/* appcenter-plugin.c generated by valac 0.56.8, the Vala compiler
 * generated from appcenter-plugin.vala, do not modify */

/*
* Copyright (c) 2017 David Hewitt <davidmhewitt@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: David Hewitt <davidmhewitt@gmail.com>
*/

#include "slingshot.h"
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>

enum  {
	SYNAPSE_APPCENTER_PLUGIN_0_PROPERTY,
	SYNAPSE_APPCENTER_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_APPCENTER_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_appcenter_plugin_properties[SYNAPSE_APPCENTER_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SynapseAppcenterPluginSearchData SynapseAppcenterPluginSearchData;
enum  {
	SYNAPSE_APPCENTER_PLUGIN_RESULT_0_PROPERTY,
	SYNAPSE_APPCENTER_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY,
	SYNAPSE_APPCENTER_PLUGIN_RESULT_NUM_PROPERTIES
};
static GParamSpec* synapse_appcenter_plugin_result_properties[SYNAPSE_APPCENTER_PLUGIN_RESULT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _SynapseAppcenterPluginPrivate {
	gboolean _enabled;
};

struct _SynapseAppcenterPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseAppcenterPlugin* self;
	SynapseQuery query;
	SynapseResultSet* result;
	GRegex* _tmp0_;
	SynapseQuery _tmp1_;
	const gchar* _tmp2_;
	SynapseResultSet* results;
	SynapseResultSet* _tmp3_;
	SynapseAppcenterPluginResult* search_result;
	SynapseQuery _tmp4_;
	const gchar* _tmp5_;
	SynapseAppcenterPluginResult* _tmp6_;
	SynapseResultSet* _tmp7_;
	SynapseAppcenterPluginResult* _tmp8_;
};

struct _SynapseAppcenterPluginResultPrivate {
	gint _default_relevancy;
	GAppInfo* appinfo;
	gchar* search_term;
};

static gint SynapseAppcenterPlugin_private_offset;
static gpointer synapse_appcenter_plugin_parent_class = NULL;
static GAppInfo* synapse_appcenter_plugin_appinfo;
static GAppInfo* synapse_appcenter_plugin_appinfo = NULL;
static GRegex* synapse_appcenter_plugin_regex;
static GRegex* synapse_appcenter_plugin_regex = NULL;
static gint SynapseAppcenterPluginResult_private_offset;
static gpointer synapse_appcenter_plugin_result_parent_class = NULL;
static SynapseActivatableIface * synapse_appcenter_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_appcenter_plugin_synapse_item_provider_parent_iface = NULL;

static void synapse_appcenter_plugin_real_activate (SynapseActivatable* base);
static void synapse_appcenter_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_appcenter_plugin_register_plugin (void);
static void _synapse_appcenter_plugin_register_plugin_synapse_plugin_register_func (void);
static gboolean synapse_appcenter_plugin_real_handles_query (SynapseItemProvider* base,
                                                      SynapseQuery* query);
static void synapse_appcenter_plugin_real_search_data_free (gpointer _data);
static void synapse_appcenter_plugin_real_search (SynapseItemProvider* base,
                                           SynapseQuery* query,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean synapse_appcenter_plugin_real_search_co (SynapseAppcenterPluginSearchData* _data_);
static void synapse_appcenter_plugin_result_real_execute (SynapseMatch* base,
                                                   SynapseMatch* match);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void synapse_appcenter_plugin_result_finalize (GObject * obj);
static GType synapse_appcenter_plugin_result_get_type_once (void);
static void _vala_synapse_appcenter_plugin_result_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_synapse_appcenter_plugin_result_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);
static void synapse_appcenter_plugin_finalize (GObject * obj);
static GType synapse_appcenter_plugin_get_type_once (void);
static void _vala_synapse_appcenter_plugin_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_synapse_appcenter_plugin_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);

static inline gpointer
synapse_appcenter_plugin_get_instance_private (SynapseAppcenterPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseAppcenterPlugin_private_offset);
}

static void
synapse_appcenter_plugin_real_activate (SynapseActivatable* base)
{
	SynapseAppcenterPlugin * self;
	self = (SynapseAppcenterPlugin*) base;
}

static void
synapse_appcenter_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseAppcenterPlugin * self;
	self = (SynapseAppcenterPlugin*) base;
}

static void
_synapse_appcenter_plugin_register_plugin_synapse_plugin_register_func (void)
{
	synapse_appcenter_plugin_register_plugin ();
}

static void
synapse_appcenter_plugin_register_plugin (void)
{
	gboolean appcenter_installed = FALSE;
	GAppInfo* _tmp0_;
	GAppInfo* _tmp1_;
	SynapseDataSinkPluginRegistry* _tmp2_;
	SynapseDataSinkPluginRegistry* _tmp3_;
	appcenter_installed = FALSE;
	_tmp0_ = g_app_info_get_default_for_type ("x-scheme-handler/appstream", FALSE);
	_g_object_unref0 (synapse_appcenter_plugin_appinfo);
	synapse_appcenter_plugin_appinfo = _tmp0_;
	_tmp1_ = synapse_appcenter_plugin_appinfo;
	if (_tmp1_ != NULL) {
		appcenter_installed = TRUE;
	}
	_tmp2_ = synapse_data_sink_plugin_registry_get_default ();
	_tmp3_ = _tmp2_;
	synapse_data_sink_plugin_registry_register_plugin (_tmp3_, SYNAPSE_TYPE_APPCENTER_PLUGIN, _ ("AppCenter"), _ ("Search for applications"), "system-software-install", _synapse_appcenter_plugin_register_plugin_synapse_plugin_register_func, appcenter_installed, _ ("AppCenter is not installed"));
	_g_object_unref0 (_tmp3_);
}

static gboolean
synapse_appcenter_plugin_real_handles_query (SynapseItemProvider* base,
                                             SynapseQuery* query)
{
	SynapseAppcenterPlugin * self;
	SynapseQuery _tmp0_;
	gboolean result;
	self = (SynapseAppcenterPlugin*) base;
	g_return_val_if_fail (query != NULL, FALSE);
	_tmp0_ = *query;
	result = (_tmp0_.query_type & SYNAPSE_QUERY_FLAGS_TEXT) == SYNAPSE_QUERY_FLAGS_TEXT;
	return result;
}

static void
synapse_appcenter_plugin_real_search_data_free (gpointer _data)
{
	SynapseAppcenterPluginSearchData* _data_;
	_data_ = _data;
	synapse_query_destroy (&_data_->query);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseAppcenterPluginSearchData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
synapse_appcenter_plugin_real_search (SynapseItemProvider* base,
                                      SynapseQuery* query,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	SynapseAppcenterPlugin * self;
	SynapseAppcenterPluginSearchData* _data_;
	SynapseAppcenterPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
	g_return_if_fail (query != NULL);
	self = (SynapseAppcenterPlugin*) base;
	_data_ = g_slice_new0 (SynapseAppcenterPluginSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, synapse_appcenter_plugin_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = *query;
	_tmp2_ = _tmp1_;
	synapse_query_copy (&_tmp2_, &_tmp3_);
	synapse_query_destroy (&_data_->query);
	_data_->query = _tmp3_;
	synapse_appcenter_plugin_real_search_co (_data_);
}

static SynapseResultSet*
synapse_appcenter_plugin_search_finish (SynapseItemProvider* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	SynapseResultSet* result;
	SynapseAppcenterPluginSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
synapse_appcenter_plugin_real_search_co (SynapseAppcenterPluginSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = synapse_appcenter_plugin_regex;
	_data_->_tmp1_ = _data_->query;
	_data_->_tmp2_ = _data_->_tmp1_.query_string;
	if (g_regex_match (_data_->_tmp0_, _data_->_tmp2_, 0, NULL)) {
		_data_->_tmp3_ = synapse_result_set_new ();
		_data_->results = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->query;
		_data_->_tmp5_ = _data_->_tmp4_.query_string;
		_data_->_tmp6_ = synapse_appcenter_plugin_result_new (_data_->_tmp5_);
		_data_->search_result = _data_->_tmp6_;
		_data_->_tmp7_ = _data_->results;
		_data_->_tmp8_ = _data_->search_result;
		synapse_result_set_add (_data_->_tmp7_, (SynapseMatch*) _data_->_tmp8_, (gint) SYNAPSE_MATCH_SCORE_INCREMENT_MINOR);
		_data_->result = _data_->results;
		_g_object_unref0 (_data_->search_result);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->result = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

SynapseAppcenterPlugin*
synapse_appcenter_plugin_construct (GType object_type)
{
	SynapseAppcenterPlugin * self = NULL;
	self = (SynapseAppcenterPlugin*) g_object_new (object_type, NULL);
	return self;
}

SynapseAppcenterPlugin*
synapse_appcenter_plugin_new (void)
{
	return synapse_appcenter_plugin_construct (SYNAPSE_TYPE_APPCENTER_PLUGIN);
}

static gboolean
synapse_appcenter_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseAppcenterPlugin* self;
	self = (SynapseAppcenterPlugin*) base;
	result = self->priv->_enabled;
	return result;
}

static void
synapse_appcenter_plugin_real_set_enabled (SynapseActivatable* base,
                                           gboolean value)
{
	SynapseAppcenterPlugin* self;
	gboolean old_value;
	self = (SynapseAppcenterPlugin*) base;
	old_value = synapse_appcenter_plugin_real_get_enabled (base);
	if (old_value != value) {
		self->priv->_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_appcenter_plugin_properties[SYNAPSE_APPCENTER_PLUGIN_ENABLED_PROPERTY]);
	}
}

static inline gpointer
synapse_appcenter_plugin_result_get_instance_private (SynapseAppcenterPluginResult* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseAppcenterPluginResult_private_offset);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

SynapseAppcenterPluginResult*
synapse_appcenter_plugin_result_construct (GType object_type,
                                           const gchar* search)
{
	SynapseAppcenterPluginResult * self = NULL;
	gchar* _tmp0_;
	gchar* _title = NULL;
	gchar* _tmp1_;
	gchar* _icon_name = NULL;
	gchar* _tmp2_;
	GAppInfo* _tmp3_;
	GAppInfo* _tmp4_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	g_return_val_if_fail (search != NULL, NULL);
	self = (SynapseAppcenterPluginResult*) synapse_match_construct (object_type);
	_tmp0_ = g_strdup (search);
	_g_free0 (self->priv->search_term);
	self->priv->search_term = _tmp0_;
	_tmp1_ = g_strdup ("");
	_title = _tmp1_;
	_tmp2_ = g_strdup ("");
	_icon_name = _tmp2_;
	_tmp3_ = g_app_info_get_default_for_type ("x-scheme-handler/appstream", FALSE);
	_g_object_unref0 (self->priv->appinfo);
	self->priv->appinfo = _tmp3_;
	_tmp4_ = self->priv->appinfo;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GAppInfo* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		GAppInfo* _tmp11_;
		GIcon* _tmp12_;
		gchar* _tmp13_;
		_tmp5_ = self->priv->search_term;
		_tmp6_ = string_strip (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->appinfo;
		_tmp9_ = g_app_info_get_display_name (_tmp8_);
		_tmp10_ = g_strdup_printf (_ ("Search for %s in %s"), _tmp7_, _tmp9_);
		_g_free0 (_title);
		_title = _tmp10_;
		_g_free0 (_tmp7_);
		_tmp11_ = self->priv->appinfo;
		_tmp12_ = g_app_info_get_icon (_tmp11_);
		_tmp13_ = g_icon_to_string (_tmp12_);
		_g_free0 (_icon_name);
		_icon_name = _tmp13_;
	}
	_tmp14_ = _title;
	synapse_match_set_title ((SynapseMatch*) self, _tmp14_);
	_tmp15_ = _icon_name;
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp15_);
	synapse_match_set_description ((SynapseMatch*) self, _ ("Search the app store"));
	synapse_match_set_has_thumbnail ((SynapseMatch*) self, FALSE);
	synapse_match_set_match_type ((SynapseMatch*) self, SYNAPSE_MATCH_TYPE_ACTION);
	_g_free0 (_icon_name);
	_g_free0 (_title);
	return self;
}

SynapseAppcenterPluginResult*
synapse_appcenter_plugin_result_new (const gchar* search)
{
	return synapse_appcenter_plugin_result_construct (SYNAPSE_APPCENTER_PLUGIN_TYPE_RESULT, search);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
synapse_appcenter_plugin_result_real_execute (SynapseMatch* base,
                                              SynapseMatch* match)
{
	SynapseAppcenterPluginResult * self;
	GAppInfo* _tmp0_;
	GList* list = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = (SynapseAppcenterPluginResult*) base;
	_tmp0_ = self->priv->appinfo;
	if (_tmp0_ == NULL) {
		return;
	}
	list = NULL;
	_tmp1_ = self->priv->search_term;
	_tmp2_ = g_uri_escape_string (_tmp1_, NULL, TRUE);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("appstream://", _tmp3_, NULL);
	list = g_list_append (list, _tmp4_);
	_g_free0 (_tmp3_);
	{
		GAppInfo* _tmp5_;
		GList* _tmp6_;
		_tmp5_ = self->priv->appinfo;
		_tmp6_ = list;
		g_app_info_launch_uris (_tmp5_, _tmp6_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("appcenter-plugin.vala:70: %s\n", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		(list == NULL) ? NULL : (list = (_g_list_free__g_free0_ (list), NULL));
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	(list == NULL) ? NULL : (list = (_g_list_free__g_free0_ (list), NULL));
}

gint
synapse_appcenter_plugin_result_get_default_relevancy (SynapseAppcenterPluginResult* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_default_relevancy;
	return result;
}

void
synapse_appcenter_plugin_result_set_default_relevancy (SynapseAppcenterPluginResult* self,
                                                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_appcenter_plugin_result_get_default_relevancy (self);
	if (old_value != value) {
		self->priv->_default_relevancy = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_appcenter_plugin_result_properties[SYNAPSE_APPCENTER_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY]);
	}
}

static void
synapse_appcenter_plugin_result_class_init (SynapseAppcenterPluginResultClass * klass,
                                            gpointer klass_data)
{
	synapse_appcenter_plugin_result_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseAppcenterPluginResult_private_offset);
	((SynapseMatchClass *) klass)->execute = (void (*) (SynapseMatch*, SynapseMatch*)) synapse_appcenter_plugin_result_real_execute;
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_appcenter_plugin_result_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_appcenter_plugin_result_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_appcenter_plugin_result_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_APPCENTER_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY, synapse_appcenter_plugin_result_properties[SYNAPSE_APPCENTER_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY] = g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
synapse_appcenter_plugin_result_instance_init (SynapseAppcenterPluginResult * self,
                                               gpointer klass)
{
	self->priv = synapse_appcenter_plugin_result_get_instance_private (self);
	self->priv->_default_relevancy = 0;
}

static void
synapse_appcenter_plugin_result_finalize (GObject * obj)
{
	SynapseAppcenterPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_APPCENTER_PLUGIN_TYPE_RESULT, SynapseAppcenterPluginResult);
	_g_object_unref0 (self->priv->appinfo);
	_g_free0 (self->priv->search_term);
	G_OBJECT_CLASS (synapse_appcenter_plugin_result_parent_class)->finalize (obj);
}

static GType
synapse_appcenter_plugin_result_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseAppcenterPluginResultClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_appcenter_plugin_result_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseAppcenterPluginResult), 0, (GInstanceInitFunc) synapse_appcenter_plugin_result_instance_init, NULL };
	GType synapse_appcenter_plugin_result_type_id;
	synapse_appcenter_plugin_result_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseAppcenterPluginResult", &g_define_type_info, 0);
	SynapseAppcenterPluginResult_private_offset = g_type_add_instance_private (synapse_appcenter_plugin_result_type_id, sizeof (SynapseAppcenterPluginResultPrivate));
	return synapse_appcenter_plugin_result_type_id;
}

GType
synapse_appcenter_plugin_result_get_type (void)
{
	static volatile gsize synapse_appcenter_plugin_result_type_id__once = 0;
	if (g_once_init_enter (&synapse_appcenter_plugin_result_type_id__once)) {
		GType synapse_appcenter_plugin_result_type_id;
		synapse_appcenter_plugin_result_type_id = synapse_appcenter_plugin_result_get_type_once ();
		g_once_init_leave (&synapse_appcenter_plugin_result_type_id__once, synapse_appcenter_plugin_result_type_id);
	}
	return synapse_appcenter_plugin_result_type_id__once;
}

static void
_vala_synapse_appcenter_plugin_result_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	SynapseAppcenterPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_APPCENTER_PLUGIN_TYPE_RESULT, SynapseAppcenterPluginResult);
	switch (property_id) {
		case SYNAPSE_APPCENTER_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY:
		g_value_set_int (value, synapse_appcenter_plugin_result_get_default_relevancy (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_synapse_appcenter_plugin_result_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	SynapseAppcenterPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_APPCENTER_PLUGIN_TYPE_RESULT, SynapseAppcenterPluginResult);
	switch (property_id) {
		case SYNAPSE_APPCENTER_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY:
		synapse_appcenter_plugin_result_set_default_relevancy (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
synapse_appcenter_plugin_class_init (SynapseAppcenterPluginClass * klass,
                                     gpointer klass_data)
{
	GError* _inner_error0_ = NULL;
	synapse_appcenter_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseAppcenterPlugin_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_appcenter_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_appcenter_plugin_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_appcenter_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_APPCENTER_PLUGIN_ENABLED_PROPERTY, synapse_appcenter_plugin_properties[SYNAPSE_APPCENTER_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	synapse_appcenter_plugin_register_plugin ();
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		_tmp1_ = g_regex_new ("^(?=\\pL).{2,}$", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (synapse_appcenter_plugin_regex);
		synapse_appcenter_plugin_regex = _tmp2_;
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_error ("appcenter-plugin.vala:103: Error creating regexp.");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
}

static void
synapse_appcenter_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                             gpointer iface_data)
{
	synapse_appcenter_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*) (SynapseActivatable*)) synapse_appcenter_plugin_real_activate;
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_appcenter_plugin_real_deactivate;
	iface->get_enabled = synapse_appcenter_plugin_real_get_enabled;
	iface->set_enabled = synapse_appcenter_plugin_real_set_enabled;
}

static void
synapse_appcenter_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                               gpointer iface_data)
{
	synapse_appcenter_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->handles_query = (gboolean (*) (SynapseItemProvider*, SynapseQuery*)) synapse_appcenter_plugin_real_handles_query;
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_appcenter_plugin_real_search;
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_appcenter_plugin_search_finish;
}

static void
synapse_appcenter_plugin_instance_init (SynapseAppcenterPlugin * self,
                                        gpointer klass)
{
	self->priv = synapse_appcenter_plugin_get_instance_private (self);
	self->priv->_enabled = TRUE;
}

static void
synapse_appcenter_plugin_finalize (GObject * obj)
{
	SynapseAppcenterPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_APPCENTER_PLUGIN, SynapseAppcenterPlugin);
	G_OBJECT_CLASS (synapse_appcenter_plugin_parent_class)->finalize (obj);
}

static GType
synapse_appcenter_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseAppcenterPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_appcenter_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseAppcenterPlugin), 0, (GInstanceInitFunc) synapse_appcenter_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_appcenter_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_appcenter_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_appcenter_plugin_type_id;
	synapse_appcenter_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseAppcenterPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_appcenter_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_appcenter_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseAppcenterPlugin_private_offset = g_type_add_instance_private (synapse_appcenter_plugin_type_id, sizeof (SynapseAppcenterPluginPrivate));
	return synapse_appcenter_plugin_type_id;
}

GType
synapse_appcenter_plugin_get_type (void)
{
	static volatile gsize synapse_appcenter_plugin_type_id__once = 0;
	if (g_once_init_enter (&synapse_appcenter_plugin_type_id__once)) {
		GType synapse_appcenter_plugin_type_id;
		synapse_appcenter_plugin_type_id = synapse_appcenter_plugin_get_type_once ();
		g_once_init_leave (&synapse_appcenter_plugin_type_id__once, synapse_appcenter_plugin_type_id);
	}
	return synapse_appcenter_plugin_type_id__once;
}

static void
_vala_synapse_appcenter_plugin_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	SynapseAppcenterPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_APPCENTER_PLUGIN, SynapseAppcenterPlugin);
	switch (property_id) {
		case SYNAPSE_APPCENTER_PLUGIN_ENABLED_PROPERTY:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_synapse_appcenter_plugin_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	SynapseAppcenterPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_APPCENTER_PLUGIN, SynapseAppcenterPlugin);
	switch (property_id) {
		case SYNAPSE_APPCENTER_PLUGIN_ENABLED_PROPERTY:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

