/* data-sink.c generated by valac 0.56.8, the Vala compiler
 * generated from data-sink.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include "slingshot.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#define SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION (synapse_data_sink_data_sink_configuration_get_type ())
#define SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION, SynapseDataSinkDataSinkConfiguration))
#define SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION, SynapseDataSinkDataSinkConfigurationClass))
#define SYNAPSE_DATA_SINK_IS_DATA_SINK_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION))
#define SYNAPSE_DATA_SINK_IS_DATA_SINK_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION))
#define SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION, SynapseDataSinkDataSinkConfigurationClass))

typedef struct _SynapseDataSinkDataSinkConfiguration SynapseDataSinkDataSinkConfiguration;
typedef struct _SynapseDataSinkDataSinkConfigurationClass SynapseDataSinkDataSinkConfigurationClass;
enum  {
	SYNAPSE_DATA_SINK_0_PROPERTY,
	SYNAPSE_DATA_SINK_HAS_EMPTY_HANDLERS_PROPERTY,
	SYNAPSE_DATA_SINK_HAS_UNKNOWN_HANDLERS_PROPERTY,
	SYNAPSE_DATA_SINK_NUM_PROPERTIES
};
static GParamSpec* synapse_data_sink_properties[SYNAPSE_DATA_SINK_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block12Data Block12Data;
typedef struct _SynapseDataSinkInitializeCachesData SynapseDataSinkInitializeCachesData;
#define _synapse_data_sink_plugin_registry_plugin_info_unref0(var) ((var == NULL) ? NULL : (var = (synapse_data_sink_plugin_registry_plugin_info_unref (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block13Data Block13Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseDataSinkSearchData SynapseDataSinkSearchData;
enum  {
	SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_0_PROPERTY,
	SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_NUM_PROPERTIES
};
static GParamSpec* synapse_data_sink_plugin_registry_properties[SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_NUM_PROPERTIES];
typedef struct _SynapseDataSinkPluginRegistryParamSpecPluginInfo SynapseDataSinkPluginRegistryParamSpecPluginInfo;
typedef struct _SynapseDataSinkDataSinkConfigurationPrivate SynapseDataSinkDataSinkConfigurationPrivate;
enum  {
	SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_0_PROPERTY,
	SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_DISABLED_PLUGINS_PROPERTY,
	SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_NUM_PROPERTIES
};
static GParamSpec* synapse_data_sink_data_sink_configuration_properties[SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_NUM_PROPERTIES];
enum  {
	SYNAPSE_DATA_SINK_PLUGIN_REGISTERED_SIGNAL,
	SYNAPSE_DATA_SINK_SEARCH_DONE_SIGNAL,
	SYNAPSE_DATA_SINK_NUM_SIGNALS
};
static guint synapse_data_sink_signals[SYNAPSE_DATA_SINK_NUM_SIGNALS] = {0};

struct _SynapseDataSinkPrivate {
	SynapseDataSinkDataSinkConfiguration* config;
	GeeSet* item_plugins;
	GeeSet* action_plugins;
	guint query_id;
	SynapseDBusService* dbus_name_cache;
	SynapseDesktopFileService* desktop_file_service;
	SynapseDataSinkPluginRegistry* registry;
	SynapseRelevancyService* relevancy_service;
	GType* plugin_types;
	gint plugin_types_length1;
	gint _plugin_types_size_;
	gboolean _has_empty_handlers;
	gboolean _has_unknown_handlers;
	gboolean plugins_loaded;
};

struct _Block12Data {
	int _ref_count_;
	SynapseDataSink* self;
	gint initialized_components;
	gint num_components;
	gpointer _async_data_;
};

struct _SynapseDataSinkInitializeCachesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDataSink* self;
	Block12Data* _data12_;
	SynapseDBusService* _tmp0_;
	SynapseDBusService* _tmp1_;
	SynapseDesktopFileService* _tmp2_;
	SynapseDesktopFileService* _tmp3_;
	SynapseDesktopFileService* _tmp4_;
};

struct _Block13Data {
	int _ref_count_;
	SynapseDataSink* self;
	SynapseQuery q;
	GList* cancellables;
	SynapseResultSet* current_result_set;
	gint search_size;
	gboolean waiting;
	gpointer _async_data_;
};

struct _SynapseDataSinkSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDataSink* self;
	gchar* query;
	SynapseQueryFlags flags;
	SynapseResultSet* dest_result_set;
	GCancellable* cancellable;
	GeeList* result;
	Block13Data* _data13_;
	gboolean _tmp0_;
	GError* _tmp1_;
	guint _tmp2_;
	const gchar* _tmp3_;
	SynapseQueryFlags _tmp4_;
	gchar* query_stripped;
	gchar* _tmp5_;
	SynapseResultSet* _tmp6_;
	SynapseResultSet* _tmp7_;
	SynapseResultSet* _tmp8_;
	SynapseResultSet* _tmp9_;
	GeeSet* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GeeIterator* _data_plugin_it;
	GeeSet* _tmp13_;
	GeeIterator* _tmp14_;
	GeeIterator* _tmp15_;
	SynapseItemProvider* data_plugin;
	GeeIterator* _tmp16_;
	gpointer _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	SynapseItemProvider* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	SynapseItemProvider* _tmp24_;
	SynapseItemProvider* _tmp25_;
	SynapseQuery _tmp26_;
	gboolean skip;
	gint _tmp27_;
	GCancellable* c;
	GCancellable* _tmp28_;
	GCancellable* _tmp29_;
	GCancellable* _tmp30_;
	GCancellable* _tmp31_;
	GCancellable* _tmp32_;
	SynapseItemProvider* _tmp33_;
	SynapseQuery _tmp34_;
	gboolean _tmp35_;
	GError* _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp38_;
	const gchar* _tmp39_;
	SynapseDefaultMatch* unknown_match;
	SynapseDefaultMatch* _tmp40_;
	gboolean add_to_rs;
	gboolean _tmp41_;
	GeeList* unknown_match_actions;
	SynapseDefaultMatch* _tmp42_;
	GeeList* _tmp43_;
	GeeList* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	SynapseResultSet* _tmp47_;
	SynapseDefaultMatch* _tmp48_;
	SynapseResultSet* _tmp49_;
	GeeList* _tmp50_;
	GError* _inner_error0_;
};

struct _SynapseDataSinkPluginRegistryPrivate {
	GeeList* plugins;
};

struct _SynapseDataSinkPluginRegistryParamSpecPluginInfo {
	GParamSpec parent_instance;
};

struct _SynapseDataSinkDataSinkConfiguration {
	SynapseConfigObject parent_instance;
	SynapseDataSinkDataSinkConfigurationPrivate * priv;
};

struct _SynapseDataSinkDataSinkConfigurationClass {
	SynapseConfigObjectClass parent_class;
};

struct _SynapseDataSinkDataSinkConfigurationPrivate {
	gchar** _disabled_plugins;
	gint _disabled_plugins_length1;
	gint __disabled_plugins_size_;
};

static gint SynapseDataSink_private_offset;
static gpointer synapse_data_sink_parent_class = NULL;
static gint SynapseDataSinkPluginRegistry_private_offset;
static gpointer synapse_data_sink_plugin_registry_parent_class = NULL;
SynapseDataSinkPluginRegistry* synapse_data_sink_plugin_registry_instance = NULL;
static gpointer synapse_data_sink_plugin_registry_plugin_info_parent_class = NULL;
static gint SynapseDataSinkDataSinkConfiguration_private_offset;
static gpointer synapse_data_sink_data_sink_configuration_parent_class = NULL;
static SynapseSearchProviderIface * synapse_data_sink_synapse_search_provider_parent_iface = NULL;

static GType synapse_search_provider_get_type_once (void);
static GType synapse_data_sink_data_sink_configuration_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void synapse_data_sink_initialize_caches_data_free (gpointer _data);
static void synapse_data_sink_initialize_caches (SynapseDataSink* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void synapse_data_sink_initialize_caches_finish (SynapseDataSink* self,
                                                 GAsyncResult* _res_);
static gboolean synapse_data_sink_initialize_caches_co (SynapseDataSinkInitializeCachesData* _data_);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static gboolean _synapse_data_sink_initialize_caches_co_gsource_func (gpointer self);
static void __lambda9_ (Block12Data* _data12_);
static void ___lambda9__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void synapse_data_sink_check_plugins (SynapseDataSink* self);
static void _synapse_data_sink_check_plugins_synapse_desktop_file_service_reload_done (SynapseDesktopFileService* _sender,
                                                                                gpointer self);
static void __lambda10_ (Block12Data* _data12_);
static void ___lambda10__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gboolean __lambda11_ (SynapseDataSink* self);
static void synapse_data_sink_load_plugins (SynapseDataSink* self);
static gboolean ___lambda11__gsource_func (gpointer self);
static void _vala_array_add4 (SynapsePluginRegisterFunc* * array,
                       gint* length,
                       gint* size,
                       SynapsePluginRegisterFunc value);
static void synapse_data_sink_update_has_unknown_handlers (SynapseDataSink* self);
static void synapse_data_sink_update_has_empty_handlers (SynapseDataSink* self);
static GObject* synapse_data_sink_create_plugin (SynapseDataSink* self,
                                          GType t);
static gboolean synapse_data_sink_data_sink_configuration_is_plugin_enabled (SynapseDataSinkDataSinkConfiguration* self,
                                                                      GType t);
static gboolean _vala_g_type_array_contains (GType * stack,
                                      gssize stack_length,
                                      const GType needle);
static void _vala_array_add5 (GType* * array,
                       gint* length,
                       gint* size,
                       GType value);
static void synapse_data_sink_data_sink_configuration_set_plugin_enabled (SynapseDataSinkDataSinkConfiguration* self,
                                                                   GType t,
                                                                   gboolean enabled);
static void synapse_data_sink_real_search_data_free (gpointer _data);
static void synapse_data_sink_real_search (SynapseSearchProvider* base,
                                    const gchar* query,
                                    SynapseQueryFlags flags,
                                    SynapseResultSet* dest_result_set,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static gboolean synapse_data_sink_real_search_co (SynapseDataSinkSearchData* _data_);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void block13_data_unref (void * _userdata_);
static gboolean _synapse_data_sink_real_search_co_gsource_func (gpointer self);
static void ____lambda13_ (Block13Data* _data13_,
                    GObject* src_obj,
                    GAsyncResult* res);
static void _____lambda13__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void ___lambda14_ (Block13Data* _data13_);
static void ____lambda14__gfunc (gconstpointer data,
                          gpointer self);
static void g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void synapse_data_sink_plugin_registry_plugin_info_finalize (SynapseDataSinkPluginRegistryPluginInfo * obj);
static GType synapse_data_sink_plugin_registry_plugin_info_get_type_once (void);
static GObject * synapse_data_sink_plugin_registry_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties);
static void synapse_data_sink_plugin_registry_finalize (GObject * obj);
static GType synapse_data_sink_plugin_registry_get_type_once (void);
static void synapse_data_sink_data_sink_configuration_enable_plugin (SynapseDataSinkDataSinkConfiguration* self,
                                                              const gchar* name);
static void synapse_data_sink_data_sink_configuration_disable_plugin (SynapseDataSinkDataSinkConfiguration* self,
                                                               const gchar* name);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static SynapseDataSinkDataSinkConfiguration* synapse_data_sink_data_sink_configuration_new (void);
static SynapseDataSinkDataSinkConfiguration* synapse_data_sink_data_sink_configuration_construct (GType object_type);
static gchar** synapse_data_sink_data_sink_configuration_get_disabled_plugins (SynapseDataSinkDataSinkConfiguration* self,
                                                                        gint* result_length1);
static void synapse_data_sink_data_sink_configuration_set_disabled_plugins (SynapseDataSinkDataSinkConfiguration* self,
                                                                     gchar** value,
                                                                     gint value_length1);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static void synapse_data_sink_data_sink_configuration_finalize (GObject * obj);
static GType synapse_data_sink_data_sink_configuration_get_type_once (void);
static void _vala_synapse_data_sink_data_sink_configuration_get_property (GObject * object,
                                                                   guint property_id,
                                                                   GValue * value,
                                                                   GParamSpec * pspec);
static void _vala_synapse_data_sink_data_sink_configuration_set_property (GObject * object,
                                                                   guint property_id,
                                                                   const GValue * value,
                                                                   GParamSpec * pspec);
static GObject * synapse_data_sink_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void synapse_data_sink_finalize (GObject * obj);
static GType synapse_data_sink_get_type_once (void);
static void _vala_synapse_data_sink_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_synapse_data_sink_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

GQuark
synapse_search_error_quark (void)
{
	return g_quark_from_static_string ("synapse-search-error-quark");
}

static GType
synapse_search_error_get_type_once (void)
{
	static const GEnumValue values[] = {{SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED, "SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED", "search-cancelled"}, {SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR, "SYNAPSE_SEARCH_ERROR_UNKNOWN_ERROR", "unknown-error"}, {0, NULL, NULL}};
	GType synapse_search_error_type_id;
	synapse_search_error_type_id = g_enum_register_static ("SynapseSearchError", values);
	return synapse_search_error_type_id;
}

GType
synapse_search_error_get_type (void)
{
	static volatile gsize synapse_search_error_type_id__once = 0;
	if (g_once_init_enter (&synapse_search_error_type_id__once)) {
		GType synapse_search_error_type_id;
		synapse_search_error_type_id = synapse_search_error_get_type_once ();
		g_once_init_leave (&synapse_search_error_type_id__once, synapse_search_error_type_id);
	}
	return synapse_search_error_type_id__once;
}

void
synapse_search_provider_search (SynapseSearchProvider* self,
                                const gchar* query,
                                SynapseQueryFlags flags,
                                SynapseResultSet* dest_result_set,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	SynapseSearchProviderIface* _iface_;
	_iface_ = SYNAPSE_SEARCH_PROVIDER_GET_INTERFACE (self);
	if (_iface_->search) {
		_iface_->search (self, query, flags, dest_result_set, cancellable, _callback_, _user_data_);
	}
}

GeeList*
synapse_search_provider_search_finish (SynapseSearchProvider* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	SynapseSearchProviderIface* _iface_;
	_iface_ = SYNAPSE_SEARCH_PROVIDER_GET_INTERFACE (self);
	if (_iface_->search_finish) {
		return _iface_->search_finish (self, _res_, error);
	}
	return NULL;
}

static void
synapse_search_provider_default_init (SynapseSearchProviderIface * iface,
                                      gpointer iface_data)
{
}

static GType
synapse_search_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseSearchProviderIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_search_provider_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType synapse_search_provider_type_id;
	synapse_search_provider_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseSearchProvider", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (synapse_search_provider_type_id, G_TYPE_OBJECT);
	return synapse_search_provider_type_id;
}

GType
synapse_search_provider_get_type (void)
{
	static volatile gsize synapse_search_provider_type_id__once = 0;
	if (g_once_init_enter (&synapse_search_provider_type_id__once)) {
		GType synapse_search_provider_type_id;
		synapse_search_provider_type_id = synapse_search_provider_get_type_once ();
		g_once_init_leave (&synapse_search_provider_type_id__once, synapse_search_provider_type_id);
	}
	return synapse_search_provider_type_id__once;
}

static inline gpointer
synapse_data_sink_get_instance_private (SynapseDataSink* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDataSink_private_offset);
}

SynapseDataSink*
synapse_data_sink_construct (GType object_type)
{
	SynapseDataSink * self = NULL;
	self = (SynapseDataSink*) g_object_new (object_type, NULL);
	return self;
}

SynapseDataSink*
synapse_data_sink_new (void)
{
	return synapse_data_sink_construct (SYNAPSE_TYPE_DATA_SINK);
}

static void
synapse_data_sink_initialize_caches_data_free (gpointer _data)
{
	SynapseDataSinkInitializeCachesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseDataSinkInitializeCachesData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
synapse_data_sink_initialize_caches (SynapseDataSink* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	SynapseDataSinkInitializeCachesData* _data_;
	SynapseDataSink* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SynapseDataSinkInitializeCachesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, synapse_data_sink_initialize_caches_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	synapse_data_sink_initialize_caches_co (_data_);
}

static void
synapse_data_sink_initialize_caches_finish (SynapseDataSink* self,
                                            GAsyncResult* _res_)
{
	SynapseDataSinkInitializeCachesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		SynapseDataSink* self;
		self = _data12_->self;
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static gboolean
_synapse_data_sink_initialize_caches_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_data_sink_initialize_caches_co (self);
	return result;
}

static void
__lambda9_ (Block12Data* _data12_)
{
	SynapseDataSink* self;
	gint _tmp0_;
	self = _data12_->self;
	_tmp0_ = _data12_->initialized_components;
	_data12_->initialized_components = _tmp0_ + 1;
	if (_data12_->initialized_components >= _data12_->num_components) {
		synapse_data_sink_initialize_caches_co (_data12_->_async_data_);
	}
}

static void
___lambda9__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda9_ (self);
	block12_data_unref (self);
}

static void
_synapse_data_sink_check_plugins_synapse_desktop_file_service_reload_done (SynapseDesktopFileService* _sender,
                                                                           gpointer self)
{
	synapse_data_sink_check_plugins ((SynapseDataSink*) self);
}

static void
__lambda10_ (Block12Data* _data12_)
{
	SynapseDataSink* self;
	gint _tmp0_;
	self = _data12_->self;
	_tmp0_ = _data12_->initialized_components;
	_data12_->initialized_components = _tmp0_ + 1;
	if (_data12_->initialized_components >= _data12_->num_components) {
		synapse_data_sink_initialize_caches_co (_data12_->_async_data_);
	}
}

static void
___lambda10__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda10_ (self);
	block12_data_unref (self);
}

static gboolean
__lambda11_ (SynapseDataSink* self)
{
	gboolean result;
	synapse_data_sink_load_plugins (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda11__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda11_ ((SynapseDataSink*) self);
	return result;
}

static gboolean
synapse_data_sink_initialize_caches_co (SynapseDataSinkInitializeCachesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data12_ = g_slice_new0 (Block12Data);
	_data_->_data12_->_ref_count_ = 1;
	_data_->_data12_->self = g_object_ref (_data_->self);
	_data_->_data12_->_async_data_ = _data_;
	g_idle_add_full (G_PRIORITY_LOW, _synapse_data_sink_initialize_caches_co_gsource_func, _data_, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_data12_->initialized_components = 0;
	_data_->_data12_->num_components = 2;
	_data_->_tmp0_ = synapse_dbus_service_get_default ();
	_g_object_unref0 (_data_->self->priv->dbus_name_cache);
	_data_->self->priv->dbus_name_cache = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->dbus_name_cache;
	synapse_dbus_service_initialize (_data_->_tmp1_, ___lambda9__gasync_ready_callback, block12_data_ref (_data_->_data12_));
	_data_->_tmp2_ = synapse_desktop_file_service_get_default ();
	_g_object_unref0 (_data_->self->priv->desktop_file_service);
	_data_->self->priv->desktop_file_service = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->desktop_file_service;
	g_signal_connect_object (_data_->_tmp3_, "reload-done", (GCallback) _synapse_data_sink_check_plugins_synapse_desktop_file_service_reload_done, _data_->self, 0);
	_data_->_tmp4_ = _data_->self->priv->desktop_file_service;
	synapse_desktop_file_service_initialize (_data_->_tmp4_, ___lambda10__gasync_ready_callback, block12_data_ref (_data_->_data12_));
	_data_->_state_ = 2;
	return FALSE;
	_state_2:
	;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda11__gsource_func, g_object_ref (_data_->self), g_object_unref);
	block12_data_unref (_data_->_data12_);
	_data_->_data12_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_vala_array_add4 (SynapsePluginRegisterFunc* * array,
                  gint* length,
                  gint* size,
                  SynapsePluginRegisterFunc value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (SynapsePluginRegisterFunc, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
synapse_data_sink_check_plugins (SynapseDataSink* self)
{
	SynapsePluginRegisterFunc* reg_funcs = NULL;
	SynapsePluginRegisterFunc* _tmp0_;
	gint reg_funcs_length1;
	gint _reg_funcs_size_;
	SynapsePluginRegisterFunc* _tmp12_;
	gint _tmp12__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (SynapsePluginRegisterFunc, 0);
	reg_funcs = _tmp0_;
	reg_funcs_length1 = 0;
	_reg_funcs_size_ = reg_funcs_length1;
	{
		GeeList* _pi_list = NULL;
		SynapseDataSinkPluginRegistry* _tmp1_;
		GeeList* _tmp2_;
		gint _pi_size = 0;
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _pi_index = 0;
		_tmp1_ = self->priv->registry;
		_tmp2_ = synapse_data_sink_plugin_registry_get_plugins (_tmp1_);
		_pi_list = _tmp2_;
		_tmp3_ = _pi_list;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_pi_size = _tmp5_;
		_pi_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			SynapseDataSinkPluginRegistryPluginInfo* pi = NULL;
			GeeList* _tmp8_;
			gpointer _tmp9_;
			SynapseDataSinkPluginRegistryPluginInfo* _tmp10_;
			SynapsePluginRegisterFunc _tmp11_;
			_pi_index = _pi_index + 1;
			_tmp6_ = _pi_index;
			_tmp7_ = _pi_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _pi_list;
			_tmp9_ = gee_list_get (_tmp8_, _pi_index);
			pi = (SynapseDataSinkPluginRegistryPluginInfo*) _tmp9_;
			_tmp10_ = pi;
			_tmp11_ = _tmp10_->register_func;
			_vala_array_add4 (&reg_funcs, &reg_funcs_length1, &_reg_funcs_size_, _tmp11_);
			_synapse_data_sink_plugin_registry_plugin_info_unref0 (pi);
		}
		_g_object_unref0 (_pi_list);
	}
	_tmp12_ = reg_funcs;
	_tmp12__length1 = reg_funcs_length1;
	{
		SynapsePluginRegisterFunc* func_collection = NULL;
		gint func_collection_length1 = 0;
		gint _func_collection_size_ = 0;
		gint func_it = 0;
		func_collection = _tmp12_;
		func_collection_length1 = _tmp12__length1;
		for (func_it = 0; func_it < func_collection_length1; func_it = func_it + 1) {
			SynapsePluginRegisterFunc func = NULL;
			func = func_collection[func_it];
			{
				SynapsePluginRegisterFunc _tmp13_;
				_tmp13_ = func;
				_tmp13_ ();
			}
		}
	}
	reg_funcs = (g_free (reg_funcs), NULL);
}

void
synapse_data_sink_register_plugin (SynapseDataSink* self,
                                   GObject* plugin)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin != NULL);
	if (SYNAPSE_IS_ACTION_PROVIDER (plugin)) {
		SynapseActionProvider* action_plugin = NULL;
		SynapseActionProvider* _tmp0_;
		GeeSet* _tmp1_;
		SynapseActionProvider* _tmp2_;
		gboolean _tmp3_;
		SynapseActionProvider* _tmp4_;
		_tmp0_ = _g_object_ref0 (SYNAPSE_IS_ACTION_PROVIDER (plugin) ? ((SynapseActionProvider*) plugin) : NULL);
		action_plugin = _tmp0_;
		_tmp1_ = self->priv->action_plugins;
		_tmp2_ = action_plugin;
		gee_collection_add ((GeeCollection*) _tmp1_, _tmp2_);
		_tmp3_ = self->priv->_has_unknown_handlers;
		_tmp4_ = action_plugin;
		synapse_data_sink_set_has_unknown_handlers (self, _tmp3_ | synapse_action_provider_handles_unknown (_tmp4_));
		_g_object_unref0 (action_plugin);
	}
	if (SYNAPSE_IS_ITEM_PROVIDER (plugin)) {
		SynapseItemProvider* item_plugin = NULL;
		SynapseItemProvider* _tmp5_;
		GeeSet* _tmp6_;
		SynapseItemProvider* _tmp7_;
		gboolean _tmp8_;
		SynapseItemProvider* _tmp9_;
		_tmp5_ = _g_object_ref0 (SYNAPSE_IS_ITEM_PROVIDER (plugin) ? ((SynapseItemProvider*) plugin) : NULL);
		item_plugin = _tmp5_;
		_tmp6_ = self->priv->item_plugins;
		_tmp7_ = item_plugin;
		gee_collection_add ((GeeCollection*) _tmp6_, _tmp7_);
		_tmp8_ = self->priv->_has_empty_handlers;
		_tmp9_ = item_plugin;
		synapse_data_sink_set_has_empty_handlers (self, _tmp8_ | synapse_item_provider_handles_empty_query (_tmp9_));
		_g_object_unref0 (item_plugin);
	}
	g_signal_emit (self, synapse_data_sink_signals[SYNAPSE_DATA_SINK_PLUGIN_REGISTERED_SIGNAL], 0, plugin);
}

static void
synapse_data_sink_update_has_unknown_handlers (SynapseDataSink* self)
{
	gboolean tmp = FALSE;
	g_return_if_fail (self != NULL);
	tmp = FALSE;
	{
		GeeIterator* _action_it = NULL;
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->action_plugins;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_action_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			SynapseActionProvider* action = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			gboolean _tmp5_ = FALSE;
			SynapseActionProvider* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp2_ = _action_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _action_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			action = (SynapseActionProvider*) _tmp4_;
			_tmp6_ = action;
			_tmp7_ = synapse_activatable_get_enabled ((SynapseActivatable*) _tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_) {
				SynapseActionProvider* _tmp9_;
				_tmp9_ = action;
				_tmp5_ = synapse_action_provider_handles_unknown (_tmp9_);
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				tmp = TRUE;
				_g_object_unref0 (action);
				break;
			}
			_g_object_unref0 (action);
		}
		_g_object_unref0 (_action_it);
	}
	synapse_data_sink_set_has_unknown_handlers (self, tmp);
}

static void
synapse_data_sink_update_has_empty_handlers (SynapseDataSink* self)
{
	gboolean tmp = FALSE;
	g_return_if_fail (self != NULL);
	tmp = FALSE;
	{
		GeeIterator* _item_plugin_it = NULL;
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->item_plugins;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_item_plugin_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			SynapseItemProvider* item_plugin = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			gboolean _tmp5_ = FALSE;
			SynapseItemProvider* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp2_ = _item_plugin_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _item_plugin_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			item_plugin = (SynapseItemProvider*) _tmp4_;
			_tmp6_ = item_plugin;
			_tmp7_ = synapse_activatable_get_enabled ((SynapseActivatable*) _tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_) {
				SynapseItemProvider* _tmp9_;
				_tmp9_ = item_plugin;
				_tmp5_ = synapse_item_provider_handles_empty_query (_tmp9_);
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				tmp = TRUE;
				_g_object_unref0 (item_plugin);
				break;
			}
			_g_object_unref0 (item_plugin);
		}
		_g_object_unref0 (_item_plugin_it);
	}
	synapse_data_sink_set_has_empty_handlers (self, tmp);
}

static GObject*
synapse_data_sink_create_plugin (SynapseDataSink* self,
                                 GType t)
{
	GObjectClass* obj_class = NULL;
	GTypeClass* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GObjectClass* _tmp2_;
	GObject* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_type_class_ref (t);
	obj_class = (GObjectClass*) _tmp0_;
	_tmp2_ = obj_class;
	if (_tmp2_ != NULL) {
		GObjectClass* _tmp3_;
		GParamSpec* _tmp4_;
		_tmp3_ = obj_class;
		_tmp4_ = g_object_class_find_property (_tmp3_, "data-sink");
		_tmp1_ = _tmp4_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GObject* _tmp5_;
		GObject* _tmp6_;
		_tmp5_ = g_object_new (t, "data-sink", self, NULL, NULL);
		_tmp6_ = G_IS_INITIALLY_UNOWNED (_tmp5_) ? g_object_ref_sink (_tmp5_) : _tmp5_;
		result = _tmp6_;
		_g_type_class_unref0 (obj_class);
		return result;
	} else {
		GObject* _tmp7_;
		GObject* _tmp8_;
		_tmp7_ = g_object_new (t, NULL, NULL);
		_tmp8_ = G_IS_INITIALLY_UNOWNED (_tmp7_) ? g_object_ref_sink (_tmp7_) : _tmp7_;
		result = _tmp8_;
		_g_type_class_unref0 (obj_class);
		return result;
	}
}

static void
synapse_data_sink_load_plugins (SynapseDataSink* self)
{
	GType* _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->plugin_types;
	_tmp0__length1 = self->priv->plugin_types_length1;
	{
		GType* t_collection = NULL;
		gint t_collection_length1 = 0;
		gint _t_collection_size_ = 0;
		gint t_it = 0;
		t_collection = _tmp0_;
		t_collection_length1 = _tmp0__length1;
		for (t_it = 0; t_it < t_collection_length1; t_it = t_it + 1) {
			GType t = 0UL;
			t = t_collection[t_it];
			{
				GTypeClass* _tmp1_;
				GTypeClass* _tmp2_;
				SynapseDataSinkPluginRegistryPluginInfo* info = NULL;
				SynapseDataSinkPluginRegistry* _tmp3_;
				SynapseDataSinkPluginRegistryPluginInfo* _tmp4_;
				gboolean _tmp5_ = FALSE;
				SynapseDataSinkPluginRegistryPluginInfo* _tmp6_;
				gboolean skip = FALSE;
				gboolean _tmp8_ = FALSE;
				SynapseDataSinkDataSinkConfiguration* _tmp9_;
				_tmp1_ = g_type_class_ref (t);
				_tmp2_ = _tmp1_;
				_g_type_class_unref0 (_tmp2_);
				_tmp3_ = self->priv->registry;
				_tmp4_ = synapse_data_sink_plugin_registry_get_plugin_info_for_type (_tmp3_, t);
				info = _tmp4_;
				_tmp6_ = info;
				if (_tmp6_ != NULL) {
					SynapseDataSinkPluginRegistryPluginInfo* _tmp7_;
					_tmp7_ = info;
					_tmp5_ = _tmp7_->runnable == FALSE;
				} else {
					_tmp5_ = FALSE;
				}
				skip = _tmp5_;
				_tmp9_ = self->priv->config;
				if (synapse_data_sink_data_sink_configuration_is_plugin_enabled (_tmp9_, t)) {
					_tmp8_ = !skip;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					GObject* plugin = NULL;
					GObject* _tmp10_;
					GObject* _tmp11_;
					GObject* _tmp12_;
					_tmp10_ = synapse_data_sink_create_plugin (self, t);
					plugin = _tmp10_;
					_tmp11_ = plugin;
					synapse_data_sink_register_plugin (self, _tmp11_);
					_tmp12_ = plugin;
					synapse_activatable_activate (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatable));
					_g_object_unref0 (plugin);
				}
				_synapse_data_sink_plugin_registry_plugin_info_unref0 (info);
			}
		}
	}
	self->priv->plugins_loaded = TRUE;
}

static gboolean
_vala_g_type_array_contains (GType * stack,
                             gssize stack_length,
                             const GType needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_vala_array_add5 (GType* * array,
                  gint* length,
                  gint* size,
                  GType value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GType, *array, *size);
	}
	(*array)[(*length)++] = value;
}

void
synapse_data_sink_register_static_plugin (SynapseDataSink* self,
                                          GType plugin_type)
{
	GType* _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->plugin_types;
	_tmp0__length1 = self->priv->plugin_types_length1;
	if (_vala_g_type_array_contains (_tmp0_, _tmp0__length1, plugin_type)) {
		return;
	}
	_vala_array_add5 (&self->priv->plugin_types, &self->priv->plugin_types_length1, &self->priv->_plugin_types_size_, plugin_type);
}

GObject*
synapse_data_sink_get_plugin (SynapseDataSink* self,
                              const gchar* name)
{
	GObject* _result_ = NULL;
	GObject* _tmp8_;
	GObject* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_result_ = NULL;
	{
		GeeIterator* _plugin_it = NULL;
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->item_plugins;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_plugin_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			SynapseItemProvider* plugin = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			SynapseItemProvider* _tmp5_;
			const gchar* _tmp6_;
			_tmp2_ = _plugin_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _plugin_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			plugin = (SynapseItemProvider*) _tmp4_;
			_tmp5_ = plugin;
			_tmp6_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) _tmp5_));
			if (g_strcmp0 (_tmp6_, name) == 0) {
				SynapseItemProvider* _tmp7_;
				_tmp7_ = plugin;
				_result_ = (GObject*) _tmp7_;
				_g_object_unref0 (plugin);
				break;
			}
			_g_object_unref0 (plugin);
		}
		_g_object_unref0 (_plugin_it);
	}
	_tmp8_ = _result_;
	result = _tmp8_;
	return result;
}

gboolean
synapse_data_sink_is_plugin_enabled (SynapseDataSink* self,
                                     GType plugin_type)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeIterator* _plugin_it = NULL;
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->item_plugins;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_plugin_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			SynapseItemProvider* plugin = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			SynapseItemProvider* _tmp5_;
			_tmp2_ = _plugin_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _plugin_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			plugin = (SynapseItemProvider*) _tmp4_;
			_tmp5_ = plugin;
			if (G_TYPE_FROM_INSTANCE ((GObject*) _tmp5_) == plugin_type) {
				SynapseItemProvider* _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
				_tmp6_ = plugin;
				_tmp7_ = synapse_activatable_get_enabled ((SynapseActivatable*) _tmp6_);
				_tmp8_ = _tmp7_;
				result = _tmp8_;
				_g_object_unref0 (plugin);
				_g_object_unref0 (_plugin_it);
				return result;
			}
			_g_object_unref0 (plugin);
		}
		_g_object_unref0 (_plugin_it);
	}
	{
		GeeIterator* _action_it = NULL;
		GeeSet* _tmp9_;
		GeeIterator* _tmp10_;
		_tmp9_ = self->priv->action_plugins;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_action_it = _tmp10_;
		while (TRUE) {
			GeeIterator* _tmp11_;
			SynapseActionProvider* action = NULL;
			GeeIterator* _tmp12_;
			gpointer _tmp13_;
			SynapseActionProvider* _tmp14_;
			_tmp11_ = _action_it;
			if (!gee_iterator_next (_tmp11_)) {
				break;
			}
			_tmp12_ = _action_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			action = (SynapseActionProvider*) _tmp13_;
			_tmp14_ = action;
			if (G_TYPE_FROM_INSTANCE ((GObject*) _tmp14_) == plugin_type) {
				SynapseActionProvider* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
				_tmp15_ = action;
				_tmp16_ = synapse_activatable_get_enabled ((SynapseActivatable*) _tmp15_);
				_tmp17_ = _tmp16_;
				result = _tmp17_;
				_g_object_unref0 (action);
				_g_object_unref0 (_action_it);
				return result;
			}
			_g_object_unref0 (action);
		}
		_g_object_unref0 (_action_it);
	}
	result = FALSE;
	return result;
}

void
synapse_data_sink_set_plugin_enabled (SynapseDataSink* self,
                                      GType plugin_type,
                                      gboolean enabled)
{
	SynapseDataSinkDataSinkConfiguration* _tmp0_;
	SynapseConfigService* _tmp1_;
	SynapseConfigService* _tmp2_;
	SynapseDataSinkDataSinkConfiguration* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->config;
	synapse_data_sink_data_sink_configuration_set_plugin_enabled (_tmp0_, plugin_type, enabled);
	_tmp1_ = synapse_config_service_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->config;
	synapse_config_service_set_config (_tmp2_, "data-sink", "global", (SynapseConfigObject*) _tmp3_);
	_g_object_unref0 (_tmp2_);
	{
		GeeIterator* _plugin_it = NULL;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp4_ = self->priv->item_plugins;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_plugin_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			SynapseItemProvider* plugin = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			SynapseItemProvider* _tmp9_;
			_tmp6_ = _plugin_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _plugin_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			plugin = (SynapseItemProvider*) _tmp8_;
			_tmp9_ = plugin;
			if (G_TYPE_FROM_INSTANCE ((GObject*) _tmp9_) == plugin_type) {
				SynapseItemProvider* _tmp10_;
				_tmp10_ = plugin;
				synapse_activatable_set_enabled ((SynapseActivatable*) _tmp10_, enabled);
				if (enabled) {
					SynapseItemProvider* _tmp11_;
					_tmp11_ = plugin;
					synapse_activatable_activate ((SynapseActivatable*) _tmp11_);
				} else {
					SynapseItemProvider* _tmp12_;
					_tmp12_ = plugin;
					synapse_activatable_deactivate ((SynapseActivatable*) _tmp12_);
				}
				synapse_data_sink_update_has_empty_handlers (self);
				_g_object_unref0 (plugin);
				_g_object_unref0 (_plugin_it);
				return;
			}
			_g_object_unref0 (plugin);
		}
		_g_object_unref0 (_plugin_it);
	}
	{
		GeeIterator* _action_it = NULL;
		GeeSet* _tmp13_;
		GeeIterator* _tmp14_;
		_tmp13_ = self->priv->action_plugins;
		_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
		_action_it = _tmp14_;
		while (TRUE) {
			GeeIterator* _tmp15_;
			SynapseActionProvider* action = NULL;
			GeeIterator* _tmp16_;
			gpointer _tmp17_;
			SynapseActionProvider* _tmp18_;
			_tmp15_ = _action_it;
			if (!gee_iterator_next (_tmp15_)) {
				break;
			}
			_tmp16_ = _action_it;
			_tmp17_ = gee_iterator_get (_tmp16_);
			action = (SynapseActionProvider*) _tmp17_;
			_tmp18_ = action;
			if (G_TYPE_FROM_INSTANCE ((GObject*) _tmp18_) == plugin_type) {
				SynapseActionProvider* _tmp19_;
				_tmp19_ = action;
				synapse_activatable_set_enabled ((SynapseActivatable*) _tmp19_, enabled);
				if (enabled) {
					SynapseActionProvider* _tmp20_;
					_tmp20_ = action;
					synapse_activatable_activate ((SynapseActivatable*) _tmp20_);
				} else {
					SynapseActionProvider* _tmp21_;
					_tmp21_ = action;
					synapse_activatable_deactivate ((SynapseActivatable*) _tmp21_);
				}
				synapse_data_sink_update_has_unknown_handlers (self);
				_g_object_unref0 (action);
				_g_object_unref0 (_action_it);
				return;
			}
			_g_object_unref0 (action);
		}
		_g_object_unref0 (_action_it);
	}
	if (enabled) {
		GObject* new_instance = NULL;
		GObject* _tmp22_;
		GObject* _tmp23_;
		GObject* _tmp24_;
		_tmp22_ = synapse_data_sink_create_plugin (self, plugin_type);
		new_instance = _tmp22_;
		_tmp23_ = new_instance;
		synapse_data_sink_register_plugin (self, _tmp23_);
		_tmp24_ = new_instance;
		synapse_activatable_activate (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, SYNAPSE_TYPE_ACTIVATABLE, SynapseActivatable));
		_g_object_unref0 (new_instance);
	}
}

static void
synapse_data_sink_real_search_data_free (gpointer _data)
{
	SynapseDataSinkSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->query);
	_g_object_unref0 (_data_->dest_result_set);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseDataSinkSearchData, _data_);
}

static void
synapse_data_sink_real_search (SynapseSearchProvider* base,
                               const gchar* query,
                               SynapseQueryFlags flags,
                               SynapseResultSet* dest_result_set,
                               GCancellable* cancellable,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	SynapseDataSink * self;
	SynapseDataSinkSearchData* _data_;
	SynapseDataSink* _tmp0_;
	gchar* _tmp1_;
	SynapseResultSet* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (query != NULL);
	self = (SynapseDataSink*) base;
	_data_ = g_slice_new0 (SynapseDataSinkSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, synapse_data_sink_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (query);
	_g_free0 (_data_->query);
	_data_->query = _tmp1_;
	_data_->flags = flags;
	_tmp2_ = _g_object_ref0 (dest_result_set);
	_g_object_unref0 (_data_->dest_result_set);
	_data_->dest_result_set = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	synapse_data_sink_real_search_co (_data_);
}

static GeeList*
synapse_data_sink_search_finish (SynapseSearchProvider* base,
                                 GAsyncResult* _res_,
                                 GError** error)
{
	GeeList* result;
	SynapseDataSinkSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		SynapseDataSink* self;
		self = _data13_->self;
		_g_object_unref0 (_data13_->current_result_set);
		(_data13_->cancellables == NULL) ? NULL : (_data13_->cancellables = (_g_list_free__g_object_unref0_ (_data13_->cancellables), NULL));
		synapse_query_destroy (&_data13_->q);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static gboolean
_synapse_data_sink_real_search_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_data_sink_real_search_co (self);
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
____lambda13_ (Block13Data* _data13_,
               GObject* src_obj,
               GAsyncResult* res)
{
	SynapseDataSink* self;
	SynapseItemProvider* plugin = NULL;
	SynapseItemProvider* _tmp0_;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_;
	GError* _inner_error0_ = NULL;
	self = _data13_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = _g_object_ref0 (SYNAPSE_IS_ITEM_PROVIDER (src_obj) ? ((SynapseItemProvider*) src_obj) : NULL);
	plugin = _tmp0_;
	{
		SynapseResultSet* results = NULL;
		SynapseResultSet* _tmp1_;
		const gchar* _tmp2_;
		SynapseQuery _tmp3_;
		SynapseResultSet* _tmp4_;
		_tmp1_ = synapse_item_provider_search_finish (plugin, res, &_inner_error0_);
		results = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
				goto __catch0_synapse_search_error;
			}
			_g_object_unref0 (plugin);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp2_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) plugin));
		_tmp3_ = _data13_->q;
		g_signal_emit (self, synapse_data_sink_signals[SYNAPSE_DATA_SINK_SEARCH_DONE_SIGNAL], g_quark_from_string (_tmp2_), results, _tmp3_.query_id);
		_tmp4_ = _data13_->current_result_set;
		synapse_result_set_add_all (_tmp4_, results);
		_g_object_unref0 (results);
	}
	goto __finally0;
	__catch0_synapse_search_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		if (!g_error_matches (_tmp5_, SYNAPSE_SEARCH_ERROR, SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED)) {
			const gchar* _tmp6_;
			GError* _tmp7_;
			const gchar* _tmp8_;
			_tmp6_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) plugin));
			_tmp7_ = err;
			_tmp8_ = _tmp7_->message;
			g_warning ("data-sink.vala:453: %s returned error: %s", _tmp6_, _tmp8_);
		}
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (plugin);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_data13_->search_size = _data13_->search_size - 1;
	_tmp10_ = _data13_->search_size;
	if (_tmp10_ == 0) {
		_tmp9_ = _data13_->waiting;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		synapse_data_sink_real_search_co (_data13_->_async_data_);
	}
	_g_object_unref0 (plugin);
}

static void
_____lambda13__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	____lambda13_ (self, source_object, res);
	block13_data_unref (self);
}

static void
___lambda14_ (Block13Data* _data13_)
{
	SynapseDataSink* self;
	GList* _tmp0_;
	self = _data13_->self;
	_tmp0_ = _data13_->cancellables;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			GCancellable* c = NULL;
			c = (GCancellable*) c_it->data;
			{
				GCancellable* _tmp1_;
				_tmp1_ = c;
				g_cancellable_cancel (_tmp1_);
			}
		}
	}
}

static void
____lambda14__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda14_ (self);
}

static gboolean
synapse_data_sink_real_search_co (SynapseDataSinkSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data13_ = g_slice_new0 (Block13Data);
	_data_->_data13_->_ref_count_ = 1;
	_data_->_data13_->self = g_object_ref (_data_->self);
	_data_->_data13_->_async_data_ = _data_;
	while (TRUE) {
		if (!(!_data_->self->priv->plugins_loaded)) {
			break;
		}
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _synapse_data_sink_real_search_co_gsource_func, _data_, NULL);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		if (_data_->cancellable != NULL) {
			_data_->_tmp0_ = g_cancellable_is_cancelled (_data_->cancellable);
		} else {
			_data_->_tmp0_ = FALSE;
		}
		if (_data_->_tmp0_) {
			_data_->_tmp1_ = g_error_new_literal (SYNAPSE_SEARCH_ERROR, SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED, "Cancelled");
			_data_->_inner_error0_ = _data_->_tmp1_;
			if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				block13_data_unref (_data_->_data13_);
				_data_->_data13_ = NULL;
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				block13_data_unref (_data_->_data13_);
				_data_->_data13_ = NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	_data_->_tmp2_ = _data_->self->priv->query_id;
	_data_->self->priv->query_id = _data_->_tmp2_ + 1;
	_data_->_tmp3_ = _data_->query;
	_data_->_tmp4_ = _data_->flags;
	synapse_query_init (&_data_->_data13_->q, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, (guint) 96);
	_data_->_tmp5_ = string_strip (_data_->query);
	_data_->query_stripped = _data_->_tmp5_;
	_data_->_data13_->cancellables = NULL;
	_data_->_tmp7_ = _g_object_ref0 (_data_->dest_result_set);
	_data_->_tmp6_ = _data_->_tmp7_;
	if (_data_->_tmp6_ == NULL) {
		_data_->_tmp8_ = synapse_result_set_new ();
		_g_object_unref0 (_data_->_tmp6_);
		_data_->_tmp6_ = _data_->_tmp8_;
	}
	_data_->_tmp9_ = _data_->_tmp6_;
	_data_->_tmp6_ = NULL;
	_data_->_data13_->current_result_set = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->self->priv->item_plugins;
	_data_->_tmp11_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp10_);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_data13_->search_size = _data_->_tmp12_;
	_data_->_data13_->waiting = FALSE;
	{
		_data_->_tmp13_ = _data_->self->priv->item_plugins;
		_data_->_tmp14_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp13_);
		_data_->_data_plugin_it = _data_->_tmp14_;
		while (TRUE) {
			_data_->_tmp15_ = _data_->_data_plugin_it;
			if (!gee_iterator_next (_data_->_tmp15_)) {
				break;
			}
			_data_->_tmp16_ = _data_->_data_plugin_it;
			_data_->_tmp17_ = gee_iterator_get (_data_->_tmp16_);
			_data_->data_plugin = (SynapseItemProvider*) _data_->_tmp17_;
			_data_->_tmp20_ = _data_->data_plugin;
			_data_->_tmp21_ = synapse_activatable_get_enabled ((SynapseActivatable*) _data_->_tmp20_);
			_data_->_tmp22_ = _data_->_tmp21_;
			if (!_data_->_tmp22_) {
				_data_->_tmp19_ = TRUE;
			} else {
				if (g_strcmp0 (_data_->query, "") == 0) {
					_data_->_tmp24_ = _data_->data_plugin;
					_data_->_tmp23_ = !synapse_item_provider_handles_empty_query (_data_->_tmp24_);
				} else {
					_data_->_tmp23_ = FALSE;
				}
				_data_->_tmp19_ = _data_->_tmp23_;
			}
			if (_data_->_tmp19_) {
				_data_->_tmp18_ = TRUE;
			} else {
				_data_->_tmp25_ = _data_->data_plugin;
				_data_->_tmp26_ = _data_->_data13_->q;
				_data_->_tmp18_ = !synapse_item_provider_handles_query (_data_->_tmp25_, &_data_->_tmp26_);
			}
			_data_->skip = _data_->_tmp18_;
			if (_data_->skip) {
				_data_->_tmp27_ = _data_->_data13_->search_size;
				_data_->_data13_->search_size = _data_->_tmp27_ - 1;
				_g_object_unref0 (_data_->data_plugin);
				continue;
			}
			_data_->_tmp28_ = g_cancellable_new ();
			_data_->c = _data_->_tmp28_;
			_data_->_tmp29_ = _data_->c;
			_data_->_tmp30_ = _g_object_ref0 (_data_->_tmp29_);
			_data_->_data13_->cancellables = g_list_prepend (_data_->_data13_->cancellables, _data_->_tmp30_);
			_data_->_tmp31_ = _data_->c;
			_data_->_tmp32_ = _g_object_ref0 (_data_->_tmp31_);
			_g_object_unref0 (_data_->_data13_->q.cancellable);
			_data_->_data13_->q.cancellable = _data_->_tmp32_;
			_data_->_tmp33_ = _data_->data_plugin;
			_data_->_tmp34_ = _data_->_data13_->q;
			synapse_item_provider_search (_data_->_tmp33_, &_data_->_tmp34_, _____lambda13__gasync_ready_callback, block13_data_ref (_data_->_data13_));
			_g_object_unref0 (_data_->c);
			_g_object_unref0 (_data_->data_plugin);
		}
		_g_object_unref0 (_data_->_data_plugin_it);
	}
	_data_->_data13_->cancellables = g_list_reverse (_data_->_data13_->cancellables);
	if (_data_->cancellable != NULL) {
		g_cancellable_connect (_data_->cancellable, (GCallback) ____lambda14__gfunc, block13_data_ref (_data_->_data13_), block13_data_unref);
	}
	_data_->_data13_->waiting = TRUE;
	if (_data_->_data13_->search_size > 0) {
		_data_->_state_ = 2;
		return FALSE;
		_state_2:
		;
	}
	if (_data_->cancellable != NULL) {
		_data_->_tmp35_ = g_cancellable_is_cancelled (_data_->cancellable);
	} else {
		_data_->_tmp35_ = FALSE;
	}
	if (_data_->_tmp35_) {
		_data_->_tmp36_ = g_error_new_literal (SYNAPSE_SEARCH_ERROR, SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED, "Cancelled");
		_data_->_inner_error0_ = _data_->_tmp36_;
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->_tmp6_);
			_g_free0 (_data_->query_stripped);
			block13_data_unref (_data_->_data13_);
			_data_->_data13_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->_tmp6_);
			_g_free0 (_data_->query_stripped);
			block13_data_unref (_data_->_data13_);
			_data_->_data13_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp38_ = _data_->self->priv->_has_unknown_handlers;
	if (_data_->_tmp38_) {
		_data_->_tmp39_ = _data_->query_stripped;
		_data_->_tmp37_ = g_strcmp0 (_data_->_tmp39_, "") != 0;
	} else {
		_data_->_tmp37_ = FALSE;
	}
	if (_data_->_tmp37_) {
		_data_->_tmp40_ = synapse_default_match_new (_data_->query);
		_data_->unknown_match = _data_->_tmp40_;
		_data_->add_to_rs = FALSE;
		if ((_data_->flags & SYNAPSE_QUERY_FLAGS_ACTIONS) == SYNAPSE_QUERY_FLAGS_ACTIONS) {
			_data_->_tmp41_ = TRUE;
		} else {
			_data_->_tmp41_ = (_data_->flags & SYNAPSE_QUERY_FLAGS_TEXT) == SYNAPSE_QUERY_FLAGS_TEXT;
		}
		if (_data_->_tmp41_) {
			_data_->add_to_rs = TRUE;
		} else {
			_data_->_tmp42_ = _data_->unknown_match;
			_data_->_tmp43_ = synapse_data_sink_find_actions_for_unknown_match (_data_->self, (SynapseMatch*) _data_->_tmp42_, _data_->flags);
			_data_->unknown_match_actions = _data_->_tmp43_;
			_data_->_tmp44_ = _data_->unknown_match_actions;
			_data_->_tmp45_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp44_);
			_data_->_tmp46_ = _data_->_tmp45_;
			if (_data_->_tmp46_ > 0) {
				_data_->add_to_rs = TRUE;
			}
			_g_object_unref0 (_data_->unknown_match_actions);
		}
		if (_data_->add_to_rs) {
			_data_->_tmp47_ = _data_->_data13_->current_result_set;
			_data_->_tmp48_ = _data_->unknown_match;
			synapse_result_set_add (_data_->_tmp47_, (SynapseMatch*) _data_->_tmp48_, 0);
		}
		_g_object_unref0 (_data_->unknown_match);
	}
	_data_->_tmp49_ = _data_->_data13_->current_result_set;
	_data_->_tmp50_ = synapse_result_set_get_sorted_list (_data_->_tmp49_);
	_data_->result = _data_->_tmp50_;
	_g_object_unref0 (_data_->_tmp6_);
	_g_free0 (_data_->query_stripped);
	block13_data_unref (_data_->_data13_);
	_data_->_data13_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

GeeList*
synapse_data_sink_find_actions_for_unknown_match (SynapseDataSink* self,
                                                  SynapseMatch* match,
                                                  SynapseQueryFlags flags)
{
	SynapseResultSet* rs = NULL;
	SynapseResultSet* _tmp0_;
	SynapseQuery q = {0};
	SynapseResultSet* _tmp14_;
	GeeList* _tmp15_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (match != NULL, NULL);
	_tmp0_ = synapse_result_set_new ();
	rs = _tmp0_;
	synapse_query_init (&q, (guint) 0, "", flags, (guint) 96);
	{
		GeeIterator* _action_plugin_it = NULL;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp1_ = self->priv->action_plugins;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_action_plugin_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			SynapseActionProvider* action_plugin = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			SynapseActionProvider* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			SynapseActionProvider* _tmp9_;
			SynapseResultSet* _tmp10_;
			SynapseActionProvider* _tmp11_;
			SynapseResultSet* _tmp12_;
			SynapseResultSet* _tmp13_;
			_tmp3_ = _action_plugin_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _action_plugin_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			action_plugin = (SynapseActionProvider*) _tmp5_;
			_tmp6_ = action_plugin;
			_tmp7_ = synapse_activatable_get_enabled ((SynapseActivatable*) _tmp6_);
			_tmp8_ = _tmp7_;
			if (!_tmp8_) {
				_g_object_unref0 (action_plugin);
				continue;
			}
			_tmp9_ = action_plugin;
			if (!synapse_action_provider_handles_unknown (_tmp9_)) {
				_g_object_unref0 (action_plugin);
				continue;
			}
			_tmp10_ = rs;
			_tmp11_ = action_plugin;
			_tmp12_ = synapse_action_provider_find_for_match (_tmp11_, &q, match);
			_tmp13_ = _tmp12_;
			synapse_result_set_add_all (_tmp10_, _tmp13_);
			_g_object_unref0 (_tmp13_);
			_g_object_unref0 (action_plugin);
		}
		_g_object_unref0 (_action_plugin_it);
	}
	_tmp14_ = rs;
	_tmp15_ = synapse_result_set_get_sorted_list (_tmp14_);
	result = _tmp15_;
	synapse_query_destroy (&q);
	_g_object_unref0 (rs);
	return result;
}

GeeList*
synapse_data_sink_find_actions_for_match (SynapseDataSink* self,
                                          SynapseMatch* match,
                                          const gchar* query,
                                          SynapseQueryFlags flags)
{
	SynapseResultSet* rs = NULL;
	SynapseResultSet* _tmp0_;
	const gchar* _tmp1_ = NULL;
	SynapseQuery q = {0};
	SynapseResultSet* _tmp14_;
	GeeList* _tmp15_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (match != NULL, NULL);
	_tmp0_ = synapse_result_set_new ();
	rs = _tmp0_;
	_tmp1_ = query;
	if (_tmp1_ == NULL) {
		_tmp1_ = "";
	}
	synapse_query_init (&q, (guint) 0, _tmp1_, flags, (guint) 96);
	{
		GeeIterator* _action_plugin_it = NULL;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp2_ = self->priv->action_plugins;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_action_plugin_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			SynapseActionProvider* action_plugin = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			SynapseActionProvider* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			SynapseResultSet* _tmp10_;
			SynapseActionProvider* _tmp11_;
			SynapseResultSet* _tmp12_;
			SynapseResultSet* _tmp13_;
			_tmp4_ = _action_plugin_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _action_plugin_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			action_plugin = (SynapseActionProvider*) _tmp6_;
			_tmp7_ = action_plugin;
			_tmp8_ = synapse_activatable_get_enabled ((SynapseActivatable*) _tmp7_);
			_tmp9_ = _tmp8_;
			if (!_tmp9_) {
				_g_object_unref0 (action_plugin);
				continue;
			}
			_tmp10_ = rs;
			_tmp11_ = action_plugin;
			_tmp12_ = synapse_action_provider_find_for_match (_tmp11_, &q, match);
			_tmp13_ = _tmp12_;
			synapse_result_set_add_all (_tmp10_, _tmp13_);
			_g_object_unref0 (_tmp13_);
			_g_object_unref0 (action_plugin);
		}
		_g_object_unref0 (_action_plugin_it);
	}
	_tmp14_ = rs;
	_tmp15_ = synapse_result_set_get_sorted_list (_tmp14_);
	result = _tmp15_;
	synapse_query_destroy (&q);
	_g_object_unref0 (rs);
	return result;
}

gboolean
synapse_data_sink_get_has_empty_handlers (SynapseDataSink* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_empty_handlers;
	return result;
}

void
synapse_data_sink_set_has_empty_handlers (SynapseDataSink* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_data_sink_get_has_empty_handlers (self);
	if (old_value != value) {
		self->priv->_has_empty_handlers = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_data_sink_properties[SYNAPSE_DATA_SINK_HAS_EMPTY_HANDLERS_PROPERTY]);
	}
}

gboolean
synapse_data_sink_get_has_unknown_handlers (SynapseDataSink* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_unknown_handlers;
	return result;
}

void
synapse_data_sink_set_has_unknown_handlers (SynapseDataSink* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_data_sink_get_has_unknown_handlers (self);
	if (old_value != value) {
		self->priv->_has_unknown_handlers = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_data_sink_properties[SYNAPSE_DATA_SINK_HAS_UNKNOWN_HANDLERS_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_UINT (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_UINT) (gpointer data1, gpointer arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_uint (param_values + 2), data2);
}

static inline gpointer
synapse_data_sink_plugin_registry_get_instance_private (SynapseDataSinkPluginRegistry* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDataSinkPluginRegistry_private_offset);
}

SynapseDataSinkPluginRegistry*
synapse_data_sink_plugin_registry_get_default (void)
{
	SynapseDataSinkPluginRegistry* _tmp0_ = NULL;
	SynapseDataSinkPluginRegistry* _tmp1_;
	SynapseDataSinkPluginRegistry* _tmp2_;
	SynapseDataSinkPluginRegistry* _tmp4_;
	SynapseDataSinkPluginRegistry* result;
	_tmp1_ = synapse_data_sink_plugin_registry_instance;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		SynapseDataSinkPluginRegistry* _tmp3_;
		_tmp3_ = synapse_data_sink_plugin_registry_new ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp0_);
	return result;
}

void
synapse_data_sink_plugin_registry_register_plugin (SynapseDataSinkPluginRegistry* self,
                                                   GType plugin_type,
                                                   const gchar* title,
                                                   const gchar* description,
                                                   const gchar* icon_name,
                                                   SynapsePluginRegisterFunc reg_func,
                                                   gboolean runnable,
                                                   const gchar* runnable_error)
{
	gint index = 0;
	SynapseDataSinkPluginRegistryPluginInfo* p = NULL;
	SynapseDataSinkPluginRegistryPluginInfo* _tmp12_;
	GeeList* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (description != NULL);
	g_return_if_fail (icon_name != NULL);
	g_return_if_fail (runnable_error != NULL);
	index = -1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GeeList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				GeeList* _tmp5_;
				gpointer _tmp6_;
				SynapseDataSinkPluginRegistryPluginInfo* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->plugins;
				_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->plugins;
				_tmp6_ = gee_list_get (_tmp5_, i);
				_tmp7_ = (SynapseDataSinkPluginRegistryPluginInfo*) _tmp6_;
				_tmp8_ = _tmp7_->plugin_type == plugin_type;
				_synapse_data_sink_plugin_registry_plugin_info_unref0 (_tmp7_);
				if (_tmp8_) {
					index = i;
					break;
				}
			}
		}
	}
	if (index >= 0) {
		GeeList* _tmp9_;
		gpointer _tmp10_;
		SynapseDataSinkPluginRegistryPluginInfo* _tmp11_;
		_tmp9_ = self->priv->plugins;
		_tmp10_ = gee_list_remove_at (_tmp9_, index);
		_tmp11_ = (SynapseDataSinkPluginRegistryPluginInfo*) _tmp10_;
		_synapse_data_sink_plugin_registry_plugin_info_unref0 (_tmp11_);
	}
	_tmp12_ = synapse_data_sink_plugin_registry_plugin_info_new (plugin_type, title, description, icon_name, reg_func, runnable, runnable_error);
	p = _tmp12_;
	_tmp13_ = self->priv->plugins;
	gee_collection_add ((GeeCollection*) _tmp13_, p);
	_synapse_data_sink_plugin_registry_plugin_info_unref0 (p);
}

GeeList*
synapse_data_sink_plugin_registry_get_plugins (SynapseDataSinkPluginRegistry* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->plugins;
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

SynapseDataSinkPluginRegistryPluginInfo*
synapse_data_sink_plugin_registry_get_plugin_info_for_type (SynapseDataSinkPluginRegistry* self,
                                                            GType plugin_type)
{
	SynapseDataSinkPluginRegistryPluginInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeList* _pi_list = NULL;
		GeeList* _tmp0_;
		gint _pi_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _pi_index = 0;
		_tmp0_ = self->priv->plugins;
		_pi_list = _tmp0_;
		_tmp1_ = _pi_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_pi_size = _tmp3_;
		_pi_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			SynapseDataSinkPluginRegistryPluginInfo* pi = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			SynapseDataSinkPluginRegistryPluginInfo* _tmp8_;
			_pi_index = _pi_index + 1;
			_tmp4_ = _pi_index;
			_tmp5_ = _pi_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _pi_list;
			_tmp7_ = gee_list_get (_tmp6_, _pi_index);
			pi = (SynapseDataSinkPluginRegistryPluginInfo*) _tmp7_;
			_tmp8_ = pi;
			if (_tmp8_->plugin_type == plugin_type) {
				result = pi;
				return result;
			}
			_synapse_data_sink_plugin_registry_plugin_info_unref0 (pi);
		}
	}
	result = NULL;
	return result;
}

SynapseDataSinkPluginRegistry*
synapse_data_sink_plugin_registry_construct (GType object_type)
{
	SynapseDataSinkPluginRegistry * self = NULL;
	self = (SynapseDataSinkPluginRegistry*) g_object_new (object_type, NULL);
	return self;
}

SynapseDataSinkPluginRegistry*
synapse_data_sink_plugin_registry_new (void)
{
	return synapse_data_sink_plugin_registry_construct (SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY);
}

SynapseDataSinkPluginRegistryPluginInfo*
synapse_data_sink_plugin_registry_plugin_info_construct (GType object_type,
                                                         GType type,
                                                         const gchar* title,
                                                         const gchar* desc,
                                                         const gchar* icon_name,
                                                         SynapsePluginRegisterFunc reg_func,
                                                         gboolean runnable,
                                                         const gchar* runnable_error)
{
	SynapseDataSinkPluginRegistryPluginInfo* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (desc != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	g_return_val_if_fail (runnable_error != NULL, NULL);
	self = (SynapseDataSinkPluginRegistryPluginInfo*) g_type_create_instance (object_type);
	self->plugin_type = type;
	_tmp0_ = g_strdup (title);
	_g_free0 (self->title);
	self->title = _tmp0_;
	_tmp1_ = g_strdup (desc);
	_g_free0 (self->description);
	self->description = _tmp1_;
	_tmp2_ = g_strdup (icon_name);
	_g_free0 (self->icon_name);
	self->icon_name = _tmp2_;
	self->register_func = reg_func;
	self->runnable = runnable;
	_tmp3_ = g_strdup (runnable_error);
	_g_free0 (self->runnable_error);
	self->runnable_error = _tmp3_;
	return self;
}

SynapseDataSinkPluginRegistryPluginInfo*
synapse_data_sink_plugin_registry_plugin_info_new (GType type,
                                                   const gchar* title,
                                                   const gchar* desc,
                                                   const gchar* icon_name,
                                                   SynapsePluginRegisterFunc reg_func,
                                                   gboolean runnable,
                                                   const gchar* runnable_error)
{
	return synapse_data_sink_plugin_registry_plugin_info_construct (SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO, type, title, desc, icon_name, reg_func, runnable, runnable_error);
}

static void
synapse_data_sink_plugin_registry_value_plugin_info_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
synapse_data_sink_plugin_registry_value_plugin_info_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		synapse_data_sink_plugin_registry_plugin_info_unref (value->data[0].v_pointer);
	}
}

static void
synapse_data_sink_plugin_registry_value_plugin_info_copy_value (const GValue* src_value,
                                                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = synapse_data_sink_plugin_registry_plugin_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
synapse_data_sink_plugin_registry_value_plugin_info_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
synapse_data_sink_plugin_registry_value_plugin_info_collect_value (GValue* value,
                                                                   guint n_collect_values,
                                                                   GTypeCValue* collect_values,
                                                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SynapseDataSinkPluginRegistryPluginInfo * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = synapse_data_sink_plugin_registry_plugin_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
synapse_data_sink_plugin_registry_value_plugin_info_lcopy_value (const GValue* value,
                                                                 guint n_collect_values,
                                                                 GTypeCValue* collect_values,
                                                                 guint collect_flags)
{
	SynapseDataSinkPluginRegistryPluginInfo ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = synapse_data_sink_plugin_registry_plugin_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
synapse_data_sink_plugin_registry_param_spec_plugin_info (const gchar* name,
                                                          const gchar* nick,
                                                          const gchar* blurb,
                                                          GType object_type,
                                                          GParamFlags flags)
{
	SynapseDataSinkPluginRegistryParamSpecPluginInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
synapse_data_sink_plugin_registry_value_get_plugin_info (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO), NULL);
	return value->data[0].v_pointer;
}

void
synapse_data_sink_plugin_registry_value_set_plugin_info (GValue* value,
                                                         gpointer v_object)
{
	SynapseDataSinkPluginRegistryPluginInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		synapse_data_sink_plugin_registry_plugin_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_data_sink_plugin_registry_plugin_info_unref (old);
	}
}

void
synapse_data_sink_plugin_registry_value_take_plugin_info (GValue* value,
                                                          gpointer v_object)
{
	SynapseDataSinkPluginRegistryPluginInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		synapse_data_sink_plugin_registry_plugin_info_unref (old);
	}
}

static void
synapse_data_sink_plugin_registry_plugin_info_class_init (SynapseDataSinkPluginRegistryPluginInfoClass * klass,
                                                          gpointer klass_data)
{
	synapse_data_sink_plugin_registry_plugin_info_parent_class = g_type_class_peek_parent (klass);
	((SynapseDataSinkPluginRegistryPluginInfoClass *) klass)->finalize = synapse_data_sink_plugin_registry_plugin_info_finalize;
}

static void
synapse_data_sink_plugin_registry_plugin_info_instance_init (SynapseDataSinkPluginRegistryPluginInfo * self,
                                                             gpointer klass)
{
	self->ref_count = 1;
}

static void
synapse_data_sink_plugin_registry_plugin_info_finalize (SynapseDataSinkPluginRegistryPluginInfo * obj)
{
	SynapseDataSinkPluginRegistryPluginInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO, SynapseDataSinkPluginRegistryPluginInfo);
	g_signal_handlers_destroy (self);
	_g_free0 (self->title);
	_g_free0 (self->description);
	_g_free0 (self->icon_name);
	_g_free0 (self->runnable_error);
}

static GType
synapse_data_sink_plugin_registry_plugin_info_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { synapse_data_sink_plugin_registry_value_plugin_info_init, synapse_data_sink_plugin_registry_value_plugin_info_free_value, synapse_data_sink_plugin_registry_value_plugin_info_copy_value, synapse_data_sink_plugin_registry_value_plugin_info_peek_pointer, "p", synapse_data_sink_plugin_registry_value_plugin_info_collect_value, "p", synapse_data_sink_plugin_registry_value_plugin_info_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDataSinkPluginRegistryPluginInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_data_sink_plugin_registry_plugin_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDataSinkPluginRegistryPluginInfo), 0, (GInstanceInitFunc) synapse_data_sink_plugin_registry_plugin_info_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType synapse_data_sink_plugin_registry_plugin_info_type_id;
	synapse_data_sink_plugin_registry_plugin_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseDataSinkPluginRegistryPluginInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return synapse_data_sink_plugin_registry_plugin_info_type_id;
}

GType
synapse_data_sink_plugin_registry_plugin_info_get_type (void)
{
	static volatile gsize synapse_data_sink_plugin_registry_plugin_info_type_id__once = 0;
	if (g_once_init_enter (&synapse_data_sink_plugin_registry_plugin_info_type_id__once)) {
		GType synapse_data_sink_plugin_registry_plugin_info_type_id;
		synapse_data_sink_plugin_registry_plugin_info_type_id = synapse_data_sink_plugin_registry_plugin_info_get_type_once ();
		g_once_init_leave (&synapse_data_sink_plugin_registry_plugin_info_type_id__once, synapse_data_sink_plugin_registry_plugin_info_type_id);
	}
	return synapse_data_sink_plugin_registry_plugin_info_type_id__once;
}

gpointer
synapse_data_sink_plugin_registry_plugin_info_ref (gpointer instance)
{
	SynapseDataSinkPluginRegistryPluginInfo * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
synapse_data_sink_plugin_registry_plugin_info_unref (gpointer instance)
{
	SynapseDataSinkPluginRegistryPluginInfo * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_PLUGIN_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static GObject *
synapse_data_sink_plugin_registry_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDataSinkPluginRegistry * self;
	GeeArrayList* _tmp0_;
	parent_class = G_OBJECT_CLASS (synapse_data_sink_plugin_registry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY, SynapseDataSinkPluginRegistry);
	synapse_data_sink_plugin_registry_instance = self;
	_tmp0_ = gee_array_list_new (SYNAPSE_DATA_SINK_PLUGIN_REGISTRY_TYPE_PLUGIN_INFO, (GBoxedCopyFunc) synapse_data_sink_plugin_registry_plugin_info_ref, (GDestroyNotify) synapse_data_sink_plugin_registry_plugin_info_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->plugins);
	self->priv->plugins = (GeeList*) _tmp0_;
	return obj;
}

static void
synapse_data_sink_plugin_registry_class_init (SynapseDataSinkPluginRegistryClass * klass,
                                              gpointer klass_data)
{
	synapse_data_sink_plugin_registry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseDataSinkPluginRegistry_private_offset);
	G_OBJECT_CLASS (klass)->constructor = synapse_data_sink_plugin_registry_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_data_sink_plugin_registry_finalize;
}

static void
synapse_data_sink_plugin_registry_instance_init (SynapseDataSinkPluginRegistry * self,
                                                 gpointer klass)
{
	self->priv = synapse_data_sink_plugin_registry_get_instance_private (self);
}

static void
synapse_data_sink_plugin_registry_finalize (GObject * obj)
{
	SynapseDataSinkPluginRegistry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DATA_SINK_TYPE_PLUGIN_REGISTRY, SynapseDataSinkPluginRegistry);
	synapse_data_sink_plugin_registry_instance = NULL;
	_g_object_unref0 (self->priv->plugins);
	G_OBJECT_CLASS (synapse_data_sink_plugin_registry_parent_class)->finalize (obj);
}

static GType
synapse_data_sink_plugin_registry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDataSinkPluginRegistryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_data_sink_plugin_registry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDataSinkPluginRegistry), 0, (GInstanceInitFunc) synapse_data_sink_plugin_registry_instance_init, NULL };
	GType synapse_data_sink_plugin_registry_type_id;
	synapse_data_sink_plugin_registry_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDataSinkPluginRegistry", &g_define_type_info, 0);
	SynapseDataSinkPluginRegistry_private_offset = g_type_add_instance_private (synapse_data_sink_plugin_registry_type_id, sizeof (SynapseDataSinkPluginRegistryPrivate));
	return synapse_data_sink_plugin_registry_type_id;
}

GType
synapse_data_sink_plugin_registry_get_type (void)
{
	static volatile gsize synapse_data_sink_plugin_registry_type_id__once = 0;
	if (g_once_init_enter (&synapse_data_sink_plugin_registry_type_id__once)) {
		GType synapse_data_sink_plugin_registry_type_id;
		synapse_data_sink_plugin_registry_type_id = synapse_data_sink_plugin_registry_get_type_once ();
		g_once_init_leave (&synapse_data_sink_plugin_registry_type_id__once, synapse_data_sink_plugin_registry_type_id);
	}
	return synapse_data_sink_plugin_registry_type_id__once;
}

static inline gpointer
synapse_data_sink_data_sink_configuration_get_instance_private (SynapseDataSinkDataSinkConfiguration* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDataSinkDataSinkConfiguration_private_offset);
}

static void
synapse_data_sink_data_sink_configuration_set_plugin_enabled (SynapseDataSinkDataSinkConfiguration* self,
                                                              GType t,
                                                              gboolean enabled)
{
	g_return_if_fail (self != NULL);
	if (enabled) {
		const gchar* _tmp0_;
		_tmp0_ = g_type_name (t);
		synapse_data_sink_data_sink_configuration_enable_plugin (self, _tmp0_);
	} else {
		const gchar* _tmp1_;
		_tmp1_ = g_type_name (t);
		synapse_data_sink_data_sink_configuration_disable_plugin (self, _tmp1_);
	}
}

static gboolean
synapse_data_sink_data_sink_configuration_is_plugin_enabled (SynapseDataSinkDataSinkConfiguration* self,
                                                             GType t)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* plugin_name = NULL;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_disabled_plugins;
	_tmp0__length1 = self->priv->_disabled_plugins_length1;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = g_type_name (t);
	plugin_name = _tmp1_;
	_tmp2_ = self->priv->_disabled_plugins;
	_tmp2__length1 = self->priv->_disabled_plugins_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp2_;
		s_collection_length1 = _tmp2__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp3_ = s;
				_tmp4_ = plugin_name;
				if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
synapse_data_sink_data_sink_configuration_enable_plugin (SynapseDataSinkDataSinkConfiguration* self,
                                                         const gchar* name)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** cpy = NULL;
	gchar** _tmp2_;
	gint cpy_length1;
	gint _cpy_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->_disabled_plugins;
	_tmp0__length1 = self->priv->_disabled_plugins_length1;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_disabled_plugins;
	_tmp1__length1 = self->priv->_disabled_plugins_length1;
	if (!_vala_string_array_contains (_tmp1_, _tmp1__length1, name)) {
		return;
	}
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	cpy = _tmp2_;
	cpy_length1 = 0;
	_cpy_size_ = cpy_length1;
	_tmp3_ = self->priv->_disabled_plugins;
	_tmp3__length1 = self->priv->_disabled_plugins_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp3_;
		s_collection_length1 = _tmp3__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				const gchar* _tmp4_;
				_tmp4_ = s;
				if (g_strcmp0 (_tmp4_, name) != 0) {
					const gchar* _tmp5_;
					gchar* _tmp6_;
					_tmp5_ = s;
					_tmp6_ = g_strdup (_tmp5_);
					_vala_array_add6 (&cpy, &cpy_length1, &_cpy_size_, _tmp6_);
				}
			}
		}
	}
	_tmp7_ = cpy;
	_tmp7__length1 = cpy_length1;
	cpy = NULL;
	cpy_length1 = 0;
	self->priv->_disabled_plugins = (_vala_array_free (self->priv->_disabled_plugins, self->priv->_disabled_plugins_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_disabled_plugins = _tmp7_;
	self->priv->_disabled_plugins_length1 = _tmp7__length1;
	self->priv->__disabled_plugins_size_ = self->priv->_disabled_plugins_length1;
	cpy = (_vala_array_free (cpy, cpy_length1, (GDestroyNotify) g_free), NULL);
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
synapse_data_sink_data_sink_configuration_disable_plugin (SynapseDataSinkDataSinkConfiguration* self,
                                                          const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = self->priv->_disabled_plugins;
	_tmp1__length1 = self->priv->_disabled_plugins_length1;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp2_;
		gint _tmp2__length1;
		_tmp2_ = self->priv->_disabled_plugins;
		_tmp2__length1 = self->priv->_disabled_plugins_length1;
		_tmp0_ = !_vala_string_array_contains (_tmp2_, _tmp2__length1, name);
	}
	if (_tmp0_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (name);
		_vala_array_add7 (&self->priv->_disabled_plugins, &self->priv->_disabled_plugins_length1, &self->priv->__disabled_plugins_size_, _tmp3_);
	}
}

static SynapseDataSinkDataSinkConfiguration*
synapse_data_sink_data_sink_configuration_construct (GType object_type)
{
	SynapseDataSinkDataSinkConfiguration * self = NULL;
	self = (SynapseDataSinkDataSinkConfiguration*) synapse_config_object_construct (object_type);
	return self;
}

static SynapseDataSinkDataSinkConfiguration*
synapse_data_sink_data_sink_configuration_new (void)
{
	return synapse_data_sink_data_sink_configuration_construct (SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION);
}

static gchar**
synapse_data_sink_data_sink_configuration_get_disabled_plugins (SynapseDataSinkDataSinkConfiguration* self,
                                                                gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_disabled_plugins;
	_tmp0__length1 = self->priv->_disabled_plugins_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
synapse_data_sink_data_sink_configuration_set_disabled_plugins (SynapseDataSinkDataSinkConfiguration* self,
                                                                gchar** value,
                                                                gint value_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (value != NULL) ? _vala_array_dup2 (value, value_length1) : value;
	_tmp0__length1 = value_length1;
	self->priv->_disabled_plugins = (_vala_array_free (self->priv->_disabled_plugins, self->priv->_disabled_plugins_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_disabled_plugins = _tmp0_;
	self->priv->_disabled_plugins_length1 = _tmp0__length1;
	self->priv->__disabled_plugins_size_ = self->priv->_disabled_plugins_length1;
	g_object_notify_by_pspec ((GObject *) self, synapse_data_sink_data_sink_configuration_properties[SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_DISABLED_PLUGINS_PROPERTY]);
}

static void
synapse_data_sink_data_sink_configuration_class_init (SynapseDataSinkDataSinkConfigurationClass * klass,
                                                      gpointer klass_data)
{
	synapse_data_sink_data_sink_configuration_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseDataSinkDataSinkConfiguration_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_data_sink_data_sink_configuration_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_data_sink_data_sink_configuration_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_data_sink_data_sink_configuration_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_DISABLED_PLUGINS_PROPERTY, synapse_data_sink_data_sink_configuration_properties[SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_DISABLED_PLUGINS_PROPERTY] = g_param_spec_boxed ("disabled-plugins", "disabled-plugins", "disabled-plugins", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
synapse_data_sink_data_sink_configuration_instance_init (SynapseDataSinkDataSinkConfiguration * self,
                                                         gpointer klass)
{
	self->priv = synapse_data_sink_data_sink_configuration_get_instance_private (self);
	self->priv->_disabled_plugins = NULL;
	self->priv->_disabled_plugins_length1 = 0;
	self->priv->__disabled_plugins_size_ = self->priv->_disabled_plugins_length1;
}

static void
synapse_data_sink_data_sink_configuration_finalize (GObject * obj)
{
	SynapseDataSinkDataSinkConfiguration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION, SynapseDataSinkDataSinkConfiguration);
	self->priv->_disabled_plugins = (_vala_array_free (self->priv->_disabled_plugins, self->priv->_disabled_plugins_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (synapse_data_sink_data_sink_configuration_parent_class)->finalize (obj);
}

static GType
synapse_data_sink_data_sink_configuration_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDataSinkDataSinkConfigurationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_data_sink_data_sink_configuration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDataSinkDataSinkConfiguration), 0, (GInstanceInitFunc) synapse_data_sink_data_sink_configuration_instance_init, NULL };
	GType synapse_data_sink_data_sink_configuration_type_id;
	synapse_data_sink_data_sink_configuration_type_id = g_type_register_static (SYNAPSE_TYPE_CONFIG_OBJECT, "SynapseDataSinkDataSinkConfiguration", &g_define_type_info, 0);
	SynapseDataSinkDataSinkConfiguration_private_offset = g_type_add_instance_private (synapse_data_sink_data_sink_configuration_type_id, sizeof (SynapseDataSinkDataSinkConfigurationPrivate));
	return synapse_data_sink_data_sink_configuration_type_id;
}

static GType
synapse_data_sink_data_sink_configuration_get_type (void)
{
	static volatile gsize synapse_data_sink_data_sink_configuration_type_id__once = 0;
	if (g_once_init_enter (&synapse_data_sink_data_sink_configuration_type_id__once)) {
		GType synapse_data_sink_data_sink_configuration_type_id;
		synapse_data_sink_data_sink_configuration_type_id = synapse_data_sink_data_sink_configuration_get_type_once ();
		g_once_init_leave (&synapse_data_sink_data_sink_configuration_type_id__once, synapse_data_sink_data_sink_configuration_type_id);
	}
	return synapse_data_sink_data_sink_configuration_type_id__once;
}

static void
_vala_synapse_data_sink_data_sink_configuration_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec)
{
	SynapseDataSinkDataSinkConfiguration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION, SynapseDataSinkDataSinkConfiguration);
	switch (property_id) {
		case SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_DISABLED_PLUGINS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, synapse_data_sink_data_sink_configuration_get_disabled_plugins (self, &length));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_synapse_data_sink_data_sink_configuration_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec)
{
	SynapseDataSinkDataSinkConfiguration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION, SynapseDataSinkDataSinkConfiguration);
	switch (property_id) {
		case SYNAPSE_DATA_SINK_DATA_SINK_CONFIGURATION_DISABLED_PLUGINS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			synapse_data_sink_data_sink_configuration_set_disabled_plugins (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GObject *
synapse_data_sink_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDataSink * self;
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GType* _tmp2_;
	SynapseConfigService* cfg = NULL;
	SynapseConfigService* _tmp3_;
	SynapseConfigService* _tmp4_;
	SynapseConfigObject* _tmp5_;
	SynapseDataSinkPluginRegistry* _tmp6_;
	SynapseRelevancyService* _tmp7_;
	parent_class = G_OBJECT_CLASS (synapse_data_sink_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DATA_SINK, SynapseDataSink);
	_tmp0_ = gee_hash_set_new (SYNAPSE_TYPE_ITEM_PROVIDER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->item_plugins);
	self->priv->item_plugins = (GeeSet*) _tmp0_;
	_tmp1_ = gee_hash_set_new (SYNAPSE_TYPE_ACTION_PROVIDER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->action_plugins);
	self->priv->action_plugins = (GeeSet*) _tmp1_;
	_tmp2_ = g_new0 (GType, 0);
	self->priv->plugin_types = (g_free (self->priv->plugin_types), NULL);
	self->priv->plugin_types = _tmp2_;
	self->priv->plugin_types_length1 = 0;
	self->priv->_plugin_types_size_ = self->priv->plugin_types_length1;
	self->priv->query_id = (guint) 0;
	_tmp3_ = synapse_config_service_get_default ();
	cfg = _tmp3_;
	_tmp4_ = cfg;
	_tmp5_ = synapse_config_service_get_config (_tmp4_, "data-sink", "global", SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION);
	_g_object_unref0 (self->priv->config);
	self->priv->config = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, SYNAPSE_DATA_SINK_TYPE_DATA_SINK_CONFIGURATION, SynapseDataSinkDataSinkConfiguration);
	_tmp6_ = synapse_data_sink_plugin_registry_get_default ();
	_g_object_unref0 (self->priv->registry);
	self->priv->registry = _tmp6_;
	_tmp7_ = synapse_relevancy_service_get_default ();
	_g_object_unref0 (self->priv->relevancy_service);
	self->priv->relevancy_service = _tmp7_;
	synapse_data_sink_initialize_caches (self, NULL, NULL);
	synapse_data_sink_register_static_plugin (self, SYNAPSE_TYPE_COMMON_ACTIONS);
	_g_object_unref0 (cfg);
	return obj;
}

static void
synapse_data_sink_class_init (SynapseDataSinkClass * klass,
                              gpointer klass_data)
{
	synapse_data_sink_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseDataSink_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_data_sink_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_data_sink_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_data_sink_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_data_sink_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DATA_SINK_HAS_EMPTY_HANDLERS_PROPERTY, synapse_data_sink_properties[SYNAPSE_DATA_SINK_HAS_EMPTY_HANDLERS_PROPERTY] = g_param_spec_boolean ("has-empty-handlers", "has-empty-handlers", "has-empty-handlers", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DATA_SINK_HAS_UNKNOWN_HANDLERS_PROPERTY, synapse_data_sink_properties[SYNAPSE_DATA_SINK_HAS_UNKNOWN_HANDLERS_PROPERTY] = g_param_spec_boolean ("has-unknown-handlers", "has-unknown-handlers", "has-unknown-handlers", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	synapse_data_sink_signals[SYNAPSE_DATA_SINK_PLUGIN_REGISTERED_SIGNAL] = g_signal_new ("plugin-registered", SYNAPSE_TYPE_DATA_SINK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_OBJECT);
	synapse_data_sink_signals[SYNAPSE_DATA_SINK_SEARCH_DONE_SIGNAL] = g_signal_new ("search-done", SYNAPSE_TYPE_DATA_SINK, G_SIGNAL_RUN_LAST | G_SIGNAL_DETAILED, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_UINT, G_TYPE_NONE, 2, SYNAPSE_TYPE_RESULT_SET, G_TYPE_UINT);
}

static void
synapse_data_sink_synapse_search_provider_interface_init (SynapseSearchProviderIface * iface,
                                                          gpointer iface_data)
{
	synapse_data_sink_synapse_search_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (void (*) (SynapseSearchProvider*, const gchar*, SynapseQueryFlags, SynapseResultSet*, GCancellable*, GAsyncReadyCallback, gpointer)) synapse_data_sink_real_search;
	iface->search_finish = (GeeList* (*) (SynapseSearchProvider*, GAsyncResult*, GError**)) synapse_data_sink_search_finish;
}

static void
synapse_data_sink_instance_init (SynapseDataSink * self,
                                 gpointer klass)
{
	self->priv = synapse_data_sink_get_instance_private (self);
	self->priv->_has_empty_handlers = FALSE;
	self->priv->_has_unknown_handlers = FALSE;
	self->priv->plugins_loaded = FALSE;
}

static void
synapse_data_sink_finalize (GObject * obj)
{
	SynapseDataSink * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DATA_SINK, SynapseDataSink);
	g_debug ("data-sink.vala:181: DataSink died…");
	_g_object_unref0 (self->priv->config);
	_g_object_unref0 (self->priv->item_plugins);
	_g_object_unref0 (self->priv->action_plugins);
	_g_object_unref0 (self->priv->dbus_name_cache);
	_g_object_unref0 (self->priv->desktop_file_service);
	_g_object_unref0 (self->priv->registry);
	_g_object_unref0 (self->priv->relevancy_service);
	self->priv->plugin_types = (g_free (self->priv->plugin_types), NULL);
	G_OBJECT_CLASS (synapse_data_sink_parent_class)->finalize (obj);
}

static GType
synapse_data_sink_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDataSinkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_data_sink_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDataSink), 0, (GInstanceInitFunc) synapse_data_sink_instance_init, NULL };
	static const GInterfaceInfo synapse_search_provider_info = { (GInterfaceInitFunc) synapse_data_sink_synapse_search_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_data_sink_type_id;
	synapse_data_sink_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDataSink", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_data_sink_type_id, SYNAPSE_TYPE_SEARCH_PROVIDER, &synapse_search_provider_info);
	SynapseDataSink_private_offset = g_type_add_instance_private (synapse_data_sink_type_id, sizeof (SynapseDataSinkPrivate));
	return synapse_data_sink_type_id;
}

GType
synapse_data_sink_get_type (void)
{
	static volatile gsize synapse_data_sink_type_id__once = 0;
	if (g_once_init_enter (&synapse_data_sink_type_id__once)) {
		GType synapse_data_sink_type_id;
		synapse_data_sink_type_id = synapse_data_sink_get_type_once ();
		g_once_init_leave (&synapse_data_sink_type_id__once, synapse_data_sink_type_id);
	}
	return synapse_data_sink_type_id__once;
}

static void
_vala_synapse_data_sink_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	SynapseDataSink * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DATA_SINK, SynapseDataSink);
	switch (property_id) {
		case SYNAPSE_DATA_SINK_HAS_EMPTY_HANDLERS_PROPERTY:
		g_value_set_boolean (value, synapse_data_sink_get_has_empty_handlers (self));
		break;
		case SYNAPSE_DATA_SINK_HAS_UNKNOWN_HANDLERS_PROPERTY:
		g_value_set_boolean (value, synapse_data_sink_get_has_unknown_handlers (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_synapse_data_sink_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	SynapseDataSink * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DATA_SINK, SynapseDataSink);
	switch (property_id) {
		case SYNAPSE_DATA_SINK_HAS_EMPTY_HANDLERS_PROPERTY:
		synapse_data_sink_set_has_empty_handlers (self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DATA_SINK_HAS_UNKNOWN_HANDLERS_PROPERTY:
		synapse_data_sink_set_has_unknown_handlers (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

