/* SearchItem.c generated by valac 0.56.8, the Vala compiler
 * generated from SearchItem.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 *           2011-2012 Giulio Collura
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "slingshot.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define SLINGSHOT_WIDGETS_SEARCH_ITEM_ICON_SIZE 32

enum  {
	SLINGSHOT_WIDGETS_SEARCH_ITEM_0_PROPERTY,
	SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_PROPERTY,
	SLINGSHOT_WIDGETS_SEARCH_ITEM_SEARCH_TERM_PROPERTY,
	SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_PROPERTY,
	SLINGSHOT_WIDGETS_SEARCH_ITEM_ICON_PROPERTY,
	SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_URI_PROPERTY,
	SLINGSHOT_WIDGETS_SEARCH_ITEM_NUM_PROPERTIES
};
static GParamSpec* slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
enum  {
	SLINGSHOT_WIDGETS_SEARCH_ITEM_LAUNCH_APP_SIGNAL,
	SLINGSHOT_WIDGETS_SEARCH_ITEM_NUM_SIGNALS
};
static guint slingshot_widgets_search_item_signals[SLINGSHOT_WIDGETS_SEARCH_ITEM_NUM_SIGNALS] = {0};

struct _SlingshotWidgetsSearchItemPrivate {
	SlingshotBackendApp* _app;
	gchar* _search_term;
	SlingshotWidgetsSearchItemResultType _result_type;
	GtkImage* _icon;
	gchar* _app_uri;
	SlingshotAppContextMenu* menu;
	GtkLabel* name_label;
	GCancellable* cancellable;
};

static gint SlingshotWidgetsSearchItem_private_offset;
static gpointer slingshot_widgets_search_item_parent_class = NULL;

static gchar* slingshot_widgets_search_item_markup_string_with_search (const gchar* text,
                                                                const gchar* pattern);
static void slingshot_widgets_search_item_real_destroy (GtkWidget* base);
static void slingshot_widgets_search_item_set_icon (SlingshotWidgetsSearchItem* self,
                                             GtkImage* value);
static void slingshot_widgets_search_item_set_app_uri (SlingshotWidgetsSearchItem* self,
                                                const gchar* value);
static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data);
static GObject * slingshot_widgets_search_item_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static gboolean _slingshot_backend_app_launch_slingshot_widgets_search_item_launch_app (SlingshotWidgetsSearchItem* _sender,
                                                                                 gpointer self);
static void slingshot_widgets_search_item_finalize (GObject * obj);
static GType slingshot_widgets_search_item_get_type_once (void);
static void _vala_slingshot_widgets_search_item_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_slingshot_widgets_search_item_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);

static inline gpointer
slingshot_widgets_search_item_get_instance_private (SlingshotWidgetsSearchItem* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotWidgetsSearchItem_private_offset);
}

const gchar*
slingshot_widgets_search_item_result_type_to_string (SlingshotWidgetsSearchItemResultType self)
{
	const gchar* result;
	switch (self) {
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_TEXT:
		{
			result = _ ("Text");
			return result;
		}
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_APPLICATION:
		{
			result = _ ("Applications");
			return result;
		}
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_GENERIC_URI:
		{
			result = _ ("Files");
			return result;
		}
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_LINK:
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_ACTION:
		{
			result = _ ("Actions");
			return result;
		}
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_SEARCH:
		{
			result = _ ("Search");
			return result;
		}
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_CONTACT:
		{
			result = _ ("Contacts");
			return result;
		}
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_INTERNET:
		{
			result = _ ("Internet");
			return result;
		}
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_SETTINGS:
		{
			result = _ ("Settings");
			return result;
		}
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_APP_ACTIONS:
		{
			result = _ ("Application Actions");
			return result;
		}
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_BOOKMARK:
		{
			result = _ ("Bookmarks");
			return result;
		}
		default:
		{
			result = _ ("Other");
			return result;
		}
	}
}

static GType
slingshot_widgets_search_item_result_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_UNKNOWN, "SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_UNKNOWN", "unknown"}, {SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_TEXT, "SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_TEXT", "text"}, {SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_APPLICATION, "SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_APPLICATION", "application"}, {SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_BOOKMARK, "SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_BOOKMARK", "bookmark"}, {SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_APP_ACTIONS, "SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_APP_ACTIONS", "app-actions"}, {SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_ACTION, "SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_ACTION", "action"}, {SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_GENERIC_URI, "SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_GENERIC_URI", "generic-uri"}, {SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_SEARCH, "SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_SEARCH", "search"}, {SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_CONTACT, "SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_CONTACT", "contact"}, {SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_INTERNET, "SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_INTERNET", "internet"}, {SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_SETTINGS, "SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_SETTINGS", "settings"}, {SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_LINK, "SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_LINK", "link"}, {0, NULL, NULL}};
	GType slingshot_widgets_search_item_result_type_type_id;
	slingshot_widgets_search_item_result_type_type_id = g_enum_register_static ("SlingshotWidgetsSearchItemResultType", values);
	return slingshot_widgets_search_item_result_type_type_id;
}

GType
slingshot_widgets_search_item_result_type_get_type (void)
{
	static volatile gsize slingshot_widgets_search_item_result_type_type_id__once = 0;
	if (g_once_init_enter (&slingshot_widgets_search_item_result_type_type_id__once)) {
		GType slingshot_widgets_search_item_result_type_type_id;
		slingshot_widgets_search_item_result_type_type_id = slingshot_widgets_search_item_result_type_get_type_once ();
		g_once_init_leave (&slingshot_widgets_search_item_result_type_type_id__once, slingshot_widgets_search_item_result_type_type_id);
	}
	return slingshot_widgets_search_item_result_type_type_id__once;
}

SlingshotWidgetsSearchItem*
slingshot_widgets_search_item_construct (GType object_type,
                                         SlingshotBackendApp* app,
                                         const gchar* search_term,
                                         SlingshotWidgetsSearchItemResultType result_type)
{
	SlingshotWidgetsSearchItem * self = NULL;
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (search_term != NULL, NULL);
	self = (SlingshotWidgetsSearchItem*) g_object_new (object_type, "app", app, "search-term", search_term, "result-type", result_type, NULL);
	return self;
}

SlingshotWidgetsSearchItem*
slingshot_widgets_search_item_new (SlingshotBackendApp* app,
                                   const gchar* search_term,
                                   SlingshotWidgetsSearchItemResultType result_type)
{
	return slingshot_widgets_search_item_construct (SLINGSHOT_WIDGETS_TYPE_SEARCH_ITEM, app, search_term, result_type);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
slingshot_widgets_search_item_markup_string_with_search (const gchar* text,
                                                         const gchar* pattern)
{
	static const char MARKUP[] = "%s";
	GeeList* matchers = NULL;
	GeeList* _tmp8_;
	gchar* highlighted = NULL;
	const gchar* _tmp49_;
	gchar* result;
	g_return_val_if_fail (text != NULL, NULL);
	g_return_val_if_fail (pattern != NULL, NULL);
	if (g_strcmp0 (pattern, "") == 0) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = g_markup_escape_text (text, (gssize) -1);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strdup_printf (MARKUP, _tmp1_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		result = _tmp3_;
		return result;
	}
	if (g_strcmp0 (text, "") == 0) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = g_markup_escape_text (pattern, (gssize) -1);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf (MARKUP, _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		result = _tmp7_;
		return result;
	}
	_tmp8_ = synapse_query_get_matchers_for_query (pattern, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
	matchers = _tmp8_;
	highlighted = NULL;
	{
		GeeList* _matcher_list = NULL;
		GeeList* _tmp9_;
		gint _matcher_size = 0;
		GeeList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _matcher_index = 0;
		_tmp9_ = matchers;
		_matcher_list = _tmp9_;
		_tmp10_ = _matcher_list;
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_matcher_size = _tmp12_;
		_matcher_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			GeeMapEntry* matcher = NULL;
			GeeList* _tmp15_;
			gpointer _tmp16_;
			GMatchInfo* mi = NULL;
			GeeMapEntry* _tmp17_;
			gconstpointer _tmp18_;
			gconstpointer _tmp19_;
			GMatchInfo* _tmp20_ = NULL;
			gboolean _tmp21_;
			_matcher_index = _matcher_index + 1;
			_tmp13_ = _matcher_index;
			_tmp14_ = _matcher_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _matcher_list;
			_tmp16_ = gee_list_get (_tmp15_, _matcher_index);
			matcher = (GeeMapEntry*) _tmp16_;
			_tmp17_ = matcher;
			_tmp18_ = gee_map_entry_get_key (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp21_ = g_regex_match ((GRegex*) _tmp19_, text, 0, &_tmp20_);
			_g_match_info_unref0 (mi);
			mi = _tmp20_;
			if (_tmp21_) {
				gint start_pos = 0;
				gint end_pos = 0;
				gint last_pos = 0;
				gint cnt = 0;
				GMatchInfo* _tmp22_;
				GString* res = NULL;
				GString* _tmp23_;
				GString* _tmp46_;
				const gchar* _tmp47_;
				gchar* _tmp48_;
				last_pos = 0;
				_tmp22_ = mi;
				cnt = g_match_info_get_match_count (_tmp22_);
				_tmp23_ = g_string_new ("");
				res = _tmp23_;
				{
					gint i = 0;
					i = 1;
					{
						gboolean _tmp24_ = FALSE;
						_tmp24_ = TRUE;
						while (TRUE) {
							GMatchInfo* _tmp26_;
							gint _tmp27_ = 0;
							gint _tmp28_ = 0;
							gboolean _tmp29_ = FALSE;
							GString* _tmp30_;
							gchar* _tmp31_;
							gchar* _tmp32_;
							gchar* _tmp33_;
							gchar* _tmp34_;
							GString* _tmp35_;
							GMatchInfo* _tmp36_;
							gchar* _tmp37_;
							gchar* _tmp38_;
							gchar* _tmp39_;
							gchar* _tmp40_;
							if (!_tmp24_) {
								gint _tmp25_;
								_tmp25_ = i;
								i = _tmp25_ + 1;
							}
							_tmp24_ = FALSE;
							if (!(i < cnt)) {
								break;
							}
							_tmp26_ = mi;
							g_match_info_fetch_pos (_tmp26_, i, &_tmp27_, &_tmp28_);
							start_pos = _tmp27_;
							end_pos = _tmp28_;
							if (start_pos >= 0) {
								_tmp29_ = end_pos >= 0;
							} else {
								_tmp29_ = FALSE;
							}
							g_warn_if_fail (_tmp29_);
							_tmp30_ = res;
							_tmp31_ = string_substring (text, (glong) last_pos, (glong) (start_pos - last_pos));
							_tmp32_ = _tmp31_;
							_tmp33_ = g_markup_escape_text (_tmp32_, (gssize) -1);
							_tmp34_ = _tmp33_;
							g_string_append (_tmp30_, _tmp34_);
							_g_free0 (_tmp34_);
							_g_free0 (_tmp32_);
							last_pos = end_pos;
							_tmp35_ = res;
							_tmp36_ = mi;
							_tmp37_ = g_match_info_fetch (_tmp36_, i);
							_tmp38_ = _tmp37_;
							_tmp39_ = g_markup_printf_escaped ("<b>%s</b>", _tmp38_);
							_tmp40_ = _tmp39_;
							g_string_append (_tmp35_, _tmp40_);
							_g_free0 (_tmp40_);
							_g_free0 (_tmp38_);
							if (i == (cnt - 1)) {
								GString* _tmp41_;
								gchar* _tmp42_;
								gchar* _tmp43_;
								gchar* _tmp44_;
								gchar* _tmp45_;
								_tmp41_ = res;
								_tmp42_ = string_substring (text, (glong) last_pos, (glong) -1);
								_tmp43_ = _tmp42_;
								_tmp44_ = g_markup_escape_text (_tmp43_, (gssize) -1);
								_tmp45_ = _tmp44_;
								g_string_append (_tmp41_, _tmp45_);
								_g_free0 (_tmp45_);
								_g_free0 (_tmp43_);
							}
						}
					}
				}
				_tmp46_ = res;
				_tmp47_ = _tmp46_->str;
				_tmp48_ = g_strdup (_tmp47_);
				_g_free0 (highlighted);
				highlighted = _tmp48_;
				_g_string_free0 (res);
				_g_match_info_unref0 (mi);
				_g_object_unref0 (matcher);
				break;
			}
			_g_match_info_unref0 (mi);
			_g_object_unref0 (matcher);
		}
	}
	_tmp49_ = highlighted;
	if (_tmp49_ != NULL) {
		const gchar* _tmp50_;
		gchar* _tmp51_;
		_tmp50_ = highlighted;
		_tmp51_ = g_strdup_printf (MARKUP, _tmp50_);
		result = _tmp51_;
		_g_free0 (highlighted);
		_g_object_unref0 (matchers);
		return result;
	} else {
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		_tmp52_ = g_markup_escape_text (text, (gssize) -1);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_strdup_printf (MARKUP, _tmp53_);
		_tmp55_ = _tmp54_;
		_g_free0 (_tmp53_);
		result = _tmp55_;
		_g_free0 (highlighted);
		_g_object_unref0 (matchers);
		return result;
	}
}

static void
slingshot_widgets_search_item_real_destroy (GtkWidget* base)
{
	SlingshotWidgetsSearchItem * self;
	GCancellable* _tmp0_;
	self = (SlingshotWidgetsSearchItem*) base;
	GTK_WIDGET_CLASS (slingshot_widgets_search_item_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow));
	_tmp0_ = self->priv->cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
	}
}

gboolean
slingshot_widgets_search_item_create_context_menu (SlingshotWidgetsSearchItem* self,
                                                   GdkEvent* e)
{
	SlingshotWidgetsSearchItemResultType _tmp0_;
	SlingshotBackendApp* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	SlingshotBackendApp* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	SlingshotAppContextMenu* _tmp7_;
	SlingshotAppContextMenu* _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
	gboolean _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->priv->_result_type;
	if (_tmp0_ != SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_APPLICATION) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp1_ = self->priv->_app;
	_tmp2_ = slingshot_backend_app_get_desktop_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_app;
	_tmp5_ = slingshot_backend_app_get_desktop_path (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = slingshot_app_context_menu_new (_tmp3_, _tmp6_);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->menu);
	self->priv->menu = _tmp7_;
	_tmp8_ = self->priv->menu;
	_tmp9_ = gtk_container_get_children ((GtkContainer*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_ != NULL;
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (g_list_free (_tmp10_), NULL));
	if (_tmp11_) {
		if (e->type == GDK_KEY_PRESS) {
			SlingshotAppContextMenu* _tmp12_;
			_tmp12_ = self->priv->menu;
			gtk_menu_popup_at_widget ((GtkMenu*) _tmp12_, (GtkWidget*) self, GDK_GRAVITY_EAST, GDK_GRAVITY_CENTER, e);
			result = GDK_EVENT_STOP;
			return result;
		} else {
			if (e->type == GDK_BUTTON_PRESS) {
				SlingshotAppContextMenu* _tmp13_;
				_tmp13_ = self->priv->menu;
				gtk_menu_popup_at_pointer ((GtkMenu*) _tmp13_, e);
				result = GDK_EVENT_STOP;
				return result;
			}
		}
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

SlingshotBackendApp*
slingshot_widgets_search_item_get_app (SlingshotWidgetsSearchItem* self)
{
	SlingshotBackendApp* result;
	SlingshotBackendApp* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
slingshot_widgets_search_item_set_app (SlingshotWidgetsSearchItem* self,
                                       SlingshotBackendApp* value)
{
	SlingshotBackendApp* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_widgets_search_item_get_app (self);
	if (old_value != value) {
		SlingshotBackendApp* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app);
		self->priv->_app = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_PROPERTY]);
	}
}

const gchar*
slingshot_widgets_search_item_get_search_term (SlingshotWidgetsSearchItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_search_term;
	result = _tmp0_;
	return result;
}

static void
slingshot_widgets_search_item_set_search_term (SlingshotWidgetsSearchItem* self,
                                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_widgets_search_item_get_search_term (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_search_term);
		self->priv->_search_term = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_SEARCH_TERM_PROPERTY]);
	}
}

SlingshotWidgetsSearchItemResultType
slingshot_widgets_search_item_get_result_type (SlingshotWidgetsSearchItem* self)
{
	SlingshotWidgetsSearchItemResultType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_result_type;
	return result;
}

static void
slingshot_widgets_search_item_set_result_type (SlingshotWidgetsSearchItem* self,
                                               SlingshotWidgetsSearchItemResultType value)
{
	SlingshotWidgetsSearchItemResultType old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_widgets_search_item_get_result_type (self);
	if (old_value != value) {
		self->priv->_result_type = value;
		g_object_notify_by_pspec ((GObject *) self, slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_PROPERTY]);
	}
}

GtkImage*
slingshot_widgets_search_item_get_icon (SlingshotWidgetsSearchItem* self)
{
	GtkImage* result;
	GtkImage* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

static void
slingshot_widgets_search_item_set_icon (SlingshotWidgetsSearchItem* self,
                                        GtkImage* value)
{
	GtkImage* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_widgets_search_item_get_icon (self);
	if (old_value != value) {
		GtkImage* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_ICON_PROPERTY]);
	}
}

const gchar*
slingshot_widgets_search_item_get_app_uri (SlingshotWidgetsSearchItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_uri;
	result = _tmp0_;
	return result;
}

static void
slingshot_widgets_search_item_set_app_uri (SlingshotWidgetsSearchItem* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_widgets_search_item_get_app_uri (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_app_uri);
		self->priv->_app_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_URI_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_BOOLEAN__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_set_boolean (return_value, v_return);
}

static gboolean
_slingshot_backend_app_launch_slingshot_widgets_search_item_launch_app (SlingshotWidgetsSearchItem* _sender,
                                                                        gpointer self)
{
	gboolean result;
	result = slingshot_backend_app_launch ((SlingshotBackendApp*) self);
	return result;
}

static GObject *
slingshot_widgets_search_item_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotWidgetsSearchItem * self;
	gchar* markup = NULL;
	SlingshotWidgetsSearchItemResultType _tmp0_;
	const gchar* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	GtkImage* _tmp25_;
	GtkImage* _tmp26_;
	GtkImage* _tmp27_;
	SlingshotBackendApp* _tmp28_;
	GIcon* _tmp29_;
	GIcon* _tmp30_;
	GtkImage* _tmp31_;
	SlingshotBackendApp* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	gboolean _tmp35_ = FALSE;
	SlingshotBackendApp* _tmp36_;
	SynapseMatch* _tmp37_;
	SynapseMatch* _tmp38_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp51_;
	GtkGrid* _tmp52_;
	GtkGrid* _tmp53_;
	GtkImage* _tmp54_;
	GtkGrid* _tmp55_;
	GtkLabel* _tmp56_;
	GtkGrid* _tmp57_;
	GtkGrid* _tmp58_;
	GtkGrid* _tmp59_;
	SlingshotWidgetsSearchItemResultType _tmp60_;
	SynapseApplicationMatch* app_match = NULL;
	SlingshotBackendApp* _tmp62_;
	SynapseMatch* _tmp63_;
	SynapseMatch* _tmp64_;
	SynapseApplicationMatch* _tmp65_;
	gboolean _tmp66_ = FALSE;
	SynapseApplicationMatch* _tmp67_;
	parent_class = G_OBJECT_CLASS (slingshot_widgets_search_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_WIDGETS_TYPE_SEARCH_ITEM, SlingshotWidgetsSearchItem);
	_tmp0_ = self->priv->_result_type;
	if (_tmp0_ == SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_TEXT) {
		SlingshotBackendApp* _tmp1_;
		SynapseMatch* _tmp2_;
		SynapseMatch* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp1_ = self->priv->_app;
		_tmp2_ = slingshot_backend_app_get_match (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = synapse_match_get_title (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (markup);
		markup = _tmp6_;
	} else {
		SlingshotWidgetsSearchItemResultType _tmp7_;
		_tmp7_ = self->priv->_result_type;
		if (_tmp7_ == SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_APP_ACTIONS) {
			SlingshotBackendApp* _tmp8_;
			SynapseMatch* _tmp9_;
			SynapseMatch* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp8_ = self->priv->_app;
			_tmp9_ = slingshot_backend_app_get_match (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = synapse_match_get_title (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = self->priv->_search_term;
			_tmp14_ = slingshot_widgets_search_item_markup_string_with_search (_tmp12_, _tmp13_);
			_g_free0 (markup);
			markup = _tmp14_;
		} else {
			SlingshotBackendApp* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp15_ = self->priv->_app;
			_tmp16_ = slingshot_backend_app_get_name (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = self->priv->_search_term;
			_tmp19_ = slingshot_widgets_search_item_markup_string_with_search (_tmp17_, _tmp18_);
			_g_free0 (markup);
			markup = _tmp19_;
		}
	}
	_tmp20_ = markup;
	_tmp21_ = (GtkLabel*) gtk_label_new (_tmp20_);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->name_label);
	self->priv->name_label = _tmp21_;
	_tmp22_ = self->priv->name_label;
	gtk_label_set_ellipsize (_tmp22_, PANGO_ELLIPSIZE_END);
	_tmp23_ = self->priv->name_label;
	gtk_label_set_use_markup (_tmp23_, TRUE);
	_tmp24_ = self->priv->name_label;
	gtk_label_set_xalign (_tmp24_, (gfloat) 0);
	_tmp25_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp25_);
	_tmp26_ = _tmp25_;
	slingshot_widgets_search_item_set_icon (self, _tmp26_);
	_g_object_unref0 (_tmp26_);
	_tmp27_ = self->priv->_icon;
	_tmp28_ = self->priv->_app;
	_tmp29_ = slingshot_backend_app_get_icon (_tmp28_);
	_tmp30_ = _tmp29_;
	g_object_set (_tmp27_, "gicon", _tmp30_, NULL);
	_tmp31_ = self->priv->_icon;
	gtk_image_set_pixel_size (_tmp31_, SLINGSHOT_WIDGETS_SEARCH_ITEM_ICON_SIZE);
	_tmp32_ = self->priv->_app;
	_tmp33_ = slingshot_backend_app_get_description (_tmp32_);
	_tmp34_ = _tmp33_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) self, _tmp34_);
	_tmp36_ = self->priv->_app;
	_tmp37_ = slingshot_backend_app_get_match (_tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp38_ != NULL) {
		SlingshotBackendApp* _tmp39_;
		SynapseMatch* _tmp40_;
		SynapseMatch* _tmp41_;
		const gchar* _tmp42_;
		const gchar* _tmp43_;
		_tmp39_ = self->priv->_app;
		_tmp40_ = slingshot_backend_app_get_match (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = synapse_match_get_icon_name (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp35_ = g_str_has_prefix (_tmp43_, G_DIR_SEPARATOR_S);
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		GdkPixbuf* pixbuf = NULL;
		SlingshotBackendApp* _tmp44_;
		SynapseMatch* _tmp45_;
		SynapseMatch* _tmp46_;
		GdkPixbuf* _tmp47_;
		GdkPixbuf* _tmp48_;
		_tmp44_ = self->priv->_app;
		_tmp45_ = slingshot_backend_app_get_match (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = slingshot_backend_synapse_search_get_pathicon_for_match (_tmp46_, SLINGSHOT_WIDGETS_SEARCH_ITEM_ICON_SIZE);
		pixbuf = _tmp47_;
		_tmp48_ = pixbuf;
		if (_tmp48_ != NULL) {
			GtkImage* _tmp49_;
			GdkPixbuf* _tmp50_;
			_tmp49_ = self->priv->_icon;
			_tmp50_ = pixbuf;
			gtk_image_set_from_pixbuf (_tmp49_, _tmp50_);
		}
		_g_object_unref0 (pixbuf);
	}
	_tmp51_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp51_);
	grid = _tmp51_;
	_tmp52_ = grid;
	gtk_grid_set_column_spacing (_tmp52_, 12);
	_tmp53_ = grid;
	_tmp54_ = self->priv->_icon;
	gtk_container_add ((GtkContainer*) _tmp53_, (GtkWidget*) _tmp54_);
	_tmp55_ = grid;
	_tmp56_ = self->priv->name_label;
	gtk_container_add ((GtkContainer*) _tmp55_, (GtkWidget*) _tmp56_);
	_tmp57_ = grid;
	g_object_set ((GtkWidget*) _tmp57_, "margin", 6, NULL);
	_tmp58_ = grid;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp58_, 18);
	_tmp59_ = grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp59_);
	_tmp60_ = self->priv->_result_type;
	if (_tmp60_ != SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_APP_ACTIONS) {
		SlingshotBackendApp* _tmp61_;
		_tmp61_ = self->priv->_app;
		g_signal_connect_object (self, "launch-app", (GCallback) _slingshot_backend_app_launch_slingshot_widgets_search_item_launch_app, _tmp61_, 0);
	}
	slingshot_widgets_search_item_set_app_uri (self, NULL);
	_tmp62_ = self->priv->_app;
	_tmp63_ = slingshot_backend_app_get_match (_tmp62_);
	_tmp64_ = _tmp63_;
	_tmp65_ = _g_object_ref0 (SYNAPSE_IS_APPLICATION_MATCH (_tmp64_) ? ((SynapseApplicationMatch*) _tmp64_) : NULL);
	app_match = _tmp65_;
	_tmp67_ = app_match;
	if (_tmp67_ != NULL) {
		SynapseApplicationMatch* _tmp68_;
		const gchar* _tmp69_;
		const gchar* _tmp70_;
		_tmp68_ = app_match;
		_tmp69_ = synapse_application_match_get_filename (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp66_ = _tmp70_ != NULL;
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		SynapseApplicationMatch* _tmp71_;
		const gchar* _tmp72_;
		const gchar* _tmp73_;
		GFile* _tmp74_;
		GFile* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		_tmp71_ = app_match;
		_tmp72_ = synapse_application_match_get_filename (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = g_file_new_for_path (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = g_file_get_uri (_tmp75_);
		_tmp77_ = _tmp76_;
		slingshot_widgets_search_item_set_app_uri (self, _tmp77_);
		_g_free0 (_tmp77_);
		_g_object_unref0 (_tmp75_);
	}
	_g_object_unref0 (app_match);
	_g_object_unref0 (grid);
	_g_free0 (markup);
	return obj;
}

static void
slingshot_widgets_search_item_class_init (SlingshotWidgetsSearchItemClass * klass,
                                          gpointer klass_data)
{
	slingshot_widgets_search_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotWidgetsSearchItem_private_offset);
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget*)) slingshot_widgets_search_item_real_destroy;
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_widgets_search_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_widgets_search_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = slingshot_widgets_search_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_widgets_search_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_PROPERTY, slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_PROPERTY] = g_param_spec_object ("app", "app", "app", SLINGSHOT_BACKEND_TYPE_APP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_WIDGETS_SEARCH_ITEM_SEARCH_TERM_PROPERTY, slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_SEARCH_TERM_PROPERTY] = g_param_spec_string ("search-term", "search-term", "search-term", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_PROPERTY, slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_PROPERTY] = g_param_spec_enum ("result-type", "result-type", "result-type", SLINGSHOT_WIDGETS_SEARCH_ITEM_TYPE_RESULT_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_WIDGETS_SEARCH_ITEM_ICON_PROPERTY, slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", gtk_image_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_URI_PROPERTY, slingshot_widgets_search_item_properties[SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_URI_PROPERTY] = g_param_spec_string ("app-uri", "app-uri", "app-uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	slingshot_widgets_search_item_signals[SLINGSHOT_WIDGETS_SEARCH_ITEM_LAUNCH_APP_SIGNAL] = g_signal_new ("launch-app", SLINGSHOT_WIDGETS_TYPE_SEARCH_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
}

static void
slingshot_widgets_search_item_instance_init (SlingshotWidgetsSearchItem * self,
                                             gpointer klass)
{
	self->priv = slingshot_widgets_search_item_get_instance_private (self);
	self->priv->cancellable = NULL;
}

static void
slingshot_widgets_search_item_finalize (GObject * obj)
{
	SlingshotWidgetsSearchItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_WIDGETS_TYPE_SEARCH_ITEM, SlingshotWidgetsSearchItem);
	_g_object_unref0 (self->priv->_app);
	_g_free0 (self->priv->_search_term);
	_g_object_unref0 (self->priv->_icon);
	_g_free0 (self->priv->_app_uri);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (slingshot_widgets_search_item_parent_class)->finalize (obj);
}

static GType
slingshot_widgets_search_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotWidgetsSearchItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_widgets_search_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotWidgetsSearchItem), 0, (GInstanceInitFunc) slingshot_widgets_search_item_instance_init, NULL };
	GType slingshot_widgets_search_item_type_id;
	slingshot_widgets_search_item_type_id = g_type_register_static (gtk_list_box_row_get_type (), "SlingshotWidgetsSearchItem", &g_define_type_info, 0);
	SlingshotWidgetsSearchItem_private_offset = g_type_add_instance_private (slingshot_widgets_search_item_type_id, sizeof (SlingshotWidgetsSearchItemPrivate));
	return slingshot_widgets_search_item_type_id;
}

GType
slingshot_widgets_search_item_get_type (void)
{
	static volatile gsize slingshot_widgets_search_item_type_id__once = 0;
	if (g_once_init_enter (&slingshot_widgets_search_item_type_id__once)) {
		GType slingshot_widgets_search_item_type_id;
		slingshot_widgets_search_item_type_id = slingshot_widgets_search_item_get_type_once ();
		g_once_init_leave (&slingshot_widgets_search_item_type_id__once, slingshot_widgets_search_item_type_id);
	}
	return slingshot_widgets_search_item_type_id__once;
}

static void
_vala_slingshot_widgets_search_item_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	SlingshotWidgetsSearchItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_WIDGETS_TYPE_SEARCH_ITEM, SlingshotWidgetsSearchItem);
	switch (property_id) {
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_PROPERTY:
		g_value_set_object (value, slingshot_widgets_search_item_get_app (self));
		break;
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_SEARCH_TERM_PROPERTY:
		g_value_set_string (value, slingshot_widgets_search_item_get_search_term (self));
		break;
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_PROPERTY:
		g_value_set_enum (value, slingshot_widgets_search_item_get_result_type (self));
		break;
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_ICON_PROPERTY:
		g_value_set_object (value, slingshot_widgets_search_item_get_icon (self));
		break;
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_URI_PROPERTY:
		g_value_set_string (value, slingshot_widgets_search_item_get_app_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_widgets_search_item_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	SlingshotWidgetsSearchItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_WIDGETS_TYPE_SEARCH_ITEM, SlingshotWidgetsSearchItem);
	switch (property_id) {
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_PROPERTY:
		slingshot_widgets_search_item_set_app (self, g_value_get_object (value));
		break;
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_SEARCH_TERM_PROPERTY:
		slingshot_widgets_search_item_set_search_term (self, g_value_get_string (value));
		break;
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_PROPERTY:
		slingshot_widgets_search_item_set_result_type (self, g_value_get_enum (value));
		break;
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_ICON_PROPERTY:
		slingshot_widgets_search_item_set_icon (self, g_value_get_object (value));
		break;
		case SLINGSHOT_WIDGETS_SEARCH_ITEM_APP_URI_PROPERTY:
		slingshot_widgets_search_item_set_app_uri (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

