/* AppContextMenu.c generated by valac 0.56.8, the Vala compiler
 * generated from AppContextMenu.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 * Copyright 2020-2021 Justin Haygood
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "slingshot.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gdesktopappinfo.h>
#include <gtk/gtk.h>
#include <plank.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <granite.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>

enum  {
	SLINGSHOT_APP_CONTEXT_MENU_0_PROPERTY,
	SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_ID_PROPERTY,
	SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_PATH_PROPERTY,
	SLINGSHOT_APP_CONTEXT_MENU_NUM_PROPERTIES
};
static GParamSpec* slingshot_app_context_menu_properties[SLINGSHOT_APP_CONTEXT_MENU_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SlingshotAppContextMenuOnAppcenterDbusChangedData SlingshotAppContextMenuOnAppcenterDbusChangedData;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
enum  {
	SLINGSHOT_APP_CONTEXT_MENU_APP_LAUNCHED_SIGNAL,
	SLINGSHOT_APP_CONTEXT_MENU_NUM_SIGNALS
};
static guint slingshot_app_context_menu_signals[SLINGSHOT_APP_CONTEXT_MENU_NUM_SIGNALS] = {0};

struct _SlingshotAppContextMenuPrivate {
	gchar* _desktop_id;
	gchar* _desktop_path;
	GDesktopAppInfo* app_info;
	gboolean has_system_item;
	gchar* appstream_comp_id;
	SlingshotBackendSwitcherooControl* switcheroo_control;
	GtkMenuItem* uninstall_menuitem;
	GtkMenuItem* appcenter_menuitem;
	gboolean docked;
};

struct _Block7Data {
	int _ref_count_;
	SlingshotAppContextMenu* self;
	SlingshotBackendAppCenter* appcenter;
};

struct _SlingshotAppContextMenuOnAppcenterDbusChangedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SlingshotAppContextMenu* self;
	SlingshotBackendAppCenter* appcenter;
	AppCenterDBus* _tmp0_;
	AppCenterDBus* _tmp1_;
	gchar* _tmp2_;
	AppCenterDBus* _tmp3_;
	AppCenterDBus* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError* e;
	gchar* _tmp8_;
	GError* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GtkMenuItem* _tmp12_;
	const gchar* _tmp13_;
	GtkMenuItem* _tmp14_;
	const gchar* _tmp15_;
	GError* _inner_error0_;
};

struct _Block8Data {
	int _ref_count_;
	SlingshotAppContextMenu* self;
	gchar* action;
};

struct _Block9Data {
	int _ref_count_;
	SlingshotAppContextMenu* self;
	gboolean prefers_non_default_gpu;
};

struct _Block10Data {
	int _ref_count_;
	SlingshotAppContextMenu* self;
	SlingshotBackendAppCenter* appcenter;
};

static gint SlingshotAppContextMenu_private_offset;
static gpointer slingshot_app_context_menu_parent_class = NULL;
static PlankDBusClient* slingshot_app_context_menu_plank_client;
static PlankDBusClient* slingshot_app_context_menu_plank_client = NULL;

static void slingshot_app_context_menu_uninstall_menuitem_activate (SlingshotAppContextMenu* self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda28_ (Block7Data* _data7_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda28__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void slingshot_app_context_menu_open_in_appcenter (SlingshotAppContextMenu* self);
static void __lambda29_ (SlingshotAppContextMenu* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda29__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void slingshot_app_context_menu_on_appcenter_dbus_changed_data_free (gpointer _data);
static void slingshot_app_context_menu_on_appcenter_dbus_changed (SlingshotAppContextMenu* self,
                                                           SlingshotBackendAppCenter* appcenter,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
static void slingshot_app_context_menu_on_appcenter_dbus_changed_finish (SlingshotAppContextMenu* self,
                                                                  GAsyncResult* _res_);
static gboolean slingshot_app_context_menu_on_appcenter_dbus_changed_co (SlingshotAppContextMenuOnAppcenterDbusChangedData* _data_);
static void slingshot_app_context_menu_on_appcenter_dbus_changed_ready (GObject* source_object,
                                                                 GAsyncResult* _res_,
                                                                 gpointer _user_data_);
static void slingshot_app_context_menu_plank_menuitem_activate (SlingshotAppContextMenu* self);
static gchar* slingshot_app_context_menu_get_desktop_uri (SlingshotAppContextMenu* self);
static GObject * slingshot_app_context_menu_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void _slingshot_app_context_menu_____lambda30_ (Block8Data* _data8_,
                                                GtkMenuItem* target);
static void __slingshot_app_context_menu_____lambda30__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                        gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void _slingshot_app_context_menu____lambda31_ (Block9Data* _data9_,
                                               GtkMenuItem* target);
static void __slingshot_app_context_menu____lambda31__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                       gpointer self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _slingshot_app_context_menu_plank_menuitem_activate_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                                 gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void _slingshot_app_context_menu_uninstall_menuitem_activate_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                                     gpointer self);
static void _slingshot_app_context_menu_open_in_appcenter_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                           gpointer self);
static void _slingshot_app_context_menu____lambda32_ (Block10Data* _data10_);
static void __slingshot_app_context_menu____lambda32__g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void slingshot_app_context_menu_finalize (GObject * obj);
static GType slingshot_app_context_menu_get_type_once (void);
static void _vala_slingshot_app_context_menu_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_slingshot_app_context_menu_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static gssize _vala_array_length (gpointer array);

static inline gpointer
slingshot_app_context_menu_get_instance_private (SlingshotAppContextMenu* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotAppContextMenu_private_offset);
}

SlingshotAppContextMenu*
slingshot_app_context_menu_construct (GType object_type,
                                      const gchar* desktop_id,
                                      const gchar* desktop_path)
{
	SlingshotAppContextMenu * self = NULL;
	g_return_val_if_fail (desktop_id != NULL, NULL);
	g_return_val_if_fail (desktop_path != NULL, NULL);
	self = (SlingshotAppContextMenu*) g_object_new (object_type, "desktop-id", desktop_id, "desktop-path", desktop_path, NULL);
	return self;
}

SlingshotAppContextMenu*
slingshot_app_context_menu_new (const gchar* desktop_id,
                                const gchar* desktop_path)
{
	return slingshot_app_context_menu_construct (SLINGSHOT_TYPE_APP_CONTEXT_MENU, desktop_id, desktop_path);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		SlingshotAppContextMenu* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->appcenter);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda28_ (Block7Data* _data7_,
             GObject* obj,
             GAsyncResult* res)
{
	SlingshotAppContextMenu* self;
	GError* _inner_error0_ = NULL;
	self = _data7_->self;
	g_return_if_fail (res != NULL);
	{
		SlingshotBackendAppCenter* _tmp0_;
		AppCenterDBus* _tmp1_;
		AppCenterDBus* _tmp2_;
		_tmp0_ = _data7_->appcenter;
		_tmp1_ = slingshot_backend_app_center_get_dbus (_tmp0_);
		_tmp2_ = _tmp1_;
		app_center_dbus_uninstall_finish (_tmp2_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("AppContextMenu.vala:161: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda28__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda28_ (self, source_object, res);
	block7_data_unref (self);
}

static void
slingshot_app_context_menu_uninstall_menuitem_activate (SlingshotAppContextMenu* self)
{
	Block7Data* _data7_;
	SlingshotBackendAppCenter* _tmp0_;
	SlingshotBackendAppCenter* _tmp1_;
	gboolean _tmp2_ = FALSE;
	SlingshotBackendAppCenter* _tmp3_;
	AppCenterDBus* _tmp4_;
	AppCenterDBus* _tmp5_;
	SlingshotBackendAppCenter* _tmp7_;
	AppCenterDBus* _tmp8_;
	AppCenterDBus* _tmp9_;
	const gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = slingshot_backend_app_center_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data7_->appcenter = _tmp1_;
	_tmp3_ = _data7_->appcenter;
	_tmp4_ = slingshot_backend_app_center_get_dbus (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = self->priv->appstream_comp_id;
		_tmp2_ = g_strcmp0 (_tmp6_, "") == 0;
	}
	if (_tmp2_) {
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return;
	}
	g_signal_emit (self, slingshot_app_context_menu_signals[SLINGSHOT_APP_CONTEXT_MENU_APP_LAUNCHED_SIGNAL], 0);
	_tmp7_ = _data7_->appcenter;
	_tmp8_ = slingshot_backend_app_center_get_dbus (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->appstream_comp_id;
	app_center_dbus_uninstall (_tmp9_, _tmp10_, ___lambda28__gasync_ready_callback, block7_data_ref (_data7_));
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static void
__lambda29_ (SlingshotAppContextMenu* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		g_app_info_launch_default_for_uri_finish (res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GraniteMessageDialog* message_dialog = NULL;
		GDesktopAppInfo* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GraniteMessageDialog* _tmp4_;
		GraniteMessageDialog* _tmp5_;
		GraniteMessageDialog* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		GraniteMessageDialog* _tmp9_;
		GraniteMessageDialog* _tmp10_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = self->priv->app_info;
		_tmp1_ = g_app_info_get_display_name ((GAppInfo*) _tmp0_);
		_tmp2_ = g_strdup_printf ("Unable to open %s in AppCenter", _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = granite_message_dialog_new_with_image_from_icon_name (_tmp3_, "", "dialog-error", GTK_BUTTONS_CLOSE);
		g_object_ref_sink (_tmp4_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		message_dialog = _tmp5_;
		_tmp6_ = message_dialog;
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		granite_message_dialog_show_error_details (_tmp6_, _tmp8_);
		_tmp9_ = message_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp9_);
		_tmp10_ = message_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp10_);
		_g_object_unref0 (message_dialog);
		_g_error_free0 (_error_);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		g_signal_emit (self, slingshot_app_context_menu_signals[SLINGSHOT_APP_CONTEXT_MENU_APP_LAUNCHED_SIGNAL], 0);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda29__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda29_ ((SlingshotAppContextMenu*) self, source_object, res);
	g_object_unref (self);
}

static void
slingshot_app_context_menu_open_in_appcenter (SlingshotAppContextMenu* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->appstream_comp_id;
	_tmp1_ = g_strconcat ("appstream://", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	g_app_info_launch_default_for_uri_async (_tmp2_, NULL, NULL, ___lambda29__gasync_ready_callback, g_object_ref (self));
	_g_free0 (_tmp2_);
}

static void
slingshot_app_context_menu_on_appcenter_dbus_changed_data_free (gpointer _data)
{
	SlingshotAppContextMenuOnAppcenterDbusChangedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->appcenter);
	_g_object_unref0 (_data_->self);
	g_slice_free (SlingshotAppContextMenuOnAppcenterDbusChangedData, _data_);
}

static void
slingshot_app_context_menu_on_appcenter_dbus_changed (SlingshotAppContextMenu* self,
                                                      SlingshotBackendAppCenter* appcenter,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	SlingshotAppContextMenuOnAppcenterDbusChangedData* _data_;
	SlingshotAppContextMenu* _tmp0_;
	SlingshotBackendAppCenter* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (appcenter != NULL);
	_data_ = g_slice_new0 (SlingshotAppContextMenuOnAppcenterDbusChangedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, slingshot_app_context_menu_on_appcenter_dbus_changed_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (appcenter);
	_g_object_unref0 (_data_->appcenter);
	_data_->appcenter = _tmp1_;
	slingshot_app_context_menu_on_appcenter_dbus_changed_co (_data_);
}

static void
slingshot_app_context_menu_on_appcenter_dbus_changed_finish (SlingshotAppContextMenu* self,
                                                             GAsyncResult* _res_)
{
	SlingshotAppContextMenuOnAppcenterDbusChangedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
slingshot_app_context_menu_on_appcenter_dbus_changed_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_)
{
	SlingshotAppContextMenuOnAppcenterDbusChangedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	slingshot_app_context_menu_on_appcenter_dbus_changed_co (_data_);
}

static gboolean
slingshot_app_context_menu_on_appcenter_dbus_changed_co (SlingshotAppContextMenuOnAppcenterDbusChangedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = slingshot_backend_app_center_get_dbus (_data_->appcenter);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_ != NULL) {
		{
			_data_->_tmp3_ = slingshot_backend_app_center_get_dbus (_data_->appcenter);
			_data_->_tmp4_ = _data_->_tmp3_;
			_data_->_tmp5_ = _data_->self->priv->_desktop_id;
			_data_->_state_ = 1;
			app_center_dbus_get_component_from_desktop_id (_data_->_tmp4_, _data_->_tmp5_, slingshot_app_context_menu_on_appcenter_dbus_changed_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp6_ = app_center_dbus_get_component_from_desktop_id_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp2_ = _data_->_tmp6_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp7_ = _data_->_tmp2_;
			_data_->_tmp2_ = NULL;
			_g_free0 (_data_->self->priv->appstream_comp_id);
			_data_->self->priv->appstream_comp_id = _data_->_tmp7_;
			_g_free0 (_data_->_tmp2_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp8_ = g_strdup ("");
			_g_free0 (_data_->self->priv->appstream_comp_id);
			_data_->self->priv->appstream_comp_id = _data_->_tmp8_;
			_data_->_tmp9_ = _data_->e;
			_data_->_tmp10_ = _data_->_tmp9_->message;
			g_warning ("AppContextMenu.vala:192: %s", _data_->_tmp10_);
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		_data_->_tmp11_ = g_strdup ("");
		_g_free0 (_data_->self->priv->appstream_comp_id);
		_data_->self->priv->appstream_comp_id = _data_->_tmp11_;
	}
	_data_->_tmp12_ = _data_->self->priv->uninstall_menuitem;
	_data_->_tmp13_ = _data_->self->priv->appstream_comp_id;
	gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp12_, g_strcmp0 (_data_->_tmp13_, "") != 0);
	_data_->_tmp14_ = _data_->self->priv->appcenter_menuitem;
	_data_->_tmp15_ = _data_->self->priv->appstream_comp_id;
	gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp14_, g_strcmp0 (_data_->_tmp15_, "") != 0);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
slingshot_app_context_menu_plank_menuitem_activate (SlingshotAppContextMenu* self)
{
	gboolean _tmp0_ = FALSE;
	PlankDBusClient* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = slingshot_app_context_menu_plank_client;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		PlankDBusClient* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = slingshot_app_context_menu_plank_client;
		_tmp3_ = plank_dbus_client_get_is_connected (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	}
	if (_tmp0_) {
		return;
	}
	if (self->priv->docked) {
		PlankDBusClient* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = slingshot_app_context_menu_plank_client;
		_tmp6_ = slingshot_app_context_menu_get_desktop_uri (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		plank_dbus_client_remove_item (_tmp5_, _tmp8_);
		_g_free0 (_tmp8_);
	} else {
		PlankDBusClient* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp9_ = slingshot_app_context_menu_plank_client;
		_tmp10_ = slingshot_app_context_menu_get_desktop_uri (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		plank_dbus_client_add_item (_tmp9_, _tmp12_);
		_g_free0 (_tmp12_);
	}
}

const gchar*
slingshot_app_context_menu_get_desktop_id (SlingshotAppContextMenu* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_id;
	result = _tmp0_;
	return result;
}

static void
slingshot_app_context_menu_set_desktop_id (SlingshotAppContextMenu* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_app_context_menu_get_desktop_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desktop_id);
		self->priv->_desktop_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_app_context_menu_properties[SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_ID_PROPERTY]);
	}
}

const gchar*
slingshot_app_context_menu_get_desktop_path (SlingshotAppContextMenu* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_path;
	result = _tmp0_;
	return result;
}

static void
slingshot_app_context_menu_set_desktop_path (SlingshotAppContextMenu* self,
                                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_app_context_menu_get_desktop_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desktop_path);
		self->priv->_desktop_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_app_context_menu_properties[SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_PATH_PROPERTY]);
	}
}

static gchar*
slingshot_app_context_menu_get_desktop_uri (SlingshotAppContextMenu* self)
{
	gchar* result;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		SlingshotAppContextMenu* self;
		self = _data8_->self;
		_g_free0 (_data8_->action);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
_slingshot_app_context_menu_____lambda30_ (Block8Data* _data8_,
                                           GtkMenuItem* target)
{
	SlingshotAppContextMenu* self;
	GdkAppLaunchContext* context = NULL;
	GdkDisplay* _tmp0_;
	GdkAppLaunchContext* _tmp1_;
	GdkAppLaunchContext* _tmp2_;
	GDesktopAppInfo* _tmp3_;
	const gchar* _tmp4_;
	GdkAppLaunchContext* _tmp5_;
	self = _data8_->self;
	g_return_if_fail (target != NULL);
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) target);
	_tmp1_ = gdk_display_get_app_launch_context (_tmp0_);
	context = _tmp1_;
	_tmp2_ = context;
	gdk_app_launch_context_set_timestamp (_tmp2_, gtk_get_current_event_time ());
	_tmp3_ = self->priv->app_info;
	_tmp4_ = _data8_->action;
	_tmp5_ = context;
	g_desktop_app_info_launch_action (_tmp3_, _tmp4_, (GAppLaunchContext*) _tmp5_);
	g_signal_emit (self, slingshot_app_context_menu_signals[SLINGSHOT_APP_CONTEXT_MENU_APP_LAUNCHED_SIGNAL], 0);
	_g_object_unref0 (context);
}

static void
__slingshot_app_context_menu_____lambda30__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                   gpointer self)
{
	_slingshot_app_context_menu_____lambda30_ (self, _sender);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		SlingshotAppContextMenu* self;
		self = _data9_->self;
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
_slingshot_app_context_menu____lambda31_ (Block9Data* _data9_,
                                          GtkMenuItem* target)
{
	SlingshotAppContextMenu* self;
	GError* _inner_error0_ = NULL;
	self = _data9_->self;
	g_return_if_fail (target != NULL);
	{
		GdkAppLaunchContext* context = NULL;
		GdkDisplay* _tmp0_;
		GdkAppLaunchContext* _tmp1_;
		GdkAppLaunchContext* _tmp2_;
		SlingshotBackendSwitcherooControl* _tmp3_;
		GdkAppLaunchContext* _tmp4_;
		GDesktopAppInfo* _tmp5_;
		GdkAppLaunchContext* _tmp6_;
		_tmp0_ = gtk_widget_get_display ((GtkWidget*) target);
		_tmp1_ = gdk_display_get_app_launch_context (_tmp0_);
		context = _tmp1_;
		_tmp2_ = context;
		gdk_app_launch_context_set_timestamp (_tmp2_, gtk_get_current_event_time ());
		_tmp3_ = self->priv->switcheroo_control;
		_tmp4_ = context;
		slingshot_backend_switcheroo_control_apply_gpu_environment (_tmp3_, (GAppLaunchContext*) _tmp4_, _data9_->prefers_non_default_gpu);
		_tmp5_ = self->priv->app_info;
		_tmp6_ = context;
		g_app_info_launch ((GAppInfo*) _tmp5_, NULL, (GAppLaunchContext*) _tmp6_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (context);
			goto __catch0_g_error;
		}
		g_signal_emit (self, slingshot_app_context_menu_signals[SLINGSHOT_APP_CONTEXT_MENU_APP_LAUNCHED_SIGNAL], 0);
		_g_object_unref0 (context);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = gtk_widget_get_name ((GtkWidget*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("AppContextMenu.vala:93: Failed to launch %s: %s", _tmp8_, _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__slingshot_app_context_menu____lambda31__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                  gpointer self)
{
	_slingshot_app_context_menu____lambda31_ (self, _sender);
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_slingshot_app_context_menu_plank_menuitem_activate_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                            gpointer self)
{
	slingshot_app_context_menu_plank_menuitem_activate ((SlingshotAppContextMenu*) self);
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		SlingshotAppContextMenu* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->appcenter);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
_slingshot_app_context_menu_uninstall_menuitem_activate_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                                gpointer self)
{
	slingshot_app_context_menu_uninstall_menuitem_activate ((SlingshotAppContextMenu*) self);
}

static void
_slingshot_app_context_menu_open_in_appcenter_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                      gpointer self)
{
	slingshot_app_context_menu_open_in_appcenter ((SlingshotAppContextMenu*) self);
}

static void
_slingshot_app_context_menu____lambda32_ (Block10Data* _data10_)
{
	SlingshotAppContextMenu* self;
	SlingshotBackendAppCenter* _tmp0_;
	self = _data10_->self;
	_tmp0_ = _data10_->appcenter;
	slingshot_app_context_menu_on_appcenter_dbus_changed (self, _tmp0_, NULL, NULL);
}

static void
__slingshot_app_context_menu____lambda32__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	_slingshot_app_context_menu____lambda32_ (self);
}

static GObject *
slingshot_app_context_menu_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotAppContextMenu * self;
	SlingshotBackendSwitcherooControl* _tmp0_;
	const gchar* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	GDesktopAppInfo* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gboolean _tmp16_ = FALSE;
	SlingshotBackendSwitcherooControl* _tmp17_;
	gboolean _tmp30_ = FALSE;
	PlankDBusClient* _tmp31_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gboolean _tmp54_;
	parent_class = G_OBJECT_CLASS (slingshot_app_context_menu_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_TYPE_APP_CONTEXT_MENU, SlingshotAppContextMenu);
	_tmp0_ = slingshot_backend_switcheroo_control_new ();
	_g_object_unref0 (self->priv->switcheroo_control);
	self->priv->switcheroo_control = _tmp0_;
	_tmp1_ = self->priv->_desktop_id;
	_tmp2_ = g_desktop_app_info_new (_tmp1_);
	_g_object_unref0 (self->priv->app_info);
	self->priv->app_info = _tmp2_;
	_tmp3_ = self->priv->app_info;
	_tmp5_ = _tmp4_ = g_desktop_app_info_list_actions (_tmp3_);
	{
		gchar** _action_collection = NULL;
		gint _action_collection_length1 = 0;
		gint __action_collection_size_ = 0;
		gint _action_it = 0;
		_action_collection = _tmp5_;
		_action_collection_length1 = _vala_array_length (_tmp4_);
		for (_action_it = 0; _action_it < _action_collection_length1; _action_it = _action_it + 1) {
			const gchar* _action = NULL;
			_action = _action_collection[_action_it];
			{
				Block8Data* _data8_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				GtkMenuItem* menuitem = NULL;
				GDesktopAppInfo* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				GtkMenuItem* _tmp12_;
				GtkMenuItem* _tmp13_;
				GtkMenuItem* _tmp14_;
				GtkMenuItem* _tmp15_;
				_data8_ = g_slice_new0 (Block8Data);
				_data8_->_ref_count_ = 1;
				_data8_->self = g_object_ref (self);
				_tmp6_ = _action;
				_tmp7_ = g_strdup (_tmp6_);
				_data8_->action = _tmp7_;
				_tmp8_ = self->priv->app_info;
				_tmp9_ = _data8_->action;
				_tmp10_ = g_desktop_app_info_get_action_name (_tmp8_, _tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_tmp11_);
				g_object_ref_sink (_tmp12_);
				_tmp13_ = _tmp12_;
				_g_free0 (_tmp11_);
				menuitem = _tmp13_;
				_tmp14_ = menuitem;
				gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp14_);
				_tmp15_ = menuitem;
				g_signal_connect_data (_tmp15_, "activate", (GCallback) __slingshot_app_context_menu_____lambda30__gtk_menu_item_activate, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
				_g_object_unref0 (menuitem);
				block8_data_unref (_data8_);
				_data8_ = NULL;
			}
		}
	}
	_tmp17_ = self->priv->switcheroo_control;
	if (_tmp17_ != NULL) {
		SlingshotBackendSwitcherooControl* _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp20_;
		_tmp18_ = self->priv->switcheroo_control;
		_tmp19_ = slingshot_backend_switcheroo_control_get_has_dual_gpu (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp16_ = _tmp20_;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		Block9Data* _data9_;
		GDesktopAppInfo* _tmp21_;
		gchar* gpu_name = NULL;
		SlingshotBackendSwitcherooControl* _tmp22_;
		gchar* _tmp23_;
		gchar* label = NULL;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		GtkMenuItem* menu_item = NULL;
		const gchar* _tmp26_;
		GtkMenuItem* _tmp27_;
		GtkMenuItem* _tmp28_;
		GtkMenuItem* _tmp29_;
		_data9_ = g_slice_new0 (Block9Data);
		_data9_->_ref_count_ = 1;
		_data9_->self = g_object_ref (self);
		_tmp21_ = self->priv->app_info;
		_data9_->prefers_non_default_gpu = g_desktop_app_info_get_boolean (_tmp21_, "PrefersNonDefaultGPU");
		_tmp22_ = self->priv->switcheroo_control;
		_tmp23_ = slingshot_backend_switcheroo_control_get_gpu_name (_tmp22_, _data9_->prefers_non_default_gpu);
		gpu_name = _tmp23_;
		_tmp24_ = gpu_name;
		_tmp25_ = g_strdup_printf (_ ("Open with %s Graphics"), _tmp24_);
		label = _tmp25_;
		_tmp26_ = label;
		_tmp27_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_tmp26_);
		g_object_ref_sink (_tmp27_);
		menu_item = _tmp27_;
		_tmp28_ = menu_item;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp28_);
		_tmp29_ = menu_item;
		g_signal_connect_data (_tmp29_, "activate", (GCallback) __slingshot_app_context_menu____lambda31__gtk_menu_item_activate, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
		_g_object_unref0 (menu_item);
		_g_free0 (label);
		_g_free0 (gpu_name);
		block9_data_unref (_data9_);
		_data9_ = NULL;
	}
	_tmp31_ = slingshot_app_context_menu_plank_client;
	if (_tmp31_ != NULL) {
		PlankDBusClient* _tmp32_;
		gboolean _tmp33_;
		gboolean _tmp34_;
		_tmp32_ = slingshot_app_context_menu_plank_client;
		_tmp33_ = plank_dbus_client_get_is_connected (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp30_ = _tmp34_;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		GList* _tmp35_;
		GList* _tmp36_;
		gboolean _tmp37_;
		GtkMenuItem* plank_menuitem = NULL;
		GtkMenuItem* _tmp40_;
		GtkMenuItem* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		PlankDBusClient* _tmp45_;
		gint _tmp46_ = 0;
		gchar** _tmp47_;
		GtkMenuItem* _tmp50_;
		GtkMenuItem* _tmp51_;
		_tmp35_ = gtk_container_get_children ((GtkContainer*) self);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_list_length (_tmp36_) > ((guint) 0);
		(_tmp36_ == NULL) ? NULL : (_tmp36_ = (g_list_free (_tmp36_), NULL));
		if (_tmp37_) {
			GtkSeparatorMenuItem* _tmp38_;
			GtkSeparatorMenuItem* _tmp39_;
			_tmp38_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
			g_object_ref_sink (_tmp38_);
			_tmp39_ = _tmp38_;
			gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp39_);
			_g_object_unref0 (_tmp39_);
		}
		self->priv->has_system_item = TRUE;
		_tmp40_ = (GtkMenuItem*) gtk_menu_item_new ();
		g_object_ref_sink (_tmp40_);
		plank_menuitem = _tmp40_;
		_tmp41_ = plank_menuitem;
		gtk_menu_item_set_use_underline (_tmp41_, TRUE);
		_tmp42_ = slingshot_app_context_menu_get_desktop_uri (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = _tmp43_;
		_tmp45_ = slingshot_app_context_menu_plank_client;
		_tmp47_ = plank_dbus_client_get_persistent_applications (_tmp45_, &_tmp46_);
		self->priv->docked = _vala_string_array_contains (_tmp47_, _tmp46_, _tmp44_);
		_g_free0 (_tmp44_);
		if (self->priv->docked) {
			GtkMenuItem* _tmp48_;
			_tmp48_ = plank_menuitem;
			gtk_menu_item_set_label (_tmp48_, _ ("Remove from _Dock"));
		} else {
			GtkMenuItem* _tmp49_;
			_tmp49_ = plank_menuitem;
			gtk_menu_item_set_label (_tmp49_, _ ("Add to _Dock"));
		}
		_tmp50_ = plank_menuitem;
		g_signal_connect_object (_tmp50_, "activate", (GCallback) _slingshot_app_context_menu_plank_menuitem_activate_gtk_menu_item_activate, self, 0);
		_tmp51_ = plank_menuitem;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp51_);
		_g_object_unref0 (plank_menuitem);
	}
	_tmp52_ = g_find_program_in_path ("io.elementary.appcenter");
	_tmp53_ = _tmp52_;
	_tmp54_ = _tmp53_ != NULL;
	_g_free0 (_tmp53_);
	if (_tmp54_) {
		Block10Data* _data10_;
		gboolean _tmp55_ = FALSE;
		GtkMenuItem* _tmp60_ = NULL;
		GtkMenuItem* _tmp61_;
		GtkMenuItem* _tmp62_ = NULL;
		GtkMenuItem* _tmp63_;
		GtkMenuItem* _tmp64_;
		GtkMenuItem* _tmp65_;
		SlingshotBackendAppCenter* _tmp66_;
		SlingshotBackendAppCenter* _tmp67_;
		SlingshotBackendAppCenter* _tmp68_;
		SlingshotBackendAppCenter* _tmp69_;
		_data10_ = g_slice_new0 (Block10Data);
		_data10_->_ref_count_ = 1;
		_data10_->self = g_object_ref (self);
		if (!self->priv->has_system_item) {
			GList* _tmp56_;
			GList* _tmp57_;
			_tmp56_ = gtk_container_get_children ((GtkContainer*) self);
			_tmp57_ = _tmp56_;
			_tmp55_ = g_list_length (_tmp57_) > ((guint) 0);
			(_tmp57_ == NULL) ? NULL : (_tmp57_ = (g_list_free (_tmp57_), NULL));
		} else {
			_tmp55_ = FALSE;
		}
		if (_tmp55_) {
			GtkSeparatorMenuItem* _tmp58_;
			GtkSeparatorMenuItem* _tmp59_;
			_tmp58_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
			g_object_ref_sink (_tmp58_);
			_tmp59_ = _tmp58_;
			gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp59_);
			_g_object_unref0 (_tmp59_);
		}
		_tmp60_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Uninstall"));
		gtk_widget_set_sensitive ((GtkWidget*) _tmp60_, FALSE);
		g_object_ref_sink (_tmp60_);
		_g_object_unref0 (self->priv->uninstall_menuitem);
		self->priv->uninstall_menuitem = _tmp60_;
		_tmp61_ = self->priv->uninstall_menuitem;
		g_signal_connect_object (_tmp61_, "activate", (GCallback) _slingshot_app_context_menu_uninstall_menuitem_activate_gtk_menu_item_activate, self, 0);
		_tmp62_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("View in AppCenter"));
		gtk_widget_set_sensitive ((GtkWidget*) _tmp62_, FALSE);
		g_object_ref_sink (_tmp62_);
		_g_object_unref0 (self->priv->appcenter_menuitem);
		self->priv->appcenter_menuitem = _tmp62_;
		_tmp63_ = self->priv->appcenter_menuitem;
		g_signal_connect_object (_tmp63_, "activate", (GCallback) _slingshot_app_context_menu_open_in_appcenter_gtk_menu_item_activate, self, 0);
		_tmp64_ = self->priv->uninstall_menuitem;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp64_);
		_tmp65_ = self->priv->appcenter_menuitem;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp65_);
		_tmp66_ = slingshot_backend_app_center_get_default ();
		_tmp67_ = _g_object_ref0 (_tmp66_);
		_data10_->appcenter = _tmp67_;
		_tmp68_ = _data10_->appcenter;
		g_signal_connect_data ((GObject*) _tmp68_, "notify::dbus", (GCallback) __slingshot_app_context_menu____lambda32__g_object_notify, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
		_tmp69_ = _data10_->appcenter;
		slingshot_app_context_menu_on_appcenter_dbus_changed (self, _tmp69_, NULL, NULL);
		block10_data_unref (_data10_);
		_data10_ = NULL;
	}
	gtk_widget_show_all ((GtkWidget*) self);
	return obj;
}

static void
slingshot_app_context_menu_class_init (SlingshotAppContextMenuClass * klass,
                                       gpointer klass_data)
{
	PlankDBusClient* _tmp0_;
	PlankDBusClient* _tmp1_;
	slingshot_app_context_menu_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotAppContextMenu_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_app_context_menu_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_app_context_menu_set_property;
	G_OBJECT_CLASS (klass)->constructor = slingshot_app_context_menu_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_app_context_menu_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_ID_PROPERTY, slingshot_app_context_menu_properties[SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_ID_PROPERTY] = g_param_spec_string ("desktop-id", "desktop-id", "desktop-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_PATH_PROPERTY, slingshot_app_context_menu_properties[SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_PATH_PROPERTY] = g_param_spec_string ("desktop-path", "desktop-path", "desktop-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	slingshot_app_context_menu_signals[SLINGSHOT_APP_CONTEXT_MENU_APP_LAUNCHED_SIGNAL] = g_signal_new ("app-launched", SLINGSHOT_TYPE_APP_CONTEXT_MENU, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	plank_paths_initialize ("plank", PKGDATADIR);
	_tmp0_ = plank_dbus_client_get_instance ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (slingshot_app_context_menu_plank_client);
	slingshot_app_context_menu_plank_client = _tmp1_;
}

static void
slingshot_app_context_menu_instance_init (SlingshotAppContextMenu * self,
                                          gpointer klass)
{
	gchar* _tmp0_;
	self->priv = slingshot_app_context_menu_get_instance_private (self);
	self->priv->has_system_item = FALSE;
	_tmp0_ = g_strdup ("");
	self->priv->appstream_comp_id = _tmp0_;
	self->priv->docked = FALSE;
}

static void
slingshot_app_context_menu_finalize (GObject * obj)
{
	SlingshotAppContextMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_TYPE_APP_CONTEXT_MENU, SlingshotAppContextMenu);
	_g_free0 (self->priv->_desktop_id);
	_g_free0 (self->priv->_desktop_path);
	_g_object_unref0 (self->priv->app_info);
	_g_free0 (self->priv->appstream_comp_id);
	_g_object_unref0 (self->priv->switcheroo_control);
	_g_object_unref0 (self->priv->uninstall_menuitem);
	_g_object_unref0 (self->priv->appcenter_menuitem);
	G_OBJECT_CLASS (slingshot_app_context_menu_parent_class)->finalize (obj);
}

static GType
slingshot_app_context_menu_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotAppContextMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_app_context_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotAppContextMenu), 0, (GInstanceInitFunc) slingshot_app_context_menu_instance_init, NULL };
	GType slingshot_app_context_menu_type_id;
	slingshot_app_context_menu_type_id = g_type_register_static (gtk_menu_get_type (), "SlingshotAppContextMenu", &g_define_type_info, 0);
	SlingshotAppContextMenu_private_offset = g_type_add_instance_private (slingshot_app_context_menu_type_id, sizeof (SlingshotAppContextMenuPrivate));
	return slingshot_app_context_menu_type_id;
}

GType
slingshot_app_context_menu_get_type (void)
{
	static volatile gsize slingshot_app_context_menu_type_id__once = 0;
	if (g_once_init_enter (&slingshot_app_context_menu_type_id__once)) {
		GType slingshot_app_context_menu_type_id;
		slingshot_app_context_menu_type_id = slingshot_app_context_menu_get_type_once ();
		g_once_init_leave (&slingshot_app_context_menu_type_id__once, slingshot_app_context_menu_type_id);
	}
	return slingshot_app_context_menu_type_id__once;
}

static void
_vala_slingshot_app_context_menu_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	SlingshotAppContextMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_TYPE_APP_CONTEXT_MENU, SlingshotAppContextMenu);
	switch (property_id) {
		case SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_ID_PROPERTY:
		g_value_set_string (value, slingshot_app_context_menu_get_desktop_id (self));
		break;
		case SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_PATH_PROPERTY:
		g_value_set_string (value, slingshot_app_context_menu_get_desktop_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_app_context_menu_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	SlingshotAppContextMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_TYPE_APP_CONTEXT_MENU, SlingshotAppContextMenu);
	switch (property_id) {
		case SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_ID_PROPERTY:
		slingshot_app_context_menu_set_desktop_id (self, g_value_get_string (value));
		break;
		case SLINGSHOT_APP_CONTEXT_MENU_DESKTOP_PATH_PROPERTY:
		slingshot_app_context_menu_set_desktop_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

