/* SearchView.c generated by valac 0.56.8, the Vala compiler
 * generated from SearchView.vala, do not modify */

/*
 * Copyright 2011-2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 *              Giulio Collura
 */

#include "slingshot.h"
#include <granite.h>
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

#define SLINGSHOT_WIDGETS_SEARCH_VIEW_MAX_RESULTS 10

enum  {
	SLINGSHOT_WIDGETS_SEARCH_VIEW_0_PROPERTY,
	SLINGSHOT_WIDGETS_SEARCH_VIEW_NUM_PROPERTIES
};
static GParamSpec* slingshot_widgets_search_view_properties[SLINGSHOT_WIDGETS_SEARCH_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block5Data Block5Data;
enum  {
	SLINGSHOT_WIDGETS_SEARCH_VIEW_START_SEARCH_SIGNAL,
	SLINGSHOT_WIDGETS_SEARCH_VIEW_APP_LAUNCHED_SIGNAL,
	SLINGSHOT_WIDGETS_SEARCH_VIEW_NUM_SIGNALS
};
static guint slingshot_widgets_search_view_signals[SLINGSHOT_WIDGETS_SEARCH_VIEW_NUM_SIGNALS] = {0};

struct _SlingshotWidgetsSearchViewPrivate {
	GraniteWidgetsAlertView* alert_view;
	SlingshotAppListBox* list_box;
	GeeHashMap* limitator;
};

struct _Block5Data {
	int _ref_count_;
	SlingshotWidgetsSearchView* self;
	GtkListBoxRow* row;
};

static gint SlingshotWidgetsSearchView_private_offset;
static gpointer slingshot_widgets_search_view_parent_class = NULL;

static void slingshot_widgets_search_view_create_item (SlingshotWidgetsSearchView* self,
                                                SlingshotBackendApp* app,
                                                const gchar* search_term,
                                                SlingshotWidgetsSearchItemResultType result_type);
static void __lambda50_ (SlingshotWidgetsSearchView* self,
                  SynapseSearchMatch* search,
                  SynapseMatch* target);
static void ___lambda50__slingshot_backend_app_start_search (SlingshotBackendApp* _sender,
                                                      SynapseSearchMatch* search_match,
                                                      SynapseMatch* target,
                                                      gpointer self);
static void __lambda49_ (SlingshotWidgetsSearchView* self,
                  GtkWidget* child);
static void ___lambda49__gfunc (gconstpointer data,
                         gpointer self);
static gint slingshot_widgets_search_view_update_sort (SlingshotWidgetsSearchView* self,
                                                GtkListBoxRow* row1,
                                                GtkListBoxRow* row2);
static void slingshot_widgets_search_view_update_header (SlingshotWidgetsSearchItem* row,
                                                  SlingshotWidgetsSearchItem* before,
                                                  SlingshotWidgetsSearchView* self);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static GObject * slingshot_widgets_search_view_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static gint _slingshot_widgets_search_view___lambda51_ (SlingshotWidgetsSearchView* self,
                                                 GtkListBoxRow* row1,
                                                 GtkListBoxRow* row2);
static gint __slingshot_widgets_search_view___lambda51__gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                         GtkListBoxRow* row2,
                                                                         gpointer self);
static void _slingshot_widgets_search_view___lambda52_ (SlingshotWidgetsSearchView* self);
static void __slingshot_widgets_search_view___lambda52__slingshot_app_list_box_close_request (SlingshotAppListBox* _sender,
                                                                                       gpointer self);
static void _slingshot_widgets_search_view___lambda53_ (SlingshotWidgetsSearchView* self,
                                                 GtkListBoxRow* row);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda54_ (Block5Data* _data5_);
static gboolean ___lambda54__gsource_func (gpointer self);
static void __slingshot_widgets_search_view___lambda53__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                             GtkListBoxRow* row,
                                                                             gpointer self);
static gboolean _slingshot_widgets_search_view___lambda55_ (SlingshotWidgetsSearchView* self,
                                                     GdkEventButton* e);
static gboolean __slingshot_widgets_search_view___lambda55__gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                    GdkEventButton* event,
                                                                                    gpointer self);
static gboolean _slingshot_widgets_search_view___lambda56_ (SlingshotWidgetsSearchView* self,
                                                     GdkEventKey* e);
static gboolean __slingshot_widgets_search_view___lambda56__gtk_widget_key_press_event (GtkWidget* _sender,
                                                                                 GdkEventKey* event,
                                                                                 gpointer self);
static void slingshot_widgets_search_view_finalize (GObject * obj);
static GType slingshot_widgets_search_view_get_type_once (void);

static inline gpointer
slingshot_widgets_search_view_get_instance_private (SlingshotWidgetsSearchView* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotWidgetsSearchView_private_offset);
}

void
slingshot_widgets_search_view_set_results (SlingshotWidgetsSearchView* self,
                                           GeeList* matches,
                                           const gchar* search_term)
{
	gint _tmp0_;
	gint _tmp1_;
	GtkListBoxRow* first = NULL;
	SlingshotAppListBox* _tmp41_;
	GtkListBoxRow* _tmp42_;
	GtkListBoxRow* _tmp43_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (matches != NULL);
	g_return_if_fail (search_term != NULL);
	slingshot_widgets_search_view_clear (self);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) matches);
	_tmp1_ = _tmp0_;
	if (_tmp1_ > 0) {
		{
			GeeList* _match_list = NULL;
			gint _match_size = 0;
			GeeList* _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _match_index = 0;
			_match_list = matches;
			_tmp2_ = _match_list;
			_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
			_tmp4_ = _tmp3_;
			_match_size = _tmp4_;
			_match_index = -1;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				SynapseMatch* match = NULL;
				GeeList* _tmp7_;
				gpointer _tmp8_;
				SlingshotBackendApp* app = NULL;
				SynapseMatch* _tmp9_;
				SlingshotBackendApp* _tmp10_;
				SlingshotWidgetsSearchItemResultType result_type = 0;
				SynapseMatch* _tmp11_;
				SynapseMatchType _tmp12_;
				SynapseMatchType _tmp13_;
				SynapseMatch* _tmp14_;
				SlingshotBackendApp* _tmp37_;
				_match_index = _match_index + 1;
				_tmp5_ = _match_index;
				_tmp6_ = _match_size;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = _match_list;
				_tmp8_ = gee_list_get (_tmp7_, _match_index);
				match = (SynapseMatch*) _tmp8_;
				_tmp9_ = match;
				_tmp10_ = slingshot_backend_app_new_from_synapse_match (_tmp9_, NULL);
				app = _tmp10_;
				_tmp11_ = match;
				_tmp12_ = synapse_match_get_match_type (_tmp11_);
				_tmp13_ = _tmp12_;
				result_type = (SlingshotWidgetsSearchItemResultType) _tmp13_;
				_tmp14_ = match;
				if (SYNAPSE_DESKTOP_FILE_PLUGIN_IS_ACTION_MATCH (_tmp14_)) {
					result_type = SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_APP_ACTIONS;
				} else {
					SynapseMatch* _tmp15_;
					_tmp15_ = match;
					if (SYNAPSE_IS_SWITCHBOARD_OBJECT (_tmp15_)) {
						result_type = SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_SETTINGS;
					} else {
						SynapseMatch* _tmp16_;
						_tmp16_ = match;
						if (SYNAPSE_LINK_PLUGIN_IS_RESULT (_tmp16_)) {
							result_type = SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_INTERNET;
						} else {
							SynapseMatch* _tmp17_;
							_tmp17_ = match;
							if (SYNAPSE_FILE_BOOKMARK_PLUGIN_IS_RESULT (_tmp17_)) {
								result_type = SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_BOOKMARK;
							}
						}
					}
				}
				if (result_type == SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_UNKNOWN) {
					GeeList* actions = NULL;
					SynapseMatch* _tmp18_;
					GeeList* _tmp19_;
					_tmp18_ = match;
					_tmp19_ = slingshot_backend_synapse_search_find_actions_for_match (_tmp18_);
					actions = _tmp19_;
					{
						GeeList* _action_list = NULL;
						GeeList* _tmp20_;
						gint _action_size = 0;
						GeeList* _tmp21_;
						gint _tmp22_;
						gint _tmp23_;
						gint _action_index = 0;
						_tmp20_ = actions;
						_action_list = _tmp20_;
						_tmp21_ = _action_list;
						_tmp22_ = gee_collection_get_size ((GeeCollection*) _tmp21_);
						_tmp23_ = _tmp22_;
						_action_size = _tmp23_;
						_action_index = -1;
						while (TRUE) {
							gint _tmp24_;
							gint _tmp25_;
							SynapseMatch* action = NULL;
							GeeList* _tmp26_;
							gpointer _tmp27_;
							SynapseMatch* _tmp28_;
							SynapseMatch* _tmp29_;
							SlingshotBackendApp* _tmp30_;
							SlingshotBackendApp* _tmp31_;
							SlingshotBackendApp* _tmp32_;
							SynapseMatch* _tmp33_;
							SynapseMatch* _tmp34_;
							SynapseMatchType _tmp35_;
							SynapseMatchType _tmp36_;
							_action_index = _action_index + 1;
							_tmp24_ = _action_index;
							_tmp25_ = _action_size;
							if (!(_tmp24_ < _tmp25_)) {
								break;
							}
							_tmp26_ = _action_list;
							_tmp27_ = gee_list_get (_tmp26_, _action_index);
							action = (SynapseMatch*) _tmp27_;
							_tmp28_ = action;
							_tmp29_ = match;
							_tmp30_ = slingshot_backend_app_new_from_synapse_match (_tmp28_, _tmp29_);
							_g_object_unref0 (app);
							app = _tmp30_;
							_tmp31_ = app;
							_tmp32_ = app;
							_tmp33_ = slingshot_backend_app_get_match (_tmp32_);
							_tmp34_ = _tmp33_;
							_tmp35_ = synapse_match_get_match_type (_tmp34_);
							_tmp36_ = _tmp35_;
							slingshot_widgets_search_view_create_item (self, _tmp31_, search_term, (SlingshotWidgetsSearchItemResultType) _tmp36_);
							_g_object_unref0 (action);
						}
					}
					_g_object_unref0 (actions);
					_g_object_unref0 (app);
					_g_object_unref0 (match);
					continue;
				}
				_tmp37_ = app;
				slingshot_widgets_search_view_create_item (self, _tmp37_, search_term, result_type);
				_g_object_unref0 (app);
				_g_object_unref0 (match);
			}
		}
	} else {
		GraniteWidgetsAlertView* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp38_ = self->priv->alert_view;
		_tmp39_ = g_strdup_printf (_ ("No Results for “%s”"), search_term);
		_tmp40_ = _tmp39_;
		granite_widgets_alert_view_set_title (_tmp38_, _tmp40_);
		_g_free0 (_tmp40_);
	}
	_tmp41_ = self->priv->list_box;
	_tmp42_ = gtk_list_box_get_row_at_index ((GtkListBox*) _tmp41_, 0);
	first = _tmp42_;
	_tmp43_ = first;
	if (_tmp43_ != NULL) {
		SlingshotAppListBox* _tmp44_;
		GtkListBoxRow* _tmp45_;
		_tmp44_ = self->priv->list_box;
		_tmp45_ = first;
		gtk_list_box_select_row ((GtkListBox*) _tmp44_, _tmp45_);
	}
}

static void
__lambda50_ (SlingshotWidgetsSearchView* self,
             SynapseSearchMatch* search,
             SynapseMatch* target)
{
	g_return_if_fail (search != NULL);
	g_signal_emit (self, slingshot_widgets_search_view_signals[SLINGSHOT_WIDGETS_SEARCH_VIEW_START_SEARCH_SIGNAL], 0, search, target);
}

static void
___lambda50__slingshot_backend_app_start_search (SlingshotBackendApp* _sender,
                                                 SynapseSearchMatch* search_match,
                                                 SynapseMatch* target,
                                                 gpointer self)
{
	__lambda50_ ((SlingshotWidgetsSearchView*) self, search_match, target);
}

static void
slingshot_widgets_search_view_create_item (SlingshotWidgetsSearchView* self,
                                           SlingshotBackendApp* app,
                                           const gchar* search_term,
                                           SlingshotWidgetsSearchItemResultType result_type)
{
	GeeHashMap* _tmp0_;
	SlingshotWidgetsSearchItem* search_item = NULL;
	SlingshotWidgetsSearchItem* _tmp5_;
	SlingshotAppListBox* _tmp6_;
	SlingshotWidgetsSearchItem* _tmp7_;
	SlingshotWidgetsSearchItem* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app != NULL);
	g_return_if_fail (search_term != NULL);
	_tmp0_ = self->priv->limitator;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) result_type))) {
		guint amount = 0U;
		GeeHashMap* _tmp1_;
		gpointer _tmp2_;
		_tmp1_ = self->priv->limitator;
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, (gpointer) ((gintptr) result_type));
		amount = (guint) ((guintptr) _tmp2_);
		if (amount >= ((guint) SLINGSHOT_WIDGETS_SEARCH_VIEW_MAX_RESULTS)) {
			return;
		} else {
			GeeHashMap* _tmp3_;
			_tmp3_ = self->priv->limitator;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, (gpointer) ((gintptr) result_type), (gpointer) ((guintptr) (amount + 1)));
		}
	} else {
		GeeHashMap* _tmp4_;
		_tmp4_ = self->priv->limitator;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp4_, (gpointer) ((gintptr) result_type), (gpointer) ((guintptr) 1));
	}
	_tmp5_ = slingshot_widgets_search_item_new (app, search_term, result_type);
	g_object_ref_sink (_tmp5_);
	search_item = _tmp5_;
	g_signal_connect_object (app, "start-search", (GCallback) ___lambda50__slingshot_backend_app_start_search, self, 0);
	_tmp6_ = self->priv->list_box;
	_tmp7_ = search_item;
	gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = search_item;
	gtk_widget_show_all ((GtkWidget*) _tmp8_);
	_g_object_unref0 (search_item);
}

static void
__lambda49_ (SlingshotWidgetsSearchView* self,
             GtkWidget* child)
{
	g_return_if_fail (child != NULL);
	gtk_widget_destroy (child);
}

static void
___lambda49__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda49_ ((SlingshotWidgetsSearchView*) self, (GtkWidget*) data);
}

void
slingshot_widgets_search_view_clear (SlingshotWidgetsSearchView* self)
{
	GeeHashMap* _tmp0_;
	SlingshotAppListBox* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->limitator;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
	_tmp1_ = self->priv->list_box;
	_tmp2_ = gtk_container_get_children ((GtkContainer*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_list_foreach (_tmp3_, ___lambda49__gfunc, self);
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (g_list_free (_tmp3_), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
slingshot_widgets_search_view_activate_selection (SlingshotWidgetsSearchView* self)
{
	GtkListBoxRow* selection = NULL;
	SlingshotAppListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->list_box;
	_tmp1_ = gtk_list_box_get_selected_row ((GtkListBox*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	if (_tmp3_ != NULL) {
		SlingshotAppListBox* _tmp4_;
		GtkListBoxRow* _tmp5_;
		_tmp4_ = self->priv->list_box;
		_tmp5_ = selection;
		g_signal_emit_by_name ((GtkListBox*) _tmp4_, "row-activated", _tmp5_);
	}
	_g_object_unref0 (selection);
}

static gint
slingshot_widgets_search_view_update_sort (SlingshotWidgetsSearchView* self,
                                           GtkListBoxRow* row1,
                                           GtkListBoxRow* row2)
{
	SlingshotWidgetsSearchItem* item1 = NULL;
	SlingshotWidgetsSearchItem* _tmp0_;
	SlingshotWidgetsSearchItem* item2 = NULL;
	SlingshotWidgetsSearchItem* _tmp1_;
	SlingshotWidgetsSearchItem* _tmp2_;
	SlingshotWidgetsSearchItemResultType _tmp3_;
	SlingshotWidgetsSearchItemResultType _tmp4_;
	SlingshotWidgetsSearchItem* _tmp5_;
	SlingshotWidgetsSearchItemResultType _tmp6_;
	SlingshotWidgetsSearchItemResultType _tmp7_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = _g_object_ref0 (SLINGSHOT_WIDGETS_IS_SEARCH_ITEM (row1) ? ((SlingshotWidgetsSearchItem*) row1) : NULL);
	item1 = _tmp0_;
	_tmp1_ = _g_object_ref0 (SLINGSHOT_WIDGETS_IS_SEARCH_ITEM (row2) ? ((SlingshotWidgetsSearchItem*) row2) : NULL);
	item2 = _tmp1_;
	_tmp2_ = item1;
	_tmp3_ = slingshot_widgets_search_item_get_result_type (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = item2;
	_tmp6_ = slingshot_widgets_search_item_get_result_type (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp4_ != _tmp7_) {
		SlingshotWidgetsSearchItem* _tmp8_;
		SlingshotWidgetsSearchItemResultType _tmp9_;
		SlingshotWidgetsSearchItemResultType _tmp10_;
		SlingshotWidgetsSearchItem* _tmp11_;
		SlingshotWidgetsSearchItemResultType _tmp12_;
		SlingshotWidgetsSearchItemResultType _tmp13_;
		_tmp8_ = item1;
		_tmp9_ = slingshot_widgets_search_item_get_result_type (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = item2;
		_tmp12_ = slingshot_widgets_search_item_get_result_type (_tmp11_);
		_tmp13_ = _tmp12_;
		result = (gint) (_tmp10_ - _tmp13_);
		_g_object_unref0 (item2);
		_g_object_unref0 (item1);
		return result;
	}
	result = 0;
	_g_object_unref0 (item2);
	_g_object_unref0 (item1);
	return result;
}

static void
slingshot_widgets_search_view_update_header (SlingshotWidgetsSearchItem* row,
                                             SlingshotWidgetsSearchItem* before,
                                             SlingshotWidgetsSearchView* self)
{
	gboolean _tmp0_ = FALSE;
	GraniteHeaderLabel* header = NULL;
	SlingshotWidgetsSearchItemResultType _tmp5_;
	SlingshotWidgetsSearchItemResultType _tmp6_;
	const gchar* _tmp7_;
	GraniteHeaderLabel* _tmp8_;
	GraniteHeaderLabel* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	if (before != NULL) {
		SlingshotWidgetsSearchItemResultType _tmp1_;
		SlingshotWidgetsSearchItemResultType _tmp2_;
		SlingshotWidgetsSearchItemResultType _tmp3_;
		SlingshotWidgetsSearchItemResultType _tmp4_;
		_tmp1_ = slingshot_widgets_search_item_get_result_type (before);
		_tmp2_ = _tmp1_;
		_tmp3_ = slingshot_widgets_search_item_get_result_type (row);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp2_ == _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_list_box_row_set_header ((GtkListBoxRow*) row, NULL);
		return;
	}
	_tmp5_ = slingshot_widgets_search_item_get_result_type (row);
	_tmp6_ = _tmp5_;
	_tmp7_ = slingshot_widgets_search_item_result_type_to_string (_tmp6_);
	_tmp8_ = granite_header_label_new (_tmp7_);
	g_object_ref_sink (_tmp8_);
	header = _tmp8_;
	_tmp9_ = header;
	gtk_list_box_row_set_header ((GtkListBoxRow*) row, (GtkWidget*) _tmp9_);
	_g_object_unref0 (header);
}

SlingshotWidgetsSearchView*
slingshot_widgets_search_view_construct (GType object_type)
{
	SlingshotWidgetsSearchView * self = NULL;
	self = (SlingshotWidgetsSearchView*) g_object_new (object_type, NULL);
	return self;
}

SlingshotWidgetsSearchView*
slingshot_widgets_search_view_new (void)
{
	return slingshot_widgets_search_view_construct (SLINGSHOT_WIDGETS_TYPE_SEARCH_VIEW);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static gint
_slingshot_widgets_search_view___lambda51_ (SlingshotWidgetsSearchView* self,
                                            GtkListBoxRow* row1,
                                            GtkListBoxRow* row2)
{
	gint result;
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	result = slingshot_widgets_search_view_update_sort (self, row1, row2);
	return result;
}

static gint
__slingshot_widgets_search_view___lambda51__gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                    GtkListBoxRow* row2,
                                                                    gpointer self)
{
	gint result;
	result = _slingshot_widgets_search_view___lambda51_ ((SlingshotWidgetsSearchView*) self, row1, row2);
	return result;
}

static void
_slingshot_widgets_search_view___lambda52_ (SlingshotWidgetsSearchView* self)
{
	g_signal_emit (self, slingshot_widgets_search_view_signals[SLINGSHOT_WIDGETS_SEARCH_VIEW_APP_LAUNCHED_SIGNAL], 0);
}

static void
__slingshot_widgets_search_view___lambda52__slingshot_app_list_box_close_request (SlingshotAppListBox* _sender,
                                                                                  gpointer self)
{
	_slingshot_widgets_search_view___lambda52_ ((SlingshotWidgetsSearchView*) self);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		SlingshotWidgetsSearchView* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->row);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
__lambda54_ (Block5Data* _data5_)
{
	SlingshotWidgetsSearchView* self;
	SlingshotWidgetsSearchItem* search_item = NULL;
	SlingshotWidgetsSearchItem* _tmp0_;
	SlingshotAppListBox* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	self = _data5_->self;
	_tmp0_ = _g_object_ref0 (SLINGSHOT_WIDGETS_IS_SEARCH_ITEM (_data5_->row) ? ((SlingshotWidgetsSearchItem*) _data5_->row) : NULL);
	search_item = _tmp0_;
	_tmp1_ = self->priv->list_box;
	_tmp2_ = slingshot_app_list_box_get_dragging (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		SlingshotWidgetsSearchItem* _tmp4_;
		SlingshotWidgetsSearchItemResultType _tmp5_;
		SlingshotWidgetsSearchItemResultType _tmp6_;
		_tmp4_ = search_item;
		_tmp5_ = slingshot_widgets_search_item_get_result_type (_tmp4_);
		_tmp6_ = _tmp5_;
		switch (_tmp6_) {
			case SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_APP_ACTIONS:
			case SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_LINK:
			case SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_SETTINGS:
			case SLINGSHOT_WIDGETS_SEARCH_ITEM_RESULT_TYPE_BOOKMARK:
			{
				SlingshotWidgetsSearchItem* _tmp7_;
				SlingshotBackendApp* _tmp8_;
				SlingshotBackendApp* _tmp9_;
				SynapseMatch* _tmp10_;
				SynapseMatch* _tmp11_;
				_tmp7_ = search_item;
				_tmp8_ = slingshot_widgets_search_item_get_app (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = slingshot_backend_app_get_match (_tmp9_);
				_tmp11_ = _tmp10_;
				synapse_match_execute (_tmp11_, NULL);
				break;
			}
			default:
			{
				SlingshotWidgetsSearchItem* _tmp12_;
				SlingshotBackendApp* _tmp13_;
				SlingshotBackendApp* _tmp14_;
				_tmp12_ = search_item;
				_tmp13_ = slingshot_widgets_search_item_get_app (_tmp12_);
				_tmp14_ = _tmp13_;
				slingshot_backend_app_launch (_tmp14_);
				break;
			}
		}
		g_signal_emit (self, slingshot_widgets_search_view_signals[SLINGSHOT_WIDGETS_SEARCH_VIEW_APP_LAUNCHED_SIGNAL], 0);
	}
	result = FALSE;
	_g_object_unref0 (search_item);
	return result;
}

static gboolean
___lambda54__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda54_ (self);
	return result;
}

static void
_slingshot_widgets_search_view___lambda53_ (SlingshotWidgetsSearchView* self,
                                            GtkListBoxRow* row)
{
	Block5Data* _data5_;
	GtkListBoxRow* _tmp0_;
	g_return_if_fail (row != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (row);
	_g_object_unref0 (_data5_->row);
	_data5_->row = _tmp0_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda54__gsource_func, block5_data_ref (_data5_), block5_data_unref);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
__slingshot_widgets_search_view___lambda53__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                        GtkListBoxRow* row,
                                                                        gpointer self)
{
	_slingshot_widgets_search_view___lambda53_ ((SlingshotWidgetsSearchView*) self, row);
}

static gboolean
_slingshot_widgets_search_view___lambda55_ (SlingshotWidgetsSearchView* self,
                                            GdkEventButton* e)
{
	GtkListBoxRow* row = NULL;
	SlingshotAppListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	SlingshotWidgetsSearchItem* search_item = NULL;
	GtkListBoxRow* _tmp3_;
	SlingshotWidgetsSearchItem* _tmp4_;
	SlingshotWidgetsSearchItem* _tmp5_;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->priv->list_box;
	_tmp1_ = gtk_list_box_get_row_at_y ((GtkListBox*) _tmp0_, (gint) e->y);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	row = _tmp2_;
	_tmp3_ = row;
	_tmp4_ = _g_object_ref0 (SLINGSHOT_WIDGETS_IS_SEARCH_ITEM (_tmp3_) ? ((SlingshotWidgetsSearchItem*) _tmp3_) : NULL);
	search_item = _tmp4_;
	if (e->button != ((guint) GDK_BUTTON_SECONDARY)) {
		result = GDK_EVENT_PROPAGATE;
		_g_object_unref0 (search_item);
		_g_object_unref0 (row);
		return result;
	}
	_tmp5_ = search_item;
	result = slingshot_widgets_search_item_create_context_menu (_tmp5_, (GdkEvent*) e);
	_g_object_unref0 (search_item);
	_g_object_unref0 (row);
	return result;
}

static gboolean
__slingshot_widgets_search_view___lambda55__gtk_widget_button_press_event (GtkWidget* _sender,
                                                                           GdkEventButton* event,
                                                                           gpointer self)
{
	gboolean result;
	result = _slingshot_widgets_search_view___lambda55_ ((SlingshotWidgetsSearchView*) self, event);
	return result;
}

static gboolean
_slingshot_widgets_search_view___lambda56_ (SlingshotWidgetsSearchView* self,
                                            GdkEventKey* e)
{
	GtkListBoxRow* row = NULL;
	SlingshotAppListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	SlingshotWidgetsSearchItem* search_item = NULL;
	GtkListBoxRow* _tmp3_;
	SlingshotWidgetsSearchItem* _tmp4_;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->priv->list_box;
	_tmp1_ = gtk_list_box_get_selected_row ((GtkListBox*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	row = _tmp2_;
	_tmp3_ = row;
	_tmp4_ = _g_object_ref0 (SLINGSHOT_WIDGETS_IS_SEARCH_ITEM (_tmp3_) ? ((SlingshotWidgetsSearchItem*) _tmp3_) : NULL);
	search_item = _tmp4_;
	if (e->keyval == GDK_KEY_Menu) {
		SlingshotWidgetsSearchItem* _tmp5_;
		_tmp5_ = search_item;
		result = slingshot_widgets_search_item_create_context_menu (_tmp5_, (GdkEvent*) e);
		_g_object_unref0 (search_item);
		_g_object_unref0 (row);
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	_g_object_unref0 (search_item);
	_g_object_unref0 (row);
	return result;
}

static gboolean
__slingshot_widgets_search_view___lambda56__gtk_widget_key_press_event (GtkWidget* _sender,
                                                                        GdkEventKey* event,
                                                                        gpointer self)
{
	gboolean result;
	result = _slingshot_widgets_search_view___lambda56_ ((SlingshotWidgetsSearchView*) self, event);
	return result;
}

static GObject *
slingshot_widgets_search_view_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotWidgetsSearchView * self;
	GraniteWidgetsAlertView* _tmp0_;
	GraniteWidgetsAlertView* _tmp1_;
	GeeHashMap* _tmp2_;
	SlingshotAppListBox* _tmp3_;
	SlingshotAppListBox* _tmp4_;
	SlingshotAppListBox* _tmp5_;
	SlingshotAppListBox* _tmp6_;
	SlingshotAppListBox* _tmp7_;
	GraniteWidgetsAlertView* _tmp8_;
	SlingshotAppListBox* _tmp9_;
	SlingshotAppListBox* _tmp10_;
	SlingshotAppListBox* _tmp11_;
	SlingshotAppListBox* _tmp12_;
	SlingshotAppListBox* _tmp13_;
	parent_class = G_OBJECT_CLASS (slingshot_widgets_search_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_WIDGETS_TYPE_SEARCH_VIEW, SlingshotWidgetsSearchView);
	g_object_set ((GtkScrolledWindow*) self, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	_tmp0_ = granite_widgets_alert_view_new ("", _ ("Try changing search terms."), "edit-find-symbolic");
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->alert_view);
	self->priv->alert_view = _tmp0_;
	_tmp1_ = self->priv->alert_view;
	gtk_widget_show_all ((GtkWidget*) _tmp1_);
	_tmp2_ = gee_hash_map_new (SLINGSHOT_WIDGETS_SEARCH_ITEM_TYPE_RESULT_TYPE, NULL, NULL, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->limitator);
	self->priv->limitator = _tmp2_;
	_tmp3_ = slingshot_app_list_box_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->list_box);
	self->priv->list_box = _tmp3_;
	_tmp4_ = self->priv->list_box;
	gtk_list_box_set_activate_on_single_click ((GtkListBox*) _tmp4_, TRUE);
	_tmp5_ = self->priv->list_box;
	gtk_list_box_set_sort_func ((GtkListBox*) _tmp5_, __slingshot_widgets_search_view___lambda51__gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp6_ = self->priv->list_box;
	gtk_list_box_set_header_func ((GtkListBox*) _tmp6_, (GtkListBoxUpdateHeaderFunc) slingshot_widgets_search_view_update_header, g_object_ref (self), g_object_unref);
	_tmp7_ = self->priv->list_box;
	_tmp8_ = self->priv->alert_view;
	gtk_list_box_set_placeholder ((GtkListBox*) _tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->list_box;
	g_signal_connect_object (_tmp9_, "close-request", (GCallback) __slingshot_widgets_search_view___lambda52__slingshot_app_list_box_close_request, self, 0);
	_tmp10_ = self->priv->list_box;
	g_signal_connect_object ((GtkListBox*) _tmp10_, "row-activated", (GCallback) __slingshot_widgets_search_view___lambda53__gtk_list_box_row_activated, self, 0);
	_tmp11_ = self->priv->list_box;
	g_signal_connect_object ((GtkWidget*) _tmp11_, "button-press-event", (GCallback) __slingshot_widgets_search_view___lambda55__gtk_widget_button_press_event, self, 0);
	_tmp12_ = self->priv->list_box;
	g_signal_connect_object ((GtkWidget*) _tmp12_, "key-press-event", (GCallback) __slingshot_widgets_search_view___lambda56__gtk_widget_key_press_event, self, 0);
	_tmp13_ = self->priv->list_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp13_);
	return obj;
}

static void
slingshot_widgets_search_view_class_init (SlingshotWidgetsSearchViewClass * klass,
                                          gpointer klass_data)
{
	slingshot_widgets_search_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotWidgetsSearchView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = slingshot_widgets_search_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_widgets_search_view_finalize;
	slingshot_widgets_search_view_signals[SLINGSHOT_WIDGETS_SEARCH_VIEW_START_SEARCH_SIGNAL] = g_signal_new ("start-search", SLINGSHOT_WIDGETS_TYPE_SEARCH_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, SYNAPSE_TYPE_SEARCH_MATCH, SYNAPSE_TYPE_MATCH);
	slingshot_widgets_search_view_signals[SLINGSHOT_WIDGETS_SEARCH_VIEW_APP_LAUNCHED_SIGNAL] = g_signal_new ("app-launched", SLINGSHOT_WIDGETS_TYPE_SEARCH_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
slingshot_widgets_search_view_instance_init (SlingshotWidgetsSearchView * self,
                                             gpointer klass)
{
	self->priv = slingshot_widgets_search_view_get_instance_private (self);
}

static void
slingshot_widgets_search_view_finalize (GObject * obj)
{
	SlingshotWidgetsSearchView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_WIDGETS_TYPE_SEARCH_VIEW, SlingshotWidgetsSearchView);
	_g_object_unref0 (self->priv->alert_view);
	_g_object_unref0 (self->priv->list_box);
	_g_object_unref0 (self->priv->limitator);
	G_OBJECT_CLASS (slingshot_widgets_search_view_parent_class)->finalize (obj);
}

static GType
slingshot_widgets_search_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotWidgetsSearchViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_widgets_search_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotWidgetsSearchView), 0, (GInstanceInitFunc) slingshot_widgets_search_view_instance_init, NULL };
	GType slingshot_widgets_search_view_type_id;
	slingshot_widgets_search_view_type_id = g_type_register_static (gtk_scrolled_window_get_type (), "SlingshotWidgetsSearchView", &g_define_type_info, 0);
	SlingshotWidgetsSearchView_private_offset = g_type_add_instance_private (slingshot_widgets_search_view_type_id, sizeof (SlingshotWidgetsSearchViewPrivate));
	return slingshot_widgets_search_view_type_id;
}

GType
slingshot_widgets_search_view_get_type (void)
{
	static volatile gsize slingshot_widgets_search_view_type_id__once = 0;
	if (g_once_init_enter (&slingshot_widgets_search_view_type_id__once)) {
		GType slingshot_widgets_search_view_type_id;
		slingshot_widgets_search_view_type_id = slingshot_widgets_search_view_get_type_once ();
		g_once_init_leave (&slingshot_widgets_search_view_type_id__once, slingshot_widgets_search_view_type_id);
	}
	return slingshot_widgets_search_view_type_id__once;
}

