/* Indicator.c generated by valac 0.56.8, the Vala compiler
 * generated from Indicator.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 *           2011-2012 Giulio Collura
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "slingshot.h"
#include <gtk/gtk.h>
#include <wingpanel.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <plank.h>
#include <glib/gi18n-lib.h>
#include <granite.h>
#include <gmodule.h>

#define SLINGSHOT_INDICATOR_KEYBINDING_SCHEMA "org.pantheon.desktop.gala.keybindings"
#define SLINGSHOT_INDICATOR_GALA_BEHAVIOR_SCHEMA "org.pantheon.desktop.gala.behavior"

enum  {
	SLINGSHOT_INDICATOR_0_PROPERTY,
	SLINGSHOT_INDICATOR_NUM_PROPERTIES
};
static GParamSpec* slingshot_indicator_properties[SLINGSHOT_INDICATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))

struct _SlingshotIndicatorPrivate {
	SlingshotDBusService* dbus_service;
	GtkGrid* indicator_grid;
	SlingshotSlingshotView* view;
};

static gint SlingshotIndicator_private_offset;
static gpointer slingshot_indicator_parent_class = NULL;
static GSettings* slingshot_indicator_keybinding_settings;
static GSettings* slingshot_indicator_keybinding_settings = NULL;
static GSettings* slingshot_indicator_gala_behavior_settings;
static GSettings* slingshot_indicator_gala_behavior_settings = NULL;

static void slingshot_indicator_on_close_indicator (SlingshotIndicator* self);
static GtkWidget* slingshot_indicator_real_get_widget (WingpanelIndicator* base);
static void _slingshot_indicator_on_close_indicator_slingshot_slingshot_view_close_indicator (SlingshotSlingshotView* _sender,
                                                                                       gpointer self);
static GtkWidget* slingshot_indicator_real_get_display_widget (WingpanelIndicator* base);
static void slingshot_indicator_update_tooltip (SlingshotIndicator* self);
static void ____lambda83_ (SlingshotIndicator* self,
                    const gchar* key);
static void _____lambda83__g_settings_changed (GSettings* _sender,
                                        const gchar* key,
                                        gpointer self);
static void ____lambda84_ (SlingshotIndicator* self,
                    const gchar* key);
static void _____lambda84__g_settings_changed (GSettings* _sender,
                                        const gchar* key,
                                        gpointer self);
static void slingshot_indicator_real_opened (WingpanelIndicator* base);
static void slingshot_indicator_real_closed (WingpanelIndicator* base);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static GObject * slingshot_indicator_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void slingshot_indicator_finalize (GObject * obj);
static GType slingshot_indicator_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
slingshot_indicator_get_instance_private (SlingshotIndicator* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotIndicator_private_offset);
}

SlingshotIndicator*
slingshot_indicator_construct (GType object_type)
{
	SlingshotIndicator * self = NULL;
	self = (SlingshotIndicator*) g_object_new (object_type, "code-name", WINGPANEL_INDICATOR_APP_LAUNCHER, NULL);
	return self;
}

SlingshotIndicator*
slingshot_indicator_new (void)
{
	return slingshot_indicator_construct (SLINGSHOT_TYPE_INDICATOR);
}

static void
slingshot_indicator_on_close_indicator (SlingshotIndicator* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name ((WingpanelIndicator*) self, "close");
}

static void
_slingshot_indicator_on_close_indicator_slingshot_slingshot_view_close_indicator (SlingshotSlingshotView* _sender,
                                                                                  gpointer self)
{
	slingshot_indicator_on_close_indicator ((SlingshotIndicator*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
slingshot_indicator_real_get_widget (WingpanelIndicator* base)
{
	SlingshotIndicator * self;
	SlingshotSlingshotView* _tmp0_;
	SlingshotSlingshotView* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* result;
	self = (SlingshotIndicator*) base;
	_tmp0_ = self->priv->view;
	if (_tmp0_ == NULL) {
		SlingshotSlingshotView* _tmp1_;
		PlankUnity* client = NULL;
		PlankUnity* _tmp2_;
		PlankUnity* _tmp3_;
		SlingshotSlingshotView* _tmp4_;
		SlingshotSlingshotView* _tmp5_;
		SlingshotDBusService* _tmp6_;
		_tmp1_ = slingshot_slingshot_view_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->view);
		self->priv->view = _tmp1_;
		_tmp2_ = plank_unity_get_default ();
		client = _tmp2_;
		_tmp3_ = client;
		_tmp4_ = self->priv->view;
		plank_unity_add_client (_tmp3_, (PlankUnityClient*) _tmp4_);
		_tmp5_ = self->priv->view;
		g_signal_connect_object (_tmp5_, "close-indicator", (GCallback) _slingshot_indicator_on_close_indicator_slingshot_slingshot_view_close_indicator, self, 0);
		_tmp6_ = self->priv->dbus_service;
		if (_tmp6_ == NULL) {
			SlingshotSlingshotView* _tmp7_;
			SlingshotDBusService* _tmp8_;
			_tmp7_ = self->priv->view;
			_tmp8_ = slingshot_dbus_service_new (_tmp7_);
			_g_object_unref0 (self->priv->dbus_service);
			self->priv->dbus_service = _tmp8_;
		}
	}
	_tmp9_ = self->priv->view;
	_tmp10_ = _g_object_ref0 ((GtkWidget*) _tmp9_);
	result = _tmp10_;
	return result;
}

static void
____lambda83_ (SlingshotIndicator* self,
               const gchar* key)
{
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "panel-main-menu") == 0) {
		slingshot_indicator_update_tooltip (self);
	}
}

static void
_____lambda83__g_settings_changed (GSettings* _sender,
                                   const gchar* key,
                                   gpointer self)
{
	____lambda83_ ((SlingshotIndicator*) self, key);
}

static void
____lambda84_ (SlingshotIndicator* self,
               const gchar* key)
{
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "overlay-action") == 0) {
		slingshot_indicator_update_tooltip (self);
	}
}

static void
_____lambda84__g_settings_changed (GSettings* _sender,
                                   const gchar* key,
                                   gpointer self)
{
	____lambda84_ ((SlingshotIndicator*) self, key);
}

static GtkWidget*
slingshot_indicator_real_get_display_widget (WingpanelIndicator* base)
{
	SlingshotIndicator * self;
	GtkGrid* _tmp0_;
	GtkGrid* _tmp13_;
	GtkWidget* _tmp14_;
	GtkWidget* result;
	self = (SlingshotIndicator*) base;
	_tmp0_ = self->priv->indicator_grid;
	if (_tmp0_ == NULL) {
		GtkLabel* indicator_label = NULL;
		GtkLabel* _tmp1_;
		GtkLabel* _tmp2_;
		GtkImage* indicator_icon = NULL;
		GtkImage* _tmp3_;
		GtkGrid* _tmp4_;
		GtkGrid* _tmp5_;
		GtkImage* _tmp6_;
		GtkGrid* _tmp7_;
		GtkLabel* _tmp8_;
		GSettings* _tmp9_;
		GSettings* _tmp11_;
		_tmp1_ = (GtkLabel*) gtk_label_new (_ ("Applications"));
		g_object_ref_sink (_tmp1_);
		indicator_label = _tmp1_;
		_tmp2_ = indicator_label;
		gtk_widget_set_vexpand ((GtkWidget*) _tmp2_, TRUE);
		_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name ("system-search-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
		g_object_ref_sink (_tmp3_);
		indicator_icon = _tmp3_;
		_tmp4_ = (GtkGrid*) gtk_grid_new ();
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (self->priv->indicator_grid);
		self->priv->indicator_grid = _tmp4_;
		_tmp5_ = self->priv->indicator_grid;
		_tmp6_ = indicator_icon;
		gtk_grid_attach (_tmp5_, (GtkWidget*) _tmp6_, 0, 0, 1, 1);
		_tmp7_ = self->priv->indicator_grid;
		_tmp8_ = indicator_label;
		gtk_grid_attach (_tmp7_, (GtkWidget*) _tmp8_, 1, 0, 1, 1);
		slingshot_indicator_update_tooltip (self);
		_tmp9_ = slingshot_indicator_keybinding_settings;
		if (_tmp9_ != NULL) {
			GSettings* _tmp10_;
			_tmp10_ = slingshot_indicator_keybinding_settings;
			g_signal_connect_object (_tmp10_, "changed", (GCallback) _____lambda83__g_settings_changed, self, 0);
		}
		_tmp11_ = slingshot_indicator_gala_behavior_settings;
		if (_tmp11_ != NULL) {
			GSettings* _tmp12_;
			_tmp12_ = slingshot_indicator_gala_behavior_settings;
			g_signal_connect_object (_tmp12_, "changed", (GCallback) _____lambda84__g_settings_changed, self, 0);
		}
		_g_object_unref0 (indicator_icon);
		_g_object_unref0 (indicator_label);
	}
	wingpanel_indicator_set_visible ((WingpanelIndicator*) self, TRUE);
	_tmp13_ = self->priv->indicator_grid;
	_tmp14_ = _g_object_ref0 ((GtkWidget*) _tmp13_);
	result = _tmp14_;
	return result;
}

static void
slingshot_indicator_real_opened (WingpanelIndicator* base)
{
	SlingshotIndicator * self;
	SlingshotSlingshotView* _tmp0_;
	self = (SlingshotIndicator*) base;
	_tmp0_ = self->priv->view;
	if (_tmp0_ != NULL) {
		SlingshotSlingshotView* _tmp1_;
		_tmp1_ = self->priv->view;
		slingshot_slingshot_view_show_slingshot (_tmp1_);
	}
}

static void
slingshot_indicator_real_closed (WingpanelIndicator* base)
{
	SlingshotIndicator * self;
	self = (SlingshotIndicator*) base;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
slingshot_indicator_update_tooltip (SlingshotIndicator* self)
{
	gchar** accels = NULL;
	gchar** _tmp0_;
	gint accels_length1;
	gint _accels_size_;
	gboolean _tmp1_ = FALSE;
	GSettings* _tmp2_;
	GSettings* _tmp11_;
	GtkGrid* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar* _tmp19_;
	gchar* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	accels = _tmp0_;
	accels_length1 = 0;
	_accels_size_ = accels_length1;
	_tmp2_ = slingshot_indicator_keybinding_settings;
	if (_tmp2_ != NULL) {
		GtkGrid* _tmp3_;
		_tmp3_ = self->priv->indicator_grid;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar** raw_accels = NULL;
		GSettings* _tmp4_;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gint raw_accels_length1;
		gint _raw_accels_size_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		_tmp4_ = slingshot_indicator_keybinding_settings;
		_tmp6_ = _tmp5_ = g_settings_get_strv (_tmp4_, "panel-main-menu");
		raw_accels = _tmp6_;
		raw_accels_length1 = _vala_array_length (_tmp5_);
		_raw_accels_size_ = raw_accels_length1;
		_tmp7_ = raw_accels;
		_tmp7__length1 = raw_accels_length1;
		{
			gchar** raw_accel_collection = NULL;
			gint raw_accel_collection_length1 = 0;
			gint _raw_accel_collection_size_ = 0;
			gint raw_accel_it = 0;
			raw_accel_collection = _tmp7_;
			raw_accel_collection_length1 = _tmp7__length1;
			for (raw_accel_it = 0; raw_accel_it < raw_accel_collection_length1; raw_accel_it = raw_accel_it + 1) {
				const gchar* raw_accel = NULL;
				raw_accel = raw_accel_collection[raw_accel_it];
				{
					const gchar* _tmp8_;
					_tmp8_ = raw_accel;
					if (g_strcmp0 (_tmp8_, "") != 0) {
						const gchar* _tmp9_;
						gchar* _tmp10_;
						_tmp9_ = raw_accel;
						_tmp10_ = g_strdup (_tmp9_);
						_vala_array_add1 (&accels, &accels_length1, &_accels_size_, _tmp10_);
					}
				}
			}
		}
		raw_accels = (_vala_array_free (raw_accels, raw_accels_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp11_ = slingshot_indicator_gala_behavior_settings;
	if (_tmp11_ != NULL) {
		GSettings* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean _tmp15_;
		_tmp12_ = slingshot_indicator_gala_behavior_settings;
		_tmp13_ = g_settings_get_string (_tmp12_, "overlay-action");
		_tmp14_ = _tmp13_;
		_tmp15_ = string_contains (_tmp14_, "wingpanel");
		_g_free0 (_tmp14_);
		if (_tmp15_) {
			gchar* _tmp16_;
			_tmp16_ = g_strdup ("<Super>");
			_vala_array_add2 (&accels, &accels_length1, &_accels_size_, _tmp16_);
		}
	}
	_tmp17_ = self->priv->indicator_grid;
	_tmp18_ = accels;
	_tmp18__length1 = accels_length1;
	_tmp19_ = granite_markup_accel_tooltip (_tmp18_, (gint) _tmp18__length1, _ ("Open and search apps"));
	_tmp20_ = _tmp19_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp17_, _tmp20_);
	_g_free0 (_tmp20_);
	accels = (_vala_array_free (accels, accels_length1, (GDestroyNotify) g_free), NULL);
}

static GObject *
slingshot_indicator_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotIndicator * self;
	GtkIconTheme* default_theme = NULL;
	GtkIconTheme* _tmp0_;
	GtkIconTheme* _tmp1_;
	parent_class = G_OBJECT_CLASS (slingshot_indicator_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_TYPE_INDICATOR, SlingshotIndicator);
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gtk_icon_theme_get_default ();
	default_theme = _tmp0_;
	_tmp1_ = default_theme;
	gtk_icon_theme_add_resource_path (_tmp1_, "/io/elementary/desktop/wingpanel/applications-menu/icons");
	return obj;
}

static void
slingshot_indicator_class_init (SlingshotIndicatorClass * klass,
                                gpointer klass_data)
{
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchema* _tmp1_;
	GSettingsSchema* _tmp2_;
	gboolean _tmp3_;
	GSettingsSchemaSource* _tmp5_;
	GSettingsSchema* _tmp6_;
	GSettingsSchema* _tmp7_;
	gboolean _tmp8_;
	slingshot_indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotIndicator_private_offset);
	((WingpanelIndicatorClass *) klass)->get_widget = (GtkWidget* (*) (WingpanelIndicator*)) slingshot_indicator_real_get_widget;
	((WingpanelIndicatorClass *) klass)->get_display_widget = (GtkWidget* (*) (WingpanelIndicator*)) slingshot_indicator_real_get_display_widget;
	((WingpanelIndicatorClass *) klass)->opened = (void (*) (WingpanelIndicator*)) slingshot_indicator_real_opened;
	((WingpanelIndicatorClass *) klass)->closed = (void (*) (WingpanelIndicator*)) slingshot_indicator_real_closed;
	G_OBJECT_CLASS (klass)->constructor = slingshot_indicator_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_indicator_finalize;
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = g_settings_schema_source_lookup (_tmp0_, SLINGSHOT_INDICATOR_KEYBINDING_SCHEMA, TRUE);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_settings_schema_unref0 (_tmp2_);
	if (_tmp3_) {
		GSettings* _tmp4_;
		_tmp4_ = g_settings_new (SLINGSHOT_INDICATOR_KEYBINDING_SCHEMA);
		_g_object_unref0 (slingshot_indicator_keybinding_settings);
		slingshot_indicator_keybinding_settings = _tmp4_;
	}
	_tmp5_ = g_settings_schema_source_get_default ();
	_tmp6_ = g_settings_schema_source_lookup (_tmp5_, SLINGSHOT_INDICATOR_GALA_BEHAVIOR_SCHEMA, TRUE);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_ != NULL;
	_g_settings_schema_unref0 (_tmp7_);
	if (_tmp8_) {
		GSettings* _tmp9_;
		_tmp9_ = g_settings_new (SLINGSHOT_INDICATOR_GALA_BEHAVIOR_SCHEMA);
		_g_object_unref0 (slingshot_indicator_gala_behavior_settings);
		slingshot_indicator_gala_behavior_settings = _tmp9_;
	}
}

static void
slingshot_indicator_instance_init (SlingshotIndicator * self,
                                   gpointer klass)
{
	self->priv = slingshot_indicator_get_instance_private (self);
	self->priv->dbus_service = NULL;
	self->priv->indicator_grid = NULL;
	self->priv->view = NULL;
}

static void
slingshot_indicator_finalize (GObject * obj)
{
	SlingshotIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_TYPE_INDICATOR, SlingshotIndicator);
	_g_object_unref0 (self->priv->dbus_service);
	_g_object_unref0 (self->priv->indicator_grid);
	_g_object_unref0 (self->priv->view);
	G_OBJECT_CLASS (slingshot_indicator_parent_class)->finalize (obj);
}

static GType
slingshot_indicator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotIndicator), 0, (GInstanceInitFunc) slingshot_indicator_instance_init, NULL };
	GType slingshot_indicator_type_id;
	slingshot_indicator_type_id = g_type_register_static (WINGPANEL_TYPE_INDICATOR, "SlingshotIndicator", &g_define_type_info, 0);
	SlingshotIndicator_private_offset = g_type_add_instance_private (slingshot_indicator_type_id, sizeof (SlingshotIndicatorPrivate));
	return slingshot_indicator_type_id;
}

GType
slingshot_indicator_get_type (void)
{
	static volatile gsize slingshot_indicator_type_id__once = 0;
	if (g_once_init_enter (&slingshot_indicator_type_id__once)) {
		GType slingshot_indicator_type_id;
		slingshot_indicator_type_id = slingshot_indicator_get_type_once ();
		g_once_init_leave (&slingshot_indicator_type_id__once, slingshot_indicator_type_id);
	}
	return slingshot_indicator_type_id__once;
}

WingpanelIndicator*
get_indicator (GModule* module,
               WingpanelIndicatorManagerServerType server_type)
{
	SlingshotIndicator* indicator = NULL;
	SlingshotIndicator* _tmp0_;
	WingpanelIndicator* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Indicator.vala:144: Activating Slingshot");
	if (server_type == WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_GREETER) {
		result = NULL;
		return result;
	}
	_tmp0_ = slingshot_indicator_new ();
	indicator = _tmp0_;
	result = (WingpanelIndicator*) indicator;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

