/* SynapseSearch.c generated by valac 0.56.8, the Vala compiler
 * generated from SynapseSearch.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/**/
/*  Copyright (C) 2011-2012 Giulio Collura*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "slingshot.h"
#include <gio/gio.h>
#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

enum  {
	SLINGSHOT_BACKEND_SYNAPSE_SEARCH_0_PROPERTY,
	SLINGSHOT_BACKEND_SYNAPSE_SEARCH_NUM_PROPERTIES
};
static GParamSpec* slingshot_backend_synapse_search_properties[SLINGSHOT_BACKEND_SYNAPSE_SEARCH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SlingshotBackendSynapseSearchSearchData SlingshotBackendSynapseSearchSearchData;

struct _SlingshotBackendSynapseSearchPrivate {
	GCancellable* current_search;
};

struct _SlingshotBackendSynapseSearchSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SlingshotBackendSynapseSearch* self;
	gchar* text;
	SynapseSearchProvider* provider;
	GeeList* result;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	SynapseDataSink* _tmp2_;
	SynapseResultSet* results;
	SynapseResultSet* _tmp4_;
	GeeList* _tmp5_;
	GCancellable* _tmp6_;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	GError* e;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError* _inner_error0_;
};

static gint SlingshotBackendSynapseSearch_private_offset;
static gpointer slingshot_backend_synapse_search_parent_class = NULL;
static GType* slingshot_backend_synapse_search_plugins;
static gint slingshot_backend_synapse_search_plugins_length1;
static GType* slingshot_backend_synapse_search_plugins = NULL;
static gint slingshot_backend_synapse_search_plugins_length1 = 0;
static gint _slingshot_backend_synapse_search_plugins_size_ = 0;
static SynapseDataSink* slingshot_backend_synapse_search_sink;
static SynapseDataSink* slingshot_backend_synapse_search_sink = NULL;
static GeeHashMap* slingshot_backend_synapse_search_favicon_cache;
static GeeHashMap* slingshot_backend_synapse_search_favicon_cache = NULL;

static void slingshot_backend_synapse_search_search_data_free (gpointer _data);
static gboolean slingshot_backend_synapse_search_search_co (SlingshotBackendSynapseSearchSearchData* _data_);
static void slingshot_backend_synapse_search_search_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void slingshot_backend_synapse_search_finalize (GObject * obj);
static GType slingshot_backend_synapse_search_get_type_once (void);

static inline gpointer
slingshot_backend_synapse_search_get_instance_private (SlingshotBackendSynapseSearch* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotBackendSynapseSearch_private_offset);
}

SlingshotBackendSynapseSearch*
slingshot_backend_synapse_search_construct (GType object_type)
{
	SlingshotBackendSynapseSearch * self = NULL;
	SynapseDataSink* _tmp0_;
	self = (SlingshotBackendSynapseSearch*) g_object_new (object_type, NULL);
	_tmp0_ = slingshot_backend_synapse_search_sink;
	if (_tmp0_ == NULL) {
		SynapseDataSink* _tmp1_;
		GType* _tmp2_;
		gint _tmp2__length1;
		GeeHashMap* _tmp4_;
		_tmp1_ = synapse_data_sink_new ();
		_g_object_unref0 (slingshot_backend_synapse_search_sink);
		slingshot_backend_synapse_search_sink = _tmp1_;
		_tmp2_ = slingshot_backend_synapse_search_plugins;
		_tmp2__length1 = slingshot_backend_synapse_search_plugins_length1;
		{
			GType* plugin_collection = NULL;
			gint plugin_collection_length1 = 0;
			gint _plugin_collection_size_ = 0;
			gint plugin_it = 0;
			plugin_collection = _tmp2_;
			plugin_collection_length1 = _tmp2__length1;
			for (plugin_it = 0; plugin_it < plugin_collection_length1; plugin_it = plugin_it + 1) {
				GType plugin = 0UL;
				plugin = plugin_collection[plugin_it];
				{
					SynapseDataSink* _tmp3_;
					_tmp3_ = slingshot_backend_synapse_search_sink;
					synapse_data_sink_register_static_plugin (_tmp3_, plugin);
				}
			}
		}
		_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gdk_pixbuf_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (slingshot_backend_synapse_search_favicon_cache);
		slingshot_backend_synapse_search_favicon_cache = _tmp4_;
	}
	return self;
}

SlingshotBackendSynapseSearch*
slingshot_backend_synapse_search_new (void)
{
	return slingshot_backend_synapse_search_construct (SLINGSHOT_BACKEND_TYPE_SYNAPSE_SEARCH);
}

static void
slingshot_backend_synapse_search_search_data_free (gpointer _data)
{
	SlingshotBackendSynapseSearchSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->text);
	_g_object_unref0 (_data_->provider);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SlingshotBackendSynapseSearchSearchData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
slingshot_backend_synapse_search_search (SlingshotBackendSynapseSearch* self,
                                         const gchar* text,
                                         SynapseSearchProvider* provider,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	SlingshotBackendSynapseSearchSearchData* _data_;
	SlingshotBackendSynapseSearch* _tmp0_;
	gchar* _tmp1_;
	SynapseSearchProvider* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_data_ = g_slice_new0 (SlingshotBackendSynapseSearchSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, slingshot_backend_synapse_search_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (text);
	_g_free0 (_data_->text);
	_data_->text = _tmp1_;
	_tmp2_ = _g_object_ref0 (provider);
	_g_object_unref0 (_data_->provider);
	_data_->provider = _tmp2_;
	slingshot_backend_synapse_search_search_co (_data_);
}

GeeList*
slingshot_backend_synapse_search_search_finish (SlingshotBackendSynapseSearch* self,
                                                GAsyncResult* _res_)
{
	GeeList* result;
	SlingshotBackendSynapseSearchSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
slingshot_backend_synapse_search_search_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	SlingshotBackendSynapseSearchSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	slingshot_backend_synapse_search_search_co (_data_);
}

static gboolean
slingshot_backend_synapse_search_search_co (SlingshotBackendSynapseSearchSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->current_search;
	if (_data_->_tmp0_ != NULL) {
		_data_->_tmp1_ = _data_->self->priv->current_search;
		g_cancellable_cancel (_data_->_tmp1_);
	}
	if (_data_->provider == NULL) {
		SynapseSearchProvider* _tmp3_;
		_data_->_tmp2_ = slingshot_backend_synapse_search_sink;
		_tmp3_ = _g_object_ref0 ((SynapseSearchProvider*) _data_->_tmp2_);
		_g_object_unref0 (_data_->provider);
		_data_->provider = _tmp3_;
	}
	_data_->_tmp4_ = synapse_result_set_new ();
	_data_->results = _data_->_tmp4_;
	{
		_data_->_tmp6_ = _data_->self->priv->current_search;
		_data_->_state_ = 1;
		synapse_search_provider_search (_data_->provider, _data_->text, SYNAPSE_QUERY_FLAGS_ALL, _data_->results, _data_->_tmp6_, slingshot_backend_synapse_search_search_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = synapse_search_provider_search_finish (_data_->provider, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp5_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp8_ = _data_->_tmp5_;
		_data_->_tmp5_ = NULL;
		_data_->result = _data_->_tmp8_;
		_g_object_unref0 (_data_->_tmp5_);
		_g_object_unref0 (_data_->results);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp9_ = _data_->e;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		g_warning ("SynapseSearch.vala:64: %s", _data_->_tmp10_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->results);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = NULL;
	_g_object_unref0 (_data_->results);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

GeeList*
slingshot_backend_synapse_search_find_actions_for_match (SynapseMatch* match)
{
	SynapseDataSink* _tmp0_;
	GeeList* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (match != NULL, NULL);
	_tmp0_ = slingshot_backend_synapse_search_sink;
	_tmp1_ = synapse_data_sink_find_actions_for_match (_tmp0_, match, NULL, SYNAPSE_QUERY_FLAGS_ALL);
	result = _tmp1_;
	return result;
}

GdkPixbuf*
slingshot_backend_synapse_search_get_pathicon_for_match (SynapseMatch* match,
                                                         gint size)
{
	GdkPixbuf* pixbuf = NULL;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (match != NULL, NULL);
	pixbuf = NULL;
	{
		GFile* file = NULL;
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		_tmp0_ = synapse_match_get_icon_name (match);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_file_new_for_path (_tmp1_);
		file = _tmp2_;
		_tmp3_ = file;
		if (g_file_query_exists (_tmp3_, NULL)) {
			GdkPixbuf* _tmp4_ = NULL;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			GdkPixbuf* _tmp7_;
			GdkPixbuf* _tmp8_;
			_tmp5_ = synapse_match_get_icon_name (match);
			_tmp6_ = _tmp5_;
			_tmp7_ = gdk_pixbuf_new_from_file_at_scale (_tmp6_, size, size, TRUE, &_inner_error0_);
			_tmp4_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				goto __catch0_g_error;
			}
			_tmp8_ = _tmp4_;
			_tmp4_ = NULL;
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp8_;
			_g_object_unref0 (_tmp4_);
		}
		_g_object_unref0 (file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("SynapseSearch.vala:81: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = pixbuf;
	return result;
}

static void
slingshot_backend_synapse_search_class_init (SlingshotBackendSynapseSearchClass * klass,
                                             gpointer klass_data)
{
	GType* _tmp0_;
	slingshot_backend_synapse_search_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotBackendSynapseSearch_private_offset);
	G_OBJECT_CLASS (klass)->finalize = slingshot_backend_synapse_search_finalize;
	_tmp0_ = g_new0 (GType, 9);
	_tmp0_[0] = SYNAPSE_TYPE_CALCULATOR_PLUGIN;
	_tmp0_[1] = SYNAPSE_TYPE_CONVERTER_PLUGIN;
	_tmp0_[2] = SYNAPSE_TYPE_COMMAND_PLUGIN;
	_tmp0_[3] = SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN;
	_tmp0_[4] = SYNAPSE_TYPE_SWITCHBOARD_PLUGIN;
	_tmp0_[5] = SYNAPSE_TYPE_SYSTEM_MANAGEMENT_PLUGIN;
	_tmp0_[6] = SYNAPSE_TYPE_LINK_PLUGIN;
	_tmp0_[7] = SYNAPSE_TYPE_APPCENTER_PLUGIN;
	_tmp0_[8] = SYNAPSE_TYPE_FILE_BOOKMARK_PLUGIN;
	slingshot_backend_synapse_search_plugins = _tmp0_;
	slingshot_backend_synapse_search_plugins_length1 = 9;
	_slingshot_backend_synapse_search_plugins_size_ = slingshot_backend_synapse_search_plugins_length1;
}

static void
slingshot_backend_synapse_search_instance_init (SlingshotBackendSynapseSearch * self,
                                                gpointer klass)
{
	self->priv = slingshot_backend_synapse_search_get_instance_private (self);
	self->priv->current_search = NULL;
}

static void
slingshot_backend_synapse_search_finalize (GObject * obj)
{
	SlingshotBackendSynapseSearch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_BACKEND_TYPE_SYNAPSE_SEARCH, SlingshotBackendSynapseSearch);
	_g_object_unref0 (self->priv->current_search);
	G_OBJECT_CLASS (slingshot_backend_synapse_search_parent_class)->finalize (obj);
}

static GType
slingshot_backend_synapse_search_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotBackendSynapseSearchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_backend_synapse_search_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotBackendSynapseSearch), 0, (GInstanceInitFunc) slingshot_backend_synapse_search_instance_init, NULL };
	GType slingshot_backend_synapse_search_type_id;
	slingshot_backend_synapse_search_type_id = g_type_register_static (G_TYPE_OBJECT, "SlingshotBackendSynapseSearch", &g_define_type_info, 0);
	SlingshotBackendSynapseSearch_private_offset = g_type_add_instance_private (slingshot_backend_synapse_search_type_id, sizeof (SlingshotBackendSynapseSearchPrivate));
	return slingshot_backend_synapse_search_type_id;
}

GType
slingshot_backend_synapse_search_get_type (void)
{
	static volatile gsize slingshot_backend_synapse_search_type_id__once = 0;
	if (g_once_init_enter (&slingshot_backend_synapse_search_type_id__once)) {
		GType slingshot_backend_synapse_search_type_id;
		slingshot_backend_synapse_search_type_id = slingshot_backend_synapse_search_get_type_once ();
		g_once_init_leave (&slingshot_backend_synapse_search_type_id__once, slingshot_backend_synapse_search_type_id);
	}
	return slingshot_backend_synapse_search_type_id__once;
}

