/* RelevancyService.c generated by valac 0.56.8, the Vala compiler
 * generated from RelevancyService.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/**/
/*  Copyright (C) 2011-2012 Slingshot Developers*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/
/*  Thanks to Synapse Developers for this class*/

#include "slingshot.h"
#include <zeitgeist.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <zeitgeist-datamodel.h>

#define SLINGSHOT_BACKEND_RELEVANCY_SERVICE_MULTIPLIER 65535.0f

enum  {
	SLINGSHOT_BACKEND_RELEVANCY_SERVICE_0_PROPERTY,
	SLINGSHOT_BACKEND_RELEVANCY_SERVICE_NUM_PROPERTIES
};
static GParamSpec* slingshot_backend_relevancy_service_properties[SLINGSHOT_BACKEND_RELEVANCY_SERVICE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SlingshotBackendRelevancyServiceCheckDataSourcesData SlingshotBackendRelevancyServiceCheckDataSourcesData;
typedef struct _SlingshotBackendRelevancyServiceLoadApplicationRelevanciesData SlingshotBackendRelevancyServiceLoadApplicationRelevanciesData;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	SLINGSHOT_BACKEND_RELEVANCY_SERVICE_UPDATE_COMPLETE_SIGNAL,
	SLINGSHOT_BACKEND_RELEVANCY_SERVICE_NUM_SIGNALS
};
static guint slingshot_backend_relevancy_service_signals[SLINGSHOT_BACKEND_RELEVANCY_SERVICE_NUM_SIGNALS] = {0};

struct _SlingshotBackendRelevancyServicePrivate {
	ZeitgeistLog* zg_log;
	ZeitgeistDataSourceRegistry* zg_dsr;
	GeeHashMap* app_popularity;
	gboolean has_datahub_gio_module;
	gboolean refreshing;
};

struct _SlingshotBackendRelevancyServiceCheckDataSourcesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SlingshotBackendRelevancyService* self;
	ZeitgeistDataSourceRegistry* _tmp0_;
	GPtrArray* ptr_arr;
	ZeitgeistDataSourceRegistry* _tmp1_;
	GPtrArray* _tmp2_;
	guint i;
	gboolean _tmp3_;
	guint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	ZeitgeistDataSource* ds;
	gconstpointer _tmp7_;
	gboolean _tmp8_;
	ZeitgeistDataSource* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	ZeitgeistDataSource* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	GError* e;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _inner_error0_;
};

struct _SlingshotBackendRelevancyServiceLoadApplicationRelevanciesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SlingshotBackendRelevancyService* self;
	gint64 end;
	gint64 start;
	ZeitgeistTimeRange* tr;
	ZeitgeistTimeRange* _tmp0_;
	ZeitgeistEvent* event;
	ZeitgeistEvent* _tmp1_;
	ZeitgeistEvent* _tmp2_;
	ZeitgeistSubject* subject;
	ZeitgeistSubject* _tmp3_;
	ZeitgeistSubject* _tmp4_;
	ZeitgeistSubject* _tmp5_;
	ZeitgeistEvent* _tmp6_;
	ZeitgeistSubject* _tmp7_;
	GPtrArray* ptr_arr;
	GPtrArray* _tmp8_;
	GPtrArray* _tmp9_;
	ZeitgeistEvent* _tmp10_;
	ZeitgeistEvent* _tmp11_;
	ZeitgeistResultSet* rs;
	ZeitgeistLog* _tmp12_;
	ZeitgeistTimeRange* _tmp13_;
	GPtrArray* _tmp14_;
	ZeitgeistResultSet* _tmp15_;
	GeeHashMap* _tmp16_;
	guint size;
	ZeitgeistResultSet* _tmp17_;
	guint index;
	ZeitgeistResultSet* _e_it;
	ZeitgeistResultSet* _tmp18_;
	ZeitgeistResultSet* _tmp19_;
	ZeitgeistEvent* e;
	ZeitgeistResultSet* _tmp20_;
	ZeitgeistEvent* _tmp21_;
	ZeitgeistEvent* _tmp22_;
	ZeitgeistEvent* _tmp23_;
	ZeitgeistSubject* s;
	ZeitgeistEvent* _tmp24_;
	ZeitgeistSubject* _tmp25_;
	gfloat power;
	gfloat relevancy;
	GeeHashMap* _tmp26_;
	ZeitgeistSubject* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	guint _tmp30_;
	GError* err;
	GError* _tmp31_;
	const gchar* _tmp32_;
	GError* _inner_error0_;
};

static gint SlingshotBackendRelevancyService_private_offset;
static gpointer slingshot_backend_relevancy_service_parent_class = NULL;

static void slingshot_backend_relevancy_service_check_data_sources (SlingshotBackendRelevancyService* self,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static void slingshot_backend_relevancy_service_check_data_sources_finish (SlingshotBackendRelevancyService* self,
                                                                    GAsyncResult* _res_);
static gboolean _slingshot_backend_relevancy_service_refresh_popularity_gsource_func (gpointer self);
static void slingshot_backend_relevancy_service_check_data_sources_data_free (gpointer _data);
static gboolean slingshot_backend_relevancy_service_check_data_sources_co (SlingshotBackendRelevancyServiceCheckDataSourcesData* _data_);
static void slingshot_backend_relevancy_service_check_data_sources_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_);
static void slingshot_backend_relevancy_service_load_application_relevancies (SlingshotBackendRelevancyService* self,
                                                                       GAsyncReadyCallback _callback_,
                                                                       gpointer _user_data_);
static void slingshot_backend_relevancy_service_load_application_relevancies_finish (SlingshotBackendRelevancyService* self,
                                                                              GAsyncResult* _res_);
static void slingshot_backend_relevancy_service_reload_relevancies (SlingshotBackendRelevancyService* self);
static gboolean __lambda23_ (SlingshotBackendRelevancyService* self);
static gboolean ___lambda23__gsource_func (gpointer self);
static void slingshot_backend_relevancy_service_load_application_relevancies_data_free (gpointer _data);
static gboolean slingshot_backend_relevancy_service_load_application_relevancies_co (SlingshotBackendRelevancyServiceLoadApplicationRelevanciesData* _data_);
static gboolean _slingshot_backend_relevancy_service_load_application_relevancies_co_gsource_func (gpointer self);
static void _g_object_unref0_ (gpointer var);
static void slingshot_backend_relevancy_service_load_application_relevancies_ready (GObject* source_object,
                                                                             GAsyncResult* _res_,
                                                                             gpointer _user_data_);
static void slingshot_backend_relevancy_service_push_app_launch (SlingshotBackendRelevancyService* self,
                                                          const gchar* app_uri,
                                                          const gchar* display_name);
static void slingshot_backend_relevancy_service_finalize (GObject * obj);
static GType slingshot_backend_relevancy_service_get_type_once (void);

static inline gpointer
slingshot_backend_relevancy_service_get_instance_private (SlingshotBackendRelevancyService* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotBackendRelevancyService_private_offset);
}

static gboolean
_slingshot_backend_relevancy_service_refresh_popularity_gsource_func (gpointer self)
{
	gboolean result;
	result = slingshot_backend_relevancy_service_refresh_popularity ((SlingshotBackendRelevancyService*) self);
	return result;
}

SlingshotBackendRelevancyService*
slingshot_backend_relevancy_service_construct (GType object_type)
{
	SlingshotBackendRelevancyService * self = NULL;
	ZeitgeistLog* _tmp0_;
	GeeHashMap* _tmp1_;
	self = (SlingshotBackendRelevancyService*) g_object_new (object_type, NULL);
	_tmp0_ = zeitgeist_log_new ();
	_g_object_unref0 (self->priv->zg_log);
	self->priv->zg_log = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->app_popularity);
	self->priv->app_popularity = _tmp1_;
	slingshot_backend_relevancy_service_refresh_popularity (self);
	slingshot_backend_relevancy_service_check_data_sources (self, NULL, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) (60 * 30), _slingshot_backend_relevancy_service_refresh_popularity_gsource_func, g_object_ref (self), g_object_unref);
	return self;
}

SlingshotBackendRelevancyService*
slingshot_backend_relevancy_service_new (void)
{
	return slingshot_backend_relevancy_service_construct (SLINGSHOT_BACKEND_TYPE_RELEVANCY_SERVICE);
}

static void
slingshot_backend_relevancy_service_check_data_sources_data_free (gpointer _data)
{
	SlingshotBackendRelevancyServiceCheckDataSourcesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SlingshotBackendRelevancyServiceCheckDataSourcesData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
slingshot_backend_relevancy_service_check_data_sources (SlingshotBackendRelevancyService* self,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	SlingshotBackendRelevancyServiceCheckDataSourcesData* _data_;
	SlingshotBackendRelevancyService* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SlingshotBackendRelevancyServiceCheckDataSourcesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, slingshot_backend_relevancy_service_check_data_sources_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	slingshot_backend_relevancy_service_check_data_sources_co (_data_);
}

static void
slingshot_backend_relevancy_service_check_data_sources_finish (SlingshotBackendRelevancyService* self,
                                                               GAsyncResult* _res_)
{
	SlingshotBackendRelevancyServiceCheckDataSourcesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
slingshot_backend_relevancy_service_check_data_sources_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_)
{
	SlingshotBackendRelevancyServiceCheckDataSourcesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	slingshot_backend_relevancy_service_check_data_sources_co (_data_);
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static gboolean
slingshot_backend_relevancy_service_check_data_sources_co (SlingshotBackendRelevancyServiceCheckDataSourcesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = zeitgeist_data_source_registry_new ();
	_g_object_unref0 (_data_->self->priv->zg_dsr);
	_data_->self->priv->zg_dsr = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->self->priv->zg_dsr;
		_data_->_state_ = 1;
		zeitgeist_data_source_registry_get_data_sources (_data_->_tmp1_, NULL, slingshot_backend_relevancy_service_check_data_sources_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = zeitgeist_data_source_registry_get_data_sources_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		_data_->ptr_arr = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			_data_->i = (guint) 0;
			{
				_data_->_tmp3_ = TRUE;
				while (TRUE) {
					if (!_data_->_tmp3_) {
						_data_->_tmp4_ = _data_->i;
						_data_->i = _data_->_tmp4_ + 1;
					}
					_data_->_tmp3_ = FALSE;
					_data_->_tmp5_ = vala_g_ptr_array_get_length (_data_->ptr_arr);
					_data_->_tmp6_ = _data_->_tmp5_;
					if (!(_data_->i < ((guint) _data_->_tmp6_))) {
						break;
					}
					_data_->_tmp7_ = g_ptr_array_index (_data_->ptr_arr, _data_->i);
					_data_->ds = G_TYPE_CHECK_INSTANCE_CAST ((ZeitgeistDataSource*) _data_->_tmp7_, ZEITGEIST_TYPE_DATA_SOURCE, ZeitgeistDataSource);
					_data_->_tmp9_ = _data_->ds;
					_data_->_tmp10_ = zeitgeist_data_source_get_unique_id (_data_->_tmp9_);
					_data_->_tmp11_ = _data_->_tmp10_;
					if (g_strcmp0 (_data_->_tmp11_, "com.zeitgeist-project,datahub,gio-launch-listener") == 0) {
						_data_->_tmp12_ = _data_->ds;
						_data_->_tmp13_ = zeitgeist_data_source_get_enabled (_data_->_tmp12_);
						_data_->_tmp14_ = _data_->_tmp13_;
						_data_->_tmp8_ = _data_->_tmp14_ == TRUE;
					} else {
						_data_->_tmp8_ = FALSE;
					}
					if (_data_->_tmp8_) {
						_data_->self->priv->has_datahub_gio_module = TRUE;
						break;
					}
				}
			}
		}
		_g_ptr_array_unref0 (_data_->ptr_arr);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp15_ = _data_->e;
		_data_->_tmp16_ = _data_->_tmp15_->message;
		g_critical ("RelevancyService.vala:63: %s", _data_->_tmp16_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gboolean
slingshot_backend_relevancy_service_refresh_popularity (SlingshotBackendRelevancyService* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	slingshot_backend_relevancy_service_load_application_relevancies (self, NULL, NULL);
	result = TRUE;
	return result;
}

static gboolean
__lambda23_ (SlingshotBackendRelevancyService* self)
{
	gboolean result;
	slingshot_backend_relevancy_service_load_application_relevancies (self, NULL, NULL);
	result = FALSE;
	return result;
}

static gboolean
___lambda23__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda23_ ((SlingshotBackendRelevancyService*) self);
	return result;
}

static void
slingshot_backend_relevancy_service_reload_relevancies (SlingshotBackendRelevancyService* self)
{
	g_return_if_fail (self != NULL);
	g_idle_add_full (G_PRIORITY_LOW, ___lambda23__gsource_func, g_object_ref (self), g_object_unref);
}

static void
slingshot_backend_relevancy_service_load_application_relevancies_data_free (gpointer _data)
{
	SlingshotBackendRelevancyServiceLoadApplicationRelevanciesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SlingshotBackendRelevancyServiceLoadApplicationRelevanciesData, _data_);
}

static void
slingshot_backend_relevancy_service_load_application_relevancies (SlingshotBackendRelevancyService* self,
                                                                  GAsyncReadyCallback _callback_,
                                                                  gpointer _user_data_)
{
	SlingshotBackendRelevancyServiceLoadApplicationRelevanciesData* _data_;
	SlingshotBackendRelevancyService* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SlingshotBackendRelevancyServiceLoadApplicationRelevanciesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, slingshot_backend_relevancy_service_load_application_relevancies_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	slingshot_backend_relevancy_service_load_application_relevancies_co (_data_);
}

static void
slingshot_backend_relevancy_service_load_application_relevancies_finish (SlingshotBackendRelevancyService* self,
                                                                         GAsyncResult* _res_)
{
	SlingshotBackendRelevancyServiceLoadApplicationRelevanciesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
_slingshot_backend_relevancy_service_load_application_relevancies_co_gsource_func (gpointer self)
{
	gboolean result;
	result = slingshot_backend_relevancy_service_load_application_relevancies_co (self);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
slingshot_backend_relevancy_service_load_application_relevancies_ready (GObject* source_object,
                                                                        GAsyncResult* _res_,
                                                                        gpointer _user_data_)
{
	SlingshotBackendRelevancyServiceLoadApplicationRelevanciesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	slingshot_backend_relevancy_service_load_application_relevancies_co (_data_);
}

static gboolean
slingshot_backend_relevancy_service_load_application_relevancies_co (SlingshotBackendRelevancyServiceLoadApplicationRelevanciesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_idle_add_full (G_PRIORITY_HIGH, _slingshot_backend_relevancy_service_load_application_relevancies_co_gsource_func, _data_, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	if (_data_->self->priv->refreshing == TRUE) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->refreshing = TRUE;
	_data_->end = zeitgeist_timestamp_from_now ();
	_data_->start = _data_->end - (ZEITGEIST_TIMESTAMP_WEEK * 4);
	_data_->_tmp0_ = zeitgeist_time_range_new (_data_->start, _data_->end);
	_data_->tr = _data_->_tmp0_;
	_data_->_tmp1_ = zeitgeist_event_new ();
	_data_->event = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->event;
	zeitgeist_event_set_interpretation (_data_->_tmp2_, "!" ZEITGEIST_ZG_LEAVE_EVENT);
	_data_->_tmp3_ = zeitgeist_subject_new ();
	_data_->subject = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->subject;
	zeitgeist_subject_set_interpretation (_data_->_tmp4_, ZEITGEIST_NFO_SOFTWARE);
	_data_->_tmp5_ = _data_->subject;
	zeitgeist_subject_set_uri (_data_->_tmp5_, "application://*");
	_data_->_tmp6_ = _data_->event;
	_data_->_tmp7_ = _data_->subject;
	zeitgeist_event_add_subject (_data_->_tmp6_, _data_->_tmp7_);
	_data_->_tmp8_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->ptr_arr = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->ptr_arr;
	_data_->_tmp10_ = _data_->event;
	_data_->_tmp11_ = _g_object_ref0 (_data_->_tmp10_);
	g_ptr_array_add (_data_->_tmp9_, _data_->_tmp11_);
	{
		_data_->_tmp12_ = _data_->self->priv->zg_log;
		_data_->_tmp13_ = _data_->tr;
		_data_->_tmp14_ = _data_->ptr_arr;
		_data_->_state_ = 2;
		zeitgeist_log_find_events (_data_->_tmp12_, _data_->_tmp13_, _data_->_tmp14_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) 256, ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, NULL, slingshot_backend_relevancy_service_load_application_relevancies_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp15_ = zeitgeist_log_find_events_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error0_);
		_data_->rs = _data_->_tmp15_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp16_ = _data_->self->priv->app_popularity;
		gee_abstract_map_clear ((GeeAbstractMap*) _data_->_tmp16_);
		_data_->_tmp17_ = _data_->rs;
		_data_->size = zeitgeist_result_set_size (_data_->_tmp17_);
		_data_->index = (guint) 0;
		{
			_data_->_tmp18_ = _data_->rs;
			_data_->_tmp19_ = zeitgeist_result_set_iterator (_data_->_tmp18_);
			_data_->_e_it = _data_->_tmp19_;
			while (TRUE) {
				_data_->_tmp20_ = _data_->_e_it;
				_data_->_tmp21_ = zeitgeist_result_set_next_value (_data_->_tmp20_);
				_g_object_unref0 (_data_->e);
				_data_->e = _data_->_tmp21_;
				_data_->_tmp22_ = _data_->e;
				if (!(_data_->_tmp22_ != NULL)) {
					break;
				}
				_data_->_tmp23_ = _data_->e;
				if (zeitgeist_event_num_subjects (_data_->_tmp23_) <= 0) {
					continue;
				}
				_data_->_tmp24_ = _data_->e;
				_data_->_tmp25_ = zeitgeist_event_get_subject (_data_->_tmp24_, 0);
				_data_->s = _data_->_tmp25_;
				_data_->power = (_data_->index / (_data_->size * 2)) + 0.5f;
				_data_->relevancy = 1.0f / powf ((gfloat) (_data_->index + 1), _data_->power);
				_data_->_tmp26_ = _data_->self->priv->app_popularity;
				_data_->_tmp27_ = _data_->s;
				_data_->_tmp28_ = zeitgeist_subject_get_uri (_data_->_tmp27_);
				_data_->_tmp29_ = _data_->_tmp28_;
				gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp26_, _data_->_tmp29_, (gpointer) ((gintptr) (_data_->relevancy * SLINGSHOT_BACKEND_RELEVANCY_SERVICE_MULTIPLIER)));
				_data_->_tmp30_ = _data_->index;
				_data_->index = _data_->_tmp30_ + 1;
				_g_object_unref0 (_data_->s);
			}
			_g_object_unref0 (_data_->e);
			_g_object_unref0 (_data_->_e_it);
		}
		g_signal_emit (_data_->self, slingshot_backend_relevancy_service_signals[SLINGSHOT_BACKEND_RELEVANCY_SERVICE_UPDATE_COMPLETE_SIGNAL], 0);
		_data_->self->priv->refreshing = FALSE;
		_g_object_unref0 (_data_->rs);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp31_ = _data_->err;
		_data_->_tmp32_ = _data_->_tmp31_->message;
		g_critical ("RelevancyService.vala:134: %s", _data_->_tmp32_);
		_data_->self->priv->refreshing = FALSE;
		_g_error_free0 (_data_->err);
		_g_ptr_array_unref0 (_data_->ptr_arr);
		_g_object_unref0 (_data_->subject);
		_g_object_unref0 (_data_->event);
		_g_object_unref0 (_data_->tr);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_ptr_array_unref0 (_data_->ptr_arr);
		_g_object_unref0 (_data_->subject);
		_g_object_unref0 (_data_->event);
		_g_object_unref0 (_data_->tr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_ptr_array_unref0 (_data_->ptr_arr);
	_g_object_unref0 (_data_->subject);
	_g_object_unref0 (_data_->event);
	_g_object_unref0 (_data_->tr);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gfloat
slingshot_backend_relevancy_service_get_app_popularity (SlingshotBackendRelevancyService* self,
                                                        const gchar* desktop_id)
{
	gchar* id = NULL;
	gchar* _tmp0_;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	g_return_val_if_fail (desktop_id != NULL, 0.0F);
	_tmp0_ = g_strconcat ("application://", desktop_id, NULL);
	id = _tmp0_;
	_tmp1_ = self->priv->app_popularity;
	_tmp2_ = id;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _tmp2_)) {
		GeeHashMap* _tmp3_;
		const gchar* _tmp4_;
		gpointer _tmp5_;
		_tmp3_ = self->priv->app_popularity;
		_tmp4_ = id;
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
		result = ((gint) ((gintptr) _tmp5_)) / SLINGSHOT_BACKEND_RELEVANCY_SERVICE_MULTIPLIER;
		_g_free0 (id);
		return result;
	}
	result = 0.0f;
	_g_free0 (id);
	return result;
}

void
slingshot_backend_relevancy_service_app_launched (SlingshotBackendRelevancyService* self,
                                                  SlingshotBackendApp* app)
{
	gchar* app_uri = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app != NULL);
	app_uri = NULL;
	_tmp0_ = slingshot_backend_app_get_desktop_id (app);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = slingshot_backend_app_get_desktop_id (app);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat ("application://", _tmp3_, NULL);
		_g_free0 (app_uri);
		app_uri = _tmp4_;
	}
	_tmp5_ = app_uri;
	_tmp6_ = slingshot_backend_app_get_name (app);
	_tmp7_ = _tmp6_;
	slingshot_backend_relevancy_service_push_app_launch (self, _tmp5_, _tmp7_);
	slingshot_backend_relevancy_service_reload_relevancies (self);
	_g_free0 (app_uri);
}

static void
slingshot_backend_relevancy_service_push_app_launch (SlingshotBackendRelevancyService* self,
                                                     const gchar* app_uri,
                                                     const gchar* display_name)
{
	ZeitgeistEvent* event = NULL;
	ZeitgeistEvent* _tmp0_;
	ZeitgeistSubject* subject = NULL;
	ZeitgeistSubject* _tmp1_;
	GPtrArray* ptr_arr = NULL;
	GPtrArray* _tmp2_;
	ZeitgeistEvent* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_uri != NULL);
	g_message ("RelevancyService.vala:166: Pushing launch event: %s [%s]", app_uri, display_name);
	_tmp0_ = zeitgeist_event_new ();
	event = _tmp0_;
	_tmp1_ = zeitgeist_subject_new ();
	subject = _tmp1_;
	zeitgeist_event_set_actor (event, "application://synapse.desktop");
	zeitgeist_event_set_interpretation (event, ZEITGEIST_ZG_ACCESS_EVENT);
	zeitgeist_event_set_manifestation (event, ZEITGEIST_ZG_USER_ACTIVITY);
	zeitgeist_event_add_subject (event, subject);
	zeitgeist_subject_set_uri (subject, app_uri);
	zeitgeist_subject_set_interpretation (subject, ZEITGEIST_NFO_SOFTWARE);
	zeitgeist_subject_set_manifestation (subject, ZEITGEIST_NFO_SOFTWARE_ITEM);
	zeitgeist_subject_set_mimetype (subject, "application/x-desktop");
	zeitgeist_subject_set_text (subject, display_name);
	_tmp2_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	ptr_arr = _tmp2_;
	_tmp3_ = _g_object_ref0 (event);
	g_ptr_array_add (ptr_arr, _tmp3_);
	{
		ZeitgeistLog* _tmp4_;
		_tmp4_ = self->priv->zg_log;
		zeitgeist_log_insert_events_no_reply (_tmp4_, ptr_arr, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_critical ("RelevancyService.vala:186: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_ptr_array_unref0 (ptr_arr);
		_g_object_unref0 (subject);
		_g_object_unref0 (event);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_ptr_array_unref0 (ptr_arr);
	_g_object_unref0 (subject);
	_g_object_unref0 (event);
}

static void
slingshot_backend_relevancy_service_class_init (SlingshotBackendRelevancyServiceClass * klass,
                                                gpointer klass_data)
{
	slingshot_backend_relevancy_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotBackendRelevancyService_private_offset);
	G_OBJECT_CLASS (klass)->finalize = slingshot_backend_relevancy_service_finalize;
	slingshot_backend_relevancy_service_signals[SLINGSHOT_BACKEND_RELEVANCY_SERVICE_UPDATE_COMPLETE_SIGNAL] = g_signal_new ("update-complete", SLINGSHOT_BACKEND_TYPE_RELEVANCY_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
slingshot_backend_relevancy_service_instance_init (SlingshotBackendRelevancyService * self,
                                                   gpointer klass)
{
	self->priv = slingshot_backend_relevancy_service_get_instance_private (self);
	self->priv->has_datahub_gio_module = FALSE;
	self->priv->refreshing = FALSE;
}

static void
slingshot_backend_relevancy_service_finalize (GObject * obj)
{
	SlingshotBackendRelevancyService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_BACKEND_TYPE_RELEVANCY_SERVICE, SlingshotBackendRelevancyService);
	_g_object_unref0 (self->priv->zg_log);
	_g_object_unref0 (self->priv->zg_dsr);
	_g_object_unref0 (self->priv->app_popularity);
	G_OBJECT_CLASS (slingshot_backend_relevancy_service_parent_class)->finalize (obj);
}

static GType
slingshot_backend_relevancy_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotBackendRelevancyServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_backend_relevancy_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotBackendRelevancyService), 0, (GInstanceInitFunc) slingshot_backend_relevancy_service_instance_init, NULL };
	GType slingshot_backend_relevancy_service_type_id;
	slingshot_backend_relevancy_service_type_id = g_type_register_static (G_TYPE_OBJECT, "SlingshotBackendRelevancyService", &g_define_type_info, 0);
	SlingshotBackendRelevancyService_private_offset = g_type_add_instance_private (slingshot_backend_relevancy_service_type_id, sizeof (SlingshotBackendRelevancyServicePrivate));
	return slingshot_backend_relevancy_service_type_id;
}

GType
slingshot_backend_relevancy_service_get_type (void)
{
	static volatile gsize slingshot_backend_relevancy_service_type_id__once = 0;
	if (g_once_init_enter (&slingshot_backend_relevancy_service_type_id__once)) {
		GType slingshot_backend_relevancy_service_type_id;
		slingshot_backend_relevancy_service_type_id = slingshot_backend_relevancy_service_get_type_once ();
		g_once_init_leave (&slingshot_backend_relevancy_service_type_id__once, slingshot_backend_relevancy_service_type_id);
	}
	return slingshot_backend_relevancy_service_type_id__once;
}

