/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 79 "cfg.y"


#include <stdlib.h>
#include <stdio.h>
#include <sys/socket.h>
#include <unistd.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <arpa/inet.h>
#include <string.h>
#include <errno.h>
#include "route_struct.h"
#include "globals.h"
#include "route.h"
#include "dprint.h"
#include "cfg_pp.h"
#include "sr_module.h"
#include "modparam.h"
#include "ip_addr.h"
#include "resolve.h"
#include "socket_info.h"
#include "name_alias.h"
#include "ut.h"
#include "pt_scaling.h"
#include "dset.h"
#include "pvar.h"
#include "blacklists.h"
#include "xlog.h"
#include "db/db_insertq.h"
#include "bin_interface.h"
#include "net/trans.h"
#include "config.h"
#include "mem/rpm_mem.h"
#include "poll_types.h"

#ifdef SHM_EXTRA_STATS
#include "mem/module_info.h"
#endif

#ifdef DEBUG_DMALLOC
#include <dmalloc.h>
#endif

/* hack to avoid alloca usage in the generated C file (needed for compiler
 with no built in alloca, like icc*/
#undef _ALLOCA_H

#undef MIN
#undef MAX

extern int yylex();
static void yyerror(char* s);
static void yyerrorf(char* fmt, ...);
static char* tmp;
static int i_tmp, rc;
static struct socket_id* lst_tmp;
static int rt;  /* Type of route block for find_export */
static str s_tmp;
static str tstr;
static struct net* net_tmp;
static pv_spec_t *spec;
static pv_elem_t *elem;
static struct bl_rule *bl_head = 0;
static struct bl_rule *bl_tail = 0;
static struct script_route_ref *rt_ref = NULL;

action_elem_t elems[MAX_ACTION_ELEMS];
static action_elem_t route_elems[MAX_ACTION_ELEMS];
action_elem_t *a_tmp;

static inline void warn(char* s);
static struct socket_id* mk_listen_id(char*, enum sip_protos, int);
static struct socket_id* set_listen_id_adv(struct socket_id *, char *, int);
static struct multi_str *new_string(char *s);
static int parse_ipnet(char *in, int len, struct net **ipnet);

extern int line;
extern int column;
extern int startcolumn;
extern char *finame;

struct listen_param {
	enum si_flags flags;
	int workers;
	struct socket_id *socket;
	char *tag;
	char *auto_scaling_profile;
} p_tmp;
static void fill_socket_id(struct listen_param *param, struct socket_id *s);

union route_name_var {
	int iname;
	struct _pv_spec *sname;
	struct _pv_elem *ename;
	void *data;
} rn_tmp;

#ifndef SHM_EXTRA_STATS
struct multi_str{
	char *s;
	struct multi_str* next;
};
#else
static struct multi_str *tmp_mod;
#endif

#define get_cfg_file_name \
	((finame) ? finame : cfg_file ? cfg_file : "default")



#define mk_action_(_res, _type, _no, _elems) \
	do { \
		_res = mk_action(_type, _no, _elems, line, get_cfg_file_name); \
	} while(0)
#define mk_action0(_res, _type) \
	do { \
		_res = mk_action(_type, 0, 0, line, get_cfg_file_name); \
	} while(0)
#define mk_action1(_res, _type, _p1_type, _p1) \
	do { \
		elems[0].type = _p1_type; \
		elems[0].u.data = _p1; \
		_res = mk_action(_type, 1, elems, line, get_cfg_file_name); \
	} while(0)
#define	mk_action2(_res, _type, _p1_type, _p2_type, _p1, _p2) \
	do { \
		elems[0].type = _p1_type; \
		elems[0].u.data = _p1; \
		elems[1].type = _p2_type; \
		elems[1].u.data = _p2; \
		_res = mk_action(_type, 2, elems, line, get_cfg_file_name); \
	} while(0)
#define mk_action3(_res, _type, _p1_type, _p2_type, _p3_type, _p1, _p2, _p3) \
	do { \
		elems[0].type = _p1_type; \
		elems[0].u.data = _p1; \
		elems[1].type = _p2_type; \
		elems[1].u.data = _p2; \
		elems[2].type = _p3_type; \
		elems[2].u.data = _p3; \
		_res = mk_action(_type, 3, elems, line, get_cfg_file_name); \
	} while(0)

extern int cfg_parse_only_routes;
#define IFOR(_instr) \
	if (cfg_parse_only_routes==1) {_instr;break;}


#line 222 "cfg.tab.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "cfg.tab.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_DROP = 3,                       /* DROP  */
  YYSYMBOL_ASSERT = 4,                     /* ASSERT  */
  YYSYMBOL_EXIT = 5,                       /* EXIT  */
  YYSYMBOL_RETURN = 6,                     /* RETURN  */
  YYSYMBOL_LOG_TOK = 7,                    /* LOG_TOK  */
  YYSYMBOL_ERROR = 8,                      /* ERROR  */
  YYSYMBOL_ROUTE = 9,                      /* ROUTE  */
  YYSYMBOL_ROUTE_FAILURE = 10,             /* ROUTE_FAILURE  */
  YYSYMBOL_ROUTE_ONREPLY = 11,             /* ROUTE_ONREPLY  */
  YYSYMBOL_ROUTE_BRANCH = 12,              /* ROUTE_BRANCH  */
  YYSYMBOL_ROUTE_ERROR = 13,               /* ROUTE_ERROR  */
  YYSYMBOL_ROUTE_LOCAL = 14,               /* ROUTE_LOCAL  */
  YYSYMBOL_ROUTE_STARTUP = 15,             /* ROUTE_STARTUP  */
  YYSYMBOL_ROUTE_TIMER = 16,               /* ROUTE_TIMER  */
  YYSYMBOL_ROUTE_EVENT = 17,               /* ROUTE_EVENT  */
  YYSYMBOL_IF = 18,                        /* IF  */
  YYSYMBOL_ELSE = 19,                      /* ELSE  */
  YYSYMBOL_SWITCH = 20,                    /* SWITCH  */
  YYSYMBOL_CASE = 21,                      /* CASE  */
  YYSYMBOL_DEFAULT = 22,                   /* DEFAULT  */
  YYSYMBOL_BREAK = 23,                     /* BREAK  */
  YYSYMBOL_WHILE = 24,                     /* WHILE  */
  YYSYMBOL_FOR = 25,                       /* FOR  */
  YYSYMBOL_IN = 26,                        /* IN  */
  YYSYMBOL_READONLY = 27,                  /* READONLY  */
  YYSYMBOL_EXPIRE = 28,                    /* EXPIRE  */
  YYSYMBOL_NULLV = 29,                     /* NULLV  */
  YYSYMBOL_XDBG = 30,                      /* XDBG  */
  YYSYMBOL_XLOG = 31,                      /* XLOG  */
  YYSYMBOL_XLOG_BUF_SIZE = 32,             /* XLOG_BUF_SIZE  */
  YYSYMBOL_XLOG_FORCE_COLOR = 33,          /* XLOG_FORCE_COLOR  */
  YYSYMBOL_XLOG_PRINT_LEVEL = 34,          /* XLOG_PRINT_LEVEL  */
  YYSYMBOL_XLOG_LEVEL = 35,                /* XLOG_LEVEL  */
  YYSYMBOL_PV_PRINT_BUF_SIZE = 36,         /* PV_PRINT_BUF_SIZE  */
  YYSYMBOL_DEBUG_MODE = 37,                /* DEBUG_MODE  */
  YYSYMBOL_ENABLE_ASSERTS = 38,            /* ENABLE_ASSERTS  */
  YYSYMBOL_ABORT_ON_ASSERT = 39,           /* ABORT_ON_ASSERT  */
  YYSYMBOL_LOGLEVEL = 40,                  /* LOGLEVEL  */
  YYSYMBOL_LOGPREFIX = 41,                 /* LOGPREFIX  */
  YYSYMBOL_LOGSTDOUT = 42,                 /* LOGSTDOUT  */
  YYSYMBOL_LOGSTDERROR = 43,               /* LOGSTDERROR  */
  YYSYMBOL_STDERROR_ENABLED = 44,          /* STDERROR_ENABLED  */
  YYSYMBOL_SYSLOG_ENABLED = 45,            /* SYSLOG_ENABLED  */
  YYSYMBOL_LOG_EVENT_ENABLED = 46,         /* LOG_EVENT_ENABLED  */
  YYSYMBOL_STDERROR_LEVEL_FILTER = 47,     /* STDERROR_LEVEL_FILTER  */
  YYSYMBOL_SYSLOG_LEVEL_FILTER = 48,       /* SYSLOG_LEVEL_FILTER  */
  YYSYMBOL_LOG_EVENT_LEVEL_FILTER = 49,    /* LOG_EVENT_LEVEL_FILTER  */
  YYSYMBOL_STDERROR_FORMAT = 50,           /* STDERROR_FORMAT  */
  YYSYMBOL_SYSLOG_FORMAT = 51,             /* SYSLOG_FORMAT  */
  YYSYMBOL_LOG_JSON_BUF_SIZE = 52,         /* LOG_JSON_BUF_SIZE  */
  YYSYMBOL_LOG_MSG_BUF_SIZE = 53,          /* LOG_MSG_BUF_SIZE  */
  YYSYMBOL_LOGFACILITY = 54,               /* LOGFACILITY  */
  YYSYMBOL_SYSLOG_FACILITY = 55,           /* SYSLOG_FACILITY  */
  YYSYMBOL_LOGNAME = 56,                   /* LOGNAME  */
  YYSYMBOL_SYSLOG_NAME = 57,               /* SYSLOG_NAME  */
  YYSYMBOL_AVP_ALIASES = 58,               /* AVP_ALIASES  */
  YYSYMBOL_LISTEN = 59,                    /* LISTEN  */
  YYSYMBOL_SOCKET = 60,                    /* SOCKET  */
  YYSYMBOL_MEMGROUP = 61,                  /* MEMGROUP  */
  YYSYMBOL_ALIAS = 62,                     /* ALIAS  */
  YYSYMBOL_AUTO_ALIASES = 63,              /* AUTO_ALIASES  */
  YYSYMBOL_TAG = 64,                       /* TAG  */
  YYSYMBOL_DNS = 65,                       /* DNS  */
  YYSYMBOL_REV_DNS = 66,                   /* REV_DNS  */
  YYSYMBOL_DNS_TRY_IPV6 = 67,              /* DNS_TRY_IPV6  */
  YYSYMBOL_DNS_TRY_NAPTR = 68,             /* DNS_TRY_NAPTR  */
  YYSYMBOL_DNS_RETR_TIME = 69,             /* DNS_RETR_TIME  */
  YYSYMBOL_DNS_RETR_NO = 70,               /* DNS_RETR_NO  */
  YYSYMBOL_DNS_SERVERS_NO = 71,            /* DNS_SERVERS_NO  */
  YYSYMBOL_DNS_USE_SEARCH = 72,            /* DNS_USE_SEARCH  */
  YYSYMBOL_MAX_WHILE_LOOPS = 73,           /* MAX_WHILE_LOOPS  */
  YYSYMBOL_UDP_WORKERS = 74,               /* UDP_WORKERS  */
  YYSYMBOL_CHECK_VIA = 75,                 /* CHECK_VIA  */
  YYSYMBOL_SHM_HASH_SPLIT_PERCENTAGE = 76, /* SHM_HASH_SPLIT_PERCENTAGE  */
  YYSYMBOL_SHM_SECONDARY_HASH_SIZE = 77,   /* SHM_SECONDARY_HASH_SIZE  */
  YYSYMBOL_MEM_WARMING_ENABLED = 78,       /* MEM_WARMING_ENABLED  */
  YYSYMBOL_MEM_WARMING_PATTERN_FILE = 79,  /* MEM_WARMING_PATTERN_FILE  */
  YYSYMBOL_MEM_WARMING_PERCENTAGE = 80,    /* MEM_WARMING_PERCENTAGE  */
  YYSYMBOL_RPM_MEM_FILE = 81,              /* RPM_MEM_FILE  */
  YYSYMBOL_RPM_MEM_SIZE = 82,              /* RPM_MEM_SIZE  */
  YYSYMBOL_MEMLOG = 83,                    /* MEMLOG  */
  YYSYMBOL_MEMDUMP = 84,                   /* MEMDUMP  */
  YYSYMBOL_SHM_MEMLOG_SIZE = 85,           /* SHM_MEMLOG_SIZE  */
  YYSYMBOL_EXECMSGTHRESHOLD = 86,          /* EXECMSGTHRESHOLD  */
  YYSYMBOL_EXECDNSTHRESHOLD = 87,          /* EXECDNSTHRESHOLD  */
  YYSYMBOL_TCPTHRESHOLD = 88,              /* TCPTHRESHOLD  */
  YYSYMBOL_EVENT_SHM_THRESHOLD = 89,       /* EVENT_SHM_THRESHOLD  */
  YYSYMBOL_EVENT_PKG_THRESHOLD = 90,       /* EVENT_PKG_THRESHOLD  */
  YYSYMBOL_QUERYBUFFERSIZE = 91,           /* QUERYBUFFERSIZE  */
  YYSYMBOL_QUERYFLUSHTIME = 92,            /* QUERYFLUSHTIME  */
  YYSYMBOL_SIP_WARNING = 93,               /* SIP_WARNING  */
  YYSYMBOL_SERVER_SIGNATURE = 94,          /* SERVER_SIGNATURE  */
  YYSYMBOL_SERVER_HEADER = 95,             /* SERVER_HEADER  */
  YYSYMBOL_USER_AGENT_HEADER = 96,         /* USER_AGENT_HEADER  */
  YYSYMBOL_LOADMODULE = 97,                /* LOADMODULE  */
  YYSYMBOL_MPATH = 98,                     /* MPATH  */
  YYSYMBOL_MODPARAM = 99,                  /* MODPARAM  */
  YYSYMBOL_MAXBUFFER = 100,                /* MAXBUFFER  */
  YYSYMBOL_CHROOT = 101,                   /* CHROOT  */
  YYSYMBOL_WDIR = 102,                     /* WDIR  */
  YYSYMBOL_MHOMED = 103,                   /* MHOMED  */
  YYSYMBOL_POLL_METHOD = 104,              /* POLL_METHOD  */
  YYSYMBOL_TCP_ACCEPT_ALIASES = 105,       /* TCP_ACCEPT_ALIASES  */
  YYSYMBOL_TCP_WORKERS = 106,              /* TCP_WORKERS  */
  YYSYMBOL_TCP_CONNECT_TIMEOUT = 107,      /* TCP_CONNECT_TIMEOUT  */
  YYSYMBOL_TCP_CON_LIFETIME = 108,         /* TCP_CON_LIFETIME  */
  YYSYMBOL_TCP_SOCKET_BACKLOG = 109,       /* TCP_SOCKET_BACKLOG  */
  YYSYMBOL_TCP_MAX_CONNECTIONS = 110,      /* TCP_MAX_CONNECTIONS  */
  YYSYMBOL_TCP_NO_NEW_CONN_BFLAG = 111,    /* TCP_NO_NEW_CONN_BFLAG  */
  YYSYMBOL_TCP_NO_NEW_CONN_RPLFLAG = 112,  /* TCP_NO_NEW_CONN_RPLFLAG  */
  YYSYMBOL_TCP_KEEPALIVE = 113,            /* TCP_KEEPALIVE  */
  YYSYMBOL_TCP_KEEPCOUNT = 114,            /* TCP_KEEPCOUNT  */
  YYSYMBOL_TCP_KEEPIDLE = 115,             /* TCP_KEEPIDLE  */
  YYSYMBOL_TCP_KEEPINTERVAL = 116,         /* TCP_KEEPINTERVAL  */
  YYSYMBOL_TCP_MAX_MSG_TIME = 117,         /* TCP_MAX_MSG_TIME  */
  YYSYMBOL_TCP_PARALLEL_READ_ON_WORKERS = 118, /* TCP_PARALLEL_READ_ON_WORKERS  */
  YYSYMBOL_ADVERTISED_ADDRESS = 119,       /* ADVERTISED_ADDRESS  */
  YYSYMBOL_ADVERTISED_PORT = 120,          /* ADVERTISED_PORT  */
  YYSYMBOL_DISABLE_CORE = 121,             /* DISABLE_CORE  */
  YYSYMBOL_OPEN_FD_LIMIT = 122,            /* OPEN_FD_LIMIT  */
  YYSYMBOL_MCAST_LOOPBACK = 123,           /* MCAST_LOOPBACK  */
  YYSYMBOL_MCAST_TTL = 124,                /* MCAST_TTL  */
  YYSYMBOL_TOS = 125,                      /* TOS  */
  YYSYMBOL_DISABLE_DNS_FAILOVER = 126,     /* DISABLE_DNS_FAILOVER  */
  YYSYMBOL_DISABLE_DNS_BLACKLIST = 127,    /* DISABLE_DNS_BLACKLIST  */
  YYSYMBOL_DST_BLACKLIST = 128,            /* DST_BLACKLIST  */
  YYSYMBOL_DISABLE_STATELESS_FWD = 129,    /* DISABLE_STATELESS_FWD  */
  YYSYMBOL_DB_VERSION_TABLE = 130,         /* DB_VERSION_TABLE  */
  YYSYMBOL_DB_DEFAULT_URL = 131,           /* DB_DEFAULT_URL  */
  YYSYMBOL_DB_MAX_ASYNC_CONNECTIONS = 132, /* DB_MAX_ASYNC_CONNECTIONS  */
  YYSYMBOL_DISABLE_503_TRANSLATION = 133,  /* DISABLE_503_TRANSLATION  */
  YYSYMBOL_SYNC_TOKEN = 134,               /* SYNC_TOKEN  */
  YYSYMBOL_ASYNC_TOKEN = 135,              /* ASYNC_TOKEN  */
  YYSYMBOL_LAUNCH_TOKEN = 136,             /* LAUNCH_TOKEN  */
  YYSYMBOL_AUTO_SCALING_PROFILE = 137,     /* AUTO_SCALING_PROFILE  */
  YYSYMBOL_AUTO_SCALING_CYCLE = 138,       /* AUTO_SCALING_CYCLE  */
  YYSYMBOL_TIMER_WORKERS = 139,            /* TIMER_WORKERS  */
  YYSYMBOL_EQUAL = 140,                    /* EQUAL  */
  YYSYMBOL_EQUAL_T = 141,                  /* EQUAL_T  */
  YYSYMBOL_GT = 142,                       /* GT  */
  YYSYMBOL_LT = 143,                       /* LT  */
  YYSYMBOL_GTE = 144,                      /* GTE  */
  YYSYMBOL_LTE = 145,                      /* LTE  */
  YYSYMBOL_DIFF = 146,                     /* DIFF  */
  YYSYMBOL_MATCH = 147,                    /* MATCH  */
  YYSYMBOL_NOTMATCH = 148,                 /* NOTMATCH  */
  YYSYMBOL_COLONEQ = 149,                  /* COLONEQ  */
  YYSYMBOL_PLUSEQ = 150,                   /* PLUSEQ  */
  YYSYMBOL_MINUSEQ = 151,                  /* MINUSEQ  */
  YYSYMBOL_SLASHEQ = 152,                  /* SLASHEQ  */
  YYSYMBOL_MULTEQ = 153,                   /* MULTEQ  */
  YYSYMBOL_MODULOEQ = 154,                 /* MODULOEQ  */
  YYSYMBOL_BANDEQ = 155,                   /* BANDEQ  */
  YYSYMBOL_BOREQ = 156,                    /* BOREQ  */
  YYSYMBOL_BXOREQ = 157,                   /* BXOREQ  */
  YYSYMBOL_OR = 158,                       /* OR  */
  YYSYMBOL_AND = 159,                      /* AND  */
  YYSYMBOL_BOR = 160,                      /* BOR  */
  YYSYMBOL_BAND = 161,                     /* BAND  */
  YYSYMBOL_BXOR = 162,                     /* BXOR  */
  YYSYMBOL_BLSHIFT = 163,                  /* BLSHIFT  */
  YYSYMBOL_BRSHIFT = 164,                  /* BRSHIFT  */
  YYSYMBOL_PLUS = 165,                     /* PLUS  */
  YYSYMBOL_MINUS = 166,                    /* MINUS  */
  YYSYMBOL_MULT = 167,                     /* MULT  */
  YYSYMBOL_MODULO = 168,                   /* MODULO  */
  YYSYMBOL_NOT = 169,                      /* NOT  */
  YYSYMBOL_BNOT = 170,                     /* BNOT  */
  YYSYMBOL_NUMBER = 171,                   /* NUMBER  */
  YYSYMBOL_ZERO = 172,                     /* ZERO  */
  YYSYMBOL_ID = 173,                       /* ID  */
  YYSYMBOL_STRING = 174,                   /* STRING  */
  YYSYMBOL_SCRIPTVAR = 175,                /* SCRIPTVAR  */
  YYSYMBOL_IPV6ADDR = 176,                 /* IPV6ADDR  */
  YYSYMBOL_IPV4ADDR = 177,                 /* IPV4ADDR  */
  YYSYMBOL_IPNET = 178,                    /* IPNET  */
  YYSYMBOL_COMMA = 179,                    /* COMMA  */
  YYSYMBOL_SEMICOLON = 180,                /* SEMICOLON  */
  YYSYMBOL_RPAREN = 181,                   /* RPAREN  */
  YYSYMBOL_LPAREN = 182,                   /* LPAREN  */
  YYSYMBOL_LBRACE = 183,                   /* LBRACE  */
  YYSYMBOL_RBRACE = 184,                   /* RBRACE  */
  YYSYMBOL_LBRACK = 185,                   /* LBRACK  */
  YYSYMBOL_RBRACK = 186,                   /* RBRACK  */
  YYSYMBOL_SLASH = 187,                    /* SLASH  */
  YYSYMBOL_AS = 188,                       /* AS  */
  YYSYMBOL_USE_WORKERS = 189,              /* USE_WORKERS  */
  YYSYMBOL_USE_AUTO_SCALING_PROFILE = 190, /* USE_AUTO_SCALING_PROFILE  */
  YYSYMBOL_MAX = 191,                      /* MAX  */
  YYSYMBOL_MIN = 192,                      /* MIN  */
  YYSYMBOL_DOT = 193,                      /* DOT  */
  YYSYMBOL_CR = 194,                       /* CR  */
  YYSYMBOL_COLON = 195,                    /* COLON  */
  YYSYMBOL_ANY = 196,                      /* ANY  */
  YYSYMBOL_ANYCAST = 197,                  /* ANYCAST  */
  YYSYMBOL_FRAG = 198,                     /* FRAG  */
  YYSYMBOL_REUSE_PORT = 199,               /* REUSE_PORT  */
  YYSYMBOL_SCRIPTVARERR = 200,             /* SCRIPTVARERR  */
  YYSYMBOL_SCALE_UP_TO = 201,              /* SCALE_UP_TO  */
  YYSYMBOL_SCALE_DOWN_TO = 202,            /* SCALE_DOWN_TO  */
  YYSYMBOL_ON = 203,                       /* ON  */
  YYSYMBOL_CYCLES = 204,                   /* CYCLES  */
  YYSYMBOL_CYCLES_WITHIN = 205,            /* CYCLES_WITHIN  */
  YYSYMBOL_PERCENTAGE = 206,               /* PERCENTAGE  */
  YYSYMBOL_YYACCEPT = 207,                 /* $accept  */
  YYSYMBOL_cfg = 208,                      /* cfg  */
  YYSYMBOL_statements = 209,               /* statements  */
  YYSYMBOL_statement = 210,                /* statement  */
  YYSYMBOL_211_1 = 211,                    /* $@1  */
  YYSYMBOL_212_2 = 212,                    /* $@2  */
  YYSYMBOL_213_3 = 213,                    /* $@3  */
  YYSYMBOL_214_4 = 214,                    /* $@4  */
  YYSYMBOL_215_5 = 215,                    /* $@5  */
  YYSYMBOL_216_6 = 216,                    /* $@6  */
  YYSYMBOL_217_7 = 217,                    /* $@7  */
  YYSYMBOL_218_8 = 218,                    /* $@8  */
  YYSYMBOL_219_9 = 219,                    /* $@9  */
  YYSYMBOL_listen_id = 220,                /* listen_id  */
  YYSYMBOL_host_sep = 221,                 /* host_sep  */
  YYSYMBOL_host = 222,                     /* host  */
  YYSYMBOL_proto = 223,                    /* proto  */
  YYSYMBOL_port = 224,                     /* port  */
  YYSYMBOL_snumber = 225,                  /* snumber  */
  YYSYMBOL_phostport = 226,                /* phostport  */
  YYSYMBOL_panyhostport = 227,             /* panyhostport  */
  YYSYMBOL_alias_def = 228,                /* alias_def  */
  YYSYMBOL_id_lst = 229,                   /* id_lst  */
  YYSYMBOL_listen_id_def = 230,            /* listen_id_def  */
  YYSYMBOL_socket_def_param = 231,         /* socket_def_param  */
  YYSYMBOL_socket_def_params = 232,        /* socket_def_params  */
  YYSYMBOL_socket_def = 233,               /* socket_def  */
  YYSYMBOL_234_10 = 234,                   /* $@10  */
  YYSYMBOL_235_11 = 235,                   /* $@11  */
  YYSYMBOL_any_proto = 236,                /* any_proto  */
  YYSYMBOL_multi_string = 237,             /* multi_string  */
  YYSYMBOL_blst_elem = 238,                /* blst_elem  */
  YYSYMBOL_blst_def = 239,                 /* blst_def  */
  YYSYMBOL_blst_flag = 240,                /* blst_flag  */
  YYSYMBOL_blst_flags = 241,               /* blst_flags  */
  YYSYMBOL_blst_elem_list = 242,           /* blst_elem_list  */
  YYSYMBOL_auto_scale_profile_def = 243,   /* auto_scale_profile_def  */
  YYSYMBOL_assign_stm = 244,               /* assign_stm  */
  YYSYMBOL_module_stm = 245,               /* module_stm  */
  YYSYMBOL_ip = 246,                       /* ip  */
  YYSYMBOL_ipv4 = 247,                     /* ipv4  */
  YYSYMBOL_ipv6addr = 248,                 /* ipv6addr  */
  YYSYMBOL_ipv6 = 249,                     /* ipv6  */
  YYSYMBOL_ipnet = 250,                    /* ipnet  */
  YYSYMBOL_folded_string = 251,            /* folded_string  */
  YYSYMBOL_route_name = 252,               /* route_name  */
  YYSYMBOL_route_name_var = 253,           /* route_name_var  */
  YYSYMBOL_route_stm = 254,                /* route_stm  */
  YYSYMBOL_failure_route_stm = 255,        /* failure_route_stm  */
  YYSYMBOL_onreply_route_stm = 256,        /* onreply_route_stm  */
  YYSYMBOL_branch_route_stm = 257,         /* branch_route_stm  */
  YYSYMBOL_error_route_stm = 258,          /* error_route_stm  */
  YYSYMBOL_local_route_stm = 259,          /* local_route_stm  */
  YYSYMBOL_startup_route_stm = 260,        /* startup_route_stm  */
  YYSYMBOL_timer_route_stm = 261,          /* timer_route_stm  */
  YYSYMBOL_event_route_stm = 262,          /* event_route_stm  */
  YYSYMBOL_exp = 263,                      /* exp  */
  YYSYMBOL_equalop = 264,                  /* equalop  */
  YYSYMBOL_compop = 265,                   /* compop  */
  YYSYMBOL_matchop = 266,                  /* matchop  */
  YYSYMBOL_intop = 267,                    /* intop  */
  YYSYMBOL_strop = 268,                    /* strop  */
  YYSYMBOL_script_var = 269,               /* script_var  */
  YYSYMBOL_exp_elem = 270,                 /* exp_elem  */
  YYSYMBOL_exp_cond = 271,                 /* exp_cond  */
  YYSYMBOL_assignop = 272,                 /* assignop  */
  YYSYMBOL_assignexp = 273,                /* assignexp  */
  YYSYMBOL_assign_cmd = 274,               /* assign_cmd  */
  YYSYMBOL_exp_stm = 275,                  /* exp_stm  */
  YYSYMBOL_brk_stm = 276,                  /* brk_stm  */
  YYSYMBOL_stm = 277,                      /* stm  */
  YYSYMBOL_actions = 278,                  /* actions  */
  YYSYMBOL_brk_actions = 279,              /* brk_actions  */
  YYSYMBOL_action = 280,                   /* action  */
  YYSYMBOL_brk_action = 281,               /* brk_action  */
  YYSYMBOL_brk_if_cmd = 282,               /* brk_if_cmd  */
  YYSYMBOL_if_cmd = 283,                   /* if_cmd  */
  YYSYMBOL_while_cmd = 284,                /* while_cmd  */
  YYSYMBOL_foreach_cmd = 285,              /* foreach_cmd  */
  YYSYMBOL_switch_cmd = 286,               /* switch_cmd  */
  YYSYMBOL_switch_stm = 287,               /* switch_stm  */
  YYSYMBOL_case_stms = 288,                /* case_stms  */
  YYSYMBOL_case_stm = 289,                 /* case_stm  */
  YYSYMBOL_default_stm = 290,              /* default_stm  */
  YYSYMBOL_func_param = 291,               /* func_param  */
  YYSYMBOL_route_param = 292,              /* route_param  */
  YYSYMBOL_async_func = 293,               /* async_func  */
  YYSYMBOL_cmd = 294                       /* cmd  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  234
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   2358

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  207
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  88
/* YYNRULES -- Number of rules.  */
#define YYNRULES  519
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  990

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   461


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   500,   500,   503,   504,   505,   508,   509,   510,   510,
     511,   511,   512,   512,   513,   513,   514,   514,   515,   515,
     516,   516,   517,   517,   518,   518,   520,   523,   538,   547,
     562,   563,   566,   567,   581,   586,   596,   597,   600,   601,
     602,   606,   608,   610,   615,   621,   623,   627,   629,   631,
     633,   637,   640,   641,   644,   646,   648,   654,   657,   660,
     663,   666,   669,   672,   677,   678,   681,   682,   683,   683,
     688,   688,   695,   696,   698,   699,   702,   710,   719,   725,
     732,   738,   745,   751,   758,   764,   771,   777,   786,   787,
     788,   791,   792,   793,   796,   797,   800,   801,   802,   806,
     814,   822,   828,   836,   840,   852,   853,   854,   855,   856,
     857,   872,   874,   877,   878,   899,   900,   911,   912,   923,
     924,   933,   934,   940,   941,   947,   948,   950,   951,   976,
    1001,  1009,  1010,  1018,  1019,  1026,  1027,  1033,  1034,  1037,
    1038,  1039,  1040,  1041,  1042,  1043,  1044,  1045,  1046,  1047,
    1048,  1049,  1050,  1051,  1052,  1053,  1054,  1055,  1056,  1057,
    1058,  1059,  1060,  1061,  1065,  1066,  1069,  1073,  1074,  1075,
    1083,  1091,  1099,  1107,  1115,  1123,  1131,  1139,  1147,  1155,
    1158,  1159,  1162,  1163,  1164,  1165,  1166,  1167,  1168,  1169,
    1170,  1171,  1172,  1173,  1174,  1175,  1185,  1186,  1200,  1201,
    1202,  1203,  1204,  1205,  1206,  1207,  1208,  1209,  1210,  1211,
    1212,  1213,  1214,  1215,  1225,  1235,  1236,  1241,  1242,  1245,
    1249,  1250,  1255,  1256,  1259,  1260,  1263,  1264,  1267,  1268,
    1275,  1276,  1283,  1285,  1288,  1289,  1292,  1293,  1296,  1299,
    1306,  1307,  1314,  1315,  1322,  1323,  1325,  1326,  1330,  1331,
    1334,  1335,  1337,  1338,  1340,  1342,  1344,  1345,  1346,  1347,
    1349,  1350,  1357,  1360,  1368,  1371,  1415,  1416,  1421,  1423,
    1425,  1426,  1432,  1434,  1448,  1450,  1453,  1454,  1457,  1458,
    1465,  1466,  1473,  1474,  1478,  1506,  1507,  1509,  1510,  1513,
    1514,  1517,  1518,  1528,  1538,  1540,  1542,  1543,  1545,  1546,
    1548,  1551,  1553,  1556,  1557,  1560,  1562,  1565,  1568,  1572,
    1573,  1579,  1585,  1591,  1595,  1596,  1599,  1615,  1631,  1632,
    1635,  1641,  1651,  1661,  1672,  1675,  1684,  1689,  1712,  1717,
    1725,  1741,  1744,  1750,  1753,  1761,  1767,  1770,  1776,  1779,
    1787,  1790,  1798,  1801,  1809,  1812,  1825,  1828,  1834,  1839,
    1840,  1841,  1842,  1843,  1844,  1847,  1848,  1851,  1852,  1853,
    1854,  1856,  1857,  1860,  1861,  1864,  1865,  1866,  1869,  1885,
    1890,  1891,  1892,  1894,  1899,  1902,  1905,  1908,  1911,  1917,
    1918,  1919,  1920,  1921,  1922,  1923,  1924,  1925,  1926,  1930,
    1931,  1932,  1933,  1934,  1935,  1938,  1941,  1944,  1947,  1950,
    1953,  1956,  1959,  1962,  1965,  1968,  1971,  1984,  1997,  2019,
    2020,  2021,  2022,  2023,  2026,  2027,  2028,  2031,  2032,  2033,
    2036,  2037,  2038,  2042,  2043,  2044,  2047,  2048,  2049,  2050,
    2051,  2052,  2053,  2054,  2057,  2058,  2059,  2060,  2061,  2062,
    2063,  2064,  2065,  2068,  2076,  2086,  2094,  2104,  2112,  2130,
    2139,  2140,  2142,  2143,  2146,  2152,  2158,  2164,  2172,  2175,
    2178,  2183,  2193,  2200,  2207,  2217,  2222,  2229,  2239,  2244,
    2251,  2263,  2268,  2273,  2278,  2283,  2293,  2303,  2313,  2325,
    2343,  2374,  2378,  2384,  2387,  2388,  2389,  2390,  2391,  2393,
    2395,  2397,  2399,  2401,  2402,  2405,  2411,  2412,  2414,  2420,
    2421,  2423,  2427,  2446,  2447,  2449,  2472,  2508,  2510,  2513,
    2515,  2517,  2519,  2521,  2523,  2525,  2532,  2539,  2546,  2553
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "DROP", "ASSERT",
  "EXIT", "RETURN", "LOG_TOK", "ERROR", "ROUTE", "ROUTE_FAILURE",
  "ROUTE_ONREPLY", "ROUTE_BRANCH", "ROUTE_ERROR", "ROUTE_LOCAL",
  "ROUTE_STARTUP", "ROUTE_TIMER", "ROUTE_EVENT", "IF", "ELSE", "SWITCH",
  "CASE", "DEFAULT", "BREAK", "WHILE", "FOR", "IN", "READONLY", "EXPIRE",
  "NULLV", "XDBG", "XLOG", "XLOG_BUF_SIZE", "XLOG_FORCE_COLOR",
  "XLOG_PRINT_LEVEL", "XLOG_LEVEL", "PV_PRINT_BUF_SIZE", "DEBUG_MODE",
  "ENABLE_ASSERTS", "ABORT_ON_ASSERT", "LOGLEVEL", "LOGPREFIX",
  "LOGSTDOUT", "LOGSTDERROR", "STDERROR_ENABLED", "SYSLOG_ENABLED",
  "LOG_EVENT_ENABLED", "STDERROR_LEVEL_FILTER", "SYSLOG_LEVEL_FILTER",
  "LOG_EVENT_LEVEL_FILTER", "STDERROR_FORMAT", "SYSLOG_FORMAT",
  "LOG_JSON_BUF_SIZE", "LOG_MSG_BUF_SIZE", "LOGFACILITY",
  "SYSLOG_FACILITY", "LOGNAME", "SYSLOG_NAME", "AVP_ALIASES", "LISTEN",
  "SOCKET", "MEMGROUP", "ALIAS", "AUTO_ALIASES", "TAG", "DNS", "REV_DNS",
  "DNS_TRY_IPV6", "DNS_TRY_NAPTR", "DNS_RETR_TIME", "DNS_RETR_NO",
  "DNS_SERVERS_NO", "DNS_USE_SEARCH", "MAX_WHILE_LOOPS", "UDP_WORKERS",
  "CHECK_VIA", "SHM_HASH_SPLIT_PERCENTAGE", "SHM_SECONDARY_HASH_SIZE",
  "MEM_WARMING_ENABLED", "MEM_WARMING_PATTERN_FILE",
  "MEM_WARMING_PERCENTAGE", "RPM_MEM_FILE", "RPM_MEM_SIZE", "MEMLOG",
  "MEMDUMP", "SHM_MEMLOG_SIZE", "EXECMSGTHRESHOLD", "EXECDNSTHRESHOLD",
  "TCPTHRESHOLD", "EVENT_SHM_THRESHOLD", "EVENT_PKG_THRESHOLD",
  "QUERYBUFFERSIZE", "QUERYFLUSHTIME", "SIP_WARNING", "SERVER_SIGNATURE",
  "SERVER_HEADER", "USER_AGENT_HEADER", "LOADMODULE", "MPATH", "MODPARAM",
  "MAXBUFFER", "CHROOT", "WDIR", "MHOMED", "POLL_METHOD",
  "TCP_ACCEPT_ALIASES", "TCP_WORKERS", "TCP_CONNECT_TIMEOUT",
  "TCP_CON_LIFETIME", "TCP_SOCKET_BACKLOG", "TCP_MAX_CONNECTIONS",
  "TCP_NO_NEW_CONN_BFLAG", "TCP_NO_NEW_CONN_RPLFLAG", "TCP_KEEPALIVE",
  "TCP_KEEPCOUNT", "TCP_KEEPIDLE", "TCP_KEEPINTERVAL", "TCP_MAX_MSG_TIME",
  "TCP_PARALLEL_READ_ON_WORKERS", "ADVERTISED_ADDRESS", "ADVERTISED_PORT",
  "DISABLE_CORE", "OPEN_FD_LIMIT", "MCAST_LOOPBACK", "MCAST_TTL", "TOS",
  "DISABLE_DNS_FAILOVER", "DISABLE_DNS_BLACKLIST", "DST_BLACKLIST",
  "DISABLE_STATELESS_FWD", "DB_VERSION_TABLE", "DB_DEFAULT_URL",
  "DB_MAX_ASYNC_CONNECTIONS", "DISABLE_503_TRANSLATION", "SYNC_TOKEN",
  "ASYNC_TOKEN", "LAUNCH_TOKEN", "AUTO_SCALING_PROFILE",
  "AUTO_SCALING_CYCLE", "TIMER_WORKERS", "EQUAL", "EQUAL_T", "GT", "LT",
  "GTE", "LTE", "DIFF", "MATCH", "NOTMATCH", "COLONEQ", "PLUSEQ",
  "MINUSEQ", "SLASHEQ", "MULTEQ", "MODULOEQ", "BANDEQ", "BOREQ", "BXOREQ",
  "OR", "AND", "BOR", "BAND", "BXOR", "BLSHIFT", "BRSHIFT", "PLUS",
  "MINUS", "MULT", "MODULO", "NOT", "BNOT", "NUMBER", "ZERO", "ID",
  "STRING", "SCRIPTVAR", "IPV6ADDR", "IPV4ADDR", "IPNET", "COMMA",
  "SEMICOLON", "RPAREN", "LPAREN", "LBRACE", "RBRACE", "LBRACK", "RBRACK",
  "SLASH", "AS", "USE_WORKERS", "USE_AUTO_SCALING_PROFILE", "MAX", "MIN",
  "DOT", "CR", "COLON", "ANY", "ANYCAST", "FRAG", "REUSE_PORT",
  "SCRIPTVARERR", "SCALE_UP_TO", "SCALE_DOWN_TO", "ON", "CYCLES",
  "CYCLES_WITHIN", "PERCENTAGE", "$accept", "cfg", "statements",
  "statement", "$@1", "$@2", "$@3", "$@4", "$@5", "$@6", "$@7", "$@8",
  "$@9", "listen_id", "host_sep", "host", "proto", "port", "snumber",
  "phostport", "panyhostport", "alias_def", "id_lst", "listen_id_def",
  "socket_def_param", "socket_def_params", "socket_def", "$@10", "$@11",
  "any_proto", "multi_string", "blst_elem", "blst_def", "blst_flag",
  "blst_flags", "blst_elem_list", "auto_scale_profile_def", "assign_stm",
  "module_stm", "ip", "ipv4", "ipv6addr", "ipv6", "ipnet", "folded_string",
  "route_name", "route_name_var", "route_stm", "failure_route_stm",
  "onreply_route_stm", "branch_route_stm", "error_route_stm",
  "local_route_stm", "startup_route_stm", "timer_route_stm",
  "event_route_stm", "exp", "equalop", "compop", "matchop", "intop",
  "strop", "script_var", "exp_elem", "exp_cond", "assignop", "assignexp",
  "assign_cmd", "exp_stm", "brk_stm", "stm", "actions", "brk_actions",
  "action", "brk_action", "brk_if_cmd", "if_cmd", "while_cmd",
  "foreach_cmd", "switch_cmd", "switch_stm", "case_stms", "case_stm",
  "default_stm", "func_param", "route_param", "async_func", "cmd", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-813)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-459)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    2164,  -114,  -105,   -30,   -26,    23,    37,    42,    53,   210,
     215,   229,   246,   250,   264,   268,   291,   302,   307,   311,
     317,   337,   343,   384,   390,   409,   439,   470,   478,   519,
     527,   546,   550,   555,   557,    21,   413,   492,   564,   565,
     618,   558,   568,   584,   587,   598,   612,   615,   625,   664,
     669,   679,   683,   688,   693,   696,   710,   717,   721,   726,
     727,   740,   745,   753,   758,    85,   763,    27,   767,   770,
     773,   780,   781,   788,   821,   822,   825,   828,   832,   840,
     842,   847,   849,   851,   852,   858,   859,   863,   868,   870,
     871,   872,   873,   875,   635,   642,   876,   877,   879,   880,
     882,   890,   892,   893,   895,  -813,   225,  2001,  -813,   330,
     496,   556,   629,   137,   689,   715,   752,   754,  -813,  -813,
    -813,   156,   157,   166,   357,   169,   182,   183,   199,     7,
      92,   226,   238,   348,   358,   365,   360,   398,   366,   658,
     730,   367,   381,    38,    75,   112,   121,   147,   148,   774,
     282,   397,   399,   410,  -813,   865,  -813,   866,  -813,   878,
    -813,   891,  -813,   896,  -813,   897,   411,   414,   425,   427,
     433,   442,   127,   443,   134,   460,   451,   459,   462,   464,
     468,   471,   484,   486,   490,   491,   493,   500,   135,   136,
    -813,  -813,   138,  -813,   867,   501,    59,   108,   502,   125,
     516,   520,   531,   554,   585,   586,   111,   120,   588,   592,
     593,   605,   608,   622,    84,   628,   639,   644,   655,   673,
     165,  -813,   899,  -813,   902,   874,   903,   139,   140,   677,
     691,   150,   692,   907,  -813,  -114,  -813,     2,  -813,     6,
    -813,    45,  -813,    19,  -813,    63,  -813,    66,  -813,    67,
    -813,    46,  -813,    50,  -813,  -813,  -813,  -813,  -813,  -813,
    -813,  -813,   908,   909,  -813,  -813,  -813,  -813,  -813,  -813,
    -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,
    -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,
    -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,
    -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,   815,  -813,
     844,  1008,  1013,  -813,  -813,  -813,   848,  -813,   853,  -813,
    -813,  -813,   885,   888,  -813,   -75,   889,  -813,  1205,  -813,
    -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,
    -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,   856,
    -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,
    -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,
    -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,
    -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,
    -813,  -813,  -813,  -813,  -813,  -813,   884,  -813,  -813,  -813,
    -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,
    -813,  -813,  -813,   898,  -813,  -813,  -813,  -813,  -813,  -813,
    -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,
    -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,
    -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,  -813,
    -813,  -813,  -813,  -813,  -813,  -813,   170,  -813,  -813,  -813,
    -813,  -813,  -813,  -813,  -813,  -813,  -813,   906,  -813,  -813,
    -813,   900,  -813,  1825,   341,  -813,   341,  -813,  1825,   341,
    -813,   341,  -813,  1825,  -813,  1825,  -813,  1825,  -813,   341,
    -813,   341,  -813,  -813,  -813,  1063,  1044,  1044,   141,   905,
    1172,  -813,   151,   913,  1172,  -813,   916,   918,   921,   712,
     883,  -813,   932,   941,   933,   939,   943,   -92,    69,    74,
      88,   946,   948,   949,   950,   951,   953,   962,   964,    91,
    -813,  -813,  -813,  1371,   967,   711,  -813,  -813,  -813,  -813,
    -813,    14,  -813,  -813,  -813,   963,   966,   742,   975,   976,
     783,   834,   929,   969,   980,   972,   977,   998,  1172,  1002,
    1001,  -813,  -813,  -813,  1044,  -813,  -813,  -813,  1014,  -813,
    -813,   995,  -813,  -813,  -813,   996,  -813,  -813,  -813,  -813,
    -813,   -95,   942,   850,  -813,  1010,  1365,  1011,   731,  -813,
    -813,  -813,   126,  -813,   143,  -813,    24,  1365,   -81,  1365,
     -81,  1015,  1025,  1035,  1035,  -813,   305,  1184,  1185,  -813,
    -813,  -813,  -813,  -813,  -813,  -813,  -813,  1550,  -813,  -813,
    -813,  -813,  -813,  -813,  1032,  1036,  -813,  1038,  1046,  -813,
    -813,  -813,  1052,  1055,   -64,    10,  -813,  1049,  -813,  -813,
    -813,  -813,  -813,    30,   -12,   712,  -813,   723,  -813,   808,
    -813,  -813,    57,  -813,  -813,  1074,  -813,  1365,  1365,  1603,
    1550,  -813,   222,  1736,  -813,  -813,  -813,  -813,  -813,  -813,
    -813,  -813,  1065,  1066,  1068,  1069,  1073,  1072,  1076,  1082,
    -813,  -116,  -813,   -25,  1083,   248,  1240,   -57,   -36,   251,
     300,    98,  1091,   -84,  1093,  -813,   831,  -813,  -813,  -813,
     532,  -813,  -813,  1550,  -813,  1550,  -813,  1647,  -813,  1546,
    -813,  1825,  1825,  1825,  1825,  1089,  1825,  -813,  -813,  -813,
    -813,  -813,    41,  -813,  -813,   314,  1098,   580,  -813,   808,
    -813,  -813,  -813,  1101,   604,  -813,  1040,  -813,  1113,  -813,
     551,  -813,   970,  1245,  1365,  1365,  1108,  -813,  -813,  -813,
    -813,  -813,  -813,  -813,  -813,   694,   -69,  -813,     7,   -45,
    -813,  -813,  -813,  -813,  1111,  -813,  1112,  -813,   437,  -813,
    1644,  1104,  1416,   -81,  -813,  -813,  -813,  -813,  1114,  -813,
    -813,  -813,   426,   341,   341,  -813,  -813,  -813,  -813,  -813,
     994,  -813,  -813,  1407,  1550,  1550,  1550,  1550,  1550,  1550,
    1550,  1550,  1550,  1550,  1020,  1051,  1092,  1133,  1106,  1253,
    -813,  -813,  -813,  -813,  -813,  1115,   619,   697,   -64,  -813,
    -813,  1265,  -813,  -813,  -813,  -813,  -813,  1110,  -813,  -813,
    -813,  -813,  -813,  1123,  1124,  -813,  -813,  -813,  -813,   674,
    1673,  1274,  -813,  1275,  1125,  1129,  -813,  1457,  1130,  -813,
    -813,  -813,  -813,  -813,  -813,    33,  1134,   596,   643,  1135,
    -813,   702,   735,   748,  -813,  -813,  -813,  -813,   722,   722,
     722,   722,   722,  -813,  -813,  -813,  -813,  -813,  -813,  -813,
    -813,  -813,  1825,  -813,   697,   -64,  -813,   764,  1139,  1140,
    -813,  -813,  -813,   631,  -813,  -813,  1294,  1644,   656,  1137,
     489,  -813,  1365,  -813,  -813,   645,  -813,  -813,  -813,  -813,
    1416,  -813,  -813,  -813,  -813,  1151,  -813,  1149,  -813,  1335,
     765,  1145,   -64,  -813,  -813,   590,  -813,  -813,  -813,  -813,
    -813,  -813,  1132,  1136,  -813,  1142,  -813,  -813,   563,  -813,
    -813,  -813,  -813,  1147,  1148,  -813,   -64,  -813,  -813,   776,
    1128,  1161,  1739,  1739,  1739,  1416,  -813,  -813,   785,  1160,
    -813,  1164,  1150,   415,   553,   676,  1328,  1176,  -813,  1170,
    1153,  1183,  1416,  1177,  -813,  1190,  1159,  -813,  -813,  1195,
    1193,  1342,  1207,  1206,  1355,  1180,  1214,  -813,  1182,  -813
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    26,     0,     0,     4,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     6,     7,
     307,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   147,     0,   149,     0,   151,     0,
     153,     0,   155,     0,   157,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     309,   308,     0,   313,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   289,     0,   291,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     1,     5,     3,     0,     9,     0,
      11,     0,    13,     0,    15,     0,    17,     0,    19,     0,
      21,     0,    23,     0,    25,   256,   253,   257,   254,   258,
     255,   260,     0,     0,    38,   259,   252,   251,   111,   110,
     107,   106,   109,   108,   103,   105,   104,   113,   112,   115,
     114,   117,   116,   119,   118,   121,   120,   123,   122,   125,
     124,   127,   126,   128,   129,   131,   130,   133,   132,   135,
     134,   137,   136,   139,   138,   141,   140,   264,     0,    35,
       0,    67,    66,   263,   262,   261,     0,   268,    32,    28,
     317,   316,     0,     0,    47,    29,     0,    51,    52,   267,
      27,   314,   318,   315,   270,   269,   143,   142,   145,   144,
     146,   148,   150,   152,   154,   156,   159,   158,   164,   162,
     168,   167,   170,   169,   172,   171,   174,   173,   176,   175,
     178,   177,   180,   179,   182,   181,   184,   183,   188,   187,
     186,   185,   190,   189,   192,   191,   194,   193,   196,   195,
     198,   197,   200,   199,   202,   201,   204,   203,   246,   245,
     248,   247,   250,   249,   287,   286,     0,   161,   160,   207,
     206,   205,   210,   209,   208,   212,   211,   215,   213,   214,
     217,   216,   220,   218,   222,   221,   224,   223,   226,   225,
     228,   227,   230,   229,   232,   231,   234,   233,   240,   239,
     242,   241,   244,   243,   236,   235,   238,   237,   272,    32,
     271,   274,   273,   276,   275,   278,   277,   280,   279,   282,
     281,   285,   283,   284,   288,   290,    90,   294,   296,   295,
     298,   297,   300,   299,   302,   301,   304,     0,   303,   306,
     305,   165,   331,     0,     0,   333,     0,   336,     0,     0,
     338,     0,   340,     0,   342,     0,   344,     0,   346,     0,
     348,     0,    39,    40,    44,     0,     0,     0,     0,     0,
       0,    31,     0,     0,     0,    53,     0,     0,     0,     0,
       0,   293,     0,     0,   484,     0,   486,   493,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     368,   432,   369,     0,     0,     0,   421,   427,   428,   429,
     430,     0,   325,   324,   326,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    45,    41,     0,     0,     0,
       0,    57,    58,    59,    64,    71,    69,   266,    74,   265,
     319,    48,    34,    33,   163,     0,   219,    93,    91,    92,
      95,    90,     0,     0,   166,     0,     0,     0,     0,   490,
     488,   496,     0,   499,     0,   503,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   508,     0,   379,   380,   381,
     382,   383,   384,   385,   386,   387,   388,     0,   431,   422,
     329,   420,   433,   426,     0,     0,   334,     0,     0,   339,
     341,   343,     0,     0,     0,     0,    62,    54,    61,    60,
      63,    65,    75,     0,     0,     0,   292,     0,   320,     0,
      89,    97,     0,   321,    86,     0,   485,     0,     0,     0,
       0,   372,     0,   373,   354,   370,   411,   371,   410,   409,
     487,   492,     0,     0,     0,     0,     0,     0,     0,     0,
     327,     0,   328,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   462,   505,   465,   468,
       0,   407,   408,     0,   390,     0,   389,   391,   392,   406,
     393,     0,     0,     0,     0,     0,     0,    36,    37,    46,
      43,    42,     0,    50,    49,     0,     0,     0,    94,     0,
      87,    72,    73,     0,     0,    98,     0,    88,     0,   351,
       0,   413,     0,     0,     0,     0,     0,   355,   357,   358,
     359,   360,   356,   361,   362,   363,   364,   367,     0,     0,
     491,   489,   497,   494,     0,   500,     0,   504,     0,   501,
       0,     0,     0,     0,   322,   509,   323,   510,     0,   511,
     512,   482,     0,     0,     0,   519,   507,   463,   466,   469,
     464,   506,   404,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      56,    55,   310,   312,   311,     0,     0,     0,     0,    84,
      96,     0,   352,   412,   353,   350,   349,     0,   377,   378,
     376,   375,   374,     0,     0,   473,   471,   472,   474,     0,
       0,   445,   417,     0,     0,     0,   441,     0,     0,   447,
     414,   436,   437,   438,   439,     0,     0,     0,     0,     0,
     479,     0,     0,     0,   461,   467,   470,   405,   400,   399,
     401,   402,   403,   394,   395,   396,   398,   397,   330,   332,
     335,   337,     0,   347,     0,     0,    85,     0,     0,     0,
     483,   495,   498,     0,   502,   419,     0,     0,     0,     0,
     451,   453,     0,   434,   416,     0,   424,   440,   442,   435,
       0,   513,   514,   481,   480,     0,   515,     0,   518,     0,
       0,     0,     0,    80,    82,     0,   478,   475,   476,   477,
     418,   446,     0,     0,   449,     0,   452,   450,     0,   425,
     415,   423,   448,     0,     0,   345,     0,    81,    83,     0,
     102,     0,   457,   455,   459,     0,   516,   517,     0,     0,
      78,     0,   101,     0,     0,     0,   443,     0,    79,     0,
       0,     0,     0,     0,    76,     0,     0,   444,    77,     0,
       0,     0,     0,     0,     0,     0,     0,   100,     0,    99
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -813,  -813,  -813,  1280,  -813,  -813,  -813,  -813,  -813,  -813,
    -813,  -813,  -813,  -210,  -813,  -813,  -149,  -611,  -124,  -142,
    -813,  -813,  1064,  -813,  -813,  -461,  1243,  -813,  -813,   665,
     829,   657,   817,   755,  -813,  -813,  -813,  -813,  -813,  -148,
    -813,  1077,  -813,  -609,  -540,  -420,  -813,  -813,  -813,  -813,
    -813,  -813,  -813,  -813,  -813,  -813,  -570,  -813,  -813,  -813,
    -813,  -813,  -255,  -813,  -556,  -813,   382,  -576,  -813,  -812,
     505,  -469,   -29,  -502,   -13,  -813,  -542,  -700,  -676,  -456,
    -813,  -813,   503,  -813,   632,  -813,   800,  -580
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   324,   503,   325,   310,   719,   706,   311,
     312,   328,   329,   638,   564,   565,   313,   497,   496,   733,
     569,   651,   511,   580,   581,   652,   468,   118,   119,   653,
     331,   332,   333,   654,   688,   545,   681,   238,   240,   242,
     244,   246,   248,   250,   252,   254,   662,   755,   756,   757,
     758,   759,   533,   664,   708,   617,   709,   534,   667,   849,
     841,   535,   905,   536,   850,   851,   537,   538,   539,   540,
     899,   900,   901,   937,   700,   839,   692,   541
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     265,   326,   330,   472,   440,   274,   669,   475,   327,   547,
     666,   720,   288,   290,   550,   622,   551,   669,   552,   669,
     480,   666,   154,   666,   721,   679,   120,   683,   193,   685,
     665,   723,   724,   621,   908,   121,   566,   710,   730,   299,
     734,   665,   810,   665,   668,   621,   477,   488,   621,   621,
     621,   490,   367,   369,   371,   668,   546,   668,   735,   548,
     399,   549,   690,   768,   482,   769,   330,   484,   486,   553,
     591,   554,   852,   262,   263,   593,   301,   669,   669,   264,
     710,   666,   666,   530,   645,   438,   190,   739,   740,   595,
     588,   501,   605,   275,   530,   784,   853,   785,   942,   781,
     510,   665,   665,   641,   727,  -366,  -366,   717,   532,   402,
     122,   811,   422,   303,   123,   668,   668,   774,   502,   532,
     816,   424,   305,   710,   775,   710,   407,   674,   358,   831,
     530,  -366,   718,   744,   745,   362,   390,   392,   776,   394,
     458,   460,   567,   966,   677,   777,   829,   852,   307,   314,
     245,   466,   572,   262,   263,   532,   770,   255,   257,   264,
     977,   155,   725,   124,   669,   669,   451,   259,   666,   666,
     266,   853,   262,   263,   825,   826,   680,   125,   264,   326,
     330,   717,   126,   268,   270,   473,   327,   474,   665,   665,
     742,   476,   855,   127,   623,   542,   848,   543,   544,   530,
     272,   717,   668,   668,   481,   852,   718,   888,   887,   194,
     852,   300,   717,   909,   710,   710,   710,   710,   710,   710,
     710,   710,   710,   710,   532,   234,   718,   277,   478,   853,
     479,   489,   400,   401,   853,   491,   736,   718,   858,   279,
     621,   737,   804,   805,   806,   807,   483,   809,   302,   485,
     487,   592,   852,   852,   852,   852,   594,   439,   319,   191,
     320,   321,   590,   852,   852,   852,   276,   855,   842,   322,
     596,   848,   852,   606,   921,   920,   853,   853,   853,   853,
     782,   403,   404,   317,   423,   556,   304,   853,   853,   853,
     571,   262,   263,   425,   556,   306,   853,   264,   408,   409,
     675,   359,   621,   621,   621,   621,   694,   621,   363,   391,
     393,   949,   395,   459,   461,   568,   854,   678,   308,   308,
     309,   309,   669,   467,   -30,   855,   666,   256,   258,   848,
     855,   663,   938,   673,   848,   958,   452,   260,   453,   237,
     267,   682,   663,   684,   663,   686,   665,   330,   637,   281,
     128,   699,   330,   269,   271,   129,   330,   509,   261,   283,
     668,   287,   707,   862,   863,   510,   285,   291,   295,   130,
     273,   896,   855,   855,   855,   855,   848,   848,   848,   848,
     744,   745,   297,   855,   855,   855,   131,   848,   848,   848,
     132,   854,   855,   589,   621,   842,   848,   278,   334,   289,
     336,   746,   663,   663,   133,   707,   744,   745,   134,   280,
     330,   338,   346,   919,   156,   348,   939,   621,   514,   515,
     516,   517,   518,   519,   520,   774,   350,   859,   352,   772,
     778,   135,   779,   844,   354,   522,  -456,  -456,   845,   523,
     524,   789,   136,   356,   360,   525,   526,   137,   707,   854,
     707,   138,   366,   308,   854,   318,   319,   139,   320,   321,
     368,   364,   661,   370,   672,   372,   835,   322,   676,   374,
     262,   263,   376,   661,   776,   661,   264,   140,   323,   695,
     530,   780,   698,   141,   696,   378,   697,   380,   774,   663,
     663,   382,   384,   158,   386,   812,   854,   854,   854,   854,
     732,   388,   397,   405,   832,   532,   239,   854,   854,   854,
     898,   935,   542,   838,   543,   544,   854,   410,   856,   282,
     726,   412,   262,   263,   142,   262,   263,   699,   264,   284,
     143,   264,   414,   661,   661,   866,   286,   292,   296,   707,
     707,   707,   707,   707,   707,   707,   707,   707,   707,   144,
     527,   528,   298,   157,   939,   416,   514,   515,   516,   517,
     518,   519,   520,   262,   263,   160,   162,   241,   335,   264,
     337,   844,   788,   522,  -454,  -454,   845,   523,   524,   145,
     732,   339,   347,   525,   526,   349,   418,   420,   529,   426,
     530,   262,   263,   428,   430,   846,   351,   264,   353,  -456,
     695,   530,   262,   263,   355,   696,   432,   860,   264,   434,
     146,   836,   530,   357,   361,   532,   262,   263,   147,   164,
     661,   661,   264,   436,   262,   263,   532,   262,   263,   441,
     264,   365,   159,   264,   830,   373,   221,   532,   929,   375,
     443,   243,   377,   223,   837,   445,   939,   663,   514,   515,
     516,   517,   518,   519,   520,   379,   447,   381,   698,   148,
     926,   383,   385,   844,   387,   522,   865,   149,   845,   523,
     524,   389,   398,   406,   449,   525,   526,   939,   462,   514,
     515,   516,   517,   518,   519,   520,   150,   411,   527,   528,
     151,   413,   464,   469,   844,   152,   522,   153,   166,   845,
     523,   524,   415,   247,   161,   163,   525,   526,   167,   744,
     745,   790,   619,   791,   514,   515,   516,   517,   518,   519,
     520,   744,   745,   828,   168,   417,   529,   169,   530,   521,
     249,   522,   822,   846,   577,   523,   524,  -454,   170,   578,
     579,   525,   526,   619,   955,   514,   515,   516,   517,   518,
     519,   520,   171,   532,   776,   172,   419,   421,   165,   427,
     521,   814,   522,   429,   431,   173,   523,   524,   251,   928,
     774,   253,   525,   526,   933,   222,   433,   911,   661,   435,
     527,   528,   224,   818,   619,   819,   514,   515,   516,   517,
     518,   519,   520,   437,   950,   951,   262,   263,   885,   442,
     886,   521,   264,   522,   174,   927,   530,   523,   524,   175,
     444,   527,   528,   525,   526,   446,   494,   776,   529,   176,
     530,   262,   263,   177,   912,   846,   448,   264,   178,   940,
     932,   532,   293,   179,   906,   619,   180,   514,   515,   516,
     517,   518,   519,   520,   450,   532,   527,   528,   463,   529,
     181,   530,   521,   893,   522,   894,   846,   182,   523,   524,
    -458,   183,   465,   470,   525,   526,   184,   185,  -365,  -365,
     320,   321,   648,   320,   321,   648,   532,   527,   528,   322,
     186,   790,   322,   914,   529,   187,   530,   799,   800,   801,
     802,   531,   941,   188,  -365,   620,   262,   263,   189,   320,
     321,   648,   264,   192,   294,   729,   530,   195,   322,   803,
     196,   532,   671,   197,   915,   529,   916,   530,   527,   528,
     198,   199,   531,   963,   964,   965,   626,   917,   200,   918,
     619,   532,   514,   515,   516,   517,   518,   519,   520,   906,
     906,   906,   532,   922,   946,   923,   947,   521,   316,   522,
     941,   941,   941,   523,   524,   959,   529,   960,   530,   525,
     526,   201,   202,   531,   967,   203,   968,   629,   204,   527,
     528,   619,   205,   514,   515,   516,   517,   518,   519,   520,
     206,   309,   207,   532,   320,   321,   648,   208,   521,   209,
     522,   210,   211,   322,   523,   524,   262,   263,   212,   213,
     525,   526,   264,   214,   731,   787,   530,   529,   215,   530,
     216,   217,   218,   219,   531,   220,   225,   226,   630,   227,
     228,   619,   229,   514,   515,   516,   517,   518,   519,   520,
     230,   532,   231,   232,   532,   233,   340,   341,   521,   495,
     522,   396,   743,   498,   523,   524,   506,   456,   -35,   342,
     525,   526,   619,   655,   514,   515,   516,   517,   518,   519,
     520,   320,   343,   507,   527,   528,   582,   344,   345,   521,
     454,   522,   -70,   455,   457,   523,   524,   -68,   471,   492,
     493,   525,   526,   500,   504,   792,   573,   793,   508,   574,
     513,   570,   575,   619,   576,   514,   515,   516,   517,   518,
     519,   520,   529,   583,   530,   527,   528,   512,   557,   531,
     521,   647,   522,   631,   584,   585,   523,   524,   320,   321,
     648,   586,   525,   526,   649,   587,   650,   322,   597,   532,
     598,   599,   600,   601,   619,   602,   514,   515,   516,   517,
     518,   519,   520,   529,   603,   530,   604,   618,   632,   624,
     531,   521,   625,   522,   823,   527,   528,   523,   524,   262,
     263,   627,   628,   525,   526,   264,   633,   634,   864,   530,
     532,   636,   635,   639,   640,   644,   868,   869,   870,   871,
     872,   873,   874,   875,   876,   877,   527,   528,   568,   687,
     643,   656,   670,   529,   532,   530,   -70,   -70,   -70,   689,
     531,   -68,   -68,   -68,   878,   -70,   -70,   -70,   691,   647,
     -68,   -68,   -68,   701,   702,   711,   320,   321,   648,   712,
     532,   713,   649,   715,   529,   322,   530,   527,   528,   714,
     555,   531,   558,   559,   560,   879,   439,   319,   716,   320,
     321,   561,   562,   563,   722,   738,   760,   761,   322,   762,
     763,   532,   764,   765,   619,   766,   514,   515,   516,   517,
     518,   519,   520,   767,   771,   529,   773,   530,   527,   528,
     783,   521,   531,   522,   786,   808,   880,   523,   524,   813,
     817,   821,   827,   525,   526,   833,   834,   843,   857,   882,
     889,   890,   532,   897,   884,   619,   898,   514,   515,   516,
     517,   518,   519,   520,   891,   892,   529,   902,   530,   903,
     907,   925,   521,   531,   522,   910,   913,   881,   523,   524,
     924,   934,   943,   944,   525,   526,   948,   952,   956,   957,
     961,   953,   962,   532,   969,   970,   619,   954,   514,   515,
     516,   517,   518,   519,   520,   439,   319,   972,   320,   321,
     973,   974,   971,   521,   976,   522,   975,   322,   978,   523,
     524,   979,   980,   981,   982,   525,   526,   983,   514,   515,
     516,   517,   518,   519,   520,   984,   308,   985,   318,   319,
     986,   320,   321,   521,   987,   988,   989,   236,   527,   528,
     322,   315,   505,   820,   815,   525,   526,   642,   646,   499,
     728,   323,   931,   936,   693,   794,   795,   796,   797,   798,
     799,   800,   801,   802,   861,     0,     0,     0,     0,   514,
     515,   516,   517,   518,   519,   520,   529,     0,   530,   527,
     528,   824,   803,   531,   844,     0,   522,   883,     0,   845,
     523,   524,     0,     0,     0,     0,   525,   526,     0,     0,
       0,     0,     0,   532,     0,     0,     0,     0,     0,     0,
     514,   515,   516,   517,   518,   519,   520,   529,     0,   530,
     527,   528,     0,     0,   531,   844,     0,   522,   930,     0,
     845,   523,   524,     0,     0,     0,     0,   525,   526,     0,
       0,     0,     0,     0,   532,     0,     0,     0,     0,     0,
     527,   528,     0,     0,     0,     0,     0,     0,   529,     0,
     530,   607,     0,     0,     0,   531,     0,     0,     0,   945,
     608,   609,   610,   611,   612,   613,   614,   615,   616,     0,
     262,   263,     0,     0,   657,   532,   264,     0,   529,     0,
     530,     0,     0,     0,     0,     0,     0,   658,   659,     0,
     660,   527,   528,   514,   515,   516,   517,   518,   519,   520,
       0,     0,     0,     0,     0,   532,     0,   794,   795,   796,
     797,   798,   799,   800,   801,   802,     0,     0,     0,     0,
     525,   526,     0,     0,     0,     0,     0,     0,   867,   529,
       0,   530,   527,   528,   803,     0,   846,     0,     0,   847,
       0,     0,     0,     0,     0,     0,   514,   515,   516,   517,
     518,   519,   520,     0,     0,     0,   532,     0,     0,     0,
       0,   521,     0,   522,     0,     0,     0,   523,   524,     0,
     529,     0,   530,   525,   526,     0,     0,   846,     0,     0,
       0,   904,     0,     0,     0,     0,     0,   514,   515,   516,
     517,   518,   519,   520,     0,     0,     0,   532,     0,     0,
       0,     0,   521,     0,   522,     0,     0,     0,   523,   524,
       0,     0,     0,     0,   525,   526,   514,   515,   516,   517,
     518,   519,   520,     0,     0,   527,   528,     0,     0,     0,
       0,   521,     0,   522,     0,     0,     0,   523,   524,     0,
       0,     0,     0,   525,   526,     0,   794,   795,   796,   797,
     798,   799,   800,   801,   802,   262,   263,     0,     0,     0,
     703,   264,     0,   529,   704,   530,     0,     0,     0,     0,
       0,     0,   705,   803,     0,     0,     0,     0,   527,   528,
       0,     0,   514,   515,   516,   517,   518,   519,   520,     0,
     532,     0,     0,     0,     0,     0,     0,   844,     0,   522,
       0,     0,   845,   523,   524,     0,     0,     0,     0,   525,
     526,     0,     0,     0,     0,     0,   529,     0,   530,   527,
     528,     0,     0,   531,     0,     0,     0,   741,   747,   748,
     749,   750,   751,   752,   753,   754,     0,     0,     0,     0,
       0,     0,     0,   532,     0,     0,     0,     0,   527,   528,
       0,     0,     0,     0,     0,     0,     0,   529,     0,   530,
       0,     0,     0,     0,   531,     0,     0,   840,   514,   515,
     516,   517,   518,   519,   520,     0,     0,     0,     0,     0,
       0,     0,     0,   521,   532,   522,   529,     0,   530,   523,
     524,     0,     0,   531,     0,   525,   526,   895,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   532,   527,   528,   607,   747,   748,   749,
     750,   751,   752,   753,   754,   608,   609,   610,   611,   612,
     613,   614,   615,   616,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   529,     0,   530,     0,     0,     0,     0,   846,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   532,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     527,   528,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   529,     0,
     530,    -2,   235,     0,     0,   531,     0,     0,     0,     0,
      -8,   -10,   -12,   -14,   -16,   -18,   -20,   -22,   -24,     0,
       0,     0,     0,     0,     0,   532,     0,     0,     0,     0,
       0,     0,     0,     2,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,     0,
      28,    29,    30,    31,    32,     0,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,     0,     0,     0,   102,   103,
     104,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     1,     0,     0,     0,     0,
       0,     0,     0,    -8,   -10,   -12,   -14,   -16,   -18,   -20,
     -22,   -24,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   105,     2,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,     0,    28,    29,    30,    31,    32,     0,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,     0,     0,
       0,   102,   103,   104,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   105
};

static const yytype_int16 yycheck[] =
{
     124,   150,   150,     1,   214,   129,   586,     1,   150,   478,
     586,     1,   136,   137,   483,     1,   485,   597,   487,   599,
       1,   597,     1,   599,   635,     1,   140,   597,     1,   599,
     586,     1,   643,   535,     1,   140,   497,   617,   647,     1,
     649,   597,     1,   599,   586,   547,     1,     1,   550,   551,
     552,     1,   176,   177,   178,   597,   476,   599,     1,   479,
       1,   481,   602,   179,     1,   181,   214,     1,     1,   489,
       1,   491,   772,   165,   166,     1,     1,   657,   658,   171,
     660,   657,   658,   175,   179,     1,     1,   657,   658,     1,
     182,   166,     1,     1,   175,   179,   772,   181,   910,     1,
     195,   657,   658,   564,   644,   174,   175,   171,   200,     1,
     140,   722,     1,     1,   140,   657,   658,   174,   193,   200,
     729,     1,     1,   703,   181,   705,     1,     1,     1,   174,
     175,   200,   196,   158,   159,     1,     1,     1,   174,     1,
       1,     1,     1,   955,     1,   181,   755,   847,     1,     1,
      13,     1,     1,   165,   166,   200,   181,     1,     1,   171,
     972,   140,   174,   140,   744,   745,     1,     1,   744,   745,
       1,   847,   165,   166,   744,   745,   596,   140,   171,   328,
     328,   171,   140,     1,     1,   183,   328,   185,   744,   745,
     659,   185,   772,   140,   180,   171,   772,   173,   174,   175,
       1,   171,   744,   745,   185,   905,   196,   818,   817,   182,
     910,   173,   171,   180,   794,   795,   796,   797,   798,   799,
     800,   801,   802,   803,   200,     0,   196,     1,   183,   905,
     185,   185,   173,   174,   910,   185,   179,   196,   778,     1,
     742,   184,   711,   712,   713,   714,   183,   716,   173,   183,
     183,   182,   952,   953,   954,   955,   182,   173,   174,   174,
     176,   177,   517,   963,   964,   965,   174,   847,   770,   185,
     182,   847,   972,   182,   885,   884,   952,   953,   954,   955,
     182,   173,   174,     1,   173,   495,   174,   963,   964,   965,
     500,   165,   166,   173,   504,   174,   972,   171,   173,   174,
     174,   174,   804,   805,   806,   807,     1,   809,   174,   174,
     174,   922,   174,   174,   174,   174,   772,   174,   171,   171,
     173,   173,   902,   173,   173,   905,   902,   171,   171,   905,
     910,   586,   902,   588,   910,   946,   171,   171,   173,     9,
     171,   596,   597,   598,   599,   600,   902,   495,   558,     1,
     140,   606,   500,   171,   171,   140,   504,   187,     1,     1,
     902,     1,   617,   783,   784,   195,     1,     1,     1,   140,
     171,   840,   952,   953,   954,   955,   952,   953,   954,   955,
     158,   159,     1,   963,   964,   965,   140,   963,   964,   965,
     140,   847,   972,   517,   896,   897,   972,   171,     1,     1,
       1,   179,   657,   658,   140,   660,   158,   159,   140,   171,
     558,     1,     1,   882,     1,     1,     1,   919,     3,     4,
       5,     6,     7,     8,     9,   174,     1,     1,     1,   181,
     179,   140,   181,    18,     1,    20,    21,    22,    23,    24,
      25,   696,   140,     1,     1,    30,    31,   140,   703,   905,
     705,   140,     1,   171,   910,   173,   174,   140,   176,   177,
       1,     1,   586,     1,   588,     1,    29,   185,   592,     1,
     165,   166,     1,   597,   174,   599,   171,   140,   196,   174,
     175,   181,   606,   140,   179,     1,   181,     1,   174,   744,
     745,     1,     1,     1,     1,   181,   952,   953,   954,   955,
     649,     1,     1,     1,   759,   200,    10,   963,   964,   965,
      21,    22,   171,   768,   173,   174,   972,     1,   773,   171,
     644,     1,   165,   166,   140,   165,   166,   782,   171,   171,
     140,   171,     1,   657,   658,   790,   171,   171,   171,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   140,
     135,   136,   171,   140,     1,     1,     3,     4,     5,     6,
       7,     8,     9,   165,   166,     1,     1,    11,   171,   171,
     171,    18,   696,    20,    21,    22,    23,    24,    25,   140,
     729,   171,   171,    30,    31,   171,     1,     1,   173,     1,
     175,   165,   166,     1,     1,   180,   171,   171,   171,   184,
     174,   175,   165,   166,   171,   179,     1,   181,   171,     1,
     140,   174,   175,   171,   171,   200,   165,   166,   140,     1,
     744,   745,   171,     1,   165,   166,   200,   165,   166,     1,
     171,   171,   140,   171,   758,   171,     1,   200,   893,   171,
       1,    12,   171,     1,   768,     1,     1,   902,     3,     4,
       5,     6,     7,     8,     9,   171,     1,   171,   782,   140,
      29,   171,   171,    18,   171,    20,   790,   140,    23,    24,
      25,   171,   171,   171,     1,    30,    31,     1,     1,     3,
       4,     5,     6,     7,     8,     9,   140,   171,   135,   136,
     140,   171,     1,     1,    18,   140,    20,   140,   140,    23,
      24,    25,   171,    14,   140,   140,    30,    31,   140,   158,
     159,   179,     1,   181,     3,     4,     5,     6,     7,     8,
       9,   158,   159,    29,   140,   171,   173,   140,   175,    18,
      15,    20,   181,   180,    22,    24,    25,   184,   140,    27,
      28,    30,    31,     1,   181,     3,     4,     5,     6,     7,
       8,     9,   140,   200,   174,   140,   171,   171,   140,   171,
      18,   181,    20,   171,   171,   140,    24,    25,    16,   893,
     174,    17,    30,    31,   898,   140,   171,   181,   902,   171,
     135,   136,   140,   179,     1,   181,     3,     4,     5,     6,
       7,     8,     9,   171,   204,   205,   165,   166,   179,   171,
     181,    18,   171,    20,   140,   174,   175,    24,    25,   140,
     171,   135,   136,    30,    31,   171,     1,   174,   173,   140,
     175,   165,   166,   140,   181,   180,   171,   171,   140,   184,
     174,   200,   174,   140,   847,     1,   140,     3,     4,     5,
       6,     7,     8,     9,   171,   200,   135,   136,   171,   173,
     140,   175,    18,   179,    20,   181,   180,   140,    24,    25,
     184,   140,   171,   171,    30,    31,   140,   140,   174,   175,
     176,   177,   178,   176,   177,   178,   200,   135,   136,   185,
     140,   179,   185,   181,   173,   140,   175,   165,   166,   167,
     168,   180,   905,   140,   200,   184,   165,   166,   140,   176,
     177,   178,   171,   140,   174,   182,   175,   140,   185,   187,
     140,   200,   181,   140,   179,   173,   181,   175,   135,   136,
     140,   140,   180,   952,   953,   954,   184,   179,   140,   181,
       1,   200,     3,     4,     5,     6,     7,     8,     9,   952,
     953,   954,   200,   179,   179,   181,   181,    18,   174,    20,
     963,   964,   965,    24,    25,   179,   173,   181,   175,    30,
      31,   140,   140,   180,   179,   140,   181,   184,   140,   135,
     136,     1,   140,     3,     4,     5,     6,     7,     8,     9,
     140,   173,   140,   200,   176,   177,   178,   140,    18,   140,
      20,   140,   140,   185,    24,    25,   165,   166,   140,   140,
      30,    31,   171,   140,   196,   174,   175,   173,   140,   175,
     140,   140,   140,   140,   180,   140,   140,   140,   184,   140,
     140,     1,   140,     3,     4,     5,     6,     7,     8,     9,
     140,   200,   140,   140,   200,   140,   171,   171,    18,   195,
      20,   174,   660,   195,    24,    25,   190,   173,   195,   171,
      30,    31,     1,   203,     3,     4,     5,     6,     7,     8,
       9,   176,   171,   179,   135,   136,   183,   171,   171,    18,
     171,    20,    64,   171,   171,    24,    25,    64,   171,   171,
     171,    30,    31,   195,   195,   703,   173,   705,   190,   173,
     190,   186,   174,     1,   173,     3,     4,     5,     6,     7,
       8,     9,   173,   171,   175,   135,   136,   201,    64,   180,
      18,   169,    20,   184,   173,   182,    24,    25,   176,   177,
     178,   182,    30,    31,   182,   182,   184,   185,   182,   200,
     182,   182,   182,   182,     1,   182,     3,     4,     5,     6,
       7,     8,     9,   173,   182,   175,   182,   180,   179,   186,
     180,    18,   186,    20,   184,   135,   136,    24,    25,   165,
     166,   186,   186,    30,    31,   171,   186,   195,   174,   175,
     200,   173,   195,   171,   173,   179,   794,   795,   796,   797,
     798,   799,   800,   801,   802,   803,   135,   136,   174,   174,
     195,   181,   181,   173,   200,   175,   188,   189,   190,   174,
     180,   188,   189,   190,   184,   197,   198,   199,   173,   169,
     197,   198,   199,    29,    29,   183,   176,   177,   178,   183,
     200,   183,   182,   171,   173,   185,   175,   135,   136,   183,
     167,   180,   188,   189,   190,   184,   173,   174,   183,   176,
     177,   197,   198,   199,   195,   171,   181,   181,   185,   181,
     181,   200,   179,   181,     1,   179,     3,     4,     5,     6,
       7,     8,     9,   181,   181,   173,    26,   175,   135,   136,
     179,    18,   180,    20,   181,   186,   184,    24,    25,   181,
     179,   168,   174,    30,    31,   174,   174,   183,   174,   183,
      25,   181,   200,    19,   179,     1,    21,     3,     4,     5,
       6,     7,     8,     9,   181,   181,   173,   182,   175,   180,
     180,   171,    18,   180,    20,   181,   181,   184,    24,    25,
     181,   184,   171,   174,    30,    31,   181,   195,   181,   181,
     202,   195,   171,   200,   174,   171,     1,   195,     3,     4,
       5,     6,     7,     8,     9,   173,   174,    19,   176,   177,
     174,   181,   202,    18,   171,    20,   203,   185,   181,    24,
      25,   171,   203,   168,   171,    30,    31,    25,     3,     4,
       5,     6,     7,     8,     9,   168,   171,   171,   173,   174,
      25,   176,   177,    18,   204,   171,   204,   107,   135,   136,
     185,   148,   328,   736,   729,    30,    31,   568,   581,   322,
     645,   196,   897,   900,   604,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   782,    -1,    -1,    -1,    -1,     3,
       4,     5,     6,     7,     8,     9,   173,    -1,   175,   135,
     136,   186,   187,   180,    18,    -1,    20,   184,    -1,    23,
      24,    25,    -1,    -1,    -1,    -1,    30,    31,    -1,    -1,
      -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,    -1,    -1,
       3,     4,     5,     6,     7,     8,     9,   173,    -1,   175,
     135,   136,    -1,    -1,   180,    18,    -1,    20,   184,    -1,
      23,    24,    25,    -1,    -1,    -1,    -1,    30,    31,    -1,
      -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,    -1,
     135,   136,    -1,    -1,    -1,    -1,    -1,    -1,   173,    -1,
     175,   140,    -1,    -1,    -1,   180,    -1,    -1,    -1,   184,
     149,   150,   151,   152,   153,   154,   155,   156,   157,    -1,
     165,   166,    -1,    -1,   169,   200,   171,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
     185,   135,   136,     3,     4,     5,     6,     7,     8,     9,
      -1,    -1,    -1,    -1,    -1,   200,    -1,   160,   161,   162,
     163,   164,   165,   166,   167,   168,    -1,    -1,    -1,    -1,
      30,    31,    -1,    -1,    -1,    -1,    -1,    -1,   181,   173,
      -1,   175,   135,   136,   187,    -1,   180,    -1,    -1,   183,
      -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,     6,
       7,     8,     9,    -1,    -1,    -1,   200,    -1,    -1,    -1,
      -1,    18,    -1,    20,    -1,    -1,    -1,    24,    25,    -1,
     173,    -1,   175,    30,    31,    -1,    -1,   180,    -1,    -1,
      -1,   184,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,
       6,     7,     8,     9,    -1,    -1,    -1,   200,    -1,    -1,
      -1,    -1,    18,    -1,    20,    -1,    -1,    -1,    24,    25,
      -1,    -1,    -1,    -1,    30,    31,     3,     4,     5,     6,
       7,     8,     9,    -1,    -1,   135,   136,    -1,    -1,    -1,
      -1,    18,    -1,    20,    -1,    -1,    -1,    24,    25,    -1,
      -1,    -1,    -1,    30,    31,    -1,   160,   161,   162,   163,
     164,   165,   166,   167,   168,   165,   166,    -1,    -1,    -1,
     170,   171,    -1,   173,   174,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   187,    -1,    -1,    -1,    -1,   135,   136,
      -1,    -1,     3,     4,     5,     6,     7,     8,     9,    -1,
     200,    -1,    -1,    -1,    -1,    -1,    -1,    18,    -1,    20,
      -1,    -1,    23,    24,    25,    -1,    -1,    -1,    -1,    30,
      31,    -1,    -1,    -1,    -1,    -1,   173,    -1,   175,   135,
     136,    -1,    -1,   180,    -1,    -1,    -1,   184,   141,   142,
     143,   144,   145,   146,   147,   148,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   135,   136,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,   180,    -1,    -1,   183,     3,     4,
       5,     6,     7,     8,     9,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    18,   200,    20,   173,    -1,   175,    24,
      25,    -1,    -1,   180,    -1,    30,    31,   184,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   200,   135,   136,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   156,   157,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,   180,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     135,   136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,    -1,
     175,     0,     1,    -1,    -1,   180,    -1,    -1,    -1,    -1,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    -1,
      -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,    -1,    -1,    -1,   137,   138,
     139,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   194,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    -1,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,    -1,    -1,
      -1,   137,   138,   139,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   194
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,     1,    32,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    59,    60,
      61,    62,    63,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   137,   138,   139,   194,   208,   209,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   219,   244,   245,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,     1,   140,     1,   140,     1,   140,
       1,   140,     1,   140,     1,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
       1,   174,   140,     1,   182,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,     1,   140,     1,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,     0,     1,   210,     9,   254,    10,
     255,    11,   256,    12,   257,    13,   258,    14,   259,    15,
     260,    16,   261,    17,   262,     1,   171,     1,   171,     1,
     171,     1,   165,   166,   171,   225,     1,   171,     1,   171,
       1,   171,     1,   171,   225,     1,   174,     1,   171,     1,
     171,     1,   171,     1,   171,     1,   171,     1,   225,     1,
     225,     1,   171,   174,   174,     1,   171,     1,   171,     1,
     173,     1,   173,     1,   174,     1,   174,     1,   171,   173,
     223,   226,   227,   233,     1,   233,   174,     1,   173,   174,
     176,   177,   185,   196,   220,   222,   223,   226,   228,   229,
     246,   247,   248,   249,     1,   171,     1,   171,     1,   171,
     171,   171,   171,   171,   171,   171,     1,   171,     1,   171,
       1,   171,     1,   171,     1,   171,     1,   171,     1,   174,
       1,   171,     1,   174,     1,   171,     1,   225,     1,   225,
       1,   225,     1,   171,     1,   171,     1,   171,     1,   171,
       1,   171,     1,   171,     1,   171,     1,   171,     1,   171,
       1,   174,     1,   174,     1,   174,   174,     1,   171,     1,
     173,   174,     1,   173,   174,     1,   171,     1,   173,   174,
       1,   171,     1,   171,     1,   171,     1,   171,     1,   171,
       1,   171,     1,   173,     1,   173,     1,   171,     1,   171,
       1,   171,     1,   171,     1,   171,     1,   171,     1,   173,
     220,     1,   171,     1,   171,     1,   171,     1,   171,     1,
     171,     1,   171,   173,   171,   171,   173,   171,     1,   174,
       1,   174,     1,   171,     1,   171,     1,   173,   243,     1,
     171,   171,     1,   183,   185,     1,   185,     1,   183,   185,
       1,   185,     1,   183,     1,   183,     1,   183,     1,   185,
       1,   185,   171,   171,     1,   195,   235,   234,   195,   248,
     195,   166,   193,   221,   195,   229,   190,   179,   190,   187,
     195,   239,   201,   190,     3,     4,     5,     6,     7,     8,
       9,    18,    20,    24,    25,    30,    31,   135,   136,   173,
     175,   180,   200,   269,   274,   278,   280,   283,   284,   285,
     286,   294,   171,   173,   174,   252,   252,   278,   252,   252,
     278,   278,   278,   252,   252,   167,   220,    64,   188,   189,
     190,   197,   198,   199,   231,   232,   232,     1,   174,   237,
     186,   220,     1,   173,   173,   174,   173,    22,    27,    28,
     240,   241,   183,   171,   173,   182,   182,   182,   182,   225,
     269,     1,   182,     1,   182,     1,   182,   182,   182,   182,
     182,   182,   182,   182,   182,     1,   182,   140,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   272,   180,     1,
     184,   280,     1,   180,   186,   186,   184,   186,   186,   184,
     184,   184,   179,   186,   195,   195,   173,   220,   230,   171,
     173,   232,   237,   195,   179,   179,   239,   169,   178,   182,
     184,   238,   242,   246,   250,   203,   181,   169,   182,   183,
     185,   225,   263,   269,   270,   271,   274,   275,   283,   294,
     181,   181,   225,   269,     1,   174,   225,     1,   174,     1,
     252,   253,   269,   263,   269,   263,   269,   174,   251,   174,
     251,   173,   293,   293,     1,   174,   179,   181,   225,   269,
     291,    29,    29,   170,   174,   182,   225,   269,   271,   273,
     294,   183,   183,   183,   183,   171,   183,   171,   196,   224,
       1,   224,   195,     1,   224,   174,   225,   251,   240,   182,
     250,   196,   223,   236,   250,     1,   179,   184,   171,   263,
     263,   184,   278,   273,   158,   159,   179,   141,   142,   143,
     144,   145,   146,   147,   148,   264,   265,   266,   267,   268,
     181,   181,   181,   181,   179,   181,   179,   181,   179,   181,
     181,   181,   181,    26,   174,   181,   174,   181,   179,   181,
     181,     1,   182,   179,   179,   181,   181,   174,   225,   269,
     179,   181,   273,   273,   160,   161,   162,   163,   164,   165,
     166,   167,   168,   187,   278,   278,   278,   278,   186,   278,
       1,   224,   181,   181,   181,   236,   250,   179,   179,   181,
     238,   168,   181,   184,   186,   263,   263,   174,    29,   250,
     225,   174,   269,   174,   174,    29,   174,   225,   269,   292,
     183,   277,   280,   183,    18,    23,   180,   183,   274,   276,
     281,   282,   284,   285,   286,   294,   269,   174,   251,     1,
     181,   291,   252,   252,   174,   225,   269,   181,   273,   273,
     273,   273,   273,   273,   273,   273,   273,   273,   184,   184,
     184,   184,   183,   184,   179,   179,   181,   250,   224,    25,
     181,   181,   181,   179,   181,   184,   278,    19,    21,   287,
     288,   289,   182,   180,   184,   279,   281,   180,     1,   180,
     181,   181,   181,   181,   181,   179,   181,   179,   181,   278,
     250,   224,   179,   181,   181,   171,    29,   174,   225,   269,
     184,   277,   174,   225,   184,    22,   289,   290,   263,     1,
     184,   281,   276,   171,   174,   184,   179,   181,   181,   224,
     204,   205,   195,   195,   195,   181,   181,   181,   224,   179,
     181,   202,   171,   279,   279,   279,   276,   179,   181,   174,
     171,   202,    19,   174,   181,   203,   171,   276,   181,   171,
     203,   168,   171,    25,   168,   171,    25,   204,   171,   204
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int16 yyr1[] =
{
       0,   207,   208,   209,   209,   209,   210,   210,   211,   210,
     212,   210,   213,   210,   214,   210,   215,   210,   216,   210,
     217,   210,   218,   210,   219,   210,   210,   220,   220,   220,
     221,   221,   222,   222,   222,   223,   224,   224,   225,   225,
     225,   226,   226,   226,   226,   227,   227,   228,   228,   228,
     228,   228,   229,   229,   230,   230,   230,   231,   231,   231,
     231,   231,   231,   231,   232,   232,   233,   233,   234,   233,
     235,   233,   236,   236,   237,   237,   238,   238,   238,   238,
     238,   238,   238,   238,   238,   238,   238,   238,   239,   239,
     239,   240,   240,   240,   241,   241,   242,   242,   242,   243,
     243,   243,   243,   244,   244,   244,   244,   244,   244,   244,
     244,   244,   244,   244,   244,   244,   244,   244,   244,   244,
     244,   244,   244,   244,   244,   244,   244,   244,   244,   244,
     244,   244,   244,   244,   244,   244,   244,   244,   244,   244,
     244,   244,   244,   244,   244,   244,   244,   244,   244,   244,
     244,   244,   244,   244,   244,   244,   244,   244,   244,   244,
     244,   244,   244,   244,   244,   244,   244,   244,   244,   244,
     244,   244,   244,   244,   244,   244,   244,   244,   244,   244,
     244,   244,   244,   244,   244,   244,   244,   244,   244,   244,
     244,   244,   244,   244,   244,   244,   244,   244,   244,   244,
     244,   244,   244,   244,   244,   244,   244,   244,   244,   244,
     244,   244,   244,   244,   244,   244,   244,   244,   244,   244,
     244,   244,   244,   244,   244,   244,   244,   244,   244,   244,
     244,   244,   244,   244,   244,   244,   244,   244,   244,   244,
     244,   244,   244,   244,   244,   244,   244,   244,   244,   244,
     244,   244,   244,   244,   244,   244,   244,   244,   244,   244,
     244,   244,   244,   244,   244,   244,   244,   244,   244,   244,
     244,   244,   244,   244,   244,   244,   244,   244,   244,   244,
     244,   244,   244,   244,   244,   244,   244,   244,   244,   244,
     244,   244,   244,   244,   244,   244,   244,   244,   244,   244,
     244,   244,   244,   244,   244,   244,   244,   244,   245,   245,
     245,   245,   245,   245,   246,   246,   247,   248,   249,   249,
     250,   250,   251,   251,   252,   252,   252,   253,   253,   254,
     254,   254,   255,   255,   256,   256,   256,   257,   257,   258,
     258,   259,   259,   260,   260,   261,   261,   262,   262,   263,
     263,   263,   263,   263,   263,   264,   264,   265,   265,   265,
     265,   266,   266,   267,   267,   268,   268,   268,   269,   269,
     270,   270,   270,   270,   271,   271,   271,   271,   271,   272,
     272,   272,   272,   272,   272,   272,   272,   272,   272,   273,
     273,   273,   273,   273,   273,   273,   273,   273,   273,   273,
     273,   273,   273,   273,   273,   273,   274,   274,   274,   275,
     275,   275,   275,   275,   276,   276,   276,   277,   277,   277,
     278,   278,   278,   279,   279,   279,   280,   280,   280,   280,
     280,   280,   280,   280,   281,   281,   281,   281,   281,   281,
     281,   281,   281,   282,   282,   283,   283,   284,   285,   286,
     287,   287,   288,   288,   289,   289,   289,   289,   290,   290,
     291,   291,   291,   291,   291,   291,   291,   291,   291,   291,
     291,   292,   292,   292,   292,   292,   292,   292,   292,   293,
     293,   293,   293,   294,   294,   294,   294,   294,   294,   294,
     294,   294,   294,   294,   294,   294,   294,   294,   294,   294,
     294,   294,   294,   294,   294,   294,   294,   294,   294,   294,
     294,   294,   294,   294,   294,   294,   294,   294,   294,   294
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     2,     1,     2,     1,     1,     0,     2,
       0,     2,     0,     2,     0,     2,     0,     2,     0,     2,
       0,     2,     0,     2,     0,     2,     1,     1,     1,     1,
       1,     1,     1,     3,     3,     1,     1,     1,     1,     2,
       2,     3,     5,     5,     2,     3,     5,     1,     3,     5,
       5,     1,     1,     2,     1,     3,     3,     1,     1,     1,
       2,     2,     2,     2,     1,     2,     1,     1,     0,     3,
       0,     3,     1,     1,     1,     2,     9,    10,     7,     8,
       5,     6,     5,     6,     3,     4,     1,     2,     4,     3,
       0,     1,     1,     1,     3,     1,     3,     1,     2,    18,
      17,    10,     9,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     2,     3,     2,
       3,     2,     3,     2,     3,     2,     3,     2,     3,     3,
       3,     3,     3,     5,     3,     3,     5,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     5,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     5,     5,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     2,
       3,     2,     6,     4,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     2,     2,     2,
       8,     8,     8,     2,     1,     1,     1,     1,     1,     3,
       1,     1,     2,     2,     1,     1,     1,     1,     1,     4,
       7,     2,     7,     2,     4,     7,     2,     7,     2,     4,
       2,     4,     2,     4,     2,     9,     2,     7,     2,     3,
       3,     2,     3,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     3,     3,     3,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     2,     3,     3,     3,     3,     1,
       1,     1,     3,     2,     1,     3,     2,     1,     3,     2,
       2,     1,     2,     2,     1,     2,     2,     1,     1,     1,
       1,     2,     1,     2,     2,     2,     1,     1,     1,     1,
       2,     1,     2,     5,     7,     5,     7,     5,     7,     7,
       2,     1,     2,     1,     4,     3,     4,     3,     3,     2,
       1,     3,     1,     2,     2,     1,     2,     3,     1,     2,
       3,     1,     1,     1,     1,     3,     3,     3,     3,     3,
       4,     4,     2,     6,     1,     3,     1,     3,     2,     4,
       2,     4,     3,     1,     4,     6,     2,     4,     6,     2,
       4,     4,     6,     2,     4,     3,     4,     4,     2,     4,
       4,     4,     4,     6,     6,     6,     8,     8,     6,     4
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 3: /* statements: statements statement  */
#line 503 "cfg.y"
                                     {}
#line 2502 "cfg.tab.c"
    break;

  case 4: /* statements: statement  */
#line 504 "cfg.y"
                            {}
#line 2508 "cfg.tab.c"
    break;

  case 5: /* statements: statements error  */
#line 505 "cfg.y"
                                   { yyerror(""); YYABORT;}
#line 2514 "cfg.tab.c"
    break;

  case 8: /* $@1: %empty  */
#line 510 "cfg.y"
                  {rt=REQUEST_ROUTE;}
#line 2520 "cfg.tab.c"
    break;

  case 10: /* $@2: %empty  */
#line 511 "cfg.y"
                  {rt=FAILURE_ROUTE;}
#line 2526 "cfg.tab.c"
    break;

  case 12: /* $@3: %empty  */
#line 512 "cfg.y"
                  {rt=ONREPLY_ROUTE;}
#line 2532 "cfg.tab.c"
    break;

  case 14: /* $@4: %empty  */
#line 513 "cfg.y"
                  {rt=BRANCH_ROUTE;}
#line 2538 "cfg.tab.c"
    break;

  case 16: /* $@5: %empty  */
#line 514 "cfg.y"
                  {rt=ERROR_ROUTE;}
#line 2544 "cfg.tab.c"
    break;

  case 18: /* $@6: %empty  */
#line 515 "cfg.y"
                  {rt=LOCAL_ROUTE;}
#line 2550 "cfg.tab.c"
    break;

  case 20: /* $@7: %empty  */
#line 516 "cfg.y"
                  {rt=STARTUP_ROUTE;}
#line 2556 "cfg.tab.c"
    break;

  case 22: /* $@8: %empty  */
#line 517 "cfg.y"
                  {rt=TIMER_ROUTE;}
#line 2562 "cfg.tab.c"
    break;

  case 24: /* $@9: %empty  */
#line 518 "cfg.y"
                  {rt=EVENT_ROUTE;}
#line 2568 "cfg.tab.c"
    break;

  case 27: /* listen_id: ip  */
#line 523 "cfg.y"
                                        { IFOR();
							tmp=ip_addr2a((yyvsp[0].ipaddr));
							if(tmp==0){
								LM_CRIT("cfg. parser: bad ip address.\n");
								(yyval.strval)=0;
							}else{
								(yyval.strval)=pkg_malloc(strlen(tmp)+1);
								if ((yyval.strval)==0){
									LM_CRIT("cfg. parser: out of memory.\n");
									YYABORT;
								}else{
									memcpy((yyval.strval), tmp, strlen(tmp)+1);
								}
							}
						}
#line 2588 "cfg.tab.c"
    break;

  case 28: /* listen_id: STRING  */
#line 538 "cfg.y"
                                        { IFOR();
							(yyval.strval)=pkg_malloc(strlen((yyvsp[0].strval))+1);
							if ((yyval.strval)==0){
									LM_CRIT("cfg. parser: out of memory.\n");
									YYABORT;
							}else{
									memcpy((yyval.strval), (yyvsp[0].strval), strlen((yyvsp[0].strval))+1);
							}
						}
#line 2602 "cfg.tab.c"
    break;

  case 29: /* listen_id: host  */
#line 547 "cfg.y"
                                        { IFOR();
							if ((yyvsp[0].strval)==0) {
								(yyval.strval) = 0;
							} else {
								(yyval.strval)=pkg_malloc(strlen((yyvsp[0].strval))+1);
								if ((yyval.strval)==0){
									LM_CRIT("cfg. parser: out of memory.\n");
									YYABORT;
								}else{
									memcpy((yyval.strval), (yyvsp[0].strval), strlen((yyvsp[0].strval))+1);
								}
							}
						}
#line 2620 "cfg.tab.c"
    break;

  case 30: /* host_sep: DOT  */
#line 562 "cfg.y"
                    {(yyval.strval)=".";}
#line 2626 "cfg.tab.c"
    break;

  case 31: /* host_sep: MINUS  */
#line 563 "cfg.y"
                              {(yyval.strval)="-"; }
#line 2632 "cfg.tab.c"
    break;

  case 32: /* host: ID  */
#line 566 "cfg.y"
                                        { (yyval.strval)=(yyvsp[0].strval); }
#line 2638 "cfg.tab.c"
    break;

  case 33: /* host: host host_sep ID  */
#line 567 "cfg.y"
                                { IFOR();
						(yyval.strval)=(char*)pkg_malloc(strlen((yyvsp[-2].strval))+1+strlen((yyvsp[0].strval))+1);
						if ((yyval.strval)==0){
							LM_CRIT("cfg. parser: memory allocation"
										" failure while parsing host\n");
							YYABORT;
						}else{
							memcpy((yyval.strval), (yyvsp[-2].strval), strlen((yyvsp[-2].strval)));
							(yyval.strval)[strlen((yyvsp[-2].strval))]=*(yyvsp[-1].strval);
							memcpy((yyval.strval)+strlen((yyvsp[-2].strval))+1, (yyvsp[0].strval), strlen((yyvsp[0].strval)));
							(yyval.strval)[strlen((yyvsp[-2].strval))+1+strlen((yyvsp[0].strval))]=0;
						}
						pkg_free((yyvsp[-2].strval)); pkg_free((yyvsp[0].strval));
					}
#line 2657 "cfg.tab.c"
    break;

  case 34: /* host: host DOT error  */
#line 581 "cfg.y"
                         { (yyval.strval)=0; pkg_free((yyvsp[-2].strval));
					yyerror("invalid hostname (use quotes if hostname "
						"has config keywords)"); }
#line 2665 "cfg.tab.c"
    break;

  case 35: /* proto: ID  */
#line 586 "cfg.y"
           { IFOR();
		if (parse_proto((unsigned char *)(yyvsp[0].strval), strlen((yyvsp[0].strval)), &i_tmp) < 0) {
			yyerrorf("cannot handle protocol <%s>\n", (yyvsp[0].strval));
			YYABORT;
		}
		pkg_free((yyvsp[0].strval));
		(yyval.intval) = i_tmp;
	 }
#line 2678 "cfg.tab.c"
    break;

  case 36: /* port: NUMBER  */
#line 596 "cfg.y"
                        { (yyval.intval)=(yyvsp[0].intval); }
#line 2684 "cfg.tab.c"
    break;

  case 37: /* port: ANY  */
#line 597 "cfg.y"
                                { (yyval.intval)=0; }
#line 2690 "cfg.tab.c"
    break;

  case 38: /* snumber: NUMBER  */
#line 600 "cfg.y"
                        { (yyval.intval)=(yyvsp[0].intval); }
#line 2696 "cfg.tab.c"
    break;

  case 39: /* snumber: PLUS NUMBER  */
#line 601 "cfg.y"
                                { (yyval.intval)=(yyvsp[0].intval); }
#line 2702 "cfg.tab.c"
    break;

  case 40: /* snumber: MINUS NUMBER  */
#line 602 "cfg.y"
                                { (yyval.intval)=-(yyvsp[0].intval); }
#line 2708 "cfg.tab.c"
    break;

  case 41: /* phostport: proto COLON listen_id  */
#line 606 "cfg.y"
                                        { IFOR();
				(yyval.sockid)=mk_listen_id((yyvsp[0].strval), (yyvsp[-2].intval), 0); }
#line 2715 "cfg.tab.c"
    break;

  case 42: /* phostport: proto COLON listen_id COLON port  */
#line 608 "cfg.y"
                                                                { IFOR();
				(yyval.sockid)=mk_listen_id((yyvsp[-2].strval), (yyvsp[-4].intval), (yyvsp[0].intval));}
#line 2722 "cfg.tab.c"
    break;

  case 43: /* phostport: proto COLON listen_id COLON error  */
#line 610 "cfg.y"
                                                            {
				(yyval.sockid)=0;
				yyerror("port number expected");
				YYABORT;
				}
#line 2732 "cfg.tab.c"
    break;

  case 44: /* phostport: NUMBER error  */
#line 615 "cfg.y"
                                       { (yyval.sockid)=0;
				yyerror("protocol expected");
				YYABORT;
			}
#line 2741 "cfg.tab.c"
    break;

  case 45: /* panyhostport: proto COLON MULT  */
#line 621 "cfg.y"
                                                        { IFOR();
				(yyval.sockid)=mk_listen_id(0, (yyvsp[-2].intval), 0); }
#line 2748 "cfg.tab.c"
    break;

  case 46: /* panyhostport: proto COLON MULT COLON port  */
#line 623 "cfg.y"
                                                        { IFOR();
				(yyval.sockid)=mk_listen_id(0, (yyvsp[-4].intval), (yyvsp[0].intval)); }
#line 2755 "cfg.tab.c"
    break;

  case 47: /* alias_def: listen_id  */
#line 627 "cfg.y"
                                                                        { IFOR();
				(yyval.sockid)=mk_listen_id((yyvsp[0].strval), PROTO_NONE, 0); }
#line 2762 "cfg.tab.c"
    break;

  case 48: /* alias_def: ANY COLON listen_id  */
#line 629 "cfg.y"
                                                                        { IFOR();
		 		(yyval.sockid)=mk_listen_id((yyvsp[0].strval), PROTO_NONE, 0); }
#line 2769 "cfg.tab.c"
    break;

  case 49: /* alias_def: ANY COLON listen_id COLON port  */
#line 631 "cfg.y"
                                                        { IFOR();
		 		(yyval.sockid)=mk_listen_id((yyvsp[-2].strval), PROTO_NONE, (yyvsp[0].intval)); }
#line 2776 "cfg.tab.c"
    break;

  case 50: /* alias_def: ANY COLON listen_id COLON error  */
#line 633 "cfg.y"
                                                        {
				(yyval.sockid)=0;
				yyerror(" port number expected");
				}
#line 2785 "cfg.tab.c"
    break;

  case 52: /* id_lst: alias_def  */
#line 640 "cfg.y"
                                        { IFOR();  (yyval.sockid)=(yyvsp[0].sockid) ; }
#line 2791 "cfg.tab.c"
    break;

  case 53: /* id_lst: alias_def id_lst  */
#line 641 "cfg.y"
                                        { IFOR(); (yyval.sockid)=(yyvsp[-1].sockid); (yyval.sockid)->next=(yyvsp[0].sockid); }
#line 2797 "cfg.tab.c"
    break;

  case 54: /* listen_id_def: listen_id  */
#line 644 "cfg.y"
                                                                { IFOR();
					(yyval.sockid)=mk_listen_id((yyvsp[0].strval), PROTO_NONE, 0); }
#line 2804 "cfg.tab.c"
    break;

  case 55: /* listen_id_def: listen_id COLON port  */
#line 646 "cfg.y"
                                                                { IFOR();
			 		(yyval.sockid)=mk_listen_id((yyvsp[-2].strval), PROTO_NONE, (yyvsp[0].intval)); }
#line 2811 "cfg.tab.c"
    break;

  case 56: /* listen_id_def: listen_id COLON error  */
#line 648 "cfg.y"
                                                      {
					(yyval.sockid)=0;
					yyerror(" port number expected");
					}
#line 2820 "cfg.tab.c"
    break;

  case 57: /* socket_def_param: ANYCAST  */
#line 654 "cfg.y"
                          { IFOR();
					p_tmp.flags |= SI_IS_ANYCAST;
					}
#line 2828 "cfg.tab.c"
    break;

  case 58: /* socket_def_param: FRAG  */
#line 657 "cfg.y"
                                       { IFOR();
					p_tmp.flags |= SI_FRAG;
					}
#line 2836 "cfg.tab.c"
    break;

  case 59: /* socket_def_param: REUSE_PORT  */
#line 660 "cfg.y"
                                             { IFOR();
					p_tmp.flags |= SI_REUSEPORT;
					}
#line 2844 "cfg.tab.c"
    break;

  case 60: /* socket_def_param: USE_WORKERS NUMBER  */
#line 663 "cfg.y"
                                                     { IFOR();
					p_tmp.workers=(yyvsp[0].intval);
					}
#line 2852 "cfg.tab.c"
    break;

  case 61: /* socket_def_param: AS listen_id_def  */
#line 666 "cfg.y"
                                                   { IFOR();
					p_tmp.socket = (yyvsp[0].sockid);
					}
#line 2860 "cfg.tab.c"
    break;

  case 62: /* socket_def_param: TAG ID  */
#line 669 "cfg.y"
                                         { IFOR();
					p_tmp.tag = (yyvsp[0].strval);
					}
#line 2868 "cfg.tab.c"
    break;

  case 63: /* socket_def_param: USE_AUTO_SCALING_PROFILE ID  */
#line 672 "cfg.y"
                                                              { IFOR();
					p_tmp.auto_scaling_profile=(yyvsp[0].strval);
					}
#line 2876 "cfg.tab.c"
    break;

  case 66: /* socket_def: panyhostport  */
#line 681 "cfg.y"
                                                { (yyval.sockid)=(yyvsp[0].sockid); }
#line 2882 "cfg.tab.c"
    break;

  case 67: /* socket_def: phostport  */
#line 682 "cfg.y"
                                                                { (yyval.sockid)=(yyvsp[0].sockid); }
#line 2888 "cfg.tab.c"
    break;

  case 68: /* $@10: %empty  */
#line 683 "cfg.y"
                                       { IFOR();
					memset(&p_tmp, 0, sizeof(p_tmp));
				}
#line 2896 "cfg.tab.c"
    break;

  case 69: /* socket_def: panyhostport $@10 socket_def_params  */
#line 685 "cfg.y"
                                                        { IFOR();
					(yyval.sockid)=(yyvsp[-2].sockid); fill_socket_id(&p_tmp, (yyval.sockid));
				}
#line 2904 "cfg.tab.c"
    break;

  case 70: /* $@11: %empty  */
#line 688 "cfg.y"
                                    { IFOR();
					memset(&p_tmp, 0, sizeof(p_tmp));
				}
#line 2912 "cfg.tab.c"
    break;

  case 71: /* socket_def: phostport $@11 socket_def_params  */
#line 690 "cfg.y"
                                                        { IFOR();
					(yyval.sockid)=(yyvsp[-2].sockid); fill_socket_id(&p_tmp, (yyval.sockid));
				}
#line 2920 "cfg.tab.c"
    break;

  case 72: /* any_proto: ANY  */
#line 695 "cfg.y"
                        { (yyval.intval)=PROTO_NONE; }
#line 2926 "cfg.tab.c"
    break;

  case 73: /* any_proto: proto  */
#line 696 "cfg.y"
                                { (yyval.intval)=(yyvsp[0].intval); }
#line 2932 "cfg.tab.c"
    break;

  case 74: /* multi_string: STRING  */
#line 698 "cfg.y"
                       {  IFOR(); (yyval.multistr)=new_string((yyvsp[0].strval)); }
#line 2938 "cfg.tab.c"
    break;

  case 75: /* multi_string: STRING multi_string  */
#line 699 "cfg.y"
                                      { IFOR(); (yyval.multistr)=new_string((yyvsp[-1].strval)); (yyval.multistr)->next=(yyvsp[0].multistr); }
#line 2944 "cfg.tab.c"
    break;

  case 76: /* blst_elem: LPAREN any_proto COMMA ipnet COMMA port COMMA STRING RPAREN  */
#line 702 "cfg.y"
                                                                       {
				IFOR(pkg_free((yyvsp[-5].ipnet)));
				s_tmp.s=(yyvsp[-1].strval);
				s_tmp.len=strlen((yyvsp[-1].strval));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[-5].ipnet),&s_tmp,(yyvsp[-3].intval),(yyvsp[-7].intval),0)) {
					yyerror("failed to add backlist element\n");YYABORT;
				}
			}
#line 2957 "cfg.tab.c"
    break;

  case 77: /* blst_elem: NOT LPAREN any_proto COMMA ipnet COMMA port COMMA STRING RPAREN  */
#line 710 "cfg.y"
                                                                                  {
				IFOR(pkg_free((yyvsp[-5].ipnet)));
				s_tmp.s=(yyvsp[-1].strval);
				s_tmp.len=strlen((yyvsp[-1].strval));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[-5].ipnet),&s_tmp,
				(yyvsp[-3].intval),(yyvsp[-7].intval),BLR_APPLY_CONTRARY)) {
					yyerror("failed to add backlist element\n");YYABORT;
				}
			}
#line 2971 "cfg.tab.c"
    break;

  case 78: /* blst_elem: LPAREN any_proto COMMA ipnet COMMA port RPAREN  */
#line 719 "cfg.y"
                                                                 {
				IFOR(pkg_free((yyvsp[-3].ipnet)));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[-3].ipnet),NULL,(yyvsp[-1].intval),(yyvsp[-5].intval),0)) {
					yyerror("failed to add backlist element\n");YYABORT;
				}
			}
#line 2982 "cfg.tab.c"
    break;

  case 79: /* blst_elem: NOT LPAREN any_proto COMMA ipnet COMMA port RPAREN  */
#line 725 "cfg.y"
                                                                     {
				IFOR(pkg_free((yyvsp[-3].ipnet)));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[-3].ipnet),NULL,
				(yyvsp[-1].intval),(yyvsp[-5].intval),BLR_APPLY_CONTRARY)) {
					yyerror("failed to add backlist element\n");YYABORT;
				}
			}
#line 2994 "cfg.tab.c"
    break;

  case 80: /* blst_elem: LPAREN any_proto COMMA ipnet RPAREN  */
#line 732 "cfg.y"
                                                      {
				IFOR(pkg_free((yyvsp[-1].ipnet)));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[-1].ipnet),NULL,0,(yyvsp[-3].intval),0)) {
					yyerror("failed to add backlist element\n");YYABORT;
				}
			}
#line 3005 "cfg.tab.c"
    break;

  case 81: /* blst_elem: NOT LPAREN any_proto COMMA ipnet RPAREN  */
#line 738 "cfg.y"
                                                          {
				IFOR(pkg_free((yyvsp[-1].ipnet)));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[-1].ipnet),NULL,
				0,(yyvsp[-3].intval),BLR_APPLY_CONTRARY)) {
					yyerror("failed to add backlist element\n");YYABORT;
				}
			}
#line 3017 "cfg.tab.c"
    break;

  case 82: /* blst_elem: LPAREN ipnet COMMA port RPAREN  */
#line 745 "cfg.y"
                                                 {
				IFOR(pkg_free((yyvsp[-3].ipnet)));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[-3].ipnet),NULL,(yyvsp[-1].intval),PROTO_NONE,0)) {
					yyerror("failed to add backlist element\n");YYABORT;
				}
			}
#line 3028 "cfg.tab.c"
    break;

  case 83: /* blst_elem: NOT LPAREN ipnet COMMA port RPAREN  */
#line 751 "cfg.y"
                                                     {
				IFOR(pkg_free((yyvsp[-3].ipnet)));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[-3].ipnet),NULL,
				(yyvsp[-1].intval),PROTO_NONE,BLR_APPLY_CONTRARY)) {
					yyerror("failed to add backlist element\n");YYABORT;
				}
			}
#line 3040 "cfg.tab.c"
    break;

  case 84: /* blst_elem: LPAREN ipnet RPAREN  */
#line 758 "cfg.y"
                                      {
				IFOR(pkg_free((yyvsp[-1].ipnet)));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[-1].ipnet),NULL,0,PROTO_NONE,0)) {
					yyerror("failed to add backlist element\n"); YYABORT;
				}
			}
#line 3051 "cfg.tab.c"
    break;

  case 85: /* blst_elem: NOT LPAREN ipnet RPAREN  */
#line 764 "cfg.y"
                                          {
				IFOR(pkg_free((yyvsp[-1].ipnet)));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[-1].ipnet),NULL,
				0,PROTO_NONE,BLR_APPLY_CONTRARY)) {
					yyerror("failed to add backlist element\n");YYABORT;
				}
			}
#line 3063 "cfg.tab.c"
    break;

  case 86: /* blst_elem: ipnet  */
#line 771 "cfg.y"
                        {
				IFOR(pkg_free((yyvsp[0].ipnet)));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[0].ipnet),NULL,0,PROTO_NONE,0)) {
					yyerror("failed to add backlist element\n"); YYABORT;
				}
			}
#line 3074 "cfg.tab.c"
    break;

  case 87: /* blst_elem: NOT ipnet  */
#line 777 "cfg.y"
                            {
				IFOR(pkg_free((yyvsp[0].ipnet)));
				if (add_rule_to_list(&bl_head,&bl_tail,(yyvsp[0].ipnet),NULL,
				0,PROTO_NONE,BLR_APPLY_CONTRARY)) {
					yyerror("failed to add backlist element\n");YYABORT;
				}
			}
#line 3086 "cfg.tab.c"
    break;

  case 91: /* blst_flag: READONLY  */
#line 791 "cfg.y"
                    { (yyval.intval) = BL_READONLY_LIST; }
#line 3092 "cfg.tab.c"
    break;

  case 92: /* blst_flag: EXPIRE  */
#line 792 "cfg.y"
                          { (yyval.intval) = BL_DO_EXPIRE; }
#line 3098 "cfg.tab.c"
    break;

  case 93: /* blst_flag: DEFAULT  */
#line 793 "cfg.y"
                           { (yyval.intval) = BL_BY_DEFAULT; }
#line 3104 "cfg.tab.c"
    break;

  case 94: /* blst_flags: blst_flags COMMA blst_flag  */
#line 796 "cfg.y"
                                       { (yyval.intval) = (yyvsp[-2].intval) | (yyvsp[0].intval); }
#line 3110 "cfg.tab.c"
    break;

  case 95: /* blst_flags: blst_flag  */
#line 797 "cfg.y"
                            {}
#line 3116 "cfg.tab.c"
    break;

  case 96: /* blst_elem_list: blst_elem_list COMMA blst_elem  */
#line 800 "cfg.y"
                                               {}
#line 3122 "cfg.tab.c"
    break;

  case 97: /* blst_elem_list: blst_elem  */
#line 801 "cfg.y"
                            {}
#line 3128 "cfg.tab.c"
    break;

  case 98: /* blst_elem_list: blst_elem_list error  */
#line 802 "cfg.y"
                                       { yyerror("bad black list element");}
#line 3134 "cfg.tab.c"
    break;

  case 99: /* auto_scale_profile_def: ID SCALE_UP_TO NUMBER ON NUMBER MODULO FOR NUMBER CYCLES_WITHIN NUMBER SCALE_DOWN_TO NUMBER ON NUMBER MODULO FOR NUMBER CYCLES  */
#line 809 "cfg.y"
                                              { IFOR();
			if (create_auto_scaling_profile((yyvsp[-17].strval),(yyvsp[-15].intval),(yyvsp[-13].intval),(yyvsp[-10].intval),(yyvsp[-8].intval),
			(yyvsp[-6].intval), (yyvsp[-4].intval), (yyvsp[-1].intval),10*(yyvsp[-1].intval))<0)
				yyerror("failed to create auto scaling profile");
		 }
#line 3144 "cfg.tab.c"
    break;

  case 100: /* auto_scale_profile_def: ID SCALE_UP_TO NUMBER ON NUMBER MODULO FOR NUMBER CYCLES SCALE_DOWN_TO NUMBER ON NUMBER MODULO FOR NUMBER CYCLES  */
#line 817 "cfg.y"
                                              { IFOR();
			if (create_auto_scaling_profile((yyvsp[-16].strval),(yyvsp[-14].intval),(yyvsp[-12].intval),(yyvsp[-9].intval),(yyvsp[-9].intval),
			(yyvsp[-6].intval), (yyvsp[-4].intval), (yyvsp[-1].intval), 10*(yyvsp[-1].intval))<0)
				yyerror("failed to create auto scaling profile");
		 }
#line 3154 "cfg.tab.c"
    break;

  case 101: /* auto_scale_profile_def: ID SCALE_UP_TO NUMBER ON NUMBER MODULO FOR NUMBER CYCLES_WITHIN NUMBER  */
#line 823 "cfg.y"
                                                            { IFOR();
			if (create_auto_scaling_profile((yyvsp[-9].strval),(yyvsp[-7].intval),(yyvsp[-5].intval),(yyvsp[-2].intval),(yyvsp[0].intval),
			0, 0, 0, 0)<0)
				yyerror("failed to create auto scaling profile");
		}
#line 3164 "cfg.tab.c"
    break;

  case 102: /* auto_scale_profile_def: ID SCALE_UP_TO NUMBER ON NUMBER MODULO FOR NUMBER CYCLES  */
#line 829 "cfg.y"
                                              { IFOR();
			if (create_auto_scaling_profile((yyvsp[-8].strval),(yyvsp[-6].intval),(yyvsp[-4].intval),(yyvsp[-1].intval),(yyvsp[-1].intval),
			0, 0, 0, 0)<0)
				yyerror("failed to create auto scaling profile");
		}
#line 3174 "cfg.tab.c"
    break;

  case 103: /* assign_stm: LOGLEVEL EQUAL snumber  */
#line 836 "cfg.y"
                                   { IFOR();
			/* in debug mode, force logging to DEBUG level*/
			*log_level = debug_mode?L_DBG:(yyvsp[0].intval);
			}
#line 3183 "cfg.tab.c"
    break;

  case 104: /* assign_stm: LOGPREFIX EQUAL STRING  */
#line 840 "cfg.y"
                                         { IFOR();
			if (*(yyvsp[0].strval)) {
				int len = strlen((yyvsp[0].strval));
				char *buf = pkg_malloc(len + 2);
				if (!buf)
					yyerror("oom");
				sprintf(buf, "%s:", (yyvsp[0].strval));
				log_prefix = buf;
			} else {
				log_prefix = (yyvsp[0].strval);
			}
			}
#line 3200 "cfg.tab.c"
    break;

  case 105: /* assign_stm: LOGPREFIX EQUAL error  */
#line 852 "cfg.y"
                                         { yyerror("string value expected"); }
#line 3206 "cfg.tab.c"
    break;

  case 106: /* assign_stm: ENABLE_ASSERTS EQUAL NUMBER  */
#line 853 "cfg.y"
                                               { IFOR(); enable_asserts=(yyvsp[0].intval); }
#line 3212 "cfg.tab.c"
    break;

  case 107: /* assign_stm: ENABLE_ASSERTS EQUAL error  */
#line 854 "cfg.y"
                                              { yyerror("boolean value expected"); }
#line 3218 "cfg.tab.c"
    break;

  case 108: /* assign_stm: ABORT_ON_ASSERT EQUAL NUMBER  */
#line 855 "cfg.y"
                                                { IFOR(); abort_on_assert=(yyvsp[0].intval); }
#line 3224 "cfg.tab.c"
    break;

  case 109: /* assign_stm: ABORT_ON_ASSERT EQUAL error  */
#line 856 "cfg.y"
                                               { yyerror("boolean value expected"); }
#line 3230 "cfg.tab.c"
    break;

  case 110: /* assign_stm: DEBUG_MODE EQUAL NUMBER  */
#line 857 "cfg.y"
                                           { IFOR();
			debug_mode=(yyvsp[0].intval);
			if (debug_mode) {
				*log_level = L_DBG;
				stderr_enabled=1;
				syslog_enabled=0;

				s_tmp.s=STDERR_CONSUMER_NAME;
				s_tmp.len=strlen(STDERR_CONSUMER_NAME);
				set_log_consumer_mute_state(&s_tmp, 0);
				s_tmp.s=SYSLOG_CONSUMER_NAME;
				s_tmp.len=strlen(SYSLOG_CONSUMER_NAME);
				set_log_consumer_mute_state(&s_tmp, 1);
			}
			}
#line 3250 "cfg.tab.c"
    break;

  case 111: /* assign_stm: DEBUG_MODE EQUAL error  */
#line 873 "cfg.y"
                        { yyerror("boolean value expected for debug_mode"); }
#line 3256 "cfg.tab.c"
    break;

  case 112: /* assign_stm: LOGSTDOUT EQUAL NUMBER  */
#line 876 "cfg.y"
                        { IFOR(); log_stdout=(yyvsp[0].intval); }
#line 3262 "cfg.tab.c"
    break;

  case 113: /* assign_stm: LOGSTDOUT EQUAL error  */
#line 877 "cfg.y"
                                        { yyerror("boolean value expected"); }
#line 3268 "cfg.tab.c"
    break;

  case 114: /* assign_stm: LOGSTDERROR EQUAL NUMBER  */
#line 878 "cfg.y"
                                           {
			IFOR();
			warn("'log_stderror' is deprecated, use 'stderror_enabled' and/or"
				"'syslog_enabled' instead");
			if (!config_check && !debug_mode) {
				if ((yyvsp[0].intval)) {
					stderr_enabled=1;
					syslog_enabled=0;
				} else {
					stderr_enabled=0;
					syslog_enabled=1;
				}

				s_tmp.s=STDERR_CONSUMER_NAME;
				s_tmp.len=strlen(STDERR_CONSUMER_NAME);
				set_log_consumer_mute_state(&s_tmp, !(yyvsp[0].intval));
				s_tmp.s=SYSLOG_CONSUMER_NAME;
				s_tmp.len=strlen(SYSLOG_CONSUMER_NAME);
				set_log_consumer_mute_state(&s_tmp, (yyvsp[0].intval));
			}
			}
#line 3294 "cfg.tab.c"
    break;

  case 115: /* assign_stm: LOGSTDERROR EQUAL error  */
#line 899 "cfg.y"
                                          { yyerror("boolean value expected"); }
#line 3300 "cfg.tab.c"
    break;

  case 116: /* assign_stm: STDERROR_ENABLED EQUAL NUMBER  */
#line 900 "cfg.y"
                                                {
			/* in config-check or debug mode we force logging
			 * to standard error */
			IFOR();
			if (!config_check && !debug_mode) {
				stderr_enabled=(yyvsp[0].intval);
				s_tmp.s=STDERR_CONSUMER_NAME;
				s_tmp.len=strlen(STDERR_CONSUMER_NAME);
				set_log_consumer_mute_state(&s_tmp, !(yyvsp[0].intval));
			}
			}
#line 3316 "cfg.tab.c"
    break;

  case 117: /* assign_stm: STDERROR_ENABLED EQUAL error  */
#line 911 "cfg.y"
                                               { yyerror("boolean value expected"); }
#line 3322 "cfg.tab.c"
    break;

  case 118: /* assign_stm: SYSLOG_ENABLED EQUAL NUMBER  */
#line 912 "cfg.y"
                                              {
			IFOR();
			/* in config-check or debug mode we force logging
			 * to standard error */
			if (!config_check && !debug_mode) {
				syslog_enabled=(yyvsp[0].intval);
				s_tmp.s=SYSLOG_CONSUMER_NAME;
				s_tmp.len=strlen(SYSLOG_CONSUMER_NAME);
				set_log_consumer_mute_state(&s_tmp, !(yyvsp[0].intval));
			}
			}
#line 3338 "cfg.tab.c"
    break;

  case 119: /* assign_stm: SYSLOG_ENABLED EQUAL error  */
#line 923 "cfg.y"
                                             { yyerror("boolean value expected"); }
#line 3344 "cfg.tab.c"
    break;

  case 120: /* assign_stm: LOG_EVENT_ENABLED EQUAL NUMBER  */
#line 924 "cfg.y"
                                                 {
			IFOR();
			if ((yyvsp[0].intval)) {
				if (init_log_msg_buf(0) < 0) {
					yyerror("failed to allocate msg log buffer");
					YYABORT;
				}
			}
			log_event_enabled=(yyvsp[0].intval); }
#line 3358 "cfg.tab.c"
    break;

  case 121: /* assign_stm: LOG_EVENT_ENABLED EQUAL error  */
#line 933 "cfg.y"
                                                { yyerror("boolean value expected"); }
#line 3364 "cfg.tab.c"
    break;

  case 122: /* assign_stm: STDERROR_LEVEL_FILTER EQUAL snumber  */
#line 934 "cfg.y"
                                                      {
			IFOR();
			s_tmp.s=STDERR_CONSUMER_NAME;
			s_tmp.len=strlen(STDERR_CONSUMER_NAME);
			set_log_consumer_level_filter(&s_tmp, (yyvsp[0].intval));
			}
#line 3375 "cfg.tab.c"
    break;

  case 123: /* assign_stm: STDERROR_LEVEL_FILTER EQUAL error  */
#line 940 "cfg.y"
                                                    { yyerror("number expected"); }
#line 3381 "cfg.tab.c"
    break;

  case 124: /* assign_stm: SYSLOG_LEVEL_FILTER EQUAL snumber  */
#line 941 "cfg.y"
                                                    {
			IFOR();
			s_tmp.s=SYSLOG_CONSUMER_NAME;
			s_tmp.len=strlen(SYSLOG_CONSUMER_NAME);
			set_log_consumer_level_filter(&s_tmp, (yyvsp[0].intval));
			}
#line 3392 "cfg.tab.c"
    break;

  case 125: /* assign_stm: SYSLOG_LEVEL_FILTER EQUAL error  */
#line 947 "cfg.y"
                                                  { yyerror("number expected"); }
#line 3398 "cfg.tab.c"
    break;

  case 126: /* assign_stm: LOG_EVENT_LEVEL_FILTER EQUAL NUMBER  */
#line 948 "cfg.y"
                                                      { IFOR();
							log_event_level_filter = (yyvsp[0].intval); }
#line 3405 "cfg.tab.c"
    break;

  case 127: /* assign_stm: LOG_EVENT_LEVEL_FILTER EQUAL error  */
#line 950 "cfg.y"
                                                     { yyerror("number expected"); }
#line 3411 "cfg.tab.c"
    break;

  case 128: /* assign_stm: STDERROR_FORMAT EQUAL STRING  */
#line 951 "cfg.y"
                                               { IFOR();
			s_tmp.s = (yyvsp[0].strval);
			s_tmp.len = strlen((yyvsp[0].strval));
			if ((i_tmp = parse_log_format(&s_tmp)) < 0) {
				yyerror("unknown log format");
			} else {
				if (i_tmp != LOG_FORMAT_PLAIN) {
					if (init_log_json_buf(0) < 0) {
						yyerror("failed to allocate json log buffer");
						YYABORT;
					}
					if (init_log_msg_buf(0) < 0) {
						yyerror("failed to allocate msg log buffer");
						YYABORT;
					}

					if (i_tmp == LOG_FORMAT_JSON_CEE && init_log_cee_hostname() < 0) {
						yyerror("failed to allocate hostname buffer");
						YYABORT;
					}
				}

				stderr_log_format = i_tmp;
			}
			}
#line 3441 "cfg.tab.c"
    break;

  case 129: /* assign_stm: SYSLOG_FORMAT EQUAL STRING  */
#line 976 "cfg.y"
                                             { IFOR();
			s_tmp.s = (yyvsp[0].strval);
			s_tmp.len = strlen((yyvsp[0].strval));
			if ((i_tmp = parse_log_format(&s_tmp)) < 0) {
				yyerror("unknown log format");
			} else {
				if (i_tmp != LOG_FORMAT_PLAIN) {
					if (init_log_json_buf(0) < 0) {
						yyerror("failed to allocate json log buffer");
						YYABORT;
					}
					if (init_log_msg_buf(0) < 0) {
						yyerror("failed to allocate msg log buffer");
						YYABORT;
					}

					if (i_tmp == LOG_FORMAT_JSON_CEE && init_log_cee_hostname() < 0) {
						yyerror("failed to allocate hostname buffer");
						YYABORT;
					}
				}

				syslog_log_format = i_tmp;
			}
			}
#line 3471 "cfg.tab.c"
    break;

  case 130: /* assign_stm: LOG_JSON_BUF_SIZE EQUAL NUMBER  */
#line 1001 "cfg.y"
                                                 {
			IFOR();
			log_json_buf_size = (yyvsp[0].intval);
			if (init_log_json_buf(1) < 0) {
				yyerror("failed to realloc json log buffer");
				YYABORT;
			}
			}
#line 3484 "cfg.tab.c"
    break;

  case 131: /* assign_stm: LOG_JSON_BUF_SIZE EQUAL error  */
#line 1009 "cfg.y"
                                                { yyerror("number expected"); }
#line 3490 "cfg.tab.c"
    break;

  case 132: /* assign_stm: LOG_MSG_BUF_SIZE EQUAL NUMBER  */
#line 1010 "cfg.y"
                                                {
			IFOR();
			log_msg_buf_size = (yyvsp[0].intval);
			if (init_log_msg_buf(1) < 0) {
				yyerror("failed to realloc msg log buffer");
				YYABORT;
			}
			}
#line 3503 "cfg.tab.c"
    break;

  case 133: /* assign_stm: LOG_MSG_BUF_SIZE EQUAL error  */
#line 1018 "cfg.y"
                                               { yyerror("number expected"); }
#line 3509 "cfg.tab.c"
    break;

  case 134: /* assign_stm: LOGFACILITY EQUAL ID  */
#line 1019 "cfg.y"
                                       { IFOR();
			warn("'log_facility' is deprecated, use 'syslog_facility' instead");
			if ( (i_tmp=str2facility((yyvsp[0].strval)))==-1)
				yyerror("bad facility (see syslog(3) man page)");
			if (!config_check)
				log_facility=i_tmp;
			}
#line 3521 "cfg.tab.c"
    break;

  case 135: /* assign_stm: LOGFACILITY EQUAL error  */
#line 1026 "cfg.y"
                                          { yyerror("ID expected"); }
#line 3527 "cfg.tab.c"
    break;

  case 136: /* assign_stm: SYSLOG_FACILITY EQUAL ID  */
#line 1027 "cfg.y"
                                           { IFOR();
			if ( (i_tmp=str2facility((yyvsp[0].strval)))==-1)
				yyerror("bad facility (see syslog(3) man page)");
			if (!config_check)
				log_facility=i_tmp;
			}
#line 3538 "cfg.tab.c"
    break;

  case 137: /* assign_stm: SYSLOG_FACILITY EQUAL error  */
#line 1033 "cfg.y"
                                              { yyerror("ID expected"); }
#line 3544 "cfg.tab.c"
    break;

  case 138: /* assign_stm: LOGNAME EQUAL STRING  */
#line 1034 "cfg.y"
                                       { IFOR();
			warn("'log_name' is deprecated, use 'syslog_name' instead");
			log_name=(yyvsp[0].strval); }
#line 3552 "cfg.tab.c"
    break;

  case 139: /* assign_stm: LOGNAME EQUAL error  */
#line 1037 "cfg.y"
                                      { yyerror("string value expected"); }
#line 3558 "cfg.tab.c"
    break;

  case 140: /* assign_stm: SYSLOG_NAME EQUAL STRING  */
#line 1038 "cfg.y"
                                           { IFOR(); log_name=(yyvsp[0].strval); }
#line 3564 "cfg.tab.c"
    break;

  case 141: /* assign_stm: SYSLOG_NAME EQUAL error  */
#line 1039 "cfg.y"
                                          { yyerror("string value expected"); }
#line 3570 "cfg.tab.c"
    break;

  case 142: /* assign_stm: DNS EQUAL NUMBER  */
#line 1040 "cfg.y"
                                     { IFOR(); received_dns|= ((yyvsp[0].intval))?DO_DNS:0; }
#line 3576 "cfg.tab.c"
    break;

  case 143: /* assign_stm: DNS EQUAL error  */
#line 1041 "cfg.y"
                                  { yyerror("boolean value expected"); }
#line 3582 "cfg.tab.c"
    break;

  case 144: /* assign_stm: REV_DNS EQUAL NUMBER  */
#line 1042 "cfg.y"
                                       { IFOR(); received_dns|= ((yyvsp[0].intval))?DO_REV_DNS:0; }
#line 3588 "cfg.tab.c"
    break;

  case 145: /* assign_stm: REV_DNS EQUAL error  */
#line 1043 "cfg.y"
                                      { yyerror("boolean value expected"); }
#line 3594 "cfg.tab.c"
    break;

  case 146: /* assign_stm: DNS_TRY_IPV6 EQUAL NUMBER  */
#line 1044 "cfg.y"
                                              { IFOR(); dns_try_ipv6=(yyvsp[0].intval); }
#line 3600 "cfg.tab.c"
    break;

  case 147: /* assign_stm: DNS_TRY_IPV6 error  */
#line 1045 "cfg.y"
                                     { yyerror("boolean value expected"); }
#line 3606 "cfg.tab.c"
    break;

  case 148: /* assign_stm: DNS_TRY_NAPTR EQUAL NUMBER  */
#line 1046 "cfg.y"
                                               { IFOR(); dns_try_naptr=(yyvsp[0].intval); }
#line 3612 "cfg.tab.c"
    break;

  case 149: /* assign_stm: DNS_TRY_NAPTR error  */
#line 1047 "cfg.y"
                                      { yyerror("boolean value expected"); }
#line 3618 "cfg.tab.c"
    break;

  case 150: /* assign_stm: DNS_RETR_TIME EQUAL NUMBER  */
#line 1048 "cfg.y"
                                               { IFOR(); dns_retr_time=(yyvsp[0].intval); }
#line 3624 "cfg.tab.c"
    break;

  case 151: /* assign_stm: DNS_RETR_TIME error  */
#line 1049 "cfg.y"
                                      { yyerror("number expected"); }
#line 3630 "cfg.tab.c"
    break;

  case 152: /* assign_stm: DNS_RETR_NO EQUAL NUMBER  */
#line 1050 "cfg.y"
                                             { IFOR(); dns_retr_no=(yyvsp[0].intval); }
#line 3636 "cfg.tab.c"
    break;

  case 153: /* assign_stm: DNS_RETR_NO error  */
#line 1051 "cfg.y"
                                    { yyerror("number expected"); }
#line 3642 "cfg.tab.c"
    break;

  case 154: /* assign_stm: DNS_SERVERS_NO EQUAL NUMBER  */
#line 1052 "cfg.y"
                                                { IFOR(); dns_servers_no=(yyvsp[0].intval); }
#line 3648 "cfg.tab.c"
    break;

  case 155: /* assign_stm: DNS_SERVERS_NO error  */
#line 1053 "cfg.y"
                                       { yyerror("number expected"); }
#line 3654 "cfg.tab.c"
    break;

  case 156: /* assign_stm: DNS_USE_SEARCH EQUAL NUMBER  */
#line 1054 "cfg.y"
                                                { IFOR(); dns_search_list=(yyvsp[0].intval); }
#line 3660 "cfg.tab.c"
    break;

  case 157: /* assign_stm: DNS_USE_SEARCH error  */
#line 1055 "cfg.y"
                                       { yyerror("boolean value expected"); }
#line 3666 "cfg.tab.c"
    break;

  case 158: /* assign_stm: MAX_WHILE_LOOPS EQUAL NUMBER  */
#line 1056 "cfg.y"
                                               { IFOR(); max_while_loops=(yyvsp[0].intval); }
#line 3672 "cfg.tab.c"
    break;

  case 159: /* assign_stm: MAX_WHILE_LOOPS EQUAL error  */
#line 1057 "cfg.y"
                                              { yyerror("number expected"); }
#line 3678 "cfg.tab.c"
    break;

  case 160: /* assign_stm: MAXBUFFER EQUAL NUMBER  */
#line 1058 "cfg.y"
                                         { IFOR(); maxbuffer=(yyvsp[0].intval); }
#line 3684 "cfg.tab.c"
    break;

  case 161: /* assign_stm: MAXBUFFER EQUAL error  */
#line 1059 "cfg.y"
                                        { yyerror("number expected"); }
#line 3690 "cfg.tab.c"
    break;

  case 162: /* assign_stm: UDP_WORKERS EQUAL NUMBER  */
#line 1060 "cfg.y"
                                           { IFOR(); udp_workers_no=(yyvsp[0].intval); }
#line 3696 "cfg.tab.c"
    break;

  case 163: /* assign_stm: UDP_WORKERS EQUAL NUMBER USE_AUTO_SCALING_PROFILE ID  */
#line 1061 "cfg.y"
                                                                       { IFOR();
				udp_workers_no=(yyvsp[-2].intval);
				udp_auto_scaling_profile=(yyvsp[0].strval);
		}
#line 3705 "cfg.tab.c"
    break;

  case 164: /* assign_stm: UDP_WORKERS EQUAL error  */
#line 1065 "cfg.y"
                                          { yyerror("number expected"); }
#line 3711 "cfg.tab.c"
    break;

  case 165: /* assign_stm: TIMER_WORKERS EQUAL NUMBER  */
#line 1066 "cfg.y"
                                             { IFOR();
				timer_workers_no=(yyvsp[0].intval);
		}
#line 3719 "cfg.tab.c"
    break;

  case 166: /* assign_stm: TIMER_WORKERS EQUAL NUMBER USE_AUTO_SCALING_PROFILE ID  */
#line 1069 "cfg.y"
                                                                         { IFOR();
				timer_workers_no=(yyvsp[-2].intval);
				timer_auto_scaling_profile=(yyvsp[0].strval);
		}
#line 3728 "cfg.tab.c"
    break;

  case 167: /* assign_stm: CHECK_VIA EQUAL NUMBER  */
#line 1073 "cfg.y"
                                         { check_via=(yyvsp[0].intval); }
#line 3734 "cfg.tab.c"
    break;

  case 168: /* assign_stm: CHECK_VIA EQUAL error  */
#line 1074 "cfg.y"
                                        { yyerror("boolean value expected"); }
#line 3740 "cfg.tab.c"
    break;

  case 169: /* assign_stm: SHM_HASH_SPLIT_PERCENTAGE EQUAL NUMBER  */
#line 1075 "cfg.y"
                                                         { IFOR();
			#ifdef HP_MALLOC
			shm_hash_split_percentage=(yyvsp[0].intval);
			#else
			LM_ERR("Cannot set parameter; Please recompile with support "
				"for HP_MALLOC\n");
			#endif
			}
#line 3753 "cfg.tab.c"
    break;

  case 170: /* assign_stm: SHM_HASH_SPLIT_PERCENTAGE EQUAL error  */
#line 1083 "cfg.y"
                                                        {
			#ifdef HP_MALLOC
			yyerror("number expected");
			#else
			LM_ERR("Cannot set parameter; Please recompile with support "
				"for HP_MALLOC\n");
			#endif
				}
#line 3766 "cfg.tab.c"
    break;

  case 171: /* assign_stm: SHM_SECONDARY_HASH_SIZE EQUAL NUMBER  */
#line 1091 "cfg.y"
                                                       { IFOR();
			#ifdef HP_MALLOC
			shm_secondary_hash_size=(yyvsp[0].intval);
			#else
			LM_ERR("Cannot set parameter; Please recompile with support"
				" for HP_MALLOC\n");
			#endif
			}
#line 3779 "cfg.tab.c"
    break;

  case 172: /* assign_stm: SHM_SECONDARY_HASH_SIZE EQUAL error  */
#line 1099 "cfg.y"
                                                      {
			#ifdef HP_MALLOC
			yyerror("number expected");
			#else
			LM_ERR("Cannot set parameter; Please recompile with support "
				"for HP_MALLOC\n");
			#endif
			}
#line 3792 "cfg.tab.c"
    break;

  case 173: /* assign_stm: MEM_WARMING_ENABLED EQUAL NUMBER  */
#line 1107 "cfg.y"
                                                   { IFOR();
			#ifdef HP_MALLOC
			mem_warming_enabled = (yyvsp[0].intval);
			#else
			LM_ERR("Cannot set parameter; Please recompile with support"
				" for HP_MALLOC\n");
			#endif
			}
#line 3805 "cfg.tab.c"
    break;

  case 174: /* assign_stm: MEM_WARMING_ENABLED EQUAL error  */
#line 1115 "cfg.y"
                                                  {
			#ifdef HP_MALLOC
			yyerror("number expected");
			#else
			LM_ERR("Cannot set parameter; Please recompile with support "
				"for HP_MALLOC\n");
			#endif
			}
#line 3818 "cfg.tab.c"
    break;

  case 175: /* assign_stm: MEM_WARMING_PATTERN_FILE EQUAL STRING  */
#line 1123 "cfg.y"
                                                        { IFOR();
			#ifdef HP_MALLOC
			mem_warming_pattern_file = (yyvsp[0].strval);
			#else
			LM_ERR("Cannot set parameter; Please recompile with "
				"support for HP_MALLOC\n");
			#endif
			}
#line 3831 "cfg.tab.c"
    break;

  case 176: /* assign_stm: MEM_WARMING_PATTERN_FILE EQUAL error  */
#line 1131 "cfg.y"
                                                       {
			#ifdef HP_MALLOC
			yyerror("string expected");
			#else
			LM_ERR("Cannot set parameter; Please recompile with support "
				"for HP_MALLOC\n");
			#endif
			}
#line 3844 "cfg.tab.c"
    break;

  case 177: /* assign_stm: MEM_WARMING_PERCENTAGE EQUAL NUMBER  */
#line 1139 "cfg.y"
                                                      { IFOR();
			#ifdef HP_MALLOC
			mem_warming_percentage = (yyvsp[0].intval);
			#else
			LM_ERR("Cannot set parameter; Please recompile with "
				"support for HP_MALLOC\n");
			#endif
			}
#line 3857 "cfg.tab.c"
    break;

  case 178: /* assign_stm: MEM_WARMING_PERCENTAGE EQUAL error  */
#line 1147 "cfg.y"
                                                     {
			#ifdef HP_MALLOC
			yyerror("number expected");
			#else
			LM_ERR("Cannot set parameter; Please recompile with support "
				"for HP_MALLOC\n");
			#endif
			}
#line 3870 "cfg.tab.c"
    break;

  case 179: /* assign_stm: RPM_MEM_FILE EQUAL STRING  */
#line 1155 "cfg.y"
                                            { IFOR();
			rpm_mem_file = (yyvsp[0].strval);
			}
#line 3878 "cfg.tab.c"
    break;

  case 180: /* assign_stm: RPM_MEM_FILE EQUAL error  */
#line 1158 "cfg.y"
                                           { yyerror("string value expected"); }
#line 3884 "cfg.tab.c"
    break;

  case 181: /* assign_stm: RPM_MEM_SIZE EQUAL NUMBER  */
#line 1159 "cfg.y"
                                            { IFOR();
			rpm_mem_size = (yyvsp[0].intval) * 1024 * 1024;
			}
#line 3892 "cfg.tab.c"
    break;

  case 182: /* assign_stm: RPM_MEM_SIZE EQUAL error  */
#line 1162 "cfg.y"
                                           { yyerror("int value expected"); }
#line 3898 "cfg.tab.c"
    break;

  case 183: /* assign_stm: MEMLOG EQUAL snumber  */
#line 1163 "cfg.y"
                                       { IFOR(); memlog=(yyvsp[0].intval); memdump=(yyvsp[0].intval); }
#line 3904 "cfg.tab.c"
    break;

  case 184: /* assign_stm: MEMLOG EQUAL error  */
#line 1164 "cfg.y"
                                     { yyerror("int value expected"); }
#line 3910 "cfg.tab.c"
    break;

  case 185: /* assign_stm: SHM_MEMLOG_SIZE EQUAL snumber  */
#line 1165 "cfg.y"
                                                { IFOR(); shm_memlog_size=(yyvsp[0].intval);}
#line 3916 "cfg.tab.c"
    break;

  case 186: /* assign_stm: SHM_MEMLOG_SIZE EQUAL error  */
#line 1166 "cfg.y"
                                              { yyerror("int value expected"); }
#line 3922 "cfg.tab.c"
    break;

  case 187: /* assign_stm: MEMDUMP EQUAL snumber  */
#line 1167 "cfg.y"
                                        { IFOR(); memdump=(yyvsp[0].intval); }
#line 3928 "cfg.tab.c"
    break;

  case 188: /* assign_stm: MEMDUMP EQUAL error  */
#line 1168 "cfg.y"
                                      { yyerror("int value expected"); }
#line 3934 "cfg.tab.c"
    break;

  case 189: /* assign_stm: EXECMSGTHRESHOLD EQUAL NUMBER  */
#line 1169 "cfg.y"
                                                {  IFOR();execmsgthreshold=(yyvsp[0].intval); }
#line 3940 "cfg.tab.c"
    break;

  case 190: /* assign_stm: EXECMSGTHRESHOLD EQUAL error  */
#line 1170 "cfg.y"
                                               { yyerror("int value expected"); }
#line 3946 "cfg.tab.c"
    break;

  case 191: /* assign_stm: EXECDNSTHRESHOLD EQUAL NUMBER  */
#line 1171 "cfg.y"
                                                { IFOR(); execdnsthreshold=(yyvsp[0].intval); }
#line 3952 "cfg.tab.c"
    break;

  case 192: /* assign_stm: EXECDNSTHRESHOLD EQUAL error  */
#line 1172 "cfg.y"
                                               { yyerror("int value expected"); }
#line 3958 "cfg.tab.c"
    break;

  case 193: /* assign_stm: TCPTHRESHOLD EQUAL NUMBER  */
#line 1173 "cfg.y"
                                            { IFOR(); tcpthreshold=(yyvsp[0].intval); }
#line 3964 "cfg.tab.c"
    break;

  case 194: /* assign_stm: TCPTHRESHOLD EQUAL error  */
#line 1174 "cfg.y"
                                           { yyerror("int value expected"); }
#line 3970 "cfg.tab.c"
    break;

  case 195: /* assign_stm: EVENT_SHM_THRESHOLD EQUAL NUMBER  */
#line 1175 "cfg.y"
                                                   { IFOR();
			#ifdef STATISTICS
			if ((yyvsp[0].intval) < 0 || (yyvsp[0].intval) > 100)
				yyerror("SHM threshold has to be a percentage between"
					" 0 and 100");
			event_shm_threshold=(yyvsp[0].intval);
			#else
			yyerror("statistics support not compiled in");
			#endif /* STATISTICS */
			}
#line 3985 "cfg.tab.c"
    break;

  case 196: /* assign_stm: EVENT_SHM_THRESHOLD EQUAL error  */
#line 1185 "cfg.y"
                                                  { yyerror("int value expected"); }
#line 3991 "cfg.tab.c"
    break;

  case 197: /* assign_stm: EVENT_PKG_THRESHOLD EQUAL NUMBER  */
#line 1186 "cfg.y"
                                                   { IFOR();
			#ifdef PKG_MALLOC
			#ifdef STATISTICS
			if ((yyvsp[0].intval) < 0 || (yyvsp[0].intval) > 100)
				yyerror("PKG threshold has to be a percentage between "
					"0 and 100");
			event_pkg_threshold=(yyvsp[0].intval);
			#else
			yyerror("statistics support not compiled in");
			#endif
			#else
			yyerror("pkg_malloc support not compiled in");
			#endif
			}
#line 4010 "cfg.tab.c"
    break;

  case 198: /* assign_stm: EVENT_PKG_THRESHOLD EQUAL error  */
#line 1200 "cfg.y"
                                                  { yyerror("int value expected"); }
#line 4016 "cfg.tab.c"
    break;

  case 199: /* assign_stm: QUERYBUFFERSIZE EQUAL NUMBER  */
#line 1201 "cfg.y"
                                               { IFOR(); query_buffer_size=(yyvsp[0].intval); }
#line 4022 "cfg.tab.c"
    break;

  case 200: /* assign_stm: QUERYBUFFERSIZE EQUAL error  */
#line 1202 "cfg.y"
                                              { yyerror("int value expected"); }
#line 4028 "cfg.tab.c"
    break;

  case 201: /* assign_stm: QUERYFLUSHTIME EQUAL NUMBER  */
#line 1203 "cfg.y"
                                              { IFOR(); query_flush_time=(yyvsp[0].intval); }
#line 4034 "cfg.tab.c"
    break;

  case 202: /* assign_stm: QUERYFLUSHTIME EQUAL error  */
#line 1204 "cfg.y"
                                             { yyerror("int value expected"); }
#line 4040 "cfg.tab.c"
    break;

  case 203: /* assign_stm: SIP_WARNING EQUAL NUMBER  */
#line 1205 "cfg.y"
                                           { IFOR(); sip_warning=(yyvsp[0].intval); }
#line 4046 "cfg.tab.c"
    break;

  case 204: /* assign_stm: SIP_WARNING EQUAL error  */
#line 1206 "cfg.y"
                                          { yyerror("boolean value expected"); }
#line 4052 "cfg.tab.c"
    break;

  case 205: /* assign_stm: CHROOT EQUAL STRING  */
#line 1207 "cfg.y"
                                          { IFOR(); chroot_dir=(yyvsp[0].strval); }
#line 4058 "cfg.tab.c"
    break;

  case 206: /* assign_stm: CHROOT EQUAL ID  */
#line 1208 "cfg.y"
                                          { IFOR(); chroot_dir=(yyvsp[0].strval); }
#line 4064 "cfg.tab.c"
    break;

  case 207: /* assign_stm: CHROOT EQUAL error  */
#line 1209 "cfg.y"
                                          { yyerror("string value expected"); }
#line 4070 "cfg.tab.c"
    break;

  case 208: /* assign_stm: WDIR EQUAL STRING  */
#line 1210 "cfg.y"
                                        { IFOR(); working_dir=(yyvsp[0].strval); }
#line 4076 "cfg.tab.c"
    break;

  case 209: /* assign_stm: WDIR EQUAL ID  */
#line 1211 "cfg.y"
                                        { IFOR(); working_dir=(yyvsp[0].strval); }
#line 4082 "cfg.tab.c"
    break;

  case 210: /* assign_stm: WDIR EQUAL error  */
#line 1212 "cfg.y"
                                        { yyerror("string value expected"); }
#line 4088 "cfg.tab.c"
    break;

  case 211: /* assign_stm: MHOMED EQUAL NUMBER  */
#line 1213 "cfg.y"
                                      { IFOR(); mhomed=(yyvsp[0].intval); }
#line 4094 "cfg.tab.c"
    break;

  case 212: /* assign_stm: MHOMED EQUAL error  */
#line 1214 "cfg.y"
                                     { yyerror("boolean value expected"); }
#line 4100 "cfg.tab.c"
    break;

  case 213: /* assign_stm: POLL_METHOD EQUAL ID  */
#line 1215 "cfg.y"
                                       { IFOR();
									io_poll_method=get_poll_type((yyvsp[0].strval));
									if (io_poll_method==POLL_NONE){
										LM_CRIT("bad poll method name:"
											" %s\n, try one of %s.\n",
											(yyvsp[0].strval), poll_support);
										yyerror("bad poll_method "
											"value");
									}
								}
#line 4115 "cfg.tab.c"
    break;

  case 214: /* assign_stm: POLL_METHOD EQUAL STRING  */
#line 1225 "cfg.y"
                                           { IFOR();
									io_poll_method=get_poll_type((yyvsp[0].strval));
									if (io_poll_method==POLL_NONE){
										LM_CRIT("bad poll method name:"
											" %s\n, try one of %s.\n",
											(yyvsp[0].strval), poll_support);
										yyerror("bad poll_method "
											"value");
									}
									}
#line 4130 "cfg.tab.c"
    break;

  case 215: /* assign_stm: POLL_METHOD EQUAL error  */
#line 1235 "cfg.y"
                                          { yyerror("poll method name expected"); }
#line 4136 "cfg.tab.c"
    break;

  case 216: /* assign_stm: TCP_ACCEPT_ALIASES EQUAL NUMBER  */
#line 1236 "cfg.y"
                                                  { IFOR();
				if ((yyvsp[0].intval) < TCP_ALIAS_NEVER || (yyvsp[0].intval) > TCP_ALIAS_ALWAYS)
					yyerror("invalid 'tcp_accept_aliases' value");
				tcp_accept_aliases=(yyvsp[0].intval);
		}
#line 4146 "cfg.tab.c"
    break;

  case 217: /* assign_stm: TCP_ACCEPT_ALIASES EQUAL error  */
#line 1241 "cfg.y"
                                                 { yyerror("boolean value expected"); }
#line 4152 "cfg.tab.c"
    break;

  case 218: /* assign_stm: TCP_WORKERS EQUAL NUMBER  */
#line 1242 "cfg.y"
                                           { IFOR();
				tcp_workers_no=(yyvsp[0].intval);
		}
#line 4160 "cfg.tab.c"
    break;

  case 219: /* assign_stm: TCP_WORKERS EQUAL NUMBER USE_AUTO_SCALING_PROFILE ID  */
#line 1245 "cfg.y"
                                                                      { IFOR();
				tcp_workers_no=(yyvsp[-2].intval);
				tcp_auto_scaling_profile=(yyvsp[0].strval);
		}
#line 4169 "cfg.tab.c"
    break;

  case 220: /* assign_stm: TCP_WORKERS EQUAL error  */
#line 1249 "cfg.y"
                                          { yyerror("number expected"); }
#line 4175 "cfg.tab.c"
    break;

  case 221: /* assign_stm: TCP_CONNECT_TIMEOUT EQUAL NUMBER  */
#line 1250 "cfg.y"
                                                   { IFOR();
				if ((yyvsp[0].intval) <= 0)
					yyerror("invalid 'tcp_connect_timeout' (value too low!)");
				tcp_connect_timeout=(yyvsp[0].intval);
		}
#line 4185 "cfg.tab.c"
    break;

  case 222: /* assign_stm: TCP_CONNECT_TIMEOUT EQUAL error  */
#line 1255 "cfg.y"
                                                  { yyerror("number expected"); }
#line 4191 "cfg.tab.c"
    break;

  case 223: /* assign_stm: TCP_CON_LIFETIME EQUAL NUMBER  */
#line 1256 "cfg.y"
                                                { IFOR();
				tcp_con_lifetime=(yyvsp[0].intval);
		}
#line 4199 "cfg.tab.c"
    break;

  case 224: /* assign_stm: TCP_CON_LIFETIME EQUAL error  */
#line 1259 "cfg.y"
                                               { yyerror("number expected"); }
#line 4205 "cfg.tab.c"
    break;

  case 225: /* assign_stm: TCP_SOCKET_BACKLOG EQUAL NUMBER  */
#line 1260 "cfg.y"
                                                  { IFOR();
				tcp_socket_backlog=(yyvsp[0].intval);
		}
#line 4213 "cfg.tab.c"
    break;

  case 226: /* assign_stm: TCP_SOCKET_BACKLOG EQUAL error  */
#line 1263 "cfg.y"
                                                 { yyerror("number expected"); }
#line 4219 "cfg.tab.c"
    break;

  case 227: /* assign_stm: TCP_MAX_CONNECTIONS EQUAL NUMBER  */
#line 1264 "cfg.y"
                                                   { IFOR();
				tcp_max_connections=(yyvsp[0].intval);
		}
#line 4227 "cfg.tab.c"
    break;

  case 228: /* assign_stm: TCP_MAX_CONNECTIONS EQUAL error  */
#line 1267 "cfg.y"
                                                  { yyerror("number expected"); }
#line 4233 "cfg.tab.c"
    break;

  case 229: /* assign_stm: TCP_NO_NEW_CONN_BFLAG EQUAL ID  */
#line 1268 "cfg.y"
                                                 { IFOR();
				tcp_no_new_conn_bflag =
					get_flag_id_by_name(FLAG_TYPE_BRANCH, (yyvsp[0].strval), 0);
				if (!flag_in_range( (flag_t)tcp_no_new_conn_bflag ) )
					yyerror("invalid TCP no_new_conn Branch Flag");
				flag_idx2mask( &tcp_no_new_conn_bflag );
		}
#line 4245 "cfg.tab.c"
    break;

  case 230: /* assign_stm: TCP_NO_NEW_CONN_BFLAG EQUAL error  */
#line 1275 "cfg.y"
                                                    { yyerror("number value expected"); }
#line 4251 "cfg.tab.c"
    break;

  case 231: /* assign_stm: TCP_NO_NEW_CONN_RPLFLAG EQUAL ID  */
#line 1276 "cfg.y"
                                                   { IFOR();
				tcp_no_new_conn_rplflag =
					get_flag_id_by_name(FLAG_TYPE_MSG, (yyvsp[0].strval), 0);
				if (!flag_in_range( (flag_t)tcp_no_new_conn_rplflag ) )
					yyerror("invalid TCP no_new_conn RePLy Flag");
				flag_idx2mask( &tcp_no_new_conn_rplflag );
		}
#line 4263 "cfg.tab.c"
    break;

  case 232: /* assign_stm: TCP_NO_NEW_CONN_RPLFLAG EQUAL error  */
#line 1283 "cfg.y"
                                                      { yyerror("number value expected"); }
#line 4269 "cfg.tab.c"
    break;

  case 233: /* assign_stm: TCP_KEEPALIVE EQUAL NUMBER  */
#line 1285 "cfg.y"
                                             { IFOR();
				tcp_keepalive=!!(yyvsp[0].intval);
		}
#line 4277 "cfg.tab.c"
    break;

  case 234: /* assign_stm: TCP_KEEPALIVE EQUAL error  */
#line 1288 "cfg.y"
                                            { yyerror("boolean value expected"); }
#line 4283 "cfg.tab.c"
    break;

  case 235: /* assign_stm: TCP_MAX_MSG_TIME EQUAL NUMBER  */
#line 1289 "cfg.y"
                                                { IFOR();
				tcp_max_msg_time=(yyvsp[0].intval);
		}
#line 4291 "cfg.tab.c"
    break;

  case 236: /* assign_stm: TCP_MAX_MSG_TIME EQUAL error  */
#line 1292 "cfg.y"
                                               { yyerror("boolean value expected"); }
#line 4297 "cfg.tab.c"
    break;

  case 237: /* assign_stm: TCP_PARALLEL_READ_ON_WORKERS EQUAL NUMBER  */
#line 1293 "cfg.y"
                                                            { IFOR();
				tcp_parallel_read_on_workers=!!(yyvsp[0].intval);
		}
#line 4305 "cfg.tab.c"
    break;

  case 238: /* assign_stm: TCP_PARALLEL_READ_ON_WORKERS EQUAL error  */
#line 1296 "cfg.y"
                                                           {
			yyerror("boolean value expected");
		}
#line 4313 "cfg.tab.c"
    break;

  case 239: /* assign_stm: TCP_KEEPCOUNT EQUAL NUMBER  */
#line 1299 "cfg.y"
                                                        { IFOR();
			#ifndef HAVE_TCP_KEEPCNT
				warn("cannot be enabled TCP_KEEPCOUNT (no OS support)");
			#else
				tcp_keepcount=(yyvsp[0].intval);
			#endif
		}
#line 4325 "cfg.tab.c"
    break;

  case 240: /* assign_stm: TCP_KEEPCOUNT EQUAL error  */
#line 1306 "cfg.y"
                                            { yyerror("int value expected"); }
#line 4331 "cfg.tab.c"
    break;

  case 241: /* assign_stm: TCP_KEEPIDLE EQUAL NUMBER  */
#line 1307 "cfg.y"
                                                        { IFOR();
			#ifndef HAVE_TCP_KEEPIDLE
				warn("cannot be enabled TCP_KEEPIDLE (no OS support)");
			#else
				tcp_keepidle=(yyvsp[0].intval);
			#endif
		}
#line 4343 "cfg.tab.c"
    break;

  case 242: /* assign_stm: TCP_KEEPIDLE EQUAL error  */
#line 1314 "cfg.y"
                                           { yyerror("int value expected"); }
#line 4349 "cfg.tab.c"
    break;

  case 243: /* assign_stm: TCP_KEEPINTERVAL EQUAL NUMBER  */
#line 1315 "cfg.y"
                                                { IFOR();
			#ifndef HAVE_TCP_KEEPINTVL
				warn("cannot be enabled TCP_KEEPINTERVAL (no OS support)");
			#else
				tcp_keepinterval=(yyvsp[0].intval);
			 #endif
		}
#line 4361 "cfg.tab.c"
    break;

  case 244: /* assign_stm: TCP_KEEPINTERVAL EQUAL error  */
#line 1322 "cfg.y"
                                               { yyerror("int value expected"); }
#line 4367 "cfg.tab.c"
    break;

  case 245: /* assign_stm: SERVER_SIGNATURE EQUAL NUMBER  */
#line 1323 "cfg.y"
                                                { IFOR();
							server_signature=(yyvsp[0].intval); }
#line 4374 "cfg.tab.c"
    break;

  case 246: /* assign_stm: SERVER_SIGNATURE EQUAL error  */
#line 1325 "cfg.y"
                                               { yyerror("boolean value expected"); }
#line 4380 "cfg.tab.c"
    break;

  case 247: /* assign_stm: SERVER_HEADER EQUAL STRING  */
#line 1326 "cfg.y"
                                             { IFOR();
							server_header->s=(yyvsp[0].strval);
							server_header->len=strlen((yyvsp[0].strval));
							}
#line 4389 "cfg.tab.c"
    break;

  case 248: /* assign_stm: SERVER_HEADER EQUAL error  */
#line 1330 "cfg.y"
                                            { yyerror("string value expected"); }
#line 4395 "cfg.tab.c"
    break;

  case 249: /* assign_stm: USER_AGENT_HEADER EQUAL STRING  */
#line 1331 "cfg.y"
                                                 { user_agent_header->s=(yyvsp[0].strval);
			user_agent_header->len=strlen((yyvsp[0].strval));
									}
#line 4403 "cfg.tab.c"
    break;

  case 250: /* assign_stm: USER_AGENT_HEADER EQUAL error  */
#line 1334 "cfg.y"
                                                { yyerror("string value expected"); }
#line 4409 "cfg.tab.c"
    break;

  case 251: /* assign_stm: PV_PRINT_BUF_SIZE EQUAL NUMBER  */
#line 1335 "cfg.y"
                                                 { IFOR();
							pv_print_buf_size = (yyvsp[0].intval); }
#line 4416 "cfg.tab.c"
    break;

  case 252: /* assign_stm: PV_PRINT_BUF_SIZE EQUAL error  */
#line 1337 "cfg.y"
                                                { yyerror("number expected"); }
#line 4422 "cfg.tab.c"
    break;

  case 253: /* assign_stm: XLOG_BUF_SIZE EQUAL NUMBER  */
#line 1338 "cfg.y"
                                             { IFOR();
							xlog_buf_size = (yyvsp[0].intval); }
#line 4429 "cfg.tab.c"
    break;

  case 254: /* assign_stm: XLOG_FORCE_COLOR EQUAL NUMBER  */
#line 1340 "cfg.y"
                                                { IFOR();
							xlog_force_color = (yyvsp[0].intval); }
#line 4436 "cfg.tab.c"
    break;

  case 255: /* assign_stm: XLOG_PRINT_LEVEL EQUAL NUMBER  */
#line 1342 "cfg.y"
                                                { IFOR();
							xlog_print_level = (yyvsp[0].intval); }
#line 4443 "cfg.tab.c"
    break;

  case 256: /* assign_stm: XLOG_BUF_SIZE EQUAL error  */
#line 1344 "cfg.y"
                                            { yyerror("number expected"); }
#line 4449 "cfg.tab.c"
    break;

  case 257: /* assign_stm: XLOG_FORCE_COLOR EQUAL error  */
#line 1345 "cfg.y"
                                               { yyerror("boolean value expected"); }
#line 4455 "cfg.tab.c"
    break;

  case 258: /* assign_stm: XLOG_PRINT_LEVEL EQUAL error  */
#line 1346 "cfg.y"
                                               { yyerror("number expected"); }
#line 4461 "cfg.tab.c"
    break;

  case 259: /* assign_stm: XLOG_LEVEL EQUAL snumber  */
#line 1347 "cfg.y"
                                           { IFOR();
							*xlog_level = (yyvsp[0].intval); }
#line 4468 "cfg.tab.c"
    break;

  case 260: /* assign_stm: XLOG_LEVEL EQUAL error  */
#line 1349 "cfg.y"
                                         { yyerror("number expected"); }
#line 4474 "cfg.tab.c"
    break;

  case 261: /* assign_stm: SOCKET EQUAL socket_def  */
#line 1350 "cfg.y"
                                          { IFOR();
							if (add_listening_socket((yyvsp[0].sockid))!=0){
								LM_CRIT("cfg. parser: failed"
										" to add listening socket\n");
								break;
							}
						}
#line 4486 "cfg.tab.c"
    break;

  case 262: /* assign_stm: SOCKET EQUAL error  */
#line 1357 "cfg.y"
                                      { yyerror("ip address or hostname "
						"expected (use quotes if the hostname includes"
						" config keywords)"); }
#line 4494 "cfg.tab.c"
    break;

  case 263: /* assign_stm: LISTEN EQUAL socket_def  */
#line 1360 "cfg.y"
                                          { IFOR();
							warn("'listen' is deprecated, use 'socket' instead");
							if (add_listening_socket((yyvsp[0].sockid))!=0){
								LM_CRIT("cfg. parser: failed"
										" to add listen address\n");
								break;
							}
						}
#line 4507 "cfg.tab.c"
    break;

  case 264: /* assign_stm: LISTEN EQUAL error  */
#line 1368 "cfg.y"
                                      { yyerror("ip address or hostname "
						"expected (use quotes if the hostname includes"
						" config keywords)"); }
#line 4515 "cfg.tab.c"
    break;

  case 265: /* assign_stm: MEMGROUP EQUAL STRING COLON multi_string  */
#line 1371 "cfg.y"
                                                           { IFOR();
							/* convert STIRNG ($3) to an ID */
							/* update the memstats type for each module */
							#ifndef SHM_EXTRA_STATS
								LM_CRIT("SHM_EXTRA_STATS not defined");
								YYABORT;
							#else

							#ifdef SHM_SHOW_DEFAULT_GROUP
							if(strcmp((yyvsp[-2].strval), "default") == 0){
								LM_CRIT("default group  name is not allowed");
								YYABORT;
							}
							#endif

							for(tmp_mod = mod_names; tmp_mod; tmp_mod=tmp_mod->next){
								if(strcmp((yyvsp[-2].strval), tmp_mod->s) == 0){
									LM_CRIT("The same mem-group name is used twice: [%s] [%s]\n", (yyvsp[-2].strval), tmp_mod->s);
									YYABORT;
								}
							}

							tmp_mod = pkg_malloc(sizeof(struct multi_str));
							if(!tmp_mod){
								LM_CRIT("out of pkg memory");
								YYABORT;
							}

							tmp_mod->s = (yyvsp[-2].strval);
							tmp_mod->next = mod_names;
							mod_names = tmp_mod;
							for (tmp_mod = (yyvsp[0].multistr); tmp_mod; tmp_mod = tmp_mod->next){
								if(set_mem_idx(tmp_mod->s, mem_free_idx)){
									YYABORT;
								}
							}

							mem_free_idx++;

							if(alloc_group_stat()){
								YYABORT;
							}
							#endif
						}
#line 4564 "cfg.tab.c"
    break;

  case 266: /* assign_stm: MEMGROUP EQUAL STRING COLON error  */
#line 1415 "cfg.y"
                                                    { yyerror("invalid or no module specified"); }
#line 4570 "cfg.tab.c"
    break;

  case 267: /* assign_stm: ALIAS EQUAL id_lst  */
#line 1416 "cfg.y"
                                      { IFOR();
							for(lst_tmp=(yyvsp[0].sockid); lst_tmp; lst_tmp=lst_tmp->next)
								add_alias(lst_tmp->name, strlen(lst_tmp->name),
											lst_tmp->port, lst_tmp->proto);
							  }
#line 4580 "cfg.tab.c"
    break;

  case 268: /* assign_stm: ALIAS EQUAL error  */
#line 1421 "cfg.y"
                                      { yyerror("hostname expected (use quotes"
							" if the hostname includes config keywords)"); }
#line 4587 "cfg.tab.c"
    break;

  case 269: /* assign_stm: AUTO_ALIASES EQUAL NUMBER  */
#line 1423 "cfg.y"
                                            { IFOR();
								auto_aliases=(yyvsp[0].intval); }
#line 4594 "cfg.tab.c"
    break;

  case 270: /* assign_stm: AUTO_ALIASES EQUAL error  */
#line 1425 "cfg.y"
                                            { yyerror("number  expected"); }
#line 4600 "cfg.tab.c"
    break;

  case 271: /* assign_stm: ADVERTISED_ADDRESS EQUAL listen_id  */
#line 1426 "cfg.y"
                                                     { IFOR();
								if ((yyvsp[0].strval)) {
									default_global_address->s=(yyvsp[0].strval);
									default_global_address->len=strlen((yyvsp[0].strval));
								}
								}
#line 4611 "cfg.tab.c"
    break;

  case 272: /* assign_stm: ADVERTISED_ADDRESS EQUAL error  */
#line 1432 "cfg.y"
                                                 {yyerror("ip address or hostname "
												"expected"); }
#line 4618 "cfg.tab.c"
    break;

  case 273: /* assign_stm: ADVERTISED_PORT EQUAL NUMBER  */
#line 1434 "cfg.y"
                                               { IFOR();
								tmp = int2str((yyvsp[0].intval), &i_tmp);
								if (i_tmp > default_global_port->len)
									default_global_port->s =
									pkg_realloc(default_global_port->s, i_tmp);
								if (!default_global_port->s) {
									LM_CRIT("cfg. parser: out of memory.\n");
									YYABORT;
								} else {
									default_global_port->len = i_tmp;
									memcpy(default_global_port->s, tmp,
											default_global_port->len);
								}
								}
#line 4637 "cfg.tab.c"
    break;

  case 274: /* assign_stm: ADVERTISED_PORT EQUAL error  */
#line 1448 "cfg.y"
                                             {yyerror("ip address or hostname "
												"expected"); }
#line 4644 "cfg.tab.c"
    break;

  case 275: /* assign_stm: DISABLE_CORE EQUAL NUMBER  */
#line 1450 "cfg.y"
                                            { IFOR();
										disable_core_dump=(yyvsp[0].intval);
									}
#line 4652 "cfg.tab.c"
    break;

  case 276: /* assign_stm: DISABLE_CORE EQUAL error  */
#line 1453 "cfg.y"
                                           { yyerror("boolean value expected"); }
#line 4658 "cfg.tab.c"
    break;

  case 277: /* assign_stm: OPEN_FD_LIMIT EQUAL NUMBER  */
#line 1454 "cfg.y"
                                             { IFOR();
										open_files_limit=(yyvsp[0].intval);
									}
#line 4666 "cfg.tab.c"
    break;

  case 278: /* assign_stm: OPEN_FD_LIMIT EQUAL error  */
#line 1457 "cfg.y"
                                            { yyerror("number expected"); }
#line 4672 "cfg.tab.c"
    break;

  case 279: /* assign_stm: MCAST_LOOPBACK EQUAL NUMBER  */
#line 1458 "cfg.y"
                                              { IFOR();
								#ifdef USE_MCAST
										mcast_loopback=(yyvsp[0].intval);
								#else
									warn("no multicast support compiled in");
								#endif
		  }
#line 4684 "cfg.tab.c"
    break;

  case 280: /* assign_stm: MCAST_LOOPBACK EQUAL error  */
#line 1465 "cfg.y"
                                             { yyerror("boolean value expected"); }
#line 4690 "cfg.tab.c"
    break;

  case 281: /* assign_stm: MCAST_TTL EQUAL NUMBER  */
#line 1466 "cfg.y"
                                         { IFOR();
								#ifdef USE_MCAST
										mcast_ttl=(yyvsp[0].intval);
								#else
									warn("no multicast support compiled in");
								#endif
		  }
#line 4702 "cfg.tab.c"
    break;

  case 282: /* assign_stm: MCAST_TTL EQUAL error  */
#line 1473 "cfg.y"
                                        { yyerror("number expected as tos"); }
#line 4708 "cfg.tab.c"
    break;

  case 283: /* assign_stm: TOS EQUAL NUMBER  */
#line 1474 "cfg.y"
                                   { IFOR(); tos = (yyvsp[0].intval);
							if (tos<=0)
								yyerror("invalid tos value");
		 }
#line 4717 "cfg.tab.c"
    break;

  case 284: /* assign_stm: TOS EQUAL ID  */
#line 1478 "cfg.y"
                               { IFOR();
							if (strcasecmp((yyvsp[0].strval),"IPTOS_LOWDELAY")) {
								tos=IPTOS_LOWDELAY;
							} else if (strcasecmp((yyvsp[0].strval),"IPTOS_THROUGHPUT")) {
								tos=IPTOS_THROUGHPUT;
							} else if (strcasecmp((yyvsp[0].strval),"IPTOS_RELIABILITY")) {
								tos=IPTOS_RELIABILITY;
#if defined(IPTOS_MINCOST)
							} else if (strcasecmp((yyvsp[0].strval),"IPTOS_MINCOST")) {
								tos=IPTOS_MINCOST;
#endif
#if defined(IPTOS_LOWCOST)
							} else if (strcasecmp((yyvsp[0].strval),"IPTOS_LOWCOST")) {
								tos=IPTOS_LOWCOST;
#endif
							} else {
								yyerror("invalid tos value - allowed: "
									"IPTOS_LOWDELAY,IPTOS_THROUGHPUT,"
									"IPTOS_RELIABILITY"
#if defined(IPTOS_LOWCOST)
									",IPTOS_LOWCOST"
#endif
#if defined(IPTOS_MINCOST)
									",IPTOS_MINCOST"
#endif
									"\n");
							}
		 }
#line 4750 "cfg.tab.c"
    break;

  case 285: /* assign_stm: TOS EQUAL error  */
#line 1506 "cfg.y"
                                  { yyerror("number expected"); }
#line 4756 "cfg.tab.c"
    break;

  case 286: /* assign_stm: MPATH EQUAL STRING  */
#line 1507 "cfg.y"
                                     {IFOR();
				set_mpath((yyvsp[0].strval)); }
#line 4763 "cfg.tab.c"
    break;

  case 287: /* assign_stm: MPATH EQUAL error  */
#line 1509 "cfg.y"
                                     { yyerror("string value expected"); }
#line 4769 "cfg.tab.c"
    break;

  case 288: /* assign_stm: DISABLE_DNS_FAILOVER EQUAL NUMBER  */
#line 1510 "cfg.y"
                                                    { IFOR();
										disable_dns_failover=(yyvsp[0].intval);
									}
#line 4777 "cfg.tab.c"
    break;

  case 289: /* assign_stm: DISABLE_DNS_FAILOVER error  */
#line 1513 "cfg.y"
                                             { yyerror("boolean value expected"); }
#line 4783 "cfg.tab.c"
    break;

  case 290: /* assign_stm: DISABLE_DNS_BLACKLIST EQUAL NUMBER  */
#line 1514 "cfg.y"
                                                     { IFOR();
										disable_dns_blacklist=(yyvsp[0].intval);
									}
#line 4791 "cfg.tab.c"
    break;

  case 291: /* assign_stm: DISABLE_DNS_BLACKLIST error  */
#line 1517 "cfg.y"
                                              { yyerror("boolean value expected"); }
#line 4797 "cfg.tab.c"
    break;

  case 292: /* assign_stm: DST_BLACKLIST EQUAL ID SLASH blst_flags blst_def  */
#line 1518 "cfg.y"
                                                                   { IFOR();
				s_tmp.s = (yyvsp[-3].strval);
				s_tmp.len = strlen((yyvsp[-3].strval));
				if (create_bl_head(_str("script"), (yyvsp[-1].intval),
				    bl_head, bl_tail, &s_tmp)==0) {
					yyerror("failed to create blacklist\n");
					YYABORT;
				}
				bl_head = bl_tail = NULL;
				}
#line 4812 "cfg.tab.c"
    break;

  case 293: /* assign_stm: DST_BLACKLIST EQUAL ID blst_def  */
#line 1528 "cfg.y"
                                                  { IFOR();
				s_tmp.s = (yyvsp[-1].strval);
				s_tmp.len = strlen((yyvsp[-1].strval));
				if (create_bl_head(_str("script"), BL_READONLY_LIST,
				    bl_head, bl_tail, &s_tmp)==0) {
					yyerror("failed to create blacklist\n");
					YYABORT;
				}
				bl_head = bl_tail = NULL;
				}
#line 4827 "cfg.tab.c"
    break;

  case 294: /* assign_stm: DISABLE_STATELESS_FWD EQUAL NUMBER  */
#line 1538 "cfg.y"
                                                     { IFOR();
				sl_fwd_disabled=(yyvsp[0].intval); }
#line 4834 "cfg.tab.c"
    break;

  case 295: /* assign_stm: DB_VERSION_TABLE EQUAL STRING  */
#line 1540 "cfg.y"
                                                { IFOR();
				db_version_table=(yyvsp[0].strval); }
#line 4841 "cfg.tab.c"
    break;

  case 296: /* assign_stm: DB_VERSION_TABLE EQUAL error  */
#line 1542 "cfg.y"
                                               { yyerror("string value expected"); }
#line 4847 "cfg.tab.c"
    break;

  case 297: /* assign_stm: DB_DEFAULT_URL EQUAL STRING  */
#line 1543 "cfg.y"
                                              { IFOR();
				db_default_url=(yyvsp[0].strval); }
#line 4854 "cfg.tab.c"
    break;

  case 298: /* assign_stm: DB_DEFAULT_URL EQUAL error  */
#line 1545 "cfg.y"
                                             { yyerror("string value expected"); }
#line 4860 "cfg.tab.c"
    break;

  case 299: /* assign_stm: DB_MAX_ASYNC_CONNECTIONS EQUAL NUMBER  */
#line 1546 "cfg.y"
                                                        { IFOR();
				db_max_async_connections=(yyvsp[0].intval); }
#line 4867 "cfg.tab.c"
    break;

  case 300: /* assign_stm: DB_MAX_ASYNC_CONNECTIONS EQUAL error  */
#line 1548 "cfg.y"
                                                       {
				yyerror("integer value expected");
				}
#line 4875 "cfg.tab.c"
    break;

  case 301: /* assign_stm: DISABLE_503_TRANSLATION EQUAL NUMBER  */
#line 1551 "cfg.y"
                                                       { IFOR();
				disable_503_translation=(yyvsp[0].intval); }
#line 4882 "cfg.tab.c"
    break;

  case 302: /* assign_stm: DISABLE_503_TRANSLATION EQUAL error  */
#line 1553 "cfg.y"
                                                      {
				yyerror("integer value expected");
				}
#line 4890 "cfg.tab.c"
    break;

  case 303: /* assign_stm: AUTO_SCALING_PROFILE EQUAL auto_scale_profile_def  */
#line 1556 "cfg.y"
                                                                    {}
#line 4896 "cfg.tab.c"
    break;

  case 304: /* assign_stm: AUTO_SCALING_PROFILE EQUAL error  */
#line 1557 "cfg.y"
                                                   {
				yyerror("bad auto-scaling profile definition");
				}
#line 4904 "cfg.tab.c"
    break;

  case 305: /* assign_stm: AUTO_SCALING_CYCLE EQUAL NUMBER  */
#line 1560 "cfg.y"
                                                  { IFOR();
				auto_scaling_cycle=(yyvsp[0].intval); }
#line 4911 "cfg.tab.c"
    break;

  case 306: /* assign_stm: AUTO_SCALING_CYCLE EQUAL error  */
#line 1562 "cfg.y"
                                                 {
				yyerror("integer value expected");
				}
#line 4919 "cfg.tab.c"
    break;

  case 307: /* assign_stm: error EQUAL  */
#line 1565 "cfg.y"
                              { yyerror("unknown config variable"); }
#line 4925 "cfg.tab.c"
    break;

  case 308: /* module_stm: LOADMODULE STRING  */
#line 1568 "cfg.y"
                                        { IFOR();
			if (load_module((yyvsp[0].strval)) < 0)
				yyerrorf("failed to load module %s\n", (yyvsp[0].strval));
		}
#line 4934 "cfg.tab.c"
    break;

  case 309: /* module_stm: LOADMODULE error  */
#line 1572 "cfg.y"
                                        { yyerror("string expected");  }
#line 4940 "cfg.tab.c"
    break;

  case 310: /* module_stm: MODPARAM LPAREN STRING COMMA STRING COMMA STRING RPAREN  */
#line 1573 "cfg.y"
                                                                          { IFOR();
				if (set_mod_param_regex((yyvsp[-5].strval), (yyvsp[-3].strval), STR_PARAM, (yyvsp[-1].strval)) != 0) {
					yyerrorf("Parameter <%s> not found in module <%s> - "
						"can't set", (yyvsp[-3].strval), (yyvsp[-5].strval));
				}
			}
#line 4951 "cfg.tab.c"
    break;

  case 311: /* module_stm: MODPARAM LPAREN STRING COMMA STRING COMMA folded_string RPAREN  */
#line 1579 "cfg.y"
                                                                                 { IFOR();
				if (set_mod_param_regex((yyvsp[-5].strval), (yyvsp[-3].strval), STR_PARAM, (yyvsp[-1].strval)) != 0) {
					yyerrorf("Parameter <%s> not found in module <%s> - "
						"can't set", (yyvsp[-3].strval), (yyvsp[-5].strval));
				}
			}
#line 4962 "cfg.tab.c"
    break;

  case 312: /* module_stm: MODPARAM LPAREN STRING COMMA STRING COMMA snumber RPAREN  */
#line 1585 "cfg.y"
                                                                           { IFOR();
				if (set_mod_param_regex((yyvsp[-5].strval), (yyvsp[-3].strval), INT_PARAM, (void*)(yyvsp[-1].intval)) != 0) {
					yyerrorf("Parameter <%s> not found in module <%s> - "
						"can't set", (yyvsp[-3].strval), (yyvsp[-5].strval));
				}
			}
#line 4973 "cfg.tab.c"
    break;

  case 313: /* module_stm: MODPARAM error  */
#line 1591 "cfg.y"
                                 { yyerror("Invalid arguments"); }
#line 4979 "cfg.tab.c"
    break;

  case 314: /* ip: ipv4  */
#line 1595 "cfg.y"
                       { (yyval.ipaddr)=(yyvsp[0].ipaddr); }
#line 4985 "cfg.tab.c"
    break;

  case 315: /* ip: ipv6  */
#line 1596 "cfg.y"
                       { (yyval.ipaddr)=(yyvsp[0].ipaddr); }
#line 4991 "cfg.tab.c"
    break;

  case 316: /* ipv4: IPV4ADDR  */
#line 1599 "cfg.y"
                 {
					(yyval.ipaddr)=pkg_malloc(sizeof(struct ip_addr));
					if ((yyval.ipaddr)==0){
						LM_CRIT("ERROR: cfg. parser: out of memory.\n");
						YYABORT;
					}else{
						memset((yyval.ipaddr), 0, sizeof(struct ip_addr));
						(yyval.ipaddr)->af=AF_INET;
						(yyval.ipaddr)->len=16;
						if (inet_pton(AF_INET, (yyvsp[0].strval), (yyval.ipaddr)->u.addr)<=0){
							yyerror("bad ipv4 address");
						}
					}
				}
#line 5010 "cfg.tab.c"
    break;

  case 317: /* ipv6addr: IPV6ADDR  */
#line 1615 "cfg.y"
                         {
					(yyval.ipaddr)=pkg_malloc(sizeof(struct ip_addr));
					if ((yyval.ipaddr)==0){
						LM_CRIT("ERROR: cfg. parser: out of memory.\n");
						YYABORT;
					}else{
						memset((yyval.ipaddr), 0, sizeof(struct ip_addr));
						(yyval.ipaddr)->af=AF_INET6;
						(yyval.ipaddr)->len=16;
						if (inet_pton(AF_INET6, (yyvsp[0].strval), (yyval.ipaddr)->u.addr)<=0){
							yyerror("bad ipv6 address");
						}
					}
				}
#line 5029 "cfg.tab.c"
    break;

  case 318: /* ipv6: ipv6addr  */
#line 1631 "cfg.y"
                 { (yyval.ipaddr)=(yyvsp[0].ipaddr); }
#line 5035 "cfg.tab.c"
    break;

  case 319: /* ipv6: LBRACK ipv6addr RBRACK  */
#line 1632 "cfg.y"
                                 {(yyval.ipaddr)=(yyvsp[-1].ipaddr); }
#line 5041 "cfg.tab.c"
    break;

  case 320: /* ipnet: IPNET  */
#line 1635 "cfg.y"
                {
				if (parse_ipnet((yyvsp[0].strval), strlen((yyvsp[0].strval)), &net_tmp) < 0)
					yyerror("unable to parse ip and/or netmask\n");

				(yyval.ipnet) = net_tmp;
			}
#line 5052 "cfg.tab.c"
    break;

  case 321: /* ipnet: ip  */
#line 1641 "cfg.y"
                        {
				(yyval.ipnet)=mk_net_bitlen((yyvsp[0].ipaddr), (yyvsp[0].ipaddr)->len*8);
				pkg_free((yyvsp[0].ipaddr));
			}
#line 5061 "cfg.tab.c"
    break;

  case 322: /* folded_string: STRING STRING  */
#line 1651 "cfg.y"
                              {
				(yyval.strval) = pkg_malloc( strlen((yyvsp[-1].strval)) + strlen((yyvsp[0].strval)) + 1);
				if ((yyval.strval)==0){
					yyerror("cfg. parser: out of memory");
					YYABORT;
				} else {
					strcpy((yyval.strval),(yyvsp[-1].strval)); strcat((yyval.strval),(yyvsp[0].strval));
					pkg_free((yyvsp[-1].strval)); pkg_free((yyvsp[0].strval));
				}
			}
#line 5076 "cfg.tab.c"
    break;

  case 323: /* folded_string: folded_string STRING  */
#line 1661 "cfg.y"
                                       {
				(yyval.strval) = pkg_malloc( strlen((yyvsp[-1].strval)) + strlen((yyvsp[0].strval)) + 1);
				if ((yyval.strval)==0){
					LM_CRIT("ERROR: cfg. parser: out of memory.\n");
					YYABORT;
				} else {
					strcpy((yyval.strval),(yyvsp[-1].strval)); strcat((yyval.strval),(yyvsp[0].strval));
					pkg_free((yyvsp[-1].strval)); pkg_free((yyvsp[0].strval));
				}
			}
#line 5091 "cfg.tab.c"
    break;

  case 324: /* route_name: ID  */
#line 1672 "cfg.y"
                {
				(yyval.strval) = (yyvsp[0].strval);
				}
#line 5099 "cfg.tab.c"
    break;

  case 325: /* route_name: NUMBER  */
#line 1675 "cfg.y"
                         {
				tmp=int2str((yyvsp[0].intval), &i_tmp);
				if (((yyval.strval)=pkg_malloc(i_tmp+1))==0) {
					yyerror("cfg. parser: out of memory.\n");
					YYABORT;
				}
				memcpy( (yyval.strval), tmp, i_tmp);
				(yyval.strval)[i_tmp] = 0;
				}
#line 5113 "cfg.tab.c"
    break;

  case 326: /* route_name: STRING  */
#line 1684 "cfg.y"
                        {
				(yyval.strval) = (yyvsp[0].strval);
		}
#line 5121 "cfg.tab.c"
    break;

  case 327: /* route_name_var: route_name  */
#line 1689 "cfg.y"
                           {
				/* check to see if there are any "$" in the string name */
				tmp = strchr((yyvsp[0].strval), '$');
				if (!tmp) {
					/* route name is a cosntant string - search for the route */
					rn_tmp.data = 0;
					rn_tmp.iname = get_script_route_idx((yyvsp[0].strval), sroutes->request,
							RT_NO, 0);
					if (rn_tmp.iname==-1)
						yyerror("too many script routes");
					(yyval.intval) = NUMBER_ST;
				} else {
					tstr.s = (yyvsp[0].strval);
					tstr.len = strlen(tstr.s);
					if (pv_parse_format(&tstr, &elem) < 0) {
						yyerror("cannot parse format");
						YYABORT;
					}
					/* the route name is a format, so we can't evaluate it now */
					rn_tmp.ename = elem;
					(yyval.intval) = SCRIPTVAR_ELEM_ST;
				}
			}
#line 5149 "cfg.tab.c"
    break;

  case 328: /* route_name_var: script_var  */
#line 1712 "cfg.y"
                             {
				rn_tmp.sname = (yyvsp[0].specval);
				(yyval.intval) = SCRIPTVAR_ST;
		}
#line 5158 "cfg.tab.c"
    break;

  case 329: /* route_stm: ROUTE LBRACE actions RBRACE  */
#line 1717 "cfg.y"
                                        {
						if (sroutes->request[DEFAULT_RT].a!=0) {
							yyerror("overwriting default "
								"request routing table");
							YYABORT;
						}
						push((yyvsp[-1].action), &sroutes->request[DEFAULT_RT].a);
					}
#line 5171 "cfg.tab.c"
    break;

  case 330: /* route_stm: ROUTE LBRACK route_name RBRACK LBRACE actions RBRACE  */
#line 1725 "cfg.y"
                                                                       {
						if ( strtol((yyvsp[-4].strval),&tmp,10)==0 && *tmp==0) {
							/* route[0] detected */
							if (sroutes->request[DEFAULT_RT].a!=0) {
								yyerror("overwriting(2) default "
									"request routing table");
								YYABORT;
							}
							push((yyvsp[-1].action), &sroutes->request[DEFAULT_RT].a);
						} else {
							i_tmp = get_script_route_idx( (yyvsp[-4].strval),
								sroutes->request, RT_NO,1);
							if (i_tmp==-1) YYABORT;
							push((yyvsp[-1].action), &sroutes->request[i_tmp].a);
						}
					}
#line 5192 "cfg.tab.c"
    break;

  case 331: /* route_stm: ROUTE error  */
#line 1741 "cfg.y"
                              { yyerror("invalid  route  statement"); }
#line 5198 "cfg.tab.c"
    break;

  case 332: /* failure_route_stm: ROUTE_FAILURE LBRACK route_name RBRACK LBRACE actions RBRACE  */
#line 1744 "cfg.y"
                                                                                {
						i_tmp = get_script_route_idx( (yyvsp[-4].strval), sroutes->failure,
							FAILURE_RT_NO,1);
						if (i_tmp==-1) YYABORT;
						push((yyvsp[-1].action), &sroutes->failure[i_tmp].a);
					}
#line 5209 "cfg.tab.c"
    break;

  case 333: /* failure_route_stm: ROUTE_FAILURE error  */
#line 1750 "cfg.y"
                                      { yyerror("invalid failure_route statement"); }
#line 5215 "cfg.tab.c"
    break;

  case 334: /* onreply_route_stm: ROUTE_ONREPLY LBRACE actions RBRACE  */
#line 1753 "cfg.y"
                                                       {
						if (sroutes->onreply[DEFAULT_RT].a!=0) {
							yyerror("overwriting default "
								"onreply routing table");
							YYABORT;
						}
						push((yyvsp[-1].action), &sroutes->onreply[DEFAULT_RT].a);
					}
#line 5228 "cfg.tab.c"
    break;

  case 335: /* onreply_route_stm: ROUTE_ONREPLY LBRACK route_name RBRACK LBRACE actions RBRACE  */
#line 1761 "cfg.y"
                                                                               {
						i_tmp = get_script_route_idx( (yyvsp[-4].strval), sroutes->onreply,
							ONREPLY_RT_NO,1);
						if (i_tmp==-1) YYABORT;
						push((yyvsp[-1].action), &sroutes->onreply[i_tmp].a);
					}
#line 5239 "cfg.tab.c"
    break;

  case 336: /* onreply_route_stm: ROUTE_ONREPLY error  */
#line 1767 "cfg.y"
                                      { yyerror("invalid onreply_route statement"); }
#line 5245 "cfg.tab.c"
    break;

  case 337: /* branch_route_stm: ROUTE_BRANCH LBRACK route_name RBRACK LBRACE actions RBRACE  */
#line 1770 "cfg.y"
                                                                              {
						i_tmp = get_script_route_idx( (yyvsp[-4].strval), sroutes->branch,
							BRANCH_RT_NO,1);
						if (i_tmp==-1) YYABORT;
						push((yyvsp[-1].action), &sroutes->branch[i_tmp].a);
					}
#line 5256 "cfg.tab.c"
    break;

  case 338: /* branch_route_stm: ROUTE_BRANCH error  */
#line 1776 "cfg.y"
                                     { yyerror("invalid branch_route statement"); }
#line 5262 "cfg.tab.c"
    break;

  case 339: /* error_route_stm: ROUTE_ERROR LBRACE actions RBRACE  */
#line 1779 "cfg.y"
                                                    {
						if (sroutes->error.a!=0) {
							yyerror("overwriting default "
								"error routing table");
							YYABORT;
						}
						push((yyvsp[-1].action), &sroutes->error.a);
					}
#line 5275 "cfg.tab.c"
    break;

  case 340: /* error_route_stm: ROUTE_ERROR error  */
#line 1787 "cfg.y"
                                    { yyerror("invalid error_route statement"); }
#line 5281 "cfg.tab.c"
    break;

  case 341: /* local_route_stm: ROUTE_LOCAL LBRACE actions RBRACE  */
#line 1790 "cfg.y"
                                                    {
						if (sroutes->local.a!=0) {
							yyerror("re-definition of local "
								"route detected");
							YYABORT;
						}
						push((yyvsp[-1].action), &sroutes->local.a);
					}
#line 5294 "cfg.tab.c"
    break;

  case 342: /* local_route_stm: ROUTE_LOCAL error  */
#line 1798 "cfg.y"
                                    { yyerror("invalid local_route statement"); }
#line 5300 "cfg.tab.c"
    break;

  case 343: /* startup_route_stm: ROUTE_STARTUP LBRACE actions RBRACE  */
#line 1801 "cfg.y"
                                                        {
						if (sroutes->startup.a!=0) {
							yyerror("re-definition of startup "
								"route detected");
							YYABORT;
						}
						push((yyvsp[-1].action), &sroutes->startup.a);
					}
#line 5313 "cfg.tab.c"
    break;

  case 344: /* startup_route_stm: ROUTE_STARTUP error  */
#line 1809 "cfg.y"
                                      { yyerror("invalid startup_route statement"); }
#line 5319 "cfg.tab.c"
    break;

  case 345: /* timer_route_stm: ROUTE_TIMER LBRACK route_name COMMA NUMBER RBRACK LBRACE actions RBRACE  */
#line 1812 "cfg.y"
                                                                                          {
						i_tmp = 0;
						while(i_tmp<TIMER_RT_NO && sroutes->timer[i_tmp].a!=0){
							i_tmp++;
						}
						if(i_tmp == TIMER_RT_NO) {
							yyerror("Too many timer routes defined\n");
							YYABORT;
						}
						sroutes->timer[i_tmp].name = (yyvsp[-6].strval);
						sroutes->timer[i_tmp].interval = (yyvsp[-4].intval);
						push((yyvsp[-1].action), &sroutes->timer[i_tmp].a);
					}
#line 5337 "cfg.tab.c"
    break;

  case 346: /* timer_route_stm: ROUTE_TIMER error  */
#line 1825 "cfg.y"
                                    { yyerror("invalid timer_route statement"); }
#line 5343 "cfg.tab.c"
    break;

  case 347: /* event_route_stm: ROUTE_EVENT LBRACK route_name RBRACK LBRACE actions RBRACE  */
#line 1828 "cfg.y"
                                                                            {
						i_tmp = get_script_route_idx((yyvsp[-4].strval), sroutes->event,
								EVENT_RT_NO,1);
						if (i_tmp==-1) YYABORT;
						push((yyvsp[-1].action), &sroutes->event[i_tmp].a);
					}
#line 5354 "cfg.tab.c"
    break;

  case 348: /* event_route_stm: ROUTE_EVENT error  */
#line 1834 "cfg.y"
                                    { yyerror("invalid event_route statement"); }
#line 5360 "cfg.tab.c"
    break;

  case 349: /* exp: exp AND exp  */
#line 1839 "cfg.y"
                        { (yyval.expr)=mk_exp(AND_OP, (yyvsp[-2].expr), (yyvsp[0].expr)); }
#line 5366 "cfg.tab.c"
    break;

  case 350: /* exp: exp OR exp  */
#line 1840 "cfg.y"
                                { (yyval.expr)=mk_exp(OR_OP, (yyvsp[-2].expr), (yyvsp[0].expr));  }
#line 5372 "cfg.tab.c"
    break;

  case 351: /* exp: NOT exp  */
#line 1841 "cfg.y"
                                        { (yyval.expr)=mk_exp(NOT_OP, (yyvsp[0].expr), 0);  }
#line 5378 "cfg.tab.c"
    break;

  case 352: /* exp: LPAREN exp RPAREN  */
#line 1842 "cfg.y"
                                { (yyval.expr)=mk_exp(EVAL_OP, (yyvsp[-1].expr), 0); }
#line 5384 "cfg.tab.c"
    break;

  case 353: /* exp: LBRACK assignexp RBRACK  */
#line 1843 "cfg.y"
                                  { (yyval.expr)=(yyvsp[-1].expr); }
#line 5390 "cfg.tab.c"
    break;

  case 354: /* exp: exp_elem  */
#line 1844 "cfg.y"
                                        { (yyval.expr)=(yyvsp[0].expr); }
#line 5396 "cfg.tab.c"
    break;

  case 355: /* equalop: EQUAL_T  */
#line 1847 "cfg.y"
                          {(yyval.intval)=EQUAL_OP; }
#line 5402 "cfg.tab.c"
    break;

  case 356: /* equalop: DIFF  */
#line 1848 "cfg.y"
                                {(yyval.intval)=DIFF_OP; }
#line 5408 "cfg.tab.c"
    break;

  case 357: /* compop: GT  */
#line 1851 "cfg.y"
                {(yyval.intval)=GT_OP; }
#line 5414 "cfg.tab.c"
    break;

  case 358: /* compop: LT  */
#line 1852 "cfg.y"
                        {(yyval.intval)=LT_OP; }
#line 5420 "cfg.tab.c"
    break;

  case 359: /* compop: GTE  */
#line 1853 "cfg.y"
                        {(yyval.intval)=GTE_OP; }
#line 5426 "cfg.tab.c"
    break;

  case 360: /* compop: LTE  */
#line 1854 "cfg.y"
                        {(yyval.intval)=LTE_OP; }
#line 5432 "cfg.tab.c"
    break;

  case 361: /* matchop: MATCH  */
#line 1856 "cfg.y"
                {(yyval.intval)=MATCH_OP; }
#line 5438 "cfg.tab.c"
    break;

  case 362: /* matchop: NOTMATCH  */
#line 1857 "cfg.y"
                                {(yyval.intval)=NOTMATCH_OP; }
#line 5444 "cfg.tab.c"
    break;

  case 363: /* intop: equalop  */
#line 1860 "cfg.y"
                {(yyval.intval)=(yyvsp[0].intval); }
#line 5450 "cfg.tab.c"
    break;

  case 364: /* intop: compop  */
#line 1861 "cfg.y"
                        {(yyval.intval)=(yyvsp[0].intval); }
#line 5456 "cfg.tab.c"
    break;

  case 365: /* strop: equalop  */
#line 1864 "cfg.y"
                {(yyval.intval)=(yyvsp[0].intval); }
#line 5462 "cfg.tab.c"
    break;

  case 366: /* strop: compop  */
#line 1865 "cfg.y"
                     {(yyval.intval)=(yyvsp[0].intval); }
#line 5468 "cfg.tab.c"
    break;

  case 367: /* strop: matchop  */
#line 1866 "cfg.y"
                                {(yyval.intval)=(yyvsp[0].intval); }
#line 5474 "cfg.tab.c"
    break;

  case 368: /* script_var: SCRIPTVAR  */
#line 1869 "cfg.y"
                                {
				spec = (pv_spec_t*)pkg_malloc(sizeof(pv_spec_t));
				if (spec==NULL){
					yyerror("no more pkg memory\n");
					YYABORT;
				}
				memset(spec, 0, sizeof(pv_spec_t));
				tstr.s = (yyvsp[0].strval);
				tstr.len = strlen(tstr.s);
				if(pv_parse_spec(&tstr, spec)==NULL)
				{
					yyerror("unknown script variable");
				}

				(yyval.specval) = spec;
			}
#line 5495 "cfg.tab.c"
    break;

  case 369: /* script_var: SCRIPTVARERR  */
#line 1885 "cfg.y"
                               {
			(yyval.specval)=0; yyerror("invalid script variable name");
		}
#line 5503 "cfg.tab.c"
    break;

  case 370: /* exp_elem: exp_cond  */
#line 1890 "cfg.y"
                                {(yyval.expr)=(yyvsp[0].expr); }
#line 5509 "cfg.tab.c"
    break;

  case 371: /* exp_elem: exp_stm  */
#line 1891 "cfg.y"
                                        {(yyval.expr)=mk_elem( NO_OP, ACTION_O, 0, ACTIONS_ST, (yyvsp[0].action) ); }
#line 5515 "cfg.tab.c"
    break;

  case 372: /* exp_elem: snumber  */
#line 1892 "cfg.y"
                                        {(yyval.expr)=mk_elem( NO_OP, NUMBER_O, 0, NUMBER_ST,
											(void*)(yyvsp[0].intval) ); }
#line 5522 "cfg.tab.c"
    break;

  case 373: /* exp_elem: script_var  */
#line 1894 "cfg.y"
                                {
				(yyval.expr)=mk_elem(NO_OP, SCRIPTVAR_O,0,SCRIPTVAR_ST,(void*)(yyvsp[0].specval));
			}
#line 5530 "cfg.tab.c"
    break;

  case 374: /* exp_cond: script_var strop script_var  */
#line 1899 "cfg.y"
                                      {
				(yyval.expr)=mk_elem( (yyvsp[-1].intval), SCRIPTVAR_O,(void*)(yyvsp[-2].specval),SCRIPTVAR_ST,(void*)(yyvsp[0].specval));
			}
#line 5538 "cfg.tab.c"
    break;

  case 375: /* exp_cond: script_var strop STRING  */
#line 1902 "cfg.y"
                                          {
				(yyval.expr)=mk_elem( (yyvsp[-1].intval), SCRIPTVAR_O,(void*)(yyvsp[-2].specval),STR_ST,(yyvsp[0].strval));
			}
#line 5546 "cfg.tab.c"
    break;

  case 376: /* exp_cond: script_var intop snumber  */
#line 1905 "cfg.y"
                                           {
				(yyval.expr)=mk_elem( (yyvsp[-1].intval), SCRIPTVAR_O,(void*)(yyvsp[-2].specval),NUMBER_ST,(void *)(yyvsp[0].intval));
			}
#line 5554 "cfg.tab.c"
    break;

  case 377: /* exp_cond: script_var equalop NULLV  */
#line 1908 "cfg.y"
                                                {
				(yyval.expr)=mk_elem( (yyvsp[-1].intval), SCRIPTVAR_O,(void*)(yyvsp[-2].specval), NULLV_ST, 0);
			}
#line 5562 "cfg.tab.c"
    break;

  case 378: /* exp_cond: script_var equalop ipnet  */
#line 1911 "cfg.y"
                                           {
				(yyval.expr)=mk_elem((yyvsp[-1].intval), SCRIPTVAR_O, (void*)(yyvsp[-2].specval), NET_ST, (yyvsp[0].ipnet));
			}
#line 5570 "cfg.tab.c"
    break;

  case 379: /* assignop: EQUAL  */
#line 1917 "cfg.y"
              { (yyval.intval) = EQ_T; }
#line 5576 "cfg.tab.c"
    break;

  case 380: /* assignop: COLONEQ  */
#line 1918 "cfg.y"
                  { (yyval.intval) = COLONEQ_T; }
#line 5582 "cfg.tab.c"
    break;

  case 381: /* assignop: PLUSEQ  */
#line 1919 "cfg.y"
                 { (yyval.intval) = PLUSEQ_T; }
#line 5588 "cfg.tab.c"
    break;

  case 382: /* assignop: MINUSEQ  */
#line 1920 "cfg.y"
                  { (yyval.intval) = MINUSEQ_T;}
#line 5594 "cfg.tab.c"
    break;

  case 383: /* assignop: SLASHEQ  */
#line 1921 "cfg.y"
                  { (yyval.intval) = DIVEQ_T; }
#line 5600 "cfg.tab.c"
    break;

  case 384: /* assignop: MULTEQ  */
#line 1922 "cfg.y"
                 { (yyval.intval) = MULTEQ_T; }
#line 5606 "cfg.tab.c"
    break;

  case 385: /* assignop: MODULOEQ  */
#line 1923 "cfg.y"
                   { (yyval.intval) = MODULOEQ_T; }
#line 5612 "cfg.tab.c"
    break;

  case 386: /* assignop: BANDEQ  */
#line 1924 "cfg.y"
                 { (yyval.intval) = BANDEQ_T; }
#line 5618 "cfg.tab.c"
    break;

  case 387: /* assignop: BOREQ  */
#line 1925 "cfg.y"
                { (yyval.intval) = BOREQ_T; }
#line 5624 "cfg.tab.c"
    break;

  case 388: /* assignop: BXOREQ  */
#line 1926 "cfg.y"
                 { (yyval.intval) = BXOREQ_T; }
#line 5630 "cfg.tab.c"
    break;

  case 389: /* assignexp: snumber  */
#line 1930 "cfg.y"
                { (yyval.expr) = mk_elem(VALUE_OP, NUMBERV_O, (void*)(yyvsp[0].intval), 0, 0); }
#line 5636 "cfg.tab.c"
    break;

  case 390: /* assignexp: STRING  */
#line 1931 "cfg.y"
                 { (yyval.expr) = mk_elem(VALUE_OP, STRINGV_O, (yyvsp[0].strval), 0, 0); }
#line 5642 "cfg.tab.c"
    break;

  case 391: /* assignexp: script_var  */
#line 1932 "cfg.y"
                     { (yyval.expr) = mk_elem(VALUE_OP, SCRIPTVAR_O, (yyvsp[0].specval), 0, 0); }
#line 5648 "cfg.tab.c"
    break;

  case 392: /* assignexp: exp_cond  */
#line 1933 "cfg.y"
                   { (yyval.expr)= (yyvsp[0].expr); }
#line 5654 "cfg.tab.c"
    break;

  case 393: /* assignexp: cmd  */
#line 1934 "cfg.y"
              { (yyval.expr)=mk_elem( NO_OP, ACTION_O, 0, ACTIONS_ST, (yyvsp[0].action) ); }
#line 5660 "cfg.tab.c"
    break;

  case 394: /* assignexp: assignexp PLUS assignexp  */
#line 1935 "cfg.y"
                                   {
				(yyval.expr) = mk_elem(PLUS_OP, EXPR_O, (yyvsp[-2].expr), EXPR_ST, (yyvsp[0].expr));
			}
#line 5668 "cfg.tab.c"
    break;

  case 395: /* assignexp: assignexp MINUS assignexp  */
#line 1938 "cfg.y"
                                    {
				(yyval.expr) = mk_elem(MINUS_OP, EXPR_O, (yyvsp[-2].expr), EXPR_ST, (yyvsp[0].expr));
			}
#line 5676 "cfg.tab.c"
    break;

  case 396: /* assignexp: assignexp MULT assignexp  */
#line 1941 "cfg.y"
                                   {
				(yyval.expr) = mk_elem(MULT_OP, EXPR_O, (yyvsp[-2].expr), EXPR_ST, (yyvsp[0].expr));
			}
#line 5684 "cfg.tab.c"
    break;

  case 397: /* assignexp: assignexp SLASH assignexp  */
#line 1944 "cfg.y"
                                    {
				(yyval.expr) = mk_elem(DIV_OP, EXPR_O, (yyvsp[-2].expr), EXPR_ST, (yyvsp[0].expr));
			}
#line 5692 "cfg.tab.c"
    break;

  case 398: /* assignexp: assignexp MODULO assignexp  */
#line 1947 "cfg.y"
                                     {
				(yyval.expr) = mk_elem(MODULO_OP, EXPR_O, (yyvsp[-2].expr), EXPR_ST, (yyvsp[0].expr));
			}
#line 5700 "cfg.tab.c"
    break;

  case 399: /* assignexp: assignexp BAND assignexp  */
#line 1950 "cfg.y"
                                   {
				(yyval.expr) = mk_elem(BAND_OP, EXPR_O, (yyvsp[-2].expr), EXPR_ST, (yyvsp[0].expr));
			}
#line 5708 "cfg.tab.c"
    break;

  case 400: /* assignexp: assignexp BOR assignexp  */
#line 1953 "cfg.y"
                                  {
				(yyval.expr) = mk_elem(BOR_OP, EXPR_O, (yyvsp[-2].expr), EXPR_ST, (yyvsp[0].expr));
			}
#line 5716 "cfg.tab.c"
    break;

  case 401: /* assignexp: assignexp BXOR assignexp  */
#line 1956 "cfg.y"
                                   {
				(yyval.expr) = mk_elem(BXOR_OP, EXPR_O, (yyvsp[-2].expr), EXPR_ST, (yyvsp[0].expr));
			}
#line 5724 "cfg.tab.c"
    break;

  case 402: /* assignexp: assignexp BLSHIFT assignexp  */
#line 1959 "cfg.y"
                                      {
				(yyval.expr) = mk_elem(BLSHIFT_OP, EXPR_O, (yyvsp[-2].expr), EXPR_ST, (yyvsp[0].expr));
			}
#line 5732 "cfg.tab.c"
    break;

  case 403: /* assignexp: assignexp BRSHIFT assignexp  */
#line 1962 "cfg.y"
                                      {
				(yyval.expr) = mk_elem(BRSHIFT_OP, EXPR_O, (yyvsp[-2].expr), EXPR_ST, (yyvsp[0].expr));
			}
#line 5740 "cfg.tab.c"
    break;

  case 404: /* assignexp: BNOT assignexp  */
#line 1965 "cfg.y"
                         {
				(yyval.expr) = mk_elem(BNOT_OP, EXPR_O, (yyvsp[0].expr), 0, 0);
			}
#line 5748 "cfg.tab.c"
    break;

  case 405: /* assignexp: LPAREN assignexp RPAREN  */
#line 1968 "cfg.y"
                                  { (yyval.expr) = (yyvsp[-1].expr); }
#line 5754 "cfg.tab.c"
    break;

  case 406: /* assign_cmd: script_var assignop assignexp  */
#line 1971 "cfg.y"
                                          {
			if(!pv_is_w((yyvsp[-2].specval)))
				yyerror("invalid left operand in assignment");
			if((yyvsp[-2].specval)->trans!=0)
				yyerror("transformations not accepted in left side "
					"of assignment");

			mk_action2( (yyval.action), (yyvsp[-1].intval),
					SCRIPTVAR_ST,
					EXPR_ST,
					(yyvsp[-2].specval),
					(yyvsp[0].expr));
		}
#line 5772 "cfg.tab.c"
    break;

  case 407: /* assign_cmd: script_var EQUAL NULLV  */
#line 1984 "cfg.y"
                                  {
			if(!pv_is_w((yyvsp[-2].specval)))
				yyerror("invalid left operand in assignment");
			if((yyvsp[-2].specval)->trans!=0)
				yyerror("transformations not accepted in left side "
					"of assignment");

			mk_action2( (yyval.action), EQ_T,
					SCRIPTVAR_ST,
					NULLV_ST,
					(yyvsp[-2].specval),
					0);
		}
#line 5790 "cfg.tab.c"
    break;

  case 408: /* assign_cmd: script_var COLONEQ NULLV  */
#line 1997 "cfg.y"
                                    {
			if(!pv_is_w((yyvsp[-2].specval)))
				yyerror("invalid left operand in assignment");
			/* not all can get NULL with := */
			switch((yyvsp[-2].specval)->type) {
				case PVT_AVP:
				break;
				default:
					yyerror("invalid left operand in NULL assignment");
			}
			if((yyvsp[-2].specval)->trans!=0)
				yyerror("transformations not accepted in left side "
					"of assignment");

			mk_action2( (yyval.action), COLONEQ_T,
					SCRIPTVAR_ST,
					NULLV_ST,
					(yyvsp[-2].specval),
					0);
		}
#line 5815 "cfg.tab.c"
    break;

  case 409: /* exp_stm: cmd  */
#line 2019 "cfg.y"
                                                                { (yyval.action)=(yyvsp[0].action); }
#line 5821 "cfg.tab.c"
    break;

  case 410: /* exp_stm: if_cmd  */
#line 2020 "cfg.y"
                                                                { (yyval.action)=(yyvsp[0].action); }
#line 5827 "cfg.tab.c"
    break;

  case 411: /* exp_stm: assign_cmd  */
#line 2021 "cfg.y"
                                                                { (yyval.action)=(yyvsp[0].action); }
#line 5833 "cfg.tab.c"
    break;

  case 412: /* exp_stm: LBRACE actions RBRACE  */
#line 2022 "cfg.y"
                                                { (yyval.action)=(yyvsp[-1].action); }
#line 5839 "cfg.tab.c"
    break;

  case 413: /* exp_stm: LBRACE RBRACE  */
#line 2023 "cfg.y"
                                                        { (yyval.action)=0; }
#line 5845 "cfg.tab.c"
    break;

  case 414: /* brk_stm: brk_action  */
#line 2026 "cfg.y"
                                                                { (yyval.action)=(yyvsp[0].action); }
#line 5851 "cfg.tab.c"
    break;

  case 415: /* brk_stm: LBRACE brk_actions RBRACE  */
#line 2027 "cfg.y"
                                                        { (yyval.action)=(yyvsp[-1].action); }
#line 5857 "cfg.tab.c"
    break;

  case 416: /* brk_stm: LBRACE RBRACE  */
#line 2028 "cfg.y"
                                                        { (yyval.action)=0; }
#line 5863 "cfg.tab.c"
    break;

  case 417: /* stm: action  */
#line 2031 "cfg.y"
                                                        { (yyval.action)=(yyvsp[0].action); }
#line 5869 "cfg.tab.c"
    break;

  case 418: /* stm: LBRACE actions RBRACE  */
#line 2032 "cfg.y"
                                                { (yyval.action)=(yyvsp[-1].action); }
#line 5875 "cfg.tab.c"
    break;

  case 419: /* stm: LBRACE RBRACE  */
#line 2033 "cfg.y"
                                                        { (yyval.action)=0; }
#line 5881 "cfg.tab.c"
    break;

  case 420: /* actions: actions action  */
#line 2036 "cfg.y"
                                {(yyval.action)=append_action((yyvsp[-1].action), (yyvsp[0].action)); }
#line 5887 "cfg.tab.c"
    break;

  case 421: /* actions: action  */
#line 2037 "cfg.y"
                                                {(yyval.action)=(yyvsp[0].action);}
#line 5893 "cfg.tab.c"
    break;

  case 422: /* actions: actions error  */
#line 2038 "cfg.y"
                                { (yyval.action)=0; yyerror("bad command!)"); }
#line 5899 "cfg.tab.c"
    break;

  case 423: /* brk_actions: brk_actions brk_action  */
#line 2042 "cfg.y"
                                        {(yyval.action)=append_action((yyvsp[-1].action), (yyvsp[0].action)); }
#line 5905 "cfg.tab.c"
    break;

  case 424: /* brk_actions: brk_action  */
#line 2043 "cfg.y"
                                                {(yyval.action)=(yyvsp[0].action);}
#line 5911 "cfg.tab.c"
    break;

  case 425: /* brk_actions: brk_actions error  */
#line 2044 "cfg.y"
                                    { (yyval.action)=0; yyerror("bad command!)"); }
#line 5917 "cfg.tab.c"
    break;

  case 426: /* action: cmd SEMICOLON  */
#line 2047 "cfg.y"
                              {(yyval.action)=(yyvsp[-1].action);}
#line 5923 "cfg.tab.c"
    break;

  case 427: /* action: if_cmd  */
#line 2048 "cfg.y"
                         {(yyval.action)=(yyvsp[0].action);}
#line 5929 "cfg.tab.c"
    break;

  case 428: /* action: while_cmd  */
#line 2049 "cfg.y"
                            {(yyval.action)=(yyvsp[0].action);}
#line 5935 "cfg.tab.c"
    break;

  case 429: /* action: foreach_cmd  */
#line 2050 "cfg.y"
                              {(yyval.action)=(yyvsp[0].action);}
#line 5941 "cfg.tab.c"
    break;

  case 430: /* action: switch_cmd  */
#line 2051 "cfg.y"
                             {(yyval.action)=(yyvsp[0].action);}
#line 5947 "cfg.tab.c"
    break;

  case 431: /* action: assign_cmd SEMICOLON  */
#line 2052 "cfg.y"
                                       {(yyval.action)=(yyvsp[-1].action);}
#line 5953 "cfg.tab.c"
    break;

  case 432: /* action: SEMICOLON  */
#line 2053 "cfg.y"
                                              {(yyval.action)=0;}
#line 5959 "cfg.tab.c"
    break;

  case 433: /* action: cmd error  */
#line 2054 "cfg.y"
                            { (yyval.action)=0; yyerror("bad command: missing ';'?"); }
#line 5965 "cfg.tab.c"
    break;

  case 434: /* brk_action: BREAK SEMICOLON  */
#line 2057 "cfg.y"
                            { mk_action0((yyval.action), BREAK_T);}
#line 5971 "cfg.tab.c"
    break;

  case 435: /* brk_action: cmd SEMICOLON  */
#line 2058 "cfg.y"
                                {(yyval.action)=(yyvsp[-1].action);}
#line 5977 "cfg.tab.c"
    break;

  case 436: /* brk_action: brk_if_cmd  */
#line 2059 "cfg.y"
                             {(yyval.action)=(yyvsp[0].action);}
#line 5983 "cfg.tab.c"
    break;

  case 437: /* brk_action: while_cmd  */
#line 2060 "cfg.y"
                            {(yyval.action)=(yyvsp[0].action);}
#line 5989 "cfg.tab.c"
    break;

  case 438: /* brk_action: foreach_cmd  */
#line 2061 "cfg.y"
                              {(yyval.action)=(yyvsp[0].action);}
#line 5995 "cfg.tab.c"
    break;

  case 439: /* brk_action: switch_cmd  */
#line 2062 "cfg.y"
                             {(yyval.action)=(yyvsp[0].action);}
#line 6001 "cfg.tab.c"
    break;

  case 440: /* brk_action: assign_cmd SEMICOLON  */
#line 2063 "cfg.y"
                                       {(yyval.action)=(yyvsp[-1].action);}
#line 6007 "cfg.tab.c"
    break;

  case 441: /* brk_action: SEMICOLON  */
#line 2064 "cfg.y"
                                              {(yyval.action)=0;}
#line 6013 "cfg.tab.c"
    break;

  case 442: /* brk_action: cmd error  */
#line 2065 "cfg.y"
                            { (yyval.action)=0; yyerror("bad command: missing ';'?"); }
#line 6019 "cfg.tab.c"
    break;

  case 443: /* brk_if_cmd: IF LPAREN exp RPAREN brk_stm  */
#line 2068 "cfg.y"
                                                                { mk_action3( (yyval.action), IF_T,
													 EXPR_ST,
													 ACTIONS_ST,
													 NOSUBTYPE,
													 (yyvsp[-2].expr),
													 (yyvsp[0].action),
													 0);
									}
#line 6032 "cfg.tab.c"
    break;

  case 444: /* brk_if_cmd: IF LPAREN exp RPAREN brk_stm ELSE brk_stm  */
#line 2076 "cfg.y"
                                                                        { mk_action3( (yyval.action), IF_T,
													 EXPR_ST,
													 ACTIONS_ST,
													 ACTIONS_ST,
													 (yyvsp[-4].expr),
													 (yyvsp[-2].action),
													 (yyvsp[0].action));
									}
#line 6045 "cfg.tab.c"
    break;

  case 445: /* if_cmd: IF LPAREN exp RPAREN stm  */
#line 2086 "cfg.y"
                                                                        { mk_action3( (yyval.action), IF_T,
													 EXPR_ST,
													 ACTIONS_ST,
													 NOSUBTYPE,
													 (yyvsp[-2].expr),
													 (yyvsp[0].action),
													 0);
									}
#line 6058 "cfg.tab.c"
    break;

  case 446: /* if_cmd: IF LPAREN exp RPAREN stm ELSE stm  */
#line 2094 "cfg.y"
                                                                { mk_action3( (yyval.action), IF_T,
													 EXPR_ST,
													 ACTIONS_ST,
													 ACTIONS_ST,
													 (yyvsp[-4].expr),
													 (yyvsp[-2].action),
													 (yyvsp[0].action));
									}
#line 6071 "cfg.tab.c"
    break;

  case 447: /* while_cmd: WHILE LPAREN exp RPAREN brk_stm  */
#line 2104 "cfg.y"
                                                        { mk_action2( (yyval.action), WHILE_T,
													 EXPR_ST,
													 ACTIONS_ST,
													 (yyvsp[-2].expr),
													 (yyvsp[0].action));
									}
#line 6082 "cfg.tab.c"
    break;

  case 448: /* foreach_cmd: FOR LPAREN script_var IN script_var RPAREN brk_stm  */
#line 2112 "cfg.y"
                                                                   {
					if ((yyvsp[-4].specval)->type != PVT_SCRIPTVAR &&
					    (yyvsp[-4].specval)->type != PVT_AVP &&
						pv_type((yyvsp[-4].specval)->type) != PVT_JSON) {
						yyerror("\nfor-each statement: only \"var\", \"avp\" "
					            "and \"json\" iterators are supported!");
					}

					mk_action3( (yyval.action), FOR_EACH_T,
					            SCRIPTVAR_ST,
					            SCRIPTVAR_ST,
					            ACTIONS_ST,
					            (yyvsp[-4].specval),
					            (yyvsp[-2].specval),
					            (yyvsp[0].action));
					}
#line 6103 "cfg.tab.c"
    break;

  case 449: /* switch_cmd: SWITCH LPAREN script_var RPAREN LBRACE switch_stm RBRACE  */
#line 2130 "cfg.y"
                                                                                        {
											mk_action2( (yyval.action), SWITCH_T,
														SCRIPTVAR_ST,
														ACTIONS_ST,
														(yyvsp[-4].specval),
														(yyvsp[-1].action));
									}
#line 6115 "cfg.tab.c"
    break;

  case 450: /* switch_stm: case_stms default_stm  */
#line 2139 "cfg.y"
                                  { (yyval.action)=append_action((yyvsp[-1].action), (yyvsp[0].action)); }
#line 6121 "cfg.tab.c"
    break;

  case 451: /* switch_stm: case_stms  */
#line 2140 "cfg.y"
                                                { (yyval.action)=(yyvsp[0].action); }
#line 6127 "cfg.tab.c"
    break;

  case 452: /* case_stms: case_stms case_stm  */
#line 2142 "cfg.y"
                                        {(yyval.action)=append_action((yyvsp[-1].action), (yyvsp[0].action)); }
#line 6133 "cfg.tab.c"
    break;

  case 453: /* case_stms: case_stm  */
#line 2143 "cfg.y"
                                                {(yyval.action)=(yyvsp[0].action);}
#line 6139 "cfg.tab.c"
    break;

  case 454: /* case_stm: CASE snumber COLON brk_actions  */
#line 2146 "cfg.y"
                                         { mk_action2( (yyval.action), CASE_T,
													NUMBER_ST,
													ACTIONS_ST,
													(void*)(yyvsp[-2].intval),
													(yyvsp[0].action));
											}
#line 6150 "cfg.tab.c"
    break;

  case 455: /* case_stm: CASE snumber COLON  */
#line 2152 "cfg.y"
                                     { mk_action2( (yyval.action), CASE_T,
													NUMBER_ST,
													ACTIONS_ST,
													(void*)(yyvsp[-1].intval),
													NULL);
							}
#line 6161 "cfg.tab.c"
    break;

  case 456: /* case_stm: CASE STRING COLON brk_actions  */
#line 2158 "cfg.y"
                                                { mk_action2( (yyval.action), CASE_T,
													STR_ST,
													ACTIONS_ST,
													(void*)(yyvsp[-2].strval),
													(yyvsp[0].action));
											}
#line 6172 "cfg.tab.c"
    break;

  case 457: /* case_stm: CASE STRING COLON  */
#line 2164 "cfg.y"
                                    { mk_action2( (yyval.action), CASE_T,
													STR_ST,
													ACTIONS_ST,
													(void*)(yyvsp[-1].strval),
													NULL);
							}
#line 6183 "cfg.tab.c"
    break;

  case 458: /* default_stm: DEFAULT COLON brk_actions  */
#line 2172 "cfg.y"
                                       { mk_action1( (yyval.action), DEFAULT_T,
													ACTIONS_ST, (yyvsp[0].action));
									}
#line 6191 "cfg.tab.c"
    break;

  case 459: /* default_stm: DEFAULT COLON  */
#line 2175 "cfg.y"
                                { mk_action1( (yyval.action), DEFAULT_T, ACTIONS_ST, NULL); }
#line 6197 "cfg.tab.c"
    break;

  case 460: /* func_param: STRING  */
#line 2178 "cfg.y"
                   {
										elems[1].type = STR_ST;
										elems[1].u.data = (yyvsp[0].strval);
										(yyval.intval)=1;
										}
#line 6207 "cfg.tab.c"
    break;

  case 461: /* func_param: func_param COMMA STRING  */
#line 2183 "cfg.y"
                                          {
										if ((yyvsp[-2].intval)+1>=MAX_ACTION_ELEMS) {
											yyerror("too many arguments "
												"in function\n");
											(yyval.intval)=0;
										}
										elems[(yyvsp[-2].intval)+1].type = STR_ST;
										elems[(yyvsp[-2].intval)+1].u.data = (yyvsp[0].strval);
										(yyval.intval)=(yyvsp[-2].intval)+1;
										}
#line 6222 "cfg.tab.c"
    break;

  case 462: /* func_param: COMMA  */
#line 2193 "cfg.y"
                        {
										elems[1].type = NULLV_ST;
										elems[1].u.data = NULL;
										elems[2].type = NULLV_ST;
										elems[2].u.data = NULL;
										(yyval.intval)=2;
										}
#line 6234 "cfg.tab.c"
    break;

  case 463: /* func_param: COMMA STRING  */
#line 2200 "cfg.y"
                               {
										elems[1].type = NULLV_ST;
										elems[1].u.data = NULL;
										elems[2].type = STR_ST;
										elems[2].u.data = (yyvsp[0].strval);
										(yyval.intval)=2;
										}
#line 6246 "cfg.tab.c"
    break;

  case 464: /* func_param: func_param COMMA  */
#line 2207 "cfg.y"
                                   {
										if ((yyvsp[-1].intval)+1>=MAX_ACTION_ELEMS) {
											yyerror("too many arguments "
												"in function\n");
											(yyval.intval)=0;
										}
										elems[(yyvsp[-1].intval)+1].type = NULLV_ST;
										elems[(yyvsp[-1].intval)+1].u.data = NULL;
										(yyval.intval)=(yyvsp[-1].intval)+1;
										}
#line 6261 "cfg.tab.c"
    break;

  case 465: /* func_param: snumber  */
#line 2217 "cfg.y"
                          {
										elems[1].type = NUMBER_ST;
										elems[1].u.number = (yyvsp[0].intval);
										(yyval.intval)=1;
										}
#line 6271 "cfg.tab.c"
    break;

  case 466: /* func_param: COMMA snumber  */
#line 2222 "cfg.y"
                                {
										elems[1].type = NULLV_ST;
										elems[1].u.data = NULL;
										elems[2].type = NUMBER_ST;
										elems[2].u.number = (yyvsp[0].intval);
										(yyval.intval)=2;
										}
#line 6283 "cfg.tab.c"
    break;

  case 467: /* func_param: func_param COMMA snumber  */
#line 2229 "cfg.y"
                                           {
										if ((yyvsp[-2].intval)+1>=MAX_ACTION_ELEMS) {
											yyerror("too many arguments "
												"in function\n");
											(yyval.intval)=0;
										}
										elems[(yyvsp[-2].intval)+1].type = NUMBER_ST;
										elems[(yyvsp[-2].intval)+1].u.number = (yyvsp[0].intval);
										(yyval.intval)=(yyvsp[-2].intval)+1;
										}
#line 6298 "cfg.tab.c"
    break;

  case 468: /* func_param: script_var  */
#line 2239 "cfg.y"
                             {
										elems[1].type = SCRIPTVAR_ST;
										elems[1].u.data = (yyvsp[0].specval);
										(yyval.intval)=1;
										}
#line 6308 "cfg.tab.c"
    break;

  case 469: /* func_param: COMMA script_var  */
#line 2244 "cfg.y"
                                   {
										elems[1].type = NULLV_ST;
										elems[1].u.data = NULL;
										elems[2].type = SCRIPTVAR_ST;
										elems[2].u.data = (yyvsp[0].specval);
										(yyval.intval)=2;
										}
#line 6320 "cfg.tab.c"
    break;

  case 470: /* func_param: func_param COMMA script_var  */
#line 2251 "cfg.y"
                                              {
										if ((yyvsp[-2].intval)+1>=MAX_ACTION_ELEMS) {
											yyerror("too many arguments "
												"in function\n");
											(yyval.intval)=0;
										}
										elems[(yyvsp[-2].intval)+1].type = SCRIPTVAR_ST;
										elems[(yyvsp[-2].intval)+1].u.data = (yyvsp[0].specval);
										(yyval.intval)=(yyvsp[-2].intval)+1;
										}
#line 6335 "cfg.tab.c"
    break;

  case 471: /* route_param: STRING  */
#line 2263 "cfg.y"
                    {
						route_elems[0].type = STRING_ST;
						route_elems[0].u.string = (yyvsp[0].strval);
						(yyval.intval)=1;
			}
#line 6345 "cfg.tab.c"
    break;

  case 472: /* route_param: snumber  */
#line 2268 "cfg.y"
                          {
						route_elems[0].type = NUMBER_ST;
						route_elems[0].u.number = (long)(yyvsp[0].intval);
						(yyval.intval)=1;
			}
#line 6355 "cfg.tab.c"
    break;

  case 473: /* route_param: NULLV  */
#line 2273 "cfg.y"
                        {
						route_elems[0].type = NULLV_ST;
						route_elems[0].u.data = 0;
						(yyval.intval)=1;
			}
#line 6365 "cfg.tab.c"
    break;

  case 474: /* route_param: script_var  */
#line 2278 "cfg.y"
                             {
						route_elems[0].type = SCRIPTVAR_ST;
						route_elems[0].u.data = (yyvsp[0].specval);
						(yyval.intval)=1;
			}
#line 6375 "cfg.tab.c"
    break;

  case 475: /* route_param: route_param COMMA STRING  */
#line 2283 "cfg.y"
                                           {
						if ((yyvsp[-2].intval)>=MAX_ACTION_ELEMS) {
							yyerror("too many arguments in function\n");
							(yyval.intval)=-1;
						} else {
							route_elems[(yyvsp[-2].intval)].type = STRING_ST;
							route_elems[(yyvsp[-2].intval)].u.data = (yyvsp[0].strval);
							(yyval.intval)=(yyvsp[-2].intval)+1;
						}
			}
#line 6390 "cfg.tab.c"
    break;

  case 476: /* route_param: route_param COMMA snumber  */
#line 2293 "cfg.y"
                                            {
						if ((yyvsp[-2].intval)>=MAX_ACTION_ELEMS) {
							yyerror("too many arguments in function\n");
							(yyval.intval)=-1;
						} else {
							route_elems[(yyvsp[-2].intval)].type = NUMBER_ST;
							route_elems[(yyvsp[-2].intval)].u.data = (void*)(long)(yyvsp[0].intval);
							(yyval.intval)=(yyvsp[-2].intval)+1;
						}
			}
#line 6405 "cfg.tab.c"
    break;

  case 477: /* route_param: route_param COMMA script_var  */
#line 2303 "cfg.y"
                                               {
						if ((yyvsp[-2].intval)+1>=MAX_ACTION_ELEMS) {
							yyerror("too many arguments in function\n");
							(yyval.intval)=-1;
						} else {
							route_elems[(yyvsp[-2].intval)].type = SCRIPTVAR_ST;
							route_elems[(yyvsp[-2].intval)].u.data = (yyvsp[0].specval);
							(yyval.intval)=(yyvsp[-2].intval)+1;
						}
			}
#line 6420 "cfg.tab.c"
    break;

  case 478: /* route_param: route_param COMMA NULLV  */
#line 2313 "cfg.y"
                                          {
						if ((yyvsp[-2].intval)+1>=MAX_ACTION_ELEMS) {
							yyerror("too many arguments in function\n");
							(yyval.intval)=-1;
						} else {
							route_elems[(yyvsp[-2].intval)].type = NULLV_ST;
							route_elems[(yyvsp[-2].intval)].u.data = 0;
							(yyval.intval)=(yyvsp[-2].intval)+1;
						}
			}
#line 6435 "cfg.tab.c"
    break;

  case 479: /* async_func: ID LPAREN RPAREN  */
#line 2325 "cfg.y"
                             {
				const acmd_export_t* acmd_tmp=find_mod_acmd_export_t((yyvsp[-2].strval));
				if (acmd_tmp==0){
					yyerrorf("unknown async command <%s>, "
						"missing loadmodule?", (yyvsp[-2].strval));
					(yyval.action)=0;
				}else{
					if (check_acmd_call_params(acmd_tmp,elems,0)<0) {
						yyerrorf("too few parameters "
							"for command <%s>\n", (yyvsp[-2].strval));
						(yyval.action)=0;
					} else {
						elems[0].type = ACMD_ST;
						elems[0].u.data_const = acmd_tmp;
						mk_action_((yyval.action), AMODULE_T, 1, elems);
					}
				}
			}
#line 6458 "cfg.tab.c"
    break;

  case 480: /* async_func: ID LPAREN func_param RPAREN  */
#line 2343 "cfg.y"
                                                      {
				const acmd_export_t* acmd_tmp=find_mod_acmd_export_t((yyvsp[-3].strval));
				if (acmd_tmp==0){
					yyerrorf("unknown async command <%s>, "
						"missing loadmodule?", (yyvsp[-3].strval));
					(yyval.action)=0;
				}else{
					rc = check_acmd_call_params(acmd_tmp,elems,(yyvsp[-1].intval));
					switch (rc) {
					case -1:
						yyerrorf("too few parameters "
							"for async command <%s>\n", (yyvsp[-3].strval));
						(yyval.action)=0;
						break;
					case -2:
						yyerrorf("too many parameters "
							"for async command <%s>\n", (yyvsp[-3].strval));
						(yyval.action)=0;
						break;
					case -3:
						yyerrorf("mandatory parameter "
							" omitted for async command <%s>\n", (yyvsp[-3].strval));
						(yyval.action)=0;
						break;
					default:
						elems[0].type = ACMD_ST;
						elems[0].u.data_const = acmd_tmp;
						mk_action_((yyval.action), AMODULE_T, (yyvsp[-1].intval)+1, elems);
					}
				}
			}
#line 6494 "cfg.tab.c"
    break;

  case 481: /* async_func: ID LPAREN error RPAREN  */
#line 2374 "cfg.y"
                                                 {
				(yyval.action)=0;
				yyerrorf("bad arguments for command <%s>", (yyvsp[-3].strval));
			}
#line 6503 "cfg.tab.c"
    break;

  case 482: /* async_func: ID error  */
#line 2378 "cfg.y"
                                   {
				(yyval.action)=0;
				yyerrorf("bare word <%s> found, command calls need '()'", (yyvsp[-1].strval));
			}
#line 6512 "cfg.tab.c"
    break;

  case 483: /* cmd: ASSERT LPAREN exp COMMA STRING RPAREN  */
#line 2384 "cfg.y"
                                                 {
			mk_action2( (yyval.action), ASSERT_T, EXPR_ST, STRING_ST, (yyvsp[-3].expr), (yyvsp[-1].strval));
			}
#line 6520 "cfg.tab.c"
    break;

  case 484: /* cmd: DROP  */
#line 2387 "cfg.y"
                                                 {mk_action0( (yyval.action), DROP_T); }
#line 6526 "cfg.tab.c"
    break;

  case 485: /* cmd: DROP LPAREN RPAREN  */
#line 2388 "cfg.y"
                                     {mk_action0( (yyval.action), DROP_T); }
#line 6532 "cfg.tab.c"
    break;

  case 486: /* cmd: EXIT  */
#line 2389 "cfg.y"
                                                 {mk_action0( (yyval.action), EXIT_T); }
#line 6538 "cfg.tab.c"
    break;

  case 487: /* cmd: EXIT LPAREN RPAREN  */
#line 2390 "cfg.y"
                                     {mk_action0( (yyval.action), EXIT_T); }
#line 6544 "cfg.tab.c"
    break;

  case 488: /* cmd: RETURN script_var  */
#line 2392 "cfg.y"
                                                         {mk_action1( (yyval.action), RETURN_T, SCRIPTVAR_ST, (void*)(yyvsp[0].specval)); }
#line 6550 "cfg.tab.c"
    break;

  case 489: /* cmd: RETURN LPAREN script_var RPAREN  */
#line 2394 "cfg.y"
                                                         {mk_action1( (yyval.action), RETURN_T, SCRIPTVAR_ST, (void*)(yyvsp[-1].specval)); }
#line 6556 "cfg.tab.c"
    break;

  case 490: /* cmd: RETURN snumber  */
#line 2396 "cfg.y"
                                                         {mk_action1( (yyval.action), RETURN_T, NUMBER_ST, (void*)(yyvsp[0].intval)); }
#line 6562 "cfg.tab.c"
    break;

  case 491: /* cmd: RETURN LPAREN snumber RPAREN  */
#line 2398 "cfg.y"
                                                         {mk_action1( (yyval.action), RETURN_T, NUMBER_ST, (void*)(yyvsp[-1].intval)); }
#line 6568 "cfg.tab.c"
    break;

  case 492: /* cmd: RETURN LPAREN RPAREN  */
#line 2400 "cfg.y"
                                                         {mk_action1( (yyval.action), RETURN_T, NUMBER_ST, (void*)1); }
#line 6574 "cfg.tab.c"
    break;

  case 493: /* cmd: RETURN  */
#line 2401 "cfg.y"
                                                 {mk_action1( (yyval.action), RETURN_T, NUMBER_ST, (void*)1); }
#line 6580 "cfg.tab.c"
    break;

  case 494: /* cmd: LOG_TOK LPAREN STRING RPAREN  */
#line 2402 "cfg.y"
                                                {mk_action2( (yyval.action), LOG_T, NUMBER_ST,
													STRING_ST,(void*)4,(yyvsp[-1].strval));
									}
#line 6588 "cfg.tab.c"
    break;

  case 495: /* cmd: LOG_TOK LPAREN snumber COMMA STRING RPAREN  */
#line 2405 "cfg.y"
                                                                {mk_action2( (yyval.action), LOG_T,
																NUMBER_ST,
																STRING_ST,
																(void*)(yyvsp[-3].intval),
																(yyvsp[-1].strval));
												}
#line 6599 "cfg.tab.c"
    break;

  case 496: /* cmd: LOG_TOK error  */
#line 2411 "cfg.y"
                                { (yyval.action)=0; yyerror("missing '(' or ')' ?"); }
#line 6605 "cfg.tab.c"
    break;

  case 497: /* cmd: LOG_TOK LPAREN error RPAREN  */
#line 2412 "cfg.y"
                                              { (yyval.action)=0; yyerror("bad log"
									"argument"); }
#line 6612 "cfg.tab.c"
    break;

  case 498: /* cmd: ERROR LPAREN STRING COMMA STRING RPAREN  */
#line 2414 "cfg.y"
                                                          {mk_action2( (yyval.action), ERROR_T,
																STRING_ST,
																STRING_ST,
																(yyvsp[-3].strval),
																(yyvsp[-1].strval));
												  }
#line 6623 "cfg.tab.c"
    break;

  case 499: /* cmd: ERROR error  */
#line 2420 "cfg.y"
                              { (yyval.action)=0; yyerror("missing '(' or ')' ?"); }
#line 6629 "cfg.tab.c"
    break;

  case 500: /* cmd: ERROR LPAREN error RPAREN  */
#line 2421 "cfg.y"
                                            { (yyval.action)=0; yyerror("bad error"
														"argument"); }
#line 6636 "cfg.tab.c"
    break;

  case 501: /* cmd: ROUTE LPAREN route_name_var RPAREN  */
#line 2423 "cfg.y"
                                                        {
						mk_action2( (yyval.action), ROUTE_T, (yyvsp[-1].intval), 0, rn_tmp.data, 0);
					}
#line 6644 "cfg.tab.c"
    break;

  case 502: /* cmd: ROUTE LPAREN route_name_var COMMA route_param RPAREN  */
#line 2427 "cfg.y"
                                                                        {
						if ((yyvsp[-1].intval) <= 0) yyerror("too many route parameters");

						/* duplicate the list */
						a_tmp = pkg_malloc((yyvsp[-1].intval) * sizeof(action_elem_t));
						if (!a_tmp) {
							yyerror("no more pkg memory");
							YYABORT;
						}
						memcpy(a_tmp, route_elems, (yyvsp[-1].intval)*sizeof(action_elem_t));

						mk_action3( (yyval.action), ROUTE_T, (yyvsp[-3].intval),	/* route idx */
							NUMBER_ST,					/* number of params */
							SCRIPTVAR_ST,				/* parameters */
							rn_tmp.data,
							(void*)(long)(yyvsp[-1].intval),
							(void*)a_tmp);
					}
#line 6667 "cfg.tab.c"
    break;

  case 503: /* cmd: ROUTE error  */
#line 2446 "cfg.y"
                              { (yyval.action)=0; yyerror("missing '(' or ')' ?"); }
#line 6673 "cfg.tab.c"
    break;

  case 504: /* cmd: ROUTE LPAREN error RPAREN  */
#line 2447 "cfg.y"
                                            { (yyval.action)=0; yyerror("bad route"
						"argument"); }
#line 6680 "cfg.tab.c"
    break;

  case 505: /* cmd: ID LPAREN RPAREN  */
#line 2449 "cfg.y"
                                        {
								const cmd_export_t* cmd_tmp=find_cmd_export_t((yyvsp[-2].strval), rt);
								if (cmd_tmp==0){
									if (find_cmd_export_t((yyvsp[-2].strval), 0)) {
										yyerrorf("Command <%s> cannot be "
											"used in the block\n", (yyvsp[-2].strval));
									} else {
										yyerrorf("unknown command <%s>, "
											"missing loadmodule?", (yyvsp[-2].strval));
									}
									(yyval.action)=0;
								}else{
									if (check_cmd_call_params(cmd_tmp,elems,0)<0) {
										yyerrorf("too few parameters "
											"for command <%s>\n", (yyvsp[-2].strval));
										(yyval.action)=0;
									} else {
										elems[0].type = CMD_ST;
										elems[0].u.data_const = cmd_tmp;
										mk_action_((yyval.action), CMD_T, 1, elems);
									}
								}
							}
#line 6708 "cfg.tab.c"
    break;

  case 506: /* cmd: ID LPAREN func_param RPAREN  */
#line 2472 "cfg.y"
                                                {
								const cmd_export_t* cmd_tmp=find_cmd_export_t((yyvsp[-3].strval), rt);
								if (cmd_tmp==0){
									if (find_cmd_export_t((yyvsp[-3].strval), 0)) {
										yyerrorf("Command <%s> cannot be "
											"used in the block\n", (yyvsp[-3].strval));
									} else {
										yyerrorf("unknown command <%s>, "
											"missing loadmodule?", (yyvsp[-3].strval));
									}
									(yyval.action)=0;
								}else{
									rc = check_cmd_call_params(cmd_tmp,elems,(yyvsp[-1].intval));
									switch (rc) {
									case -1:
										yyerrorf("too few parameters "
											"for command <%s>\n", (yyvsp[-3].strval));
										(yyval.action)=0;
										break;
									case -2:
										yyerrorf("too many parameters "
											"for command <%s>\n", (yyvsp[-3].strval));
										(yyval.action)=0;
										break;
									case -3:
										yyerrorf("mandatory parameter "
											"omitted for command <%s>\n", (yyvsp[-3].strval));
										(yyval.action)=0;
										break;
									default:
										elems[0].type = CMD_ST;
										elems[0].u.data_const = cmd_tmp;
										mk_action_((yyval.action), CMD_T, (yyvsp[-1].intval)+1, elems);
									}
								}
							}
#line 6749 "cfg.tab.c"
    break;

  case 507: /* cmd: ID LPAREN error RPAREN  */
#line 2508 "cfg.y"
                                         { (yyval.action)=0; yyerrorf("bad arguments for "
												"command <%s>", (yyvsp[-3].strval)); }
#line 6756 "cfg.tab.c"
    break;

  case 508: /* cmd: ID error  */
#line 2510 "cfg.y"
                           { (yyval.action)=0;
			yyerrorf("bare word <%s> found, command calls need '()'", (yyvsp[-1].strval));
			}
#line 6764 "cfg.tab.c"
    break;

  case 509: /* cmd: XDBG LPAREN STRING RPAREN  */
#line 2513 "cfg.y"
                                            {
				mk_action1((yyval.action), XDBG_T, STR_ST, (yyvsp[-1].strval));	}
#line 6771 "cfg.tab.c"
    break;

  case 510: /* cmd: XDBG LPAREN folded_string RPAREN  */
#line 2515 "cfg.y"
                                                   {
				mk_action1((yyval.action), XDBG_T, STR_ST, (yyvsp[-1].strval));	}
#line 6778 "cfg.tab.c"
    break;

  case 511: /* cmd: XLOG LPAREN STRING RPAREN  */
#line 2517 "cfg.y"
                                            {
				mk_action1((yyval.action), XLOG_T, STR_ST, (yyvsp[-1].strval)); }
#line 6785 "cfg.tab.c"
    break;

  case 512: /* cmd: XLOG LPAREN folded_string RPAREN  */
#line 2519 "cfg.y"
                                                   {
				mk_action1((yyval.action), XLOG_T, STR_ST, (yyvsp[-1].strval)); }
#line 6792 "cfg.tab.c"
    break;

  case 513: /* cmd: XLOG LPAREN STRING COMMA STRING RPAREN  */
#line 2521 "cfg.y"
                                                         {
				mk_action2((yyval.action), XLOG_T, STR_ST, STR_ST, (yyvsp[-3].strval), (yyvsp[-1].strval)); }
#line 6799 "cfg.tab.c"
    break;

  case 514: /* cmd: XLOG LPAREN STRING COMMA folded_string RPAREN  */
#line 2523 "cfg.y"
                                                                {
				mk_action2((yyval.action), XLOG_T, STR_ST, STR_ST, (yyvsp[-3].strval), (yyvsp[-1].strval)); }
#line 6806 "cfg.tab.c"
    break;

  case 515: /* cmd: ASYNC_TOKEN LPAREN async_func COMMA route_name RPAREN  */
#line 2525 "cfg.y"
                                                                        {
				rt_ref = ref_script_route_by_name( (yyvsp[-1].strval), sroutes->request,
					RT_NO, REQUEST_ROUTE, 0);
				if (rt_ref==NULL) yyerror("fail to create route reference");
				mk_action2((yyval.action), ASYNC_T, ACTIONS_ST, ROUTE_REF_ST,
						(yyvsp[-3].action), (void*)rt_ref);
				}
#line 6818 "cfg.tab.c"
    break;

  case 516: /* cmd: ASYNC_TOKEN LPAREN async_func COMMA route_name COMMA NUMBER RPAREN  */
#line 2532 "cfg.y"
                                                                                     {
				rt_ref = ref_script_route_by_name( (yyvsp[-3].strval), sroutes->request,
					RT_NO, REQUEST_ROUTE, 0);
				if (rt_ref==NULL) yyerror("fail to create route reference");
				mk_action3((yyval.action), ASYNC_T, ACTIONS_ST, ROUTE_REF_ST, NUMBER_ST,
						(yyvsp[-5].action), (void*)rt_ref, (void*)(long)(yyvsp[-1].intval));
				}
#line 6830 "cfg.tab.c"
    break;

  case 517: /* cmd: LAUNCH_TOKEN LPAREN async_func COMMA route_name COMMA STRING RPAREN  */
#line 2539 "cfg.y"
                                                                                      {
				rt_ref = ref_script_route_by_name( (yyvsp[-3].strval), sroutes->request,
					RT_NO, REQUEST_ROUTE, 0);
				if (rt_ref==NULL) yyerror("fail to create route reference");
				mk_action3((yyval.action), LAUNCH_T, ACTIONS_ST, ROUTE_REF_ST, STRING_ST,
						(yyvsp[-5].action), (void*)rt_ref, (yyvsp[-1].strval));
				}
#line 6842 "cfg.tab.c"
    break;

  case 518: /* cmd: LAUNCH_TOKEN LPAREN async_func COMMA route_name RPAREN  */
#line 2546 "cfg.y"
                                                                         {
				rt_ref = ref_script_route_by_name( (yyvsp[-1].strval), sroutes->request,
					RT_NO, REQUEST_ROUTE, 0);
				if (rt_ref==NULL) yyerror("fail to create route reference");
				mk_action2((yyval.action), LAUNCH_T, ACTIONS_ST, ROUTE_REF_ST,
						(yyvsp[-3].action), (void*)rt_ref);
				}
#line 6854 "cfg.tab.c"
    break;

  case 519: /* cmd: LAUNCH_TOKEN LPAREN async_func RPAREN  */
#line 2553 "cfg.y"
                                                        {
				mk_action2((yyval.action), LAUNCH_T, ACTIONS_ST, ROUTE_REF_ST,
						(yyvsp[-1].action), (void*)NULL);
				}
#line 6863 "cfg.tab.c"
    break;


#line 6867 "cfg.tab.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 2560 "cfg.y"


static inline void ALLOW_UNUSED warn(char* s)
{
	LM_WARN("warning in config file %s, line %d, column %d-%d: %s\n",
			get_cfg_file_name, line, startcolumn, column, s);
}

static void yyerror(char* s)
{
	cfg_dump_backtrace();
	LM_CRIT("parse error in %s:%d:%d-%d: %s\n",
			get_cfg_file_name, line, startcolumn, column, s);
	_cfg_dump_context(get_cfg_file_name, line, startcolumn, column, 1);
	cfg_errors++;
}

#define ERROR_MAXLEN 1024
static void yyerrorf(char *fmt, ...)
{
	char *tmp = pkg_malloc(ERROR_MAXLEN);
	va_list ap;
	va_start(ap, fmt);

	vsnprintf(tmp, ERROR_MAXLEN, fmt, ap);
	yyerror(tmp);

	pkg_free(tmp);
	va_end(ap);
}


static struct socket_id* mk_listen_id(char* host, enum sip_protos proto,
																	int port)
{
	struct socket_id* l;
	l=pkg_malloc(sizeof(struct socket_id));
	if (l==0){
		LM_CRIT("cfg. parser: out of memory.\n");
	}else{
		memset(l, 0, sizeof(*l));
		l->name     = host;
		l->proto    = proto;
		l->port     = port;
	}

	return l;
}

static void fill_socket_id(struct listen_param *param, struct socket_id *s)
{
	s->flags |= param->flags;
	s->workers = param->workers;
	s->auto_scaling_profile = param->auto_scaling_profile;
	if (param->socket)
		set_listen_id_adv(s, param->socket->name, param->socket->port);
	s->tag = param->tag;
}

static struct multi_str *new_string(char *s)
{
	struct multi_str *ms = pkg_malloc(sizeof(struct multi_str));
	if (!ms) {
		LM_CRIT("cfg. parser: out of memory.\n");
	}else{
		ms->s    = s;
		ms->next = NULL;
	}
	return ms;
}

static struct socket_id* set_listen_id_adv(struct socket_id* sock,
											char *adv_name,
											int adv_port)
{
	sock->adv_name=adv_name;
	sock->adv_port=adv_port;
	return sock;
}

static int parse_ipnet(char *in, int len, struct net **ipnet)
{
	char *p = NULL;
	str ip_s, mask_s;
	struct ip_addr *ip = NULL, *mask = NULL, *ip_tmp;
	int af;
	unsigned int bitlen;

	p = q_memchr(in, '.', len);
	if (p)
		af = AF_INET;
	else if (q_memchr(in, ':', len)) {
		af = AF_INET6;
	} else {
		LM_ERR("Not an IP");
		return -1;
	}

	p = q_memchr(in, '/', len);
	if (!p) {
		LM_ERR("No netmask\n");
		return -1;
	}
	ip_s.s = in;
	ip_s.len = p - in;

	mask_s.s = p + 1;
	mask_s.len = len - ip_s.len - 1;
	if (!mask_s.s || mask_s.len == 0) {
		LM_ERR("Empty netmask\n");
		return -1;
	}

	ip_tmp = (af == AF_INET) ? str2ip(&ip_s) : str2ip6(&ip_s);
	if (!ip_tmp) {
		LM_ERR("Invalid IP\n");
		return -1;
	}
	ip = pkg_malloc(sizeof *ip);
	if (!ip) {
		LM_CRIT("No more pkg memory\n");
		return -1;
	}
	memcpy(ip, ip_tmp, sizeof *ip);

	p = (af == AF_INET) ? q_memchr(p, '.', len-(p-in)+1) : q_memchr(p, ':', len-(p-in)+1);
	if (p) {
		ip_tmp = (af == AF_INET) ? str2ip(&mask_s) : str2ip6(&mask_s);
		if (!ip_tmp) {
			LM_ERR("Invalid netmask\n");
			return -1;
		}
		mask = pkg_malloc(sizeof *mask);
		if (!mask) {
			LM_CRIT("No more pkg memory\n");
			return -1;
		}
		memcpy(mask, ip_tmp, sizeof *mask);

		*ipnet = mk_net(ip, mask);
	} else {
		if (str2int(&mask_s, &bitlen) < 0) {
			LM_ERR("Invalid netmask bitlen\n");
			return -1;
		}

		*ipnet = mk_net_bitlen(ip, bitlen);
	}

	pkg_free(ip);
	pkg_free(mask);

	if (*ipnet == NULL)
			return -1;

	return 0;
}
