/* Viewer.c generated by valac 0.56.12, the Vala compiler
 * generated from Viewer.vala, do not modify */

/*
* Copyright (c) 2011-2016 Felipe Escoto (https://github.com/Philip-Scott/Notes-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <webkit2/webkit2.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <granite.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <gio/gio.h>
#include <mkdio.h>

#define ENOTES_VIEWER_DARK_THEME "\n" \
"<style>\n" \
"    body, html {\n" \
"        color: #839496;\n" \
"        background-color: #002b36;\n" \
"    }\n" \
"    code {\n" \
"        background-color: #1D3848;\n" \
"        border: 1px solid #1D3848;\n" \
"        color: #33719C;\n" \
"    }\n" \
"</style>"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ENOTES_TYPE_VIEWER (enotes_viewer_get_type ())
#define ENOTES_VIEWER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_VIEWER, ENotesViewer))
#define ENOTES_VIEWER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_VIEWER, ENotesViewerClass))
#define ENOTES_IS_VIEWER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_VIEWER))
#define ENOTES_IS_VIEWER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_VIEWER))
#define ENOTES_VIEWER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_VIEWER, ENotesViewerClass))

typedef struct _ENotesViewer ENotesViewer;
typedef struct _ENotesViewerClass ENotesViewerClass;
typedef struct _ENotesViewerPrivate ENotesViewerPrivate;

#define ENOTES_TYPE_PAGE (enotes_page_get_type ())
#define ENOTES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGE, ENotesPage))
#define ENOTES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGE, ENotesPageClass))
#define ENOTES_IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGE))
#define ENOTES_IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGE))
#define ENOTES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGE, ENotesPageClass))

typedef struct _ENotesPage ENotesPage;
typedef struct _ENotesPageClass ENotesPageClass;

#define ENOTES_TYPE_STYLE_LOADER (enotes_style_loader_get_type ())
#define ENOTES_STYLE_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_STYLE_LOADER, ENotesStyleLoader))
#define ENOTES_STYLE_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_STYLE_LOADER, ENotesStyleLoaderClass))
#define ENOTES_IS_STYLE_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_STYLE_LOADER))
#define ENOTES_IS_STYLE_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_STYLE_LOADER))
#define ENOTES_STYLE_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_STYLE_LOADER, ENotesStyleLoaderClass))

typedef struct _ENotesStyleLoader ENotesStyleLoader;
typedef struct _ENotesStyleLoaderClass ENotesStyleLoaderClass;
enum  {
	ENOTES_VIEWER_0_PROPERTY,
	ENOTES_VIEWER_NUM_PROPERTIES
};
static GParamSpec* enotes_viewer_properties[ENOTES_VIEWER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _enotes_style_loader_unref0(var) ((var == NULL) ? NULL : (var = (enotes_style_loader_unref (var), NULL)))
typedef struct _ENotesPagePrivate ENotesPagePrivate;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define ENOTES_TYPE_NOTEBOOK_TABLE (enotes_notebook_table_get_type ())
#define ENOTES_NOTEBOOK_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_NOTEBOOK_TABLE, ENotesNotebookTable))
#define ENOTES_NOTEBOOK_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_NOTEBOOK_TABLE, ENotesNotebookTableClass))
#define ENOTES_IS_NOTEBOOK_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_NOTEBOOK_TABLE))
#define ENOTES_IS_NOTEBOOK_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_NOTEBOOK_TABLE))
#define ENOTES_NOTEBOOK_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_NOTEBOOK_TABLE, ENotesNotebookTableClass))

typedef struct _ENotesNotebookTable ENotesNotebookTable;
typedef struct _ENotesNotebookTableClass ENotesNotebookTableClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))

#define ENOTES_TYPE_APPLICATION (enotes_application_get_type ())
#define ENOTES_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_APPLICATION, ENotesApplication))
#define ENOTES_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_APPLICATION, ENotesApplicationClass))
#define ENOTES_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_APPLICATION))
#define ENOTES_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_APPLICATION))
#define ENOTES_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_APPLICATION, ENotesApplicationClass))

typedef struct _ENotesApplication ENotesApplication;
typedef struct _ENotesApplicationClass ENotesApplicationClass;
typedef struct _ENotesApplicationPrivate ENotesApplicationPrivate;

#define ENOTES_APPLICATION_TYPE_STATE (enotes_application_state_get_type ())
#define ENOTES_APPLICATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationState))
#define ENOTES_APPLICATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationStateClass))
#define ENOTES_APPLICATION_IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_APPLICATION_TYPE_STATE))
#define ENOTES_APPLICATION_IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_APPLICATION_TYPE_STATE))
#define ENOTES_APPLICATION_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationStateClass))

typedef struct _ENotesApplicationState ENotesApplicationState;
typedef struct _ENotesApplicationStateClass ENotesApplicationStateClass;
typedef enum  {
	ENOTES_MODE_NONE = -1,
	ENOTES_MODE_VIEW = 0,
	ENOTES_MODE_EDIT = 1,
	ENOTES_MODE_BOTH = 2
} ENotesMode;

#define ENOTES_TYPE_MODE (enotes_mode_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _mkd_cleanup0(var) ((var == NULL) ? NULL : (var = (mkd_cleanup (var), NULL)))

#define ENOTES_TYPE_PLUGIN_MANAGER (enotes_plugin_manager_get_type ())
#define ENOTES_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PLUGIN_MANAGER, ENotesPluginManager))
#define ENOTES_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PLUGIN_MANAGER, ENotesPluginManagerClass))
#define ENOTES_IS_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PLUGIN_MANAGER))
#define ENOTES_IS_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PLUGIN_MANAGER))
#define ENOTES_PLUGIN_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PLUGIN_MANAGER, ENotesPluginManagerClass))

typedef struct _ENotesPluginManager ENotesPluginManager;
typedef struct _ENotesPluginManagerClass ENotesPluginManagerClass;

#define ENOTES_TYPE_PLUGIN (enotes_plugin_get_type ())
#define ENOTES_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PLUGIN, ENotesPlugin))
#define ENOTES_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PLUGIN, ENotesPluginClass))
#define ENOTES_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PLUGIN))
#define ENOTES_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PLUGIN))
#define ENOTES_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PLUGIN, ENotesPluginClass))

typedef struct _ENotesPlugin ENotesPlugin;
typedef struct _ENotesPluginClass ENotesPluginClass;

struct _ENotesViewer {
	WebKitWebView parent_instance;
	ENotesViewerPrivate * priv;
	gchar* CSS;
};

struct _ENotesViewerClass {
	WebKitWebViewClass parent_class;
};

struct _ENotesViewerPrivate {
	ENotesPage* previous_page;
	ENotesStyleLoader* style_loader;
};

struct _ENotesPage {
	GObject parent_instance;
	ENotesPagePrivate * priv;
	gint64 id;
	gint64 notebook_id;
	gchar* name;
	gchar* data;
	gchar* subtitle;
	gchar* html_cache;
	gint64 creation_date;
	gint64 modification_date;
	gboolean new_page;
	gboolean cache_changed;
	gchar* full_path;
};

struct _ENotesPageClass {
	GObjectClass parent_class;
};

struct _ENotesApplication {
	GraniteApplication parent_instance;
	ENotesApplicationPrivate * priv;
	gboolean running;
	ENotesApplicationState* state;
};

struct _ENotesApplicationClass {
	GraniteApplicationClass parent_class;
};

static gint ENotesViewer_private_offset;
static gpointer enotes_viewer_parent_class = NULL;
VALA_EXTERN ENotesApplication* enotes_app;

VALA_EXTERN GType enotes_viewer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesViewer, g_object_unref)
VALA_EXTERN GType enotes_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPage, g_object_unref)
VALA_EXTERN gpointer enotes_style_loader_ref (gpointer instance);
VALA_EXTERN void enotes_style_loader_unref (gpointer instance);
VALA_EXTERN GParamSpec* enotes_param_spec_style_loader (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void enotes_value_set_style_loader (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void enotes_value_take_style_loader (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer enotes_value_get_style_loader (const GValue* value);
VALA_EXTERN GType enotes_style_loader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesStyleLoader, enotes_style_loader_unref)
VALA_EXTERN ENotesViewer* enotes_viewer_new (void);
VALA_EXTERN ENotesViewer* enotes_viewer_construct (GType object_type);
VALA_EXTERN ENotesStyleLoader* enotes_style_loader_get_instance (void);
static void enotes_viewer_connect_signals (ENotesViewer* self);
VALA_EXTERN void enotes_viewer_load_css (ENotesViewer* self,
                             ENotesPage* page,
                             gboolean overrride);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType enotes_notebook_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesNotebookTable, database_table_unref)
VALA_EXTERN ENotesNotebookTable* enotes_notebook_table_get_instance (void);
VALA_EXTERN gchar* enotes_notebook_table_get_stylesheet_from_page (ENotesNotebookTable* self,
                                                       gint64 page_id);
VALA_EXTERN gchar* enotes_style_loader_get_styleshet (ENotesStyleLoader* self,
                                          const gchar* stylesheet,
                                          gint64 current_page_id,
                                          gboolean trying_global);
VALA_EXTERN void enotes_viewer_reload_page (ENotesViewer* self);
VALA_EXTERN GType enotes_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesApplication, g_object_unref)
VALA_EXTERN GType enotes_application_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesApplicationState, g_object_unref)
VALA_EXTERN ENotesPage* enotes_application_state_get_opened_page (ENotesApplicationState* self);
VALA_EXTERN void enotes_viewer_load_page (ENotesViewer* self,
                              ENotesPage* page,
                              gboolean force_load);
VALA_EXTERN GType enotes_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ENotesMode enotes_application_state_get_mode (ENotesApplicationState* self);
static gchar** enotes_viewer_process_frontmatter (ENotesViewer* self,
                                           const gchar* raw_mk,
                                           gchar** processed_mk,
                                           gint* result_length1);
static gchar* enotes_viewer_process (ENotesViewer* self,
                              const gchar* raw_mk);
static gchar* enotes_viewer_get_theme_color_css (ENotesViewer* self);
VALA_EXTERN void enotes_viewer_quick_reload (ENotesViewer* self,
                                 ENotesPage* page);
static GtkWidget* __lambda13_ (ENotesViewer* self,
                        WebKitNavigationAction* navigation_action);
static gboolean enotes_viewer_launch_browser (ENotesViewer* self,
                                       const gchar* url);
static GtkWidget* ___lambda13__webkit_web_view_create (WebKitWebView* _sender,
                                                WebKitNavigationAction* navigation_action,
                                                gpointer self);
static gboolean __lambda14_ (ENotesViewer* self,
                      WebKitPolicyDecision* decision,
                      WebKitPolicyDecisionType type);
static gboolean ___lambda14__webkit_web_view_decide_policy (WebKitWebView* _sender,
                                                     WebKitPolicyDecision* decision,
                                                     WebKitPolicyDecisionType type,
                                                     gpointer self);
static void __lambda15_ (ENotesViewer* self,
                  WebKitLoadEvent event);
static void enotes_viewer_search_from_state (ENotesViewer* self);
static void ___lambda15__webkit_web_view_load_changed (WebKitWebView* _sender,
                                                WebKitLoadEvent load_event,
                                                gpointer self);
static void __lambda16_ (ENotesViewer* self);
static void ___lambda16__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda17_ (ENotesViewer* self);
static void ___lambda17__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda18_ (ENotesViewer* self);
static void ___lambda18__enotes_application_state_page_text_updated (ENotesApplicationState* _sender,
                                                              gpointer self);
VALA_EXTERN const gchar* enotes_application_state_get_search_field (ENotesApplicationState* self);
VALA_EXTERN void enotes_application_state_open_page (ENotesApplicationState* self,
                                         gint64 page_id);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gchar* enotes_viewer_process_plugins (ENotesViewer* self,
                                      const gchar* raw_mk);
VALA_EXTERN GType enotes_plugin_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPluginManager, g_object_unref)
VALA_EXTERN ENotesPluginManager* enotes_plugin_manager_get_instance (void);
VALA_EXTERN GType enotes_plugin_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPlugin, g_object_unref)
VALA_EXTERN ENotesPlugin** enotes_plugin_manager_get_plugs (ENotesPluginManager* self,
                                                gint* result_length1);
VALA_EXTERN gboolean enotes_plugin_has_match (ENotesPlugin* self,
                                  const gchar* text);
VALA_EXTERN gchar* enotes_plugin_convert (ENotesPlugin* self,
                              const gchar* line);
VALA_EXTERN const gchar* enotes_application_state_get_style_scheme (ENotesApplicationState* self);
static void enotes_viewer_finalize (GObject * obj);
static GType enotes_viewer_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
enotes_viewer_get_instance_private (ENotesViewer* self)
{
	return G_STRUCT_MEMBER_P (self, ENotesViewer_private_offset);
}

static gpointer
_enotes_style_loader_ref0 (gpointer self)
{
#line 28 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	return self ? enotes_style_loader_ref (self) : NULL;
#line 358 "Viewer.c"
}

ENotesViewer*
enotes_viewer_construct (GType object_type)
{
	ENotesViewer * self = NULL;
	ENotesStyleLoader* _tmp0_;
	ENotesStyleLoader* _tmp1_;
	ENotesStyleLoader* _tmp2_;
#line 27 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	self = (ENotesViewer*) g_object_new (object_type, NULL);
#line 28 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp0_ = enotes_style_loader_get_instance ();
#line 28 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp1_ = _tmp0_;
#line 28 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp2_ = _enotes_style_loader_ref0 (_tmp1_);
#line 28 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_enotes_style_loader_unref0 (self->priv->style_loader);
#line 28 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	self->priv->style_loader = _tmp2_;
#line 29 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_object_set ((GtkWidget*) self, "width-request", 200, NULL);
#line 31 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	enotes_viewer_connect_signals (self);
#line 27 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	return self;
#line 386 "Viewer.c"
}

ENotesViewer*
enotes_viewer_new (void)
{
#line 27 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	return enotes_viewer_construct (ENOTES_TYPE_VIEWER);
#line 394 "Viewer.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 37 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	return self ? g_object_ref (self) : NULL;
#line 402 "Viewer.c"
}

void
enotes_viewer_load_css (ENotesViewer* self,
                        ENotesPage* page,
                        gboolean overrride)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 34 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_return_if_fail (self != NULL);
#line 35 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	if (overrride) {
#line 35 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp1_ = TRUE;
#line 418 "Viewer.c"
	} else {
		ENotesPage* _tmp2_;
#line 35 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp2_ = self->priv->previous_page;
#line 35 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp1_ = _tmp2_ == NULL;
#line 425 "Viewer.c"
	}
#line 35 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	if (_tmp1_) {
#line 35 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp0_ = TRUE;
#line 431 "Viewer.c"
	} else {
		ENotesPage* _tmp3_;
#line 35 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp3_ = self->priv->previous_page;
#line 35 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp0_ = _tmp3_->id != page->id;
#line 438 "Viewer.c"
	}
#line 35 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	if (_tmp0_) {
#line 442 "Viewer.c"
		ENotesPage* _tmp5_;
#line 36 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		if (page != NULL) {
#line 446 "Viewer.c"
			ENotesPage* _tmp4_;
#line 37 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp4_ = _g_object_ref0 (page);
#line 37 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_g_object_unref0 (self->priv->previous_page);
#line 37 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			self->priv->previous_page = _tmp4_;
#line 454 "Viewer.c"
		}
#line 41 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp5_ = self->priv->previous_page;
#line 41 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		if (_tmp5_ != NULL) {
#line 460 "Viewer.c"
			gchar* stylesheet = NULL;
			ENotesNotebookTable* _tmp6_;
			ENotesNotebookTable* _tmp7_;
			ENotesPage* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			ENotesStyleLoader* _tmp11_;
			const gchar* _tmp12_;
			ENotesPage* _tmp13_;
			gchar* _tmp14_;
#line 42 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp6_ = enotes_notebook_table_get_instance ();
#line 42 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp7_ = _tmp6_;
#line 42 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp8_ = self->priv->previous_page;
#line 42 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp9_ = enotes_notebook_table_get_stylesheet_from_page (_tmp7_, _tmp8_->id);
#line 42 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp10_ = _tmp9_;
#line 42 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_database_table_unref0 (_tmp7_);
#line 42 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			stylesheet = _tmp10_;
#line 43 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp11_ = self->priv->style_loader;
#line 43 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp12_ = stylesheet;
#line 43 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp13_ = self->priv->previous_page;
#line 43 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp14_ = enotes_style_loader_get_styleshet (_tmp11_, _tmp12_, _tmp13_->id, FALSE);
#line 43 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_g_free0 (self->CSS);
#line 43 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			self->CSS = _tmp14_;
#line 41 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_g_free0 (stylesheet);
#line 499 "Viewer.c"
		}
	}
}

void
enotes_viewer_reload_page (ENotesViewer* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	ENotesPage* _tmp2_;
	ENotesPage* _tmp3_;
#line 48 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_return_if_fail (self != NULL);
#line 49 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp0_ = enotes_app;
#line 49 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp1_ = _tmp0_->state;
#line 49 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp2_ = enotes_application_state_get_opened_page (_tmp1_);
#line 49 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp3_ = _tmp2_;
#line 49 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	if (_tmp3_ != NULL) {
#line 523 "Viewer.c"
		ENotesApplication* _tmp4_;
		ENotesApplicationState* _tmp5_;
		ENotesPage* _tmp6_;
		ENotesPage* _tmp7_;
		ENotesApplication* _tmp8_;
		ENotesApplicationState* _tmp9_;
		ENotesPage* _tmp10_;
		ENotesPage* _tmp11_;
#line 50 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp4_ = enotes_app;
#line 50 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp5_ = _tmp4_->state;
#line 50 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp6_ = enotes_application_state_get_opened_page (_tmp5_);
#line 50 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp7_ = _tmp6_;
#line 50 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		enotes_viewer_load_css (self, _tmp7_, TRUE);
#line 51 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp8_ = enotes_app;
#line 51 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp9_ = _tmp8_->state;
#line 51 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp10_ = enotes_application_state_get_opened_page (_tmp9_);
#line 51 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp11_ = _tmp10_;
#line 51 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		enotes_viewer_load_page (self, _tmp11_, TRUE);
#line 552 "Viewer.c"
	}
}

void
enotes_viewer_load_page (ENotesViewer* self,
                         ENotesPage* page,
                         gboolean force_load)
{
	gboolean _tmp0_ = FALSE;
	ENotesApplication* _tmp1_;
	ENotesApplicationState* _tmp2_;
	ENotesMode _tmp3_;
	ENotesMode _tmp4_;
#line 55 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_return_if_fail (self != NULL);
#line 56 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	if (page == NULL) {
#line 57 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		webkit_web_view_load_html ((WebKitWebView*) self, "", "file:///");
#line 58 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		return;
#line 574 "Viewer.c"
	}
#line 61 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp1_ = enotes_app;
#line 61 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp2_ = _tmp1_->state;
#line 61 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp3_ = enotes_application_state_get_mode (_tmp2_);
#line 61 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp4_ = _tmp3_;
#line 61 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	if (_tmp4_ != ENOTES_MODE_EDIT) {
#line 61 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp0_ = TRUE;
#line 588 "Viewer.c"
	} else {
#line 61 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp0_ = force_load;
#line 592 "Viewer.c"
	}
#line 61 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	if (_tmp0_) {
#line 596 "Viewer.c"
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp6_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
#line 62 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp6_ = page->html_cache;
#line 62 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		if (g_strcmp0 (_tmp6_, "") == 0) {
#line 62 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp5_ = TRUE;
#line 610 "Viewer.c"
		} else {
#line 62 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp5_ = force_load;
#line 614 "Viewer.c"
		}
#line 62 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		if (_tmp5_) {
#line 618 "Viewer.c"
			gchar* markdown = NULL;
			const gchar* _tmp7_;
			gchar* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gchar** _tmp10_;
			gchar** _tmp11_;
			gint _tmp11__length1;
			const gchar* _tmp12_;
			gchar* _tmp13_;
#line 63 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			g_debug ("Viewer.vala:63: Reloading page\n");
#line 66 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp7_ = page->data;
#line 66 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp10_ = enotes_viewer_process_frontmatter (self, _tmp7_, &_tmp8_, &_tmp9_);
#line 66 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_g_free0 (markdown);
#line 66 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			markdown = _tmp8_;
#line 66 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp11_ = _tmp10_;
#line 66 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp11__length1 = _tmp9_;
#line 66 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
#line 68 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			enotes_viewer_load_css (self, page, FALSE);
#line 70 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp12_ = markdown;
#line 70 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp13_ = enotes_viewer_process (self, _tmp12_);
#line 70 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_g_free0 (page->html_cache);
#line 70 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			page->html_cache = _tmp13_;
#line 71 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			page->cache_changed = TRUE;
#line 62 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_g_free0 (markdown);
#line 658 "Viewer.c"
		} else {
#line 73 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			g_debug ("Viewer.vala:73: Loading content from cache");
#line 662 "Viewer.c"
		}
#line 76 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp14_ = page->html_cache;
#line 76 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp15_ = enotes_viewer_get_theme_color_css (self);
#line 76 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp16_ = _tmp15_;
#line 76 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp17_ = g_strconcat (_tmp14_, _tmp16_, NULL);
#line 76 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp18_ = _tmp17_;
#line 76 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		webkit_web_view_load_html ((WebKitWebView*) self, _tmp18_, "file:///");
#line 76 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_g_free0 (_tmp18_);
#line 76 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_g_free0 (_tmp16_);
#line 680 "Viewer.c"
	}
}

void
enotes_viewer_quick_reload (ENotesViewer* self,
                            ENotesPage* page)
{
	gchar* markdown = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
#line 80 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_return_if_fail (self != NULL);
#line 80 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_return_if_fail (page != NULL);
#line 81 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_debug ("Viewer.vala:81: Quick Reloading page\n");
#line 84 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp0_ = page->data;
#line 84 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp3_ = enotes_viewer_process_frontmatter (self, _tmp0_, &_tmp1_, &_tmp2_);
#line 84 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_g_free0 (markdown);
#line 84 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	markdown = _tmp1_;
#line 84 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp4_ = _tmp3_;
#line 84 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp4__length1 = _tmp2_;
#line 84 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
#line 85 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp5_ = enotes_viewer_process (self, markdown);
#line 85 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp6_ = _tmp5_;
#line 85 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp7_ = enotes_viewer_get_theme_color_css (self);
#line 85 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp8_ = _tmp7_;
#line 85 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp9_ = g_strconcat (_tmp6_, _tmp8_, NULL);
#line 85 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp10_ = _tmp9_;
#line 85 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	webkit_web_view_load_html ((WebKitWebView*) self, _tmp10_, "file:///");
#line 85 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_g_free0 (_tmp10_);
#line 85 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_g_free0 (_tmp8_);
#line 85 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_g_free0 (_tmp6_);
#line 80 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_g_free0 (markdown);
#line 743 "Viewer.c"
}

static GtkWidget*
__lambda13_ (ENotesViewer* self,
             WebKitNavigationAction* navigation_action)
{
	WebKitURIRequest* _tmp0_;
	const gchar* _tmp1_;
	GtkWidget* result;
#line 89 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_return_val_if_fail (navigation_action != NULL, NULL);
#line 90 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp0_ = webkit_navigation_action_get_request (navigation_action);
#line 90 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp1_ = webkit_uri_request_get_uri (_tmp0_);
#line 90 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	enotes_viewer_launch_browser (self, _tmp1_);
#line 91 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	result = NULL;
#line 91 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	return result;
#line 765 "Viewer.c"
}

static GtkWidget*
___lambda13__webkit_web_view_create (WebKitWebView* _sender,
                                     WebKitNavigationAction* navigation_action,
                                     gpointer self)
{
	GtkWidget* result;
	result = __lambda13_ ((ENotesViewer*) self, navigation_action);
#line 89 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	return result;
#line 777 "Viewer.c"
}

static gboolean
__lambda14_ (ENotesViewer* self,
             WebKitPolicyDecision* decision,
             WebKitPolicyDecisionType type)
{
	gboolean result;
#line 94 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_return_val_if_fail (decision != NULL, FALSE);
#line 95 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	switch (type) {
#line 95 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		case WEBKIT_POLICY_DECISION_TYPE_NEW_WINDOW_ACTION:
#line 792 "Viewer.c"
		{
#line 97 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (decision, webkit_response_policy_decision_get_type ())) {
#line 796 "Viewer.c"
				WebKitURIRequest* _tmp0_;
				WebKitURIRequest* _tmp1_;
				const gchar* _tmp2_;
#line 98 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp0_ = webkit_response_policy_decision_get_request (G_TYPE_CHECK_INSTANCE_TYPE (decision, webkit_response_policy_decision_get_type ()) ? ((WebKitResponsePolicyDecision*) decision) : NULL);
#line 98 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp1_ = _tmp0_;
#line 98 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp2_ = webkit_uri_request_get_uri (_tmp1_);
#line 98 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				enotes_viewer_launch_browser (self, _tmp2_);
#line 808 "Viewer.c"
			}
#line 100 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			break;
#line 812 "Viewer.c"
		}
#line 95 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		case WEBKIT_POLICY_DECISION_TYPE_RESPONSE:
#line 816 "Viewer.c"
		{
#line 102 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (decision, webkit_response_policy_decision_get_type ())) {
#line 820 "Viewer.c"
				WebKitResponsePolicyDecision* policy = NULL;
				WebKitResponsePolicyDecision* _tmp3_;
				WebKitResponsePolicyDecision* _tmp4_;
				WebKitURIRequest* _tmp5_;
				WebKitURIRequest* _tmp6_;
				const gchar* _tmp7_;
#line 103 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (decision, webkit_response_policy_decision_get_type (), WebKitResponsePolicyDecision));
#line 103 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				policy = _tmp3_;
#line 104 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp4_ = policy;
#line 104 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp5_ = webkit_response_policy_decision_get_request (_tmp4_);
#line 104 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp6_ = _tmp5_;
#line 104 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp7_ = webkit_uri_request_get_uri (_tmp6_);
#line 104 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				enotes_viewer_launch_browser (self, _tmp7_);
#line 105 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				result = FALSE;
#line 105 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_g_object_unref0 (policy);
#line 105 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				return result;
#line 847 "Viewer.c"
			}
#line 107 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			break;
#line 851 "Viewer.c"
		}
#line 95 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		case WEBKIT_POLICY_DECISION_TYPE_NAVIGATION_ACTION:
#line 855 "Viewer.c"
		{
#line 109 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (decision, webkit_navigation_policy_decision_get_type ())) {
#line 859 "Viewer.c"
				WebKitNavigationPolicyDecision* policy = NULL;
				WebKitNavigationPolicyDecision* _tmp8_;
				WebKitNavigationPolicyDecision* _tmp9_;
				WebKitNavigationAction* _tmp10_;
				WebKitNavigationAction* _tmp11_;
				WebKitURIRequest* _tmp12_;
				const gchar* _tmp13_;
#line 110 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (decision, webkit_navigation_policy_decision_get_type (), WebKitNavigationPolicyDecision));
#line 110 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				policy = _tmp8_;
#line 111 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp9_ = policy;
#line 111 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp10_ = webkit_navigation_policy_decision_get_navigation_action (_tmp9_);
#line 111 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp11_ = _tmp10_;
#line 111 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp12_ = webkit_navigation_action_get_request (_tmp11_);
#line 111 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp13_ = webkit_uri_request_get_uri (_tmp12_);
#line 111 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				result = enotes_viewer_launch_browser (self, _tmp13_);
#line 111 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_g_object_unref0 (policy);
#line 111 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				return result;
#line 887 "Viewer.c"
			}
#line 113 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			break;
#line 891 "Viewer.c"
		}
		default:
#line 95 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		break;
#line 896 "Viewer.c"
	}
#line 116 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	result = TRUE;
#line 116 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	return result;
#line 902 "Viewer.c"
}

static gboolean
___lambda14__webkit_web_view_decide_policy (WebKitWebView* _sender,
                                            WebKitPolicyDecision* decision,
                                            WebKitPolicyDecisionType type,
                                            gpointer self)
{
	gboolean result;
	result = __lambda14_ ((ENotesViewer*) self, decision, type);
#line 94 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	return result;
#line 915 "Viewer.c"
}

static void
__lambda15_ (ENotesViewer* self,
             WebKitLoadEvent event)
{
#line 120 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	if (event == WEBKIT_LOAD_FINISHED) {
#line 924 "Viewer.c"
		GdkRectangle rectangle = {0};
		WebKitWindowProperties* _tmp0_;
		GdkRectangle _tmp1_ = {0};
		GdkRectangle _tmp2_;
		GdkRectangle _tmp3_;
#line 121 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp0_ = webkit_web_view_get_window_properties ((WebKitWebView*) self);
#line 121 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		webkit_window_properties_get_geometry (_tmp0_, &_tmp1_);
#line 121 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		rectangle = _tmp1_;
#line 122 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp2_ = rectangle;
#line 122 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp3_ = rectangle;
#line 122 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		gtk_widget_set_size_request ((GtkWidget*) self, _tmp2_.width, _tmp3_.height);
#line 123 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		enotes_viewer_search_from_state (self);
#line 944 "Viewer.c"
	}
}

static void
___lambda15__webkit_web_view_load_changed (WebKitWebView* _sender,
                                           WebKitLoadEvent load_event,
                                           gpointer self)
{
#line 119 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	__lambda15_ ((ENotesViewer*) self, load_event);
#line 955 "Viewer.c"
}

static void
__lambda16_ (ENotesViewer* self)
{
#line 128 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	enotes_viewer_reload_page (self);
#line 963 "Viewer.c"
}

static void
___lambda16__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 127 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	__lambda16_ ((ENotesViewer*) self);
#line 973 "Viewer.c"
}

static void
__lambda17_ (ENotesViewer* self)
{
#line 132 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	enotes_viewer_search_from_state (self);
#line 981 "Viewer.c"
}

static void
___lambda17__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 131 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	__lambda17_ ((ENotesViewer*) self);
#line 991 "Viewer.c"
}

static void
__lambda18_ (ENotesViewer* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	ENotesMode _tmp2_;
	ENotesMode _tmp3_;
	ENotesApplication* _tmp4_;
	ENotesApplicationState* _tmp5_;
	ENotesPage* _tmp6_;
	ENotesPage* _tmp7_;
#line 136 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp0_ = enotes_app;
#line 136 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp1_ = _tmp0_->state;
#line 136 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp2_ = enotes_application_state_get_mode (_tmp1_);
#line 136 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp3_ = _tmp2_;
#line 136 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	if (_tmp3_ != ENOTES_MODE_BOTH) {
#line 136 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		return;
#line 1017 "Viewer.c"
	}
#line 138 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp4_ = enotes_app;
#line 138 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp5_ = _tmp4_->state;
#line 138 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp6_ = enotes_application_state_get_opened_page (_tmp5_);
#line 138 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp7_ = _tmp6_;
#line 138 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	enotes_viewer_quick_reload (self, _tmp7_);
#line 1029 "Viewer.c"
}

static void
___lambda18__enotes_application_state_page_text_updated (ENotesApplicationState* _sender,
                                                         gpointer self)
{
#line 135 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	__lambda18_ ((ENotesViewer*) self);
#line 1038 "Viewer.c"
}

static void
enotes_viewer_connect_signals (ENotesViewer* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	ENotesApplication* _tmp2_;
	ENotesApplicationState* _tmp3_;
	ENotesApplication* _tmp4_;
	ENotesApplicationState* _tmp5_;
#line 88 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_return_if_fail (self != NULL);
#line 89 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_signal_connect_object ((WebKitWebView*) self, "create", (GCallback) ___lambda13__webkit_web_view_create, self, 0);
#line 94 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_signal_connect_object ((WebKitWebView*) self, "decide-policy", (GCallback) ___lambda14__webkit_web_view_decide_policy, self, 0);
#line 119 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_signal_connect_object ((WebKitWebView*) self, "load-changed", (GCallback) ___lambda15__webkit_web_view_load_changed, self, 0);
#line 127 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp0_ = enotes_app;
#line 127 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp1_ = _tmp0_->state;
#line 127 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_signal_connect_object ((GObject*) _tmp1_, "notify::style-scheme", (GCallback) ___lambda16__g_object_notify, self, 0);
#line 131 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp2_ = enotes_app;
#line 131 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp3_ = _tmp2_->state;
#line 131 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_signal_connect_object ((GObject*) _tmp3_, "notify::search-field", (GCallback) ___lambda17__g_object_notify, self, 0);
#line 135 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp4_ = enotes_app;
#line 135 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp5_ = _tmp4_->state;
#line 135 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_signal_connect_object (_tmp5_, "page-text-updated", (GCallback) ___lambda18__enotes_application_state_page_text_updated, self, 0);
#line 1076 "Viewer.c"
}

static void
enotes_viewer_search_from_state (ENotesViewer* self)
{
	gchar* search_text = NULL;
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
#line 142 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_return_if_fail (self != NULL);
#line 143 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp0_ = enotes_app;
#line 143 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp1_ = _tmp0_->state;
#line 143 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp2_ = enotes_application_state_get_search_field (_tmp1_);
#line 143 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp3_ = _tmp2_;
#line 143 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 143 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	search_text = _tmp4_;
#line 145 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp5_ = search_text;
#line 145 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	if (g_strcmp0 (_tmp5_, "") != 0) {
#line 1107 "Viewer.c"
		WebKitFindController* _tmp6_;
		ENotesApplication* _tmp7_;
		ENotesApplicationState* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
#line 146 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp6_ = webkit_web_view_get_find_controller ((WebKitWebView*) self);
#line 146 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp7_ = enotes_app;
#line 146 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp8_ = _tmp7_->state;
#line 146 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp9_ = enotes_application_state_get_search_field (_tmp8_);
#line 146 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp10_ = _tmp9_;
#line 146 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		webkit_find_controller_search (_tmp6_, _tmp10_, (guint32) WEBKIT_FIND_OPTIONS_CASE_INSENSITIVE, (guint) 100);
#line 1125 "Viewer.c"
	} else {
		WebKitFindController* _tmp11_;
#line 148 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp11_ = webkit_web_view_get_find_controller ((WebKitWebView*) self);
#line 148 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		webkit_find_controller_search_finish (_tmp11_);
#line 1132 "Viewer.c"
	}
#line 142 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_g_free0 (search_text);
#line 1136 "Viewer.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1538 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1538 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1539 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1539 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1539 "glib-2.0.vapi"
	return result;
#line 1155 "Viewer.c"
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
#line 778 "glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0LL);
#line 779 "glib-2.0.vapi"
	result = g_ascii_strtoll (str, NULL, _base);
#line 779 "glib-2.0.vapi"
	return result;
#line 1169 "Viewer.c"
}

static gboolean
enotes_viewer_launch_browser (ENotesViewer* self,
                              const gchar* url)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 152 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 152 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_return_val_if_fail (url != NULL, FALSE);
#line 153 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	if (string_contains (url, "file:///")) {
#line 154 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		result = TRUE;
#line 154 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		return result;
#line 1188 "Viewer.c"
	}
#line 155 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	if (string_contains (url, "notes-up:///")) {
#line 1192 "Viewer.c"
		gchar* page_string = NULL;
		gchar** _tmp0_;
		gchar** _tmp1_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
#line 156 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		webkit_web_view_stop_loading ((WebKitWebView*) self);
#line 158 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp1_ = _tmp0_ = g_strsplit (url, ":///", 0);
#line 158 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp2_ = _tmp1_;
#line 158 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp2__length1 = _vala_array_length (_tmp0_);
#line 158 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp3_ = _tmp2_[1];
#line 158 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 158 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp5_ = _tmp4_;
#line 158 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
#line 158 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		page_string = _tmp5_;
#line 159 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp6_ = page_string;
#line 159 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		if (_tmp6_ != NULL) {
#line 1224 "Viewer.c"
			const gchar* _tmp7_;
			ENotesApplication* _tmp8_;
			ENotesApplicationState* _tmp9_;
			const gchar* _tmp10_;
#line 160 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp7_ = page_string;
#line 160 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			g_debug ("Viewer.vala:160: Openinng page %s", _tmp7_);
#line 161 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp8_ = enotes_app;
#line 161 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp9_ = _tmp8_->state;
#line 161 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp10_ = page_string;
#line 161 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			enotes_application_state_open_page (_tmp9_, int64_parse (_tmp10_, (guint) 0));
#line 1241 "Viewer.c"
		}
#line 155 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_g_free0 (page_string);
#line 1245 "Viewer.c"
	} else {
#line 163 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		if (!string_contains (url, "/embed/")) {
#line 1249 "Viewer.c"
			{
#line 165 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				g_app_info_launch_default_for_uri (url, NULL, &_inner_error0_);
#line 165 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1255 "Viewer.c"
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp11_;
				const gchar* _tmp12_;
#line 164 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				e = _inner_error0_;
#line 164 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_inner_error0_ = NULL;
#line 167 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp11_ = e;
#line 167 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp12_ = _tmp11_->message;
#line 167 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				g_warning ("Viewer.vala:167: No app to handle urls: %s", _tmp12_);
#line 164 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_g_error_free0 (e);
#line 1277 "Viewer.c"
			}
			__finally0:
#line 164 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1282 "Viewer.c"
				gboolean _tmp13_ = FALSE;
#line 164 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 164 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				g_clear_error (&_inner_error0_);
#line 164 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				return _tmp13_;
#line 1290 "Viewer.c"
			}
#line 169 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			webkit_web_view_stop_loading ((WebKitWebView*) self);
#line 1294 "Viewer.c"
		}
	}
#line 172 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	result = FALSE;
#line 172 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	return result;
#line 1301 "Viewer.c"
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
#line 1488 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1489 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1489 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1489 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1490 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1491 "glib-2.0.vapi"
		start = string_length + start;
#line 1328 "Viewer.c"
	}
#line 1493 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1494 "glib-2.0.vapi"
		end = string_length + end;
#line 1334 "Viewer.c"
	}
#line 1496 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1496 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 1340 "Viewer.c"
	} else {
#line 1496 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 1344 "Viewer.c"
	}
#line 1496 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1497 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1497 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 1352 "Viewer.c"
	} else {
#line 1497 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 1356 "Viewer.c"
	}
#line 1497 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1498 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1499 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1499 "glib-2.0.vapi"
	result = _tmp4_;
#line 1499 "glib-2.0.vapi"
	return result;
#line 1368 "Viewer.c"
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1161 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1162 "glib-2.0.vapi"
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
#line 1162 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1164 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1164 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 1390 "Viewer.c"
		gchar* _tmp2_;
#line 1165 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1165 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1165 "glib-2.0.vapi"
		return result;
#line 1398 "Viewer.c"
	} else {
#line 1167 "glib-2.0.vapi"
		result = -1;
#line 1167 "glib-2.0.vapi"
		return result;
#line 1404 "Viewer.c"
	}
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 204 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	if ((*length) == (*size)) {
#line 204 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 204 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1420 "Viewer.c"
	}
#line 204 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	(*array)[(*length)++] = value;
#line 204 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	(*array)[*length] = NULL;
#line 1426 "Viewer.c"
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 205 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	if ((*length) == (*size)) {
#line 205 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 205 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1441 "Viewer.c"
	}
#line 205 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	(*array)[(*length)++] = value;
#line 205 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	(*array)[*length] = NULL;
#line 1447 "Viewer.c"
}

static gchar**
enotes_viewer_process_frontmatter (ENotesViewer* self,
                                   const gchar* raw_mk,
                                   gchar** processed_mk,
                                   gint* result_length1)
{
	gchar* _vala_processed_mk = NULL;
	gchar** map = NULL;
	gchar** _tmp0_;
	gint map_length1;
	gint _map_size_;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gint _tmp3_;
	const gchar* _tmp21_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar** result;
#line 175 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 175 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_return_val_if_fail (raw_mk != NULL, NULL);
#line 176 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 176 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	map = _tmp0_;
#line 176 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	map_length1 = 0;
#line 176 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_map_size_ = map_length1;
#line 178 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_g_free0 (_vala_processed_mk);
#line 178 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_vala_processed_mk = NULL;
#line 181 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp2_ = strlen (raw_mk);
#line 181 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp3_ = _tmp2_;
#line 181 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	if (_tmp3_ > 4) {
#line 1490 "Viewer.c"
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 181 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp4_ = string_slice (raw_mk, (glong) 0, (glong) 4);
#line 181 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp5_ = _tmp4_;
#line 181 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp1_ = g_strcmp0 (_tmp5_, "---\n") == 0;
#line 181 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_g_free0 (_tmp5_);
#line 1501 "Viewer.c"
	} else {
#line 181 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp1_ = FALSE;
#line 1505 "Viewer.c"
	}
#line 181 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	if (_tmp1_) {
#line 1509 "Viewer.c"
		gint i = 0;
		gboolean valid_frontmatter = FALSE;
		gint last_newline = 0;
		gint next_newline = 0;
		gchar* line = NULL;
		gchar* _tmp6_;
#line 182 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		i = 0;
#line 183 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		valid_frontmatter = TRUE;
#line 184 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		last_newline = 3;
#line 186 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp6_ = g_strdup ("");
#line 186 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		line = _tmp6_;
#line 187 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		while (TRUE) {
#line 1528 "Viewer.c"
			gchar* _tmp7_;
			const gchar* _tmp8_;
			gint sep_index = 0;
			const gchar* _tmp9_;
			gint _tmp17_;
#line 189 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			next_newline = string_index_of_char (raw_mk, (gunichar) '\n', last_newline + 1);
#line 190 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			if (next_newline == -1) {
#line 191 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				valid_frontmatter = FALSE;
#line 192 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				break;
#line 1542 "Viewer.c"
			}
#line 195 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp7_ = string_slice (raw_mk, (glong) (last_newline + 1), (glong) next_newline);
#line 195 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_g_free0 (line);
#line 195 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			line = _tmp7_;
#line 196 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			last_newline = next_newline;
#line 198 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp8_ = line;
#line 198 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			if (g_strcmp0 (_tmp8_, "---") == 0) {
#line 199 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				break;
#line 1558 "Viewer.c"
			}
#line 202 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp9_ = line;
#line 202 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			sep_index = string_index_of_char (_tmp9_, (gunichar) ':', 0);
#line 203 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			if (sep_index != -1) {
#line 1566 "Viewer.c"
				const gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				gchar* _tmp16_;
#line 204 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp10_ = line;
#line 204 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp11_ = string_slice (_tmp10_, (glong) 0, (glong) (sep_index - 1));
#line 204 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_vala_array_add3 (&map, &map_length1, &_map_size_, _tmp11_);
#line 205 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp12_ = line;
#line 205 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp13_ = line;
#line 205 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp14_ = strlen (_tmp13_);
#line 205 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp15_ = _tmp14_;
#line 205 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp16_ = string_slice (_tmp12_, (glong) (sep_index + 1), (glong) _tmp15_);
#line 205 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_vala_array_add4 (&map, &map_length1, &_map_size_, _tmp16_);
#line 1592 "Viewer.c"
			} else {
#line 207 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				valid_frontmatter = FALSE;
#line 208 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				break;
#line 1598 "Viewer.c"
			}
#line 211 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp17_ = i;
#line 211 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			i = _tmp17_ + 1;
#line 1604 "Viewer.c"
		}
#line 214 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		if (valid_frontmatter) {
#line 1608 "Viewer.c"
			gint _tmp18_;
			gint _tmp19_;
			gchar* _tmp20_;
#line 215 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp18_ = strlen (raw_mk);
#line 215 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp19_ = _tmp18_;
#line 215 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp20_ = string_slice (raw_mk, (glong) last_newline, (glong) _tmp19_);
#line 215 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_g_free0 (_vala_processed_mk);
#line 215 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_vala_processed_mk = _tmp20_;
#line 1622 "Viewer.c"
		}
#line 181 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_g_free0 (line);
#line 1626 "Viewer.c"
	}
#line 219 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp21_ = _vala_processed_mk;
#line 219 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	if (_tmp21_ == NULL) {
#line 1632 "Viewer.c"
		gchar* _tmp22_;
#line 220 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp22_ = g_strdup (raw_mk);
#line 220 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_g_free0 (_vala_processed_mk);
#line 220 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_vala_processed_mk = _tmp22_;
#line 1640 "Viewer.c"
	}
#line 223 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp23_ = map;
#line 223 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp23__length1 = map_length1;
#line 223 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	if (result_length1) {
#line 223 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		*result_length1 = _tmp23__length1;
#line 1650 "Viewer.c"
	}
#line 223 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	result = _tmp23_;
#line 223 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	if (processed_mk) {
#line 223 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		*processed_mk = _vala_processed_mk;
#line 1658 "Viewer.c"
	} else {
#line 223 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_g_free0 (_vala_processed_mk);
#line 1662 "Viewer.c"
	}
#line 223 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	return result;
#line 1666 "Viewer.c"
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
#line 1563 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1564 "glib-2.0.vapi"
	res = (guint8*) self;
#line 1564 "glib-2.0.vapi"
	res_length1 = -1;
#line 1564 "glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1565 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1565 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1565 "glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1566 "glib-2.0.vapi"
	_tmp2_ = res;
#line 1566 "glib-2.0.vapi"
	_tmp2__length1 = res_length1;
#line 1566 "glib-2.0.vapi"
	if (result_length1) {
#line 1566 "glib-2.0.vapi"
		*result_length1 = _tmp2__length1;
#line 1703 "Viewer.c"
	}
#line 1566 "glib-2.0.vapi"
	result = _tmp2_;
#line 1566 "glib-2.0.vapi"
	return result;
#line 1709 "Viewer.c"
}

static gchar*
enotes_viewer_process (ENotesViewer* self,
                       const gchar* raw_mk)
{
	gchar* processed_mk = NULL;
	gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	MMIOT* mkd = NULL;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	guint8* _tmp6_;
	gint _tmp6__length1;
	MMIOT* _tmp7_;
	gchar* _result_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* html = NULL;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* result;
#line 226 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 226 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_return_val_if_fail (raw_mk != NULL, NULL);
#line 228 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp2_ = enotes_viewer_process_frontmatter (self, raw_mk, &_tmp0_, &_tmp1_);
#line 228 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_g_free0 (processed_mk);
#line 228 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	processed_mk = _tmp0_;
#line 228 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp3_ = _tmp2_;
#line 228 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp3__length1 = _tmp1_;
#line 228 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
#line 230 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp4_ = string_get_data (processed_mk, &_tmp5_);
#line 230 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp4__length1 = _tmp5_;
#line 230 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp6_ = _tmp4_;
#line 230 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp6__length1 = _tmp4__length1;
#line 230 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp7_ = mkd_string (_tmp6_, _tmp6__length1, ((((0x00200000 + 0x00004000) + 0x02000000) + 0x01000000) + 0x00400000) + 0x40000000);
#line 230 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	mkd = _tmp7_;
#line 231 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	mkd_compile (mkd, ((((0x00200000 + 0x00004000) + 0x02000000) + 0x01000000) + 0x00400000) + 0x40000000);
#line 234 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	mkd_document (mkd, &_tmp8_);
#line 234 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_g_free0 (_result_);
#line 234 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 234 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_result_ = _tmp9_;
#line 236 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp10_ = g_strdup ("<!doctype html><meta charset=utf-8><head>");
#line 236 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	html = _tmp10_;
#line 237 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp11_ = html;
#line 237 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp12_ = self->CSS;
#line 237 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp13_ = g_strconcat ("<style>", _tmp12_, NULL);
#line 237 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp14_ = _tmp13_;
#line 237 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp15_ = g_strconcat (_tmp14_, "</style>", NULL);
#line 237 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp16_ = _tmp15_;
#line 237 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp17_ = g_strconcat (_tmp11_, _tmp16_, NULL);
#line 237 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_g_free0 (html);
#line 237 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	html = _tmp17_;
#line 237 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_g_free0 (_tmp16_);
#line 237 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_g_free0 (_tmp14_);
#line 238 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp18_ = html;
#line 238 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp19_ = g_strconcat (_tmp18_, "</head><body><div class=\"markdown-body\">", NULL);
#line 238 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_g_free0 (html);
#line 238 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	html = _tmp19_;
#line 239 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp20_ = html;
#line 239 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp21_ = enotes_viewer_process_plugins (self, _result_);
#line 239 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp22_ = _tmp21_;
#line 239 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp23_ = g_strconcat (_tmp20_, _tmp22_, NULL);
#line 239 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_g_free0 (html);
#line 239 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	html = _tmp23_;
#line 239 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_g_free0 (_tmp22_);
#line 240 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp24_ = html;
#line 240 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp25_ = g_strconcat (_tmp24_, "</div></body></html>", NULL);
#line 240 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_g_free0 (html);
#line 240 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	html = _tmp25_;
#line 242 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	result = html;
#line 242 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_g_free0 (_result_);
#line 242 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_mkd_cleanup0 (mkd);
#line 242 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_g_free0 (processed_mk);
#line 242 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	return result;
#line 1854 "Viewer.c"
}

static gchar*
enotes_viewer_process_plugins (ENotesViewer* self,
                               const gchar* raw_mk)
{
	gchar** lines = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint lines_length1;
	gint _lines_size_;
	gchar* build = NULL;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* result;
#line 245 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 245 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_return_val_if_fail (raw_mk != NULL, NULL);
#line 246 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp1_ = _tmp0_ = g_strsplit (raw_mk, "\n", 0);
#line 246 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	lines = _tmp1_;
#line 246 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	lines_length1 = _vala_array_length (_tmp0_);
#line 246 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_lines_size_ = lines_length1;
#line 247 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp2_ = g_strdup ("");
#line 247 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	build = _tmp2_;
#line 248 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp3_ = lines;
#line 248 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp3__length1 = lines_length1;
#line 1891 "Viewer.c"
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
#line 248 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		line_collection = _tmp3_;
#line 248 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		line_collection_length1 = _tmp3__length1;
#line 248 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
#line 1903 "Viewer.c"
			gchar* _tmp4_;
			gchar* line = NULL;
#line 248 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			_tmp4_ = g_strdup (line_collection[line_it]);
#line 248 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
			line = _tmp4_;
#line 1910 "Viewer.c"
			{
				gboolean found = FALSE;
				ENotesPluginManager* _tmp5_;
				ENotesPluginManager* _tmp6_;
				gint _tmp7_ = 0;
				ENotesPlugin** _tmp8_;
				ENotesPlugin** _tmp9_;
				gint _tmp9__length1;
#line 249 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				found = FALSE;
#line 250 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp5_ = enotes_plugin_manager_get_instance ();
#line 250 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp6_ = _tmp5_;
#line 250 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp8_ = enotes_plugin_manager_get_plugs (_tmp6_, &_tmp7_);
#line 250 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp9_ = _tmp8_;
#line 250 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_tmp9__length1 = _tmp7_;
#line 250 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_g_object_unref0 (_tmp6_);
#line 1933 "Viewer.c"
				{
					ENotesPlugin** plugin_collection = NULL;
					gint plugin_collection_length1 = 0;
					gint _plugin_collection_size_ = 0;
					gint plugin_it = 0;
#line 250 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
					plugin_collection = _tmp9_;
#line 250 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
					plugin_collection_length1 = _tmp9__length1;
#line 250 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
					for (plugin_it = 0; plugin_it < plugin_collection_length1; plugin_it = plugin_it + 1) {
#line 1945 "Viewer.c"
						ENotesPlugin* _tmp10_;
						ENotesPlugin* plugin = NULL;
#line 250 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
						_tmp10_ = _g_object_ref0 (plugin_collection[plugin_it]);
#line 250 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
						plugin = _tmp10_;
#line 1952 "Viewer.c"
						{
							ENotesPlugin* _tmp11_;
							const gchar* _tmp12_;
#line 251 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
							_tmp11_ = plugin;
#line 251 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
							_tmp12_ = line;
#line 251 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
							if (enotes_plugin_has_match (_tmp11_, _tmp12_)) {
#line 1962 "Viewer.c"
								const gchar* _tmp13_;
								ENotesPlugin* _tmp14_;
								const gchar* _tmp15_;
								gchar* _tmp16_;
								gchar* _tmp17_;
								gchar* _tmp18_;
								gchar* _tmp19_;
								gchar* _tmp20_;
#line 252 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
								_tmp13_ = build;
#line 252 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
								_tmp14_ = plugin;
#line 252 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
								_tmp15_ = line;
#line 252 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
								_tmp16_ = enotes_plugin_convert (_tmp14_, _tmp15_);
#line 252 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
								_tmp17_ = _tmp16_;
#line 252 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
								_tmp18_ = g_strconcat (_tmp13_, _tmp17_, NULL);
#line 252 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
								_tmp19_ = _tmp18_;
#line 252 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
								_tmp20_ = g_strconcat (_tmp19_, "\n", NULL);
#line 252 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
								_g_free0 (build);
#line 252 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
								build = _tmp20_;
#line 252 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
								_g_free0 (_tmp19_);
#line 252 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
								_g_free0 (_tmp17_);
#line 253 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
								found = TRUE;
#line 254 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
								_g_object_unref0 (plugin);
#line 254 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
								break;
#line 2001 "Viewer.c"
							}
#line 250 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
							_g_object_unref0 (plugin);
#line 2005 "Viewer.c"
						}
					}
				}
#line 258 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				if (!found) {
#line 2011 "Viewer.c"
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
#line 259 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
					_tmp21_ = build;
#line 259 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
					_tmp22_ = line;
#line 259 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
					_tmp23_ = g_strconcat (_tmp21_, _tmp22_, NULL);
#line 259 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
					_tmp24_ = _tmp23_;
#line 259 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
					_tmp25_ = g_strconcat (_tmp24_, "\n", NULL);
#line 259 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
					_g_free0 (build);
#line 259 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
					build = _tmp25_;
#line 259 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
					_g_free0 (_tmp24_);
#line 2033 "Viewer.c"
				}
#line 248 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
				_g_free0 (line);
#line 2037 "Viewer.c"
			}
		}
	}
#line 263 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	result = build;
#line 263 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 263 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	return result;
#line 2047 "Viewer.c"
}

static gchar*
enotes_viewer_get_theme_color_css (ENotesViewer* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp5_;
	gchar* result;
#line 266 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 267 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp0_ = enotes_app;
#line 267 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp1_ = _tmp0_->state;
#line 267 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp2_ = enotes_application_state_get_style_scheme (_tmp1_);
#line 267 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp3_ = _tmp2_;
#line 267 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	if (g_strcmp0 (_tmp3_, "solarized-dark") == 0) {
#line 2071 "Viewer.c"
		gchar* _tmp4_;
#line 268 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		_tmp4_ = g_strdup (ENOTES_VIEWER_DARK_THEME);
#line 268 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		result = _tmp4_;
#line 268 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
		return result;
#line 2079 "Viewer.c"
	}
#line 271 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_tmp5_ = g_strdup ("");
#line 271 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	result = _tmp5_;
#line 271 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	return result;
#line 2087 "Viewer.c"
}

static void
enotes_viewer_class_init (ENotesViewerClass * klass,
                          gpointer klass_data)
{
#line 22 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	enotes_viewer_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	g_type_class_adjust_private_offset (klass, &ENotesViewer_private_offset);
#line 22 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	G_OBJECT_CLASS (klass)->finalize = enotes_viewer_finalize;
#line 2100 "Viewer.c"
}

static void
enotes_viewer_instance_init (ENotesViewer * self,
                             gpointer klass)
{
#line 22 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	self->priv = enotes_viewer_get_instance_private (self);
#line 24 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	self->priv->previous_page = NULL;
#line 2111 "Viewer.c"
}

static void
enotes_viewer_finalize (GObject * obj)
{
	ENotesViewer * self;
#line 22 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_VIEWER, ENotesViewer);
#line 23 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_g_free0 (self->CSS);
#line 24 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_g_object_unref0 (self->priv->previous_page);
#line 25 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	_enotes_style_loader_unref0 (self->priv->style_loader);
#line 22 "../Notes-up-2.0.6/src/Widgets/Viewer.vala"
	G_OBJECT_CLASS (enotes_viewer_parent_class)->finalize (obj);
#line 2128 "Viewer.c"
}

static GType
enotes_viewer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesViewerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_viewer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesViewer), 0, (GInstanceInitFunc) enotes_viewer_instance_init, NULL };
	GType enotes_viewer_type_id;
	enotes_viewer_type_id = g_type_register_static (webkit_web_view_get_type (), "ENotesViewer", &g_define_type_info, 0);
	ENotesViewer_private_offset = g_type_add_instance_private (enotes_viewer_type_id, sizeof (ENotesViewerPrivate));
	return enotes_viewer_type_id;
}

GType
enotes_viewer_get_type (void)
{
	static volatile gsize enotes_viewer_type_id__once = 0;
	if (g_once_init_enter (&enotes_viewer_type_id__once)) {
		GType enotes_viewer_type_id;
		enotes_viewer_type_id = enotes_viewer_get_type_once ();
		g_once_init_leave (&enotes_viewer_type_id__once, enotes_viewer_type_id);
	}
	return enotes_viewer_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

