/* PagesList.c generated by valac 0.56.12, the Vala compiler
 * generated from PagesList.vala, do not modify */

/*
* Copyright (c) 2011-2016 Felipe Escoto (https://github.com/Philip-Scott/Notes-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <granite.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gdk/gdk.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ENOTES_TYPE_PAGES_LIST (enotes_pages_list_get_type ())
#define ENOTES_PAGES_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGES_LIST, ENotesPagesList))
#define ENOTES_PAGES_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGES_LIST, ENotesPagesListClass))
#define ENOTES_IS_PAGES_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGES_LIST))
#define ENOTES_IS_PAGES_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGES_LIST))
#define ENOTES_PAGES_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGES_LIST, ENotesPagesListClass))

typedef struct _ENotesPagesList ENotesPagesList;
typedef struct _ENotesPagesListClass ENotesPagesListClass;
typedef struct _ENotesPagesListPrivate ENotesPagesListPrivate;

#define ENOTES_TYPE_PAGE_ITEM (enotes_page_item_get_type ())
#define ENOTES_PAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGE_ITEM, ENotesPageItem))
#define ENOTES_PAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGE_ITEM, ENotesPageItemClass))
#define ENOTES_IS_PAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGE_ITEM))
#define ENOTES_IS_PAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGE_ITEM))
#define ENOTES_PAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGE_ITEM, ENotesPageItemClass))

typedef struct _ENotesPageItem ENotesPageItem;
typedef struct _ENotesPageItemClass ENotesPageItemClass;
enum  {
	ENOTES_PAGES_LIST_0_PROPERTY,
	ENOTES_PAGES_LIST_NUM_PROPERTIES
};
static GParamSpec* enotes_pages_list_properties[ENOTES_PAGES_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define ENOTES_TYPE_PAGE_TABLE (enotes_page_table_get_type ())
#define ENOTES_PAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGE_TABLE, ENotesPageTable))
#define ENOTES_PAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGE_TABLE, ENotesPageTableClass))
#define ENOTES_IS_PAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGE_TABLE))
#define ENOTES_IS_PAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGE_TABLE))
#define ENOTES_PAGE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGE_TABLE, ENotesPageTableClass))

typedef struct _ENotesPageTable ENotesPageTable;
typedef struct _ENotesPageTableClass ENotesPageTableClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))

#define ENOTES_TYPE_PAGE (enotes_page_get_type ())
#define ENOTES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGE, ENotesPage))
#define ENOTES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGE, ENotesPageClass))
#define ENOTES_IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGE))
#define ENOTES_IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGE))
#define ENOTES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGE, ENotesPageClass))

typedef struct _ENotesPage ENotesPage;
typedef struct _ENotesPageClass ENotesPageClass;
typedef struct _ENotesPagePrivate ENotesPagePrivate;
typedef enum  {
	ENOTES_MODE_NONE = -1,
	ENOTES_MODE_VIEW = 0,
	ENOTES_MODE_EDIT = 1,
	ENOTES_MODE_BOTH = 2
} ENotesMode;

#define ENOTES_TYPE_MODE (enotes_mode_get_type ())

#define ENOTES_TYPE_APPLICATION (enotes_application_get_type ())
#define ENOTES_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_APPLICATION, ENotesApplication))
#define ENOTES_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_APPLICATION, ENotesApplicationClass))
#define ENOTES_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_APPLICATION))
#define ENOTES_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_APPLICATION))
#define ENOTES_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_APPLICATION, ENotesApplicationClass))

typedef struct _ENotesApplication ENotesApplication;
typedef struct _ENotesApplicationClass ENotesApplicationClass;
typedef struct _ENotesApplicationPrivate ENotesApplicationPrivate;

#define ENOTES_APPLICATION_TYPE_STATE (enotes_application_state_get_type ())
#define ENOTES_APPLICATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationState))
#define ENOTES_APPLICATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationStateClass))
#define ENOTES_APPLICATION_IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_APPLICATION_TYPE_STATE))
#define ENOTES_APPLICATION_IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_APPLICATION_TYPE_STATE))
#define ENOTES_APPLICATION_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationStateClass))

typedef struct _ENotesApplicationState ENotesApplicationState;
typedef struct _ENotesApplicationStateClass ENotesApplicationStateClass;

#define ENOTES_TYPE_NOTEBOOK (enotes_notebook_get_type ())
#define ENOTES_NOTEBOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_NOTEBOOK, ENotesNotebook))
#define ENOTES_NOTEBOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_NOTEBOOK, ENotesNotebookClass))
#define ENOTES_IS_NOTEBOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_NOTEBOOK))
#define ENOTES_IS_NOTEBOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_NOTEBOOK))
#define ENOTES_NOTEBOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_NOTEBOOK, ENotesNotebookClass))

typedef struct _ENotesNotebook ENotesNotebook;
typedef struct _ENotesNotebookClass ENotesNotebookClass;
typedef struct _ENotesNotebookPrivate ENotesNotebookPrivate;

#define ENOTES_TYPE_TAG (enotes_tag_get_type ())
#define ENOTES_TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_TAG, ENotesTag))
#define ENOTES_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_TAG, ENotesTagClass))
#define ENOTES_IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_TAG))
#define ENOTES_IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_TAG))
#define ENOTES_TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_TAG, ENotesTagClass))

typedef struct _ENotesTag ENotesTag;
typedef struct _ENotesTagClass ENotesTagClass;

#define ENOTES_TYPE_TAGS_TABLE (enotes_tags_table_get_type ())
#define ENOTES_TAGS_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_TAGS_TABLE, ENotesTagsTable))
#define ENOTES_TAGS_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_TAGS_TABLE, ENotesTagsTableClass))
#define ENOTES_IS_TAGS_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_TAGS_TABLE))
#define ENOTES_IS_TAGS_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_TAGS_TABLE))
#define ENOTES_TAGS_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_TAGS_TABLE, ENotesTagsTableClass))

typedef struct _ENotesTagsTable ENotesTagsTable;
typedef struct _ENotesTagsTableClass ENotesTagsTableClass;
typedef struct _ENotesTagPrivate ENotesTagPrivate;

#define ENOTES_TYPE_VIEW_EDIT_STACK (enotes_view_edit_stack_get_type ())
#define ENOTES_VIEW_EDIT_STACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_VIEW_EDIT_STACK, ENotesViewEditStack))
#define ENOTES_VIEW_EDIT_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_VIEW_EDIT_STACK, ENotesViewEditStackClass))
#define ENOTES_IS_VIEW_EDIT_STACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_VIEW_EDIT_STACK))
#define ENOTES_IS_VIEW_EDIT_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_VIEW_EDIT_STACK))
#define ENOTES_VIEW_EDIT_STACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_VIEW_EDIT_STACK, ENotesViewEditStackClass))

typedef struct _ENotesViewEditStack ENotesViewEditStack;
typedef struct _ENotesViewEditStackClass ENotesViewEditStackClass;

#define ENOTES_TYPE_EDITOR (enotes_editor_get_type ())
#define ENOTES_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_EDITOR, ENotesEditor))
#define ENOTES_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_EDITOR, ENotesEditorClass))
#define ENOTES_IS_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_EDITOR))
#define ENOTES_IS_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_EDITOR))
#define ENOTES_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_EDITOR, ENotesEditorClass))

typedef struct _ENotesEditor ENotesEditor;
typedef struct _ENotesEditorClass ENotesEditorClass;

#define ENOTES_TYPE_TRASH (enotes_trash_get_type ())
#define ENOTES_TRASH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_TRASH, ENotesTrash))
#define ENOTES_TRASH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_TRASH, ENotesTrashClass))
#define ENOTES_IS_TRASH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_TRASH))
#define ENOTES_IS_TRASH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_TRASH))
#define ENOTES_TRASH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_TRASH, ENotesTrashClass))

typedef struct _ENotesTrash ENotesTrash;
typedef struct _ENotesTrashClass ENotesTrashClass;

struct _ENotesPagesList {
	GtkBox parent_instance;
	ENotesPagesListPrivate * priv;
	GtkListBox* listbox;
};

struct _ENotesPagesListClass {
	GtkBoxClass parent_class;
};

struct _ENotesPagesListPrivate {
	GtkFrame* toolbar;
	GtkSeparator* separator;
	GtkButton* minus_button;
	GtkButton* plus_button;
	GtkLabel* notebook_name;
	GtkLabel* page_total;
	gchar* search_for;
	gboolean loading_pages;
	gboolean selecting;
	GeeHashMap* added_pages;
};

struct _ENotesPage {
	GObject parent_instance;
	ENotesPagePrivate * priv;
	gint64 id;
	gint64 notebook_id;
	gchar* name;
	gchar* data;
	gchar* subtitle;
	gchar* html_cache;
	gint64 creation_date;
	gint64 modification_date;
	gboolean new_page;
	gboolean cache_changed;
	gchar* full_path;
};

struct _ENotesPageClass {
	GObjectClass parent_class;
};

struct _ENotesApplication {
	GraniteApplication parent_instance;
	ENotesApplicationPrivate * priv;
	gboolean running;
	ENotesApplicationState* state;
};

struct _ENotesApplicationClass {
	GraniteApplicationClass parent_class;
};

struct _ENotesNotebook {
	GObject parent_instance;
	ENotesNotebookPrivate * priv;
	gint64 id;
	gint64* parent_id;
	GdkRGBA rgb;
	gchar* name;
	gchar* css;
	gchar* stylesheet;
};

struct _ENotesNotebookClass {
	GObjectClass parent_class;
};

struct _ENotesTag {
	GObject parent_instance;
	ENotesTagPrivate * priv;
	gint64 id;
	gchar* name;
	gchar* data;
};

struct _ENotesTagClass {
	GObjectClass parent_class;
};

static gint ENotesPagesList_private_offset;
static gpointer enotes_pages_list_parent_class = NULL;
static ENotesPagesList* enotes_pages_list_instance;
static ENotesPagesList* enotes_pages_list_instance = NULL;
VALA_EXTERN ENotesApplication* enotes_app;

VALA_EXTERN GType enotes_pages_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPagesList, g_object_unref)
VALA_EXTERN GType enotes_page_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPageItem, g_object_unref)
VALA_EXTERN ENotesPagesList* enotes_pages_list_get_instance (void);
static ENotesPagesList* enotes_pages_list_new (void);
static ENotesPagesList* enotes_pages_list_construct (GType object_type);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType enotes_page_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPageTable, database_table_unref)
VALA_EXTERN ENotesPageTable* enotes_page_table_get_instance (void);
static void enotes_pages_list_build_ui (ENotesPagesList* self);
static void enotes_pages_list_connect_signals (ENotesPagesList* self);
static gboolean __lambda19_ (ENotesPagesList* self,
                      GtkListBoxRow* row);
VALA_EXTERN GType enotes_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPage, g_object_unref)
VALA_EXTERN ENotesPage* enotes_page_item_get_page (ENotesPageItem* self);
static gboolean ___lambda19__gtk_list_box_filter_func (GtkListBoxRow* row,
                                                gpointer self);
static gint __lambda20_ (ENotesPagesList* self,
                  GtkListBoxRow* row1,
                  GtkListBoxRow* row2);
static gint ___lambda20__gtk_list_box_sort_func (GtkListBoxRow* row1,
                                          GtkListBoxRow* row2,
                                          gpointer self);
static GtkFrame* enotes_pages_list_build_toolbar (ENotesPagesList* self);
VALA_EXTERN GType enotes_mode_get_type (void) G_GNUC_CONST ;
static void enotes_pages_list_toolbar_mode (ENotesPagesList* self,
                                     ENotesMode* mode);
VALA_EXTERN GType enotes_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesApplication, g_object_unref)
VALA_EXTERN GType enotes_application_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesApplicationState, g_object_unref)
VALA_EXTERN ENotesMode enotes_application_state_get_mode (ENotesApplicationState* self);
VALA_EXTERN void enotes_pages_list_clear_pages (ENotesPagesList* self);
VALA_EXTERN void enotes_pages_list_refresh (ENotesPagesList* self);
VALA_EXTERN GType enotes_notebook_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesNotebook, g_object_unref)
VALA_EXTERN ENotesNotebook* enotes_application_state_get_opened_notebook (ENotesApplicationState* self);
static void enotes_pages_list_load_pages (ENotesPagesList* self,
                                   ENotesNotebook* notebook);
VALA_EXTERN void enotes_pages_list_load_all_pages (ENotesPagesList* self);
static gboolean enotes_pages_list_select_page (ENotesPagesList* self,
                                        ENotesPage* page);
VALA_EXTERN gboolean enotes_page_equals (ENotesPage* self,
                             ENotesPage* page);
VALA_EXTERN GeeArrayList* enotes_page_table_get_pages (ENotesPageTable* self,
                                           gint64 notebook_id);
static void enotes_pages_list_load_page_list (ENotesPagesList* self,
                                       GeeArrayList* pages);
VALA_EXTERN GType enotes_tag_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesTag, g_object_unref)
static void enotes_pages_list_load_pages_for_tag (ENotesPagesList* self,
                                           ENotesTag* tag);
VALA_EXTERN GType enotes_tags_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesTagsTable, database_table_unref)
VALA_EXTERN ENotesTagsTable* enotes_tags_table_get_instance (void);
VALA_EXTERN GeeArrayList* enotes_tags_table_get_pages_for_tag (ENotesTagsTable* self,
                                                   ENotesTag* tag);
VALA_EXTERN GeeArrayList* enotes_page_table_get_all_pages (ENotesPageTable* self);
static ENotesPageItem* enotes_pages_list_new_page (ENotesPagesList* self,
                                            ENotesPage* page);
VALA_EXTERN ENotesPage* enotes_application_state_get_opened_page (ENotesApplicationState* self);
VALA_EXTERN ENotesPageItem* enotes_page_item_new (ENotesPage* page);
VALA_EXTERN ENotesPageItem* enotes_page_item_construct (GType object_type,
                                            ENotesPage* page);
VALA_EXTERN void enotes_pages_list_new_blank_page (ENotesPagesList* self);
VALA_EXTERN GType enotes_view_edit_stack_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesViewEditStack, g_object_unref)
VALA_EXTERN ENotesViewEditStack* enotes_view_edit_stack_get_instance (void);
VALA_EXTERN GType enotes_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesEditor, g_object_unref)
VALA_EXTERN ENotesEditor* enotes_view_edit_stack_get_editor (ENotesViewEditStack* self);
VALA_EXTERN void enotes_editor_save_file (ENotesEditor* self);
VALA_EXTERN ENotesPage* enotes_page_table_new_page (ENotesPageTable* self,
                                        gint64 notebook_id);
VALA_EXTERN void enotes_pages_list_grab_focus (ENotesPagesList* self);
static gboolean _enotes_mode_equal (const ENotesMode * s1,
                             const ENotesMode * s2);
static void __lambda21_ (ENotesPagesList* self);
static void ___lambda21__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda22_ (ENotesPagesList* self);
VALA_EXTERN const gchar* enotes_application_state_get_search_field (ENotesApplicationState* self);
static void ___lambda22__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda23_ (ENotesPagesList* self);
static void ___lambda23__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda24_ (ENotesPagesList* self,
                  ENotesTag* tag);
static void ___lambda24__enotes_application_state_show_pages_in_tag (ENotesApplicationState* _sender,
                                                              ENotesTag* tag,
                                                              gpointer self);
static void __lambda25_ (ENotesPagesList* self);
static void ___lambda25__enotes_application_state_show_all_pages (ENotesApplicationState* _sender,
                                                           gpointer self);
static void __lambda26_ (ENotesPagesList* self);
static void ___lambda26__enotes_application_state_notebook_contents_changed (ENotesApplicationState* _sender,
                                                                      gpointer self);
static void __lambda27_ (ENotesPagesList* self);
static void ___lambda27__enotes_application_state_load_all_pages (ENotesApplicationState* _sender,
                                                           gpointer self);
static void __lambda28_ (ENotesPagesList* self);
static void ___lambda28__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda29_ (ENotesPagesList* self);
static void ___lambda29__enotes_application_state_search_selected (ENotesApplicationState* _sender,
                                                            gpointer self);
static void __lambda30_ (ENotesPagesList* self);
static void ___lambda30__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda31_ (ENotesPagesList* self);
VALA_EXTERN GType enotes_trash_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesTrash, g_object_unref)
VALA_EXTERN ENotesTrash* enotes_trash_get_instance (void);
VALA_EXTERN void enotes_trash_trash_page (ENotesTrash* self,
                              ENotesPage* page);
static void ___lambda31__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda32_ (ENotesPagesList* self,
                  GtkListBoxRow* row);
VALA_EXTERN void enotes_application_state_open_page (ENotesApplicationState* self,
                                         gint64 page_id);
static void ___lambda32__gtk_list_box_row_selected (GtkListBox* _sender,
                                             GtkListBoxRow* row,
                                             gpointer self);
static void __lambda33_ (ENotesPagesList* self,
                  GtkListBoxRow* row);
VALA_EXTERN void enotes_application_state_toggle_app_mode (ENotesApplicationState* self);
VALA_EXTERN void enotes_editor_give_focus (ENotesEditor* self);
static void ___lambda33__gtk_list_box_row_activated (GtkListBox* _sender,
                                              GtkListBoxRow* row,
                                              gpointer self);
static void __lambda34_ (ENotesPagesList* self,
                  ENotesPage* page);
VALA_EXTERN void enotes_page_item_set_page (ENotesPageItem* self,
                                ENotesPage* value);
VALA_EXTERN void enotes_page_item_load_data (ENotesPageItem* self);
static void ___lambda34__enotes_page_table_page_saved (ENotesPageTable* _sender,
                                                ENotesPage* page,
                                                gpointer self);
static void enotes_pages_list_translations (ENotesPagesList* self);
static void enotes_pages_list_finalize (GObject * obj);
static GType enotes_pages_list_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
enotes_pages_list_get_instance_private (ENotesPagesList* self)
{
	return G_STRUCT_MEMBER_P (self, ENotesPagesList_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 45 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	return self ? g_object_ref (self) : NULL;
#line 469 "PagesList.c"
}

ENotesPagesList*
enotes_pages_list_get_instance (void)
{
	ENotesPagesList* _tmp0_;
	ENotesPagesList* _tmp2_;
	ENotesPagesList* _tmp3_;
	ENotesPagesList* result;
#line 41 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = enotes_pages_list_instance;
#line 41 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	if (_tmp0_ == NULL) {
#line 483 "PagesList.c"
		ENotesPagesList* _tmp1_;
#line 42 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp1_ = enotes_pages_list_new ();
#line 42 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		g_object_ref_sink (_tmp1_);
#line 42 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_g_object_unref0 (enotes_pages_list_instance);
#line 42 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		enotes_pages_list_instance = _tmp1_;
#line 493 "PagesList.c"
	}
#line 45 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = enotes_pages_list_instance;
#line 45 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 45 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	result = _tmp3_;
#line 45 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	return result;
#line 503 "PagesList.c"
}

static ENotesPagesList*
enotes_pages_list_construct (GType object_type)
{
	ENotesPagesList * self = NULL;
	GeeHashMap* _tmp0_;
	ENotesPageTable* _tmp1_;
	ENotesPageTable* _tmp2_;
#line 48 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	self = (ENotesPagesList*) g_object_new (object_type, NULL);
#line 49 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, ENOTES_TYPE_PAGE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 49 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (self->priv->added_pages);
#line 49 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	self->priv->added_pages = _tmp0_;
#line 51 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp1_ = enotes_page_table_get_instance ();
#line 51 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = _tmp1_;
#line 51 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_database_table_unref0 (_tmp2_);
#line 53 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	enotes_pages_list_build_ui (self);
#line 54 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	enotes_pages_list_connect_signals (self);
#line 48 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	return self;
#line 533 "PagesList.c"
}

static ENotesPagesList*
enotes_pages_list_new (void)
{
#line 48 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	return enotes_pages_list_construct (ENOTES_TYPE_PAGES_LIST);
#line 541 "PagesList.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1538 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1538 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1539 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1539 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1539 "glib-2.0.vapi"
	return result;
#line 560 "PagesList.c"
}

static gboolean
__lambda19_ (ENotesPagesList* self,
             GtkListBoxRow* row)
{
	const gchar* _tmp0_;
	gboolean result;
#line 66 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_val_if_fail (row != NULL, FALSE);
#line 67 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = self->priv->search_for;
#line 67 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	if (g_strcmp0 (_tmp0_, "") != 0) {
#line 575 "PagesList.c"
		ENotesPage* page = NULL;
		ENotesPage* _tmp1_;
		ENotesPage* _tmp2_;
		ENotesPage* _tmp3_;
		gboolean _tmp4_ = FALSE;
		ENotesPage* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gboolean _tmp10_;
#line 68 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp1_ = enotes_page_item_get_page (G_TYPE_CHECK_INSTANCE_CAST (row, ENOTES_TYPE_PAGE_ITEM, ENotesPageItem));
#line 68 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp2_ = _tmp1_;
#line 68 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 68 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		page = _tmp3_;
#line 69 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp5_ = page;
#line 69 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp6_ = _tmp5_->name;
#line 69 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
#line 69 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp8_ = _tmp7_;
#line 69 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp9_ = self->priv->search_for;
#line 69 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp10_ = string_contains (_tmp8_, _tmp9_);
#line 69 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_g_free0 (_tmp8_);
#line 69 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		if (_tmp10_) {
#line 69 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			_tmp4_ = TRUE;
#line 613 "PagesList.c"
		} else {
			ENotesPage* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
#line 69 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			_tmp11_ = page;
#line 69 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			_tmp12_ = _tmp11_->data;
#line 69 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			_tmp13_ = g_utf8_strdown (_tmp12_, (gssize) -1);
#line 69 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			_tmp14_ = _tmp13_;
#line 69 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			_tmp15_ = self->priv->search_for;
#line 69 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			_tmp4_ = string_contains (_tmp14_, _tmp15_);
#line 69 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			_g_free0 (_tmp14_);
#line 634 "PagesList.c"
		}
#line 69 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		result = _tmp4_;
#line 69 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_g_object_unref0 (page);
#line 69 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		return result;
#line 642 "PagesList.c"
	}
#line 72 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	result = TRUE;
#line 72 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	return result;
#line 648 "PagesList.c"
}

static gboolean
___lambda19__gtk_list_box_filter_func (GtkListBoxRow* row,
                                       gpointer self)
{
	gboolean result;
	result = __lambda19_ ((ENotesPagesList*) self, row);
#line 66 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	return result;
#line 659 "PagesList.c"
}

static gint
__lambda20_ (ENotesPagesList* self,
             GtkListBoxRow* row1,
             GtkListBoxRow* row2)
{
	gint64 a = 0LL;
	ENotesPage* _tmp0_;
	ENotesPage* _tmp1_;
	gint64 b = 0LL;
	ENotesPage* _tmp2_;
	ENotesPage* _tmp3_;
	gint result;
#line 75 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_val_if_fail (row1 != NULL, 0);
#line 75 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_val_if_fail (row2 != NULL, 0);
#line 76 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = enotes_page_item_get_page (G_TYPE_CHECK_INSTANCE_CAST (row1, ENOTES_TYPE_PAGE_ITEM, ENotesPageItem));
#line 76 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp1_ = _tmp0_;
#line 76 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	a = _tmp1_->id;
#line 77 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = enotes_page_item_get_page (G_TYPE_CHECK_INSTANCE_CAST (row2, ENOTES_TYPE_PAGE_ITEM, ENotesPageItem));
#line 77 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp3_ = _tmp2_;
#line 77 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	b = _tmp3_->id;
#line 79 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	if (a > b) {
#line 79 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		result = -1;
#line 79 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		return result;
#line 696 "PagesList.c"
	}
#line 80 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	if (b > a) {
#line 80 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		result = 1;
#line 80 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		return result;
#line 704 "PagesList.c"
	}
#line 82 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	result = 0;
#line 82 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	return result;
#line 710 "PagesList.c"
}

static gint
___lambda20__gtk_list_box_sort_func (GtkListBoxRow* row1,
                                     GtkListBoxRow* row2,
                                     gpointer self)
{
	gint result;
	result = __lambda20_ ((ENotesPagesList*) self, row1, row2);
#line 75 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	return result;
#line 722 "PagesList.c"
}

static void
enotes_pages_list_build_ui (ENotesPagesList* self)
{
	GtkScrolledWindow* scroll_box = NULL;
	GtkScrolledWindow* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBox* _tmp2_;
	GtkListBox* _tmp3_;
	GtkListBox* _tmp4_;
	GtkListBox* _tmp5_;
	GtkListBox* _tmp6_;
	GtkListBox* _tmp7_;
	GtkFrame* _tmp8_;
	GtkListBox* _tmp9_;
	GtkFrame* _tmp10_;
	ENotesApplication* _tmp11_;
	ENotesApplicationState* _tmp12_;
	ENotesMode _tmp13_;
	ENotesMode _tmp14_;
#line 57 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_if_fail (self != NULL);
#line 58 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
#line 60 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 60 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_object_ref_sink (_tmp0_);
#line 60 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	scroll_box = _tmp0_;
#line 61 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp1_ = (GtkListBox*) gtk_list_box_new ();
#line 61 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_object_ref_sink (_tmp1_);
#line 61 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (self->listbox);
#line 61 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	self->listbox = _tmp1_;
#line 62 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = self->listbox;
#line 62 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_vexpand ((GtkWidget*) _tmp2_, TRUE);
#line 63 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp3_ = self->listbox;
#line 63 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_list_box_set_selection_mode (_tmp3_, GTK_SELECTION_MULTIPLE);
#line 64 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp4_ = self->listbox;
#line 64 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_list_box_set_activate_on_single_click (_tmp4_, FALSE);
#line 65 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp5_ = self->listbox;
#line 65 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp5_, 200, 250);
#line 66 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp6_ = self->listbox;
#line 66 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_list_box_set_filter_func (_tmp6_, ___lambda19__gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
#line 75 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp7_ = self->listbox;
#line 75 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_list_box_set_sort_func (_tmp7_, ___lambda20__gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
#line 85 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_size_request ((GtkWidget*) scroll_box, 200, 250);
#line 86 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp8_ = enotes_pages_list_build_toolbar (self);
#line 86 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (self->priv->toolbar);
#line 86 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	self->priv->toolbar = _tmp8_;
#line 88 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp9_ = self->listbox;
#line 88 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_container_add ((GtkContainer*) scroll_box, (GtkWidget*) _tmp9_);
#line 89 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) scroll_box);
#line 90 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp10_ = self->priv->toolbar;
#line 90 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp10_);
#line 92 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp11_ = enotes_app;
#line 92 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp12_ = _tmp11_->state;
#line 92 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp13_ = enotes_application_state_get_mode (_tmp12_);
#line 92 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp14_ = _tmp13_;
#line 92 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	enotes_pages_list_toolbar_mode (self, &_tmp14_);
#line 57 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (scroll_box);
#line 816 "PagesList.c"
}

static GtkFrame*
enotes_pages_list_build_toolbar (ENotesPagesList* self)
{
	GtkFrame* frame = NULL;
	GtkFrame* _tmp0_;
	GtkBox* box = NULL;
	GtkBox* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	ENotesApplication* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GtkButton* _tmp10_;
	GtkStyleContext* _tmp11_;
	GtkButton* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	GtkButton* _tmp15_;
	GtkStyleContext* _tmp16_;
	GtkButton* _tmp17_;
	GtkButton* _tmp18_;
	GtkButton* _tmp19_;
	GtkButton* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	GtkSeparator* _tmp23_;
	GtkLabel* _tmp24_;
	GtkLabel* _tmp25_;
	GtkSeparator* _tmp26_;
	GtkLabel* _tmp27_;
	GtkSeparator* _tmp28_;
	GtkLabel* _tmp29_;
	GtkLabel* _tmp30_;
	GtkStyleContext* _tmp31_;
	GtkLabel* _tmp32_;
	GtkLabel* _tmp33_;
	GtkLabel* _tmp34_;
	GtkLabel* _tmp35_;
	GtkLabel* _tmp36_;
	GtkSeparator* _tmp37_;
	GtkSeparator* _tmp38_;
	GtkButton* _tmp39_;
	GtkSeparator* _tmp40_;
	GtkButton* _tmp41_;
	GtkStyleContext* _tmp42_;
	GtkStyleContext* _tmp43_;
	GtkFrame* result;
#line 95 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 96 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = (GtkFrame*) gtk_frame_new (NULL);
#line 96 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_object_ref_sink (_tmp0_);
#line 96 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	frame = _tmp0_;
#line 97 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
#line 97 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_object_ref_sink (_tmp1_);
#line 97 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	box = _tmp1_;
#line 99 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = (GtkButton*) gtk_button_new_from_icon_name ("document-new-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
#line 99 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_object_ref_sink (_tmp2_);
#line 99 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (self->priv->plus_button);
#line 99 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	self->priv->plus_button = _tmp2_;
#line 101 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp3_ = self->priv->plus_button;
#line 101 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp4_ = enotes_app;
#line 101 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp6_ = _tmp5_ = gtk_application_get_accels_for_action ((GtkApplication*) _tmp4_, "win.new-action");
#line 101 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp7_ = _tmp6_;
#line 101 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp7__length1 = _vala_array_length (_tmp5_);
#line 101 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp8_ = granite_markup_accel_tooltip (_tmp7_, (gint) _vala_array_length (_tmp5_), _ ("New Page"));
#line 101 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp9_ = _tmp8_;
#line 101 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp3_, _tmp9_);
#line 101 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_free0 (_tmp9_);
#line 101 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
#line 102 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp10_ = self->priv->plus_button;
#line 102 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
#line 102 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_style_context_add_class (_tmp11_, "flat");
#line 103 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp12_ = self->priv->plus_button;
#line 103 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_can_focus ((GtkWidget*) _tmp12_, FALSE);
#line 105 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp13_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-delete-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
#line 105 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_object_ref_sink (_tmp13_);
#line 105 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (self->priv->minus_button);
#line 105 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	self->priv->minus_button = _tmp13_;
#line 106 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp14_ = self->priv->minus_button;
#line 106 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp14_, _ ("Delete Page"));
#line 107 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp15_ = self->priv->minus_button;
#line 107 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) _tmp15_);
#line 107 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_style_context_add_class (_tmp16_, "flat");
#line 108 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp17_ = self->priv->minus_button;
#line 108 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp17_, GTK_ALIGN_END);
#line 109 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp18_ = self->priv->minus_button;
#line 109 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp18_, TRUE);
#line 110 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp19_ = self->priv->minus_button;
#line 110 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_can_focus ((GtkWidget*) _tmp19_, FALSE);
#line 111 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp20_ = self->priv->minus_button;
#line 111 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp20_, FALSE);
#line 113 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp21_ = (GtkLabel*) gtk_label_new ("");
#line 113 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_object_ref_sink (_tmp21_);
#line 113 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (self->priv->notebook_name);
#line 113 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	self->priv->notebook_name = _tmp21_;
#line 114 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp22_ = (GtkLabel*) gtk_label_new ("");
#line 114 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_object_ref_sink (_tmp22_);
#line 114 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (self->priv->page_total);
#line 114 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	self->priv->page_total = _tmp22_;
#line 115 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp23_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_VERTICAL);
#line 115 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_object_ref_sink (_tmp23_);
#line 115 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (self->priv->separator);
#line 115 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	self->priv->separator = _tmp23_;
#line 117 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp24_ = self->priv->notebook_name;
#line 117 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp24_, GTK_ALIGN_START);
#line 118 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp25_ = self->priv->page_total;
#line 118 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp25_, GTK_ALIGN_END);
#line 120 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp26_ = self->priv->separator;
#line 120 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp26_, FALSE);
#line 121 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp27_ = self->priv->notebook_name;
#line 121 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp27_, TRUE);
#line 122 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp28_ = self->priv->separator;
#line 122 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp28_, TRUE);
#line 124 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp29_ = self->priv->notebook_name;
#line 124 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_label_set_ellipsize (_tmp29_, PANGO_ELLIPSIZE_END);
#line 125 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp30_ = self->priv->notebook_name;
#line 125 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp31_ = gtk_widget_get_style_context ((GtkWidget*) _tmp30_);
#line 125 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_style_context_add_class (_tmp31_, "h4");
#line 126 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp32_ = self->priv->notebook_name;
#line 126 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_margin_start ((GtkWidget*) _tmp32_, 6);
#line 127 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp33_ = self->priv->notebook_name;
#line 127 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_margin_end ((GtkWidget*) _tmp33_, 6);
#line 128 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp34_ = self->priv->page_total;
#line 128 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_margin_end ((GtkWidget*) _tmp34_, 6);
#line 130 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp35_ = self->priv->notebook_name;
#line 130 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp35_);
#line 131 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp36_ = self->priv->page_total;
#line 131 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp36_);
#line 132 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp37_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_VERTICAL);
#line 132 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_object_ref_sink (_tmp37_);
#line 132 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp38_ = _tmp37_;
#line 132 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp38_);
#line 132 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (_tmp38_);
#line 133 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp39_ = self->priv->minus_button;
#line 133 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp39_);
#line 134 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp40_ = self->priv->separator;
#line 134 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp40_);
#line 135 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp41_ = self->priv->plus_button;
#line 135 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp41_);
#line 137 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_sensitive ((GtkWidget*) frame, FALSE);
#line 138 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp42_ = gtk_widget_get_style_context ((GtkWidget*) frame);
#line 138 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_style_context_add_class (_tmp42_, "toolbar");
#line 139 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp43_ = gtk_widget_get_style_context ((GtkWidget*) frame);
#line 139 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_style_context_add_class (_tmp43_, "inline-toolbar");
#line 141 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) box);
#line 142 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_show_all ((GtkWidget*) frame);
#line 144 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	result = frame;
#line 144 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (box);
#line 144 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	return result;
#line 1072 "PagesList.c"
}

void
enotes_pages_list_clear_pages (ENotesPagesList* self)
{
	GtkListBox* _tmp0_;
	GeeHashMap* _tmp1_;
	GList* childerns = NULL;
	GtkListBox* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
#line 147 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_if_fail (self != NULL);
#line 148 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = self->listbox;
#line 148 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_list_box_unselect_all (_tmp0_);
#line 149 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp1_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, ENOTES_TYPE_PAGE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 149 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (self->priv->added_pages);
#line 149 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	self->priv->added_pages = _tmp1_;
#line 150 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = self->listbox;
#line 150 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp3_ = gtk_container_get_children ((GtkContainer*) _tmp2_);
#line 150 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	childerns = _tmp3_;
#line 152 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp4_ = childerns;
#line 1104 "PagesList.c"
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
#line 152 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		child_collection = _tmp4_;
#line 152 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
#line 1112 "PagesList.c"
			GtkWidget* _tmp5_;
			GtkWidget* child = NULL;
#line 152 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			_tmp5_ = _g_object_ref0 ((GtkWidget*) child_it->data);
#line 152 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			child = _tmp5_;
#line 1119 "PagesList.c"
			{
				GtkWidget* _tmp6_;
#line 153 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
				_tmp6_ = child;
#line 153 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_list_box_row_get_type ())) {
#line 1126 "PagesList.c"
					GtkListBox* _tmp7_;
					GtkWidget* _tmp8_;
#line 154 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
					_tmp7_ = self->listbox;
#line 154 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
					_tmp8_ = child;
#line 154 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
					gtk_container_remove ((GtkContainer*) _tmp7_, _tmp8_);
#line 1135 "PagesList.c"
				}
#line 152 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
				_g_object_unref0 (child);
#line 1139 "PagesList.c"
			}
		}
	}
#line 147 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	(childerns == NULL) ? NULL : (childerns = (g_list_free (childerns), NULL));
#line 1145 "PagesList.c"
}

void
enotes_pages_list_refresh (ENotesPagesList* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	ENotesNotebook* _tmp2_;
	ENotesNotebook* _tmp3_;
#line 159 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_if_fail (self != NULL);
#line 160 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = enotes_app;
#line 160 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp1_ = _tmp0_->state;
#line 160 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = enotes_application_state_get_opened_notebook (_tmp1_);
#line 160 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp3_ = _tmp2_;
#line 160 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	if (_tmp3_ != NULL) {
#line 1167 "PagesList.c"
		ENotesApplication* _tmp4_;
		ENotesApplicationState* _tmp5_;
		ENotesNotebook* _tmp6_;
		ENotesNotebook* _tmp7_;
#line 161 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp4_ = enotes_app;
#line 161 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp5_ = _tmp4_->state;
#line 161 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp6_ = enotes_application_state_get_opened_notebook (_tmp5_);
#line 161 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp7_ = _tmp6_;
#line 161 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		enotes_pages_list_load_pages (self, _tmp7_);
#line 1182 "PagesList.c"
	} else {
#line 163 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		enotes_pages_list_load_all_pages (self);
#line 1186 "PagesList.c"
	}
}

static gboolean
enotes_pages_list_select_page (ENotesPagesList* self,
                               ENotesPage* page)
{
	GList* childerns = NULL;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GtkButton* _tmp13_;
	gboolean result;
#line 167 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 168 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	if (page == NULL) {
#line 168 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		result = FALSE;
#line 168 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		return result;
#line 1208 "PagesList.c"
	}
#line 169 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	self->priv->selecting = TRUE;
#line 171 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = self->listbox;
#line 171 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
#line 171 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	childerns = _tmp1_;
#line 173 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = childerns;
#line 1220 "PagesList.c"
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
#line 173 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		child_collection = _tmp2_;
#line 173 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
#line 1228 "PagesList.c"
			GtkWidget* _tmp3_;
			GtkWidget* child = NULL;
#line 173 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			_tmp3_ = _g_object_ref0 ((GtkWidget*) child_it->data);
#line 173 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			child = _tmp3_;
#line 1235 "PagesList.c"
			{
				GtkWidget* _tmp4_;
#line 174 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
				_tmp4_ = child;
#line 174 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
				if (ENOTES_IS_PAGE_ITEM (_tmp4_)) {
#line 1242 "PagesList.c"
					ENotesPageItem* item = NULL;
					GtkWidget* _tmp5_;
					ENotesPageItem* _tmp6_;
					ENotesPageItem* _tmp7_;
					ENotesPage* _tmp8_;
					ENotesPage* _tmp9_;
#line 175 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
					_tmp5_ = child;
#line 175 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
					_tmp6_ = _g_object_ref0 (ENOTES_IS_PAGE_ITEM (_tmp5_) ? ((ENotesPageItem*) _tmp5_) : NULL);
#line 175 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
					item = _tmp6_;
#line 177 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
					_tmp7_ = item;
#line 177 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
					_tmp8_ = enotes_page_item_get_page (_tmp7_);
#line 177 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
					_tmp9_ = _tmp8_;
#line 177 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
					if (enotes_page_equals (page, _tmp9_)) {
#line 1263 "PagesList.c"
						GtkListBox* _tmp10_;
						ENotesPageItem* _tmp11_;
						GtkButton* _tmp12_;
#line 178 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
						_tmp10_ = self->listbox;
#line 178 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
						_tmp11_ = item;
#line 178 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
						gtk_list_box_select_row (_tmp10_, (GtkListBoxRow*) _tmp11_);
#line 179 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
						_tmp12_ = self->priv->minus_button;
#line 179 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
						gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, TRUE);
#line 180 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
						self->priv->selecting = FALSE;
#line 181 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
						result = TRUE;
#line 181 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
						_g_object_unref0 (item);
#line 181 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
						_g_object_unref0 (child);
#line 181 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
						(childerns == NULL) ? NULL : (childerns = (g_list_free (childerns), NULL));
#line 181 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
						return result;
#line 1289 "PagesList.c"
					}
#line 174 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
					_g_object_unref0 (item);
#line 1293 "PagesList.c"
				}
#line 173 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
				_g_object_unref0 (child);
#line 1297 "PagesList.c"
			}
		}
	}
#line 186 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp13_ = self->priv->minus_button;
#line 186 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, FALSE);
#line 187 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	self->priv->selecting = FALSE;
#line 188 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	result = FALSE;
#line 188 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	(childerns == NULL) ? NULL : (childerns = (g_list_free (childerns), NULL));
#line 188 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	return result;
#line 1313 "PagesList.c"
}

static void
enotes_pages_list_load_pages (ENotesPagesList* self,
                              ENotesNotebook* notebook)
{
	GeeArrayList* pages = NULL;
	ENotesPageTable* _tmp0_;
	ENotesPageTable* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GtkLabel* _tmp5_;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
#line 191 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_if_fail (self != NULL);
#line 192 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	if (notebook == NULL) {
#line 192 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		return;
#line 1341 "PagesList.c"
	}
#line 194 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = enotes_page_table_get_instance ();
#line 194 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp1_ = _tmp0_;
#line 194 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = enotes_page_table_get_pages (_tmp1_, notebook->id);
#line 194 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp3_ = _tmp2_;
#line 194 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_database_table_unref0 (_tmp1_);
#line 194 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	pages = _tmp3_;
#line 196 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp4_ = pages;
#line 196 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	enotes_pages_list_load_page_list (self, _tmp4_);
#line 198 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp5_ = self->priv->notebook_name;
#line 198 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp6_ = notebook->name;
#line 198 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "§", 0);
#line 198 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp9_ = _tmp8_;
#line 198 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp9__length1 = _vala_array_length (_tmp7_);
#line 198 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp10_ = _tmp9_[0];
#line 198 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp11_ = g_strconcat (_tmp10_, ":", NULL);
#line 198 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp12_ = _tmp11_;
#line 198 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_label_set_label (_tmp5_, _tmp12_);
#line 198 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_free0 (_tmp12_);
#line 198 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
#line 191 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (pages);
#line 1383 "PagesList.c"
}

static void
enotes_pages_list_load_pages_for_tag (ENotesPagesList* self,
                                      ENotesTag* tag)
{
	GeeArrayList* pages = NULL;
	ENotesTagsTable* _tmp0_;
	ENotesTagsTable* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GtkLabel* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
#line 201 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_if_fail (self != NULL);
#line 201 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_if_fail (tag != NULL);
#line 202 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = enotes_tags_table_get_instance ();
#line 202 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp1_ = _tmp0_;
#line 202 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = enotes_tags_table_get_pages_for_tag (_tmp1_, tag);
#line 202 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp3_ = _tmp2_;
#line 202 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_database_table_unref0 (_tmp1_);
#line 202 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	pages = _tmp3_;
#line 204 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	enotes_pages_list_load_page_list (self, pages);
#line 205 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp4_ = self->priv->notebook_name;
#line 205 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp5_ = tag->name;
#line 205 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp6_ = g_strdup_printf ("%s:", _tmp5_);
#line 205 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp7_ = _tmp6_;
#line 205 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_label_set_label (_tmp4_, _tmp7_);
#line 205 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_free0 (_tmp7_);
#line 201 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (pages);
#line 1431 "PagesList.c"
}

void
enotes_pages_list_load_all_pages (ENotesPagesList* self)
{
	GeeArrayList* pages = NULL;
	ENotesPageTable* _tmp0_;
	ENotesPageTable* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GtkLabel* _tmp4_;
#line 208 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_if_fail (self != NULL);
#line 209 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	self->priv->loading_pages = TRUE;
#line 210 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = enotes_page_table_get_instance ();
#line 210 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp1_ = _tmp0_;
#line 210 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = enotes_page_table_get_all_pages (_tmp1_);
#line 210 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp3_ = _tmp2_;
#line 210 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_database_table_unref0 (_tmp1_);
#line 210 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	pages = _tmp3_;
#line 211 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	enotes_pages_list_load_page_list (self, pages);
#line 213 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp4_ = self->priv->notebook_name;
#line 213 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_label_set_label (_tmp4_, "Notes:");
#line 208 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (pages);
#line 1467 "PagesList.c"
}

static void
enotes_pages_list_load_page_list (ENotesPagesList* self,
                                  GeeArrayList* pages)
{
	GtkFrame* _tmp10_;
	GtkButton* _tmp11_;
	gchar* page_label = NULL;
	GeeHashMap* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_;
	GtkLabel* _tmp16_;
	GeeHashMap* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GtkListBox* _tmp22_;
	ENotesApplication* _tmp23_;
	ENotesApplicationState* _tmp24_;
	ENotesPage* _tmp25_;
	ENotesPage* _tmp26_;
#line 216 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_if_fail (self != NULL);
#line 216 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_if_fail (pages != NULL);
#line 217 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	self->priv->loading_pages = TRUE;
#line 218 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	enotes_pages_list_clear_pages (self);
#line 1500 "PagesList.c"
	{
		GeeArrayList* _page_list = NULL;
		gint _page_size = 0;
		GeeArrayList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _page_index = 0;
#line 220 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_page_list = pages;
#line 220 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp0_ = _page_list;
#line 220 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
#line 220 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp2_ = _tmp1_;
#line 220 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_page_size = _tmp2_;
#line 220 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_page_index = -1;
#line 220 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		while (TRUE) {
#line 1522 "PagesList.c"
			gint _tmp3_;
			gint _tmp4_;
			ENotesPage* page = NULL;
			GeeArrayList* _tmp5_;
			gpointer _tmp6_;
			ENotesPage* _tmp7_;
			ENotesPageItem* _tmp8_;
			ENotesPageItem* _tmp9_;
#line 220 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			_page_index = _page_index + 1;
#line 220 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			_tmp3_ = _page_index;
#line 220 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			_tmp4_ = _page_size;
#line 220 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			if (!(_tmp3_ < _tmp4_)) {
#line 220 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
				break;
#line 1541 "PagesList.c"
			}
#line 220 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			_tmp5_ = _page_list;
#line 220 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _page_index);
#line 220 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			page = (ENotesPage*) _tmp6_;
#line 221 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			_tmp7_ = page;
#line 221 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			_tmp8_ = enotes_pages_list_new_page (self, _tmp7_);
#line 221 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			_tmp9_ = _tmp8_;
#line 221 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			_g_object_unref0 (_tmp9_);
#line 220 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			_g_object_unref0 (page);
#line 1559 "PagesList.c"
		}
	}
#line 224 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp10_ = self->priv->toolbar;
#line 224 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, TRUE);
#line 225 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp11_ = self->priv->minus_button;
#line 225 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, FALSE);
#line 227 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp12_ = self->priv->added_pages;
#line 227 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp13_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp12_);
#line 227 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp14_ = _tmp13_;
#line 227 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp15_ = g_strdup (g_dngettext ("notes-up", "%i Page", "%i Pages", (gulong) _tmp14_));
#line 227 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	page_label = _tmp15_;
#line 228 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp16_ = self->priv->page_total;
#line 228 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp17_ = self->priv->added_pages;
#line 228 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp18_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp17_);
#line 228 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp19_ = _tmp18_;
#line 228 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp20_ = g_strdup_printf (page_label, _tmp19_);
#line 228 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp21_ = _tmp20_;
#line 228 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_label_set_label (_tmp16_, _tmp21_);
#line 228 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_free0 (_tmp21_);
#line 230 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp22_ = self->listbox;
#line 230 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp22_);
#line 231 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp23_ = enotes_app;
#line 231 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp24_ = _tmp23_->state;
#line 231 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp25_ = enotes_application_state_get_opened_page (_tmp24_);
#line 231 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp26_ = _tmp25_;
#line 231 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	enotes_pages_list_select_page (self, _tmp26_);
#line 232 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	self->priv->loading_pages = FALSE;
#line 216 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_free0 (page_label);
#line 1614 "PagesList.c"
}

static ENotesPageItem*
enotes_pages_list_new_page (ENotesPagesList* self,
                            ENotesPage* page)
{
	ENotesPageItem* page_box = NULL;
	ENotesPageItem* _tmp0_;
	GtkListBox* _tmp1_;
	GeeHashMap* _tmp2_;
	ENotesPageItem* result;
#line 235 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 235 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_val_if_fail (page != NULL, NULL);
#line 236 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = enotes_page_item_new (page);
#line 236 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_object_ref_sink (_tmp0_);
#line 236 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	page_box = _tmp0_;
#line 237 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp1_ = self->listbox;
#line 237 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_container_add ((GtkContainer*) _tmp1_, (GtkWidget*) page_box);
#line 239 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = self->priv->added_pages;
#line 239 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, (gpointer) ((gintptr) page->id), page_box);
#line 241 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	result = page_box;
#line 241 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	return result;
#line 1648 "PagesList.c"
}

void
enotes_pages_list_new_blank_page (ENotesPagesList* self)
{
	ENotesViewEditStack* _tmp0_;
	ENotesViewEditStack* _tmp1_;
	ENotesEditor* _tmp2_;
	ENotesEditor* _tmp3_;
	ENotesNotebook* current_notebook = NULL;
	ENotesApplication* _tmp4_;
	ENotesApplicationState* _tmp5_;
	ENotesNotebook* _tmp6_;
	ENotesNotebook* _tmp7_;
	ENotesNotebook* _tmp8_;
	gint64 _tmp9_ = 0LL;
	ENotesNotebook* _tmp10_;
	gint64 current_id = 0LL;
	ENotesPage* page = NULL;
	ENotesPageTable* _tmp12_;
	ENotesPageTable* _tmp13_;
	ENotesPage* _tmp14_;
	ENotesPage* _tmp15_;
	ENotesPageItem* page_item = NULL;
	ENotesPageItem* _tmp16_;
	GeeHashMap* _tmp17_;
	GtkListBox* _tmp18_;
	GtkListBox* _tmp19_;
	GtkListBox* _tmp20_;
	GtkListBox* _tmp21_;
#line 244 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_if_fail (self != NULL);
#line 245 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = enotes_view_edit_stack_get_instance ();
#line 245 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp1_ = _tmp0_;
#line 245 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = enotes_view_edit_stack_get_editor (_tmp1_);
#line 245 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp3_ = _tmp2_;
#line 245 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	enotes_editor_save_file (_tmp3_);
#line 245 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (_tmp1_);
#line 247 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp4_ = enotes_app;
#line 247 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp5_ = _tmp4_->state;
#line 247 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp6_ = enotes_application_state_get_opened_notebook (_tmp5_);
#line 247 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp7_ = _tmp6_;
#line 247 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 247 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	current_notebook = _tmp8_;
#line 248 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp10_ = current_notebook;
#line 248 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	if (_tmp10_ != NULL) {
#line 1709 "PagesList.c"
		ENotesNotebook* _tmp11_;
#line 248 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp11_ = current_notebook;
#line 248 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp9_ = _tmp11_->id;
#line 1715 "PagesList.c"
	} else {
#line 248 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp9_ = (gint64) -1;
#line 1719 "PagesList.c"
	}
#line 248 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	current_id = _tmp9_;
#line 250 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp12_ = enotes_page_table_get_instance ();
#line 250 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp13_ = _tmp12_;
#line 250 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp14_ = enotes_page_table_new_page (_tmp13_, current_id);
#line 250 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp15_ = _tmp14_;
#line 250 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_database_table_unref0 (_tmp13_);
#line 250 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	page = _tmp15_;
#line 251 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp16_ = enotes_page_item_new (page);
#line 251 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_object_ref_sink (_tmp16_);
#line 251 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	page_item = _tmp16_;
#line 253 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp17_ = self->priv->added_pages;
#line 253 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, (gpointer) ((gintptr) page->id), page_item);
#line 255 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp18_ = self->listbox;
#line 255 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_list_box_prepend (_tmp18_, (GtkWidget*) page_item);
#line 256 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp19_ = self->listbox;
#line 256 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp19_);
#line 257 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp20_ = self->listbox;
#line 257 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_list_box_unselect_all (_tmp20_);
#line 258 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp21_ = self->listbox;
#line 258 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_list_box_select_row (_tmp21_, (GtkListBoxRow*) page_item);
#line 244 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (page_item);
#line 244 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (page);
#line 244 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (current_notebook);
#line 1767 "PagesList.c"
}

void
enotes_pages_list_grab_focus (ENotesPagesList* self)
{
	GtkListBox* _tmp0_;
#line 261 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_if_fail (self != NULL);
#line 262 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = self->listbox;
#line 262 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
#line 1780 "PagesList.c"
}

static gboolean
_enotes_mode_equal (const ENotesMode * s1,
                    const ENotesMode * s2)
{
#line 266 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	if (s1 == s2) {
#line 266 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		return TRUE;
#line 1791 "PagesList.c"
	}
#line 266 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	if (s1 == NULL) {
#line 266 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		return FALSE;
#line 1797 "PagesList.c"
	}
#line 266 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	if (s2 == NULL) {
#line 266 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		return FALSE;
#line 1803 "PagesList.c"
	}
#line 266 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	return (*s1) == (*s2);
#line 1807 "PagesList.c"
}

static void
enotes_pages_list_toolbar_mode (ENotesPagesList* self,
                                ENotesMode* mode)
{
	GtkSeparator* _tmp0_;
	ENotesMode _tmp1_;
	GtkButton* _tmp2_;
	ENotesMode _tmp3_;
	GtkLabel* _tmp4_;
	ENotesMode _tmp5_;
#line 265 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_if_fail (self != NULL);
#line 266 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = self->priv->separator;
#line 266 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp1_ = ENOTES_MODE_EDIT;
#line 266 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, _enotes_mode_equal (mode, &_tmp1_) == TRUE);
#line 267 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = self->priv->minus_button;
#line 267 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp3_ = ENOTES_MODE_EDIT;
#line 267 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, _enotes_mode_equal (mode, &_tmp3_) == TRUE);
#line 268 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp4_ = self->priv->page_total;
#line 268 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp5_ = ENOTES_MODE_EDIT;
#line 268 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, !(_enotes_mode_equal (mode, &_tmp5_) == TRUE));
#line 1840 "PagesList.c"
}

static void
__lambda21_ (ENotesPagesList* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	ENotesMode _tmp2_;
	ENotesMode _tmp3_;
#line 273 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = enotes_app;
#line 273 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp1_ = _tmp0_->state;
#line 273 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = enotes_application_state_get_mode (_tmp1_);
#line 273 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp3_ = _tmp2_;
#line 273 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	enotes_pages_list_toolbar_mode (self, &_tmp3_);
#line 1860 "PagesList.c"
}

static void
___lambda21__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 272 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	__lambda21_ ((ENotesPagesList*) self);
#line 1870 "PagesList.c"
}

static void
__lambda22_ (ENotesPagesList* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GtkListBox* _tmp5_;
#line 277 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = enotes_app;
#line 277 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp1_ = _tmp0_->state;
#line 277 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = enotes_application_state_get_search_field (_tmp1_);
#line 277 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp3_ = _tmp2_;
#line 277 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) -1);
#line 277 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_free0 (self->priv->search_for);
#line 277 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	self->priv->search_for = _tmp4_;
#line 278 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp5_ = self->listbox;
#line 278 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_list_box_invalidate_filter (_tmp5_);
#line 1900 "PagesList.c"
}

static void
___lambda22__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 276 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	__lambda22_ ((ENotesPagesList*) self);
#line 1910 "PagesList.c"
}

static void
__lambda23_ (ENotesPagesList* self)
{
	ENotesNotebook* notebook = NULL;
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	ENotesNotebook* _tmp2_;
	ENotesNotebook* _tmp3_;
	ENotesNotebook* _tmp4_;
	ENotesNotebook* _tmp5_;
#line 282 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = enotes_app;
#line 282 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp1_ = _tmp0_->state;
#line 282 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = enotes_application_state_get_opened_notebook (_tmp1_);
#line 282 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp3_ = _tmp2_;
#line 282 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 282 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	notebook = _tmp4_;
#line 283 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp5_ = notebook;
#line 283 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	if (_tmp5_ != NULL) {
#line 1939 "PagesList.c"
		ENotesNotebook* _tmp6_;
#line 284 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp6_ = notebook;
#line 284 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		enotes_pages_list_load_pages (self, _tmp6_);
#line 1945 "PagesList.c"
	}
#line 281 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (notebook);
#line 1949 "PagesList.c"
}

static void
___lambda23__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 281 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	__lambda23_ ((ENotesPagesList*) self);
#line 1959 "PagesList.c"
}

static void
__lambda24_ (ENotesPagesList* self,
             ENotesTag* tag)
{
#line 288 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_if_fail (tag != NULL);
#line 289 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	enotes_pages_list_load_pages_for_tag (self, tag);
#line 1970 "PagesList.c"
}

static void
___lambda24__enotes_application_state_show_pages_in_tag (ENotesApplicationState* _sender,
                                                         ENotesTag* tag,
                                                         gpointer self)
{
#line 288 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	__lambda24_ ((ENotesPagesList*) self, tag);
#line 1980 "PagesList.c"
}

static void
__lambda25_ (ENotesPagesList* self)
{
#line 293 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	enotes_pages_list_load_all_pages (self);
#line 1988 "PagesList.c"
}

static void
___lambda25__enotes_application_state_show_all_pages (ENotesApplicationState* _sender,
                                                      gpointer self)
{
#line 292 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	__lambda25_ ((ENotesPagesList*) self);
#line 1997 "PagesList.c"
}

static void
__lambda26_ (ENotesPagesList* self)
{
#line 297 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	enotes_pages_list_refresh (self);
#line 2005 "PagesList.c"
}

static void
___lambda26__enotes_application_state_notebook_contents_changed (ENotesApplicationState* _sender,
                                                                 gpointer self)
{
#line 296 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	__lambda26_ ((ENotesPagesList*) self);
#line 2014 "PagesList.c"
}

static void
__lambda27_ (ENotesPagesList* self)
{
#line 301 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	enotes_pages_list_load_all_pages (self);
#line 2022 "PagesList.c"
}

static void
___lambda27__enotes_application_state_load_all_pages (ENotesApplicationState* _sender,
                                                      gpointer self)
{
#line 300 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	__lambda27_ ((ENotesPagesList*) self);
#line 2031 "PagesList.c"
}

static void
__lambda28_ (ENotesPagesList* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	ENotesPage* _tmp2_;
	ENotesPage* _tmp3_;
#line 305 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = enotes_app;
#line 305 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp1_ = _tmp0_->state;
#line 305 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = enotes_application_state_get_opened_page (_tmp1_);
#line 305 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp3_ = _tmp2_;
#line 305 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	enotes_pages_list_select_page (self, _tmp3_);
#line 2051 "PagesList.c"
}

static void
___lambda28__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 304 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	__lambda28_ ((ENotesPagesList*) self);
#line 2061 "PagesList.c"
}

static void
__lambda29_ (ENotesPagesList* self)
{
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBox* _tmp3_;
	GtkListBoxRow* _tmp4_;
#line 309 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = self->listbox;
#line 309 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp1_ = self->listbox;
#line 309 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = gtk_list_box_get_row_at_y (_tmp1_, 0);
#line 309 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_list_box_select_row (_tmp0_, _tmp2_);
#line 310 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp3_ = self->listbox;
#line 310 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp4_ = gtk_list_box_get_row_at_y (_tmp3_, 0);
#line 310 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp4_);
#line 2086 "PagesList.c"
}

static void
___lambda29__enotes_application_state_search_selected (ENotesApplicationState* _sender,
                                                       gpointer self)
{
#line 308 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	__lambda29_ ((ENotesPagesList*) self);
#line 2095 "PagesList.c"
}

static void
__lambda30_ (ENotesPagesList* self)
{
#line 314 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	enotes_pages_list_new_blank_page (self);
#line 2103 "PagesList.c"
}

static void
___lambda30__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 313 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	__lambda30_ ((ENotesPagesList*) self);
#line 2112 "PagesList.c"
}

static void
__lambda31_ (ENotesPagesList* self)
{
	ENotesViewEditStack* _tmp0_;
	ENotesViewEditStack* _tmp1_;
	ENotesEditor* _tmp2_;
	ENotesEditor* _tmp3_;
	GList* rows = NULL;
	GtkListBox* _tmp4_;
	GList* _tmp5_;
	GList* _tmp6_;
#line 318 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = enotes_view_edit_stack_get_instance ();
#line 318 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp1_ = _tmp0_;
#line 318 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = enotes_view_edit_stack_get_editor (_tmp1_);
#line 318 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp3_ = _tmp2_;
#line 318 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
#line 318 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (_tmp1_);
#line 320 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp4_ = self->listbox;
#line 320 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp5_ = gtk_list_box_get_selected_rows (_tmp4_);
#line 320 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	rows = _tmp5_;
#line 322 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp6_ = rows;
#line 2146 "PagesList.c"
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
#line 322 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		row_collection = _tmp6_;
#line 322 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
#line 2154 "PagesList.c"
			GtkListBoxRow* row = NULL;
#line 322 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
			row = (GtkListBoxRow*) row_it->data;
#line 2158 "PagesList.c"
			{
				ENotesTrash* _tmp7_;
				ENotesTrash* _tmp8_;
				GtkListBoxRow* _tmp9_;
				ENotesPage* _tmp10_;
				ENotesPage* _tmp11_;
#line 323 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
				_tmp7_ = enotes_trash_get_instance ();
#line 323 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
				_tmp8_ = _tmp7_;
#line 323 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
				_tmp9_ = row;
#line 323 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
				_tmp10_ = enotes_page_item_get_page (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, ENOTES_TYPE_PAGE_ITEM, ENotesPageItem));
#line 323 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
				_tmp11_ = _tmp10_;
#line 323 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
				enotes_trash_trash_page (_tmp8_, _tmp11_);
#line 323 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
				_g_object_unref0 (_tmp8_);
#line 2179 "PagesList.c"
			}
		}
	}
#line 326 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	enotes_pages_list_refresh (self);
#line 317 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	(rows == NULL) ? NULL : (rows = (g_list_free (rows), NULL));
#line 2187 "PagesList.c"
}

static void
___lambda31__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 317 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	__lambda31_ ((ENotesPagesList*) self);
#line 2196 "PagesList.c"
}

static void
__lambda32_ (ENotesPagesList* self,
             GtkListBoxRow* row)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ENotesApplication* _tmp2_;
	ENotesApplicationState* _tmp3_;
	ENotesPage* _tmp4_;
	ENotesPage* _tmp5_;
#line 330 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	if (row == NULL) {
#line 330 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp1_ = TRUE;
#line 2213 "PagesList.c"
	} else {
#line 330 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp1_ = self->priv->loading_pages;
#line 2217 "PagesList.c"
	}
#line 330 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	if (_tmp1_) {
#line 330 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp0_ = TRUE;
#line 2223 "PagesList.c"
	} else {
#line 330 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp0_ = self->priv->selecting;
#line 2227 "PagesList.c"
	}
#line 330 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	if (_tmp0_) {
#line 330 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		return;
#line 2233 "PagesList.c"
	}
#line 331 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = enotes_app;
#line 331 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp3_ = _tmp2_->state;
#line 331 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp4_ = enotes_page_item_get_page (G_TYPE_CHECK_INSTANCE_CAST (row, ENOTES_TYPE_PAGE_ITEM, ENotesPageItem));
#line 331 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp5_ = _tmp4_;
#line 331 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	enotes_application_state_open_page (_tmp3_, _tmp5_->id);
#line 2245 "PagesList.c"
}

static void
___lambda32__gtk_list_box_row_selected (GtkListBox* _sender,
                                        GtkListBoxRow* row,
                                        gpointer self)
{
#line 329 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	__lambda32_ ((ENotesPagesList*) self, row);
#line 2255 "PagesList.c"
}

static void
__lambda33_ (ENotesPagesList* self,
             GtkListBoxRow* row)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	ENotesApplication* _tmp2_;
	ENotesApplicationState* _tmp3_;
	ENotesMode _tmp4_;
	ENotesMode _tmp5_;
#line 334 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_if_fail (row != NULL);
#line 335 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = enotes_app;
#line 335 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp1_ = _tmp0_->state;
#line 335 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	enotes_application_state_toggle_app_mode (_tmp1_);
#line 337 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = enotes_app;
#line 337 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp3_ = _tmp2_->state;
#line 337 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp4_ = enotes_application_state_get_mode (_tmp3_);
#line 337 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp5_ = _tmp4_;
#line 337 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	if (_tmp5_ == ENOTES_MODE_EDIT) {
#line 2286 "PagesList.c"
		ENotesViewEditStack* _tmp6_;
		ENotesViewEditStack* _tmp7_;
		ENotesEditor* _tmp8_;
		ENotesEditor* _tmp9_;
#line 338 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp6_ = enotes_view_edit_stack_get_instance ();
#line 338 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp7_ = _tmp6_;
#line 338 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp8_ = enotes_view_edit_stack_get_editor (_tmp7_);
#line 338 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp9_ = _tmp8_;
#line 338 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		enotes_editor_give_focus (_tmp9_);
#line 338 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_g_object_unref0 (_tmp7_);
#line 2303 "PagesList.c"
	}
}

static void
___lambda33__gtk_list_box_row_activated (GtkListBox* _sender,
                                         GtkListBoxRow* row,
                                         gpointer self)
{
#line 334 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	__lambda33_ ((ENotesPagesList*) self, row);
#line 2314 "PagesList.c"
}

static void
__lambda34_ (ENotesPagesList* self,
             ENotesPage* page)
{
	GeeHashMap* _tmp0_;
#line 342 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_if_fail (page != NULL);
#line 343 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = self->priv->added_pages;
#line 343 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) page->id))) {
#line 2328 "PagesList.c"
		ENotesPageItem* page_item = NULL;
		GeeHashMap* _tmp1_;
		gpointer _tmp2_;
		ENotesPageItem* _tmp3_;
		ENotesPageItem* _tmp4_;
#line 344 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp1_ = self->priv->added_pages;
#line 344 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, (gpointer) ((gintptr) page->id));
#line 344 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		page_item = (ENotesPageItem*) _tmp2_;
#line 345 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp3_ = page_item;
#line 345 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		enotes_page_item_set_page (_tmp3_, page);
#line 346 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_tmp4_ = page_item;
#line 346 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		enotes_page_item_load_data (_tmp4_);
#line 343 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
		_g_object_unref0 (page_item);
#line 2350 "PagesList.c"
	}
}

static void
___lambda34__enotes_page_table_page_saved (ENotesPageTable* _sender,
                                           ENotesPage* page,
                                           gpointer self)
{
#line 342 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	__lambda34_ ((ENotesPagesList*) self, page);
#line 2361 "PagesList.c"
}

static void
enotes_pages_list_connect_signals (ENotesPagesList* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	ENotesApplication* _tmp2_;
	ENotesApplicationState* _tmp3_;
	ENotesApplication* _tmp4_;
	ENotesApplicationState* _tmp5_;
	ENotesApplication* _tmp6_;
	ENotesApplicationState* _tmp7_;
	ENotesApplication* _tmp8_;
	ENotesApplicationState* _tmp9_;
	ENotesApplication* _tmp10_;
	ENotesApplicationState* _tmp11_;
	ENotesApplication* _tmp12_;
	ENotesApplicationState* _tmp13_;
	ENotesApplication* _tmp14_;
	ENotesApplicationState* _tmp15_;
	ENotesApplication* _tmp16_;
	ENotesApplicationState* _tmp17_;
	GtkButton* _tmp18_;
	GtkButton* _tmp19_;
	GtkListBox* _tmp20_;
	GtkListBox* _tmp21_;
	ENotesPageTable* _tmp22_;
	ENotesPageTable* _tmp23_;
#line 271 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_if_fail (self != NULL);
#line 272 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = enotes_app;
#line 272 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp1_ = _tmp0_->state;
#line 272 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_signal_connect_object ((GObject*) _tmp1_, "notify::mode", (GCallback) ___lambda21__g_object_notify, self, 0);
#line 276 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp2_ = enotes_app;
#line 276 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp3_ = _tmp2_->state;
#line 276 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_signal_connect_object ((GObject*) _tmp3_, "notify::search-field", (GCallback) ___lambda22__g_object_notify, self, 0);
#line 281 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp4_ = enotes_app;
#line 281 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp5_ = _tmp4_->state;
#line 281 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_signal_connect_object ((GObject*) _tmp5_, "notify::opened-notebook", (GCallback) ___lambda23__g_object_notify, self, 0);
#line 288 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp6_ = enotes_app;
#line 288 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp7_ = _tmp6_->state;
#line 288 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_signal_connect_object (_tmp7_, "show-pages-in-tag", (GCallback) ___lambda24__enotes_application_state_show_pages_in_tag, self, 0);
#line 292 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp8_ = enotes_app;
#line 292 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp9_ = _tmp8_->state;
#line 292 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_signal_connect_object (_tmp9_, "show-all-pages", (GCallback) ___lambda25__enotes_application_state_show_all_pages, self, 0);
#line 296 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp10_ = enotes_app;
#line 296 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp11_ = _tmp10_->state;
#line 296 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_signal_connect_object (_tmp11_, "notebook-contents-changed", (GCallback) ___lambda26__enotes_application_state_notebook_contents_changed, self, 0);
#line 300 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp12_ = enotes_app;
#line 300 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp13_ = _tmp12_->state;
#line 300 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_signal_connect_object (_tmp13_, "load-all-pages", (GCallback) ___lambda27__enotes_application_state_load_all_pages, self, 0);
#line 304 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp14_ = enotes_app;
#line 304 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp15_ = _tmp14_->state;
#line 304 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_signal_connect_object ((GObject*) _tmp15_, "notify::opened-page", (GCallback) ___lambda28__g_object_notify, self, 0);
#line 308 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp16_ = enotes_app;
#line 308 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp17_ = _tmp16_->state;
#line 308 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_signal_connect_object (_tmp17_, "search-selected", (GCallback) ___lambda29__enotes_application_state_search_selected, self, 0);
#line 313 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp18_ = self->priv->plus_button;
#line 313 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_signal_connect_object (_tmp18_, "clicked", (GCallback) ___lambda30__gtk_button_clicked, self, 0);
#line 317 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp19_ = self->priv->minus_button;
#line 317 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_signal_connect_object (_tmp19_, "clicked", (GCallback) ___lambda31__gtk_button_clicked, self, 0);
#line 329 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp20_ = self->listbox;
#line 329 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_signal_connect_object (_tmp20_, "row-selected", (GCallback) ___lambda32__gtk_list_box_row_selected, self, 0);
#line 334 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp21_ = self->listbox;
#line 334 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_signal_connect_object (_tmp21_, "row-activated", (GCallback) ___lambda33__gtk_list_box_row_activated, self, 0);
#line 342 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp22_ = enotes_page_table_get_instance ();
#line 342 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp23_ = _tmp22_;
#line 342 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_signal_connect_object (_tmp23_, "page-saved", (GCallback) ___lambda34__enotes_page_table_page_saved, self, 0);
#line 342 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_database_table_unref0 (_tmp23_);
#line 2471 "PagesList.c"
}

static void
enotes_pages_list_translations (ENotesPagesList* self)
{
#line 352 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_return_if_fail (self != NULL);
#line 353 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	ngettext ("%i Page", "%i Pages", (gulong) 0);
#line 2481 "PagesList.c"
}

static void
enotes_pages_list_class_init (ENotesPagesListClass * klass,
                              gpointer klass_data)
{
#line 22 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	enotes_pages_list_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	g_type_class_adjust_private_offset (klass, &ENotesPagesList_private_offset);
#line 22 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	G_OBJECT_CLASS (klass)->finalize = enotes_pages_list_finalize;
#line 2494 "PagesList.c"
}

static void
enotes_pages_list_instance_init (ENotesPagesList * self,
                                 gpointer klass)
{
	gchar* _tmp0_;
#line 22 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	self->priv = enotes_pages_list_get_instance_private (self);
#line 34 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_tmp0_ = g_strdup ("");
#line 34 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	self->priv->search_for = _tmp0_;
#line 35 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	self->priv->loading_pages = FALSE;
#line 36 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	self->priv->selecting = FALSE;
#line 2512 "PagesList.c"
}

static void
enotes_pages_list_finalize (GObject * obj)
{
	ENotesPagesList * self;
#line 22 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_PAGES_LIST, ENotesPagesList);
#line 25 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (self->listbox);
#line 26 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (self->priv->toolbar);
#line 28 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (self->priv->separator);
#line 29 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (self->priv->minus_button);
#line 30 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (self->priv->plus_button);
#line 31 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (self->priv->notebook_name);
#line 32 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (self->priv->page_total);
#line 34 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_free0 (self->priv->search_for);
#line 38 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	_g_object_unref0 (self->priv->added_pages);
#line 22 "../Notes-up-2.0.6/src/Widgets/PagesList.vala"
	G_OBJECT_CLASS (enotes_pages_list_parent_class)->finalize (obj);
#line 2541 "PagesList.c"
}

static GType
enotes_pages_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesPagesListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_pages_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesPagesList), 0, (GInstanceInitFunc) enotes_pages_list_instance_init, NULL };
	GType enotes_pages_list_type_id;
	enotes_pages_list_type_id = g_type_register_static (gtk_box_get_type (), "ENotesPagesList", &g_define_type_info, 0);
	ENotesPagesList_private_offset = g_type_add_instance_private (enotes_pages_list_type_id, sizeof (ENotesPagesListPrivate));
	return enotes_pages_list_type_id;
}

GType
enotes_pages_list_get_type (void)
{
	static volatile gsize enotes_pages_list_type_id__once = 0;
	if (g_once_init_enter (&enotes_pages_list_type_id__once)) {
		GType enotes_pages_list_type_id;
		enotes_pages_list_type_id = enotes_pages_list_get_type_once ();
		g_once_init_leave (&enotes_pages_list_type_id__once, enotes_pages_list_type_id);
	}
	return enotes_pages_list_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

