/* PageInfoEditor.c generated by valac 0.56.12, the Vala compiler
 * generated from PageInfoEditor.vala, do not modify */

/*
* Copyright (c) 2019 Felipe Escoto (https://github.com/Philip-Scott/Notes-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <granite.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gee.h>

#define ENOTES_PAGE_INFO_EDITOR_NB_STYLE "* { color: %s}"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ENOTES_TYPE_PAGE_INFO_EDITOR (enotes_page_info_editor_get_type ())
#define ENOTES_PAGE_INFO_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGE_INFO_EDITOR, ENotesPageInfoEditor))
#define ENOTES_PAGE_INFO_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGE_INFO_EDITOR, ENotesPageInfoEditorClass))
#define ENOTES_IS_PAGE_INFO_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGE_INFO_EDITOR))
#define ENOTES_IS_PAGE_INFO_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGE_INFO_EDITOR))
#define ENOTES_PAGE_INFO_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGE_INFO_EDITOR, ENotesPageInfoEditorClass))

typedef struct _ENotesPageInfoEditor ENotesPageInfoEditor;
typedef struct _ENotesPageInfoEditorClass ENotesPageInfoEditorClass;
typedef struct _ENotesPageInfoEditorPrivate ENotesPageInfoEditorPrivate;

#define ENOTES_TYPE_BUTTON_ENTRY (enotes_button_entry_get_type ())
#define ENOTES_BUTTON_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_BUTTON_ENTRY, ENotesButtonEntry))
#define ENOTES_BUTTON_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_BUTTON_ENTRY, ENotesButtonEntryClass))
#define ENOTES_IS_BUTTON_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_BUTTON_ENTRY))
#define ENOTES_IS_BUTTON_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_BUTTON_ENTRY))
#define ENOTES_BUTTON_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_BUTTON_ENTRY, ENotesButtonEntryClass))

typedef struct _ENotesButtonEntry ENotesButtonEntry;
typedef struct _ENotesButtonEntryClass ENotesButtonEntryClass;

#define ENOTES_TYPE_PAGE (enotes_page_get_type ())
#define ENOTES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGE, ENotesPage))
#define ENOTES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGE, ENotesPageClass))
#define ENOTES_IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGE))
#define ENOTES_IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGE))
#define ENOTES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGE, ENotesPageClass))

typedef struct _ENotesPage ENotesPage;
typedef struct _ENotesPageClass ENotesPageClass;

#define ENOTES_TYPE_NOTEBOOK (enotes_notebook_get_type ())
#define ENOTES_NOTEBOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_NOTEBOOK, ENotesNotebook))
#define ENOTES_NOTEBOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_NOTEBOOK, ENotesNotebookClass))
#define ENOTES_IS_NOTEBOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_NOTEBOOK))
#define ENOTES_IS_NOTEBOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_NOTEBOOK))
#define ENOTES_NOTEBOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_NOTEBOOK, ENotesNotebookClass))

typedef struct _ENotesNotebook ENotesNotebook;
typedef struct _ENotesNotebookClass ENotesNotebookClass;
enum  {
	ENOTES_PAGE_INFO_EDITOR_0_PROPERTY,
	ENOTES_PAGE_INFO_EDITOR_NUM_PROPERTIES
};
static GParamSpec* enotes_page_info_editor_properties[ENOTES_PAGE_INFO_EDITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ENotesPagePrivate ENotesPagePrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ENotesNotebookPrivate ENotesNotebookPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define ENOTES_PAGE_INFO_EDITOR_TYPE_TAGS_BOX (enotes_page_info_editor_tags_box_get_type ())
#define ENOTES_PAGE_INFO_EDITOR_TAGS_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_PAGE_INFO_EDITOR_TYPE_TAGS_BOX, ENotesPageInfoEditorTagsBox))
#define ENOTES_PAGE_INFO_EDITOR_TAGS_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_PAGE_INFO_EDITOR_TYPE_TAGS_BOX, ENotesPageInfoEditorTagsBoxClass))
#define ENOTES_PAGE_INFO_EDITOR_IS_TAGS_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_PAGE_INFO_EDITOR_TYPE_TAGS_BOX))
#define ENOTES_PAGE_INFO_EDITOR_IS_TAGS_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_PAGE_INFO_EDITOR_TYPE_TAGS_BOX))
#define ENOTES_PAGE_INFO_EDITOR_TAGS_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_PAGE_INFO_EDITOR_TYPE_TAGS_BOX, ENotesPageInfoEditorTagsBoxClass))

typedef struct _ENotesPageInfoEditorTagsBox ENotesPageInfoEditorTagsBox;
typedef struct _ENotesPageInfoEditorTagsBoxClass ENotesPageInfoEditorTagsBoxClass;
typedef struct _ENotesPageInfoEditorTagsBoxPrivate ENotesPageInfoEditorTagsBoxPrivate;
enum  {
	ENOTES_PAGE_INFO_EDITOR_TAGS_BOX_0_PROPERTY,
	ENOTES_PAGE_INFO_EDITOR_TAGS_BOX_NUM_PROPERTIES
};
static GParamSpec* enotes_page_info_editor_tags_box_properties[ENOTES_PAGE_INFO_EDITOR_TAGS_BOX_NUM_PROPERTIES];

#define ENOTES_TYPE_TAG (enotes_tag_get_type ())
#define ENOTES_TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_TAG, ENotesTag))
#define ENOTES_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_TAG, ENotesTagClass))
#define ENOTES_IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_TAG))
#define ENOTES_IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_TAG))
#define ENOTES_TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_TAG, ENotesTagClass))

typedef struct _ENotesTag ENotesTag;
typedef struct _ENotesTagClass ENotesTagClass;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define ENOTES_TYPE_TAGS_TABLE (enotes_tags_table_get_type ())
#define ENOTES_TAGS_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_TAGS_TABLE, ENotesTagsTable))
#define ENOTES_TAGS_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_TAGS_TABLE, ENotesTagsTableClass))
#define ENOTES_IS_TAGS_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_TAGS_TABLE))
#define ENOTES_IS_TAGS_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_TAGS_TABLE))
#define ENOTES_TAGS_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_TAGS_TABLE, ENotesTagsTableClass))

typedef struct _ENotesTagsTable ENotesTagsTable;
typedef struct _ENotesTagsTableClass ENotesTagsTableClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
typedef struct _ENotesTagPrivate ENotesTagPrivate;
typedef struct _Block6Data Block6Data;

#define ENOTES_TYPE_APPLICATION (enotes_application_get_type ())
#define ENOTES_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_APPLICATION, ENotesApplication))
#define ENOTES_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_APPLICATION, ENotesApplicationClass))
#define ENOTES_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_APPLICATION))
#define ENOTES_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_APPLICATION))
#define ENOTES_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_APPLICATION, ENotesApplicationClass))

typedef struct _ENotesApplication ENotesApplication;
typedef struct _ENotesApplicationClass ENotesApplicationClass;
typedef struct _ENotesApplicationPrivate ENotesApplicationPrivate;

#define ENOTES_APPLICATION_TYPE_STATE (enotes_application_state_get_type ())
#define ENOTES_APPLICATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationState))
#define ENOTES_APPLICATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationStateClass))
#define ENOTES_APPLICATION_IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_APPLICATION_TYPE_STATE))
#define ENOTES_APPLICATION_IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_APPLICATION_TYPE_STATE))
#define ENOTES_APPLICATION_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationStateClass))

typedef struct _ENotesApplicationState ENotesApplicationState;
typedef struct _ENotesApplicationStateClass ENotesApplicationStateClass;

#define ENOTES_TYPE_NOTEBOOK_LIST_DIALOG (enotes_notebook_list_dialog_get_type ())
#define ENOTES_NOTEBOOK_LIST_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_NOTEBOOK_LIST_DIALOG, ENotesNotebookListDialog))
#define ENOTES_NOTEBOOK_LIST_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_NOTEBOOK_LIST_DIALOG, ENotesNotebookListDialogClass))
#define ENOTES_IS_NOTEBOOK_LIST_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_NOTEBOOK_LIST_DIALOG))
#define ENOTES_IS_NOTEBOOK_LIST_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_NOTEBOOK_LIST_DIALOG))
#define ENOTES_NOTEBOOK_LIST_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_NOTEBOOK_LIST_DIALOG, ENotesNotebookListDialogClass))

typedef struct _ENotesNotebookListDialog ENotesNotebookListDialog;
typedef struct _ENotesNotebookListDialogClass ENotesNotebookListDialogClass;

#define ENOTES_TYPE_WINDOW (enotes_window_get_type ())
#define ENOTES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_WINDOW, ENotesWindow))
#define ENOTES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_WINDOW, ENotesWindowClass))
#define ENOTES_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_WINDOW))
#define ENOTES_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_WINDOW))
#define ENOTES_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_WINDOW, ENotesWindowClass))

typedef struct _ENotesWindow ENotesWindow;
typedef struct _ENotesWindowClass ENotesWindowClass;

struct _ENotesPageInfoEditor {
	GtkRevealer parent_instance;
	ENotesPageInfoEditorPrivate * priv;
};

struct _ENotesPageInfoEditorClass {
	GtkRevealerClass parent_class;
};

struct _ENotesPageInfoEditorPrivate {
	GtkCssProvider* notebook_css_provider;
	GtkButton* current_notebook_button;
	GtkLabel* current_notebook;
	GtkLabel* created_date_label;
	GtkLabel* updated_date_label;
	GtkGrid* grid;
	ENotesButtonEntry* page_title;
	GtkToggleButton* toggle_button;
	ENotesPage* _page;
	ENotesNotebook* _notebook;
};

struct _ENotesPage {
	GObject parent_instance;
	ENotesPagePrivate * priv;
	gint64 id;
	gint64 notebook_id;
	gchar* name;
	gchar* data;
	gchar* subtitle;
	gchar* html_cache;
	gint64 creation_date;
	gint64 modification_date;
	gboolean new_page;
	gboolean cache_changed;
	gchar* full_path;
};

struct _ENotesPageClass {
	GObjectClass parent_class;
};

struct _ENotesNotebook {
	GObject parent_instance;
	ENotesNotebookPrivate * priv;
	gint64 id;
	gint64* parent_id;
	GdkRGBA rgb;
	gchar* name;
	gchar* css;
	gchar* stylesheet;
};

struct _ENotesNotebookClass {
	GObjectClass parent_class;
};

struct _ENotesPageInfoEditorTagsBox {
	GtkScrolledWindow parent_instance;
	ENotesPageInfoEditorTagsBoxPrivate * priv;
};

struct _ENotesPageInfoEditorTagsBoxClass {
	GtkScrolledWindowClass parent_class;
};

struct _ENotesPageInfoEditorTagsBoxPrivate {
	ENotesPage* page;
	GtkGrid* grid;
	GeeArrayList* tag_widgets;
	GtkEntryCompletion* completion;
	ENotesButtonEntry* new_tag_entry;
};

struct _ENotesTag {
	GObject parent_instance;
	ENotesTagPrivate * priv;
	gint64 id;
	gchar* name;
	gchar* data;
};

struct _ENotesTagClass {
	GObjectClass parent_class;
};

struct _Block6Data {
	int _ref_count_;
	ENotesPageInfoEditorTagsBox* self;
	ENotesTag* tag;
	GtkButton* tag_button;
};

struct _ENotesApplication {
	GraniteApplication parent_instance;
	ENotesApplicationPrivate * priv;
	gboolean running;
	ENotesApplicationState* state;
};

struct _ENotesApplicationClass {
	GraniteApplicationClass parent_class;
};

static gint ENotesPageInfoEditor_private_offset;
static gpointer enotes_page_info_editor_parent_class = NULL;
static gint ENotesPageInfoEditorTagsBox_private_offset;
static gpointer enotes_page_info_editor_tags_box_parent_class = NULL;
VALA_EXTERN ENotesApplication* enotes_app;

VALA_EXTERN GType enotes_page_info_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPageInfoEditor, g_object_unref)
VALA_EXTERN GType enotes_button_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesButtonEntry, g_object_unref)
VALA_EXTERN GType enotes_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPage, g_object_unref)
VALA_EXTERN GType enotes_notebook_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesNotebook, g_object_unref)
VALA_EXTERN ENotesPageInfoEditor* enotes_page_info_editor_new (void);
VALA_EXTERN ENotesPageInfoEditor* enotes_page_info_editor_construct (GType object_type);
static void enotes_page_info_editor_set_visibility (ENotesPageInfoEditor* self,
                                             gboolean value);
VALA_EXTERN GtkToggleButton* enotes_page_info_editor_get_toggle_button (ENotesPageInfoEditor* self);
static ENotesPage* enotes_page_info_editor_get_page (ENotesPageInfoEditor* self);
static void enotes_page_info_editor_set_page (ENotesPageInfoEditor* self,
                                       ENotesPage* value);
static void enotes_page_info_editor_set_creation_date (ENotesPageInfoEditor* self,
                                                GDateTime* value);
static void enotes_page_info_editor_set_modification_date (ENotesPageInfoEditor* self,
                                                    GDateTime* value);
VALA_EXTERN void enotes_button_entry_set_text (ENotesButtonEntry* self,
                                   const gchar* value);
static ENotesNotebook* enotes_page_info_editor_get_notebook (ENotesPageInfoEditor* self);
static void enotes_page_info_editor_set_notebook (ENotesPageInfoEditor* self,
                                           ENotesNotebook* value);
VALA_EXTERN GType enotes_page_info_editor_tags_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPageInfoEditorTagsBox, g_object_unref)
static void enotes_page_info_editor_tags_box_refresh_completion (ENotesPageInfoEditorTagsBox* self);
VALA_EXTERN GType enotes_tag_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesTag, g_object_unref)
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType enotes_tags_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesTagsTable, database_table_unref)
VALA_EXTERN ENotesTagsTable* enotes_tags_table_get_instance (void);
VALA_EXTERN GeeArrayList* enotes_tags_table_get_tags (ENotesTagsTable* self);
static void enotes_page_info_editor_tags_box_update_tags (ENotesPageInfoEditorTagsBox* self,
                                                   ENotesPage* page);
VALA_EXTERN GeeArrayList* enotes_tags_table_get_tags_for_page (ENotesTagsTable* self,
                                                   gint64 page_id);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean ____lambda87_ (Block6Data* _data6_);
static void __lambda88_ (Block6Data* _data6_);
VALA_EXTERN void enotes_tags_table_remove_tag_from_page (ENotesTagsTable* self,
                                             gint64 tag_id,
                                             gint64 page_id);
VALA_EXTERN GType enotes_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesApplication, g_object_unref)
VALA_EXTERN GType enotes_application_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesApplicationState, g_object_unref)
static void ___lambda88__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static gboolean _____lambda87__gtk_widget_button_release_event (GtkWidget* _sender,
                                                         GdkEventButton* event,
                                                         gpointer self);
VALA_EXTERN void enotes_button_entry_hide_entry (ENotesButtonEntry* self);
VALA_EXTERN GtkEntry* enotes_button_entry_get_entry (ENotesButtonEntry* self);
VALA_EXTERN ENotesPageInfoEditorTagsBox* enotes_page_info_editor_tags_box_new (void);
VALA_EXTERN ENotesPageInfoEditorTagsBox* enotes_page_info_editor_tags_box_construct (GType object_type);
static GObject * enotes_page_info_editor_tags_box_constructor (GType type,
                                                        guint n_construct_properties,
                                                        GObjectConstructParam * construct_properties);
VALA_EXTERN ENotesButtonEntry* enotes_button_entry_new_for_tags (const gchar* tag_text);
VALA_EXTERN ENotesButtonEntry* enotes_button_entry_construct_for_tags (GType object_type,
                                                           const gchar* tag_text);
static void _enotes_page_info_editor_tags_box___lambda89_ (ENotesPageInfoEditorTagsBox* self);
VALA_EXTERN void enotes_tags_table_create_tag (ENotesTagsTable* self,
                                   const gchar* name,
                                   ENotesPage* page);
VALA_EXTERN const gchar* enotes_button_entry_get_text (ENotesButtonEntry* self);
static void __enotes_page_info_editor_tags_box___lambda89__enotes_button_entry_activated (ENotesButtonEntry* _sender,
                                                                                   gpointer self);
static void _enotes_page_info_editor_tags_box___lambda90_ (ENotesPageInfoEditorTagsBox* self);
VALA_EXTERN ENotesPage* enotes_application_state_get_opened_page (ENotesApplicationState* self);
static void __enotes_page_info_editor_tags_box___lambda90__g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self);
static void _enotes_page_info_editor_tags_box___lambda91_ (ENotesPageInfoEditorTagsBox* self);
static void __enotes_page_info_editor_tags_box___lambda91__enotes_application_state_tags_changed (ENotesApplicationState* _sender,
                                                                                           gpointer self);
static void enotes_page_info_editor_tags_box_finalize (GObject * obj);
static GType enotes_page_info_editor_tags_box_get_type_once (void);
static GObject * enotes_page_info_editor_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
VALA_EXTERN ENotesButtonEntry* enotes_button_entry_new_for_page_title (void);
VALA_EXTERN ENotesButtonEntry* enotes_button_entry_construct_for_page_title (GType object_type);
static void _enotes_page_info_editor___lambda92_ (ENotesPageInfoEditor* self);
static void __enotes_page_info_editor___lambda92__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void _enotes_page_info_editor___lambda93_ (ENotesPageInfoEditor* self);
VALA_EXTERN ENotesNotebook* enotes_application_state_get_opened_page_notebook (ENotesApplicationState* self);
static void __enotes_page_info_editor___lambda93__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void _enotes_page_info_editor___lambda94_ (ENotesPageInfoEditor* self);
VALA_EXTERN gboolean enotes_application_state_get_show_page_info (ENotesApplicationState* self);
static void __enotes_page_info_editor___lambda94__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void _enotes_page_info_editor___lambda95_ (ENotesPageInfoEditor* self);
VALA_EXTERN void enotes_application_state_set_show_page_info (ENotesApplicationState* self,
                                                  gboolean value);
static void __enotes_page_info_editor___lambda95__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                      gpointer self);
static void _enotes_page_info_editor___lambda96_ (ENotesPageInfoEditor* self);
VALA_EXTERN ENotesNotebookListDialog* enotes_notebook_list_dialog_new_to_move_page (ENotesPage* page_to_move);
VALA_EXTERN ENotesNotebookListDialog* enotes_notebook_list_dialog_construct_to_move_page (GType object_type,
                                                                              ENotesPage* page_to_move);
VALA_EXTERN GType enotes_notebook_list_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesNotebookListDialog, g_object_unref)
static void __enotes_page_info_editor___lambda96__gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self);
static void _enotes_page_info_editor___lambda97_ (ENotesPageInfoEditor* self);
VALA_EXTERN GType enotes_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesWindow, g_object_unref)
VALA_EXTERN ENotesWindow* enotes_application_get_app_window (ENotesApplication* self);
static void __enotes_page_info_editor___lambda97__gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self);
static void _enotes_page_info_editor___lambda98_ (ENotesPageInfoEditor* self);
VALA_EXTERN void enotes_application_state_save_opened_page (ENotesApplicationState* self);
static void __enotes_page_info_editor___lambda98__enotes_button_entry_activated (ENotesButtonEntry* _sender,
                                                                          gpointer self);
static void _enotes_page_info_editor___lambda99_ (ENotesPageInfoEditor* self);
static void __enotes_page_info_editor___lambda99__enotes_application_state_update_page_title (ENotesApplicationState* _sender,
                                                                                       gpointer self);
static void _enotes_page_info_editor___lambda100_ (ENotesPageInfoEditor* self);
static void __enotes_page_info_editor___lambda100__enotes_application_state_opened_notebook_updated (ENotesApplicationState* _sender,
                                                                                              gpointer self);
static void enotes_page_info_editor_finalize (GObject * obj);
static GType enotes_page_info_editor_get_type_once (void);
static void _vala_enotes_page_info_editor_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_enotes_page_info_editor_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
enotes_page_info_editor_get_instance_private (ENotesPageInfoEditor* self)
{
	return G_STRUCT_MEMBER_P (self, ENotesPageInfoEditor_private_offset);
}

ENotesPageInfoEditor*
enotes_page_info_editor_construct (GType object_type)
{
	ENotesPageInfoEditor * self = NULL;
#line 112 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self = (ENotesPageInfoEditor*) g_object_new (object_type, NULL);
#line 113 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	enotes_page_info_editor_set_visibility (self, FALSE);
#line 112 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	return self;
#line 480 "PageInfoEditor.c"
}

ENotesPageInfoEditor*
enotes_page_info_editor_new (void)
{
#line 112 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	return enotes_page_info_editor_construct (ENOTES_TYPE_PAGE_INFO_EDITOR);
#line 488 "PageInfoEditor.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 245 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	return self ? g_object_ref (self) : NULL;
#line 496 "PageInfoEditor.c"
}

GtkToggleButton*
enotes_page_info_editor_get_toggle_button (ENotesPageInfoEditor* self)
{
	GtkToggleButton* _tmp0_;
	GtkToggleButton* _tmp1_;
	GtkToggleButton* result;
#line 244 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 245 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = self->priv->toggle_button;
#line 245 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 245 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	result = _tmp1_;
#line 245 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	return result;
#line 515 "PageInfoEditor.c"
}

static ENotesPage*
enotes_page_info_editor_get_page (ENotesPageInfoEditor* self)
{
	ENotesPage* result;
	ENotesPage* _tmp0_;
#line 37 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 38 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = self->priv->_page;
#line 38 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	result = _tmp0_;
#line 38 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	return result;
#line 531 "PageInfoEditor.c"
}

static void
enotes_page_info_editor_set_page (ENotesPageInfoEditor* self,
                                  ENotesPage* value)
{
	ENotesPage* _tmp6_;
#line 39 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_return_if_fail (self != NULL);
#line 40 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	if (value != NULL) {
#line 543 "PageInfoEditor.c"
		GDateTime* _tmp0_;
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		GDateTime* _tmp3_;
		ENotesButtonEntry* _tmp4_;
		const gchar* _tmp5_;
#line 41 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		enotes_page_info_editor_set_visibility (self, TRUE);
#line 43 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp0_ = g_date_time_new_from_unix_local (value->creation_date);
#line 43 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp1_ = _tmp0_;
#line 43 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		enotes_page_info_editor_set_creation_date (self, _tmp1_);
#line 43 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_g_date_time_unref0 (_tmp1_);
#line 44 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp2_ = g_date_time_new_from_unix_local (value->modification_date);
#line 44 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp3_ = _tmp2_;
#line 44 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		enotes_page_info_editor_set_modification_date (self, _tmp3_);
#line 44 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_g_date_time_unref0 (_tmp3_);
#line 45 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp4_ = self->priv->page_title;
#line 45 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp5_ = value->name;
#line 45 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		enotes_button_entry_set_text (_tmp4_, _tmp5_);
#line 574 "PageInfoEditor.c"
	} else {
#line 47 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		enotes_page_info_editor_set_visibility (self, FALSE);
#line 578 "PageInfoEditor.c"
	}
#line 50 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp6_ = _g_object_ref0 (value);
#line 50 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->_page);
#line 50 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self->priv->_page = _tmp6_;
#line 586 "PageInfoEditor.c"
}

static void
enotes_page_info_editor_set_visibility (ENotesPageInfoEditor* self,
                                        gboolean value)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GtkToggleButton* _tmp2_;
	GtkToggleButton* _tmp3_;
	GtkToggleButton* _tmp4_;
#line 55 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_return_if_fail (self != NULL);
#line 56 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = gtk_widget_get_visible ((GtkWidget*) self);
#line 56 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp1_ = _tmp0_;
#line 56 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	if (_tmp1_ == value) {
#line 56 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		return;
#line 608 "PageInfoEditor.c"
	}
#line 58 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_set_visible ((GtkWidget*) self, value);
#line 59 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_set_no_show_all ((GtkWidget*) self, !value);
#line 60 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp2_ = self->priv->toggle_button;
#line 60 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, value);
#line 61 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp3_ = self->priv->toggle_button;
#line 61 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp3_, !value);
#line 63 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp4_ = self->priv->toggle_button;
#line 63 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp4_);
#line 64 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_show_all ((GtkWidget*) self);
#line 628 "PageInfoEditor.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
#line 1578 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1579 "glib-2.0.vapi"
	result = self;
#line 1579 "glib-2.0.vapi"
	return result;
#line 641 "PageInfoEditor.c"
}

static void
enotes_page_info_editor_set_creation_date (ENotesPageInfoEditor* self,
                                           GDateTime* value)
{
	gchar* date = NULL;
	gchar* _tmp0_;
	GtkLabel* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 69 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_return_if_fail (self != NULL);
#line 70 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = granite_date_time_get_relative_datetime (value);
#line 70 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	date = _tmp0_;
#line 71 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp1_ = self->priv->created_date_label;
#line 71 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp2_ = string_to_string (date);
#line 71 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp3_ = g_strdup_printf (_ ("Created: %s"), _tmp2_);
#line 71 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp4_ = _tmp3_;
#line 71 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_label_set_label (_tmp1_, _tmp4_);
#line 71 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_free0 (_tmp4_);
#line 69 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_free0 (date);
#line 674 "PageInfoEditor.c"
}

static void
enotes_page_info_editor_set_modification_date (ENotesPageInfoEditor* self,
                                               GDateTime* value)
{
	gchar* date = NULL;
	gchar* _tmp0_;
	GtkLabel* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 76 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_return_if_fail (self != NULL);
#line 77 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = granite_date_time_get_relative_datetime (value);
#line 77 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	date = _tmp0_;
#line 78 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp1_ = self->priv->updated_date_label;
#line 78 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp2_ = string_to_string (date);
#line 78 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp3_ = g_strdup_printf (_ ("Updated: %s"), _tmp2_);
#line 78 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp4_ = _tmp3_;
#line 78 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_label_set_label (_tmp1_, _tmp4_);
#line 78 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_free0 (_tmp4_);
#line 76 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_free0 (date);
#line 707 "PageInfoEditor.c"
}

static ENotesNotebook*
enotes_page_info_editor_get_notebook (ENotesPageInfoEditor* self)
{
	ENotesNotebook* result;
	ENotesNotebook* _tmp0_;
#line 85 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 86 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = self->priv->_notebook;
#line 86 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	result = _tmp0_;
#line 86 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	return result;
#line 723 "PageInfoEditor.c"
}

static void
enotes_page_info_editor_set_notebook (ENotesPageInfoEditor* self,
                                      ENotesNotebook* value)
{
	ENotesNotebook* _tmp26_;
	GError* _inner_error0_ = NULL;
#line 87 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_return_if_fail (self != NULL);
#line 88 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	if (value != NULL) {
#line 736 "PageInfoEditor.c"
		GtkLabel* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
#line 89 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp0_ = self->priv->current_notebook;
#line 89 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp1_ = value->name;
#line 89 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp2_ = g_markup_printf_escaped ("%s<span color=\"#444\" size=\"x-large\">\342\214\204</span>", _tmp1_);
#line 89 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp3_ = _tmp2_;
#line 89 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		gtk_label_set_label (_tmp0_, _tmp3_);
#line 89 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_g_free0 (_tmp3_);
#line 753 "PageInfoEditor.c"
		{
			gchar* style = NULL;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			GtkCssProvider* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
#line 92 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			value->rgb.alpha = (gdouble) 1;
#line 93 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp4_ = gdk_rgba_to_string (&value->rgb);
#line 93 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp5_ = _tmp4_;
#line 93 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp6_ = g_strdup_printf (ENOTES_PAGE_INFO_EDITOR_NB_STYLE, _tmp5_);
#line 93 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp7_ = _tmp6_;
#line 93 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_g_free0 (_tmp5_);
#line 93 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			style = _tmp7_;
#line 94 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp8_ = self->priv->notebook_css_provider;
#line 94 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp9_ = style;
#line 94 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp10_ = style;
#line 94 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp11_ = strlen (_tmp10_);
#line 94 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp12_ = _tmp11_;
#line 94 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			gtk_css_provider_load_from_data (_tmp8_, _tmp9_, (gssize) _tmp12_, &_inner_error0_);
#line 94 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 94 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
				_g_free0 (style);
#line 795 "PageInfoEditor.c"
				goto __catch0_g_error;
			}
#line 91 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_g_free0 (style);
#line 800 "PageInfoEditor.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp13_;
			const gchar* _tmp14_;
#line 91 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			e = _inner_error0_;
#line 91 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_inner_error0_ = NULL;
#line 96 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp13_ = e;
#line 96 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp14_ = _tmp13_->message;
#line 96 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			g_warning ("PageInfoEditor.vala:96: Style error: %s", _tmp14_);
#line 91 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_g_error_free0 (e);
#line 820 "PageInfoEditor.c"
		}
		__finally0:
#line 91 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 91 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 91 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			g_clear_error (&_inner_error0_);
#line 91 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			return;
#line 831 "PageInfoEditor.c"
		}
	} else {
		{
			GtkLabel* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* style = NULL;
			gchar* _tmp18_;
			GtkCssProvider* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
#line 100 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp15_ = self->priv->current_notebook;
#line 100 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp16_ = g_markup_printf_escaped ("%s<span color=\"#444\" size=\"x-large\">\342\214\204</span>", _ ("Not in Notebook"));
#line 100 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp17_ = _tmp16_;
#line 100 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			gtk_label_set_label (_tmp15_, _tmp17_);
#line 100 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_g_free0 (_tmp17_);
#line 101 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp18_ = g_strdup_printf (ENOTES_PAGE_INFO_EDITOR_NB_STYLE, "#000");
#line 101 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			style = _tmp18_;
#line 102 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp19_ = self->priv->notebook_css_provider;
#line 102 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp20_ = style;
#line 102 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp21_ = style;
#line 102 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp22_ = strlen (_tmp21_);
#line 102 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp23_ = _tmp22_;
#line 102 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			gtk_css_provider_load_from_data (_tmp19_, _tmp20_, (gssize) _tmp23_, &_inner_error0_);
#line 102 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 102 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
				_g_free0 (style);
#line 875 "PageInfoEditor.c"
				goto __catch1_g_error;
			}
#line 99 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_g_free0 (style);
#line 880 "PageInfoEditor.c"
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp24_;
			const gchar* _tmp25_;
#line 99 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			e = _inner_error0_;
#line 99 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_inner_error0_ = NULL;
#line 104 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp24_ = e;
#line 104 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp25_ = _tmp24_->message;
#line 104 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			g_warning ("PageInfoEditor.vala:104: Style error: %s", _tmp25_);
#line 99 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_g_error_free0 (e);
#line 900 "PageInfoEditor.c"
		}
		__finally1:
#line 99 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 99 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 99 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			g_clear_error (&_inner_error0_);
#line 99 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			return;
#line 911 "PageInfoEditor.c"
		}
	}
#line 108 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp26_ = _g_object_ref0 (value);
#line 108 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->_notebook);
#line 108 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self->priv->_notebook = _tmp26_;
#line 920 "PageInfoEditor.c"
}

static inline gpointer
enotes_page_info_editor_tags_box_get_instance_private (ENotesPageInfoEditorTagsBox* self)
{
	return G_STRUCT_MEMBER_P (self, ENotesPageInfoEditorTagsBox_private_offset);
}

static void
enotes_page_info_editor_tags_box_refresh_completion (ENotesPageInfoEditorTagsBox* self)
{
	GtkListStore* list_store = NULL;
	GtkListStore* _tmp0_;
	GtkEntryCompletion* _tmp1_;
	GtkListStore* _tmp2_;
	GtkTreeIter iter = {0};
#line 299 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_return_if_fail (self != NULL);
#line 300 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING, -1);
#line 300 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	list_store = _tmp0_;
#line 301 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp1_ = self->priv->completion;
#line 301 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp2_ = list_store;
#line 301 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_entry_completion_set_model (_tmp1_, (GtkTreeModel*) _tmp2_);
#line 949 "PageInfoEditor.c"
	{
		GeeArrayList* _tag_list = NULL;
		ENotesTagsTable* _tmp3_;
		ENotesTagsTable* _tmp4_;
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		gint _tag_size = 0;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tag_index = 0;
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp3_ = enotes_tags_table_get_instance ();
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp4_ = _tmp3_;
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp5_ = enotes_tags_table_get_tags (_tmp4_);
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp6_ = _tmp5_;
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_database_table_unref0 (_tmp4_);
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tag_list = _tmp6_;
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp7_ = _tag_list;
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp9_ = _tmp8_;
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tag_size = _tmp9_;
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tag_index = -1;
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		while (TRUE) {
#line 985 "PageInfoEditor.c"
			gint _tmp10_;
			gint _tmp11_;
			ENotesTag* tag = NULL;
			GeeArrayList* _tmp12_;
			gpointer _tmp13_;
			GtkListStore* _tmp14_;
			GtkTreeIter _tmp15_ = {0};
			GtkListStore* _tmp16_;
			GtkTreeIter _tmp17_;
			ENotesTag* _tmp18_;
			const gchar* _tmp19_;
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tag_index = _tag_index + 1;
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp10_ = _tag_index;
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp11_ = _tag_size;
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			if (!(_tmp10_ < _tmp11_)) {
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
				break;
#line 1007 "PageInfoEditor.c"
			}
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp12_ = _tag_list;
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tag_index);
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			tag = (ENotesTag*) _tmp13_;
#line 305 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp14_ = list_store;
#line 305 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			gtk_list_store_append (_tmp14_, &_tmp15_);
#line 305 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			iter = _tmp15_;
#line 306 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp16_ = list_store;
#line 306 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp17_ = iter;
#line 306 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp18_ = tag;
#line 306 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp19_ = _tmp18_->name;
#line 306 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			gtk_list_store_set (_tmp16_, &_tmp17_, 0, _tmp19_, -1);
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_g_object_unref0 (tag);
#line 1033 "PageInfoEditor.c"
		}
#line 304 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_g_object_unref0 (_tag_list);
#line 1037 "PageInfoEditor.c"
	}
#line 299 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (list_store);
#line 1041 "PageInfoEditor.c"
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	return _data6_;
#line 1051 "PageInfoEditor.c"
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 1061 "PageInfoEditor.c"
		ENotesPageInfoEditorTagsBox* self;
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		self = _data6_->self;
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_g_object_unref0 (_data6_->tag_button);
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_g_object_unref0 (_data6_->tag);
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_g_object_unref0 (self);
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		g_slice_free (Block6Data, _data6_);
#line 1073 "PageInfoEditor.c"
	}
}

static void
__lambda88_ (Block6Data* _data6_)
{
	ENotesPageInfoEditorTagsBox* self;
	ENotesTagsTable* _tmp0_;
	ENotesTagsTable* _tmp1_;
	ENotesTag* _tmp2_;
	ENotesPage* _tmp3_;
	ENotesApplication* _tmp4_;
	ENotesApplicationState* _tmp5_;
#line 337 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self = _data6_->self;
#line 338 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = enotes_tags_table_get_instance ();
#line 338 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp1_ = _tmp0_;
#line 338 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp2_ = _data6_->tag;
#line 338 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp3_ = self->priv->page;
#line 338 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	enotes_tags_table_remove_tag_from_page (_tmp1_, _tmp2_->id, _tmp3_->id);
#line 338 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_database_table_unref0 (_tmp1_);
#line 339 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp4_ = enotes_app;
#line 339 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp5_ = _tmp4_->state;
#line 339 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_signal_emit_by_name (_tmp5_, "tags-changed");
#line 1107 "PageInfoEditor.c"
}

static void
___lambda88__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
#line 337 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	__lambda88_ (self);
#line 1116 "PageInfoEditor.c"
}

static gboolean
____lambda87_ (Block6Data* _data6_)
{
	ENotesPageInfoEditorTagsBox* self;
	GtkMenu* menu = NULL;
	GtkMenu* _tmp0_;
	GtkButton* _tmp1_;
	GtkMenuItem* remove = NULL;
	GtkMenuItem* _tmp2_;
	GtkButton* _tmp3_;
	gboolean result;
#line 327 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self = _data6_->self;
#line 328 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
#line 328 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp0_);
#line 328 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	menu = _tmp0_;
#line 329 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp1_ = _data6_->tag_button;
#line 329 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_set (menu, "attach-widget", (GtkWidget*) _tmp1_, NULL);
#line 331 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp2_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Remove tag"));
#line 331 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp2_);
#line 331 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	remove = _tmp2_;
#line 332 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_container_add ((GtkContainer*) menu, (GtkWidget*) remove);
#line 333 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_show_all ((GtkWidget*) menu);
#line 335 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp3_ = _data6_->tag_button;
#line 335 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_menu_popup_at_widget (menu, (GtkWidget*) _tmp3_, GDK_GRAVITY_SOUTH, GDK_GRAVITY_NORTH, NULL);
#line 337 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_signal_connect_data (remove, "activate", (GCallback) ___lambda88__gtk_menu_item_activate, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
#line 342 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	result = TRUE;
#line 342 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (remove);
#line 342 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (menu);
#line 342 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	return result;
#line 1166 "PageInfoEditor.c"
}

static gboolean
_____lambda87__gtk_widget_button_release_event (GtkWidget* _sender,
                                                GdkEventButton* event,
                                                gpointer self)
{
	gboolean result;
	result = ____lambda87_ (self);
#line 327 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	return result;
#line 1178 "PageInfoEditor.c"
}

static void
enotes_page_info_editor_tags_box_update_tags (ENotesPageInfoEditorTagsBox* self,
                                              ENotesPage* page)
{
	GtkGrid* _tmp0_;
	ENotesButtonEntry* _tmp1_;
	GeeArrayList* tags = NULL;
	ENotesTagsTable* _tmp11_;
	ENotesTagsTable* _tmp12_;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
	ENotesButtonEntry* _tmp33_;
	ENotesButtonEntry* _tmp34_;
	GtkEntry* _tmp35_;
	GtkEntry* _tmp36_;
	ENotesButtonEntry* _tmp37_;
	GtkEntry* _tmp38_;
	GtkEntry* _tmp39_;
	GtkEntryCompletion* _tmp40_;
	GtkGrid* _tmp41_;
	ENotesButtonEntry* _tmp42_;
	GtkGrid* _tmp43_;
#line 310 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_return_if_fail (self != NULL);
#line 311 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = self->priv->grid;
#line 311 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp1_ = self->priv->new_tag_entry;
#line 311 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_container_remove ((GtkContainer*) _tmp0_, (GtkWidget*) _tmp1_);
#line 1211 "PageInfoEditor.c"
	{
		GeeArrayList* _child_list = NULL;
		GeeArrayList* _tmp2_;
		gint _child_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _child_index = 0;
#line 312 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp2_ = self->priv->tag_widgets;
#line 312 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_child_list = _tmp2_;
#line 312 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp3_ = _child_list;
#line 312 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
#line 312 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp5_ = _tmp4_;
#line 312 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_child_size = _tmp5_;
#line 312 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_child_index = -1;
#line 312 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		while (TRUE) {
#line 1236 "PageInfoEditor.c"
			gint _tmp6_;
			gint _tmp7_;
			GtkWidget* child = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			GtkWidget* _tmp10_;
#line 312 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_child_index = _child_index + 1;
#line 312 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp6_ = _child_index;
#line 312 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp7_ = _child_size;
#line 312 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 312 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
				break;
#line 1253 "PageInfoEditor.c"
			}
#line 312 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp8_ = _child_list;
#line 312 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _child_index);
#line 312 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			child = (GtkWidget*) _tmp9_;
#line 313 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp10_ = child;
#line 313 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			gtk_widget_destroy (_tmp10_);
#line 312 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_g_object_unref0 (child);
#line 1267 "PageInfoEditor.c"
		}
	}
#line 316 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	if (page == NULL) {
#line 316 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		return;
#line 1274 "PageInfoEditor.c"
	}
#line 318 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp11_ = enotes_tags_table_get_instance ();
#line 318 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp12_ = _tmp11_;
#line 318 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp13_ = enotes_tags_table_get_tags_for_page (_tmp12_, page->id);
#line 318 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp14_ = _tmp13_;
#line 318 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_database_table_unref0 (_tmp12_);
#line 318 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	tags = _tmp14_;
#line 1288 "PageInfoEditor.c"
	{
		GeeArrayList* _tag_list = NULL;
		GeeArrayList* _tmp15_;
		gint _tag_size = 0;
		GeeArrayList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _tag_index = 0;
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp15_ = tags;
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tag_list = _tmp15_;
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp16_ = _tag_list;
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp18_ = _tmp17_;
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tag_size = _tmp18_;
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tag_index = -1;
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		while (TRUE) {
#line 1313 "PageInfoEditor.c"
			Block6Data* _data6_;
			gint _tmp19_;
			gint _tmp20_;
			GeeArrayList* _tmp21_;
			gpointer _tmp22_;
			ENotesTag* _tmp23_;
			const gchar* _tmp24_;
			GtkButton* _tmp25_;
			GtkButton* _tmp26_;
			GtkStyleContext* _tmp27_;
			GtkGrid* _tmp28_;
			GtkButton* _tmp29_;
			GeeArrayList* _tmp30_;
			GtkButton* _tmp31_;
			GtkButton* _tmp32_;
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_data6_ = g_slice_new0 (Block6Data);
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_data6_->_ref_count_ = 1;
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_data6_->self = g_object_ref (self);
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tag_index = _tag_index + 1;
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp19_ = _tag_index;
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp20_ = _tag_size;
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			if (!(_tmp19_ < _tmp20_)) {
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
				block6_data_unref (_data6_);
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
				_data6_ = NULL;
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
				break;
#line 1349 "PageInfoEditor.c"
			}
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp21_ = _tag_list;
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _tag_index);
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_data6_->tag = (ENotesTag*) _tmp22_;
#line 321 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp23_ = _data6_->tag;
#line 321 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp24_ = _tmp23_->name;
#line 321 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp25_ = (GtkButton*) gtk_button_new_with_label (_tmp24_);
#line 321 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			g_object_ref_sink (_tmp25_);
#line 321 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_data6_->tag_button = _tmp25_;
#line 322 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp26_ = _data6_->tag_button;
#line 322 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp27_ = gtk_widget_get_style_context ((GtkWidget*) _tmp26_);
#line 322 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			gtk_style_context_add_class (_tmp27_, "flat");
#line 323 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp28_ = self->priv->grid;
#line 323 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp29_ = _data6_->tag_button;
#line 323 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			gtk_container_add ((GtkContainer*) _tmp28_, (GtkWidget*) _tmp29_);
#line 325 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp30_ = self->priv->tag_widgets;
#line 325 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp31_ = _data6_->tag_button;
#line 325 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, (GtkWidget*) _tmp31_);
#line 327 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_tmp32_ = _data6_->tag_button;
#line 327 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			g_signal_connect_data ((GtkWidget*) _tmp32_, "button-release-event", (GCallback) _____lambda87__gtk_widget_button_release_event, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			block6_data_unref (_data6_);
#line 320 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
			_data6_ = NULL;
#line 1393 "PageInfoEditor.c"
		}
	}
#line 346 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp33_ = self->priv->new_tag_entry;
#line 346 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	enotes_button_entry_hide_entry (_tmp33_);
#line 347 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp34_ = self->priv->new_tag_entry;
#line 347 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp35_ = enotes_button_entry_get_entry (_tmp34_);
#line 347 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp36_ = _tmp35_;
#line 347 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_entry_set_text (_tmp36_, "");
#line 348 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp37_ = self->priv->new_tag_entry;
#line 348 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp38_ = enotes_button_entry_get_entry (_tmp37_);
#line 348 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp39_ = _tmp38_;
#line 348 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp40_ = self->priv->completion;
#line 348 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_entry_set_completion (_tmp39_, _tmp40_);
#line 350 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp41_ = self->priv->grid;
#line 350 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp42_ = self->priv->new_tag_entry;
#line 350 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_container_add ((GtkContainer*) _tmp41_, (GtkWidget*) _tmp42_);
#line 351 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp43_ = self->priv->grid;
#line 351 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp43_);
#line 310 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (tags);
#line 1430 "PageInfoEditor.c"
}

ENotesPageInfoEditorTagsBox*
enotes_page_info_editor_tags_box_construct (GType object_type)
{
	ENotesPageInfoEditorTagsBox * self = NULL;
#line 250 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self = (ENotesPageInfoEditorTagsBox*) g_object_new (object_type, NULL);
#line 250 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	return self;
#line 1441 "PageInfoEditor.c"
}

ENotesPageInfoEditorTagsBox*
enotes_page_info_editor_tags_box_new (void)
{
#line 250 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	return enotes_page_info_editor_tags_box_construct (ENOTES_PAGE_INFO_EDITOR_TYPE_TAGS_BOX);
#line 1449 "PageInfoEditor.c"
}

static void
_enotes_page_info_editor_tags_box___lambda89_ (ENotesPageInfoEditorTagsBox* self)
{
	ENotesTagsTable* _tmp0_;
	ENotesTagsTable* _tmp1_;
	ENotesButtonEntry* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ENotesPage* _tmp5_;
	ENotesApplication* _tmp6_;
	ENotesApplicationState* _tmp7_;
#line 267 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = enotes_tags_table_get_instance ();
#line 267 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp1_ = _tmp0_;
#line 267 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp2_ = self->priv->new_tag_entry;
#line 267 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp3_ = enotes_button_entry_get_text (_tmp2_);
#line 267 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp4_ = _tmp3_;
#line 267 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp5_ = self->priv->page;
#line 267 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	enotes_tags_table_create_tag (_tmp1_, _tmp4_, _tmp5_);
#line 267 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_database_table_unref0 (_tmp1_);
#line 268 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp6_ = enotes_app;
#line 268 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp7_ = _tmp6_->state;
#line 268 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_signal_emit_by_name (_tmp7_, "tags-changed");
#line 1485 "PageInfoEditor.c"
}

static void
__enotes_page_info_editor_tags_box___lambda89__enotes_button_entry_activated (ENotesButtonEntry* _sender,
                                                                              gpointer self)
{
#line 266 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_enotes_page_info_editor_tags_box___lambda89_ ((ENotesPageInfoEditorTagsBox*) self);
#line 1494 "PageInfoEditor.c"
}

static void
_enotes_page_info_editor_tags_box___lambda90_ (ENotesPageInfoEditorTagsBox* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	ENotesPage* _tmp2_;
	ENotesPage* _tmp3_;
	ENotesPage* _tmp4_;
	ENotesPage* _tmp5_;
#line 286 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = enotes_app;
#line 286 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp1_ = _tmp0_->state;
#line 286 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp2_ = enotes_application_state_get_opened_page (_tmp1_);
#line 286 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp3_ = _tmp2_;
#line 286 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 286 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->page);
#line 286 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self->priv->page = _tmp4_;
#line 287 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp5_ = self->priv->page;
#line 287 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	enotes_page_info_editor_tags_box_update_tags (self, _tmp5_);
#line 1524 "PageInfoEditor.c"
}

static void
__enotes_page_info_editor_tags_box___lambda90__g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self)
{
#line 285 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_enotes_page_info_editor_tags_box___lambda90_ ((ENotesPageInfoEditorTagsBox*) self);
#line 1534 "PageInfoEditor.c"
}

static void
_enotes_page_info_editor_tags_box___lambda91_ (ENotesPageInfoEditorTagsBox* self)
{
	ENotesPage* _tmp0_;
#line 291 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = self->priv->page;
#line 291 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	enotes_page_info_editor_tags_box_update_tags (self, _tmp0_);
#line 293 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	enotes_page_info_editor_tags_box_refresh_completion (self);
#line 1547 "PageInfoEditor.c"
}

static void
__enotes_page_info_editor_tags_box___lambda91__enotes_application_state_tags_changed (ENotesApplicationState* _sender,
                                                                                      gpointer self)
{
#line 290 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_enotes_page_info_editor_tags_box___lambda91_ ((ENotesPageInfoEditorTagsBox*) self);
#line 1556 "PageInfoEditor.c"
}

static GObject *
enotes_page_info_editor_tags_box_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ENotesPageInfoEditorTagsBox * self;
	GeeArrayList* _tmp0_;
	ENotesButtonEntry* _tmp1_;
	ENotesButtonEntry* _tmp2_;
	GtkEntryCompletion* _tmp3_;
	GtkEntryCompletion* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkGrid* _tmp7_;
	GtkGrid* _tmp8_;
	GtkGrid* _tmp9_;
	GtkImage* _tmp10_;
	GtkImage* _tmp11_;
	GtkGrid* _tmp12_;
	ENotesButtonEntry* _tmp13_;
	GtkGrid* _tmp14_;
	ENotesApplication* _tmp15_;
	ENotesApplicationState* _tmp16_;
	ENotesApplication* _tmp17_;
	ENotesApplicationState* _tmp18_;
#line 259 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	parent_class = G_OBJECT_CLASS (enotes_page_info_editor_tags_box_parent_class);
#line 259 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 259 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_PAGE_INFO_EDITOR_TYPE_TAGS_BOX, ENotesPageInfoEditorTagsBox);
#line 260 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
#line 261 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_CENTER);
#line 263 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = gee_array_list_new (gtk_widget_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 263 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->tag_widgets);
#line 263 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self->priv->tag_widgets = _tmp0_;
#line 265 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp1_ = enotes_button_entry_new_for_tags (_ ("Click to add tag…"));
#line 265 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp1_);
#line 265 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->new_tag_entry);
#line 265 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self->priv->new_tag_entry = _tmp1_;
#line 266 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp2_ = self->priv->new_tag_entry;
#line 266 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_signal_connect_object (_tmp2_, "activated", (GCallback) __enotes_page_info_editor_tags_box___lambda89__enotes_button_entry_activated, self, 0);
#line 271 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp3_ = gtk_entry_completion_new ();
#line 271 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->completion);
#line 271 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self->priv->completion = _tmp3_;
#line 272 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp4_ = self->priv->completion;
#line 272 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_entry_completion_set_text_column (_tmp4_, 0);
#line 274 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp5_ = (GtkGrid*) gtk_grid_new ();
#line 274 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp5_);
#line 274 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->grid);
#line 274 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self->priv->grid = _tmp5_;
#line 275 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp6_ = self->priv->grid;
#line 275 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp6_, GTK_ORIENTATION_HORIZONTAL);
#line 276 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp7_ = self->priv->grid;
#line 276 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp7_, GTK_ALIGN_CENTER);
#line 277 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp8_ = self->priv->grid;
#line 277 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_grid_set_column_spacing (_tmp8_, 3);
#line 279 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp9_ = self->priv->grid;
#line 279 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp10_ = (GtkImage*) gtk_image_new_from_icon_name ("tag-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 279 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp10_);
#line 279 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp11_ = _tmp10_;
#line 279 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp11_);
#line 279 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (_tmp11_);
#line 280 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp12_ = self->priv->grid;
#line 280 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp13_ = self->priv->new_tag_entry;
#line 280 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
#line 282 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp14_ = self->priv->grid;
#line 282 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp14_);
#line 283 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_show_all ((GtkWidget*) self);
#line 285 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp15_ = enotes_app;
#line 285 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp16_ = _tmp15_->state;
#line 285 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_signal_connect_object ((GObject*) _tmp16_, "notify::opened-page", (GCallback) __enotes_page_info_editor_tags_box___lambda90__g_object_notify, self, 0);
#line 290 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp17_ = enotes_app;
#line 290 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp18_ = _tmp17_->state;
#line 290 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_signal_connect_object (_tmp18_, "tags-changed", (GCallback) __enotes_page_info_editor_tags_box___lambda91__enotes_application_state_tags_changed, self, 0);
#line 296 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	enotes_page_info_editor_tags_box_refresh_completion (self);
#line 259 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	return obj;
#line 1684 "PageInfoEditor.c"
}

static void
enotes_page_info_editor_tags_box_class_init (ENotesPageInfoEditorTagsBoxClass * klass,
                                             gpointer klass_data)
{
#line 250 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	enotes_page_info_editor_tags_box_parent_class = g_type_class_peek_parent (klass);
#line 250 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_type_class_adjust_private_offset (klass, &ENotesPageInfoEditorTagsBox_private_offset);
#line 250 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	G_OBJECT_CLASS (klass)->constructor = enotes_page_info_editor_tags_box_constructor;
#line 250 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	G_OBJECT_CLASS (klass)->finalize = enotes_page_info_editor_tags_box_finalize;
#line 1699 "PageInfoEditor.c"
}

static void
enotes_page_info_editor_tags_box_instance_init (ENotesPageInfoEditorTagsBox * self,
                                                gpointer klass)
{
#line 250 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self->priv = enotes_page_info_editor_tags_box_get_instance_private (self);
#line 1708 "PageInfoEditor.c"
}

static void
enotes_page_info_editor_tags_box_finalize (GObject * obj)
{
	ENotesPageInfoEditorTagsBox * self;
#line 250 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_PAGE_INFO_EDITOR_TYPE_TAGS_BOX, ENotesPageInfoEditorTagsBox);
#line 251 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->page);
#line 252 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->grid);
#line 254 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->tag_widgets);
#line 255 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->completion);
#line 257 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->new_tag_entry);
#line 250 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	G_OBJECT_CLASS (enotes_page_info_editor_tags_box_parent_class)->finalize (obj);
#line 1729 "PageInfoEditor.c"
}

static GType
enotes_page_info_editor_tags_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesPageInfoEditorTagsBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_page_info_editor_tags_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesPageInfoEditorTagsBox), 0, (GInstanceInitFunc) enotes_page_info_editor_tags_box_instance_init, NULL };
	GType enotes_page_info_editor_tags_box_type_id;
	enotes_page_info_editor_tags_box_type_id = g_type_register_static (gtk_scrolled_window_get_type (), "ENotesPageInfoEditorTagsBox", &g_define_type_info, 0);
	ENotesPageInfoEditorTagsBox_private_offset = g_type_add_instance_private (enotes_page_info_editor_tags_box_type_id, sizeof (ENotesPageInfoEditorTagsBoxPrivate));
	return enotes_page_info_editor_tags_box_type_id;
}

GType
enotes_page_info_editor_tags_box_get_type (void)
{
	static volatile gsize enotes_page_info_editor_tags_box_type_id__once = 0;
	if (g_once_init_enter (&enotes_page_info_editor_tags_box_type_id__once)) {
		GType enotes_page_info_editor_tags_box_type_id;
		enotes_page_info_editor_tags_box_type_id = enotes_page_info_editor_tags_box_get_type_once ();
		g_once_init_leave (&enotes_page_info_editor_tags_box_type_id__once, enotes_page_info_editor_tags_box_type_id);
	}
	return enotes_page_info_editor_tags_box_type_id__once;
}

static void
_enotes_page_info_editor___lambda92_ (ENotesPageInfoEditor* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	ENotesPage* _tmp2_;
	ENotesPage* _tmp3_;
#line 185 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = enotes_app;
#line 185 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp1_ = _tmp0_->state;
#line 185 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp2_ = enotes_application_state_get_opened_page (_tmp1_);
#line 185 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp3_ = _tmp2_;
#line 185 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	enotes_page_info_editor_set_page (self, _tmp3_);
#line 1771 "PageInfoEditor.c"
}

static void
__enotes_page_info_editor___lambda92__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
#line 184 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_enotes_page_info_editor___lambda92_ ((ENotesPageInfoEditor*) self);
#line 1781 "PageInfoEditor.c"
}

static void
_enotes_page_info_editor___lambda93_ (ENotesPageInfoEditor* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	ENotesNotebook* _tmp2_;
	ENotesNotebook* _tmp3_;
#line 189 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = enotes_app;
#line 189 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp1_ = _tmp0_->state;
#line 189 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp2_ = enotes_application_state_get_opened_page_notebook (_tmp1_);
#line 189 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp3_ = _tmp2_;
#line 189 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	enotes_page_info_editor_set_notebook (self, _tmp3_);
#line 1801 "PageInfoEditor.c"
}

static void
__enotes_page_info_editor___lambda93__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
#line 188 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_enotes_page_info_editor___lambda93_ ((ENotesPageInfoEditor*) self);
#line 1811 "PageInfoEditor.c"
}

static void
_enotes_page_info_editor___lambda94_ (ENotesPageInfoEditor* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkToggleButton* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
#line 205 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = enotes_app;
#line 205 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp1_ = _tmp0_->state;
#line 205 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp2_ = enotes_application_state_get_show_page_info (_tmp1_);
#line 205 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp3_ = _tmp2_;
#line 205 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_revealer_set_reveal_child ((GtkRevealer*) self, _tmp3_);
#line 206 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp4_ = self->priv->toggle_button;
#line 206 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp5_ = gtk_revealer_get_reveal_child ((GtkRevealer*) self);
#line 206 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp6_ = _tmp5_;
#line 206 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	if (gtk_toggle_button_get_active (_tmp4_) != _tmp6_) {
#line 1842 "PageInfoEditor.c"
		GtkToggleButton* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
#line 207 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp7_ = self->priv->toggle_button;
#line 207 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp8_ = gtk_revealer_get_reveal_child ((GtkRevealer*) self);
#line 207 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		_tmp9_ = _tmp8_;
#line 207 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		gtk_toggle_button_set_active (_tmp7_, _tmp9_);
#line 1854 "PageInfoEditor.c"
	}
}

static void
__enotes_page_info_editor___lambda94__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
#line 204 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_enotes_page_info_editor___lambda94_ ((ENotesPageInfoEditor*) self);
#line 1865 "PageInfoEditor.c"
}

static void
_enotes_page_info_editor___lambda95_ (ENotesPageInfoEditor* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	GtkToggleButton* _tmp2_;
#line 212 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = enotes_app;
#line 212 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp1_ = _tmp0_->state;
#line 212 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp2_ = self->priv->toggle_button;
#line 212 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	enotes_application_state_set_show_page_info (_tmp1_, gtk_toggle_button_get_active (_tmp2_));
#line 1882 "PageInfoEditor.c"
}

static void
__enotes_page_info_editor___lambda95__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                 gpointer self)
{
#line 211 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_enotes_page_info_editor___lambda95_ ((ENotesPageInfoEditor*) self);
#line 1891 "PageInfoEditor.c"
}

static void
_enotes_page_info_editor___lambda96_ (ENotesPageInfoEditor* self)
{
	ENotesPage* _tmp0_;
	ENotesPage* _tmp1_;
	ENotesNotebookListDialog* _tmp2_;
	ENotesNotebookListDialog* _tmp3_;
#line 216 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = enotes_page_info_editor_get_page (self);
#line 216 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp1_ = _tmp0_;
#line 216 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp2_ = enotes_notebook_list_dialog_new_to_move_page (_tmp1_);
#line 216 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp2_);
#line 216 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp3_ = _tmp2_;
#line 216 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (_tmp3_);
#line 1913 "PageInfoEditor.c"
}

static void
__enotes_page_info_editor___lambda96__gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self)
{
#line 215 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_enotes_page_info_editor___lambda96_ ((ENotesPageInfoEditor*) self);
#line 1922 "PageInfoEditor.c"
}

static void
_enotes_page_info_editor___lambda97_ (ENotesPageInfoEditor* self)
{
	GtkClipboard* clipboard = NULL;
	ENotesApplication* _tmp0_;
	ENotesWindow* _tmp1_;
	ENotesWindow* _tmp2_;
	GdkDisplay* _tmp3_;
	GtkClipboard* _tmp4_;
	GtkClipboard* _tmp5_;
	GtkClipboard* _tmp6_;
	ENotesPage* p = NULL;
	ENotesPage* _tmp7_;
	ENotesPage* _tmp8_;
	ENotesPage* _tmp9_;
	gchar* link_text = NULL;
	ENotesPage* _tmp10_;
	ENotesPage* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GtkClipboard* _tmp14_;
	const gchar* _tmp15_;
#line 220 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = enotes_app;
#line 220 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp1_ = enotes_application_get_app_window (_tmp0_);
#line 220 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp2_ = _tmp1_;
#line 220 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp3_ = gtk_widget_get_display ((GtkWidget*) _tmp2_);
#line 220 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp4_ = gtk_clipboard_get_default (_tmp3_);
#line 220 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 220 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp6_ = _tmp5_;
#line 220 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (_tmp2_);
#line 220 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	clipboard = _tmp6_;
#line 221 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp7_ = enotes_page_info_editor_get_page (self);
#line 221 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp8_ = _tmp7_;
#line 221 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 221 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	p = _tmp9_;
#line 223 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp10_ = p;
#line 223 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp11_ = p;
#line 223 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp12_ = _tmp11_->name;
#line 223 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp13_ = g_strdup_printf ("<page %lld %s %s>", _tmp10_->id, _ ("Link to: "), _tmp12_);
#line 223 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	link_text = _tmp13_;
#line 224 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp14_ = clipboard;
#line 224 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp15_ = link_text;
#line 224 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_clipboard_set_text (_tmp14_, _tmp15_, -1);
#line 219 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_free0 (link_text);
#line 219 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (p);
#line 219 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (clipboard);
#line 1995 "PageInfoEditor.c"
}

static void
__enotes_page_info_editor___lambda97__gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self)
{
#line 219 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_enotes_page_info_editor___lambda97_ ((ENotesPageInfoEditor*) self);
#line 2004 "PageInfoEditor.c"
}

static void
_enotes_page_info_editor___lambda98_ (ENotesPageInfoEditor* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	ENotesPage* _tmp2_;
	ENotesPage* _tmp3_;
	ENotesButtonEntry* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	ENotesApplication* _tmp8_;
	ENotesApplicationState* _tmp9_;
#line 228 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = enotes_app;
#line 228 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp1_ = _tmp0_->state;
#line 228 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp2_ = enotes_application_state_get_opened_page (_tmp1_);
#line 228 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp3_ = _tmp2_;
#line 228 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp4_ = self->priv->page_title;
#line 228 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp5_ = enotes_button_entry_get_text (_tmp4_);
#line 228 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp6_ = _tmp5_;
#line 228 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 228 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_free0 (_tmp3_->name);
#line 228 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp3_->name = _tmp7_;
#line 229 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp8_ = enotes_app;
#line 229 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp9_ = _tmp8_->state;
#line 229 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	enotes_application_state_save_opened_page (_tmp9_);
#line 2046 "PageInfoEditor.c"
}

static void
__enotes_page_info_editor___lambda98__enotes_button_entry_activated (ENotesButtonEntry* _sender,
                                                                     gpointer self)
{
#line 227 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_enotes_page_info_editor___lambda98_ ((ENotesPageInfoEditor*) self);
#line 2055 "PageInfoEditor.c"
}

static void
_enotes_page_info_editor___lambda99_ (ENotesPageInfoEditor* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	ENotesPage* _tmp2_;
	ENotesPage* _tmp3_;
#line 233 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = enotes_app;
#line 233 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp1_ = _tmp0_->state;
#line 233 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp2_ = enotes_application_state_get_opened_page (_tmp1_);
#line 233 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp3_ = _tmp2_;
#line 233 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	enotes_page_info_editor_set_page (self, _tmp3_);
#line 2075 "PageInfoEditor.c"
}

static void
__enotes_page_info_editor___lambda99__enotes_application_state_update_page_title (ENotesApplicationState* _sender,
                                                                                  gpointer self)
{
#line 232 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_enotes_page_info_editor___lambda99_ ((ENotesPageInfoEditor*) self);
#line 2084 "PageInfoEditor.c"
}

static void
_enotes_page_info_editor___lambda100_ (ENotesPageInfoEditor* self)
{
	ENotesApplication* _tmp0_;
	ENotesApplicationState* _tmp1_;
	ENotesNotebook* _tmp2_;
	ENotesNotebook* _tmp3_;
#line 237 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = enotes_app;
#line 237 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp1_ = _tmp0_->state;
#line 237 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp2_ = enotes_application_state_get_opened_page_notebook (_tmp1_);
#line 237 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp3_ = _tmp2_;
#line 237 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	enotes_page_info_editor_set_notebook (self, _tmp3_);
#line 2104 "PageInfoEditor.c"
}

static void
__enotes_page_info_editor___lambda100__enotes_application_state_opened_notebook_updated (ENotesApplicationState* _sender,
                                                                                         gpointer self)
{
#line 236 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_enotes_page_info_editor___lambda100_ ((ENotesPageInfoEditor*) self);
#line 2113 "PageInfoEditor.c"
}

static GObject *
enotes_page_info_editor_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ENotesPageInfoEditor * self;
	GtkGrid* _tmp0_;
	GtkGrid* _tmp1_;
	GtkGrid* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkGrid* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkGrid* button_grid = NULL;
	GtkGrid* _tmp6_;
	GtkGrid* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkButton* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkCssProvider* _tmp14_;
	GtkLabel* _tmp15_;
	GtkStyleContext* _tmp16_;
	GtkCssProvider* _tmp17_;
	GtkGrid* _tmp18_;
	GtkImage* _tmp19_;
	GtkImage* _tmp20_;
	GtkGrid* _tmp21_;
	GtkLabel* _tmp22_;
	GtkButton* _tmp23_;
	GtkGrid* _tmp24_;
	GtkSeparator* mid_separator = NULL;
	GtkSeparator* _tmp25_;
	GtkSeparator* _tmp26_;
	GtkLabel* _tmp27_;
	GtkLabel* _tmp28_;
	GtkLabel* _tmp29_;
	GtkLabel* _tmp30_;
	GtkStyleContext* _tmp31_;
	GtkLabel* _tmp32_;
	GtkLabel* _tmp33_;
	GtkLabel* _tmp34_;
	GtkLabel* _tmp35_;
	GtkLabel* _tmp36_;
	GtkStyleContext* _tmp37_;
	GtkLabel* _tmp38_;
	GtkSeparator* bottom_separator = NULL;
	GtkSeparator* _tmp39_;
	GtkSeparator* _tmp40_;
	ENotesButtonEntry* _tmp41_;
	GtkButton* link_to_page_button = NULL;
	GtkButton* _tmp42_;
	GtkButton* _tmp43_;
	GtkButton* _tmp44_;
	GtkButton* _tmp45_;
	GtkBox* bottom_box = NULL;
	GtkBox* _tmp46_;
	GtkBox* _tmp47_;
	ENotesButtonEntry* _tmp48_;
	GtkBox* _tmp49_;
	GtkLabel* _tmp50_;
	GtkBox* _tmp51_;
	GtkLabel* _tmp52_;
	GtkBox* _tmp53_;
	GtkButton* _tmp54_;
	ENotesPageInfoEditorTagsBox* tags_box = NULL;
	ENotesPageInfoEditorTagsBox* _tmp55_;
	GtkGrid* _tmp56_;
	GtkButton* _tmp57_;
	GtkGrid* _tmp58_;
	GtkSeparator* _tmp59_;
	GtkSeparator* _tmp60_;
	GtkGrid* _tmp61_;
	ENotesPageInfoEditorTagsBox* _tmp62_;
	GtkGrid* _tmp63_;
	GtkSeparator* _tmp64_;
	GtkGrid* _tmp65_;
	GtkBox* _tmp66_;
	GtkGrid* _tmp67_;
	GtkSeparator* _tmp68_;
	GtkGrid* _tmp69_;
	ENotesApplication* _tmp70_;
	ENotesApplicationState* _tmp71_;
	ENotesApplication* _tmp72_;
	ENotesApplicationState* _tmp73_;
	GtkToggleButton* _tmp74_;
	GtkToggleButton* _tmp75_;
	GtkStyleContext* _tmp76_;
	GtkToggleButton* _tmp77_;
	GtkStyleContext* _tmp78_;
	GtkToggleButton* _tmp79_;
	ENotesApplication* _tmp80_;
	gchar** _tmp81_;
	gchar** _tmp82_;
	gchar** _tmp83_;
	gint _tmp83__length1;
	gchar* _tmp84_;
	gchar* _tmp85_;
	GtkToggleButton* _tmp86_;
	GtkImage* icon = NULL;
	GtkImage* _tmp87_;
	GtkImage* _tmp88_;
	GtkImage* _tmp89_;
	GtkToggleButton* _tmp90_;
	GtkImage* _tmp91_;
	ENotesApplication* _tmp92_;
	ENotesApplicationState* _tmp93_;
	GtkToggleButton* _tmp94_;
	GtkButton* _tmp95_;
	GtkButton* _tmp96_;
	ENotesButtonEntry* _tmp97_;
	ENotesApplication* _tmp98_;
	ENotesApplicationState* _tmp99_;
	ENotesApplication* _tmp100_;
	ENotesApplicationState* _tmp101_;
#line 116 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	parent_class = G_OBJECT_CLASS (enotes_page_info_editor_parent_class);
#line 116 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 116 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_PAGE_INFO_EDITOR, ENotesPageInfoEditor);
#line 117 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
#line 117 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp0_);
#line 117 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->grid);
#line 117 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self->priv->grid = _tmp0_;
#line 118 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp1_ = self->priv->grid;
#line 118 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_grid_set_column_spacing (_tmp1_, 16);
#line 119 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp2_ = self->priv->grid;
#line 119 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
#line 119 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_style_context_add_class (_tmp3_, "inline-toolbar");
#line 120 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp4_ = self->priv->grid;
#line 120 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
#line 120 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_style_context_add_class (_tmp5_, "toolbar");
#line 122 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp6_ = (GtkGrid*) gtk_grid_new ();
#line 122 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp6_);
#line 122 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	button_grid = _tmp6_;
#line 123 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp7_ = button_grid;
#line 123 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp7_, GTK_ORIENTATION_HORIZONTAL);
#line 125 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp8_ = (GtkButton*) gtk_button_new ();
#line 125 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp8_);
#line 125 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->current_notebook_button);
#line 125 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self->priv->current_notebook_button = _tmp8_;
#line 126 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp9_ = self->priv->current_notebook_button;
#line 126 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) _tmp9_);
#line 126 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_style_context_add_class (_tmp10_, "flat");
#line 127 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp11_ = self->priv->current_notebook_button;
#line 127 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp11_, _ ("Move page…"));
#line 129 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp12_ = (GtkLabel*) gtk_label_new ("");
#line 129 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp12_);
#line 129 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->current_notebook);
#line 129 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self->priv->current_notebook = _tmp12_;
#line 130 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp13_ = self->priv->current_notebook;
#line 130 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_label_set_use_markup (_tmp13_, TRUE);
#line 132 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp14_ = gtk_css_provider_new ();
#line 132 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->notebook_css_provider);
#line 132 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self->priv->notebook_css_provider = _tmp14_;
#line 133 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp15_ = self->priv->current_notebook;
#line 133 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) _tmp15_);
#line 133 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp17_ = self->priv->notebook_css_provider;
#line 133 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_style_context_add_provider (_tmp16_, (GtkStyleProvider*) _tmp17_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 135 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp18_ = button_grid;
#line 135 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp19_ = (GtkImage*) gtk_image_new_from_icon_name ("notebook-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 135 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp19_);
#line 135 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp20_ = _tmp19_;
#line 135 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) _tmp20_);
#line 135 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (_tmp20_);
#line 136 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp21_ = button_grid;
#line 136 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp22_ = self->priv->current_notebook;
#line 136 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
#line 138 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp23_ = self->priv->current_notebook_button;
#line 138 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp24_ = button_grid;
#line 138 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
#line 140 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp25_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
#line 140 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp25_);
#line 140 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	mid_separator = _tmp25_;
#line 141 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp26_ = mid_separator;
#line 141 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp26_, TRUE);
#line 143 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp27_ = (GtkLabel*) gtk_label_new ("");
#line 143 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp27_);
#line 143 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->created_date_label);
#line 143 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self->priv->created_date_label = _tmp27_;
#line 144 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp28_ = self->priv->created_date_label;
#line 144 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp28_, GTK_ALIGN_START);
#line 145 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp29_ = self->priv->created_date_label;
#line 145 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_label_set_use_markup (_tmp29_, TRUE);
#line 146 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp30_ = self->priv->created_date_label;
#line 146 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp31_ = gtk_widget_get_style_context ((GtkWidget*) _tmp30_);
#line 146 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_style_context_add_class (_tmp31_, "h4");
#line 148 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp32_ = (GtkLabel*) gtk_label_new ("");
#line 148 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp32_);
#line 148 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->updated_date_label);
#line 148 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self->priv->updated_date_label = _tmp32_;
#line 149 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp33_ = self->priv->updated_date_label;
#line 149 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp33_, GTK_ALIGN_START);
#line 150 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp34_ = self->priv->updated_date_label;
#line 150 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_label_set_use_markup (_tmp34_, TRUE);
#line 151 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp35_ = self->priv->updated_date_label;
#line 151 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp35_, TRUE);
#line 152 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp36_ = self->priv->updated_date_label;
#line 152 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp37_ = gtk_widget_get_style_context ((GtkWidget*) _tmp36_);
#line 152 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_style_context_add_class (_tmp37_, "h4");
#line 153 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp38_ = self->priv->updated_date_label;
#line 153 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_set_margin_start ((GtkWidget*) _tmp38_, 8);
#line 155 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp39_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
#line 155 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp39_);
#line 155 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	bottom_separator = _tmp39_;
#line 156 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp40_ = bottom_separator;
#line 156 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp40_, TRUE);
#line 158 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp41_ = enotes_button_entry_new_for_page_title ();
#line 158 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp41_);
#line 158 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->page_title);
#line 158 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self->priv->page_title = _tmp41_;
#line 160 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp42_ = (GtkButton*) gtk_button_new_from_icon_name ("insert-link-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 160 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp42_);
#line 160 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	link_to_page_button = _tmp42_;
#line 161 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp43_ = link_to_page_button;
#line 161 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp43_, GTK_ALIGN_END);
#line 162 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp44_ = link_to_page_button;
#line 162 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_set_margin_end ((GtkWidget*) _tmp44_, 6);
#line 163 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp45_ = link_to_page_button;
#line 163 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp45_, _ ("Copy link to page to clipboard"));
#line 165 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp46_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 16);
#line 165 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp46_);
#line 165 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	bottom_box = _tmp46_;
#line 166 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp47_ = bottom_box;
#line 166 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp48_ = self->priv->page_title;
#line 166 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_container_add ((GtkContainer*) _tmp47_, (GtkWidget*) _tmp48_);
#line 167 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp49_ = bottom_box;
#line 167 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp50_ = self->priv->created_date_label;
#line 167 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_container_add ((GtkContainer*) _tmp49_, (GtkWidget*) _tmp50_);
#line 168 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp51_ = bottom_box;
#line 168 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp52_ = self->priv->updated_date_label;
#line 168 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_container_add ((GtkContainer*) _tmp51_, (GtkWidget*) _tmp52_);
#line 169 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp53_ = bottom_box;
#line 169 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp54_ = link_to_page_button;
#line 169 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_container_add ((GtkContainer*) _tmp53_, (GtkWidget*) _tmp54_);
#line 171 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp55_ = enotes_page_info_editor_tags_box_new ();
#line 171 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp55_);
#line 171 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	tags_box = _tmp55_;
#line 173 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp56_ = self->priv->grid;
#line 173 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp57_ = self->priv->current_notebook_button;
#line 173 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_grid_attach (_tmp56_, (GtkWidget*) _tmp57_, 0, 0, 1, 1);
#line 174 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp58_ = self->priv->grid;
#line 174 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp59_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_VERTICAL);
#line 174 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp59_);
#line 174 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp60_ = _tmp59_;
#line 174 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_grid_attach (_tmp58_, (GtkWidget*) _tmp60_, 1, 0, 1, 1);
#line 174 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (_tmp60_);
#line 175 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp61_ = self->priv->grid;
#line 175 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp62_ = tags_box;
#line 175 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_grid_attach (_tmp61_, (GtkWidget*) _tmp62_, 2, 0, 1, 1);
#line 176 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp63_ = self->priv->grid;
#line 176 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp64_ = mid_separator;
#line 176 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_grid_attach (_tmp63_, (GtkWidget*) _tmp64_, 0, 1, 3, 1);
#line 177 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp65_ = self->priv->grid;
#line 177 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp66_ = bottom_box;
#line 177 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_grid_attach (_tmp65_, (GtkWidget*) _tmp66_, 0, 2, 3, 1);
#line 178 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp67_ = self->priv->grid;
#line 178 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp68_ = bottom_separator;
#line 178 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_grid_attach (_tmp67_, (GtkWidget*) _tmp68_, 0, 3, 3, 1);
#line 180 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_show_all ((GtkWidget*) self);
#line 182 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp69_ = self->priv->grid;
#line 182 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp69_);
#line 184 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp70_ = enotes_app;
#line 184 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp71_ = _tmp70_->state;
#line 184 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_signal_connect_object ((GObject*) _tmp71_, "notify::opened-page", (GCallback) __enotes_page_info_editor___lambda92__g_object_notify, self, 0);
#line 188 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp72_ = enotes_app;
#line 188 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp73_ = _tmp72_->state;
#line 188 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_signal_connect_object ((GObject*) _tmp73_, "notify::opened-page-notebook", (GCallback) __enotes_page_info_editor___lambda93__g_object_notify, self, 0);
#line 192 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp74_ = (GtkToggleButton*) gtk_toggle_button_new ();
#line 192 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp74_);
#line 192 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->toggle_button);
#line 192 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self->priv->toggle_button = _tmp74_;
#line 193 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp75_ = self->priv->toggle_button;
#line 193 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp76_ = gtk_widget_get_style_context ((GtkWidget*) _tmp75_);
#line 193 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_style_context_add_class (_tmp76_, "flat");
#line 194 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp77_ = self->priv->toggle_button;
#line 194 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp78_ = gtk_widget_get_style_context ((GtkWidget*) _tmp77_);
#line 194 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_style_context_add_class (_tmp78_, "circular");
#line 195 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp79_ = self->priv->toggle_button;
#line 195 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp80_ = enotes_app;
#line 195 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp82_ = _tmp81_ = gtk_application_get_accels_for_action ((GtkApplication*) _tmp80_, "win.page-info-action");
#line 195 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp83_ = _tmp82_;
#line 195 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp83__length1 = _vala_array_length (_tmp81_);
#line 195 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp84_ = granite_markup_accel_tooltip (_tmp83_, (gint) _vala_array_length (_tmp81_), _ ("Toggle page information"));
#line 195 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp85_ = _tmp84_;
#line 195 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp79_, _tmp85_);
#line 195 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_free0 (_tmp85_);
#line 195 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp83_ = (_vala_array_free (_tmp83_, _tmp83__length1, (GDestroyNotify) g_free), NULL);
#line 196 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp86_ = self->priv->toggle_button;
#line 196 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_set_can_focus ((GtkWidget*) _tmp86_, FALSE);
#line 198 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp87_ = (GtkImage*) gtk_image_new_from_icon_name ("view-more-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 198 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_object_ref_sink (_tmp87_);
#line 198 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	icon = _tmp87_;
#line 199 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp88_ = icon;
#line 199 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_set_margin_start ((GtkWidget*) _tmp88_, 3);
#line 200 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp89_ = icon;
#line 200 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_widget_set_margin_end ((GtkWidget*) _tmp89_, 3);
#line 202 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp90_ = self->priv->toggle_button;
#line 202 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp91_ = icon;
#line 202 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	gtk_container_add ((GtkContainer*) _tmp90_, (GtkWidget*) _tmp91_);
#line 204 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp92_ = enotes_app;
#line 204 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp93_ = _tmp92_->state;
#line 204 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_signal_connect_object ((GObject*) _tmp93_, "notify::show-page-info", (GCallback) __enotes_page_info_editor___lambda94__g_object_notify, self, 0);
#line 211 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp94_ = self->priv->toggle_button;
#line 211 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_signal_connect_object (_tmp94_, "toggled", (GCallback) __enotes_page_info_editor___lambda95__gtk_toggle_button_toggled, self, 0);
#line 215 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp95_ = self->priv->current_notebook_button;
#line 215 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_signal_connect_object (_tmp95_, "clicked", (GCallback) __enotes_page_info_editor___lambda96__gtk_button_clicked, self, 0);
#line 219 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp96_ = link_to_page_button;
#line 219 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_signal_connect_object (_tmp96_, "clicked", (GCallback) __enotes_page_info_editor___lambda97__gtk_button_clicked, self, 0);
#line 227 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp97_ = self->priv->page_title;
#line 227 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_signal_connect_object (_tmp97_, "activated", (GCallback) __enotes_page_info_editor___lambda98__enotes_button_entry_activated, self, 0);
#line 232 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp98_ = enotes_app;
#line 232 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp99_ = _tmp98_->state;
#line 232 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_signal_connect_object (_tmp99_, "update-page-title", (GCallback) __enotes_page_info_editor___lambda99__enotes_application_state_update_page_title, self, 0);
#line 236 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp100_ = enotes_app;
#line 236 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_tmp101_ = _tmp100_->state;
#line 236 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_signal_connect_object (_tmp101_, "opened-notebook-updated", (GCallback) __enotes_page_info_editor___lambda100__enotes_application_state_opened_notebook_updated, self, 0);
#line 241 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	enotes_page_info_editor_set_notebook (self, NULL);
#line 116 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (icon);
#line 116 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (tags_box);
#line 116 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (bottom_box);
#line 116 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (link_to_page_button);
#line 116 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (bottom_separator);
#line 116 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (mid_separator);
#line 116 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (button_grid);
#line 116 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	return obj;
#line 2652 "PageInfoEditor.c"
}

static void
enotes_page_info_editor_class_init (ENotesPageInfoEditorClass * klass,
                                    gpointer klass_data)
{
#line 22 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	enotes_page_info_editor_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	g_type_class_adjust_private_offset (klass, &ENotesPageInfoEditor_private_offset);
#line 22 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_enotes_page_info_editor_get_property;
#line 22 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_enotes_page_info_editor_set_property;
#line 22 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	G_OBJECT_CLASS (klass)->constructor = enotes_page_info_editor_constructor;
#line 22 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	G_OBJECT_CLASS (klass)->finalize = enotes_page_info_editor_finalize;
#line 2671 "PageInfoEditor.c"
}

static void
enotes_page_info_editor_instance_init (ENotesPageInfoEditor * self,
                                       gpointer klass)
{
#line 22 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self->priv = enotes_page_info_editor_get_instance_private (self);
#line 2680 "PageInfoEditor.c"
}

static void
enotes_page_info_editor_finalize (GObject * obj)
{
	ENotesPageInfoEditor * self;
#line 22 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_PAGE_INFO_EDITOR, ENotesPageInfoEditor);
#line 24 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->notebook_css_provider);
#line 25 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->current_notebook_button);
#line 26 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->current_notebook);
#line 27 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->created_date_label);
#line 28 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->updated_date_label);
#line 29 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->grid);
#line 31 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->page_title);
#line 33 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->toggle_button);
#line 35 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->_page);
#line 82 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	_g_object_unref0 (self->priv->_notebook);
#line 22 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	G_OBJECT_CLASS (enotes_page_info_editor_parent_class)->finalize (obj);
#line 2711 "PageInfoEditor.c"
}

static GType
enotes_page_info_editor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesPageInfoEditorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_page_info_editor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesPageInfoEditor), 0, (GInstanceInitFunc) enotes_page_info_editor_instance_init, NULL };
	GType enotes_page_info_editor_type_id;
	enotes_page_info_editor_type_id = g_type_register_static (gtk_revealer_get_type (), "ENotesPageInfoEditor", &g_define_type_info, 0);
	ENotesPageInfoEditor_private_offset = g_type_add_instance_private (enotes_page_info_editor_type_id, sizeof (ENotesPageInfoEditorPrivate));
	return enotes_page_info_editor_type_id;
}

GType
enotes_page_info_editor_get_type (void)
{
	static volatile gsize enotes_page_info_editor_type_id__once = 0;
	if (g_once_init_enter (&enotes_page_info_editor_type_id__once)) {
		GType enotes_page_info_editor_type_id;
		enotes_page_info_editor_type_id = enotes_page_info_editor_get_type_once ();
		g_once_init_leave (&enotes_page_info_editor_type_id__once, enotes_page_info_editor_type_id);
	}
	return enotes_page_info_editor_type_id__once;
}

static void
_vala_enotes_page_info_editor_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	ENotesPageInfoEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ENOTES_TYPE_PAGE_INFO_EDITOR, ENotesPageInfoEditor);
#line 22 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	switch (property_id) {
#line 2746 "PageInfoEditor.c"
		default:
#line 22 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		break;
#line 2752 "PageInfoEditor.c"
	}
}

static void
_vala_enotes_page_info_editor_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	ENotesPageInfoEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ENOTES_TYPE_PAGE_INFO_EDITOR, ENotesPageInfoEditor);
#line 22 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
	switch (property_id) {
#line 2766 "PageInfoEditor.c"
		default:
#line 22 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Notes-up-2.0.6/src/Widgets/PageInfoEditor.vala"
		break;
#line 2772 "PageInfoEditor.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

