/* Trash.c generated by valac 0.56.12, the Vala compiler
 * generated from Trash.vala, do not modify */

/*
* Copyright (c) 2016 Felipe Escoto (https://github.com/Philip-Scott/Notes-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ENOTES_TYPE_TRASH (enotes_trash_get_type ())
#define ENOTES_TRASH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_TRASH, ENotesTrash))
#define ENOTES_TRASH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_TRASH, ENotesTrashClass))
#define ENOTES_IS_TRASH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_TRASH))
#define ENOTES_IS_TRASH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_TRASH))
#define ENOTES_TRASH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_TRASH, ENotesTrashClass))

typedef struct _ENotesTrash ENotesTrash;
typedef struct _ENotesTrashClass ENotesTrashClass;
typedef struct _ENotesTrashPrivate ENotesTrashPrivate;
enum  {
	ENOTES_TRASH_0_PROPERTY,
	ENOTES_TRASH_NUM_PROPERTIES
};
static GParamSpec* enotes_trash_properties[ENOTES_TRASH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ENOTES_TYPE_PAGE (enotes_page_get_type ())
#define ENOTES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGE, ENotesPage))
#define ENOTES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGE, ENotesPageClass))
#define ENOTES_IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGE))
#define ENOTES_IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGE))
#define ENOTES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGE, ENotesPageClass))

typedef struct _ENotesPage ENotesPage;
typedef struct _ENotesPageClass ENotesPageClass;
typedef struct _ENotesPagePrivate ENotesPagePrivate;

#define ENOTES_TYPE_NOTEBOOK (enotes_notebook_get_type ())
#define ENOTES_NOTEBOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_NOTEBOOK, ENotesNotebook))
#define ENOTES_NOTEBOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_NOTEBOOK, ENotesNotebookClass))
#define ENOTES_IS_NOTEBOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_NOTEBOOK))
#define ENOTES_IS_NOTEBOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_NOTEBOOK))
#define ENOTES_NOTEBOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_NOTEBOOK, ENotesNotebookClass))

typedef struct _ENotesNotebook ENotesNotebook;
typedef struct _ENotesNotebookClass ENotesNotebookClass;
typedef struct _ENotesNotebookPrivate ENotesNotebookPrivate;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define ENOTES_TYPE_NOTEBOOK_TABLE (enotes_notebook_table_get_type ())
#define ENOTES_NOTEBOOK_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_NOTEBOOK_TABLE, ENotesNotebookTable))
#define ENOTES_NOTEBOOK_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_NOTEBOOK_TABLE, ENotesNotebookTableClass))
#define ENOTES_IS_NOTEBOOK_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_NOTEBOOK_TABLE))
#define ENOTES_IS_NOTEBOOK_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_NOTEBOOK_TABLE))
#define ENOTES_NOTEBOOK_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_NOTEBOOK_TABLE, ENotesNotebookTableClass))

typedef struct _ENotesNotebookTable ENotesNotebookTable;
typedef struct _ENotesNotebookTableClass ENotesNotebookTableClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))

#define ENOTES_TYPE_PAGE_TABLE (enotes_page_table_get_type ())
#define ENOTES_PAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGE_TABLE, ENotesPageTable))
#define ENOTES_PAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGE_TABLE, ENotesPageTableClass))
#define ENOTES_IS_PAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGE_TABLE))
#define ENOTES_IS_PAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGE_TABLE))
#define ENOTES_PAGE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGE_TABLE, ENotesPageTableClass))

typedef struct _ENotesPageTable ENotesPageTable;
typedef struct _ENotesPageTableClass ENotesPageTableClass;
enum  {
	ENOTES_TRASH_PAGE_ADDED_SIGNAL,
	ENOTES_TRASH_PAGE_REMOVED_SIGNAL,
	ENOTES_TRASH_NOTEBOOK_ADDED_SIGNAL,
	ENOTES_TRASH_NOTEBOOK_REMOVED_SIGNAL,
	ENOTES_TRASH_NUM_SIGNALS
};
static guint enotes_trash_signals[ENOTES_TRASH_NUM_SIGNALS] = {0};

struct _ENotesTrash {
	GObject parent_instance;
	ENotesTrashPrivate * priv;
};

struct _ENotesTrashClass {
	GObjectClass parent_class;
};

struct _ENotesTrashPrivate {
	GeeHashSet* pages;
	GeeHashSet* notebooks;
};

struct _ENotesPage {
	GObject parent_instance;
	ENotesPagePrivate * priv;
	gint64 id;
	gint64 notebook_id;
	gchar* name;
	gchar* data;
	gchar* subtitle;
	gchar* html_cache;
	gint64 creation_date;
	gint64 modification_date;
	gboolean new_page;
	gboolean cache_changed;
	gchar* full_path;
};

struct _ENotesPageClass {
	GObjectClass parent_class;
};

struct _ENotesNotebook {
	GObject parent_instance;
	ENotesNotebookPrivate * priv;
	gint64 id;
	gint64* parent_id;
	GdkRGBA rgb;
	gchar* name;
	gchar* css;
	gchar* stylesheet;
};

struct _ENotesNotebookClass {
	GObjectClass parent_class;
};

static gint ENotesTrash_private_offset;
static gpointer enotes_trash_parent_class = NULL;
static ENotesTrash* enotes_trash_instance;
static ENotesTrash* enotes_trash_instance = NULL;

VALA_EXTERN GType enotes_trash_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesTrash, g_object_unref)
static ENotesTrash* enotes_trash_new (void);
static ENotesTrash* enotes_trash_construct (GType object_type);
VALA_EXTERN ENotesTrash* enotes_trash_get_instance (void);
VALA_EXTERN GType enotes_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPage, g_object_unref)
VALA_EXTERN void enotes_trash_trash_page (ENotesTrash* self,
                              ENotesPage* page);
VALA_EXTERN gboolean enotes_trash_is_page_trashed (ENotesTrash* self,
                                       ENotesPage* to_check);
VALA_EXTERN GType enotes_notebook_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesNotebook, g_object_unref)
VALA_EXTERN void enotes_trash_trash_notebook (ENotesTrash* self,
                                  ENotesNotebook* notebook);
VALA_EXTERN gboolean enotes_trash_is_notebook_trashed (ENotesTrash* self,
                                           ENotesNotebook* to_check);
VALA_EXTERN void enotes_trash_restore_page (ENotesTrash* self,
                                ENotesPage* page);
VALA_EXTERN void enotes_trash_restore_notebook (ENotesTrash* self,
                                    ENotesNotebook* notebook);
VALA_EXTERN void enotes_trash_clear_files (ENotesTrash* self);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType enotes_notebook_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesNotebookTable, database_table_unref)
VALA_EXTERN ENotesNotebookTable* enotes_notebook_table_get_instance (void);
VALA_EXTERN void enotes_notebook_table_delete_notebook (ENotesNotebookTable* self,
                                            gint64 id);
VALA_EXTERN GType enotes_page_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPageTable, database_table_unref)
VALA_EXTERN ENotesPageTable* enotes_page_table_get_instance (void);
VALA_EXTERN void enotes_page_table_delete_page (ENotesPageTable* self,
                                    gint64 id);
VALA_EXTERN void enotes_trash_reset_instance (void);
static void enotes_trash_finalize (GObject * obj);
static GType enotes_trash_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
enotes_trash_get_instance_private (ENotesTrash* self)
{
	return G_STRUCT_MEMBER_P (self, ENotesTrash_private_offset);
}

static ENotesTrash*
enotes_trash_construct (GType object_type)
{
	ENotesTrash * self = NULL;
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
#line 33 "../Notes-up-2.0.6/src/Services/Trash.vala"
	self = (ENotesTrash*) g_object_new (object_type, NULL);
#line 34 "../Notes-up-2.0.6/src/Services/Trash.vala"
	_tmp0_ = gee_hash_set_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 34 "../Notes-up-2.0.6/src/Services/Trash.vala"
	_g_object_unref0 (self->priv->pages);
#line 34 "../Notes-up-2.0.6/src/Services/Trash.vala"
	self->priv->pages = _tmp0_;
#line 35 "../Notes-up-2.0.6/src/Services/Trash.vala"
	_tmp1_ = gee_hash_set_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 35 "../Notes-up-2.0.6/src/Services/Trash.vala"
	_g_object_unref0 (self->priv->notebooks);
#line 35 "../Notes-up-2.0.6/src/Services/Trash.vala"
	self->priv->notebooks = _tmp1_;
#line 33 "../Notes-up-2.0.6/src/Services/Trash.vala"
	return self;
#line 255 "Trash.c"
}

static ENotesTrash*
enotes_trash_new (void)
{
#line 33 "../Notes-up-2.0.6/src/Services/Trash.vala"
	return enotes_trash_construct (ENOTES_TYPE_TRASH);
#line 263 "Trash.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 43 "../Notes-up-2.0.6/src/Services/Trash.vala"
	return self ? g_object_ref (self) : NULL;
#line 271 "Trash.c"
}

ENotesTrash*
enotes_trash_get_instance (void)
{
	ENotesTrash* _tmp0_;
	ENotesTrash* _tmp2_;
	ENotesTrash* _tmp3_;
	ENotesTrash* result;
#line 39 "../Notes-up-2.0.6/src/Services/Trash.vala"
	_tmp0_ = enotes_trash_instance;
#line 39 "../Notes-up-2.0.6/src/Services/Trash.vala"
	if (_tmp0_ == NULL) {
#line 285 "Trash.c"
		ENotesTrash* _tmp1_;
#line 40 "../Notes-up-2.0.6/src/Services/Trash.vala"
		_tmp1_ = enotes_trash_new ();
#line 40 "../Notes-up-2.0.6/src/Services/Trash.vala"
		_g_object_unref0 (enotes_trash_instance);
#line 40 "../Notes-up-2.0.6/src/Services/Trash.vala"
		enotes_trash_instance = _tmp1_;
#line 293 "Trash.c"
	}
#line 43 "../Notes-up-2.0.6/src/Services/Trash.vala"
	_tmp2_ = enotes_trash_instance;
#line 43 "../Notes-up-2.0.6/src/Services/Trash.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 43 "../Notes-up-2.0.6/src/Services/Trash.vala"
	result = _tmp3_;
#line 43 "../Notes-up-2.0.6/src/Services/Trash.vala"
	return result;
#line 303 "Trash.c"
}

void
enotes_trash_trash_page (ENotesTrash* self,
                         ENotesPage* page)
{
#line 46 "../Notes-up-2.0.6/src/Services/Trash.vala"
	g_return_if_fail (self != NULL);
#line 46 "../Notes-up-2.0.6/src/Services/Trash.vala"
	g_return_if_fail (page != NULL);
#line 47 "../Notes-up-2.0.6/src/Services/Trash.vala"
	if (!enotes_trash_is_page_trashed (self, page)) {
#line 316 "Trash.c"
		GeeHashSet* _tmp0_;
#line 48 "../Notes-up-2.0.6/src/Services/Trash.vala"
		_tmp0_ = self->priv->pages;
#line 48 "../Notes-up-2.0.6/src/Services/Trash.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, (gpointer) ((gintptr) page->id));
#line 49 "../Notes-up-2.0.6/src/Services/Trash.vala"
		g_signal_emit (self, enotes_trash_signals[ENOTES_TRASH_PAGE_ADDED_SIGNAL], 0, page);
#line 324 "Trash.c"
	}
}

void
enotes_trash_trash_notebook (ENotesTrash* self,
                             ENotesNotebook* notebook)
{
#line 53 "../Notes-up-2.0.6/src/Services/Trash.vala"
	g_return_if_fail (self != NULL);
#line 53 "../Notes-up-2.0.6/src/Services/Trash.vala"
	g_return_if_fail (notebook != NULL);
#line 54 "../Notes-up-2.0.6/src/Services/Trash.vala"
	if (!enotes_trash_is_notebook_trashed (self, notebook)) {
#line 338 "Trash.c"
		GeeHashSet* _tmp0_;
#line 55 "../Notes-up-2.0.6/src/Services/Trash.vala"
		_tmp0_ = self->priv->notebooks;
#line 55 "../Notes-up-2.0.6/src/Services/Trash.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, (gpointer) ((gintptr) notebook->id));
#line 56 "../Notes-up-2.0.6/src/Services/Trash.vala"
		g_signal_emit (self, enotes_trash_signals[ENOTES_TRASH_NOTEBOOK_ADDED_SIGNAL], 0, notebook);
#line 346 "Trash.c"
	}
}

void
enotes_trash_restore_page (ENotesTrash* self,
                           ENotesPage* page)
{
	GeeHashSet* _tmp0_;
#line 60 "../Notes-up-2.0.6/src/Services/Trash.vala"
	g_return_if_fail (self != NULL);
#line 60 "../Notes-up-2.0.6/src/Services/Trash.vala"
	g_return_if_fail (page != NULL);
#line 61 "../Notes-up-2.0.6/src/Services/Trash.vala"
	_tmp0_ = self->priv->pages;
#line 61 "../Notes-up-2.0.6/src/Services/Trash.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, (gpointer) ((gintptr) page->id));
#line 62 "../Notes-up-2.0.6/src/Services/Trash.vala"
	g_signal_emit (self, enotes_trash_signals[ENOTES_TRASH_PAGE_REMOVED_SIGNAL], 0, page);
#line 365 "Trash.c"
}

void
enotes_trash_restore_notebook (ENotesTrash* self,
                               ENotesNotebook* notebook)
{
	GeeHashSet* _tmp0_;
#line 65 "../Notes-up-2.0.6/src/Services/Trash.vala"
	g_return_if_fail (self != NULL);
#line 65 "../Notes-up-2.0.6/src/Services/Trash.vala"
	g_return_if_fail (notebook != NULL);
#line 66 "../Notes-up-2.0.6/src/Services/Trash.vala"
	_tmp0_ = self->priv->notebooks;
#line 66 "../Notes-up-2.0.6/src/Services/Trash.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, (gpointer) ((gintptr) notebook->id));
#line 67 "../Notes-up-2.0.6/src/Services/Trash.vala"
	g_signal_emit (self, enotes_trash_signals[ENOTES_TRASH_NOTEBOOK_REMOVED_SIGNAL], 0, notebook);
#line 383 "Trash.c"
}

gboolean
enotes_trash_is_page_trashed (ENotesTrash* self,
                              ENotesPage* to_check)
{
	GeeHashSet* _tmp0_;
	gboolean result;
#line 70 "../Notes-up-2.0.6/src/Services/Trash.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 70 "../Notes-up-2.0.6/src/Services/Trash.vala"
	g_return_val_if_fail (to_check != NULL, FALSE);
#line 71 "../Notes-up-2.0.6/src/Services/Trash.vala"
	_tmp0_ = self->priv->pages;
#line 71 "../Notes-up-2.0.6/src/Services/Trash.vala"
	result = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, (gpointer) ((gintptr) to_check->id));
#line 71 "../Notes-up-2.0.6/src/Services/Trash.vala"
	return result;
#line 402 "Trash.c"
}

gboolean
enotes_trash_is_notebook_trashed (ENotesTrash* self,
                                  ENotesNotebook* to_check)
{
	GeeHashSet* _tmp0_;
	gboolean result;
#line 74 "../Notes-up-2.0.6/src/Services/Trash.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 74 "../Notes-up-2.0.6/src/Services/Trash.vala"
	g_return_val_if_fail (to_check != NULL, FALSE);
#line 75 "../Notes-up-2.0.6/src/Services/Trash.vala"
	_tmp0_ = self->priv->notebooks;
#line 75 "../Notes-up-2.0.6/src/Services/Trash.vala"
	result = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, (gpointer) ((gintptr) to_check->id));
#line 75 "../Notes-up-2.0.6/src/Services/Trash.vala"
	return result;
#line 421 "Trash.c"
}

void
enotes_trash_clear_files (ENotesTrash* self)
{
#line 78 "../Notes-up-2.0.6/src/Services/Trash.vala"
	g_return_if_fail (self != NULL);
#line 429 "Trash.c"
	{
		GeeIterator* _id_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
#line 79 "../Notes-up-2.0.6/src/Services/Trash.vala"
		_tmp0_ = self->priv->notebooks;
#line 79 "../Notes-up-2.0.6/src/Services/Trash.vala"
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
#line 79 "../Notes-up-2.0.6/src/Services/Trash.vala"
		_id_it = _tmp1_;
#line 79 "../Notes-up-2.0.6/src/Services/Trash.vala"
		while (TRUE) {
#line 442 "Trash.c"
			GeeIterator* _tmp2_;
			gint id = 0;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			ENotesNotebookTable* _tmp5_;
			ENotesNotebookTable* _tmp6_;
#line 79 "../Notes-up-2.0.6/src/Services/Trash.vala"
			_tmp2_ = _id_it;
#line 79 "../Notes-up-2.0.6/src/Services/Trash.vala"
			if (!gee_iterator_next (_tmp2_)) {
#line 79 "../Notes-up-2.0.6/src/Services/Trash.vala"
				break;
#line 455 "Trash.c"
			}
#line 79 "../Notes-up-2.0.6/src/Services/Trash.vala"
			_tmp3_ = _id_it;
#line 79 "../Notes-up-2.0.6/src/Services/Trash.vala"
			_tmp4_ = gee_iterator_get (_tmp3_);
#line 79 "../Notes-up-2.0.6/src/Services/Trash.vala"
			id = (gint) ((gintptr) _tmp4_);
#line 80 "../Notes-up-2.0.6/src/Services/Trash.vala"
			_tmp5_ = enotes_notebook_table_get_instance ();
#line 80 "../Notes-up-2.0.6/src/Services/Trash.vala"
			_tmp6_ = _tmp5_;
#line 80 "../Notes-up-2.0.6/src/Services/Trash.vala"
			enotes_notebook_table_delete_notebook (_tmp6_, (gint64) id);
#line 80 "../Notes-up-2.0.6/src/Services/Trash.vala"
			_database_table_unref0 (_tmp6_);
#line 471 "Trash.c"
		}
#line 79 "../Notes-up-2.0.6/src/Services/Trash.vala"
		_g_object_unref0 (_id_it);
#line 475 "Trash.c"
	}
	{
		GeeIterator* _id_it = NULL;
		GeeHashSet* _tmp7_;
		GeeIterator* _tmp8_;
#line 83 "../Notes-up-2.0.6/src/Services/Trash.vala"
		_tmp7_ = self->priv->pages;
#line 83 "../Notes-up-2.0.6/src/Services/Trash.vala"
		_tmp8_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp7_);
#line 83 "../Notes-up-2.0.6/src/Services/Trash.vala"
		_id_it = _tmp8_;
#line 83 "../Notes-up-2.0.6/src/Services/Trash.vala"
		while (TRUE) {
#line 489 "Trash.c"
			GeeIterator* _tmp9_;
			gint id = 0;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			ENotesPageTable* _tmp12_;
			ENotesPageTable* _tmp13_;
#line 83 "../Notes-up-2.0.6/src/Services/Trash.vala"
			_tmp9_ = _id_it;
#line 83 "../Notes-up-2.0.6/src/Services/Trash.vala"
			if (!gee_iterator_next (_tmp9_)) {
#line 83 "../Notes-up-2.0.6/src/Services/Trash.vala"
				break;
#line 502 "Trash.c"
			}
#line 83 "../Notes-up-2.0.6/src/Services/Trash.vala"
			_tmp10_ = _id_it;
#line 83 "../Notes-up-2.0.6/src/Services/Trash.vala"
			_tmp11_ = gee_iterator_get (_tmp10_);
#line 83 "../Notes-up-2.0.6/src/Services/Trash.vala"
			id = (gint) ((gintptr) _tmp11_);
#line 84 "../Notes-up-2.0.6/src/Services/Trash.vala"
			_tmp12_ = enotes_page_table_get_instance ();
#line 84 "../Notes-up-2.0.6/src/Services/Trash.vala"
			_tmp13_ = _tmp12_;
#line 84 "../Notes-up-2.0.6/src/Services/Trash.vala"
			enotes_page_table_delete_page (_tmp13_, (gint64) id);
#line 84 "../Notes-up-2.0.6/src/Services/Trash.vala"
			_database_table_unref0 (_tmp13_);
#line 518 "Trash.c"
		}
#line 83 "../Notes-up-2.0.6/src/Services/Trash.vala"
		_g_object_unref0 (_id_it);
#line 522 "Trash.c"
	}
}

void
enotes_trash_reset_instance (void)
{
#line 89 "../Notes-up-2.0.6/src/Services/Trash.vala"
	_g_object_unref0 (enotes_trash_instance);
#line 89 "../Notes-up-2.0.6/src/Services/Trash.vala"
	enotes_trash_instance = NULL;
#line 533 "Trash.c"
}

static void
enotes_trash_class_init (ENotesTrashClass * klass,
                         gpointer klass_data)
{
#line 22 "../Notes-up-2.0.6/src/Services/Trash.vala"
	enotes_trash_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Notes-up-2.0.6/src/Services/Trash.vala"
	g_type_class_adjust_private_offset (klass, &ENotesTrash_private_offset);
#line 22 "../Notes-up-2.0.6/src/Services/Trash.vala"
	G_OBJECT_CLASS (klass)->finalize = enotes_trash_finalize;
#line 22 "../Notes-up-2.0.6/src/Services/Trash.vala"
	enotes_trash_signals[ENOTES_TRASH_PAGE_ADDED_SIGNAL] = g_signal_new ("page-added", ENOTES_TYPE_TRASH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, ENOTES_TYPE_PAGE);
#line 22 "../Notes-up-2.0.6/src/Services/Trash.vala"
	enotes_trash_signals[ENOTES_TRASH_PAGE_REMOVED_SIGNAL] = g_signal_new ("page-removed", ENOTES_TYPE_TRASH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, ENOTES_TYPE_PAGE);
#line 22 "../Notes-up-2.0.6/src/Services/Trash.vala"
	enotes_trash_signals[ENOTES_TRASH_NOTEBOOK_ADDED_SIGNAL] = g_signal_new ("notebook-added", ENOTES_TYPE_TRASH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, ENOTES_TYPE_NOTEBOOK);
#line 22 "../Notes-up-2.0.6/src/Services/Trash.vala"
	enotes_trash_signals[ENOTES_TRASH_NOTEBOOK_REMOVED_SIGNAL] = g_signal_new ("notebook-removed", ENOTES_TYPE_TRASH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, ENOTES_TYPE_NOTEBOOK);
#line 554 "Trash.c"
}

static void
enotes_trash_instance_init (ENotesTrash * self,
                            gpointer klass)
{
#line 22 "../Notes-up-2.0.6/src/Services/Trash.vala"
	self->priv = enotes_trash_get_instance_private (self);
#line 563 "Trash.c"
}

static void
enotes_trash_finalize (GObject * obj)
{
	ENotesTrash * self;
#line 22 "../Notes-up-2.0.6/src/Services/Trash.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_TRASH, ENotesTrash);
#line 30 "../Notes-up-2.0.6/src/Services/Trash.vala"
	_g_object_unref0 (self->priv->pages);
#line 31 "../Notes-up-2.0.6/src/Services/Trash.vala"
	_g_object_unref0 (self->priv->notebooks);
#line 22 "../Notes-up-2.0.6/src/Services/Trash.vala"
	G_OBJECT_CLASS (enotes_trash_parent_class)->finalize (obj);
#line 578 "Trash.c"
}

static GType
enotes_trash_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesTrashClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_trash_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesTrash), 0, (GInstanceInitFunc) enotes_trash_instance_init, NULL };
	GType enotes_trash_type_id;
	enotes_trash_type_id = g_type_register_static (G_TYPE_OBJECT, "ENotesTrash", &g_define_type_info, 0);
	ENotesTrash_private_offset = g_type_add_instance_private (enotes_trash_type_id, sizeof (ENotesTrashPrivate));
	return enotes_trash_type_id;
}

GType
enotes_trash_get_type (void)
{
	static volatile gsize enotes_trash_type_id__once = 0;
	if (g_once_init_enter (&enotes_trash_type_id__once)) {
		GType enotes_trash_type_id;
		enotes_trash_type_id = enotes_trash_get_type_once ();
		g_once_init_leave (&enotes_trash_type_id__once, enotes_trash_type_id);
	}
	return enotes_trash_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

