/* Notebook.c generated by valac 0.56.12, the Vala compiler
 * generated from Notebook.vala, do not modify */

/*
* Copyright (c) 2011-2016 Felipe Escoto (https://github.com/Philip-Scott/Notes-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <gee.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ENOTES_TYPE_NOTEBOOK (enotes_notebook_get_type ())
#define ENOTES_NOTEBOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_NOTEBOOK, ENotesNotebook))
#define ENOTES_NOTEBOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_NOTEBOOK, ENotesNotebookClass))
#define ENOTES_IS_NOTEBOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_NOTEBOOK))
#define ENOTES_IS_NOTEBOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_NOTEBOOK))
#define ENOTES_NOTEBOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_NOTEBOOK, ENotesNotebookClass))

typedef struct _ENotesNotebook ENotesNotebook;
typedef struct _ENotesNotebookClass ENotesNotebookClass;
typedef struct _ENotesNotebookPrivate ENotesNotebookPrivate;
enum  {
	ENOTES_NOTEBOOK_0_PROPERTY,
	ENOTES_NOTEBOOK_NUM_PROPERTIES
};
static GParamSpec* enotes_notebook_properties[ENOTES_NOTEBOOK_NUM_PROPERTIES];
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
enum  {
	ENOTES_NOTEBOOK_DESTROY_SIGNAL,
	ENOTES_NOTEBOOK_NUM_SIGNALS
};
static guint enotes_notebook_signals[ENOTES_NOTEBOOK_NUM_SIGNALS] = {0};

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define ENOTES_TYPE_NOTEBOOK_TABLE (enotes_notebook_table_get_type ())
#define ENOTES_NOTEBOOK_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_NOTEBOOK_TABLE, ENotesNotebookTable))
#define ENOTES_NOTEBOOK_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_NOTEBOOK_TABLE, ENotesNotebookTableClass))
#define ENOTES_IS_NOTEBOOK_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_NOTEBOOK_TABLE))
#define ENOTES_IS_NOTEBOOK_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_NOTEBOOK_TABLE))
#define ENOTES_NOTEBOOK_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_NOTEBOOK_TABLE, ENotesNotebookTableClass))

typedef struct _ENotesNotebookTable ENotesNotebookTable;
typedef struct _ENotesNotebookTableClass ENotesNotebookTableClass;
typedef struct _ENotesNotebookTablePrivate ENotesNotebookTablePrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ENOTES_TYPE_PAGE_TABLE (enotes_page_table_get_type ())
#define ENOTES_PAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGE_TABLE, ENotesPageTable))
#define ENOTES_PAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGE_TABLE, ENotesPageTableClass))
#define ENOTES_IS_PAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGE_TABLE))
#define ENOTES_IS_PAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGE_TABLE))
#define ENOTES_PAGE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGE_TABLE, ENotesPageTableClass))

typedef struct _ENotesPageTable ENotesPageTable;
typedef struct _ENotesPageTableClass ENotesPageTableClass;

#define ENOTES_TYPE_PAGE (enotes_page_get_type ())
#define ENOTES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGE, ENotesPage))
#define ENOTES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGE, ENotesPageClass))
#define ENOTES_IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGE))
#define ENOTES_IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGE))
#define ENOTES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGE, ENotesPageClass))

typedef struct _ENotesPage ENotesPage;
typedef struct _ENotesPageClass ENotesPageClass;
typedef struct _ENotesPagePrivate ENotesPagePrivate;
enum  {
	ENOTES_NOTEBOOK_TABLE_NOTEBOOK_ADDED_SIGNAL,
	ENOTES_NOTEBOOK_TABLE_NOTEBOOK_CHANGED_SIGNAL,
	ENOTES_NOTEBOOK_TABLE_NUM_SIGNALS
};
static guint enotes_notebook_table_signals[ENOTES_NOTEBOOK_TABLE_NUM_SIGNALS] = {0};

struct _ENotesNotebook {
	GObject parent_instance;
	ENotesNotebookPrivate * priv;
	gint64 id;
	gint64* parent_id;
	GdkRGBA rgb;
	gchar* name;
	gchar* css;
	gchar* stylesheet;
};

struct _ENotesNotebookClass {
	GObjectClass parent_class;
};

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _ENotesNotebookTable {
	DatabaseTable parent_instance;
	ENotesNotebookTablePrivate * priv;
};

struct _ENotesNotebookTableClass {
	DatabaseTableClass parent_class;
};

struct _ENotesPage {
	GObject parent_instance;
	ENotesPagePrivate * priv;
	gint64 id;
	gint64 notebook_id;
	gchar* name;
	gchar* data;
	gchar* subtitle;
	gchar* html_cache;
	gint64 creation_date;
	gint64 modification_date;
	gboolean new_page;
	gboolean cache_changed;
	gchar* full_path;
};

struct _ENotesPageClass {
	GObjectClass parent_class;
};

static gpointer enotes_notebook_parent_class = NULL;
static gpointer enotes_notebook_table_parent_class = NULL;
static ENotesNotebookTable* enotes_notebook_table_instance;
static ENotesNotebookTable* enotes_notebook_table_instance = NULL;

VALA_EXTERN GType enotes_notebook_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesNotebook, g_object_unref)
VALA_EXTERN ENotesNotebook* enotes_notebook_new (void);
VALA_EXTERN ENotesNotebook* enotes_notebook_construct (GType object_type);
static void enotes_notebook_finalize (GObject * obj);
static GType enotes_notebook_get_type_once (void);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType enotes_notebook_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesNotebookTable, database_table_unref)
static ENotesNotebookTable* enotes_notebook_table_new (void);
static ENotesNotebookTable* enotes_notebook_table_construct (GType object_type);
VALA_EXTERN DatabaseTable* database_table_construct (GType object_type);
VALA_EXTERN sqlite3_stmt* database_table_create_stmt (const gchar* data);
VALA_EXTERN void database_table_fatal (const gchar* op,
                           gint res);
VALA_EXTERN void database_table_set_table_name (DatabaseTable* self,
                                    const gchar* table_name);
VALA_EXTERN ENotesNotebookTable* enotes_notebook_table_get_instance (void);
VALA_EXTERN GeeArrayList* enotes_notebook_table_get_notebooks (ENotesNotebookTable* self);
static gint64* _int64_dup (gint64* self);
VALA_EXTERN ENotesNotebook* enotes_notebook_table_load_notebook_data (ENotesNotebookTable* self,
                                                          gint64 notebook_id);
VALA_EXTERN void database_table_bind_int (sqlite3_stmt* stmt,
                              gint column,
                              gint64 data);
VALA_EXTERN void enotes_notebook_table_save_notebook (ENotesNotebookTable* self,
                                          gint64 notebook_id,
                                          const gchar* name,
                                          GdkRGBA* rgb,
                                          const gchar* css,
                                          const gchar* stylesheet);
VALA_EXTERN void database_table_bind_text (sqlite3_stmt* stmt,
                               gint column,
                               const gchar* data);
VALA_EXTERN gint64 enotes_notebook_table_new_notebook (ENotesNotebookTable* self,
                                           gint64 parent,
                                           const gchar* name,
                                           GdkRGBA* rgb,
                                           const gchar* css,
                                           const gchar* stylesheet);
VALA_EXTERN gint64 database_table_last_insert_row (DatabaseTable* self);
VALA_EXTERN GType enotes_page_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPageTable, database_table_unref)
VALA_EXTERN ENotesPageTable* enotes_page_table_get_instance (void);
VALA_EXTERN GType enotes_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPage, g_object_unref)
VALA_EXTERN ENotesPage* enotes_page_table_new_page (ENotesPageTable* self,
                                        gint64 notebook_id);
VALA_EXTERN gchar* enotes_notebook_table_get_stylesheet_from_page (ENotesNotebookTable* self,
                                                       gint64 page_id);
VALA_EXTERN gchar* enotes_notebook_table_get_css_from_page (ENotesNotebookTable* self,
                                                gint64 page_id);
VALA_EXTERN void enotes_notebook_table_move_notebook (ENotesNotebookTable* self,
                                          ENotesNotebook* notebook,
                                          ENotesNotebook* parent_notebook);
VALA_EXTERN void enotes_notebook_table_delete_notebook (ENotesNotebookTable* self,
                                            gint64 id);
VALA_EXTERN GeeArrayList* enotes_page_table_get_pages (ENotesPageTable* self,
                                           gint64 notebook_id);
VALA_EXTERN void enotes_page_table_delete_page (ENotesPageTable* self,
                                    gint64 id);
VALA_EXTERN void enotes_notebook_table_reset_instance (void);
static void enotes_notebook_table_finalize (DatabaseTable * obj);
static GType enotes_notebook_table_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

ENotesNotebook*
enotes_notebook_construct (GType object_type)
{
	ENotesNotebook * self = NULL;
#line 22 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	self = (ENotesNotebook*) g_object_new (object_type, NULL);
#line 22 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	return self;
#line 267 "Notebook.c"
}

ENotesNotebook*
enotes_notebook_new (void)
{
#line 22 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	return enotes_notebook_construct (ENOTES_TYPE_NOTEBOOK);
#line 275 "Notebook.c"
}

static void
enotes_notebook_class_init (ENotesNotebookClass * klass,
                            gpointer klass_data)
{
#line 22 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	enotes_notebook_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	G_OBJECT_CLASS (klass)->finalize = enotes_notebook_finalize;
#line 22 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	enotes_notebook_signals[ENOTES_NOTEBOOK_DESTROY_SIGNAL] = g_signal_new ("destroy", ENOTES_TYPE_NOTEBOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 288 "Notebook.c"
}

static void
enotes_notebook_instance_init (ENotesNotebook * self,
                               gpointer klass)
{
}

static void
enotes_notebook_finalize (GObject * obj)
{
	ENotesNotebook * self;
#line 22 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_NOTEBOOK, ENotesNotebook);
#line 26 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_g_free0 (self->parent_id);
#line 29 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_g_free0 (self->name);
#line 30 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_g_free0 (self->css);
#line 31 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_g_free0 (self->stylesheet);
#line 22 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	G_OBJECT_CLASS (enotes_notebook_parent_class)->finalize (obj);
#line 313 "Notebook.c"
}

static GType
enotes_notebook_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesNotebookClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_notebook_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesNotebook), 0, (GInstanceInitFunc) enotes_notebook_instance_init, NULL };
	GType enotes_notebook_type_id;
	enotes_notebook_type_id = g_type_register_static (G_TYPE_OBJECT, "ENotesNotebook", &g_define_type_info, 0);
	return enotes_notebook_type_id;
}

GType
enotes_notebook_get_type (void)
{
	static volatile gsize enotes_notebook_type_id__once = 0;
	if (g_once_init_enter (&enotes_notebook_type_id__once)) {
		GType enotes_notebook_type_id;
		enotes_notebook_type_id = enotes_notebook_get_type_once ();
		g_once_init_leave (&enotes_notebook_type_id__once, enotes_notebook_type_id);
	}
	return enotes_notebook_type_id__once;
}

static ENotesNotebookTable*
enotes_notebook_table_construct (GType object_type)
{
	ENotesNotebookTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
#line 40 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	self = (ENotesNotebookTable*) database_table_construct (object_type);
#line 41 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp0_ = database_table_create_stmt ("CREATE TABLE IF NOT EXISTS Notebook (" "id INTEGER PRIMARY KEY AUTOINCREMENT, " "name TEXT NOT NULL, " "rgb TEXT," "CSS TEXT," "stylesheet TEXT," "parent_id INTEGER)");
#line 41 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	stmt = _tmp0_;
#line 48 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp1_ = stmt;
#line 48 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	res = sqlite3_step (_tmp1_);
#line 49 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	if (res != SQLITE_DONE) {
#line 50 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		database_table_fatal ("create notebook table", res);
#line 359 "Notebook.c"
	}
#line 53 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	database_table_set_table_name ((DatabaseTable*) self, "Notebook");
#line 40 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_sqlite3_finalize0 (stmt);
#line 40 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	return self;
#line 367 "Notebook.c"
}

static ENotesNotebookTable*
enotes_notebook_table_new (void)
{
#line 40 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	return enotes_notebook_table_construct (ENOTES_TYPE_NOTEBOOK_TABLE);
#line 375 "Notebook.c"
}

static gpointer
_database_table_ref0 (gpointer self)
{
#line 61 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	return self ? database_table_ref (self) : NULL;
#line 383 "Notebook.c"
}

ENotesNotebookTable*
enotes_notebook_table_get_instance (void)
{
	ENotesNotebookTable* _tmp0_;
	ENotesNotebookTable* _tmp2_;
	ENotesNotebookTable* _tmp3_;
	ENotesNotebookTable* result;
#line 57 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp0_ = enotes_notebook_table_instance;
#line 57 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	if (_tmp0_ == NULL) {
#line 397 "Notebook.c"
		ENotesNotebookTable* _tmp1_;
#line 58 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		_tmp1_ = enotes_notebook_table_new ();
#line 58 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		_database_table_unref0 (enotes_notebook_table_instance);
#line 58 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		enotes_notebook_table_instance = _tmp1_;
#line 405 "Notebook.c"
	}
#line 61 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp2_ = enotes_notebook_table_instance;
#line 61 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp3_ = _database_table_ref0 (_tmp2_);
#line 61 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	result = _tmp3_;
#line 61 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	return result;
#line 415 "Notebook.c"
}

static gint64*
_int64_dup (gint64* self)
{
	gint64* dup;
#line 86 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	dup = g_new0 (gint64, 1);
#line 86 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	memcpy (dup, self, sizeof (gint64));
#line 86 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	return dup;
#line 428 "Notebook.c"
}

static gpointer
__int64_dup0 (gpointer self)
{
#line 86 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	return self ? _int64_dup (self) : NULL;
#line 436 "Notebook.c"
}

GeeArrayList*
enotes_notebook_table_get_notebooks (ENotesNotebookTable* self)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	GeeArrayList* notebooks = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* result;
#line 65 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 66 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp0_ = database_table_create_stmt ("SELECT id, name, rgb, parent_id, css, stylesheet FROM Notebook");
#line 66 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	stmt = _tmp0_;
#line 68 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp1_ = gee_array_list_new (ENOTES_TYPE_NOTEBOOK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 68 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	notebooks = _tmp1_;
#line 457 "Notebook.c"
	{
		gboolean _tmp2_ = FALSE;
#line 70 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		_tmp2_ = TRUE;
#line 70 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		while (TRUE) {
#line 464 "Notebook.c"
			gint res = 0;
			sqlite3_stmt* _tmp3_;
			ENotesNotebook* row = NULL;
			ENotesNotebook* _tmp4_;
			ENotesNotebook* _tmp5_;
			sqlite3_stmt* _tmp6_;
			ENotesNotebook* _tmp7_;
			sqlite3_stmt* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			GdkRGBA rgba = {0};
			GdkRGBA _tmp11_ = {0};
			sqlite3_stmt* _tmp12_;
			const gchar* _tmp13_;
			ENotesNotebook* _tmp14_;
			GdkRGBA _tmp15_;
			ENotesNotebook* _tmp16_;
			sqlite3_stmt* _tmp17_;
			gint64 _tmp18_;
			gint64* _tmp19_;
			ENotesNotebook* _tmp20_;
			sqlite3_stmt* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			ENotesNotebook* _tmp24_;
			sqlite3_stmt* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			GeeArrayList* _tmp28_;
			ENotesNotebook* _tmp29_;
#line 70 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			if (!_tmp2_) {
#line 497 "Notebook.c"
			}
#line 70 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp2_ = FALSE;
#line 71 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp3_ = stmt;
#line 71 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			res = sqlite3_step (_tmp3_);
#line 72 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			if (res == SQLITE_DONE) {
#line 73 "../Notes-up-2.0.6/src/Services/Notebook.vala"
				break;
#line 509 "Notebook.c"
			} else {
#line 74 "../Notes-up-2.0.6/src/Services/Notebook.vala"
				if (res != SQLITE_ROW) {
#line 75 "../Notes-up-2.0.6/src/Services/Notebook.vala"
					database_table_fatal ("get_notebooks", res);
#line 76 "../Notes-up-2.0.6/src/Services/Notebook.vala"
					break;
#line 517 "Notebook.c"
				}
			}
#line 79 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp4_ = enotes_notebook_new ();
#line 79 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			row = _tmp4_;
#line 81 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp5_ = row;
#line 81 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp6_ = stmt;
#line 81 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp5_->id = sqlite3_column_int64 (_tmp6_, 0);
#line 82 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp7_ = row;
#line 82 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp8_ = stmt;
#line 82 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp9_ = (const gchar*) sqlite3_column_text (_tmp8_, 1);
#line 82 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp10_ = g_strdup (_tmp9_);
#line 82 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_g_free0 (_tmp7_->name);
#line 82 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp7_->name = _tmp10_;
#line 83 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			rgba = _tmp11_;
#line 84 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp12_ = stmt;
#line 84 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp13_ = (const gchar*) sqlite3_column_text (_tmp12_, 2);
#line 84 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			gdk_rgba_parse (&rgba, _tmp13_);
#line 85 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp14_ = row;
#line 85 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp15_ = rgba;
#line 85 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp14_->rgb = _tmp15_;
#line 86 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp16_ = row;
#line 86 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp17_ = stmt;
#line 86 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp18_ = sqlite3_column_int64 (_tmp17_, 3);
#line 86 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp19_ = __int64_dup0 (&_tmp18_);
#line 86 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_g_free0 (_tmp16_->parent_id);
#line 86 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp16_->parent_id = _tmp19_;
#line 87 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp20_ = row;
#line 87 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp21_ = stmt;
#line 87 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp22_ = (const gchar*) sqlite3_column_text (_tmp21_, 4);
#line 87 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp23_ = g_strdup (_tmp22_);
#line 87 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_g_free0 (_tmp20_->css);
#line 87 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp20_->css = _tmp23_;
#line 88 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp24_ = row;
#line 88 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp25_ = stmt;
#line 88 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp26_ = (const gchar*) sqlite3_column_text (_tmp25_, 5);
#line 88 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp27_ = g_strdup (_tmp26_);
#line 88 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_g_free0 (_tmp24_->stylesheet);
#line 88 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp24_->stylesheet = _tmp27_;
#line 90 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp28_ = notebooks;
#line 90 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp29_ = row;
#line 90 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp29_);
#line 70 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_g_object_unref0 (row);
#line 600 "Notebook.c"
		}
	}
#line 93 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	result = notebooks;
#line 93 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_sqlite3_finalize0 (stmt);
#line 93 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	return result;
#line 609 "Notebook.c"
}

ENotesNotebook*
enotes_notebook_table_load_notebook_data (ENotesNotebookTable* self,
                                          gint64 notebook_id)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	ENotesNotebook* row = NULL;
	ENotesNotebook* _tmp3_;
	ENotesNotebook* _tmp4_;
	ENotesNotebook* _tmp5_;
	sqlite3_stmt* _tmp6_;
	gint64 _tmp7_;
	gint64* _tmp8_;
	ENotesNotebook* _tmp9_;
	sqlite3_stmt* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GdkRGBA rgba = {0};
	GdkRGBA _tmp13_ = {0};
	sqlite3_stmt* _tmp14_;
	const gchar* _tmp15_;
	ENotesNotebook* _tmp16_;
	GdkRGBA _tmp17_;
	ENotesNotebook* _tmp18_;
	sqlite3_stmt* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	ENotesNotebook* _tmp22_;
	sqlite3_stmt* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	ENotesNotebook* result;
#line 96 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 97 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp0_ = database_table_create_stmt ("SELECT parent_id, name, rgb, css, stylesheet " "FROM Notebook WHERE id=?");
#line 97 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	stmt = _tmp0_;
#line 100 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp1_ = stmt;
#line 100 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	database_table_bind_int (_tmp1_, 1, notebook_id);
#line 102 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp2_ = stmt;
#line 102 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	if (sqlite3_step (_tmp2_) != SQLITE_ROW) {
#line 103 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		result = NULL;
#line 103 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		_sqlite3_finalize0 (stmt);
#line 103 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		return result;
#line 666 "Notebook.c"
	}
#line 105 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp3_ = enotes_notebook_new ();
#line 105 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	row = _tmp3_;
#line 106 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp4_ = row;
#line 106 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp4_->id = notebook_id;
#line 107 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp5_ = row;
#line 107 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp6_ = stmt;
#line 107 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp7_ = (gint64) sqlite3_column_int (_tmp6_, 0);
#line 107 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp8_ = __int64_dup0 (&_tmp7_);
#line 107 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_g_free0 (_tmp5_->parent_id);
#line 107 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp5_->parent_id = _tmp8_;
#line 108 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp9_ = row;
#line 108 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp10_ = stmt;
#line 108 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp11_ = (const gchar*) sqlite3_column_text (_tmp10_, 1);
#line 108 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp12_ = g_strdup (_tmp11_);
#line 108 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_g_free0 (_tmp9_->name);
#line 108 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp9_->name = _tmp12_;
#line 109 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	rgba = _tmp13_;
#line 110 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp14_ = stmt;
#line 110 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp15_ = (const gchar*) sqlite3_column_text (_tmp14_, 2);
#line 110 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	gdk_rgba_parse (&rgba, _tmp15_);
#line 111 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp16_ = row;
#line 111 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp17_ = rgba;
#line 111 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp16_->rgb = _tmp17_;
#line 112 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp18_ = row;
#line 112 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp19_ = stmt;
#line 112 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp20_ = (const gchar*) sqlite3_column_text (_tmp19_, 3);
#line 112 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp21_ = g_strdup (_tmp20_);
#line 112 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_g_free0 (_tmp18_->css);
#line 112 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp18_->css = _tmp21_;
#line 113 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp22_ = row;
#line 113 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp23_ = stmt;
#line 113 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp24_ = (const gchar*) sqlite3_column_text (_tmp23_, 4);
#line 113 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp25_ = g_strdup (_tmp24_);
#line 113 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_g_free0 (_tmp22_->stylesheet);
#line 113 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp22_->stylesheet = _tmp25_;
#line 115 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	result = row;
#line 115 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_sqlite3_finalize0 (stmt);
#line 115 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	return result;
#line 744 "Notebook.c"
}

void
enotes_notebook_table_save_notebook (ENotesNotebookTable* self,
                                     gint64 notebook_id,
                                     const gchar* name,
                                     GdkRGBA* rgb,
                                     const gchar* css,
                                     const gchar* stylesheet)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ENotesNotebook* notebook = NULL;
	ENotesNotebook* _tmp3_;
#line 118 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	g_return_if_fail (self != NULL);
#line 118 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	g_return_if_fail (name != NULL);
#line 118 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	g_return_if_fail (rgb != NULL);
#line 118 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	g_return_if_fail (css != NULL);
#line 118 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	g_return_if_fail (stylesheet != NULL);
#line 119 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp0_ = database_table_create_stmt ("UPDATE Notebook SET name = ?, css = ?, stylesheet = ?, rgb =? WHERE id" \
" = ?");
#line 119 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	stmt = _tmp0_;
#line 121 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	database_table_bind_text (stmt, 1, name);
#line 122 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	database_table_bind_text (stmt, 2, css);
#line 123 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	database_table_bind_text (stmt, 3, stylesheet);
#line 124 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp1_ = gdk_rgba_to_string (rgb);
#line 124 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp2_ = _tmp1_;
#line 124 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	database_table_bind_text (stmt, 4, _tmp2_);
#line 124 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_g_free0 (_tmp2_);
#line 125 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	database_table_bind_int (stmt, 5, notebook_id);
#line 127 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	sqlite3_step (stmt);
#line 129 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp3_ = enotes_notebook_table_load_notebook_data (self, notebook_id);
#line 129 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	notebook = _tmp3_;
#line 130 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	g_signal_emit (self, enotes_notebook_table_signals[ENOTES_NOTEBOOK_TABLE_NOTEBOOK_CHANGED_SIGNAL], 0, notebook);
#line 118 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_g_object_unref0 (notebook);
#line 118 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_sqlite3_finalize0 (stmt);
#line 803 "Notebook.c"
}

gint64
enotes_notebook_table_new_notebook (ENotesNotebookTable* self,
                                    gint64 parent,
                                    const gchar* name,
                                    GdkRGBA* rgb,
                                    const gchar* css,
                                    const gchar* stylesheet)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	sqlite3_stmt* _tmp6_;
	sqlite3_stmt* _tmp7_;
	gint res = 0;
	sqlite3_stmt* _tmp8_;
	gint64 last = 0LL;
	ENotesNotebook* notebook = NULL;
	ENotesNotebook* _tmp9_;
	ENotesPageTable* _tmp10_;
	ENotesPageTable* _tmp11_;
	ENotesNotebook* _tmp12_;
	ENotesPage* _tmp13_;
	ENotesPage* _tmp14_;
	ENotesNotebook* _tmp15_;
	gint64 result;
#line 133 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 133 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	g_return_val_if_fail (name != NULL, 0LL);
#line 133 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	g_return_val_if_fail (rgb != NULL, 0LL);
#line 133 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	g_return_val_if_fail (css != NULL, 0LL);
#line 133 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	g_return_val_if_fail (stylesheet != NULL, 0LL);
#line 134 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp0_ = database_table_create_stmt ("INSERT INTO Notebook (name, parent_id, rgb, css, stylesheet) " "VALUES (?, ?, ?, ?, ?)");
#line 134 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	stmt = _tmp0_;
#line 137 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp1_ = stmt;
#line 137 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	database_table_bind_text (_tmp1_, 1, name);
#line 138 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp2_ = stmt;
#line 138 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	database_table_bind_int (_tmp2_, 2, parent);
#line 139 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp3_ = stmt;
#line 139 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp4_ = gdk_rgba_to_string (rgb);
#line 139 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp5_ = _tmp4_;
#line 139 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	database_table_bind_text (_tmp3_, 3, _tmp5_);
#line 139 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_g_free0 (_tmp5_);
#line 140 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp6_ = stmt;
#line 140 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	database_table_bind_text (_tmp6_, 4, css);
#line 141 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp7_ = stmt;
#line 141 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	database_table_bind_text (_tmp7_, 5, stylesheet);
#line 143 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp8_ = stmt;
#line 143 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	res = sqlite3_step (_tmp8_);
#line 144 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	if (res != SQLITE_DONE) {
#line 145 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		database_table_fatal ("Event create_from_row", res);
#line 146 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		result = (gint64) 0;
#line 146 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		_sqlite3_finalize0 (stmt);
#line 146 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		return result;
#line 889 "Notebook.c"
	}
#line 149 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	last = database_table_last_insert_row ((DatabaseTable*) self);
#line 150 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp9_ = enotes_notebook_table_load_notebook_data (self, last);
#line 150 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	notebook = _tmp9_;
#line 151 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp10_ = enotes_page_table_get_instance ();
#line 151 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp11_ = _tmp10_;
#line 151 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp12_ = notebook;
#line 151 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp13_ = enotes_page_table_new_page (_tmp11_, _tmp12_->id);
#line 151 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp14_ = _tmp13_;
#line 151 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_g_object_unref0 (_tmp14_);
#line 151 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_database_table_unref0 (_tmp11_);
#line 153 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp15_ = notebook;
#line 153 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	g_signal_emit (self, enotes_notebook_table_signals[ENOTES_NOTEBOOK_TABLE_NOTEBOOK_ADDED_SIGNAL], 0, _tmp15_);
#line 155 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	result = last;
#line 155 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_g_object_unref0 (notebook);
#line 155 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_sqlite3_finalize0 (stmt);
#line 155 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	return result;
#line 923 "Notebook.c"
}

gchar*
enotes_notebook_table_get_stylesheet_from_page (ENotesNotebookTable* self,
                                                gint64 page_id)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
#line 158 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 159 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp0_ = database_table_create_stmt ("SELECT stylesheet FROM Notebook JOIN Page WHERE Page.id = ? AND Page.n" \
"otebook_id = Notebook.id");
#line 159 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	stmt = _tmp0_;
#line 160 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp1_ = stmt;
#line 160 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	database_table_bind_int (_tmp1_, 1, page_id);
#line 162 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp2_ = stmt;
#line 162 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	if (sqlite3_step (_tmp2_) != SQLITE_ROW) {
#line 163 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		result = NULL;
#line 163 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		_sqlite3_finalize0 (stmt);
#line 163 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		return result;
#line 958 "Notebook.c"
	}
#line 166 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp3_ = stmt;
#line 166 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp4_ = (const gchar*) sqlite3_column_text (_tmp3_, 0);
#line 166 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 166 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	result = _tmp5_;
#line 166 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_sqlite3_finalize0 (stmt);
#line 166 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	return result;
#line 972 "Notebook.c"
}

gchar*
enotes_notebook_table_get_css_from_page (ENotesNotebookTable* self,
                                         gint64 page_id)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
#line 169 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 170 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp0_ = database_table_create_stmt ("SELECT css FROM Notebook JOIN Page WHERE Page.id = ? AND Page.notebook" \
"_id = Notebook.id");
#line 170 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	stmt = _tmp0_;
#line 171 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp1_ = stmt;
#line 171 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	database_table_bind_int (_tmp1_, 1, page_id);
#line 173 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp2_ = stmt;
#line 173 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	if (sqlite3_step (_tmp2_) != SQLITE_ROW) {
#line 174 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		result = NULL;
#line 174 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		_sqlite3_finalize0 (stmt);
#line 174 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		return result;
#line 1007 "Notebook.c"
	}
#line 177 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp3_ = stmt;
#line 177 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp4_ = (const gchar*) sqlite3_column_text (_tmp3_, 0);
#line 177 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 177 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	result = _tmp5_;
#line 177 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_sqlite3_finalize0 (stmt);
#line 177 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	return result;
#line 1021 "Notebook.c"
}

void
enotes_notebook_table_move_notebook (ENotesNotebookTable* self,
                                     ENotesNotebook* notebook,
                                     ENotesNotebook* parent_notebook)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint64 _tmp1_ = 0LL;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
#line 180 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	g_return_if_fail (self != NULL);
#line 180 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	g_return_if_fail (notebook != NULL);
#line 181 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp0_ = database_table_create_stmt ("UPDATE Notebook SET parent_id = ? WHERE id = ?");
#line 181 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	stmt = _tmp0_;
#line 182 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	if (parent_notebook != NULL) {
#line 182 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		_tmp1_ = parent_notebook->id;
#line 1047 "Notebook.c"
	} else {
#line 182 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		_tmp1_ = (gint64) 0;
#line 1051 "Notebook.c"
	}
#line 182 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp2_ = stmt;
#line 182 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	database_table_bind_int (_tmp2_, 1, _tmp1_);
#line 183 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp3_ = stmt;
#line 183 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	database_table_bind_int (_tmp3_, 2, notebook->id);
#line 185 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp4_ = stmt;
#line 185 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	sqlite3_step (_tmp4_);
#line 180 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_sqlite3_finalize0 (stmt);
#line 1067 "Notebook.c"
}

void
enotes_notebook_table_delete_notebook (ENotesNotebookTable* self,
                                       gint64 id)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	ENotesPageTable* page_table = NULL;
	ENotesPageTable* _tmp3_;
	GeeArrayList* pages = NULL;
	ENotesPageTable* _tmp4_;
	GeeArrayList* _tmp5_;
	sqlite3_stmt* _tmp16_;
	sqlite3_stmt* _tmp17_;
	sqlite3_stmt* _tmp18_;
#line 188 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	g_return_if_fail (self != NULL);
#line 189 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp0_ = database_table_create_stmt ("UPDATE Notebook SET parent_id = 0 WHERE parent_id = ?");
#line 189 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	stmt = _tmp0_;
#line 190 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp1_ = stmt;
#line 190 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	database_table_bind_int (_tmp1_, 1, id);
#line 191 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp2_ = stmt;
#line 191 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	sqlite3_step (_tmp2_);
#line 193 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp3_ = enotes_page_table_get_instance ();
#line 193 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	page_table = _tmp3_;
#line 194 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp4_ = page_table;
#line 194 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp5_ = enotes_page_table_get_pages (_tmp4_, id);
#line 194 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	pages = _tmp5_;
#line 1110 "Notebook.c"
	{
		GeeArrayList* _page_list = NULL;
		GeeArrayList* _tmp6_;
		gint _page_size = 0;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _page_index = 0;
#line 196 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		_tmp6_ = pages;
#line 196 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		_page_list = _tmp6_;
#line 196 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		_tmp7_ = _page_list;
#line 196 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
#line 196 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		_tmp9_ = _tmp8_;
#line 196 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		_page_size = _tmp9_;
#line 196 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		_page_index = -1;
#line 196 "../Notes-up-2.0.6/src/Services/Notebook.vala"
		while (TRUE) {
#line 1135 "Notebook.c"
			gint _tmp10_;
			gint _tmp11_;
			ENotesPage* page = NULL;
			GeeArrayList* _tmp12_;
			gpointer _tmp13_;
			ENotesPageTable* _tmp14_;
			ENotesPage* _tmp15_;
#line 196 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_page_index = _page_index + 1;
#line 196 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp10_ = _page_index;
#line 196 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp11_ = _page_size;
#line 196 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			if (!(_tmp10_ < _tmp11_)) {
#line 196 "../Notes-up-2.0.6/src/Services/Notebook.vala"
				break;
#line 1153 "Notebook.c"
			}
#line 196 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp12_ = _page_list;
#line 196 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _page_index);
#line 196 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			page = (ENotesPage*) _tmp13_;
#line 197 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp14_ = page_table;
#line 197 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_tmp15_ = page;
#line 197 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			enotes_page_table_delete_page (_tmp14_, _tmp15_->id);
#line 196 "../Notes-up-2.0.6/src/Services/Notebook.vala"
			_g_object_unref0 (page);
#line 1169 "Notebook.c"
		}
	}
#line 200 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp16_ = database_table_create_stmt ("DELETE FROM Notebook WHERE id = ?");
#line 200 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_sqlite3_finalize0 (stmt);
#line 200 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	stmt = _tmp16_;
#line 201 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp17_ = stmt;
#line 201 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	database_table_bind_int (_tmp17_, 1, id);
#line 203 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_tmp18_ = stmt;
#line 203 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	sqlite3_step (_tmp18_);
#line 188 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_g_object_unref0 (pages);
#line 188 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_database_table_unref0 (page_table);
#line 188 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_sqlite3_finalize0 (stmt);
#line 1192 "Notebook.c"
}

void
enotes_notebook_table_reset_instance (void)
{
#line 207 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	_database_table_unref0 (enotes_notebook_table_instance);
#line 207 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	enotes_notebook_table_instance = NULL;
#line 1202 "Notebook.c"
}

static void
enotes_notebook_table_class_init (ENotesNotebookTableClass * klass,
                                  gpointer klass_data)
{
#line 34 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	enotes_notebook_table_parent_class = g_type_class_peek_parent (klass);
#line 34 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	((DatabaseTableClass *) klass)->finalize = enotes_notebook_table_finalize;
#line 34 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	enotes_notebook_table_signals[ENOTES_NOTEBOOK_TABLE_NOTEBOOK_ADDED_SIGNAL] = g_signal_new ("notebook-added", ENOTES_TYPE_NOTEBOOK_TABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, ENOTES_TYPE_NOTEBOOK);
#line 34 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	enotes_notebook_table_signals[ENOTES_NOTEBOOK_TABLE_NOTEBOOK_CHANGED_SIGNAL] = g_signal_new ("notebook-changed", ENOTES_TYPE_NOTEBOOK_TABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, ENOTES_TYPE_NOTEBOOK);
#line 1217 "Notebook.c"
}

static void
enotes_notebook_table_instance_init (ENotesNotebookTable * self,
                                     gpointer klass)
{
}

static void
enotes_notebook_table_finalize (DatabaseTable * obj)
{
	ENotesNotebookTable * self;
#line 34 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_NOTEBOOK_TABLE, ENotesNotebookTable);
#line 34 "../Notes-up-2.0.6/src/Services/Notebook.vala"
	DATABASE_TABLE_CLASS (enotes_notebook_table_parent_class)->finalize (obj);
#line 1234 "Notebook.c"
}

static GType
enotes_notebook_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesNotebookTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_notebook_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesNotebookTable), 0, (GInstanceInitFunc) enotes_notebook_table_instance_init, NULL };
	GType enotes_notebook_table_type_id;
	enotes_notebook_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "ENotesNotebookTable", &g_define_type_info, 0);
	return enotes_notebook_table_type_id;
}

GType
enotes_notebook_table_get_type (void)
{
	static volatile gsize enotes_notebook_table_type_id__once = 0;
	if (g_once_init_enter (&enotes_notebook_table_type_id__once)) {
		GType enotes_notebook_table_type_id;
		enotes_notebook_table_type_id = enotes_notebook_table_get_type_once ();
		g_once_init_leave (&enotes_notebook_table_type_id__once, enotes_notebook_table_type_id);
	}
	return enotes_notebook_table_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

