/* FileManager.c generated by valac 0.56.12, the Vala compiler
 * generated from FileManager.vala, do not modify */

/*
* Copyright (c) 2015-2016 Felipe Escoto (https://github.com/Philip-Scott/Notes-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <webkit2/webkit2.h>
#include <granite.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ENOTES_TYPE_FILE_MANAGER (enotes_file_manager_get_type ())
#define ENOTES_FILE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_FILE_MANAGER, ENotesFileManager))
#define ENOTES_FILE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_FILE_MANAGER, ENotesFileManagerClass))
#define ENOTES_IS_FILE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_FILE_MANAGER))
#define ENOTES_IS_FILE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_FILE_MANAGER))
#define ENOTES_FILE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_FILE_MANAGER, ENotesFileManagerClass))

typedef struct _ENotesFileManager ENotesFileManager;
typedef struct _ENotesFileManagerClass ENotesFileManagerClass;
typedef struct _ENotesFileManagerPrivate ENotesFileManagerPrivate;
enum  {
	ENOTES_FILE_MANAGER_0_PROPERTY,
	ENOTES_FILE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* enotes_file_manager_properties[ENOTES_FILE_MANAGER_NUM_PROPERTIES];

#define ENOTES_TYPE_VIEW_EDIT_STACK (enotes_view_edit_stack_get_type ())
#define ENOTES_VIEW_EDIT_STACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_VIEW_EDIT_STACK, ENotesViewEditStack))
#define ENOTES_VIEW_EDIT_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_VIEW_EDIT_STACK, ENotesViewEditStackClass))
#define ENOTES_IS_VIEW_EDIT_STACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_VIEW_EDIT_STACK))
#define ENOTES_IS_VIEW_EDIT_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_VIEW_EDIT_STACK))
#define ENOTES_VIEW_EDIT_STACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_VIEW_EDIT_STACK, ENotesViewEditStackClass))

typedef struct _ENotesViewEditStack ENotesViewEditStack;
typedef struct _ENotesViewEditStackClass ENotesViewEditStackClass;

#define ENOTES_TYPE_VIEWER (enotes_viewer_get_type ())
#define ENOTES_VIEWER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_VIEWER, ENotesViewer))
#define ENOTES_VIEWER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_VIEWER, ENotesViewerClass))
#define ENOTES_IS_VIEWER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_VIEWER))
#define ENOTES_IS_VIEWER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_VIEWER))
#define ENOTES_VIEWER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_VIEWER, ENotesViewerClass))

typedef struct _ENotesViewer ENotesViewer;
typedef struct _ENotesViewerClass ENotesViewerClass;

#define ENOTES_TYPE_PAGE (enotes_page_get_type ())
#define ENOTES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGE, ENotesPage))
#define ENOTES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGE, ENotesPageClass))
#define ENOTES_IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGE))
#define ENOTES_IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGE))
#define ENOTES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGE, ENotesPageClass))

typedef struct _ENotesPage ENotesPage;
typedef struct _ENotesPageClass ENotesPageClass;

#define ENOTES_TYPE_APPLICATION (enotes_application_get_type ())
#define ENOTES_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_APPLICATION, ENotesApplication))
#define ENOTES_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_APPLICATION, ENotesApplicationClass))
#define ENOTES_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_APPLICATION))
#define ENOTES_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_APPLICATION))
#define ENOTES_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_APPLICATION, ENotesApplicationClass))

typedef struct _ENotesApplication ENotesApplication;
typedef struct _ENotesApplicationClass ENotesApplicationClass;
typedef struct _ENotesApplicationPrivate ENotesApplicationPrivate;

#define ENOTES_APPLICATION_TYPE_STATE (enotes_application_state_get_type ())
#define ENOTES_APPLICATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationState))
#define ENOTES_APPLICATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationStateClass))
#define ENOTES_APPLICATION_IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_APPLICATION_TYPE_STATE))
#define ENOTES_APPLICATION_IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_APPLICATION_TYPE_STATE))
#define ENOTES_APPLICATION_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationStateClass))

typedef struct _ENotesApplicationState ENotesApplicationState;
typedef struct _ENotesApplicationStateClass ENotesApplicationStateClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define ENOTES_TYPE_EDITOR (enotes_editor_get_type ())
#define ENOTES_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_EDITOR, ENotesEditor))
#define ENOTES_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_EDITOR, ENotesEditorClass))
#define ENOTES_IS_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_EDITOR))
#define ENOTES_IS_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_EDITOR))
#define ENOTES_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_EDITOR, ENotesEditorClass))

typedef struct _ENotesEditor ENotesEditor;
typedef struct _ENotesEditorClass ENotesEditorClass;
typedef struct _ENotesPagePrivate ENotesPagePrivate;
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;

struct _ENotesFileManager {
	GObject parent_instance;
	ENotesFileManagerPrivate * priv;
};

struct _ENotesFileManagerClass {
	GObjectClass parent_class;
};

struct _ENotesApplication {
	GraniteApplication parent_instance;
	ENotesApplicationPrivate * priv;
	gboolean running;
	ENotesApplicationState* state;
};

struct _ENotesApplicationClass {
	GraniteApplicationClass parent_class;
};

struct _ENotesPage {
	GObject parent_instance;
	ENotesPagePrivate * priv;
	gint64 id;
	gint64 notebook_id;
	gchar* name;
	gchar* data;
	gchar* subtitle;
	gchar* html_cache;
	gint64 creation_date;
	gint64 modification_date;
	gboolean new_page;
	gboolean cache_changed;
	gchar* full_path;
};

struct _ENotesPageClass {
	GObjectClass parent_class;
};

struct _Block10Data {
	int _ref_count_;
	GFile* file;
	gchar* contents;
};

struct _Block11Data {
	int _ref_count_;
	GtkFileChooserDialog* dialog;
};

static gpointer enotes_file_manager_parent_class = NULL;
VALA_EXTERN ENotesApplication* enotes_app;

VALA_EXTERN GType enotes_file_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesFileManager, g_object_unref)
VALA_EXTERN GFile* enotes_file_manager_export_pdf_action (const gchar* file_path);
VALA_EXTERN GType enotes_view_edit_stack_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesViewEditStack, g_object_unref)
VALA_EXTERN ENotesViewEditStack* enotes_view_edit_stack_get_instance (void);
VALA_EXTERN GType enotes_viewer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesViewer, g_object_unref)
VALA_EXTERN ENotesViewer* enotes_view_edit_stack_get_viewer (ENotesViewEditStack* self);
VALA_EXTERN GType enotes_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPage, g_object_unref)
VALA_EXTERN void enotes_viewer_load_page (ENotesViewer* self,
                              ENotesPage* page,
                              gboolean force_load);
VALA_EXTERN GType enotes_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesApplication, g_object_unref)
VALA_EXTERN GType enotes_application_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesApplicationState, g_object_unref)
VALA_EXTERN ENotesPage* enotes_application_state_get_opened_page (ENotesApplicationState* self);
VALA_EXTERN GFile* enotes_file_manager_get_file_from_user (const gchar* filetype,
                                               GtkFileChooserAction* chooser_action);
VALA_EXTERN void enotes_file_manager_write_file (GFile* file,
                                     const gchar* contents,
                                     gboolean overrite,
                                     GError** error);
VALA_EXTERN GFile* enotes_file_manager_export_markdown_action (const gchar* file_path);
VALA_EXTERN GType enotes_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesEditor, g_object_unref)
VALA_EXTERN ENotesEditor* enotes_view_edit_stack_get_editor (ENotesViewEditStack* self);
VALA_EXTERN void enotes_editor_save_file (ENotesEditor* self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
VALA_EXTERN void enotes_file_manager_create_file_if_not_exists (GFile* file,
                                                    GError** error);
static void __lambda38_ (Block10Data* _data10_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda38__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static gboolean _gtk_file_chooser_action_equal (const GtkFileChooserAction * s1,
                                         const GtkFileChooserAction * s2);
static void __lambda37_ (Block11Data* _data11_,
                  GtkFileFilter* filter);
static void ___lambda37__gfunc (gconstpointer data,
                         gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN ENotesFileManager* enotes_file_manager_new (void);
VALA_EXTERN ENotesFileManager* enotes_file_manager_construct (GType object_type);
static GType enotes_file_manager_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GFile*
enotes_file_manager_export_pdf_action (const gchar* file_path)
{
	ENotesViewEditStack* _tmp0_;
	ENotesViewEditStack* _tmp1_;
	ENotesViewer* _tmp2_;
	ENotesViewer* _tmp3_;
	ENotesApplication* _tmp4_;
	ENotesApplicationState* _tmp5_;
	ENotesPage* _tmp6_;
	ENotesPage* _tmp7_;
	GFile* file = NULL;
	GFile* _tmp11_;
	GFile* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gboolean _tmp17_;
	WebKitPrintOperation* op = NULL;
	ENotesViewEditStack* _tmp27_;
	ENotesViewEditStack* _tmp28_;
	ENotesViewer* _tmp29_;
	ENotesViewer* _tmp30_;
	WebKitPrintOperation* _tmp31_;
	WebKitPrintOperation* _tmp32_;
	GtkPrintSettings* settings = NULL;
	GtkPrintSettings* _tmp33_;
	GtkPrintSettings* _tmp34_;
	GtkPrintSettings* _tmp35_;
	GFile* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	WebKitPrintOperation* _tmp39_;
	GtkPrintSettings* _tmp40_;
	WebKitPrintOperation* _tmp41_;
	GError* _inner_error0_ = NULL;
	GFile* result;
#line 25 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp0_ = enotes_view_edit_stack_get_instance ();
#line 25 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp1_ = _tmp0_;
#line 25 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp2_ = enotes_view_edit_stack_get_viewer (_tmp1_);
#line 25 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp3_ = _tmp2_;
#line 25 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp4_ = enotes_app;
#line 25 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp5_ = _tmp4_->state;
#line 25 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp6_ = enotes_application_state_get_opened_page (_tmp5_);
#line 25 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp7_ = _tmp6_;
#line 25 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	enotes_viewer_load_page (_tmp3_, _tmp7_, TRUE);
#line 25 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_g_object_unref0 (_tmp1_);
#line 28 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	if (file_path == NULL) {
#line 300 "FileManager.c"
		GtkFileChooserAction _tmp8_;
		GFile* _tmp9_;
#line 29 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp8_ = GTK_FILE_CHOOSER_ACTION_SAVE;
#line 29 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp9_ = enotes_file_manager_get_file_from_user ("pdf", &_tmp8_);
#line 29 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_object_unref0 (file);
#line 29 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		file = _tmp9_;
#line 311 "FileManager.c"
	} else {
		GFile* _tmp10_;
#line 31 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp10_ = g_file_new_for_path (file_path);
#line 31 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_object_unref0 (file);
#line 31 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		file = _tmp10_;
#line 320 "FileManager.c"
	}
#line 34 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp11_ = file;
#line 34 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	if (_tmp11_ == NULL) {
#line 35 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		result = NULL;
#line 35 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_object_unref0 (file);
#line 35 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		return result;
#line 332 "FileManager.c"
	}
#line 38 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp12_ = file;
#line 38 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp13_ = g_file_get_basename (_tmp12_);
#line 38 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp14_ = _tmp13_;
#line 38 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp15_ = g_utf8_strdown (_tmp14_, (gssize) -1);
#line 38 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp16_ = _tmp15_;
#line 38 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp17_ = !g_str_has_suffix (_tmp16_, ".pdf");
#line 38 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_g_free0 (_tmp16_);
#line 38 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_g_free0 (_tmp14_);
#line 38 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	if (_tmp17_) {
#line 352 "FileManager.c"
		GFile* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		GFile* _tmp23_;
#line 39 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp18_ = file;
#line 39 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp19_ = g_file_get_path (_tmp18_);
#line 39 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp20_ = _tmp19_;
#line 39 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp21_ = g_strconcat (_tmp20_, ".pdf", NULL);
#line 39 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp22_ = _tmp21_;
#line 39 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp23_ = g_file_new_for_path (_tmp22_);
#line 39 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_object_unref0 (file);
#line 39 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		file = _tmp23_;
#line 39 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_free0 (_tmp22_);
#line 39 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_free0 (_tmp20_);
#line 379 "FileManager.c"
	}
	{
		GFile* _tmp24_;
#line 43 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp24_ = file;
#line 43 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		enotes_file_manager_write_file (_tmp24_, "", FALSE, &_inner_error0_);
#line 43 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 389 "FileManager.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		const gchar* _tmp26_;
#line 42 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		e = _inner_error0_;
#line 42 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_inner_error0_ = NULL;
#line 45 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp25_ = e;
#line 45 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp26_ = _tmp25_->message;
#line 45 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		g_warning ("FileManager.vala:45: Could not write initial PDF file: %s", _tmp26_);
#line 46 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		result = NULL;
#line 46 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_error_free0 (e);
#line 46 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_object_unref0 (file);
#line 46 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		return result;
#line 417 "FileManager.c"
	}
	__finally0:
#line 42 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 42 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_object_unref0 (file);
#line 42 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 42 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		g_clear_error (&_inner_error0_);
#line 42 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		return NULL;
#line 430 "FileManager.c"
	}
#line 49 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp27_ = enotes_view_edit_stack_get_instance ();
#line 49 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp28_ = _tmp27_;
#line 49 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp29_ = enotes_view_edit_stack_get_viewer (_tmp28_);
#line 49 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp30_ = _tmp29_;
#line 49 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp31_ = webkit_print_operation_new ((WebKitWebView*) _tmp30_);
#line 49 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp32_ = _tmp31_;
#line 49 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_g_object_unref0 (_tmp28_);
#line 49 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	op = _tmp32_;
#line 50 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp33_ = gtk_print_settings_new ();
#line 50 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	settings = _tmp33_;
#line 51 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp34_ = settings;
#line 51 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	gtk_print_settings_set_printer (_tmp34_, _ ("Print to File"));
#line 53 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp35_ = settings;
#line 53 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp36_ = file;
#line 53 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp37_ = g_file_get_uri (_tmp36_);
#line 53 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp38_ = _tmp37_;
#line 53 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	gtk_print_settings_set (_tmp35_, GTK_PRINT_SETTINGS_OUTPUT_URI, _tmp38_);
#line 53 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_g_free0 (_tmp38_);
#line 54 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp39_ = op;
#line 54 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp40_ = settings;
#line 54 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	webkit_print_operation_set_print_settings (_tmp39_, _tmp40_);
#line 56 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp41_ = op;
#line 56 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	webkit_print_operation_print (_tmp41_);
#line 58 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	result = file;
#line 58 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_g_object_unref0 (settings);
#line 58 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_g_object_unref0 (op);
#line 58 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	return result;
#line 486 "FileManager.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 77 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	return self ? g_object_ref (self) : NULL;
#line 494 "FileManager.c"
}

static gchar*
string_to_utf8 (const gchar* self,
                gint* result_length1)
{
	gint string_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _result_ = NULL;
	gchar* _tmp2_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gchar* result;
#line 1570 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1571 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1571 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1571 "glib-2.0.vapi"
	string_length = _tmp1_;
#line 1572 "glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, string_length + 1);
#line 1572 "glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1572 "glib-2.0.vapi"
	_result__length1 = string_length + 1;
#line 1572 "glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1573 "glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1573 "glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1574 "glib-2.0.vapi"
	memcpy (_result_, self, (gsize) string_length);
#line 1575 "glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1575 "glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1575 "glib-2.0.vapi"
	if (result_length1) {
#line 1575 "glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 542 "FileManager.c"
	}
#line 1575 "glib-2.0.vapi"
	result = _tmp4_;
#line 1575 "glib-2.0.vapi"
	return result;
#line 548 "FileManager.c"
}

GFile*
enotes_file_manager_export_markdown_action (const gchar* file_path)
{
	GFile* file = NULL;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	ENotesEditor* editor = NULL;
	ENotesViewEditStack* _tmp16_;
	ENotesViewEditStack* _tmp17_;
	ENotesEditor* _tmp18_;
	ENotesEditor* _tmp19_;
	ENotesEditor* _tmp20_;
	ENotesEditor* _tmp21_;
	ENotesEditor* _tmp22_;
	GError* _inner_error0_ = NULL;
	GFile* result;
#line 63 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	if (file_path == NULL) {
#line 574 "FileManager.c"
		GtkFileChooserAction _tmp0_;
		GFile* _tmp1_;
#line 64 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp0_ = GTK_FILE_CHOOSER_ACTION_SAVE;
#line 64 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp1_ = enotes_file_manager_get_file_from_user ("md", &_tmp0_);
#line 64 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_object_unref0 (file);
#line 64 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		file = _tmp1_;
#line 585 "FileManager.c"
	} else {
		GFile* _tmp2_;
#line 66 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp2_ = g_file_new_for_path (file_path);
#line 66 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_object_unref0 (file);
#line 66 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		file = _tmp2_;
#line 594 "FileManager.c"
	}
#line 69 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp3_ = file;
#line 69 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	if (_tmp3_ == NULL) {
#line 70 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		result = NULL;
#line 70 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_object_unref0 (file);
#line 70 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		return result;
#line 606 "FileManager.c"
	}
#line 73 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp4_ = file;
#line 73 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp5_ = g_file_get_basename (_tmp4_);
#line 73 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp6_ = _tmp5_;
#line 73 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
#line 73 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp8_ = _tmp7_;
#line 73 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp9_ = !g_str_has_suffix (_tmp8_, ".md");
#line 73 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_g_free0 (_tmp8_);
#line 73 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_g_free0 (_tmp6_);
#line 73 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	if (_tmp9_) {
#line 626 "FileManager.c"
		GFile* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GFile* _tmp15_;
#line 74 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp10_ = file;
#line 74 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp11_ = g_file_get_path (_tmp10_);
#line 74 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp12_ = _tmp11_;
#line 74 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp13_ = g_strconcat (_tmp12_, ".md", NULL);
#line 74 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp14_ = _tmp13_;
#line 74 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp15_ = g_file_new_for_path (_tmp14_);
#line 74 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_object_unref0 (file);
#line 74 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		file = _tmp15_;
#line 74 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_free0 (_tmp14_);
#line 74 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_free0 (_tmp12_);
#line 653 "FileManager.c"
	}
#line 77 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp16_ = enotes_view_edit_stack_get_instance ();
#line 77 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp17_ = _tmp16_;
#line 77 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp18_ = enotes_view_edit_stack_get_editor (_tmp17_);
#line 77 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp19_ = _tmp18_;
#line 77 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp20_ = _g_object_ref0 (_tmp19_);
#line 77 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp21_ = _tmp20_;
#line 77 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_g_object_unref0 (_tmp17_);
#line 77 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	editor = _tmp21_;
#line 78 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp22_ = editor;
#line 78 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	enotes_editor_save_file (_tmp22_);
#line 675 "FileManager.c"
	{
		GFile* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		ENotesApplication* _tmp26_;
		ENotesApplicationState* _tmp27_;
		ENotesPage* _tmp28_;
		ENotesPage* _tmp29_;
		const gchar* _tmp30_;
		gint _tmp31_ = 0;
		gchar* _tmp32_;
		guint8* _tmp33_;
		gint _tmp33__length1;
#line 81 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp23_ = file;
#line 81 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp24_ = g_file_get_path (_tmp23_);
#line 81 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp25_ = _tmp24_;
#line 81 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp26_ = enotes_app;
#line 81 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp27_ = _tmp26_->state;
#line 81 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp28_ = enotes_application_state_get_opened_page (_tmp27_);
#line 81 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp29_ = _tmp28_;
#line 81 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp30_ = _tmp29_->data;
#line 81 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp32_ = string_to_utf8 (_tmp30_, &_tmp31_);
#line 81 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp33_ = (guint8*) _tmp32_;
#line 81 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp33__length1 = (_tmp31_ * sizeof (gchar)) / sizeof (guint8);
#line 81 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		g_file_set_contents (_tmp25_, (const char*) _tmp33_, (gsize) ((_tmp31_ * sizeof (gchar)) / sizeof (guint8)), &_inner_error0_);
#line 81 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp33_ = (g_free (_tmp33_), NULL);
#line 81 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_free0 (_tmp25_);
#line 81 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 719 "FileManager.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp34_;
		const gchar* _tmp35_;
#line 80 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		e = _inner_error0_;
#line 80 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_inner_error0_ = NULL;
#line 83 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp34_ = e;
#line 83 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp35_ = _tmp34_->message;
#line 83 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		g_warning ("FileManager.vala:83: Failed to export file %s", _tmp35_);
#line 80 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_error_free0 (e);
#line 741 "FileManager.c"
	}
	__finally0:
#line 80 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 80 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_object_unref0 (editor);
#line 80 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_object_unref0 (file);
#line 80 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 80 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		g_clear_error (&_inner_error0_);
#line 80 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		return NULL;
#line 756 "FileManager.c"
	}
#line 86 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	result = file;
#line 86 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_g_object_unref0 (editor);
#line 86 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	return result;
#line 764 "FileManager.c"
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
#line 89 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	g_atomic_int_inc (&_data10_->_ref_count_);
#line 89 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	return _data10_;
#line 774 "FileManager.c"
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
#line 89 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
#line 89 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_object_unref0 (_data10_->file);
#line 89 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_free0 (_data10_->contents);
#line 89 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		g_slice_free (Block10Data, _data10_);
#line 790 "FileManager.c"
	}
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
#line 1563 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1564 "glib-2.0.vapi"
	res = (guint8*) self;
#line 1564 "glib-2.0.vapi"
	res_length1 = -1;
#line 1564 "glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1565 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1565 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1565 "glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1566 "glib-2.0.vapi"
	_tmp2_ = res;
#line 1566 "glib-2.0.vapi"
	_tmp2__length1 = res_length1;
#line 1566 "glib-2.0.vapi"
	if (result_length1) {
#line 1566 "glib-2.0.vapi"
		*result_length1 = _tmp2__length1;
#line 828 "FileManager.c"
	}
#line 1566 "glib-2.0.vapi"
	result = _tmp2_;
#line 1566 "glib-2.0.vapi"
	return result;
#line 834 "FileManager.c"
}

static void
__lambda38_ (Block10Data* _data10_,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
#line 96 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	g_return_if_fail (res != NULL);
#line 845 "FileManager.c"
	{
		GFileIOStream* iostream = NULL;
		GFileIOStream* _tmp0_;
		GOutputStream* ostream = NULL;
		GFileIOStream* _tmp1_;
		GOutputStream* _tmp2_;
		GOutputStream* _tmp3_;
		GOutputStream* _tmp4_;
		GOutputStream* _tmp5_;
		guint8* _tmp6_;
		gint _tmp6__length1;
		gint _tmp7_ = 0;
		guint8* _tmp8_;
		gint _tmp8__length1;
#line 98 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp0_ = g_file_open_readwrite_finish (_data10_->file, res, &_inner_error0_);
#line 98 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		iostream = _tmp0_;
#line 98 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 866 "FileManager.c"
			goto __catch0_g_error;
		}
#line 99 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp1_ = iostream;
#line 99 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp2_ = g_io_stream_get_output_stream ((GIOStream*) _tmp1_);
#line 99 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp3_ = _tmp2_;
#line 99 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 99 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		ostream = _tmp4_;
#line 100 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp5_ = ostream;
#line 100 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp6_ = string_get_data (_data10_->contents, &_tmp7_);
#line 100 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp6__length1 = _tmp7_;
#line 100 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp8_ = _tmp6_;
#line 100 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp8__length1 = _tmp6__length1;
#line 100 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		g_output_stream_write_all (_tmp5_, _tmp8_, (gsize) _tmp8__length1, NULL, NULL, &_inner_error0_);
#line 100 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 100 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			_g_object_unref0 (ostream);
#line 100 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			_g_object_unref0 (iostream);
#line 897 "FileManager.c"
			goto __catch0_g_error;
		}
#line 97 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_object_unref0 (ostream);
#line 97 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_object_unref0 (iostream);
#line 904 "FileManager.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
#line 97 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		e = _inner_error0_;
#line 97 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_inner_error0_ = NULL;
#line 102 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp9_ = g_file_get_basename (_data10_->file);
#line 102 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp10_ = _tmp9_;
#line 102 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp11_ = e;
#line 102 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp12_ = _tmp11_->message;
#line 102 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		g_warning ("FileManager.vala:102: Could not write file \"%s\": %s", _tmp10_, _tmp12_);
#line 102 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_free0 (_tmp10_);
#line 97 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_error_free0 (e);
#line 932 "FileManager.c"
	}
	__finally0:
#line 97 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 97 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 97 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		g_clear_error (&_inner_error0_);
#line 97 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		return;
#line 943 "FileManager.c"
	}
}

static void
___lambda38__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
#line 96 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	__lambda38_ (self, source_object, res);
#line 96 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	block10_data_unref (self);
#line 956 "FileManager.c"
}

void
enotes_file_manager_write_file (GFile* file,
                                const gchar* contents,
                                gboolean overrite,
                                GError** error)
{
	Block10Data* _data10_;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GError* _inner_error0_ = NULL;
#line 89 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	g_return_if_fail (file != NULL);
#line 89 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	g_return_if_fail (contents != NULL);
#line 89 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_data10_ = g_slice_new0 (Block10Data);
#line 89 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_data10_->_ref_count_ = 1;
#line 89 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp0_ = _g_object_ref0 (file);
#line 89 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_g_object_unref0 (_data10_->file);
#line 89 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_data10_->file = _tmp0_;
#line 89 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp1_ = g_strdup (contents);
#line 89 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_g_free0 (_data10_->contents);
#line 89 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_data10_->contents = _tmp1_;
#line 90 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	if (g_file_query_exists (_data10_->file, NULL)) {
#line 90 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp2_ = overrite;
#line 994 "FileManager.c"
	} else {
#line 90 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp2_ = FALSE;
#line 998 "FileManager.c"
	}
#line 90 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	if (_tmp2_) {
#line 91 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		g_file_delete (_data10_->file, NULL, &_inner_error0_);
#line 91 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 91 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			g_propagate_error (error, _inner_error0_);
#line 91 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			block10_data_unref (_data10_);
#line 91 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			_data10_ = NULL;
#line 91 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			return;
#line 1014 "FileManager.c"
		}
	}
#line 94 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	enotes_file_manager_create_file_if_not_exists (_data10_->file, &_inner_error0_);
#line 94 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 94 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		g_propagate_error (error, _inner_error0_);
#line 94 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		block10_data_unref (_data10_);
#line 94 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_data10_ = NULL;
#line 94 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		return;
#line 1029 "FileManager.c"
	}
#line 96 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	g_file_open_readwrite_async (_data10_->file, G_PRIORITY_DEFAULT, NULL, ___lambda38__gasync_ready_callback, block10_data_ref (_data10_));
#line 89 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	block10_data_unref (_data10_);
#line 89 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_data10_ = NULL;
#line 1037 "FileManager.c"
}

void
enotes_file_manager_create_file_if_not_exists (GFile* file,
                                               GError** error)
{
	GError* _inner_error0_ = NULL;
#line 107 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	g_return_if_fail (file != NULL);
#line 108 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	if (!g_file_query_exists (file, NULL)) {
#line 1049 "FileManager.c"
		{
			GFileOutputStream* _tmp0_;
			GFileOutputStream* _tmp1_;
#line 110 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			_tmp0_ = g_file_create (file, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
#line 110 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			_tmp1_ = _tmp0_;
#line 110 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			_g_object_unref0 (_tmp1_);
#line 110 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1061 "FileManager.c"
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
			GError* _tmp4_;
#line 109 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			e = _inner_error0_;
#line 109 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			_inner_error0_ = NULL;
#line 112 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			_tmp2_ = e;
#line 112 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			_tmp3_ = _tmp2_->message;
#line 112 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			_tmp4_ = g_error_new (g_quark_from_string (""), -1, "Could not write file: %s", _tmp3_);
#line 112 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			_inner_error0_ = _tmp4_;
#line 112 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			_g_error_free0 (e);
#line 1086 "FileManager.c"
			goto __finally0;
		}
		__finally0:
#line 109 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 109 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			g_propagate_error (error, _inner_error0_);
#line 109 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			return;
#line 1096 "FileManager.c"
		}
	}
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
#line 117 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	g_atomic_int_inc (&_data11_->_ref_count_);
#line 117 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	return _data11_;
#line 1108 "FileManager.c"
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
#line 117 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
#line 117 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_object_unref0 (_data11_->dialog);
#line 117 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		g_slice_free (Block11Data, _data11_);
#line 1122 "FileManager.c"
	}
}

static gboolean
_gtk_file_chooser_action_equal (const GtkFileChooserAction * s1,
                                const GtkFileChooserAction * s2)
{
#line 168 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	if (s1 == s2) {
#line 168 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		return TRUE;
#line 1134 "FileManager.c"
	}
#line 168 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	if (s1 == NULL) {
#line 168 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		return FALSE;
#line 1140 "FileManager.c"
	}
#line 168 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	if (s2 == NULL) {
#line 168 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		return FALSE;
#line 1146 "FileManager.c"
	}
#line 168 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	return (*s1) == (*s2);
#line 1150 "FileManager.c"
}

static void
__lambda37_ (Block11Data* _data11_,
             GtkFileFilter* filter)
{
	GtkFileChooserDialog* _tmp0_;
	GtkFileFilter* _tmp1_;
#line 191 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	g_return_if_fail (filter != NULL);
#line 192 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp0_ = _data11_->dialog;
#line 192 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp1_ = _g_object_ref0 (filter);
#line 192 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp0_, _tmp1_);
#line 1167 "FileManager.c"
}

static void
___lambda37__gfunc (gconstpointer data,
                    gpointer self)
{
#line 191 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	__lambda37_ (self, (GtkFileFilter*) data);
#line 1176 "FileManager.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 201 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1184 "FileManager.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 201 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 1192 "FileManager.c"
}

GFile*
enotes_file_manager_get_file_from_user (const gchar* filetype,
                                        GtkFileChooserAction* chooser_action)
{
	Block11Data* _data11_;
	GFile* _result_ = NULL;
	gchar* title = NULL;
	gchar* _tmp0_;
	gchar* accept_button_label = NULL;
	gchar* _tmp1_;
	GList* filters = NULL;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
#line 124 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	static GQuark _tmp3_label0 = 0;
#line 124 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	static GQuark _tmp3_label1 = 0;
#line 124 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	static GQuark _tmp3_label2 = 0;
#line 124 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	static GQuark _tmp3_label3 = 0;
#line 1216 "FileManager.c"
	GtkFileChooserAction _tmp32_;
	GtkFileFilter* all_filter = NULL;
	GtkFileFilter* _tmp38_;
	GtkFileFilter* _tmp39_;
	GtkFileFilter* _tmp40_;
	GtkFileFilter* _tmp41_;
	GtkFileFilter* _tmp42_;
	const gchar* _tmp43_;
	ENotesApplication* _tmp44_;
	GtkWindow* _tmp45_;
	const gchar* _tmp46_;
	GtkFileChooserDialog* _tmp47_;
	GList* _tmp48_;
	GtkFileChooserDialog* _tmp49_;
	GtkFileChooserDialog* _tmp52_;
	GFile* result;
#line 117 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	g_return_val_if_fail (filetype != NULL, NULL);
#line 117 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_data11_ = g_slice_new0 (Block11Data);
#line 117 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_data11_->_ref_count_ = 1;
#line 118 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_result_ = NULL;
#line 120 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp0_ = g_strdup ("");
#line 120 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	title = _tmp0_;
#line 121 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp1_ = g_strdup ("");
#line 121 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	accept_button_label = _tmp1_;
#line 122 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	filters = NULL;
#line 124 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp2_ = filetype;
#line 124 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
#line 124 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("pdf")))) {
#line 124 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		switch (0) {
#line 1259 "FileManager.c"
			default:
			{
				gchar* _tmp5_;
				GtkFileFilter* filter = NULL;
				GtkFileFilter* _tmp6_;
				GtkFileFilter* _tmp7_;
				GtkFileFilter* _tmp8_;
				GtkFileFilter* _tmp9_;
				GtkFileFilter* _tmp10_;
				GtkFileFilter* _tmp11_;
#line 126 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp5_ = g_strdup (_ ("Save as PDF"));
#line 126 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_g_free0 (title);
#line 126 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				title = _tmp5_;
#line 127 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp6_ = gtk_file_filter_new ();
#line 127 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				g_object_ref_sink (_tmp6_);
#line 127 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				filter = _tmp6_;
#line 128 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp7_ = filter;
#line 128 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				gtk_file_filter_set_name (_tmp7_, _ ("PDF File"));
#line 130 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp8_ = filter;
#line 130 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				gtk_file_filter_add_mime_type (_tmp8_, "application/pdf");
#line 131 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp9_ = filter;
#line 131 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				gtk_file_filter_add_pattern (_tmp9_, "*.pdf");
#line 133 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp10_ = filter;
#line 133 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp11_ = _g_object_ref0 (_tmp10_);
#line 133 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				filters = g_list_append (filters, _tmp11_);
#line 134 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_g_object_unref0 (filter);
#line 134 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				break;
#line 1304 "FileManager.c"
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("md")))) {
#line 124 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		switch (0) {
#line 1310 "FileManager.c"
			default:
			{
				gchar* _tmp12_;
				GtkFileFilter* filter = NULL;
				GtkFileFilter* _tmp13_;
				GtkFileFilter* _tmp14_;
				GtkFileFilter* _tmp15_;
				GtkFileFilter* _tmp16_;
				GtkFileFilter* _tmp17_;
				GtkFileFilter* _tmp18_;
#line 136 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp12_ = g_strdup (_ ("Save as Markdown"));
#line 136 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_g_free0 (title);
#line 136 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				title = _tmp12_;
#line 137 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp13_ = gtk_file_filter_new ();
#line 137 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				g_object_ref_sink (_tmp13_);
#line 137 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				filter = _tmp13_;
#line 138 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp14_ = filter;
#line 138 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				gtk_file_filter_set_name (_tmp14_, _ ("Markdown File"));
#line 140 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp15_ = filter;
#line 140 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				gtk_file_filter_add_mime_type (_tmp15_, "text/markdown");
#line 141 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp16_ = filter;
#line 141 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				gtk_file_filter_add_pattern (_tmp16_, "*.md");
#line 143 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp17_ = filter;
#line 143 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp18_ = _g_object_ref0 (_tmp17_);
#line 143 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				filters = g_list_append (filters, _tmp18_);
#line 144 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_g_object_unref0 (filter);
#line 144 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				break;
#line 1355 "FileManager.c"
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("image")))) {
#line 124 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		switch (0) {
#line 1361 "FileManager.c"
			default:
			{
				gchar* _tmp19_;
				GtkFileFilter* filter = NULL;
				GtkFileFilter* _tmp20_;
				GtkFileFilter* _tmp21_;
				GtkFileFilter* _tmp22_;
				GtkFileFilter* _tmp23_;
				GtkFileFilter* _tmp24_;
#line 146 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp19_ = g_strdup (_ ("Open Image"));
#line 146 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_g_free0 (title);
#line 146 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				title = _tmp19_;
#line 148 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp20_ = gtk_file_filter_new ();
#line 148 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				g_object_ref_sink (_tmp20_);
#line 148 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				filter = _tmp20_;
#line 149 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp21_ = filter;
#line 149 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				gtk_file_filter_set_name (_tmp21_, _ ("Images"));
#line 150 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp22_ = filter;
#line 150 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				gtk_file_filter_add_mime_type (_tmp22_, "image/*");
#line 152 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp23_ = filter;
#line 152 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp24_ = _g_object_ref0 (_tmp23_);
#line 152 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				filters = g_list_append (filters, _tmp24_);
#line 153 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_g_object_unref0 (filter);
#line 153 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				break;
#line 1401 "FileManager.c"
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label3) ? _tmp3_label3 : (_tmp3_label3 = g_quark_from_static_string ("ndb")))) {
#line 124 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		switch (0) {
#line 1407 "FileManager.c"
			default:
			{
				gchar* _tmp25_;
				GtkFileFilter* filter = NULL;
				GtkFileFilter* _tmp26_;
				GtkFileFilter* _tmp27_;
				GtkFileFilter* _tmp28_;
				GtkFileFilter* _tmp29_;
				GtkFileFilter* _tmp30_;
				GtkFileFilter* _tmp31_;
#line 155 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp25_ = g_strdup (_ ("Create or Open a Notes-Up File"));
#line 155 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_g_free0 (title);
#line 155 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				title = _tmp25_;
#line 157 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp26_ = gtk_file_filter_new ();
#line 157 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				g_object_ref_sink (_tmp26_);
#line 157 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				filter = _tmp26_;
#line 158 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp27_ = filter;
#line 158 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				gtk_file_filter_set_name (_tmp27_, _ ("Notes-Up Notebook"));
#line 159 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp28_ = filter;
#line 159 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				gtk_file_filter_add_mime_type (_tmp28_, "application/x-notesup");
#line 160 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp29_ = filter;
#line 160 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				gtk_file_filter_add_pattern (_tmp29_, "*.ndb");
#line 162 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp30_ = filter;
#line 162 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_tmp31_ = _g_object_ref0 (_tmp30_);
#line 162 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				filters = g_list_append (filters, _tmp31_);
#line 163 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				_g_object_unref0 (filter);
#line 163 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				break;
#line 1452 "FileManager.c"
			}
		}
	} else {
#line 124 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		switch (0) {
#line 1458 "FileManager.c"
			default:
			{
#line 165 "../Notes-up-2.0.6/src/Services/FileManager.vala"
				g_assert_not_reached ();
#line 1463 "FileManager.c"
			}
		}
	}
#line 168 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp32_ = GTK_FILE_CHOOSER_ACTION_SAVE;
#line 168 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	if (_gtk_file_chooser_action_equal (chooser_action, &_tmp32_) == TRUE) {
#line 1471 "FileManager.c"
		gchar* _tmp33_;
#line 169 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp33_ = g_strdup (_ ("Save"));
#line 169 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_free0 (accept_button_label);
#line 169 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		accept_button_label = _tmp33_;
#line 1479 "FileManager.c"
	} else {
		GtkFileChooserAction _tmp34_;
#line 170 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp34_ = GTK_FILE_CHOOSER_ACTION_OPEN;
#line 170 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		if (_gtk_file_chooser_action_equal (chooser_action, &_tmp34_) == TRUE) {
#line 1486 "FileManager.c"
			gchar* _tmp35_;
#line 171 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			_tmp35_ = g_strdup (_ ("Open"));
#line 171 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			_g_free0 (accept_button_label);
#line 171 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			accept_button_label = _tmp35_;
#line 1494 "FileManager.c"
		} else {
			gchar* _tmp36_;
			GtkFileChooserAction _tmp37_;
#line 173 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			_tmp36_ = g_strdup (_ ("Open or Create"));
#line 173 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			_g_free0 (accept_button_label);
#line 173 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			accept_button_label = _tmp36_;
#line 174 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			_tmp37_ = GTK_FILE_CHOOSER_ACTION_SAVE;
#line 174 "../Notes-up-2.0.6/src/Services/FileManager.vala"
			chooser_action = &_tmp37_;
#line 1508 "FileManager.c"
		}
	}
#line 177 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp38_ = gtk_file_filter_new ();
#line 177 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	g_object_ref_sink (_tmp38_);
#line 177 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	all_filter = _tmp38_;
#line 178 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp39_ = all_filter;
#line 178 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	gtk_file_filter_set_name (_tmp39_, _ ("All Files"));
#line 179 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp40_ = all_filter;
#line 179 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	gtk_file_filter_add_pattern (_tmp40_, "*");
#line 181 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp41_ = all_filter;
#line 181 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp42_ = _g_object_ref0 (_tmp41_);
#line 181 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	filters = g_list_append (filters, _tmp42_);
#line 183 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp43_ = title;
#line 183 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp44_ = enotes_app;
#line 183 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp45_ = gtk_application_get_active_window ((GtkApplication*) _tmp44_);
#line 183 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp46_ = accept_button_label;
#line 183 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp47_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp43_, _tmp45_, *chooser_action, _ ("Cancel"), GTK_RESPONSE_CANCEL, _tmp46_, GTK_RESPONSE_ACCEPT, NULL);
#line 183 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	g_object_ref_sink (_tmp47_);
#line 183 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_data11_->dialog = _tmp47_;
#line 191 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp48_ = filters;
#line 191 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	g_list_foreach (_tmp48_, ___lambda37__gfunc, _data11_);
#line 195 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp49_ = _data11_->dialog;
#line 195 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	if (gtk_dialog_run ((GtkDialog*) _tmp49_) == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 1553 "FileManager.c"
		GtkFileChooserDialog* _tmp50_;
		GFile* _tmp51_;
#line 196 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp50_ = _data11_->dialog;
#line 196 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_tmp51_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp50_);
#line 196 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_g_object_unref0 (_result_);
#line 196 "../Notes-up-2.0.6/src/Services/FileManager.vala"
		_result_ = _tmp51_;
#line 1564 "FileManager.c"
	}
#line 199 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_tmp52_ = _data11_->dialog;
#line 199 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	g_signal_emit_by_name ((GtkDialog*) _tmp52_, "close");
#line 201 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	result = _result_;
#line 201 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_g_object_unref0 (all_filter);
#line 201 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	(filters == NULL) ? NULL : (filters = (_g_list_free__g_object_unref0_ (filters), NULL));
#line 201 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_g_free0 (accept_button_label);
#line 201 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_g_free0 (title);
#line 201 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	block11_data_unref (_data11_);
#line 201 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	_data11_ = NULL;
#line 201 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	return result;
#line 1586 "FileManager.c"
}

ENotesFileManager*
enotes_file_manager_construct (GType object_type)
{
	ENotesFileManager * self = NULL;
#line 22 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	self = (ENotesFileManager*) g_object_new (object_type, NULL);
#line 22 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	return self;
#line 1597 "FileManager.c"
}

ENotesFileManager*
enotes_file_manager_new (void)
{
#line 22 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	return enotes_file_manager_construct (ENOTES_TYPE_FILE_MANAGER);
#line 1605 "FileManager.c"
}

static void
enotes_file_manager_class_init (ENotesFileManagerClass * klass,
                                gpointer klass_data)
{
#line 22 "../Notes-up-2.0.6/src/Services/FileManager.vala"
	enotes_file_manager_parent_class = g_type_class_peek_parent (klass);
#line 1614 "FileManager.c"
}

static void
enotes_file_manager_instance_init (ENotesFileManager * self,
                                   gpointer klass)
{
}

static GType
enotes_file_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesFileManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_file_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesFileManager), 0, (GInstanceInitFunc) enotes_file_manager_instance_init, NULL };
	GType enotes_file_manager_type_id;
	enotes_file_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "ENotesFileManager", &g_define_type_info, 0);
	return enotes_file_manager_type_id;
}

GType
enotes_file_manager_get_type (void)
{
	static volatile gsize enotes_file_manager_type_id__once = 0;
	if (g_once_init_enter (&enotes_file_manager_type_id__once)) {
		GType enotes_file_manager_type_id;
		enotes_file_manager_type_id = enotes_file_manager_get_type_once ();
		g_once_init_leave (&enotes_file_manager_type_id__once, enotes_file_manager_type_id);
	}
	return enotes_file_manager_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

