/* Bookmark.c generated by valac 0.56.12, the Vala compiler
 * generated from Bookmark.vala, do not modify */

/*
* Copyright (c) 2011-2016 Felipe Escoto (https://github.com/Philip-Scott/Notes-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <sqlite3.h>
#include <gee.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ENOTES_TYPE_BOOKMARK (enotes_bookmark_get_type ())
#define ENOTES_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_BOOKMARK, ENotesBookmark))
#define ENOTES_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_BOOKMARK, ENotesBookmarkClass))
#define ENOTES_IS_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_BOOKMARK))
#define ENOTES_IS_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_BOOKMARK))
#define ENOTES_BOOKMARK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_BOOKMARK, ENotesBookmarkClass))

typedef struct _ENotesBookmark ENotesBookmark;
typedef struct _ENotesBookmarkClass ENotesBookmarkClass;
typedef struct _ENotesBookmarkPrivate ENotesBookmarkPrivate;
enum  {
	ENOTES_BOOKMARK_0_PROPERTY,
	ENOTES_BOOKMARK_NUM_PROPERTIES
};
static GParamSpec* enotes_bookmark_properties[ENOTES_BOOKMARK_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define ENOTES_TYPE_BOOKMARK_TABLE (enotes_bookmark_table_get_type ())
#define ENOTES_BOOKMARK_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_BOOKMARK_TABLE, ENotesBookmarkTable))
#define ENOTES_BOOKMARK_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_BOOKMARK_TABLE, ENotesBookmarkTableClass))
#define ENOTES_IS_BOOKMARK_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_BOOKMARK_TABLE))
#define ENOTES_IS_BOOKMARK_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_BOOKMARK_TABLE))
#define ENOTES_BOOKMARK_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_BOOKMARK_TABLE, ENotesBookmarkTableClass))

typedef struct _ENotesBookmarkTable ENotesBookmarkTable;
typedef struct _ENotesBookmarkTableClass ENotesBookmarkTableClass;
typedef struct _ENotesBookmarkTablePrivate ENotesBookmarkTablePrivate;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))

#define ENOTES_TYPE_PAGE (enotes_page_get_type ())
#define ENOTES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGE, ENotesPage))
#define ENOTES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGE, ENotesPageClass))
#define ENOTES_IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGE))
#define ENOTES_IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGE))
#define ENOTES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGE, ENotesPageClass))

typedef struct _ENotesPage ENotesPage;
typedef struct _ENotesPageClass ENotesPageClass;
typedef struct _ENotesPagePrivate ENotesPagePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	ENOTES_BOOKMARK_TABLE_BOOKMARK_ADDED_SIGNAL,
	ENOTES_BOOKMARK_TABLE_BOOKMARK_REMOVED_SIGNAL,
	ENOTES_BOOKMARK_TABLE_NUM_SIGNALS
};
static guint enotes_bookmark_table_signals[ENOTES_BOOKMARK_TABLE_NUM_SIGNALS] = {0};

struct _ENotesBookmark {
	GObject parent_instance;
	ENotesBookmarkPrivate * priv;
	gint64 page_id;
	gchar* name;
	GdkRGBA color;
};

struct _ENotesBookmarkClass {
	GObjectClass parent_class;
};

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _ENotesBookmarkTable {
	DatabaseTable parent_instance;
	ENotesBookmarkTablePrivate * priv;
};

struct _ENotesBookmarkTableClass {
	DatabaseTableClass parent_class;
};

struct _ENotesPage {
	GObject parent_instance;
	ENotesPagePrivate * priv;
	gint64 id;
	gint64 notebook_id;
	gchar* name;
	gchar* data;
	gchar* subtitle;
	gchar* html_cache;
	gint64 creation_date;
	gint64 modification_date;
	gboolean new_page;
	gboolean cache_changed;
	gchar* full_path;
};

struct _ENotesPageClass {
	GObjectClass parent_class;
};

static gpointer enotes_bookmark_parent_class = NULL;
static gpointer enotes_bookmark_table_parent_class = NULL;
static ENotesBookmarkTable* enotes_bookmark_table_instance;
static ENotesBookmarkTable* enotes_bookmark_table_instance = NULL;

VALA_EXTERN GType enotes_bookmark_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesBookmark, g_object_unref)
VALA_EXTERN ENotesBookmark* enotes_bookmark_new (void);
VALA_EXTERN ENotesBookmark* enotes_bookmark_construct (GType object_type);
static void enotes_bookmark_finalize (GObject * obj);
static GType enotes_bookmark_get_type_once (void);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType enotes_bookmark_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesBookmarkTable, database_table_unref)
VALA_EXTERN ENotesBookmarkTable* enotes_bookmark_table_get_instance (void);
static ENotesBookmarkTable* enotes_bookmark_table_new (void);
static ENotesBookmarkTable* enotes_bookmark_table_construct (GType object_type);
VALA_EXTERN DatabaseTable* database_table_construct (GType object_type);
VALA_EXTERN sqlite3_stmt* database_table_create_stmt (const gchar* data);
VALA_EXTERN void database_table_fatal (const gchar* op,
                           gint res);
VALA_EXTERN void database_table_set_table_name (DatabaseTable* self,
                                    const gchar* table_name);
VALA_EXTERN GType enotes_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPage, g_object_unref)
VALA_EXTERN void enotes_bookmark_table_add (ENotesBookmarkTable* self,
                                ENotesPage* page);
VALA_EXTERN void database_table_bind_int (sqlite3_stmt* stmt,
                              gint column,
                              gint64 data);
VALA_EXTERN void enotes_bookmark_table_remove (ENotesBookmarkTable* self,
                                   gint64 page_id);
VALA_EXTERN GeeArrayList* enotes_bookmark_table_get_bookmarks (ENotesBookmarkTable* self);
VALA_EXTERN void enotes_bookmark_table_rename (ENotesBookmarkTable* self,
                                   gint64 id,
                                   const gchar* text);
VALA_EXTERN void database_table_bind_text (sqlite3_stmt* stmt,
                               gint column,
                               const gchar* data);
VALA_EXTERN gboolean enotes_bookmark_table_is_bookmarked (ENotesBookmarkTable* self,
                                              ENotesPage* page);
VALA_EXTERN void enotes_bookmark_table_reset_instance (void);
static void g_cclosure_user_marshal_VOID__INT64 (GClosure * closure,
                                          GValue * return_value,
                                          guint n_param_values,
                                          const GValue * param_values,
                                          gpointer invocation_hint,
                                          gpointer marshal_data);
static void enotes_bookmark_table_finalize (DatabaseTable * obj);
static GType enotes_bookmark_table_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

ENotesBookmark*
enotes_bookmark_construct (GType object_type)
{
	ENotesBookmark * self = NULL;
#line 22 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	self = (ENotesBookmark*) g_object_new (object_type, NULL);
#line 22 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	return self;
#line 230 "Bookmark.c"
}

ENotesBookmark*
enotes_bookmark_new (void)
{
#line 22 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	return enotes_bookmark_construct (ENOTES_TYPE_BOOKMARK);
#line 238 "Bookmark.c"
}

static void
enotes_bookmark_class_init (ENotesBookmarkClass * klass,
                            gpointer klass_data)
{
#line 22 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	enotes_bookmark_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	G_OBJECT_CLASS (klass)->finalize = enotes_bookmark_finalize;
#line 249 "Bookmark.c"
}

static void
enotes_bookmark_instance_init (ENotesBookmark * self,
                               gpointer klass)
{
}

static void
enotes_bookmark_finalize (GObject * obj)
{
	ENotesBookmark * self;
#line 22 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_BOOKMARK, ENotesBookmark);
#line 24 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	_g_free0 (self->name);
#line 22 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	G_OBJECT_CLASS (enotes_bookmark_parent_class)->finalize (obj);
#line 268 "Bookmark.c"
}

static GType
enotes_bookmark_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesBookmarkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_bookmark_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesBookmark), 0, (GInstanceInitFunc) enotes_bookmark_instance_init, NULL };
	GType enotes_bookmark_type_id;
	enotes_bookmark_type_id = g_type_register_static (G_TYPE_OBJECT, "ENotesBookmark", &g_define_type_info, 0);
	return enotes_bookmark_type_id;
}

GType
enotes_bookmark_get_type (void)
{
	static volatile gsize enotes_bookmark_type_id__once = 0;
	if (g_once_init_enter (&enotes_bookmark_type_id__once)) {
		GType enotes_bookmark_type_id;
		enotes_bookmark_type_id = enotes_bookmark_get_type_once ();
		g_once_init_leave (&enotes_bookmark_type_id__once, enotes_bookmark_type_id);
	}
	return enotes_bookmark_type_id__once;
}

static gpointer
_database_table_ref0 (gpointer self)
{
#line 39 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	return self ? database_table_ref (self) : NULL;
#line 297 "Bookmark.c"
}

ENotesBookmarkTable*
enotes_bookmark_table_get_instance (void)
{
	ENotesBookmarkTable* _tmp0_;
	ENotesBookmarkTable* _tmp2_;
	ENotesBookmarkTable* _tmp3_;
	ENotesBookmarkTable* result;
#line 35 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	_tmp0_ = enotes_bookmark_table_instance;
#line 35 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	if (_tmp0_ == NULL) {
#line 311 "Bookmark.c"
		ENotesBookmarkTable* _tmp1_;
#line 36 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
		_tmp1_ = enotes_bookmark_table_new ();
#line 36 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
		_database_table_unref0 (enotes_bookmark_table_instance);
#line 36 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
		enotes_bookmark_table_instance = _tmp1_;
#line 319 "Bookmark.c"
	}
#line 39 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	_tmp2_ = enotes_bookmark_table_instance;
#line 39 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	_tmp3_ = _database_table_ref0 (_tmp2_);
#line 39 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	result = _tmp3_;
#line 39 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	return result;
#line 329 "Bookmark.c"
}

static ENotesBookmarkTable*
enotes_bookmark_table_construct (GType object_type)
{
	ENotesBookmarkTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
#line 42 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	self = (ENotesBookmarkTable*) database_table_construct (object_type);
#line 43 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	_tmp0_ = database_table_create_stmt ("CREATE TABLE IF NOT EXISTS Bookmark (" "id INTEGER UNIQUE PRIMARY KEY, " "name TEXT)");
#line 43 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	stmt = _tmp0_;
#line 46 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	_tmp1_ = stmt;
#line 46 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	res = sqlite3_step (_tmp1_);
#line 48 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	if (res != SQLITE_DONE) {
#line 49 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
		database_table_fatal ("create bookmark table", res);
#line 354 "Bookmark.c"
	}
#line 52 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	database_table_set_table_name ((DatabaseTable*) self, "Bookmark");
#line 42 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	_sqlite3_finalize0 (stmt);
#line 42 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	return self;
#line 362 "Bookmark.c"
}

static ENotesBookmarkTable*
enotes_bookmark_table_new (void)
{
#line 42 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	return enotes_bookmark_table_construct (ENOTES_TYPE_BOOKMARK_TABLE);
#line 370 "Bookmark.c"
}

void
enotes_bookmark_table_add (ENotesBookmarkTable* self,
                           ENotesPage* page)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
#line 55 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	g_return_if_fail (self != NULL);
#line 55 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	g_return_if_fail (page != NULL);
#line 56 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	_tmp0_ = database_table_create_stmt ("INSERT INTO Bookmark (id) values (?)");
#line 56 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	stmt = _tmp0_;
#line 57 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	database_table_bind_int (stmt, 1, page->id);
#line 58 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	sqlite3_step (stmt);
#line 60 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	g_signal_emit (self, enotes_bookmark_table_signals[ENOTES_BOOKMARK_TABLE_BOOKMARK_ADDED_SIGNAL], 0);
#line 55 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	_sqlite3_finalize0 (stmt);
#line 395 "Bookmark.c"
}

void
enotes_bookmark_table_remove (ENotesBookmarkTable* self,
                              gint64 page_id)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
#line 63 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	g_return_if_fail (self != NULL);
#line 64 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	_tmp0_ = database_table_create_stmt ("DELETE FROM Bookmark Where id = ?");
#line 64 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	stmt = _tmp0_;
#line 65 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	database_table_bind_int (stmt, 1, page_id);
#line 66 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	sqlite3_step (stmt);
#line 68 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	g_signal_emit (self, enotes_bookmark_table_signals[ENOTES_BOOKMARK_TABLE_BOOKMARK_REMOVED_SIGNAL], 0, page_id);
#line 63 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	_sqlite3_finalize0 (stmt);
#line 418 "Bookmark.c"
}

GeeArrayList*
enotes_bookmark_table_get_bookmarks (ENotesBookmarkTable* self)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	GeeArrayList* bookmarks = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* result;
#line 71 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 72 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	_tmp0_ = database_table_create_stmt ("SELECT Page.id, Page.name, Notebook.rgb, Bookmark.name " "FROM Bookmark JOIN Page on Bookmark.id = Page.id " "JOIN Notebook on page.notebook_id = Notebook.id");
#line 72 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	stmt = _tmp0_;
#line 76 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	_tmp1_ = gee_array_list_new (ENOTES_TYPE_BOOKMARK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 76 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	bookmarks = _tmp1_;
#line 439 "Bookmark.c"
	{
		gboolean _tmp2_ = FALSE;
#line 78 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
		_tmp2_ = TRUE;
#line 78 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
		while (TRUE) {
#line 446 "Bookmark.c"
			gint res = 0;
			sqlite3_stmt* _tmp3_;
			ENotesBookmark* row = NULL;
			ENotesBookmark* _tmp4_;
			ENotesBookmark* _tmp5_;
			sqlite3_stmt* _tmp6_;
			sqlite3_stmt* _tmp7_;
			const gchar* _tmp8_;
			GdkRGBA rgba = {0};
			GdkRGBA _tmp17_ = {0};
			sqlite3_stmt* _tmp18_;
			const gchar* _tmp19_;
			ENotesBookmark* _tmp20_;
			GdkRGBA _tmp21_;
			GeeArrayList* _tmp22_;
			ENotesBookmark* _tmp23_;
#line 78 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			if (!_tmp2_) {
#line 465 "Bookmark.c"
			}
#line 78 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			_tmp2_ = FALSE;
#line 79 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			_tmp3_ = stmt;
#line 79 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			res = sqlite3_step (_tmp3_);
#line 80 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			if (res == SQLITE_DONE) {
#line 81 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
				break;
#line 477 "Bookmark.c"
			} else {
#line 82 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
				if (res != SQLITE_ROW) {
#line 83 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
					database_table_fatal ("get bookmarks", res);
#line 84 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
					break;
#line 485 "Bookmark.c"
				}
			}
#line 87 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			_tmp4_ = enotes_bookmark_new ();
#line 87 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			row = _tmp4_;
#line 89 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			_tmp5_ = row;
#line 89 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			_tmp6_ = stmt;
#line 89 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			_tmp5_->page_id = sqlite3_column_int64 (_tmp6_, 0);
#line 91 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			_tmp7_ = stmt;
#line 91 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			_tmp8_ = (const gchar*) sqlite3_column_text (_tmp7_, 3);
#line 91 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			if (_tmp8_ != NULL) {
#line 504 "Bookmark.c"
				ENotesBookmark* _tmp9_;
				sqlite3_stmt* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
#line 92 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
				_tmp9_ = row;
#line 92 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
				_tmp10_ = stmt;
#line 92 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
				_tmp11_ = (const gchar*) sqlite3_column_text (_tmp10_, 3);
#line 92 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
				_tmp12_ = g_strdup (_tmp11_);
#line 92 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
				_g_free0 (_tmp9_->name);
#line 92 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
				_tmp9_->name = _tmp12_;
#line 521 "Bookmark.c"
			} else {
				ENotesBookmark* _tmp13_;
				sqlite3_stmt* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
#line 94 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
				_tmp13_ = row;
#line 94 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
				_tmp14_ = stmt;
#line 94 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
				_tmp15_ = (const gchar*) sqlite3_column_text (_tmp14_, 1);
#line 94 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
				_tmp16_ = g_strdup (_tmp15_);
#line 94 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
				_g_free0 (_tmp13_->name);
#line 94 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
				_tmp13_->name = _tmp16_;
#line 539 "Bookmark.c"
			}
#line 97 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			rgba = _tmp17_;
#line 98 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			_tmp18_ = stmt;
#line 98 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			_tmp19_ = (const gchar*) sqlite3_column_text (_tmp18_, 2);
#line 98 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			gdk_rgba_parse (&rgba, _tmp19_);
#line 99 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			_tmp20_ = row;
#line 99 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			_tmp21_ = rgba;
#line 99 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			_tmp20_->color = _tmp21_;
#line 101 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			_tmp22_ = bookmarks;
#line 101 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			_tmp23_ = row;
#line 101 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
#line 78 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
			_g_object_unref0 (row);
#line 563 "Bookmark.c"
		}
	}
#line 104 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	result = bookmarks;
#line 104 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	_sqlite3_finalize0 (stmt);
#line 104 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	return result;
#line 572 "Bookmark.c"
}

void
enotes_bookmark_table_rename (ENotesBookmarkTable* self,
                              gint64 id,
                              const gchar* text)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
#line 107 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	g_return_if_fail (self != NULL);
#line 107 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	g_return_if_fail (text != NULL);
#line 108 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	_tmp0_ = database_table_create_stmt ("UPDATE Bookmark SET name = ? WHERE id = ?");
#line 108 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	stmt = _tmp0_;
#line 109 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	database_table_bind_text (stmt, 1, text);
#line 110 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	database_table_bind_int (stmt, 2, id);
#line 111 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	sqlite3_step (stmt);
#line 107 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	_sqlite3_finalize0 (stmt);
#line 598 "Bookmark.c"
}

gboolean
enotes_bookmark_table_is_bookmarked (ENotesBookmarkTable* self,
                                     ENotesPage* page)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gboolean result;
#line 114 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 115 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	_tmp0_ = database_table_create_stmt ("SELECT CAST(CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END AS INTEGER) FROM " \
"Bookmark WHERE Bookmark.id = ?");
#line 115 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	stmt = _tmp0_;
#line 116 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	database_table_bind_int (stmt, 1, page->id);
#line 117 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	sqlite3_step (stmt);
#line 119 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	result = sqlite3_column_int64 (stmt, 0) == ((gint64) 1);
#line 119 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	_sqlite3_finalize0 (stmt);
#line 119 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	return result;
#line 624 "Bookmark.c"
}

void
enotes_bookmark_table_reset_instance (void)
{
#line 123 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	_database_table_unref0 (enotes_bookmark_table_instance);
#line 123 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	enotes_bookmark_table_instance = NULL;
#line 634 "Bookmark.c"
}

static void
g_cclosure_user_marshal_VOID__INT64 (GClosure * closure,
                                     GValue * return_value,
                                     guint n_param_values,
                                     const GValue * param_values,
                                     gpointer invocation_hint,
                                     gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT64) (gpointer data1, gint64 arg_1, gpointer data2);
	register GMarshalFunc_VOID__INT64 callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 28 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	g_return_if_fail (n_param_values == 2);
#line 28 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 28 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
		data1 = closure->data;
#line 28 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
		data2 = param_values->data[0].v_pointer;
#line 659 "Bookmark.c"
	} else {
#line 28 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
		data1 = param_values->data[0].v_pointer;
#line 28 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
		data2 = closure->data;
#line 665 "Bookmark.c"
	}
#line 28 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	callback = (GMarshalFunc_VOID__INT64) (marshal_data ? marshal_data : cc->callback);
#line 28 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	callback (data1, g_value_get_int64 (param_values + 1), data2);
#line 671 "Bookmark.c"
}

static void
enotes_bookmark_table_class_init (ENotesBookmarkTableClass * klass,
                                  gpointer klass_data)
{
#line 28 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	enotes_bookmark_table_parent_class = g_type_class_peek_parent (klass);
#line 28 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	((DatabaseTableClass *) klass)->finalize = enotes_bookmark_table_finalize;
#line 28 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	enotes_bookmark_table_signals[ENOTES_BOOKMARK_TABLE_BOOKMARK_ADDED_SIGNAL] = g_signal_new ("bookmark-added", ENOTES_TYPE_BOOKMARK_TABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 28 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	enotes_bookmark_table_signals[ENOTES_BOOKMARK_TABLE_BOOKMARK_REMOVED_SIGNAL] = g_signal_new ("bookmark-removed", ENOTES_TYPE_BOOKMARK_TABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT64, G_TYPE_NONE, 1, G_TYPE_INT64);
#line 686 "Bookmark.c"
}

static void
enotes_bookmark_table_instance_init (ENotesBookmarkTable * self,
                                     gpointer klass)
{
}

static void
enotes_bookmark_table_finalize (DatabaseTable * obj)
{
	ENotesBookmarkTable * self;
#line 28 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_BOOKMARK_TABLE, ENotesBookmarkTable);
#line 28 "../Notes-up-2.0.6/src/Services/Bookmark.vala"
	DATABASE_TABLE_CLASS (enotes_bookmark_table_parent_class)->finalize (obj);
#line 703 "Bookmark.c"
}

static GType
enotes_bookmark_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesBookmarkTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_bookmark_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesBookmarkTable), 0, (GInstanceInitFunc) enotes_bookmark_table_instance_init, NULL };
	GType enotes_bookmark_table_type_id;
	enotes_bookmark_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "ENotesBookmarkTable", &g_define_type_info, 0);
	return enotes_bookmark_table_type_id;
}

GType
enotes_bookmark_table_get_type (void)
{
	static volatile gsize enotes_bookmark_table_type_id__once = 0;
	if (g_once_init_enter (&enotes_bookmark_table_type_id__once)) {
		GType enotes_bookmark_table_type_id;
		enotes_bookmark_table_type_id = enotes_bookmark_table_get_type_once ();
		g_once_init_leave (&enotes_bookmark_table_type_id__once, enotes_bookmark_table_type_id);
	}
	return enotes_bookmark_table_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

