/* Color.c generated by valac 0.56.12, the Vala compiler
 * generated from Color.vala, do not modify */

/*
* Copyright (c) 2016 Felipe Escoto (https://github.com/Philip-Scott/Notes-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ENOTES_TYPE_PLUGIN (enotes_plugin_get_type ())
#define ENOTES_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PLUGIN, ENotesPlugin))
#define ENOTES_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PLUGIN, ENotesPluginClass))
#define ENOTES_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PLUGIN))
#define ENOTES_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PLUGIN))
#define ENOTES_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PLUGIN, ENotesPluginClass))

typedef struct _ENotesPlugin ENotesPlugin;
typedef struct _ENotesPluginClass ENotesPluginClass;
typedef struct _ENotesPluginPrivate ENotesPluginPrivate;

#define TYPE_BL_MEMBER (bl_member_get_type ())
#define BL_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BL_MEMBER, BLMember))
#define BL_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BL_MEMBER, BLMemberClass))
#define IS_BL_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BL_MEMBER))
#define IS_BL_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BL_MEMBER))
#define BL_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BL_MEMBER, BLMemberClass))

typedef struct _BLMember BLMember;
typedef struct _BLMemberClass BLMemberClass;

#define ENOTES_TYPE_COLOR (enotes_color_get_type ())
#define ENOTES_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_COLOR, ENotesColor))
#define ENOTES_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_COLOR, ENotesColorClass))
#define ENOTES_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_COLOR))
#define ENOTES_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_COLOR))
#define ENOTES_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_COLOR, ENotesColorClass))

typedef struct _ENotesColor ENotesColor;
typedef struct _ENotesColorClass ENotesColorClass;
typedef struct _ENotesColorPrivate ENotesColorPrivate;
enum  {
	ENOTES_COLOR_0_PROPERTY,
	ENOTES_COLOR_NUM_PROPERTIES
};
static GParamSpec* enotes_color_properties[ENOTES_COLOR_NUM_PROPERTIES];
#define _g_pattern_spec_free0(var) ((var == NULL) ? NULL : (var = (g_pattern_spec_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _bl_member_unref0(var) ((var == NULL) ? NULL : (var = (bl_member_unref (var), NULL)))

struct _ENotesPlugin {
	GObject parent_instance;
	ENotesPluginPrivate * priv;
	gboolean state;
	gchar* code_name;
};

struct _ENotesPluginClass {
	GObjectClass parent_class;
	gchar* (*get_desctiption) (ENotesPlugin* self);
	gchar* (*get_name) (ENotesPlugin* self);
	gboolean (*has_match) (ENotesPlugin* self, const gchar* text);
	gchar* (*convert) (ENotesPlugin* self, const gchar* line);
	GtkWidget* (*editor_button) (ENotesPlugin* self);
	gchar* (*get_button_desctiption) (ENotesPlugin* self);
	gchar* (*request_string) (ENotesPlugin* self, const gchar* selection);
	GeeList* (*get_blacklist_members) (ENotesPlugin* self);
};

struct _ENotesColor {
	ENotesPlugin parent_instance;
	ENotesColorPrivate * priv;
};

struct _ENotesColorClass {
	ENotesPluginClass parent_class;
};

struct _ENotesColorPrivate {
	GPatternSpec* spec;
	GtkColorChooserWidget* color_selector;
	GtkPopover* popover;
	gchar* selection;
};

static gint ENotesColor_private_offset;
static gpointer enotes_color_parent_class = NULL;

VALA_EXTERN GType enotes_plugin_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPlugin, g_object_unref)
VALA_EXTERN gpointer bl_member_ref (gpointer instance);
VALA_EXTERN void bl_member_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_bl_member (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_bl_member (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_bl_member (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_bl_member (const GValue* value);
VALA_EXTERN GType bl_member_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BLMember, bl_member_unref)
VALA_EXTERN GType enotes_color_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesColor, g_object_unref)
VALA_EXTERN gchar* enotes_plugin_get_desctiption (ENotesPlugin* self);
VALA_EXTERN gchar* enotes_plugin_get_name (ENotesPlugin* self);
VALA_EXTERN GtkWidget* enotes_plugin_editor_button (ENotesPlugin* self);
VALA_EXTERN gchar* enotes_plugin_get_button_desctiption (ENotesPlugin* self);
VALA_EXTERN gchar* enotes_plugin_request_string (ENotesPlugin* self,
                                     const gchar* selection);
VALA_EXTERN gboolean enotes_plugin_has_match (ENotesPlugin* self,
                                  const gchar* text);
VALA_EXTERN gchar* enotes_plugin_convert (ENotesPlugin* self,
                              const gchar* line);
VALA_EXTERN GeeList* enotes_plugin_get_blacklist_members (ENotesPlugin* self);
static gchar* enotes_color_real_get_desctiption (ENotesPlugin* base);
static gchar* enotes_color_real_get_name (ENotesPlugin* base);
static GtkWidget* enotes_color_real_editor_button (ENotesPlugin* base);
static void __lambda4_ (ENotesColor* self);
static void ___lambda4__gtk_widget_hide (GtkWidget* _sender,
                                  gpointer self);
static void __lambda5_ (ENotesColor* self);
static void ___lambda5__gtk_color_chooser_color_activated (GtkColorChooser* _sender,
                                                    GdkRGBA* color,
                                                    gpointer self);
static gchar* enotes_color_real_get_button_desctiption (ENotesPlugin* base);
static gchar* enotes_color_real_request_string (ENotesPlugin* base,
                                         const gchar* selection);
static gboolean enotes_color_real_has_match (ENotesPlugin* base,
                                      const gchar* text);
static gchar* enotes_color_real_convert (ENotesPlugin* base,
                                  const gchar* line_);
static GeeList* enotes_color_real_get_blacklist_members (ENotesPlugin* base);
VALA_EXTERN BLMember* bl_member_new (GRegex* reg,
                         const gchar* replace);
VALA_EXTERN BLMember* bl_member_construct (GType object_type,
                               GRegex* reg,
                               const gchar* replace);
VALA_EXTERN ENotesColor* enotes_color_new (void);
VALA_EXTERN ENotesColor* enotes_color_construct (GType object_type);
VALA_EXTERN ENotesPlugin* enotes_plugin_construct (GType object_type);
static GObject * enotes_color_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void enotes_color_finalize (GObject * obj);
static GType enotes_color_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GRegex* _tmp_regex_0 = NULL;

static inline gpointer
enotes_color_get_instance_private (ENotesColor* self)
{
	return G_STRUCT_MEMBER_P (self, ENotesColor_private_offset);
}

static gchar*
enotes_color_real_get_desctiption (ENotesPlugin* base)
{
	ENotesColor * self;
	gchar* _tmp0_;
	gchar* result;
#line 34 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	self = (ENotesColor*) base;
#line 35 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp0_ = g_strdup (_ ("Set font color for the line with <color [#color]> or for some text wit" \
"h <color [color] [text]>"));
#line 35 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	result = _tmp0_;
#line 35 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	return result;
#line 210 "Color.c"
}

static gchar*
enotes_color_real_get_name (ENotesPlugin* base)
{
	ENotesColor * self;
	gchar* _tmp0_;
	gchar* result;
#line 38 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	self = (ENotesColor*) base;
#line 39 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp0_ = g_strdup (_ ("Font color"));
#line 39 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	result = _tmp0_;
#line 39 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	return result;
#line 227 "Color.c"
}

static void
__lambda4_ (ENotesColor* self)
{
	GtkColorChooserWidget* _tmp0_;
#line 52 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp0_ = self->priv->color_selector;
#line 52 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	g_object_set (_tmp0_, "show-editor", FALSE, NULL);
#line 238 "Color.c"
}

static void
___lambda4__gtk_widget_hide (GtkWidget* _sender,
                             gpointer self)
{
#line 51 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	__lambda4_ ((ENotesColor*) self);
#line 247 "Color.c"
}

static void
__lambda5_ (ENotesColor* self)
{
	GtkPopover* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
#line 56 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp0_ = self->priv->popover;
#line 56 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 58 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp1_ = self->priv->selection;
#line 58 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp2_ = strlen (_tmp1_);
#line 58 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp3_ = _tmp2_;
#line 58 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	if (_tmp3_ > 0) {
#line 269 "Color.c"
		GtkColorChooserWidget* _tmp4_;
		GdkRGBA _tmp5_ = {0};
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
#line 59 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_tmp4_ = self->priv->color_selector;
#line 59 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp4_, &_tmp5_);
#line 59 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_tmp6_ = gdk_rgba_to_string (&_tmp5_);
#line 59 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_tmp7_ = _tmp6_;
#line 59 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_tmp8_ = g_strconcat ("<color ", _tmp7_, NULL);
#line 59 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_tmp9_ = _tmp8_;
#line 59 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_tmp10_ = g_strconcat (_tmp9_, " ", NULL);
#line 59 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_tmp11_ = _tmp10_;
#line 59 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_tmp12_ = self->priv->selection;
#line 59 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_tmp13_ = g_strconcat (_tmp11_, _tmp12_, NULL);
#line 59 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_tmp14_ = _tmp13_;
#line 59 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_tmp15_ = g_strconcat (_tmp14_, ">", NULL);
#line 59 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_tmp16_ = _tmp15_;
#line 59 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		g_signal_emit_by_name ((ENotesPlugin*) self, "string-cooked", _tmp16_);
#line 59 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_g_free0 (_tmp16_);
#line 59 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_g_free0 (_tmp14_);
#line 59 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_g_free0 (_tmp11_);
#line 59 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_g_free0 (_tmp9_);
#line 59 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_g_free0 (_tmp7_);
#line 321 "Color.c"
	} else {
		GtkColorChooserWidget* _tmp17_;
		GdkRGBA _tmp18_ = {0};
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
#line 61 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_tmp17_ = self->priv->color_selector;
#line 61 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp17_, &_tmp18_);
#line 61 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_tmp19_ = gdk_rgba_to_string (&_tmp18_);
#line 61 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_tmp20_ = _tmp19_;
#line 61 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_tmp21_ = g_strconcat ("<color ", _tmp20_, NULL);
#line 61 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_tmp22_ = _tmp21_;
#line 61 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_tmp23_ = g_strconcat (_tmp22_, ">", NULL);
#line 61 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_tmp24_ = _tmp23_;
#line 61 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		g_signal_emit_by_name ((ENotesPlugin*) self, "string-cooked", _tmp24_);
#line 61 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_g_free0 (_tmp24_);
#line 61 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_g_free0 (_tmp22_);
#line 61 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_g_free0 (_tmp20_);
#line 355 "Color.c"
	}
}

static void
___lambda5__gtk_color_chooser_color_activated (GtkColorChooser* _sender,
                                               GdkRGBA* color,
                                               gpointer self)
{
#line 55 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	__lambda5_ ((ENotesColor*) self);
#line 366 "Color.c"
}

static GtkWidget*
enotes_color_real_editor_button (ENotesPlugin* base)
{
	ENotesColor * self;
	GtkImage* image = NULL;
	GtkImage* _tmp0_;
	GtkPopover* _tmp1_;
	GtkColorChooserWidget* _tmp2_;
	GtkColorChooserWidget* _tmp3_;
	GtkPopover* _tmp4_;
	GtkColorChooserWidget* _tmp5_;
	GtkPopover* _tmp6_;
	GtkColorChooserWidget* _tmp7_;
	GtkWidget* result;
#line 42 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	self = (ENotesColor*) base;
#line 43 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("applications-graphics", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
#line 43 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	g_object_ref_sink (_tmp0_);
#line 43 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	image = _tmp0_;
#line 45 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp1_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) image);
#line 45 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	g_object_ref_sink (_tmp1_);
#line 45 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_g_object_unref0 (self->priv->popover);
#line 45 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	self->priv->popover = _tmp1_;
#line 46 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp2_ = (GtkColorChooserWidget*) gtk_color_chooser_widget_new ();
#line 46 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	g_object_ref_sink (_tmp2_);
#line 46 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_g_object_unref0 (self->priv->color_selector);
#line 46 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	self->priv->color_selector = _tmp2_;
#line 47 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp3_ = self->priv->color_selector;
#line 47 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	g_object_set ((GtkWidget*) _tmp3_, "margin", 6, NULL);
#line 49 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp4_ = self->priv->popover;
#line 49 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp5_ = self->priv->color_selector;
#line 49 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
#line 51 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp6_ = self->priv->popover;
#line 51 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	g_signal_connect_object ((GtkWidget*) _tmp6_, "hide", (GCallback) ___lambda4__gtk_widget_hide, self, 0);
#line 55 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp7_ = self->priv->color_selector;
#line 55 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	g_signal_connect_object ((GtkColorChooser*) _tmp7_, "color-activated", (GCallback) ___lambda5__gtk_color_chooser_color_activated, self, 0);
#line 64 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	result = (GtkWidget*) image;
#line 64 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	return result;
#line 429 "Color.c"
}

static gchar*
enotes_color_real_get_button_desctiption (ENotesPlugin* base)
{
	ENotesColor * self;
	gchar* _tmp0_;
	gchar* result;
#line 67 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	self = (ENotesColor*) base;
#line 68 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp0_ = g_strdup (_ ("Font color"));
#line 68 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	result = _tmp0_;
#line 68 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	return result;
#line 446 "Color.c"
}

static gchar*
enotes_color_real_request_string (ENotesPlugin* base,
                                  const gchar* selection)
{
	ENotesColor * self;
	GtkPopover* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
#line 71 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	self = (ENotesColor*) base;
#line 71 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	g_return_val_if_fail (selection != NULL, NULL);
#line 72 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp0_ = self->priv->popover;
#line 72 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp0_);
#line 73 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp1_ = g_strdup (selection);
#line 73 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_g_free0 (self->priv->selection);
#line 73 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	self->priv->selection = _tmp1_;
#line 75 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp2_ = g_strdup ("");
#line 75 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	result = _tmp2_;
#line 75 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	return result;
#line 478 "Color.c"
}

static gboolean
enotes_color_real_has_match (ENotesPlugin* base,
                             const gchar* text)
{
	ENotesColor * self;
	GPatternSpec* _tmp0_;
	gboolean result;
#line 78 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	self = (ENotesColor*) base;
#line 78 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	g_return_val_if_fail (text != NULL, FALSE);
#line 79 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp0_ = self->priv->spec;
#line 79 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	result = g_pattern_match_string (_tmp0_, text);
#line 79 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	return result;
#line 498 "Color.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
#line 1240 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1241 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1241 "glib-2.0.vapi"
	result = _tmp0_;
#line 1241 "glib-2.0.vapi"
	return result;
#line 515 "Color.c"
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
#line 1488 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1489 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1489 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1489 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1490 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1491 "glib-2.0.vapi"
		start = string_length + start;
#line 542 "Color.c"
	}
#line 1493 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1494 "glib-2.0.vapi"
		end = string_length + end;
#line 548 "Color.c"
	}
#line 1496 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1496 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 554 "Color.c"
	} else {
#line 1496 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 558 "Color.c"
	}
#line 1496 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1497 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1497 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 566 "Color.c"
	} else {
#line 1497 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 570 "Color.c"
	}
#line 1497 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1498 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1499 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1499 "glib-2.0.vapi"
	result = _tmp4_;
#line 1499 "glib-2.0.vapi"
	return result;
#line 582 "Color.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1538 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1538 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1539 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1539 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1539 "glib-2.0.vapi"
	return result;
#line 601 "Color.c"
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1161 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1162 "glib-2.0.vapi"
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
#line 1162 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1164 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1164 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 623 "Color.c"
		gchar* _tmp2_;
#line 1165 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1165 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1165 "glib-2.0.vapi"
		return result;
#line 631 "Color.c"
	} else {
#line 1167 "glib-2.0.vapi"
		result = -1;
#line 1167 "glib-2.0.vapi"
		return result;
#line 637 "Color.c"
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1543 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1543 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 660 "Color.c"
	} else {
#line 1543 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 664 "Color.c"
	}
#line 1543 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1543 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 670 "Color.c"
	} else {
#line 1543 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 674 "Color.c"
	}
#line 1543 "glib-2.0.vapi"
	if (_tmp0_) {
#line 678 "Color.c"
		gchar* _tmp2_;
#line 1544 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1544 "glib-2.0.vapi"
		result = _tmp2_;
#line 1544 "glib-2.0.vapi"
		return result;
#line 686 "Color.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1547 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1547 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1547 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1547 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1547 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1547 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1547 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1547 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 714 "Color.c"
				goto __catch0_g_regex_error;
			}
#line 1547 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1547 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1547 "glib-2.0.vapi"
			return NULL;
#line 723 "Color.c"
		}
#line 1548 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1548 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1548 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1548 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1548 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1548 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 737 "Color.c"
				goto __catch0_g_regex_error;
			}
#line 1548 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1548 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1548 "glib-2.0.vapi"
			return NULL;
#line 746 "Color.c"
		}
#line 1548 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1548 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1548 "glib-2.0.vapi"
		result = _tmp10_;
#line 1548 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1548 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1548 "glib-2.0.vapi"
		return result;
#line 760 "Color.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1546 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1550 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 769 "Color.c"
	}
	__finally0:
#line 1546 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1546 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1546 "glib-2.0.vapi"
	return NULL;
#line 778 "Color.c"
}

static gchar*
enotes_color_real_convert (ENotesPlugin* base,
                           const gchar* line_)
{
	ENotesColor * self;
	gint chars = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* line = NULL;
	gchar* _tmp2_;
	gchar* builed = NULL;
	gchar* _tmp3_;
	gint initial = 0;
	gint final = 0;
	gint last = 0;
	gint i = 0;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* result;
#line 82 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	self = (ENotesColor*) base;
#line 82 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	g_return_val_if_fail (line_ != NULL, NULL);
#line 83 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp0_ = strlen (line_);
#line 83 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp1_ = _tmp0_;
#line 83 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	chars = _tmp1_;
#line 84 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp2_ = g_strconcat (line_, "     ", NULL);
#line 84 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	line = _tmp2_;
#line 85 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp3_ = g_strdup ("");
#line 85 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	builed = _tmp3_;
#line 87 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	initial = 0;
#line 87 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	final = 0;
#line 87 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	last = 0;
#line 828 "Color.c"
	{
		gboolean _tmp4_ = FALSE;
#line 89 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		i = -1;
#line 89 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		_tmp4_ = TRUE;
#line 89 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		while (TRUE) {
#line 837 "Color.c"
			const gchar* _tmp6_;
#line 89 "../Notes-up-2.0.6/src/Plugins/Color.vala"
			if (!_tmp4_) {
#line 841 "Color.c"
				gint _tmp5_;
#line 89 "../Notes-up-2.0.6/src/Plugins/Color.vala"
				i = i + 1;
#line 89 "../Notes-up-2.0.6/src/Plugins/Color.vala"
				_tmp5_ = i;
#line 847 "Color.c"
			}
#line 89 "../Notes-up-2.0.6/src/Plugins/Color.vala"
			_tmp4_ = FALSE;
#line 89 "../Notes-up-2.0.6/src/Plugins/Color.vala"
			if (!(i < chars)) {
#line 89 "../Notes-up-2.0.6/src/Plugins/Color.vala"
				break;
#line 855 "Color.c"
			}
#line 90 "../Notes-up-2.0.6/src/Plugins/Color.vala"
			_tmp6_ = line;
#line 90 "../Notes-up-2.0.6/src/Plugins/Color.vala"
			if (string_get (_tmp6_, (glong) i) == '<') {
#line 90 "../Notes-up-2.0.6/src/Plugins/Color.vala"
				initial = i;
#line 863 "Color.c"
			} else {
				const gchar* _tmp7_;
#line 91 "../Notes-up-2.0.6/src/Plugins/Color.vala"
				_tmp7_ = line;
#line 91 "../Notes-up-2.0.6/src/Plugins/Color.vala"
				if (string_get (_tmp7_, (glong) i) == '>') {
#line 870 "Color.c"
					gchar* cut = NULL;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					const gchar* _tmp10_;
#line 92 "../Notes-up-2.0.6/src/Plugins/Color.vala"
					final = i;
#line 93 "../Notes-up-2.0.6/src/Plugins/Color.vala"
					_tmp8_ = line;
#line 93 "../Notes-up-2.0.6/src/Plugins/Color.vala"
					_tmp9_ = string_slice (_tmp8_, (glong) initial, (glong) final);
#line 93 "../Notes-up-2.0.6/src/Plugins/Color.vala"
					cut = _tmp9_;
#line 94 "../Notes-up-2.0.6/src/Plugins/Color.vala"
					_tmp10_ = cut;
#line 94 "../Notes-up-2.0.6/src/Plugins/Color.vala"
					if (string_contains (_tmp10_, "<color ")) {
#line 887 "Color.c"
						gint index = 0;
						const gchar* _tmp11_;
#line 95 "../Notes-up-2.0.6/src/Plugins/Color.vala"
						_tmp11_ = cut;
#line 95 "../Notes-up-2.0.6/src/Plugins/Color.vala"
						index = string_index_of_char (_tmp11_, (gunichar) ' ', 7);
#line 96 "../Notes-up-2.0.6/src/Plugins/Color.vala"
						if (index == -1) {
#line 896 "Color.c"
							const gchar* _tmp12_;
							const gchar* _tmp13_;
							gchar* _tmp14_;
							gchar* _tmp15_;
							gchar* _tmp16_;
							gchar* _tmp17_;
							const gchar* _tmp18_;
							gchar* _tmp19_;
							gchar* _tmp20_;
							gchar* _tmp21_;
							gchar* _tmp22_;
							gchar* _tmp23_;
#line 97 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp12_ = builed;
#line 97 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp13_ = line;
#line 97 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp14_ = string_slice (_tmp13_, (glong) last, (glong) initial);
#line 97 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp15_ = _tmp14_;
#line 97 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp16_ = g_strconcat (_tmp12_, _tmp15_, NULL);
#line 97 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp17_ = _tmp16_;
#line 97 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp18_ = cut;
#line 97 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp19_ = string_replace (_tmp18_, "<color ", "<color style=\"color:");
#line 97 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp20_ = _tmp19_;
#line 97 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp21_ = g_strconcat (_tmp17_, _tmp20_, NULL);
#line 97 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp22_ = _tmp21_;
#line 97 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp23_ = g_strconcat (_tmp22_, "\"", NULL);
#line 97 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_g_free0 (builed);
#line 97 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							builed = _tmp23_;
#line 97 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_g_free0 (_tmp22_);
#line 97 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_g_free0 (_tmp20_);
#line 97 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_g_free0 (_tmp17_);
#line 97 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_g_free0 (_tmp15_);
#line 98 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							last = final;
#line 947 "Color.c"
						} else {
							const gchar* _tmp24_;
							const gchar* _tmp25_;
							gchar* _tmp26_;
							gchar* _tmp27_;
							gchar* _tmp28_;
							gchar* _tmp29_;
							const gchar* _tmp30_;
							gchar* _tmp31_;
							gchar* _tmp32_;
							gchar* _tmp33_;
							gchar* _tmp34_;
							gchar* _tmp35_;
							gchar* _tmp36_;
							gchar* _tmp37_;
							gchar* _tmp38_;
							const gchar* _tmp39_;
							const gchar* _tmp40_;
							gint _tmp41_;
							gint _tmp42_;
							gchar* _tmp43_;
							gchar* _tmp44_;
							gchar* _tmp45_;
							gchar* _tmp46_;
							gchar* _tmp47_;
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp24_ = builed;
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp25_ = line;
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp26_ = string_slice (_tmp25_, (glong) last, (glong) initial);
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp27_ = _tmp26_;
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp28_ = g_strconcat (_tmp24_, _tmp27_, NULL);
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp29_ = _tmp28_;
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp30_ = cut;
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp31_ = string_slice (_tmp30_, (glong) 0, (glong) index);
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp32_ = _tmp31_;
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp33_ = string_replace (_tmp32_, "<color ", "<color style=\"color:");
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp34_ = _tmp33_;
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp35_ = g_strconcat (_tmp29_, _tmp34_, NULL);
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp36_ = _tmp35_;
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp37_ = g_strconcat (_tmp36_, "\">", NULL);
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp38_ = _tmp37_;
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp39_ = cut;
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp40_ = cut;
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp41_ = strlen (_tmp40_);
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp42_ = _tmp41_;
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp43_ = string_slice (_tmp39_, (glong) index, (glong) _tmp42_);
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp44_ = _tmp43_;
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp45_ = g_strconcat (_tmp38_, _tmp44_, NULL);
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp46_ = _tmp45_;
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_tmp47_ = g_strconcat (_tmp46_, "</color>", NULL);
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_g_free0 (builed);
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							builed = _tmp47_;
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_g_free0 (_tmp46_);
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_g_free0 (_tmp44_);
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_g_free0 (_tmp38_);
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_g_free0 (_tmp36_);
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_g_free0 (_tmp34_);
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_g_free0 (_tmp32_);
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_g_free0 (_tmp29_);
#line 100 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							_g_free0 (_tmp27_);
#line 101 "../Notes-up-2.0.6/src/Plugins/Color.vala"
							last = final + 1;
#line 1043 "Color.c"
						}
					}
#line 91 "../Notes-up-2.0.6/src/Plugins/Color.vala"
					_g_free0 (cut);
#line 1048 "Color.c"
				}
			}
		}
	}
#line 107 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp48_ = builed;
#line 107 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp49_ = line;
#line 107 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp50_ = string_slice (_tmp49_, (glong) last, (glong) i);
#line 107 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp51_ = _tmp50_;
#line 107 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp52_ = g_strconcat (_tmp48_, _tmp51_, NULL);
#line 107 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp53_ = _tmp52_;
#line 107 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_g_free0 (_tmp51_);
#line 107 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	result = _tmp53_;
#line 107 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_g_free0 (builed);
#line 107 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_g_free0 (line);
#line 107 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	return result;
#line 1075 "Color.c"
}

static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
#line 112 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	if (g_once_init_enter ((volatile gsize*) re)) {
#line 112 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
#line 112 "../Notes-up-2.0.6/src/Plugins/Color.vala"
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
#line 1089 "Color.c"
	}
#line 112 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	return *re;
#line 1093 "Color.c"
}

static GeeList*
enotes_color_real_get_blacklist_members (ENotesPlugin* base)
{
	ENotesColor * self;
	GeeLinkedList* list = NULL;
	GeeLinkedList* _tmp0_;
	BLMember* _tmp1_;
	BLMember* _tmp2_;
	GeeList* result;
#line 110 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	self = (ENotesColor*) base;
#line 111 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp0_ = gee_linked_list_new (TYPE_BL_MEMBER, (GBoxedCopyFunc) bl_member_ref, (GDestroyNotify) bl_member_unref, NULL, NULL, NULL);
#line 111 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	list = _tmp0_;
#line 112 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp1_ = bl_member_new (_thread_safe_regex_init (&_tmp_regex_0, "<color #[\\d\\p{L}]{6}>", 0), "");
#line 112 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp2_ = _tmp1_;
#line 112 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) list, _tmp2_);
#line 112 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_bl_member_unref0 (_tmp2_);
#line 113 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	result = (GeeList*) list;
#line 113 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	return result;
#line 1123 "Color.c"
}

ENotesColor*
enotes_color_construct (GType object_type)
{
	ENotesColor * self = NULL;
#line 22 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	self = (ENotesColor*) enotes_plugin_construct (object_type);
#line 22 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	return self;
#line 1134 "Color.c"
}

ENotesColor*
enotes_color_new (void)
{
#line 22 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	return enotes_color_construct (ENOTES_TYPE_COLOR);
#line 1142 "Color.c"
}

static GObject *
enotes_color_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ENotesColor * self;
	gchar* _tmp0_;
#line 30 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	parent_class = G_OBJECT_CLASS (enotes_color_parent_class);
#line 30 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 30 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_COLOR, ENotesColor);
#line 31 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp0_ = g_strdup ("ENOTES.COLORS");
#line 31 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_g_free0 (((ENotesPlugin*) self)->code_name);
#line 31 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	((ENotesPlugin*) self)->code_name = _tmp0_;
#line 30 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	return obj;
#line 1168 "Color.c"
}

static void
enotes_color_class_init (ENotesColorClass * klass,
                         gpointer klass_data)
{
#line 22 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	enotes_color_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	g_type_class_adjust_private_offset (klass, &ENotesColor_private_offset);
#line 22 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	((ENotesPluginClass *) klass)->get_desctiption = (gchar* (*) (ENotesPlugin*)) enotes_color_real_get_desctiption;
#line 22 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	((ENotesPluginClass *) klass)->get_name = (gchar* (*) (ENotesPlugin*)) enotes_color_real_get_name;
#line 22 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	((ENotesPluginClass *) klass)->editor_button = (GtkWidget* (*) (ENotesPlugin*)) enotes_color_real_editor_button;
#line 22 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	((ENotesPluginClass *) klass)->get_button_desctiption = (gchar* (*) (ENotesPlugin*)) enotes_color_real_get_button_desctiption;
#line 22 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	((ENotesPluginClass *) klass)->request_string = (gchar* (*) (ENotesPlugin*, const gchar*)) enotes_color_real_request_string;
#line 22 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	((ENotesPluginClass *) klass)->has_match = (gboolean (*) (ENotesPlugin*, const gchar*)) enotes_color_real_has_match;
#line 22 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	((ENotesPluginClass *) klass)->convert = (gchar* (*) (ENotesPlugin*, const gchar*)) enotes_color_real_convert;
#line 22 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	((ENotesPluginClass *) klass)->get_blacklist_members = (GeeList* (*) (ENotesPlugin*)) enotes_color_real_get_blacklist_members;
#line 22 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	G_OBJECT_CLASS (klass)->constructor = enotes_color_constructor;
#line 22 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	G_OBJECT_CLASS (klass)->finalize = enotes_color_finalize;
#line 1199 "Color.c"
}

static void
enotes_color_instance_init (ENotesColor * self,
                            gpointer klass)
{
	GPatternSpec* _tmp0_;
#line 22 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	self->priv = enotes_color_get_instance_private (self);
#line 23 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_tmp0_ = g_pattern_spec_new ("*<color *>*");
#line 23 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	self->priv->spec = _tmp0_;
#line 1213 "Color.c"
}

static void
enotes_color_finalize (GObject * obj)
{
	ENotesColor * self;
#line 22 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_COLOR, ENotesColor);
#line 23 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_g_pattern_spec_free0 (self->priv->spec);
#line 25 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_g_object_unref0 (self->priv->color_selector);
#line 26 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_g_object_unref0 (self->priv->popover);
#line 28 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	_g_free0 (self->priv->selection);
#line 22 "../Notes-up-2.0.6/src/Plugins/Color.vala"
	G_OBJECT_CLASS (enotes_color_parent_class)->finalize (obj);
#line 1232 "Color.c"
}

static GType
enotes_color_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesColorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_color_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesColor), 0, (GInstanceInitFunc) enotes_color_instance_init, NULL };
	GType enotes_color_type_id;
	enotes_color_type_id = g_type_register_static (ENOTES_TYPE_PLUGIN, "ENotesColor", &g_define_type_info, 0);
	ENotesColor_private_offset = g_type_add_instance_private (enotes_color_type_id, sizeof (ENotesColorPrivate));
	return enotes_color_type_id;
}

GType
enotes_color_get_type (void)
{
	static volatile gsize enotes_color_type_id__once = 0;
	if (g_once_init_enter (&enotes_color_type_id__once)) {
		GType enotes_color_type_id;
		enotes_color_type_id = enotes_color_get_type_once ();
		g_once_init_leave (&enotes_color_type_id__once, enotes_color_type_id);
	}
	return enotes_color_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

