/* Application.c generated by valac 0.56.12, the Vala compiler
 * generated from Application.vala, do not modify */

/*
* Copyright (c) 2019 Felipe Escoto (https://github.com/Philip-Scott/Notes-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <granite.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

#define ENOTES_FEATURE_FLAGS_SHOW_NOTEBOOK_PANE FALSE
#define ENOTES_APPLICATION_PROGRAM_NAME N_ ("Notes-Up")
#define ENOTES_APPLICATION_COMMENT N_ ("Your Markdown Notebook.")
#define ENOTES_APPLICATION_ABOUT_STOCK N_ ("About Notes")
#define TERMINAL_NAME "notes-up"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	ENOTES_KEY_CHANGE_MODE,
	ENOTES_KEY_SAVE,
	ENOTES_KEY_QUIT,
	ENOTES_KEY_NEW_PAGE,
	ENOTES_KEY_FIND,
	ENOTES_KEY_BOOKMARK,
	ENOTES_KEY_BOLD,
	ENOTES_KEY_ITALICS,
	ENOTES_KEY_STRIKE,
	ENOTES_KEY_PAGE_INFO,
	ENOTES_KEY_PANEL_MODE,
	ENOTES_KEY_PANEL_MODE_R
} ENotesKey;

#define ENOTES_TYPE_KEY (enotes_key_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define ENOTES_TYPE_APPLICATION (enotes_application_get_type ())
#define ENOTES_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_APPLICATION, ENotesApplication))
#define ENOTES_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_APPLICATION, ENotesApplicationClass))
#define ENOTES_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_APPLICATION))
#define ENOTES_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_APPLICATION))
#define ENOTES_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_APPLICATION, ENotesApplicationClass))

typedef struct _ENotesApplication ENotesApplication;
typedef struct _ENotesApplicationClass ENotesApplicationClass;

#define ENOTES_SERVICES_TYPE_SETTINGS (enotes_services_settings_get_type ())
#define ENOTES_SERVICES_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_SERVICES_TYPE_SETTINGS, ENotesServicesSettings))
#define ENOTES_SERVICES_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_SERVICES_TYPE_SETTINGS, ENotesServicesSettingsClass))
#define ENOTES_SERVICES_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_SERVICES_TYPE_SETTINGS))
#define ENOTES_SERVICES_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_SERVICES_TYPE_SETTINGS))
#define ENOTES_SERVICES_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_SERVICES_TYPE_SETTINGS, ENotesServicesSettingsClass))

typedef struct _ENotesServicesSettings ENotesServicesSettings;
typedef struct _ENotesServicesSettingsClass ENotesServicesSettingsClass;
typedef struct _ENotesApplicationPrivate ENotesApplicationPrivate;

#define ENOTES_APPLICATION_TYPE_STATE (enotes_application_state_get_type ())
#define ENOTES_APPLICATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationState))
#define ENOTES_APPLICATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationStateClass))
#define ENOTES_APPLICATION_IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_APPLICATION_TYPE_STATE))
#define ENOTES_APPLICATION_IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_APPLICATION_TYPE_STATE))
#define ENOTES_APPLICATION_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationStateClass))

typedef struct _ENotesApplicationState ENotesApplicationState;
typedef struct _ENotesApplicationStateClass ENotesApplicationStateClass;
enum  {
	ENOTES_APPLICATION_0_PROPERTY,
	ENOTES_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* enotes_application_properties[ENOTES_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ENOTES_TYPE_WINDOW (enotes_window_get_type ())
#define ENOTES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_WINDOW, ENotesWindow))
#define ENOTES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_WINDOW, ENotesWindowClass))
#define ENOTES_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_WINDOW))
#define ENOTES_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_WINDOW))
#define ENOTES_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_WINDOW, ENotesWindowClass))

typedef struct _ENotesWindow ENotesWindow;
typedef struct _ENotesWindowClass ENotesWindowClass;
typedef struct _ENotesApplicationStatePrivate ENotesApplicationStatePrivate;

#define ENOTES_TYPE_PAGE (enotes_page_get_type ())
#define ENOTES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGE, ENotesPage))
#define ENOTES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGE, ENotesPageClass))
#define ENOTES_IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGE))
#define ENOTES_IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGE))
#define ENOTES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGE, ENotesPageClass))

typedef struct _ENotesPage ENotesPage;
typedef struct _ENotesPageClass ENotesPageClass;

#define ENOTES_TYPE_NOTEBOOK (enotes_notebook_get_type ())
#define ENOTES_NOTEBOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_NOTEBOOK, ENotesNotebook))
#define ENOTES_NOTEBOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_NOTEBOOK, ENotesNotebookClass))
#define ENOTES_IS_NOTEBOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_NOTEBOOK))
#define ENOTES_IS_NOTEBOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_NOTEBOOK))
#define ENOTES_NOTEBOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_NOTEBOOK, ENotesNotebookClass))

typedef struct _ENotesNotebook ENotesNotebook;
typedef struct _ENotesNotebookClass ENotesNotebookClass;
typedef enum  {
	ENOTES_MODE_NONE = -1,
	ENOTES_MODE_VIEW = 0,
	ENOTES_MODE_EDIT = 1,
	ENOTES_MODE_BOTH = 2
} ENotesMode;

#define ENOTES_TYPE_MODE (enotes_mode_get_type ())
enum  {
	ENOTES_APPLICATION_STATE_0_PROPERTY,
	ENOTES_APPLICATION_STATE_DB_PROPERTY,
	ENOTES_APPLICATION_STATE_OPENED_PAGE_PROPERTY,
	ENOTES_APPLICATION_STATE_OPENED_PAGE_NOTEBOOK_PROPERTY,
	ENOTES_APPLICATION_STATE_OPENED_NOTEBOOK_PROPERTY,
	ENOTES_APPLICATION_STATE_MODE_PROPERTY,
	ENOTES_APPLICATION_STATE_SHOW_PAGE_INFO_PROPERTY,
	ENOTES_APPLICATION_STATE_PANES_VISIBLE_PROPERTY,
	ENOTES_APPLICATION_STATE_STYLE_SCHEME_PROPERTY,
	ENOTES_APPLICATION_STATE_SEARCH_FIELD_PROPERTY,
	ENOTES_APPLICATION_STATE_EDITOR_FONT_PROPERTY,
	ENOTES_APPLICATION_STATE_EDITOR_SCHEME_PROPERTY,
	ENOTES_APPLICATION_STATE_EDITOR_SHOW_LINE_NUMBERS_PROPERTY,
	ENOTES_APPLICATION_STATE_EDITOR_AUTO_INDENT_PROPERTY,
	ENOTES_APPLICATION_STATE_NUM_PROPERTIES
};
static GParamSpec* enotes_application_state_properties[ENOTES_APPLICATION_STATE_NUM_PROPERTIES];
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define ENOTES_TYPE_NOTEBOOK_TABLE (enotes_notebook_table_get_type ())
#define ENOTES_NOTEBOOK_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_NOTEBOOK_TABLE, ENotesNotebookTable))
#define ENOTES_NOTEBOOK_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_NOTEBOOK_TABLE, ENotesNotebookTableClass))
#define ENOTES_IS_NOTEBOOK_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_NOTEBOOK_TABLE))
#define ENOTES_IS_NOTEBOOK_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_NOTEBOOK_TABLE))
#define ENOTES_NOTEBOOK_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_NOTEBOOK_TABLE, ENotesNotebookTableClass))

typedef struct _ENotesNotebookTable ENotesNotebookTable;
typedef struct _ENotesNotebookTableClass ENotesNotebookTableClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))

#define ENOTES_TYPE_PAGE_TABLE (enotes_page_table_get_type ())
#define ENOTES_PAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGE_TABLE, ENotesPageTable))
#define ENOTES_PAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGE_TABLE, ENotesPageTableClass))
#define ENOTES_IS_PAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGE_TABLE))
#define ENOTES_IS_PAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGE_TABLE))
#define ENOTES_PAGE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGE_TABLE, ENotesPageTableClass))

typedef struct _ENotesPageTable ENotesPageTable;
typedef struct _ENotesPageTableClass ENotesPageTableClass;
typedef struct _ENotesNotebookPrivate ENotesNotebookPrivate;
typedef struct _ENotesPagePrivate ENotesPagePrivate;

#define ENOTES_TYPE_TAG (enotes_tag_get_type ())
#define ENOTES_TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_TAG, ENotesTag))
#define ENOTES_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_TAG, ENotesTagClass))
#define ENOTES_IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_TAG))
#define ENOTES_IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_TAG))
#define ENOTES_TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_TAG, ENotesTagClass))

typedef struct _ENotesTag ENotesTag;
typedef struct _ENotesTagClass ENotesTagClass;
typedef enum  {
	FILE_DATA_TYPE_FILE_NAME = 0,
	FILE_DATA_TYPE_LAST_NOTEBOOK = 10,
	FILE_DATA_TYPE_LAST_PAGE = 11,
	FILE_DATA_TYPE_STYLESHEET = 21,
	FILE_DATA_TYPE_CUSTOM_CSS = 22
} FileDataType;

#define TYPE_FILE_DATA_TYPE (file_data_type_get_type ())
enum  {
	ENOTES_APPLICATION_STATE_PRE_DATABASE_CHANGE_SIGNAL,
	ENOTES_APPLICATION_STATE_POST_DATABASE_CHANGE_SIGNAL,
	ENOTES_APPLICATION_STATE_UPDATE_PAGE_TITLE_SIGNAL,
	ENOTES_APPLICATION_STATE_SEARCH_SELECTED_SIGNAL,
	ENOTES_APPLICATION_STATE_BOOKMARK_CHANGED_SIGNAL,
	ENOTES_APPLICATION_STATE_REQUEST_SAVING_PAGE_INFO_SIGNAL,
	ENOTES_APPLICATION_STATE_PAGE_TEXT_UPDATED_SIGNAL,
	ENOTES_APPLICATION_STATE_PAGE_UPDATED_SIGNAL,
	ENOTES_APPLICATION_STATE_PAGE_DELETED_SIGNAL,
	ENOTES_APPLICATION_STATE_OPENED_NOTEBOOK_UPDATED_SIGNAL,
	ENOTES_APPLICATION_STATE_LOAD_ALL_PAGES_SIGNAL,
	ENOTES_APPLICATION_STATE_NOTEBOOK_CONTENTS_CHANGED_SIGNAL,
	ENOTES_APPLICATION_STATE_TAGS_CHANGED_SIGNAL,
	ENOTES_APPLICATION_STATE_SHOW_ALL_PAGES_SIGNAL,
	ENOTES_APPLICATION_STATE_SHOW_PAGES_IN_TAG_SIGNAL,
	ENOTES_APPLICATION_STATE_RELOAD_EDITOR_SETTINGS_SIGNAL,
	ENOTES_APPLICATION_STATE_FILE_DATA_CHANGED_SIGNAL,
	ENOTES_APPLICATION_STATE_NUM_SIGNALS
};
static guint enotes_application_state_signals[ENOTES_APPLICATION_STATE_NUM_SIGNALS] = {0};

struct _ENotesApplication {
	GraniteApplication parent_instance;
	ENotesApplicationPrivate * priv;
	gboolean running;
	ENotesApplicationState* state;
};

struct _ENotesApplicationClass {
	GraniteApplicationClass parent_class;
};

struct _ENotesApplicationState {
	GObject parent_instance;
	ENotesApplicationStatePrivate * priv;
};

struct _ENotesApplicationStateClass {
	GObjectClass parent_class;
};

struct _ENotesApplicationStatePrivate {
	gchar* _db;
	ENotesPage* _opened_page;
	ENotesNotebook* _opened_page_notebook;
	ENotesNotebook* _opened_notebook;
	ENotesMode _mode;
	gboolean _show_page_info;
	gint _panes_visible;
	gchar* _style_scheme;
	gchar* _search_field;
	gchar* _editor_font;
	gchar* _editor_scheme;
	gboolean _editor_show_line_numbers;
	gboolean _editor_auto_indent;
};

struct _ENotesNotebook {
	GObject parent_instance;
	ENotesNotebookPrivate * priv;
	gint64 id;
	gint64* parent_id;
	GdkRGBA rgb;
	gchar* name;
	gchar* css;
	gchar* stylesheet;
};

struct _ENotesNotebookClass {
	GObjectClass parent_class;
};

struct _ENotesPage {
	GObject parent_instance;
	ENotesPagePrivate * priv;
	gint64 id;
	gint64 notebook_id;
	gchar* name;
	gchar* data;
	gchar* subtitle;
	gchar* html_cache;
	gint64 creation_date;
	gint64 modification_date;
	gboolean new_page;
	gboolean cache_changed;
	gchar* full_path;
};

struct _ENotesPageClass {
	GObjectClass parent_class;
};

VALA_EXTERN ENotesApplication* enotes_app;
ENotesApplication* enotes_app = NULL;
VALA_EXTERN ENotesServicesSettings* enotes_settings;
ENotesServicesSettings* enotes_settings = NULL;
static gpointer enotes_application_parent_class = NULL;
static gint ENotesApplicationState_private_offset;
static gpointer enotes_application_state_parent_class = NULL;

VALA_EXTERN GType enotes_key_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* enotes_key_to_key (ENotesKey self);
VALA_EXTERN gchar* enotes_key_to_string (ENotesKey self);
VALA_EXTERN GType enotes_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesApplication, g_object_unref)
VALA_EXTERN GType enotes_services_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesServicesSettings, g_object_unref)
VALA_EXTERN GType enotes_application_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesApplicationState, g_object_unref)
static void enotes_application_init (ENotesApplication* self);
VALA_EXTERN ENotesServicesSettings* enotes_services_settings_get_instance (void);
VALA_EXTERN const gchar* enotes_services_settings_get_notes_database (ENotesServicesSettings* self);
VALA_EXTERN void enotes_services_settings_set_notes_database (ENotesServicesSettings* self,
                                                  const gchar* value);
static void enotes_application_real_activate (GApplication* base);
VALA_EXTERN void enotes_application_state_set_database (ENotesApplicationState* self,
                                            const gchar* _db);
static void enotes_application_start_window (ENotesApplication* self);
static void enotes_application_real_open (GApplication* base,
                                   GFile** files,
                                   gint files_length1,
                                   const gchar* hint);
VALA_EXTERN GType enotes_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesWindow, g_object_unref)
VALA_EXTERN ENotesWindow* enotes_window_new (ENotesApplication* app);
VALA_EXTERN ENotesWindow* enotes_window_construct (GType object_type,
                                       ENotesApplication* app);
VALA_EXTERN ENotesWindow* enotes_application_get_app_window (ENotesApplication* self);
VALA_EXTERN void enotes_window_show_app (ENotesWindow* self);
VALA_EXTERN ENotesApplication* enotes_application_new (void);
VALA_EXTERN ENotesApplication* enotes_application_construct (GType object_type);
VALA_EXTERN GType enotes_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPage, g_object_unref)
VALA_EXTERN GType enotes_notebook_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesNotebook, g_object_unref)
VALA_EXTERN GType enotes_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN const gchar* enotes_application_state_get_db (ENotesApplicationState* self);
VALA_EXTERN gboolean db_is_file_valid (const gchar* path);
VALA_EXTERN void database_table_terminate (void);
static void enotes_application_state_set_db (ENotesApplicationState* self,
                                      const gchar* value);
static void enotes_application_state_set_opened_page_notebook (ENotesApplicationState* self,
                                                        ENotesNotebook* value);
VALA_EXTERN void enotes_application_state_set_opened_notebook (ENotesApplicationState* self,
                                                   ENotesNotebook* value);
static void enotes_application_state_set_opened_page (ENotesApplicationState* self,
                                               ENotesPage* value);
VALA_EXTERN gboolean database_table_init (const gchar* filename);
static void _g_free0_ (gpointer var);
static void _vala_gchar_free_function_content_of (gpointer data);
VALA_EXTERN gchar** enotes_services_settings_get_recent_files (ENotesServicesSettings* self,
                                                   gint* result_length1);
VALA_EXTERN void enotes_services_settings_set_recent_files (ENotesServicesSettings* self,
                                                gchar** value,
                                                gint value_length1);
VALA_EXTERN void enotes_application_state_open_notebook (ENotesApplicationState* self,
                                             gint64 notebook_id);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType enotes_notebook_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesNotebookTable, database_table_unref)
VALA_EXTERN ENotesNotebookTable* enotes_notebook_table_get_instance (void);
VALA_EXTERN ENotesNotebook* enotes_notebook_table_load_notebook_data (ENotesNotebookTable* self,
                                                          gint64 notebook_id);
VALA_EXTERN void enotes_application_state_open_page (ENotesApplicationState* self,
                                         gint64 page_id);
VALA_EXTERN GType enotes_page_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPageTable, database_table_unref)
VALA_EXTERN ENotesPageTable* enotes_page_table_get_instance (void);
VALA_EXTERN ENotesPage* enotes_page_table_get_page (ENotesPageTable* self,
                                        gint64 page_id);
VALA_EXTERN ENotesNotebook* enotes_application_state_get_opened_page_notebook (ENotesApplicationState* self);
VALA_EXTERN void enotes_application_state_save_opened_page (ENotesApplicationState* self);
VALA_EXTERN ENotesPage* enotes_application_state_get_opened_page (ENotesApplicationState* self);
VALA_EXTERN void enotes_page_table_save_page (ENotesPageTable* self,
                                  ENotesPage* page);
VALA_EXTERN void enotes_application_state_set_style (ENotesApplicationState* self,
                                         const gchar* style);
static void enotes_application_state_set_style_scheme (ENotesApplicationState* self,
                                                const gchar* value);
VALA_EXTERN void enotes_application_state_set_editor_scheme (ENotesApplicationState* self,
                                                 const gchar* value);
VALA_EXTERN void enotes_application_state_toggle_app_mode (ENotesApplicationState* self);
VALA_EXTERN ENotesMode enotes_application_state_get_mode (ENotesApplicationState* self);
VALA_EXTERN void enotes_application_state_set_mode (ENotesApplicationState* self,
                                        ENotesMode value);
VALA_EXTERN ENotesApplicationState* enotes_application_state_new (void);
VALA_EXTERN ENotesApplicationState* enotes_application_state_construct (GType object_type);
VALA_EXTERN ENotesNotebook* enotes_application_state_get_opened_notebook (ENotesApplicationState* self);
VALA_EXTERN gboolean enotes_application_state_get_show_page_info (ENotesApplicationState* self);
VALA_EXTERN void enotes_application_state_set_show_page_info (ENotesApplicationState* self,
                                                  gboolean value);
VALA_EXTERN gint enotes_application_state_get_panes_visible (ENotesApplicationState* self);
VALA_EXTERN void enotes_application_state_set_panes_visible (ENotesApplicationState* self,
                                                 gint value);
VALA_EXTERN const gchar* enotes_application_state_get_style_scheme (ENotesApplicationState* self);
VALA_EXTERN const gchar* enotes_application_state_get_search_field (ENotesApplicationState* self);
VALA_EXTERN void enotes_application_state_set_search_field (ENotesApplicationState* self,
                                                const gchar* value);
VALA_EXTERN const gchar* enotes_application_state_get_editor_font (ENotesApplicationState* self);
VALA_EXTERN void enotes_application_state_set_editor_font (ENotesApplicationState* self,
                                               const gchar* value);
VALA_EXTERN const gchar* enotes_application_state_get_editor_scheme (ENotesApplicationState* self);
VALA_EXTERN gboolean enotes_application_state_get_editor_show_line_numbers (ENotesApplicationState* self);
VALA_EXTERN void enotes_application_state_set_editor_show_line_numbers (ENotesApplicationState* self,
                                                            gboolean value);
VALA_EXTERN gboolean enotes_application_state_get_editor_auto_indent (ENotesApplicationState* self);
VALA_EXTERN void enotes_application_state_set_editor_auto_indent (ENotesApplicationState* self,
                                                      gboolean value);
VALA_EXTERN GType enotes_tag_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesTag, g_object_unref)
VALA_EXTERN GType file_data_type_get_type (void) G_GNUC_CONST ;
static void g_cclosure_user_marshal_VOID__ENUM_STRING (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static GObject * enotes_application_state_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void _enotes_application_state___lambda8_ (ENotesApplicationState* self,
                                           GParamSpec* spec);
static void __enotes_application_state___lambda8__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void enotes_application_state_finalize (GObject * obj);
static GType enotes_application_state_get_type_once (void);
static void _vala_enotes_application_state_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_enotes_application_state_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static GObject * enotes_application_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void enotes_application_finalize (GObject * obj);
static GType enotes_application_get_type_once (void);

gchar*
enotes_key_to_key (ENotesKey self)
{
	gchar* result;
#line 37 "../Notes-up-2.0.6/src/Application.vala"
	switch (self) {
#line 37 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_KEY_CHANGE_MODE:
#line 479 "Application.c"
		{
			gchar* _tmp0_;
#line 39 "../Notes-up-2.0.6/src/Application.vala"
			_tmp0_ = g_strdup (_ ("<Ctrl>M"));
#line 39 "../Notes-up-2.0.6/src/Application.vala"
			result = _tmp0_;
#line 39 "../Notes-up-2.0.6/src/Application.vala"
			return result;
#line 488 "Application.c"
		}
#line 37 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_KEY_SAVE:
#line 492 "Application.c"
		{
			gchar* _tmp1_;
#line 40 "../Notes-up-2.0.6/src/Application.vala"
			_tmp1_ = g_strdup (_ ("<Ctrl>S"));
#line 40 "../Notes-up-2.0.6/src/Application.vala"
			result = _tmp1_;
#line 40 "../Notes-up-2.0.6/src/Application.vala"
			return result;
#line 501 "Application.c"
		}
#line 37 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_KEY_QUIT:
#line 505 "Application.c"
		{
			gchar* _tmp2_;
#line 41 "../Notes-up-2.0.6/src/Application.vala"
			_tmp2_ = g_strdup (_ ("<Ctrl>Q"));
#line 41 "../Notes-up-2.0.6/src/Application.vala"
			result = _tmp2_;
#line 41 "../Notes-up-2.0.6/src/Application.vala"
			return result;
#line 514 "Application.c"
		}
#line 37 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_KEY_NEW_PAGE:
#line 518 "Application.c"
		{
			gchar* _tmp3_;
#line 42 "../Notes-up-2.0.6/src/Application.vala"
			_tmp3_ = g_strdup (_ ("<Ctrl><Shift>N"));
#line 42 "../Notes-up-2.0.6/src/Application.vala"
			result = _tmp3_;
#line 42 "../Notes-up-2.0.6/src/Application.vala"
			return result;
#line 527 "Application.c"
		}
#line 37 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_KEY_FIND:
#line 531 "Application.c"
		{
			gchar* _tmp4_;
#line 43 "../Notes-up-2.0.6/src/Application.vala"
			_tmp4_ = g_strdup (_ ("<Ctrl>F"));
#line 43 "../Notes-up-2.0.6/src/Application.vala"
			result = _tmp4_;
#line 43 "../Notes-up-2.0.6/src/Application.vala"
			return result;
#line 540 "Application.c"
		}
#line 37 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_KEY_BOOKMARK:
#line 544 "Application.c"
		{
			gchar* _tmp5_;
#line 44 "../Notes-up-2.0.6/src/Application.vala"
			_tmp5_ = g_strdup (_ ("<Ctrl>K"));
#line 44 "../Notes-up-2.0.6/src/Application.vala"
			result = _tmp5_;
#line 44 "../Notes-up-2.0.6/src/Application.vala"
			return result;
#line 553 "Application.c"
		}
#line 37 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_KEY_BOLD:
#line 557 "Application.c"
		{
			gchar* _tmp6_;
#line 45 "../Notes-up-2.0.6/src/Application.vala"
			_tmp6_ = g_strdup (_ ("<Ctrl>B"));
#line 45 "../Notes-up-2.0.6/src/Application.vala"
			result = _tmp6_;
#line 45 "../Notes-up-2.0.6/src/Application.vala"
			return result;
#line 566 "Application.c"
		}
#line 37 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_KEY_ITALICS:
#line 570 "Application.c"
		{
			gchar* _tmp7_;
#line 46 "../Notes-up-2.0.6/src/Application.vala"
			_tmp7_ = g_strdup (_ ("<Ctrl>I"));
#line 46 "../Notes-up-2.0.6/src/Application.vala"
			result = _tmp7_;
#line 46 "../Notes-up-2.0.6/src/Application.vala"
			return result;
#line 579 "Application.c"
		}
#line 37 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_KEY_STRIKE:
#line 583 "Application.c"
		{
			gchar* _tmp8_;
#line 47 "../Notes-up-2.0.6/src/Application.vala"
			_tmp8_ = g_strdup (_ ("<Ctrl>T"));
#line 47 "../Notes-up-2.0.6/src/Application.vala"
			result = _tmp8_;
#line 47 "../Notes-up-2.0.6/src/Application.vala"
			return result;
#line 592 "Application.c"
		}
#line 37 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_KEY_PAGE_INFO:
#line 596 "Application.c"
		{
			gchar* _tmp9_;
#line 48 "../Notes-up-2.0.6/src/Application.vala"
			_tmp9_ = g_strdup (_ ("<Ctrl><Shift>I"));
#line 48 "../Notes-up-2.0.6/src/Application.vala"
			result = _tmp9_;
#line 48 "../Notes-up-2.0.6/src/Application.vala"
			return result;
#line 605 "Application.c"
		}
#line 37 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_KEY_PANEL_MODE:
#line 609 "Application.c"
		{
			gchar* _tmp10_;
#line 49 "../Notes-up-2.0.6/src/Application.vala"
			_tmp10_ = g_strdup (_ ("<Ctrl>P"));
#line 49 "../Notes-up-2.0.6/src/Application.vala"
			result = _tmp10_;
#line 49 "../Notes-up-2.0.6/src/Application.vala"
			return result;
#line 618 "Application.c"
		}
#line 37 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_KEY_PANEL_MODE_R:
#line 622 "Application.c"
		{
			gchar* _tmp11_;
#line 50 "../Notes-up-2.0.6/src/Application.vala"
			_tmp11_ = g_strdup (_ ("<Ctrl><Shift>P"));
#line 50 "../Notes-up-2.0.6/src/Application.vala"
			result = _tmp11_;
#line 50 "../Notes-up-2.0.6/src/Application.vala"
			return result;
#line 631 "Application.c"
		}
		default:
		{
#line 51 "../Notes-up-2.0.6/src/Application.vala"
			g_assert_not_reached ();
#line 637 "Application.c"
		}
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1543 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1543 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 661 "Application.c"
	} else {
#line 1543 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 665 "Application.c"
	}
#line 1543 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1543 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 671 "Application.c"
	} else {
#line 1543 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 675 "Application.c"
	}
#line 1543 "glib-2.0.vapi"
	if (_tmp0_) {
#line 679 "Application.c"
		gchar* _tmp2_;
#line 1544 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1544 "glib-2.0.vapi"
		result = _tmp2_;
#line 1544 "glib-2.0.vapi"
		return result;
#line 687 "Application.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1547 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1547 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1547 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1547 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1547 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1547 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1547 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1547 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 715 "Application.c"
				goto __catch0_g_regex_error;
			}
#line 1547 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1547 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1547 "glib-2.0.vapi"
			return NULL;
#line 724 "Application.c"
		}
#line 1548 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1548 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1548 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1548 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1548 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1548 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 738 "Application.c"
				goto __catch0_g_regex_error;
			}
#line 1548 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1548 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1548 "glib-2.0.vapi"
			return NULL;
#line 747 "Application.c"
		}
#line 1548 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1548 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1548 "glib-2.0.vapi"
		result = _tmp10_;
#line 1548 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1548 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1548 "glib-2.0.vapi"
		return result;
#line 761 "Application.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1546 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1550 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 770 "Application.c"
	}
	__finally0:
#line 1546 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1546 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1546 "glib-2.0.vapi"
	return NULL;
#line 779 "Application.c"
}

gchar*
enotes_key_to_string (ENotesKey self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
#line 56 "../Notes-up-2.0.6/src/Application.vala"
	_tmp0_ = enotes_key_to_key (self);
#line 56 "../Notes-up-2.0.6/src/Application.vala"
	_tmp1_ = _tmp0_;
#line 56 "../Notes-up-2.0.6/src/Application.vala"
	_tmp2_ = string_replace (_tmp1_, ">", "+");
#line 56 "../Notes-up-2.0.6/src/Application.vala"
	_tmp3_ = _tmp2_;
#line 56 "../Notes-up-2.0.6/src/Application.vala"
	_tmp4_ = string_replace (_tmp3_, "<", "");
#line 56 "../Notes-up-2.0.6/src/Application.vala"
	_tmp5_ = _tmp4_;
#line 56 "../Notes-up-2.0.6/src/Application.vala"
	_tmp6_ = g_strconcat (" (", _tmp5_, NULL);
#line 56 "../Notes-up-2.0.6/src/Application.vala"
	_tmp7_ = _tmp6_;
#line 56 "../Notes-up-2.0.6/src/Application.vala"
	_tmp8_ = g_strconcat (_tmp7_, ")", NULL);
#line 56 "../Notes-up-2.0.6/src/Application.vala"
	_tmp9_ = _tmp8_;
#line 56 "../Notes-up-2.0.6/src/Application.vala"
	_g_free0 (_tmp7_);
#line 56 "../Notes-up-2.0.6/src/Application.vala"
	_g_free0 (_tmp5_);
#line 56 "../Notes-up-2.0.6/src/Application.vala"
	_g_free0 (_tmp3_);
#line 56 "../Notes-up-2.0.6/src/Application.vala"
	_g_free0 (_tmp1_);
#line 56 "../Notes-up-2.0.6/src/Application.vala"
	result = _tmp9_;
#line 56 "../Notes-up-2.0.6/src/Application.vala"
	return result;
#line 828 "Application.c"
}

static GType
enotes_key_get_type_once (void)
{
	static const GEnumValue values[] = {{ENOTES_KEY_CHANGE_MODE, "ENOTES_KEY_CHANGE_MODE", "change-mode"}, {ENOTES_KEY_SAVE, "ENOTES_KEY_SAVE", "save"}, {ENOTES_KEY_QUIT, "ENOTES_KEY_QUIT", "quit"}, {ENOTES_KEY_NEW_PAGE, "ENOTES_KEY_NEW_PAGE", "new-page"}, {ENOTES_KEY_FIND, "ENOTES_KEY_FIND", "find"}, {ENOTES_KEY_BOOKMARK, "ENOTES_KEY_BOOKMARK", "bookmark"}, {ENOTES_KEY_BOLD, "ENOTES_KEY_BOLD", "bold"}, {ENOTES_KEY_ITALICS, "ENOTES_KEY_ITALICS", "italics"}, {ENOTES_KEY_STRIKE, "ENOTES_KEY_STRIKE", "strike"}, {ENOTES_KEY_PAGE_INFO, "ENOTES_KEY_PAGE_INFO", "page-info"}, {ENOTES_KEY_PANEL_MODE, "ENOTES_KEY_PANEL_MODE", "panel-mode"}, {ENOTES_KEY_PANEL_MODE_R, "ENOTES_KEY_PANEL_MODE_R", "panel-mode-r"}, {0, NULL, NULL}};
	GType enotes_key_type_id;
	enotes_key_type_id = g_enum_register_static ("ENotesKey", values);
	return enotes_key_type_id;
}

GType
enotes_key_get_type (void)
{
	static volatile gsize enotes_key_type_id__once = 0;
	if (g_once_init_enter (&enotes_key_type_id__once)) {
		GType enotes_key_type_id;
		enotes_key_type_id = enotes_key_get_type_once ();
		g_once_init_leave (&enotes_key_type_id__once, enotes_key_type_id);
	}
	return enotes_key_type_id__once;
}

static void
enotes_application_init (ENotesApplication* self)
{
#line 88 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (self != NULL);
#line 89 "../Notes-up-2.0.6/src/Application.vala"
	if (!self->running) {
#line 859 "Application.c"
		ENotesServicesSettings* _tmp0_;
		ENotesServicesSettings* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		GtkIconTheme* default_theme = NULL;
		GtkIconTheme* _tmp10_;
		GtkIconTheme* _tmp11_;
#line 90 "../Notes-up-2.0.6/src/Application.vala"
		enotes_app = self;
#line 91 "../Notes-up-2.0.6/src/Application.vala"
		_tmp0_ = enotes_services_settings_get_instance ();
#line 91 "../Notes-up-2.0.6/src/Application.vala"
		_g_object_unref0 (enotes_settings);
#line 91 "../Notes-up-2.0.6/src/Application.vala"
		enotes_settings = _tmp0_;
#line 94 "../Notes-up-2.0.6/src/Application.vala"
		_tmp1_ = enotes_settings;
#line 94 "../Notes-up-2.0.6/src/Application.vala"
		_tmp2_ = enotes_services_settings_get_notes_database (_tmp1_);
#line 94 "../Notes-up-2.0.6/src/Application.vala"
		_tmp3_ = _tmp2_;
#line 94 "../Notes-up-2.0.6/src/Application.vala"
		if (g_strcmp0 (_tmp3_, "") == 0) {
#line 883 "Application.c"
			gchar* notes_path = NULL;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			ENotesServicesSettings* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
#line 95 "../Notes-up-2.0.6/src/Application.vala"
			_tmp4_ = g_get_home_dir ();
#line 95 "../Notes-up-2.0.6/src/Application.vala"
			_tmp5_ = g_build_filename (_tmp4_, "/.local/share/notes-up/", NULL);
#line 95 "../Notes-up-2.0.6/src/Application.vala"
			notes_path = _tmp5_;
#line 97 "../Notes-up-2.0.6/src/Application.vala"
			_tmp6_ = enotes_settings;
#line 97 "../Notes-up-2.0.6/src/Application.vala"
			_tmp7_ = notes_path;
#line 97 "../Notes-up-2.0.6/src/Application.vala"
			_tmp8_ = g_build_filename (_tmp7_, "NotesUp.db", NULL);
#line 97 "../Notes-up-2.0.6/src/Application.vala"
			_tmp9_ = _tmp8_;
#line 97 "../Notes-up-2.0.6/src/Application.vala"
			enotes_services_settings_set_notes_database (_tmp6_, _tmp9_);
#line 97 "../Notes-up-2.0.6/src/Application.vala"
			_g_free0 (_tmp9_);
#line 94 "../Notes-up-2.0.6/src/Application.vala"
			_g_free0 (notes_path);
#line 911 "Application.c"
		}
#line 100 "../Notes-up-2.0.6/src/Application.vala"
		_tmp10_ = gtk_icon_theme_get_default ();
#line 100 "../Notes-up-2.0.6/src/Application.vala"
		default_theme = _tmp10_;
#line 101 "../Notes-up-2.0.6/src/Application.vala"
		_tmp11_ = default_theme;
#line 101 "../Notes-up-2.0.6/src/Application.vala"
		gtk_icon_theme_add_resource_path (_tmp11_, "/com/github/philip-scott/notes-up/icons/");
#line 921 "Application.c"
	}
}

static void
enotes_application_real_activate (GApplication* base)
{
	ENotesApplication * self;
	ENotesApplicationState* _tmp0_;
	ENotesServicesSettings* _tmp1_;
	ENotesServicesSettings* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
#line 105 "../Notes-up-2.0.6/src/Application.vala"
	self = (ENotesApplication*) base;
#line 106 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_init (self);
#line 107 "../Notes-up-2.0.6/src/Application.vala"
	_tmp0_ = self->state;
#line 107 "../Notes-up-2.0.6/src/Application.vala"
	_tmp1_ = enotes_services_settings_get_instance ();
#line 107 "../Notes-up-2.0.6/src/Application.vala"
	_tmp2_ = _tmp1_;
#line 107 "../Notes-up-2.0.6/src/Application.vala"
	_tmp3_ = enotes_services_settings_get_notes_database (_tmp2_);
#line 107 "../Notes-up-2.0.6/src/Application.vala"
	_tmp4_ = _tmp3_;
#line 107 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_set_database (_tmp0_, _tmp4_);
#line 107 "../Notes-up-2.0.6/src/Application.vala"
	_g_object_unref0 (_tmp2_);
#line 108 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_start_window (self);
#line 954 "Application.c"
}

static void
enotes_application_real_open (GApplication* base,
                              GFile** files,
                              gint files_length1,
                              const gchar* hint)
{
	ENotesApplication * self;
	ENotesApplicationState* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 111 "../Notes-up-2.0.6/src/Application.vala"
	self = (ENotesApplication*) base;
#line 111 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (hint != NULL);
#line 112 "../Notes-up-2.0.6/src/Application.vala"
	if (files_length1 > 1) {
#line 113 "../Notes-up-2.0.6/src/Application.vala"
		g_warning ("Application.vala:113: Only the first file will be opened");
#line 976 "Application.c"
	}
#line 117 "../Notes-up-2.0.6/src/Application.vala"
	if (!self->running) {
#line 118 "../Notes-up-2.0.6/src/Application.vala"
		enotes_application_init (self);
#line 982 "Application.c"
	}
#line 121 "../Notes-up-2.0.6/src/Application.vala"
	_tmp0_ = self->state;
#line 121 "../Notes-up-2.0.6/src/Application.vala"
	_tmp1_ = files[0];
#line 121 "../Notes-up-2.0.6/src/Application.vala"
	_tmp2_ = g_file_get_path (_tmp1_);
#line 121 "../Notes-up-2.0.6/src/Application.vala"
	_tmp3_ = _tmp2_;
#line 121 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_set_database (_tmp0_, _tmp3_);
#line 121 "../Notes-up-2.0.6/src/Application.vala"
	_g_free0 (_tmp3_);
#line 123 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_start_window (self);
#line 998 "Application.c"
}

static void
enotes_application_start_window (ENotesApplication* self)
{
	ENotesWindow* _tmp2_;
	ENotesWindow* _tmp3_;
#line 126 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (self != NULL);
#line 127 "../Notes-up-2.0.6/src/Application.vala"
	if (!self->running) {
#line 1010 "Application.c"
		ENotesWindow* window = NULL;
		ENotesWindow* _tmp0_;
		ENotesWindow* _tmp1_;
#line 128 "../Notes-up-2.0.6/src/Application.vala"
		_tmp0_ = enotes_window_new (self);
#line 128 "../Notes-up-2.0.6/src/Application.vala"
		g_object_ref_sink (_tmp0_);
#line 128 "../Notes-up-2.0.6/src/Application.vala"
		window = _tmp0_;
#line 129 "../Notes-up-2.0.6/src/Application.vala"
		_tmp1_ = window;
#line 129 "../Notes-up-2.0.6/src/Application.vala"
		gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp1_);
#line 131 "../Notes-up-2.0.6/src/Application.vala"
		self->running = TRUE;
#line 127 "../Notes-up-2.0.6/src/Application.vala"
		_g_object_unref0 (window);
#line 1028 "Application.c"
	}
#line 134 "../Notes-up-2.0.6/src/Application.vala"
	_tmp2_ = enotes_application_get_app_window (self);
#line 134 "../Notes-up-2.0.6/src/Application.vala"
	_tmp3_ = _tmp2_;
#line 134 "../Notes-up-2.0.6/src/Application.vala"
	enotes_window_show_app (_tmp3_);
#line 134 "../Notes-up-2.0.6/src/Application.vala"
	_g_object_unref0 (_tmp3_);
#line 1038 "Application.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 138 "../Notes-up-2.0.6/src/Application.vala"
	return self ? g_object_ref (self) : NULL;
#line 1046 "Application.c"
}

ENotesWindow*
enotes_application_get_app_window (ENotesApplication* self)
{
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	ENotesWindow* _tmp2_;
	ENotesWindow* result;
#line 137 "../Notes-up-2.0.6/src/Application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 138 "../Notes-up-2.0.6/src/Application.vala"
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
#line 138 "../Notes-up-2.0.6/src/Application.vala"
	_tmp1_ = _tmp0_;
#line 138 "../Notes-up-2.0.6/src/Application.vala"
	_tmp2_ = _g_object_ref0 (ENOTES_IS_WINDOW (_tmp1_) ? ((ENotesWindow*) _tmp1_) : NULL);
#line 138 "../Notes-up-2.0.6/src/Application.vala"
	result = _tmp2_;
#line 138 "../Notes-up-2.0.6/src/Application.vala"
	return result;
#line 1068 "Application.c"
}

ENotesApplication*
enotes_application_construct (GType object_type)
{
	ENotesApplication * self = NULL;
#line 69 "../Notes-up-2.0.6/src/Application.vala"
	self = (ENotesApplication*) granite_application_construct (object_type);
#line 69 "../Notes-up-2.0.6/src/Application.vala"
	return self;
#line 1079 "Application.c"
}

ENotesApplication*
enotes_application_new (void)
{
#line 69 "../Notes-up-2.0.6/src/Application.vala"
	return enotes_application_construct (ENOTES_TYPE_APPLICATION);
#line 1087 "Application.c"
}

static inline gpointer
enotes_application_state_get_instance_private (ENotesApplicationState* self)
{
	return G_STRUCT_MEMBER_P (self, ENotesApplicationState_private_offset);
}

static void
_g_free0_ (gpointer var)
{
#line 221 "../Notes-up-2.0.6/src/Application.vala"
	var = (g_free (var), NULL);
#line 1101 "Application.c"
}

static void
_vala_gchar_free_function_content_of (gpointer data)
{
	gchar* self;
#line 221 "../Notes-up-2.0.6/src/Application.vala"
	self = *((gchar**) data);
#line 221 "../Notes-up-2.0.6/src/Application.vala"
	_g_free0_ (self);
#line 1112 "Application.c"
}

void
enotes_application_state_set_database (ENotesApplicationState* self,
                                       const gchar* _db)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GArray* recent_files = NULL;
	GArray* _tmp2_;
	GArray* _tmp3_;
	gchar* _tmp4_;
	ENotesServicesSettings* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	gchar** _tmp8_;
	gint _tmp8__length1;
	ENotesServicesSettings* _tmp14_;
	GArray* _tmp15_;
	gpointer* _tmp16_;
	gint _tmp16__length1;
	ENotesServicesSettings* _tmp17_;
#line 203 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (self != NULL);
#line 203 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (_db != NULL);
#line 204 "../Notes-up-2.0.6/src/Application.vala"
	_tmp0_ = self->priv->_db;
#line 204 "../Notes-up-2.0.6/src/Application.vala"
	if (g_strcmp0 (_tmp0_, _db) == 0) {
#line 204 "../Notes-up-2.0.6/src/Application.vala"
		return;
#line 1146 "Application.c"
	}
#line 206 "../Notes-up-2.0.6/src/Application.vala"
	if (!db_is_file_valid (_db)) {
#line 207 "../Notes-up-2.0.6/src/Application.vala"
		return;
#line 1152 "Application.c"
	}
#line 210 "../Notes-up-2.0.6/src/Application.vala"
	g_signal_emit (self, enotes_application_state_signals[ENOTES_APPLICATION_STATE_PRE_DATABASE_CHANGE_SIGNAL], 0);
#line 211 "../Notes-up-2.0.6/src/Application.vala"
	database_table_terminate ();
#line 213 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_set_db (self, _db);
#line 215 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_set_opened_page_notebook (self, NULL);
#line 216 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_set_opened_notebook (self, NULL);
#line 217 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_set_opened_page (self, NULL);
#line 219 "../Notes-up-2.0.6/src/Application.vala"
	_tmp1_ = self->priv->_db;
#line 219 "../Notes-up-2.0.6/src/Application.vala"
	database_table_init (_tmp1_);
#line 221 "../Notes-up-2.0.6/src/Application.vala"
	_tmp2_ = g_array_new (TRUE, TRUE, sizeof (gchar*));
#line 221 "../Notes-up-2.0.6/src/Application.vala"
	g_array_set_clear_func (_tmp2_, (GDestroyNotify) _vala_gchar_free_function_content_of);
#line 221 "../Notes-up-2.0.6/src/Application.vala"
	recent_files = _tmp2_;
#line 222 "../Notes-up-2.0.6/src/Application.vala"
	_tmp3_ = recent_files;
#line 222 "../Notes-up-2.0.6/src/Application.vala"
	_tmp4_ = g_strdup (_db);
#line 222 "../Notes-up-2.0.6/src/Application.vala"
	g_array_append_val (_tmp3_, _tmp4_);
#line 224 "../Notes-up-2.0.6/src/Application.vala"
	_tmp5_ = enotes_settings;
#line 224 "../Notes-up-2.0.6/src/Application.vala"
	_tmp6_ = enotes_services_settings_get_recent_files (_tmp5_, &_tmp7_);
#line 224 "../Notes-up-2.0.6/src/Application.vala"
	_tmp6__length1 = _tmp7_;
#line 224 "../Notes-up-2.0.6/src/Application.vala"
	_tmp8_ = _tmp6_;
#line 224 "../Notes-up-2.0.6/src/Application.vala"
	_tmp8__length1 = _tmp6__length1;
#line 1192 "Application.c"
	{
		gchar** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
#line 224 "../Notes-up-2.0.6/src/Application.vala"
		file_collection = _tmp8_;
#line 224 "../Notes-up-2.0.6/src/Application.vala"
		file_collection_length1 = _tmp8__length1;
#line 224 "../Notes-up-2.0.6/src/Application.vala"
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
#line 1204 "Application.c"
			gchar* _tmp9_;
			gchar* file = NULL;
#line 224 "../Notes-up-2.0.6/src/Application.vala"
			_tmp9_ = g_strdup (file_collection[file_it]);
#line 224 "../Notes-up-2.0.6/src/Application.vala"
			file = _tmp9_;
#line 1211 "Application.c"
			{
				const gchar* _tmp10_;
				GArray* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
#line 225 "../Notes-up-2.0.6/src/Application.vala"
				_tmp10_ = file;
#line 225 "../Notes-up-2.0.6/src/Application.vala"
				if (g_strcmp0 (_tmp10_, _db) == 0) {
#line 225 "../Notes-up-2.0.6/src/Application.vala"
					_g_free0 (file);
#line 225 "../Notes-up-2.0.6/src/Application.vala"
					continue;
#line 1225 "Application.c"
				}
#line 226 "../Notes-up-2.0.6/src/Application.vala"
				_tmp11_ = recent_files;
#line 226 "../Notes-up-2.0.6/src/Application.vala"
				_tmp12_ = file;
#line 226 "../Notes-up-2.0.6/src/Application.vala"
				_tmp13_ = g_strdup (_tmp12_);
#line 226 "../Notes-up-2.0.6/src/Application.vala"
				g_array_append_val (_tmp11_, _tmp13_);
#line 224 "../Notes-up-2.0.6/src/Application.vala"
				_g_free0 (file);
#line 1237 "Application.c"
			}
		}
	}
#line 229 "../Notes-up-2.0.6/src/Application.vala"
	_tmp14_ = enotes_settings;
#line 229 "../Notes-up-2.0.6/src/Application.vala"
	_tmp15_ = recent_files;
#line 229 "../Notes-up-2.0.6/src/Application.vala"
	_tmp16_ = _tmp15_->data;
#line 229 "../Notes-up-2.0.6/src/Application.vala"
	_tmp16__length1 = _tmp15_->len;
#line 229 "../Notes-up-2.0.6/src/Application.vala"
	enotes_services_settings_set_recent_files (_tmp14_, _tmp16_, _tmp16__length1);
#line 230 "../Notes-up-2.0.6/src/Application.vala"
	_tmp17_ = enotes_settings;
#line 230 "../Notes-up-2.0.6/src/Application.vala"
	enotes_services_settings_set_notes_database (_tmp17_, _db);
#line 232 "../Notes-up-2.0.6/src/Application.vala"
	g_signal_emit (self, enotes_application_state_signals[ENOTES_APPLICATION_STATE_POST_DATABASE_CHANGE_SIGNAL], 0);
#line 203 "../Notes-up-2.0.6/src/Application.vala"
	_g_array_unref0 (recent_files);
#line 1259 "Application.c"
}

void
enotes_application_state_open_notebook (ENotesApplicationState* self,
                                        gint64 notebook_id)
{
#line 235 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (self != NULL);
#line 236 "../Notes-up-2.0.6/src/Application.vala"
	if (notebook_id != ((gint64) 0)) {
#line 1270 "Application.c"
		ENotesNotebookTable* _tmp0_;
		ENotesNotebookTable* _tmp1_;
		ENotesNotebook* _tmp2_;
		ENotesNotebook* _tmp3_;
#line 237 "../Notes-up-2.0.6/src/Application.vala"
		_tmp0_ = enotes_notebook_table_get_instance ();
#line 237 "../Notes-up-2.0.6/src/Application.vala"
		_tmp1_ = _tmp0_;
#line 237 "../Notes-up-2.0.6/src/Application.vala"
		_tmp2_ = enotes_notebook_table_load_notebook_data (_tmp1_, notebook_id);
#line 237 "../Notes-up-2.0.6/src/Application.vala"
		_tmp3_ = _tmp2_;
#line 237 "../Notes-up-2.0.6/src/Application.vala"
		enotes_application_state_set_opened_notebook (self, _tmp3_);
#line 237 "../Notes-up-2.0.6/src/Application.vala"
		_g_object_unref0 (_tmp3_);
#line 237 "../Notes-up-2.0.6/src/Application.vala"
		_database_table_unref0 (_tmp1_);
#line 1289 "Application.c"
	} else {
#line 239 "../Notes-up-2.0.6/src/Application.vala"
		g_signal_emit (self, enotes_application_state_signals[ENOTES_APPLICATION_STATE_LOAD_ALL_PAGES_SIGNAL], 0);
#line 1293 "Application.c"
	}
}

void
enotes_application_state_open_page (ENotesApplicationState* self,
                                    gint64 page_id)
{
	ENotesPage* page_to_open = NULL;
	ENotesPageTable* _tmp0_;
	ENotesPageTable* _tmp1_;
	ENotesPage* _tmp2_;
	ENotesPage* _tmp3_;
	ENotesPage* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ENotesNotebook* _tmp6_;
	ENotesPage* _tmp14_;
	ENotesApplication* _tmp15_;
	ENotesApplicationState* _tmp16_;
#line 243 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (self != NULL);
#line 244 "../Notes-up-2.0.6/src/Application.vala"
	g_signal_emit (self, enotes_application_state_signals[ENOTES_APPLICATION_STATE_REQUEST_SAVING_PAGE_INFO_SIGNAL], 0);
#line 245 "../Notes-up-2.0.6/src/Application.vala"
	_tmp0_ = enotes_page_table_get_instance ();
#line 245 "../Notes-up-2.0.6/src/Application.vala"
	_tmp1_ = _tmp0_;
#line 245 "../Notes-up-2.0.6/src/Application.vala"
	_tmp2_ = enotes_page_table_get_page (_tmp1_, page_id);
#line 245 "../Notes-up-2.0.6/src/Application.vala"
	_tmp3_ = _tmp2_;
#line 245 "../Notes-up-2.0.6/src/Application.vala"
	_database_table_unref0 (_tmp1_);
#line 245 "../Notes-up-2.0.6/src/Application.vala"
	page_to_open = _tmp3_;
#line 247 "../Notes-up-2.0.6/src/Application.vala"
	_tmp4_ = page_to_open;
#line 247 "../Notes-up-2.0.6/src/Application.vala"
	if (_tmp4_ == NULL) {
#line 247 "../Notes-up-2.0.6/src/Application.vala"
		_g_object_unref0 (page_to_open);
#line 247 "../Notes-up-2.0.6/src/Application.vala"
		return;
#line 1336 "Application.c"
	}
#line 249 "../Notes-up-2.0.6/src/Application.vala"
	_tmp6_ = self->priv->_opened_page_notebook;
#line 249 "../Notes-up-2.0.6/src/Application.vala"
	if (_tmp6_ == NULL) {
#line 249 "../Notes-up-2.0.6/src/Application.vala"
		_tmp5_ = TRUE;
#line 1344 "Application.c"
	} else {
		ENotesNotebook* _tmp7_;
		ENotesPage* _tmp8_;
#line 249 "../Notes-up-2.0.6/src/Application.vala"
		_tmp7_ = self->priv->_opened_page_notebook;
#line 249 "../Notes-up-2.0.6/src/Application.vala"
		_tmp8_ = page_to_open;
#line 249 "../Notes-up-2.0.6/src/Application.vala"
		_tmp5_ = _tmp7_->id != _tmp8_->notebook_id;
#line 1354 "Application.c"
	}
#line 249 "../Notes-up-2.0.6/src/Application.vala"
	if (_tmp5_) {
#line 1358 "Application.c"
		ENotesNotebookTable* _tmp9_;
		ENotesNotebookTable* _tmp10_;
		ENotesPage* _tmp11_;
		ENotesNotebook* _tmp12_;
		ENotesNotebook* _tmp13_;
#line 250 "../Notes-up-2.0.6/src/Application.vala"
		_tmp9_ = enotes_notebook_table_get_instance ();
#line 250 "../Notes-up-2.0.6/src/Application.vala"
		_tmp10_ = _tmp9_;
#line 250 "../Notes-up-2.0.6/src/Application.vala"
		_tmp11_ = page_to_open;
#line 250 "../Notes-up-2.0.6/src/Application.vala"
		_tmp12_ = enotes_notebook_table_load_notebook_data (_tmp10_, _tmp11_->notebook_id);
#line 250 "../Notes-up-2.0.6/src/Application.vala"
		_tmp13_ = _tmp12_;
#line 250 "../Notes-up-2.0.6/src/Application.vala"
		enotes_application_state_set_opened_page_notebook (self, _tmp13_);
#line 250 "../Notes-up-2.0.6/src/Application.vala"
		_g_object_unref0 (_tmp13_);
#line 250 "../Notes-up-2.0.6/src/Application.vala"
		_database_table_unref0 (_tmp10_);
#line 1380 "Application.c"
	}
#line 253 "../Notes-up-2.0.6/src/Application.vala"
	_tmp14_ = page_to_open;
#line 253 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_set_opened_page (self, _tmp14_);
#line 254 "../Notes-up-2.0.6/src/Application.vala"
	_tmp15_ = enotes_app;
#line 254 "../Notes-up-2.0.6/src/Application.vala"
	_tmp16_ = _tmp15_->state;
#line 254 "../Notes-up-2.0.6/src/Application.vala"
	g_signal_emit (_tmp16_, enotes_application_state_signals[ENOTES_APPLICATION_STATE_UPDATE_PAGE_TITLE_SIGNAL], 0);
#line 243 "../Notes-up-2.0.6/src/Application.vala"
	_g_object_unref0 (page_to_open);
#line 1394 "Application.c"
}

void
enotes_application_state_save_opened_page (ENotesApplicationState* self)
{
	ENotesPage* _tmp0_;
	ENotesPageTable* _tmp1_;
	ENotesPageTable* _tmp2_;
	ENotesPage* _tmp3_;
	ENotesPage* _tmp4_;
#line 257 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (self != NULL);
#line 258 "../Notes-up-2.0.6/src/Application.vala"
	_tmp0_ = self->priv->_opened_page;
#line 258 "../Notes-up-2.0.6/src/Application.vala"
	if (_tmp0_ == NULL) {
#line 258 "../Notes-up-2.0.6/src/Application.vala"
		return;
#line 1413 "Application.c"
	}
#line 260 "../Notes-up-2.0.6/src/Application.vala"
	_tmp1_ = enotes_page_table_get_instance ();
#line 260 "../Notes-up-2.0.6/src/Application.vala"
	_tmp2_ = _tmp1_;
#line 260 "../Notes-up-2.0.6/src/Application.vala"
	_tmp3_ = self->priv->_opened_page;
#line 260 "../Notes-up-2.0.6/src/Application.vala"
	enotes_page_table_save_page (_tmp2_, _tmp3_);
#line 260 "../Notes-up-2.0.6/src/Application.vala"
	_database_table_unref0 (_tmp2_);
#line 261 "../Notes-up-2.0.6/src/Application.vala"
	_tmp4_ = self->priv->_opened_page;
#line 261 "../Notes-up-2.0.6/src/Application.vala"
	_tmp4_->cache_changed = FALSE;
#line 263 "../Notes-up-2.0.6/src/Application.vala"
	g_signal_emit (self, enotes_application_state_signals[ENOTES_APPLICATION_STATE_UPDATE_PAGE_TITLE_SIGNAL], 0);
#line 264 "../Notes-up-2.0.6/src/Application.vala"
	g_signal_emit (self, enotes_application_state_signals[ENOTES_APPLICATION_STATE_PAGE_UPDATED_SIGNAL], 0);
#line 1433 "Application.c"
}

void
enotes_application_state_set_style (ENotesApplicationState* self,
                                    const gchar* style)
{
	GtkSettings* gtk_settings = NULL;
	GtkSettings* _tmp0_;
	GtkSettings* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
#line 270 "../Notes-up-2.0.6/src/Application.vala"
	static GQuark _tmp3_label0 = 0;
#line 270 "../Notes-up-2.0.6/src/Application.vala"
	static GQuark _tmp3_label1 = 0;
#line 267 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (self != NULL);
#line 267 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (style != NULL);
#line 268 "../Notes-up-2.0.6/src/Application.vala"
	_tmp0_ = gtk_settings_get_default ();
#line 268 "../Notes-up-2.0.6/src/Application.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 268 "../Notes-up-2.0.6/src/Application.vala"
	gtk_settings = _tmp1_;
#line 270 "../Notes-up-2.0.6/src/Application.vala"
	_tmp2_ = style;
#line 270 "../Notes-up-2.0.6/src/Application.vala"
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
#line 270 "../Notes-up-2.0.6/src/Application.vala"
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("solarized-light")))) {
#line 270 "../Notes-up-2.0.6/src/Application.vala"
		switch (0) {
#line 1467 "Application.c"
			default:
			{
				GtkSettings* _tmp5_;
#line 272 "../Notes-up-2.0.6/src/Application.vala"
				enotes_application_state_set_style_scheme (self, style);
#line 273 "../Notes-up-2.0.6/src/Application.vala"
				enotes_application_state_set_editor_scheme (self, style);
#line 274 "../Notes-up-2.0.6/src/Application.vala"
				_tmp5_ = gtk_settings;
#line 274 "../Notes-up-2.0.6/src/Application.vala"
				g_object_set (_tmp5_, "gtk-application-prefer-dark-theme", FALSE, NULL);
#line 275 "../Notes-up-2.0.6/src/Application.vala"
				break;
#line 1481 "Application.c"
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("solarized-dark")))) {
#line 270 "../Notes-up-2.0.6/src/Application.vala"
		switch (0) {
#line 1487 "Application.c"
			default:
			{
				GtkSettings* _tmp6_;
#line 277 "../Notes-up-2.0.6/src/Application.vala"
				enotes_application_state_set_style_scheme (self, style);
#line 278 "../Notes-up-2.0.6/src/Application.vala"
				enotes_application_state_set_editor_scheme (self, style);
#line 279 "../Notes-up-2.0.6/src/Application.vala"
				_tmp6_ = gtk_settings;
#line 279 "../Notes-up-2.0.6/src/Application.vala"
				g_object_set (_tmp6_, "gtk-application-prefer-dark-theme", TRUE, NULL);
#line 280 "../Notes-up-2.0.6/src/Application.vala"
				break;
#line 1501 "Application.c"
			}
		}
	} else {
#line 270 "../Notes-up-2.0.6/src/Application.vala"
		switch (0) {
#line 1507 "Application.c"
			default:
			{
				GtkSettings* _tmp7_;
#line 282 "../Notes-up-2.0.6/src/Application.vala"
				enotes_application_state_set_style_scheme (self, "high-contrast");
#line 283 "../Notes-up-2.0.6/src/Application.vala"
				enotes_application_state_set_editor_scheme (self, "classic");
#line 284 "../Notes-up-2.0.6/src/Application.vala"
				_tmp7_ = gtk_settings;
#line 284 "../Notes-up-2.0.6/src/Application.vala"
				g_object_set (_tmp7_, "gtk-application-prefer-dark-theme", FALSE, NULL);
#line 285 "../Notes-up-2.0.6/src/Application.vala"
				break;
#line 1521 "Application.c"
			}
		}
	}
#line 288 "../Notes-up-2.0.6/src/Application.vala"
	g_signal_emit (self, enotes_application_state_signals[ENOTES_APPLICATION_STATE_RELOAD_EDITOR_SETTINGS_SIGNAL], 0);
#line 267 "../Notes-up-2.0.6/src/Application.vala"
	_g_object_unref0 (gtk_settings);
#line 1529 "Application.c"
}

void
enotes_application_state_toggle_app_mode (ENotesApplicationState* self)
{
	ENotesMode _tmp0_;
#line 291 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (self != NULL);
#line 292 "../Notes-up-2.0.6/src/Application.vala"
	_tmp0_ = self->priv->_mode;
#line 292 "../Notes-up-2.0.6/src/Application.vala"
	if (_tmp0_ == ENOTES_MODE_EDIT) {
#line 293 "../Notes-up-2.0.6/src/Application.vala"
		enotes_application_state_set_mode (self, ENOTES_MODE_VIEW);
#line 1544 "Application.c"
	} else {
#line 295 "../Notes-up-2.0.6/src/Application.vala"
		enotes_application_state_set_mode (self, ENOTES_MODE_EDIT);
#line 1548 "Application.c"
	}
}

ENotesApplicationState*
enotes_application_state_construct (GType object_type)
{
	ENotesApplicationState * self = NULL;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	self = (ENotesApplicationState*) g_object_new (object_type, NULL);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	return self;
#line 1560 "Application.c"
}

ENotesApplicationState*
enotes_application_state_new (void)
{
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	return enotes_application_state_construct (ENOTES_APPLICATION_TYPE_STATE);
#line 1568 "Application.c"
}

const gchar*
enotes_application_state_get_db (ENotesApplicationState* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 144 "../Notes-up-2.0.6/src/Application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 144 "../Notes-up-2.0.6/src/Application.vala"
	_tmp0_ = self->priv->_db;
#line 144 "../Notes-up-2.0.6/src/Application.vala"
	result = _tmp0_;
#line 144 "../Notes-up-2.0.6/src/Application.vala"
	return result;
#line 1584 "Application.c"
}

static void
enotes_application_state_set_db (ENotesApplicationState* self,
                                 const gchar* value)
{
	gchar* old_value;
#line 144 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (self != NULL);
#line 144 "../Notes-up-2.0.6/src/Application.vala"
	old_value = enotes_application_state_get_db (self);
#line 144 "../Notes-up-2.0.6/src/Application.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1598 "Application.c"
		gchar* _tmp0_;
#line 144 "../Notes-up-2.0.6/src/Application.vala"
		_tmp0_ = g_strdup (value);
#line 144 "../Notes-up-2.0.6/src/Application.vala"
		_g_free0 (self->priv->_db);
#line 144 "../Notes-up-2.0.6/src/Application.vala"
		self->priv->_db = _tmp0_;
#line 144 "../Notes-up-2.0.6/src/Application.vala"
		g_object_notify_by_pspec ((GObject *) self, enotes_application_state_properties[ENOTES_APPLICATION_STATE_DB_PROPERTY]);
#line 1608 "Application.c"
	}
}

ENotesPage*
enotes_application_state_get_opened_page (ENotesApplicationState* self)
{
	ENotesPage* result;
	ENotesPage* _tmp0_;
#line 150 "../Notes-up-2.0.6/src/Application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 150 "../Notes-up-2.0.6/src/Application.vala"
	_tmp0_ = self->priv->_opened_page;
#line 150 "../Notes-up-2.0.6/src/Application.vala"
	result = _tmp0_;
#line 150 "../Notes-up-2.0.6/src/Application.vala"
	return result;
#line 1625 "Application.c"
}

static void
enotes_application_state_set_opened_page (ENotesApplicationState* self,
                                          ENotesPage* value)
{
	ENotesPage* old_value;
#line 150 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (self != NULL);
#line 150 "../Notes-up-2.0.6/src/Application.vala"
	old_value = enotes_application_state_get_opened_page (self);
#line 150 "../Notes-up-2.0.6/src/Application.vala"
	if (old_value != value) {
#line 1639 "Application.c"
		ENotesPage* _tmp0_;
#line 150 "../Notes-up-2.0.6/src/Application.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 150 "../Notes-up-2.0.6/src/Application.vala"
		_g_object_unref0 (self->priv->_opened_page);
#line 150 "../Notes-up-2.0.6/src/Application.vala"
		self->priv->_opened_page = _tmp0_;
#line 150 "../Notes-up-2.0.6/src/Application.vala"
		g_object_notify_by_pspec ((GObject *) self, enotes_application_state_properties[ENOTES_APPLICATION_STATE_OPENED_PAGE_PROPERTY]);
#line 1649 "Application.c"
	}
}

ENotesNotebook*
enotes_application_state_get_opened_page_notebook (ENotesApplicationState* self)
{
	ENotesNotebook* result;
	ENotesNotebook* _tmp0_;
#line 152 "../Notes-up-2.0.6/src/Application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 152 "../Notes-up-2.0.6/src/Application.vala"
	_tmp0_ = self->priv->_opened_page_notebook;
#line 152 "../Notes-up-2.0.6/src/Application.vala"
	result = _tmp0_;
#line 152 "../Notes-up-2.0.6/src/Application.vala"
	return result;
#line 1666 "Application.c"
}

static void
enotes_application_state_set_opened_page_notebook (ENotesApplicationState* self,
                                                   ENotesNotebook* value)
{
	ENotesNotebook* old_value;
#line 152 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (self != NULL);
#line 152 "../Notes-up-2.0.6/src/Application.vala"
	old_value = enotes_application_state_get_opened_page_notebook (self);
#line 152 "../Notes-up-2.0.6/src/Application.vala"
	if (old_value != value) {
#line 1680 "Application.c"
		ENotesNotebook* _tmp0_;
#line 152 "../Notes-up-2.0.6/src/Application.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 152 "../Notes-up-2.0.6/src/Application.vala"
		_g_object_unref0 (self->priv->_opened_page_notebook);
#line 152 "../Notes-up-2.0.6/src/Application.vala"
		self->priv->_opened_page_notebook = _tmp0_;
#line 152 "../Notes-up-2.0.6/src/Application.vala"
		g_object_notify_by_pspec ((GObject *) self, enotes_application_state_properties[ENOTES_APPLICATION_STATE_OPENED_PAGE_NOTEBOOK_PROPERTY]);
#line 1690 "Application.c"
	}
}

ENotesNotebook*
enotes_application_state_get_opened_notebook (ENotesApplicationState* self)
{
	ENotesNotebook* result;
	ENotesNotebook* _tmp0_;
#line 153 "../Notes-up-2.0.6/src/Application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 153 "../Notes-up-2.0.6/src/Application.vala"
	_tmp0_ = self->priv->_opened_notebook;
#line 153 "../Notes-up-2.0.6/src/Application.vala"
	result = _tmp0_;
#line 153 "../Notes-up-2.0.6/src/Application.vala"
	return result;
#line 1707 "Application.c"
}

void
enotes_application_state_set_opened_notebook (ENotesApplicationState* self,
                                              ENotesNotebook* value)
{
	ENotesNotebook* old_value;
#line 153 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (self != NULL);
#line 153 "../Notes-up-2.0.6/src/Application.vala"
	old_value = enotes_application_state_get_opened_notebook (self);
#line 153 "../Notes-up-2.0.6/src/Application.vala"
	if (old_value != value) {
#line 1721 "Application.c"
		ENotesNotebook* _tmp0_;
#line 153 "../Notes-up-2.0.6/src/Application.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 153 "../Notes-up-2.0.6/src/Application.vala"
		_g_object_unref0 (self->priv->_opened_notebook);
#line 153 "../Notes-up-2.0.6/src/Application.vala"
		self->priv->_opened_notebook = _tmp0_;
#line 153 "../Notes-up-2.0.6/src/Application.vala"
		g_object_notify_by_pspec ((GObject *) self, enotes_application_state_properties[ENOTES_APPLICATION_STATE_OPENED_NOTEBOOK_PROPERTY]);
#line 1731 "Application.c"
	}
}

ENotesMode
enotes_application_state_get_mode (ENotesApplicationState* self)
{
	ENotesMode result;
#line 155 "../Notes-up-2.0.6/src/Application.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 155 "../Notes-up-2.0.6/src/Application.vala"
	result = self->priv->_mode;
#line 155 "../Notes-up-2.0.6/src/Application.vala"
	return result;
#line 1745 "Application.c"
}

void
enotes_application_state_set_mode (ENotesApplicationState* self,
                                   ENotesMode value)
{
	ENotesMode old_value;
#line 155 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (self != NULL);
#line 155 "../Notes-up-2.0.6/src/Application.vala"
	old_value = enotes_application_state_get_mode (self);
#line 155 "../Notes-up-2.0.6/src/Application.vala"
	if (old_value != value) {
#line 155 "../Notes-up-2.0.6/src/Application.vala"
		self->priv->_mode = value;
#line 155 "../Notes-up-2.0.6/src/Application.vala"
		g_object_notify_by_pspec ((GObject *) self, enotes_application_state_properties[ENOTES_APPLICATION_STATE_MODE_PROPERTY]);
#line 1763 "Application.c"
	}
}

gboolean
enotes_application_state_get_show_page_info (ENotesApplicationState* self)
{
	gboolean result;
#line 156 "../Notes-up-2.0.6/src/Application.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 156 "../Notes-up-2.0.6/src/Application.vala"
	result = self->priv->_show_page_info;
#line 156 "../Notes-up-2.0.6/src/Application.vala"
	return result;
#line 1777 "Application.c"
}

void
enotes_application_state_set_show_page_info (ENotesApplicationState* self,
                                             gboolean value)
{
	gboolean old_value;
#line 156 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (self != NULL);
#line 156 "../Notes-up-2.0.6/src/Application.vala"
	old_value = enotes_application_state_get_show_page_info (self);
#line 156 "../Notes-up-2.0.6/src/Application.vala"
	if (old_value != value) {
#line 156 "../Notes-up-2.0.6/src/Application.vala"
		self->priv->_show_page_info = value;
#line 156 "../Notes-up-2.0.6/src/Application.vala"
		g_object_notify_by_pspec ((GObject *) self, enotes_application_state_properties[ENOTES_APPLICATION_STATE_SHOW_PAGE_INFO_PROPERTY]);
#line 1795 "Application.c"
	}
}

gint
enotes_application_state_get_panes_visible (ENotesApplicationState* self)
{
	gint result;
#line 158 "../Notes-up-2.0.6/src/Application.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 158 "../Notes-up-2.0.6/src/Application.vala"
	result = self->priv->_panes_visible;
#line 158 "../Notes-up-2.0.6/src/Application.vala"
	return result;
#line 1809 "Application.c"
}

void
enotes_application_state_set_panes_visible (ENotesApplicationState* self,
                                            gint value)
{
	gint old_value;
#line 158 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (self != NULL);
#line 158 "../Notes-up-2.0.6/src/Application.vala"
	old_value = enotes_application_state_get_panes_visible (self);
#line 158 "../Notes-up-2.0.6/src/Application.vala"
	if (old_value != value) {
#line 158 "../Notes-up-2.0.6/src/Application.vala"
		self->priv->_panes_visible = value;
#line 158 "../Notes-up-2.0.6/src/Application.vala"
		g_object_notify_by_pspec ((GObject *) self, enotes_application_state_properties[ENOTES_APPLICATION_STATE_PANES_VISIBLE_PROPERTY]);
#line 1827 "Application.c"
	}
}

const gchar*
enotes_application_state_get_style_scheme (ENotesApplicationState* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 160 "../Notes-up-2.0.6/src/Application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 160 "../Notes-up-2.0.6/src/Application.vala"
	_tmp0_ = self->priv->_style_scheme;
#line 160 "../Notes-up-2.0.6/src/Application.vala"
	result = _tmp0_;
#line 160 "../Notes-up-2.0.6/src/Application.vala"
	return result;
#line 1844 "Application.c"
}

static void
enotes_application_state_set_style_scheme (ENotesApplicationState* self,
                                           const gchar* value)
{
	gchar* old_value;
#line 160 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (self != NULL);
#line 160 "../Notes-up-2.0.6/src/Application.vala"
	old_value = enotes_application_state_get_style_scheme (self);
#line 160 "../Notes-up-2.0.6/src/Application.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1858 "Application.c"
		gchar* _tmp0_;
#line 160 "../Notes-up-2.0.6/src/Application.vala"
		_tmp0_ = g_strdup (value);
#line 160 "../Notes-up-2.0.6/src/Application.vala"
		_g_free0 (self->priv->_style_scheme);
#line 160 "../Notes-up-2.0.6/src/Application.vala"
		self->priv->_style_scheme = _tmp0_;
#line 160 "../Notes-up-2.0.6/src/Application.vala"
		g_object_notify_by_pspec ((GObject *) self, enotes_application_state_properties[ENOTES_APPLICATION_STATE_STYLE_SCHEME_PROPERTY]);
#line 1868 "Application.c"
	}
}

const gchar*
enotes_application_state_get_search_field (ENotesApplicationState* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 164 "../Notes-up-2.0.6/src/Application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 164 "../Notes-up-2.0.6/src/Application.vala"
	_tmp0_ = self->priv->_search_field;
#line 164 "../Notes-up-2.0.6/src/Application.vala"
	result = _tmp0_;
#line 164 "../Notes-up-2.0.6/src/Application.vala"
	return result;
#line 1885 "Application.c"
}

void
enotes_application_state_set_search_field (ENotesApplicationState* self,
                                           const gchar* value)
{
	gchar* old_value;
#line 164 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (self != NULL);
#line 164 "../Notes-up-2.0.6/src/Application.vala"
	old_value = enotes_application_state_get_search_field (self);
#line 164 "../Notes-up-2.0.6/src/Application.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1899 "Application.c"
		gchar* _tmp0_;
#line 164 "../Notes-up-2.0.6/src/Application.vala"
		_tmp0_ = g_strdup (value);
#line 164 "../Notes-up-2.0.6/src/Application.vala"
		_g_free0 (self->priv->_search_field);
#line 164 "../Notes-up-2.0.6/src/Application.vala"
		self->priv->_search_field = _tmp0_;
#line 164 "../Notes-up-2.0.6/src/Application.vala"
		g_object_notify_by_pspec ((GObject *) self, enotes_application_state_properties[ENOTES_APPLICATION_STATE_SEARCH_FIELD_PROPERTY]);
#line 1909 "Application.c"
	}
}

const gchar*
enotes_application_state_get_editor_font (ENotesApplicationState* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 189 "../Notes-up-2.0.6/src/Application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 189 "../Notes-up-2.0.6/src/Application.vala"
	_tmp0_ = self->priv->_editor_font;
#line 189 "../Notes-up-2.0.6/src/Application.vala"
	result = _tmp0_;
#line 189 "../Notes-up-2.0.6/src/Application.vala"
	return result;
#line 1926 "Application.c"
}

void
enotes_application_state_set_editor_font (ENotesApplicationState* self,
                                          const gchar* value)
{
	gchar* old_value;
#line 189 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (self != NULL);
#line 189 "../Notes-up-2.0.6/src/Application.vala"
	old_value = enotes_application_state_get_editor_font (self);
#line 189 "../Notes-up-2.0.6/src/Application.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1940 "Application.c"
		gchar* _tmp0_;
#line 189 "../Notes-up-2.0.6/src/Application.vala"
		_tmp0_ = g_strdup (value);
#line 189 "../Notes-up-2.0.6/src/Application.vala"
		_g_free0 (self->priv->_editor_font);
#line 189 "../Notes-up-2.0.6/src/Application.vala"
		self->priv->_editor_font = _tmp0_;
#line 189 "../Notes-up-2.0.6/src/Application.vala"
		g_object_notify_by_pspec ((GObject *) self, enotes_application_state_properties[ENOTES_APPLICATION_STATE_EDITOR_FONT_PROPERTY]);
#line 1950 "Application.c"
	}
}

const gchar*
enotes_application_state_get_editor_scheme (ENotesApplicationState* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 190 "../Notes-up-2.0.6/src/Application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 190 "../Notes-up-2.0.6/src/Application.vala"
	_tmp0_ = self->priv->_editor_scheme;
#line 190 "../Notes-up-2.0.6/src/Application.vala"
	result = _tmp0_;
#line 190 "../Notes-up-2.0.6/src/Application.vala"
	return result;
#line 1967 "Application.c"
}

void
enotes_application_state_set_editor_scheme (ENotesApplicationState* self,
                                            const gchar* value)
{
	gchar* old_value;
#line 190 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (self != NULL);
#line 190 "../Notes-up-2.0.6/src/Application.vala"
	old_value = enotes_application_state_get_editor_scheme (self);
#line 190 "../Notes-up-2.0.6/src/Application.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1981 "Application.c"
		gchar* _tmp0_;
#line 190 "../Notes-up-2.0.6/src/Application.vala"
		_tmp0_ = g_strdup (value);
#line 190 "../Notes-up-2.0.6/src/Application.vala"
		_g_free0 (self->priv->_editor_scheme);
#line 190 "../Notes-up-2.0.6/src/Application.vala"
		self->priv->_editor_scheme = _tmp0_;
#line 190 "../Notes-up-2.0.6/src/Application.vala"
		g_object_notify_by_pspec ((GObject *) self, enotes_application_state_properties[ENOTES_APPLICATION_STATE_EDITOR_SCHEME_PROPERTY]);
#line 1991 "Application.c"
	}
}

gboolean
enotes_application_state_get_editor_show_line_numbers (ENotesApplicationState* self)
{
	gboolean result;
#line 191 "../Notes-up-2.0.6/src/Application.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 191 "../Notes-up-2.0.6/src/Application.vala"
	result = self->priv->_editor_show_line_numbers;
#line 191 "../Notes-up-2.0.6/src/Application.vala"
	return result;
#line 2005 "Application.c"
}

void
enotes_application_state_set_editor_show_line_numbers (ENotesApplicationState* self,
                                                       gboolean value)
{
	gboolean old_value;
#line 191 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (self != NULL);
#line 191 "../Notes-up-2.0.6/src/Application.vala"
	old_value = enotes_application_state_get_editor_show_line_numbers (self);
#line 191 "../Notes-up-2.0.6/src/Application.vala"
	if (old_value != value) {
#line 191 "../Notes-up-2.0.6/src/Application.vala"
		self->priv->_editor_show_line_numbers = value;
#line 191 "../Notes-up-2.0.6/src/Application.vala"
		g_object_notify_by_pspec ((GObject *) self, enotes_application_state_properties[ENOTES_APPLICATION_STATE_EDITOR_SHOW_LINE_NUMBERS_PROPERTY]);
#line 2023 "Application.c"
	}
}

gboolean
enotes_application_state_get_editor_auto_indent (ENotesApplicationState* self)
{
	gboolean result;
#line 192 "../Notes-up-2.0.6/src/Application.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 192 "../Notes-up-2.0.6/src/Application.vala"
	result = self->priv->_editor_auto_indent;
#line 192 "../Notes-up-2.0.6/src/Application.vala"
	return result;
#line 2037 "Application.c"
}

void
enotes_application_state_set_editor_auto_indent (ENotesApplicationState* self,
                                                 gboolean value)
{
	gboolean old_value;
#line 192 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (self != NULL);
#line 192 "../Notes-up-2.0.6/src/Application.vala"
	old_value = enotes_application_state_get_editor_auto_indent (self);
#line 192 "../Notes-up-2.0.6/src/Application.vala"
	if (old_value != value) {
#line 192 "../Notes-up-2.0.6/src/Application.vala"
		self->priv->_editor_auto_indent = value;
#line 192 "../Notes-up-2.0.6/src/Application.vala"
		g_object_notify_by_pspec ((GObject *) self, enotes_application_state_properties[ENOTES_APPLICATION_STATE_EDITOR_AUTO_INDENT_PROPERTY]);
#line 2055 "Application.c"
	}
}

static void
g_cclosure_user_marshal_VOID__ENUM_STRING (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__ENUM_STRING) (gpointer data1, gint arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__ENUM_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (n_param_values == 3);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		data1 = closure->data;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		data2 = param_values->data[0].v_pointer;
#line 2081 "Application.c"
	} else {
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		data1 = param_values->data[0].v_pointer;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		data2 = closure->data;
#line 2087 "Application.c"
	}
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	callback = (GMarshalFunc_VOID__ENUM_STRING) (marshal_data ? marshal_data : cc->callback);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	callback (data1, g_value_get_enum (param_values + 1), g_value_get_string (param_values + 2), data2);
#line 2093 "Application.c"
}

static void
_enotes_application_state___lambda8_ (ENotesApplicationState* self,
                                      GParamSpec* spec)
{
	const gchar* _tmp0_;
#line 198 "../Notes-up-2.0.6/src/Application.vala"
	g_return_if_fail (spec != NULL);
#line 199 "../Notes-up-2.0.6/src/Application.vala"
	_tmp0_ = spec->name;
#line 199 "../Notes-up-2.0.6/src/Application.vala"
	g_debug ("Application.vala:199: Property changed in state: %s\n", _tmp0_);
#line 2107 "Application.c"
}

static void
__enotes_application_state___lambda8__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
#line 198 "../Notes-up-2.0.6/src/Application.vala"
	_enotes_application_state___lambda8_ ((ENotesApplicationState*) self, pspec);
#line 2117 "Application.c"
}

static GObject *
enotes_application_state_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ENotesApplicationState * self;
#line 197 "../Notes-up-2.0.6/src/Application.vala"
	parent_class = G_OBJECT_CLASS (enotes_application_state_parent_class);
#line 197 "../Notes-up-2.0.6/src/Application.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 197 "../Notes-up-2.0.6/src/Application.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationState);
#line 198 "../Notes-up-2.0.6/src/Application.vala"
	g_signal_connect_object ((GObject*) self, "notify", (GCallback) __enotes_application_state___lambda8__g_object_notify, self, 0);
#line 197 "../Notes-up-2.0.6/src/Application.vala"
	return obj;
#line 2138 "Application.c"
}

static void
enotes_application_state_class_init (ENotesApplicationStateClass * klass,
                                     gpointer klass_data)
{
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_parent_class = g_type_class_peek_parent (klass);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	g_type_class_adjust_private_offset (klass, &ENotesApplicationState_private_offset);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_enotes_application_state_get_property;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_enotes_application_state_set_property;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	G_OBJECT_CLASS (klass)->constructor = enotes_application_state_constructor;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	G_OBJECT_CLASS (klass)->finalize = enotes_application_state_finalize;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ENOTES_APPLICATION_STATE_DB_PROPERTY, enotes_application_state_properties[ENOTES_APPLICATION_STATE_DB_PROPERTY] = g_param_spec_string ("db", "db", "db", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ENOTES_APPLICATION_STATE_OPENED_PAGE_PROPERTY, enotes_application_state_properties[ENOTES_APPLICATION_STATE_OPENED_PAGE_PROPERTY] = g_param_spec_object ("opened-page", "opened-page", "opened-page", ENOTES_TYPE_PAGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ENOTES_APPLICATION_STATE_OPENED_PAGE_NOTEBOOK_PROPERTY, enotes_application_state_properties[ENOTES_APPLICATION_STATE_OPENED_PAGE_NOTEBOOK_PROPERTY] = g_param_spec_object ("opened-page-notebook", "opened-page-notebook", "opened-page-notebook", ENOTES_TYPE_NOTEBOOK, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ENOTES_APPLICATION_STATE_OPENED_NOTEBOOK_PROPERTY, enotes_application_state_properties[ENOTES_APPLICATION_STATE_OPENED_NOTEBOOK_PROPERTY] = g_param_spec_object ("opened-notebook", "opened-notebook", "opened-notebook", ENOTES_TYPE_NOTEBOOK, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ENOTES_APPLICATION_STATE_MODE_PROPERTY, enotes_application_state_properties[ENOTES_APPLICATION_STATE_MODE_PROPERTY] = g_param_spec_enum ("mode", "mode", "mode", ENOTES_TYPE_MODE, ENOTES_MODE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ENOTES_APPLICATION_STATE_SHOW_PAGE_INFO_PROPERTY, enotes_application_state_properties[ENOTES_APPLICATION_STATE_SHOW_PAGE_INFO_PROPERTY] = g_param_spec_boolean ("show-page-info", "show-page-info", "show-page-info", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ENOTES_APPLICATION_STATE_PANES_VISIBLE_PROPERTY, enotes_application_state_properties[ENOTES_APPLICATION_STATE_PANES_VISIBLE_PROPERTY] = g_param_spec_int ("panes-visible", "panes-visible", "panes-visible", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ENOTES_APPLICATION_STATE_STYLE_SCHEME_PROPERTY, enotes_application_state_properties[ENOTES_APPLICATION_STATE_STYLE_SCHEME_PROPERTY] = g_param_spec_string ("style-scheme", "style-scheme", "style-scheme", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ENOTES_APPLICATION_STATE_SEARCH_FIELD_PROPERTY, enotes_application_state_properties[ENOTES_APPLICATION_STATE_SEARCH_FIELD_PROPERTY] = g_param_spec_string ("search-field", "search-field", "search-field", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ENOTES_APPLICATION_STATE_EDITOR_FONT_PROPERTY, enotes_application_state_properties[ENOTES_APPLICATION_STATE_EDITOR_FONT_PROPERTY] = g_param_spec_string ("editor-font", "editor-font", "editor-font", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ENOTES_APPLICATION_STATE_EDITOR_SCHEME_PROPERTY, enotes_application_state_properties[ENOTES_APPLICATION_STATE_EDITOR_SCHEME_PROPERTY] = g_param_spec_string ("editor-scheme", "editor-scheme", "editor-scheme", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ENOTES_APPLICATION_STATE_EDITOR_SHOW_LINE_NUMBERS_PROPERTY, enotes_application_state_properties[ENOTES_APPLICATION_STATE_EDITOR_SHOW_LINE_NUMBERS_PROPERTY] = g_param_spec_boolean ("editor-show-line-numbers", "editor-show-line-numbers", "editor-show-line-numbers", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ENOTES_APPLICATION_STATE_EDITOR_AUTO_INDENT_PROPERTY, enotes_application_state_properties[ENOTES_APPLICATION_STATE_EDITOR_AUTO_INDENT_PROPERTY] = g_param_spec_boolean ("editor-auto-indent", "editor-auto-indent", "editor-auto-indent", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_signals[ENOTES_APPLICATION_STATE_PRE_DATABASE_CHANGE_SIGNAL] = g_signal_new ("pre-database-change", ENOTES_APPLICATION_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_signals[ENOTES_APPLICATION_STATE_POST_DATABASE_CHANGE_SIGNAL] = g_signal_new ("post-database-change", ENOTES_APPLICATION_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_signals[ENOTES_APPLICATION_STATE_UPDATE_PAGE_TITLE_SIGNAL] = g_signal_new ("update-page-title", ENOTES_APPLICATION_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_signals[ENOTES_APPLICATION_STATE_SEARCH_SELECTED_SIGNAL] = g_signal_new ("search-selected", ENOTES_APPLICATION_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_signals[ENOTES_APPLICATION_STATE_BOOKMARK_CHANGED_SIGNAL] = g_signal_new ("bookmark-changed", ENOTES_APPLICATION_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_signals[ENOTES_APPLICATION_STATE_REQUEST_SAVING_PAGE_INFO_SIGNAL] = g_signal_new ("request-saving-page-info", ENOTES_APPLICATION_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_signals[ENOTES_APPLICATION_STATE_PAGE_TEXT_UPDATED_SIGNAL] = g_signal_new ("page-text-updated", ENOTES_APPLICATION_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_signals[ENOTES_APPLICATION_STATE_PAGE_UPDATED_SIGNAL] = g_signal_new ("page-updated", ENOTES_APPLICATION_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_signals[ENOTES_APPLICATION_STATE_PAGE_DELETED_SIGNAL] = g_signal_new ("page-deleted", ENOTES_APPLICATION_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_signals[ENOTES_APPLICATION_STATE_OPENED_NOTEBOOK_UPDATED_SIGNAL] = g_signal_new ("opened-notebook-updated", ENOTES_APPLICATION_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_signals[ENOTES_APPLICATION_STATE_LOAD_ALL_PAGES_SIGNAL] = g_signal_new ("load-all-pages", ENOTES_APPLICATION_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_signals[ENOTES_APPLICATION_STATE_NOTEBOOK_CONTENTS_CHANGED_SIGNAL] = g_signal_new ("notebook-contents-changed", ENOTES_APPLICATION_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_signals[ENOTES_APPLICATION_STATE_TAGS_CHANGED_SIGNAL] = g_signal_new ("tags-changed", ENOTES_APPLICATION_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_signals[ENOTES_APPLICATION_STATE_SHOW_ALL_PAGES_SIGNAL] = g_signal_new ("show-all-pages", ENOTES_APPLICATION_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_signals[ENOTES_APPLICATION_STATE_SHOW_PAGES_IN_TAG_SIGNAL] = g_signal_new ("show-pages-in-tag", ENOTES_APPLICATION_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, ENOTES_TYPE_TAG);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_signals[ENOTES_APPLICATION_STATE_RELOAD_EDITOR_SETTINGS_SIGNAL] = g_signal_new ("reload-editor-settings", ENOTES_APPLICATION_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_state_signals[ENOTES_APPLICATION_STATE_FILE_DATA_CHANGED_SIGNAL] = g_signal_new ("file-data-changed", ENOTES_APPLICATION_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__ENUM_STRING, G_TYPE_NONE, 2, TYPE_FILE_DATA_TYPE, G_TYPE_STRING);
#line 2217 "Application.c"
}

static void
enotes_application_state_instance_init (ENotesApplicationState * self,
                                        gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	self->priv = enotes_application_state_get_instance_private (self);
#line 155 "../Notes-up-2.0.6/src/Application.vala"
	self->priv->_mode = ENOTES_MODE_NONE;
#line 158 "../Notes-up-2.0.6/src/Application.vala"
	self->priv->_panes_visible = -1;
#line 164 "../Notes-up-2.0.6/src/Application.vala"
	_tmp0_ = g_strdup ("");
#line 164 "../Notes-up-2.0.6/src/Application.vala"
	self->priv->_search_field = _tmp0_;
#line 189 "../Notes-up-2.0.6/src/Application.vala"
	_tmp1_ = g_strdup ("");
#line 189 "../Notes-up-2.0.6/src/Application.vala"
	self->priv->_editor_font = _tmp1_;
#line 190 "../Notes-up-2.0.6/src/Application.vala"
	_tmp2_ = g_strdup ("classic");
#line 190 "../Notes-up-2.0.6/src/Application.vala"
	self->priv->_editor_scheme = _tmp2_;
#line 2245 "Application.c"
}

static void
enotes_application_state_finalize (GObject * obj)
{
	ENotesApplicationState * self;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationState);
#line 144 "../Notes-up-2.0.6/src/Application.vala"
	_g_free0 (self->priv->_db);
#line 150 "../Notes-up-2.0.6/src/Application.vala"
	_g_object_unref0 (self->priv->_opened_page);
#line 152 "../Notes-up-2.0.6/src/Application.vala"
	_g_object_unref0 (self->priv->_opened_page_notebook);
#line 153 "../Notes-up-2.0.6/src/Application.vala"
	_g_object_unref0 (self->priv->_opened_notebook);
#line 160 "../Notes-up-2.0.6/src/Application.vala"
	_g_free0 (self->priv->_style_scheme);
#line 164 "../Notes-up-2.0.6/src/Application.vala"
	_g_free0 (self->priv->_search_field);
#line 189 "../Notes-up-2.0.6/src/Application.vala"
	_g_free0 (self->priv->_editor_font);
#line 190 "../Notes-up-2.0.6/src/Application.vala"
	_g_free0 (self->priv->_editor_scheme);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	G_OBJECT_CLASS (enotes_application_state_parent_class)->finalize (obj);
#line 2272 "Application.c"
}

static GType
enotes_application_state_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesApplicationStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_application_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesApplicationState), 0, (GInstanceInitFunc) enotes_application_state_instance_init, NULL };
	GType enotes_application_state_type_id;
	enotes_application_state_type_id = g_type_register_static (G_TYPE_OBJECT, "ENotesApplicationState", &g_define_type_info, 0);
	ENotesApplicationState_private_offset = g_type_add_instance_private (enotes_application_state_type_id, sizeof (ENotesApplicationStatePrivate));
	return enotes_application_state_type_id;
}

GType
enotes_application_state_get_type (void)
{
	static volatile gsize enotes_application_state_type_id__once = 0;
	if (g_once_init_enter (&enotes_application_state_type_id__once)) {
		GType enotes_application_state_type_id;
		enotes_application_state_type_id = enotes_application_state_get_type_once ();
		g_once_init_leave (&enotes_application_state_type_id__once, enotes_application_state_type_id);
	}
	return enotes_application_state_type_id__once;
}

static void
_vala_enotes_application_state_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	ENotesApplicationState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationState);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	switch (property_id) {
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_DB_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		g_value_set_string (value, enotes_application_state_get_db (self));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_OPENED_PAGE_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		g_value_set_object (value, enotes_application_state_get_opened_page (self));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_OPENED_PAGE_NOTEBOOK_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		g_value_set_object (value, enotes_application_state_get_opened_page_notebook (self));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_OPENED_NOTEBOOK_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		g_value_set_object (value, enotes_application_state_get_opened_notebook (self));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_MODE_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		g_value_set_enum (value, enotes_application_state_get_mode (self));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_SHOW_PAGE_INFO_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		g_value_set_boolean (value, enotes_application_state_get_show_page_info (self));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_PANES_VISIBLE_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		g_value_set_int (value, enotes_application_state_get_panes_visible (self));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_STYLE_SCHEME_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		g_value_set_string (value, enotes_application_state_get_style_scheme (self));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_SEARCH_FIELD_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		g_value_set_string (value, enotes_application_state_get_search_field (self));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_EDITOR_FONT_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		g_value_set_string (value, enotes_application_state_get_editor_font (self));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_EDITOR_SCHEME_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		g_value_set_string (value, enotes_application_state_get_editor_scheme (self));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_EDITOR_SHOW_LINE_NUMBERS_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		g_value_set_boolean (value, enotes_application_state_get_editor_show_line_numbers (self));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_EDITOR_AUTO_INDENT_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		g_value_set_boolean (value, enotes_application_state_get_editor_auto_indent (self));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 2385 "Application.c"
		default:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 2391 "Application.c"
	}
}

static void
_vala_enotes_application_state_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	ENotesApplicationState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationState);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
	switch (property_id) {
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_DB_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		enotes_application_state_set_db (self, g_value_get_string (value));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_OPENED_PAGE_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		enotes_application_state_set_opened_page (self, g_value_get_object (value));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_OPENED_PAGE_NOTEBOOK_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		enotes_application_state_set_opened_page_notebook (self, g_value_get_object (value));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_OPENED_NOTEBOOK_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		enotes_application_state_set_opened_notebook (self, g_value_get_object (value));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_MODE_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		enotes_application_state_set_mode (self, g_value_get_enum (value));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_SHOW_PAGE_INFO_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		enotes_application_state_set_show_page_info (self, g_value_get_boolean (value));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_PANES_VISIBLE_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		enotes_application_state_set_panes_visible (self, g_value_get_int (value));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_STYLE_SCHEME_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		enotes_application_state_set_style_scheme (self, g_value_get_string (value));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_SEARCH_FIELD_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		enotes_application_state_set_search_field (self, g_value_get_string (value));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_EDITOR_FONT_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		enotes_application_state_set_editor_font (self, g_value_get_string (value));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_EDITOR_SCHEME_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		enotes_application_state_set_editor_scheme (self, g_value_get_string (value));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_EDITOR_SHOW_LINE_NUMBERS_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		enotes_application_state_set_editor_show_line_numbers (self, g_value_get_boolean (value));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		case ENOTES_APPLICATION_STATE_EDITOR_AUTO_INDENT_PROPERTY:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		enotes_application_state_set_editor_auto_indent (self, g_value_get_boolean (value));
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 2483 "Application.c"
		default:
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 142 "../Notes-up-2.0.6/src/Application.vala"
		break;
#line 2489 "Application.c"
	}
}

static GObject *
enotes_application_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ENotesApplication * self;
	GApplicationFlags _tmp0_;
	GApplicationFlags _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	ENotesApplicationState* _tmp5_;
#line 77 "../Notes-up-2.0.6/src/Application.vala"
	parent_class = G_OBJECT_CLASS (enotes_application_parent_class);
#line 77 "../Notes-up-2.0.6/src/Application.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 77 "../Notes-up-2.0.6/src/Application.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_APPLICATION, ENotesApplication);
#line 78 "../Notes-up-2.0.6/src/Application.vala"
	_tmp0_ = g_application_get_flags ((GApplication*) self);
#line 78 "../Notes-up-2.0.6/src/Application.vala"
	_tmp1_ = _tmp0_;
#line 78 "../Notes-up-2.0.6/src/Application.vala"
	g_application_set_flags ((GApplication*) self, _tmp1_ | G_APPLICATION_HANDLES_OPEN);
#line 80 "../Notes-up-2.0.6/src/Application.vala"
	g_application_set_application_id ((GApplication*) self, "com.github.philip_scott.notes-up");
#line 81 "../Notes-up-2.0.6/src/Application.vala"
	_tmp2_ = g_strdup (ENOTES_APPLICATION_PROGRAM_NAME);
#line 81 "../Notes-up-2.0.6/src/Application.vala"
	_g_free0 (((GraniteApplication*) self)->program_name);
#line 81 "../Notes-up-2.0.6/src/Application.vala"
	((GraniteApplication*) self)->program_name = _tmp2_;
#line 82 "../Notes-up-2.0.6/src/Application.vala"
	_tmp3_ = g_strdup (TERMINAL_NAME);
#line 82 "../Notes-up-2.0.6/src/Application.vala"
	_g_free0 (((GraniteApplication*) self)->exec_name);
#line 82 "../Notes-up-2.0.6/src/Application.vala"
	((GraniteApplication*) self)->exec_name = _tmp3_;
#line 83 "../Notes-up-2.0.6/src/Application.vala"
	_tmp4_ = g_strdup ("com.github.philip_scott.notes-up");
#line 83 "../Notes-up-2.0.6/src/Application.vala"
	_g_free0 (((GraniteApplication*) self)->app_launcher);
#line 83 "../Notes-up-2.0.6/src/Application.vala"
	((GraniteApplication*) self)->app_launcher = _tmp4_;
#line 85 "../Notes-up-2.0.6/src/Application.vala"
	_tmp5_ = enotes_application_state_new ();
#line 85 "../Notes-up-2.0.6/src/Application.vala"
	_g_object_unref0 (self->state);
#line 85 "../Notes-up-2.0.6/src/Application.vala"
	self->state = _tmp5_;
#line 77 "../Notes-up-2.0.6/src/Application.vala"
	return obj;
#line 2547 "Application.c"
}

static void
enotes_application_class_init (ENotesApplicationClass * klass,
                               gpointer klass_data)
{
#line 69 "../Notes-up-2.0.6/src/Application.vala"
	enotes_application_parent_class = g_type_class_peek_parent (klass);
#line 69 "../Notes-up-2.0.6/src/Application.vala"
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) enotes_application_real_activate;
#line 69 "../Notes-up-2.0.6/src/Application.vala"
	((GApplicationClass *) klass)->open = (void (*) (GApplication*, GFile**, gint, const gchar*)) enotes_application_real_open;
#line 69 "../Notes-up-2.0.6/src/Application.vala"
	G_OBJECT_CLASS (klass)->constructor = enotes_application_constructor;
#line 69 "../Notes-up-2.0.6/src/Application.vala"
	G_OBJECT_CLASS (klass)->finalize = enotes_application_finalize;
#line 2564 "Application.c"
}

static void
enotes_application_instance_init (ENotesApplication * self,
                                  gpointer klass)
{
#line 74 "../Notes-up-2.0.6/src/Application.vala"
	self->running = FALSE;
#line 2573 "Application.c"
}

static void
enotes_application_finalize (GObject * obj)
{
	ENotesApplication * self;
#line 69 "../Notes-up-2.0.6/src/Application.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_APPLICATION, ENotesApplication);
#line 75 "../Notes-up-2.0.6/src/Application.vala"
	_g_object_unref0 (self->state);
#line 69 "../Notes-up-2.0.6/src/Application.vala"
	G_OBJECT_CLASS (enotes_application_parent_class)->finalize (obj);
#line 2586 "Application.c"
}

static GType
enotes_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesApplication), 0, (GInstanceInitFunc) enotes_application_instance_init, NULL };
	GType enotes_application_type_id;
	enotes_application_type_id = g_type_register_static (GRANITE_TYPE_APPLICATION, "ENotesApplication", &g_define_type_info, 0);
	return enotes_application_type_id;
}

GType
enotes_application_get_type (void)
{
	static volatile gsize enotes_application_type_id__once = 0;
	if (g_once_init_enter (&enotes_application_type_id__once)) {
		GType enotes_application_type_id;
		enotes_application_type_id = enotes_application_get_type_once ();
		g_once_init_leave (&enotes_application_type_id__once, enotes_application_type_id);
	}
	return enotes_application_type_id__once;
}

