// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from webkit-gir-files
// DO NOT EDIT

use crate::{PrintOperationResponse, WebView};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "WebKitPrintOperation")]
    pub struct PrintOperation(Object<ffi::WebKitPrintOperation, ffi::WebKitPrintOperationClass>);

    match fn {
        type_ => || ffi::webkit_print_operation_get_type(),
    }
}

impl PrintOperation {
    #[doc(alias = "webkit_print_operation_new")]
    pub fn new(web_view: &impl IsA<WebView>) -> PrintOperation {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::webkit_print_operation_new(
                web_view.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_print_operation_get_page_setup")]
    #[doc(alias = "get_page_setup")]
    pub fn page_setup(&self) -> Option<gtk::PageSetup> {
        unsafe {
            from_glib_none(ffi::webkit_print_operation_get_page_setup(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_print_operation_get_print_settings")]
    #[doc(alias = "get_print_settings")]
    pub fn print_settings(&self) -> Option<gtk::PrintSettings> {
        unsafe {
            from_glib_none(ffi::webkit_print_operation_get_print_settings(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_print_operation_print")]
    pub fn print(&self) {
        unsafe {
            ffi::webkit_print_operation_print(self.to_glib_none().0);
        }
    }

    #[doc(alias = "webkit_print_operation_run_dialog")]
    pub fn run_dialog(&self, parent: Option<&impl IsA<gtk::Window>>) -> PrintOperationResponse {
        unsafe {
            from_glib(ffi::webkit_print_operation_run_dialog(
                self.to_glib_none().0,
                parent.map(|p| p.as_ref()).to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_print_operation_set_page_setup")]
    pub fn set_page_setup(&self, page_setup: &gtk::PageSetup) {
        unsafe {
            ffi::webkit_print_operation_set_page_setup(
                self.to_glib_none().0,
                page_setup.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "webkit_print_operation_set_print_settings")]
    pub fn set_print_settings(&self, print_settings: &gtk::PrintSettings) {
        unsafe {
            ffi::webkit_print_operation_set_print_settings(
                self.to_glib_none().0,
                print_settings.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "web-view")]
    pub fn web_view(&self) -> Option<WebView> {
        glib::ObjectExt::property(self, "web-view")
    }

    #[doc(alias = "failed")]
    pub fn connect_failed<F: Fn(&Self, &glib::Error) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn failed_trampoline<F: Fn(&PrintOperation, &glib::Error) + 'static>(
            this: *mut ffi::WebKitPrintOperation,
            error: *mut glib::ffi::GError,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(error))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"failed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    failed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "finished")]
    pub fn connect_finished<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn finished_trampoline<F: Fn(&PrintOperation) + 'static>(
            this: *mut ffi::WebKitPrintOperation,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"finished\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    finished_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "page-setup")]
    pub fn connect_page_setup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_page_setup_trampoline<F: Fn(&PrintOperation) + 'static>(
            this: *mut ffi::WebKitPrintOperation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::page-setup\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_page_setup_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "print-settings")]
    pub fn connect_print_settings_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_print_settings_trampoline<F: Fn(&PrintOperation) + 'static>(
            this: *mut ffi::WebKitPrintOperation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::print-settings\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_print_settings_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for PrintOperation {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("PrintOperation")
    }
}
