// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from webkit-gir-files
// DO NOT EDIT

use crate::{URIRequest, URIResponse, WebView};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "WebKitDownload")]
    pub struct Download(Object<ffi::WebKitDownload, ffi::WebKitDownloadClass>);

    match fn {
        type_ => || ffi::webkit_download_get_type(),
    }
}

impl Download {
    #[doc(alias = "webkit_download_cancel")]
    pub fn cancel(&self) {
        unsafe {
            ffi::webkit_download_cancel(self.to_glib_none().0);
        }
    }

    #[doc(alias = "webkit_download_get_allow_overwrite")]
    #[doc(alias = "get_allow_overwrite")]
    pub fn allows_overwrite(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_download_get_allow_overwrite(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_download_get_destination")]
    #[doc(alias = "get_destination")]
    pub fn destination(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::webkit_download_get_destination(self.to_glib_none().0)) }
    }

    #[doc(alias = "webkit_download_get_elapsed_time")]
    #[doc(alias = "get_elapsed_time")]
    pub fn elapsed_time(&self) -> f64 {
        unsafe { ffi::webkit_download_get_elapsed_time(self.to_glib_none().0) }
    }

    #[doc(alias = "webkit_download_get_estimated_progress")]
    #[doc(alias = "get_estimated_progress")]
    pub fn estimated_progress(&self) -> f64 {
        unsafe { ffi::webkit_download_get_estimated_progress(self.to_glib_none().0) }
    }

    #[doc(alias = "webkit_download_get_received_data_length")]
    #[doc(alias = "get_received_data_length")]
    pub fn received_data_length(&self) -> u64 {
        unsafe { ffi::webkit_download_get_received_data_length(self.to_glib_none().0) }
    }

    #[doc(alias = "webkit_download_get_request")]
    #[doc(alias = "get_request")]
    pub fn request(&self) -> Option<URIRequest> {
        unsafe { from_glib_none(ffi::webkit_download_get_request(self.to_glib_none().0)) }
    }

    #[doc(alias = "webkit_download_get_response")]
    #[doc(alias = "get_response")]
    pub fn response(&self) -> Option<URIResponse> {
        unsafe { from_glib_none(ffi::webkit_download_get_response(self.to_glib_none().0)) }
    }

    #[doc(alias = "webkit_download_get_web_view")]
    #[doc(alias = "get_web_view")]
    pub fn web_view(&self) -> Option<WebView> {
        unsafe { from_glib_none(ffi::webkit_download_get_web_view(self.to_glib_none().0)) }
    }

    #[doc(alias = "webkit_download_set_allow_overwrite")]
    pub fn set_allow_overwrite(&self, allowed: bool) {
        unsafe {
            ffi::webkit_download_set_allow_overwrite(self.to_glib_none().0, allowed.into_glib());
        }
    }

    #[doc(alias = "webkit_download_set_destination")]
    pub fn set_destination(&self, destination: &str) {
        unsafe {
            ffi::webkit_download_set_destination(
                self.to_glib_none().0,
                destination.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "created-destination")]
    pub fn connect_created_destination<F: Fn(&Self, &str) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn created_destination_trampoline<F: Fn(&Download, &str) + 'static>(
            this: *mut ffi::WebKitDownload,
            destination: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                &glib::GString::from_glib_borrow(destination),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"created-destination\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    created_destination_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "decide-destination")]
    pub fn connect_decide_destination<F: Fn(&Self, &str) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn decide_destination_trampoline<
            F: Fn(&Download, &str) -> bool + 'static,
        >(
            this: *mut ffi::WebKitDownload,
            suggested_filename: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                &glib::GString::from_glib_borrow(suggested_filename),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"decide-destination\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    decide_destination_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "failed")]
    pub fn connect_failed<F: Fn(&Self, &glib::Error) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn failed_trampoline<F: Fn(&Download, &glib::Error) + 'static>(
            this: *mut ffi::WebKitDownload,
            error: *mut glib::ffi::GError,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(error))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"failed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    failed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "finished")]
    pub fn connect_finished<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn finished_trampoline<F: Fn(&Download) + 'static>(
            this: *mut ffi::WebKitDownload,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"finished\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    finished_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "received-data")]
    pub fn connect_received_data<F: Fn(&Self, u64) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn received_data_trampoline<F: Fn(&Download, u64) + 'static>(
            this: *mut ffi::WebKitDownload,
            data_length: u64,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), data_length)
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"received-data\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    received_data_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "allow-overwrite")]
    pub fn connect_allow_overwrite_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_allow_overwrite_trampoline<F: Fn(&Download) + 'static>(
            this: *mut ffi::WebKitDownload,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::allow-overwrite\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_allow_overwrite_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "destination")]
    pub fn connect_destination_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_destination_trampoline<F: Fn(&Download) + 'static>(
            this: *mut ffi::WebKitDownload,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::destination\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_destination_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "estimated-progress")]
    pub fn connect_estimated_progress_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_estimated_progress_trampoline<F: Fn(&Download) + 'static>(
            this: *mut ffi::WebKitDownload,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::estimated-progress\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_estimated_progress_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "response")]
    pub fn connect_response_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_response_trampoline<F: Fn(&Download) + 'static>(
            this: *mut ffi::WebKitDownload,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::response\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_response_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Download {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Download")
    }
}
