/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "nemo-cinnamon-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_monitor,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.Cinnamon
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NemoCinnamon
 * @title: NemoCinnamon
 * @short_description: Generated C code for the org.Cinnamon D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-Cinnamon.top_of_page">org.Cinnamon</link> D-Bus interface in C.
 */

enum
{
  NEMO__CINNAMON_MONITORS_CHANGED,
  NEMO__CINNAMON_RUN_STATE_CHANGED,
};

static unsigned NEMO__CINNAMON_SIGNALS[2] = { 0 };

/* ---- Introspection data for org.Cinnamon ---- */

static const _ExtendedGDBusArgInfo _nemo_cinnamon_method_info_get_monitors_OUT_ARG_monitors =
{
  {
    -1,
    (gchar *) "monitors",
    (gchar *) "ai",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nemo_cinnamon_method_info_get_monitors_OUT_ARG_pointers[] =
{
  &_nemo_cinnamon_method_info_get_monitors_OUT_ARG_monitors.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nemo_cinnamon_method_info_get_monitors =
{
  {
    -1,
    (gchar *) "GetMonitors",
    NULL,
    (GDBusArgInfo **) &_nemo_cinnamon_method_info_get_monitors_OUT_ARG_pointers,
    NULL
  },
  "handle-get-monitors",
  FALSE
};

static const _ExtendedGDBusArgInfo _nemo_cinnamon_method_info_get_monitor_work_rect_IN_ARG_monitor =
{
  {
    -1,
    (gchar *) "monitor",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nemo_cinnamon_method_info_get_monitor_work_rect_IN_ARG_pointers[] =
{
  &_nemo_cinnamon_method_info_get_monitor_work_rect_IN_ARG_monitor.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _nemo_cinnamon_method_info_get_monitor_work_rect_OUT_ARG_rect =
{
  {
    -1,
    (gchar *) "rect",
    (gchar *) "ai",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nemo_cinnamon_method_info_get_monitor_work_rect_OUT_ARG_pointers[] =
{
  &_nemo_cinnamon_method_info_get_monitor_work_rect_OUT_ARG_rect.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nemo_cinnamon_method_info_get_monitor_work_rect =
{
  {
    -1,
    (gchar *) "GetMonitorWorkRect",
    (GDBusArgInfo **) &_nemo_cinnamon_method_info_get_monitor_work_rect_IN_ARG_pointers,
    (GDBusArgInfo **) &_nemo_cinnamon_method_info_get_monitor_work_rect_OUT_ARG_pointers,
    NULL
  },
  "handle-get-monitor-work-rect",
  FALSE
};

static const _ExtendedGDBusArgInfo _nemo_cinnamon_method_info_get_run_state_OUT_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nemo_cinnamon_method_info_get_run_state_OUT_ARG_pointers[] =
{
  &_nemo_cinnamon_method_info_get_run_state_OUT_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nemo_cinnamon_method_info_get_run_state =
{
  {
    -1,
    (gchar *) "GetRunState",
    NULL,
    (GDBusArgInfo **) &_nemo_cinnamon_method_info_get_run_state_OUT_ARG_pointers,
    NULL
  },
  "handle-get-run-state",
  FALSE
};

static const GDBusMethodInfo * const _nemo_cinnamon_method_info_pointers[] =
{
  &_nemo_cinnamon_method_info_get_monitors.parent_struct,
  &_nemo_cinnamon_method_info_get_monitor_work_rect.parent_struct,
  &_nemo_cinnamon_method_info_get_run_state.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _nemo_cinnamon_signal_info_monitors_changed =
{
  {
    -1,
    (gchar *) "MonitorsChanged",
    NULL,
    NULL
  },
  "monitors-changed"
};

static const _ExtendedGDBusSignalInfo _nemo_cinnamon_signal_info_run_state_changed =
{
  {
    -1,
    (gchar *) "RunStateChanged",
    NULL,
    NULL
  },
  "run-state-changed"
};

static const GDBusSignalInfo * const _nemo_cinnamon_signal_info_pointers[] =
{
  &_nemo_cinnamon_signal_info_monitors_changed.parent_struct,
  &_nemo_cinnamon_signal_info_run_state_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _nemo_cinnamon_property_info_run_state =
{
  {
    -1,
    (gchar *) "RunState",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "run-state",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _nemo_cinnamon_property_info_pointers[] =
{
  &_nemo_cinnamon_property_info_run_state.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _nemo_cinnamon_interface_info =
{
  {
    -1,
    (gchar *) "org.Cinnamon",
    (GDBusMethodInfo **) &_nemo_cinnamon_method_info_pointers,
    (GDBusSignalInfo **) &_nemo_cinnamon_signal_info_pointers,
    (GDBusPropertyInfo **) &_nemo_cinnamon_property_info_pointers,
    NULL
  },
  "cinnamon",
};


/**
 * nemo_cinnamon_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-Cinnamon.top_of_page">org.Cinnamon</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
nemo_cinnamon_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_nemo_cinnamon_interface_info.parent_struct;
}

/**
 * nemo_cinnamon_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #NemoCinnamon interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
nemo_cinnamon_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "run-state");
  return property_id_begin - 1;
}


inline static void
nemo_cinnamon_signal_marshal_monitors_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nemo_cinnamon_signal_marshal_run_state_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nemo_cinnamon_method_marshal_get_monitors (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nemo_cinnamon_method_marshal_get_monitor_work_rect (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nemo_cinnamon_method_marshal_get_run_state (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * NemoCinnamon:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-Cinnamon.top_of_page">org.Cinnamon</link>.
 */

/**
 * NemoCinnamonIface:
 * @parent_iface: The parent interface.
 * @handle_get_monitor_work_rect: Handler for the #NemoCinnamon::handle-get-monitor-work-rect signal.
 * @handle_get_monitors: Handler for the #NemoCinnamon::handle-get-monitors signal.
 * @handle_get_run_state: Handler for the #NemoCinnamon::handle-get-run-state signal.
 * @get_run_state: Getter for the #NemoCinnamon:run-state property.
 * @monitors_changed: Handler for the #NemoCinnamon::monitors-changed signal.
 * @run_state_changed: Handler for the #NemoCinnamon::run-state-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-Cinnamon.top_of_page">org.Cinnamon</link>.
 */

typedef NemoCinnamonIface NemoCinnamonInterface;
G_DEFINE_INTERFACE (NemoCinnamon, nemo_cinnamon, G_TYPE_OBJECT)

static void
nemo_cinnamon_default_init (NemoCinnamonIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * NemoCinnamon::handle-get-monitors:
   * @object: A #NemoCinnamon.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-Cinnamon.GetMonitors">GetMonitors()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nemo_cinnamon_complete_get_monitors() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-monitors",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NemoCinnamonIface, handle_get_monitors),
    g_signal_accumulator_true_handled,
    NULL,
      nemo_cinnamon_method_marshal_get_monitors,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * NemoCinnamon::handle-get-monitor-work-rect:
   * @object: A #NemoCinnamon.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_monitor: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-Cinnamon.GetMonitorWorkRect">GetMonitorWorkRect()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nemo_cinnamon_complete_get_monitor_work_rect() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-monitor-work-rect",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NemoCinnamonIface, handle_get_monitor_work_rect),
    g_signal_accumulator_true_handled,
    NULL,
      nemo_cinnamon_method_marshal_get_monitor_work_rect,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT);

  /**
   * NemoCinnamon::handle-get-run-state:
   * @object: A #NemoCinnamon.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-Cinnamon.GetRunState">GetRunState()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nemo_cinnamon_complete_get_run_state() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-run-state",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NemoCinnamonIface, handle_get_run_state),
    g_signal_accumulator_true_handled,
    NULL,
      nemo_cinnamon_method_marshal_get_run_state,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * NemoCinnamon::monitors-changed:
   * @object: A #NemoCinnamon.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-Cinnamon.MonitorsChanged">"MonitorsChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  NEMO__CINNAMON_SIGNALS[NEMO__CINNAMON_MONITORS_CHANGED] =
    g_signal_new ("monitors-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (NemoCinnamonIface, monitors_changed),
      NULL,
      NULL,
      nemo_cinnamon_signal_marshal_monitors_changed,
      G_TYPE_NONE,
      0);

  /**
   * NemoCinnamon::run-state-changed:
   * @object: A #NemoCinnamon.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-Cinnamon.RunStateChanged">"RunStateChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  NEMO__CINNAMON_SIGNALS[NEMO__CINNAMON_RUN_STATE_CHANGED] =
    g_signal_new ("run-state-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (NemoCinnamonIface, run_state_changed),
      NULL,
      NULL,
      nemo_cinnamon_signal_marshal_run_state_changed,
      G_TYPE_NONE,
      0);

  /* GObject properties for D-Bus properties: */
  /**
   * NemoCinnamon:run-state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-Cinnamon.RunState">"RunState"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("run-state", "RunState", "RunState", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * nemo_cinnamon_get_run_state: (skip)
 * @object: A #NemoCinnamon.
 *
 * Gets the value of the <link linkend="gdbus-property-org-Cinnamon.RunState">"RunState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
nemo_cinnamon_get_run_state (NemoCinnamon *object)
{
  g_return_val_if_fail (NEMO_IS_CINNAMON (object), 0);

  return NEMO_CINNAMON_GET_IFACE (object)->get_run_state (object);
}

/**
 * nemo_cinnamon_set_run_state: (skip)
 * @object: A #NemoCinnamon.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-Cinnamon.RunState">"RunState"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nemo_cinnamon_set_run_state (NemoCinnamon *object, gint value)
{
  g_object_set (G_OBJECT (object), "run-state", value, NULL);
}

/**
 * nemo_cinnamon_emit_monitors_changed:
 * @object: A #NemoCinnamon.
 *
 * Emits the <link linkend="gdbus-signal-org-Cinnamon.MonitorsChanged">"MonitorsChanged"</link> D-Bus signal.
 */
void
nemo_cinnamon_emit_monitors_changed (
    NemoCinnamon *object)
{
  g_signal_emit (object, NEMO__CINNAMON_SIGNALS[NEMO__CINNAMON_MONITORS_CHANGED], 0);
}

/**
 * nemo_cinnamon_emit_run_state_changed:
 * @object: A #NemoCinnamon.
 *
 * Emits the <link linkend="gdbus-signal-org-Cinnamon.RunStateChanged">"RunStateChanged"</link> D-Bus signal.
 */
void
nemo_cinnamon_emit_run_state_changed (
    NemoCinnamon *object)
{
  g_signal_emit (object, NEMO__CINNAMON_SIGNALS[NEMO__CINNAMON_RUN_STATE_CHANGED], 0);
}

/**
 * nemo_cinnamon_call_get_monitors:
 * @proxy: A #NemoCinnamonProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-Cinnamon.GetMonitors">GetMonitors()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nemo_cinnamon_call_get_monitors_finish() to get the result of the operation.
 *
 * See nemo_cinnamon_call_get_monitors_sync() for the synchronous, blocking version of this method.
 */
void
nemo_cinnamon_call_get_monitors (
    NemoCinnamon *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetMonitors",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nemo_cinnamon_call_get_monitors_finish:
 * @proxy: A #NemoCinnamonProxy.
 * @out_monitors: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nemo_cinnamon_call_get_monitors().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nemo_cinnamon_call_get_monitors().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nemo_cinnamon_call_get_monitors_finish (
    NemoCinnamon *proxy,
    GVariant **out_monitors,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@ai)",
                 out_monitors);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nemo_cinnamon_call_get_monitors_sync:
 * @proxy: A #NemoCinnamonProxy.
 * @out_monitors: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-Cinnamon.GetMonitors">GetMonitors()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nemo_cinnamon_call_get_monitors() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nemo_cinnamon_call_get_monitors_sync (
    NemoCinnamon *proxy,
    GVariant **out_monitors,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetMonitors",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@ai)",
                 out_monitors);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nemo_cinnamon_call_get_monitor_work_rect:
 * @proxy: A #NemoCinnamonProxy.
 * @arg_monitor: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-Cinnamon.GetMonitorWorkRect">GetMonitorWorkRect()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nemo_cinnamon_call_get_monitor_work_rect_finish() to get the result of the operation.
 *
 * See nemo_cinnamon_call_get_monitor_work_rect_sync() for the synchronous, blocking version of this method.
 */
void
nemo_cinnamon_call_get_monitor_work_rect (
    NemoCinnamon *proxy,
    gint arg_monitor,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetMonitorWorkRect",
    g_variant_new ("(i)",
                   arg_monitor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nemo_cinnamon_call_get_monitor_work_rect_finish:
 * @proxy: A #NemoCinnamonProxy.
 * @out_rect: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nemo_cinnamon_call_get_monitor_work_rect().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nemo_cinnamon_call_get_monitor_work_rect().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nemo_cinnamon_call_get_monitor_work_rect_finish (
    NemoCinnamon *proxy,
    GVariant **out_rect,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@ai)",
                 out_rect);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nemo_cinnamon_call_get_monitor_work_rect_sync:
 * @proxy: A #NemoCinnamonProxy.
 * @arg_monitor: Argument to pass with the method invocation.
 * @out_rect: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-Cinnamon.GetMonitorWorkRect">GetMonitorWorkRect()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nemo_cinnamon_call_get_monitor_work_rect() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nemo_cinnamon_call_get_monitor_work_rect_sync (
    NemoCinnamon *proxy,
    gint arg_monitor,
    GVariant **out_rect,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetMonitorWorkRect",
    g_variant_new ("(i)",
                   arg_monitor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@ai)",
                 out_rect);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nemo_cinnamon_call_get_run_state:
 * @proxy: A #NemoCinnamonProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-Cinnamon.GetRunState">GetRunState()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nemo_cinnamon_call_get_run_state_finish() to get the result of the operation.
 *
 * See nemo_cinnamon_call_get_run_state_sync() for the synchronous, blocking version of this method.
 */
void
nemo_cinnamon_call_get_run_state (
    NemoCinnamon *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetRunState",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nemo_cinnamon_call_get_run_state_finish:
 * @proxy: A #NemoCinnamonProxy.
 * @out_state: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nemo_cinnamon_call_get_run_state().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nemo_cinnamon_call_get_run_state().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nemo_cinnamon_call_get_run_state_finish (
    NemoCinnamon *proxy,
    gint *out_state,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_state);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nemo_cinnamon_call_get_run_state_sync:
 * @proxy: A #NemoCinnamonProxy.
 * @out_state: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-Cinnamon.GetRunState">GetRunState()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nemo_cinnamon_call_get_run_state() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nemo_cinnamon_call_get_run_state_sync (
    NemoCinnamon *proxy,
    gint *out_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetRunState",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_state);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nemo_cinnamon_complete_get_monitors:
 * @object: A #NemoCinnamon.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @monitors: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-Cinnamon.GetMonitors">GetMonitors()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nemo_cinnamon_complete_get_monitors (
    NemoCinnamon *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *monitors)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@ai)",
                   monitors));
}

/**
 * nemo_cinnamon_complete_get_monitor_work_rect:
 * @object: A #NemoCinnamon.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @rect: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-Cinnamon.GetMonitorWorkRect">GetMonitorWorkRect()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nemo_cinnamon_complete_get_monitor_work_rect (
    NemoCinnamon *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *rect)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@ai)",
                   rect));
}

/**
 * nemo_cinnamon_complete_get_run_state:
 * @object: A #NemoCinnamon.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @state: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-Cinnamon.GetRunState">GetRunState()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nemo_cinnamon_complete_get_run_state (
    NemoCinnamon *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint state)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   state));
}

/* ------------------------------------------------------------------------ */

/**
 * NemoCinnamonProxy:
 *
 * The #NemoCinnamonProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NemoCinnamonProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NemoCinnamonProxy.
 */

struct _NemoCinnamonProxyPrivate
{
  GData *qdata;
};

static void nemo_cinnamon_proxy_iface_init (NemoCinnamonIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NemoCinnamonProxy, nemo_cinnamon_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (NemoCinnamonProxy)
                         G_IMPLEMENT_INTERFACE (NEMO_TYPE_CINNAMON, nemo_cinnamon_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (NemoCinnamonProxy, nemo_cinnamon_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (NEMO_TYPE_CINNAMON, nemo_cinnamon_proxy_iface_init))

#endif
static void
nemo_cinnamon_proxy_finalize (GObject *object)
{
  NemoCinnamonProxy *proxy = NEMO_CINNAMON_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (nemo_cinnamon_proxy_parent_class)->finalize (object);
}

static void
nemo_cinnamon_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _nemo_cinnamon_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
nemo_cinnamon_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.Cinnamon: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
nemo_cinnamon_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _nemo_cinnamon_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.Cinnamon", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) nemo_cinnamon_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
nemo_cinnamon_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_nemo_cinnamon_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], NEMO_TYPE_CINNAMON);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NEMO_TYPE_CINNAMON);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
nemo_cinnamon_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  NemoCinnamonProxy *proxy = NEMO_CINNAMON_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nemo_cinnamon_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nemo_cinnamon_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gint 
nemo_cinnamon_proxy_get_run_state (NemoCinnamon *object)
{
  NemoCinnamonProxy *proxy = NEMO_CINNAMON_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RunState");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
nemo_cinnamon_proxy_init (NemoCinnamonProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = nemo_cinnamon_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, NEMO_TYPE_CINNAMON_PROXY, NemoCinnamonProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), nemo_cinnamon_interface_info ());
}

static void
nemo_cinnamon_proxy_class_init (NemoCinnamonProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = nemo_cinnamon_proxy_finalize;
  gobject_class->get_property = nemo_cinnamon_proxy_get_property;
  gobject_class->set_property = nemo_cinnamon_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = nemo_cinnamon_proxy_g_signal;
  proxy_class->g_properties_changed = nemo_cinnamon_proxy_g_properties_changed;

  nemo_cinnamon_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NemoCinnamonProxyPrivate));
#endif
}

static void
nemo_cinnamon_proxy_iface_init (NemoCinnamonIface *iface)
{
  iface->get_run_state = nemo_cinnamon_proxy_get_run_state;
}

/**
 * nemo_cinnamon_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-Cinnamon.top_of_page">org.Cinnamon</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nemo_cinnamon_proxy_new_finish() to get the result of the operation.
 *
 * See nemo_cinnamon_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
nemo_cinnamon_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NEMO_TYPE_CINNAMON_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.Cinnamon", NULL);
}

/**
 * nemo_cinnamon_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nemo_cinnamon_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nemo_cinnamon_proxy_new().
 *
 * Returns: (transfer full) (type NemoCinnamonProxy): The constructed proxy object or %NULL if @error is set.
 */
NemoCinnamon *
nemo_cinnamon_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NEMO_CINNAMON (ret);
  else
    return NULL;
}

/**
 * nemo_cinnamon_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-Cinnamon.top_of_page">org.Cinnamon</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nemo_cinnamon_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NemoCinnamonProxy): The constructed proxy object or %NULL if @error is set.
 */
NemoCinnamon *
nemo_cinnamon_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NEMO_TYPE_CINNAMON_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.Cinnamon", NULL);
  if (ret != NULL)
    return NEMO_CINNAMON (ret);
  else
    return NULL;
}


/**
 * nemo_cinnamon_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like nemo_cinnamon_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nemo_cinnamon_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See nemo_cinnamon_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
nemo_cinnamon_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NEMO_TYPE_CINNAMON_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.Cinnamon", NULL);
}

/**
 * nemo_cinnamon_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nemo_cinnamon_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nemo_cinnamon_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type NemoCinnamonProxy): The constructed proxy object or %NULL if @error is set.
 */
NemoCinnamon *
nemo_cinnamon_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NEMO_CINNAMON (ret);
  else
    return NULL;
}

/**
 * nemo_cinnamon_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like nemo_cinnamon_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nemo_cinnamon_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NemoCinnamonProxy): The constructed proxy object or %NULL if @error is set.
 */
NemoCinnamon *
nemo_cinnamon_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NEMO_TYPE_CINNAMON_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.Cinnamon", NULL);
  if (ret != NULL)
    return NEMO_CINNAMON (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * NemoCinnamonSkeleton:
 *
 * The #NemoCinnamonSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NemoCinnamonSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NemoCinnamonSkeleton.
 */

struct _NemoCinnamonSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_nemo_cinnamon_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  NemoCinnamonSkeleton *skeleton = NEMO_CINNAMON_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], NEMO_TYPE_CINNAMON);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NEMO_TYPE_CINNAMON);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_nemo_cinnamon_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  NemoCinnamonSkeleton *skeleton = NEMO_CINNAMON_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nemo_cinnamon_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_nemo_cinnamon_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  NemoCinnamonSkeleton *skeleton = NEMO_CINNAMON_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nemo_cinnamon_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _nemo_cinnamon_skeleton_vtable =
{
  _nemo_cinnamon_skeleton_handle_method_call,
  _nemo_cinnamon_skeleton_handle_get_property,
  _nemo_cinnamon_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
nemo_cinnamon_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return nemo_cinnamon_interface_info ();
}

static GDBusInterfaceVTable *
nemo_cinnamon_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_nemo_cinnamon_skeleton_vtable;
}

static GVariant *
nemo_cinnamon_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  NemoCinnamonSkeleton *skeleton = NEMO_CINNAMON_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_nemo_cinnamon_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _nemo_cinnamon_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _nemo_cinnamon_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _nemo_cinnamon_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.Cinnamon", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _nemo_cinnamon_emit_changed (gpointer user_data);

static void
nemo_cinnamon_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  NemoCinnamonSkeleton *skeleton = NEMO_CINNAMON_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _nemo_cinnamon_emit_changed (skeleton);
}

static void
_nemo_cinnamon_on_signal_monitors_changed (
    NemoCinnamon *object)
{
  NemoCinnamonSkeleton *skeleton = NEMO_CINNAMON_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.Cinnamon", "MonitorsChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_nemo_cinnamon_on_signal_run_state_changed (
    NemoCinnamon *object)
{
  NemoCinnamonSkeleton *skeleton = NEMO_CINNAMON_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.Cinnamon", "RunStateChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void nemo_cinnamon_skeleton_iface_init (NemoCinnamonIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NemoCinnamonSkeleton, nemo_cinnamon_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (NemoCinnamonSkeleton)
                         G_IMPLEMENT_INTERFACE (NEMO_TYPE_CINNAMON, nemo_cinnamon_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (NemoCinnamonSkeleton, nemo_cinnamon_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (NEMO_TYPE_CINNAMON, nemo_cinnamon_skeleton_iface_init))

#endif
static void
nemo_cinnamon_skeleton_finalize (GObject *object)
{
  NemoCinnamonSkeleton *skeleton = NEMO_CINNAMON_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (nemo_cinnamon_skeleton_parent_class)->finalize (object);
}

static void
nemo_cinnamon_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  NemoCinnamonSkeleton *skeleton = NEMO_CINNAMON_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_nemo_cinnamon_emit_changed (gpointer user_data)
{
  NemoCinnamonSkeleton *skeleton = NEMO_CINNAMON_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.Cinnamon",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_nemo_cinnamon_schedule_emit_changed (NemoCinnamonSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
nemo_cinnamon_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  NemoCinnamonSkeleton *skeleton = NEMO_CINNAMON_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _nemo_cinnamon_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _nemo_cinnamon_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
nemo_cinnamon_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  NemoCinnamonSkeleton *skeleton = NEMO_CINNAMON_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _nemo_cinnamon_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _nemo_cinnamon_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
nemo_cinnamon_skeleton_init (NemoCinnamonSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = nemo_cinnamon_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, NEMO_TYPE_CINNAMON_SKELETON, NemoCinnamonSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_INT);
}

static gint 
nemo_cinnamon_skeleton_get_run_state (NemoCinnamon *object)
{
  NemoCinnamonSkeleton *skeleton = NEMO_CINNAMON_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
nemo_cinnamon_skeleton_class_init (NemoCinnamonSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = nemo_cinnamon_skeleton_finalize;
  gobject_class->get_property = nemo_cinnamon_skeleton_get_property;
  gobject_class->set_property = nemo_cinnamon_skeleton_set_property;
  gobject_class->notify       = nemo_cinnamon_skeleton_notify;


  nemo_cinnamon_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = nemo_cinnamon_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = nemo_cinnamon_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = nemo_cinnamon_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = nemo_cinnamon_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NemoCinnamonSkeletonPrivate));
#endif
}

static void
nemo_cinnamon_skeleton_iface_init (NemoCinnamonIface *iface)
{
  iface->monitors_changed = _nemo_cinnamon_on_signal_monitors_changed;
  iface->run_state_changed = _nemo_cinnamon_on_signal_run_state_changed;
  iface->get_run_state = nemo_cinnamon_skeleton_get_run_state;
}

/**
 * nemo_cinnamon_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-Cinnamon.top_of_page">org.Cinnamon</link>.
 *
 * Returns: (transfer full) (type NemoCinnamonSkeleton): The skeleton object.
 */
NemoCinnamon *
nemo_cinnamon_skeleton_new (void)
{
  return NEMO_CINNAMON (g_object_new (NEMO_TYPE_CINNAMON_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for Object, ObjectProxy and ObjectSkeleton
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NemoObject
 * @title: NemoObject
 * @short_description: Specialized GDBusObject types
 *
 * This section contains the #NemoObject, #NemoObjectProxy, and #NemoObjectSkeleton types which make it easier to work with objects implementing generated types for D-Bus interfaces.
 */

/**
 * NemoObject:
 *
 * The #NemoObject type is a specialized container of interfaces.
 */

/**
 * NemoObjectIface:
 * @parent_iface: The parent interface.
 *
 * Virtual table for the #NemoObject interface.
 */

typedef NemoObjectIface NemoObjectInterface;
G_DEFINE_INTERFACE_WITH_CODE (NemoObject, nemo_object, G_TYPE_OBJECT, g_type_interface_add_prerequisite (g_define_type_id, G_TYPE_DBUS_OBJECT);)

static void
nemo_object_default_init (NemoObjectIface *iface)
{
  /**
   * NemoObject:cinnamon:
   *
   * The #NemoCinnamon instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-Cinnamon.top_of_page">org.Cinnamon</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("cinnamon", "cinnamon", "cinnamon", NEMO_TYPE_CINNAMON, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

}

/**
 * nemo_object_get_cinnamon:
 * @object: A #NemoObject.
 *
 * Gets the #NemoCinnamon instance for the D-Bus interface <link linkend="gdbus-interface-org-Cinnamon.top_of_page">org.Cinnamon</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #NemoCinnamon that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
NemoCinnamon *nemo_object_get_cinnamon (NemoObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.Cinnamon");
  if (ret == NULL)
    return NULL;
  return NEMO_CINNAMON (ret);
}


/**
 * nemo_object_peek_cinnamon: (skip)
 * @object: A #NemoObject.
 *
 * Like nemo_object_get_cinnamon() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #NemoCinnamon or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
NemoCinnamon *nemo_object_peek_cinnamon (NemoObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.Cinnamon");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return NEMO_CINNAMON (ret);
}


static void
nemo_object_notify (GDBusObject *object, GDBusInterface *interface)
{
  _ExtendedGDBusInterfaceInfo *info = (_ExtendedGDBusInterfaceInfo *) g_dbus_interface_get_info (interface);
  /* info can be NULL if the other end is using a D-Bus interface we don't know
   * anything about, for example old generated code in this process talking to
   * newer generated code in the other process. */
  if (info != NULL)
    g_object_notify (G_OBJECT (object), info->hyphen_name);
}

/**
 * NemoObjectProxy:
 *
 * The #NemoObjectProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NemoObjectProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NemoObjectProxy.
 */

static void
nemo_object_proxy__nemo_object_iface_init (NemoObjectIface *iface G_GNUC_UNUSED)
{
}

static void
nemo_object_proxy__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = nemo_object_notify;
  iface->interface_removed = nemo_object_notify;
}


G_DEFINE_TYPE_WITH_CODE (NemoObjectProxy, nemo_object_proxy, G_TYPE_DBUS_OBJECT_PROXY,
                         G_IMPLEMENT_INTERFACE (NEMO_TYPE_OBJECT, nemo_object_proxy__nemo_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, nemo_object_proxy__g_dbus_object_iface_init))

static void
nemo_object_proxy_init (NemoObjectProxy *object G_GNUC_UNUSED)
{
}

static void
nemo_object_proxy_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec)
{
  G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
}

static void
nemo_object_proxy_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  NemoObjectProxy *object = NEMO_OBJECT_PROXY (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.Cinnamon");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
nemo_object_proxy_class_init (NemoObjectProxyClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = nemo_object_proxy_set_property;
  gobject_class->get_property = nemo_object_proxy_get_property;

  g_object_class_override_property (gobject_class, 1, "cinnamon");
}

/**
 * nemo_object_proxy_new:
 * @connection: A #GDBusConnection.
 * @object_path: An object path.
 *
 * Creates a new proxy object.
 *
 * Returns: (transfer full): The proxy object.
 */
NemoObjectProxy *
nemo_object_proxy_new (GDBusConnection *connection,
  const gchar *object_path)
{
  g_return_val_if_fail (G_IS_DBUS_CONNECTION (connection), NULL);
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return NEMO_OBJECT_PROXY (g_object_new (NEMO_TYPE_OBJECT_PROXY, "g-connection", connection, "g-object-path", object_path, NULL));
}

/**
 * NemoObjectSkeleton:
 *
 * The #NemoObjectSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NemoObjectSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NemoObjectSkeleton.
 */

static void
nemo_object_skeleton__nemo_object_iface_init (NemoObjectIface *iface G_GNUC_UNUSED)
{
}


static void
nemo_object_skeleton__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = nemo_object_notify;
  iface->interface_removed = nemo_object_notify;
}

G_DEFINE_TYPE_WITH_CODE (NemoObjectSkeleton, nemo_object_skeleton, G_TYPE_DBUS_OBJECT_SKELETON,
                         G_IMPLEMENT_INTERFACE (NEMO_TYPE_OBJECT, nemo_object_skeleton__nemo_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, nemo_object_skeleton__g_dbus_object_iface_init))

static void
nemo_object_skeleton_init (NemoObjectSkeleton *object G_GNUC_UNUSED)
{
}

static void
nemo_object_skeleton_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  NemoObjectSkeleton *object = NEMO_OBJECT_SKELETON (gobject);
  GDBusInterfaceSkeleton *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (NEMO_IS_CINNAMON (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.Cinnamon");
        }
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
nemo_object_skeleton_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  NemoObjectSkeleton *object = NEMO_OBJECT_SKELETON (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.Cinnamon");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
nemo_object_skeleton_class_init (NemoObjectSkeletonClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = nemo_object_skeleton_set_property;
  gobject_class->get_property = nemo_object_skeleton_get_property;

  g_object_class_override_property (gobject_class, 1, "cinnamon");
}

/**
 * nemo_object_skeleton_new:
 * @object_path: An object path.
 *
 * Creates a new skeleton object.
 *
 * Returns: (transfer full): The skeleton object.
 */
NemoObjectSkeleton *
nemo_object_skeleton_new (const gchar *object_path)
{
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return NEMO_OBJECT_SKELETON (g_object_new (NEMO_TYPE_OBJECT_SKELETON, "g-object-path", object_path, NULL));
}

/**
 * nemo_object_skeleton_set_cinnamon:
 * @object: A #NemoObjectSkeleton.
 * @interface_: (nullable): A #NemoCinnamon or %NULL to clear the interface.
 *
 * Sets the #NemoCinnamon instance for the D-Bus interface <link linkend="gdbus-interface-org-Cinnamon.top_of_page">org.Cinnamon</link> on @object.
 */
void nemo_object_skeleton_set_cinnamon (NemoObjectSkeleton *object, NemoCinnamon *interface_)
{
  g_object_set (G_OBJECT (object), "cinnamon", interface_, NULL);
}


/* ------------------------------------------------------------------------
 * Code for ObjectManager client
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NemoObjectManagerClient
 * @title: NemoObjectManagerClient
 * @short_description: Generated GDBusObjectManagerClient type
 *
 * This section contains a #GDBusObjectManagerClient that uses nemo_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc.
 */

/**
 * NemoObjectManagerClient:
 *
 * The #NemoObjectManagerClient structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NemoObjectManagerClientClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NemoObjectManagerClient.
 */

G_DEFINE_TYPE (NemoObjectManagerClient, nemo_object_manager_client, G_TYPE_DBUS_OBJECT_MANAGER_CLIENT)

static void
nemo_object_manager_client_init (NemoObjectManagerClient *manager G_GNUC_UNUSED)
{
}

static void
nemo_object_manager_client_class_init (NemoObjectManagerClientClass *klass G_GNUC_UNUSED)
{
}

/**
 * nemo_object_manager_client_get_proxy_type:
 * @manager: A #GDBusObjectManagerClient.
 * @object_path: The object path of the remote object (unused).
 * @interface_name: (nullable): Interface name of the remote object or %NULL to get the object proxy #GType.
 * @user_data: User data (unused).
 *
 * A #GDBusProxyTypeFunc that maps @interface_name to the generated #GDBusObjectProxy derived and #GDBusProxy derived types.
 *
 * Returns: A #GDBusProxy derived #GType if @interface_name is not %NULL, otherwise the #GType for #NemoObjectProxy.
 */
GType
nemo_object_manager_client_get_proxy_type (GDBusObjectManagerClient *manager G_GNUC_UNUSED, const gchar *object_path G_GNUC_UNUSED, const gchar *interface_name, gpointer user_data G_GNUC_UNUSED)
{
  static gsize once_init_value = 0;
  static GHashTable *lookup_hash;
  GType ret;

  if (interface_name == NULL)
    return NEMO_TYPE_OBJECT_PROXY;
  if (g_once_init_enter (&once_init_value))
    {
      lookup_hash = g_hash_table_new (g_str_hash, g_str_equal);
      g_hash_table_insert (lookup_hash, (gpointer) "org.Cinnamon", GSIZE_TO_POINTER (NEMO_TYPE_CINNAMON_PROXY));
      g_once_init_leave (&once_init_value, 1);
    }
  ret = (GType) GPOINTER_TO_SIZE (g_hash_table_lookup (lookup_hash, interface_name));
  if (ret == (GType) 0)
    ret = G_TYPE_DBUS_PROXY;
  return ret;
}

/**
 * nemo_object_manager_client_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates #GDBusObjectManagerClient using nemo_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nemo_object_manager_client_new_finish() to get the result of the operation.
 *
 * See nemo_object_manager_client_new_sync() for the synchronous, blocking version of this constructor.
 */
void
nemo_object_manager_client_new (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (NEMO_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", nemo_object_manager_client_get_proxy_type, NULL);
}

/**
 * nemo_object_manager_client_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nemo_object_manager_client_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nemo_object_manager_client_new().
 *
 * Returns: (transfer full) (type NemoObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
nemo_object_manager_client_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * nemo_object_manager_client_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates #GDBusObjectManagerClient using nemo_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nemo_object_manager_client_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NemoObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
nemo_object_manager_client_new_sync (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (NEMO_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", nemo_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


/**
 * nemo_object_manager_client_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like nemo_object_manager_client_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nemo_object_manager_client_new_for_bus_finish() to get the result of the operation.
 *
 * See nemo_object_manager_client_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
nemo_object_manager_client_new_for_bus (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (NEMO_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", nemo_object_manager_client_get_proxy_type, NULL);
}

/**
 * nemo_object_manager_client_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nemo_object_manager_client_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nemo_object_manager_client_new_for_bus().
 *
 * Returns: (transfer full) (type NemoObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
nemo_object_manager_client_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * nemo_object_manager_client_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like nemo_object_manager_client_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nemo_object_manager_client_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NemoObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
nemo_object_manager_client_new_for_bus_sync (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (NEMO_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", nemo_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


