//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.10
//
// <auto-generated>
//
// Generated from file `MumbleServer.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __MumbleServer_h__
#define __MumbleServer_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/IncomingAsync.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/SliceChecksumDict.h>
#include <IceUtil/UndefSysMacros.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 10
#       error Ice patch level mismatch!
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace MumbleServer
{

class Tree;
class ServerCallback;
class ServerCallbackPrx;
class ServerContextCallback;
class ServerContextCallbackPrx;
class ServerAuthenticator;
class ServerAuthenticatorPrx;
class ServerUpdatingAuthenticator;
class ServerUpdatingAuthenticatorPrx;
class Server;
class ServerPrx;
class MetaCallback;
class MetaCallbackPrx;
class Meta;
class MetaPrx;

}

namespace MumbleServer
{

/**
 * A network address in IPv6 format.
 */
using NetAddress = ::std::vector<::Ice::Byte>;

/**
 * A connected user.
 */
struct User
{
    /**
     * Session ID. This identifies the connection to the server.
     */
    int session;
    /**
     * User ID. -1 if the user is anonymous.
     */
    int userid;
    /**
     * Is user muted by the server?
     */
    bool mute;
    /**
     * Is user deafened by the server? If true, this implies mute.
     */
    bool deaf;
    /**
     * Is the user suppressed by the server? This means the user is not muted, but does not have speech privileges in the current channel.
     */
    bool suppress;
    /**
     * Is the user a priority speaker?
     */
    bool prioritySpeaker;
    /**
     * Is the user self-muted?
     */
    bool selfMute;
    /**
     * Is the user self-deafened? If true, this implies mute.
     */
    bool selfDeaf;
    /**
     * Is the User recording? (This flag is read-only and cannot be changed using setState().)
     */
    bool recording;
    /**
     * Channel ID the user is in. Matches {@link Channel.id}.
     */
    int channel;
    /**
     * The name of the user.
     */
    ::std::string name;
    /**
     * Seconds user has been online.
     */
    int onlinesecs;
    /**
     * Average transmission rate in bytes per second over the last few seconds.
     */
    int bytespersec;
    /**
     * Legacy client version.
     */
    int version;
    /**
     * New client version. (See https://github.com/mumble-voip/mumble/issues/5827)
     */
    long long int version2;
    /**
     * Client release. For official releases, this equals the version. For snapshots and git compiles, this will be something else.
     */
    ::std::string release;
    /**
     * Client OS.
     */
    ::std::string os;
    /**
     * Client OS Version.
     */
    ::std::string osversion;
    /**
     * Plugin Identity. This will be the user's unique ID inside the current game.
     */
    ::std::string identity;
    /**
     * Base64-encoded Plugin context. This is a binary blob identifying the game and team the user is on.
     *
     * The used Base64 alphabet is the one specified in RFC 2045.
     *
     * Before Mumble 1.3.0, this string was not Base64-encoded. This could cause problems for some Ice
     * implementations, such as the .NET implementation.
     *
     * If you need the exact string that is used by Mumble, you can get it by Base64-decoding this string.
     *
     * If you simply need to detect whether two users are in the same game world, string comparisons will
     * continue to work as before.
     */
    ::std::string context;
    /**
     * User comment. Shown as tooltip for this user.
     */
    ::std::string comment;
    /**
     * Client address.
     */
    ::MumbleServer::NetAddress address;
    /**
     * TCP only. True until UDP connectivity is established.
     */
    bool tcponly;
    /**
     * Idle time. This is how many seconds it is since the user last spoke. Other activity is not counted.
     */
    int idlesecs;
    /**
     * UDP Ping Average. This is the average ping for the user via UDP over the duration of the connection.
     */
    float udpPing;
    /**
     * TCP Ping Average. This is the average ping for the user via TCP over the duration of the connection.
     */
    float tcpPing;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const int&, const int&, const bool&, const bool&, const bool&, const bool&, const bool&, const bool&, const bool&, const int&, const ::std::string&, const int&, const int&, const int&, const long long int&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::MumbleServer::NetAddress&, const bool&, const int&, const float&, const float&> ice_tuple() const
    {
        return std::tie(session, userid, mute, deaf, suppress, prioritySpeaker, selfMute, selfDeaf, recording, channel, name, onlinesecs, bytespersec, version, version2, release, os, osversion, identity, context, comment, address, tcponly, idlesecs, udpPing, tcpPing);
    }
};

using IntList = ::std::vector<int>;

/**
 * A text message between users.
 */
struct TextMessage
{
    /**
     * Sessions (connected users) who were sent this message.
     */
    ::MumbleServer::IntList sessions;
    /**
     * Channels who were sent this message.
     */
    ::MumbleServer::IntList channels;
    /**
     * Trees of channels who were sent this message.
     */
    ::MumbleServer::IntList trees;
    /**
     * The contents of the message.
     */
    ::std::string text;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::MumbleServer::IntList&, const ::MumbleServer::IntList&, const ::MumbleServer::IntList&, const ::std::string&> ice_tuple() const
    {
        return std::tie(sessions, channels, trees, text);
    }
};

/**
 * A channel.
 */
struct Channel
{
    /**
     * Channel ID. This is unique per channel, and the root channel is always id 0.
     */
    int id;
    /**
     * Name of the channel. There can not be two channels with the same parent that has the same name.
     */
    ::std::string name;
    /**
     * ID of parent channel, or -1 if this is the root channel.
     */
    int parent;
    /**
     * List of id of linked channels.
     */
    ::MumbleServer::IntList links;
    /**
     * Description of channel. Shown as tooltip for this channel.
     */
    ::std::string description;
    /**
     * Channel is temporary, and will be removed when the last user leaves it.
     */
    bool temporary;
    /**
     * Position of the channel which is used in Client for sorting.
     */
    int position;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const int&, const ::std::string&, const int&, const ::MumbleServer::IntList&, const ::std::string&, const bool&, const int&> ice_tuple() const
    {
        return std::tie(id, name, parent, links, description, temporary, position);
    }
};

/**
 * A group. Groups are defined per channel, and can inherit members from parent channels.
 */
struct Group
{
    /**
     * Group name
     */
    ::std::string name;
    /**
     * Is this group inherited from a parent channel? Read-only.
     */
    bool inherited;
    /**
     * Does this group inherit members from parent channels?
     */
    bool inherit;
    /**
     * Can subchannels inherit members from this group?
     */
    bool inheritable;
    /**
     * List of users to add to the group.
     */
    ::MumbleServer::IntList add;
    /**
     * List of inherited users to remove from the group.
     */
    ::MumbleServer::IntList remove;
    /**
     * Current members of the group, including inherited members. Read-only.
     */
    ::MumbleServer::IntList members;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const bool&, const bool&, const bool&, const ::MumbleServer::IntList&, const ::MumbleServer::IntList&, const ::MumbleServer::IntList&> ice_tuple() const
    {
        return std::tie(name, inherited, inherit, inheritable, add, remove, members);
    }
};

/**
 * Write access to channel control. Implies all other permissions (except Speak).
 */
constexpr int PermissionWrite = 1;

/**
 * Traverse channel. Without this, a client cannot reach subchannels, no matter which privileges he has there.
 */
constexpr int PermissionTraverse = 2;

/**
 * Enter channel.
 */
constexpr int PermissionEnter = 4;

/**
 * Speak in channel.
 */
constexpr int PermissionSpeak = 8;

/**
 * Whisper to channel. This is different from Speak, so you can set up different permissions.
 */
constexpr int PermissionWhisper = 256;

/**
 * Mute and deafen other users in this channel.
 */
constexpr int PermissionMuteDeafen = 16;

/**
 * Move users from channel. You need this permission in both the source and destination channel to move another user.
 */
constexpr int PermissionMove = 32;

/**
 * Make new channel as a subchannel of this channel.
 */
constexpr int PermissionMakeChannel = 64;

/**
 * Make new temporary channel as a subchannel of this channel.
 */
constexpr int PermissionMakeTempChannel = 1024;

/**
 * Link this channel. You need this permission in both the source and destination channel to link channels, or in either channel to unlink them.
 */
constexpr int PermissionLinkChannel = 128;

/**
 * Send text message to channel.
 */
constexpr int PermissionTextMessage = 512;

/**
 * Kick user from server. Only valid on root channel.
 */
constexpr int PermissionKick = 65536;

/**
 * Ban user from server. Only valid on root channel.
 */
constexpr int PermissionBan = 131072;

/**
 * Register and unregister users. Only valid on root channel.
 */
constexpr int PermissionRegister = 262144;

/**
 * Register and unregister users. Only valid on root channel.
 */
constexpr int PermissionRegisterSelf = 524288;

/**
 * Reset the comment or avatar of a user. Only valid on root channel.
 */
constexpr int ResetUserContent = 1048576;

/**
 * Access Control List for a channel. ACLs are defined per channel, and can be inherited from parent channels.
 */
struct ACL
{
    /**
     * Does the ACL apply to this channel?
     */
    bool applyHere;
    /**
     * Does the ACL apply to subchannels?
     */
    bool applySubs;
    /**
     * Is this ACL inherited from a parent channel? Read-only.
     */
    bool inherited;
    /**
     * ID of user this ACL applies to. -1 if using a group name.
     */
    int userid;
    /**
     * Group this ACL applies to. Blank if using userid.
     */
    ::std::string group;
    /**
     * Binary mask of privileges to allow.
     */
    int allow;
    /**
     * Binary mask of privileges to deny.
     */
    int deny;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const bool&, const bool&, const bool&, const int&, const ::std::string&, const int&, const int&> ice_tuple() const
    {
        return std::tie(applyHere, applySubs, inherited, userid, group, allow, deny);
    }
};

/**
 * A single ip mask for a ban.
 */
struct Ban
{
    /**
     * Address to ban.
     */
    ::MumbleServer::NetAddress address;
    /**
     * Number of bits in ban to apply.
     */
    int bits;
    /**
     * Username associated with ban.
     */
    ::std::string name;
    /**
     * Hash of banned user.
     */
    ::std::string hash;
    /**
     * Reason for ban.
     */
    ::std::string reason;
    /**
     * Date ban was applied in unix time format.
     */
    int start;
    /**
     * Duration of ban.
     */
    int duration;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::MumbleServer::NetAddress&, const int&, const ::std::string&, const ::std::string&, const ::std::string&, const int&, const int&> ice_tuple() const
    {
        return std::tie(address, bits, name, hash, reason, start, duration);
    }
};

/**
 * A entry in the log.
 */
struct LogEntry
{
    /**
     * Timestamp in UNIX time_t
     */
    int timestamp;
    /**
     * The log message.
     */
    ::std::string txt;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const int&, const ::std::string&> ice_tuple() const
    {
        return std::tie(timestamp, txt);
    }
};

using TreeList = ::std::vector<::std::shared_ptr<Tree>>;

enum class ChannelInfo : unsigned char
{
    ChannelDescription,
    ChannelPosition
};

enum class UserInfo : unsigned char
{
    UserName,
    UserEmail,
    UserComment,
    UserHash,
    UserPassword,
    UserLastActive,
    UserKDFIterations
};

using UserMap = ::std::map<int, User>;

using ChannelMap = ::std::map<int, Channel>;

using ChannelList = ::std::vector<Channel>;

using UserList = ::std::vector<User>;

using GroupList = ::std::vector<Group>;

using ACLList = ::std::vector<ACL>;

using LogList = ::std::vector<LogEntry>;

using BanList = ::std::vector<Ban>;

using IdList = ::std::vector<int>;

using NameList = ::std::vector<::std::string>;

using NameMap = ::std::map<int, ::std::string>;

using IdMap = ::std::map<::std::string, int>;

using Texture = ::std::vector<::Ice::Byte>;

using ConfigMap = ::std::map<::std::string, ::std::string>;

using GroupNameList = ::std::vector<::std::string>;

using CertificateDer = ::std::vector<::Ice::Byte>;

using CertificateList = ::std::vector<CertificateDer>;

/**
 * User information map.
 * Older versions of ice-php can't handle enums as keys. If you are using one of these, replace 'UserInfo' with 'byte'.
 */
using UserInfoMap = ::std::map<UserInfo, ::std::string>;

class MurmurException : public ::Ice::UserExceptionHelper<MurmurException, ::Ice::UserException>
{
public:

    virtual ~MurmurException();

    MurmurException(const MurmurException&) = default;

    MurmurException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
};

/// \cond INTERNAL
static MurmurException _iceS_MurmurException_init;
/// \endcond

/**
 * This is thrown when you specify an invalid session. This may happen if the user has disconnected since your last call to {@link Server.getUsers}. See {@link User.session}
 */
class InvalidSessionException : public ::Ice::UserExceptionHelper<InvalidSessionException, MurmurException>
{
public:

    virtual ~InvalidSessionException();

    InvalidSessionException(const InvalidSessionException&) = default;

    InvalidSessionException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
};

/**
 * This is thrown when you specify an invalid channel id. This may happen if the channel was removed by another provess. It can also be thrown if you try to add an invalid channel.
 */
class InvalidChannelException : public ::Ice::UserExceptionHelper<InvalidChannelException, MurmurException>
{
public:

    virtual ~InvalidChannelException();

    InvalidChannelException(const InvalidChannelException&) = default;

    InvalidChannelException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
};

/**
 * This is thrown when you try to do an operation on a server that does not exist. This may happen if someone has removed the server.
 */
class InvalidServerException : public ::Ice::UserExceptionHelper<InvalidServerException, MurmurException>
{
public:

    virtual ~InvalidServerException();

    InvalidServerException(const InvalidServerException&) = default;

    InvalidServerException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
};

/**
 * This happens if you try to fetch user or channel state on a stopped server, if you try to stop an already stopped server or start an already started server.
 */
class ServerBootedException : public ::Ice::UserExceptionHelper<ServerBootedException, MurmurException>
{
public:

    virtual ~ServerBootedException();

    ServerBootedException(const ServerBootedException&) = default;

    ServerBootedException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
};

/**
 * This is thrown if {@link Server.start} fails, and should generally be the cause for some concern.
 */
class ServerFailureException : public ::Ice::UserExceptionHelper<ServerFailureException, MurmurException>
{
public:

    virtual ~ServerFailureException();

    ServerFailureException(const ServerFailureException&) = default;

    ServerFailureException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
};

/**
 * This is thrown when you specify an invalid userid.
 */
class InvalidUserException : public ::Ice::UserExceptionHelper<InvalidUserException, MurmurException>
{
public:

    virtual ~InvalidUserException();

    InvalidUserException(const InvalidUserException&) = default;

    InvalidUserException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
};

/**
 * This is thrown when you try to set an invalid texture.
 */
class InvalidTextureException : public ::Ice::UserExceptionHelper<InvalidTextureException, MurmurException>
{
public:

    virtual ~InvalidTextureException();

    InvalidTextureException(const InvalidTextureException&) = default;

    InvalidTextureException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
};

/**
 * This is thrown when you supply an invalid callback.
 */
class InvalidCallbackException : public ::Ice::UserExceptionHelper<InvalidCallbackException, MurmurException>
{
public:

    virtual ~InvalidCallbackException();

    InvalidCallbackException(const InvalidCallbackException&) = default;

    InvalidCallbackException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
};

/**
 * This is thrown when you supply the wrong secret in the calling context.
 */
class InvalidSecretException : public ::Ice::UserExceptionHelper<InvalidSecretException, MurmurException>
{
public:

    virtual ~InvalidSecretException();

    InvalidSecretException(const InvalidSecretException&) = default;

    InvalidSecretException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
};

/**
 * This is thrown when the channel operation would exceed the channel nesting limit
 */
class NestingLimitException : public ::Ice::UserExceptionHelper<NestingLimitException, MurmurException>
{
public:

    virtual ~NestingLimitException();

    NestingLimitException(const NestingLimitException&) = default;

    NestingLimitException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
};

/**
 * This is thrown when you ask the server to disclose something that should be secret.
 */
class WriteOnlyException : public ::Ice::UserExceptionHelper<WriteOnlyException, MurmurException>
{
public:

    virtual ~WriteOnlyException();

    WriteOnlyException(const WriteOnlyException&) = default;

    WriteOnlyException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
};

/**
 * This is thrown when invalid input data was specified.
 */
class InvalidInputDataException : public ::Ice::UserExceptionHelper<InvalidInputDataException, MurmurException>
{
public:

    virtual ~InvalidInputDataException();

    InvalidInputDataException(const InvalidInputDataException&) = default;

    InvalidInputDataException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
};

/**
 * Context for actions in the Server menu.
 */
constexpr int ContextServer = 1;

/**
 * Context for actions in the Channel menu.
 */
constexpr int ContextChannel = 2;

/**
 * Context for actions in the User menu.
 */
constexpr int ContextUser = 4;

using ServerList = ::std::vector<::std::shared_ptr<ServerPrx>>;

using Ice::operator<;
using Ice::operator<=;
using Ice::operator>;
using Ice::operator>=;
using Ice::operator==;
using Ice::operator!=;

}

namespace MumbleServer
{

/**
 * Callback interface for servers. You can supply an implementation of this to receive notification
 * messages from the server.
 * If an added callback ever throws an exception or goes away, it will be automatically removed.
 * Please note that all callbacks are done asynchronously; murmur does not wait for the callback to
 * complete before continuing processing.
 * Note that callbacks are removed when a server is stopped, so you should have a callback for
 * {@link MetaCallback.started} which calls {@link Server.addCallback}.
 * @see MetaCallback
 * @see Server.addCallback
 */
class ServerCallback : public virtual ::Ice::Object
{
public:

    using ProxyType = ServerCallbackPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Called when a user connects to the server.
     * @param state State of connected user.
     * @param current The Current object for the invocation.
     */
    virtual void userConnected(User state, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_userConnected(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Called when a user disconnects from the server. The user has already been removed, so you can no longer use methods like {@link Server.getState}
     * to retrieve the user's state.
     * @param state State of disconnected user.
     * @param current The Current object for the invocation.
     */
    virtual void userDisconnected(User state, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_userDisconnected(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Called when a user state changes. This is called if the user moves, is renamed, is muted, deafened etc.
     * @param state New state of user.
     * @param current The Current object for the invocation.
     */
    virtual void userStateChanged(User state, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_userStateChanged(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Called when user writes a text message
     * @param state the User sending the message
     * @param message the TextMessage the user has sent
     * @param current The Current object for the invocation.
     */
    virtual void userTextMessage(User state, TextMessage message, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_userTextMessage(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Called when a new channel is created.
     * @param state State of new channel.
     * @param current The Current object for the invocation.
     */
    virtual void channelCreated(Channel state, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_channelCreated(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Called when a channel is removed. The channel has already been removed, you can no longer use methods like {@link Server.getChannelState}
     * @param state State of removed channel.
     * @param current The Current object for the invocation.
     */
    virtual void channelRemoved(Channel state, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_channelRemoved(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Called when a new channel state changes. This is called if the channel is moved, renamed or if new links are added.
     * @param state New state of channel.
     * @param current The Current object for the invocation.
     */
    virtual void channelStateChanged(Channel state, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_channelStateChanged(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * Callback interface for context actions. You need to supply one of these for {@link Server.addContext}.
 * If an added callback ever throws an exception or goes away, it will be automatically removed.
 * Please note that all callbacks are done asynchronously; murmur does not wait for the callback to
 * complete before continuing processing.
 */
class ServerContextCallback : public virtual ::Ice::Object
{
public:

    using ProxyType = ServerContextCallbackPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Called when a context action is performed.
     * @param action Action to be performed.
     * @param usr User which initiated the action.
     * @param session If nonzero, session of target user.
     * @param channelid If not -1, id of target channel.
     * @param current The Current object for the invocation.
     */
    virtual void contextAction(::std::string action, User usr, int session, int channelid, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_contextAction(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * Callback interface for server authentication. You need to supply one of these for {@link Server.setAuthenticator}.
 * If an added callback ever throws an exception or goes away, it will be automatically removed.
 * Please note that unlike {@link ServerCallback} and {@link ServerContextCallback}, these methods are called
 * synchronously. If the response lags, the entire murmur server will lag.
 * Also note that, as the method calls are synchronous, making a call to {@link Server} or {@link Meta} will
 * deadlock the server.
 */
class ServerAuthenticator : public virtual ::Ice::Object
{
public:

    using ProxyType = ServerAuthenticatorPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Encapsulates the results of a call to authenticate.
     */
    struct AuthenticateResult
    {
        /** UserID of authenticated user, -1 for authentication failures, -2 for unknown user (fallthrough), -3 for authentication failures where the data could (temporarily) not be verified. */
        int returnValue;
        /** Set this to change the username from the supplied one. */
        ::std::string newname;
        /** List of groups on the root channel that the user will be added to for the duration of the connection. */
        GroupNameList groups;
    };

    /**
     * Called to authenticate a user. If you do not know the username in question, always return -2 from this
     * method to fall through to normal database authentication.
     * Note that if authentication succeeds, murmur will create a record of the user in it's database, reserving
     * the username and id so it cannot be used for normal database authentication.
     * The data in the certificate (name, email addresses etc), as well as the list of signing certificates,
     * should only be trusted if certstrong is true.
     *
     * Internally, Murmur treats usernames as case-insensitive. It is recommended
     * that authenticators do the same. Murmur checks if a username is in use when
     * a user connects. If the connecting user is registered, the other username is
     * kicked. If the connecting user is not registered, the connecting user is not
     * allowed to join the server.
     * @param name Username to authenticate.
     * @param pw Password to authenticate with.
     * @param certificates List of der encoded certificates the user connected with.
     * @param certhash Hash of user certificate, as used by murmur internally when matching.
     * @param certstrong True if certificate was valid and signed by a trusted CA.
     * @param newname Set this to change the username from the supplied one.
     * @param groups List of groups on the root channel that the user will be added to for the duration of the connection.
     * @param current The Current object for the invocation.
     * @return UserID of authenticated user, -1 for authentication failures, -2 for unknown user (fallthrough),
     * -3 for authentication failures where the data could (temporarily) not be verified.
     */
    virtual int authenticate(::std::string name, ::std::string pw, CertificateList certificates, ::std::string certhash, bool certstrong, ::std::string& newname, GroupNameList& groups, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_authenticate(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Encapsulates the results of a call to getInfo.
     */
    struct GetInfoResult
    {
        /** true if information is present, false to fall through. */
        bool returnValue;
        /** Information about user. */
        UserInfoMap info;
    };

    /**
     * Fetch information about a user. This is used to retrieve information like email address, keyhash etc. If you
     * want murmur to take care of this information itself, simply return false to fall through.
     * @param id User id.
     * @param info Information about user. This needs to include at least "name".
     * @param current The Current object for the invocation.
     * @return true if information is present, false to fall through.
     */
    virtual bool getInfo(int id, UserInfoMap& info, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getInfo(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Map a name to a user id.
     * @param name Username to map.
     * @param current The Current object for the invocation.
     * @return User id or -2 for unknown name.
     */
    virtual int nameToId(::std::string name, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_nameToId(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Map a user id to a username.
     * @param id User id to map.
     * @param current The Current object for the invocation.
     * @return Name of user or empty string for unknown id.
     */
    virtual ::std::string idToName(int id, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_idToName(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Map a user to a custom Texture.
     * @param id User id to map.
     * @param current The Current object for the invocation.
     * @return User texture or an empty texture for unknown users or users without textures.
     */
    virtual Texture idToTexture(int id, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_idToTexture(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * Callback interface for server authentication and registration. This allows you to support both authentication
 * and account updating.
 * You do not need to implement this if all you want is authentication, you only need this if other scripts
 * connected to the same server calls e.g. {@link Server.setTexture}.
 * Almost all of these methods support fall through, meaning murmur should continue the operation against its
 * own database.
 */
class ServerUpdatingAuthenticator : public virtual ServerAuthenticator
{
public:

    using ProxyType = ServerUpdatingAuthenticatorPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Register a new user.
     * @param info Information about user to register.
     * @param current The Current object for the invocation.
     * @return User id of new user, -1 for registration failure, or -2 to fall through.
     */
    virtual int registerUser(UserInfoMap info, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_registerUser(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Unregister a user.
     * @param id Userid to unregister.
     * @param current The Current object for the invocation.
     * @return 1 for successful unregistration, 0 for unsuccessful unregistration, -1 to fall through.
     */
    virtual int unregisterUser(int id, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_unregisterUser(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get a list of registered users matching filter.
     * @param filter Substring usernames must contain. If empty, return all registered users.
     * @param current The Current object for the invocation.
     * @return List of matching registered users.
     */
    virtual NameMap getRegisteredUsers(::std::string filter, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getRegisteredUsers(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set additional information for user registration.
     * @param id Userid of registered user.
     * @param info Information to set about user. This should be merged with existing information.
     * @param current The Current object for the invocation.
     * @return 1 for successful update, 0 for unsuccessful update, -1 to fall through.
     */
    virtual int setInfo(int id, UserInfoMap info, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setInfo(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set texture (now called avatar) of user registration.
     * @param id registrationId of registered user.
     * @param tex New texture.
     * @param current The Current object for the invocation.
     * @return 1 for successful update, 0 for unsuccessful update, -1 to fall through.
     */
    virtual int setTexture(int id, Texture tex, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setTexture(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * Per-server interface. This includes all methods for configuring and altering
 * the state of a single virtual server. You can retrieve a pointer to this interface
 * from one of the methods in {@link Meta}.
 */
class Server : public virtual ::Ice::Object
{
public:

    using ProxyType = ServerPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Shows if the server currently running (accepting users).
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void isRunningAsync(::std::function<void(bool returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_isRunning(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Start server.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void startAsync(::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_start(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Stop server.
     * Note: Server will be restarted on Murmur restart unless explicitly disabled
     * with setConf("boot", false)
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void stopAsync(::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_stop(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Delete server and all it's configuration.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void deleteAsync(::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_delete(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch the server id.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void idAsync(::std::function<void(int returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_id(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Add a callback. The callback will receive notifications about changes to users and channels.
     * @param cb Callback interface which will receive notifications.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @see removeCallback
     */
    virtual void addCallbackAsync(::std::shared_ptr<ServerCallbackPrx> cb, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_addCallback(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @see addCallback
     */
    virtual void removeCallbackAsync(::std::shared_ptr<ServerCallbackPrx> cb, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_removeCallback(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set external authenticator. If set, all authentications from clients are forwarded to this
     * proxy.
     * @param auth Authenticator object to perform subsequent authentications.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void setAuthenticatorAsync(::std::shared_ptr<ServerAuthenticatorPrx> auth, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setAuthenticator(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Retrieve configuration item.
     * @param key Configuration key.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getConfAsync(::std::string key, ::std::function<void(const ::std::string& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getConf(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Retrieve all configuration items.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getAllConfAsync(::std::function<void(const ConfigMap& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getAllConf(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set a configuration item.
     * @param key Configuration key.
     * @param value Configuration value.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void setConfAsync(::std::string key, ::std::string value, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setConf(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set superuser password. This is just a convenience for using {@link updateRegistration} on user id 0.
     * @param pw Password.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void setSuperuserPasswordAsync(::std::string pw, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setSuperuserPassword(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch log entries.
     * @param first Lowest numbered entry to fetch. 0 is the most recent item.
     * @param last Last entry to fetch.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getLogAsync(int first, int last, ::std::function<void(const LogList& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getLog(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch length of log
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getLogLenAsync(::std::function<void(int returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getLogLen(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch all users. This returns all currently connected users on the server.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @see getState
     */
    virtual void getUsersAsync(::std::function<void(const UserMap& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getUsers(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch all channels. This returns all defined channels on the server. The root channel is always channel 0.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @see getChannelState
     */
    virtual void getChannelsAsync(::std::function<void(const ChannelMap& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getChannels(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch certificate of user. This returns the complete certificate chain of a user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getCertificateListAsync(int session, ::std::function<void(const CertificateList& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getCertificateList(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch all channels and connected users as a tree. This retrieves an easy-to-use representation of the server
     * as a tree. This is primarily used for viewing the state of the server on a webpage.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getTreeAsync(::std::function<void(const ::std::shared_ptr<Tree>& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getTree(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch all current IP bans on the server.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getBansAsync(::std::function<void(const BanList& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getBans(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set all current IP bans on the server. This will replace any bans already present, so if you want to add a ban, be sure to call {@link getBans} and then
     * append to the returned list before calling this method.
     * @param bans List of bans.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void setBansAsync(BanList bans, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setBans(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Kick a user. The user is not banned, and is free to rejoin the server.
     * @param session Connection ID of user. See {@link User.session}.
     * @param reason Text message to show when user is kicked.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void kickUserAsync(int session, ::std::string reason, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_kickUser(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get state of a single connected user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @see setState
     * @see getUsers
     */
    virtual void getStateAsync(int session, ::std::function<void(const User& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getState(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set user state. You can use this to move, mute and deafen users.
     * @param state User state to set.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @see getState
     */
    virtual void setStateAsync(User state, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setState(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Send text message to a single user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param text Message to send.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @see sendMessageChannel
     */
    virtual void sendMessageAsync(int session, ::std::string text, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_sendMessage(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Check if user is permitted to perform action.
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param perm Permission bits to check.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void hasPermissionAsync(int session, int channelid, int perm, ::std::function<void(bool returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_hasPermission(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Return users effective permissions
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void effectivePermissionsAsync(int session, int channelid, ::std::function<void(int returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_effectivePermissions(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Add a context callback. This is done per user, and will add a context menu action for the user.
     * @param session Session of user which should receive context entry.
     * @param action Action string, a unique name to associate with the action.
     * @param text Name of action shown to user.
     * @param cb Callback interface which will receive notifications.
     * @param ctx Context this should be used in. Needs to be one or a combination of {@link ContextServer}, {@link ContextChannel} and {@link ContextUser}.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @see removeContextCallback
     */
    virtual void addContextCallbackAsync(int session, ::std::string action, ::std::string text, ::std::shared_ptr<ServerContextCallbackPrx> cb, int ctx, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_addContextCallback(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed. This callback will be removed from all from all users.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @see addContextCallback
     */
    virtual void removeContextCallbackAsync(::std::shared_ptr<ServerContextCallbackPrx> cb, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_removeContextCallback(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get state of single channel.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @see setChannelState
     * @see getChannels
     */
    virtual void getChannelStateAsync(int channelid, ::std::function<void(const Channel& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getChannelState(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set state of a single channel. You can use this to move or relink channels.
     * @param state Channel state to set.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @see getChannelState
     */
    virtual void setChannelStateAsync(Channel state, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setChannelState(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove a channel and all its subchannels.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void removeChannelAsync(int channelid, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_removeChannel(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Add a new channel.
     * @param name Name of new channel.
     * @param parent Channel ID of parent channel. See {@link Channel.id}.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void addChannelAsync(::std::string name, int parent, ::std::function<void(int returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_addChannel(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Send text message to channel or a tree of channels.
     * @param channelid Channel ID of channel to send to. See {@link Channel.id}.
     * @param tree If true, the message will be sent to the channel and all its subchannels.
     * @param text Message to send.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @see sendMessage
     */
    virtual void sendMessageChannelAsync(int channelid, bool tree, ::std::string text, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_sendMessageChannel(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Encapsulates the results of a call to getACL.
     */
    struct GetACLResult
    {
        /** List of ACLs on the channel. */
        ACLList acls;
        /** List of groups on the channel. */
        GroupList groups;
        /** Does this channel inherit ACLs from the parent channel? */
        bool inherit;
    };

    /**
     * Retrieve ACLs and Groups on a channel.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getACLAsync(int channelid, ::std::function<void(const ACLList& acls, const GroupList& groups, bool inherit)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getACL(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set ACLs and Groups on a channel. Note that this will replace all existing ACLs and groups on the channel.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param acls List of ACLs on the channel.
     * @param groups List of groups on the channel.
     * @param inherit Should this channel inherit ACLs from the parent channel?
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void setACLAsync(int channelid, ACLList acls, GroupList groups, bool inherit, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setACL(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Temporarily add a user to a group on a channel. This state is not saved, and is intended for temporary memberships.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to add to.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void addUserToGroupAsync(int channelid, int session, ::std::string group, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_addUserToGroup(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove a user from a temporary group membership on a channel. This state is not saved, and is intended for temporary memberships.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to remove from.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void removeUserFromGroupAsync(int channelid, int session, ::std::string group, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_removeUserFromGroup(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Redirect whisper targets for user. If set, whenever a user tries to whisper to group "source", the whisper will be redirected to group "target".
     * To remove a redirect pass an empty target string. This is intended for context groups.
     * @param session Connection ID of user. See {@link User.session}.
     * @param source Group name to redirect from.
     * @param target Group name to redirect to.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void redirectWhisperGroupAsync(int session, ::std::string source, ::std::string target, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_redirectWhisperGroup(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Map a list of {@link User.userid} to a matching name.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getUserNamesAsync(IdList ids, ::std::function<void(const NameMap& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getUserNames(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Map a list of user names to a matching id.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @reuturn List of matching ids, with -1 representing invalid or unknown user names.
     */
    virtual void getUserIdsAsync(NameList names, ::std::function<void(const IdMap& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getUserIds(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Register a new user.
     * @param info Information about new user. Must include at least "name".
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void registerUserAsync(UserInfoMap info, ::std::function<void(int returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_registerUser(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove a user registration.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void unregisterUserAsync(int userid, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_unregisterUser(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Update the registration for a user. You can use this to set the email or password of a user,
     * and can also use it to change the user's name.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void updateRegistrationAsync(int userid, UserInfoMap info, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_updateRegistration(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch registration for a single user.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getRegistrationAsync(int userid, ::std::function<void(const UserInfoMap& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getRegistration(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch a group of registered users.
     * @param filter Substring of user name. If blank, will retrieve all registered users.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getRegisteredUsersAsync(::std::string filter, ::std::function<void(const NameMap& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getRegisteredUsers(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Verify the password of a user. You can use this to verify a user's credentials.
     * @param name User name. See {@link RegisteredUser.name}.
     * @param pw User password.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void verifyPasswordAsync(::std::string name, ::std::string pw, ::std::function<void(int returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_verifyPassword(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch user texture. Textures are stored as zlib compress()ed 600x60 32-bit BGRA data.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getTextureAsync(int userid, ::std::function<void(const Texture& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getTexture(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set a user texture (now called avatar).
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param tex Texture (as a Byte-Array) to set for the user, or an empty texture to remove the existing texture.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void setTextureAsync(int userid, Texture tex, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setTexture(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get virtual server uptime.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getUptimeAsync(::std::function<void(int returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getUptime(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Update the server's certificate information.
     *
     * Reconfigure the running server's TLS socket with the given
     * certificate and private key.
     *
     * The certificate and and private key must be PEM formatted.
     *
     * New clients will see the new certificate.
     * Existing clients will continue to see the certificate the server
     * was using when they connected to it.
     *
     * This method throws InvalidInputDataException if any of the
     * following errors happen:
     * - Unable to decode the PEM certificate and/or private key.
     * - Unable to decrypt the private key with the given passphrase.
     * - The certificate and/or private key do not contain RSA keys.
     * - The certificate is not usable with the given private key.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void updateCertificateAsync(::std::string certificate, ::std::string privateKey, ::std::string passphrase, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_updateCertificate(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Makes the given user start listening to the given channel.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void startListeningAsync(int userid, int channelid, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_startListening(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Makes the given user stop listening to the given channel.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void stopListeningAsync(int userid, int channelid, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_stopListening(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void isListeningAsync(int userid, int channelid, ::std::function<void(bool returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_isListening(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * @param userid The ID of the user
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getListeningChannelsAsync(int userid, ::std::function<void(const IntList& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getListeningChannels(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * @param channelid The ID of the channel
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getListeningUsersAsync(int channelid, ::std::function<void(const IntList& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getListeningUsers(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getListenerVolumeAdjustmentAsync(int channelid, int userid, ::std::function<void(float returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getListenerVolumeAdjustment(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Sets the volume adjustment set for a listener of the given user in the given channel
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void setListenerVolumeAdjustmentAsync(int channelid, int userid, float volumeAdjustment, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setListenerVolumeAdjustment(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * @param receiverUserIDs list of IDs of the users the message shall be sent to
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void sendWelcomeMessageAsync(IdList receiverUserIDs, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_sendWelcomeMessage(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * Callback interface for Meta. You can supply an implementation of this to receive notifications
 * when servers are stopped or started.
 * If an added callback ever throws an exception or goes away, it will be automatically removed.
 * Please note that all callbacks are done asynchronously; murmur does not wait for the callback to
 * complete before continuing processing.
 * @see ServerCallback
 * @see Meta.addCallback
 */
class MetaCallback : public virtual ::Ice::Object
{
public:

    using ProxyType = MetaCallbackPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Called when a server is started. The server is up and running when this event is sent, so all methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param current The Current object for the invocation.
     */
    virtual void started(::std::shared_ptr<ServerPrx> srv, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_started(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Called when a server is stopped. The server is already stopped when this event is sent, so no methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param current The Current object for the invocation.
     */
    virtual void stopped(::std::shared_ptr<ServerPrx> srv, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_stopped(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * This is the meta interface. It is primarily used for retrieving the {@link Server} interfaces for each individual server.
 */
class Meta : public virtual ::Ice::Object
{
public:

    using ProxyType = MetaPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Fetch interface to specific server.
     * @param id Server ID. See {@link Server.getId}.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getServerAsync(int id, ::std::function<void(const ::std::shared_ptr<ServerPrx>& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getServer(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Create a new server. Call {@link Server.getId} on the returned interface to find it's ID.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void newServerAsync(::std::function<void(const ::std::shared_ptr<ServerPrx>& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_newServer(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch list of all currently running servers.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getBootedServersAsync(::std::function<void(const ServerList& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getBootedServers(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch list of all defined servers.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getAllServersAsync(::std::function<void(const ServerList& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getAllServers(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch default configuration. This returns the configuration items that were set in the configuration file, or
     * the built-in default. The individual servers will use these values unless they have been overridden in the
     * server specific configuration. The only special case is the port, which defaults to the value defined here +
     * the servers ID - 1 (so that virtual server #1 uses the defined port, server #2 uses port+1 etc).
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getDefaultConfAsync(::std::function<void(const ConfigMap& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getDefaultConf(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Encapsulates the results of a call to getVersion.
     */
    struct GetVersionResult
    {
        /** Major version. */
        int major;
        /** Minor version. */
        int minor;
        /** Patchlevel. */
        int patch;
        /** Textual representation of version. */
        ::std::string text;
    };

    /**
     * Fetch version of Murmur.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getVersionAsync(::std::function<void(int major, int minor, int patch, const ::std::string& text)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getVersion(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Add a callback. The callback will receive notifications when servers are started or stopped.
     * @param cb Callback interface which will receive notifications.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void addCallbackAsync(::std::shared_ptr<MetaCallbackPrx> cb, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_addCallback(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void removeCallbackAsync(::std::shared_ptr<MetaCallbackPrx> cb, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_removeCallback(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get murmur uptime.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getUptimeAsync(::std::function<void(int returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getUptime(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get slice file.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getSliceAsync(::std::function<void(const ::std::string& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getSlice(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Returns a checksum dict for the slice file.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void getSliceChecksumsAsync(::std::function<void(const ::Ice::SliceChecksumDict& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getSliceChecksums(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

}

namespace MumbleServer
{

/**
 * User and subchannel state. Read-only.
 */
class Tree : public ::Ice::ValueHelper<Tree, ::Ice::Value>
{
public:

    virtual ~Tree();

    Tree() = default;

    Tree(const Tree&) = default;
    Tree(Tree&&) = default;
    Tree& operator=(const Tree&) = default;
    Tree& operator=(Tree&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param c Channel definition of current channel.
     * @param children List of subchannels.
     * @param users Users in this channel.
     */
    Tree(const ::MumbleServer::Channel& c, const ::MumbleServer::TreeList& children, const ::MumbleServer::UserList& users) :
        c(c),
        children(children),
        users(users)
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::MumbleServer::Channel&, const ::MumbleServer::TreeList&, const ::MumbleServer::UserList&> ice_tuple() const
    {
        return std::tie(c, children, users);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Channel definition of current channel.
     */
    ::MumbleServer::Channel c;
    /**
     * List of subchannels.
     */
    ::MumbleServer::TreeList children;
    /**
     * Users in this channel.
     */
    ::MumbleServer::UserList users;
};

/// \cond INTERNAL
static Tree _iceS_Tree_init;
/// \endcond

}

namespace MumbleServer
{

/**
 * Callback interface for servers. You can supply an implementation of this to receive notification
 * messages from the server.
 * If an added callback ever throws an exception or goes away, it will be automatically removed.
 * Please note that all callbacks are done asynchronously; murmur does not wait for the callback to
 * complete before continuing processing.
 * Note that callbacks are removed when a server is stopped, so you should have a callback for
 * {@link MetaCallback.started} which calls {@link Server.addCallback}.
 * @see MetaCallback
 * @see Server.addCallback
 */
class ServerCallbackPrx : public virtual ::Ice::Proxy<ServerCallbackPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Called when a user connects to the server.
     * @param state State of connected user.
     * @param context The Context map to send with the invocation.
     */
    void userConnected(const User& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerCallbackPrx::_iceI_userConnected, state, context).get();
    }

    /**
     * Called when a user connects to the server.
     * @param state State of connected user.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto userConnectedAsync(const User& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerCallbackPrx::_iceI_userConnected, state, context);
    }

    /**
     * Called when a user connects to the server.
     * @param state State of connected user.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    userConnectedAsync(const User& state,
                       ::std::function<void()> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerCallbackPrx::_iceI_userConnected, state, context);
    }

    /// \cond INTERNAL
    void _iceI_userConnected(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const User&, const ::Ice::Context&);
    /// \endcond

    /**
     * Called when a user disconnects from the server. The user has already been removed, so you can no longer use methods like {@link Server.getState}
     * to retrieve the user's state.
     * @param state State of disconnected user.
     * @param context The Context map to send with the invocation.
     */
    void userDisconnected(const User& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerCallbackPrx::_iceI_userDisconnected, state, context).get();
    }

    /**
     * Called when a user disconnects from the server. The user has already been removed, so you can no longer use methods like {@link Server.getState}
     * to retrieve the user's state.
     * @param state State of disconnected user.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto userDisconnectedAsync(const User& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerCallbackPrx::_iceI_userDisconnected, state, context);
    }

    /**
     * Called when a user disconnects from the server. The user has already been removed, so you can no longer use methods like {@link Server.getState}
     * to retrieve the user's state.
     * @param state State of disconnected user.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    userDisconnectedAsync(const User& state,
                          ::std::function<void()> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerCallbackPrx::_iceI_userDisconnected, state, context);
    }

    /// \cond INTERNAL
    void _iceI_userDisconnected(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const User&, const ::Ice::Context&);
    /// \endcond

    /**
     * Called when a user state changes. This is called if the user moves, is renamed, is muted, deafened etc.
     * @param state New state of user.
     * @param context The Context map to send with the invocation.
     */
    void userStateChanged(const User& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerCallbackPrx::_iceI_userStateChanged, state, context).get();
    }

    /**
     * Called when a user state changes. This is called if the user moves, is renamed, is muted, deafened etc.
     * @param state New state of user.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto userStateChangedAsync(const User& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerCallbackPrx::_iceI_userStateChanged, state, context);
    }

    /**
     * Called when a user state changes. This is called if the user moves, is renamed, is muted, deafened etc.
     * @param state New state of user.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    userStateChangedAsync(const User& state,
                          ::std::function<void()> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerCallbackPrx::_iceI_userStateChanged, state, context);
    }

    /// \cond INTERNAL
    void _iceI_userStateChanged(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const User&, const ::Ice::Context&);
    /// \endcond

    /**
     * Called when user writes a text message
     * @param state the User sending the message
     * @param message the TextMessage the user has sent
     * @param context The Context map to send with the invocation.
     */
    void userTextMessage(const User& state, const TextMessage& message, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerCallbackPrx::_iceI_userTextMessage, state, message, context).get();
    }

    /**
     * Called when user writes a text message
     * @param state the User sending the message
     * @param message the TextMessage the user has sent
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto userTextMessageAsync(const User& state, const TextMessage& message, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerCallbackPrx::_iceI_userTextMessage, state, message, context);
    }

    /**
     * Called when user writes a text message
     * @param state the User sending the message
     * @param message the TextMessage the user has sent
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    userTextMessageAsync(const User& state, const TextMessage& message,
                         ::std::function<void()> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerCallbackPrx::_iceI_userTextMessage, state, message, context);
    }

    /// \cond INTERNAL
    void _iceI_userTextMessage(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const User&, const TextMessage&, const ::Ice::Context&);
    /// \endcond

    /**
     * Called when a new channel is created.
     * @param state State of new channel.
     * @param context The Context map to send with the invocation.
     */
    void channelCreated(const Channel& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerCallbackPrx::_iceI_channelCreated, state, context).get();
    }

    /**
     * Called when a new channel is created.
     * @param state State of new channel.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto channelCreatedAsync(const Channel& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerCallbackPrx::_iceI_channelCreated, state, context);
    }

    /**
     * Called when a new channel is created.
     * @param state State of new channel.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    channelCreatedAsync(const Channel& state,
                        ::std::function<void()> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerCallbackPrx::_iceI_channelCreated, state, context);
    }

    /// \cond INTERNAL
    void _iceI_channelCreated(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const Channel&, const ::Ice::Context&);
    /// \endcond

    /**
     * Called when a channel is removed. The channel has already been removed, you can no longer use methods like {@link Server.getChannelState}
     * @param state State of removed channel.
     * @param context The Context map to send with the invocation.
     */
    void channelRemoved(const Channel& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerCallbackPrx::_iceI_channelRemoved, state, context).get();
    }

    /**
     * Called when a channel is removed. The channel has already been removed, you can no longer use methods like {@link Server.getChannelState}
     * @param state State of removed channel.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto channelRemovedAsync(const Channel& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerCallbackPrx::_iceI_channelRemoved, state, context);
    }

    /**
     * Called when a channel is removed. The channel has already been removed, you can no longer use methods like {@link Server.getChannelState}
     * @param state State of removed channel.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    channelRemovedAsync(const Channel& state,
                        ::std::function<void()> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerCallbackPrx::_iceI_channelRemoved, state, context);
    }

    /// \cond INTERNAL
    void _iceI_channelRemoved(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const Channel&, const ::Ice::Context&);
    /// \endcond

    /**
     * Called when a new channel state changes. This is called if the channel is moved, renamed or if new links are added.
     * @param state New state of channel.
     * @param context The Context map to send with the invocation.
     */
    void channelStateChanged(const Channel& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerCallbackPrx::_iceI_channelStateChanged, state, context).get();
    }

    /**
     * Called when a new channel state changes. This is called if the channel is moved, renamed or if new links are added.
     * @param state New state of channel.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto channelStateChangedAsync(const Channel& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerCallbackPrx::_iceI_channelStateChanged, state, context);
    }

    /**
     * Called when a new channel state changes. This is called if the channel is moved, renamed or if new links are added.
     * @param state New state of channel.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    channelStateChangedAsync(const Channel& state,
                             ::std::function<void()> response,
                             ::std::function<void(::std::exception_ptr)> ex = nullptr,
                             ::std::function<void(bool)> sent = nullptr,
                             const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerCallbackPrx::_iceI_channelStateChanged, state, context);
    }

    /// \cond INTERNAL
    void _iceI_channelStateChanged(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const Channel&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    ServerCallbackPrx() = default;
    friend ::std::shared_ptr<ServerCallbackPrx> IceInternal::createProxy<ServerCallbackPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * Callback interface for context actions. You need to supply one of these for {@link Server.addContext}.
 * If an added callback ever throws an exception or goes away, it will be automatically removed.
 * Please note that all callbacks are done asynchronously; murmur does not wait for the callback to
 * complete before continuing processing.
 */
class ServerContextCallbackPrx : public virtual ::Ice::Proxy<ServerContextCallbackPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Called when a context action is performed.
     * @param action Action to be performed.
     * @param usr User which initiated the action.
     * @param session If nonzero, session of target user.
     * @param channelid If not -1, id of target channel.
     * @param context The Context map to send with the invocation.
     */
    void contextAction(const ::std::string& action, const User& usr, int session, int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerContextCallbackPrx::_iceI_contextAction, action, usr, session, channelid, context).get();
    }

    /**
     * Called when a context action is performed.
     * @param action Action to be performed.
     * @param usr User which initiated the action.
     * @param session If nonzero, session of target user.
     * @param channelid If not -1, id of target channel.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto contextActionAsync(const ::std::string& action, const User& usr, int session, int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerContextCallbackPrx::_iceI_contextAction, action, usr, session, channelid, context);
    }

    /**
     * Called when a context action is performed.
     * @param action Action to be performed.
     * @param usr User which initiated the action.
     * @param session If nonzero, session of target user.
     * @param channelid If not -1, id of target channel.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    contextActionAsync(const ::std::string& action, const User& usr, int session, int channelid,
                       ::std::function<void()> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerContextCallbackPrx::_iceI_contextAction, action, usr, session, channelid, context);
    }

    /// \cond INTERNAL
    void _iceI_contextAction(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const User&, int, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    ServerContextCallbackPrx() = default;
    friend ::std::shared_ptr<ServerContextCallbackPrx> IceInternal::createProxy<ServerContextCallbackPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * Callback interface for server authentication. You need to supply one of these for {@link Server.setAuthenticator}.
 * If an added callback ever throws an exception or goes away, it will be automatically removed.
 * Please note that unlike {@link ServerCallback} and {@link ServerContextCallback}, these methods are called
 * synchronously. If the response lags, the entire murmur server will lag.
 * Also note that, as the method calls are synchronous, making a call to {@link Server} or {@link Meta} will
 * deadlock the server.
 */
class ServerAuthenticatorPrx : public virtual ::Ice::Proxy<ServerAuthenticatorPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Called to authenticate a user. If you do not know the username in question, always return -2 from this
     * method to fall through to normal database authentication.
     * Note that if authentication succeeds, murmur will create a record of the user in it's database, reserving
     * the username and id so it cannot be used for normal database authentication.
     * The data in the certificate (name, email addresses etc), as well as the list of signing certificates,
     * should only be trusted if certstrong is true.
     *
     * Internally, Murmur treats usernames as case-insensitive. It is recommended
     * that authenticators do the same. Murmur checks if a username is in use when
     * a user connects. If the connecting user is registered, the other username is
     * kicked. If the connecting user is not registered, the connecting user is not
     * allowed to join the server.
     * @param name Username to authenticate.
     * @param pw Password to authenticate with.
     * @param certificates List of der encoded certificates the user connected with.
     * @param certhash Hash of user certificate, as used by murmur internally when matching.
     * @param certstrong True if certificate was valid and signed by a trusted CA.
     * @param newname Set this to change the username from the supplied one.
     * @param groups List of groups on the root channel that the user will be added to for the duration of the connection.
     * @param context The Context map to send with the invocation.
     * @return UserID of authenticated user, -1 for authentication failures, -2 for unknown user (fallthrough),
     * -3 for authentication failures where the data could (temporarily) not be verified.
     */
    int authenticate(const ::std::string& name, const ::std::string& pw, const CertificateList& certificates, const ::std::string& certhash, bool certstrong, ::std::string& newname, GroupNameList& groups, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _result = _makePromiseOutgoing<ServerAuthenticator::AuthenticateResult>(true, this, &ServerAuthenticatorPrx::_iceI_authenticate, name, pw, certificates, certhash, certstrong, context).get();
        newname = ::std::move(_result.newname);
        groups = ::std::move(_result.groups);
        return _result.returnValue;
    }

    /**
     * Called to authenticate a user. If you do not know the username in question, always return -2 from this
     * method to fall through to normal database authentication.
     * Note that if authentication succeeds, murmur will create a record of the user in it's database, reserving
     * the username and id so it cannot be used for normal database authentication.
     * The data in the certificate (name, email addresses etc), as well as the list of signing certificates,
     * should only be trusted if certstrong is true.
     *
     * Internally, Murmur treats usernames as case-insensitive. It is recommended
     * that authenticators do the same. Murmur checks if a username is in use when
     * a user connects. If the connecting user is registered, the other username is
     * kicked. If the connecting user is not registered, the connecting user is not
     * allowed to join the server.
     * @param name Username to authenticate.
     * @param pw Password to authenticate with.
     * @param certificates List of der encoded certificates the user connected with.
     * @param certhash Hash of user certificate, as used by murmur internally when matching.
     * @param certstrong True if certificate was valid and signed by a trusted CA.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto authenticateAsync(const ::std::string& name, const ::std::string& pw, const CertificateList& certificates, const ::std::string& certhash, bool certstrong, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<ServerAuthenticator::AuthenticateResult>>().get_future())
    {
        return _makePromiseOutgoing<ServerAuthenticator::AuthenticateResult, P>(false, this, &ServerAuthenticatorPrx::_iceI_authenticate, name, pw, certificates, certhash, certstrong, context);
    }

    /**
     * Called to authenticate a user. If you do not know the username in question, always return -2 from this
     * method to fall through to normal database authentication.
     * Note that if authentication succeeds, murmur will create a record of the user in it's database, reserving
     * the username and id so it cannot be used for normal database authentication.
     * The data in the certificate (name, email addresses etc), as well as the list of signing certificates,
     * should only be trusted if certstrong is true.
     *
     * Internally, Murmur treats usernames as case-insensitive. It is recommended
     * that authenticators do the same. Murmur checks if a username is in use when
     * a user connects. If the connecting user is registered, the other username is
     * kicked. If the connecting user is not registered, the connecting user is not
     * allowed to join the server.
     * @param name Username to authenticate.
     * @param pw Password to authenticate with.
     * @param certificates List of der encoded certificates the user connected with.
     * @param certhash Hash of user certificate, as used by murmur internally when matching.
     * @param certstrong True if certificate was valid and signed by a trusted CA.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    authenticateAsync(const ::std::string& name, const ::std::string& pw, const CertificateList& certificates, const ::std::string& certhash, bool certstrong,
                      ::std::function<void(int, ::std::string, ::MumbleServer::GroupNameList)> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _responseCb = [response](ServerAuthenticator::AuthenticateResult&& _result)
        {
            response(_result.returnValue, ::std::move(_result.newname), ::std::move(_result.groups));
        };
        return _makeLamdaOutgoing<ServerAuthenticator::AuthenticateResult>(std::move(_responseCb), std::move(ex), std::move(sent), this, &MumbleServer::ServerAuthenticatorPrx::_iceI_authenticate, name, pw, certificates, certhash, certstrong, context);
    }

    /// \cond INTERNAL
    void _iceI_authenticate(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<ServerAuthenticator::AuthenticateResult>>&, const ::std::string&, const ::std::string&, const CertificateList&, const ::std::string&, bool, const ::Ice::Context&);
    /// \endcond

    /**
     * Fetch information about a user. This is used to retrieve information like email address, keyhash etc. If you
     * want murmur to take care of this information itself, simply return false to fall through.
     * @param id User id.
     * @param info Information about user. This needs to include at least "name".
     * @param context The Context map to send with the invocation.
     * @return true if information is present, false to fall through.
     */
    bool getInfo(int id, UserInfoMap& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _result = _makePromiseOutgoing<ServerAuthenticator::GetInfoResult>(true, this, &ServerAuthenticatorPrx::_iceI_getInfo, id, context).get();
        info = ::std::move(_result.info);
        return _result.returnValue;
    }

    /**
     * Fetch information about a user. This is used to retrieve information like email address, keyhash etc. If you
     * want murmur to take care of this information itself, simply return false to fall through.
     * @param id User id.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getInfoAsync(int id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<ServerAuthenticator::GetInfoResult>>().get_future())
    {
        return _makePromiseOutgoing<ServerAuthenticator::GetInfoResult, P>(false, this, &ServerAuthenticatorPrx::_iceI_getInfo, id, context);
    }

    /**
     * Fetch information about a user. This is used to retrieve information like email address, keyhash etc. If you
     * want murmur to take care of this information itself, simply return false to fall through.
     * @param id User id.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getInfoAsync(int id,
                 ::std::function<void(bool, ::MumbleServer::UserInfoMap)> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _responseCb = [response](ServerAuthenticator::GetInfoResult&& _result)
        {
            response(_result.returnValue, ::std::move(_result.info));
        };
        return _makeLamdaOutgoing<ServerAuthenticator::GetInfoResult>(std::move(_responseCb), std::move(ex), std::move(sent), this, &MumbleServer::ServerAuthenticatorPrx::_iceI_getInfo, id, context);
    }

    /// \cond INTERNAL
    void _iceI_getInfo(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<ServerAuthenticator::GetInfoResult>>&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Map a name to a user id.
     * @param name Username to map.
     * @param context The Context map to send with the invocation.
     * @return User id or -2 for unknown name.
     */
    int nameToId(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &ServerAuthenticatorPrx::_iceI_nameToId, name, context).get();
    }

    /**
     * Map a name to a user id.
     * @param name Username to map.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto nameToIdAsync(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &ServerAuthenticatorPrx::_iceI_nameToId, name, context);
    }

    /**
     * Map a name to a user id.
     * @param name Username to map.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    nameToIdAsync(const ::std::string& name,
                  ::std::function<void(int)> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerAuthenticatorPrx::_iceI_nameToId, name, context);
    }

    /// \cond INTERNAL
    void _iceI_nameToId(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Map a user id to a username.
     * @param id User id to map.
     * @param context The Context map to send with the invocation.
     * @return Name of user or empty string for unknown id.
     */
    ::std::string idToName(int id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::string>(true, this, &ServerAuthenticatorPrx::_iceI_idToName, id, context).get();
    }

    /**
     * Map a user id to a username.
     * @param id User id to map.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto idToNameAsync(int id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::string>>().get_future())
    {
        return _makePromiseOutgoing<::std::string, P>(false, this, &ServerAuthenticatorPrx::_iceI_idToName, id, context);
    }

    /**
     * Map a user id to a username.
     * @param id User id to map.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    idToNameAsync(int id,
                  ::std::function<void(::std::string)> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::string>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerAuthenticatorPrx::_iceI_idToName, id, context);
    }

    /// \cond INTERNAL
    void _iceI_idToName(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Map a user to a custom Texture.
     * @param id User id to map.
     * @param context The Context map to send with the invocation.
     * @return User texture or an empty texture for unknown users or users without textures.
     */
    Texture idToTexture(int id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::MumbleServer::Texture>(true, this, &ServerAuthenticatorPrx::_iceI_idToTexture, id, context).get();
    }

    /**
     * Map a user to a custom Texture.
     * @param id User id to map.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto idToTextureAsync(int id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::MumbleServer::Texture>>().get_future())
    {
        return _makePromiseOutgoing<::MumbleServer::Texture, P>(false, this, &ServerAuthenticatorPrx::_iceI_idToTexture, id, context);
    }

    /**
     * Map a user to a custom Texture.
     * @param id User id to map.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    idToTextureAsync(int id,
                     ::std::function<void(::MumbleServer::Texture)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::MumbleServer::Texture>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerAuthenticatorPrx::_iceI_idToTexture, id, context);
    }

    /// \cond INTERNAL
    void _iceI_idToTexture(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::MumbleServer::Texture>>&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    ServerAuthenticatorPrx() = default;
    friend ::std::shared_ptr<ServerAuthenticatorPrx> IceInternal::createProxy<ServerAuthenticatorPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * Callback interface for server authentication and registration. This allows you to support both authentication
 * and account updating.
 * You do not need to implement this if all you want is authentication, you only need this if other scripts
 * connected to the same server calls e.g. {@link Server.setTexture}.
 * Almost all of these methods support fall through, meaning murmur should continue the operation against its
 * own database.
 */
class ServerUpdatingAuthenticatorPrx : public virtual ::Ice::Proxy<ServerUpdatingAuthenticatorPrx, ServerAuthenticatorPrx>
{
public:

    /**
     * Register a new user.
     * @param info Information about user to register.
     * @param context The Context map to send with the invocation.
     * @return User id of new user, -1 for registration failure, or -2 to fall through.
     */
    int registerUser(const UserInfoMap& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &ServerUpdatingAuthenticatorPrx::_iceI_registerUser, info, context).get();
    }

    /**
     * Register a new user.
     * @param info Information about user to register.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto registerUserAsync(const UserInfoMap& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &ServerUpdatingAuthenticatorPrx::_iceI_registerUser, info, context);
    }

    /**
     * Register a new user.
     * @param info Information about user to register.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    registerUserAsync(const UserInfoMap& info,
                      ::std::function<void(int)> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerUpdatingAuthenticatorPrx::_iceI_registerUser, info, context);
    }

    /// \cond INTERNAL
    void _iceI_registerUser(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const UserInfoMap&, const ::Ice::Context&);
    /// \endcond

    /**
     * Unregister a user.
     * @param id Userid to unregister.
     * @param context The Context map to send with the invocation.
     * @return 1 for successful unregistration, 0 for unsuccessful unregistration, -1 to fall through.
     */
    int unregisterUser(int id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &ServerUpdatingAuthenticatorPrx::_iceI_unregisterUser, id, context).get();
    }

    /**
     * Unregister a user.
     * @param id Userid to unregister.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto unregisterUserAsync(int id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &ServerUpdatingAuthenticatorPrx::_iceI_unregisterUser, id, context);
    }

    /**
     * Unregister a user.
     * @param id Userid to unregister.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    unregisterUserAsync(int id,
                        ::std::function<void(int)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerUpdatingAuthenticatorPrx::_iceI_unregisterUser, id, context);
    }

    /// \cond INTERNAL
    void _iceI_unregisterUser(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Get a list of registered users matching filter.
     * @param filter Substring usernames must contain. If empty, return all registered users.
     * @param context The Context map to send with the invocation.
     * @return List of matching registered users.
     */
    NameMap getRegisteredUsers(const ::std::string& filter, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::MumbleServer::NameMap>(true, this, &ServerUpdatingAuthenticatorPrx::_iceI_getRegisteredUsers, filter, context).get();
    }

    /**
     * Get a list of registered users matching filter.
     * @param filter Substring usernames must contain. If empty, return all registered users.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getRegisteredUsersAsync(const ::std::string& filter, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::MumbleServer::NameMap>>().get_future())
    {
        return _makePromiseOutgoing<::MumbleServer::NameMap, P>(false, this, &ServerUpdatingAuthenticatorPrx::_iceI_getRegisteredUsers, filter, context);
    }

    /**
     * Get a list of registered users matching filter.
     * @param filter Substring usernames must contain. If empty, return all registered users.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getRegisteredUsersAsync(const ::std::string& filter,
                            ::std::function<void(::MumbleServer::NameMap)> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::MumbleServer::NameMap>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerUpdatingAuthenticatorPrx::_iceI_getRegisteredUsers, filter, context);
    }

    /// \cond INTERNAL
    void _iceI_getRegisteredUsers(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::MumbleServer::NameMap>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Set additional information for user registration.
     * @param id Userid of registered user.
     * @param info Information to set about user. This should be merged with existing information.
     * @param context The Context map to send with the invocation.
     * @return 1 for successful update, 0 for unsuccessful update, -1 to fall through.
     */
    int setInfo(int id, const UserInfoMap& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &ServerUpdatingAuthenticatorPrx::_iceI_setInfo, id, info, context).get();
    }

    /**
     * Set additional information for user registration.
     * @param id Userid of registered user.
     * @param info Information to set about user. This should be merged with existing information.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setInfoAsync(int id, const UserInfoMap& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &ServerUpdatingAuthenticatorPrx::_iceI_setInfo, id, info, context);
    }

    /**
     * Set additional information for user registration.
     * @param id Userid of registered user.
     * @param info Information to set about user. This should be merged with existing information.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setInfoAsync(int id, const UserInfoMap& info,
                 ::std::function<void(int)> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerUpdatingAuthenticatorPrx::_iceI_setInfo, id, info, context);
    }

    /// \cond INTERNAL
    void _iceI_setInfo(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, int, const UserInfoMap&, const ::Ice::Context&);
    /// \endcond

    /**
     * Set texture (now called avatar) of user registration.
     * @param id registrationId of registered user.
     * @param tex New texture.
     * @param context The Context map to send with the invocation.
     * @return 1 for successful update, 0 for unsuccessful update, -1 to fall through.
     */
    int setTexture(int id, const Texture& tex, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &ServerUpdatingAuthenticatorPrx::_iceI_setTexture, id, tex, context).get();
    }

    /**
     * Set texture (now called avatar) of user registration.
     * @param id registrationId of registered user.
     * @param tex New texture.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setTextureAsync(int id, const Texture& tex, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &ServerUpdatingAuthenticatorPrx::_iceI_setTexture, id, tex, context);
    }

    /**
     * Set texture (now called avatar) of user registration.
     * @param id registrationId of registered user.
     * @param tex New texture.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setTextureAsync(int id, const Texture& tex,
                    ::std::function<void(int)> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerUpdatingAuthenticatorPrx::_iceI_setTexture, id, tex, context);
    }

    /// \cond INTERNAL
    void _iceI_setTexture(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, int, const Texture&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    ServerUpdatingAuthenticatorPrx() = default;
    friend ::std::shared_ptr<ServerUpdatingAuthenticatorPrx> IceInternal::createProxy<ServerUpdatingAuthenticatorPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * Per-server interface. This includes all methods for configuring and altering
 * the state of a single virtual server. You can retrieve a pointer to this interface
 * from one of the methods in {@link Meta}.
 */
class ServerPrx : public virtual ::Ice::Proxy<ServerPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Shows if the server currently running (accepting users).
     * @param context The Context map to send with the invocation.
     * @return Run-state of server.
     */
    bool isRunning(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<bool>(true, this, &ServerPrx::_iceI_isRunning, context).get();
    }

    /**
     * Shows if the server currently running (accepting users).
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto isRunningAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<bool>>().get_future())
    {
        return _makePromiseOutgoing<bool, P>(false, this, &ServerPrx::_iceI_isRunning, context);
    }

    /**
     * Shows if the server currently running (accepting users).
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    isRunningAsync(::std::function<void(bool)> response,
                   ::std::function<void(::std::exception_ptr)> ex = nullptr,
                   ::std::function<void(bool)> sent = nullptr,
                   const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<bool>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_isRunning, context);
    }

    /// \cond INTERNAL
    void _iceI_isRunning(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<bool>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Start server.
     * @param context The Context map to send with the invocation.
     */
    void start(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_start, context).get();
    }

    /**
     * Start server.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto startAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_start, context);
    }

    /**
     * Start server.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    startAsync(::std::function<void()> response,
               ::std::function<void(::std::exception_ptr)> ex = nullptr,
               ::std::function<void(bool)> sent = nullptr,
               const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_start, context);
    }

    /// \cond INTERNAL
    void _iceI_start(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Stop server.
     * Note: Server will be restarted on Murmur restart unless explicitly disabled
     * with setConf("boot", false)
     * @param context The Context map to send with the invocation.
     */
    void stop(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_stop, context).get();
    }

    /**
     * Stop server.
     * Note: Server will be restarted on Murmur restart unless explicitly disabled
     * with setConf("boot", false)
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto stopAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_stop, context);
    }

    /**
     * Stop server.
     * Note: Server will be restarted on Murmur restart unless explicitly disabled
     * with setConf("boot", false)
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    stopAsync(::std::function<void()> response,
              ::std::function<void(::std::exception_ptr)> ex = nullptr,
              ::std::function<void(bool)> sent = nullptr,
              const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_stop, context);
    }

    /// \cond INTERNAL
    void _iceI_stop(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Delete server and all it's configuration.
     * @param context The Context map to send with the invocation.
     */
    void _cpp_delete(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_delete, context).get();
    }

    /**
     * Delete server and all it's configuration.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto deleteAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_delete, context);
    }

    /**
     * Delete server and all it's configuration.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    deleteAsync(::std::function<void()> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_delete, context);
    }

    /// \cond INTERNAL
    void _iceI_delete(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Fetch the server id.
     * @param context The Context map to send with the invocation.
     * @return Unique server id.
     */
    int id(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &ServerPrx::_iceI_id, context).get();
    }

    /**
     * Fetch the server id.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto idAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &ServerPrx::_iceI_id, context);
    }

    /**
     * Fetch the server id.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    idAsync(::std::function<void(int)> response,
            ::std::function<void(::std::exception_ptr)> ex = nullptr,
            ::std::function<void(bool)> sent = nullptr,
            const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_id, context);
    }

    /// \cond INTERNAL
    void _iceI_id(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Add a callback. The callback will receive notifications about changes to users and channels.
     * @param cb Callback interface which will receive notifications.
     * @param context The Context map to send with the invocation.
     * @see removeCallback
     */
    void addCallback(const ::std::shared_ptr<ServerCallbackPrx>& cb, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_addCallback, cb, context).get();
    }

    /**
     * Add a callback. The callback will receive notifications about changes to users and channels.
     * @param cb Callback interface which will receive notifications.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see removeCallback
     */
    template<template<typename> class P = ::std::promise>
    auto addCallbackAsync(const ::std::shared_ptr<ServerCallbackPrx>& cb, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_addCallback, cb, context);
    }

    /**
     * Add a callback. The callback will receive notifications about changes to users and channels.
     * @param cb Callback interface which will receive notifications.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see removeCallback
     */
    ::std::function<void()>
    addCallbackAsync(const ::std::shared_ptr<ServerCallbackPrx>& cb,
                     ::std::function<void()> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_addCallback, cb, context);
    }

    /// \cond INTERNAL
    void _iceI_addCallback(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<ServerCallbackPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed.
     * @param context The Context map to send with the invocation.
     * @see addCallback
     */
    void removeCallback(const ::std::shared_ptr<ServerCallbackPrx>& cb, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_removeCallback, cb, context).get();
    }

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see addCallback
     */
    template<template<typename> class P = ::std::promise>
    auto removeCallbackAsync(const ::std::shared_ptr<ServerCallbackPrx>& cb, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_removeCallback, cb, context);
    }

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see addCallback
     */
    ::std::function<void()>
    removeCallbackAsync(const ::std::shared_ptr<ServerCallbackPrx>& cb,
                        ::std::function<void()> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_removeCallback, cb, context);
    }

    /// \cond INTERNAL
    void _iceI_removeCallback(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<ServerCallbackPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Set external authenticator. If set, all authentications from clients are forwarded to this
     * proxy.
     * @param auth Authenticator object to perform subsequent authentications.
     * @param context The Context map to send with the invocation.
     */
    void setAuthenticator(const ::std::shared_ptr<ServerAuthenticatorPrx>& auth, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_setAuthenticator, auth, context).get();
    }

    /**
     * Set external authenticator. If set, all authentications from clients are forwarded to this
     * proxy.
     * @param auth Authenticator object to perform subsequent authentications.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setAuthenticatorAsync(const ::std::shared_ptr<ServerAuthenticatorPrx>& auth, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_setAuthenticator, auth, context);
    }

    /**
     * Set external authenticator. If set, all authentications from clients are forwarded to this
     * proxy.
     * @param auth Authenticator object to perform subsequent authentications.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setAuthenticatorAsync(const ::std::shared_ptr<ServerAuthenticatorPrx>& auth,
                          ::std::function<void()> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_setAuthenticator, auth, context);
    }

    /// \cond INTERNAL
    void _iceI_setAuthenticator(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<ServerAuthenticatorPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Retrieve configuration item.
     * @param key Configuration key.
     * @param context The Context map to send with the invocation.
     * @return Configuration value. If this is empty, see {@link Meta.getDefaultConf}
     */
    ::std::string getConf(const ::std::string& key, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::string>(true, this, &ServerPrx::_iceI_getConf, key, context).get();
    }

    /**
     * Retrieve configuration item.
     * @param key Configuration key.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getConfAsync(const ::std::string& key, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::string>>().get_future())
    {
        return _makePromiseOutgoing<::std::string, P>(false, this, &ServerPrx::_iceI_getConf, key, context);
    }

    /**
     * Retrieve configuration item.
     * @param key Configuration key.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getConfAsync(const ::std::string& key,
                 ::std::function<void(::std::string)> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::string>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_getConf, key, context);
    }

    /// \cond INTERNAL
    void _iceI_getConf(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Retrieve all configuration items.
     * @param context The Context map to send with the invocation.
     * @return All configured values. If a value isn't set here, the value from {@link Meta.getDefaultConf} is used.
     */
    ConfigMap getAllConf(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::MumbleServer::ConfigMap>(true, this, &ServerPrx::_iceI_getAllConf, context).get();
    }

    /**
     * Retrieve all configuration items.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getAllConfAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::MumbleServer::ConfigMap>>().get_future())
    {
        return _makePromiseOutgoing<::MumbleServer::ConfigMap, P>(false, this, &ServerPrx::_iceI_getAllConf, context);
    }

    /**
     * Retrieve all configuration items.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getAllConfAsync(::std::function<void(::MumbleServer::ConfigMap)> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::MumbleServer::ConfigMap>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_getAllConf, context);
    }

    /// \cond INTERNAL
    void _iceI_getAllConf(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::MumbleServer::ConfigMap>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Set a configuration item.
     * @param key Configuration key.
     * @param value Configuration value.
     * @param context The Context map to send with the invocation.
     */
    void setConf(const ::std::string& key, const ::std::string& value, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_setConf, key, value, context).get();
    }

    /**
     * Set a configuration item.
     * @param key Configuration key.
     * @param value Configuration value.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setConfAsync(const ::std::string& key, const ::std::string& value, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_setConf, key, value, context);
    }

    /**
     * Set a configuration item.
     * @param key Configuration key.
     * @param value Configuration value.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setConfAsync(const ::std::string& key, const ::std::string& value,
                 ::std::function<void()> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_setConf, key, value, context);
    }

    /// \cond INTERNAL
    void _iceI_setConf(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Set superuser password. This is just a convenience for using {@link updateRegistration} on user id 0.
     * @param pw Password.
     * @param context The Context map to send with the invocation.
     */
    void setSuperuserPassword(const ::std::string& pw, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_setSuperuserPassword, pw, context).get();
    }

    /**
     * Set superuser password. This is just a convenience for using {@link updateRegistration} on user id 0.
     * @param pw Password.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setSuperuserPasswordAsync(const ::std::string& pw, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_setSuperuserPassword, pw, context);
    }

    /**
     * Set superuser password. This is just a convenience for using {@link updateRegistration} on user id 0.
     * @param pw Password.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setSuperuserPasswordAsync(const ::std::string& pw,
                              ::std::function<void()> response,
                              ::std::function<void(::std::exception_ptr)> ex = nullptr,
                              ::std::function<void(bool)> sent = nullptr,
                              const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_setSuperuserPassword, pw, context);
    }

    /// \cond INTERNAL
    void _iceI_setSuperuserPassword(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Fetch log entries.
     * @param first Lowest numbered entry to fetch. 0 is the most recent item.
     * @param last Last entry to fetch.
     * @param context The Context map to send with the invocation.
     * @return List of log entries.
     */
    LogList getLog(int first, int last, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::MumbleServer::LogList>(true, this, &ServerPrx::_iceI_getLog, first, last, context).get();
    }

    /**
     * Fetch log entries.
     * @param first Lowest numbered entry to fetch. 0 is the most recent item.
     * @param last Last entry to fetch.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getLogAsync(int first, int last, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::MumbleServer::LogList>>().get_future())
    {
        return _makePromiseOutgoing<::MumbleServer::LogList, P>(false, this, &ServerPrx::_iceI_getLog, first, last, context);
    }

    /**
     * Fetch log entries.
     * @param first Lowest numbered entry to fetch. 0 is the most recent item.
     * @param last Last entry to fetch.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getLogAsync(int first, int last,
                ::std::function<void(::MumbleServer::LogList)> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::MumbleServer::LogList>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_getLog, first, last, context);
    }

    /// \cond INTERNAL
    void _iceI_getLog(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::MumbleServer::LogList>>&, int, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Fetch length of log
     * @param context The Context map to send with the invocation.
     * @return Number of entries in log
     */
    int getLogLen(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &ServerPrx::_iceI_getLogLen, context).get();
    }

    /**
     * Fetch length of log
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getLogLenAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &ServerPrx::_iceI_getLogLen, context);
    }

    /**
     * Fetch length of log
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getLogLenAsync(::std::function<void(int)> response,
                   ::std::function<void(::std::exception_ptr)> ex = nullptr,
                   ::std::function<void(bool)> sent = nullptr,
                   const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_getLogLen, context);
    }

    /// \cond INTERNAL
    void _iceI_getLogLen(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Fetch all users. This returns all currently connected users on the server.
     * @param context The Context map to send with the invocation.
     * @return List of connected users.
     * @see getState
     */
    UserMap getUsers(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::MumbleServer::UserMap>(true, this, &ServerPrx::_iceI_getUsers, context).get();
    }

    /**
     * Fetch all users. This returns all currently connected users on the server.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see getState
     */
    template<template<typename> class P = ::std::promise>
    auto getUsersAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::MumbleServer::UserMap>>().get_future())
    {
        return _makePromiseOutgoing<::MumbleServer::UserMap, P>(false, this, &ServerPrx::_iceI_getUsers, context);
    }

    /**
     * Fetch all users. This returns all currently connected users on the server.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see getState
     */
    ::std::function<void()>
    getUsersAsync(::std::function<void(::MumbleServer::UserMap)> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::MumbleServer::UserMap>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_getUsers, context);
    }

    /// \cond INTERNAL
    void _iceI_getUsers(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::MumbleServer::UserMap>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Fetch all channels. This returns all defined channels on the server. The root channel is always channel 0.
     * @param context The Context map to send with the invocation.
     * @return List of defined channels.
     * @see getChannelState
     */
    ChannelMap getChannels(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::MumbleServer::ChannelMap>(true, this, &ServerPrx::_iceI_getChannels, context).get();
    }

    /**
     * Fetch all channels. This returns all defined channels on the server. The root channel is always channel 0.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see getChannelState
     */
    template<template<typename> class P = ::std::promise>
    auto getChannelsAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::MumbleServer::ChannelMap>>().get_future())
    {
        return _makePromiseOutgoing<::MumbleServer::ChannelMap, P>(false, this, &ServerPrx::_iceI_getChannels, context);
    }

    /**
     * Fetch all channels. This returns all defined channels on the server. The root channel is always channel 0.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see getChannelState
     */
    ::std::function<void()>
    getChannelsAsync(::std::function<void(::MumbleServer::ChannelMap)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::MumbleServer::ChannelMap>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_getChannels, context);
    }

    /// \cond INTERNAL
    void _iceI_getChannels(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::MumbleServer::ChannelMap>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Fetch certificate of user. This returns the complete certificate chain of a user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param context The Context map to send with the invocation.
     * @return Certificate list of user.
     */
    CertificateList getCertificateList(int session, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::MumbleServer::CertificateList>(true, this, &ServerPrx::_iceI_getCertificateList, session, context).get();
    }

    /**
     * Fetch certificate of user. This returns the complete certificate chain of a user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getCertificateListAsync(int session, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::MumbleServer::CertificateList>>().get_future())
    {
        return _makePromiseOutgoing<::MumbleServer::CertificateList, P>(false, this, &ServerPrx::_iceI_getCertificateList, session, context);
    }

    /**
     * Fetch certificate of user. This returns the complete certificate chain of a user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getCertificateListAsync(int session,
                            ::std::function<void(::MumbleServer::CertificateList)> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::MumbleServer::CertificateList>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_getCertificateList, session, context);
    }

    /// \cond INTERNAL
    void _iceI_getCertificateList(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::MumbleServer::CertificateList>>&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Fetch all channels and connected users as a tree. This retrieves an easy-to-use representation of the server
     * as a tree. This is primarily used for viewing the state of the server on a webpage.
     * @param context The Context map to send with the invocation.
     * @return Recursive tree of all channels and connected users.
     */
    ::std::shared_ptr<Tree> getTree(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::MumbleServer::Tree>>(true, this, &ServerPrx::_iceI_getTree, context).get();
    }

    /**
     * Fetch all channels and connected users as a tree. This retrieves an easy-to-use representation of the server
     * as a tree. This is primarily used for viewing the state of the server on a webpage.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getTreeAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::MumbleServer::Tree>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::MumbleServer::Tree>, P>(false, this, &ServerPrx::_iceI_getTree, context);
    }

    /**
     * Fetch all channels and connected users as a tree. This retrieves an easy-to-use representation of the server
     * as a tree. This is primarily used for viewing the state of the server on a webpage.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getTreeAsync(::std::function<void(::std::shared_ptr<::MumbleServer::Tree>)> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::MumbleServer::Tree>>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_getTree, context);
    }

    /// \cond INTERNAL
    void _iceI_getTree(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::MumbleServer::Tree>>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Fetch all current IP bans on the server.
     * @param context The Context map to send with the invocation.
     * @return List of bans.
     */
    BanList getBans(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::MumbleServer::BanList>(true, this, &ServerPrx::_iceI_getBans, context).get();
    }

    /**
     * Fetch all current IP bans on the server.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getBansAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::MumbleServer::BanList>>().get_future())
    {
        return _makePromiseOutgoing<::MumbleServer::BanList, P>(false, this, &ServerPrx::_iceI_getBans, context);
    }

    /**
     * Fetch all current IP bans on the server.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getBansAsync(::std::function<void(::MumbleServer::BanList)> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::MumbleServer::BanList>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_getBans, context);
    }

    /// \cond INTERNAL
    void _iceI_getBans(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::MumbleServer::BanList>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Set all current IP bans on the server. This will replace any bans already present, so if you want to add a ban, be sure to call {@link getBans} and then
     * append to the returned list before calling this method.
     * @param bans List of bans.
     * @param context The Context map to send with the invocation.
     */
    void setBans(const BanList& bans, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_setBans, bans, context).get();
    }

    /**
     * Set all current IP bans on the server. This will replace any bans already present, so if you want to add a ban, be sure to call {@link getBans} and then
     * append to the returned list before calling this method.
     * @param bans List of bans.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setBansAsync(const BanList& bans, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_setBans, bans, context);
    }

    /**
     * Set all current IP bans on the server. This will replace any bans already present, so if you want to add a ban, be sure to call {@link getBans} and then
     * append to the returned list before calling this method.
     * @param bans List of bans.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setBansAsync(const BanList& bans,
                 ::std::function<void()> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_setBans, bans, context);
    }

    /// \cond INTERNAL
    void _iceI_setBans(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const BanList&, const ::Ice::Context&);
    /// \endcond

    /**
     * Kick a user. The user is not banned, and is free to rejoin the server.
     * @param session Connection ID of user. See {@link User.session}.
     * @param reason Text message to show when user is kicked.
     * @param context The Context map to send with the invocation.
     */
    void kickUser(int session, const ::std::string& reason, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_kickUser, session, reason, context).get();
    }

    /**
     * Kick a user. The user is not banned, and is free to rejoin the server.
     * @param session Connection ID of user. See {@link User.session}.
     * @param reason Text message to show when user is kicked.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto kickUserAsync(int session, const ::std::string& reason, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_kickUser, session, reason, context);
    }

    /**
     * Kick a user. The user is not banned, and is free to rejoin the server.
     * @param session Connection ID of user. See {@link User.session}.
     * @param reason Text message to show when user is kicked.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    kickUserAsync(int session, const ::std::string& reason,
                  ::std::function<void()> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_kickUser, session, reason, context);
    }

    /// \cond INTERNAL
    void _iceI_kickUser(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get state of a single connected user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param context The Context map to send with the invocation.
     * @return State of connected user.
     * @see setState
     * @see getUsers
     */
    User getState(int session, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::MumbleServer::User>(true, this, &ServerPrx::_iceI_getState, session, context).get();
    }

    /**
     * Get state of a single connected user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see setState
     * @see getUsers
     */
    template<template<typename> class P = ::std::promise>
    auto getStateAsync(int session, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::MumbleServer::User>>().get_future())
    {
        return _makePromiseOutgoing<::MumbleServer::User, P>(false, this, &ServerPrx::_iceI_getState, session, context);
    }

    /**
     * Get state of a single connected user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see setState
     * @see getUsers
     */
    ::std::function<void()>
    getStateAsync(int session,
                  ::std::function<void(::MumbleServer::User)> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::MumbleServer::User>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_getState, session, context);
    }

    /// \cond INTERNAL
    void _iceI_getState(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::MumbleServer::User>>&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Set user state. You can use this to move, mute and deafen users.
     * @param state User state to set.
     * @param context The Context map to send with the invocation.
     * @see getState
     */
    void setState(const User& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_setState, state, context).get();
    }

    /**
     * Set user state. You can use this to move, mute and deafen users.
     * @param state User state to set.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see getState
     */
    template<template<typename> class P = ::std::promise>
    auto setStateAsync(const User& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_setState, state, context);
    }

    /**
     * Set user state. You can use this to move, mute and deafen users.
     * @param state User state to set.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see getState
     */
    ::std::function<void()>
    setStateAsync(const User& state,
                  ::std::function<void()> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_setState, state, context);
    }

    /// \cond INTERNAL
    void _iceI_setState(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const User&, const ::Ice::Context&);
    /// \endcond

    /**
     * Send text message to a single user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param text Message to send.
     * @param context The Context map to send with the invocation.
     * @see sendMessageChannel
     */
    void sendMessage(int session, const ::std::string& text, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_sendMessage, session, text, context).get();
    }

    /**
     * Send text message to a single user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param text Message to send.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see sendMessageChannel
     */
    template<template<typename> class P = ::std::promise>
    auto sendMessageAsync(int session, const ::std::string& text, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_sendMessage, session, text, context);
    }

    /**
     * Send text message to a single user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param text Message to send.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see sendMessageChannel
     */
    ::std::function<void()>
    sendMessageAsync(int session, const ::std::string& text,
                     ::std::function<void()> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_sendMessage, session, text, context);
    }

    /// \cond INTERNAL
    void _iceI_sendMessage(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Check if user is permitted to perform action.
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param perm Permission bits to check.
     * @param context The Context map to send with the invocation.
     * @return true if any of the permissions in perm were set for the user.
     */
    bool hasPermission(int session, int channelid, int perm, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<bool>(true, this, &ServerPrx::_iceI_hasPermission, session, channelid, perm, context).get();
    }

    /**
     * Check if user is permitted to perform action.
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param perm Permission bits to check.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto hasPermissionAsync(int session, int channelid, int perm, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<bool>>().get_future())
    {
        return _makePromiseOutgoing<bool, P>(false, this, &ServerPrx::_iceI_hasPermission, session, channelid, perm, context);
    }

    /**
     * Check if user is permitted to perform action.
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param perm Permission bits to check.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    hasPermissionAsync(int session, int channelid, int perm,
                       ::std::function<void(bool)> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<bool>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_hasPermission, session, channelid, perm, context);
    }

    /// \cond INTERNAL
    void _iceI_hasPermission(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<bool>>&, int, int, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Return users effective permissions
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @return bitfield of allowed actions
     */
    int effectivePermissions(int session, int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &ServerPrx::_iceI_effectivePermissions, session, channelid, context).get();
    }

    /**
     * Return users effective permissions
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto effectivePermissionsAsync(int session, int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &ServerPrx::_iceI_effectivePermissions, session, channelid, context);
    }

    /**
     * Return users effective permissions
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    effectivePermissionsAsync(int session, int channelid,
                              ::std::function<void(int)> response,
                              ::std::function<void(::std::exception_ptr)> ex = nullptr,
                              ::std::function<void(bool)> sent = nullptr,
                              const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_effectivePermissions, session, channelid, context);
    }

    /// \cond INTERNAL
    void _iceI_effectivePermissions(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, int, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Add a context callback. This is done per user, and will add a context menu action for the user.
     * @param session Session of user which should receive context entry.
     * @param action Action string, a unique name to associate with the action.
     * @param text Name of action shown to user.
     * @param cb Callback interface which will receive notifications.
     * @param ctx Context this should be used in. Needs to be one or a combination of {@link ContextServer}, {@link ContextChannel} and {@link ContextUser}.
     * @param context The Context map to send with the invocation.
     * @see removeContextCallback
     */
    void addContextCallback(int session, const ::std::string& action, const ::std::string& text, const ::std::shared_ptr<ServerContextCallbackPrx>& cb, int ctx, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_addContextCallback, session, action, text, cb, ctx, context).get();
    }

    /**
     * Add a context callback. This is done per user, and will add a context menu action for the user.
     * @param session Session of user which should receive context entry.
     * @param action Action string, a unique name to associate with the action.
     * @param text Name of action shown to user.
     * @param cb Callback interface which will receive notifications.
     * @param ctx Context this should be used in. Needs to be one or a combination of {@link ContextServer}, {@link ContextChannel} and {@link ContextUser}.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see removeContextCallback
     */
    template<template<typename> class P = ::std::promise>
    auto addContextCallbackAsync(int session, const ::std::string& action, const ::std::string& text, const ::std::shared_ptr<ServerContextCallbackPrx>& cb, int ctx, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_addContextCallback, session, action, text, cb, ctx, context);
    }

    /**
     * Add a context callback. This is done per user, and will add a context menu action for the user.
     * @param session Session of user which should receive context entry.
     * @param action Action string, a unique name to associate with the action.
     * @param text Name of action shown to user.
     * @param cb Callback interface which will receive notifications.
     * @param ctx Context this should be used in. Needs to be one or a combination of {@link ContextServer}, {@link ContextChannel} and {@link ContextUser}.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see removeContextCallback
     */
    ::std::function<void()>
    addContextCallbackAsync(int session, const ::std::string& action, const ::std::string& text, const ::std::shared_ptr<ServerContextCallbackPrx>& cb, int ctx,
                            ::std::function<void()> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_addContextCallback, session, action, text, cb, ctx, context);
    }

    /// \cond INTERNAL
    void _iceI_addContextCallback(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const ::std::string&, const ::std::string&, const ::std::shared_ptr<ServerContextCallbackPrx>&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed. This callback will be removed from all from all users.
     * @param context The Context map to send with the invocation.
     * @see addContextCallback
     */
    void removeContextCallback(const ::std::shared_ptr<ServerContextCallbackPrx>& cb, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_removeContextCallback, cb, context).get();
    }

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed. This callback will be removed from all from all users.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see addContextCallback
     */
    template<template<typename> class P = ::std::promise>
    auto removeContextCallbackAsync(const ::std::shared_ptr<ServerContextCallbackPrx>& cb, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_removeContextCallback, cb, context);
    }

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed. This callback will be removed from all from all users.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see addContextCallback
     */
    ::std::function<void()>
    removeContextCallbackAsync(const ::std::shared_ptr<ServerContextCallbackPrx>& cb,
                               ::std::function<void()> response,
                               ::std::function<void(::std::exception_ptr)> ex = nullptr,
                               ::std::function<void(bool)> sent = nullptr,
                               const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_removeContextCallback, cb, context);
    }

    /// \cond INTERNAL
    void _iceI_removeContextCallback(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<ServerContextCallbackPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get state of single channel.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @return State of channel.
     * @see setChannelState
     * @see getChannels
     */
    Channel getChannelState(int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::MumbleServer::Channel>(true, this, &ServerPrx::_iceI_getChannelState, channelid, context).get();
    }

    /**
     * Get state of single channel.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see setChannelState
     * @see getChannels
     */
    template<template<typename> class P = ::std::promise>
    auto getChannelStateAsync(int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::MumbleServer::Channel>>().get_future())
    {
        return _makePromiseOutgoing<::MumbleServer::Channel, P>(false, this, &ServerPrx::_iceI_getChannelState, channelid, context);
    }

    /**
     * Get state of single channel.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see setChannelState
     * @see getChannels
     */
    ::std::function<void()>
    getChannelStateAsync(int channelid,
                         ::std::function<void(::MumbleServer::Channel)> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::MumbleServer::Channel>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_getChannelState, channelid, context);
    }

    /// \cond INTERNAL
    void _iceI_getChannelState(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::MumbleServer::Channel>>&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Set state of a single channel. You can use this to move or relink channels.
     * @param state Channel state to set.
     * @param context The Context map to send with the invocation.
     * @see getChannelState
     */
    void setChannelState(const Channel& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_setChannelState, state, context).get();
    }

    /**
     * Set state of a single channel. You can use this to move or relink channels.
     * @param state Channel state to set.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see getChannelState
     */
    template<template<typename> class P = ::std::promise>
    auto setChannelStateAsync(const Channel& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_setChannelState, state, context);
    }

    /**
     * Set state of a single channel. You can use this to move or relink channels.
     * @param state Channel state to set.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see getChannelState
     */
    ::std::function<void()>
    setChannelStateAsync(const Channel& state,
                         ::std::function<void()> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_setChannelState, state, context);
    }

    /// \cond INTERNAL
    void _iceI_setChannelState(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const Channel&, const ::Ice::Context&);
    /// \endcond

    /**
     * Remove a channel and all its subchannels.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     */
    void removeChannel(int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_removeChannel, channelid, context).get();
    }

    /**
     * Remove a channel and all its subchannels.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto removeChannelAsync(int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_removeChannel, channelid, context);
    }

    /**
     * Remove a channel and all its subchannels.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    removeChannelAsync(int channelid,
                       ::std::function<void()> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_removeChannel, channelid, context);
    }

    /// \cond INTERNAL
    void _iceI_removeChannel(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Add a new channel.
     * @param name Name of new channel.
     * @param parent Channel ID of parent channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @return ID of newly created channel.
     */
    int addChannel(const ::std::string& name, int parent, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &ServerPrx::_iceI_addChannel, name, parent, context).get();
    }

    /**
     * Add a new channel.
     * @param name Name of new channel.
     * @param parent Channel ID of parent channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto addChannelAsync(const ::std::string& name, int parent, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &ServerPrx::_iceI_addChannel, name, parent, context);
    }

    /**
     * Add a new channel.
     * @param name Name of new channel.
     * @param parent Channel ID of parent channel. See {@link Channel.id}.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    addChannelAsync(const ::std::string& name, int parent,
                    ::std::function<void(int)> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_addChannel, name, parent, context);
    }

    /// \cond INTERNAL
    void _iceI_addChannel(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::std::string&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Send text message to channel or a tree of channels.
     * @param channelid Channel ID of channel to send to. See {@link Channel.id}.
     * @param tree If true, the message will be sent to the channel and all its subchannels.
     * @param text Message to send.
     * @param context The Context map to send with the invocation.
     * @see sendMessage
     */
    void sendMessageChannel(int channelid, bool tree, const ::std::string& text, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_sendMessageChannel, channelid, tree, text, context).get();
    }

    /**
     * Send text message to channel or a tree of channels.
     * @param channelid Channel ID of channel to send to. See {@link Channel.id}.
     * @param tree If true, the message will be sent to the channel and all its subchannels.
     * @param text Message to send.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see sendMessage
     */
    template<template<typename> class P = ::std::promise>
    auto sendMessageChannelAsync(int channelid, bool tree, const ::std::string& text, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_sendMessageChannel, channelid, tree, text, context);
    }

    /**
     * Send text message to channel or a tree of channels.
     * @param channelid Channel ID of channel to send to. See {@link Channel.id}.
     * @param tree If true, the message will be sent to the channel and all its subchannels.
     * @param text Message to send.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see sendMessage
     */
    ::std::function<void()>
    sendMessageChannelAsync(int channelid, bool tree, const ::std::string& text,
                            ::std::function<void()> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_sendMessageChannel, channelid, tree, text, context);
    }

    /// \cond INTERNAL
    void _iceI_sendMessageChannel(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, bool, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Retrieve ACLs and Groups on a channel.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param acls List of ACLs on the channel. This will include inherited ACLs.
     * @param groups List of groups on the channel. This will include inherited groups.
     * @param inherit Does this channel inherit ACLs from the parent channel?
     * @param context The Context map to send with the invocation.
     */
    void getACL(int channelid, ACLList& acls, GroupList& groups, bool& inherit, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _result = _makePromiseOutgoing<Server::GetACLResult>(true, this, &ServerPrx::_iceI_getACL, channelid, context).get();
        acls = ::std::move(_result.acls);
        groups = ::std::move(_result.groups);
        inherit = _result.inherit;
    }

    /**
     * Retrieve ACLs and Groups on a channel.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getACLAsync(int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<Server::GetACLResult>>().get_future())
    {
        return _makePromiseOutgoing<Server::GetACLResult, P>(false, this, &ServerPrx::_iceI_getACL, channelid, context);
    }

    /**
     * Retrieve ACLs and Groups on a channel.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getACLAsync(int channelid,
                ::std::function<void(::MumbleServer::ACLList, ::MumbleServer::GroupList, bool)> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _responseCb = [response](Server::GetACLResult&& _result)
        {
            response(::std::move(_result.acls), ::std::move(_result.groups), _result.inherit);
        };
        return _makeLamdaOutgoing<Server::GetACLResult>(std::move(_responseCb), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_getACL, channelid, context);
    }

    /// \cond INTERNAL
    void _iceI_getACL(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<Server::GetACLResult>>&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Set ACLs and Groups on a channel. Note that this will replace all existing ACLs and groups on the channel.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param acls List of ACLs on the channel.
     * @param groups List of groups on the channel.
     * @param inherit Should this channel inherit ACLs from the parent channel?
     * @param context The Context map to send with the invocation.
     */
    void setACL(int channelid, const ACLList& acls, const GroupList& groups, bool inherit, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_setACL, channelid, acls, groups, inherit, context).get();
    }

    /**
     * Set ACLs and Groups on a channel. Note that this will replace all existing ACLs and groups on the channel.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param acls List of ACLs on the channel.
     * @param groups List of groups on the channel.
     * @param inherit Should this channel inherit ACLs from the parent channel?
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setACLAsync(int channelid, const ACLList& acls, const GroupList& groups, bool inherit, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_setACL, channelid, acls, groups, inherit, context);
    }

    /**
     * Set ACLs and Groups on a channel. Note that this will replace all existing ACLs and groups on the channel.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param acls List of ACLs on the channel.
     * @param groups List of groups on the channel.
     * @param inherit Should this channel inherit ACLs from the parent channel?
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setACLAsync(int channelid, const ACLList& acls, const GroupList& groups, bool inherit,
                ::std::function<void()> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_setACL, channelid, acls, groups, inherit, context);
    }

    /// \cond INTERNAL
    void _iceI_setACL(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const ACLList&, const GroupList&, bool, const ::Ice::Context&);
    /// \endcond

    /**
     * Temporarily add a user to a group on a channel. This state is not saved, and is intended for temporary memberships.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to add to.
     * @param context The Context map to send with the invocation.
     */
    void addUserToGroup(int channelid, int session, const ::std::string& group, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_addUserToGroup, channelid, session, group, context).get();
    }

    /**
     * Temporarily add a user to a group on a channel. This state is not saved, and is intended for temporary memberships.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to add to.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto addUserToGroupAsync(int channelid, int session, const ::std::string& group, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_addUserToGroup, channelid, session, group, context);
    }

    /**
     * Temporarily add a user to a group on a channel. This state is not saved, and is intended for temporary memberships.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to add to.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    addUserToGroupAsync(int channelid, int session, const ::std::string& group,
                        ::std::function<void()> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_addUserToGroup, channelid, session, group, context);
    }

    /// \cond INTERNAL
    void _iceI_addUserToGroup(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, int, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Remove a user from a temporary group membership on a channel. This state is not saved, and is intended for temporary memberships.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to remove from.
     * @param context The Context map to send with the invocation.
     */
    void removeUserFromGroup(int channelid, int session, const ::std::string& group, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_removeUserFromGroup, channelid, session, group, context).get();
    }

    /**
     * Remove a user from a temporary group membership on a channel. This state is not saved, and is intended for temporary memberships.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to remove from.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto removeUserFromGroupAsync(int channelid, int session, const ::std::string& group, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_removeUserFromGroup, channelid, session, group, context);
    }

    /**
     * Remove a user from a temporary group membership on a channel. This state is not saved, and is intended for temporary memberships.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to remove from.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    removeUserFromGroupAsync(int channelid, int session, const ::std::string& group,
                             ::std::function<void()> response,
                             ::std::function<void(::std::exception_ptr)> ex = nullptr,
                             ::std::function<void(bool)> sent = nullptr,
                             const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_removeUserFromGroup, channelid, session, group, context);
    }

    /// \cond INTERNAL
    void _iceI_removeUserFromGroup(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, int, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Redirect whisper targets for user. If set, whenever a user tries to whisper to group "source", the whisper will be redirected to group "target".
     * To remove a redirect pass an empty target string. This is intended for context groups.
     * @param session Connection ID of user. See {@link User.session}.
     * @param source Group name to redirect from.
     * @param target Group name to redirect to.
     * @param context The Context map to send with the invocation.
     */
    void redirectWhisperGroup(int session, const ::std::string& source, const ::std::string& target, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_redirectWhisperGroup, session, source, target, context).get();
    }

    /**
     * Redirect whisper targets for user. If set, whenever a user tries to whisper to group "source", the whisper will be redirected to group "target".
     * To remove a redirect pass an empty target string. This is intended for context groups.
     * @param session Connection ID of user. See {@link User.session}.
     * @param source Group name to redirect from.
     * @param target Group name to redirect to.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto redirectWhisperGroupAsync(int session, const ::std::string& source, const ::std::string& target, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_redirectWhisperGroup, session, source, target, context);
    }

    /**
     * Redirect whisper targets for user. If set, whenever a user tries to whisper to group "source", the whisper will be redirected to group "target".
     * To remove a redirect pass an empty target string. This is intended for context groups.
     * @param session Connection ID of user. See {@link User.session}.
     * @param source Group name to redirect from.
     * @param target Group name to redirect to.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    redirectWhisperGroupAsync(int session, const ::std::string& source, const ::std::string& target,
                              ::std::function<void()> response,
                              ::std::function<void(::std::exception_ptr)> ex = nullptr,
                              ::std::function<void(bool)> sent = nullptr,
                              const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_redirectWhisperGroup, session, source, target, context);
    }

    /// \cond INTERNAL
    void _iceI_redirectWhisperGroup(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const ::std::string&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Map a list of {@link User.userid} to a matching name.
     * @param context The Context map to send with the invocation.
     * @return Matching list of names, with an empty string representing invalid or unknown ids.
     */
    NameMap getUserNames(const IdList& ids, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::MumbleServer::NameMap>(true, this, &ServerPrx::_iceI_getUserNames, ids, context).get();
    }

    /**
     * Map a list of {@link User.userid} to a matching name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getUserNamesAsync(const IdList& ids, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::MumbleServer::NameMap>>().get_future())
    {
        return _makePromiseOutgoing<::MumbleServer::NameMap, P>(false, this, &ServerPrx::_iceI_getUserNames, ids, context);
    }

    /**
     * Map a list of {@link User.userid} to a matching name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getUserNamesAsync(const IdList& ids,
                      ::std::function<void(::MumbleServer::NameMap)> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::MumbleServer::NameMap>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_getUserNames, ids, context);
    }

    /// \cond INTERNAL
    void _iceI_getUserNames(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::MumbleServer::NameMap>>&, const IdList&, const ::Ice::Context&);
    /// \endcond

    /**
     * Map a list of user names to a matching id.
     * @param context The Context map to send with the invocation.
     * @reuturn List of matching ids, with -1 representing invalid or unknown user names.
     */
    IdMap getUserIds(const NameList& names, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::MumbleServer::IdMap>(true, this, &ServerPrx::_iceI_getUserIds, names, context).get();
    }

    /**
     * Map a list of user names to a matching id.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @reuturn List of matching ids, with -1 representing invalid or unknown user names.
     */
    template<template<typename> class P = ::std::promise>
    auto getUserIdsAsync(const NameList& names, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::MumbleServer::IdMap>>().get_future())
    {
        return _makePromiseOutgoing<::MumbleServer::IdMap, P>(false, this, &ServerPrx::_iceI_getUserIds, names, context);
    }

    /**
     * Map a list of user names to a matching id.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @reuturn List of matching ids, with -1 representing invalid or unknown user names.
     */
    ::std::function<void()>
    getUserIdsAsync(const NameList& names,
                    ::std::function<void(::MumbleServer::IdMap)> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::MumbleServer::IdMap>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_getUserIds, names, context);
    }

    /// \cond INTERNAL
    void _iceI_getUserIds(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::MumbleServer::IdMap>>&, const NameList&, const ::Ice::Context&);
    /// \endcond

    /**
     * Register a new user.
     * @param info Information about new user. Must include at least "name".
     * @param context The Context map to send with the invocation.
     * @return The ID of the user. See {@link RegisteredUser.userid}.
     */
    int registerUser(const UserInfoMap& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &ServerPrx::_iceI_registerUser, info, context).get();
    }

    /**
     * Register a new user.
     * @param info Information about new user. Must include at least "name".
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto registerUserAsync(const UserInfoMap& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &ServerPrx::_iceI_registerUser, info, context);
    }

    /**
     * Register a new user.
     * @param info Information about new user. Must include at least "name".
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    registerUserAsync(const UserInfoMap& info,
                      ::std::function<void(int)> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_registerUser, info, context);
    }

    /// \cond INTERNAL
    void _iceI_registerUser(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const UserInfoMap&, const ::Ice::Context&);
    /// \endcond

    /**
     * Remove a user registration.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param context The Context map to send with the invocation.
     */
    void unregisterUser(int userid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_unregisterUser, userid, context).get();
    }

    /**
     * Remove a user registration.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto unregisterUserAsync(int userid, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_unregisterUser, userid, context);
    }

    /**
     * Remove a user registration.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    unregisterUserAsync(int userid,
                        ::std::function<void()> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_unregisterUser, userid, context);
    }

    /// \cond INTERNAL
    void _iceI_unregisterUser(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Update the registration for a user. You can use this to set the email or password of a user,
     * and can also use it to change the user's name.
     * @param context The Context map to send with the invocation.
     */
    void updateRegistration(int userid, const UserInfoMap& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_updateRegistration, userid, info, context).get();
    }

    /**
     * Update the registration for a user. You can use this to set the email or password of a user,
     * and can also use it to change the user's name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto updateRegistrationAsync(int userid, const UserInfoMap& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_updateRegistration, userid, info, context);
    }

    /**
     * Update the registration for a user. You can use this to set the email or password of a user,
     * and can also use it to change the user's name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    updateRegistrationAsync(int userid, const UserInfoMap& info,
                            ::std::function<void()> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_updateRegistration, userid, info, context);
    }

    /// \cond INTERNAL
    void _iceI_updateRegistration(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const UserInfoMap&, const ::Ice::Context&);
    /// \endcond

    /**
     * Fetch registration for a single user.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param context The Context map to send with the invocation.
     * @return Registration record.
     */
    UserInfoMap getRegistration(int userid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::MumbleServer::UserInfoMap>(true, this, &ServerPrx::_iceI_getRegistration, userid, context).get();
    }

    /**
     * Fetch registration for a single user.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getRegistrationAsync(int userid, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::MumbleServer::UserInfoMap>>().get_future())
    {
        return _makePromiseOutgoing<::MumbleServer::UserInfoMap, P>(false, this, &ServerPrx::_iceI_getRegistration, userid, context);
    }

    /**
     * Fetch registration for a single user.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getRegistrationAsync(int userid,
                         ::std::function<void(::MumbleServer::UserInfoMap)> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::MumbleServer::UserInfoMap>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_getRegistration, userid, context);
    }

    /// \cond INTERNAL
    void _iceI_getRegistration(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::MumbleServer::UserInfoMap>>&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Fetch a group of registered users.
     * @param filter Substring of user name. If blank, will retrieve all registered users.
     * @param context The Context map to send with the invocation.
     * @return List of registration records.
     */
    NameMap getRegisteredUsers(const ::std::string& filter, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::MumbleServer::NameMap>(true, this, &ServerPrx::_iceI_getRegisteredUsers, filter, context).get();
    }

    /**
     * Fetch a group of registered users.
     * @param filter Substring of user name. If blank, will retrieve all registered users.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getRegisteredUsersAsync(const ::std::string& filter, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::MumbleServer::NameMap>>().get_future())
    {
        return _makePromiseOutgoing<::MumbleServer::NameMap, P>(false, this, &ServerPrx::_iceI_getRegisteredUsers, filter, context);
    }

    /**
     * Fetch a group of registered users.
     * @param filter Substring of user name. If blank, will retrieve all registered users.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getRegisteredUsersAsync(const ::std::string& filter,
                            ::std::function<void(::MumbleServer::NameMap)> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::MumbleServer::NameMap>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_getRegisteredUsers, filter, context);
    }

    /// \cond INTERNAL
    void _iceI_getRegisteredUsers(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::MumbleServer::NameMap>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Verify the password of a user. You can use this to verify a user's credentials.
     * @param name User name. See {@link RegisteredUser.name}.
     * @param pw User password.
     * @param context The Context map to send with the invocation.
     * @return User ID of registered user (See {@link RegisteredUser.userid}), -1 for failed authentication or -2 for unknown usernames.
     */
    int verifyPassword(const ::std::string& name, const ::std::string& pw, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &ServerPrx::_iceI_verifyPassword, name, pw, context).get();
    }

    /**
     * Verify the password of a user. You can use this to verify a user's credentials.
     * @param name User name. See {@link RegisteredUser.name}.
     * @param pw User password.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto verifyPasswordAsync(const ::std::string& name, const ::std::string& pw, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &ServerPrx::_iceI_verifyPassword, name, pw, context);
    }

    /**
     * Verify the password of a user. You can use this to verify a user's credentials.
     * @param name User name. See {@link RegisteredUser.name}.
     * @param pw User password.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    verifyPasswordAsync(const ::std::string& name, const ::std::string& pw,
                        ::std::function<void(int)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_verifyPassword, name, pw, context);
    }

    /// \cond INTERNAL
    void _iceI_verifyPassword(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::std::string&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Fetch user texture. Textures are stored as zlib compress()ed 600x60 32-bit BGRA data.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param context The Context map to send with the invocation.
     * @return Custom texture associated with user or an empty texture.
     */
    Texture getTexture(int userid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::MumbleServer::Texture>(true, this, &ServerPrx::_iceI_getTexture, userid, context).get();
    }

    /**
     * Fetch user texture. Textures are stored as zlib compress()ed 600x60 32-bit BGRA data.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getTextureAsync(int userid, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::MumbleServer::Texture>>().get_future())
    {
        return _makePromiseOutgoing<::MumbleServer::Texture, P>(false, this, &ServerPrx::_iceI_getTexture, userid, context);
    }

    /**
     * Fetch user texture. Textures are stored as zlib compress()ed 600x60 32-bit BGRA data.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getTextureAsync(int userid,
                    ::std::function<void(::MumbleServer::Texture)> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::MumbleServer::Texture>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_getTexture, userid, context);
    }

    /// \cond INTERNAL
    void _iceI_getTexture(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::MumbleServer::Texture>>&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Set a user texture (now called avatar).
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param tex Texture (as a Byte-Array) to set for the user, or an empty texture to remove the existing texture.
     * @param context The Context map to send with the invocation.
     */
    void setTexture(int userid, const Texture& tex, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_setTexture, userid, tex, context).get();
    }

    /**
     * Set a user texture (now called avatar).
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param tex Texture (as a Byte-Array) to set for the user, or an empty texture to remove the existing texture.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setTextureAsync(int userid, const Texture& tex, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_setTexture, userid, tex, context);
    }

    /**
     * Set a user texture (now called avatar).
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param tex Texture (as a Byte-Array) to set for the user, or an empty texture to remove the existing texture.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setTextureAsync(int userid, const Texture& tex,
                    ::std::function<void()> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_setTexture, userid, tex, context);
    }

    /// \cond INTERNAL
    void _iceI_setTexture(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const Texture&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get virtual server uptime.
     * @param context The Context map to send with the invocation.
     * @return Uptime of the virtual server in seconds
     */
    int getUptime(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &ServerPrx::_iceI_getUptime, context).get();
    }

    /**
     * Get virtual server uptime.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getUptimeAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &ServerPrx::_iceI_getUptime, context);
    }

    /**
     * Get virtual server uptime.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getUptimeAsync(::std::function<void(int)> response,
                   ::std::function<void(::std::exception_ptr)> ex = nullptr,
                   ::std::function<void(bool)> sent = nullptr,
                   const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_getUptime, context);
    }

    /// \cond INTERNAL
    void _iceI_getUptime(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Update the server's certificate information.
     *
     * Reconfigure the running server's TLS socket with the given
     * certificate and private key.
     *
     * The certificate and and private key must be PEM formatted.
     *
     * New clients will see the new certificate.
     * Existing clients will continue to see the certificate the server
     * was using when they connected to it.
     *
     * This method throws InvalidInputDataException if any of the
     * following errors happen:
     * - Unable to decode the PEM certificate and/or private key.
     * - Unable to decrypt the private key with the given passphrase.
     * - The certificate and/or private key do not contain RSA keys.
     * - The certificate is not usable with the given private key.
     * @param context The Context map to send with the invocation.
     */
    void updateCertificate(const ::std::string& certificate, const ::std::string& privateKey, const ::std::string& passphrase, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_updateCertificate, certificate, privateKey, passphrase, context).get();
    }

    /**
     * Update the server's certificate information.
     *
     * Reconfigure the running server's TLS socket with the given
     * certificate and private key.
     *
     * The certificate and and private key must be PEM formatted.
     *
     * New clients will see the new certificate.
     * Existing clients will continue to see the certificate the server
     * was using when they connected to it.
     *
     * This method throws InvalidInputDataException if any of the
     * following errors happen:
     * - Unable to decode the PEM certificate and/or private key.
     * - Unable to decrypt the private key with the given passphrase.
     * - The certificate and/or private key do not contain RSA keys.
     * - The certificate is not usable with the given private key.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto updateCertificateAsync(const ::std::string& certificate, const ::std::string& privateKey, const ::std::string& passphrase, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_updateCertificate, certificate, privateKey, passphrase, context);
    }

    /**
     * Update the server's certificate information.
     *
     * Reconfigure the running server's TLS socket with the given
     * certificate and private key.
     *
     * The certificate and and private key must be PEM formatted.
     *
     * New clients will see the new certificate.
     * Existing clients will continue to see the certificate the server
     * was using when they connected to it.
     *
     * This method throws InvalidInputDataException if any of the
     * following errors happen:
     * - Unable to decode the PEM certificate and/or private key.
     * - Unable to decrypt the private key with the given passphrase.
     * - The certificate and/or private key do not contain RSA keys.
     * - The certificate is not usable with the given private key.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    updateCertificateAsync(const ::std::string& certificate, const ::std::string& privateKey, const ::std::string& passphrase,
                           ::std::function<void()> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_updateCertificate, certificate, privateKey, passphrase, context);
    }

    /// \cond INTERNAL
    void _iceI_updateCertificate(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::std::string&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Makes the given user start listening to the given channel.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     */
    void startListening(int userid, int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_startListening, userid, channelid, context).get();
    }

    /**
     * Makes the given user start listening to the given channel.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto startListeningAsync(int userid, int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_startListening, userid, channelid, context);
    }

    /**
     * Makes the given user start listening to the given channel.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    startListeningAsync(int userid, int channelid,
                        ::std::function<void()> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_startListening, userid, channelid, context);
    }

    /// \cond INTERNAL
    void _iceI_startListening(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Makes the given user stop listening to the given channel.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     */
    void stopListening(int userid, int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_stopListening, userid, channelid, context).get();
    }

    /**
     * Makes the given user stop listening to the given channel.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto stopListeningAsync(int userid, int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_stopListening, userid, channelid, context);
    }

    /**
     * Makes the given user stop listening to the given channel.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    stopListeningAsync(int userid, int channelid,
                       ::std::function<void()> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_stopListening, userid, channelid, context);
    }

    /// \cond INTERNAL
    void _iceI_stopListening(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, int, const ::Ice::Context&);
    /// \endcond

    /**
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     * @return s Whether the given user is currently listening to the given channel
     */
    bool isListening(int userid, int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<bool>(true, this, &ServerPrx::_iceI_isListening, userid, channelid, context).get();
    }

    /**
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto isListeningAsync(int userid, int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<bool>>().get_future())
    {
        return _makePromiseOutgoing<bool, P>(false, this, &ServerPrx::_iceI_isListening, userid, channelid, context);
    }

    /**
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    isListeningAsync(int userid, int channelid,
                     ::std::function<void(bool)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<bool>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_isListening, userid, channelid, context);
    }

    /// \cond INTERNAL
    void _iceI_isListening(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<bool>>&, int, int, const ::Ice::Context&);
    /// \endcond

    /**
     * @param userid The ID of the user
     * @param context The Context map to send with the invocation.
     * @return s An ID-list of channels the given user is listening to
     */
    IntList getListeningChannels(int userid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::MumbleServer::IntList>(true, this, &ServerPrx::_iceI_getListeningChannels, userid, context).get();
    }

    /**
     * @param userid The ID of the user
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getListeningChannelsAsync(int userid, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::MumbleServer::IntList>>().get_future())
    {
        return _makePromiseOutgoing<::MumbleServer::IntList, P>(false, this, &ServerPrx::_iceI_getListeningChannels, userid, context);
    }

    /**
     * @param userid The ID of the user
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getListeningChannelsAsync(int userid,
                              ::std::function<void(::MumbleServer::IntList)> response,
                              ::std::function<void(::std::exception_ptr)> ex = nullptr,
                              ::std::function<void(bool)> sent = nullptr,
                              const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::MumbleServer::IntList>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_getListeningChannels, userid, context);
    }

    /// \cond INTERNAL
    void _iceI_getListeningChannels(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::MumbleServer::IntList>>&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     * @return s An ID-list of users listening to the given channel
     */
    IntList getListeningUsers(int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::MumbleServer::IntList>(true, this, &ServerPrx::_iceI_getListeningUsers, channelid, context).get();
    }

    /**
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getListeningUsersAsync(int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::MumbleServer::IntList>>().get_future())
    {
        return _makePromiseOutgoing<::MumbleServer::IntList, P>(false, this, &ServerPrx::_iceI_getListeningUsers, channelid, context);
    }

    /**
     * @param channelid The ID of the channel
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getListeningUsersAsync(int channelid,
                           ::std::function<void(::MumbleServer::IntList)> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::MumbleServer::IntList>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_getListeningUsers, channelid, context);
    }

    /// \cond INTERNAL
    void _iceI_getListeningUsers(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::MumbleServer::IntList>>&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param context The Context map to send with the invocation.
     * @return s The volume adjustment set for a listener of the given user in the given channel
     */
    float getListenerVolumeAdjustment(int channelid, int userid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<float>(true, this, &ServerPrx::_iceI_getListenerVolumeAdjustment, channelid, userid, context).get();
    }

    /**
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getListenerVolumeAdjustmentAsync(int channelid, int userid, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<float>>().get_future())
    {
        return _makePromiseOutgoing<float, P>(false, this, &ServerPrx::_iceI_getListenerVolumeAdjustment, channelid, userid, context);
    }

    /**
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getListenerVolumeAdjustmentAsync(int channelid, int userid,
                                     ::std::function<void(float)> response,
                                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                     ::std::function<void(bool)> sent = nullptr,
                                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<float>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_getListenerVolumeAdjustment, channelid, userid, context);
    }

    /// \cond INTERNAL
    void _iceI_getListenerVolumeAdjustment(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<float>>&, int, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Sets the volume adjustment set for a listener of the given user in the given channel
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param context The Context map to send with the invocation.
     */
    void setListenerVolumeAdjustment(int channelid, int userid, float volumeAdjustment, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_setListenerVolumeAdjustment, channelid, userid, volumeAdjustment, context).get();
    }

    /**
     * Sets the volume adjustment set for a listener of the given user in the given channel
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setListenerVolumeAdjustmentAsync(int channelid, int userid, float volumeAdjustment, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_setListenerVolumeAdjustment, channelid, userid, volumeAdjustment, context);
    }

    /**
     * Sets the volume adjustment set for a listener of the given user in the given channel
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setListenerVolumeAdjustmentAsync(int channelid, int userid, float volumeAdjustment,
                                     ::std::function<void()> response,
                                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                     ::std::function<void(bool)> sent = nullptr,
                                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_setListenerVolumeAdjustment, channelid, userid, volumeAdjustment, context);
    }

    /// \cond INTERNAL
    void _iceI_setListenerVolumeAdjustment(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, int, float, const ::Ice::Context&);
    /// \endcond

    /**
     * @param receiverUserIDs list of IDs of the users the message shall be sent to
     * @param context The Context map to send with the invocation.
     */
    void sendWelcomeMessage(const IdList& receiverUserIDs, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_sendWelcomeMessage, receiverUserIDs, context).get();
    }

    /**
     * @param receiverUserIDs list of IDs of the users the message shall be sent to
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto sendWelcomeMessageAsync(const IdList& receiverUserIDs, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_sendWelcomeMessage, receiverUserIDs, context);
    }

    /**
     * @param receiverUserIDs list of IDs of the users the message shall be sent to
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    sendWelcomeMessageAsync(const IdList& receiverUserIDs,
                            ::std::function<void()> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::ServerPrx::_iceI_sendWelcomeMessage, receiverUserIDs, context);
    }

    /// \cond INTERNAL
    void _iceI_sendWelcomeMessage(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const IdList&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    ServerPrx() = default;
    friend ::std::shared_ptr<ServerPrx> IceInternal::createProxy<ServerPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * Callback interface for Meta. You can supply an implementation of this to receive notifications
 * when servers are stopped or started.
 * If an added callback ever throws an exception or goes away, it will be automatically removed.
 * Please note that all callbacks are done asynchronously; murmur does not wait for the callback to
 * complete before continuing processing.
 * @see ServerCallback
 * @see Meta.addCallback
 */
class MetaCallbackPrx : public virtual ::Ice::Proxy<MetaCallbackPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Called when a server is started. The server is up and running when this event is sent, so all methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param context The Context map to send with the invocation.
     */
    void started(const ::std::shared_ptr<ServerPrx>& srv, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &MetaCallbackPrx::_iceI_started, srv, context).get();
    }

    /**
     * Called when a server is started. The server is up and running when this event is sent, so all methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto startedAsync(const ::std::shared_ptr<ServerPrx>& srv, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &MetaCallbackPrx::_iceI_started, srv, context);
    }

    /**
     * Called when a server is started. The server is up and running when this event is sent, so all methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    startedAsync(const ::std::shared_ptr<ServerPrx>& srv,
                 ::std::function<void()> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::MetaCallbackPrx::_iceI_started, srv, context);
    }

    /// \cond INTERNAL
    void _iceI_started(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<ServerPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Called when a server is stopped. The server is already stopped when this event is sent, so no methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param context The Context map to send with the invocation.
     */
    void stopped(const ::std::shared_ptr<ServerPrx>& srv, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &MetaCallbackPrx::_iceI_stopped, srv, context).get();
    }

    /**
     * Called when a server is stopped. The server is already stopped when this event is sent, so no methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto stoppedAsync(const ::std::shared_ptr<ServerPrx>& srv, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &MetaCallbackPrx::_iceI_stopped, srv, context);
    }

    /**
     * Called when a server is stopped. The server is already stopped when this event is sent, so no methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    stoppedAsync(const ::std::shared_ptr<ServerPrx>& srv,
                 ::std::function<void()> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::MetaCallbackPrx::_iceI_stopped, srv, context);
    }

    /// \cond INTERNAL
    void _iceI_stopped(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<ServerPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    MetaCallbackPrx() = default;
    friend ::std::shared_ptr<MetaCallbackPrx> IceInternal::createProxy<MetaCallbackPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * This is the meta interface. It is primarily used for retrieving the {@link Server} interfaces for each individual server.
 */
class MetaPrx : public virtual ::Ice::Proxy<MetaPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Fetch interface to specific server.
     * @param id Server ID. See {@link Server.getId}.
     * @param context The Context map to send with the invocation.
     * @return Interface for specified server, or a null proxy if id is invalid.
     */
    ::std::shared_ptr<ServerPrx> getServer(int id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::MumbleServer::ServerPrx>>(true, this, &MetaPrx::_iceI_getServer, id, context).get();
    }

    /**
     * Fetch interface to specific server.
     * @param id Server ID. See {@link Server.getId}.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getServerAsync(int id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::MumbleServer::ServerPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::MumbleServer::ServerPrx>, P>(false, this, &MetaPrx::_iceI_getServer, id, context);
    }

    /**
     * Fetch interface to specific server.
     * @param id Server ID. See {@link Server.getId}.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getServerAsync(int id,
                   ::std::function<void(::std::shared_ptr<::MumbleServer::ServerPrx>)> response,
                   ::std::function<void(::std::exception_ptr)> ex = nullptr,
                   ::std::function<void(bool)> sent = nullptr,
                   const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::MumbleServer::ServerPrx>>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::MetaPrx::_iceI_getServer, id, context);
    }

    /// \cond INTERNAL
    void _iceI_getServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::MumbleServer::ServerPrx>>>&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Create a new server. Call {@link Server.getId} on the returned interface to find it's ID.
     * @param context The Context map to send with the invocation.
     * @return Interface for new server.
     */
    ::std::shared_ptr<ServerPrx> newServer(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::MumbleServer::ServerPrx>>(true, this, &MetaPrx::_iceI_newServer, context).get();
    }

    /**
     * Create a new server. Call {@link Server.getId} on the returned interface to find it's ID.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto newServerAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::MumbleServer::ServerPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::MumbleServer::ServerPrx>, P>(false, this, &MetaPrx::_iceI_newServer, context);
    }

    /**
     * Create a new server. Call {@link Server.getId} on the returned interface to find it's ID.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    newServerAsync(::std::function<void(::std::shared_ptr<::MumbleServer::ServerPrx>)> response,
                   ::std::function<void(::std::exception_ptr)> ex = nullptr,
                   ::std::function<void(bool)> sent = nullptr,
                   const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::MumbleServer::ServerPrx>>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::MetaPrx::_iceI_newServer, context);
    }

    /// \cond INTERNAL
    void _iceI_newServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::MumbleServer::ServerPrx>>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Fetch list of all currently running servers.
     * @param context The Context map to send with the invocation.
     * @return List of interfaces for running servers.
     */
    ServerList getBootedServers(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::MumbleServer::ServerList>(true, this, &MetaPrx::_iceI_getBootedServers, context).get();
    }

    /**
     * Fetch list of all currently running servers.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getBootedServersAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::MumbleServer::ServerList>>().get_future())
    {
        return _makePromiseOutgoing<::MumbleServer::ServerList, P>(false, this, &MetaPrx::_iceI_getBootedServers, context);
    }

    /**
     * Fetch list of all currently running servers.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getBootedServersAsync(::std::function<void(::MumbleServer::ServerList)> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::MumbleServer::ServerList>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::MetaPrx::_iceI_getBootedServers, context);
    }

    /// \cond INTERNAL
    void _iceI_getBootedServers(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::MumbleServer::ServerList>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Fetch list of all defined servers.
     * @param context The Context map to send with the invocation.
     * @return List of interfaces for all servers.
     */
    ServerList getAllServers(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::MumbleServer::ServerList>(true, this, &MetaPrx::_iceI_getAllServers, context).get();
    }

    /**
     * Fetch list of all defined servers.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getAllServersAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::MumbleServer::ServerList>>().get_future())
    {
        return _makePromiseOutgoing<::MumbleServer::ServerList, P>(false, this, &MetaPrx::_iceI_getAllServers, context);
    }

    /**
     * Fetch list of all defined servers.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getAllServersAsync(::std::function<void(::MumbleServer::ServerList)> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::MumbleServer::ServerList>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::MetaPrx::_iceI_getAllServers, context);
    }

    /// \cond INTERNAL
    void _iceI_getAllServers(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::MumbleServer::ServerList>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Fetch default configuration. This returns the configuration items that were set in the configuration file, or
     * the built-in default. The individual servers will use these values unless they have been overridden in the
     * server specific configuration. The only special case is the port, which defaults to the value defined here +
     * the servers ID - 1 (so that virtual server #1 uses the defined port, server #2 uses port+1 etc).
     * @param context The Context map to send with the invocation.
     * @return Default configuration of the servers.
     */
    ConfigMap getDefaultConf(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::MumbleServer::ConfigMap>(true, this, &MetaPrx::_iceI_getDefaultConf, context).get();
    }

    /**
     * Fetch default configuration. This returns the configuration items that were set in the configuration file, or
     * the built-in default. The individual servers will use these values unless they have been overridden in the
     * server specific configuration. The only special case is the port, which defaults to the value defined here +
     * the servers ID - 1 (so that virtual server #1 uses the defined port, server #2 uses port+1 etc).
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getDefaultConfAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::MumbleServer::ConfigMap>>().get_future())
    {
        return _makePromiseOutgoing<::MumbleServer::ConfigMap, P>(false, this, &MetaPrx::_iceI_getDefaultConf, context);
    }

    /**
     * Fetch default configuration. This returns the configuration items that were set in the configuration file, or
     * the built-in default. The individual servers will use these values unless they have been overridden in the
     * server specific configuration. The only special case is the port, which defaults to the value defined here +
     * the servers ID - 1 (so that virtual server #1 uses the defined port, server #2 uses port+1 etc).
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getDefaultConfAsync(::std::function<void(::MumbleServer::ConfigMap)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::MumbleServer::ConfigMap>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::MetaPrx::_iceI_getDefaultConf, context);
    }

    /// \cond INTERNAL
    void _iceI_getDefaultConf(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::MumbleServer::ConfigMap>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Fetch version of Murmur.
     * @param major Major version.
     * @param minor Minor version.
     * @param patch Patchlevel.
     * @param text Textual representation of version. Note that this may not match the {@link major}, {@link minor} and {@link patch} levels, as it
     * may be simply the compile date or the SVN revision. This is usually the text you want to present to users.
     * @param context The Context map to send with the invocation.
     */
    void getVersion(int& major, int& minor, int& patch, ::std::string& text, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _result = _makePromiseOutgoing<Meta::GetVersionResult>(true, this, &MetaPrx::_iceI_getVersion, context).get();
        major = _result.major;
        minor = _result.minor;
        patch = _result.patch;
        text = ::std::move(_result.text);
    }

    /**
     * Fetch version of Murmur.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getVersionAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<Meta::GetVersionResult>>().get_future())
    {
        return _makePromiseOutgoing<Meta::GetVersionResult, P>(false, this, &MetaPrx::_iceI_getVersion, context);
    }

    /**
     * Fetch version of Murmur.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getVersionAsync(::std::function<void(int, int, int, ::std::string)> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _responseCb = [response](Meta::GetVersionResult&& _result)
        {
            response(_result.major, _result.minor, _result.patch, ::std::move(_result.text));
        };
        return _makeLamdaOutgoing<Meta::GetVersionResult>(std::move(_responseCb), std::move(ex), std::move(sent), this, &MumbleServer::MetaPrx::_iceI_getVersion, context);
    }

    /// \cond INTERNAL
    void _iceI_getVersion(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<Meta::GetVersionResult>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Add a callback. The callback will receive notifications when servers are started or stopped.
     * @param cb Callback interface which will receive notifications.
     * @param context The Context map to send with the invocation.
     */
    void addCallback(const ::std::shared_ptr<MetaCallbackPrx>& cb, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &MetaPrx::_iceI_addCallback, cb, context).get();
    }

    /**
     * Add a callback. The callback will receive notifications when servers are started or stopped.
     * @param cb Callback interface which will receive notifications.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto addCallbackAsync(const ::std::shared_ptr<MetaCallbackPrx>& cb, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &MetaPrx::_iceI_addCallback, cb, context);
    }

    /**
     * Add a callback. The callback will receive notifications when servers are started or stopped.
     * @param cb Callback interface which will receive notifications.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    addCallbackAsync(const ::std::shared_ptr<MetaCallbackPrx>& cb,
                     ::std::function<void()> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::MetaPrx::_iceI_addCallback, cb, context);
    }

    /// \cond INTERNAL
    void _iceI_addCallback(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<MetaCallbackPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed.
     * @param context The Context map to send with the invocation.
     */
    void removeCallback(const ::std::shared_ptr<MetaCallbackPrx>& cb, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &MetaPrx::_iceI_removeCallback, cb, context).get();
    }

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto removeCallbackAsync(const ::std::shared_ptr<MetaCallbackPrx>& cb, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &MetaPrx::_iceI_removeCallback, cb, context);
    }

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    removeCallbackAsync(const ::std::shared_ptr<MetaCallbackPrx>& cb,
                        ::std::function<void()> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::MetaPrx::_iceI_removeCallback, cb, context);
    }

    /// \cond INTERNAL
    void _iceI_removeCallback(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<MetaCallbackPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get murmur uptime.
     * @param context The Context map to send with the invocation.
     * @return Uptime of murmur in seconds
     */
    int getUptime(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &MetaPrx::_iceI_getUptime, context).get();
    }

    /**
     * Get murmur uptime.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getUptimeAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &MetaPrx::_iceI_getUptime, context);
    }

    /**
     * Get murmur uptime.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getUptimeAsync(::std::function<void(int)> response,
                   ::std::function<void(::std::exception_ptr)> ex = nullptr,
                   ::std::function<void(bool)> sent = nullptr,
                   const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::MetaPrx::_iceI_getUptime, context);
    }

    /// \cond INTERNAL
    void _iceI_getUptime(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get slice file.
     * @param context The Context map to send with the invocation.
     * @return Contents of the slice file server compiled with.
     */
    ::std::string getSlice(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::string>(true, this, &MetaPrx::_iceI_getSlice, context).get();
    }

    /**
     * Get slice file.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getSliceAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::string>>().get_future())
    {
        return _makePromiseOutgoing<::std::string, P>(false, this, &MetaPrx::_iceI_getSlice, context);
    }

    /**
     * Get slice file.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getSliceAsync(::std::function<void(::std::string)> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::string>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::MetaPrx::_iceI_getSlice, context);
    }

    /// \cond INTERNAL
    void _iceI_getSlice(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Returns a checksum dict for the slice file.
     * @param context The Context map to send with the invocation.
     * @return Checksum dict
     */
    ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::SliceChecksumDict>(true, this, &MetaPrx::_iceI_getSliceChecksums, context).get();
    }

    /**
     * Returns a checksum dict for the slice file.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getSliceChecksumsAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::SliceChecksumDict>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::SliceChecksumDict, P>(false, this, &MetaPrx::_iceI_getSliceChecksums, context);
    }

    /**
     * Returns a checksum dict for the slice file.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getSliceChecksumsAsync(::std::function<void(::Ice::SliceChecksumDict)> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::SliceChecksumDict>(std::move(response), std::move(ex), std::move(sent), this, &MumbleServer::MetaPrx::_iceI_getSliceChecksums, context);
    }

    /// \cond INTERNAL
    void _iceI_getSliceChecksums(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::SliceChecksumDict>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    MetaPrx() = default;
    friend ::std::shared_ptr<MetaPrx> IceInternal::createProxy<MetaPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits<::MumbleServer::User>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 60;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::MumbleServer::User, S>
{
    static void read(S* istr, ::MumbleServer::User& v)
    {
        istr->readAll(v.session, v.userid, v.mute, v.deaf, v.suppress, v.prioritySpeaker, v.selfMute, v.selfDeaf, v.recording, v.channel, v.name, v.onlinesecs, v.bytespersec, v.version, v.version2, v.release, v.os, v.osversion, v.identity, v.context, v.comment, v.address, v.tcponly, v.idlesecs, v.udpPing, v.tcpPing);
    }
};

template<>
struct StreamableTraits<::MumbleServer::TextMessage>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 4;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::MumbleServer::TextMessage, S>
{
    static void read(S* istr, ::MumbleServer::TextMessage& v)
    {
        istr->readAll(v.sessions, v.channels, v.trees, v.text);
    }
};

template<>
struct StreamableTraits<::MumbleServer::Channel>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 16;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::MumbleServer::Channel, S>
{
    static void read(S* istr, ::MumbleServer::Channel& v)
    {
        istr->readAll(v.id, v.name, v.parent, v.links, v.description, v.temporary, v.position);
    }
};

template<>
struct StreamableTraits<::MumbleServer::Group>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 7;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::MumbleServer::Group, S>
{
    static void read(S* istr, ::MumbleServer::Group& v)
    {
        istr->readAll(v.name, v.inherited, v.inherit, v.inheritable, v.add, v.remove, v.members);
    }
};

template<>
struct StreamableTraits<::MumbleServer::ACL>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 16;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::MumbleServer::ACL, S>
{
    static void read(S* istr, ::MumbleServer::ACL& v)
    {
        istr->readAll(v.applyHere, v.applySubs, v.inherited, v.userid, v.group, v.allow, v.deny);
    }
};

template<>
struct StreamableTraits<::MumbleServer::Ban>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 16;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::MumbleServer::Ban, S>
{
    static void read(S* istr, ::MumbleServer::Ban& v)
    {
        istr->readAll(v.address, v.bits, v.name, v.hash, v.reason, v.start, v.duration);
    }
};

template<>
struct StreamableTraits<::MumbleServer::LogEntry>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 5;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::MumbleServer::LogEntry, S>
{
    static void read(S* istr, ::MumbleServer::LogEntry& v)
    {
        istr->readAll(v.timestamp, v.txt);
    }
};

template<>
struct StreamableTraits< ::MumbleServer::ChannelInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryEnum;
    static const int minValue = 0;
    static const int maxValue = 1;
    static const int minWireSize = 1;
    static const bool fixedLength = false;
};

template<>
struct StreamableTraits< ::MumbleServer::UserInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryEnum;
    static const int minValue = 0;
    static const int maxValue = 6;
    static const int minWireSize = 1;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::MumbleServer::Tree, S>
{
    static void read(S* istr, ::MumbleServer::Tree& v)
    {
        istr->readAll(v.c, v.children, v.users);
    }
};

}
/// \endcond

/// \cond INTERNAL
namespace MumbleServer
{

using TreePtr = ::std::shared_ptr<Tree>;

using ServerCallbackPtr = ::std::shared_ptr<ServerCallback>;
using ServerCallbackPrxPtr = ::std::shared_ptr<ServerCallbackPrx>;

using ServerContextCallbackPtr = ::std::shared_ptr<ServerContextCallback>;
using ServerContextCallbackPrxPtr = ::std::shared_ptr<ServerContextCallbackPrx>;

using ServerAuthenticatorPtr = ::std::shared_ptr<ServerAuthenticator>;
using ServerAuthenticatorPrxPtr = ::std::shared_ptr<ServerAuthenticatorPrx>;

using ServerUpdatingAuthenticatorPtr = ::std::shared_ptr<ServerUpdatingAuthenticator>;
using ServerUpdatingAuthenticatorPrxPtr = ::std::shared_ptr<ServerUpdatingAuthenticatorPrx>;

using ServerPtr = ::std::shared_ptr<Server>;
using ServerPrxPtr = ::std::shared_ptr<ServerPrx>;

using MetaCallbackPtr = ::std::shared_ptr<MetaCallback>;
using MetaCallbackPrxPtr = ::std::shared_ptr<MetaCallbackPrx>;

using MetaPtr = ::std::shared_ptr<Meta>;
using MetaPrxPtr = ::std::shared_ptr<MetaPrx>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace MumbleServer
{

class Tree;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< Tree>&);
::IceProxy::Ice::Object* upCast(Tree*);
/// \endcond

class ServerCallback;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ServerCallback>&);
::IceProxy::Ice::Object* upCast(ServerCallback*);
/// \endcond

class ServerContextCallback;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ServerContextCallback>&);
::IceProxy::Ice::Object* upCast(ServerContextCallback*);
/// \endcond

class ServerAuthenticator;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ServerAuthenticator>&);
::IceProxy::Ice::Object* upCast(ServerAuthenticator*);
/// \endcond

class ServerUpdatingAuthenticator;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ServerUpdatingAuthenticator>&);
::IceProxy::Ice::Object* upCast(ServerUpdatingAuthenticator*);
/// \endcond

class Server;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< Server>&);
::IceProxy::Ice::Object* upCast(Server*);
/// \endcond

class MetaCallback;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< MetaCallback>&);
::IceProxy::Ice::Object* upCast(MetaCallback*);
/// \endcond

class Meta;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< Meta>&);
::IceProxy::Ice::Object* upCast(Meta*);
/// \endcond

}

}

namespace MumbleServer
{

class Tree;
/// \cond INTERNAL
::Ice::Object* upCast(Tree*);
/// \endcond
typedef ::IceInternal::Handle< Tree> TreePtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::MumbleServer::Tree> TreePrx;
typedef TreePrx TreePrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(TreePtr&, const ::Ice::ObjectPtr&);
/// \endcond

class ServerCallback;
/// \cond INTERNAL
::Ice::Object* upCast(ServerCallback*);
/// \endcond
typedef ::IceInternal::Handle< ServerCallback> ServerCallbackPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::MumbleServer::ServerCallback> ServerCallbackPrx;
typedef ServerCallbackPrx ServerCallbackPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(ServerCallbackPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class ServerContextCallback;
/// \cond INTERNAL
::Ice::Object* upCast(ServerContextCallback*);
/// \endcond
typedef ::IceInternal::Handle< ServerContextCallback> ServerContextCallbackPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::MumbleServer::ServerContextCallback> ServerContextCallbackPrx;
typedef ServerContextCallbackPrx ServerContextCallbackPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(ServerContextCallbackPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class ServerAuthenticator;
/// \cond INTERNAL
::Ice::Object* upCast(ServerAuthenticator*);
/// \endcond
typedef ::IceInternal::Handle< ServerAuthenticator> ServerAuthenticatorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::MumbleServer::ServerAuthenticator> ServerAuthenticatorPrx;
typedef ServerAuthenticatorPrx ServerAuthenticatorPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(ServerAuthenticatorPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class ServerUpdatingAuthenticator;
/// \cond INTERNAL
::Ice::Object* upCast(ServerUpdatingAuthenticator*);
/// \endcond
typedef ::IceInternal::Handle< ServerUpdatingAuthenticator> ServerUpdatingAuthenticatorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::MumbleServer::ServerUpdatingAuthenticator> ServerUpdatingAuthenticatorPrx;
typedef ServerUpdatingAuthenticatorPrx ServerUpdatingAuthenticatorPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(ServerUpdatingAuthenticatorPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class Server;
/// \cond INTERNAL
::Ice::Object* upCast(Server*);
/// \endcond
typedef ::IceInternal::Handle< Server> ServerPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::MumbleServer::Server> ServerPrx;
typedef ServerPrx ServerPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(ServerPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class MetaCallback;
/// \cond INTERNAL
::Ice::Object* upCast(MetaCallback*);
/// \endcond
typedef ::IceInternal::Handle< MetaCallback> MetaCallbackPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::MumbleServer::MetaCallback> MetaCallbackPrx;
typedef MetaCallbackPrx MetaCallbackPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(MetaCallbackPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class Meta;
/// \cond INTERNAL
::Ice::Object* upCast(Meta*);
/// \endcond
typedef ::IceInternal::Handle< Meta> MetaPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::MumbleServer::Meta> MetaPrx;
typedef MetaPrx MetaPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(MetaPtr&, const ::Ice::ObjectPtr&);
/// \endcond

}

namespace MumbleServer
{

/**
 * A network address in IPv6 format.
 */
typedef ::std::vector< ::Ice::Byte> NetAddress;

/**
 * A connected user.
 */
struct User
{
    /**
     * Session ID. This identifies the connection to the server.
     */
    ::Ice::Int session;
    /**
     * User ID. -1 if the user is anonymous.
     */
    ::Ice::Int userid;
    /**
     * Is user muted by the server?
     */
    bool mute;
    /**
     * Is user deafened by the server? If true, this implies mute.
     */
    bool deaf;
    /**
     * Is the user suppressed by the server? This means the user is not muted, but does not have speech privileges in the current channel.
     */
    bool suppress;
    /**
     * Is the user a priority speaker?
     */
    bool prioritySpeaker;
    /**
     * Is the user self-muted?
     */
    bool selfMute;
    /**
     * Is the user self-deafened? If true, this implies mute.
     */
    bool selfDeaf;
    /**
     * Is the User recording? (This flag is read-only and cannot be changed using setState().)
     */
    bool recording;
    /**
     * Channel ID the user is in. Matches {@link Channel.id}.
     */
    ::Ice::Int channel;
    /**
     * The name of the user.
     */
    ::std::string name;
    /**
     * Seconds user has been online.
     */
    ::Ice::Int onlinesecs;
    /**
     * Average transmission rate in bytes per second over the last few seconds.
     */
    ::Ice::Int bytespersec;
    /**
     * Legacy client version.
     */
    ::Ice::Int version;
    /**
     * New client version. (See https://github.com/mumble-voip/mumble/issues/5827)
     */
    ::Ice::Long version2;
    /**
     * Client release. For official releases, this equals the version. For snapshots and git compiles, this will be something else.
     */
    ::std::string release;
    /**
     * Client OS.
     */
    ::std::string os;
    /**
     * Client OS Version.
     */
    ::std::string osversion;
    /**
     * Plugin Identity. This will be the user's unique ID inside the current game.
     */
    ::std::string identity;
    /**
     * Base64-encoded Plugin context. This is a binary blob identifying the game and team the user is on.
     *
     * The used Base64 alphabet is the one specified in RFC 2045.
     *
     * Before Mumble 1.3.0, this string was not Base64-encoded. This could cause problems for some Ice
     * implementations, such as the .NET implementation.
     *
     * If you need the exact string that is used by Mumble, you can get it by Base64-decoding this string.
     *
     * If you simply need to detect whether two users are in the same game world, string comparisons will
     * continue to work as before.
     */
    ::std::string context;
    /**
     * User comment. Shown as tooltip for this user.
     */
    ::std::string comment;
    /**
     * Client address.
     */
    ::MumbleServer::NetAddress address;
    /**
     * TCP only. True until UDP connectivity is established.
     */
    bool tcponly;
    /**
     * Idle time. This is how many seconds it is since the user last spoke. Other activity is not counted.
     */
    ::Ice::Int idlesecs;
    /**
     * UDP Ping Average. This is the average ping for the user via UDP over the duration of the connection.
     */
    ::Ice::Float udpPing;
    /**
     * TCP Ping Average. This is the average ping for the user via TCP over the duration of the connection.
     */
    ::Ice::Float tcpPing;
};

typedef ::std::vector< ::Ice::Int> IntList;

/**
 * A text message between users.
 */
struct TextMessage
{
    /**
     * Sessions (connected users) who were sent this message.
     */
    ::MumbleServer::IntList sessions;
    /**
     * Channels who were sent this message.
     */
    ::MumbleServer::IntList channels;
    /**
     * Trees of channels who were sent this message.
     */
    ::MumbleServer::IntList trees;
    /**
     * The contents of the message.
     */
    ::std::string text;
};

/**
 * A channel.
 */
struct Channel
{
    /**
     * Channel ID. This is unique per channel, and the root channel is always id 0.
     */
    ::Ice::Int id;
    /**
     * Name of the channel. There can not be two channels with the same parent that has the same name.
     */
    ::std::string name;
    /**
     * ID of parent channel, or -1 if this is the root channel.
     */
    ::Ice::Int parent;
    /**
     * List of id of linked channels.
     */
    ::MumbleServer::IntList links;
    /**
     * Description of channel. Shown as tooltip for this channel.
     */
    ::std::string description;
    /**
     * Channel is temporary, and will be removed when the last user leaves it.
     */
    bool temporary;
    /**
     * Position of the channel which is used in Client for sorting.
     */
    ::Ice::Int position;
};

/**
 * A group. Groups are defined per channel, and can inherit members from parent channels.
 */
struct Group
{
    /**
     * Group name
     */
    ::std::string name;
    /**
     * Is this group inherited from a parent channel? Read-only.
     */
    bool inherited;
    /**
     * Does this group inherit members from parent channels?
     */
    bool inherit;
    /**
     * Can subchannels inherit members from this group?
     */
    bool inheritable;
    /**
     * List of users to add to the group.
     */
    ::MumbleServer::IntList add;
    /**
     * List of inherited users to remove from the group.
     */
    ::MumbleServer::IntList remove;
    /**
     * Current members of the group, including inherited members. Read-only.
     */
    ::MumbleServer::IntList members;
};

/**
 * Write access to channel control. Implies all other permissions (except Speak).
 */
const ::Ice::Int PermissionWrite = 1;

/**
 * Traverse channel. Without this, a client cannot reach subchannels, no matter which privileges he has there.
 */
const ::Ice::Int PermissionTraverse = 2;

/**
 * Enter channel.
 */
const ::Ice::Int PermissionEnter = 4;

/**
 * Speak in channel.
 */
const ::Ice::Int PermissionSpeak = 8;

/**
 * Whisper to channel. This is different from Speak, so you can set up different permissions.
 */
const ::Ice::Int PermissionWhisper = 256;

/**
 * Mute and deafen other users in this channel.
 */
const ::Ice::Int PermissionMuteDeafen = 16;

/**
 * Move users from channel. You need this permission in both the source and destination channel to move another user.
 */
const ::Ice::Int PermissionMove = 32;

/**
 * Make new channel as a subchannel of this channel.
 */
const ::Ice::Int PermissionMakeChannel = 64;

/**
 * Make new temporary channel as a subchannel of this channel.
 */
const ::Ice::Int PermissionMakeTempChannel = 1024;

/**
 * Link this channel. You need this permission in both the source and destination channel to link channels, or in either channel to unlink them.
 */
const ::Ice::Int PermissionLinkChannel = 128;

/**
 * Send text message to channel.
 */
const ::Ice::Int PermissionTextMessage = 512;

/**
 * Kick user from server. Only valid on root channel.
 */
const ::Ice::Int PermissionKick = 65536;

/**
 * Ban user from server. Only valid on root channel.
 */
const ::Ice::Int PermissionBan = 131072;

/**
 * Register and unregister users. Only valid on root channel.
 */
const ::Ice::Int PermissionRegister = 262144;

/**
 * Register and unregister users. Only valid on root channel.
 */
const ::Ice::Int PermissionRegisterSelf = 524288;

/**
 * Reset the comment or avatar of a user. Only valid on root channel.
 */
const ::Ice::Int ResetUserContent = 1048576;

/**
 * Access Control List for a channel. ACLs are defined per channel, and can be inherited from parent channels.
 */
struct ACL
{
    /**
     * Does the ACL apply to this channel?
     */
    bool applyHere;
    /**
     * Does the ACL apply to subchannels?
     */
    bool applySubs;
    /**
     * Is this ACL inherited from a parent channel? Read-only.
     */
    bool inherited;
    /**
     * ID of user this ACL applies to. -1 if using a group name.
     */
    ::Ice::Int userid;
    /**
     * Group this ACL applies to. Blank if using userid.
     */
    ::std::string group;
    /**
     * Binary mask of privileges to allow.
     */
    ::Ice::Int allow;
    /**
     * Binary mask of privileges to deny.
     */
    ::Ice::Int deny;

    bool operator==(const ACL& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(applyHere != rhs_.applyHere)
        {
            return false;
        }
        if(applySubs != rhs_.applySubs)
        {
            return false;
        }
        if(inherited != rhs_.inherited)
        {
            return false;
        }
        if(userid != rhs_.userid)
        {
            return false;
        }
        if(group != rhs_.group)
        {
            return false;
        }
        if(allow != rhs_.allow)
        {
            return false;
        }
        if(deny != rhs_.deny)
        {
            return false;
        }
        return true;
    }

    bool operator<(const ACL& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(applyHere < rhs_.applyHere)
        {
            return true;
        }
        else if(rhs_.applyHere < applyHere)
        {
            return false;
        }
        if(applySubs < rhs_.applySubs)
        {
            return true;
        }
        else if(rhs_.applySubs < applySubs)
        {
            return false;
        }
        if(inherited < rhs_.inherited)
        {
            return true;
        }
        else if(rhs_.inherited < inherited)
        {
            return false;
        }
        if(userid < rhs_.userid)
        {
            return true;
        }
        else if(rhs_.userid < userid)
        {
            return false;
        }
        if(group < rhs_.group)
        {
            return true;
        }
        else if(rhs_.group < group)
        {
            return false;
        }
        if(allow < rhs_.allow)
        {
            return true;
        }
        else if(rhs_.allow < allow)
        {
            return false;
        }
        if(deny < rhs_.deny)
        {
            return true;
        }
        else if(rhs_.deny < deny)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const ACL& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const ACL& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const ACL& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const ACL& rhs_) const
    {
        return !operator<(rhs_);
    }
};

/**
 * A single ip mask for a ban.
 */
struct Ban
{
    /**
     * Address to ban.
     */
    ::MumbleServer::NetAddress address;
    /**
     * Number of bits in ban to apply.
     */
    ::Ice::Int bits;
    /**
     * Username associated with ban.
     */
    ::std::string name;
    /**
     * Hash of banned user.
     */
    ::std::string hash;
    /**
     * Reason for ban.
     */
    ::std::string reason;
    /**
     * Date ban was applied in unix time format.
     */
    ::Ice::Int start;
    /**
     * Duration of ban.
     */
    ::Ice::Int duration;
};

/**
 * A entry in the log.
 */
struct LogEntry
{
    /**
     * Timestamp in UNIX time_t
     */
    ::Ice::Int timestamp;
    /**
     * The log message.
     */
    ::std::string txt;

    bool operator==(const LogEntry& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(timestamp != rhs_.timestamp)
        {
            return false;
        }
        if(txt != rhs_.txt)
        {
            return false;
        }
        return true;
    }

    bool operator<(const LogEntry& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(timestamp < rhs_.timestamp)
        {
            return true;
        }
        else if(rhs_.timestamp < timestamp)
        {
            return false;
        }
        if(txt < rhs_.txt)
        {
            return true;
        }
        else if(rhs_.txt < txt)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const LogEntry& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const LogEntry& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const LogEntry& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const LogEntry& rhs_) const
    {
        return !operator<(rhs_);
    }
};

typedef ::std::vector<TreePtr> TreeList;

enum ChannelInfo
{
    ChannelDescription,
    ChannelPosition
};

enum UserInfo
{
    UserName,
    UserEmail,
    UserComment,
    UserHash,
    UserPassword,
    UserLastActive,
    UserKDFIterations
};

typedef ::std::map< ::Ice::Int, User> UserMap;

typedef ::std::map< ::Ice::Int, Channel> ChannelMap;

typedef ::std::vector<Channel> ChannelList;

typedef ::std::vector<User> UserList;

typedef ::std::vector<Group> GroupList;

typedef ::std::vector<ACL> ACLList;

typedef ::std::vector<LogEntry> LogList;

typedef ::std::vector<Ban> BanList;

typedef ::std::vector< ::Ice::Int> IdList;

typedef ::std::vector< ::std::string> NameList;

typedef ::std::map< ::Ice::Int, ::std::string> NameMap;

typedef ::std::map< ::std::string, ::Ice::Int> IdMap;

typedef ::std::vector< ::Ice::Byte> Texture;

typedef ::std::map< ::std::string, ::std::string> ConfigMap;

typedef ::std::vector< ::std::string> GroupNameList;

typedef ::std::vector< ::Ice::Byte> CertificateDer;

typedef ::std::vector<CertificateDer> CertificateList;

/**
 * User information map.
 * Older versions of ice-php can't handle enums as keys. If you are using one of these, replace 'UserInfo' with 'byte'.
 */
typedef ::std::map<UserInfo, ::std::string> UserInfoMap;

class MurmurException : public ::Ice::UserException
{
public:

    MurmurException() {}

#ifdef ICE_CPP11_COMPILER
    MurmurException(const MurmurException&) = default;
    virtual ~MurmurException();
#else
    virtual ~MurmurException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual MurmurException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
static MurmurException _iceS_MurmurException_init;
/// \endcond

/**
 * This is thrown when you specify an invalid session. This may happen if the user has disconnected since your last call to {@link Server.getUsers}. See {@link User.session}
 */
class InvalidSessionException : public MurmurException
{
public:

    InvalidSessionException() {}

#ifdef ICE_CPP11_COMPILER
    InvalidSessionException(const InvalidSessionException&) = default;
    virtual ~InvalidSessionException();
#else
    virtual ~InvalidSessionException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual InvalidSessionException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This is thrown when you specify an invalid channel id. This may happen if the channel was removed by another provess. It can also be thrown if you try to add an invalid channel.
 */
class InvalidChannelException : public MurmurException
{
public:

    InvalidChannelException() {}

#ifdef ICE_CPP11_COMPILER
    InvalidChannelException(const InvalidChannelException&) = default;
    virtual ~InvalidChannelException();
#else
    virtual ~InvalidChannelException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual InvalidChannelException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This is thrown when you try to do an operation on a server that does not exist. This may happen if someone has removed the server.
 */
class InvalidServerException : public MurmurException
{
public:

    InvalidServerException() {}

#ifdef ICE_CPP11_COMPILER
    InvalidServerException(const InvalidServerException&) = default;
    virtual ~InvalidServerException();
#else
    virtual ~InvalidServerException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual InvalidServerException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This happens if you try to fetch user or channel state on a stopped server, if you try to stop an already stopped server or start an already started server.
 */
class ServerBootedException : public MurmurException
{
public:

    ServerBootedException() {}

#ifdef ICE_CPP11_COMPILER
    ServerBootedException(const ServerBootedException&) = default;
    virtual ~ServerBootedException();
#else
    virtual ~ServerBootedException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual ServerBootedException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This is thrown if {@link Server.start} fails, and should generally be the cause for some concern.
 */
class ServerFailureException : public MurmurException
{
public:

    ServerFailureException() {}

#ifdef ICE_CPP11_COMPILER
    ServerFailureException(const ServerFailureException&) = default;
    virtual ~ServerFailureException();
#else
    virtual ~ServerFailureException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual ServerFailureException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This is thrown when you specify an invalid userid.
 */
class InvalidUserException : public MurmurException
{
public:

    InvalidUserException() {}

#ifdef ICE_CPP11_COMPILER
    InvalidUserException(const InvalidUserException&) = default;
    virtual ~InvalidUserException();
#else
    virtual ~InvalidUserException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual InvalidUserException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This is thrown when you try to set an invalid texture.
 */
class InvalidTextureException : public MurmurException
{
public:

    InvalidTextureException() {}

#ifdef ICE_CPP11_COMPILER
    InvalidTextureException(const InvalidTextureException&) = default;
    virtual ~InvalidTextureException();
#else
    virtual ~InvalidTextureException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual InvalidTextureException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This is thrown when you supply an invalid callback.
 */
class InvalidCallbackException : public MurmurException
{
public:

    InvalidCallbackException() {}

#ifdef ICE_CPP11_COMPILER
    InvalidCallbackException(const InvalidCallbackException&) = default;
    virtual ~InvalidCallbackException();
#else
    virtual ~InvalidCallbackException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual InvalidCallbackException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This is thrown when you supply the wrong secret in the calling context.
 */
class InvalidSecretException : public MurmurException
{
public:

    InvalidSecretException() {}

#ifdef ICE_CPP11_COMPILER
    InvalidSecretException(const InvalidSecretException&) = default;
    virtual ~InvalidSecretException();
#else
    virtual ~InvalidSecretException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual InvalidSecretException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This is thrown when the channel operation would exceed the channel nesting limit
 */
class NestingLimitException : public MurmurException
{
public:

    NestingLimitException() {}

#ifdef ICE_CPP11_COMPILER
    NestingLimitException(const NestingLimitException&) = default;
    virtual ~NestingLimitException();
#else
    virtual ~NestingLimitException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual NestingLimitException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This is thrown when you ask the server to disclose something that should be secret.
 */
class WriteOnlyException : public MurmurException
{
public:

    WriteOnlyException() {}

#ifdef ICE_CPP11_COMPILER
    WriteOnlyException(const WriteOnlyException&) = default;
    virtual ~WriteOnlyException();
#else
    virtual ~WriteOnlyException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual WriteOnlyException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This is thrown when invalid input data was specified.
 */
class InvalidInputDataException : public MurmurException
{
public:

    InvalidInputDataException() {}

#ifdef ICE_CPP11_COMPILER
    InvalidInputDataException(const InvalidInputDataException&) = default;
    virtual ~InvalidInputDataException();
#else
    virtual ~InvalidInputDataException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual InvalidInputDataException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * Context for actions in the Server menu.
 */
const ::Ice::Int ContextServer = 1;

/**
 * Context for actions in the Channel menu.
 */
const ::Ice::Int ContextChannel = 2;

/**
 * Context for actions in the User menu.
 */
const ::Ice::Int ContextUser = 4;

typedef ::std::vector<ServerPrx> ServerList;

}

namespace MumbleServer
{

/**
 * AMD callback class for MumbleServer::Server::isRunning_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_isRunning : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_isRunning();

    /**
     * Call ice_response for a successful completion.
     * @param result Run-state of server.
     */
    virtual void ice_response(bool result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_isRunning> AMD_Server_isRunningPtr;

/**
 * AMD callback class for MumbleServer::Server::start_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_start : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_start();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_start> AMD_Server_startPtr;

/**
 * AMD callback class for MumbleServer::Server::stop_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_stop : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_stop();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_stop> AMD_Server_stopPtr;

/**
 * AMD callback class for MumbleServer::Server::_cpp_delete_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_delete : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_delete();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_delete> AMD_Server_deletePtr;

/**
 * AMD callback class for MumbleServer::Server::id_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_id : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_id();

    /**
     * Call ice_response for a successful completion.
     * @param result Unique server id.
     */
    virtual void ice_response(::Ice::Int result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_id> AMD_Server_idPtr;

/**
 * AMD callback class for MumbleServer::Server::addCallback_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_addCallback : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_addCallback();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_addCallback> AMD_Server_addCallbackPtr;

/**
 * AMD callback class for MumbleServer::Server::removeCallback_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_removeCallback : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_removeCallback();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_removeCallback> AMD_Server_removeCallbackPtr;

/**
 * AMD callback class for MumbleServer::Server::setAuthenticator_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_setAuthenticator : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_setAuthenticator();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_setAuthenticator> AMD_Server_setAuthenticatorPtr;

/**
 * AMD callback class for MumbleServer::Server::getConf_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_getConf : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_getConf();

    /**
     * Call ice_response for a successful completion.
     * @param result Configuration value. If this is empty, see {@link Meta.getDefaultConf}
     */
    virtual void ice_response(const ::std::string& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_getConf> AMD_Server_getConfPtr;

/**
 * AMD callback class for MumbleServer::Server::getAllConf_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_getAllConf : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_getAllConf();

    /**
     * Call ice_response for a successful completion.
     * @param result All configured values. If a value isn't set here, the value from {@link Meta.getDefaultConf} is used.
     */
    virtual void ice_response(const ConfigMap& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_getAllConf> AMD_Server_getAllConfPtr;

/**
 * AMD callback class for MumbleServer::Server::setConf_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_setConf : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_setConf();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_setConf> AMD_Server_setConfPtr;

/**
 * AMD callback class for MumbleServer::Server::setSuperuserPassword_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_setSuperuserPassword : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_setSuperuserPassword();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_setSuperuserPassword> AMD_Server_setSuperuserPasswordPtr;

/**
 * AMD callback class for MumbleServer::Server::getLog_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_getLog : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_getLog();

    /**
     * Call ice_response for a successful completion.
     * @param result List of log entries.
     */
    virtual void ice_response(const LogList& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_getLog> AMD_Server_getLogPtr;

/**
 * AMD callback class for MumbleServer::Server::getLogLen_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_getLogLen : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_getLogLen();

    /**
     * Call ice_response for a successful completion.
     * @param result Number of entries in log
     */
    virtual void ice_response(::Ice::Int result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_getLogLen> AMD_Server_getLogLenPtr;

/**
 * AMD callback class for MumbleServer::Server::getUsers_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_getUsers : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_getUsers();

    /**
     * Call ice_response for a successful completion.
     * @param result List of connected users.
     */
    virtual void ice_response(const UserMap& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_getUsers> AMD_Server_getUsersPtr;

/**
 * AMD callback class for MumbleServer::Server::getChannels_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_getChannels : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_getChannels();

    /**
     * Call ice_response for a successful completion.
     * @param result List of defined channels.
     */
    virtual void ice_response(const ChannelMap& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_getChannels> AMD_Server_getChannelsPtr;

/**
 * AMD callback class for MumbleServer::Server::getCertificateList_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_getCertificateList : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_getCertificateList();

    /**
     * Call ice_response for a successful completion.
     * @param result Certificate list of user.
     */
    virtual void ice_response(const CertificateList& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_getCertificateList> AMD_Server_getCertificateListPtr;

/**
 * AMD callback class for MumbleServer::Server::getTree_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_getTree : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_getTree();

    /**
     * Call ice_response for a successful completion.
     * @param result Recursive tree of all channels and connected users.
     */
    virtual void ice_response(const TreePtr& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_getTree> AMD_Server_getTreePtr;

/**
 * AMD callback class for MumbleServer::Server::getBans_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_getBans : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_getBans();

    /**
     * Call ice_response for a successful completion.
     * @param result List of bans.
     */
    virtual void ice_response(const BanList& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_getBans> AMD_Server_getBansPtr;

/**
 * AMD callback class for MumbleServer::Server::setBans_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_setBans : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_setBans();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_setBans> AMD_Server_setBansPtr;

/**
 * AMD callback class for MumbleServer::Server::kickUser_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_kickUser : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_kickUser();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_kickUser> AMD_Server_kickUserPtr;

/**
 * AMD callback class for MumbleServer::Server::getState_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_getState : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_getState();

    /**
     * Call ice_response for a successful completion.
     * @param result State of connected user.
     */
    virtual void ice_response(const User& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_getState> AMD_Server_getStatePtr;

/**
 * AMD callback class for MumbleServer::Server::setState_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_setState : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_setState();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_setState> AMD_Server_setStatePtr;

/**
 * AMD callback class for MumbleServer::Server::sendMessage_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_sendMessage : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_sendMessage();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_sendMessage> AMD_Server_sendMessagePtr;

/**
 * AMD callback class for MumbleServer::Server::hasPermission_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_hasPermission : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_hasPermission();

    /**
     * Call ice_response for a successful completion.
     * @param result true if any of the permissions in perm were set for the user.
     */
    virtual void ice_response(bool result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_hasPermission> AMD_Server_hasPermissionPtr;

/**
 * AMD callback class for MumbleServer::Server::effectivePermissions_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_effectivePermissions : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_effectivePermissions();

    /**
     * Call ice_response for a successful completion.
     * @param result bitfield of allowed actions
     */
    virtual void ice_response(::Ice::Int result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_effectivePermissions> AMD_Server_effectivePermissionsPtr;

/**
 * AMD callback class for MumbleServer::Server::addContextCallback_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_addContextCallback : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_addContextCallback();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_addContextCallback> AMD_Server_addContextCallbackPtr;

/**
 * AMD callback class for MumbleServer::Server::removeContextCallback_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_removeContextCallback : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_removeContextCallback();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_removeContextCallback> AMD_Server_removeContextCallbackPtr;

/**
 * AMD callback class for MumbleServer::Server::getChannelState_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_getChannelState : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_getChannelState();

    /**
     * Call ice_response for a successful completion.
     * @param result State of channel.
     */
    virtual void ice_response(const Channel& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_getChannelState> AMD_Server_getChannelStatePtr;

/**
 * AMD callback class for MumbleServer::Server::setChannelState_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_setChannelState : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_setChannelState();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_setChannelState> AMD_Server_setChannelStatePtr;

/**
 * AMD callback class for MumbleServer::Server::removeChannel_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_removeChannel : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_removeChannel();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_removeChannel> AMD_Server_removeChannelPtr;

/**
 * AMD callback class for MumbleServer::Server::addChannel_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_addChannel : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_addChannel();

    /**
     * Call ice_response for a successful completion.
     * @param result ID of newly created channel.
     */
    virtual void ice_response(::Ice::Int result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_addChannel> AMD_Server_addChannelPtr;

/**
 * AMD callback class for MumbleServer::Server::sendMessageChannel_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_sendMessageChannel : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_sendMessageChannel();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_sendMessageChannel> AMD_Server_sendMessageChannelPtr;

/**
 * AMD callback class for MumbleServer::Server::getACL_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_getACL : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_getACL();

    /**
     * Call ice_response for a successful completion.
     * @param acls List of ACLs on the channel. This will include inherited ACLs.
     * @param groups List of groups on the channel. This will include inherited groups.
     * @param inherit Does this channel inherit ACLs from the parent channel?
     */
    virtual void ice_response(const ACLList& acls, const GroupList& groups, bool inherit) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_getACL> AMD_Server_getACLPtr;

/**
 * AMD callback class for MumbleServer::Server::setACL_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_setACL : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_setACL();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_setACL> AMD_Server_setACLPtr;

/**
 * AMD callback class for MumbleServer::Server::addUserToGroup_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_addUserToGroup : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_addUserToGroup();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_addUserToGroup> AMD_Server_addUserToGroupPtr;

/**
 * AMD callback class for MumbleServer::Server::removeUserFromGroup_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_removeUserFromGroup : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_removeUserFromGroup();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_removeUserFromGroup> AMD_Server_removeUserFromGroupPtr;

/**
 * AMD callback class for MumbleServer::Server::redirectWhisperGroup_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_redirectWhisperGroup : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_redirectWhisperGroup();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_redirectWhisperGroup> AMD_Server_redirectWhisperGroupPtr;

/**
 * AMD callback class for MumbleServer::Server::getUserNames_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_getUserNames : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_getUserNames();

    /**
     * Call ice_response for a successful completion.
     * @param result Matching list of names, with an empty string representing invalid or unknown ids.
     */
    virtual void ice_response(const NameMap& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_getUserNames> AMD_Server_getUserNamesPtr;

/**
 * AMD callback class for MumbleServer::Server::getUserIds_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_getUserIds : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_getUserIds();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response(const IdMap& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_getUserIds> AMD_Server_getUserIdsPtr;

/**
 * AMD callback class for MumbleServer::Server::registerUser_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_registerUser : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_registerUser();

    /**
     * Call ice_response for a successful completion.
     * @param result The ID of the user. See {@link RegisteredUser.userid}.
     */
    virtual void ice_response(::Ice::Int result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_registerUser> AMD_Server_registerUserPtr;

/**
 * AMD callback class for MumbleServer::Server::unregisterUser_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_unregisterUser : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_unregisterUser();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_unregisterUser> AMD_Server_unregisterUserPtr;

/**
 * AMD callback class for MumbleServer::Server::updateRegistration_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_updateRegistration : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_updateRegistration();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_updateRegistration> AMD_Server_updateRegistrationPtr;

/**
 * AMD callback class for MumbleServer::Server::getRegistration_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_getRegistration : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_getRegistration();

    /**
     * Call ice_response for a successful completion.
     * @param result Registration record.
     */
    virtual void ice_response(const UserInfoMap& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_getRegistration> AMD_Server_getRegistrationPtr;

/**
 * AMD callback class for MumbleServer::Server::getRegisteredUsers_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_getRegisteredUsers : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_getRegisteredUsers();

    /**
     * Call ice_response for a successful completion.
     * @param result List of registration records.
     */
    virtual void ice_response(const NameMap& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_getRegisteredUsers> AMD_Server_getRegisteredUsersPtr;

/**
 * AMD callback class for MumbleServer::Server::verifyPassword_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_verifyPassword : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_verifyPassword();

    /**
     * Call ice_response for a successful completion.
     * @param result User ID of registered user (See {@link RegisteredUser.userid}), -1 for failed authentication or -2 for unknown usernames.
     */
    virtual void ice_response(::Ice::Int result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_verifyPassword> AMD_Server_verifyPasswordPtr;

/**
 * AMD callback class for MumbleServer::Server::getTexture_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_getTexture : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_getTexture();

    /**
     * Call ice_response for a successful completion.
     * @param result Custom texture associated with user or an empty texture.
     */
    virtual void ice_response(const Texture& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_getTexture> AMD_Server_getTexturePtr;

/**
 * AMD callback class for MumbleServer::Server::setTexture_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_setTexture : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_setTexture();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_setTexture> AMD_Server_setTexturePtr;

/**
 * AMD callback class for MumbleServer::Server::getUptime_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_getUptime : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_getUptime();

    /**
     * Call ice_response for a successful completion.
     * @param result Uptime of the virtual server in seconds
     */
    virtual void ice_response(::Ice::Int result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_getUptime> AMD_Server_getUptimePtr;

/**
 * AMD callback class for MumbleServer::Server::updateCertificate_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_updateCertificate : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_updateCertificate();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_updateCertificate> AMD_Server_updateCertificatePtr;

/**
 * AMD callback class for MumbleServer::Server::startListening_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_startListening : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_startListening();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_startListening> AMD_Server_startListeningPtr;

/**
 * AMD callback class for MumbleServer::Server::stopListening_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_stopListening : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_stopListening();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_stopListening> AMD_Server_stopListeningPtr;

/**
 * AMD callback class for MumbleServer::Server::isListening_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_isListening : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_isListening();

    /**
     * Call ice_response for a successful completion.
     * @param result s Whether the given user is currently listening to the given channel
     */
    virtual void ice_response(bool result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_isListening> AMD_Server_isListeningPtr;

/**
 * AMD callback class for MumbleServer::Server::getListeningChannels_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_getListeningChannels : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_getListeningChannels();

    /**
     * Call ice_response for a successful completion.
     * @param result s An ID-list of channels the given user is listening to
     */
    virtual void ice_response(const IntList& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_getListeningChannels> AMD_Server_getListeningChannelsPtr;

/**
 * AMD callback class for MumbleServer::Server::getListeningUsers_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_getListeningUsers : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_getListeningUsers();

    /**
     * Call ice_response for a successful completion.
     * @param result s An ID-list of users listening to the given channel
     */
    virtual void ice_response(const IntList& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_getListeningUsers> AMD_Server_getListeningUsersPtr;

/**
 * AMD callback class for MumbleServer::Server::getListenerVolumeAdjustment_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_getListenerVolumeAdjustment : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_getListenerVolumeAdjustment();

    /**
     * Call ice_response for a successful completion.
     * @param result s The volume adjustment set for a listener of the given user in the given channel
     */
    virtual void ice_response(::Ice::Float result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_getListenerVolumeAdjustment> AMD_Server_getListenerVolumeAdjustmentPtr;

/**
 * AMD callback class for MumbleServer::Server::setListenerVolumeAdjustment_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_setListenerVolumeAdjustment : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_setListenerVolumeAdjustment();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_setListenerVolumeAdjustment> AMD_Server_setListenerVolumeAdjustmentPtr;

/**
 * AMD callback class for MumbleServer::Server::sendWelcomeMessage_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_sendWelcomeMessage : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_sendWelcomeMessage();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Server_sendWelcomeMessage> AMD_Server_sendWelcomeMessagePtr;

/**
 * AMD callback class for MumbleServer::Meta::getServer_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Meta_getServer : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Meta_getServer();

    /**
     * Call ice_response for a successful completion.
     * @param result Interface for specified server, or a null proxy if id is invalid.
     */
    virtual void ice_response(const ServerPrx& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Meta_getServer> AMD_Meta_getServerPtr;

/**
 * AMD callback class for MumbleServer::Meta::newServer_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Meta_newServer : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Meta_newServer();

    /**
     * Call ice_response for a successful completion.
     * @param result Interface for new server.
     */
    virtual void ice_response(const ServerPrx& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Meta_newServer> AMD_Meta_newServerPtr;

/**
 * AMD callback class for MumbleServer::Meta::getBootedServers_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Meta_getBootedServers : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Meta_getBootedServers();

    /**
     * Call ice_response for a successful completion.
     * @param result List of interfaces for running servers.
     */
    virtual void ice_response(const ServerList& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Meta_getBootedServers> AMD_Meta_getBootedServersPtr;

/**
 * AMD callback class for MumbleServer::Meta::getAllServers_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Meta_getAllServers : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Meta_getAllServers();

    /**
     * Call ice_response for a successful completion.
     * @param result List of interfaces for all servers.
     */
    virtual void ice_response(const ServerList& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Meta_getAllServers> AMD_Meta_getAllServersPtr;

/**
 * AMD callback class for MumbleServer::Meta::getDefaultConf_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Meta_getDefaultConf : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Meta_getDefaultConf();

    /**
     * Call ice_response for a successful completion.
     * @param result Default configuration of the servers.
     */
    virtual void ice_response(const ConfigMap& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Meta_getDefaultConf> AMD_Meta_getDefaultConfPtr;

/**
 * AMD callback class for MumbleServer::Meta::getVersion_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Meta_getVersion : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Meta_getVersion();

    /**
     * Call ice_response for a successful completion.
     * @param major Major version.
     * @param minor Minor version.
     * @param patch Patchlevel.
     * @param text Textual representation of version. Note that this may not match the {@link major}, {@link minor} and {@link patch} levels, as it
     * may be simply the compile date or the SVN revision. This is usually the text you want to present to users.
     */
    virtual void ice_response(::Ice::Int major, ::Ice::Int minor, ::Ice::Int patch, const ::std::string& text) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Meta_getVersion> AMD_Meta_getVersionPtr;

/**
 * AMD callback class for MumbleServer::Meta::addCallback_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Meta_addCallback : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Meta_addCallback();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Meta_addCallback> AMD_Meta_addCallbackPtr;

/**
 * AMD callback class for MumbleServer::Meta::removeCallback_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Meta_removeCallback : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Meta_removeCallback();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Meta_removeCallback> AMD_Meta_removeCallbackPtr;

/**
 * AMD callback class for MumbleServer::Meta::getUptime_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Meta_getUptime : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Meta_getUptime();

    /**
     * Call ice_response for a successful completion.
     * @param result Uptime of murmur in seconds
     */
    virtual void ice_response(::Ice::Int result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Meta_getUptime> AMD_Meta_getUptimePtr;

/**
 * AMD callback class for MumbleServer::Meta::getSlice_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Meta_getSlice : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Meta_getSlice();

    /**
     * Call ice_response for a successful completion.
     * @param result Contents of the slice file server compiled with.
     */
    virtual void ice_response(const ::std::string& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Meta_getSlice> AMD_Meta_getSlicePtr;

/**
 * AMD callback class for MumbleServer::Meta::getSliceChecksums_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Meta_getSliceChecksums : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Meta_getSliceChecksums();

    /**
     * Call ice_response for a successful completion.
     * @param result Checksum dict
     */
    virtual void ice_response(const ::Ice::SliceChecksumDict& result) = 0;
};

typedef ::IceUtil::Handle< ::MumbleServer::AMD_Meta_getSliceChecksums> AMD_Meta_getSliceChecksumsPtr;

}

/// \cond INTERNAL
namespace IceAsync
{

namespace MumbleServer
{

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_isRunning : public ::MumbleServer::AMD_Server_isRunning, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_isRunning(::IceInternal::Incoming&);

    virtual void ice_response(bool);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_start : public ::MumbleServer::AMD_Server_start, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_start(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_stop : public ::MumbleServer::AMD_Server_stop, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_stop(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_delete : public ::MumbleServer::AMD_Server_delete, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_delete(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_id : public ::MumbleServer::AMD_Server_id, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_id(::IceInternal::Incoming&);

    virtual void ice_response(::Ice::Int);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_addCallback : public ::MumbleServer::AMD_Server_addCallback, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_addCallback(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_removeCallback : public ::MumbleServer::AMD_Server_removeCallback, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_removeCallback(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_setAuthenticator : public ::MumbleServer::AMD_Server_setAuthenticator, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_setAuthenticator(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_getConf : public ::MumbleServer::AMD_Server_getConf, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_getConf(::IceInternal::Incoming&);

    virtual void ice_response(const ::std::string&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_getAllConf : public ::MumbleServer::AMD_Server_getAllConf, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_getAllConf(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::ConfigMap&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_setConf : public ::MumbleServer::AMD_Server_setConf, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_setConf(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_setSuperuserPassword : public ::MumbleServer::AMD_Server_setSuperuserPassword, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_setSuperuserPassword(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_getLog : public ::MumbleServer::AMD_Server_getLog, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_getLog(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::LogList&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_getLogLen : public ::MumbleServer::AMD_Server_getLogLen, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_getLogLen(::IceInternal::Incoming&);

    virtual void ice_response(::Ice::Int);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_getUsers : public ::MumbleServer::AMD_Server_getUsers, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_getUsers(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::UserMap&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_getChannels : public ::MumbleServer::AMD_Server_getChannels, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_getChannels(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::ChannelMap&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_getCertificateList : public ::MumbleServer::AMD_Server_getCertificateList, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_getCertificateList(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::CertificateList&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_getTree : public ::MumbleServer::AMD_Server_getTree, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_getTree(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::TreePtr&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_getBans : public ::MumbleServer::AMD_Server_getBans, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_getBans(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::BanList&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_setBans : public ::MumbleServer::AMD_Server_setBans, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_setBans(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_kickUser : public ::MumbleServer::AMD_Server_kickUser, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_kickUser(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_getState : public ::MumbleServer::AMD_Server_getState, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_getState(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::User&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_setState : public ::MumbleServer::AMD_Server_setState, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_setState(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_sendMessage : public ::MumbleServer::AMD_Server_sendMessage, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_sendMessage(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_hasPermission : public ::MumbleServer::AMD_Server_hasPermission, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_hasPermission(::IceInternal::Incoming&);

    virtual void ice_response(bool);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_effectivePermissions : public ::MumbleServer::AMD_Server_effectivePermissions, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_effectivePermissions(::IceInternal::Incoming&);

    virtual void ice_response(::Ice::Int);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_addContextCallback : public ::MumbleServer::AMD_Server_addContextCallback, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_addContextCallback(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_removeContextCallback : public ::MumbleServer::AMD_Server_removeContextCallback, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_removeContextCallback(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_getChannelState : public ::MumbleServer::AMD_Server_getChannelState, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_getChannelState(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::Channel&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_setChannelState : public ::MumbleServer::AMD_Server_setChannelState, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_setChannelState(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_removeChannel : public ::MumbleServer::AMD_Server_removeChannel, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_removeChannel(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_addChannel : public ::MumbleServer::AMD_Server_addChannel, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_addChannel(::IceInternal::Incoming&);

    virtual void ice_response(::Ice::Int);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_sendMessageChannel : public ::MumbleServer::AMD_Server_sendMessageChannel, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_sendMessageChannel(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_getACL : public ::MumbleServer::AMD_Server_getACL, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_getACL(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::ACLList&, const ::MumbleServer::GroupList&, bool);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_setACL : public ::MumbleServer::AMD_Server_setACL, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_setACL(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_addUserToGroup : public ::MumbleServer::AMD_Server_addUserToGroup, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_addUserToGroup(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_removeUserFromGroup : public ::MumbleServer::AMD_Server_removeUserFromGroup, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_removeUserFromGroup(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_redirectWhisperGroup : public ::MumbleServer::AMD_Server_redirectWhisperGroup, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_redirectWhisperGroup(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_getUserNames : public ::MumbleServer::AMD_Server_getUserNames, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_getUserNames(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::NameMap&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_getUserIds : public ::MumbleServer::AMD_Server_getUserIds, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_getUserIds(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::IdMap&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_registerUser : public ::MumbleServer::AMD_Server_registerUser, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_registerUser(::IceInternal::Incoming&);

    virtual void ice_response(::Ice::Int);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_unregisterUser : public ::MumbleServer::AMD_Server_unregisterUser, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_unregisterUser(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_updateRegistration : public ::MumbleServer::AMD_Server_updateRegistration, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_updateRegistration(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_getRegistration : public ::MumbleServer::AMD_Server_getRegistration, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_getRegistration(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::UserInfoMap&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_getRegisteredUsers : public ::MumbleServer::AMD_Server_getRegisteredUsers, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_getRegisteredUsers(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::NameMap&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_verifyPassword : public ::MumbleServer::AMD_Server_verifyPassword, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_verifyPassword(::IceInternal::Incoming&);

    virtual void ice_response(::Ice::Int);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_getTexture : public ::MumbleServer::AMD_Server_getTexture, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_getTexture(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::Texture&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_setTexture : public ::MumbleServer::AMD_Server_setTexture, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_setTexture(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_getUptime : public ::MumbleServer::AMD_Server_getUptime, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_getUptime(::IceInternal::Incoming&);

    virtual void ice_response(::Ice::Int);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_updateCertificate : public ::MumbleServer::AMD_Server_updateCertificate, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_updateCertificate(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_startListening : public ::MumbleServer::AMD_Server_startListening, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_startListening(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_stopListening : public ::MumbleServer::AMD_Server_stopListening, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_stopListening(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_isListening : public ::MumbleServer::AMD_Server_isListening, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_isListening(::IceInternal::Incoming&);

    virtual void ice_response(bool);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_getListeningChannels : public ::MumbleServer::AMD_Server_getListeningChannels, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_getListeningChannels(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::IntList&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_getListeningUsers : public ::MumbleServer::AMD_Server_getListeningUsers, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_getListeningUsers(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::IntList&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_getListenerVolumeAdjustment : public ::MumbleServer::AMD_Server_getListenerVolumeAdjustment, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_getListenerVolumeAdjustment(::IceInternal::Incoming&);

    virtual void ice_response(::Ice::Float);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_setListenerVolumeAdjustment : public ::MumbleServer::AMD_Server_setListenerVolumeAdjustment, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_setListenerVolumeAdjustment(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_sendWelcomeMessage : public ::MumbleServer::AMD_Server_sendWelcomeMessage, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_sendWelcomeMessage(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Meta_getServer : public ::MumbleServer::AMD_Meta_getServer, public ::IceInternal::IncomingAsync
{
public:

    AMD_Meta_getServer(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::ServerPrx&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Meta_newServer : public ::MumbleServer::AMD_Meta_newServer, public ::IceInternal::IncomingAsync
{
public:

    AMD_Meta_newServer(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::ServerPrx&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Meta_getBootedServers : public ::MumbleServer::AMD_Meta_getBootedServers, public ::IceInternal::IncomingAsync
{
public:

    AMD_Meta_getBootedServers(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::ServerList&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Meta_getAllServers : public ::MumbleServer::AMD_Meta_getAllServers, public ::IceInternal::IncomingAsync
{
public:

    AMD_Meta_getAllServers(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::ServerList&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Meta_getDefaultConf : public ::MumbleServer::AMD_Meta_getDefaultConf, public ::IceInternal::IncomingAsync
{
public:

    AMD_Meta_getDefaultConf(::IceInternal::Incoming&);

    virtual void ice_response(const ::MumbleServer::ConfigMap&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Meta_getVersion : public ::MumbleServer::AMD_Meta_getVersion, public ::IceInternal::IncomingAsync
{
public:

    AMD_Meta_getVersion(::IceInternal::Incoming&);

    virtual void ice_response(::Ice::Int, ::Ice::Int, ::Ice::Int, const ::std::string&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Meta_addCallback : public ::MumbleServer::AMD_Meta_addCallback, public ::IceInternal::IncomingAsync
{
public:

    AMD_Meta_addCallback(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Meta_removeCallback : public ::MumbleServer::AMD_Meta_removeCallback, public ::IceInternal::IncomingAsync
{
public:

    AMD_Meta_removeCallback(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Meta_getUptime : public ::MumbleServer::AMD_Meta_getUptime, public ::IceInternal::IncomingAsync
{
public:

    AMD_Meta_getUptime(::IceInternal::Incoming&);

    virtual void ice_response(::Ice::Int);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Meta_getSlice : public ::MumbleServer::AMD_Meta_getSlice, public ::IceInternal::IncomingAsync
{
public:

    AMD_Meta_getSlice(::IceInternal::Incoming&);

    virtual void ice_response(const ::std::string&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Meta_getSliceChecksums : public ::MumbleServer::AMD_Meta_getSliceChecksums, public ::IceInternal::IncomingAsync
{
public:

    AMD_Meta_getSliceChecksums(::IceInternal::Incoming&);

    virtual void ice_response(const ::Ice::SliceChecksumDict&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

}

}
/// \endcond

namespace MumbleServer
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::ServerCallback::begin_userConnected.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerCallback_userConnected.
 */
class Callback_ServerCallback_userConnected_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServerCallback_userConnected_Base> Callback_ServerCallback_userConnectedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::ServerCallback::begin_userDisconnected.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerCallback_userDisconnected.
 */
class Callback_ServerCallback_userDisconnected_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServerCallback_userDisconnected_Base> Callback_ServerCallback_userDisconnectedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::ServerCallback::begin_userStateChanged.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerCallback_userStateChanged.
 */
class Callback_ServerCallback_userStateChanged_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServerCallback_userStateChanged_Base> Callback_ServerCallback_userStateChangedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::ServerCallback::begin_userTextMessage.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerCallback_userTextMessage.
 */
class Callback_ServerCallback_userTextMessage_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServerCallback_userTextMessage_Base> Callback_ServerCallback_userTextMessagePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::ServerCallback::begin_channelCreated.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerCallback_channelCreated.
 */
class Callback_ServerCallback_channelCreated_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServerCallback_channelCreated_Base> Callback_ServerCallback_channelCreatedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::ServerCallback::begin_channelRemoved.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerCallback_channelRemoved.
 */
class Callback_ServerCallback_channelRemoved_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServerCallback_channelRemoved_Base> Callback_ServerCallback_channelRemovedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::ServerCallback::begin_channelStateChanged.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerCallback_channelStateChanged.
 */
class Callback_ServerCallback_channelStateChanged_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServerCallback_channelStateChanged_Base> Callback_ServerCallback_channelStateChangedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::ServerContextCallback::begin_contextAction.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerContextCallback_contextAction.
 */
class Callback_ServerContextCallback_contextAction_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServerContextCallback_contextAction_Base> Callback_ServerContextCallback_contextActionPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::ServerAuthenticator::begin_authenticate.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerAuthenticator_authenticate.
 */
class Callback_ServerAuthenticator_authenticate_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServerAuthenticator_authenticate_Base> Callback_ServerAuthenticator_authenticatePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::ServerAuthenticator::begin_getInfo.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerAuthenticator_getInfo.
 */
class Callback_ServerAuthenticator_getInfo_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServerAuthenticator_getInfo_Base> Callback_ServerAuthenticator_getInfoPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::ServerAuthenticator::begin_nameToId.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerAuthenticator_nameToId.
 */
class Callback_ServerAuthenticator_nameToId_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServerAuthenticator_nameToId_Base> Callback_ServerAuthenticator_nameToIdPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::ServerAuthenticator::begin_idToName.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerAuthenticator_idToName.
 */
class Callback_ServerAuthenticator_idToName_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServerAuthenticator_idToName_Base> Callback_ServerAuthenticator_idToNamePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::ServerAuthenticator::begin_idToTexture.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerAuthenticator_idToTexture.
 */
class Callback_ServerAuthenticator_idToTexture_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServerAuthenticator_idToTexture_Base> Callback_ServerAuthenticator_idToTexturePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::ServerUpdatingAuthenticator::begin_registerUser.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerUpdatingAuthenticator_registerUser.
 */
class Callback_ServerUpdatingAuthenticator_registerUser_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServerUpdatingAuthenticator_registerUser_Base> Callback_ServerUpdatingAuthenticator_registerUserPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::ServerUpdatingAuthenticator::begin_unregisterUser.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerUpdatingAuthenticator_unregisterUser.
 */
class Callback_ServerUpdatingAuthenticator_unregisterUser_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServerUpdatingAuthenticator_unregisterUser_Base> Callback_ServerUpdatingAuthenticator_unregisterUserPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::ServerUpdatingAuthenticator::begin_getRegisteredUsers.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerUpdatingAuthenticator_getRegisteredUsers.
 */
class Callback_ServerUpdatingAuthenticator_getRegisteredUsers_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServerUpdatingAuthenticator_getRegisteredUsers_Base> Callback_ServerUpdatingAuthenticator_getRegisteredUsersPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::ServerUpdatingAuthenticator::begin_setInfo.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerUpdatingAuthenticator_setInfo.
 */
class Callback_ServerUpdatingAuthenticator_setInfo_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServerUpdatingAuthenticator_setInfo_Base> Callback_ServerUpdatingAuthenticator_setInfoPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::ServerUpdatingAuthenticator::begin_setTexture.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerUpdatingAuthenticator_setTexture.
 */
class Callback_ServerUpdatingAuthenticator_setTexture_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServerUpdatingAuthenticator_setTexture_Base> Callback_ServerUpdatingAuthenticator_setTexturePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_isRunning.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_isRunning.
 */
class Callback_Server_isRunning_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_isRunning_Base> Callback_Server_isRunningPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_start.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_start.
 */
class Callback_Server_start_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_start_Base> Callback_Server_startPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_stop.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_stop.
 */
class Callback_Server_stop_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_stop_Base> Callback_Server_stopPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_delete.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_delete.
 */
class Callback_Server_delete_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_delete_Base> Callback_Server_deletePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_id.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_id.
 */
class Callback_Server_id_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_id_Base> Callback_Server_idPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_addCallback.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_addCallback.
 */
class Callback_Server_addCallback_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_addCallback_Base> Callback_Server_addCallbackPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_removeCallback.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_removeCallback.
 */
class Callback_Server_removeCallback_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_removeCallback_Base> Callback_Server_removeCallbackPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_setAuthenticator.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_setAuthenticator.
 */
class Callback_Server_setAuthenticator_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_setAuthenticator_Base> Callback_Server_setAuthenticatorPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_getConf.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_getConf.
 */
class Callback_Server_getConf_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getConf_Base> Callback_Server_getConfPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_getAllConf.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_getAllConf.
 */
class Callback_Server_getAllConf_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getAllConf_Base> Callback_Server_getAllConfPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_setConf.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_setConf.
 */
class Callback_Server_setConf_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_setConf_Base> Callback_Server_setConfPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_setSuperuserPassword.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_setSuperuserPassword.
 */
class Callback_Server_setSuperuserPassword_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_setSuperuserPassword_Base> Callback_Server_setSuperuserPasswordPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_getLog.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_getLog.
 */
class Callback_Server_getLog_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getLog_Base> Callback_Server_getLogPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_getLogLen.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_getLogLen.
 */
class Callback_Server_getLogLen_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getLogLen_Base> Callback_Server_getLogLenPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_getUsers.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_getUsers.
 */
class Callback_Server_getUsers_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getUsers_Base> Callback_Server_getUsersPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_getChannels.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_getChannels.
 */
class Callback_Server_getChannels_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getChannels_Base> Callback_Server_getChannelsPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_getCertificateList.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_getCertificateList.
 */
class Callback_Server_getCertificateList_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getCertificateList_Base> Callback_Server_getCertificateListPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_getTree.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_getTree.
 */
class Callback_Server_getTree_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getTree_Base> Callback_Server_getTreePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_getBans.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_getBans.
 */
class Callback_Server_getBans_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getBans_Base> Callback_Server_getBansPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_setBans.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_setBans.
 */
class Callback_Server_setBans_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_setBans_Base> Callback_Server_setBansPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_kickUser.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_kickUser.
 */
class Callback_Server_kickUser_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_kickUser_Base> Callback_Server_kickUserPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_getState.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_getState.
 */
class Callback_Server_getState_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getState_Base> Callback_Server_getStatePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_setState.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_setState.
 */
class Callback_Server_setState_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_setState_Base> Callback_Server_setStatePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_sendMessage.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_sendMessage.
 */
class Callback_Server_sendMessage_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_sendMessage_Base> Callback_Server_sendMessagePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_hasPermission.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_hasPermission.
 */
class Callback_Server_hasPermission_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_hasPermission_Base> Callback_Server_hasPermissionPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_effectivePermissions.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_effectivePermissions.
 */
class Callback_Server_effectivePermissions_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_effectivePermissions_Base> Callback_Server_effectivePermissionsPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_addContextCallback.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_addContextCallback.
 */
class Callback_Server_addContextCallback_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_addContextCallback_Base> Callback_Server_addContextCallbackPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_removeContextCallback.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_removeContextCallback.
 */
class Callback_Server_removeContextCallback_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_removeContextCallback_Base> Callback_Server_removeContextCallbackPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_getChannelState.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_getChannelState.
 */
class Callback_Server_getChannelState_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getChannelState_Base> Callback_Server_getChannelStatePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_setChannelState.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_setChannelState.
 */
class Callback_Server_setChannelState_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_setChannelState_Base> Callback_Server_setChannelStatePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_removeChannel.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_removeChannel.
 */
class Callback_Server_removeChannel_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_removeChannel_Base> Callback_Server_removeChannelPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_addChannel.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_addChannel.
 */
class Callback_Server_addChannel_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_addChannel_Base> Callback_Server_addChannelPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_sendMessageChannel.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_sendMessageChannel.
 */
class Callback_Server_sendMessageChannel_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_sendMessageChannel_Base> Callback_Server_sendMessageChannelPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_getACL.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_getACL.
 */
class Callback_Server_getACL_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getACL_Base> Callback_Server_getACLPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_setACL.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_setACL.
 */
class Callback_Server_setACL_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_setACL_Base> Callback_Server_setACLPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_addUserToGroup.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_addUserToGroup.
 */
class Callback_Server_addUserToGroup_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_addUserToGroup_Base> Callback_Server_addUserToGroupPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_removeUserFromGroup.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_removeUserFromGroup.
 */
class Callback_Server_removeUserFromGroup_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_removeUserFromGroup_Base> Callback_Server_removeUserFromGroupPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_redirectWhisperGroup.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_redirectWhisperGroup.
 */
class Callback_Server_redirectWhisperGroup_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_redirectWhisperGroup_Base> Callback_Server_redirectWhisperGroupPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_getUserNames.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_getUserNames.
 */
class Callback_Server_getUserNames_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getUserNames_Base> Callback_Server_getUserNamesPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_getUserIds.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_getUserIds.
 */
class Callback_Server_getUserIds_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getUserIds_Base> Callback_Server_getUserIdsPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_registerUser.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_registerUser.
 */
class Callback_Server_registerUser_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_registerUser_Base> Callback_Server_registerUserPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_unregisterUser.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_unregisterUser.
 */
class Callback_Server_unregisterUser_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_unregisterUser_Base> Callback_Server_unregisterUserPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_updateRegistration.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_updateRegistration.
 */
class Callback_Server_updateRegistration_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_updateRegistration_Base> Callback_Server_updateRegistrationPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_getRegistration.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_getRegistration.
 */
class Callback_Server_getRegistration_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getRegistration_Base> Callback_Server_getRegistrationPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_getRegisteredUsers.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_getRegisteredUsers.
 */
class Callback_Server_getRegisteredUsers_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getRegisteredUsers_Base> Callback_Server_getRegisteredUsersPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_verifyPassword.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_verifyPassword.
 */
class Callback_Server_verifyPassword_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_verifyPassword_Base> Callback_Server_verifyPasswordPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_getTexture.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_getTexture.
 */
class Callback_Server_getTexture_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getTexture_Base> Callback_Server_getTexturePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_setTexture.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_setTexture.
 */
class Callback_Server_setTexture_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_setTexture_Base> Callback_Server_setTexturePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_getUptime.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_getUptime.
 */
class Callback_Server_getUptime_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getUptime_Base> Callback_Server_getUptimePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_updateCertificate.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_updateCertificate.
 */
class Callback_Server_updateCertificate_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_updateCertificate_Base> Callback_Server_updateCertificatePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_startListening.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_startListening.
 */
class Callback_Server_startListening_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_startListening_Base> Callback_Server_startListeningPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_stopListening.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_stopListening.
 */
class Callback_Server_stopListening_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_stopListening_Base> Callback_Server_stopListeningPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_isListening.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_isListening.
 */
class Callback_Server_isListening_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_isListening_Base> Callback_Server_isListeningPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_getListeningChannels.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_getListeningChannels.
 */
class Callback_Server_getListeningChannels_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getListeningChannels_Base> Callback_Server_getListeningChannelsPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_getListeningUsers.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_getListeningUsers.
 */
class Callback_Server_getListeningUsers_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getListeningUsers_Base> Callback_Server_getListeningUsersPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_getListenerVolumeAdjustment.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_getListenerVolumeAdjustment.
 */
class Callback_Server_getListenerVolumeAdjustment_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getListenerVolumeAdjustment_Base> Callback_Server_getListenerVolumeAdjustmentPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_setListenerVolumeAdjustment.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_setListenerVolumeAdjustment.
 */
class Callback_Server_setListenerVolumeAdjustment_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_setListenerVolumeAdjustment_Base> Callback_Server_setListenerVolumeAdjustmentPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Server::begin_sendWelcomeMessage.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Server_sendWelcomeMessage.
 */
class Callback_Server_sendWelcomeMessage_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_sendWelcomeMessage_Base> Callback_Server_sendWelcomeMessagePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::MetaCallback::begin_started.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_MetaCallback_started.
 */
class Callback_MetaCallback_started_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_MetaCallback_started_Base> Callback_MetaCallback_startedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::MetaCallback::begin_stopped.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_MetaCallback_stopped.
 */
class Callback_MetaCallback_stopped_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_MetaCallback_stopped_Base> Callback_MetaCallback_stoppedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Meta::begin_getServer.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Meta_getServer.
 */
class Callback_Meta_getServer_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Meta_getServer_Base> Callback_Meta_getServerPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Meta::begin_newServer.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Meta_newServer.
 */
class Callback_Meta_newServer_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Meta_newServer_Base> Callback_Meta_newServerPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Meta::begin_getBootedServers.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Meta_getBootedServers.
 */
class Callback_Meta_getBootedServers_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Meta_getBootedServers_Base> Callback_Meta_getBootedServersPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Meta::begin_getAllServers.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Meta_getAllServers.
 */
class Callback_Meta_getAllServers_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Meta_getAllServers_Base> Callback_Meta_getAllServersPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Meta::begin_getDefaultConf.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Meta_getDefaultConf.
 */
class Callback_Meta_getDefaultConf_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Meta_getDefaultConf_Base> Callback_Meta_getDefaultConfPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Meta::begin_getVersion.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Meta_getVersion.
 */
class Callback_Meta_getVersion_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Meta_getVersion_Base> Callback_Meta_getVersionPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Meta::begin_addCallback.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Meta_addCallback.
 */
class Callback_Meta_addCallback_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Meta_addCallback_Base> Callback_Meta_addCallbackPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Meta::begin_removeCallback.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Meta_removeCallback.
 */
class Callback_Meta_removeCallback_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Meta_removeCallback_Base> Callback_Meta_removeCallbackPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Meta::begin_getUptime.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Meta_getUptime.
 */
class Callback_Meta_getUptime_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Meta_getUptime_Base> Callback_Meta_getUptimePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Meta::begin_getSlice.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Meta_getSlice.
 */
class Callback_Meta_getSlice_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Meta_getSlice_Base> Callback_Meta_getSlicePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::MumbleServer::Meta::begin_getSliceChecksums.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_Meta_getSliceChecksums.
 */
class Callback_Meta_getSliceChecksums_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Meta_getSliceChecksums_Base> Callback_Meta_getSliceChecksumsPtr;

}

namespace IceProxy
{

namespace MumbleServer
{

class Tree : public virtual ::Ice::Proxy<Tree, ::IceProxy::Ice::Object>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ServerCallback : public virtual ::Ice::Proxy<ServerCallback, ::IceProxy::Ice::Object>
{
public:

    /**
     * Called when a user connects to the server.
     * @param state State of connected user.
     * @param context The Context map to send with the invocation.
     */
    void userConnected(const ::MumbleServer::User& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_userConnected(_iceI_begin_userConnected(state, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Called when a user connects to the server.
     * @param state State of connected user.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_userConnected(const ::MumbleServer::User& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_userConnected(state, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Called when a user connects to the server.
     * @param state State of connected user.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_userConnected(const ::MumbleServer::User& state, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_userConnected(state, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called when a user connects to the server.
     * @param state State of connected user.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_userConnected(const ::MumbleServer::User& state, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_userConnected(state, context, cb, cookie);
    }

    /**
     * Called when a user connects to the server.
     * @param state State of connected user.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_userConnected(const ::MumbleServer::User& state, const ::MumbleServer::Callback_ServerCallback_userConnectedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_userConnected(state, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called when a user connects to the server.
     * @param state State of connected user.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_userConnected(const ::MumbleServer::User& state, const ::Ice::Context& context, const ::MumbleServer::Callback_ServerCallback_userConnectedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_userConnected(state, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_userConnected.
     * @param result The asynchronous result object for the invocation.
     */
    void end_userConnected(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_userConnected(const ::MumbleServer::User&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Called when a user disconnects from the server. The user has already been removed, so you can no longer use methods like {@link Server.getState}
     * to retrieve the user's state.
     * @param state State of disconnected user.
     * @param context The Context map to send with the invocation.
     */
    void userDisconnected(const ::MumbleServer::User& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_userDisconnected(_iceI_begin_userDisconnected(state, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Called when a user disconnects from the server. The user has already been removed, so you can no longer use methods like {@link Server.getState}
     * to retrieve the user's state.
     * @param state State of disconnected user.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_userDisconnected(const ::MumbleServer::User& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_userDisconnected(state, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Called when a user disconnects from the server. The user has already been removed, so you can no longer use methods like {@link Server.getState}
     * to retrieve the user's state.
     * @param state State of disconnected user.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_userDisconnected(const ::MumbleServer::User& state, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_userDisconnected(state, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called when a user disconnects from the server. The user has already been removed, so you can no longer use methods like {@link Server.getState}
     * to retrieve the user's state.
     * @param state State of disconnected user.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_userDisconnected(const ::MumbleServer::User& state, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_userDisconnected(state, context, cb, cookie);
    }

    /**
     * Called when a user disconnects from the server. The user has already been removed, so you can no longer use methods like {@link Server.getState}
     * to retrieve the user's state.
     * @param state State of disconnected user.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_userDisconnected(const ::MumbleServer::User& state, const ::MumbleServer::Callback_ServerCallback_userDisconnectedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_userDisconnected(state, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called when a user disconnects from the server. The user has already been removed, so you can no longer use methods like {@link Server.getState}
     * to retrieve the user's state.
     * @param state State of disconnected user.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_userDisconnected(const ::MumbleServer::User& state, const ::Ice::Context& context, const ::MumbleServer::Callback_ServerCallback_userDisconnectedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_userDisconnected(state, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_userDisconnected.
     * @param result The asynchronous result object for the invocation.
     */
    void end_userDisconnected(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_userDisconnected(const ::MumbleServer::User&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Called when a user state changes. This is called if the user moves, is renamed, is muted, deafened etc.
     * @param state New state of user.
     * @param context The Context map to send with the invocation.
     */
    void userStateChanged(const ::MumbleServer::User& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_userStateChanged(_iceI_begin_userStateChanged(state, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Called when a user state changes. This is called if the user moves, is renamed, is muted, deafened etc.
     * @param state New state of user.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_userStateChanged(const ::MumbleServer::User& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_userStateChanged(state, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Called when a user state changes. This is called if the user moves, is renamed, is muted, deafened etc.
     * @param state New state of user.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_userStateChanged(const ::MumbleServer::User& state, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_userStateChanged(state, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called when a user state changes. This is called if the user moves, is renamed, is muted, deafened etc.
     * @param state New state of user.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_userStateChanged(const ::MumbleServer::User& state, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_userStateChanged(state, context, cb, cookie);
    }

    /**
     * Called when a user state changes. This is called if the user moves, is renamed, is muted, deafened etc.
     * @param state New state of user.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_userStateChanged(const ::MumbleServer::User& state, const ::MumbleServer::Callback_ServerCallback_userStateChangedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_userStateChanged(state, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called when a user state changes. This is called if the user moves, is renamed, is muted, deafened etc.
     * @param state New state of user.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_userStateChanged(const ::MumbleServer::User& state, const ::Ice::Context& context, const ::MumbleServer::Callback_ServerCallback_userStateChangedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_userStateChanged(state, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_userStateChanged.
     * @param result The asynchronous result object for the invocation.
     */
    void end_userStateChanged(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_userStateChanged(const ::MumbleServer::User&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Called when user writes a text message
     * @param state the User sending the message
     * @param message the TextMessage the user has sent
     * @param context The Context map to send with the invocation.
     */
    void userTextMessage(const ::MumbleServer::User& state, const ::MumbleServer::TextMessage& message, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_userTextMessage(_iceI_begin_userTextMessage(state, message, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Called when user writes a text message
     * @param state the User sending the message
     * @param message the TextMessage the user has sent
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_userTextMessage(const ::MumbleServer::User& state, const ::MumbleServer::TextMessage& message, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_userTextMessage(state, message, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Called when user writes a text message
     * @param state the User sending the message
     * @param message the TextMessage the user has sent
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_userTextMessage(const ::MumbleServer::User& state, const ::MumbleServer::TextMessage& message, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_userTextMessage(state, message, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called when user writes a text message
     * @param state the User sending the message
     * @param message the TextMessage the user has sent
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_userTextMessage(const ::MumbleServer::User& state, const ::MumbleServer::TextMessage& message, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_userTextMessage(state, message, context, cb, cookie);
    }

    /**
     * Called when user writes a text message
     * @param state the User sending the message
     * @param message the TextMessage the user has sent
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_userTextMessage(const ::MumbleServer::User& state, const ::MumbleServer::TextMessage& message, const ::MumbleServer::Callback_ServerCallback_userTextMessagePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_userTextMessage(state, message, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called when user writes a text message
     * @param state the User sending the message
     * @param message the TextMessage the user has sent
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_userTextMessage(const ::MumbleServer::User& state, const ::MumbleServer::TextMessage& message, const ::Ice::Context& context, const ::MumbleServer::Callback_ServerCallback_userTextMessagePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_userTextMessage(state, message, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_userTextMessage.
     * @param result The asynchronous result object for the invocation.
     */
    void end_userTextMessage(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_userTextMessage(const ::MumbleServer::User&, const ::MumbleServer::TextMessage&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Called when a new channel is created.
     * @param state State of new channel.
     * @param context The Context map to send with the invocation.
     */
    void channelCreated(const ::MumbleServer::Channel& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_channelCreated(_iceI_begin_channelCreated(state, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Called when a new channel is created.
     * @param state State of new channel.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_channelCreated(const ::MumbleServer::Channel& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_channelCreated(state, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Called when a new channel is created.
     * @param state State of new channel.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_channelCreated(const ::MumbleServer::Channel& state, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_channelCreated(state, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called when a new channel is created.
     * @param state State of new channel.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_channelCreated(const ::MumbleServer::Channel& state, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_channelCreated(state, context, cb, cookie);
    }

    /**
     * Called when a new channel is created.
     * @param state State of new channel.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_channelCreated(const ::MumbleServer::Channel& state, const ::MumbleServer::Callback_ServerCallback_channelCreatedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_channelCreated(state, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called when a new channel is created.
     * @param state State of new channel.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_channelCreated(const ::MumbleServer::Channel& state, const ::Ice::Context& context, const ::MumbleServer::Callback_ServerCallback_channelCreatedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_channelCreated(state, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_channelCreated.
     * @param result The asynchronous result object for the invocation.
     */
    void end_channelCreated(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_channelCreated(const ::MumbleServer::Channel&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Called when a channel is removed. The channel has already been removed, you can no longer use methods like {@link Server.getChannelState}
     * @param state State of removed channel.
     * @param context The Context map to send with the invocation.
     */
    void channelRemoved(const ::MumbleServer::Channel& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_channelRemoved(_iceI_begin_channelRemoved(state, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Called when a channel is removed. The channel has already been removed, you can no longer use methods like {@link Server.getChannelState}
     * @param state State of removed channel.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_channelRemoved(const ::MumbleServer::Channel& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_channelRemoved(state, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Called when a channel is removed. The channel has already been removed, you can no longer use methods like {@link Server.getChannelState}
     * @param state State of removed channel.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_channelRemoved(const ::MumbleServer::Channel& state, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_channelRemoved(state, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called when a channel is removed. The channel has already been removed, you can no longer use methods like {@link Server.getChannelState}
     * @param state State of removed channel.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_channelRemoved(const ::MumbleServer::Channel& state, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_channelRemoved(state, context, cb, cookie);
    }

    /**
     * Called when a channel is removed. The channel has already been removed, you can no longer use methods like {@link Server.getChannelState}
     * @param state State of removed channel.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_channelRemoved(const ::MumbleServer::Channel& state, const ::MumbleServer::Callback_ServerCallback_channelRemovedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_channelRemoved(state, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called when a channel is removed. The channel has already been removed, you can no longer use methods like {@link Server.getChannelState}
     * @param state State of removed channel.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_channelRemoved(const ::MumbleServer::Channel& state, const ::Ice::Context& context, const ::MumbleServer::Callback_ServerCallback_channelRemovedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_channelRemoved(state, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_channelRemoved.
     * @param result The asynchronous result object for the invocation.
     */
    void end_channelRemoved(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_channelRemoved(const ::MumbleServer::Channel&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Called when a new channel state changes. This is called if the channel is moved, renamed or if new links are added.
     * @param state New state of channel.
     * @param context The Context map to send with the invocation.
     */
    void channelStateChanged(const ::MumbleServer::Channel& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_channelStateChanged(_iceI_begin_channelStateChanged(state, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Called when a new channel state changes. This is called if the channel is moved, renamed or if new links are added.
     * @param state New state of channel.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_channelStateChanged(const ::MumbleServer::Channel& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_channelStateChanged(state, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Called when a new channel state changes. This is called if the channel is moved, renamed or if new links are added.
     * @param state New state of channel.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_channelStateChanged(const ::MumbleServer::Channel& state, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_channelStateChanged(state, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called when a new channel state changes. This is called if the channel is moved, renamed or if new links are added.
     * @param state New state of channel.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_channelStateChanged(const ::MumbleServer::Channel& state, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_channelStateChanged(state, context, cb, cookie);
    }

    /**
     * Called when a new channel state changes. This is called if the channel is moved, renamed or if new links are added.
     * @param state New state of channel.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_channelStateChanged(const ::MumbleServer::Channel& state, const ::MumbleServer::Callback_ServerCallback_channelStateChangedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_channelStateChanged(state, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called when a new channel state changes. This is called if the channel is moved, renamed or if new links are added.
     * @param state New state of channel.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_channelStateChanged(const ::MumbleServer::Channel& state, const ::Ice::Context& context, const ::MumbleServer::Callback_ServerCallback_channelStateChangedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_channelStateChanged(state, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_channelStateChanged.
     * @param result The asynchronous result object for the invocation.
     */
    void end_channelStateChanged(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_channelStateChanged(const ::MumbleServer::Channel&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ServerContextCallback : public virtual ::Ice::Proxy<ServerContextCallback, ::IceProxy::Ice::Object>
{
public:

    /**
     * Called when a context action is performed.
     * @param action Action to be performed.
     * @param usr User which initiated the action.
     * @param session If nonzero, session of target user.
     * @param channelid If not -1, id of target channel.
     * @param context The Context map to send with the invocation.
     */
    void contextAction(const ::std::string& action, const ::MumbleServer::User& usr, ::Ice::Int session, ::Ice::Int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_contextAction(_iceI_begin_contextAction(action, usr, session, channelid, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Called when a context action is performed.
     * @param action Action to be performed.
     * @param usr User which initiated the action.
     * @param session If nonzero, session of target user.
     * @param channelid If not -1, id of target channel.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_contextAction(const ::std::string& action, const ::MumbleServer::User& usr, ::Ice::Int session, ::Ice::Int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_contextAction(action, usr, session, channelid, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Called when a context action is performed.
     * @param action Action to be performed.
     * @param usr User which initiated the action.
     * @param session If nonzero, session of target user.
     * @param channelid If not -1, id of target channel.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_contextAction(const ::std::string& action, const ::MumbleServer::User& usr, ::Ice::Int session, ::Ice::Int channelid, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_contextAction(action, usr, session, channelid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called when a context action is performed.
     * @param action Action to be performed.
     * @param usr User which initiated the action.
     * @param session If nonzero, session of target user.
     * @param channelid If not -1, id of target channel.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_contextAction(const ::std::string& action, const ::MumbleServer::User& usr, ::Ice::Int session, ::Ice::Int channelid, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_contextAction(action, usr, session, channelid, context, cb, cookie);
    }

    /**
     * Called when a context action is performed.
     * @param action Action to be performed.
     * @param usr User which initiated the action.
     * @param session If nonzero, session of target user.
     * @param channelid If not -1, id of target channel.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_contextAction(const ::std::string& action, const ::MumbleServer::User& usr, ::Ice::Int session, ::Ice::Int channelid, const ::MumbleServer::Callback_ServerContextCallback_contextActionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_contextAction(action, usr, session, channelid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called when a context action is performed.
     * @param action Action to be performed.
     * @param usr User which initiated the action.
     * @param session If nonzero, session of target user.
     * @param channelid If not -1, id of target channel.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_contextAction(const ::std::string& action, const ::MumbleServer::User& usr, ::Ice::Int session, ::Ice::Int channelid, const ::Ice::Context& context, const ::MumbleServer::Callback_ServerContextCallback_contextActionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_contextAction(action, usr, session, channelid, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_contextAction.
     * @param result The asynchronous result object for the invocation.
     */
    void end_contextAction(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_contextAction(const ::std::string&, const ::MumbleServer::User&, ::Ice::Int, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ServerAuthenticator : public virtual ::Ice::Proxy<ServerAuthenticator, ::IceProxy::Ice::Object>
{
public:

    /**
     * Called to authenticate a user. If you do not know the username in question, always return -2 from this
     * method to fall through to normal database authentication.
     * Note that if authentication succeeds, murmur will create a record of the user in it's database, reserving
     * the username and id so it cannot be used for normal database authentication.
     * The data in the certificate (name, email addresses etc), as well as the list of signing certificates,
     * should only be trusted if certstrong is true.
     *
     * Internally, Murmur treats usernames as case-insensitive. It is recommended
     * that authenticators do the same. Murmur checks if a username is in use when
     * a user connects. If the connecting user is registered, the other username is
     * kicked. If the connecting user is not registered, the connecting user is not
     * allowed to join the server.
     * @param name Username to authenticate.
     * @param pw Password to authenticate with.
     * @param certificates List of der encoded certificates the user connected with.
     * @param certhash Hash of user certificate, as used by murmur internally when matching.
     * @param certstrong True if certificate was valid and signed by a trusted CA.
     * @param newname Set this to change the username from the supplied one.
     * @param groups List of groups on the root channel that the user will be added to for the duration of the connection.
     * @param context The Context map to send with the invocation.
     * @return UserID of authenticated user, -1 for authentication failures, -2 for unknown user (fallthrough),
     * -3 for authentication failures where the data could (temporarily) not be verified.
     */
    ::Ice::Int authenticate(const ::std::string& name, const ::std::string& pw, const ::MumbleServer::CertificateList& certificates, const ::std::string& certhash, bool certstrong, ::std::string& newname, ::MumbleServer::GroupNameList& groups, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_authenticate(newname, groups, _iceI_begin_authenticate(name, pw, certificates, certhash, certstrong, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Called to authenticate a user. If you do not know the username in question, always return -2 from this
     * method to fall through to normal database authentication.
     * Note that if authentication succeeds, murmur will create a record of the user in it's database, reserving
     * the username and id so it cannot be used for normal database authentication.
     * The data in the certificate (name, email addresses etc), as well as the list of signing certificates,
     * should only be trusted if certstrong is true.
     *
     * Internally, Murmur treats usernames as case-insensitive. It is recommended
     * that authenticators do the same. Murmur checks if a username is in use when
     * a user connects. If the connecting user is registered, the other username is
     * kicked. If the connecting user is not registered, the connecting user is not
     * allowed to join the server.
     * @param name Username to authenticate.
     * @param pw Password to authenticate with.
     * @param certificates List of der encoded certificates the user connected with.
     * @param certhash Hash of user certificate, as used by murmur internally when matching.
     * @param certstrong True if certificate was valid and signed by a trusted CA.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_authenticate(const ::std::string& name, const ::std::string& pw, const ::MumbleServer::CertificateList& certificates, const ::std::string& certhash, bool certstrong, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_authenticate(name, pw, certificates, certhash, certstrong, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Called to authenticate a user. If you do not know the username in question, always return -2 from this
     * method to fall through to normal database authentication.
     * Note that if authentication succeeds, murmur will create a record of the user in it's database, reserving
     * the username and id so it cannot be used for normal database authentication.
     * The data in the certificate (name, email addresses etc), as well as the list of signing certificates,
     * should only be trusted if certstrong is true.
     *
     * Internally, Murmur treats usernames as case-insensitive. It is recommended
     * that authenticators do the same. Murmur checks if a username is in use when
     * a user connects. If the connecting user is registered, the other username is
     * kicked. If the connecting user is not registered, the connecting user is not
     * allowed to join the server.
     * @param name Username to authenticate.
     * @param pw Password to authenticate with.
     * @param certificates List of der encoded certificates the user connected with.
     * @param certhash Hash of user certificate, as used by murmur internally when matching.
     * @param certstrong True if certificate was valid and signed by a trusted CA.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_authenticate(const ::std::string& name, const ::std::string& pw, const ::MumbleServer::CertificateList& certificates, const ::std::string& certhash, bool certstrong, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_authenticate(name, pw, certificates, certhash, certstrong, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called to authenticate a user. If you do not know the username in question, always return -2 from this
     * method to fall through to normal database authentication.
     * Note that if authentication succeeds, murmur will create a record of the user in it's database, reserving
     * the username and id so it cannot be used for normal database authentication.
     * The data in the certificate (name, email addresses etc), as well as the list of signing certificates,
     * should only be trusted if certstrong is true.
     *
     * Internally, Murmur treats usernames as case-insensitive. It is recommended
     * that authenticators do the same. Murmur checks if a username is in use when
     * a user connects. If the connecting user is registered, the other username is
     * kicked. If the connecting user is not registered, the connecting user is not
     * allowed to join the server.
     * @param name Username to authenticate.
     * @param pw Password to authenticate with.
     * @param certificates List of der encoded certificates the user connected with.
     * @param certhash Hash of user certificate, as used by murmur internally when matching.
     * @param certstrong True if certificate was valid and signed by a trusted CA.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_authenticate(const ::std::string& name, const ::std::string& pw, const ::MumbleServer::CertificateList& certificates, const ::std::string& certhash, bool certstrong, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_authenticate(name, pw, certificates, certhash, certstrong, context, cb, cookie);
    }

    /**
     * Called to authenticate a user. If you do not know the username in question, always return -2 from this
     * method to fall through to normal database authentication.
     * Note that if authentication succeeds, murmur will create a record of the user in it's database, reserving
     * the username and id so it cannot be used for normal database authentication.
     * The data in the certificate (name, email addresses etc), as well as the list of signing certificates,
     * should only be trusted if certstrong is true.
     *
     * Internally, Murmur treats usernames as case-insensitive. It is recommended
     * that authenticators do the same. Murmur checks if a username is in use when
     * a user connects. If the connecting user is registered, the other username is
     * kicked. If the connecting user is not registered, the connecting user is not
     * allowed to join the server.
     * @param name Username to authenticate.
     * @param pw Password to authenticate with.
     * @param certificates List of der encoded certificates the user connected with.
     * @param certhash Hash of user certificate, as used by murmur internally when matching.
     * @param certstrong True if certificate was valid and signed by a trusted CA.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_authenticate(const ::std::string& name, const ::std::string& pw, const ::MumbleServer::CertificateList& certificates, const ::std::string& certhash, bool certstrong, const ::MumbleServer::Callback_ServerAuthenticator_authenticatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_authenticate(name, pw, certificates, certhash, certstrong, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called to authenticate a user. If you do not know the username in question, always return -2 from this
     * method to fall through to normal database authentication.
     * Note that if authentication succeeds, murmur will create a record of the user in it's database, reserving
     * the username and id so it cannot be used for normal database authentication.
     * The data in the certificate (name, email addresses etc), as well as the list of signing certificates,
     * should only be trusted if certstrong is true.
     *
     * Internally, Murmur treats usernames as case-insensitive. It is recommended
     * that authenticators do the same. Murmur checks if a username is in use when
     * a user connects. If the connecting user is registered, the other username is
     * kicked. If the connecting user is not registered, the connecting user is not
     * allowed to join the server.
     * @param name Username to authenticate.
     * @param pw Password to authenticate with.
     * @param certificates List of der encoded certificates the user connected with.
     * @param certhash Hash of user certificate, as used by murmur internally when matching.
     * @param certstrong True if certificate was valid and signed by a trusted CA.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_authenticate(const ::std::string& name, const ::std::string& pw, const ::MumbleServer::CertificateList& certificates, const ::std::string& certhash, bool certstrong, const ::Ice::Context& context, const ::MumbleServer::Callback_ServerAuthenticator_authenticatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_authenticate(name, pw, certificates, certhash, certstrong, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_authenticate.
     * @param newname Set this to change the username from the supplied one.
     * @param groups List of groups on the root channel that the user will be added to for the duration of the connection.
     * @param result The asynchronous result object for the invocation.
     * @return UserID of authenticated user, -1 for authentication failures, -2 for unknown user (fallthrough),
     * -3 for authentication failures where the data could (temporarily) not be verified.
     */
    ::Ice::Int end_authenticate(::std::string& newname, ::MumbleServer::GroupNameList& groups, const ::Ice::AsyncResultPtr& result);
    /// \cond INTERNAL

    void _iceI_end_authenticate(::std::string& iceP_newname, ::MumbleServer::GroupNameList& iceP_groups, ::Ice::Int& ret, const ::Ice::AsyncResultPtr&);
    /// \endcond

private:

    ::Ice::AsyncResultPtr _iceI_begin_authenticate(const ::std::string&, const ::std::string&, const ::MumbleServer::CertificateList&, const ::std::string&, bool, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Fetch information about a user. This is used to retrieve information like email address, keyhash etc. If you
     * want murmur to take care of this information itself, simply return false to fall through.
     * @param id User id.
     * @param info Information about user. This needs to include at least "name".
     * @param context The Context map to send with the invocation.
     * @return true if information is present, false to fall through.
     */
    bool getInfo(::Ice::Int id, ::MumbleServer::UserInfoMap& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getInfo(info, _iceI_begin_getInfo(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Fetch information about a user. This is used to retrieve information like email address, keyhash etc. If you
     * want murmur to take care of this information itself, simply return false to fall through.
     * @param id User id.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getInfo(::Ice::Int id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getInfo(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Fetch information about a user. This is used to retrieve information like email address, keyhash etc. If you
     * want murmur to take care of this information itself, simply return false to fall through.
     * @param id User id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getInfo(::Ice::Int id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getInfo(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch information about a user. This is used to retrieve information like email address, keyhash etc. If you
     * want murmur to take care of this information itself, simply return false to fall through.
     * @param id User id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getInfo(::Ice::Int id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getInfo(id, context, cb, cookie);
    }

    /**
     * Fetch information about a user. This is used to retrieve information like email address, keyhash etc. If you
     * want murmur to take care of this information itself, simply return false to fall through.
     * @param id User id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getInfo(::Ice::Int id, const ::MumbleServer::Callback_ServerAuthenticator_getInfoPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getInfo(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch information about a user. This is used to retrieve information like email address, keyhash etc. If you
     * want murmur to take care of this information itself, simply return false to fall through.
     * @param id User id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getInfo(::Ice::Int id, const ::Ice::Context& context, const ::MumbleServer::Callback_ServerAuthenticator_getInfoPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getInfo(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getInfo.
     * @param info Information about user. This needs to include at least "name".
     * @param result The asynchronous result object for the invocation.
     * @return true if information is present, false to fall through.
     */
    bool end_getInfo(::MumbleServer::UserInfoMap& info, const ::Ice::AsyncResultPtr& result);
    /// \cond INTERNAL

    void _iceI_end_getInfo(::MumbleServer::UserInfoMap& iceP_info, bool& ret, const ::Ice::AsyncResultPtr&);
    /// \endcond

private:

    ::Ice::AsyncResultPtr _iceI_begin_getInfo(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Map a name to a user id.
     * @param name Username to map.
     * @param context The Context map to send with the invocation.
     * @return User id or -2 for unknown name.
     */
    ::Ice::Int nameToId(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_nameToId(_iceI_begin_nameToId(name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Map a name to a user id.
     * @param name Username to map.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nameToId(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_nameToId(name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Map a name to a user id.
     * @param name Username to map.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nameToId(const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nameToId(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Map a name to a user id.
     * @param name Username to map.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nameToId(const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nameToId(name, context, cb, cookie);
    }

    /**
     * Map a name to a user id.
     * @param name Username to map.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nameToId(const ::std::string& name, const ::MumbleServer::Callback_ServerAuthenticator_nameToIdPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nameToId(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Map a name to a user id.
     * @param name Username to map.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nameToId(const ::std::string& name, const ::Ice::Context& context, const ::MumbleServer::Callback_ServerAuthenticator_nameToIdPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nameToId(name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_nameToId.
     * @param result The asynchronous result object for the invocation.
     * @return User id or -2 for unknown name.
     */
    ::Ice::Int end_nameToId(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_nameToId(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Map a user id to a username.
     * @param id User id to map.
     * @param context The Context map to send with the invocation.
     * @return Name of user or empty string for unknown id.
     */
    ::std::string idToName(::Ice::Int id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_idToName(_iceI_begin_idToName(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Map a user id to a username.
     * @param id User id to map.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_idToName(::Ice::Int id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_idToName(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Map a user id to a username.
     * @param id User id to map.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_idToName(::Ice::Int id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_idToName(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Map a user id to a username.
     * @param id User id to map.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_idToName(::Ice::Int id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_idToName(id, context, cb, cookie);
    }

    /**
     * Map a user id to a username.
     * @param id User id to map.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_idToName(::Ice::Int id, const ::MumbleServer::Callback_ServerAuthenticator_idToNamePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_idToName(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Map a user id to a username.
     * @param id User id to map.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_idToName(::Ice::Int id, const ::Ice::Context& context, const ::MumbleServer::Callback_ServerAuthenticator_idToNamePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_idToName(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_idToName.
     * @param result The asynchronous result object for the invocation.
     * @return Name of user or empty string for unknown id.
     */
    ::std::string end_idToName(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_idToName(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Map a user to a custom Texture.
     * @param id User id to map.
     * @param context The Context map to send with the invocation.
     * @return User texture or an empty texture for unknown users or users without textures.
     */
    ::MumbleServer::Texture idToTexture(::Ice::Int id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_idToTexture(_iceI_begin_idToTexture(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Map a user to a custom Texture.
     * @param id User id to map.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_idToTexture(::Ice::Int id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_idToTexture(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Map a user to a custom Texture.
     * @param id User id to map.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_idToTexture(::Ice::Int id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_idToTexture(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Map a user to a custom Texture.
     * @param id User id to map.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_idToTexture(::Ice::Int id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_idToTexture(id, context, cb, cookie);
    }

    /**
     * Map a user to a custom Texture.
     * @param id User id to map.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_idToTexture(::Ice::Int id, const ::MumbleServer::Callback_ServerAuthenticator_idToTexturePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_idToTexture(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Map a user to a custom Texture.
     * @param id User id to map.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_idToTexture(::Ice::Int id, const ::Ice::Context& context, const ::MumbleServer::Callback_ServerAuthenticator_idToTexturePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_idToTexture(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_idToTexture.
     * @param result The asynchronous result object for the invocation.
     * @return User texture or an empty texture for unknown users or users without textures.
     */
    ::MumbleServer::Texture end_idToTexture(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_idToTexture(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ServerUpdatingAuthenticator : public virtual ::Ice::Proxy<ServerUpdatingAuthenticator, ::IceProxy::MumbleServer::ServerAuthenticator>
{
public:

    /**
     * Register a new user.
     * @param info Information about user to register.
     * @param context The Context map to send with the invocation.
     * @return User id of new user, -1 for registration failure, or -2 to fall through.
     */
    ::Ice::Int registerUser(const ::MumbleServer::UserInfoMap& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_registerUser(_iceI_begin_registerUser(info, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Register a new user.
     * @param info Information about user to register.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerUser(const ::MumbleServer::UserInfoMap& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_registerUser(info, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Register a new user.
     * @param info Information about user to register.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerUser(const ::MumbleServer::UserInfoMap& info, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerUser(info, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Register a new user.
     * @param info Information about user to register.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerUser(const ::MumbleServer::UserInfoMap& info, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerUser(info, context, cb, cookie);
    }

    /**
     * Register a new user.
     * @param info Information about user to register.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerUser(const ::MumbleServer::UserInfoMap& info, const ::MumbleServer::Callback_ServerUpdatingAuthenticator_registerUserPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerUser(info, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Register a new user.
     * @param info Information about user to register.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerUser(const ::MumbleServer::UserInfoMap& info, const ::Ice::Context& context, const ::MumbleServer::Callback_ServerUpdatingAuthenticator_registerUserPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerUser(info, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_registerUser.
     * @param result The asynchronous result object for the invocation.
     * @return User id of new user, -1 for registration failure, or -2 to fall through.
     */
    ::Ice::Int end_registerUser(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_registerUser(const ::MumbleServer::UserInfoMap&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Unregister a user.
     * @param id Userid to unregister.
     * @param context The Context map to send with the invocation.
     * @return 1 for successful unregistration, 0 for unsuccessful unregistration, -1 to fall through.
     */
    ::Ice::Int unregisterUser(::Ice::Int id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_unregisterUser(_iceI_begin_unregisterUser(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Unregister a user.
     * @param id Userid to unregister.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_unregisterUser(::Ice::Int id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_unregisterUser(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Unregister a user.
     * @param id Userid to unregister.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_unregisterUser(::Ice::Int id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unregisterUser(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Unregister a user.
     * @param id Userid to unregister.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_unregisterUser(::Ice::Int id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unregisterUser(id, context, cb, cookie);
    }

    /**
     * Unregister a user.
     * @param id Userid to unregister.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_unregisterUser(::Ice::Int id, const ::MumbleServer::Callback_ServerUpdatingAuthenticator_unregisterUserPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unregisterUser(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Unregister a user.
     * @param id Userid to unregister.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_unregisterUser(::Ice::Int id, const ::Ice::Context& context, const ::MumbleServer::Callback_ServerUpdatingAuthenticator_unregisterUserPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unregisterUser(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_unregisterUser.
     * @param result The asynchronous result object for the invocation.
     * @return 1 for successful unregistration, 0 for unsuccessful unregistration, -1 to fall through.
     */
    ::Ice::Int end_unregisterUser(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_unregisterUser(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get a list of registered users matching filter.
     * @param filter Substring usernames must contain. If empty, return all registered users.
     * @param context The Context map to send with the invocation.
     * @return List of matching registered users.
     */
    ::MumbleServer::NameMap getRegisteredUsers(const ::std::string& filter, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getRegisteredUsers(_iceI_begin_getRegisteredUsers(filter, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get a list of registered users matching filter.
     * @param filter Substring usernames must contain. If empty, return all registered users.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegisteredUsers(const ::std::string& filter, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getRegisteredUsers(filter, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get a list of registered users matching filter.
     * @param filter Substring usernames must contain. If empty, return all registered users.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegisteredUsers(const ::std::string& filter, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegisteredUsers(filter, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get a list of registered users matching filter.
     * @param filter Substring usernames must contain. If empty, return all registered users.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegisteredUsers(const ::std::string& filter, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegisteredUsers(filter, context, cb, cookie);
    }

    /**
     * Get a list of registered users matching filter.
     * @param filter Substring usernames must contain. If empty, return all registered users.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegisteredUsers(const ::std::string& filter, const ::MumbleServer::Callback_ServerUpdatingAuthenticator_getRegisteredUsersPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegisteredUsers(filter, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get a list of registered users matching filter.
     * @param filter Substring usernames must contain. If empty, return all registered users.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegisteredUsers(const ::std::string& filter, const ::Ice::Context& context, const ::MumbleServer::Callback_ServerUpdatingAuthenticator_getRegisteredUsersPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegisteredUsers(filter, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getRegisteredUsers.
     * @param result The asynchronous result object for the invocation.
     * @return List of matching registered users.
     */
    ::MumbleServer::NameMap end_getRegisteredUsers(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getRegisteredUsers(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Set additional information for user registration.
     * @param id Userid of registered user.
     * @param info Information to set about user. This should be merged with existing information.
     * @param context The Context map to send with the invocation.
     * @return 1 for successful update, 0 for unsuccessful update, -1 to fall through.
     */
    ::Ice::Int setInfo(::Ice::Int id, const ::MumbleServer::UserInfoMap& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_setInfo(_iceI_begin_setInfo(id, info, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Set additional information for user registration.
     * @param id Userid of registered user.
     * @param info Information to set about user. This should be merged with existing information.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setInfo(::Ice::Int id, const ::MumbleServer::UserInfoMap& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setInfo(id, info, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Set additional information for user registration.
     * @param id Userid of registered user.
     * @param info Information to set about user. This should be merged with existing information.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setInfo(::Ice::Int id, const ::MumbleServer::UserInfoMap& info, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setInfo(id, info, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set additional information for user registration.
     * @param id Userid of registered user.
     * @param info Information to set about user. This should be merged with existing information.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setInfo(::Ice::Int id, const ::MumbleServer::UserInfoMap& info, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setInfo(id, info, context, cb, cookie);
    }

    /**
     * Set additional information for user registration.
     * @param id Userid of registered user.
     * @param info Information to set about user. This should be merged with existing information.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setInfo(::Ice::Int id, const ::MumbleServer::UserInfoMap& info, const ::MumbleServer::Callback_ServerUpdatingAuthenticator_setInfoPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setInfo(id, info, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set additional information for user registration.
     * @param id Userid of registered user.
     * @param info Information to set about user. This should be merged with existing information.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setInfo(::Ice::Int id, const ::MumbleServer::UserInfoMap& info, const ::Ice::Context& context, const ::MumbleServer::Callback_ServerUpdatingAuthenticator_setInfoPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setInfo(id, info, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setInfo.
     * @param result The asynchronous result object for the invocation.
     * @return 1 for successful update, 0 for unsuccessful update, -1 to fall through.
     */
    ::Ice::Int end_setInfo(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_setInfo(::Ice::Int, const ::MumbleServer::UserInfoMap&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Set texture (now called avatar) of user registration.
     * @param id registrationId of registered user.
     * @param tex New texture.
     * @param context The Context map to send with the invocation.
     * @return 1 for successful update, 0 for unsuccessful update, -1 to fall through.
     */
    ::Ice::Int setTexture(::Ice::Int id, const ::MumbleServer::Texture& tex, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_setTexture(_iceI_begin_setTexture(id, tex, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Set texture (now called avatar) of user registration.
     * @param id registrationId of registered user.
     * @param tex New texture.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setTexture(::Ice::Int id, const ::MumbleServer::Texture& tex, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setTexture(id, tex, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Set texture (now called avatar) of user registration.
     * @param id registrationId of registered user.
     * @param tex New texture.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setTexture(::Ice::Int id, const ::MumbleServer::Texture& tex, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setTexture(id, tex, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set texture (now called avatar) of user registration.
     * @param id registrationId of registered user.
     * @param tex New texture.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setTexture(::Ice::Int id, const ::MumbleServer::Texture& tex, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setTexture(id, tex, context, cb, cookie);
    }

    /**
     * Set texture (now called avatar) of user registration.
     * @param id registrationId of registered user.
     * @param tex New texture.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setTexture(::Ice::Int id, const ::MumbleServer::Texture& tex, const ::MumbleServer::Callback_ServerUpdatingAuthenticator_setTexturePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setTexture(id, tex, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set texture (now called avatar) of user registration.
     * @param id registrationId of registered user.
     * @param tex New texture.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setTexture(::Ice::Int id, const ::MumbleServer::Texture& tex, const ::Ice::Context& context, const ::MumbleServer::Callback_ServerUpdatingAuthenticator_setTexturePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setTexture(id, tex, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setTexture.
     * @param result The asynchronous result object for the invocation.
     * @return 1 for successful update, 0 for unsuccessful update, -1 to fall through.
     */
    ::Ice::Int end_setTexture(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_setTexture(::Ice::Int, const ::MumbleServer::Texture&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class Server : public virtual ::Ice::Proxy<Server, ::IceProxy::Ice::Object>
{
public:

    /**
     * Shows if the server currently running (accepting users).
     * @param context The Context map to send with the invocation.
     * @return Run-state of server.
     */
    bool isRunning(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_isRunning(_iceI_begin_isRunning(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Shows if the server currently running (accepting users).
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_isRunning(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_isRunning(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Shows if the server currently running (accepting users).
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_isRunning(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_isRunning(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Shows if the server currently running (accepting users).
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_isRunning(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_isRunning(context, cb, cookie);
    }

    /**
     * Shows if the server currently running (accepting users).
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_isRunning(const ::MumbleServer::Callback_Server_isRunningPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_isRunning(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Shows if the server currently running (accepting users).
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_isRunning(const ::Ice::Context& context, const ::MumbleServer::Callback_Server_isRunningPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_isRunning(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_isRunning.
     * @param result The asynchronous result object for the invocation.
     * @return Run-state of server.
     */
    bool end_isRunning(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_isRunning(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Start server.
     * @param context The Context map to send with the invocation.
     */
    void start(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_start(_iceI_begin_start(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Start server.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_start(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_start(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Start server.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_start(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_start(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Start server.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_start(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_start(context, cb, cookie);
    }

    /**
     * Start server.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_start(const ::MumbleServer::Callback_Server_startPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_start(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Start server.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_start(const ::Ice::Context& context, const ::MumbleServer::Callback_Server_startPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_start(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_start.
     * @param result The asynchronous result object for the invocation.
     */
    void end_start(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_start(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Stop server.
     * Note: Server will be restarted on Murmur restart unless explicitly disabled
     * with setConf("boot", false)
     * @param context The Context map to send with the invocation.
     */
    void stop(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_stop(_iceI_begin_stop(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Stop server.
     * Note: Server will be restarted on Murmur restart unless explicitly disabled
     * with setConf("boot", false)
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stop(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_stop(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Stop server.
     * Note: Server will be restarted on Murmur restart unless explicitly disabled
     * with setConf("boot", false)
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stop(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stop(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Stop server.
     * Note: Server will be restarted on Murmur restart unless explicitly disabled
     * with setConf("boot", false)
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stop(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stop(context, cb, cookie);
    }

    /**
     * Stop server.
     * Note: Server will be restarted on Murmur restart unless explicitly disabled
     * with setConf("boot", false)
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stop(const ::MumbleServer::Callback_Server_stopPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stop(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Stop server.
     * Note: Server will be restarted on Murmur restart unless explicitly disabled
     * with setConf("boot", false)
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stop(const ::Ice::Context& context, const ::MumbleServer::Callback_Server_stopPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stop(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_stop.
     * @param result The asynchronous result object for the invocation.
     */
    void end_stop(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_stop(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Delete server and all it's configuration.
     * @param context The Context map to send with the invocation.
     */
    void _cpp_delete(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_delete(_iceI_begin_delete(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Delete server and all it's configuration.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_delete(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_delete(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Delete server and all it's configuration.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_delete(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_delete(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Delete server and all it's configuration.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_delete(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_delete(context, cb, cookie);
    }

    /**
     * Delete server and all it's configuration.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_delete(const ::MumbleServer::Callback_Server_deletePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_delete(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Delete server and all it's configuration.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_delete(const ::Ice::Context& context, const ::MumbleServer::Callback_Server_deletePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_delete(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_delete.
     * @param result The asynchronous result object for the invocation.
     */
    void end_delete(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_delete(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Fetch the server id.
     * @param context The Context map to send with the invocation.
     * @return Unique server id.
     */
    ::Ice::Int id(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_id(_iceI_begin_id(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Fetch the server id.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_id(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_id(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Fetch the server id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_id(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_id(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch the server id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_id(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_id(context, cb, cookie);
    }

    /**
     * Fetch the server id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_id(const ::MumbleServer::Callback_Server_idPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_id(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch the server id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_id(const ::Ice::Context& context, const ::MumbleServer::Callback_Server_idPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_id(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_id.
     * @param result The asynchronous result object for the invocation.
     * @return Unique server id.
     */
    ::Ice::Int end_id(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_id(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Add a callback. The callback will receive notifications about changes to users and channels.
     * @param cb Callback interface which will receive notifications.
     * @param context The Context map to send with the invocation.
     * @see removeCallback
     */
    void addCallback(const ::MumbleServer::ServerCallbackPrx& cb, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_addCallback(_iceI_begin_addCallback(cb, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Add a callback. The callback will receive notifications about changes to users and channels.
     * @param cb Callback interface which will receive notifications.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see removeCallback
     */
    ::Ice::AsyncResultPtr begin_addCallback(const ::MumbleServer::ServerCallbackPrx& cb, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_addCallback(cb, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Add a callback. The callback will receive notifications about changes to users and channels.
     * @param cb Callback interface which will receive notifications.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see removeCallback
     */
    ::Ice::AsyncResultPtr begin_addCallback(const ::MumbleServer::ServerCallbackPrx& cb, const ::Ice::CallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addCallback(cb, ::Ice::noExplicitContext, cb_, cookie);
    }

    /**
     * Add a callback. The callback will receive notifications about changes to users and channels.
     * @param cb Callback interface which will receive notifications.
     * @param context The Context map to send with the invocation.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see removeCallback
     */
    ::Ice::AsyncResultPtr begin_addCallback(const ::MumbleServer::ServerCallbackPrx& cb, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addCallback(cb, context, cb_, cookie);
    }

    /**
     * Add a callback. The callback will receive notifications about changes to users and channels.
     * @param cb Callback interface which will receive notifications.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see removeCallback
     */
    ::Ice::AsyncResultPtr begin_addCallback(const ::MumbleServer::ServerCallbackPrx& cb, const ::MumbleServer::Callback_Server_addCallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addCallback(cb, ::Ice::noExplicitContext, cb_, cookie);
    }

    /**
     * Add a callback. The callback will receive notifications about changes to users and channels.
     * @param cb Callback interface which will receive notifications.
     * @param context The Context map to send with the invocation.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see removeCallback
     */
    ::Ice::AsyncResultPtr begin_addCallback(const ::MumbleServer::ServerCallbackPrx& cb, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_addCallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addCallback(cb, context, cb_, cookie);
    }

    /**
     * Completes an invocation of begin_addCallback.
     * @param result The asynchronous result object for the invocation.
     */
    void end_addCallback(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_addCallback(const ::MumbleServer::ServerCallbackPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed.
     * @param context The Context map to send with the invocation.
     * @see addCallback
     */
    void removeCallback(const ::MumbleServer::ServerCallbackPrx& cb, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_removeCallback(_iceI_begin_removeCallback(cb, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see addCallback
     */
    ::Ice::AsyncResultPtr begin_removeCallback(const ::MumbleServer::ServerCallbackPrx& cb, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_removeCallback(cb, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see addCallback
     */
    ::Ice::AsyncResultPtr begin_removeCallback(const ::MumbleServer::ServerCallbackPrx& cb, const ::Ice::CallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeCallback(cb, ::Ice::noExplicitContext, cb_, cookie);
    }

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed.
     * @param context The Context map to send with the invocation.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see addCallback
     */
    ::Ice::AsyncResultPtr begin_removeCallback(const ::MumbleServer::ServerCallbackPrx& cb, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeCallback(cb, context, cb_, cookie);
    }

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see addCallback
     */
    ::Ice::AsyncResultPtr begin_removeCallback(const ::MumbleServer::ServerCallbackPrx& cb, const ::MumbleServer::Callback_Server_removeCallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeCallback(cb, ::Ice::noExplicitContext, cb_, cookie);
    }

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed.
     * @param context The Context map to send with the invocation.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see addCallback
     */
    ::Ice::AsyncResultPtr begin_removeCallback(const ::MumbleServer::ServerCallbackPrx& cb, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_removeCallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeCallback(cb, context, cb_, cookie);
    }

    /**
     * Completes an invocation of begin_removeCallback.
     * @param result The asynchronous result object for the invocation.
     */
    void end_removeCallback(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_removeCallback(const ::MumbleServer::ServerCallbackPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Set external authenticator. If set, all authentications from clients are forwarded to this
     * proxy.
     * @param auth Authenticator object to perform subsequent authentications.
     * @param context The Context map to send with the invocation.
     */
    void setAuthenticator(const ::MumbleServer::ServerAuthenticatorPrx& auth, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setAuthenticator(_iceI_begin_setAuthenticator(auth, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Set external authenticator. If set, all authentications from clients are forwarded to this
     * proxy.
     * @param auth Authenticator object to perform subsequent authentications.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setAuthenticator(const ::MumbleServer::ServerAuthenticatorPrx& auth, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setAuthenticator(auth, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Set external authenticator. If set, all authentications from clients are forwarded to this
     * proxy.
     * @param auth Authenticator object to perform subsequent authentications.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setAuthenticator(const ::MumbleServer::ServerAuthenticatorPrx& auth, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAuthenticator(auth, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set external authenticator. If set, all authentications from clients are forwarded to this
     * proxy.
     * @param auth Authenticator object to perform subsequent authentications.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setAuthenticator(const ::MumbleServer::ServerAuthenticatorPrx& auth, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAuthenticator(auth, context, cb, cookie);
    }

    /**
     * Set external authenticator. If set, all authentications from clients are forwarded to this
     * proxy.
     * @param auth Authenticator object to perform subsequent authentications.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setAuthenticator(const ::MumbleServer::ServerAuthenticatorPrx& auth, const ::MumbleServer::Callback_Server_setAuthenticatorPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAuthenticator(auth, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set external authenticator. If set, all authentications from clients are forwarded to this
     * proxy.
     * @param auth Authenticator object to perform subsequent authentications.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setAuthenticator(const ::MumbleServer::ServerAuthenticatorPrx& auth, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_setAuthenticatorPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAuthenticator(auth, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setAuthenticator.
     * @param result The asynchronous result object for the invocation.
     */
    void end_setAuthenticator(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_setAuthenticator(const ::MumbleServer::ServerAuthenticatorPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Retrieve configuration item.
     * @param key Configuration key.
     * @param context The Context map to send with the invocation.
     * @return Configuration value. If this is empty, see {@link Meta.getDefaultConf}
     */
    ::std::string getConf(const ::std::string& key, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getConf(_iceI_begin_getConf(key, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Retrieve configuration item.
     * @param key Configuration key.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getConf(const ::std::string& key, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getConf(key, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Retrieve configuration item.
     * @param key Configuration key.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getConf(const ::std::string& key, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getConf(key, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Retrieve configuration item.
     * @param key Configuration key.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getConf(const ::std::string& key, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getConf(key, context, cb, cookie);
    }

    /**
     * Retrieve configuration item.
     * @param key Configuration key.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getConf(const ::std::string& key, const ::MumbleServer::Callback_Server_getConfPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getConf(key, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Retrieve configuration item.
     * @param key Configuration key.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getConf(const ::std::string& key, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_getConfPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getConf(key, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getConf.
     * @param result The asynchronous result object for the invocation.
     * @return Configuration value. If this is empty, see {@link Meta.getDefaultConf}
     */
    ::std::string end_getConf(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getConf(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Retrieve all configuration items.
     * @param context The Context map to send with the invocation.
     * @return All configured values. If a value isn't set here, the value from {@link Meta.getDefaultConf} is used.
     */
    ::MumbleServer::ConfigMap getAllConf(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getAllConf(_iceI_begin_getAllConf(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Retrieve all configuration items.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllConf(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getAllConf(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Retrieve all configuration items.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllConf(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllConf(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Retrieve all configuration items.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllConf(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllConf(context, cb, cookie);
    }

    /**
     * Retrieve all configuration items.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllConf(const ::MumbleServer::Callback_Server_getAllConfPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllConf(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Retrieve all configuration items.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllConf(const ::Ice::Context& context, const ::MumbleServer::Callback_Server_getAllConfPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllConf(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getAllConf.
     * @param result The asynchronous result object for the invocation.
     * @return All configured values. If a value isn't set here, the value from {@link Meta.getDefaultConf} is used.
     */
    ::MumbleServer::ConfigMap end_getAllConf(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getAllConf(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Set a configuration item.
     * @param key Configuration key.
     * @param value Configuration value.
     * @param context The Context map to send with the invocation.
     */
    void setConf(const ::std::string& key, const ::std::string& value, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setConf(_iceI_begin_setConf(key, value, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Set a configuration item.
     * @param key Configuration key.
     * @param value Configuration value.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setConf(const ::std::string& key, const ::std::string& value, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setConf(key, value, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Set a configuration item.
     * @param key Configuration key.
     * @param value Configuration value.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setConf(const ::std::string& key, const ::std::string& value, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setConf(key, value, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set a configuration item.
     * @param key Configuration key.
     * @param value Configuration value.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setConf(const ::std::string& key, const ::std::string& value, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setConf(key, value, context, cb, cookie);
    }

    /**
     * Set a configuration item.
     * @param key Configuration key.
     * @param value Configuration value.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setConf(const ::std::string& key, const ::std::string& value, const ::MumbleServer::Callback_Server_setConfPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setConf(key, value, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set a configuration item.
     * @param key Configuration key.
     * @param value Configuration value.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setConf(const ::std::string& key, const ::std::string& value, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_setConfPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setConf(key, value, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setConf.
     * @param result The asynchronous result object for the invocation.
     */
    void end_setConf(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_setConf(const ::std::string&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Set superuser password. This is just a convenience for using {@link updateRegistration} on user id 0.
     * @param pw Password.
     * @param context The Context map to send with the invocation.
     */
    void setSuperuserPassword(const ::std::string& pw, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setSuperuserPassword(_iceI_begin_setSuperuserPassword(pw, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Set superuser password. This is just a convenience for using {@link updateRegistration} on user id 0.
     * @param pw Password.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setSuperuserPassword(const ::std::string& pw, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setSuperuserPassword(pw, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Set superuser password. This is just a convenience for using {@link updateRegistration} on user id 0.
     * @param pw Password.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setSuperuserPassword(const ::std::string& pw, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setSuperuserPassword(pw, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set superuser password. This is just a convenience for using {@link updateRegistration} on user id 0.
     * @param pw Password.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setSuperuserPassword(const ::std::string& pw, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setSuperuserPassword(pw, context, cb, cookie);
    }

    /**
     * Set superuser password. This is just a convenience for using {@link updateRegistration} on user id 0.
     * @param pw Password.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setSuperuserPassword(const ::std::string& pw, const ::MumbleServer::Callback_Server_setSuperuserPasswordPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setSuperuserPassword(pw, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set superuser password. This is just a convenience for using {@link updateRegistration} on user id 0.
     * @param pw Password.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setSuperuserPassword(const ::std::string& pw, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_setSuperuserPasswordPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setSuperuserPassword(pw, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setSuperuserPassword.
     * @param result The asynchronous result object for the invocation.
     */
    void end_setSuperuserPassword(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_setSuperuserPassword(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Fetch log entries.
     * @param first Lowest numbered entry to fetch. 0 is the most recent item.
     * @param last Last entry to fetch.
     * @param context The Context map to send with the invocation.
     * @return List of log entries.
     */
    ::MumbleServer::LogList getLog(::Ice::Int first, ::Ice::Int last, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getLog(_iceI_begin_getLog(first, last, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Fetch log entries.
     * @param first Lowest numbered entry to fetch. 0 is the most recent item.
     * @param last Last entry to fetch.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLog(::Ice::Int first, ::Ice::Int last, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getLog(first, last, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Fetch log entries.
     * @param first Lowest numbered entry to fetch. 0 is the most recent item.
     * @param last Last entry to fetch.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLog(::Ice::Int first, ::Ice::Int last, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLog(first, last, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch log entries.
     * @param first Lowest numbered entry to fetch. 0 is the most recent item.
     * @param last Last entry to fetch.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLog(::Ice::Int first, ::Ice::Int last, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLog(first, last, context, cb, cookie);
    }

    /**
     * Fetch log entries.
     * @param first Lowest numbered entry to fetch. 0 is the most recent item.
     * @param last Last entry to fetch.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLog(::Ice::Int first, ::Ice::Int last, const ::MumbleServer::Callback_Server_getLogPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLog(first, last, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch log entries.
     * @param first Lowest numbered entry to fetch. 0 is the most recent item.
     * @param last Last entry to fetch.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLog(::Ice::Int first, ::Ice::Int last, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_getLogPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLog(first, last, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getLog.
     * @param result The asynchronous result object for the invocation.
     * @return List of log entries.
     */
    ::MumbleServer::LogList end_getLog(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getLog(::Ice::Int, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Fetch length of log
     * @param context The Context map to send with the invocation.
     * @return Number of entries in log
     */
    ::Ice::Int getLogLen(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getLogLen(_iceI_begin_getLogLen(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Fetch length of log
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLogLen(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getLogLen(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Fetch length of log
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLogLen(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLogLen(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch length of log
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLogLen(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLogLen(context, cb, cookie);
    }

    /**
     * Fetch length of log
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLogLen(const ::MumbleServer::Callback_Server_getLogLenPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLogLen(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch length of log
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLogLen(const ::Ice::Context& context, const ::MumbleServer::Callback_Server_getLogLenPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLogLen(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getLogLen.
     * @param result The asynchronous result object for the invocation.
     * @return Number of entries in log
     */
    ::Ice::Int end_getLogLen(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getLogLen(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Fetch all users. This returns all currently connected users on the server.
     * @param context The Context map to send with the invocation.
     * @return List of connected users.
     * @see getState
     */
    ::MumbleServer::UserMap getUsers(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getUsers(_iceI_begin_getUsers(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Fetch all users. This returns all currently connected users on the server.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see getState
     */
    ::Ice::AsyncResultPtr begin_getUsers(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getUsers(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Fetch all users. This returns all currently connected users on the server.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see getState
     */
    ::Ice::AsyncResultPtr begin_getUsers(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUsers(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch all users. This returns all currently connected users on the server.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see getState
     */
    ::Ice::AsyncResultPtr begin_getUsers(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUsers(context, cb, cookie);
    }

    /**
     * Fetch all users. This returns all currently connected users on the server.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see getState
     */
    ::Ice::AsyncResultPtr begin_getUsers(const ::MumbleServer::Callback_Server_getUsersPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUsers(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch all users. This returns all currently connected users on the server.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see getState
     */
    ::Ice::AsyncResultPtr begin_getUsers(const ::Ice::Context& context, const ::MumbleServer::Callback_Server_getUsersPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUsers(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getUsers.
     * @param result The asynchronous result object for the invocation.
     * @return List of connected users.
     */
    ::MumbleServer::UserMap end_getUsers(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getUsers(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Fetch all channels. This returns all defined channels on the server. The root channel is always channel 0.
     * @param context The Context map to send with the invocation.
     * @return List of defined channels.
     * @see getChannelState
     */
    ::MumbleServer::ChannelMap getChannels(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getChannels(_iceI_begin_getChannels(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Fetch all channels. This returns all defined channels on the server. The root channel is always channel 0.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see getChannelState
     */
    ::Ice::AsyncResultPtr begin_getChannels(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getChannels(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Fetch all channels. This returns all defined channels on the server. The root channel is always channel 0.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see getChannelState
     */
    ::Ice::AsyncResultPtr begin_getChannels(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChannels(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch all channels. This returns all defined channels on the server. The root channel is always channel 0.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see getChannelState
     */
    ::Ice::AsyncResultPtr begin_getChannels(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChannels(context, cb, cookie);
    }

    /**
     * Fetch all channels. This returns all defined channels on the server. The root channel is always channel 0.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see getChannelState
     */
    ::Ice::AsyncResultPtr begin_getChannels(const ::MumbleServer::Callback_Server_getChannelsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChannels(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch all channels. This returns all defined channels on the server. The root channel is always channel 0.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see getChannelState
     */
    ::Ice::AsyncResultPtr begin_getChannels(const ::Ice::Context& context, const ::MumbleServer::Callback_Server_getChannelsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChannels(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getChannels.
     * @param result The asynchronous result object for the invocation.
     * @return List of defined channels.
     */
    ::MumbleServer::ChannelMap end_getChannels(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getChannels(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Fetch certificate of user. This returns the complete certificate chain of a user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param context The Context map to send with the invocation.
     * @return Certificate list of user.
     */
    ::MumbleServer::CertificateList getCertificateList(::Ice::Int session, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getCertificateList(_iceI_begin_getCertificateList(session, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Fetch certificate of user. This returns the complete certificate chain of a user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getCertificateList(::Ice::Int session, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getCertificateList(session, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Fetch certificate of user. This returns the complete certificate chain of a user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getCertificateList(::Ice::Int session, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getCertificateList(session, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch certificate of user. This returns the complete certificate chain of a user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getCertificateList(::Ice::Int session, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getCertificateList(session, context, cb, cookie);
    }

    /**
     * Fetch certificate of user. This returns the complete certificate chain of a user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getCertificateList(::Ice::Int session, const ::MumbleServer::Callback_Server_getCertificateListPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getCertificateList(session, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch certificate of user. This returns the complete certificate chain of a user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getCertificateList(::Ice::Int session, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_getCertificateListPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getCertificateList(session, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getCertificateList.
     * @param result The asynchronous result object for the invocation.
     * @return Certificate list of user.
     */
    ::MumbleServer::CertificateList end_getCertificateList(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getCertificateList(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Fetch all channels and connected users as a tree. This retrieves an easy-to-use representation of the server
     * as a tree. This is primarily used for viewing the state of the server on a webpage.
     * @param context The Context map to send with the invocation.
     * @return Recursive tree of all channels and connected users.
     */
    ::MumbleServer::TreePtr getTree(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getTree(_iceI_begin_getTree(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Fetch all channels and connected users as a tree. This retrieves an easy-to-use representation of the server
     * as a tree. This is primarily used for viewing the state of the server on a webpage.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTree(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getTree(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Fetch all channels and connected users as a tree. This retrieves an easy-to-use representation of the server
     * as a tree. This is primarily used for viewing the state of the server on a webpage.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTree(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTree(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch all channels and connected users as a tree. This retrieves an easy-to-use representation of the server
     * as a tree. This is primarily used for viewing the state of the server on a webpage.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTree(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTree(context, cb, cookie);
    }

    /**
     * Fetch all channels and connected users as a tree. This retrieves an easy-to-use representation of the server
     * as a tree. This is primarily used for viewing the state of the server on a webpage.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTree(const ::MumbleServer::Callback_Server_getTreePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTree(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch all channels and connected users as a tree. This retrieves an easy-to-use representation of the server
     * as a tree. This is primarily used for viewing the state of the server on a webpage.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTree(const ::Ice::Context& context, const ::MumbleServer::Callback_Server_getTreePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTree(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getTree.
     * @param result The asynchronous result object for the invocation.
     * @return Recursive tree of all channels and connected users.
     */
    ::MumbleServer::TreePtr end_getTree(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getTree(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Fetch all current IP bans on the server.
     * @param context The Context map to send with the invocation.
     * @return List of bans.
     */
    ::MumbleServer::BanList getBans(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getBans(_iceI_begin_getBans(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Fetch all current IP bans on the server.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getBans(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getBans(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Fetch all current IP bans on the server.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getBans(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getBans(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch all current IP bans on the server.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getBans(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getBans(context, cb, cookie);
    }

    /**
     * Fetch all current IP bans on the server.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getBans(const ::MumbleServer::Callback_Server_getBansPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getBans(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch all current IP bans on the server.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getBans(const ::Ice::Context& context, const ::MumbleServer::Callback_Server_getBansPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getBans(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getBans.
     * @param result The asynchronous result object for the invocation.
     * @return List of bans.
     */
    ::MumbleServer::BanList end_getBans(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getBans(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Set all current IP bans on the server. This will replace any bans already present, so if you want to add a ban, be sure to call {@link getBans} and then
     * append to the returned list before calling this method.
     * @param bans List of bans.
     * @param context The Context map to send with the invocation.
     */
    void setBans(const ::MumbleServer::BanList& bans, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setBans(_iceI_begin_setBans(bans, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Set all current IP bans on the server. This will replace any bans already present, so if you want to add a ban, be sure to call {@link getBans} and then
     * append to the returned list before calling this method.
     * @param bans List of bans.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setBans(const ::MumbleServer::BanList& bans, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setBans(bans, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Set all current IP bans on the server. This will replace any bans already present, so if you want to add a ban, be sure to call {@link getBans} and then
     * append to the returned list before calling this method.
     * @param bans List of bans.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setBans(const ::MumbleServer::BanList& bans, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setBans(bans, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set all current IP bans on the server. This will replace any bans already present, so if you want to add a ban, be sure to call {@link getBans} and then
     * append to the returned list before calling this method.
     * @param bans List of bans.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setBans(const ::MumbleServer::BanList& bans, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setBans(bans, context, cb, cookie);
    }

    /**
     * Set all current IP bans on the server. This will replace any bans already present, so if you want to add a ban, be sure to call {@link getBans} and then
     * append to the returned list before calling this method.
     * @param bans List of bans.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setBans(const ::MumbleServer::BanList& bans, const ::MumbleServer::Callback_Server_setBansPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setBans(bans, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set all current IP bans on the server. This will replace any bans already present, so if you want to add a ban, be sure to call {@link getBans} and then
     * append to the returned list before calling this method.
     * @param bans List of bans.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setBans(const ::MumbleServer::BanList& bans, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_setBansPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setBans(bans, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setBans.
     * @param result The asynchronous result object for the invocation.
     */
    void end_setBans(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_setBans(const ::MumbleServer::BanList&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Kick a user. The user is not banned, and is free to rejoin the server.
     * @param session Connection ID of user. See {@link User.session}.
     * @param reason Text message to show when user is kicked.
     * @param context The Context map to send with the invocation.
     */
    void kickUser(::Ice::Int session, const ::std::string& reason, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_kickUser(_iceI_begin_kickUser(session, reason, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Kick a user. The user is not banned, and is free to rejoin the server.
     * @param session Connection ID of user. See {@link User.session}.
     * @param reason Text message to show when user is kicked.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_kickUser(::Ice::Int session, const ::std::string& reason, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_kickUser(session, reason, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Kick a user. The user is not banned, and is free to rejoin the server.
     * @param session Connection ID of user. See {@link User.session}.
     * @param reason Text message to show when user is kicked.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_kickUser(::Ice::Int session, const ::std::string& reason, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_kickUser(session, reason, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Kick a user. The user is not banned, and is free to rejoin the server.
     * @param session Connection ID of user. See {@link User.session}.
     * @param reason Text message to show when user is kicked.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_kickUser(::Ice::Int session, const ::std::string& reason, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_kickUser(session, reason, context, cb, cookie);
    }

    /**
     * Kick a user. The user is not banned, and is free to rejoin the server.
     * @param session Connection ID of user. See {@link User.session}.
     * @param reason Text message to show when user is kicked.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_kickUser(::Ice::Int session, const ::std::string& reason, const ::MumbleServer::Callback_Server_kickUserPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_kickUser(session, reason, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Kick a user. The user is not banned, and is free to rejoin the server.
     * @param session Connection ID of user. See {@link User.session}.
     * @param reason Text message to show when user is kicked.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_kickUser(::Ice::Int session, const ::std::string& reason, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_kickUserPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_kickUser(session, reason, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_kickUser.
     * @param result The asynchronous result object for the invocation.
     */
    void end_kickUser(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_kickUser(::Ice::Int, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get state of a single connected user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param context The Context map to send with the invocation.
     * @return State of connected user.
     * @see setState
     * @see getUsers
     */
    ::MumbleServer::User getState(::Ice::Int session, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getState(_iceI_begin_getState(session, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get state of a single connected user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see setState
     * @see getUsers
     */
    ::Ice::AsyncResultPtr begin_getState(::Ice::Int session, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getState(session, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get state of a single connected user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see setState
     * @see getUsers
     */
    ::Ice::AsyncResultPtr begin_getState(::Ice::Int session, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getState(session, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get state of a single connected user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see setState
     * @see getUsers
     */
    ::Ice::AsyncResultPtr begin_getState(::Ice::Int session, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getState(session, context, cb, cookie);
    }

    /**
     * Get state of a single connected user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see setState
     * @see getUsers
     */
    ::Ice::AsyncResultPtr begin_getState(::Ice::Int session, const ::MumbleServer::Callback_Server_getStatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getState(session, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get state of a single connected user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see setState
     * @see getUsers
     */
    ::Ice::AsyncResultPtr begin_getState(::Ice::Int session, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_getStatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getState(session, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getState.
     * @param result The asynchronous result object for the invocation.
     * @return State of connected user.
     */
    ::MumbleServer::User end_getState(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getState(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Set user state. You can use this to move, mute and deafen users.
     * @param state User state to set.
     * @param context The Context map to send with the invocation.
     * @see getState
     */
    void setState(const ::MumbleServer::User& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setState(_iceI_begin_setState(state, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Set user state. You can use this to move, mute and deafen users.
     * @param state User state to set.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see getState
     */
    ::Ice::AsyncResultPtr begin_setState(const ::MumbleServer::User& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setState(state, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Set user state. You can use this to move, mute and deafen users.
     * @param state User state to set.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see getState
     */
    ::Ice::AsyncResultPtr begin_setState(const ::MumbleServer::User& state, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setState(state, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set user state. You can use this to move, mute and deafen users.
     * @param state User state to set.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see getState
     */
    ::Ice::AsyncResultPtr begin_setState(const ::MumbleServer::User& state, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setState(state, context, cb, cookie);
    }

    /**
     * Set user state. You can use this to move, mute and deafen users.
     * @param state User state to set.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see getState
     */
    ::Ice::AsyncResultPtr begin_setState(const ::MumbleServer::User& state, const ::MumbleServer::Callback_Server_setStatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setState(state, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set user state. You can use this to move, mute and deafen users.
     * @param state User state to set.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see getState
     */
    ::Ice::AsyncResultPtr begin_setState(const ::MumbleServer::User& state, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_setStatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setState(state, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setState.
     * @param result The asynchronous result object for the invocation.
     */
    void end_setState(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_setState(const ::MumbleServer::User&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Send text message to a single user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param text Message to send.
     * @param context The Context map to send with the invocation.
     * @see sendMessageChannel
     */
    void sendMessage(::Ice::Int session, const ::std::string& text, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_sendMessage(_iceI_begin_sendMessage(session, text, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Send text message to a single user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param text Message to send.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see sendMessageChannel
     */
    ::Ice::AsyncResultPtr begin_sendMessage(::Ice::Int session, const ::std::string& text, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_sendMessage(session, text, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Send text message to a single user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param text Message to send.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see sendMessageChannel
     */
    ::Ice::AsyncResultPtr begin_sendMessage(::Ice::Int session, const ::std::string& text, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendMessage(session, text, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Send text message to a single user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param text Message to send.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see sendMessageChannel
     */
    ::Ice::AsyncResultPtr begin_sendMessage(::Ice::Int session, const ::std::string& text, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendMessage(session, text, context, cb, cookie);
    }

    /**
     * Send text message to a single user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param text Message to send.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see sendMessageChannel
     */
    ::Ice::AsyncResultPtr begin_sendMessage(::Ice::Int session, const ::std::string& text, const ::MumbleServer::Callback_Server_sendMessagePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendMessage(session, text, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Send text message to a single user.
     * @param session Connection ID of user. See {@link User.session}.
     * @param text Message to send.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see sendMessageChannel
     */
    ::Ice::AsyncResultPtr begin_sendMessage(::Ice::Int session, const ::std::string& text, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_sendMessagePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendMessage(session, text, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_sendMessage.
     * @param result The asynchronous result object for the invocation.
     */
    void end_sendMessage(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_sendMessage(::Ice::Int, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Check if user is permitted to perform action.
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param perm Permission bits to check.
     * @param context The Context map to send with the invocation.
     * @return true if any of the permissions in perm were set for the user.
     */
    bool hasPermission(::Ice::Int session, ::Ice::Int channelid, ::Ice::Int perm, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_hasPermission(_iceI_begin_hasPermission(session, channelid, perm, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Check if user is permitted to perform action.
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param perm Permission bits to check.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_hasPermission(::Ice::Int session, ::Ice::Int channelid, ::Ice::Int perm, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_hasPermission(session, channelid, perm, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Check if user is permitted to perform action.
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param perm Permission bits to check.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_hasPermission(::Ice::Int session, ::Ice::Int channelid, ::Ice::Int perm, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_hasPermission(session, channelid, perm, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Check if user is permitted to perform action.
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param perm Permission bits to check.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_hasPermission(::Ice::Int session, ::Ice::Int channelid, ::Ice::Int perm, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_hasPermission(session, channelid, perm, context, cb, cookie);
    }

    /**
     * Check if user is permitted to perform action.
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param perm Permission bits to check.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_hasPermission(::Ice::Int session, ::Ice::Int channelid, ::Ice::Int perm, const ::MumbleServer::Callback_Server_hasPermissionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_hasPermission(session, channelid, perm, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Check if user is permitted to perform action.
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param perm Permission bits to check.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_hasPermission(::Ice::Int session, ::Ice::Int channelid, ::Ice::Int perm, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_hasPermissionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_hasPermission(session, channelid, perm, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_hasPermission.
     * @param result The asynchronous result object for the invocation.
     * @return true if any of the permissions in perm were set for the user.
     */
    bool end_hasPermission(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_hasPermission(::Ice::Int, ::Ice::Int, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Return users effective permissions
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @return bitfield of allowed actions
     */
    ::Ice::Int effectivePermissions(::Ice::Int session, ::Ice::Int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_effectivePermissions(_iceI_begin_effectivePermissions(session, channelid, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Return users effective permissions
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_effectivePermissions(::Ice::Int session, ::Ice::Int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_effectivePermissions(session, channelid, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Return users effective permissions
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_effectivePermissions(::Ice::Int session, ::Ice::Int channelid, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_effectivePermissions(session, channelid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return users effective permissions
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_effectivePermissions(::Ice::Int session, ::Ice::Int channelid, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_effectivePermissions(session, channelid, context, cb, cookie);
    }

    /**
     * Return users effective permissions
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_effectivePermissions(::Ice::Int session, ::Ice::Int channelid, const ::MumbleServer::Callback_Server_effectivePermissionsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_effectivePermissions(session, channelid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return users effective permissions
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_effectivePermissions(::Ice::Int session, ::Ice::Int channelid, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_effectivePermissionsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_effectivePermissions(session, channelid, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_effectivePermissions.
     * @param result The asynchronous result object for the invocation.
     * @return bitfield of allowed actions
     */
    ::Ice::Int end_effectivePermissions(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_effectivePermissions(::Ice::Int, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Add a context callback. This is done per user, and will add a context menu action for the user.
     * @param session Session of user which should receive context entry.
     * @param action Action string, a unique name to associate with the action.
     * @param text Name of action shown to user.
     * @param cb Callback interface which will receive notifications.
     * @param ctx Context this should be used in. Needs to be one or a combination of {@link ContextServer}, {@link ContextChannel} and {@link ContextUser}.
     * @param context The Context map to send with the invocation.
     * @see removeContextCallback
     */
    void addContextCallback(::Ice::Int session, const ::std::string& action, const ::std::string& text, const ::MumbleServer::ServerContextCallbackPrx& cb, ::Ice::Int ctx, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_addContextCallback(_iceI_begin_addContextCallback(session, action, text, cb, ctx, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Add a context callback. This is done per user, and will add a context menu action for the user.
     * @param session Session of user which should receive context entry.
     * @param action Action string, a unique name to associate with the action.
     * @param text Name of action shown to user.
     * @param cb Callback interface which will receive notifications.
     * @param ctx Context this should be used in. Needs to be one or a combination of {@link ContextServer}, {@link ContextChannel} and {@link ContextUser}.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see removeContextCallback
     */
    ::Ice::AsyncResultPtr begin_addContextCallback(::Ice::Int session, const ::std::string& action, const ::std::string& text, const ::MumbleServer::ServerContextCallbackPrx& cb, ::Ice::Int ctx, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_addContextCallback(session, action, text, cb, ctx, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Add a context callback. This is done per user, and will add a context menu action for the user.
     * @param session Session of user which should receive context entry.
     * @param action Action string, a unique name to associate with the action.
     * @param text Name of action shown to user.
     * @param cb Callback interface which will receive notifications.
     * @param ctx Context this should be used in. Needs to be one or a combination of {@link ContextServer}, {@link ContextChannel} and {@link ContextUser}.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see removeContextCallback
     */
    ::Ice::AsyncResultPtr begin_addContextCallback(::Ice::Int session, const ::std::string& action, const ::std::string& text, const ::MumbleServer::ServerContextCallbackPrx& cb, ::Ice::Int ctx, const ::Ice::CallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addContextCallback(session, action, text, cb, ctx, ::Ice::noExplicitContext, cb_, cookie);
    }

    /**
     * Add a context callback. This is done per user, and will add a context menu action for the user.
     * @param session Session of user which should receive context entry.
     * @param action Action string, a unique name to associate with the action.
     * @param text Name of action shown to user.
     * @param cb Callback interface which will receive notifications.
     * @param ctx Context this should be used in. Needs to be one or a combination of {@link ContextServer}, {@link ContextChannel} and {@link ContextUser}.
     * @param context The Context map to send with the invocation.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see removeContextCallback
     */
    ::Ice::AsyncResultPtr begin_addContextCallback(::Ice::Int session, const ::std::string& action, const ::std::string& text, const ::MumbleServer::ServerContextCallbackPrx& cb, ::Ice::Int ctx, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addContextCallback(session, action, text, cb, ctx, context, cb_, cookie);
    }

    /**
     * Add a context callback. This is done per user, and will add a context menu action for the user.
     * @param session Session of user which should receive context entry.
     * @param action Action string, a unique name to associate with the action.
     * @param text Name of action shown to user.
     * @param cb Callback interface which will receive notifications.
     * @param ctx Context this should be used in. Needs to be one or a combination of {@link ContextServer}, {@link ContextChannel} and {@link ContextUser}.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see removeContextCallback
     */
    ::Ice::AsyncResultPtr begin_addContextCallback(::Ice::Int session, const ::std::string& action, const ::std::string& text, const ::MumbleServer::ServerContextCallbackPrx& cb, ::Ice::Int ctx, const ::MumbleServer::Callback_Server_addContextCallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addContextCallback(session, action, text, cb, ctx, ::Ice::noExplicitContext, cb_, cookie);
    }

    /**
     * Add a context callback. This is done per user, and will add a context menu action for the user.
     * @param session Session of user which should receive context entry.
     * @param action Action string, a unique name to associate with the action.
     * @param text Name of action shown to user.
     * @param cb Callback interface which will receive notifications.
     * @param ctx Context this should be used in. Needs to be one or a combination of {@link ContextServer}, {@link ContextChannel} and {@link ContextUser}.
     * @param context The Context map to send with the invocation.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see removeContextCallback
     */
    ::Ice::AsyncResultPtr begin_addContextCallback(::Ice::Int session, const ::std::string& action, const ::std::string& text, const ::MumbleServer::ServerContextCallbackPrx& cb, ::Ice::Int ctx, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_addContextCallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addContextCallback(session, action, text, cb, ctx, context, cb_, cookie);
    }

    /**
     * Completes an invocation of begin_addContextCallback.
     * @param result The asynchronous result object for the invocation.
     */
    void end_addContextCallback(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_addContextCallback(::Ice::Int, const ::std::string&, const ::std::string&, const ::MumbleServer::ServerContextCallbackPrx&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed. This callback will be removed from all from all users.
     * @param context The Context map to send with the invocation.
     * @see addContextCallback
     */
    void removeContextCallback(const ::MumbleServer::ServerContextCallbackPrx& cb, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_removeContextCallback(_iceI_begin_removeContextCallback(cb, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed. This callback will be removed from all from all users.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see addContextCallback
     */
    ::Ice::AsyncResultPtr begin_removeContextCallback(const ::MumbleServer::ServerContextCallbackPrx& cb, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_removeContextCallback(cb, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed. This callback will be removed from all from all users.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see addContextCallback
     */
    ::Ice::AsyncResultPtr begin_removeContextCallback(const ::MumbleServer::ServerContextCallbackPrx& cb, const ::Ice::CallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeContextCallback(cb, ::Ice::noExplicitContext, cb_, cookie);
    }

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed. This callback will be removed from all from all users.
     * @param context The Context map to send with the invocation.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see addContextCallback
     */
    ::Ice::AsyncResultPtr begin_removeContextCallback(const ::MumbleServer::ServerContextCallbackPrx& cb, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeContextCallback(cb, context, cb_, cookie);
    }

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed. This callback will be removed from all from all users.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see addContextCallback
     */
    ::Ice::AsyncResultPtr begin_removeContextCallback(const ::MumbleServer::ServerContextCallbackPrx& cb, const ::MumbleServer::Callback_Server_removeContextCallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeContextCallback(cb, ::Ice::noExplicitContext, cb_, cookie);
    }

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed. This callback will be removed from all from all users.
     * @param context The Context map to send with the invocation.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see addContextCallback
     */
    ::Ice::AsyncResultPtr begin_removeContextCallback(const ::MumbleServer::ServerContextCallbackPrx& cb, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_removeContextCallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeContextCallback(cb, context, cb_, cookie);
    }

    /**
     * Completes an invocation of begin_removeContextCallback.
     * @param result The asynchronous result object for the invocation.
     */
    void end_removeContextCallback(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_removeContextCallback(const ::MumbleServer::ServerContextCallbackPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get state of single channel.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @return State of channel.
     * @see setChannelState
     * @see getChannels
     */
    ::MumbleServer::Channel getChannelState(::Ice::Int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getChannelState(_iceI_begin_getChannelState(channelid, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get state of single channel.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see setChannelState
     * @see getChannels
     */
    ::Ice::AsyncResultPtr begin_getChannelState(::Ice::Int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getChannelState(channelid, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get state of single channel.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see setChannelState
     * @see getChannels
     */
    ::Ice::AsyncResultPtr begin_getChannelState(::Ice::Int channelid, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChannelState(channelid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get state of single channel.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see setChannelState
     * @see getChannels
     */
    ::Ice::AsyncResultPtr begin_getChannelState(::Ice::Int channelid, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChannelState(channelid, context, cb, cookie);
    }

    /**
     * Get state of single channel.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see setChannelState
     * @see getChannels
     */
    ::Ice::AsyncResultPtr begin_getChannelState(::Ice::Int channelid, const ::MumbleServer::Callback_Server_getChannelStatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChannelState(channelid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get state of single channel.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see setChannelState
     * @see getChannels
     */
    ::Ice::AsyncResultPtr begin_getChannelState(::Ice::Int channelid, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_getChannelStatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getChannelState(channelid, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getChannelState.
     * @param result The asynchronous result object for the invocation.
     * @return State of channel.
     */
    ::MumbleServer::Channel end_getChannelState(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getChannelState(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Set state of a single channel. You can use this to move or relink channels.
     * @param state Channel state to set.
     * @param context The Context map to send with the invocation.
     * @see getChannelState
     */
    void setChannelState(const ::MumbleServer::Channel& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setChannelState(_iceI_begin_setChannelState(state, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Set state of a single channel. You can use this to move or relink channels.
     * @param state Channel state to set.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see getChannelState
     */
    ::Ice::AsyncResultPtr begin_setChannelState(const ::MumbleServer::Channel& state, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setChannelState(state, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Set state of a single channel. You can use this to move or relink channels.
     * @param state Channel state to set.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see getChannelState
     */
    ::Ice::AsyncResultPtr begin_setChannelState(const ::MumbleServer::Channel& state, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setChannelState(state, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set state of a single channel. You can use this to move or relink channels.
     * @param state Channel state to set.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see getChannelState
     */
    ::Ice::AsyncResultPtr begin_setChannelState(const ::MumbleServer::Channel& state, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setChannelState(state, context, cb, cookie);
    }

    /**
     * Set state of a single channel. You can use this to move or relink channels.
     * @param state Channel state to set.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see getChannelState
     */
    ::Ice::AsyncResultPtr begin_setChannelState(const ::MumbleServer::Channel& state, const ::MumbleServer::Callback_Server_setChannelStatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setChannelState(state, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set state of a single channel. You can use this to move or relink channels.
     * @param state Channel state to set.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see getChannelState
     */
    ::Ice::AsyncResultPtr begin_setChannelState(const ::MumbleServer::Channel& state, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_setChannelStatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setChannelState(state, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setChannelState.
     * @param result The asynchronous result object for the invocation.
     */
    void end_setChannelState(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_setChannelState(const ::MumbleServer::Channel&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Remove a channel and all its subchannels.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     */
    void removeChannel(::Ice::Int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_removeChannel(_iceI_begin_removeChannel(channelid, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Remove a channel and all its subchannels.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeChannel(::Ice::Int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_removeChannel(channelid, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Remove a channel and all its subchannels.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeChannel(::Ice::Int channelid, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeChannel(channelid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Remove a channel and all its subchannels.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeChannel(::Ice::Int channelid, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeChannel(channelid, context, cb, cookie);
    }

    /**
     * Remove a channel and all its subchannels.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeChannel(::Ice::Int channelid, const ::MumbleServer::Callback_Server_removeChannelPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeChannel(channelid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Remove a channel and all its subchannels.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeChannel(::Ice::Int channelid, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_removeChannelPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeChannel(channelid, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_removeChannel.
     * @param result The asynchronous result object for the invocation.
     */
    void end_removeChannel(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_removeChannel(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Add a new channel.
     * @param name Name of new channel.
     * @param parent Channel ID of parent channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @return ID of newly created channel.
     */
    ::Ice::Int addChannel(const ::std::string& name, ::Ice::Int parent, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_addChannel(_iceI_begin_addChannel(name, parent, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Add a new channel.
     * @param name Name of new channel.
     * @param parent Channel ID of parent channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addChannel(const ::std::string& name, ::Ice::Int parent, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_addChannel(name, parent, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Add a new channel.
     * @param name Name of new channel.
     * @param parent Channel ID of parent channel. See {@link Channel.id}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addChannel(const ::std::string& name, ::Ice::Int parent, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addChannel(name, parent, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Add a new channel.
     * @param name Name of new channel.
     * @param parent Channel ID of parent channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addChannel(const ::std::string& name, ::Ice::Int parent, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addChannel(name, parent, context, cb, cookie);
    }

    /**
     * Add a new channel.
     * @param name Name of new channel.
     * @param parent Channel ID of parent channel. See {@link Channel.id}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addChannel(const ::std::string& name, ::Ice::Int parent, const ::MumbleServer::Callback_Server_addChannelPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addChannel(name, parent, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Add a new channel.
     * @param name Name of new channel.
     * @param parent Channel ID of parent channel. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addChannel(const ::std::string& name, ::Ice::Int parent, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_addChannelPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addChannel(name, parent, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_addChannel.
     * @param result The asynchronous result object for the invocation.
     * @return ID of newly created channel.
     */
    ::Ice::Int end_addChannel(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_addChannel(const ::std::string&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Send text message to channel or a tree of channels.
     * @param channelid Channel ID of channel to send to. See {@link Channel.id}.
     * @param tree If true, the message will be sent to the channel and all its subchannels.
     * @param text Message to send.
     * @param context The Context map to send with the invocation.
     * @see sendMessage
     */
    void sendMessageChannel(::Ice::Int channelid, bool tree, const ::std::string& text, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_sendMessageChannel(_iceI_begin_sendMessageChannel(channelid, tree, text, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Send text message to channel or a tree of channels.
     * @param channelid Channel ID of channel to send to. See {@link Channel.id}.
     * @param tree If true, the message will be sent to the channel and all its subchannels.
     * @param text Message to send.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see sendMessage
     */
    ::Ice::AsyncResultPtr begin_sendMessageChannel(::Ice::Int channelid, bool tree, const ::std::string& text, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_sendMessageChannel(channelid, tree, text, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Send text message to channel or a tree of channels.
     * @param channelid Channel ID of channel to send to. See {@link Channel.id}.
     * @param tree If true, the message will be sent to the channel and all its subchannels.
     * @param text Message to send.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see sendMessage
     */
    ::Ice::AsyncResultPtr begin_sendMessageChannel(::Ice::Int channelid, bool tree, const ::std::string& text, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendMessageChannel(channelid, tree, text, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Send text message to channel or a tree of channels.
     * @param channelid Channel ID of channel to send to. See {@link Channel.id}.
     * @param tree If true, the message will be sent to the channel and all its subchannels.
     * @param text Message to send.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see sendMessage
     */
    ::Ice::AsyncResultPtr begin_sendMessageChannel(::Ice::Int channelid, bool tree, const ::std::string& text, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendMessageChannel(channelid, tree, text, context, cb, cookie);
    }

    /**
     * Send text message to channel or a tree of channels.
     * @param channelid Channel ID of channel to send to. See {@link Channel.id}.
     * @param tree If true, the message will be sent to the channel and all its subchannels.
     * @param text Message to send.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see sendMessage
     */
    ::Ice::AsyncResultPtr begin_sendMessageChannel(::Ice::Int channelid, bool tree, const ::std::string& text, const ::MumbleServer::Callback_Server_sendMessageChannelPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendMessageChannel(channelid, tree, text, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Send text message to channel or a tree of channels.
     * @param channelid Channel ID of channel to send to. See {@link Channel.id}.
     * @param tree If true, the message will be sent to the channel and all its subchannels.
     * @param text Message to send.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see sendMessage
     */
    ::Ice::AsyncResultPtr begin_sendMessageChannel(::Ice::Int channelid, bool tree, const ::std::string& text, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_sendMessageChannelPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendMessageChannel(channelid, tree, text, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_sendMessageChannel.
     * @param result The asynchronous result object for the invocation.
     */
    void end_sendMessageChannel(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_sendMessageChannel(::Ice::Int, bool, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Retrieve ACLs and Groups on a channel.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param acls List of ACLs on the channel. This will include inherited ACLs.
     * @param groups List of groups on the channel. This will include inherited groups.
     * @param inherit Does this channel inherit ACLs from the parent channel?
     * @param context The Context map to send with the invocation.
     */
    void getACL(::Ice::Int channelid, ::MumbleServer::ACLList& acls, ::MumbleServer::GroupList& groups, bool& inherit, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_getACL(acls, groups, inherit, _iceI_begin_getACL(channelid, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Retrieve ACLs and Groups on a channel.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getACL(::Ice::Int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getACL(channelid, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Retrieve ACLs and Groups on a channel.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getACL(::Ice::Int channelid, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getACL(channelid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Retrieve ACLs and Groups on a channel.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getACL(::Ice::Int channelid, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getACL(channelid, context, cb, cookie);
    }

    /**
     * Retrieve ACLs and Groups on a channel.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getACL(::Ice::Int channelid, const ::MumbleServer::Callback_Server_getACLPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getACL(channelid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Retrieve ACLs and Groups on a channel.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getACL(::Ice::Int channelid, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_getACLPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getACL(channelid, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getACL.
     * @param acls List of ACLs on the channel. This will include inherited ACLs.
     * @param groups List of groups on the channel. This will include inherited groups.
     * @param inherit Does this channel inherit ACLs from the parent channel?
     * @param result The asynchronous result object for the invocation.
     */
    void end_getACL(::MumbleServer::ACLList& acls, ::MumbleServer::GroupList& groups, bool& inherit, const ::Ice::AsyncResultPtr& result);
    /// \cond INTERNAL

    void _iceI_end_getACL(::MumbleServer::ACLList& iceP_acls, ::MumbleServer::GroupList& iceP_groups, bool& iceP_inherit, const ::Ice::AsyncResultPtr&);
    /// \endcond

private:

    ::Ice::AsyncResultPtr _iceI_begin_getACL(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Set ACLs and Groups on a channel. Note that this will replace all existing ACLs and groups on the channel.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param acls List of ACLs on the channel.
     * @param groups List of groups on the channel.
     * @param inherit Should this channel inherit ACLs from the parent channel?
     * @param context The Context map to send with the invocation.
     */
    void setACL(::Ice::Int channelid, const ::MumbleServer::ACLList& acls, const ::MumbleServer::GroupList& groups, bool inherit, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setACL(_iceI_begin_setACL(channelid, acls, groups, inherit, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Set ACLs and Groups on a channel. Note that this will replace all existing ACLs and groups on the channel.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param acls List of ACLs on the channel.
     * @param groups List of groups on the channel.
     * @param inherit Should this channel inherit ACLs from the parent channel?
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setACL(::Ice::Int channelid, const ::MumbleServer::ACLList& acls, const ::MumbleServer::GroupList& groups, bool inherit, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setACL(channelid, acls, groups, inherit, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Set ACLs and Groups on a channel. Note that this will replace all existing ACLs and groups on the channel.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param acls List of ACLs on the channel.
     * @param groups List of groups on the channel.
     * @param inherit Should this channel inherit ACLs from the parent channel?
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setACL(::Ice::Int channelid, const ::MumbleServer::ACLList& acls, const ::MumbleServer::GroupList& groups, bool inherit, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setACL(channelid, acls, groups, inherit, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set ACLs and Groups on a channel. Note that this will replace all existing ACLs and groups on the channel.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param acls List of ACLs on the channel.
     * @param groups List of groups on the channel.
     * @param inherit Should this channel inherit ACLs from the parent channel?
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setACL(::Ice::Int channelid, const ::MumbleServer::ACLList& acls, const ::MumbleServer::GroupList& groups, bool inherit, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setACL(channelid, acls, groups, inherit, context, cb, cookie);
    }

    /**
     * Set ACLs and Groups on a channel. Note that this will replace all existing ACLs and groups on the channel.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param acls List of ACLs on the channel.
     * @param groups List of groups on the channel.
     * @param inherit Should this channel inherit ACLs from the parent channel?
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setACL(::Ice::Int channelid, const ::MumbleServer::ACLList& acls, const ::MumbleServer::GroupList& groups, bool inherit, const ::MumbleServer::Callback_Server_setACLPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setACL(channelid, acls, groups, inherit, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set ACLs and Groups on a channel. Note that this will replace all existing ACLs and groups on the channel.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param acls List of ACLs on the channel.
     * @param groups List of groups on the channel.
     * @param inherit Should this channel inherit ACLs from the parent channel?
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setACL(::Ice::Int channelid, const ::MumbleServer::ACLList& acls, const ::MumbleServer::GroupList& groups, bool inherit, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_setACLPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setACL(channelid, acls, groups, inherit, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setACL.
     * @param result The asynchronous result object for the invocation.
     */
    void end_setACL(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_setACL(::Ice::Int, const ::MumbleServer::ACLList&, const ::MumbleServer::GroupList&, bool, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Temporarily add a user to a group on a channel. This state is not saved, and is intended for temporary memberships.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to add to.
     * @param context The Context map to send with the invocation.
     */
    void addUserToGroup(::Ice::Int channelid, ::Ice::Int session, const ::std::string& group, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_addUserToGroup(_iceI_begin_addUserToGroup(channelid, session, group, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Temporarily add a user to a group on a channel. This state is not saved, and is intended for temporary memberships.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to add to.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addUserToGroup(::Ice::Int channelid, ::Ice::Int session, const ::std::string& group, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_addUserToGroup(channelid, session, group, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Temporarily add a user to a group on a channel. This state is not saved, and is intended for temporary memberships.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to add to.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addUserToGroup(::Ice::Int channelid, ::Ice::Int session, const ::std::string& group, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addUserToGroup(channelid, session, group, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Temporarily add a user to a group on a channel. This state is not saved, and is intended for temporary memberships.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to add to.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addUserToGroup(::Ice::Int channelid, ::Ice::Int session, const ::std::string& group, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addUserToGroup(channelid, session, group, context, cb, cookie);
    }

    /**
     * Temporarily add a user to a group on a channel. This state is not saved, and is intended for temporary memberships.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to add to.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addUserToGroup(::Ice::Int channelid, ::Ice::Int session, const ::std::string& group, const ::MumbleServer::Callback_Server_addUserToGroupPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addUserToGroup(channelid, session, group, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Temporarily add a user to a group on a channel. This state is not saved, and is intended for temporary memberships.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to add to.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addUserToGroup(::Ice::Int channelid, ::Ice::Int session, const ::std::string& group, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_addUserToGroupPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addUserToGroup(channelid, session, group, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_addUserToGroup.
     * @param result The asynchronous result object for the invocation.
     */
    void end_addUserToGroup(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_addUserToGroup(::Ice::Int, ::Ice::Int, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Remove a user from a temporary group membership on a channel. This state is not saved, and is intended for temporary memberships.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to remove from.
     * @param context The Context map to send with the invocation.
     */
    void removeUserFromGroup(::Ice::Int channelid, ::Ice::Int session, const ::std::string& group, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_removeUserFromGroup(_iceI_begin_removeUserFromGroup(channelid, session, group, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Remove a user from a temporary group membership on a channel. This state is not saved, and is intended for temporary memberships.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to remove from.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeUserFromGroup(::Ice::Int channelid, ::Ice::Int session, const ::std::string& group, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_removeUserFromGroup(channelid, session, group, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Remove a user from a temporary group membership on a channel. This state is not saved, and is intended for temporary memberships.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to remove from.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeUserFromGroup(::Ice::Int channelid, ::Ice::Int session, const ::std::string& group, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeUserFromGroup(channelid, session, group, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Remove a user from a temporary group membership on a channel. This state is not saved, and is intended for temporary memberships.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to remove from.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeUserFromGroup(::Ice::Int channelid, ::Ice::Int session, const ::std::string& group, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeUserFromGroup(channelid, session, group, context, cb, cookie);
    }

    /**
     * Remove a user from a temporary group membership on a channel. This state is not saved, and is intended for temporary memberships.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to remove from.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeUserFromGroup(::Ice::Int channelid, ::Ice::Int session, const ::std::string& group, const ::MumbleServer::Callback_Server_removeUserFromGroupPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeUserFromGroup(channelid, session, group, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Remove a user from a temporary group membership on a channel. This state is not saved, and is intended for temporary memberships.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to remove from.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeUserFromGroup(::Ice::Int channelid, ::Ice::Int session, const ::std::string& group, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_removeUserFromGroupPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeUserFromGroup(channelid, session, group, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_removeUserFromGroup.
     * @param result The asynchronous result object for the invocation.
     */
    void end_removeUserFromGroup(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_removeUserFromGroup(::Ice::Int, ::Ice::Int, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Redirect whisper targets for user. If set, whenever a user tries to whisper to group "source", the whisper will be redirected to group "target".
     * To remove a redirect pass an empty target string. This is intended for context groups.
     * @param session Connection ID of user. See {@link User.session}.
     * @param source Group name to redirect from.
     * @param target Group name to redirect to.
     * @param context The Context map to send with the invocation.
     */
    void redirectWhisperGroup(::Ice::Int session, const ::std::string& source, const ::std::string& target, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_redirectWhisperGroup(_iceI_begin_redirectWhisperGroup(session, source, target, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Redirect whisper targets for user. If set, whenever a user tries to whisper to group "source", the whisper will be redirected to group "target".
     * To remove a redirect pass an empty target string. This is intended for context groups.
     * @param session Connection ID of user. See {@link User.session}.
     * @param source Group name to redirect from.
     * @param target Group name to redirect to.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_redirectWhisperGroup(::Ice::Int session, const ::std::string& source, const ::std::string& target, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_redirectWhisperGroup(session, source, target, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Redirect whisper targets for user. If set, whenever a user tries to whisper to group "source", the whisper will be redirected to group "target".
     * To remove a redirect pass an empty target string. This is intended for context groups.
     * @param session Connection ID of user. See {@link User.session}.
     * @param source Group name to redirect from.
     * @param target Group name to redirect to.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_redirectWhisperGroup(::Ice::Int session, const ::std::string& source, const ::std::string& target, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_redirectWhisperGroup(session, source, target, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Redirect whisper targets for user. If set, whenever a user tries to whisper to group "source", the whisper will be redirected to group "target".
     * To remove a redirect pass an empty target string. This is intended for context groups.
     * @param session Connection ID of user. See {@link User.session}.
     * @param source Group name to redirect from.
     * @param target Group name to redirect to.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_redirectWhisperGroup(::Ice::Int session, const ::std::string& source, const ::std::string& target, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_redirectWhisperGroup(session, source, target, context, cb, cookie);
    }

    /**
     * Redirect whisper targets for user. If set, whenever a user tries to whisper to group "source", the whisper will be redirected to group "target".
     * To remove a redirect pass an empty target string. This is intended for context groups.
     * @param session Connection ID of user. See {@link User.session}.
     * @param source Group name to redirect from.
     * @param target Group name to redirect to.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_redirectWhisperGroup(::Ice::Int session, const ::std::string& source, const ::std::string& target, const ::MumbleServer::Callback_Server_redirectWhisperGroupPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_redirectWhisperGroup(session, source, target, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Redirect whisper targets for user. If set, whenever a user tries to whisper to group "source", the whisper will be redirected to group "target".
     * To remove a redirect pass an empty target string. This is intended for context groups.
     * @param session Connection ID of user. See {@link User.session}.
     * @param source Group name to redirect from.
     * @param target Group name to redirect to.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_redirectWhisperGroup(::Ice::Int session, const ::std::string& source, const ::std::string& target, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_redirectWhisperGroupPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_redirectWhisperGroup(session, source, target, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_redirectWhisperGroup.
     * @param result The asynchronous result object for the invocation.
     */
    void end_redirectWhisperGroup(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_redirectWhisperGroup(::Ice::Int, const ::std::string&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Map a list of {@link User.userid} to a matching name.
     * @param context The Context map to send with the invocation.
     * @return Matching list of names, with an empty string representing invalid or unknown ids.
     */
    ::MumbleServer::NameMap getUserNames(const ::MumbleServer::IdList& ids, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getUserNames(_iceI_begin_getUserNames(ids, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Map a list of {@link User.userid} to a matching name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getUserNames(const ::MumbleServer::IdList& ids, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getUserNames(ids, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Map a list of {@link User.userid} to a matching name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getUserNames(const ::MumbleServer::IdList& ids, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUserNames(ids, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Map a list of {@link User.userid} to a matching name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getUserNames(const ::MumbleServer::IdList& ids, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUserNames(ids, context, cb, cookie);
    }

    /**
     * Map a list of {@link User.userid} to a matching name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getUserNames(const ::MumbleServer::IdList& ids, const ::MumbleServer::Callback_Server_getUserNamesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUserNames(ids, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Map a list of {@link User.userid} to a matching name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getUserNames(const ::MumbleServer::IdList& ids, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_getUserNamesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUserNames(ids, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getUserNames.
     * @param result The asynchronous result object for the invocation.
     * @return Matching list of names, with an empty string representing invalid or unknown ids.
     */
    ::MumbleServer::NameMap end_getUserNames(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getUserNames(const ::MumbleServer::IdList&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Map a list of user names to a matching id.
     * @param context The Context map to send with the invocation.
     * @reuturn List of matching ids, with -1 representing invalid or unknown user names.
     */
    ::MumbleServer::IdMap getUserIds(const ::MumbleServer::NameList& names, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getUserIds(_iceI_begin_getUserIds(names, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Map a list of user names to a matching id.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @reuturn List of matching ids, with -1 representing invalid or unknown user names.
     */
    ::Ice::AsyncResultPtr begin_getUserIds(const ::MumbleServer::NameList& names, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getUserIds(names, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Map a list of user names to a matching id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @reuturn List of matching ids, with -1 representing invalid or unknown user names.
     */
    ::Ice::AsyncResultPtr begin_getUserIds(const ::MumbleServer::NameList& names, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUserIds(names, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Map a list of user names to a matching id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @reuturn List of matching ids, with -1 representing invalid or unknown user names.
     */
    ::Ice::AsyncResultPtr begin_getUserIds(const ::MumbleServer::NameList& names, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUserIds(names, context, cb, cookie);
    }

    /**
     * Map a list of user names to a matching id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @reuturn List of matching ids, with -1 representing invalid or unknown user names.
     */
    ::Ice::AsyncResultPtr begin_getUserIds(const ::MumbleServer::NameList& names, const ::MumbleServer::Callback_Server_getUserIdsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUserIds(names, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Map a list of user names to a matching id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @reuturn List of matching ids, with -1 representing invalid or unknown user names.
     */
    ::Ice::AsyncResultPtr begin_getUserIds(const ::MumbleServer::NameList& names, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_getUserIdsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUserIds(names, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getUserIds.
     * @param result The asynchronous result object for the invocation.
     */
    ::MumbleServer::IdMap end_getUserIds(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getUserIds(const ::MumbleServer::NameList&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Register a new user.
     * @param info Information about new user. Must include at least "name".
     * @param context The Context map to send with the invocation.
     * @return The ID of the user. See {@link RegisteredUser.userid}.
     */
    ::Ice::Int registerUser(const ::MumbleServer::UserInfoMap& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_registerUser(_iceI_begin_registerUser(info, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Register a new user.
     * @param info Information about new user. Must include at least "name".
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerUser(const ::MumbleServer::UserInfoMap& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_registerUser(info, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Register a new user.
     * @param info Information about new user. Must include at least "name".
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerUser(const ::MumbleServer::UserInfoMap& info, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerUser(info, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Register a new user.
     * @param info Information about new user. Must include at least "name".
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerUser(const ::MumbleServer::UserInfoMap& info, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerUser(info, context, cb, cookie);
    }

    /**
     * Register a new user.
     * @param info Information about new user. Must include at least "name".
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerUser(const ::MumbleServer::UserInfoMap& info, const ::MumbleServer::Callback_Server_registerUserPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerUser(info, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Register a new user.
     * @param info Information about new user. Must include at least "name".
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerUser(const ::MumbleServer::UserInfoMap& info, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_registerUserPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerUser(info, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_registerUser.
     * @param result The asynchronous result object for the invocation.
     * @return The ID of the user. See {@link RegisteredUser.userid}.
     */
    ::Ice::Int end_registerUser(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_registerUser(const ::MumbleServer::UserInfoMap&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Remove a user registration.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param context The Context map to send with the invocation.
     */
    void unregisterUser(::Ice::Int userid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_unregisterUser(_iceI_begin_unregisterUser(userid, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Remove a user registration.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_unregisterUser(::Ice::Int userid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_unregisterUser(userid, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Remove a user registration.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_unregisterUser(::Ice::Int userid, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unregisterUser(userid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Remove a user registration.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_unregisterUser(::Ice::Int userid, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unregisterUser(userid, context, cb, cookie);
    }

    /**
     * Remove a user registration.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_unregisterUser(::Ice::Int userid, const ::MumbleServer::Callback_Server_unregisterUserPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unregisterUser(userid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Remove a user registration.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_unregisterUser(::Ice::Int userid, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_unregisterUserPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_unregisterUser(userid, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_unregisterUser.
     * @param result The asynchronous result object for the invocation.
     */
    void end_unregisterUser(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_unregisterUser(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Update the registration for a user. You can use this to set the email or password of a user,
     * and can also use it to change the user's name.
     * @param context The Context map to send with the invocation.
     */
    void updateRegistration(::Ice::Int userid, const ::MumbleServer::UserInfoMap& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_updateRegistration(_iceI_begin_updateRegistration(userid, info, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Update the registration for a user. You can use this to set the email or password of a user,
     * and can also use it to change the user's name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateRegistration(::Ice::Int userid, const ::MumbleServer::UserInfoMap& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_updateRegistration(userid, info, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Update the registration for a user. You can use this to set the email or password of a user,
     * and can also use it to change the user's name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateRegistration(::Ice::Int userid, const ::MumbleServer::UserInfoMap& info, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateRegistration(userid, info, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Update the registration for a user. You can use this to set the email or password of a user,
     * and can also use it to change the user's name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateRegistration(::Ice::Int userid, const ::MumbleServer::UserInfoMap& info, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateRegistration(userid, info, context, cb, cookie);
    }

    /**
     * Update the registration for a user. You can use this to set the email or password of a user,
     * and can also use it to change the user's name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateRegistration(::Ice::Int userid, const ::MumbleServer::UserInfoMap& info, const ::MumbleServer::Callback_Server_updateRegistrationPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateRegistration(userid, info, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Update the registration for a user. You can use this to set the email or password of a user,
     * and can also use it to change the user's name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateRegistration(::Ice::Int userid, const ::MumbleServer::UserInfoMap& info, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_updateRegistrationPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateRegistration(userid, info, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_updateRegistration.
     * @param result The asynchronous result object for the invocation.
     */
    void end_updateRegistration(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_updateRegistration(::Ice::Int, const ::MumbleServer::UserInfoMap&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Fetch registration for a single user.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param context The Context map to send with the invocation.
     * @return Registration record.
     */
    ::MumbleServer::UserInfoMap getRegistration(::Ice::Int userid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getRegistration(_iceI_begin_getRegistration(userid, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Fetch registration for a single user.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegistration(::Ice::Int userid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getRegistration(userid, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Fetch registration for a single user.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegistration(::Ice::Int userid, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistration(userid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch registration for a single user.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegistration(::Ice::Int userid, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistration(userid, context, cb, cookie);
    }

    /**
     * Fetch registration for a single user.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegistration(::Ice::Int userid, const ::MumbleServer::Callback_Server_getRegistrationPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistration(userid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch registration for a single user.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegistration(::Ice::Int userid, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_getRegistrationPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistration(userid, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getRegistration.
     * @param result The asynchronous result object for the invocation.
     * @return Registration record.
     */
    ::MumbleServer::UserInfoMap end_getRegistration(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getRegistration(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Fetch a group of registered users.
     * @param filter Substring of user name. If blank, will retrieve all registered users.
     * @param context The Context map to send with the invocation.
     * @return List of registration records.
     */
    ::MumbleServer::NameMap getRegisteredUsers(const ::std::string& filter, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getRegisteredUsers(_iceI_begin_getRegisteredUsers(filter, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Fetch a group of registered users.
     * @param filter Substring of user name. If blank, will retrieve all registered users.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegisteredUsers(const ::std::string& filter, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getRegisteredUsers(filter, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Fetch a group of registered users.
     * @param filter Substring of user name. If blank, will retrieve all registered users.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegisteredUsers(const ::std::string& filter, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegisteredUsers(filter, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch a group of registered users.
     * @param filter Substring of user name. If blank, will retrieve all registered users.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegisteredUsers(const ::std::string& filter, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegisteredUsers(filter, context, cb, cookie);
    }

    /**
     * Fetch a group of registered users.
     * @param filter Substring of user name. If blank, will retrieve all registered users.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegisteredUsers(const ::std::string& filter, const ::MumbleServer::Callback_Server_getRegisteredUsersPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegisteredUsers(filter, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch a group of registered users.
     * @param filter Substring of user name. If blank, will retrieve all registered users.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegisteredUsers(const ::std::string& filter, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_getRegisteredUsersPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegisteredUsers(filter, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getRegisteredUsers.
     * @param result The asynchronous result object for the invocation.
     * @return List of registration records.
     */
    ::MumbleServer::NameMap end_getRegisteredUsers(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getRegisteredUsers(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Verify the password of a user. You can use this to verify a user's credentials.
     * @param name User name. See {@link RegisteredUser.name}.
     * @param pw User password.
     * @param context The Context map to send with the invocation.
     * @return User ID of registered user (See {@link RegisteredUser.userid}), -1 for failed authentication or -2 for unknown usernames.
     */
    ::Ice::Int verifyPassword(const ::std::string& name, const ::std::string& pw, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_verifyPassword(_iceI_begin_verifyPassword(name, pw, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Verify the password of a user. You can use this to verify a user's credentials.
     * @param name User name. See {@link RegisteredUser.name}.
     * @param pw User password.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_verifyPassword(const ::std::string& name, const ::std::string& pw, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_verifyPassword(name, pw, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Verify the password of a user. You can use this to verify a user's credentials.
     * @param name User name. See {@link RegisteredUser.name}.
     * @param pw User password.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_verifyPassword(const ::std::string& name, const ::std::string& pw, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_verifyPassword(name, pw, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Verify the password of a user. You can use this to verify a user's credentials.
     * @param name User name. See {@link RegisteredUser.name}.
     * @param pw User password.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_verifyPassword(const ::std::string& name, const ::std::string& pw, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_verifyPassword(name, pw, context, cb, cookie);
    }

    /**
     * Verify the password of a user. You can use this to verify a user's credentials.
     * @param name User name. See {@link RegisteredUser.name}.
     * @param pw User password.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_verifyPassword(const ::std::string& name, const ::std::string& pw, const ::MumbleServer::Callback_Server_verifyPasswordPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_verifyPassword(name, pw, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Verify the password of a user. You can use this to verify a user's credentials.
     * @param name User name. See {@link RegisteredUser.name}.
     * @param pw User password.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_verifyPassword(const ::std::string& name, const ::std::string& pw, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_verifyPasswordPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_verifyPassword(name, pw, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_verifyPassword.
     * @param result The asynchronous result object for the invocation.
     * @return User ID of registered user (See {@link RegisteredUser.userid}), -1 for failed authentication or -2 for unknown usernames.
     */
    ::Ice::Int end_verifyPassword(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_verifyPassword(const ::std::string&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Fetch user texture. Textures are stored as zlib compress()ed 600x60 32-bit BGRA data.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param context The Context map to send with the invocation.
     * @return Custom texture associated with user or an empty texture.
     */
    ::MumbleServer::Texture getTexture(::Ice::Int userid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getTexture(_iceI_begin_getTexture(userid, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Fetch user texture. Textures are stored as zlib compress()ed 600x60 32-bit BGRA data.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTexture(::Ice::Int userid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getTexture(userid, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Fetch user texture. Textures are stored as zlib compress()ed 600x60 32-bit BGRA data.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTexture(::Ice::Int userid, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTexture(userid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch user texture. Textures are stored as zlib compress()ed 600x60 32-bit BGRA data.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTexture(::Ice::Int userid, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTexture(userid, context, cb, cookie);
    }

    /**
     * Fetch user texture. Textures are stored as zlib compress()ed 600x60 32-bit BGRA data.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTexture(::Ice::Int userid, const ::MumbleServer::Callback_Server_getTexturePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTexture(userid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch user texture. Textures are stored as zlib compress()ed 600x60 32-bit BGRA data.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTexture(::Ice::Int userid, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_getTexturePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTexture(userid, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getTexture.
     * @param result The asynchronous result object for the invocation.
     * @return Custom texture associated with user or an empty texture.
     */
    ::MumbleServer::Texture end_getTexture(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getTexture(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Set a user texture (now called avatar).
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param tex Texture (as a Byte-Array) to set for the user, or an empty texture to remove the existing texture.
     * @param context The Context map to send with the invocation.
     */
    void setTexture(::Ice::Int userid, const ::MumbleServer::Texture& tex, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setTexture(_iceI_begin_setTexture(userid, tex, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Set a user texture (now called avatar).
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param tex Texture (as a Byte-Array) to set for the user, or an empty texture to remove the existing texture.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setTexture(::Ice::Int userid, const ::MumbleServer::Texture& tex, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setTexture(userid, tex, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Set a user texture (now called avatar).
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param tex Texture (as a Byte-Array) to set for the user, or an empty texture to remove the existing texture.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setTexture(::Ice::Int userid, const ::MumbleServer::Texture& tex, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setTexture(userid, tex, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set a user texture (now called avatar).
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param tex Texture (as a Byte-Array) to set for the user, or an empty texture to remove the existing texture.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setTexture(::Ice::Int userid, const ::MumbleServer::Texture& tex, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setTexture(userid, tex, context, cb, cookie);
    }

    /**
     * Set a user texture (now called avatar).
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param tex Texture (as a Byte-Array) to set for the user, or an empty texture to remove the existing texture.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setTexture(::Ice::Int userid, const ::MumbleServer::Texture& tex, const ::MumbleServer::Callback_Server_setTexturePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setTexture(userid, tex, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set a user texture (now called avatar).
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param tex Texture (as a Byte-Array) to set for the user, or an empty texture to remove the existing texture.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setTexture(::Ice::Int userid, const ::MumbleServer::Texture& tex, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_setTexturePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setTexture(userid, tex, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setTexture.
     * @param result The asynchronous result object for the invocation.
     */
    void end_setTexture(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_setTexture(::Ice::Int, const ::MumbleServer::Texture&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get virtual server uptime.
     * @param context The Context map to send with the invocation.
     * @return Uptime of the virtual server in seconds
     */
    ::Ice::Int getUptime(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getUptime(_iceI_begin_getUptime(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get virtual server uptime.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getUptime(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getUptime(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get virtual server uptime.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getUptime(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUptime(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get virtual server uptime.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getUptime(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUptime(context, cb, cookie);
    }

    /**
     * Get virtual server uptime.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getUptime(const ::MumbleServer::Callback_Server_getUptimePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUptime(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get virtual server uptime.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getUptime(const ::Ice::Context& context, const ::MumbleServer::Callback_Server_getUptimePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUptime(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getUptime.
     * @param result The asynchronous result object for the invocation.
     * @return Uptime of the virtual server in seconds
     */
    ::Ice::Int end_getUptime(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getUptime(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Update the server's certificate information.
     *
     * Reconfigure the running server's TLS socket with the given
     * certificate and private key.
     *
     * The certificate and and private key must be PEM formatted.
     *
     * New clients will see the new certificate.
     * Existing clients will continue to see the certificate the server
     * was using when they connected to it.
     *
     * This method throws InvalidInputDataException if any of the
     * following errors happen:
     * - Unable to decode the PEM certificate and/or private key.
     * - Unable to decrypt the private key with the given passphrase.
     * - The certificate and/or private key do not contain RSA keys.
     * - The certificate is not usable with the given private key.
     * @param context The Context map to send with the invocation.
     */
    void updateCertificate(const ::std::string& certificate, const ::std::string& privateKey, const ::std::string& passphrase, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_updateCertificate(_iceI_begin_updateCertificate(certificate, privateKey, passphrase, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Update the server's certificate information.
     *
     * Reconfigure the running server's TLS socket with the given
     * certificate and private key.
     *
     * The certificate and and private key must be PEM formatted.
     *
     * New clients will see the new certificate.
     * Existing clients will continue to see the certificate the server
     * was using when they connected to it.
     *
     * This method throws InvalidInputDataException if any of the
     * following errors happen:
     * - Unable to decode the PEM certificate and/or private key.
     * - Unable to decrypt the private key with the given passphrase.
     * - The certificate and/or private key do not contain RSA keys.
     * - The certificate is not usable with the given private key.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateCertificate(const ::std::string& certificate, const ::std::string& privateKey, const ::std::string& passphrase, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_updateCertificate(certificate, privateKey, passphrase, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Update the server's certificate information.
     *
     * Reconfigure the running server's TLS socket with the given
     * certificate and private key.
     *
     * The certificate and and private key must be PEM formatted.
     *
     * New clients will see the new certificate.
     * Existing clients will continue to see the certificate the server
     * was using when they connected to it.
     *
     * This method throws InvalidInputDataException if any of the
     * following errors happen:
     * - Unable to decode the PEM certificate and/or private key.
     * - Unable to decrypt the private key with the given passphrase.
     * - The certificate and/or private key do not contain RSA keys.
     * - The certificate is not usable with the given private key.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateCertificate(const ::std::string& certificate, const ::std::string& privateKey, const ::std::string& passphrase, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateCertificate(certificate, privateKey, passphrase, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Update the server's certificate information.
     *
     * Reconfigure the running server's TLS socket with the given
     * certificate and private key.
     *
     * The certificate and and private key must be PEM formatted.
     *
     * New clients will see the new certificate.
     * Existing clients will continue to see the certificate the server
     * was using when they connected to it.
     *
     * This method throws InvalidInputDataException if any of the
     * following errors happen:
     * - Unable to decode the PEM certificate and/or private key.
     * - Unable to decrypt the private key with the given passphrase.
     * - The certificate and/or private key do not contain RSA keys.
     * - The certificate is not usable with the given private key.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateCertificate(const ::std::string& certificate, const ::std::string& privateKey, const ::std::string& passphrase, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateCertificate(certificate, privateKey, passphrase, context, cb, cookie);
    }

    /**
     * Update the server's certificate information.
     *
     * Reconfigure the running server's TLS socket with the given
     * certificate and private key.
     *
     * The certificate and and private key must be PEM formatted.
     *
     * New clients will see the new certificate.
     * Existing clients will continue to see the certificate the server
     * was using when they connected to it.
     *
     * This method throws InvalidInputDataException if any of the
     * following errors happen:
     * - Unable to decode the PEM certificate and/or private key.
     * - Unable to decrypt the private key with the given passphrase.
     * - The certificate and/or private key do not contain RSA keys.
     * - The certificate is not usable with the given private key.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateCertificate(const ::std::string& certificate, const ::std::string& privateKey, const ::std::string& passphrase, const ::MumbleServer::Callback_Server_updateCertificatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateCertificate(certificate, privateKey, passphrase, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Update the server's certificate information.
     *
     * Reconfigure the running server's TLS socket with the given
     * certificate and private key.
     *
     * The certificate and and private key must be PEM formatted.
     *
     * New clients will see the new certificate.
     * Existing clients will continue to see the certificate the server
     * was using when they connected to it.
     *
     * This method throws InvalidInputDataException if any of the
     * following errors happen:
     * - Unable to decode the PEM certificate and/or private key.
     * - Unable to decrypt the private key with the given passphrase.
     * - The certificate and/or private key do not contain RSA keys.
     * - The certificate is not usable with the given private key.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateCertificate(const ::std::string& certificate, const ::std::string& privateKey, const ::std::string& passphrase, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_updateCertificatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateCertificate(certificate, privateKey, passphrase, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_updateCertificate.
     * @param result The asynchronous result object for the invocation.
     */
    void end_updateCertificate(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_updateCertificate(const ::std::string&, const ::std::string&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Makes the given user start listening to the given channel.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     */
    void startListening(::Ice::Int userid, ::Ice::Int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_startListening(_iceI_begin_startListening(userid, channelid, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Makes the given user start listening to the given channel.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_startListening(::Ice::Int userid, ::Ice::Int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_startListening(userid, channelid, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Makes the given user start listening to the given channel.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_startListening(::Ice::Int userid, ::Ice::Int channelid, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startListening(userid, channelid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Makes the given user start listening to the given channel.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_startListening(::Ice::Int userid, ::Ice::Int channelid, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startListening(userid, channelid, context, cb, cookie);
    }

    /**
     * Makes the given user start listening to the given channel.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_startListening(::Ice::Int userid, ::Ice::Int channelid, const ::MumbleServer::Callback_Server_startListeningPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startListening(userid, channelid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Makes the given user start listening to the given channel.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_startListening(::Ice::Int userid, ::Ice::Int channelid, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_startListeningPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startListening(userid, channelid, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_startListening.
     * @param result The asynchronous result object for the invocation.
     */
    void end_startListening(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_startListening(::Ice::Int, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Makes the given user stop listening to the given channel.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     */
    void stopListening(::Ice::Int userid, ::Ice::Int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_stopListening(_iceI_begin_stopListening(userid, channelid, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Makes the given user stop listening to the given channel.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stopListening(::Ice::Int userid, ::Ice::Int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_stopListening(userid, channelid, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Makes the given user stop listening to the given channel.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stopListening(::Ice::Int userid, ::Ice::Int channelid, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopListening(userid, channelid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Makes the given user stop listening to the given channel.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stopListening(::Ice::Int userid, ::Ice::Int channelid, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopListening(userid, channelid, context, cb, cookie);
    }

    /**
     * Makes the given user stop listening to the given channel.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stopListening(::Ice::Int userid, ::Ice::Int channelid, const ::MumbleServer::Callback_Server_stopListeningPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopListening(userid, channelid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Makes the given user stop listening to the given channel.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stopListening(::Ice::Int userid, ::Ice::Int channelid, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_stopListeningPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopListening(userid, channelid, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_stopListening.
     * @param result The asynchronous result object for the invocation.
     */
    void end_stopListening(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_stopListening(::Ice::Int, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     * @return s Whether the given user is currently listening to the given channel
     */
    bool isListening(::Ice::Int userid, ::Ice::Int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_isListening(_iceI_begin_isListening(userid, channelid, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_isListening(::Ice::Int userid, ::Ice::Int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_isListening(userid, channelid, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_isListening(::Ice::Int userid, ::Ice::Int channelid, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_isListening(userid, channelid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_isListening(::Ice::Int userid, ::Ice::Int channelid, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_isListening(userid, channelid, context, cb, cookie);
    }

    /**
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_isListening(::Ice::Int userid, ::Ice::Int channelid, const ::MumbleServer::Callback_Server_isListeningPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_isListening(userid, channelid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_isListening(::Ice::Int userid, ::Ice::Int channelid, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_isListeningPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_isListening(userid, channelid, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_isListening.
     * @param result The asynchronous result object for the invocation.
     * @return s Whether the given user is currently listening to the given channel
     */
    bool end_isListening(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_isListening(::Ice::Int, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * @param userid The ID of the user
     * @param context The Context map to send with the invocation.
     * @return s An ID-list of channels the given user is listening to
     */
    ::MumbleServer::IntList getListeningChannels(::Ice::Int userid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getListeningChannels(_iceI_begin_getListeningChannels(userid, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * @param userid The ID of the user
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getListeningChannels(::Ice::Int userid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getListeningChannels(userid, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * @param userid The ID of the user
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getListeningChannels(::Ice::Int userid, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getListeningChannels(userid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * @param userid The ID of the user
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getListeningChannels(::Ice::Int userid, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getListeningChannels(userid, context, cb, cookie);
    }

    /**
     * @param userid The ID of the user
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getListeningChannels(::Ice::Int userid, const ::MumbleServer::Callback_Server_getListeningChannelsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getListeningChannels(userid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * @param userid The ID of the user
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getListeningChannels(::Ice::Int userid, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_getListeningChannelsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getListeningChannels(userid, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getListeningChannels.
     * @param result The asynchronous result object for the invocation.
     * @return s An ID-list of channels the given user is listening to
     */
    ::MumbleServer::IntList end_getListeningChannels(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getListeningChannels(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     * @return s An ID-list of users listening to the given channel
     */
    ::MumbleServer::IntList getListeningUsers(::Ice::Int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getListeningUsers(_iceI_begin_getListeningUsers(channelid, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getListeningUsers(::Ice::Int channelid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getListeningUsers(channelid, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * @param channelid The ID of the channel
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getListeningUsers(::Ice::Int channelid, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getListeningUsers(channelid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getListeningUsers(::Ice::Int channelid, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getListeningUsers(channelid, context, cb, cookie);
    }

    /**
     * @param channelid The ID of the channel
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getListeningUsers(::Ice::Int channelid, const ::MumbleServer::Callback_Server_getListeningUsersPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getListeningUsers(channelid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * @param channelid The ID of the channel
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getListeningUsers(::Ice::Int channelid, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_getListeningUsersPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getListeningUsers(channelid, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getListeningUsers.
     * @param result The asynchronous result object for the invocation.
     * @return s An ID-list of users listening to the given channel
     */
    ::MumbleServer::IntList end_getListeningUsers(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getListeningUsers(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param context The Context map to send with the invocation.
     * @return s The volume adjustment set for a listener of the given user in the given channel
     */
    ::Ice::Float getListenerVolumeAdjustment(::Ice::Int channelid, ::Ice::Int userid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getListenerVolumeAdjustment(_iceI_begin_getListenerVolumeAdjustment(channelid, userid, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getListenerVolumeAdjustment(::Ice::Int channelid, ::Ice::Int userid, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getListenerVolumeAdjustment(channelid, userid, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getListenerVolumeAdjustment(::Ice::Int channelid, ::Ice::Int userid, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getListenerVolumeAdjustment(channelid, userid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getListenerVolumeAdjustment(::Ice::Int channelid, ::Ice::Int userid, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getListenerVolumeAdjustment(channelid, userid, context, cb, cookie);
    }

    /**
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getListenerVolumeAdjustment(::Ice::Int channelid, ::Ice::Int userid, const ::MumbleServer::Callback_Server_getListenerVolumeAdjustmentPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getListenerVolumeAdjustment(channelid, userid, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getListenerVolumeAdjustment(::Ice::Int channelid, ::Ice::Int userid, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_getListenerVolumeAdjustmentPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getListenerVolumeAdjustment(channelid, userid, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getListenerVolumeAdjustment.
     * @param result The asynchronous result object for the invocation.
     * @return s The volume adjustment set for a listener of the given user in the given channel
     */
    ::Ice::Float end_getListenerVolumeAdjustment(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getListenerVolumeAdjustment(::Ice::Int, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Sets the volume adjustment set for a listener of the given user in the given channel
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param context The Context map to send with the invocation.
     */
    void setListenerVolumeAdjustment(::Ice::Int channelid, ::Ice::Int userid, ::Ice::Float volumeAdjustment, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setListenerVolumeAdjustment(_iceI_begin_setListenerVolumeAdjustment(channelid, userid, volumeAdjustment, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Sets the volume adjustment set for a listener of the given user in the given channel
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setListenerVolumeAdjustment(::Ice::Int channelid, ::Ice::Int userid, ::Ice::Float volumeAdjustment, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setListenerVolumeAdjustment(channelid, userid, volumeAdjustment, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Sets the volume adjustment set for a listener of the given user in the given channel
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setListenerVolumeAdjustment(::Ice::Int channelid, ::Ice::Int userid, ::Ice::Float volumeAdjustment, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setListenerVolumeAdjustment(channelid, userid, volumeAdjustment, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Sets the volume adjustment set for a listener of the given user in the given channel
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setListenerVolumeAdjustment(::Ice::Int channelid, ::Ice::Int userid, ::Ice::Float volumeAdjustment, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setListenerVolumeAdjustment(channelid, userid, volumeAdjustment, context, cb, cookie);
    }

    /**
     * Sets the volume adjustment set for a listener of the given user in the given channel
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setListenerVolumeAdjustment(::Ice::Int channelid, ::Ice::Int userid, ::Ice::Float volumeAdjustment, const ::MumbleServer::Callback_Server_setListenerVolumeAdjustmentPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setListenerVolumeAdjustment(channelid, userid, volumeAdjustment, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Sets the volume adjustment set for a listener of the given user in the given channel
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setListenerVolumeAdjustment(::Ice::Int channelid, ::Ice::Int userid, ::Ice::Float volumeAdjustment, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_setListenerVolumeAdjustmentPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setListenerVolumeAdjustment(channelid, userid, volumeAdjustment, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setListenerVolumeAdjustment.
     * @param result The asynchronous result object for the invocation.
     */
    void end_setListenerVolumeAdjustment(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_setListenerVolumeAdjustment(::Ice::Int, ::Ice::Int, ::Ice::Float, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * @param receiverUserIDs list of IDs of the users the message shall be sent to
     * @param context The Context map to send with the invocation.
     */
    void sendWelcomeMessage(const ::MumbleServer::IdList& receiverUserIDs, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_sendWelcomeMessage(_iceI_begin_sendWelcomeMessage(receiverUserIDs, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * @param receiverUserIDs list of IDs of the users the message shall be sent to
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_sendWelcomeMessage(const ::MumbleServer::IdList& receiverUserIDs, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_sendWelcomeMessage(receiverUserIDs, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * @param receiverUserIDs list of IDs of the users the message shall be sent to
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_sendWelcomeMessage(const ::MumbleServer::IdList& receiverUserIDs, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendWelcomeMessage(receiverUserIDs, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * @param receiverUserIDs list of IDs of the users the message shall be sent to
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_sendWelcomeMessage(const ::MumbleServer::IdList& receiverUserIDs, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendWelcomeMessage(receiverUserIDs, context, cb, cookie);
    }

    /**
     * @param receiverUserIDs list of IDs of the users the message shall be sent to
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_sendWelcomeMessage(const ::MumbleServer::IdList& receiverUserIDs, const ::MumbleServer::Callback_Server_sendWelcomeMessagePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendWelcomeMessage(receiverUserIDs, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * @param receiverUserIDs list of IDs of the users the message shall be sent to
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_sendWelcomeMessage(const ::MumbleServer::IdList& receiverUserIDs, const ::Ice::Context& context, const ::MumbleServer::Callback_Server_sendWelcomeMessagePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendWelcomeMessage(receiverUserIDs, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_sendWelcomeMessage.
     * @param result The asynchronous result object for the invocation.
     */
    void end_sendWelcomeMessage(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_sendWelcomeMessage(const ::MumbleServer::IdList&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class MetaCallback : public virtual ::Ice::Proxy<MetaCallback, ::IceProxy::Ice::Object>
{
public:

    /**
     * Called when a server is started. The server is up and running when this event is sent, so all methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param context The Context map to send with the invocation.
     */
    void started(const ::MumbleServer::ServerPrx& srv, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_started(_iceI_begin_started(srv, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Called when a server is started. The server is up and running when this event is sent, so all methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_started(const ::MumbleServer::ServerPrx& srv, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_started(srv, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Called when a server is started. The server is up and running when this event is sent, so all methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_started(const ::MumbleServer::ServerPrx& srv, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_started(srv, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called when a server is started. The server is up and running when this event is sent, so all methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_started(const ::MumbleServer::ServerPrx& srv, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_started(srv, context, cb, cookie);
    }

    /**
     * Called when a server is started. The server is up and running when this event is sent, so all methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_started(const ::MumbleServer::ServerPrx& srv, const ::MumbleServer::Callback_MetaCallback_startedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_started(srv, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called when a server is started. The server is up and running when this event is sent, so all methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_started(const ::MumbleServer::ServerPrx& srv, const ::Ice::Context& context, const ::MumbleServer::Callback_MetaCallback_startedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_started(srv, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_started.
     * @param result The asynchronous result object for the invocation.
     */
    void end_started(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_started(const ::MumbleServer::ServerPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Called when a server is stopped. The server is already stopped when this event is sent, so no methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param context The Context map to send with the invocation.
     */
    void stopped(const ::MumbleServer::ServerPrx& srv, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_stopped(_iceI_begin_stopped(srv, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Called when a server is stopped. The server is already stopped when this event is sent, so no methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stopped(const ::MumbleServer::ServerPrx& srv, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_stopped(srv, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Called when a server is stopped. The server is already stopped when this event is sent, so no methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stopped(const ::MumbleServer::ServerPrx& srv, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopped(srv, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called when a server is stopped. The server is already stopped when this event is sent, so no methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stopped(const ::MumbleServer::ServerPrx& srv, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopped(srv, context, cb, cookie);
    }

    /**
     * Called when a server is stopped. The server is already stopped when this event is sent, so no methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stopped(const ::MumbleServer::ServerPrx& srv, const ::MumbleServer::Callback_MetaCallback_stoppedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopped(srv, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Called when a server is stopped. The server is already stopped when this event is sent, so no methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stopped(const ::MumbleServer::ServerPrx& srv, const ::Ice::Context& context, const ::MumbleServer::Callback_MetaCallback_stoppedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopped(srv, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_stopped.
     * @param result The asynchronous result object for the invocation.
     */
    void end_stopped(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_stopped(const ::MumbleServer::ServerPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class Meta : public virtual ::Ice::Proxy<Meta, ::IceProxy::Ice::Object>
{
public:

    /**
     * Fetch interface to specific server.
     * @param id Server ID. See {@link Server.getId}.
     * @param context The Context map to send with the invocation.
     * @return Interface for specified server, or a null proxy if id is invalid.
     */
    ::MumbleServer::ServerPrx getServer(::Ice::Int id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getServer(_iceI_begin_getServer(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Fetch interface to specific server.
     * @param id Server ID. See {@link Server.getId}.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServer(::Ice::Int id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getServer(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Fetch interface to specific server.
     * @param id Server ID. See {@link Server.getId}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServer(::Ice::Int id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServer(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch interface to specific server.
     * @param id Server ID. See {@link Server.getId}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServer(::Ice::Int id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServer(id, context, cb, cookie);
    }

    /**
     * Fetch interface to specific server.
     * @param id Server ID. See {@link Server.getId}.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServer(::Ice::Int id, const ::MumbleServer::Callback_Meta_getServerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServer(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch interface to specific server.
     * @param id Server ID. See {@link Server.getId}.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServer(::Ice::Int id, const ::Ice::Context& context, const ::MumbleServer::Callback_Meta_getServerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServer(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getServer.
     * @param result The asynchronous result object for the invocation.
     * @return Interface for specified server, or a null proxy if id is invalid.
     */
    ::MumbleServer::ServerPrx end_getServer(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getServer(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Create a new server. Call {@link Server.getId} on the returned interface to find it's ID.
     * @param context The Context map to send with the invocation.
     * @return Interface for new server.
     */
    ::MumbleServer::ServerPrx newServer(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_newServer(_iceI_begin_newServer(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Create a new server. Call {@link Server.getId} on the returned interface to find it's ID.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_newServer(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_newServer(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Create a new server. Call {@link Server.getId} on the returned interface to find it's ID.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_newServer(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_newServer(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create a new server. Call {@link Server.getId} on the returned interface to find it's ID.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_newServer(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_newServer(context, cb, cookie);
    }

    /**
     * Create a new server. Call {@link Server.getId} on the returned interface to find it's ID.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_newServer(const ::MumbleServer::Callback_Meta_newServerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_newServer(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create a new server. Call {@link Server.getId} on the returned interface to find it's ID.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_newServer(const ::Ice::Context& context, const ::MumbleServer::Callback_Meta_newServerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_newServer(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_newServer.
     * @param result The asynchronous result object for the invocation.
     * @return Interface for new server.
     */
    ::MumbleServer::ServerPrx end_newServer(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_newServer(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Fetch list of all currently running servers.
     * @param context The Context map to send with the invocation.
     * @return List of interfaces for running servers.
     */
    ::MumbleServer::ServerList getBootedServers(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getBootedServers(_iceI_begin_getBootedServers(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Fetch list of all currently running servers.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getBootedServers(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getBootedServers(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Fetch list of all currently running servers.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getBootedServers(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getBootedServers(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch list of all currently running servers.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getBootedServers(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getBootedServers(context, cb, cookie);
    }

    /**
     * Fetch list of all currently running servers.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getBootedServers(const ::MumbleServer::Callback_Meta_getBootedServersPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getBootedServers(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch list of all currently running servers.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getBootedServers(const ::Ice::Context& context, const ::MumbleServer::Callback_Meta_getBootedServersPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getBootedServers(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getBootedServers.
     * @param result The asynchronous result object for the invocation.
     * @return List of interfaces for running servers.
     */
    ::MumbleServer::ServerList end_getBootedServers(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getBootedServers(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Fetch list of all defined servers.
     * @param context The Context map to send with the invocation.
     * @return List of interfaces for all servers.
     */
    ::MumbleServer::ServerList getAllServers(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getAllServers(_iceI_begin_getAllServers(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Fetch list of all defined servers.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllServers(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getAllServers(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Fetch list of all defined servers.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllServers(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllServers(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch list of all defined servers.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllServers(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllServers(context, cb, cookie);
    }

    /**
     * Fetch list of all defined servers.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllServers(const ::MumbleServer::Callback_Meta_getAllServersPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllServers(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch list of all defined servers.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllServers(const ::Ice::Context& context, const ::MumbleServer::Callback_Meta_getAllServersPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllServers(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getAllServers.
     * @param result The asynchronous result object for the invocation.
     * @return List of interfaces for all servers.
     */
    ::MumbleServer::ServerList end_getAllServers(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getAllServers(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Fetch default configuration. This returns the configuration items that were set in the configuration file, or
     * the built-in default. The individual servers will use these values unless they have been overridden in the
     * server specific configuration. The only special case is the port, which defaults to the value defined here +
     * the servers ID - 1 (so that virtual server #1 uses the defined port, server #2 uses port+1 etc).
     * @param context The Context map to send with the invocation.
     * @return Default configuration of the servers.
     */
    ::MumbleServer::ConfigMap getDefaultConf(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getDefaultConf(_iceI_begin_getDefaultConf(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Fetch default configuration. This returns the configuration items that were set in the configuration file, or
     * the built-in default. The individual servers will use these values unless they have been overridden in the
     * server specific configuration. The only special case is the port, which defaults to the value defined here +
     * the servers ID - 1 (so that virtual server #1 uses the defined port, server #2 uses port+1 etc).
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getDefaultConf(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getDefaultConf(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Fetch default configuration. This returns the configuration items that were set in the configuration file, or
     * the built-in default. The individual servers will use these values unless they have been overridden in the
     * server specific configuration. The only special case is the port, which defaults to the value defined here +
     * the servers ID - 1 (so that virtual server #1 uses the defined port, server #2 uses port+1 etc).
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getDefaultConf(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getDefaultConf(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch default configuration. This returns the configuration items that were set in the configuration file, or
     * the built-in default. The individual servers will use these values unless they have been overridden in the
     * server specific configuration. The only special case is the port, which defaults to the value defined here +
     * the servers ID - 1 (so that virtual server #1 uses the defined port, server #2 uses port+1 etc).
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getDefaultConf(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getDefaultConf(context, cb, cookie);
    }

    /**
     * Fetch default configuration. This returns the configuration items that were set in the configuration file, or
     * the built-in default. The individual servers will use these values unless they have been overridden in the
     * server specific configuration. The only special case is the port, which defaults to the value defined here +
     * the servers ID - 1 (so that virtual server #1 uses the defined port, server #2 uses port+1 etc).
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getDefaultConf(const ::MumbleServer::Callback_Meta_getDefaultConfPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getDefaultConf(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch default configuration. This returns the configuration items that were set in the configuration file, or
     * the built-in default. The individual servers will use these values unless they have been overridden in the
     * server specific configuration. The only special case is the port, which defaults to the value defined here +
     * the servers ID - 1 (so that virtual server #1 uses the defined port, server #2 uses port+1 etc).
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getDefaultConf(const ::Ice::Context& context, const ::MumbleServer::Callback_Meta_getDefaultConfPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getDefaultConf(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getDefaultConf.
     * @param result The asynchronous result object for the invocation.
     * @return Default configuration of the servers.
     */
    ::MumbleServer::ConfigMap end_getDefaultConf(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getDefaultConf(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Fetch version of Murmur.
     * @param major Major version.
     * @param minor Minor version.
     * @param patch Patchlevel.
     * @param text Textual representation of version. Note that this may not match the {@link major}, {@link minor} and {@link patch} levels, as it
     * may be simply the compile date or the SVN revision. This is usually the text you want to present to users.
     * @param context The Context map to send with the invocation.
     */
    void getVersion(::Ice::Int& major, ::Ice::Int& minor, ::Ice::Int& patch, ::std::string& text, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_getVersion(major, minor, patch, text, _iceI_begin_getVersion(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Fetch version of Murmur.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getVersion(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getVersion(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Fetch version of Murmur.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getVersion(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getVersion(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch version of Murmur.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getVersion(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getVersion(context, cb, cookie);
    }

    /**
     * Fetch version of Murmur.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getVersion(const ::MumbleServer::Callback_Meta_getVersionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getVersion(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Fetch version of Murmur.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getVersion(const ::Ice::Context& context, const ::MumbleServer::Callback_Meta_getVersionPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getVersion(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getVersion.
     * @param major Major version.
     * @param minor Minor version.
     * @param patch Patchlevel.
     * @param text Textual representation of version. Note that this may not match the {@link major}, {@link minor} and {@link patch} levels, as it
     * may be simply the compile date or the SVN revision. This is usually the text you want to present to users.
     * @param result The asynchronous result object for the invocation.
     */
    void end_getVersion(::Ice::Int& major, ::Ice::Int& minor, ::Ice::Int& patch, ::std::string& text, const ::Ice::AsyncResultPtr& result);
    /// \cond INTERNAL

    void _iceI_end_getVersion(::Ice::Int& iceP_major, ::Ice::Int& iceP_minor, ::Ice::Int& iceP_patch, ::std::string& iceP_text, const ::Ice::AsyncResultPtr&);
    /// \endcond

private:

    ::Ice::AsyncResultPtr _iceI_begin_getVersion(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Add a callback. The callback will receive notifications when servers are started or stopped.
     * @param cb Callback interface which will receive notifications.
     * @param context The Context map to send with the invocation.
     */
    void addCallback(const ::MumbleServer::MetaCallbackPrx& cb, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_addCallback(_iceI_begin_addCallback(cb, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Add a callback. The callback will receive notifications when servers are started or stopped.
     * @param cb Callback interface which will receive notifications.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addCallback(const ::MumbleServer::MetaCallbackPrx& cb, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_addCallback(cb, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Add a callback. The callback will receive notifications when servers are started or stopped.
     * @param cb Callback interface which will receive notifications.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addCallback(const ::MumbleServer::MetaCallbackPrx& cb, const ::Ice::CallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addCallback(cb, ::Ice::noExplicitContext, cb_, cookie);
    }

    /**
     * Add a callback. The callback will receive notifications when servers are started or stopped.
     * @param cb Callback interface which will receive notifications.
     * @param context The Context map to send with the invocation.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addCallback(const ::MumbleServer::MetaCallbackPrx& cb, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addCallback(cb, context, cb_, cookie);
    }

    /**
     * Add a callback. The callback will receive notifications when servers are started or stopped.
     * @param cb Callback interface which will receive notifications.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addCallback(const ::MumbleServer::MetaCallbackPrx& cb, const ::MumbleServer::Callback_Meta_addCallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addCallback(cb, ::Ice::noExplicitContext, cb_, cookie);
    }

    /**
     * Add a callback. The callback will receive notifications when servers are started or stopped.
     * @param cb Callback interface which will receive notifications.
     * @param context The Context map to send with the invocation.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addCallback(const ::MumbleServer::MetaCallbackPrx& cb, const ::Ice::Context& context, const ::MumbleServer::Callback_Meta_addCallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addCallback(cb, context, cb_, cookie);
    }

    /**
     * Completes an invocation of begin_addCallback.
     * @param result The asynchronous result object for the invocation.
     */
    void end_addCallback(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_addCallback(const ::MumbleServer::MetaCallbackPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed.
     * @param context The Context map to send with the invocation.
     */
    void removeCallback(const ::MumbleServer::MetaCallbackPrx& cb, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_removeCallback(_iceI_begin_removeCallback(cb, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeCallback(const ::MumbleServer::MetaCallbackPrx& cb, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_removeCallback(cb, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeCallback(const ::MumbleServer::MetaCallbackPrx& cb, const ::Ice::CallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeCallback(cb, ::Ice::noExplicitContext, cb_, cookie);
    }

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed.
     * @param context The Context map to send with the invocation.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeCallback(const ::MumbleServer::MetaCallbackPrx& cb, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeCallback(cb, context, cb_, cookie);
    }

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeCallback(const ::MumbleServer::MetaCallbackPrx& cb, const ::MumbleServer::Callback_Meta_removeCallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeCallback(cb, ::Ice::noExplicitContext, cb_, cookie);
    }

    /**
     * Remove a callback.
     * @param cb Callback interface to be removed.
     * @param context The Context map to send with the invocation.
     * @param cb_ Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeCallback(const ::MumbleServer::MetaCallbackPrx& cb, const ::Ice::Context& context, const ::MumbleServer::Callback_Meta_removeCallbackPtr& cb_, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeCallback(cb, context, cb_, cookie);
    }

    /**
     * Completes an invocation of begin_removeCallback.
     * @param result The asynchronous result object for the invocation.
     */
    void end_removeCallback(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_removeCallback(const ::MumbleServer::MetaCallbackPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get murmur uptime.
     * @param context The Context map to send with the invocation.
     * @return Uptime of murmur in seconds
     */
    ::Ice::Int getUptime(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getUptime(_iceI_begin_getUptime(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get murmur uptime.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getUptime(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getUptime(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get murmur uptime.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getUptime(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUptime(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get murmur uptime.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getUptime(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUptime(context, cb, cookie);
    }

    /**
     * Get murmur uptime.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getUptime(const ::MumbleServer::Callback_Meta_getUptimePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUptime(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get murmur uptime.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getUptime(const ::Ice::Context& context, const ::MumbleServer::Callback_Meta_getUptimePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUptime(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getUptime.
     * @param result The asynchronous result object for the invocation.
     * @return Uptime of murmur in seconds
     */
    ::Ice::Int end_getUptime(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getUptime(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get slice file.
     * @param context The Context map to send with the invocation.
     * @return Contents of the slice file server compiled with.
     */
    ::std::string getSlice(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getSlice(_iceI_begin_getSlice(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get slice file.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSlice(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getSlice(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get slice file.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSlice(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSlice(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get slice file.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSlice(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSlice(context, cb, cookie);
    }

    /**
     * Get slice file.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSlice(const ::MumbleServer::Callback_Meta_getSlicePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSlice(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get slice file.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSlice(const ::Ice::Context& context, const ::MumbleServer::Callback_Meta_getSlicePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSlice(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getSlice.
     * @param result The asynchronous result object for the invocation.
     * @return Contents of the slice file server compiled with.
     */
    ::std::string end_getSlice(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getSlice(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Returns a checksum dict for the slice file.
     * @param context The Context map to send with the invocation.
     * @return Checksum dict
     */
    ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getSliceChecksums(_iceI_begin_getSliceChecksums(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Returns a checksum dict for the slice file.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getSliceChecksums(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Returns a checksum dict for the slice file.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Returns a checksum dict for the slice file.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(context, cb, cookie);
    }

    /**
     * Returns a checksum dict for the slice file.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::MumbleServer::Callback_Meta_getSliceChecksumsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Returns a checksum dict for the slice file.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::Context& context, const ::MumbleServer::Callback_Meta_getSliceChecksumsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getSliceChecksums.
     * @param result The asynchronous result object for the invocation.
     * @return Checksum dict
     */
    ::Ice::SliceChecksumDict end_getSliceChecksums(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getSliceChecksums(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace MumbleServer
{

/**
 * User and subchannel state. Read-only.
 */
class Tree : public virtual ::Ice::Object, public ::IceInternal::GCObject
{
public:

    typedef TreePrx ProxyType;
    typedef TreePtr PointerType;

    virtual ~Tree();

    Tree()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param c Channel definition of current channel.
     * @param children List of subchannels.
     * @param users Users in this channel.
     */
    Tree(const ::MumbleServer::Channel& c, const ::MumbleServer::TreeList& children, const ::MumbleServer::UserList& users) :
        c(c),
        children(children),
        users(users)
    {
    }

#ifdef ICE_CPP11_COMPILER
    Tree(const Tree&) = default;
    Tree& operator=(const Tree&) = default;
#endif

    /**
     * Polymorphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
    /// \cond INTERNAL
    virtual void _iceGcVisitMembers(::IceInternal::GCVisitor&);
    /// \endcond

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond

public:

    /**
     * Channel definition of current channel.
     */
    ::MumbleServer::Channel c;
    /**
     * List of subchannels.
     */
    ::MumbleServer::TreeList children;
    /**
     * Users in this channel.
     */
    ::MumbleServer::UserList users;
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_Tree_init = ::MumbleServer::Tree::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const Tree& lhs, const Tree& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Tree& lhs, const Tree& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Callback interface for servers. You can supply an implementation of this to receive notification
 * messages from the server.
 * If an added callback ever throws an exception or goes away, it will be automatically removed.
 * Please note that all callbacks are done asynchronously; murmur does not wait for the callback to
 * complete before continuing processing.
 * Note that callbacks are removed when a server is stopped, so you should have a callback for
 * {@link MetaCallback.started} which calls {@link Server.addCallback}.
 * @see MetaCallback
 * @see Server.addCallback
 */
class ServerCallback : public virtual ::Ice::Object
{
public:

    typedef ServerCallbackPrx ProxyType;
    typedef ServerCallbackPtr PointerType;

    virtual ~ServerCallback();

#ifdef ICE_CPP11_COMPILER
    ServerCallback() = default;
    ServerCallback(const ServerCallback&) = default;
    ServerCallback& operator=(const ServerCallback&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Called when a user connects to the server.
     * @param state State of connected user.
     * @param current The Current object for the invocation.
     */
    virtual void userConnected(const User& state, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_userConnected(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Called when a user disconnects from the server. The user has already been removed, so you can no longer use methods like {@link Server.getState}
     * to retrieve the user's state.
     * @param state State of disconnected user.
     * @param current The Current object for the invocation.
     */
    virtual void userDisconnected(const User& state, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_userDisconnected(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Called when a user state changes. This is called if the user moves, is renamed, is muted, deafened etc.
     * @param state New state of user.
     * @param current The Current object for the invocation.
     */
    virtual void userStateChanged(const User& state, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_userStateChanged(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Called when user writes a text message
     * @param state the User sending the message
     * @param message the TextMessage the user has sent
     * @param current The Current object for the invocation.
     */
    virtual void userTextMessage(const User& state, const TextMessage& message, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_userTextMessage(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Called when a new channel is created.
     * @param state State of new channel.
     * @param current The Current object for the invocation.
     */
    virtual void channelCreated(const Channel& state, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_channelCreated(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Called when a channel is removed. The channel has already been removed, you can no longer use methods like {@link Server.getChannelState}
     * @param state State of removed channel.
     * @param current The Current object for the invocation.
     */
    virtual void channelRemoved(const Channel& state, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_channelRemoved(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Called when a new channel state changes. This is called if the channel is moved, renamed or if new links are added.
     * @param state New state of channel.
     * @param current The Current object for the invocation.
     */
    virtual void channelStateChanged(const Channel& state, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_channelStateChanged(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const ServerCallback& lhs, const ServerCallback& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ServerCallback& lhs, const ServerCallback& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Callback interface for context actions. You need to supply one of these for {@link Server.addContext}.
 * If an added callback ever throws an exception or goes away, it will be automatically removed.
 * Please note that all callbacks are done asynchronously; murmur does not wait for the callback to
 * complete before continuing processing.
 */
class ServerContextCallback : public virtual ::Ice::Object
{
public:

    typedef ServerContextCallbackPrx ProxyType;
    typedef ServerContextCallbackPtr PointerType;

    virtual ~ServerContextCallback();

#ifdef ICE_CPP11_COMPILER
    ServerContextCallback() = default;
    ServerContextCallback(const ServerContextCallback&) = default;
    ServerContextCallback& operator=(const ServerContextCallback&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Called when a context action is performed.
     * @param action Action to be performed.
     * @param usr User which initiated the action.
     * @param session If nonzero, session of target user.
     * @param channelid If not -1, id of target channel.
     * @param current The Current object for the invocation.
     */
    virtual void contextAction(const ::std::string& action, const User& usr, ::Ice::Int session, ::Ice::Int channelid, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_contextAction(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const ServerContextCallback& lhs, const ServerContextCallback& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ServerContextCallback& lhs, const ServerContextCallback& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Callback interface for server authentication. You need to supply one of these for {@link Server.setAuthenticator}.
 * If an added callback ever throws an exception or goes away, it will be automatically removed.
 * Please note that unlike {@link ServerCallback} and {@link ServerContextCallback}, these methods are called
 * synchronously. If the response lags, the entire murmur server will lag.
 * Also note that, as the method calls are synchronous, making a call to {@link Server} or {@link Meta} will
 * deadlock the server.
 */
class ServerAuthenticator : public virtual ::Ice::Object
{
public:

    typedef ServerAuthenticatorPrx ProxyType;
    typedef ServerAuthenticatorPtr PointerType;

    virtual ~ServerAuthenticator();

#ifdef ICE_CPP11_COMPILER
    ServerAuthenticator() = default;
    ServerAuthenticator(const ServerAuthenticator&) = default;
    ServerAuthenticator& operator=(const ServerAuthenticator&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Called to authenticate a user. If you do not know the username in question, always return -2 from this
     * method to fall through to normal database authentication.
     * Note that if authentication succeeds, murmur will create a record of the user in it's database, reserving
     * the username and id so it cannot be used for normal database authentication.
     * The data in the certificate (name, email addresses etc), as well as the list of signing certificates,
     * should only be trusted if certstrong is true.
     *
     * Internally, Murmur treats usernames as case-insensitive. It is recommended
     * that authenticators do the same. Murmur checks if a username is in use when
     * a user connects. If the connecting user is registered, the other username is
     * kicked. If the connecting user is not registered, the connecting user is not
     * allowed to join the server.
     * @param name Username to authenticate.
     * @param pw Password to authenticate with.
     * @param certificates List of der encoded certificates the user connected with.
     * @param certhash Hash of user certificate, as used by murmur internally when matching.
     * @param certstrong True if certificate was valid and signed by a trusted CA.
     * @param newname Set this to change the username from the supplied one.
     * @param groups List of groups on the root channel that the user will be added to for the duration of the connection.
     * @param current The Current object for the invocation.
     * @return UserID of authenticated user, -1 for authentication failures, -2 for unknown user (fallthrough),
     * -3 for authentication failures where the data could (temporarily) not be verified.
     */
    virtual ::Ice::Int authenticate(const ::std::string& name, const ::std::string& pw, const CertificateList& certificates, const ::std::string& certhash, bool certstrong, ::std::string& newname, GroupNameList& groups, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_authenticate(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch information about a user. This is used to retrieve information like email address, keyhash etc. If you
     * want murmur to take care of this information itself, simply return false to fall through.
     * @param id User id.
     * @param info Information about user. This needs to include at least "name".
     * @param current The Current object for the invocation.
     * @return true if information is present, false to fall through.
     */
    virtual bool getInfo(::Ice::Int id, UserInfoMap& info, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getInfo(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Map a name to a user id.
     * @param name Username to map.
     * @param current The Current object for the invocation.
     * @return User id or -2 for unknown name.
     */
    virtual ::Ice::Int nameToId(const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_nameToId(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Map a user id to a username.
     * @param id User id to map.
     * @param current The Current object for the invocation.
     * @return Name of user or empty string for unknown id.
     */
    virtual ::std::string idToName(::Ice::Int id, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_idToName(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Map a user to a custom Texture.
     * @param id User id to map.
     * @param current The Current object for the invocation.
     * @return User texture or an empty texture for unknown users or users without textures.
     */
    virtual Texture idToTexture(::Ice::Int id, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_idToTexture(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const ServerAuthenticator& lhs, const ServerAuthenticator& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ServerAuthenticator& lhs, const ServerAuthenticator& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Callback interface for server authentication and registration. This allows you to support both authentication
 * and account updating.
 * You do not need to implement this if all you want is authentication, you only need this if other scripts
 * connected to the same server calls e.g. {@link Server.setTexture}.
 * Almost all of these methods support fall through, meaning murmur should continue the operation against its
 * own database.
 */
class ServerUpdatingAuthenticator : virtual public ServerAuthenticator
{
public:

    typedef ServerUpdatingAuthenticatorPrx ProxyType;
    typedef ServerUpdatingAuthenticatorPtr PointerType;

    virtual ~ServerUpdatingAuthenticator();

#ifdef ICE_CPP11_COMPILER
    ServerUpdatingAuthenticator() = default;
    ServerUpdatingAuthenticator(const ServerUpdatingAuthenticator&) = default;
    ServerUpdatingAuthenticator& operator=(const ServerUpdatingAuthenticator&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Register a new user.
     * @param info Information about user to register.
     * @param current The Current object for the invocation.
     * @return User id of new user, -1 for registration failure, or -2 to fall through.
     */
    virtual ::Ice::Int registerUser(const UserInfoMap& info, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_registerUser(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Unregister a user.
     * @param id Userid to unregister.
     * @param current The Current object for the invocation.
     * @return 1 for successful unregistration, 0 for unsuccessful unregistration, -1 to fall through.
     */
    virtual ::Ice::Int unregisterUser(::Ice::Int id, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_unregisterUser(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get a list of registered users matching filter.
     * @param filter Substring usernames must contain. If empty, return all registered users.
     * @param current The Current object for the invocation.
     * @return List of matching registered users.
     */
    virtual NameMap getRegisteredUsers(const ::std::string& filter, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getRegisteredUsers(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set additional information for user registration.
     * @param id Userid of registered user.
     * @param info Information to set about user. This should be merged with existing information.
     * @param current The Current object for the invocation.
     * @return 1 for successful update, 0 for unsuccessful update, -1 to fall through.
     */
    virtual ::Ice::Int setInfo(::Ice::Int id, const UserInfoMap& info, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setInfo(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set texture (now called avatar) of user registration.
     * @param id registrationId of registered user.
     * @param tex New texture.
     * @param current The Current object for the invocation.
     * @return 1 for successful update, 0 for unsuccessful update, -1 to fall through.
     */
    virtual ::Ice::Int setTexture(::Ice::Int id, const Texture& tex, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setTexture(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const ServerUpdatingAuthenticator& lhs, const ServerUpdatingAuthenticator& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ServerUpdatingAuthenticator& lhs, const ServerUpdatingAuthenticator& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Per-server interface. This includes all methods for configuring and altering
 * the state of a single virtual server. You can retrieve a pointer to this interface
 * from one of the methods in {@link Meta}.
 */
class Server : public virtual ::Ice::Object
{
public:

    typedef ServerPrx ProxyType;
    typedef ServerPtr PointerType;

    virtual ~Server();

#ifdef ICE_CPP11_COMPILER
    Server() = default;
    Server(const Server&) = default;
    Server& operator=(const Server&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Shows if the server currently running (accepting users).
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void isRunning_async(const ::MumbleServer::AMD_Server_isRunningPtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_isRunning(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Start server.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void start_async(const ::MumbleServer::AMD_Server_startPtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_start(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Stop server.
     * Note: Server will be restarted on Murmur restart unless explicitly disabled
     * with setConf("boot", false)
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void stop_async(const ::MumbleServer::AMD_Server_stopPtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_stop(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Delete server and all it's configuration.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void delete_async(const ::MumbleServer::AMD_Server_deletePtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_delete(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch the server id.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void id_async(const ::MumbleServer::AMD_Server_idPtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_id(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Add a callback. The callback will receive notifications about changes to users and channels.
     * @param cb_ The AMD callback object for the invocation.
     * @param cb Callback interface which will receive notifications.
     * @param current The Current object for the invocation.
     * @see removeCallback
     */
    virtual void addCallback_async(const ::MumbleServer::AMD_Server_addCallbackPtr& cb_, const ServerCallbackPrx& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_addCallback(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove a callback.
     * @param cb_ The AMD callback object for the invocation.
     * @param cb Callback interface to be removed.
     * @param current The Current object for the invocation.
     * @see addCallback
     */
    virtual void removeCallback_async(const ::MumbleServer::AMD_Server_removeCallbackPtr& cb_, const ServerCallbackPrx& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_removeCallback(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set external authenticator. If set, all authentications from clients are forwarded to this
     * proxy.
     * @param cb The AMD callback object for the invocation.
     * @param auth Authenticator object to perform subsequent authentications.
     * @param current The Current object for the invocation.
     */
    virtual void setAuthenticator_async(const ::MumbleServer::AMD_Server_setAuthenticatorPtr& cb, const ServerAuthenticatorPrx& auth, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setAuthenticator(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Retrieve configuration item.
     * @param cb The AMD callback object for the invocation.
     * @param key Configuration key.
     * @param current The Current object for the invocation.
     */
    virtual void getConf_async(const ::MumbleServer::AMD_Server_getConfPtr& cb, const ::std::string& key, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getConf(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Retrieve all configuration items.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void getAllConf_async(const ::MumbleServer::AMD_Server_getAllConfPtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getAllConf(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set a configuration item.
     * @param cb The AMD callback object for the invocation.
     * @param key Configuration key.
     * @param value Configuration value.
     * @param current The Current object for the invocation.
     */
    virtual void setConf_async(const ::MumbleServer::AMD_Server_setConfPtr& cb, const ::std::string& key, const ::std::string& value, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setConf(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set superuser password. This is just a convenience for using {@link updateRegistration} on user id 0.
     * @param cb The AMD callback object for the invocation.
     * @param pw Password.
     * @param current The Current object for the invocation.
     */
    virtual void setSuperuserPassword_async(const ::MumbleServer::AMD_Server_setSuperuserPasswordPtr& cb, const ::std::string& pw, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setSuperuserPassword(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch log entries.
     * @param cb The AMD callback object for the invocation.
     * @param first Lowest numbered entry to fetch. 0 is the most recent item.
     * @param last Last entry to fetch.
     * @param current The Current object for the invocation.
     */
    virtual void getLog_async(const ::MumbleServer::AMD_Server_getLogPtr& cb, ::Ice::Int first, ::Ice::Int last, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getLog(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch length of log
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void getLogLen_async(const ::MumbleServer::AMD_Server_getLogLenPtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getLogLen(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch all users. This returns all currently connected users on the server.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     * @see getState
     */
    virtual void getUsers_async(const ::MumbleServer::AMD_Server_getUsersPtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getUsers(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch all channels. This returns all defined channels on the server. The root channel is always channel 0.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     * @see getChannelState
     */
    virtual void getChannels_async(const ::MumbleServer::AMD_Server_getChannelsPtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getChannels(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch certificate of user. This returns the complete certificate chain of a user.
     * @param cb The AMD callback object for the invocation.
     * @param session Connection ID of user. See {@link User.session}.
     * @param current The Current object for the invocation.
     */
    virtual void getCertificateList_async(const ::MumbleServer::AMD_Server_getCertificateListPtr& cb, ::Ice::Int session, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getCertificateList(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch all channels and connected users as a tree. This retrieves an easy-to-use representation of the server
     * as a tree. This is primarily used for viewing the state of the server on a webpage.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void getTree_async(const ::MumbleServer::AMD_Server_getTreePtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getTree(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch all current IP bans on the server.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void getBans_async(const ::MumbleServer::AMD_Server_getBansPtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getBans(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set all current IP bans on the server. This will replace any bans already present, so if you want to add a ban, be sure to call {@link getBans} and then
     * append to the returned list before calling this method.
     * @param cb The AMD callback object for the invocation.
     * @param bans List of bans.
     * @param current The Current object for the invocation.
     */
    virtual void setBans_async(const ::MumbleServer::AMD_Server_setBansPtr& cb, const BanList& bans, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setBans(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Kick a user. The user is not banned, and is free to rejoin the server.
     * @param cb The AMD callback object for the invocation.
     * @param session Connection ID of user. See {@link User.session}.
     * @param reason Text message to show when user is kicked.
     * @param current The Current object for the invocation.
     */
    virtual void kickUser_async(const ::MumbleServer::AMD_Server_kickUserPtr& cb, ::Ice::Int session, const ::std::string& reason, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_kickUser(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get state of a single connected user.
     * @param cb The AMD callback object for the invocation.
     * @param session Connection ID of user. See {@link User.session}.
     * @param current The Current object for the invocation.
     * @see setState
     * @see getUsers
     */
    virtual void getState_async(const ::MumbleServer::AMD_Server_getStatePtr& cb, ::Ice::Int session, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getState(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set user state. You can use this to move, mute and deafen users.
     * @param cb The AMD callback object for the invocation.
     * @param state User state to set.
     * @param current The Current object for the invocation.
     * @see getState
     */
    virtual void setState_async(const ::MumbleServer::AMD_Server_setStatePtr& cb, const User& state, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setState(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Send text message to a single user.
     * @param cb The AMD callback object for the invocation.
     * @param session Connection ID of user. See {@link User.session}.
     * @param text Message to send.
     * @param current The Current object for the invocation.
     * @see sendMessageChannel
     */
    virtual void sendMessage_async(const ::MumbleServer::AMD_Server_sendMessagePtr& cb, ::Ice::Int session, const ::std::string& text, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_sendMessage(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Check if user is permitted to perform action.
     * @param cb The AMD callback object for the invocation.
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param perm Permission bits to check.
     * @param current The Current object for the invocation.
     */
    virtual void hasPermission_async(const ::MumbleServer::AMD_Server_hasPermissionPtr& cb, ::Ice::Int session, ::Ice::Int channelid, ::Ice::Int perm, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_hasPermission(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Return users effective permissions
     * @param cb The AMD callback object for the invocation.
     * @param session Connection ID of user. See {@link User.session}.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param current The Current object for the invocation.
     */
    virtual void effectivePermissions_async(const ::MumbleServer::AMD_Server_effectivePermissionsPtr& cb, ::Ice::Int session, ::Ice::Int channelid, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_effectivePermissions(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Add a context callback. This is done per user, and will add a context menu action for the user.
     * @param cb_ The AMD callback object for the invocation.
     * @param session Session of user which should receive context entry.
     * @param action Action string, a unique name to associate with the action.
     * @param text Name of action shown to user.
     * @param cb Callback interface which will receive notifications.
     * @param ctx Context this should be used in. Needs to be one or a combination of {@link ContextServer}, {@link ContextChannel} and {@link ContextUser}.
     * @param current The Current object for the invocation.
     * @see removeContextCallback
     */
    virtual void addContextCallback_async(const ::MumbleServer::AMD_Server_addContextCallbackPtr& cb_, ::Ice::Int session, const ::std::string& action, const ::std::string& text, const ServerContextCallbackPrx& cb, ::Ice::Int ctx, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_addContextCallback(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove a callback.
     * @param cb_ The AMD callback object for the invocation.
     * @param cb Callback interface to be removed. This callback will be removed from all from all users.
     * @param current The Current object for the invocation.
     * @see addContextCallback
     */
    virtual void removeContextCallback_async(const ::MumbleServer::AMD_Server_removeContextCallbackPtr& cb_, const ServerContextCallbackPrx& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_removeContextCallback(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get state of single channel.
     * @param cb The AMD callback object for the invocation.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param current The Current object for the invocation.
     * @see setChannelState
     * @see getChannels
     */
    virtual void getChannelState_async(const ::MumbleServer::AMD_Server_getChannelStatePtr& cb, ::Ice::Int channelid, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getChannelState(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set state of a single channel. You can use this to move or relink channels.
     * @param cb The AMD callback object for the invocation.
     * @param state Channel state to set.
     * @param current The Current object for the invocation.
     * @see getChannelState
     */
    virtual void setChannelState_async(const ::MumbleServer::AMD_Server_setChannelStatePtr& cb, const Channel& state, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setChannelState(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove a channel and all its subchannels.
     * @param cb The AMD callback object for the invocation.
     * @param channelid ID of Channel. See {@link Channel.id}.
     * @param current The Current object for the invocation.
     */
    virtual void removeChannel_async(const ::MumbleServer::AMD_Server_removeChannelPtr& cb, ::Ice::Int channelid, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_removeChannel(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Add a new channel.
     * @param cb The AMD callback object for the invocation.
     * @param name Name of new channel.
     * @param parent Channel ID of parent channel. See {@link Channel.id}.
     * @param current The Current object for the invocation.
     */
    virtual void addChannel_async(const ::MumbleServer::AMD_Server_addChannelPtr& cb, const ::std::string& name, ::Ice::Int parent, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_addChannel(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Send text message to channel or a tree of channels.
     * @param cb The AMD callback object for the invocation.
     * @param channelid Channel ID of channel to send to. See {@link Channel.id}.
     * @param tree If true, the message will be sent to the channel and all its subchannels.
     * @param text Message to send.
     * @param current The Current object for the invocation.
     * @see sendMessage
     */
    virtual void sendMessageChannel_async(const ::MumbleServer::AMD_Server_sendMessageChannelPtr& cb, ::Ice::Int channelid, bool tree, const ::std::string& text, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_sendMessageChannel(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Retrieve ACLs and Groups on a channel.
     * @param cb The AMD callback object for the invocation.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param current The Current object for the invocation.
     */
    virtual void getACL_async(const ::MumbleServer::AMD_Server_getACLPtr& cb, ::Ice::Int channelid, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getACL(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set ACLs and Groups on a channel. Note that this will replace all existing ACLs and groups on the channel.
     * @param cb The AMD callback object for the invocation.
     * @param channelid Channel ID of channel to fetch from. See {@link Channel.id}.
     * @param acls List of ACLs on the channel.
     * @param groups List of groups on the channel.
     * @param inherit Should this channel inherit ACLs from the parent channel?
     * @param current The Current object for the invocation.
     */
    virtual void setACL_async(const ::MumbleServer::AMD_Server_setACLPtr& cb, ::Ice::Int channelid, const ACLList& acls, const GroupList& groups, bool inherit, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setACL(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Temporarily add a user to a group on a channel. This state is not saved, and is intended for temporary memberships.
     * @param cb The AMD callback object for the invocation.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to add to.
     * @param current The Current object for the invocation.
     */
    virtual void addUserToGroup_async(const ::MumbleServer::AMD_Server_addUserToGroupPtr& cb, ::Ice::Int channelid, ::Ice::Int session, const ::std::string& group, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_addUserToGroup(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove a user from a temporary group membership on a channel. This state is not saved, and is intended for temporary memberships.
     * @param cb The AMD callback object for the invocation.
     * @param channelid Channel ID of channel to add to. See {@link Channel.id}.
     * @param session Connection ID of user. See {@link User.session}.
     * @param group Group name to remove from.
     * @param current The Current object for the invocation.
     */
    virtual void removeUserFromGroup_async(const ::MumbleServer::AMD_Server_removeUserFromGroupPtr& cb, ::Ice::Int channelid, ::Ice::Int session, const ::std::string& group, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_removeUserFromGroup(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Redirect whisper targets for user. If set, whenever a user tries to whisper to group "source", the whisper will be redirected to group "target".
     * To remove a redirect pass an empty target string. This is intended for context groups.
     * @param cb The AMD callback object for the invocation.
     * @param session Connection ID of user. See {@link User.session}.
     * @param source Group name to redirect from.
     * @param target Group name to redirect to.
     * @param current The Current object for the invocation.
     */
    virtual void redirectWhisperGroup_async(const ::MumbleServer::AMD_Server_redirectWhisperGroupPtr& cb, ::Ice::Int session, const ::std::string& source, const ::std::string& target, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_redirectWhisperGroup(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Map a list of {@link User.userid} to a matching name.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void getUserNames_async(const ::MumbleServer::AMD_Server_getUserNamesPtr& cb, const IdList& ids, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getUserNames(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Map a list of user names to a matching id.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     * @reuturn List of matching ids, with -1 representing invalid or unknown user names.
     */
    virtual void getUserIds_async(const ::MumbleServer::AMD_Server_getUserIdsPtr& cb, const NameList& names, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getUserIds(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Register a new user.
     * @param cb The AMD callback object for the invocation.
     * @param info Information about new user. Must include at least "name".
     * @param current The Current object for the invocation.
     */
    virtual void registerUser_async(const ::MumbleServer::AMD_Server_registerUserPtr& cb, const UserInfoMap& info, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_registerUser(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove a user registration.
     * @param cb The AMD callback object for the invocation.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param current The Current object for the invocation.
     */
    virtual void unregisterUser_async(const ::MumbleServer::AMD_Server_unregisterUserPtr& cb, ::Ice::Int userid, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_unregisterUser(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Update the registration for a user. You can use this to set the email or password of a user,
     * and can also use it to change the user's name.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void updateRegistration_async(const ::MumbleServer::AMD_Server_updateRegistrationPtr& cb, ::Ice::Int userid, const UserInfoMap& info, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_updateRegistration(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch registration for a single user.
     * @param cb The AMD callback object for the invocation.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param current The Current object for the invocation.
     */
    virtual void getRegistration_async(const ::MumbleServer::AMD_Server_getRegistrationPtr& cb, ::Ice::Int userid, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getRegistration(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch a group of registered users.
     * @param cb The AMD callback object for the invocation.
     * @param filter Substring of user name. If blank, will retrieve all registered users.
     * @param current The Current object for the invocation.
     */
    virtual void getRegisteredUsers_async(const ::MumbleServer::AMD_Server_getRegisteredUsersPtr& cb, const ::std::string& filter, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getRegisteredUsers(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Verify the password of a user. You can use this to verify a user's credentials.
     * @param cb The AMD callback object for the invocation.
     * @param name User name. See {@link RegisteredUser.name}.
     * @param pw User password.
     * @param current The Current object for the invocation.
     */
    virtual void verifyPassword_async(const ::MumbleServer::AMD_Server_verifyPasswordPtr& cb, const ::std::string& name, const ::std::string& pw, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_verifyPassword(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch user texture. Textures are stored as zlib compress()ed 600x60 32-bit BGRA data.
     * @param cb The AMD callback object for the invocation.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param current The Current object for the invocation.
     */
    virtual void getTexture_async(const ::MumbleServer::AMD_Server_getTexturePtr& cb, ::Ice::Int userid, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getTexture(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set a user texture (now called avatar).
     * @param cb The AMD callback object for the invocation.
     * @param userid ID of registered user. See {@link RegisteredUser.userid}.
     * @param tex Texture (as a Byte-Array) to set for the user, or an empty texture to remove the existing texture.
     * @param current The Current object for the invocation.
     */
    virtual void setTexture_async(const ::MumbleServer::AMD_Server_setTexturePtr& cb, ::Ice::Int userid, const Texture& tex, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setTexture(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get virtual server uptime.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void getUptime_async(const ::MumbleServer::AMD_Server_getUptimePtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getUptime(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Update the server's certificate information.
     *
     * Reconfigure the running server's TLS socket with the given
     * certificate and private key.
     *
     * The certificate and and private key must be PEM formatted.
     *
     * New clients will see the new certificate.
     * Existing clients will continue to see the certificate the server
     * was using when they connected to it.
     *
     * This method throws InvalidInputDataException if any of the
     * following errors happen:
     * - Unable to decode the PEM certificate and/or private key.
     * - Unable to decrypt the private key with the given passphrase.
     * - The certificate and/or private key do not contain RSA keys.
     * - The certificate is not usable with the given private key.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void updateCertificate_async(const ::MumbleServer::AMD_Server_updateCertificatePtr& cb, const ::std::string& certificate, const ::std::string& privateKey, const ::std::string& passphrase, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_updateCertificate(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Makes the given user start listening to the given channel.
     * @param cb The AMD callback object for the invocation.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param current The Current object for the invocation.
     */
    virtual void startListening_async(const ::MumbleServer::AMD_Server_startListeningPtr& cb, ::Ice::Int userid, ::Ice::Int channelid, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_startListening(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Makes the given user stop listening to the given channel.
     * @param cb The AMD callback object for the invocation.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param current The Current object for the invocation.
     */
    virtual void stopListening_async(const ::MumbleServer::AMD_Server_stopListeningPtr& cb, ::Ice::Int userid, ::Ice::Int channelid, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_stopListening(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * @param cb The AMD callback object for the invocation.
     * @param userid The ID of the user
     * @param channelid The ID of the channel
     * @param current The Current object for the invocation.
     */
    virtual void isListening_async(const ::MumbleServer::AMD_Server_isListeningPtr& cb, ::Ice::Int userid, ::Ice::Int channelid, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_isListening(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * @param cb The AMD callback object for the invocation.
     * @param userid The ID of the user
     * @param current The Current object for the invocation.
     */
    virtual void getListeningChannels_async(const ::MumbleServer::AMD_Server_getListeningChannelsPtr& cb, ::Ice::Int userid, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getListeningChannels(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * @param cb The AMD callback object for the invocation.
     * @param channelid The ID of the channel
     * @param current The Current object for the invocation.
     */
    virtual void getListeningUsers_async(const ::MumbleServer::AMD_Server_getListeningUsersPtr& cb, ::Ice::Int channelid, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getListeningUsers(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * @param cb The AMD callback object for the invocation.
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param current The Current object for the invocation.
     */
    virtual void getListenerVolumeAdjustment_async(const ::MumbleServer::AMD_Server_getListenerVolumeAdjustmentPtr& cb, ::Ice::Int channelid, ::Ice::Int userid, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getListenerVolumeAdjustment(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Sets the volume adjustment set for a listener of the given user in the given channel
     * @param cb The AMD callback object for the invocation.
     * @param channelid The ID of the channel
     * @param userid The ID of the user
     * @param current The Current object for the invocation.
     */
    virtual void setListenerVolumeAdjustment_async(const ::MumbleServer::AMD_Server_setListenerVolumeAdjustmentPtr& cb, ::Ice::Int channelid, ::Ice::Int userid, ::Ice::Float volumeAdjustment, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setListenerVolumeAdjustment(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * @param cb The AMD callback object for the invocation.
     * @param receiverUserIDs list of IDs of the users the message shall be sent to
     * @param current The Current object for the invocation.
     */
    virtual void sendWelcomeMessage_async(const ::MumbleServer::AMD_Server_sendWelcomeMessagePtr& cb, const IdList& receiverUserIDs, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_sendWelcomeMessage(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const Server& lhs, const Server& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Server& lhs, const Server& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Callback interface for Meta. You can supply an implementation of this to receive notifications
 * when servers are stopped or started.
 * If an added callback ever throws an exception or goes away, it will be automatically removed.
 * Please note that all callbacks are done asynchronously; murmur does not wait for the callback to
 * complete before continuing processing.
 * @see ServerCallback
 * @see Meta.addCallback
 */
class MetaCallback : public virtual ::Ice::Object
{
public:

    typedef MetaCallbackPrx ProxyType;
    typedef MetaCallbackPtr PointerType;

    virtual ~MetaCallback();

#ifdef ICE_CPP11_COMPILER
    MetaCallback() = default;
    MetaCallback(const MetaCallback&) = default;
    MetaCallback& operator=(const MetaCallback&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Called when a server is started. The server is up and running when this event is sent, so all methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param current The Current object for the invocation.
     */
    virtual void started(const ServerPrx& srv, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_started(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Called when a server is stopped. The server is already stopped when this event is sent, so no methods that
     * need a running server will work.
     * @param srv Interface for started server.
     * @param current The Current object for the invocation.
     */
    virtual void stopped(const ServerPrx& srv, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_stopped(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const MetaCallback& lhs, const MetaCallback& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const MetaCallback& lhs, const MetaCallback& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * This is the meta interface. It is primarily used for retrieving the {@link Server} interfaces for each individual server.
 */
class Meta : public virtual ::Ice::Object
{
public:

    typedef MetaPrx ProxyType;
    typedef MetaPtr PointerType;

    virtual ~Meta();

#ifdef ICE_CPP11_COMPILER
    Meta() = default;
    Meta(const Meta&) = default;
    Meta& operator=(const Meta&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Fetch interface to specific server.
     * @param cb The AMD callback object for the invocation.
     * @param id Server ID. See {@link Server.getId}.
     * @param current The Current object for the invocation.
     */
    virtual void getServer_async(const ::MumbleServer::AMD_Meta_getServerPtr& cb, ::Ice::Int id, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getServer(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Create a new server. Call {@link Server.getId} on the returned interface to find it's ID.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void newServer_async(const ::MumbleServer::AMD_Meta_newServerPtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_newServer(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch list of all currently running servers.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void getBootedServers_async(const ::MumbleServer::AMD_Meta_getBootedServersPtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getBootedServers(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch list of all defined servers.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void getAllServers_async(const ::MumbleServer::AMD_Meta_getAllServersPtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getAllServers(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch default configuration. This returns the configuration items that were set in the configuration file, or
     * the built-in default. The individual servers will use these values unless they have been overridden in the
     * server specific configuration. The only special case is the port, which defaults to the value defined here +
     * the servers ID - 1 (so that virtual server #1 uses the defined port, server #2 uses port+1 etc).
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void getDefaultConf_async(const ::MumbleServer::AMD_Meta_getDefaultConfPtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getDefaultConf(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Fetch version of Murmur.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void getVersion_async(const ::MumbleServer::AMD_Meta_getVersionPtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getVersion(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Add a callback. The callback will receive notifications when servers are started or stopped.
     * @param cb_ The AMD callback object for the invocation.
     * @param cb Callback interface which will receive notifications.
     * @param current The Current object for the invocation.
     */
    virtual void addCallback_async(const ::MumbleServer::AMD_Meta_addCallbackPtr& cb_, const MetaCallbackPrx& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_addCallback(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove a callback.
     * @param cb_ The AMD callback object for the invocation.
     * @param cb Callback interface to be removed.
     * @param current The Current object for the invocation.
     */
    virtual void removeCallback_async(const ::MumbleServer::AMD_Meta_removeCallbackPtr& cb_, const MetaCallbackPrx& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_removeCallback(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get murmur uptime.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void getUptime_async(const ::MumbleServer::AMD_Meta_getUptimePtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getUptime(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get slice file.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void getSlice_async(const ::MumbleServer::AMD_Meta_getSlicePtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getSlice(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Returns a checksum dict for the slice file.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void getSliceChecksums_async(const ::MumbleServer::AMD_Meta_getSliceChecksumsPtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getSliceChecksums(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const Meta& lhs, const Meta& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Meta& lhs, const Meta& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::MumbleServer::User>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 60;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::MumbleServer::User, S>
{
    static void write(S* ostr, const ::MumbleServer::User& v)
    {
        ostr->write(v.session);
        ostr->write(v.userid);
        ostr->write(v.mute);
        ostr->write(v.deaf);
        ostr->write(v.suppress);
        ostr->write(v.prioritySpeaker);
        ostr->write(v.selfMute);
        ostr->write(v.selfDeaf);
        ostr->write(v.recording);
        ostr->write(v.channel);
        ostr->write(v.name);
        ostr->write(v.onlinesecs);
        ostr->write(v.bytespersec);
        ostr->write(v.version);
        ostr->write(v.version2);
        ostr->write(v.release);
        ostr->write(v.os);
        ostr->write(v.osversion);
        ostr->write(v.identity);
        ostr->write(v.context);
        ostr->write(v.comment);
        ostr->write(v.address);
        ostr->write(v.tcponly);
        ostr->write(v.idlesecs);
        ostr->write(v.udpPing);
        ostr->write(v.tcpPing);
    }
};

template<typename S>
struct StreamReader< ::MumbleServer::User, S>
{
    static void read(S* istr, ::MumbleServer::User& v)
    {
        istr->read(v.session);
        istr->read(v.userid);
        istr->read(v.mute);
        istr->read(v.deaf);
        istr->read(v.suppress);
        istr->read(v.prioritySpeaker);
        istr->read(v.selfMute);
        istr->read(v.selfDeaf);
        istr->read(v.recording);
        istr->read(v.channel);
        istr->read(v.name);
        istr->read(v.onlinesecs);
        istr->read(v.bytespersec);
        istr->read(v.version);
        istr->read(v.version2);
        istr->read(v.release);
        istr->read(v.os);
        istr->read(v.osversion);
        istr->read(v.identity);
        istr->read(v.context);
        istr->read(v.comment);
        istr->read(v.address);
        istr->read(v.tcponly);
        istr->read(v.idlesecs);
        istr->read(v.udpPing);
        istr->read(v.tcpPing);
    }
};

template<>
struct StreamableTraits< ::MumbleServer::TextMessage>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 4;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::MumbleServer::TextMessage, S>
{
    static void write(S* ostr, const ::MumbleServer::TextMessage& v)
    {
        ostr->write(v.sessions);
        ostr->write(v.channels);
        ostr->write(v.trees);
        ostr->write(v.text);
    }
};

template<typename S>
struct StreamReader< ::MumbleServer::TextMessage, S>
{
    static void read(S* istr, ::MumbleServer::TextMessage& v)
    {
        istr->read(v.sessions);
        istr->read(v.channels);
        istr->read(v.trees);
        istr->read(v.text);
    }
};

template<>
struct StreamableTraits< ::MumbleServer::Channel>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 16;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::MumbleServer::Channel, S>
{
    static void write(S* ostr, const ::MumbleServer::Channel& v)
    {
        ostr->write(v.id);
        ostr->write(v.name);
        ostr->write(v.parent);
        ostr->write(v.links);
        ostr->write(v.description);
        ostr->write(v.temporary);
        ostr->write(v.position);
    }
};

template<typename S>
struct StreamReader< ::MumbleServer::Channel, S>
{
    static void read(S* istr, ::MumbleServer::Channel& v)
    {
        istr->read(v.id);
        istr->read(v.name);
        istr->read(v.parent);
        istr->read(v.links);
        istr->read(v.description);
        istr->read(v.temporary);
        istr->read(v.position);
    }
};

template<>
struct StreamableTraits< ::MumbleServer::Group>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 7;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::MumbleServer::Group, S>
{
    static void write(S* ostr, const ::MumbleServer::Group& v)
    {
        ostr->write(v.name);
        ostr->write(v.inherited);
        ostr->write(v.inherit);
        ostr->write(v.inheritable);
        ostr->write(v.add);
        ostr->write(v.remove);
        ostr->write(v.members);
    }
};

template<typename S>
struct StreamReader< ::MumbleServer::Group, S>
{
    static void read(S* istr, ::MumbleServer::Group& v)
    {
        istr->read(v.name);
        istr->read(v.inherited);
        istr->read(v.inherit);
        istr->read(v.inheritable);
        istr->read(v.add);
        istr->read(v.remove);
        istr->read(v.members);
    }
};

template<>
struct StreamableTraits< ::MumbleServer::ACL>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 16;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::MumbleServer::ACL, S>
{
    static void write(S* ostr, const ::MumbleServer::ACL& v)
    {
        ostr->write(v.applyHere);
        ostr->write(v.applySubs);
        ostr->write(v.inherited);
        ostr->write(v.userid);
        ostr->write(v.group);
        ostr->write(v.allow);
        ostr->write(v.deny);
    }
};

template<typename S>
struct StreamReader< ::MumbleServer::ACL, S>
{
    static void read(S* istr, ::MumbleServer::ACL& v)
    {
        istr->read(v.applyHere);
        istr->read(v.applySubs);
        istr->read(v.inherited);
        istr->read(v.userid);
        istr->read(v.group);
        istr->read(v.allow);
        istr->read(v.deny);
    }
};

template<>
struct StreamableTraits< ::MumbleServer::Ban>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 16;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::MumbleServer::Ban, S>
{
    static void write(S* ostr, const ::MumbleServer::Ban& v)
    {
        ostr->write(v.address);
        ostr->write(v.bits);
        ostr->write(v.name);
        ostr->write(v.hash);
        ostr->write(v.reason);
        ostr->write(v.start);
        ostr->write(v.duration);
    }
};

template<typename S>
struct StreamReader< ::MumbleServer::Ban, S>
{
    static void read(S* istr, ::MumbleServer::Ban& v)
    {
        istr->read(v.address);
        istr->read(v.bits);
        istr->read(v.name);
        istr->read(v.hash);
        istr->read(v.reason);
        istr->read(v.start);
        istr->read(v.duration);
    }
};

template<>
struct StreamableTraits< ::MumbleServer::LogEntry>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 5;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::MumbleServer::LogEntry, S>
{
    static void write(S* ostr, const ::MumbleServer::LogEntry& v)
    {
        ostr->write(v.timestamp);
        ostr->write(v.txt);
    }
};

template<typename S>
struct StreamReader< ::MumbleServer::LogEntry, S>
{
    static void read(S* istr, ::MumbleServer::LogEntry& v)
    {
        istr->read(v.timestamp);
        istr->read(v.txt);
    }
};

template<>
struct StreamableTraits< ::MumbleServer::ChannelInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryEnum;
    static const int minValue = 0;
    static const int maxValue = 1;
    static const int minWireSize = 1;
    static const bool fixedLength = false;
};

template<>
struct StreamableTraits< ::MumbleServer::UserInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryEnum;
    static const int minValue = 0;
    static const int maxValue = 6;
    static const int minWireSize = 1;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::MumbleServer::Tree, S>
{
    static void write(S* ostr, const ::MumbleServer::Tree& v)
    {
        ostr->write(v.c);
        ostr->write(v.children);
        ostr->write(v.users);
    }
};

template<typename S>
struct StreamReader< ::MumbleServer::Tree, S>
{
    static void read(S* istr, ::MumbleServer::Tree& v)
    {
        istr->read(v.c);
        istr->read(v.children);
        istr->read(v.users);
    }
};

template<>
struct StreamableTraits< ::MumbleServer::MurmurException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::MumbleServer::InvalidSessionException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::MumbleServer::InvalidChannelException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::MumbleServer::InvalidServerException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::MumbleServer::ServerBootedException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::MumbleServer::ServerFailureException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::MumbleServer::InvalidUserException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::MumbleServer::InvalidTextureException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::MumbleServer::InvalidCallbackException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::MumbleServer::InvalidSecretException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::MumbleServer::NestingLimitException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::MumbleServer::WriteOnlyException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::MumbleServer::InvalidInputDataException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

}
/// \endcond

namespace MumbleServer
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::MumbleServer::ServerCallback::begin_userConnected.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerCallback_userConnected.
 */
template<class T>
class CallbackNC_ServerCallback_userConnected : public Callback_ServerCallback_userConnected_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ServerCallback_userConnected(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userConnected.
 */
template<class T> Callback_ServerCallback_userConnectedPtr
newCallback_ServerCallback_userConnected(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_userConnected<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userConnected.
 */
template<class T> Callback_ServerCallback_userConnectedPtr
newCallback_ServerCallback_userConnected(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_userConnected<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userConnected.
 */
template<class T> Callback_ServerCallback_userConnectedPtr
newCallback_ServerCallback_userConnected(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_userConnected<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userConnected.
 */
template<class T> Callback_ServerCallback_userConnectedPtr
newCallback_ServerCallback_userConnected(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_userConnected<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::MumbleServer::ServerCallback::begin_userConnected.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerCallback_userConnected.
 */
template<class T, typename CT>
class Callback_ServerCallback_userConnected : public Callback_ServerCallback_userConnected_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ServerCallback_userConnected(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userConnected.
 */
template<class T, typename CT> Callback_ServerCallback_userConnectedPtr
newCallback_ServerCallback_userConnected(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_userConnected<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userConnected.
 */
template<class T, typename CT> Callback_ServerCallback_userConnectedPtr
newCallback_ServerCallback_userConnected(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_userConnected<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userConnected.
 */
template<class T, typename CT> Callback_ServerCallback_userConnectedPtr
newCallback_ServerCallback_userConnected(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_userConnected<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userConnected.
 */
template<class T, typename CT> Callback_ServerCallback_userConnectedPtr
newCallback_ServerCallback_userConnected(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_userConnected<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::MumbleServer::ServerCallback::begin_userDisconnected.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerCallback_userDisconnected.
 */
template<class T>
class CallbackNC_ServerCallback_userDisconnected : public Callback_ServerCallback_userDisconnected_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ServerCallback_userDisconnected(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userDisconnected.
 */
template<class T> Callback_ServerCallback_userDisconnectedPtr
newCallback_ServerCallback_userDisconnected(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_userDisconnected<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userDisconnected.
 */
template<class T> Callback_ServerCallback_userDisconnectedPtr
newCallback_ServerCallback_userDisconnected(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_userDisconnected<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userDisconnected.
 */
template<class T> Callback_ServerCallback_userDisconnectedPtr
newCallback_ServerCallback_userDisconnected(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_userDisconnected<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userDisconnected.
 */
template<class T> Callback_ServerCallback_userDisconnectedPtr
newCallback_ServerCallback_userDisconnected(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_userDisconnected<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::MumbleServer::ServerCallback::begin_userDisconnected.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerCallback_userDisconnected.
 */
template<class T, typename CT>
class Callback_ServerCallback_userDisconnected : public Callback_ServerCallback_userDisconnected_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ServerCallback_userDisconnected(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userDisconnected.
 */
template<class T, typename CT> Callback_ServerCallback_userDisconnectedPtr
newCallback_ServerCallback_userDisconnected(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_userDisconnected<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userDisconnected.
 */
template<class T, typename CT> Callback_ServerCallback_userDisconnectedPtr
newCallback_ServerCallback_userDisconnected(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_userDisconnected<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userDisconnected.
 */
template<class T, typename CT> Callback_ServerCallback_userDisconnectedPtr
newCallback_ServerCallback_userDisconnected(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_userDisconnected<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userDisconnected.
 */
template<class T, typename CT> Callback_ServerCallback_userDisconnectedPtr
newCallback_ServerCallback_userDisconnected(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_userDisconnected<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::MumbleServer::ServerCallback::begin_userStateChanged.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerCallback_userStateChanged.
 */
template<class T>
class CallbackNC_ServerCallback_userStateChanged : public Callback_ServerCallback_userStateChanged_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ServerCallback_userStateChanged(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userStateChanged.
 */
template<class T> Callback_ServerCallback_userStateChangedPtr
newCallback_ServerCallback_userStateChanged(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_userStateChanged<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userStateChanged.
 */
template<class T> Callback_ServerCallback_userStateChangedPtr
newCallback_ServerCallback_userStateChanged(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_userStateChanged<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userStateChanged.
 */
template<class T> Callback_ServerCallback_userStateChangedPtr
newCallback_ServerCallback_userStateChanged(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_userStateChanged<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userStateChanged.
 */
template<class T> Callback_ServerCallback_userStateChangedPtr
newCallback_ServerCallback_userStateChanged(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_userStateChanged<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::MumbleServer::ServerCallback::begin_userStateChanged.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerCallback_userStateChanged.
 */
template<class T, typename CT>
class Callback_ServerCallback_userStateChanged : public Callback_ServerCallback_userStateChanged_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ServerCallback_userStateChanged(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userStateChanged.
 */
template<class T, typename CT> Callback_ServerCallback_userStateChangedPtr
newCallback_ServerCallback_userStateChanged(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_userStateChanged<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userStateChanged.
 */
template<class T, typename CT> Callback_ServerCallback_userStateChangedPtr
newCallback_ServerCallback_userStateChanged(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_userStateChanged<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userStateChanged.
 */
template<class T, typename CT> Callback_ServerCallback_userStateChangedPtr
newCallback_ServerCallback_userStateChanged(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_userStateChanged<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userStateChanged.
 */
template<class T, typename CT> Callback_ServerCallback_userStateChangedPtr
newCallback_ServerCallback_userStateChanged(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_userStateChanged<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::MumbleServer::ServerCallback::begin_userTextMessage.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerCallback_userTextMessage.
 */
template<class T>
class CallbackNC_ServerCallback_userTextMessage : public Callback_ServerCallback_userTextMessage_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ServerCallback_userTextMessage(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userTextMessage.
 */
template<class T> Callback_ServerCallback_userTextMessagePtr
newCallback_ServerCallback_userTextMessage(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_userTextMessage<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userTextMessage.
 */
template<class T> Callback_ServerCallback_userTextMessagePtr
newCallback_ServerCallback_userTextMessage(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_userTextMessage<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userTextMessage.
 */
template<class T> Callback_ServerCallback_userTextMessagePtr
newCallback_ServerCallback_userTextMessage(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_userTextMessage<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userTextMessage.
 */
template<class T> Callback_ServerCallback_userTextMessagePtr
newCallback_ServerCallback_userTextMessage(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_userTextMessage<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::MumbleServer::ServerCallback::begin_userTextMessage.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerCallback_userTextMessage.
 */
template<class T, typename CT>
class Callback_ServerCallback_userTextMessage : public Callback_ServerCallback_userTextMessage_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ServerCallback_userTextMessage(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userTextMessage.
 */
template<class T, typename CT> Callback_ServerCallback_userTextMessagePtr
newCallback_ServerCallback_userTextMessage(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_userTextMessage<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userTextMessage.
 */
template<class T, typename CT> Callback_ServerCallback_userTextMessagePtr
newCallback_ServerCallback_userTextMessage(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_userTextMessage<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userTextMessage.
 */
template<class T, typename CT> Callback_ServerCallback_userTextMessagePtr
newCallback_ServerCallback_userTextMessage(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_userTextMessage<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_userTextMessage.
 */
template<class T, typename CT> Callback_ServerCallback_userTextMessagePtr
newCallback_ServerCallback_userTextMessage(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_userTextMessage<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::MumbleServer::ServerCallback::begin_channelCreated.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerCallback_channelCreated.
 */
template<class T>
class CallbackNC_ServerCallback_channelCreated : public Callback_ServerCallback_channelCreated_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ServerCallback_channelCreated(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelCreated.
 */
template<class T> Callback_ServerCallback_channelCreatedPtr
newCallback_ServerCallback_channelCreated(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_channelCreated<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelCreated.
 */
template<class T> Callback_ServerCallback_channelCreatedPtr
newCallback_ServerCallback_channelCreated(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_channelCreated<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelCreated.
 */
template<class T> Callback_ServerCallback_channelCreatedPtr
newCallback_ServerCallback_channelCreated(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_channelCreated<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelCreated.
 */
template<class T> Callback_ServerCallback_channelCreatedPtr
newCallback_ServerCallback_channelCreated(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_channelCreated<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::MumbleServer::ServerCallback::begin_channelCreated.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerCallback_channelCreated.
 */
template<class T, typename CT>
class Callback_ServerCallback_channelCreated : public Callback_ServerCallback_channelCreated_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ServerCallback_channelCreated(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelCreated.
 */
template<class T, typename CT> Callback_ServerCallback_channelCreatedPtr
newCallback_ServerCallback_channelCreated(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_channelCreated<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelCreated.
 */
template<class T, typename CT> Callback_ServerCallback_channelCreatedPtr
newCallback_ServerCallback_channelCreated(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_channelCreated<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelCreated.
 */
template<class T, typename CT> Callback_ServerCallback_channelCreatedPtr
newCallback_ServerCallback_channelCreated(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_channelCreated<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelCreated.
 */
template<class T, typename CT> Callback_ServerCallback_channelCreatedPtr
newCallback_ServerCallback_channelCreated(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_channelCreated<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::MumbleServer::ServerCallback::begin_channelRemoved.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerCallback_channelRemoved.
 */
template<class T>
class CallbackNC_ServerCallback_channelRemoved : public Callback_ServerCallback_channelRemoved_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ServerCallback_channelRemoved(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelRemoved.
 */
template<class T> Callback_ServerCallback_channelRemovedPtr
newCallback_ServerCallback_channelRemoved(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_channelRemoved<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelRemoved.
 */
template<class T> Callback_ServerCallback_channelRemovedPtr
newCallback_ServerCallback_channelRemoved(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_channelRemoved<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelRemoved.
 */
template<class T> Callback_ServerCallback_channelRemovedPtr
newCallback_ServerCallback_channelRemoved(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_channelRemoved<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelRemoved.
 */
template<class T> Callback_ServerCallback_channelRemovedPtr
newCallback_ServerCallback_channelRemoved(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_channelRemoved<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::MumbleServer::ServerCallback::begin_channelRemoved.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerCallback_channelRemoved.
 */
template<class T, typename CT>
class Callback_ServerCallback_channelRemoved : public Callback_ServerCallback_channelRemoved_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ServerCallback_channelRemoved(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelRemoved.
 */
template<class T, typename CT> Callback_ServerCallback_channelRemovedPtr
newCallback_ServerCallback_channelRemoved(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_channelRemoved<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelRemoved.
 */
template<class T, typename CT> Callback_ServerCallback_channelRemovedPtr
newCallback_ServerCallback_channelRemoved(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_channelRemoved<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelRemoved.
 */
template<class T, typename CT> Callback_ServerCallback_channelRemovedPtr
newCallback_ServerCallback_channelRemoved(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_channelRemoved<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelRemoved.
 */
template<class T, typename CT> Callback_ServerCallback_channelRemovedPtr
newCallback_ServerCallback_channelRemoved(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_channelRemoved<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::MumbleServer::ServerCallback::begin_channelStateChanged.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerCallback_channelStateChanged.
 */
template<class T>
class CallbackNC_ServerCallback_channelStateChanged : public Callback_ServerCallback_channelStateChanged_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ServerCallback_channelStateChanged(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelStateChanged.
 */
template<class T> Callback_ServerCallback_channelStateChangedPtr
newCallback_ServerCallback_channelStateChanged(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_channelStateChanged<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelStateChanged.
 */
template<class T> Callback_ServerCallback_channelStateChangedPtr
newCallback_ServerCallback_channelStateChanged(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_channelStateChanged<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelStateChanged.
 */
template<class T> Callback_ServerCallback_channelStateChangedPtr
newCallback_ServerCallback_channelStateChanged(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_channelStateChanged<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelStateChanged.
 */
template<class T> Callback_ServerCallback_channelStateChangedPtr
newCallback_ServerCallback_channelStateChanged(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerCallback_channelStateChanged<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::MumbleServer::ServerCallback::begin_channelStateChanged.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerCallback_channelStateChanged.
 */
template<class T, typename CT>
class Callback_ServerCallback_channelStateChanged : public Callback_ServerCallback_channelStateChanged_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ServerCallback_channelStateChanged(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelStateChanged.
 */
template<class T, typename CT> Callback_ServerCallback_channelStateChangedPtr
newCallback_ServerCallback_channelStateChanged(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_channelStateChanged<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelStateChanged.
 */
template<class T, typename CT> Callback_ServerCallback_channelStateChangedPtr
newCallback_ServerCallback_channelStateChanged(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_channelStateChanged<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelStateChanged.
 */
template<class T, typename CT> Callback_ServerCallback_channelStateChangedPtr
newCallback_ServerCallback_channelStateChanged(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_channelStateChanged<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerCallback::begin_channelStateChanged.
 */
template<class T, typename CT> Callback_ServerCallback_channelStateChangedPtr
newCallback_ServerCallback_channelStateChanged(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerCallback_channelStateChanged<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::MumbleServer::ServerContextCallback::begin_contextAction.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerContextCallback_contextAction.
 */
template<class T>
class CallbackNC_ServerContextCallback_contextAction : public Callback_ServerContextCallback_contextAction_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ServerContextCallback_contextAction(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerContextCallback::begin_contextAction.
 */
template<class T> Callback_ServerContextCallback_contextActionPtr
newCallback_ServerContextCallback_contextAction(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerContextCallback_contextAction<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerContextCallback::begin_contextAction.
 */
template<class T> Callback_ServerContextCallback_contextActionPtr
newCallback_ServerContextCallback_contextAction(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerContextCallback_contextAction<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerContextCallback::begin_contextAction.
 */
template<class T> Callback_ServerContextCallback_contextActionPtr
newCallback_ServerContextCallback_contextAction(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerContextCallback_contextAction<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerContextCallback::begin_contextAction.
 */
template<class T> Callback_ServerContextCallback_contextActionPtr
newCallback_ServerContextCallback_contextAction(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerContextCallback_contextAction<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::MumbleServer::ServerContextCallback::begin_contextAction.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerContextCallback_contextAction.
 */
template<class T, typename CT>
class Callback_ServerContextCallback_contextAction : public Callback_ServerContextCallback_contextAction_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ServerContextCallback_contextAction(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerContextCallback::begin_contextAction.
 */
template<class T, typename CT> Callback_ServerContextCallback_contextActionPtr
newCallback_ServerContextCallback_contextAction(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerContextCallback_contextAction<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerContextCallback::begin_contextAction.
 */
template<class T, typename CT> Callback_ServerContextCallback_contextActionPtr
newCallback_ServerContextCallback_contextAction(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerContextCallback_contextAction<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerContextCallback::begin_contextAction.
 */
template<class T, typename CT> Callback_ServerContextCallback_contextActionPtr
newCallback_ServerContextCallback_contextAction(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerContextCallback_contextAction<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerContextCallback::begin_contextAction.
 */
template<class T, typename CT> Callback_ServerContextCallback_contextActionPtr
newCallback_ServerContextCallback_contextAction(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerContextCallback_contextAction<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::MumbleServer::ServerAuthenticator::begin_authenticate.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerAuthenticator_authenticate.
 */
template<class T>
class CallbackNC_ServerAuthenticator_authenticate : public Callback_ServerAuthenticator_authenticate_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(::Ice::Int, const ::std::string&, const GroupNameList&);

    CallbackNC_ServerAuthenticator_authenticate(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServerAuthenticatorPrx proxy = ServerAuthenticatorPrx::uncheckedCast(result->getProxy());
        ::std::string iceP_newname;
        GroupNameList iceP_groups;
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_authenticate(iceP_newname, iceP_groups, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret, iceP_newname, iceP_groups);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerAuthenticator::begin_authenticate.
 */
template<class T> Callback_ServerAuthenticator_authenticatePtr
newCallback_ServerAuthenticator_authenticate(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int, const ::std::string&, const GroupNameList&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerAuthenticator_authenticate<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerAuthenticator::begin_authenticate.
 */
template<class T> Callback_ServerAuthenticator_authenticatePtr
newCallback_ServerAuthenticator_authenticate(T* instance, void (T::*cb)(::Ice::Int, const ::std::string&, const GroupNameList&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServerAuthenticator_authenticate<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::MumbleServer::ServerAuthenticator::begin_authenticate.
 * Create a wrapper instance by calling ::MumbleServer::newCallback_ServerAuthenticator_authenticate.
 */
template<class T, typename CT>
class Callback_ServerAuthenticator_authenticate : public Callback_ServerAuthenticator_authenticate_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(::Ice::Int, const ::std::string&, const GroupNameList&, const CT&);

    Callback_ServerAuthenticator_authenticate(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServerAuthenticatorPrx proxy = ServerAuthenticatorPrx::uncheckedCast(result->getProxy());
        ::std::string iceP_newname;
        GroupNameList iceP_groups;
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_authenticate(iceP_newname, iceP_groups, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, iceP_newname, iceP_groups, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerAuthenticator::begin_authenticate.
 */
template<class T, typename CT> Callback_ServerAuthenticator_authenticatePtr
newCallback_ServerAuthenticator_authenticate(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int, const ::std::string&, const GroupNameList&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServerAuthenticator_authenticate<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::MumbleServer::ServerAuthenticator::begin_authenticate.
 */
template<class T, typename CT> Callback_ServerAuthenticator_authenticatePtr
newCallback_ServerAuthenticator_authenticate(T* instance, void (T::*cb)(::Ice::Int, const ::std::string&, const 