/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "meta-dbus-login1.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.login1.Session
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MetaDbusLogin1Session
 * @title: MetaDbusLogin1Session
 * @short_description: Generated C code for the org.freedesktop.login1.Session D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-login1-Session.top_of_page">org.freedesktop.login1.Session</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.login1.Session ---- */

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_activate =
{
  {
    -1,
    (gchar *) "Activate",
    NULL,
    NULL,
    NULL
  },
  "handle-activate",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_take_control_IN_ARG_force =
{
  {
    -1,
    (gchar *) "force",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_session_method_info_take_control_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_session_method_info_take_control_IN_ARG_force.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_take_control =
{
  {
    -1,
    (gchar *) "TakeControl",
    (GDBusArgInfo **) &_meta_dbus_login1_session_method_info_take_control_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-take-control",
  FALSE
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_release_control =
{
  {
    -1,
    (gchar *) "ReleaseControl",
    NULL,
    NULL,
    NULL
  },
  "handle-release-control",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_take_device_IN_ARG_major =
{
  {
    -1,
    (gchar *) "major",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_take_device_IN_ARG_minor =
{
  {
    -1,
    (gchar *) "minor",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_session_method_info_take_device_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_session_method_info_take_device_IN_ARG_major.parent_struct,
  &_meta_dbus_login1_session_method_info_take_device_IN_ARG_minor.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_take_device_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_take_device_OUT_ARG_paused =
{
  {
    -1,
    (gchar *) "paused",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_session_method_info_take_device_OUT_ARG_pointers[] =
{
  &_meta_dbus_login1_session_method_info_take_device_OUT_ARG_fd.parent_struct,
  &_meta_dbus_login1_session_method_info_take_device_OUT_ARG_paused.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_take_device =
{
  {
    -1,
    (gchar *) "TakeDevice",
    (GDBusArgInfo **) &_meta_dbus_login1_session_method_info_take_device_IN_ARG_pointers,
    (GDBusArgInfo **) &_meta_dbus_login1_session_method_info_take_device_OUT_ARG_pointers,
    NULL
  },
  "handle-take-device",
  TRUE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_release_device_IN_ARG_major =
{
  {
    -1,
    (gchar *) "major",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_release_device_IN_ARG_minor =
{
  {
    -1,
    (gchar *) "minor",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_session_method_info_release_device_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_session_method_info_release_device_IN_ARG_major.parent_struct,
  &_meta_dbus_login1_session_method_info_release_device_IN_ARG_minor.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_release_device =
{
  {
    -1,
    (gchar *) "ReleaseDevice",
    (GDBusArgInfo **) &_meta_dbus_login1_session_method_info_release_device_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-release-device",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_pause_device_complete_IN_ARG_major =
{
  {
    -1,
    (gchar *) "major",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_method_info_pause_device_complete_IN_ARG_minor =
{
  {
    -1,
    (gchar *) "minor",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_session_method_info_pause_device_complete_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_session_method_info_pause_device_complete_IN_ARG_major.parent_struct,
  &_meta_dbus_login1_session_method_info_pause_device_complete_IN_ARG_minor.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_session_method_info_pause_device_complete =
{
  {
    -1,
    (gchar *) "PauseDeviceComplete",
    (GDBusArgInfo **) &_meta_dbus_login1_session_method_info_pause_device_complete_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-pause-device-complete",
  FALSE
};

static const GDBusMethodInfo * const _meta_dbus_login1_session_method_info_pointers[] =
{
  &_meta_dbus_login1_session_method_info_activate.parent_struct,
  &_meta_dbus_login1_session_method_info_take_control.parent_struct,
  &_meta_dbus_login1_session_method_info_release_control.parent_struct,
  &_meta_dbus_login1_session_method_info_take_device.parent_struct,
  &_meta_dbus_login1_session_method_info_release_device.parent_struct,
  &_meta_dbus_login1_session_method_info_pause_device_complete.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_signal_info_pause_device_ARG_major =
{
  {
    -1,
    (gchar *) "major",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_signal_info_pause_device_ARG_minor =
{
  {
    -1,
    (gchar *) "minor",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_signal_info_pause_device_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_session_signal_info_pause_device_ARG_pointers[] =
{
  &_meta_dbus_login1_session_signal_info_pause_device_ARG_major.parent_struct,
  &_meta_dbus_login1_session_signal_info_pause_device_ARG_minor.parent_struct,
  &_meta_dbus_login1_session_signal_info_pause_device_ARG_type.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _meta_dbus_login1_session_signal_info_pause_device =
{
  {
    -1,
    (gchar *) "PauseDevice",
    (GDBusArgInfo **) &_meta_dbus_login1_session_signal_info_pause_device_ARG_pointers,
    NULL
  },
  "pause-device"
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_signal_info_resume_device_ARG_major =
{
  {
    -1,
    (gchar *) "major",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_signal_info_resume_device_ARG_minor =
{
  {
    -1,
    (gchar *) "minor",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_login1_session_signal_info_resume_device_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_session_signal_info_resume_device_ARG_pointers[] =
{
  &_meta_dbus_login1_session_signal_info_resume_device_ARG_major.parent_struct,
  &_meta_dbus_login1_session_signal_info_resume_device_ARG_minor.parent_struct,
  &_meta_dbus_login1_session_signal_info_resume_device_ARG_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _meta_dbus_login1_session_signal_info_resume_device =
{
  {
    -1,
    (gchar *) "ResumeDevice",
    (GDBusArgInfo **) &_meta_dbus_login1_session_signal_info_resume_device_ARG_pointers,
    NULL
  },
  "resume-device"
};

static const GDBusSignalInfo * const _meta_dbus_login1_session_signal_info_pointers[] =
{
  &_meta_dbus_login1_session_signal_info_pause_device.parent_struct,
  &_meta_dbus_login1_session_signal_info_resume_device.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_login1_session_property_info_active =
{
  {
    -1,
    (gchar *) "Active",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "active",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _meta_dbus_login1_session_property_info_pointers[] =
{
  &_meta_dbus_login1_session_property_info_active.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _meta_dbus_login1_session_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.login1.Session",
    (GDBusMethodInfo **) &_meta_dbus_login1_session_method_info_pointers,
    (GDBusSignalInfo **) &_meta_dbus_login1_session_signal_info_pointers,
    (GDBusPropertyInfo **) &_meta_dbus_login1_session_property_info_pointers,
    NULL
  },
  "session",
};


/**
 * meta_dbus_login1_session_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-login1-Session.top_of_page">org.freedesktop.login1.Session</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
meta_dbus_login1_session_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_meta_dbus_login1_session_interface_info.parent_struct;
}

/**
 * meta_dbus_login1_session_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MetaDbusLogin1Session interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
meta_dbus_login1_session_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "active");
  return property_id_begin - 1;
}



/**
 * MetaDbusLogin1Session:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Session.top_of_page">org.freedesktop.login1.Session</link>.
 */

/**
 * MetaDbusLogin1SessionIface:
 * @parent_iface: The parent interface.
 * @handle_activate: Handler for the #MetaDbusLogin1Session::handle-activate signal.
 * @handle_pause_device_complete: Handler for the #MetaDbusLogin1Session::handle-pause-device-complete signal.
 * @handle_release_control: Handler for the #MetaDbusLogin1Session::handle-release-control signal.
 * @handle_release_device: Handler for the #MetaDbusLogin1Session::handle-release-device signal.
 * @handle_take_control: Handler for the #MetaDbusLogin1Session::handle-take-control signal.
 * @handle_take_device: Handler for the #MetaDbusLogin1Session::handle-take-device signal.
 * @get_active: Getter for the #MetaDbusLogin1Session:active property.
 * @pause_device: Handler for the #MetaDbusLogin1Session::pause-device signal.
 * @resume_device: Handler for the #MetaDbusLogin1Session::resume-device signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Session.top_of_page">org.freedesktop.login1.Session</link>.
 */

typedef MetaDbusLogin1SessionIface MetaDbusLogin1SessionInterface;
G_DEFINE_INTERFACE (MetaDbusLogin1Session, meta_dbus_login1_session, G_TYPE_OBJECT)

static void
meta_dbus_login1_session_default_init (MetaDbusLogin1SessionIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MetaDbusLogin1Session::handle-activate:
   * @object: A #MetaDbusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.Activate">Activate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_activate() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-activate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDbusLogin1SessionIface, handle_activate),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDbusLogin1Session::handle-take-control:
   * @object: A #MetaDbusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_force: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeControl">TakeControl()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_take_control() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-take-control",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDbusLogin1SessionIface, handle_take_control),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * MetaDbusLogin1Session::handle-release-control:
   * @object: A #MetaDbusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseControl">ReleaseControl()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_release_control() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release-control",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDbusLogin1SessionIface, handle_release_control),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDbusLogin1Session::handle-take-device:
   * @object: A #MetaDbusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_major: Argument passed by remote caller.
   * @arg_minor: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeDevice">TakeDevice()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_take_device() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-take-device",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDbusLogin1SessionIface, handle_take_device),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_UINT, G_TYPE_UINT);

  /**
   * MetaDbusLogin1Session::handle-release-device:
   * @object: A #MetaDbusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_major: Argument passed by remote caller.
   * @arg_minor: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseDevice">ReleaseDevice()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_release_device() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release-device",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDbusLogin1SessionIface, handle_release_device),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_UINT);

  /**
   * MetaDbusLogin1Session::handle-pause-device-complete:
   * @object: A #MetaDbusLogin1Session.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_major: Argument passed by remote caller.
   * @arg_minor: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.PauseDeviceComplete">PauseDeviceComplete()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_session_complete_pause_device_complete() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pause-device-complete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDbusLogin1SessionIface, handle_pause_device_complete),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_UINT);

  /* GObject signals for received D-Bus signals: */
  /**
   * MetaDbusLogin1Session::pause-device:
   * @object: A #MetaDbusLogin1Session.
   * @arg_major: Argument.
   * @arg_minor: Argument.
   * @arg_type: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-login1-Session.PauseDevice">"PauseDevice"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("pause-device",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDbusLogin1SessionIface, pause_device),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING);

  /**
   * MetaDbusLogin1Session::resume-device:
   * @object: A #MetaDbusLogin1Session.
   * @arg_major: Argument.
   * @arg_minor: Argument.
   * @arg_fd: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-login1-Session.ResumeDevice">"ResumeDevice"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("resume-device",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDbusLogin1SessionIface, resume_device),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * MetaDbusLogin1Session:active:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.Active">"Active"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("active", "Active", "Active", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * meta_dbus_login1_session_get_active: (skip)
 * @object: A #MetaDbusLogin1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Active">"Active"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
meta_dbus_login1_session_get_active (MetaDbusLogin1Session *object)
{
  g_return_val_if_fail (META_DBUS_LOGIN1_IS_SESSION (object), FALSE);

  return META_DBUS_LOGIN1_SESSION_GET_IFACE (object)->get_active (object);
}

/**
 * meta_dbus_login1_session_set_active: (skip)
 * @object: A #MetaDbusLogin1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.Active">"Active"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_login1_session_set_active (MetaDbusLogin1Session *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "active", value, NULL);
}

/**
 * meta_dbus_login1_session_emit_pause_device:
 * @object: A #MetaDbusLogin1Session.
 * @arg_major: Argument to pass with the signal.
 * @arg_minor: Argument to pass with the signal.
 * @arg_type: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-login1-Session.PauseDevice">"PauseDevice"</link> D-Bus signal.
 */
void
meta_dbus_login1_session_emit_pause_device (
    MetaDbusLogin1Session *object,
    guint arg_major,
    guint arg_minor,
    const gchar *arg_type)
{
  g_signal_emit_by_name (object, "pause-device", arg_major, arg_minor, arg_type);
}

/**
 * meta_dbus_login1_session_emit_resume_device:
 * @object: A #MetaDbusLogin1Session.
 * @arg_major: Argument to pass with the signal.
 * @arg_minor: Argument to pass with the signal.
 * @arg_fd: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-login1-Session.ResumeDevice">"ResumeDevice"</link> D-Bus signal.
 */
void
meta_dbus_login1_session_emit_resume_device (
    MetaDbusLogin1Session *object,
    guint arg_major,
    guint arg_minor,
    GVariant *arg_fd)
{
  g_signal_emit_by_name (object, "resume-device", arg_major, arg_minor, arg_fd);
}

/**
 * meta_dbus_login1_session_call_activate:
 * @proxy: A #MetaDbusLogin1SessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.Activate">Activate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_activate_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_activate_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_activate (
    MetaDbusLogin1Session *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Activate",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_activate_finish:
 * @proxy: A #MetaDbusLogin1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_activate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_activate().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_activate_finish (
    MetaDbusLogin1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_activate_sync:
 * @proxy: A #MetaDbusLogin1SessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.Activate">Activate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_activate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_activate_sync (
    MetaDbusLogin1Session *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Activate",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_take_control:
 * @proxy: A #MetaDbusLogin1SessionProxy.
 * @arg_force: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeControl">TakeControl()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_take_control_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_take_control_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_take_control (
    MetaDbusLogin1Session *proxy,
    gboolean arg_force,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "TakeControl",
    g_variant_new ("(b)",
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_take_control_finish:
 * @proxy: A #MetaDbusLogin1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_take_control().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_take_control().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_take_control_finish (
    MetaDbusLogin1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_take_control_sync:
 * @proxy: A #MetaDbusLogin1SessionProxy.
 * @arg_force: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeControl">TakeControl()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_take_control() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_take_control_sync (
    MetaDbusLogin1Session *proxy,
    gboolean arg_force,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "TakeControl",
    g_variant_new ("(b)",
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_release_control:
 * @proxy: A #MetaDbusLogin1SessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseControl">ReleaseControl()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_release_control_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_release_control_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_release_control (
    MetaDbusLogin1Session *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReleaseControl",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_release_control_finish:
 * @proxy: A #MetaDbusLogin1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_release_control().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_release_control().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_release_control_finish (
    MetaDbusLogin1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_release_control_sync:
 * @proxy: A #MetaDbusLogin1SessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseControl">ReleaseControl()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_release_control() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_release_control_sync (
    MetaDbusLogin1Session *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReleaseControl",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_take_device:
 * @proxy: A #MetaDbusLogin1SessionProxy.
 * @arg_major: Argument to pass with the method invocation.
 * @arg_minor: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeDevice">TakeDevice()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_take_device_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_take_device_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_take_device (
    MetaDbusLogin1Session *proxy,
    guint arg_major,
    guint arg_minor,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "TakeDevice",
    g_variant_new ("(uu)",
                   arg_major,
                   arg_minor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_take_device_finish:
 * @proxy: A #MetaDbusLogin1SessionProxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_paused: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_take_device().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_take_device().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_take_device_finish (
    MetaDbusLogin1Session *proxy,
    GVariant **out_fd,
    gboolean *out_paused,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@hb)",
                 out_fd,
                 out_paused);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_take_device_sync:
 * @proxy: A #MetaDbusLogin1SessionProxy.
 * @arg_major: Argument to pass with the method invocation.
 * @arg_minor: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_paused: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeDevice">TakeDevice()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_take_device() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_take_device_sync (
    MetaDbusLogin1Session *proxy,
    guint arg_major,
    guint arg_minor,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    gboolean *out_paused,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "TakeDevice",
    g_variant_new ("(uu)",
                   arg_major,
                   arg_minor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@hb)",
                 out_fd,
                 out_paused);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_release_device:
 * @proxy: A #MetaDbusLogin1SessionProxy.
 * @arg_major: Argument to pass with the method invocation.
 * @arg_minor: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseDevice">ReleaseDevice()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_release_device_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_release_device_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_release_device (
    MetaDbusLogin1Session *proxy,
    guint arg_major,
    guint arg_minor,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReleaseDevice",
    g_variant_new ("(uu)",
                   arg_major,
                   arg_minor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_release_device_finish:
 * @proxy: A #MetaDbusLogin1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_release_device().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_release_device().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_release_device_finish (
    MetaDbusLogin1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_release_device_sync:
 * @proxy: A #MetaDbusLogin1SessionProxy.
 * @arg_major: Argument to pass with the method invocation.
 * @arg_minor: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseDevice">ReleaseDevice()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_release_device() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_release_device_sync (
    MetaDbusLogin1Session *proxy,
    guint arg_major,
    guint arg_minor,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReleaseDevice",
    g_variant_new ("(uu)",
                   arg_major,
                   arg_minor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_pause_device_complete:
 * @proxy: A #MetaDbusLogin1SessionProxy.
 * @arg_major: Argument to pass with the method invocation.
 * @arg_minor: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.PauseDeviceComplete">PauseDeviceComplete()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_call_pause_device_complete_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_call_pause_device_complete_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_session_call_pause_device_complete (
    MetaDbusLogin1Session *proxy,
    guint arg_major,
    guint arg_minor,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PauseDeviceComplete",
    g_variant_new ("(uu)",
                   arg_major,
                   arg_minor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_session_call_pause_device_complete_finish:
 * @proxy: A #MetaDbusLogin1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_call_pause_device_complete().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_session_call_pause_device_complete().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_pause_device_complete_finish (
    MetaDbusLogin1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_call_pause_device_complete_sync:
 * @proxy: A #MetaDbusLogin1SessionProxy.
 * @arg_major: Argument to pass with the method invocation.
 * @arg_minor: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.PauseDeviceComplete">PauseDeviceComplete()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_call_pause_device_complete() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_session_call_pause_device_complete_sync (
    MetaDbusLogin1Session *proxy,
    guint arg_major,
    guint arg_minor,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PauseDeviceComplete",
    g_variant_new ("(uu)",
                   arg_major,
                   arg_minor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_session_complete_activate:
 * @object: A #MetaDbusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.Activate">Activate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_activate (
    MetaDbusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_session_complete_take_control:
 * @object: A #MetaDbusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeControl">TakeControl()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_take_control (
    MetaDbusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_session_complete_release_control:
 * @object: A #MetaDbusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseControl">ReleaseControl()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_release_control (
    MetaDbusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_session_complete_take_device:
 * @object: A #MetaDbusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 * @paused: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeDevice">TakeDevice()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_take_device (
    MetaDbusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd,
    gboolean paused)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@hb)",
                   fd,
                   paused),
    fd_list);
}

/**
 * meta_dbus_login1_session_complete_release_device:
 * @object: A #MetaDbusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseDevice">ReleaseDevice()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_release_device (
    MetaDbusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_login1_session_complete_pause_device_complete:
 * @object: A #MetaDbusLogin1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.PauseDeviceComplete">PauseDeviceComplete()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_session_complete_pause_device_complete (
    MetaDbusLogin1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MetaDbusLogin1SessionProxy:
 *
 * The #MetaDbusLogin1SessionProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDbusLogin1SessionProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDbusLogin1SessionProxy.
 */

struct _MetaDbusLogin1SessionProxyPrivate
{
  GData *qdata;
};

static void meta_dbus_login1_session_proxy_iface_init (MetaDbusLogin1SessionIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDbusLogin1SessionProxy, meta_dbus_login1_session_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MetaDbusLogin1SessionProxy)
                         G_IMPLEMENT_INTERFACE (META_DBUS_LOGIN1_TYPE_SESSION, meta_dbus_login1_session_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDbusLogin1SessionProxy, meta_dbus_login1_session_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (META_DBUS_LOGIN1_TYPE_SESSION, meta_dbus_login1_session_proxy_iface_init))

#endif
static void
meta_dbus_login1_session_proxy_finalize (GObject *object)
{
  MetaDbusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (meta_dbus_login1_session_proxy_parent_class)->finalize (object);
}

static void
meta_dbus_login1_session_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _meta_dbus_login1_session_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
meta_dbus_login1_session_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.login1.Session: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
meta_dbus_login1_session_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _meta_dbus_login1_session_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.login1.Session", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) meta_dbus_login1_session_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
meta_dbus_login1_session_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_meta_dbus_login1_session_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], META_DBUS_LOGIN1_TYPE_SESSION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_LOGIN1_TYPE_SESSION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
meta_dbus_login1_session_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MetaDbusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_login1_session_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_login1_session_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
meta_dbus_login1_session_proxy_get_active (MetaDbusLogin1Session *object)
{
  MetaDbusLogin1SessionProxy *proxy = META_DBUS_LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Active");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
meta_dbus_login1_session_proxy_init (MetaDbusLogin1SessionProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = meta_dbus_login1_session_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, META_DBUS_LOGIN1_TYPE_SESSION_PROXY, MetaDbusLogin1SessionProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), meta_dbus_login1_session_interface_info ());
}

static void
meta_dbus_login1_session_proxy_class_init (MetaDbusLogin1SessionProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = meta_dbus_login1_session_proxy_finalize;
  gobject_class->get_property = meta_dbus_login1_session_proxy_get_property;
  gobject_class->set_property = meta_dbus_login1_session_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = meta_dbus_login1_session_proxy_g_signal;
  proxy_class->g_properties_changed = meta_dbus_login1_session_proxy_g_properties_changed;

  meta_dbus_login1_session_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDbusLogin1SessionProxyPrivate));
#endif
}

static void
meta_dbus_login1_session_proxy_iface_init (MetaDbusLogin1SessionIface *iface)
{
  iface->get_active = meta_dbus_login1_session_proxy_get_active;
}

/**
 * meta_dbus_login1_session_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Session.top_of_page">org.freedesktop.login1.Session</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_proxy_new_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_login1_session_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_LOGIN1_TYPE_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.login1.Session", NULL);
}

/**
 * meta_dbus_login1_session_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_login1_session_proxy_new().
 *
 * Returns: (transfer full) (type MetaDbusLogin1SessionProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDbusLogin1Session *
meta_dbus_login1_session_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_LOGIN1_SESSION (ret);
  else
    return NULL;
}

/**
 * meta_dbus_login1_session_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Session.top_of_page">org.freedesktop.login1.Session</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDbusLogin1SessionProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDbusLogin1Session *
meta_dbus_login1_session_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_LOGIN1_TYPE_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.login1.Session", NULL);
  if (ret != NULL)
    return META_DBUS_LOGIN1_SESSION (ret);
  else
    return NULL;
}


/**
 * meta_dbus_login1_session_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like meta_dbus_login1_session_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_session_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_session_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_login1_session_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_LOGIN1_TYPE_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.login1.Session", NULL);
}

/**
 * meta_dbus_login1_session_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_session_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_login1_session_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MetaDbusLogin1SessionProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDbusLogin1Session *
meta_dbus_login1_session_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_LOGIN1_SESSION (ret);
  else
    return NULL;
}

/**
 * meta_dbus_login1_session_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like meta_dbus_login1_session_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_session_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDbusLogin1SessionProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDbusLogin1Session *
meta_dbus_login1_session_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_LOGIN1_TYPE_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.login1.Session", NULL);
  if (ret != NULL)
    return META_DBUS_LOGIN1_SESSION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MetaDbusLogin1SessionSkeleton:
 *
 * The #MetaDbusLogin1SessionSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDbusLogin1SessionSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDbusLogin1SessionSkeleton.
 */

struct _MetaDbusLogin1SessionSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_meta_dbus_login1_session_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MetaDbusLogin1SessionSkeleton *skeleton = META_DBUS_LOGIN1_SESSION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], META_DBUS_LOGIN1_TYPE_SESSION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_LOGIN1_TYPE_SESSION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_meta_dbus_login1_session_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MetaDbusLogin1SessionSkeleton *skeleton = META_DBUS_LOGIN1_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_login1_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_meta_dbus_login1_session_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MetaDbusLogin1SessionSkeleton *skeleton = META_DBUS_LOGIN1_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_login1_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _meta_dbus_login1_session_skeleton_vtable =
{
  _meta_dbus_login1_session_skeleton_handle_method_call,
  _meta_dbus_login1_session_skeleton_handle_get_property,
  _meta_dbus_login1_session_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
meta_dbus_login1_session_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return meta_dbus_login1_session_interface_info ();
}

static GDBusInterfaceVTable *
meta_dbus_login1_session_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_meta_dbus_login1_session_skeleton_vtable;
}

static GVariant *
meta_dbus_login1_session_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MetaDbusLogin1SessionSkeleton *skeleton = META_DBUS_LOGIN1_SESSION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_meta_dbus_login1_session_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _meta_dbus_login1_session_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _meta_dbus_login1_session_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _meta_dbus_login1_session_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.login1.Session", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _meta_dbus_login1_session_emit_changed (gpointer user_data);

static void
meta_dbus_login1_session_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MetaDbusLogin1SessionSkeleton *skeleton = META_DBUS_LOGIN1_SESSION_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _meta_dbus_login1_session_emit_changed (skeleton);
}

static void
_meta_dbus_login1_session_on_signal_pause_device (
    MetaDbusLogin1Session *object,
    guint arg_major,
    guint arg_minor,
    const gchar *arg_type)
{
  MetaDbusLogin1SessionSkeleton *skeleton = META_DBUS_LOGIN1_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(uus)",
                   arg_major,
                   arg_minor,
                   arg_type));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.login1.Session", "PauseDevice",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_meta_dbus_login1_session_on_signal_resume_device (
    MetaDbusLogin1Session *object,
    guint arg_major,
    guint arg_minor,
    GVariant *arg_fd)
{
  MetaDbusLogin1SessionSkeleton *skeleton = META_DBUS_LOGIN1_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(uu@h)",
                   arg_major,
                   arg_minor,
                   arg_fd));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.login1.Session", "ResumeDevice",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void meta_dbus_login1_session_skeleton_iface_init (MetaDbusLogin1SessionIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDbusLogin1SessionSkeleton, meta_dbus_login1_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MetaDbusLogin1SessionSkeleton)
                         G_IMPLEMENT_INTERFACE (META_DBUS_LOGIN1_TYPE_SESSION, meta_dbus_login1_session_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDbusLogin1SessionSkeleton, meta_dbus_login1_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (META_DBUS_LOGIN1_TYPE_SESSION, meta_dbus_login1_session_skeleton_iface_init))

#endif
static void
meta_dbus_login1_session_skeleton_finalize (GObject *object)
{
  MetaDbusLogin1SessionSkeleton *skeleton = META_DBUS_LOGIN1_SESSION_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (meta_dbus_login1_session_skeleton_parent_class)->finalize (object);
}

static void
meta_dbus_login1_session_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MetaDbusLogin1SessionSkeleton *skeleton = META_DBUS_LOGIN1_SESSION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_meta_dbus_login1_session_emit_changed (gpointer user_data)
{
  MetaDbusLogin1SessionSkeleton *skeleton = META_DBUS_LOGIN1_SESSION_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.login1.Session",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_meta_dbus_login1_session_schedule_emit_changed (MetaDbusLogin1SessionSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
meta_dbus_login1_session_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MetaDbusLogin1SessionSkeleton *skeleton = META_DBUS_LOGIN1_SESSION_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _meta_dbus_login1_session_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _meta_dbus_login1_session_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
meta_dbus_login1_session_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MetaDbusLogin1SessionSkeleton *skeleton = META_DBUS_LOGIN1_SESSION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _meta_dbus_login1_session_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _meta_dbus_login1_session_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
meta_dbus_login1_session_skeleton_init (MetaDbusLogin1SessionSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = meta_dbus_login1_session_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, META_DBUS_LOGIN1_TYPE_SESSION_SKELETON, MetaDbusLogin1SessionSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
}

static gboolean 
meta_dbus_login1_session_skeleton_get_active (MetaDbusLogin1Session *object)
{
  MetaDbusLogin1SessionSkeleton *skeleton = META_DBUS_LOGIN1_SESSION_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
meta_dbus_login1_session_skeleton_class_init (MetaDbusLogin1SessionSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = meta_dbus_login1_session_skeleton_finalize;
  gobject_class->get_property = meta_dbus_login1_session_skeleton_get_property;
  gobject_class->set_property = meta_dbus_login1_session_skeleton_set_property;
  gobject_class->notify       = meta_dbus_login1_session_skeleton_notify;


  meta_dbus_login1_session_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = meta_dbus_login1_session_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = meta_dbus_login1_session_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = meta_dbus_login1_session_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = meta_dbus_login1_session_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDbusLogin1SessionSkeletonPrivate));
#endif
}

static void
meta_dbus_login1_session_skeleton_iface_init (MetaDbusLogin1SessionIface *iface)
{
  iface->pause_device = _meta_dbus_login1_session_on_signal_pause_device;
  iface->resume_device = _meta_dbus_login1_session_on_signal_resume_device;
  iface->get_active = meta_dbus_login1_session_skeleton_get_active;
}

/**
 * meta_dbus_login1_session_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Session.top_of_page">org.freedesktop.login1.Session</link>.
 *
 * Returns: (transfer full) (type MetaDbusLogin1SessionSkeleton): The skeleton object.
 */
MetaDbusLogin1Session *
meta_dbus_login1_session_skeleton_new (void)
{
  return META_DBUS_LOGIN1_SESSION (g_object_new (META_DBUS_LOGIN1_TYPE_SESSION_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.login1.Seat
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MetaDbusLogin1Seat
 * @title: MetaDbusLogin1Seat
 * @short_description: Generated C code for the org.freedesktop.login1.Seat D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-login1-Seat.top_of_page">org.freedesktop.login1.Seat</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.login1.Seat ---- */

static const _ExtendedGDBusArgInfo _meta_dbus_login1_seat_method_info_switch_to_IN_ARG_vt =
{
  {
    -1,
    (gchar *) "vt",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_login1_seat_method_info_switch_to_IN_ARG_pointers[] =
{
  &_meta_dbus_login1_seat_method_info_switch_to_IN_ARG_vt.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_login1_seat_method_info_switch_to =
{
  {
    -1,
    (gchar *) "SwitchTo",
    (GDBusArgInfo **) &_meta_dbus_login1_seat_method_info_switch_to_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-switch-to",
  FALSE
};

static const GDBusMethodInfo * const _meta_dbus_login1_seat_method_info_pointers[] =
{
  &_meta_dbus_login1_seat_method_info_switch_to.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _meta_dbus_login1_seat_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.login1.Seat",
    (GDBusMethodInfo **) &_meta_dbus_login1_seat_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "seat",
};


/**
 * meta_dbus_login1_seat_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-login1-Seat.top_of_page">org.freedesktop.login1.Seat</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
meta_dbus_login1_seat_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_meta_dbus_login1_seat_interface_info.parent_struct;
}

/**
 * meta_dbus_login1_seat_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MetaDbusLogin1Seat interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
meta_dbus_login1_seat_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * MetaDbusLogin1Seat:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Seat.top_of_page">org.freedesktop.login1.Seat</link>.
 */

/**
 * MetaDbusLogin1SeatIface:
 * @parent_iface: The parent interface.
 * @handle_switch_to: Handler for the #MetaDbusLogin1Seat::handle-switch-to signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Seat.top_of_page">org.freedesktop.login1.Seat</link>.
 */

typedef MetaDbusLogin1SeatIface MetaDbusLogin1SeatInterface;
G_DEFINE_INTERFACE (MetaDbusLogin1Seat, meta_dbus_login1_seat, G_TYPE_OBJECT)

static void
meta_dbus_login1_seat_default_init (MetaDbusLogin1SeatIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MetaDbusLogin1Seat::handle-switch-to:
   * @object: A #MetaDbusLogin1Seat.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_vt: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Seat.SwitchTo">SwitchTo()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_login1_seat_complete_switch_to() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-switch-to",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDbusLogin1SeatIface, handle_switch_to),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

}

/**
 * meta_dbus_login1_seat_call_switch_to:
 * @proxy: A #MetaDbusLogin1SeatProxy.
 * @arg_vt: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Seat.SwitchTo">SwitchTo()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_seat_call_switch_to_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_seat_call_switch_to_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_login1_seat_call_switch_to (
    MetaDbusLogin1Seat *proxy,
    guint arg_vt,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SwitchTo",
    g_variant_new ("(u)",
                   arg_vt),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_login1_seat_call_switch_to_finish:
 * @proxy: A #MetaDbusLogin1SeatProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_seat_call_switch_to().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_login1_seat_call_switch_to().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_seat_call_switch_to_finish (
    MetaDbusLogin1Seat *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_seat_call_switch_to_sync:
 * @proxy: A #MetaDbusLogin1SeatProxy.
 * @arg_vt: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Seat.SwitchTo">SwitchTo()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_seat_call_switch_to() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_login1_seat_call_switch_to_sync (
    MetaDbusLogin1Seat *proxy,
    guint arg_vt,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SwitchTo",
    g_variant_new ("(u)",
                   arg_vt),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_login1_seat_complete_switch_to:
 * @object: A #MetaDbusLogin1Seat.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Seat.SwitchTo">SwitchTo()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_login1_seat_complete_switch_to (
    MetaDbusLogin1Seat *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MetaDbusLogin1SeatProxy:
 *
 * The #MetaDbusLogin1SeatProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDbusLogin1SeatProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDbusLogin1SeatProxy.
 */

struct _MetaDbusLogin1SeatProxyPrivate
{
  GData *qdata;
};

static void meta_dbus_login1_seat_proxy_iface_init (MetaDbusLogin1SeatIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDbusLogin1SeatProxy, meta_dbus_login1_seat_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MetaDbusLogin1SeatProxy)
                         G_IMPLEMENT_INTERFACE (META_DBUS_LOGIN1_TYPE_SEAT, meta_dbus_login1_seat_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDbusLogin1SeatProxy, meta_dbus_login1_seat_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (META_DBUS_LOGIN1_TYPE_SEAT, meta_dbus_login1_seat_proxy_iface_init))

#endif
static void
meta_dbus_login1_seat_proxy_finalize (GObject *object)
{
  MetaDbusLogin1SeatProxy *proxy = META_DBUS_LOGIN1_SEAT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (meta_dbus_login1_seat_proxy_parent_class)->finalize (object);
}

static void
meta_dbus_login1_seat_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
meta_dbus_login1_seat_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
meta_dbus_login1_seat_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_meta_dbus_login1_seat_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], META_DBUS_LOGIN1_TYPE_SEAT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_LOGIN1_TYPE_SEAT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
meta_dbus_login1_seat_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MetaDbusLogin1SeatProxy *proxy = META_DBUS_LOGIN1_SEAT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_login1_seat_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_login1_seat_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
meta_dbus_login1_seat_proxy_init (MetaDbusLogin1SeatProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = meta_dbus_login1_seat_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, META_DBUS_LOGIN1_TYPE_SEAT_PROXY, MetaDbusLogin1SeatProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), meta_dbus_login1_seat_interface_info ());
}

static void
meta_dbus_login1_seat_proxy_class_init (MetaDbusLogin1SeatProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = meta_dbus_login1_seat_proxy_finalize;
  gobject_class->get_property = meta_dbus_login1_seat_proxy_get_property;
  gobject_class->set_property = meta_dbus_login1_seat_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = meta_dbus_login1_seat_proxy_g_signal;
  proxy_class->g_properties_changed = meta_dbus_login1_seat_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDbusLogin1SeatProxyPrivate));
#endif
}

static void
meta_dbus_login1_seat_proxy_iface_init (MetaDbusLogin1SeatIface *iface G_GNUC_UNUSED)
{
}

/**
 * meta_dbus_login1_seat_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Seat.top_of_page">org.freedesktop.login1.Seat</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_seat_proxy_new_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_seat_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_login1_seat_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_LOGIN1_TYPE_SEAT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.login1.Seat", NULL);
}

/**
 * meta_dbus_login1_seat_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_seat_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_login1_seat_proxy_new().
 *
 * Returns: (transfer full) (type MetaDbusLogin1SeatProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDbusLogin1Seat *
meta_dbus_login1_seat_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_LOGIN1_SEAT (ret);
  else
    return NULL;
}

/**
 * meta_dbus_login1_seat_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Seat.top_of_page">org.freedesktop.login1.Seat</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_seat_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDbusLogin1SeatProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDbusLogin1Seat *
meta_dbus_login1_seat_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_LOGIN1_TYPE_SEAT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.login1.Seat", NULL);
  if (ret != NULL)
    return META_DBUS_LOGIN1_SEAT (ret);
  else
    return NULL;
}


/**
 * meta_dbus_login1_seat_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like meta_dbus_login1_seat_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_login1_seat_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See meta_dbus_login1_seat_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_login1_seat_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_LOGIN1_TYPE_SEAT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.login1.Seat", NULL);
}

/**
 * meta_dbus_login1_seat_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_login1_seat_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_login1_seat_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MetaDbusLogin1SeatProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDbusLogin1Seat *
meta_dbus_login1_seat_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_LOGIN1_SEAT (ret);
  else
    return NULL;
}

/**
 * meta_dbus_login1_seat_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like meta_dbus_login1_seat_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_login1_seat_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDbusLogin1SeatProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDbusLogin1Seat *
meta_dbus_login1_seat_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_LOGIN1_TYPE_SEAT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.login1.Seat", NULL);
  if (ret != NULL)
    return META_DBUS_LOGIN1_SEAT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MetaDbusLogin1SeatSkeleton:
 *
 * The #MetaDbusLogin1SeatSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDbusLogin1SeatSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDbusLogin1SeatSkeleton.
 */

struct _MetaDbusLogin1SeatSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_meta_dbus_login1_seat_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MetaDbusLogin1SeatSkeleton *skeleton = META_DBUS_LOGIN1_SEAT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], META_DBUS_LOGIN1_TYPE_SEAT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_LOGIN1_TYPE_SEAT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_meta_dbus_login1_seat_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MetaDbusLogin1SeatSkeleton *skeleton = META_DBUS_LOGIN1_SEAT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_login1_seat_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_meta_dbus_login1_seat_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MetaDbusLogin1SeatSkeleton *skeleton = META_DBUS_LOGIN1_SEAT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_login1_seat_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _meta_dbus_login1_seat_skeleton_vtable =
{
  _meta_dbus_login1_seat_skeleton_handle_method_call,
  _meta_dbus_login1_seat_skeleton_handle_get_property,
  _meta_dbus_login1_seat_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
meta_dbus_login1_seat_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return meta_dbus_login1_seat_interface_info ();
}

static GDBusInterfaceVTable *
meta_dbus_login1_seat_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_meta_dbus_login1_seat_skeleton_vtable;
}

static GVariant *
meta_dbus_login1_seat_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MetaDbusLogin1SeatSkeleton *skeleton = META_DBUS_LOGIN1_SEAT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_meta_dbus_login1_seat_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _meta_dbus_login1_seat_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _meta_dbus_login1_seat_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _meta_dbus_login1_seat_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.login1.Seat", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
meta_dbus_login1_seat_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void meta_dbus_login1_seat_skeleton_iface_init (MetaDbusLogin1SeatIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDbusLogin1SeatSkeleton, meta_dbus_login1_seat_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MetaDbusLogin1SeatSkeleton)
                         G_IMPLEMENT_INTERFACE (META_DBUS_LOGIN1_TYPE_SEAT, meta_dbus_login1_seat_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDbusLogin1SeatSkeleton, meta_dbus_login1_seat_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (META_DBUS_LOGIN1_TYPE_SEAT, meta_dbus_login1_seat_skeleton_iface_init))

#endif
static void
meta_dbus_login1_seat_skeleton_finalize (GObject *object)
{
  MetaDbusLogin1SeatSkeleton *skeleton = META_DBUS_LOGIN1_SEAT_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (meta_dbus_login1_seat_skeleton_parent_class)->finalize (object);
}

static void
meta_dbus_login1_seat_skeleton_init (MetaDbusLogin1SeatSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = meta_dbus_login1_seat_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, META_DBUS_LOGIN1_TYPE_SEAT_SKELETON, MetaDbusLogin1SeatSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
meta_dbus_login1_seat_skeleton_class_init (MetaDbusLogin1SeatSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = meta_dbus_login1_seat_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = meta_dbus_login1_seat_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = meta_dbus_login1_seat_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = meta_dbus_login1_seat_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = meta_dbus_login1_seat_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDbusLogin1SeatSkeletonPrivate));
#endif
}

static void
meta_dbus_login1_seat_skeleton_iface_init (MetaDbusLogin1SeatIface *iface G_GNUC_UNUSED)
{
}

/**
 * meta_dbus_login1_seat_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Seat.top_of_page">org.freedesktop.login1.Seat</link>.
 *
 * Returns: (transfer full) (type MetaDbusLogin1SeatSkeleton): The skeleton object.
 */
MetaDbusLogin1Seat *
meta_dbus_login1_seat_skeleton_new (void)
{
  return META_DBUS_LOGIN1_SEAT (g_object_new (META_DBUS_LOGIN1_TYPE_SEAT_SKELETON, NULL));
}

