#include "bin2c.hh"

static const unsigned char dhclient_summary_lnav_data[] = {
0x78, 0x9c, 0x6d, 0x52, 0x5d, 0x6f, 0x9b, 0x30, 0x14, 0x7d, 0xe7, 0x57, 
0x5c, 0x25, 0xab, 0x02, 0x1b, 0x54, 0x4b, 0xd4, 0x27, 0xb6, 0x87, 0x65, 
0x09, 0x6b, 0x90, 0x68, 0x12, 0x01, 0x55, 0x35, 0x69, 0x52, 0xe4, 0x80, 
0x13, 0x3c, 0x81, 0x8d, 0x6c, 0xd3, 0x35, 0xff, 0x7e, 0x36, 0x38, 0x01, 
0xaa, 0x82, 0xf8, 0xf0, 0xbd, 0xe7, 0x9e, 0xfb, 0x71, 0xee, 0xd4, 0x9a, 
0xc2, 0x0f, 0x71, 0xa1, 0xac, 0x16, 0x44, 0xf8, 0x90, 0x17, 0x59, 0x49, 
0x30, 0x95, 0x9e, 0x68, 0xaa, 0x0a, 0xf1, 0x8b, 0xf6, 0xe6, 0x58, 0x64, 
0x9c, 0xd4, 0x92, 0x30, 0xea, 0xc3, 0x23, 0xa6, 0x98, 0x23, 0x89, 0x01, 
0x81, 0x81, 0x00, 0x3b, 0xc1, 0x7a, 0xb3, 0xda, 0x03, 0xca, 0x73, 0x8e, 
0x85, 0xc0, 0x02, 0x8e, 0xac, 0xa1, 0x39, 0x10, 0x0a, 0xb2, 0x20, 0x02, 
0x4a, 0x76, 0xb6, 0xa6, 0x96, 0xe5, 0xe3, 0xac, 0x60, 0x1d, 0xb2, 0xc4, 
0x48, 0xc3, 0xd8, 0x2b, 0xe6, 0x20, 0x49, 0x85, 0xfd, 0xce, 0x69, 0x7d, 
0x4b, 0x82, 0x28, 0x58, 0xa5, 0x40, 0x6a, 0x58, 0x26, 0x10, 0xee, 0x5d, 
0x10, 0x12, 0x71, 0x79, 0xd0, 0x18, 0x6d, 0x99, 0x24, 0xfa, 0x08, 0xa9, 
0x3a, 0x4e, 0x5c, 0x0b, 0xcc, 0x55, 0x73, 0x42, 0xe5, 0xc9, 0x9e, 0xdc, 
0xc1, 0xe2, 0x41, 0x4c, 0x5c, 0x58, 0x2d, 0x93, 0xe0, 0xe6, 0x04, 0x78, 
0xd9, 0x04, 0x5b, 0xc0, 0x34, 0xef, 0x58, 0xc2, 0x04, 0xb6, 0xcf, 0x51, 
0x04, 0xa9, 0xb6, 0xde, 0x22, 0x85, 0xbe, 0x55, 0xe8, 0x27, 0x44, 0x05, 
0x39, 0x9c, 0x39, 0xc6, 0xd4, 0x85, 0xd9, 0x32, 0x93, 0xe4, 0x15, 0xcf, 
0xae, 0x66, 0xca, 0x78, 0xe5, 0x0c, 0x88, 0x83, 0x68, 0x94, 0x67, 0x40, 
0x76, 0xff, 0x75, 0x71, 0xba, 0x13, 0x50, 0xb0, 0x86, 0xf7, 0xac, 0x47, 
0x56, 0xe6, 0x2e, 0xd8, 0x7f, 0x9b, 0x92, 0x20, 0x9a, 0xa3, 0x8b, 0x7d, 
0xad, 0xc9, 0x01, 0x0f, 0x7a, 0x6b, 0xdf, 0xb1, 0xe3, 0xc0, 0x67, 0xd5, 
0xd2, 0xc7, 0xe9, 0x83, 0xed, 0xda, 0xd1, 0x23, 0x59, 0x37, 0x4a, 0x0d, 
0xa5, 0x8c, 0x72, 0xfc, 0x8a, 0x77, 0x4f, 0xea, 0x63, 0xbf, 0x84, 0xe9, 
0xa6, 0x1b, 0x71, 0x4b, 0x23, 0x14, 0xac, 0x0d, 0xb3, 0xcd, 0x74, 0x2b, 
0x42, 0x6d, 0xa5, 0x89, 0xc9, 0xad, 0x38, 0xfa, 0x94, 0xae, 0x1e, 0xbd, 
0xe1, 0x19, 0x86, 0x5c, 0xe1, 0x2e, 0x70, 0x7c, 0xc6, 0x6f, 0xf5, 0xa1, 
0x42, 0x32, 0x2b, 0xec, 0x59, 0x27, 0xb4, 0x64, 0x60, 0xff, 0x49, 0xbe, 
0xa8, 0x3e, 0x3c, 0x35, 0xac, 0x16, 0x8b, 0xdf, 0x64, 0x4b, 0x6d, 0xe8, 
0x40, 0x5c, 0x84, 0xb6, 0xab, 0x47, 0xeb, 0x11, 0x07, 0xda, 0xa1, 0xa5, 
0xd8, 0xa5, 0xad, 0x1c, 0xa6, 0xaf, 0xc7, 0x78, 0xf7, 0xbc, 0x87, 0x9f, 
0xbf, 0xb5, 0x77, 0x17, 0xaf, 0x83, 0x58, 0xff, 0x8f, 0x56, 0x60, 0xd5, 
0x21, 0x4d, 0x59, 0x83, 0xc2, 0x07, 0x42, 0xf4, 0x55, 0xcb, 0xc5, 0xfd, 
0x78, 0x81, 0x6e, 0x6b, 0xd0, 0x16, 0x35, 0x9e, 0x91, 0x86, 0x9b, 0xe2, 
0x4a, 0x39, 0x1f, 0x06, 0x7e, 0x7f, 0xcf, 0x14, 0x85, 0x4f, 0x61, 0x0a, 
0x73, 0x67, 0x48, 0x39, 0xaa, 0x80, 0xd4, 0xe6, 0xf4, 0x71, 0x9e, 0xb9, 
0x63, 0xf9, 0xff, 0x38, 0x91, 0xd8, 0x93, 0xe8, 0x58, 0xaa, 0x37, 0x03, 
0xcf, 0xfa, 0x0f, 0xf5, 0x0b, 0x0f, 0x42, 0x00

};
static const unsigned char docker_url_handler_lnav_data[] = {
0x78, 0x9c, 0xad, 0x55, 0x6d, 0x4f, 0xdb, 0x30, 0x10, 0xfe, 0x9e, 0x5f, 
0x71, 0x83, 0xa0, 0x24, 0xa2, 0x2e, 0xb0, 0x8f, 0x9d, 0x10, 0x43, 0x10, 
0xb4, 0x49, 0xac, 0x93, 0x5a, 0xa6, 0x7d, 0x41, 0x44, 0x5e, 0x72, 0x6d, 
0x02, 0x89, 0x1d, 0xd9, 0x2e, 0x6a, 0xb5, 0xee, 0xbf, 0xcf, 0x4e, 0xd2, 
0xd0, 0x90, 0x58, 0x0c, 0x69, 0xd7, 0x4a, 0x7e, 0xb9, 0xc7, 0x77, 0x8f, 
0xef, 0xdc, 0xa7, 0x87, 0xce, 0x21, 0x7c, 0x96, 0x1b, 0xc6, 0x4b, 0x99, 
0xc9, 0x09, 0x24, 0x3c, 0x7e, 0x42, 0x41, 0x56, 0x22, 0x27, 0x29, 0x65, 
0x49, 0x8e, 0xc2, 0xf8, 0x13, 0x94, 0xb1, 0xc8, 0x4a, 0x95, 0x71, 0x36, 
0x81, 0xaf, 0x4c, 0xa1, 0x60, 0x34, 0x87, 0x7a, 0x0f, 0x14, 0x87, 0x1a, 
0x0a, 0xbc, 0x44, 0x96, 0xb1, 0x65, 0x13, 0xe4, 0xa4, 0xe4, 0x49, 0x41, 
0x19, 0xfc, 0x98, 0xdd, 0x4a, 0xe7, 0xd0, 0x71, 0x3e, 0xcd, 0xc3, 0xdb, 
0xf0, 0xea, 0x0e, 0x1e, 0x97, 0xa8, 0x7c, 0x9d, 0x60, 0x04, 0xde, 0x89, 
0x8c, 0x53, 0x2c, 0xd0, 0x0b, 0xe0, 0x72, 0xde, 0x9c, 0x8a, 0xea, 0xad, 
0x91, 0x03, 0x8d, 0xed, 0xc3, 0x53, 0x2e, 0x55, 0x07, 0x6c, 0x36, 0x18, 
0xb5, 0xc1, 0x4b, 0xaa, 0xd2, 0x0e, 0xdc, 0x6c, 0x18, 0xe4, 0xcd, 0xec, 
0xfb, 0x37, 0xf0, 0x1b, 0x3e, 0x25, 0x15, 0x12, 0x23, 0x7d, 0xc4, 0x77, 
0xcf, 0x2a, 0xb0, 0x9e, 0x06, 0x2f, 0x74, 0xe5, 0xea, 0x97, 0x54, 0xc2, 
0x77, 0xf7, 0x42, 0x8c, 0xe0, 0xe3, 0x7e, 0x54, 0x81, 0x79, 0x15, 0xb8, 
0x3d, 0x72, 0x75, 0x39, 0x0f, 0x5b, 0x42, 0xee, 0x2b, 0xaa, 0xad, 0xe3, 
0xe7, 0x97, 0x70, 0x0a, 0x5e, 0xcc, 0x8b, 0x92, 0x4b, 0xf4, 0xe0, 0xce, 
0x2c, 0xfd, 0xd6, 0x6b, 0xac, 0x09, 0xb7, 0x14, 0x7c, 0x55, 0x46, 0x31, 
0x67, 0x31, 0x55, 0x5d, 0xc0, 0xce, 0x4a, 0x91, 0x31, 0xb5, 0x18, 0xf6, 
0x19, 0xf3, 0x26, 0x32, 0x05, 0x42, 0x4c, 0xfa, 0xf3, 0x23, 0x09, 0x47, 
0x92, 0x34, 0x69, 0x81, 0x2c, 0xf4, 0x0a, 0x72, 0xbe, 0x94, 0xc6, 0xcf, 
0x89, 0x9e, 0x91, 0x52, 0xe0, 0x22, 0x5b, 0xd7, 0x2e, 0x6f, 0x64, 0x0d, 
0xda, 0x84, 0x88, 0x24, 0x8a, 0xe7, 0x2c, 0x46, 0x39, 0x7e, 0xc2, 0x8d, 
0x1d, 0xed, 0x5a, 0xda, 0x6b, 0xc3, 0x35, 0x45, 0x7d, 0x5f, 0xfa, 0x41, 
0x70, 0x30, 0x1c, 0x23, 0x4e, 0xa9, 0xf0, 0xcf, 0x4e, 0x83, 0x9e, 0xb3, 
0x6a, 0x6d, 0x5c, 0x24, 0xb2, 0xe3, 0xa9, 0x9e, 0xcc, 0x42, 0x2a, 0xdd, 
0x82, 0x57, 0x14, 0x2b, 0xbc, 0x54, 0xfd, 0x2c, 0x02, 0x97, 0xb8, 0xd6, 
0x8d, 0xa3, 0xa5, 0x5a, 0x09, 0x1c, 0xee, 0x4e, 0xb6, 0x60, 0xab, 0x3c, 
0xb7, 0x77, 0x4e, 0xaa, 0x71, 0x42, 0x15, 0xb5, 0x97, 0x41, 0xd0, 0x4c, 
0x17, 0x01, 0x85, 0xe0, 0xc2, 0x1e, 0xc5, 0x98, 0x77, 0x45, 0x19, 0xe3, 
0x4a, 0xb3, 0xa2, 0xc9, 0xae, 0x78, 0x7a, 0x64, 0x8b, 0x6c, 0xb9, 0x12, 
0xb4, 0xfe, 0x69, 0x7b, 0xb0, 0xdd, 0xfe, 0x7b, 0x07, 0x1a, 0x7e, 0x55, 
0x6e, 0x2b, 0xa8, 0x5f, 0xdf, 0x6a, 0x77, 0x38, 0xaa, 0xe7, 0x5f, 0x14, 
0x81, 0x7f, 0x31, 0x79, 0x20, 0x84, 0xb8, 0xc1, 0x85, 0xaf, 0xa7, 0xfa, 
0x3b, 0xde, 0xde, 0x33, 0xbd, 0xfb, 0xe1, 0x41, 0xcf, 0xb5, 0x63, 0x7b, 
0x3f, 0x36, 0x9f, 0xc0, 0x0d, 0x82, 0xe3, 0xc0, 0x1b, 0x6e, 0xdf, 0x46, 
0xdf, 0xa1, 0x9f, 0xe2, 0x51, 0x72, 0x16, 0x21, 0x8d, 0xd3, 0xe1, 0x4a, 
0x6d, 0x68, 0x91, 0x47, 0x8a, 0x47, 0x06, 0x66, 0xaf, 0xa5, 0x09, 0x3d, 
0xd6, 0x75, 0x53, 0xc8, 0xd4, 0xbb, 0xee, 0xe6, 0x8e, 0x77, 0x4f, 0x75, 
0x88, 0x34, 0x95, 0xbd, 0x17, 0xdd, 0x41, 0x69, 0xb5, 0x98, 0x85, 0x75, 
0xf2, 0x82, 0xaa, 0x38, 0x8d, 0x32, 0x96, 0xe0, 0x1a, 0xce, 0xe1, 0xb4, 
0x17, 0xec, 0x72, 0x7a, 0xdd, 0xb0, 0xac, 0x5f, 0x5e, 0x0b, 0x3d, 0x6b, 
0xa1, 0x2f, 0x5d, 0x09, 0x6f, 0xe7, 0x61, 0x57, 0xb0, 0x8c, 0xb9, 0xaf, 
0x04, 0x73, 0x9f, 0x86, 0x16, 0xad, 0x93, 0x46, 0xae, 0x6c, 0xba, 0x53, 
0xe9, 0x4d, 0xab, 0x2b, 0x16, 0x1d, 0x79, 0x4b, 0x11, 0xac, 0xc2, 0xd9, 
0xbd, 0x40, 0x7b, 0x89, 0xb7, 0xc8, 0xe0, 0x1a, 0x63, 0x33, 0x2a, 0x9a, 
0xe5, 0x40, 0x18, 0x1c, 0x9f, 0x02, 0xb9, 0x81, 0x83, 0x23, 0x79, 0xf0, 
0x1f, 0xc8, 0xd9, 0x11, 0xbd, 0x12, 0xee, 0xd5, 0x7e, 0x7a, 0xed, 0x34, 
0x63, 0xab, 0x39, 0xce, 0x04, 0x9f, 0xf5, 0x7f, 0xab, 0xfb, 0xdb, 0xac, 
0xfe, 0x38, 0x7f, 0x01, 0xce, 0x28, 0xd1, 0x9b, 0x00

};
static const unsigned char journald_url_handler_lnav_data[] = {
0x78, 0x9c, 0x6d, 0x91, 0xdb, 0x6a, 0xc3, 0x30, 0x0c, 0x86, 0xef, 0xfd, 
0x14, 0x82, 0x66, 0x38, 0x85, 0x86, 0xd1, 0xdb, 0x8c, 0xc2, 0x4a, 0x9b, 
0xb1, 0x41, 0xd7, 0x41, 0xd3, 0xb1, 0xcb, 0x62, 0x1c, 0x37, 0x87, 0x39, 
0x76, 0x88, 0x9d, 0x41, 0x59, 0xf7, 0xee, 0xf3, 0xa1, 0x07, 0xd2, 0x54, 
0x04, 0x22, 0xff, 0x7c, 0x92, 0x7e, 0xa1, 0x11, 0x1a, 0xc1, 0xb3, 0x3a, 
0x08, 0xd9, 0xa8, 0x52, 0xc5, 0x50, 0xc9, 0xae, 0x15, 0x84, 0x67, 0x51, 
0xd7, 0xf2, 0xa8, 0x20, 0x22, 0xe3, 0xac, 0xb5, 0x44, 0xc6, 0x14, 0x6d, 
0xcb, 0x46, 0x97, 0x52, 0xc4, 0xf0, 0x26, 0x34, 0xb3, 0x14, 0x78, 0x0d, 
0xb4, 0x04, 0x8f, 0x82, 0x6c, 0x98, 0x28, 0x45, 0x7e, 0x69, 0x03, 0x9f, 
0x9b, 0x95, 0x42, 0x23, 0x84, 0x9e, 0xd2, 0x64, 0x95, 0x2c, 0xb6, 0x08, 
0x4c, 0x54, 0x39, 0xd3, 0xa1, 0xe9, 0x3f, 0x01, 0xfc, 0xa8, 0x68, 0xc1, 
0x6a, 0x86, 0xc7, 0x30, 0x4f, 0xa1, 0xf2, 0x8f, 0xc9, 0x00, 0x2a, 0xa4, 
0xd2, 0x27, 0xc4, 0xa6, 0x43, 0xa0, 0x21, 0x2d, 0xa9, 0x99, 0x31, 0xa5, 
0x0c, 0x46, 0x14, 0x54, 0x4e, 0x50, 0x8e, 0x7b, 0xd9, 0x7c, 0xbc, 0x43, 
0xe8, 0xc7, 0x83, 0xd1, 0x15, 0xdb, 0x99, 0xaa, 0x30, 0x98, 0xba, 0x86, 
0x26, 0x1d, 0xf7, 0xdd, 0x35, 0x6d, 0x29, 0xf4, 0x3e, 0xc4, 0xb1, 0x2a, 
0xce, 0x6b, 0x50, 0xcd, 0x21, 0x8a, 0x64, 0xa7, 0x9b, 0x4e, 0xcf, 0x2a, 
0x25, 0x05, 0x44, 0x7b, 0x78, 0x50, 0xe6, 0xc3, 0xde, 0x8b, 0x8d, 0xc5, 
0x3c, 0x4d, 0x20, 0x70, 0x06, 0x2f, 0x9a, 0x8d, 0xaf, 0xd7, 0x64, 0x0d, 
0x98, 0x4b, 0x4a, 0xb8, 0xdb, 0x03, 0xb6, 0x46, 0xe8, 0x11, 0x36, 0x30, 
0xee, 0x49, 0xc9, 0x2a, 0x4d, 0x86, 0x4c, 0x54, 0x03, 0x86, 0xe3, 0xf1, 
0x76, 0x4a, 0xb2, 0x5e, 0x5e, 0x6d, 0x9c, 0x37, 0xcd, 0x5b, 0xd9, 0x35, 
0x3b, 0x2a, 0x05, 0x25, 0x3a, 0xec, 0xb5, 0x72, 0x46, 0x39, 0x13, 0xb9, 
0x2e, 0xc2, 0x6f, 0x76, 0x18, 0x0f, 0xe6, 0x38, 0xc7, 0xd3, 0xfb, 0x3e, 
0xbd, 0x0f, 0xe7, 0xc2, 0xd4, 0xda, 0x1f, 0x06, 0x3c, 0xa0, 0xee, 0xda, 
0xf7, 0xa5, 0xfd, 0xda, 0xd9, 0xcd, 0xda, 0xeb, 0xa5, 0x91, 0x7b, 0xd2, 
0x0f, 0xe1, 0x1d, 0x9b, 0xf4, 0x24, 0x33, 0xb1, 0x6f, 0xda, 0x9d, 0xd8, 
0xde, 0x65, 0xc7, 0x08, 0x2d, 0xc2, 0xe0, 0x74, 0xfe, 0x2b, 0xe4, 0x33, 
0x77, 0x70, 0x5a, 0x67, 0x0a, 0xa1, 0x98, 0x99, 0xbe, 0x10, 0xfc, 0xda, 
0xd7, 0x1f, 0xfa, 0x07, 0x6b, 0xf4, 0xc1, 0x4b, 0x00

};
static const unsigned char lnav_copy_text_lnav_data[] = {
0x78, 0x9c, 0x35, 0x8e, 0xc1, 0x4a, 0xc4, 0x30, 0x10, 0x86, 0xef, 0x79, 
0x8a, 0x81, 0x2e, 0x54, 0xc1, 0xd2, 0x7b, 0xbc, 0xb8, 0xd4, 0x88, 0x42, 
0xad, 0x60, 0x57, 0x3c, 0x96, 0x6e, 0x32, 0xba, 0x91, 0x36, 0x09, 0xc9, 
0xd8, 0x75, 0x91, 0x7d, 0x77, 0x93, 0xd8, 0x9d, 0xe3, 0x7c, 0xf3, 0x7f, 
0xf3, 0x17, 0xac, 0x80, 0xbb, 0x70, 0x32, 0xd6, 0x05, 0x1d, 0x38, 0x4c, 
0x66, 0x5c, 0x2a, 0x69, 0xdd, 0xa9, 0x22, 0xfc, 0xa1, 0xc4, 0x14, 0x06, 
0xe9, 0xb5, 0x23, 0x6d, 0x0d, 0x87, 0x26, 0x12, 0x48, 0x04, 0x3e, 0xbc, 
0x9d, 0x81, 0x0e, 0x08, 0x64, 0x1d, 0x2c, 0x1a, 0x8f, 0xac, 0x60, 0xec, 
0xb6, 0x17, 0xad, 0x68, 0x76, 0xf0, 0xf5, 0x89, 0x74, 0x15, 0x70, 0x42, 
0x49, 0xa8, 0x86, 0x74, 0x7f, 0x03, 0x65, 0xbd, 0x8c, 0xd3, 0x37, 0x96, 
0xd7, 0xb0, 0xed, 0x41, 0x5a, 0x43, 0x68, 0x08, 0x1e, 0x5e, 0x5f, 0x9e, 
0xf3, 0xcf, 0x21, 0x6a, 0x86, 0xac, 0xb9, 0x38, 0x9a, 0x6d, 0x2f, 0x18, 
0xc4, 0x79, 0x7f, 0x14, 0x1d, 0x6c, 0x2e, 0x89, 0xa7, 0x1e, 0xba, 0xb7, 
0xb6, 0x85, 0x5d, 0xdc, 0x66, 0x9c, 0xa6, 0xe4, 0x47, 0xaf, 0x09, 0x2b, 
0xb2, 0x50, 0x95, 0x79, 0x2b, 0xda, 0x35, 0xfd, 0x8f, 0x51, 0x1e, 0x22, 
0x32, 0xb0, 0xf9, 0x5d, 0x3d, 0xe7, 0xf5, 0xac, 0xbb, 0xcf, 0x75, 0x66, 
0xc5, 0x18, 0xf7, 0xa8, 0xb4, 0x8f, 0x95, 0x93, 0xa6, 0x56, 0xb8, 0xd4, 
0x72, 0xd2, 0x6e, 0x6f, 0x47, 0xaf, 0x18, 0xc7, 0x58, 0x3e, 0xa5, 0x67, 
0x75, 0x66, 0x7f, 0x39, 0xd1, 0x5d, 0x94, 0x00

};
static const unsigned char lnav_pop_view_lnav_data[] = {
0x78, 0x9c, 0xad, 0x52, 0xcb, 0x6e, 0xc2, 0x30, 0x10, 0xbc, 0xfb, 0x2b, 
0x56, 0x22, 0x52, 0x2e, 0x70, 0xe0, 0xd0, 0x4b, 0x50, 0xa5, 0xa6, 0xc4, 
0x55, 0x91, 0x42, 0x40, 0x49, 0x50, 0xd5, 0x93, 0x65, 0x88, 0x0b, 0x11, 
0x49, 0x1c, 0x61, 0x8b, 0x87, 0xaa, 0xfe, 0x7b, 0xd7, 0x4e, 0x1b, 0x02, 
0xa5, 0x52, 0x0f, 0x3d, 0x65, 0xb3, 0x33, 0x3b, 0x9e, 0x1d, 0xbb, 0x47, 
0x7a, 0xf0, 0xa0, 0x4e, 0x95, 0xac, 0x55, 0xae, 0x3c, 0x28, 0x2a, 0xbe, 
0x1f, 0xd4, 0xb2, 0x1e, 0xec, 0x73, 0x71, 0x30, 0x50, 0x26, 0xd4, 0x6a, 
0x97, 0xd7, 0x3a, 0x97, 0x95, 0x07, 0x73, 0x59, 0x83, 0xde, 0x08, 0xd0, 
0xf8, 0x35, 0x04, 0x90, 0x95, 0xfd, 0xb7, 0xb5, 0xd2, 0x7c, 0xb5, 0x25, 
0x3d, 0x42, 0x46, 0x09, 0x0d, 0xe9, 0x38, 0x85, 0x9d, 0x3c, 0xe4, 0x19, 
0x70, 0x65, 0x0a, 0xa6, 0x25, 0xcb, 0x44, 0x21, 0xb4, 0xe8, 0x43, 0xc5, 
0x4b, 0x61, 0xda, 0x05, 0x57, 0x9a, 0x99, 0x51, 0x66, 0x3a, 0x7d, 0x18, 
0xfb, 0x09, 0xb5, 0x20, 0x01, 0x80, 0x97, 0x67, 0x1a, 0x81, 0x9b, 0x2d, 
0x5d, 0x48, 0x4d, 0xe5, 0x6c, 0xc5, 0xa9, 0xe4, 0x35, 0x6a, 0xbc, 0xb1, 
0x6c, 0x69, 0xa7, 0xce, 0xac, 0x4d, 0xae, 0xb4, 0x5c, 0xef, 0x78, 0x79, 
0x83, 0x6c, 0xb0, 0x2b, 0xba, 0x16, 0x47, 0x7d, 0x83, 0x69, 0xda, 0x2d, 
0x93, 0x86, 0xe8, 0xc5, 0x75, 0x09, 0xd0, 0x28, 0x30, 0x5e, 0xad, 0x4d, 
0x5e, 0x68, 0x56, 0xaa, 0x35, 0x3c, 0xc5, 0xb3, 0xa9, 0x4d, 0xaa, 0x71, 
0x6f, 0x17, 0x87, 0x59, 0x1c, 0xd0, 0x18, 0x1e, 0x5f, 0xbf, 0xd6, 0x0e, 
0x68, 0x32, 0x86, 0x70, 0x32, 0x9d, 0xa4, 0x30, 0x1c, 0xb5, 0x91, 0x60, 
0x70, 0x4c, 0xe7, 0x9d, 0xf5, 0xdb, 0xc6, 0xa5, 0xa6, 0x32, 0x56, 0xe3, 
0x26, 0x0d, 0xb8, 0x07, 0xe7, 0x32, 0x2a, 0xd4, 0x0b, 0x50, 0x2f, 0xa5, 
0xb7, 0x9d, 0x34, 0xa3, 0x8d, 0x0d, 0x9c, 0xbd, 0x48, 0xff, 0x6c, 0xc5, 
0x4a, 0xfb, 0x09, 0x54, 0xe2, 0x60, 0x5d, 0xb4, 0xea, 0xff, 0xb1, 0x1e, 
0xea, 0xca, 0x22, 0xfb, 0xeb, 0x76, 0x3f, 0x2c, 0xa0, 0xe2, 0x62, 0x1e, 
0xf8, 0xb8, 0x60, 0x67, 0x26, 0xa1, 0x9d, 0x03, 0xbe, 0x33, 0x69, 0x1b, 
0x56, 0x11, 0x6f, 0xce, 0x19, 0x22, 0xe6, 0x1e, 0xef, 0x86, 0x2e, 0xf8, 
0x51, 0x80, 0x8d, 0x5f, 0x0f, 0xf9, 0xc2, 0xaf, 0x74, 0x26, 0x09, 0x44, 
0xb3, 0x14, 0xa2, 0x45, 0x18, 0x8e, 0x88, 0x27, 0xf6, 0xbc, 0x00, 0x0f, 
0xef, 0x7d, 0x60, 0xee, 0xdd, 0x79, 0xef, 0x3e, 0x83, 0x0f, 0x84, 0x57, 
0x1b, 0x49, 0x3e, 0x01, 0xd5, 0x86, 0x12, 0xb0, 0x00

};
static const unsigned char partition_by_boot_lnav_data[] = {
0x78, 0x9c, 0x45, 0x4f, 0x5d, 0x6b, 0xc2, 0x30, 0x14, 0x7d, 0xef, 0xaf, 
0x38, 0xa3, 0x94, 0x2a, 0xcc, 0xfd, 0x80, 0xca, 0x60, 0xd3, 0x66, 0x18, 
0x16, 0xac, 0xb4, 0x71, 0x7d, 0x94, 0x56, 0x33, 0x0d, 0xb3, 0x4d, 0xe9, 
0xcd, 0x9c, 0x05, 0x7f, 0xfc, 0x12, 0xcb, 0xd8, 0x85, 0x3c, 0xdc, 0x93, 
0xf3, 0x75, 0xc3, 0x20, 0x44, 0x9a, 0x61, 0x9d, 0x49, 0xb0, 0x94, 0x4b, 
0xc8, 0x15, 0x2f, 0xf0, 0xc6, 0x05, 0x7b, 0x84, 0xdb, 0x4a, 0x2e, 0x04, 
0x16, 0x0c, 0xd9, 0x07, 0xcb, 0xcb, 0x9c, 0x4b, 0xc9, 0xd6, 0x0f, 0x41, 
0xe8, 0x24, 0x2f, 0x34, 0xb4, 0xa6, 0x23, 0x4d, 0x09, 0xba, 0xaa, 0xb7, 
0xda, 0x6a, 0xd3, 0xce, 0xea, 0x61, 0x56, 0x1b, 0x63, 0xfd, 0xf7, 0x41, 
0xd1, 0xbe, 0xd7, 0x9d, 0x87, 0x13, 0x6c, 0xfe, 0x18, 0xb0, 0x27, 0x85, 
0xb3, 0x39, 0xe2, 0xa2, 0xd5, 0x0f, 0xea, 0x8a, 0xd4, 0x01, 0x0e, 0xf5, 
0x22, 0x34, 0x8a, 0xa8, 0x3a, 0x2a, 0xc2, 0x67, 0x6f, 0x9a, 0x3b, 0x51, 
0xe8, 0xf6, 0xfb, 0x8a, 0x2f, 0xd5, 0xb7, 0xea, 0xfc, 0xe4, 0x52, 0x83, 
0xf9, 0x76, 0x93, 0xbe, 0x4a, 0x06, 0x1a, 0xc8, 0x99, 0xec, 0xdc, 0x0b, 
0xe0, 0xa7, 0x60, 0xd2, 0xbb, 0xee, 0x7c, 0x13, 0x3c, 0x23, 0x5e, 0x38, 
0xbf, 0x04, 0x31, 0x6e, 0xb7, 0x3b, 0x6c, 0x75, 0xa3, 0x46, 0x62, 0xb9, 
0x62, 0x39, 0x1b, 0x31, 0x75, 0xb5, 0x10, 0xfc, 0x9d, 0x21, 0x8e, 0xc6, 
0x84, 0x24, 0x1a, 0xf3, 0x2e, 0xaa, 0x27, 0x57, 0x35, 0x8a, 0xe7, 0x2e, 
0xb0, 0x60, 0x82, 0x2d, 0x25, 0xe2, 0x65, 0xaf, 0x2a, 0xeb, 0xca, 0xde, 
0x3d, 0xf7, 0xa7, 0xaa, 0x75, 0x45, 0x27, 0x53, 0xbf, 0xc4, 0xff, 0xf7, 
0xd3, 0x84, 0xa6, 0x4e, 0xf5, 0x0b, 0x5e, 0xc7, 0x69, 0xff, 0x00

};
static const unsigned char piper_url_handler_lnav_data[] = {
0x78, 0x9c, 0x2d, 0x8d, 0x41, 0x0b, 0x82, 0x30, 0x1c, 0xc5, 0xef, 0xfb, 
0x14, 0x7f, 0x50, 0x50, 0x23, 0x1b, 0x5d, 0xed, 0x92, 0x94, 0x81, 0x64, 
0x09, 0xb3, 0xec, 0x28, 0x92, 0x43, 0x17, 0x63, 0x1b, 0xdb, 0x3c, 0x44, 
0xf4, 0xdd, 0x53, 0xd7, 0xed, 0xf1, 0xde, 0x8f, 0xdf, 0xf3, 0x90, 0x07, 
0x7b, 0xf3, 0x16, 0x52, 0x19, 0x66, 0x12, 0x50, 0x4c, 0x51, 0x1d, 0x8f, 
0x9a, 0xc7, 0x43, 0x2b, 0x3a, 0x4e, 0xf5, 0x3c, 0x77, 0xd4, 0x3c, 0x35, 
0x53, 0x96, 0x49, 0x91, 0x40, 0x2e, 0x2c, 0xd5, 0xa2, 0xe5, 0xe0, 0x3a, 
0xb0, 0x12, 0x1c, 0x0a, 0x52, 0x51, 0xc1, 0x44, 0xef, 0x1c, 0x70, 0x27, 
0x85, 0x41, 0x1e, 0x42, 0xbb, 0x2a, 0x2b, 0xb2, 0xc3, 0x0d, 0x5e, 0x3d, 
0xb5, 0xe1, 0x24, 0x5e, 0x43, 0x80, 0x07, 0x69, 0x6c, 0x10, 0x41, 0x5a, 
0xc1, 0x38, 0x47, 0x38, 0x91, 0xf2, 0x02, 0xe1, 0x1f, 0x54, 0xad, 0x36, 
0xb4, 0x99, 0xc8, 0xd0, 0xdf, 0x3a, 0x46, 0xf3, 0x08, 0xa1, 0x64, 0xd6, 
0x83, 0xff, 0x29, 0xae, 0x69, 0xdd, 0x3c, 0x4a, 0x72, 0x6e, 0x8e, 0x39, 
0xf9, 0xe2, 0xe5, 0x0c, 0xfb, 0x8b, 0x07, 0xcb, 0xd1, 0x6e, 0x56, 0xe8, 
0x07, 0x1c, 0xbc, 0x44, 0xa2, 0x00

};
static const unsigned char rename_stdin_lnav_data[] = {
0x78, 0x9c, 0x6d, 0x51, 0x4b, 0x6b, 0x02, 0x31, 0x10, 0xbe, 0xef, 0xaf, 
0xf8, 0xc0, 0x42, 0xf4, 0x20, 0xd4, 0xab, 0xad, 0xa5, 0xd2, 0x6e, 0x1f, 
0x60, 0x1f, 0xb8, 0x4a, 0x8f, 0x92, 0x6e, 0x66, 0x75, 0xc0, 0x9d, 0x2c, 
0x49, 0xd4, 0x0a, 0xfe, 0xf8, 0x6e, 0xd6, 0x15, 0x4b, 0x31, 0xa7, 0x81, 
0x7c, 0xcf, 0x99, 0x4e, 0xd2, 0xc1, 0xbd, 0xdf, 0x8b, 0xad, 0x3c, 0xfb, 
0x21, 0x1c, 0x89, 0x2e, 0xa9, 0xef, 0x83, 0x61, 0xc1, 0x6d, 0x9c, 0xef, 
0x22, 0xc0, 0x90, 0xcf, 0x1d, 0x57, 0x81, 0xad, 0x0c, 0xf1, 0xcc, 0x5b, 
0x82, 0x86, 0xdf, 0x97, 0xdf, 0x76, 0xcd, 0x39, 0x22, 0x0a, 0xc1, 0x22, 
0xac, 0x08, 0x3e, 0x68, 0x31, 0xda, 0x99, 0x3e, 0x4b, 0xb5, 0x09, 0x28, 
0x78, 0x4d, 0x49, 0x27, 0x49, 0x6e, 0xb2, 0x74, 0x92, 0x3e, 0xcc, 0xe0, 
0x34, 0x7b, 0x5a, 0x90, 0x73, 0xd6, 0x75, 0x15, 0xfd, 0x54, 0x94, 0x07, 
0x96, 0x65, 0xc3, 0x14, 0xda, 0x1d, 0x95, 0x0a, 0xeb, 0x70, 0xf4, 0xd7, 
0xbe, 0xf9, 0x29, 0xd8, 0xf9, 0x00, 0xed, 0x96, 0x9b, 0x92, 0x24, 0xa8, 
0x1e, 0xbe, 0x5e, 0xd2, 0x69, 0x8a, 0xab, 0x01, 0x5e, 0x33, 0xbc, 0xcf, 
0x27, 0x93, 0xcb, 0xf2, 0x62, 0x61, 0x74, 0xd0, 0xd8, 0xd5, 0x32, 0x8e, 
0x0c, 0xbb, 0xda, 0x8c, 0x4c, 0x0c, 0xba, 0x16, 0xbd, 0x55, 0xca, 0xff, 
0x0b, 0xab, 0x7a, 0x09, 0xda, 0x77, 0x34, 0xe8, 0xb6, 0xaa, 0xb9, 0xdd, 
0x48, 0xe8, 0x0e, 0x7a, 0x78, 0x9a, 0x7e, 0xbc, 0x35, 0xe4, 0x45, 0xec, 
0xd5, 0xa2, 0xe2, 0x58, 0xe9, 0xb0, 0x1a, 0xa9, 0x26, 0x74, 0x1d, 0x6f, 
0x84, 0xeb, 0xba, 0xf1, 0xfc, 0xf3, 0x71, 0x3c, 0x4b, 0xff, 0xc0, 0xb3, 
0x74, 0x76, 0x06, 0xd7, 0xe1, 0x2f, 0xd3, 0xcf, 0xbb, 0x52, 0x2c, 0x85, 
0x3d, 0x5d, 0xc4, 0xb4, 0x2b, 0xa9, 0xd3, 0x2b, 0x1c, 0x0e, 0xb1, 0xfc, 
0x38, 0x43, 0xe9, 0x97, 0xc9, 0x2f, 0x0f, 0xce, 0x91, 0x5c, 0x00

};
static const unsigned char search_for_lnav_data[] = {
0x78, 0x9c, 0x45, 0x8c, 0x41, 0x0b, 0x82, 0x30, 0x00, 0x46, 0xef, 0xfb, 
0x15, 0x1f, 0xd8, 0xa1, 0x0e, 0x05, 0x5d, 0x8d, 0xa0, 0x72, 0x8b, 0x04, 
0xc5, 0x98, 0x86, 0x74, 0x1a, 0xc3, 0x96, 0x8e, 0x6c, 0xca, 0x36, 0x8c, 
0xfe, 0x7d, 0x46, 0x45, 0xdf, 0xf1, 0xf1, 0xde, 0x17, 0x90, 0x00, 0x1b, 
0xf7, 0x34, 0x5d, 0xef, 0xb4, 0x0b, 0xe1, 0x94, 0xb4, 0x55, 0x33, 0xbf, 
0x76, 0xf6, 0xcd, 0x2f, 0xca, 0x55, 0x56, 0xf7, 0x5e, 0x77, 0x26, 0x44, 
0xee, 0xa5, 0xf5, 0x90, 0x5f, 0x05, 0xa3, 0x02, 0xdf, 0x28, 0xd4, 0x7a, 
0x50, 0x06, 0xce, 0x5b, 0x6d, 0xea, 0x05, 0x09, 0x08, 0x59, 0x9d, 0x8e, 
0x74, 0x5b, 0x30, 0xb4, 0x46, 0x0e, 0x62, 0xd0, 0xea, 0xe1, 0x90, 0xb3, 
0xe2, 0x97, 0xad, 0x31, 0x11, 0x42, 0xb6, 0xad, 0x10, 0x28, 0x0f, 0x8c, 
0x33, 0x18, 0x79, 0x57, 0x23, 0x9d, 0x12, 0x8c, 0xcb, 0x59, 0xc2, 0xa2, 
0xe2, 0xc3, 0xf6, 0x3c, 0x4b, 0xff, 0x27, 0xc2, 0x79, 0x59, 0xdd, 0x90, 
0x71, 0xca, 0x38, 0x76, 0x67, 0xf0, 0xac, 0x8c, 0x29, 0x28, 0xcb, 0x23, 
0x24, 0x71, 0x1a, 0x17, 0x58, 0xce, 0xc8, 0x0b, 0x94, 0x64, 0x3f, 0xc6, 0x00

};
struct bin_src_file lnav_scripts[9] = {
    { "dhclient-summary.lnav", dhclient_summary_lnav_data, 463, 906 },
    { "docker-url-handler.lnav", docker_url_handler_lnav_data, 632, 1951 },
    { "journald-url-handler.lnav", journald_url_handler_lnav_data, 356, 772 },
    { "lnav-copy-text.lnav", lnav_copy_text_lnav_data, 223, 307 },
    { "lnav-pop-view.lnav", lnav_pop_view_lnav_data, 368, 834 },
    { "partition-by-boot.lnav", partition_by_boot_lnav_data, 250, 338 },
    { "piper-url-handler.lnav", piper_url_handler_lnav_data, 173, 211 },
    { "rename-stdin.lnav", rename_stdin_lnav_data, 274, 449 },
    { "search-for.lnav", search_for_lnav_data, 168, 204 },
};
