
  struct AvailableComponent {
    /// The name of the component.
    const char *Name;

    /// The name of the library for this component (or NULL).
    const char *Library;

    /// Whether the component is installed.
    bool IsInstalled;

    /// The list of libraries required when linking this component.
    const char *RequiredLibraries[185];
  } AvailableComponents[185] = {
  { "aarch64", nullptr, true, {"aarch64codegen", "aarch64asmparser", "aarch64disassembler", "aarch64desc", "aarch64info", "aarch64utils"} },
{ "aarch64asmparser", "LLVMAArch64AsmParser", true, {"aarch64desc", "aarch64info", "aarch64utils", "mc", "mcparser", "support"} },
{ "aarch64codegen", "LLVMAArch64CodeGen", true, {"aarch64desc", "aarch64info", "aarch64utils", "analysis", "asmprinter", "codegen", "core", "mc", "scalaropts", "selectiondag", "support", "target", "transformutils", "globalisel", "cfguard"} },
{ "aarch64desc", "LLVMAArch64Desc", true, {"aarch64info", "aarch64utils", "mc", "binaryformat", "support"} },
{ "aarch64disassembler", "LLVMAArch64Disassembler", true, {"aarch64desc", "aarch64info", "aarch64utils", "mc", "mcdisassembler", "support"} },
{ "aarch64info", "LLVMAArch64Info", true, {"mc", "support"} },
{ "aarch64utils", "LLVMAArch64Utils", true, {"support"} },
{ "aggressiveinstcombine", "LLVMAggressiveInstCombine", true, {"analysis", "core", "support", "transformutils"} },
{ "all", nullptr, true, {"demangle", "support", "tablegen", "core", "fuzzmutate", "filecheck", "interfacestub", "irreader", "codegen", "selectiondag", "asmprinter", "mirparser", "globalisel", "binaryformat", "bitreader", "bitwriter", "bitstreamreader", "dwarflinker", "extensions", "frontendopenacc", "frontendopenmp", "transformutils", "instrumentation", "aggressiveinstcombine", "instcombine", "scalaropts", "ipo", "vectorize", "objcarcopts", "coroutines", "cfguard", "linker", "analysis", "lto", "mc", "mcparser", "mcdisassembler", "mca", "object", "objectyaml", "option", "remarks", "debuginfodwarf", "debuginfogsym", "debuginfomsf", "debuginfocodeview", "debuginfopdb", "symbolize", "dwp", "executionengine", "interpreter", "jitlink", "mcjit", "orcjit", "orcshared", "orctargetprocess", "runtimedyld", "perfjitevents", "target", "aarch64codegen", "aarch64asmparser", "aarch64disassembler", "aarch64desc", "aarch64info", "aarch64utils", "amdgpucodegen", "amdgpuasmparser", "amdgpudisassembler", "amdgputargetmca", "amdgpudesc", "amdgpuinfo", "amdgpuutils", "armcodegen", "armasmparser", "armdisassembler", "armdesc", "arminfo", "armutils", "avrcodegen", "avrasmparser", "avrdisassembler", "avrdesc", "avrinfo", "bpfcodegen", "bpfasmparser", "bpfdisassembler", "bpfdesc", "bpfinfo", "hexagoncodegen", "hexagonasmparser", "hexagondisassembler", "hexagondesc", "hexagoninfo", "lanaicodegen", "lanaiasmparser", "lanaidisassembler", "lanaidesc", "lanaiinfo", "mipscodegen", "mipsasmparser", "mipsdisassembler", "mipsdesc", "mipsinfo", "msp430codegen", "msp430desc", "msp430info", "msp430asmparser", "msp430disassembler", "nvptxcodegen", "nvptxdesc", "nvptxinfo", "powerpccodegen", "powerpcasmparser", "powerpcdisassembler", "powerpcdesc", "powerpcinfo", "riscvcodegen", "riscvasmparser", "riscvdisassembler", "riscvdesc", "riscvinfo", "sparccodegen", "sparcasmparser", "sparcdisassembler", "sparcdesc", "sparcinfo", "systemzcodegen", "systemzasmparser", "systemzdisassembler", "systemzdesc", "systemzinfo", "vecodegen", "veasmparser", "vedisassembler", "veinfo", "vedesc", "webassemblycodegen", "webassemblyasmparser", "webassemblydisassembler", "webassemblydesc", "webassemblyinfo", "webassemblyutils", "x86codegen", "x86asmparser", "x86disassembler", "x86targetmca", "x86desc", "x86info", "xcorecodegen", "xcoredisassembler", "xcoredesc", "xcoreinfo", "asmparser", "lineeditor", "profiledata", "coverage", "passes", "textapi", "dlltooldriver", "libdriver", "xray", "windowsmanifest", "all-targets", "engine", "native", "nativecodegen", "aarch64", "amdgpu", "arm", "avr", "bpf", "hexagon", "lanai", "mips", "msp430", "nvptx", "powerpc", "riscv", "sparc", "systemz", "ve", "webassembly", "x86", "xcore"} },
{ "all-targets", nullptr, true, {"aarch64", "amdgpu", "arm", "avr", "bpf", "hexagon", "lanai", "mips", "msp430", "nvptx", "powerpc", "riscv", "sparc", "systemz", "ve", "webassembly", "x86", "xcore"} },
{ "amdgpu", nullptr, true, {"amdgpucodegen", "amdgpuasmparser", "amdgpudisassembler", "amdgputargetmca", "amdgpudesc", "amdgpuinfo", "amdgpuutils"} },
{ "amdgpuasmparser", "LLVMAMDGPUAsmParser", true, {"mc", "mcparser", "amdgpudesc", "amdgpuinfo", "amdgpuutils", "support"} },
{ "amdgpucodegen", "LLVMAMDGPUCodeGen", true, {"analysis", "asmprinter", "codegen", "core", "ipo", "mc", "passes", "amdgpudesc", "amdgpuinfo", "amdgpuutils", "scalaropts", "selectiondag", "support", "target", "transformutils", "vectorize", "globalisel", "binaryformat", "mirparser"} },
{ "amdgpudesc", "LLVMAMDGPUDesc", true, {"core", "mc", "amdgpuinfo", "amdgpuutils", "support", "binaryformat"} },
{ "amdgpudisassembler", "LLVMAMDGPUDisassembler", true, {"amdgpudesc", "amdgpuinfo", "amdgpuutils", "mc", "mcdisassembler", "support"} },
{ "amdgpuinfo", "LLVMAMDGPUInfo", true, {"mc", "support"} },
{ "amdgputargetmca", "LLVMAMDGPUTargetMCA", true, {"mc", "mcparser", "amdgpudesc", "amdgpuinfo", "amdgpuutils", "support", "mca"} },
{ "amdgpuutils", "LLVMAMDGPUUtils", true, {"analysis", "core", "mc", "binaryformat", "support"} },
{ "analysis", "LLVMAnalysis", true, {"binaryformat", "core", "object", "profiledata", "support"} },
{ "arm", nullptr, true, {"armcodegen", "armasmparser", "armdisassembler", "armdesc", "arminfo", "armutils"} },
{ "armasmparser", "LLVMARMAsmParser", true, {"armdesc", "arminfo", "mc", "mcparser", "support", "armutils"} },
{ "armcodegen", "LLVMARMCodeGen", true, {"armdesc", "arminfo", "analysis", "asmprinter", "codegen", "core", "ipo", "mc", "scalaropts", "selectiondag", "support", "target", "globalisel", "armutils", "transformutils", "cfguard"} },
{ "armdesc", "LLVMARMDesc", true, {"arminfo", "armutils", "mc", "mcdisassembler", "support", "binaryformat"} },
{ "armdisassembler", "LLVMARMDisassembler", true, {"armdesc", "arminfo", "mcdisassembler", "support", "armutils"} },
{ "arminfo", "LLVMARMInfo", true, {"mc", "support"} },
{ "armutils", "LLVMARMUtils", true, {"support"} },
{ "asmparser", "LLVMAsmParser", true, {"binaryformat", "core", "support"} },
{ "asmprinter", "LLVMAsmPrinter", true, {"analysis", "binaryformat", "codegen", "core", "debuginfocodeview", "debuginfodwarf", "debuginfomsf", "mc", "mcparser", "remarks", "support", "target"} },
{ "avr", nullptr, true, {"avrcodegen", "avrasmparser", "avrdisassembler", "avrdesc", "avrinfo"} },
{ "avrasmparser", "LLVMAVRAsmParser", true, {"mc", "mcparser", "avrdesc", "avrinfo", "support"} },
{ "avrcodegen", "LLVMAVRCodeGen", true, {"asmprinter", "codegen", "core", "mc", "avrdesc", "avrinfo", "selectiondag", "support", "target"} },
{ "avrdesc", "LLVMAVRDesc", true, {"mc", "avrinfo", "support"} },
{ "avrdisassembler", "LLVMAVRDisassembler", true, {"mcdisassembler", "avrinfo", "support"} },
{ "avrinfo", "LLVMAVRInfo", true, {"mc", "support"} },
{ "binaryformat", "LLVMBinaryFormat", true, {"support"} },
{ "bitreader", "LLVMBitReader", true, {"bitstreamreader", "core", "support"} },
{ "bitstreamreader", "LLVMBitstreamReader", true, {"support"} },
{ "bitwriter", "LLVMBitWriter", true, {"analysis", "core", "mc", "object", "support"} },
{ "bpf", nullptr, true, {"bpfcodegen", "bpfasmparser", "bpfdisassembler", "bpfdesc", "bpfinfo"} },
{ "bpfasmparser", "LLVMBPFAsmParser", true, {"mc", "mcparser", "bpfdesc", "bpfinfo", "support"} },
{ "bpfcodegen", "LLVMBPFCodeGen", true, {"analysis", "asmprinter", "codegen", "core", "mc", "bpfdesc", "bpfinfo", "ipo", "scalaropts", "selectiondag", "support", "target", "transformutils"} },
{ "bpfdesc", "LLVMBPFDesc", true, {"mc", "bpfinfo", "support"} },
{ "bpfdisassembler", "LLVMBPFDisassembler", true, {"mcdisassembler", "bpfinfo", "support"} },
{ "bpfinfo", "LLVMBPFInfo", true, {"mc", "support"} },
{ "cfguard", "LLVMCFGuard", true, {"core", "support"} },
{ "codegen", "LLVMCodeGen", true, {"analysis", "bitreader", "bitwriter", "core", "mc", "profiledata", "scalaropts", "support", "target", "transformutils"} },
{ "core", "LLVMCore", true, {"binaryformat", "remarks", "support"} },
{ "coroutines", "LLVMCoroutines", true, {"analysis", "core", "ipo", "scalaropts", "support", "transformutils"} },
{ "coverage", "LLVMCoverage", true, {"core", "object", "profiledata", "support"} },
{ "debuginfocodeview", "LLVMDebugInfoCodeView", true, {"support"} },
{ "debuginfodwarf", "LLVMDebugInfoDWARF", true, {"binaryformat", "object", "mc", "support"} },
{ "debuginfogsym", "LLVMDebugInfoGSYM", true, {"mc", "object", "support", "debuginfodwarf"} },
{ "debuginfomsf", "LLVMDebugInfoMSF", true, {"support"} },
{ "debuginfopdb", "LLVMDebugInfoPDB", true, {"binaryformat", "object", "support", "debuginfocodeview", "debuginfomsf"} },
{ "demangle", "LLVMDemangle", true, {} },
{ "dlltooldriver", "LLVMDlltoolDriver", true, {"object", "option", "support"} },
{ "dwarflinker", "LLVMDWARFLinker", true, {"binaryformat", "debuginfodwarf", "asmprinter", "codegen", "mc", "object", "support"} },
{ "dwp", "LLVMDWP", true, {"debuginfodwarf", "mc", "object", "support", "target"} },
{ "engine", nullptr, true, {"interpreter"} },
{ "executionengine", "LLVMExecutionEngine", true, {"core", "mc", "object", "orctargetprocess", "runtimedyld", "support", "target"} },
{ "extensions", "LLVMExtensions", true, {"support"} },
{ "filecheck", "LLVMFileCheck", true, {} },
{ "frontendopenacc", "LLVMFrontendOpenACC", true, {} },
{ "frontendopenmp", "LLVMFrontendOpenMP", true, {"core", "support", "transformutils", "analysis", "mc", "scalaropts"} },
{ "fuzzmutate", "LLVMFuzzMutate", true, {"analysis", "bitreader", "bitwriter", "core", "scalaropts", "support", "target"} },
{ "globalisel", "LLVMGlobalISel", true, {"analysis", "codegen", "core", "mc", "selectiondag", "support", "target", "transformutils"} },
{ "hexagon", nullptr, true, {"hexagoncodegen", "hexagonasmparser", "hexagondisassembler", "hexagondesc", "hexagoninfo"} },
{ "hexagonasmparser", "LLVMHexagonAsmParser", true, {"mc", "mcparser", "support", "hexagondesc", "hexagoninfo"} },
{ "hexagoncodegen", "LLVMHexagonCodeGen", true, {"analysis", "asmprinter", "codegen", "core", "hexagonasmparser", "hexagondesc", "hexagoninfo", "ipo", "mc", "scalaropts", "selectiondag", "support", "target", "transformutils"} },
{ "hexagondesc", "LLVMHexagonDesc", true, {"hexagoninfo", "mc", "support"} },
{ "hexagondisassembler", "LLVMHexagonDisassembler", true, {"hexagondesc", "hexagoninfo", "mc", "mcdisassembler", "support"} },
{ "hexagoninfo", "LLVMHexagonInfo", true, {"mc", "support"} },
{ "instcombine", "LLVMInstCombine", true, {"analysis", "core", "support", "transformutils"} },
{ "instrumentation", "LLVMInstrumentation", true, {"analysis", "core", "mc", "support", "transformutils", "profiledata"} },
{ "interfacestub", "LLVMInterfaceStub", true, {"binaryformat", "mc", "object", "support"} },
{ "interpreter", "LLVMInterpreter", true, {"codegen", "core", "executionengine", "support"} },
{ "ipo", "LLVMipo", true, {"aggressiveinstcombine", "analysis", "bitreader", "bitwriter", "core", "frontendopenmp", "instcombine", "irreader", "linker", "object", "profiledata", "scalaropts", "support", "transformutils", "vectorize", "instrumentation", "scalaropts"} },
{ "irreader", "LLVMIRReader", true, {"asmparser", "bitreader", "core", "support"} },
{ "jitlink", "LLVMJITLink", true, {"binaryformat", "object", "orctargetprocess", "support"} },
{ "lanai", nullptr, true, {"lanaicodegen", "lanaiasmparser", "lanaidisassembler", "lanaidesc", "lanaiinfo"} },
{ "lanaiasmparser", "LLVMLanaiAsmParser", true, {"mc", "mcparser", "support", "lanaidesc", "lanaiinfo"} },
{ "lanaicodegen", "LLVMLanaiCodeGen", true, {"analysis", "asmprinter", "codegen", "core", "lanaiasmparser", "lanaidesc", "lanaiinfo", "mc", "selectiondag", "support", "target", "transformutils"} },
{ "lanaidesc", "LLVMLanaiDesc", true, {"lanaiinfo", "mc", "mcdisassembler", "support"} },
{ "lanaidisassembler", "LLVMLanaiDisassembler", true, {"lanaidesc", "lanaiinfo", "mc", "mcdisassembler", "support"} },
{ "lanaiinfo", "LLVMLanaiInfo", true, {"mc", "support"} },
{ "libdriver", "LLVMLibDriver", true, {"binaryformat", "bitreader", "object", "option", "support", "binaryformat", "bitreader", "object", "option", "support"} },
{ "lineeditor", "LLVMLineEditor", true, {"support"} },
{ "linker", "LLVMLinker", true, {"core", "object", "support", "transformutils"} },
{ "lto", "LLVMLTO", true, {"aggressiveinstcombine", "analysis", "binaryformat", "bitreader", "bitwriter", "codegen", "core", "extensions", "ipo", "instcombine", "instrumentation", "linker", "mc", "objcarcopts", "object", "passes", "remarks", "scalaropts", "support", "target", "transformutils"} },
{ "mc", "LLVMMC", true, {"support", "binaryformat", "debuginfocodeview"} },
{ "mca", "LLVMMCA", true, {"mc", "support"} },
{ "mcdisassembler", "LLVMMCDisassembler", true, {"mc", "support"} },
{ "mcjit", "LLVMMCJIT", true, {"core", "executionengine", "object", "runtimedyld", "support", "target"} },
{ "mcparser", "LLVMMCParser", true, {"mc", "support"} },
{ "mips", nullptr, true, {"mipscodegen", "mipsasmparser", "mipsdisassembler", "mipsdesc", "mipsinfo"} },
{ "mipsasmparser", "LLVMMipsAsmParser", true, {"mc", "mcparser", "mipsdesc", "mipsinfo", "support"} },
{ "mipscodegen", "LLVMMipsCodeGen", true, {"analysis", "asmprinter", "codegen", "core", "mc", "mipsdesc", "mipsinfo", "selectiondag", "support", "target", "globalisel"} },
{ "mipsdesc", "LLVMMipsDesc", true, {"mc", "mipsinfo", "support"} },
{ "mipsdisassembler", "LLVMMipsDisassembler", true, {"mcdisassembler", "mipsinfo", "support"} },
{ "mipsinfo", "LLVMMipsInfo", true, {"mc", "support"} },
{ "mirparser", "LLVMMIRParser", true, {"asmparser", "binaryformat", "codegen", "core", "mc", "support", "target"} },
{ "msp430", nullptr, true, {"msp430codegen", "msp430desc", "msp430info", "msp430asmparser", "msp430disassembler"} },
{ "msp430asmparser", "LLVMMSP430AsmParser", true, {"mc", "mcparser", "msp430desc", "msp430info", "support"} },
{ "msp430codegen", "LLVMMSP430CodeGen", true, {"asmprinter", "codegen", "core", "mc", "msp430desc", "msp430info", "selectiondag", "support", "target"} },
{ "msp430desc", "LLVMMSP430Desc", true, {"mc", "msp430info", "support"} },
{ "msp430disassembler", "LLVMMSP430Disassembler", true, {"mcdisassembler", "msp430info", "support"} },
{ "msp430info", "LLVMMSP430Info", true, {"mc", "support"} },
{ "native", nullptr, true, {"x86"} },
{ "nativecodegen", nullptr, true, {"x86codegen"} },
{ "nvptx", nullptr, true, {"nvptxcodegen", "nvptxdesc", "nvptxinfo"} },
{ "nvptxcodegen", "LLVMNVPTXCodeGen", true, {"analysis", "asmprinter", "codegen", "core", "ipo", "mc", "nvptxdesc", "nvptxinfo", "scalaropts", "selectiondag", "support", "target", "transformutils", "vectorize"} },
{ "nvptxdesc", "LLVMNVPTXDesc", true, {"mc", "nvptxinfo", "support"} },
{ "nvptxinfo", "LLVMNVPTXInfo", true, {"mc", "support"} },
{ "objcarcopts", "LLVMObjCARCOpts", true, {"analysis", "core", "support", "transformutils"} },
{ "object", "LLVMObject", true, {"bitreader", "core", "mc", "binaryformat", "mcparser", "support", "textapi"} },
{ "objectyaml", "LLVMObjectYAML", true, {"binaryformat", "object", "support", "debuginfocodeview", "mc"} },
{ "option", "LLVMOption", true, {"support"} },
{ "orcjit", "LLVMOrcJIT", true, {"core", "executionengine", "jitlink", "object", "orcshared", "orctargetprocess", "mc", "mcdisassembler", "passes", "runtimedyld", "support", "target", "transformutils"} },
{ "orcshared", "LLVMOrcShared", true, {"support"} },
{ "orctargetprocess", "LLVMOrcTargetProcess", true, {"orcshared", "support"} },
{ "passes", "LLVMPasses", true, {"aggressiveinstcombine", "analysis", "core", "coroutines", "ipo", "instcombine", "objcarcopts", "scalaropts", "support", "target", "transformutils", "vectorize", "instrumentation"} },
{ "perfjitevents", "LLVMPerfJITEvents", true, {"codegen", "core", "debuginfodwarf", "executionengine", "object", "support"} },
{ "powerpc", nullptr, true, {"powerpccodegen", "powerpcasmparser", "powerpcdisassembler", "powerpcdesc", "powerpcinfo"} },
{ "powerpcasmparser", "LLVMPowerPCAsmParser", true, {"mc", "mcparser", "powerpcdesc", "powerpcinfo", "support"} },
{ "powerpccodegen", "LLVMPowerPCCodeGen", true, {"analysis", "asmprinter", "binaryformat", "codegen", "core", "mc", "powerpcdesc", "powerpcinfo", "scalaropts", "selectiondag", "support", "target", "transformutils", "globalisel"} },
{ "powerpcdesc", "LLVMPowerPCDesc", true, {"mc", "powerpcinfo", "support", "binaryformat"} },
{ "powerpcdisassembler", "LLVMPowerPCDisassembler", true, {"mcdisassembler", "powerpcinfo", "support"} },
{ "powerpcinfo", "LLVMPowerPCInfo", true, {"mc", "support"} },
{ "profiledata", "LLVMProfileData", true, {"core", "support", "demangle", "object", "debuginfodwarf"} },
{ "remarks", "LLVMRemarks", true, {"bitstreamreader", "support"} },
{ "riscv", nullptr, true, {"riscvcodegen", "riscvasmparser", "riscvdisassembler", "riscvdesc", "riscvinfo"} },
{ "riscvasmparser", "LLVMRISCVAsmParser", true, {"mc", "mcparser", "riscvdesc", "riscvinfo", "support"} },
{ "riscvcodegen", "LLVMRISCVCodeGen", true, {"analysis", "asmprinter", "core", "codegen", "mc", "riscvdesc", "riscvinfo", "selectiondag", "support", "target", "transformutils", "globalisel"} },
{ "riscvdesc", "LLVMRISCVDesc", true, {"mc", "riscvinfo", "support"} },
{ "riscvdisassembler", "LLVMRISCVDisassembler", true, {"mc", "mcdisassembler", "riscvdesc", "riscvinfo", "support"} },
{ "riscvinfo", "LLVMRISCVInfo", true, {"mc", "support"} },
{ "runtimedyld", "LLVMRuntimeDyld", true, {"core", "mc", "object", "support"} },
{ "scalaropts", "LLVMScalarOpts", true, {"aggressiveinstcombine", "analysis", "core", "instcombine", "support", "transformutils"} },
{ "selectiondag", "LLVMSelectionDAG", true, {"analysis", "codegen", "core", "mc", "support", "target", "transformutils"} },
{ "sparc", nullptr, true, {"sparccodegen", "sparcasmparser", "sparcdisassembler", "sparcdesc", "sparcinfo"} },
{ "sparcasmparser", "LLVMSparcAsmParser", true, {"mc", "mcparser", "sparcdesc", "sparcinfo", "support"} },
{ "sparccodegen", "LLVMSparcCodeGen", true, {"asmprinter", "codegen", "core", "mc", "selectiondag", "sparcdesc", "sparcinfo", "support", "target"} },
{ "sparcdesc", "LLVMSparcDesc", true, {"mc", "sparcinfo", "support"} },
{ "sparcdisassembler", "LLVMSparcDisassembler", true, {"mcdisassembler", "sparcinfo", "support"} },
{ "sparcinfo", "LLVMSparcInfo", true, {"mc", "support"} },
{ "support", "LLVMSupport", true, {"demangle"} },
{ "symbolize", "LLVMSymbolize", true, {"debuginfodwarf", "debuginfopdb", "object", "support", "demangle"} },
{ "systemz", nullptr, true, {"systemzcodegen", "systemzasmparser", "systemzdisassembler", "systemzdesc", "systemzinfo"} },
{ "systemzasmparser", "LLVMSystemZAsmParser", true, {"mc", "mcparser", "support", "systemzdesc", "systemzinfo"} },
{ "systemzcodegen", "LLVMSystemZCodeGen", true, {"analysis", "asmprinter", "codegen", "core", "mc", "scalaropts", "selectiondag", "support", "systemzdesc", "systemzinfo", "target"} },
{ "systemzdesc", "LLVMSystemZDesc", true, {"mc", "support", "systemzinfo"} },
{ "systemzdisassembler", "LLVMSystemZDisassembler", true, {"mc", "mcdisassembler", "support", "systemzdesc", "systemzinfo"} },
{ "systemzinfo", "LLVMSystemZInfo", true, {"mc", "support"} },
{ "tablegen", "LLVMTableGen", true, {"support"} },
{ "target", "LLVMTarget", true, {"analysis", "core", "mc", "support"} },
{ "textapi", "LLVMTextAPI", true, {"support", "binaryformat"} },
{ "transformutils", "LLVMTransformUtils", true, {"analysis", "core", "support"} },
{ "ve", nullptr, true, {"vecodegen", "veasmparser", "vedisassembler", "veinfo", "vedesc"} },
{ "veasmparser", "LLVMVEAsmParser", true, {"mc", "mcparser", "vedesc", "veinfo", "support"} },
{ "vecodegen", "LLVMVECodeGen", true, {"analysis", "asmprinter", "codegen", "core", "mc", "selectiondag", "vedesc", "veinfo", "support", "target"} },
{ "vectorize", "LLVMVectorize", true, {"analysis", "core", "support", "transformutils"} },
{ "vedesc", "LLVMVEDesc", true, {"mc", "veinfo", "support"} },
{ "vedisassembler", "LLVMVEDisassembler", true, {"mcdisassembler", "veinfo", "support"} },
{ "veinfo", "LLVMVEInfo", true, {"mc", "support"} },
{ "webassembly", nullptr, true, {"webassemblycodegen", "webassemblyasmparser", "webassemblydisassembler", "webassemblydesc", "webassemblyinfo", "webassemblyutils"} },
{ "webassemblyasmparser", "LLVMWebAssemblyAsmParser", true, {"mc", "mcparser", "webassemblyinfo", "webassemblyutils", "support"} },
{ "webassemblycodegen", "LLVMWebAssemblyCodeGen", true, {"analysis", "asmprinter", "binaryformat", "codegen", "core", "mc", "scalaropts", "selectiondag", "support", "target", "transformutils", "webassemblydesc", "webassemblyinfo", "webassemblyutils"} },
{ "webassemblydesc", "LLVMWebAssemblyDesc", true, {"mc", "support", "webassemblyinfo", "webassemblyutils"} },
{ "webassemblydisassembler", "LLVMWebAssemblyDisassembler", true, {"webassemblydesc", "mcdisassembler", "webassemblyinfo", "webassemblyutils", "support", "mc"} },
{ "webassemblyinfo", "LLVMWebAssemblyInfo", true, {"mc", "support"} },
{ "webassemblyutils", "LLVMWebAssemblyUtils", true, {"codegen", "core", "mc", "support"} },
{ "windowsmanifest", "LLVMWindowsManifest", true, {"support"} },
{ "x86", nullptr, true, {"x86codegen", "x86asmparser", "x86disassembler", "x86targetmca", "x86desc", "x86info"} },
{ "x86asmparser", "LLVMX86AsmParser", true, {"mc", "mcparser", "support", "x86desc", "x86info"} },
{ "x86codegen", "LLVMX86CodeGen", true, {"analysis", "asmprinter", "codegen", "core", "instrumentation", "mc", "selectiondag", "support", "target", "transformutils", "x86desc", "x86info", "globalisel", "profiledata", "cfguard"} },
{ "x86desc", "LLVMX86Desc", true, {"mc", "mcdisassembler", "support", "x86info", "binaryformat"} },
{ "x86disassembler", "LLVMX86Disassembler", true, {"mcdisassembler", "support", "x86info"} },
{ "x86info", "LLVMX86Info", true, {"mc", "support"} },
{ "x86targetmca", "LLVMX86TargetMCA", true, {"mc", "mcparser", "x86desc", "x86info", "support", "mca"} },
{ "xcore", nullptr, true, {"xcorecodegen", "xcoredisassembler", "xcoredesc", "xcoreinfo"} },
{ "xcorecodegen", "LLVMXCoreCodeGen", true, {"analysis", "asmprinter", "codegen", "core", "mc", "selectiondag", "support", "target", "transformutils", "xcoredesc", "xcoreinfo"} },
{ "xcoredesc", "LLVMXCoreDesc", true, {"mc", "support", "xcoreinfo"} },
{ "xcoredisassembler", "LLVMXCoreDisassembler", true, {"mcdisassembler", "support", "xcoreinfo"} },
{ "xcoreinfo", "LLVMXCoreInfo", true, {"mc", "support"} },
{ "xray", "LLVMXRay", true, {"support", "object"} },
};