/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Subtarget Enumeration Source Fragment                                      *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_SUBTARGETINFO_ENUM
#undef GET_SUBTARGETINFO_ENUM

namespace llvm {
namespace X86 {
enum {
  Feature3DNow = 0,
  Feature3DNowA = 1,
  Feature64Bit = 2,
  FeatureADX = 3,
  FeatureAES = 4,
  FeatureAMXBF16 = 5,
  FeatureAMXINT8 = 6,
  FeatureAMXTILE = 7,
  FeatureAVX = 8,
  FeatureAVX2 = 9,
  FeatureAVX512 = 10,
  FeatureAVXVNNI = 11,
  FeatureBF16 = 12,
  FeatureBITALG = 13,
  FeatureBMI = 14,
  FeatureBMI2 = 15,
  FeatureBWI = 16,
  FeatureCDI = 17,
  FeatureCLDEMOTE = 18,
  FeatureCLFLUSHOPT = 19,
  FeatureCLWB = 20,
  FeatureCLZERO = 21,
  FeatureCMOV = 22,
  FeatureCMPXCHG8B = 23,
  FeatureCMPXCHG16B = 24,
  FeatureCRC32 = 25,
  FeatureDQI = 26,
  FeatureENQCMD = 27,
  FeatureERI = 28,
  FeatureERMSB = 29,
  FeatureF16C = 30,
  FeatureFMA = 31,
  FeatureFMA4 = 32,
  FeatureFP16 = 33,
  FeatureFSGSBase = 34,
  FeatureFSRM = 35,
  FeatureFXSR = 36,
  FeatureGFNI = 37,
  FeatureHRESET = 38,
  FeatureIFMA = 39,
  FeatureINVPCID = 40,
  FeatureKL = 41,
  FeatureLAHFSAHF = 42,
  FeatureLVIControlFlowIntegrity = 43,
  FeatureLVILoadHardening = 44,
  FeatureLWP = 45,
  FeatureLZCNT = 46,
  FeatureMMX = 47,
  FeatureMOVBE = 48,
  FeatureMOVDIR64B = 49,
  FeatureMOVDIRI = 50,
  FeatureMWAITX = 51,
  FeatureNOPL = 52,
  FeaturePCLMUL = 53,
  FeaturePCONFIG = 54,
  FeaturePFI = 55,
  FeaturePKU = 56,
  FeaturePOPCNT = 57,
  FeaturePREFETCHWT1 = 58,
  FeaturePRFCHW = 59,
  FeaturePTWRITE = 60,
  FeatureRDPID = 61,
  FeatureRDRAND = 62,
  FeatureRDSEED = 63,
  FeatureRTM = 64,
  FeatureRetpoline = 65,
  FeatureRetpolineExternalThunk = 66,
  FeatureRetpolineIndirectBranches = 67,
  FeatureRetpolineIndirectCalls = 68,
  FeatureSERIALIZE = 69,
  FeatureSGX = 70,
  FeatureSHA = 71,
  FeatureSHSTK = 72,
  FeatureSSE1 = 73,
  FeatureSSE2 = 74,
  FeatureSSE3 = 75,
  FeatureSSE4A = 76,
  FeatureSSE41 = 77,
  FeatureSSE42 = 78,
  FeatureSSEUnalignedMem = 79,
  FeatureSSSE3 = 80,
  FeatureSoftFloat = 81,
  FeatureSpeculativeExecutionSideEffectSuppression = 82,
  FeatureTBM = 83,
  FeatureTSXLDTRK = 84,
  FeatureTaggedGlobals = 85,
  FeatureUINTR = 86,
  FeatureUseAA = 87,
  FeatureVAES = 88,
  FeatureVBMI = 89,
  FeatureVBMI2 = 90,
  FeatureVLX = 91,
  FeatureVNNI = 92,
  FeatureVP2INTERSECT = 93,
  FeatureVPCLMULQDQ = 94,
  FeatureVPOPCNTDQ = 95,
  FeatureWAITPKG = 96,
  FeatureWBNOINVD = 97,
  FeatureWIDEKL = 98,
  FeatureX87 = 99,
  FeatureXOP = 100,
  FeatureXSAVE = 101,
  FeatureXSAVEC = 102,
  FeatureXSAVEOPT = 103,
  FeatureXSAVES = 104,
  Mode16Bit = 105,
  Mode32Bit = 106,
  Mode64Bit = 107,
  ProcIntelAtom = 108,
  TuningBranchFusion = 109,
  TuningFast7ByteNOP = 110,
  TuningFast11ByteNOP = 111,
  TuningFast15ByteNOP = 112,
  TuningFastBEXTR = 113,
  TuningFastGather = 114,
  TuningFastHorizontalOps = 115,
  TuningFastLZCNT = 116,
  TuningFastMOVBE = 117,
  TuningFastSHLDRotate = 118,
  TuningFastScalarFSQRT = 119,
  TuningFastScalarShiftMasks = 120,
  TuningFastVariableCrossLaneShuffle = 121,
  TuningFastVariablePerLaneShuffle = 122,
  TuningFastVectorFSQRT = 123,
  TuningFastVectorShiftMasks = 124,
  TuningInsertVZEROUPPER = 125,
  TuningLEAForSP = 126,
  TuningLEAUsesAG = 127,
  TuningLZCNTFalseDeps = 128,
  TuningMacroFusion = 129,
  TuningPOPCNTFalseDeps = 130,
  TuningPadShortFunctions = 131,
  TuningPrefer128Bit = 132,
  TuningPrefer256Bit = 133,
  TuningPreferMaskRegisters = 134,
  TuningSlow3OpsLEA = 135,
  TuningSlowDivide32 = 136,
  TuningSlowDivide64 = 137,
  TuningSlowIncDec = 138,
  TuningSlowLEA = 139,
  TuningSlowPMADDWD = 140,
  TuningSlowPMULLD = 141,
  TuningSlowSHLD = 142,
  TuningSlowTwoMemOps = 143,
  TuningSlowUAMem16 = 144,
  TuningSlowUAMem32 = 145,
  TuningUseGLMDivSqrtCosts = 146,
  TuningUseSLMArithCosts = 147,
  NumSubtargetFeatures = 148
};
} // end namespace X86
} // end namespace llvm

#endif // GET_SUBTARGETINFO_ENUM


#ifdef GET_SUBTARGETINFO_MC_DESC
#undef GET_SUBTARGETINFO_MC_DESC

namespace llvm {
// Sorted (by key) array of values for CPU features.
extern const llvm::SubtargetFeatureKV X86FeatureKV[] = {
  { "16bit-mode", "16-bit mode (i8086)", X86::Mode16Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "32bit-mode", "32-bit mode (80386)", X86::Mode32Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "3dnow", "Enable 3DNow! instructions", X86::Feature3DNow, { { { 0x800000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "3dnowa", "Enable 3DNow! Athlon instructions", X86::Feature3DNowA, { { { 0x1ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "64bit", "Support 64-bit instructions", X86::Feature64Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "64bit-mode", "64-bit mode (x86_64)", X86::Mode64Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "adx", "Support ADX instructions", X86::FeatureADX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "aes", "Enable AES instructions", X86::FeatureAES, { { { 0x0ULL, 0x400ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-bf16", "Support AMX-BF16 instructions", X86::FeatureAMXBF16, { { { 0x80ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-int8", "Support AMX-INT8 instructions", X86::FeatureAMXINT8, { { { 0x80ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-tile", "Support AMX-TILE instructions", X86::FeatureAMXTILE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx", "Enable AVX instructions", X86::FeatureAVX, { { { 0x0ULL, 0x4000ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx2", "Enable AVX2 instructions", X86::FeatureAVX2, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bf16", "Support bfloat16 floating point", X86::FeatureBF16, { { { 0x10000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bitalg", "Enable AVX-512 Bit Algorithms", X86::FeatureBITALG, { { { 0x10000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bw", "Enable AVX-512 Byte and Word Instructions", X86::FeatureBWI, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512cd", "Enable AVX-512 Conflict Detection Instructions", X86::FeatureCDI, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512dq", "Enable AVX-512 Doubleword and Quadword Instructions", X86::FeatureDQI, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512er", "Enable AVX-512 Exponential and Reciprocal Instructions", X86::FeatureERI, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512f", "Enable AVX-512 instructions", X86::FeatureAVX512, { { { 0xc0000200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512fp16", "Support 16-bit floating point", X86::FeatureFP16, { { { 0x4010000ULL, 0x8000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512ifma", "Enable AVX-512 Integer Fused Multiple-Add", X86::FeatureIFMA, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512pf", "Enable AVX-512 PreFetch Instructions", X86::FeaturePFI, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vbmi", "Enable AVX-512 Vector Byte Manipulation Instructions", X86::FeatureVBMI, { { { 0x10000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vbmi2", "Enable AVX-512 further Vector Byte Manipulation Instructions", X86::FeatureVBMI2, { { { 0x10000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vl", "Enable AVX-512 Vector Length eXtensions", X86::FeatureVLX, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vnni", "Enable AVX-512 Vector Neural Network Instructions", X86::FeatureVNNI, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vp2intersect", "Enable AVX-512 vp2intersect", X86::FeatureVP2INTERSECT, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vpopcntdq", "Enable AVX-512 Population Count Instructions", X86::FeatureVPOPCNTDQ, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxvnni", "Support AVX_VNNI encoding", X86::FeatureAVXVNNI, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "bmi", "Support BMI instructions", X86::FeatureBMI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "bmi2", "Support BMI2 instructions", X86::FeatureBMI2, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "branchfusion", "CMP/TEST can be fused with conditional branches", X86::TuningBranchFusion, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cldemote", "Enable Cache Demote", X86::FeatureCLDEMOTE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clflushopt", "Flush A Cache Line Optimized", X86::FeatureCLFLUSHOPT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clwb", "Cache Line Write Back", X86::FeatureCLWB, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clzero", "Enable Cache Line Zero", X86::FeatureCLZERO, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cmov", "Enable conditional move instructions", X86::FeatureCMOV, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "crc32", "Enable SSE 4.2 CRC32 instruction", X86::FeatureCRC32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cx16", "64-bit with cmpxchg16b", X86::FeatureCMPXCHG16B, { { { 0x800000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cx8", "Support CMPXCHG8B instructions", X86::FeatureCMPXCHG8B, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "enqcmd", "Has ENQCMD instructions", X86::FeatureENQCMD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ermsb", "REP MOVS/STOS are fast", X86::FeatureERMSB, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "f16c", "Support 16-bit floating point conversion instructions", X86::FeatureF16C, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-lzcnt-tzcnt", "LZCNT/TZCNT have a false dependency on dest register", X86::TuningLZCNTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-popcnt", "POPCNT has a false dependency on dest register", X86::TuningPOPCNTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-11bytenop", "Target can quickly decode up to 11 byte NOPs", X86::TuningFast11ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-15bytenop", "Target can quickly decode up to 15 byte NOPs", X86::TuningFast15ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-7bytenop", "Target can quickly decode up to 7 byte NOPs", X86::TuningFast7ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-bextr", "Indicates that the BEXTR instruction is implemented as a single uop with good throughput", X86::TuningFastBEXTR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-gather", "Indicates if gather is reasonably fast", X86::TuningFastGather, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-hops", "Prefer horizontal vector math instructions (haddp, phsub, etc.) over normal vector instructions with shuffles", X86::TuningFastHorizontalOps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-lzcnt", "LZCNT instructions are as fast as most simple integer ops", X86::TuningFastLZCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-movbe", "Prefer a movbe over a single-use load + bswap / single-use bswap + store", X86::TuningFastMOVBE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-scalar-fsqrt", "Scalar SQRT is fast (disable Newton-Raphson)", X86::TuningFastScalarFSQRT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-scalar-shift-masks", "Prefer a left/right scalar logical shift pair over a shift+and pair", X86::TuningFastScalarShiftMasks, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-shld-rotate", "SHLD can be used as a faster rotate", X86::TuningFastSHLDRotate, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-variable-crosslane-shuffle", "Cross-lane shuffles with variable masks are fast", X86::TuningFastVariableCrossLaneShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-variable-perlane-shuffle", "Per-lane shuffles with variable masks are fast", X86::TuningFastVariablePerLaneShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-vector-fsqrt", "Vector SQRT is fast (disable Newton-Raphson)", X86::TuningFastVectorFSQRT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-vector-shift-masks", "Prefer a left/right vector logical shift pair over a shift+and pair", X86::TuningFastVectorShiftMasks, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fma", "Enable three-operand fused multiple-add", X86::FeatureFMA, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fma4", "Enable four-operand fused multiple-add", X86::FeatureFMA4, { { { 0x100ULL, 0x1000ULL, 0x0ULL, 0x0ULL, } } } },
  { "fsgsbase", "Support FS/GS Base instructions", X86::FeatureFSGSBase, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fsrm", "REP MOVSB of short lengths is faster", X86::FeatureFSRM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fxsr", "Support fxsave/fxrestore instructions", X86::FeatureFXSR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "gfni", "Enable Galois Field Arithmetic Instructions", X86::FeatureGFNI, { { { 0x0ULL, 0x400ULL, 0x0ULL, 0x0ULL, } } } },
  { "hreset", "Has hreset instruction", X86::FeatureHRESET, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "idivl-to-divb", "Use 8-bit divide for positive values less than 256", X86::TuningSlowDivide32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "idivq-to-divl", "Use 32-bit divide for positive values less than 2^32", X86::TuningSlowDivide64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "invpcid", "Invalidate Process-Context Identifier", X86::FeatureINVPCID, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "kl", "Support Key Locker kl Instructions", X86::FeatureKL, { { { 0x0ULL, 0x400ULL, 0x0ULL, 0x0ULL, } } } },
  { "lea-sp", "Use LEA for adjusting the stack pointer", X86::TuningLEAForSP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lea-uses-ag", "LEA instruction needs inputs at AG stage", X86::TuningLEAUsesAG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lvi-cfi", "Prevent indirect calls/branches from using a memory operand, and precede all indirect calls/branches from a register with an LFENCE instruction to serialize control flow. Also decompose RET instructions into a POP+LFENCE+JMP sequence.", X86::FeatureLVIControlFlowIntegrity, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lvi-load-hardening", "Insert LFENCE instructions to prevent data speculatively injected into loads from being used maliciously.", X86::FeatureLVILoadHardening, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lwp", "Enable LWP instructions", X86::FeatureLWP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lzcnt", "Support LZCNT instruction", X86::FeatureLZCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "macrofusion", "Various instructions can be fused with conditional branches", X86::TuningMacroFusion, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "mmx", "Enable MMX instructions", X86::FeatureMMX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movbe", "Support MOVBE instruction", X86::FeatureMOVBE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movdir64b", "Support movdir64b instruction", X86::FeatureMOVDIR64B, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movdiri", "Support movdiri instruction", X86::FeatureMOVDIRI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "mwaitx", "Enable MONITORX/MWAITX timer functionality", X86::FeatureMWAITX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "nopl", "Enable NOPL instruction", X86::FeatureNOPL, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pad-short-functions", "Pad short functions", X86::TuningPadShortFunctions, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pclmul", "Enable packed carry-less multiplication instructions", X86::FeaturePCLMUL, { { { 0x0ULL, 0x400ULL, 0x0ULL, 0x0ULL, } } } },
  { "pconfig", "platform configuration instruction", X86::FeaturePCONFIG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pku", "Enable protection keys", X86::FeaturePKU, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "popcnt", "Support POPCNT instruction", X86::FeaturePOPCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-128-bit", "Prefer 128-bit AVX instructions", X86::TuningPrefer128Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-256-bit", "Prefer 256-bit AVX instructions", X86::TuningPrefer256Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-mask-registers", "Prefer AVX512 mask registers over PTEST/MOVMSK", X86::TuningPreferMaskRegisters, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefetchwt1", "Prefetch with Intent to Write and T1 Hint", X86::FeaturePREFETCHWT1, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prfchw", "Support PRFCHW instructions", X86::FeaturePRFCHW, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ptwrite", "Support ptwrite instruction", X86::FeaturePTWRITE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdpid", "Support RDPID instructions", X86::FeatureRDPID, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdrnd", "Support RDRAND instruction", X86::FeatureRDRAND, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdseed", "Support RDSEED instruction", X86::FeatureRDSEED, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline", "Remove speculation of indirect branches from the generated code, either by avoiding them entirely or lowering them with a speculation blocking construct", X86::FeatureRetpoline, { { { 0x0ULL, 0x18ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-external-thunk", "When lowering an indirect call or branch using a `retpoline`, rely on the specified user provided thunk rather than emitting one ourselves. Only has effect when combined with some other retpoline feature", X86::FeatureRetpolineExternalThunk, { { { 0x0ULL, 0x10ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-indirect-branches", "Remove speculation of indirect branches from the generated code", X86::FeatureRetpolineIndirectBranches, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-indirect-calls", "Remove speculation of indirect calls from the generated code", X86::FeatureRetpolineIndirectCalls, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rtm", "Support RTM instructions", X86::FeatureRTM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sahf", "Support LAHF and SAHF instructions in 64-bit mode", X86::FeatureLAHFSAHF, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "serialize", "Has serialize instruction", X86::FeatureSERIALIZE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "seses", "Prevent speculative execution side channel timing attacks by inserting a speculation barrier before memory reads, memory writes, and conditional branches. Implies LVI Control Flow integrity.", X86::FeatureSpeculativeExecutionSideEffectSuppression, { { { 0x80000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sgx", "Enable Software Guard Extensions", X86::FeatureSGX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sha", "Enable SHA instructions", X86::FeatureSHA, { { { 0x0ULL, 0x400ULL, 0x0ULL, 0x0ULL, } } } },
  { "shstk", "Support CET Shadow-Stack instructions", X86::FeatureSHSTK, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-3ops-lea", "LEA instruction with 3 ops or certain registers is slow", X86::TuningSlow3OpsLEA, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-incdec", "INC and DEC instructions are slower than ADD and SUB", X86::TuningSlowIncDec, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-lea", "LEA instruction with certain arguments is slow", X86::TuningSlowLEA, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-pmaddwd", "PMADDWD is slower than PMULLD", X86::TuningSlowPMADDWD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-pmulld", "PMULLD instruction is slow", X86::TuningSlowPMULLD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-shld", "SHLD instruction is slow", X86::TuningSlowSHLD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-two-mem-ops", "Two memory operand instructions are slow", X86::TuningSlowTwoMemOps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-unaligned-mem-16", "Slow unaligned 16-byte memory access", X86::TuningSlowUAMem16, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-unaligned-mem-32", "Slow unaligned 32-byte memory access", X86::TuningSlowUAMem32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "soft-float", "Use software floating point features", X86::FeatureSoftFloat, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse", "Enable SSE instructions", X86::FeatureSSE1, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse-unaligned-mem", "Allow unaligned memory operands with SSE instructions", X86::FeatureSSEUnalignedMem, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse2", "Enable SSE2 instructions", X86::FeatureSSE2, { { { 0x0ULL, 0x200ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse3", "Enable SSE3 instructions", X86::FeatureSSE3, { { { 0x0ULL, 0x400ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4.1", "Enable SSE 4.1 instructions", X86::FeatureSSE41, { { { 0x0ULL, 0x10000ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4.2", "Enable SSE 4.2 instructions", X86::FeatureSSE42, { { { 0x0ULL, 0x2000ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4a", "Support SSE 4a instructions", X86::FeatureSSE4A, { { { 0x0ULL, 0x800ULL, 0x0ULL, 0x0ULL, } } } },
  { "ssse3", "Enable SSSE3 instructions", X86::FeatureSSSE3, { { { 0x0ULL, 0x800ULL, 0x0ULL, 0x0ULL, } } } },
  { "tagged-globals", "Use an instruction sequence for taking the address of a global that allows a memory tag in the upper address bits.", X86::FeatureTaggedGlobals, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tbm", "Enable TBM instructions", X86::FeatureTBM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tsxldtrk", "Support TSXLDTRK instructions", X86::FeatureTSXLDTRK, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "uintr", "Has UINTR Instructions", X86::FeatureUINTR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "use-aa", "Use alias analysis during codegen", X86::FeatureUseAA, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "use-glm-div-sqrt-costs", "Use Goldmont specific floating point div/sqrt costs", X86::TuningUseGLMDivSqrtCosts, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "use-slm-arith-costs", "Use Silvermont specific arithmetic costs", X86::TuningUseSLMArithCosts, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vaes", "Promote selected AES instructions to AVX512/AVX registers", X86::FeatureVAES, { { { 0x110ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vpclmulqdq", "Enable vpclmulqdq instructions", X86::FeatureVPCLMULQDQ, { { { 0x20000000000100ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vzeroupper", "Should insert vzeroupper instructions", X86::TuningInsertVZEROUPPER, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "waitpkg", "Wait and pause enhancements", X86::FeatureWAITPKG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "wbnoinvd", "Write Back No Invalidate", X86::FeatureWBNOINVD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "widekl", "Support Key Locker wide Instructions", X86::FeatureWIDEKL, { { { 0x20000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "x87", "Enable X87 float instructions", X86::FeatureX87, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xop", "Enable XOP instructions", X86::FeatureXOP, { { { 0x100000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsave", "Support xsave instructions", X86::FeatureXSAVE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsavec", "Support xsavec instructions", X86::FeatureXSAVEC, { { { 0x0ULL, 0x2000000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsaveopt", "Support xsaveopt instructions", X86::FeatureXSAVEOPT, { { { 0x0ULL, 0x2000000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsaves", "Support xsaves instructions", X86::FeatureXSAVES, { { { 0x0ULL, 0x2000000000ULL, 0x0ULL, 0x0ULL, } } } },
};

#ifdef DBGFIELD
#error "<target>GenSubtargetInfo.inc requires a DBGFIELD macro"
#endif
#if !defined(NDEBUG) || defined(LLVM_ENABLE_DUMP)
#define DBGFIELD(x) x,
#else
#define DBGFIELD(x)
#endif

// ===============================================================
// Data tables for the new per-operand machine model.

// {ProcResourceIdx, Cycles}
extern const llvm::MCWriteProcResEntry X86WriteProcResTable[] = {
  { 0,  0}, // Invalid
  {22,  1}, // #1
  {23,  1}, // #2
  {13,  1}, // #3
  {19,  1}, // #4
  {20,  1}, // #5
  {22,  1}, // #6
  {23,  1}, // #7
  {14,  1}, // #8
  {20,  1}, // #9
  {22,  1}, // #10
  {23,  1}, // #11
  { 7,  1}, // #12
  {12,  1}, // #13
  {14,  2}, // #14
  {17,  1}, // #15
  {20,  2}, // #16
  {21,  2}, // #17
  {22,  3}, // #18
  {23,  6}, // #19
  {14,  1}, // #20
  {17,  1}, // #21
  {20,  1}, // #22
  {21,  1}, // #23
  {22,  1}, // #24
  {23,  2}, // #25
  { 4,  1}, // #26
  {11,  1}, // #27
  {15,  1}, // #28
  {16,  1}, // #29
  {19,  1}, // #30
  {22,  1}, // #31
  {23,  1}, // #32
  { 7,  1}, // #33
  {12,  1}, // #34
  {21,  1}, // #35
  {23,  2}, // #36
  {17,  1}, // #37
  {21,  1}, // #38
  {23,  1}, // #39
  { 3,  1}, // #40
  {11,  1}, // #41
  {12,  1}, // #42
  {13,  1}, // #43
  {14,  1}, // #44
  {19,  1}, // #45
  {20,  1}, // #46
  {22,  1}, // #47
  {23,  1}, // #48
  { 7,  1}, // #49
  {12,  1}, // #50
  {17,  1}, // #51
  {21,  2}, // #52
  {22,  1}, // #53
  {23,  4}, // #54
  {17,  1}, // #55
  {21,  1}, // #56
  {22,  1}, // #57
  {23,  2}, // #58
  {11,  1}, // #59
  {17,  1}, // #60
  {19,  1}, // #61
  {21,  1}, // #62
  {22,  1}, // #63
  {23,  2}, // #64
  {11,  1}, // #65
  {19,  1}, // #66
  {22,  1}, // #67
  {23,  1}, // #68
  { 3,  1}, // #69
  {11,  1}, // #70
  {12,  1}, // #71
  {13,  1}, // #72
  {14,  1}, // #73
  {17,  1}, // #74
  {19,  1}, // #75
  {20,  1}, // #76
  {21,  1}, // #77
  {22,  1}, // #78
  {23,  2}, // #79
  { 3,  2}, // #80
  {11,  2}, // #81
  {12,  2}, // #82
  {13,  2}, // #83
  {14,  2}, // #84
  {17,  1}, // #85
  {19,  2}, // #86
  {20,  2}, // #87
  {21,  1}, // #88
  {22,  2}, // #89
  {23,  3}, // #90
  { 3,  2}, // #91
  {11,  2}, // #92
  {12,  2}, // #93
  {13,  2}, // #94
  {14,  2}, // #95
  {19,  2}, // #96
  {20,  2}, // #97
  {22,  2}, // #98
  {23,  2}, // #99
  { 3,  3}, // #100
  { 8,  6}, // #101
  {11,  3}, // #102
  {12,  3}, // #103
  {13,  9}, // #104
  {14,  3}, // #105
  {15,  6}, // #106
  {17,  1}, // #107
  {18,  6}, // #108
  {19, 10}, // #109
  {20,  9}, // #110
  {21,  1}, // #111
  {22, 10}, // #112
  {23, 11}, // #113
  { 3,  3}, // #114
  { 8,  6}, // #115
  {11,  3}, // #116
  {12,  3}, // #117
  {13,  9}, // #118
  {14,  3}, // #119
  {15,  6}, // #120
  {18,  6}, // #121
  {19, 11}, // #122
  {20,  9}, // #123
  {22, 11}, // #124
  {23, 11}, // #125
  {14,  1}, // #126
  {15,  1}, // #127
  {17,  1}, // #128
  {19,  1}, // #129
  {20,  1}, // #130
  {21,  1}, // #131
  {22,  2}, // #132
  {23,  3}, // #133
  {14,  1}, // #134
  {15,  1}, // #135
  {19,  1}, // #136
  {20,  1}, // #137
  {22,  2}, // #138
  {23,  2}, // #139
  {17,  1}, // #140
  {19,  2}, // #141
  {21,  1}, // #142
  {22,  2}, // #143
  {23,  3}, // #144
  {19,  2}, // #145
  {22,  2}, // #146
  {23,  2}, // #147
  {15,  1}, // #148
  {17,  1}, // #149
  {19,  1}, // #150
  {21,  1}, // #151
  {22,  1}, // #152
  {23,  2}, // #153
  {15,  1}, // #154
  {19,  1}, // #155
  {22,  1}, // #156
  {23,  1}, // #157
  { 4,  1}, // #158
  {11,  1}, // #159
  {15,  1}, // #160
  {16,  1}, // #161
  {17,  1}, // #162
  {19,  1}, // #163
  {21,  1}, // #164
  {22,  1}, // #165
  {23,  2}, // #166
  { 7,  1}, // #167
  {12,  1}, // #168
  {14,  1}, // #169
  {17,  1}, // #170
  {20,  1}, // #171
  {21,  2}, // #172
  {22,  1}, // #173
  {23,  4}, // #174
  {14,  2}, // #175
  {20,  2}, // #176
  {22,  5}, // #177
  {23,  5}, // #178
  { 1, 10}, // #179
  { 3,  1}, // #180
  {11,  1}, // #181
  {12,  1}, // #182
  {13,  1}, // #183
  {14,  1}, // #184
  {17,  1}, // #185
  {19,  1}, // #186
  {20,  1}, // #187
  {21,  1}, // #188
  {22,  1}, // #189
  {23,  2}, // #190
  { 3,  7}, // #191
  { 4,  2}, // #192
  { 8,  8}, // #193
  { 9,  3}, // #194
  {11,  9}, // #195
  {12,  7}, // #196
  {13, 16}, // #197
  {14, 10}, // #198
  {15, 10}, // #199
  {16,  5}, // #200
  {18, 11}, // #201
  {19, 18}, // #202
  {20, 19}, // #203
  {22, 32}, // #204
  {23, 32}, // #205
  { 1, 10}, // #206
  { 3,  1}, // #207
  {11,  1}, // #208
  {12,  1}, // #209
  {13,  1}, // #210
  {14,  1}, // #211
  {19,  1}, // #212
  {20,  1}, // #213
  {22,  1}, // #214
  {23,  1}, // #215
  { 2,  4}, // #216
  { 3,  1}, // #217
  {11,  1}, // #218
  {12,  1}, // #219
  {13,  1}, // #220
  {14,  1}, // #221
  {17,  1}, // #222
  {19,  1}, // #223
  {20,  1}, // #224
  {21,  1}, // #225
  {22,  1}, // #226
  {23,  2}, // #227
  { 2,  3}, // #228
  { 3,  1}, // #229
  {11,  1}, // #230
  {12,  1}, // #231
  {13,  1}, // #232
  {14,  1}, // #233
  {19,  1}, // #234
  {20,  1}, // #235
  {22,  1}, // #236
  {23,  1}, // #237
  { 2,  5}, // #238
  { 3,  1}, // #239
  {11,  1}, // #240
  {12,  1}, // #241
  {13,  1}, // #242
  {14,  1}, // #243
  {17,  1}, // #244
  {19,  1}, // #245
  {20,  1}, // #246
  {21,  1}, // #247
  {22,  1}, // #248
  {23,  2}, // #249
  { 2,  3}, // #250
  { 3,  1}, // #251
  {11,  1}, // #252
  {12,  1}, // #253
  {13,  1}, // #254
  {14,  1}, // #255
  {17,  1}, // #256
  {19,  1}, // #257
  {20,  1}, // #258
  {21,  1}, // #259
  {22,  1}, // #260
  {23,  2}, // #261
  { 8,  1}, // #262
  {11,  2}, // #263
  {13,  1}, // #264
  {15,  1}, // #265
  {17,  1}, // #266
  {18,  1}, // #267
  {19,  3}, // #268
  {20,  1}, // #269
  {21,  1}, // #270
  {22,  3}, // #271
  {23,  4}, // #272
  { 8,  1}, // #273
  {11,  2}, // #274
  {13,  1}, // #275
  {15,  1}, // #276
  {18,  1}, // #277
  {19,  3}, // #278
  {20,  1}, // #279
  {22,  3}, // #280
  {23,  3}, // #281
  { 8,  1}, // #282
  {11,  3}, // #283
  {13,  1}, // #284
  {15,  1}, // #285
  {17,  1}, // #286
  {18,  1}, // #287
  {19,  4}, // #288
  {20,  1}, // #289
  {21,  1}, // #290
  {22,  4}, // #291
  {23,  5}, // #292
  { 8,  1}, // #293
  {11,  3}, // #294
  {13,  1}, // #295
  {15,  1}, // #296
  {18,  1}, // #297
  {19,  4}, // #298
  {20,  1}, // #299
  {22,  4}, // #300
  {23,  4}, // #301
  { 7,  1}, // #302
  { 8,  1}, // #303
  {12,  1}, // #304
  {13,  1}, // #305
  {15,  1}, // #306
  {18,  1}, // #307
  {19,  1}, // #308
  {20,  1}, // #309
  {21,  1}, // #310
  {22,  1}, // #311
  {23,  3}, // #312
  { 3,  1}, // #313
  { 8,  1}, // #314
  {11,  1}, // #315
  {12,  1}, // #316
  {13,  2}, // #317
  {14,  1}, // #318
  {15,  1}, // #319
  {18,  1}, // #320
  {19,  2}, // #321
  {20,  2}, // #322
  {22,  2}, // #323
  {23,  2}, // #324
  {13,  9}, // #325
  {19,  9}, // #326
  {20,  9}, // #327
  {22, 10}, // #328
  {23, 10}, // #329
  {13,  2}, // #330
  {19,  2}, // #331
  {20,  2}, // #332
  {22,  2}, // #333
  {23,  2}, // #334
  { 8,  2}, // #335
  {11,  1}, // #336
  {13,  2}, // #337
  {15,  2}, // #338
  {17,  1}, // #339
  {18,  2}, // #340
  {19,  3}, // #341
  {20,  2}, // #342
  {21,  1}, // #343
  {22,  3}, // #344
  {23,  4}, // #345
  { 8,  2}, // #346
  {11,  1}, // #347
  {13,  2}, // #348
  {15,  2}, // #349
  {18,  2}, // #350
  {19,  3}, // #351
  {20,  2}, // #352
  {22,  3}, // #353
  {23,  3}, // #354
  { 3,  2}, // #355
  { 8,  4}, // #356
  {11,  2}, // #357
  {12,  2}, // #358
  {13,  6}, // #359
  {14,  2}, // #360
  {15,  4}, // #361
  {17,  1}, // #362
  {18,  4}, // #363
  {19,  6}, // #364
  {20,  6}, // #365
  {21,  1}, // #366
  {22,  7}, // #367
  {23,  8}, // #368
  { 3,  4}, // #369
  { 4,  2}, // #370
  { 8,  4}, // #371
  { 9,  8}, // #372
  {11,  6}, // #373
  {12,  4}, // #374
  {13,  8}, // #375
  {14, 26}, // #376
  {15,  6}, // #377
  {16, 10}, // #378
  {18, 12}, // #379
  {19, 10}, // #380
  {20, 30}, // #381
  {22, 66}, // #382
  {23, 66}, // #383
  { 4,  1}, // #384
  {11,  1}, // #385
  {14,  1}, // #386
  {15,  1}, // #387
  {16,  1}, // #388
  {17,  1}, // #389
  {19,  1}, // #390
  {20,  1}, // #391
  {21,  1}, // #392
  {22,  4}, // #393
  {23,  5}, // #394
  { 4,  1}, // #395
  {11,  1}, // #396
  {14,  1}, // #397
  {15,  1}, // #398
  {16,  1}, // #399
  {19,  1}, // #400
  {20,  1}, // #401
  {22,  4}, // #402
  {23,  4}, // #403
  { 4,  1}, // #404
  {11,  1}, // #405
  {15,  1}, // #406
  {16,  1}, // #407
  {17,  1}, // #408
  {19,  1}, // #409
  {21,  1}, // #410
  {22,  2}, // #411
  {23,  3}, // #412
  { 4,  1}, // #413
  {11,  1}, // #414
  {15,  1}, // #415
  {16,  1}, // #416
  {19,  1}, // #417
  {22,  2}, // #418
  {23,  2}, // #419
  { 4,  1}, // #420
  {11,  1}, // #421
  {14,  1}, // #422
  {15,  1}, // #423
  {16,  1}, // #424
  {17,  1}, // #425
  {19,  1}, // #426
  {20,  1}, // #427
  {21,  1}, // #428
  {22,  3}, // #429
  {23,  4}, // #430
  { 4,  1}, // #431
  {11,  1}, // #432
  {14,  1}, // #433
  {15,  1}, // #434
  {16,  1}, // #435
  {19,  1}, // #436
  {20,  1}, // #437
  {22,  3}, // #438
  {23,  3}, // #439
  { 4,  1}, // #440
  { 8,  1}, // #441
  {11,  1}, // #442
  {13,  1}, // #443
  {15,  2}, // #444
  {16,  1}, // #445
  {17,  1}, // #446
  {18,  1}, // #447
  {19,  2}, // #448
  {20,  1}, // #449
  {21,  1}, // #450
  {22,  2}, // #451
  {23,  3}, // #452
  { 4,  1}, // #453
  { 8,  1}, // #454
  {11,  1}, // #455
  {13,  1}, // #456
  {15,  2}, // #457
  {16,  1}, // #458
  {18,  1}, // #459
  {19,  2}, // #460
  {20,  1}, // #461
  {22,  2}, // #462
  {23,  2}, // #463
  { 8,  1}, // #464
  {13,  1}, // #465
  {15,  1}, // #466
  {17,  1}, // #467
  {18,  1}, // #468
  {19,  1}, // #469
  {20,  1}, // #470
  {21,  1}, // #471
  {22,  1}, // #472
  {23,  2}, // #473
  { 8,  1}, // #474
  {13,  1}, // #475
  {15,  1}, // #476
  {18,  1}, // #477
  {19,  1}, // #478
  {20,  1}, // #479
  {22,  1}, // #480
  {23,  1}, // #481
  { 3,  1}, // #482
  {11,  1}, // #483
  {12,  1}, // #484
  {13,  1}, // #485
  {14,  1}, // #486
  {17,  1}, // #487
  {19,  1}, // #488
  {20,  1}, // #489
  {21,  1}, // #490
  {22,  2}, // #491
  {23,  3}, // #492
  { 7,  1}, // #493
  {12,  1}, // #494
  {17,  1}, // #495
  {21,  1}, // #496
  {23,  2}, // #497
  {13,  1}, // #498
  {17,  1}, // #499
  {19,  1}, // #500
  {20,  1}, // #501
  {21,  1}, // #502
  {22,  1}, // #503
  {23,  2}, // #504
  { 8,  2}, // #505
  {13,  3}, // #506
  {15,  2}, // #507
  {17,  1}, // #508
  {18,  2}, // #509
  {19,  3}, // #510
  {20,  3}, // #511
  {21,  1}, // #512
  {22,  3}, // #513
  {23,  4}, // #514
  { 8,  2}, // #515
  {13,  3}, // #516
  {15,  2}, // #517
  {18,  2}, // #518
  {19,  3}, // #519
  {20,  3}, // #520
  {22,  3}, // #521
  {23,  3}, // #522
  { 8,  2}, // #523
  {13,  2}, // #524
  {15,  2}, // #525
  {18,  2}, // #526
  {19,  2}, // #527
  {20,  2}, // #528
  {22,  2}, // #529
  {23,  2}, // #530
  { 8,  2}, // #531
  {13,  2}, // #532
  {15,  2}, // #533
  {17,  1}, // #534
  {18,  2}, // #535
  {19,  2}, // #536
  {20,  2}, // #537
  {21,  1}, // #538
  {22,  2}, // #539
  {23,  3}, // #540
  { 3,  4}, // #541
  { 8,  3}, // #542
  {11,  4}, // #543
  {12,  4}, // #544
  {13,  7}, // #545
  {14,  4}, // #546
  {15,  3}, // #547
  {17,  1}, // #548
  {18,  3}, // #549
  {19,  7}, // #550
  {20,  7}, // #551
  {21,  1}, // #552
  {22,  8}, // #553
  {23,  9}, // #554
  { 3,  4}, // #555
  { 8,  3}, // #556
  {11,  4}, // #557
  {12,  4}, // #558
  {13,  7}, // #559
  {14,  4}, // #560
  {15,  3}, // #561
  {18,  3}, // #562
  {19,  7}, // #563
  {20,  7}, // #564
  {22,  8}, // #565
  {23,  8}, // #566
  { 3,  4}, // #567
  { 8,  3}, // #568
  {11,  4}, // #569
  {12,  4}, // #570
  {13,  7}, // #571
  {14,  4}, // #572
  {15,  3}, // #573
  {17,  1}, // #574
  {18,  3}, // #575
  {19,  8}, // #576
  {20,  7}, // #577
  {21,  1}, // #578
  {22,  9}, // #579
  {23, 10}, // #580
  { 3,  4}, // #581
  { 8,  3}, // #582
  {11,  4}, // #583
  {12,  4}, // #584
  {13,  7}, // #585
  {14,  4}, // #586
  {15,  3}, // #587
  {18,  3}, // #588
  {19,  8}, // #589
  {20,  7}, // #590
  {22,  9}, // #591
  {23,  9}, // #592
  { 3,  3}, // #593
  {11,  3}, // #594
  {12,  3}, // #595
  {13,  3}, // #596
  {14,  3}, // #597
  {17,  1}, // #598
  {19,  3}, // #599
  {20,  3}, // #600
  {21,  1}, // #601
  {22,  3}, // #602
  {23,  4}, // #603
  { 3,  3}, // #604
  {11,  3}, // #605
  {12,  3}, // #606
  {13,  3}, // #607
  {14,  3}, // #608
  {19,  3}, // #609
  {20,  3}, // #610
  {22,  3}, // #611
  {23,  3}, // #612
  { 8,  2}, // #613
  {13,  2}, // #614
  {15,  2}, // #615
  {17,  1}, // #616
  {18,  2}, // #617
  {19,  3}, // #618
  {20,  2}, // #619
  {21,  1}, // #620
  {22,  3}, // #621
  {23,  4}, // #622
  { 8,  2}, // #623
  {13,  2}, // #624
  {15,  2}, // #625
  {18,  2}, // #626
  {19,  3}, // #627
  {20,  2}, // #628
  {22,  3}, // #629
  {23,  3}, // #630
  {11,  2}, // #631
  {17,  1}, // #632
  {19,  2}, // #633
  {21,  1}, // #634
  {22,  2}, // #635
  {23,  3}, // #636
  {11,  2}, // #637
  {19,  2}, // #638
  {22,  2}, // #639
  {23,  2}, // #640
  { 7,  1}, // #641
  {12,  1}, // #642
  {17,  1}, // #643
  {21,  2}, // #644
  {23,  3}, // #645
  { 8,  1}, // #646
  {11,  1}, // #647
  {13,  1}, // #648
  {15,  1}, // #649
  {18,  1}, // #650
  {19,  2}, // #651
  {20,  1}, // #652
  {22,  2}, // #653
  {23,  2}, // #654
  { 3,  1}, // #655
  { 8,  1}, // #656
  {11,  1}, // #657
  {12,  1}, // #658
  {13,  2}, // #659
  {14,  1}, // #660
  {15,  1}, // #661
  {17,  1}, // #662
  {18,  1}, // #663
  {19,  2}, // #664
  {20,  2}, // #665
  {21,  1}, // #666
  {22,  2}, // #667
  {23,  3}, // #668
  { 7,  1}, // #669
  {12,  1}, // #670
  {14,  3}, // #671
  {17,  1}, // #672
  {20,  3}, // #673
  {21,  2}, // #674
  {22,  3}, // #675
  {23,  6}, // #676
  {14,  3}, // #677
  {20,  3}, // #678
  {22,  3}, // #679
  {23,  3}, // #680
  { 7,  1}, // #681
  {12,  1}, // #682
  {14,  1}, // #683
  {20,  1}, // #684
  {21,  1}, // #685
  {22,  1}, // #686
  {23,  3}, // #687
  { 4,  1}, // #688
  {11,  1}, // #689
  {14,  2}, // #690
  {15,  1}, // #691
  {16,  1}, // #692
  {17,  1}, // #693
  {19,  1}, // #694
  {20,  2}, // #695
  {21,  2}, // #696
  {22,  4}, // #697
  {23,  6}, // #698
  { 4,  1}, // #699
  {11,  1}, // #700
  {15,  1}, // #701
  {16,  1}, // #702
  {17,  1}, // #703
  {19,  1}, // #704
  {21,  2}, // #705
  {22,  2}, // #706
  {23,  4}, // #707
  { 4,  1}, // #708
  {11,  1}, // #709
  {14,  2}, // #710
  {15,  1}, // #711
  {16,  1}, // #712
  {19,  1}, // #713
  {20,  2}, // #714
  {22,  4}, // #715
  {23,  4}, // #716
  { 2,  6}, // #717
  { 3,  1}, // #718
  {11,  1}, // #719
  {12,  1}, // #720
  {13,  1}, // #721
  {14,  1}, // #722
  {17,  1}, // #723
  {19,  1}, // #724
  {20,  1}, // #725
  {21,  1}, // #726
  {22,  1}, // #727
  {23,  2}, // #728
  { 2,  6}, // #729
  { 3,  1}, // #730
  {11,  1}, // #731
  {12,  1}, // #732
  {13,  1}, // #733
  {14,  1}, // #734
  {19,  1}, // #735
  {20,  1}, // #736
  {22,  1}, // #737
  {23,  1}, // #738
  { 2,  7}, // #739
  { 3,  1}, // #740
  {11,  1}, // #741
  {12,  1}, // #742
  {13,  1}, // #743
  {14,  1}, // #744
  {19,  1}, // #745
  {20,  1}, // #746
  {22,  1}, // #747
  {23,  1}, // #748
  { 8,  1}, // #749
  {13,  1}, // #750
  {15,  1}, // #751
  {18,  1}, // #752
  {19,  2}, // #753
  {20,  1}, // #754
  {22,  2}, // #755
  {23,  2}, // #756
  { 7,  1}, // #757
  { 8,  1}, // #758
  {11,  1}, // #759
  {12,  1}, // #760
  {13,  1}, // #761
  {15,  1}, // #762
  {18,  1}, // #763
  {19,  2}, // #764
  {20,  1}, // #765
  {21,  1}, // #766
  {22,  2}, // #767
  {23,  4}, // #768
  { 2,  8}, // #769
  { 3,  1}, // #770
  {11,  1}, // #771
  {12,  1}, // #772
  {13,  1}, // #773
  {14,  1}, // #774
  {17,  1}, // #775
  {19,  1}, // #776
  {20,  1}, // #777
  {21,  1}, // #778
  {22,  1}, // #779
  {23,  2}, // #780
  { 2,  5}, // #781
  { 3,  1}, // #782
  {11,  1}, // #783
  {12,  1}, // #784
  {13,  1}, // #785
  {14,  1}, // #786
  {19,  1}, // #787
  {20,  1}, // #788
  {22,  1}, // #789
  {23,  1}, // #790
  { 3,  1}, // #791
  {11,  1}, // #792
  {12,  1}, // #793
  {13,  1}, // #794
  {14,  1}, // #795
  {19,  1}, // #796
  {20,  1}, // #797
  {21,  1}, // #798
  {22,  1}, // #799
  {23,  2}, // #800
  { 2, 12}, // #801
  { 3,  1}, // #802
  {11,  1}, // #803
  {12,  1}, // #804
  {13,  1}, // #805
  {14,  1}, // #806
  {17,  1}, // #807
  {19,  1}, // #808
  {20,  1}, // #809
  {21,  1}, // #810
  {22,  1}, // #811
  {23,  2}, // #812
  { 2, 12}, // #813
  { 3,  1}, // #814
  {11,  1}, // #815
  {12,  1}, // #816
  {13,  1}, // #817
  {14,  1}, // #818
  {19,  1}, // #819
  {20,  1}, // #820
  {22,  1}, // #821
  {23,  1}, // #822
  {14,  1}, // #823
  {17,  1}, // #824
  {20,  1}, // #825
  {21,  2}, // #826
  {22,  3}, // #827
  {23,  5}, // #828
  { 4,  2}, // #829
  {11,  2}, // #830
  {14,  4}, // #831
  {15,  3}, // #832
  {16,  2}, // #833
  {17,  1}, // #834
  {19,  3}, // #835
  {20,  4}, // #836
  {21,  2}, // #837
  {22,  9}, // #838
  {23, 11}, // #839
  { 3,  2}, // #840
  { 4,  1}, // #841
  { 8,  2}, // #842
  { 9,  4}, // #843
  {11,  3}, // #844
  {12,  2}, // #845
  {13,  6}, // #846
  {14,  6}, // #847
  {15,  3}, // #848
  {16,  5}, // #849
  {18,  6}, // #850
  {19,  7}, // #851
  {20, 10}, // #852
  {22, 15}, // #853
  {23, 15}, // #854
  { 3,  1}, // #855
  { 8,  1}, // #856
  {11,  2}, // #857
  {12,  1}, // #858
  {13,  2}, // #859
  {14,  1}, // #860
  {15,  1}, // #861
  {18,  1}, // #862
  {19,  3}, // #863
  {20,  2}, // #864
  {22,  3}, // #865
  {23,  3}, // #866
  { 3,  1}, // #867
  { 8,  1}, // #868
  {11,  2}, // #869
  {12,  1}, // #870
  {13,  2}, // #871
  {14,  1}, // #872
  {15,  1}, // #873
  {17,  1}, // #874
  {18,  1}, // #875
  {19,  3}, // #876
  {20,  2}, // #877
  {21,  1}, // #878
  {22,  3}, // #879
  {23,  4}, // #880
  {17,  1}, // #881
  {21,  1}, // #882
  {22,  2}, // #883
  {23,  3}, // #884
  { 9,  1}, // #885
  {14,  1}, // #886
  {16,  1}, // #887
  {18,  1}, // #888
  {20,  1}, // #889
  {22,  3}, // #890
  {23,  3}, // #891
  { 7,  1}, // #892
  { 9,  1}, // #893
  {12,  1}, // #894
  {14,  2}, // #895
  {16,  1}, // #896
  {17,  1}, // #897
  {18,  1}, // #898
  {20,  2}, // #899
  {21,  2}, // #900
  {22,  5}, // #901
  {23,  8}, // #902
  {14,  1}, // #903
  {20,  1}, // #904
  {22,  2}, // #905
  {23,  2}, // #906
  { 3,  1}, // #907
  {11,  1}, // #908
  {12,  1}, // #909
  {13,  2}, // #910
  {14,  1}, // #911
  {17,  1}, // #912
  {19,  2}, // #913
  {20,  2}, // #914
  {21,  1}, // #915
  {22,  2}, // #916
  {23,  3}, // #917
  {14,  2}, // #918
  {20,  2}, // #919
  {22, 11}, // #920
  {23, 11}, // #921
  { 7,  1}, // #922
  { 9,  1}, // #923
  {12,  1}, // #924
  {14,  1}, // #925
  {16,  1}, // #926
  {18,  1}, // #927
  {20,  1}, // #928
  {21,  1}, // #929
  {22,  1}, // #930
  {23,  3}, // #931
  { 9,  1}, // #932
  {14,  1}, // #933
  {16,  1}, // #934
  {18,  1}, // #935
  {20,  1}, // #936
  {22,  4}, // #937
  {23,  4}, // #938
  { 7,  1}, // #939
  {12,  1}, // #940
  {14,  4}, // #941
  {15,  2}, // #942
  {17,  1}, // #943
  {19,  2}, // #944
  {20,  4}, // #945
  {21,  2}, // #946
  {22, 11}, // #947
  {23, 14}, // #948
  { 9,  1}, // #949
  {14,  4}, // #950
  {15,  1}, // #951
  {16,  1}, // #952
  {18,  1}, // #953
  {19,  1}, // #954
  {20,  4}, // #955
  {22,  7}, // #956
  {23,  7}, // #957
  { 9,  1}, // #958
  {14,  1}, // #959
  {16,  1}, // #960
  {18,  1}, // #961
  {20,  1}, // #962
  {22,  6}, // #963
  {23,  6}, // #964
  { 3,  2}, // #965
  { 7,  1}, // #966
  { 8,  4}, // #967
  {11,  2}, // #968
  {12,  3}, // #969
  {13,  6}, // #970
  {14,  6}, // #971
  {15,  4}, // #972
  {17,  1}, // #973
  {18,  4}, // #974
  {19,  6}, // #975
  {20, 10}, // #976
  {21,  2}, // #977
  {22, 16}, // #978
  {23, 19}, // #979
  { 8,  2}, // #980
  {13,  2}, // #981
  {15,  2}, // #982
  {18,  2}, // #983
  {19,  2}, // #984
  {20,  2}, // #985
  {22, 22}, // #986
  {23, 22}, // #987
  { 8,  1}, // #988
  { 9,  2}, // #989
  {13,  1}, // #990
  {14,  2}, // #991
  {15,  1}, // #992
  {16,  2}, // #993
  {18,  3}, // #994
  {19,  1}, // #995
  {20,  3}, // #996
  {22, 10}, // #997
  {23, 10}, // #998
  { 7,  1}, // #999
  { 8,  1}, // #1000
  { 9,  1}, // #1001
  {12,  1}, // #1002
  {13,  1}, // #1003
  {14,  2}, // #1004
  {15,  1}, // #1005
  {16,  1}, // #1006
  {17,  1}, // #1007
  {18,  2}, // #1008
  {19,  1}, // #1009
  {20,  3}, // #1010
  {21,  2}, // #1011
  {22,  5}, // #1012
  {23,  8}, // #1013
  { 8,  6}, // #1014
  {13,  9}, // #1015
  {15,  6}, // #1016
  {18,  6}, // #1017
  {19,  9}, // #1018
  {20,  9}, // #1019
  {22, 15}, // #1020
  {23, 15}, // #1021
  { 8,  1}, // #1022
  { 9,  5}, // #1023
  {13,  1}, // #1024
  {14,  9}, // #1025
  {15,  1}, // #1026
  {16,  5}, // #1027
  {17,  2}, // #1028
  {18,  6}, // #1029
  {19,  1}, // #1030
  {20, 10}, // #1031
  {21,  3}, // #1032
  {22, 20}, // #1033
  {23, 23}, // #1034
  { 8,  1}, // #1035
  { 9,  5}, // #1036
  {13,  1}, // #1037
  {14,  9}, // #1038
  {15,  1}, // #1039
  {16,  5}, // #1040
  {17,  3}, // #1041
  {18,  6}, // #1042
  {19,  1}, // #1043
  {20, 10}, // #1044
  {21,  3}, // #1045
  {22, 20}, // #1046
  {23, 23}, // #1047
  { 8,  1}, // #1048
  { 9,  1}, // #1049
  {13,  1}, // #1050
  {14,  2}, // #1051
  {15,  1}, // #1052
  {16,  1}, // #1053
  {18,  2}, // #1054
  {19,  1}, // #1055
  {20,  3}, // #1056
  {22,  8}, // #1057
  {23,  8}, // #1058
  { 3,  4}, // #1059
  { 9,  2}, // #1060
  {11,  4}, // #1061
  {12,  4}, // #1062
  {13,  5}, // #1063
  {14,  8}, // #1064
  {15,  1}, // #1065
  {16,  2}, // #1066
  {17, 33}, // #1067
  {18,  2}, // #1068
  {19,  6}, // #1069
  {20,  9}, // #1070
  {21, 33}, // #1071
  {22, 57}, // #1072
  {23, 90}, // #1073
  { 9,  1}, // #1074
  {14,  1}, // #1075
  {16,  1}, // #1076
  {17,  1}, // #1077
  {18,  1}, // #1078
  {20,  1}, // #1079
  {21,  1}, // #1080
  {22,  2}, // #1081
  {23,  3}, // #1082
  { 3,  1}, // #1083
  {11,  1}, // #1084
  {12,  1}, // #1085
  {13,  1}, // #1086
  {14,  1}, // #1087
  {19,  1}, // #1088
  {20,  1}, // #1089
  {22,  2}, // #1090
  {23,  2}, // #1091
  {14,  1}, // #1092
  {20,  1}, // #1093
  {22,  3}, // #1094
  {23,  3}, // #1095
  { 4,  2}, // #1096
  {11,  2}, // #1097
  {14,  4}, // #1098
  {15,  3}, // #1099
  {16,  2}, // #1100
  {19,  3}, // #1101
  {20,  4}, // #1102
  {22, 10}, // #1103
  {23, 10}, // #1104
  { 7,  1}, // #1105
  {12,  1}, // #1106
  {21,  1}, // #1107
  {22,  1}, // #1108
  {23,  3}, // #1109
  { 7,  1}, // #1110
  {12,  1}, // #1111
  {14,  1}, // #1112
  {20,  1}, // #1113
  {21,  1}, // #1114
  {22,  2}, // #1115
  {23,  4}, // #1116
  { 7,  1}, // #1117
  { 9,  1}, // #1118
  {12,  1}, // #1119
  {14,  1}, // #1120
  {16,  1}, // #1121
  {18,  1}, // #1122
  {20,  1}, // #1123
  {21,  1}, // #1124
  {22,  2}, // #1125
  {23,  4}, // #1126
  { 7,  1}, // #1127
  {12,  1}, // #1128
  {21,  1}, // #1129
  {22,  4}, // #1130
  {23,  6}, // #1131
  { 9,  1}, // #1132
  {14,  1}, // #1133
  {16,  1}, // #1134
  {18,  1}, // #1135
  {20,  1}, // #1136
  {22,  2}, // #1137
  {23,  2}, // #1138
  { 9,  1}, // #1139
  {14,  1}, // #1140
  {16,  1}, // #1141
  {17,  1}, // #1142
  {18,  1}, // #1143
  {20,  1}, // #1144
  {21,  1}, // #1145
  {22,  1}, // #1146
  {23,  2}, // #1147
  { 3,  1}, // #1148
  { 7,  1}, // #1149
  {11,  1}, // #1150
  {12,  2}, // #1151
  {13,  1}, // #1152
  {14,  1}, // #1153
  {19,  1}, // #1154
  {20,  1}, // #1155
  {21,  1}, // #1156
  {22,  1}, // #1157
  {23,  3}, // #1158
  { 4,  1}, // #1159
  { 9,  1}, // #1160
  {11,  1}, // #1161
  {14,  2}, // #1162
  {15,  1}, // #1163
  {16,  2}, // #1164
  {18,  1}, // #1165
  {19,  1}, // #1166
  {20,  2}, // #1167
  {22,  4}, // #1168
  {23,  4}, // #1169
  { 7,  1}, // #1170
  { 9,  1}, // #1171
  {12,  1}, // #1172
  {14,  1}, // #1173
  {16,  1}, // #1174
  {17,  1}, // #1175
  {18,  1}, // #1176
  {20,  1}, // #1177
  {21,  2}, // #1178
  {22,  2}, // #1179
  {23,  5}, // #1180
  { 7,  1}, // #1181
  {12,  1}, // #1182
  {14,  2}, // #1183
  {17,  1}, // #1184
  {20,  2}, // #1185
  {21,  2}, // #1186
  {22,  2}, // #1187
  {23,  5}, // #1188
  { 7,  1}, // #1189
  {12,  1}, // #1190
  {17,  1}, // #1191
  {21,  2}, // #1192
  {22,  2}, // #1193
  {23,  5}, // #1194
  { 3,  1}, // #1195
  {11,  2}, // #1196
  {12,  1}, // #1197
  {13,  1}, // #1198
  {14,  1}, // #1199
  {17,  1}, // #1200
  {19,  2}, // #1201
  {20,  1}, // #1202
  {21,  1}, // #1203
  {22,  2}, // #1204
  {23,  3}, // #1205
  {22, 16}, // #1206
  {23, 16}, // #1207
  { 9,  1}, // #1208
  {14,  1}, // #1209
  {16,  1}, // #1210
  {18,  1}, // #1211
  {20,  1}, // #1212
  {22,  1}, // #1213
  {23,  1}, // #1214
  { 7,  1}, // #1215
  {12,  1}, // #1216
  {15,  1}, // #1217
  {19,  1}, // #1218
  {21,  1}, // #1219
  {22,  1}, // #1220
  {23,  3}, // #1221
  {14,  2}, // #1222
  {20,  2}, // #1223
  {22,  2}, // #1224
  {23,  2}, // #1225
  { 8,  2}, // #1226
  {13,  2}, // #1227
  {15,  2}, // #1228
  {18,  2}, // #1229
  {19,  2}, // #1230
  {20,  2}, // #1231
  {22,  3}, // #1232
  {23,  3}, // #1233
  { 3,  1}, // #1234
  {11,  2}, // #1235
  {12,  1}, // #1236
  {13,  1}, // #1237
  {14,  1}, // #1238
  {19,  2}, // #1239
  {20,  1}, // #1240
  {22,  2}, // #1241
  {23,  2}, // #1242
  { 8,  1}, // #1243
  {11,  1}, // #1244
  {13,  1}, // #1245
  {15,  1}, // #1246
  {17,  1}, // #1247
  {18,  1}, // #1248
  {19,  2}, // #1249
  {20,  1}, // #1250
  {21,  1}, // #1251
  {22,  2}, // #1252
  {23,  3}, // #1253
  { 4,  1}, // #1254
  { 9,  1}, // #1255
  {11,  1}, // #1256
  {14,  1}, // #1257
  {15,  1}, // #1258
  {16,  2}, // #1259
  {18,  1}, // #1260
  {19,  1}, // #1261
  {20,  1}, // #1262
  {22,  4}, // #1263
  {23,  4}, // #1264
  { 4,  1}, // #1265
  { 9,  2}, // #1266
  {11,  1}, // #1267
  {14,  2}, // #1268
  {15,  1}, // #1269
  {16,  3}, // #1270
  {17,  1}, // #1271
  {18,  2}, // #1272
  {19,  1}, // #1273
  {20,  2}, // #1274
  {21,  1}, // #1275
  {22,  4}, // #1276
  {23,  5}, // #1277
  { 4,  1}, // #1278
  { 9,  1}, // #1279
  {11,  1}, // #1280
  {14,  2}, // #1281
  {15,  1}, // #1282
  {16,  2}, // #1283
  {18,  1}, // #1284
  {19,  1}, // #1285
  {20,  2}, // #1286
  {22,  3}, // #1287
  {23,  3}, // #1288
  {14,  1}, // #1289
  {20,  1}, // #1290
  {22,  5}, // #1291
  {23,  5}, // #1292
  { 4,  1}, // #1293
  {11,  1}, // #1294
  {14,  5}, // #1295
  {15,  2}, // #1296
  {16,  1}, // #1297
  {17,  1}, // #1298
  {19,  2}, // #1299
  {20,  5}, // #1300
  {21,  2}, // #1301
  {22,  8}, // #1302
  {23, 10}, // #1303
  { 4,  2}, // #1304
  {11,  2}, // #1305
  {14,  3}, // #1306
  {15,  2}, // #1307
  {16,  2}, // #1308
  {19,  2}, // #1309
  {20,  3}, // #1310
  {22,  7}, // #1311
  {23,  7}, // #1312
  { 4,  1}, // #1313
  {11,  1}, // #1314
  {14,  5}, // #1315
  {15,  2}, // #1316
  {16,  1}, // #1317
  {19,  2}, // #1318
  {20,  5}, // #1319
  {22,  9}, // #1320
  {23,  9}, // #1321
  { 4,  1}, // #1322
  { 9,  8}, // #1323
  {11,  1}, // #1324
  {14,  8}, // #1325
  {15,  1}, // #1326
  {16,  9}, // #1327
  {17,  1}, // #1328
  {18,  8}, // #1329
  {19,  1}, // #1330
  {20,  8}, // #1331
  {21,  1}, // #1332
  {22, 30}, // #1333
  {23, 31}, // #1334
  { 7,  1}, // #1335
  { 9, 10}, // #1336
  {12,  1}, // #1337
  {14, 10}, // #1338
  {16, 10}, // #1339
  {17,  1}, // #1340
  {18, 10}, // #1341
  {20, 10}, // #1342
  {21,  2}, // #1343
  {22, 36}, // #1344
  {23, 39}, // #1345
  { 7,  1}, // #1346
  { 9, 11}, // #1347
  {12,  1}, // #1348
  {14, 11}, // #1349
  {16, 11}, // #1350
  {17,  1}, // #1351
  {18, 11}, // #1352
  {20, 11}, // #1353
  {21,  2}, // #1354
  {22, 37}, // #1355
  {23, 40}, // #1356
  { 7,  1}, // #1357
  { 9, 11}, // #1358
  {12,  1}, // #1359
  {14, 11}, // #1360
  {16, 11}, // #1361
  {17,  1}, // #1362
  {18, 11}, // #1363
  {20, 11}, // #1364
  {21,  2}, // #1365
  {22, 41}, // #1366
  {23, 44}, // #1367
  { 4,  1}, // #1368
  { 7,  1}, // #1369
  { 8,  2}, // #1370
  { 9,  3}, // #1371
  {11,  1}, // #1372
  {12,  1}, // #1373
  {13,  2}, // #1374
  {14,  3}, // #1375
  {15,  4}, // #1376
  {16,  4}, // #1377
  {17,  1}, // #1378
  {18,  5}, // #1379
  {19,  4}, // #1380
  {20,  5}, // #1381
  {21,  2}, // #1382
  {22, 15}, // #1383
  {23, 18}, // #1384
  { 3,  2}, // #1385
  {11,  2}, // #1386
  {12,  2}, // #1387
  {13,  7}, // #1388
  {14, 12}, // #1389
  {17,  8}, // #1390
  {19,  7}, // #1391
  {20, 17}, // #1392
  {21,  8}, // #1393
  {22, 56}, // #1394
  {23, 64}, // #1395
  { 3,  4}, // #1396
  { 9,  4}, // #1397
  {11,  4}, // #1398
  {12,  4}, // #1399
  {13,  5}, // #1400
  {14, 10}, // #1401
  {15,  1}, // #1402
  {16,  4}, // #1403
  {17, 31}, // #1404
  {18,  4}, // #1405
  {19,  6}, // #1406
  {20, 11}, // #1407
  {21, 31}, // #1408
  {22, 57}, // #1409
  {23, 88}, // #1410
  { 3,  9}, // #1411
  { 4,  1}, // #1412
  { 7, 11}, // #1413
  { 8, 16}, // #1414
  { 9,  1}, // #1415
  {11, 10}, // #1416
  {12, 20}, // #1417
  {13, 25}, // #1418
  {14, 31}, // #1419
  {15, 17}, // #1420
  {16,  2}, // #1421
  {18, 17}, // #1422
  {19, 26}, // #1423
  {20, 47}, // #1424
  {21, 11}, // #1425
  {22, 78}, // #1426
  {23, 100}, // #1427
  { 3,  1}, // #1428
  { 8,  1}, // #1429
  {11,  1}, // #1430
  {12,  1}, // #1431
  {13,  2}, // #1432
  {14,  1}, // #1433
  {15,  1}, // #1434
  {17,  2}, // #1435
  {18,  1}, // #1436
  {19,  3}, // #1437
  {20,  2}, // #1438
  {21,  2}, // #1439
  {22,  3}, // #1440
  {23,  5}, // #1441
  { 3,  1}, // #1442
  { 8,  1}, // #1443
  {11,  1}, // #1444
  {12,  1}, // #1445
  {13,  2}, // #1446
  {14,  1}, // #1447
  {15,  1}, // #1448
  {17,  4}, // #1449
  {18,  1}, // #1450
  {19,  3}, // #1451
  {20,  2}, // #1452
  {21,  4}, // #1453
  {22,  3}, // #1454
  {23,  7}, // #1455
  { 3,  1}, // #1456
  { 8,  1}, // #1457
  {11,  1}, // #1458
  {12,  1}, // #1459
  {13,  2}, // #1460
  {14,  1}, // #1461
  {15,  1}, // #1462
  {17,  8}, // #1463
  {18,  1}, // #1464
  {19,  3}, // #1465
  {20,  2}, // #1466
  {21,  8}, // #1467
  {22,  3}, // #1468
  {23, 11}, // #1469
  { 3,  1}, // #1470
  { 8,  2}, // #1471
  {11,  1}, // #1472
  {12,  1}, // #1473
  {13,  3}, // #1474
  {14,  1}, // #1475
  {15,  2}, // #1476
  {18,  2}, // #1477
  {19,  3}, // #1478
  {20,  3}, // #1479
  {22,  3}, // #1480
  {23,  3}, // #1481
  { 3,  1}, // #1482
  { 8,  2}, // #1483
  {11,  1}, // #1484
  {12,  1}, // #1485
  {13,  3}, // #1486
  {14,  1}, // #1487
  {15,  2}, // #1488
  {17,  1}, // #1489
  {18,  2}, // #1490
  {19,  3}, // #1491
  {20,  3}, // #1492
  {21,  1}, // #1493
  {22,  3}, // #1494
  {23,  4}, // #1495
  {14,  2}, // #1496
  {17,  1}, // #1497
  {20,  2}, // #1498
  {21,  1}, // #1499
  {22,  2}, // #1500
  {23,  3}, // #1501
  { 7,  1}, // #1502
  {12,  1}, // #1503
  {14,  2}, // #1504
  {20,  2}, // #1505
  {21,  1}, // #1506
  {22,  2}, // #1507
  {23,  4}, // #1508
  { 2,  1}, // #1509
  { 3,  1}, // #1510
  { 1,  1}, // #1511
  { 3,  2}, // #1512
  { 1,  1}, // #1513
  { 3,  1}, // #1514
  { 1,  6}, // #1515
  { 2,  6}, // #1516
  { 3, 12}, // #1517
  { 1,  5}, // #1518
  { 2,  5}, // #1519
  { 3, 10}, // #1520
  { 1,  1}, // #1521
  { 2,  1}, // #1522
  { 3,  2}, // #1523
  { 1, 16}, // #1524
  { 2, 16}, // #1525
  { 3, 32}, // #1526
  { 3, 11}, // #1527
  { 3, 15}, // #1528
  { 1, 10}, // #1529
  { 2, 10}, // #1530
  { 3, 20}, // #1531
  { 1,  9}, // #1532
  { 2,  9}, // #1533
  { 3, 18}, // #1534
  { 1,  5}, // #1535
  { 3,  5}, // #1536
  { 1,  7}, // #1537
  { 2,  7}, // #1538
  { 3, 14}, // #1539
  { 1,  8}, // #1540
  { 2,  8}, // #1541
  { 3, 16}, // #1542
  { 1, 12}, // #1543
  { 2, 12}, // #1544
  { 3, 24}, // #1545
  { 1, 11}, // #1546
  { 2, 11}, // #1547
  { 3, 22}, // #1548
  { 1, 50}, // #1549
  { 2, 50}, // #1550
  { 3, 100}, // #1551
  { 1, 130}, // #1552
  { 2, 130}, // #1553
  { 3, 260}, // #1554
  { 1, 68}, // #1555
  { 2, 68}, // #1556
  { 3, 136}, // #1557
  { 1, 125}, // #1558
  { 2, 125}, // #1559
  { 3, 250}, // #1560
  { 1, 70}, // #1561
  { 2, 70}, // #1562
  { 3, 140}, // #1563
  { 1, 34}, // #1564
  { 2, 34}, // #1565
  { 3, 68}, // #1566
  { 1, 62}, // #1567
  { 2, 62}, // #1568
  { 3, 124}, // #1569
  { 1, 14}, // #1570
  { 2, 14}, // #1571
  { 3, 28}, // #1572
  { 3,  6}, // #1573
  { 1,  3}, // #1574
  { 3,  3}, // #1575
  { 1,  4}, // #1576
  { 2,  4}, // #1577
  { 3,  8}, // #1578
  { 1,  3}, // #1579
  { 2,  3}, // #1580
  { 3,  6}, // #1581
  { 1,  2}, // #1582
  { 2,  2}, // #1583
  { 3,  4}, // #1584
  { 1,  2}, // #1585
  { 3,  2}, // #1586
  { 1,  4}, // #1587
  { 3,  4}, // #1588
  { 1, 71}, // #1589
  { 3, 71}, // #1590
  { 1, 15}, // #1591
  { 2, 15}, // #1592
  { 3, 30}, // #1593
  { 2,  5}, // #1594
  { 3,  5}, // #1595
  { 3, 13}, // #1596
  { 3, 17}, // #1597
  { 3, 21}, // #1598
  { 3, 23}, // #1599
  { 3, 25}, // #1600
  { 3, 26}, // #1601
  { 3, 29}, // #1602
  { 3, 45}, // #1603
  { 3, 46}, // #1604
  { 3, 48}, // #1605
  { 3, 55}, // #1606
  { 3, 59}, // #1607
  { 3, 63}, // #1608
  { 3, 72}, // #1609
  { 3, 74}, // #1610
  { 3, 77}, // #1611
  { 3, 78}, // #1612
  { 3, 79}, // #1613
  { 3, 92}, // #1614
  { 3, 94}, // #1615
  { 3, 99}, // #1616
  { 3, 121}, // #1617
  { 3, 127}, // #1618
  { 3, 130}, // #1619
  { 3, 141}, // #1620
  { 3, 146}, // #1621
  { 3, 147}, // #1622
  { 3, 168}, // #1623
  { 3, 174}, // #1624
  { 3, 183}, // #1625
  { 3, 202}, // #1626
  { 5,  2}, // #1627
  { 8,  2}, // #1628
  {11,  1}, // #1629
  {14,  1}, // #1630
  {19,  1}, // #1631
  { 2,  1}, // #1632
  { 5,  1}, // #1633
  { 7,  1}, // #1634
  { 8,  1}, // #1635
  { 1,  2}, // #1636
  { 5, 44}, // #1637
  { 7, 44}, // #1638
  { 8, 44}, // #1639
  {22,  1}, // #1640
  {24,  1}, // #1641
  { 1,  3}, // #1642
  { 2,  1}, // #1643
  { 5,  1}, // #1644
  { 7,  1}, // #1645
  { 8,  1}, // #1646
  {22,  3}, // #1647
  { 5,  1}, // #1648
  { 8,  1}, // #1649
  { 5,  6}, // #1650
  { 8,  6}, // #1651
  { 1,  1}, // #1652
  {13,  1}, // #1653
  {14,  3}, // #1654
  {20,  3}, // #1655
  {24,  1}, // #1656
  { 1,  3}, // #1657
  {10,  3}, // #1658
  {14,  1}, // #1659
  {19,  1}, // #1660
  {22,  3}, // #1661
  { 1,  1}, // #1662
  {13,  2}, // #1663
  {14, 36}, // #1664
  {20, 36}, // #1665
  {24,  1}, // #1666
  {10,  4}, // #1667
  {14,  1}, // #1668
  {16,  1}, // #1669
  {19,  1}, // #1670
  { 1,  4}, // #1671
  { 5,  2}, // #1672
  { 8,  2}, // #1673
  {22,  3}, // #1674
  {24,  1}, // #1675
  { 1,  3}, // #1676
  { 5,  2}, // #1677
  { 8,  2}, // #1678
  {22,  3}, // #1679
  { 1,  3}, // #1680
  {10,  1}, // #1681
  {14,  1}, // #1682
  {15,  1}, // #1683
  {19,  1}, // #1684
  {22,  3}, // #1685
  { 1,  3}, // #1686
  {12,  1}, // #1687
  {14,  1}, // #1688
  {15,  1}, // #1689
  {19,  1}, // #1690
  {22,  3}, // #1691
  { 1,  3}, // #1692
  {10,  2}, // #1693
  {14,  1}, // #1694
  {19,  1}, // #1695
  {22,  3}, // #1696
  { 1,  3}, // #1697
  { 5,  6}, // #1698
  { 8,  6}, // #1699
  {22,  3}, // #1700
  { 1,  3}, // #1701
  { 5,  8}, // #1702
  { 8,  8}, // #1703
  {22,  3}, // #1704
  { 1,  2}, // #1705
  { 5,  7}, // #1706
  { 8,  7}, // #1707
  {22,  2}, // #1708
  { 1,  1}, // #1709
  { 5, 42}, // #1710
  { 8, 42}, // #1711
  {22,  1}, // #1712
  { 1,  1}, // #1713
  { 5, 44}, // #1714
  { 8, 44}, // #1715
  {22,  1}, // #1716
  { 1,  3}, // #1717
  { 5,  1}, // #1718
  { 8,  1}, // #1719
  {22,  3}, // #1720
  { 1,  2}, // #1721
  {22,  2}, // #1722
  { 5,  3}, // #1723
  { 7,  3}, // #1724
  { 8,  3}, // #1725
  { 1,  3}, // #1726
  { 5,  1}, // #1727
  { 6,  1}, // #1728
  { 8,  1}, // #1729
  {10,  1}, // #1730
  {14,  1}, // #1731
  {15,  1}, // #1732
  {19,  1}, // #1733
  {22,  3}, // #1734
  { 1,  3}, // #1735
  { 5,  4}, // #1736
  { 8,  4}, // #1737
  {22,  3}, // #1738
  { 1,  3}, // #1739
  { 9,  1}, // #1740
  {13,  1}, // #1741
  {14,  1}, // #1742
  {15,  1}, // #1743
  {19,  1}, // #1744
  {22,  3}, // #1745
  { 1,  3}, // #1746
  { 5,  1}, // #1747
  { 6,  1}, // #1748
  { 8,  1}, // #1749
  { 9,  1}, // #1750
  {10,  1}, // #1751
  {13,  1}, // #1752
  {14,  1}, // #1753
  {15,  1}, // #1754
  {19,  1}, // #1755
  {22,  3}, // #1756
  { 1,  3}, // #1757
  { 9,  2}, // #1758
  {13,  1}, // #1759
  {14,  1}, // #1760
  {15,  1}, // #1761
  {19,  1}, // #1762
  {22,  3}, // #1763
  { 1,  3}, // #1764
  { 4, 15}, // #1765
  { 5,  1}, // #1766
  { 7,  1}, // #1767
  { 8,  1}, // #1768
  {22,  3}, // #1769
  { 1,  3}, // #1770
  { 4, 14}, // #1771
  { 5,  1}, // #1772
  { 7,  1}, // #1773
  { 8,  1}, // #1774
  {22,  3}, // #1775
  { 1,  3}, // #1776
  { 4, 12}, // #1777
  { 5,  1}, // #1778
  { 7,  1}, // #1779
  { 8,  1}, // #1780
  {22,  3}, // #1781
  { 1,  3}, // #1782
  {10,  9}, // #1783
  {14,  1}, // #1784
  {16,  1}, // #1785
  {19,  1}, // #1786
  {22,  3}, // #1787
  { 1,  3}, // #1788
  {10, 10}, // #1789
  {14,  1}, // #1790
  {16,  1}, // #1791
  {19,  1}, // #1792
  {22,  3}, // #1793
  { 1,  3}, // #1794
  {10, 14}, // #1795
  {14,  1}, // #1796
  {16,  1}, // #1797
  {19,  1}, // #1798
  {22,  3}, // #1799
  { 1,  1}, // #1800
  {24,  1}, // #1801
  { 1,  1}, // #1802
  {13,  1}, // #1803
  {14,  2}, // #1804
  {16,  2}, // #1805
  {19,  2}, // #1806
  {24,  1}, // #1807
  { 5,  1}, // #1808
  { 6,  1}, // #1809
  { 8,  1}, // #1810
  {10,  3}, // #1811
  {14,  1}, // #1812
  {15,  1}, // #1813
  {19,  1}, // #1814
  {11,  2}, // #1815
  {14,  1}, // #1816
  {19,  1}, // #1817
  {10,  1}, // #1818
  {14,  1}, // #1819
  {19,  1}, // #1820
  {13,  1}, // #1821
  {14,  1}, // #1822
  {16,  1}, // #1823
  {19,  1}, // #1824
  { 1,  3}, // #1825
  {11,  2}, // #1826
  {14,  1}, // #1827
  {19,  1}, // #1828
  {22,  3}, // #1829
  { 1,  3}, // #1830
  {10,  5}, // #1831
  {14,  1}, // #1832
  {15,  1}, // #1833
  {19,  1}, // #1834
  {22,  3}, // #1835
  { 1,  3}, // #1836
  { 4, 17}, // #1837
  { 5,  1}, // #1838
  { 7,  1}, // #1839
  { 8,  1}, // #1840
  {22,  3}, // #1841
  { 1,  3}, // #1842
  { 4, 25}, // #1843
  { 5,  1}, // #1844
  { 7,  1}, // #1845
  { 8,  1}, // #1846
  {22,  3}, // #1847
  { 1,  3}, // #1848
  { 5,  1}, // #1849
  { 7,  1}, // #1850
  { 8,  1}, // #1851
  {22,  3}, // #1852
  {23,  5}, // #1853
  { 5,  1}, // #1854
  { 7,  1}, // #1855
  { 8,  1}, // #1856
  {23,  5}, // #1857
  { 1,  3}, // #1858
  { 5,  1}, // #1859
  { 7,  1}, // #1860
  { 8,  1}, // #1861
  {22,  3}, // #1862
  {23,  2}, // #1863
  { 5,  1}, // #1864
  { 7,  1}, // #1865
  { 8,  1}, // #1866
  {23,  2}, // #1867
  { 1,  3}, // #1868
  { 5,  1}, // #1869
  { 7,  1}, // #1870
  { 8,  1}, // #1871
  {22,  3}, // #1872
  {23,  4}, // #1873
  { 5,  1}, // #1874
  { 7,  1}, // #1875
  { 8,  1}, // #1876
  {23,  4}, // #1877
  { 1,  3}, // #1878
  { 5,  1}, // #1879
  { 7,  1}, // #1880
  { 8,  1}, // #1881
  {22,  3}, // #1882
  {23,  6}, // #1883
  { 5,  1}, // #1884
  { 7,  1}, // #1885
  { 8,  1}, // #1886
  {23,  6}, // #1887
  { 1,  3}, // #1888
  {11,  3}, // #1889
  {14,  1}, // #1890
  {19,  1}, // #1891
  {22,  3}, // #1892
  { 1,  1}, // #1893
  {22,  1}, // #1894
  { 1,  3}, // #1895
  { 5,  2}, // #1896
  { 6,  2}, // #1897
  { 8,  2}, // #1898
  {22,  3}, // #1899
  { 1,  1}, // #1900
  {13,  1}, // #1901
  {14,  1}, // #1902
  {16,  1}, // #1903
  {19,  1}, // #1904
  {24,  1}, // #1905
  { 1,  3}, // #1906
  {11,  1}, // #1907
  {14,  1}, // #1908
  {19,  1}, // #1909
  {22,  3}, // #1910
  { 1,  3}, // #1911
  {11,  4}, // #1912
  {14,  1}, // #1913
  {19,  1}, // #1914
  {22,  3}, // #1915
  { 1,  3}, // #1916
  {12,  4}, // #1917
  {14,  1}, // #1918
  {15,  1}, // #1919
  {19,  1}, // #1920
  {22,  3}, // #1921
  { 1,  3}, // #1922
  {10,  1}, // #1923
  {14,  1}, // #1924
  {16,  1}, // #1925
  {19,  1}, // #1926
  {22,  3}, // #1927
  { 1,  3}, // #1928
  {12,  7}, // #1929
  {14,  1}, // #1930
  {15,  1}, // #1931
  {19,  1}, // #1932
  {22,  3}, // #1933
  { 1, 23}, // #1934
  { 5,  1}, // #1935
  { 6,  1}, // #1936
  { 8,  1}, // #1937
  {10,  1}, // #1938
  {11, 10}, // #1939
  {14,  1}, // #1940
  {16,  1}, // #1941
  {19,  1}, // #1942
  {22, 13}, // #1943
  {24, 10}, // #1944
  { 1, 20}, // #1945
  { 5,  1}, // #1946
  { 6,  1}, // #1947
  { 8,  1}, // #1948
  {10,  1}, // #1949
  {11, 10}, // #1950
  {14,  1}, // #1951
  {16,  1}, // #1952
  {19,  1}, // #1953
  {22, 10}, // #1954
  {24, 10}, // #1955
  { 1,  3}, // #1956
  { 5,  1}, // #1957
  { 6,  1}, // #1958
  { 8,  1}, // #1959
  {10,  6}, // #1960
  {14,  1}, // #1961
  {16,  1}, // #1962
  {19,  1}, // #1963
  {22,  3}, // #1964
  { 1,  3}, // #1965
  { 5,  1}, // #1966
  { 6,  1}, // #1967
  { 8,  1}, // #1968
  {10,  8}, // #1969
  {14,  1}, // #1970
  {16,  1}, // #1971
  {19,  1}, // #1972
  {22,  3}, // #1973
  { 1,  3}, // #1974
  {11,  1}, // #1975
  {14,  1}, // #1976
  {15,  1}, // #1977
  {19,  1}, // #1978
  {22,  3}, // #1979
  { 1,  3}, // #1980
  {11,  1}, // #1981
  {12,  2}, // #1982
  {14,  3}, // #1983
  {15,  2}, // #1984
  {19,  3}, // #1985
  {22,  3}, // #1986
  { 1,  3}, // #1987
  {22,  2}, // #1988
  {24,  1}, // #1989
  { 1,  4}, // #1990
  { 5,  1}, // #1991
  { 8,  1}, // #1992
  {22,  3}, // #1993
  {24,  1}, // #1994
  { 1,  3}, // #1995
  {13,  1}, // #1996
  {14,  1}, // #1997
  {16,  1}, // #1998
  {19,  1}, // #1999
  {22,  3}, // #2000
  { 1,  3}, // #2001
  {10,  2}, // #2002
  {14,  1}, // #2003
  {16,  1}, // #2004
  {19,  1}, // #2005
  {22,  3}, // #2006
  { 1,  1}, // #2007
  { 5,  1}, // #2008
  { 8,  1}, // #2009
  {24,  1}, // #2010
  { 1,  1}, // #2011
  { 5, 22}, // #2012
  { 8, 22}, // #2013
  {22,  1}, // #2014
  {10, 18}, // #2015
  {14,  1}, // #2016
  {16,  1}, // #2017
  {19,  1}, // #2018
  { 1, 18}, // #2019
  {24, 18}, // #2020
  { 1,  3}, // #2021
  {10,  3}, // #2022
  {14,  1}, // #2023
  {22,  3}, // #2024
  { 1,  3}, // #2025
  {10,  2}, // #2026
  {14,  1}, // #2027
  {15,  1}, // #2028
  {19,  1}, // #2029
  {22,  3}, // #2030
  { 1,  3}, // #2031
  {10,  2}, // #2032
  {14,  2}, // #2033
  {19,  2}, // #2034
  {22,  3}, // #2035
  { 1,  3}, // #2036
  {10,  4}, // #2037
  {14,  2}, // #2038
  {19,  2}, // #2039
  {22,  3}, // #2040
  { 1,  3}, // #2041
  {10,  3}, // #2042
  {14,  2}, // #2043
  {19,  2}, // #2044
  {22,  3}, // #2045
  { 1,  3}, // #2046
  { 9,  2}, // #2047
  {10,  1}, // #2048
  {13,  1}, // #2049
  {14,  1}, // #2050
  {15,  1}, // #2051
  {19,  1}, // #2052
  {22,  3}, // #2053
  { 1,  1}, // #2054
  { 9,  2}, // #2055
  {10,  1}, // #2056
  {13,  1}, // #2057
  {14,  1}, // #2058
  {15,  1}, // #2059
  {19,  1}, // #2060
  {24,  1}, // #2061
  { 1,  1}, // #2062
  { 9,  2}, // #2063
  {13,  1}, // #2064
  {14,  1}, // #2065
  {15,  1}, // #2066
  {19,  1}, // #2067
  {24,  1}, // #2068
  { 1,  3}, // #2069
  {10, 18}, // #2070
  {14,  2}, // #2071
  {16,  2}, // #2072
  {19,  2}, // #2073
  {22,  3}, // #2074
  { 1,  3}, // #2075
  {10, 25}, // #2076
  {14,  2}, // #2077
  {16,  2}, // #2078
  {19,  2}, // #2079
  {22,  3}, // #2080
  { 1,  3}, // #2081
  {13,  1}, // #2082
  {14,  2}, // #2083
  {16,  2}, // #2084
  {19,  2}, // #2085
  {22,  3}, // #2086
  { 1,  3}, // #2087
  {10,  8}, // #2088
  {14,  1}, // #2089
  {15,  1}, // #2090
  {19,  1}, // #2091
  {22,  3}, // #2092
  { 1,  3}, // #2093
  {11,  3}, // #2094
  {14,  2}, // #2095
  {19,  2}, // #2096
  {22,  3}, // #2097
  { 1,  2}, // #2098
  {10, 376}, // #2099
  {14,  2}, // #2100
  {19,  2}, // #2101
  {24,  2}, // #2102
  { 1,  1}, // #2103
  {10, 188}, // #2104
  {14,  1}, // #2105
  {19,  1}, // #2106
  {24,  1}, // #2107
  { 1,  3}, // #2108
  {10,  4}, // #2109
  {14,  1}, // #2110
  {19,  1}, // #2111
  {22,  3}, // #2112
  { 1,  2}, // #2113
  {13,  2}, // #2114
  {14, 36}, // #2115
  {20, 36}, // #2116
  {24,  2}, // #2117
  {11,  2}, // #2118
  {14,  2}, // #2119
  {19,  2}, // #2120
  { 1,  3}, // #2121
  {11,  4}, // #2122
  {14,  2}, // #2123
  {19,  2}, // #2124
  {22,  3}, // #2125
  { 1,  2}, // #2126
  {13,  2}, // #2127
  {14,  2}, // #2128
  {16,  2}, // #2129
  {19,  2}, // #2130
  {24,  2}, // #2131
  { 1,  3}, // #2132
  { 5,  1}, // #2133
  { 6,  1}, // #2134
  { 8,  1}, // #2135
  {10,  4}, // #2136
  {14,  2}, // #2137
  {19,  2}, // #2138
  {22,  3}, // #2139
  { 1,  3}, // #2140
  {10,  1}, // #2141
  {14,  2}, // #2142
  {16,  2}, // #2143
  {19,  2}, // #2144
  {22,  3}, // #2145
  { 1,  3}, // #2146
  {10,  2}, // #2147
  {14,  2}, // #2148
  {16,  2}, // #2149
  {19,  2}, // #2150
  {22,  3}, // #2151
  { 1,  3}, // #2152
  { 5,  1}, // #2153
  { 6,  1}, // #2154
  { 8,  1}, // #2155
  {10,  4}, // #2156
  {14,  4}, // #2157
  {19,  4}, // #2158
  {22,  3}, // #2159
  { 9,  3}, // #2160
  {13,  1}, // #2161
  {14,  1}, // #2162
  {15,  1}, // #2163
  {19,  1}, // #2164
  { 5, 23}, // #2165
  { 7, 23}, // #2166
  { 8, 23}, // #2167
  { 5, 21}, // #2168
  { 7, 21}, // #2169
  { 8, 21}, // #2170
  { 5, 26}, // #2171
  { 7, 26}, // #2172
  { 8, 26}, // #2173
  { 5, 69}, // #2174
  { 7, 69}, // #2175
  { 8, 69}, // #2176
  { 5, 25}, // #2177
  { 8, 25}, // #2178
  { 1,  1}, // #2179
  {10,  4}, // #2180
  {14,  2}, // #2181
  {19,  2}, // #2182
  {22,  1}, // #2183
  { 5, 20}, // #2184
  { 7, 20}, // #2185
  { 8, 20}, // #2186
  { 1,  3}, // #2187
  {10, 10}, // #2188
  {14,  1}, // #2189
  {15,  1}, // #2190
  {19,  1}, // #2191
  {22,  3}, // #2192
  { 1,  3}, // #2193
  {10, 18}, // #2194
  {14,  1}, // #2195
  {15,  1}, // #2196
  {19,  1}, // #2197
  {22,  3}, // #2198
  { 5, 375}, // #2199
  { 8, 375}, // #2200
  { 5, 14}, // #2201
  { 8, 14}, // #2202
  { 5, 24}, // #2203
  { 8, 24}, // #2204
  {10,  6}, // #2205
  {14,  1}, // #2206
  {19,  1}, // #2207
  {10,  8}, // #2208
  {14,  1}, // #2209
  {19,  1}, // #2210
  { 5,  3}, // #2211
  { 8,  3}, // #2212
  { 5, 18}, // #2213
  { 8, 18}, // #2214
  { 5, 88}, // #2215
  { 8, 88}, // #2216
  { 1,  3}, // #2217
  { 5,  3}, // #2218
  { 8,  3}, // #2219
  {22,  3}, // #2220
  { 5, 10}, // #2221
  { 8, 10}, // #2222
  { 5, 12}, // #2223
  { 8, 12}, // #2224
  { 5, 17}, // #2225
  { 8, 17}, // #2226
  { 5,  5}, // #2227
  { 8,  5}, // #2228
  { 5, 23}, // #2229
  { 8, 23}, // #2230
  { 5, 20}, // #2231
  { 8, 20}, // #2232
  { 5, 19}, // #2233
  { 8, 19}, // #2234
  { 5, 13}, // #2235
  { 8, 13}, // #2236
  { 5, 21}, // #2237
  { 8, 21}, // #2238
  { 5, 15}, // #2239
  { 8, 15}, // #2240
  {13,  1}, // #2241
  {14, 10}, // #2242
  {16, 10}, // #2243
  {19, 10}, // #2244
  {13,  1}, // #2245
  {14,  3}, // #2246
  {16,  3}, // #2247
  {19,  3}, // #2248
  {13,  1}, // #2249
  {14,  4}, // #2250
  {16,  4}, // #2251
  {19,  4}, // #2252
  {11,  1}, // #2253
  {12,  1}, // #2254
  {14,  1}, // #2255
  {15,  1}, // #2256
  {19,  1}, // #2257
  { 3,  2}, // #2258
  { 8,  7}, // #2259
  {11,  2}, // #2260
  {12,  2}, // #2261
  {13,  9}, // #2262
  {14,  2}, // #2263
  {15,  7}, // #2264
  {17,  1}, // #2265
  {18,  7}, // #2266
  {19, 10}, // #2267
  {20,  9}, // #2268
  {21,  1}, // #2269
  {22, 10}, // #2270
  {23, 11}, // #2271
  { 3,  2}, // #2272
  { 8,  7}, // #2273
  {11,  2}, // #2274
  {12,  2}, // #2275
  {13,  9}, // #2276
  {14,  2}, // #2277
  {15,  7}, // #2278
  {18,  7}, // #2279
  {19, 11}, // #2280
  {20,  9}, // #2281
  {22, 11}, // #2282
  {23, 11}, // #2283
  { 3,  2}, // #2284
  { 4,  2}, // #2285
  { 8,  2}, // #2286
  {11,  4}, // #2287
  {12,  2}, // #2288
  {13,  4}, // #2289
  {14,  2}, // #2290
  {15,  4}, // #2291
  {16,  2}, // #2292
  {17,  1}, // #2293
  {18,  2}, // #2294
  {19,  6}, // #2295
  {20,  4}, // #2296
  {21,  1}, // #2297
  {22,  7}, // #2298
  {23,  8}, // #2299
  { 3,  7}, // #2300
  { 4,  7}, // #2301
  { 8,  3}, // #2302
  { 9,  3}, // #2303
  {11, 15}, // #2304
  {12,  7}, // #2305
  {13, 10}, // #2306
  {14, 10}, // #2307
  {15, 10}, // #2308
  {16, 10}, // #2309
  {18,  6}, // #2310
  {19, 18}, // #2311
  {20, 13}, // #2312
  {22, 32}, // #2313
  {23, 32}, // #2314
  { 2,  8}, // #2315
  { 3,  1}, // #2316
  {11,  1}, // #2317
  {12,  1}, // #2318
  {13,  1}, // #2319
  {14,  1}, // #2320
  {19,  1}, // #2321
  {20,  1}, // #2322
  {22,  1}, // #2323
  {23,  1}, // #2324
  { 2,  4}, // #2325
  { 3,  1}, // #2326
  {11,  1}, // #2327
  {12,  1}, // #2328
  {13,  1}, // #2329
  {14,  1}, // #2330
  {19,  1}, // #2331
  {20,  1}, // #2332
  {22,  1}, // #2333
  {23,  1}, // #2334
  { 3,  1}, // #2335
  { 4,  1}, // #2336
  { 8,  1}, // #2337
  {11,  2}, // #2338
  {12,  1}, // #2339
  {13,  2}, // #2340
  {14,  1}, // #2341
  {15,  2}, // #2342
  {16,  1}, // #2343
  {17,  1}, // #2344
  {18,  1}, // #2345
  {19,  3}, // #2346
  {20,  2}, // #2347
  {21,  1}, // #2348
  {22,  3}, // #2349
  {23,  4}, // #2350
  { 3,  1}, // #2351
  { 4,  1}, // #2352
  { 8,  1}, // #2353
  {11,  2}, // #2354
  {12,  1}, // #2355
  {13,  2}, // #2356
  {14,  1}, // #2357
  {15,  2}, // #2358
  {16,  1}, // #2359
  {18,  1}, // #2360
  {19,  3}, // #2361
  {20,  2}, // #2362
  {22,  3}, // #2363
  {23,  3}, // #2364
  { 3,  2}, // #2365
  { 4,  1}, // #2366
  { 8,  1}, // #2367
  {11,  3}, // #2368
  {12,  2}, // #2369
  {13,  3}, // #2370
  {14,  2}, // #2371
  {15,  2}, // #2372
  {16,  1}, // #2373
  {17,  1}, // #2374
  {18,  1}, // #2375
  {19,  4}, // #2376
  {20,  3}, // #2377
  {21,  1}, // #2378
  {22,  4}, // #2379
  {23,  5}, // #2380
  { 3,  2}, // #2381
  { 4,  1}, // #2382
  { 8,  1}, // #2383
  {11,  3}, // #2384
  {12,  2}, // #2385
  {13,  3}, // #2386
  {14,  2}, // #2387
  {15,  2}, // #2388
  {16,  1}, // #2389
  {18,  1}, // #2390
  {19,  4}, // #2391
  {20,  3}, // #2392
  {22,  4}, // #2393
  {23,  4}, // #2394
  {11,  8}, // #2395
  {15,  1}, // #2396
  {19, 30}, // #2397
  {22, 31}, // #2398
  {23, 31}, // #2399
  { 4,  1}, // #2400
  { 8,  2}, // #2401
  {11,  1}, // #2402
  {13,  2}, // #2403
  {15,  3}, // #2404
  {16,  1}, // #2405
  {17,  1}, // #2406
  {18,  2}, // #2407
  {19,  3}, // #2408
  {20,  2}, // #2409
  {21,  1}, // #2410
  {22,  3}, // #2411
  {23,  4}, // #2412
  { 4,  1}, // #2413
  { 8,  2}, // #2414
  {11,  1}, // #2415
  {13,  2}, // #2416
  {15,  3}, // #2417
  {16,  1}, // #2418
  {18,  2}, // #2419
  {19,  3}, // #2420
  {20,  2}, // #2421
  {22,  3}, // #2422
  {23,  3}, // #2423
  { 8,  2}, // #2424
  {13,  2}, // #2425
  {15,  3}, // #2426
  {17,  1}, // #2427
  {18,  2}, // #2428
  {19,  3}, // #2429
  {20,  2}, // #2430
  {21,  1}, // #2431
  {22,  3}, // #2432
  {23,  4}, // #2433
  { 8,  2}, // #2434
  {13,  2}, // #2435
  {15,  3}, // #2436
  {18,  2}, // #2437
  {19,  3}, // #2438
  {20,  2}, // #2439
  {22,  3}, // #2440
  {23,  3}, // #2441
  {14,  2}, // #2442
  {20,  2}, // #2443
  {22,  3}, // #2444
  {23,  3}, // #2445
  { 4,  2}, // #2446
  {11,  2}, // #2447
  {15,  2}, // #2448
  {16,  2}, // #2449
  {17,  1}, // #2450
  {19,  2}, // #2451
  {21,  1}, // #2452
  {22,  2}, // #2453
  {23,  3}, // #2454
  { 4,  1}, // #2455
  {11,  1}, // #2456
  {14,  1}, // #2457
  {15,  1}, // #2458
  {16,  1}, // #2459
  {17,  1}, // #2460
  {19,  1}, // #2461
  {20,  1}, // #2462
  {21,  2}, // #2463
  {22,  4}, // #2464
  {23,  6}, // #2465
  { 2, 14}, // #2466
  { 3,  1}, // #2467
  {11,  1}, // #2468
  {12,  1}, // #2469
  {13,  1}, // #2470
  {14,  1}, // #2471
  {17,  1}, // #2472
  {19,  1}, // #2473
  {20,  1}, // #2474
  {21,  1}, // #2475
  {22,  1}, // #2476
  {23,  2}, // #2477
  { 2, 14}, // #2478
  { 3,  1}, // #2479
  {11,  1}, // #2480
  {12,  1}, // #2481
  {13,  1}, // #2482
  {14,  1}, // #2483
  {19,  1}, // #2484
  {20,  1}, // #2485
  {22,  1}, // #2486
  {23,  1}, // #2487
  { 2,  7}, // #2488
  { 3,  1}, // #2489
  {11,  1}, // #2490
  {12,  1}, // #2491
  {13,  1}, // #2492
  {14,  1}, // #2493
  {17,  1}, // #2494
  {19,  1}, // #2495
  {20,  1}, // #2496
  {21,  1}, // #2497
  {22,  1}, // #2498
  {23,  2}, // #2499
  { 2,  9}, // #2500
  { 3,  1}, // #2501
  {11,  1}, // #2502
  {12,  1}, // #2503
  {13,  1}, // #2504
  {14,  1}, // #2505
  {19,  1}, // #2506
  {20,  1}, // #2507
  {22,  1}, // #2508
  {23,  1}, // #2509
  { 4,  1}, // #2510
  { 7,  1}, // #2511
  {11,  1}, // #2512
  {12,  1}, // #2513
  {15,  1}, // #2514
  {16,  1}, // #2515
  {19,  1}, // #2516
  {21,  1}, // #2517
  {22,  1}, // #2518
  {23,  3}, // #2519
  { 2, 16}, // #2520
  { 3,  2}, // #2521
  {11,  2}, // #2522
  {12,  2}, // #2523
  {13,  2}, // #2524
  {14,  2}, // #2525
  {17,  1}, // #2526
  {19,  3}, // #2527
  {20,  2}, // #2528
  {21,  1}, // #2529
  {22,  3}, // #2530
  {23,  4}, // #2531
  { 2, 16}, // #2532
  { 3,  2}, // #2533
  {11,  2}, // #2534
  {12,  2}, // #2535
  {13,  2}, // #2536
  {14,  2}, // #2537
  {19,  3}, // #2538
  {20,  2}, // #2539
  {22,  3}, // #2540
  {23,  3}, // #2541
  { 2, 10}, // #2542
  { 3,  2}, // #2543
  {11,  2}, // #2544
  {12,  2}, // #2545
  {13,  2}, // #2546
  {14,  2}, // #2547
  {17,  1}, // #2548
  {19,  3}, // #2549
  {20,  2}, // #2550
  {21,  1}, // #2551
  {22,  3}, // #2552
  {23,  4}, // #2553
  { 2, 10}, // #2554
  { 3,  2}, // #2555
  {11,  2}, // #2556
  {12,  2}, // #2557
  {13,  2}, // #2558
  {14,  2}, // #2559
  {19,  3}, // #2560
  {20,  2}, // #2561
  {22,  3}, // #2562
  {23,  3}, // #2563
  { 3,  1}, // #2564
  { 7,  1}, // #2565
  {11,  1}, // #2566
  {12,  2}, // #2567
  {13,  1}, // #2568
  {14,  1}, // #2569
  {15,  1}, // #2570
  {19,  2}, // #2571
  {20,  1}, // #2572
  {21,  1}, // #2573
  {22,  2}, // #2574
  {23,  4}, // #2575
  { 3,  2}, // #2576
  { 8,  1}, // #2577
  {11,  2}, // #2578
  {12,  2}, // #2579
  {13,  3}, // #2580
  {14,  2}, // #2581
  {15,  1}, // #2582
  {17,  1}, // #2583
  {18,  1}, // #2584
  {19,  3}, // #2585
  {20,  3}, // #2586
  {21,  1}, // #2587
  {22,  3}, // #2588
  {23,  4}, // #2589
  { 3,  2}, // #2590
  { 8,  1}, // #2591
  {11,  2}, // #2592
  {12,  2}, // #2593
  {13,  3}, // #2594
  {14,  2}, // #2595
  {15,  1}, // #2596
  {18,  1}, // #2597
  {19,  3}, // #2598
  {20,  3}, // #2599
  {22,  3}, // #2600
  {23,  3}, // #2601
  { 2, 28}, // #2602
  { 3,  2}, // #2603
  {11,  2}, // #2604
  {12,  2}, // #2605
  {13,  2}, // #2606
  {14,  2}, // #2607
  {17,  1}, // #2608
  {19,  3}, // #2609
  {20,  2}, // #2610
  {21,  1}, // #2611
  {22,  3}, // #2612
  {23,  4}, // #2613
  { 2, 28}, // #2614
  { 3,  2}, // #2615
  {11,  2}, // #2616
  {12,  2}, // #2617
  {13,  2}, // #2618
  {14,  2}, // #2619
  {19,  3}, // #2620
  {20,  2}, // #2621
  {22,  3}, // #2622
  {23,  3}, // #2623
  { 2, 14}, // #2624
  { 3,  2}, // #2625
  {11,  2}, // #2626
  {12,  2}, // #2627
  {13,  2}, // #2628
  {14,  2}, // #2629
  {17,  1}, // #2630
  {19,  3}, // #2631
  {20,  2}, // #2632
  {21,  1}, // #2633
  {22,  3}, // #2634
  {23,  4}, // #2635
  { 2, 14}, // #2636
  { 3,  2}, // #2637
  {11,  2}, // #2638
  {12,  2}, // #2639
  {13,  2}, // #2640
  {14,  2}, // #2641
  {19,  3}, // #2642
  {20,  2}, // #2643
  {22,  3}, // #2644
  {23,  3}, // #2645
  { 4,  2}, // #2646
  {11,  2}, // #2647
  {14,  3}, // #2648
  {15,  3}, // #2649
  {16,  2}, // #2650
  {17,  1}, // #2651
  {19,  3}, // #2652
  {20,  3}, // #2653
  {21,  2}, // #2654
  {22,  9}, // #2655
  {23, 11}, // #2656
  { 3,  2}, // #2657
  { 4,  1}, // #2658
  { 9,  4}, // #2659
  {11,  3}, // #2660
  {12,  2}, // #2661
  {13,  2}, // #2662
  {14,  6}, // #2663
  {15,  1}, // #2664
  {16,  5}, // #2665
  {18,  4}, // #2666
  {19,  3}, // #2667
  {20,  6}, // #2668
  {22, 12}, // #2669
  {23, 12}, // #2670
  { 3,  1}, // #2671
  { 4,  1}, // #2672
  {11,  2}, // #2673
  {12,  1}, // #2674
  {13,  1}, // #2675
  {14,  1}, // #2676
  {15,  1}, // #2677
  {16,  1}, // #2678
  {19,  2}, // #2679
  {20,  1}, // #2680
  {22,  2}, // #2681
  {23,  2}, // #2682
  { 7,  1}, // #2683
  {12,  1}, // #2684
  {17,  1}, // #2685
  {21,  2}, // #2686
  {22,  3}, // #2687
  {23,  6}, // #2688
  { 9,  1}, // #2689
  {14,  1}, // #2690
  {16,  1}, // #2691
  {18,  1}, // #2692
  {20,  1}, // #2693
  {22,  5}, // #2694
  {23,  5}, // #2695
  { 9,  2}, // #2696
  {14,  4}, // #2697
  {15,  1}, // #2698
  {16,  2}, // #2699
  {18,  2}, // #2700
  {19,  1}, // #2701
  {20,  4}, // #2702
  {22,  7}, // #2703
  {23,  7}, // #2704
  { 8,  6}, // #2705
  {11,  3}, // #2706
  {13,  6}, // #2707
  {15,  6}, // #2708
  {18,  6}, // #2709
  {19,  9}, // #2710
  {20,  6}, // #2711
  {22, 15}, // #2712
  {23, 15}, // #2713
  {11,  1}, // #2714
  {19,  2}, // #2715
  {22,  2}, // #2716
  {23,  2}, // #2717
  { 4,  2}, // #2718
  {11,  2}, // #2719
  {14,  3}, // #2720
  {15,  3}, // #2721
  {16,  2}, // #2722
  {19,  3}, // #2723
  {20,  3}, // #2724
  {22, 10}, // #2725
  {23, 10}, // #2726
  { 3,  1}, // #2727
  { 4,  1}, // #2728
  {11,  2}, // #2729
  {12,  1}, // #2730
  {13,  1}, // #2731
  {14,  1}, // #2732
  {15,  1}, // #2733
  {16,  1}, // #2734
  {17,  1}, // #2735
  {19,  2}, // #2736
  {20,  1}, // #2737
  {21,  1}, // #2738
  {22,  2}, // #2739
  {23,  3}, // #2740
  { 8,  1}, // #2741
  { 9,  1}, // #2742
  {13,  1}, // #2743
  {14,  1}, // #2744
  {15,  1}, // #2745
  {16,  1}, // #2746
  {18,  2}, // #2747
  {19,  1}, // #2748
  {20,  2}, // #2749
  {22,  2}, // #2750
  {23,  2}, // #2751
  {14,  1}, // #2752
  {17,  1}, // #2753
  {20,  1}, // #2754
  {21,  1}, // #2755
  {22,  4}, // #2756
  {23,  5}, // #2757
  { 8,  1}, // #2758
  {13,  1}, // #2759
  {15,  1}, // #2760
  {17,  1}, // #2761
  {18,  1}, // #2762
  {19,  2}, // #2763
  {20,  1}, // #2764
  {21,  1}, // #2765
  {22,  2}, // #2766
  {23,  3}, // #2767
  { 4,  2}, // #2768
  { 9,  2}, // #2769
  {11,  2}, // #2770
  {14,  2}, // #2771
  {15,  2}, // #2772
  {16,  4}, // #2773
  {17,  1}, // #2774
  {18,  2}, // #2775
  {19,  2}, // #2776
  {20,  2}, // #2777
  {21,  1}, // #2778
  {22,  7}, // #2779
  {23,  8}, // #2780
  { 4,  1}, // #2781
  {11,  1}, // #2782
  {14,  4}, // #2783
  {15,  2}, // #2784
  {16,  1}, // #2785
  {17,  1}, // #2786
  {19,  2}, // #2787
  {20,  4}, // #2788
  {21,  2}, // #2789
  {22,  8}, // #2790
  {23, 10}, // #2791
  { 4,  2}, // #2792
  {11,  2}, // #2793
  {14,  2}, // #2794
  {15,  2}, // #2795
  {16,  2}, // #2796
  {19,  2}, // #2797
  {20,  2}, // #2798
  {22,  7}, // #2799
  {23,  7}, // #2800
  { 4,  1}, // #2801
  {11,  1}, // #2802
  {14,  4}, // #2803
  {15,  2}, // #2804
  {16,  1}, // #2805
  {19,  2}, // #2806
  {20,  4}, // #2807
  {22,  9}, // #2808
  {23,  9}, // #2809
  { 9,  3}, // #2810
  {14,  3}, // #2811
  {16,  3}, // #2812
  {17,  1}, // #2813
  {18,  3}, // #2814
  {20,  3}, // #2815
  {21,  1}, // #2816
  {22, 18}, // #2817
  {23, 19}, // #2818
  { 7,  1}, // #2819
  { 9,  5}, // #2820
  {12,  1}, // #2821
  {14,  5}, // #2822
  {16,  5}, // #2823
  {17,  1}, // #2824
  {18,  5}, // #2825
  {20,  5}, // #2826
  {21,  2}, // #2827
  {22, 24}, // #2828
  {23, 27}, // #2829
  { 7,  1}, // #2830
  { 9,  6}, // #2831
  {12,  1}, // #2832
  {14,  6}, // #2833
  {16,  6}, // #2834
  {17,  1}, // #2835
  {18,  6}, // #2836
  {20,  6}, // #2837
  {21,  2}, // #2838
  {22, 25}, // #2839
  {23, 28}, // #2840
  { 3,  2}, // #2841
  {11,  4}, // #2842
  {12,  2}, // #2843
  {13,  3}, // #2844
  {14, 12}, // #2845
  {17,  8}, // #2846
  {19,  7}, // #2847
  {20, 13}, // #2848
  {21,  8}, // #2849
  {22, 56}, // #2850
  {23, 64}, // #2851
  { 3,  9}, // #2852
  { 4,  9}, // #2853
  { 7, 11}, // #2854
  { 8,  8}, // #2855
  { 9,  1}, // #2856
  {11, 18}, // #2857
  {12, 20}, // #2858
  {13, 17}, // #2859
  {14, 31}, // #2860
  {15, 17}, // #2861
  {16, 10}, // #2862
  {18,  9}, // #2863
  {19, 26}, // #2864
  {20, 39}, // #2865
  {21, 11}, // #2866
  {22, 78}, // #2867
  {23, 100}, // #2868
  { 7,  1}, // #2869
  { 8,  3}, // #2870
  {12,  1}, // #2871
  {13,  3}, // #2872
  {15,  3}, // #2873
  {17,  2}, // #2874
  {18,  3}, // #2875
  {19,  3}, // #2876
  {20,  3}, // #2877
  {21,  2}, // #2878
  {22,  4}, // #2879
  {23,  7}, // #2880
  { 7,  1}, // #2881
  { 8,  3}, // #2882
  {12,  1}, // #2883
  {13,  3}, // #2884
  {15,  3}, // #2885
  {17,  4}, // #2886
  {18,  3}, // #2887
  {19,  3}, // #2888
  {20,  3}, // #2889
  {21,  4}, // #2890
  {22,  4}, // #2891
  {23,  9}, // #2892
  { 7,  1}, // #2893
  { 8,  4}, // #2894
  {12,  1}, // #2895
  {13,  4}, // #2896
  {15,  4}, // #2897
  {17,  4}, // #2898
  {18,  4}, // #2899
  {19,  4}, // #2900
  {20,  4}, // #2901
  {21,  4}, // #2902
  {22,  5}, // #2903
  {23, 10}, // #2904
  { 7,  1}, // #2905
  { 8,  4}, // #2906
  {12,  1}, // #2907
  {13,  4}, // #2908
  {15,  4}, // #2909
  {17,  8}, // #2910
  {18,  4}, // #2911
  {19,  4}, // #2912
  {20,  4}, // #2913
  {21,  8}, // #2914
  {22,  5}, // #2915
  {23, 14}, // #2916
  { 7,  1}, // #2917
  { 8,  5}, // #2918
  {12,  1}, // #2919
  {13,  5}, // #2920
  {15,  5}, // #2921
  {17,  2}, // #2922
  {18,  5}, // #2923
  {19,  5}, // #2924
  {20,  5}, // #2925
  {21,  2}, // #2926
  {22,  6}, // #2927
  {23,  9}, // #2928
  { 9,  1}, // #2929
  {14,  1}, // #2930
  {16,  1}, // #2931
  {17,  1}, // #2932
  {18,  1}, // #2933
  {20,  1}, // #2934
  {21,  1}, // #2935
  {22, 17}, // #2936
  {23, 18}, // #2937
  {14,  1}, // #2938
  {17,  1}, // #2939
  {20,  1}, // #2940
  {21,  1}, // #2941
  {22,  2}, // #2942
  {23,  3}, // #2943
  { 9,  1}, // #2944
  {16,  1}, // #2945
  { 3,  3}, // #2946
  {11,  1}, // #2947
  {12,  2}, // #2948
  {14,  1}, // #2949
  { 8,  1}, // #2950
  { 9,  1}, // #2951
  {12,  1}, // #2952
  {14,  1}, // #2953
  {15,  1}, // #2954
  { 8,  2}, // #2955
  { 9,  2}, // #2956
  {12,  2}, // #2957
  {14,  2}, // #2958
  {15,  2}, // #2959
  { 3,  2}, // #2960
  {11,  1}, // #2961
  {12,  2}, // #2962
  {14,  1}, // #2963
  { 3,  2}, // #2964
  {11,  1}, // #2965
  {12,  1}, // #2966
  { 3,  1}, // #2967
  {11,  1}, // #2968
  {12,  2}, // #2969
  {14,  1}, // #2970
  { 5,  1}, // #2971
  { 7,  1}, // #2972
  { 9,  1}, // #2973
  {10,  1}, // #2974
  {11,  1}, // #2975
  {12,  1}, // #2976
  { 7,  1}, // #2977
  { 9,  2}, // #2978
  {11,  1}, // #2979
  {12,  1}, // #2980
  {16,  1}, // #2981
  {19,  1}, // #2982
  { 7,  1}, // #2983
  { 9,  2}, // #2984
  {16,  1}, // #2985
  {19,  1}, // #2986
  { 7,  1}, // #2987
  { 9,  1}, // #2988
  {11,  1}, // #2989
  {12,  1}, // #2990
  {19,  1}, // #2991
  { 7,  1}, // #2992
  { 9,  1}, // #2993
  {19,  1}, // #2994
  { 9,  4}, // #2995
  {10,  4}, // #2996
  {11,  1}, // #2997
  {12,  1}, // #2998
  { 3,  8}, // #2999
  {11,  1}, // #3000
  {12,  1}, // #3001
  { 1,  1}, // #3002
  { 3,  1}, // #3003
  { 5,  1}, // #3004
  { 7,  1}, // #3005
  { 9,  1}, // #3006
  {10,  1}, // #3007
  {11,  1}, // #3008
  {12,  1}, // #3009
  { 3,  4}, // #3010
  {11,  1}, // #3011
  {12,  1}, // #3012
  { 8,  1}, // #3013
  { 9,  1}, // #3014
  {11,  1}, // #3015
  {12,  1}, // #3016
  {15,  1}, // #3017
  { 8,  1}, // #3018
  { 9,  1}, // #3019
  {15,  1}, // #3020
  { 1,  1}, // #3021
  { 3,  1}, // #3022
  { 5,  1}, // #3023
  { 7,  1}, // #3024
  { 8,  1}, // #3025
  { 9,  2}, // #3026
  {10,  1}, // #3027
  {11,  1}, // #3028
  {12,  1}, // #3029
  {15,  1}, // #3030
  { 1,  1}, // #3031
  { 3,  1}, // #3032
  { 5,  1}, // #3033
  { 7,  1}, // #3034
  { 8,  1}, // #3035
  { 9,  2}, // #3036
  {10,  1}, // #3037
  {15,  1}, // #3038
  { 8,  1}, // #3039
  { 9,  1}, // #3040
  {11,  1}, // #3041
  {12,  1}, // #3042
  {15,  2}, // #3043
  { 8,  1}, // #3044
  { 9,  1}, // #3045
  {15,  2}, // #3046
  { 2,  1}, // #3047
  { 3,  1}, // #3048
  { 4, 17}, // #3049
  {11,  1}, // #3050
  {12,  1}, // #3051
  { 2,  1}, // #3052
  { 3,  1}, // #3053
  { 4, 25}, // #3054
  {11,  1}, // #3055
  {12,  1}, // #3056
  { 2,  1}, // #3057
  { 3,  1}, // #3058
  { 4, 41}, // #3059
  {11,  1}, // #3060
  {12,  1}, // #3061
  { 2,  1}, // #3062
  { 3,  1}, // #3063
  { 4, 12}, // #3064
  {11,  1}, // #3065
  {12,  1}, // #3066
  { 6, 19}, // #3067
  { 8,  1}, // #3068
  { 9,  1}, // #3069
  {10, 19}, // #3070
  {11,  1}, // #3071
  {12,  1}, // #3072
  { 5,  3}, // #3073
  { 6,  3}, // #3074
  { 8,  1}, // #3075
  { 9,  1}, // #3076
  {10,  6}, // #3077
  {11,  1}, // #3078
  {12,  1}, // #3079
  { 9,  1}, // #3080
  {11,  1}, // #3081
  {12,  1}, // #3082
  {16,  1}, // #3083
  { 2,  1}, // #3084
  { 3,  1}, // #3085
  {11,  1}, // #3086
  {12,  1}, // #3087
  {13,  3}, // #3088
  { 2,  1}, // #3089
  { 3,  1}, // #3090
  {13,  3}, // #3091
  { 2,  1}, // #3092
  { 3,  1}, // #3093
  {11,  1}, // #3094
  {12,  1}, // #3095
  {13,  1}, // #3096
  { 2,  1}, // #3097
  { 3,  1}, // #3098
  {11,  1}, // #3099
  {12,  1}, // #3100
  {13,  2}, // #3101
  { 2,  1}, // #3102
  { 3,  1}, // #3103
  {13,  1}, // #3104
  { 2,  1}, // #3105
  { 3,  1}, // #3106
  {13,  2}, // #3107
  { 2,  1}, // #3108
  { 3,  1}, // #3109
  {11,  1}, // #3110
  {12,  1}, // #3111
  {13,  4}, // #3112
  { 2,  1}, // #3113
  { 3,  1}, // #3114
  {13,  4}, // #3115
  { 7,  1}, // #3116
  { 9,  1}, // #3117
  {11,  1}, // #3118
  {12,  1}, // #3119
  {19,  2}, // #3120
  { 7,  1}, // #3121
  { 9,  1}, // #3122
  {19,  2}, // #3123
  { 6,  2}, // #3124
  { 8,  1}, // #3125
  { 9,  1}, // #3126
  {10,  2}, // #3127
  {11,  1}, // #3128
  {12,  1}, // #3129
  { 6,  1}, // #3130
  { 8,  1}, // #3131
  { 9,  1}, // #3132
  {10,  1}, // #3133
  {11,  1}, // #3134
  {12,  1}, // #3135
  { 9,  4}, // #3136
  {11,  1}, // #3137
  {12,  1}, // #3138
  {16,  4}, // #3139
  { 9,  4}, // #3140
  {16,  4}, // #3141
  { 1,  1}, // #3142
  { 3,  1}, // #3143
  { 5,  1}, // #3144
  { 8,  1}, // #3145
  { 9,  1}, // #3146
  {10,  1}, // #3147
  {11,  3}, // #3148
  {12,  5}, // #3149
  {14,  2}, // #3150
  {16, 10}, // #3151
  {18,  4}, // #3152
  { 1,  1}, // #3153
  { 3,  1}, // #3154
  { 5,  1}, // #3155
  { 8,  1}, // #3156
  { 9,  1}, // #3157
  {10,  1}, // #3158
  {11,  2}, // #3159
  {12,  4}, // #3160
  {14,  2}, // #3161
  {16, 10}, // #3162
  {18,  4}, // #3163
  { 1,  1}, // #3164
  { 3,  1}, // #3165
  { 5,  1}, // #3166
  { 7,  1}, // #3167
  { 8,  2}, // #3168
  { 9,  3}, // #3169
  {10,  1}, // #3170
  {11,  1}, // #3171
  {12,  1}, // #3172
  {16,  2}, // #3173
  {18,  2}, // #3174
  { 1,  1}, // #3175
  { 3,  1}, // #3176
  { 5,  1}, // #3177
  { 7,  1}, // #3178
  { 8,  2}, // #3179
  { 9,  3}, // #3180
  {10,  1}, // #3181
  {16,  2}, // #3182
  {18,  2}, // #3183
  { 7,  2}, // #3184
  { 9,  3}, // #3185
  {11,  1}, // #3186
  {12,  1}, // #3187
  {16,  1}, // #3188
  {19,  2}, // #3189
  { 7,  2}, // #3190
  { 9,  3}, // #3191
  {16,  1}, // #3192
  {19,  2}, // #3193
  { 9,  1}, // #3194
  {11,  1}, // #3195
  {12,  1}, // #3196
  {16,  4}, // #3197
  { 9,  1}, // #3198
  {16,  4}, // #3199
  { 3,  1}, // #3200
  {12,  1}, // #3201
  {14,  1}, // #3202
  { 3, 22}, // #3203
  {11,  1}, // #3204
  {12,  1}, // #3205
  { 6, 27}, // #3206
  { 8,  1}, // #3207
  { 9,  1}, // #3208
  {10, 27}, // #3209
  {11,  1}, // #3210
  {12,  1}, // #3211
  { 6, 21}, // #3212
  { 8,  1}, // #3213
  { 9,  1}, // #3214
  {10, 21}, // #3215
  {11,  1}, // #3216
  {12,  1}, // #3217
  { 6, 35}, // #3218
  { 8,  1}, // #3219
  { 9,  1}, // #3220
  {10, 35}, // #3221
  { 5,  2}, // #3222
  { 7,  2}, // #3223
  { 9,  2}, // #3224
  {10,  2}, // #3225
  {11,  2}, // #3226
  {12,  2}, // #3227
  { 9,  6}, // #3228
  {10,  6}, // #3229
  {11,  2}, // #3230
  {12,  2}, // #3231
  { 9,  2}, // #3232
  {10,  2}, // #3233
  {11,  1}, // #3234
  {12,  1}, // #3235
  { 8,  2}, // #3236
  { 9,  2}, // #3237
  {11,  2}, // #3238
  {12,  2}, // #3239
  {15,  2}, // #3240
  { 8,  2}, // #3241
  { 9,  2}, // #3242
  {15,  2}, // #3243
  { 8,  2}, // #3244
  { 9,  2}, // #3245
  {10,  4}, // #3246
  {11,  2}, // #3247
  {12,  2}, // #3248
  {15,  2}, // #3249
  { 8,  2}, // #3250
  { 9,  2}, // #3251
  {10,  4}, // #3252
  {15,  2}, // #3253
  { 8,  2}, // #3254
  { 9,  2}, // #3255
  {10,  2}, // #3256
  {12,  1}, // #3257
  {14,  1}, // #3258
  {15,  2}, // #3259
  { 8,  2}, // #3260
  { 9,  2}, // #3261
  {10,  2}, // #3262
  {15,  2}, // #3263
  { 6, 38}, // #3264
  { 8,  2}, // #3265
  { 9,  2}, // #3266
  {10, 38}, // #3267
  {11,  2}, // #3268
  {12,  2}, // #3269
  { 5,  6}, // #3270
  { 6,  6}, // #3271
  { 8,  2}, // #3272
  { 9,  2}, // #3273
  {10, 12}, // #3274
  {11,  2}, // #3275
  {12,  2}, // #3276
  { 3,  4}, // #3277
  { 5,  1}, // #3278
  { 7,  1}, // #3279
  { 8,  4}, // #3280
  { 9,  5}, // #3281
  {10,  1}, // #3282
  {11,  4}, // #3283
  {12,  8}, // #3284
  {14,  4}, // #3285
  {15,  4}, // #3286
  { 9,  4}, // #3287
  {10,  4}, // #3288
  {11,  2}, // #3289
  {12,  2}, // #3290
  { 3,  2}, // #3291
  { 5,  1}, // #3292
  { 7,  1}, // #3293
  { 8,  2}, // #3294
  { 9,  3}, // #3295
  {10,  1}, // #3296
  {11,  2}, // #3297
  {12,  4}, // #3298
  {14,  2}, // #3299
  {15,  2}, // #3300
  { 3,  8}, // #3301
  { 5,  1}, // #3302
  { 7,  1}, // #3303
  { 8, 10}, // #3304
  { 9, 11}, // #3305
  {10,  1}, // #3306
  {11,  8}, // #3307
  {12, 16}, // #3308
  {14,  8}, // #3309
  {15, 10}, // #3310
  { 3,  4}, // #3311
  { 5,  1}, // #3312
  { 7,  1}, // #3313
  { 8,  5}, // #3314
  { 9,  6}, // #3315
  {10,  1}, // #3316
  {11,  4}, // #3317
  {12,  8}, // #3318
  {14,  4}, // #3319
  {15,  5}, // #3320
  { 9,  2}, // #3321
  {16,  2}, // #3322
  { 6,  4}, // #3323
  { 8,  2}, // #3324
  { 9,  2}, // #3325
  {10,  4}, // #3326
  {11,  2}, // #3327
  {12,  2}, // #3328
  { 6,  2}, // #3329
  { 8,  2}, // #3330
  { 9,  2}, // #3331
  {10,  2}, // #3332
  {11,  2}, // #3333
  {12,  2}, // #3334
  { 9,  2}, // #3335
  {10,  6}, // #3336
  {11,  2}, // #3337
  {12,  2}, // #3338
  { 9,  1}, // #3339
  {10,  4}, // #3340
  {11,  1}, // #3341
  {12,  1}, // #3342
  { 9,  4}, // #3343
  {11,  2}, // #3344
  {12,  2}, // #3345
  {16,  4}, // #3346
  { 9,  2}, // #3347
  {11,  1}, // #3348
  {12,  1}, // #3349
  {16,  2}, // #3350
  { 1,  1}, // #3351
  { 3,  1}, // #3352
  { 5,  2}, // #3353
  { 9,  2}, // #3354
  {10,  4}, // #3355
  {11,  2}, // #3356
  {12,  2}, // #3357
  { 6, 54}, // #3358
  { 8,  2}, // #3359
  { 9,  2}, // #3360
  {10, 54}, // #3361
  {11,  2}, // #3362
  {12,  2}, // #3363
  { 6, 42}, // #3364
  { 8,  2}, // #3365
  { 9,  2}, // #3366
  {10, 42}, // #3367
  {11,  2}, // #3368
  {12,  2}, // #3369
  { 3,  2}, // #3370
  {11, 16}, // #3371
  {12, 32}, // #3372
  {14, 16}, // #3373
  { 9,  2}, // #3374
  {10,  4}, // #3375
  {11,  1}, // #3376
  {12,  1}, // #3377
  { 3, 42}, // #3378
  { 5,  1}, // #3379
  { 7,  1}, // #3380
  { 8,  2}, // #3381
  { 9,  3}, // #3382
  {10,  1}, // #3383
  {11,  2}, // #3384
  {12, 18}, // #3385
  {14, 16}, // #3386
  {15,  2}, // #3387
  { 3,  3}, // #3388
  {11, 19}, // #3389
  {12, 38}, // #3390
  {14, 19}, // #3391
  { 3,  6}, // #3392
  {11, 38}, // #3393
  {12, 76}, // #3394
  {14, 38}, // #3395
  { 3,  3}, // #3396
  {11, 16}, // #3397
  {12, 32}, // #3398
  {14, 16}, // #3399
  { 3,  3}, // #3400
  {11, 17}, // #3401
  {12, 34}, // #3402
  {14, 17}, // #3403
  { 3,  6}, // #3404
  {11,  1}, // #3405
  {12,  2}, // #3406
  {14,  1}, // #3407
  { 3,  1}, // #3408
  {11, 19}, // #3409
  {12, 38}, // #3410
  {14, 19}, // #3411
  { 2,  1}, // #3412
  { 3,  1}, // #3413
  {12,  1}, // #3414
  {14,  1}, // #3415
  { 8,  1}, // #3416
  {13,  1}, // #3417
  {15,  1}, // #3418
  {17,  1}, // #3419
  {18,  1}, // #3420
  {19,  3}, // #3421
  {20,  1}, // #3422
  {21,  1}, // #3423
  {22,  3}, // #3424
  {23,  4}, // #3425
  { 8,  1}, // #3426
  {13,  1}, // #3427
  {15,  1}, // #3428
  {18,  1}, // #3429
  {19,  3}, // #3430
  {20,  1}, // #3431
  {22,  3}, // #3432
  {23,  3}, // #3433
  { 8,  1}, // #3434
  {13,  1}, // #3435
  {15,  1}, // #3436
  {17,  1}, // #3437
  {18,  1}, // #3438
  {19,  4}, // #3439
  {20,  1}, // #3440
  {21,  1}, // #3441
  {22,  4}, // #3442
  {23,  5}, // #3443
  { 8,  1}, // #3444
  {13,  1}, // #3445
  {15,  1}, // #3446
  {18,  1}, // #3447
  {19,  4}, // #3448
  {20,  1}, // #3449
  {22,  4}, // #3450
  {23,  4}, // #3451
  {13,  2}, // #3452
  {17,  1}, // #3453
  {19,  2}, // #3454
  {20,  2}, // #3455
  {21,  1}, // #3456
  {22,  2}, // #3457
  {23,  3}, // #3458
  { 7,  1}, // #3459
  { 8,  1}, // #3460
  {12,  1}, // #3461
  {13,  2}, // #3462
  {15,  1}, // #3463
  {18,  1}, // #3464
  {19,  2}, // #3465
  {20,  2}, // #3466
  {21,  1}, // #3467
  {22,  2}, // #3468
  {23,  4}, // #3469
  { 8,  1}, // #3470
  {13,  2}, // #3471
  {15,  1}, // #3472
  {18,  1}, // #3473
  {19,  2}, // #3474
  {20,  2}, // #3475
  {22,  2}, // #3476
  {23,  2}, // #3477
  { 2, 16}, // #3478
  { 3,  2}, // #3479
  { 8,  1}, // #3480
  {11,  2}, // #3481
  {12,  2}, // #3482
  {13,  3}, // #3483
  {14,  2}, // #3484
  {15,  1}, // #3485
  {17,  1}, // #3486
  {18,  1}, // #3487
  {19,  3}, // #3488
  {20,  3}, // #3489
  {21,  1}, // #3490
  {22,  3}, // #3491
  {23,  4}, // #3492
  { 2, 16}, // #3493
  { 3,  2}, // #3494
  { 8,  1}, // #3495
  {11,  2}, // #3496
  {12,  2}, // #3497
  {13,  3}, // #3498
  {14,  2}, // #3499
  {15,  1}, // #3500
  {18,  1}, // #3501
  {19,  3}, // #3502
  {20,  3}, // #3503
  {22,  3}, // #3504
  {23,  3}, // #3505
  { 2, 10}, // #3506
  { 3,  2}, // #3507
  { 8,  1}, // #3508
  {11,  2}, // #3509
  {12,  2}, // #3510
  {13,  3}, // #3511
  {14,  2}, // #3512
  {15,  1}, // #3513
  {17,  1}, // #3514
  {18,  1}, // #3515
  {19,  3}, // #3516
  {20,  3}, // #3517
  {21,  1}, // #3518
  {22,  3}, // #3519
  {23,  4}, // #3520
  { 2, 10}, // #3521
  { 3,  2}, // #3522
  { 8,  1}, // #3523
  {11,  2}, // #3524
  {12,  2}, // #3525
  {13,  3}, // #3526
  {14,  2}, // #3527
  {15,  1}, // #3528
  {18,  1}, // #3529
  {19,  3}, // #3530
  {20,  3}, // #3531
  {22,  3}, // #3532
  {23,  3}, // #3533
  { 2, 24}, // #3534
  { 3,  2}, // #3535
  { 8,  1}, // #3536
  {11,  2}, // #3537
  {12,  2}, // #3538
  {13,  3}, // #3539
  {14,  2}, // #3540
  {15,  1}, // #3541
  {17,  1}, // #3542
  {18,  1}, // #3543
  {19,  3}, // #3544
  {20,  3}, // #3545
  {21,  1}, // #3546
  {22,  3}, // #3547
  {23,  4}, // #3548
  { 2, 24}, // #3549
  { 3,  2}, // #3550
  { 8,  1}, // #3551
  {11,  2}, // #3552
  {12,  2}, // #3553
  {13,  3}, // #3554
  {14,  2}, // #3555
  {15,  1}, // #3556
  {18,  1}, // #3557
  {19,  3}, // #3558
  {20,  3}, // #3559
  {22,  3}, // #3560
  {23,  3}, // #3561
  { 2, 12}, // #3562
  { 3,  2}, // #3563
  { 8,  1}, // #3564
  {11,  2}, // #3565
  {12,  2}, // #3566
  {13,  3}, // #3567
  {14,  2}, // #3568
  {15,  1}, // #3569
  {17,  1}, // #3570
  {18,  1}, // #3571
  {19,  3}, // #3572
  {20,  3}, // #3573
  {21,  1}, // #3574
  {22,  3}, // #3575
  {23,  4}, // #3576
  { 2, 12}, // #3577
  { 3,  2}, // #3578
  { 8,  1}, // #3579
  {11,  2}, // #3580
  {12,  2}, // #3581
  {13,  3}, // #3582
  {14,  2}, // #3583
  {15,  1}, // #3584
  {18,  1}, // #3585
  {19,  3}, // #3586
  {20,  3}, // #3587
  {22,  3}, // #3588
  {23,  3}, // #3589
  { 3,  1}, // #3590
  { 8,  1}, // #3591
  {11,  1}, // #3592
  {12,  1}, // #3593
  {13,  2}, // #3594
  {14,  1}, // #3595
  {15,  1}, // #3596
  {18,  1}, // #3597
  {19,  3}, // #3598
  {20,  2}, // #3599
  {22,  3}, // #3600
  {23,  3}, // #3601
  { 3,  1}, // #3602
  { 8,  1}, // #3603
  {11,  1}, // #3604
  {12,  1}, // #3605
  {13,  2}, // #3606
  {14,  1}, // #3607
  {15,  1}, // #3608
  {17,  1}, // #3609
  {18,  1}, // #3610
  {19,  3}, // #3611
  {20,  2}, // #3612
  {21,  1}, // #3613
  {22,  3}, // #3614
  {23,  4}, // #3615
  { 4,  1}, // #3616
  { 9,  5}, // #3617
  {11,  1}, // #3618
  {13,  4}, // #3619
  {14,  5}, // #3620
  {15,  1}, // #3621
  {16,  6}, // #3622
  {18,  5}, // #3623
  {19,  5}, // #3624
  {20,  9}, // #3625
  {22, 10}, // #3626
  {23, 10}, // #3627
  { 7,  2}, // #3628
  {12,  2}, // #3629
  {15,  1}, // #3630
  {19,  1}, // #3631
  {21,  2}, // #3632
  {22,  1}, // #3633
  {23,  5}, // #3634
  { 7,  1}, // #3635
  {12,  1}, // #3636
  {19,  1}, // #3637
  {21,  1}, // #3638
  {22,  1}, // #3639
  {23,  3}, // #3640
  { 7,  1}, // #3641
  { 8,  2}, // #3642
  {12,  1}, // #3643
  {13,  2}, // #3644
  {15,  2}, // #3645
  {18,  2}, // #3646
  {19,  2}, // #3647
  {20,  2}, // #3648
  {21,  1}, // #3649
  {22,  2}, // #3650
  {23,  4}, // #3651
  { 8,  1}, // #3652
  {13,  1}, // #3653
  {15,  1}, // #3654
  {17,  1}, // #3655
  {18,  1}, // #3656
  {19,  1}, // #3657
  {20,  1}, // #3658
  {21,  1}, // #3659
  {22,  2}, // #3660
  {23,  3}, // #3661
  { 3,  1}, // #3662
  { 7,  2}, // #3663
  {11,  1}, // #3664
  {12,  3}, // #3665
  {13,  1}, // #3666
  {14,  1}, // #3667
  {19,  1}, // #3668
  {20,  1}, // #3669
  {21,  2}, // #3670
  {22,  3}, // #3671
  {23,  7}, // #3672
  { 3,  1}, // #3673
  { 7,  4}, // #3674
  {11,  1}, // #3675
  {12,  5}, // #3676
  {13,  1}, // #3677
  {14,  1}, // #3678
  {19,  1}, // #3679
  {20,  1}, // #3680
  {21,  4}, // #3681
  {22,  3}, // #3682
  {23, 11}, // #3683
  { 3,  1}, // #3684
  { 7,  8}, // #3685
  {11,  1}, // #3686
  {12,  9}, // #3687
  {13,  1}, // #3688
  {14,  1}, // #3689
  {19,  1}, // #3690
  {20,  1}, // #3691
  {21,  8}, // #3692
  {22,  3}, // #3693
  {23, 19}, // #3694
  { 3,  1}, // #3695
  { 7, 16}, // #3696
  { 8,  1}, // #3697
  {11,  1}, // #3698
  {12, 17}, // #3699
  {13,  2}, // #3700
  {14,  1}, // #3701
  {15,  1}, // #3702
  {18,  1}, // #3703
  {19,  2}, // #3704
  {20,  2}, // #3705
  {21, 16}, // #3706
  {22,  4}, // #3707
  {23, 36}, // #3708
  { 3,  1}, // #3709
  { 7,  2}, // #3710
  { 8,  1}, // #3711
  {11,  1}, // #3712
  {12,  3}, // #3713
  {13,  2}, // #3714
  {14,  1}, // #3715
  {15,  1}, // #3716
  {18,  1}, // #3717
  {19,  2}, // #3718
  {20,  2}, // #3719
  {21,  2}, // #3720
  {22,  4}, // #3721
  {23,  8}, // #3722
  { 3,  1}, // #3723
  { 7,  4}, // #3724
  { 8,  1}, // #3725
  {11,  1}, // #3726
  {12,  5}, // #3727
  {13,  2}, // #3728
  {14,  1}, // #3729
  {15,  1}, // #3730
  {18,  1}, // #3731
  {19,  2}, // #3732
  {20,  2}, // #3733
  {21,  4}, // #3734
  {22,  4}, // #3735
  {23, 12}, // #3736
  { 3,  1}, // #3737
  { 7,  8}, // #3738
  { 8,  1}, // #3739
  {11,  1}, // #3740
  {12,  9}, // #3741
  {13,  2}, // #3742
  {14,  1}, // #3743
  {15,  1}, // #3744
  {18,  1}, // #3745
  {19,  2}, // #3746
  {20,  2}, // #3747
  {21,  8}, // #3748
  {22,  4}, // #3749
  {23, 20}, // #3750
  {11,  3}, // #3751
  {19,  3}, // #3752
  {22,  3}, // #3753
  {23,  3}, // #3754
  {13,  3}, // #3755
  {19,  3}, // #3756
  {20,  3}, // #3757
  {22,  3}, // #3758
  {23,  3}, // #3759
  { 3,  1}, // #3760
  {11,  1}, // #3761
  {12,  1}, // #3762
  {13,  1}, // #3763
  {14,  1}, // #3764
  {17,  1}, // #3765
  {19,  2}, // #3766
  {20,  1}, // #3767
  {21,  1}, // #3768
  {22,  2}, // #3769
  {23,  3}, // #3770
  { 4,  1}, // #3771
  { 8,  2}, // #3772
  {11,  3}, // #3773
  {13,  2}, // #3774
  {15,  3}, // #3775
  {16,  1}, // #3776
  {17,  1}, // #3777
  {18,  2}, // #3778
  {19,  7}, // #3779
  {20,  2}, // #3780
  {21,  1}, // #3781
  {22,  7}, // #3782
  {23,  8}, // #3783
  {11,  3}, // #3784
  {17,  1}, // #3785
  {19,  3}, // #3786
  {21,  1}, // #3787
  {22,  3}, // #3788
  {23,  4}, // #3789
  {13,  3}, // #3790
  {17,  1}, // #3791
  {19,  3}, // #3792
  {20,  3}, // #3793
  {21,  1}, // #3794
  {22,  3}, // #3795
  {23,  4}, // #3796
  { 3,  1}, // #3797
  {11,  1}, // #3798
  {12,  1}, // #3799
  {13,  1}, // #3800
  {14,  1}, // #3801
  {17,  2}, // #3802
  {19,  2}, // #3803
  {20,  1}, // #3804
  {21,  2}, // #3805
  {22,  3}, // #3806
  {23,  5}, // #3807
  { 3,  1}, // #3808
  {11,  1}, // #3809
  {12,  1}, // #3810
  {13,  1}, // #3811
  {14,  1}, // #3812
  {17,  4}, // #3813
  {19,  2}, // #3814
  {20,  1}, // #3815
  {21,  4}, // #3816
  {22,  3}, // #3817
  {23,  7}, // #3818
  { 3,  1}, // #3819
  {11,  1}, // #3820
  {12,  1}, // #3821
  {13,  1}, // #3822
  {14,  1}, // #3823
  {17,  8}, // #3824
  {19,  2}, // #3825
  {20,  1}, // #3826
  {21,  8}, // #3827
  {22,  3}, // #3828
  {23, 11}, // #3829
  { 3,  1}, // #3830
  {11,  1}, // #3831
  {12,  1}, // #3832
  {13,  1}, // #3833
  {14,  1}, // #3834
  {17, 16}, // #3835
  {19,  2}, // #3836
  {20,  1}, // #3837
  {21, 16}, // #3838
  {22,  3}, // #3839
  {23, 19}, // #3840
  { 8,  5}, // #3841
  {11,  5}, // #3842
  {13,  5}, // #3843
  {15,  5}, // #3844
  {18,  5}, // #3845
  {19, 14}, // #3846
  {20,  5}, // #3847
  {22, 14}, // #3848
  {23, 14}, // #3849
  { 8,  5}, // #3850
  {11,  5}, // #3851
  {13,  5}, // #3852
  {15,  5}, // #3853
  {17,  1}, // #3854
  {18,  5}, // #3855
  {19, 14}, // #3856
  {20,  5}, // #3857
  {21,  1}, // #3858
  {22, 14}, // #3859
  {23, 15}, // #3860
  { 8,  9}, // #3861
  {11,  7}, // #3862
  {13,  9}, // #3863
  {15,  9}, // #3864
  {18,  9}, // #3865
  {19, 21}, // #3866
  {20,  9}, // #3867
  {22, 21}, // #3868
  {23, 21}, // #3869
  { 8,  9}, // #3870
  {11,  7}, // #3871
  {13,  9}, // #3872
  {15,  9}, // #3873
  {17,  1}, // #3874
  {18,  9}, // #3875
  {19, 21}, // #3876
  {20,  9}, // #3877
  {21,  1}, // #3878
  {22, 21}, // #3879
  {23, 22}, // #3880
  { 8, 17}, // #3881
  {11, 11}, // #3882
  {13, 17}, // #3883
  {15, 17}, // #3884
  {18, 17}, // #3885
  {19, 35}, // #3886
  {20, 17}, // #3887
  {22, 35}, // #3888
  {23, 35}, // #3889
  { 8, 17}, // #3890
  {11, 11}, // #3891
  {13, 17}, // #3892
  {15, 17}, // #3893
  {17,  1}, // #3894
  {18, 17}, // #3895
  {19, 35}, // #3896
  {20, 17}, // #3897
  {21,  1}, // #3898
  {22, 35}, // #3899
  {23, 36}, // #3900
  { 4,  1}, // #3901
  { 7,  1}, // #3902
  { 9,  1}, // #3903
  {11,  1}, // #3904
  {12,  1}, // #3905
  { 6,  1}, // #3906
  { 8,  1}, // #3907
  { 9,  1}, // #3908
  {11,  1}, // #3909
  {12,  1}, // #3910
  { 5,  1}, // #3911
  { 6,  2}, // #3912
  { 8,  2}, // #3913
  { 9,  2}, // #3914
  {10,  2}, // #3915
  {11,  3}, // #3916
  {12,  6}, // #3917
  { 6,  1}, // #3918
  { 8,  1}, // #3919
  { 9,  1}, // #3920
  {10,  1}, // #3921
  {11,  1}, // #3922
  {12,  2}, // #3923
  { 5,  1}, // #3924
  {10,  1}, // #3925
  {12,  2}, // #3926
  {10,  1}, // #3927
  {12,  1}, // #3928
  { 5,  1}, // #3929
  {10,  2}, // #3930
  {11,  3}, // #3931
  {12,  6}, // #3932
  { 8,  1}, // #3933
  {10,  1}, // #3934
  {11,  2}, // #3935
  {12,  3}, // #3936
  { 5,  1}, // #3937
  {10,  2}, // #3938
  {11,  1}, // #3939
  {12,  4}, // #3940
  { 4,  1}, // #3941
  { 7,  1}, // #3942
  { 9,  1}, // #3943
  {10,  1}, // #3944
  {11,  1}, // #3945
  {12,  2}, // #3946
  { 6,  1}, // #3947
  { 8,  1}, // #3948
  { 9,  1}, // #3949
  {10,  1}, // #3950
  {11,  2}, // #3951
  {12,  3}, // #3952
  { 6,  1}, // #3953
  { 8,  1}, // #3954
  { 9,  1}, // #3955
  {11,  2}, // #3956
  {12,  2}, // #3957
  { 6,  2}, // #3958
  { 8,  2}, // #3959
  { 9,  2}, // #3960
  {10,  1}, // #3961
  {11,  2}, // #3962
  {12,  3}, // #3963
  { 6,  2}, // #3964
  { 8,  2}, // #3965
  { 9,  2}, // #3966
  {11,  2}, // #3967
  {12,  2}, // #3968
  {10,  1}, // #3969
  {11, 10}, // #3970
  {12, 11}, // #3971
  {11, 11}, // #3972
  {12, 11}, // #3973
  { 4,  1}, // #3974
  { 7,  1}, // #3975
  { 8,  1}, // #3976
  { 9,  1}, // #3977
  {10,  1}, // #3978
  {11,  2}, // #3979
  {12,  3}, // #3980
  { 4,  1}, // #3981
  { 7,  1}, // #3982
  { 8,  1}, // #3983
  { 9,  1}, // #3984
  {11,  2}, // #3985
  {12,  2}, // #3986
  { 8,  1}, // #3987
  {10,  1}, // #3988
  {11,  1}, // #3989
  {12,  2}, // #3990
  { 8,  2}, // #3991
  {10,  1}, // #3992
  {11,  2}, // #3993
  {12,  3}, // #3994
  { 8,  2}, // #3995
  {11,  2}, // #3996
  {12,  2}, // #3997
  { 5,  1}, // #3998
  { 6,  1}, // #3999
  { 8,  2}, // #4000
  { 9,  1}, // #4001
  {10,  2}, // #4002
  {11,  3}, // #4003
  {12,  6}, // #4004
  { 5,  1}, // #4005
  { 8,  1}, // #4006
  {10,  2}, // #4007
  {11,  1}, // #4008
  {12,  4}, // #4009
  { 6,  2}, // #4010
  { 8,  3}, // #4011
  { 9,  2}, // #4012
  {11,  3}, // #4013
  {12,  3}, // #4014
  { 8,  1}, // #4015
  {11,  4}, // #4016
  {12,  4}, // #4017
  { 4,  1}, // #4018
  { 6,  1}, // #4019
  { 7,  1}, // #4020
  { 8,  1}, // #4021
  { 9,  2}, // #4022
  {10,  1}, // #4023
  {11,  2}, // #4024
  {12,  3}, // #4025
  { 4,  1}, // #4026
  { 6,  1}, // #4027
  { 7,  1}, // #4028
  { 8,  1}, // #4029
  { 9,  2}, // #4030
  {11,  2}, // #4031
  {12,  2}, // #4032
  { 3,  1}, // #4033
  { 7,  1}, // #4034
  { 8,  1}, // #4035
  {10,  1}, // #4036
  {11,  1}, // #4037
  {12,  2}, // #4038
  { 3,  1}, // #4039
  { 6,  1}, // #4040
  { 7,  1}, // #4041
  { 8,  2}, // #4042
  { 9,  1}, // #4043
  {11,  2}, // #4044
  {12,  2}, // #4045
  { 3,  1}, // #4046
  { 4,  1}, // #4047
  { 7,  2}, // #4048
  { 8,  1}, // #4049
  { 9,  1}, // #4050
  {10,  1}, // #4051
  {11,  2}, // #4052
  {12,  3}, // #4053
  { 3,  1}, // #4054
  { 4,  1}, // #4055
  { 7,  2}, // #4056
  { 8,  1}, // #4057
  { 9,  1}, // #4058
  {11,  2}, // #4059
  {12,  2}, // #4060
  { 4,  1}, // #4061
  { 6,  2}, // #4062
  { 7,  1}, // #4063
  { 8,  2}, // #4064
  { 9,  3}, // #4065
  {11,  3}, // #4066
  {12,  3}, // #4067
  { 3,  1}, // #4068
  { 7,  1}, // #4069
  { 8,  1}, // #4070
  {11,  1}, // #4071
  {12,  1}, // #4072
  { 1, 10}, // #4073
  { 3,  1}, // #4074
  { 7,  1}, // #4075
  { 8,  1}, // #4076
  {10,  1}, // #4077
  {11,  1}, // #4078
  {12,  2}, // #4079
  { 1, 10}, // #4080
  { 3,  1}, // #4081
  { 7,  1}, // #4082
  { 8,  1}, // #4083
  {11,  1}, // #4084
  {12,  1}, // #4085
  { 2, 22}, // #4086
  { 3,  1}, // #4087
  { 7,  1}, // #4088
  { 8,  1}, // #4089
  {10,  1}, // #4090
  {11,  1}, // #4091
  {12,  2}, // #4092
  { 2, 22}, // #4093
  { 3,  1}, // #4094
  { 7,  1}, // #4095
  { 8,  1}, // #4096
  {11,  1}, // #4097
  {12,  1}, // #4098
  { 2, 14}, // #4099
  { 3,  1}, // #4100
  { 7,  1}, // #4101
  { 8,  1}, // #4102
  {10,  1}, // #4103
  {11,  1}, // #4104
  {12,  2}, // #4105
  { 2, 14}, // #4106
  { 3,  1}, // #4107
  { 7,  1}, // #4108
  { 8,  1}, // #4109
  {11,  1}, // #4110
  {12,  1}, // #4111
  { 3,  1}, // #4112
  { 4,  1}, // #4113
  { 6,  1}, // #4114
  { 7,  2}, // #4115
  { 8,  2}, // #4116
  { 9,  2}, // #4117
  {10,  1}, // #4118
  {11,  3}, // #4119
  {12,  4}, // #4120
  { 3,  1}, // #4121
  { 4,  1}, // #4122
  { 6,  1}, // #4123
  { 7,  2}, // #4124
  { 8,  2}, // #4125
  { 9,  2}, // #4126
  {11,  3}, // #4127
  {12,  3}, // #4128
  { 3,  1}, // #4129
  { 4,  2}, // #4130
  { 6,  1}, // #4131
  { 7,  3}, // #4132
  { 8,  2}, // #4133
  { 9,  3}, // #4134
  {10,  1}, // #4135
  {11,  4}, // #4136
  {12,  5}, // #4137
  { 3,  1}, // #4138
  { 4,  2}, // #4139
  { 6,  1}, // #4140
  { 7,  3}, // #4141
  { 8,  2}, // #4142
  { 9,  3}, // #4143
  {11,  4}, // #4144
  {12,  4}, // #4145
  { 5,  1}, // #4146
  { 9,  1}, // #4147
  {10,  1}, // #4148
  {11,  1}, // #4149
  {12,  3}, // #4150
  { 3,  1}, // #4151
  { 7,  1}, // #4152
  { 8,  1}, // #4153
  { 9,  1}, // #4154
  {11,  2}, // #4155
  {12,  2}, // #4156
  {11, 31}, // #4157
  {12, 31}, // #4158
  { 4,  1}, // #4159
  { 6,  2}, // #4160
  { 7,  1}, // #4161
  { 8,  2}, // #4162
  { 9,  3}, // #4163
  {10,  1}, // #4164
  {11,  3}, // #4165
  {12,  4}, // #4166
  { 4,  1}, // #4167
  { 7,  1}, // #4168
  { 8,  1}, // #4169
  { 9,  1}, // #4170
  {10,  1}, // #4171
  {11,  4}, // #4172
  {12,  5}, // #4173
  { 4,  1}, // #4174
  { 7,  1}, // #4175
  { 8,  1}, // #4176
  { 9,  1}, // #4177
  {11,  4}, // #4178
  {12,  4}, // #4179
  { 4,  1}, // #4180
  { 7,  1}, // #4181
  { 9,  1}, // #4182
  {10,  1}, // #4183
  {11,  2}, // #4184
  {12,  3}, // #4185
  { 4,  1}, // #4186
  { 7,  1}, // #4187
  { 9,  1}, // #4188
  {11,  2}, // #4189
  {12,  2}, // #4190
  { 4,  1}, // #4191
  { 7,  1}, // #4192
  { 8,  1}, // #4193
  { 9,  1}, // #4194
  {10,  1}, // #4195
  {11,  3}, // #4196
  {12,  4}, // #4197
  { 4,  1}, // #4198
  { 7,  1}, // #4199
  { 8,  1}, // #4200
  { 9,  1}, // #4201
  {11,  3}, // #4202
  {12,  3}, // #4203
  { 3,  1}, // #4204
  { 5,  1}, // #4205
  { 6,  1}, // #4206
  { 7,  1}, // #4207
  { 8,  2}, // #4208
  { 9,  1}, // #4209
  {10,  1}, // #4210
  {11,  2}, // #4211
  {12,  4}, // #4212
  { 6,  1}, // #4213
  { 8,  1}, // #4214
  { 9,  2}, // #4215
  {11,  2}, // #4216
  {12,  2}, // #4217
  { 3,  1}, // #4218
  { 7,  1}, // #4219
  { 8,  1}, // #4220
  { 9,  2}, // #4221
  {10,  1}, // #4222
  {11,  3}, // #4223
  {12,  4}, // #4224
  { 3,  1}, // #4225
  { 7,  1}, // #4226
  { 8,  1}, // #4227
  { 9,  2}, // #4228
  {11,  3}, // #4229
  {12,  3}, // #4230
  {10,  1}, // #4231
  {11, 17}, // #4232
  {12, 18}, // #4233
  {11, 18}, // #4234
  {12, 18}, // #4235
  {10,  1}, // #4236
  {11,  7}, // #4237
  {12,  8}, // #4238
  {11,  8}, // #4239
  {12,  8}, // #4240
  { 3,  3}, // #4241
  { 7,  3}, // #4242
  { 8,  3}, // #4243
  {10,  1}, // #4244
  {11,  3}, // #4245
  {12,  4}, // #4246
  { 3,  3}, // #4247
  { 7,  3}, // #4248
  { 8,  3}, // #4249
  {11,  3}, // #4250
  {12,  3}, // #4251
  { 5,  1}, // #4252
  {10,  2}, // #4253
  {12,  3}, // #4254
  { 3,  1}, // #4255
  { 7,  1}, // #4256
  { 8,  1}, // #4257
  { 9,  1}, // #4258
  {10,  1}, // #4259
  {11,  2}, // #4260
  {12,  3}, // #4261
  { 3,  1}, // #4262
  { 6,  1}, // #4263
  { 7,  1}, // #4264
  { 8,  2}, // #4265
  { 9,  1}, // #4266
  {10,  1}, // #4267
  {11,  2}, // #4268
  {12,  3}, // #4269
  { 5,  1}, // #4270
  { 8,  2}, // #4271
  {10,  2}, // #4272
  {11,  2}, // #4273
  {12,  5}, // #4274
  { 5,  1}, // #4275
  { 8,  3}, // #4276
  {10,  2}, // #4277
  {11,  3}, // #4278
  {12,  6}, // #4279
  { 5,  1}, // #4280
  { 8,  1}, // #4281
  {10,  1}, // #4282
  {11,  1}, // #4283
  {12,  3}, // #4284
  { 5,  1}, // #4285
  { 8,  3}, // #4286
  {10,  2}, // #4287
  {11,  4}, // #4288
  {12,  7}, // #4289
  { 5,  1}, // #4290
  { 8,  1}, // #4291
  {10,  2}, // #4292
  {11,  2}, // #4293
  {12,  5}, // #4294
  { 2, 21}, // #4295
  { 3,  1}, // #4296
  { 7,  1}, // #4297
  { 8,  1}, // #4298
  {10,  1}, // #4299
  {11,  1}, // #4300
  {12,  2}, // #4301
  { 2, 21}, // #4302
  { 3,  1}, // #4303
  { 7,  1}, // #4304
  { 8,  1}, // #4305
  {11,  1}, // #4306
  {12,  1}, // #4307
  { 2, 24}, // #4308
  { 3,  1}, // #4309
  { 7,  1}, // #4310
  { 8,  1}, // #4311
  {11,  1}, // #4312
  {12,  1}, // #4313
  { 7,  1}, // #4314
  {10,  1}, // #4315
  {11,  1}, // #4316
  {12,  2}, // #4317
  { 4,  1}, // #4318
  { 5,  1}, // #4319
  { 7,  1}, // #4320
  { 9,  1}, // #4321
  {10,  1}, // #4322
  {11,  1}, // #4323
  {12,  3}, // #4324
  { 2, 44}, // #4325
  { 3,  2}, // #4326
  { 7,  2}, // #4327
  { 8,  3}, // #4328
  {10,  1}, // #4329
  {11,  3}, // #4330
  {12,  4}, // #4331
  { 2, 44}, // #4332
  { 3,  2}, // #4333
  { 7,  2}, // #4334
  { 8,  3}, // #4335
  {11,  3}, // #4336
  {12,  3}, // #4337
  { 2, 28}, // #4338
  { 3,  2}, // #4339
  { 7,  2}, // #4340
  { 8,  3}, // #4341
  {10,  1}, // #4342
  {11,  3}, // #4343
  {12,  4}, // #4344
  { 2, 28}, // #4345
  { 3,  2}, // #4346
  { 7,  2}, // #4347
  { 8,  3}, // #4348
  {11,  3}, // #4349
  {12,  3}, // #4350
  { 5,  1}, // #4351
  { 7,  1}, // #4352
  {10,  1}, // #4353
  {11,  1}, // #4354
  {12,  3}, // #4355
  { 8,  7}, // #4356
  {10,  4}, // #4357
  {11,  7}, // #4358
  {12, 11}, // #4359
  { 5,  1}, // #4360
  {10,  2}, // #4361
  {11,  2}, // #4362
  {12,  5}, // #4363
  { 6,  1}, // #4364
  { 7,  1}, // #4365
  { 8,  1}, // #4366
  { 9,  1}, // #4367
  {10,  1}, // #4368
  {11,  2}, // #4369
  {12,  3}, // #4370
  { 5,  1}, // #4371
  { 6,  2}, // #4372
  { 8,  2}, // #4373
  { 9,  2}, // #4374
  {10,  2}, // #4375
  {11,  2}, // #4376
  {12,  5}, // #4377
  { 4,  1}, // #4378
  { 5,  1}, // #4379
  { 7,  1}, // #4380
  { 9,  1}, // #4381
  {10,  2}, // #4382
  {11,  1}, // #4383
  {12,  4}, // #4384
  { 5,  1}, // #4385
  { 6,  1}, // #4386
  { 8,  1}, // #4387
  { 9,  1}, // #4388
  {10,  2}, // #4389
  {11,  1}, // #4390
  {12,  4}, // #4391
  { 6,  1}, // #4392
  { 8,  1}, // #4393
  { 9,  1}, // #4394
  {11,  4}, // #4395
  {12,  4}, // #4396
  { 5,  1}, // #4397
  { 6,  2}, // #4398
  { 7,  1}, // #4399
  { 8,  2}, // #4400
  { 9,  2}, // #4401
  {10,  1}, // #4402
  {11,  3}, // #4403
  {12,  5}, // #4404
  { 3,  1}, // #4405
  { 7,  1}, // #4406
  { 8,  1}, // #4407
  {11,  2}, // #4408
  {12,  2}, // #4409
  { 8,  8}, // #4410
  {11,  8}, // #4411
  {12,  8}, // #4412
  { 5,  1}, // #4413
  { 6,  1}, // #4414
  { 8,  1}, // #4415
  { 9,  1}, // #4416
  {10,  1}, // #4417
  {11,  1}, // #4418
  {12,  3}, // #4419
  { 5,  1}, // #4420
  {10,  1}, // #4421
  {11,  1}, // #4422
  {12,  3}, // #4423
  { 3,  1}, // #4424
  { 5,  1}, // #4425
  { 7,  1}, // #4426
  { 8,  1}, // #4427
  { 9,  1}, // #4428
  {10,  1}, // #4429
  {11,  2}, // #4430
  {12,  4}, // #4431
  { 5,  1}, // #4432
  { 6,  1}, // #4433
  { 7,  1}, // #4434
  { 8,  1}, // #4435
  { 9,  1}, // #4436
  {10,  1}, // #4437
  {11,  2}, // #4438
  {12,  4}, // #4439
  { 3,  1}, // #4440
  { 5,  1}, // #4441
  { 7,  1}, // #4442
  { 8,  1}, // #4443
  {10,  2}, // #4444
  {11,  1}, // #4445
  {12,  4}, // #4446
  { 4,  1}, // #4447
  { 6,  2}, // #4448
  { 7,  1}, // #4449
  { 8,  2}, // #4450
  { 9,  3}, // #4451
  {11,  4}, // #4452
  {12,  4}, // #4453
  {10,  2}, // #4454
  {11,  3}, // #4455
  {12,  5}, // #4456
  { 5,  1}, // #4457
  { 6,  1}, // #4458
  { 7,  1}, // #4459
  { 8,  1}, // #4460
  { 9,  1}, // #4461
  {10,  2}, // #4462
  {11,  2}, // #4463
  {12,  5}, // #4464
  { 5,  1}, // #4465
  { 8,  2}, // #4466
  {10,  2}, // #4467
  {11,  3}, // #4468
  {12,  6}, // #4469
  { 4,  2}, // #4470
  { 7,  2}, // #4471
  { 9,  2}, // #4472
  {10,  1}, // #4473
  {11,  2}, // #4474
  {12,  3}, // #4475
  { 8,  2}, // #4476
  {11,  3}, // #4477
  {12,  3}, // #4478
  { 8,  2}, // #4479
  {10,  1}, // #4480
  {11,  3}, // #4481
  {12,  4}, // #4482
  { 5,  1}, // #4483
  { 8,  2}, // #4484
  {10,  1}, // #4485
  {11,  2}, // #4486
  {12,  4}, // #4487
  { 3,  1}, // #4488
  { 4,  1}, // #4489
  { 8,  1}, // #4490
  { 9,  1}, // #4491
  {11,  2}, // #4492
  {12,  1}, // #4493
  {13,  2}, // #4494
  {14,  2}, // #4495
  {15,  2}, // #4496
  {16,  2}, // #4497
  {18,  2}, // #4498
  {19,  3}, // #4499
  {20,  3}, // #4500
  {22,  4}, // #4501
  {23,  4}, // #4502
  { 4,  1}, // #4503
  { 9,  1}, // #4504
  {11,  1}, // #4505
  {14,  1}, // #4506
  {15,  1}, // #4507
  {16,  2}, // #4508
  {17,  1}, // #4509
  {18,  1}, // #4510
  {19,  1}, // #4511
  {20,  1}, // #4512
  {21,  1}, // #4513
  {22,  2}, // #4514
  {23,  3}, // #4515
  { 4,  1}, // #4516
  { 9,  1}, // #4517
  {11,  1}, // #4518
  {14,  1}, // #4519
  {15,  1}, // #4520
  {16,  2}, // #4521
  {18,  1}, // #4522
  {19,  1}, // #4523
  {20,  1}, // #4524
  {22,  2}, // #4525
  {23,  2}, // #4526
  { 2, 17}, // #4527
  { 3,  1}, // #4528
  {11,  1}, // #4529
  {12,  1}, // #4530
  {13,  1}, // #4531
  {14,  1}, // #4532
  {19,  1}, // #4533
  {20,  1}, // #4534
  {22,  1}, // #4535
  {23,  1}, // #4536
  { 4,  1}, // #4537
  { 7,  1}, // #4538
  { 8,  1}, // #4539
  {11,  1}, // #4540
  {12,  1}, // #4541
  {13,  1}, // #4542
  {15,  2}, // #4543
  {16,  1}, // #4544
  {18,  1}, // #4545
  {19,  2}, // #4546
  {20,  1}, // #4547
  {21,  1}, // #4548
  {22,  2}, // #4549
  {23,  4}, // #4550
  { 2, 28}, // #4551
  { 3,  2}, // #4552
  {11,  2}, // #4553
  {12,  2}, // #4554
  {13,  2}, // #4555
  {14,  2}, // #4556
  {15,  1}, // #4557
  {17,  1}, // #4558
  {19,  3}, // #4559
  {20,  2}, // #4560
  {21,  1}, // #4561
  {22,  3}, // #4562
  {23,  4}, // #4563
  { 2, 28}, // #4564
  { 3,  2}, // #4565
  {11,  2}, // #4566
  {12,  2}, // #4567
  {13,  2}, // #4568
  {14,  2}, // #4569
  {15,  1}, // #4570
  {19,  3}, // #4571
  {20,  2}, // #4572
  {22,  3}, // #4573
  {23,  3}, // #4574
  { 2, 14}, // #4575
  { 3,  2}, // #4576
  {11,  2}, // #4577
  {12,  2}, // #4578
  {13,  2}, // #4579
  {14,  2}, // #4580
  {15,  1}, // #4581
  {17,  1}, // #4582
  {19,  3}, // #4583
  {20,  2}, // #4584
  {21,  1}, // #4585
  {22,  3}, // #4586
  {23,  4}, // #4587
  { 2, 14}, // #4588
  { 3,  2}, // #4589
  {11,  2}, // #4590
  {12,  2}, // #4591
  {13,  2}, // #4592
  {14,  2}, // #4593
  {15,  1}, // #4594
  {19,  3}, // #4595
  {20,  2}, // #4596
  {22,  3}, // #4597
  {23,  3}, // #4598
  { 4,  2}, // #4599
  {11,  2}, // #4600
  {15,  2}, // #4601
  {16,  2}, // #4602
  {19,  2}, // #4603
  {22,  2}, // #4604
  {23,  2}, // #4605
  { 3,  2}, // #4606
  { 4,  1}, // #4607
  { 8,  2}, // #4608
  { 9,  4}, // #4609
  {11,  5}, // #4610
  {12,  2}, // #4611
  {13,  4}, // #4612
  {14,  6}, // #4613
  {15,  3}, // #4614
  {16,  5}, // #4615
  {18,  6}, // #4616
  {19,  7}, // #4617
  {20,  8}, // #4618
  {22, 15}, // #4619
  {23, 15}, // #4620
  { 7,  1}, // #4621
  {12,  1}, // #4622
  {17,  2}, // #4623
  {21,  2}, // #4624
  {22,  2}, // #4625
  {23,  5}, // #4626
  {17,  1}, // #4627
  {21,  1}, // #4628
  {22, 14}, // #4629
  {23, 15}, // #4630
  {17,  2}, // #4631
  {21,  2}, // #4632
  {22,  3}, // #4633
  {23,  5}, // #4634
  { 9,  2}, // #4635
  {14,  2}, // #4636
  {16,  2}, // #4637
  {17,  1}, // #4638
  {18,  2}, // #4639
  {19,  1}, // #4640
  {20,  2}, // #4641
  {21,  1}, // #4642
  {22,  3}, // #4643
  {23,  4}, // #4644
  {17,  1}, // #4645
  {19, 16}, // #4646
  {21,  1}, // #4647
  {22, 16}, // #4648
  {23, 17}, // #4649
  { 3,  2}, // #4650
  { 8,  2}, // #4651
  {11,  2}, // #4652
  {12,  2}, // #4653
  {13,  4}, // #4654
  {14,  4}, // #4655
  {15,  3}, // #4656
  {17,  2}, // #4657
  {18,  2}, // #4658
  {19,  8}, // #4659
  {20,  6}, // #4660
  {21,  2}, // #4661
  {22, 10}, // #4662
  {23, 12}, // #4663
  { 3,  3}, // #4664
  { 8,  3}, // #4665
  {11,  3}, // #4666
  {12,  3}, // #4667
  {13,  6}, // #4668
  {14,  7}, // #4669
  {15,  4}, // #4670
  {17,  4}, // #4671
  {18,  3}, // #4672
  {19, 12}, // #4673
  {20, 10}, // #4674
  {21,  4}, // #4675
  {22, 16}, // #4676
  {23, 20}, // #4677
  { 3,  5}, // #4678
  { 8,  3}, // #4679
  {11,  5}, // #4680
  {12,  5}, // #4681
  {13,  8}, // #4682
  {14, 13}, // #4683
  {15,  4}, // #4684
  {17,  8}, // #4685
  {18,  3}, // #4686
  {19, 18}, // #4687
  {20, 16}, // #4688
  {21,  8}, // #4689
  {22, 26}, // #4690
  {23, 34}, // #4691
  { 3,  3}, // #4692
  { 8,  3}, // #4693
  {11,  3}, // #4694
  {12,  3}, // #4695
  {13,  6}, // #4696
  {14,  5}, // #4697
  {15,  4}, // #4698
  {17,  2}, // #4699
  {18,  3}, // #4700
  {19, 10}, // #4701
  {20,  8}, // #4702
  {21,  2}, // #4703
  {22, 12}, // #4704
  {23, 14}, // #4705
  { 3,  5}, // #4706
  { 8,  3}, // #4707
  {11,  5}, // #4708
  {12,  5}, // #4709
  {13,  8}, // #4710
  {14,  9}, // #4711
  {15,  4}, // #4712
  {17,  4}, // #4713
  {18,  3}, // #4714
  {19, 14}, // #4715
  {20, 12}, // #4716
  {21,  4}, // #4717
  {22, 18}, // #4718
  {23, 22}, // #4719
  { 3,  3}, // #4720
  { 8,  3}, // #4721
  {11,  3}, // #4722
  {12,  3}, // #4723
  {13,  6}, // #4724
  {14,  5}, // #4725
  {15,  4}, // #4726
  {17,  2}, // #4727
  {18,  3}, // #4728
  {19, 11}, // #4729
  {20,  8}, // #4730
  {21,  2}, // #4731
  {22, 13}, // #4732
  {23, 15}, // #4733
  {14,  1}, // #4734
  {17,  1}, // #4735
  {20,  1}, // #4736
  {21,  1}, // #4737
  {22,  3}, // #4738
  {23,  4}, // #4739
  { 5,  2}, // #4740
  { 6,  2}, // #4741
  {10,  1}, // #4742
  { 5,  1}, // #4743
  { 6,  1}, // #4744
  {10,  1}, // #4745
  { 4,  5}, // #4746
  { 6,  5}, // #4747
  {10,  1}, // #4748
  { 4,  1}, // #4749
  { 6,  1}, // #4750
  {10,  1}, // #4751
  { 4,  4}, // #4752
  { 6,  4}, // #4753
  {10,  1}, // #4754
  { 7, 10}, // #4755
  { 8, 10}, // #4756
  { 9, 20}, // #4757
  {10,  1}, // #4758
  { 7,  1}, // #4759
  { 8,  1}, // #4760
  { 9,  2}, // #4761
  {10,  2}, // #4762
  { 4,  2}, // #4763
  { 6,  2}, // #4764
  {10,  1}, // #4765
  { 1, 25}, // #4766
  { 9,  1}, // #4767
  {10,  1}, // #4768
  { 2, 69}, // #4769
  { 4,  1}, // #4770
  { 6,  1}, // #4771
  {10,  1}, // #4772
  { 2, 39}, // #4773
  { 4,  1}, // #4774
  { 6,  1}, // #4775
  {10,  1}, // #4776
  { 2, 17}, // #4777
  { 4,  1}, // #4778
  { 6,  1}, // #4779
  {10,  1}, // #4780
  { 2, 32}, // #4781
  { 4,  1}, // #4782
  { 6,  1}, // #4783
  {10,  1}, // #4784
  { 5,  8}, // #4785
  { 6,  8}, // #4786
  {10,  1}, // #4787
  { 5, 12}, // #4788
  { 6, 12}, // #4789
  {10,  1}, // #4790
  { 4,  1}, // #4791
  { 6,  1}, // #4792
  {10,  2}, // #4793
  { 6, 10}, // #4794
  { 5,  6}, // #4795
  { 6,  6}, // #4796
  {10,  1}, // #4797
  { 8,  5}, // #4798
  { 9,  5}, // #4799
  {10,  1}, // #4800
  { 8,  4}, // #4801
  { 9,  4}, // #4802
  {10,  1}, // #4803
  { 8,  7}, // #4804
  { 9,  7}, // #4805
  {10,  1}, // #4806
  { 3,  4}, // #4807
  { 4,  1}, // #4808
  { 6,  1}, // #4809
  {10,  1}, // #4810
  { 3,  2}, // #4811
  { 4,  1}, // #4812
  { 6,  1}, // #4813
  {10,  1}, // #4814
  { 4, 10}, // #4815
  { 6, 10}, // #4816
  {10,  1}, // #4817
  { 4, 21}, // #4818
  { 6, 21}, // #4819
  {10,  1}, // #4820
  { 4, 17}, // #4821
  { 6, 17}, // #4822
  {10,  1}, // #4823
  { 4, 13}, // #4824
  { 6, 13}, // #4825
  {10,  1}, // #4826
  { 4,  8}, // #4827
  { 6,  8}, // #4828
  {10,  1}, // #4829
  { 2, 70}, // #4830
  { 4,  1}, // #4831
  { 6,  1}, // #4832
  {10,  1}, // #4833
  { 2, 40}, // #4834
  { 4,  1}, // #4835
  { 6,  1}, // #4836
  {10,  1}, // #4837
  { 2, 35}, // #4838
  { 4,  1}, // #4839
  { 6,  1}, // #4840
  {10,  1}, // #4841
  { 2, 20}, // #4842
  { 4,  1}, // #4843
  { 6,  1}, // #4844
  {10,  1}, // #4845
  {26,  1}, // #4846
  {27,  1}, // #4847
  {15,  1}, // #4848
  {23,  1}, // #4849
  {24,  1}, // #4850
  {26,  1}, // #4851
  {27,  1}, // #4852
  {16,  1}, // #4853
  {24,  1}, // #4854
  {26,  1}, // #4855
  {27,  1}, // #4856
  { 7,  1}, // #4857
  {14,  1}, // #4858
  {16,  2}, // #4859
  {19,  1}, // #4860
  {20,  1}, // #4861
  {24,  2}, // #4862
  {25,  2}, // #4863
  {26,  3}, // #4864
  {27,  6}, // #4865
  {16,  1}, // #4866
  {19,  1}, // #4867
  {24,  1}, // #4868
  {25,  1}, // #4869
  {26,  1}, // #4870
  {27,  2}, // #4871
  { 4,  1}, // #4872
  {13,  1}, // #4873
  {17,  1}, // #4874
  {18,  1}, // #4875
  {23,  1}, // #4876
  {26,  1}, // #4877
  {27,  1}, // #4878
  { 7,  1}, // #4879
  {14,  1}, // #4880
  {20,  1}, // #4881
  {25,  1}, // #4882
  {27,  2}, // #4883
  {19,  1}, // #4884
  {25,  1}, // #4885
  {27,  1}, // #4886
  { 3,  1}, // #4887
  {13,  1}, // #4888
  {14,  1}, // #4889
  {15,  1}, // #4890
  {16,  1}, // #4891
  {23,  1}, // #4892
  {24,  1}, // #4893
  {26,  1}, // #4894
  {27,  1}, // #4895
  { 7,  1}, // #4896
  {14,  1}, // #4897
  {19,  1}, // #4898
  {20,  1}, // #4899
  {25,  2}, // #4900
  {26,  1}, // #4901
  {27,  4}, // #4902
  {19,  1}, // #4903
  {25,  1}, // #4904
  {26,  1}, // #4905
  {27,  2}, // #4906
  {13,  1}, // #4907
  {19,  1}, // #4908
  {23,  1}, // #4909
  {25,  1}, // #4910
  {26,  1}, // #4911
  {27,  2}, // #4912
  {13,  1}, // #4913
  {23,  1}, // #4914
  {26,  1}, // #4915
  {27,  1}, // #4916
  { 3,  1}, // #4917
  {13,  1}, // #4918
  {14,  1}, // #4919
  {15,  1}, // #4920
  {16,  1}, // #4921
  {19,  1}, // #4922
  {23,  1}, // #4923
  {24,  1}, // #4924
  {25,  1}, // #4925
  {26,  1}, // #4926
  {27,  2}, // #4927
  { 3,  2}, // #4928
  {13,  2}, // #4929
  {14,  2}, // #4930
  {15,  2}, // #4931
  {16,  2}, // #4932
  {19,  1}, // #4933
  {23,  2}, // #4934
  {24,  2}, // #4935
  {25,  1}, // #4936
  {26,  2}, // #4937
  {27,  3}, // #4938
  { 3,  2}, // #4939
  {13,  2}, // #4940
  {14,  2}, // #4941
  {15,  2}, // #4942
  {16,  2}, // #4943
  {23,  2}, // #4944
  {24,  2}, // #4945
  {26,  2}, // #4946
  {27,  2}, // #4947
  { 3,  3}, // #4948
  { 8,  6}, // #4949
  {13,  3}, // #4950
  {14,  3}, // #4951
  {15,  9}, // #4952
  {16,  3}, // #4953
  {17,  6}, // #4954
  {19,  1}, // #4955
  {21,  6}, // #4956
  {23, 10}, // #4957
  {24,  9}, // #4958
  {25,  1}, // #4959
  {26, 10}, // #4960
  {27, 11}, // #4961
  { 3,  3}, // #4962
  { 8,  6}, // #4963
  {13,  3}, // #4964
  {14,  3}, // #4965
  {15,  9}, // #4966
  {16,  3}, // #4967
  {17,  6}, // #4968
  {21,  6}, // #4969
  {23, 11}, // #4970
  {24,  9}, // #4971
  {26, 11}, // #4972
  {27, 11}, // #4973
  {16,  1}, // #4974
  {17,  1}, // #4975
  {19,  1}, // #4976
  {23,  1}, // #4977
  {24,  1}, // #4978
  {25,  1}, // #4979
  {26,  2}, // #4980
  {27,  3}, // #4981
  {16,  1}, // #4982
  {17,  1}, // #4983
  {23,  1}, // #4984
  {24,  1}, // #4985
  {26,  2}, // #4986
  {27,  2}, // #4987
  {19,  1}, // #4988
  {23,  2}, // #4989
  {25,  1}, // #4990
  {26,  2}, // #4991
  {27,  3}, // #4992
  {23,  2}, // #4993
  {26,  2}, // #4994
  {27,  2}, // #4995
  {17,  1}, // #4996
  {19,  1}, // #4997
  {23,  1}, // #4998
  {25,  1}, // #4999
  {26,  1}, // #5000
  {27,  2}, // #5001
  {17,  1}, // #5002
  {23,  1}, // #5003
  {26,  1}, // #5004
  {27,  1}, // #5005
  { 4,  1}, // #5006
  {13,  1}, // #5007
  {17,  1}, // #5008
  {18,  1}, // #5009
  {19,  1}, // #5010
  {23,  1}, // #5011
  {25,  1}, // #5012
  {26,  1}, // #5013
  {27,  2}, // #5014
  { 7,  1}, // #5015
  {14,  1}, // #5016
  {16,  1}, // #5017
  {19,  1}, // #5018
  {20,  1}, // #5019
  {24,  1}, // #5020
  {25,  2}, // #5021
  {26,  1}, // #5022
  {27,  4}, // #5023
  {16,  2}, // #5024
  {24,  2}, // #5025
  {26,  5}, // #5026
  {27,  5}, // #5027
  {13,  2}, // #5028
  {19,  1}, // #5029
  {23,  2}, // #5030
  {25,  1}, // #5031
  {26,  2}, // #5032
  {27,  3}, // #5033
  {13,  2}, // #5034
  {23,  2}, // #5035
  {26,  2}, // #5036
  {27,  2}, // #5037
  { 1, 10}, // #5038
  { 3,  1}, // #5039
  {13,  1}, // #5040
  {14,  1}, // #5041
  {15,  1}, // #5042
  {16,  1}, // #5043
  {19,  1}, // #5044
  {23,  1}, // #5045
  {24,  1}, // #5046
  {25,  1}, // #5047
  {26,  1}, // #5048
  {27,  2}, // #5049
  { 3,  7}, // #5050
  { 4,  2}, // #5051
  { 8,  8}, // #5052
  { 9,  3}, // #5053
  {13,  9}, // #5054
  {14,  7}, // #5055
  {15, 16}, // #5056
  {16, 10}, // #5057
  {17, 10}, // #5058
  {18,  5}, // #5059
  {21, 11}, // #5060
  {23, 18}, // #5061
  {24, 19}, // #5062
  {26, 32}, // #5063
  {27, 32}, // #5064
  { 1, 10}, // #5065
  { 3,  1}, // #5066
  {13,  1}, // #5067
  {14,  1}, // #5068
  {15,  1}, // #5069
  {16,  1}, // #5070
  {23,  1}, // #5071
  {24,  1}, // #5072
  {26,  1}, // #5073
  {27,  1}, // #5074
  { 2,  4}, // #5075
  { 3,  1}, // #5076
  {13,  1}, // #5077
  {14,  1}, // #5078
  {15,  1}, // #5079
  {16,  1}, // #5080
  {19,  1}, // #5081
  {23,  1}, // #5082
  {24,  1}, // #5083
  {25,  1}, // #5084
  {26,  1}, // #5085
  {27,  2}, // #5086
  { 2,  3}, // #5087
  { 3,  1}, // #5088
  {13,  1}, // #5089
  {14,  1}, // #5090
  {15,  1}, // #5091
  {16,  1}, // #5092
  {23,  1}, // #5093
  {24,  1}, // #5094
  {26,  1}, // #5095
  {27,  1}, // #5096
  { 2,  5}, // #5097
  { 3,  1}, // #5098
  {13,  1}, // #5099
  {14,  1}, // #5100
  {15,  1}, // #5101
  {16,  1}, // #5102
  {19,  1}, // #5103
  {23,  1}, // #5104
  {24,  1}, // #5105
  {25,  1}, // #5106
  {26,  1}, // #5107
  {27,  2}, // #5108
  { 2,  3}, // #5109
  { 3,  1}, // #5110
  {13,  1}, // #5111
  {14,  1}, // #5112
  {15,  1}, // #5113
  {16,  1}, // #5114
  {19,  1}, // #5115
  {23,  1}, // #5116
  {24,  1}, // #5117
  {25,  1}, // #5118
  {26,  1}, // #5119
  {27,  2}, // #5120
  { 8,  1}, // #5121
  {15,  1}, // #5122
  {17,  1}, // #5123
  {19,  1}, // #5124
  {21,  1}, // #5125
  {23,  3}, // #5126
  {24,  1}, // #5127
  {25,  1}, // #5128
  {26,  3}, // #5129
  {27,  4}, // #5130
  { 8,  1}, // #5131
  {15,  1}, // #5132
  {17,  1}, // #5133
  {21,  1}, // #5134
  {23,  3}, // #5135
  {24,  1}, // #5136
  {26,  3}, // #5137
  {27,  3}, // #5138
  { 8,  1}, // #5139
  {15,  1}, // #5140
  {17,  1}, // #5141
  {19,  1}, // #5142
  {21,  1}, // #5143
  {23,  4}, // #5144
  {24,  1}, // #5145
  {25,  1}, // #5146
  {26,  4}, // #5147
  {27,  5}, // #5148
  { 8,  1}, // #5149
  {15,  1}, // #5150
  {17,  1}, // #5151
  {21,  1}, // #5152
  {23,  4}, // #5153
  {24,  1}, // #5154
  {26,  4}, // #5155
  {27,  4}, // #5156
  { 7,  1}, // #5157
  { 8,  1}, // #5158
  {14,  1}, // #5159
  {15,  1}, // #5160
  {17,  1}, // #5161
  {20,  1}, // #5162
  {21,  1}, // #5163
  {23,  1}, // #5164
  {24,  1}, // #5165
  {25,  1}, // #5166
  {26,  1}, // #5167
  {27,  3}, // #5168
  { 3,  1}, // #5169
  { 8,  1}, // #5170
  {13,  1}, // #5171
  {14,  1}, // #5172
  {15,  2}, // #5173
  {16,  1}, // #5174
  {17,  1}, // #5175
  {21,  1}, // #5176
  {23,  2}, // #5177
  {24,  2}, // #5178
  {26,  2}, // #5179
  {27,  2}, // #5180
  {15,  9}, // #5181
  {23,  9}, // #5182
  {24,  9}, // #5183
  {26, 10}, // #5184
  {27, 10}, // #5185
  {15,  2}, // #5186
  {23,  2}, // #5187
  {24,  2}, // #5188
  {26,  2}, // #5189
  {27,  2}, // #5190
  { 8,  2}, // #5191
  {15,  2}, // #5192
  {17,  2}, // #5193
  {19,  1}, // #5194
  {21,  2}, // #5195
  {23,  3}, // #5196
  {24,  2}, // #5197
  {25,  1}, // #5198
  {26,  3}, // #5199
  {27,  4}, // #5200
  { 8,  2}, // #5201
  {15,  2}, // #5202
  {17,  2}, // #5203
  {21,  2}, // #5204
  {23,  3}, // #5205
  {24,  2}, // #5206
  {26,  3}, // #5207
  {27,  3}, // #5208
  { 3,  2}, // #5209
  { 8,  4}, // #5210
  {13,  2}, // #5211
  {14,  2}, // #5212
  {15,  6}, // #5213
  {16,  2}, // #5214
  {17,  4}, // #5215
  {19,  1}, // #5216
  {21,  4}, // #5217
  {23,  6}, // #5218
  {24,  6}, // #5219
  {25,  1}, // #5220
  {26,  7}, // #5221
  {27,  8}, // #5222
  { 3,  4}, // #5223
  { 4,  2}, // #5224
  { 8,  4}, // #5225
  { 9,  8}, // #5226
  {13,  6}, // #5227
  {14,  4}, // #5228
  {15,  8}, // #5229
  {16, 26}, // #5230
  {17,  6}, // #5231
  {18, 10}, // #5232
  {21, 12}, // #5233
  {23, 10}, // #5234
  {24, 30}, // #5235
  {26, 66}, // #5236
  {27, 66}, // #5237
  { 4,  1}, // #5238
  {13,  1}, // #5239
  {16,  1}, // #5240
  {17,  1}, // #5241
  {18,  1}, // #5242
  {19,  1}, // #5243
  {23,  1}, // #5244
  {24,  1}, // #5245
  {25,  1}, // #5246
  {26,  4}, // #5247
  {27,  5}, // #5248
  { 4,  1}, // #5249
  {13,  1}, // #5250
  {16,  1}, // #5251
  {17,  1}, // #5252
  {18,  1}, // #5253
  {23,  1}, // #5254
  {24,  1}, // #5255
  {26,  4}, // #5256
  {27,  4}, // #5257
  { 4,  1}, // #5258
  {13,  1}, // #5259
  {17,  1}, // #5260
  {18,  1}, // #5261
  {19,  1}, // #5262
  {23,  1}, // #5263
  {25,  1}, // #5264
  {26,  2}, // #5265
  {27,  3}, // #5266
  { 4,  1}, // #5267
  {13,  1}, // #5268
  {17,  1}, // #5269
  {18,  1}, // #5270
  {23,  1}, // #5271
  {26,  2}, // #5272
  {27,  2}, // #5273
  { 4,  1}, // #5274
  {13,  1}, // #5275
  {16,  1}, // #5276
  {17,  1}, // #5277
  {18,  1}, // #5278
  {19,  1}, // #5279
  {23,  1}, // #5280
  {24,  1}, // #5281
  {25,  1}, // #5282
  {26,  3}, // #5283
  {27,  4}, // #5284
  { 4,  1}, // #5285
  {13,  1}, // #5286
  {16,  1}, // #5287
  {17,  1}, // #5288
  {18,  1}, // #5289
  {23,  1}, // #5290
  {24,  1}, // #5291
  {26,  3}, // #5292
  {27,  3}, // #5293
  { 4,  1}, // #5294
  { 8,  1}, // #5295
  {13,  1}, // #5296
  {15,  1}, // #5297
  {17,  2}, // #5298
  {18,  1}, // #5299
  {19,  1}, // #5300
  {21,  1}, // #5301
  {23,  2}, // #5302
  {24,  1}, // #5303
  {25,  1}, // #5304
  {26,  2}, // #5305
  {27,  3}, // #5306
  { 4,  1}, // #5307
  { 8,  1}, // #5308
  {13,  1}, // #5309
  {15,  1}, // #5310
  {17,  2}, // #5311
  {18,  1}, // #5312
  {21,  1}, // #5313
  {23,  2}, // #5314
  {24,  1}, // #5315
  {26,  2}, // #5316
  {27,  2}, // #5317
  { 8,  1}, // #5318
  {15,  1}, // #5319
  {17,  1}, // #5320
  {21,  1}, // #5321
  {23,  1}, // #5322
  {24,  1}, // #5323
  {26,  1}, // #5324
  {27,  1}, // #5325
  { 3,  1}, // #5326
  {13,  1}, // #5327
  {14,  1}, // #5328
  {15,  1}, // #5329
  {16,  1}, // #5330
  {19,  1}, // #5331
  {23,  1}, // #5332
  {24,  1}, // #5333
  {25,  1}, // #5334
  {26,  2}, // #5335
  {27,  3}, // #5336
  { 7,  1}, // #5337
  {14,  1}, // #5338
  {19,  1}, // #5339
  {20,  1}, // #5340
  {25,  1}, // #5341
  {27,  2}, // #5342
  {15,  1}, // #5343
  {19,  1}, // #5344
  {23,  1}, // #5345
  {24,  1}, // #5346
  {25,  1}, // #5347
  {26,  1}, // #5348
  {27,  2}, // #5349
  { 8,  1}, // #5350
  {15,  1}, // #5351
  {17,  1}, // #5352
  {19,  1}, // #5353
  {21,  1}, // #5354
  {23,  1}, // #5355
  {24,  1}, // #5356
  {25,  1}, // #5357
  {26,  1}, // #5358
  {27,  2}, // #5359
  { 8,  2}, // #5360
  {15,  3}, // #5361
  {17,  2}, // #5362
  {19,  1}, // #5363
  {21,  2}, // #5364
  {23,  3}, // #5365
  {24,  3}, // #5366
  {25,  1}, // #5367
  {26,  3}, // #5368
  {27,  4}, // #5369
  { 8,  2}, // #5370
  {15,  3}, // #5371
  {17,  2}, // #5372
  {21,  2}, // #5373
  {23,  3}, // #5374
  {24,  3}, // #5375
  {26,  3}, // #5376
  {27,  3}, // #5377
  { 8,  2}, // #5378
  {15,  2}, // #5379
  {17,  2}, // #5380
  {21,  2}, // #5381
  {23,  2}, // #5382
  {24,  2}, // #5383
  {26,  2}, // #5384
  {27,  2}, // #5385
  { 8,  2}, // #5386
  {15,  2}, // #5387
  {17,  2}, // #5388
  {19,  1}, // #5389
  {21,  2}, // #5390
  {23,  2}, // #5391
  {24,  2}, // #5392
  {25,  1}, // #5393
  {26,  2}, // #5394
  {27,  3}, // #5395
  { 3,  4}, // #5396
  { 8,  3}, // #5397
  {13,  4}, // #5398
  {14,  4}, // #5399
  {15,  7}, // #5400
  {16,  4}, // #5401
  {17,  3}, // #5402
  {19,  1}, // #5403
  {21,  3}, // #5404
  {23,  7}, // #5405
  {24,  7}, // #5406
  {25,  1}, // #5407
  {26,  8}, // #5408
  {27,  9}, // #5409
  { 3,  4}, // #5410
  { 8,  3}, // #5411
  {13,  4}, // #5412
  {14,  4}, // #5413
  {15,  7}, // #5414
  {16,  4}, // #5415
  {17,  3}, // #5416
  {21,  3}, // #5417
  {23,  7}, // #5418
  {24,  7}, // #5419
  {26,  8}, // #5420
  {27,  8}, // #5421
  { 3,  4}, // #5422
  { 8,  3}, // #5423
  {13,  4}, // #5424
  {14,  4}, // #5425
  {15,  7}, // #5426
  {16,  4}, // #5427
  {17,  3}, // #5428
  {19,  1}, // #5429
  {21,  3}, // #5430
  {23,  8}, // #5431
  {24,  7}, // #5432
  {25,  1}, // #5433
  {26,  9}, // #5434
  {27, 10}, // #5435
  { 3,  4}, // #5436
  { 8,  3}, // #5437
  {13,  4}, // #5438
  {14,  4}, // #5439
  {15,  7}, // #5440
  {16,  4}, // #5441
  {17,  3}, // #5442
  {21,  3}, // #5443
  {23,  8}, // #5444
  {24,  7}, // #5445
  {26,  9}, // #5446
  {27,  9}, // #5447
  { 3,  3}, // #5448
  {13,  3}, // #5449
  {14,  3}, // #5450
  {15,  3}, // #5451
  {16,  3}, // #5452
  {19,  1}, // #5453
  {23,  3}, // #5454
  {24,  3}, // #5455
  {25,  1}, // #5456
  {26,  3}, // #5457
  {27,  4}, // #5458
  { 3,  3}, // #5459
  {13,  3}, // #5460
  {14,  3}, // #5461
  {15,  3}, // #5462
  {16,  3}, // #5463
  {23,  3}, // #5464
  {24,  3}, // #5465
  {26,  3}, // #5466
  {27,  3}, // #5467
  { 7,  1}, // #5468
  {14,  1}, // #5469
  {19,  1}, // #5470
  {20,  1}, // #5471
  {25,  2}, // #5472
  {27,  3}, // #5473
  { 8,  1}, // #5474
  {13,  1}, // #5475
  {15,  1}, // #5476
  {17,  1}, // #5477
  {21,  1}, // #5478
  {23,  2}, // #5479
  {24,  1}, // #5480
  {26,  2}, // #5481
  {27,  2}, // #5482
  { 3,  1}, // #5483
  { 8,  1}, // #5484
  {13,  1}, // #5485
  {14,  1}, // #5486
  {15,  2}, // #5487
  {16,  1}, // #5488
  {17,  1}, // #5489
  {19,  1}, // #5490
  {21,  1}, // #5491
  {23,  2}, // #5492
  {24,  2}, // #5493
  {25,  1}, // #5494
  {26,  2}, // #5495
  {27,  3}, // #5496
  { 7,  1}, // #5497
  {14,  1}, // #5498
  {16,  3}, // #5499
  {19,  1}, // #5500
  {20,  1}, // #5501
  {24,  3}, // #5502
  {25,  2}, // #5503
  {26,  3}, // #5504
  {27,  6}, // #5505
  {16,  3}, // #5506
  {24,  3}, // #5507
  {26,  3}, // #5508
  {27,  3}, // #5509
  { 7,  1}, // #5510
  {14,  1}, // #5511
  {16,  1}, // #5512
  {20,  1}, // #5513
  {24,  1}, // #5514
  {25,  1}, // #5515
  {26,  1}, // #5516
  {27,  3}, // #5517
  { 4,  1}, // #5518
  {13,  1}, // #5519
  {16,  2}, // #5520
  {17,  1}, // #5521
  {18,  1}, // #5522
  {19,  1}, // #5523
  {23,  1}, // #5524
  {24,  2}, // #5525
  {25,  2}, // #5526
  {26,  4}, // #5527
  {27,  6}, // #5528
  { 4,  1}, // #5529
  {13,  1}, // #5530
  {17,  1}, // #5531
  {18,  1}, // #5532
  {19,  1}, // #5533
  {23,  1}, // #5534
  {25,  2}, // #5535
  {26,  2}, // #5536
  {27,  4}, // #5537
  { 4,  1}, // #5538
  {13,  1}, // #5539
  {16,  2}, // #5540
  {17,  1}, // #5541
  {18,  1}, // #5542
  {23,  1}, // #5543
  {24,  2}, // #5544
  {26,  4}, // #5545
  {27,  4}, // #5546
  { 2,  6}, // #5547
  { 3,  1}, // #5548
  {13,  1}, // #5549
  {14,  1}, // #5550
  {15,  1}, // #5551
  {16,  1}, // #5552
  {19,  1}, // #5553
  {23,  1}, // #5554
  {24,  1}, // #5555
  {25,  1}, // #5556
  {26,  1}, // #5557
  {27,  2}, // #5558
  { 2,  6}, // #5559
  { 3,  1}, // #5560
  {13,  1}, // #5561
  {14,  1}, // #5562
  {15,  1}, // #5563
  {16,  1}, // #5564
  {23,  1}, // #5565
  {24,  1}, // #5566
  {26,  1}, // #5567
  {27,  1}, // #5568
  { 2,  7}, // #5569
  { 3,  1}, // #5570
  {13,  1}, // #5571
  {14,  1}, // #5572
  {15,  1}, // #5573
  {16,  1}, // #5574
  {23,  1}, // #5575
  {24,  1}, // #5576
  {26,  1}, // #5577
  {27,  1}, // #5578
  { 8,  1}, // #5579
  {13,  1}, // #5580
  {15,  1}, // #5581
  {17,  1}, // #5582
  {19,  1}, // #5583
  {21,  1}, // #5584
  {23,  2}, // #5585
  {24,  1}, // #5586
  {25,  1}, // #5587
  {26,  2}, // #5588
  {27,  3}, // #5589
  {15,  2}, // #5590
  {19,  1}, // #5591
  {23,  2}, // #5592
  {24,  2}, // #5593
  {25,  1}, // #5594
  {26,  2}, // #5595
  {27,  3}, // #5596
  { 7,  1}, // #5597
  { 8,  1}, // #5598
  {13,  1}, // #5599
  {14,  1}, // #5600
  {15,  1}, // #5601
  {17,  1}, // #5602
  {20,  1}, // #5603
  {21,  1}, // #5604
  {23,  2}, // #5605
  {24,  1}, // #5606
  {25,  1}, // #5607
  {26,  2}, // #5608
  {27,  4}, // #5609
  { 7,  1}, // #5610
  { 8,  1}, // #5611
  {14,  1}, // #5612
  {15,  2}, // #5613
  {17,  1}, // #5614
  {20,  1}, // #5615
  {21,  1}, // #5616
  {23,  2}, // #5617
  {24,  2}, // #5618
  {25,  1}, // #5619
  {26,  2}, // #5620
  {27,  4}, // #5621
  { 8,  1}, // #5622
  {15,  2}, // #5623
  {17,  1}, // #5624
  {21,  1}, // #5625
  {23,  2}, // #5626
  {24,  2}, // #5627
  {26,  2}, // #5628
  {27,  2}, // #5629
  { 2,  8}, // #5630
  { 3,  1}, // #5631
  {13,  1}, // #5632
  {14,  1}, // #5633
  {15,  1}, // #5634
  {16,  1}, // #5635
  {19,  1}, // #5636
  {23,  1}, // #5637
  {24,  1}, // #5638
  {25,  1}, // #5639
  {26,  1}, // #5640
  {27,  2}, // #5641
  { 2,  5}, // #5642
  { 3,  1}, // #5643
  {13,  1}, // #5644
  {14,  1}, // #5645
  {15,  1}, // #5646
  {16,  1}, // #5647
  {23,  1}, // #5648
  {24,  1}, // #5649
  {26,  1}, // #5650
  {27,  1}, // #5651
  { 2, 16}, // #5652
  { 3,  2}, // #5653
  { 8,  1}, // #5654
  {13,  2}, // #5655
  {14,  2}, // #5656
  {15,  3}, // #5657
  {16,  2}, // #5658
  {17,  1}, // #5659
  {19,  1}, // #5660
  {21,  1}, // #5661
  {23,  3}, // #5662
  {24,  3}, // #5663
  {25,  1}, // #5664
  {26,  3}, // #5665
  {27,  4}, // #5666
  { 2, 16}, // #5667
  { 3,  2}, // #5668
  { 8,  1}, // #5669
  {13,  2}, // #5670
  {14,  2}, // #5671
  {15,  3}, // #5672
  {16,  2}, // #5673
  {17,  1}, // #5674
  {21,  1}, // #5675
  {23,  3}, // #5676
  {24,  3}, // #5677
  {26,  3}, // #5678
  {27,  3}, // #5679
  { 2, 10}, // #5680
  { 3,  2}, // #5681
  { 8,  1}, // #5682
  {13,  2}, // #5683
  {14,  2}, // #5684
  {15,  3}, // #5685
  {16,  2}, // #5686
  {17,  1}, // #5687
  {19,  1}, // #5688
  {21,  1}, // #5689
  {23,  3}, // #5690
  {24,  3}, // #5691
  {25,  1}, // #5692
  {26,  3}, // #5693
  {27,  4}, // #5694
  { 2, 10}, // #5695
  { 3,  2}, // #5696
  { 8,  1}, // #5697
  {13,  2}, // #5698
  {14,  2}, // #5699
  {15,  3}, // #5700
  {16,  2}, // #5701
  {17,  1}, // #5702
  {21,  1}, // #5703
  {23,  3}, // #5704
  {24,  3}, // #5705
  {26,  3}, // #5706
  {27,  3}, // #5707
  { 3,  1}, // #5708
  {13,  1}, // #5709
  {14,  1}, // #5710
  {15,  1}, // #5711
  {16,  1}, // #5712
  {23,  1}, // #5713
  {24,  1}, // #5714
  {25,  1}, // #5715
  {26,  1}, // #5716
  {27,  2}, // #5717
  { 2, 12}, // #5718
  { 3,  1}, // #5719
  {13,  1}, // #5720
  {14,  1}, // #5721
  {15,  1}, // #5722
  {16,  1}, // #5723
  {19,  1}, // #5724
  {23,  1}, // #5725
  {24,  1}, // #5726
  {25,  1}, // #5727
  {26,  1}, // #5728
  {27,  2}, // #5729
  { 2, 12}, // #5730
  { 3,  1}, // #5731
  {13,  1}, // #5732
  {14,  1}, // #5733
  {15,  1}, // #5734
  {16,  1}, // #5735
  {23,  1}, // #5736
  {24,  1}, // #5737
  {26,  1}, // #5738
  {27,  1}, // #5739
  { 2, 24}, // #5740
  { 3,  2}, // #5741
  { 8,  1}, // #5742
  {13,  2}, // #5743
  {14,  2}, // #5744
  {15,  3}, // #5745
  {16,  2}, // #5746
  {17,  1}, // #5747
  {19,  1}, // #5748
  {21,  1}, // #5749
  {23,  3}, // #5750
  {24,  3}, // #5751
  {25,  1}, // #5752
  {26,  3}, // #5753
  {27,  4}, // #5754
  { 2, 24}, // #5755
  { 3,  2}, // #5756
  { 8,  1}, // #5757
  {13,  2}, // #5758
  {14,  2}, // #5759
  {15,  3}, // #5760
  {16,  2}, // #5761
  {17,  1}, // #5762
  {21,  1}, // #5763
  {23,  3}, // #5764
  {24,  3}, // #5765
  {26,  3}, // #5766
  {27,  3}, // #5767
  { 2, 12}, // #5768
  { 3,  2}, // #5769
  { 8,  1}, // #5770
  {13,  2}, // #5771
  {14,  2}, // #5772
  {15,  3}, // #5773
  {16,  2}, // #5774
  {17,  1}, // #5775
  {19,  1}, // #5776
  {21,  1}, // #5777
  {23,  3}, // #5778
  {24,  3}, // #5779
  {25,  1}, // #5780
  {26,  3}, // #5781
  {27,  4}, // #5782
  { 2, 12}, // #5783
  { 3,  2}, // #5784
  { 8,  1}, // #5785
  {13,  2}, // #5786
  {14,  2}, // #5787
  {15,  3}, // #5788
  {16,  2}, // #5789
  {17,  1}, // #5790
  {21,  1}, // #5791
  {23,  3}, // #5792
  {24,  3}, // #5793
  {26,  3}, // #5794
  {27,  3}, // #5795
  {16,  1}, // #5796
  {19,  1}, // #5797
  {24,  1}, // #5798
  {25,  2}, // #5799
  {26,  3}, // #5800
  {27,  5}, // #5801
  { 4,  2}, // #5802
  {13,  2}, // #5803
  {16,  4}, // #5804
  {17,  3}, // #5805
  {18,  2}, // #5806
  {19,  1}, // #5807
  {23,  3}, // #5808
  {24,  4}, // #5809
  {25,  2}, // #5810
  {26,  9}, // #5811
  {27, 11}, // #5812
  { 8,  1}, // #5813
  {15,  1}, // #5814
  {17,  1}, // #5815
  {21,  1}, // #5816
  {23,  2}, // #5817
  {24,  1}, // #5818
  {26,  2}, // #5819
  {27,  2}, // #5820
  { 3,  2}, // #5821
  { 4,  1}, // #5822
  { 8,  2}, // #5823
  { 9,  4}, // #5824
  {13,  3}, // #5825
  {14,  2}, // #5826
  {15,  6}, // #5827
  {16,  6}, // #5828
  {17,  3}, // #5829
  {18,  5}, // #5830
  {21,  6}, // #5831
  {23,  7}, // #5832
  {24, 10}, // #5833
  {26, 15}, // #5834
  {27, 15}, // #5835
  { 3,  1}, // #5836
  { 8,  1}, // #5837
  {13,  1}, // #5838
  {14,  1}, // #5839
  {15,  2}, // #5840
  {16,  1}, // #5841
  {17,  1}, // #5842
  {21,  1}, // #5843
  {23,  3}, // #5844
  {24,  2}, // #5845
  {26,  3}, // #5846
  {27,  3}, // #5847
  { 3,  1}, // #5848
  { 8,  1}, // #5849
  {13,  1}, // #5850
  {14,  1}, // #5851
  {15,  2}, // #5852
  {16,  1}, // #5853
  {17,  1}, // #5854
  {19,  1}, // #5855
  {21,  1}, // #5856
  {23,  3}, // #5857
  {24,  2}, // #5858
  {25,  1}, // #5859
  {26,  3}, // #5860
  {27,  4}, // #5861
  {19,  1}, // #5862
  {25,  1}, // #5863
  {26,  2}, // #5864
  {27,  3}, // #5865
  { 9,  1}, // #5866
  {16,  1}, // #5867
  {18,  1}, // #5868
  {21,  1}, // #5869
  {24,  1}, // #5870
  {26,  3}, // #5871
  {27,  3}, // #5872
  { 7,  1}, // #5873
  { 9,  1}, // #5874
  {14,  1}, // #5875
  {16,  2}, // #5876
  {18,  1}, // #5877
  {19,  1}, // #5878
  {20,  1}, // #5879
  {21,  1}, // #5880
  {24,  2}, // #5881
  {25,  2}, // #5882
  {26,  5}, // #5883
  {27,  8}, // #5884
  {16,  1}, // #5885
  {24,  1}, // #5886
  {26,  2}, // #5887
  {27,  2}, // #5888
  { 3,  1}, // #5889
  {13,  1}, // #5890
  {14,  1}, // #5891
  {15,  2}, // #5892
  {16,  1}, // #5893
  {19,  1}, // #5894
  {23,  2}, // #5895
  {24,  2}, // #5896
  {25,  1}, // #5897
  {26,  2}, // #5898
  {27,  3}, // #5899
  {16,  2}, // #5900
  {24,  2}, // #5901
  {26, 11}, // #5902
  {27, 11}, // #5903
  { 7,  1}, // #5904
  { 9,  1}, // #5905
  {14,  1}, // #5906
  {16,  1}, // #5907
  {18,  1}, // #5908
  {20,  1}, // #5909
  {21,  1}, // #5910
  {24,  1}, // #5911
  {25,  1}, // #5912
  {26,  1}, // #5913
  {27,  3}, // #5914
  { 9,  1}, // #5915
  {16,  1}, // #5916
  {18,  1}, // #5917
  {21,  1}, // #5918
  {24,  1}, // #5919
  {26,  4}, // #5920
  {27,  4}, // #5921
  { 7,  1}, // #5922
  {14,  1}, // #5923
  {16,  4}, // #5924
  {17,  2}, // #5925
  {19,  1}, // #5926
  {20,  1}, // #5927
  {23,  2}, // #5928
  {24,  4}, // #5929
  {25,  2}, // #5930
  {26, 11}, // #5931
  {27, 14}, // #5932
  { 9,  1}, // #5933
  {16,  4}, // #5934
  {17,  1}, // #5935
  {18,  1}, // #5936
  {21,  1}, // #5937
  {23,  1}, // #5938
  {24,  4}, // #5939
  {26,  7}, // #5940
  {27,  7}, // #5941
  { 9,  1}, // #5942
  {16,  1}, // #5943
  {18,  1}, // #5944
  {21,  1}, // #5945
  {24,  1}, // #5946
  {26,  6}, // #5947
  {27,  6}, // #5948
  { 3,  2}, // #5949
  { 7,  1}, // #5950
  { 8,  4}, // #5951
  {13,  2}, // #5952
  {14,  3}, // #5953
  {15,  6}, // #5954
  {16,  6}, // #5955
  {17,  4}, // #5956
  {19,  1}, // #5957
  {20,  1}, // #5958
  {21,  4}, // #5959
  {23,  6}, // #5960
  {24, 10}, // #5961
  {25,  2}, // #5962
  {26, 16}, // #5963
  {27, 19}, // #5964
  { 8,  2}, // #5965
  {15,  2}, // #5966
  {17,  2}, // #5967
  {21,  2}, // #5968
  {23,  2}, // #5969
  {24,  2}, // #5970
  {26, 22}, // #5971
  {27, 22}, // #5972
  { 8,  1}, // #5973
  { 9,  2}, // #5974
  {15,  1}, // #5975
  {16,  2}, // #5976
  {17,  1}, // #5977
  {18,  2}, // #5978
  {21,  3}, // #5979
  {23,  1}, // #5980
  {24,  3}, // #5981
  {26, 10}, // #5982
  {27, 10}, // #5983
  { 7,  1}, // #5984
  { 8,  1}, // #5985
  { 9,  1}, // #5986
  {14,  1}, // #5987
  {15,  1}, // #5988
  {16,  2}, // #5989
  {17,  1}, // #5990
  {18,  1}, // #5991
  {19,  1}, // #5992
  {20,  1}, // #5993
  {21,  2}, // #5994
  {23,  1}, // #5995
  {24,  3}, // #5996
  {25,  2}, // #5997
  {26,  5}, // #5998
  {27,  8}, // #5999
  { 8,  6}, // #6000
  {15,  9}, // #6001
  {17,  6}, // #6002
  {21,  6}, // #6003
  {23,  9}, // #6004
  {24,  9}, // #6005
  {26, 15}, // #6006
  {27, 15}, // #6007
  { 8,  1}, // #6008
  { 9,  5}, // #6009
  {15,  1}, // #6010
  {16,  9}, // #6011
  {17,  1}, // #6012
  {18,  5}, // #6013
  {19,  2}, // #6014
  {21,  6}, // #6015
  {23,  1}, // #6016
  {24, 10}, // #6017
  {25,  3}, // #6018
  {26, 20}, // #6019
  {27, 23}, // #6020
  { 8,  1}, // #6021
  { 9,  5}, // #6022
  {15,  1}, // #6023
  {16,  9}, // #6024
  {17,  1}, // #6025
  {18,  5}, // #6026
  {19,  3}, // #6027
  {21,  6}, // #6028
  {23,  1}, // #6029
  {24, 10}, // #6030
  {25,  3}, // #6031
  {26, 20}, // #6032
  {27, 23}, // #6033
  { 8,  1}, // #6034
  { 9,  1}, // #6035
  {15,  1}, // #6036
  {16,  2}, // #6037
  {17,  1}, // #6038
  {18,  1}, // #6039
  {21,  2}, // #6040
  {23,  1}, // #6041
  {24,  3}, // #6042
  {26,  8}, // #6043
  {27,  8}, // #6044
  { 3,  4}, // #6045
  { 9,  2}, // #6046
  {13,  4}, // #6047
  {14,  4}, // #6048
  {15,  5}, // #6049
  {16,  8}, // #6050
  {17,  1}, // #6051
  {18,  2}, // #6052
  {19, 33}, // #6053
  {21,  2}, // #6054
  {23,  6}, // #6055
  {24,  9}, // #6056
  {25, 33}, // #6057
  {26, 57}, // #6058
  {27, 90}, // #6059
  { 9,  1}, // #6060
  {16,  1}, // #6061
  {18,  1}, // #6062
  {19,  1}, // #6063
  {21,  1}, // #6064
  {24,  1}, // #6065
  {25,  1}, // #6066
  {26,  2}, // #6067
  {27,  3}, // #6068
  { 3,  1}, // #6069
  {13,  1}, // #6070
  {14,  1}, // #6071
  {15,  1}, // #6072
  {16,  1}, // #6073
  {23,  1}, // #6074
  {24,  1}, // #6075
  {26,  2}, // #6076
  {27,  2}, // #6077
  {16,  1}, // #6078
  {24,  1}, // #6079
  {26,  3}, // #6080
  {27,  3}, // #6081
  { 4,  2}, // #6082
  {13,  2}, // #6083
  {16,  4}, // #6084
  {17,  3}, // #6085
  {18,  2}, // #6086
  {23,  3}, // #6087
  {24,  4}, // #6088
  {26, 10}, // #6089
  {27, 10}, // #6090
  { 7,  1}, // #6091
  {14,  1}, // #6092
  {20,  1}, // #6093
  {25,  1}, // #6094
  {26,  1}, // #6095
  {27,  3}, // #6096
  { 7,  1}, // #6097
  {14,  1}, // #6098
  {16,  1}, // #6099
  {20,  1}, // #6100
  {24,  1}, // #6101
  {25,  1}, // #6102
  {26,  2}, // #6103
  {27,  4}, // #6104
  { 7,  1}, // #6105
  { 9,  1}, // #6106
  {14,  1}, // #6107
  {16,  1}, // #6108
  {18,  1}, // #6109
  {20,  1}, // #6110
  {21,  1}, // #6111
  {24,  1}, // #6112
  {25,  1}, // #6113
  {26,  2}, // #6114
  {27,  4}, // #6115
  { 7,  1}, // #6116
  {14,  1}, // #6117
  {20,  1}, // #6118
  {25,  1}, // #6119
  {26,  4}, // #6120
  {27,  6}, // #6121
  { 9,  1}, // #6122
  {16,  1}, // #6123
  {18,  1}, // #6124
  {21,  1}, // #6125
  {24,  1}, // #6126
  {26,  2}, // #6127
  {27,  2}, // #6128
  { 9,  1}, // #6129
  {16,  1}, // #6130
  {18,  1}, // #6131
  {19,  1}, // #6132
  {21,  1}, // #6133
  {24,  1}, // #6134
  {25,  1}, // #6135
  {26,  1}, // #6136
  {27,  2}, // #6137
  { 3,  1}, // #6138
  { 7,  1}, // #6139
  {13,  1}, // #6140
  {14,  2}, // #6141
  {15,  1}, // #6142
  {16,  1}, // #6143
  {20,  1}, // #6144
  {23,  1}, // #6145
  {24,  1}, // #6146
  {25,  1}, // #6147
  {26,  1}, // #6148
  {27,  3}, // #6149
  { 4,  1}, // #6150
  { 9,  1}, // #6151
  {13,  1}, // #6152
  {16,  2}, // #6153
  {17,  1}, // #6154
  {18,  2}, // #6155
  {21,  1}, // #6156
  {23,  1}, // #6157
  {24,  2}, // #6158
  {26,  4}, // #6159
  {27,  4}, // #6160
  { 7,  1}, // #6161
  { 9,  1}, // #6162
  {14,  1}, // #6163
  {16,  1}, // #6164
  {18,  1}, // #6165
  {19,  1}, // #6166
  {20,  1}, // #6167
  {21,  1}, // #6168
  {24,  1}, // #6169
  {25,  2}, // #6170
  {26,  2}, // #6171
  {27,  5}, // #6172
  { 7,  1}, // #6173
  {14,  1}, // #6174
  {16,  2}, // #6175
  {19,  1}, // #6176
  {20,  1}, // #6177
  {24,  2}, // #6178
  {25,  2}, // #6179
  {26,  2}, // #6180
  {27,  5}, // #6181
  { 7,  1}, // #6182
  {14,  1}, // #6183
  {19,  1}, // #6184
  {20,  1}, // #6185
  {25,  2}, // #6186
  {26,  2}, // #6187
  {27,  5}, // #6188
  { 4,  1}, // #6189
  { 9,  5}, // #6190
  {13,  1}, // #6191
  {15,  4}, // #6192
  {16,  5}, // #6193
  {17,  1}, // #6194
  {18,  6}, // #6195
  {21,  5}, // #6196
  {23,  5}, // #6197
  {24,  9}, // #6198
  {26, 10}, // #6199
  {27, 10}, // #6200
  { 9,  1}, // #6201
  {16,  1}, // #6202
  {18,  1}, // #6203
  {21,  1}, // #6204
  {24,  1}, // #6205
  {26,  1}, // #6206
  {27,  1}, // #6207
  { 7,  1}, // #6208
  {14,  1}, // #6209
  {17,  1}, // #6210
  {20,  1}, // #6211
  {23,  1}, // #6212
  {25,  1}, // #6213
  {26,  1}, // #6214
  {27,  3}, // #6215
  {16,  2}, // #6216
  {24,  2}, // #6217
  {26,  2}, // #6218
  {27,  2}, // #6219
  { 8,  2}, // #6220
  {15,  2}, // #6221
  {17,  2}, // #6222
  {21,  2}, // #6223
  {23,  2}, // #6224
  {24,  2}, // #6225
  {26,  3}, // #6226
  {27,  3}, // #6227
  { 8,  1}, // #6228
  {15,  1}, // #6229
  {17,  1}, // #6230
  {19,  1}, // #6231
  {21,  1}, // #6232
  {23,  2}, // #6233
  {24,  1}, // #6234
  {25,  1}, // #6235
  {26,  2}, // #6236
  {27,  3}, // #6237
  { 4,  1}, // #6238
  { 9,  1}, // #6239
  {13,  1}, // #6240
  {16,  1}, // #6241
  {17,  1}, // #6242
  {18,  2}, // #6243
  {21,  1}, // #6244
  {23,  1}, // #6245
  {24,  1}, // #6246
  {26,  4}, // #6247
  {27,  4}, // #6248
  { 4,  1}, // #6249
  { 9,  2}, // #6250
  {13,  1}, // #6251
  {16,  2}, // #6252
  {17,  1}, // #6253
  {18,  3}, // #6254
  {19,  1}, // #6255
  {21,  2}, // #6256
  {23,  1}, // #6257
  {24,  2}, // #6258
  {25,  1}, // #6259
  {26,  4}, // #6260
  {27,  5}, // #6261
  { 4,  1}, // #6262
  { 9,  1}, // #6263
  {13,  1}, // #6264
  {16,  2}, // #6265
  {17,  1}, // #6266
  {18,  2}, // #6267
  {21,  1}, // #6268
  {23,  1}, // #6269
  {24,  2}, // #6270
  {26,  3}, // #6271
  {27,  3}, // #6272
  {16,  1}, // #6273
  {24,  1}, // #6274
  {26,  5}, // #6275
  {27,  5}, // #6276
  { 4,  1}, // #6277
  {13,  1}, // #6278
  {16,  5}, // #6279
  {17,  2}, // #6280
  {18,  1}, // #6281
  {19,  1}, // #6282
  {23,  2}, // #6283
  {24,  5}, // #6284
  {25,  2}, // #6285
  {26,  8}, // #6286
  {27, 10}, // #6287
  { 4,  2}, // #6288
  {13,  2}, // #6289
  {16,  3}, // #6290
  {17,  2}, // #6291
  {18,  2}, // #6292
  {23,  2}, // #6293
  {24,  3}, // #6294
  {26,  7}, // #6295
  {27,  7}, // #6296
  { 4,  1}, // #6297
  {13,  1}, // #6298
  {16,  5}, // #6299
  {17,  2}, // #6300
  {18,  1}, // #6301
  {23,  2}, // #6302
  {24,  5}, // #6303
  {26,  9}, // #6304
  {27,  9}, // #6305
  { 4,  1}, // #6306
  { 9,  8}, // #6307
  {13,  1}, // #6308
  {16,  8}, // #6309
  {17,  1}, // #6310
  {18,  9}, // #6311
  {19,  1}, // #6312
  {21,  8}, // #6313
  {23,  1}, // #6314
  {24,  8}, // #6315
  {25,  1}, // #6316
  {26, 30}, // #6317
  {27, 31}, // #6318
  { 7,  1}, // #6319
  { 9, 10}, // #6320
  {14,  1}, // #6321
  {16, 10}, // #6322
  {18, 10}, // #6323
  {19,  1}, // #6324
  {20,  1}, // #6325
  {21, 10}, // #6326
  {24, 10}, // #6327
  {25,  2}, // #6328
  {26, 36}, // #6329
  {27, 39}, // #6330
  { 7,  1}, // #6331
  { 9, 11}, // #6332
  {14,  1}, // #6333
  {16, 11}, // #6334
  {18, 11}, // #6335
  {19,  1}, // #6336
  {20,  1}, // #6337
  {21, 11}, // #6338
  {24, 11}, // #6339
  {25,  2}, // #6340
  {26, 37}, // #6341
  {27, 40}, // #6342
  { 4,  1}, // #6343
  { 7,  1}, // #6344
  { 8,  2}, // #6345
  { 9,  3}, // #6346
  {13,  1}, // #6347
  {14,  1}, // #6348
  {15,  2}, // #6349
  {16,  3}, // #6350
  {17,  4}, // #6351
  {18,  4}, // #6352
  {19,  1}, // #6353
  {20,  1}, // #6354
  {21,  5}, // #6355
  {23,  4}, // #6356
  {24,  5}, // #6357
  {25,  2}, // #6358
  {26, 15}, // #6359
  {27, 18}, // #6360
  { 3,  2}, // #6361
  {13,  2}, // #6362
  {14,  2}, // #6363
  {15,  7}, // #6364
  {16, 12}, // #6365
  {19,  8}, // #6366
  {23,  7}, // #6367
  {24, 17}, // #6368
  {25,  8}, // #6369
  {26, 56}, // #6370
  {27, 64}, // #6371
  { 3,  4}, // #6372
  { 9,  4}, // #6373
  {13,  4}, // #6374
  {14,  4}, // #6375
  {15,  5}, // #6376
  {16, 10}, // #6377
  {17,  1}, // #6378
  {18,  4}, // #6379
  {19, 31}, // #6380
  {21,  4}, // #6381
  {23,  6}, // #6382
  {24, 11}, // #6383
  {25, 31}, // #6384
  {26, 57}, // #6385
  {27, 88}, // #6386
  { 3,  9}, // #6387
  { 4,  1}, // #6388
  { 7, 11}, // #6389
  { 8, 16}, // #6390
  { 9,  1}, // #6391
  {13, 10}, // #6392
  {14, 20}, // #6393
  {15, 25}, // #6394
  {16, 31}, // #6395
  {17, 17}, // #6396
  {18,  2}, // #6397
  {20, 11}, // #6398
  {21, 17}, // #6399
  {23, 26}, // #6400
  {24, 47}, // #6401
  {25, 11}, // #6402
  {26, 78}, // #6403
  {27, 100}, // #6404
  { 3,  1}, // #6405
  { 8,  1}, // #6406
  {13,  1}, // #6407
  {14,  1}, // #6408
  {15,  2}, // #6409
  {16,  1}, // #6410
  {17,  1}, // #6411
  {19,  2}, // #6412
  {21,  1}, // #6413
  {23,  3}, // #6414
  {24,  2}, // #6415
  {25,  2}, // #6416
  {26,  3}, // #6417
  {27,  5}, // #6418
  { 3,  1}, // #6419
  { 8,  1}, // #6420
  {13,  1}, // #6421
  {14,  1}, // #6422
  {15,  2}, // #6423
  {16,  1}, // #6424
  {17,  1}, // #6425
  {19,  4}, // #6426
  {21,  1}, // #6427
  {23,  3}, // #6428
  {24,  2}, // #6429
  {25,  4}, // #6430
  {26,  3}, // #6431
  {27,  7}, // #6432
  { 3,  1}, // #6433
  { 8,  1}, // #6434
  {13,  1}, // #6435
  {14,  1}, // #6436
  {15,  2}, // #6437
  {16,  1}, // #6438
  {17,  1}, // #6439
  {19,  8}, // #6440
  {21,  1}, // #6441
  {23,  3}, // #6442
  {24,  2}, // #6443
  {25,  8}, // #6444
  {26,  3}, // #6445
  {27, 11}, // #6446
  { 3,  1}, // #6447
  { 8,  2}, // #6448
  {13,  1}, // #6449
  {14,  1}, // #6450
  {15,  3}, // #6451
  {16,  1}, // #6452
  {17,  2}, // #6453
  {21,  2}, // #6454
  {23,  3}, // #6455
  {24,  3}, // #6456
  {26,  3}, // #6457
  {27,  3}, // #6458
  { 8,  2}, // #6459
  {13,  1}, // #6460
  {15,  2}, // #6461
  {17,  2}, // #6462
  {21,  2}, // #6463
  {23,  3}, // #6464
  {24,  2}, // #6465
  {26,  3}, // #6466
  {27,  3}, // #6467
  { 3,  1}, // #6468
  { 8,  2}, // #6469
  {13,  1}, // #6470
  {14,  1}, // #6471
  {15,  3}, // #6472
  {16,  1}, // #6473
  {17,  2}, // #6474
  {19,  1}, // #6475
  {21,  2}, // #6476
  {23,  3}, // #6477
  {24,  3}, // #6478
  {25,  1}, // #6479
  {26,  3}, // #6480
  {27,  4}, // #6481
  { 8,  2}, // #6482
  {13,  1}, // #6483
  {15,  2}, // #6484
  {17,  2}, // #6485
  {19,  1}, // #6486
  {21,  2}, // #6487
  {23,  3}, // #6488
  {24,  2}, // #6489
  {25,  1}, // #6490
  {26,  3}, // #6491
  {27,  4}, // #6492
  { 7,  2}, // #6493
  {14,  2}, // #6494
  {17,  1}, // #6495
  {20,  2}, // #6496
  {23,  1}, // #6497
  {25,  2}, // #6498
  {26,  1}, // #6499
  {27,  5}, // #6500
  { 7,  1}, // #6501
  {14,  1}, // #6502
  {20,  1}, // #6503
  {23,  1}, // #6504
  {25,  1}, // #6505
  {26,  1}, // #6506
  {27,  3}, // #6507
  { 7,  1}, // #6508
  { 8,  2}, // #6509
  {14,  1}, // #6510
  {15,  2}, // #6511
  {17,  2}, // #6512
  {20,  1}, // #6513
  {21,  2}, // #6514
  {23,  2}, // #6515
  {24,  2}, // #6516
  {25,  1}, // #6517
  {26,  2}, // #6518
  {27,  4}, // #6519
  { 8,  1}, // #6520
  {15,  1}, // #6521
  {17,  1}, // #6522
  {19,  1}, // #6523
  {21,  1}, // #6524
  {23,  1}, // #6525
  {24,  1}, // #6526
  {25,  1}, // #6527
  {26,  2}, // #6528
  {27,  3}, // #6529
  { 3,  1}, // #6530
  { 7,  2}, // #6531
  {13,  1}, // #6532
  {14,  3}, // #6533
  {15,  1}, // #6534
  {16,  1}, // #6535
  {20,  2}, // #6536
  {23,  1}, // #6537
  {24,  1}, // #6538
  {25,  2}, // #6539
  {26,  3}, // #6540
  {27,  7}, // #6541
  { 3,  1}, // #6542
  { 7,  4}, // #6543
  {13,  1}, // #6544
  {14,  5}, // #6545
  {15,  1}, // #6546
  {16,  1}, // #6547
  {20,  4}, // #6548
  {23,  1}, // #6549
  {24,  1}, // #6550
  {25,  4}, // #6551
  {26,  3}, // #6552
  {27, 11}, // #6553
  { 3,  1}, // #6554
  { 7,  8}, // #6555
  {13,  1}, // #6556
  {14,  9}, // #6557
  {15,  1}, // #6558
  {16,  1}, // #6559
  {20,  8}, // #6560
  {23,  1}, // #6561
  {24,  1}, // #6562
  {25,  8}, // #6563
  {26,  3}, // #6564
  {27, 19}, // #6565
  { 3,  1}, // #6566
  { 7, 16}, // #6567
  { 8,  1}, // #6568
  {13,  1}, // #6569
  {14, 17}, // #6570
  {15,  2}, // #6571
  {16,  1}, // #6572
  {17,  1}, // #6573
  {20, 16}, // #6574
  {21,  1}, // #6575
  {23,  2}, // #6576
  {24,  2}, // #6577
  {25, 16}, // #6578
  {26,  4}, // #6579
  {27, 36}, // #6580
  { 3,  1}, // #6581
  { 7,  2}, // #6582
  { 8,  1}, // #6583
  {13,  1}, // #6584
  {14,  3}, // #6585
  {15,  2}, // #6586
  {16,  1}, // #6587
  {17,  1}, // #6588
  {20,  2}, // #6589
  {21,  1}, // #6590
  {23,  2}, // #6591
  {24,  2}, // #6592
  {25,  2}, // #6593
  {26,  4}, // #6594
  {27,  8}, // #6595
  { 3,  1}, // #6596
  { 7,  4}, // #6597
  { 8,  1}, // #6598
  {13,  1}, // #6599
  {14,  5}, // #6600
  {15,  2}, // #6601
  {16,  1}, // #6602
  {17,  1}, // #6603
  {20,  4}, // #6604
  {21,  1}, // #6605
  {23,  2}, // #6606
  {24,  2}, // #6607
  {25,  4}, // #6608
  {26,  4}, // #6609
  {27, 12}, // #6610
  { 3,  1}, // #6611
  { 7,  8}, // #6612
  { 8,  1}, // #6613
  {13,  1}, // #6614
  {14,  9}, // #6615
  {15,  2}, // #6616
  {16,  1}, // #6617
  {17,  1}, // #6618
  {20,  8}, // #6619
  {21,  1}, // #6620
  {23,  2}, // #6621
  {24,  2}, // #6622
  {25,  8}, // #6623
  {26,  4}, // #6624
  {27, 20}, // #6625
  {13,  3}, // #6626
  {23,  3}, // #6627
  {26,  3}, // #6628
  {27,  3}, // #6629
  {15,  3}, // #6630
  {23,  3}, // #6631
  {24,  3}, // #6632
  {26,  3}, // #6633
  {27,  3}, // #6634
  { 3,  1}, // #6635
  {13,  1}, // #6636
  {14,  1}, // #6637
  {15,  1}, // #6638
  {16,  1}, // #6639
  {19,  1}, // #6640
  {23,  2}, // #6641
  {24,  1}, // #6642
  {25,  1}, // #6643
  {26,  2}, // #6644
  {27,  3}, // #6645
  { 4,  1}, // #6646
  { 8,  2}, // #6647
  {13,  3}, // #6648
  {15,  2}, // #6649
  {17,  3}, // #6650
  {18,  1}, // #6651
  {19,  1}, // #6652
  {21,  2}, // #6653
  {23,  7}, // #6654
  {24,  2}, // #6655
  {25,  1}, // #6656
  {26,  7}, // #6657
  {27,  8}, // #6658
  {13,  3}, // #6659
  {19,  1}, // #6660
  {23,  3}, // #6661
  {25,  1}, // #6662
  {26,  3}, // #6663
  {27,  4}, // #6664
  {15,  3}, // #6665
  {19,  1}, // #6666
  {23,  3}, // #6667
  {24,  3}, // #6668
  {25,  1}, // #6669
  {26,  3}, // #6670
  {27,  4}, // #6671
  { 3,  1}, // #6672
  {13,  1}, // #6673
  {14,  1}, // #6674
  {15,  1}, // #6675
  {16,  1}, // #6676
  {19,  2}, // #6677
  {23,  2}, // #6678
  {24,  1}, // #6679
  {25,  2}, // #6680
  {26,  3}, // #6681
  {27,  5}, // #6682
  { 3,  1}, // #6683
  {13,  1}, // #6684
  {14,  1}, // #6685
  {15,  1}, // #6686
  {16,  1}, // #6687
  {19,  4}, // #6688
  {23,  2}, // #6689
  {24,  1}, // #6690
  {25,  4}, // #6691
  {26,  3}, // #6692
  {27,  7}, // #6693
  { 3,  1}, // #6694
  {13,  1}, // #6695
  {14,  1}, // #6696
  {15,  1}, // #6697
  {16,  1}, // #6698
  {19,  8}, // #6699
  {23,  2}, // #6700
  {24,  1}, // #6701
  {25,  8}, // #6702
  {26,  3}, // #6703
  {27, 11}, // #6704
  { 3,  1}, // #6705
  {13,  1}, // #6706
  {14,  1}, // #6707
  {15,  1}, // #6708
  {16,  1}, // #6709
  {19, 16}, // #6710
  {23,  2}, // #6711
  {24,  1}, // #6712
  {25, 16}, // #6713
  {26,  3}, // #6714
  {27, 19}, // #6715
  { 8,  5}, // #6716
  {13,  5}, // #6717
  {15,  5}, // #6718
  {17,  5}, // #6719
  {21,  5}, // #6720
  {23, 14}, // #6721
  {24,  5}, // #6722
  {26, 14}, // #6723
  {27, 14}, // #6724
  { 8,  5}, // #6725
  {13,  5}, // #6726
  {15,  5}, // #6727
  {17,  5}, // #6728
  {19,  1}, // #6729
  {21,  5}, // #6730
  {23, 14}, // #6731
  {24,  5}, // #6732
  {25,  1}, // #6733
  {26, 14}, // #6734
  {27, 15}, // #6735
  { 8,  9}, // #6736
  {13,  7}, // #6737
  {15,  9}, // #6738
  {17,  9}, // #6739
  {21,  9}, // #6740
  {23, 21}, // #6741
  {24,  9}, // #6742
  {26, 21}, // #6743
  {27, 21}, // #6744
  { 8,  9}, // #6745
  {13,  7}, // #6746
  {15,  9}, // #6747
  {17,  9}, // #6748
  {19,  1}, // #6749
  {21,  9}, // #6750
  {23, 21}, // #6751
  {24,  9}, // #6752
  {25,  1}, // #6753
  {26, 21}, // #6754
  {27, 22}, // #6755
  { 8, 17}, // #6756
  {13, 11}, // #6757
  {15, 17}, // #6758
  {17, 17}, // #6759
  {21, 17}, // #6760
  {23, 35}, // #6761
  {24, 17}, // #6762
  {26, 35}, // #6763
  {27, 35}, // #6764
  { 8, 17}, // #6765
  {13, 11}, // #6766
  {15, 17}, // #6767
  {17, 17}, // #6768
  {19,  1}, // #6769
  {21, 17}, // #6770
  {23, 35}, // #6771
  {24, 17}, // #6772
  {25,  1}, // #6773
  {26, 35}, // #6774
  {27, 36}, // #6775
  {16,  2}, // #6776
  {19,  1}, // #6777
  {24,  2}, // #6778
  {25,  1}, // #6779
  {26,  2}, // #6780
  {27,  3}, // #6781
  { 7,  1}, // #6782
  {14,  1}, // #6783
  {16,  2}, // #6784
  {20,  1}, // #6785
  {24,  2}, // #6786
  {25,  1}, // #6787
  {26,  2}, // #6788
  {27,  4}, // #6789
  { 1,  1}, // #6790
  { 4,  1}, // #6791
  {11,  1}, // #6792
  {15,  1}, // #6793
  {18,  1}, // #6794
  {20,  1}, // #6795
  {21,  1}, // #6796
  {22,  1}, // #6797
  { 1,  2}, // #6798
  { 4,  1}, // #6799
  { 1,  1}, // #6800
  {11,  1}, // #6801
  {12,  1}, // #6802
  {16,  1}, // #6803
  {17,  1}, // #6804
  {18,  1}, // #6805
  {22,  1}, // #6806
  { 1,  1}, // #6807
  {11,  1}, // #6808
  {16,  1}, // #6809
  {22,  1}, // #6810
  { 1,  1}, // #6811
  {11,  1}, // #6812
  {15,  1}, // #6813
  {18,  1}, // #6814
  {20,  1}, // #6815
  {21,  1}, // #6816
  {22,  1}, // #6817
  { 1,  1}, // #6818
  {11,  2}, // #6819
  {18,  2}, // #6820
  {22,  2}, // #6821
  { 1,  1}, // #6822
  {11,  2}, // #6823
  {15,  2}, // #6824
  {18,  2}, // #6825
  {20,  2}, // #6826
  {21,  2}, // #6827
  {22,  2}, // #6828
  { 1,  1}, // #6829
  { 4,  1}, // #6830
  { 7,  1}, // #6831
  {10, 17}, // #6832
  { 1,  1}, // #6833
  { 4,  1}, // #6834
  { 7,  1}, // #6835
  {10, 25}, // #6836
  { 1,  1}, // #6837
  { 4,  1}, // #6838
  { 7,  1}, // #6839
  {10, 41}, // #6840
  { 1,  1}, // #6841
  { 4,  1}, // #6842
  { 7,  1}, // #6843
  {10, 15}, // #6844
  { 1,  1}, // #6845
  {11,  5}, // #6846
  {14,  3}, // #6847
  {17,  3}, // #6848
  {19,  5}, // #6849
  {21,  3}, // #6850
  {11,  3}, // #6851
  {14,  2}, // #6852
  {17,  2}, // #6853
  {19,  3}, // #6854
  {21,  2}, // #6855
  { 1,  1}, // #6856
  { 4,  1}, // #6857
  { 6,  1}, // #6858
  {23,  1}, // #6859
  { 1,  1}, // #6860
  {11,  1}, // #6861
  {19,  1}, // #6862
  { 1,  1}, // #6863
  {11,  1}, // #6864
  {20,  1}, // #6865
  {22,  1}, // #6866
  {11,  1}, // #6867
  {14,  1}, // #6868
  {17,  1}, // #6869
  {19,  1}, // #6870
  {21,  1}, // #6871
  { 1,  1}, // #6872
  {11,  1}, // #6873
  {14,  1}, // #6874
  {17,  1}, // #6875
  {19,  1}, // #6876
  {21,  1}, // #6877
  { 1,  1}, // #6878
  { 4,  1}, // #6879
  { 6,  1}, // #6880
  {23,  2}, // #6881
  { 1,  1}, // #6882
  {11,  2}, // #6883
  {19,  2}, // #6884
  { 1,  1}, // #6885
  {11,  2}, // #6886
  {17,  2}, // #6887
  { 1,  1}, // #6888
  {11, 20}, // #6889
  {15, 20}, // #6890
  {18, 20}, // #6891
  {20, 20}, // #6892
  {21, 20}, // #6893
  {22, 20}, // #6894
  { 1,  1}, // #6895
  {11,  1}, // #6896
  {18,  1}, // #6897
  {22,  1}, // #6898
  { 1,  1}, // #6899
  {11, 22}, // #6900
  {15, 22}, // #6901
  {18, 22}, // #6902
  {20, 22}, // #6903
  {21, 22}, // #6904
  {22, 22}, // #6905
  {11, 15}, // #6906
  {15, 15}, // #6907
  {18, 15}, // #6908
  {20, 15}, // #6909
  {21, 15}, // #6910
  {22, 15}, // #6911
  { 1,  1}, // #6912
  {11, 19}, // #6913
  {15, 19}, // #6914
  {18, 19}, // #6915
  {20, 19}, // #6916
  {21, 19}, // #6917
  {22, 19}, // #6918
  {11, 12}, // #6919
  {15, 12}, // #6920
  {18, 12}, // #6921
  {20, 12}, // #6922
  {21, 12}, // #6923
  {22, 12}, // #6924
  { 1,  1}, // #6925
  {11,  2}, // #6926
  {16,  2}, // #6927
  {22,  2}, // #6928
  { 1,  1}, // #6929
  {11,  3}, // #6930
  {16,  3}, // #6931
  {22,  3}, // #6932
  {11,  2}, // #6933
  {14,  2}, // #6934
  {17,  2}, // #6935
  {19,  2}, // #6936
  {21,  2}, // #6937
  { 1,  1}, // #6938
  {11,  2}, // #6939
  {12,  2}, // #6940
  {16,  2}, // #6941
  {17,  2}, // #6942
  {18,  2}, // #6943
  {22,  2}, // #6944
  { 1,  1}, // #6945
  {11, 40}, // #6946
  {15, 40}, // #6947
  {18, 40}, // #6948
  {20, 40}, // #6949
  {21, 40}, // #6950
  {22, 40}, // #6951
  { 1,  1}, // #6952
  {11, 28}, // #6953
  {15, 28}, // #6954
  {18, 28}, // #6955
  {20, 28}, // #6956
  {21, 28}, // #6957
  {22, 28}, // #6958
  {11,  2}, // #6959
  {15,  1}, // #6960
  {18,  1}, // #6961
  {19,  1}, // #6962
  {20,  1}, // #6963
  {21,  1}, // #6964
  {22,  1}, // #6965
  { 1,  1}, // #6966
  {11,  2}, // #6967
  {15,  1}, // #6968
  {18,  1}, // #6969
  {19,  1}, // #6970
  {20,  1}, // #6971
  {21,  1}, // #6972
  {22,  1}, // #6973
  {11,  1}, // #6974
  {21,  1}, // #6975
  { 1,  1}, // #6976
  {11,  1}, // #6977
  {21,  1}, // #6978
  { 1,  1}, // #6979
  {11,  1}, // #6980
  {17,  1}, // #6981
  { 1,  5}, // #6982
  {11,  3}, // #6983
  {14,  2}, // #6984
  {17,  2}, // #6985
  {19,  3}, // #6986
  {21,  2}, // #6987
  { 1,  1}, // #6988
  {11,  2}, // #6989
  {22,  2}, // #6990
  { 1,  1}, // #6991
  {11,  2}, // #6992
  {14,  1}, // #6993
  {15,  1}, // #6994
  {17,  1}, // #6995
  {18,  1}, // #6996
  {19,  1}, // #6997
  {20,  1}, // #6998
  {21,  2}, // #6999
  {22,  1}, // #7000
  { 1,  1}, // #7001
  {11,  3}, // #7002
  {18,  3}, // #7003
  {22,  3}, // #7004
  {11,  2}, // #7005
  {15,  1}, // #7006
  {18,  1}, // #7007
  {20,  1}, // #7008
  {21,  1}, // #7009
  {22,  2}, // #7010
  { 1,  1}, // #7011
  {11,  2}, // #7012
  {13,  2}, // #7013
  {16,  2}, // #7014
  {19,  2}, // #7015
  {20,  2}, // #7016
  {22,  2}, // #7017
  { 1,  1}, // #7018
  { 4,  1}, // #7019
  { 9,  1}, // #7020
  {11,  1}, // #7021
  {22,  1}, // #7022
  { 1,  1}, // #7023
  {11,  1}, // #7024
  {22,  1}, // #7025
  {11,  2}, // #7026
  {14,  1}, // #7027
  {17,  1}, // #7028
  {19,  2}, // #7029
  {21,  1}, // #7030
  {11,  2}, // #7031
  {13,  1}, // #7032
  {16,  1}, // #7033
  {18,  1}, // #7034
  {19,  1}, // #7035
  {20,  1}, // #7036
  {22,  2}, // #7037
  {11,  1}, // #7038
  {13,  1}, // #7039
  {16,  1}, // #7040
  {19,  1}, // #7041
  {20,  1}, // #7042
  {22,  1}, // #7043
  { 1,  1}, // #7044
  {11,  1}, // #7045
  {13,  1}, // #7046
  {16,  1}, // #7047
  {19,  1}, // #7048
  {20,  1}, // #7049
  {22,  1}, // #7050
  {12,  1}, // #7051
  {16,  1}, // #7052
  {19,  1}, // #7053
  {21,  1}, // #7054
  {22,  1}, // #7055
  {23,  1}, // #7056
  { 1,  2}, // #7057
  { 5,  1}, // #7058
  { 1,  1}, // #7059
  {12,  1}, // #7060
  {13,  1}, // #7061
  {17,  1}, // #7062
  {18,  1}, // #7063
  {19,  1}, // #7064
  {23,  1}, // #7065
  { 1,  1}, // #7066
  {12,  1}, // #7067
  {17,  1}, // #7068
  {23,  1}, // #7069
  { 1,  1}, // #7070
  {12,  1}, // #7071
  {16,  1}, // #7072
  {19,  1}, // #7073
  {21,  1}, // #7074
  {22,  1}, // #7075
  {23,  1}, // #7076
  { 1,  1}, // #7077
  {12,  1}, // #7078
  {19,  1}, // #7079
  {23,  1}, // #7080
  { 1,  1}, // #7081
  {12,  2}, // #7082
  {16,  2}, // #7083
  {19,  2}, // #7084
  {21,  2}, // #7085
  {22,  2}, // #7086
  {23,  2}, // #7087
  { 1,  1}, // #7088
  { 5,  1}, // #7089
  { 8,  1}, // #7090
  {11, 17}, // #7091
  { 1,  1}, // #7092
  { 5,  1}, // #7093
  { 8,  1}, // #7094
  {11, 25}, // #7095
  { 1,  1}, // #7096
  { 5,  1}, // #7097
  { 8,  1}, // #7098
  {11, 41}, // #7099
  { 1,  1}, // #7100
  { 5,  1}, // #7101
  { 8,  1}, // #7102
  {11, 15}, // #7103
  { 1,  1}, // #7104
  {12,  5}, // #7105
  {15,  3}, // #7106
  {18,  3}, // #7107
  {20,  5}, // #7108
  {22,  3}, // #7109
  {12,  3}, // #7110
  {15,  2}, // #7111
  {18,  2}, // #7112
  {20,  3}, // #7113
  {22,  2}, // #7114
  { 1,  1}, // #7115
  { 5,  1}, // #7116
  { 7,  1}, // #7117
  {24,  1}, // #7118
  { 1,  1}, // #7119
  {12,  1}, // #7120
  {20,  1}, // #7121
  { 1,  1}, // #7122
  {12,  1}, // #7123
  {21,  1}, // #7124
  {23,  1}, // #7125
  {12,  1}, // #7126
  {15,  1}, // #7127
  {18,  1}, // #7128
  {20,  1}, // #7129
  {22,  1}, // #7130
  { 1,  1}, // #7131
  {12,  1}, // #7132
  {15,  1}, // #7133
  {18,  1}, // #7134
  {20,  1}, // #7135
  {22,  1}, // #7136
  { 1,  1}, // #7137
  { 5,  1}, // #7138
  { 7,  1}, // #7139
  {24,  2}, // #7140
  { 1,  1}, // #7141
  {12,  2}, // #7142
  {20,  2}, // #7143
  { 1,  1}, // #7144
  {12,  2}, // #7145
  {18,  2}, // #7146
  {12,  1}, // #7147
  {18,  1}, // #7148
  { 1,  1}, // #7149
  {12, 20}, // #7150
  {16, 20}, // #7151
  {19, 20}, // #7152
  {21, 20}, // #7153
  {22, 20}, // #7154
  {23, 20}, // #7155
  {12, 13}, // #7156
  {16, 13}, // #7157
  {19, 13}, // #7158
  {21, 13}, // #7159
  {22, 13}, // #7160
  {23, 13}, // #7161
  { 1,  1}, // #7162
  {12, 17}, // #7163
  {16, 17}, // #7164
  {19, 17}, // #7165
  {21, 17}, // #7166
  {22, 17}, // #7167
  {23, 17}, // #7168
  {12, 10}, // #7169
  {16, 10}, // #7170
  {19, 10}, // #7171
  {21, 10}, // #7172
  {22, 10}, // #7173
  {23, 10}, // #7174
  { 1,  1}, // #7175
  {12,  2}, // #7176
  {17,  2}, // #7177
  {23,  2}, // #7178
  {12,  2}, // #7179
  {15,  2}, // #7180
  {18,  2}, // #7181
  {20,  2}, // #7182
  {22,  2}, // #7183
  { 1,  1}, // #7184
  {12, 28}, // #7185
  {16, 28}, // #7186
  {19, 28}, // #7187
  {21, 28}, // #7188
  {22, 28}, // #7189
  {23, 28}, // #7190
  {12,  2}, // #7191
  {16,  1}, // #7192
  {19,  1}, // #7193
  {20,  1}, // #7194
  {21,  1}, // #7195
  {22,  1}, // #7196
  {23,  1}, // #7197
  { 1,  1}, // #7198
  {12,  2}, // #7199
  {16,  1}, // #7200
  {19,  1}, // #7201
  {20,  1}, // #7202
  {21,  1}, // #7203
  {22,  1}, // #7204
  {23,  1}, // #7205
  {12,  1}, // #7206
  {22,  1}, // #7207
  { 1,  1}, // #7208
  {12,  1}, // #7209
  {22,  1}, // #7210
  { 1,  1}, // #7211
  {12,  1}, // #7212
  {18,  1}, // #7213
  { 1,  5}, // #7214
  {12,  3}, // #7215
  {15,  2}, // #7216
  {18,  2}, // #7217
  {20,  3}, // #7218
  {22,  2}, // #7219
  { 1,  1}, // #7220
  {12,  1}, // #7221
  {23,  1}, // #7222
  { 1,  1}, // #7223
  {12,  2}, // #7224
  {15,  1}, // #7225
  {16,  1}, // #7226
  {18,  1}, // #7227
  {19,  1}, // #7228
  {20,  1}, // #7229
  {21,  1}, // #7230
  {22,  2}, // #7231
  {23,  1}, // #7232
  { 1,  1}, // #7233
  {12,  3}, // #7234
  {19,  3}, // #7235
  {23,  3}, // #7236
  { 1,  1}, // #7237
  {12,  3}, // #7238
  {17,  3}, // #7239
  {23,  3}, // #7240
  {12,  2}, // #7241
  {16,  1}, // #7242
  {19,  1}, // #7243
  {21,  1}, // #7244
  {22,  1}, // #7245
  {23,  2}, // #7246
  { 1,  1}, // #7247
  {12,  2}, // #7248
  {14,  2}, // #7249
  {17,  2}, // #7250
  {20,  2}, // #7251
  {21,  2}, // #7252
  {23,  2}, // #7253
  { 1,  1}, // #7254
  { 5,  1}, // #7255
  {10,  1}, // #7256
  {12,  2}, // #7257
  {15,  1}, // #7258
  {18,  1}, // #7259
  {20,  2}, // #7260
  {22,  1}, // #7261
  {12,  2}, // #7262
  {14,  1}, // #7263
  {17,  1}, // #7264
  {19,  1}, // #7265
  {20,  1}, // #7266
  {21,  1}, // #7267
  {23,  2}, // #7268
  {12,  1}, // #7269
  {14,  1}, // #7270
  {17,  1}, // #7271
  {20,  1}, // #7272
  {21,  1}, // #7273
  {23,  1}, // #7274
  { 1,  1}, // #7275
  {12,  1}, // #7276
  {14,  1}, // #7277
  {17,  1}, // #7278
  {20,  1}, // #7279
  {21,  1}, // #7280
  {23,  1}, // #7281
  {11,  1}, // #7282
  {36,  1}, // #7283
  {11,  0}, // #7284
  {36,  0}, // #7285
  {14,  1}, // #7286
  {20,  1}, // #7287
  {28,  1}, // #7288
  {31,  1}, // #7289
  {32,  1}, // #7290
  {13,  1}, // #7291
  {36,  1}, // #7292
  {11, 12}, // #7293
  {36, 12}, // #7294
  { 4,  1}, // #7295
  {13,  1}, // #7296
  {36,  2}, // #7297
  {37,  1}, // #7298
  {38,  1}, // #7299
  {11,  4}, // #7300
  {36,  4}, // #7301
  {11, 100}, // #7302
  {36, 100}, // #7303
  {10,  3}, // #7304
  {11,  3}, // #7305
  {36,  3}, // #7306
  {26,  1}, // #7307
  {27,  1}, // #7308
  {37,  1}, // #7309
  {39,  1}, // #7310
  {14,  1}, // #7311
  {26,  1}, // #7312
  {37,  1}, // #7313
  {38,  1}, // #7314
  {14,  2}, // #7315
  {15,  2}, // #7316
  {16,  2}, // #7317
  {20,  2}, // #7318
  {21,  2}, // #7319
  {28,  2}, // #7320
  {29,  2}, // #7321
  {31,  2}, // #7322
  {32,  2}, // #7323
  { 4,  2}, // #7324
  {11,  4}, // #7325
  {36,  6}, // #7326
  {37,  2}, // #7327
  {38,  1}, // #7328
  {39,  1}, // #7329
  { 4,  1}, // #7330
  {11,  4}, // #7331
  {36,  5}, // #7332
  {37,  1}, // #7333
  {38,  1}, // #7334
  { 4,  2}, // #7335
  {11,  1}, // #7336
  {36,  3}, // #7337
  {37,  2}, // #7338
  {38,  1}, // #7339
  {39,  1}, // #7340
  { 4,  1}, // #7341
  {11,  1}, // #7342
  {36,  2}, // #7343
  {37,  1}, // #7344
  {38,  1}, // #7345
  {14,  2}, // #7346
  {17,  1}, // #7347
  {18,  1}, // #7348
  {20,  1}, // #7349
  {26,  1}, // #7350
  {28,  1}, // #7351
  {31,  1}, // #7352
  {32,  1}, // #7353
  {37,  1}, // #7354
  {38,  1}, // #7355
  {14,  1}, // #7356
  {17,  1}, // #7357
  {18,  1}, // #7358
  {20,  1}, // #7359
  {28,  1}, // #7360
  {31,  1}, // #7361
  {32,  1}, // #7362
  {14,  2}, // #7363
  {15,  1}, // #7364
  {16,  1}, // #7365
  {20,  1}, // #7366
  {21,  1}, // #7367
  {26,  1}, // #7368
  {28,  1}, // #7369
  {29,  1}, // #7370
  {31,  1}, // #7371
  {32,  1}, // #7372
  {37,  1}, // #7373
  {38,  1}, // #7374
  {14,  1}, // #7375
  {15,  1}, // #7376
  {16,  1}, // #7377
  {20,  1}, // #7378
  {21,  1}, // #7379
  {28,  1}, // #7380
  {29,  1}, // #7381
  {31,  1}, // #7382
  {32,  1}, // #7383
  {14,  2}, // #7384
  {20,  1}, // #7385
  {26,  1}, // #7386
  {28,  1}, // #7387
  {31,  1}, // #7388
  {32,  1}, // #7389
  {37,  1}, // #7390
  {38,  1}, // #7391
  { 4,  1}, // #7392
  {10,  1}, // #7393
  {11,  1}, // #7394
  {36,  2}, // #7395
  {37,  1}, // #7396
  {38,  1}, // #7397
  {10,  1}, // #7398
  {11,  1}, // #7399
  {36,  1}, // #7400
  { 4,  1}, // #7401
  {11,  2}, // #7402
  {36,  3}, // #7403
  {37,  1}, // #7404
  {38,  1}, // #7405
  {11,  2}, // #7406
  {36,  2}, // #7407
  { 4,  1}, // #7408
  { 6,  3}, // #7409
  {10,  3}, // #7410
  {11,  3}, // #7411
  {36,  4}, // #7412
  {37,  1}, // #7413
  {38,  1}, // #7414
  { 6,  3}, // #7415
  {10,  3}, // #7416
  {11,  3}, // #7417
  {36,  3}, // #7418
  { 4,  1}, // #7419
  { 6,  4}, // #7420
  {10,  4}, // #7421
  {11,  4}, // #7422
  {36,  5}, // #7423
  {37,  1}, // #7424
  {38,  1}, // #7425
  { 6,  4}, // #7426
  {10,  4}, // #7427
  {11,  4}, // #7428
  {36,  4}, // #7429
  { 4,  2}, // #7430
  {10,  1}, // #7431
  {11,  1}, // #7432
  {36,  3}, // #7433
  {37,  2}, // #7434
  {38,  1}, // #7435
  {39,  1}, // #7436
  {10,  2}, // #7437
  {11,  2}, // #7438
  {36,  2}, // #7439
  { 4,  1}, // #7440
  {36,  1}, // #7441
  {37,  1}, // #7442
  {38,  1}, // #7443
  { 4,  1}, // #7444
  { 9,  1}, // #7445
  {11,  1}, // #7446
  {36,  2}, // #7447
  {37,  1}, // #7448
  {38,  1}, // #7449
  { 9,  1}, // #7450
  {11,  1}, // #7451
  {36,  1}, // #7452
  {11, 28}, // #7453
  {36, 28}, // #7454
  {14,  3}, // #7455
  {15,  2}, // #7456
  {16,  2}, // #7457
  {20,  2}, // #7458
  {21,  2}, // #7459
  {26,  1}, // #7460
  {28,  2}, // #7461
  {29,  2}, // #7462
  {31,  2}, // #7463
  {32,  2}, // #7464
  {37,  1}, // #7465
  {38,  1}, // #7466
  { 4,  1}, // #7467
  { 6,  1}, // #7468
  {10,  1}, // #7469
  {11,  1}, // #7470
  {36,  2}, // #7471
  {37,  1}, // #7472
  {38,  1}, // #7473
  { 6,  1}, // #7474
  {10,  1}, // #7475
  {11,  1}, // #7476
  {36,  1}, // #7477
  {14,  3}, // #7478
  {17,  2}, // #7479
  {18,  2}, // #7480
  {20,  2}, // #7481
  {26,  1}, // #7482
  {28,  2}, // #7483
  {31,  2}, // #7484
  {32,  2}, // #7485
  {37,  1}, // #7486
  {38,  1}, // #7487
  {14,  2}, // #7488
  {17,  2}, // #7489
  {18,  2}, // #7490
  {20,  2}, // #7491
  {28,  2}, // #7492
  {31,  2}, // #7493
  {32,  2}, // #7494
  { 4,  1}, // #7495
  { 5, 11}, // #7496
  { 9, 11}, // #7497
  {11, 11}, // #7498
  {13, 11}, // #7499
  {36, 12}, // #7500
  {37,  1}, // #7501
  {38,  1}, // #7502
  { 5, 11}, // #7503
  { 9, 11}, // #7504
  {11, 11}, // #7505
  {13, 11}, // #7506
  {36, 11}, // #7507
  { 4,  1}, // #7508
  { 5, 13}, // #7509
  { 9, 13}, // #7510
  {11, 13}, // #7511
  {13, 13}, // #7512
  {36, 14}, // #7513
  {37,  1}, // #7514
  {38,  1}, // #7515
  { 5, 13}, // #7516
  { 9, 13}, // #7517
  {11, 13}, // #7518
  {13, 13}, // #7519
  {36, 13}, // #7520
  { 4,  1}, // #7521
  { 5, 17}, // #7522
  { 9, 17}, // #7523
  {11, 17}, // #7524
  {13, 17}, // #7525
  {36, 18}, // #7526
  {37,  1}, // #7527
  {38,  1}, // #7528
  { 5, 17}, // #7529
  { 9, 17}, // #7530
  {11, 17}, // #7531
  {13, 17}, // #7532
  {36, 17}, // #7533
  { 4,  1}, // #7534
  { 5, 10}, // #7535
  { 9, 10}, // #7536
  {11, 10}, // #7537
  {13, 10}, // #7538
  {36, 11}, // #7539
  {37,  1}, // #7540
  {38,  1}, // #7541
  { 5, 10}, // #7542
  { 9, 10}, // #7543
  {11, 10}, // #7544
  {13, 10}, // #7545
  {36, 10}, // #7546
  {14,  6}, // #7547
  {15,  5}, // #7548
  {16,  5}, // #7549
  {19,  5}, // #7550
  {20,  5}, // #7551
  {21,  5}, // #7552
  {23,  5}, // #7553
  {26,  1}, // #7554
  {28,  5}, // #7555
  {29,  5}, // #7556
  {30,  5}, // #7557
  {31,  5}, // #7558
  {32,  5}, // #7559
  {34,  5}, // #7560
  {35,  5}, // #7561
  {37,  1}, // #7562
  {38,  1}, // #7563
  {14,  5}, // #7564
  {15,  5}, // #7565
  {16,  5}, // #7566
  {19,  5}, // #7567
  {20,  5}, // #7568
  {21,  5}, // #7569
  {23,  5}, // #7570
  {28,  5}, // #7571
  {29,  5}, // #7572
  {30,  5}, // #7573
  {31,  5}, // #7574
  {32,  5}, // #7575
  {34,  5}, // #7576
  {35,  5}, // #7577
  {14,  4}, // #7578
  {15,  3}, // #7579
  {16,  3}, // #7580
  {19,  3}, // #7581
  {20,  3}, // #7582
  {21,  3}, // #7583
  {23,  3}, // #7584
  {26,  1}, // #7585
  {28,  3}, // #7586
  {29,  3}, // #7587
  {30,  3}, // #7588
  {31,  3}, // #7589
  {32,  3}, // #7590
  {34,  3}, // #7591
  {35,  3}, // #7592
  {37,  1}, // #7593
  {38,  1}, // #7594
  {14,  3}, // #7595
  {15,  3}, // #7596
  {16,  3}, // #7597
  {19,  3}, // #7598
  {20,  3}, // #7599
  {21,  3}, // #7600
  {23,  3}, // #7601
  {28,  3}, // #7602
  {29,  3}, // #7603
  {30,  3}, // #7604
  {31,  3}, // #7605
  {32,  3}, // #7606
  {34,  3}, // #7607
  {35,  3}, // #7608
  {14,  7}, // #7609
  {15,  6}, // #7610
  {16,  6}, // #7611
  {20,  6}, // #7612
  {21,  6}, // #7613
  {26,  1}, // #7614
  {28,  6}, // #7615
  {29,  6}, // #7616
  {31,  6}, // #7617
  {32,  6}, // #7618
  {37,  1}, // #7619
  {38,  1}, // #7620
  {14,  6}, // #7621
  {15,  6}, // #7622
  {16,  6}, // #7623
  {20,  6}, // #7624
  {21,  6}, // #7625
  {28,  6}, // #7626
  {29,  6}, // #7627
  {31,  6}, // #7628
  {32,  6}, // #7629
  {14,  9}, // #7630
  {15,  8}, // #7631
  {16,  8}, // #7632
  {20,  8}, // #7633
  {21,  8}, // #7634
  {26,  1}, // #7635
  {28,  8}, // #7636
  {29,  8}, // #7637
  {31,  8}, // #7638
  {32,  8}, // #7639
  {37,  1}, // #7640
  {38,  1}, // #7641
  {14,  8}, // #7642
  {15,  8}, // #7643
  {16,  8}, // #7644
  {20,  8}, // #7645
  {21,  8}, // #7646
  {28,  8}, // #7647
  {29,  8}, // #7648
  {31,  8}, // #7649
  {32,  8}, // #7650
  { 4,  1}, // #7651
  {36,  1}, // #7652
  {37,  2}, // #7653
  {39,  2}, // #7654
  {14,  2}, // #7655
  {26,  2}, // #7656
  {14,  2}, // #7657
  {15,  1}, // #7658
  {16,  1}, // #7659
  {19,  1}, // #7660
  {20,  1}, // #7661
  {21,  1}, // #7662
  {23,  1}, // #7663
  {26,  1}, // #7664
  {28,  1}, // #7665
  {29,  1}, // #7666
  {30,  1}, // #7667
  {31,  1}, // #7668
  {32,  1}, // #7669
  {34,  1}, // #7670
  {35,  1}, // #7671
  {37,  1}, // #7672
  {38,  1}, // #7673
  {14,  3}, // #7674
  {17,  2}, // #7675
  {18,  2}, // #7676
  {19,  2}, // #7677
  {20,  2}, // #7678
  {24,  2}, // #7679
  {26,  1}, // #7680
  {28,  2}, // #7681
  {30,  2}, // #7682
  {31,  2}, // #7683
  {32,  2}, // #7684
  {34,  2}, // #7685
  {35,  2}, // #7686
  {37,  1}, // #7687
  {38,  1}, // #7688
  {14,  2}, // #7689
  {17,  2}, // #7690
  {18,  2}, // #7691
  {19,  2}, // #7692
  {20,  2}, // #7693
  {24,  2}, // #7694
  {28,  2}, // #7695
  {30,  2}, // #7696
  {31,  2}, // #7697
  {32,  2}, // #7698
  {34,  2}, // #7699
  {35,  2}, // #7700
  {14,  2}, // #7701
  {19,  1}, // #7702
  {20,  1}, // #7703
  {26,  1}, // #7704
  {28,  1}, // #7705
  {30,  1}, // #7706
  {31,  1}, // #7707
  {32,  1}, // #7708
  {34,  1}, // #7709
  {35,  1}, // #7710
  {37,  1}, // #7711
  {38,  1}, // #7712
  {14,  1}, // #7713
  {19,  1}, // #7714
  {20,  1}, // #7715
  {28,  1}, // #7716
  {30,  1}, // #7717
  {31,  1}, // #7718
  {32,  1}, // #7719
  {34,  1}, // #7720
  {35,  1}, // #7721
  { 8,  1}, // #7722
  { 9,  1}, // #7723
  {11,  1}, // #7724
  {36,  1}, // #7725
  { 4,  1}, // #7726
  {11,  6}, // #7727
  {36,  7}, // #7728
  {37,  1}, // #7729
  {38,  1}, // #7730
  {14,  3}, // #7731
  {15,  2}, // #7732
  {16,  2}, // #7733
  {20,  2}, // #7734
  {21,  2}, // #7735
  {22,  2}, // #7736
  {26,  1}, // #7737
  {28,  2}, // #7738
  {29,  2}, // #7739
  {31,  2}, // #7740
  {32,  2}, // #7741
  {33,  2}, // #7742
  {37,  1}, // #7743
  {38,  1}, // #7744
  {14,  2}, // #7745
  {15,  2}, // #7746
  {16,  2}, // #7747
  {20,  2}, // #7748
  {21,  2}, // #7749
  {22,  2}, // #7750
  {28,  2}, // #7751
  {29,  2}, // #7752
  {31,  2}, // #7753
  {32,  2}, // #7754
  {33,  2}, // #7755
  {14,  3}, // #7756
  {26,  3}, // #7757
  {37,  1}, // #7758
  {38,  1}, // #7759
  {14,  2}, // #7760
  {20,  1}, // #7761
  {26,  1}, // #7762
  {28,  1}, // #7763
  {31,  1}, // #7764
  {32,  1}, // #7765
  {33,  1}, // #7766
  {37,  1}, // #7767
  {38,  1}, // #7768
  {14,  1}, // #7769
  {20,  1}, // #7770
  {28,  1}, // #7771
  {31,  1}, // #7772
  {32,  1}, // #7773
  {33,  1}, // #7774
  {14,  1}, // #7775
  {17,  1}, // #7776
  {18,  1}, // #7777
  {19,  1}, // #7778
  {20,  1}, // #7779
  {24,  1}, // #7780
  {28,  1}, // #7781
  {30,  1}, // #7782
  {31,  1}, // #7783
  {32,  1}, // #7784
  {34,  1}, // #7785
  {35,  1}, // #7786
  {14,  3}, // #7787
  {20,  2}, // #7788
  {26,  1}, // #7789
  {28,  2}, // #7790
  {31,  2}, // #7791
  {32,  2}, // #7792
  {37,  1}, // #7793
  {38,  1}, // #7794
  {14,  2}, // #7795
  {20,  2}, // #7796
  {28,  2}, // #7797
  {31,  2}, // #7798
  {32,  2}, // #7799
  {14,  9}, // #7800
  {20,  8}, // #7801
  {26,  1}, // #7802
  {28,  8}, // #7803
  {31,  8}, // #7804
  {32,  8}, // #7805
  {37,  1}, // #7806
  {38,  1}, // #7807
  {14,  8}, // #7808
  {20,  8}, // #7809
  {28,  8}, // #7810
  {31,  8}, // #7811
  {32,  8}, // #7812
  {14,  5}, // #7813
  {15,  4}, // #7814
  {16,  4}, // #7815
  {20,  4}, // #7816
  {21,  4}, // #7817
  {26,  1}, // #7818
  {28,  4}, // #7819
  {29,  4}, // #7820
  {31,  4}, // #7821
  {32,  4}, // #7822
  {37,  1}, // #7823
  {38,  1}, // #7824
  {14,  4}, // #7825
  {15,  4}, // #7826
  {16,  4}, // #7827
  {20,  4}, // #7828
  {21,  4}, // #7829
  {28,  4}, // #7830
  {29,  4}, // #7831
  {31,  4}, // #7832
  {32,  4}, // #7833
  {14, 13}, // #7834
  {20, 12}, // #7835
  {26,  1}, // #7836
  {28, 12}, // #7837
  {31, 12}, // #7838
  {32, 12}, // #7839
  {37,  1}, // #7840
  {38,  1}, // #7841
  {14, 12}, // #7842
  {20, 12}, // #7843
  {28, 12}, // #7844
  {31, 12}, // #7845
  {32, 12}, // #7846
  { 4,  2}, // #7847
  {36,  2}, // #7848
  {37,  3}, // #7849
  {38,  1}, // #7850
  {39,  2}, // #7851
  {14,  2}, // #7852
  {19,  1}, // #7853
  {20,  1}, // #7854
  {26,  2}, // #7855
  {27,  1}, // #7856
  {28,  1}, // #7857
  {30,  1}, // #7858
  {31,  1}, // #7859
  {32,  1}, // #7860
  {34,  1}, // #7861
  {35,  1}, // #7862
  {37,  1}, // #7863
  {38,  1}, // #7864
  {14,  1}, // #7865
  {19,  1}, // #7866
  {20,  1}, // #7867
  {26,  1}, // #7868
  {27,  1}, // #7869
  {28,  1}, // #7870
  {30,  1}, // #7871
  {31,  1}, // #7872
  {32,  1}, // #7873
  {34,  1}, // #7874
  {35,  1}, // #7875
  { 4,  1}, // #7876
  {36,  1}, // #7877
  {37,  1}, // #7878
  {39,  1}, // #7879
  {14,  1}, // #7880
  {15,  1}, // #7881
  {16,  1}, // #7882
  {19,  1}, // #7883
  {20,  1}, // #7884
  {21,  1}, // #7885
  {23,  1}, // #7886
  {28,  1}, // #7887
  {29,  1}, // #7888
  {30,  1}, // #7889
  {31,  1}, // #7890
  {32,  1}, // #7891
  {34,  1}, // #7892
  {35,  1}, // #7893
  { 4,  1}, // #7894
  { 9,  2}, // #7895
  {11,  2}, // #7896
  {36,  3}, // #7897
  {37,  1}, // #7898
  {39,  1}, // #7899
  { 9,  2}, // #7900
  {11,  2}, // #7901
  {36,  2}, // #7902
  { 4,  1}, // #7903
  {10,  4}, // #7904
  {11,  4}, // #7905
  {36,  5}, // #7906
  {37,  1}, // #7907
  {38,  1}, // #7908
  {14, 10}, // #7909
  {15,  9}, // #7910
  {16,  9}, // #7911
  {19,  9}, // #7912
  {20,  9}, // #7913
  {21,  9}, // #7914
  {23,  9}, // #7915
  {26,  1}, // #7916
  {28,  9}, // #7917
  {29,  9}, // #7918
  {30,  9}, // #7919
  {31,  9}, // #7920
  {32,  9}, // #7921
  {34,  9}, // #7922
  {35,  9}, // #7923
  {37,  1}, // #7924
  {38,  1}, // #7925
  {14,  9}, // #7926
  {15,  9}, // #7927
  {16,  9}, // #7928
  {19,  9}, // #7929
  {20,  9}, // #7930
  {21,  9}, // #7931
  {23,  9}, // #7932
  {28,  9}, // #7933
  {29,  9}, // #7934
  {30,  9}, // #7935
  {31,  9}, // #7936
  {32,  9}, // #7937
  {34,  9}, // #7938
  {35,  9}, // #7939
  {14, 23}, // #7940
  {15, 23}, // #7941
  {16, 23}, // #7942
  {19, 23}, // #7943
  {20, 23}, // #7944
  {21, 23}, // #7945
  {23, 23}, // #7946
  {28, 23}, // #7947
  {29, 23}, // #7948
  {30, 23}, // #7949
  {31, 23}, // #7950
  {32, 23}, // #7951
  {34, 23}, // #7952
  {35, 23}, // #7953
  { 4,  1}, // #7954
  {11, 60}, // #7955
  {36, 61}, // #7956
  {37,  1}, // #7957
  {39,  1}, // #7958
  {14,  2}, // #7959
  {17,  2}, // #7960
  {18,  2}, // #7961
  {20,  2}, // #7962
  {26,  1}, // #7963
  {27,  1}, // #7964
  {28,  2}, // #7965
  {31,  2}, // #7966
  {32,  2}, // #7967
  {37,  1}, // #7968
  {39,  1}, // #7969
  {14,  1}, // #7970
  {17,  1}, // #7971
  {18,  1}, // #7972
  {20,  1}, // #7973
  {26,  1}, // #7974
  {27,  1}, // #7975
  {28,  1}, // #7976
  {31,  1}, // #7977
  {32,  1}, // #7978
  {37,  1}, // #7979
  {39,  1}, // #7980
  {26,  6}, // #7981
  {27,  6}, // #7982
  {37,  1}, // #7983
  {39,  1}, // #7984
  {26,  4}, // #7985
  {27,  4}, // #7986
  {37,  1}, // #7987
  {39,  1}, // #7988
  {26, 12}, // #7989
  {27, 12}, // #7990
  {37,  1}, // #7991
  {39,  1}, // #7992
  {14,  4}, // #7993
  {19,  3}, // #7994
  {20,  3}, // #7995
  {26,  1}, // #7996
  {28,  3}, // #7997
  {30,  3}, // #7998
  {31,  3}, // #7999
  {32,  3}, // #8000
  {34,  3}, // #8001
  {35,  3}, // #8002
  {37,  1}, // #8003
  {38,  1}, // #8004
  {14,  3}, // #8005
  {19,  3}, // #8006
  {20,  3}, // #8007
  {28,  3}, // #8008
  {30,  3}, // #8009
  {31,  3}, // #8010
  {32,  3}, // #8011
  {34,  3}, // #8012
  {35,  3}, // #8013
  {14,  3}, // #8014
  {19,  2}, // #8015
  {20,  2}, // #8016
  {26,  1}, // #8017
  {28,  2}, // #8018
  {30,  2}, // #8019
  {31,  2}, // #8020
  {32,  2}, // #8021
  {34,  2}, // #8022
  {35,  2}, // #8023
  {37,  1}, // #8024
  {38,  1}, // #8025
  {14,  2}, // #8026
  {19,  2}, // #8027
  {20,  2}, // #8028
  {28,  2}, // #8029
  {30,  2}, // #8030
  {31,  2}, // #8031
  {32,  2}, // #8032
  {34,  2}, // #8033
  {35,  2}, // #8034
  {11,  8}, // #8035
  {36,  8}, // #8036
  { 4,  1}, // #8037
  {10,  8}, // #8038
  {11,  8}, // #8039
  {36,  9}, // #8040
  {37,  1}, // #8041
  {38,  1}, // #8042
  {37, 30}, // #8043
  { 4,  3}, // #8044
  {36,  3}, // #8045
  {37,  1}, // #8046
  {38,  1}, // #8047
  { 4,  1}, // #8048
  {11, 12}, // #8049
  {36, 13}, // #8050
  {37,  1}, // #8051
  {38,  1}, // #8052
  {11, 24}, // #8053
  {36, 24}, // #8054
  {11, 59}, // #8055
  {36, 59}, // #8056
  {10,  6}, // #8057
  {11,  6}, // #8058
  {36,  6}, // #8059
  {10,  8}, // #8060
  {11,  8}, // #8061
  {36,  8}, // #8062
  { 4,  1}, // #8063
  {14,  1}, // #8064
  {15,  1}, // #8065
  {16,  1}, // #8066
  {20,  1}, // #8067
  {21,  1}, // #8068
  {22,  1}, // #8069
  {28,  1}, // #8070
  {29,  1}, // #8071
  {31,  1}, // #8072
  {32,  1}, // #8073
  {33,  1}, // #8074
  {36,  1}, // #8075
  {37,  1}, // #8076
  {38,  1}, // #8077
  { 4,  1}, // #8078
  {14, 24}, // #8079
  {20, 24}, // #8080
  {28, 24}, // #8081
  {31, 24}, // #8082
  {32, 24}, // #8083
  {36,  1}, // #8084
  {37,  1}, // #8085
  {38,  1}, // #8086
  { 4,  1}, // #8087
  {14, 62}, // #8088
  {20, 62}, // #8089
  {28, 62}, // #8090
  {31, 62}, // #8091
  {32, 62}, // #8092
  {36,  1}, // #8093
  {37,  1}, // #8094
  {38,  1}, // #8095
  { 4,  1}, // #8096
  {11,  4}, // #8097
  {36,  5}, // #8098
  {37,  1}, // #8099
  {39,  1}, // #8100
  {14,  6}, // #8101
  {17,  6}, // #8102
  {18,  6}, // #8103
  {20,  6}, // #8104
  {28,  6}, // #8105
  {31,  6}, // #8106
  {32,  6}, // #8107
  { 4,  1}, // #8108
  {14,  1}, // #8109
  {15,  1}, // #8110
  {16,  1}, // #8111
  {19,  1}, // #8112
  {20,  1}, // #8113
  {21,  1}, // #8114
  {23,  1}, // #8115
  {28,  1}, // #8116
  {29,  1}, // #8117
  {30,  1}, // #8118
  {31,  1}, // #8119
  {32,  1}, // #8120
  {34,  1}, // #8121
  {35,  1}, // #8122
  {36,  1}, // #8123
  {37,  1}, // #8124
  {38,  1}, // #8125
  {14,  1}, // #8126
  {15,  1}, // #8127
  {16,  1}, // #8128
  {20,  1}, // #8129
  {21,  1}, // #8130
  {22,  1}, // #8131
  {26,  1}, // #8132
  {27,  1}, // #8133
  {28,  1}, // #8134
  {29,  1}, // #8135
  {31,  1}, // #8136
  {32,  1}, // #8137
  {33,  1}, // #8138
  {37,  1}, // #8139
  {39,  1}, // #8140
  { 4,  1}, // #8141
  {14,  8}, // #8142
  {20,  8}, // #8143
  {28,  8}, // #8144
  {31,  8}, // #8145
  {32,  8}, // #8146
  {36,  1}, // #8147
  {37,  1}, // #8148
  {38,  1}, // #8149
  {14,  3}, // #8150
  {20,  3}, // #8151
  {28,  3}, // #8152
  {31,  3}, // #8153
  {32,  3}, // #8154
  { 4,  1}, // #8155
  {14,  3}, // #8156
  {20,  3}, // #8157
  {28,  3}, // #8158
  {31,  3}, // #8159
  {32,  3}, // #8160
  {36,  1}, // #8161
  {37,  1}, // #8162
  {38,  1}, // #8163
  { 4,  1}, // #8164
  {14,  2}, // #8165
  {20,  2}, // #8166
  {28,  2}, // #8167
  {31,  2}, // #8168
  {32,  2}, // #8169
  {36,  1}, // #8170
  {37,  1}, // #8171
  {38,  1}, // #8172
  { 4,  1}, // #8173
  {11,  7}, // #8174
  {36,  8}, // #8175
  {37,  2}, // #8176
  {38,  1}, // #8177
  {39,  1}, // #8178
  { 4,  1}, // #8179
  {10,  2}, // #8180
  {11,  2}, // #8181
  {36,  3}, // #8182
  {37,  1}, // #8183
  {38,  1}, // #8184
  {14,  5}, // #8185
  {20,  4}, // #8186
  {26,  1}, // #8187
  {28,  4}, // #8188
  {31,  4}, // #8189
  {32,  4}, // #8190
  { 4,  1}, // #8191
  {14,  2}, // #8192
  {15,  2}, // #8193
  {16,  2}, // #8194
  {19,  2}, // #8195
  {20,  2}, // #8196
  {21,  2}, // #8197
  {23,  2}, // #8198
  {28,  2}, // #8199
  {29,  2}, // #8200
  {30,  2}, // #8201
  {31,  2}, // #8202
  {32,  2}, // #8203
  {34,  2}, // #8204
  {35,  2}, // #8205
  {36,  1}, // #8206
  {37,  1}, // #8207
  {38,  1} // #8208
}; // X86WriteProcResTable

// {Cycles, WriteResourceID}
extern const llvm::MCWriteLatencyEntry X86WriteLatencyTable[] = {
  { 0,  0}, // Invalid
  { 1,  0}, // #1 WriteALU_WriteZero_WriteVecALU_WriteJump_WriteMove_WriteADC_WriteFStoreX_WriteFStoreY_WriteFSign_WriteNop_WriteFLogic_WriteFBlend_WriteBLS_WriteBSWAP32_WriteBitTest_WriteBitTestSet_WriteBZHI_WriteCMOV_WriteStore_WriteVecALUX_WriteFLDC_WriteFShuffle_WriteVecLogicX_WriteShuffle_WriteLAHFSAHF_WriteFLD0_WriteFLD1_WriteLEA_WriteFence_WriteVecStoreX_WriteVecMoveFromGpr_WriteVecMoveX_WriteVecStoreNT_WriteVarShuffle_WriteVecShiftImm_WriteFMoveX_WriteStoreNT_WriteFStoreNTX_WriteShuffleX_WriteBlend_WriteVarShuffleX_WriteVecShiftImmX_WriteRotate_WriteRMW_WriteShift_WriteSETCC_WriteShuffleY_WriteFLogicY_WriteFBlendY_WriteVecALUY_WriteFMoveY_WriteFShuffleY_WriteVecStoreY_WriteVecMoveY_WriteVecStoreNTY_WriteFStoreNTY_WriteVecLogicY_WriteBlendY_WriteFVarShuffleY_WriteVecShiftImmY_WriteVarVecShift_WriteVarVecShiftY_WriteVarShuffleY_SKLWriteResGroup9_SKLWriteResGroup10_SKLWriteResGroup11_SKLWriteResGroup3_SKLWriteResGroup6_SKLWriteResGroup7_SKLWriteResGroup4_SKLWriteResGroup8_SKLWritePSUB_WriteCMPXCHGRMW_WriteJumpLd_WriteFLoadX_AtomWrite0_1_WriteADCLd_WriteALULd_WriteFLogicLd_WriteBSWAP64_WriteBitTestImmLd_WriteLoad_WriteCMOVLd_WriteVecExtractSt_WriteVecALUXLd_WriteFShuffleLd_WriteVecLoadX_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteVarShuffleLd_WriteVecLoadNT_WriteShuffleXLd_WriteVecLogicXLd_WriteRotateCL_WriteShiftLd_WriteShiftCL_WriteVecShiftImmXLd_WriteFTestLd_AtomWrite1_1_AtomWrite0_1_1_AtomWrite01_1_WriteFCMOV_WriteFComX_WriteVecTest_WriteSETCCStore_WriteFSqrt80_WriteSTMXCSR_WriteShuffle256_WriteVarShuffle256_WriteVPMOV256_WriteVecTestY_WriteFTestY_WriteXCHG_PdWriteTST_F_UCOM_FPPr_PdWriteXADD_PdWriteLEA16r_PdWriteADCSBB64ri32_PdWriteVMOVUPDYmrVMOVUPSYmr_PdWriteVMOVDQUYmr_PdWriteMOVDQArr_PdWriteSETGEmSETGmSETLEmSETLm_WriteVecMoveToGpr_WriteMMXMOVMSK_BWWriteResGroup10_BWWriteResGroup2_BWWriteResGroup5_BWWriteResGroup6_BWWriteResGroup3_BWWriteResGroup4_BWWriteResGroup7_BWWriteResGroup8_BWWriteResGroup9_WriteBEXTR_WriteLZCNT_WritePHAdd_WritePOPCNT_WriteFShuffle256_JWriteVecExtractF128_JWriteZeroIdiomYmm_WriteShuffleZ_WriteFLogicZ_WriteVecALUZ_WriteFMoveZ_WriteFShuffleZ_WriteVecMoveZ_WriteVecLogicZ_WriteFVarShuffleZ_WriteVecShiftImmZ_WriteVarVecShiftZ_WriteVarShuffleZ_SKXWriteResGroup9_SKXWriteResGroup10_SKXWriteResGroup11_SKXWriteResGroup3_SKXWriteResGroup6_SKXWriteResGroup7_SKXWriteResGroup4_SKXWriteResGroup8_SKXWritePSUB_WriteCvtSS2SD_WriteFVarShuffle256_SBWriteResGroup2_SBWriteResGroup1_SBWriteResGroup4_SBWriteResGroup5_SBWriteResGroupVzeroupper_WriteBitTestRegLd_HWWriteBTRSCmr_HWWrite2P1_HWWriteP01_HWWrite2P01_HWWrite2P0156_P23_HWWriteResGroup10_HWWriteINTO_HWWritePushA_HWWritePopA_HWWriteP1_HWWriteBOUND_HWWriteResGroup3_HWWriteResGroup6_HWWriteResGroup7_HWWrite3P01_HWWriteP0156_P23_HWWriteRETI_HWWriteRDPMC_HWWriteRDRAND_HWWriteFNSAVE_HWWriteFRSTOR_HWWriteResGroup2_HWWriteResGroup4_HWWriteResGroup5_HWWriteResGroup8_HWWriteResGroup9_HWWriteADC0_WriteSHDrri_WriteSHDrrcl_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_ICXWriteResGroup9_ICXWriteResGroup10_ICXWriteResGroup11_ICXWriteResGroup3_ICXWriteResGroup6_ICXWriteResGroup7_ICXWriteResGroup4_ICXWriteResGroup8_ICXWritePSUB_WriteFVarBlend_WriteFMOVMSK_WriteVarBlend_WriteVecMOVMSK_WriteVecShiftX_WriteFVarBlendY_WriteVarBlendY_ZnWriteFPU3Lat1_ZnWriteFLDr_ZnWriteFPU0Lat1_ZnWriteFXCH_ZnWriteJCXZ_ZnWriteLD_F80m_ZnWriteLOOPE_ZnWriteCMPXCHG8B_ZnWriteRET_ZnWritePCMPGTQr_ZnWriteFPU01Y_ZnWriteFPU12m_ZnWriteCALLr_ZnXADD_ZnWriteFPU013_ZnWritePShift_ZnWriteSHA1MSG2r_ZnWriteSHA1NEXTEr_WriteFCmp64X_WriteFCmpX_WriteFCmp64Y_WriteFCmpY_WriteVecShiftY_Zn2WriteFPU3Lat1_Zn2WriteFLDr_Zn2WriteFPU0Lat1_Zn2WriteFXCH_Zn2WriteJCXZ_Zn2WriteLD_F80m_Zn2WriteLOOPE_Zn2WriteCMPXCHG8B_Zn2WriteRET_Zn2WritePCMPGTQr_Zn2WriteFPU01Y_Zn2WriteFPU12m_Zn2WriteCALLr_Zn2XADD_Zn2WriteFPU013_Zn2WriteFPU013Y_Zn2WriteSHA1MSG2r_Zn2WriteSHA1NEXTEr_Zn2WriteXCHG_WriteVecMOVMSKY_Zn3WriteLFENCE_Zn3WriteMoveExtend_Zn3WriteVecALUXMMX_Zn3WriteRotateR1_Zn3WriteMOVMMX_Zn3WriteSFENCE_Zn3WriteMOVBEmr_Zn3WriteCvtPD2IMMX_Zn3WriteSHA1MSG2rr_SHA1NEXTErr_Zn3WriteALUSlow_Zn3WriteMaterialize32bitImm_Zn3WriteADC8mr_SBB8mr_Zn3WriteWriteXCHGUnrenameable_Zn3WritePOPCNT16rr_Zn3WriteLZCNT16rr_Zn3WriteMOVMMXSlow_Zn3WriteVecALUXSlow_Zn3WriteVecALUYSlow
  { 8,  0}, // #2 WriteCMPXCHGRMW_SKLWriteResGroup119_WriteAESIMC_WriteFVarBlendLd_WriteBSFLd_WriteBSRLd_WriteCRC32Ld_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtPS2ILd_WriteCvtPS2PDLd_WriteCvtSD2ILd_WriteCvtSD2SSLd_WriteCvtSS2SDLd_WriteCvtSS2ILd_WriteIMul16RegLd_WriteIMul16ImmLd_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul64RegLd_WriteIMul64ImmLd_WriteIMul8Ld_WriteLZCNTLd_WritePHAddLd_WritePSADBWLd_WriteMULX32Ld_WriteMULX64Ld_WriteVarBlendLd_WritePOPCNTLd_WriteFRnd_WriteTZCNTLd_WriteShuffleYLd_WriteFLogicYLd_WriteFBlendYLd_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_WriteCvtPS2IYLd_WriteCvtPS2PDYLd_WriteCvtPS2PHYSt_WriteFRndY_WriteVecALUYLd_WriteFMaskedLoadY_WriteFShuffleYLd_WriteVecLogicYLd_WriteBlendYLd_WriteVarBlendYLd_WriteFVarShuffleYLd_WriteVecMaskedLoadY_WriteVecShiftImmYLd_WriteVarVecShiftYLd_WriteVarShuffleYLd_WriteVecShiftYLd_WriteFTestLd_SKLWriteResGroup116_SKLWriteResGroup117_SKLWriteResGroup107_SKLWriteResGroup108_SKLWriteResGroup110_SKLWriteResGroup112_WriteCvtI2PDLd_WriteFHAdd_WriteIMul16Ld_WritePHAddXLd_AtomWrite01_8_WriteIMul32Ld_WriteVarShuffleLd_WriteVecShiftLd_WriteVarShuffleXLd_WriteVecShiftXLd_WriteCvtI2PDY_WriteCvtPH2PSY_WriteFVarShuffleLd_WriteVarVecShiftLd_PdWriteVPERM2F128rm_PdWriteRCL3264ri_PdWriteVMPSADBW_BWWriteResGroup100_WriteFAdd64XLd_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteFComXLd_WriteFComLd_WriteFMul64XLd_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WriteFVarBlendYLd_BWWriteResGroup97_BWWriteResGroup91_BWWriteResGroup99_BWWriteResGroup154_BWWriteResGroup92_WriteAESDecEncLd_WriteCvtI2PSLd_WriteVecMoveFromGpr_WriteMPSADLd_WritePCmpIStrM_WriteVecTestLd_WriteFRndLd_WriteFAdd64YLd_WriteFAddYLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteFRndYLd_SKXWriteResGroup130_WriteShuffleZLd_WriteFLogicZLd_WriteCvtPD2PSZLd_WriteCvtPD2IZLd_WriteCvtPS2IZLd_WriteCvtPS2PDZLd_WriteCvtPS2PHZSt_WriteFRndZ_WriteVecALUZLd_WriteFShuffleZLd_WriteVecLogicZLd_WriteVarBlendZLd_WriteFVarShuffleZLd_WriteVecShiftImmZLd_WriteVarVecShiftZLd_WriteVarShuffleZLd_WriteVecShiftZLd_SKXWriteResGroup127_SKXWriteResGroup128_SKXWriteResGroup118_SKXWriteResGroup119_SKXWriteResGroup121_SKXWriteResGroup123_SKXWriteResGroup131_SKXWriteResGroup132_SKXWriteResGroup133_SKXWriteResGroup134_WriteAESKeyGen_WriteVecALULd_WriteSHDmri_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSZLd_WriteFVarShuffle256Ld_WriteVPMOV256Ld_WriteFTestYLd_SBWriteResGroup86_SBWriteResGroup84_SBWriteResGroup77_SBWriteResGroup83_SBWriteResGroup85_SBWriteResGroup87_SBWriteCMOVA_CMOVBErm_HWWriteResGroup12_HWWriteResGroup48_HWWriteResGroup46_HWWriteResGroup47_HWWriteResGroup145_HWWriteResGroup11_2_HWWriteResGroup13_1_HWWriteResGroup17_2_HWWriteCMOVA_CMOVBErm_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteVecIMulXLd_WritePSADBWXLd_WriteVecIMulYLd_WriteFMulYLd_ICXWriteResGroup130_ICXWriteResGroup127_ICXWriteResGroup128_ICXWriteResGroup118_ICXWriteResGroup119_ICXWriteResGroup121_ICXWriteResGroup123_ICXWriteResGroup131_ICXWriteResGroup132_ICXWriteResGroup133_ICXWriteResGroup134_WriteFLoadX_WriteFLoadY_WriteFLogicLd_WriteFBlendLd_WriteLoad_WriteVecALUXLd_ZnWriteMul16Ld_ZnWriteMul32Ld_WriteFShuffleLd_WriteVecLoadX_ZnWriteFPU13_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteVecLoadNT_WriteFStoreNT_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WriteVecLoadY_WriteVecLoadNTY_WriteVecShiftImmXLd_WriteVecTestYLd_ZnWriteLEAVE_ZnWritePushA_ZnWritePCMPGTQm_ZnWriteBROADCAST_ZnWriteFPU01Op2_ZnWriteVPBROADCAST256Ld_ZnWritePCMPGTQYm_ZnWriteFPU0Lat1Ld_ZnWriteFPU013Ld_ZnWriteVPBROADCAST128Ld_ZnWriteFPU013m_ZnWriteSHA1MSG2Ld_ZnWriteSHA1NEXTELd_Zn2WriteMul64Ld_Zn2WriteFPU13_WriteFCmp64YLd_WriteFCmpYLd_Zn2WriteLEAVE_Zn2WritePushA_Zn2WritePCMPGTQm_Zn2WriteBROADCAST_Zn2WriteFPU01Op2_Zn2WriteVPBROADCAST256Ld_Zn2WritePCMPGTQYm_Zn2WriteFPU0Lat1Ld_Zn2WriteFPU013Ld_Zn2WriteFPU013LdY_Zn2WriteVPBROADCAST128Ld_Zn2WriteFPU013m_Zn2WriteSHA1MSG2Ld_Zn2WriteSHA1NEXTELd_WriteFLD0_Zn3WriteRotateLeftMI_Zn3WriteVINSERTF128rmr_Zn3WriteRotateLeftMCL_Zn3WriteVEXTRACTI128mr
  { 6,  0}, // #3 WriteJumpLd_WriteFLoadX_WriteADCLd_WriteALULd_WriteBLSLd_WriteBitTestImmLd_WriteBitTestRegLd_WriteRMW_WriteBZHILd_WriteCMOVLd_WriteFHAdd_WriteVecLoadX_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteVarShuffleLd_WriteVecShiftLd_WriteVecLoadNT_WriteCLMul_WriteStore_WriteShiftLd_WriteSHDrrcl_WriteCvtPS2PHSt_WriteFHAddY_SKLWriteResGroup82_SKLWriteResGroup68_SKLWriteResGroup76_SKLWriteResGroup78_SKLWriteResGroup83_SKLWriteResGroup84_SKLWriteResGroup67_SKLWriteResGroup72_SKLWriteResGroup80_SKLWriteResGroup88_SKLWriteResGroup75_SKLWriteResGroup70_SKLWriteResGroup69_WriteFAdd64X_WriteFCmp64X_WriteFCmpX_WriteCvtI2PS_WriteCvtPS2I_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2SD_WriteIMul16Reg_WriteIMul16Imm_WriteIMul32_WriteFLD1_AtomWrite01_6_PdWriteALURMW_WriteBEXTRLd_WriteFComXLd_WriteCRC32Ld_WriteFComLd_WriteIMul64_WriteIMul64Reg_WriteIMul64Imm_WriteLZCNTLd_WriteVecTestLd_WriteTZCNTLd_WriteShuffle256Ld_WriteVarShuffle256Ld_WriteFMaskedStore64Y_WriteFMaskedLoadY_WriteFMaskedStore32Y_WriteVecMaskedLoadY_WriteVPMOV256Ld_WriteVecTestYLd_WriteFTestYLd_WriteFTestLd_PdWriteXLAT_PdWriteVBROADCASTYLd_PdWriteXADDm_PdWriteMMX_CVTPD2PIrrMMX_CVTPI2PDrr_PdWriteFCOMPm_PdWriteLXADD_PdWriteBMI1m_PdWriteCRC32r32r32_PdWriteMMX_CVTTPD2PIrr_WriteFLoadY_WriteFLogicLd_WriteFBlendLd_WriteVecALUXLd_WriteFShuffleLd_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WriteVarShuffleXLd_WriteFRnd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteCvtPS2PHY_WriteFRndY_WriteVecLoadY_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVecShiftImmXLd_BWWriteResGroup69_BWWriteResGroup66_BWWriteResGroup70_BWWriteResGroup58_BWWriteResGroup71_BWWriteResGroup65_BWWriteResGroup62_BWWriteResGroup68_BWWriteResGroup59_BWWriteResGroup64_BWWriteResGroup60_WriteIMul16Ld_WriteIMul16RegLd_WriteIMul32Ld_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul8Ld_WritePHAddLd_WriteFLogicYLd_WriteFBlendYLd_WriteFShuffle256Ld_WriteCvtPD2PSY_WriteCvtPD2IY_WriteFShuffleYLd_JWriteVBROADCASTYLd_WriteCvtSD2I_WriteCvtSS2I_SKXWriteResGroup86_SKXWriteResGroup72_SKXWriteResGroup81_SKXWriteResGroup82_SKXWriteResGroup87_SKXWriteResGroup88_SKXWriteResGroup71_SKXWriteResGroup76_SKXWriteResGroup84_SKXWriteResGroup92a_SKXWriteResGroup79_SKXWriteResGroup73_SKXWriteResGroup80_SBWriteResGroup48_SBWriteResGroup53_SBWriteResGroup81_SBWriteResGroup49_SBWriteResGroup51_SBWriteResGroup52_WriteCvtPS2PHZ_WriteFRndZ_HWWriteResGroup18_HWWriteResGroup108_HWWriteResGroup0_HWWriteResGroup14_HWWriteResGroup107_HWWriteResGroup11_HWWriteResGroup13_HWWriteResGroup16_HWWriteResGroup102_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WritePHAddX_WritePOPCNTLd_WriteFRndLd_WriteFAddYLd_WriteFCmp64YLd_WriteFCmpYLd_WriteFRndYLd_ICXWriteResGroup86_ICXWriteResGroup72_ICXWriteResGroup81_ICXWriteResGroup82_ICXWriteResGroup87_ICXWriteResGroup88_ICXWriteResGroup71_ICXWriteResGroup76_ICXWriteResGroup84_ICXWriteResGroup79_ICXWriteResGroup73_ICXWriteResGroup80_ZnWriteALULat2Ld_ZnWriteBTRSCm_ZnWriteSHA1RNDS4r_Zn2WriteALULat2Ld_Zn2WriteBTRSCm_Zn2WriteSHA1RNDS4r_WritePCmpEStrI_WritePCmpEStrM_WritePCmpIStrM_WriteSHDmrcl_WriteSHDmri_Zn3WriteXCHG32rm_XCHG64rm_Zn3Writerm_SHA256MSG1rm_Zn3WriteSHA1RNDS4rri_Zn3WriteSHA1MSG1rm_Zn3WriteVPERMYri
  {100,  0}, // #4 WriteSystem_WriteMicrocoded_ZnWriteMicrocoded_WriteFShuffle256_WriteFVarShuffle256_Zn2WriteMicrocoded
  { 3,  0}, // #5 WriteSHDrri_WriteBSF_WriteBSR_WriteFCMOV_WriteCRC32_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtPS2I_WriteCvtPS2PD_WriteCvtSD2I_WriteCvtSD2SS_WriteCvtSS2SD_WriteCvtSS2I_WriteVecExtract_WriteIMul16Reg_WriteIMul32Reg_WriteIMul32Imm_WriteIMul64Reg_WriteIMul64Imm_WriteIMul8_WriteLZCNT_WritePHAdd_WritePSADBW_WriteMULX32_WriteMULX64_WritePHAddX_WritePOPCNT_WritePSADBWX_WriteVecTest_WriteRotateCL_WriteShiftCL_WriteTZCNT_WriteShuffle256_WriteFShuffle256_WriteVarShuffle256_WriteCvtPD2PSY_WriteCvtPD2IY_WriteCvtPS2IY_WriteCvtPS2PDY_WritePSADBWY_WriteFVarShuffle256_WritePHAddY_WriteVPMOV256_WriteVecTestY_SKLWriteResGroup40_SKLWriteResGroup32_SKLWriteResGroup42_SKLWriteResGroup46_SKLWriteResGroup45_SKLWriteResGroup43_SKLWriteResGroup41_SKLWriteResGroup29_SKLWriteResGroup30_SKLWriteResGroup39_SKLWriteResGroup35_SKLWriteResGroup36_SKLWritePCMPGTQ_SKLWriteSETA_SETBEm_WriteVecMoveToGpr_WriteMMXMOVMSK_WriteVecShiftLd_WriteFMOVMSK_WriteVecMOVMSK_WriteVecShiftXLd_AtomWrite01_3_WriteCMPXCHGRMW_WriteFLDC_WriteFLD0_WriteFLD1_WriteFStoreNTX_WriteVarShuffleX_WriteSHDrrcl_WriteFStoreNTY_WriteFVarShuffleY_WriteVarVecShift_PdWriteCMPXCHG8rm_PdWriteCMPXCHG8rr_PdWriteCMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm_PdWriteCMPXCHG8B_PdWriteCMPXCHG16B_PdWriteSHLD16rrCLSHLD32rrCLSHRD32rrCL_PdWriteEXTRQ_PdWriteINSERTQI_PdWriteSHLD32rri8SHRD16rri8_WriteFAdd64X_WriteFAddX_WriteFCmp64X_WriteFCmpX_WriteFComX_WriteFMul64X_WriteFMulX_WriteFAdd64Y_WriteFAddY_WriteFCmp64Y_WriteFCmpY_WriteFMul64Y_WriteFMulY_WriteVecMOVMSKY_WriteVarVecShiftY_BWWriteResGroup27_BWWriteResGroup34_BWWriteResGroup35_BWWriteResGroup38_BWWriteResGroup37_BWWriteResGroup28_BWWriteResGroup33_BWWriteSETA_SETBEm_WriteAESDecEnc_WriteLoad_WriteCvtI2PD_WriteCvtI2PS_WriteVecExtractSt_WriteLDMXCSR_WriteMPSAD_WriteFRnd_WriteFVarBlendY_WriteCvtI2PDY_WriteCvtI2PSY_WriteCvtPH2PSY_WriteCvtPS2PH_WriteFRndY_WriteFTest_JSlowLEA16r_JWriteCMPXCHG8rr_WriteCvtPD2PSZ_WriteCvtPD2IZ_WriteCvtPS2IZ_WriteCvtPS2PDZ_WritePSADBWZ_SKXWriteResGroup42_SKXWriteResGroup34_SKXWriteResGroup44_SKXWriteResGroup48_SKXWriteResGroup47_SKXWriteResGroup45_SKXWriteResGroup43_SKXWriteResGroup31_SKXWriteResGroup32_SKXWriteResGroup41_SKXWriteResGroup37_SKXWriteResGroup38_SKXWriteResGroup30_SKXWritePCMPGTQ_SKXWriteSETA_SETBEm_WriteVecALU_WriteFAdd64Z_WriteFAddZ_WriteFCmpZ_WriteCvtI2PSZ_WriteCvtPH2PSZ_WriteCvtPS2PHY_WriteCvtPS2PHZ_WriteFRndZ_WriteFCmp64Z_SBWriteResGroup21_SBWriteResGroup22_SBWriteResGroup26_2_SBWriteCMOVA_CMOVBErr_SBWriteSETA_SETBEm_WriteVarVecShiftZ_HWWriteResGroup50_HWWriteResGroup58_HWWriteResGroup59_HWWriteResGroup45_HWWriteResGroup44_HWWriteResGroup51_HWWriteResGroup57_HWWriteCMOVA_CMOVBErr_HWWriteSETA_SETBEm_WriteFLoadX_WriteFLoadY_WriteVecLoadX_WriteVecLoadNT_WriteVecLoadY_WriteFMaskedLoadY_WriteVecLoadNTY_WriteVecMaskedLoadY_ICXWriteResGroup42_ICXWriteResGroup34_ICXWriteResGroup44_ICXWriteResGroup48_ICXWriteResGroup47_ICXWriteResGroup45_ICXWriteResGroup43_ICXWriteResGroup31_ICXWriteResGroup32_ICXWriteResGroup41_ICXWriteResGroup37_ICXWriteResGroup38_ICXWriteResGroup30_ICXWritePCMPGTQ_ICXWriteSETA_SETBEm_ZnWriteCVTPS2PDr_ZnWriteMul16_ZnWriteMul32_WriteVecMoveFromGpr_ZnWriteVCVTPS2PDY_Zn2WriteCVTPD2PSr_Zn2WriteCVTPS2PDr_Zn2WriteCVTSS2SDr_Zn2WriteMul16_Zn2WriteMul32_Zn2WriteCVTPD2PSYr_Zn2WriteVCVTPS2PDY_Zn2WriteCVTPD2DQr_Zn2WriteCVTDQ2PDr_Zn2WriteCVSTSI2SDr_Zn2WritePShift_Zn2WritePShiftY_Zn2WriteEXTRQ_WriteCvtI2SD_WriteCvtI2SS_WriteVecIMul_WritePHMINPOS_WriteVecIMulX_WritePMULLD_WriteFRcpX_WriteFRsqrtX_WriteVecIMulY_WritePMULLDY_WriteFRcpY_WriteFRsqrtY_Zn3WriteCvtI2PSMMX_Zn3WriteCMPXCHG8rr_Zn3WriteCMPXCHG8B_Zn3WriteRotateRightRCL_Zn3WritePDEP_PEXT_Zn3WriteVPERM2I128rr_VPERM2F128rr_Zn3WriteEXTRQI_INSERTQI_Zn3WriteSHA256MSG2rr_Zn3WriteRotateRightRI_Zn3WriteEXTRQ_INSERTQ
  { 7,  0}, // #6 WriteFLoadY_WriteRMW_WriteFLogicLd_WriteBEXTRLd_WriteFBlendLd_WriteFComXLd_WriteFComLd_WriteVecALUXLd_WriteFShuffleLd_WriteLDMXCSR_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WriteVarShuffleXLd_WriteVecShiftXLd_WriteCvtPH2PSY_WriteCvtPS2PHY_WriteVecLoadY_WriteFMaskedLoad_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVecMaskedLoad_WriteVecShiftImmXLd_WriteVarVecShiftLd_SKLWriteResGroup95_SKLWriteResGroup94_SKLWriteResGroup91_SKLWriteResGroup85_SKLWriteResGroup96_SKLWriteResGroup103_SKLWriteResGroup98_SKLWriteResGroup102_SKLWriteResGroup100_SKLWriteResGroup101_SKLWriteResGroup92_SKLWriteResGroup89_SKLWriteResGroup86_SKLWriteCMOVA_CMOVBErm_WriteFAdd64XLd_WriteFCmp64XLd_WriteFCmpXLd_WriteCvtI2PD_WriteCvtI2PSLd_WriteCvtPD2I_WriteCvtPS2ILd_WriteCvtPS2PD_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteIMul16_WriteIMul16RegLd_WriteIMul16ImmLd_WriteIMul32Ld_WriteIMul8Ld_WritePHAddX_AtomWrite0_1_7_AtomWrite0_1_7_4_AtomWrite01_7_WriteFVarBlendLd_WriteBSFLd_PdWriteBTSIm_PdWriteBTSRm_WriteFCmp64Ld_WriteFCmpLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVarBlendLd_WritePCmpIStrM_WritePHAddXLd_WriteShuffleYLd_WriteFLogicYLd_WriteFVarBlendYLd_WriteFBlendYLd_WriteFShuffle256Ld_WriteFCmp64YLd_WriteFCmpYLd_WriteFShuffleYLd_PdWriteVBROADCASTF128_PdWriteRCL3264rCL_PdWriteVEXTRACTF128mr_PdWriteRCR32riRCR64ri_PdWriteRCR3264rCL_WriteAESDecEnc_WriteMPSAD_WriteVecTestLd_WriteCvtPS2PHYSt_WriteVecALUYLd_WriteMPSADY_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteVecShiftImmYLd_WriteVarShuffleYLd_WriteVecShiftYLd_WriteFTestYLd_BWWriteResGroup80_BWWriteResGroup82_BWWriteResGroup90_BWWriteResGroup84_BWWriteResGroup89_BWWriteResGroup87_BWWriteResGroup88_BWWriteResGroup73_BWWriteResGroup77_BWWriteResGroup79_BWWriteResGroup74_BWWriteCMOVA_CMOVBErm_WriteAESIMCLd_WriteAESKeyGenLd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSD2SS_WriteCvtSS2I_WriteVecIMulLd_WritePSADBWLd_WriteVarShuffleLd_WriteFMulXLd_WriteFMulLd_WriteCLMulLd_WritePCmpIStrI_WritePHMINPOSLd_WriteVecIMulXLd_WritePSADBWXLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_WriteFRsqrtLd_WriteCvtPS2PDYLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_WriteCvtPH2PSZ_WriteCvtPS2PHZ_SKXWriteResGroup100_SKXWriteResGroup99_SKXWriteResGroup95_SKXWriteResGroup89_SKXWriteResGroup101_SKXWriteResGroup111_SKXWriteResGroup104_SKXWriteResGroup109_SKXWriteResGroup107_SKXWriteResGroup108_SKXWriteResGroup96_SKXWriteResGroup93_SKXWriteResGroup90_SKXWriteResGroup92_SKXWriteResGroup93z_SKXWriteResGroup97_SKXWriteResGroup103_SKXWriteResGroup106_SKXWriteResGroup110_SKXWriteResGroup112_SKXWriteResGroup113_SKXWriteResGroup114_SKXWriteCMOVA_CMOVBErm_WriteADCLd_WriteCMOVLd_WriteVecInsertLd_WriteCvtPS2PDZLd_WriteFRcpZ_WriteFRsqrtZ_WriteFTestLd_SBWriteResGroup69_SBWriteResGroup25_1_SBWriteResGroup63_SBWriteResGroup68_SBWriteResGroup54_SBWriteResGroup58_SBWriteResGroup59_SBWriteResGroup62_SBWriteResGroup64_SBWriteResGroup66_SBWriteResGroup67_WriteCvtPH2PSYLd_WriteCvtPH2PSZLd_WriteCvtPS2PHZSt_HWWriteResGroup25_HWWriteResGroup37_HWWriteResGroup26_HWWriteResGroup0_1_HWWriteResGroup39_HWWriteXLAT_HWWriteResGroup114_HWWriteResGroup41_HWWriteResGroup17_HWWriteResGroup11_1_HWWriteResGroup36_2_WriteCvtSD2SSLd_WriteIMul64_WriteFMul64X_WritePMULLDLd_WriteFAdd64YLd_WriteFMul64Y_WritePMULLDYLd_SLMWriteResGroup1rm_ICXWriteResGroup100_ICXWriteResGroup99_ICXWriteResGroup95_ICXWriteResGroup89_ICXWriteResGroup101_ICXWriteResGroup111_ICXWriteResGroup104_ICXWriteResGroup109_ICXWriteResGroup107_ICXWriteResGroup108_ICXWriteResGroup96_ICXWriteResGroup93_ICXWriteResGroup90_ICXWriteResGroup92_ICXWriteResGroup93z_ICXWriteResGroup97_ICXWriteResGroup103_ICXWriteResGroup106_ICXWriteResGroup110_ICXWriteResGroup112_ICXWriteResGroup113_ICXWriteResGroup114_ICXWriteCMOVA_CMOVBErm_WriteBSRLd_WriteFHAdd_Zn2WriteMul16Ld_Zn2WriteMul32Ld_WritePHAddLd_WriteMULX32Ld_WriteMULX64Ld_WriteFHAddY_WritePHAddYLd_WriteFCMOV_WriteCRC32Ld_WriteIMul16Ld_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul64Ld_WriteIMul64RegLd_WriteIMul64ImmLd_WriteFVarShuffle256_Zn3WriteRotateRightMCL_Zn3WriteCMPXCHG8rm_LCMPXCHG8_Zn3WriteVPERM2F128rm_Zn3WriteSHA256MSG2rm_Zn3WriteXCHG8rm_XCHG16rm_Zn3WriteRotateRightMI_Zn3WriteVPERMPSYrr
  {10,  0}, // #7 WriteFAdd64XLd_WriteFAddXLd_WriteAESDecEncLd_WriteFCmp64XLd_WriteFCmpXLd_WriteEMMS_WriteVecIMulLd_WriteMPSADLd_WriteFMul64XLd_WriteFMulXLd_WritePCmpIStrI_WritePCmpIStrM_WritePHMINPOSLd_WritePMULLD_WriteFRcpXLd_WriteFRsqrtXLd_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSYLd_WritePSADBWYLd_WriteFMAXLd_WriteFVarShuffle256Ld_WritePHAddYLd_WriteVPMOV256Ld_WritePMULLDY_WriteVecTestYLd_SKLWriteResGroup133_SKLWriteResGroup143_SKLWriteResGroup134_SKLWriteResGroup138_SKLWriteResGroup139_SKLWriteResGroup140_WriteFComXLd_WriteCvtSD2SS_AtomWrite01_10_AtomWrite0_1_10_WriteFAdd64Ld_WriteFAddLd_WriteAESIMCLd_WriteAESKeyGenLd_WriteIMul64Ld_WriteIMul64RegLd_WriteIMul64ImmLd_WritePHAddLd_WriteMMXMOVMSK_WriteFMul64Ld_WriteFMulLd_WritePCmpEStrM_WritePMULLDLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFAdd64YLd_WriteFAddYLd_WriteFMAYLd_WriteFMul64YLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_PdWriteCRC32r64r64_PdWriteRCL16rCL_PdWriteRCR16ri_PdWriteVFRCZP_PdWriteVFRCZS_PdWriteVFRCZY_WriteFHAddLd_WritePSADBWLd_WriteCLMulLd_WriteVecIMulXLd_WritePSADBWXLd_BWWriteResGroup120_BWWriteResGroup115_BWWriteResGroup117_WriteCvtPH2PSZLd_WritePSADBWZLd_WritePMULLDZ_SKXWriteResGroup148_SKXWriteResGroup157_SKXWriteResGroup149_SKXWriteResGroup153_SKXWriteResGroup154_SKXWriteResGroup136_2_SKXWriteResGroup151_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtSD2ILd_WriteCvtSD2SSLd_WriteCvtI2SSLd_WriteCvtSS2ILd_WritePCmpEStrILd_WriteSHDmrcl_WriteFMAZLd_WriteFAdd64ZLd_WriteFAddZLd_WriteFCmp64YLd_WriteFCmpYLd_WriteFCmpZLd_WriteCvtI2PDYLd_WriteCvtI2PDZLd_WriteCvtI2PSYLd_WriteCvtI2PSZLd_WriteCvtPS2IYLd_WriteCvtPS2IZLd_WriteFRndYLd_WriteFRndZLd_WriteFCmp64ZLd_SBWriteResGroup101_WriteSHDmri_WriteVarVecShiftYLd_WriteVarVecShiftZLd_HWWriteResGroup52_1_HWWriteResGroup97_HWWriteResGroup77_HWWriteResGroup78_WriteBSF_WriteBSR_ICXWriteResGroup148_ICXWriteResGroup157_ICXWriteResGroup149_ICXWriteResGroup153_ICXWriteResGroup154_ICXWriteResGroup136_2_ICXWriteResGroup151_WriteFCmp64Ld_WriteFCmpLd_WriteCRC32Ld_ZnWriteCVTPS2PDLd_WriteFComLd_Zn2WriteCVTPD2PSLd_Zn2WriteCVTPS2PDLd_Zn2WriteCVTSS2SDLd_WriteFRndLd_Zn2WriteCVTPD2PSYLd_Zn2WriteVDIVPSYr_WriteFVarShuffleYLd_WriteFVarShuffleLd_WriteVarVecShiftLd_Zn2WriteCVTPD2DQLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtPS2PDLd_WriteCvtI2SDLd_WriteCvtSS2SDLd_WriteDiv8_WriteIDiv8_WriteCvtPH2PSLd_WriteVecIMulYLd_WritePMULLDYLd_Zn3WriteVZEROALL_Zn3WriteVPERMPDYmi
  { 4,  0}, // #8 WriteFAdd64X_WriteFAddX_WriteAESDecEnc_WriteFCmp64X_WriteFCmpX_WriteCvtI2PD_WriteCvtI2PS_WriteCvtI2SD_WriteCvtI2SS_WriteIMul16_WriteIMul16Imm_WriteIMul32_WriteIMul64_WriteMPSAD_WriteFMul64X_WriteFMulX_WritePHMINPOS_WriteFRcpX_WriteFRsqrtX_WriteFAdd64Y_WriteFAddY_WriteFCmp64Y_WriteFCmpY_WriteCvtI2PDY_WriteCvtI2PSY_WriteFMAX_WriteFMAY_WriteMPSADY_WriteFMul64Y_WriteFMulY_WriteVecShiftY_WriteFRcpY_WriteFRsqrtY_SKLWriteResGroup53_SKLWriteResGroup55_SKLWriteResGroup54_SKLWriteResGroup48_SKLWriteResGroup57_SKLWriteResGroup47_WritePHAddLd_WriteVecIMulLd_WritePSADBWLd_WriteFMulLd_WriteVarShuffleX_WriteFRcpLd_WriteFRsqrtLd_WriteSHDmrcl_WriteSHDmri_AtomWrite01_4_WriteBSR_WriteCvtPS2I_WriteCvtSD2SS_WriteCvtSS2SD_WriteIMul16Reg_WriteIMul32Reg_WriteIMul32Imm_WriteIMul8_WriteVecIMulX_WritePOPCNT_WritePSADBWX_WriteFRnd_WriteCvtPS2IY_WriteCvtPS2PHYSt_WriteCvtPS2PHSt_WriteFRndY_PdWriteMMX_CVTPI2PSrr_PdWriteMOVQ2DQrr_PdWriteVPERM2F128rr_PdWriteVPMACS_WriteVecTestY_BWWriteResGroup42_BWWriteResGroup39_BWWriteResGroup44_BWWriteResGroup45_BWWriteResGroup41_BWWriteResGroup43_BWWriteResGroup40_WriteJumpLd_WriteADCLd_WriteALULd_WriteBEXTRLd_WriteBSF_WriteBitTestImmLd_WriteBitTestRegLd_WriteCMOVLd_WriteFHAdd_WriteLZCNTLd_WriteVecMoveToGpr_WriteVecInsertLd_WritePMULLD_WriteStore_WritePOPCNTLd_WriteShiftLd_WriteSHDrrcl_WriteFHAddY_WriteFVarShuffleY_WriteFTestY_WriteFAdd64Z_WriteFAddZ_WriteFCmpZ_WriteCvtI2PDZ_WriteCvtI2PSZ_WriteFMAZ_WriteFCmp64Z_WriteFMul64Z_WriteFMulZ_WriteVecShiftZ_WriteFRcpZ_SKXWriteResGroup54_SKXWriteResGroup55_SKXWriteResGroup50_SKXWriteResGroup57_SKXWriteResGroup49_SKXWriteResGroup33_SKXWriteResGroup50z_SKXWriteResGroup51_WriteCvtPD2I_WriteCvtPD2PS_WritePCmpEStrI_WriteCvtPD2PSY_WriteCvtPD2PSZ_WriteCvtPD2IY_WriteCvtPD2IZ_WriteCvtPS2PHZSt_SBWriteResGroup29_2_HWWriteResGroup73_HWWriteResGroup70_HWWriteMOVS_HWWriteResGroup62_HWWriteResGroup81_HWWriteResGroup72_HWWriteResGroup61_HWWriteCMPS_HWWriteResGroup71_HWWriteResGroup83_WriteCMPXCHGRMW_WriteFLogicLd_WriteFBlendLd_WriteFVarBlend_WriteRMW_WriteVecExtractSt_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteMMXMOVMSK_WriteVarShuffleLd_WriteFMOVMSK_WriteShuffleXLd_WriteVecLogicXLd_WriteVarBlend_WriteBlendLd_WriteVecMOVMSK_WriteVecTestLd_WriteShuffleYLd_WriteFLogicYLd_WriteVecALUYLd_WriteFShuffleYLd_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteFVarShuffleLd_WriteVecMOVMSKY_WritePMULLDY_WriteVecShiftImmXLd_WriteVecShiftImmYLd_WriteVarVecShiftLd_WriteVecTestYLd_WriteFTestYLd_WriteFTestLd_SLMWriteResGroup1rr_ICXWriteResGroup54_ICXWriteResGroup55_ICXWriteResGroup50_ICXWriteResGroup57_ICXWriteResGroup49_ICXWriteResGroup33_ICXWriteResGroup50z_ICXWriteResGroup51_WriteAESIMC_WriteAESKeyGen_ZnWriteCVTPD2PSr_ZnWriteCVTSS2SDr_ZnWriteMul64_WriteVecIMulY_WriteFMaskedStore64_WriteFMaskedStore32_WriteVecMaskedStore32_WriteVecMaskedStore64_ZnWriteCVTPS2PIr_ZnWritePUSH_ZnWriteINSERTQ_ZnWriteSHA256RNDS2r_Zn2WriteMul16Imm_Zn2WriteMul64_WriteVPMOV256_Zn2WriteCVTPS2PIr_Zn2WriteCVSTSI2SIr_Zn2WritePUSH_Zn2WriteINSERTQ_Zn2WriteSHA256RNDS2r_WriteFComX_WriteCLMul_WriteCvtPS2PDY_WriteCvtPH2PSY_Zn3WriteCMPXCHG16B_LCMPXCHG16B_Zn3WriteRotateLeftRI_Zn3WriteRotateLeftRCL_Zn3WriteVEXTRACTF128rr_VEXTRACTI128rr_Zn3WriteSHA256RNDS2rr_Zn3WriteMOVBE16rm
  { 9,  0}, // #9 WriteFAdd64Ld_WriteFAddLd_WriteFCmp64Ld_WriteFCmpLd_WriteCvtI2PDLd_WriteCvtI2PSLd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteDPPD_WriteIMul16Ld_WriteIMul32Ld_WriteIMul64Ld_WriteFMul64Ld_WriteFMulLd_WritePHAddXLd_WritePSADBWXLd_WriteVecTestLd_WriteFRcpLd_WriteFRsqrtLd_WriteSHDmri_WriteFMALd_WriteFVarBlendYLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPH2PSLd_WriteFTestYLd_SKLWriteResGroup120_SKLWriteResGroup123_SKLWriteResGroup121_SKLWriteResGroup131_SKLWriteResGroup128_WriteBitTestRegLd_WriteFCMOV_WriteFComX_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteFHAddLd_WriteFMul64X_WriteFRcpX_WriteFRsqrtX_AtomWrite0_1_9_AtomWrite01_9_WriteAESDecEnc_WriteCvtPS2ILd_WriteCvtSD2SSLd_WriteCvtSS2SDLd_WriteFDiv64X_WriteFDivX_WriteIMul16ImmLd_WriteVecIMulLd_WritePSADBWLd_WriteMPSAD_WritePHMINPOSLd_WriteVecIMulXLd_WriteFRndLd_WriteFSqrt64X_WriteFSqrtX_WriteCvtPS2IYLd_WriteFDiv64Y_WriteFDivY_WriteFRndYLd_WriteFSqrt64Y_WriteFSqrtY_PdWriteX87Div_PdWriteRCR16rCL_WriteFAdd64YLd_WriteFAddYLd_WriteShuffle256Ld_WriteFShuffle256Ld_WriteFCmp64YLd_WriteFCmpYLd_WriteVarShuffle256Ld_WriteFMul64YLd_WriteFMulYLd_WriteFVarShuffle256Ld_WritePHAddYLd_WriteVPMOV256Ld_WriteVarVecShiftYLd_BWWriteResGroup101_BWWriteResGroup105_BWWriteResGroup112_BWWriteResGroup106_BWWriteResGroup107_BWWriteResGroup108_BWWriteResGroup113_WriteIMul64RegLd_WriteIMul64ImmLd_WriteFMul64XLd_WritePMULLDLd_WriteSHDmrcl_WriteFHAddYLd_WriteFVarShuffleYLd_WriteVecTestYLd_WriteFVarBlendZLd_WriteCvtI2PDZLd_WriteCvtI2PSZLd_WriteFRsqrtZ_SKXWriteResGroup135_SKXWriteResGroup137_SKXWriteResGroup136_SKXWriteResGroup146_SKXWriteResGroup143_SBWriteResGroup98_WriteFAdd64XLd_WriteFAddXLd_SBWriteResGroup100_WriteRMW_WriteFCmp64XLd_WriteFCmpXLd_WritePOPCNTLd_WriteFMaskedLoadY_WriteVarBlendYLd_WriteVarBlendZLd_WriteVecMaskedLoadY_SBWriteResGroup97_2_SBWriteResGroup93_SBWriteResGroup95_SBWriteResGroup99_SBWriteResGroupVzeroall_WriteCMPXCHGRMW_HWWriteResGroup69_WriteVarVecShiftLd_HWWriteResGroup66_HWWriteResGroup68_HWWriteResGroup76_HWWriteResGroup52_HWWriteResGroup53_1_HWWriteResGroup78_1_HWWriteResGroup80_HWWriteResGroup87_WritePHAddLd_ICXWriteResGroup135_ICXWriteResGroup137_ICXWriteResGroup136_ICXWriteResGroup146_ICXWriteResGroup143_ZnWriteMul64Ld_WriteStore_WriteVecShiftYLd_ZnWriteFPU02_ZnWriteVINSERT128Ld_ZnWriteFPU01Op2Y_ZnWriteFPU013LdY_ZnWriteSHA1MSG1Ld_Zn2WriteFPU02_Zn2WriteVINSERT128Ld_Zn2WriteFPU01Op2Y_Zn2WriteSHA1MSG1Ld_WritePCmpIStrILd_Zn3WriteVPERMYm
  {14,  0}, // #10 WriteAESIMCLd_SKLWriteResGroup166_WriteFRndLd_SKLWriteResGroup166_1_SKLWriteResGroup170_SKLWriteResGroup169_WriteIMul64ImmLd_AtomWrite01_14_WriteAESDecEncLd_WriteDiv32_WriteDiv64_WriteFDiv64XLd_WriteFDivXLd_WriteFDivLd_WriteFDiv64Ld_WriteIDiv32_WriteIDiv64_WriteMPSADLd_WritePCmpEStrI_WriteFSqrt64XLd_WriteFSqrtXLd_WriteFSqrt64Ld_WriteFSqrtLd_WriteFDiv64YLd_WriteFDivYLd_WriteFSqrt64YLd_WriteFSqrtYLd_BWWriteResGroup139_1_WriteDPPDLd_WriteDPPS_WriteDPPSY_BWWriteResGroup146_BWWriteResGroup145_BWWriteResGroup141_BWWriteResGroup144_WritePCmpEStrM_SKXWriteResGroup184_SKXWriteResGroup184_1_SKXWriteResGroup190_SKXWriteResGroup187_SKXWriteResGroup188_SKXWriteResGroup189_WriteAESKeyGenLd_WriteCLMul_WriteMPSADYLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup142_HWWriteResGroup184_ICXWriteResGroup184_ICXWriteResGroup184_1_ICXWriteResGroup190_ICXWriteResGroup187_ICXWriteResGroup188_ICXWriteResGroup189_WriteDiv8Ld_WriteIDiv8Ld_WriteFVarShuffle256Ld
  {25,  0}, // #11 WriteAESKeyGenLd_WriteDiv8_WriteIDiv8_WritePCmpEStrMLd_WriteFSqrt64YLd_SKLWriteResGroup202_AtomWrite01_25_WriteDPPS_WriteIDiv16_WriteIDiv32_WriteIDiv64_WriteDiv32_WriteFDivZLd_SKXWriteResGroup233_SKXWriteGatherEVEX16_WriteDiv16_WriteDiv64_WriteFDiv64Ld_ICXWriteResGroup233_ICXWriteGatherEVEX16
  {20,  0}, // #12 WriteAESKeyGen_SKLWriteResGroup190_WriteDPPSYLd_SKLWriteResGroup193_SKLWriteResGroup192_SKLWriteResGroup189_SKLWriteResGroupVEX4_AtomWrite01_20_WriteDPPDLd_BWWriteResGroup167_BWWriteResGroup165_WriteDiv16Ld_WriteIDiv16Ld_SKXWriteResGroup216_WriteFSqrtZ_SKXWriteResGroup220_SKXWriteResGroup219_SKXWriteResGroup215_SKXWriteResGroupVEX4_WriteFDivXLd_WriteFDivLd_WriteCLMulLd_WriteFSqrtXLd_WriteFSqrtLd_WriteAESIMCLd_WriteFDiv64X_WriteDPPSLd_HWWriteResGroup156_HWWriteResGroup154_WritePCmpEStrMLd_WritePCmpIStrILd_ICXWriteResGroup216_ICXWriteResGroup220_ICXWriteResGroup219_ICXWriteResGroup215_ICXWriteResGroupVEX4_WriteFSqrt64X_WriteFSqrt80_Zn2WriteVDIVPDYLd_WriteFSqrt64Y_WriteFDiv64XLd_WriteFDiv64Ld_WriteFDiv64YLd
  { 2,  0}, // #13 WriteBEXTR_WriteFVarBlend_WriteBSWAP64_WriteFComX_WriteVecExtractSt_WriteVecMoveToGpr_WriteVecInsert_WriteMMXMOVMSK_WriteFMOVMSK_WriteVarBlend_WriteVecMOVMSK_WriteVecShiftX_WriteSETCCStore_WriteSTMXCSR_WriteFVarBlendY_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVarBlendY_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_WriteVecMOVMSKY_WriteFTestY_WriteXCHG_SKLWriteResGroup17_SKLWriteResGroup23_SKLWriteResGroup25_SKLWriteResGroup14_SKLWriteResGroup28_SKLWriteResGroup20_SKLWriteResGroup13_SKLWriteResGroup21_SKLWriteResGroup27_SKLWriteResGroup100_1_SKLWriteCMOVA_CMOVBErr_SKLWriteSETA_SETBEr_WriteSHDrri_AtomWrite01_2_WriteLAHFSAHF_WriteStore_WriteSHDrrcl_WriteVecALU_WriteFLogic_WriteFBlend_WriteBLS_WriteBitTestSet_WriteFCmp64X_WriteFCmpX_WriteCRC32_WriteVecALUX_WriteEMMS_WriteFShuffle_WriteVecLogicX_WriteShuffle_WriteLZCNT_WriteVecStore_WriteVecStoreNT_WriteVecShiftImm_WriteFStore_WriteShuffleX_WriteBlend_WritePHAddX_WriteVecShiftImmX_WriteTZCNT_WriteShuffleY_WriteFLogicY_WriteFBlendY_WriteFShuffle256_WriteFCmp64Y_WriteFCmpY_WriteFMoveY_WriteFShuffleY_WriteVecMoveY_WriteVecStoreNTY_PdWriteLAHF_PdWriteVEXTRACTF128rr_PdWriteMOVHPm_PdWriteBMI1_PdWriteSAHF_PdWriteBEXTRI_PdWriteBEXTRIm_PdWriteVPPERM_PdWrite3OpsLEA_WriteVecTest_WriteCvtPH2PSY_BWWriteResGroup14_BWWriteResGroup20_BWWriteResGroup22_BWWriteResGroup12_BWWriteResGroup17_BWWriteResGroup25_BWWriteResGroup16_BWWriteResGroup18_BWWriteResGroup24_BWWriteResGroup15_BWWriteResGroup87_1_BWWriteCMOVA_CMOVBErr_BWWriteSETA_SETBEr_WriteFSign_WriteAESIMC_WriteAESKeyGen_WriteCvtPS2PD_WriteVecIMul_WritePSADBW_WriteVarShuffle_WriteFMulX_WriteCLMul_WritePHMINPOS_WriteVecIMulX_WritePSADBWX_WriteVarShuffleX_WriteFRcpX_WriteRMW_WriteFRsqrtX_WriteCvtPS2PDY_WriteFMulY_WriteFRcpY_WriteFRsqrtY_JWriteXCHG8rr_XADDrr_JWriteINSERTQ_JWrite3OpsLEA_WriteFVarBlendZ_WriteVarBlendZ_SKXWriteResGroup17_SKXWriteResGroup23_SKXWriteResGroup25_SKXWriteResGroup14_SKXWriteResGroup28_SKXWriteResGroup20_SKXWriteResGroup13_SKXWriteResGroup21_SKXWriteResGroup27_SKXWriteResGroup107_1_SKXWriteResGroup29_SKXWriteCMOVA_CMOVBErr_SKXWriteSETA_SETBEr_WriteADC_WriteRotate_WriteCvtPS2PDZ_WriteVecTestY_SBWriteResGroup18_SBWriteResGroup11_SBWriteResGroup12_SBWriteResGroup15_SBWriteResGroup23_SBWriteSETA_SETBEr_WriteCvtPH2PSZ_HWWriteResGroup30_HWWriteResGroup35_HWWriteResGroup21_HWWriteResGroup28_HWWriteResGroup33_HWWriteResGroup24_HWWriteResGroup32_HWWriteResGroup19_HWWriteResGroup23_HWWriteResGroup23_16_HWWriteResGroup31_HWWriteResGroup46_1_HWWriteSETA_SETBEr_WriteVecShiftY_ICXWriteResGroup17_ICXWriteResGroup23_ICXWriteResGroup25_ICXWriteResGroup14_ICXWriteResGroup28_ICXWriteResGroup20_ICXWriteResGroup13_ICXWriteResGroup21_ICXWriteResGroup27_ICXWriteResGroup107_1_ICXWriteResGroup29_ICXWriteCMOVA_CMOVBErr_ICXWriteSETA_SETBEr_ZnWriteALULat2_WriteShuffle256_WriteVarShuffle256_ZnWriteEXTRACTPSr_ZnWriteFPU013Y_ZnWritePShiftY_ZnWriteVINSERT128r_ZnWriteEXTRQ_ZnWriteSHA1MSG1r_Zn2WriteALULat2_Zn2WriteEXTRACTPSr_Zn2WriteVINSERT128r_Zn2WriteSHA1MSG1r_Zn2WriteBTRSC_WriteCvtSD2I_WriteCvtSS2I_WritePCmpIStrI_WritePHAddY_Zn3WriteCvtI2PDMMX_Zn3WriteSHA256MSG1rr_Zn3SlowLEA16r_Zn3WriteTZCNT16rr_Zn3WriteWriteFStoreMMX_Zn3WriteSHA1MSG1rr_Zn3Write3OpsLEA
  { 5,  0}, // #14 WriteLoad_WriteCMPXCHG_WriteVecLoad_WriteVecIMul_WriteFLoad_WriteVecIMulX_WriteCvtPH2PS_WriteCvtPS2PH_WriteVecIMulY_SKLWriteResGroup60_SKLWriteResGroup58_SKLWriteResGroup65_SKLWriteResGroup59_SKLWriteResGroup61_SKLWriteResGroup63_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64Ld_WriteFCmpLd_WriteFCom_WriteFComLd_WriteEMMS_WriteIMul32RegLd_WriteIMul32ImmLd_WriteLDMXCSR_WriteFMulXLd_WriteFMul64Ld_WriteVecIMulXLd_WritePSADBWXLd_WriteVarShuffleXLd_WriteFRndLd_AtomWrite1_5_AtomWrite0_1_5_AtomWrite01_5_WriteJumpLd_WriteFLoadX_WriteFLoadY_WriteADCLd_WriteALULd_WriteFAdd64X_WriteAESIMC_WriteAESKeyGen_WriteBitTestImmLd_WriteBitTestRegLd_WriteBZHILd_WriteCMOVLd_WriteIMul16Imm_WriteVecLoadX_WritePHAdd_WriteVecLoadNT_WriteFMul64X_WritePMULLD_WriteFRcpX_WriteShiftLd_WriteFRsqrtX_WriteFAdd64Y_WriteFAddY_WriteFMAX_WriteFMAY_WriteVecLoadY_WriteVecLoadNTY_WriteFMul64Y_WriteFMulY_WriteFRcpY_WriteFRsqrtY_PdWriteX87Add_PdWriteX87Mul_PdWriteCRC32r32r16_PdWriteCMOVm_WriteFHAdd_WriteCLMul_WritePHMINPOS_WriteCvtPS2PHSt_WritePSADBWY_WriteFHAddY_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_BWWriteResGroup50_BWWriteResGroup49_BWWriteResGroup54_BWWriteResGroup57_BWWriteResGroup47_BWWriteResGroup51_BWWriteResGroup55_BWWritePCMPGTQ_WriteBLSLd_WriteBSR_WriteTZCNTLd_WriteVecIMulZ_SKXWriteResGroup61_SKXWriteResGroup58_SKXWriteResGroup69_SKXWriteResGroup63_SKXWriteResGroup67_SKXWriteResGroup62_SKXWriteResGroup65_SKXWriteResGroup66_WriteCvtSD2I_WriteCvtI2SS_WriteCvtSS2I_WriteVecExtractSt_WriteSTMXCSR_WritePSADBWZ_WriteFMAZ_WriteFMul64Z_WriteFMulZ_WritePMULLDY_WritePMULLDZ_SBWriteResGroup33_SBWriteResGroup31_SBWriteResGroup41_SBWriteResGroup47_SBWriteResGroup76_SBWriteResGroup35_SBWriteResGroup35_2_SBWriteResGroup36_SBWriteResGroup40_SBWriteResGroup45_SBWriteResGroup46_SBWritePCMPGTQ_HWWriteResGroup93_HWWriteResGroup0_2_HWWriteResGroup99_HWWriteResGroup88_HWWriteResGroup89_HWWriteResGroup94_HWWriteResGroup100_HWWritePCMPGTQ_WriteRMW_WriteCvtI2PD_WriteCvtI2PS_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtPS2I_WriteCvtPS2PD_WriteCvtI2SD_WriteIMul64Reg_WriteIMul64Imm_WriteIMul8_WriteVecShiftLd_WriteVecShiftXLd_WriteCvtI2PDY_WriteCvtI2PSY_WriteCvtPD2PSY_WriteCvtPD2IY_WriteCvtPS2IY_WriteCvtPS2PDY_WriteVecShiftYLd_ICXWriteResGroup61_ICXWriteResGroup58_ICXWriteResGroup69_ICXWriteResGroup63_ICXWriteResGroup67_ICXWriteResGroup62_ICXWriteResGroup65_ICXWriteResGroup66_WriteBEXTRLd_WritePOPCNTLd_ZnWriteRSQRTSSr_ZnWriteCVTPD2PSYr_ZnWriteRSQRTPSYr_ZnWriteCVTPD2DQr_ZnWriteSTr_ZnWriteXCHGrm_ZnWriteST_FP80m_ZnWriteEXTRACTPSm_ZnWriteMOVBE_ZnWriteCVSTSI2SIr_ZnWriteCVTDQ2PDr_ZnWriteCVSTSI2SDr_ZnWritePop16r_WriteLZCNTLd_Zn2WriteRSQRTSSr_Zn2WriteRSQRTPSYr_Zn2WriteSTr_Zn2WriteXCHGrm_Zn2WriteST_FP80m_Zn2WriteEXTRACTPSm_Zn2WriteMOVBE_Zn2WritePop16r_Zn3WriteMOVSlow_Zn3WriteX87Arith_Zn3WriteX87Div_Zn3Writerm_SHA1MSG2rm_SHA1NEXTErm_Zn3WriteRotateM1_Zn3WriteVPERMDYrr
  {29,  0}, // #15 WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_AtomWrite01_29_WriteAESKeyGen_WriteFDiv64YLd_WriteFSqrt64Y_BWWriteResGroup182_BWWriteResGroup185_SKXWriteResGroup242_WriteFDivY_WriteFDivZ_WriteFSqrtY_WriteFSqrtZ_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_ICXWriteResGroup242
  {76,  0}, // #16 WriteDiv16_WriteDiv32_WriteDiv64
  {17,  0}, // #17 SKLWriteResGroup179_WriteFSqrtLd_WritePMULLDYLd_SKLWriteResGroup180_AtomWrite01_17_WriteCLMulLd_WriteFDivY_WriteFRcpYLd_WriteFRsqrtYLd_BWWriteResGroup183_1_WriteDiv16_WriteIDiv16_WriteDPPSYLd_JWriteLOCK_CMPXCHGrm_SKXWriteResGroup201_WritePMULLDZLd_SKXWriteResGroup202_SKXWriteGatherEVEX2_WritePCmpEStrMLd_WritePCmpIStrILd_WritePCmpIStrMLd_WriteFSqrtXLd_HWWriteResGroup147_HWWriteResGroup132_HWWriteResGroup185_HWWriteResGroup189_ICXWriteResGroup201_ICXWriteResGroup202_ICXWriteGatherEVEX2_Zn2WriteVDIVPSYLd_WriteDiv32Ld_WriteDiv64_WriteIDiv32Ld_WriteIDiv64
  {11,  0}, // #18 SKLWriteResGroup145_WriteFDiv_WriteVecIMulXLd_WriteSHDmrcl_WriteFAdd64YLd_WriteFAddYLd_WriteFCmp64YLd_WriteFCmpYLd_WriteFDivY_WriteFMAYLd_WriteMPSADYLd_WriteFMul64YLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_SKLWriteResGroup156_SKLWriteResGroup151_SKLWriteResGroup149_SKLWriteResGroup146_SKLWriteResGroup147_SKLWriteResGroup152_SKLWriteResGroup150_SKLWriteResGroup154_SKLWriteResGroup155_AtomWrite01_11_WriteCvtPD2PS_WriteCvtSD2SSLd_WriteFHAdd_WriteVecMoveToGpr_WriteVecMoveFromGpr_WritePCmpIStrI_WriteFHAddY_PdWriteRCR8rCL_PdWriteRCL16ri_WriteFDivX_BWWriteResGroup122_1_WritePCmpIStrM_WriteFRndLd_WriteFSqrtX_WritePSADBWYLd_WriteVecIMulYLd_WriteFHAddYLd_BWWriteResGroup133_BWWriteResGroup123_BWWriteResGroup128_BWWriteResGroup131_BWWriteResGroup132_WriteCMPXCHGRMW_WriteDPPS_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_JWriteXCHGrm_XCHG_Part_JWriteCMPXCHG8B_JWriteCMPXCHG8rm_JWriteLOCK_XADDrm_XCHG_Part_WriteCvtSD2ILd_WriteCvtSS2ILd_SKXWriteResGroup159_WriteFMAZLd_WriteFAdd64ZLd_WriteFAddZLd_WriteFCmpZLd_WriteFCmp64ZLd_WriteFMul64ZLd_WriteFMulZLd_WriteFRcpZLd_SKXWriteResGroup171_SKXWriteResGroup162_SKXWriteResGroup160_SKXWriteResGroup161_SKXWriteResGroup166_SKXWriteResGroup164_SKXWriteResGroup169_SKXWriteResGroup170_SKXWriteResGroup148_2_SKXWriteResGroup163_SKXWriteResGroup167_WriteFHAddLd_WriteFMul64XLd_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePCmpEStrM_WritePHMINPOSLd_WritePMULLDLd_WritePSADBWXLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_WriteFRsqrtLd_WriteCvtPD2PSZLd_WriteCvtPD2IZLd_WriteVecShiftYLd_WriteVecShiftZLd_SBWriteResGroup108_SBWriteResGroup104_SBWriteResGroup106_WriteCLMul_WriteFMAXLd_WriteVecTestYLd_WriteFRsqrtZ_HWWriteResGroup131_HWWriteFRNDINT_HWWriteResGroup91_2_HWWriteResGroup75_HWWriteResGroup129_HWWriteResGroup130_WriteAESDecEncLd_WriteAESIMCLd_WriteAESKeyGenLd_ICXWriteResGroup159_ICXWriteResGroup171_ICXWriteResGroup162_ICXWriteResGroup160_ICXWriteResGroup161_ICXWriteResGroup166_ICXWriteResGroup164_ICXWriteResGroup169_ICXWriteResGroup170_ICXWriteResGroup148_2_ICXWriteResGroup163_ICXWriteResGroup167_ZnWriteCVTPD2PSLd_ZnWriteCVTSS2SDLd_ZnWriteFPU3_WriteVecIMulLd_ZnWriteCVTPD2PSYLd_WriteFRndYLd_ZnWriteFILD_ZnWriteSHA256RNDS2Ld_Zn2WriteFPU3_WritePMULLDYLd_Zn2WriteFILD_Zn2WriteCVSTSI2SILd_Zn2WriteSHA256RNDS2Ld_WriteFComXLd_WriteDiv16_WriteFLDC_WriteIDiv16_WriteFLD1_WriteMPSADLd_WriteCLMulLd_WriteFMALd_WriteCvtI2PDYLd_WriteCvtPS2PDYLd_WriteCvtPH2PSYLd_WriteVPMOV256Ld_Zn3WriteVPERMPSYrm
  {16,  0}, // #19 WriteFDivLd_WritePCmpIStrILd_WritePCmpIStrMLd_WritePMULLDLd_SKLWriteResGroup177_SKLWriteResGroup178_WriteBSFLd_WriteBSRLd_WriteDiv8Ld_WriteFHAddLd_WriteIDiv8Ld_WriteFHAddYLd_WriteFDivXLd_BWWriteResGroup150_WriteFSqrt64X_WriteFSqrtXLd_WriteFSqrtLd_WritePMULLDYLd_BWWriteResGroup153_WriteDPPSLd_WriteFMaskedStore64Y_WriteFMaskedStore32_JWriteXCHGrm_LdSt_Part_JWriteLOCK_CMPXCHG8rm_WriteFRsqrtZLd_SKXWriteResGroup199_HWWriteResGroup120_HWWriteResGroup186_HWWriteResGroup190_ICXWriteResGroup199_WriteDPPDLd
  {19,  0}, // #20 SKLWriteResGroup186_WriteDPPSLd_WritePCmpEStrM_WriteFSqrtYLd_WriteDiv16Ld_WriteIDiv16Ld_WritePCmpEStrILd_WriteAESIMCLd_WriteFDiv64XLd_BWWriteResGroup161_BWWriteResGroup183_4_BWWriteResGroup183_3_WriteFDivX_WritePCmpEStrMLd_JWriteLOCK_CMPXCHG8B_JWriteLOCK_ALURMW_SKXWriteResGroup209_SKXWriteGatherEVEX4_WriteDPPSYLd_WriteFDivXLd_HWWriteResGroup135_HWWriteResGroup143_HWWriteFPREM_ICXWriteResGroup209_ICXWriteGatherEVEX4_WriteDiv8Ld_WriteIDiv8Ld_ZnWriteVDIVPSYLd
  {15,  0}, // #21 WriteDPPDLd_WriteFRndYLd_SKLWriteResGroup174_SKLWriteResGroup171_WriteCMPXCHG_WriteSTMXCSR_WriteDiv16_WriteIDiv16_WritePCmpEStrMLd_PdWriteVFRCZm_PdWriteVFRCZYm_WritePMULLDLd_BWWriteResGroup149_BWWriteResGroup147_WriteDiv8Ld_WriteIDiv8Ld_WriteFRndZLd_SKXWriteResGroup195_SKXWriteResGroup191_SKXWriteResGroup174_SKXWriteResGroup174z_SKXWriteResGroup194_SBWriteResGroup119_HWWriteResGroup115_HWWriteFXTRACT_HWWriteResGroup188_WriteDPPS_ICXWriteResGroup195_ICXWriteResGroup191_ICXWriteResGroup174_ICXWriteResGroup174z_ICXWriteResGroup194_WriteFDiv64X_WriteFDivX_ZnWriteVDIVPDY_WriteDiv16Ld_WriteIDiv16Ld_WriteFSqrtX_WriteDPPSY_WriteFSqrtY
  {13,  0}, // #22 WriteDPPS_WriteDPPSY_WriteFHAddYLd_SKLWriteResGroup162_SKLWriteResGroup163_AtomWrite01_13_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteVecExtractSt_WriteCvtI2PDYLd_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_WriteCvtPS2PDYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_PdWriteCVTSI642SDrr_CVTSI642SSrr_CVTSI2SDr_CVTSI2SSrr_PdWriteRCL8ri_WriteMPSADYLd_WritePCmpIStrMLd_WriteFMaskedStore64_SKXWriteResGroup180_SKXWriteResGroup181_SKXWriteResGroup183_WriteAESDecEncLd_WriteMPSADLd_SBWriteResGroup114_WriteFDivX_WriteFRndYLd_WriteFRndZLd_HWWriteResGroup103_WriteBSFLd_WriteBSRLd_WriteCLMulLd_ICXWriteResGroup180_ICXWriteResGroup181_ICXWriteResGroup183_ZnWriteSHA1RNDS4Ld_Zn2WriteVDIVPDY_Zn2WriteSHA1RNDS4Ld_WriteDiv32_WriteFDiv64X_WriteFHAddLd_WriteIDiv32_WritePCmpEStrILd_WritePCmpEStrMLd_WriteFDiv64Y
  {12,  0}, // #23 WriteFHAddLd_WriteCLMulLd_WriteFSqrtX_WriteVecIMulYLd_WriteFSqrtY_SKLWriteResGroup160_WriteCvtPD2PSLd_WriteIMul64Ld_WriteIMul64RegLd_WriteDiv8_WriteVecExtract_WriteIDiv8_WriteFMOVMSK_WritePCmpIStrMLd_WriteVecMOVMSK_PdWriteRCL8rCL_PdWriteRCR8ri_PdWriteVPCLMULQDQrr_WriteAESDecEncLd_WriteMPSADLd_WriteFRndYLd_BWWriteResGroup135_WriteCvtSD2ILd_WriteCvtSD2SSLd_WriteCvtSS2SDLd_WriteCvtSS2ILd_WritePCmpIStrILd_WriteDPPSY_WriteVecIMulZLd_SKXWriteResGroup179_SKXWriteResGroup200_SKXWriteResGroup175_SKXWriteResGroup176_SKXWriteResGroup177_WriteAESIMC_WritePSADBWYLd_WritePSADBWZLd_WriteFHAddYLd_WriteFMul64YLd_WriteFMul64ZLd_WriteFMulYLd_WriteFMulZLd_WritePMULLDYLd_WritePMULLDZLd_SBWriteResGroup111_WriteFRndLd_WriteSHDmrcl_WriteFMAZLd_WriteFMAYLd_HWWriteResGroup91_3_HWWriteResGroup104_WriteDPPD_WriteFRcpXLd_WriteFRsqrtXLd_ICXWriteResGroup179_ICXWriteResGroup200_ICXWriteResGroup175_ICXWriteResGroup176_ICXWriteResGroup177_WriteCvtI2PDLd_WriteCvtI2PSLd_WriteCvtPD2ILd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteFRcpLd_ZnWriteRSQRTSSLd_WriteFMALd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPD2IYLd_WriteCvtPS2IYLd_ZnWriteVDIVPSYr_WriteFMAXLd_WriteFRcpYLd_ZnWriteRSQRTPSYLd_ZnWriteCVTPD2DQLd_ZnWriteFIST_ZnWriteCVSTSI2SILd_ZnWriteFPU03_Zn2WriteRSQRTSSLd_Zn2WriteRSQRTPSYLd_Zn2WriteFIST_Zn2WriteFPU03
  {28,  0}, // #24 WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteDiv32Ld_WriteFDiv64XLd_WriteFDiv64Ld_WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_WriteFSqrt64XLd_WriteFSqrt64Ld_WriteFSqrt64YLd
  {102,  0}, // #25 WriteIDiv16_WriteIDiv32_WriteIDiv64
  { 9,  0}, // #26 WriteIMulHLd
  { 8,  0}, // #27 WriteMULX32Ld_WriteMULX64Ld
  { 4,  0}, // #28 WriteIMulH
  { 3,  0}, // #29 WriteMULX32_WriteMULX64
  {24,  0}, // #30 WritePCmpEStrILd_WriteFSqrt64XLd_WritePCmpEStrMLd_BWWriteResGroup177_WriteFDiv64XLd_WriteFDivXLd_WriteFDivLd_WriteFDiv64Ld_WriteFSqrt80_HWWriteResGroup162
  {18,  0}, // #31 WritePCmpEStrI_WriteFSqrt64X_WriteFSqrtXLd_WriteFDivYLd_WriteFSqrt64Y_SKLWriteResGroup185_SKLWriteResGroup184_SKLWriteResGroupVEX2_AtomWrite01_18_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteDiv32Ld_WriteDiv64Ld_WriteIDiv32Ld_WriteIDiv64Ld_BWWriteResGroup160_BWWriteResGroup159_BWWriteResGroup183_2_WriteFDivZ_SKXWriteResGroup208_SKXWriteResGroup207_SKXWriteResGroupVEX2_WriteAESIMCLd_WriteDPPSLd_WriteFDivLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup149_ICXWriteResGroup208_ICXWriteResGroup207_ICXWriteResGroupVEX2_WriteFDivXLd
  { 6,  0}, // #32 WriteRotateLd_WriteShiftLd_WriteALULd
  { 1,  0}, // #33 WriteRMW
  { 8,  0}, // #34 WriteRotateCLLd_WriteShiftCLLd
  { 1,  0}, // #35 WriteRMW
  {23,  0}, // #36 WriteFSqrt64Ld_SKLWriteResGroup198_AtomWrite01_23_WritePCmpEStrILd_WriteFSqrt80_WriteFDiv64Y_WriteFDivYLd_BWWriteResGroup176_WriteFDiv64Z_SKXWriteResGroup228_WriteIDiv8_HWWriteResGroup151_WriteFSqrtLd_ICXWriteResGroup228
  {21,  0}, // #37 WriteFSqrt80_SKLWriteResGroup195_AtomWrite01_21_WriteFSqrt64XLd_WriteFSqrt64Ld_WriteFSqrtY_BWWriteResGroup171_BWWriteResGroup169_BWWriteResGroup183_5_WriteFSqrtX_SKXWriteResGroup222_SKXWriteResGroup205_SKXWriteGatherEVEX8_WriteFDivY_WriteFDivZ_WriteDPPSYLd_WriteFSqrtZ_HWWriteResGroup144_WritePCmpEStrI_ICXWriteResGroup222_ICXWriteResGroup205_ICXWriteGatherEVEX8_WriteDiv16Ld_WriteIDiv16Ld_WriteDiv64Ld_WriteIDiv64Ld_WriteFSqrt64Y
  { 5,  0}, // #38 WriteLoad
  { 5,  0}, // #39 WriteVecMaskedGatherWriteback
  {42,  0}, // #40 SKLWriteResGroup214_SKLWriteResGroup215_BWWriteResGroup196_WriteFSqrtY_SKXWriteResGroup254_SKXWriteResGroup255_WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd_HWWriteResGroup176_WriteFDivXLd_ICXWriteResGroup254_ICXWriteResGroup255
  {75,  0}, // #41 SKLWriteResGroup220_BWWriteResGroup200_SKXWriteResGroup263_HWWriteResGroup180_HWWriteFSCALE_ICXWriteResGroup263
  {35,  0}, // #42 SKLWriteResGroup210_SKLWriteResGroup209_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteFSqrt64YLd_BWWriteResGroup194_WriteFSqrt80_SKXWriteResGroup248_SKXWriteResGroup247_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Z_HWWriteResGroup170_ICXWriteResGroup248_ICXWriteResGroup247_WriteFSqrtYLd
  {63,  0}, // #43 SKLWriteResGroup219_SKLWriteResGroup218_AtomWrite01_63_BWWriteResGroup199_BWWriteResGroup198_SKXWriteResGroup260_SKXWriteResGroup259_ICXWriteResGroup260_ICXWriteResGroup259
  {22,  0}, // #44 SKLWriteResGroup196_SKLWriteResGroupVEX8_AtomWrite01_22_BWWriteResGroup172_WriteFMaskedStore32Y_SKXWriteResGroup223_SKXWriteResGroupVEX8_SKXWriteResGroup211_SKXWriteResGroup211_1_SKXWriteResGroup225_WriteFDiv64X_WriteDiv8_WriteFSqrt64XLd_HWWriteResGroup146_HWWriteResGroup187_WriteFDivLd_ICXWriteResGroup223_ICXWriteResGroupVEX8_ICXWriteResGroup211_ICXWriteResGroup211_1_ICXWriteResGroup225_WriteFDiv64XLd_WriteFDivXLd_WriteFDiv64Ld_ZnWriteVDIVPDYLd_WriteDPPSLd_WriteFSqrtXLd_WriteFSqrtLd_WriteFSqrt80_WriteDPPSYLd_WriteFSqrtYLd
  {37,  0}, // #45 SKLWriteResGroup211_SKXWriteResGroup250_SKXWriteResGroup249_WriteFDiv64Ld_ICXWriteResGroup250_ICXWriteResGroup249
  {27,  0}, // #46 SKLWriteResGroup206_WriteDPPSY_PdWriteVDPPSrri_WriteFSqrtYLd_WriteFSqrt64X_WriteFSqrtZLd_SKXWriteResGroup239_WriteFSqrt64XLd_WriteFSqrt64Ld_HWWriteFPREM1_HWWriteResGroup155_ICXWriteResGroup239_WriteFSqrtXLd_WriteFSqrtLd_WriteFSqrt64YLd
  {30,  0}, // #47 SKLWriteResGroup208_AtomWrite01_30_WriteDPPSLd_BWWriteResGroup186_WriteFDiv64ZLd_SKXWriteResGroup243_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_HWWriteResGroup161_HWWriteResGroup164_ICXWriteResGroup243
  {41,  0}, // #48 SKLWriteResGroup213_WriteDiv64_WriteIDiv64_SKXWriteResGroup253_HWWriteResGroup175_WriteFSqrtX_ICXWriteResGroup253
  {46,  0}, // #49 SKLWriteResGroup216_AtomWrite01_46_PdWriteVZEROUPPER_JWriteJVZEROUPPER
  {40,  0}, // #50 SKLWriteResGroup212_SKXWriteResGroup252_WriteFSqrt80_ICXWriteResGroup252_WriteFSqrt64Y
  {62,  0}, // #51 SKLWriteResGroup217_WriteFDiv64Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv8Ld_WriteFSqrt64Ld_SKXWriteResGroup258_ICXWriteResGroup258
  {106,  0}, // #52 SKLWriteResGroup223_SKXWriteResGroup266_ICXWriteResGroup266
  {50,  0}, // #53 WriteDiv16Ld_WriteDiv32Ld_WriteDiv8
  {130,  0}, // #54 WriteDiv64Ld_WriteIDiv64Ld_AtomWrite01_130
  {68,  0}, // #55 WriteDiv8Ld_AtomWrite01_68
  {125,  0}, // #56 WriteFDiv64XLd_WriteFSqrt64XLd
  {70,  0}, // #57 WriteFDivXLd_WriteFSqrtXLd
  {34,  0}, // #58 WriteFDivLd_WriteFSqrtLd_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_BWWriteResGroup191_JWriteMASKMOVDQU_SBWriteResGroup131_WriteAESKeyGenLd_HWWriteResGroup166_WriteFDiv64
  { 1,  0}, // #59 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #60 WriteRMW
  {71,  0}, // #61 WriteFSqrt80_AtomWrite01_71_WriteFSqrt64X
  {26,  0}, // #62 AtomWrite01_26_BWWriteResGroup180_WriteFSqrtXLd_WriteFSqrtLd_WriteFDiv64XLd
  {32,  0}, // #63 AtomWrite01_32_WriteDPPSYLd_WriteFSqrt64XLd_WriteFSqrt64Ld_JWriteCMPXCHG16B_WriteFSqrt64Z
  {45,  0}, // #64 AtomWrite01_45_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Y_WriteFSqrt64Z_WriteDiv64Ld_WriteIDiv64Ld
  {48,  0}, // #65 AtomWrite01_48
  {55,  0}, // #66 AtomWrite01_55
  {59,  0}, // #67 AtomWrite01_59_WriteFSqrt64YLd
  {72,  0}, // #68 AtomWrite01_72_WriteFDiv64XLd
  {74,  0}, // #69 AtomWrite01_74_SKXWriteResGroup262_WriteFSqrt64XLd_ICXWriteResGroup262
  {77,  0}, // #70 AtomWrite01_77
  {78,  0}, // #71 AtomWrite01_78
  {79,  0}, // #72 AtomWrite01_79
  {92,  0}, // #73 AtomWrite01_92
  {94,  0}, // #74 AtomWrite01_94
  {99,  0}, // #75 AtomWrite01_99
  {121,  0}, // #76 AtomWrite01_121
  {127,  0}, // #77 AtomWrite01_127
  {140,  0}, // #78 AtomWrite01_140_SKXWriteResGroup267_ICXWriteResGroup267
  {141,  0}, // #79 AtomWrite01_141
  {146,  0}, // #80 AtomWrite01_146
  {147,  0}, // #81 AtomWrite01_147
  {168,  0}, // #82 AtomWrite01_168
  {174,  0}, // #83 AtomWrite01_174
  {183,  0}, // #84 AtomWrite01_183
  {202,  0}, // #85 AtomWrite01_202
  { 5,  0}, // #86 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #87 WriteRMW
  {90,  0}, // #88 PdWriteVZEROALL_JWriteJVZEROALL
  {184,  0}, // #89 PdWriteLARrr
  {33,  0}, // #90 WriteAESKeyGenLd
  {80,  0}, // #91 WriteDiv16_WriteDiv32_WriteDiv64
  {31,  0}, // #92 WriteEMMS_SBWriteResGroup130_HWWriteResGroup163_HWWriteResGroup165
  {60,  0}, // #93 BWWriteResGroup197
  {115,  0}, // #94 BWWriteResGroup202_HWWriteResGroup183
  {44,  0}, // #95 WriteDiv64Ld_WriteIDiv64Ld_SKXWriteResGroup256_WriteFSqrtXLd_ICXWriteResGroup256
  { 4,  0}, // #96 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 2,  0}, // #97 WriteRMW
  {43,  0}, // #98 WriteFDiv64YLd_WriteFDivYLd
  {38,  0}, // #99 WriteFDiv64Y_WriteFDivY_JWriteLOCK_CMPXCHG16B_WriteFSqrt64Ld
  {54,  0}, // #100 WriteFSqrt64Y
  {47,  0}, // #101 WriteFSqrtYLd_HWWriteFBLD_WriteFSqrt64YLd
  { 3,  0}, // #102 JWriteXADDrm_XCHG_Part
  {11,  0}, // #103 JWriteXADDrm_LdSt_Part
  {39,  0}, // #104 WriteFSqrt64ZLd_WriteFDivX
  {67,  0}, // #105 SKXWriteResGroup261_ICXWriteResGroup261
  { 7,  0}, // #106 WriteRotateLd
  { 1,  0}, // #107 WriteRMW
  {52,  0}, // #108 WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd
  {36,  0}, // #109 WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_HWWriteResGroup171
  {98,  0}, // #110 WriteDiv16_WriteDiv32_WriteDiv64
  {112,  0}, // #111 WriteIDiv16_WriteIDiv32_WriteIDiv64
  {64,  0}, // #112 HWWriteResGroup179_HWWriteResGroup178
  {61,  0}, // #113 HWWriteResGroup177
  {69,  0}, // #114 WriteFDiv64X
  { 4,  0}, // #115 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #116 WriteRMW
  { 7,  0}, // #117 WriteIMulHLd
  { 8,  0}, // #118 WriteMULX32Ld_WriteMULX64Ld
  { 3,  0}, // #119 WriteIMulH
  { 3,  0}, // #120 WriteMULX32_WriteMULX64
  {107,  0}, // #121 WriteFShuffle256Ld_WriteFVarShuffle256Ld
  { 8,  0}, // #122 WriteLoad
  { 8,  0}, // #123 WriteVecMaskedGatherWriteback_WriteIMulHLd
  { 7,  0}, // #124 WriteIMulHLd_WriteMULX32Ld_WriteMULX64Ld
  { 7,  0} // #125 WriteMULX32Ld_WriteMULX64Ld
}; // X86WriteLatencyTable

// {UseIdx, WriteResourceID, Cycles}
extern const llvm::MCReadAdvanceEntry X86ReadAdvanceTable[] = {
  {0,  0,  0}, // Invalid
  {5,  0,  5}, // #1
  {6,  0,  5}, // #2
  {0,  0,  5}, // #3
  {6,  0,  5}, // #4
  {0,  0,  6}, // #5
  {1,  0,  0}, // #6
  {0,  0,  7}, // #7
  {0,  0,  7}, // #8
  {6,  0,  7}, // #9
  {0,  0,  6}, // #10
  {6,  0,  6}, // #11
  {0,  0,  7}, // #12
  {1,  0,  7}, // #13
  {0,  0,  6}, // #14
  {1,  0,  6}, // #15
  {0,  0,  5}, // #16
  {1,  0,  5}, // #17
  {5,  0,  3}, // #18
  {6,  0,  3}, // #19
  {0,  0,  3}, // #20
  {6,  0,  3}, // #21
  {0,  0,  3}, // #22
  {1,  0,  3}, // #23
  {5,  0,  4}, // #24
  {6,  0,  4}, // #25
  {0,  0,  4}, // #26
  {6,  0,  4}, // #27
  {0,  0, -10}, // #28
  {1,  0, -10}, // #29
  {0,  0, -6}, // #30
  {1,  0, -6}, // #31
  {5,  0,  3}, // #32
  {6,  0,  3}, // #33
  {7,  0,  3}, // #34
  {8,  0,  3}, // #35
  {0,  0,  8}, // #36
  {0,  0,  8}, // #37
  {6,  0,  8}, // #38
  {0,  0,  8}, // #39
  {1,  0,  8}, // #40
  {0,  0, -1}, // #41
  {1,  0, -1} // #42
}; // X86ReadAdvanceTable

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc SkylakeClientModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, false,  3, 5,  1, 1,  0, 0}, // #3
  {DBGFIELD("WriteJump")          1, false, false, false,  8, 4,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteCMPXCHGRMW")    6, false, false, false, 12, 8,  2, 1,  0, 0}, // #5
  {DBGFIELD("WriteJumpLd")        2, false, false, false, 20, 6,  3, 1,  0, 0}, // #6
  {DBGFIELD("WriteMove")          1, false, false, false,  1, 2,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, false,  1, 2,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteADC")           1, false, false, false,  8, 4,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteSHDrri")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreX")       2, false, false, false, 33, 4,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteFLoadX")        1, false, false, false, 37, 3,  3, 1,  0, 0}, // #12
  {DBGFIELD("WriteFStoreY")       2, false, false, false, 33, 4,  1, 1,  0, 0}, // #13
  {DBGFIELD("WriteFLoadY")        1, false, false, false, 37, 3,  6, 1,  0, 0}, // #14
  {DBGFIELD("WriteMicrocoded")    1, false, false, false,  1, 2,  4, 1,  0, 0}, // #15
  {DBGFIELD("WriteFSign")         1, false, false, false, 40, 9,  1, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCRMW")        6, false, false, false, 12, 8,  2, 1,  0, 0}, // #17
  {DBGFIELD("WriteADCRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 6, false, false, false, 12, 8,  2, 1,  1, 2}, // #18
  {DBGFIELD("WriteADCLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 20, 6,  3, 1,  3, 2}, // #19
  {DBGFIELD("WriteALURMW")        3, false, false, false, 49, 6,  6, 1,  0, 0}, // #20
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, false, 49, 6,  6, 1,  1, 1}, // #21
  {DBGFIELD("WriteALULd_ReadAfterLd") 2, false, false, false, 55, 4,  3, 1,  3, 1}, // #22
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1,  5, 1}, // #23
  {DBGFIELD("WriteFAdd64X")       1, false, false, false, 65, 4,  8, 1,  0, 0}, // #24
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1,  5, 1}, // #25
  {DBGFIELD("WriteFAddX")         1, false, false, false, 65, 4,  8, 1,  0, 0}, // #26
  {DBGFIELD("WriteNop")           1, false, false, false,  0, 0,  1, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 2, false, false, false, 59, 6,  9, 1,  3, 1}, // #28
  {DBGFIELD("WriteFAdd64")        1, false, false, false, 65, 4,  8, 1,  0, 0}, // #29
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 2, false, false, false, 59, 6,  9, 1,  3, 1}, // #30
  {DBGFIELD("WriteFAdd")          1, false, false, false, 65, 4,  8, 1,  0, 0}, // #31
  {DBGFIELD("WriteFAddLd")        2, false, false, false, 59, 6,  9, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  7, 1,  5, 1}, // #33
  {DBGFIELD("WriteAESDecEnc")     1, false, false, false, 40, 9,  8, 1,  0, 0}, // #34
  {DBGFIELD("WriteAESIMCLd")      3, false, false, false, 80, 11, 10, 1,  0, 0}, // #35
  {DBGFIELD("WriteAESIMC")        2, false, false, false, 91, 9,  2, 1,  0, 0}, // #36
  {DBGFIELD("WriteAESKeyGenLd")   11, false, false, false, 100, 14, 11, 1,  0, 0}, // #37
  {DBGFIELD("WriteAESKeyGen")     11, false, false, false, 114, 12, 12, 1,  0, 0}, // #38
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 2, false, false, false, 60, 5,  6, 1,  5, 1}, // #39
  {DBGFIELD("WriteFLogic")        1, false, false, false, 30, 3,  1, 1,  0, 0}, // #40
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, false, 126, 8,  6, 1,  1, 1}, // #41
  {DBGFIELD("WriteBEXTR")         2, false, false, false, 134, 6, 13, 1,  0, 0}, // #42
  {DBGFIELD("WriteBEXTRLd")       3, false, false, false, 126, 8,  6, 1,  0, 0}, // #43
  {DBGFIELD("WriteALULd")         2, false, false, false, 55, 4,  3, 1,  0, 0}, // #44
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 2, false, false, false, 60, 5,  6, 1,  5, 1}, // #45
  {DBGFIELD("WriteFBlend")        1, false, false, false, 30, 3,  1, 1,  0, 0}, // #46
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 3, false, false, false, 140, 5,  2, 1,  5, 1}, // #47
  {DBGFIELD("WriteFVarBlend")     2, false, false, false, 145, 3, 13, 1,  0, 0}, // #48
  {DBGFIELD("WriteBLSLd")         2, false, false, false, 148, 6,  3, 1,  0, 0}, // #49
  {DBGFIELD("WriteBLS")           1, false, false, false, 154, 4,  1, 1,  0, 0}, // #50
  {DBGFIELD("WriteBSFLd")         2, false, false, false, 158, 9,  2, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSF")           1, false, false, false, 26, 7,  5, 1,  0, 0}, // #52
  {DBGFIELD("WriteBSRLd")         2, false, false, false, 158, 9,  2, 1,  0, 0}, // #53
  {DBGFIELD("WriteBSR")           1, false, false, false, 26, 7,  5, 1,  0, 0}, // #54
  {DBGFIELD("WriteBSWAP32")       1, false, false, false, 154, 4,  1, 1,  0, 0}, // #55
  {DBGFIELD("WriteBSWAP64")       2, false, false, false, 134, 6, 13, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestImmLd")  2, false, false, false, 20, 6,  3, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestRegLd")  2, false, false, false, 55, 4,  3, 1,  0, 0}, // #58
  {DBGFIELD("WriteBitTest")       1, false, false, false,  8, 4,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBitTestSetImmRMW") 4, false, false, false, 167, 8,  3, 1,  0, 0}, // #60
  {DBGFIELD("WriteBitTestSetRegRMW") 3, false, false, false, 49, 6,  3, 1,  0, 0}, // #61
  {DBGFIELD("WriteBitTestSet")    1, false, false, false,  8, 4,  1, 1,  0, 0}, // #62
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 148, 6,  3, 1,  1, 1}, // #63
  {DBGFIELD("WriteBZHI")          1, false, false, false, 154, 4,  1, 1,  0, 0}, // #64
  {DBGFIELD("WriteLoad")          1, false, false, false, 37, 3, 14, 1,  0, 0}, // #65
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 2, false, false, false, 20, 6,  3, 1,  3, 1}, // #66
  {DBGFIELD("WriteCMOV")          1, false, false, false,  8, 4,  1, 1,  0, 0}, // #67
  {DBGFIELD("WriteFCMOV")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #68
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 55, 4,  3, 1,  1, 1}, // #69
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1,  5, 1}, // #70
  {DBGFIELD("WriteFCmp64X")       1, false, false, false, 65, 4,  8, 1,  0, 0}, // #71
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1,  5, 1}, // #72
  {DBGFIELD("WriteFCmpX")         1, false, false, false, 65, 4,  8, 1,  0, 0}, // #73
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 2, false, false, false, 59, 6,  9, 1,  3, 1}, // #74
  {DBGFIELD("WriteFCmp64")        1, false, false, false, 65, 4,  8, 1,  0, 0}, // #75
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 2, false, false, false, 59, 6,  9, 1,  3, 1}, // #76
  {DBGFIELD("WriteFCmp")          1, false, false, false, 65, 4,  8, 1,  0, 0}, // #77
  {DBGFIELD("WriteCMPXCHG")       5, false, false, false, 175, 4, 14, 1,  0, 0}, // #78
  {DBGFIELD("WriteFComXLd_ReadAfterVecLd") 2, false, false, false, 69, 11,  6, 1,  3, 1}, // #79
  {DBGFIELD("WriteFComX")         1, false, false, false, 40, 9, 13, 1,  0, 0}, // #80
  {DBGFIELD("WriteFCom")          1, false, false, false, 40, 9, 13, 1,  0, 0}, // #81
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #82
  {DBGFIELD("WriteCRC32")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtI2PDLd")     2, false, false, false, 158, 9,  9, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtI2PD")       1, false, false, false, 26, 7,  8, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtI2PSLd")     2, false, false, false, 158, 9,  9, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtI2PS")       1, false, false, false, 26, 7,  8, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtPD2ILd")     2, false, false, false, 158, 9,  2, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPD2I")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPD2PSLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPD2PS")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPS2ILd")     2, false, false, false, 158, 9,  2, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtPS2I")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtPS2PD")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtSD2ILd")     2, false, false, false, 158, 9,  2, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtSD2I")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtSD2SSLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #100
  {DBGFIELD("WriteCvtSD2SS")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, false, 158, 9,  9, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  9, 1,  3, 1}, // #103
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 1, false, false, false, 26, 7,  8, 1,  0, 1}, // #104
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 1, false, false, false, 26, 7,  8, 1,  6, 1}, // #105
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, false, 158, 9,  9, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  9, 1,  3, 1}, // #107
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 1, false, false, false, 26, 7,  8, 1,  0, 1}, // #108
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 1, false, false, false, 26, 7,  8, 1,  6, 1}, // #109
  {DBGFIELD("WriteCvtSS2SDLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #110
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #111
  {DBGFIELD("WriteCvtSS2SD")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #112
  {DBGFIELD("WriteCvtSS2ILd")     2, false, false, false, 158, 9,  2, 1,  0, 0}, // #113
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #114
  {DBGFIELD("WriteCvtSS2I")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #115
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 179, 12, 15, 1,  1, 2}, // #116
  {DBGFIELD("WriteDiv16")         32, false, false, false, 191, 15, 16, 1,  0, 0}, // #117
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 179, 12, 15, 1,  1, 2}, // #118
  {DBGFIELD("WriteDiv32")         32, false, false, false, 191, 15, 16, 1,  0, 0}, // #119
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 179, 12, 15, 1,  1, 2}, // #120
  {DBGFIELD("WriteDiv64")         32, false, false, false, 191, 15, 16, 1,  0, 0}, // #121
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 179, 12, 15, 1,  1, 2}, // #122
  {DBGFIELD("WriteDiv8")          1, false, false, false, 206, 10, 11, 1,  0, 0}, // #123
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 2, false, false, false, 216, 12, 12, 1,  5, 1}, // #124
  {DBGFIELD("WriteFDiv64X")       1, false, false, false, 228, 10, 10, 1,  0, 0}, // #125
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 2, false, false, false, 238, 12, 17, 1,  5, 1}, // #126
  {DBGFIELD("WriteFDivX")         1, false, false, false, 228, 10, 18, 1,  0, 0}, // #127
  {DBGFIELD("WriteFDivLd")        2, false, false, false, 250, 12, 19, 1,  0, 0}, // #128
  {DBGFIELD("WriteFDiv")          1, false, false, false, 228, 10, 18, 1,  0, 0}, // #129
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 2, false, false, false, 216, 12, 20, 1,  3, 1}, // #130
  {DBGFIELD("WriteFDiv64")        1, false, false, false, 228, 10, 10, 1,  0, 0}, // #131
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 2, false, false, false, 250, 12, 19, 1,  3, 1}, // #132
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 4, false, false, false, 262, 11, 21, 1,  5, 1}, // #133
  {DBGFIELD("WriteDPPD")          3, false, false, false, 273, 9,  9, 1,  0, 0}, // #134
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 5, false, false, false, 282, 11, 20, 1,  5, 1}, // #135
  {DBGFIELD("WriteDPPS")          4, false, false, false, 293, 9, 22, 1,  0, 0}, // #136
  {DBGFIELD("WriteStore")         1, false, false, false, 33, 4,  1, 1,  0, 0}, // #137
  {DBGFIELD("WriteVecExtractSt")  3, false, false, false, 302, 11, 13, 1,  0, 0}, // #138
  {DBGFIELD("WriteVecExtract")    2, false, false, false, 313, 12,  5, 1,  0, 0}, // #139
  {DBGFIELD("WriteVecALUX")       1, false, false, false, 65, 4,  1, 1,  0, 0}, // #140
  {DBGFIELD("WriteFComLd")        2, false, false, false, 69, 11,  6, 1,  0, 0}, // #141
  {DBGFIELD("WriteEMMS")          10, false, false, false, 325, 5,  7, 1,  0, 0}, // #142
  {DBGFIELD("WriteFLDC")          2, false, false, false, 330, 5,  1, 1,  0, 0}, // #143
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  6, 1,  5, 1}, // #144
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 4, false, false, false, 335, 11, 23, 1,  5, 1}, // #145
  {DBGFIELD("WriteFHAdd")         3, false, false, false, 346, 9,  3, 1,  0, 0}, // #146
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 355, 14, 24, 1,  1, 2}, // #147
  {DBGFIELD("WriteIDiv16")        66, false, false, false, 369, 15, 25, 1,  0, 0}, // #148
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 355, 14, 24, 1,  1, 2}, // #149
  {DBGFIELD("WriteIDiv32")        66, false, false, false, 369, 15, 25, 1,  0, 0}, // #150
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 355, 14, 24, 1,  1, 2}, // #151
  {DBGFIELD("WriteIDiv64")        66, false, false, false, 369, 15, 25, 1,  0, 0}, // #152
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 355, 14, 24, 1,  1, 2}, // #153
  {DBGFIELD("WriteIDiv8")         1, false, false, false, 206, 10, 11, 1,  0, 0}, // #154
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 384, 11,  9, 1,  1, 2}, // #155
  {DBGFIELD("WriteIMul16")        4, false, false, false, 395, 9,  8, 1,  0, 0}, // #156
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #157
  {DBGFIELD("WriteIMul16ImmLd")   3, false, false, false, 404, 9,  2, 1,  0, 0}, // #158
  {DBGFIELD("WriteIMul16Reg")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul16Imm")     2, false, false, false, 413, 7,  8, 1,  0, 0}, // #160
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 420, 11,  9, 1,  1, 2}, // #161
  {DBGFIELD("WriteIMul32")        3, false, false, false, 431, 9,  8, 1,  0, 0}, // #162
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #163
  {DBGFIELD("WriteIMul32ImmLd")   2, false, false, false, 158, 9,  2, 1,  0, 0}, // #164
  {DBGFIELD("WriteIMul32Reg")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul32Imm")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #166
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 440, 13,  9, 1,  1, 2}, // #167
  {DBGFIELD("WriteIMul64")        2, false, false, false, 453, 11,  8, 1,  0, 0}, // #168
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #169
  {DBGFIELD("WriteIMul64ImmLd")   2, false, false, false, 158, 9,  2, 1,  0, 0}, // #170
  {DBGFIELD("WriteIMul64Reg")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #171
  {DBGFIELD("WriteIMul64Imm")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #172
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 158, 9,  2, 1,  1, 2}, // #173
  {DBGFIELD("WriteIMul8")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #174
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #175
  {DBGFIELD("WriteFShuffle")      1, false, false, false, 474, 8,  1, 1,  0, 0}, // #176
  {DBGFIELD("WriteVecLogicX")     1, false, false, false, 30, 3,  1, 1,  0, 0}, // #177
  {DBGFIELD("WriteShuffle")       1, false, false, false, 474, 8,  1, 1,  0, 0}, // #178
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, false,  8, 4,  1, 1,  0, 0}, // #179
  {DBGFIELD("WriteVecLoadX")      1, false, false, false, 37, 3,  3, 1,  0, 0}, // #180
  {DBGFIELD("WriteLDMXCSR")       3, false, false, false, 482, 11,  6, 1,  0, 0}, // #181
  {DBGFIELD("WriteFLD0")          1, false, false, false,  3, 5,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteFLD1")          2, false, false, false, 330, 5,  1, 1,  0, 0}, // #183
  {DBGFIELD("WriteLEA")           1, false, false, false, 154, 4,  1, 1,  0, 0}, // #184
  {DBGFIELD("WriteFence")         1, false, false, false, 493, 5,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteLZCNTLd")       2, false, false, false, 158, 9,  2, 1,  0, 0}, // #186
  {DBGFIELD("WriteLZCNT")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecStoreX")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #188
  {DBGFIELD("WriteVecStore")      2, false, false, false, 33, 4,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, false, 40, 9, 13, 1,  0, 0}, // #190
  {DBGFIELD("WriteVecLoad")       1, false, false, false, 37, 3, 14, 1,  0, 0}, // #191
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecMoveX")      1, false, false, false, 30, 3,  1, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecStoreNT")    2, false, false, false, 33, 4,  1, 1,  0, 0}, // #194
  {DBGFIELD("WriteVecMove")       1, false, false, false,  3, 5,  1, 1,  0, 0}, // #195
  {DBGFIELD("WriteVecALULd")      2, false, false, false, 498, 7,  3, 1,  0, 0}, // #196
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #197
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 2, false, false, false, 498, 7,  3, 1,  3, 1}, // #198
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 2, false, false, false, 498, 7,  3, 1,  3, 1}, // #199
  {DBGFIELD("WriteVecLogic")      1, false, false, false,  3, 5,  1, 1,  0, 0}, // #200
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, false, 505, 10,  2, 1,  3, 1}, // #201
  {DBGFIELD("WritePHAdd")         3, false, false, false, 515, 8,  5, 1,  0, 0}, // #202
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #203
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 2, false, false, false, 523, 8, 13, 1,  6, 1}, // #204
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #205
  {DBGFIELD("WriteVecIMul")       1, false, false, false, 40, 9, 14, 1,  0, 0}, // #206
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, false, 40, 9, 13, 1,  0, 0}, // #207
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 2, false, false, false, 464, 10,  2, 1,  3, 1}, // #208
  {DBGFIELD("WritePSADBW")        1, false, false, false, 474, 8,  5, 1,  0, 0}, // #209
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #210
  {DBGFIELD("WriteVarShuffle")    1, false, false, false, 474, 8,  1, 1,  0, 0}, // #211
  {DBGFIELD("WriteShuffleLd")     2, false, false, false, 464, 10,  3, 1,  0, 0}, // #212
  {DBGFIELD("WriteVecShiftImm")   1, false, false, false, 40, 9,  1, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 2, false, false, false, 69, 11,  3, 1,  3, 1}, // #214
  {DBGFIELD("WriteVecShift")      1, false, false, false, 40, 9,  1, 1,  0, 0}, // #215
  {DBGFIELD("WriteFMoveX")        1, false, false, false, 30, 3,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteFShuffleLd")    2, false, false, false, 464, 10,  6, 1,  0, 0}, // #217
  {DBGFIELD("WriteFStore")        2, false, false, false, 33, 4,  1, 1,  0, 0}, // #218
  {DBGFIELD("WriteFMOVMSK")       1, false, false, false, 40, 9, 13, 1,  0, 0}, // #219
  {DBGFIELD("WriteVecLoadNT")     1, false, false, false, 37, 3,  3, 1,  0, 0}, // #220
  {DBGFIELD("WriteStoreNT")       2, false, false, false, 33, 4,  1, 1,  0, 0}, // #221
  {DBGFIELD("WriteFStoreNTX")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #222
  {DBGFIELD("WriteFStoreNT")      2, false, false, false, 33, 4,  1, 1,  0, 0}, // #223
  {DBGFIELD("WriteFLoad")         1, false, false, false, 37, 3, 14, 1,  0, 0}, // #224
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 3, false, false, false, 531, 10,  7, 1,  5, 1}, // #225
  {DBGFIELD("WriteMPSAD")         2, false, false, false, 523, 8,  8, 1,  0, 0}, // #226
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1,  5, 1}, // #227
  {DBGFIELD("WriteFMul64X")       1, false, false, false, 65, 4,  8, 1,  0, 0}, // #228
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1,  5, 1}, // #229
  {DBGFIELD("WriteFMulX")         1, false, false, false, 65, 4,  8, 1,  0, 0}, // #230
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 2, false, false, false, 59, 6,  9, 1,  3, 1}, // #231
  {DBGFIELD("WriteFMul64")        1, false, false, false, 65, 4,  8, 1,  0, 0}, // #232
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 2, false, false, false, 59, 6,  9, 1,  3, 1}, // #233
  {DBGFIELD("WriteFMul")          1, false, false, false, 65, 4,  8, 1,  0, 0}, // #234
  {DBGFIELD("WriteMULX32Ld")      4, false, false, false, 420, 11,  2, 1,  0, 0}, // #235
  {DBGFIELD("WriteMULX32")        3, false, false, false, 431, 9,  5, 1,  0, 0}, // #236
  {DBGFIELD("WriteIMulHLd_WriteMULX32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 5, false, false, false, 420, 11, 26, 2,  1, 1}, // #237
  {DBGFIELD("WriteIMulH_WriteMULX32") 4, false, false, false, 431, 9, 28, 2,  0, 0}, // #238
  {DBGFIELD("WriteMULX64Ld")      3, false, false, false, 440, 13,  2, 1,  0, 0}, // #239
  {DBGFIELD("WriteMULX64")        2, false, false, false, 453, 11,  5, 1,  0, 0}, // #240
  {DBGFIELD("WriteIMulHLd_WriteMULX64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 4, false, false, false, 440, 13, 26, 2,  1, 1}, // #241
  {DBGFIELD("WriteIMulH_WriteMULX64") 3, false, false, false, 453, 11, 28, 2,  0, 0}, // #242
  {DBGFIELD("WriteFMulLd")        2, false, false, false, 59, 6,  9, 1,  0, 0}, // #243
  {DBGFIELD("WriteVecALUXLd")     2, false, false, false, 59, 6,  6, 1,  0, 0}, // #244
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #245
  {DBGFIELD("WriteShuffleX")      1, false, false, false, 474, 8,  1, 1,  0, 0}, // #246
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 2, false, false, false, 60, 5,  6, 1,  5, 1}, // #247
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 3, false, false, false, 140, 5,  2, 1,  5, 1}, // #248
  {DBGFIELD("WriteVarBlend")      2, false, false, false, 145, 3, 13, 1,  0, 0}, // #249
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #250
  {DBGFIELD("WriteBlend")         1, false, false, false, 474, 8,  1, 1,  0, 0}, // #251
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 2, false, false, false, 464, 10, 23, 1,  5, 1}, // #252
  {DBGFIELD("WriteCLMul")         1, false, false, false, 474, 8,  3, 1,  0, 0}, // #253
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 9, false, false, false, 541, 14, 30, 1,  5, 1}, // #254
  {DBGFIELD("WritePCmpEStrI")     8, false, false, false, 555, 12, 31, 1,  0, 0}, // #255
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 10, false, false, false, 567, 14, 11, 1,  5, 1}, // #256
  {DBGFIELD("WritePCmpEStrM")     9, false, false, false, 581, 12, 20, 1,  0, 0}, // #257
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 4, false, false, false, 593, 11, 19, 1,  5, 1}, // #258
  {DBGFIELD("WritePCmpIStrI")     3, false, false, false, 604, 9,  7, 1,  0, 0}, // #259
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 4, false, false, false, 593, 11, 19, 1,  5, 1}, // #260
  {DBGFIELD("WritePCmpIStrM")     3, false, false, false, 604, 9,  7, 1,  0, 0}, // #261
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 2, false, false, false, 158, 9,  2, 1,  5, 1}, // #262
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 4, false, false, false, 613, 10,  9, 1,  5, 1}, // #263
  {DBGFIELD("WritePHAddX")        3, false, false, false, 623, 8,  5, 1,  0, 0}, // #264
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, false, 59, 6,  7, 1,  0, 0}, // #265
  {DBGFIELD("WritePHMINPOS")      1, false, false, false, 65, 4,  8, 1,  0, 0}, // #266
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 2, false, false, false, 158, 9,  9, 1,  5, 1}, // #267
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6, 18, 1,  5, 1}, // #268
  {DBGFIELD("WriteVecIMulX")      1, false, false, false, 65, 4, 14, 1,  0, 0}, // #269
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, false, 40, 9, 13, 1,  0, 0}, // #270
  {DBGFIELD("WriteShuffleXLd")    2, false, false, false, 464, 10,  6, 1,  0, 0}, // #271
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 3, false, false, false, 631, 6, 19, 1,  5, 1}, // #272
  {DBGFIELD("WritePMULLD")        2, false, false, false, 637, 4,  7, 1,  0, 0}, // #273
  {DBGFIELD("WriteCopy")          2, false, false, false, 641, 5,  3, 1,  0, 0}, // #274
  {DBGFIELD("WritePOPCNTLd")      2, false, false, false, 158, 9,  2, 1,  0, 0}, // #275
  {DBGFIELD("WritePOPCNT")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #276
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #277
  {DBGFIELD("WritePSADBWX")       1, false, false, false, 474, 8,  5, 1,  0, 0}, // #278
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #279
  {DBGFIELD("WriteVarShuffleX")   1, false, false, false, 474, 8,  1, 1,  0, 0}, // #280
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, false, 65, 4,  1, 1,  0, 0}, // #281
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  6, 1,  5, 1}, // #282
  {DBGFIELD("WriteVecShiftX")     2, false, false, false, 646, 9, 13, 1,  0, 0}, // #283
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 3, false, false, false, 655, 14,  9, 1,  5, 1}, // #284
  {DBGFIELD("WriteVecTest")       2, false, false, false, 313, 12,  5, 1,  0, 0}, // #285
  {DBGFIELD("WriteRotateLd_WriteRMW") 3, false, false, false, 167, 8, 32, 2,  0, 0}, // #286
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 5, false, false, false, 669, 8, 34, 2,  0, 0}, // #287
  {DBGFIELD("WriteRotate")        1, false, false, false,  8, 4,  1, 1,  0, 0}, // #288
  {DBGFIELD("WriteRotateCL")      3, false, false, false, 677, 4,  5, 1,  0, 0}, // #289
  {DBGFIELD("WriteFRcpXLd")       2, false, false, false, 69, 11,  7, 1,  0, 0}, // #290
  {DBGFIELD("WriteFRcpX")         1, false, false, false, 40, 9,  8, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRcpLd")        2, false, false, false, 69, 11,  9, 1,  0, 0}, // #292
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 2, false, false, false, 69, 11,  9, 1,  3, 1}, // #293
  {DBGFIELD("WriteFRcp")          1, false, false, false, 40, 9,  8, 1,  0, 0}, // #294
  {DBGFIELD("WriteRMW")           1, false, false, false, 33, 4,  1, 1,  0, 0}, // #295
  {DBGFIELD("WriteShiftLd")       2, false, false, false, 20, 6,  3, 1,  0, 0}, // #296
  {DBGFIELD("WriteShift")         1, false, false, false,  8, 4,  1, 1,  0, 0}, // #297
  {DBGFIELD("WriteFRndLd")        3, false, false, false, 631, 6, 10, 1,  0, 0}, // #298
  {DBGFIELD("WriteFRnd")          2, false, false, false, 637, 4,  2, 1,  0, 0}, // #299
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 3, false, false, false, 631, 6, 10, 1,  5, 1}, // #300
  {DBGFIELD("WriteFRsqrtXLd")     2, false, false, false, 69, 11,  7, 1,  0, 0}, // #301
  {DBGFIELD("WriteFRsqrtX")       1, false, false, false, 40, 9,  8, 1,  0, 0}, // #302
  {DBGFIELD("WriteFRsqrtLd")      2, false, false, false, 69, 11,  9, 1,  0, 0}, // #303
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 2, false, false, false, 69, 11,  9, 1,  3, 1}, // #304
  {DBGFIELD("WriteFRsqrt")        1, false, false, false, 40, 9,  8, 1,  0, 0}, // #305
  {DBGFIELD("WriteShiftLd_WriteRMW") 3, false, false, false, 167, 8, 32, 2,  0, 0}, // #306
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 5, false, false, false, 669, 8, 34, 2,  0, 0}, // #307
  {DBGFIELD("WriteShiftCL")       3, false, false, false, 677, 4,  5, 1,  0, 0}, // #308
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 20, 6,  3, 1,  1, 1}, // #309
  {DBGFIELD("WriteSETCCStore")    3, false, false, false, 681, 7, 13, 1,  0, 0}, // #310
  {DBGFIELD("WriteSETCC")         1, false, false, false,  8, 4,  1, 1,  0, 0}, // #311
  {DBGFIELD("WriteSHDmrcl")       6, false, false, false, 688, 11, 18, 1,  0, 0}, // #312
  {DBGFIELD("WriteSHDmri")        4, false, false, false, 699, 9,  9, 1,  0, 0}, // #313
  {DBGFIELD("WriteSHDrrcl")       4, false, false, false, 708, 9,  3, 1,  0, 0}, // #314
  {DBGFIELD("WriteFSqrt64XLd")    2, false, false, false, 717, 12, 30, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrt64X")      1, false, false, false, 729, 10, 31, 1,  0, 0}, // #316
  {DBGFIELD("WriteFSqrtXLd")      2, false, false, false, 250, 12, 31, 1,  0, 0}, // #317
  {DBGFIELD("WriteFSqrtX")        1, false, false, false, 228, 10, 23, 1,  0, 0}, // #318
  {DBGFIELD("WriteFSqrt64Ld")     2, false, false, false, 717, 12, 36, 1,  0, 0}, // #319
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 2, false, false, false, 717, 12, 36, 1,  3, 1}, // #320
  {DBGFIELD("WriteFSqrt64")       1, false, false, false, 729, 10, 31, 1,  0, 0}, // #321
  {DBGFIELD("WriteFSqrtLd")       2, false, false, false, 250, 12, 17, 1,  0, 0}, // #322
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 2, false, false, false, 250, 12, 17, 1,  3, 1}, // #323
  {DBGFIELD("WriteFSqrt")         1, false, false, false, 228, 10, 23, 1,  0, 0}, // #324
  {DBGFIELD("WriteFSqrt80")       1, false, false, false, 739, 10, 37, 1,  0, 0}, // #325
  {DBGFIELD("WriteSTMXCSR")       3, false, false, false, 302, 11, 13, 1,  0, 0}, // #326
  {DBGFIELD("WriteTZCNTLd")       2, false, false, false, 158, 9,  2, 1,  0, 0}, // #327
  {DBGFIELD("WriteTZCNT")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #328
  {DBGFIELD("WriteFMAZLd")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #329
  {DBGFIELD("WriteFMALd")         2, false, false, false, 59, 6,  9, 1,  0, 0}, // #330
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1,  7, 1}, // #331
  {DBGFIELD("WriteFAdd64Y")       1, false, false, false, 65, 4,  8, 1,  0, 0}, // #332
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteFAdd64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1,  7, 1}, // #335
  {DBGFIELD("WriteFAddY")         1, false, false, false, 65, 4,  8, 1,  0, 0}, // #336
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteFAddZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  2, 1,  7, 1}, // #339
  {DBGFIELD("WriteShuffleY")      1, false, false, false, 474, 8,  1, 1,  0, 0}, // #340
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteShuffleZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 2, false, false, false, 60, 5,  2, 1,  7, 1}, // #343
  {DBGFIELD("WriteFLogicY")       1, false, false, false, 30, 3,  1, 1,  0, 0}, // #344
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #345
  {DBGFIELD("WriteFLogicZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #346
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 3, false, false, false, 140, 5,  9, 1,  7, 1}, // #347
  {DBGFIELD("WriteFVarBlendY")    2, false, false, false, 145, 3, 13, 1,  0, 0}, // #348
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #349
  {DBGFIELD("WriteFVarBlendZ")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 2, false, false, false, 60, 5,  2, 1,  7, 1}, // #351
  {DBGFIELD("WriteFBlendY")       1, false, false, false, 30, 3,  1, 1,  0, 0}, // #352
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 3, false, false, false, 140, 5,  9, 1,  8, 2}, // #353
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, false, 140, 5,  2, 1, 10, 2}, // #354
  {DBGFIELD("WriteShuffle256Ld")  2, false, false, false, 464, 10,  7, 1,  0, 0}, // #355
  {DBGFIELD("WriteShuffle256")    1, false, false, false, 474, 8,  5, 1,  0, 0}, // #356
  {DBGFIELD("WriteShuffleYLd")    2, false, false, false, 464, 10,  2, 1,  0, 0}, // #357
  {DBGFIELD("WriteFShuffle256")   1, false, false, false, 474, 8,  5, 1,  0, 0}, // #358
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #359
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1,  7, 1}, // #360
  {DBGFIELD("WriteFCmp64Y")       1, false, false, false, 65, 4,  8, 1,  0, 0}, // #361
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1,  7, 1}, // #362
  {DBGFIELD("WriteFCmpY")         1, false, false, false, 65, 4,  8, 1,  0, 0}, // #363
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #364
  {DBGFIELD("WriteFCmpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("WriteVarShuffle256Ld") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #366
  {DBGFIELD("WriteVarShuffle256") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #367
  {DBGFIELD("WriteCvtI2PDYLd")    2, false, false, false, 158, 9,  9, 1,  0, 0}, // #368
  {DBGFIELD("WriteCvtI2PDY")      1, false, false, false, 26, 7,  8, 1,  0, 0}, // #369
  {DBGFIELD("WriteCvtI2PDZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #370
  {DBGFIELD("WriteCvtI2PDZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, false, 158, 9,  9, 1,  0, 0}, // #372
  {DBGFIELD("WriteCvtI2PSY")      1, false, false, false, 26, 7,  8, 1,  0, 0}, // #373
  {DBGFIELD("WriteCvtI2PSZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #374
  {DBGFIELD("WriteCvtI2PSZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 2, false, false, false, 158, 9,  2, 1,  5, 1}, // #376
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 2, false, false, false, 158, 9,  2, 1,  7, 1}, // #377
  {DBGFIELD("WriteCvtPD2PSY")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #378
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtPD2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteCvtPD2PSYLd")   2, false, false, false, 158, 9,  2, 1,  0, 0}, // #381
  {DBGFIELD("WriteCvtPD2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #382
  {DBGFIELD("WriteCvtPD2IYLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #383
  {DBGFIELD("WriteCvtPD2IY")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #384
  {DBGFIELD("WriteCvtPD2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #385
  {DBGFIELD("WriteCvtPD2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2IY")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2PDYLd")   2, false, false, false, 158, 9,  2, 1,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PDY")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PDZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PDZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtPH2PSYLd")   2, false, false, false, 59, 6,  7, 1,  0, 0}, // #395
  {DBGFIELD("WriteCvtPH2PSY")     2, false, false, false, 646, 9,  6, 1,  0, 0}, // #396
  {DBGFIELD("WriteCvtPH2PSLd")    2, false, false, false, 59, 6,  9, 1,  0, 0}, // #397
  {DBGFIELD("WriteCvtPH2PS")      2, false, false, false, 749, 8, 14, 1,  0, 0}, // #398
  {DBGFIELD("WriteCvtPH2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteCvtPH2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD("WriteCvtPS2PHYSt")   4, false, false, false, 757, 12,  2, 1,  0, 0}, // #401
  {DBGFIELD("WriteCvtPS2PHY")     2, false, false, false, 646, 9,  6, 1,  0, 0}, // #402
  {DBGFIELD("WriteCvtPS2PHSt")    4, false, false, false, 757, 12,  3, 1,  0, 0}, // #403
  {DBGFIELD("WriteCvtPS2PH")      2, false, false, false, 749, 8, 14, 1,  0, 0}, // #404
  {DBGFIELD("WriteCvtPS2PHZSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteCvtPS2PHZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #406
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #407
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #408
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #409
  {DBGFIELD("WritePSADBWY")       1, false, false, false, 474, 8,  5, 1,  0, 0}, // #410
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WritePSADBWZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #412
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 2, false, false, false, 769, 12, 37, 1,  7, 1}, // #413
  {DBGFIELD("WriteFDiv64Y")       1, false, false, false, 781, 10, 10, 1,  0, 0}, // #414
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WriteFDiv64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 2, false, false, false, 238, 12, 31, 1,  7, 1}, // #417
  {DBGFIELD("WriteFDivY")         1, false, false, false, 781, 10, 18, 1,  0, 0}, // #418
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteFDivZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #420
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1,  5, 1}, // #421
  {DBGFIELD("WriteFMAX")          1, false, false, false, 65, 4,  8, 1,  0, 0}, // #422
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1,  7, 1}, // #423
  {DBGFIELD("WriteFMAY")          1, false, false, false, 65, 4,  8, 1,  0, 0}, // #424
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteFMAZ")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #426
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 5, false, false, false, 282, 11, 12, 1,  7, 1}, // #427
  {DBGFIELD("WriteDPPSY")         4, false, false, false, 293, 9, 22, 1,  0, 0}, // #428
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #429
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1, 12, 2}, // #430
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1, 14, 2}, // #431
  {DBGFIELD("WriteFMALd_ReadAfterVecLd") 2, false, false, false, 59, 6,  9, 1,  3, 1}, // #432
  {DBGFIELD("WriteFMA")           1, false, false, false, 65, 4,  8, 1,  0, 0}, // #433
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 2, false, false, false, 59, 6,  9, 1, 16, 2}, // #434
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1,  8, 2}, // #435
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1, 10, 2}, // #436
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 2, false, false, false, 59, 6,  9, 1,  3, 2}, // #437
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 3, false, false, false, 631, 6, 21, 1,  7, 1}, // #438
  {DBGFIELD("WriteFRndY")         2, false, false, false, 637, 4,  2, 1,  0, 0}, // #439
  {DBGFIELD("WriteLoad_WriteVecMaskedGatherWriteback") 1, false, false, false, 37, 3, 38, 2,  0, 0}, // #440
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteFRndZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 23, 1,  7, 1}, // #443
  {DBGFIELD("WriteVecIMulY")      1, false, false, false, 65, 4, 14, 1,  0, 0}, // #444
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #445
  {DBGFIELD("WriteVecIMulZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6,  2, 1,  7, 1}, // #447
  {DBGFIELD("WriteVecALUY")       1, false, false, false, 65, 4,  1, 1,  0, 0}, // #448
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("WriteVecALUZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #450
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 4, false, false, false, 335, 11, 22, 1,  7, 1}, // #451
  {DBGFIELD("WriteFHAddY")        3, false, false, false, 346, 9,  3, 1,  0, 0}, // #452
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #453
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #454
  {DBGFIELD("WriteVecLoadY")      1, false, false, false, 37, 3,  6, 1,  0, 0}, // #455
  {DBGFIELD("WriteFMaskedStore64Y") 2, false, false, false, 791, 10, 13, 1,  0, 0}, // #456
  {DBGFIELD("WriteFMaskedLoadY")  2, false, false, false, 60, 5,  2, 1,  0, 0}, // #457
  {DBGFIELD("WriteFMaskedStore64") 2, false, false, false, 791, 10, 13, 1,  0, 0}, // #458
  {DBGFIELD("WriteFMaskedLoad")   2, false, false, false, 60, 5,  6, 1,  0, 0}, // #459
  {DBGFIELD("WriteFMaskedStore32Y") 2, false, false, false, 791, 10, 13, 1,  0, 0}, // #460
  {DBGFIELD("WriteFMaskedStore32") 2, false, false, false, 791, 10, 13, 1,  0, 0}, // #461
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #462
  {DBGFIELD("WriteFCmp64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #463
  {DBGFIELD("WriteFMoveY")        1, false, false, false, 30, 3,  1, 1,  0, 0}, // #464
  {DBGFIELD("WriteFMoveZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #465
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, false, 464, 10,  2, 1,  0, 0}, // #466
  {DBGFIELD("WriteFShuffleY")     1, false, false, false, 474, 8,  1, 1,  0, 0}, // #467
  {DBGFIELD("WriteFShuffleZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteFShuffleZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #469
  {DBGFIELD("WriteVecStoreY")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #470
  {DBGFIELD("WriteVecMoveY")      1, false, false, false, 30, 3,  1, 1,  0, 0}, // #471
  {DBGFIELD("WriteVecMoveZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #472
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, false, 37, 3,  6, 1,  0, 0}, // #473
  {DBGFIELD("WriteVecStoreNTY")   2, false, false, false, 33, 4,  1, 1,  0, 0}, // #474
  {DBGFIELD("WriteFStoreNTY")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #475
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 3, false, false, false, 531, 10, 18, 1,  7, 1}, // #476
  {DBGFIELD("WriteMPSADY")        2, false, false, false, 523, 8,  8, 1,  0, 0}, // #477
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1,  7, 1}, // #478
  {DBGFIELD("WriteFMul64Y")       1, false, false, false, 65, 4,  8, 1,  0, 0}, // #479
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteFMul64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1,  7, 1}, // #482
  {DBGFIELD("WriteFMulY")         1, false, false, false, 65, 4,  8, 1,  0, 0}, // #483
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #484
  {DBGFIELD("WriteFMulZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #485
  {DBGFIELD("WriteVecALUYLd")     2, false, false, false, 59, 6,  2, 1,  0, 0}, // #486
  {DBGFIELD("WriteVecALUZLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 2, false, false, false, 60, 5,  2, 1,  7, 1}, // #488
  {DBGFIELD("WriteVecLogicY")     1, false, false, false, 30, 3,  1, 1,  0, 0}, // #489
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteVecLogicZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  2, 1,  7, 1}, // #492
  {DBGFIELD("WriteBlendY")        1, false, false, false, 474, 8,  1, 1,  0, 0}, // #493
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 3, false, false, false, 140, 5,  2, 1,  7, 1}, // #494
  {DBGFIELD("WriteVarBlendY")     2, false, false, false, 145, 3, 13, 1,  0, 0}, // #495
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteVarBlendZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 3, false, false, false, 140, 5,  2, 1,  8, 2}, // #498
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, false, 140, 5,  2, 1, 10, 2}, // #499
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 464, 10,  2, 1,  8, 2}, // #500
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  2, 1, 12, 2}, // #501
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1, 10, 2}, // #502
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1, 14, 2}, // #503
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #504
  {DBGFIELD("WriteFVarShuffle256") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #505
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 464, 10,  2, 1,  8, 2}, // #506
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  2, 1, 12, 2}, // #507
  {DBGFIELD("WriteFVarShuffleY")  1, false, false, false, 474, 8,  1, 1,  0, 0}, // #508
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1, 10, 2}, // #509
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1, 14, 2}, // #510
  {DBGFIELD("WriteFVarShuffle")   1, false, false, false, 474, 8,  1, 1,  0, 0}, // #511
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  2, 1,  7, 1}, // #512
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #513
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #514
  {DBGFIELD("WriteFVarShuffleZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #515
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 4, false, false, false, 613, 10,  7, 1,  7, 1}, // #516
  {DBGFIELD("WritePHAddY")        3, false, false, false, 623, 8,  5, 1,  0, 0}, // #517
  {DBGFIELD("WriteVecInsert")     2, false, false, false, 523, 8, 13, 1,  0, 0}, // #518
  {DBGFIELD("WriteVecIMulXLd")    2, false, false, false, 59, 6, 18, 1,  0, 0}, // #519
  {DBGFIELD("WriteVecIMulYLd")    2, false, false, false, 59, 6, 23, 1,  0, 0}, // #520
  {DBGFIELD("WriteVecIMulZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #521
  {DBGFIELD("WriteVecMaskedStore32Y") 2, false, false, false, 791, 10, 13, 1,  0, 0}, // #522
  {DBGFIELD("WriteVecMaskedLoadY") 2, false, false, false, 60, 5,  2, 1,  0, 0}, // #523
  {DBGFIELD("WriteVecMaskedStore32") 2, false, false, false, 791, 10, 13, 1,  0, 0}, // #524
  {DBGFIELD("WriteVecMaskedLoad") 2, false, false, false, 60, 5,  6, 1,  0, 0}, // #525
  {DBGFIELD("WriteVecMaskedStore64Y") 2, false, false, false, 791, 10, 13, 1,  0, 0}, // #526
  {DBGFIELD("WriteVecMaskedStore64") 2, false, false, false, 791, 10, 13, 1,  0, 0}, // #527
  {DBGFIELD("WriteVPMOV256Ld")    2, false, false, false, 464, 10,  7, 1,  0, 0}, // #528
  {DBGFIELD("WriteVPMOV256")      1, false, false, false, 474, 8,  5, 1,  0, 0}, // #529
  {DBGFIELD("WriteVecMOVMSKY")    1, false, false, false, 40, 9, 13, 1,  0, 0}, // #530
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 3, false, false, false, 631, 6, 17, 1,  7, 1}, // #531
  {DBGFIELD("WritePMULLDY")       2, false, false, false, 637, 4,  7, 1,  0, 0}, // #532
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WritePMULLDZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #534
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1, 10, 2}, // #535
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1, 14, 2}, // #536
  {DBGFIELD("WriteVecShiftImmXLd") 2, false, false, false, 59, 6,  6, 1,  0, 0}, // #537
  {DBGFIELD("WriteVecShiftImmYLd") 2, false, false, false, 59, 6,  2, 1,  0, 0}, // #538
  {DBGFIELD("WriteVecShiftImmY")  1, false, false, false, 65, 4,  1, 1,  0, 0}, // #539
  {DBGFIELD("WriteVecShiftImmZLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #540
  {DBGFIELD("WriteVecShiftImmZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #541
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  6, 1,  5, 1}, // #542
  {DBGFIELD("WriteVarVecShift")   1, false, false, false, 65, 4,  1, 1,  0, 0}, // #543
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6,  2, 1,  7, 1}, // #544
  {DBGFIELD("WriteVarVecShiftY")  1, false, false, false, 65, 4,  1, 1,  0, 0}, // #545
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #546
  {DBGFIELD("WriteVarVecShiftZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #547
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  6, 1,  5, 1}, // #548
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  2, 1,  7, 1}, // #549
  {DBGFIELD("WriteVarShuffleY")   1, false, false, false, 474, 8,  1, 1,  0, 0}, // #550
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #551
  {DBGFIELD("WriteVarShuffleZ")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #552
  {DBGFIELD("WriteShuffleZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #553
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6,  2, 1,  7, 1}, // #554
  {DBGFIELD("WriteVecShiftY")     2, false, false, false, 646, 9,  8, 1,  0, 0}, // #555
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteVecShiftZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 3, false, false, false, 655, 14,  7, 1,  7, 1}, // #558
  {DBGFIELD("WriteVecTestY")      2, false, false, false, 313, 12,  5, 1,  0, 0}, // #559
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  7, 1,  5, 1}, // #560
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 2, false, false, false, 69, 11, 18, 1,  7, 1}, // #561
  {DBGFIELD("WriteFRcpY")         1, false, false, false, 40, 9,  8, 1,  0, 0}, // #562
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #563
  {DBGFIELD("WriteFRcpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #564
  {DBGFIELD("WriteFRcpYLd")       2, false, false, false, 69, 11, 18, 1,  0, 0}, // #565
  {DBGFIELD("WriteFRndYLd")       3, false, false, false, 631, 6, 21, 1,  0, 0}, // #566
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  7, 1,  5, 1}, // #567
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 2, false, false, false, 69, 11, 18, 1,  7, 1}, // #568
  {DBGFIELD("WriteFRsqrtY")       1, false, false, false, 40, 9,  8, 1,  0, 0}, // #569
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #570
  {DBGFIELD("WriteFRsqrtZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #571
  {DBGFIELD("WriteFRsqrtYLd")     2, false, false, false, 69, 11, 18, 1,  0, 0}, // #572
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  2, 1,  7, 1}, // #573
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #574
  {DBGFIELD("WriteFSqrt64YLd")    2, false, false, false, 801, 12, 11, 1,  0, 0}, // #575
  {DBGFIELD("WriteFSqrt64Y")      1, false, false, false, 813, 10, 31, 1,  0, 0}, // #576
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 2, false, false, false, 717, 12, 30, 1,  5, 1}, // #577
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 2, false, false, false, 801, 12, 11, 1,  7, 1}, // #578
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #579
  {DBGFIELD("WriteFSqrt64Z")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #580
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 2, false, false, false, 250, 12, 31, 1,  5, 1}, // #581
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 2, false, false, false, 717, 12, 20, 1,  7, 1}, // #582
  {DBGFIELD("WriteFSqrtY")        1, false, false, false, 729, 10, 23, 1,  0, 0}, // #583
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #584
  {DBGFIELD("WriteFSqrtZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #585
  {DBGFIELD("WriteFSqrtYLd")      2, false, false, false, 717, 12, 20, 1,  0, 0}, // #586
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 2, false, false, false, 69, 11,  9, 1,  7, 1}, // #587
  {DBGFIELD("WriteFTestY")        1, false, false, false, 40, 9, 13, 1,  0, 0}, // #588
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  2, 1,  5, 1}, // #589
  {DBGFIELD("WriteFTest")         1, false, false, false, 40, 9, 13, 1,  0, 0}, // #590
  {DBGFIELD("WriteALULd_WriteRMW") 3, false, false, false, 49, 6, 32, 2,  0, 0}, // #591
  {DBGFIELD("WriteXCHG")          3, false, false, false, 280, 2, 13, 1,  0, 0}, // #592
  {DBGFIELD("COPY")               8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #593
  {DBGFIELD("XAM_F")              1, false, false, false, 40, 9, 13, 1,  0, 0}, // #594
  {DBGFIELD("LD_Frr")             1, false, false, false,  1, 2,  1, 1,  0, 0}, // #595
  {DBGFIELD("MOVSX64rr32")        1, false, false, false,  1, 2,  1, 1,  0, 0}, // #596
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 5, false, false, false, 823, 6,  2, 1,  0, 0}, // #597
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 11, false, false, false, 829, 11, 31, 1,  0, 0}, // #598
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 4, false, false, false, 167, 8,  3, 1,  0, 0}, // #599
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 6, false, false, false, 669, 8,  2, 1,  0, 0}, // #600
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #601
  {DBGFIELD("FCOMPP")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #602
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, false, 40, 9, 13, 1,  0, 0}, // #603
  {DBGFIELD("MMX_CVTPI2PSrr")     2, false, false, false, 91, 9,  3, 1,  0, 0}, // #604
  {DBGFIELD("MMX_CVTPI2PSrm")     2, false, false, false, 69, 11,  9, 1,  0, 0}, // #605
  {DBGFIELD("MMX_CVTPS2PIrr_MMX_CVTTPS2PIrr") 2, false, false, false, 749, 8, 14, 1,  0, 0}, // #606
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 2, false, false, false, 55, 4,  3, 1,  0, 0}, // #607
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #608
  {DBGFIELD("XCH_F")              15, false, false, false, 840, 15, 17, 1,  0, 0}, // #609
  {DBGFIELD("RETI16_RETI32_RETI64_IRET_IRET16_IRET32_IRET64") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #610
  {DBGFIELD("MMX_CVTPS2PIrm_MMX_CVTTPS2PIrm") 2, false, false, false, 59, 6,  9, 1,  0, 0}, // #611
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #612
  {DBGFIELD("CVTSI642SDrm")       2, false, false, false, 158, 9,  9, 1,  0, 0}, // #613
  {DBGFIELD("CVTSI642SDrm_Int")   2, false, false, false, 158, 9,  9, 1,  3, 1}, // #614
  {DBGFIELD("CVTSI642SSrr")       3, false, false, false, 346, 9,  3, 1,  0, 0}, // #615
  {DBGFIELD("CVTSI642SSrr_Int")   3, false, false, false, 346, 9,  3, 1,  0, 0}, // #616
  {DBGFIELD("CVTSI642SSrm")       2, false, false, false, 158, 9,  9, 1,  0, 0}, // #617
  {DBGFIELD("CVTSI642SSrm_Int")   2, false, false, false, 158, 9,  9, 1,  3, 1}, // #618
  {DBGFIELD("CVTSS2SI64rr_CVTTSS2SI64rr") 3, false, false, false, 855, 12,  6, 1,  0, 0}, // #619
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 3, false, false, false, 855, 12,  6, 1,  0, 0}, // #620
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 4, false, false, false, 867, 14, 23, 1,  0, 0}, // #621
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 2, false, false, false, 98, 2, 13, 1,  0, 0}, // #622
  {DBGFIELD("LFENCE")             2, false, false, false, 98, 2, 13, 1,  0, 0}, // #623
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #624
  {DBGFIELD("LEAVE_LEAVE64")      3, false, false, false, 881, 4,  6, 1,  0, 0}, // #625
  {DBGFIELD("POP16r")             2, false, false, false, 55, 4,  3, 1,  0, 0}, // #626
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 4, false, false, false, 49, 6,  3, 1,  0, 0}, // #627
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #628
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #629
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #630
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, false,  1, 2,  1, 1,  0, 0}, // #631
  {DBGFIELD("MMX_PADDQrr_MMX_PSUBQrr") 1, false, false, false,  3, 5,  1, 1,  0, 0}, // #632
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #633
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64_MASKMOVDQUX32") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #634
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  2, false, false, false, 33, 4,  1, 1,  0, 0}, // #635
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, false, 30, 3,  1, 1,  0, 0}, // #636
  {DBGFIELD("CLD")                3, false, false, false, 885, 7,  5, 1,  0, 0}, // #637
  {DBGFIELD("LDDQUrm")            1, false, false, false, 37, 3,  3, 1,  0, 0}, // #638
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #639
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 4, false, false, false, 49, 6,  3, 1,  0, 0}, // #640
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 8, false, false, false, 892, 11,  7, 1,  0, 0}, // #641
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, false, 623, 8,  5, 1,  0, 0}, // #642
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #643
  {DBGFIELD("MMX_PADDQrm_MMX_PSUBQrm") 2, false, false, false, 498, 7,  3, 1,  3, 1}, // #644
  {DBGFIELD("MOVDQUrm")           1, false, false, false, 37, 3,  3, 1,  0, 0}, // #645
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, false, 37, 3,  3, 1,  0, 0}, // #646
  {DBGFIELD("PADDQrm_PSUBQrm")    2, false, false, false, 60, 5,  6, 1,  5, 1}, // #647
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #648
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   2, false, false, false, 903, 4, 13, 1,  0, 0}, // #649
  {DBGFIELD("LD_F80m")            1, false, false, false, 37, 3,  6, 1,  0, 0}, // #650
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, false, 613, 10,  9, 1,  5, 1}, // #651
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 2, false, false, false, 313, 12,  5, 1,  0, 0}, // #652
  {DBGFIELD("FLDCW16m")           3, false, false, false, 907, 11,  6, 1,  0, 0}, // #653
  {DBGFIELD("ST_FP80m")           2, false, false, false, 33, 4,  1, 1,  0, 0}, // #654
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, false, 515, 8,  5, 1,  0, 0}, // #655
  {DBGFIELD("CMPXCHG8rm")         6, false, false, false, 12, 8,  2, 1,  0, 0}, // #656
  {DBGFIELD("INTO")               1, false, false, false,  1, 2,  4, 1,  0, 0}, // #657
  {DBGFIELD("XLAT")               1, false, false, false, 37, 3, 14, 1,  0, 0}, // #658
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 4, false, false, false, 708, 9,  3, 1,  0, 0}, // #659
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #660
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 6, false, false, false, 688, 11, 18, 1,  0, 0}, // #661
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 4, false, false, false, 699, 9,  9, 1,  0, 0}, // #662
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 3, false, false, false, 302, 11,  8, 1,  0, 0}, // #663
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, false, 505, 10,  2, 1,  3, 1}, // #664
  {DBGFIELD("AAD8i8")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #665
  {DBGFIELD("LOOPE")              11, false, false, false, 918, 4, 18, 1,  0, 0}, // #666
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, false, 33, 4,  1, 1,  0, 0}, // #667
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 4, false, false, false, 708, 9,  3, 1,  0, 0}, // #668
  {DBGFIELD("FNSTCW16m")          3, false, false, false, 922, 10, 13, 1,  0, 0}, // #669
  {DBGFIELD("POPA16_POPA32")      1, false, false, false, 37, 3, 14, 1,  0, 0}, // #670
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #671
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 6, false, false, false, 688, 11, 18, 1,  0, 0}, // #672
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 4, false, false, false, 699, 9,  9, 1,  0, 0}, // #673
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #674
  {DBGFIELD("CMPXCHG8rr")         5, false, false, false, 175, 4, 14, 1,  0, 0}, // #675
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80") 1, false, false, false, 40, 9, 13, 1,  0, 0}, // #676
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #677
  {DBGFIELD("AAA_AAS")            1, false, false, false,  1, 2,  4, 1,  0, 0}, // #678
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 6, false, false, false, 12, 8,  2, 1,  0, 0}, // #679
  {DBGFIELD("LOOPNE")             11, false, false, false, 918, 4, 18, 1,  0, 0}, // #680
  {DBGFIELD("PAUSE")              4, false, false, false, 932, 7,  8, 1,  0, 0}, // #681
  {DBGFIELD("CMPXCHG8B")          14, false, false, false, 939, 10, 19, 1,  0, 0}, // #682
  {DBGFIELD("DAA")                1, false, false, false,  1, 2,  4, 1,  0, 0}, // #683
  {DBGFIELD("LOOP")               7, false, false, false, 949, 9,  6, 1,  0, 0}, // #684
  {DBGFIELD("DAS")                1, false, false, false,  1, 2,  4, 1,  0, 0}, // #685
  {DBGFIELD("AAM8i8")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #686
  {DBGFIELD("STD")                6, false, false, false, 958, 7,  3, 1,  0, 0}, // #687
  {DBGFIELD("CMPXCHG16B")         19, false, false, false, 965, 15, 36, 1,  0, 0}, // #688
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, false,  1, 2,  4, 1,  0, 0}, // #689
  {DBGFIELD("FNCLEX_FXTRACT")     4, false, false, false, 300, 2,  8, 1,  0, 0}, // #690
  {DBGFIELD("POPF32_POPF64")      1, false, false, false, 37, 3, 14, 1,  0, 0}, // #691
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #692
  {DBGFIELD("RDTSC_RDTSCP")       22, false, false, false, 980, 8, 40, 1,  0, 0}, // #693
  {DBGFIELD("ENTER")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #694
  {DBGFIELD("POPF16")             1, false, false, false, 37, 3, 14, 1,  0, 0}, // #695
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #696
  {DBGFIELD("FRNDINT")            1, false, false, false,  1, 2,  4, 1,  0, 0}, // #697
  {DBGFIELD("MWAITrr_RDPMC")      10, false, false, false, 988, 11, 12, 1,  0, 0}, // #698
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, false,  1, 2,  4, 1,  0, 0}, // #699
  {DBGFIELD("FPREM")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #700
  {DBGFIELD("INSB_INSL_INSW")     8, false, false, false, 999, 15, 12, 1,  0, 0}, // #701
  {DBGFIELD("FNINIT")             15, false, false, false, 1014, 8, 41, 1,  0, 0}, // #702
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 23, false, false, false, 1022, 13, 42, 1,  0, 0}, // #703
  {DBGFIELD("FPREM1")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #704
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #705
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 23, false, false, false, 1022, 13, 42, 1,  0, 0}, // #706
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, false,  1, 2,  4, 1,  0, 0}, // #707
  {DBGFIELD("FSCALE")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #708
  {DBGFIELD("RDMSR")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #709
  {DBGFIELD("RET_RET16_RET32_RET64_LRET16_LRET32_LRET64_LRETI16_LRETI32_LRETI64") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #710
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 23, false, false, false, 1035, 13, 42, 1,  0, 0}, // #711
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 23, false, false, false, 1035, 13, 42, 1,  0, 0}, // #712
  {DBGFIELD("F2XM1")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #713
  {DBGFIELD("CPUID")              8, false, false, false, 1048, 11, 31, 1,  0, 0}, // #714
  {DBGFIELD("INT")                1, false, false, false,  1, 2,  4, 1,  0, 0}, // #715
  {DBGFIELD("INT3")               1, false, false, false,  1, 2,  4, 1,  0, 0}, // #716
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, false,  1, 2,  4, 1,  0, 0}, // #717
  {DBGFIELD("FXRSTOR_FXRSTOR64")  90, false, false, false, 1059, 15, 43, 1,  0, 0}, // #718
  {DBGFIELD("FYL2X")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #719
  {DBGFIELD("FYL2XP1")            1, false, false, false,  1, 2,  4, 1,  0, 0}, // #720
  {DBGFIELD("FPTAN")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #721
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, false,  1, 2,  4, 1,  0, 0}, // #722
  {DBGFIELD("FPATAN")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #723
  {DBGFIELD("WRMSR")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #724
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #725
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, false, 474, 8,  1, 1,  0, 0}, // #726
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 2, false, false, false, 330, 5, 13, 1,  0, 0}, // #727
  {DBGFIELD("FNOP")               1, false, false, false,  3, 5,  1, 1,  0, 0}, // #728
  {DBGFIELD("RET64")              3, false, false, false, 1074, 9,  6, 1,  0, 0}, // #729
  {DBGFIELD("CDQ_CQO")            1, false, false, false,  8, 4,  1, 1,  0, 0}, // #730
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, false,  3, 5,  1, 1,  0, 0}, // #731
  {DBGFIELD("MMX_PADDQrr")        1, false, false, false,  3, 5,  1, 1,  0, 0}, // #732
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, false, 474, 8,  1, 1,  0, 0}, // #733
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 3, false, false, false, 881, 4,  6, 1,  0, 0}, // #734
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int_VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 1, false, false, false, 40, 9, 13, 1,  0, 0}, // #735
  {DBGFIELD("CWD")                2, false, false, false, 903, 4, 13, 1,  0, 0}, // #736
  {DBGFIELD("FNSTSW16r")          2, false, false, false, 1083, 9,  5, 1,  0, 0}, // #737
  {DBGFIELD("MMX_MOVDQ2Qrr")      2, false, false, false, 330, 5, 13, 1,  0, 0}, // #738
  {DBGFIELD("PUSHFS64")           1, false, false, false,  1, 2,  4, 1,  0, 0}, // #739
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 2, false, false, false, 313, 12,  5, 1,  0, 0}, // #740
  {DBGFIELD("RCL16r1_RCL32r1_RCL64r1_RCL8r1_RCR16r1_RCR32r1_RCR64r1_RCR8r1") 3, false, false, false, 1092, 4,  5, 1,  0, 0}, // #741
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, false, 40, 9, 13, 1,  0, 0}, // #742
  {DBGFIELD("MOV64sr")            1, false, false, false,  1, 2,  1, 1,  0, 0}, // #743
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVSX32rm16_MOVSX32rm32_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #744
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 10, false, false, false, 1096, 9, 10, 1,  0, 0}, // #745
  {DBGFIELD("RCL16ri_RCL32ri_RCL64ri_RCL8ri_RCR16ri_RCR32ri_RCR64ri_RCR8ri") 3, false, false, false, 1092, 4,  5, 1,  0, 0}, // #746
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 3, false, false, false, 1105, 5, 13, 1,  0, 0}, // #747
  {DBGFIELD("CLI")                1, false, false, false,  1, 2,  4, 1,  0, 0}, // #748
  {DBGFIELD("PUSHGS64")           1, false, false, false,  1, 2,  4, 1,  0, 0}, // #749
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 3, false, false, false, 302, 11,  8, 1,  0, 0}, // #750
  {DBGFIELD("CALL64pcrel32")      4, false, false, false, 1110, 7,  5, 1,  0, 0}, // #751
  {DBGFIELD("CALL64r_RVMARKER_CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 4, false, false, false, 1117, 10,  5, 1,  0, 0}, // #752
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 3, false, false, false, 302, 11, 13, 1,  0, 0}, // #753
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 3, false, false, false, 1105, 5, 13, 1,  0, 0}, // #754
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 3, false, false, false, 302, 11, 13, 1,  0, 0}, // #755
  {DBGFIELD("PUSHF16_PUSHF64")    6, false, false, false, 1127, 5, 14, 1,  0, 0}, // #756
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 2, false, false, false, 1132, 7, 13, 1,  0, 0}, // #757
  {DBGFIELD("MMX_MOVD64from64rm") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #758
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, false, 37, 3,  3, 1,  0, 0}, // #759
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #760
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #761
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #762
  {DBGFIELD("MOV16sm")            1, false, false, false,  1, 2,  1, 1,  0, 0}, // #763
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 2, false, false, false, 498, 7,  3, 1,  0, 0}, // #764
  {DBGFIELD("MMX_PALIGNRrmi")     2, false, false, false, 464, 10,  3, 1,  3, 1}, // #765
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 2, false, false, false, 498, 7,  3, 1,  3, 1}, // #766
  {DBGFIELD("LODSL_LODSQ")        1, false, false, false,  1, 2,  4, 1,  0, 0}, // #767
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, false, 37, 3,  6, 1,  0, 0}, // #768
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 1, false, false, false, 37, 3,  6, 1,  0, 0}, // #769
  {DBGFIELD("VINSERTF128rm")      2, false, false, false, 60, 5,  6, 1,  0, 0}, // #770
  {DBGFIELD("MMX_PADDQrm")        2, false, false, false, 498, 7,  3, 1,  3, 1}, // #771
  {DBGFIELD("VERRm_VERWm")        1, false, false, false,  1, 2,  4, 1,  0, 0}, // #772
  {DBGFIELD("FARJMP64m")          2, false, false, false, 1139, 9,  3, 1,  0, 0}, // #773
  {DBGFIELD("FNSTSWm")            3, false, false, false, 1148, 11,  5, 1,  0, 0}, // #774
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 4, false, false, false, 1159, 11,  3, 1,  0, 0}, // #775
  {DBGFIELD("CALL64m_RVMARKER_CALL64m_CALL64m_NT") 5, false, false, false, 1170, 11,  6, 1,  0, 0}, // #776
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 5, false, false, false, 1170, 11,  6, 1,  0, 0}, // #777
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int_VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 2, false, false, false, 69, 11,  6, 1,  3, 1}, // #778
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #779
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 5, false, false, false, 1181, 8,  6, 1,  0, 0}, // #780
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 5, false, false, false, 1189, 6,  6, 1,  0, 0}, // #781
  {DBGFIELD("FARCALL64m")         5, false, false, false, 1170, 11,  6, 1,  0, 0}, // #782
  {DBGFIELD("CVTSD2SI64rm_CVTSD2SI64rm_Int_CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 3, false, false, false, 1195, 11, 18, 1,  0, 0}, // #783
  {DBGFIELD("CVTSS2SIrm_CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 3, false, false, false, 1195, 11, 18, 1,  0, 0}, // #784
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, false, 37, 3,  6, 1,  0, 0}, // #785
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 6, false, false, false, 669, 8,  2, 1,  0, 0}, // #786
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 6, false, false, false, 12, 8,  2, 1,  1, 2}, // #787
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #788
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #789
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 3, false, false, false, 531, 10, 18, 1,  0, 0}, // #790
  {DBGFIELD("MUL_F32m_MUL_F64m")  2, false, false, false, 69, 11, 18, 1,  0, 0}, // #791
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 3, false, false, false, 531, 10, 22, 1,  0, 0}, // #792
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 3, false, false, false, 655, 14, 10, 1,  0, 0}, // #793
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 2, false, false, false, 69, 11, 44, 1,  0, 0}, // #794
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 3, false, false, false, 655, 14, 11, 1,  0, 0}, // #795
  {DBGFIELD("VZEROALL")           16, false, false, false, 1206, 2, 19, 1,  0, 0}, // #796
  {DBGFIELD("VZEROUPPER")         4, false, false, false,  0, 0,  0, 1,  0, 0}, // #797
  {DBGFIELD("CLC")                1, false, false, false,  0, 0,  1, 1,  0, 0}, // #798
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #799
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #800
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #801
  {DBGFIELD("PXORrr_VPXORrr")     8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #802
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #803
  {DBGFIELD("PSUBQrr")            8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #804
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #805
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #806
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #807
  {DBGFIELD("SETCCr")             8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #808
  {DBGFIELD("SETCCm")             8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #809
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 2, false, false, false, 464, 10,  3, 1,  0, 0}, // #810
  {DBGFIELD("RETI16_RETI32_RETI64") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #811
  {DBGFIELD("LRETI16_LRETI32_LRETI64") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #812
  {DBGFIELD("RDPMC")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #813
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #814
  {DBGFIELD("FBLDm")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #815
  {DBGFIELD("FFREE_FFREEP")       1, false, false, false,  1, 2,  4, 1,  0, 0}, // #816
  {DBGFIELD("FSAVEm")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #817
  {DBGFIELD("FRSTORm")            1, false, false, false,  1, 2,  4, 1,  0, 0}, // #818
  {DBGFIELD("FXTRACT")            1, false, false, false,  1, 2,  4, 1,  0, 0}, // #819
  {DBGFIELD("MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #820
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #821
  {DBGFIELD("VBROADCASTF128")     1, false, false, false, 37, 3,  6, 1,  0, 0}, // #822
  {DBGFIELD("VBROADCASTI128")     1, false, false, false, 37, 3,  6, 1,  0, 0}, // #823
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, false, 37, 3,  6, 1,  0, 0}, // #824
  {DBGFIELD("FBSTPm")             2, false, false, false, 33, 4,  1, 1,  0, 0}, // #825
  {DBGFIELD("VMPTRSTm")           2, false, false, false, 33, 4,  1, 1,  0, 0}, // #826
  {DBGFIELD("ST_FP32m_ST_FP64m")  2, false, false, false, 33, 4,  1, 1,  0, 0}, // #827
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #828
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #829
  {DBGFIELD("MMX_MOVQ2DQrr")      2, false, false, false, 523, 8, 13, 1,  0, 0}, // #830
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, false, 1208, 7,  1, 1,  0, 0}, // #831
  {DBGFIELD("FINCSTP")            1, false, false, false,  3, 5,  1, 1,  0, 0}, // #832
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, false, 154, 4,  1, 1,  0, 0}, // #833
  {DBGFIELD("VPBLENDDYrri")       1, false, false, false, 30, 3,  1, 1,  0, 0}, // #834
  {DBGFIELD("VPBLENDDrri")        1, false, false, false, 30, 3,  1, 1,  0, 0}, // #835
  {DBGFIELD("CMC_STC")            1, false, false, false,  1, 2,  1, 1,  0, 0}, // #836
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #837
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 2, false, false, false, 59, 6,  9, 1,  0, 0}, // #838
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 2, false, false, false, 59, 6,  6, 1,  5, 1}, // #839
  {DBGFIELD("CVTSS2SDrm")         2, false, false, false, 59, 6,  7, 1,  0, 0}, // #840
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 2, false, false, false, 59, 6,  7, 1,  0, 0}, // #841
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 2, false, false, false, 59, 6,  2, 1,  7, 1}, // #842
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #843
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 2, false, false, false, 464, 10,  3, 1,  0, 0}, // #844
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 2, false, false, false, 464, 10,  2, 1,  0, 0}, // #845
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 2, false, false, false, 1139, 9,  3, 1,  0, 0}, // #846
  {DBGFIELD("ANDN32rm_ANDN64rm")  2, false, false, false, 148, 6,  3, 1,  0, 0}, // #847
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 2, false, false, false, 148, 6,  3, 1,  0, 0}, // #848
  {DBGFIELD("VINSERTI128rm")      2, false, false, false, 60, 5,  6, 1,  0, 0}, // #849
  {DBGFIELD("VPBLENDDrmi")        2, false, false, false, 60, 5,  6, 1,  0, 0}, // #850
  {DBGFIELD("VPBLENDDYrmi")       2, false, false, false, 60, 5,  2, 1,  0, 0}, // #851
  {DBGFIELD("POP32r_POP64r")      2, false, false, false, 55, 4,  3, 1,  0, 0}, // #852
  {DBGFIELD("SFENCE")             2, false, false, false, 23, 3, 13, 1,  0, 0}, // #853
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 3, false, false, false, 1215, 7, 13, 1,  0, 0}, // #854
  {DBGFIELD("MOVBE16mr")          3, false, false, false, 1215, 7, 13, 1,  0, 0}, // #855
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 3, false, false, false, 1105, 5, 13, 1,  0, 0}, // #856
  {DBGFIELD("MFENCE")             3, false, false, false, 88, 3,  5, 1,  0, 0}, // #857
  {DBGFIELD("XGETBV")             2, false, false, false, 98, 2, 13, 1,  0, 0}, // #858
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 2, false, false, false, 749, 8, 14, 1,  0, 0}, // #859
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 2, false, false, false, 749, 8, 14, 1,  0, 0}, // #860
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm_MMX_PACKUSWBrm") 3, false, false, false, 531, 10,  6, 1,  0, 0}, // #861
  {DBGFIELD("LRET64_RET32")       2, false, false, false, 20, 6,  3, 1,  0, 0}, // #862
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 2, false, false, false, 1222, 4, 13, 1,  0, 0}, // #863
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #864
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, false, 65, 4,  8, 1,  0, 0}, // #865
  {DBGFIELD("VCVTDQ2PSYrr")       1, false, false, false, 65, 4,  8, 1,  0, 0}, // #866
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #867
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 2, false, false, false, 59, 6,  7, 1,  0, 0}, // #868
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, false, 59, 6, 18, 1,  0, 0}, // #869
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 2, false, false, false, 59, 6, 18, 1,  0, 0}, // #870
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #871
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr_MMX_PACKUSWBrr") 3, false, false, false, 1226, 8,  5, 1,  0, 0}, // #872
  {DBGFIELD("CLDEMOTE")           3, false, false, false, 885, 7,  5, 1,  0, 0}, // #873
  {DBGFIELD("CVTSD2SI64rr_CVTSD2SIrr_CVTTSD2SI64rr_CVTTSD2SIrr_VCVTSD2SI64rr_VCVTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, false, 1234, 9,  3, 1,  0, 0}, // #874
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 2, false, false, false, 1234, 9,  3, 1,  0, 0}, // #875
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, false, 1234, 9,  3, 1,  0, 0}, // #876
  {DBGFIELD("CVTSS2SIrr_CVTTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 3, false, false, false, 855, 12,  6, 1,  0, 0}, // #877
  {DBGFIELD("VCVTPS2PDYrr")       2, false, false, false, 646, 9,  6, 1,  0, 0}, // #878
  {DBGFIELD("MMX_CVTPI2PDrr")     2, false, false, false, 313, 12, 14, 1,  0, 0}, // #879
  {DBGFIELD("MMX_CVTPD2PIrr_MMX_CVTTPD2PIrr") 2, false, false, false, 749, 8, 14, 1,  0, 0}, // #880
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 2, false, false, false, 313, 12, 14, 1,  0, 0}, // #881
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 2, false, false, false, 749, 8, 14, 1,  0, 0}, // #882
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 2, false, false, false, 749, 8, 14, 1,  0, 0}, // #883
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 2, false, false, false, 749, 8, 14, 1,  0, 0}, // #884
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, false, 749, 8, 14, 1,  0, 0}, // #885
  {DBGFIELD("CVTSI2SSrr")         2, false, false, false, 749, 8, 14, 1,  0, 0}, // #886
  {DBGFIELD("CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 2, false, false, false, 749, 8, 14, 1,  0, 0}, // #887
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, false, 749, 8, 14, 1,  0, 0}, // #888
  {DBGFIELD("VCVTSD2SI64rm_VCVTSD2SI64rm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 3, false, false, false, 1195, 11, 18, 1,  0, 0}, // #889
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int") 3, false, false, false, 1195, 11, 18, 1,  0, 0}, // #890
  {DBGFIELD("VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, false, 1195, 11, 18, 1,  0, 0}, // #891
  {DBGFIELD("VCVTPS2PDYrm")       2, false, false, false, 59, 6, 18, 1,  0, 0}, // #892
  {DBGFIELD("CVTPD2PSrm")         3, false, false, false, 1243, 11, 18, 1,  0, 0}, // #893
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIrm_MMX_CVTTPD2PIrm") 3, false, false, false, 1243, 11, 18, 1,  0, 0}, // #894
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 3, false, false, false, 655, 14, 18, 1,  0, 0}, // #895
  {DBGFIELD("MMX_CVTPI2PDrm")     3, false, false, false, 655, 14,  7, 1,  0, 0}, // #896
  {DBGFIELD("CVTSD2SSrm")         3, false, false, false, 1243, 11,  7, 1,  0, 0}, // #897
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_VCVTSD2SSrm_Int") 3, false, false, false, 1243, 11,  7, 1,  0, 0}, // #898
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 2, false, false, false, 464, 10,  2, 1,  0, 0}, // #899
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 4, false, false, false, 1254, 11,  8, 1,  0, 0}, // #900
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 5, false, false, false, 1265, 13,  9, 1,  0, 0}, // #901
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, false, 40, 9,  8, 1,  0, 0}, // #902
  {DBGFIELD("VPCMPGTQYrm")        2, false, false, false, 464, 10,  7, 1,  0, 0}, // #903
  {DBGFIELD("VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, false, 346, 9,  3, 1,  0, 0}, // #904
  {DBGFIELD("STR16r_STR32r_STR64r") 3, false, false, false, 1278, 11, 14, 1,  0, 0}, // #905
  {DBGFIELD("XSETBV")             5, false, false, false, 1289, 4, 14, 1,  0, 0}, // #906
  {DBGFIELD("VCVTDQ2PDYrr")       2, false, false, false, 313, 12,  6, 1,  0, 0}, // #907
  {DBGFIELD("VCVTPD2PSYrr")       2, false, false, false, 646, 9,  6, 1,  0, 0}, // #908
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 2, false, false, false, 646, 9,  6, 1,  0, 0}, // #909
  {DBGFIELD("VCVTDQ2PDYrm")       3, false, false, false, 655, 14, 22, 1,  0, 0}, // #910
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 10, false, false, false, 1293, 11, 21, 1,  0, 0}, // #911
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 7, false, false, false, 1304, 9, 18, 1,  0, 0}, // #912
  {DBGFIELD("RCL8rCL")            9, false, false, false, 1313, 9, 18, 1,  0, 0}, // #913
  {DBGFIELD("RDTSC")              8, false, false, false, 1048, 11, 31, 1,  0, 0}, // #914
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 31, false, false, false, 1322, 13, 45, 1,  0, 0}, // #915
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, false, 40, 9, 12, 1,  0, 0}, // #916
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 2, false, false, false, 69, 11, 46, 1,  0, 0}, // #917
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 3, false, false, false, 655, 14, 47, 1,  0, 0}, // #918
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, false, 40, 9, 21, 1,  0, 0}, // #919
  {DBGFIELD("XSAVE64")            39, false, false, false, 1335, 11, 48, 1,  0, 0}, // #920
  {DBGFIELD("XSAVE")              40, false, false, false, 1346, 11, 40, 1,  0, 0}, // #921
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 44, false, false, false, 1357, 11, 49, 1,  0, 0}, // #922
  {DBGFIELD("VMCLEARm")           18, false, false, false, 1368, 17, 50, 1,  0, 0}, // #923
  {DBGFIELD("FLDENVm")            64, false, false, false, 1385, 11, 51, 1,  0, 0}, // #924
  {DBGFIELD("FXRSTOR64")          88, false, false, false, 1396, 15, 43, 1,  0, 0}, // #925
  {DBGFIELD("FSTENVm")            100, false, false, false, 1411, 17, 52, 1,  0, 0}, // #926
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm") 5, false, false, false, 1428, 14, 31, 1,  0, 0}, // #927
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 5, false, false, false, 1442, 14, 12, 1,  0, 0}, // #928
  {DBGFIELD("VGATHERDPSrm_VPGATHERDDrm") 5, false, false, false, 1442, 14, 12, 1,  0, 0}, // #929
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 5, false, false, false, 1456, 14, 44, 1,  0, 0}, // #930
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 5, false, false, false, 1428, 14, 31, 1,  0, 0}, // #931
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm_VGATHERQPSYrm_VPGATHERQDYrm") 5, false, false, false, 1442, 14, 12, 1,  0, 0}, // #932
  {DBGFIELD("VGATHERQPSrm_VPGATHERQDrm") 5, false, false, false, 1428, 14, 31, 1,  0, 0}, // #933
  {DBGFIELD("VPXORYrr")           8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #934
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #935
  {DBGFIELD("VPCMPGTQYrr")        8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #936
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, false,  8, 4,  1, 1,  0, 0}, // #937
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 2, false, false, false, 903, 4, 13, 1,  0, 0}, // #938
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 2, false, false, false, 464, 10,  2, 1,  0, 0}, // #939
  {DBGFIELD("LRET64")             3, false, false, false, 1074, 9,  6, 1,  0, 0}, // #940
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 2, false, false, false, 59, 6,  7, 1,  0, 0}, // #941
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 3, false, false, false, 1243, 11, 18, 1,  0, 0}, // #942
  {DBGFIELD("POPF64")             1, false, false, false, 37, 3, 14, 1,  0, 0}, // #943
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 5, false, false, false, 1442, 14, 12, 1,  0, 0}, // #944
  {DBGFIELD("PCMPEQQrr")          1, false, false, false, 65, 4,  1, 1,  0, 0}, // #945
  {DBGFIELD("PCMPEQQrm")          2, false, false, false, 59, 6,  6, 1,  5, 1}, // #946
  {DBGFIELD("MOV16rm")            1, false, false, false, 37, 3, 14, 1,  0, 0}, // #947
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #948
  {DBGFIELD("POP16rmm")           4, false, false, false, 49, 6,  3, 1,  0, 0}, // #949
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 4, false, false, false, 49, 6,  3, 1,  0, 0}, // #950
  {DBGFIELD("PUSHF16")            6, false, false, false, 1127, 5, 14, 1,  0, 0}, // #951
  {DBGFIELD("LAHF")               1, false, false, false,  8, 4,  1, 1,  0, 0}, // #952
  {DBGFIELD("ADD16mi_ADD16mi8_ADD32mi_ADD32mi8_ADD64mi32_ADD64mi8_ADD8mi_ADD8mi8_SUB16mi_SUB16mi8_SUB32mi_SUB32mi8_SUB64mi32_SUB64mi8_SUB8mi_SUB8mi8") 3, false, false, false, 49, 6,  6, 1,  0, 0}, // #953
  {DBGFIELD("ADD16mr_ADD32mr_ADD64mr_ADD8mr_SUB16mr_SUB32mr_SUB64mr_SUB8mr") 3, false, false, false, 49, 6,  6, 1,  1, 1}, // #954
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 6, false, false, false, 12, 8,  2, 1,  0, 0}, // #955
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 3, false, false, false, 49, 6,  6, 1,  0, 0}, // #956
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 4, false, false, false, 1117, 10,  5, 1,  0, 0}, // #957
  {DBGFIELD("RET16_LRET16_LRET32") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #958
  {DBGFIELD("IRET16_IRET32_IRET64") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #959
  {DBGFIELD("AND16mi_AND16mi8_AND32mi_AND32mi8_AND64mi32_AND64mi8_AND8mi_AND8mi8_OR16mi_OR16mi8_OR32mi_OR32mi8_OR32mi8Locked_OR64mi32_OR64mi8_OR8mi_OR8mi8_XOR16mi_XOR16mi8_XOR32mi_XOR32mi8_XOR64mi32_XOR64mi8_XOR8mi_XOR8mi8") 3, false, false, false, 49, 6,  6, 1,  0, 0}, // #960
  {DBGFIELD("AND16mr_AND32mr_AND64mr_AND8mr_OR16mr_OR32mr_OR64mr_OR8mr_XOR16mr_XOR32mr_XOR64mr_XOR8mr") 3, false, false, false, 49, 6,  6, 1,  1, 1}, // #961
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 4, false, false, false, 699, 9,  9, 1,  0, 0}, // #962
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 4, false, false, false, 708, 9,  3, 1,  0, 0}, // #963
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 6, false, false, false, 688, 11, 18, 1,  0, 0}, // #964
  {DBGFIELD("MOVSLDUPrm")         1, false, false, false, 37, 3,  3, 1,  0, 0}, // #965
  {DBGFIELD("MOVSLDUPrr")         1, false, false, false, 474, 8,  1, 1,  0, 0}, // #966
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 3, false, false, false, 280, 2, 13, 1,  0, 0}, // #967
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, false, 40, 9,  1, 1,  0, 0}, // #968
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #969
  {DBGFIELD("VPBLENDWYrri")       1, false, false, false, 474, 8,  1, 1,  0, 0}, // #970
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #971
  {DBGFIELD("VPBLENDWYrmi")       2, false, false, false, 464, 10,  2, 1,  7, 1}, // #972
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #973
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64_MASKMOVDQUX32") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #974
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64_VMASKMOVDQUX32") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #975
  {DBGFIELD("VPMASKMOVDYrm")      2, false, false, false, 60, 5,  2, 1,  0, 0}, // #976
  {DBGFIELD("VPMASKMOVDrm")       2, false, false, false, 60, 5,  6, 1,  0, 0}, // #977
  {DBGFIELD("VPMASKMOVDYmr")      2, false, false, false, 791, 10, 13, 1,  0, 0}, // #978
  {DBGFIELD("VPMASKMOVDmr")       2, false, false, false, 791, 10, 13, 1,  0, 0}, // #979
  {DBGFIELD("VPMASKMOVQYmr")      2, false, false, false, 791, 10, 13, 1,  0, 0}, // #980
  {DBGFIELD("VPMASKMOVQmr")       2, false, false, false, 791, 10, 13, 1,  0, 0}, // #981
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 2, false, false, false, 464, 10,  6, 1,  0, 0}, // #982
  {DBGFIELD("VPGATHERDDYrm")      5, false, false, false, 1456, 14, 44, 1,  0, 0}, // #983
  {DBGFIELD("VPGATHERDDrm")       5, false, false, false, 1442, 14, 12, 1,  0, 0}, // #984
  {DBGFIELD("VPGATHERDQYrm")      5, false, false, false, 1442, 14, 12, 1,  0, 0}, // #985
  {DBGFIELD("VPGATHERDQrm")       5, false, false, false, 1428, 14, 31, 1,  0, 0}, // #986
  {DBGFIELD("VPGATHERQDYrm")      5, false, false, false, 1442, 14, 12, 1,  0, 0}, // #987
  {DBGFIELD("VPGATHERQDrm")       5, false, false, false, 1428, 14, 31, 1,  0, 0}, // #988
  {DBGFIELD("VPGATHERQQYrm")      5, false, false, false, 1442, 14, 12, 1,  0, 0}, // #989
  {DBGFIELD("VPGATHERQQrm")       5, false, false, false, 1428, 14, 31, 1,  0, 0}, // #990
  {DBGFIELD("PSLLDQri_PSRLDQri_VPSLLDQri_VPSRLDQri") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #991
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #992
  {DBGFIELD("VPERM2F128rr")       1, false, false, false, 474, 8,  5, 1,  0, 0}, // #993
  {DBGFIELD("VPERM2F128rm")       2, false, false, false, 464, 10,  7, 1,  7, 1}, // #994
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, false, 474, 8,  5, 1,  0, 0}, // #995
  {DBGFIELD("VEXTRACTF128mr")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #996
  {DBGFIELD("VINSERTF128rr")      1, false, false, false, 474, 8,  5, 1,  0, 0}, // #997
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #998
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #999
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 3, false, false, false, 855, 12,  6, 1,  0, 0}, // #1000
  {DBGFIELD("VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, false, 1195, 11, 18, 1,  0, 0}, // #1001
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1002
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1003
  {DBGFIELD("SHA256MSG2rm")       2, false, false, false, 59, 6, 18, 1,  5, 1}, // #1004
  {DBGFIELD("SHA256MSG2rr")       1, false, false, false, 65, 4, 14, 1,  0, 0}, // #1005
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, false, 65, 4, 14, 1,  0, 0}, // #1006
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 2, false, false, false, 59, 6, 18, 1,  5, 1}, // #1007
  {DBGFIELD("SHA1MSG2rr")         1, false, false, false, 65, 4, 14, 1,  0, 0}, // #1008
  {DBGFIELD("SHA1MSG2rm")         2, false, false, false, 59, 6, 18, 1,  5, 1}, // #1009
  {DBGFIELD("SHA1NEXTErr")        1, false, false, false, 65, 4, 14, 1,  0, 0}, // #1010
  {DBGFIELD("SHA1NEXTErm")        2, false, false, false, 59, 6, 18, 1,  5, 1}, // #1011
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, false, 65, 4, 14, 1,  0, 0}, // #1012
  {DBGFIELD("SHA1RNDS4rmi")       2, false, false, false, 59, 6, 18, 1,  5, 1}, // #1013
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, false, 65, 4, 14, 1,  0, 0}, // #1014
  {DBGFIELD("SHA256RNDS2rm")      2, false, false, false, 59, 6, 18, 1,  5, 1}, // #1015
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 3, false, false, false, 280, 2, 13, 1,  0, 0}, // #1016
  {DBGFIELD("BT16mi8_BT32mi8_BT64mi8") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #1017
  {DBGFIELD("BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 1, false, false, false,  8, 4,  1, 1,  0, 0}, // #1018
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, false, 65, 4,  8, 1,  0, 0}, // #1019
  {DBGFIELD("MOV8rm_MOV8rm_NOREX") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1020
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVZX16rm16") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1021
  {DBGFIELD("MOVBE16rm")          2, false, false, false, 148, 6,  3, 1,  0, 0}, // #1022
  {DBGFIELD("ADD8i8_ADD16i16_ADD32i32_ADD64i32_AND8i8_AND16i16_AND32i32_AND64i32_OR8i8_OR16i16_OR32i32_OR64i32_SUB8i8_SUB16i16_SUB32i32_SUB64i32_XOR8i8_XOR16i16_XOR32i32_XOR64i32") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1023
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32_MOVZX16rr16") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1024
  {DBGFIELD("MOV32ri_MOV32ri_alt_MOV64ri32") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1025
  {DBGFIELD("ADC8mr_SBB8mr")      6, false, false, false, 12, 8,  2, 1,  1, 2}, // #1026
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1027
  {DBGFIELD("LEA16r")             1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1028
  {DBGFIELD("LCMPXCHG8")          6, false, false, false, 12, 8,  2, 1,  0, 0}, // #1029
  {DBGFIELD("LCMPXCHG16B")        6, false, false, false, 12, 8,  2, 1,  0, 0}, // #1030
  {DBGFIELD("XCHG8rr_XCHG16rr_XCHG16ar") 3, false, false, false, 280, 2, 13, 1,  0, 0}, // #1031
  {DBGFIELD("XCHG8rm_XCHG16rm")   8, false, false, false, 892, 11,  7, 1,  0, 0}, // #1032
  {DBGFIELD("POPCNT16rr")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1033
  {DBGFIELD("LZCNT16rr")          1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1034
  {DBGFIELD("TZCNT16rr")          1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1035
  {DBGFIELD("RCL8m1_RCL16m1_RCL32m1_RCL64m1_RCR8m1_RCR16m1_RCR32m1_RCR64m1") 5, false, false, false, 823, 6,  2, 1,  0, 0}, // #1036
  {DBGFIELD("RCR8ri_RCR16ri_RCR32ri_RCR64ri") 3, false, false, false, 1092, 4,  5, 1,  0, 0}, // #1037
  {DBGFIELD("RCR8mi_RCR16mi_RCR32mi_RCR64mi") 5, false, false, false, 823, 6,  2, 1,  0, 0}, // #1038
  {DBGFIELD("RCR16rCL_RCR32rCL_RCR64rCL") 7, false, false, false, 1304, 9, 18, 1,  0, 0}, // #1039
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #1040
  {DBGFIELD("VEXTRACTI128rr")     1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1041
  {DBGFIELD("VEXTRACTI128mr")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #1042
  {DBGFIELD("MMX_MOVQ2FR64rr")    1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1043
  {DBGFIELD("MMX_MOVD64rr_MMX_MOVD64to64rr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1044
  {DBGFIELD("EXTRQ")              1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1045
  {DBGFIELD("INSERTQ")            1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1046
  {DBGFIELD("PABSBrr_PABSDrr_PABSWrr_PADDSBrr_PADDSWrr_PADDUSBrr_PADDUSWrr_PAVGBrr_PAVGWrr_PSIGNBrr_PSIGNDrr_PSIGNWrr_VPABSBrr_VPABSDrr_VPABSWrr_VPADDSBrr_VPADDSWrr_VPADDUSBrr_VPADDUSWrr_VPAVGBrr_VPAVGWrr_VPCMPEQQrr_VPSIGNBrr_VPSIGNDrr_VPSIGNWrr_PSUBSBrr_PSUBSWrr_PSUBUSBrr_PSUBUSWrr_VPSUBSBrr_VPSUBSWrr_VPSUBUSBrr_VPSUBUSWrr") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1047
  {DBGFIELD("MMX_PADDSBrr_MMX_PADDSWrr_MMX_PADDUSBrr_MMX_PADDUSWrr_MMX_PAVGBrr_MMX_PAVGWrr_MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false, 40, 9,  1, 1,  0, 0}, // #1048
  {DBGFIELD("VPABSBYrr_VPABSDYrr_VPABSWYrr_VPADDSBYrr_VPADDSWYrr_VPADDUSBYrr_VPADDUSWYrr_VPSUBSBYrr_VPSUBSWYrr_VPSUBUSBYrr_VPSUBUSWYrr_VPAVGBYrr_VPAVGWYrr_VPCMPEQQYrr_VPSIGNBYrr_VPSIGNDYrr_VPSIGNWYrr") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1049
  {DBGFIELD("SHA1MSG1rr")         1, false, false, false, 65, 4, 14, 1,  0, 0}, // #1050
  {DBGFIELD("SHA1MSG1rm")         2, false, false, false, 59, 6, 18, 1,  5, 1}, // #1051
  {DBGFIELD("VPERM2I128rr")       1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1052
  {DBGFIELD("VPERMPSYrr")         1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1053
  {DBGFIELD("VPERMPSYrm")         2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1054
  {DBGFIELD("VPERMPDYri")         1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1055
  {DBGFIELD("VPERMQYri")          1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1056
  {DBGFIELD("VPERMPDYmi")         2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1057
  {DBGFIELD("VPERMDYrr")          1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1058
  {DBGFIELD("VPERMQYmi")          2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1059
  {DBGFIELD("VPERMDYrm")          2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1060
  {DBGFIELD("MOV32rr_MOV32rr_REV_MOV64rr_MOV64rr_REV") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1061
  {DBGFIELD("MOVSX32rr32")        1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1062
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV_SUB32rr_REV_SUB64rr_REV") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1063
  {DBGFIELD("CMP8rr_CMP8rr_REV_CMP16rr_CMP16rr_REV_CMP32rr_CMP32rr_REV_CMP64rr_CMP64rr_REV") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1064
  {DBGFIELD("VXORPSrr_VXORPDrr")  8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1065
  {DBGFIELD("VANDNPSrr_VANDNPDrr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1066
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1067
  {DBGFIELD("VPXORrr")            8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1068
  {DBGFIELD("VPANDNrr")           1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1069
  {DBGFIELD("VPANDNYrr")          1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1070
  {DBGFIELD("VPSUBBrr_VPSUBWrr_VPSUBDrr_VPSUBQrr_VPCMPGTBrr_VPCMPGTWrr_VPCMPGTDrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1071
  {DBGFIELD("VPCMPGTQrr")         8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1072
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #1073
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 3, false, false, false, 49, 6,  6, 1,  0, 0}, // #1074
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1075
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 2, false, false, false, 55, 4,  3, 1,  0, 0}, // #1076
  {DBGFIELD("ADC64ri32_SBB64ri32") 1, false, false, false,  8, 4,  1, 1,  0, 0}, // #1077
  {DBGFIELD("CRC32r32r16")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1078
  {DBGFIELD("CRC32r32r32")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1079
  {DBGFIELD("CRC32r64r64")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1080
  {DBGFIELD("SAHF")               1, false, false, false,  8, 4,  1, 1,  0, 0}, // #1081
  {DBGFIELD("BEXTRI32ri_BEXTRI64ri") 2, false, false, false, 134, 6, 13, 1,  0, 0}, // #1082
  {DBGFIELD("BEXTRI32mi_BEXTRI64mi") 3, false, false, false, 126, 8,  6, 1,  0, 0}, // #1083
  {DBGFIELD("RCR8ri")             3, false, false, false, 1092, 4,  5, 1,  0, 0}, // #1084
  {DBGFIELD("RCL16rCL")           7, false, false, false, 1304, 9, 18, 1,  0, 0}, // #1085
  {DBGFIELD("RCR16ri")            3, false, false, false, 1092, 4,  5, 1,  0, 0}, // #1086
  {DBGFIELD("RCR32rCL_RCR64rCL")  7, false, false, false, 1304, 9, 18, 1,  0, 0}, // #1087
  {DBGFIELD("RCL16ri")            3, false, false, false, 1092, 4,  5, 1,  0, 0}, // #1088
  {DBGFIELD("RCL32ri_RCL64ri")    3, false, false, false, 1092, 4,  5, 1,  0, 0}, // #1089
  {DBGFIELD("SHLD32rri8")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1090
  {DBGFIELD("SHRD16rri8")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1091
  {DBGFIELD("SHLD16rrCL")         4, false, false, false, 708, 9,  3, 1,  0, 0}, // #1092
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #1093
  {DBGFIELD("TST_F")              1, false, false, false, 40, 9, 13, 1,  0, 0}, // #1094
  {DBGFIELD("VDPPSrri")           4, false, false, false, 293, 9, 22, 1,  0, 0}, // #1095
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr") 2, false, false, false, 637, 4,  2, 1,  0, 0}, // #1096
  {DBGFIELD("VFRCZSDrr_VFRCZSSrr") 2, false, false, false, 637, 4,  2, 1,  0, 0}, // #1097
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 3, false, false, false, 631, 6, 10, 1,  5, 1}, // #1098
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 2, false, false, false, 637, 4,  2, 1,  0, 0}, // #1099
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 3, false, false, false, 631, 6, 21, 1,  7, 1}, // #1100
  {DBGFIELD("MMX_CVTTPD2PIrr")    2, false, false, false, 749, 8, 14, 1,  0, 0}, // #1101
  {DBGFIELD("VMOVDQUYmr")         2, false, false, false, 33, 4,  1, 1,  0, 0}, // #1102
  {DBGFIELD("MOVDQArr")           1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1103
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 2, false, false, false, 637, 4,  7, 1,  0, 0}, // #1104
  {DBGFIELD("VMPSADBWrri")        2, false, false, false, 523, 8,  8, 1,  0, 0}, // #1105
  {DBGFIELD("VPPERMrrr_VPPERMrrr_REV") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1106
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, false, 623, 8,  5, 1,  0, 0}, // #1107
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, false, 613, 10,  9, 1,  5, 1}, // #1108
  {DBGFIELD("VPCLMULQDQrr")       1, false, false, false, 474, 8,  3, 1,  0, 0}, // #1109
  {DBGFIELD("ANDNPSrr_ANDNPDrr")  1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1110
  {DBGFIELD("MMX_PXORrr_MMX_PANDNrr") 1, false, false, false,  3, 5,  1, 1,  0, 0}, // #1111
  {DBGFIELD("PANDNrr")            1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1112
  {DBGFIELD("MMX_PSUBBrr_MMX_PSUBDrr_MMX_PSUBWrr_MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false,  3, 5,  1, 1,  0, 0}, // #1113
  {DBGFIELD("LCMPXCHG16_LCMPXCHG32_LCMPXCHG64") 6, false, false, false, 12, 8,  2, 1,  0, 0}, // #1114
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 5, false, false, false, 175, 4, 14, 1,  0, 0}, // #1115
  {DBGFIELD("LCMPXCHG8B")         6, false, false, false, 12, 8,  2, 1,  0, 0}, // #1116
  {DBGFIELD("XCHG8rr")            3, false, false, false, 280, 2, 13, 1,  0, 0}, // #1117
  {DBGFIELD("MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false, 40, 9,  1, 1,  0, 0}, // #1118
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1119
  {DBGFIELD("MMX_PCMPEQBrr_MMX_PCMPEQDrr_MMX_PCMPEQWrr_MMX_PMAXSWrr_MMX_PMINSWrr_MMX_PMAXUBrr_MMX_PMINUBrr") 1, false, false, false, 40, 9,  1, 1,  0, 0}, // #1120
  {DBGFIELD("MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false, 40, 9,  1, 1,  0, 0}, // #1121
  {DBGFIELD("CLAC_STAC")          1, false, false, false,  8, 4,  1, 1,  0, 0}, // #1122
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1123
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1124
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1125
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 3, false, false, false, 1470, 12,  5, 1,  0, 0}, // #1126
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, false, 346, 9,  5, 1,  0, 0}, // #1127
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 3, false, false, false, 346, 9,  5, 1,  0, 0}, // #1128
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 1, false, false, false, 65, 4,  8, 1,  0, 0}, // #1129
  {DBGFIELD("MMX_PADDSBrm_MMX_PADDSWrm_MMX_PADDUSBrm_MMX_PADDUSWrm_MMX_PAVGBrm_MMX_PAVGWrm_MMX_PCMPEQBrm_MMX_PCMPEQDrm_MMX_PCMPEQWrm_MMX_PCMPGTBrm_MMX_PCMPGTDrm_MMX_PCMPGTWrm_MMX_PMAXSWrm_MMX_PMAXUBrm_MMX_PMINSWrm_MMX_PMINUBrm_MMX_PSUBSBrm_MMX_PSUBSWrm_MMX_PSUBUSBrm_MMX_PSUBUSWrm") 2, false, false, false, 69, 11,  3, 1,  0, 0}, // #1130
  {DBGFIELD("CVTSS2SI64rr")       2, false, false, false, 1234, 9,  3, 1,  0, 0}, // #1131
  {DBGFIELD("CVTSS2SI64rr_Int")   2, false, false, false, 1234, 9,  3, 1,  0, 0}, // #1132
  {DBGFIELD("CVTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr") 2, false, false, false, 1234, 9,  3, 1,  0, 0}, // #1133
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 2, false, false, false, 1234, 9,  3, 1,  0, 0}, // #1134
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 2, false, false, false, 60, 5,  6, 1,  5, 1}, // #1135
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 2, false, false, false, 60, 5,  2, 1,  7, 1}, // #1136
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 4, false, false, false, 1482, 14,  2, 1,  0, 0}, // #1137
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, false, 335, 11,  9, 1,  0, 0}, // #1138
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 4, false, false, false, 335, 11,  7, 1,  0, 0}, // #1139
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 40, false, false, false, 1346, 11, 40, 1,  0, 0}, // #1140
  {DBGFIELD("PCMPGTBrr_PCMPGTDrr_PCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1141
  {DBGFIELD("VPCMPGTBrr_VPCMPGTDrr_VPCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1142
  {DBGFIELD("VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1143
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1144
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1145
  {DBGFIELD("KSET0D_KSET0Q_KSET0W_KSET1D_KSET1Q_KSET1W") 1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1146
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1147
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 2, false, false, false, 145, 3, 13, 1,  0, 0}, // #1148
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 2, false, false, false, 145, 3, 13, 1,  0, 0}, // #1149
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1150
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1151
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1152
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 2, false, false, false, 145, 3, 13, 1,  0, 0}, // #1153
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 2, false, false, false, 145, 3, 13, 1,  0, 0}, // #1154
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1155
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #1156
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1157
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1158
  {DBGFIELD("VPSADBWZrr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1159
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1160
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1161
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1162
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1163
  {DBGFIELD("VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1164
  {DBGFIELD("VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1165
  {DBGFIELD("VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1166
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1167
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1168
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, false, 65, 4,  8, 1,  0, 0}, // #1169
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 1, false, false, false, 65, 4,  8, 1,  0, 0}, // #1170
  {DBGFIELD("VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1171
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, false, 65, 4,  8, 1,  0, 0}, // #1172
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1173
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1174
  {DBGFIELD("VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1175
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1176
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1177
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1178
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1179
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1180
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1181
  {DBGFIELD("VCVTPS2DQYrr")       1, false, false, false, 65, 4,  8, 1,  0, 0}, // #1182
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1183
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1184
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1185
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1186
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1187
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1188
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1189
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1190
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1191
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1192
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #1193
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1194
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1195
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1196
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1197
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1198
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1199
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1200
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 1, false, false, false, 26, 7,  8, 1,  6, 1}, // #1201
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 1, false, false, false, 26, 7,  8, 1,  6, 1}, // #1202
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1203
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1204
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 4, false, false, false, 757, 12,  3, 1,  0, 0}, // #1205
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 4, false, false, false, 757, 12,  2, 1,  0, 0}, // #1206
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1207
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #1208
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1209
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1210
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1211
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 1, false, false, false, 26, 7,  8, 1,  6, 1}, // #1212
  {DBGFIELD("VMOVSDZrm_VMOVSDZrm_alt_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrm_alt_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1213
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1214
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1215
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1216
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1217
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1218
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1219
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1220
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1221
  {DBGFIELD("VCVTPD2PSZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1222
  {DBGFIELD("VCVTPS2PDZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1223
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1224
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1225
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false, false, 37, 3,  3, 1,  0, 0}, // #1226
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 3, false, false, false, 140, 5,  2, 1,  5, 1}, // #1227
  {DBGFIELD("VBROADCASTI32X2Z128rm_VBROADCASTI32X2Z128rmk_VBROADCASTI32X2Z128rmkz_VPBROADCASTDZ128rm_VPBROADCASTDZ128rmk_VPBROADCASTDZ128rmkz_VPBROADCASTQZ128rm_VPBROADCASTQZ128rmk_VPBROADCASTQZ128rmkz") 2, false, false, false, 464, 10,  6, 1,  0, 0}, // #1228
  {DBGFIELD("VBROADCASTSSZ128rm_VBROADCASTSSZ128rmk_VBROADCASTSSZ128rmkz") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #1229
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #1230
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 2, false, false, false, 464, 10,  6, 1,  0, 0}, // #1231
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #1232
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 2, false, false, false, 59, 6,  6, 1,  5, 1}, // #1233
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 3, false, false, false, 140, 5,  2, 1,  5, 1}, // #1234
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1235
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1236
  {DBGFIELD("VCVTSS2SI64rr")      2, false, false, false, 1234, 9,  3, 1,  0, 0}, // #1237
  {DBGFIELD("VCVTSS2SI64rr_Int")  2, false, false, false, 1234, 9,  3, 1,  0, 0}, // #1238
  {DBGFIELD("VCVTTSS2SI64rr")     3, false, false, false, 855, 12,  6, 1,  0, 0}, // #1239
  {DBGFIELD("VCVTTSS2SI64rr_Int") 3, false, false, false, 855, 12,  6, 1,  0, 0}, // #1240
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1241
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #1242
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1243
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1244
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1245
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1246
  {DBGFIELD("VPBROADCASTBZ256rm_VPBROADCASTBZ256rmk_VPBROADCASTBZ256rmkz_VPBROADCASTBZrm_VPBROADCASTBZrmk_VPBROADCASTBZrmkz_VPBROADCASTWZ256rm_VPBROADCASTWZ256rmk_VPBROADCASTWZ256rmkz_VPBROADCASTWZrm_VPBROADCASTWZrmk_VPBROADCASTWZrmkz") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #1247
  {DBGFIELD("VMOVNTDQAZ256rm")    1, false, false, false, 37, 3,  6, 1,  0, 0}, // #1248
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 3, false, false, false, 140, 5,  9, 1,  7, 1}, // #1249
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1250
  {DBGFIELD("VBROADCASTF32X2Z256rm_VBROADCASTF32X2Z256rmk_VBROADCASTF32X2Z256rmkz_VBROADCASTF32X2Zrm_VBROADCASTF32X2Zrmk_VBROADCASTF32X2Zrmkz_VBROADCASTI32X2Z256rm_VBROADCASTI32X2Z256rmk_VBROADCASTI32X2Z256rmkz_VBROADCASTI32X2Zrm_VBROADCASTI32X2Zrmk_VBROADCASTI32X2Zrmkz_VPBROADCASTDZ256rm_VPBROADCASTDZ256rmk_VPBROADCASTDZ256rmkz_VPBROADCASTDZrm_VPBROADCASTDZrmk_VPBROADCASTDZrmkz_VPBROADCASTQZ256rm_VPBROADCASTQZ256rmk_VPBROADCASTQZ256rmkz_VPBROADCASTQZrm_VPBROADCASTQZrmk_VPBROADCASTQZrmkz") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #1251
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 2, false, false, false, 464, 10,  2, 1,  0, 0}, // #1252
  {DBGFIELD("VBROADCASTSDZ256rm_VBROADCASTSDZ256rmk_VBROADCASTSDZ256rmkz_VBROADCASTSDZrm_VBROADCASTSDZrmk_VBROADCASTSDZrmkz_VBROADCASTSSZ256rm_VBROADCASTSSZ256rmk_VBROADCASTSSZ256rmkz_VBROADCASTSSZrm_VBROADCASTSSZrmk_VBROADCASTSSZrmkz") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #1253
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1254
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1255
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 1, false, false, false, 37, 3,  6, 1,  0, 0}, // #1256
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, false, 464, 10,  2, 1,  0, 0}, // #1257
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1258
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 1, false, false, false, 37, 3,  6, 1,  0, 0}, // #1259
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 2, false, false, false, 59, 6,  2, 1,  7, 1}, // #1260
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1261
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 3, false, false, false, 140, 5,  2, 1,  7, 1}, // #1262
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1263
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1264
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1265
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1266
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1267
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #1268
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 2, false, false, false, 59, 6,  9, 1,  3, 1}, // #1269
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1270
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1271
  {DBGFIELD("VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 2, false, false, false, 59, 6,  6, 1,  5, 1}, // #1272
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmik_VFPCLASSPDZ128rm_VFPCLASSPDZ128rmb_VFPCLASSPDZ128rmbk_VFPCLASSPDZ128rmk_VFPCLASSPSZ128rm_VFPCLASSPSZ128rmb_VFPCLASSPSZ128rmbk_VFPCLASSPSZ128rmk") 2, false, false, false, 59, 6,  7, 1,  5, 1}, // #1273
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk") 2, false, false, false, 59, 6,  9, 1,  3, 1}, // #1274
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmik_VPCMPDZ128rmi_VPCMPDZ128rmib_VPCMPDZ128rmibk_VPCMPDZ128rmik_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmib_VPCMPQZ128rmibk_VPCMPQZ128rmik_VPCMPUBZ128rmi_VPCMPUBZ128rmik_VPCMPUDZ128rmi_VPCMPUDZ128rmib_VPCMPUDZ128rmibk_VPCMPUDZ128rmik_VPCMPUQZ128rmi_VPCMPUQZ128rmib_VPCMPUQZ128rmibk_VPCMPUQZ128rmik_VPCMPUWZ128rmi_VPCMPUWZ128rmik_VPCMPWZ128rmi_VPCMPWZ128rmik") 2, false, false, false, 59, 6,  6, 1,  5, 1}, // #1275
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 2, false, false, false, 60, 5,  6, 1,  5, 1}, // #1276
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 2, false, false, false, 464, 10,  2, 1,  7, 1}, // #1277
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1278
  {DBGFIELD("VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 2, false, false, false, 59, 6,  2, 1,  7, 1}, // #1279
  {DBGFIELD("VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1280
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmik_VFPCLASSPDZ256rm_VFPCLASSPDZ256rmb_VFPCLASSPDZ256rmbk_VFPCLASSPDZ256rmk_VFPCLASSPSZ256rm_VFPCLASSPSZ256rmb_VFPCLASSPSZ256rmbk_VFPCLASSPSZ256rmk") 2, false, false, false, 59, 6, 18, 1,  7, 1}, // #1281
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmik_VFPCLASSPDZrm_VFPCLASSPDZrmb_VFPCLASSPDZrmbk_VFPCLASSPDZrmk_VFPCLASSPSZrm_VFPCLASSPSZrmb_VFPCLASSPSZrmbk_VFPCLASSPSZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1282
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmik_VPCMPDZ256rmi_VPCMPDZ256rmib_VPCMPDZ256rmibk_VPCMPDZ256rmik_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmib_VPCMPQZ256rmibk_VPCMPQZ256rmik_VPCMPUBZ256rmi_VPCMPUBZ256rmik_VPCMPUDZ256rmi_VPCMPUDZ256rmib_VPCMPUDZ256rmibk_VPCMPUDZ256rmik_VPCMPUQZ256rmi_VPCMPUQZ256rmib_VPCMPUQZ256rmibk_VPCMPUQZ256rmik_VPCMPUWZ256rmi_VPCMPUWZ256rmik_VPCMPWZ256rmi_VPCMPWZ256rmik") 2, false, false, false, 59, 6,  2, 1,  7, 1}, // #1283
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmik_VPCMPDZrmi_VPCMPDZrmib_VPCMPDZrmibk_VPCMPDZrmik_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmib_VPCMPQZrmibk_VPCMPQZrmik_VPCMPUBZrmi_VPCMPUBZrmik_VPCMPUDZrmi_VPCMPUDZrmib_VPCMPUDZrmibk_VPCMPUDZrmik_VPCMPUQZrmi_VPCMPUQZrmib_VPCMPUQZrmibk_VPCMPUQZrmik_VPCMPUWZrmi_VPCMPUWZrmik_VPCMPWZrmi_VPCMPWZrmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1284
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 2, false, false, false, 60, 5,  2, 1,  7, 1}, // #1285
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1286
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 2, false, false, false, 158, 9,  9, 1,  0, 0}, // #1287
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 2, false, false, false, 158, 9,  9, 1,  0, 0}, // #1288
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #1289
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 2, false, false, false, 59, 6,  9, 1,  0, 0}, // #1290
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #1291
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #1292
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #1293
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1294
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 2, false, false, false, 158, 9,  9, 1,  0, 0}, // #1295
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1296
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, false, 158, 9,  9, 1,  0, 0}, // #1297
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1298
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, false, 59, 6,  7, 1,  0, 0}, // #1299
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1300
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #1301
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1302
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #1303
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1304
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #1305
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1306
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1307
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #1308
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 2, false, false, false, 59, 6,  6, 1,  0, 0}, // #1309
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, false, 65, 4, 14, 1,  0, 0}, // #1310
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 1, false, false, false, 65, 4, 14, 1,  0, 0}, // #1311
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1312
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1313
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #1314
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #1315
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1316
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1317
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1318
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1319
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1320
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1321
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1322
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 2, false, false, false, 59, 6,  6, 1,  0, 0}, // #1323
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 2, false, false, false, 59, 6, 18, 1,  5, 1}, // #1324
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 2, false, false, false, 59, 6, 23, 1,  7, 1}, // #1325
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1326
  {DBGFIELD("VGATHERQPSZ128rm_VPGATHERQDZ128rm_VGATHERDPDZ128rm_VPGATHERDQZ128rm_VGATHERQPDZ128rm_VPGATHERQQZ128rm") 1, false, false, false, 37, 3, 38, 2,  0, 0}, // #1327
  {DBGFIELD("VGATHERQPSZ256rm_VPGATHERQDZ256rm_VGATHERQPDZ256rm_VPGATHERQQZ256rm_VGATHERDPSZ128rm_VPGATHERDDZ128rm_VGATHERDPDZ256rm_VPGATHERDQZ256rm") 1, false, false, false, 37, 3, 38, 2,  0, 0}, // #1328
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm_VGATHERDPDZrm_VPGATHERDQZrm_VGATHERQPDZrm_VPGATHERQQZrm_VGATHERQPSZrm_VPGATHERQDZrm") 1, false, false, false, 37, 3, 38, 2,  0, 0}, // #1329
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 1, false, false, false, 37, 3, 38, 2,  0, 0}, // #1330
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1331
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1332
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 2, false, false, false, 59, 6,  2, 1,  0, 0}, // #1333
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1334
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1335
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 2, false, false, false, 59, 6,  2, 1,  0, 0}, // #1336
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1337
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1338
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1339
  {DBGFIELD("VXORPSZ128rr_VXORPDZ128rr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1340
  {DBGFIELD("VXORPSZ256rr_VXORPDZ256rr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1341
  {DBGFIELD("VXORPSZrr_VXORPDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1342
  {DBGFIELD("VPXORDZ128rr_VPXORQZ128rr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1343
  {DBGFIELD("VPXORDZ256rr_VPXORQZ256rr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1344
  {DBGFIELD("VPXORDZrr_VPXORQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1345
  {DBGFIELD("VPSUBBZ128rr_VPSUBDZ128rr_VPSUBQZ128rr_VPSUBWZ128rr") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1346
  {DBGFIELD("VPSUBBZ256rr_VPSUBDZ256rr_VPSUBQZ256rr_VPSUBWZ256rr") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1347
  {DBGFIELD("VPSUBBZrr_VPSUBDZrr_VPSUBQZrr_VPSUBWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1348
  {DBGFIELD("VPBROADCASTDrr_VPBROADCASTQrr_PALIGNRrri_VPALIGNRZ128rri_VPALIGNRZ128rrik_VPALIGNRZ128rrikz_VPALIGNRrri_PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWZ128rr_VPACKSSDWZ128rrk_VPACKSSDWZ128rrkz_VPACKSSDWrr_VPACKSSWBZ128rr_VPACKSSWBZ128rrk_VPACKSSWBZ128rrkz_VPACKSSWBrr_VPACKUSDWZ128rr_VPACKUSDWZ128rrk_VPACKUSDWZ128rrkz_VPACKUSDWrr_VPACKUSWBZ128rr_VPACKUSWBZ128rrk_VPACKUSWBZ128rrkz_VPACKUSWBrr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1349
  {DBGFIELD("INSERTPSrr_VINSERTPSZrr_VINSERTPSrr_MOVHLPSrr_MOVLHPSrr_VMOVHLPSZrr_VMOVHLPSrr_VMOVLHPSZrr_VMOVLHPSrr_MOVDDUPrr_VMOVDDUPZ128rr_VMOVDDUPZ128rrk_VMOVDDUPZ128rrkz_VMOVDDUPrr_VPERMILPDZ128ri_VPERMILPDZ128rik_VPERMILPDZ128rikz_VPERMILPDri_VPERMILPSZ128ri_VPERMILPSZ128rik_VPERMILPSZ128rikz_VPERMILPSri_UNPCKHPDrr_UNPCKHPSrr_UNPCKLPDrr_UNPCKLPSrr_VUNPCKHPDZ128rr_VUNPCKHPDZ128rrk_VUNPCKHPDZ128rrkz_VUNPCKHPDrr_VUNPCKHPSZ128rr_VUNPCKHPSZ128rrk_VUNPCKHPSZ128rrkz_VUNPCKHPSrr_VUNPCKLPDZ128rr_VUNPCKLPDZ128rrk_VUNPCKLPDZ128rrkz_VUNPCKLPDrr_VUNPCKLPSZ128rr_VUNPCKLPSZ128rrk_VUNPCKLPSZ128rrkz_VUNPCKLPSrr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1350
  {DBGFIELD("VMOVDDUPYrr_VMOVDDUPZ256rr_VMOVDDUPZ256rrk_VMOVDDUPZ256rrkz_VPERMILPDYri_VPERMILPDZ256ri_VPERMILPDZ256rik_VPERMILPDZ256rikz_VPERMILPSYri_VPERMILPSZ256ri_VPERMILPSZ256rik_VPERMILPSZ256rikz_VUNPCKHPDYrr_VUNPCKHPDZ256rr_VUNPCKHPDZ256rrk_VUNPCKHPDZ256rrkz_VUNPCKHPSYrr_VUNPCKHPSZ256rr_VUNPCKHPSZ256rrk_VUNPCKHPSZ256rrkz_VUNPCKLPDYrr_VUNPCKLPDZ256rr_VUNPCKLPDZ256rrk_VUNPCKLPDZ256rrkz_VUNPCKLPSYrr_VUNPCKLPSZ256rr_VUNPCKLPSZ256rrk_VUNPCKLPSZ256rrkz") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1351
  {DBGFIELD("VMOVDDUPZrr_VMOVDDUPZrrk_VMOVDDUPZrrkz_VPERMILPDZri_VPERMILPDZrik_VPERMILPDZrikz_VPERMILPSZri_VPERMILPSZrik_VPERMILPSZrikz_VUNPCKHPDZrr_VUNPCKHPDZrrk_VUNPCKHPDZrrkz_VUNPCKHPSZrr_VUNPCKHPSZrrk_VUNPCKHPSZrrkz_VUNPCKLPDZrr_VUNPCKLPDZrrk_VUNPCKLPDZrrkz_VUNPCKLPSZrr_VUNPCKLPSZrrk_VUNPCKLPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1352
  {DBGFIELD("VPALIGNRYrri_VPALIGNRZ256rri_VPALIGNRZ256rrik_VPALIGNRZ256rrikz_VPACKSSDWYrr_VPACKSSDWZ256rr_VPACKSSDWZ256rrk_VPACKSSDWZ256rrkz_VPACKSSWBYrr_VPACKSSWBZ256rr_VPACKSSWBZ256rrk_VPACKSSWBZ256rrkz_VPACKUSDWYrr_VPACKUSDWZ256rr_VPACKUSDWZ256rrk_VPACKUSDWZ256rrkz_VPACKUSWBYrr_VPACKUSWBZ256rr_VPACKUSWBZ256rrk_VPACKUSWBZ256rrkz") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1353
  {DBGFIELD("VPALIGNRZrri_VPALIGNRZrrik_VPALIGNRZrrikz_VPACKSSDWZrr_VPACKSSDWZrrk_VPACKSSDWZrrkz_VPACKSSWBZrr_VPACKSSWBZrrk_VPACKSSWBZrrkz_VPACKUSDWZrr_VPACKUSDWZrrk_VPACKUSDWZrrkz_VPACKUSWBZrr_VPACKUSWBZrrk_VPACKUSWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1354
  {DBGFIELD("VPERMILPDYrr_VPERMILPDZ256rr_VPERMILPDZ256rrk_VPERMILPDZ256rrkz_VPERMILPSYrr_VPERMILPSZ256rr_VPERMILPSZ256rrk_VPERMILPSZ256rrkz") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1355
  {DBGFIELD("VPERMILPDZ128rr_VPERMILPDZ128rrk_VPERMILPDZ128rrkz_VPERMILPDrr_VPERMILPSZ128rr_VPERMILPSZ128rrk_VPERMILPSZ128rrkz_VPERMILPSrr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1356
  {DBGFIELD("VPERMILPDZrr_VPERMILPDZrrk_VPERMILPDZrrkz_VPERMILPSZrr_VPERMILPSZrrk_VPERMILPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1357
  {DBGFIELD("MOVSDrr_MOVSDrr_REV_VMOVSDZrr_VMOVSDZrr_REV_VMOVSDZrrk_VMOVSDZrrk_REV_VMOVSDZrrkz_VMOVSDZrrkz_REV_VMOVSDrr_VMOVSDrr_REV_VMOVSSZrr_VMOVSSZrr_REV_VMOVSSZrrk_VMOVSSZrrk_REV_VMOVSSZrrkz_VMOVSSZrrkz_REV_VMOVSSrr_VMOVSSrr_REV") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1358
  {DBGFIELD("VPBROADCASTBZ128rm_VPBROADCASTBZ128rmk_VPBROADCASTBZ128rmkz_VPBROADCASTWZ128rm_VPBROADCASTWZ128rmk_VPBROADCASTWZ128rmkz") 2, false, false, false, 464, 10,  6, 1,  0, 0}, // #1359
  {DBGFIELD("INSERTPSrm_VINSERTPSZrm_VINSERTPSrm_UNPCKHPDrm_UNPCKHPSrm_UNPCKLPDrm_UNPCKLPSrm_VUNPCKHPDZ128rm_VUNPCKHPDZ128rmb_VUNPCKHPDZ128rmbk_VUNPCKHPDZ128rmbkz_VUNPCKHPDZ128rmk_VUNPCKHPDZ128rmkz_VUNPCKHPDrm_VUNPCKHPSZ128rm_VUNPCKHPSZ128rmb_VUNPCKHPSZ128rmbk_VUNPCKHPSZ128rmbkz_VUNPCKHPSZ128rmk_VUNPCKHPSZ128rmkz_VUNPCKHPSrm_VUNPCKLPDZ128rm_VUNPCKLPDZ128rmb_VUNPCKLPDZ128rmbk_VUNPCKLPDZ128rmbkz_VUNPCKLPDZ128rmk_VUNPCKLPDZ128rmkz_VUNPCKLPDrm_VUNPCKLPSZ128rm_VUNPCKLPSZ128rmb_VUNPCKLPSZ128rmbk_VUNPCKLPSZ128rmbkz_VUNPCKLPSZ128rmk_VUNPCKLPSZ128rmkz_VUNPCKLPSrm") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #1360
  {DBGFIELD("PALIGNRrmi_VPALIGNRZ128rmi_VPALIGNRZ128rmik_VPALIGNRZ128rmikz_VPALIGNRrmi_PACKSSDWrm_PACKSSWBrm_PACKUSDWrm_PACKUSWBrm_VPACKSSDWZ128rm_VPACKSSDWZ128rmb_VPACKSSDWZ128rmbk_VPACKSSDWZ128rmbkz_VPACKSSDWZ128rmk_VPACKSSDWZ128rmkz_VPACKSSDWrm_VPACKSSWBZ128rm_VPACKSSWBZ128rmk_VPACKSSWBZ128rmkz_VPACKSSWBrm_VPACKUSDWZ128rm_VPACKUSDWZ128rmb_VPACKUSDWZ128rmbk_VPACKUSDWZ128rmbkz_VPACKUSDWZ128rmk_VPACKUSDWZ128rmkz_VPACKUSDWrm_VPACKUSWBZ128rm_VPACKUSWBZ128rmk_VPACKUSWBZ128rmkz_VPACKUSWBrm") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #1361
  {DBGFIELD("VPERMILPDZ128mbi_VPERMILPDZ128mbik_VPERMILPDZ128mbikz_VPERMILPDZ128mi_VPERMILPDZ128mik_VPERMILPDZ128mikz_VPERMILPDmi_VPERMILPSZ128mbi_VPERMILPSZ128mbik_VPERMILPSZ128mbikz_VPERMILPSZ128mi_VPERMILPSZ128mik_VPERMILPSZ128mikz_VPERMILPSmi") 2, false, false, false, 464, 10,  6, 1,  0, 0}, // #1362
  {DBGFIELD("VPERMILPDZ128rm_VPERMILPDZ128rmb_VPERMILPDZ128rmbk_VPERMILPDZ128rmbkz_VPERMILPDZ128rmk_VPERMILPDZ128rmkz_VPERMILPDrm_VPERMILPSZ128rm_VPERMILPSZ128rmb_VPERMILPSZ128rmbk_VPERMILPSZ128rmbkz_VPERMILPSZ128rmk_VPERMILPSZ128rmkz_VPERMILPSrm") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #1363
  {DBGFIELD("VPALIGNRYrmi_VPALIGNRZ256rmi_VPALIGNRZ256rmik_VPALIGNRZ256rmikz_VPACKSSDWYrm_VPACKSSDWZ256rm_VPACKSSDWZ256rmb_VPACKSSDWZ256rmbk_VPACKSSDWZ256rmbkz_VPACKSSDWZ256rmk_VPACKSSDWZ256rmkz_VPACKSSWBYrm_VPACKSSWBZ256rm_VPACKSSWBZ256rmk_VPACKSSWBZ256rmkz_VPACKUSDWYrm_VPACKUSDWZ256rm_VPACKUSDWZ256rmb_VPACKUSDWZ256rmbk_VPACKUSDWZ256rmbkz_VPACKUSDWZ256rmk_VPACKUSDWZ256rmkz_VPACKUSWBYrm_VPACKUSWBZ256rm_VPACKUSWBZ256rmk_VPACKUSWBZ256rmkz") 2, false, false, false, 464, 10,  2, 1,  7, 1}, // #1364
  {DBGFIELD("VPALIGNRZrmi_VPALIGNRZrmik_VPALIGNRZrmikz_VPACKSSDWZrm_VPACKSSDWZrmb_VPACKSSDWZrmbk_VPACKSSDWZrmbkz_VPACKSSDWZrmk_VPACKSSDWZrmkz_VPACKSSWBZrm_VPACKSSWBZrmk_VPACKSSWBZrmkz_VPACKUSDWZrm_VPACKUSDWZrmb_VPACKUSDWZrmbk_VPACKUSDWZrmbkz_VPACKUSDWZrmk_VPACKUSDWZrmkz_VPACKUSWBZrm_VPACKUSWBZrmk_VPACKUSWBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1365
  {DBGFIELD("VPERMILPDYmi_VPERMILPDZ256mbi_VPERMILPDZ256mbik_VPERMILPDZ256mbikz_VPERMILPDZ256mi_VPERMILPDZ256mik_VPERMILPDZ256mikz_VPERMILPSYmi_VPERMILPSZ256mbi_VPERMILPSZ256mbik_VPERMILPSZ256mbikz_VPERMILPSZ256mi_VPERMILPSZ256mik_VPERMILPSZ256mikz") 2, false, false, false, 464, 10,  2, 1,  0, 0}, // #1366
  {DBGFIELD("VPERMILPDZmbi_VPERMILPDZmbik_VPERMILPDZmbikz_VPERMILPDZmi_VPERMILPDZmik_VPERMILPDZmikz_VPERMILPSZmbi_VPERMILPSZmbik_VPERMILPSZmbikz_VPERMILPSZmi_VPERMILPSZmik_VPERMILPSZmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1367
  {DBGFIELD("VPERMILPDYrm_VPERMILPDZ256rm_VPERMILPDZ256rmb_VPERMILPDZ256rmbk_VPERMILPDZ256rmbkz_VPERMILPDZ256rmk_VPERMILPDZ256rmkz_VPERMILPSYrm_VPERMILPSZ256rm_VPERMILPSZ256rmb_VPERMILPSZ256rmbk_VPERMILPSZ256rmbkz_VPERMILPSZ256rmk_VPERMILPSZ256rmkz") 2, false, false, false, 464, 10,  2, 1,  7, 1}, // #1368
  {DBGFIELD("VPERMILPDZrm_VPERMILPDZrmb_VPERMILPDZrmbk_VPERMILPDZrmbkz_VPERMILPDZrmk_VPERMILPDZrmkz_VPERMILPSZrm_VPERMILPSZrmb_VPERMILPSZrmbk_VPERMILPSZrmbkz_VPERMILPSZrmk_VPERMILPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1369
  {DBGFIELD("VUNPCKHPDYrm_VUNPCKHPDZ256rm_VUNPCKHPDZ256rmb_VUNPCKHPDZ256rmbk_VUNPCKHPDZ256rmbkz_VUNPCKHPDZ256rmk_VUNPCKHPDZ256rmkz_VUNPCKHPSYrm_VUNPCKHPSZ256rm_VUNPCKHPSZ256rmb_VUNPCKHPSZ256rmbk_VUNPCKHPSZ256rmbkz_VUNPCKHPSZ256rmk_VUNPCKHPSZ256rmkz_VUNPCKLPDYrm_VUNPCKLPDZ256rm_VUNPCKLPDZ256rmb_VUNPCKLPDZ256rmbk_VUNPCKLPDZ256rmbkz_VUNPCKLPDZ256rmk_VUNPCKLPDZ256rmkz_VUNPCKLPSYrm_VUNPCKLPSZ256rm_VUNPCKLPSZ256rmb_VUNPCKLPSZ256rmbk_VUNPCKLPSZ256rmbkz_VUNPCKLPSZ256rmk_VUNPCKLPSZ256rmkz") 2, false, false, false, 464, 10,  2, 1,  7, 1}, // #1370
  {DBGFIELD("VUNPCKHPDZrm_VUNPCKHPDZrmb_VUNPCKHPDZrmbk_VUNPCKHPDZrmbkz_VUNPCKHPDZrmk_VUNPCKHPDZrmkz_VUNPCKHPSZrm_VUNPCKHPSZrmb_VUNPCKHPSZrmbk_VUNPCKHPSZrmbkz_VUNPCKHPSZrmk_VUNPCKHPSZrmkz_VUNPCKLPDZrm_VUNPCKLPDZrmb_VUNPCKLPDZrmbk_VUNPCKLPDZrmbkz_VUNPCKLPDZrmk_VUNPCKLPDZrmkz_VUNPCKLPSZrm_VUNPCKLPSZrmb_VUNPCKLPSZrmbk_VUNPCKLPSZrmbkz_VUNPCKLPSZrmk_VUNPCKLPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1371
  {DBGFIELD("PdWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1372
  {DBGFIELD("WriteVecALU")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1373
  {DBGFIELD("JWriteZeroLatency")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1374
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1375
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1376
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1377
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1378
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1379
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1380
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1381
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1382
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1383
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1384
  {DBGFIELD("JWriteLOCK_CMPXCHG8B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1385
  {DBGFIELD("JWriteLOCK_CMPXCHG16B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1386
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1387
  {DBGFIELD("JWriteLOCK_CMPXCHGrm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1388
  {DBGFIELD("JWriteCMPXCHG8B")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1389
  {DBGFIELD("JWriteCMPXCHG16B")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1390
  {DBGFIELD("JWriteCMPXCHG8rm")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1391
  {DBGFIELD("WriteCMPXCHGRMW")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1392
  {DBGFIELD("JWriteCMPXCHG8rr")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1393
  {DBGFIELD("WriteCMPXCHG")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1394
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1395
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1396
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1397
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1398
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1399
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1400
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1401
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1402
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1403
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1404
  {DBGFIELD("JWriteLOCK_XADDrm_XCHG_Part_JWriteXCHGrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1405
  {DBGFIELD("JWriteXADDrm_XCHG_Part_JWriteXADDrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1406
  {DBGFIELD("SBWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1407
  {DBGFIELD("WriteALU")           1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1408
  {DBGFIELD("HWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1409
  {DBGFIELD("BWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1410
  {DBGFIELD("Zn3WriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1411
  {DBGFIELD("SKLWriteZeroLatency") 1, false, false, false,  0, 0,  0, 1,  0, 0}, // #1412
  {DBGFIELD("SKXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1413
  {DBGFIELD("ICXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1414
  {DBGFIELD("WriteFLogic")        1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1415
  {DBGFIELD("WriteFLogicY")       1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1416
  {DBGFIELD("JWriteZeroIdiomYmm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1417
  {DBGFIELD("WriteVecLogicX")     1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1418
  {DBGFIELD("WriteVecALUX")       1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1419
  {DBGFIELD("SKLWritePSUB")       1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1420
  {DBGFIELD("SKXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1421
  {DBGFIELD("ICXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1422
  {DBGFIELD("SBWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1423
  {DBGFIELD("HWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1424
  {DBGFIELD("BWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1425
  {DBGFIELD("SKLWritePCMPGTQ")    1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1426
  {DBGFIELD("SKXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1427
  {DBGFIELD("ICXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1428
  {DBGFIELD("SBWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1429
  {DBGFIELD("WriteCMOV")          1, false, false, false,  8, 4,  1, 1,  0, 0}, // #1430
  {DBGFIELD("HWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1431
  {DBGFIELD("BWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1432
  {DBGFIELD("SKLWriteCMOVA_CMOVBErr") 2, false, false, false, 1222, 4, 13, 1,  0, 0}, // #1433
  {DBGFIELD("SKXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1434
  {DBGFIELD("ICXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1435
  {DBGFIELD("SBWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1436
  {DBGFIELD("WriteCMOVLd")        2, false, false, false, 20, 6,  3, 1,  0, 0}, // #1437
  {DBGFIELD("HWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1438
  {DBGFIELD("BWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1439
  {DBGFIELD("PdWriteCMOVm")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1440
  {DBGFIELD("SKLWriteCMOVA_CMOVBErm") 3, false, false, false, 1496, 6,  6, 1,  0, 0}, // #1441
  {DBGFIELD("SKXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1442
  {DBGFIELD("ICXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1443
  {DBGFIELD("SBWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1444
  {DBGFIELD("WriteSETCC")         1, false, false, false,  8, 4,  1, 1,  0, 0}, // #1445
  {DBGFIELD("HWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1446
  {DBGFIELD("BWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1447
  {DBGFIELD("SKLWriteSETA_SETBEr") 2, false, false, false, 1222, 4, 13, 1,  0, 0}, // #1448
  {DBGFIELD("SKXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1449
  {DBGFIELD("ICXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1450
  {DBGFIELD("SBWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1451
  {DBGFIELD("WriteSETCCStore")    3, false, false, false, 681, 7, 13, 1,  0, 0}, // #1452
  {DBGFIELD("HWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1453
  {DBGFIELD("BWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1454
  {DBGFIELD("PdWriteSETGEmSETGmSETLEmSETLm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1455
  {DBGFIELD("SKLWriteSETA_SETBEm") 4, false, false, false, 1502, 7,  5, 1,  0, 0}, // #1456
  {DBGFIELD("SKXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1457
  {DBGFIELD("ICXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1458
  {DBGFIELD("WriteVecLogicY")     1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1459
  {DBGFIELD("WriteVecALUY")       1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1460
  {DBGFIELD("HWWriteADC0")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1461
  {DBGFIELD("WriteADC")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1462
  {DBGFIELD("JWriteLOCK_ALURMW")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1463
  {DBGFIELD("WriteALURMW")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1464
  {DBGFIELD("WriteFShuffle256")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1465
  {DBGFIELD("Zn3Write3OpsLEA")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1466
  {DBGFIELD("WriteLEA")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1467
  {DBGFIELD("PdWrite3OpsLEA")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1468
  {DBGFIELD("JWrite3OpsLEA")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1469
  {DBGFIELD("WriteVecLogic")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1470
  {DBGFIELD("WriteFLogicZ")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1471
  {DBGFIELD("WriteVecLogicZ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1472
}; // SkylakeClientModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc AtomModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, false, 40, 1,  1, 1,  0, 0}, // #3
  {DBGFIELD("WriteJump")          1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteCMPXCHGRMW")    1, false, false, false, 1511, 2,  1, 1,  0, 0}, // #5
  {DBGFIELD("WriteJumpLd")        1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteMove")          1, false, false, false, 40, 1,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, false, 40, 1,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteADC")           1, false, false, false, 40, 1,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteSHDrri")        1, false, false, false, 80, 1, 13, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreX")       1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteFLoadX")        1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #12
  {DBGFIELD("WriteFStoreY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #13
  {DBGFIELD("WriteFLoadY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #14
  {DBGFIELD("WriteMicrocoded")    1, false, false, false, 40, 1,  4, 1,  0, 0}, // #15
  {DBGFIELD("WriteFSign")         1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCRMW")        1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #17
  {DBGFIELD("WriteADCRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 1513, 2,  1, 1, 18, 2}, // #18
  {DBGFIELD("WriteADCLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 1513, 2,  1, 1, 20, 2}, // #19
  {DBGFIELD("WriteALURMW")        1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #20
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 1513, 2,  1, 1, 18, 1}, // #21
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #22
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 4, false, false, false, 1515, 3,  6, 1, 20, 1}, // #23
  {DBGFIELD("WriteFAdd64X")       3, false, false, false, 1518, 3,  3, 1,  0, 0}, // #24
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 1, false, false, false, 1521, 3, 14, 1, 20, 1}, // #25
  {DBGFIELD("WriteFAddX")         1, false, false, false, 1509, 2, 14, 1,  0, 0}, // #26
  {DBGFIELD("WriteNop")           1, false, false, false, 40, 1,  1, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 1, false, false, false, 1521, 3, 14, 1, 20, 1}, // #28
  {DBGFIELD("WriteFAdd64")        1, false, false, false, 1509, 2, 14, 1,  0, 0}, // #29
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 1, false, false, false, 1521, 3, 14, 1, 20, 1}, // #30
  {DBGFIELD("WriteFAdd")          1, false, false, false, 1509, 2, 14, 1,  0, 0}, // #31
  {DBGFIELD("WriteFAddLd")        1, false, false, false, 1521, 3, 14, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #33
  {DBGFIELD("WriteAESDecEnc")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #34
  {DBGFIELD("WriteAESIMCLd")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #35
  {DBGFIELD("WriteAESIMC")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #36
  {DBGFIELD("WriteAESKeyGenLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #37
  {DBGFIELD("WriteAESKeyGen")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #38
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #39
  {DBGFIELD("WriteFLogic")        1, false, false, false, 40, 1,  1, 1,  0, 0}, // #40
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #41
  {DBGFIELD("WriteBEXTR")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #42
  {DBGFIELD("WriteBEXTRLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #43
  {DBGFIELD("WriteALULd")         1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #44
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #45
  {DBGFIELD("WriteFBlend")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #46
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #47
  {DBGFIELD("WriteFVarBlend")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #48
  {DBGFIELD("WriteBLSLd")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #49
  {DBGFIELD("WriteBLS")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #50
  {DBGFIELD("WriteBSFLd")         10, false, false, false, 1524, 3, 19, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSF")           10, false, false, false, 1524, 3, 19, 1,  0, 0}, // #52
  {DBGFIELD("WriteBSRLd")         10, false, false, false, 1524, 3, 19, 1,  0, 0}, // #53
  {DBGFIELD("WriteBSR")           10, false, false, false, 1524, 3, 19, 1,  0, 0}, // #54
  {DBGFIELD("WriteBSWAP32")       1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #55
  {DBGFIELD("WriteBSWAP64")       1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestImmLd")  1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestRegLd")  1, false, false, false, 1411, 1,  9, 1,  0, 0}, // #58
  {DBGFIELD("WriteBitTest")       1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBitTestSetImmRMW") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #60
  {DBGFIELD("WriteBitTestSetRegRMW") 1, false, false, false, 1527, 1, 18, 1,  0, 0}, // #61
  {DBGFIELD("WriteBitTestSet")    1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #62
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #63
  {DBGFIELD("WriteBZHI")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #64
  {DBGFIELD("WriteLoad")          1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #65
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #66
  {DBGFIELD("WriteCMOV")          1, false, false, false, 40, 1,  1, 1,  0, 0}, // #67
  {DBGFIELD("WriteFCMOV")         1, false, false, false, 1411, 1,  9, 1,  0, 0}, // #68
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 1513, 2,  1, 1, 18, 1}, // #69
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 4, false, false, false, 1515, 3,  6, 1, 20, 1}, // #70
  {DBGFIELD("WriteFCmp64X")       3, false, false, false, 1518, 3,  3, 1,  0, 0}, // #71
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 4, false, false, false, 1515, 3,  6, 1, 20, 1}, // #72
  {DBGFIELD("WriteFCmpX")         3, false, false, false, 1518, 3,  3, 1,  0, 0}, // #73
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 1, false, false, false, 1521, 3, 14, 1, 20, 1}, // #74
  {DBGFIELD("WriteFCmp64")        1, false, false, false, 1509, 2, 14, 1,  0, 0}, // #75
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 1, false, false, false, 1521, 3, 14, 1, 20, 1}, // #76
  {DBGFIELD("WriteFCmp")          1, false, false, false, 1509, 2, 14, 1,  0, 0}, // #77
  {DBGFIELD("WriteCMPXCHG")       1, false, false, false, 1528, 1, 21, 1,  0, 0}, // #78
  {DBGFIELD("WriteFComXLd_ReadAfterVecLd") 5, false, false, false, 1529, 3,  7, 1, 20, 1}, // #79
  {DBGFIELD("WriteFComX")         4, false, false, false, 1532, 3,  9, 1,  0, 0}, // #80
  {DBGFIELD("WriteFCom")          1, false, false, false, 1535, 2, 14, 1,  0, 0}, // #81
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #82
  {DBGFIELD("WriteCRC32")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #83
  {DBGFIELD("WriteCvtI2PDLd")     4, false, false, false, 1537, 3,  2, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtI2PD")       3, false, false, false, 1515, 3,  6, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtI2PSLd")     4, false, false, false, 1537, 3,  6, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtI2PS")       3, false, false, false, 1515, 3,  3, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtPD2ILd")     5, false, false, false, 1540, 3,  2, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPD2I")       4, false, false, false, 1537, 3,  6, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPD2PSLd")    5, false, false, false, 1543, 3, 23, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPD2PS")      4, false, false, false, 1546, 3, 18, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPS2ILd")     4, false, false, false, 1537, 3,  6, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtPS2I")       3, false, false, false, 1515, 3,  3, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtPS2PDLd")    5, false, false, false, 1537, 3,  2, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtPS2PD")      4, false, false, false, 1515, 3,  6, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtSD2ILd")     4, false, false, false, 1529, 3,  9, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 3, false, false, false, 1540, 3,  2, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtSD2I")       3, false, false, false, 1540, 3,  2, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtSD2SSLd")    4, false, false, false, 1543, 3, 18, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 4, false, false, false, 1543, 3, 18, 1, 20, 1}, // #100
  {DBGFIELD("WriteCvtSD2SS")      3, false, false, false, 1529, 3,  7, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtI2SDLd")     3, false, false, false, 1537, 3,  6, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 3, false, false, false, 1537, 3,  6, 1, 20, 1}, // #103
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 3, false, false, false, 1515, 3,  3, 1,  0, 1}, // #104
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 3, false, false, false, 1515, 3,  3, 1,  6, 1}, // #105
  {DBGFIELD("WriteCvtI2SSLd")     1, false, false, false, 1515, 3,  6, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 1, false, false, false, 1515, 3,  6, 1, 20, 1}, // #107
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 3, false, false, false, 1515, 3,  3, 1,  0, 1}, // #108
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 3, false, false, false, 1515, 3,  3, 1,  6, 1}, // #109
  {DBGFIELD("WriteCvtSS2SDLd")    4, false, false, false, 1537, 3,  6, 1,  0, 0}, // #110
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 4, false, false, false, 1537, 3,  6, 1, 20, 1}, // #111
  {DBGFIELD("WriteCvtSS2SD")      3, false, false, false, 1515, 3,  3, 1,  0, 0}, // #112
  {DBGFIELD("WriteCvtSS2ILd")     4, false, false, false, 1532, 3,  9, 1,  0, 0}, // #113
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 3, false, false, false, 1540, 3,  2, 1,  0, 0}, // #114
  {DBGFIELD("WriteCvtSS2I")       3, false, false, false, 1540, 3,  2, 1,  0, 0}, // #115
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 12, false, false, false, 1549, 3, 53, 1, 18, 2}, // #116
  {DBGFIELD("WriteDiv16")         12, false, false, false, 1549, 3, 53, 1,  0, 0}, // #117
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 12, false, false, false, 1549, 3, 53, 1, 18, 2}, // #118
  {DBGFIELD("WriteDiv32")         12, false, false, false, 1549, 3, 53, 1,  0, 0}, // #119
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 38, false, false, false, 1552, 3, 54, 1, 18, 2}, // #120
  {DBGFIELD("WriteDiv64")         38, false, false, false, 1552, 3, 54, 1,  0, 0}, // #121
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 9, false, false, false, 1555, 3, 55, 1, 18, 2}, // #122
  {DBGFIELD("WriteDiv8")          9, false, false, false, 1549, 3, 53, 1,  0, 0}, // #123
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 7, false, false, false, 1558, 3, 56, 1, 20, 1}, // #124
  {DBGFIELD("WriteFDiv64X")       6, false, false, false, 1558, 3, 56, 1,  0, 0}, // #125
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 7, false, false, false, 1561, 3, 57, 1, 20, 1}, // #126
  {DBGFIELD("WriteFDivX")         6, false, false, false, 1561, 3, 57, 1,  0, 0}, // #127
  {DBGFIELD("WriteFDivLd")        4, false, false, false, 1564, 3, 58, 1,  0, 0}, // #128
  {DBGFIELD("WriteFDiv")          3, false, false, false, 1564, 3, 58, 1,  0, 0}, // #129
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 4, false, false, false, 1567, 3, 51, 1, 20, 1}, // #130
  {DBGFIELD("WriteFDiv64")        3, false, false, false, 1567, 3, 51, 1,  0, 0}, // #131
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 4, false, false, false, 1564, 3, 58, 1, 20, 1}, // #132
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #133
  {DBGFIELD("WriteDPPD")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #134
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #135
  {DBGFIELD("WriteDPPS")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #136
  {DBGFIELD("WriteStore")         1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #137
  {DBGFIELD("WriteVecExtractSt")  1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #138
  {DBGFIELD("WriteVecExtract")    1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #139
  {DBGFIELD("WriteVecALUX")       1, false, false, false, 40, 1,  1, 1,  0, 0}, // #140
  {DBGFIELD("WriteFComLd")        1, false, false, false, 1535, 2, 14, 1,  0, 0}, // #141
  {DBGFIELD("WriteEMMS")          1, false, false, false, 1536, 1, 14, 1,  0, 0}, // #142
  {DBGFIELD("WriteFLDC")          1, false, false, false, 1520, 1,  7, 1,  0, 0}, // #143
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #144
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 6, false, false, false, 1532, 3,  9, 1, 20, 1}, // #145
  {DBGFIELD("WriteFHAdd")         5, false, false, false, 1540, 3,  2, 1,  0, 0}, // #146
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 29, false, false, false, 1567, 3, 51, 1, 18, 2}, // #147
  {DBGFIELD("WriteIDiv16")        29, false, false, false, 1567, 3, 51, 1,  0, 0}, // #148
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 29, false, false, false, 1567, 3, 51, 1, 18, 2}, // #149
  {DBGFIELD("WriteIDiv32")        29, false, false, false, 1567, 3, 51, 1,  0, 0}, // #150
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 60, false, false, false, 1552, 3, 54, 1, 18, 2}, // #151
  {DBGFIELD("WriteIDiv64")        60, false, false, false, 1552, 3, 54, 1,  0, 0}, // #152
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 26, false, false, false, 1567, 3, 51, 1, 18, 2}, // #153
  {DBGFIELD("WriteIDiv8")         26, false, false, false, 1567, 3, 51, 1,  0, 0}, // #154
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 1540, 3,  2, 1, 18, 2}, // #155
  {DBGFIELD("WriteIMul16")        4, false, false, false, 1537, 3,  6, 1,  0, 0}, // #156
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 3, false, false, false, 1537, 3,  6, 1, 20, 1}, // #157
  {DBGFIELD("WriteIMul16ImmLd")   3, false, false, false, 1537, 3,  6, 1,  0, 0}, // #158
  {DBGFIELD("WriteIMul16Reg")     2, false, false, false, 1515, 3,  3, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul16Imm")     2, false, false, false, 1515, 3,  3, 1,  0, 0}, // #160
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 1537, 3,  6, 1, 18, 2}, // #161
  {DBGFIELD("WriteIMul32")        3, false, false, false, 1515, 3,  3, 1,  0, 0}, // #162
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 1, false, false, false, 1535, 2, 14, 1, 20, 1}, // #163
  {DBGFIELD("WriteIMul32ImmLd")   1, false, false, false, 1535, 2, 14, 1,  0, 0}, // #164
  {DBGFIELD("WriteIMul32Reg")     1, false, false, false, 1535, 2, 14, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul32Imm")     1, false, false, false, 1535, 2, 14, 1,  0, 0}, // #166
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 1543, 3, 23, 1, 18, 2}, // #167
  {DBGFIELD("WriteIMul64")        8, false, false, false, 1543, 3, 23, 1,  0, 0}, // #168
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 6, false, false, false, 1543, 3, 23, 1, 20, 1}, // #169
  {DBGFIELD("WriteIMul64ImmLd")   7, false, false, false, 1570, 3, 10, 1,  0, 0}, // #170
  {DBGFIELD("WriteIMul64Reg")     6, false, false, false, 1543, 3, 23, 1,  0, 0}, // #171
  {DBGFIELD("WriteIMul64Imm")     7, false, false, false, 1570, 3, 10, 1,  0, 0}, // #172
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 1537, 3,  6, 1, 18, 2}, // #173
  {DBGFIELD("WriteIMul8")         3, false, false, false, 1537, 3,  6, 1,  0, 0}, // #174
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #175
  {DBGFIELD("WriteFShuffle")      1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #176
  {DBGFIELD("WriteVecLogicX")     1, false, false, false, 40, 1,  1, 1,  0, 0}, // #177
  {DBGFIELD("WriteShuffle")       1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #178
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, false, 80, 1, 13, 1,  0, 0}, // #179
  {DBGFIELD("WriteVecLoadX")      1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #180
  {DBGFIELD("WriteLDMXCSR")       4, false, false, false, 1518, 3, 14, 1,  0, 0}, // #181
  {DBGFIELD("WriteFLD0")          1, false, false, false, 40, 1,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteFLD1")          1, false, false, false, 1573, 1,  3, 1,  0, 0}, // #183
  {DBGFIELD("WriteLEA")           1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #184
  {DBGFIELD("WriteFence")         1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteLZCNTLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #186
  {DBGFIELD("WriteLZCNT")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #187
  {DBGFIELD("WriteVecStoreX")     1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #188
  {DBGFIELD("WriteVecStore")      1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, false, 1574, 2,  5, 1,  0, 0}, // #190
  {DBGFIELD("WriteVecLoad")       1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #191
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecMoveX")      1, false, false, false, 40, 1,  1, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecStoreNT")    1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #194
  {DBGFIELD("WriteVecMove")       1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #195
  {DBGFIELD("WriteVecALULd")      1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #196
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #197
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #198
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #199
  {DBGFIELD("WriteVecLogic")      1, false, false, false, 40, 1,  1, 1,  0, 0}, // #200
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, false, 1576, 3,  8, 1, 20, 1}, // #201
  {DBGFIELD("WritePHAdd")         3, false, false, false, 1579, 3,  5, 1,  0, 0}, // #202
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #203
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 1, false, false, false, 1513, 2,  1, 1,  6, 1}, // #204
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 1, false, false, false, 1513, 2,  8, 1, 20, 1}, // #205
  {DBGFIELD("WriteVecIMul")       1, false, false, false, 1513, 2,  8, 1,  0, 0}, // #206
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, false, 1574, 2,  5, 1,  0, 0}, // #207
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 1, false, false, false, 1513, 2,  8, 1, 20, 1}, // #208
  {DBGFIELD("WritePSADBW")        1, false, false, false, 1513, 2,  8, 1,  0, 0}, // #209
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #210
  {DBGFIELD("WriteVarShuffle")    1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #211
  {DBGFIELD("WriteShuffleLd")     1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #212
  {DBGFIELD("WriteVecShiftImm")   1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 3, false, false, false, 1582, 3,  5, 1, 20, 1}, // #214
  {DBGFIELD("WriteVecShift")      2, false, false, false, 1521, 3, 13, 1,  0, 0}, // #215
  {DBGFIELD("WriteFMoveX")        1, false, false, false, 40, 1,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteFShuffleLd")    1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #217
  {DBGFIELD("WriteFStore")        1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #218
  {DBGFIELD("WriteFMOVMSK")       1, false, false, false, 1574, 2,  5, 1,  0, 0}, // #219
  {DBGFIELD("WriteVecLoadNT")     1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #220
  {DBGFIELD("WriteStoreNT")       1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #221
  {DBGFIELD("WriteFStoreNTX")     1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #222
  {DBGFIELD("WriteFStoreNT")      1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #223
  {DBGFIELD("WriteFLoad")         1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #224
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #225
  {DBGFIELD("WriteMPSAD")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #226
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 7, false, false, false, 1529, 3,  7, 1, 20, 1}, // #227
  {DBGFIELD("WriteFMul64X")       6, false, false, false, 1532, 3,  9, 1,  0, 0}, // #228
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 1, false, false, false, 1585, 2, 14, 1, 20, 1}, // #229
  {DBGFIELD("WriteFMulX")         1, false, false, false, 1585, 2, 14, 1,  0, 0}, // #230
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 1, false, false, false, 1585, 2, 14, 1, 20, 1}, // #231
  {DBGFIELD("WriteFMul64")        1, false, false, false, 1585, 2, 14, 1,  0, 0}, // #232
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 1, false, false, false, 1585, 2,  8, 1, 20, 1}, // #233
  {DBGFIELD("WriteFMul")          1, false, false, false, 1585, 2,  8, 1,  0, 0}, // #234
  {DBGFIELD("WriteMULX32Ld")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #235
  {DBGFIELD("WriteMULX32")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #236
  {DBGFIELD("WriteIMulHLd_WriteMULX32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #237
  {DBGFIELD("WriteIMulH_WriteMULX32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #238
  {DBGFIELD("WriteMULX64Ld")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #239
  {DBGFIELD("WriteMULX64")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #240
  {DBGFIELD("WriteIMulHLd_WriteMULX64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #241
  {DBGFIELD("WriteIMulH_WriteMULX64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #242
  {DBGFIELD("WriteFMulLd")        1, false, false, false, 1585, 2,  8, 1,  0, 0}, // #243
  {DBGFIELD("WriteVecALUXLd")     1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #244
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #245
  {DBGFIELD("WriteShuffleX")      1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #246
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #247
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #248
  {DBGFIELD("WriteVarBlend")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #249
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #250
  {DBGFIELD("WriteBlend")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #251
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #252
  {DBGFIELD("WriteCLMul")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #253
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #254
  {DBGFIELD("WritePCmpEStrI")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #255
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #256
  {DBGFIELD("WritePCmpEStrM")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #257
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #258
  {DBGFIELD("WritePCmpIStrI")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #259
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #260
  {DBGFIELD("WritePCmpIStrM")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #261
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 4, false, false, false, 1537, 3,  6, 1, 20, 1}, // #262
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 4, false, false, false, 1540, 3,  2, 1, 20, 1}, // #263
  {DBGFIELD("WritePHAddX")        3, false, false, false, 1537, 3,  6, 1,  0, 0}, // #264
  {DBGFIELD("WritePHMINPOSLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #265
  {DBGFIELD("WritePHMINPOS")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #266
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 4, false, false, false, 1537, 3,  6, 1, 20, 1}, // #267
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 1, false, false, false, 1585, 2, 14, 1, 20, 1}, // #268
  {DBGFIELD("WriteVecIMulX")      1, false, false, false, 1585, 2, 14, 1,  0, 0}, // #269
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, false, 1574, 2,  5, 1,  0, 0}, // #270
  {DBGFIELD("WriteShuffleXLd")    1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #271
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #272
  {DBGFIELD("WritePMULLD")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #273
  {DBGFIELD("WriteCopy")          2, false, false, false, 1585, 2, 13, 1,  0, 0}, // #274
  {DBGFIELD("WritePOPCNTLd")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #275
  {DBGFIELD("WritePOPCNT")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #276
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 1, false, false, false, 1585, 2, 14, 1, 20, 1}, // #277
  {DBGFIELD("WritePSADBWX")       1, false, false, false, 1585, 2, 14, 1,  0, 0}, // #278
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 5, false, false, false, 1576, 3, 14, 1, 20, 1}, // #279
  {DBGFIELD("WriteVarShuffleX")   4, false, false, false, 1579, 3,  8, 1,  0, 0}, // #280
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #281
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 3, false, false, false, 1582, 3,  5, 1, 20, 1}, // #282
  {DBGFIELD("WriteVecShiftX")     2, false, false, false, 1521, 3, 13, 1,  0, 0}, // #283
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #284
  {DBGFIELD("WriteVecTest")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #285
  {DBGFIELD("WriteRotateLd_WriteRMW") 2, false, false, false, 1585, 2, 59, 2,  0, 0}, // #286
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 2, false, false, false, 1585, 2, 59, 2,  0, 0}, // #287
  {DBGFIELD("WriteRotate")        1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #288
  {DBGFIELD("WriteRotateCL")      1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #289
  {DBGFIELD("WriteFRcpXLd")       6, false, false, false, 1529, 3,  7, 1,  0, 0}, // #290
  {DBGFIELD("WriteFRcpX")         5, false, false, false, 1532, 3,  9, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRcpLd")        1, false, false, false, 1587, 2,  8, 1,  0, 0}, // #292
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 1, false, false, false, 1587, 2,  8, 1, 20, 1}, // #293
  {DBGFIELD("WriteFRcp")          1, false, false, false, 1587, 2,  8, 1,  0, 0}, // #294
  {DBGFIELD("WriteRMW")           1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #295
  {DBGFIELD("WriteShiftLd")       1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #296
  {DBGFIELD("WriteShift")         1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #297
  {DBGFIELD("WriteFRndLd")        1, false, false, false, 1535, 2, 14, 1,  0, 0}, // #298
  {DBGFIELD("WriteFRnd")          1, false, false, false, 1535, 2, 14, 1,  0, 0}, // #299
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 1, false, false, false, 1535, 2, 14, 1, 20, 1}, // #300
  {DBGFIELD("WriteFRsqrtXLd")     6, false, false, false, 1529, 3,  7, 1,  0, 0}, // #301
  {DBGFIELD("WriteFRsqrtX")       5, false, false, false, 1532, 3,  9, 1,  0, 0}, // #302
  {DBGFIELD("WriteFRsqrtLd")      1, false, false, false, 1587, 2,  8, 1,  0, 0}, // #303
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 1, false, false, false, 1587, 2,  8, 1, 20, 1}, // #304
  {DBGFIELD("WriteFRsqrt")        1, false, false, false, 1587, 2,  8, 1,  0, 0}, // #305
  {DBGFIELD("WriteShiftLd_WriteRMW") 2, false, false, false, 1585, 2, 59, 2,  0, 0}, // #306
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 2, false, false, false, 1585, 2, 59, 2,  0, 0}, // #307
  {DBGFIELD("WriteShiftCL")       1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #308
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 1513, 2,  1, 1, 18, 1}, // #309
  {DBGFIELD("WriteSETCCStore")    1, false, false, false, 80, 1, 13, 1,  0, 0}, // #310
  {DBGFIELD("WriteSETCC")         1, false, false, false, 40, 1,  1, 1,  0, 0}, // #311
  {DBGFIELD("WriteSHDmrcl")       1, false, false, false, 369, 1,  8, 1,  0, 0}, // #312
  {DBGFIELD("WriteSHDmri")        1, false, false, false, 369, 1,  8, 1,  0, 0}, // #313
  {DBGFIELD("WriteSHDrrcl")       1, false, false, false, 80, 1, 13, 1,  0, 0}, // #314
  {DBGFIELD("WriteFSqrt64XLd")    6, false, false, false, 1558, 3, 56, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrt64X")      5, false, false, false, 1558, 3, 56, 1,  0, 0}, // #316
  {DBGFIELD("WriteFSqrtXLd")      6, false, false, false, 1561, 3, 57, 1,  0, 0}, // #317
  {DBGFIELD("WriteFSqrtX")        5, false, false, false, 1561, 3, 57, 1,  0, 0}, // #318
  {DBGFIELD("WriteFSqrt64Ld")     4, false, false, false, 1567, 3, 51, 1,  0, 0}, // #319
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 4, false, false, false, 1567, 3, 51, 1, 20, 1}, // #320
  {DBGFIELD("WriteFSqrt64")       3, false, false, false, 1567, 3, 51, 1,  0, 0}, // #321
  {DBGFIELD("WriteFSqrtLd")       4, false, false, false, 1564, 3, 58, 1,  0, 0}, // #322
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 4, false, false, false, 1564, 3, 58, 1, 20, 1}, // #323
  {DBGFIELD("WriteFSqrt")         3, false, false, false, 1564, 3, 58, 1,  0, 0}, // #324
  {DBGFIELD("WriteFSqrt80")       1, false, false, false, 1589, 2, 61, 1,  0, 0}, // #325
  {DBGFIELD("WriteSTMXCSR")       4, false, false, false, 1591, 3, 21, 1,  0, 0}, // #326
  {DBGFIELD("WriteTZCNTLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #327
  {DBGFIELD("WriteTZCNT")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #328
  {DBGFIELD("WriteFMAZLd")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #329
  {DBGFIELD("WriteFMALd")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #330
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #331
  {DBGFIELD("WriteFAdd64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #332
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteFAdd64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #335
  {DBGFIELD("WriteFAddY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #336
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteFAddZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD("WriteShuffleY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteShuffleZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #343
  {DBGFIELD("WriteFLogicY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #344
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #345
  {DBGFIELD("WriteFLogicZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #346
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #347
  {DBGFIELD("WriteFVarBlendY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #348
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #349
  {DBGFIELD("WriteFVarBlendZ")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #351
  {DBGFIELD("WriteFBlendY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #352
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #353
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #354
  {DBGFIELD("WriteShuffle256Ld")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #355
  {DBGFIELD("WriteShuffle256")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #356
  {DBGFIELD("WriteShuffleYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD("WriteFShuffle256")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #358
  {DBGFIELD("WriteFShuffle256Ld") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #359
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #360
  {DBGFIELD("WriteFCmp64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #361
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #362
  {DBGFIELD("WriteFCmpY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #363
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #364
  {DBGFIELD("WriteFCmpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("WriteVarShuffle256Ld") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #366
  {DBGFIELD("WriteVarShuffle256") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #367
  {DBGFIELD("WriteCvtI2PDYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #368
  {DBGFIELD("WriteCvtI2PDY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #369
  {DBGFIELD("WriteCvtI2PDZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #370
  {DBGFIELD("WriteCvtI2PDZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD("WriteCvtI2PSYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #372
  {DBGFIELD("WriteCvtI2PSY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #373
  {DBGFIELD("WriteCvtI2PSZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #374
  {DBGFIELD("WriteCvtI2PSZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 5, false, false, false, 1543, 3, 23, 1, 20, 1}, // #376
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #377
  {DBGFIELD("WriteCvtPD2PSY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #378
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtPD2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteCvtPD2PSYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #381
  {DBGFIELD("WriteCvtPD2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #382
  {DBGFIELD("WriteCvtPD2IYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #383
  {DBGFIELD("WriteCvtPD2IY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #384
  {DBGFIELD("WriteCvtPD2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #385
  {DBGFIELD("WriteCvtPD2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteCvtPS2IYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2IY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2PDYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PDY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PDZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PDZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtPH2PSYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #395
  {DBGFIELD("WriteCvtPH2PSY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #396
  {DBGFIELD("WriteCvtPH2PSLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #397
  {DBGFIELD("WriteCvtPH2PS")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #398
  {DBGFIELD("WriteCvtPH2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteCvtPH2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD("WriteCvtPS2PHYSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #401
  {DBGFIELD("WriteCvtPS2PHY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #402
  {DBGFIELD("WriteCvtPS2PHSt")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #403
  {DBGFIELD("WriteCvtPS2PH")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WriteCvtPS2PHZSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteCvtPS2PHZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #406
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 4, false, false, false, 1529, 3,  9, 1, 20, 1}, // #407
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 4, false, false, false, 1532, 3,  9, 1, 20, 1}, // #408
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #409
  {DBGFIELD("WritePSADBWY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #410
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WritePSADBWZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #412
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #413
  {DBGFIELD("WriteFDiv64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #414
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WriteFDiv64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #417
  {DBGFIELD("WriteFDivY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #418
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteFDivZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #420
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #421
  {DBGFIELD("WriteFMAX")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #422
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #423
  {DBGFIELD("WriteFMAY")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #424
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteFMAZ")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #426
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #427
  {DBGFIELD("WriteDPPSY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #428
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #429
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #430
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #431
  {DBGFIELD("WriteFMALd_ReadAfterVecLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #432
  {DBGFIELD("WriteFMA")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #433
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #434
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #435
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #436
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #437
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #438
  {DBGFIELD("WriteFRndY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #439
  {DBGFIELD("WriteLoad_WriteVecMaskedGatherWriteback") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #440
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteFRndZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #443
  {DBGFIELD("WriteVecIMulY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #444
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #445
  {DBGFIELD("WriteVecIMulZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("WriteVecALUY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("WriteVecALUZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #450
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #451
  {DBGFIELD("WriteFHAddY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #452
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #453
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #454
  {DBGFIELD("WriteVecLoadY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #455
  {DBGFIELD("WriteFMaskedStore64Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #456
  {DBGFIELD("WriteFMaskedLoadY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #457
  {DBGFIELD("WriteFMaskedStore64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #458
  {DBGFIELD("WriteFMaskedLoad")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #459
  {DBGFIELD("WriteFMaskedStore32Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #460
  {DBGFIELD("WriteFMaskedStore32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #461
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #462
  {DBGFIELD("WriteFCmp64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #463
  {DBGFIELD("WriteFMoveY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #464
  {DBGFIELD("WriteFMoveZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #465
  {DBGFIELD("WriteFShuffleYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #466
  {DBGFIELD("WriteFShuffleY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #467
  {DBGFIELD("WriteFShuffleZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteFShuffleZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #469
  {DBGFIELD("WriteVecStoreY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #470
  {DBGFIELD("WriteVecMoveY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("WriteVecMoveZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #472
  {DBGFIELD("WriteVecLoadNTY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #473
  {DBGFIELD("WriteVecStoreNTY")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #474
  {DBGFIELD("WriteFStoreNTY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #475
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #476
  {DBGFIELD("WriteMPSADY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #477
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #478
  {DBGFIELD("WriteFMul64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #479
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteFMul64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #482
  {DBGFIELD("WriteFMulY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #483
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #484
  {DBGFIELD("WriteFMulZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #485
  {DBGFIELD("WriteVecALUYLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("WriteVecALUZLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #488
  {DBGFIELD("WriteVecLogicY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #489
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteVecLogicZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #492
  {DBGFIELD("WriteBlendY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #493
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #494
  {DBGFIELD("WriteVarBlendY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #495
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteVarBlendZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #498
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #499
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #500
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #501
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 1513, 2,  1, 1, 20, 2}, // #502
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 1513, 2,  1, 1, 22, 2}, // #503
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #504
  {DBGFIELD("WriteFVarShuffle256") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #505
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #506
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #507
  {DBGFIELD("WriteFVarShuffleY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #508
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #509
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #510
  {DBGFIELD("WriteFVarShuffle")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #511
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #512
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #513
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #514
  {DBGFIELD("WriteFVarShuffleZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #515
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #516
  {DBGFIELD("WritePHAddY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #517
  {DBGFIELD("WriteVecInsert")     1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #518
  {DBGFIELD("WriteVecIMulXLd")    1, false, false, false, 1585, 2, 14, 1,  0, 0}, // #519
  {DBGFIELD("WriteVecIMulYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #520
  {DBGFIELD("WriteVecIMulZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #521
  {DBGFIELD("WriteVecMaskedStore32Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #522
  {DBGFIELD("WriteVecMaskedLoadY") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #523
  {DBGFIELD("WriteVecMaskedStore32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #524
  {DBGFIELD("WriteVecMaskedLoad") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #525
  {DBGFIELD("WriteVecMaskedStore64Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #526
  {DBGFIELD("WriteVecMaskedStore64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #527
  {DBGFIELD("WriteVPMOV256Ld")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #528
  {DBGFIELD("WriteVPMOV256")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #529
  {DBGFIELD("WriteVecMOVMSKY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #530
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #531
  {DBGFIELD("WritePMULLDY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #532
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WritePMULLDZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #534
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 5, false, false, false, 1576, 3, 14, 1, 20, 2}, // #535
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 5, false, false, false, 1576, 3, 14, 1, 22, 2}, // #536
  {DBGFIELD("WriteVecShiftImmXLd") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #537
  {DBGFIELD("WriteVecShiftImmYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #538
  {DBGFIELD("WriteVecShiftImmY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #539
  {DBGFIELD("WriteVecShiftImmZLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #540
  {DBGFIELD("WriteVecShiftImmZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #541
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("WriteVarVecShift")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #543
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #544
  {DBGFIELD("WriteVarVecShiftY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #545
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #546
  {DBGFIELD("WriteVarVecShiftZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #547
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #548
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteVarShuffleY")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #550
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #551
  {DBGFIELD("WriteVarShuffleZ")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #552
  {DBGFIELD("WriteShuffleZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #553
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #554
  {DBGFIELD("WriteVecShiftY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #555
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteVecShiftZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #558
  {DBGFIELD("WriteVecTestY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #559
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 6, false, false, false, 1529, 3,  7, 1, 20, 1}, // #560
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #561
  {DBGFIELD("WriteFRcpY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #562
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #563
  {DBGFIELD("WriteFRcpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #564
  {DBGFIELD("WriteFRcpYLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #565
  {DBGFIELD("WriteFRndYLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #566
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 6, false, false, false, 1529, 3,  7, 1, 20, 1}, // #567
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #568
  {DBGFIELD("WriteFRsqrtY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #569
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #570
  {DBGFIELD("WriteFRsqrtZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #571
  {DBGFIELD("WriteFRsqrtYLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #572
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #573
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #574
  {DBGFIELD("WriteFSqrt64YLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #575
  {DBGFIELD("WriteFSqrt64Y")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #576
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 6, false, false, false, 1558, 3, 56, 1, 20, 1}, // #577
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #578
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #579
  {DBGFIELD("WriteFSqrt64Z")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #580
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 6, false, false, false, 1561, 3, 57, 1, 20, 1}, // #581
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #582
  {DBGFIELD("WriteFSqrtY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #583
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #584
  {DBGFIELD("WriteFSqrtZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #585
  {DBGFIELD("WriteFSqrtYLd")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #586
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #587
  {DBGFIELD("WriteFTestY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #588
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #589
  {DBGFIELD("WriteFTest")         1, false, false, false, 40, 1,  1, 1,  0, 0}, // #590
  {DBGFIELD("WriteALULd_WriteRMW") 2, false, false, false, 1585, 2, 59, 2,  0, 0}, // #591
  {DBGFIELD("WriteXCHG")          1, false, false, false, 80, 1, 13, 1,  0, 0}, // #592
  {DBGFIELD("COPY")               1, false, false, false, 40, 1,  1, 1,  0, 0}, // #593
  {DBGFIELD("XAM_F")              1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #594
  {DBGFIELD("LD_Frr")             1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #595
  {DBGFIELD("MOVSX64rr32")        1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #596
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #597
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #598
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #599
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #600
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #601
  {DBGFIELD("FCOMPP")             1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #602
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #603
  {DBGFIELD("MMX_CVTPI2PSrr")     1, false, false, false, 1594, 2, 14, 1,  0, 0}, // #604
  {DBGFIELD("MMX_CVTPI2PSrm")     1, false, false, false, 1594, 2, 14, 1,  0, 0}, // #605
  {DBGFIELD("MMX_CVTPS2PIrr_MMX_CVTTPS2PIrr") 1, false, false, false, 1594, 2, 14, 1,  0, 0}, // #606
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, false, 1521, 3,  1, 1,  0, 0}, // #607
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, false, 1521, 3,  1, 1,  0, 0}, // #608
  {DBGFIELD("XCH_F")              1, false, false, false, 1521, 3,  1, 1,  0, 0}, // #609
  {DBGFIELD("RETI16_RETI32_RETI64_IRET_IRET16_IRET32_IRET64") 1, false, false, false, 1521, 3,  1, 1,  0, 0}, // #610
  {DBGFIELD("MMX_CVTPS2PIrm_MMX_CVTTPS2PIrm") 1, false, false, false, 1518, 3, 14, 1,  0, 0}, // #611
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 1, false, false, false, 1518, 3, 14, 1,  0, 0}, // #612
  {DBGFIELD("CVTSI642SDrm")       1, false, false, false, 1515, 3,  6, 1,  0, 0}, // #613
  {DBGFIELD("CVTSI642SDrm_Int")   1, false, false, false, 1515, 3,  6, 1,  0, 0}, // #614
  {DBGFIELD("CVTSI642SSrr")       4, false, false, false, 1540, 3,  6, 1,  0, 0}, // #615
  {DBGFIELD("CVTSI642SSrr_Int")   4, false, false, false, 1540, 3,  6, 1,  0, 0}, // #616
  {DBGFIELD("CVTSI642SSrm")       4, false, false, false, 1540, 3,  6, 1,  0, 0}, // #617
  {DBGFIELD("CVTSI642SSrm_Int")   4, false, false, false, 1540, 3,  6, 1,  0, 0}, // #618
  {DBGFIELD("CVTSS2SI64rr_CVTTSS2SI64rr") 4, false, false, false, 1532, 3,  9, 1,  0, 0}, // #619
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 4, false, false, false, 1532, 3,  9, 1,  0, 0}, // #620
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 5, false, false, false, 1546, 3,  7, 1,  0, 0}, // #621
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #622
  {DBGFIELD("LFENCE")             1, false, false, false, 40, 1,  1, 1,  0, 0}, // #623
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #624
  {DBGFIELD("LEAVE_LEAVE64")      1, false, false, false, 80, 1, 13, 1,  0, 0}, // #625
  {DBGFIELD("POP16r")             1, false, false, false, 80, 1, 13, 1,  0, 0}, // #626
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #627
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #628
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #629
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #630
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, false, 80, 1, 13, 1,  0, 0}, // #631
  {DBGFIELD("MMX_PADDQrr_MMX_PSUBQrr") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #632
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #633
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64_MASKMOVDQUX32") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #634
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  1, false, false, false, 80, 1, 13, 1,  0, 0}, // #635
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, false, 80, 1, 13, 1,  0, 0}, // #636
  {DBGFIELD("CLD")                1, false, false, false, 100, 1,  5, 1,  0, 0}, // #637
  {DBGFIELD("LDDQUrm")            1, false, false, false, 100, 1,  5, 1,  0, 0}, // #638
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, false, 100, 1,  5, 1,  0, 0}, // #639
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 1, false, false, false, 100, 1,  5, 1,  0, 0}, // #640
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 1, false, false, false, 100, 1,  5, 1,  0, 0}, // #641
  {DBGFIELD("PHADDDrr_PHSUBDrr")  1, false, false, false, 100, 1,  5, 1,  0, 0}, // #642
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, false, 100, 1,  5, 1,  0, 0}, // #643
  {DBGFIELD("MMX_PADDQrm_MMX_PSUBQrm") 1, false, false, false, 100, 1,  5, 1,  0, 0}, // #644
  {DBGFIELD("MOVDQUrm")           1, false, false, false, 100, 1,  5, 1,  0, 0}, // #645
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, false, 100, 1,  5, 1,  0, 0}, // #646
  {DBGFIELD("PADDQrm_PSUBQrm")    1, false, false, false, 100, 1,  5, 1,  0, 0}, // #647
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, false, 369, 1,  8, 1,  0, 0}, // #648
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   1, false, false, false, 369, 1,  8, 1,  0, 0}, // #649
  {DBGFIELD("LD_F80m")            1, false, false, false, 369, 1,  8, 1,  0, 0}, // #650
  {DBGFIELD("PHADDDrm_PHSUBDrm")  1, false, false, false, 369, 1,  8, 1,  0, 0}, // #651
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 1, false, false, false, 369, 1,  8, 1,  0, 0}, // #652
  {DBGFIELD("FLDCW16m")           1, false, false, false, 1536, 1, 14, 1,  0, 0}, // #653
  {DBGFIELD("ST_FP80m")           1, false, false, false, 1536, 1, 14, 1,  0, 0}, // #654
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 1, false, false, false, 1536, 1, 14, 1,  0, 0}, // #655
  {DBGFIELD("CMPXCHG8rm")         1, false, false, false, 1573, 1,  3, 1,  0, 0}, // #656
  {DBGFIELD("INTO")               1, false, false, false, 1573, 1,  3, 1,  0, 0}, // #657
  {DBGFIELD("XLAT")               1, false, false, false, 1573, 1,  3, 1,  0, 0}, // #658
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 1, false, false, false, 1573, 1,  3, 1,  0, 0}, // #659
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, false, 1573, 1,  3, 1,  0, 0}, // #660
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 1, false, false, false, 1573, 1,  3, 1,  0, 0}, // #661
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 1, false, false, false, 1573, 1,  3, 1,  0, 0}, // #662
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 1, false, false, false, 1573, 1,  3, 1,  0, 0}, // #663
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 1, false, false, false, 1573, 1,  3, 1,  0, 0}, // #664
  {DBGFIELD("AAD8i8")             1, false, false, false, 191, 1,  6, 1,  0, 0}, // #665
  {DBGFIELD("LOOPE")              1, false, false, false, 1578, 1,  2, 1,  0, 0}, // #666
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, false, 1578, 1,  2, 1,  0, 0}, // #667
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 1, false, false, false, 1578, 1,  2, 1,  0, 0}, // #668
  {DBGFIELD("FNSTCW16m")          1, false, false, false, 1578, 1,  2, 1,  0, 0}, // #669
  {DBGFIELD("POPA16_POPA32")      1, false, false, false, 1411, 1,  9, 1,  0, 0}, // #670
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, false, 1411, 1,  9, 1,  0, 0}, // #671
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 1, false, false, false, 1411, 1,  9, 1,  0, 0}, // #672
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 1, false, false, false, 1411, 1,  9, 1,  0, 0}, // #673
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, false, 1411, 1,  9, 1,  0, 0}, // #674
  {DBGFIELD("CMPXCHG8rr")         1, false, false, false, 1411, 1,  9, 1,  0, 0}, // #675
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80") 1, false, false, false, 1411, 1,  9, 1,  0, 0}, // #676
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, false, 1527, 1, 18, 1,  0, 0}, // #677
  {DBGFIELD("AAA_AAS")            1, false, false, false, 1596, 1, 22, 1,  0, 0}, // #678
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 1, false, false, false, 1539, 1, 10, 1,  0, 0}, // #679
  {DBGFIELD("LOOPNE")             1, false, false, false, 1597, 1, 17, 1,  0, 0}, // #680
  {DBGFIELD("PAUSE")              1, false, false, false, 1597, 1, 17, 1,  0, 0}, // #681
  {DBGFIELD("CMPXCHG8B")          1, false, false, false, 1534, 1, 31, 1,  0, 0}, // #682
  {DBGFIELD("DAA")                1, false, false, false, 1534, 1, 31, 1,  0, 0}, // #683
  {DBGFIELD("LOOP")               1, false, false, false, 1534, 1, 31, 1,  0, 0}, // #684
  {DBGFIELD("DAS")                1, false, false, false, 1531, 1, 12, 1,  0, 0}, // #685
  {DBGFIELD("AAM8i8")             1, false, false, false, 1598, 1, 37, 1,  0, 0}, // #686
  {DBGFIELD("STD")                1, false, false, false, 1598, 1, 37, 1,  0, 0}, // #687
  {DBGFIELD("CMPXCHG16B")         1, false, false, false, 1548, 1, 44, 1,  0, 0}, // #688
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, false, 1599, 1, 36, 1,  0, 0}, // #689
  {DBGFIELD("FNCLEX_FXTRACT")     1, false, false, false, 1600, 1, 11, 1,  0, 0}, // #690
  {DBGFIELD("POPF32_POPF64")      1, false, false, false, 1601, 1, 62, 1,  0, 0}, // #691
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, false, 1602, 1, 15, 1,  0, 0}, // #692
  {DBGFIELD("RDTSC_RDTSCP")       1, false, false, false, 1593, 1, 47, 1,  0, 0}, // #693
  {DBGFIELD("ENTER")              1, false, false, false, 1526, 1, 63, 1,  0, 0}, // #694
  {DBGFIELD("POPF16")             1, false, false, false, 1526, 1, 63, 1,  0, 0}, // #695
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, false, 1603, 1, 64, 1,  0, 0}, // #696
  {DBGFIELD("FRNDINT")            1, false, false, false, 1604, 1, 49, 1,  0, 0}, // #697
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false, false, 1604, 1, 49, 1,  0, 0}, // #698
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, false, 1605, 1, 65, 1,  0, 0}, // #699
  {DBGFIELD("FPREM")              1, false, false, false, 1606, 1, 66, 1,  0, 0}, // #700
  {DBGFIELD("INSB_INSL_INSW")     1, false, false, false, 1607, 1, 67, 1,  0, 0}, // #701
  {DBGFIELD("FNINIT")             1, false, false, false, 1608, 1, 43, 1,  0, 0}, // #702
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 1, false, false, false, 1566, 1, 55, 1,  0, 0}, // #703
  {DBGFIELD("FPREM1")             1, false, false, false, 1590, 1, 61, 1,  0, 0}, // #704
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, false, 1590, 1, 61, 1,  0, 0}, // #705
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 1, false, false, false, 1609, 1, 68, 1,  0, 0}, // #706
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, false, 1610, 1, 69, 1,  0, 0}, // #707
  {DBGFIELD("FSCALE")             1, false, false, false, 1611, 1, 70, 1,  0, 0}, // #708
  {DBGFIELD("RDMSR")              1, false, false, false, 1612, 1, 71, 1,  0, 0}, // #709
  {DBGFIELD("RET_RET16_RET32_RET64_LRET16_LRET32_LRET64_LRETI16_LRETI32_LRETI64") 1, false, false, false, 1613, 1, 72, 1,  0, 0}, // #710
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 1, false, false, false, 1614, 1, 73, 1,  0, 0}, // #711
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 1, false, false, false, 1615, 1, 74, 1,  0, 0}, // #712
  {DBGFIELD("F2XM1")              1, false, false, false, 1616, 1, 75, 1,  0, 0}, // #713
  {DBGFIELD("CPUID")              1, false, false, false, 1617, 1, 76, 1,  0, 0}, // #714
  {DBGFIELD("INT")                1, false, false, false, 1618, 1, 77, 1,  0, 0}, // #715
  {DBGFIELD("INT3")               1, false, false, false, 1619, 1, 54, 1,  0, 0}, // #716
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, false, 1563, 1, 78, 1,  0, 0}, // #717
  {DBGFIELD("FXRSTOR_FXRSTOR64")  1, false, false, false, 1620, 1, 79, 1,  0, 0}, // #718
  {DBGFIELD("FYL2X")              1, false, false, false, 1621, 1, 80, 1,  0, 0}, // #719
  {DBGFIELD("FYL2XP1")            1, false, false, false, 1622, 1, 81, 1,  0, 0}, // #720
  {DBGFIELD("FPTAN")              1, false, false, false, 1623, 1, 82, 1,  0, 0}, // #721
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, false, 1624, 1, 83, 1,  0, 0}, // #722
  {DBGFIELD("FPATAN")             1, false, false, false, 1625, 1, 84, 1,  0, 0}, // #723
  {DBGFIELD("WRMSR")              1, false, false, false, 1626, 1, 85, 1,  0, 0}, // #724
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, false, 1535, 2, 14, 1,  0, 0}, // #725
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #726
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #727
  {DBGFIELD("FNOP")               1, false, false, false, 40, 1,  1, 1,  0, 0}, // #728
  {DBGFIELD("RET64")              1, false, false, false, 1613, 1, 72, 1,  0, 0}, // #729
  {DBGFIELD("CDQ_CQO")            1, false, false, false, 369, 1,  8, 1,  0, 0}, // #730
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #731
  {DBGFIELD("MMX_PADDQrr")        1, false, false, false, 80, 1, 13, 1,  0, 0}, // #732
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #733
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #734
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int_VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 4, false, false, false, 1532, 3,  9, 1,  0, 0}, // #735
  {DBGFIELD("CWD")                1, false, false, false, 369, 1,  8, 1,  0, 0}, // #736
  {DBGFIELD("FNSTSW16r")          1, false, false, false, 40, 1,  1, 1,  0, 0}, // #737
  {DBGFIELD("MMX_MOVDQ2Qrr")      1, false, false, false, 40, 1,  1, 1,  0, 0}, // #738
  {DBGFIELD("PUSHFS64")           1, false, false, false, 80, 1, 13, 1,  0, 0}, // #739
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #740
  {DBGFIELD("RCL16r1_RCL32r1_RCL64r1_RCL8r1_RCR16r1_RCR32r1_RCR64r1_RCR8r1") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #741
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, false, 1411, 1,  9, 1,  0, 0}, // #742
  {DBGFIELD("MOV64sr")            1, false, false, false, 40, 1,  1, 1,  0, 0}, // #743
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVSX32rm16_MOVSX32rm32_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #744
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #745
  {DBGFIELD("RCL16ri_RCL32ri_RCL64ri_RCL8ri_RCR16ri_RCR32ri_RCR64ri_RCR8ri") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #746
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 1, false, false, false, 1521, 3,  1, 1,  0, 0}, // #747
  {DBGFIELD("CLI")                1, false, false, false, 40, 1,  4, 1,  0, 0}, // #748
  {DBGFIELD("PUSHGS64")           1, false, false, false, 80, 1, 13, 1,  0, 0}, // #749
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #750
  {DBGFIELD("CALL64pcrel32")      1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #751
  {DBGFIELD("CALL64r_RVMARKER_CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #752
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #753
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #754
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #755
  {DBGFIELD("PUSHF16_PUSHF64")    1, false, false, false, 1411, 1,  9, 1,  0, 0}, // #756
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #757
  {DBGFIELD("MMX_MOVD64from64rm") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #758
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #759
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #760
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #761
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #762
  {DBGFIELD("MOV16sm")            1, false, false, false, 40, 1,  1, 1,  0, 0}, // #763
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #764
  {DBGFIELD("MMX_PALIGNRrmi")     1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #765
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #766
  {DBGFIELD("LODSL_LODSQ")        1, false, false, false, 80, 1, 13, 1,  0, 0}, // #767
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #768
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #769
  {DBGFIELD("VINSERTF128rm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #770
  {DBGFIELD("MMX_PADDQrm")        1, false, false, false, 100, 1,  5, 1,  0, 0}, // #771
  {DBGFIELD("VERRm_VERWm")        1, false, false, false, 40, 1,  4, 1,  0, 0}, // #772
  {DBGFIELD("FARJMP64m")          1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #773
  {DBGFIELD("FNSTSWm")            1, false, false, false, 40, 1,  4, 1,  0, 0}, // #774
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 1, false, false, false, 40, 1,  4, 1,  0, 0}, // #775
  {DBGFIELD("CALL64m_RVMARKER_CALL64m_CALL64m_NT") 1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #776
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #777
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int_VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 5, false, false, false, 1529, 3,  7, 1, 20, 1}, // #778
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, false, 100, 1,  5, 1,  0, 0}, // #779
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #780
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 1, false, false, false, 100, 1,  5, 1,  0, 0}, // #781
  {DBGFIELD("FARCALL64m")         1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #782
  {DBGFIELD("CVTSD2SI64rm_CVTSD2SI64rm_Int_CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 4, false, false, false, 1529, 3,  9, 1,  0, 0}, // #783
  {DBGFIELD("CVTSS2SIrm_CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 4, false, false, false, 1532, 3,  9, 1,  0, 0}, // #784
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #785
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #786
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 1, false, false, false, 1513, 2,  1, 1, 18, 2}, // #787
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 1, false, false, false, 1521, 3, 14, 1,  0, 0}, // #788
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #789
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 1, false, false, false, 1535, 2, 14, 1,  0, 0}, // #790
  {DBGFIELD("MUL_F32m_MUL_F64m")  1, false, false, false, 1585, 2,  8, 1,  0, 0}, // #791
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 1, false, false, false, 1521, 3, 14, 1,  0, 0}, // #792
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 1, false, false, false, 1585, 2,  8, 1,  0, 0}, // #793
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 4, false, false, false, 1564, 3, 58, 1,  0, 0}, // #794
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 4, false, false, false, 1564, 3, 58, 1,  0, 0}, // #795
  {DBGFIELD("VZEROALL")           1, false, false, false, 40, 1,  4, 1,  0, 0}, // #796
  {DBGFIELD("VZEROUPPER")         1, false, false, false, 40, 1,  4, 1,  0, 0}, // #797
  {DBGFIELD("CLC")                1, false, false, false, 40, 1,  1, 1,  0, 0}, // #798
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #799
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #800
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #801
  {DBGFIELD("PXORrr_VPXORrr")     1, false, false, false, 40, 1,  1, 1,  0, 0}, // #802
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #803
  {DBGFIELD("PSUBQrr")            1, false, false, false, 80, 1, 13, 1,  0, 0}, // #804
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #805
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #806
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #807
  {DBGFIELD("SETCCr")             1, false, false, false, 40, 1,  1, 1,  0, 0}, // #808
  {DBGFIELD("SETCCm")             1, false, false, false, 80, 1, 13, 1,  0, 0}, // #809
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #810
  {DBGFIELD("RETI16_RETI32_RETI64") 1, false, false, false, 1521, 3,  1, 1,  0, 0}, // #811
  {DBGFIELD("LRETI16_LRETI32_LRETI64") 1, false, false, false, 1613, 1, 72, 1,  0, 0}, // #812
  {DBGFIELD("RDPMC")              1, false, false, false, 1604, 1, 49, 1,  0, 0}, // #813
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false, false, 40, 1,  4, 1,  0, 0}, // #814
  {DBGFIELD("FBLDm")              1, false, false, false, 40, 1,  4, 1,  0, 0}, // #815
  {DBGFIELD("FFREE_FFREEP")       1, false, false, false, 40, 1,  1, 1,  0, 0}, // #816
  {DBGFIELD("FSAVEm")             1, false, false, false, 40, 1,  4, 1,  0, 0}, // #817
  {DBGFIELD("FRSTORm")            1, false, false, false, 40, 1,  4, 1,  0, 0}, // #818
  {DBGFIELD("FXTRACT")            1, false, false, false, 1600, 1, 11, 1,  0, 0}, // #819
  {DBGFIELD("MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #820
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #821
  {DBGFIELD("VBROADCASTF128")     1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #822
  {DBGFIELD("VBROADCASTI128")     1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #823
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #824
  {DBGFIELD("FBSTPm")             1, false, false, false, 40, 1,  4, 1,  0, 0}, // #825
  {DBGFIELD("VMPTRSTm")           1, false, false, false, 40, 1,  4, 1,  0, 0}, // #826
  {DBGFIELD("ST_FP32m_ST_FP64m")  1, false, false, false, 80, 1, 13, 1,  0, 0}, // #827
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #828
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #829
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false, false, 40, 1,  1, 1,  0, 0}, // #830
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #831
  {DBGFIELD("FINCSTP")            1, false, false, false, 40, 1,  1, 1,  0, 0}, // #832
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, false, 40, 1,  1, 1,  0, 0}, // #833
  {DBGFIELD("VPBLENDDYrri")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #834
  {DBGFIELD("VPBLENDDrri")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #835
  {DBGFIELD("CMC_STC")            1, false, false, false, 40, 1,  1, 1,  0, 0}, // #836
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, false, 40, 1,  4, 1,  0, 0}, // #837
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 5, false, false, false, 1537, 3,  2, 1,  0, 0}, // #838
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #839
  {DBGFIELD("CVTSS2SDrm")         4, false, false, false, 1537, 3,  6, 1,  0, 0}, // #840
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 4, false, false, false, 1537, 3,  6, 1, 20, 1}, // #841
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #842
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #843
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #844
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #845
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #846
  {DBGFIELD("ANDN32rm_ANDN64rm")  1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #847
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #848
  {DBGFIELD("VINSERTI128rm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #849
  {DBGFIELD("VPBLENDDrmi")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #850
  {DBGFIELD("VPBLENDDYrmi")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #851
  {DBGFIELD("POP32r_POP64r")      1, false, false, false, 1521, 3,  1, 1,  0, 0}, // #852
  {DBGFIELD("SFENCE")             1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #853
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #854
  {DBGFIELD("MOVBE16mr")          1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #855
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 1, false, false, false, 1521, 3,  1, 1,  0, 0}, // #856
  {DBGFIELD("MFENCE")             1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #857
  {DBGFIELD("XGETBV")             1, false, false, false, 40, 1,  4, 1,  0, 0}, // #858
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 4, false, false, false, 1515, 3,  6, 1,  0, 0}, // #859
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 3, false, false, false, 1515, 3,  3, 1,  0, 0}, // #860
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm_MMX_PACKUSWBrm") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #861
  {DBGFIELD("LRET64_RET32")       1, false, false, false, 1613, 1, 72, 1,  0, 0}, // #862
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #863
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #864
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 3, false, false, false, 1515, 3,  3, 1,  0, 0}, // #865
  {DBGFIELD("VCVTDQ2PSYrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #866
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #867
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 4, false, false, false, 1537, 3,  6, 1,  0, 0}, // #868
  {DBGFIELD("VCVTDQ2PSYrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #869
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #870
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #871
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr_MMX_PACKUSWBrr") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #872
  {DBGFIELD("CLDEMOTE")           1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #873
  {DBGFIELD("CVTSD2SI64rr_CVTSD2SIrr_CVTTSD2SI64rr_CVTTSD2SIrr_VCVTSD2SI64rr_VCVTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 3, false, false, false, 1540, 3,  2, 1,  0, 0}, // #874
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 3, false, false, false, 1540, 3,  2, 1,  0, 0}, // #875
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 3, false, false, false, 1540, 3,  2, 1,  0, 0}, // #876
  {DBGFIELD("CVTSS2SIrr_CVTTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 3, false, false, false, 1540, 3,  2, 1,  0, 0}, // #877
  {DBGFIELD("VCVTPS2PDYrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #878
  {DBGFIELD("MMX_CVTPI2PDrr")     3, false, false, false, 1515, 3,  6, 1,  0, 0}, // #879
  {DBGFIELD("MMX_CVTPD2PIrr_MMX_CVTTPD2PIrr") 4, false, false, false, 1537, 3,  6, 1,  0, 0}, // #880
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 3, false, false, false, 1515, 3,  6, 1,  0, 0}, // #881
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 4, false, false, false, 1546, 3, 18, 1,  0, 0}, // #882
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 3, false, false, false, 1529, 3,  7, 1,  0, 0}, // #883
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 3, false, false, false, 1515, 3,  3, 1,  0, 1}, // #884
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 3, false, false, false, 1515, 3,  3, 1,  6, 1}, // #885
  {DBGFIELD("CVTSI2SSrr")         3, false, false, false, 1515, 3,  3, 1,  0, 1}, // #886
  {DBGFIELD("CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 3, false, false, false, 1515, 3,  3, 1,  6, 1}, // #887
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 4, false, false, false, 1537, 3,  6, 1,  0, 0}, // #888
  {DBGFIELD("VCVTSD2SI64rm_VCVTSD2SI64rm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 4, false, false, false, 1529, 3,  9, 1,  0, 0}, // #889
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int") 5, false, false, false, 1546, 3,  7, 1,  0, 0}, // #890
  {DBGFIELD("VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 4, false, false, false, 1532, 3,  9, 1,  0, 0}, // #891
  {DBGFIELD("VCVTPS2PDYrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #892
  {DBGFIELD("CVTPD2PSrm")         5, false, false, false, 1543, 3, 23, 1,  0, 0}, // #893
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIrm_MMX_CVTTPD2PIrm") 5, false, false, false, 1540, 3,  2, 1,  0, 0}, // #894
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 4, false, false, false, 1537, 3,  2, 1,  0, 0}, // #895
  {DBGFIELD("MMX_CVTPI2PDrm")     4, false, false, false, 1537, 3,  2, 1,  0, 0}, // #896
  {DBGFIELD("CVTSD2SSrm")         4, false, false, false, 1543, 3, 18, 1,  0, 0}, // #897
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_VCVTSD2SSrm_Int") 4, false, false, false, 1543, 3, 18, 1, 20, 1}, // #898
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #899
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 1, false, false, false, 40, 1,  4, 1,  0, 0}, // #900
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 1, false, false, false, 40, 1,  4, 1,  0, 0}, // #901
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, false, 1585, 2,  8, 1,  0, 0}, // #902
  {DBGFIELD("VPCMPGTQYrm")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #903
  {DBGFIELD("VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, false, 1515, 3,  3, 1,  6, 1}, // #904
  {DBGFIELD("STR16r_STR32r_STR64r") 1, false, false, false, 40, 1,  4, 1,  0, 0}, // #905
  {DBGFIELD("XSETBV")             1, false, false, false, 40, 1,  4, 1,  0, 0}, // #906
  {DBGFIELD("VCVTDQ2PDYrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #907
  {DBGFIELD("VCVTPD2PSYrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #908
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #909
  {DBGFIELD("VCVTDQ2PDYrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #910
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #911
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #912
  {DBGFIELD("RCL8rCL")            1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #913
  {DBGFIELD("RDTSC")              1, false, false, false, 1593, 1, 47, 1,  0, 0}, // #914
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 1, false, false, false, 40, 1,  4, 1,  0, 0}, // #915
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 3, false, false, false, 1564, 3, 58, 1,  0, 0}, // #916
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 4, false, false, false, 1564, 3, 58, 1,  0, 0}, // #917
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 4, false, false, false, 1564, 3, 58, 1,  0, 0}, // #918
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 3, false, false, false, 1564, 3, 58, 1,  0, 0}, // #919
  {DBGFIELD("XSAVE64")            1, false, false, false, 40, 1,  4, 1,  0, 0}, // #920
  {DBGFIELD("XSAVE")              1, false, false, false, 40, 1,  4, 1,  0, 0}, // #921
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 1, false, false, false, 40, 1,  4, 1,  0, 0}, // #922
  {DBGFIELD("VMCLEARm")           1, false, false, false, 40, 1,  4, 1,  0, 0}, // #923
  {DBGFIELD("FLDENVm")            1, false, false, false, 40, 1,  4, 1,  0, 0}, // #924
  {DBGFIELD("FXRSTOR64")          1, false, false, false, 1620, 1, 79, 1,  0, 0}, // #925
  {DBGFIELD("FSTENVm")            1, false, false, false, 40, 1,  4, 1,  0, 0}, // #926
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #927
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #928
  {DBGFIELD("VGATHERDPSrm_VPGATHERDDrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #929
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #930
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #931
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm_VGATHERQPSYrm_VPGATHERQDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #932
  {DBGFIELD("VGATHERQPSrm_VPGATHERQDrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #933
  {DBGFIELD("VPXORYrr")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #934
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #935
  {DBGFIELD("VPCMPGTQYrr")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #936
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #937
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #938
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 1, false, false, false, 1535, 2, 14, 1,  0, 0}, // #939
  {DBGFIELD("LRET64")             1, false, false, false, 1613, 1, 72, 1,  0, 0}, // #940
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 4, false, false, false, 1537, 3,  6, 1,  0, 0}, // #941
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 5, false, false, false, 1540, 3,  2, 1,  0, 0}, // #942
  {DBGFIELD("POPF64")             1, false, false, false, 1601, 1, 62, 1,  0, 0}, // #943
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #944
  {DBGFIELD("PCMPEQQrr")          1, false, false, false, 40, 1,  1, 1,  0, 0}, // #945
  {DBGFIELD("PCMPEQQrm")          1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #946
  {DBGFIELD("MOV16rm")            1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #947
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #948
  {DBGFIELD("POP16rmm")           1, false, false, false, 100, 1,  5, 1,  0, 0}, // #949
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #950
  {DBGFIELD("PUSHF16")            1, false, false, false, 1411, 1,  9, 1,  0, 0}, // #951
  {DBGFIELD("LAHF")               1, false, false, false, 80, 1, 13, 1,  0, 0}, // #952
  {DBGFIELD("ADD16mi_ADD16mi8_ADD32mi_ADD32mi8_ADD64mi32_ADD64mi8_ADD8mi_ADD8mi8_SUB16mi_SUB16mi8_SUB32mi_SUB32mi8_SUB64mi32_SUB64mi8_SUB8mi_SUB8mi8") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #953
  {DBGFIELD("ADD16mr_ADD32mr_ADD64mr_ADD8mr_SUB16mr_SUB32mr_SUB64mr_SUB8mr") 1, false, false, false, 1513, 2,  1, 1, 18, 1}, // #954
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #955
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #956
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #957
  {DBGFIELD("RET16_LRET16_LRET32") 1, false, false, false, 1613, 1, 72, 1,  0, 0}, // #958
  {DBGFIELD("IRET16_IRET32_IRET64") 1, false, false, false, 1521, 3,  1, 1,  0, 0}, // #959
  {DBGFIELD("AND16mi_AND16mi8_AND32mi_AND32mi8_AND64mi32_AND64mi8_AND8mi_AND8mi8_OR16mi_OR16mi8_OR32mi_OR32mi8_OR32mi8Locked_OR64mi32_OR64mi8_OR8mi_OR8mi8_XOR16mi_XOR16mi8_XOR32mi_XOR32mi8_XOR64mi32_XOR64mi8_XOR8mi_XOR8mi8") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #960
  {DBGFIELD("AND16mr_AND32mr_AND64mr_AND8mr_OR16mr_OR32mr_OR64mr_OR8mr_XOR16mr_XOR32mr_XOR64mr_XOR8mr") 1, false, false, false, 1513, 2,  1, 1, 18, 1}, // #961
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 1, false, false, false, 369, 1,  8, 1,  0, 0}, // #962
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #963
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 1, false, false, false, 369, 1,  8, 1,  0, 0}, // #964
  {DBGFIELD("MOVSLDUPrm")         1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #965
  {DBGFIELD("MOVSLDUPrr")         1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #966
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #967
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #968
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #969
  {DBGFIELD("VPBLENDWYrri")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #970
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #971
  {DBGFIELD("VPBLENDWYrmi")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #972
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #973
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64_MASKMOVDQUX32") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #974
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64_VMASKMOVDQUX32") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #975
  {DBGFIELD("VPMASKMOVDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #976
  {DBGFIELD("VPMASKMOVDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #977
  {DBGFIELD("VPMASKMOVDYmr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #978
  {DBGFIELD("VPMASKMOVDmr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #979
  {DBGFIELD("VPMASKMOVQYmr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #980
  {DBGFIELD("VPMASKMOVQmr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #981
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #982
  {DBGFIELD("VPGATHERDDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #983
  {DBGFIELD("VPGATHERDDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #984
  {DBGFIELD("VPGATHERDQYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #985
  {DBGFIELD("VPGATHERDQrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #986
  {DBGFIELD("VPGATHERQDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #987
  {DBGFIELD("VPGATHERQDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #988
  {DBGFIELD("VPGATHERQQYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #989
  {DBGFIELD("VPGATHERQQrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #990
  {DBGFIELD("PSLLDQri_PSRLDQri_VPSLLDQri_VPSRLDQri") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #991
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #992
  {DBGFIELD("VPERM2F128rr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #993
  {DBGFIELD("VPERM2F128rm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #994
  {DBGFIELD("VEXTRACTF128rr")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #995
  {DBGFIELD("VEXTRACTF128mr")     1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #996
  {DBGFIELD("VINSERTF128rr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #997
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 5, false, false, false, 1540, 3,  2, 1,  0, 0}, // #998
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #999
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 3, false, false, false, 1540, 3,  2, 1,  0, 0}, // #1000
  {DBGFIELD("VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 4, false, false, false, 1532, 3,  9, 1,  0, 0}, // #1001
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1002
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1003
  {DBGFIELD("SHA256MSG2rm")       1, false, false, false, 1585, 2, 14, 1, 20, 1}, // #1004
  {DBGFIELD("SHA256MSG2rr")       1, false, false, false, 1585, 2, 14, 1,  0, 0}, // #1005
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, false, 1585, 2, 14, 1,  0, 0}, // #1006
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 1, false, false, false, 1585, 2, 14, 1, 20, 1}, // #1007
  {DBGFIELD("SHA1MSG2rr")         1, false, false, false, 1585, 2, 14, 1,  0, 0}, // #1008
  {DBGFIELD("SHA1MSG2rm")         1, false, false, false, 1585, 2, 14, 1, 20, 1}, // #1009
  {DBGFIELD("SHA1NEXTErr")        1, false, false, false, 1585, 2, 14, 1,  0, 0}, // #1010
  {DBGFIELD("SHA1NEXTErm")        1, false, false, false, 1585, 2, 14, 1, 20, 1}, // #1011
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, false, 1585, 2, 14, 1,  0, 0}, // #1012
  {DBGFIELD("SHA1RNDS4rmi")       1, false, false, false, 1585, 2, 14, 1, 20, 1}, // #1013
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, false, 1585, 2, 14, 1,  0, 0}, // #1014
  {DBGFIELD("SHA256RNDS2rm")      1, false, false, false, 1585, 2, 14, 1, 20, 1}, // #1015
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #1016
  {DBGFIELD("BT16mi8_BT32mi8_BT64mi8") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1017
  {DBGFIELD("BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #1018
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 3, false, false, false, 1515, 3,  3, 1,  0, 0}, // #1019
  {DBGFIELD("MOV8rm_MOV8rm_NOREX") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1020
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVZX16rm16") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1021
  {DBGFIELD("MOVBE16rm")          1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1022
  {DBGFIELD("ADD8i8_ADD16i16_ADD32i32_ADD64i32_AND8i8_AND16i16_AND32i32_AND64i32_OR8i8_OR16i16_OR32i32_OR64i32_SUB8i8_SUB16i16_SUB32i32_SUB64i32_XOR8i8_XOR16i16_XOR32i32_XOR64i32") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1023
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32_MOVZX16rr16") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1024
  {DBGFIELD("MOV32ri_MOV32ri_alt_MOV64ri32") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1025
  {DBGFIELD("ADC8mr_SBB8mr")      1, false, false, false, 1513, 2,  1, 1, 18, 2}, // #1026
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #1027
  {DBGFIELD("LEA16r")             1, false, false, false, 1509, 2,  1, 1,  0, 0}, // #1028
  {DBGFIELD("LCMPXCHG8")          1, false, false, false, 1511, 2,  1, 1,  0, 0}, // #1029
  {DBGFIELD("LCMPXCHG16B")        1, false, false, false, 1511, 2,  1, 1,  0, 0}, // #1030
  {DBGFIELD("XCHG8rr_XCHG16rr_XCHG16ar") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #1031
  {DBGFIELD("XCHG8rm_XCHG16rm")   1, false, false, false, 100, 1,  5, 1,  0, 0}, // #1032
  {DBGFIELD("POPCNT16rr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1033
  {DBGFIELD("LZCNT16rr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1034
  {DBGFIELD("TZCNT16rr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1035
  {DBGFIELD("RCL8m1_RCL16m1_RCL32m1_RCL64m1_RCR8m1_RCR16m1_RCR32m1_RCR64m1") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1036
  {DBGFIELD("RCR8ri_RCR16ri_RCR32ri_RCR64ri") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1037
  {DBGFIELD("RCR8mi_RCR16mi_RCR32mi_RCR64mi") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1038
  {DBGFIELD("RCR16rCL_RCR32rCL_RCR64rCL") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1039
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1040
  {DBGFIELD("VEXTRACTI128rr")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1041
  {DBGFIELD("VEXTRACTI128mr")     1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1042
  {DBGFIELD("MMX_MOVQ2FR64rr")    1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1043
  {DBGFIELD("MMX_MOVD64rr_MMX_MOVD64to64rr") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1044
  {DBGFIELD("EXTRQ")              1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1045
  {DBGFIELD("INSERTQ")            1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1046
  {DBGFIELD("PABSBrr_PABSDrr_PABSWrr_PADDSBrr_PADDSWrr_PADDUSBrr_PADDUSWrr_PAVGBrr_PAVGWrr_PSIGNBrr_PSIGNDrr_PSIGNWrr_VPABSBrr_VPABSDrr_VPABSWrr_VPADDSBrr_VPADDSWrr_VPADDUSBrr_VPADDUSWrr_VPAVGBrr_VPAVGWrr_VPCMPEQQrr_VPSIGNBrr_VPSIGNDrr_VPSIGNWrr_PSUBSBrr_PSUBSWrr_PSUBUSBrr_PSUBUSWrr_VPSUBSBrr_VPSUBSWrr_VPSUBUSBrr_VPSUBUSWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1047
  {DBGFIELD("MMX_PADDSBrr_MMX_PADDSWrr_MMX_PADDUSBrr_MMX_PADDUSWrr_MMX_PAVGBrr_MMX_PAVGWrr_MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1048
  {DBGFIELD("VPABSBYrr_VPABSDYrr_VPABSWYrr_VPADDSBYrr_VPADDSWYrr_VPADDUSBYrr_VPADDUSWYrr_VPSUBSBYrr_VPSUBSWYrr_VPSUBUSBYrr_VPSUBUSWYrr_VPAVGBYrr_VPAVGWYrr_VPCMPEQQYrr_VPSIGNBYrr_VPSIGNDYrr_VPSIGNWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1049
  {DBGFIELD("SHA1MSG1rr")         1, false, false, false, 1585, 2, 14, 1,  0, 0}, // #1050
  {DBGFIELD("SHA1MSG1rm")         1, false, false, false, 1585, 2, 14, 1, 20, 1}, // #1051
  {DBGFIELD("VPERM2I128rr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1052
  {DBGFIELD("VPERMPSYrr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1053
  {DBGFIELD("VPERMPSYrm")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1054
  {DBGFIELD("VPERMPDYri")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1055
  {DBGFIELD("VPERMQYri")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1056
  {DBGFIELD("VPERMPDYmi")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1057
  {DBGFIELD("VPERMDYrr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1058
  {DBGFIELD("VPERMQYmi")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1059
  {DBGFIELD("VPERMDYrm")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1060
  {DBGFIELD("MOV32rr_MOV32rr_REV_MOV64rr_MOV64rr_REV") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1061
  {DBGFIELD("MOVSX32rr32")        1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1062
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV_SUB32rr_REV_SUB64rr_REV") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1063
  {DBGFIELD("CMP8rr_CMP8rr_REV_CMP16rr_CMP16rr_REV_CMP32rr_CMP32rr_REV_CMP64rr_CMP64rr_REV") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1064
  {DBGFIELD("VXORPSrr_VXORPDrr")  1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1065
  {DBGFIELD("VANDNPSrr_VANDNPDrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1066
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1067
  {DBGFIELD("VPXORrr")            1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1068
  {DBGFIELD("VPANDNrr")           1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1069
  {DBGFIELD("VPANDNYrr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1070
  {DBGFIELD("VPSUBBrr_VPSUBWrr_VPSUBDrr_VPSUBQrr_VPCMPGTBrr_VPCMPGTWrr_VPCMPGTDrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1071
  {DBGFIELD("VPCMPGTQrr")         1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1072
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 1, false, false, false, 40, 1,  4, 1,  0, 0}, // #1073
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1074
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1075
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1076
  {DBGFIELD("ADC64ri32_SBB64ri32") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1077
  {DBGFIELD("CRC32r32r16")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1078
  {DBGFIELD("CRC32r32r32")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1079
  {DBGFIELD("CRC32r64r64")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1080
  {DBGFIELD("SAHF")               1, false, false, false, 80, 1, 13, 1,  0, 0}, // #1081
  {DBGFIELD("BEXTRI32ri_BEXTRI64ri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1082
  {DBGFIELD("BEXTRI32mi_BEXTRI64mi") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1083
  {DBGFIELD("RCR8ri")             1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1084
  {DBGFIELD("RCL16rCL")           1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1085
  {DBGFIELD("RCR16ri")            1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1086
  {DBGFIELD("RCR32rCL_RCR64rCL")  1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1087
  {DBGFIELD("RCL16ri")            1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1088
  {DBGFIELD("RCL32ri_RCL64ri")    1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1089
  {DBGFIELD("SHLD32rri8")         1, false, false, false, 80, 1, 13, 1,  0, 0}, // #1090
  {DBGFIELD("SHRD16rri8")         1, false, false, false, 1573, 1,  3, 1,  0, 0}, // #1091
  {DBGFIELD("SHLD16rrCL")         1, false, false, false, 1573, 1,  3, 1,  0, 0}, // #1092
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1093
  {DBGFIELD("TST_F")              1, false, false, false, 1411, 1,  9, 1,  0, 0}, // #1094
  {DBGFIELD("VDPPSrri")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1095
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr") 1, false, false, false, 1535, 2, 14, 1,  0, 0}, // #1096
  {DBGFIELD("VFRCZSDrr_VFRCZSSrr") 1, false, false, false, 1535, 2, 14, 1,  0, 0}, // #1097
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 1, false, false, false, 1535, 2, 14, 1, 20, 1}, // #1098
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1099
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1100
  {DBGFIELD("MMX_CVTTPD2PIrr")    4, false, false, false, 1537, 3,  6, 1,  0, 0}, // #1101
  {DBGFIELD("VMOVDQUYmr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1102
  {DBGFIELD("MOVDQArr")           1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1103
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1104
  {DBGFIELD("VMPSADBWrri")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1105
  {DBGFIELD("VPPERMrrr_VPPERMrrr_REV") 4, false, false, false, 1579, 3,  8, 1,  0, 0}, // #1106
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, false, 1537, 3,  6, 1,  0, 0}, // #1107
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, false, 1540, 3,  2, 1, 20, 1}, // #1108
  {DBGFIELD("VPCLMULQDQrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1109
  {DBGFIELD("ANDNPSrr_ANDNPDrr")  1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1110
  {DBGFIELD("MMX_PXORrr_MMX_PANDNrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1111
  {DBGFIELD("PANDNrr")            1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1112
  {DBGFIELD("MMX_PSUBBrr_MMX_PSUBDrr_MMX_PSUBWrr_MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1113
  {DBGFIELD("LCMPXCHG16_LCMPXCHG32_LCMPXCHG64") 1, false, false, false, 1511, 2,  1, 1,  0, 0}, // #1114
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 1, false, false, false, 1528, 1, 21, 1,  0, 0}, // #1115
  {DBGFIELD("LCMPXCHG8B")         1, false, false, false, 1511, 2,  1, 1,  0, 0}, // #1116
  {DBGFIELD("XCHG8rr")            1, false, false, false, 80, 1, 13, 1,  0, 0}, // #1117
  {DBGFIELD("MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1118
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1119
  {DBGFIELD("MMX_PCMPEQBrr_MMX_PCMPEQDrr_MMX_PCMPEQWrr_MMX_PMAXSWrr_MMX_PMINSWrr_MMX_PMAXUBrr_MMX_PMINUBrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1120
  {DBGFIELD("MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1121
  {DBGFIELD("CLAC_STAC")          1, false, false, false, 40, 1,  4, 1,  0, 0}, // #1122
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1123
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1124
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, false, 1509, 2, 14, 1,  0, 0}, // #1125
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 1, false, false, false, 1536, 1, 14, 1,  0, 0}, // #1126
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, false, 1537, 3,  6, 1,  0, 0}, // #1127
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1128
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1129
  {DBGFIELD("MMX_PADDSBrm_MMX_PADDSWrm_MMX_PADDUSBrm_MMX_PADDUSWrm_MMX_PAVGBrm_MMX_PAVGWrm_MMX_PCMPEQBrm_MMX_PCMPEQDrm_MMX_PCMPEQWrm_MMX_PCMPGTBrm_MMX_PCMPGTDrm_MMX_PCMPGTWrm_MMX_PMAXSWrm_MMX_PMAXUBrm_MMX_PMINSWrm_MMX_PMINUBrm_MMX_PSUBSBrm_MMX_PSUBSWrm_MMX_PSUBUSBrm_MMX_PSUBUSWrm") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #1130
  {DBGFIELD("CVTSS2SI64rr")       4, false, false, false, 1532, 3,  9, 1,  0, 0}, // #1131
  {DBGFIELD("CVTSS2SI64rr_Int")   4, false, false, false, 1532, 3,  9, 1,  0, 0}, // #1132
  {DBGFIELD("CVTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr") 3, false, false, false, 1540, 3,  2, 1,  0, 0}, // #1133
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 3, false, false, false, 1540, 3,  2, 1,  0, 0}, // #1134
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #1135
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1136
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 1, false, false, false, 1573, 1,  3, 1,  0, 0}, // #1137
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, false, 1540, 3,  2, 1, 20, 1}, // #1138
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1139
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 1, false, false, false, 40, 1,  4, 1,  0, 0}, // #1140
  {DBGFIELD("PCMPGTBrr_PCMPGTDrr_PCMPGTWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1141
  {DBGFIELD("VPCMPGTBrr_VPCMPGTDrr_VPCMPGTWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1142
  {DBGFIELD("VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1143
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1144
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1145
  {DBGFIELD("KSET0D_KSET0Q_KSET0W_KSET1D_KSET1Q_KSET1W") 1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1146
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1147
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1148
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1149
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1150
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1151
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1152
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1153
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1154
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1155
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1156
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1157
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1158
  {DBGFIELD("VPSADBWZrr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1159
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1160
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1161
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1162
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1163
  {DBGFIELD("VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1164
  {DBGFIELD("VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1165
  {DBGFIELD("VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1166
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1167
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1168
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 3, false, false, false, 1518, 3,  3, 1,  0, 0}, // #1169
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1170
  {DBGFIELD("VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1171
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, false, 1509, 2, 14, 1,  0, 0}, // #1172
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1173
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1174
  {DBGFIELD("VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1175
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1176
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1177
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 3, false, false, false, 1515, 3,  3, 1,  0, 0}, // #1178
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1179
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 4, false, false, false, 1537, 3,  6, 1,  0, 0}, // #1180
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1181
  {DBGFIELD("VCVTPS2DQYrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1182
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 3, false, false, false, 1515, 3,  3, 1,  0, 0}, // #1183
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1184
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 3, false, false, false, 1515, 3,  6, 1,  0, 0}, // #1185
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1186
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1187
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1188
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1189
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1190
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1191
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1192
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1193
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 3, false, false, false, 1515, 3,  6, 1,  0, 0}, // #1194
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 4, false, false, false, 1537, 3,  6, 1,  0, 0}, // #1195
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 4, false, false, false, 1546, 3, 18, 1,  0, 0}, // #1196
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 4, false, false, false, 1515, 3,  6, 1,  0, 0}, // #1197
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 3, false, false, false, 1515, 3,  3, 1,  0, 0}, // #1198
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 3, false, false, false, 1515, 3,  3, 1,  0, 0}, // #1199
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 3, false, false, false, 1529, 3,  7, 1,  0, 0}, // #1200
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 3, false, false, false, 1515, 3,  3, 1,  6, 1}, // #1201
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 3, false, false, false, 1515, 3,  3, 1,  6, 1}, // #1202
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 3, false, false, false, 1515, 3,  3, 1,  0, 0}, // #1203
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1204
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1205
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1206
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1207
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1208
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1209
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1210
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1211
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 3, false, false, false, 1515, 3,  3, 1,  6, 1}, // #1212
  {DBGFIELD("VMOVSDZrm_VMOVSDZrm_alt_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrm_alt_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1213
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1214
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1215
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1216
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1217
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1218
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1219
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1220
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1221
  {DBGFIELD("VCVTPD2PSZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1222
  {DBGFIELD("VCVTPS2PDZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1223
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1224
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1225
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1226
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1227
  {DBGFIELD("VBROADCASTI32X2Z128rm_VBROADCASTI32X2Z128rmk_VBROADCASTI32X2Z128rmkz_VPBROADCASTDZ128rm_VPBROADCASTDZ128rmk_VPBROADCASTDZ128rmkz_VPBROADCASTQZ128rm_VPBROADCASTQZ128rmk_VPBROADCASTQZ128rmkz") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1228
  {DBGFIELD("VBROADCASTSSZ128rm_VBROADCASTSSZ128rmk_VBROADCASTSSZ128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1229
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1230
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1231
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1232
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #1233
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1234
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1235
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 3, false, false, false, 1540, 3,  2, 1,  0, 0}, // #1236
  {DBGFIELD("VCVTSS2SI64rr")      3, false, false, false, 1540, 3,  2, 1,  0, 0}, // #1237
  {DBGFIELD("VCVTSS2SI64rr_Int")  3, false, false, false, 1540, 3,  2, 1,  0, 0}, // #1238
  {DBGFIELD("VCVTTSS2SI64rr")     3, false, false, false, 1540, 3,  2, 1,  0, 0}, // #1239
  {DBGFIELD("VCVTTSS2SI64rr_Int") 3, false, false, false, 1540, 3,  2, 1,  0, 0}, // #1240
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1241
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1242
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1243
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1244
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1245
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1246
  {DBGFIELD("VPBROADCASTBZ256rm_VPBROADCASTBZ256rmk_VPBROADCASTBZ256rmkz_VPBROADCASTBZrm_VPBROADCASTBZrmk_VPBROADCASTBZrmkz_VPBROADCASTWZ256rm_VPBROADCASTWZ256rmk_VPBROADCASTWZ256rmkz_VPBROADCASTWZrm_VPBROADCASTWZrmk_VPBROADCASTWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1247
  {DBGFIELD("VMOVNTDQAZ256rm")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1248
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1249
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1250
  {DBGFIELD("VBROADCASTF32X2Z256rm_VBROADCASTF32X2Z256rmk_VBROADCASTF32X2Z256rmkz_VBROADCASTF32X2Zrm_VBROADCASTF32X2Zrmk_VBROADCASTF32X2Zrmkz_VBROADCASTI32X2Z256rm_VBROADCASTI32X2Z256rmk_VBROADCASTI32X2Z256rmkz_VBROADCASTI32X2Zrm_VBROADCASTI32X2Zrmk_VBROADCASTI32X2Zrmkz_VPBROADCASTDZ256rm_VPBROADCASTDZ256rmk_VPBROADCASTDZ256rmkz_VPBROADCASTDZrm_VPBROADCASTDZrmk_VPBROADCASTDZrmkz_VPBROADCASTQZ256rm_VPBROADCASTQZ256rmk_VPBROADCASTQZ256rmkz_VPBROADCASTQZrm_VPBROADCASTQZrmk_VPBROADCASTQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1251
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1252
  {DBGFIELD("VBROADCASTSDZ256rm_VBROADCASTSDZ256rmk_VBROADCASTSDZ256rmkz_VBROADCASTSDZrm_VBROADCASTSDZrmk_VBROADCASTSDZrmkz_VBROADCASTSSZ256rm_VBROADCASTSSZ256rmk_VBROADCASTSSZ256rmkz_VBROADCASTSSZrm_VBROADCASTSSZrmk_VBROADCASTSSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1253
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1254
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1255
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1256
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1257
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1258
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1259
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1260
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1261
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1262
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1263
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1264
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1265
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1266
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1267
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #1268
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 1, false, false, false, 1521, 3, 14, 1, 20, 1}, // #1269
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1270
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1271
  {DBGFIELD("VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #1272
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmik_VFPCLASSPDZ128rm_VFPCLASSPDZ128rmb_VFPCLASSPDZ128rmbk_VFPCLASSPDZ128rmk_VFPCLASSPSZ128rm_VFPCLASSPSZ128rmb_VFPCLASSPSZ128rmbk_VFPCLASSPSZ128rmk") 4, false, false, false, 1515, 3,  6, 1, 20, 1}, // #1273
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk") 1, false, false, false, 1521, 3, 14, 1, 20, 1}, // #1274
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmik_VPCMPDZ128rmi_VPCMPDZ128rmib_VPCMPDZ128rmibk_VPCMPDZ128rmik_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmib_VPCMPQZ128rmibk_VPCMPQZ128rmik_VPCMPUBZ128rmi_VPCMPUBZ128rmik_VPCMPUDZ128rmi_VPCMPUDZ128rmib_VPCMPUDZ128rmibk_VPCMPUDZ128rmik_VPCMPUQZ128rmi_VPCMPUQZ128rmib_VPCMPUQZ128rmibk_VPCMPUQZ128rmik_VPCMPUWZ128rmi_VPCMPUWZ128rmik_VPCMPWZ128rmi_VPCMPWZ128rmik") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #1275
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #1276
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1277
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1278
  {DBGFIELD("VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1279
  {DBGFIELD("VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1280
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmik_VFPCLASSPDZ256rm_VFPCLASSPDZ256rmb_VFPCLASSPDZ256rmbk_VFPCLASSPDZ256rmk_VFPCLASSPSZ256rm_VFPCLASSPSZ256rmb_VFPCLASSPSZ256rmbk_VFPCLASSPSZ256rmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1281
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmik_VFPCLASSPDZrm_VFPCLASSPDZrmb_VFPCLASSPDZrmbk_VFPCLASSPDZrmk_VFPCLASSPSZrm_VFPCLASSPSZrmb_VFPCLASSPSZrmbk_VFPCLASSPSZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1282
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmik_VPCMPDZ256rmi_VPCMPDZ256rmib_VPCMPDZ256rmibk_VPCMPDZ256rmik_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmib_VPCMPQZ256rmibk_VPCMPQZ256rmik_VPCMPUBZ256rmi_VPCMPUBZ256rmik_VPCMPUDZ256rmi_VPCMPUDZ256rmib_VPCMPUDZ256rmibk_VPCMPUDZ256rmik_VPCMPUQZ256rmi_VPCMPUQZ256rmib_VPCMPUQZ256rmibk_VPCMPUQZ256rmik_VPCMPUWZ256rmi_VPCMPUWZ256rmik_VPCMPWZ256rmi_VPCMPWZ256rmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1283
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmik_VPCMPDZrmi_VPCMPDZrmib_VPCMPDZrmibk_VPCMPDZrmik_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmib_VPCMPQZrmibk_VPCMPQZrmik_VPCMPUBZrmi_VPCMPUBZrmik_VPCMPUDZrmi_VPCMPUDZrmib_VPCMPUDZrmibk_VPCMPUDZrmik_VPCMPUQZrmi_VPCMPUQZrmib_VPCMPUQZrmibk_VPCMPUQZrmik_VPCMPUWZrmi_VPCMPUWZrmik_VPCMPWZrmi_VPCMPWZrmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1284
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1285
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1286
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 4, false, false, false, 1537, 3,  2, 1,  0, 0}, // #1287
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 4, false, false, false, 1537, 3,  6, 1,  0, 0}, // #1288
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 5, false, false, false, 1540, 3,  2, 1,  0, 0}, // #1289
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1290
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 4, false, false, false, 1537, 3,  6, 1,  0, 0}, // #1291
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 5, false, false, false, 1537, 3,  2, 1,  0, 0}, // #1292
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 4, false, false, false, 1537, 3,  6, 1, 20, 1}, // #1293
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1294
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1295
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1296
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1297
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1298
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1299
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1300
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1301
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1302
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1303
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1304
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1305
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1306
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1307
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 4, false, false, false, 1543, 3, 18, 1, 20, 1}, // #1308
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1309
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, false, 1585, 2, 14, 1,  0, 0}, // #1310
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1311
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1312
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1313
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 4, false, false, false, 1529, 3,  9, 1, 20, 1}, // #1314
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 4, false, false, false, 1532, 3,  9, 1, 20, 1}, // #1315
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1316
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1317
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1318
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1319
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1320
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1321
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1322
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1323
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 1, false, false, false, 1585, 2, 14, 1, 20, 1}, // #1324
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1325
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1326
  {DBGFIELD("VGATHERQPSZ128rm_VPGATHERQDZ128rm_VGATHERDPDZ128rm_VPGATHERDQZ128rm_VGATHERQPDZ128rm_VPGATHERQQZ128rm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1327
  {DBGFIELD("VGATHERQPSZ256rm_VPGATHERQDZ256rm_VGATHERQPDZ256rm_VPGATHERQQZ256rm_VGATHERDPSZ128rm_VPGATHERDDZ128rm_VGATHERDPDZ256rm_VPGATHERDQZ256rm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1328
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm_VGATHERDPDZrm_VPGATHERDQZrm_VGATHERQPDZrm_VPGATHERQQZrm_VGATHERQPSZrm_VPGATHERQDZrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1329
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1330
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1331
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1332
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1333
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1334
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1335
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1336
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1337
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1338
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1339
  {DBGFIELD("VXORPSZ128rr_VXORPDZ128rr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1340
  {DBGFIELD("VXORPSZ256rr_VXORPDZ256rr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1341
  {DBGFIELD("VXORPSZrr_VXORPDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1342
  {DBGFIELD("VPXORDZ128rr_VPXORQZ128rr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1343
  {DBGFIELD("VPXORDZ256rr_VPXORQZ256rr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1344
  {DBGFIELD("VPXORDZrr_VPXORQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1345
  {DBGFIELD("VPSUBBZ128rr_VPSUBDZ128rr_VPSUBQZ128rr_VPSUBWZ128rr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1346
  {DBGFIELD("VPSUBBZ256rr_VPSUBDZ256rr_VPSUBQZ256rr_VPSUBWZ256rr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1347
  {DBGFIELD("VPSUBBZrr_VPSUBDZrr_VPSUBQZrr_VPSUBWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1348
  {DBGFIELD("VPBROADCASTDrr_VPBROADCASTQrr_PALIGNRrri_VPALIGNRZ128rri_VPALIGNRZ128rrik_VPALIGNRZ128rrikz_VPALIGNRrri_PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWZ128rr_VPACKSSDWZ128rrk_VPACKSSDWZ128rrkz_VPACKSSDWrr_VPACKSSWBZ128rr_VPACKSSWBZ128rrk_VPACKSSWBZ128rrkz_VPACKSSWBrr_VPACKUSDWZ128rr_VPACKUSDWZ128rrk_VPACKUSDWZ128rrkz_VPACKUSDWrr_VPACKUSWBZ128rr_VPACKUSWBZ128rrk_VPACKUSWBZ128rrkz_VPACKUSWBrr") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1349
  {DBGFIELD("INSERTPSrr_VINSERTPSZrr_VINSERTPSrr_MOVHLPSrr_MOVLHPSrr_VMOVHLPSZrr_VMOVHLPSrr_VMOVLHPSZrr_VMOVLHPSrr_MOVDDUPrr_VMOVDDUPZ128rr_VMOVDDUPZ128rrk_VMOVDDUPZ128rrkz_VMOVDDUPrr_VPERMILPDZ128ri_VPERMILPDZ128rik_VPERMILPDZ128rikz_VPERMILPDri_VPERMILPSZ128ri_VPERMILPSZ128rik_VPERMILPSZ128rikz_VPERMILPSri_UNPCKHPDrr_UNPCKHPSrr_UNPCKLPDrr_UNPCKLPSrr_VUNPCKHPDZ128rr_VUNPCKHPDZ128rrk_VUNPCKHPDZ128rrkz_VUNPCKHPDrr_VUNPCKHPSZ128rr_VUNPCKHPSZ128rrk_VUNPCKHPSZ128rrkz_VUNPCKHPSrr_VUNPCKLPDZ128rr_VUNPCKLPDZ128rrk_VUNPCKLPDZ128rrkz_VUNPCKLPDrr_VUNPCKLPSZ128rr_VUNPCKLPSZ128rrk_VUNPCKLPSZ128rrkz_VUNPCKLPSrr") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1350
  {DBGFIELD("VMOVDDUPYrr_VMOVDDUPZ256rr_VMOVDDUPZ256rrk_VMOVDDUPZ256rrkz_VPERMILPDYri_VPERMILPDZ256ri_VPERMILPDZ256rik_VPERMILPDZ256rikz_VPERMILPSYri_VPERMILPSZ256ri_VPERMILPSZ256rik_VPERMILPSZ256rikz_VUNPCKHPDYrr_VUNPCKHPDZ256rr_VUNPCKHPDZ256rrk_VUNPCKHPDZ256rrkz_VUNPCKHPSYrr_VUNPCKHPSZ256rr_VUNPCKHPSZ256rrk_VUNPCKHPSZ256rrkz_VUNPCKLPDYrr_VUNPCKLPDZ256rr_VUNPCKLPDZ256rrk_VUNPCKLPDZ256rrkz_VUNPCKLPSYrr_VUNPCKLPSZ256rr_VUNPCKLPSZ256rrk_VUNPCKLPSZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1351
  {DBGFIELD("VMOVDDUPZrr_VMOVDDUPZrrk_VMOVDDUPZrrkz_VPERMILPDZri_VPERMILPDZrik_VPERMILPDZrikz_VPERMILPSZri_VPERMILPSZrik_VPERMILPSZrikz_VUNPCKHPDZrr_VUNPCKHPDZrrk_VUNPCKHPDZrrkz_VUNPCKHPSZrr_VUNPCKHPSZrrk_VUNPCKHPSZrrkz_VUNPCKLPDZrr_VUNPCKLPDZrrk_VUNPCKLPDZrrkz_VUNPCKLPSZrr_VUNPCKLPSZrrk_VUNPCKLPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1352
  {DBGFIELD("VPALIGNRYrri_VPALIGNRZ256rri_VPALIGNRZ256rrik_VPALIGNRZ256rrikz_VPACKSSDWYrr_VPACKSSDWZ256rr_VPACKSSDWZ256rrk_VPACKSSDWZ256rrkz_VPACKSSWBYrr_VPACKSSWBZ256rr_VPACKSSWBZ256rrk_VPACKSSWBZ256rrkz_VPACKUSDWYrr_VPACKUSDWZ256rr_VPACKUSDWZ256rrk_VPACKUSDWZ256rrkz_VPACKUSWBYrr_VPACKUSWBZ256rr_VPACKUSWBZ256rrk_VPACKUSWBZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1353
  {DBGFIELD("VPALIGNRZrri_VPALIGNRZrrik_VPALIGNRZrrikz_VPACKSSDWZrr_VPACKSSDWZrrk_VPACKSSDWZrrkz_VPACKSSWBZrr_VPACKSSWBZrrk_VPACKSSWBZrrkz_VPACKUSDWZrr_VPACKUSDWZrrk_VPACKUSDWZrrkz_VPACKUSWBZrr_VPACKUSWBZrrk_VPACKUSWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1354
  {DBGFIELD("VPERMILPDYrr_VPERMILPDZ256rr_VPERMILPDZ256rrk_VPERMILPDZ256rrkz_VPERMILPSYrr_VPERMILPSZ256rr_VPERMILPSZ256rrk_VPERMILPSZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1355
  {DBGFIELD("VPERMILPDZ128rr_VPERMILPDZ128rrk_VPERMILPDZ128rrkz_VPERMILPDrr_VPERMILPSZ128rr_VPERMILPSZ128rrk_VPERMILPSZ128rrkz_VPERMILPSrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1356
  {DBGFIELD("VPERMILPDZrr_VPERMILPDZrrk_VPERMILPDZrrkz_VPERMILPSZrr_VPERMILPSZrrk_VPERMILPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1357
  {DBGFIELD("MOVSDrr_MOVSDrr_REV_VMOVSDZrr_VMOVSDZrr_REV_VMOVSDZrrk_VMOVSDZrrk_REV_VMOVSDZrrkz_VMOVSDZrrkz_REV_VMOVSDrr_VMOVSDrr_REV_VMOVSSZrr_VMOVSSZrr_REV_VMOVSSZrrk_VMOVSSZrrk_REV_VMOVSSZrrkz_VMOVSSZrrkz_REV_VMOVSSrr_VMOVSSrr_REV") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1358
  {DBGFIELD("VPBROADCASTBZ128rm_VPBROADCASTBZ128rmk_VPBROADCASTBZ128rmkz_VPBROADCASTWZ128rm_VPBROADCASTWZ128rmk_VPBROADCASTWZ128rmkz") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1359
  {DBGFIELD("INSERTPSrm_VINSERTPSZrm_VINSERTPSrm_UNPCKHPDrm_UNPCKHPSrm_UNPCKLPDrm_UNPCKLPSrm_VUNPCKHPDZ128rm_VUNPCKHPDZ128rmb_VUNPCKHPDZ128rmbk_VUNPCKHPDZ128rmbkz_VUNPCKHPDZ128rmk_VUNPCKHPDZ128rmkz_VUNPCKHPDrm_VUNPCKHPSZ128rm_VUNPCKHPSZ128rmb_VUNPCKHPSZ128rmbk_VUNPCKHPSZ128rmbkz_VUNPCKHPSZ128rmk_VUNPCKHPSZ128rmkz_VUNPCKHPSrm_VUNPCKLPDZ128rm_VUNPCKLPDZ128rmb_VUNPCKLPDZ128rmbk_VUNPCKLPDZ128rmbkz_VUNPCKLPDZ128rmk_VUNPCKLPDZ128rmkz_VUNPCKLPDrm_VUNPCKLPSZ128rm_VUNPCKLPSZ128rmb_VUNPCKLPSZ128rmbk_VUNPCKLPSZ128rmbkz_VUNPCKLPSZ128rmk_VUNPCKLPSZ128rmkz_VUNPCKLPSrm") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #1360
  {DBGFIELD("PALIGNRrmi_VPALIGNRZ128rmi_VPALIGNRZ128rmik_VPALIGNRZ128rmikz_VPALIGNRrmi_PACKSSDWrm_PACKSSWBrm_PACKUSDWrm_PACKUSWBrm_VPACKSSDWZ128rm_VPACKSSDWZ128rmb_VPACKSSDWZ128rmbk_VPACKSSDWZ128rmbkz_VPACKSSDWZ128rmk_VPACKSSDWZ128rmkz_VPACKSSDWrm_VPACKSSWBZ128rm_VPACKSSWBZ128rmk_VPACKSSWBZ128rmkz_VPACKSSWBrm_VPACKUSDWZ128rm_VPACKUSDWZ128rmb_VPACKUSDWZ128rmbk_VPACKUSDWZ128rmbkz_VPACKUSDWZ128rmk_VPACKUSDWZ128rmkz_VPACKUSDWrm_VPACKUSWBZ128rm_VPACKUSWBZ128rmk_VPACKUSWBZ128rmkz_VPACKUSWBrm") 1, false, false, false, 1513, 2,  1, 1, 20, 1}, // #1361
  {DBGFIELD("VPERMILPDZ128mbi_VPERMILPDZ128mbik_VPERMILPDZ128mbikz_VPERMILPDZ128mi_VPERMILPDZ128mik_VPERMILPDZ128mikz_VPERMILPDmi_VPERMILPSZ128mbi_VPERMILPSZ128mbik_VPERMILPSZ128mbikz_VPERMILPSZ128mi_VPERMILPSZ128mik_VPERMILPSZ128mikz_VPERMILPSmi") 1, false, false, false, 1513, 2,  1, 1,  0, 0}, // #1362
  {DBGFIELD("VPERMILPDZ128rm_VPERMILPDZ128rmb_VPERMILPDZ128rmbk_VPERMILPDZ128rmbkz_VPERMILPDZ128rmk_VPERMILPDZ128rmkz_VPERMILPDrm_VPERMILPSZ128rm_VPERMILPSZ128rmb_VPERMILPSZ128rmbk_VPERMILPSZ128rmbkz_VPERMILPSZ128rmk_VPERMILPSZ128rmkz_VPERMILPSrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1363
  {DBGFIELD("VPALIGNRYrmi_VPALIGNRZ256rmi_VPALIGNRZ256rmik_VPALIGNRZ256rmikz_VPACKSSDWYrm_VPACKSSDWZ256rm_VPACKSSDWZ256rmb_VPACKSSDWZ256rmbk_VPACKSSDWZ256rmbkz_VPACKSSDWZ256rmk_VPACKSSDWZ256rmkz_VPACKSSWBYrm_VPACKSSWBZ256rm_VPACKSSWBZ256rmk_VPACKSSWBZ256rmkz_VPACKUSDWYrm_VPACKUSDWZ256rm_VPACKUSDWZ256rmb_VPACKUSDWZ256rmbk_VPACKUSDWZ256rmbkz_VPACKUSDWZ256rmk_VPACKUSDWZ256rmkz_VPACKUSWBYrm_VPACKUSWBZ256rm_VPACKUSWBZ256rmk_VPACKUSWBZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1364
  {DBGFIELD("VPALIGNRZrmi_VPALIGNRZrmik_VPALIGNRZrmikz_VPACKSSDWZrm_VPACKSSDWZrmb_VPACKSSDWZrmbk_VPACKSSDWZrmbkz_VPACKSSDWZrmk_VPACKSSDWZrmkz_VPACKSSWBZrm_VPACKSSWBZrmk_VPACKSSWBZrmkz_VPACKUSDWZrm_VPACKUSDWZrmb_VPACKUSDWZrmbk_VPACKUSDWZrmbkz_VPACKUSDWZrmk_VPACKUSDWZrmkz_VPACKUSWBZrm_VPACKUSWBZrmk_VPACKUSWBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1365
  {DBGFIELD("VPERMILPDYmi_VPERMILPDZ256mbi_VPERMILPDZ256mbik_VPERMILPDZ256mbikz_VPERMILPDZ256mi_VPERMILPDZ256mik_VPERMILPDZ256mikz_VPERMILPSYmi_VPERMILPSZ256mbi_VPERMILPSZ256mbik_VPERMILPSZ256mbikz_VPERMILPSZ256mi_VPERMILPSZ256mik_VPERMILPSZ256mikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1366
  {DBGFIELD("VPERMILPDZmbi_VPERMILPDZmbik_VPERMILPDZmbikz_VPERMILPDZmi_VPERMILPDZmik_VPERMILPDZmikz_VPERMILPSZmbi_VPERMILPSZmbik_VPERMILPSZmbikz_VPERMILPSZmi_VPERMILPSZmik_VPERMILPSZmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1367
  {DBGFIELD("VPERMILPDYrm_VPERMILPDZ256rm_VPERMILPDZ256rmb_VPERMILPDZ256rmbk_VPERMILPDZ256rmbkz_VPERMILPDZ256rmk_VPERMILPDZ256rmkz_VPERMILPSYrm_VPERMILPSZ256rm_VPERMILPSZ256rmb_VPERMILPSZ256rmbk_VPERMILPSZ256rmbkz_VPERMILPSZ256rmk_VPERMILPSZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1368
  {DBGFIELD("VPERMILPDZrm_VPERMILPDZrmb_VPERMILPDZrmbk_VPERMILPDZrmbkz_VPERMILPDZrmk_VPERMILPDZrmkz_VPERMILPSZrm_VPERMILPSZrmb_VPERMILPSZrmbk_VPERMILPSZrmbkz_VPERMILPSZrmk_VPERMILPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1369
  {DBGFIELD("VUNPCKHPDYrm_VUNPCKHPDZ256rm_VUNPCKHPDZ256rmb_VUNPCKHPDZ256rmbk_VUNPCKHPDZ256rmbkz_VUNPCKHPDZ256rmk_VUNPCKHPDZ256rmkz_VUNPCKHPSYrm_VUNPCKHPSZ256rm_VUNPCKHPSZ256rmb_VUNPCKHPSZ256rmbk_VUNPCKHPSZ256rmbkz_VUNPCKHPSZ256rmk_VUNPCKHPSZ256rmkz_VUNPCKLPDYrm_VUNPCKLPDZ256rm_VUNPCKLPDZ256rmb_VUNPCKLPDZ256rmbk_VUNPCKLPDZ256rmbkz_VUNPCKLPDZ256rmk_VUNPCKLPDZ256rmkz_VUNPCKLPSYrm_VUNPCKLPSZ256rm_VUNPCKLPSZ256rmb_VUNPCKLPSZ256rmbk_VUNPCKLPSZ256rmbkz_VUNPCKLPSZ256rmk_VUNPCKLPSZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1370
  {DBGFIELD("VUNPCKHPDZrm_VUNPCKHPDZrmb_VUNPCKHPDZrmbk_VUNPCKHPDZrmbkz_VUNPCKHPDZrmk_VUNPCKHPDZrmkz_VUNPCKHPSZrm_VUNPCKHPSZrmb_VUNPCKHPSZrmbk_VUNPCKHPSZrmbkz_VUNPCKHPSZrmk_VUNPCKHPSZrmkz_VUNPCKLPDZrm_VUNPCKLPDZrmb_VUNPCKLPDZrmbk_VUNPCKLPDZrmbkz_VUNPCKLPDZrmk_VUNPCKLPDZrmkz_VUNPCKLPSZrm_VUNPCKLPSZrmb_VUNPCKLPSZrmbk_VUNPCKLPSZrmbkz_VUNPCKLPSZrmk_VUNPCKLPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1371
  {DBGFIELD("PdWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1372
  {DBGFIELD("WriteVecALU")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1373
  {DBGFIELD("JWriteZeroLatency")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1374
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1375
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1376
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1377
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1378
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1379
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1380
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1381
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1382
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1383
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1384
  {DBGFIELD("JWriteLOCK_CMPXCHG8B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1385
  {DBGFIELD("JWriteLOCK_CMPXCHG16B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1386
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1387
  {DBGFIELD("JWriteLOCK_CMPXCHGrm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1388
  {DBGFIELD("JWriteCMPXCHG8B")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1389
  {DBGFIELD("JWriteCMPXCHG16B")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1390
  {DBGFIELD("JWriteCMPXCHG8rm")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1391
  {DBGFIELD("WriteCMPXCHGRMW")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1392
  {DBGFIELD("JWriteCMPXCHG8rr")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1393
  {DBGFIELD("WriteCMPXCHG")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1394
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1395
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1396
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1397
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1398
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1399
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1400
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1401
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1402
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1403
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1404
  {DBGFIELD("JWriteLOCK_XADDrm_XCHG_Part_JWriteXCHGrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1405
  {DBGFIELD("JWriteXADDrm_XCHG_Part_JWriteXADDrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1406
  {DBGFIELD("SBWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1407
  {DBGFIELD("WriteALU")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1408
  {DBGFIELD("HWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1409
  {DBGFIELD("BWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1410
  {DBGFIELD("Zn3WriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1411
  {DBGFIELD("SKLWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1412
  {DBGFIELD("SKXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1413
  {DBGFIELD("ICXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1414
  {DBGFIELD("WriteFLogic")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1415
  {DBGFIELD("WriteFLogicY")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1416
  {DBGFIELD("JWriteZeroIdiomYmm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1417
  {DBGFIELD("WriteVecLogicX")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1418
  {DBGFIELD("WriteVecALUX")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1419
  {DBGFIELD("SKLWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1420
  {DBGFIELD("SKXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1421
  {DBGFIELD("ICXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1422
  {DBGFIELD("SBWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1423
  {DBGFIELD("HWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1424
  {DBGFIELD("BWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1425
  {DBGFIELD("SKLWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1426
  {DBGFIELD("SKXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1427
  {DBGFIELD("ICXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1428
  {DBGFIELD("SBWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1429
  {DBGFIELD("WriteCMOV")          0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1430
  {DBGFIELD("HWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1431
  {DBGFIELD("BWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1432
  {DBGFIELD("SKLWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1433
  {DBGFIELD("SKXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1434
  {DBGFIELD("ICXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1435
  {DBGFIELD("SBWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1436
  {DBGFIELD("WriteCMOVLd")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1437
  {DBGFIELD("HWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1438
  {DBGFIELD("BWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1439
  {DBGFIELD("PdWriteCMOVm")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1440
  {DBGFIELD("SKLWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1441
  {DBGFIELD("SKXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1442
  {DBGFIELD("ICXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1443
  {DBGFIELD("SBWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1444
  {DBGFIELD("WriteSETCC")         0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1445
  {DBGFIELD("HWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1446
  {DBGFIELD("BWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1447
  {DBGFIELD("SKLWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1448
  {DBGFIELD("SKXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1449
  {DBGFIELD("ICXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1450
  {DBGFIELD("SBWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1451
  {DBGFIELD("WriteSETCCStore")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1452
  {DBGFIELD("HWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1453
  {DBGFIELD("BWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1454
  {DBGFIELD("PdWriteSETGEmSETGmSETLEmSETLm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1455
  {DBGFIELD("SKLWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1456
  {DBGFIELD("SKXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1457
  {DBGFIELD("ICXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1458
  {DBGFIELD("WriteVecLogicY")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1459
  {DBGFIELD("WriteVecALUY")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1460
  {DBGFIELD("HWWriteADC0")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1461
  {DBGFIELD("WriteADC")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1462
  {DBGFIELD("JWriteLOCK_ALURMW")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1463
  {DBGFIELD("WriteALURMW")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1464
  {DBGFIELD("WriteFShuffle256")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1465
  {DBGFIELD("Zn3Write3OpsLEA")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1466
  {DBGFIELD("WriteLEA")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1467
  {DBGFIELD("PdWrite3OpsLEA")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1468
  {DBGFIELD("JWrite3OpsLEA")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1469
  {DBGFIELD("WriteVecLogic")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1470
  {DBGFIELD("WriteFLogicZ")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1471
  {DBGFIELD("WriteVecLogicZ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1472
}; // AtomModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc BdVer2ModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, false, 1629, 3, 13, 1,  0, 0}, // #3
  {DBGFIELD("WriteJump")          1, false, false, false, 1632, 4,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteCMPXCHGRMW")    2, false, false, false, 1636, 6,  5, 1,  0, 0}, // #5
  {DBGFIELD("WriteJumpLd")        1, false, false, false, 1642, 6, 14, 1,  0, 0}, // #6
  {DBGFIELD("WriteMove")          1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteADC")           1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteSHDrri")        6, false, false, false, 1650, 2,  5, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreX")       1, false, false, false, 1652, 5,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteFLoadX")        1, false, false, false, 1657, 5, 14, 1,  0, 0}, // #12
  {DBGFIELD("WriteFStoreY")       4, false, false, false, 1662, 5,  1, 1,  0, 0}, // #13
  {DBGFIELD("WriteFLoadY")        2, false, false, false, 1657, 5, 14, 1,  0, 0}, // #14
  {DBGFIELD("WriteMicrocoded")    1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #15
  {DBGFIELD("WriteFSign")         1, false, false, false, 1667, 4,  1, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCRMW")        2, false, false, false, 1671, 5,  3, 1,  0, 0}, // #17
  {DBGFIELD("WriteADCRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 1671, 5,  3, 1, 24, 2}, // #18
  {DBGFIELD("WriteADCLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 1676, 4, 14, 1, 26, 2}, // #19
  {DBGFIELD("WriteALURMW")        1, false, false, false, 1671, 5,  3, 1,  0, 0}, // #20
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 1671, 5,  3, 1, 24, 1}, // #21
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false, false, 1676, 4, 14, 1, 26, 1}, // #22
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 1, false, false, false, 1680, 6,  7, 1,  3, 1}, // #23
  {DBGFIELD("WriteFAdd64X")       1, false, false, false, 1681, 4, 14, 1,  0, 0}, // #24
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 1, false, false, false, 1680, 6,  7, 1,  3, 1}, // #25
  {DBGFIELD("WriteFAddX")         1, false, false, false, 1681, 4, 14, 1,  0, 0}, // #26
  {DBGFIELD("WriteNop")           1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 1, false, false, false, 1680, 6,  7, 1,  3, 1}, // #28
  {DBGFIELD("WriteFAdd64")        1, false, false, false, 1681, 4, 14, 1,  0, 0}, // #29
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 1, false, false, false, 1680, 6,  7, 1,  3, 1}, // #30
  {DBGFIELD("WriteFAdd")          1, false, false, false, 1681, 4, 14, 1,  0, 0}, // #31
  {DBGFIELD("WriteFAddLd")        1, false, false, false, 1680, 6,  7, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 2, false, false, false, 1686, 6, 10, 1,  3, 1}, // #33
  {DBGFIELD("WriteAESDecEnc")     2, false, false, false, 1687, 4,  9, 1,  0, 0}, // #34
  {DBGFIELD("WriteAESIMCLd")      1, false, false, false, 1686, 6,  7, 1,  0, 0}, // #35
  {DBGFIELD("WriteAESIMC")        1, false, false, false, 1687, 4, 14, 1,  0, 0}, // #36
  {DBGFIELD("WriteAESKeyGenLd")   1, false, false, false, 1686, 6,  7, 1,  0, 0}, // #37
  {DBGFIELD("WriteAESKeyGen")     1, false, false, false, 1687, 4, 14, 1,  0, 0}, // #38
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 1, false, false, false, 1692, 5,  6, 1,  3, 1}, // #39
  {DBGFIELD("WriteFLogic")        1, false, false, false, 1693, 3, 13, 1,  0, 0}, // #40
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 1676, 4,  3, 1, 24, 1}, // #41
  {DBGFIELD("WriteBEXTR")         2, false, false, false, 1627, 2, 13, 1,  0, 0}, // #42
  {DBGFIELD("WriteBEXTRLd")       2, false, false, false, 1676, 4,  3, 1,  0, 0}, // #43
  {DBGFIELD("WriteALULd")         1, false, false, false, 1676, 4, 14, 1,  0, 0}, // #44
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 1, false, false, false, 1657, 5,  6, 1,  3, 1}, // #45
  {DBGFIELD("WriteFBlend")        1, false, false, false, 1658, 3, 13, 1,  0, 0}, // #46
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 1, false, false, false, 1657, 5,  6, 1,  3, 1}, // #47
  {DBGFIELD("WriteFVarBlend")     1, false, false, false, 1658, 3, 13, 1,  0, 0}, // #48
  {DBGFIELD("WriteBLSLd")         2, false, false, false, 1676, 4,  3, 1,  0, 0}, // #49
  {DBGFIELD("WriteBLS")           2, false, false, false, 1627, 2, 13, 1,  0, 0}, // #50
  {DBGFIELD("WriteBSFLd")         8, false, false, false, 1697, 4,  6, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSF")           6, false, false, false, 1650, 2,  5, 1,  0, 0}, // #52
  {DBGFIELD("WriteBSRLd")         9, false, false, false, 1701, 4,  2, 1,  0, 0}, // #53
  {DBGFIELD("WriteBSR")           7, false, false, false, 1702, 2,  8, 1,  0, 0}, // #54
  {DBGFIELD("WriteBSWAP32")       1, false, false, false, 1648, 2,  1, 1,  0, 0}, // #55
  {DBGFIELD("WriteBSWAP64")       1, false, false, false, 1648, 2,  1, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestImmLd")  1, false, false, false, 1676, 4, 14, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestRegLd")  7, false, false, false, 1705, 4, 14, 1,  0, 0}, // #58
  {DBGFIELD("WriteBitTest")       1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBitTestSetImmRMW") 4, false, false, false, 1709, 4,  6, 1,  0, 0}, // #60
  {DBGFIELD("WriteBitTestSetRegRMW") 10, false, false, false, 1713, 4,  6, 1,  0, 0}, // #61
  {DBGFIELD("WriteBitTestSet")    2, false, false, false, 1627, 2, 13, 1,  0, 0}, // #62
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 1717, 4, 14, 1, 24, 1}, // #63
  {DBGFIELD("WriteBZHI")          1, false, false, false, 1648, 2,  1, 1,  0, 0}, // #64
  {DBGFIELD("WriteLoad")          1, false, false, false, 1721, 2, 14, 1,  0, 0}, // #65
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 1, false, false, false, 1717, 4, 14, 1, 26, 1}, // #66
  {DBGFIELD("WriteCMOV")          1, false, false, false, 1648, 2,  1, 1,  0, 0}, // #67
  {DBGFIELD("WriteFCMOV")         1, false, false, false, 1681, 4,  1, 1,  0, 0}, // #68
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 1676, 4, 14, 1, 24, 1}, // #69
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 1, false, false, false, 1680, 6,  6, 1,  3, 1}, // #70
  {DBGFIELD("WriteFCmp64X")       1, false, false, false, 1681, 4, 13, 1,  0, 0}, // #71
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 1, false, false, false, 1680, 6,  6, 1,  3, 1}, // #72
  {DBGFIELD("WriteFCmpX")         1, false, false, false, 1681, 4, 13, 1,  0, 0}, // #73
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 1, false, false, false, 1680, 6,  6, 1,  3, 1}, // #74
  {DBGFIELD("WriteFCmp64")        1, false, false, false, 1681, 4, 13, 1,  0, 0}, // #75
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 1, false, false, false, 1680, 6,  6, 1,  3, 1}, // #76
  {DBGFIELD("WriteFCmp")          1, false, false, false, 1681, 4, 13, 1,  0, 0}, // #77
  {DBGFIELD("WriteCMPXCHG")       5, false, false, false, 1723, 3,  5, 1,  0, 0}, // #78
  {DBGFIELD("WriteFComXLd_ReadAfterVecLd") 2, false, false, false, 1726, 9,  3, 1,  3, 1}, // #79
  {DBGFIELD("WriteFComX")         2, false, false, false, 1727, 7,  1, 1,  0, 0}, // #80
  {DBGFIELD("WriteFCom")          2, false, false, false, 1727, 7,  1, 1,  0, 0}, // #81
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 3, false, false, false, 1735, 4,  3, 1, 26, 1}, // #82
  {DBGFIELD("WriteCRC32")         3, false, false, false, 1736, 2, 13, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtI2PDLd")     2, false, false, false, 1739, 7, 22, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtI2PD")       2, false, false, false, 1740, 5,  2, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtI2PSLd")     1, false, false, false, 1739, 7,  9, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtI2PS")       1, false, false, false, 1740, 5,  8, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtPD2ILd")     2, false, false, false, 1739, 7, 22, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPD2I")       2, false, false, false, 1740, 5,  2, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPD2PSLd")    2, false, false, false, 1739, 7, 22, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPD2PS")      2, false, false, false, 1740, 5,  2, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPS2ILd")     1, false, false, false, 1739, 7,  9, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtPS2I")       1, false, false, false, 1740, 5,  8, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, false, 1739, 7, 22, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtPS2PD")      2, false, false, false, 1740, 5,  2, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtSD2ILd")     2, false, false, false, 1746, 11, 31, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 2, false, false, false, 1747, 9, 22, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtSD2I")       2, false, false, false, 1747, 9, 22, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtSD2SSLd")    1, false, false, false, 1757, 7,  9, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 1, false, false, false, 1757, 7,  9, 1,  3, 1}, // #100
  {DBGFIELD("WriteCvtSD2SS")      1, false, false, false, 1758, 5,  8, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, false, 1739, 7,  9, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 2, false, false, false, 1739, 7,  9, 1,  3, 1}, // #103
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 2, false, false, false, 1740, 5,  8, 1, 28, 1}, // #104
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 2, false, false, false, 1740, 5,  8, 1, 29, 1}, // #105
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, false, 1739, 7,  9, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 2, false, false, false, 1739, 7,  9, 1,  3, 1}, // #107
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 2, false, false, false, 1740, 5,  8, 1, 28, 1}, // #108
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 2, false, false, false, 1740, 5,  8, 1, 29, 1}, // #109
  {DBGFIELD("WriteCvtSS2SDLd")    1, false, false, false, 1757, 7,  9, 1,  0, 0}, // #110
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 1, false, false, false, 1757, 7,  9, 1,  3, 1}, // #111
  {DBGFIELD("WriteCvtSS2SD")      1, false, false, false, 1758, 5,  8, 1,  0, 0}, // #112
  {DBGFIELD("WriteCvtSS2ILd")     2, false, false, false, 1746, 11, 31, 1,  0, 0}, // #113
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 2, false, false, false, 1747, 9, 22, 1,  0, 0}, // #114
  {DBGFIELD("WriteCvtSS2I")       2, false, false, false, 1747, 9, 22, 1,  0, 0}, // #115
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 1764, 6, 20, 1, 24, 2}, // #116
  {DBGFIELD("WriteDiv16")         2, false, false, false, 1765, 4, 21, 1,  0, 0}, // #117
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 1770, 6, 31, 1, 24, 2}, // #118
  {DBGFIELD("WriteDiv32")         2, false, false, false, 1771, 4, 10, 1,  0, 0}, // #119
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 1770, 6, 31, 1, 24, 2}, // #120
  {DBGFIELD("WriteDiv64")         2, false, false, false, 1771, 4, 10, 1,  0, 0}, // #121
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 1776, 6, 19, 1, 24, 2}, // #122
  {DBGFIELD("WriteDiv8")          1, false, false, false, 1777, 4, 23, 1,  0, 0}, // #123
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 1, false, false, false, 1782, 6, 10, 1,  3, 1}, // #124
  {DBGFIELD("WriteFDiv64X")       1, false, false, false, 1783, 4,  9, 1,  0, 0}, // #125
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 1, false, false, false, 1782, 6, 10, 1,  3, 1}, // #126
  {DBGFIELD("WriteFDivX")         1, false, false, false, 1783, 4,  9, 1,  0, 0}, // #127
  {DBGFIELD("WriteFDivLd")        1, false, false, false, 1782, 6, 10, 1,  0, 0}, // #128
  {DBGFIELD("WriteFDiv")          1, false, false, false, 1783, 4,  9, 1,  0, 0}, // #129
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 1, false, false, false, 1782, 6, 10, 1,  3, 1}, // #130
  {DBGFIELD("WriteFDiv64")        1, false, false, false, 1783, 4,  9, 1,  0, 0}, // #131
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 1, false, false, false, 1782, 6, 10, 1,  3, 1}, // #132
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 17, false, false, false, 1788, 6, 12, 1,  3, 1}, // #133
  {DBGFIELD("WriteDPPD")          15, false, false, false, 1789, 4, 21, 1,  0, 0}, // #134
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 18, false, false, false, 1794, 6, 47, 1,  3, 1}, // #135
  {DBGFIELD("WriteDPPS")          16, false, false, false, 1795, 4, 11, 1,  0, 0}, // #136
  {DBGFIELD("WriteStore")         1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #137
  {DBGFIELD("WriteVecExtractSt")  2, false, false, false, 1802, 6, 22, 1,  0, 0}, // #138
  {DBGFIELD("WriteVecExtract")    2, false, false, false, 1808, 7, 23, 1,  0, 0}, // #139
  {DBGFIELD("WriteVecALUX")       1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #140
  {DBGFIELD("WriteFComLd")        2, false, false, false, 1726, 9,  3, 1,  0, 0}, // #141
  {DBGFIELD("WriteEMMS")          1, false, false, false, 1818, 3, 13, 1,  0, 0}, // #142
  {DBGFIELD("WriteFLDC")          1, false, false, false, 1821, 4,  5, 1,  0, 0}, // #143
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 1, false, false, false, 1825, 5,  6, 1,  3, 1}, // #144
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 4, false, false, false, 1830, 6, 19, 1,  3, 1}, // #145
  {DBGFIELD("WriteFHAdd")         3, false, false, false, 1831, 4, 18, 1,  0, 0}, // #146
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 1836, 6, 20, 1, 24, 2}, // #147
  {DBGFIELD("WriteIDiv16")        2, false, false, false, 1837, 4, 21, 1,  0, 0}, // #148
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 1842, 6, 31, 1, 24, 2}, // #149
  {DBGFIELD("WriteIDiv32")        2, false, false, false, 1843, 4, 10, 1,  0, 0}, // #150
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 1770, 6, 31, 1, 24, 2}, // #151
  {DBGFIELD("WriteIDiv64")        2, false, false, false, 1771, 4, 10, 1,  0, 0}, // #152
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 1776, 6, 19, 1, 24, 2}, // #153
  {DBGFIELD("WriteIDiv8")         1, false, false, false, 1777, 4, 23, 1,  0, 0}, // #154
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 1848, 6,  2, 1, 24, 2}, // #155
  {DBGFIELD("WriteIMul16")        2, false, false, false, 1854, 4,  8, 1,  0, 0}, // #156
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 1, false, false, false, 1858, 6,  2, 1, 26, 1}, // #157
  {DBGFIELD("WriteIMul16ImmLd")   2, false, false, false, 1848, 6,  9, 1,  0, 0}, // #158
  {DBGFIELD("WriteIMul16Reg")     1, false, false, false, 1864, 4,  8, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul16Imm")     2, false, false, false, 1854, 4, 14, 1,  0, 0}, // #160
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 1868, 6,  2, 1, 24, 2}, // #161
  {DBGFIELD("WriteIMul32")        1, false, false, false, 1874, 4,  8, 1,  0, 0}, // #162
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 1, false, false, false, 1858, 6,  2, 1, 26, 1}, // #163
  {DBGFIELD("WriteIMul32ImmLd")   2, false, false, false, 1858, 6,  2, 1,  0, 0}, // #164
  {DBGFIELD("WriteIMul32Reg")     1, false, false, false, 1864, 4,  8, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul32Imm")     1, false, false, false, 1864, 4,  8, 1,  0, 0}, // #166
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 1878, 6,  7, 1, 24, 2}, // #167
  {DBGFIELD("WriteIMul64")        1, false, false, false, 1884, 4,  3, 1,  0, 0}, // #168
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 1, false, false, false, 1868, 6,  7, 1, 26, 1}, // #169
  {DBGFIELD("WriteIMul64ImmLd")   2, false, false, false, 1868, 6,  7, 1,  0, 0}, // #170
  {DBGFIELD("WriteIMul64Reg")     1, false, false, false, 1874, 4,  3, 1,  0, 0}, // #171
  {DBGFIELD("WriteIMul64Imm")     1, false, false, false, 1874, 4,  3, 1,  0, 0}, // #172
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 1868, 6,  2, 1, 24, 2}, // #173
  {DBGFIELD("WriteIMul8")         1, false, false, false, 1874, 4,  8, 1,  0, 0}, // #174
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 1, false, false, false, 1692, 5,  6, 1,  3, 1}, // #175
  {DBGFIELD("WriteFShuffle")      1, false, false, false, 1693, 3, 13, 1,  0, 0}, // #176
  {DBGFIELD("WriteVecLogicX")     1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #177
  {DBGFIELD("WriteShuffle")       1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #178
  {DBGFIELD("WriteLAHFSAHF")      2, false, false, false, 1736, 2, 13, 1,  0, 0}, // #179
  {DBGFIELD("WriteVecLoadX")      1, false, false, false, 1888, 5, 14, 1,  0, 0}, // #180
  {DBGFIELD("WriteLDMXCSR")       1, false, false, false, 1893, 2, 14, 1,  0, 0}, // #181
  {DBGFIELD("WriteFLD0")          1, false, false, false, 1821, 4,  5, 1,  0, 0}, // #182
  {DBGFIELD("WriteFLD1")          1, false, false, false, 1821, 4,  5, 1,  0, 0}, // #183
  {DBGFIELD("WriteLEA")           1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #184
  {DBGFIELD("WriteFence")         1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteLZCNTLd")       2, false, false, false, 1895, 5,  3, 1,  0, 0}, // #186
  {DBGFIELD("WriteLZCNT")         2, false, false, false, 1896, 3, 13, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecStoreX")     1, false, false, false, 1652, 5,  1, 1,  0, 0}, // #188
  {DBGFIELD("WriteVecStore")      1, false, false, false, 1652, 5, 13, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, false, 1727, 7, 18, 1,  0, 0}, // #190
  {DBGFIELD("WriteVecLoad")       1, false, false, false, 1888, 5, 14, 1,  0, 0}, // #191
  {DBGFIELD("WriteVecMoveFromGpr") 2, false, false, false, 1693, 3, 18, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecMoveX")      1, false, false, false, 1815, 3,  1, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecStoreNT")    1, false, false, false, 1900, 6, 13, 1,  0, 0}, // #194
  {DBGFIELD("WriteVecMove")       1, false, false, false, 1629, 3, 13, 1,  0, 0}, // #195
  {DBGFIELD("WriteVecALULd")      1, false, false, false, 1906, 5,  6, 1,  0, 0}, // #196
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 1, false, false, false, 1825, 5,  6, 1,  3, 1}, // #197
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 1, false, false, false, 1906, 5,  6, 1,  3, 1}, // #198
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 1, false, false, false, 1906, 5,  6, 1,  3, 1}, // #199
  {DBGFIELD("WriteVecLogic")      1, false, false, false, 1629, 3, 13, 1,  0, 0}, // #200
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, false, 1911, 5,  7, 1,  3, 1}, // #201
  {DBGFIELD("WritePHAdd")         3, false, false, false, 1912, 3, 14, 1,  0, 0}, // #202
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, false, 1911, 5,  3, 1, 26, 1}, // #203
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 2, false, false, false, 1889, 3, 13, 1, 29, 1}, // #204
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 1, false, false, false, 1686, 6,  9, 1,  3, 1}, // #205
  {DBGFIELD("WriteVecIMul")       1, false, false, false, 1687, 4,  8, 1,  0, 0}, // #206
  {DBGFIELD("WriteMMXMOVMSK")     2, false, false, false, 1727, 7,  7, 1,  0, 0}, // #207
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 2, false, false, false, 1825, 5,  9, 1,  3, 1}, // #208
  {DBGFIELD("WritePSADBW")        2, false, false, false, 1815, 3,  8, 1,  0, 0}, // #209
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 1, false, false, false, 1825, 5,  2, 1,  3, 1}, // #210
  {DBGFIELD("WriteVarShuffle")    1, false, false, false, 1815, 3,  5, 1,  0, 0}, // #211
  {DBGFIELD("WriteShuffleLd")     1, false, false, false, 1825, 5,  6, 1,  0, 0}, // #212
  {DBGFIELD("WriteVecShiftImm")   1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 1, false, false, false, 1825, 5,  2, 1,  3, 1}, // #214
  {DBGFIELD("WriteVecShift")      1, false, false, false, 1815, 3,  5, 1,  0, 0}, // #215
  {DBGFIELD("WriteFMoveX")        1, false, false, false, 1693, 3,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteFShuffleLd")    1, false, false, false, 1692, 5,  6, 1,  0, 0}, // #217
  {DBGFIELD("WriteFStore")        1, false, false, false, 1652, 5, 13, 1,  0, 0}, // #218
  {DBGFIELD("WriteFMOVMSK")       2, false, false, false, 1727, 7, 23, 1,  0, 0}, // #219
  {DBGFIELD("WriteVecLoadNT")     1, false, false, false, 1911, 5, 14, 1,  0, 0}, // #220
  {DBGFIELD("WriteStoreNT")       1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #221
  {DBGFIELD("WriteFStoreNTX")     1, false, false, false, 1900, 6,  5, 1,  0, 0}, // #222
  {DBGFIELD("WriteFStoreNT")      1, false, false, false, 1900, 6,  5, 1,  0, 0}, // #223
  {DBGFIELD("WriteFLoad")         1, false, false, false, 1657, 5, 14, 1,  0, 0}, // #224
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 8, false, false, false, 1916, 6, 10, 1,  3, 1}, // #225
  {DBGFIELD("WriteMPSAD")         8, false, false, false, 1917, 4,  9, 1,  0, 0}, // #226
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 1, false, false, false, 1922, 6,  7, 1,  3, 1}, // #227
  {DBGFIELD("WriteFMul64X")       1, false, false, false, 1923, 4, 14, 1,  0, 0}, // #228
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 1, false, false, false, 1922, 6,  7, 1,  3, 1}, // #229
  {DBGFIELD("WriteFMulX")         1, false, false, false, 1923, 4, 14, 1,  0, 0}, // #230
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 1, false, false, false, 1922, 6,  7, 1,  3, 1}, // #231
  {DBGFIELD("WriteFMul64")        1, false, false, false, 1923, 4, 14, 1,  0, 0}, // #232
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 1, false, false, false, 1922, 6,  7, 1,  3, 1}, // #233
  {DBGFIELD("WriteFMul")          1, false, false, false, 1923, 4, 14, 1,  0, 0}, // #234
  {DBGFIELD("WriteMULX32Ld")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #235
  {DBGFIELD("WriteMULX32")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #236
  {DBGFIELD("WriteIMulHLd_WriteMULX32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #237
  {DBGFIELD("WriteIMulH_WriteMULX32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #238
  {DBGFIELD("WriteMULX64Ld")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #239
  {DBGFIELD("WriteMULX64")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #240
  {DBGFIELD("WriteIMulHLd_WriteMULX64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #241
  {DBGFIELD("WriteIMulH_WriteMULX64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #242
  {DBGFIELD("WriteFMulLd")        1, false, false, false, 1922, 6,  7, 1,  0, 0}, // #243
  {DBGFIELD("WriteVecALUXLd")     1, false, false, false, 1825, 5,  6, 1,  0, 0}, // #244
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 1, false, false, false, 1825, 5,  6, 1,  3, 1}, // #245
  {DBGFIELD("WriteShuffleX")      1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #246
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 1, false, false, false, 1825, 5,  6, 1,  3, 1}, // #247
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 1, false, false, false, 1825, 5,  6, 1,  3, 1}, // #248
  {DBGFIELD("WriteVarBlend")      1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #249
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 1, false, false, false, 1906, 5,  6, 1,  3, 1}, // #250
  {DBGFIELD("WriteBlend")         1, false, false, false, 1629, 3, 13, 1,  0, 0}, // #251
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 6, false, false, false, 1928, 6, 17, 1,  3, 1}, // #252
  {DBGFIELD("WriteCLMul")         5, false, false, false, 1929, 4, 23, 1,  0, 0}, // #253
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 28, false, false, false, 1934, 11, 20, 1,  3, 1}, // #254
  {DBGFIELD("WritePCmpEStrI")     27, false, false, false, 1945, 11, 10, 1,  0, 0}, // #255
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 28, false, false, false, 1934, 11, 21, 1,  3, 1}, // #256
  {DBGFIELD("WritePCmpEStrM")     27, false, false, false, 1945, 11,  7, 1,  0, 0}, // #257
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 8, false, false, false, 1956, 9, 19, 1,  3, 1}, // #258
  {DBGFIELD("WritePCmpIStrI")     7, false, false, false, 1957, 7, 18, 1,  0, 0}, // #259
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 9, false, false, false, 1965, 9, 23, 1,  3, 1}, // #260
  {DBGFIELD("WritePCmpIStrM")     7, false, false, false, 1966, 7,  6, 1,  0, 0}, // #261
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 1, false, false, false, 1739, 7,  9, 1,  3, 1}, // #262
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 1, false, false, false, 1825, 5,  6, 1,  3, 1}, // #263
  {DBGFIELD("WritePHAddX")        1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #264
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, false, 1974, 6,  9, 1,  0, 0}, // #265
  {DBGFIELD("WritePHMINPOS")      2, false, false, false, 1975, 4,  8, 1,  0, 0}, // #266
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 1, false, false, false, 1739, 7,  9, 1,  3, 1}, // #267
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 1, false, false, false, 1686, 6,  9, 1,  3, 1}, // #268
  {DBGFIELD("WriteVecIMulX")      1, false, false, false, 1687, 4,  8, 1,  0, 0}, // #269
  {DBGFIELD("WriteVecMOVMSK")     2, false, false, false, 1727, 7, 23, 1,  0, 0}, // #270
  {DBGFIELD("WriteShuffleXLd")    1, false, false, false, 1825, 5,  6, 1,  0, 0}, // #271
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 1, false, false, false, 1980, 7,  7, 1,  3, 1}, // #272
  {DBGFIELD("WritePMULLD")        1, false, false, false, 1981, 5, 14, 1,  0, 0}, // #273
  {DBGFIELD("WriteCopy")          2, false, false, false, 1987, 3,  3, 1,  0, 0}, // #274
  {DBGFIELD("WritePOPCNTLd")      1, false, false, false, 1735, 4,  2, 1,  0, 0}, // #275
  {DBGFIELD("WritePOPCNT")        1, false, false, false, 1736, 2,  8, 1,  0, 0}, // #276
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 2, false, false, false, 1825, 5,  9, 1,  3, 1}, // #277
  {DBGFIELD("WritePSADBWX")       2, false, false, false, 1815, 3,  8, 1,  0, 0}, // #278
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 1, false, false, false, 1888, 5,  2, 1,  3, 1}, // #279
  {DBGFIELD("WriteVarShuffleX")   1, false, false, false, 1889, 3,  5, 1,  0, 0}, // #280
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #281
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 1, false, false, false, 1825, 5,  2, 1,  3, 1}, // #282
  {DBGFIELD("WriteVecShiftX")     1, false, false, false, 1815, 3,  5, 1,  0, 0}, // #283
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 2, false, false, false, 1726, 9,  3, 1,  3, 1}, // #284
  {DBGFIELD("WriteVecTest")       2, false, false, false, 1727, 7,  1, 1,  0, 0}, // #285
  {DBGFIELD("WriteRotateLd_WriteRMW") 2, false, false, false, 1671, 5, 86, 2,  0, 0}, // #286
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 2, false, false, false, 1990, 5, 86, 2,  0, 0}, // #287
  {DBGFIELD("WriteRotate")        1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #288
  {DBGFIELD("WriteRotateCL")      1, false, false, false, 1648, 2,  1, 1,  0, 0}, // #289
  {DBGFIELD("WriteFRcpXLd")       1, false, false, false, 1922, 6,  7, 1,  0, 0}, // #290
  {DBGFIELD("WriteFRcpX")         1, false, false, false, 1923, 4, 14, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRcpLd")        1, false, false, false, 1922, 6,  7, 1,  0, 0}, // #292
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 1, false, false, false, 1922, 6,  7, 1,  3, 1}, // #293
  {DBGFIELD("WriteFRcp")          1, false, false, false, 1923, 4, 14, 1,  0, 0}, // #294
  {DBGFIELD("WriteRMW")           1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #295
  {DBGFIELD("WriteShiftLd")       1, false, false, false, 1676, 4, 14, 1,  0, 0}, // #296
  {DBGFIELD("WriteShift")         1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #297
  {DBGFIELD("WriteFRndLd")        1, false, false, false, 1995, 6,  9, 1,  0, 0}, // #298
  {DBGFIELD("WriteFRnd")          1, false, false, false, 1821, 4,  8, 1,  0, 0}, // #299
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 1, false, false, false, 1995, 6,  9, 1,  3, 1}, // #300
  {DBGFIELD("WriteFRsqrtXLd")     1, false, false, false, 1922, 6,  7, 1,  0, 0}, // #301
  {DBGFIELD("WriteFRsqrtX")       1, false, false, false, 1923, 4, 14, 1,  0, 0}, // #302
  {DBGFIELD("WriteFRsqrtLd")      1, false, false, false, 2001, 6,  7, 1,  0, 0}, // #303
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 1, false, false, false, 2001, 6,  7, 1,  3, 1}, // #304
  {DBGFIELD("WriteFRsqrt")        1, false, false, false, 2002, 4, 14, 1,  0, 0}, // #305
  {DBGFIELD("WriteShiftLd_WriteRMW") 2, false, false, false, 1671, 5, 86, 2,  0, 0}, // #306
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 2, false, false, false, 1990, 5, 86, 2,  0, 0}, // #307
  {DBGFIELD("WriteShiftCL")       1, false, false, false, 1648, 2,  1, 1,  0, 0}, // #308
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 1676, 4, 14, 1, 24, 1}, // #309
  {DBGFIELD("WriteSETCCStore")    1, false, false, false, 2007, 4,  1, 1,  0, 0}, // #310
  {DBGFIELD("WriteSETCC")         1, false, false, false, 1648, 2,  1, 1,  0, 0}, // #311
  {DBGFIELD("WriteSHDmrcl")       8, false, false, false, 2011, 4,  8, 1,  0, 0}, // #312
  {DBGFIELD("WriteSHDmri")        8, false, false, false, 2011, 4,  8, 1,  0, 0}, // #313
  {DBGFIELD("WriteSHDrrcl")       7, false, false, false, 1702, 2,  5, 1,  0, 0}, // #314
  {DBGFIELD("WriteFSqrt64XLd")    1, false, false, false, 1782, 6, 10, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrt64X")      1, false, false, false, 1783, 4,  9, 1,  0, 0}, // #316
  {DBGFIELD("WriteFSqrtXLd")      1, false, false, false, 1782, 6, 10, 1,  0, 0}, // #317
  {DBGFIELD("WriteFSqrtX")        1, false, false, false, 1783, 4,  9, 1,  0, 0}, // #318
  {DBGFIELD("WriteFSqrt64Ld")     1, false, false, false, 1782, 6, 10, 1,  0, 0}, // #319
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 1, false, false, false, 1782, 6, 10, 1,  3, 1}, // #320
  {DBGFIELD("WriteFSqrt64")       1, false, false, false, 1783, 4,  9, 1,  0, 0}, // #321
  {DBGFIELD("WriteFSqrtLd")       1, false, false, false, 1782, 6, 10, 1,  0, 0}, // #322
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 1, false, false, false, 1782, 6, 10, 1,  3, 1}, // #323
  {DBGFIELD("WriteFSqrt")         1, false, false, false, 1783, 4,  9, 1,  0, 0}, // #324
  {DBGFIELD("WriteFSqrt80")       1, false, false, false, 2015, 4,  1, 1,  0, 0}, // #325
  {DBGFIELD("WriteSTMXCSR")       2, false, false, false, 2019, 2,  1, 1,  0, 0}, // #326
  {DBGFIELD("WriteTZCNTLd")       2, false, false, false, 1895, 5,  3, 1,  0, 0}, // #327
  {DBGFIELD("WriteTZCNT")         2, false, false, false, 1896, 3, 13, 1,  0, 0}, // #328
  {DBGFIELD("WriteFMAZLd")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #329
  {DBGFIELD("WriteFMALd")         1, false, false, false, 2021, 4,  7, 1,  0, 0}, // #330
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 2, false, false, false, 2025, 6,  7, 1,  3, 1}, // #331
  {DBGFIELD("WriteFAdd64Y")       2, false, false, false, 2026, 4, 14, 1,  0, 0}, // #332
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteFAdd64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 2, false, false, false, 2025, 6,  7, 1,  3, 1}, // #335
  {DBGFIELD("WriteFAddY")         2, false, false, false, 2026, 4, 14, 1,  0, 0}, // #336
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteFAddZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 1911, 5,  6, 1,  3, 1}, // #339
  {DBGFIELD("WriteShuffleY")      2, false, false, false, 1912, 3, 13, 1,  0, 0}, // #340
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteShuffleZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 2, false, false, false, 2031, 5,  6, 1,  3, 1}, // #343
  {DBGFIELD("WriteFLogicY")       2, false, false, false, 2032, 3, 13, 1,  0, 0}, // #344
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #345
  {DBGFIELD("WriteFLogicZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #346
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 2, false, false, false, 2036, 5,  6, 1,  3, 1}, // #347
  {DBGFIELD("WriteFVarBlendY")    2, false, false, false, 2037, 3, 13, 1,  0, 0}, // #348
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #349
  {DBGFIELD("WriteFVarBlendZ")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 2, false, false, false, 2041, 5,  6, 1,  3, 1}, // #351
  {DBGFIELD("WriteFBlendY")       2, false, false, false, 2042, 3, 13, 1,  0, 0}, // #352
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 2036, 5,  6, 1,  3, 2}, // #353
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 1657, 5,  6, 1,  3, 2}, // #354
  {DBGFIELD("WriteShuffle256Ld")  1, false, false, false, 1906, 5,  3, 1,  0, 0}, // #355
  {DBGFIELD("WriteShuffle256")    1, false, false, false, 1629, 3,  1, 1,  0, 0}, // #356
  {DBGFIELD("WriteShuffleYLd")    2, false, false, false, 1911, 5,  6, 1,  0, 0}, // #357
  {DBGFIELD("WriteFShuffle256")   2, false, false, false, 1658, 3, 13, 1,  0, 0}, // #358
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, false, 1657, 5,  6, 1,  0, 0}, // #359
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 2, false, false, false, 2025, 6,  6, 1,  3, 1}, // #360
  {DBGFIELD("WriteFCmp64Y")       2, false, false, false, 2026, 4, 13, 1,  0, 0}, // #361
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 2, false, false, false, 2025, 6,  6, 1,  3, 1}, // #362
  {DBGFIELD("WriteFCmpY")         2, false, false, false, 2026, 4, 13, 1,  0, 0}, // #363
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #364
  {DBGFIELD("WriteFCmpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("WriteVarShuffle256Ld") 1, false, false, false, 1906, 5,  3, 1,  0, 0}, // #366
  {DBGFIELD("WriteVarShuffle256") 1, false, false, false, 1629, 3,  1, 1,  0, 0}, // #367
  {DBGFIELD("WriteCvtI2PDYLd")    5, false, false, false, 1757, 7, 22, 1,  0, 0}, // #368
  {DBGFIELD("WriteCvtI2PDY")      4, false, false, false, 1758, 5,  2, 1,  0, 0}, // #369
  {DBGFIELD("WriteCvtI2PDZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #370
  {DBGFIELD("WriteCvtI2PDZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, false, 1757, 7,  9, 1,  0, 0}, // #372
  {DBGFIELD("WriteCvtI2PSY")      2, false, false, false, 1758, 5,  8, 1,  0, 0}, // #373
  {DBGFIELD("WriteCvtI2PSZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #374
  {DBGFIELD("WriteCvtI2PSZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 2, false, false, false, 1739, 7, 22, 1,  3, 1}, // #376
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 4, false, false, false, 2046, 8, 22, 1,  3, 1}, // #377
  {DBGFIELD("WriteCvtPD2PSY")     4, false, false, false, 2047, 6,  2, 1,  0, 0}, // #378
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtPD2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteCvtPD2PSYLd")   4, false, false, false, 2046, 8, 22, 1,  0, 0}, // #381
  {DBGFIELD("WriteCvtPD2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #382
  {DBGFIELD("WriteCvtPD2IYLd")    4, false, false, false, 2046, 8, 22, 1,  0, 0}, // #383
  {DBGFIELD("WriteCvtPD2IY")      4, false, false, false, 2047, 6,  2, 1,  0, 0}, // #384
  {DBGFIELD("WriteCvtPD2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #385
  {DBGFIELD("WriteCvtPD2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, false, 1757, 7,  9, 1,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2IY")      2, false, false, false, 1758, 5,  8, 1,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2PDYLd")   5, false, false, false, 1757, 7, 22, 1,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PDY")     4, false, false, false, 1758, 5,  2, 1,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PDZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PDZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtPH2PSYLd")   7, false, false, false, 1757, 7, 22, 1,  0, 0}, // #395
  {DBGFIELD("WriteCvtPH2PSY")     4, false, false, false, 1758, 5,  2, 1,  0, 0}, // #396
  {DBGFIELD("WriteCvtPH2PSLd")    3, false, false, false, 1757, 7, 22, 1,  0, 0}, // #397
  {DBGFIELD("WriteCvtPH2PS")      2, false, false, false, 1758, 5,  2, 1,  0, 0}, // #398
  {DBGFIELD("WriteCvtPH2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteCvtPH2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD("WriteCvtPS2PHYSt")   4, false, false, false, 2054, 8,  8, 1,  0, 0}, // #401
  {DBGFIELD("WriteCvtPS2PHY")     4, false, false, false, 2047, 6,  2, 1,  0, 0}, // #402
  {DBGFIELD("WriteCvtPS2PHSt")    3, false, false, false, 2062, 7,  8, 1,  0, 0}, // #403
  {DBGFIELD("WriteCvtPS2PH")      2, false, false, false, 1758, 5,  2, 1,  0, 0}, // #404
  {DBGFIELD("WriteCvtPS2PHZSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteCvtPS2PHZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #406
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 2, false, false, false, 1746, 11, 31, 1,  3, 1}, // #407
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 2, false, false, false, 1746, 11, 31, 1,  3, 1}, // #408
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #409
  {DBGFIELD("WritePSADBWY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #410
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WritePSADBWZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #412
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 2, false, false, false, 2069, 6, 10, 1,  3, 1}, // #413
  {DBGFIELD("WriteFDiv64Y")       2, false, false, false, 2070, 4,  9, 1,  0, 0}, // #414
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WriteFDiv64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 2, false, false, false, 2069, 6, 10, 1,  3, 1}, // #417
  {DBGFIELD("WriteFDivY")         2, false, false, false, 2070, 4,  9, 1,  0, 0}, // #418
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteFDivZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #420
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 1, false, false, false, 2021, 4,  7, 1,  3, 1}, // #421
  {DBGFIELD("WriteFMAX")          1, false, false, false, 1658, 2, 14, 1,  0, 0}, // #422
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 2, false, false, false, 2021, 4,  7, 1,  3, 1}, // #423
  {DBGFIELD("WriteFMAY")          2, false, false, false, 1658, 2, 14, 1,  0, 0}, // #424
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteFMAZ")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #426
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 29, false, false, false, 2075, 6, 63, 1,  3, 1}, // #427
  {DBGFIELD("WriteDPPSY")         25, false, false, false, 2076, 4, 46, 1,  0, 0}, // #428
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 1, false, false, false, 1906, 5,  3, 1,  3, 1}, // #429
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 2021, 4,  7, 1, 16, 2}, // #430
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 2021, 4,  7, 1, 16, 2}, // #431
  {DBGFIELD("WriteFMALd_ReadAfterVecLd") 1, false, false, false, 2021, 4,  7, 1,  3, 1}, // #432
  {DBGFIELD("WriteFMA")           1, false, false, false, 1658, 2, 14, 1,  0, 0}, // #433
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 1, false, false, false, 2021, 4,  7, 1, 16, 2}, // #434
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 2021, 4,  7, 1,  3, 2}, // #435
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 2021, 4,  7, 1,  3, 2}, // #436
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 1, false, false, false, 2021, 4,  7, 1,  3, 2}, // #437
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 2, false, false, false, 2081, 6,  9, 1,  3, 1}, // #438
  {DBGFIELD("WriteFRndY")         2, false, false, false, 1803, 4,  8, 1,  0, 0}, // #439
  {DBGFIELD("WriteLoad_WriteVecMaskedGatherWriteback") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #440
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteFRndZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #443
  {DBGFIELD("WriteVecIMulY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #444
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #445
  {DBGFIELD("WriteVecIMulZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("WriteVecALUY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("WriteVecALUZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #450
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 10, false, false, false, 2087, 6, 19, 1,  3, 1}, // #451
  {DBGFIELD("WriteFHAddY")        8, false, false, false, 2088, 4, 18, 1,  0, 0}, // #452
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 1657, 5,  6, 1,  3, 1}, // #453
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 1, false, false, false, 1906, 5,  3, 1,  3, 1}, // #454
  {DBGFIELD("WriteVecLoadY")      2, false, false, false, 2093, 5, 14, 1,  0, 0}, // #455
  {DBGFIELD("WriteFMaskedStore64Y") 34, false, false, false, 2098, 5,  3, 1,  0, 0}, // #456
  {DBGFIELD("WriteFMaskedLoadY")  2, false, false, false, 2036, 5,  3, 1,  0, 0}, // #457
  {DBGFIELD("WriteFMaskedStore64") 18, false, false, false, 2103, 5,  3, 1,  0, 0}, // #458
  {DBGFIELD("WriteFMaskedLoad")   1, false, false, false, 2108, 5,  3, 1,  0, 0}, // #459
  {DBGFIELD("WriteFMaskedStore32Y") 34, false, false, false, 2098, 5,  3, 1,  0, 0}, // #460
  {DBGFIELD("WriteFMaskedStore32") 18, false, false, false, 2103, 5,  3, 1,  0, 0}, // #461
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #462
  {DBGFIELD("WriteFCmp64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #463
  {DBGFIELD("WriteFMoveY")        2, false, false, false, 2032, 3, 13, 1,  0, 0}, // #464
  {DBGFIELD("WriteFMoveZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #465
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, false, 2036, 5,  6, 1,  0, 0}, // #466
  {DBGFIELD("WriteFShuffleY")     2, false, false, false, 2037, 3, 13, 1,  0, 0}, // #467
  {DBGFIELD("WriteFShuffleZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteFShuffleZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #469
  {DBGFIELD("WriteVecStoreY")     4, false, false, false, 2113, 5,  1, 1,  0, 0}, // #470
  {DBGFIELD("WriteVecMoveY")      2, false, false, false, 2118, 3, 13, 1,  0, 0}, // #471
  {DBGFIELD("WriteVecMoveZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #472
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, false, 2121, 5, 14, 1,  0, 0}, // #473
  {DBGFIELD("WriteVecStoreNTY")   4, false, false, false, 2126, 6, 13, 1,  0, 0}, // #474
  {DBGFIELD("WriteFStoreNTY")     4, false, false, false, 2126, 6,  5, 1,  0, 0}, // #475
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #476
  {DBGFIELD("WriteMPSADY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #477
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 2, false, false, false, 2001, 6,  7, 1,  3, 1}, // #478
  {DBGFIELD("WriteFMul64Y")       2, false, false, false, 2002, 4, 14, 1,  0, 0}, // #479
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteFMul64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 2, false, false, false, 2001, 6,  7, 1,  3, 1}, // #482
  {DBGFIELD("WriteFMulY")         2, false, false, false, 2002, 4, 14, 1,  0, 0}, // #483
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #484
  {DBGFIELD("WriteFMulZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #485
  {DBGFIELD("WriteVecALUYLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("WriteVecALUZLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #488
  {DBGFIELD("WriteVecLogicY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #489
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteVecLogicZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #492
  {DBGFIELD("WriteBlendY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #493
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #494
  {DBGFIELD("WriteVarBlendY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #495
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteVarBlendZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #498
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 1825, 5,  6, 1,  3, 2}, // #499
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 1911, 5,  6, 1,  3, 2}, // #500
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 1911, 5,  6, 1, 16, 2}, // #501
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 1825, 5,  6, 1,  3, 2}, // #502
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 1825, 5,  6, 1, 16, 2}, // #503
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #504
  {DBGFIELD("WriteFVarShuffle256") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #505
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 2036, 5,  2, 1,  3, 2}, // #506
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 2036, 5,  2, 1, 16, 2}, // #507
  {DBGFIELD("WriteFVarShuffleY")  2, false, false, false, 2037, 3,  5, 1,  0, 0}, // #508
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 1692, 5,  2, 1,  3, 2}, // #509
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 1692, 5,  2, 1, 16, 2}, // #510
  {DBGFIELD("WriteFVarShuffle")   1, false, false, false, 1693, 3,  5, 1,  0, 0}, // #511
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 2036, 5,  2, 1,  3, 1}, // #512
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 1, false, false, false, 1692, 5,  2, 1,  3, 1}, // #513
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #514
  {DBGFIELD("WriteFVarShuffleZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #515
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #516
  {DBGFIELD("WritePHAddY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #517
  {DBGFIELD("WriteVecInsert")     2, false, false, false, 1889, 3, 13, 1,  0, 0}, // #518
  {DBGFIELD("WriteVecIMulXLd")    1, false, false, false, 1686, 6,  9, 1,  0, 0}, // #519
  {DBGFIELD("WriteVecIMulYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #520
  {DBGFIELD("WriteVecIMulZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #521
  {DBGFIELD("WriteVecMaskedStore32Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #522
  {DBGFIELD("WriteVecMaskedLoadY") 2, false, false, false, 2121, 5,  3, 1,  0, 0}, // #523
  {DBGFIELD("WriteVecMaskedStore32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #524
  {DBGFIELD("WriteVecMaskedLoad") 1, false, false, false, 1825, 5,  3, 1,  0, 0}, // #525
  {DBGFIELD("WriteVecMaskedStore64Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #526
  {DBGFIELD("WriteVecMaskedStore64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #527
  {DBGFIELD("WriteVPMOV256Ld")    1, false, false, false, 1906, 5,  3, 1,  0, 0}, // #528
  {DBGFIELD("WriteVPMOV256")      1, false, false, false, 1629, 3,  1, 1,  0, 0}, // #529
  {DBGFIELD("WriteVecMOVMSKY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #530
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #531
  {DBGFIELD("WritePMULLDY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #532
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WritePMULLDZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #534
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 1888, 5,  2, 1,  3, 2}, // #535
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 1888, 5,  2, 1, 16, 2}, // #536
  {DBGFIELD("WriteVecShiftImmXLd") 1, false, false, false, 1825, 5,  6, 1,  0, 0}, // #537
  {DBGFIELD("WriteVecShiftImmYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #538
  {DBGFIELD("WriteVecShiftImmY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #539
  {DBGFIELD("WriteVecShiftImmZLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #540
  {DBGFIELD("WriteVecShiftImmZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #541
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 1, false, false, false, 1825, 5,  2, 1,  3, 1}, // #542
  {DBGFIELD("WriteVarVecShift")   1, false, false, false, 1815, 3,  5, 1,  0, 0}, // #543
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #544
  {DBGFIELD("WriteVarVecShiftY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #545
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #546
  {DBGFIELD("WriteVarVecShiftZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #547
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 1, false, false, false, 1825, 5,  6, 1,  3, 1}, // #548
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteVarShuffleY")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #550
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #551
  {DBGFIELD("WriteVarShuffleZ")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #552
  {DBGFIELD("WriteShuffleZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #553
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #554
  {DBGFIELD("WriteVecShiftY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #555
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteVecShiftZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 6, false, false, false, 2132, 8,  3, 1,  3, 1}, // #558
  {DBGFIELD("WriteVecTestY")      4, false, false, false, 2133, 6,  1, 1,  0, 0}, // #559
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 1, false, false, false, 1922, 6,  7, 1,  3, 1}, // #560
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 2, false, false, false, 2140, 6,  7, 1,  3, 1}, // #561
  {DBGFIELD("WriteFRcpY")         2, false, false, false, 2141, 4, 14, 1,  0, 0}, // #562
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #563
  {DBGFIELD("WriteFRcpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #564
  {DBGFIELD("WriteFRcpYLd")       2, false, false, false, 2140, 6,  7, 1,  0, 0}, // #565
  {DBGFIELD("WriteFRndYLd")       2, false, false, false, 2081, 6,  9, 1,  0, 0}, // #566
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 1, false, false, false, 1922, 6,  7, 1,  3, 1}, // #567
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 2, false, false, false, 2146, 6,  7, 1,  3, 1}, // #568
  {DBGFIELD("WriteFRsqrtY")       2, false, false, false, 2147, 4, 14, 1,  0, 0}, // #569
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #570
  {DBGFIELD("WriteFRsqrtZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #571
  {DBGFIELD("WriteFRsqrtYLd")     2, false, false, false, 2146, 6,  7, 1,  0, 0}, // #572
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 2036, 5,  6, 1,  3, 1}, // #573
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #574
  {DBGFIELD("WriteFSqrt64YLd")    2, false, false, false, 2069, 6, 10, 1,  0, 0}, // #575
  {DBGFIELD("WriteFSqrt64Y")      2, false, false, false, 2070, 4,  9, 1,  0, 0}, // #576
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 1, false, false, false, 1782, 6, 10, 1,  3, 1}, // #577
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 2, false, false, false, 2069, 6, 10, 1,  3, 1}, // #578
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #579
  {DBGFIELD("WriteFSqrt64Z")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #580
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 1, false, false, false, 1782, 6, 10, 1,  3, 1}, // #581
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 2, false, false, false, 2069, 6, 10, 1,  3, 1}, // #582
  {DBGFIELD("WriteFSqrtY")        2, false, false, false, 2070, 4,  9, 1,  0, 0}, // #583
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #584
  {DBGFIELD("WriteFSqrtZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #585
  {DBGFIELD("WriteFSqrtYLd")      2, false, false, false, 2069, 6, 10, 1,  0, 0}, // #586
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 6, false, false, false, 2152, 8,  3, 1,  3, 1}, // #587
  {DBGFIELD("WriteFTestY")        4, false, false, false, 2153, 6,  1, 1,  0, 0}, // #588
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 2, false, false, false, 1726, 9,  3, 1,  3, 1}, // #589
  {DBGFIELD("WriteFTest")         2, false, false, false, 1727, 7,  1, 1,  0, 0}, // #590
  {DBGFIELD("WriteALULd_WriteRMW") 2, false, false, false, 1671, 5, 86, 2,  0, 0}, // #591
  {DBGFIELD("WriteXCHG")          2, false, false, false, 1633, 3,  1, 1,  0, 0}, // #592
  {DBGFIELD("COPY")               1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #593
  {DBGFIELD("XAM_F")              2, false, false, false, 1727, 7,  1, 1,  0, 0}, // #594
  {DBGFIELD("LD_Frr")             1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #595
  {DBGFIELD("MOVSX64rr32")        1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #596
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 2, false, false, false, 1671, 5, 86, 2,  0, 0}, // #597
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 2, false, false, false, 1990, 5, 86, 2,  0, 0}, // #598
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 2, false, false, false, 1671, 5, 86, 2,  0, 0}, // #599
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 2, false, false, false, 1990, 5, 86, 2,  0, 0}, // #600
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #601
  {DBGFIELD("FCOMPP")             1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #602
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, false, 1923, 4,  1, 1,  0, 0}, // #603
  {DBGFIELD("MMX_CVTPI2PSrr")     2, false, false, false, 1740, 5,  8, 1,  0, 0}, // #604
  {DBGFIELD("MMX_CVTPI2PSrm")     1, false, false, false, 1739, 7,  9, 1,  0, 0}, // #605
  {DBGFIELD("MMX_CVTPS2PIrr_MMX_CVTTPS2PIrr") 1, false, false, false, 1740, 5,  8, 1,  0, 0}, // #606
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, false, 1721, 2, 14, 1,  0, 0}, // #607
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #608
  {DBGFIELD("XCH_F")              1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #609
  {DBGFIELD("RETI16_RETI32_RETI64_IRET_IRET16_IRET32_IRET64") 1, false, false, false, 1642, 6, 14, 1,  0, 0}, // #610
  {DBGFIELD("MMX_CVTPS2PIrm_MMX_CVTTPS2PIrm") 1, false, false, false, 1739, 7,  9, 1,  0, 0}, // #611
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 1, false, false, false, 1721, 2, 14, 1,  0, 0}, // #612
  {DBGFIELD("CVTSI642SDrm")       2, false, false, false, 1739, 7,  9, 1,  0, 0}, // #613
  {DBGFIELD("CVTSI642SDrm_Int")   2, false, false, false, 1739, 7,  9, 1,  3, 1}, // #614
  {DBGFIELD("CVTSI642SSrr")       2, false, false, false, 2160, 5, 22, 1,  0, 0}, // #615
  {DBGFIELD("CVTSI642SSrr_Int")   2, false, false, false, 1740, 5,  8, 1, 29, 1}, // #616
  {DBGFIELD("CVTSI642SSrm")       2, false, false, false, 1739, 7,  9, 1,  0, 0}, // #617
  {DBGFIELD("CVTSI642SSrm_Int")   2, false, false, false, 1739, 7,  9, 1,  3, 1}, // #618
  {DBGFIELD("CVTSS2SI64rr_CVTTSS2SI64rr") 2, false, false, false, 1747, 9, 22, 1,  0, 0}, // #619
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 2, false, false, false, 1747, 9, 22, 1,  0, 0}, // #620
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 2, false, false, false, 1746, 11, 31, 1,  0, 0}, // #621
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #622
  {DBGFIELD("LFENCE")             1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #623
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, false, 1693, 3, 13, 1,  0, 0}, // #624
  {DBGFIELD("LEAVE_LEAVE64")      1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #625
  {DBGFIELD("POP16r")             1, false, false, false, 1721, 2, 14, 1,  0, 0}, // #626
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 2, false, false, false, 1987, 3,  3, 1,  0, 0}, // #627
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #628
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #629
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #630
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #631
  {DBGFIELD("MMX_PADDQrr_MMX_PSUBQrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #632
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #633
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64_MASKMOVDQUX32") 1, false, false, false, 1652, 5,  1, 1,  0, 0}, // #634
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  1, false, false, false, 1652, 5,  1, 1,  0, 0}, // #635
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #636
  {DBGFIELD("CLD")                1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #637
  {DBGFIELD("LDDQUrm")            1, false, false, false, 1888, 5, 14, 1,  0, 0}, // #638
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #639
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 2, false, false, false, 1987, 3,  3, 1,  0, 0}, // #640
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 2, false, false, false, 1671, 5, 86, 2,  0, 0}, // #641
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, false, 1912, 3, 14, 1,  0, 0}, // #642
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, false, 1676, 4, 14, 1,  0, 0}, // #643
  {DBGFIELD("MMX_PADDQrm_MMX_PSUBQrm") 1, false, false, false, 1906, 5,  6, 1,  3, 1}, // #644
  {DBGFIELD("MOVDQUrm")           1, false, false, false, 1888, 5, 14, 1,  0, 0}, // #645
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, false, 1657, 5, 14, 1,  0, 0}, // #646
  {DBGFIELD("PADDQrm_PSUBQrm")    1, false, false, false, 1825, 5,  6, 1,  3, 1}, // #647
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #648
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   1, false, false, false, 1632, 4,  1, 1,  0, 0}, // #649
  {DBGFIELD("LD_F80m")            1, false, false, false, 1721, 2, 14, 1,  0, 0}, // #650
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, false, 1911, 5,  7, 1,  0, 0}, // #651
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 2, false, false, false, 1808, 7, 23, 1,  0, 0}, // #652
  {DBGFIELD("FLDCW16m")           1, false, false, false, 1721, 2, 14, 1,  0, 0}, // #653
  {DBGFIELD("ST_FP80m")           1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #654
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, false, 1912, 3, 14, 1,  0, 0}, // #655
  {DBGFIELD("CMPXCHG8rm")         5, false, false, false, 2165, 3,  5, 1,  0, 0}, // #656
  {DBGFIELD("INTO")               1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #657
  {DBGFIELD("XLAT")               1, false, false, false, 1648, 2,  3, 1,  0, 0}, // #658
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 7, false, false, false, 1702, 2,  5, 1,  0, 0}, // #659
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 6, false, false, false, 1650, 2,  5, 1,  0, 0}, // #660
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 8, false, false, false, 2011, 4,  8, 1,  0, 0}, // #661
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 8, false, false, false, 2011, 4,  8, 1,  0, 0}, // #662
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #663
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, false, 1911, 5,  7, 1,  3, 1}, // #664
  {DBGFIELD("AAD8i8")             1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #665
  {DBGFIELD("LOOPE")              1, false, false, false, 1632, 4,  1, 1,  0, 0}, // #666
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #667
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 7, false, false, false, 1702, 2,  5, 1,  0, 0}, // #668
  {DBGFIELD("FNSTCW16m")          1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #669
  {DBGFIELD("POPA16_POPA32")      1, false, false, false, 1721, 2, 14, 1,  0, 0}, // #670
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #671
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 8, false, false, false, 2011, 4,  8, 1,  0, 0}, // #672
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 8, false, false, false, 2011, 4,  8, 1,  0, 0}, // #673
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 6, false, false, false, 1650, 2,  5, 1,  0, 0}, // #674
  {DBGFIELD("CMPXCHG8rr")         3, false, false, false, 1723, 3,  5, 1,  0, 0}, // #675
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80") 2, false, false, false, 1727, 7,  1, 1,  0, 0}, // #676
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #677
  {DBGFIELD("AAA_AAS")            1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #678
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 6, false, false, false, 2168, 3,  5, 1,  0, 0}, // #679
  {DBGFIELD("LOOPNE")             1, false, false, false, 1632, 4,  1, 1,  0, 0}, // #680
  {DBGFIELD("PAUSE")              1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #681
  {DBGFIELD("CMPXCHG8B")          18, false, false, false, 2171, 3,  5, 1,  0, 0}, // #682
  {DBGFIELD("DAA")                1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #683
  {DBGFIELD("LOOP")               1, false, false, false, 1632, 4,  1, 1,  0, 0}, // #684
  {DBGFIELD("DAS")                1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #685
  {DBGFIELD("AAM8i8")             1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #686
  {DBGFIELD("STD")                1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #687
  {DBGFIELD("CMPXCHG16B")         22, false, false, false, 2174, 3,  5, 1,  0, 0}, // #688
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #689
  {DBGFIELD("FNCLEX_FXTRACT")     1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #690
  {DBGFIELD("POPF32_POPF64")      1, false, false, false, 1721, 2, 14, 1,  0, 0}, // #691
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #692
  {DBGFIELD("RDTSC_RDTSCP")       1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #693
  {DBGFIELD("ENTER")              1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #694
  {DBGFIELD("POPF16")             1, false, false, false, 1721, 2, 14, 1,  0, 0}, // #695
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #696
  {DBGFIELD("FRNDINT")            1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #697
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #698
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #699
  {DBGFIELD("FPREM")              1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #700
  {DBGFIELD("INSB_INSL_INSW")     1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #701
  {DBGFIELD("FNINIT")             1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #702
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #703
  {DBGFIELD("FPREM1")             1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #704
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #705
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #706
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #707
  {DBGFIELD("FSCALE")             1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #708
  {DBGFIELD("RDMSR")              1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #709
  {DBGFIELD("RET_RET16_RET32_RET64_LRET16_LRET32_LRET64_LRETI16_LRETI32_LRETI64") 1, false, false, false, 1642, 6, 14, 1,  0, 0}, // #710
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #711
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #712
  {DBGFIELD("F2XM1")              1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #713
  {DBGFIELD("CPUID")              1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #714
  {DBGFIELD("INT")                1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #715
  {DBGFIELD("INT3")               1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #716
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #717
  {DBGFIELD("FXRSTOR_FXRSTOR64")  1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #718
  {DBGFIELD("FYL2X")              1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #719
  {DBGFIELD("FYL2XP1")            1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #720
  {DBGFIELD("FPTAN")              1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #721
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #722
  {DBGFIELD("FPATAN")             1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #723
  {DBGFIELD("WRMSR")              1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #724
  {DBGFIELD("COMP_FST0r_COM_FST0r") 2, false, false, false, 1727, 7,  1, 1,  0, 0}, // #725
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   2, false, false, false, 1727, 7,  1, 1,  0, 0}, // #726
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #727
  {DBGFIELD("FNOP")               1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #728
  {DBGFIELD("RET64")              1, false, false, false, 1642, 6, 14, 1,  0, 0}, // #729
  {DBGFIELD("CDQ_CQO")            1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #730
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, false, 1629, 3, 13, 1,  0, 0}, // #731
  {DBGFIELD("MMX_PADDQrr")        1, false, false, false, 1629, 3, 13, 1,  0, 0}, // #732
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #733
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #734
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int_VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 2, false, false, false, 1727, 7,  1, 1,  0, 0}, // #735
  {DBGFIELD("CWD")                1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #736
  {DBGFIELD("FNSTSW16r")          1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #737
  {DBGFIELD("MMX_MOVDQ2Qrr")      1, false, false, false, 1815, 3,  1, 1,  0, 0}, // #738
  {DBGFIELD("PUSHFS64")           1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #739
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 2, false, false, false, 1808, 7, 23, 1,  0, 0}, // #740
  {DBGFIELD("RCL16r1_RCL32r1_RCL64r1_RCL8r1_RCR16r1_RCR32r1_RCR64r1_RCR8r1") 1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #741
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 2, false, false, false, 1727, 7,  1, 1,  0, 0}, // #742
  {DBGFIELD("MOV64sr")            1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #743
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVSX32rm16_MOVSX32rm32_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false, false, 1676, 4, 14, 1,  0, 0}, // #744
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 24, false, false, false, 2012, 2, 18, 1,  0, 0}, // #745
  {DBGFIELD("RCL16ri_RCL32ri_RCL64ri_RCL8ri_RCR16ri_RCR32ri_RCR64ri_RCR8ri") 25, false, false, false, 2177, 2, 22, 1,  0, 0}, // #746
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #747
  {DBGFIELD("CLI")                1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #748
  {DBGFIELD("PUSHGS64")           1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #749
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #750
  {DBGFIELD("CALL64pcrel32")      1, false, false, false, 1632, 4,  1, 1,  0, 0}, // #751
  {DBGFIELD("CALL64r_RVMARKER_CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false, false, 1632, 4,  1, 1,  0, 0}, // #752
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 2, false, false, false, 1802, 6, 22, 1,  0, 0}, // #753
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #754
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 2, false, false, false, 1802, 6, 22, 1,  0, 0}, // #755
  {DBGFIELD("PUSHF16_PUSHF64")    1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #756
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 1, false, false, false, 1721, 2, 14, 1,  0, 0}, // #757
  {DBGFIELD("MMX_MOVD64from64rm") 1, false, false, false, 1652, 5, 13, 1,  0, 0}, // #758
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, false, 1692, 5,  6, 1,  0, 0}, // #759
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, false, 1888, 5, 14, 1,  0, 0}, // #760
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 1692, 5,  6, 1,  0, 0}, // #761
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, false, 1657, 5, 14, 1,  0, 0}, // #762
  {DBGFIELD("MOV16sm")            1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #763
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 1, false, false, false, 1906, 5,  6, 1,  0, 0}, // #764
  {DBGFIELD("MMX_PALIGNRrmi")     1, false, false, false, 1825, 5,  6, 1,  3, 1}, // #765
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 1, false, false, false, 1906, 5,  6, 1,  3, 1}, // #766
  {DBGFIELD("LODSL_LODSQ")        1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #767
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 2, false, false, false, 2179, 5,  3, 1, 26, 1}, // #768
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 2, false, false, false, 2036, 5,  6, 1,  0, 0}, // #769
  {DBGFIELD("VINSERTF128rm")      2, false, false, false, 1657, 5,  6, 1,  3, 1}, // #770
  {DBGFIELD("MMX_PADDQrm")        1, false, false, false, 1906, 5,  6, 1,  3, 1}, // #771
  {DBGFIELD("VERRm_VERWm")        1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #772
  {DBGFIELD("FARJMP64m")          1, false, false, false, 1632, 4,  1, 1,  0, 0}, // #773
  {DBGFIELD("FNSTSWm")            1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #774
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #775
  {DBGFIELD("CALL64m_RVMARKER_CALL64m_CALL64m_NT") 1, false, false, false, 1632, 4,  1, 1,  0, 0}, // #776
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 1, false, false, false, 1642, 6, 14, 1,  0, 0}, // #777
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int_VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 2, false, false, false, 1726, 9,  3, 1,  3, 1}, // #778
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #779
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 2, false, false, false, 1671, 5, 86, 2,  0, 0}, // #780
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 4, false, false, false, 2184, 3,  3, 1,  0, 0}, // #781
  {DBGFIELD("FARCALL64m")         1, false, false, false, 1632, 4,  1, 1,  0, 0}, // #782
  {DBGFIELD("CVTSD2SI64rm_CVTSD2SI64rm_Int_CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 2, false, false, false, 1746, 11, 31, 1,  0, 0}, // #783
  {DBGFIELD("CVTSS2SIrm_CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 2, false, false, false, 1746, 11, 31, 1,  0, 0}, // #784
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, false, 1721, 2, 14, 1,  0, 0}, // #785
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 2, false, false, false, 1990, 5, 86, 2,  0, 0}, // #786
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 2, false, false, false, 1671, 5,  3, 1, 24, 2}, // #787
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 1, false, false, false, 2187, 6, 14, 1,  0, 0}, // #788
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 1, false, false, false, 1825, 5,  6, 1,  3, 1}, // #789
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 2, false, false, false, 1726, 9,  3, 1,  0, 0}, // #790
  {DBGFIELD("MUL_F32m_MUL_F64m")  1, false, false, false, 1788, 6, 14, 1,  0, 0}, // #791
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 1, false, false, false, 2187, 6, 14, 1,  0, 0}, // #792
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 1, false, false, false, 1788, 6, 14, 1,  0, 0}, // #793
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 1, false, false, false, 2193, 6,  9, 1,  0, 0}, // #794
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 1, false, false, false, 2193, 6,  9, 1,  0, 0}, // #795
  {DBGFIELD("VZEROALL")           32, false, false, false,  0, 0, 88, 1,  0, 0}, // #796
  {DBGFIELD("VZEROUPPER")         16, false, false, false,  0, 0, 49, 1,  0, 0}, // #797
  {DBGFIELD("CLC")                1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #798
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #799
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #800
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 2, false, false, false, 2032, 3, 13, 1,  0, 0}, // #801
  {DBGFIELD("PXORrr_VPXORrr")     8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #802
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #803
  {DBGFIELD("PSUBQrr")            8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #804
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #805
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 1, false, false, false, 1648, 2,  1, 1,  0, 0}, // #806
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #807
  {DBGFIELD("SETCCr")             1, false, false, false, 1648, 2,  1, 1,  0, 0}, // #808
  {DBGFIELD("SETCCm")             8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #809
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 1, false, false, false, 1692, 5,  6, 1,  3, 1}, // #810
  {DBGFIELD("RETI16_RETI32_RETI64") 1, false, false, false, 1642, 6, 14, 1,  0, 0}, // #811
  {DBGFIELD("LRETI16_LRETI32_LRETI64") 1, false, false, false, 1642, 6, 14, 1,  0, 0}, // #812
  {DBGFIELD("RDPMC")              1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #813
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #814
  {DBGFIELD("FBLDm")              1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #815
  {DBGFIELD("FFREE_FFREEP")       1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #816
  {DBGFIELD("FSAVEm")             1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #817
  {DBGFIELD("FRSTORm")            1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #818
  {DBGFIELD("FXTRACT")            1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #819
  {DBGFIELD("MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 1692, 5,  6, 1,  0, 0}, // #820
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, false, 1825, 5,  6, 1,  0, 0}, // #821
  {DBGFIELD("VBROADCASTF128")     2, false, false, false, 1658, 3,  6, 1,  0, 0}, // #822
  {DBGFIELD("VBROADCASTI128")     1, false, false, false, 1825, 5,  6, 1,  0, 0}, // #823
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, false, 1825, 5,  6, 1,  0, 0}, // #824
  {DBGFIELD("FBSTPm")             1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #825
  {DBGFIELD("VMPTRSTm")           1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #826
  {DBGFIELD("ST_FP32m_ST_FP64m")  1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #827
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #828
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 1, false, false, false, 1815, 3,  5, 1,  0, 0}, // #829
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false, false, 1629, 3,  8, 1,  0, 0}, // #830
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, false, 1632, 4,  1, 1,  0, 0}, // #831
  {DBGFIELD("FINCSTP")            1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #832
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #833
  {DBGFIELD("VPBLENDDYrri")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #834
  {DBGFIELD("VPBLENDDrri")        1, false, false, false, 1629, 3, 13, 1,  0, 0}, // #835
  {DBGFIELD("CMC_STC")            1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #836
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #837
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 2, false, false, false, 1739, 7, 22, 1,  0, 0}, // #838
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 1, false, false, false, 1825, 5,  2, 1,  3, 1}, // #839
  {DBGFIELD("CVTSS2SDrm")         1, false, false, false, 1757, 7,  9, 1,  0, 0}, // #840
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 1, false, false, false, 1757, 7,  9, 1,  3, 1}, // #841
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #842
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 1, false, false, false, 1676, 4, 14, 1, 26, 1}, // #843
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 1, false, false, false, 1825, 5,  6, 1,  0, 0}, // #844
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 1, false, false, false, 1906, 5,  3, 1,  0, 0}, // #845
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 1, false, false, false, 1642, 6, 14, 1,  0, 0}, // #846
  {DBGFIELD("ANDN32rm_ANDN64rm")  1, false, false, false, 1676, 4, 14, 1, 26, 1}, // #847
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 1, false, false, false, 1676, 4, 14, 1,  0, 0}, // #848
  {DBGFIELD("VINSERTI128rm")      1, false, false, false, 1906, 5,  3, 1,  3, 1}, // #849
  {DBGFIELD("VPBLENDDrmi")        1, false, false, false, 1906, 5,  6, 1,  3, 1}, // #850
  {DBGFIELD("VPBLENDDYrmi")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #851
  {DBGFIELD("POP32r_POP64r")      1, false, false, false, 1721, 2, 14, 1,  0, 0}, // #852
  {DBGFIELD("SFENCE")             1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #853
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #854
  {DBGFIELD("MOVBE16mr")          1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #855
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #856
  {DBGFIELD("MFENCE")             1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #857
  {DBGFIELD("XGETBV")             1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #858
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 2, false, false, false, 1740, 5,  2, 1,  0, 0}, // #859
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 1, false, false, false, 1758, 5,  8, 1,  0, 0}, // #860
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm_MMX_PACKUSWBrm") 1, false, false, false, 1825, 5,  6, 1,  3, 1}, // #861
  {DBGFIELD("LRET64_RET32")       1, false, false, false, 1642, 6, 14, 1,  0, 0}, // #862
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #863
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #864
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, false, 1740, 5,  8, 1,  0, 0}, // #865
  {DBGFIELD("VCVTDQ2PSYrr")       2, false, false, false, 1758, 5,  8, 1,  0, 0}, // #866
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #867
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 1, false, false, false, 1739, 7,  9, 1,  0, 0}, // #868
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, false, 1757, 7,  9, 1,  0, 0}, // #869
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 2, false, false, false, 1757, 7,  9, 1,  0, 0}, // #870
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 1, false, false, false, 1906, 5,  3, 1,  0, 0}, // #871
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr_MMX_PACKUSWBrr") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #872
  {DBGFIELD("CLDEMOTE")           1, false, false, false, 1721, 2, 14, 1,  0, 0}, // #873
  {DBGFIELD("CVTSD2SI64rr_CVTSD2SIrr_CVTTSD2SI64rr_CVTTSD2SIrr_VCVTSD2SI64rr_VCVTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, false, 1747, 9, 22, 1,  0, 0}, // #874
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 2, false, false, false, 1747, 9, 22, 1,  0, 0}, // #875
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, false, 1747, 9, 22, 1,  0, 0}, // #876
  {DBGFIELD("CVTSS2SIrr_CVTTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 2, false, false, false, 1747, 9, 22, 1,  0, 0}, // #877
  {DBGFIELD("VCVTPS2PDYrr")       4, false, false, false, 1758, 5,  2, 1,  0, 0}, // #878
  {DBGFIELD("MMX_CVTPI2PDrr")     2, false, false, false, 1740, 5,  3, 1,  0, 0}, // #879
  {DBGFIELD("MMX_CVTPD2PIrr_MMX_CVTTPD2PIrr") 2, false, false, false, 1740, 5,  3, 1,  0, 0}, // #880
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 2, false, false, false, 1740, 5,  2, 1,  0, 0}, // #881
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 2, false, false, false, 1740, 5,  2, 1,  0, 0}, // #882
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 1, false, false, false, 1758, 5,  8, 1,  0, 0}, // #883
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 2, false, false, false, 2160, 5, 22, 1,  0, 0}, // #884
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, false, 1740, 5,  8, 1, 29, 1}, // #885
  {DBGFIELD("CVTSI2SSrr")         2, false, false, false, 2160, 5, 22, 1,  0, 0}, // #886
  {DBGFIELD("CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 2, false, false, false, 1740, 5,  8, 1, 29, 1}, // #887
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, false, 1740, 5,  2, 1,  0, 0}, // #888
  {DBGFIELD("VCVTSD2SI64rm_VCVTSD2SI64rm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 2, false, false, false, 1746, 11, 31, 1,  0, 0}, // #889
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int") 2, false, false, false, 1746, 11, 31, 1,  0, 0}, // #890
  {DBGFIELD("VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 2, false, false, false, 1746, 11, 31, 1,  0, 0}, // #891
  {DBGFIELD("VCVTPS2PDYrm")       5, false, false, false, 1757, 7, 22, 1,  0, 0}, // #892
  {DBGFIELD("CVTPD2PSrm")         2, false, false, false, 1739, 7, 22, 1,  0, 0}, // #893
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIrm_MMX_CVTTPD2PIrm") 2, false, false, false, 1739, 7, 22, 1,  0, 0}, // #894
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 2, false, false, false, 1739, 7, 22, 1,  0, 0}, // #895
  {DBGFIELD("MMX_CVTPI2PDrm")     2, false, false, false, 1739, 7, 22, 1,  0, 0}, // #896
  {DBGFIELD("CVTSD2SSrm")         1, false, false, false, 1757, 7,  9, 1,  0, 0}, // #897
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_VCVTSD2SSrm_Int") 1, false, false, false, 1757, 7,  9, 1,  3, 1}, // #898
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 1, false, false, false, 1825, 5,  6, 1,  0, 0}, // #899
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 45, false, false, false, 2199, 2, 89, 1,  0, 0}, // #900
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #901
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, false, 1923, 4, 14, 1,  0, 0}, // #902
  {DBGFIELD("VPCMPGTQYrm")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #903
  {DBGFIELD("VCVTSI642SSrr_VCVTSI642SSrr_Int") 2, false, false, false, 1740, 5,  8, 1, 29, 1}, // #904
  {DBGFIELD("STR16r_STR32r_STR64r") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #905
  {DBGFIELD("XSETBV")             1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #906
  {DBGFIELD("VCVTDQ2PDYrr")       4, false, false, false, 1758, 5,  2, 1,  0, 0}, // #907
  {DBGFIELD("VCVTPD2PSYrr")       4, false, false, false, 2047, 6,  2, 1,  0, 0}, // #908
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 4, false, false, false, 2047, 6,  2, 1,  0, 0}, // #909
  {DBGFIELD("VCVTDQ2PDYrm")       5, false, false, false, 1757, 7, 22, 1,  0, 0}, // #910
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 2, false, false, false, 1990, 5, 86, 2,  0, 0}, // #911
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 17, false, false, false, 2201, 2,  6, 1,  0, 0}, // #912
  {DBGFIELD("RCL8rCL")            26, false, false, false, 2203, 2, 23, 1,  0, 0}, // #913
  {DBGFIELD("RDTSC")              1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #914
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #915
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, false, 1783, 4,  9, 1,  0, 0}, // #916
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 1, false, false, false, 2193, 6,  9, 1,  0, 0}, // #917
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 1, false, false, false, 2193, 6,  9, 1,  0, 0}, // #918
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, false, 1783, 4,  9, 1,  0, 0}, // #919
  {DBGFIELD("XSAVE64")            1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #920
  {DBGFIELD("XSAVE")              1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #921
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #922
  {DBGFIELD("VMCLEARm")           1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #923
  {DBGFIELD("FLDENVm")            1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #924
  {DBGFIELD("FXRSTOR64")          1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #925
  {DBGFIELD("FSTENVm")            1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #926
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #927
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #928
  {DBGFIELD("VGATHERDPSrm_VPGATHERDDrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #929
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #930
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #931
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm_VGATHERQPSYrm_VPGATHERQDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #932
  {DBGFIELD("VGATHERQPSrm_VPGATHERQDrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #933
  {DBGFIELD("VPXORYrr")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #934
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #935
  {DBGFIELD("VPCMPGTQYrr")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #936
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #937
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #938
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 1, false, false, false, 1923, 4,  3, 1,  0, 0}, // #939
  {DBGFIELD("LRET64")             1, false, false, false, 1642, 6, 14, 1,  0, 0}, // #940
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 1, false, false, false, 1739, 7,  9, 1,  0, 0}, // #941
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 2, false, false, false, 1739, 7, 22, 1,  0, 0}, // #942
  {DBGFIELD("POPF64")             1, false, false, false, 1721, 2, 14, 1,  0, 0}, // #943
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #944
  {DBGFIELD("PCMPEQQrr")          1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #945
  {DBGFIELD("PCMPEQQrm")          1, false, false, false, 1825, 5,  6, 1,  3, 1}, // #946
  {DBGFIELD("MOV16rm")            1, false, false, false, 1721, 2, 14, 1,  0, 0}, // #947
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false, false, 1676, 4, 14, 1,  0, 0}, // #948
  {DBGFIELD("POP16rmm")           2, false, false, false, 1987, 3,  3, 1,  0, 0}, // #949
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 2, false, false, false, 1987, 3,  3, 1,  0, 0}, // #950
  {DBGFIELD("PUSHF16")            1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #951
  {DBGFIELD("LAHF")               4, false, false, false, 1736, 2, 13, 1,  0, 0}, // #952
  {DBGFIELD("ADD16mi_ADD16mi8_ADD32mi_ADD32mi8_ADD64mi32_ADD64mi8_ADD8mi_ADD8mi8_SUB16mi_SUB16mi8_SUB32mi_SUB32mi8_SUB64mi32_SUB64mi8_SUB8mi_SUB8mi8") 1, false, false, false, 1671, 5,  3, 1,  0, 0}, // #953
  {DBGFIELD("ADD16mr_ADD32mr_ADD64mr_ADD8mr_SUB16mr_SUB32mr_SUB64mr_SUB8mr") 1, false, false, false, 1671, 5,  3, 1, 24, 1}, // #954
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 2, false, false, false, 1671, 5,  3, 1,  0, 0}, // #955
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 1, false, false, false, 1671, 5,  3, 1,  0, 0}, // #956
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 1, false, false, false, 1632, 4,  1, 1,  0, 0}, // #957
  {DBGFIELD("RET16_LRET16_LRET32") 1, false, false, false, 1642, 6, 14, 1,  0, 0}, // #958
  {DBGFIELD("IRET16_IRET32_IRET64") 1, false, false, false, 1642, 6, 14, 1,  0, 0}, // #959
  {DBGFIELD("AND16mi_AND16mi8_AND32mi_AND32mi8_AND64mi32_AND64mi8_AND8mi_AND8mi8_OR16mi_OR16mi8_OR32mi_OR32mi8_OR32mi8Locked_OR64mi32_OR64mi8_OR8mi_OR8mi8_XOR16mi_XOR16mi8_XOR32mi_XOR32mi8_XOR64mi32_XOR64mi8_XOR8mi_XOR8mi8") 1, false, false, false, 1671, 5,  3, 1,  0, 0}, // #960
  {DBGFIELD("AND16mr_AND32mr_AND64mr_AND8mr_OR16mr_OR32mr_OR64mr_OR8mr_XOR16mr_XOR32mr_XOR64mr_XOR8mr") 1, false, false, false, 1671, 5,  3, 1, 24, 1}, // #961
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 8, false, false, false, 2011, 4,  8, 1,  0, 0}, // #962
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 7, false, false, false, 1650, 2,  5, 1,  0, 0}, // #963
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 8, false, false, false, 2011, 4,  8, 1,  0, 0}, // #964
  {DBGFIELD("MOVSLDUPrm")         1, false, false, false, 1692, 5,  6, 1,  0, 0}, // #965
  {DBGFIELD("MOVSLDUPrr")         1, false, false, false, 1693, 3, 13, 1,  0, 0}, // #966
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 2, false, false, false, 1633, 3,  1, 1,  0, 0}, // #967
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, false, 1667, 4,  1, 1,  0, 0}, // #968
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 1, false, false, false, 1629, 3, 13, 1,  0, 0}, // #969
  {DBGFIELD("VPBLENDWYrri")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #970
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 1, false, false, false, 1906, 5,  6, 1,  3, 1}, // #971
  {DBGFIELD("VPBLENDWYrmi")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #972
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #973
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64_MASKMOVDQUX32") 1, false, false, false, 1652, 5,  1, 1,  0, 0}, // #974
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64_VMASKMOVDQUX32") 1, false, false, false, 1652, 5,  1, 1,  0, 0}, // #975
  {DBGFIELD("VPMASKMOVDYrm")      2, false, false, false, 2121, 5,  3, 1,  0, 0}, // #976
  {DBGFIELD("VPMASKMOVDrm")       1, false, false, false, 1825, 5,  3, 1,  0, 0}, // #977
  {DBGFIELD("VPMASKMOVDYmr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #978
  {DBGFIELD("VPMASKMOVDmr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #979
  {DBGFIELD("VPMASKMOVQYmr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #980
  {DBGFIELD("VPMASKMOVQmr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #981
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 1, false, false, false, 1825, 5,  6, 1,  0, 0}, // #982
  {DBGFIELD("VPGATHERDDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #983
  {DBGFIELD("VPGATHERDDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #984
  {DBGFIELD("VPGATHERDQYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #985
  {DBGFIELD("VPGATHERDQrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #986
  {DBGFIELD("VPGATHERQDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #987
  {DBGFIELD("VPGATHERQDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #988
  {DBGFIELD("VPGATHERQQYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #989
  {DBGFIELD("VPGATHERQQrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #990
  {DBGFIELD("PSLLDQri_PSRLDQri_VPSLLDQri_VPSRLDQri") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #991
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 2, false, false, false, 1912, 3, 13, 1,  0, 0}, // #992
  {DBGFIELD("VPERM2F128rr")       8, false, false, false, 2205, 3,  8, 1,  0, 0}, // #993
  {DBGFIELD("VPERM2F128rm")       10, false, false, false, 2208, 3,  2, 1,  0, 0}, // #994
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, false, 1693, 3, 13, 1,  0, 0}, // #995
  {DBGFIELD("VEXTRACTF128mr")     2, false, false, false, 2109, 3,  6, 1,  0, 0}, // #996
  {DBGFIELD("VINSERTF128rr")      2, false, false, false, 1658, 3, 13, 1,  0, 0}, // #997
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 2, false, false, false, 1739, 7, 22, 1,  0, 0}, // #998
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 4, false, false, false, 2046, 8, 22, 1,  0, 0}, // #999
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, false, 1747, 9, 22, 1,  0, 0}, // #1000
  {DBGFIELD("VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 2, false, false, false, 1746, 11, 31, 1,  0, 0}, // #1001
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, false, 1889, 3,  5, 1,  0, 0}, // #1002
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, false, 1889, 3,  5, 1,  0, 0}, // #1003
  {DBGFIELD("SHA256MSG2rm")       1, false, false, false, 1686, 6,  9, 1,  3, 1}, // #1004
  {DBGFIELD("SHA256MSG2rr")       1, false, false, false, 1687, 4,  8, 1,  0, 0}, // #1005
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, false, 1687, 4,  8, 1,  0, 0}, // #1006
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 1, false, false, false, 1686, 6,  9, 1,  3, 1}, // #1007
  {DBGFIELD("SHA1MSG2rr")         1, false, false, false, 1687, 4,  8, 1,  0, 0}, // #1008
  {DBGFIELD("SHA1MSG2rm")         1, false, false, false, 1686, 6,  9, 1,  3, 1}, // #1009
  {DBGFIELD("SHA1NEXTErr")        1, false, false, false, 1687, 4,  8, 1,  0, 0}, // #1010
  {DBGFIELD("SHA1NEXTErm")        1, false, false, false, 1686, 6,  9, 1,  3, 1}, // #1011
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, false, 1687, 4,  8, 1,  0, 0}, // #1012
  {DBGFIELD("SHA1RNDS4rmi")       1, false, false, false, 1686, 6,  9, 1,  3, 1}, // #1013
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, false, 1687, 4,  8, 1,  0, 0}, // #1014
  {DBGFIELD("SHA256RNDS2rm")      1, false, false, false, 1686, 6,  9, 1,  3, 1}, // #1015
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 2, false, false, false, 1633, 3,  1, 1,  0, 0}, // #1016
  {DBGFIELD("BT16mi8_BT32mi8_BT64mi8") 1, false, false, false, 1676, 4, 14, 1,  0, 0}, // #1017
  {DBGFIELD("BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 2, false, false, false, 1627, 2, 13, 1,  0, 0}, // #1018
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, false, 1740, 5,  8, 1,  0, 0}, // #1019
  {DBGFIELD("MOV8rm_MOV8rm_NOREX") 1, false, false, false, 1721, 2, 14, 1,  0, 0}, // #1020
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVZX16rm16") 1, false, false, false, 1676, 4, 14, 1,  0, 0}, // #1021
  {DBGFIELD("MOVBE16rm")          1, false, false, false, 1676, 4, 14, 1,  0, 0}, // #1022
  {DBGFIELD("ADD8i8_ADD16i16_ADD32i32_ADD64i32_AND8i8_AND16i16_AND32i32_AND64i32_OR8i8_OR16i16_OR32i32_OR64i32_SUB8i8_SUB16i16_SUB32i32_SUB64i32_XOR8i8_XOR16i16_XOR32i32_XOR64i32") 1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #1023
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32_MOVZX16rr16") 1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #1024
  {DBGFIELD("MOV32ri_MOV32ri_alt_MOV64ri32") 1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #1025
  {DBGFIELD("ADC8mr_SBB8mr")      2, false, false, false, 1671, 5,  3, 1, 24, 2}, // #1026
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1027
  {DBGFIELD("LEA16r")             2, false, false, false, 2211, 2,  1, 1,  0, 0}, // #1028
  {DBGFIELD("LCMPXCHG8")          2, false, false, false, 1636, 6,  5, 1,  0, 0}, // #1029
  {DBGFIELD("LCMPXCHG16B")        2, false, false, false, 1636, 6,  5, 1,  0, 0}, // #1030
  {DBGFIELD("XCHG8rr_XCHG16rr_XCHG16ar") 2, false, false, false, 1633, 3,  1, 1,  0, 0}, // #1031
  {DBGFIELD("XCHG8rm_XCHG16rm")   2, false, false, false, 1671, 5, 86, 2,  0, 0}, // #1032
  {DBGFIELD("POPCNT16rr")         1, false, false, false, 1736, 2,  8, 1,  0, 0}, // #1033
  {DBGFIELD("LZCNT16rr")          2, false, false, false, 1896, 3, 13, 1,  0, 0}, // #1034
  {DBGFIELD("TZCNT16rr")          2, false, false, false, 1896, 3, 13, 1,  0, 0}, // #1035
  {DBGFIELD("RCL8m1_RCL16m1_RCL32m1_RCL64m1_RCR8m1_RCR16m1_RCR32m1_RCR64m1") 2, false, false, false, 1671, 5, 86, 2,  0, 0}, // #1036
  {DBGFIELD("RCR8ri_RCR16ri_RCR32ri_RCR64ri") 15, false, false, false, 2201, 2,  6, 1,  0, 0}, // #1037
  {DBGFIELD("RCR8mi_RCR16mi_RCR32mi_RCR64mi") 2, false, false, false, 1671, 5, 86, 2,  0, 0}, // #1038
  {DBGFIELD("RCR16rCL_RCR32rCL_RCR64rCL") 20, false, false, false, 2213, 2,  9, 1,  0, 0}, // #1039
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 2, false, false, false, 1652, 5, 13, 1,  0, 0}, // #1040
  {DBGFIELD("VEXTRACTI128rr")     1, false, false, false, 1629, 3,  1, 1,  0, 0}, // #1041
  {DBGFIELD("VEXTRACTI128mr")     1, false, false, false, 1652, 5,  1, 1,  0, 0}, // #1042
  {DBGFIELD("MMX_MOVQ2FR64rr")    1, false, false, false, 1815, 3,  1, 1,  0, 0}, // #1043
  {DBGFIELD("MMX_MOVD64rr_MMX_MOVD64to64rr") 2, false, false, false, 1693, 3, 18, 1,  0, 0}, // #1044
  {DBGFIELD("EXTRQ")              1, false, false, false, 1889, 3,  5, 1,  0, 0}, // #1045
  {DBGFIELD("INSERTQ")            1, false, false, false, 1815, 3,  5, 1,  0, 0}, // #1046
  {DBGFIELD("PABSBrr_PABSDrr_PABSWrr_PADDSBrr_PADDSWrr_PADDUSBrr_PADDUSWrr_PAVGBrr_PAVGWrr_PSIGNBrr_PSIGNDrr_PSIGNWrr_VPABSBrr_VPABSDrr_VPABSWrr_VPADDSBrr_VPADDSWrr_VPADDUSBrr_VPADDUSWrr_VPAVGBrr_VPAVGWrr_VPCMPEQQrr_VPSIGNBrr_VPSIGNDrr_VPSIGNWrr_PSUBSBrr_PSUBSWrr_PSUBUSBrr_PSUBUSWrr_VPSUBSBrr_VPSUBSWrr_VPSUBUSBrr_VPSUBUSWrr") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #1047
  {DBGFIELD("MMX_PADDSBrr_MMX_PADDSWrr_MMX_PADDUSBrr_MMX_PADDUSWrr_MMX_PAVGBrr_MMX_PAVGWrr_MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false, 1629, 3, 13, 1,  0, 0}, // #1048
  {DBGFIELD("VPABSBYrr_VPABSDYrr_VPABSWYrr_VPADDSBYrr_VPADDSWYrr_VPADDUSBYrr_VPADDUSWYrr_VPSUBSBYrr_VPSUBSWYrr_VPSUBUSBYrr_VPSUBUSWYrr_VPAVGBYrr_VPAVGWYrr_VPCMPEQQYrr_VPSIGNBYrr_VPSIGNDYrr_VPSIGNWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1049
  {DBGFIELD("SHA1MSG1rr")         1, false, false, false, 1687, 4,  8, 1,  0, 0}, // #1050
  {DBGFIELD("SHA1MSG1rm")         1, false, false, false, 1686, 6,  9, 1,  3, 1}, // #1051
  {DBGFIELD("VPERM2I128rr")       1, false, false, false, 1629, 3,  1, 1,  0, 0}, // #1052
  {DBGFIELD("VPERMPSYrr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1053
  {DBGFIELD("VPERMPSYrm")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1054
  {DBGFIELD("VPERMPDYri")         2, false, false, false, 1658, 3, 13, 1,  0, 0}, // #1055
  {DBGFIELD("VPERMQYri")          1, false, false, false, 1629, 3,  1, 1,  0, 0}, // #1056
  {DBGFIELD("VPERMPDYmi")         2, false, false, false, 1657, 5,  6, 1,  3, 1}, // #1057
  {DBGFIELD("VPERMDYrr")          1, false, false, false, 1629, 3,  1, 1,  0, 0}, // #1058
  {DBGFIELD("VPERMQYmi")          1, false, false, false, 1906, 5,  3, 1,  3, 1}, // #1059
  {DBGFIELD("VPERMDYrm")          1, false, false, false, 1906, 5,  3, 1,  3, 1}, // #1060
  {DBGFIELD("MOV32rr_MOV32rr_REV_MOV64rr_MOV64rr_REV") 1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #1061
  {DBGFIELD("MOVSX32rr32")        1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #1062
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV_SUB32rr_REV_SUB64rr_REV") 1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #1063
  {DBGFIELD("CMP8rr_CMP8rr_REV_CMP16rr_CMP16rr_REV_CMP32rr_CMP32rr_REV_CMP64rr_CMP64rr_REV") 1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #1064
  {DBGFIELD("VXORPSrr_VXORPDrr")  8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1065
  {DBGFIELD("VANDNPSrr_VANDNPDrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1066
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 2, false, false, false, 2032, 3, 13, 1,  0, 0}, // #1067
  {DBGFIELD("VPXORrr")            8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1068
  {DBGFIELD("VPANDNrr")           8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1069
  {DBGFIELD("VPANDNYrr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1070
  {DBGFIELD("VPSUBBrr_VPSUBWrr_VPSUBDrr_VPSUBQrr_VPCMPGTBrr_VPCMPGTWrr_VPCMPGTDrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1071
  {DBGFIELD("VPCMPGTQrr")         1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #1072
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 45, false, false, false, 2199, 2, 89, 1,  0, 0}, // #1073
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 4, false, false, false, 2215, 2,  3, 1,  0, 0}, // #1074
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 2, false, false, false, 1627, 2, 13, 1,  0, 0}, // #1075
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 2, false, false, false, 2217, 4,  3, 1,  0, 0}, // #1076
  {DBGFIELD("ADC64ri32_SBB64ri32") 1, false, false, false, 2211, 2,  1, 1,  0, 0}, // #1077
  {DBGFIELD("CRC32r32r16")        5, false, false, false, 2221, 2, 14, 1,  0, 0}, // #1078
  {DBGFIELD("CRC32r32r32")        7, false, false, false, 2223, 2,  3, 1,  0, 0}, // #1079
  {DBGFIELD("CRC32r64r64")        11, false, false, false, 2225, 2,  7, 1,  0, 0}, // #1080
  {DBGFIELD("SAHF")               2, false, false, false, 1627, 2, 13, 1,  0, 0}, // #1081
  {DBGFIELD("BEXTRI32ri_BEXTRI64ri") 2, false, false, false, 1736, 2, 13, 1,  0, 0}, // #1082
  {DBGFIELD("BEXTRI32mi_BEXTRI64mi") 2, false, false, false, 2227, 2, 13, 1,  0, 0}, // #1083
  {DBGFIELD("RCR8ri")             23, false, false, false, 2229, 2, 23, 1,  0, 0}, // #1084
  {DBGFIELD("RCL16rCL")           22, false, false, false, 2231, 2,  7, 1,  0, 0}, // #1085
  {DBGFIELD("RCR16ri")            19, false, false, false, 2233, 2,  7, 1,  0, 0}, // #1086
  {DBGFIELD("RCR32rCL_RCR64rCL")  16, false, false, false, 2235, 2,  6, 1,  0, 0}, // #1087
  {DBGFIELD("RCL16ri")            21, false, false, false, 2237, 2, 18, 1,  0, 0}, // #1088
  {DBGFIELD("RCL32ri_RCL64ri")    16, false, false, false, 2239, 2,  2, 1,  0, 0}, // #1089
  {DBGFIELD("SHLD32rri8")         6, false, false, false, 1650, 2,  5, 1,  0, 0}, // #1090
  {DBGFIELD("SHRD16rri8")         6, false, false, false, 1650, 2,  5, 1,  0, 0}, // #1091
  {DBGFIELD("SHLD16rrCL")         7, false, false, false, 1650, 2,  5, 1,  0, 0}, // #1092
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 8, false, false, false, 1900, 6,  1, 1,  0, 0}, // #1093
  {DBGFIELD("TST_F")              1, false, false, false, 1923, 4,  1, 1,  0, 0}, // #1094
  {DBGFIELD("VDPPSrri")           17, false, false, false, 1795, 4, 46, 1,  0, 0}, // #1095
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr") 2, false, false, false, 1803, 4,  7, 1,  0, 0}, // #1096
  {DBGFIELD("VFRCZSDrr_VFRCZSSrr") 2, false, false, false, 2241, 4,  7, 1,  0, 0}, // #1097
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 3, false, false, false, 1803, 4, 21, 1,  0, 0}, // #1098
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 4, false, false, false, 2245, 4,  7, 1,  0, 0}, // #1099
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 8, false, false, false, 2249, 4, 21, 1,  0, 0}, // #1100
  {DBGFIELD("MMX_CVTTPD2PIrr")    2, false, false, false, 1740, 5,  3, 1,  0, 0}, // #1101
  {DBGFIELD("VMOVDQUYmr")         8, false, false, false, 1900, 6,  1, 1,  0, 0}, // #1102
  {DBGFIELD("MOVDQArr")           1, false, false, false, 1629, 3,  1, 1,  0, 0}, // #1103
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 1, false, false, false, 2253, 5,  8, 1,  0, 0}, // #1104
  {DBGFIELD("VMPSADBWrri")        10, false, false, false, 1917, 4,  2, 1,  0, 0}, // #1105
  {DBGFIELD("VPPERMrrr_VPPERMrrr_REV") 1, false, false, false, 1889, 3, 13, 1,  0, 0}, // #1106
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, false, 1912, 3, 14, 1,  0, 0}, // #1107
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, false, 1911, 5,  7, 1,  0, 0}, // #1108
  {DBGFIELD("VPCLMULQDQrr")       6, false, false, false, 1929, 4, 23, 1,  0, 0}, // #1109
  {DBGFIELD("ANDNPSrr_ANDNPDrr")  8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1110
  {DBGFIELD("MMX_PXORrr_MMX_PANDNrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1111
  {DBGFIELD("PANDNrr")            8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1112
  {DBGFIELD("MMX_PSUBBrr_MMX_PSUBDrr_MMX_PSUBWrr_MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1113
  {DBGFIELD("LCMPXCHG16_LCMPXCHG32_LCMPXCHG64") 2, false, false, false, 1636, 6,  5, 1,  0, 0}, // #1114
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 5, false, false, false, 1723, 3,  5, 1,  0, 0}, // #1115
  {DBGFIELD("LCMPXCHG8B")         2, false, false, false, 1636, 6,  5, 1,  0, 0}, // #1116
  {DBGFIELD("XCHG8rr")            2, false, false, false, 1633, 3,  1, 1,  0, 0}, // #1117
  {DBGFIELD("MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false, 1629, 3, 13, 1,  0, 0}, // #1118
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #1119
  {DBGFIELD("MMX_PCMPEQBrr_MMX_PCMPEQDrr_MMX_PCMPEQWrr_MMX_PMAXSWrr_MMX_PMINSWrr_MMX_PMAXUBrr_MMX_PMINUBrr") 1, false, false, false, 1629, 3, 13, 1,  0, 0}, // #1120
  {DBGFIELD("MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1121
  {DBGFIELD("CLAC_STAC")          1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #1122
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #1123
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1124
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, false, 1681, 4, 14, 1,  0, 0}, // #1125
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 3, false, false, false, 1912, 3, 14, 1,  0, 0}, // #1126
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, false, 1912, 3, 14, 1,  0, 0}, // #1127
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1128
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 2, false, false, false, 1758, 5,  8, 1,  0, 0}, // #1129
  {DBGFIELD("MMX_PADDSBrm_MMX_PADDSWrm_MMX_PADDUSBrm_MMX_PADDUSWrm_MMX_PAVGBrm_MMX_PAVGWrm_MMX_PCMPEQBrm_MMX_PCMPEQDrm_MMX_PCMPEQWrm_MMX_PCMPGTBrm_MMX_PCMPGTDrm_MMX_PCMPGTWrm_MMX_PMAXSWrm_MMX_PMAXUBrm_MMX_PMINSWrm_MMX_PMINUBrm_MMX_PSUBSBrm_MMX_PSUBSWrm_MMX_PSUBUSBrm_MMX_PSUBUSWrm") 1, false, false, false, 1906, 5,  6, 1,  3, 1}, // #1130
  {DBGFIELD("CVTSS2SI64rr")       2, false, false, false, 1747, 9, 22, 1,  0, 0}, // #1131
  {DBGFIELD("CVTSS2SI64rr_Int")   2, false, false, false, 1747, 9, 22, 1,  0, 0}, // #1132
  {DBGFIELD("CVTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr") 2, false, false, false, 1747, 9, 22, 1,  0, 0}, // #1133
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 2, false, false, false, 1747, 9, 22, 1,  0, 0}, // #1134
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 1, false, false, false, 1825, 5,  6, 1,  3, 1}, // #1135
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1136
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 4, false, false, false, 1911, 5,  7, 1,  3, 1}, // #1137
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, false, 1911, 5,  7, 1,  0, 0}, // #1138
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1139
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 1, false, false, false, 1648, 2,  4, 1,  0, 0}, // #1140
  {DBGFIELD("PCMPGTBrr_PCMPGTDrr_PCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1141
  {DBGFIELD("VPCMPGTBrr_VPCMPGTDrr_VPCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1142
  {DBGFIELD("VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1143
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #1144
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #1145
  {DBGFIELD("KSET0D_KSET0Q_KSET0W_KSET1D_KSET1Q_KSET1W") 1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1146
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #1147
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 1, false, false, false, 1658, 3, 13, 1,  0, 0}, // #1148
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 2, false, false, false, 2037, 3, 13, 1,  0, 0}, // #1149
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #1150
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1151
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1152
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #1153
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1154
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #1155
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 4, false, false, false, 2113, 5,  1, 1,  0, 0}, // #1156
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #1157
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #1158
  {DBGFIELD("VPSADBWZrr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1159
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #1160
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 2, false, false, false, 1912, 3, 13, 1,  0, 0}, // #1161
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1162
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1163
  {DBGFIELD("VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #1164
  {DBGFIELD("VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1165
  {DBGFIELD("VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1166
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #1167
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #1168
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, false, 1681, 4, 13, 1,  0, 0}, // #1169
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 2, false, false, false, 2026, 4, 13, 1,  0, 0}, // #1170
  {DBGFIELD("VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1171
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, false, 1681, 4, 13, 1,  0, 0}, // #1172
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #1173
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1174
  {DBGFIELD("VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1175
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1176
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1177
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 1, false, false, false, 1740, 5,  8, 1,  0, 0}, // #1178
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 2, false, false, false, 1758, 5,  8, 1,  0, 0}, // #1179
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 2, false, false, false, 1740, 5,  2, 1,  0, 0}, // #1180
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 4, false, false, false, 2047, 6,  2, 1,  0, 0}, // #1181
  {DBGFIELD("VCVTPS2DQYrr")       2, false, false, false, 1758, 5,  8, 1,  0, 0}, // #1182
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, false, 1740, 5,  8, 1,  0, 0}, // #1183
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 2, false, false, false, 1758, 5,  8, 1,  0, 0}, // #1184
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 2, false, false, false, 1740, 5,  2, 1,  0, 0}, // #1185
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 4, false, false, false, 1758, 5,  2, 1,  0, 0}, // #1186
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1187
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1188
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1189
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1190
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 1, false, false, false, 1629, 3,  1, 1,  0, 0}, // #1191
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 1, false, false, false, 1629, 3,  1, 1,  0, 0}, // #1192
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 1, false, false, false, 1906, 5,  3, 1,  0, 0}, // #1193
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 2, false, false, false, 1740, 5,  2, 1,  0, 0}, // #1194
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 2, false, false, false, 1740, 5,  2, 1,  0, 0}, // #1195
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 2, false, false, false, 1740, 5,  2, 1,  0, 0}, // #1196
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 2, false, false, false, 1740, 5,  2, 1,  0, 0}, // #1197
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false, false, 1740, 5,  8, 1,  0, 0}, // #1198
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false, false, 1740, 5,  8, 1,  0, 0}, // #1199
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 1, false, false, false, 1758, 5,  8, 1,  0, 0}, // #1200
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 2, false, false, false, 1740, 5,  8, 1, 29, 1}, // #1201
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 2, false, false, false, 1740, 5,  8, 1, 29, 1}, // #1202
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 1, false, false, false, 1758, 5,  8, 1,  0, 0}, // #1203
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #1204
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 3, false, false, false, 2062, 7,  8, 1,  0, 0}, // #1205
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 4, false, false, false, 2054, 8,  8, 1,  0, 0}, // #1206
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1207
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 1, false, false, false, 1906, 5,  3, 1,  0, 0}, // #1208
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 1, false, false, false, 1629, 3,  1, 1,  0, 0}, // #1209
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false, false, 1888, 5, 14, 1,  0, 0}, // #1210
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false, false, 1888, 5, 14, 1,  0, 0}, // #1211
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 2, false, false, false, 1740, 5,  8, 1, 29, 1}, // #1212
  {DBGFIELD("VMOVSDZrm_VMOVSDZrm_alt_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrm_alt_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, false, 1657, 5, 14, 1,  0, 0}, // #1213
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 4, false, false, false, 1758, 5,  2, 1,  0, 0}, // #1214
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 4, false, false, false, 2047, 6,  2, 1,  0, 0}, // #1215
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 4, false, false, false, 2047, 6,  2, 1,  0, 0}, // #1216
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 4, false, false, false, 1758, 5,  2, 1,  0, 0}, // #1217
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 2, false, false, false, 1758, 5,  8, 1,  0, 0}, // #1218
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 2, false, false, false, 1758, 5,  8, 1,  0, 0}, // #1219
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1220
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1221
  {DBGFIELD("VCVTPD2PSZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1222
  {DBGFIELD("VCVTPS2PDZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1223
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1224
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1225
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false, false, 1888, 5, 14, 1,  0, 0}, // #1226
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 1, false, false, false, 1657, 5,  6, 1,  3, 1}, // #1227
  {DBGFIELD("VBROADCASTI32X2Z128rm_VBROADCASTI32X2Z128rmk_VBROADCASTI32X2Z128rmkz_VPBROADCASTDZ128rm_VPBROADCASTDZ128rmk_VPBROADCASTDZ128rmkz_VPBROADCASTQZ128rm_VPBROADCASTQZ128rmk_VPBROADCASTQZ128rmkz") 1, false, false, false, 1825, 5,  6, 1,  0, 0}, // #1228
  {DBGFIELD("VBROADCASTSSZ128rm_VBROADCASTSSZ128rmk_VBROADCASTSSZ128rmkz") 2, false, false, false, 1657, 5,  6, 1,  0, 0}, // #1229
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, false, 1657, 5, 14, 1,  0, 0}, // #1230
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 1, false, false, false, 1692, 5,  6, 1,  0, 0}, // #1231
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, false, 1888, 5, 14, 1,  0, 0}, // #1232
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 1, false, false, false, 1825, 5,  6, 1,  3, 1}, // #1233
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 1, false, false, false, 1825, 5,  6, 1,  3, 1}, // #1234
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 1, false, false, false, 1629, 3,  1, 1,  0, 0}, // #1235
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 2, false, false, false, 1747, 9, 22, 1,  0, 0}, // #1236
  {DBGFIELD("VCVTSS2SI64rr")      2, false, false, false, 1747, 9, 22, 1,  0, 0}, // #1237
  {DBGFIELD("VCVTSS2SI64rr_Int")  2, false, false, false, 1747, 9, 22, 1,  0, 0}, // #1238
  {DBGFIELD("VCVTTSS2SI64rr")     2, false, false, false, 1747, 9, 22, 1,  0, 0}, // #1239
  {DBGFIELD("VCVTTSS2SI64rr_Int") 2, false, false, false, 1747, 9, 22, 1,  0, 0}, // #1240
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, false, 1721, 2, 14, 1,  0, 0}, // #1241
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 1, false, false, false, 1906, 5,  3, 1,  0, 0}, // #1242
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #1243
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #1244
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #1245
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #1246
  {DBGFIELD("VPBROADCASTBZ256rm_VPBROADCASTBZ256rmk_VPBROADCASTBZ256rmkz_VPBROADCASTBZrm_VPBROADCASTBZrmk_VPBROADCASTBZrmkz_VPBROADCASTWZ256rm_VPBROADCASTWZ256rmk_VPBROADCASTWZ256rmkz_VPBROADCASTWZrm_VPBROADCASTWZrmk_VPBROADCASTWZrmkz") 1, false, false, false, 1906, 5,  3, 1,  0, 0}, // #1247
  {DBGFIELD("VMOVNTDQAZ256rm")    2, false, false, false, 2093, 5, 14, 1,  0, 0}, // #1248
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 2, false, false, false, 2036, 5,  6, 1,  3, 1}, // #1249
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1250
  {DBGFIELD("VBROADCASTF32X2Z256rm_VBROADCASTF32X2Z256rmk_VBROADCASTF32X2Z256rmkz_VBROADCASTF32X2Zrm_VBROADCASTF32X2Zrmk_VBROADCASTF32X2Zrmkz_VBROADCASTI32X2Z256rm_VBROADCASTI32X2Z256rmk_VBROADCASTI32X2Z256rmkz_VBROADCASTI32X2Zrm_VBROADCASTI32X2Zrmk_VBROADCASTI32X2Zrmkz_VPBROADCASTDZ256rm_VPBROADCASTDZ256rmk_VPBROADCASTDZ256rmkz_VPBROADCASTDZrm_VPBROADCASTDZrmk_VPBROADCASTDZrmkz_VPBROADCASTQZ256rm_VPBROADCASTQZ256rmk_VPBROADCASTQZ256rmkz_VPBROADCASTQZrm_VPBROADCASTQZrmk_VPBROADCASTQZrmkz") 1, false, false, false, 1906, 5,  3, 1,  0, 0}, // #1251
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 2, false, false, false, 1911, 5,  6, 1,  0, 0}, // #1252
  {DBGFIELD("VBROADCASTSDZ256rm_VBROADCASTSDZ256rmk_VBROADCASTSDZ256rmkz_VBROADCASTSDZrm_VBROADCASTSDZrmk_VBROADCASTSDZrmkz_VBROADCASTSSZ256rm_VBROADCASTSSZ256rmk_VBROADCASTSSZ256rmkz_VBROADCASTSSZrm_VBROADCASTSSZrmk_VBROADCASTSSZrmkz") 2, false, false, false, 1657, 5,  6, 1,  0, 0}, // #1253
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, false, 1657, 5,  6, 1,  3, 1}, // #1254
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 1, false, false, false, 1906, 5,  3, 1,  3, 1}, // #1255
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 2, false, false, false, 1657, 5, 14, 1,  0, 0}, // #1256
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, false, 2036, 5,  6, 1,  0, 0}, // #1257
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1258
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 2, false, false, false, 2093, 5, 14, 1,  0, 0}, // #1259
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1260
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1261
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1262
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1263
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #1264
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #1265
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #1266
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false, false, 1800, 2,  1, 1,  0, 0}, // #1267
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 1, false, false, false, 1825, 5,  6, 1,  3, 1}, // #1268
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 1, false, false, false, 1680, 6,  6, 1,  3, 1}, // #1269
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 1, false, false, false, 1906, 5,  3, 1,  3, 1}, // #1270
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1271
  {DBGFIELD("VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 1, false, false, false, 1825, 5,  6, 1,  3, 1}, // #1272
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmik_VFPCLASSPDZ128rm_VFPCLASSPDZ128rmb_VFPCLASSPDZ128rmbk_VFPCLASSPDZ128rmk_VFPCLASSPSZ128rm_VFPCLASSPSZ128rmb_VFPCLASSPSZ128rmbk_VFPCLASSPSZ128rmk") 1, false, false, false, 1680, 6,  6, 1,  3, 1}, // #1273
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk") 1, false, false, false, 1680, 6,  6, 1,  3, 1}, // #1274
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmik_VPCMPDZ128rmi_VPCMPDZ128rmib_VPCMPDZ128rmibk_VPCMPDZ128rmik_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmib_VPCMPQZ128rmibk_VPCMPQZ128rmik_VPCMPUBZ128rmi_VPCMPUBZ128rmik_VPCMPUDZ128rmi_VPCMPUDZ128rmib_VPCMPUDZ128rmibk_VPCMPUDZ128rmik_VPCMPUQZ128rmi_VPCMPUQZ128rmib_VPCMPUQZ128rmibk_VPCMPUQZ128rmik_VPCMPUWZ128rmi_VPCMPUWZ128rmik_VPCMPWZ128rmi_VPCMPWZ128rmik") 1, false, false, false, 1825, 5,  6, 1,  3, 1}, // #1275
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 1, false, false, false, 1825, 5,  6, 1,  3, 1}, // #1276
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 2, false, false, false, 1911, 5,  6, 1,  3, 1}, // #1277
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1278
  {DBGFIELD("VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1279
  {DBGFIELD("VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1280
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmik_VFPCLASSPDZ256rm_VFPCLASSPDZ256rmb_VFPCLASSPDZ256rmbk_VFPCLASSPDZ256rmk_VFPCLASSPSZ256rm_VFPCLASSPSZ256rmb_VFPCLASSPSZ256rmbk_VFPCLASSPSZ256rmk") 2, false, false, false, 2025, 6,  6, 1,  3, 1}, // #1281
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmik_VFPCLASSPDZrm_VFPCLASSPDZrmb_VFPCLASSPDZrmbk_VFPCLASSPDZrmk_VFPCLASSPSZrm_VFPCLASSPSZrmb_VFPCLASSPSZrmbk_VFPCLASSPSZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1282
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmik_VPCMPDZ256rmi_VPCMPDZ256rmib_VPCMPDZ256rmibk_VPCMPDZ256rmik_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmib_VPCMPQZ256rmibk_VPCMPQZ256rmik_VPCMPUBZ256rmi_VPCMPUBZ256rmik_VPCMPUDZ256rmi_VPCMPUDZ256rmib_VPCMPUDZ256rmibk_VPCMPUDZ256rmik_VPCMPUQZ256rmi_VPCMPUQZ256rmib_VPCMPUQZ256rmibk_VPCMPUQZ256rmik_VPCMPUWZ256rmi_VPCMPUWZ256rmik_VPCMPWZ256rmi_VPCMPWZ256rmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1283
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmik_VPCMPDZrmi_VPCMPDZrmib_VPCMPDZrmibk_VPCMPDZrmik_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmib_VPCMPQZrmibk_VPCMPQZrmik_VPCMPUBZrmi_VPCMPUBZrmik_VPCMPUDZrmi_VPCMPUDZrmib_VPCMPUDZrmibk_VPCMPUDZrmik_VPCMPUQZrmi_VPCMPUQZrmib_VPCMPUQZrmibk_VPCMPUQZrmik_VPCMPUWZrmi_VPCMPUWZrmik_VPCMPWZrmi_VPCMPWZrmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1284
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1285
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1286
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 2, false, false, false, 1739, 7, 22, 1,  0, 0}, // #1287
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 1, false, false, false, 1739, 7,  9, 1,  0, 0}, // #1288
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 2, false, false, false, 1739, 7, 22, 1,  0, 0}, // #1289
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 3, false, false, false, 1757, 7, 22, 1,  0, 0}, // #1290
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 1, false, false, false, 1739, 7,  9, 1,  0, 0}, // #1291
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 2, false, false, false, 1739, 7, 22, 1,  0, 0}, // #1292
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 1, false, false, false, 1757, 7,  9, 1,  3, 1}, // #1293
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 1, false, false, false, 1906, 5,  3, 1,  3, 1}, // #1294
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 5, false, false, false, 1757, 7, 22, 1,  0, 0}, // #1295
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1296
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, false, 1757, 7,  9, 1,  0, 0}, // #1297
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1298
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 7, false, false, false, 1757, 7, 22, 1,  0, 0}, // #1299
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1300
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 5, false, false, false, 1757, 7, 22, 1,  0, 0}, // #1301
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1302
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 4, false, false, false, 2046, 8, 22, 1,  0, 0}, // #1303
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1304
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, false, 1757, 7,  9, 1,  0, 0}, // #1305
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1306
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 1, false, false, false, 1906, 5,  3, 1,  3, 1}, // #1307
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 1, false, false, false, 1757, 7,  9, 1,  3, 1}, // #1308
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 1, false, false, false, 1825, 5,  6, 1,  0, 0}, // #1309
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, false, 1687, 4,  8, 1,  0, 0}, // #1310
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1311
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1312
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 1, false, false, false, 1906, 5,  3, 1,  3, 1}, // #1313
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 2, false, false, false, 1746, 11, 31, 1,  3, 1}, // #1314
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 2, false, false, false, 1746, 11, 31, 1,  3, 1}, // #1315
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1316
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 1, false, false, false, 1906, 5,  3, 1,  3, 1}, // #1317
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 1, false, false, false, 1906, 5,  3, 1,  3, 1}, // #1318
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1319
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1320
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1321
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 1, false, false, false, 1906, 5,  3, 1,  3, 1}, // #1322
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 1, false, false, false, 1825, 5,  6, 1,  0, 0}, // #1323
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 1, false, false, false, 1686, 6,  9, 1,  3, 1}, // #1324
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1325
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1326
  {DBGFIELD("VGATHERQPSZ128rm_VPGATHERQDZ128rm_VGATHERDPDZ128rm_VPGATHERDQZ128rm_VGATHERQPDZ128rm_VPGATHERQQZ128rm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1327
  {DBGFIELD("VGATHERQPSZ256rm_VPGATHERQDZ256rm_VGATHERQPDZ256rm_VPGATHERQQZ256rm_VGATHERDPSZ128rm_VPGATHERDDZ128rm_VGATHERDPDZ256rm_VPGATHERDQZ256rm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1328
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm_VGATHERDPDZrm_VPGATHERDQZrm_VGATHERQPDZrm_VPGATHERQQZrm_VGATHERQPSZrm_VPGATHERQDZrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1329
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1330
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #1331
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1332
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1333
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1334
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1335
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1336
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1337
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1338
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1339
  {DBGFIELD("VXORPSZ128rr_VXORPDZ128rr") 1, false, false, false, 1693, 3, 13, 1,  0, 0}, // #1340
  {DBGFIELD("VXORPSZ256rr_VXORPDZ256rr") 2, false, false, false, 2032, 3, 13, 1,  0, 0}, // #1341
  {DBGFIELD("VXORPSZrr_VXORPDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1342
  {DBGFIELD("VPXORDZ128rr_VPXORQZ128rr") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #1343
  {DBGFIELD("VPXORDZ256rr_VPXORQZ256rr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1344
  {DBGFIELD("VPXORDZrr_VPXORQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1345
  {DBGFIELD("VPSUBBZ128rr_VPSUBDZ128rr_VPSUBQZ128rr_VPSUBWZ128rr") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #1346
  {DBGFIELD("VPSUBBZ256rr_VPSUBDZ256rr_VPSUBQZ256rr_VPSUBWZ256rr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1347
  {DBGFIELD("VPSUBBZrr_VPSUBDZrr_VPSUBQZrr_VPSUBWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1348
  {DBGFIELD("VPBROADCASTDrr_VPBROADCASTQrr_PALIGNRrri_VPALIGNRZ128rri_VPALIGNRZ128rrik_VPALIGNRZ128rrikz_VPALIGNRrri_PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWZ128rr_VPACKSSDWZ128rrk_VPACKSSDWZ128rrkz_VPACKSSDWrr_VPACKSSWBZ128rr_VPACKSSWBZ128rrk_VPACKSSWBZ128rrkz_VPACKSSWBrr_VPACKUSDWZ128rr_VPACKUSDWZ128rrk_VPACKUSDWZ128rrkz_VPACKUSDWrr_VPACKUSWBZ128rr_VPACKUSWBZ128rrk_VPACKUSWBZ128rrkz_VPACKUSWBrr") 1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #1349
  {DBGFIELD("INSERTPSrr_VINSERTPSZrr_VINSERTPSrr_MOVHLPSrr_MOVLHPSrr_VMOVHLPSZrr_VMOVHLPSrr_VMOVLHPSZrr_VMOVLHPSrr_MOVDDUPrr_VMOVDDUPZ128rr_VMOVDDUPZ128rrk_VMOVDDUPZ128rrkz_VMOVDDUPrr_VPERMILPDZ128ri_VPERMILPDZ128rik_VPERMILPDZ128rikz_VPERMILPDri_VPERMILPSZ128ri_VPERMILPSZ128rik_VPERMILPSZ128rikz_VPERMILPSri_UNPCKHPDrr_UNPCKHPSrr_UNPCKLPDrr_UNPCKLPSrr_VUNPCKHPDZ128rr_VUNPCKHPDZ128rrk_VUNPCKHPDZ128rrkz_VUNPCKHPDrr_VUNPCKHPSZ128rr_VUNPCKHPSZ128rrk_VUNPCKHPSZ128rrkz_VUNPCKHPSrr_VUNPCKLPDZ128rr_VUNPCKLPDZ128rrk_VUNPCKLPDZ128rrkz_VUNPCKLPDrr_VUNPCKLPSZ128rr_VUNPCKLPSZ128rrk_VUNPCKLPSZ128rrkz_VUNPCKLPSrr") 1, false, false, false, 1693, 3, 13, 1,  0, 0}, // #1350
  {DBGFIELD("VMOVDDUPYrr_VMOVDDUPZ256rr_VMOVDDUPZ256rrk_VMOVDDUPZ256rrkz_VPERMILPDYri_VPERMILPDZ256ri_VPERMILPDZ256rik_VPERMILPDZ256rikz_VPERMILPSYri_VPERMILPSZ256ri_VPERMILPSZ256rik_VPERMILPSZ256rikz_VUNPCKHPDYrr_VUNPCKHPDZ256rr_VUNPCKHPDZ256rrk_VUNPCKHPDZ256rrkz_VUNPCKHPSYrr_VUNPCKHPSZ256rr_VUNPCKHPSZ256rrk_VUNPCKHPSZ256rrkz_VUNPCKLPDYrr_VUNPCKLPDZ256rr_VUNPCKLPDZ256rrk_VUNPCKLPDZ256rrkz_VUNPCKLPSYrr_VUNPCKLPSZ256rr_VUNPCKLPSZ256rrk_VUNPCKLPSZ256rrkz") 2, false, false, false, 2037, 3, 13, 1,  0, 0}, // #1351
  {DBGFIELD("VMOVDDUPZrr_VMOVDDUPZrrk_VMOVDDUPZrrkz_VPERMILPDZri_VPERMILPDZrik_VPERMILPDZrikz_VPERMILPSZri_VPERMILPSZrik_VPERMILPSZrikz_VUNPCKHPDZrr_VUNPCKHPDZrrk_VUNPCKHPDZrrkz_VUNPCKHPSZrr_VUNPCKHPSZrrk_VUNPCKHPSZrrkz_VUNPCKLPDZrr_VUNPCKLPDZrrk_VUNPCKLPDZrrkz_VUNPCKLPSZrr_VUNPCKLPSZrrk_VUNPCKLPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1352
  {DBGFIELD("VPALIGNRYrri_VPALIGNRZ256rri_VPALIGNRZ256rrik_VPALIGNRZ256rrikz_VPACKSSDWYrr_VPACKSSDWZ256rr_VPACKSSDWZ256rrk_VPACKSSDWZ256rrkz_VPACKSSWBYrr_VPACKSSWBZ256rr_VPACKSSWBZ256rrk_VPACKSSWBZ256rrkz_VPACKUSDWYrr_VPACKUSDWZ256rr_VPACKUSDWZ256rrk_VPACKUSDWZ256rrkz_VPACKUSWBYrr_VPACKUSWBZ256rr_VPACKUSWBZ256rrk_VPACKUSWBZ256rrkz") 2, false, false, false, 1912, 3, 13, 1,  0, 0}, // #1353
  {DBGFIELD("VPALIGNRZrri_VPALIGNRZrrik_VPALIGNRZrrikz_VPACKSSDWZrr_VPACKSSDWZrrk_VPACKSSDWZrrkz_VPACKSSWBZrr_VPACKSSWBZrrk_VPACKSSWBZrrkz_VPACKUSDWZrr_VPACKUSDWZrrk_VPACKUSDWZrrkz_VPACKUSWBZrr_VPACKUSWBZrrk_VPACKUSWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1354
  {DBGFIELD("VPERMILPDYrr_VPERMILPDZ256rr_VPERMILPDZ256rrk_VPERMILPDZ256rrkz_VPERMILPSYrr_VPERMILPSZ256rr_VPERMILPSZ256rrk_VPERMILPSZ256rrkz") 2, false, false, false, 2037, 3,  5, 1,  0, 0}, // #1355
  {DBGFIELD("VPERMILPDZ128rr_VPERMILPDZ128rrk_VPERMILPDZ128rrkz_VPERMILPDrr_VPERMILPSZ128rr_VPERMILPSZ128rrk_VPERMILPSZ128rrkz_VPERMILPSrr") 1, false, false, false, 1693, 3,  5, 1,  0, 0}, // #1356
  {DBGFIELD("VPERMILPDZrr_VPERMILPDZrrk_VPERMILPDZrrkz_VPERMILPSZrr_VPERMILPSZrrk_VPERMILPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1357
  {DBGFIELD("MOVSDrr_MOVSDrr_REV_VMOVSDZrr_VMOVSDZrr_REV_VMOVSDZrrk_VMOVSDZrrk_REV_VMOVSDZrrkz_VMOVSDZrrkz_REV_VMOVSDrr_VMOVSDrr_REV_VMOVSSZrr_VMOVSSZrr_REV_VMOVSSZrrk_VMOVSSZrrk_REV_VMOVSSZrrkz_VMOVSSZrrkz_REV_VMOVSSrr_VMOVSSrr_REV") 1, false, false, false, 1693, 3, 13, 1,  0, 0}, // #1358
  {DBGFIELD("VPBROADCASTBZ128rm_VPBROADCASTBZ128rmk_VPBROADCASTBZ128rmkz_VPBROADCASTWZ128rm_VPBROADCASTWZ128rmk_VPBROADCASTWZ128rmkz") 1, false, false, false, 1825, 5,  6, 1,  0, 0}, // #1359
  {DBGFIELD("INSERTPSrm_VINSERTPSZrm_VINSERTPSrm_UNPCKHPDrm_UNPCKHPSrm_UNPCKLPDrm_UNPCKLPSrm_VUNPCKHPDZ128rm_VUNPCKHPDZ128rmb_VUNPCKHPDZ128rmbk_VUNPCKHPDZ128rmbkz_VUNPCKHPDZ128rmk_VUNPCKHPDZ128rmkz_VUNPCKHPDrm_VUNPCKHPSZ128rm_VUNPCKHPSZ128rmb_VUNPCKHPSZ128rmbk_VUNPCKHPSZ128rmbkz_VUNPCKHPSZ128rmk_VUNPCKHPSZ128rmkz_VUNPCKHPSrm_VUNPCKLPDZ128rm_VUNPCKLPDZ128rmb_VUNPCKLPDZ128rmbk_VUNPCKLPDZ128rmbkz_VUNPCKLPDZ128rmk_VUNPCKLPDZ128rmkz_VUNPCKLPDrm_VUNPCKLPSZ128rm_VUNPCKLPSZ128rmb_VUNPCKLPSZ128rmbk_VUNPCKLPSZ128rmbkz_VUNPCKLPSZ128rmk_VUNPCKLPSZ128rmkz_VUNPCKLPSrm") 1, false, false, false, 1692, 5,  6, 1,  3, 1}, // #1360
  {DBGFIELD("PALIGNRrmi_VPALIGNRZ128rmi_VPALIGNRZ128rmik_VPALIGNRZ128rmikz_VPALIGNRrmi_PACKSSDWrm_PACKSSWBrm_PACKUSDWrm_PACKUSWBrm_VPACKSSDWZ128rm_VPACKSSDWZ128rmb_VPACKSSDWZ128rmbk_VPACKSSDWZ128rmbkz_VPACKSSDWZ128rmk_VPACKSSDWZ128rmkz_VPACKSSDWrm_VPACKSSWBZ128rm_VPACKSSWBZ128rmk_VPACKSSWBZ128rmkz_VPACKSSWBrm_VPACKUSDWZ128rm_VPACKUSDWZ128rmb_VPACKUSDWZ128rmbk_VPACKUSDWZ128rmbkz_VPACKUSDWZ128rmk_VPACKUSDWZ128rmkz_VPACKUSDWrm_VPACKUSWBZ128rm_VPACKUSWBZ128rmk_VPACKUSWBZ128rmkz_VPACKUSWBrm") 1, false, false, false, 1825, 5,  6, 1,  3, 1}, // #1361
  {DBGFIELD("VPERMILPDZ128mbi_VPERMILPDZ128mbik_VPERMILPDZ128mbikz_VPERMILPDZ128mi_VPERMILPDZ128mik_VPERMILPDZ128mikz_VPERMILPDmi_VPERMILPSZ128mbi_VPERMILPSZ128mbik_VPERMILPSZ128mbikz_VPERMILPSZ128mi_VPERMILPSZ128mik_VPERMILPSZ128mikz_VPERMILPSmi") 1, false, false, false, 1692, 5,  6, 1,  0, 0}, // #1362
  {DBGFIELD("VPERMILPDZ128rm_VPERMILPDZ128rmb_VPERMILPDZ128rmbk_VPERMILPDZ128rmbkz_VPERMILPDZ128rmk_VPERMILPDZ128rmkz_VPERMILPDrm_VPERMILPSZ128rm_VPERMILPSZ128rmb_VPERMILPSZ128rmbk_VPERMILPSZ128rmbkz_VPERMILPSZ128rmk_VPERMILPSZ128rmkz_VPERMILPSrm") 1, false, false, false, 1692, 5,  2, 1,  3, 1}, // #1363
  {DBGFIELD("VPALIGNRYrmi_VPALIGNRZ256rmi_VPALIGNRZ256rmik_VPALIGNRZ256rmikz_VPACKSSDWYrm_VPACKSSDWZ256rm_VPACKSSDWZ256rmb_VPACKSSDWZ256rmbk_VPACKSSDWZ256rmbkz_VPACKSSDWZ256rmk_VPACKSSDWZ256rmkz_VPACKSSWBYrm_VPACKSSWBZ256rm_VPACKSSWBZ256rmk_VPACKSSWBZ256rmkz_VPACKUSDWYrm_VPACKUSDWZ256rm_VPACKUSDWZ256rmb_VPACKUSDWZ256rmbk_VPACKUSDWZ256rmbkz_VPACKUSDWZ256rmk_VPACKUSDWZ256rmkz_VPACKUSWBYrm_VPACKUSWBZ256rm_VPACKUSWBZ256rmk_VPACKUSWBZ256rmkz") 2, false, false, false, 1911, 5,  6, 1,  3, 1}, // #1364
  {DBGFIELD("VPALIGNRZrmi_VPALIGNRZrmik_VPALIGNRZrmikz_VPACKSSDWZrm_VPACKSSDWZrmb_VPACKSSDWZrmbk_VPACKSSDWZrmbkz_VPACKSSDWZrmk_VPACKSSDWZrmkz_VPACKSSWBZrm_VPACKSSWBZrmk_VPACKSSWBZrmkz_VPACKUSDWZrm_VPACKUSDWZrmb_VPACKUSDWZrmbk_VPACKUSDWZrmbkz_VPACKUSDWZrmk_VPACKUSDWZrmkz_VPACKUSWBZrm_VPACKUSWBZrmk_VPACKUSWBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1365
  {DBGFIELD("VPERMILPDYmi_VPERMILPDZ256mbi_VPERMILPDZ256mbik_VPERMILPDZ256mbikz_VPERMILPDZ256mi_VPERMILPDZ256mik_VPERMILPDZ256mikz_VPERMILPSYmi_VPERMILPSZ256mbi_VPERMILPSZ256mbik_VPERMILPSZ256mbikz_VPERMILPSZ256mi_VPERMILPSZ256mik_VPERMILPSZ256mikz") 2, false, false, false, 2036, 5,  6, 1,  0, 0}, // #1366
  {DBGFIELD("VPERMILPDZmbi_VPERMILPDZmbik_VPERMILPDZmbikz_VPERMILPDZmi_VPERMILPDZmik_VPERMILPDZmikz_VPERMILPSZmbi_VPERMILPSZmbik_VPERMILPSZmbikz_VPERMILPSZmi_VPERMILPSZmik_VPERMILPSZmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1367
  {DBGFIELD("VPERMILPDYrm_VPERMILPDZ256rm_VPERMILPDZ256rmb_VPERMILPDZ256rmbk_VPERMILPDZ256rmbkz_VPERMILPDZ256rmk_VPERMILPDZ256rmkz_VPERMILPSYrm_VPERMILPSZ256rm_VPERMILPSZ256rmb_VPERMILPSZ256rmbk_VPERMILPSZ256rmbkz_VPERMILPSZ256rmk_VPERMILPSZ256rmkz") 2, false, false, false, 2036, 5,  2, 1,  3, 1}, // #1368
  {DBGFIELD("VPERMILPDZrm_VPERMILPDZrmb_VPERMILPDZrmbk_VPERMILPDZrmbkz_VPERMILPDZrmk_VPERMILPDZrmkz_VPERMILPSZrm_VPERMILPSZrmb_VPERMILPSZrmbk_VPERMILPSZrmbkz_VPERMILPSZrmk_VPERMILPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1369
  {DBGFIELD("VUNPCKHPDYrm_VUNPCKHPDZ256rm_VUNPCKHPDZ256rmb_VUNPCKHPDZ256rmbk_VUNPCKHPDZ256rmbkz_VUNPCKHPDZ256rmk_VUNPCKHPDZ256rmkz_VUNPCKHPSYrm_VUNPCKHPSZ256rm_VUNPCKHPSZ256rmb_VUNPCKHPSZ256rmbk_VUNPCKHPSZ256rmbkz_VUNPCKHPSZ256rmk_VUNPCKHPSZ256rmkz_VUNPCKLPDYrm_VUNPCKLPDZ256rm_VUNPCKLPDZ256rmb_VUNPCKLPDZ256rmbk_VUNPCKLPDZ256rmbkz_VUNPCKLPDZ256rmk_VUNPCKLPDZ256rmkz_VUNPCKLPSYrm_VUNPCKLPSZ256rm_VUNPCKLPSZ256rmb_VUNPCKLPSZ256rmbk_VUNPCKLPSZ256rmbkz_VUNPCKLPSZ256rmk_VUNPCKLPSZ256rmkz") 2, false, false, false, 2036, 5,  6, 1,  3, 1}, // #1370
  {DBGFIELD("VUNPCKHPDZrm_VUNPCKHPDZrmb_VUNPCKHPDZrmbk_VUNPCKHPDZrmbkz_VUNPCKHPDZrmk_VUNPCKHPDZrmkz_VUNPCKHPSZrm_VUNPCKHPSZrmb_VUNPCKHPSZrmbk_VUNPCKHPSZrmbkz_VUNPCKHPSZrmk_VUNPCKHPSZrmkz_VUNPCKLPDZrm_VUNPCKLPDZrmb_VUNPCKLPDZrmbk_VUNPCKLPDZrmbkz_VUNPCKLPDZrmk_VUNPCKLPDZrmkz_VUNPCKLPSZrm_VUNPCKLPSZrmb_VUNPCKLPSZrmbk_VUNPCKLPSZrmbkz_VUNPCKLPSZrmk_VUNPCKLPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1371
  {DBGFIELD("PdWriteZeroLatency") 1, false, false, false,  0, 0,  0, 1,  0, 0}, // #1372
  {DBGFIELD("WriteVecALU")        1, false, false, false, 1629, 3, 13, 1,  0, 0}, // #1373
  {DBGFIELD("JWriteZeroLatency")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1374
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1375
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1376
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1377
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1378
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1379
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1380
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1381
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1382
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1383
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1384
  {DBGFIELD("JWriteLOCK_CMPXCHG8B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1385
  {DBGFIELD("JWriteLOCK_CMPXCHG16B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1386
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1387
  {DBGFIELD("JWriteLOCK_CMPXCHGrm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1388
  {DBGFIELD("JWriteCMPXCHG8B")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1389
  {DBGFIELD("JWriteCMPXCHG16B")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1390
  {DBGFIELD("JWriteCMPXCHG8rm")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1391
  {DBGFIELD("WriteCMPXCHGRMW")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1392
  {DBGFIELD("JWriteCMPXCHG8rr")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1393
  {DBGFIELD("WriteCMPXCHG")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1394
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1395
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1396
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1397
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1398
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1399
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1400
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1401
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1402
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1403
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1404
  {DBGFIELD("JWriteLOCK_XADDrm_XCHG_Part_JWriteXCHGrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1405
  {DBGFIELD("JWriteXADDrm_XCHG_Part_JWriteXADDrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1406
  {DBGFIELD("SBWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1407
  {DBGFIELD("WriteALU")           1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #1408
  {DBGFIELD("HWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1409
  {DBGFIELD("BWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1410
  {DBGFIELD("Zn3WriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1411
  {DBGFIELD("SKLWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1412
  {DBGFIELD("SKXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1413
  {DBGFIELD("ICXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1414
  {DBGFIELD("WriteFLogic")        1, false, false, false, 1693, 3, 13, 1,  0, 0}, // #1415
  {DBGFIELD("WriteFLogicY")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1416
  {DBGFIELD("JWriteZeroIdiomYmm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1417
  {DBGFIELD("WriteVecLogicX")     1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #1418
  {DBGFIELD("WriteVecALUX")       1, false, false, false, 1815, 3, 13, 1,  0, 0}, // #1419
  {DBGFIELD("SKLWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1420
  {DBGFIELD("SKXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1421
  {DBGFIELD("ICXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1422
  {DBGFIELD("SBWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1423
  {DBGFIELD("HWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1424
  {DBGFIELD("BWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1425
  {DBGFIELD("SKLWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1426
  {DBGFIELD("SKXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1427
  {DBGFIELD("ICXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1428
  {DBGFIELD("SBWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1429
  {DBGFIELD("WriteCMOV")          0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1430
  {DBGFIELD("HWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1431
  {DBGFIELD("BWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1432
  {DBGFIELD("SKLWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1433
  {DBGFIELD("SKXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1434
  {DBGFIELD("ICXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1435
  {DBGFIELD("SBWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1436
  {DBGFIELD("WriteCMOVLd")        1, false, false, false, 1717, 4, 14, 1,  0, 0}, // #1437
  {DBGFIELD("HWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1438
  {DBGFIELD("BWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1439
  {DBGFIELD("PdWriteCMOVm")       2, false, false, false, 2217, 4, 14, 1,  0, 0}, // #1440
  {DBGFIELD("SKLWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1441
  {DBGFIELD("SKXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1442
  {DBGFIELD("ICXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1443
  {DBGFIELD("SBWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1444
  {DBGFIELD("WriteSETCC")         0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1445
  {DBGFIELD("HWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1446
  {DBGFIELD("BWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1447
  {DBGFIELD("SKLWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1448
  {DBGFIELD("SKXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1449
  {DBGFIELD("ICXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1450
  {DBGFIELD("SBWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1451
  {DBGFIELD("WriteSETCCStore")    1, false, false, false, 2007, 4,  1, 1,  0, 0}, // #1452
  {DBGFIELD("HWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1453
  {DBGFIELD("BWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1454
  {DBGFIELD("PdWriteSETGEmSETGmSETLEmSETLm") 2, false, false, false, 1627, 2,  1, 1,  0, 0}, // #1455
  {DBGFIELD("SKLWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1456
  {DBGFIELD("SKXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1457
  {DBGFIELD("ICXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1458
  {DBGFIELD("WriteVecLogicY")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1459
  {DBGFIELD("WriteVecALUY")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1460
  {DBGFIELD("HWWriteADC0")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1461
  {DBGFIELD("WriteADC")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1462
  {DBGFIELD("JWriteLOCK_ALURMW")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1463
  {DBGFIELD("WriteALURMW")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1464
  {DBGFIELD("WriteFShuffle256")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1465
  {DBGFIELD("Zn3Write3OpsLEA")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1466
  {DBGFIELD("WriteLEA")           1, false, false, false, 1627, 2,  1, 1,  0, 0}, // #1467
  {DBGFIELD("PdWrite3OpsLEA")     1, false, false, false, 1627, 2, 13, 1,  0, 0}, // #1468
  {DBGFIELD("JWrite3OpsLEA")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1469
  {DBGFIELD("WriteVecLogic")      1, false, false, false, 1629, 3, 13, 1,  0, 0}, // #1470
  {DBGFIELD("WriteFLogicZ")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1471
  {DBGFIELD("WriteVecLogicZ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1472
}; // BdVer2ModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc BroadwellModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, false, 154, 4,  1, 1,  0, 0}, // #3
  {DBGFIELD("WriteJump")          1, false, false, false,  8, 4,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteCMPXCHGRMW")    6, false, false, false, 12, 8,  2, 1,  0, 0}, // #5
  {DBGFIELD("WriteJumpLd")        2, false, false, false, 20, 6,  3, 1,  0, 0}, // #6
  {DBGFIELD("WriteMove")          1, false, false, false,  1, 2,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, false,  1, 2,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteADC")           1, false, false, false,  8, 4,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteSHDrri")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreX")       2, false, false, false, 33, 4,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteFLoadX")        1, false, false, false, 37, 3, 14, 1,  0, 0}, // #12
  {DBGFIELD("WriteFStoreY")       2, false, false, false, 33, 4,  1, 1,  0, 0}, // #13
  {DBGFIELD("WriteFLoadY")        1, false, false, false, 37, 3,  3, 1,  0, 0}, // #14
  {DBGFIELD("WriteMicrocoded")    1, false, false, false,  1, 2,  4, 1,  0, 0}, // #15
  {DBGFIELD("WriteFSign")         1, false, false, false, 474, 8,  1, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCRMW")        6, false, false, false, 12, 8,  2, 1,  0, 0}, // #17
  {DBGFIELD("WriteADCRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 6, false, false, false, 12, 8,  2, 1,  1, 2}, // #18
  {DBGFIELD("WriteADCLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 20, 6,  3, 1,  3, 2}, // #19
  {DBGFIELD("WriteALURMW")        3, false, false, false, 49, 6,  6, 1,  0, 0}, // #20
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, false, 49, 6,  6, 1,  1, 1}, // #21
  {DBGFIELD("WriteALULd_ReadAfterLd") 2, false, false, false, 55, 4,  3, 1,  3, 1}, // #22
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #23
  {DBGFIELD("WriteFAdd64X")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #24
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #25
  {DBGFIELD("WriteFAddX")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #26
  {DBGFIELD("WriteNop")           1, false, false, false,  0, 0,  1, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #28
  {DBGFIELD("WriteFAdd64")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #29
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #30
  {DBGFIELD("WriteFAdd")          1, false, false, false, 26, 7,  5, 1,  0, 0}, // #31
  {DBGFIELD("WriteFAddLd")        2, false, false, false, 158, 9,  2, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 2, false, false, false, 464, 10, 23, 1,  3, 1}, // #33
  {DBGFIELD("WriteAESDecEnc")     1, false, false, false, 474, 8,  6, 1,  0, 0}, // #34
  {DBGFIELD("WriteAESIMCLd")      3, false, false, false, 531, 10, 20, 1,  0, 0}, // #35
  {DBGFIELD("WriteAESIMC")        2, false, false, false, 523, 8, 10, 1,  0, 0}, // #36
  {DBGFIELD("WriteAESKeyGenLd")   11, false, false, false, 2258, 14, 90, 1,  0, 0}, // #37
  {DBGFIELD("WriteAESKeyGen")     11, false, false, false, 2272, 12, 15, 1,  0, 0}, // #38
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #39
  {DBGFIELD("WriteFLogic")        1, false, false, false, 474, 8,  1, 1,  0, 0}, // #40
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, false, 126, 8,  6, 1,  1, 1}, // #41
  {DBGFIELD("WriteBEXTR")         2, false, false, false, 134, 6, 13, 1,  0, 0}, // #42
  {DBGFIELD("WriteBEXTRLd")       3, false, false, false, 126, 8,  6, 1,  0, 0}, // #43
  {DBGFIELD("WriteALULd")         2, false, false, false, 55, 4,  3, 1,  0, 0}, // #44
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 2, false, false, false, 60, 5,  3, 1,  3, 1}, // #45
  {DBGFIELD("WriteFBlend")        1, false, false, false, 30, 3,  1, 1,  0, 0}, // #46
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 3, false, false, false, 531, 10,  6, 1,  3, 1}, // #47
  {DBGFIELD("WriteFVarBlend")     2, false, false, false, 523, 8, 13, 1,  0, 0}, // #48
  {DBGFIELD("WriteBLSLd")         2, false, false, false, 148, 6,  3, 1,  0, 0}, // #49
  {DBGFIELD("WriteBLS")           1, false, false, false, 154, 4,  1, 1,  0, 0}, // #50
  {DBGFIELD("WriteBSFLd")         2, false, false, false, 158, 9,  2, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSF")           1, false, false, false, 26, 7,  5, 1,  0, 0}, // #52
  {DBGFIELD("WriteBSRLd")         2, false, false, false, 158, 9,  2, 1,  0, 0}, // #53
  {DBGFIELD("WriteBSR")           1, false, false, false, 26, 7,  5, 1,  0, 0}, // #54
  {DBGFIELD("WriteBSWAP32")       1, false, false, false, 154, 4,  1, 1,  0, 0}, // #55
  {DBGFIELD("WriteBSWAP64")       2, false, false, false, 134, 6, 13, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestImmLd")  2, false, false, false, 20, 6,  3, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestRegLd")  2, false, false, false, 55, 4,  3, 1,  0, 0}, // #58
  {DBGFIELD("WriteBitTest")       1, false, false, false,  8, 4,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBitTestSetImmRMW") 4, false, false, false, 167, 8,  3, 1,  0, 0}, // #60
  {DBGFIELD("WriteBitTestSetRegRMW") 3, false, false, false, 49, 6,  3, 1,  0, 0}, // #61
  {DBGFIELD("WriteBitTestSet")    1, false, false, false,  8, 4,  1, 1,  0, 0}, // #62
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 148, 6,  3, 1,  1, 1}, // #63
  {DBGFIELD("WriteBZHI")          1, false, false, false, 154, 4,  1, 1,  0, 0}, // #64
  {DBGFIELD("WriteLoad")          1, false, false, false, 37, 3, 14, 1,  0, 0}, // #65
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 2, false, false, false, 20, 6,  3, 1,  3, 1}, // #66
  {DBGFIELD("WriteCMOV")          1, false, false, false,  8, 4,  1, 1,  0, 0}, // #67
  {DBGFIELD("WriteFCMOV")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #68
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 55, 4,  3, 1,  1, 1}, // #69
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #70
  {DBGFIELD("WriteFCmp64X")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #71
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #72
  {DBGFIELD("WriteFCmpX")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #73
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #74
  {DBGFIELD("WriteFCmp64")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #75
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #76
  {DBGFIELD("WriteFCmp")          1, false, false, false, 26, 7,  5, 1,  0, 0}, // #77
  {DBGFIELD("WriteCMPXCHG")       5, false, false, false, 175, 4, 14, 1,  0, 0}, // #78
  {DBGFIELD("WriteFComXLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #79
  {DBGFIELD("WriteFComX")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #80
  {DBGFIELD("WriteFCom")          1, false, false, false, 26, 7,  5, 1,  0, 0}, // #81
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #82
  {DBGFIELD("WriteCRC32")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtI2PDLd")     2, false, false, false, 158, 9,  9, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtI2PD")       1, false, false, false, 26, 7,  8, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtI2PSLd")     2, false, false, false, 158, 9,  9, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtI2PS")       1, false, false, false, 26, 7,  8, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtPD2ILd")     2, false, false, false, 158, 9,  2, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPD2I")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPD2PSLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPD2PS")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPS2ILd")     2, false, false, false, 158, 9,  2, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtPS2I")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtPS2PD")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtSD2ILd")     2, false, false, false, 158, 9,  2, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtSD2I")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtSD2SSLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #100
  {DBGFIELD("WriteCvtSD2SS")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, false, 158, 9,  9, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  9, 1,  3, 1}, // #103
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 1, false, false, false, 26, 7,  8, 1,  0, 1}, // #104
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 1, false, false, false, 26, 7,  8, 1,  6, 1}, // #105
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, false, 158, 9,  9, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  9, 1,  3, 1}, // #107
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 1, false, false, false, 26, 7,  8, 1,  0, 1}, // #108
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 1, false, false, false, 26, 7,  8, 1,  6, 1}, // #109
  {DBGFIELD("WriteCvtSS2SDLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #110
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #111
  {DBGFIELD("WriteCvtSS2SD")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #112
  {DBGFIELD("WriteCvtSS2ILd")     2, false, false, false, 158, 9,  2, 1,  0, 0}, // #113
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #114
  {DBGFIELD("WriteCvtSS2I")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #115
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 2284, 16, 58, 1,  1, 2}, // #116
  {DBGFIELD("WriteDiv16")         32, false, false, false, 2300, 15, 91, 1,  0, 0}, // #117
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 2284, 16, 58, 1,  1, 2}, // #118
  {DBGFIELD("WriteDiv32")         32, false, false, false, 2300, 15, 91, 1,  0, 0}, // #119
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 2284, 16, 58, 1,  1, 2}, // #120
  {DBGFIELD("WriteDiv64")         32, false, false, false, 2300, 15, 91, 1,  0, 0}, // #121
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 2284, 16, 58, 1,  1, 2}, // #122
  {DBGFIELD("WriteDiv8")          1, false, false, false, 206, 10, 11, 1,  0, 0}, // #123
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 2, false, false, false, 769, 12, 20, 1,  3, 1}, // #124
  {DBGFIELD("WriteFDiv64X")       1, false, false, false, 2315, 10, 10, 1,  0, 0}, // #125
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 2, false, false, false, 238, 12, 19, 1,  3, 1}, // #126
  {DBGFIELD("WriteFDivX")         1, false, false, false, 781, 10, 18, 1,  0, 0}, // #127
  {DBGFIELD("WriteFDivLd")        2, false, false, false, 238, 12, 19, 1,  0, 0}, // #128
  {DBGFIELD("WriteFDiv")          1, false, false, false, 228, 10, 18, 1,  0, 0}, // #129
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 2, false, false, false, 769, 12, 20, 1,  3, 1}, // #130
  {DBGFIELD("WriteFDiv64")        1, false, false, false, 2325, 10, 10, 1,  0, 0}, // #131
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 2, false, false, false, 238, 12, 19, 1,  3, 1}, // #132
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 4, false, false, false, 2335, 16, 10, 1,  3, 1}, // #133
  {DBGFIELD("WriteDPPD")          3, false, false, false, 2351, 14,  9, 1,  0, 0}, // #134
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 5, false, false, false, 2365, 16, 20, 1,  3, 1}, // #135
  {DBGFIELD("WriteDPPS")          4, false, false, false, 2381, 14, 10, 1,  0, 0}, // #136
  {DBGFIELD("WriteStore")         1, false, false, false, 33, 4,  1, 1,  0, 0}, // #137
  {DBGFIELD("WriteVecExtractSt")  3, false, false, false, 302, 11, 13, 1,  0, 0}, // #138
  {DBGFIELD("WriteVecExtract")    2, false, false, false, 313, 12, 13, 1,  0, 0}, // #139
  {DBGFIELD("WriteVecALUX")       1, false, false, false, 154, 4,  1, 1,  0, 0}, // #140
  {DBGFIELD("WriteFComLd")        2, false, false, false, 158, 9,  2, 1,  0, 0}, // #141
  {DBGFIELD("WriteEMMS")          31, false, false, false, 2395, 5, 92, 1,  0, 0}, // #142
  {DBGFIELD("WriteFLDC")          2, false, false, false, 637, 4,  1, 1,  0, 0}, // #143
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 2, false, false, false, 148, 6,  3, 1,  3, 1}, // #144
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 4, false, false, false, 2400, 13,  7, 1,  3, 1}, // #145
  {DBGFIELD("WriteFHAdd")         3, false, false, false, 2413, 11, 14, 1,  0, 0}, // #146
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 2284, 16, 42, 1,  1, 2}, // #147
  {DBGFIELD("WriteIDiv16")        1, false, false, false, 206, 10, 11, 1,  0, 0}, // #148
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 2284, 16, 42, 1,  1, 2}, // #149
  {DBGFIELD("WriteIDiv32")        1, false, false, false, 206, 10, 11, 1,  0, 0}, // #150
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 2284, 16, 42, 1,  1, 2}, // #151
  {DBGFIELD("WriteIDiv64")        1, false, false, false, 206, 10, 11, 1,  0, 0}, // #152
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 2284, 16, 42, 1,  1, 2}, // #153
  {DBGFIELD("WriteIDiv8")         1, false, false, false, 206, 10, 11, 1,  0, 0}, // #154
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 384, 11,  9, 1,  1, 2}, // #155
  {DBGFIELD("WriteIMul16")        4, false, false, false, 395, 9,  8, 1,  0, 0}, // #156
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #157
  {DBGFIELD("WriteIMul16ImmLd")   3, false, false, false, 404, 9,  2, 1,  0, 0}, // #158
  {DBGFIELD("WriteIMul16Reg")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul16Imm")     2, false, false, false, 413, 7,  8, 1,  0, 0}, // #160
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 420, 11,  9, 1,  1, 2}, // #161
  {DBGFIELD("WriteIMul32")        3, false, false, false, 431, 9,  8, 1,  0, 0}, // #162
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #163
  {DBGFIELD("WriteIMul32ImmLd")   2, false, false, false, 158, 9,  2, 1,  0, 0}, // #164
  {DBGFIELD("WriteIMul32Reg")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul32Imm")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #166
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 440, 13,  9, 1,  1, 2}, // #167
  {DBGFIELD("WriteIMul64")        2, false, false, false, 453, 11,  8, 1,  0, 0}, // #168
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #169
  {DBGFIELD("WriteIMul64ImmLd")   2, false, false, false, 158, 9,  2, 1,  0, 0}, // #170
  {DBGFIELD("WriteIMul64Reg")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #171
  {DBGFIELD("WriteIMul64Imm")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #172
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 158, 9,  2, 1,  1, 2}, // #173
  {DBGFIELD("WriteIMul8")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #174
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #175
  {DBGFIELD("WriteFShuffle")      1, false, false, false, 474, 8,  1, 1,  0, 0}, // #176
  {DBGFIELD("WriteVecLogicX")     1, false, false, false, 30, 3,  1, 1,  0, 0}, // #177
  {DBGFIELD("WriteShuffle")       1, false, false, false, 474, 8,  1, 1,  0, 0}, // #178
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, false,  8, 4,  1, 1,  0, 0}, // #179
  {DBGFIELD("WriteVecLoadX")      1, false, false, false, 37, 3, 14, 1,  0, 0}, // #180
  {DBGFIELD("WriteLDMXCSR")       3, false, false, false, 482, 11,  6, 1,  0, 0}, // #181
  {DBGFIELD("WriteFLD0")          1, false, false, false, 65, 4,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteFLD1")          2, false, false, false, 637, 4,  1, 1,  0, 0}, // #183
  {DBGFIELD("WriteLEA")           1, false, false, false, 154, 4,  1, 1,  0, 0}, // #184
  {DBGFIELD("WriteFence")         1, false, false, false, 493, 5,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteLZCNTLd")       2, false, false, false, 158, 9,  2, 1,  0, 0}, // #186
  {DBGFIELD("WriteLZCNT")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecStoreX")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #188
  {DBGFIELD("WriteVecStore")      2, false, false, false, 33, 4,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, false, 40, 9,  1, 1,  0, 0}, // #190
  {DBGFIELD("WriteVecLoad")       1, false, false, false, 37, 3, 14, 1,  0, 0}, // #191
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecMoveX")      1, false, false, false, 30, 3,  1, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecStoreNT")    2, false, false, false, 33, 4,  1, 1,  0, 0}, // #194
  {DBGFIELD("WriteVecMove")       1, false, false, false, 30, 3,  1, 1,  0, 0}, // #195
  {DBGFIELD("WriteVecALULd")      2, false, false, false, 148, 6,  3, 1,  0, 0}, // #196
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #197
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 2, false, false, false, 148, 6,  3, 1,  3, 1}, // #198
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 2, false, false, false, 60, 5,  3, 1,  3, 1}, // #199
  {DBGFIELD("WriteVecLogic")      1, false, false, false, 30, 3,  1, 1,  0, 0}, // #200
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, false, 2424, 10,  2, 1,  3, 1}, // #201
  {DBGFIELD("WritePHAdd")         3, false, false, false, 2434, 8,  5, 1,  0, 0}, // #202
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #203
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 2, false, false, false, 523, 8, 13, 1,  6, 1}, // #204
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #205
  {DBGFIELD("WriteVecIMul")       1, false, false, false, 40, 9, 14, 1,  0, 0}, // #206
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, false, 40, 9,  1, 1,  0, 0}, // #207
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #208
  {DBGFIELD("WritePSADBW")        1, false, false, false, 40, 9, 14, 1,  0, 0}, // #209
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #210
  {DBGFIELD("WriteVarShuffle")    1, false, false, false, 474, 8,  1, 1,  0, 0}, // #211
  {DBGFIELD("WriteShuffleLd")     2, false, false, false, 464, 10,  3, 1,  0, 0}, // #212
  {DBGFIELD("WriteVecShiftImm")   1, false, false, false, 40, 9,  1, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 2, false, false, false, 69, 11,  3, 1,  3, 1}, // #214
  {DBGFIELD("WriteVecShift")      1, false, false, false, 40, 9,  1, 1,  0, 0}, // #215
  {DBGFIELD("WriteFMoveX")        1, false, false, false, 474, 8,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteFShuffleLd")    2, false, false, false, 464, 10,  3, 1,  0, 0}, // #217
  {DBGFIELD("WriteFStore")        2, false, false, false, 33, 4,  1, 1,  0, 0}, // #218
  {DBGFIELD("WriteFMOVMSK")       1, false, false, false, 40, 9,  5, 1,  0, 0}, // #219
  {DBGFIELD("WriteVecLoadNT")     1, false, false, false, 37, 3, 14, 1,  0, 0}, // #220
  {DBGFIELD("WriteStoreNT")       2, false, false, false, 33, 4,  1, 1,  0, 0}, // #221
  {DBGFIELD("WriteFStoreNTX")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #222
  {DBGFIELD("WriteFStoreNT")      2, false, false, false, 33, 4,  1, 1,  0, 0}, // #223
  {DBGFIELD("WriteFLoad")         1, false, false, false, 37, 3, 14, 1,  0, 0}, // #224
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 4, false, false, false, 1482, 14, 23, 1,  3, 1}, // #225
  {DBGFIELD("WriteMPSAD")         3, false, false, false, 1470, 12,  6, 1,  0, 0}, // #226
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  2, 1,  3, 1}, // #227
  {DBGFIELD("WriteFMul64X")       1, false, false, false, 65, 4,  5, 1,  0, 0}, // #228
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  2, 1,  3, 1}, // #229
  {DBGFIELD("WriteFMulX")         1, false, false, false, 65, 4,  5, 1,  0, 0}, // #230
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 2, false, false, false, 59, 6,  2, 1,  3, 1}, // #231
  {DBGFIELD("WriteFMul64")        1, false, false, false, 65, 4,  5, 1,  0, 0}, // #232
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 2, false, false, false, 59, 6,  2, 1,  3, 1}, // #233
  {DBGFIELD("WriteFMul")          1, false, false, false, 65, 4,  5, 1,  0, 0}, // #234
  {DBGFIELD("WriteMULX32Ld")      4, false, false, false, 420, 11,  2, 1,  0, 0}, // #235
  {DBGFIELD("WriteMULX32")        3, false, false, false, 431, 9,  5, 1,  0, 0}, // #236
  {DBGFIELD("WriteIMulHLd_WriteMULX32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 5, false, false, false, 420, 11, 26, 2,  1, 1}, // #237
  {DBGFIELD("WriteIMulH_WriteMULX32") 4, false, false, false, 431, 9, 28, 2,  0, 0}, // #238
  {DBGFIELD("WriteMULX64Ld")      3, false, false, false, 440, 13,  2, 1,  0, 0}, // #239
  {DBGFIELD("WriteMULX64")        2, false, false, false, 453, 11,  5, 1,  0, 0}, // #240
  {DBGFIELD("WriteIMulHLd_WriteMULX64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 4, false, false, false, 440, 13, 26, 2,  1, 1}, // #241
  {DBGFIELD("WriteIMulH_WriteMULX64") 3, false, false, false, 453, 11, 28, 2,  0, 0}, // #242
  {DBGFIELD("WriteFMulLd")        2, false, false, false, 59, 6,  2, 1,  0, 0}, // #243
  {DBGFIELD("WriteVecALUXLd")     2, false, false, false, 148, 6,  3, 1,  0, 0}, // #244
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #245
  {DBGFIELD("WriteShuffleX")      1, false, false, false, 474, 8,  1, 1,  0, 0}, // #246
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 2, false, false, false, 60, 5,  3, 1,  3, 1}, // #247
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 3, false, false, false, 531, 10,  6, 1,  3, 1}, // #248
  {DBGFIELD("WriteVarBlend")      2, false, false, false, 523, 8, 13, 1,  0, 0}, // #249
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #250
  {DBGFIELD("WriteBlend")         1, false, false, false, 474, 8,  1, 1,  0, 0}, // #251
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #252
  {DBGFIELD("WriteCLMul")         1, false, false, false, 40, 9, 14, 1,  0, 0}, // #253
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 9, false, false, false, 541, 14, 36, 1,  3, 1}, // #254
  {DBGFIELD("WritePCmpEStrI")     8, false, false, false, 555, 12, 31, 1,  0, 0}, // #255
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 10, false, false, false, 567, 14, 30, 1,  3, 1}, // #256
  {DBGFIELD("WritePCmpEStrM")     9, false, false, false, 581, 12, 20, 1,  0, 0}, // #257
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 4, false, false, false, 593, 11, 19, 1,  3, 1}, // #258
  {DBGFIELD("WritePCmpIStrI")     3, false, false, false, 604, 9, 18, 1,  0, 0}, // #259
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 4, false, false, false, 593, 11, 19, 1,  3, 1}, // #260
  {DBGFIELD("WritePCmpIStrM")     3, false, false, false, 604, 9, 18, 1,  0, 0}, // #261
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #262
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 4, false, false, false, 2424, 10,  2, 1,  3, 1}, // #263
  {DBGFIELD("WritePHAddX")        3, false, false, false, 2434, 8,  5, 1,  0, 0}, // #264
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, false, 69, 11,  7, 1,  0, 0}, // #265
  {DBGFIELD("WritePHMINPOS")      1, false, false, false, 40, 9, 14, 1,  0, 0}, // #266
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 2, false, false, false, 158, 9,  9, 1,  3, 1}, // #267
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #268
  {DBGFIELD("WriteVecIMulX")      1, false, false, false, 40, 9, 14, 1,  0, 0}, // #269
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, false, 40, 9,  5, 1,  0, 0}, // #270
  {DBGFIELD("WriteShuffleXLd")    2, false, false, false, 464, 10,  3, 1,  0, 0}, // #271
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 3, false, false, false, 80, 11, 21, 1,  3, 1}, // #272
  {DBGFIELD("WritePMULLD")        2, false, false, false, 91, 9,  7, 1,  0, 0}, // #273
  {DBGFIELD("WriteCopy")          2, false, false, false, 641, 5,  3, 1,  0, 0}, // #274
  {DBGFIELD("WritePOPCNTLd")      2, false, false, false, 158, 9,  2, 1,  0, 0}, // #275
  {DBGFIELD("WritePOPCNT")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #276
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #277
  {DBGFIELD("WritePSADBWX")       1, false, false, false, 40, 9, 14, 1,  0, 0}, // #278
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #279
  {DBGFIELD("WriteVarShuffleX")   1, false, false, false, 474, 8,  1, 1,  0, 0}, // #280
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, false, 40, 9,  1, 1,  0, 0}, // #281
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 3, false, false, false, 655, 14,  6, 1,  3, 1}, // #282
  {DBGFIELD("WriteVecShiftX")     2, false, false, false, 313, 12, 13, 1,  0, 0}, // #283
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 3, false, false, false, 655, 14,  6, 1,  3, 1}, // #284
  {DBGFIELD("WriteVecTest")       2, false, false, false, 313, 12, 13, 1,  0, 0}, // #285
  {DBGFIELD("WriteRotateLd_WriteRMW") 3, false, false, false, 167, 8, 32, 2,  0, 0}, // #286
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 5, false, false, false, 12, 8, 34, 2,  0, 0}, // #287
  {DBGFIELD("WriteRotate")        1, false, false, false,  8, 4,  1, 1,  0, 0}, // #288
  {DBGFIELD("WriteRotateCL")      3, false, false, false, 2442, 4,  5, 1,  0, 0}, // #289
  {DBGFIELD("WriteFRcpXLd")       2, false, false, false, 69, 11,  7, 1,  0, 0}, // #290
  {DBGFIELD("WriteFRcpX")         1, false, false, false, 40, 9, 14, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRcpLd")        2, false, false, false, 69, 11,  7, 1,  0, 0}, // #292
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #293
  {DBGFIELD("WriteFRcp")          1, false, false, false, 40, 9, 14, 1,  0, 0}, // #294
  {DBGFIELD("WriteRMW")           1, false, false, false, 33, 4,  1, 1,  0, 0}, // #295
  {DBGFIELD("WriteShiftLd")       2, false, false, false, 20, 6,  3, 1,  0, 0}, // #296
  {DBGFIELD("WriteShift")         1, false, false, false,  8, 4,  1, 1,  0, 0}, // #297
  {DBGFIELD("WriteFRndLd")        3, false, false, false, 2446, 9, 18, 1,  0, 0}, // #298
  {DBGFIELD("WriteFRnd")          1, false, false, false, 37, 3,  3, 1,  0, 0}, // #299
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 3, false, false, false, 2446, 9, 18, 1,  3, 1}, // #300
  {DBGFIELD("WriteFRsqrtXLd")     2, false, false, false, 69, 11,  7, 1,  0, 0}, // #301
  {DBGFIELD("WriteFRsqrtX")       1, false, false, false, 40, 9, 14, 1,  0, 0}, // #302
  {DBGFIELD("WriteFRsqrtLd")      2, false, false, false, 69, 11,  7, 1,  0, 0}, // #303
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #304
  {DBGFIELD("WriteFRsqrt")        1, false, false, false, 40, 9, 14, 1,  0, 0}, // #305
  {DBGFIELD("WriteShiftLd_WriteRMW") 3, false, false, false, 167, 8, 32, 2,  0, 0}, // #306
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 5, false, false, false, 12, 8, 34, 2,  0, 0}, // #307
  {DBGFIELD("WriteShiftCL")       3, false, false, false, 2442, 4,  5, 1,  0, 0}, // #308
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 20, 6,  3, 1,  1, 1}, // #309
  {DBGFIELD("WriteSETCCStore")    3, false, false, false, 681, 7, 13, 1,  0, 0}, // #310
  {DBGFIELD("WriteSETCC")         1, false, false, false,  8, 4,  1, 1,  0, 0}, // #311
  {DBGFIELD("WriteSHDmrcl")       6, false, false, false, 2455, 11, 18, 1,  0, 0}, // #312
  {DBGFIELD("WriteSHDmri")        4, false, false, false, 699, 9,  9, 1,  0, 0}, // #313
  {DBGFIELD("WriteSHDrrcl")       4, false, false, false, 395, 9,  3, 1,  0, 0}, // #314
  {DBGFIELD("WriteFSqrt64XLd")    2, false, false, false, 2466, 12, 37, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrt64X")      1, false, false, false, 2478, 10, 19, 1,  0, 0}, // #316
  {DBGFIELD("WriteFSqrtXLd")      2, false, false, false, 2488, 12, 19, 1,  0, 0}, // #317
  {DBGFIELD("WriteFSqrtX")        1, false, false, false, 739, 10, 18, 1,  0, 0}, // #318
  {DBGFIELD("WriteFSqrt64Ld")     2, false, false, false, 2466, 12, 37, 1,  0, 0}, // #319
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 2, false, false, false, 2466, 12, 37, 1,  3, 1}, // #320
  {DBGFIELD("WriteFSqrt64")       1, false, false, false, 2315, 10, 19, 1,  0, 0}, // #321
  {DBGFIELD("WriteFSqrtLd")       2, false, false, false, 2488, 12, 19, 1,  0, 0}, // #322
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 2, false, false, false, 2488, 12, 19, 1,  3, 1}, // #323
  {DBGFIELD("WriteFSqrt")         1, false, false, false, 2325, 10, 18, 1,  0, 0}, // #324
  {DBGFIELD("WriteFSqrt80")       1, false, false, false, 2500, 10, 36, 1,  0, 0}, // #325
  {DBGFIELD("WriteSTMXCSR")       3, false, false, false, 302, 11, 13, 1,  0, 0}, // #326
  {DBGFIELD("WriteTZCNTLd")       2, false, false, false, 158, 9,  2, 1,  0, 0}, // #327
  {DBGFIELD("WriteTZCNT")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #328
  {DBGFIELD("WriteFMAZLd")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #329
  {DBGFIELD("WriteFMALd")         2, false, false, false, 59, 6,  7, 1,  0, 0}, // #330
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 2, false, false, false, 158, 9,  9, 1,  5, 1}, // #331
  {DBGFIELD("WriteFAdd64Y")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #332
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteFAdd64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 2, false, false, false, 158, 9,  9, 1,  5, 1}, // #335
  {DBGFIELD("WriteFAddY")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #336
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteFAddZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #339
  {DBGFIELD("WriteShuffleY")      1, false, false, false, 474, 8,  1, 1,  0, 0}, // #340
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteShuffleZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #343
  {DBGFIELD("WriteFLogicY")       1, false, false, false, 474, 8,  1, 1,  0, 0}, // #344
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #345
  {DBGFIELD("WriteFLogicZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #346
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 3, false, false, false, 531, 10,  2, 1,  5, 1}, // #347
  {DBGFIELD("WriteFVarBlendY")    2, false, false, false, 523, 8, 13, 1,  0, 0}, // #348
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #349
  {DBGFIELD("WriteFVarBlendZ")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 2, false, false, false, 60, 5,  6, 1,  5, 1}, // #351
  {DBGFIELD("WriteFBlendY")       1, false, false, false, 30, 3,  1, 1,  0, 0}, // #352
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 3, false, false, false, 531, 10,  2, 1, 10, 2}, // #353
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, false, 531, 10,  6, 1,  3, 2}, // #354
  {DBGFIELD("WriteShuffle256Ld")  2, false, false, false, 464, 10,  9, 1,  0, 0}, // #355
  {DBGFIELD("WriteShuffle256")    1, false, false, false, 474, 8,  5, 1,  0, 0}, // #356
  {DBGFIELD("WriteShuffleYLd")    2, false, false, false, 464, 10,  6, 1,  0, 0}, // #357
  {DBGFIELD("WriteFShuffle256")   1, false, false, false, 474, 8,  5, 1,  0, 0}, // #358
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #359
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 2, false, false, false, 158, 9,  9, 1,  5, 1}, // #360
  {DBGFIELD("WriteFCmp64Y")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #361
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 2, false, false, false, 158, 9,  9, 1,  5, 1}, // #362
  {DBGFIELD("WriteFCmpY")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #363
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #364
  {DBGFIELD("WriteFCmpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("WriteVarShuffle256Ld") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #366
  {DBGFIELD("WriteVarShuffle256") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #367
  {DBGFIELD("WriteCvtI2PDYLd")    2, false, false, false, 158, 9,  9, 1,  0, 0}, // #368
  {DBGFIELD("WriteCvtI2PDY")      1, false, false, false, 26, 7,  8, 1,  0, 0}, // #369
  {DBGFIELD("WriteCvtI2PDZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #370
  {DBGFIELD("WriteCvtI2PDZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, false, 158, 9,  9, 1,  0, 0}, // #372
  {DBGFIELD("WriteCvtI2PSY")      1, false, false, false, 26, 7,  8, 1,  0, 0}, // #373
  {DBGFIELD("WriteCvtI2PSZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #374
  {DBGFIELD("WriteCvtI2PSZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #376
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 2, false, false, false, 158, 9,  2, 1,  5, 1}, // #377
  {DBGFIELD("WriteCvtPD2PSY")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #378
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtPD2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteCvtPD2PSYLd")   2, false, false, false, 158, 9,  2, 1,  0, 0}, // #381
  {DBGFIELD("WriteCvtPD2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #382
  {DBGFIELD("WriteCvtPD2IYLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #383
  {DBGFIELD("WriteCvtPD2IY")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #384
  {DBGFIELD("WriteCvtPD2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #385
  {DBGFIELD("WriteCvtPD2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2IY")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2PDYLd")   2, false, false, false, 158, 9,  2, 1,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PDY")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PDZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PDZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtPH2PSYLd")   2, false, false, false, 69, 11,  3, 1,  0, 0}, // #395
  {DBGFIELD("WriteCvtPH2PSY")     2, false, false, false, 313, 12, 13, 1,  0, 0}, // #396
  {DBGFIELD("WriteCvtPH2PSLd")    2, false, false, false, 69, 11,  3, 1,  0, 0}, // #397
  {DBGFIELD("WriteCvtPH2PS")      2, false, false, false, 313, 12, 13, 1,  0, 0}, // #398
  {DBGFIELD("WriteCvtPH2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteCvtPH2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD("WriteCvtPS2PHYSt")   3, false, false, false, 2510, 10,  6, 1,  0, 0}, // #401
  {DBGFIELD("WriteCvtPS2PHY")     2, false, false, false, 453, 11,  3, 1,  0, 0}, // #402
  {DBGFIELD("WriteCvtPS2PHSt")    3, false, false, false, 2510, 10, 14, 1,  0, 0}, // #403
  {DBGFIELD("WriteCvtPS2PH")      2, false, false, false, 453, 11,  8, 1,  0, 0}, // #404
  {DBGFIELD("WriteCvtPS2PHZSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteCvtPS2PHZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #406
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #407
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #408
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 2, false, false, false, 69, 11, 18, 1,  5, 1}, // #409
  {DBGFIELD("WritePSADBWY")       1, false, false, false, 40, 9, 14, 1,  0, 0}, // #410
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WritePSADBWZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #412
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 4, false, false, false, 2520, 12, 15, 1,  5, 1}, // #413
  {DBGFIELD("WriteFDiv64Y")       3, false, false, false, 2532, 10, 36, 1,  0, 0}, // #414
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WriteFDiv64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 4, false, false, false, 2542, 12, 36, 1,  5, 1}, // #417
  {DBGFIELD("WriteFDivY")         3, false, false, false, 2554, 10, 17, 1,  0, 0}, // #418
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteFDivZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #420
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1,  3, 1}, // #421
  {DBGFIELD("WriteFMAX")          1, false, false, false, 65, 4, 14, 1,  0, 0}, // #422
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1,  5, 1}, // #423
  {DBGFIELD("WriteFMAY")          1, false, false, false, 65, 4, 14, 1,  0, 0}, // #424
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteFMAZ")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #426
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 5, false, false, false, 2365, 16, 12, 1,  5, 1}, // #427
  {DBGFIELD("WriteDPPSY")         4, false, false, false, 2381, 14, 10, 1,  0, 0}, // #428
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #429
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1, 14, 2}, // #430
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1, 16, 2}, // #431
  {DBGFIELD("WriteFMALd_ReadAfterVecLd") 2, false, false, false, 59, 6,  7, 1,  3, 1}, // #432
  {DBGFIELD("WriteFMA")           1, false, false, false, 65, 4, 14, 1,  0, 0}, // #433
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 2, false, false, false, 59, 6,  7, 1, 16, 2}, // #434
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1, 10, 2}, // #435
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1,  3, 2}, // #436
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 2, false, false, false, 59, 6,  7, 1,  3, 2}, // #437
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 3, false, false, false, 2446, 9, 23, 1,  5, 1}, // #438
  {DBGFIELD("WriteFRndY")         1, false, false, false, 37, 3,  3, 1,  0, 0}, // #439
  {DBGFIELD("WriteLoad_WriteVecMaskedGatherWriteback") 1, false, false, false, 37, 3, 38, 2,  0, 0}, // #440
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteFRndZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 2, false, false, false, 69, 11, 18, 1,  5, 1}, // #443
  {DBGFIELD("WriteVecIMulY")      1, false, false, false, 40, 9, 14, 1,  0, 0}, // #444
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #445
  {DBGFIELD("WriteVecIMulZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 2, false, false, false, 148, 6,  6, 1,  5, 1}, // #447
  {DBGFIELD("WriteVecALUY")       1, false, false, false, 154, 4,  1, 1,  0, 0}, // #448
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("WriteVecALUZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #450
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 4, false, false, false, 2400, 13, 18, 1,  5, 1}, // #451
  {DBGFIELD("WriteFHAddY")        3, false, false, false, 2413, 11, 14, 1,  0, 0}, // #452
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #453
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #454
  {DBGFIELD("WriteVecLoadY")      1, false, false, false, 37, 3,  3, 1,  0, 0}, // #455
  {DBGFIELD("WriteFMaskedStore64Y") 4, false, false, false, 2564, 12, 14, 1,  0, 0}, // #456
  {DBGFIELD("WriteFMaskedLoadY")  3, false, false, false, 531, 10,  2, 1,  0, 0}, // #457
  {DBGFIELD("WriteFMaskedStore64") 4, false, false, false, 2564, 12, 14, 1,  0, 0}, // #458
  {DBGFIELD("WriteFMaskedLoad")   3, false, false, false, 531, 10,  6, 1,  0, 0}, // #459
  {DBGFIELD("WriteFMaskedStore32Y") 4, false, false, false, 2564, 12, 14, 1,  0, 0}, // #460
  {DBGFIELD("WriteFMaskedStore32") 4, false, false, false, 2564, 12, 14, 1,  0, 0}, // #461
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #462
  {DBGFIELD("WriteFCmp64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #463
  {DBGFIELD("WriteFMoveY")        1, false, false, false, 474, 8,  1, 1,  0, 0}, // #464
  {DBGFIELD("WriteFMoveZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #465
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, false, 464, 10,  6, 1,  0, 0}, // #466
  {DBGFIELD("WriteFShuffleY")     1, false, false, false, 474, 8,  1, 1,  0, 0}, // #467
  {DBGFIELD("WriteFShuffleZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteFShuffleZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #469
  {DBGFIELD("WriteVecStoreY")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #470
  {DBGFIELD("WriteVecMoveY")      1, false, false, false, 30, 3,  1, 1,  0, 0}, // #471
  {DBGFIELD("WriteVecMoveZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #472
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, false, 37, 3,  3, 1,  0, 0}, // #473
  {DBGFIELD("WriteVecStoreNTY")   2, false, false, false, 33, 4,  1, 1,  0, 0}, // #474
  {DBGFIELD("WriteFStoreNTY")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #475
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 4, false, false, false, 1482, 14, 22, 1,  5, 1}, // #476
  {DBGFIELD("WriteMPSADY")        3, false, false, false, 1470, 12,  6, 1,  0, 0}, // #477
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 2, false, false, false, 59, 6,  9, 1,  5, 1}, // #478
  {DBGFIELD("WriteFMul64Y")       1, false, false, false, 65, 4,  5, 1,  0, 0}, // #479
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteFMul64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6,  9, 1,  5, 1}, // #482
  {DBGFIELD("WriteFMulY")         1, false, false, false, 65, 4,  5, 1,  0, 0}, // #483
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #484
  {DBGFIELD("WriteFMulZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #485
  {DBGFIELD("WriteVecALUYLd")     2, false, false, false, 148, 6,  6, 1,  0, 0}, // #486
  {DBGFIELD("WriteVecALUZLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 2, false, false, false, 60, 5,  6, 1,  5, 1}, // #488
  {DBGFIELD("WriteVecLogicY")     1, false, false, false, 30, 3,  1, 1,  0, 0}, // #489
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteVecLogicZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #492
  {DBGFIELD("WriteBlendY")        1, false, false, false, 474, 8,  1, 1,  0, 0}, // #493
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 3, false, false, false, 531, 10,  2, 1,  5, 1}, // #494
  {DBGFIELD("WriteVarBlendY")     2, false, false, false, 523, 8, 13, 1,  0, 0}, // #495
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteVarBlendZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 3, false, false, false, 531, 10,  2, 1, 10, 2}, // #498
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, false, 531, 10,  6, 1,  3, 2}, // #499
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 464, 10,  6, 1, 10, 2}, // #500
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  6, 1, 14, 2}, // #501
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1,  3, 2}, // #502
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1, 16, 2}, // #503
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #504
  {DBGFIELD("WriteFVarShuffle256") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #505
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 464, 10,  6, 1, 10, 2}, // #506
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  6, 1, 14, 2}, // #507
  {DBGFIELD("WriteFVarShuffleY")  1, false, false, false, 474, 8,  1, 1,  0, 0}, // #508
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1,  3, 2}, // #509
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1, 16, 2}, // #510
  {DBGFIELD("WriteFVarShuffle")   1, false, false, false, 474, 8,  1, 1,  0, 0}, // #511
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #512
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #513
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #514
  {DBGFIELD("WriteFVarShuffleZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #515
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 4, false, false, false, 2424, 10,  9, 1,  5, 1}, // #516
  {DBGFIELD("WritePHAddY")        3, false, false, false, 2434, 8,  5, 1,  0, 0}, // #517
  {DBGFIELD("WriteVecInsert")     2, false, false, false, 523, 8, 13, 1,  0, 0}, // #518
  {DBGFIELD("WriteVecIMulXLd")    2, false, false, false, 69, 11,  7, 1,  0, 0}, // #519
  {DBGFIELD("WriteVecIMulYLd")    2, false, false, false, 69, 11, 18, 1,  0, 0}, // #520
  {DBGFIELD("WriteVecIMulZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #521
  {DBGFIELD("WriteVecMaskedStore32Y") 4, false, false, false, 2564, 12, 14, 1,  0, 0}, // #522
  {DBGFIELD("WriteVecMaskedLoadY") 3, false, false, false, 531, 10,  2, 1,  0, 0}, // #523
  {DBGFIELD("WriteVecMaskedStore32") 4, false, false, false, 2564, 12, 14, 1,  0, 0}, // #524
  {DBGFIELD("WriteVecMaskedLoad") 3, false, false, false, 531, 10,  6, 1,  0, 0}, // #525
  {DBGFIELD("WriteVecMaskedStore64Y") 4, false, false, false, 2564, 12, 14, 1,  0, 0}, // #526
  {DBGFIELD("WriteVecMaskedStore64") 4, false, false, false, 2564, 12, 14, 1,  0, 0}, // #527
  {DBGFIELD("WriteVPMOV256Ld")    2, false, false, false, 464, 10,  9, 1,  0, 0}, // #528
  {DBGFIELD("WriteVPMOV256")      1, false, false, false, 474, 8,  5, 1,  0, 0}, // #529
  {DBGFIELD("WriteVecMOVMSKY")    1, false, false, false, 40, 9,  5, 1,  0, 0}, // #530
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 3, false, false, false, 80, 11, 19, 1,  5, 1}, // #531
  {DBGFIELD("WritePMULLDY")       2, false, false, false, 91, 9,  7, 1,  0, 0}, // #532
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WritePMULLDZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #534
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1,  3, 2}, // #535
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1, 16, 2}, // #536
  {DBGFIELD("WriteVecShiftImmXLd") 2, false, false, false, 69, 11,  3, 1,  0, 0}, // #537
  {DBGFIELD("WriteVecShiftImmYLd") 2, false, false, false, 69, 11,  6, 1,  0, 0}, // #538
  {DBGFIELD("WriteVecShiftImmY")  1, false, false, false, 40, 9,  1, 1,  0, 0}, // #539
  {DBGFIELD("WriteVecShiftImmZLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #540
  {DBGFIELD("WriteVecShiftImmZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #541
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 4, false, false, false, 2576, 14,  2, 1,  3, 1}, // #542
  {DBGFIELD("WriteVarVecShift")   3, false, false, false, 2590, 12,  5, 1,  0, 0}, // #543
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 4, false, false, false, 2576, 14,  9, 1,  5, 1}, // #544
  {DBGFIELD("WriteVarVecShiftY")  3, false, false, false, 2590, 12,  5, 1,  0, 0}, // #545
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #546
  {DBGFIELD("WriteVarVecShiftZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #547
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  3, 1,  3, 1}, // #548
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #549
  {DBGFIELD("WriteVarShuffleY")   1, false, false, false, 474, 8,  1, 1,  0, 0}, // #550
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #551
  {DBGFIELD("WriteVarShuffleZ")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #552
  {DBGFIELD("WriteShuffleZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #553
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 2, false, false, false, 69, 11,  6, 1,  5, 1}, // #554
  {DBGFIELD("WriteVecShiftY")     2, false, false, false, 313, 12,  8, 1,  0, 0}, // #555
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteVecShiftZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 3, false, false, false, 655, 14,  7, 1,  5, 1}, // #558
  {DBGFIELD("WriteVecTestY")      2, false, false, false, 313, 12,  8, 1,  0, 0}, // #559
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #560
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 4, false, false, false, 2521, 11, 17, 1,  5, 1}, // #561
  {DBGFIELD("WriteFRcpY")         3, false, false, false, 2533, 9, 18, 1,  0, 0}, // #562
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #563
  {DBGFIELD("WriteFRcpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #564
  {DBGFIELD("WriteFRcpYLd")       4, false, false, false, 2521, 11, 17, 1,  0, 0}, // #565
  {DBGFIELD("WriteFRndYLd")       3, false, false, false, 2446, 9, 23, 1,  0, 0}, // #566
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #567
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 4, false, false, false, 2521, 11, 17, 1,  5, 1}, // #568
  {DBGFIELD("WriteFRsqrtY")       3, false, false, false, 2533, 9, 18, 1,  0, 0}, // #569
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #570
  {DBGFIELD("WriteFRsqrtZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #571
  {DBGFIELD("WriteFRsqrtYLd")     4, false, false, false, 2521, 11, 17, 1,  0, 0}, // #572
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #573
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #574
  {DBGFIELD("WriteFSqrt64YLd")    4, false, false, false, 2602, 12, 42, 1,  0, 0}, // #575
  {DBGFIELD("WriteFSqrt64Y")      3, false, false, false, 2614, 10, 15, 1,  0, 0}, // #576
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 2, false, false, false, 2466, 12, 37, 1,  3, 1}, // #577
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 4, false, false, false, 2602, 12, 42, 1,  5, 1}, // #578
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #579
  {DBGFIELD("WriteFSqrt64Z")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #580
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 2, false, false, false, 2488, 12, 19, 1,  3, 1}, // #581
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 4, false, false, false, 2624, 12, 46, 1,  5, 1}, // #582
  {DBGFIELD("WriteFSqrtY")        3, false, false, false, 2636, 10, 37, 1,  0, 0}, // #583
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #584
  {DBGFIELD("WriteFSqrtZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #585
  {DBGFIELD("WriteFSqrtYLd")      4, false, false, false, 2624, 12, 46, 1,  0, 0}, // #586
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 2, false, false, false, 69, 11,  6, 1,  5, 1}, // #587
  {DBGFIELD("WriteFTestY")        1, false, false, false, 40, 9,  1, 1,  0, 0}, // #588
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  3, 1,  3, 1}, // #589
  {DBGFIELD("WriteFTest")         1, false, false, false, 40, 9,  1, 1,  0, 0}, // #590
  {DBGFIELD("WriteALULd_WriteRMW") 3, false, false, false, 49, 6, 32, 2,  0, 0}, // #591
  {DBGFIELD("WriteXCHG")          3, false, false, false, 280, 2, 13, 1,  0, 0}, // #592
  {DBGFIELD("COPY")               1, false, false, false,  1, 2,  1, 1,  0, 0}, // #593
  {DBGFIELD("XAM_F")              1, false, false, false, 40, 9,  1, 1,  0, 0}, // #594
  {DBGFIELD("LD_Frr")             1, false, false, false,  1, 2,  1, 1,  0, 0}, // #595
  {DBGFIELD("MOVSX64rr32")        1, false, false, false,  1, 2,  1, 1,  0, 0}, // #596
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 5, false, false, false, 823, 6,  2, 1,  0, 0}, // #597
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 11, false, false, false, 2646, 11, 31, 1,  0, 0}, // #598
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 4, false, false, false, 167, 8,  3, 1,  0, 0}, // #599
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 6, false, false, false, 12, 8,  2, 1,  0, 0}, // #600
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #601
  {DBGFIELD("FCOMPP")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #602
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #603
  {DBGFIELD("MMX_CVTPI2PSrr")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #604
  {DBGFIELD("MMX_CVTPI2PSrm")     2, false, false, false, 158, 9,  2, 1,  0, 0}, // #605
  {DBGFIELD("MMX_CVTPS2PIrr_MMX_CVTTPS2PIrr") 2, false, false, false, 453, 11,  8, 1,  0, 0}, // #606
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 2, false, false, false, 55, 4,  3, 1,  0, 0}, // #607
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #608
  {DBGFIELD("XCH_F")              12, false, false, false, 2657, 14, 10, 1,  0, 0}, // #609
  {DBGFIELD("RETI16_RETI32_RETI64_IRET_IRET16_IRET32_IRET64") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #610
  {DBGFIELD("MMX_CVTPS2PIrm_MMX_CVTTPS2PIrm") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #611
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 2, false, false, false, 158, 9,  9, 1,  0, 0}, // #612
  {DBGFIELD("CVTSI642SDrm")       2, false, false, false, 158, 9,  9, 1,  0, 0}, // #613
  {DBGFIELD("CVTSI642SDrm_Int")   2, false, false, false, 158, 9,  9, 1,  3, 1}, // #614
  {DBGFIELD("CVTSI642SSrr")       3, false, false, false, 2413, 11, 14, 1,  0, 0}, // #615
  {DBGFIELD("CVTSI642SSrr_Int")   3, false, false, false, 2413, 11, 14, 1,  0, 0}, // #616
  {DBGFIELD("CVTSI642SSrm")       2, false, false, false, 158, 9,  9, 1,  0, 0}, // #617
  {DBGFIELD("CVTSI642SSrm_Int")   2, false, false, false, 158, 9,  9, 1,  3, 1}, // #618
  {DBGFIELD("CVTSS2SI64rr_CVTTSS2SI64rr") 2, false, false, false, 2671, 12,  8, 1,  0, 0}, // #619
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 2, false, false, false, 2671, 12,  8, 1,  0, 0}, // #620
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 4, false, false, false, 2335, 16,  7, 1,  0, 0}, // #621
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 2, false, false, false, 98, 2, 13, 1,  0, 0}, // #622
  {DBGFIELD("LFENCE")             2, false, false, false, 98, 2, 13, 1,  0, 0}, // #623
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #624
  {DBGFIELD("LEAVE_LEAVE64")      3, false, false, false, 881, 4,  6, 1,  0, 0}, // #625
  {DBGFIELD("POP16r")             2, false, false, false, 55, 4,  3, 1,  0, 0}, // #626
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 4, false, false, false, 49, 6,  3, 1,  0, 0}, // #627
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #628
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #629
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #630
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, false,  1, 2,  1, 1,  0, 0}, // #631
  {DBGFIELD("MMX_PADDQrr_MMX_PSUBQrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #632
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #633
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64_MASKMOVDQUX32") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #634
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  2, false, false, false, 33, 4,  1, 1,  0, 0}, // #635
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, false, 154, 4,  1, 1,  0, 0}, // #636
  {DBGFIELD("CLD")                3, false, false, false, 885, 7,  5, 1,  0, 0}, // #637
  {DBGFIELD("LDDQUrm")            1, false, false, false, 37, 3, 14, 1,  0, 0}, // #638
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #639
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 4, false, false, false, 49, 6,  3, 1,  0, 0}, // #640
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 6, false, false, false, 2683, 6,  2, 1,  0, 0}, // #641
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, false, 2434, 8,  5, 1,  0, 0}, // #642
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #643
  {DBGFIELD("MMX_PADDQrm_MMX_PSUBQrm") 2, false, false, false, 148, 6,  3, 1,  3, 1}, // #644
  {DBGFIELD("MOVDQUrm")           1, false, false, false, 37, 3, 14, 1,  0, 0}, // #645
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, false, 37, 3, 14, 1,  0, 0}, // #646
  {DBGFIELD("PADDQrm_PSUBQrm")    2, false, false, false, 148, 6,  3, 1,  3, 1}, // #647
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #648
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   2, false, false, false, 903, 4, 13, 1,  0, 0}, // #649
  {DBGFIELD("LD_F80m")            1, false, false, false, 37, 3,  3, 1,  0, 0}, // #650
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, false, 2424, 10,  2, 1,  3, 1}, // #651
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 2, false, false, false, 313, 12, 13, 1,  0, 0}, // #652
  {DBGFIELD("FLDCW16m")           3, false, false, false, 1195, 11,  6, 1,  0, 0}, // #653
  {DBGFIELD("ST_FP80m")           2, false, false, false, 33, 4,  1, 1,  0, 0}, // #654
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, false, 2434, 8,  5, 1,  0, 0}, // #655
  {DBGFIELD("CMPXCHG8rm")         6, false, false, false, 12, 8,  2, 1,  0, 0}, // #656
  {DBGFIELD("INTO")               1, false, false, false,  1, 2,  4, 1,  0, 0}, // #657
  {DBGFIELD("XLAT")               1, false, false, false, 37, 3, 14, 1,  0, 0}, // #658
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 4, false, false, false, 395, 9,  3, 1,  0, 0}, // #659
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #660
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 6, false, false, false, 2455, 11, 18, 1,  0, 0}, // #661
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 4, false, false, false, 699, 9,  9, 1,  0, 0}, // #662
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 3, false, false, false, 2510, 10,  8, 1,  0, 0}, // #663
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, false, 2424, 10,  2, 1,  3, 1}, // #664
  {DBGFIELD("AAD8i8")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #665
  {DBGFIELD("LOOPE")              11, false, false, false, 918, 4, 18, 1,  0, 0}, // #666
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, false, 33, 4,  1, 1,  0, 0}, // #667
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 4, false, false, false, 395, 9,  3, 1,  0, 0}, // #668
  {DBGFIELD("FNSTCW16m")          3, false, false, false, 922, 10, 13, 1,  0, 0}, // #669
  {DBGFIELD("POPA16_POPA32")      1, false, false, false, 37, 3, 14, 1,  0, 0}, // #670
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #671
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 6, false, false, false, 2455, 11, 18, 1,  0, 0}, // #672
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 4, false, false, false, 699, 9,  9, 1,  0, 0}, // #673
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #674
  {DBGFIELD("CMPXCHG8rr")         5, false, false, false, 175, 4, 14, 1,  0, 0}, // #675
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #676
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #677
  {DBGFIELD("AAA_AAS")            1, false, false, false,  1, 2,  4, 1,  0, 0}, // #678
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 6, false, false, false, 12, 8,  2, 1,  0, 0}, // #679
  {DBGFIELD("LOOPNE")             11, false, false, false, 918, 4, 18, 1,  0, 0}, // #680
  {DBGFIELD("PAUSE")              5, false, false, false, 2689, 7, 14, 1,  0, 0}, // #681
  {DBGFIELD("CMPXCHG8B")          14, false, false, false, 939, 10, 19, 1,  0, 0}, // #682
  {DBGFIELD("DAA")                1, false, false, false,  1, 2,  4, 1,  0, 0}, // #683
  {DBGFIELD("LOOP")               7, false, false, false, 2696, 9,  6, 1,  0, 0}, // #684
  {DBGFIELD("DAS")                1, false, false, false,  1, 2,  4, 1,  0, 0}, // #685
  {DBGFIELD("AAM8i8")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #686
  {DBGFIELD("STD")                6, false, false, false, 958, 7,  3, 1,  0, 0}, // #687
  {DBGFIELD("CMPXCHG16B")         19, false, false, false, 965, 15, 37, 1,  0, 0}, // #688
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, false,  1, 2,  4, 1,  0, 0}, // #689
  {DBGFIELD("FNCLEX_FXTRACT")     4, false, false, false, 300, 2,  8, 1,  0, 0}, // #690
  {DBGFIELD("POPF32_POPF64")      1, false, false, false, 37, 3, 14, 1,  0, 0}, // #691
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #692
  {DBGFIELD("RDTSC_RDTSCP")       22, false, false, false, 980, 8, 40, 1,  0, 0}, // #693
  {DBGFIELD("ENTER")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #694
  {DBGFIELD("POPF16")             1, false, false, false, 37, 3, 14, 1,  0, 0}, // #695
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #696
  {DBGFIELD("FRNDINT")            1, false, false, false,  1, 2,  4, 1,  0, 0}, // #697
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false, false,  1, 2,  4, 1,  0, 0}, // #698
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, false,  1, 2,  4, 1,  0, 0}, // #699
  {DBGFIELD("FPREM")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #700
  {DBGFIELD("INSB_INSL_INSW")     8, false, false, false, 999, 15, 12, 1,  0, 0}, // #701
  {DBGFIELD("FNINIT")             15, false, false, false, 2705, 9, 41, 1,  0, 0}, // #702
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 23, false, false, false, 1022, 13, 42, 1,  0, 0}, // #703
  {DBGFIELD("FPREM1")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #704
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #705
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 23, false, false, false, 1022, 13, 42, 1,  0, 0}, // #706
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, false,  1, 2,  4, 1,  0, 0}, // #707
  {DBGFIELD("FSCALE")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #708
  {DBGFIELD("RDMSR")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #709
  {DBGFIELD("RET_RET16_RET32_RET64_LRET16_LRET32_LRET64_LRETI16_LRETI32_LRETI64") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #710
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 23, false, false, false, 1035, 13, 58, 1,  0, 0}, // #711
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 23, false, false, false, 1035, 13, 58, 1,  0, 0}, // #712
  {DBGFIELD("F2XM1")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #713
  {DBGFIELD("CPUID")              8, false, false, false, 1048, 11, 31, 1,  0, 0}, // #714
  {DBGFIELD("INT")                1, false, false, false,  1, 2,  4, 1,  0, 0}, // #715
  {DBGFIELD("INT3")               1, false, false, false,  1, 2,  4, 1,  0, 0}, // #716
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, false,  1, 2,  4, 1,  0, 0}, // #717
  {DBGFIELD("FXRSTOR_FXRSTOR64")  90, false, false, false, 1059, 15, 43, 1,  0, 0}, // #718
  {DBGFIELD("FYL2X")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #719
  {DBGFIELD("FYL2XP1")            1, false, false, false,  1, 2,  4, 1,  0, 0}, // #720
  {DBGFIELD("FPTAN")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #721
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, false,  1, 2,  4, 1,  0, 0}, // #722
  {DBGFIELD("FPATAN")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #723
  {DBGFIELD("WRMSR")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #724
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, false, 26, 7,  1, 1,  0, 0}, // #725
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, false, 26, 7,  1, 1,  0, 0}, // #726
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 2, false, false, false, 637, 4, 13, 1,  0, 0}, // #727
  {DBGFIELD("FNOP")               1, false, false, false, 65, 4,  1, 1,  0, 0}, // #728
  {DBGFIELD("RET64")              3, false, false, false, 1074, 9,  6, 1,  0, 0}, // #729
  {DBGFIELD("CDQ_CQO")            1, false, false, false,  8, 4,  1, 1,  0, 0}, // #730
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #731
  {DBGFIELD("MMX_PADDQrr")        1, false, false, false, 154, 4,  1, 1,  0, 0}, // #732
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, false, 474, 8,  1, 1,  0, 0}, // #733
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 3, false, false, false, 881, 4,  6, 1,  0, 0}, // #734
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int_VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #735
  {DBGFIELD("CWD")                2, false, false, false, 903, 4, 13, 1,  0, 0}, // #736
  {DBGFIELD("FNSTSW16r")          2, false, false, false, 1083, 9,  8, 1,  0, 0}, // #737
  {DBGFIELD("MMX_MOVDQ2Qrr")      2, false, false, false, 2714, 4, 13, 1,  0, 0}, // #738
  {DBGFIELD("PUSHFS64")           1, false, false, false,  1, 2,  4, 1,  0, 0}, // #739
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 2, false, false, false, 313, 12, 13, 1,  0, 0}, // #740
  {DBGFIELD("RCL16r1_RCL32r1_RCL64r1_RCL8r1_RCR16r1_RCR32r1_RCR64r1_RCR8r1") 3, false, false, false, 1092, 4,  5, 1,  0, 0}, // #741
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #742
  {DBGFIELD("MOV64sr")            1, false, false, false,  1, 2,  1, 1,  0, 0}, // #743
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVSX32rm16_MOVSX32rm32_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #744
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 10, false, false, false, 2718, 9, 10, 1,  0, 0}, // #745
  {DBGFIELD("RCL16ri_RCL32ri_RCL64ri_RCL8ri_RCR16ri_RCR32ri_RCR64ri_RCR8ri") 3, false, false, false, 1092, 4,  5, 1,  0, 0}, // #746
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 3, false, false, false, 1105, 5, 13, 1,  0, 0}, // #747
  {DBGFIELD("CLI")                1, false, false, false,  1, 2,  4, 1,  0, 0}, // #748
  {DBGFIELD("PUSHGS64")           1, false, false, false,  1, 2,  4, 1,  0, 0}, // #749
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 3, false, false, false, 2510, 10,  8, 1,  0, 0}, // #750
  {DBGFIELD("CALL64pcrel32")      4, false, false, false, 1110, 7,  5, 1,  0, 0}, // #751
  {DBGFIELD("CALL64r_RVMARKER_CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 4, false, false, false, 1117, 10,  5, 1,  0, 0}, // #752
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 3, false, false, false, 302, 11, 13, 1,  0, 0}, // #753
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 3, false, false, false, 1105, 5, 13, 1,  0, 0}, // #754
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 3, false, false, false, 302, 11, 13, 1,  0, 0}, // #755
  {DBGFIELD("PUSHF16_PUSHF64")    6, false, false, false, 1127, 5, 14, 1,  0, 0}, // #756
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 2, false, false, false, 1132, 7, 13, 1,  0, 0}, // #757
  {DBGFIELD("MMX_MOVD64from64rm") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #758
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, false, 37, 3, 14, 1,  0, 0}, // #759
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #760
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #761
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #762
  {DBGFIELD("MOV16sm")            1, false, false, false,  1, 2,  1, 1,  0, 0}, // #763
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 2, false, false, false, 148, 6,  3, 1,  0, 0}, // #764
  {DBGFIELD("MMX_PALIGNRrmi")     2, false, false, false, 464, 10,  3, 1,  3, 1}, // #765
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 2, false, false, false, 148, 6,  3, 1,  3, 1}, // #766
  {DBGFIELD("LODSL_LODSQ")        1, false, false, false,  1, 2,  4, 1,  0, 0}, // #767
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #768
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #769
  {DBGFIELD("VINSERTF128rm")      2, false, false, false, 60, 5,  3, 1,  0, 0}, // #770
  {DBGFIELD("MMX_PADDQrm")        2, false, false, false, 148, 6,  3, 1,  3, 1}, // #771
  {DBGFIELD("VERRm_VERWm")        1, false, false, false,  1, 2,  4, 1,  0, 0}, // #772
  {DBGFIELD("FARJMP64m")          2, false, false, false, 1139, 9,  3, 1,  0, 0}, // #773
  {DBGFIELD("FNSTSWm")            3, false, false, false, 1148, 11,  8, 1,  0, 0}, // #774
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 4, false, false, false, 1159, 11,  3, 1,  0, 0}, // #775
  {DBGFIELD("CALL64m_RVMARKER_CALL64m_CALL64m_NT") 5, false, false, false, 1170, 11,  6, 1,  0, 0}, // #776
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 5, false, false, false, 1170, 11,  6, 1,  0, 0}, // #777
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int_VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #778
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #779
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 5, false, false, false, 1181, 8,  6, 1,  0, 0}, // #780
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 5, false, false, false, 1189, 6,  6, 1,  0, 0}, // #781
  {DBGFIELD("FARCALL64m")         5, false, false, false, 1170, 11,  6, 1,  0, 0}, // #782
  {DBGFIELD("CVTSD2SI64rm_CVTSD2SI64rm_Int_CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 3, false, false, false, 2727, 14,  9, 1,  0, 0}, // #783
  {DBGFIELD("CVTSS2SIrm_CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 3, false, false, false, 2727, 14,  9, 1,  0, 0}, // #784
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, false, 37, 3,  3, 1,  0, 0}, // #785
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 6, false, false, false, 12, 8,  2, 1,  0, 0}, // #786
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 6, false, false, false, 12, 8,  2, 1,  1, 2}, // #787
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 2, false, false, false, 158, 9,  9, 1,  0, 0}, // #788
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 2, false, false, false, 69, 11,  7, 1,  0, 0}, // #789
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 3, false, false, false, 2446, 9,  7, 1,  0, 0}, // #790
  {DBGFIELD("MUL_F32m_MUL_F64m")  2, false, false, false, 69, 11, 18, 1,  0, 0}, // #791
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 3, false, false, false, 2446, 9, 23, 1,  0, 0}, // #792
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 3, false, false, false, 2727, 14, 10, 1,  0, 0}, // #793
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 2, false, false, false, 69, 11, 37, 1,  0, 0}, // #794
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 3, false, false, false, 2727, 14, 30, 1,  0, 0}, // #795
  {DBGFIELD("VZEROALL")           20, false, false, false, 2741, 11,  2, 1,  0, 0}, // #796
  {DBGFIELD("VZEROUPPER")         4, false, false, false,  0, 0,  0, 1,  0, 0}, // #797
  {DBGFIELD("CLC")                1, false, false, false,  0, 0,  1, 1,  0, 0}, // #798
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #799
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #800
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #801
  {DBGFIELD("PXORrr_VPXORrr")     8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #802
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #803
  {DBGFIELD("PSUBQrr")            8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #804
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #805
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #806
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #807
  {DBGFIELD("SETCCr")             8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #808
  {DBGFIELD("SETCCm")             8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #809
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #810
  {DBGFIELD("RETI16_RETI32_RETI64") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #811
  {DBGFIELD("LRETI16_LRETI32_LRETI64") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #812
  {DBGFIELD("RDPMC")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #813
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 5, false, false, false, 2752, 6,  9, 1,  0, 0}, // #814
  {DBGFIELD("FBLDm")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #815
  {DBGFIELD("FFREE_FFREEP")       1, false, false, false,  1, 2,  4, 1,  0, 0}, // #816
  {DBGFIELD("FSAVEm")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #817
  {DBGFIELD("FRSTORm")            1, false, false, false,  1, 2,  4, 1,  0, 0}, // #818
  {DBGFIELD("FXTRACT")            1, false, false, false,  1, 2,  4, 1,  0, 0}, // #819
  {DBGFIELD("MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #820
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #821
  {DBGFIELD("VBROADCASTF128")     1, false, false, false, 37, 3,  3, 1,  0, 0}, // #822
  {DBGFIELD("VBROADCASTI128")     1, false, false, false, 37, 3,  3, 1,  0, 0}, // #823
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #824
  {DBGFIELD("FBSTPm")             2, false, false, false, 33, 4,  1, 1,  0, 0}, // #825
  {DBGFIELD("VMPTRSTm")           1, false, false, false,  1, 2,  4, 1,  0, 0}, // #826
  {DBGFIELD("ST_FP32m_ST_FP64m")  2, false, false, false, 33, 4,  1, 1,  0, 0}, // #827
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 1, false, false, false, 40, 9,  1, 1,  0, 0}, // #828
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 1, false, false, false, 40, 9,  1, 1,  0, 0}, // #829
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false, false, 474, 8,  1, 1,  0, 0}, // #830
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, false, 1208, 7,  1, 1,  0, 0}, // #831
  {DBGFIELD("FINCSTP")            1, false, false, false, 65, 4,  1, 1,  0, 0}, // #832
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, false, 154, 4,  1, 1,  0, 0}, // #833
  {DBGFIELD("VPBLENDDYrri")       1, false, false, false, 30, 3,  1, 1,  0, 0}, // #834
  {DBGFIELD("VPBLENDDrri")        1, false, false, false, 30, 3,  1, 1,  0, 0}, // #835
  {DBGFIELD("CMC_STC")            1, false, false, false,  1, 2,  1, 1,  0, 0}, // #836
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #837
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 2, false, false, false, 69, 11,  3, 1,  0, 0}, // #838
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 2, false, false, false, 69, 11,  3, 1,  0, 0}, // #839
  {DBGFIELD("CVTSS2SDrm")         2, false, false, false, 69, 11,  3, 1,  0, 0}, // #840
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 2, false, false, false, 69, 11,  3, 1,  0, 0}, // #841
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 2, false, false, false, 69, 11,  6, 1,  0, 0}, // #842
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #843
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 2, false, false, false, 464, 10,  3, 1,  0, 0}, // #844
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 2, false, false, false, 464, 10,  2, 1,  0, 0}, // #845
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 2, false, false, false, 1139, 9,  3, 1,  0, 0}, // #846
  {DBGFIELD("ANDN32rm_ANDN64rm")  2, false, false, false, 148, 6,  3, 1,  0, 0}, // #847
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 2, false, false, false, 148, 6,  3, 1,  0, 0}, // #848
  {DBGFIELD("VINSERTI128rm")      2, false, false, false, 60, 5,  3, 1,  0, 0}, // #849
  {DBGFIELD("VPBLENDDrmi")        2, false, false, false, 60, 5,  3, 1,  0, 0}, // #850
  {DBGFIELD("VPBLENDDYrmi")       2, false, false, false, 60, 5,  6, 1,  0, 0}, // #851
  {DBGFIELD("POP32r_POP64r")      2, false, false, false, 55, 4,  3, 1,  0, 0}, // #852
  {DBGFIELD("SFENCE")             2, false, false, false, 23, 3, 13, 1,  0, 0}, // #853
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 3, false, false, false, 1215, 7, 13, 1,  0, 0}, // #854
  {DBGFIELD("MOVBE16mr")          3, false, false, false, 1215, 7, 13, 1,  0, 0}, // #855
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 3, false, false, false, 1105, 5, 13, 1,  0, 0}, // #856
  {DBGFIELD("MFENCE")             2, false, false, false, 98, 2, 13, 1,  0, 0}, // #857
  {DBGFIELD("XGETBV")             2, false, false, false, 98, 2, 13, 1,  0, 0}, // #858
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 2, false, false, false, 313, 12, 13, 1,  0, 0}, // #859
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 2, false, false, false, 313, 12, 13, 1,  0, 0}, // #860
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm_MMX_PACKUSWBrm") 3, false, false, false, 531, 10,  6, 1,  0, 0}, // #861
  {DBGFIELD("LRET64_RET32")       2, false, false, false, 20, 6,  3, 1,  0, 0}, // #862
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 2, false, false, false, 1222, 4, 13, 1,  0, 0}, // #863
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #864
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #865
  {DBGFIELD("VCVTDQ2PSYrr")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #866
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #867
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #868
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, false, 158, 9,  9, 1,  0, 0}, // #869
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 2, false, false, false, 158, 9,  9, 1,  0, 0}, // #870
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 2, false, false, false, 464, 10,  2, 1,  0, 0}, // #871
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr_MMX_PACKUSWBrr") 3, false, false, false, 1226, 8,  5, 1,  0, 0}, // #872
  {DBGFIELD("CLDEMOTE")           3, false, false, false, 885, 7,  5, 1,  0, 0}, // #873
  {DBGFIELD("CVTSD2SI64rr_CVTSD2SIrr_CVTTSD2SI64rr_CVTTSD2SIrr_VCVTSD2SI64rr_VCVTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, false, 2671, 12,  8, 1,  0, 0}, // #874
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 2, false, false, false, 2671, 12,  8, 1,  0, 0}, // #875
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, false, 2671, 12,  8, 1,  0, 0}, // #876
  {DBGFIELD("CVTSS2SIrr_CVTTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 2, false, false, false, 2671, 12,  8, 1,  0, 0}, // #877
  {DBGFIELD("VCVTPS2PDYrr")       2, false, false, false, 313, 12,  8, 1,  0, 0}, // #878
  {DBGFIELD("MMX_CVTPI2PDrr")     2, false, false, false, 453, 11,  8, 1,  0, 0}, // #879
  {DBGFIELD("MMX_CVTPD2PIrr_MMX_CVTTPD2PIrr") 2, false, false, false, 453, 11,  8, 1,  0, 0}, // #880
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 2, false, false, false, 453, 11,  8, 1,  0, 0}, // #881
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 2, false, false, false, 453, 11,  8, 1,  0, 0}, // #882
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 2, false, false, false, 453, 11,  8, 1,  0, 0}, // #883
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 2, false, false, false, 453, 11,  8, 1,  0, 0}, // #884
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, false, 453, 11,  8, 1,  0, 0}, // #885
  {DBGFIELD("CVTSI2SSrr")         2, false, false, false, 453, 11,  8, 1,  0, 0}, // #886
  {DBGFIELD("CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 2, false, false, false, 453, 11,  8, 1,  0, 0}, // #887
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, false, 453, 11,  8, 1,  0, 0}, // #888
  {DBGFIELD("VCVTSD2SI64rm_VCVTSD2SI64rm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 3, false, false, false, 2727, 14,  9, 1,  0, 0}, // #889
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int") 3, false, false, false, 2727, 14,  9, 1,  0, 0}, // #890
  {DBGFIELD("VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, false, 2727, 14,  9, 1,  0, 0}, // #891
  {DBGFIELD("VCVTPS2PDYrm")       3, false, false, false, 655, 14,  9, 1,  0, 0}, // #892
  {DBGFIELD("CVTPD2PSrm")         3, false, false, false, 440, 13,  9, 1,  0, 0}, // #893
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIrm_MMX_CVTTPD2PIrm") 3, false, false, false, 440, 13,  9, 1,  0, 0}, // #894
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 3, false, false, false, 440, 13,  9, 1,  0, 0}, // #895
  {DBGFIELD("MMX_CVTPI2PDrm")     3, false, false, false, 440, 13,  9, 1,  0, 0}, // #896
  {DBGFIELD("CVTSD2SSrm")         3, false, false, false, 440, 13,  9, 1,  0, 0}, // #897
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_VCVTSD2SSrm_Int") 3, false, false, false, 440, 13,  9, 1,  0, 0}, // #898
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 3, false, false, false, 2758, 10,  9, 1,  0, 0}, // #899
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 8, false, false, false, 2768, 13, 10, 1,  0, 0}, // #900
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 5, false, false, false, 1265, 13,  9, 1,  0, 0}, // #901
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, false, 40, 9, 14, 1,  0, 0}, // #902
  {DBGFIELD("VPCMPGTQYrm")        2, false, false, false, 69, 11, 18, 1,  0, 0}, // #903
  {DBGFIELD("VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, false, 2413, 11, 14, 1,  0, 0}, // #904
  {DBGFIELD("STR16r_STR32r_STR64r") 3, false, false, false, 1278, 11, 14, 1,  0, 0}, // #905
  {DBGFIELD("XSETBV")             5, false, false, false, 1289, 4, 14, 1,  0, 0}, // #906
  {DBGFIELD("VCVTDQ2PDYrr")       2, false, false, false, 453, 11,  3, 1,  0, 0}, // #907
  {DBGFIELD("VCVTPD2PSYrr")       2, false, false, false, 453, 11,  3, 1,  0, 0}, // #908
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 2, false, false, false, 453, 11,  3, 1,  0, 0}, // #909
  {DBGFIELD("VCVTDQ2PDYrm")       3, false, false, false, 440, 13, 18, 1,  0, 0}, // #910
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 10, false, false, false, 2781, 11, 21, 1,  0, 0}, // #911
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 7, false, false, false, 2792, 9, 18, 1,  0, 0}, // #912
  {DBGFIELD("RCL8rCL")            9, false, false, false, 2801, 9, 18, 1,  0, 0}, // #913
  {DBGFIELD("RDTSC")              8, false, false, false, 1048, 11, 31, 1,  0, 0}, // #914
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 19, false, false, false, 2810, 9, 36, 1,  0, 0}, // #915
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, false, 40, 9, 12, 1,  0, 0}, // #916
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 2, false, false, false, 69, 11, 62, 1,  0, 0}, // #917
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 3, false, false, false, 2727, 14, 15, 1,  0, 0}, // #918
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, false, 40, 9, 21, 1,  0, 0}, // #919
  {DBGFIELD("XSAVE64")            27, false, false, false, 2819, 11, 15, 1,  0, 0}, // #920
  {DBGFIELD("XSAVE")              28, false, false, false, 2830, 11, 47, 1,  0, 0}, // #921
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 28, false, false, false, 2830, 11, 47, 1,  0, 0}, // #922
  {DBGFIELD("VMCLEARm")           1, false, false, false,  1, 2,  4, 1,  0, 0}, // #923
  {DBGFIELD("FLDENVm")            64, false, false, false, 2841, 11, 93, 1,  0, 0}, // #924
  {DBGFIELD("FXRSTOR64")          88, false, false, false, 1396, 15, 43, 1,  0, 0}, // #925
  {DBGFIELD("FSTENVm")            100, false, false, false, 2852, 17, 94, 1,  0, 0}, // #926
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm") 7, false, false, false, 2869, 12, 17, 1,  0, 0}, // #927
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 9, false, false, false, 2881, 12, 31, 1,  0, 0}, // #928
  {DBGFIELD("VGATHERDPSrm_VPGATHERDDrm") 10, false, false, false, 2893, 12, 20, 1,  0, 0}, // #929
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 14, false, false, false, 2905, 12, 37, 1,  0, 0}, // #930
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 7, false, false, false, 2869, 12, 17, 1,  0, 0}, // #931
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm_VGATHERQPSYrm_VPGATHERQDYrm") 10, false, false, false, 2893, 12, 20, 1,  0, 0}, // #932
  {DBGFIELD("VGATHERQPSrm_VPGATHERQDrm") 9, false, false, false, 2917, 12, 20, 1,  0, 0}, // #933
  {DBGFIELD("VPXORYrr")           8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #934
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #935
  {DBGFIELD("VPCMPGTQYrr")        8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #936
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, false,  8, 4,  1, 1,  0, 0}, // #937
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 2, false, false, false, 903, 4, 13, 1,  0, 0}, // #938
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 2, false, false, false, 158, 9,  6, 1,  0, 0}, // #939
  {DBGFIELD("LRET64")             3, false, false, false, 1074, 9,  6, 1,  0, 0}, // #940
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #941
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 3, false, false, false, 440, 13,  9, 1,  0, 0}, // #942
  {DBGFIELD("POPF64")             18, false, false, false, 2929, 9, 44, 1,  0, 0}, // #943
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 9, false, false, false, 2881, 12, 31, 1,  0, 0}, // #944
  {DBGFIELD("PCMPEQQrr")          1, false, false, false, 154, 4,  1, 1,  0, 0}, // #945
  {DBGFIELD("PCMPEQQrm")          2, false, false, false, 148, 6,  3, 1,  3, 1}, // #946
  {DBGFIELD("MOV16rm")            1, false, false, false, 37, 3, 14, 1,  0, 0}, // #947
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #948
  {DBGFIELD("POP16rmm")           4, false, false, false, 49, 6,  3, 1,  0, 0}, // #949
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 4, false, false, false, 49, 6,  3, 1,  0, 0}, // #950
  {DBGFIELD("PUSHF16")            6, false, false, false, 1127, 5, 14, 1,  0, 0}, // #951
  {DBGFIELD("LAHF")               1, false, false, false,  8, 4,  1, 1,  0, 0}, // #952
  {DBGFIELD("ADD16mi_ADD16mi8_ADD32mi_ADD32mi8_ADD64mi32_ADD64mi8_ADD8mi_ADD8mi8_SUB16mi_SUB16mi8_SUB32mi_SUB32mi8_SUB64mi32_SUB64mi8_SUB8mi_SUB8mi8") 3, false, false, false, 49, 6,  6, 1,  0, 0}, // #953
  {DBGFIELD("ADD16mr_ADD32mr_ADD64mr_ADD8mr_SUB16mr_SUB32mr_SUB64mr_SUB8mr") 3, false, false, false, 49, 6,  6, 1,  1, 1}, // #954
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 6, false, false, false, 12, 8,  2, 1,  0, 0}, // #955
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 3, false, false, false, 49, 6,  6, 1,  0, 0}, // #956
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 4, false, false, false, 1117, 10,  5, 1,  0, 0}, // #957
  {DBGFIELD("RET16_LRET16_LRET32") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #958
  {DBGFIELD("IRET16_IRET32_IRET64") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #959
  {DBGFIELD("AND16mi_AND16mi8_AND32mi_AND32mi8_AND64mi32_AND64mi8_AND8mi_AND8mi8_OR16mi_OR16mi8_OR32mi_OR32mi8_OR32mi8Locked_OR64mi32_OR64mi8_OR8mi_OR8mi8_XOR16mi_XOR16mi8_XOR32mi_XOR32mi8_XOR64mi32_XOR64mi8_XOR8mi_XOR8mi8") 3, false, false, false, 49, 6,  6, 1,  0, 0}, // #960
  {DBGFIELD("AND16mr_AND32mr_AND64mr_AND8mr_OR16mr_OR32mr_OR64mr_OR8mr_XOR16mr_XOR32mr_XOR64mr_XOR8mr") 3, false, false, false, 49, 6,  6, 1,  1, 1}, // #961
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 4, false, false, false, 699, 9,  9, 1,  0, 0}, // #962
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 4, false, false, false, 395, 9,  3, 1,  0, 0}, // #963
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 6, false, false, false, 2455, 11, 18, 1,  0, 0}, // #964
  {DBGFIELD("MOVSLDUPrm")         1, false, false, false, 37, 3, 14, 1,  0, 0}, // #965
  {DBGFIELD("MOVSLDUPrr")         1, false, false, false, 474, 8,  1, 1,  0, 0}, // #966
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 3, false, false, false, 280, 2, 13, 1,  0, 0}, // #967
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #968
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #969
  {DBGFIELD("VPBLENDWYrri")       1, false, false, false, 474, 8,  1, 1,  0, 0}, // #970
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #971
  {DBGFIELD("VPBLENDWYrmi")       2, false, false, false, 464, 10,  6, 1,  5, 1}, // #972
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #973
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64_MASKMOVDQUX32") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #974
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64_VMASKMOVDQUX32") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #975
  {DBGFIELD("VPMASKMOVDYrm")      3, false, false, false, 531, 10,  2, 1,  0, 0}, // #976
  {DBGFIELD("VPMASKMOVDrm")       3, false, false, false, 531, 10,  6, 1,  0, 0}, // #977
  {DBGFIELD("VPMASKMOVDYmr")      4, false, false, false, 2564, 12, 14, 1,  0, 0}, // #978
  {DBGFIELD("VPMASKMOVDmr")       4, false, false, false, 2564, 12, 14, 1,  0, 0}, // #979
  {DBGFIELD("VPMASKMOVQYmr")      4, false, false, false, 2564, 12, 14, 1,  0, 0}, // #980
  {DBGFIELD("VPMASKMOVQmr")       4, false, false, false, 2564, 12, 14, 1,  0, 0}, // #981
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 3, false, false, false, 2758, 10,  9, 1,  0, 0}, // #982
  {DBGFIELD("VPGATHERDDYrm")      14, false, false, false, 2905, 12, 37, 1,  0, 0}, // #983
  {DBGFIELD("VPGATHERDDrm")       10, false, false, false, 2893, 12, 20, 1,  0, 0}, // #984
  {DBGFIELD("VPGATHERDQYrm")      9, false, false, false, 2881, 12, 31, 1,  0, 0}, // #985
  {DBGFIELD("VPGATHERDQrm")       7, false, false, false, 2869, 12, 17, 1,  0, 0}, // #986
  {DBGFIELD("VPGATHERQDYrm")      10, false, false, false, 2893, 12, 20, 1,  0, 0}, // #987
  {DBGFIELD("VPGATHERQDrm")       9, false, false, false, 2917, 12, 20, 1,  0, 0}, // #988
  {DBGFIELD("VPGATHERQQYrm")      9, false, false, false, 2881, 12, 31, 1,  0, 0}, // #989
  {DBGFIELD("VPGATHERQQrm")       7, false, false, false, 2869, 12, 17, 1,  0, 0}, // #990
  {DBGFIELD("PSLLDQri_PSRLDQri_VPSLLDQri_VPSRLDQri") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #991
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #992
  {DBGFIELD("VPERM2F128rr")       1, false, false, false, 474, 8,  5, 1,  0, 0}, // #993
  {DBGFIELD("VPERM2F128rm")       2, false, false, false, 464, 10,  9, 1,  5, 1}, // #994
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, false, 474, 8,  5, 1,  0, 0}, // #995
  {DBGFIELD("VEXTRACTF128mr")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #996
  {DBGFIELD("VINSERTF128rr")      1, false, false, false, 474, 8,  5, 1,  0, 0}, // #997
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #998
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #999
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, false, 2671, 12,  8, 1,  0, 0}, // #1000
  {DBGFIELD("VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, false, 2727, 14,  9, 1,  0, 0}, // #1001
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1002
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1003
  {DBGFIELD("SHA256MSG2rm")       2, false, false, false, 69, 11,  7, 1,  3, 1}, // #1004
  {DBGFIELD("SHA256MSG2rr")       1, false, false, false, 40, 9, 14, 1,  0, 0}, // #1005
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, false, 40, 9, 14, 1,  0, 0}, // #1006
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #1007
  {DBGFIELD("SHA1MSG2rr")         1, false, false, false, 40, 9, 14, 1,  0, 0}, // #1008
  {DBGFIELD("SHA1MSG2rm")         2, false, false, false, 69, 11,  7, 1,  3, 1}, // #1009
  {DBGFIELD("SHA1NEXTErr")        1, false, false, false, 40, 9, 14, 1,  0, 0}, // #1010
  {DBGFIELD("SHA1NEXTErm")        2, false, false, false, 69, 11,  7, 1,  3, 1}, // #1011
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, false, 40, 9, 14, 1,  0, 0}, // #1012
  {DBGFIELD("SHA1RNDS4rmi")       2, false, false, false, 69, 11,  7, 1,  3, 1}, // #1013
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, false, 40, 9, 14, 1,  0, 0}, // #1014
  {DBGFIELD("SHA256RNDS2rm")      2, false, false, false, 69, 11,  7, 1,  3, 1}, // #1015
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 3, false, false, false, 280, 2, 13, 1,  0, 0}, // #1016
  {DBGFIELD("BT16mi8_BT32mi8_BT64mi8") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #1017
  {DBGFIELD("BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 1, false, false, false,  8, 4,  1, 1,  0, 0}, // #1018
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1019
  {DBGFIELD("MOV8rm_MOV8rm_NOREX") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1020
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVZX16rm16") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1021
  {DBGFIELD("MOVBE16rm")          2, false, false, false, 148, 6,  3, 1,  0, 0}, // #1022
  {DBGFIELD("ADD8i8_ADD16i16_ADD32i32_ADD64i32_AND8i8_AND16i16_AND32i32_AND64i32_OR8i8_OR16i16_OR32i32_OR64i32_SUB8i8_SUB16i16_SUB32i32_SUB64i32_XOR8i8_XOR16i16_XOR32i32_XOR64i32") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1023
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32_MOVZX16rr16") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1024
  {DBGFIELD("MOV32ri_MOV32ri_alt_MOV64ri32") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1025
  {DBGFIELD("ADC8mr_SBB8mr")      6, false, false, false, 12, 8,  2, 1,  1, 2}, // #1026
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1027
  {DBGFIELD("LEA16r")             1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1028
  {DBGFIELD("LCMPXCHG8")          6, false, false, false, 12, 8,  2, 1,  0, 0}, // #1029
  {DBGFIELD("LCMPXCHG16B")        6, false, false, false, 12, 8,  2, 1,  0, 0}, // #1030
  {DBGFIELD("XCHG8rr_XCHG16rr_XCHG16ar") 3, false, false, false, 280, 2, 13, 1,  0, 0}, // #1031
  {DBGFIELD("XCHG8rm_XCHG16rm")   6, false, false, false, 2683, 6,  2, 1,  0, 0}, // #1032
  {DBGFIELD("POPCNT16rr")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1033
  {DBGFIELD("LZCNT16rr")          1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1034
  {DBGFIELD("TZCNT16rr")          1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1035
  {DBGFIELD("RCL8m1_RCL16m1_RCL32m1_RCL64m1_RCR8m1_RCR16m1_RCR32m1_RCR64m1") 5, false, false, false, 823, 6,  2, 1,  0, 0}, // #1036
  {DBGFIELD("RCR8ri_RCR16ri_RCR32ri_RCR64ri") 3, false, false, false, 1092, 4,  5, 1,  0, 0}, // #1037
  {DBGFIELD("RCR8mi_RCR16mi_RCR32mi_RCR64mi") 5, false, false, false, 823, 6,  2, 1,  0, 0}, // #1038
  {DBGFIELD("RCR16rCL_RCR32rCL_RCR64rCL") 7, false, false, false, 2792, 9, 18, 1,  0, 0}, // #1039
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #1040
  {DBGFIELD("VEXTRACTI128rr")     1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1041
  {DBGFIELD("VEXTRACTI128mr")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #1042
  {DBGFIELD("MMX_MOVQ2FR64rr")    1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1043
  {DBGFIELD("MMX_MOVD64rr_MMX_MOVD64to64rr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1044
  {DBGFIELD("EXTRQ")              1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1045
  {DBGFIELD("INSERTQ")            1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1046
  {DBGFIELD("PABSBrr_PABSDrr_PABSWrr_PADDSBrr_PADDSWrr_PADDUSBrr_PADDUSWrr_PAVGBrr_PAVGWrr_PSIGNBrr_PSIGNDrr_PSIGNWrr_VPABSBrr_VPABSDrr_VPABSWrr_VPADDSBrr_VPADDSWrr_VPADDUSBrr_VPADDUSWrr_VPAVGBrr_VPAVGWrr_VPCMPEQQrr_VPSIGNBrr_VPSIGNDrr_VPSIGNWrr_PSUBSBrr_PSUBSWrr_PSUBUSBrr_PSUBUSWrr_VPSUBSBrr_VPSUBSWrr_VPSUBUSBrr_VPSUBUSWrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1047
  {DBGFIELD("MMX_PADDSBrr_MMX_PADDSWrr_MMX_PADDUSBrr_MMX_PADDUSWrr_MMX_PAVGBrr_MMX_PAVGWrr_MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1048
  {DBGFIELD("VPABSBYrr_VPABSDYrr_VPABSWYrr_VPADDSBYrr_VPADDSWYrr_VPADDUSBYrr_VPADDUSWYrr_VPSUBSBYrr_VPSUBSWYrr_VPSUBUSBYrr_VPSUBUSWYrr_VPAVGBYrr_VPAVGWYrr_VPCMPEQQYrr_VPSIGNBYrr_VPSIGNDYrr_VPSIGNWYrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1049
  {DBGFIELD("SHA1MSG1rr")         1, false, false, false, 40, 9, 14, 1,  0, 0}, // #1050
  {DBGFIELD("SHA1MSG1rm")         2, false, false, false, 69, 11,  7, 1,  3, 1}, // #1051
  {DBGFIELD("VPERM2I128rr")       1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1052
  {DBGFIELD("VPERMPSYrr")         1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1053
  {DBGFIELD("VPERMPSYrm")         2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1054
  {DBGFIELD("VPERMPDYri")         1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1055
  {DBGFIELD("VPERMQYri")          1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1056
  {DBGFIELD("VPERMPDYmi")         2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1057
  {DBGFIELD("VPERMDYrr")          1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1058
  {DBGFIELD("VPERMQYmi")          2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1059
  {DBGFIELD("VPERMDYrm")          2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1060
  {DBGFIELD("MOV32rr_MOV32rr_REV_MOV64rr_MOV64rr_REV") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1061
  {DBGFIELD("MOVSX32rr32")        1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1062
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV_SUB32rr_REV_SUB64rr_REV") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1063
  {DBGFIELD("CMP8rr_CMP8rr_REV_CMP16rr_CMP16rr_REV_CMP32rr_CMP32rr_REV_CMP64rr_CMP64rr_REV") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1064
  {DBGFIELD("VXORPSrr_VXORPDrr")  8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1065
  {DBGFIELD("VANDNPSrr_VANDNPDrr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1066
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1067
  {DBGFIELD("VPXORrr")            8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1068
  {DBGFIELD("VPANDNrr")           1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1069
  {DBGFIELD("VPANDNYrr")          1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1070
  {DBGFIELD("VPSUBBrr_VPSUBWrr_VPSUBDrr_VPSUBQrr_VPCMPGTBrr_VPCMPGTWrr_VPCMPGTDrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1071
  {DBGFIELD("VPCMPGTQrr")         8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1072
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #1073
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 3, false, false, false, 49, 6,  6, 1,  0, 0}, // #1074
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1075
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 2, false, false, false, 55, 4,  3, 1,  0, 0}, // #1076
  {DBGFIELD("ADC64ri32_SBB64ri32") 1, false, false, false,  8, 4,  1, 1,  0, 0}, // #1077
  {DBGFIELD("CRC32r32r16")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1078
  {DBGFIELD("CRC32r32r32")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1079
  {DBGFIELD("CRC32r64r64")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1080
  {DBGFIELD("SAHF")               1, false, false, false,  8, 4,  1, 1,  0, 0}, // #1081
  {DBGFIELD("BEXTRI32ri_BEXTRI64ri") 2, false, false, false, 134, 6, 13, 1,  0, 0}, // #1082
  {DBGFIELD("BEXTRI32mi_BEXTRI64mi") 3, false, false, false, 126, 8,  6, 1,  0, 0}, // #1083
  {DBGFIELD("RCR8ri")             3, false, false, false, 1092, 4,  5, 1,  0, 0}, // #1084
  {DBGFIELD("RCL16rCL")           7, false, false, false, 2792, 9, 18, 1,  0, 0}, // #1085
  {DBGFIELD("RCR16ri")            3, false, false, false, 1092, 4,  5, 1,  0, 0}, // #1086
  {DBGFIELD("RCR32rCL_RCR64rCL")  7, false, false, false, 2792, 9, 18, 1,  0, 0}, // #1087
  {DBGFIELD("RCL16ri")            3, false, false, false, 1092, 4,  5, 1,  0, 0}, // #1088
  {DBGFIELD("RCL32ri_RCL64ri")    3, false, false, false, 1092, 4,  5, 1,  0, 0}, // #1089
  {DBGFIELD("SHLD32rri8")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1090
  {DBGFIELD("SHRD16rri8")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1091
  {DBGFIELD("SHLD16rrCL")         4, false, false, false, 395, 9,  3, 1,  0, 0}, // #1092
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #1093
  {DBGFIELD("TST_F")              1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1094
  {DBGFIELD("VDPPSrri")           4, false, false, false, 2381, 14, 10, 1,  0, 0}, // #1095
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #1096
  {DBGFIELD("VFRCZSDrr_VFRCZSSrr") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #1097
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 3, false, false, false, 2446, 9, 18, 1,  3, 1}, // #1098
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #1099
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 3, false, false, false, 2446, 9, 23, 1,  5, 1}, // #1100
  {DBGFIELD("MMX_CVTTPD2PIrr")    2, false, false, false, 453, 11,  8, 1,  0, 0}, // #1101
  {DBGFIELD("VMOVDQUYmr")         2, false, false, false, 33, 4,  1, 1,  0, 0}, // #1102
  {DBGFIELD("MOVDQArr")           1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1103
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 2, false, false, false, 91, 9,  7, 1,  0, 0}, // #1104
  {DBGFIELD("VMPSADBWrri")        3, false, false, false, 1470, 12,  6, 1,  0, 0}, // #1105
  {DBGFIELD("VPPERMrrr_VPPERMrrr_REV") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1106
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, false, 2434, 8,  5, 1,  0, 0}, // #1107
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, false, 2424, 10,  2, 1,  3, 1}, // #1108
  {DBGFIELD("VPCLMULQDQrr")       1, false, false, false, 40, 9, 14, 1,  0, 0}, // #1109
  {DBGFIELD("ANDNPSrr_ANDNPDrr")  1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1110
  {DBGFIELD("MMX_PXORrr_MMX_PANDNrr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1111
  {DBGFIELD("PANDNrr")            1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1112
  {DBGFIELD("MMX_PSUBBrr_MMX_PSUBDrr_MMX_PSUBWrr_MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1113
  {DBGFIELD("LCMPXCHG16_LCMPXCHG32_LCMPXCHG64") 6, false, false, false, 12, 8,  2, 1,  0, 0}, // #1114
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 5, false, false, false, 175, 4, 14, 1,  0, 0}, // #1115
  {DBGFIELD("LCMPXCHG8B")         6, false, false, false, 12, 8,  2, 1,  0, 0}, // #1116
  {DBGFIELD("XCHG8rr")            3, false, false, false, 280, 2, 13, 1,  0, 0}, // #1117
  {DBGFIELD("MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1118
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1119
  {DBGFIELD("MMX_PCMPEQBrr_MMX_PCMPEQDrr_MMX_PCMPEQWrr_MMX_PMAXSWrr_MMX_PMINSWrr_MMX_PMAXUBrr_MMX_PMINUBrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1120
  {DBGFIELD("MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1121
  {DBGFIELD("CLAC_STAC")          1, false, false, false,  1, 2,  4, 1,  0, 0}, // #1122
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1123
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1124
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1125
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 3, false, false, false, 2434, 8,  5, 1,  0, 0}, // #1126
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, false, 2434, 8,  5, 1,  0, 0}, // #1127
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 3, false, false, false, 2434, 8,  5, 1,  0, 0}, // #1128
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1129
  {DBGFIELD("MMX_PADDSBrm_MMX_PADDSWrm_MMX_PADDUSBrm_MMX_PADDUSWrm_MMX_PAVGBrm_MMX_PAVGWrm_MMX_PCMPEQBrm_MMX_PCMPEQDrm_MMX_PCMPEQWrm_MMX_PCMPGTBrm_MMX_PCMPGTDrm_MMX_PCMPGTWrm_MMX_PMAXSWrm_MMX_PMAXUBrm_MMX_PMINSWrm_MMX_PMINUBrm_MMX_PSUBSBrm_MMX_PSUBSWrm_MMX_PSUBUSBrm_MMX_PSUBUSWrm") 2, false, false, false, 148, 6,  3, 1,  3, 1}, // #1130
  {DBGFIELD("CVTSS2SI64rr")       2, false, false, false, 2671, 12,  8, 1,  0, 0}, // #1131
  {DBGFIELD("CVTSS2SI64rr_Int")   2, false, false, false, 2671, 12,  8, 1,  0, 0}, // #1132
  {DBGFIELD("CVTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr") 2, false, false, false, 2671, 12,  8, 1,  0, 0}, // #1133
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 2, false, false, false, 2671, 12,  8, 1,  0, 0}, // #1134
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 2, false, false, false, 148, 6,  3, 1,  3, 1}, // #1135
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 2, false, false, false, 148, 6,  6, 1,  5, 1}, // #1136
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 4, false, false, false, 2424, 10,  2, 1,  3, 1}, // #1137
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, false, 2424, 10,  2, 1,  3, 1}, // #1138
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 4, false, false, false, 2424, 10,  9, 1,  5, 1}, // #1139
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 28, false, false, false, 2830, 11, 47, 1,  0, 0}, // #1140
  {DBGFIELD("PCMPGTBrr_PCMPGTDrr_PCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1141
  {DBGFIELD("VPCMPGTBrr_VPCMPGTDrr_VPCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1142
  {DBGFIELD("VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1143
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1144
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1145
  {DBGFIELD("KSET0D_KSET0Q_KSET0W_KSET1D_KSET1Q_KSET1W") 1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1146
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1147
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 2, false, false, false, 523, 8, 13, 1,  0, 0}, // #1148
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 2, false, false, false, 523, 8, 13, 1,  0, 0}, // #1149
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1150
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1151
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1152
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 2, false, false, false, 523, 8, 13, 1,  0, 0}, // #1153
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 2, false, false, false, 523, 8, 13, 1,  0, 0}, // #1154
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1155
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #1156
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1157
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1158
  {DBGFIELD("VPSADBWZrr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1159
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1160
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1161
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1162
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1163
  {DBGFIELD("VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1164
  {DBGFIELD("VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1165
  {DBGFIELD("VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1166
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1167
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1168
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1169
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1170
  {DBGFIELD("VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1171
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1172
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1173
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1174
  {DBGFIELD("VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1175
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1176
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1177
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1178
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1179
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1180
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1181
  {DBGFIELD("VCVTPS2DQYrr")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1182
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1183
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1184
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1185
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1186
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1187
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1188
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1189
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1190
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1191
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1192
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #1193
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1194
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1195
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1196
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1197
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1198
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1199
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1200
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 1, false, false, false, 26, 7,  8, 1,  6, 1}, // #1201
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 1, false, false, false, 26, 7,  8, 1,  6, 1}, // #1202
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1203
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1204
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 3, false, false, false, 2510, 10, 14, 1,  0, 0}, // #1205
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 3, false, false, false, 2510, 10,  6, 1,  0, 0}, // #1206
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1207
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #1208
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1209
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1210
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1211
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 1, false, false, false, 26, 7,  8, 1,  6, 1}, // #1212
  {DBGFIELD("VMOVSDZrm_VMOVSDZrm_alt_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrm_alt_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1213
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1214
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1215
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1216
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1217
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1218
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1219
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1220
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1221
  {DBGFIELD("VCVTPD2PSZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1222
  {DBGFIELD("VCVTPS2PDZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1223
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1224
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1225
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1226
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 3, false, false, false, 531, 10,  6, 1,  3, 1}, // #1227
  {DBGFIELD("VBROADCASTI32X2Z128rm_VBROADCASTI32X2Z128rmk_VBROADCASTI32X2Z128rmkz_VPBROADCASTDZ128rm_VPBROADCASTDZ128rmk_VPBROADCASTDZ128rmkz_VPBROADCASTQZ128rm_VPBROADCASTQZ128rmk_VPBROADCASTQZ128rmkz") 2, false, false, false, 464, 10,  3, 1,  0, 0}, // #1228
  {DBGFIELD("VBROADCASTSSZ128rm_VBROADCASTSSZ128rmk_VBROADCASTSSZ128rmkz") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #1229
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1230
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 2, false, false, false, 464, 10,  3, 1,  0, 0}, // #1231
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1232
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 2, false, false, false, 148, 6,  3, 1,  3, 1}, // #1233
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 3, false, false, false, 531, 10,  6, 1,  3, 1}, // #1234
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1235
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1236
  {DBGFIELD("VCVTSS2SI64rr")      2, false, false, false, 2671, 12,  8, 1,  0, 0}, // #1237
  {DBGFIELD("VCVTSS2SI64rr_Int")  2, false, false, false, 2671, 12,  8, 1,  0, 0}, // #1238
  {DBGFIELD("VCVTTSS2SI64rr")     2, false, false, false, 2671, 12,  8, 1,  0, 0}, // #1239
  {DBGFIELD("VCVTTSS2SI64rr_Int") 2, false, false, false, 2671, 12,  8, 1,  0, 0}, // #1240
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1241
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #1242
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1243
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1244
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1245
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1246
  {DBGFIELD("VPBROADCASTBZ256rm_VPBROADCASTBZ256rmk_VPBROADCASTBZ256rmkz_VPBROADCASTBZrm_VPBROADCASTBZrmk_VPBROADCASTBZrmkz_VPBROADCASTWZ256rm_VPBROADCASTWZ256rmk_VPBROADCASTWZ256rmkz_VPBROADCASTWZrm_VPBROADCASTWZrmk_VPBROADCASTWZrmkz") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #1247
  {DBGFIELD("VMOVNTDQAZ256rm")    1, false, false, false, 37, 3,  3, 1,  0, 0}, // #1248
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 3, false, false, false, 531, 10,  2, 1,  5, 1}, // #1249
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1250
  {DBGFIELD("VBROADCASTF32X2Z256rm_VBROADCASTF32X2Z256rmk_VBROADCASTF32X2Z256rmkz_VBROADCASTF32X2Zrm_VBROADCASTF32X2Zrmk_VBROADCASTF32X2Zrmkz_VBROADCASTI32X2Z256rm_VBROADCASTI32X2Z256rmk_VBROADCASTI32X2Z256rmkz_VBROADCASTI32X2Zrm_VBROADCASTI32X2Zrmk_VBROADCASTI32X2Zrmkz_VPBROADCASTDZ256rm_VPBROADCASTDZ256rmk_VPBROADCASTDZ256rmkz_VPBROADCASTDZrm_VPBROADCASTDZrmk_VPBROADCASTDZrmkz_VPBROADCASTQZ256rm_VPBROADCASTQZ256rmk_VPBROADCASTQZ256rmkz_VPBROADCASTQZrm_VPBROADCASTQZrmk_VPBROADCASTQZrmkz") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #1251
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 2, false, false, false, 464, 10,  6, 1,  0, 0}, // #1252
  {DBGFIELD("VBROADCASTSDZ256rm_VBROADCASTSDZ256rmk_VBROADCASTSDZ256rmkz_VBROADCASTSDZrm_VBROADCASTSDZrmk_VBROADCASTSDZrmkz_VBROADCASTSSZ256rm_VBROADCASTSSZ256rmk_VBROADCASTSSZ256rmkz_VBROADCASTSSZrm_VBROADCASTSSZrmk_VBROADCASTSSZrmkz") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #1253
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1254
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1255
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #1256
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, false, 464, 10,  6, 1,  0, 0}, // #1257
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1258
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #1259
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 2, false, false, false, 148, 6,  6, 1,  5, 1}, // #1260
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1261
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 3, false, false, false, 531, 10,  2, 1,  5, 1}, // #1262
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1263
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1264
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1265
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1266
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1267
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #1268
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #1269
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1270
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1271
  {DBGFIELD("VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 2, false, false, false, 148, 6,  3, 1,  3, 1}, // #1272
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmik_VFPCLASSPDZ128rm_VFPCLASSPDZ128rmb_VFPCLASSPDZ128rmbk_VFPCLASSPDZ128rmk_VFPCLASSPSZ128rm_VFPCLASSPSZ128rmb_VFPCLASSPSZ128rmbk_VFPCLASSPSZ128rmk") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #1273
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #1274
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmik_VPCMPDZ128rmi_VPCMPDZ128rmib_VPCMPDZ128rmibk_VPCMPDZ128rmik_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmib_VPCMPQZ128rmibk_VPCMPQZ128rmik_VPCMPUBZ128rmi_VPCMPUBZ128rmik_VPCMPUDZ128rmi_VPCMPUDZ128rmib_VPCMPUDZ128rmibk_VPCMPUDZ128rmik_VPCMPUQZ128rmi_VPCMPUQZ128rmib_VPCMPUQZ128rmibk_VPCMPUQZ128rmik_VPCMPUWZ128rmi_VPCMPUWZ128rmik_VPCMPWZ128rmi_VPCMPWZ128rmik") 2, false, false, false, 148, 6,  3, 1,  3, 1}, // #1275
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 2, false, false, false, 60, 5,  3, 1,  3, 1}, // #1276
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #1277
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1278
  {DBGFIELD("VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 2, false, false, false, 148, 6,  6, 1,  5, 1}, // #1279
  {DBGFIELD("VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1280
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmik_VFPCLASSPDZ256rm_VFPCLASSPDZ256rmb_VFPCLASSPDZ256rmbk_VFPCLASSPDZ256rmk_VFPCLASSPSZ256rm_VFPCLASSPSZ256rmb_VFPCLASSPSZ256rmbk_VFPCLASSPSZ256rmk") 2, false, false, false, 158, 9,  9, 1,  5, 1}, // #1281
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmik_VFPCLASSPDZrm_VFPCLASSPDZrmb_VFPCLASSPDZrmbk_VFPCLASSPDZrmk_VFPCLASSPSZrm_VFPCLASSPSZrmb_VFPCLASSPSZrmbk_VFPCLASSPSZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1282
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmik_VPCMPDZ256rmi_VPCMPDZ256rmib_VPCMPDZ256rmibk_VPCMPDZ256rmik_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmib_VPCMPQZ256rmibk_VPCMPQZ256rmik_VPCMPUBZ256rmi_VPCMPUBZ256rmik_VPCMPUDZ256rmi_VPCMPUDZ256rmib_VPCMPUDZ256rmibk_VPCMPUDZ256rmik_VPCMPUQZ256rmi_VPCMPUQZ256rmib_VPCMPUQZ256rmibk_VPCMPUQZ256rmik_VPCMPUWZ256rmi_VPCMPUWZ256rmik_VPCMPWZ256rmi_VPCMPWZ256rmik") 2, false, false, false, 148, 6,  6, 1,  5, 1}, // #1283
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmik_VPCMPDZrmi_VPCMPDZrmib_VPCMPDZrmibk_VPCMPDZrmik_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmib_VPCMPQZrmibk_VPCMPQZrmik_VPCMPUBZrmi_VPCMPUBZrmik_VPCMPUDZrmi_VPCMPUDZrmib_VPCMPUDZrmibk_VPCMPUDZrmik_VPCMPUQZrmi_VPCMPUQZrmib_VPCMPUQZrmibk_VPCMPUQZrmik_VPCMPUWZrmi_VPCMPUWZrmik_VPCMPWZrmi_VPCMPWZrmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1284
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 2, false, false, false, 60, 5,  6, 1,  5, 1}, // #1285
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1286
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 2, false, false, false, 158, 9,  9, 1,  0, 0}, // #1287
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 2, false, false, false, 158, 9,  9, 1,  0, 0}, // #1288
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #1289
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 2, false, false, false, 69, 11,  3, 1,  0, 0}, // #1290
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #1291
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #1292
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #1293
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1294
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 2, false, false, false, 158, 9,  9, 1,  0, 0}, // #1295
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1296
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, false, 158, 9,  9, 1,  0, 0}, // #1297
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1298
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, false, 69, 11,  3, 1,  0, 0}, // #1299
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1300
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #1301
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1302
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #1303
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1304
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #1305
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1306
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1307
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #1308
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 2, false, false, false, 148, 6,  3, 1,  0, 0}, // #1309
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, false, 40, 9, 14, 1,  0, 0}, // #1310
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 1, false, false, false, 40, 9, 14, 1,  0, 0}, // #1311
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1312
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1313
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #1314
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #1315
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1316
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1317
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1318
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1319
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1320
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1321
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1322
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 2, false, false, false, 148, 6,  3, 1,  0, 0}, // #1323
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #1324
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 2, false, false, false, 69, 11, 18, 1,  5, 1}, // #1325
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1326
  {DBGFIELD("VGATHERQPSZ128rm_VPGATHERQDZ128rm_VGATHERDPDZ128rm_VPGATHERDQZ128rm_VGATHERQPDZ128rm_VPGATHERQQZ128rm") 1, false, false, false, 37, 3, 38, 2,  0, 0}, // #1327
  {DBGFIELD("VGATHERQPSZ256rm_VPGATHERQDZ256rm_VGATHERQPDZ256rm_VPGATHERQQZ256rm_VGATHERDPSZ128rm_VPGATHERDDZ128rm_VGATHERDPDZ256rm_VPGATHERDQZ256rm") 1, false, false, false, 37, 3, 38, 2,  0, 0}, // #1328
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm_VGATHERDPDZrm_VPGATHERDQZrm_VGATHERQPDZrm_VPGATHERQQZrm_VGATHERQPSZrm_VPGATHERQDZrm") 1, false, false, false, 37, 3, 38, 2,  0, 0}, // #1329
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 1, false, false, false, 37, 3, 38, 2,  0, 0}, // #1330
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1331
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1332
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 2, false, false, false, 148, 6,  6, 1,  0, 0}, // #1333
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1334
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1335
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 2, false, false, false, 148, 6,  6, 1,  0, 0}, // #1336
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1337
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1338
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1339
  {DBGFIELD("VXORPSZ128rr_VXORPDZ128rr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1340
  {DBGFIELD("VXORPSZ256rr_VXORPDZ256rr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1341
  {DBGFIELD("VXORPSZrr_VXORPDZrr") 8191, false, false, false,  0, 0,  0