/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the RISCV target                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 32;
using PredicateBitset = llvm::PredicateBitsetImpl<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(RISCVInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(RISCVInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ISelInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ISelInfo;
  static RISCVInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static RISCVInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const int64_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const std::array<const MachineOperand *, 3> &Operands) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ISelInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasStdExtMBit = 9,
  Feature_HasStdExtABit = 10,
  Feature_HasStdExtFBit = 1,
  Feature_HasStdExtDBit = 2,
  Feature_HasStdExtZfhBit = 4,
  Feature_HasStdExtZfhOrZfhminBit = 6,
  Feature_HasStdExtZbaBit = 19,
  Feature_NotHasStdExtZbaBit = 8,
  Feature_HasStdExtZbbBit = 17,
  Feature_HasStdExtZbcBit = 21,
  Feature_HasStdExtZbeBit = 22,
  Feature_HasStdExtZbfBit = 24,
  Feature_HasStdExtZbpBit = 15,
  Feature_HasStdExtZbrBit = 23,
  Feature_HasStdExtZbsBit = 12,
  Feature_HasStdExtZbtBit = 16,
  Feature_HasStdExtZbbOrZbpBit = 13,
  Feature_HasStdExtZbkxBit = 25,
  Feature_HasStdExtZbpOrZbkbBit = 14,
  Feature_HasStdExtZbbOrZbkbBit = 18,
  Feature_HasStdExtZbbOrZbpOrZbkbBit = 11,
  Feature_HasStdExtZbcOrZbkcBit = 20,
  Feature_HasStdExtZkndBit = 26,
  Feature_HasStdExtZkneBit = 28,
  Feature_HasStdExtZkndOrZkneBit = 27,
  Feature_HasStdExtZknhBit = 29,
  Feature_HasStdExtZksedBit = 30,
  Feature_HasStdExtZkshBit = 31,
  Feature_HasVInstructionsBit = 3,
  Feature_HasVInstructionsAnyFBit = 5,
  Feature_IsRV64Bit = 7,
  Feature_IsRV32Bit = 0,
};

PredicateBitset RISCVInstructionSelector::
computeAvailableModuleFeatures(const RISCVSubtarget *Subtarget) const {
  PredicateBitset Features;
  if (Subtarget->hasStdExtM())
    Features.set(Feature_HasStdExtMBit);
  if (Subtarget->hasStdExtA())
    Features.set(Feature_HasStdExtABit);
  if (Subtarget->hasStdExtF())
    Features.set(Feature_HasStdExtFBit);
  if (Subtarget->hasStdExtD())
    Features.set(Feature_HasStdExtDBit);
  if (Subtarget->hasStdExtZfh())
    Features.set(Feature_HasStdExtZfhBit);
  if (Subtarget->hasStdExtZfh() || Subtarget->hasStdExtZfhmin())
    Features.set(Feature_HasStdExtZfhOrZfhminBit);
  if (Subtarget->hasStdExtZba())
    Features.set(Feature_HasStdExtZbaBit);
  if (!Subtarget->hasStdExtZba())
    Features.set(Feature_NotHasStdExtZbaBit);
  if (Subtarget->hasStdExtZbb())
    Features.set(Feature_HasStdExtZbbBit);
  if (Subtarget->hasStdExtZbc())
    Features.set(Feature_HasStdExtZbcBit);
  if (Subtarget->hasStdExtZbe())
    Features.set(Feature_HasStdExtZbeBit);
  if (Subtarget->hasStdExtZbf())
    Features.set(Feature_HasStdExtZbfBit);
  if (Subtarget->hasStdExtZbp())
    Features.set(Feature_HasStdExtZbpBit);
  if (Subtarget->hasStdExtZbr())
    Features.set(Feature_HasStdExtZbrBit);
  if (Subtarget->hasStdExtZbs())
    Features.set(Feature_HasStdExtZbsBit);
  if (Subtarget->hasStdExtZbt())
    Features.set(Feature_HasStdExtZbtBit);
  if (Subtarget->hasStdExtZbb() || Subtarget->hasStdExtZbp())
    Features.set(Feature_HasStdExtZbbOrZbpBit);
  if (Subtarget->hasStdExtZbkx())
    Features.set(Feature_HasStdExtZbkxBit);
  if (Subtarget->hasStdExtZbp() || Subtarget->hasStdExtZbkb())
    Features.set(Feature_HasStdExtZbpOrZbkbBit);
  if (Subtarget->hasStdExtZbb() || Subtarget->hasStdExtZbkb())
    Features.set(Feature_HasStdExtZbbOrZbkbBit);
  if (Subtarget->hasStdExtZbb() || Subtarget->hasStdExtZbp() || Subtarget->hasStdExtZbkb())
    Features.set(Feature_HasStdExtZbbOrZbpOrZbkbBit);
  if (Subtarget->hasStdExtZbc() || Subtarget->hasStdExtZbkc())
    Features.set(Feature_HasStdExtZbcOrZbkcBit);
  if (Subtarget->hasStdExtZknd())
    Features.set(Feature_HasStdExtZkndBit);
  if (Subtarget->hasStdExtZkne())
    Features.set(Feature_HasStdExtZkneBit);
  if (Subtarget->hasStdExtZknd() || Subtarget->hasStdExtZkne())
    Features.set(Feature_HasStdExtZkndOrZkneBit);
  if (Subtarget->hasStdExtZknh())
    Features.set(Feature_HasStdExtZknhBit);
  if (Subtarget->hasStdExtZksed())
    Features.set(Feature_HasStdExtZksedBit);
  if (Subtarget->hasStdExtZksh())
    Features.set(Feature_HasStdExtZkshBit);
  if (Subtarget->hasVInstructions())
    Features.set(Feature_HasVInstructionsBit);
  if (Subtarget->hasVInstructionsAnyF())
    Features.set(Feature_HasVInstructionsAnyFBit);
  if (Subtarget->is64Bit())
    Features.set(Feature_IsRV64Bit);
  if (!Subtarget->is64Bit())
    Features.set(Feature_IsRV32Bit);
  return Features;
}

void RISCVInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const RISCVSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset RISCVInstructionSelector::
computeAvailableFunctionFeatures(const RISCVSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  return Features;
}

// LLT Objects.
enum {
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_nxv1s1,
  GILLT_nxv1s8,
  GILLT_nxv1s16,
  GILLT_nxv1s32,
  GILLT_nxv1s64,
  GILLT_nxv2s1,
  GILLT_nxv2s8,
  GILLT_nxv2s16,
  GILLT_nxv2s32,
  GILLT_nxv2s64,
  GILLT_nxv4s1,
  GILLT_nxv4s8,
  GILLT_nxv4s16,
  GILLT_nxv4s32,
  GILLT_nxv4s64,
  GILLT_nxv8s1,
  GILLT_nxv8s8,
  GILLT_nxv8s16,
  GILLT_nxv8s32,
  GILLT_nxv8s64,
  GILLT_nxv16s1,
  GILLT_nxv16s8,
  GILLT_nxv16s16,
  GILLT_nxv16s32,
  GILLT_nxv32s1,
  GILLT_nxv32s8,
  GILLT_nxv32s16,
  GILLT_nxv64s1,
  GILLT_nxv64s8,
};
const static size_t NumTypeObjects = 32;
const static LLT TypeObjects[] = {
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getScalable(1), 1),
  LLT::vector(ElementCount::getScalable(1), 8),
  LLT::vector(ElementCount::getScalable(1), 16),
  LLT::vector(ElementCount::getScalable(1), 32),
  LLT::vector(ElementCount::getScalable(1), 64),
  LLT::vector(ElementCount::getScalable(2), 1),
  LLT::vector(ElementCount::getScalable(2), 8),
  LLT::vector(ElementCount::getScalable(2), 16),
  LLT::vector(ElementCount::getScalable(2), 32),
  LLT::vector(ElementCount::getScalable(2), 64),
  LLT::vector(ElementCount::getScalable(4), 1),
  LLT::vector(ElementCount::getScalable(4), 8),
  LLT::vector(ElementCount::getScalable(4), 16),
  LLT::vector(ElementCount::getScalable(4), 32),
  LLT::vector(ElementCount::getScalable(4), 64),
  LLT::vector(ElementCount::getScalable(8), 1),
  LLT::vector(ElementCount::getScalable(8), 8),
  LLT::vector(ElementCount::getScalable(8), 16),
  LLT::vector(ElementCount::getScalable(8), 32),
  LLT::vector(ElementCount::getScalable(8), 64),
  LLT::vector(ElementCount::getScalable(16), 1),
  LLT::vector(ElementCount::getScalable(16), 8),
  LLT::vector(ElementCount::getScalable(16), 16),
  LLT::vector(ElementCount::getScalable(16), 32),
  LLT::vector(ElementCount::getScalable(32), 1),
  LLT::vector(ElementCount::getScalable(32), 8),
  LLT::vector(ElementCount::getScalable(32), 16),
  LLT::vector(ElementCount::getScalable(64), 1),
  LLT::vector(ElementCount::getScalable(64), 8),
};

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasStdExtA,
  GIFBS_HasStdExtD,
  GIFBS_HasStdExtF,
  GIFBS_HasStdExtM,
  GIFBS_HasStdExtZbb,
  GIFBS_HasStdExtZbbOrZbpOrZbkb,
  GIFBS_HasStdExtZbc,
  GIFBS_HasStdExtZbcOrZbkc,
  GIFBS_HasStdExtZbkx,
  GIFBS_HasStdExtZbp,
  GIFBS_HasStdExtZbpOrZbkb,
  GIFBS_HasStdExtZbr,
  GIFBS_HasStdExtZbs,
  GIFBS_HasStdExtZbt,
  GIFBS_HasStdExtZfh,
  GIFBS_HasStdExtZfhOrZfhmin,
  GIFBS_HasStdExtZknh,
  GIFBS_HasStdExtZksed,
  GIFBS_HasStdExtZksh,
  GIFBS_HasVInstructions,
  GIFBS_HasVInstructionsAnyF,
  GIFBS_IsRV64,
  GIFBS_HasStdExtA_IsRV64,
  GIFBS_HasStdExtD_HasStdExtZfhOrZfhmin,
  GIFBS_HasStdExtD_IsRV32,
  GIFBS_HasStdExtD_IsRV64,
  GIFBS_HasStdExtF_IsRV32,
  GIFBS_HasStdExtZba_IsRV64,
  GIFBS_HasStdExtZbbOrZbkb_IsRV32,
  GIFBS_HasStdExtZbbOrZbkb_IsRV64,
  GIFBS_HasStdExtZbbOrZbp_IsRV32,
  GIFBS_HasStdExtZbbOrZbp_IsRV64,
  GIFBS_HasStdExtZbp_IsRV32,
  GIFBS_HasStdExtZbp_IsRV64,
  GIFBS_HasStdExtZbpOrZbkb_IsRV32,
  GIFBS_HasStdExtZbpOrZbkb_IsRV64,
  GIFBS_HasStdExtZbr_IsRV64,
  GIFBS_HasStdExtZknd_IsRV32,
  GIFBS_HasStdExtZknd_IsRV64,
  GIFBS_HasStdExtZkndOrZkne_IsRV64,
  GIFBS_HasStdExtZkne_IsRV32,
  GIFBS_HasStdExtZkne_IsRV64,
  GIFBS_HasStdExtZknh_IsRV32,
  GIFBS_HasStdExtZknh_IsRV64,
  GIFBS_IsRV64_NotHasStdExtZba,
  GIFBS_HasStdExtM_IsRV64_NotHasStdExtZba,
};
const static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasStdExtABit, },
  {Feature_HasStdExtDBit, },
  {Feature_HasStdExtFBit, },
  {Feature_HasStdExtMBit, },
  {Feature_HasStdExtZbbBit, },
  {Feature_HasStdExtZbbOrZbpOrZbkbBit, },
  {Feature_HasStdExtZbcBit, },
  {Feature_HasStdExtZbcOrZbkcBit, },
  {Feature_HasStdExtZbkxBit, },
  {Feature_HasStdExtZbpBit, },
  {Feature_HasStdExtZbpOrZbkbBit, },
  {Feature_HasStdExtZbrBit, },
  {Feature_HasStdExtZbsBit, },
  {Feature_HasStdExtZbtBit, },
  {Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfhOrZfhminBit, },
  {Feature_HasStdExtZknhBit, },
  {Feature_HasStdExtZksedBit, },
  {Feature_HasStdExtZkshBit, },
  {Feature_HasVInstructionsBit, },
  {Feature_HasVInstructionsAnyFBit, },
  {Feature_IsRV64Bit, },
  {Feature_HasStdExtABit, Feature_IsRV64Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfhOrZfhminBit, },
  {Feature_HasStdExtDBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtDBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtFBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbaBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbbOrZbpBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbbOrZbpBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbpBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbpBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbpOrZbkbBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbpOrZbkbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbrBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkndOrZkneBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV64Bit, },
  {Feature_IsRV64Bit, Feature_NotHasStdExtZbaBit, },
  {Feature_HasStdExtMBit, Feature_IsRV64Bit, Feature_NotHasStdExtZbaBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

// PatFrag predicates.
enum {
  GIPFP_I64_Predicate_BCLRMask = GIPFP_I64_Invalid + 1,
  GIPFP_I64_Predicate_BSETINVMask,
  GIPFP_I64_Predicate_byteselect,
  GIPFP_I64_Predicate_c_lui_imm,
  GIPFP_I64_Predicate_immzero,
  GIPFP_I64_Predicate_rnum,
  GIPFP_I64_Predicate_shfl_uimm,
  GIPFP_I64_Predicate_simm10_lsb0000nonzero,
  GIPFP_I64_Predicate_simm12,
  GIPFP_I64_Predicate_simm12_lsb0,
  GIPFP_I64_Predicate_simm12_plus1,
  GIPFP_I64_Predicate_simm5,
  GIPFP_I64_Predicate_simm5_plus1,
  GIPFP_I64_Predicate_simm5_plus1_nonzero,
  GIPFP_I64_Predicate_simm6,
  GIPFP_I64_Predicate_simm6nonzero,
  GIPFP_I64_Predicate_simm9_lsb0,
  GIPFP_I64_Predicate_uimm10_lsb00nonzero,
  GIPFP_I64_Predicate_uimm5,
  GIPFP_I64_Predicate_uimm6gt32,
  GIPFP_I64_Predicate_uimm7_lsb00,
  GIPFP_I64_Predicate_uimm8_lsb00,
  GIPFP_I64_Predicate_uimm8_lsb000,
  GIPFP_I64_Predicate_uimm9_lsb000,
  GIPFP_I64_Predicate_uimmlog2xlen,
  GIPFP_I64_Predicate_uimmlog2xlennonzero,
};
bool RISCVInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GIPFP_I64_Predicate_BCLRMask: {
    
  if (Subtarget->is64Bit())
    return !isInt<12>(Imm) && isPowerOf2_64(~Imm);
  return !isInt<12>(Imm) && isPowerOf2_32(~Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_BSETINVMask: {
    
  if (Subtarget->is64Bit())
    return !isInt<12>(Imm) && isPowerOf2_64(Imm);
  return !isInt<12>(Imm) && isPowerOf2_32(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_byteselect: {
    return isUInt<2>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_c_lui_imm: {
    return (Imm != 0) &&
                                 (isUInt<5>(Imm) ||
                                  (Imm >= 0xfffe0 && Imm <= 0xfffff));
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immzero: {
    return (Imm == 0);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_rnum: {
    return (Imm >= 0 && Imm <= 10);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_shfl_uimm: {
    
  if (Subtarget->is64Bit())
    return isUInt<5>(Imm);
  return isUInt<4>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm10_lsb0000nonzero: {
    return (Imm != 0) && isShiftedInt<6, 4>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm12: {
    return isInt<12>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm12_lsb0: {
    return isShiftedInt<11, 1>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm12_plus1: {
    return (isInt<12>(Imm) && Imm != -2048) || Imm == 2048;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm5: {
    return isInt<5>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm5_plus1: {
    return (isInt<5>(Imm) && Imm != -16) || Imm == 16;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm5_plus1_nonzero: {
    return Imm != 0 && ((isInt<5>(Imm) && Imm != -16) || Imm == 16);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm6: {
    return isInt<6>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm6nonzero: {
    return (Imm != 0) && isInt<6>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm9_lsb0: {
    return isShiftedInt<8, 1>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm10_lsb00nonzero: {
    return isShiftedUInt<8, 2>(Imm) && (Imm != 0);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm5: {
    return isUInt<5>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm6gt32: {
    
  return isUInt<6>(Imm) && Imm > 32;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm7_lsb00: {
    return isShiftedUInt<5, 2>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm8_lsb00: {
    return isShiftedUInt<6, 2>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm8_lsb000: {
    return isShiftedUInt<5, 3>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm9_lsb000: {
    return isShiftedUInt<6, 3>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimmlog2xlen: {
    
  if (Subtarget->is64Bit())
    return isUInt<6>(Imm);
  return isUInt<5>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimmlog2xlennonzero: {
    
  if (Subtarget->is64Bit())
    return isUInt<6>(Imm) && (Imm != 0);
  return isUInt<5>(Imm) && (Imm != 0);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const std::array<const MachineOperand *, 3> &Operands) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  (void)MRI;
  llvm_unreachable("Unknown predicate");
  return false;
}

RISCVInstructionSelector::ComplexMatcherMemFn
RISCVInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// Custom renderers.
enum {
  GICR_Invalid,
};
RISCVInstructionSelector::CustomRendererFn
RISCVInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool RISCVInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  MachineFunction &MF = *I.getParent()->getParent();
  MachineRegisterInfo &MRI = MF.getRegInfo();
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  NewMIVector OutMIs;
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, OutMIs, State, ISelInfo, getMatchTable(), TII, MRI, TRI, RBI, AvailableFeatures, CoverageInfo)) {
    return true;
  }

  return false;
}

const int64_t *RISCVInstructionSelector::getMatchTable() const {
  constexpr static int64_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/45, 219, /*)*//*default:*//*Label 72*/ 150581,
    /*TargetOpcode::G_ADD*//*Label 0*/ 179,
    /*TargetOpcode::G_SUB*//*Label 1*/ 2197,
    /*TargetOpcode::G_MUL*//*Label 2*/ 4143,
    /*TargetOpcode::G_SDIV*//*Label 3*/ 6208,
    /*TargetOpcode::G_UDIV*//*Label 4*/ 8158,
    /*TargetOpcode::G_SREM*//*Label 5*/ 10108,
    /*TargetOpcode::G_UREM*//*Label 6*/ 12058, 0, 0,
    /*TargetOpcode::G_AND*//*Label 7*/ 14008,
    /*TargetOpcode::G_OR*//*Label 8*/ 17504,
    /*TargetOpcode::G_XOR*//*Label 9*/ 23218, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_BITCAST*//*Label 10*/ 26150, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_READCYCLECOUNTER*//*Label 11*/ 26251, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 12*/ 26283,
    /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 13*/ 27696,
    /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 14*/ 28401,
    /*TargetOpcode::G_ATOMICRMW_SUB*//*Label 15*/ 29106,
    /*TargetOpcode::G_ATOMICRMW_AND*//*Label 16*/ 30180,
    /*TargetOpcode::G_ATOMICRMW_NAND*//*Label 17*/ 30885,
    /*TargetOpcode::G_ATOMICRMW_OR*//*Label 18*/ 31809,
    /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 19*/ 32514,
    /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 20*/ 33219,
    /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 21*/ 33924,
    /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 22*/ 34629,
    /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 23*/ 35334, 0, 0,
    /*TargetOpcode::G_FENCE*//*Label 24*/ 36039, 0, 0,
    /*TargetOpcode::G_INTRINSIC*//*Label 25*/ 36222,
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 26*/ 39561,
    /*TargetOpcode::G_ANYEXT*//*Label 27*/ 41178, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_SEXT*//*Label 28*/ 43299, 0,
    /*TargetOpcode::G_ZEXT*//*Label 29*/ 45420,
    /*TargetOpcode::G_SHL*//*Label 30*/ 47541,
    /*TargetOpcode::G_LSHR*//*Label 31*/ 49590,
    /*TargetOpcode::G_ASHR*//*Label 32*/ 51639, 0, 0,
    /*TargetOpcode::G_ROTR*//*Label 33*/ 53625,
    /*TargetOpcode::G_ROTL*//*Label 34*/ 53774,
    /*TargetOpcode::G_ICMP*//*Label 35*/ 53847,
    /*TargetOpcode::G_FCMP*//*Label 36*/ 78666,
    /*TargetOpcode::G_SELECT*//*Label 37*/ 85103, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_UMULH*//*Label 38*/ 86512,
    /*TargetOpcode::G_SMULH*//*Label 39*/ 88462,
    /*TargetOpcode::G_UADDSAT*//*Label 40*/ 90412,
    /*TargetOpcode::G_SADDSAT*//*Label 41*/ 92295,
    /*TargetOpcode::G_USUBSAT*//*Label 42*/ 94178,
    /*TargetOpcode::G_SSUBSAT*//*Label 43*/ 96061, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FADD*//*Label 44*/ 97944,
    /*TargetOpcode::G_FSUB*//*Label 45*/ 99236,
    /*TargetOpcode::G_FMUL*//*Label 46*/ 100528,
    /*TargetOpcode::G_FMA*//*Label 47*/ 101820, 0,
    /*TargetOpcode::G_FDIV*//*Label 48*/ 116443, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FNEG*//*Label 49*/ 117735,
    /*TargetOpcode::G_FPEXT*//*Label 50*/ 118907,
    /*TargetOpcode::G_FPTRUNC*//*Label 51*/ 119623,
    /*TargetOpcode::G_FPTOSI*//*Label 52*/ 120471,
    /*TargetOpcode::G_FPTOUI*//*Label 53*/ 123501,
    /*TargetOpcode::G_SITOFP*//*Label 54*/ 126531,
    /*TargetOpcode::G_UITOFP*//*Label 55*/ 129604,
    /*TargetOpcode::G_FABS*//*Label 56*/ 132677,
    /*TargetOpcode::G_FCOPYSIGN*//*Label 57*/ 133849, 0,
    /*TargetOpcode::G_FMINNUM*//*Label 58*/ 136611,
    /*TargetOpcode::G_FMAXNUM*//*Label 59*/ 137903, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_SMIN*//*Label 60*/ 139195,
    /*TargetOpcode::G_SMAX*//*Label 61*/ 141145,
    /*TargetOpcode::G_UMIN*//*Label 62*/ 143095,
    /*TargetOpcode::G_UMAX*//*Label 63*/ 145045, 0, 0, 0,
    /*TargetOpcode::G_BR*//*Label 64*/ 146995, 0, 0, 0, 0,
    /*TargetOpcode::G_CTTZ*//*Label 65*/ 147008, 0,
    /*TargetOpcode::G_CTLZ*//*Label 66*/ 147065, 0,
    /*TargetOpcode::G_CTPOP*//*Label 67*/ 147122,
    /*TargetOpcode::G_BSWAP*//*Label 68*/ 147179, 0, 0, 0, 0,
    /*TargetOpcode::G_FSQRT*//*Label 69*/ 147236, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_STRICT_FMA*//*Label 70*/ 148479,
    /*TargetOpcode::G_STRICT_FSQRT*//*Label 71*/ 150385,
    // Label 0: @179
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 97*/ 2196,
    /*GILLT_s32*//*Label 73*/ 216,
    /*GILLT_s64*//*Label 74*/ 282, 0,
    /*GILLT_nxv1s8*//*Label 75*/ 348,
    /*GILLT_nxv1s16*//*Label 76*/ 432,
    /*GILLT_nxv1s32*//*Label 77*/ 516,
    /*GILLT_nxv1s64*//*Label 78*/ 600, 0,
    /*GILLT_nxv2s8*//*Label 79*/ 684,
    /*GILLT_nxv2s16*//*Label 80*/ 768,
    /*GILLT_nxv2s32*//*Label 81*/ 852,
    /*GILLT_nxv2s64*//*Label 82*/ 936, 0,
    /*GILLT_nxv4s8*//*Label 83*/ 1020,
    /*GILLT_nxv4s16*//*Label 84*/ 1104,
    /*GILLT_nxv4s32*//*Label 85*/ 1188,
    /*GILLT_nxv4s64*//*Label 86*/ 1272, 0,
    /*GILLT_nxv8s8*//*Label 87*/ 1356,
    /*GILLT_nxv8s16*//*Label 88*/ 1440,
    /*GILLT_nxv8s32*//*Label 89*/ 1524,
    /*GILLT_nxv8s64*//*Label 90*/ 1608, 0,
    /*GILLT_nxv16s8*//*Label 91*/ 1692,
    /*GILLT_nxv16s16*//*Label 92*/ 1776,
    /*GILLT_nxv16s32*//*Label 93*/ 1860, 0,
    /*GILLT_nxv32s8*//*Label 94*/ 1944,
    /*GILLT_nxv32s16*//*Label 95*/ 2028, 0,
    /*GILLT_nxv64s8*//*Label 96*/ 2112,
    // Label 73: @216
    GIM_Try, /*On fail goto*//*Label 98*/ 281,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 99*/ 267, // Rule ID 49086 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ADDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ADDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49086,
        GIR_Done,
      // Label 99: @267
      GIM_Try, /*On fail goto*//*Label 100*/ 280, // Rule ID 49084 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::ADD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49084,
        GIR_Done,
      // Label 100: @280
      GIM_Reject,
    // Label 98: @281
    GIM_Reject,
    // Label 74: @282
    GIM_Try, /*On fail goto*//*Label 101*/ 347,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 102*/ 333, // Rule ID 49085 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ADDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ADDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49085,
        GIR_Done,
      // Label 102: @333
      GIM_Try, /*On fail goto*//*Label 103*/ 346, // Rule ID 49083 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::ADD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49083,
        GIR_Done,
      // Label 103: @346
      GIM_Reject,
    // Label 101: @347
    GIM_Reject,
    // Label 75: @348
    GIM_Try, /*On fail goto*//*Label 104*/ 431,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 105*/ 400, // Rule ID 21927 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVADD_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 21927,
        GIR_Done,
      // Label 105: @400
      GIM_Try, /*On fail goto*//*Label 106*/ 430, // Rule ID 21928 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVADD_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 21928,
        GIR_Done,
      // Label 106: @430
      GIM_Reject,
    // Label 104: @431
    GIM_Reject,
    // Label 76: @432
    GIM_Try, /*On fail goto*//*Label 107*/ 515,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 108*/ 484, // Rule ID 22173 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22173,
        GIR_Done,
      // Label 108: @484
      GIM_Try, /*On fail goto*//*Label 109*/ 514, // Rule ID 22174 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22174,
        GIR_Done,
      // Label 109: @514
      GIM_Reject,
    // Label 107: @515
    GIM_Reject,
    // Label 77: @516
    GIM_Try, /*On fail goto*//*Label 110*/ 599,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 111*/ 568, // Rule ID 22181 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22181,
        GIR_Done,
      // Label 111: @568
      GIM_Try, /*On fail goto*//*Label 112*/ 598, // Rule ID 22182 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22182,
        GIR_Done,
      // Label 112: @598
      GIM_Reject,
    // Label 110: @599
    GIM_Reject,
    // Label 78: @600
    GIM_Try, /*On fail goto*//*Label 113*/ 683,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 114*/ 652, // Rule ID 22197 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22197,
        GIR_Done,
      // Label 114: @652
      GIM_Try, /*On fail goto*//*Label 115*/ 682, // Rule ID 22198 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22198,
        GIR_Done,
      // Label 115: @682
      GIM_Reject,
    // Label 113: @683
    GIM_Reject,
    // Label 79: @684
    GIM_Try, /*On fail goto*//*Label 116*/ 767,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 117*/ 736, // Rule ID 22165 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22165,
        GIR_Done,
      // Label 117: @736
      GIM_Try, /*On fail goto*//*Label 118*/ 766, // Rule ID 22166 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22166,
        GIR_Done,
      // Label 118: @766
      GIM_Reject,
    // Label 116: @767
    GIM_Reject,
    // Label 80: @768
    GIM_Try, /*On fail goto*//*Label 119*/ 851,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 120*/ 820, // Rule ID 22177 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22177,
        GIR_Done,
      // Label 120: @820
      GIM_Try, /*On fail goto*//*Label 121*/ 850, // Rule ID 22178 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22178,
        GIR_Done,
      // Label 121: @850
      GIM_Reject,
    // Label 119: @851
    GIM_Reject,
    // Label 81: @852
    GIM_Try, /*On fail goto*//*Label 122*/ 935,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 123*/ 904, // Rule ID 22193 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22193,
        GIR_Done,
      // Label 123: @904
      GIM_Try, /*On fail goto*//*Label 124*/ 934, // Rule ID 22194 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22194,
        GIR_Done,
      // Label 124: @934
      GIM_Reject,
    // Label 122: @935
    GIM_Reject,
    // Label 82: @936
    GIM_Try, /*On fail goto*//*Label 125*/ 1019,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 126*/ 988, // Rule ID 22237 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22237,
        GIR_Done,
      // Label 126: @988
      GIM_Try, /*On fail goto*//*Label 127*/ 1018, // Rule ID 22238 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22238,
        GIR_Done,
      // Label 127: @1018
      GIM_Reject,
    // Label 125: @1019
    GIM_Reject,
    // Label 83: @1020
    GIM_Try, /*On fail goto*//*Label 128*/ 1103,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 129*/ 1072, // Rule ID 22169 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22169,
        GIR_Done,
      // Label 129: @1072
      GIM_Try, /*On fail goto*//*Label 130*/ 1102, // Rule ID 22170 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22170,
        GIR_Done,
      // Label 130: @1102
      GIM_Reject,
    // Label 128: @1103
    GIM_Reject,
    // Label 84: @1104
    GIM_Try, /*On fail goto*//*Label 131*/ 1187,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 132*/ 1156, // Rule ID 22189 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22189,
        GIR_Done,
      // Label 132: @1156
      GIM_Try, /*On fail goto*//*Label 133*/ 1186, // Rule ID 22190 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22190,
        GIR_Done,
      // Label 133: @1186
      GIM_Reject,
    // Label 131: @1187
    GIM_Reject,
    // Label 85: @1188
    GIM_Try, /*On fail goto*//*Label 134*/ 1271,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 135*/ 1240, // Rule ID 22225 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22225,
        GIR_Done,
      // Label 135: @1240
      GIM_Try, /*On fail goto*//*Label 136*/ 1270, // Rule ID 22226 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22226,
        GIR_Done,
      // Label 136: @1270
      GIM_Reject,
    // Label 134: @1271
    GIM_Reject,
    // Label 86: @1272
    GIM_Try, /*On fail goto*//*Label 137*/ 1355,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 138*/ 1324, // Rule ID 22241 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22241,
        GIR_Done,
      // Label 138: @1324
      GIM_Try, /*On fail goto*//*Label 139*/ 1354, // Rule ID 22242 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22242,
        GIR_Done,
      // Label 139: @1354
      GIM_Reject,
    // Label 137: @1355
    GIM_Reject,
    // Label 87: @1356
    GIM_Try, /*On fail goto*//*Label 140*/ 1439,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 141*/ 1408, // Rule ID 22185 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22185,
        GIR_Done,
      // Label 141: @1408
      GIM_Try, /*On fail goto*//*Label 142*/ 1438, // Rule ID 22186 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22186,
        GIR_Done,
      // Label 142: @1438
      GIM_Reject,
    // Label 140: @1439
    GIM_Reject,
    // Label 88: @1440
    GIM_Try, /*On fail goto*//*Label 143*/ 1523,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 144*/ 1492, // Rule ID 22213 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22213,
        GIR_Done,
      // Label 144: @1492
      GIM_Try, /*On fail goto*//*Label 145*/ 1522, // Rule ID 22214 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22214,
        GIR_Done,
      // Label 145: @1522
      GIM_Reject,
    // Label 143: @1523
    GIM_Reject,
    // Label 89: @1524
    GIM_Try, /*On fail goto*//*Label 146*/ 1607,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 147*/ 1576, // Rule ID 22229 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22229,
        GIR_Done,
      // Label 147: @1576
      GIM_Try, /*On fail goto*//*Label 148*/ 1606, // Rule ID 22230 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22230,
        GIR_Done,
      // Label 148: @1606
      GIM_Reject,
    // Label 146: @1607
    GIM_Reject,
    // Label 90: @1608
    GIM_Try, /*On fail goto*//*Label 149*/ 1691,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 150*/ 1660, // Rule ID 22245 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22245,
        GIR_Done,
      // Label 150: @1660
      GIM_Try, /*On fail goto*//*Label 151*/ 1690, // Rule ID 22246 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22246,
        GIR_Done,
      // Label 151: @1690
      GIM_Reject,
    // Label 149: @1691
    GIM_Reject,
    // Label 91: @1692
    GIM_Try, /*On fail goto*//*Label 152*/ 1775,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 153*/ 1744, // Rule ID 22201 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22201,
        GIR_Done,
      // Label 153: @1744
      GIM_Try, /*On fail goto*//*Label 154*/ 1774, // Rule ID 22202 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22202,
        GIR_Done,
      // Label 154: @1774
      GIM_Reject,
    // Label 152: @1775
    GIM_Reject,
    // Label 92: @1776
    GIM_Try, /*On fail goto*//*Label 155*/ 1859,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 156*/ 1828, // Rule ID 22217 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22217,
        GIR_Done,
      // Label 156: @1828
      GIM_Try, /*On fail goto*//*Label 157*/ 1858, // Rule ID 22218 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22218,
        GIR_Done,
      // Label 157: @1858
      GIM_Reject,
    // Label 155: @1859
    GIM_Reject,
    // Label 93: @1860
    GIM_Try, /*On fail goto*//*Label 158*/ 1943,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 159*/ 1912, // Rule ID 22233 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22233,
        GIR_Done,
      // Label 159: @1912
      GIM_Try, /*On fail goto*//*Label 160*/ 1942, // Rule ID 22234 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22234,
        GIR_Done,
      // Label 160: @1942
      GIM_Reject,
    // Label 158: @1943
    GIM_Reject,
    // Label 94: @1944
    GIM_Try, /*On fail goto*//*Label 161*/ 2027,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 162*/ 1996, // Rule ID 22205 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22205,
        GIR_Done,
      // Label 162: @1996
      GIM_Try, /*On fail goto*//*Label 163*/ 2026, // Rule ID 22206 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22206,
        GIR_Done,
      // Label 163: @2026
      GIM_Reject,
    // Label 161: @2027
    GIM_Reject,
    // Label 95: @2028
    GIM_Try, /*On fail goto*//*Label 164*/ 2111,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 165*/ 2080, // Rule ID 22221 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22221,
        GIR_Done,
      // Label 165: @2080
      GIM_Try, /*On fail goto*//*Label 166*/ 2110, // Rule ID 22222 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22222,
        GIR_Done,
      // Label 166: @2110
      GIM_Reject,
    // Label 164: @2111
    GIM_Reject,
    // Label 96: @2112
    GIM_Try, /*On fail goto*//*Label 167*/ 2195,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 168*/ 2164, // Rule ID 22209 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22209,
        GIR_Done,
      // Label 168: @2164
      GIM_Try, /*On fail goto*//*Label 169*/ 2194, // Rule ID 22210 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22210,
        GIR_Done,
      // Label 169: @2194
      GIM_Reject,
    // Label 167: @2195
    GIM_Reject,
    // Label 97: @2196
    GIM_Reject,
    // Label 1: @2197
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 194*/ 4142,
    /*GILLT_s32*//*Label 170*/ 2234,
    /*GILLT_s64*//*Label 171*/ 2264, 0,
    /*GILLT_nxv1s8*//*Label 172*/ 2294,
    /*GILLT_nxv1s16*//*Label 173*/ 2378,
    /*GILLT_nxv1s32*//*Label 174*/ 2462,
    /*GILLT_nxv1s64*//*Label 175*/ 2546, 0,
    /*GILLT_nxv2s8*//*Label 176*/ 2630,
    /*GILLT_nxv2s16*//*Label 177*/ 2714,
    /*GILLT_nxv2s32*//*Label 178*/ 2798,
    /*GILLT_nxv2s64*//*Label 179*/ 2882, 0,
    /*GILLT_nxv4s8*//*Label 180*/ 2966,
    /*GILLT_nxv4s16*//*Label 181*/ 3050,
    /*GILLT_nxv4s32*//*Label 182*/ 3134,
    /*GILLT_nxv4s64*//*Label 183*/ 3218, 0,
    /*GILLT_nxv8s8*//*Label 184*/ 3302,
    /*GILLT_nxv8s16*//*Label 185*/ 3386,
    /*GILLT_nxv8s32*//*Label 186*/ 3470,
    /*GILLT_nxv8s64*//*Label 187*/ 3554, 0,
    /*GILLT_nxv16s8*//*Label 188*/ 3638,
    /*GILLT_nxv16s16*//*Label 189*/ 3722,
    /*GILLT_nxv16s32*//*Label 190*/ 3806, 0,
    /*GILLT_nxv32s8*//*Label 191*/ 3890,
    /*GILLT_nxv32s16*//*Label 192*/ 3974, 0,
    /*GILLT_nxv64s8*//*Label 193*/ 4058,
    // Label 170: @2234
    GIM_Try, /*On fail goto*//*Label 195*/ 2263, // Rule ID 49088 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (SUB:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::SUB,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 49088,
      GIR_Done,
    // Label 195: @2263
    GIM_Reject,
    // Label 171: @2264
    GIM_Try, /*On fail goto*//*Label 196*/ 2293, // Rule ID 49087 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (sub:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (SUB:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::SUB,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 49087,
      GIR_Done,
    // Label 196: @2293
    GIM_Reject,
    // Label 172: @2294
    GIM_Try, /*On fail goto*//*Label 197*/ 2377,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 198*/ 2346, // Rule ID 22291 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVSUB_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22291,
        GIR_Done,
      // Label 198: @2346
      GIM_Try, /*On fail goto*//*Label 199*/ 2376, // Rule ID 22292 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVSUB_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22292,
        GIR_Done,
      // Label 199: @2376
      GIM_Reject,
    // Label 197: @2377
    GIM_Reject,
    // Label 173: @2378
    GIM_Try, /*On fail goto*//*Label 200*/ 2461,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 201*/ 2430, // Rule ID 22303 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22303,
        GIR_Done,
      // Label 201: @2430
      GIM_Try, /*On fail goto*//*Label 202*/ 2460, // Rule ID 22304 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22304,
        GIR_Done,
      // Label 202: @2460
      GIM_Reject,
    // Label 200: @2461
    GIM_Reject,
    // Label 174: @2462
    GIM_Try, /*On fail goto*//*Label 203*/ 2545,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 204*/ 2514, // Rule ID 22311 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22311,
        GIR_Done,
      // Label 204: @2514
      GIM_Try, /*On fail goto*//*Label 205*/ 2544, // Rule ID 22312 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22312,
        GIR_Done,
      // Label 205: @2544
      GIM_Reject,
    // Label 203: @2545
    GIM_Reject,
    // Label 175: @2546
    GIM_Try, /*On fail goto*//*Label 206*/ 2629,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 207*/ 2598, // Rule ID 22327 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22327,
        GIR_Done,
      // Label 207: @2598
      GIM_Try, /*On fail goto*//*Label 208*/ 2628, // Rule ID 22328 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22328,
        GIR_Done,
      // Label 208: @2628
      GIM_Reject,
    // Label 206: @2629
    GIM_Reject,
    // Label 176: @2630
    GIM_Try, /*On fail goto*//*Label 209*/ 2713,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 210*/ 2682, // Rule ID 22295 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22295,
        GIR_Done,
      // Label 210: @2682
      GIM_Try, /*On fail goto*//*Label 211*/ 2712, // Rule ID 22296 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22296,
        GIR_Done,
      // Label 211: @2712
      GIM_Reject,
    // Label 209: @2713
    GIM_Reject,
    // Label 177: @2714
    GIM_Try, /*On fail goto*//*Label 212*/ 2797,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 213*/ 2766, // Rule ID 22307 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22307,
        GIR_Done,
      // Label 213: @2766
      GIM_Try, /*On fail goto*//*Label 214*/ 2796, // Rule ID 22308 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22308,
        GIR_Done,
      // Label 214: @2796
      GIM_Reject,
    // Label 212: @2797
    GIM_Reject,
    // Label 178: @2798
    GIM_Try, /*On fail goto*//*Label 215*/ 2881,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 216*/ 2850, // Rule ID 22323 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22323,
        GIR_Done,
      // Label 216: @2850
      GIM_Try, /*On fail goto*//*Label 217*/ 2880, // Rule ID 22324 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22324,
        GIR_Done,
      // Label 217: @2880
      GIM_Reject,
    // Label 215: @2881
    GIM_Reject,
    // Label 179: @2882
    GIM_Try, /*On fail goto*//*Label 218*/ 2965,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 219*/ 2934, // Rule ID 22367 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22367,
        GIR_Done,
      // Label 219: @2934
      GIM_Try, /*On fail goto*//*Label 220*/ 2964, // Rule ID 22368 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22368,
        GIR_Done,
      // Label 220: @2964
      GIM_Reject,
    // Label 218: @2965
    GIM_Reject,
    // Label 180: @2966
    GIM_Try, /*On fail goto*//*Label 221*/ 3049,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 222*/ 3018, // Rule ID 22299 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22299,
        GIR_Done,
      // Label 222: @3018
      GIM_Try, /*On fail goto*//*Label 223*/ 3048, // Rule ID 22300 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22300,
        GIR_Done,
      // Label 223: @3048
      GIM_Reject,
    // Label 221: @3049
    GIM_Reject,
    // Label 181: @3050
    GIM_Try, /*On fail goto*//*Label 224*/ 3133,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 225*/ 3102, // Rule ID 22319 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22319,
        GIR_Done,
      // Label 225: @3102
      GIM_Try, /*On fail goto*//*Label 226*/ 3132, // Rule ID 22320 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22320,
        GIR_Done,
      // Label 226: @3132
      GIM_Reject,
    // Label 224: @3133
    GIM_Reject,
    // Label 182: @3134
    GIM_Try, /*On fail goto*//*Label 227*/ 3217,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 228*/ 3186, // Rule ID 22355 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22355,
        GIR_Done,
      // Label 228: @3186
      GIM_Try, /*On fail goto*//*Label 229*/ 3216, // Rule ID 22356 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22356,
        GIR_Done,
      // Label 229: @3216
      GIM_Reject,
    // Label 227: @3217
    GIM_Reject,
    // Label 183: @3218
    GIM_Try, /*On fail goto*//*Label 230*/ 3301,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 231*/ 3270, // Rule ID 22371 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22371,
        GIR_Done,
      // Label 231: @3270
      GIM_Try, /*On fail goto*//*Label 232*/ 3300, // Rule ID 22372 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22372,
        GIR_Done,
      // Label 232: @3300
      GIM_Reject,
    // Label 230: @3301
    GIM_Reject,
    // Label 184: @3302
    GIM_Try, /*On fail goto*//*Label 233*/ 3385,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 234*/ 3354, // Rule ID 22315 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22315,
        GIR_Done,
      // Label 234: @3354
      GIM_Try, /*On fail goto*//*Label 235*/ 3384, // Rule ID 22316 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22316,
        GIR_Done,
      // Label 235: @3384
      GIM_Reject,
    // Label 233: @3385
    GIM_Reject,
    // Label 185: @3386
    GIM_Try, /*On fail goto*//*Label 236*/ 3469,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 237*/ 3438, // Rule ID 22343 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22343,
        GIR_Done,
      // Label 237: @3438
      GIM_Try, /*On fail goto*//*Label 238*/ 3468, // Rule ID 22344 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22344,
        GIR_Done,
      // Label 238: @3468
      GIM_Reject,
    // Label 236: @3469
    GIM_Reject,
    // Label 186: @3470
    GIM_Try, /*On fail goto*//*Label 239*/ 3553,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 240*/ 3522, // Rule ID 22359 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22359,
        GIR_Done,
      // Label 240: @3522
      GIM_Try, /*On fail goto*//*Label 241*/ 3552, // Rule ID 22360 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22360,
        GIR_Done,
      // Label 241: @3552
      GIM_Reject,
    // Label 239: @3553
    GIM_Reject,
    // Label 187: @3554
    GIM_Try, /*On fail goto*//*Label 242*/ 3637,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 243*/ 3606, // Rule ID 22375 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22375,
        GIR_Done,
      // Label 243: @3606
      GIM_Try, /*On fail goto*//*Label 244*/ 3636, // Rule ID 22376 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22376,
        GIR_Done,
      // Label 244: @3636
      GIM_Reject,
    // Label 242: @3637
    GIM_Reject,
    // Label 188: @3638
    GIM_Try, /*On fail goto*//*Label 245*/ 3721,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 246*/ 3690, // Rule ID 22331 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22331,
        GIR_Done,
      // Label 246: @3690
      GIM_Try, /*On fail goto*//*Label 247*/ 3720, // Rule ID 22332 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22332,
        GIR_Done,
      // Label 247: @3720
      GIM_Reject,
    // Label 245: @3721
    GIM_Reject,
    // Label 189: @3722
    GIM_Try, /*On fail goto*//*Label 248*/ 3805,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 249*/ 3774, // Rule ID 22347 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22347,
        GIR_Done,
      // Label 249: @3774
      GIM_Try, /*On fail goto*//*Label 250*/ 3804, // Rule ID 22348 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22348,
        GIR_Done,
      // Label 250: @3804
      GIM_Reject,
    // Label 248: @3805
    GIM_Reject,
    // Label 190: @3806
    GIM_Try, /*On fail goto*//*Label 251*/ 3889,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 252*/ 3858, // Rule ID 22363 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22363,
        GIR_Done,
      // Label 252: @3858
      GIM_Try, /*On fail goto*//*Label 253*/ 3888, // Rule ID 22364 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22364,
        GIR_Done,
      // Label 253: @3888
      GIM_Reject,
    // Label 251: @3889
    GIM_Reject,
    // Label 191: @3890
    GIM_Try, /*On fail goto*//*Label 254*/ 3973,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 255*/ 3942, // Rule ID 22335 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22335,
        GIR_Done,
      // Label 255: @3942
      GIM_Try, /*On fail goto*//*Label 256*/ 3972, // Rule ID 22336 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22336,
        GIR_Done,
      // Label 256: @3972
      GIM_Reject,
    // Label 254: @3973
    GIM_Reject,
    // Label 192: @3974
    GIM_Try, /*On fail goto*//*Label 257*/ 4057,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 258*/ 4026, // Rule ID 22351 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22351,
        GIR_Done,
      // Label 258: @4026
      GIM_Try, /*On fail goto*//*Label 259*/ 4056, // Rule ID 22352 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22352,
        GIR_Done,
      // Label 259: @4056
      GIM_Reject,
    // Label 257: @4057
    GIM_Reject,
    // Label 193: @4058
    GIM_Try, /*On fail goto*//*Label 260*/ 4141,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 261*/ 4110, // Rule ID 22339 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22339,
        GIR_Done,
      // Label 261: @4110
      GIM_Try, /*On fail goto*//*Label 262*/ 4140, // Rule ID 22340 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22340,
        GIR_Done,
      // Label 262: @4140
      GIM_Reject,
    // Label 260: @4141
    GIM_Reject,
    // Label 194: @4142
    GIM_Reject,
    // Label 2: @4143
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 287*/ 6207,
    /*GILLT_s32*//*Label 263*/ 4180,
    /*GILLT_s64*//*Label 264*/ 4212, 0,
    /*GILLT_nxv1s8*//*Label 265*/ 4359,
    /*GILLT_nxv1s16*//*Label 266*/ 4443,
    /*GILLT_nxv1s32*//*Label 267*/ 4527,
    /*GILLT_nxv1s64*//*Label 268*/ 4611, 0,
    /*GILLT_nxv2s8*//*Label 269*/ 4695,
    /*GILLT_nxv2s16*//*Label 270*/ 4779,
    /*GILLT_nxv2s32*//*Label 271*/ 4863,
    /*GILLT_nxv2s64*//*Label 272*/ 4947, 0,
    /*GILLT_nxv4s8*//*Label 273*/ 5031,
    /*GILLT_nxv4s16*//*Label 274*/ 5115,
    /*GILLT_nxv4s32*//*Label 275*/ 5199,
    /*GILLT_nxv4s64*//*Label 276*/ 5283, 0,
    /*GILLT_nxv8s8*//*Label 277*/ 5367,
    /*GILLT_nxv8s16*//*Label 278*/ 5451,
    /*GILLT_nxv8s32*//*Label 279*/ 5535,
    /*GILLT_nxv8s64*//*Label 280*/ 5619, 0,
    /*GILLT_nxv16s8*//*Label 281*/ 5703,
    /*GILLT_nxv16s16*//*Label 282*/ 5787,
    /*GILLT_nxv16s32*//*Label 283*/ 5871, 0,
    /*GILLT_nxv32s8*//*Label 284*/ 5955,
    /*GILLT_nxv32s16*//*Label 285*/ 6039, 0,
    /*GILLT_nxv64s8*//*Label 286*/ 6123,
    // Label 263: @4180
    GIM_Try, /*On fail goto*//*Label 288*/ 4211, // Rule ID 49289 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (MUL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::MUL,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 49289,
      GIR_Done,
    // Label 288: @4211
    GIM_Reject,
    // Label 264: @4212
    GIM_Try, /*On fail goto*//*Label 289*/ 4358,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 290*/ 4338, // Rule ID 49312 //
        GIM_CheckFeatures, GIFBS_HasStdExtM_IsRV64_NotHasStdExtZba,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294967295,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 4294967295,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 4294967295:{ *:[i64] }))  =>  (MULHU:{ *:[i64] } (SLLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 32:{ *:[i64] }), (SLLI:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 32:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/RISCV::SLLI,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_AddImm, /*InsnID*/2, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SLLI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/1, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::MULHU,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49312,
        GIR_Done,
      // Label 290: @4338
      GIM_Try, /*On fail goto*//*Label 291*/ 4357, // Rule ID 49288 //
        GIM_CheckFeatures, GIFBS_HasStdExtM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (MUL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::MUL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49288,
        GIR_Done,
      // Label 291: @4357
      GIM_Reject,
    // Label 289: @4358
    GIM_Reject,
    // Label 265: @4359
    GIM_Try, /*On fail goto*//*Label 292*/ 4442,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 293*/ 4411, // Rule ID 25763 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVMUL_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25763,
        GIR_Done,
      // Label 293: @4411
      GIM_Try, /*On fail goto*//*Label 294*/ 4441, // Rule ID 25764 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVMUL_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25764,
        GIR_Done,
      // Label 294: @4441
      GIM_Reject,
    // Label 292: @4442
    GIM_Reject,
    // Label 266: @4443
    GIM_Try, /*On fail goto*//*Label 295*/ 4526,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 296*/ 4495, // Rule ID 25775 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25775,
        GIR_Done,
      // Label 296: @4495
      GIM_Try, /*On fail goto*//*Label 297*/ 4525, // Rule ID 25776 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25776,
        GIR_Done,
      // Label 297: @4525
      GIM_Reject,
    // Label 295: @4526
    GIM_Reject,
    // Label 267: @4527
    GIM_Try, /*On fail goto*//*Label 298*/ 4610,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 299*/ 4579, // Rule ID 25783 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25783,
        GIR_Done,
      // Label 299: @4579
      GIM_Try, /*On fail goto*//*Label 300*/ 4609, // Rule ID 25784 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25784,
        GIR_Done,
      // Label 300: @4609
      GIM_Reject,
    // Label 298: @4610
    GIM_Reject,
    // Label 268: @4611
    GIM_Try, /*On fail goto*//*Label 301*/ 4694,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 302*/ 4663, // Rule ID 25799 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25799,
        GIR_Done,
      // Label 302: @4663
      GIM_Try, /*On fail goto*//*Label 303*/ 4693, // Rule ID 25800 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25800,
        GIR_Done,
      // Label 303: @4693
      GIM_Reject,
    // Label 301: @4694
    GIM_Reject,
    // Label 269: @4695
    GIM_Try, /*On fail goto*//*Label 304*/ 4778,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 305*/ 4747, // Rule ID 25767 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25767,
        GIR_Done,
      // Label 305: @4747
      GIM_Try, /*On fail goto*//*Label 306*/ 4777, // Rule ID 25768 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25768,
        GIR_Done,
      // Label 306: @4777
      GIM_Reject,
    // Label 304: @4778
    GIM_Reject,
    // Label 270: @4779
    GIM_Try, /*On fail goto*//*Label 307*/ 4862,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 308*/ 4831, // Rule ID 25779 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25779,
        GIR_Done,
      // Label 308: @4831
      GIM_Try, /*On fail goto*//*Label 309*/ 4861, // Rule ID 25780 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25780,
        GIR_Done,
      // Label 309: @4861
      GIM_Reject,
    // Label 307: @4862
    GIM_Reject,
    // Label 271: @4863
    GIM_Try, /*On fail goto*//*Label 310*/ 4946,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 311*/ 4915, // Rule ID 25795 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25795,
        GIR_Done,
      // Label 311: @4915
      GIM_Try, /*On fail goto*//*Label 312*/ 4945, // Rule ID 25796 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25796,
        GIR_Done,
      // Label 312: @4945
      GIM_Reject,
    // Label 310: @4946
    GIM_Reject,
    // Label 272: @4947
    GIM_Try, /*On fail goto*//*Label 313*/ 5030,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 314*/ 4999, // Rule ID 25839 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25839,
        GIR_Done,
      // Label 314: @4999
      GIM_Try, /*On fail goto*//*Label 315*/ 5029, // Rule ID 25840 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25840,
        GIR_Done,
      // Label 315: @5029
      GIM_Reject,
    // Label 313: @5030
    GIM_Reject,
    // Label 273: @5031
    GIM_Try, /*On fail goto*//*Label 316*/ 5114,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 317*/ 5083, // Rule ID 25771 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25771,
        GIR_Done,
      // Label 317: @5083
      GIM_Try, /*On fail goto*//*Label 318*/ 5113, // Rule ID 25772 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25772,
        GIR_Done,
      // Label 318: @5113
      GIM_Reject,
    // Label 316: @5114
    GIM_Reject,
    // Label 274: @5115
    GIM_Try, /*On fail goto*//*Label 319*/ 5198,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 320*/ 5167, // Rule ID 25791 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25791,
        GIR_Done,
      // Label 320: @5167
      GIM_Try, /*On fail goto*//*Label 321*/ 5197, // Rule ID 25792 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25792,
        GIR_Done,
      // Label 321: @5197
      GIM_Reject,
    // Label 319: @5198
    GIM_Reject,
    // Label 275: @5199
    GIM_Try, /*On fail goto*//*Label 322*/ 5282,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 323*/ 5251, // Rule ID 25827 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25827,
        GIR_Done,
      // Label 323: @5251
      GIM_Try, /*On fail goto*//*Label 324*/ 5281, // Rule ID 25828 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25828,
        GIR_Done,
      // Label 324: @5281
      GIM_Reject,
    // Label 322: @5282
    GIM_Reject,
    // Label 276: @5283
    GIM_Try, /*On fail goto*//*Label 325*/ 5366,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 326*/ 5335, // Rule ID 25843 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25843,
        GIR_Done,
      // Label 326: @5335
      GIM_Try, /*On fail goto*//*Label 327*/ 5365, // Rule ID 25844 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25844,
        GIR_Done,
      // Label 327: @5365
      GIM_Reject,
    // Label 325: @5366
    GIM_Reject,
    // Label 277: @5367
    GIM_Try, /*On fail goto*//*Label 328*/ 5450,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 329*/ 5419, // Rule ID 25787 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25787,
        GIR_Done,
      // Label 329: @5419
      GIM_Try, /*On fail goto*//*Label 330*/ 5449, // Rule ID 25788 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25788,
        GIR_Done,
      // Label 330: @5449
      GIM_Reject,
    // Label 328: @5450
    GIM_Reject,
    // Label 278: @5451
    GIM_Try, /*On fail goto*//*Label 331*/ 5534,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 332*/ 5503, // Rule ID 25815 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25815,
        GIR_Done,
      // Label 332: @5503
      GIM_Try, /*On fail goto*//*Label 333*/ 5533, // Rule ID 25816 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25816,
        GIR_Done,
      // Label 333: @5533
      GIM_Reject,
    // Label 331: @5534
    GIM_Reject,
    // Label 279: @5535
    GIM_Try, /*On fail goto*//*Label 334*/ 5618,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 335*/ 5587, // Rule ID 25831 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25831,
        GIR_Done,
      // Label 335: @5587
      GIM_Try, /*On fail goto*//*Label 336*/ 5617, // Rule ID 25832 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25832,
        GIR_Done,
      // Label 336: @5617
      GIM_Reject,
    // Label 334: @5618
    GIM_Reject,
    // Label 280: @5619
    GIM_Try, /*On fail goto*//*Label 337*/ 5702,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 338*/ 5671, // Rule ID 25847 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25847,
        GIR_Done,
      // Label 338: @5671
      GIM_Try, /*On fail goto*//*Label 339*/ 5701, // Rule ID 25848 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25848,
        GIR_Done,
      // Label 339: @5701
      GIM_Reject,
    // Label 337: @5702
    GIM_Reject,
    // Label 281: @5703
    GIM_Try, /*On fail goto*//*Label 340*/ 5786,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 341*/ 5755, // Rule ID 25803 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25803,
        GIR_Done,
      // Label 341: @5755
      GIM_Try, /*On fail goto*//*Label 342*/ 5785, // Rule ID 25804 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25804,
        GIR_Done,
      // Label 342: @5785
      GIM_Reject,
    // Label 340: @5786
    GIM_Reject,
    // Label 282: @5787
    GIM_Try, /*On fail goto*//*Label 343*/ 5870,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 344*/ 5839, // Rule ID 25819 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25819,
        GIR_Done,
      // Label 344: @5839
      GIM_Try, /*On fail goto*//*Label 345*/ 5869, // Rule ID 25820 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25820,
        GIR_Done,
      // Label 345: @5869
      GIM_Reject,
    // Label 343: @5870
    GIM_Reject,
    // Label 283: @5871
    GIM_Try, /*On fail goto*//*Label 346*/ 5954,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 347*/ 5923, // Rule ID 25835 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25835,
        GIR_Done,
      // Label 347: @5923
      GIM_Try, /*On fail goto*//*Label 348*/ 5953, // Rule ID 25836 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25836,
        GIR_Done,
      // Label 348: @5953
      GIM_Reject,
    // Label 346: @5954
    GIM_Reject,
    // Label 284: @5955
    GIM_Try, /*On fail goto*//*Label 349*/ 6038,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 350*/ 6007, // Rule ID 25807 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25807,
        GIR_Done,
      // Label 350: @6007
      GIM_Try, /*On fail goto*//*Label 351*/ 6037, // Rule ID 25808 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25808,
        GIR_Done,
      // Label 351: @6037
      GIM_Reject,
    // Label 349: @6038
    GIM_Reject,
    // Label 285: @6039
    GIM_Try, /*On fail goto*//*Label 352*/ 6122,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 353*/ 6091, // Rule ID 25823 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25823,
        GIR_Done,
      // Label 353: @6091
      GIM_Try, /*On fail goto*//*Label 354*/ 6121, // Rule ID 25824 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25824,
        GIR_Done,
      // Label 354: @6121
      GIM_Reject,
    // Label 352: @6122
    GIM_Reject,
    // Label 286: @6123
    GIM_Try, /*On fail goto*//*Label 355*/ 6206,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 356*/ 6175, // Rule ID 25811 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25811,
        GIR_Done,
      // Label 356: @6175
      GIM_Try, /*On fail goto*//*Label 357*/ 6205, // Rule ID 25812 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 25812,
        GIR_Done,
      // Label 357: @6205
      GIM_Reject,
    // Label 355: @6206
    GIM_Reject,
    // Label 287: @6207
    GIM_Reject,
    // Label 3: @6208
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 382*/ 8157,
    /*GILLT_s32*//*Label 358*/ 6245,
    /*GILLT_s64*//*Label 359*/ 6277, 0,
    /*GILLT_nxv1s8*//*Label 360*/ 6309,
    /*GILLT_nxv1s16*//*Label 361*/ 6393,
    /*GILLT_nxv1s32*//*Label 362*/ 6477,
    /*GILLT_nxv1s64*//*Label 363*/ 6561, 0,
    /*GILLT_nxv2s8*//*Label 364*/ 6645,
    /*GILLT_nxv2s16*//*Label 365*/ 6729,
    /*GILLT_nxv2s32*//*Label 366*/ 6813,
    /*GILLT_nxv2s64*//*Label 367*/ 6897, 0,
    /*GILLT_nxv4s8*//*Label 368*/ 6981,
    /*GILLT_nxv4s16*//*Label 369*/ 7065,
    /*GILLT_nxv4s32*//*Label 370*/ 7149,
    /*GILLT_nxv4s64*//*Label 371*/ 7233, 0,
    /*GILLT_nxv8s8*//*Label 372*/ 7317,
    /*GILLT_nxv8s16*//*Label 373*/ 7401,
    /*GILLT_nxv8s32*//*Label 374*/ 7485,
    /*GILLT_nxv8s64*//*Label 375*/ 7569, 0,
    /*GILLT_nxv16s8*//*Label 376*/ 7653,
    /*GILLT_nxv16s16*//*Label 377*/ 7737,
    /*GILLT_nxv16s32*//*Label 378*/ 7821, 0,
    /*GILLT_nxv32s8*//*Label 379*/ 7905,
    /*GILLT_nxv32s16*//*Label 380*/ 7989, 0,
    /*GILLT_nxv64s8*//*Label 381*/ 8073,
    // Label 358: @6245
    GIM_Try, /*On fail goto*//*Label 383*/ 6276, // Rule ID 49297 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (sdiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIV:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::DIV,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 49297,
      GIR_Done,
    // Label 383: @6276
    GIM_Reject,
    // Label 359: @6277
    GIM_Try, /*On fail goto*//*Label 384*/ 6308, // Rule ID 49296 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (sdiv:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (DIV:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::DIV,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 49296,
      GIR_Done,
    // Label 384: @6308
    GIM_Reject,
    // Label 360: @6309
    GIM_Try, /*On fail goto*//*Label 385*/ 6392,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 386*/ 6361, // Rule ID 26115 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIV_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26115,
        GIR_Done,
      // Label 386: @6361
      GIM_Try, /*On fail goto*//*Label 387*/ 6391, // Rule ID 26116 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIV_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26116,
        GIR_Done,
      // Label 387: @6391
      GIM_Reject,
    // Label 385: @6392
    GIM_Reject,
    // Label 361: @6393
    GIM_Try, /*On fail goto*//*Label 388*/ 6476,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 389*/ 6445, // Rule ID 26127 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIV_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26127,
        GIR_Done,
      // Label 389: @6445
      GIM_Try, /*On fail goto*//*Label 390*/ 6475, // Rule ID 26128 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIV_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26128,
        GIR_Done,
      // Label 390: @6475
      GIM_Reject,
    // Label 388: @6476
    GIM_Reject,
    // Label 362: @6477
    GIM_Try, /*On fail goto*//*Label 391*/ 6560,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 392*/ 6529, // Rule ID 26135 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIV_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26135,
        GIR_Done,
      // Label 392: @6529
      GIM_Try, /*On fail goto*//*Label 393*/ 6559, // Rule ID 26136 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIV_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26136,
        GIR_Done,
      // Label 393: @6559
      GIM_Reject,
    // Label 391: @6560
    GIM_Reject,
    // Label 363: @6561
    GIM_Try, /*On fail goto*//*Label 394*/ 6644,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 395*/ 6613, // Rule ID 26151 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26151,
        GIR_Done,
      // Label 395: @6613
      GIM_Try, /*On fail goto*//*Label 396*/ 6643, // Rule ID 26152 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26152,
        GIR_Done,
      // Label 396: @6643
      GIM_Reject,
    // Label 394: @6644
    GIM_Reject,
    // Label 364: @6645
    GIM_Try, /*On fail goto*//*Label 397*/ 6728,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 398*/ 6697, // Rule ID 26119 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIV_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26119,
        GIR_Done,
      // Label 398: @6697
      GIM_Try, /*On fail goto*//*Label 399*/ 6727, // Rule ID 26120 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIV_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26120,
        GIR_Done,
      // Label 399: @6727
      GIM_Reject,
    // Label 397: @6728
    GIM_Reject,
    // Label 365: @6729
    GIM_Try, /*On fail goto*//*Label 400*/ 6812,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 401*/ 6781, // Rule ID 26131 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIV_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26131,
        GIR_Done,
      // Label 401: @6781
      GIM_Try, /*On fail goto*//*Label 402*/ 6811, // Rule ID 26132 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIV_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26132,
        GIR_Done,
      // Label 402: @6811
      GIM_Reject,
    // Label 400: @6812
    GIM_Reject,
    // Label 366: @6813
    GIM_Try, /*On fail goto*//*Label 403*/ 6896,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 404*/ 6865, // Rule ID 26147 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26147,
        GIR_Done,
      // Label 404: @6865
      GIM_Try, /*On fail goto*//*Label 405*/ 6895, // Rule ID 26148 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26148,
        GIR_Done,
      // Label 405: @6895
      GIM_Reject,
    // Label 403: @6896
    GIM_Reject,
    // Label 367: @6897
    GIM_Try, /*On fail goto*//*Label 406*/ 6980,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 407*/ 6949, // Rule ID 26191 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26191,
        GIR_Done,
      // Label 407: @6949
      GIM_Try, /*On fail goto*//*Label 408*/ 6979, // Rule ID 26192 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26192,
        GIR_Done,
      // Label 408: @6979
      GIM_Reject,
    // Label 406: @6980
    GIM_Reject,
    // Label 368: @6981
    GIM_Try, /*On fail goto*//*Label 409*/ 7064,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 410*/ 7033, // Rule ID 26123 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIV_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26123,
        GIR_Done,
      // Label 410: @7033
      GIM_Try, /*On fail goto*//*Label 411*/ 7063, // Rule ID 26124 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIV_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26124,
        GIR_Done,
      // Label 411: @7063
      GIM_Reject,
    // Label 409: @7064
    GIM_Reject,
    // Label 369: @7065
    GIM_Try, /*On fail goto*//*Label 412*/ 7148,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 413*/ 7117, // Rule ID 26143 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26143,
        GIR_Done,
      // Label 413: @7117
      GIM_Try, /*On fail goto*//*Label 414*/ 7147, // Rule ID 26144 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26144,
        GIR_Done,
      // Label 414: @7147
      GIM_Reject,
    // Label 412: @7148
    GIM_Reject,
    // Label 370: @7149
    GIM_Try, /*On fail goto*//*Label 415*/ 7232,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 416*/ 7201, // Rule ID 26179 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26179,
        GIR_Done,
      // Label 416: @7201
      GIM_Try, /*On fail goto*//*Label 417*/ 7231, // Rule ID 26180 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26180,
        GIR_Done,
      // Label 417: @7231
      GIM_Reject,
    // Label 415: @7232
    GIM_Reject,
    // Label 371: @7233
    GIM_Try, /*On fail goto*//*Label 418*/ 7316,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 419*/ 7285, // Rule ID 26195 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26195,
        GIR_Done,
      // Label 419: @7285
      GIM_Try, /*On fail goto*//*Label 420*/ 7315, // Rule ID 26196 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26196,
        GIR_Done,
      // Label 420: @7315
      GIM_Reject,
    // Label 418: @7316
    GIM_Reject,
    // Label 372: @7317
    GIM_Try, /*On fail goto*//*Label 421*/ 7400,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 422*/ 7369, // Rule ID 26139 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26139,
        GIR_Done,
      // Label 422: @7369
      GIM_Try, /*On fail goto*//*Label 423*/ 7399, // Rule ID 26140 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26140,
        GIR_Done,
      // Label 423: @7399
      GIM_Reject,
    // Label 421: @7400
    GIM_Reject,
    // Label 373: @7401
    GIM_Try, /*On fail goto*//*Label 424*/ 7484,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 425*/ 7453, // Rule ID 26167 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26167,
        GIR_Done,
      // Label 425: @7453
      GIM_Try, /*On fail goto*//*Label 426*/ 7483, // Rule ID 26168 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26168,
        GIR_Done,
      // Label 426: @7483
      GIM_Reject,
    // Label 424: @7484
    GIM_Reject,
    // Label 374: @7485
    GIM_Try, /*On fail goto*//*Label 427*/ 7568,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 428*/ 7537, // Rule ID 26183 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26183,
        GIR_Done,
      // Label 428: @7537
      GIM_Try, /*On fail goto*//*Label 429*/ 7567, // Rule ID 26184 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26184,
        GIR_Done,
      // Label 429: @7567
      GIM_Reject,
    // Label 427: @7568
    GIM_Reject,
    // Label 375: @7569
    GIM_Try, /*On fail goto*//*Label 430*/ 7652,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 431*/ 7621, // Rule ID 26199 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26199,
        GIR_Done,
      // Label 431: @7621
      GIM_Try, /*On fail goto*//*Label 432*/ 7651, // Rule ID 26200 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26200,
        GIR_Done,
      // Label 432: @7651
      GIM_Reject,
    // Label 430: @7652
    GIM_Reject,
    // Label 376: @7653
    GIM_Try, /*On fail goto*//*Label 433*/ 7736,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 434*/ 7705, // Rule ID 26155 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26155,
        GIR_Done,
      // Label 434: @7705
      GIM_Try, /*On fail goto*//*Label 435*/ 7735, // Rule ID 26156 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26156,
        GIR_Done,
      // Label 435: @7735
      GIM_Reject,
    // Label 433: @7736
    GIM_Reject,
    // Label 377: @7737
    GIM_Try, /*On fail goto*//*Label 436*/ 7820,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 437*/ 7789, // Rule ID 26171 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26171,
        GIR_Done,
      // Label 437: @7789
      GIM_Try, /*On fail goto*//*Label 438*/ 7819, // Rule ID 26172 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26172,
        GIR_Done,
      // Label 438: @7819
      GIM_Reject,
    // Label 436: @7820
    GIM_Reject,
    // Label 378: @7821
    GIM_Try, /*On fail goto*//*Label 439*/ 7904,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 440*/ 7873, // Rule ID 26187 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26187,
        GIR_Done,
      // Label 440: @7873
      GIM_Try, /*On fail goto*//*Label 441*/ 7903, // Rule ID 26188 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26188,
        GIR_Done,
      // Label 441: @7903
      GIM_Reject,
    // Label 439: @7904
    GIM_Reject,
    // Label 379: @7905
    GIM_Try, /*On fail goto*//*Label 442*/ 7988,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 443*/ 7957, // Rule ID 26159 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26159,
        GIR_Done,
      // Label 443: @7957
      GIM_Try, /*On fail goto*//*Label 444*/ 7987, // Rule ID 26160 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26160,
        GIR_Done,
      // Label 444: @7987
      GIM_Reject,
    // Label 442: @7988
    GIM_Reject,
    // Label 380: @7989
    GIM_Try, /*On fail goto*//*Label 445*/ 8072,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 446*/ 8041, // Rule ID 26175 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26175,
        GIR_Done,
      // Label 446: @8041
      GIM_Try, /*On fail goto*//*Label 447*/ 8071, // Rule ID 26176 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26176,
        GIR_Done,
      // Label 447: @8071
      GIM_Reject,
    // Label 445: @8072
    GIM_Reject,
    // Label 381: @8073
    GIM_Try, /*On fail goto*//*Label 448*/ 8156,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 449*/ 8125, // Rule ID 26163 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26163,
        GIR_Done,
      // Label 449: @8125
      GIM_Try, /*On fail goto*//*Label 450*/ 8155, // Rule ID 26164 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26164,
        GIR_Done,
      // Label 450: @8155
      GIM_Reject,
    // Label 448: @8156
    GIM_Reject,
    // Label 382: @8157
    GIM_Reject,
    // Label 4: @8158
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 475*/ 10107,
    /*GILLT_s32*//*Label 451*/ 8195,
    /*GILLT_s64*//*Label 452*/ 8227, 0,
    /*GILLT_nxv1s8*//*Label 453*/ 8259,
    /*GILLT_nxv1s16*//*Label 454*/ 8343,
    /*GILLT_nxv1s32*//*Label 455*/ 8427,
    /*GILLT_nxv1s64*//*Label 456*/ 8511, 0,
    /*GILLT_nxv2s8*//*Label 457*/ 8595,
    /*GILLT_nxv2s16*//*Label 458*/ 8679,
    /*GILLT_nxv2s32*//*Label 459*/ 8763,
    /*GILLT_nxv2s64*//*Label 460*/ 8847, 0,
    /*GILLT_nxv4s8*//*Label 461*/ 8931,
    /*GILLT_nxv4s16*//*Label 462*/ 9015,
    /*GILLT_nxv4s32*//*Label 463*/ 9099,
    /*GILLT_nxv4s64*//*Label 464*/ 9183, 0,
    /*GILLT_nxv8s8*//*Label 465*/ 9267,
    /*GILLT_nxv8s16*//*Label 466*/ 9351,
    /*GILLT_nxv8s32*//*Label 467*/ 9435,
    /*GILLT_nxv8s64*//*Label 468*/ 9519, 0,
    /*GILLT_nxv16s8*//*Label 469*/ 9603,
    /*GILLT_nxv16s16*//*Label 470*/ 9687,
    /*GILLT_nxv16s32*//*Label 471*/ 9771, 0,
    /*GILLT_nxv32s8*//*Label 472*/ 9855,
    /*GILLT_nxv32s16*//*Label 473*/ 9939, 0,
    /*GILLT_nxv64s8*//*Label 474*/ 10023,
    // Label 451: @8195
    GIM_Try, /*On fail goto*//*Label 476*/ 8226, // Rule ID 49299 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (udiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIVU:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::DIVU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 49299,
      GIR_Done,
    // Label 476: @8226
    GIM_Reject,
    // Label 452: @8227
    GIM_Try, /*On fail goto*//*Label 477*/ 8258, // Rule ID 49298 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (udiv:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (DIVU:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::DIVU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 49298,
      GIR_Done,
    // Label 477: @8258
    GIM_Reject,
    // Label 453: @8259
    GIM_Try, /*On fail goto*//*Label 478*/ 8342,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 479*/ 8311, // Rule ID 26027 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26027,
        GIR_Done,
      // Label 479: @8311
      GIM_Try, /*On fail goto*//*Label 480*/ 8341, // Rule ID 26028 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26028,
        GIR_Done,
      // Label 480: @8341
      GIM_Reject,
    // Label 478: @8342
    GIM_Reject,
    // Label 454: @8343
    GIM_Try, /*On fail goto*//*Label 481*/ 8426,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 482*/ 8395, // Rule ID 26039 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26039,
        GIR_Done,
      // Label 482: @8395
      GIM_Try, /*On fail goto*//*Label 483*/ 8425, // Rule ID 26040 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26040,
        GIR_Done,
      // Label 483: @8425
      GIM_Reject,
    // Label 481: @8426
    GIM_Reject,
    // Label 455: @8427
    GIM_Try, /*On fail goto*//*Label 484*/ 8510,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 485*/ 8479, // Rule ID 26047 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIVU_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26047,
        GIR_Done,
      // Label 485: @8479
      GIM_Try, /*On fail goto*//*Label 486*/ 8509, // Rule ID 26048 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIVU_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26048,
        GIR_Done,
      // Label 486: @8509
      GIM_Reject,
    // Label 484: @8510
    GIM_Reject,
    // Label 456: @8511
    GIM_Try, /*On fail goto*//*Label 487*/ 8594,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 488*/ 8563, // Rule ID 26063 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26063,
        GIR_Done,
      // Label 488: @8563
      GIM_Try, /*On fail goto*//*Label 489*/ 8593, // Rule ID 26064 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26064,
        GIR_Done,
      // Label 489: @8593
      GIM_Reject,
    // Label 487: @8594
    GIM_Reject,
    // Label 457: @8595
    GIM_Try, /*On fail goto*//*Label 490*/ 8678,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 491*/ 8647, // Rule ID 26031 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26031,
        GIR_Done,
      // Label 491: @8647
      GIM_Try, /*On fail goto*//*Label 492*/ 8677, // Rule ID 26032 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26032,
        GIR_Done,
      // Label 492: @8677
      GIM_Reject,
    // Label 490: @8678
    GIM_Reject,
    // Label 458: @8679
    GIM_Try, /*On fail goto*//*Label 493*/ 8762,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 494*/ 8731, // Rule ID 26043 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26043,
        GIR_Done,
      // Label 494: @8731
      GIM_Try, /*On fail goto*//*Label 495*/ 8761, // Rule ID 26044 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26044,
        GIR_Done,
      // Label 495: @8761
      GIM_Reject,
    // Label 493: @8762
    GIM_Reject,
    // Label 459: @8763
    GIM_Try, /*On fail goto*//*Label 496*/ 8846,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 497*/ 8815, // Rule ID 26059 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26059,
        GIR_Done,
      // Label 497: @8815
      GIM_Try, /*On fail goto*//*Label 498*/ 8845, // Rule ID 26060 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26060,
        GIR_Done,
      // Label 498: @8845
      GIM_Reject,
    // Label 496: @8846
    GIM_Reject,
    // Label 460: @8847
    GIM_Try, /*On fail goto*//*Label 499*/ 8930,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 500*/ 8899, // Rule ID 26103 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26103,
        GIR_Done,
      // Label 500: @8899
      GIM_Try, /*On fail goto*//*Label 501*/ 8929, // Rule ID 26104 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26104,
        GIR_Done,
      // Label 501: @8929
      GIM_Reject,
    // Label 499: @8930
    GIM_Reject,
    // Label 461: @8931
    GIM_Try, /*On fail goto*//*Label 502*/ 9014,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 503*/ 8983, // Rule ID 26035 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26035,
        GIR_Done,
      // Label 503: @8983
      GIM_Try, /*On fail goto*//*Label 504*/ 9013, // Rule ID 26036 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26036,
        GIR_Done,
      // Label 504: @9013
      GIM_Reject,
    // Label 502: @9014
    GIM_Reject,
    // Label 462: @9015
    GIM_Try, /*On fail goto*//*Label 505*/ 9098,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 506*/ 9067, // Rule ID 26055 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26055,
        GIR_Done,
      // Label 506: @9067
      GIM_Try, /*On fail goto*//*Label 507*/ 9097, // Rule ID 26056 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26056,
        GIR_Done,
      // Label 507: @9097
      GIM_Reject,
    // Label 505: @9098
    GIM_Reject,
    // Label 463: @9099
    GIM_Try, /*On fail goto*//*Label 508*/ 9182,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 509*/ 9151, // Rule ID 26091 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26091,
        GIR_Done,
      // Label 509: @9151
      GIM_Try, /*On fail goto*//*Label 510*/ 9181, // Rule ID 26092 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26092,
        GIR_Done,
      // Label 510: @9181
      GIM_Reject,
    // Label 508: @9182
    GIM_Reject,
    // Label 464: @9183
    GIM_Try, /*On fail goto*//*Label 511*/ 9266,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 512*/ 9235, // Rule ID 26107 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26107,
        GIR_Done,
      // Label 512: @9235
      GIM_Try, /*On fail goto*//*Label 513*/ 9265, // Rule ID 26108 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26108,
        GIR_Done,
      // Label 513: @9265
      GIM_Reject,
    // Label 511: @9266
    GIM_Reject,
    // Label 465: @9267
    GIM_Try, /*On fail goto*//*Label 514*/ 9350,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 515*/ 9319, // Rule ID 26051 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26051,
        GIR_Done,
      // Label 515: @9319
      GIM_Try, /*On fail goto*//*Label 516*/ 9349, // Rule ID 26052 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26052,
        GIR_Done,
      // Label 516: @9349
      GIM_Reject,
    // Label 514: @9350
    GIM_Reject,
    // Label 466: @9351
    GIM_Try, /*On fail goto*//*Label 517*/ 9434,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 518*/ 9403, // Rule ID 26079 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26079,
        GIR_Done,
      // Label 518: @9403
      GIM_Try, /*On fail goto*//*Label 519*/ 9433, // Rule ID 26080 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26080,
        GIR_Done,
      // Label 519: @9433
      GIM_Reject,
    // Label 517: @9434
    GIM_Reject,
    // Label 467: @9435
    GIM_Try, /*On fail goto*//*Label 520*/ 9518,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 521*/ 9487, // Rule ID 26095 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26095,
        GIR_Done,
      // Label 521: @9487
      GIM_Try, /*On fail goto*//*Label 522*/ 9517, // Rule ID 26096 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26096,
        GIR_Done,
      // Label 522: @9517
      GIM_Reject,
    // Label 520: @9518
    GIM_Reject,
    // Label 468: @9519
    GIM_Try, /*On fail goto*//*Label 523*/ 9602,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 524*/ 9571, // Rule ID 26111 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26111,
        GIR_Done,
      // Label 524: @9571
      GIM_Try, /*On fail goto*//*Label 525*/ 9601, // Rule ID 26112 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26112,
        GIR_Done,
      // Label 525: @9601
      GIM_Reject,
    // Label 523: @9602
    GIM_Reject,
    // Label 469: @9603
    GIM_Try, /*On fail goto*//*Label 526*/ 9686,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 527*/ 9655, // Rule ID 26067 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26067,
        GIR_Done,
      // Label 527: @9655
      GIM_Try, /*On fail goto*//*Label 528*/ 9685, // Rule ID 26068 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26068,
        GIR_Done,
      // Label 528: @9685
      GIM_Reject,
    // Label 526: @9686
    GIM_Reject,
    // Label 470: @9687
    GIM_Try, /*On fail goto*//*Label 529*/ 9770,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 530*/ 9739, // Rule ID 26083 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26083,
        GIR_Done,
      // Label 530: @9739
      GIM_Try, /*On fail goto*//*Label 531*/ 9769, // Rule ID 26084 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26084,
        GIR_Done,
      // Label 531: @9769
      GIM_Reject,
    // Label 529: @9770
    GIM_Reject,
    // Label 471: @9771
    GIM_Try, /*On fail goto*//*Label 532*/ 9854,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 533*/ 9823, // Rule ID 26099 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26099,
        GIR_Done,
      // Label 533: @9823
      GIM_Try, /*On fail goto*//*Label 534*/ 9853, // Rule ID 26100 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26100,
        GIR_Done,
      // Label 534: @9853
      GIM_Reject,
    // Label 532: @9854
    GIM_Reject,
    // Label 472: @9855
    GIM_Try, /*On fail goto*//*Label 535*/ 9938,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 536*/ 9907, // Rule ID 26071 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26071,
        GIR_Done,
      // Label 536: @9907
      GIM_Try, /*On fail goto*//*Label 537*/ 9937, // Rule ID 26072 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26072,
        GIR_Done,
      // Label 537: @9937
      GIM_Reject,
    // Label 535: @9938
    GIM_Reject,
    // Label 473: @9939
    GIM_Try, /*On fail goto*//*Label 538*/ 10022,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 539*/ 9991, // Rule ID 26087 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26087,
        GIR_Done,
      // Label 539: @9991
      GIM_Try, /*On fail goto*//*Label 540*/ 10021, // Rule ID 26088 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26088,
        GIR_Done,
      // Label 540: @10021
      GIM_Reject,
    // Label 538: @10022
    GIM_Reject,
    // Label 474: @10023
    GIM_Try, /*On fail goto*//*Label 541*/ 10106,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 542*/ 10075, // Rule ID 26075 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26075,
        GIR_Done,
      // Label 542: @10075
      GIM_Try, /*On fail goto*//*Label 543*/ 10105, // Rule ID 26076 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26076,
        GIR_Done,
      // Label 543: @10105
      GIM_Reject,
    // Label 541: @10106
    GIM_Reject,
    // Label 475: @10107
    GIM_Reject,
    // Label 5: @10108
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 568*/ 12057,
    /*GILLT_s32*//*Label 544*/ 10145,
    /*GILLT_s64*//*Label 545*/ 10177, 0,
    /*GILLT_nxv1s8*//*Label 546*/ 10209,
    /*GILLT_nxv1s16*//*Label 547*/ 10293,
    /*GILLT_nxv1s32*//*Label 548*/ 10377,
    /*GILLT_nxv1s64*//*Label 549*/ 10461, 0,
    /*GILLT_nxv2s8*//*Label 550*/ 10545,
    /*GILLT_nxv2s16*//*Label 551*/ 10629,
    /*GILLT_nxv2s32*//*Label 552*/ 10713,
    /*GILLT_nxv2s64*//*Label 553*/ 10797, 0,
    /*GILLT_nxv4s8*//*Label 554*/ 10881,
    /*GILLT_nxv4s16*//*Label 555*/ 10965,
    /*GILLT_nxv4s32*//*Label 556*/ 11049,
    /*GILLT_nxv4s64*//*Label 557*/ 11133, 0,
    /*GILLT_nxv8s8*//*Label 558*/ 11217,
    /*GILLT_nxv8s16*//*Label 559*/ 11301,
    /*GILLT_nxv8s32*//*Label 560*/ 11385,
    /*GILLT_nxv8s64*//*Label 561*/ 11469, 0,
    /*GILLT_nxv16s8*//*Label 562*/ 11553,
    /*GILLT_nxv16s16*//*Label 563*/ 11637,
    /*GILLT_nxv16s32*//*Label 564*/ 11721, 0,
    /*GILLT_nxv32s8*//*Label 565*/ 11805,
    /*GILLT_nxv32s16*//*Label 566*/ 11889, 0,
    /*GILLT_nxv64s8*//*Label 567*/ 11973,
    // Label 544: @10145
    GIM_Try, /*On fail goto*//*Label 569*/ 10176, // Rule ID 49301 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (srem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REM:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::REM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 49301,
      GIR_Done,
    // Label 569: @10176
    GIM_Reject,
    // Label 545: @10177
    GIM_Try, /*On fail goto*//*Label 570*/ 10208, // Rule ID 49300 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (srem:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (REM:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::REM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 49300,
      GIR_Done,
    // Label 570: @10208
    GIM_Reject,
    // Label 546: @10209
    GIM_Try, /*On fail goto*//*Label 571*/ 10292,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 572*/ 10261, // Rule ID 26291 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREM_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26291,
        GIR_Done,
      // Label 572: @10261
      GIM_Try, /*On fail goto*//*Label 573*/ 10291, // Rule ID 26292 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREM_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26292,
        GIR_Done,
      // Label 573: @10291
      GIM_Reject,
    // Label 571: @10292
    GIM_Reject,
    // Label 547: @10293
    GIM_Try, /*On fail goto*//*Label 574*/ 10376,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 575*/ 10345, // Rule ID 26303 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREM_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26303,
        GIR_Done,
      // Label 575: @10345
      GIM_Try, /*On fail goto*//*Label 576*/ 10375, // Rule ID 26304 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREM_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26304,
        GIR_Done,
      // Label 576: @10375
      GIM_Reject,
    // Label 574: @10376
    GIM_Reject,
    // Label 548: @10377
    GIM_Try, /*On fail goto*//*Label 577*/ 10460,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 578*/ 10429, // Rule ID 26311 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREM_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26311,
        GIR_Done,
      // Label 578: @10429
      GIM_Try, /*On fail goto*//*Label 579*/ 10459, // Rule ID 26312 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREM_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26312,
        GIR_Done,
      // Label 579: @10459
      GIM_Reject,
    // Label 577: @10460
    GIM_Reject,
    // Label 549: @10461
    GIM_Try, /*On fail goto*//*Label 580*/ 10544,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 581*/ 10513, // Rule ID 26327 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26327,
        GIR_Done,
      // Label 581: @10513
      GIM_Try, /*On fail goto*//*Label 582*/ 10543, // Rule ID 26328 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26328,
        GIR_Done,
      // Label 582: @10543
      GIM_Reject,
    // Label 580: @10544
    GIM_Reject,
    // Label 550: @10545
    GIM_Try, /*On fail goto*//*Label 583*/ 10628,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 584*/ 10597, // Rule ID 26295 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREM_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26295,
        GIR_Done,
      // Label 584: @10597
      GIM_Try, /*On fail goto*//*Label 585*/ 10627, // Rule ID 26296 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREM_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26296,
        GIR_Done,
      // Label 585: @10627
      GIM_Reject,
    // Label 583: @10628
    GIM_Reject,
    // Label 551: @10629
    GIM_Try, /*On fail goto*//*Label 586*/ 10712,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 587*/ 10681, // Rule ID 26307 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREM_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26307,
        GIR_Done,
      // Label 587: @10681
      GIM_Try, /*On fail goto*//*Label 588*/ 10711, // Rule ID 26308 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREM_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26308,
        GIR_Done,
      // Label 588: @10711
      GIM_Reject,
    // Label 586: @10712
    GIM_Reject,
    // Label 552: @10713
    GIM_Try, /*On fail goto*//*Label 589*/ 10796,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 590*/ 10765, // Rule ID 26323 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26323,
        GIR_Done,
      // Label 590: @10765
      GIM_Try, /*On fail goto*//*Label 591*/ 10795, // Rule ID 26324 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26324,
        GIR_Done,
      // Label 591: @10795
      GIM_Reject,
    // Label 589: @10796
    GIM_Reject,
    // Label 553: @10797
    GIM_Try, /*On fail goto*//*Label 592*/ 10880,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 593*/ 10849, // Rule ID 26367 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26367,
        GIR_Done,
      // Label 593: @10849
      GIM_Try, /*On fail goto*//*Label 594*/ 10879, // Rule ID 26368 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26368,
        GIR_Done,
      // Label 594: @10879
      GIM_Reject,
    // Label 592: @10880
    GIM_Reject,
    // Label 554: @10881
    GIM_Try, /*On fail goto*//*Label 595*/ 10964,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 596*/ 10933, // Rule ID 26299 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREM_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26299,
        GIR_Done,
      // Label 596: @10933
      GIM_Try, /*On fail goto*//*Label 597*/ 10963, // Rule ID 26300 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREM_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26300,
        GIR_Done,
      // Label 597: @10963
      GIM_Reject,
    // Label 595: @10964
    GIM_Reject,
    // Label 555: @10965
    GIM_Try, /*On fail goto*//*Label 598*/ 11048,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 599*/ 11017, // Rule ID 26319 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26319,
        GIR_Done,
      // Label 599: @11017
      GIM_Try, /*On fail goto*//*Label 600*/ 11047, // Rule ID 26320 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26320,
        GIR_Done,
      // Label 600: @11047
      GIM_Reject,
    // Label 598: @11048
    GIM_Reject,
    // Label 556: @11049
    GIM_Try, /*On fail goto*//*Label 601*/ 11132,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 602*/ 11101, // Rule ID 26355 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26355,
        GIR_Done,
      // Label 602: @11101
      GIM_Try, /*On fail goto*//*Label 603*/ 11131, // Rule ID 26356 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26356,
        GIR_Done,
      // Label 603: @11131
      GIM_Reject,
    // Label 601: @11132
    GIM_Reject,
    // Label 557: @11133
    GIM_Try, /*On fail goto*//*Label 604*/ 11216,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 605*/ 11185, // Rule ID 26371 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26371,
        GIR_Done,
      // Label 605: @11185
      GIM_Try, /*On fail goto*//*Label 606*/ 11215, // Rule ID 26372 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26372,
        GIR_Done,
      // Label 606: @11215
      GIM_Reject,
    // Label 604: @11216
    GIM_Reject,
    // Label 558: @11217
    GIM_Try, /*On fail goto*//*Label 607*/ 11300,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 608*/ 11269, // Rule ID 26315 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26315,
        GIR_Done,
      // Label 608: @11269
      GIM_Try, /*On fail goto*//*Label 609*/ 11299, // Rule ID 26316 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26316,
        GIR_Done,
      // Label 609: @11299
      GIM_Reject,
    // Label 607: @11300
    GIM_Reject,
    // Label 559: @11301
    GIM_Try, /*On fail goto*//*Label 610*/ 11384,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 611*/ 11353, // Rule ID 26343 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26343,
        GIR_Done,
      // Label 611: @11353
      GIM_Try, /*On fail goto*//*Label 612*/ 11383, // Rule ID 26344 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26344,
        GIR_Done,
      // Label 612: @11383
      GIM_Reject,
    // Label 610: @11384
    GIM_Reject,
    // Label 560: @11385
    GIM_Try, /*On fail goto*//*Label 613*/ 11468,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 614*/ 11437, // Rule ID 26359 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26359,
        GIR_Done,
      // Label 614: @11437
      GIM_Try, /*On fail goto*//*Label 615*/ 11467, // Rule ID 26360 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26360,
        GIR_Done,
      // Label 615: @11467
      GIM_Reject,
    // Label 613: @11468
    GIM_Reject,
    // Label 561: @11469
    GIM_Try, /*On fail goto*//*Label 616*/ 11552,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 617*/ 11521, // Rule ID 26375 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26375,
        GIR_Done,
      // Label 617: @11521
      GIM_Try, /*On fail goto*//*Label 618*/ 11551, // Rule ID 26376 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26376,
        GIR_Done,
      // Label 618: @11551
      GIM_Reject,
    // Label 616: @11552
    GIM_Reject,
    // Label 562: @11553
    GIM_Try, /*On fail goto*//*Label 619*/ 11636,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 620*/ 11605, // Rule ID 26331 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26331,
        GIR_Done,
      // Label 620: @11605
      GIM_Try, /*On fail goto*//*Label 621*/ 11635, // Rule ID 26332 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26332,
        GIR_Done,
      // Label 621: @11635
      GIM_Reject,
    // Label 619: @11636
    GIM_Reject,
    // Label 563: @11637
    GIM_Try, /*On fail goto*//*Label 622*/ 11720,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 623*/ 11689, // Rule ID 26347 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26347,
        GIR_Done,
      // Label 623: @11689
      GIM_Try, /*On fail goto*//*Label 624*/ 11719, // Rule ID 26348 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26348,
        GIR_Done,
      // Label 624: @11719
      GIM_Reject,
    // Label 622: @11720
    GIM_Reject,
    // Label 564: @11721
    GIM_Try, /*On fail goto*//*Label 625*/ 11804,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 626*/ 11773, // Rule ID 26363 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26363,
        GIR_Done,
      // Label 626: @11773
      GIM_Try, /*On fail goto*//*Label 627*/ 11803, // Rule ID 26364 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26364,
        GIR_Done,
      // Label 627: @11803
      GIM_Reject,
    // Label 625: @11804
    GIM_Reject,
    // Label 565: @11805
    GIM_Try, /*On fail goto*//*Label 628*/ 11888,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 629*/ 11857, // Rule ID 26335 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26335,
        GIR_Done,
      // Label 629: @11857
      GIM_Try, /*On fail goto*//*Label 630*/ 11887, // Rule ID 26336 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26336,
        GIR_Done,
      // Label 630: @11887
      GIM_Reject,
    // Label 628: @11888
    GIM_Reject,
    // Label 566: @11889
    GIM_Try, /*On fail goto*//*Label 631*/ 11972,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 632*/ 11941, // Rule ID 26351 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26351,
        GIR_Done,
      // Label 632: @11941
      GIM_Try, /*On fail goto*//*Label 633*/ 11971, // Rule ID 26352 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26352,
        GIR_Done,
      // Label 633: @11971
      GIM_Reject,
    // Label 631: @11972
    GIM_Reject,
    // Label 567: @11973
    GIM_Try, /*On fail goto*//*Label 634*/ 12056,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 635*/ 12025, // Rule ID 26339 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26339,
        GIR_Done,
      // Label 635: @12025
      GIM_Try, /*On fail goto*//*Label 636*/ 12055, // Rule ID 26340 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26340,
        GIR_Done,
      // Label 636: @12055
      GIM_Reject,
    // Label 634: @12056
    GIM_Reject,
    // Label 568: @12057
    GIM_Reject,
    // Label 6: @12058
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 661*/ 14007,
    /*GILLT_s32*//*Label 637*/ 12095,
    /*GILLT_s64*//*Label 638*/ 12127, 0,
    /*GILLT_nxv1s8*//*Label 639*/ 12159,
    /*GILLT_nxv1s16*//*Label 640*/ 12243,
    /*GILLT_nxv1s32*//*Label 641*/ 12327,
    /*GILLT_nxv1s64*//*Label 642*/ 12411, 0,
    /*GILLT_nxv2s8*//*Label 643*/ 12495,
    /*GILLT_nxv2s16*//*Label 644*/ 12579,
    /*GILLT_nxv2s32*//*Label 645*/ 12663,
    /*GILLT_nxv2s64*//*Label 646*/ 12747, 0,
    /*GILLT_nxv4s8*//*Label 647*/ 12831,
    /*GILLT_nxv4s16*//*Label 648*/ 12915,
    /*GILLT_nxv4s32*//*Label 649*/ 12999,
    /*GILLT_nxv4s64*//*Label 650*/ 13083, 0,
    /*GILLT_nxv8s8*//*Label 651*/ 13167,
    /*GILLT_nxv8s16*//*Label 652*/ 13251,
    /*GILLT_nxv8s32*//*Label 653*/ 13335,
    /*GILLT_nxv8s64*//*Label 654*/ 13419, 0,
    /*GILLT_nxv16s8*//*Label 655*/ 13503,
    /*GILLT_nxv16s16*//*Label 656*/ 13587,
    /*GILLT_nxv16s32*//*Label 657*/ 13671, 0,
    /*GILLT_nxv32s8*//*Label 658*/ 13755,
    /*GILLT_nxv32s16*//*Label 659*/ 13839, 0,
    /*GILLT_nxv64s8*//*Label 660*/ 13923,
    // Label 637: @12095
    GIM_Try, /*On fail goto*//*Label 662*/ 12126, // Rule ID 49303 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (urem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REMU:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::REMU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 49303,
      GIR_Done,
    // Label 662: @12126
    GIM_Reject,
    // Label 638: @12127
    GIM_Try, /*On fail goto*//*Label 663*/ 12158, // Rule ID 49302 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (urem:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (REMU:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::REMU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 49302,
      GIR_Done,
    // Label 663: @12158
    GIM_Reject,
    // Label 639: @12159
    GIM_Try, /*On fail goto*//*Label 664*/ 12242,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 665*/ 12211, // Rule ID 26203 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREMU_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26203,
        GIR_Done,
      // Label 665: @12211
      GIM_Try, /*On fail goto*//*Label 666*/ 12241, // Rule ID 26204 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREMU_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26204,
        GIR_Done,
      // Label 666: @12241
      GIM_Reject,
    // Label 664: @12242
    GIM_Reject,
    // Label 640: @12243
    GIM_Try, /*On fail goto*//*Label 667*/ 12326,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 668*/ 12295, // Rule ID 26215 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREMU_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26215,
        GIR_Done,
      // Label 668: @12295
      GIM_Try, /*On fail goto*//*Label 669*/ 12325, // Rule ID 26216 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREMU_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26216,
        GIR_Done,
      // Label 669: @12325
      GIM_Reject,
    // Label 667: @12326
    GIM_Reject,
    // Label 641: @12327
    GIM_Try, /*On fail goto*//*Label 670*/ 12410,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 671*/ 12379, // Rule ID 26223 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREMU_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26223,
        GIR_Done,
      // Label 671: @12379
      GIM_Try, /*On fail goto*//*Label 672*/ 12409, // Rule ID 26224 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREMU_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26224,
        GIR_Done,
      // Label 672: @12409
      GIM_Reject,
    // Label 670: @12410
    GIM_Reject,
    // Label 642: @12411
    GIM_Try, /*On fail goto*//*Label 673*/ 12494,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 674*/ 12463, // Rule ID 26239 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26239,
        GIR_Done,
      // Label 674: @12463
      GIM_Try, /*On fail goto*//*Label 675*/ 12493, // Rule ID 26240 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26240,
        GIR_Done,
      // Label 675: @12493
      GIM_Reject,
    // Label 673: @12494
    GIM_Reject,
    // Label 643: @12495
    GIM_Try, /*On fail goto*//*Label 676*/ 12578,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 677*/ 12547, // Rule ID 26207 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREMU_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26207,
        GIR_Done,
      // Label 677: @12547
      GIM_Try, /*On fail goto*//*Label 678*/ 12577, // Rule ID 26208 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREMU_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26208,
        GIR_Done,
      // Label 678: @12577
      GIM_Reject,
    // Label 676: @12578
    GIM_Reject,
    // Label 644: @12579
    GIM_Try, /*On fail goto*//*Label 679*/ 12662,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 680*/ 12631, // Rule ID 26219 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREMU_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26219,
        GIR_Done,
      // Label 680: @12631
      GIM_Try, /*On fail goto*//*Label 681*/ 12661, // Rule ID 26220 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREMU_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26220,
        GIR_Done,
      // Label 681: @12661
      GIM_Reject,
    // Label 679: @12662
    GIM_Reject,
    // Label 645: @12663
    GIM_Try, /*On fail goto*//*Label 682*/ 12746,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 683*/ 12715, // Rule ID 26235 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26235,
        GIR_Done,
      // Label 683: @12715
      GIM_Try, /*On fail goto*//*Label 684*/ 12745, // Rule ID 26236 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26236,
        GIR_Done,
      // Label 684: @12745
      GIM_Reject,
    // Label 682: @12746
    GIM_Reject,
    // Label 646: @12747
    GIM_Try, /*On fail goto*//*Label 685*/ 12830,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 686*/ 12799, // Rule ID 26279 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26279,
        GIR_Done,
      // Label 686: @12799
      GIM_Try, /*On fail goto*//*Label 687*/ 12829, // Rule ID 26280 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26280,
        GIR_Done,
      // Label 687: @12829
      GIM_Reject,
    // Label 685: @12830
    GIM_Reject,
    // Label 647: @12831
    GIM_Try, /*On fail goto*//*Label 688*/ 12914,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 689*/ 12883, // Rule ID 26211 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREMU_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26211,
        GIR_Done,
      // Label 689: @12883
      GIM_Try, /*On fail goto*//*Label 690*/ 12913, // Rule ID 26212 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREMU_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26212,
        GIR_Done,
      // Label 690: @12913
      GIM_Reject,
    // Label 688: @12914
    GIM_Reject,
    // Label 648: @12915
    GIM_Try, /*On fail goto*//*Label 691*/ 12998,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 692*/ 12967, // Rule ID 26231 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26231,
        GIR_Done,
      // Label 692: @12967
      GIM_Try, /*On fail goto*//*Label 693*/ 12997, // Rule ID 26232 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26232,
        GIR_Done,
      // Label 693: @12997
      GIM_Reject,
    // Label 691: @12998
    GIM_Reject,
    // Label 649: @12999
    GIM_Try, /*On fail goto*//*Label 694*/ 13082,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 695*/ 13051, // Rule ID 26267 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26267,
        GIR_Done,
      // Label 695: @13051
      GIM_Try, /*On fail goto*//*Label 696*/ 13081, // Rule ID 26268 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26268,
        GIR_Done,
      // Label 696: @13081
      GIM_Reject,
    // Label 694: @13082
    GIM_Reject,
    // Label 650: @13083
    GIM_Try, /*On fail goto*//*Label 697*/ 13166,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 698*/ 13135, // Rule ID 26283 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26283,
        GIR_Done,
      // Label 698: @13135
      GIM_Try, /*On fail goto*//*Label 699*/ 13165, // Rule ID 26284 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26284,
        GIR_Done,
      // Label 699: @13165
      GIM_Reject,
    // Label 697: @13166
    GIM_Reject,
    // Label 651: @13167
    GIM_Try, /*On fail goto*//*Label 700*/ 13250,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 701*/ 13219, // Rule ID 26227 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26227,
        GIR_Done,
      // Label 701: @13219
      GIM_Try, /*On fail goto*//*Label 702*/ 13249, // Rule ID 26228 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26228,
        GIR_Done,
      // Label 702: @13249
      GIM_Reject,
    // Label 700: @13250
    GIM_Reject,
    // Label 652: @13251
    GIM_Try, /*On fail goto*//*Label 703*/ 13334,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 704*/ 13303, // Rule ID 26255 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26255,
        GIR_Done,
      // Label 704: @13303
      GIM_Try, /*On fail goto*//*Label 705*/ 13333, // Rule ID 26256 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26256,
        GIR_Done,
      // Label 705: @13333
      GIM_Reject,
    // Label 703: @13334
    GIM_Reject,
    // Label 653: @13335
    GIM_Try, /*On fail goto*//*Label 706*/ 13418,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 707*/ 13387, // Rule ID 26271 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26271,
        GIR_Done,
      // Label 707: @13387
      GIM_Try, /*On fail goto*//*Label 708*/ 13417, // Rule ID 26272 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26272,
        GIR_Done,
      // Label 708: @13417
      GIM_Reject,
    // Label 706: @13418
    GIM_Reject,
    // Label 654: @13419
    GIM_Try, /*On fail goto*//*Label 709*/ 13502,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 710*/ 13471, // Rule ID 26287 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26287,
        GIR_Done,
      // Label 710: @13471
      GIM_Try, /*On fail goto*//*Label 711*/ 13501, // Rule ID 26288 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26288,
        GIR_Done,
      // Label 711: @13501
      GIM_Reject,
    // Label 709: @13502
    GIM_Reject,
    // Label 655: @13503
    GIM_Try, /*On fail goto*//*Label 712*/ 13586,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 713*/ 13555, // Rule ID 26243 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26243,
        GIR_Done,
      // Label 713: @13555
      GIM_Try, /*On fail goto*//*Label 714*/ 13585, // Rule ID 26244 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26244,
        GIR_Done,
      // Label 714: @13585
      GIM_Reject,
    // Label 712: @13586
    GIM_Reject,
    // Label 656: @13587
    GIM_Try, /*On fail goto*//*Label 715*/ 13670,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 716*/ 13639, // Rule ID 26259 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26259,
        GIR_Done,
      // Label 716: @13639
      GIM_Try, /*On fail goto*//*Label 717*/ 13669, // Rule ID 26260 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26260,
        GIR_Done,
      // Label 717: @13669
      GIM_Reject,
    // Label 715: @13670
    GIM_Reject,
    // Label 657: @13671
    GIM_Try, /*On fail goto*//*Label 718*/ 13754,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 719*/ 13723, // Rule ID 26275 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26275,
        GIR_Done,
      // Label 719: @13723
      GIM_Try, /*On fail goto*//*Label 720*/ 13753, // Rule ID 26276 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26276,
        GIR_Done,
      // Label 720: @13753
      GIM_Reject,
    // Label 718: @13754
    GIM_Reject,
    // Label 658: @13755
    GIM_Try, /*On fail goto*//*Label 721*/ 13838,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 722*/ 13807, // Rule ID 26247 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26247,
        GIR_Done,
      // Label 722: @13807
      GIM_Try, /*On fail goto*//*Label 723*/ 13837, // Rule ID 26248 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26248,
        GIR_Done,
      // Label 723: @13837
      GIM_Reject,
    // Label 721: @13838
    GIM_Reject,
    // Label 659: @13839
    GIM_Try, /*On fail goto*//*Label 724*/ 13922,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 725*/ 13891, // Rule ID 26263 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26263,
        GIR_Done,
      // Label 725: @13891
      GIM_Try, /*On fail goto*//*Label 726*/ 13921, // Rule ID 26264 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26264,
        GIR_Done,
      // Label 726: @13921
      GIM_Reject,
    // Label 724: @13922
    GIM_Reject,
    // Label 660: @13923
    GIM_Try, /*On fail goto*//*Label 727*/ 14006,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 728*/ 13975, // Rule ID 26251 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26251,
        GIR_Done,
      // Label 728: @13975
      GIM_Try, /*On fail goto*//*Label 729*/ 14005, // Rule ID 26252 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 26252,
        GIR_Done,
      // Label 729: @14005
      GIM_Reject,
    // Label 727: @14006
    GIM_Reject,
    // Label 661: @14007
    GIM_Reject,
    // Label 7: @14008
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 761*/ 17503,
    /*GILLT_s32*//*Label 730*/ 14045,
    /*GILLT_s64*//*Label 731*/ 14515,
    /*GILLT_nxv1s1*//*Label 732*/ 15067,
    /*GILLT_nxv1s8*//*Label 733*/ 15151,
    /*GILLT_nxv1s16*//*Label 734*/ 15235,
    /*GILLT_nxv1s32*//*Label 735*/ 15319,
    /*GILLT_nxv1s64*//*Label 736*/ 15403,
    /*GILLT_nxv2s1*//*Label 737*/ 15487,
    /*GILLT_nxv2s8*//*Label 738*/ 15571,
    /*GILLT_nxv2s16*//*Label 739*/ 15655,
    /*GILLT_nxv2s32*//*Label 740*/ 15739,
    /*GILLT_nxv2s64*//*Label 741*/ 15823,
    /*GILLT_nxv4s1*//*Label 742*/ 15907,
    /*GILLT_nxv4s8*//*Label 743*/ 15991,
    /*GILLT_nxv4s16*//*Label 744*/ 16075,
    /*GILLT_nxv4s32*//*Label 745*/ 16159,
    /*GILLT_nxv4s64*//*Label 746*/ 16243,
    /*GILLT_nxv8s1*//*Label 747*/ 16327,
    /*GILLT_nxv8s8*//*Label 748*/ 16411,
    /*GILLT_nxv8s16*//*Label 749*/ 16495,
    /*GILLT_nxv8s32*//*Label 750*/ 16579,
    /*GILLT_nxv8s64*//*Label 751*/ 16663,
    /*GILLT_nxv16s1*//*Label 752*/ 16747,
    /*GILLT_nxv16s8*//*Label 753*/ 16831,
    /*GILLT_nxv16s16*//*Label 754*/ 16915,
    /*GILLT_nxv16s32*//*Label 755*/ 16999,
    /*GILLT_nxv32s1*//*Label 756*/ 17083,
    /*GILLT_nxv32s8*//*Label 757*/ 17167,
    /*GILLT_nxv32s16*//*Label 758*/ 17251,
    /*GILLT_nxv64s1*//*Label 759*/ 17335,
    /*GILLT_nxv64s8*//*Label 760*/ 17419,
    // Label 730: @14045
    GIM_Try, /*On fail goto*//*Label 762*/ 14514,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 763*/ 14159, // Rule ID 49934 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_uimmlog2xlen,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (and:{ *:[i32] } (xor:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt), -1:{ *:[i32] }), 1:{ *:[i32] })  =>  (XORI:{ *:[i32] } (BEXTI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::BEXTI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/3, // shamt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XORI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49934,
        GIR_Done,
      // Label 763: @14159
      GIM_Try, /*On fail goto*//*Label 764*/ 14219, // Rule ID 49932 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_uimmlog2xlen,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i32] })  =>  (BEXTI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BEXTI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49932,
        GIR_Done,
      // Label 764: @14219
      GIM_Try, /*On fail goto*//*Label 765*/ 14272, // Rule ID 49916 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ROTL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -2,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i32] }:$rs2), GPR:{ *:[i32] }:$rs1)  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BCLR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49916,
        GIR_Done,
      // Label 765: @14272
      GIM_Try, /*On fail goto*//*Label 766*/ 14325, // Rule ID 55053 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55053,
        GIR_Done,
      // Label 766: @14325
      GIM_Try, /*On fail goto*//*Label 767*/ 14378, // Rule ID 55063 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ROTL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -2,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i32] }:$rs2))  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BCLR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55063,
        GIR_Done,
      // Label 767: @14378
      GIM_Try, /*On fail goto*//*Label 768*/ 14431, // Rule ID 49896 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49896,
        GIR_Done,
      // Label 768: @14431
      GIM_Try, /*On fail goto*//*Label 769*/ 14459, // Rule ID 50059 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbp_IsRV32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (ZEXT_H_RV32:{ *:[i32] } GPR:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ZEXT_H_RV32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50059,
        GIR_Done,
      // Label 769: @14459
      GIM_Try, /*On fail goto*//*Label 770*/ 14496, // Rule ID 49096 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ANDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49096,
        GIR_Done,
      // Label 770: @14496
      GIM_Try, /*On fail goto*//*Label 771*/ 14513, // Rule ID 49094 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (AND:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AND,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49094,
        GIR_Done,
      // Label 771: @14513
      GIM_Reject,
    // Label 762: @14514
    GIM_Reject,
    // Label 731: @14515
    GIM_Try, /*On fail goto*//*Label 772*/ 15066,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 773*/ 14629, // Rule ID 49933 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_uimmlog2xlen,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (and:{ *:[i64] } (xor:{ *:[i64] } (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt), -1:{ *:[i64] }), 1:{ *:[i64] })  =>  (XORI:{ *:[i64] } (BEXTI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::BEXTI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/3, // shamt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XORI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49933,
        GIR_Done,
      // Label 773: @14629
      GIM_Try, /*On fail goto*//*Label 774*/ 14689, // Rule ID 49931 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_uimmlog2xlen,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i64] } (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i64] })  =>  (BEXTI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BEXTI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49931,
        GIR_Done,
      // Label 774: @14689
      GIM_Try, /*On fail goto*//*Label 775*/ 14742, // Rule ID 49915 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ROTL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -2,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (rotl:{ *:[i64] } -2:{ *:[i64] }, GPR:{ *:[i64] }:$rs2), GPR:{ *:[i64] }:$rs1)  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BCLR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49915,
        GIR_Done,
      // Label 775: @14742
      GIM_Try, /*On fail goto*//*Label 776*/ 14795, // Rule ID 55052 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs1)  =>  (ANDN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55052,
        GIR_Done,
      // Label 776: @14795
      GIM_Try, /*On fail goto*//*Label 777*/ 14848, // Rule ID 55062 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ROTL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -2,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (rotl:{ *:[i64] } -2:{ *:[i64] }, GPR:{ *:[i64] }:$rs2))  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BCLR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55062,
        GIR_Done,
      // Label 777: @14848
      GIM_Try, /*On fail goto*//*Label 778*/ 14901, // Rule ID 49895 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }))  =>  (ANDN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49895,
        GIR_Done,
      // Label 778: @14901
      GIM_Try, /*On fail goto*//*Label 779*/ 14951, // Rule ID 49243 //
        GIM_CheckFeatures, GIFBS_IsRV64_NotHasStdExtZba,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 4294967295,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] })  =>  (SRLI:{ *:[i64] } (SLLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 32:{ *:[i64] }), 32:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SLLI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/1, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::SRLI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49243,
        GIR_Done,
      // Label 779: @14951
      GIM_Try, /*On fail goto*//*Label 780*/ 14979, // Rule ID 50060 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbp_IsRV64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, 65535:{ *:[i64] })  =>  (ZEXT_H_RV64:{ *:[i64] } GPR:{ *:[i64] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ZEXT_H_RV64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50060,
        GIR_Done,
      // Label 780: @14979
      GIM_Try, /*On fail goto*//*Label 781*/ 15011, // Rule ID 50119 //
        GIM_CheckFeatures, GIFBS_HasStdExtZba_IsRV64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 4294967295,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, 4294967295:{ *:[i64] })  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs, X0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ADD_UW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_AddRegister, /*InsnID*/0, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50119,
        GIR_Done,
      // Label 781: @15011
      GIM_Try, /*On fail goto*//*Label 782*/ 15048, // Rule ID 49095 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ANDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49095,
        GIR_Done,
      // Label 782: @15048
      GIM_Try, /*On fail goto*//*Label 783*/ 15065, // Rule ID 49093 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (AND:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AND,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49093,
        GIR_Done,
      // Label 783: @15065
      GIM_Reject,
    // Label 772: @15066
    GIM_Reject,
    // Label 732: @15067
    GIM_Try, /*On fail goto*//*Label 784*/ 15150,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 785*/ 15119, // Rule ID 27333 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMAND_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27333,
        GIR_Done,
      // Label 785: @15119
      GIM_Try, /*On fail goto*//*Label 786*/ 15149, // Rule ID 27334 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMAND_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27334,
        GIR_Done,
      // Label 786: @15149
      GIM_Reject,
    // Label 784: @15150
    GIM_Reject,
    // Label 733: @15151
    GIM_Try, /*On fail goto*//*Label 787*/ 15234,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 788*/ 15203, // Rule ID 23345 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVAND_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23345,
        GIR_Done,
      // Label 788: @15203
      GIM_Try, /*On fail goto*//*Label 789*/ 15233, // Rule ID 23346 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVAND_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23346,
        GIR_Done,
      // Label 789: @15233
      GIM_Reject,
    // Label 787: @15234
    GIM_Reject,
    // Label 734: @15235
    GIM_Try, /*On fail goto*//*Label 790*/ 15318,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 791*/ 15287, // Rule ID 23357 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23357,
        GIR_Done,
      // Label 791: @15287
      GIM_Try, /*On fail goto*//*Label 792*/ 15317, // Rule ID 23358 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23358,
        GIR_Done,
      // Label 792: @15317
      GIM_Reject,
    // Label 790: @15318
    GIM_Reject,
    // Label 735: @15319
    GIM_Try, /*On fail goto*//*Label 793*/ 15402,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 794*/ 15371, // Rule ID 23365 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23365,
        GIR_Done,
      // Label 794: @15371
      GIM_Try, /*On fail goto*//*Label 795*/ 15401, // Rule ID 23366 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23366,
        GIR_Done,
      // Label 795: @15401
      GIM_Reject,
    // Label 793: @15402
    GIM_Reject,
    // Label 736: @15403
    GIM_Try, /*On fail goto*//*Label 796*/ 15486,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 797*/ 15455, // Rule ID 23381 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23381,
        GIR_Done,
      // Label 797: @15455
      GIM_Try, /*On fail goto*//*Label 798*/ 15485, // Rule ID 23382 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23382,
        GIR_Done,
      // Label 798: @15485
      GIM_Reject,
    // Label 796: @15486
    GIM_Reject,
    // Label 737: @15487
    GIM_Try, /*On fail goto*//*Label 799*/ 15570,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 800*/ 15539, // Rule ID 27351 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMAND_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27351,
        GIR_Done,
      // Label 800: @15539
      GIM_Try, /*On fail goto*//*Label 801*/ 15569, // Rule ID 27352 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMAND_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27352,
        GIR_Done,
      // Label 801: @15569
      GIM_Reject,
    // Label 799: @15570
    GIM_Reject,
    // Label 738: @15571
    GIM_Try, /*On fail goto*//*Label 802*/ 15654,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 803*/ 15623, // Rule ID 23349 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23349,
        GIR_Done,
      // Label 803: @15623
      GIM_Try, /*On fail goto*//*Label 804*/ 15653, // Rule ID 23350 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23350,
        GIR_Done,
      // Label 804: @15653
      GIM_Reject,
    // Label 802: @15654
    GIM_Reject,
    // Label 739: @15655
    GIM_Try, /*On fail goto*//*Label 805*/ 15738,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 806*/ 15707, // Rule ID 23361 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23361,
        GIR_Done,
      // Label 806: @15707
      GIM_Try, /*On fail goto*//*Label 807*/ 15737, // Rule ID 23362 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23362,
        GIR_Done,
      // Label 807: @15737
      GIM_Reject,
    // Label 805: @15738
    GIM_Reject,
    // Label 740: @15739
    GIM_Try, /*On fail goto*//*Label 808*/ 15822,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 809*/ 15791, // Rule ID 23377 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23377,
        GIR_Done,
      // Label 809: @15791
      GIM_Try, /*On fail goto*//*Label 810*/ 15821, // Rule ID 23378 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23378,
        GIR_Done,
      // Label 810: @15821
      GIM_Reject,
    // Label 808: @15822
    GIM_Reject,
    // Label 741: @15823
    GIM_Try, /*On fail goto*//*Label 811*/ 15906,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 812*/ 15875, // Rule ID 23421 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23421,
        GIR_Done,
      // Label 812: @15875
      GIM_Try, /*On fail goto*//*Label 813*/ 15905, // Rule ID 23422 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23422,
        GIR_Done,
      // Label 813: @15905
      GIM_Reject,
    // Label 811: @15906
    GIM_Reject,
    // Label 742: @15907
    GIM_Try, /*On fail goto*//*Label 814*/ 15990,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 815*/ 15959, // Rule ID 27369 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMAND_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27369,
        GIR_Done,
      // Label 815: @15959
      GIM_Try, /*On fail goto*//*Label 816*/ 15989, // Rule ID 27370 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMAND_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27370,
        GIR_Done,
      // Label 816: @15989
      GIM_Reject,
    // Label 814: @15990
    GIM_Reject,
    // Label 743: @15991
    GIM_Try, /*On fail goto*//*Label 817*/ 16074,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 818*/ 16043, // Rule ID 23353 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23353,
        GIR_Done,
      // Label 818: @16043
      GIM_Try, /*On fail goto*//*Label 819*/ 16073, // Rule ID 23354 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23354,
        GIR_Done,
      // Label 819: @16073
      GIM_Reject,
    // Label 817: @16074
    GIM_Reject,
    // Label 744: @16075
    GIM_Try, /*On fail goto*//*Label 820*/ 16158,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 821*/ 16127, // Rule ID 23373 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23373,
        GIR_Done,
      // Label 821: @16127
      GIM_Try, /*On fail goto*//*Label 822*/ 16157, // Rule ID 23374 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23374,
        GIR_Done,
      // Label 822: @16157
      GIM_Reject,
    // Label 820: @16158
    GIM_Reject,
    // Label 745: @16159
    GIM_Try, /*On fail goto*//*Label 823*/ 16242,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 824*/ 16211, // Rule ID 23409 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23409,
        GIR_Done,
      // Label 824: @16211
      GIM_Try, /*On fail goto*//*Label 825*/ 16241, // Rule ID 23410 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23410,
        GIR_Done,
      // Label 825: @16241
      GIM_Reject,
    // Label 823: @16242
    GIM_Reject,
    // Label 746: @16243
    GIM_Try, /*On fail goto*//*Label 826*/ 16326,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 827*/ 16295, // Rule ID 23425 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23425,
        GIR_Done,
      // Label 827: @16295
      GIM_Try, /*On fail goto*//*Label 828*/ 16325, // Rule ID 23426 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23426,
        GIR_Done,
      // Label 828: @16325
      GIM_Reject,
    // Label 826: @16326
    GIM_Reject,
    // Label 747: @16327
    GIM_Try, /*On fail goto*//*Label 829*/ 16410,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 830*/ 16379, // Rule ID 27387 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMAND_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27387,
        GIR_Done,
      // Label 830: @16379
      GIM_Try, /*On fail goto*//*Label 831*/ 16409, // Rule ID 27388 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMAND_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27388,
        GIR_Done,
      // Label 831: @16409
      GIM_Reject,
    // Label 829: @16410
    GIM_Reject,
    // Label 748: @16411
    GIM_Try, /*On fail goto*//*Label 832*/ 16494,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 833*/ 16463, // Rule ID 23369 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23369,
        GIR_Done,
      // Label 833: @16463
      GIM_Try, /*On fail goto*//*Label 834*/ 16493, // Rule ID 23370 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23370,
        GIR_Done,
      // Label 834: @16493
      GIM_Reject,
    // Label 832: @16494
    GIM_Reject,
    // Label 749: @16495
    GIM_Try, /*On fail goto*//*Label 835*/ 16578,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 836*/ 16547, // Rule ID 23397 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23397,
        GIR_Done,
      // Label 836: @16547
      GIM_Try, /*On fail goto*//*Label 837*/ 16577, // Rule ID 23398 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23398,
        GIR_Done,
      // Label 837: @16577
      GIM_Reject,
    // Label 835: @16578
    GIM_Reject,
    // Label 750: @16579
    GIM_Try, /*On fail goto*//*Label 838*/ 16662,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 839*/ 16631, // Rule ID 23413 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23413,
        GIR_Done,
      // Label 839: @16631
      GIM_Try, /*On fail goto*//*Label 840*/ 16661, // Rule ID 23414 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23414,
        GIR_Done,
      // Label 840: @16661
      GIM_Reject,
    // Label 838: @16662
    GIM_Reject,
    // Label 751: @16663
    GIM_Try, /*On fail goto*//*Label 841*/ 16746,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 842*/ 16715, // Rule ID 23429 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23429,
        GIR_Done,
      // Label 842: @16715
      GIM_Try, /*On fail goto*//*Label 843*/ 16745, // Rule ID 23430 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23430,
        GIR_Done,
      // Label 843: @16745
      GIM_Reject,
    // Label 841: @16746
    GIM_Reject,
    // Label 752: @16747
    GIM_Try, /*On fail goto*//*Label 844*/ 16830,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 845*/ 16799, // Rule ID 27405 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMAND_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27405,
        GIR_Done,
      // Label 845: @16799
      GIM_Try, /*On fail goto*//*Label 846*/ 16829, // Rule ID 27406 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMAND_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27406,
        GIR_Done,
      // Label 846: @16829
      GIM_Reject,
    // Label 844: @16830
    GIM_Reject,
    // Label 753: @16831
    GIM_Try, /*On fail goto*//*Label 847*/ 16914,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 848*/ 16883, // Rule ID 23385 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23385,
        GIR_Done,
      // Label 848: @16883
      GIM_Try, /*On fail goto*//*Label 849*/ 16913, // Rule ID 23386 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23386,
        GIR_Done,
      // Label 849: @16913
      GIM_Reject,
    // Label 847: @16914
    GIM_Reject,
    // Label 754: @16915
    GIM_Try, /*On fail goto*//*Label 850*/ 16998,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 851*/ 16967, // Rule ID 23401 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23401,
        GIR_Done,
      // Label 851: @16967
      GIM_Try, /*On fail goto*//*Label 852*/ 16997, // Rule ID 23402 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23402,
        GIR_Done,
      // Label 852: @16997
      GIM_Reject,
    // Label 850: @16998
    GIM_Reject,
    // Label 755: @16999
    GIM_Try, /*On fail goto*//*Label 853*/ 17082,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 854*/ 17051, // Rule ID 23417 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23417,
        GIR_Done,
      // Label 854: @17051
      GIM_Try, /*On fail goto*//*Label 855*/ 17081, // Rule ID 23418 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23418,
        GIR_Done,
      // Label 855: @17081
      GIM_Reject,
    // Label 853: @17082
    GIM_Reject,
    // Label 756: @17083
    GIM_Try, /*On fail goto*//*Label 856*/ 17166,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 857*/ 17135, // Rule ID 27423 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMAND_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27423,
        GIR_Done,
      // Label 857: @17135
      GIM_Try, /*On fail goto*//*Label 858*/ 17165, // Rule ID 27424 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMAND_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27424,
        GIR_Done,
      // Label 858: @17165
      GIM_Reject,
    // Label 856: @17166
    GIM_Reject,
    // Label 757: @17167
    GIM_Try, /*On fail goto*//*Label 859*/ 17250,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 860*/ 17219, // Rule ID 23389 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23389,
        GIR_Done,
      // Label 860: @17219
      GIM_Try, /*On fail goto*//*Label 861*/ 17249, // Rule ID 23390 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23390,
        GIR_Done,
      // Label 861: @17249
      GIM_Reject,
    // Label 859: @17250
    GIM_Reject,
    // Label 758: @17251
    GIM_Try, /*On fail goto*//*Label 862*/ 17334,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 863*/ 17303, // Rule ID 23405 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23405,
        GIR_Done,
      // Label 863: @17303
      GIM_Try, /*On fail goto*//*Label 864*/ 17333, // Rule ID 23406 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23406,
        GIR_Done,
      // Label 864: @17333
      GIM_Reject,
    // Label 862: @17334
    GIM_Reject,
    // Label 759: @17335
    GIM_Try, /*On fail goto*//*Label 865*/ 17418,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 866*/ 17387, // Rule ID 27441 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMAND_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27441,
        GIR_Done,
      // Label 866: @17387
      GIM_Try, /*On fail goto*//*Label 867*/ 17417, // Rule ID 27442 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMAND_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27442,
        GIR_Done,
      // Label 867: @17417
      GIM_Reject,
    // Label 865: @17418
    GIM_Reject,
    // Label 760: @17419
    GIM_Try, /*On fail goto*//*Label 868*/ 17502,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 869*/ 17471, // Rule ID 23393 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23393,
        GIR_Done,
      // Label 869: @17471
      GIM_Try, /*On fail goto*//*Label 870*/ 17501, // Rule ID 23394 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23394,
        GIR_Done,
      // Label 870: @17501
      GIM_Reject,
    // Label 868: @17502
    GIM_Reject,
    // Label 761: @17503
    GIM_Reject,
    // Label 8: @17504
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 902*/ 23217,
    /*GILLT_s32*//*Label 871*/ 17541,
    /*GILLT_s64*//*Label 872*/ 19161,
    /*GILLT_nxv1s1*//*Label 873*/ 20781,
    /*GILLT_nxv1s8*//*Label 874*/ 20865,
    /*GILLT_nxv1s16*//*Label 875*/ 20949,
    /*GILLT_nxv1s32*//*Label 876*/ 21033,
    /*GILLT_nxv1s64*//*Label 877*/ 21117,
    /*GILLT_nxv2s1*//*Label 878*/ 21201,
    /*GILLT_nxv2s8*//*Label 879*/ 21285,
    /*GILLT_nxv2s16*//*Label 880*/ 21369,
    /*GILLT_nxv2s32*//*Label 881*/ 21453,
    /*GILLT_nxv2s64*//*Label 882*/ 21537,
    /*GILLT_nxv4s1*//*Label 883*/ 21621,
    /*GILLT_nxv4s8*//*Label 884*/ 21705,
    /*GILLT_nxv4s16*//*Label 885*/ 21789,
    /*GILLT_nxv4s32*//*Label 886*/ 21873,
    /*GILLT_nxv4s64*//*Label 887*/ 21957,
    /*GILLT_nxv8s1*//*Label 888*/ 22041,
    /*GILLT_nxv8s8*//*Label 889*/ 22125,
    /*GILLT_nxv8s16*//*Label 890*/ 22209,
    /*GILLT_nxv8s32*//*Label 891*/ 22293,
    /*GILLT_nxv8s64*//*Label 892*/ 22377,
    /*GILLT_nxv16s1*//*Label 893*/ 22461,
    /*GILLT_nxv16s8*//*Label 894*/ 22545,
    /*GILLT_nxv16s16*//*Label 895*/ 22629,
    /*GILLT_nxv16s32*//*Label 896*/ 22713,
    /*GILLT_nxv32s1*//*Label 897*/ 22797,
    /*GILLT_nxv32s8*//*Label 898*/ 22881,
    /*GILLT_nxv32s16*//*Label 899*/ 22965,
    /*GILLT_nxv64s1*//*Label 900*/ 23049,
    /*GILLT_nxv64s8*//*Label 901*/ 23133,
    // Label 871: @17541
    GIM_Try, /*On fail goto*//*Label 903*/ 19160,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 904*/ 17650, // Rule ID 50049 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 8:{ *:[i32] }), 65535:{ *:[i32] }), (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 255:{ *:[i32] }))  =>  (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50049,
        GIR_Done,
      // Label 904: @17650
      GIM_Try, /*On fail goto*//*Label 905*/ 17745, // Rule ID 55083 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 255:{ *:[i32] }), (and:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 8:{ *:[i32] }), 65535:{ *:[i32] }))  =>  (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55083,
        GIR_Done,
      // Label 905: @17745
      GIM_Try, /*On fail goto*//*Label 906*/ 17840, // Rule ID 55085 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 255,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 8,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 255:{ *:[i32] }), (shl:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 255:{ *:[i32] }), 8:{ *:[i32] }))  =>  (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55085,
        GIR_Done,
      // Label 906: @17840
      GIM_Try, /*On fail goto*//*Label 907*/ 17935, // Rule ID 50051 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 255,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 8,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (shl:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 255:{ *:[i32] }), 8:{ *:[i32] }), (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 255:{ *:[i32] }))  =>  (PACKH:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50051,
        GIR_Done,
      // Label 907: @17935
      GIM_Try, /*On fail goto*//*Label 908*/ 18009, // Rule ID 50056 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbp_IsRV32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 4294901760:{ *:[i32] }), (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 16:{ *:[i32] }))  =>  (PACKU:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKU,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50056,
        GIR_Done,
      // Label 908: @18009
      GIM_Try, /*On fail goto*//*Label 909*/ 18083, // Rule ID 50052 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb_IsRV32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 65535:{ *:[i32] }), (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 16:{ *:[i32] }))  =>  (PACK:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACK,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50052,
        GIR_Done,
      // Label 909: @18083
      GIM_Try, /*On fail goto*//*Label 910*/ 18157, // Rule ID 55090 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbp_IsRV32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 16:{ *:[i32] }), (and:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 4294901760:{ *:[i32] }))  =>  (PACKU:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKU,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55090,
        GIR_Done,
      // Label 910: @18157
      GIM_Try, /*On fail goto*//*Label 911*/ 18231, // Rule ID 55086 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb_IsRV32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, 16:{ *:[i32] }), (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 65535:{ *:[i32] }))  =>  (PACK:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACK,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55086,
        GIR_Done,
      // Label 911: @18231
      GIM_Try, /*On fail goto*//*Label 912*/ 18327, // Rule ID 55069 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs3), (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55069,
        GIR_Done,
      // Label 912: @18327
      GIM_Try, /*On fail goto*//*Label 913*/ 18423, // Rule ID 49990 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs3), (and:{ *:[i32] } GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs1))  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49990,
        GIR_Done,
      // Label 913: @18423
      GIM_Try, /*On fail goto*//*Label 914*/ 18519, // Rule ID 55073 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs3, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] })), (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55073,
        GIR_Done,
      // Label 914: @18519
      GIM_Try, /*On fail goto*//*Label 915*/ 18615, // Rule ID 55071 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs3, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] })), (and:{ *:[i32] } GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs1))  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55071,
        GIR_Done,
      // Label 915: @18615
      GIM_Try, /*On fail goto*//*Label 916*/ 18711, // Rule ID 55075 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs1), (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs3))  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55075,
        GIR_Done,
      // Label 916: @18711
      GIM_Try, /*On fail goto*//*Label 917*/ 18807, // Rule ID 55079 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs3))  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55079,
        GIR_Done,
      // Label 917: @18807
      GIM_Try, /*On fail goto*//*Label 918*/ 18903, // Rule ID 55077 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs1), (and:{ *:[i32] } GPR:{ *:[i32] }:$rs3, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] })))  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55077,
        GIR_Done,
      // Label 918: @18903
      GIM_Try, /*On fail goto*//*Label 919*/ 18999, // Rule ID 55081 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), (and:{ *:[i32] } GPR:{ *:[i32] }:$rs3, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] })))  =>  (CMIX:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, GPR:{ *:[i32] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55081,
        GIR_Done,
      // Label 919: @18999
      GIM_Try, /*On fail goto*//*Label 920*/ 19052, // Rule ID 55055 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ORN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55055,
        GIR_Done,
      // Label 920: @19052
      GIM_Try, /*On fail goto*//*Label 921*/ 19105, // Rule ID 49898 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ORN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49898,
        GIR_Done,
      // Label 921: @19105
      GIM_Try, /*On fail goto*//*Label 922*/ 19142, // Rule ID 49092 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ORI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49092,
        GIR_Done,
      // Label 922: @19142
      GIM_Try, /*On fail goto*//*Label 923*/ 19159, // Rule ID 49090 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (OR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::OR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49090,
        GIR_Done,
      // Label 923: @19159
      GIM_Reject,
    // Label 903: @19160
    GIM_Reject,
    // Label 872: @19161
    GIM_Try, /*On fail goto*//*Label 924*/ 20780,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 925*/ 19270, // Rule ID 50048 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 8:{ *:[i64] }), 65535:{ *:[i64] }), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 255:{ *:[i64] }))  =>  (PACKH:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50048,
        GIR_Done,
      // Label 925: @19270
      GIM_Try, /*On fail goto*//*Label 926*/ 19365, // Rule ID 55082 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 255:{ *:[i64] }), (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 8:{ *:[i64] }), 65535:{ *:[i64] }))  =>  (PACKH:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55082,
        GIR_Done,
      // Label 926: @19365
      GIM_Try, /*On fail goto*//*Label 927*/ 19460, // Rule ID 55084 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 255,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 8,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 255:{ *:[i64] }), (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 255:{ *:[i64] }), 8:{ *:[i64] }))  =>  (PACKH:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55084,
        GIR_Done,
      // Label 927: @19460
      GIM_Try, /*On fail goto*//*Label 928*/ 19555, // Rule ID 50050 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 255,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 8,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 255:{ *:[i64] }), 8:{ *:[i64] }), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 255:{ *:[i64] }))  =>  (PACKH:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50050,
        GIR_Done,
      // Label 928: @19555
      GIM_Try, /*On fail goto*//*Label 929*/ 19629, // Rule ID 50057 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbp_IsRV64,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -4294967296,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -4294967296:{ *:[i64] }), (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 32:{ *:[i64] }))  =>  (PACKU:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKU,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50057,
        GIR_Done,
      // Label 929: @19629
      GIM_Try, /*On fail goto*//*Label 930*/ 19703, // Rule ID 50053 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb_IsRV64,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294967295,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 32:{ *:[i64] }))  =>  (PACK:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACK,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50053,
        GIR_Done,
      // Label 930: @19703
      GIM_Try, /*On fail goto*//*Label 931*/ 19777, // Rule ID 55091 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbp_IsRV64,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -4294967296,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i64] } (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 32:{ *:[i64] }), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -4294967296:{ *:[i64] }))  =>  (PACKU:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACKU,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55091,
        GIR_Done,
      // Label 931: @19777
      GIM_Try, /*On fail goto*//*Label 932*/ 19851, // Rule ID 55087 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbpOrZbkb_IsRV64,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 4294967295,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 32:{ *:[i64] }), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }))  =>  (PACK:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PACK,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55087,
        GIR_Done,
      // Label 932: @19851
      GIM_Try, /*On fail goto*//*Label 933*/ 19947, // Rule ID 55068 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs3), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2))  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55068,
        GIR_Done,
      // Label 933: @19947
      GIM_Try, /*On fail goto*//*Label 934*/ 20043, // Rule ID 49989 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs3), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs1))  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49989,
        GIR_Done,
      // Label 934: @20043
      GIM_Try, /*On fail goto*//*Label 935*/ 20139, // Rule ID 55072 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs3, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] })), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2))  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55072,
        GIR_Done,
      // Label 935: @20139
      GIM_Try, /*On fail goto*//*Label 936*/ 20235, // Rule ID 55070 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs3, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] })), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs1))  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55070,
        GIR_Done,
      // Label 936: @20235
      GIM_Try, /*On fail goto*//*Label 937*/ 20331, // Rule ID 55074 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs1), (and:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs3))  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55074,
        GIR_Done,
      // Label 937: @20331
      GIM_Try, /*On fail goto*//*Label 938*/ 20427, // Rule ID 55078 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2), (and:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs3))  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55078,
        GIR_Done,
      // Label 938: @20427
      GIM_Try, /*On fail goto*//*Label 939*/ 20523, // Rule ID 55076 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs1), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs3, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] })))  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55076,
        GIR_Done,
      // Label 939: @20523
      GIM_Try, /*On fail goto*//*Label 940*/ 20619, // Rule ID 55080 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbt,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] rs2
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs3, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] })))  =>  (CMIX:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, GPR:{ *:[i64] }:$rs3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CMIX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55080,
        GIR_Done,
      // Label 940: @20619
      GIM_Try, /*On fail goto*//*Label 941*/ 20672, // Rule ID 55054 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs1)  =>  (ORN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55054,
        GIR_Done,
      // Label 941: @20672
      GIM_Try, /*On fail goto*//*Label 942*/ 20725, // Rule ID 49897 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }))  =>  (ORN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49897,
        GIR_Done,
      // Label 942: @20725
      GIM_Try, /*On fail goto*//*Label 943*/ 20762, // Rule ID 49091 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ORI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49091,
        GIR_Done,
      // Label 943: @20762
      GIM_Try, /*On fail goto*//*Label 944*/ 20779, // Rule ID 49089 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (OR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::OR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49089,
        GIR_Done,
      // Label 944: @20779
      GIM_Reject,
    // Label 924: @20780
    GIM_Reject,
    // Label 873: @20781
    GIM_Try, /*On fail goto*//*Label 945*/ 20864,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 946*/ 20833, // Rule ID 27335 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMOR_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27335,
        GIR_Done,
      // Label 946: @20833
      GIM_Try, /*On fail goto*//*Label 947*/ 20863, // Rule ID 27336 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMOR_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27336,
        GIR_Done,
      // Label 947: @20863
      GIM_Reject,
    // Label 945: @20864
    GIM_Reject,
    // Label 874: @20865
    GIM_Try, /*On fail goto*//*Label 948*/ 20948,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 949*/ 20917, // Rule ID 23477 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVOR_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23477,
        GIR_Done,
      // Label 949: @20917
      GIM_Try, /*On fail goto*//*Label 950*/ 20947, // Rule ID 23478 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVOR_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23478,
        GIR_Done,
      // Label 950: @20947
      GIM_Reject,
    // Label 948: @20948
    GIM_Reject,
    // Label 875: @20949
    GIM_Try, /*On fail goto*//*Label 951*/ 21032,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 952*/ 21001, // Rule ID 23489 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVOR_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23489,
        GIR_Done,
      // Label 952: @21001
      GIM_Try, /*On fail goto*//*Label 953*/ 21031, // Rule ID 23490 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVOR_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23490,
        GIR_Done,
      // Label 953: @21031
      GIM_Reject,
    // Label 951: @21032
    GIM_Reject,
    // Label 876: @21033
    GIM_Try, /*On fail goto*//*Label 954*/ 21116,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 955*/ 21085, // Rule ID 23497 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23497,
        GIR_Done,
      // Label 955: @21085
      GIM_Try, /*On fail goto*//*Label 956*/ 21115, // Rule ID 23498 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23498,
        GIR_Done,
      // Label 956: @21115
      GIM_Reject,
    // Label 954: @21116
    GIM_Reject,
    // Label 877: @21117
    GIM_Try, /*On fail goto*//*Label 957*/ 21200,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 958*/ 21169, // Rule ID 23513 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23513,
        GIR_Done,
      // Label 958: @21169
      GIM_Try, /*On fail goto*//*Label 959*/ 21199, // Rule ID 23514 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23514,
        GIR_Done,
      // Label 959: @21199
      GIM_Reject,
    // Label 957: @21200
    GIM_Reject,
    // Label 878: @21201
    GIM_Try, /*On fail goto*//*Label 960*/ 21284,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 961*/ 21253, // Rule ID 27353 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMOR_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27353,
        GIR_Done,
      // Label 961: @21253
      GIM_Try, /*On fail goto*//*Label 962*/ 21283, // Rule ID 27354 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMOR_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27354,
        GIR_Done,
      // Label 962: @21283
      GIM_Reject,
    // Label 960: @21284
    GIM_Reject,
    // Label 879: @21285
    GIM_Try, /*On fail goto*//*Label 963*/ 21368,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 964*/ 21337, // Rule ID 23481 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVOR_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23481,
        GIR_Done,
      // Label 964: @21337
      GIM_Try, /*On fail goto*//*Label 965*/ 21367, // Rule ID 23482 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVOR_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23482,
        GIR_Done,
      // Label 965: @21367
      GIM_Reject,
    // Label 963: @21368
    GIM_Reject,
    // Label 880: @21369
    GIM_Try, /*On fail goto*//*Label 966*/ 21452,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 967*/ 21421, // Rule ID 23493 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23493,
        GIR_Done,
      // Label 967: @21421
      GIM_Try, /*On fail goto*//*Label 968*/ 21451, // Rule ID 23494 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23494,
        GIR_Done,
      // Label 968: @21451
      GIM_Reject,
    // Label 966: @21452
    GIM_Reject,
    // Label 881: @21453
    GIM_Try, /*On fail goto*//*Label 969*/ 21536,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 970*/ 21505, // Rule ID 23509 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23509,
        GIR_Done,
      // Label 970: @21505
      GIM_Try, /*On fail goto*//*Label 971*/ 21535, // Rule ID 23510 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23510,
        GIR_Done,
      // Label 971: @21535
      GIM_Reject,
    // Label 969: @21536
    GIM_Reject,
    // Label 882: @21537
    GIM_Try, /*On fail goto*//*Label 972*/ 21620,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 973*/ 21589, // Rule ID 23553 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23553,
        GIR_Done,
      // Label 973: @21589
      GIM_Try, /*On fail goto*//*Label 974*/ 21619, // Rule ID 23554 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23554,
        GIR_Done,
      // Label 974: @21619
      GIM_Reject,
    // Label 972: @21620
    GIM_Reject,
    // Label 883: @21621
    GIM_Try, /*On fail goto*//*Label 975*/ 21704,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 976*/ 21673, // Rule ID 27371 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMOR_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27371,
        GIR_Done,
      // Label 976: @21673
      GIM_Try, /*On fail goto*//*Label 977*/ 21703, // Rule ID 27372 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMOR_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27372,
        GIR_Done,
      // Label 977: @21703
      GIM_Reject,
    // Label 975: @21704
    GIM_Reject,
    // Label 884: @21705
    GIM_Try, /*On fail goto*//*Label 978*/ 21788,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 979*/ 21757, // Rule ID 23485 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23485,
        GIR_Done,
      // Label 979: @21757
      GIM_Try, /*On fail goto*//*Label 980*/ 21787, // Rule ID 23486 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23486,
        GIR_Done,
      // Label 980: @21787
      GIM_Reject,
    // Label 978: @21788
    GIM_Reject,
    // Label 885: @21789
    GIM_Try, /*On fail goto*//*Label 981*/ 21872,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 982*/ 21841, // Rule ID 23505 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23505,
        GIR_Done,
      // Label 982: @21841
      GIM_Try, /*On fail goto*//*Label 983*/ 21871, // Rule ID 23506 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23506,
        GIR_Done,
      // Label 983: @21871
      GIM_Reject,
    // Label 981: @21872
    GIM_Reject,
    // Label 886: @21873
    GIM_Try, /*On fail goto*//*Label 984*/ 21956,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 985*/ 21925, // Rule ID 23541 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23541,
        GIR_Done,
      // Label 985: @21925
      GIM_Try, /*On fail goto*//*Label 986*/ 21955, // Rule ID 23542 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23542,
        GIR_Done,
      // Label 986: @21955
      GIM_Reject,
    // Label 984: @21956
    GIM_Reject,
    // Label 887: @21957
    GIM_Try, /*On fail goto*//*Label 987*/ 22040,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 988*/ 22009, // Rule ID 23557 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23557,
        GIR_Done,
      // Label 988: @22009
      GIM_Try, /*On fail goto*//*Label 989*/ 22039, // Rule ID 23558 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23558,
        GIR_Done,
      // Label 989: @22039
      GIM_Reject,
    // Label 987: @22040
    GIM_Reject,
    // Label 888: @22041
    GIM_Try, /*On fail goto*//*Label 990*/ 22124,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 991*/ 22093, // Rule ID 27389 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMOR_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27389,
        GIR_Done,
      // Label 991: @22093
      GIM_Try, /*On fail goto*//*Label 992*/ 22123, // Rule ID 27390 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMOR_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27390,
        GIR_Done,
      // Label 992: @22123
      GIM_Reject,
    // Label 990: @22124
    GIM_Reject,
    // Label 889: @22125
    GIM_Try, /*On fail goto*//*Label 993*/ 22208,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 994*/ 22177, // Rule ID 23501 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23501,
        GIR_Done,
      // Label 994: @22177
      GIM_Try, /*On fail goto*//*Label 995*/ 22207, // Rule ID 23502 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23502,
        GIR_Done,
      // Label 995: @22207
      GIM_Reject,
    // Label 993: @22208
    GIM_Reject,
    // Label 890: @22209
    GIM_Try, /*On fail goto*//*Label 996*/ 22292,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 997*/ 22261, // Rule ID 23529 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23529,
        GIR_Done,
      // Label 997: @22261
      GIM_Try, /*On fail goto*//*Label 998*/ 22291, // Rule ID 23530 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23530,
        GIR_Done,
      // Label 998: @22291
      GIM_Reject,
    // Label 996: @22292
    GIM_Reject,
    // Label 891: @22293
    GIM_Try, /*On fail goto*//*Label 999*/ 22376,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1000*/ 22345, // Rule ID 23545 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23545,
        GIR_Done,
      // Label 1000: @22345
      GIM_Try, /*On fail goto*//*Label 1001*/ 22375, // Rule ID 23546 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23546,
        GIR_Done,
      // Label 1001: @22375
      GIM_Reject,
    // Label 999: @22376
    GIM_Reject,
    // Label 892: @22377
    GIM_Try, /*On fail goto*//*Label 1002*/ 22460,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1003*/ 22429, // Rule ID 23561 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23561,
        GIR_Done,
      // Label 1003: @22429
      GIM_Try, /*On fail goto*//*Label 1004*/ 22459, // Rule ID 23562 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23562,
        GIR_Done,
      // Label 1004: @22459
      GIM_Reject,
    // Label 1002: @22460
    GIM_Reject,
    // Label 893: @22461
    GIM_Try, /*On fail goto*//*Label 1005*/ 22544,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1006*/ 22513, // Rule ID 27407 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMOR_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27407,
        GIR_Done,
      // Label 1006: @22513
      GIM_Try, /*On fail goto*//*Label 1007*/ 22543, // Rule ID 27408 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMOR_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27408,
        GIR_Done,
      // Label 1007: @22543
      GIM_Reject,
    // Label 1005: @22544
    GIM_Reject,
    // Label 894: @22545
    GIM_Try, /*On fail goto*//*Label 1008*/ 22628,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1009*/ 22597, // Rule ID 23517 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23517,
        GIR_Done,
      // Label 1009: @22597
      GIM_Try, /*On fail goto*//*Label 1010*/ 22627, // Rule ID 23518 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23518,
        GIR_Done,
      // Label 1010: @22627
      GIM_Reject,
    // Label 1008: @22628
    GIM_Reject,
    // Label 895: @22629
    GIM_Try, /*On fail goto*//*Label 1011*/ 22712,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1012*/ 22681, // Rule ID 23533 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23533,
        GIR_Done,
      // Label 1012: @22681
      GIM_Try, /*On fail goto*//*Label 1013*/ 22711, // Rule ID 23534 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23534,
        GIR_Done,
      // Label 1013: @22711
      GIM_Reject,
    // Label 1011: @22712
    GIM_Reject,
    // Label 896: @22713
    GIM_Try, /*On fail goto*//*Label 1014*/ 22796,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1015*/ 22765, // Rule ID 23549 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23549,
        GIR_Done,
      // Label 1015: @22765
      GIM_Try, /*On fail goto*//*Label 1016*/ 22795, // Rule ID 23550 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23550,
        GIR_Done,
      // Label 1016: @22795
      GIM_Reject,
    // Label 1014: @22796
    GIM_Reject,
    // Label 897: @22797
    GIM_Try, /*On fail goto*//*Label 1017*/ 22880,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1018*/ 22849, // Rule ID 27425 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMOR_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27425,
        GIR_Done,
      // Label 1018: @22849
      GIM_Try, /*On fail goto*//*Label 1019*/ 22879, // Rule ID 27426 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMOR_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27426,
        GIR_Done,
      // Label 1019: @22879
      GIM_Reject,
    // Label 1017: @22880
    GIM_Reject,
    // Label 898: @22881
    GIM_Try, /*On fail goto*//*Label 1020*/ 22964,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1021*/ 22933, // Rule ID 23521 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23521,
        GIR_Done,
      // Label 1021: @22933
      GIM_Try, /*On fail goto*//*Label 1022*/ 22963, // Rule ID 23522 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23522,
        GIR_Done,
      // Label 1022: @22963
      GIM_Reject,
    // Label 1020: @22964
    GIM_Reject,
    // Label 899: @22965
    GIM_Try, /*On fail goto*//*Label 1023*/ 23048,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1024*/ 23017, // Rule ID 23537 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23537,
        GIR_Done,
      // Label 1024: @23017
      GIM_Try, /*On fail goto*//*Label 1025*/ 23047, // Rule ID 23538 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23538,
        GIR_Done,
      // Label 1025: @23047
      GIM_Reject,
    // Label 1023: @23048
    GIM_Reject,
    // Label 900: @23049
    GIM_Try, /*On fail goto*//*Label 1026*/ 23132,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1027*/ 23101, // Rule ID 27443 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMOR_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27443,
        GIR_Done,
      // Label 1027: @23101
      GIM_Try, /*On fail goto*//*Label 1028*/ 23131, // Rule ID 27444 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMOR_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27444,
        GIR_Done,
      // Label 1028: @23131
      GIM_Reject,
    // Label 1026: @23132
    GIM_Reject,
    // Label 901: @23133
    GIM_Try, /*On fail goto*//*Label 1029*/ 23216,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1030*/ 23185, // Rule ID 23525 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23525,
        GIR_Done,
      // Label 1030: @23185
      GIM_Try, /*On fail goto*//*Label 1031*/ 23215, // Rule ID 23526 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23526,
        GIR_Done,
      // Label 1031: @23215
      GIM_Reject,
    // Label 1029: @23216
    GIM_Reject,
    // Label 902: @23217
    GIM_Reject,
    // Label 9: @23218
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 1063*/ 26149,
    /*GILLT_s32*//*Label 1032*/ 23255,
    /*GILLT_s64*//*Label 1033*/ 23484,
    /*GILLT_nxv1s1*//*Label 1034*/ 23713,
    /*GILLT_nxv1s8*//*Label 1035*/ 23797,
    /*GILLT_nxv1s16*//*Label 1036*/ 23881,
    /*GILLT_nxv1s32*//*Label 1037*/ 23965,
    /*GILLT_nxv1s64*//*Label 1038*/ 24049,
    /*GILLT_nxv2s1*//*Label 1039*/ 24133,
    /*GILLT_nxv2s8*//*Label 1040*/ 24217,
    /*GILLT_nxv2s16*//*Label 1041*/ 24301,
    /*GILLT_nxv2s32*//*Label 1042*/ 24385,
    /*GILLT_nxv2s64*//*Label 1043*/ 24469,
    /*GILLT_nxv4s1*//*Label 1044*/ 24553,
    /*GILLT_nxv4s8*//*Label 1045*/ 24637,
    /*GILLT_nxv4s16*//*Label 1046*/ 24721,
    /*GILLT_nxv4s32*//*Label 1047*/ 24805,
    /*GILLT_nxv4s64*//*Label 1048*/ 24889,
    /*GILLT_nxv8s1*//*Label 1049*/ 24973,
    /*GILLT_nxv8s8*//*Label 1050*/ 25057,
    /*GILLT_nxv8s16*//*Label 1051*/ 25141,
    /*GILLT_nxv8s32*//*Label 1052*/ 25225,
    /*GILLT_nxv8s64*//*Label 1053*/ 25309,
    /*GILLT_nxv16s1*//*Label 1054*/ 25393,
    /*GILLT_nxv16s8*//*Label 1055*/ 25477,
    /*GILLT_nxv16s16*//*Label 1056*/ 25561,
    /*GILLT_nxv16s32*//*Label 1057*/ 25645,
    /*GILLT_nxv32s1*//*Label 1058*/ 25729,
    /*GILLT_nxv32s8*//*Label 1059*/ 25813,
    /*GILLT_nxv32s16*//*Label 1060*/ 25897,
    /*GILLT_nxv64s1*//*Label 1061*/ 25981,
    /*GILLT_nxv64s8*//*Label 1062*/ 26065,
    // Label 1032: @23255
    GIM_Try, /*On fail goto*//*Label 1064*/ 23483,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1065*/ 23322, // Rule ID 55059 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs2)  =>  (XNOR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55059,
        GIR_Done,
      // Label 1065: @23322
      GIM_Try, /*On fail goto*//*Label 1066*/ 23375, // Rule ID 55057 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), -1:{ *:[i32] })  =>  (XNOR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55057,
        GIR_Done,
      // Label 1066: @23375
      GIM_Try, /*On fail goto*//*Label 1067*/ 23428, // Rule ID 49900 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (XNOR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49900,
        GIR_Done,
      // Label 1067: @23428
      GIM_Try, /*On fail goto*//*Label 1068*/ 23465, // Rule ID 49100 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (XORI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XORI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49100,
        GIR_Done,
      // Label 1068: @23465
      GIM_Try, /*On fail goto*//*Label 1069*/ 23482, // Rule ID 49098 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (XOR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::XOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49098,
        GIR_Done,
      // Label 1069: @23482
      GIM_Reject,
    // Label 1064: @23483
    GIM_Reject,
    // Label 1033: @23484
    GIM_Try, /*On fail goto*//*Label 1070*/ 23712,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1071*/ 23551, // Rule ID 55058 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)  =>  (XNOR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55058,
        GIR_Done,
      // Label 1071: @23551
      GIM_Try, /*On fail goto*//*Label 1072*/ 23604, // Rule ID 55056 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2), -1:{ *:[i64] })  =>  (XNOR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55056,
        GIR_Done,
      // Label 1072: @23604
      GIM_Try, /*On fail goto*//*Label 1073*/ 23657, // Rule ID 49899 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbpOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }))  =>  (XNOR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49899,
        GIR_Done,
      // Label 1073: @23657
      GIM_Try, /*On fail goto*//*Label 1074*/ 23694, // Rule ID 49099 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (XORI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XORI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49099,
        GIR_Done,
      // Label 1074: @23694
      GIM_Try, /*On fail goto*//*Label 1075*/ 23711, // Rule ID 49097 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (XOR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::XOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49097,
        GIR_Done,
      // Label 1075: @23711
      GIM_Reject,
    // Label 1070: @23712
    GIM_Reject,
    // Label 1034: @23713
    GIM_Try, /*On fail goto*//*Label 1076*/ 23796,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1077*/ 23765, // Rule ID 27337 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27337,
        GIR_Done,
      // Label 1077: @23765
      GIM_Try, /*On fail goto*//*Label 1078*/ 23795, // Rule ID 27338 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27338,
        GIR_Done,
      // Label 1078: @23795
      GIM_Reject,
    // Label 1076: @23796
    GIM_Reject,
    // Label 1035: @23797
    GIM_Try, /*On fail goto*//*Label 1079*/ 23880,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1080*/ 23849, // Rule ID 23609 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVXOR_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23609,
        GIR_Done,
      // Label 1080: @23849
      GIM_Try, /*On fail goto*//*Label 1081*/ 23879, // Rule ID 23610 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVXOR_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23610,
        GIR_Done,
      // Label 1081: @23879
      GIM_Reject,
    // Label 1079: @23880
    GIM_Reject,
    // Label 1036: @23881
    GIM_Try, /*On fail goto*//*Label 1082*/ 23964,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1083*/ 23933, // Rule ID 23621 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVXOR_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23621,
        GIR_Done,
      // Label 1083: @23933
      GIM_Try, /*On fail goto*//*Label 1084*/ 23963, // Rule ID 23622 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVXOR_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23622,
        GIR_Done,
      // Label 1084: @23963
      GIM_Reject,
    // Label 1082: @23964
    GIM_Reject,
    // Label 1037: @23965
    GIM_Try, /*On fail goto*//*Label 1085*/ 24048,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1086*/ 24017, // Rule ID 23629 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23629,
        GIR_Done,
      // Label 1086: @24017
      GIM_Try, /*On fail goto*//*Label 1087*/ 24047, // Rule ID 23630 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23630,
        GIR_Done,
      // Label 1087: @24047
      GIM_Reject,
    // Label 1085: @24048
    GIM_Reject,
    // Label 1038: @24049
    GIM_Try, /*On fail goto*//*Label 1088*/ 24132,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1089*/ 24101, // Rule ID 23645 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23645,
        GIR_Done,
      // Label 1089: @24101
      GIM_Try, /*On fail goto*//*Label 1090*/ 24131, // Rule ID 23646 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23646,
        GIR_Done,
      // Label 1090: @24131
      GIM_Reject,
    // Label 1088: @24132
    GIM_Reject,
    // Label 1039: @24133
    GIM_Try, /*On fail goto*//*Label 1091*/ 24216,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1092*/ 24185, // Rule ID 27355 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27355,
        GIR_Done,
      // Label 1092: @24185
      GIM_Try, /*On fail goto*//*Label 1093*/ 24215, // Rule ID 27356 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27356,
        GIR_Done,
      // Label 1093: @24215
      GIM_Reject,
    // Label 1091: @24216
    GIM_Reject,
    // Label 1040: @24217
    GIM_Try, /*On fail goto*//*Label 1094*/ 24300,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1095*/ 24269, // Rule ID 23613 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVXOR_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23613,
        GIR_Done,
      // Label 1095: @24269
      GIM_Try, /*On fail goto*//*Label 1096*/ 24299, // Rule ID 23614 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVXOR_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23614,
        GIR_Done,
      // Label 1096: @24299
      GIM_Reject,
    // Label 1094: @24300
    GIM_Reject,
    // Label 1041: @24301
    GIM_Try, /*On fail goto*//*Label 1097*/ 24384,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1098*/ 24353, // Rule ID 23625 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23625,
        GIR_Done,
      // Label 1098: @24353
      GIM_Try, /*On fail goto*//*Label 1099*/ 24383, // Rule ID 23626 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23626,
        GIR_Done,
      // Label 1099: @24383
      GIM_Reject,
    // Label 1097: @24384
    GIM_Reject,
    // Label 1042: @24385
    GIM_Try, /*On fail goto*//*Label 1100*/ 24468,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1101*/ 24437, // Rule ID 23641 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23641,
        GIR_Done,
      // Label 1101: @24437
      GIM_Try, /*On fail goto*//*Label 1102*/ 24467, // Rule ID 23642 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23642,
        GIR_Done,
      // Label 1102: @24467
      GIM_Reject,
    // Label 1100: @24468
    GIM_Reject,
    // Label 1043: @24469
    GIM_Try, /*On fail goto*//*Label 1103*/ 24552,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1104*/ 24521, // Rule ID 23685 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23685,
        GIR_Done,
      // Label 1104: @24521
      GIM_Try, /*On fail goto*//*Label 1105*/ 24551, // Rule ID 23686 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23686,
        GIR_Done,
      // Label 1105: @24551
      GIM_Reject,
    // Label 1103: @24552
    GIM_Reject,
    // Label 1044: @24553
    GIM_Try, /*On fail goto*//*Label 1106*/ 24636,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1107*/ 24605, // Rule ID 27373 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27373,
        GIR_Done,
      // Label 1107: @24605
      GIM_Try, /*On fail goto*//*Label 1108*/ 24635, // Rule ID 27374 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27374,
        GIR_Done,
      // Label 1108: @24635
      GIM_Reject,
    // Label 1106: @24636
    GIM_Reject,
    // Label 1045: @24637
    GIM_Try, /*On fail goto*//*Label 1109*/ 24720,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1110*/ 24689, // Rule ID 23617 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23617,
        GIR_Done,
      // Label 1110: @24689
      GIM_Try, /*On fail goto*//*Label 1111*/ 24719, // Rule ID 23618 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23618,
        GIR_Done,
      // Label 1111: @24719
      GIM_Reject,
    // Label 1109: @24720
    GIM_Reject,
    // Label 1046: @24721
    GIM_Try, /*On fail goto*//*Label 1112*/ 24804,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1113*/ 24773, // Rule ID 23637 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23637,
        GIR_Done,
      // Label 1113: @24773
      GIM_Try, /*On fail goto*//*Label 1114*/ 24803, // Rule ID 23638 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23638,
        GIR_Done,
      // Label 1114: @24803
      GIM_Reject,
    // Label 1112: @24804
    GIM_Reject,
    // Label 1047: @24805
    GIM_Try, /*On fail goto*//*Label 1115*/ 24888,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1116*/ 24857, // Rule ID 23673 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23673,
        GIR_Done,
      // Label 1116: @24857
      GIM_Try, /*On fail goto*//*Label 1117*/ 24887, // Rule ID 23674 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23674,
        GIR_Done,
      // Label 1117: @24887
      GIM_Reject,
    // Label 1115: @24888
    GIM_Reject,
    // Label 1048: @24889
    GIM_Try, /*On fail goto*//*Label 1118*/ 24972,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1119*/ 24941, // Rule ID 23689 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23689,
        GIR_Done,
      // Label 1119: @24941
      GIM_Try, /*On fail goto*//*Label 1120*/ 24971, // Rule ID 23690 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23690,
        GIR_Done,
      // Label 1120: @24971
      GIM_Reject,
    // Label 1118: @24972
    GIM_Reject,
    // Label 1049: @24973
    GIM_Try, /*On fail goto*//*Label 1121*/ 25056,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1122*/ 25025, // Rule ID 27391 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMXOR_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27391,
        GIR_Done,
      // Label 1122: @25025
      GIM_Try, /*On fail goto*//*Label 1123*/ 25055, // Rule ID 27392 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMXOR_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27392,
        GIR_Done,
      // Label 1123: @25055
      GIM_Reject,
    // Label 1121: @25056
    GIM_Reject,
    // Label 1050: @25057
    GIM_Try, /*On fail goto*//*Label 1124*/ 25140,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1125*/ 25109, // Rule ID 23633 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23633,
        GIR_Done,
      // Label 1125: @25109
      GIM_Try, /*On fail goto*//*Label 1126*/ 25139, // Rule ID 23634 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23634,
        GIR_Done,
      // Label 1126: @25139
      GIM_Reject,
    // Label 1124: @25140
    GIM_Reject,
    // Label 1051: @25141
    GIM_Try, /*On fail goto*//*Label 1127*/ 25224,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1128*/ 25193, // Rule ID 23661 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23661,
        GIR_Done,
      // Label 1128: @25193
      GIM_Try, /*On fail goto*//*Label 1129*/ 25223, // Rule ID 23662 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23662,
        GIR_Done,
      // Label 1129: @25223
      GIM_Reject,
    // Label 1127: @25224
    GIM_Reject,
    // Label 1052: @25225
    GIM_Try, /*On fail goto*//*Label 1130*/ 25308,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1131*/ 25277, // Rule ID 23677 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23677,
        GIR_Done,
      // Label 1131: @25277
      GIM_Try, /*On fail goto*//*Label 1132*/ 25307, // Rule ID 23678 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23678,
        GIR_Done,
      // Label 1132: @25307
      GIM_Reject,
    // Label 1130: @25308
    GIM_Reject,
    // Label 1053: @25309
    GIM_Try, /*On fail goto*//*Label 1133*/ 25392,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1134*/ 25361, // Rule ID 23693 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23693,
        GIR_Done,
      // Label 1134: @25361
      GIM_Try, /*On fail goto*//*Label 1135*/ 25391, // Rule ID 23694 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23694,
        GIR_Done,
      // Label 1135: @25391
      GIM_Reject,
    // Label 1133: @25392
    GIM_Reject,
    // Label 1054: @25393
    GIM_Try, /*On fail goto*//*Label 1136*/ 25476,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1137*/ 25445, // Rule ID 27409 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMXOR_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27409,
        GIR_Done,
      // Label 1137: @25445
      GIM_Try, /*On fail goto*//*Label 1138*/ 25475, // Rule ID 27410 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMXOR_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27410,
        GIR_Done,
      // Label 1138: @25475
      GIM_Reject,
    // Label 1136: @25476
    GIM_Reject,
    // Label 1055: @25477
    GIM_Try, /*On fail goto*//*Label 1139*/ 25560,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1140*/ 25529, // Rule ID 23649 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23649,
        GIR_Done,
      // Label 1140: @25529
      GIM_Try, /*On fail goto*//*Label 1141*/ 25559, // Rule ID 23650 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23650,
        GIR_Done,
      // Label 1141: @25559
      GIM_Reject,
    // Label 1139: @25560
    GIM_Reject,
    // Label 1056: @25561
    GIM_Try, /*On fail goto*//*Label 1142*/ 25644,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1143*/ 25613, // Rule ID 23665 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23665,
        GIR_Done,
      // Label 1143: @25613
      GIM_Try, /*On fail goto*//*Label 1144*/ 25643, // Rule ID 23666 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23666,
        GIR_Done,
      // Label 1144: @25643
      GIM_Reject,
    // Label 1142: @25644
    GIM_Reject,
    // Label 1057: @25645
    GIM_Try, /*On fail goto*//*Label 1145*/ 25728,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1146*/ 25697, // Rule ID 23681 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23681,
        GIR_Done,
      // Label 1146: @25697
      GIM_Try, /*On fail goto*//*Label 1147*/ 25727, // Rule ID 23682 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23682,
        GIR_Done,
      // Label 1147: @25727
      GIM_Reject,
    // Label 1145: @25728
    GIM_Reject,
    // Label 1058: @25729
    GIM_Try, /*On fail goto*//*Label 1148*/ 25812,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1149*/ 25781, // Rule ID 27427 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMXOR_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27427,
        GIR_Done,
      // Label 1149: @25781
      GIM_Try, /*On fail goto*//*Label 1150*/ 25811, // Rule ID 27428 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMXOR_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27428,
        GIR_Done,
      // Label 1150: @25811
      GIM_Reject,
    // Label 1148: @25812
    GIM_Reject,
    // Label 1059: @25813
    GIM_Try, /*On fail goto*//*Label 1151*/ 25896,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1152*/ 25865, // Rule ID 23653 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23653,
        GIR_Done,
      // Label 1152: @25865
      GIM_Try, /*On fail goto*//*Label 1153*/ 25895, // Rule ID 23654 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23654,
        GIR_Done,
      // Label 1153: @25895
      GIM_Reject,
    // Label 1151: @25896
    GIM_Reject,
    // Label 1060: @25897
    GIM_Try, /*On fail goto*//*Label 1154*/ 25980,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1155*/ 25949, // Rule ID 23669 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23669,
        GIR_Done,
      // Label 1155: @25949
      GIM_Try, /*On fail goto*//*Label 1156*/ 25979, // Rule ID 23670 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23670,
        GIR_Done,
      // Label 1156: @25979
      GIM_Reject,
    // Label 1154: @25980
    GIM_Reject,
    // Label 1061: @25981
    GIM_Try, /*On fail goto*//*Label 1157*/ 26064,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1158*/ 26033, // Rule ID 27445 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMXOR_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27445,
        GIR_Done,
      // Label 1158: @26033
      GIM_Try, /*On fail goto*//*Label 1159*/ 26063, // Rule ID 27446 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMXOR_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 27446,
        GIR_Done,
      // Label 1159: @26063
      GIM_Reject,
    // Label 1157: @26064
    GIM_Reject,
    // Label 1062: @26065
    GIM_Try, /*On fail goto*//*Label 1160*/ 26148,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1161*/ 26117, // Rule ID 23657 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23657,
        GIR_Done,
      // Label 1161: @26117
      GIM_Try, /*On fail goto*//*Label 1162*/ 26147, // Rule ID 23658 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 23658,
        GIR_Done,
      // Label 1162: @26147
      GIM_Reject,
    // Label 1160: @26148
    GIM_Reject,
    // Label 1063: @26149
    GIM_Reject,
    // Label 10: @26150
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1165*/ 26250,
    /*GILLT_s32*//*Label 1163*/ 26158,
    /*GILLT_s64*//*Label 1164*/ 26204,
    // Label 1163: @26158
    GIM_Try, /*On fail goto*//*Label 1166*/ 26203,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1167*/ 26183, // Rule ID 49701 //
        GIM_CheckFeatures, GIFBS_HasStdExtF_IsRV32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::FPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (bitconvert:{ *:[f32] } GPR:{ *:[i32] }:$rs1)  =>  (FMV_W_X:{ *:[f32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::FMV_W_X,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49701,
        GIR_Done,
      // Label 1167: @26183
      GIM_Try, /*On fail goto*//*Label 1168*/ 26202, // Rule ID 49702 //
        GIM_CheckFeatures, GIFBS_HasStdExtF_IsRV32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR32RegClassID,
        // (bitconvert:{ *:[i32] } FPR32:{ *:[f32] }:$rs1)  =>  (FMV_X_W:{ *:[i32] } FPR32:{ *:[f32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::FMV_X_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49702,
        GIR_Done,
      // Label 1168: @26202
      GIM_Reject,
    // Label 1166: @26203
    GIM_Reject,
    // Label 1164: @26204
    GIM_Try, /*On fail goto*//*Label 1169*/ 26249,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1170*/ 26229, // Rule ID 49867 //
        GIM_CheckFeatures, GIFBS_HasStdExtD_IsRV64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (bitconvert:{ *:[f64] } GPR:{ *:[i64] }:$rs1)  =>  (FMV_D_X:{ *:[f64] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::FMV_D_X,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49867,
        GIR_Done,
      // Label 1170: @26229
      GIM_Try, /*On fail goto*//*Label 1171*/ 26248, // Rule ID 49868 //
        GIM_CheckFeatures, GIFBS_HasStdExtD_IsRV64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR64RegClassID,
        // (bitconvert:{ *:[i64] } FPR64:{ *:[f64] }:$rs1)  =>  (FMV_X_D:{ *:[i64] } FPR64:{ *:[f64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::FMV_X_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49868,
        GIR_Done,
      // Label 1171: @26248
      GIM_Reject,
    // Label 1169: @26249
    GIM_Reject,
    // Label 1165: @26250
    GIM_Reject,
    // Label 11: @26251
    GIM_Try, /*On fail goto*//*Label 1172*/ 26282, // Rule ID 49281 //
      GIM_CheckFeatures, GIFBS_IsRV64,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      // (readcyclecounter:{ *:[i64] })  =>  (CSRRS:{ *:[i64] } 3072:{ *:[i64] }, X0:{ *:[i64] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CSRRS,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddImm, /*InsnID*/0, /*Imm*/3072,
      GIR_AddRegister, /*InsnID*/0, RISCV::X0, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 49281,
      GIR_Done,
    // Label 1172: @26282
    GIM_Reject,
    // Label 12: @26283
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1175*/ 27695,
    /*GILLT_s32*//*Label 1173*/ 26291,
    /*GILLT_s64*//*Label 1174*/ 26993,
    // Label 1173: @26291
    GIM_Try, /*On fail goto*//*Label 1176*/ 26992,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1177*/ 26370, // Rule ID 49468 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_monotonic>>  =>  (PseudoCmpXchg32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49468,
        GIR_Done,
      // Label 1177: @26370
      GIM_Try, /*On fail goto*//*Label 1178*/ 26439, // Rule ID 49470 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_acquire>>  =>  (PseudoCmpXchg32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49470,
        GIR_Done,
      // Label 1178: @26439
      GIM_Try, /*On fail goto*//*Label 1179*/ 26508, // Rule ID 49472 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_release>>  =>  (PseudoCmpXchg32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 5:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49472,
        GIR_Done,
      // Label 1179: @26508
      GIM_Try, /*On fail goto*//*Label 1180*/ 26577, // Rule ID 49474 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_acq_rel>>  =>  (PseudoCmpXchg32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 6:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49474,
        GIR_Done,
      // Label 1180: @26577
      GIM_Try, /*On fail goto*//*Label 1181*/ 26646, // Rule ID 49476 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_seq_cst>>  =>  (PseudoCmpXchg32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 7:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/7,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49476,
        GIR_Done,
      // Label 1181: @26646
      GIM_Try, /*On fail goto*//*Label 1182*/ 26715, // Rule ID 49593 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_monotonic>>  =>  (PseudoCmpXchg64:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49593,
        GIR_Done,
      // Label 1182: @26715
      GIM_Try, /*On fail goto*//*Label 1183*/ 26784, // Rule ID 49595 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_acquire>>  =>  (PseudoCmpXchg64:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49595,
        GIR_Done,
      // Label 1183: @26784
      GIM_Try, /*On fail goto*//*Label 1184*/ 26853, // Rule ID 49597 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_release>>  =>  (PseudoCmpXchg64:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 5:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49597,
        GIR_Done,
      // Label 1184: @26853
      GIM_Try, /*On fail goto*//*Label 1185*/ 26922, // Rule ID 49599 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_acq_rel>>  =>  (PseudoCmpXchg64:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 6:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49599,
        GIR_Done,
      // Label 1185: @26922
      GIM_Try, /*On fail goto*//*Label 1186*/ 26991, // Rule ID 49601 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_seq_cst>>  =>  (PseudoCmpXchg64:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 7:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/7,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49601,
        GIR_Done,
      // Label 1186: @26991
      GIM_Reject,
    // Label 1176: @26992
    GIM_Reject,
    // Label 1174: @26993
    GIM_Try, /*On fail goto*//*Label 1187*/ 27694,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1188*/ 27072, // Rule ID 49467 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_monotonic>>  =>  (PseudoCmpXchg32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 2:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49467,
        GIR_Done,
      // Label 1188: @27072
      GIM_Try, /*On fail goto*//*Label 1189*/ 27141, // Rule ID 49469 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_acquire>>  =>  (PseudoCmpXchg32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 4:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49469,
        GIR_Done,
      // Label 1189: @27141
      GIM_Try, /*On fail goto*//*Label 1190*/ 27210, // Rule ID 49471 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_release>>  =>  (PseudoCmpXchg32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 5:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49471,
        GIR_Done,
      // Label 1190: @27210
      GIM_Try, /*On fail goto*//*Label 1191*/ 27279, // Rule ID 49473 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_acq_rel>>  =>  (PseudoCmpXchg32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 6:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49473,
        GIR_Done,
      // Label 1191: @27279
      GIM_Try, /*On fail goto*//*Label 1192*/ 27348, // Rule ID 49475 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_seq_cst>>  =>  (PseudoCmpXchg32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 7:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/7,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49475,
        GIR_Done,
      // Label 1192: @27348
      GIM_Try, /*On fail goto*//*Label 1193*/ 27417, // Rule ID 49592 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_monotonic>>  =>  (PseudoCmpXchg64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 2:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49592,
        GIR_Done,
      // Label 1193: @27417
      GIM_Try, /*On fail goto*//*Label 1194*/ 27486, // Rule ID 49594 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_acquire>>  =>  (PseudoCmpXchg64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 4:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49594,
        GIR_Done,
      // Label 1194: @27486
      GIM_Try, /*On fail goto*//*Label 1195*/ 27555, // Rule ID 49596 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_release>>  =>  (PseudoCmpXchg64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 5:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49596,
        GIR_Done,
      // Label 1195: @27555
      GIM_Try, /*On fail goto*//*Label 1196*/ 27624, // Rule ID 49598 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_acq_rel>>  =>  (PseudoCmpXchg64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 6:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49598,
        GIR_Done,
      // Label 1196: @27624
      GIM_Try, /*On fail goto*//*Label 1197*/ 27693, // Rule ID 49600 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_seq_cst>>  =>  (PseudoCmpXchg64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 7:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/7,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49600,
        GIR_Done,
      // Label 1197: @27693
      GIM_Reject,
    // Label 1187: @27694
    GIM_Reject,
    // Label 1175: @27695
    GIM_Reject,
    // Label 13: @27696
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1200*/ 28400,
    /*GILLT_s32*//*Label 1198*/ 27704,
    /*GILLT_s64*//*Label 1199*/ 28052,
    // Label 1198: @27704
    GIM_Try, /*On fail goto*//*Label 1201*/ 28051,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1202*/ 27744, // Rule ID 49350 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_monotonic>>  =>  (AMOSWAP_W:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49350,
        GIR_Done,
      // Label 1202: @27744
      GIM_Try, /*On fail goto*//*Label 1203*/ 27778, // Rule ID 49352 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_acquire>>  =>  (AMOSWAP_W_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49352,
        GIR_Done,
      // Label 1203: @27778
      GIM_Try, /*On fail goto*//*Label 1204*/ 27812, // Rule ID 49354 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_release>>  =>  (AMOSWAP_W_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49354,
        GIR_Done,
      // Label 1204: @27812
      GIM_Try, /*On fail goto*//*Label 1205*/ 27846, // Rule ID 49356 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_acq_rel>>  =>  (AMOSWAP_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49356,
        GIR_Done,
      // Label 1205: @27846
      GIM_Try, /*On fail goto*//*Label 1206*/ 27880, // Rule ID 49358 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_seq_cst>>  =>  (AMOSWAP_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49358,
        GIR_Done,
      // Label 1206: @27880
      GIM_Try, /*On fail goto*//*Label 1207*/ 27914, // Rule ID 49485 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_monotonic>>  =>  (AMOSWAP_D:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49485,
        GIR_Done,
      // Label 1207: @27914
      GIM_Try, /*On fail goto*//*Label 1208*/ 27948, // Rule ID 49487 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_acquire>>  =>  (AMOSWAP_D_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49487,
        GIR_Done,
      // Label 1208: @27948
      GIM_Try, /*On fail goto*//*Label 1209*/ 27982, // Rule ID 49489 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_release>>  =>  (AMOSWAP_D_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49489,
        GIR_Done,
      // Label 1209: @27982
      GIM_Try, /*On fail goto*//*Label 1210*/ 28016, // Rule ID 49491 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_acq_rel>>  =>  (AMOSWAP_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49491,
        GIR_Done,
      // Label 1210: @28016
      GIM_Try, /*On fail goto*//*Label 1211*/ 28050, // Rule ID 49493 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_seq_cst>>  =>  (AMOSWAP_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49493,
        GIR_Done,
      // Label 1211: @28050
      GIM_Reject,
    // Label 1201: @28051
    GIM_Reject,
    // Label 1199: @28052
    GIM_Try, /*On fail goto*//*Label 1212*/ 28399,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1213*/ 28092, // Rule ID 49349 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_monotonic>>  =>  (AMOSWAP_W:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49349,
        GIR_Done,
      // Label 1213: @28092
      GIM_Try, /*On fail goto*//*Label 1214*/ 28126, // Rule ID 49351 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_acquire>>  =>  (AMOSWAP_W_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49351,
        GIR_Done,
      // Label 1214: @28126
      GIM_Try, /*On fail goto*//*Label 1215*/ 28160, // Rule ID 49353 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_release>>  =>  (AMOSWAP_W_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49353,
        GIR_Done,
      // Label 1215: @28160
      GIM_Try, /*On fail goto*//*Label 1216*/ 28194, // Rule ID 49355 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_acq_rel>>  =>  (AMOSWAP_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49355,
        GIR_Done,
      // Label 1216: @28194
      GIM_Try, /*On fail goto*//*Label 1217*/ 28228, // Rule ID 49357 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_seq_cst>>  =>  (AMOSWAP_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49357,
        GIR_Done,
      // Label 1217: @28228
      GIM_Try, /*On fail goto*//*Label 1218*/ 28262, // Rule ID 49484 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_monotonic>>  =>  (AMOSWAP_D:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49484,
        GIR_Done,
      // Label 1218: @28262
      GIM_Try, /*On fail goto*//*Label 1219*/ 28296, // Rule ID 49486 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_acquire>>  =>  (AMOSWAP_D_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49486,
        GIR_Done,
      // Label 1219: @28296
      GIM_Try, /*On fail goto*//*Label 1220*/ 28330, // Rule ID 49488 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_release>>  =>  (AMOSWAP_D_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49488,
        GIR_Done,
      // Label 1220: @28330
      GIM_Try, /*On fail goto*//*Label 1221*/ 28364, // Rule ID 49490 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_acq_rel>>  =>  (AMOSWAP_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49490,
        GIR_Done,
      // Label 1221: @28364
      GIM_Try, /*On fail goto*//*Label 1222*/ 28398, // Rule ID 49492 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_seq_cst>>  =>  (AMOSWAP_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49492,
        GIR_Done,
      // Label 1222: @28398
      GIM_Reject,
    // Label 1212: @28399
    GIM_Reject,
    // Label 1200: @28400
    GIM_Reject,
    // Label 14: @28401
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1225*/ 29105,
    /*GILLT_s32*//*Label 1223*/ 28409,
    /*GILLT_s64*//*Label 1224*/ 28757,
    // Label 1223: @28409
    GIM_Try, /*On fail goto*//*Label 1226*/ 28756,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1227*/ 28449, // Rule ID 49360 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_monotonic>>  =>  (AMOADD_W:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49360,
        GIR_Done,
      // Label 1227: @28449
      GIM_Try, /*On fail goto*//*Label 1228*/ 28483, // Rule ID 49362 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_acquire>>  =>  (AMOADD_W_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49362,
        GIR_Done,
      // Label 1228: @28483
      GIM_Try, /*On fail goto*//*Label 1229*/ 28517, // Rule ID 49364 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_release>>  =>  (AMOADD_W_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49364,
        GIR_Done,
      // Label 1229: @28517
      GIM_Try, /*On fail goto*//*Label 1230*/ 28551, // Rule ID 49366 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_acq_rel>>  =>  (AMOADD_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49366,
        GIR_Done,
      // Label 1230: @28551
      GIM_Try, /*On fail goto*//*Label 1231*/ 28585, // Rule ID 49368 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_seq_cst>>  =>  (AMOADD_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49368,
        GIR_Done,
      // Label 1231: @28585
      GIM_Try, /*On fail goto*//*Label 1232*/ 28619, // Rule ID 49495 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_monotonic>>  =>  (AMOADD_D:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49495,
        GIR_Done,
      // Label 1232: @28619
      GIM_Try, /*On fail goto*//*Label 1233*/ 28653, // Rule ID 49497 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_acquire>>  =>  (AMOADD_D_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49497,
        GIR_Done,
      // Label 1233: @28653
      GIM_Try, /*On fail goto*//*Label 1234*/ 28687, // Rule ID 49499 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_release>>  =>  (AMOADD_D_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49499,
        GIR_Done,
      // Label 1234: @28687
      GIM_Try, /*On fail goto*//*Label 1235*/ 28721, // Rule ID 49501 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_acq_rel>>  =>  (AMOADD_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49501,
        GIR_Done,
      // Label 1235: @28721
      GIM_Try, /*On fail goto*//*Label 1236*/ 28755, // Rule ID 49503 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_seq_cst>>  =>  (AMOADD_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49503,
        GIR_Done,
      // Label 1236: @28755
      GIM_Reject,
    // Label 1226: @28756
    GIM_Reject,
    // Label 1224: @28757
    GIM_Try, /*On fail goto*//*Label 1237*/ 29104,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1238*/ 28797, // Rule ID 49359 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_monotonic>>  =>  (AMOADD_W:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49359,
        GIR_Done,
      // Label 1238: @28797
      GIM_Try, /*On fail goto*//*Label 1239*/ 28831, // Rule ID 49361 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_acquire>>  =>  (AMOADD_W_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49361,
        GIR_Done,
      // Label 1239: @28831
      GIM_Try, /*On fail goto*//*Label 1240*/ 28865, // Rule ID 49363 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_release>>  =>  (AMOADD_W_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49363,
        GIR_Done,
      // Label 1240: @28865
      GIM_Try, /*On fail goto*//*Label 1241*/ 28899, // Rule ID 49365 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_acq_rel>>  =>  (AMOADD_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49365,
        GIR_Done,
      // Label 1241: @28899
      GIM_Try, /*On fail goto*//*Label 1242*/ 28933, // Rule ID 49367 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_seq_cst>>  =>  (AMOADD_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49367,
        GIR_Done,
      // Label 1242: @28933
      GIM_Try, /*On fail goto*//*Label 1243*/ 28967, // Rule ID 49494 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_monotonic>>  =>  (AMOADD_D:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49494,
        GIR_Done,
      // Label 1243: @28967
      GIM_Try, /*On fail goto*//*Label 1244*/ 29001, // Rule ID 49496 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_acquire>>  =>  (AMOADD_D_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49496,
        GIR_Done,
      // Label 1244: @29001
      GIM_Try, /*On fail goto*//*Label 1245*/ 29035, // Rule ID 49498 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_release>>  =>  (AMOADD_D_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49498,
        GIR_Done,
      // Label 1245: @29035
      GIM_Try, /*On fail goto*//*Label 1246*/ 29069, // Rule ID 49500 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_acq_rel>>  =>  (AMOADD_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49500,
        GIR_Done,
      // Label 1246: @29069
      GIM_Try, /*On fail goto*//*Label 1247*/ 29103, // Rule ID 49502 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_seq_cst>>  =>  (AMOADD_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49502,
        GIR_Done,
      // Label 1247: @29103
      GIM_Reject,
    // Label 1237: @29104
    GIM_Reject,
    // Label 1225: @29105
    GIM_Reject,
    // Label 15: @29106
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1250*/ 30179,
    /*GILLT_s32*//*Label 1248*/ 29114,
    /*GILLT_s64*//*Label 1249*/ 29461,
    // Label 1248: @29114
    GIM_Try, /*On fail goto*//*Label 1251*/ 29460,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_Try, /*On fail goto*//*Label 1252*/ 29191, // Rule ID 49440 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_monotonic>>  =>  (AMOADD_W:{ *:[i32] } GPR:{ *:[i32] }:$addr, (SUB:{ *:[i32] } X0:{ *:[i32] }, GPR:{ *:[i32] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49440,
        GIR_Done,
      // Label 1252: @29191
      GIM_Try, /*On fail goto*//*Label 1253*/ 29258, // Rule ID 49442 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_acquire>>  =>  (AMOADD_W_AQ:{ *:[i32] } GPR:{ *:[i32] }:$addr, (SUB:{ *:[i32] } X0:{ *:[i32] }, GPR:{ *:[i32] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49442,
        GIR_Done,
      // Label 1253: @29258
      GIM_Try, /*On fail goto*//*Label 1254*/ 29325, // Rule ID 49444 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_release>>  =>  (AMOADD_W_RL:{ *:[i32] } GPR:{ *:[i32] }:$addr, (SUB:{ *:[i32] } X0:{ *:[i32] }, GPR:{ *:[i32] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_W_RL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49444,
        GIR_Done,
      // Label 1254: @29325
      GIM_Try, /*On fail goto*//*Label 1255*/ 29392, // Rule ID 49446 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_acq_rel>>  =>  (AMOADD_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$addr, (SUB:{ *:[i32] } X0:{ *:[i32] }, GPR:{ *:[i32] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ_RL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49446,
        GIR_Done,
      // Label 1255: @29392
      GIM_Try, /*On fail goto*//*Label 1256*/ 29459, // Rule ID 49448 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_seq_cst>>  =>  (AMOADD_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$addr, (SUB:{ *:[i32] } X0:{ *:[i32] }, GPR:{ *:[i32] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ_RL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49448,
        GIR_Done,
      // Label 1256: @29459
      GIM_Reject,
    // Label 1251: @29460
    GIM_Reject,
    // Label 1249: @29461
    GIM_Try, /*On fail goto*//*Label 1257*/ 30178,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1258*/ 29538, // Rule ID 49439 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_monotonic>>  =>  (AMOADD_W:{ *:[i64] } GPR:{ *:[i64] }:$addr, (SUB:{ *:[i64] } X0:{ *:[i64] }, GPR:{ *:[i64] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49439,
        GIR_Done,
      // Label 1258: @29538
      GIM_Try, /*On fail goto*//*Label 1259*/ 29609, // Rule ID 49441 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_acquire>>  =>  (AMOADD_W_AQ:{ *:[i64] } GPR:{ *:[i64] }:$addr, (SUB:{ *:[i64] } X0:{ *:[i64] }, GPR:{ *:[i64] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49441,
        GIR_Done,
      // Label 1259: @29609
      GIM_Try, /*On fail goto*//*Label 1260*/ 29680, // Rule ID 49443 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_release>>  =>  (AMOADD_W_RL:{ *:[i64] } GPR:{ *:[i64] }:$addr, (SUB:{ *:[i64] } X0:{ *:[i64] }, GPR:{ *:[i64] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_W_RL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49443,
        GIR_Done,
      // Label 1260: @29680
      GIM_Try, /*On fail goto*//*Label 1261*/ 29751, // Rule ID 49445 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_acq_rel>>  =>  (AMOADD_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$addr, (SUB:{ *:[i64] } X0:{ *:[i64] }, GPR:{ *:[i64] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ_RL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49445,
        GIR_Done,
      // Label 1261: @29751
      GIM_Try, /*On fail goto*//*Label 1262*/ 29822, // Rule ID 49447 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_seq_cst>>  =>  (AMOADD_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$addr, (SUB:{ *:[i64] } X0:{ *:[i64] }, GPR:{ *:[i64] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ_RL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49447,
        GIR_Done,
      // Label 1262: @29822
      GIM_Try, /*On fail goto*//*Label 1263*/ 29893, // Rule ID 49574 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_64>><<P:Predicate_atomic_load_sub_64_monotonic>>  =>  (AMOADD_D:{ *:[i64] } GPR:{ *:[i64] }:$addr, (SUB:{ *:[i64] } X0:{ *:[i64] }, GPR:{ *:[i64] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49574,
        GIR_Done,
      // Label 1263: @29893
      GIM_Try, /*On fail goto*//*Label 1264*/ 29964, // Rule ID 49575 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_64>><<P:Predicate_atomic_load_sub_64_acquire>>  =>  (AMOADD_D_AQ:{ *:[i64] } GPR:{ *:[i64] }:$addr, (SUB:{ *:[i64] } X0:{ *:[i64] }, GPR:{ *:[i64] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_D_AQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49575,
        GIR_Done,
      // Label 1264: @29964
      GIM_Try, /*On fail goto*//*Label 1265*/ 30035, // Rule ID 49576 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_64>><<P:Predicate_atomic_load_sub_64_release>>  =>  (AMOADD_D_RL:{ *:[i64] } GPR:{ *:[i64] }:$addr, (SUB:{ *:[i64] } X0:{ *:[i64] }, GPR:{ *:[i64] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_D_RL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49576,
        GIR_Done,
      // Label 1265: @30035
      GIM_Try, /*On fail goto*//*Label 1266*/ 30106, // Rule ID 49577 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_64>><<P:Predicate_atomic_load_sub_64_acq_rel>>  =>  (AMOADD_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$addr, (SUB:{ *:[i64] } X0:{ *:[i64] }, GPR:{ *:[i64] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_D_AQ_RL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49577,
        GIR_Done,
      // Label 1266: @30106
      GIM_Try, /*On fail goto*//*Label 1267*/ 30177, // Rule ID 49578 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_64>><<P:Predicate_atomic_load_sub_64_seq_cst>>  =>  (AMOADD_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$addr, (SUB:{ *:[i64] } X0:{ *:[i64] }, GPR:{ *:[i64] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_D_AQ_RL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49578,
        GIR_Done,
      // Label 1267: @30177
      GIM_Reject,
    // Label 1257: @30178
    GIM_Reject,
    // Label 1250: @30179
    GIM_Reject,
    // Label 16: @30180
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1270*/ 30884,
    /*GILLT_s32*//*Label 1268*/ 30188,
    /*GILLT_s64*//*Label 1269*/ 30536,
    // Label 1268: @30188
    GIM_Try, /*On fail goto*//*Label 1271*/ 30535,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1272*/ 30228, // Rule ID 49370 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_monotonic>>  =>  (AMOAND_W:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49370,
        GIR_Done,
      // Label 1272: @30228
      GIM_Try, /*On fail goto*//*Label 1273*/ 30262, // Rule ID 49372 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_acquire>>  =>  (AMOAND_W_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49372,
        GIR_Done,
      // Label 1273: @30262
      GIM_Try, /*On fail goto*//*Label 1274*/ 30296, // Rule ID 49374 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_release>>  =>  (AMOAND_W_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49374,
        GIR_Done,
      // Label 1274: @30296
      GIM_Try, /*On fail goto*//*Label 1275*/ 30330, // Rule ID 49376 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_acq_rel>>  =>  (AMOAND_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49376,
        GIR_Done,
      // Label 1275: @30330
      GIM_Try, /*On fail goto*//*Label 1276*/ 30364, // Rule ID 49378 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_seq_cst>>  =>  (AMOAND_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49378,
        GIR_Done,
      // Label 1276: @30364
      GIM_Try, /*On fail goto*//*Label 1277*/ 30398, // Rule ID 49505 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_monotonic>>  =>  (AMOAND_D:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49505,
        GIR_Done,
      // Label 1277: @30398
      GIM_Try, /*On fail goto*//*Label 1278*/ 30432, // Rule ID 49507 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_acquire>>  =>  (AMOAND_D_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49507,
        GIR_Done,
      // Label 1278: @30432
      GIM_Try, /*On fail goto*//*Label 1279*/ 30466, // Rule ID 49509 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_release>>  =>  (AMOAND_D_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49509,
        GIR_Done,
      // Label 1279: @30466
      GIM_Try, /*On fail goto*//*Label 1280*/ 30500, // Rule ID 49511 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_acq_rel>>  =>  (AMOAND_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49511,
        GIR_Done,
      // Label 1280: @30500
      GIM_Try, /*On fail goto*//*Label 1281*/ 30534, // Rule ID 49513 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_seq_cst>>  =>  (AMOAND_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49513,
        GIR_Done,
      // Label 1281: @30534
      GIM_Reject,
    // Label 1271: @30535
    GIM_Reject,
    // Label 1269: @30536
    GIM_Try, /*On fail goto*//*Label 1282*/ 30883,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1283*/ 30576, // Rule ID 49369 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_monotonic>>  =>  (AMOAND_W:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49369,
        GIR_Done,
      // Label 1283: @30576
      GIM_Try, /*On fail goto*//*Label 1284*/ 30610, // Rule ID 49371 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_acquire>>  =>  (AMOAND_W_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49371,
        GIR_Done,
      // Label 1284: @30610
      GIM_Try, /*On fail goto*//*Label 1285*/ 30644, // Rule ID 49373 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_release>>  =>  (AMOAND_W_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49373,
        GIR_Done,
      // Label 1285: @30644
      GIM_Try, /*On fail goto*//*Label 1286*/ 30678, // Rule ID 49375 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_acq_rel>>  =>  (AMOAND_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49375,
        GIR_Done,
      // Label 1286: @30678
      GIM_Try, /*On fail goto*//*Label 1287*/ 30712, // Rule ID 49377 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_seq_cst>>  =>  (AMOAND_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49377,
        GIR_Done,
      // Label 1287: @30712
      GIM_Try, /*On fail goto*//*Label 1288*/ 30746, // Rule ID 49504 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_monotonic>>  =>  (AMOAND_D:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49504,
        GIR_Done,
      // Label 1288: @30746
      GIM_Try, /*On fail goto*//*Label 1289*/ 30780, // Rule ID 49506 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_acquire>>  =>  (AMOAND_D_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49506,
        GIR_Done,
      // Label 1289: @30780
      GIM_Try, /*On fail goto*//*Label 1290*/ 30814, // Rule ID 49508 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_release>>  =>  (AMOAND_D_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49508,
        GIR_Done,
      // Label 1290: @30814
      GIM_Try, /*On fail goto*//*Label 1291*/ 30848, // Rule ID 49510 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_acq_rel>>  =>  (AMOAND_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49510,
        GIR_Done,
      // Label 1291: @30848
      GIM_Try, /*On fail goto*//*Label 1292*/ 30882, // Rule ID 49512 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_seq_cst>>  =>  (AMOAND_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49512,
        GIR_Done,
      // Label 1292: @30882
      GIM_Reject,
    // Label 1282: @30883
    GIM_Reject,
    // Label 1270: @30884
    GIM_Reject,
    // Label 17: @30885
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1295*/ 31808,
    /*GILLT_s32*//*Label 1293*/ 30893,
    /*GILLT_s64*//*Label 1294*/ 31190,
    // Label 1293: @30893
    GIM_Try, /*On fail goto*//*Label 1296*/ 31189,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_Try, /*On fail goto*//*Label 1297*/ 30960, // Rule ID 49450 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_nand_32>><<P:Predicate_atomic_load_nand_32_monotonic>>  =>  (PseudoAtomicLoadNand32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr, 2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49450,
        GIR_Done,
      // Label 1297: @30960
      GIM_Try, /*On fail goto*//*Label 1298*/ 31017, // Rule ID 49452 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_nand_32>><<P:Predicate_atomic_load_nand_32_acquire>>  =>  (PseudoAtomicLoadNand32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr, 4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49452,
        GIR_Done,
      // Label 1298: @31017
      GIM_Try, /*On fail goto*//*Label 1299*/ 31074, // Rule ID 49454 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_nand_32>><<P:Predicate_atomic_load_nand_32_release>>  =>  (PseudoAtomicLoadNand32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr, 5:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49454,
        GIR_Done,
      // Label 1299: @31074
      GIM_Try, /*On fail goto*//*Label 1300*/ 31131, // Rule ID 49456 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_nand_32>><<P:Predicate_atomic_load_nand_32_acq_rel>>  =>  (PseudoAtomicLoadNand32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr, 6:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49456,
        GIR_Done,
      // Label 1300: @31131
      GIM_Try, /*On fail goto*//*Label 1301*/ 31188, // Rule ID 49458 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_nand_32>><<P:Predicate_atomic_load_nand_32_seq_cst>>  =>  (PseudoAtomicLoadNand32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr, 7:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/7,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49458,
        GIR_Done,
      // Label 1301: @31188
      GIM_Reject,
    // Label 1296: @31189
    GIM_Reject,
    // Label 1294: @31190
    GIM_Try, /*On fail goto*//*Label 1302*/ 31807,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1303*/ 31257, // Rule ID 49449 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_32>><<P:Predicate_atomic_load_nand_32_monotonic>>  =>  (PseudoAtomicLoadNand32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr, 2:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49449,
        GIR_Done,
      // Label 1303: @31257
      GIM_Try, /*On fail goto*//*Label 1304*/ 31318, // Rule ID 49451 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_32>><<P:Predicate_atomic_load_nand_32_acquire>>  =>  (PseudoAtomicLoadNand32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr, 4:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49451,
        GIR_Done,
      // Label 1304: @31318
      GIM_Try, /*On fail goto*//*Label 1305*/ 31379, // Rule ID 49453 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_32>><<P:Predicate_atomic_load_nand_32_release>>  =>  (PseudoAtomicLoadNand32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr, 5:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49453,
        GIR_Done,
      // Label 1305: @31379
      GIM_Try, /*On fail goto*//*Label 1306*/ 31440, // Rule ID 49455 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_32>><<P:Predicate_atomic_load_nand_32_acq_rel>>  =>  (PseudoAtomicLoadNand32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr, 6:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49455,
        GIR_Done,
      // Label 1306: @31440
      GIM_Try, /*On fail goto*//*Label 1307*/ 31501, // Rule ID 49457 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_32>><<P:Predicate_atomic_load_nand_32_seq_cst>>  =>  (PseudoAtomicLoadNand32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr, 7:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/7,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49457,
        GIR_Done,
      // Label 1307: @31501
      GIM_Try, /*On fail goto*//*Label 1308*/ 31562, // Rule ID 49579 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_64>><<P:Predicate_atomic_load_nand_64_monotonic>>  =>  (PseudoAtomicLoadNand64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr, 2:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49579,
        GIR_Done,
      // Label 1308: @31562
      GIM_Try, /*On fail goto*//*Label 1309*/ 31623, // Rule ID 49580 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_64>><<P:Predicate_atomic_load_nand_64_acquire>>  =>  (PseudoAtomicLoadNand64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr, 4:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49580,
        GIR_Done,
      // Label 1309: @31623
      GIM_Try, /*On fail goto*//*Label 1310*/ 31684, // Rule ID 49581 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_64>><<P:Predicate_atomic_load_nand_64_release>>  =>  (PseudoAtomicLoadNand64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr, 5:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49581,
        GIR_Done,
      // Label 1310: @31684
      GIM_Try, /*On fail goto*//*Label 1311*/ 31745, // Rule ID 49582 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_64>><<P:Predicate_atomic_load_nand_64_acq_rel>>  =>  (PseudoAtomicLoadNand64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr, 6:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49582,
        GIR_Done,
      // Label 1311: @31745
      GIM_Try, /*On fail goto*//*Label 1312*/ 31806, // Rule ID 49583 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_64>><<P:Predicate_atomic_load_nand_64_seq_cst>>  =>  (PseudoAtomicLoadNand64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr, 7:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/7,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49583,
        GIR_Done,
      // Label 1312: @31806
      GIM_Reject,
    // Label 1302: @31807
    GIM_Reject,
    // Label 1295: @31808
    GIM_Reject,
    // Label 18: @31809
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1315*/ 32513,
    /*GILLT_s32*//*Label 1313*/ 31817,
    /*GILLT_s64*//*Label 1314*/ 32165,
    // Label 1313: @31817
    GIM_Try, /*On fail goto*//*Label 1316*/ 32164,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1317*/ 31857, // Rule ID 49380 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_monotonic>>  =>  (AMOOR_W:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49380,
        GIR_Done,
      // Label 1317: @31857
      GIM_Try, /*On fail goto*//*Label 1318*/ 31891, // Rule ID 49382 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_acquire>>  =>  (AMOOR_W_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49382,
        GIR_Done,
      // Label 1318: @31891
      GIM_Try, /*On fail goto*//*Label 1319*/ 31925, // Rule ID 49384 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_release>>  =>  (AMOOR_W_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49384,
        GIR_Done,
      // Label 1319: @31925
      GIM_Try, /*On fail goto*//*Label 1320*/ 31959, // Rule ID 49386 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_acq_rel>>  =>  (AMOOR_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49386,
        GIR_Done,
      // Label 1320: @31959
      GIM_Try, /*On fail goto*//*Label 1321*/ 31993, // Rule ID 49388 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_seq_cst>>  =>  (AMOOR_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49388,
        GIR_Done,
      // Label 1321: @31993
      GIM_Try, /*On fail goto*//*Label 1322*/ 32027, // Rule ID 49515 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_monotonic>>  =>  (AMOOR_D:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49515,
        GIR_Done,
      // Label 1322: @32027
      GIM_Try, /*On fail goto*//*Label 1323*/ 32061, // Rule ID 49517 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_acquire>>  =>  (AMOOR_D_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49517,
        GIR_Done,
      // Label 1323: @32061
      GIM_Try, /*On fail goto*//*Label 1324*/ 32095, // Rule ID 49519 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_release>>  =>  (AMOOR_D_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49519,
        GIR_Done,
      // Label 1324: @32095
      GIM_Try, /*On fail goto*//*Label 1325*/ 32129, // Rule ID 49521 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_acq_rel>>  =>  (AMOOR_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49521,
        GIR_Done,
      // Label 1325: @32129
      GIM_Try, /*On fail goto*//*Label 1326*/ 32163, // Rule ID 49523 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_seq_cst>>  =>  (AMOOR_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49523,
        GIR_Done,
      // Label 1326: @32163
      GIM_Reject,
    // Label 1316: @32164
    GIM_Reject,
    // Label 1314: @32165
    GIM_Try, /*On fail goto*//*Label 1327*/ 32512,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1328*/ 32205, // Rule ID 49379 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_monotonic>>  =>  (AMOOR_W:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49379,
        GIR_Done,
      // Label 1328: @32205
      GIM_Try, /*On fail goto*//*Label 1329*/ 32239, // Rule ID 49381 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_acquire>>  =>  (AMOOR_W_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49381,
        GIR_Done,
      // Label 1329: @32239
      GIM_Try, /*On fail goto*//*Label 1330*/ 32273, // Rule ID 49383 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_release>>  =>  (AMOOR_W_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49383,
        GIR_Done,
      // Label 1330: @32273
      GIM_Try, /*On fail goto*//*Label 1331*/ 32307, // Rule ID 49385 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_acq_rel>>  =>  (AMOOR_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49385,
        GIR_Done,
      // Label 1331: @32307
      GIM_Try, /*On fail goto*//*Label 1332*/ 32341, // Rule ID 49387 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_seq_cst>>  =>  (AMOOR_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49387,
        GIR_Done,
      // Label 1332: @32341
      GIM_Try, /*On fail goto*//*Label 1333*/ 32375, // Rule ID 49514 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_monotonic>>  =>  (AMOOR_D:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49514,
        GIR_Done,
      // Label 1333: @32375
      GIM_Try, /*On fail goto*//*Label 1334*/ 32409, // Rule ID 49516 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_acquire>>  =>  (AMOOR_D_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49516,
        GIR_Done,
      // Label 1334: @32409
      GIM_Try, /*On fail goto*//*Label 1335*/ 32443, // Rule ID 49518 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_release>>  =>  (AMOOR_D_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49518,
        GIR_Done,
      // Label 1335: @32443
      GIM_Try, /*On fail goto*//*Label 1336*/ 32477, // Rule ID 49520 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_acq_rel>>  =>  (AMOOR_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49520,
        GIR_Done,
      // Label 1336: @32477
      GIM_Try, /*On fail goto*//*Label 1337*/ 32511, // Rule ID 49522 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_seq_cst>>  =>  (AMOOR_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49522,
        GIR_Done,
      // Label 1337: @32511
      GIM_Reject,
    // Label 1327: @32512
    GIM_Reject,
    // Label 1315: @32513
    GIM_Reject,
    // Label 19: @32514
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1340*/ 33218,
    /*GILLT_s32*//*Label 1338*/ 32522,
    /*GILLT_s64*//*Label 1339*/ 32870,
    // Label 1338: @32522
    GIM_Try, /*On fail goto*//*Label 1341*/ 32869,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1342*/ 32562, // Rule ID 49390 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_monotonic>>  =>  (AMOXOR_W:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49390,
        GIR_Done,
      // Label 1342: @32562
      GIM_Try, /*On fail goto*//*Label 1343*/ 32596, // Rule ID 49392 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_acquire>>  =>  (AMOXOR_W_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49392,
        GIR_Done,
      // Label 1343: @32596
      GIM_Try, /*On fail goto*//*Label 1344*/ 32630, // Rule ID 49394 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_release>>  =>  (AMOXOR_W_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49394,
        GIR_Done,
      // Label 1344: @32630
      GIM_Try, /*On fail goto*//*Label 1345*/ 32664, // Rule ID 49396 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_acq_rel>>  =>  (AMOXOR_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49396,
        GIR_Done,
      // Label 1345: @32664
      GIM_Try, /*On fail goto*//*Label 1346*/ 32698, // Rule ID 49398 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_seq_cst>>  =>  (AMOXOR_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49398,
        GIR_Done,
      // Label 1346: @32698
      GIM_Try, /*On fail goto*//*Label 1347*/ 32732, // Rule ID 49525 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_monotonic>>  =>  (AMOXOR_D:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49525,
        GIR_Done,
      // Label 1347: @32732
      GIM_Try, /*On fail goto*//*Label 1348*/ 32766, // Rule ID 49527 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_acquire>>  =>  (AMOXOR_D_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49527,
        GIR_Done,
      // Label 1348: @32766
      GIM_Try, /*On fail goto*//*Label 1349*/ 32800, // Rule ID 49529 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_release>>  =>  (AMOXOR_D_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49529,
        GIR_Done,
      // Label 1349: @32800
      GIM_Try, /*On fail goto*//*Label 1350*/ 32834, // Rule ID 49531 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_acq_rel>>  =>  (AMOXOR_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49531,
        GIR_Done,
      // Label 1350: @32834
      GIM_Try, /*On fail goto*//*Label 1351*/ 32868, // Rule ID 49533 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_seq_cst>>  =>  (AMOXOR_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49533,
        GIR_Done,
      // Label 1351: @32868
      GIM_Reject,
    // Label 1341: @32869
    GIM_Reject,
    // Label 1339: @32870
    GIM_Try, /*On fail goto*//*Label 1352*/ 33217,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1353*/ 32910, // Rule ID 49389 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_monotonic>>  =>  (AMOXOR_W:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49389,
        GIR_Done,
      // Label 1353: @32910
      GIM_Try, /*On fail goto*//*Label 1354*/ 32944, // Rule ID 49391 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_acquire>>  =>  (AMOXOR_W_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49391,
        GIR_Done,
      // Label 1354: @32944
      GIM_Try, /*On fail goto*//*Label 1355*/ 32978, // Rule ID 49393 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_release>>  =>  (AMOXOR_W_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49393,
        GIR_Done,
      // Label 1355: @32978
      GIM_Try, /*On fail goto*//*Label 1356*/ 33012, // Rule ID 49395 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_acq_rel>>  =>  (AMOXOR_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49395,
        GIR_Done,
      // Label 1356: @33012
      GIM_Try, /*On fail goto*//*Label 1357*/ 33046, // Rule ID 49397 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_seq_cst>>  =>  (AMOXOR_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49397,
        GIR_Done,
      // Label 1357: @33046
      GIM_Try, /*On fail goto*//*Label 1358*/ 33080, // Rule ID 49524 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_monotonic>>  =>  (AMOXOR_D:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49524,
        GIR_Done,
      // Label 1358: @33080
      GIM_Try, /*On fail goto*//*Label 1359*/ 33114, // Rule ID 49526 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_acquire>>  =>  (AMOXOR_D_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49526,
        GIR_Done,
      // Label 1359: @33114
      GIM_Try, /*On fail goto*//*Label 1360*/ 33148, // Rule ID 49528 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_release>>  =>  (AMOXOR_D_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49528,
        GIR_Done,
      // Label 1360: @33148
      GIM_Try, /*On fail goto*//*Label 1361*/ 33182, // Rule ID 49530 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_acq_rel>>  =>  (AMOXOR_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49530,
        GIR_Done,
      // Label 1361: @33182
      GIM_Try, /*On fail goto*//*Label 1362*/ 33216, // Rule ID 49532 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_seq_cst>>  =>  (AMOXOR_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49532,
        GIR_Done,
      // Label 1362: @33216
      GIM_Reject,
    // Label 1352: @33217
    GIM_Reject,
    // Label 1340: @33218
    GIM_Reject,
    // Label 20: @33219
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1365*/ 33923,
    /*GILLT_s32*//*Label 1363*/ 33227,
    /*GILLT_s64*//*Label 1364*/ 33575,
    // Label 1363: @33227
    GIM_Try, /*On fail goto*//*Label 1366*/ 33574,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1367*/ 33267, // Rule ID 49400 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_max:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_monotonic>>  =>  (AMOMAX_W:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAX_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49400,
        GIR_Done,
      // Label 1367: @33267
      GIM_Try, /*On fail goto*//*Label 1368*/ 33301, // Rule ID 49402 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_max:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_acquire>>  =>  (AMOMAX_W_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAX_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49402,
        GIR_Done,
      // Label 1368: @33301
      GIM_Try, /*On fail goto*//*Label 1369*/ 33335, // Rule ID 49404 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_max:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_release>>  =>  (AMOMAX_W_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAX_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49404,
        GIR_Done,
      // Label 1369: @33335
      GIM_Try, /*On fail goto*//*Label 1370*/ 33369, // Rule ID 49406 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_max:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_acq_rel>>  =>  (AMOMAX_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAX_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49406,
        GIR_Done,
      // Label 1370: @33369
      GIM_Try, /*On fail goto*//*Label 1371*/ 33403, // Rule ID 49408 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_max:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_seq_cst>>  =>  (AMOMAX_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAX_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49408,
        GIR_Done,
      // Label 1371: @33403
      GIM_Try, /*On fail goto*//*Label 1372*/ 33437, // Rule ID 49535 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_max:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_monotonic>>  =>  (AMOMAX_D:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAX_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49535,
        GIR_Done,
      // Label 1372: @33437
      GIM_Try, /*On fail goto*//*Label 1373*/ 33471, // Rule ID 49537 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_max:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_acquire>>  =>  (AMOMAX_D_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAX_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49537,
        GIR_Done,
      // Label 1373: @33471
      GIM_Try, /*On fail goto*//*Label 1374*/ 33505, // Rule ID 49539 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_max:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_release>>  =>  (AMOMAX_D_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAX_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49539,
        GIR_Done,
      // Label 1374: @33505
      GIM_Try, /*On fail goto*//*Label 1375*/ 33539, // Rule ID 49541 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_max:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_acq_rel>>  =>  (AMOMAX_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAX_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49541,
        GIR_Done,
      // Label 1375: @33539
      GIM_Try, /*On fail goto*//*Label 1376*/ 33573, // Rule ID 49543 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_max:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_seq_cst>>  =>  (AMOMAX_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAX_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49543,
        GIR_Done,
      // Label 1376: @33573
      GIM_Reject,
    // Label 1366: @33574
    GIM_Reject,
    // Label 1364: @33575
    GIM_Try, /*On fail goto*//*Label 1377*/ 33922,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1378*/ 33615, // Rule ID 49399 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_max:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_monotonic>>  =>  (AMOMAX_W:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAX_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49399,
        GIR_Done,
      // Label 1378: @33615
      GIM_Try, /*On fail goto*//*Label 1379*/ 33649, // Rule ID 49401 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_max:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_acquire>>  =>  (AMOMAX_W_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAX_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49401,
        GIR_Done,
      // Label 1379: @33649
      GIM_Try, /*On fail goto*//*Label 1380*/ 33683, // Rule ID 49403 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_max:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_release>>  =>  (AMOMAX_W_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAX_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49403,
        GIR_Done,
      // Label 1380: @33683
      GIM_Try, /*On fail goto*//*Label 1381*/ 33717, // Rule ID 49405 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_max:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_acq_rel>>  =>  (AMOMAX_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAX_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49405,
        GIR_Done,
      // Label 1381: @33717
      GIM_Try, /*On fail goto*//*Label 1382*/ 33751, // Rule ID 49407 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_max:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_max_32>><<P:Predicate_atomic_load_max_32_seq_cst>>  =>  (AMOMAX_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAX_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49407,
        GIR_Done,
      // Label 1382: @33751
      GIM_Try, /*On fail goto*//*Label 1383*/ 33785, // Rule ID 49534 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_max:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_monotonic>>  =>  (AMOMAX_D:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAX_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49534,
        GIR_Done,
      // Label 1383: @33785
      GIM_Try, /*On fail goto*//*Label 1384*/ 33819, // Rule ID 49536 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_max:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_acquire>>  =>  (AMOMAX_D_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAX_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49536,
        GIR_Done,
      // Label 1384: @33819
      GIM_Try, /*On fail goto*//*Label 1385*/ 33853, // Rule ID 49538 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_max:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_release>>  =>  (AMOMAX_D_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAX_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49538,
        GIR_Done,
      // Label 1385: @33853
      GIM_Try, /*On fail goto*//*Label 1386*/ 33887, // Rule ID 49540 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_max:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_acq_rel>>  =>  (AMOMAX_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAX_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49540,
        GIR_Done,
      // Label 1386: @33887
      GIM_Try, /*On fail goto*//*Label 1387*/ 33921, // Rule ID 49542 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_max:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_max_64>><<P:Predicate_atomic_load_max_64_seq_cst>>  =>  (AMOMAX_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAX_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49542,
        GIR_Done,
      // Label 1387: @33921
      GIM_Reject,
    // Label 1377: @33922
    GIM_Reject,
    // Label 1365: @33923
    GIM_Reject,
    // Label 21: @33924
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1390*/ 34628,
    /*GILLT_s32*//*Label 1388*/ 33932,
    /*GILLT_s64*//*Label 1389*/ 34280,
    // Label 1388: @33932
    GIM_Try, /*On fail goto*//*Label 1391*/ 34279,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1392*/ 33972, // Rule ID 49410 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_min:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_monotonic>>  =>  (AMOMIN_W:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMIN_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49410,
        GIR_Done,
      // Label 1392: @33972
      GIM_Try, /*On fail goto*//*Label 1393*/ 34006, // Rule ID 49412 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_min:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_acquire>>  =>  (AMOMIN_W_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMIN_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49412,
        GIR_Done,
      // Label 1393: @34006
      GIM_Try, /*On fail goto*//*Label 1394*/ 34040, // Rule ID 49414 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_min:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_release>>  =>  (AMOMIN_W_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMIN_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49414,
        GIR_Done,
      // Label 1394: @34040
      GIM_Try, /*On fail goto*//*Label 1395*/ 34074, // Rule ID 49416 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_min:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_acq_rel>>  =>  (AMOMIN_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMIN_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49416,
        GIR_Done,
      // Label 1395: @34074
      GIM_Try, /*On fail goto*//*Label 1396*/ 34108, // Rule ID 49418 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_min:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_seq_cst>>  =>  (AMOMIN_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMIN_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49418,
        GIR_Done,
      // Label 1396: @34108
      GIM_Try, /*On fail goto*//*Label 1397*/ 34142, // Rule ID 49545 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_min:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_monotonic>>  =>  (AMOMIN_D:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMIN_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49545,
        GIR_Done,
      // Label 1397: @34142
      GIM_Try, /*On fail goto*//*Label 1398*/ 34176, // Rule ID 49547 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_min:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_acquire>>  =>  (AMOMIN_D_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMIN_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49547,
        GIR_Done,
      // Label 1398: @34176
      GIM_Try, /*On fail goto*//*Label 1399*/ 34210, // Rule ID 49549 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_min:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_release>>  =>  (AMOMIN_D_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMIN_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49549,
        GIR_Done,
      // Label 1399: @34210
      GIM_Try, /*On fail goto*//*Label 1400*/ 34244, // Rule ID 49551 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_min:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_acq_rel>>  =>  (AMOMIN_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMIN_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49551,
        GIR_Done,
      // Label 1400: @34244
      GIM_Try, /*On fail goto*//*Label 1401*/ 34278, // Rule ID 49553 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_min:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_seq_cst>>  =>  (AMOMIN_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMIN_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49553,
        GIR_Done,
      // Label 1401: @34278
      GIM_Reject,
    // Label 1391: @34279
    GIM_Reject,
    // Label 1389: @34280
    GIM_Try, /*On fail goto*//*Label 1402*/ 34627,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1403*/ 34320, // Rule ID 49409 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_min:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_monotonic>>  =>  (AMOMIN_W:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMIN_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49409,
        GIR_Done,
      // Label 1403: @34320
      GIM_Try, /*On fail goto*//*Label 1404*/ 34354, // Rule ID 49411 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_min:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_acquire>>  =>  (AMOMIN_W_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMIN_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49411,
        GIR_Done,
      // Label 1404: @34354
      GIM_Try, /*On fail goto*//*Label 1405*/ 34388, // Rule ID 49413 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_min:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_release>>  =>  (AMOMIN_W_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMIN_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49413,
        GIR_Done,
      // Label 1405: @34388
      GIM_Try, /*On fail goto*//*Label 1406*/ 34422, // Rule ID 49415 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_min:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_acq_rel>>  =>  (AMOMIN_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMIN_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49415,
        GIR_Done,
      // Label 1406: @34422
      GIM_Try, /*On fail goto*//*Label 1407*/ 34456, // Rule ID 49417 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_min:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_min_32>><<P:Predicate_atomic_load_min_32_seq_cst>>  =>  (AMOMIN_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMIN_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49417,
        GIR_Done,
      // Label 1407: @34456
      GIM_Try, /*On fail goto*//*Label 1408*/ 34490, // Rule ID 49544 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_min:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_monotonic>>  =>  (AMOMIN_D:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMIN_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49544,
        GIR_Done,
      // Label 1408: @34490
      GIM_Try, /*On fail goto*//*Label 1409*/ 34524, // Rule ID 49546 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_min:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_acquire>>  =>  (AMOMIN_D_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMIN_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49546,
        GIR_Done,
      // Label 1409: @34524
      GIM_Try, /*On fail goto*//*Label 1410*/ 34558, // Rule ID 49548 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_min:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_release>>  =>  (AMOMIN_D_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMIN_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49548,
        GIR_Done,
      // Label 1410: @34558
      GIM_Try, /*On fail goto*//*Label 1411*/ 34592, // Rule ID 49550 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_min:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_acq_rel>>  =>  (AMOMIN_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMIN_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49550,
        GIR_Done,
      // Label 1411: @34592
      GIM_Try, /*On fail goto*//*Label 1412*/ 34626, // Rule ID 49552 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_min:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_min_64>><<P:Predicate_atomic_load_min_64_seq_cst>>  =>  (AMOMIN_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMIN_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49552,
        GIR_Done,
      // Label 1412: @34626
      GIM_Reject,
    // Label 1402: @34627
    GIM_Reject,
    // Label 1390: @34628
    GIM_Reject,
    // Label 22: @34629
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1415*/ 35333,
    /*GILLT_s32*//*Label 1413*/ 34637,
    /*GILLT_s64*//*Label 1414*/ 34985,
    // Label 1413: @34637
    GIM_Try, /*On fail goto*//*Label 1416*/ 34984,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1417*/ 34677, // Rule ID 49420 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_monotonic>>  =>  (AMOMAXU_W:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAXU_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49420,
        GIR_Done,
      // Label 1417: @34677
      GIM_Try, /*On fail goto*//*Label 1418*/ 34711, // Rule ID 49422 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_acquire>>  =>  (AMOMAXU_W_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAXU_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49422,
        GIR_Done,
      // Label 1418: @34711
      GIM_Try, /*On fail goto*//*Label 1419*/ 34745, // Rule ID 49424 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_release>>  =>  (AMOMAXU_W_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAXU_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49424,
        GIR_Done,
      // Label 1419: @34745
      GIM_Try, /*On fail goto*//*Label 1420*/ 34779, // Rule ID 49426 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_acq_rel>>  =>  (AMOMAXU_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAXU_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49426,
        GIR_Done,
      // Label 1420: @34779
      GIM_Try, /*On fail goto*//*Label 1421*/ 34813, // Rule ID 49428 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_seq_cst>>  =>  (AMOMAXU_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAXU_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49428,
        GIR_Done,
      // Label 1421: @34813
      GIM_Try, /*On fail goto*//*Label 1422*/ 34847, // Rule ID 49555 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_monotonic>>  =>  (AMOMAXU_D:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAXU_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49555,
        GIR_Done,
      // Label 1422: @34847
      GIM_Try, /*On fail goto*//*Label 1423*/ 34881, // Rule ID 49557 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_acquire>>  =>  (AMOMAXU_D_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAXU_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49557,
        GIR_Done,
      // Label 1423: @34881
      GIM_Try, /*On fail goto*//*Label 1424*/ 34915, // Rule ID 49559 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_release>>  =>  (AMOMAXU_D_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAXU_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49559,
        GIR_Done,
      // Label 1424: @34915
      GIM_Try, /*On fail goto*//*Label 1425*/ 34949, // Rule ID 49561 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_acq_rel>>  =>  (AMOMAXU_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAXU_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49561,
        GIR_Done,
      // Label 1425: @34949
      GIM_Try, /*On fail goto*//*Label 1426*/ 34983, // Rule ID 49563 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umax:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_seq_cst>>  =>  (AMOMAXU_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAXU_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49563,
        GIR_Done,
      // Label 1426: @34983
      GIM_Reject,
    // Label 1416: @34984
    GIM_Reject,
    // Label 1414: @34985
    GIM_Try, /*On fail goto*//*Label 1427*/ 35332,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1428*/ 35025, // Rule ID 49419 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umax:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_monotonic>>  =>  (AMOMAXU_W:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAXU_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49419,
        GIR_Done,
      // Label 1428: @35025
      GIM_Try, /*On fail goto*//*Label 1429*/ 35059, // Rule ID 49421 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umax:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_acquire>>  =>  (AMOMAXU_W_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAXU_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49421,
        GIR_Done,
      // Label 1429: @35059
      GIM_Try, /*On fail goto*//*Label 1430*/ 35093, // Rule ID 49423 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umax:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_release>>  =>  (AMOMAXU_W_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAXU_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49423,
        GIR_Done,
      // Label 1430: @35093
      GIM_Try, /*On fail goto*//*Label 1431*/ 35127, // Rule ID 49425 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umax:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_acq_rel>>  =>  (AMOMAXU_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAXU_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49425,
        GIR_Done,
      // Label 1431: @35127
      GIM_Try, /*On fail goto*//*Label 1432*/ 35161, // Rule ID 49427 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umax:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_umax_32>><<P:Predicate_atomic_load_umax_32_seq_cst>>  =>  (AMOMAXU_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAXU_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49427,
        GIR_Done,
      // Label 1432: @35161
      GIM_Try, /*On fail goto*//*Label 1433*/ 35195, // Rule ID 49554 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umax:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_monotonic>>  =>  (AMOMAXU_D:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAXU_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49554,
        GIR_Done,
      // Label 1433: @35195
      GIM_Try, /*On fail goto*//*Label 1434*/ 35229, // Rule ID 49556 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umax:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_acquire>>  =>  (AMOMAXU_D_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAXU_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49556,
        GIR_Done,
      // Label 1434: @35229
      GIM_Try, /*On fail goto*//*Label 1435*/ 35263, // Rule ID 49558 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umax:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_release>>  =>  (AMOMAXU_D_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAXU_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49558,
        GIR_Done,
      // Label 1435: @35263
      GIM_Try, /*On fail goto*//*Label 1436*/ 35297, // Rule ID 49560 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umax:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_acq_rel>>  =>  (AMOMAXU_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAXU_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49560,
        GIR_Done,
      // Label 1436: @35297
      GIM_Try, /*On fail goto*//*Label 1437*/ 35331, // Rule ID 49562 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umax:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_umax_64>><<P:Predicate_atomic_load_umax_64_seq_cst>>  =>  (AMOMAXU_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMAXU_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49562,
        GIR_Done,
      // Label 1437: @35331
      GIM_Reject,
    // Label 1427: @35332
    GIM_Reject,
    // Label 1415: @35333
    GIM_Reject,
    // Label 23: @35334
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1440*/ 36038,
    /*GILLT_s32*//*Label 1438*/ 35342,
    /*GILLT_s64*//*Label 1439*/ 35690,
    // Label 1438: @35342
    GIM_Try, /*On fail goto*//*Label 1441*/ 35689,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1442*/ 35382, // Rule ID 49430 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umin:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_monotonic>>  =>  (AMOMINU_W:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMINU_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49430,
        GIR_Done,
      // Label 1442: @35382
      GIM_Try, /*On fail goto*//*Label 1443*/ 35416, // Rule ID 49432 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umin:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_acquire>>  =>  (AMOMINU_W_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMINU_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49432,
        GIR_Done,
      // Label 1443: @35416
      GIM_Try, /*On fail goto*//*Label 1444*/ 35450, // Rule ID 49434 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umin:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_release>>  =>  (AMOMINU_W_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMINU_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49434,
        GIR_Done,
      // Label 1444: @35450
      GIM_Try, /*On fail goto*//*Label 1445*/ 35484, // Rule ID 49436 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umin:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_acq_rel>>  =>  (AMOMINU_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMINU_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49436,
        GIR_Done,
      // Label 1445: @35484
      GIM_Try, /*On fail goto*//*Label 1446*/ 35518, // Rule ID 49438 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umin:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_seq_cst>>  =>  (AMOMINU_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMINU_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49438,
        GIR_Done,
      // Label 1446: @35518
      GIM_Try, /*On fail goto*//*Label 1447*/ 35552, // Rule ID 49565 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umin:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_monotonic>>  =>  (AMOMINU_D:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMINU_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49565,
        GIR_Done,
      // Label 1447: @35552
      GIM_Try, /*On fail goto*//*Label 1448*/ 35586, // Rule ID 49567 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umin:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_acquire>>  =>  (AMOMINU_D_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMINU_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49567,
        GIR_Done,
      // Label 1448: @35586
      GIM_Try, /*On fail goto*//*Label 1449*/ 35620, // Rule ID 49569 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umin:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_release>>  =>  (AMOMINU_D_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMINU_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49569,
        GIR_Done,
      // Label 1449: @35620
      GIM_Try, /*On fail goto*//*Label 1450*/ 35654, // Rule ID 49571 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umin:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_acq_rel>>  =>  (AMOMINU_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMINU_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49571,
        GIR_Done,
      // Label 1450: @35654
      GIM_Try, /*On fail goto*//*Label 1451*/ 35688, // Rule ID 49573 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umin:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_seq_cst>>  =>  (AMOMINU_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMINU_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49573,
        GIR_Done,
      // Label 1451: @35688
      GIM_Reject,
    // Label 1441: @35689
    GIM_Reject,
    // Label 1439: @35690
    GIM_Try, /*On fail goto*//*Label 1452*/ 36037,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1453*/ 35730, // Rule ID 49429 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umin:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_monotonic>>  =>  (AMOMINU_W:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMINU_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49429,
        GIR_Done,
      // Label 1453: @35730
      GIM_Try, /*On fail goto*//*Label 1454*/ 35764, // Rule ID 49431 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umin:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_acquire>>  =>  (AMOMINU_W_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMINU_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49431,
        GIR_Done,
      // Label 1454: @35764
      GIM_Try, /*On fail goto*//*Label 1455*/ 35798, // Rule ID 49433 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umin:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_release>>  =>  (AMOMINU_W_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMINU_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49433,
        GIR_Done,
      // Label 1455: @35798
      GIM_Try, /*On fail goto*//*Label 1456*/ 35832, // Rule ID 49435 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umin:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_acq_rel>>  =>  (AMOMINU_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMINU_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49435,
        GIR_Done,
      // Label 1456: @35832
      GIM_Try, /*On fail goto*//*Label 1457*/ 35866, // Rule ID 49437 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umin:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_umin_32>><<P:Predicate_atomic_load_umin_32_seq_cst>>  =>  (AMOMINU_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMINU_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49437,
        GIR_Done,
      // Label 1457: @35866
      GIM_Try, /*On fail goto*//*Label 1458*/ 35900, // Rule ID 49564 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umin:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_monotonic>>  =>  (AMOMINU_D:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMINU_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49564,
        GIR_Done,
      // Label 1458: @35900
      GIM_Try, /*On fail goto*//*Label 1459*/ 35934, // Rule ID 49566 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umin:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_acquire>>  =>  (AMOMINU_D_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMINU_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49566,
        GIR_Done,
      // Label 1459: @35934
      GIM_Try, /*On fail goto*//*Label 1460*/ 35968, // Rule ID 49568 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umin:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_release>>  =>  (AMOMINU_D_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMINU_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49568,
        GIR_Done,
      // Label 1460: @35968
      GIM_Try, /*On fail goto*//*Label 1461*/ 36002, // Rule ID 49570 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umin:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_acq_rel>>  =>  (AMOMINU_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMINU_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49570,
        GIR_Done,
      // Label 1461: @36002
      GIM_Try, /*On fail goto*//*Label 1462*/ 36036, // Rule ID 49572 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_umin:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_umin_64>><<P:Predicate_atomic_load_umin_64_seq_cst>>  =>  (AMOMINU_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOMINU_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 49572,
        GIR_Done,
      // Label 1462: @36036
      GIM_Reject,
    // Label 1452: @36037
    GIM_Reject,
    // Label 1440: @36038
    GIM_Reject,
    // Label 24: @36039
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1465*/ 36221,
    /*GILLT_s32*//*Label 1463*/ 36047,
    /*GILLT_s64*//*Label 1464*/ 36134,
    // Label 1463: @36047
    GIM_Try, /*On fail goto*//*Label 1466*/ 36070, // Rule ID 49236 //
      GIM_CheckConstantInt, /*MI*/0, /*Op*/0, 4,
      // MIs[0] Operand 1
      GIM_CheckIsImm, /*MI*/0, /*Op*/1,
      // (atomic_fence 4:{ *:[i32] }, (timm:{ *:[i32] }))  =>  (FENCE 2:{ *:[i32] }, 3:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FENCE,
      GIR_AddImm, /*InsnID*/0, /*Imm*/2,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 49236,
      GIR_Done,
    // Label 1466: @36070
    GIM_Try, /*On fail goto*//*Label 1467*/ 36093, // Rule ID 49238 //
      GIM_CheckConstantInt, /*MI*/0, /*Op*/0, 5,
      // MIs[0] Operand 1
      GIM_CheckIsImm, /*MI*/0, /*Op*/1,
      // (atomic_fence 5:{ *:[i32] }, (timm:{ *:[i32] }))  =>  (FENCE 3:{ *:[i32] }, 1:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FENCE,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3,
      GIR_AddImm, /*InsnID*/0, /*Imm*/1,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 49238,
      GIR_Done,
    // Label 1467: @36093
    GIM_Try, /*On fail goto*//*Label 1468*/ 36110, // Rule ID 49240 //
      GIM_CheckConstantInt, /*MI*/0, /*Op*/0, 6,
      // MIs[0] Operand 1
      GIM_CheckIsImm, /*MI*/0, /*Op*/1,
      // (atomic_fence 6:{ *:[i32] }, (timm:{ *:[i32] }))  =>  (FENCE_TSO)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FENCE_TSO,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 49240,
      GIR_Done,
    // Label 1468: @36110
    GIM_Try, /*On fail goto*//*Label 1469*/ 36133, // Rule ID 49242 //
      GIM_CheckConstantInt, /*MI*/0, /*Op*/0, 7,
      // MIs[0] Operand 1
      GIM_CheckIsImm, /*MI*/0, /*Op*/1,
      // (atomic_fence 7:{ *:[i32] }, (timm:{ *:[i32] }))  =>  (FENCE 3:{ *:[i32] }, 3:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FENCE,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 49242,
      GIR_Done,
    // Label 1469: @36133
    GIM_Reject,
    // Label 1464: @36134
    GIM_Try, /*On fail goto*//*Label 1470*/ 36157, // Rule ID 49235 //
      GIM_CheckConstantInt, /*MI*/0, /*Op*/0, 4,
      // MIs[0] Operand 1
      GIM_CheckIsImm, /*MI*/0, /*Op*/1,
      // (atomic_fence 4:{ *:[i64] }, (timm:{ *:[i64] }))  =>  (FENCE 2:{ *:[i64] }, 3:{ *:[i64] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FENCE,
      GIR_AddImm, /*InsnID*/0, /*Imm*/2,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 49235,
      GIR_Done,
    // Label 1470: @36157
    GIM_Try, /*On fail goto*//*Label 1471*/ 36180, // Rule ID 49237 //
      GIM_CheckConstantInt, /*MI*/0, /*Op*/0, 5,
      // MIs[0] Operand 1
      GIM_CheckIsImm, /*MI*/0, /*Op*/1,
      // (atomic_fence 5:{ *:[i64] }, (timm:{ *:[i64] }))  =>  (FENCE 3:{ *:[i64] }, 1:{ *:[i64] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FENCE,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3,
      GIR_AddImm, /*InsnID*/0, /*Imm*/1,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 49237,
      GIR_Done,
    // Label 1471: @36180
    GIM_Try, /*On fail goto*//*Label 1472*/ 36197, // Rule ID 49239 //
      GIM_CheckConstantInt, /*MI*/0, /*Op*/0, 6,
      // MIs[0] Operand 1
      GIM_CheckIsImm, /*MI*/0, /*Op*/1,
      // (atomic_fence 6:{ *:[i64] }, (timm:{ *:[i64] }))  =>  (FENCE_TSO)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FENCE_TSO,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 49239,
      GIR_Done,
    // Label 1472: @36197
    GIM_Try, /*On fail goto*//*Label 1473*/ 36220, // Rule ID 49241 //
      GIM_CheckConstantInt, /*MI*/0, /*Op*/0, 7,
      // MIs[0] Operand 1
      GIM_CheckIsImm, /*MI*/0, /*Op*/1,
      // (atomic_fence 7:{ *:[i64] }, (timm:{ *:[i64] }))  =>  (FENCE 3:{ *:[i64] }, 3:{ *:[i64] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::FENCE,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3,
      GIR_AddImm, /*InsnID*/0, /*Imm*/3,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 49241,
      GIR_Done,
    // Label 1473: @36220
    GIM_Reject,
    // Label 1465: @36221
    GIM_Reject,
    // Label 25: @36222
    GIM_Try, /*On fail goto*//*Label 1474*/ 37548,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 1475*/ 36267, // Rule ID 50138 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbr,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::riscv_crc32_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7280:{ *:[iPTR] }, GPR:{ *:[i64] }:$rs1)  =>  (CRC32_B:{ *:[i64] } GPR:{ *:[i64] }:$rs1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CRC32_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50138,
        GIR_Done,
      // Label 1475: @36267
      GIM_Try, /*On fail goto*//*Label 1476*/ 36307, // Rule ID 50139 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbr,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::riscv_crc32_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7280:{ *:[iPTR] }, GPR:{ *:[i32] }:$rs1)  =>  (CRC32_B:{ *:[i32] } GPR:{ *:[i32] }:$rs1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CRC32_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50139,
        GIR_Done,
      // Label 1476: @36307
      GIM_Try, /*On fail goto*//*Label 1477*/ 36347, // Rule ID 50140 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbr,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::riscv_crc32_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7282:{ *:[iPTR] }, GPR:{ *:[i64] }:$rs1)  =>  (CRC32_H:{ *:[i64] } GPR:{ *:[i64] }:$rs1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CRC32_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50140,
        GIR_Done,
      // Label 1477: @36347
      GIM_Try, /*On fail goto*//*Label 1478*/ 36387, // Rule ID 50141 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbr,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::riscv_crc32_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7282:{ *:[iPTR] }, GPR:{ *:[i32] }:$rs1)  =>  (CRC32_H:{ *:[i32] } GPR:{ *:[i32] }:$rs1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CRC32_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50141,
        GIR_Done,
      // Label 1478: @36387
      GIM_Try, /*On fail goto*//*Label 1479*/ 36427, // Rule ID 50142 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbr,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::riscv_crc32_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7283:{ *:[iPTR] }, GPR:{ *:[i64] }:$rs1)  =>  (CRC32_W:{ *:[i64] } GPR:{ *:[i64] }:$rs1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CRC32_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50142,
        GIR_Done,
      // Label 1479: @36427
      GIM_Try, /*On fail goto*//*Label 1480*/ 36467, // Rule ID 50143 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbr,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::riscv_crc32_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 7283:{ *:[iPTR] }, GPR:{ *:[i32] }:$rs1)  =>  (CRC32_W:{ *:[i32] } GPR:{ *:[i32] }:$rs1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CRC32_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50143,
        GIR_Done,
      // Label 1480: @36467
      GIM_Try, /*On fail goto*//*Label 1481*/ 36507, // Rule ID 50144 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbr,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::riscv_crc32c_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i64] } 7284:{ *:[iPTR] }, GPR:{ *:[i64] }:$rs1)  =>  (CRC32C_B:{ *:[i64] } GPR:{ *:[i64] }:$rs1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CRC32C_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 50144,
        GIR_Done,
      // Label 1481: @36507
      GIM_Try, /*On fail goto*//*Label 1482*/ 36547, // Rule ID 50145 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbr,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::riscv_crc32c_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckT