/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Subtarget Enumeration Source Fragment                                      *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_SUBTARGETINFO_ENUM
#undef GET_SUBTARGETINFO_ENUM

namespace llvm {
namespace PPC {
enum {
  AIXOS = 0,
  DeprecatedDST = 1,
  Directive32 = 2,
  Directive64 = 3,
  Directive440 = 4,
  Directive601 = 5,
  Directive602 = 6,
  Directive603 = 7,
  Directive604 = 8,
  Directive620 = 9,
  Directive750 = 10,
  Directive970 = 11,
  Directive7400 = 12,
  DirectiveA2 = 13,
  DirectiveE500 = 14,
  DirectiveE500mc = 15,
  DirectiveE5500 = 16,
  DirectivePwr3 = 17,
  DirectivePwr4 = 18,
  DirectivePwr5 = 19,
  DirectivePwr5x = 20,
  DirectivePwr6 = 21,
  DirectivePwr6x = 22,
  DirectivePwr7 = 23,
  DirectivePwr8 = 24,
  DirectivePwr9 = 25,
  DirectivePwr10 = 26,
  DirectivePwrFuture = 27,
  Feature64Bit = 28,
  Feature64BitRegs = 29,
  FeatureAddLogicalFusion = 30,
  FeatureAddiLoadFusion = 31,
  FeatureAddisLoadFusion = 32,
  FeatureAltivec = 33,
  FeatureArithAddFusion = 34,
  FeatureBPERMD = 35,
  FeatureBack2BackFusion = 36,
  FeatureBookE = 37,
  FeatureCMPB = 38,
  FeatureCRBits = 39,
  FeatureCompareFusion = 40,
  FeatureDirectMove = 41,
  FeatureE500 = 42,
  FeatureEFPU2 = 43,
  FeatureExtDiv = 44,
  FeatureFCPSGN = 45,
  FeatureFPCVT = 46,
  FeatureFPRND = 47,
  FeatureFPU = 48,
  FeatureFRE = 49,
  FeatureFRES = 50,
  FeatureFRSQRTE = 51,
  FeatureFRSQRTES = 52,
  FeatureFSqrt = 53,
  FeatureFloat128 = 54,
  FeatureFusion = 55,
  FeatureHTM = 56,
  FeatureHardFloat = 57,
  FeatureICBT = 58,
  FeatureISA2_06 = 59,
  FeatureISA2_07 = 60,
  FeatureISA3_0 = 61,
  FeatureISA3_1 = 62,
  FeatureISEL = 63,
  FeatureInvariantFunctionDescriptors = 64,
  FeatureLDBRX = 65,
  FeatureLFIWAX = 66,
  FeatureLogicalAddFusion = 67,
  FeatureLogicalFusion = 68,
  FeatureLongCall = 69,
  FeatureMFOCRF = 70,
  FeatureMFTB = 71,
  FeatureMMA = 72,
  FeatureMSYNC = 73,
  FeatureModernAIXAs = 74,
  FeatureP8Altivec = 75,
  FeatureP8Crypto = 76,
  FeatureP8Vector = 77,
  FeatureP9Altivec = 78,
  FeatureP9Vector = 79,
  FeatureP10Vector = 80,
  FeaturePCRelativeMemops = 81,
  FeaturePOPCNTD = 82,
  FeaturePPC4xx = 83,
  FeaturePPC6xx = 84,
  FeaturePPCPostRASched = 85,
  FeaturePPCPreRASched = 86,
  FeaturePairedVectorMemops = 87,
  FeaturePartwordAtomic = 88,
  FeaturePredictableSelectIsExpensive = 89,
  FeaturePrefixInstrs = 90,
  FeaturePrivileged = 91,
  FeatureQuadwordAtomic = 92,
  FeatureROPProtect = 93,
  FeatureRecipPrec = 94,
  FeatureSPE = 95,
  FeatureSTFIWX = 96,
  FeatureSecurePlt = 97,
  FeatureSha3Fusion = 98,
  FeatureSlowPOPCNTD = 99,
  FeatureStoreFusion = 100,
  FeatureTwoConstNR = 101,
  FeatureUnalignedFloats = 102,
  FeatureVSX = 103,
  FeatureVectorsUseTwoUnits = 104,
  FeatureWideImmFusion = 105,
  FeatureZeroMoveFusion = 106,
  NumSubtargetFeatures = 107
};
} // end namespace PPC
} // end namespace llvm

#endif // GET_SUBTARGETINFO_ENUM


#ifdef GET_SUBTARGETINFO_MC_DESC
#undef GET_SUBTARGETINFO_MC_DESC

namespace llvm {
// Sorted (by key) array of values for CPU features.
extern const llvm::SubtargetFeatureKV PPCFeatureKV[] = {
  { "64bit", "Enable 64-bit instructions", PPC::Feature64Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "64bitregs", "Enable 64-bit registers usage for ppc32 [beta]", PPC::Feature64BitRegs, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "aix", "AIX OS", PPC::AIXOS, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "allow-unaligned-fp-access", "CPU does not trap on unaligned FP access", PPC::FeatureUnalignedFloats, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "altivec", "Enable Altivec instructions", PPC::FeatureAltivec, { { { 0x1000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "booke", "Enable Book E instructions", PPC::FeatureBookE, { { { 0x400000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "bpermd", "Enable the bpermd instruction", PPC::FeatureBPERMD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cmpb", "Enable the cmpb instruction", PPC::FeatureCMPB, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "crbits", "Use condition-register bits individually", PPC::FeatureCRBits, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "crypto", "Enable POWER8 Crypto instructions", PPC::FeatureP8Crypto, { { { 0x0ULL, 0x800ULL, 0x0ULL, 0x0ULL, } } } },
  { "direct-move", "Enable Power8 direct move instructions", PPC::FeatureDirectMove, { { { 0x0ULL, 0x8000000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "e500", "Enable E500/E500mc instructions", PPC::FeatureE500, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "efpu2", "Enable Embedded Floating-Point APU 2 instructions", PPC::FeatureEFPU2, { { { 0x0ULL, 0x80000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "extdiv", "Enable extended divide instructions", PPC::FeatureExtDiv, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fcpsgn", "Enable the fcpsgn instruction", PPC::FeatureFCPSGN, { { { 0x1000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "float128", "Enable the __float128 data type for IEEE-754R Binary128.", PPC::FeatureFloat128, { { { 0x0ULL, 0x8000000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "fpcvt", "Enable fc[ft]* (unsigned and single-precision) and lfiwzx instructions", PPC::FeatureFPCVT, { { { 0x1000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fprnd", "Enable the fri[mnpz] instructions", PPC::FeatureFPRND, { { { 0x1000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fpu", "Enable classic FPU instructions", PPC::FeatureFPU, { { { 0x200000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fre", "Enable the fre instruction", PPC::FeatureFRE, { { { 0x1000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fres", "Enable the fres instruction", PPC::FeatureFRES, { { { 0x1000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "frsqrte", "Enable the frsqrte instruction", PPC::FeatureFRSQRTE, { { { 0x1000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "frsqrtes", "Enable the frsqrtes instruction", PPC::FeatureFRSQRTES, { { { 0x1000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fsqrt", "Enable the fsqrt instruction", PPC::FeatureFSqrt, { { { 0x1000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fuse-add-logical", "Target supports Add with Logical Operations fusion", PPC::FeatureAddLogicalFusion, { { { 0x80000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fuse-addi-load", "Power8 Addi-Load fusion", PPC::FeatureAddiLoadFusion, { { { 0x80000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fuse-addis-load", "Power8 Addis-Load fusion", PPC::FeatureAddisLoadFusion, { { { 0x80000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fuse-arith-add", "Target supports Arithmetic Operations with Add fusion", PPC::FeatureArithAddFusion, { { { 0x80000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fuse-back2back", "Target supports general back to back fusion", PPC::FeatureBack2BackFusion, { { { 0x80000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fuse-cmp", "Target supports Comparison Operations fusion", PPC::FeatureCompareFusion, { { { 0x80000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fuse-logical", "Target supports Logical Operations fusion", PPC::FeatureLogicalFusion, { { { 0x80000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fuse-logical-add", "Target supports Logical with Add Operations fusion", PPC::FeatureLogicalAddFusion, { { { 0x80000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fuse-sha3", "Target supports SHA3 assist fusion", PPC::FeatureSha3Fusion, { { { 0x80000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fuse-store", "Target supports store clustering", PPC::FeatureStoreFusion, { { { 0x80000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fuse-wideimm", "Target supports Wide-Immediate fusion", PPC::FeatureWideImmFusion, { { { 0x80000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fuse-zeromove", "Target supports move to SPR with branch fusion", PPC::FeatureZeroMoveFusion, { { { 0x80000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fusion", "Target supports instruction fusion", PPC::FeatureFusion, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "hard-float", "Enable floating-point instructions", PPC::FeatureHardFloat, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "htm", "Enable Hardware Transactional Memory instructions", PPC::FeatureHTM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "icbt", "Enable icbt instruction", PPC::FeatureICBT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "invariant-function-descriptors", "Assume function descriptors are invariant", PPC::FeatureInvariantFunctionDescriptors, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "isa-v206-instructions", "Enable instructions in ISA 2.06.", PPC::FeatureISA2_06, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "isa-v207-instructions", "Enable instructions in ISA 2.07.", PPC::FeatureISA2_07, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "isa-v30-instructions", "Enable instructions in ISA 3.0.", PPC::FeatureISA3_0, { { { 0x1000000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "isa-v31-instructions", "Enable instructions in ISA 3.1.", PPC::FeatureISA3_1, { { { 0x2000000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "isel", "Enable the isel instruction", PPC::FeatureISEL, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ldbrx", "Enable the ldbrx instruction", PPC::FeatureLDBRX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lfiwax", "Enable the lfiwax instruction", PPC::FeatureLFIWAX, { { { 0x1000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "longcall", "Always use indirect calls", PPC::FeatureLongCall, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "mfocrf", "Enable the MFOCRF instruction", PPC::FeatureMFOCRF, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "mma", "Enable MMA instructions", PPC::FeatureMMA, { { { 0x0ULL, 0x806000ULL, 0x0ULL, 0x0ULL, } } } },
  { "modern-aix-as", "AIX system assembler is modern enough to support new mnes", PPC::FeatureModernAIXAs, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "msync", "Has only the msync instruction instead of sync", PPC::FeatureMSYNC, { { { 0x2000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "paired-vector-memops", "32Byte load and store instructions", PPC::FeaturePairedVectorMemops, { { { 0x2000000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "partword-atomics", "Enable l[bh]arx and st[bh]cx.", PPC::FeaturePartwordAtomic, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pcrelative-memops", "Enable PC relative Memory Ops", PPC::FeaturePCRelativeMemops, { { { 0x2000000000000000ULL, 0x4000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "popcntd", "Enable the popcnt[dw] instructions", PPC::FeaturePOPCNTD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "power10-vector", "Enable POWER10 vector instructions", PPC::FeatureP10Vector, { { { 0x4000000000000000ULL, 0x8000ULL, 0x0ULL, 0x0ULL, } } } },
  { "power8-altivec", "Enable POWER8 Altivec instructions", PPC::FeatureP8Altivec, { { { 0x200000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "power8-vector", "Enable POWER8 vector instructions", PPC::FeatureP8Vector, { { { 0x0ULL, 0x8000000800ULL, 0x0ULL, 0x0ULL, } } } },
  { "power9-altivec", "Enable POWER9 Altivec instructions", PPC::FeatureP9Altivec, { { { 0x2000000000000000ULL, 0x800ULL, 0x0ULL, 0x0ULL, } } } },
  { "power9-vector", "Enable POWER9 vector instructions", PPC::FeatureP9Vector, { { { 0x2000000000000000ULL, 0x6000ULL, 0x0ULL, 0x0ULL, } } } },
  { "ppc-postra-sched", "Use PowerPC post-RA scheduling strategy", PPC::FeaturePPCPostRASched, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ppc-prera-sched", "Use PowerPC pre-RA scheduling strategy", PPC::FeaturePPCPreRASched, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ppc4xx", "Enable PPC 4xx instructions", PPC::FeaturePPC4xx, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ppc6xx", "Enable PPC 6xx instructions", PPC::FeaturePPC6xx, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "predictable-select-expensive", "Prefer likely predicted branches over selects", PPC::FeaturePredictableSelectIsExpensive, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefix-instrs", "Enable prefixed instructions", PPC::FeaturePrefixInstrs, { { { 0x2000000000000000ULL, 0x6000ULL, 0x0ULL, 0x0ULL, } } } },
  { "privileged", "Add privileged instructions", PPC::FeaturePrivileged, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "quadword-atomics", "Enable lqarx and stqcx.", PPC::FeatureQuadwordAtomic, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "recipprec", "Assume higher precision reciprocal estimates", PPC::FeatureRecipPrec, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rop-protect", "Add ROP protect", PPC::FeatureROPProtect, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "secure-plt", "Enable secure plt mode", PPC::FeatureSecurePlt, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-popcntd", "Has slow popcnt[dw] instructions", PPC::FeatureSlowPOPCNTD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "spe", "Enable SPE instructions", PPC::FeatureSPE, { { { 0x200000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "stfiwx", "Enable the stfiwx instruction", PPC::FeatureSTFIWX, { { { 0x1000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "two-const-nr", "Requires two constant Newton-Raphson computation", PPC::FeatureTwoConstNR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vectors-use-two-units", "Vectors use two units", PPC::FeatureVectorsUseTwoUnits, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vsx", "Enable VSX instructions", PPC::FeatureVSX, { { { 0x200000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
};

#ifdef DBGFIELD
#error "<target>GenSubtargetInfo.inc requires a DBGFIELD macro"
#endif
#if !defined(NDEBUG) || defined(LLVM_ENABLE_DUMP)
#define DBGFIELD(x) x,
#else
#define DBGFIELD(x)
#endif

// Functional units for "PPC440Itineraries"
namespace PPC440ItinerariesFU {
  const InstrStage::FuncUnits P440_DISS1 = 1ULL << 0;
  const InstrStage::FuncUnits P440_DISS2 = 1ULL << 1;
  const InstrStage::FuncUnits P440_FRACC = 1ULL << 2;
  const InstrStage::FuncUnits P440_IRACC = 1ULL << 3;
  const InstrStage::FuncUnits P440_IEXE1 = 1ULL << 4;
  const InstrStage::FuncUnits P440_IEXE2 = 1ULL << 5;
  const InstrStage::FuncUnits P440_IWB = 1ULL << 6;
  const InstrStage::FuncUnits P440_LRACC = 1ULL << 7;
  const InstrStage::FuncUnits P440_JEXE1 = 1ULL << 8;
  const InstrStage::FuncUnits P440_JEXE2 = 1ULL << 9;
  const InstrStage::FuncUnits P440_JWB = 1ULL << 10;
  const InstrStage::FuncUnits P440_AGEN = 1ULL << 11;
  const InstrStage::FuncUnits P440_CRD = 1ULL << 12;
  const InstrStage::FuncUnits P440_LWB = 1ULL << 13;
  const InstrStage::FuncUnits P440_FEXE1 = 1ULL << 14;
  const InstrStage::FuncUnits P440_FEXE2 = 1ULL << 15;
  const InstrStage::FuncUnits P440_FEXE3 = 1ULL << 16;
  const InstrStage::FuncUnits P440_FEXE4 = 1ULL << 17;
  const InstrStage::FuncUnits P440_FEXE5 = 1ULL << 18;
  const InstrStage::FuncUnits P440_FEXE6 = 1ULL << 19;
  const InstrStage::FuncUnits P440_FWB = 1ULL << 20;
  const InstrStage::FuncUnits P440_LWARX_Hold = 1ULL << 21;
} // end namespace PPC440ItinerariesFU

// Pipeline forwarding paths for itineraries "PPC440Itineraries"
namespace PPC440ItinerariesBypass {
  const unsigned NoBypass = 0;
  const unsigned P440_GPR_Bypass = 1 << 0;
  const unsigned P440_FPR_Bypass = 1 << 1;
} // end namespace PPC440ItinerariesBypass

// Functional units for "G3Itineraries"
namespace G3ItinerariesFU {
  const InstrStage::FuncUnits G3_IU1 = 1ULL << 0;
  const InstrStage::FuncUnits G3_IU2 = 1ULL << 1;
  const InstrStage::FuncUnits G3_FPU1 = 1ULL << 2;
  const InstrStage::FuncUnits G3_BPU = 1ULL << 3;
  const InstrStage::FuncUnits G3_SRU = 1ULL << 4;
  const InstrStage::FuncUnits G3_SLU = 1ULL << 5;
} // end namespace G3ItinerariesFU

// Functional units for "G4Itineraries"
namespace G4ItinerariesFU {
  const InstrStage::FuncUnits G4_IU1 = 1ULL << 0;
  const InstrStage::FuncUnits G4_IU2 = 1ULL << 1;
  const InstrStage::FuncUnits G4_SLU = 1ULL << 2;
  const InstrStage::FuncUnits G4_SRU = 1ULL << 3;
  const InstrStage::FuncUnits G4_BPU = 1ULL << 4;
  const InstrStage::FuncUnits G4_FPU1 = 1ULL << 5;
  const InstrStage::FuncUnits G4_VIU1 = 1ULL << 6;
  const InstrStage::FuncUnits G4_VIU2 = 1ULL << 7;
  const InstrStage::FuncUnits G4_VPU = 1ULL << 8;
  const InstrStage::FuncUnits G4_VFPU = 1ULL << 9;
} // end namespace G4ItinerariesFU

// Functional units for "G4PlusItineraries"
namespace G4PlusItinerariesFU {
  const InstrStage::FuncUnits G4P_IU1 = 1ULL << 0;
  const InstrStage::FuncUnits G4P_IU2 = 1ULL << 1;
  const InstrStage::FuncUnits G4P_IU3 = 1ULL << 2;
  const InstrStage::FuncUnits G4P_IU4 = 1ULL << 3;
  const InstrStage::FuncUnits G4P_BPU = 1ULL << 4;
  const InstrStage::FuncUnits G4P_SLU = 1ULL << 5;
  const InstrStage::FuncUnits G4P_FPU1 = 1ULL << 6;
  const InstrStage::FuncUnits G4P_VFPU = 1ULL << 7;
  const InstrStage::FuncUnits G4P_VIU1 = 1ULL << 8;
  const InstrStage::FuncUnits G4P_VIU2 = 1ULL << 9;
  const InstrStage::FuncUnits G4P_VPU = 1ULL << 10;
} // end namespace G4PlusItinerariesFU

// Functional units for "G5Itineraries"
namespace G5ItinerariesFU {
  const InstrStage::FuncUnits G5_IU1 = 1ULL << 0;
  const InstrStage::FuncUnits G5_IU2 = 1ULL << 1;
  const InstrStage::FuncUnits G5_SLU = 1ULL << 2;
  const InstrStage::FuncUnits G5_BPU = 1ULL << 3;
  const InstrStage::FuncUnits G5_FPU1 = 1ULL << 4;
  const InstrStage::FuncUnits G5_FPU2 = 1ULL << 5;
  const InstrStage::FuncUnits G5_VFPU = 1ULL << 6;
  const InstrStage::FuncUnits G5_VIU1 = 1ULL << 7;
  const InstrStage::FuncUnits G5_VIU2 = 1ULL << 8;
  const InstrStage::FuncUnits G5_VPU = 1ULL << 9;
} // end namespace G5ItinerariesFU

// Functional units for "PPCA2Itineraries"
namespace PPCA2ItinerariesFU {
  const InstrStage::FuncUnits A2_XU = 1ULL << 0;
  const InstrStage::FuncUnits A2_FU = 1ULL << 1;
} // end namespace PPCA2ItinerariesFU

// Functional units for "PPCE500Itineraries"
namespace PPCE500ItinerariesFU {
  const InstrStage::FuncUnits E500_DIS0 = 1ULL << 0;
  const InstrStage::FuncUnits E500_DIS1 = 1ULL << 1;
  const InstrStage::FuncUnits E500_SU0 = 1ULL << 2;
  const InstrStage::FuncUnits E500_SU1 = 1ULL << 3;
  const InstrStage::FuncUnits E500_BU = 1ULL << 4;
  const InstrStage::FuncUnits E500_MU = 1ULL << 5;
  const InstrStage::FuncUnits E500_LSU_0 = 1ULL << 6;
} // end namespace PPCE500ItinerariesFU

// Pipeline forwarding paths for itineraries "PPCE500Itineraries"
namespace PPCE500ItinerariesBypass {
  const unsigned NoBypass = 0;
  const unsigned E500_CR_Bypass = 1 << 0;
  const unsigned E500_GPR_Bypass = 1 << 1;
  const unsigned E500_DivBypass = 1 << 2;
} // end namespace PPCE500ItinerariesBypass

// Functional units for "PPCE500mcItineraries"
namespace PPCE500mcItinerariesFU {
  const InstrStage::FuncUnits E500mc_DIS0 = 1ULL << 0;
  const InstrStage::FuncUnits E500mc_DIS1 = 1ULL << 1;
  const InstrStage::FuncUnits E500mc_SFX0 = 1ULL << 2;
  const InstrStage::FuncUnits E500mc_SFX1 = 1ULL << 3;
  const InstrStage::FuncUnits E500mc_BU = 1ULL << 4;
  const InstrStage::FuncUnits E500mc_CFX_DivBypass = 1ULL << 5;
  const InstrStage::FuncUnits E500mc_CFX_0 = 1ULL << 6;
  const InstrStage::FuncUnits E500mc_LSU_0 = 1ULL << 7;
  const InstrStage::FuncUnits E500mc_FPU_0 = 1ULL << 8;
} // end namespace PPCE500mcItinerariesFU

// Pipeline forwarding paths for itineraries "PPCE500mcItineraries"
namespace PPCE500mcItinerariesBypass {
  const unsigned NoBypass = 0;
  const unsigned E500mc_CR_Bypass = 1 << 0;
  const unsigned E500mc_GPR_Bypass = 1 << 1;
  const unsigned E500mc_FPR_Bypass = 1 << 2;
} // end namespace PPCE500mcItinerariesBypass

// Functional units for "PPCE5500Itineraries"
namespace PPCE5500ItinerariesFU {
  const InstrStage::FuncUnits E5500_DIS0 = 1ULL << 0;
  const InstrStage::FuncUnits E5500_DIS1 = 1ULL << 1;
  const InstrStage::FuncUnits E5500_SFX0 = 1ULL << 2;
  const InstrStage::FuncUnits E5500_SFX1 = 1ULL << 3;
  const InstrStage::FuncUnits E5500_BU = 1ULL << 4;
  const InstrStage::FuncUnits E5500_CFX_DivBypass = 1ULL << 5;
  const InstrStage::FuncUnits E5500_CFX_0 = 1ULL << 6;
  const InstrStage::FuncUnits E5500_CFX_1 = 1ULL << 7;
  const InstrStage::FuncUnits E5500_LSU_0 = 1ULL << 8;
  const InstrStage::FuncUnits E5500_FPU_0 = 1ULL << 9;
} // end namespace PPCE5500ItinerariesFU

// Pipeline forwarding paths for itineraries "PPCE5500Itineraries"
namespace PPCE5500ItinerariesBypass {
  const unsigned NoBypass = 0;
  const unsigned E5500_CR_Bypass = 1 << 0;
  const unsigned E5500_GPR_Bypass = 1 << 1;
  const unsigned E5500_FPR_Bypass = 1 << 2;
} // end namespace PPCE5500ItinerariesBypass

// Functional units for "P8Itineraries"
namespace P8ItinerariesFU {
  const InstrStage::FuncUnits P8_DU1 = 1ULL << 0;
  const InstrStage::FuncUnits P8_DU2 = 1ULL << 1;
  const InstrStage::FuncUnits P8_DU3 = 1ULL << 2;
  const InstrStage::FuncUnits P8_DU4 = 1ULL << 3;
  const InstrStage::FuncUnits P8_DU5 = 1ULL << 4;
  const InstrStage::FuncUnits P8_DU6 = 1ULL << 5;
  const InstrStage::FuncUnits P8_DU7 = 1ULL << 6;
  const InstrStage::FuncUnits P8_DU8 = 1ULL << 7;
  const InstrStage::FuncUnits P8_LU1 = 1ULL << 8;
  const InstrStage::FuncUnits P8_LU2 = 1ULL << 9;
  const InstrStage::FuncUnits P8_LSU1 = 1ULL << 10;
  const InstrStage::FuncUnits P8_LSU2 = 1ULL << 11;
  const InstrStage::FuncUnits P8_FXU1 = 1ULL << 12;
  const InstrStage::FuncUnits P8_FXU2 = 1ULL << 13;
  const InstrStage::FuncUnits P8_FPU1 = 1ULL << 14;
  const InstrStage::FuncUnits P8_FPU2 = 1ULL << 15;
  const InstrStage::FuncUnits P8_CRU = 1ULL << 16;
  const InstrStage::FuncUnits P8_BRU = 1ULL << 17;
} // end namespace P8ItinerariesFU

// Functional units for "P7Itineraries"
namespace P7ItinerariesFU {
  const InstrStage::FuncUnits P7_DU1 = 1ULL << 0;
  const InstrStage::FuncUnits P7_DU2 = 1ULL << 1;
  const InstrStage::FuncUnits P7_DU3 = 1ULL << 2;
  const InstrStage::FuncUnits P7_DU4 = 1ULL << 3;
  const InstrStage::FuncUnits P7_DU5 = 1ULL << 4;
  const InstrStage::FuncUnits P7_DU6 = 1ULL << 5;
  const InstrStage::FuncUnits P7_LS1 = 1ULL << 6;
  const InstrStage::FuncUnits P7_LS2 = 1ULL << 7;
  const InstrStage::FuncUnits P7_FX1 = 1ULL << 8;
  const InstrStage::FuncUnits P7_FX2 = 1ULL << 9;
  const InstrStage::FuncUnits P7_VS1 = 1ULL << 10;
  const InstrStage::FuncUnits P7_VS2 = 1ULL << 11;
  const InstrStage::FuncUnits P7_CRU = 1ULL << 12;
  const InstrStage::FuncUnits P7_BRU = 1ULL << 13;
} // end namespace P7ItinerariesFU

extern const llvm::InstrStage PPCStages[] = {
  { 0, 0, 0, llvm::InstrStage::Required }, // No itinerary
  { 1, PPC440ItinerariesFU::P440_DISS1 | PPC440ItinerariesFU::P440_DISS2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_LRACC, -1, (llvm::InstrStage::ReservationKinds)0 },   { 3, PPC440ItinerariesFU::P440_AGEN, 1, (llvm::InstrStage::ReservationKinds)0 },   { 2, PPC440ItinerariesFU::P440_CRD, 1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_LWB, -1, (llvm::InstrStage::ReservationKinds)0 }, // 1-5
  { 1, PPC440ItinerariesFU::P440_DISS1 | PPC440ItinerariesFU::P440_DISS2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_IRACC | PPC440ItinerariesFU::P440_LRACC, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_IEXE1 | PPC440ItinerariesFU::P440_JEXE1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_IEXE2 | PPC440ItinerariesFU::P440_JEXE2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_IWB | PPC440ItinerariesFU::P440_JWB, -1, (llvm::InstrStage::ReservationKinds)0 }, // 6-10
  { 1, PPC440ItinerariesFU::P440_DISS1 | PPC440ItinerariesFU::P440_DISS2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_IRACC, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_IEXE1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_IEXE2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_IWB, -1, (llvm::InstrStage::ReservationKinds)0 }, // 11-15
  { 1, PPC440ItinerariesFU::P440_DISS1 | PPC440ItinerariesFU::P440_DISS2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_LRACC, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_AGEN, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_CRD, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_LWB, -1, (llvm::InstrStage::ReservationKinds)0 }, // 16-20
  { 1, PPC440ItinerariesFU::P440_DISS1 | PPC440ItinerariesFU::P440_DISS2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_LRACC, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_AGEN, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_CRD, -1, (llvm::InstrStage::ReservationKinds)0 },   { 2, PPC440ItinerariesFU::P440_LWB, -1, (llvm::InstrStage::ReservationKinds)0 }, // 21-25
  { 1, PPC440ItinerariesFU::P440_DISS1 | PPC440ItinerariesFU::P440_DISS2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_IRACC, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_IEXE1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_IEXE2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 33, PPC440ItinerariesFU::P440_IWB, -1, (llvm::InstrStage::ReservationKinds)0 }, // 26-30
  { 1, PPC440ItinerariesFU::P440_DISS1 | PPC440ItinerariesFU::P440_DISS2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FRACC, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FEXE1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FEXE2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FEXE3, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FEXE4, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FEXE5, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FEXE6, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FWB, -1, (llvm::InstrStage::ReservationKinds)0 }, // 31-39
  { 1, PPC440ItinerariesFU::P440_DISS1 | PPC440ItinerariesFU::P440_DISS2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FRACC, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FEXE1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FEXE2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FEXE3, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FEXE4, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FEXE5, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FEXE6, -1, (llvm::InstrStage::ReservationKinds)0 },   { 25, PPC440ItinerariesFU::P440_FWB, -1, (llvm::InstrStage::ReservationKinds)0 }, // 40-48
  { 1, PPC440ItinerariesFU::P440_DISS1 | PPC440ItinerariesFU::P440_DISS2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FRACC, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FEXE1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FEXE2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FEXE3, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FEXE4, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FEXE5, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FEXE6, -1, (llvm::InstrStage::ReservationKinds)0 },   { 13, PPC440ItinerariesFU::P440_FWB, -1, (llvm::InstrStage::ReservationKinds)0 }, // 49-57
  { 1, PPC440ItinerariesFU::P440_DISS1 | PPC440ItinerariesFU::P440_DISS2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FRACC, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_LRACC, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_IRACC, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FEXE1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_AGEN, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_JEXE1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_IEXE1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_FEXE2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_CRD, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_JEXE2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_IEXE2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 6, PPC440ItinerariesFU::P440_FEXE3, 0, (llvm::InstrStage::ReservationKinds)0 },   { 6, PPC440ItinerariesFU::P440_LWB, 0, (llvm::InstrStage::ReservationKinds)0 },   { 6, PPC440ItinerariesFU::P440_JWB, 0, (llvm::InstrStage::ReservationKinds)0 },   { 6, PPC440ItinerariesFU::P440_IWB, -1, (llvm::InstrStage::ReservationKinds)0 }, // 58-73
  { 1, PPC440ItinerariesFU::P440_DISS1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_IRACC, 0, (llvm::InstrStage::ReservationKinds)0 },   { 4, PPC440ItinerariesFU::P440_LWARX_Hold, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_LRACC, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_AGEN, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_CRD, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_LWB, -1, (llvm::InstrStage::ReservationKinds)0 }, // 74-80
  { 1, PPC440ItinerariesFU::P440_DISS1 | PPC440ItinerariesFU::P440_DISS2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_IRACC, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_IEXE1, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPC440ItinerariesFU::P440_IEXE2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 3, PPC440ItinerariesFU::P440_IWB, -1, (llvm::InstrStage::ReservationKinds)0 }, // 81-85
  { 3, G3ItinerariesFU::G3_SLU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 86
  { 1, G3ItinerariesFU::G3_IU1 | G3ItinerariesFU::G3_IU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 87
  { 1, G3ItinerariesFU::G3_BPU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 88
  { 1, G3ItinerariesFU::G3_SRU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 89
  { 2, G3ItinerariesFU::G3_SLU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 90
  { 19, G3ItinerariesFU::G3_IU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 91
  { 1, G3ItinerariesFU::G3_FPU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 92
  { 31, G3ItinerariesFU::G3_FPU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 93
  { 17, G3ItinerariesFU::G3_FPU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 94
  { 2, G3ItinerariesFU::G3_FPU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 95
  { 2, G3ItinerariesFU::G3_SRU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 96
  { 34, G3ItinerariesFU::G3_SLU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 97
  { 3, G3ItinerariesFU::G3_SRU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 98
  { 3, G3ItinerariesFU::G3_FPU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 99
  { 5, G3ItinerariesFU::G3_IU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 100
  { 6, G3ItinerariesFU::G3_IU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 101
  { 3, G3ItinerariesFU::G3_IU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 102
  { 8, G3ItinerariesFU::G3_SLU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 103
  { 2, G3ItinerariesFU::G3_IU1 | G3ItinerariesFU::G3_IU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 104
  { 8, G4ItinerariesFU::G4_SLU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 105
  { 1, G4ItinerariesFU::G4_IU1 | G4ItinerariesFU::G4_IU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 106
  { 1, G4ItinerariesFU::G4_BPU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 107
  { 4, G4ItinerariesFU::G4_VFPU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 108
  { 1, G4ItinerariesFU::G4_SRU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 109
  { 2, G4ItinerariesFU::G4_SLU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 110
  { 19, G4ItinerariesFU::G4_IU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 111
  { 1, G4ItinerariesFU::G4_FPU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 112
  { 31, G4ItinerariesFU::G4_FPU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 113
  { 1, G4ItinerariesFU::G4_VIU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 114
  { 3, G4ItinerariesFU::G4_VIU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 115
  { 17, G4ItinerariesFU::G4_FPU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 116
  { 2, G4ItinerariesFU::G4_SRU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 117
  { 3, G4ItinerariesFU::G4_SLU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 118
  { 34, G4ItinerariesFU::G4_SLU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 119
  { 3, G4ItinerariesFU::G4_SRU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 120
  { 3, G4ItinerariesFU::G4_FPU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 121
  { 5, G4ItinerariesFU::G4_IU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 122
  { 6, G4ItinerariesFU::G4_IU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 123
  { 3, G4ItinerariesFU::G4_IU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 124
  { 5, G4ItinerariesFU::G4_SLU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 125
  { 8, G4ItinerariesFU::G4_SRU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 126
  { 2, G4ItinerariesFU::G4_IU1 | G4ItinerariesFU::G4_IU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 127
  { 1, G4ItinerariesFU::G4_VPU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 128
  { 35, G4PlusItinerariesFU::G4P_SLU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 129
  { 1, G4PlusItinerariesFU::G4P_IU1 | G4PlusItinerariesFU::G4P_IU2 | G4PlusItinerariesFU::G4P_IU3 | G4PlusItinerariesFU::G4P_IU4, -1, (llvm::InstrStage::ReservationKinds)0 }, // 130
  { 1, G4PlusItinerariesFU::G4P_BPU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 131
  { 4, G4PlusItinerariesFU::G4P_VFPU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 132
  { 2, G4PlusItinerariesFU::G4P_IU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 133
  { 3, G4PlusItinerariesFU::G4P_SLU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 134
  { 23, G4PlusItinerariesFU::G4P_IU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 135
  { 5, G4PlusItinerariesFU::G4P_FPU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 136
  { 35, G4PlusItinerariesFU::G4P_FPU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 137
  { 1, G4PlusItinerariesFU::G4P_VIU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 138
  { 4, G4PlusItinerariesFU::G4P_VIU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 139
  { 21, G4PlusItinerariesFU::G4P_FPU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 140
  { 3, G4PlusItinerariesFU::G4P_IU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 141
  { 0, G4PlusItinerariesFU::G4P_IU1 | G4PlusItinerariesFU::G4P_IU2 | G4PlusItinerariesFU::G4P_IU3 | G4PlusItinerariesFU::G4P_IU4, -1, (llvm::InstrStage::ReservationKinds)0 }, // 142
  { 4, G4PlusItinerariesFU::G4P_SLU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 143
  { 37, G4PlusItinerariesFU::G4P_SLU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 144
  { 4, G4PlusItinerariesFU::G4P_IU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 145
  { 5, G4PlusItinerariesFU::G4P_IU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 146
  { 2, G4PlusItinerariesFU::G4P_IU1 | G4PlusItinerariesFU::G4P_IU2 | G4PlusItinerariesFU::G4P_IU3 | G4PlusItinerariesFU::G4P_IU4, -1, (llvm::InstrStage::ReservationKinds)0 }, // 147
  { 2, G4PlusItinerariesFU::G4P_VFPU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 148
  { 2, G4PlusItinerariesFU::G4P_VPU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 149
  { 35, G5ItinerariesFU::G5_SLU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 150
  { 2, G5ItinerariesFU::G5_IU1 | G5ItinerariesFU::G5_IU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 151
  { 1, G5ItinerariesFU::G5_BPU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 152
  { 8, G5ItinerariesFU::G5_VFPU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 153
  { 3, G5ItinerariesFU::G5_IU1 | G5ItinerariesFU::G5_IU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 154
  { 4, G5ItinerariesFU::G5_BPU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 155
  { 3, G5ItinerariesFU::G5_SLU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 156
  { 68, G5ItinerariesFU::G5_IU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 157
  { 36, G5ItinerariesFU::G5_IU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 158
  { 6, G5ItinerariesFU::G5_FPU1 | G5ItinerariesFU::G5_FPU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 159
  { 33, G5ItinerariesFU::G5_FPU1 | G5ItinerariesFU::G5_FPU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 160
  { 8, G5ItinerariesFU::G5_FPU1 | G5ItinerariesFU::G5_FPU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 161
  { 2, G5ItinerariesFU::G5_VIU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 162
  { 5, G5ItinerariesFU::G5_VIU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 163
  { 40, G5ItinerariesFU::G5_FPU1 | G5ItinerariesFU::G5_FPU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 164
  { 40, G5ItinerariesFU::G5_SLU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 165
  { 11, G5ItinerariesFU::G5_SLU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 166
  { 5, G5ItinerariesFU::G5_SLU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 167
  { 64, G5ItinerariesFU::G5_SLU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 168
  { 7, G5ItinerariesFU::G5_IU1 | G5ItinerariesFU::G5_IU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 169
  { 2, G5ItinerariesFU::G5_BPU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 170
  { 3, G5ItinerariesFU::G5_BPU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 171
  { 2, G5ItinerariesFU::G5_IU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 172
  { 3, G5ItinerariesFU::G5_IU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 173
  { 6, G5ItinerariesFU::G5_IU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 174
  { 10, G5ItinerariesFU::G5_IU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 175
  { 8, G5ItinerariesFU::G5_IU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 176
  { 5, G5ItinerariesFU::G5_IU1 | G5ItinerariesFU::G5_IU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 177
  { 4, G5ItinerariesFU::G5_IU1 | G5ItinerariesFU::G5_IU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 178
  { 1, G5ItinerariesFU::G5_IU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 179
  { 4, G5ItinerariesFU::G5_SLU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 180
  { 1, G5ItinerariesFU::G5_IU1 | G5ItinerariesFU::G5_IU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 181
  { 2, G5ItinerariesFU::G5_VFPU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 182
  { 3, G5ItinerariesFU::G5_VPU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 183
  { 1, PPCA2ItinerariesFU::A2_XU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 184
  { 1, PPCA2ItinerariesFU::A2_FU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 185
  { 1, PPCE500ItinerariesFU::E500_DIS0 | PPCE500ItinerariesFU::E500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE500ItinerariesFU::E500_LSU_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 186-187
  { 1, PPCE500ItinerariesFU::E500_DIS0 | PPCE500ItinerariesFU::E500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE500ItinerariesFU::E500_SU0 | PPCE500ItinerariesFU::E500_SU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 188-189
  { 1, PPCE500ItinerariesFU::E500_DIS0 | PPCE500ItinerariesFU::E500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE500ItinerariesFU::E500_BU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 190-191
  { 1, PPCE500ItinerariesFU::E500_DIS0 | PPCE500ItinerariesFU::E500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE500ItinerariesFU::E500_MU, 0, (llvm::InstrStage::ReservationKinds)0 },   { 14, PPCE500ItinerariesFU::E500_MU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 192-194
  { 1, PPCE500ItinerariesFU::E500_DIS0 | PPCE500ItinerariesFU::E500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 6, PPCE500ItinerariesFU::E500_MU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 195-196
  { 1, PPCE500ItinerariesFU::E500_DIS0 | PPCE500ItinerariesFU::E500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 32, PPCE500ItinerariesFU::E500_MU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 197-198
  { 1, PPCE500ItinerariesFU::E500_DIS0 | PPCE500ItinerariesFU::E500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 4, PPCE500ItinerariesFU::E500_MU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 199-200
  { 1, PPCE500ItinerariesFU::E500_DIS0 | PPCE500ItinerariesFU::E500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE500ItinerariesFU::E500_SU0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 201-202
  { 1, PPCE500ItinerariesFU::E500_DIS0 | PPCE500ItinerariesFU::E500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 29, PPCE500ItinerariesFU::E500_MU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 203-204
  { 1, PPCE500ItinerariesFU::E500_DIS0 | PPCE500ItinerariesFU::E500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 3, PPCE500ItinerariesFU::E500_LSU_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 205-206
  { 1, PPCE500ItinerariesFU::E500_DIS0 | PPCE500ItinerariesFU::E500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE500ItinerariesFU::E500_SU0 | PPCE500ItinerariesFU::E500_SU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE500ItinerariesFU::E500_LSU_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 207-209
  { 1, PPCE500ItinerariesFU::E500_DIS0 | PPCE500ItinerariesFU::E500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 5, PPCE500ItinerariesFU::E500_SU0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 210-211
  { 1, PPCE500ItinerariesFU::E500_DIS0 | PPCE500ItinerariesFU::E500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 4, PPCE500ItinerariesFU::E500_SU0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 212-213
  { 1, PPCE500ItinerariesFU::E500_DIS0 | PPCE500ItinerariesFU::E500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, PPCE500ItinerariesFU::E500_SU0 | PPCE500ItinerariesFU::E500_SU1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 214-215
  { 1, PPCE500ItinerariesFU::E500_DIS0 | PPCE500ItinerariesFU::E500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE500ItinerariesFU::E500_LSU_0, 0, (llvm::InstrStage::ReservationKinds)0 }, // 216-217
  { 1, PPCE500ItinerariesFU::E500_DIS0 | PPCE500ItinerariesFU::E500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, PPCE500ItinerariesFU::E500_SU0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 218-219
  { 1, PPCE500mcItinerariesFU::E500mc_DIS0 | PPCE500mcItinerariesFU::E500mc_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE500mcItinerariesFU::E500mc_LSU_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 220-221
  { 1, PPCE500mcItinerariesFU::E500mc_DIS0 | PPCE500mcItinerariesFU::E500mc_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE500mcItinerariesFU::E500mc_SFX0 | PPCE500mcItinerariesFU::E500mc_SFX1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 222-223
  { 1, PPCE500mcItinerariesFU::E500mc_DIS0 | PPCE500mcItinerariesFU::E500mc_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE500mcItinerariesFU::E500mc_BU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 224-225
  { 1, PPCE500mcItinerariesFU::E500mc_DIS0 | PPCE500mcItinerariesFU::E500mc_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE500mcItinerariesFU::E500mc_CFX_0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 14, PPCE500mcItinerariesFU::E500mc_CFX_DivBypass, -1, (llvm::InstrStage::ReservationKinds)0 }, // 226-228
  { 1, PPCE500mcItinerariesFU::E500mc_DIS0 | PPCE500mcItinerariesFU::E500mc_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 4, PPCE500mcItinerariesFU::E500mc_FPU_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 229-230
  { 1, PPCE500mcItinerariesFU::E500mc_DIS0 | PPCE500mcItinerariesFU::E500mc_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 68, PPCE500mcItinerariesFU::E500mc_FPU_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 231-232
  { 1, PPCE500mcItinerariesFU::E500mc_DIS0 | PPCE500mcItinerariesFU::E500mc_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, PPCE500mcItinerariesFU::E500mc_FPU_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 233-234
  { 1, PPCE500mcItinerariesFU::E500mc_DIS0 | PPCE500mcItinerariesFU::E500mc_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 38, PPCE500mcItinerariesFU::E500mc_FPU_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 235-236
  { 1, PPCE500mcItinerariesFU::E500mc_DIS0 | PPCE500mcItinerariesFU::E500mc_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 3, PPCE500mcItinerariesFU::E500mc_LSU_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 237-238
  { 1, PPCE500mcItinerariesFU::E500mc_DIS0 | PPCE500mcItinerariesFU::E500mc_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE500mcItinerariesFU::E500mc_SFX0 | PPCE500mcItinerariesFU::E500mc_SFX1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE500mcItinerariesFU::E500mc_LSU_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 239-241
  { 1, PPCE500mcItinerariesFU::E500mc_DIS0 | PPCE500mcItinerariesFU::E500mc_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 5, PPCE500mcItinerariesFU::E500mc_SFX0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 242-243
  { 1, PPCE500mcItinerariesFU::E500mc_DIS0 | PPCE500mcItinerariesFU::E500mc_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 8, PPCE500mcItinerariesFU::E500mc_FPU_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 244-245
  { 1, PPCE500mcItinerariesFU::E500mc_DIS0 | PPCE500mcItinerariesFU::E500mc_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 4, PPCE500mcItinerariesFU::E500mc_SFX0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 246-247
  { 1, PPCE500mcItinerariesFU::E500mc_DIS0 | PPCE500mcItinerariesFU::E500mc_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, PPCE500mcItinerariesFU::E500mc_SFX0 | PPCE500mcItinerariesFU::E500mc_SFX1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 248-249
  { 1, PPCE500mcItinerariesFU::E500mc_DIS0 | PPCE500mcItinerariesFU::E500mc_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE500mcItinerariesFU::E500mc_SFX0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 250-251
  { 1, PPCE500mcItinerariesFU::E500mc_DIS0 | PPCE500mcItinerariesFU::E500mc_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE500mcItinerariesFU::E500mc_CFX_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 252-253
  { 1, PPCE500mcItinerariesFU::E500mc_DIS0 | PPCE500mcItinerariesFU::E500mc_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE500mcItinerariesFU::E500mc_LSU_0, 0, (llvm::InstrStage::ReservationKinds)0 }, // 254-255
  { 1, PPCE500mcItinerariesFU::E500mc_DIS0 | PPCE500mcItinerariesFU::E500mc_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, PPCE500mcItinerariesFU::E500mc_SFX0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 256-257
  { 1, PPCE5500ItinerariesFU::E5500_DIS0 | PPCE5500ItinerariesFU::E5500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE5500ItinerariesFU::E5500_LSU_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 258-259
  { 1, PPCE5500ItinerariesFU::E5500_DIS0 | PPCE5500ItinerariesFU::E5500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE5500ItinerariesFU::E5500_SFX0 | PPCE5500ItinerariesFU::E5500_SFX1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 260-261
  { 1, PPCE5500ItinerariesFU::E5500_DIS0 | PPCE5500ItinerariesFU::E5500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE5500ItinerariesFU::E5500_BU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 262-263
  { 1, PPCE5500ItinerariesFU::E5500_DIS0 | PPCE5500ItinerariesFU::E5500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE5500ItinerariesFU::E5500_CFX_0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 26, PPCE5500ItinerariesFU::E5500_CFX_DivBypass, -1, (llvm::InstrStage::ReservationKinds)0 }, // 264-266
  { 1, PPCE5500ItinerariesFU::E5500_DIS0 | PPCE5500ItinerariesFU::E5500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE5500ItinerariesFU::E5500_CFX_0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 16, PPCE5500ItinerariesFU::E5500_CFX_DivBypass, -1, (llvm::InstrStage::ReservationKinds)0 }, // 267-269
  { 1, PPCE5500ItinerariesFU::E5500_DIS0 | PPCE5500ItinerariesFU::E5500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE5500ItinerariesFU::E5500_FPU_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 270-271
  { 1, PPCE5500ItinerariesFU::E5500_DIS0 | PPCE5500ItinerariesFU::E5500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 31, PPCE5500ItinerariesFU::E5500_FPU_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 272-273
  { 1, PPCE5500ItinerariesFU::E5500_DIS0 | PPCE5500ItinerariesFU::E5500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 16, PPCE5500ItinerariesFU::E5500_FPU_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 274-275
  { 1, PPCE5500ItinerariesFU::E5500_DIS0 | PPCE5500ItinerariesFU::E5500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 3, PPCE5500ItinerariesFU::E5500_LSU_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 276-277
  { 1, PPCE5500ItinerariesFU::E5500_DIS0 | PPCE5500ItinerariesFU::E5500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE5500ItinerariesFU::E5500_SFX0 | PPCE5500ItinerariesFU::E5500_SFX1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE5500ItinerariesFU::E5500_LSU_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 278-280
  { 1, PPCE5500ItinerariesFU::E5500_DIS0 | PPCE5500ItinerariesFU::E5500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 4, PPCE5500ItinerariesFU::E5500_LSU_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 281-282
  { 1, PPCE5500ItinerariesFU::E5500_DIS0 | PPCE5500ItinerariesFU::E5500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE5500ItinerariesFU::E5500_CFX_0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, PPCE5500ItinerariesFU::E5500_CFX_1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 283-285
  { 1, PPCE5500ItinerariesFU::E5500_DIS0 | PPCE5500ItinerariesFU::E5500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE5500ItinerariesFU::E5500_CFX_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 286-287
  { 1, PPCE5500ItinerariesFU::E5500_DIS0 | PPCE5500ItinerariesFU::E5500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 5, PPCE5500ItinerariesFU::E5500_CFX_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 288-289
  { 1, PPCE5500ItinerariesFU::E5500_DIS0 | PPCE5500ItinerariesFU::E5500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 4, PPCE5500ItinerariesFU::E5500_CFX_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 290-291
  { 1, PPCE5500ItinerariesFU::E5500_DIS0 | PPCE5500ItinerariesFU::E5500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 7, PPCE5500ItinerariesFU::E5500_FPU_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 292-293
  { 1, PPCE5500ItinerariesFU::E5500_DIS0 | PPCE5500ItinerariesFU::E5500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, PPCE5500ItinerariesFU::E5500_CFX_0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 294-295
  { 1, PPCE5500ItinerariesFU::E5500_DIS0 | PPCE5500ItinerariesFU::E5500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE5500ItinerariesFU::E5500_CFX_0, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE5500ItinerariesFU::E5500_CFX_1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 296-298
  { 1, PPCE5500ItinerariesFU::E5500_DIS0 | PPCE5500ItinerariesFU::E5500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, PPCE5500ItinerariesFU::E5500_SFX0 | PPCE5500ItinerariesFU::E5500_SFX1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 299-300
  { 1, PPCE5500ItinerariesFU::E5500_DIS0 | PPCE5500ItinerariesFU::E5500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, PPCE5500ItinerariesFU::E5500_LSU_0, 0, (llvm::InstrStage::ReservationKinds)0 }, // 301-302
  { 1, PPCE5500ItinerariesFU::E5500_DIS0 | PPCE5500ItinerariesFU::E5500_DIS1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 2, PPCE5500ItinerariesFU::E5500_SFX0, -1, (llvm::InstrStage::ReservationKinds)0 }, // 303-304
  { 1, P8ItinerariesFU::P8_DU1 | P8ItinerariesFU::P8_DU2 | P8ItinerariesFU::P8_DU3 | P8ItinerariesFU::P8_DU4 | P8ItinerariesFU::P8_DU5 | P8ItinerariesFU::P8_DU6, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_FXU1 | P8ItinerariesFU::P8_FXU2 | P8ItinerariesFU::P8_LU1 | P8ItinerariesFU::P8_LU2 | P8ItinerariesFU::P8_LSU1 | P8ItinerariesFU::P8_LSU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 305-306
  { 1, P8ItinerariesFU::P8_DU7 | P8ItinerariesFU::P8_DU8, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_BRU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 307-308
  { 1, P8ItinerariesFU::P8_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_FPU1 | P8ItinerariesFU::P8_FPU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 309-310
  { 1, P8ItinerariesFU::P8_DU1 | P8ItinerariesFU::P8_DU2 | P8ItinerariesFU::P8_DU3 | P8ItinerariesFU::P8_DU4 | P8ItinerariesFU::P8_DU5 | P8ItinerariesFU::P8_DU6, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_FXU1 | P8ItinerariesFU::P8_FXU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 311-312
  { 1, P8ItinerariesFU::P8_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_CRU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 313-314
  { 1, P8ItinerariesFU::P8_DU1 | P8ItinerariesFU::P8_DU2 | P8ItinerariesFU::P8_DU3 | P8ItinerariesFU::P8_DU4 | P8ItinerariesFU::P8_DU5 | P8ItinerariesFU::P8_DU6, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_LSU1 | P8ItinerariesFU::P8_LSU2 | P8ItinerariesFU::P8_LU1 | P8ItinerariesFU::P8_LU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 315-316
  { 1, P8ItinerariesFU::P8_DU1 | P8ItinerariesFU::P8_DU2 | P8ItinerariesFU::P8_DU3 | P8ItinerariesFU::P8_DU4 | P8ItinerariesFU::P8_DU5 | P8ItinerariesFU::P8_DU6, 0, (llvm::InstrStage::ReservationKinds)0 },   { 23, P8ItinerariesFU::P8_FXU1 | P8ItinerariesFU::P8_FXU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 317-318
  { 1, P8ItinerariesFU::P8_DU1 | P8ItinerariesFU::P8_DU2 | P8ItinerariesFU::P8_DU3 | P8ItinerariesFU::P8_DU4 | P8ItinerariesFU::P8_DU5 | P8ItinerariesFU::P8_DU6, 0, (llvm::InstrStage::ReservationKinds)0 },   { 15, P8ItinerariesFU::P8_FXU1 | P8ItinerariesFU::P8_FXU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 319-320
  { 1, P8ItinerariesFU::P8_DU1 | P8ItinerariesFU::P8_DU2 | P8ItinerariesFU::P8_DU3 | P8ItinerariesFU::P8_DU4 | P8ItinerariesFU::P8_DU5 | P8ItinerariesFU::P8_DU6, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_FPU1 | P8ItinerariesFU::P8_FPU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 321-322
  { 1, P8ItinerariesFU::P8_DU1 | P8ItinerariesFU::P8_DU2 | P8ItinerariesFU::P8_DU3 | P8ItinerariesFU::P8_DU4 | P8ItinerariesFU::P8_DU5 | P8ItinerariesFU::P8_DU6, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_LSU1 | P8ItinerariesFU::P8_LSU2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_LU1 | P8ItinerariesFU::P8_LU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 323-325
  { 1, P8ItinerariesFU::P8_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_FXU1 | P8ItinerariesFU::P8_FXU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_BRU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 326-328
  { 1, P8ItinerariesFU::P8_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU3, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU4, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_LSU1 | P8ItinerariesFU::P8_LSU2 | P8ItinerariesFU::P8_LU1 | P8ItinerariesFU::P8_LU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 329-333
  { 1, P8ItinerariesFU::P8_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_LSU1 | P8ItinerariesFU::P8_LSU2 | P8ItinerariesFU::P8_LU1 | P8ItinerariesFU::P8_LU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_FXU1 | P8ItinerariesFU::P8_FXU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 334-337
  { 1, P8ItinerariesFU::P8_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU3, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU4, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU5, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU6, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_LSU1 | P8ItinerariesFU::P8_LSU2 | P8ItinerariesFU::P8_LU1 | P8ItinerariesFU::P8_LU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 338-344
  { 1, P8ItinerariesFU::P8_DU1 | P8ItinerariesFU::P8_DU2 | P8ItinerariesFU::P8_DU3 | P8ItinerariesFU::P8_DU4 | P8ItinerariesFU::P8_DU5 | P8ItinerariesFU::P8_DU6, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_LU1 | P8ItinerariesFU::P8_LU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 345-346
  { 1, P8ItinerariesFU::P8_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_LU1 | P8ItinerariesFU::P8_LU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_FXU1 | P8ItinerariesFU::P8_FXU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 347-350
  { 1, P8ItinerariesFU::P8_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_LSU1 | P8ItinerariesFU::P8_LSU2 | P8ItinerariesFU::P8_LU1 | P8ItinerariesFU::P8_LU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_FXU1 | P8ItinerariesFU::P8_FXU2 | P8ItinerariesFU::P8_LU1 | P8ItinerariesFU::P8_LU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 351-354
  { 1, P8ItinerariesFU::P8_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_LSU1 | P8ItinerariesFU::P8_LSU2 | P8ItinerariesFU::P8_LU1 | P8ItinerariesFU::P8_LU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_FXU1 | P8ItinerariesFU::P8_FXU2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_FXU1 | P8ItinerariesFU::P8_FXU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 355-359
  { 1, P8ItinerariesFU::P8_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU3, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU4, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU5, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU6, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_LSU1 | P8ItinerariesFU::P8_LSU2 | P8ItinerariesFU::P8_LU1 | P8ItinerariesFU::P8_LU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_FXU1 | P8ItinerariesFU::P8_FXU2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_FXU1 | P8ItinerariesFU::P8_FXU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 360-368
  { 1, P8ItinerariesFU::P8_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_LSU1 | P8ItinerariesFU::P8_LSU2 | P8ItinerariesFU::P8_LU1 | P8ItinerariesFU::P8_LU2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_FXU1 | P8ItinerariesFU::P8_FXU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 369-372
  { 1, P8ItinerariesFU::P8_DU1 | P8ItinerariesFU::P8_DU2 | P8ItinerariesFU::P8_DU3 | P8ItinerariesFU::P8_DU4 | P8ItinerariesFU::P8_DU5 | P8ItinerariesFU::P8_DU6, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_CRU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 373-374
  { 1, P8ItinerariesFU::P8_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_FXU1 | P8ItinerariesFU::P8_FXU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 375-376
  { 1, P8ItinerariesFU::P8_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU3, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU4, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU5, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU6, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_LSU1 | P8ItinerariesFU::P8_LSU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_LU1 | P8ItinerariesFU::P8_LU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 377-384
  { 1, P8ItinerariesFU::P8_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_LU1 | P8ItinerariesFU::P8_LU2 | P8ItinerariesFU::P8_LSU1 | P8ItinerariesFU::P8_LSU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_FXU1 | P8ItinerariesFU::P8_FXU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 385-388
  { 1, P8ItinerariesFU::P8_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU3, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU4, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU5, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU6, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_LSU1 | P8ItinerariesFU::P8_LSU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_FXU1 | P8ItinerariesFU::P8_FXU2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_FXU1 | P8ItinerariesFU::P8_FXU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 389-397
  { 1, P8ItinerariesFU::P8_LU1 | P8ItinerariesFU::P8_LU2 | P8ItinerariesFU::P8_LSU1 | P8ItinerariesFU::P8_LSU2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_LU1 | P8ItinerariesFU::P8_LU2 | P8ItinerariesFU::P8_LSU1 | P8ItinerariesFU::P8_LSU2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_LU1 | P8ItinerariesFU::P8_LU2 | P8ItinerariesFU::P8_LSU1 | P8ItinerariesFU::P8_LSU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 398-400
  { 1, P8ItinerariesFU::P8_DU1 | P8ItinerariesFU::P8_DU2 | P8ItinerariesFU::P8_DU3 | P8ItinerariesFU::P8_DU4 | P8ItinerariesFU::P8_DU5 | P8ItinerariesFU::P8_DU6, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_LSU1 | P8ItinerariesFU::P8_LSU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_FPU1 | P8ItinerariesFU::P8_FPU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 401-403
  { 1, P8ItinerariesFU::P8_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_LSU1 | P8ItinerariesFU::P8_LSU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_FXU1 | P8ItinerariesFU::P8_FXU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_FPU1 | P8ItinerariesFU::P8_FPU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 404-408
  { 1, P8ItinerariesFU::P8_DU1 | P8ItinerariesFU::P8_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P8ItinerariesFU::P8_FPU1 | P8ItinerariesFU::P8_FPU2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 409-410
  { 1, P7ItinerariesFU::P7_DU1 | P7ItinerariesFU::P7_DU2 | P7ItinerariesFU::P7_DU3 | P7ItinerariesFU::P7_DU4, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_FX1 | P7ItinerariesFU::P7_FX2 | P7ItinerariesFU::P7_LS1 | P7ItinerariesFU::P7_LS2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 411-412
  { 1, P7ItinerariesFU::P7_DU1 | P7ItinerariesFU::P7_DU2 | P7ItinerariesFU::P7_DU3 | P7ItinerariesFU::P7_DU4, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_FX1 | P7ItinerariesFU::P7_FX2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 413-414
  { 1, P7ItinerariesFU::P7_DU5 | P7ItinerariesFU::P7_DU6, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_BRU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 415-416
  { 1, P7ItinerariesFU::P7_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_VS1 | P7ItinerariesFU::P7_VS2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 417-418
  { 1, P7ItinerariesFU::P7_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_CRU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 419-420
  { 1, P7ItinerariesFU::P7_DU1 | P7ItinerariesFU::P7_DU2 | P7ItinerariesFU::P7_DU3 | P7ItinerariesFU::P7_DU4, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_LS1 | P7ItinerariesFU::P7_LS2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 421-422
  { 1, P7ItinerariesFU::P7_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 68, P7ItinerariesFU::P7_FX1 | P7ItinerariesFU::P7_FX2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 423-425
  { 1, P7ItinerariesFU::P7_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 36, P7ItinerariesFU::P7_FX1 | P7ItinerariesFU::P7_FX2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 426-428
  { 1, P7ItinerariesFU::P7_DU1 | P7ItinerariesFU::P7_DU2 | P7ItinerariesFU::P7_DU3 | P7ItinerariesFU::P7_DU4, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_VS1 | P7ItinerariesFU::P7_VS2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 429-430
  { 1, P7ItinerariesFU::P7_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_VS1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 431-432
  { 1, P7ItinerariesFU::P7_DU1 | P7ItinerariesFU::P7_DU2 | P7ItinerariesFU::P7_DU3 | P7ItinerariesFU::P7_DU4, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_LS1 | P7ItinerariesFU::P7_LS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_FX1 | P7ItinerariesFU::P7_FX2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 433-435
  { 1, P7ItinerariesFU::P7_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_FX1 | P7ItinerariesFU::P7_FX2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_BRU, -1, (llvm::InstrStage::ReservationKinds)0 }, // 436-438
  { 1, P7ItinerariesFU::P7_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_DU3, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_DU4, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_LS1 | P7ItinerariesFU::P7_LS2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 439-443
  { 1, P7ItinerariesFU::P7_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_LS1 | P7ItinerariesFU::P7_LS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_FX1 | P7ItinerariesFU::P7_FX2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 444-447
  { 1, P7ItinerariesFU::P7_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_DU3, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_DU4, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_FX1 | P7ItinerariesFU::P7_FX2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_LS1 | P7ItinerariesFU::P7_LS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_FX1 | P7ItinerariesFU::P7_FX2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 448-454
  { 1, P7ItinerariesFU::P7_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_LS1 | P7ItinerariesFU::P7_LS2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_FX1 | P7ItinerariesFU::P7_FX2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 455-458
  { 1, P7ItinerariesFU::P7_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_LS1 | P7ItinerariesFU::P7_LS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_FX1 | P7ItinerariesFU::P7_FX2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_FX1 | P7ItinerariesFU::P7_FX2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 459-463
  { 1, P7ItinerariesFU::P7_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_DU3, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_DU4, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_FX1 | P7ItinerariesFU::P7_FX2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_LS1 | P7ItinerariesFU::P7_LS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_FX1 | P7ItinerariesFU::P7_FX2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_FX1 | P7ItinerariesFU::P7_FX2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 464-471
  { 1, P7ItinerariesFU::P7_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_DU3, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_DU4, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_CRU, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_FX1 | P7ItinerariesFU::P7_FX2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 472-477
  { 1, P7ItinerariesFU::P7_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_FX1, -1, (llvm::InstrStage::ReservationKinds)0 }, // 478-479
  { 1, P7ItinerariesFU::P7_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_DU3, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_DU4, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_LS1 | P7ItinerariesFU::P7_LS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_FX1 | P7ItinerariesFU::P7_FX2, -1, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_FX1 | P7ItinerariesFU::P7_FX2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 480-486
  { 1, P7ItinerariesFU::P7_DU1 | P7ItinerariesFU::P7_DU2 | P7ItinerariesFU::P7_DU3 | P7ItinerariesFU::P7_DU4, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_LS1 | P7ItinerariesFU::P7_LS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_VS1 | P7ItinerariesFU::P7_VS2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 487-489
  { 1, P7ItinerariesFU::P7_DU1, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_LS1 | P7ItinerariesFU::P7_LS2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_FX1 | P7ItinerariesFU::P7_FX2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_VS1 | P7ItinerariesFU::P7_VS2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 490-494
  { 1, P7ItinerariesFU::P7_DU1 | P7ItinerariesFU::P7_DU2, 0, (llvm::InstrStage::ReservationKinds)0 },   { 1, P7ItinerariesFU::P7_VS2, -1, (llvm::InstrStage::ReservationKinds)0 }, // 495-496
  { 0, 0, 0, llvm::InstrStage::Required } // End stages
};
extern const unsigned PPCOperandCycles[] = {
  0, // No itinerary
  2,   0,   0, // 1-3
  2,   0,   0, // 4-6
  4,   0, // 7-8
  2,   0,   0, // 9-11
  4,   0,   0, // 12-14
  1,   1, // 15-16
  5,   1,   1, // 17-19
  36,   0,   0, // 20-22
  6,   0,   0, // 23-25
  31,   0,   0, // 26-28
  6,   0,   0, // 29-31
  6,   0,   0, // 32-34
  1,   1,   1, // 35-37
  19,   0,   0, // 38-40
  6,   0,   0,   0, // 41-44
  4,   1,   1, // 45-47
  2,   0,   0,   0, // 48-51
  4,   1,   1, // 52-54
  5,   2,   1,   1, // 55-58
  5,   2,   1,   1, // 59-62
  5,   1,   1, // 63-65
  5,   2,   1,   1, // 66-69
  5,   2,   1,   1, // 70-73
  4,   1,   1, // 74-76
  4,   1,   1, // 77-79
  4,   1,   1, // 80-82
  4,   1,   1, // 83-85
  4,   0,   0, // 86-88
  4,   0,   0, // 89-91
  4,   0, // 92-93
  6,   0, // 94-95
  3,   0,   0, // 96-98
  3,   0, // 99-100
  2,   0, // 101-102
  6,   0, // 103-104
  6,   0, // 105-106
  3,   0,   0, // 107-109
  2,   0, // 110-111
  5,   0, // 112-113
  4,   0,   0, // 114-116
  4,   0,   0, // 117-119
  4,   0,   0, // 120-122
  4,   0, // 123-124
  2,   0,   0, // 125-127
  2,   0,   0, // 128-130
  4,   1,   1, // 131-133
  2,   1,   1,   1, // 134-137
  2,   1,   1,   1, // 138-141
  4,   1,   1, // 142-144
  4,   1,   1, // 145-147
  1,   1,   1, // 148-150
  2,   1,   1,   1, // 151-154
  2,   0, // 155-156
  6,   0, // 157-158
  3,   0,   0, // 159-161
  3,   0,   0, // 162-164
  2,   0,   0, // 165-167
  2,   0, // 168-169
  6,   0,   0, // 170-172
  6,   0,   0, // 173-175
  2,   0,   0, // 176-178
  2,   0,   0, // 179-181
  2,   0,   0, // 182-184
  2,   0,   0, // 185-187
  4,   0,   0, // 188-190
  4,   0,   0, // 191-193
  4,   0, // 194-195
  6,   0, // 196-197
  5,   1,   1, // 198-200
  2,   0,   0, // 201-203
  4,   0,   0, // 204-206
  4,   0,   0, // 207-209
  2,   0,   0, // 210-212
  6,   0,   0, // 213-215
  2,   0,   0, // 216-218
  2,   0,   0,   0, // 219-222
  6,   0, // 223-224
  1,   1,   1, // 225-227
  5,   1,   1, // 228-230
  6,   0,   0, // 231-233
  4,   0,   0, // 234-236
  4,   0,   0, // 237-239
  4,   0,   0, // 240-242
  6,   0,   0, // 243-245
  6,   0,   0, // 246-248
  6,   0,   0,   0, // 249-252
  6,   0,   0, // 253-255
  4,   0,   0, // 256-258
  4,   0,   0, // 259-261
  6,   0,   0, // 262-264
  6,   0,   0, // 265-267
  6,   0,   0,   0, // 268-271
  5,   1,   1, // 272-274
  6,   0,   0, // 275-277
  5,   1,   1, // 278-280
  5,   1,   1, // 281-283
  5,   1,   1, // 284-286
  1,   1, // 287-288
  4,   1,   1, // 289-291
  5,   1,   1, // 292-294
  4,   1,   1, // 295-297
  4,   1,   1, // 298-300
  5,   1,   1, // 301-303
  5,   2,   1,   1, // 304-307
  5,   2,   1,   1, // 308-311
  6,   0, // 312-313
  4,   1,   1, // 314-316
  4,   1,   1, // 317-319
  4,   1,   1, // 320-322
  6,   0, // 323-324
  5,   1,   1, // 325-327
  5,   1,   1, // 328-330
  5,   1,   1, // 331-333
  5,   1,   1, // 334-336
  4,   1,   1, // 337-339
  4,   1,   1, // 340-342
  5,   1,   1, // 343-345
  1,   1,   1, // 346-348
  1,   1,   1, // 349-351
  4,   1,   1, // 352-354
  5,   1,   1, // 355-357
  4,   1,   1, // 358-360
  1,   1,   1, // 361-363
  1,   1,   1, // 364-366
  5,   1,   1, // 367-369
  6,   0, // 370-371
  2,   0,   0, // 372-374
  6,   0, // 375-376
  6,   0, // 377-378
  3,   0, // 379-380
  2,   0, // 381-382
  6,   0, // 383-384
  36,   0,   0, // 385-387
  36,   0,   0, // 388-390
  36,   0,   0, // 391-393
  36,   0,   0, // 394-396
  4,   0,   0, // 397-399
  2,   0,   0, // 400-402
  6,   0,   0, // 403-405
  4,   0,   0, // 406-408
  3,   0,   0, // 409-411
  3,   0,   0, // 412-414
  2,   0,   0, // 415-417
  2,   0,   0, // 418-420
  2,   0,   0, // 421-423
  3,   0,   0, // 424-426
  4,   0, // 427-428
  31,   0,   0, // 429-431
  31,   0,   0, // 432-434
  31,   0,   0, // 435-437
  19,   0,   0, // 438-440
  19,   0,   0, // 441-443
  19,   0,   0, // 444-446
  19,   0,   0, // 447-449
  31,   0,   0, // 450-452
  5,   2,   1,   1, // 453-456
  5,   2,   1,   1, // 457-460
  2,   1,   1,   1, // 461-464
  2,   1,   1,   1, // 465-468
  2,   1,   1,   1, // 469-472
  5,   2,   1,   1, // 473-476
  5,   2,   1,   1, // 477-480
  5,   2,   1,   1, // 481-484
  5,   2,   1,   1, // 485-488
  4,   0, // 489-490
  4,   0, // 491-492
  5,   1,   1, // 493-495
  1,   1,   1, // 496-498
  2,   0,   0, // 499-501
  5,   1,   1, // 502-504
  1,   1,   1, // 505-507
  4,   0, // 508-509
  4,   0, // 510-511
  5,   1,   1, // 512-514
  1,   1,   1, // 515-517
  5,   1,   1, // 518-520
  1,   1,   1, // 521-523
  2,   0, // 524-525
  5,   0, // 526-527
  6,   0, // 528-529
  6,   0, // 530-531
  2,   0,   0, // 532-534
  2,   0, // 535-536
  2,   0,   0, // 537-539
  1,   1, // 540-541
  6,   0,   0, // 542-544
  6,   0,   0, // 545-547
  6,   0,   0,   0, // 548-551
  6,   0,   0, // 552-554
  6,   0,   0,   0, // 555-558
  6,   0,   0, // 559-561
  4,   0, // 562-563
  4,   0, // 564-565
  4,   0, // 566-567
  4,   0, // 568-569
  2,   0,   0, // 570-572
  2,   0,   0, // 573-575
  36,   0,   0, // 576-578
  5,   1,   1, // 579-581
  2,   0, // 582-583
  2,   0,   0, // 584-586
  6,   0,   0, // 587-589
  2,   0,   0, // 590-592
  6,   0,   0, // 593-595
  6,   0,   0, // 596-598
  2,   0,   0, // 599-601
  2,   0,   0, // 602-604
  4,   0,   0, // 605-607
  5,   1,   1, // 608-610
  6,   0, // 611-612
  2,   0,   0, // 613-615
  2,   0,   0, // 616-618
  2,   0,   0, // 619-621
  6,   0,   0, // 622-624
  2,   0,   0, // 625-627
  2,   0,   0, // 628-630
  2,   0,   0, // 631-633
  2,   0,   0, // 634-636
  2,   0,   0, // 637-639
  2,   0,   0, // 640-642
  2,   0,   0, // 643-645
  5,   1,   1, // 646-648
  3,   0,   0, // 649-651
  6,   0, // 652-653
  2,   0,   0, // 654-656
  3,   0,   0, // 657-659
  2,   0,   0, // 660-662
  2,   0,   0, // 663-665
  4,   0, // 666-667
  6,   0,   0, // 668-670
  4,   0, // 671-672
  2,   0,   0, // 673-675
  2,   0,   0, // 676-678
  3,   0,   0, // 679-681
  3,   0,   0, // 682-684
  5,   1,   1, // 685-687
  5,   1,   1, // 688-690
  1,   1, // 691-692
  5,   1,   1, // 693-695
  5,   1,   1, // 696-698
  5,   0, // 699-700
  2,   0,   0, // 701-703
  5,   1,   1, // 704-706
  5,   1,   1, // 707-709
  5,   1,   1, // 710-712
  2,   0, // 713-714
  6,   0, // 715-716
  1,   1, // 717-718
  4,   1,   1, // 719-721
  1,   1, // 722-723
  5,   1,   1, // 724-726
  1,   1,   1, // 727-729
  4,   1,   1, // 730-732
  1,   1,   1, // 733-735
  5,   1,   1, // 736-738
  5,   1,   1, // 739-741
  5,   1,   1, // 742-744
  5,   1,   1, // 745-747
  4,   0, // 748-749
  1,   1, // 750-751
  5,   1,   1, // 752-754
  1,   1,   1, // 755-757
  4,   0, // 758-759
  4,   0, // 760-761
  5,   1,   1, // 762-764
  2,   0,   0, // 765-767
  6, // 768
  1,   0,   0, // 769-771
  2,   0,   0, // 772-774
  6,   0,   0, // 775-777
  2,   0,   0, // 778-780
  1,   0,   0, // 781-783
  1,   0,   0, // 784-786
  6,   0,   0, // 787-789
  71,   0,   0, // 790-792
  39,   0,   0, // 793-795
  6,   0,   0, // 796-798
  72,   0,   0, // 799-801
  5,   0,   0, // 802-804
  6,   0,   0, // 805-807
  0,   0,   0, // 808-810
  2,   0,   0, // 811-813
  59,   0,   0, // 814-816
  6,   0,   0,   0, // 817-820
  69,   0,   0, // 821-823
  65,   0,   0, // 824-826
  16,   0,   0, // 827-829
  2,   0,   0,   0, // 830-833
  16, // 834
  82,   0,   0, // 835-837
  6,   8,   0,   0, // 838-841
  6,   8,   0,   0, // 842-845
  6,   0,   0, // 846-848
  6,   0,   0, // 849-851
  7,   0,   0, // 852-854
  7,   9,   0,   0, // 855-858
  7,   9,   0,   0, // 859-862
  6,   0,   0, // 863-865
  6,   8,   0,   0, // 866-869
  6,   8,   0,   0, // 870-873
  5,   0,   0, // 874-876
  1,   0,   0, // 877-879
  6,   0, // 880-881
  6,   0, // 882-883
  4,   0, // 884-885
  1,   0, // 886-887
  4,   0, // 888-889
  6,   0, // 890-891
  16,   0, // 892-893
  5,   0,   0, // 894-896
  5,   0,   0, // 897-899
  6,   0,   0, // 900-902
  16, // 903
  2,   0,   0, // 904-906
  2,   0,   0, // 907-909
  2,   0,   0, // 910-912
  82,   0,   0, // 913-915
  2,   0,   0,   0, // 916-919
  2,   0,   0,   0, // 920-923
  0,   0,   0, // 924-926
  82,   0,   0, // 927-929
  0,   0,   0, // 930-932
  2,   0,   0,   0, // 933-936
  2,   0, // 937-938
  2,   0, // 939-940
  6,   0, // 941-942
  2,   0,   0, // 943-945
  2,   0, // 946-947
  2,   0, // 948-949
  5,   0,   0, // 950-952
  5,   0,   0, // 953-955
  2,   0,   0, // 956-958
  2,   0,   0, // 959-961
  2,   0,   0, // 962-964
  2,   0,   0, // 965-967
  2,   0,   0, // 968-970
  1,   0,   0, // 971-973
  5,   0,   0, // 974-976
  1,   0,   0, // 977-979
  6,   0,   0, // 980-982
  6,   0, // 983-984
  6,   0,   0, // 985-987
  2,   0,   0, // 988-990
  2,   0,   0, // 991-993
  2,   0,   0, // 994-996
  1,   0, // 997-998
  1,   0,   0, // 999-1001
  1,   0,   0, // 1002-1004
  2,   0,   0, // 1005-1007
  6,   0,   0, // 1008-1010
  2,   0,   0, // 1011-1013
  2,   0,   0,   0, // 1014-1017
  6,   0, // 1018-1019
  0,   0,   0, // 1020-1022
  6,   0,   0, // 1023-1025
  5,   0,   0, // 1026-1028
  5,   0,   0, // 1029-1031
  5,   0,   0, // 1032-1034
  6,   0,   0, // 1035-1037
  6,   0,   0, // 1038-1040
  6,   0,   0, // 1041-1043
  6,   0,   0,   0, // 1044-1047
  6,   0,   0, // 1048-1050
  5,   0,   0, // 1051-1053
  5,   0,   0, // 1054-1056
  6,   0,   0, // 1057-1059
  6,   0,   0, // 1060-1062
  6,   0,   0,   0, // 1063-1066
  6,   0,   0, // 1067-1069
  5,   0,   0, // 1070-1072
  6,   0,   0, // 1073-1075
  6,   0,   0, // 1076-1078
  7,   0,   0, // 1079-1081
  1,   0,   0, // 1082-1084
  16,   0,   0, // 1085-1087
  6,   0,   0, // 1088-1090
  82,   0,   0, // 1091-1093
  16, // 1094
  6, // 1095
  7,   0,   0, // 1096-1098
  6,   8,   0,   0, // 1099-1102
  6,   8,   0,   0, // 1103-1106
  6,   0, // 1107-1108
  82,   0,   0, // 1109-1111
  82,   0,   0, // 1112-1114
  6,   0,   0, // 1115-1117
  6,   0, // 1118-1119
  7,   0,   0, // 1120-1122
  7,   0,   0, // 1123-1125
  7,   0,   0, // 1126-1128
  7,   0,   0, // 1129-1131
  6,   8,   0,   0, // 1132-1135
  6,   8,   0,   0, // 1136-1139
  7,   0,   0, // 1140-1142
  0,   0,   0, // 1143-1145
  0,   0,   0, // 1146-1148
  0,   0,   0, // 1149-1151
  6,   0,   0, // 1152-1154
  0,   0,   0, // 1155-1157
  0,   0,   0, // 1158-1160
  6,   0,   0, // 1161-1163
  6,   0, // 1164-1165
  2,   0,   0, // 1166-1168
  4,   0, // 1169-1170
  6,   0, // 1171-1172
  4,   0, // 1173-1174
  16,   0, // 1175-1176
  6,   0, // 1177-1178
  39,   0,   0, // 1179-1181
  39,   0,   0, // 1182-1184
  71,   0,   0, // 1185-1187
  71,   0,   0, // 1188-1190
  39,   0,   0, // 1191-1193
  71,   0,   0, // 1194-1196
  39,   0,   0, // 1197-1199
  71,   0,   0, // 1200-1202
  1,   0,   0, // 1203-1205
  2,   0,   0, // 1206-1208
  6,   0,   0, // 1209-1211
  5,   0,   0, // 1212-1214
  2,   0,   0, // 1215-1217
  2,   0,   0, // 1218-1220
  2,   0,   0, // 1221-1223
  2,   0,   0, // 1224-1226
  2,   0,   0, // 1227-1229
  6,   0, // 1230-1231
  2,   0,   0, // 1232-1234
  2,   0,   0, // 1235-1237
  72,   0,   0, // 1238-1240
  72,   0,   0, // 1241-1243
  69,   0,   0, // 1244-1246
  69,   0,   0, // 1247-1249
  69,   0,   0, // 1250-1252
  65,   0,   0, // 1253-1255
  69,   0,   0, // 1256-1258
  65,   0,   0, // 1259-1261
  65,   0,   0, // 1262-1264
  65,   0,   0, // 1265-1267
  72,   0,   0, // 1268-1270
  59,   0,   0, // 1271-1273
  59,   0,   0, // 1274-1276
  59,   0,   0, // 1277-1279
  59,   0,   0, // 1280-1282
  72,   0,   0, // 1283-1285
  7,   9,   0,   0, // 1286-1289
  7,   9,   0,   0, // 1290-1293
  2,   0,   0,   0, // 1294-1297
  2,   0,   0,   0, // 1298-1301
  2,   0,   0,   0, // 1302-1305
  6,   8,   0,   0, // 1306-1309
  6,   8,   0,   0, // 1310-1313
  6,   0,   0, // 1314-1316
  6,   0,   0, // 1317-1319
  7,   9,   0,   0, // 1320-1323
  7,   9,   0,   0, // 1324-1327
  6,   0,   0, // 1328-1330
  6,   0,   0, // 1331-1333
  6,   0,   0, // 1334-1336
  0,   0,   0, // 1337-1339
  1,   0,   0, // 1340-1342
  6,   0,   0, // 1343-1345
  0,   0,   0, // 1346-1348
  6,   0,   0, // 1349-1351
  16, // 1352
  6,   0,   0, // 1353-1355
  0,   0,   0, // 1356-1358
  7,   0,   0, // 1359-1361
  0,   0,   0, // 1362-1364
  6,   0, // 1365-1366
  6,   0, // 1367-1368
  1,   0,   0, // 1369-1371
  16,   0, // 1372-1373
  2,   0,   0, // 1374-1376
  6, // 1377
  1,   0,   0, // 1378-1380
  6,   0,   0, // 1381-1383
  6,   0,   0, // 1384-1386
  6,   0,   0,   0, // 1387-1390
  6,   0,   0, // 1391-1393
  6,   0,   0,   0, // 1394-1397
  6,   0,   0, // 1398-1400
  6,   0,   0, // 1401-1403
  6,   0,   0, // 1404-1406
  6,   0,   0, // 1407-1409
  6,   0,   0, // 1410-1412
  2,   0,   0, // 1413-1415
  2,   0,   0, // 1416-1418
  39,   0,   0, // 1419-1421
  6,   0,   0, // 1422-1424
  2,   0, // 1425-1426
  2,   0,   0, // 1427-1429
  5,   0,   0, // 1430-1432
  2,   0,   0, // 1433-1435
  5,   0,   0, // 1436-1438
  5,   0,   0, // 1439-1441
  2,   0,   0, // 1442-1444
  2,   0,   0, // 1445-1447
  2,   0,   0, // 1448-1450
  2,   0,   0, // 1451-1453
  2,   0,   0, // 1454-1456
  2,   0,   0, // 1457-1459
  1,   0,   0, // 1460-1462
  6,   0,   0, // 1463-1465
  6,   0, // 1466-1467
  1,   0,   0, // 1468-1470
  1,   0,   0, // 1471-1473
  2,   0,   0, // 1474-1476
  6,   0,   0, // 1477-1479
  2,   0,   0, // 1480-1482
  2,   0,   0, // 1483-1485
  1,   0,   0, // 1486-1488
  2,   0,   0, // 1489-1491
  2,   0,   0, // 1492-1494
  2,   0,   0, // 1495-1497
  2,   0,   0, // 1498-1500
  2,   0,   0, // 1501-1503
  6,   0,   0, // 1504-1506
  2,   0,   0, // 1507-1509
  6,   0, // 1510-1511
  2,   0,   0, // 1512-1514
  1,   0,   0, // 1515-1517
  2,   0,   0, // 1518-1520
  6,   0,   0, // 1521-1523
  6,   0,   0, // 1524-1526
  6,   0,   0, // 1527-1529
  2,   0,   0, // 1530-1532
  2,   0,   0, // 1533-1535
  6,   0,   0, // 1536-1538
  7,   0,   0, // 1539-1541
  1,   0,   0, // 1542-1544
  6,   0,   0, // 1545-1547
  6,   0,   0, // 1548-1550
  2,   0,   0, // 1551-1553
  6,   0,   0, // 1554-1556
  7,   0,   0, // 1557-1559
  7,   0,   0, // 1560-1562
  4,   0, // 1563-1564
  1,   0,   0, // 1565-1567
  16,   0,   0, // 1568-1570
  1,   0,   0, // 1571-1573
  7,   0,   0, // 1574-1576
  0,   0,   0, // 1577-1579
  0,   0,   0, // 1580-1582
  0,   0,   0, // 1583-1585
  6,   0,   0, // 1586-1588
  6,   0,   0, // 1589-1591
  7,   0,   0, // 1592-1594
  7,   0,   0, // 1595-1597
  6,   0,   0, // 1598-1600
  1,   0,   0, // 1601-1603
  6,   0,   0, // 1604-1606
  0,   0,   0, // 1607-1609
  6,   0,   0, // 1610-1612
  6,   0,   0, // 1613-1615
  7,   0,   0, // 1616-1618
  1,   0,   0, // 1619-1621
  4,   1,   1, // 1622-1624
  4,   1,   1, // 1625-1627
  4,   1, // 1628-1629
  5,   1,   1, // 1630-1632
  4,   1,   1, // 1633-1635
  6,   1, // 1636-1637
  6,   1, // 1638-1639
  17,   1,   1, // 1640-1642
  9,   1,   1, // 1643-1645
  35,   1,   1, // 1646-1648
  7,   1,   1, // 1649-1651
  4,   1,   1, // 1652-1654
  7,   1,   1, // 1655-1657
  6,   1, // 1658-1659
  32,   1,   1, // 1660-1662
  6,   1, // 1663-1664
  4,   1,   1,   1, // 1665-1668
  6,   1,   1, // 1669-1671
  6,   1, // 1672-1673
  6,   1, // 1674-1675
  6,   1, // 1676-1677
  6,   1, // 1678-1679
  6,   1, // 1680-1681
  7,   1, // 1682-1683
  4,   1, // 1684-1685
  4,   1,   1, // 1686-1688
  8,   1, // 1689-1690
  4,   1, // 1691-1692
  7,   1, // 1693-1694
  8,   1, // 1695-1696
  7,   1, // 1697-1698
  7,   1, // 1699-1700
  7,   1, // 1701-1702
  4,   1, // 1703-1704
  5,   1, // 1705-1706
  4,   1, // 1707-1708
  5,   1, // 1709-1710
  7,   1,   1, // 1711-1713
  7,   1,   1, // 1714-1716
  7,   1,   1, // 1717-1719
  4,   1,   1, // 1720-1722
  4,   1,   1, // 1723-1725
  6,   1, // 1726-1727
  6,   1, // 1728-1729
  6,   1, // 1730-1731
  5,   1, // 1732-1733
  4,   1,   1, // 1734-1736
  4,   1, // 1737-1738
  5,   1,   1, // 1739-1741
  5,   1, // 1742-1743
  4,   1,   1, // 1744-1746
  4,   1,   1, // 1747-1749
  5,   1,   1, // 1750-1752
  4,   1,   1, // 1753-1755
  4,   1,   1, // 1756-1758
  4,   1, // 1759-1760
  4,   1,   1, // 1761-1763
  4,   1, // 1764-1765
  4,   1, // 1766-1767
  6,   1, // 1768-1769
  4,   1,   1, // 1770-1772
  8,   1, // 1773-1774
  4,   1,   1, // 1775-1777
  4,   1,   1, // 1778-1780
  4,   1,   1, // 1781-1783
  4,   1,   1, // 1784-1786
  4,   1,   1,   1, // 1787-1790
  4,   1, // 1791-1792
  6,   1, // 1793-1794
  6,   1, // 1795-1796
  4,   1,   1, // 1797-1799
  4,   1,   1, // 1800-1802
  7,   1,   1, // 1803-1805
  7,   1,   1, // 1806-1808
  7,   1,   1, // 1809-1811
  7,   1,   1, // 1812-1814
  7,   1,   1, // 1815-1817
  6,   1, // 1818-1819
  4,   1,   1, // 1820-1822
  6,   1, // 1823-1824
  6,   1, // 1825-1826
  6,   1, // 1827-1828
  6,   1, // 1829-1830
  6,   1, // 1831-1832
  6,   1,   1, // 1833-1835
  7,   1, // 1836-1837
  6,   1, // 1838-1839
  6,   1, // 1840-1841
  4,   1, // 1842-1843
  6,   1, // 1844-1845
  6,   1, // 1846-1847
  4,   1, // 1848-1849
  6,   1, // 1850-1851
  6,   1, // 1852-1853
  6,   1, // 1854-1855
  6,   1, // 1856-1857
  7,   1, // 1858-1859
  6,   1, // 1860-1861
  6,   1, // 1862-1863
  4,   1, // 1864-1865
  4,   1,   1, // 1866-1868
  7,   1, // 1869-1870
  4,   1, // 1871-1872
  7,   1, // 1873-1874
  4,   1, // 1875-1876
  7,   1, // 1877-1878
  5,   1, // 1879-1880
  4,   1, // 1881-1882
  17,   1,   1, // 1883-1885
  17,   1,   1, // 1886-1888
  17,   1,   1, // 1889-1891
  17,   1,   1, // 1892-1894
  4,   1,   1, // 1895-1897
  4,   1,   1, // 1898-1900
  4,   1, // 1901-1902
  4,   1,   1, // 1903-1905
  4,   1,   1, // 1906-1908
  4,   1,   1, // 1909-1911
  8,   1, // 1912-1913
  35,   1,   1, // 1914-1916
  35,   1,   1, // 1917-1919
  35,   1,   1, // 1920-1922
  32,   1,   1, // 1923-1925
  32,   1,   1, // 1926-1928
  32,   1,   1, // 1929-1931
  32,   1,   1, // 1932-1934
  35,   1,   1, // 1935-1937
  6,   1, // 1938-1939
  6,   1, // 1940-1941
  6,   1, // 1942-1943
  6,   1, // 1944-1945
  4,   1, // 1946-1947
  4,   1, // 1948-1949
  6,   1, // 1950-1951
  6,   1, // 1952-1953
  4,   1,   1, // 1954-1956
  4,   1,   1, // 1957-1959
  7,   1,   1, // 1960-1962
  6,   1, // 1963-1964
  6,   1, // 1965-1966
  4,   1, // 1967-1968
  6,   1, // 1969-1970
  6,   1, // 1971-1972
  7,   1, // 1973-1974
  5,   1, // 1975-1976
  4,   1, // 1977-1978
  4,   1, // 1979-1980
  4,   1,   1, // 1981-1983
  5,   1, // 1984-1985
  4,   1,   1, // 1986-1988
  6,   1, // 1989-1990
  4,   1,   1, // 1991-1993
  4,   1, // 1994-1995
  4,   1, // 1996-1997
  4,   1, // 1998-1999
  4,   1, // 2000-2001
  4,   1,   1, // 2002-2004
  4,   1,   1, // 2005-2007
  4,   1,   1, // 2008-2010
  4,   1,   1, // 2011-2013
  4,   1,   1, // 2014-2016
  17,   1,   1, // 2017-2019
  4,   1,   1, // 2020-2022
  4,   1,   1, // 2023-2025
  4,   1,   1, // 2026-2028
  4,   1,   1, // 2029-2031
  4,   1,   1, // 2032-2034
  4,   1,   1, // 2035-2037
  4,   1,   1, // 2038-2040
  4,   1,   1, // 2041-2043
  6,   1, // 2044-2045
  5,   1, // 2046-2047
  4,   1,   1, // 2048-2050
  4,   1,   1, // 2051-2053
  4,   1,   1, // 2054-2056
  4,   1,   1, // 2057-2059
  4,   1,   1, // 2060-2062
  5,   1,   1, // 2063-2065
  4,   1,   1, // 2066-2068
  4,   1,   1, // 2069-2071
  4,   1,   1, // 2072-2074
  6,   1, // 2075-2076
  4,   1, // 2077-2078
  4,   1,   1, // 2079-2081
  4,   1,   1, // 2082-2084
  4,   1,   1, // 2085-2087
  4,   1,   1, // 2088-2090
  4,   1,   1, // 2091-2093
  5,   1,   1, // 2094-2096
  4,   1,   1, // 2097-2099
  4,   1,   1, // 2100-2102
  4,   1,   1, // 2103-2105
  4,   1,   1, // 2106-2108
  4,   1,   1, // 2109-2111
  4,   1,   1, // 2112-2114
  4,   1,   1, // 2115-2117
  4,   1,   1, // 2118-2120
  6,   1, // 2121-2122
  4,   1, // 2123-2124
  4,   1,   1, // 2125-2127
  4,   1,   1, // 2128-2130
  4,   1,   1, // 2131-2133
  4,   1, // 2134-2135
  4,   1, // 2136-2137
  4,   1,   1, // 2138-2140
  4,   1,   1, // 2141-2143
  4,   1,   1, // 2144-2146
  6,   1, // 2147-2148
  6,   1, // 2149-2150
  6,   1, // 2151-2152
  6,   1, // 2153-2154
  5,   1, // 2155-2156
  4,   1,   1, // 2157-2159
  6,   1, // 2160-2161
  7,   1, // 2162-2163
  7,   1, // 2164-2165
  4,   1,   1, // 2166-2168
  4,   1,   1, // 2169-2171
  4,   1,   1, // 2172-2174
  4,   1,   1, // 2175-2177
  4,   1,   1, // 2178-2180
  4,   1,   1, // 2181-2183
  4,   1,   1, // 2184-2186
  4,   1,   1, // 2187-2189
  4,   1,   1, // 2190-2192
  4,   1,   1, // 2193-2195
  4,   1,   1, // 2196-2198
  4,   1,   1, // 2199-2201
  4,   1,   1, // 2202-2204
  4,   1,   1, // 2205-2207
  6,   1, // 2208-2209
  6,   1, // 2210-2211
  6,   1, // 2212-2213
  6,   1, // 2214-2215
  6,   1, // 2216-2217
  6,   1, // 2218-2219
  4,   1, // 2220-2221
  6,   1, // 2222-2223
  6,   1, // 2224-2225
  6,   1, // 2226-2227
  4,   1, // 2228-2229
  4,   1, // 2230-2231
  4,   1,   1, // 2232-2234
  4,   1,   1, // 2235-2237
  4,   1,   1, // 2238-2240
  4,   1,   1, // 2241-2243
  4,   1,   1, // 2244-2246
  4,   1, // 2247-2248
  5,   1,   1, // 2249-2251
  4,   1,   1, // 2252-2254
  6,   1, // 2255-2256
  6,   1, // 2257-2258
  17,   1,   1, // 2259-2261
  13,   1,   1, // 2262-2264
  71,   1,   1, // 2265-2267
  11,   1,   1, // 2268-2270
  11,   1,   1, // 2271-2273
  6,   1, // 2274-2275
  41,   1,   1, // 2276-2278
  13,   1,   1,   1, // 2279-2282
  6,   1, // 2283-2284
  4,   1,   1,   1, // 2285-2288
  6,   1,   1, // 2289-2291
  6,   1, // 2292-2293
  6,   1, // 2294-2295
  7,   1,   1, // 2296-2298
  7,   1,   1, // 2299-2301
  7,   1,   1, // 2302-2304
  6,   1, // 2305-2306
  6,   1, // 2307-2308
  6,   1, // 2309-2310
  7,   1, // 2311-2312
  4,   1, // 2313-2314
  4,   1,   1, // 2315-2317
  8,   1, // 2318-2319
  4,   1, // 2320-2321
  11, // 2322
  7,   1, // 2323-2324
  8,   1, // 2325-2326
  7,   1, // 2327-2328
  7,   1, // 2329-2330
  7,   1, // 2331-2332
  4,   1, // 2333-2334
  11,   1,   1, // 2335-2337
  5,   1, // 2338-2339
  4,   1, // 2340-2341
  5,   1, // 2342-2343
  7,   1,   1, // 2344-2346
  7,   1,   1, // 2347-2349
  7,   1,   1, // 2350-2352
  4,   1,   1, // 2353-2355
  4,   1,   1, // 2356-2358
  6,   1, // 2359-2360
  6,   1, // 2361-2362
  6,   1, // 2363-2364
  6,   1,   1, // 2365-2367
  6,   1,   1, // 2368-2370
  5,   1, // 2371-2372
  4,   1, // 2373-2374
  11,   1,   1, // 2375-2377
  11, // 2378
  5,   1,   1, // 2379-2381
  5,   1, // 2382-2383
  11,   1,   1, // 2384-2386
  11,   1,   1, // 2387-2389
  4,   1,   1, // 2390-2392
  5,   1,   1, // 2393-2395
  4,   1,   1, // 2396-2398
  4,   1,   1, // 2399-2401
  4,   1, // 2402-2403
  4,   1,   1, // 2404-2406
  4,   1, // 2407-2408
  4,   1, // 2409-2410
  6,   1, // 2411-2412
  4,   1,   1, // 2413-2415
  8,   1, // 2416-2417
  4,   1,   1, // 2418-2420
  4,   1,   1, // 2421-2423
  4,   1,   1, // 2424-2426
  11,   1,   1, // 2427-2429
  4,   1,   1, // 2430-2432
  4,   1,   1,   1, // 2433-2436
  4,   1, // 2437-2438
  6,   1, // 2439-2440
  6,   1, // 2441-2442
  11,   1,   1, // 2443-2445
  7,   1,   1, // 2446-2448
  7,   1,   1, // 2449-2451
  7,   1,   1, // 2452-2454
  11,   1,   1, // 2455-2457
  13,   1,   1, // 2458-2460
  13,   1,   1,   1, // 2461-2464
  11,   1,   1, // 2465-2467
  7,   1,   1, // 2468-2470
  7,   1,   1, // 2471-2473
  11,   1,   1, // 2474-2476
  13,   1,   1, // 2477-2479
  13,   1,   1,   1, // 2480-2483
  6,   1, // 2484-2485
  11,   1,   1, // 2486-2488
  6,   1, // 2489-2490
  6,   1, // 2491-2492
  7,   1,   1, // 2493-2495
  6,   1, // 2496-2497
  6,   1, // 2498-2499
  6,   1, // 2500-2501
  6,   1,   1, // 2502-2504
  7,   1, // 2505-2506
  7,   1,   1, // 2507-2509
  6,   1, // 2510-2511
  6,   1, // 2512-2513
  4,   1, // 2514-2515
  6,   1, // 2516-2517
  6,   1, // 2518-2519
  4,   1, // 2520-2521
  7,   1,   1, // 2522-2524
  7,   1,   1, // 2525-2527
  7,   1,   1, // 2528-2530
  7,   1,   1, // 2531-2533
  6,   1, // 2534-2535
  6,   1, // 2536-2537
  7,   1,   1, // 2538-2540
  6,   1,   1, // 2541-2543
  6,   1, // 2544-2545
  6,   1, // 2546-2547
  7,   1, // 2548-2549
  6,   1, // 2550-2551
  6,   1,   1, // 2552-2554
  6,   1, // 2555-2556
  4,   1, // 2557-2558
  4,   1,   1, // 2559-2561
  7,   1, // 2562-2563
  4,   1, // 2564-2565
  7,   1, // 2566-2567
  4,   1, // 2568-2569
  7,   1, // 2570-2571
  5,   1, // 2572-2573
  4,   1, // 2574-2575
  17,   1,   1, // 2576-2578
  17,   1,   1, // 2579-2581
  17,   1,   1, // 2582-2584
  17,   1,   1, // 2585-2587
  4,   1,   1, // 2588-2590
  4,   1,   1, // 2591-2593
  11,   1,   1, // 2594-2596
  4,   1, // 2597-2598
  11, // 2599
  11,   1,   1, // 2600-2602
  4,   1,   1, // 2603-2605
  4,   1,   1, // 2606-2608
  4,   1,   1, // 2609-2611
  11, // 2612
  8,   1, // 2613-2614
  71,   1,   1, // 2615-2617
  71,   1,   1, // 2618-2620
  71,   1,   1, // 2621-2623
  41,   1,   1, // 2624-2626
  41,   1,   1, // 2627-2629
  41,   1,   1, // 2630-2632
  41,   1,   1, // 2633-2635
  71,   1,   1, // 2636-2638
  7,   1,   1, // 2639-2641
  7,   1,   1, // 2642-2644
  6,   1,   1, // 2645-2647
  6,   1, // 2648-2649
  6,   1, // 2650-2651
  6,   1, // 2652-2653
  6,   1, // 2654-2655
  7,   1,   1, // 2656-2658
  7,   1,   1, // 2659-2661
  4,   1, // 2662-2663
  4,   1, // 2664-2665
  6,   1, // 2666-2667
  6,   1, // 2668-2669
  4,   1,   1, // 2670-2672
  6,   1, // 2673-2674
  6,   1, // 2675-2676
  4,   1, // 2677-2678
  6,   1, // 2679-2680
  6,   1, // 2681-2682
  7,   1,   1, // 2683-2685
  6,   1,   1, // 2686-2688
  7,   1, // 2689-2690
  5,   1, // 2691-2692
  4,   1, // 2693-2694
  4,   1, // 2695-2696
  4,   1,   1, // 2697-2699
  5,   1, // 2700-2701
  4,   1,   1, // 2702-2704
  6,   1, // 2705-2706
  11,   1,   1, // 2707-2709
  11,   1,   1, // 2710-2712
  13,   1,   1,   1, // 2713-2716
  11,   1,   1, // 2717-2719
  13,   1,   1,   1, // 2720-2723
  11,   1,   1, // 2724-2726
  4,   1, // 2727-2728
  4,   1, // 2729-2730
  4,   1, // 2731-2732
  4,   1, // 2733-2734
  4,   1,   1, // 2735-2737
  4,   1,   1, // 2738-2740
  17,   1,   1, // 2741-2743
  6,   1, // 2744-2745
  5,   1, // 2746-2747
  4,   1,   1, // 2748-2750
  11,   1,   1, // 2751-2753
  4,   1,   1, // 2754-2756
  11,   1,   1, // 2757-2759
  11,   1,   1, // 2760-2762
  5,   1,   1, // 2763-2765
  4,   1,   1, // 2766-2768
  4,   1,   1, // 2769-2771
  6,   1, // 2772-2773
  4,   1, // 2774-2775
  4,   1,   1, // 2776-2778
  4,   1,   1, // 2779-2781
  4,   1,   1, // 2782-2784
  11,   1,   1, // 2785-2787
  4,   1,   1, // 2788-2790
  5,   1,   1, // 2791-2793
  4,   1,   1, // 2794-2796
  4,   1,   1, // 2797-2799
  4,   1,   1, // 2800-2802
  4,   1,   1, // 2803-2805
  4,   1,   1, // 2806-2808
  6,   1, // 2809-2810
  11, // 2811
  4,   1, // 2812-2813
  4,   1,   1, // 2814-2816
  11,   1,   1, // 2817-2819
  4,   1,   1, // 2820-2822
  4,   1,   1, // 2823-2825
  4,   1, // 2826-2827
  11,   1,   1, // 2828-2830
  4,   1, // 2831-2832
  4,   1,   1, // 2833-2835
  4,   1,   1, // 2836-2838
  11, // 2839
  11, // 2840
  6,   1, // 2841-2842
  7,   1,   1, // 2843-2845
  6,   1, // 2846-2847
  6,   1, // 2848-2849
  6,   1, // 2850-2851
  5,   1, // 2852-2853
  4,   1,   1, // 2854-2856
  6,   1, // 2857-2858
  7,   1,   1, // 2859-2861
  7,   1,   1, // 2862-2864
  7,   1, // 2865-2866
  7,   1, // 2867-2868
  6,   1, // 2869-2870
  6,   1, // 2871-2872
  6,   1, // 2873-2874
  7,   1,   1, // 2875-2877
  6,   1, // 2878-2879
  6,   1,   1, // 2880-2882
  6,   1, // 2883-2884
  6,   1, // 2885-2886
  7,   1,   1, // 2887-2889
  7,   1,   1, // 2890-2892
  4,   1, // 2893-2894
  6,   1, // 2895-2896
  6,   1, // 2897-2898
  6,   1, // 2899-2900
  4,   1, // 2901-2902
  4,   1, // 2903-2904
  7,   1,   1, // 2905-2907
  4,   1,   1, // 2908-2910
  5,   2,   2, // 2911-2913
  5,   2,   2, // 2914-2916
  5,   2, // 2917-2918
  6,   2,   2, // 2919-2921
  5,   2,   2, // 2922-2924
  7,   2, // 2925-2926
  7,   2, // 2927-2928
  7,   2, // 2929-2930
  30,   2,   2, // 2931-2933
  20,   2,   2, // 2934-2936
  11,   2,   2, // 2937-2939
  39,   2,   2, // 2940-2942
  11,   2,   2, // 2943-2945
  11,   2,   2, // 2946-2948
  7,   2, // 2949-2950
  5,   2,   2, // 2951-2953
  24,   2,   2, // 2954-2956
  11,   2,   2,   2, // 2957-2960
  7,   2, // 2961-2962
  5,   2,   2,   2, // 2963-2966
  7,   2,   2, // 2967-2969
  7,   2, // 2970-2971
  7,   2, // 2972-2973
  7,   2, // 2974-2975
  7,   2, // 2976-2977
  7,   2, // 2978-2979
  8,   2,   2, // 2980-2982
  8,   2,   2, // 2983-2985
  8,   2,   2, // 2986-2988
  7,   2, // 2989-2990
  7,   2, // 2991-2992
  7,   2, // 2993-2994
  8,   2, // 2995-2996
  9,   2,   2, // 2997-2999
  5,   2, // 3000-3001
  5,   2,   2, // 3002-3004
  9,   2, // 3005-3006
  5, // 3007
  11, // 3008
  9,   2, // 3009-3010
  8,   2, // 3011-3012
  8,   2, // 3013-3014
  5, // 3015
  11,   2,   2, // 3016-3018
  6,   2, // 3019-3020
  5, // 3021
  8,   2,   2, // 3022-3024
  8,   2,   2, // 3025-3027
  8,   2,   2, // 3028-3030
  6,   2,   2, // 3031-3033
  5,   2,   2, // 3034-3036
  6,   2,   2, // 3037-3039
  7,   2, // 3040-3041
  7,   2, // 3042-3043
  7,   2, // 3044-3045
  7,   2, // 3046-3047
  7,   2, // 3048-3049
  7,   2,   2, // 3050-3052
  7,   2,   2, // 3053-3055
  6,   2, // 3056-3057
  5, // 3058
  11,   2,   2, // 3059-3061
  11, // 3062
  6,   2,   2, // 3063-3065
  6,   2, // 3066-3067
  11,   2,   2, // 3068-3070
  11,   2,   2, // 3071-3073
  5,   2,   2, // 3074-3076
  6,   2,   2, // 3077-3079
  5,   2,   2, // 3080-3082
  6,   2,   2, // 3083-3085
  5,   2,   2, // 3086-3088
  5,   2,   2, // 3089-3091
  5,   2, // 3092-3093
  5,   2,   2, // 3094-3096
  5,   2, // 3097-3098
  5, // 3099
  7,   2, // 3100-3101
  6,   2,   2, // 3102-3104
  5,   2,   2, // 3105-3107
  5,   2,   2, // 3108-3110
  9,   2, // 3111-3112
  5,   2,   2, // 3113-3115
  5,   2,   2, // 3116-3118
  5,   2,   2, // 3119-3121
  11,   2,   2, // 3122-3124
  6,   2,   2, // 3125-3127
  5,   2,   2,   2, // 3128-3131
  5, // 3132
  7,   2, // 3133-3134
  7,   2, // 3135-3136
  11,   2,   2, // 3137-3139
  9,   2,   2, // 3140-3142
  8,   2,   2, // 3143-3145
  8,   2,   2, // 3146-3148
  8,   2,   2, // 3149-3151
  11,   2,   2, // 3152-3154
  11,   2,   2, // 3155-3157
  11,   2,   2,   2, // 3158-3161
  11,   2,   2, // 3162-3164
  8,   2,   2, // 3165-3167
  8,   2,   2, // 3168-3170
  9,   2,   2, // 3171-3173
  11,   2,   2, // 3174-3176
  11,   2,   2, // 3177-3179
  11,   2,   2,   2, // 3180-3183
  7,   2, // 3184-3185
  11,   2,   2, // 3186-3188
  7,   2, // 3189-3190
  7,   2, // 3191-3192
  8,   2,   2, // 3193-3195
  7,   2, // 3196-3197
  7,   2, // 3198-3199
  7,   2, // 3200-3201
  7,   2,   2, // 3202-3204
  7,   2, // 3205-3206
  7,   2, // 3207-3208
  8,   2, // 3209-3210
  8,   2,   2, // 3211-3213
  7,   2, // 3214-3215
  7,   2, // 3216-3217
  5, // 3218
  7,   2, // 3219-3220
  7,   2, // 3221-3222
  7,   2, // 3223-3224
  7,   2, // 3225-3226
  5, // 3227
  8,   2,   2, // 3228-3230
  8,   2,   2, // 3231-3233
  8,   2,   2, // 3234-3236
  8,   2,   2, // 3237-3239
  7,   2, // 3240-3241
  7,   2, // 3242-3243
  8,   2,   2, // 3244-3246
  7,   2,   2, // 3247-3249
  7,   2, // 3250-3251
  7,   2, // 3252-3253
  7,   2, // 3254-3255
  8,   2, // 3256-3257
  7,   2, // 3258-3259
  7,   2,   2, // 3260-3262
  7,   2, // 3263-3264
  5, // 3265
  5,   2,   2, // 3266-3268
  8,   2, // 3269-3270
  5, // 3271
  8,   2, // 3272-3273
  5, // 3274
  6,   2, // 3275-3276
  5, // 3277
  20,   2,   2, // 3278-3280
  20,   2,   2, // 3281-3283
  30,   2,   2, // 3284-3286
  30,   2,   2, // 3287-3289
  20,   2,   2, // 3290-3292
  30,   2,   2, // 3293-3295
  20,   2,   2, // 3296-3298
  30,   2,   2, // 3299-3301
  5,   2,   2, // 3302-3304
  5,   2,   2, // 3305-3307
  11,   2,   2, // 3308-3310
  5,   2, // 3311-3312
  11, // 3313
  11,   2,   2, // 3314-3316
  6,   2,   2, // 3317-3319
  5,   2,   2, // 3320-3322
  5,   2,   2, // 3323-3325
  5,   2,   2, // 3326-3328
  6,   2,   2, // 3329-3331
  11, // 3332
  9,   2, // 3333-3334
  5,   2,   2, // 3335-3337
  6,   2,   2, // 3338-3340
  39,   2,   2, // 3341-3343
  39,   2,   2, // 3344-3346
  39,   2,   2, // 3347-3349
  24,   2,   2, // 3350-3352
  24,   2,   2, // 3353-3355
  24,   2,   2, // 3356-3358
  24,   2,   2, // 3359-3361
  39,   2,   2, // 3362-3364
  8,   2,   2, // 3365-3367
  8,   2,   2, // 3368-3370
  7,   2,   2, // 3371-3373
  7,   2, // 3374-3375
  7,   2, // 3376-3377
  7,   2, // 3378-3379
  7,   2, // 3380-3381
  7,   2, // 3382-3383
  7,   2, // 3384-3385
  8,   2,   2, // 3386-3388
  8,   2,   2, // 3389-3391
  5,   2, // 3392-3393
  5,   2, // 3394-3395
  7,   2, // 3396-3397
  7,   2, // 3398-3399
  5,   2,   2, // 3400-3402
  7,   2, // 3403-3404
  7,   2, // 3405-3406
  5,   2, // 3407-3408
  7,   2, // 3409-3410
  7,   2, // 3411-3412
  8,   2,   2, // 3413-3415
  7,   2,   2, // 3416-3418
  5, // 3419
  5, // 3420
  5,   2,   2, // 3421-3423
  6,   2, // 3424-3425
  5,   2,   2, // 3426-3428
  7,   2, // 3429-3430
  11,   2,   2, // 3431-3433
  11,   2,   2, // 3434-3436
  11,   2,   2,   2, // 3437-3440
  11,   2,   2, // 3441-3443
  11,   2,   2,   2, // 3444-3447
  11,   2,   2, // 3448-3450
  5,   2, // 3451-3452
  5,   2, // 3453-3454
  5,   2, // 3455-3456
  5,   2, // 3457-3458
  5,   2,   2, // 3459-3461
  5,   2,   2, // 3462-3464
  20,   2,   2, // 3465-3467
  7,   2, // 3468-3469
  6,   2, // 3470-3471
  5,   2,   2, // 3472-3474
  11,   2,   2, // 3475-3477
  5,   2,   2, // 3478-3480
  11,   2,   2, // 3481-3483
  11,   2,   2, // 3484-3486
  6,   2,   2, // 3487-3489
  5,   2,   2, // 3490-3492
  6,   2,   2, // 3493-3495
  5,   2,   2, // 3496-3498
  5,   2,   2, // 3499-3501
  5,   2,   2, // 3502-3504
  5,   2,   2, // 3505-3507
  7,   2, // 3508-3509
  5, // 3510
  5,   2,   2, // 3511-3513
  5,   2,   2, // 3514-3516
  5,   2,   2, // 3517-3519
  11,   2,   2, // 3520-3522
  5,   2,   2, // 3523-3525
  6,   2,   2, // 3526-3528
  5,   2,   2, // 3529-3531
  5,   2,   2, // 3532-3534
  5,   2,   2, // 3535-3537
  5,   2,   2, // 3538-3540
  5,   2,   2, // 3541-3543
  5,   2,   2, // 3544-3546
  7,   2, // 3547-3548
  5,   2,   2, // 3549-3551
  11, // 3552
  5, // 3553
  5,   2,   2, // 3554-3556
  11,   2,   2, // 3557-3559
  5,   2,   2, // 3560-3562
  5,   2,   2, // 3563-3565
  5,   2, // 3566-3567
  11,   2,   2, // 3568-3570
  5,   2, // 3571-3572
  5,   2,   2, // 3573-3575
  5,   2,   2, // 3576-3578
  11, // 3579
  11, // 3580
  7,   2, // 3581-3582
  7,   2, // 3583-3584
  8,   2,   2, // 3585-3587
  7,   2, // 3588-3589
  7,   2, // 3590-3591
  7,   2, // 3592-3593
  7,   2, // 3594-3595
  5,   2,   2, // 3596-3598
  7,   2, // 3599-3600
  8,   2,   2, // 3601-3603
  8,   2,   2, // 3604-3606
  8,   2, // 3607-3608
  9,   2,   2, // 3609-3611
  7,   2, // 3612-3613
  7,   2, // 3614-3615
  7,   2, // 3616-3617
  8,   2,   2, // 3618-3620
  7,   2, // 3621-3622
  7,   2, // 3623-3624
  7,   2,   2, // 3625-3627
  7,   2, // 3628-3629
  7,   2, // 3630-3631
  8,   2,   2, // 3632-3634
  8,   2,   2, // 3635-3637
  5,   2, // 3638-3639
  7,   2, // 3640-3641
  7,   2, // 3642-3643
  7,   2, // 3644-3645
  5,   2, // 3646-3647
  5,   2, // 3648-3649
  8,   2,   2, // 3650-3652
  5,   2,   2, // 3653-3655
  1,   1,   1, // 3656-3658
  1,   1,   1, // 3659-3661
  3,   1,   1, // 3662-3664
  6,   1,   1, // 3665-3667
  1,   1,   1, // 3668-3670
  3,   1,   1, // 3671-3673
  2,   1,   1, // 3674-3676
  2,   1,   1, // 3677-3679
  23,   1,   1, // 3680-3682
  15,   1,   1, // 3683-3685
  5,   1,   1, // 3686-3688
  33,   1,   1, // 3689-3691
  8,   1,   1, // 3692-3694
  5,   1,   1, // 3695-3697
  2,   1,   1, // 3698-3700
  7,   1,   1, // 3701-3703
  1,   1,   1, // 3704-3706
  1,   1,   1, // 3707-3709
  27,   1,   1, // 3710-3712
  5,   1,   1,   1, // 3713-3716
  44,   1,   1, // 3717-3719
  32,   1,   1, // 3720-3722
  1,   1,   1,   1, // 3723-3726
  3,   1,   1, // 3727-3729
  2,   2,   1,   1, // 3730-3733
  3,   3,   1,   1, // 3734-3737
  3,   1,   1, // 3738-3740
  2,   2,   1,   1, // 3741-3744
  3,   3,   1,   1, // 3745-3748
  3,   1,   1, // 3749-3751
  3,   3,   1,   1, // 3752-3755
  3,   3,   1,   1, // 3756-3759
  3,   1,   1, // 3760-3762
  4,   4,   1,   1, // 3763-3766
  4,   4,   1,   1, // 3767-3770
  2,   1,   1, // 3771-3773
  3,   1,   1, // 3774-3776
  4,   1,   1, // 3777-3779
  3,   1,   1, // 3780-3782
  3,   1, // 3783-3784
  6,   1, // 3785-3786
  3,   1, // 3787-3788
  4,   1, // 3789-3790
  4,   1,   1, // 3791-3793
  4,   1,   1, // 3794-3796
  4,   1,   1, // 3797-3799
  1,   1,   1, // 3800-3802
  1,   1,   1, // 3803-3805
  1,   1,   1, // 3806-3808
  1,   1,   1, // 3809-3811
  2,   1,   1,   1, // 3812-3815
  2,   1,   1,   1, // 3816-3819
  1,   1,   1, // 3820-3822
  1,   1,   1, // 3823-3825
  2,   1,   1,   1, // 3826-3829
  1,   1, // 3830-3831
  1,   1, // 3832-3833
  6,   1,   1, // 3834-3836
  3,   1,   1, // 3837-3839
  2,   1,   1, // 3840-3842
  6,   1,   1, // 3843-3845
  3,   1,   1, // 3846-3848
  4,   1, // 3849-3850
  1,   1,   1, // 3851-3853
  1,   1, // 3854-3855
  1,   1, // 3856-3857
  8,   1,   1, // 3858-3860
  6,   1,   1, // 3861-3863
  6,   1,   1, // 3864-3866
  8,   1,   1, // 3867-3869
  1,   1,   1, // 3870-3872
  1,   1,   1, // 3873-3875
  1,   1,   1, // 3876-3878
  2,   1,   1, // 3879-3881
  1,   1,   1, // 3882-3884
  1,   1,   1, // 3885-3887
  1,   1,   1, // 3888-3890
  3,   1,   1, // 3891-3893
  3,   1, // 3894-3895
  6,   1,   1, // 3896-3898
  3,   1,   1, // 3899-3901
  4,   1, // 3902-3903
  2,   1,   1, // 3904-3906
  1,   1,   1, // 3907-3909
  1,   1,   1, // 3910-3912
  1,   1,   1, // 3913-3915
  3,   1, // 3916-3917
  3,   1, // 3918-3919
  3,   1,   1, // 3920-3922
  1,   1,   1, // 3923-3925
  5,   1,   1, // 3926-3928
  1,   1,   1, // 3929-3931
  1,   1,   1,   1, // 3932-3935
  6,   1,   1, // 3936-3938
  4,   1, // 3939-3940
  1,   1,   1, // 3941-3943
  2,   1,   1, // 3944-3946
  6,   1,   1, // 3947-3949
  2,   1,   1, // 3950-3952
  6,   1,   1, // 3953-3955
  8,   1,   1, // 3956-3958
  6,   1,   1, // 3959-3961
  2,   1,   1, // 3962-3964
  4,   1,   1, // 3965-3967
  4,   1,   1, // 3968-3970
  4,   1,   1, // 3971-3973
  4,   1,   1, // 3974-3976
  5,   1,   1, // 3977-3979
  5,   1,   1, // 3980-3982
  5,   1,   1,   1, // 3983-3986
  6,   1,   1, // 3987-3989
  5,   1,   1, // 3990-3992
  4,   1,   1, // 3993-3995
  4,   1,   1, // 3996-3998
  4,   1,   1, // 3999-4001
  5,   1,   1, // 4002-4004
  5,   1,   1, // 4005-4007
  5,   1,   1,   1, // 4008-4011
  6,   1,   1, // 4012-4014
  2,   1,   1, // 4015-4017
  3,   1,   1, // 4018-4020
  6,   1,   1, // 4021-4023
  2,   1,   1, // 4024-4026
  8,   1,   1, // 4027-4029
  6,   1,   1, // 4030-4032
  6,   1,   1, // 4033-4035
  6,   1,   1, // 4036-4038
  6,   1,   1, // 4039-4041
  6,   1,   1, // 4042-4044
  6,   1,   1, // 4045-4047
  2,   1,   1, // 4048-4050
  2,   1,   1, // 4051-4053
  3,   1,   1, // 4054-4056
  2,   1,   1, // 4057-4059
  3,   1,   1, // 4060-4062
  2,   1,   1, // 4063-4065
  3,   1,   1, // 4066-4068
  2,   1,   1, // 4069-4071
  3,   1,   1, // 4072-4074
  2,   2,   1,   1, // 4075-4078
  3,   3,   1,   1, // 4079-4082
  4,   1, // 4083-4084
  1,   1,   1, // 4085-4087
  1,   1,   1, // 4088-4090
  2,   1,   1, // 4091-4093
  3,   1,   1, // 4094-4096
  3,   1,   1, // 4097-4099
  4,   1, // 4100-4101
  3,   1,   1, // 4102-4104
  3,   1,   1, // 4105-4107
  3,   1,   1, // 4108-4110
  3,   1,   1, // 4111-4113
  4,   4,   1,   1, // 4114-4117
  4,   4,   1,   1, // 4118-4121
  3,   1,   1, // 4122-4124
  1,   1,   1, // 4125-4127
  1,   1,   1, // 4128-4130
  2,   1,   1, // 4131-4133
  2,   1,   1, // 4134-4136
  1,   1,   1, // 4137-4139
  1,   1,   1, // 4140-4142
  2,   1,   1, // 4143-4145
  4,   1, // 4146-4147
  1,   1,   1, // 4148-4150
  4,   1, // 4151-4152
  15,   1,   1, // 4153-4155
  15,   1,   1, // 4156-4158
  23,   1,   1, // 4159-4161
  23,   1,   1, // 4162-4164
  15,   1,   1, // 4165-4167
  23,   1,   1, // 4168-4170
  15,   1,   1, // 4171-4173
  23,   1,   1, // 4174-4176
  3,   1, // 4177-4178
  1,   1,   1, // 4179-4181
  5,   1,   1, // 4182-4184
  3,   1,   1, // 4185-4187
  1,   1,   1, // 4188-4190
  1,   1,   1, // 4191-4193
  1,   1,   1, // 4194-4196
  1,   1,   1, // 4197-4199
  1,   1,   1, // 4200-4202
  6,   1, // 4203-4204
  1,   1,   1, // 4205-4207
  1,   1,   1, // 4208-4210
  33,   1,   1, // 4211-4213
  33,   1,   1, // 4214-4216
  44,   1,   1, // 4217-4219
  44,   1,   1, // 4220-4222
  44,   1,   1, // 4223-4225
  32,   1,   1, // 4226-4228
  44,   1,   1, // 4229-4231
  32,   1,   1, // 4232-4234
  32,   1,   1, // 4235-4237
  32,   1,   1, // 4238-4240
  33,   1,   1, // 4241-4243
  27,   1,   1, // 4244-4246
  27,   1,   1, // 4247-4249
  27,   1,   1, // 4250-4252
  27,   1,   1, // 4253-4255
  33,   1,   1, // 4256-4258
  3,   3,   1,   1, // 4259-4262
  3,   3,   1,   1, // 4263-4266
  2,   1,   1,   1, // 4267-4270
  2,   1,   1,   1, // 4271-4274
  2,   1,   1,   1, // 4275-4278
  2,   2,   1,   1, // 4279-4282
  3,   3,   1,   1, // 4283-4286
  2,   2,   1,   1, // 4287-4290
  3,   3,   1,   1, // 4291-4294
  3,   3,   1,   1, // 4295-4298
  3,   3,   1,   1, // 4299-4302
  6,   1,   1, // 4303-4305
  3,   1,   1, // 4306-4308
  3,   1,   1, // 4309-4311
  2,   1,   1, // 4312-4314
  1,   1,   1, // 4315-4317
  1,   1,   1, // 4318-4320
  2,   1,   1, // 4321-4323
  7,   1,   1, // 4324-4326
  2,   1,   1, // 4327-4329
  1,   1,   1, // 4330-4332
  3,   1,   1, // 4333-4335
  2,   1,   1, // 4336-4338
  1,   1,   1, // 4339-4341
  3,   1,   1, // 4342-4344
  1,   1,   1, // 4345-4347
  4,   1, // 4348-4349
  1,   1,   1, // 4350-4352
  1,   1,   1, // 4353-4355
  5,   1,   1, // 4356-4358
  6,   1,   1, // 4359-4361
  6,   1,   1, // 4362-4364
  6,   1,   1, // 4365-4367
  5,   1,   1, // 4368-4370
  5,   1,   1,   1, // 4371-4374
  6,   1,   1, // 4375-4377
  2,   1,   1, // 4378-4380
  6,   1,   1, // 4381-4383
  6,   1,   1, // 4384-4386
  6,   1,   1, // 4387-4389
  6,   1,   1, // 4390-4392
  5,   1,   1, // 4393-4395
  5,   1,   1,   1, // 4396-4399
  5,   1,   1, // 4400-4402
  3,   1,   1, // 4403-4405
  3,   1,   1, // 4406-4408
  3,   1,   1, // 4409-4411
  3,   1,   1, // 4412-4414
  6,   1,   1, // 4415-4417
  1,   1,   1, // 4418-4420
  2,   1,   1, // 4421-4423
  6,   1,   1, // 4424-4426
  6,   1,   1, // 4427-4429
  6,   1,   1, // 4430-4432
  1,   1,   1, // 4433-4435
  6,   1,   1, // 4436-4438
  2,   1,   1, // 4439-4441
  2,   1,   1, // 4442-4444
  15,   1,   1, // 4445-4447
  2,   1,   1, // 4448-4450
  2,   1,   1, // 4451-4453
  2,   1,   1, // 4454-4456
  2,   1,   1, // 4457-4459
  2,   1,   1, // 4460-4462
  2,   1,   1, // 4463-4465
  6,   1,   1, // 4466-4468
  6,   1,   1, // 4469-4471
  2,   1,   1, // 4472-4474
  6,   1,   1, // 4475-4477
  2,   1,   1, // 4478-4480
  6,   1,   1, // 4481-4483
  2,   1,   1, // 4484-4486
  1,   1, // 4487-4488
  1,   1,   1, // 4489-4491
  8,   1,   1, // 4492-4494
  2,   1,   1, // 4495-4497
  1,   1,   1, // 4498-4500
  2,   1,   1, // 4501-4503
  2,   1,   1, // 4504-4506
  6,   1,   1, // 4507-4509
  8,   1,   1, // 4510-4512
  6,   1,   1, // 4513-4515
  8,   1,   1, // 4516-4518
  1,   1,   1, // 4519-4521
  1,   1,   1, // 4522-4524
  1,   1,   1, // 4525-4527
  1,   1,   1, // 4528-4530
  6,   1,   1, // 4531-4533
  6,   1,   1, // 4534-4536
  6,   1,   1, // 4537-4539
  2,   1,   1, // 4540-4542
  6,   1,   1, // 4543-4545
  1,   1,   1, // 4546-4548
  1,   1,   1, // 4549-4551
  6,   1,   1, // 4552-4554
  6,   1,   1, // 4555-4557
  6,   1,   1, // 4558-4560
  3,   1,   1, // 4561-4563
  2,   1,   1, // 4564-4566
  1,   1,   1, // 4567-4569
  6,   1,   1, // 4570-4572
  2,   1,   1, // 4573-4575
  1,   1,   1, // 4576-4578
  1,   1,   1, // 4579-4581
  5,   1,   1, // 4582-4584
  1,   1,   1, // 4585-4587
  1,   1,   1, // 4588-4590
  2,   1,   1, // 4591-4593
  2,   1,   1, // 4594-4596
  6,   1,   1, // 4597-4599
  6,   1,   1, // 4600-4602
  6,   1,   1, // 4603-4605
  1,   1,   1, // 4606-4608
  1,   1,   1, // 4609-4611
  1,   1,   1, // 4612-4614
  1,   1,   1, // 4615-4617
  1,   1,   1, // 4618-4620
  2,   1,   1, // 4621-4623
  6,   1,   1, // 4624-4626
  6,   1,   1, // 4627-4629
  1,   1,   1, // 4630-4632
  2,   1,   1, // 4633-4635
  1,   1,   1, // 4636-4638
  4,   1, // 4639-4640
  1,   1,   1, // 4641-4643
  1,   1,   1, // 4644-4646
  1,   1,   1, // 4647-4649
  3,   1,   1, // 4650-4652
  5,   1,   1, // 4653-4655
  3,   1,   1, // 4656-4658
  1,   1,   1, // 4659-4661
  1,   1,   1, // 4662-4664
  2,   1,   1, // 4665-4667
  2,   1,   1, // 4668-4670
  2,   1,   1, // 4671-4673
  3,   1,   1, // 4674-4676
  2,   1,   1, // 4677-4679
  2,   1,   1, // 4680-4682
  2,   1,   1, // 4683-4685
  1,   1,   1, // 4686-4688
  2,   1,   1, // 4689-4691
  3,   1,   1, // 4692-4694
  3,   1,   1, // 4695-4697
  2,   1,   1, // 4698-4700
  6,   1,   1, // 4701-4703
  6,   1,   1, // 4704-4706
  2,   1,   1, // 4707-4709
  6,   1,   1, // 4710-4712
  6,   1,   1, // 4713-4715
  6,   1,   1, // 4716-4718
  2,   1,   1, // 4719-4721
  2,   1,   1, // 4722-4724
  2,   1,   1, // 4725-4727
  4,   1,   1, // 4728-4730
  2,   1,   1, // 4731-4733
  3,   1,   1, // 4734-4736
  6,   1,   1, // 4737-4739
  2,   1,   1, // 4740-4742
  6,   1,   1, // 4743-4745
  3,   1,   1, // 4746-4748
  2,   1,   1, // 4749-4751
  6,   1,   1, // 4752-4754
  6,   1,   1, // 4755-4757
  2,   1,   1, // 4758-4760
  2,   1,   1, // 4761-4763
  2,   1,   1, // 4764-4766
  6,   1,   1, // 4767-4769
  2,   1,   1, // 4770-4772
  2,   1,   1, // 4773-4775
  2,   1,   1, // 4776-4778
  3,   1,   1, // 4779-4781
  3,   1,   1, // 4782-4784
  1,   1,   1, // 4785-4787
  1,   1,   1, // 4788-4790
  2,   1,   1, // 4791-4793
  2,   1,   1, // 4794-4796
  3,   1,   1, // 4797-4799
  3,   1,   1, // 4800-4802
  3,   1,   1, // 4803-4805
  2,   1,   1, // 4806-4808
  1,   1,   1, // 4809-4811
  3,   1,   1, // 4812-4814
  3,   1,   1, // 4815-4817
  3,   1,   1, // 4818-4820
  1,   1,   1, // 4821-4823
  6,   1,   1, // 4824-4826
  2,   1,   1, // 4827-4829
  2,   1,   1, // 4830-4832
  1,   1,   1, // 4833-4835
  1,   1,   1, // 4836-4838
  3,   1,   1, // 4839-4841
  6,   1,   1, // 4842-4844
  1,   1,   1, // 4845-4847
  3,   1,   1, // 4848-4850
  2,   1,   1, // 4851-4853
  2,   1,   1, // 4854-4856
  68,   1,   1, // 4857-4859
  36,   1,   1, // 4860-4862
  5,   1,   1, // 4863-4865
  33,   1,   1, // 4866-4868
  8,   1,   1, // 4869-4871
  5,   1,   1, // 4872-4874
  2,   1,   1, // 4875-4877
  7,   1,   1, // 4878-4880
  1,   1,   1, // 4881-4883
  1,   1,   1, // 4884-4886
  27,   1,   1, // 4887-4889
  5,   1,   1,   1, // 4890-4893
  44,   1,   1, // 4894-4896
  32,   1,   1, // 4897-4899
  1,   1,   1,   1, // 4900-4903
  3,   1,   1, // 4904-4906
  2,   2,   1,   1, // 4907-4910
  3,   3,   1,   1, // 4911-4914
  3,   1,   1, // 4915-4917
  2,   2,   1,   1, // 4918-4921
  3,   3,   1,   1, // 4922-4925
  3,   1,   1, // 4926-4928
  3,   3,   1,   1, // 4929-4932
  3,   3,   1,   1, // 4933-4936
  3,   1,   1, // 4937-4939
  4,   4,   1,   1, // 4940-4943
  4,   4,   1,   1, // 4944-4947
  2,   1,   1, // 4948-4950
  3,   1,   1, // 4951-4953
  4,   1,   1, // 4954-4956
  3,   1,   1, // 4957-4959
  3,   1, // 4960-4961
  6,   1, // 4962-4963
  3,   1, // 4964-4965
  4,   1, // 4966-4967
  4,   1,   1, // 4968-4970
  4,   1,   1, // 4971-4973
  4,   1,   1, // 4974-4976
  1,   1,   1, // 4977-4979
  1,   1,   1, // 4980-4982
  1,   1,   1, // 4983-4985
  1,   1,   1, // 4986-4988
  2,   1,   1,   1, // 4989-4992
  2,   1,   1,   1, // 4993-4996
  1,   1,   1, // 4997-4999
  1,   1,   1, // 5000-5002
  1,   1,   1, // 5003-5005
  2,   1,   1,   1, // 5006-5009
  1,   1, // 5010-5011
  1,   1, // 5012-5013
  6,   1,   1, // 5014-5016
  3,   1,   1, // 5017-5019
  2,   1,   1, // 5020-5022
  6,   1,   1, // 5023-5025
  3,   1,   1, // 5026-5028
  4,   1, // 5029-5030
  1,   1,   1, // 5031-5033
  1,   1, // 5034-5035
  1,   1, // 5036-5037
  8,   1,   1, // 5038-5040
  6,   1,   1, // 5041-5043
  6,   1,   1, // 5044-5046
  8,   1,   1, // 5047-5049
  1,   1,   1, // 5050-5052
  1,   1,   1, // 5053-5055
  1,   1,   1, // 5056-5058
  2,   1,   1, // 5059-5061
  1,   1,   1, // 5062-5064
  1,   1,   1, // 5065-5067
  1,   1,   1, // 5068-5070
  3,   1,   1, // 5071-5073
  3,   1, // 5074-5075
  6,   1,   1, // 5076-5078
  3,   1,   1, // 5079-5081
  4,   1, // 5082-5083
  2,   1,   1, // 5084-5086
  1,   1,   1, // 5087-5089
  1,   1,   1, // 5090-5092
  1,   1,   1, // 5093-5095
  3,   1, // 5096-5097
  3,   1, // 5098-5099
  3,   1,   1, // 5100-5102
  1,   1,   1, // 5103-5105
  5,   1,   1, // 5106-5108
  1,   1,   1, // 5109-5111
  1,   1,   1,   1, // 5112-5115
  6,   1,   1, // 5116-5118
  4,   1, // 5119-5120
  1,   1,   1, // 5121-5123
  2,   1,   1, // 5124-5126
  6,   1,   1, // 5127-5129
  2,   1,   1, // 5130-5132
  6,   1,   1, // 5133-5135
  8,   1,   1, // 5136-5138
  6,   1,   1, // 5139-5141
  2,   1,   1, // 5142-5144
  4,   1,   1, // 5145-5147
  4,   1,   1, // 5148-5150
  4,   1,   1, // 5151-5153
  4,   1,   1, // 5154-5156
  5,   1,   1, // 5157-5159
  5,   1,   1, // 5160-5162
  5,   1,   1,   1, // 5163-5166
  6,   1,   1, // 5167-5169
  5,   1,   1, // 5170-5172
  4,   1,   1, // 5173-5175
  4,   1,   1, // 5176-5178
  4,   1,   1, // 5179-5181
  5,   1,   1, // 5182-5184
  5,   1,   1, // 5185-5187
  5,   1,   1,   1, // 5188-5191
  6,   1,   1, // 5192-5194
  2,   1,   1, // 5195-5197
  3,   1,   1, // 5198-5200
  6,   1,   1, // 5201-5203
  2,   1,   1, // 5204-5206
  8,   1,   1, // 5207-5209
  6,   1,   1, // 5210-5212
  6,   1,   1, // 5213-5215
  6,   1,   1, // 5216-5218
  6,   1,   1, // 5219-5221
  6,   1,   1, // 5222-5224
  6,   1,   1, // 5225-5227
  2,   1,   1, // 5228-5230
  2,   1,   1, // 5231-5233
  3,   1,   1, // 5234-5236
  2,   1,   1, // 5237-5239
  3,   1,   1, // 5240-5242
  2,   1,   1, // 5243-5245
  3,   1,   1, // 5246-5248
  2,   1,   1, // 5249-5251
  3,   1,   1, // 5252-5254
  2,   2,   1,   1, // 5255-5258
  3,   3,   1,   1, // 5259-5262
  4,   1, // 5263-5264
  1,   1,   1, // 5265-5267
  1,   1,   1, // 5268-5270
  2,   1,   1, // 5271-5273
  3,   1,   1, // 5274-5276
  3,   1,   1, // 5277-5279
  4,   1, // 5280-5281
  3,   1,   1, // 5282-5284
  3,   1,   1, // 5285-5287
  3,   1,   1, // 5288-5290
  3,   1,   1, // 5291-5293
  4,   4,   1,   1, // 5294-5297
  4,   4,   1,   1, // 5298-5301
  3,   1,   1, // 5302-5304
  1,   1,   1, // 5305-5307
  1,   1,   1, // 5308-5310
  1,   1,   1, // 5311-5313
  2,   1,   1, // 5314-5316
  2,   1,   1, // 5317-5319
  1,   1,   1, // 5320-5322
  1,   1,   1, // 5323-5325
  2,   1,   1, // 5326-5328
  4,   1, // 5329-5330
  1,   1,   1, // 5331-5333
  4,   1, // 5334-5335
  36,   1,   1, // 5336-5338
  36,   1,   1, // 5339-5341
  68,   1,   1, // 5342-5344
  68,   1,   1, // 5345-5347
  36,   1,   1, // 5348-5350
  68,   1,   1, // 5351-5353
  36,   1,   1, // 5354-5356
  68,   1,   1, // 5357-5359
  3,   1, // 5360-5361
  1,   1,   1, // 5362-5364
  5,   1,   1, // 5365-5367
  3,   1,   1, // 5368-5370
  1,   1,   1, // 5371-5373
  1,   1,   1, // 5374-5376
  1,   1,   1, // 5377-5379
  1,   1,   1, // 5380-5382
  1,   1,   1, // 5383-5385
  6,   1, // 5386-5387
  1,   1,   1, // 5388-5390
  1,   1,   1, // 5391-5393
  33,   1,   1, // 5394-5396
  33,   1,   1, // 5397-5399
  44,   1,   1, // 5400-5402
  44,   1,   1, // 5403-5405
  44,   1,   1, // 5406-5408
  32,   1,   1, // 5409-5411
  44,   1,   1, // 5412-5414
  32,   1,   1, // 5415-5417
  32,   1,   1, // 5418-5420
  32,   1,   1, // 5421-5423
  33,   1,   1, // 5424-5426
  27,   1,   1, // 5427-5429
  27,   1,   1, // 5430-5432
  27,   1,   1, // 5433-5435
  27,   1,   1, // 5436-5438
  33,   1,   1, // 5439-5441
  3,   3,   1,   1, // 5442-5445
  3,   3,   1,   1, // 5446-5449
  2,   1,   1,   1, // 5450-5453
  2,   1,   1,   1, // 5454-5457
  2,   1,   1,   1, // 5458-5461
  2,   2,   1,   1, // 5462-5465
  3,   3,   1,   1, // 5466-5469
  2,   2,   1,   1, // 5470-5473
  3,   3,   1,   1, // 5474-5477
  3,   3,   1,   1, // 5478-5481
  3,   3,   1,   1, // 5482-5485
  6,   1,   1, // 5486-5488
  3,   1,   1, // 5489-5491
  3,   1,   1, // 5492-5494
  2,   1,   1, // 5495-5497
  1,   1,   1, // 5498-5500
  1,   1,   1, // 5501-5503
  2,   1,   1, // 5504-5506
  7,   1,   1, // 5507-5509
  2,   1,   1, // 5510-5512
  1,   1,   1, // 5513-5515
  3,   1,   1, // 5516-5518
  2,   1,   1, // 5519-5521
  1,   1,   1, // 5522-5524
  3,   1,   1, // 5525-5527
  1,   1,   1, // 5528-5530
  4,   1, // 5531-5532
  1,   1,   1, // 5533-5535
  1,   1,   1, // 5536-5538
  5,   1,   1, // 5539-5541
  6,   1,   1, // 5542-5544
  6,   1,   1, // 5545-5547
  6,   1,   1, // 5548-5550
  5,   1,   1, // 5551-5553
  5,   1,   1,   1, // 5554-5557
  6,   1,   1, // 5558-5560
  2,   1,   1, // 5561-5563
  6,   1,   1, // 5564-5566
  6,   1,   1, // 5567-5569
  6,   1,   1, // 5570-5572
  6,   1,   1, // 5573-5575
  5,   1,   1, // 5576-5578
  5,   1,   1,   1, // 5579-5582
  5,   1,   1, // 5583-5585
  3,   1,   1, // 5586-5588
  3,   1,   1, // 5589-5591
  3,   1,   1, // 5592-5594
  3,   1,   1, // 5595-5597
  6,   1,   1, // 5598-5600
  1,   1,   1, // 5601-5603
  2,   1,   1, // 5604-5606
  6,   1,   1, // 5607-5609
  6,   1,   1, // 5610-5612
  6,   1,   1, // 5613-5615
  1,   1,   1, // 5616-5618
  6,   1,   1, // 5619-5621
  2,   1,   1, // 5622-5624
  2,   1,   1, // 5625-5627
  36,   1,   1, // 5628-5630
  2,   1,   1, // 5631-5633
  2,   1,   1, // 5634-5636
  2,   1,   1, // 5637-5639
  2,   1,   1, // 5640-5642
  2,   1,   1, // 5643-5645
  2,   1,   1, // 5646-5648
  6,   1,   1, // 5649-5651
  6,   1,   1, // 5652-5654
  2,   1,   1, // 5655-5657
  6,   1,   1, // 5658-5660
  2,   1,   1, // 5661-5663
  6,   1,   1, // 5664-5666
  2,   1,   1, // 5667-5669
  1,   1, // 5670-5671
  1,   1,   1, // 5672-5674
  8,   1,   1, // 5675-5677
  2,   1,   1, // 5678-5680
  1,   1,   1, // 5681-5683
  2,   1,   1, // 5684-5686
  2,   1,   1, // 5687-5689
  6,   1,   1, // 5690-5692
  8,   1,   1, // 5693-5695
  6,   1,   1, // 5696-5698
  8,   1,   1, // 5699-5701
  1,   1,   1, // 5702-5704
  1,   1,   1, // 5705-5707
  1,   1,   1, // 5708-5710
  1,   1,   1, // 5711-5713
  6,   1,   1, // 5714-5716
  6,   1,   1, // 5717-5719
  6,   1,   1, // 5720-5722
  2,   1,   1, // 5723-5725
  6,   1,   1, // 5726-5728
  1,   1,   1, // 5729-5731
  1,   1,   1, // 5732-5734
  6,   1,   1, // 5735-5737
  6,   1,   1, // 5738-5740
  6,   1,   1, // 5741-5743
  3,   1,   1, // 5744-5746
  2,   1,   1, // 5747-5749
  1,   1,   1, // 5750-5752
  6,   1,   1, // 5753-5755
  2,   1,   1, // 5756-5758
  1,   1,   1, // 5759-5761
  1,   1,   1, // 5762-5764
  5,   1,   1, // 5765-5767
  1,   1,   1, // 5768-5770
  1,   1,   1, // 5771-5773
  2,   1,   1, // 5774-5776
  2,   1,   1, // 5777-5779
  6,   1,   1, // 5780-5782
  6,   1,   1, // 5783-5785
  6,   1,   1, // 5786-5788
  1,   1,   1, // 5789-5791
  1,   1,   1, // 5792-5794
  1,   1,   1, // 5795-5797
  1,   1,   1, // 5798-5800
  1,   1,   1, // 5801-5803
  2,   1,   1, // 5804-5806
  6,   1,   1, // 5807-5809
  6,   1,   1, // 5810-5812
  1,   1,   1, // 5813-5815
  2,   1,   1, // 5816-5818
  1,   1,   1, // 5819-5821
  4,   1, // 5822-5823
  1,   1,   1, // 5824-5826
  1,   1,   1, // 5827-5829
  1,   1,   1, // 5830-5832
  3,   1,   1, // 5833-5835
  5,   1,   1, // 5836-5838
  3,   1,   1, // 5839-5841
  1,   1,   1, // 5842-5844
  1,   1,   1, // 5845-5847
  2,   1,   1, // 5848-5850
  2,   1,   1, // 5851-5853
  2,   1,   1, // 5854-5856
  3,   1,   1, // 5857-5859
  2,   1,   1, // 5860-5862
  2,   1,   1, // 5863-5865
  2,   1,   1, // 5866-5868
  1,   1,   1, // 5869-5871
  2,   1,   1, // 5872-5874
  3,   1,   1, // 5875-5877
  3,   1,   1, // 5878-5880
  2,   1,   1, // 5881-5883
  6,   1,   1, // 5884-5886
  6,   1,   1, // 5887-5889
  2,   1,   1, // 5890-5892
  6,   1,   1, // 5893-5895
  6,   1,   1, // 5896-5898
  6,   1,   1, // 5899-5901
  2,   1,   1, // 5902-5904
  2,   1,   1, // 5905-5907
  2,   1,   1, // 5908-5910
  4,   1,   1, // 5911-5913
  2,   1,   1, // 5914-5916
  3,   1,   1, // 5917-5919
  6,   1,   1, // 5920-5922
  2,   1,   1, // 5923-5925
  6,   1,   1, // 5926-5928
  3,   1,   1, // 5929-5931
  2,   1,   1, // 5932-5934
  6,   1,   1, // 5935-5937
  6,   1,   1, // 5938-5940
  2,   1,   1, // 5941-5943
  2,   1,   1, // 5944-5946
  2,   1,   1, // 5947-5949
  6,   1,   1, // 5950-5952
  2,   1,   1, // 5953-5955
  2,   1,   1, // 5956-5958
  2,   1,   1, // 5959-5961
  3,   1,   1, // 5962-5964
  3,   1,   1, // 5965-5967
  1,   1,   1, // 5968-5970
  1,   1,   1, // 5971-5973
  1,   1,   1, // 5974-5976
  2,   1,   1, // 5977-5979
  2,   1,   1, // 5980-5982
  3,   1,   1, // 5983-5985
  3,   1,   1, // 5986-5988
  3,   1,   1, // 5989-5991
  2,   1,   1, // 5992-5994
  1,   1,   1, // 5995-5997
  3,   1,   1, // 5998-6000
  3,   1,   1, // 6001-6003
  3,   1,   1, // 6004-6006
  1,   1,   1, // 6007-6009
  6,   1,   1, // 6010-6012
  2,   1,   1, // 6013-6015
  2,   1,   1, // 6016-6018
  0 // End operand cycles
};
extern const unsigned PPCForwardingPaths[] = {
 0, // No itinerary
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 1-3
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 4-6
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 7-8
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 9-11
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 12-14
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 15-16
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 17-19
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 20-22
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 23-25
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 26-28
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 29-31
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 32-34
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 35-37
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 38-40
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 41-44
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 45-47
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::NoBypass, // 48-51
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 52-54
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0,  0, // 55-58
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0,  0, // 59-62
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 63-65
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 66-69
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 70-73
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 74-76
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 77-79
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 80-82
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 83-85
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 86-88
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 89-91
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 92-93
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 94-95
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 96-98
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 99-100
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 101-102
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 103-104
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 105-106
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 107-109
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 110-111
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 112-113
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 114-116
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 117-119
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 120-122
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 123-124
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 125-127
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 128-130
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 131-133
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0,  0, // 134-137
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0,  0, // 138-141
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 142-144
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 145-147
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 148-150
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 151-154
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 155-156
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 157-158
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 159-161
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 162-164
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 165-167
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 168-169
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 170-172
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 173-175
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 176-178
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 179-181
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 182-184
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 185-187
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 188-190
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 191-193
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 194-195
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 196-197
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 198-200
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 201-203
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 204-206
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 207-209
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 210-212
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 213-215
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 216-218
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::NoBypass, // 219-222
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 223-224
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 225-227
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 228-230
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 231-233
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 234-236
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 237-239
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 240-242
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 243-245
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 246-248
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 249-252
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 253-255
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 256-258
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 259-261
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 262-264
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 265-267
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 268-271
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 272-274
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 275-277
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 278-280
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 281-283
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 284-286
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 287-288
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 289-291
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 292-294
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 295-297
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 298-300
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 301-303
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0,  0, // 304-307
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0,  0, // 308-311
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 312-313
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 314-316
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 317-319
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 320-322
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 323-324
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 325-327
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 328-330
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 331-333
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 334-336
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 337-339
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 340-342
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 343-345
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 346-348
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 349-351
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 352-354
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 355-357
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 358-360
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 361-363
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 364-366
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 367-369
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 370-371
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 372-374
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 375-376
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 377-378
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 379-380
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 381-382
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 383-384
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 385-387
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 388-390
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 391-393
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 394-396
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 397-399
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 400-402
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 403-405
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 406-408
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 409-411
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 412-414
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 415-417
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 418-420
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 421-423
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 424-426
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 427-428
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 429-431
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 432-434
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 435-437
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 438-440
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 441-443
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 444-446
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 447-449
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 450-452
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 453-456
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 457-460
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 461-464
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0,  0, // 465-468
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0,  0, // 469-472
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0,  0, // 473-476
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0,  0, // 477-480
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 481-484
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 485-488
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 489-490
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 491-492
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 493-495
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 496-498
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 499-501
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 502-504
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 505-507
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 508-509
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 510-511
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 512-514
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 515-517
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 518-520
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 521-523
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 524-525
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 526-527
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 528-529
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 530-531
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 532-534
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 535-536
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 537-539
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 540-541
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 542-544
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 545-547
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 548-551
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 552-554
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 555-558
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 559-561
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 562-563
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 564-565
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 566-567
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 568-569
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 570-572
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 573-575
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 576-578
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 579-581
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 582-583
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 584-586
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 587-589
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 590-592
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 593-595
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 596-598
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 599-601
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 602-604
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 605-607
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 608-610
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 611-612
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 613-615
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 616-618
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 619-621
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 622-624
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 625-627
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 628-630
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 631-633
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 634-636
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 637-639
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 640-642
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 643-645
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 646-648
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 649-651
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 652-653
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 654-656
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 657-659
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 660-662
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 663-665
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 666-667
PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, PPC440ItinerariesBypass::P440_FPR_Bypass, // 668-670
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 671-672
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 673-675
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 676-678
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 679-681
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 682-684
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 685-687
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 688-690
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 691-692
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 693-695
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 696-698
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 699-700
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 701-703
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 704-706
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 707-709
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 710-712
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 713-714
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 715-716
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 717-718
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 719-721
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 722-723
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 724-726
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 727-729
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 730-732
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 733-735
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 736-738
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 739-741
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 742-744
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 745-747
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 748-749
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 750-751
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 752-754
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass,  0, // 755-757
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 758-759
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 760-761
PPC440ItinerariesBypass::NoBypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 762-764
PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, PPC440ItinerariesBypass::P440_GPR_Bypass, // 765-767
 0, // 768
 0,  0,  0, // 769-771
 0,  0,  0, // 772-774
 0,  0,  0, // 775-777
 0,  0,  0, // 778-780
 0,  0,  0, // 781-783
 0,  0,  0, // 784-786
 0,  0,  0, // 787-789
 0,  0,  0, // 790-792
 0,  0,  0, // 793-795
 0,  0,  0, // 796-798
 0,  0,  0, // 799-801
 0,  0,  0, // 802-804
 0,  0,  0, // 805-807
 0,  0,  0, // 808-810
 0,  0,  0, // 811-813
 0,  0,  0, // 814-816
 0,  0,  0,  0, // 817-820
 0,  0,  0, // 821-823
 0,  0,  0, // 824-826
 0,  0,  0, // 827-829
 0,  0,  0,  0, // 830-833
 0, // 834
 0,  0,  0, // 835-837
 0,  0,  0,  0, // 838-841
 0,  0,  0,  0, // 842-845
 0,  0,  0, // 846-848
 0,  0,  0, // 849-851
 0,  0,  0, // 852-854
 0,  0,  0,  0, // 855-858
 0,  0,  0,  0, // 859-862
 0,  0,  0, // 863-865
 0,  0,  0,  0, // 866-869
 0,  0,  0,  0, // 870-873
 0,  0,  0, // 874-876
 0,  0,  0, // 877-879
 0,  0, // 880-881
 0,  0, // 882-883
 0,  0, // 884-885
 0,  0, // 886-887
 0,  0, // 888-889
 0,  0, // 890-891
 0,  0, // 892-893
 0,  0,  0, // 894-896
 0,  0,  0, // 897-899
 0,  0,  0, // 900-902
 0, // 903
 0,  0,  0, // 904-906
 0,  0,  0, // 907-909
 0,  0,  0, // 910-912
 0,  0,  0, // 913-915
 0,  0,  0,  0, // 916-919
 0,  0,  0,  0, // 920-923
 0,  0,  0, // 924-926
 0,  0,  0, // 927-929
 0,  0,  0, // 930-932
 0,  0,  0,  0, // 933-936
 0,  0, // 937-938
 0,  0, // 939-940
 0,  0, // 941-942
 0,  0,  0, // 943-945
 0,  0, // 946-947
 0,  0, // 948-949
 0,  0,  0, // 950-952
 0,  0,  0, // 953-955
 0,  0,  0, // 956-958
 0,  0,  0, // 959-961
 0,  0,  0, // 962-964
 0,  0,  0, // 965-967
 0,  0,  0, // 968-970
 0,  0,  0, // 971-973
 0,  0,  0, // 974-976
 0,  0,  0, // 977-979
 0,  0,  0, // 980-982
 0,  0, // 983-984
 0,  0,  0, // 985-987
 0,  0,  0, // 988-990
 0,  0,  0, // 991-993
 0,  0,  0, // 994-996
 0,  0, // 997-998
 0,  0,  0, // 999-1001
 0,  0,  0, // 1002-1004
 0,  0,  0, // 1005-1007
 0,  0,  0, // 1008-1010
 0,  0,  0, // 1011-1013
 0,  0,  0,  0, // 1014-1017
 0,  0, // 1018-1019
 0,  0,  0, // 1020-1022
 0,  0,  0, // 1023-1025
 0,  0,  0, // 1026-1028
 0,  0,  0, // 1029-1031
 0,  0,  0, // 1032-1034
 0,  0,  0, // 1035-1037
 0,  0,  0, // 1038-1040
 0,  0,  0, // 1041-1043
 0,  0,  0,  0, // 1044-1047
 0,  0,  0, // 1048-1050
 0,  0,  0, // 1051-1053
 0,  0,  0, // 1054-1056
 0,  0,  0, // 1057-1059
 0,  0,  0, // 1060-1062
 0,  0,  0,  0, // 1063-1066
 0,  0,  0, // 1067-1069
 0,  0,  0, // 1070-1072
 0,  0,  0, // 1073-1075
 0,  0,  0, // 1076-1078
 0,  0,  0, // 1079-1081
 0,  0,  0, // 1082-1084
 0,  0,  0, // 1085-1087
 0,  0,  0, // 1088-1090
 0,  0,  0, // 1091-1093
 0, // 1094
 0, // 1095
 0,  0,  0, // 1096-1098
 0,  0,  0,  0, // 1099-1102
 0,  0,  0,  0, // 1103-1106
 0,  0, // 1107-1108
 0,  0,  0, // 1109-1111
 0,  0,  0, // 1112-1114
 0,  0,  0, // 1115-1117
 0,  0, // 1118-1119
 0,  0,  0, // 1120-1122
 0,  0,  0, // 1123-1125
 0,  0,  0, // 1126-1128
 0,  0,  0, // 1129-1131
 0,  0,  0,  0, // 1132-1135
 0,  0,  0,  0, // 1136-1139
 0,  0,  0, // 1140-1142
 0,  0,  0, // 1143-1145
 0,  0,  0, // 1146-1148
 0,  0,  0, // 1149-1151
 0,  0,  0, // 1152-1154
 0,  0,  0, // 1155-1157
 0,  0,  0, // 1158-1160
 0,  0,  0, // 1161-1163
 0,  0, // 1164-1165
 0,  0,  0, // 1166-1168
 0,  0, // 1169-1170
 0,  0, // 1171-1172
 0,  0, // 1173-1174
 0,  0, // 1175-1176
 0,  0, // 1177-1178
 0,  0,  0, // 1179-1181
 0,  0,  0, // 1182-1184
 0,  0,  0, // 1185-1187
 0,  0,  0, // 1188-1190
 0,  0,  0, // 1191-1193
 0,  0,  0, // 1194-1196
 0,  0,  0, // 1197-1199
 0,  0,  0, // 1200-1202
 0,  0,  0, // 1203-1205
 0,  0,  0, // 1206-1208
 0,  0,  0, // 1209-1211
 0,  0,  0, // 1212-1214
 0,  0,  0, // 1215-1217
 0,  0,  0, // 1218-1220
 0,  0,  0, // 1221-1223
 0,  0,  0, // 1224-1226
 0,  0,  0, // 1227-1229
 0,  0, // 1230-1231
 0,  0,  0, // 1232-1234
 0,  0,  0, // 1235-1237
 0,  0,  0, // 1238-1240
 0,  0,  0, // 1241-1243
 0,  0,  0, // 1244-1246
 0,  0,  0, // 1247-1249
 0,  0,  0, // 1250-1252
 0,  0,  0, // 1253-1255
 0,  0,  0, // 1256-1258
 0,  0,  0, // 1259-1261
 0,  0,  0, // 1262-1264
 0,  0,  0, // 1265-1267
 0,  0,  0, // 1268-1270
 0,  0,  0, // 1271-1273
 0,  0,  0, // 1274-1276
 0,  0,  0, // 1277-1279
 0,  0,  0, // 1280-1282
 0,  0,  0, // 1283-1285
 0,  0,  0,  0, // 1286-1289
 0,  0,  0,  0, // 1290-1293
 0,  0,  0,  0, // 1294-1297
 0,  0,  0,  0, // 1298-1301
 0,  0,  0,  0, // 1302-1305
 0,  0,  0,  0, // 1306-1309
 0,  0,  0,  0, // 1310-1313
 0,  0,  0, // 1314-1316
 0,  0,  0, // 1317-1319
 0,  0,  0,  0, // 1320-1323
 0,  0,  0,  0, // 1324-1327
 0,  0,  0, // 1328-1330
 0,  0,  0, // 1331-1333
 0,  0,  0, // 1334-1336
 0,  0,  0, // 1337-1339
 0,  0,  0, // 1340-1342
 0,  0,  0, // 1343-1345
 0,  0,  0, // 1346-1348
 0,  0,  0, // 1349-1351
 0, // 1352
 0,  0,  0, // 1353-1355
 0,  0,  0, // 1356-1358
 0,  0,  0, // 1359-1361
 0,  0,  0, // 1362-1364
 0,  0, // 1365-1366
 0,  0, // 1367-1368
 0,  0,  0, // 1369-1371
 0,  0, // 1372-1373
 0,  0,  0, // 1374-1376
 0, // 1377
 0,  0,  0, // 1378-1380
 0,  0,  0, // 1381-1383
 0,  0,  0, // 1384-1386
 0,  0,  0,  0, // 1387-1390
 0,  0,  0, // 1391-1393
 0,  0,  0,  0, // 1394-1397
 0,  0,  0, // 1398-1400
 0,  0,  0, // 1401-1403
 0,  0,  0, // 1404-1406
 0,  0,  0, // 1407-1409
 0,  0,  0, // 1410-1412
 0,  0,  0, // 1413-1415
 0,  0,  0, // 1416-1418
 0,  0,  0, // 1419-1421
 0,  0,  0, // 1422-1424
 0,  0, // 1425-1426
 0,  0,  0, // 1427-1429
 0,  0,  0, // 1430-1432
 0,  0,  0, // 1433-1435
 0,  0,  0, // 1436-1438
 0,  0,  0, // 1439-1441
 0,  0,  0, // 1442-1444
 0,  0,  0, // 1445-1447
 0,  0,  0, // 1448-1450
 0,  0,  0, // 1451-1453
 0,  0,  0, // 1454-1456
 0,  0,  0, // 1457-1459
 0,  0,  0, // 1460-1462
 0,  0,  0, // 1463-1465
 0,  0, // 1466-1467
 0,  0,  0, // 1468-1470
 0,  0,  0, // 1471-1473
 0,  0,  0, // 1474-1476
 0,  0,  0, // 1477-1479
 0,  0,  0, // 1480-1482
 0,  0,  0, // 1483-1485
 0,  0,  0, // 1486-1488
 0,  0,  0, // 1489-1491
 0,  0,  0, // 1492-1494
 0,  0,  0, // 1495-1497
 0,  0,  0, // 1498-1500
 0,  0,  0, // 1501-1503
 0,  0,  0, // 1504-1506
 0,  0,  0, // 1507-1509
 0,  0, // 1510-1511
 0,  0,  0, // 1512-1514
 0,  0,  0, // 1515-1517
 0,  0,  0, // 1518-1520
 0,  0,  0, // 1521-1523
 0,  0,  0, // 1524-1526
 0,  0,  0, // 1527-1529
 0,  0,  0, // 1530-1532
 0,  0,  0, // 1533-1535
 0,  0,  0, // 1536-1538
 0,  0,  0, // 1539-1541
 0,  0,  0, // 1542-1544
 0,  0,  0, // 1545-1547
 0,  0,  0, // 1548-1550
 0,  0,  0, // 1551-1553
 0,  0,  0, // 1554-1556
 0,  0,  0, // 1557-1559
 0,  0,  0, // 1560-1562
 0,  0, // 1563-1564
 0,  0,  0, // 1565-1567
 0,  0,  0, // 1568-1570
 0,  0,  0, // 1571-1573
 0,  0,  0, // 1574-1576
 0,  0,  0, // 1577-1579
 0,  0,  0, // 1580-1582
 0,  0,  0, // 1583-1585
 0,  0,  0, // 1586-1588
 0,  0,  0, // 1589-1591
 0,  0,  0, // 1592-1594
 0,  0,  0, // 1595-1597
 0,  0,  0, // 1598-1600
 0,  0,  0, // 1601-1603
 0,  0,  0, // 1604-1606
 0,  0,  0, // 1607-1609
 0,  0,  0, // 1610-1612
 0,  0,  0, // 1613-1615
 0,  0,  0, // 1616-1618
 0,  0,  0, // 1619-1621
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1622-1624
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1625-1627
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1628-1629
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1630-1632
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_CR_Bypass, // 1633-1635
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1636-1637
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1638-1639
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1640-1642
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 1643-1645
PPCE500ItinerariesBypass::E500_DivBypass,  0,  0, // 1646-1648
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 1649-1651
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 1652-1654
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 1655-1657
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1658-1659
PPCE500ItinerariesBypass::E500_DivBypass,  0,  0, // 1660-1662
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1663-1664
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_CR_Bypass, // 1665-1668
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1669-1671
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1672-1673
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1674-1675
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1676-1677
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1678-1679
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1680-1681
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1682-1683
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_CR_Bypass, // 1684-1685
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass,  0, // 1686-1688
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_CR_Bypass, // 1689-1690
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_CR_Bypass, // 1691-1692
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1693-1694
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_CR_Bypass, // 1695-1696
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1697-1698
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1699-1700
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1701-1702
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1703-1704
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1705-1706
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1707-1708
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1709-1710
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1711-1713
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1714-1716
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1717-1719
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1720-1722
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1723-1725
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1726-1727
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1728-1729
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1730-1731
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1732-1733
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 1734-1736
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1737-1738
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1739-1741
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1742-1743
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1744-1746
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 1747-1749
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1750-1752
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1753-1755
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1756-1758
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_CR_Bypass, // 1759-1760
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass,  0, // 1761-1763
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1764-1765
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1766-1767
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1768-1769
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1770-1772
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_CR_Bypass, // 1773-1774
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass,  0, // 1775-1777
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_CR_Bypass, // 1778-1780
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1781-1783
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1784-1786
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_CR_Bypass, // 1787-1790
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1791-1792
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1793-1794
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1795-1796
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 1797-1799
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 1800-1802
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1803-1805
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1806-1808
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1809-1811
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1812-1814
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1815-1817
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1818-1819
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 1820-1822
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1823-1824
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1825-1826
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1827-1828
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1829-1830
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1831-1832
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1833-1835
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1836-1837
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1838-1839
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1840-1841
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1842-1843
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1844-1845
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1846-1847
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1848-1849
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1850-1851
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1852-1853
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1854-1855
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1856-1857
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1858-1859
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1860-1861
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1862-1863
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1864-1865
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1866-1868
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1869-1870
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1871-1872
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1873-1874
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_CR_Bypass, // 1875-1876
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1877-1878
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1879-1880
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1881-1882
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1883-1885
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1886-1888
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1889-1891
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1892-1894
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass,  0, // 1895-1897
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1898-1900
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_CR_Bypass, // 1901-1902
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1903-1905
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1906-1908
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1909-1911
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_CR_Bypass, // 1912-1913
PPCE500ItinerariesBypass::E500_DivBypass,  0,  0, // 1914-1916
PPCE500ItinerariesBypass::E500_DivBypass,  0,  0, // 1917-1919
PPCE500ItinerariesBypass::E500_DivBypass,  0,  0, // 1920-1922
PPCE500ItinerariesBypass::E500_DivBypass,  0,  0, // 1923-1925
PPCE500ItinerariesBypass::E500_DivBypass,  0,  0, // 1926-1928
PPCE500ItinerariesBypass::E500_DivBypass,  0,  0, // 1929-1931
PPCE500ItinerariesBypass::E500_DivBypass,  0,  0, // 1932-1934
PPCE500ItinerariesBypass::E500_DivBypass,  0,  0, // 1935-1937
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1938-1939
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1940-1941
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1942-1943
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1944-1945
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1946-1947
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1948-1949
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1950-1951
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1952-1953
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1954-1956
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 1957-1959
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 1960-1962
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1963-1964
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1965-1966
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1967-1968
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1969-1970
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1971-1972
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1973-1974
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1975-1976
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_CR_Bypass, // 1977-1978
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1979-1980
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1981-1983
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1984-1985
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1986-1988
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1989-1990
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 1991-1993
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1994-1995
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1996-1997
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 1998-1999
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2000-2001
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2002-2004
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2005-2007
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2008-2010
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2011-2013
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2014-2016
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2017-2019
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2020-2022
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2023-2025
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2026-2028
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2029-2031
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2032-2034
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2035-2037
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2038-2040
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2041-2043
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2044-2045
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2046-2047
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2048-2050
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2051-2053
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2054-2056
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2057-2059
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2060-2062
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2063-2065
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2066-2068
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2069-2071
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_CR_Bypass, // 2072-2074
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2075-2076
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_CR_Bypass, // 2077-2078
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2079-2081
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2082-2084
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2085-2087
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2088-2090
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2091-2093
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2094-2096
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2097-2099
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2100-2102
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2103-2105
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2106-2108
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2109-2111
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2112-2114
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2115-2117
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2118-2120
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2121-2122
PPCE500ItinerariesBypass::E500_CR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2123-2124
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2125-2127
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2128-2130
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2131-2133
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2134-2135
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2136-2137
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2138-2140
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2141-2143
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2144-2146
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2147-2148
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2149-2150
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2151-2152
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2153-2154
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2155-2156
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2157-2159
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2160-2161
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2162-2163
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2164-2165
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2166-2168
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2169-2171
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2172-2174
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2175-2177
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2178-2180
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2181-2183
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2184-2186
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2187-2189
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2190-2192
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2193-2195
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2196-2198
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2199-2201
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2202-2204
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2205-2207
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2208-2209
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2210-2211
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2212-2213
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2214-2215
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2216-2217
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2218-2219
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2220-2221
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2222-2223
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2224-2225
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2226-2227
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2228-2229
PPCE500ItinerariesBypass::NoBypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2230-2231
PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, PPCE500ItinerariesBypass::E500_GPR_Bypass, // 2232-2234
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2235-2237
PPCE500ItinerariesBypass::NoBypass,  0,  0, // 2238-2240
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2241-2243
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2244-2246
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2247-2248
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2249-2251
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_CR_Bypass, // 2252-2254
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2255-2256
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2257-2258
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2259-2261
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2262-2264
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2265-2267
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2268-2270
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2271-2273
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2274-2275
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2276-2278
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2279-2282
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2283-2284
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_CR_Bypass, // 2285-2288
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2289-2291
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2292-2293
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2294-2295
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2296-2298
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2299-2301
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2302-2304
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2305-2306
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2307-2308
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2309-2310
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2311-2312
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_CR_Bypass, // 2313-2314
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass,  0, // 2315-2317
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_CR_Bypass, // 2318-2319
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_CR_Bypass, // 2320-2321
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2322
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2323-2324
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_CR_Bypass, // 2325-2326
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2327-2328
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2329-2330
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2331-2332
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2333-2334
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::NoBypass, // 2335-2337
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2338-2339
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2340-2341
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2342-2343
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2344-2346
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2347-2349
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2350-2352
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2353-2355
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2356-2358
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2359-2360
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2361-2362
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2363-2364
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2365-2367
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2368-2370
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2371-2372
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2373-2374
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::NoBypass, // 2375-2377
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2378
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2379-2381
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2382-2383
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2384-2386
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2387-2389
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2390-2392
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2393-2395
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2396-2398
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2399-2401
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_CR_Bypass, // 2402-2403
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass,  0, // 2404-2406
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2407-2408
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2409-2410
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2411-2412
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2413-2415
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_CR_Bypass, // 2416-2417
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass,  0, // 2418-2420
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_CR_Bypass, // 2421-2423
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2424-2426
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2427-2429
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2430-2432
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_CR_Bypass, // 2433-2436
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2437-2438
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2439-2440
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2441-2442
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2443-2445
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2446-2448
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2449-2451
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2452-2454
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2455-2457
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2458-2460
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2461-2464
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2465-2467
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2468-2470
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2471-2473
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2474-2476
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2477-2479
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2480-2483
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2484-2485
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2486-2488
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2489-2490
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2491-2492
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2493-2495
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2496-2497
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2498-2499
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2500-2501
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2502-2504
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2505-2506
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2507-2509
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2510-2511
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2512-2513
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2514-2515
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2516-2517
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2518-2519
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2520-2521
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2522-2524
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2525-2527
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2528-2530
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2531-2533
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2534-2535
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2536-2537
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2538-2540
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2541-2543
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2544-2545
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2546-2547
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2548-2549
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2550-2551
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2552-2554
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2555-2556
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2557-2558
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2559-2561
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2562-2563
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2564-2565
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2566-2567
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_CR_Bypass, // 2568-2569
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2570-2571
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2572-2573
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2574-2575
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2576-2578
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2579-2581
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2582-2584
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2585-2587
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass,  0, // 2588-2590
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2591-2593
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2594-2596
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_CR_Bypass, // 2597-2598
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2599
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::NoBypass, // 2600-2602
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2603-2605
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2606-2608
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2609-2611
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2612
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_CR_Bypass, // 2613-2614
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2615-2617
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2618-2620
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2621-2623
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2624-2626
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2627-2629
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2630-2632
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2633-2635
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2636-2638
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2639-2641
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2642-2644
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2645-2647
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2648-2649
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2650-2651
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2652-2653
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2654-2655
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2656-2658
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2659-2661
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2662-2663
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2664-2665
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2666-2667
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2668-2669
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2670-2672
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2673-2674
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2675-2676
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2677-2678
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2679-2680
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2681-2682
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2683-2685
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2686-2688
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2689-2690
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2691-2692
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_CR_Bypass, // 2693-2694
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2695-2696
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2697-2699
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2700-2701
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2702-2704
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2705-2706
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2707-2709
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2710-2712
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2713-2716
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2717-2719
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2720-2723
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2724-2726
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2727-2728
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2729-2730
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2731-2732
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2733-2734
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2735-2737
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2738-2740
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2741-2743
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2744-2745
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2746-2747
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2748-2750
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2751-2753
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2754-2756
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2757-2759
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2760-2762
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2763-2765
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2766-2768
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_CR_Bypass, // 2769-2771
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2772-2773
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_CR_Bypass, // 2774-2775
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2776-2778
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2779-2781
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2782-2784
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2785-2787
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2788-2790
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2791-2793
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2794-2796
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2797-2799
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2800-2802
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2803-2805
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2806-2808
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2809-2810
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2811
PPCE500mcItinerariesBypass::E500mc_CR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2812-2813
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2814-2816
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::NoBypass, // 2817-2819
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2820-2822
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2823-2825
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2826-2827
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2828-2830
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2831-2832
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2833-2835
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2836-2838
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2839
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, // 2840
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2841-2842
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2843-2845
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2846-2847
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2848-2849
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2850-2851
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2852-2853
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2854-2856
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2857-2858
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2859-2861
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2862-2864
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2865-2866
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2867-2868
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2869-2870
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2871-2872
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2873-2874
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2875-2877
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2878-2879
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2880-2882
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2883-2884
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2885-2886
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2887-2889
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2890-2892
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2893-2894
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2895-2896
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2897-2898
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2899-2900
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2901-2902
PPCE500mcItinerariesBypass::NoBypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2903-2904
PPCE500mcItinerariesBypass::E500mc_FPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2905-2907
PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, PPCE500mcItinerariesBypass::E500mc_GPR_Bypass, // 2908-2910
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2911-2913
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2914-2916
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2917-2918
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2919-2921
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_CR_Bypass, // 2922-2924
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2925-2926
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2927-2928
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2929-2930
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2931-2933
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2934-2936
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 2937-2939
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 2940-2942
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 2943-2945
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 2946-2948
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2949-2950
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2951-2953
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 2954-2956
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 2957-2960
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2961-2962
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_CR_Bypass, // 2963-2966
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2967-2969
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2970-2971
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2972-2973
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2974-2975
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2976-2977
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2978-2979
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2980-2982
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2983-2985
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2986-2988
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2989-2990
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2991-2992
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2993-2994
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2995-2996
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 2997-2999
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_CR_Bypass, // 3000-3001
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass,  0, // 3002-3004
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_CR_Bypass, // 3005-3006
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3007
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3008
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_CR_Bypass, // 3009-3010
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3011-3012
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3013-3014
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3015
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::NoBypass, // 3016-3018
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3019-3020
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3021
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3022-3024
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3025-3027
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3028-3030
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3031-3033
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3034-3036
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3037-3039
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3040-3041
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3042-3043
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3044-3045
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3046-3047
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3048-3049
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3050-3052
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3053-3055
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3056-3057
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3058
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::NoBypass, // 3059-3061
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3062
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3063-3065
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3066-3067
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3068-3070
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3071-3073
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3074-3076
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3077-3079
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3080-3082
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3083-3085
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3086-3088
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3089-3091
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_CR_Bypass, // 3092-3093
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass,  0, // 3094-3096
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3097-3098
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3099
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3100-3101
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3102-3104
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3105-3107
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3108-3110
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_CR_Bypass, // 3111-3112
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass,  0, // 3113-3115
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_CR_Bypass, // 3116-3118
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3119-3121
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3122-3124
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3125-3127
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_CR_Bypass, // 3128-3131
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3132
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3133-3134
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3135-3136
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3137-3139
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3140-3142
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3143-3145
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3146-3148
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3149-3151
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3152-3154
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3155-3157
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3158-3161
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3162-3164
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3165-3167
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3168-3170
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3171-3173
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3174-3176
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3177-3179
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3180-3183
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3184-3185
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3186-3188
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3189-3190
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3191-3192
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3193-3195
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3196-3197
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3198-3199
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3200-3201
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3202-3204
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3205-3206
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3207-3208
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3209-3210
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3211-3213
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3214-3215
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3216-3217
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3218
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3219-3220
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3221-3222
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3223-3224
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3225-3226
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3227
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3228-3230
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3231-3233
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3234-3236
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3237-3239
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3240-3241
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3242-3243
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3244-3246
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3247-3249
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3250-3251
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3252-3253
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3254-3255
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3256-3257
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3258-3259
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3260-3262
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3263-3264
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3265
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3266-3268
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3269-3270
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3271
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3272-3273
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3274
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3275-3276
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3277
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3278-3280
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3281-3283
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3284-3286
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3287-3289
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3290-3292
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3293-3295
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3296-3298
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3299-3301
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass,  0, // 3302-3304
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3305-3307
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3308-3310
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_CR_Bypass, // 3311-3312
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3313
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::NoBypass, // 3314-3316
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3317-3319
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3320-3322
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3323-3325
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3326-3328
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3329-3331
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3332
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_CR_Bypass, // 3333-3334
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3335-3337
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3338-3340
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3341-3343
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3344-3346
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3347-3349
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3350-3352
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3353-3355
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3356-3358
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3359-3361
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3362-3364
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3365-3367
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3368-3370
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3371-3373
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3374-3375
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3376-3377
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3378-3379
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3380-3381
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3382-3383
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3384-3385
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3386-3388
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3389-3391
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3392-3393
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3394-3395
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3396-3397
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3398-3399
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3400-3402
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3403-3404
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3405-3406
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3407-3408
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3409-3410
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3411-3412
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3413-3415
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3416-3418
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3419
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3420
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3421-3423
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3424-3425
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3426-3428
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3429-3430
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3431-3433
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3434-3436
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3437-3440
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3441-3443
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3444-3447
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3448-3450
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3451-3452
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3453-3454
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3455-3456
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3457-3458
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3459-3461
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3462-3464
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3465-3467
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3468-3469
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3470-3471
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3472-3474
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3475-3477
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3478-3480
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3481-3483
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3484-3486
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3487-3489
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3490-3492
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3493-3495
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3496-3498
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3499-3501
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3502-3504
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_CR_Bypass, // 3505-3507
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3508-3509
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3510
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3511-3513
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3514-3516
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3517-3519
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3520-3522
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3523-3525
PPCE5500ItinerariesBypass::E5500_CR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3526-3528
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3529-3531
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3532-3534
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3535-3537
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3538-3540
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3541-3543
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3544-3546
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3547-3548
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3549-3551
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3552
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3553
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3554-3556
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::NoBypass, // 3557-3559
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3560-3562
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3563-3565
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3566-3567
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3568-3570
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3571-3572
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3573-3575
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3576-3578
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3579
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, // 3580
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3581-3582
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3583-3584
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3585-3587
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3588-3589
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3590-3591
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3592-3593
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3594-3595
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3596-3598
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3599-3600
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3601-3603
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3604-3606
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3607-3608
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3609-3611
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3612-3613
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3614-3615
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3616-3617
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3618-3620
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3621-3622
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3623-3624
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3625-3627
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3628-3629
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3630-3631
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3632-3634
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3635-3637
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3638-3639
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3640-3641
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3642-3643
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3644-3645
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3646-3647
PPCE5500ItinerariesBypass::NoBypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3648-3649
PPCE5500ItinerariesBypass::E5500_FPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3650-3652
PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, PPCE5500ItinerariesBypass::E5500_GPR_Bypass, // 3653-3655
 0,  0,  0, // 3656-3658
 0,  0,  0, // 3659-3661
 0,  0,  0, // 3662-3664
 0,  0,  0, // 3665-3667
 0,  0,  0, // 3668-3670
 0,  0,  0, // 3671-3673
 0,  0,  0, // 3674-3676
 0,  0,  0, // 3677-3679
 0,  0,  0, // 3680-3682
 0,  0,  0, // 3683-3685
 0,  0,  0, // 3686-3688
 0,  0,  0, // 3689-3691
 0,  0,  0, // 3692-3694
 0,  0,  0, // 3695-3697
 0,  0,  0, // 3698-3700
 0,  0,  0, // 3701-3703
 0,  0,  0, // 3704-3706
 0,  0,  0, // 3707-3709
 0,  0,  0, // 3710-3712
 0,  0,  0,  0, // 3713-3716
 0,  0,  0, // 3717-3719
 0,  0,  0, // 3720-3722
 0,  0,  0,  0, // 3723-3726
 0,  0,  0, // 3727-3729
 0,  0,  0,  0, // 3730-3733
 0,  0,  0,  0, // 3734-3737
 0,  0,  0, // 3738-3740
 0,  0,  0,  0, // 3741-3744
 0,  0,  0,  0, // 3745-3748
 0,  0,  0, // 3749-3751
 0,  0,  0,  0, // 3752-3755
 0,  0,  0,  0, // 3756-3759
 0,  0,  0, // 3760-3762
 0,  0,  0,  0, // 3763-3766
 0,  0,  0,  0, // 3767-3770
 0,  0,  0, // 3771-3773
 0,  0,  0, // 3774-3776
 0,  0,  0, // 3777-3779
 0,  0,  0, // 3780-3782
 0,  0, // 3783-3784
 0,  0, // 3785-3786
 0,  0, // 3787-3788
 0,  0, // 3789-3790
 0,  0,  0, // 3791-3793
 0,  0,  0, // 3794-3796
 0,  0,  0, // 3797-3799
 0,  0,  0, // 3800-3802
 0,  0,  0, // 3803-3805
 0,  0,  0, // 3806-3808
 0,  0,  0, // 3809-3811
 0,  0,  0,  0, // 3812-3815
 0,  0,  0,  0, // 3816-3819
 0,  0,  0, // 3820-3822
 0,  0,  0, // 3823-3825
 0,  0,  0,  0, // 3826-3829
 0,  0, // 3830-3831
 0,  0, // 3832-3833
 0,  0,  0, // 3834-3836
 0,  0,  0, // 3837-3839
 0,  0,  0, // 3840-3842
 0,  0,  0, // 3843-3845
 0,  0,  0, // 3846-3848
 0,  0, // 3849-3850
 0,  0,  0, // 3851-3853
 0,  0, // 3854-3855
 0,  0, // 3856-3857
 0,  0,  0, // 3858-3860
 0,  0,  0, // 3861-3863
 0,  0,  0, // 3864-3866
 0,  0,  0, // 3867-3869
 0,  0,  0, // 3870-3872
 0,  0,  0, // 3873-3875
 0,  0,  0, // 3876-3878
 0,  0,  0, // 3879-3881
 0,  0,  0, // 3882-3884
 0,  0,  0, // 3885-3887
 0,  0,  0, // 3888-3890
 0,  0,  0, // 3891-3893
 0,  0, // 3894-3895
 0,  0,  0, // 3896-3898
 0,  0,  0, // 3899-3901
 0,  0, // 3902-3903
 0,  0,  0, // 3904-3906
 0,  0,  0, // 3907-3909
 0,  0,  0, // 3910-3912
 0,  0,  0, // 3913-3915
 0,  0, // 3916-3917
 0,  0, // 3918-3919
 0,  0,  0, // 3920-3922
 0,  0,  0, // 3923-3925
 0,  0,  0, // 3926-3928
 0,  0,  0, // 3929-3931
 0,  0,  0,  0, // 3932-3935
 0,  0,  0, // 3936-3938
 0,  0, // 3939-3940
 0,  0,  0, // 3941-3943
 0,  0,  0, // 3944-3946
 0,  0,  0, // 3947-3949
 0,  0,  0, // 3950-3952
 0,  0,  0, // 3953-3955
 0,  0,  0, // 3956-3958
 0,  0,  0, // 3959-3961
 0,  0,  0, // 3962-3964
 0,  0,  0, // 3965-3967
 0,  0,  0, // 3968-3970
 0,  0,  0, // 3971-3973
 0,  0,  0, // 3974-3976
 0,  0,  0, // 3977-3979
 0,  0,  0, // 3980-3982
 0,  0,  0,  0, // 3983-3986
 0,  0,  0, // 3987-3989
 0,  0,  0, // 3990-3992
 0,  0,  0, // 3993-3995
 0,  0,  0, // 3996-3998
 0,  0,  0, // 3999-4001
 0,  0,  0, // 4002-4004
 0,  0,  0, // 4005-4007
 0,  0,  0,  0, // 4008-4011
 0,  0,  0, // 4012-4014
 0,  0,  0, // 4015-4017
 0,  0,  0, // 4018-4020
 0,  0,  0, // 4021-4023
 0,  0,  0, // 4024-4026
 0,  0,  0, // 4027-4029
 0,  0,  0, // 4030-4032
 0,  0,  0, // 4033-4035
 0,  0,  0, // 4036-4038
 0,  0,  0, // 4039-4041
 0,  0,  0, // 4042-4044
 0,  0,  0, // 4045-4047
 0,  0,  0, // 4048-4050
 0,  0,  0, // 4051-4053
 0,  0,  0, // 4054-4056
 0,  0,  0, // 4057-4059
 0,  0,  0, // 4060-4062
 0,  0,  0, // 4063-4065
 0,  0,  0, // 4066-4068
 0,  0,  0, // 4069-4071
 0,  0,  0, // 4072-4074
 0,  0,  0,  0, // 4075-4078
 0,  0,  0,  0, // 4079-4082
 0,  0, // 4083-4084
 0,  0,  0, // 4085-4087
 0,  0,  0, // 4088-4090
 0,  0,  0, // 4091-4093
 0,  0,  0, // 4094-4096
 0,  0,  0, // 4097-4099
 0,  0, // 4100-4101
 0,  0,  0, // 4102-4104
 0,  0,  0, // 4105-4107
 0,  0,  0, // 4108-4110
 0,  0,  0, // 4111-4113
 0,  0,  0,  0, // 4114-4117
 0,  0,  0,  0, // 4118-4121
 0,  0,  0, // 4122-4124
 0,  0,  0, // 4125-4127
 0,  0,  0, // 4128-4130
 0,  0,  0, // 4131-4133
 0,  0,  0, // 4134-4136
 0,  0,  0, // 4137-4139
 0,  0,  0, // 4140-4142
 0,  0,  0, // 4143-4145
 0,  0, // 4146-4147
 0,  0,  0, // 4148-4150
 0,  0, // 4151-4152
 0,  0,  0, // 4153-4155
 0,  0,  0, // 4156-4158
 0,  0,  0, // 4159-4161
 0,  0,  0, // 4162-4164
 0,  0,  0, // 4165-4167
 0,  0,  0, // 4168-4170
 0,  0,  0, // 4171-4173
 0,  0,  0, // 4174-4176
 0,  0, // 4177-4178
 0,  0,  0, // 4179-4181
 0,  0,  0, // 4182-4184
 0,  0,  0, // 4185-4187
 0,  0,  0, // 4188-4190
 0,  0,  0, // 4191-4193
 0,  0,  0, // 4194-4196
 0,  0,  0, // 4197-4199
 0,  0,  0, // 4200-4202
 0,  0, // 4203-4204
 0,  0,  0, // 4205-4207
 0,  0,  0, // 4208-4210
 0,  0,  0, // 4211-4213
 0,  0,  0, // 4214-4216
 0,  0,  0, // 4217-4219
 0,  0,  0, // 4220-4222
 0,  0,  0, // 4223-4225
 0,  0,  0, // 4226-4228
 0,  0,  0, // 4229-4231
 0,  0,  0, // 4232-4234
 0,  0,  0, // 4235-4237
 0,  0,  0, // 4238-4240
 0,  0,  0, // 4241-4243
 0,  0,  0, // 4244-4246
 0,  0,  0, // 4247-4249
 0,  0,  0, // 4250-4252
 0,  0,  0, // 4253-4255
 0,  0,  0, // 4256-4258
 0,  0,  0,  0, // 4259-4262
 0,  0,  0,  0, // 4263-4266
 0,  0,  0,  0, // 4267-4270
 0,  0,  0,  0, // 4271-4274
 0,  0,  0,  0, // 4275-4278
 0,  0,  0,  0, // 4279-4282
 0,  0,  0,  0, // 4283-4286
 0,  0,  0,  0, // 4287-4290
 0,  0,  0,  0, // 4291-4294
 0,  0,  0,  0, // 4295-4298
 0,  0,  0,  0, // 4299-4302
 0,  0,  0, // 4303-4305
 0,  0,  0, // 4306-4308
 0,  0,  0, // 4309-4311
 0,  0,  0, // 4312-4314
 0,  0,  0, // 4315-4317
 0,  0,  0, // 4318-4320
 0,  0,  0, // 4321-4323
 0,  0,  0, // 4324-4326
 0,  0,  0, // 4327-4329
 0,  0,  0, // 4330-4332
 0,  0,  0, // 4333-4335
 0,  0,  0, // 4336-4338
 0,  0,  0, // 4339-4341
 0,  0,  0, // 4342-4344
 0,  0,  0, // 4345-4347
 0,  0, // 4348-4349
 0,  0,  0, // 4350-4352
 0,  0,  0, // 4353-4355
 0,  0,  0, // 4356-4358
 0,  0,  0, // 4359-4361
 0,  0,  0, // 4362-4364
 0,  0,  0, // 4365-4367
 0,  0,  0, // 4368-4370
 0,  0,  0,  0, // 4371-4374
 0,  0,  0, // 4375-4377
 0,  0,  0, // 4378-4380
 0,  0,  0, // 4381-4383
 0,  0,  0, // 4384-4386
 0,  0,  0, // 4387-4389
 0,  0,  0, // 4390-4392
 0,  0,  0, // 4393-4395
 0,  0,  0,  0, // 4396-4399
 0,  0,  0, // 4400-4402
 0,  0,  0, // 4403-4405
 0,  0,  0, // 4406-4408
 0,  0,  0, // 4409-4411
 0,  0,  0, // 4412-4414
 0,  0,  0, // 4415-4417
 0,  0,  0, // 4418-4420
 0,  0,  0, // 4421-4423
 0,  0,  0, // 4424-4426
 0,  0,  0, // 4427-4429
 0,  0,  0, // 4430-4432
 0,  0,  0, // 4433-4435
 0,  0,  0, // 4436-4438
 0,  0,  0, // 4439-4441
 0,  0,  0, // 4442-4444
 0,  0,  0, // 4445-4447
 0,  0,  0, // 4448-4450
 0,  0,  0, // 4451-4453
 0,  0,  0, // 4454-4456
 0,  0,  0, // 4457-4459
 0,  0,  0, // 4460-4462
 0,  0,  0, // 4463-4465
 0,  0,  0, // 4466-4468
 0,  0,  0, // 4469-4471
 0,  0,  0, // 4472-4474
 0,  0,  0, // 4475-4477
 0,  0,  0, // 4478-4480
 0,  0,  0, // 4481-4483
 0,  0,  0, // 4484-4486
 0,  0, // 4487-4488
 0,  0,  0, // 4489-4491
 0,  0,  0, // 4492-4494
 0,  0,  0, // 4495-4497
 0,  0,  0, // 4498-4500
 0,  0,  0, // 4501-4503
 0,  0,  0, // 4504-4506
 0,  0,  0, // 4507-4509
 0,  0,  0, // 4510-4512
 0,  0,  0, // 4513-4515
 0,  0,  0, // 4516-4518
 0,  0,  0, // 4519-4521
 0,  0,  0, // 4522-4524
 0,  0,  0, // 4525-4527
 0,  0,  0, // 4528-4530
 0,  0,  0, // 4531-4533
 0,  0,  0, // 4534-4536
 0,  0,  0, // 4537-4539
 0,  0,  0, // 4540-4542
 0,  0,  0, // 4543-4545
 0,  0,  0, // 4546-4548
 0,  0,  0, // 4549-4551
 0,  0,  0, // 4552-4554
 0,  0,  0, // 4555-4557
 0,  0,  0, // 4558-4560
 0,  0,  0, // 4561-4563
 0,  0,  0, // 4564-4566
 0,  0,  0, // 4567-4569
 0,  0,  0, // 4570-4572
 0,  0,  0, // 4573-4575
 0,  0,  0, // 4576-4578
 0,  0,  0, // 4579-4581
 0,  0,  0, // 4582-4584
 0,  0,  0, // 4585-4587
 0,  0,  0, // 4588-4590
 0,  0,  0, // 4591-4593
 0,  0,  0, // 4594-4596
 0,  0,  0, // 4597-4599
 0,  0,  0, // 4600-4602
 0,  0,  0, // 4603-4605
 0,  0,  0, // 4606-4608
 0,  0,  0, // 4609-4611
 0,  0,  0, // 4612-4614
 0,  0,  0, // 4615-4617
 0,  0,  0, // 4618-4620
 0,  0,  0, // 4621-4623
 0,  0,  0, // 4624-4626
 0,  0,  0, // 4627-4629
 0,  0,  0, // 4630-4632
 0,  0,  0, // 4633-4635
 0,  0,  0, // 4636-4638
 0,  0, // 4639-4640
 0,  0,  0, // 4641-4643
 0,  0,  0, // 4644-4646
 0,  0,  0, // 4647-4649
 0,  0,  0, // 4650-4652
 0,  0,  0, // 4653-4655
 0,  0,  0, // 4656-4658
 0,  0,  0, // 4659-4661
 0,  0,  0, // 4662-4664
 0,  0,  0, // 4665-4667
 0,  0,  0, // 4668-4670
 0,  0,  0, // 4671-4673
 0,  0,  0, // 4674-4676
 0,  0,  0, // 4677-4679
 0,  0,  0, // 4680-4682
 0,  0,  0, // 4683-4685
 0,  0,  0, // 4686-4688
 0,  0,  0, // 4689-4691
 0,  0,  0, // 4692-4694
 0,  0,  0, // 4695-4697
 0,  0,  0, // 4698-4700
 0,  0,  0, // 4701-4703
 0,  0,  0, // 4704-4706
 0,  0,  0, // 4707-4709
 0,  0,  0, // 4710-4712
 0,  0,  0, // 4713-4715
 0,  0,  0, // 4716-4718
 0,  0,  0, // 4719-4721
 0,  0,  0, // 4722-4724
 0,  0,  0, // 4725-4727
 0,  0,  0, // 4728-4730
 0,  0,  0, // 4731-4733
 0,  0,  0, // 4734-4736
 0,  0,  0, // 4737-4739
 0,  0,  0, // 4740-4742
 0,  0,  0, // 4743-4745
 0,  0,  0, // 4746-4748
 0,  0,  0, // 4749-4751
 0,  0,  0, // 4752-4754
 0,  0,  0, // 4755-4757
 0,  0,  0, // 4758-4760
 0,  0,  0, // 4761-4763
 0,  0,  0, // 4764-4766
 0,  0,  0, // 4767-4769
 0,  0,  0, // 4770-4772
 0,  0,  0, // 4773-4775
 0,  0,  0, // 4776-4778
 0,  0,  0, // 4779-4781
 0,  0,  0, // 4782-4784
 0,  0,  0, // 4785-4787
 0,  0,  0, // 4788-4790
 0,  0,  0, // 4791-4793
 0,  0,  0, // 4794-4796
 0,  0,  0, // 4797-4799
 0,  0,  0, // 4800-4802
 0,  0,  0, // 4803-4805
 0,  0,  0, // 4806-4808
 0,  0,  0, // 4809-4811
 0,  0,  0, // 4812-4814
 0,  0,  0, // 4815-4817
 0,  0,  0, // 4818-4820
 0,  0,  0, // 4821-4823
 0,  0,  0, // 4824-4826
 0,  0,  0, // 4827-4829
 0,  0,  0, // 4830-4832
 0,  0,  0, // 4833-4835
 0,  0,  0, // 4836-4838
 0,  0,  0, // 4839-4841
 0,  0,  0, // 4842-4844
 0,  0,  0, // 4845-4847
 0,  0,  0, // 4848-4850
 0,  0,  0, // 4851-4853
 0,  0,  0, // 4854-4856
 0,  0,  0, // 4857-4859
 0,  0,  0, // 4860-4862
 0,  0,  0, // 4863-4865
 0,  0,  0, // 4866-4868
 0,  0,  0, // 4869-4871
 0,  0,  0, // 4872-4874
 0,  0,  0, // 4875-4877
 0,  0,  0, // 4878-4880
 0,  0,  0, // 4881-4883
 0,  0,  0, // 4884-4886
 0,  0,  0, // 4887-4889
 0,  0,  0,  0, // 4890-4893
 0,  0,  0, // 4894-4896
 0,  0,  0, // 4897-4899
 0,  0,  0,  0, // 4900-4903
 0,  0,  0, // 4904-4906
 0,  0,  0,  0, // 4907-4910
 0,  0,  0,  0, // 4911-4914
 0,  0,  0, // 4915-4917
 0,  0,  0,  0, // 4918-4921
 0,  0,  0,  0, // 4922-4925
 0,  0,  0, // 4926-4928
 0,  0,  0,  0, // 4929-4932
 0,  0,  0,  0, // 4933-4936
 0,  0,  0, // 4937-4939
 0,  0,  0,  0, // 4940-4943
 0,  0,  0,  0, // 4944-4947
 0,  0,  0, // 4948-4950
 0,  0,  0, // 4951-4953
 0,  0,  0, // 4954-4956
 0,  0,  0, // 4957-4959
 0,  0, // 4960-4961
 0,  0, // 4962-4963
 0,  0, // 4964-4965
 0,  0, // 4966-4967
 0,  0,  0, // 4968-4970
 0,  0,  0, // 4971-4973
 0,  0,  0, // 4974-4976
 0,  0,  0, // 4977-4979
 0,  0,  0, // 4980-4982
 0,  0,  0, // 4983-4985
 0,  0,  0, // 4986-4988
 0,  0,  0,  0, // 4989-4992
 0,  0,  0,  0, // 4993-4996
 0,  0,  0, // 4997-4999
 0,  0,  0, // 5000-5002
 0,  0,  0, // 5003-5005
 0,  0,  0,  0, // 5006-5009
 0,  0, // 5010-5011
 0,  0, // 5012-5013
 0,  0,  0, // 5014-5016
 0,  0,  0, // 5017-5019
 0,  0,  0, // 5020-5022
 0,  0,  0, // 5023-5025
 0,  0,  0, // 5026-5028
 0,  0, // 5029-5030
 0,  0,  0, // 5031-5033
 0,  0, // 5034-5035
 0,  0, // 5036-5037
 0,  0,  0, // 5038-5040
 0,  0,  0, // 5041-5043
 0,  0,  0, // 5044-5046
 0,  0,  0, // 5047-5049
 0,  0,  0, // 5050-5052
 0,  0,  0, // 5053-5055
 0,  0,  0, // 5056-5058
 0,  0,  0, // 5059-5061
 0,  0,  0, // 5062-5064
 0,  0,  0, // 5065-5067
 0,  0,  0, // 5068-5070
 0,  0,  0, // 5071-5073
 0,  0, // 5074-5075
 0,  0,  0, // 5076-5078
 0,  0,  0, // 5079-5081
 0,  0, // 5082-5083
 0,  0,  0, // 5084-5086
 0,  0,  0, // 5087-5089
 0,  0,  0, // 5090-5092
 0,  0,  0, // 5093-5095
 0,  0, // 5096-5097
 0,  0, // 5098-5099
 0,  0,  0, // 5100-5102
 0,  0,  0, // 5103-5105
 0,  0,  0, // 5106-5108
 0,  0,  0, // 5109-5111
 0,  0,  0,  0, // 5112-5115
 0,  0,  0, // 5116-5118
 0,  0, // 5119-5120
 0,  0,  0, // 5121-5123
 0,  0,  0, // 5124-5126
 0,  0,  0, // 5127-5129
 0,  0,  0, // 5130-5132
 0,  0,  0, // 5133-5135
 0,  0,  0, // 5136-5138
 0,  0,  0, // 5139-5141
 0,  0,  0, // 5142-5144
 0,  0,  0, // 5145-5147
 0,  0,  0, // 5148-5150
 0,  0,  0, // 5151-5153
 0,  0,  0, // 5154-5156
 0,  0,  0, // 5157-5159
 0,  0,  0, // 5160-5162
 0,  0,  0,  0, // 5163-5166
 0,  0,  0, // 5167-5169
 0,  0,  0, // 5170-5172
 0,  0,  0, // 5173-5175
 0,  0,  0, // 5176-5178
 0,  0,  0, // 5179-5181
 0,  0,  0, // 5182-5184
 0,  0,  0, // 5185-5187
 0,  0,  0,  0, // 5188-5191
 0,  0,  0, // 5192-5194
 0,  0,  0, // 5195-5197
 0,  0,  0, // 5198-5200
 0,  0,  0, // 5201-5203
 0,  0,  0, // 5204-5206
 0,  0,  0, // 5207-5209
 0,  0,  0, // 5210-5212
 0,  0,  0, // 5213-5215
 0,  0,  0, // 5216-5218
 0,  0,  0, // 5219-5221
 0,  0,  0, // 5222-5224
 0,  0,  0, // 5225-5227
 0,  0,  0, // 5228-5230
 0,  0,  0, // 5231-5233
 0,  0,  0, // 5234-5236
 0,  0,  0, // 5237-5239
 0,  0,  0, // 5240-5242
 0,  0,  0, // 5243-5245
 0,  0,  0, // 5246-5248
 0,  0,  0, // 5249-5251
 0,  0,  0, // 5252-5254
 0,  0,  0,  0, // 5255-5258
 0,  0,  0,  0, // 5259-5262
 0,  0, // 5263-5264
 0,  0,  0, // 5265-5267
 0,  0,  0, // 5268-5270
 0,  0,  0, // 5271-5273
 0,  0,  0, // 5274-5276
 0,  0,  0, // 5277-5279
 0,  0, // 5280-5281
 0,  0,  0, // 5282-5284
 0,  0,  0, // 5285-5287
 0,  0,  0, // 5288-5290
 0,  0,  0, // 5291-5293
 0,  0,  0,  0, // 5294-5297
 0,  0,  0,  0, // 5298-5301
 0,  0,  0, // 5302-5304
 0,  0,  0, // 5305-5307
 0,  0,  0, // 5308-5310
 0,  0,  0, // 5311-5313
 0,  0,  0, // 5314-5316
 0,  0,  0, // 5317-5319
 0,  0,  0, // 5320-5322
 0,  0,  0, // 5323-5325
 0,  0,  0, // 5326-5328
 0,  0, // 5329-5330
 0,  0,  0, // 5331-5333
 0,  0, // 5334-5335
 0,  0,  0, // 5336-5338
 0,  0,  0, // 5339-5341
 0,  0,  0, // 5342-5344
 0,  0,  0, // 5345-5347
 0,  0,  0, // 5348-5350
 0,  0,  0, // 5351-5353
 0,  0,  0, // 5354-5356
 0,  0,  0, // 5357-5359
 0,  0, // 5360-5361
 0,  0,  0, // 5362-5364
 0,  0,  0, // 5365-5367
 0,  0,  0, // 5368-5370
 0,  0,  0, // 5371-5373
 0,  0,  0, // 5374-5376
 0,  0,  0, // 5377-5379
 0,  0,  0, // 5380-5382
 0,  0,  0, // 5383-5385
 0,  0, // 5386-5387
 0,  0,  0, // 5388-5390
 0,  0,  0, // 5391-5393
 0,  0,  0, // 5394-5396
 0,  0,  0, // 5397-5399
 0,  0,  0, // 5400-5402
 0,  0,  0, // 5403-5405
 0,  0,  0, // 5406-5408
 0,  0,  0, // 5409-5411
 0,  0,  0, // 5412-5414
 0,  0,  0, // 5415-5417
 0,  0,  0, // 5418-5420
 0,  0,  0, // 5421-5423
 0,  0,  0, // 5424-5426
 0,  0,  0, // 5427-5429
 0,  0,  0, // 5430-5432
 0,  0,  0, // 5433-5435
 0,  0,  0, // 5436-5438
 0,  0,  0, // 5439-5441
 0,  0,  0,  0, // 5442-5445
 0,  0,  0,  0, // 5446-5449
 0,  0,  0,  0, // 5450-5453
 0,  0,  0,  0, // 5454-5457
 0,  0,  0,  0, // 5458-5461
 0,  0,  0,  0, // 5462-5465
 0,  0,  0,  0, // 5466-5469
 0,  0,  0,  0, // 5470-5473
 0,  0,  0,  0, // 5474-5477
 0,  0,  0,  0, // 5478-5481
 0,  0,  0,  0, // 5482-5485
 0,  0,  0, // 5486-5488
 0,  0,  0, // 5489-5491
 0,  0,  0, // 5492-5494
 0,  0,  0, // 5495-5497
 0,  0,  0, // 5498-5500
 0,  0,  0, // 5501-5503
 0,  0,  0, // 5504-5506
 0,  0,  0, // 5507-5509
 0,  0,  0, // 5510-5512
 0,  0,  0, // 5513-5515
 0,  0,  0, // 5516-5518
 0,  0,  0, // 5519-5521
 0,  0,  0, // 5522-5524
 0,  0,  0, // 5525-5527
 0,  0,  0, // 5528-5530
 0,  0, // 5531-5532
 0,  0,  0, // 5533-5535
 0,  0,  0, // 5536-5538
 0,  0,  0, // 5539-5541
 0,  0,  0, // 5542-5544
 0,  0,  0, // 5545-5547
 0,  0,  0, // 5548-5550
 0,  0,  0, // 5551-5553
 0,  0,  0,  0, // 5554-5557
 0,  0,  0, // 5558-5560
 0,  0,  0, // 5561-5563
 0,  0,  0, // 5564-5566
 0,  0,  0, // 5567-5569
 0,  0,  0, // 5570-5572
 0,  0,  0, // 5573-5575
 0,  0,  0, // 5576-5578
 0,  0,  0,  0, // 5579-5582
 0,  0,  0, // 5583-5585
 0,  0,  0, // 5586-5588
 0,  0,  0, // 5589-5591
 0,  0,  0, // 5592-5594
 0,  0,  0, // 5595-5597
 0,  0,  0, // 5598-5600
 0,  0,  0, // 5601-5603
 0,  0,  0, // 5604-5606
 0,  0,  0, // 5607-5609
 0,  0,  0, // 5610-5612
 0,  0,  0, // 5613-5615
 0,  0,  0, // 5616-5618
 0,  0,  0, // 5619-5621
 0,  0,  0, // 5622-5624
 0,  0,  0, // 5625-5627
 0,  0,  0, // 5628-5630
 0,  0,  0, // 5631-5633
 0,  0,  0, // 5634-5636
 0,  0,  0, // 5637-5639
 0,  0,  0, // 5640-5642
 0,  0,  0, // 5643-5645
 0,  0,  0, // 5646-5648
 0,  0,  0, // 5649-5651
 0,  0,  0, // 5652-5654
 0,  0,  0, // 5655-5657
 0,  0,  0, // 5658-5660
 0,  0,  0, // 5661-5663
 0,  0,  0, // 5664-5666
 0,  0,  0, // 5667-5669
 0,  0, // 5670-5671
 0,  0,  0, // 5672-5674
 0,  0,  0, // 5675-5677
 0,  0,  0, // 5678-5680
 0,  0,  0, // 5681-5683
 0,  0,  0, // 5684-5686
 0,  0,  0, // 5687-5689
 0,  0,  0, // 5690-5692
 0,  0,  0, // 5693-5695
 0,  0,  0, // 5696-5698
 0,  0,  0, // 5699-5701
 0,  0,  0, // 5702-5704
 0,  0,  0, // 5705-5707
 0,  0,  0, // 5708-5710
 0,  0,  0, // 5711-5713
 0,  0,  0, // 5714-5716
 0,  0,  0, // 5717-5719
 0,  0,  0, // 5720-5722
 0,  0,  0, // 5723-5725
 0,  0,  0, // 5726-5728
 0,  0,  0, // 5729-5731
 0,  0,  0, // 5732-5734
 0,  0,  0, // 5735-5737
 0,  0,  0, // 5738-5740
 0,  0,  0, // 5741-5743
 0,  0,  0, // 5744-5746
 0,  0,  0, // 5747-5749
 0,  0,  0, // 5750-5752
 0,  0,  0, // 5753-5755
 0,  0,  0, // 5756-5758
 0,  0,  0, // 5759-5761
 0,  0,  0, // 5762-5764
 0,  0,  0, // 5765-5767
 0,  0,  0, // 5768-5770
 0,  0,  0, // 5771-5773
 0,  0,  0, // 5774-5776
 0,  0,  0, // 5777-5779
 0,  0,  0, // 5780-5782
 0,  0,  0, // 5783-5785
 0,  0,  0, // 5786-5788
 0,  0,  0, // 5789-5791
 0,  0,  0, // 5792-5794
 0,  0,  0, // 5795-5797
 0,  0,  0, // 5798-5800
 0,  0,  0, // 5801-5803
 0,  0,  0, // 5804-5806
 0,  0,  0, // 5807-5809
 0,  0,  0, // 5810-5812
 0,  0,  0, // 5813-5815
 0,  0,  0, // 5816-5818
 0,  0,  0, // 5819-5821
 0,  0, // 5822-5823
 0,  0,  0, // 5824-5826
 0,  0,  0, // 5827-5829
 0,  0,  0, // 5830-5832
 0,  0,  0, // 5833-5835
 0,  0,  0, // 5836-5838
 0,  0,  0, // 5839-5841
 0,  0,  0, // 5842-5844
 0,  0,  0, // 5845-5847
 0,  0,  0, // 5848-5850
 0,  0,  0, // 5851-5853
 0,  0,  0, // 5854-5856
 0,  0,  0, // 5857-5859
 0,  0,  0, // 5860-5862
 0,  0,  0, // 5863-5865
 0,  0,  0, // 5866-5868
 0,  0,  0, // 5869-5871
 0,  0,  0, // 5872-5874
 0,  0,  0, // 5875-5877
 0,  0,  0, // 5878-5880
 0,  0,  0, // 5881-5883
 0,  0,  0, // 5884-5886
 0,  0,  0, // 5887-5889
 0,  0,  0, // 5890-5892
 0,  0,  0, // 5893-5895
 0,  0,  0, // 5896-5898
 0,  0,  0, // 5899-5901
 0,  0,  0, // 5902-5904
 0,  0,  0, // 5905-5907
 0,  0,  0, // 5908-5910
 0,  0,  0, // 5911-5913
 0,  0,  0, // 5914-5916
 0,  0,  0, // 5917-5919
 0,  0,  0, // 5920-5922
 0,  0,  0, // 5923-5925
 0,  0,  0, // 5926-5928
 0,  0,  0, // 5929-5931
 0,  0,  0, // 5932-5934
 0,  0,  0, // 5935-5937
 0,  0,  0, // 5938-5940
 0,  0,  0, // 5941-5943
 0,  0,  0, // 5944-5946
 0,  0,  0, // 5947-5949
 0,  0,  0, // 5950-5952
 0,  0,  0, // 5953-5955
 0,  0,  0, // 5956-5958
 0,  0,  0, // 5959-5961
 0,  0,  0, // 5962-5964
 0,  0,  0, // 5965-5967
 0,  0,  0, // 5968-5970
 0,  0,  0, // 5971-5973
 0,  0,  0, // 5974-5976
 0,  0,  0, // 5977-5979
 0,  0,  0, // 5980-5982
 0,  0,  0, // 5983-5985
 0,  0,  0, // 5986-5988
 0,  0,  0, // 5989-5991
 0,  0,  0, // 5992-5994
 0,  0,  0, // 5995-5997
 0,  0,  0, // 5998-6000
 0,  0,  0, // 6001-6003
 0,  0,  0, // 6004-6006
 0,  0,  0, // 6007-6009
 0,  0,  0, // 6010-6012
 0,  0,  0, // 6013-6015
 0,  0,  0, // 6016-6018
 0 // End bypass tables
};

static const llvm::InstrItinerary PPC440Itineraries[] = {
  { 0, 0, 0, 0, 0 }, // 0 NoInstrModel
  { 1, 1, 6, 0, 0 }, // 1 IIC_LdStSync
  { 1, 6, 11, 1, 4 }, // 2 IIC_IntSimple
  { 1, 6, 11, 4, 7 }, // 3 IIC_IntGeneral
  { 1, 11, 16, 7, 9 }, // 4 IIC_BrB
  { 0, 0, 0, 0, 0 }, // 5 IIC_VecFP
  { 1, 6, 11, 9, 12 }, // 6 IIC_IntCompare
  { 0, 0, 0, 0, 0 }, // 7 IIC_SprABORT
  { 0, 0, 0, 0, 0 }, // 8 IIC_LdStCOPY
  { 0, 0, 0, 0, 0 }, // 9 IIC_LdStPASTE
  { 1, 11, 16, 12, 15 }, // 10 IIC_BrCR
  { 0, 0, 0, 0, 0 }, // 11 IIC_LdStLD
  { 1, 16, 21, 15, 17 }, // 12 IIC_LdStDCBF
  { 1, 21, 26, 17, 20 }, // 13 IIC_LdStLoad
  { 0, 0, 0, 0, 0 }, // 14 IIC_IntDivD
  { 1, 26, 31, 20, 23 }, // 15 IIC_IntDivW
  { 0, 0, 0, 0, 0 }, // 16 IIC_FPDGeneral
  { 1, 31, 40, 23, 26 }, // 17 IIC_FPAddSub
  { 1, 40, 49, 26, 29 }, // 18 IIC_FPDivD
  { 0, 0, 0, 0, 0 }, // 19 IIC_FPSGeneral
  { 1, 31, 40, 29, 32 }, // 20 IIC_FPCompare
  { 1, 31, 40, 32, 35 }, // 21 IIC_FPGeneral
  { 0, 0, 0, 0, 0 }, // 22 IIC_VecGeneral
  { 0, 0, 0, 0, 0 }, // 23 IIC_VecComplex
  { 1, 21, 26, 35, 38 }, // 24 IIC_LdStStore
  { 0, 0, 0, 0, 0 }, // 25 IIC_IntRotateDI
  { 1, 49, 58, 38, 41 }, // 26 IIC_FPDivS
  { 1, 31, 40, 41, 45 }, // 27 IIC_FPFused
  { 0, 0, 0, 0, 0 }, // 28 IIC_FPSqrtD
  { 0, 0, 0, 0, 0 }, // 29 IIC_FPSqrtS
  { 1, 16, 21, 45, 48 }, // 30 IIC_LdStICBI
  { 1, 6, 11, 48, 52 }, // 31 IIC_IntISEL
  { 1, 58, 74, 0, 0 }, // 32 IIC_SprISYNC
  { 1, 74, 81, 52, 55 }, // 33 IIC_LdStLWARX
  { 1, 21, 26, 55, 59 }, // 34 IIC_LdStLoadUpd
  { 1, 21, 26, 59, 63 }, // 35 IIC_LdStLoadUpdX
  { 0, 0, 0, 0, 0 }, // 36 IIC_LdStLDARX
  { 0, 0, 0, 0, 0 }, // 37 IIC_LdStLDU
  { 0, 0, 0, 0, 0 }, // 38 IIC_LdStLDUX
  { 1, 21, 26, 63, 66 }, // 39 IIC_LdStLFD
  { 1, 16, 21, 66, 70 }, // 40 IIC_LdStLFDU
  { 1, 16, 21, 70, 74 }, // 41 IIC_LdStLFDUX
  { 1, 16, 21, 74, 77 }, // 42 IIC_LdStLHA
  { 1, 16, 21, 77, 80 }, // 43 IIC_LdStLHAU
  { 1, 16, 21, 80, 83 }, // 44 IIC_LdStLHAUX
  { 1, 16, 21, 83, 86 }, // 45 IIC_LdStLMW
  { 0, 0, 0, 0, 0 }, // 46 IIC_LdStLQ
  { 0, 0, 0, 0, 0 }, // 47 IIC_LdStLQARX
  { 0, 0, 0, 0, 0 }, // 48 IIC_LdStLWA
  { 0, 0, 0, 0, 0 }, // 49 IIC_IntMulHD
  { 1, 11, 16, 86, 89 }, // 50 IIC_BrMCR
  { 1, 11, 16, 89, 92 }, // 51 IIC_BrMCRX
  { 1, 11, 16, 92, 94 }, // 52 IIC_SprMFCR
  { 1, 81, 86, 94, 96 }, // 53 IIC_SprMFSPR
  { 1, 11, 16, 96, 99 }, // 54 IIC_IntMFFS
  { 1, 11, 16, 99, 101 }, // 55 IIC_SprMFMSR
  { 0, 0, 0, 0, 0 }, // 56 IIC_SprMFCRF
  { 0, 0, 0, 0, 0 }, // 57 IIC_SprMFPMR
  { 1, 11, 16, 101, 103 }, // 58 IIC_SprMFSR
  { 1, 81, 86, 103, 105 }, // 59 IIC_SprMFTB
  { 0, 0, 0, 0, 0 }, // 60 IIC_SprMSGSYNC
  { 1, 81, 86, 105, 107 }, // 61 IIC_SprMTSPR
  { 1, 11, 16, 107, 110 }, // 62 IIC_IntMTFSB0
  { 1, 11, 16, 110, 112 }, // 63 IIC_SprMTMSR
  { 0, 0, 0, 0, 0 }, // 64 IIC_SprMTMSRD
  { 0, 0, 0, 0, 0 }, // 65 IIC_SprMTPMR
  { 1, 81, 86, 112, 114 }, // 66 IIC_SprMTSR
  { 1, 11, 16, 114, 117 }, // 67 IIC_IntMulHW
  { 1, 11, 16, 117, 120 }, // 68 IIC_IntMulHWU
  { 1, 11, 16, 120, 123 }, // 69 IIC_IntMulLI
  { 1, 11, 16, 123, 125 }, // 70 IIC_SprRFI
  { 0, 0, 0, 0, 0 }, // 71 IIC_IntRFID
  { 0, 0, 0, 0, 0 }, // 72 IIC_IntRotateD
  { 1, 6, 11, 125, 128 }, // 73 IIC_IntRotate
  { 0, 0, 0, 0, 0 }, // 74 IIC_SprSLBFEE
  { 0, 0, 0, 0, 0 }, // 75 IIC_SprSLBIA
  { 0, 0, 0, 0, 0 }, // 76 IIC_SprSLBIE
  { 0, 0, 0, 0, 0 }, // 77 IIC_SprSLBIEG
  { 0, 0, 0, 0, 0 }, // 78 IIC_SprSLBMFEE
  { 0, 0, 0, 0, 0 }, // 79 IIC_SprSLBMFEV
  { 0, 0, 0, 0, 0 }, // 80 IIC_SprSLBMTE
  { 0, 0, 0, 0, 0 }, // 81 IIC_SprSLBSYNC
  { 1, 6, 11, 128, 131 }, // 82 IIC_IntShift
  { 1, 74, 81, 131, 134 }, // 83 IIC_LdStSTWCX
  { 1, 21, 26, 134, 138 }, // 84 IIC_LdStSTU
  { 1, 21, 26, 138, 142 }, // 85 IIC_LdStSTUX
  { 1, 21, 26, 142, 145 }, // 86 IIC_LdStSTD
  { 1, 74, 81, 145, 148 }, // 87 IIC_LdStSTDCX
  { 1, 16, 21, 148, 151 }, // 88 IIC_LdStSTFD
  { 1, 16, 21, 151, 155 }, // 89 IIC_LdStSTFDU
  { 0, 0, 0, 0, 0 }, // 90 IIC_SprSTOP
  { 0, 0, 0, 0, 0 }, // 91 IIC_LdStSTQ
  { 0, 0, 0, 0, 0 }, // 92 IIC_LdStSTQCX
  { 0, 0, 0, 0, 0 }, // 93 IIC_IntTrapD
  { 0, 0, 0, 0, 0 }, // 94 IIC_SprTLBIA
  { 0, 0, 0, 0, 0 }, // 95 IIC_SprTLBIE
  { 0, 0, 0, 0, 0 }, // 96 IIC_SprTLBIEL
  { 1, 11, 16, 0, 0 }, // 97 IIC_SprTLBSYNC
  { 1, 11, 16, 155, 157 }, // 98 IIC_IntTrapW
  { 0, 0, 0, 0, 0 }, // 99 IIC_VecFPCompare
  { 0, 0, 0, 0, 0 }, // 100 IIC_VecPerm
  { 0, 0, 0, 0, 0 }, // 101 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VSLD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_VPOPCNTB_VPOPCNTH_VSRAD_MTVSRDD_VEQV_VNAND_VNEGD_VNEGW_VORC_XXLAND_XXLANDC_XXLEQV_XXLEQVOnes_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 0, 0, 0, 0, 0 }, // 102 VAND_VANDC_V_SET0_V_SET0B_V_SET0H_VSLB_VSLH_VSLW_VSRB_VSRH_VSRW_VRLB_VRLD_VRLH_VRLW_VSRAB_VSRAH_VSRAW_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP_XVXEXPDP_XVXEXPSP_VRLDMI_VRLDNM_VRLWMI_VRLWNM_VMRGEW_VMRGOW_VNOR_VOR_VSEL_VXOR_XVNEGDP_XVNEGSP_XSABSQP_XSCPSGNQP_XSIEXPQP_XSNABSQP_XSNEGQP_XSXEXPQP
  { 0, 0, 0, 0, 0 }, // 103 XXSEL
  { 1, 81, 86, 157, 159 }, // 104 TABORTDC_TABORTDCI_TABORTWC_TABORTWCI
  { 1, 11, 16, 159, 162 }, // 105 MTFSB0_MTFSB1
  { 1, 11, 16, 162, 165 }, // 106 MFFSCDRN_MFFSCDRNI_MFFSCRN_MFFSCRNI
  { 1, 6, 11, 165, 168 }, // 107 CMPRB_CMPRB8_CMPEQB
  { 0, 0, 0, 0, 0 }, // 108 TD_TDI
  { 1, 11, 16, 168, 170 }, // 109 TW_TWI
  { 1, 31, 40, 170, 173 }, // 110 FCMPOD_FCMPOS_FCMPUD_FCMPUS_FTDIV_FTSQRT
  { 0, 0, 0, 0, 0 }, // 111 XSTSTDCDP_XSTSTDCSP
  { 0, 0, 0, 0, 0 }, // 112 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP_XSXSIGDP_XSCVSPDPN
  { 1, 31, 40, 173, 176 }, // 113 XSCMPEQDP_XSCMPEXPDP_XSCMPGEDP_XSCMPGTDP_XSCMPODP_XSCMPUDP_XSTDIVDP_XSTSQRTDP
  { 1, 6, 11, 176, 179 }, // 114 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW_CMPB_CMPB8_SETB_SETB8_BPERMD
  { 0, 0, 0, 0, 0 }, // 115 SLD_SRD_SRAD
  { 0, 0, 0, 0, 0 }, // 116 SRADI_EXTSWSLI_32_64_EXTSWSLI_SRADI_32_RLDIC
  { 0, 0, 0, 0, 0 }, // 117 MFVRD_MFVSRD_MTVRD_MTVSRD_MTVRWA_MTVRWZ_MTVSRWA_MTVSRWZ_MFVSRWZ_MFVRWZ
  { 1, 6, 11, 179, 182 }, // 118 CMPLW_CMPLWI_CMPW_CMPWI_CMPD_CMPDI_CMPLD_CMPLDI
  { 1, 6, 11, 182, 185 }, // 119 SUBFC_SUBFC8_SUBFC8O_SUBFCO_SUBFIC_SUBFIC8_ANDI8_rec_ANDIS8_rec_ANDIS_rec_ANDI_rec_ADDC_ADDC8_ADDC8O_ADDCO_ADDIC_ADDIC8_ADDIC_rec_ADDE_ADDE8_ADDE8O_ADDE8O_rec_ADDE8_rec_ADDEO_ADDEO_rec_ADDE_rec_ADDME_ADDME8_ADDME8O_ADDME8O_rec_ADDME8_rec_ADDMEO_ADDMEO_rec_ADDME_rec_ADDZE_ADDZE8_ADDZE8O_ADDZE8O_rec_ADDZE8_rec_ADDZEO_ADDZEO_rec_ADDZE_rec_SUBF_SUBF8_SUBF8O_SUBF8O_rec_SUBF8_rec_SUBFE_SUBFE8_SUBFE8O_SUBFE8O_rec_SUBFE8_rec_SUBFEO_SUBFEO_rec_SUBFE_rec_SUBFME_SUBFME8_SUBFME8O_SUBFME8O_rec_SUBFME8_rec_SUBFMEO_SUBFMEO_rec_SUBFME_rec_SUBFO_SUBFO_rec_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZE8O_rec_SUBFZE8_rec_SUBFZEO_SUBFZEO_rec_SUBFZE_rec_SUBF_rec_POPCNTB_POPCNTB8_LA_LA8
  { 1, 6, 11, 185, 188 }, // 120 ADD4_ADD4O_ADD4O_rec_ADD4_rec_ADD8_ADD8O_ADD8O_rec_ADD8_rec_NEG_NEG8_NEG8O_NEG8O_rec_NEG8_rec_NEGO_NEGO_rec_NEG_rec_ADDI_ADDI8_ADDIS_ADDIS8_LI_LI8_LIS_LIS8_OR_OR8_OR8_rec_ORI_ORI8_ORIS_ORIS8_OR_rec_XOR_XOR8_XOR8_rec_XORI_XORI8_XORIS_XORIS8_XOR_rec_NAND_NAND8_NAND8_rec_NAND_rec_AND_AND8_AND8_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_AND_rec_NOR_NOR8_NOR8_rec_NOR_rec_ORC_ORC8_ORC8_rec_ORC_rec_EQV_EQV8_EQV8_rec_EQV_rec_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_ADD4TLS_ADD8TLS_ADD8TLS__NOP
  { 0, 0, 0, 0, 0 }, // 121 ADDIStocHA_ADDIStocHA8_ADDItocL_COPY
  { 1, 11, 16, 188, 191 }, // 122 MCRF
  { 1, 11, 16, 191, 194 }, // 123 MCRXRX
  { 0, 0, 0, 0, 0 }, // 124 XSNABSDP_XSXEXPDP_XSABSDP_XSNEGDP_XSCPSGNDP
  { 1, 11, 16, 194, 196 }, // 125 RFEBB
  { 1, 81, 86, 196, 198 }, // 126 TBEGIN_TRECHKPT
  { 1, 21, 26, 198, 201 }, // 127 WAIT
  { 0, 0, 0, 0, 0 }, // 128 RLDCL_RLDCR
  { 1, 6, 11, 201, 204 }, // 129 RLWIMI_RLWIMI8
  { 0, 0, 0, 0, 0 }, // 130 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32_RLDIMI
  { 0, 0, 0, 0, 0 }, // 131 MFOCRF_MFOCRF8
  { 1, 11, 16, 204, 207 }, // 132 MTOCRF_MTOCRF8
  { 1, 11, 16, 207, 210 }, // 133 CR6SET_CR6UNSET_CRSET_CRUNSET_CRAND_CRANDC_CRNAND_CRNOR_CROR_CRORC_CREQV_CRXOR
  { 1, 6, 11, 210, 213 }, // 134 SLW_SLW8_SRW_SRW8_RLWINM_RLWINM8_RLWNM_RLWNM8
  { 1, 31, 40, 213, 216 }, // 135 FABSD_FABSS_FNABSD_FNABSS_FNEGD_FNEGS_FCPSGND_FCPSGNS_FMR
  { 1, 6, 11, 216, 219 }, // 136 SRAW_SRAWI
  { 1, 6, 11, 219, 223 }, // 137 ISEL_ISEL8
  { 0, 0, 0, 0, 0 }, // 138 XSIEXPDP
  { 1, 81, 86, 223, 225 }, // 139 TRECLAIM_TSR_TABORT
  { 1, 21, 26, 225, 228 }, // 140 MFVSCR
  { 1, 21, 26, 228, 231 }, // 141 MTVSCR
  { 0, 0, 0, 0, 0 }, // 142 VCMPNEZB_VCMPNEZH_VCMPNEZW_VCMPEQUB_VCMPEQUD_VCMPEQUH_VCMPEQUW_VCMPNEB_VCMPNEH_VCMPNEW_VCMPEQFP_VCMPEQFP_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPBFP_VCMPBFP_rec_VCMPGTSB_VCMPGTSB_rec_VCMPGTSD_VCMPGTSD_rec_VCMPGTSH_VCMPGTSH_rec_VCMPGTSW_VCMPGTSW_rec_VCMPGTUB_VCMPGTUB_rec_VCMPGTUD_VCMPGTUD_rec_VCMPGTUH_VCMPGTUH_rec_VCMPGTUW_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 0, 0, 0, 0, 0 }, // 143 VABSDUB_VABSDUH_VABSDUW_VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTW_VPOPCNTD_VPRTYBD_VPRTYBW
  { 0, 0, 0, 0, 0 }, // 144 VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VADDSBS_VADDSHS_VADDSWS_VMAXFP_VMINFP_VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW_VBPERMD_VADDCUW_VSHASIGMAD_VSHASIGMAW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_VSUBCUW_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP_XVXSIGDP_XVXSIGSP
  { 1, 31, 40, 231, 234 }, // 145 XVTDIVDP_XVTDIVSP_XVTSQRTDP_XVTSQRTSP
  { 0, 0, 0, 0, 0 }, // 146 VADDFP_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VEXPTEFP_VLOGEFP_VMADDFP_VMHADDSHS_VNMSUBFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVADDDP_XVADDSP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVHPSP_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVMULDP_XVMULSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP_XVSUBDP_XVSUBSP_VCFSX_VCFSX_0_VCFUX_VCFUX_0_VMHRADDSHS_VMLADDUHM_VMSUMMBM_VMSUMSHM_VMSUMSHS_VMSUMUBM_VMSUMUHM_VMSUMUDM_VMSUMUHS_VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS_VSUMSWS
  { 0, 0, 0, 0, 0 }, // 147 VSUBFP_VMULUWM
  { 0, 0, 0, 0, 0 }, // 148 MADDHD_MADDHDU_MADDLD_MADDLD8_MULLD_MULLDO
  { 1, 11, 16, 234, 237 }, // 149 MULHD_MULHW_MULLW_MULLWO
  { 1, 11, 16, 237, 240 }, // 150 MULHDU_MULHWU
  { 1, 11, 16, 240, 243 }, // 151 MULLI_MULLI8
  { 1, 31, 40, 243, 246 }, // 152 FRSP_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRE_FRES_FADDS_FMSUBS_FMADDS_FSUBS_FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRSQRTE_FRSQRTES_FNMADDS_FNMSUBS_FSELD_FSELS_FMULS
  { 1, 31, 40, 246, 249 }, // 153 FADD_FSUB
  { 1, 31, 40, 249, 253 }, // 154 FMSUB_FMADD_FNMADD_FNMSUB_FMUL
  { 0, 0, 0, 0, 0 }, // 155 XSMADDADP_XSMADDASP_XSMADDMDP_XSMADDMSP_XSMSUBADP_XSMSUBASP_XSMSUBMDP_XSMSUBMSP_XSMULDP_XSMULSP_XSNMADDADP_XSNMADDASP_XSNMADDMDP_XSNMADDMSP_XSNMSUBADP_XSNMSUBASP_XSNMSUBMDP_XSNMSUBMSP
  { 1, 31, 40, 253, 256 }, // 156 FSELD_rec_FSELS_rec
  { 1, 11, 16, 256, 259 }, // 157 MULHDU_rec_MULHWU_rec
  { 1, 11, 16, 259, 262 }, // 158 MULHD_rec_MULHW_rec_MULLWO_rec_MULLW_rec
  { 0, 0, 0, 0, 0 }, // 159 MULLDO_rec_MULLD_rec
  { 1, 31, 40, 262, 265 }, // 160 FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRES_rec_FRE_rec_FADDS_rec_FSUBS_rec_FMSUBS_rec_FNMSUBS_rec_FMADDS_rec_FNMADDS_rec_FCFIDS_rec_FCFIDUS_rec_FCFIDU_rec_FCFID_rec_FCTIDUZ_rec_FCTIDU_rec_FCTIDZ_rec_FCTID_rec_FCTIWUZ_rec_FCTIWU_rec_FCTIWZ_rec_FCTIW_rec_FMULS_rec_FRSQRTES_rec_FRSQRTE_rec_FRSP_rec
  { 1, 31, 40, 265, 268 }, // 161 FADD_rec_FSUB_rec
  { 1, 31, 40, 268, 272 }, // 162 FMSUB_rec_FNMSUB_rec_FMADD_rec_FNMADD_rec_FMUL_rec
  { 0, 0, 0, 0, 0 }, // 163 XSADDDP_XSADDSP_XSCVDPHP_XSCVDPSP_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPSXWSs_XSCVDPUXWSs_XSCVHPDP_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSQRTEDP_XSRSQRTESP_XSSUBDP_XSSUBSP_XSCVDPSPN_XSRSP
  { 1, 21, 26, 272, 275 }, // 164 LVSL_LVSR
  { 0, 0, 0, 0, 0 }, // 165 VSPLTISB_VSPLTISH_VSPLTISW_VSPLTB_VSPLTBs_VSPLTH_VSPLTHs_VSPLTW_XXMRGHW_XXMRGLW_XXPERM_XXPERMR_XXSLDWI_XXSLDWIs_XXSPLTIB_XXSPLTW_XXSPLTWs_XXPERMDI_XXPERMDIs
  { 0, 0, 0, 0, 0 }, // 166 V_SETALLONES_V_SETALLONESB_V_SETALLONESH_VBPERMQ_VGBBD_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPERM_VPERMR_VPERMXOR_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLDOI_VSLO_VSLV_VSR_VSRO_VSRV_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW_XXEXTRACTUW_XXINSERTW_VADDCUQ_VADDECUQ_VADDEUQM_VMUL10CUQ_VMUL10ECUQ_VMUL10EUQ_VMUL10UQ_VSUBCUQ_VSUBECUQ_VSUBEUQM_XSTSTDCQP_XSXSIGQP_BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDS_rec_BCDTRUNC_rec_BCDUS_rec_BCDUTRUNC_rec_BCDADD_rec_BCDSUB_rec
  { 0, 0, 0, 0, 0 }, // 167 VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VINSERTB_VINSERTD_VINSERTH_VINSERTW_MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VEXTRACTD_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VPRTYBQ_VADDUQM_VSUBUQM
  { 1, 31, 40, 275, 278 }, // 168 XSCMPEXPQP_XSCMPOQP_XSCMPUQP
  { 0, 0, 0, 0, 0 }, // 169 BCDSR_rec_XSADDQP_XSADDQPO_XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP_XSRQPI_XSRQPIX_XSRQPXP_XSSUBQP_XSSUBQPO
  { 0, 0, 0, 0, 0 }, // 170 BCDCTSQ_rec
  { 0, 0, 0, 0, 0 }, // 171 XSMADDQP_XSMADDQPO_XSMSUBQP_XSMSUBQPO_XSMULQP_XSMULQPO_XSNMADDQP_XSNMADDQPO_XSNMSUBQP_XSNMSUBQPO
  { 0, 0, 0, 0, 0 }, // 172 BCDCFSQ_rec
  { 0, 0, 0, 0, 0 }, // 173 XSDIVQP_XSDIVQPO
  { 0, 0, 0, 0, 0 }, // 174 XSSQRTQP_XSSQRTQPO
  { 1, 21, 26, 278, 281 }, // 175 LXVL_LXVLL
  { 1, 21, 26, 281, 284 }, // 176 LVEBX_LVEHX_LVEWX_LVX_LVXL
  { 1, 21, 26, 284, 287 }, // 177 LXSIBZX_LXSIHZX_LXSDX_LXVB16X_LXVD2X_LXVWSX_LXSIWZX_LXV_LXVX_LXSD
  { 0, 0, 0, 0, 0 }, // 178 DFLOADf64_XFLOADf64_LIWZX
  { 1, 16, 21, 287, 289 }, // 179 DCBF_DCBFEP_DCBST_DCBSTEP_DCBT_DCBTEP_DCBZ_DCBZEP_DCBZL_DCBZLEP_DCBTST_DCBTSTEP
  { 0, 0, 0, 0, 0 }, // 180 CP_COPY_CP_COPY8
  { 1, 16, 21, 289, 292 }, // 181 ICBI_ICBIEP
  { 1, 21, 26, 292, 295 }, // 182 ICBT_ICBTLS_LBZ_LBZ8_LBZCIX_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LDBRX_LDCIX_LHBRX_LHBRX8_LHZ_LHZ8_LHZCIX_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWBRX_LWBRX8_LWZ_LWZ8_LWZCIX_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32_EnforceIEIO_LSWI
  { 1, 74, 81, 295, 298 }, // 183 LBARX_LBARXL_LHARX_LHARXL_LWARX_LWARXL
  { 0, 0, 0, 0, 0 }, // 184 LD_LDX_LDXTLS_LDXTLS__DARN
  { 0, 0, 0, 0, 0 }, // 185 LDARX_LDARXL
  { 0, 0, 0, 0, 0 }, // 186 CP_ABORT
  { 1, 58, 74, 0, 0 }, // 187 ISYNC
  { 0, 0, 0, 0, 0 }, // 188 MSGSYNC
  { 1, 11, 16, 0, 0 }, // 189 TLBSYNC
  { 1, 1, 6, 0, 0 }, // 190 SYNC
  { 1, 16, 21, 298, 301 }, // 191 LMW
  { 1, 21, 26, 301, 304 }, // 192 LFIWZX_LFDX_LFD
  { 0, 0, 0, 0, 0 }, // 193 SLBIA
  { 0, 0, 0, 0, 0 }, // 194 SLBIE
  { 0, 0, 0, 0, 0 }, // 195 SLBMFEE
  { 0, 0, 0, 0, 0 }, // 196 SLBMFEV
  { 0, 0, 0, 0, 0 }, // 197 SLBMTE
  { 0, 0, 0, 0, 0 }, // 198 TLBIEL
  { 1, 21, 26, 304, 308 }, // 199 LHZU_LHZU8_LWZU_LWZU8
  { 1, 21, 26, 308, 312 }, // 200 LHZUX_LHZUX8_LWZUX_LWZUX8
  { 1, 81, 86, 312, 314 }, // 201 TEND
  { 1, 74, 81, 314, 317 }, // 202 STBCX_STHCX_STWCX
  { 1, 74, 81, 317, 320 }, // 203 STDCX
  { 0, 0, 0, 0, 0 }, // 204 LDMX
  { 1, 16, 21, 320, 323 }, // 205 LHA_LHA8_LHAX_LHAX8_LWAX_LWAX_32
  { 0, 0, 0, 0, 0 }, // 206 CP_PASTE8_rec_CP_PASTE_rec
  { 0, 0, 0, 0, 0 }, // 207 LWA_LWA_32
  { 1, 81, 86, 323, 325 }, // 208 TCHECK
  { 1, 21, 26, 325, 328 }, // 209 LFIWAX
  { 1, 21, 26, 328, 331 }, // 210 LXSIWAX
  { 0, 0, 0, 0, 0 }, // 211 LIWAX
  { 1, 21, 26, 331, 334 }, // 212 LFSX_LFS
  { 1, 21, 26, 334, 337 }, // 213 LXSSP_LXSSPX
  { 0, 0, 0, 0, 0 }, // 214 XFLOADf32_DFLOADf32
  { 1, 16, 21, 337, 340 }, // 215 LHAU_LHAU8
  { 1, 16, 21, 340, 343 }, // 216 LHAUX_LHAUX8_LWAUX
  { 1, 21, 26, 343, 346 }, // 217 LXVH8X_LXVDSX_LXVW4X
  { 1, 16, 21, 346, 349 }, // 218 STFD_STFDX_STFIWX_STFS_STFSX_STXSD_STXSDX_STXSIBX_STXSIBXv_STXSIHX_STXSIHXv_STXSIWX_STXSSP_STXSSPX
  { 1, 21, 26, 349, 352 }, // 219 STW_STW8_STDBRX_STHBRX_STWBRX_STB_STB8_STH_STH8_STBX_STBX8_STBXTLS_STBXTLS__STBXTLS_32_STHX_STHX8_STHXTLS_STHXTLS__STHXTLS_32_STWX_STWX8_STWXTLS_STWXTLS__STWXTLS_32
  { 0, 0, 0, 0, 0 }, // 220 DFSTOREf32_DFSTOREf64_XFSTOREf32_XFSTOREf64_STIWX
  { 1, 21, 26, 352, 355 }, // 221 STD_STDX_STDXTLS_STDXTLS_
  { 1, 21, 26, 355, 358 }, // 222 STBCIX_STDCIX_STHCIX_STWCIX_STSWI
  { 0, 0, 0, 0, 0 }, // 223 SLBIEG
  { 1, 16, 21, 358, 361 }, // 224 STMW
  { 0, 0, 0, 0, 0 }, // 225 TLBIE
  { 1, 21, 26, 361, 364 }, // 226 STVEBX_STVEHX_STVEWX_STVX_STVXL
  { 1, 16, 21, 364, 367 }, // 227 STXV_STXVB16X_STXVD2X_STXVH8X_STXVW4X_STXVX
  { 1, 21, 26, 367, 370 }, // 228 STXVL_STXVLL
  { 1, 81, 86, 370, 372 }, // 229 MTCTR_MTCTR8_MTCTR8loop_MTCTRloop_MTLR_MTLR8
  { 1, 6, 11, 372, 375 }, // 230 MFVRSAVE_MFVRSAVEv_MTVRSAVE_MTVRSAVEv
  { 0, 0, 0, 0, 0 }, // 231 MFPMR
  { 0, 0, 0, 0, 0 }, // 232 MTPMR
  { 1, 81, 86, 375, 377 }, // 233 MFTB_MFTB8
  { 1, 81, 86, 377, 379 }, // 234 MFCTR_MFCTR8_MFLR_MFLR8_MFSPR_MFSPR8
  { 1, 11, 16, 379, 381 }, // 235 MFMSR
  { 1, 11, 16, 381, 383 }, // 236 MTMSR
  { 0, 0, 0, 0, 0 }, // 237 MTMSRD
  { 1, 81, 86, 383, 385 }, // 238 MTSPR_MTSPR8
  { 1, 26, 31, 385, 388 }, // 239 DIVW_DIVWO_DIVWU_DIVWUO_MODSW
  { 1, 26, 31, 388, 391 }, // 240 DIVWE_DIVWEO_DIVWEU_DIVWEUO_MODSD_MODUD_MODUW
  { 0, 0, 0, 0, 0 }, // 241 DIVD_DIVDO_DIVDU_DIVDUO
  { 0, 0, 0, 0, 0 }, // 242 DIVDE_DIVDEO_DIVDEU_DIVDEUO
  { 1, 26, 31, 391, 394 }, // 243 DIVWO_rec_DIVWUO_rec_DIVWU_rec_DIVW_rec
  { 0, 0, 0, 0, 0 }, // 244 DIVD_rec_DIVDO_rec_DIVDU_rec_DIVDUO_rec
  { 1, 26, 31, 394, 397 }, // 245 DIVWE_rec_DIVWEO_rec_DIVWEU_rec_DIVWEUO_rec
  { 0, 0, 0, 0, 0 }, // 246 DIVDE_rec_DIVDEO_rec_DIVDEU_rec_DIVDEUO_rec
  { 1, 11, 16, 397, 400 }, // 247 MTCRF_MTCRF8
  { 1, 6, 11, 400, 403 }, // 248 ADDC8O_rec_ADDC8_rec_ADDCO_rec_ADDC_rec_SUBFC8O_rec_SUBFC8_rec_SUBFCO_rec_SUBFC_rec
  { 1, 31, 40, 403, 406 }, // 249 FABSD_rec_FABSS_rec_FNABSD_rec_FNABSS_rec_FCPSGND_rec_FCPSGNS_rec_FNEGD_rec_FNEGS_rec_FMR_rec
  { 1, 11, 16, 406, 409 }, // 250 MCRFS
  { 1, 11, 16, 409, 412 }, // 251 MTFSF_MTFSF_rec_MTFSFI_MTFSFI_rec_MTFSFIb
  { 1, 11, 16, 412, 415 }, // 252 MTFSFb
  { 0, 0, 0, 0, 0 }, // 253 RLDCL_rec_RLDCR_rec
  { 0, 0, 0, 0, 0 }, // 254 RLDICL_rec_RLDICR_rec_RLDICL_32_rec_RLDIMI_rec
  { 1, 6, 11, 415, 418 }, // 255 RLWIMI8_rec_RLWIMI_rec
  { 1, 6, 11, 418, 421 }, // 256 RLWINM8_rec_RLWINM_rec_RLWNM8_rec_RLWNM_rec_SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 1, 6, 11, 421, 424 }, // 257 SRAWI_rec_SRAW_rec
  { 1, 11, 16, 424, 427 }, // 258 MFFS_MFFSCE_MFFSL_MFFS_rec
  { 1, 11, 16, 427, 429 }, // 259 MFCR_MFCR8
  { 0, 0, 0, 0, 0 }, // 260 EXTSWSLI_32_64_rec_SRADI_rec_EXTSWSLI_rec_RLDIC_rec
  { 0, 0, 0, 0, 0 }, // 261 SRAD_rec_SLD_rec_SRD_rec
  { 1, 40, 49, 429, 432 }, // 262 FDIV
  { 1, 40, 49, 432, 435 }, // 263 FDIV_rec
  { 0, 0, 0, 0, 0 }, // 264 XSSQRTDP
  { 0, 0, 0, 0, 0 }, // 265 FSQRT
  { 0, 0, 0, 0, 0 }, // 266 XVSQRTDP
  { 0, 0, 0, 0, 0 }, // 267 XVSQRTSP
  { 0, 0, 0, 0, 0 }, // 268 FSQRT_rec
  { 0, 0, 0, 0, 0 }, // 269 XSSQRTSP
  { 0, 0, 0, 0, 0 }, // 270 FSQRTS
  { 0, 0, 0, 0, 0 }, // 271 FSQRTS_rec
  { 1, 40, 49, 435, 438 }, // 272 XSDIVDP
  { 1, 49, 58, 438, 441 }, // 273 FDIVS
  { 1, 49, 58, 441, 444 }, // 274 FDIVS_rec
  { 1, 49, 58, 444, 447 }, // 275 XSDIVSP
  { 1, 49, 58, 447, 450 }, // 276 XVDIVSP
  { 1, 40, 49, 450, 453 }, // 277 XVDIVDP
  { 1, 16, 21, 453, 457 }, // 278 LFSU
  { 1, 16, 21, 457, 461 }, // 279 LFSUX
  { 1, 16, 21, 461, 465 }, // 280 STFDU_STFDUX_STFSU_STFSUX
  { 1, 21, 26, 465, 469 }, // 281 STBU_STBU8_STDU_STHU_STHU8_STWU_STWU8
  { 1, 21, 26, 469, 473 }, // 282 STBUX_STBUX8_STDUX_STHUX_STHUX8_STWUX_STWUX8
  { 1, 21, 26, 473, 477 }, // 283 LBZU_LBZU8
  { 1, 21, 26, 477, 481 }, // 284 LBZUX_LBZUX8
  { 0, 0, 0, 0, 0 }, // 285 LDU
  { 0, 0, 0, 0, 0 }, // 286 LDUX
  { 1, 16, 21, 481, 485 }, // 287 LFDU
  { 1, 16, 21, 485, 489 }, // 288 LFDUX
  { 0, 0, 0, 0, 0 }, // 289 VPMSUMB_VPMSUMD_VPMSUMH_VPMSUMW_VCIPHER_VCIPHERLAST_VNCIPHER_VNCIPHERLAST_VSBOX
  { 1, 11, 16, 489, 491 }, // 290 BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_BCCTR_BCCTR8_BCCTR8n_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_BCCTRn_BDNZ_BDNZ8_BDNZA_BDNZAm_BDNZAp_BDNZm_BDNZp_BDZ_BDZ8_BDZA_BDZAm_BDZAp_BDZm_BDZp_BDNZL_BDNZLA_BDNZLAm_BDNZLAp_BDNZLR_BDNZLR8_BDNZLRL_BDNZLRLm_BDNZLRLp_BDNZLRm_BDNZLRp_BDNZLm_BDNZLp_BDZL_BDZLA_BDZLAm_BDZLAp_BDZLR_BDZLR8_BDZLRL_BDZLRLm_BDZLRLp_BDZLRm_BDZLRp_BDZLm_BDZLp_BL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM_BLR_BLR8_BLRL_TAILB_TAILB8_TAILBA_TAILBA8_TAILBCTR_TAILBCTR8_gBC_gBCA_gBCAat_gBCCTR_gBCCTRL_gBCL_gBCLA_gBCLAat_gBCLR_gBCLRL_gBCLat_gBCat_BCLR_BCLRL_BCLRLn_BCLRn_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_RM_BCTRL_RM_B_BA_BC_BCC_BCCA_BCL_BCLalways_BCLn_BCTRL8_LDinto_toc_BCTRL_LWZinto_toc_BCTRL8_LDinto_toc_RM_BCTRL_LWZinto_toc_RM_BCn_CTRL_DEP
  { 1, 11, 16, 491, 493 }, // 291 ADDPCIS
  { 1, 21, 26, 493, 496 }, // 292 LDAT_LWAT
  { 1, 21, 26, 496, 499 }, // 293 STDAT_STWAT
  { 1, 6, 11, 499, 502 }, // 294 BRINC
  { 0, 0, 0, 0, 0 }, // 295 EVABS_EVEQV_EVNAND_EVNEG_EVADDIW_EVADDW_EVAND_EVANDC_EVCMPEQ_EVCMPGTS_EVCMPGTU_EVCMPLTS_EVCMPLTU_EVCNTLSW_EVCNTLZW_EVEXTSB_EVEXTSH_EVMERGEHI_EVMERGEHILO_EVMERGELO_EVMERGELOHI_EVNOR_EVOR_EVORC_EVXOR_EVRLW_EVRLWI_EVRNDW_EVSLW_EVSLWI_EVSPLATFI_EVSPLATI_EVSRWIS_EVSRWIU_EVSRWS_EVSRWU_EVSUBFW_EVSUBIFW
  { 0, 0, 0, 0, 0 }, // 296 EVMRA_EVADDSMIAAW_EVADDSSIAAW_EVADDUMIAAW_EVADDUSIAAW_EVDIVWS_EVDIVWU_EVMHEGSMFAA_EVMHEGSMFAN_EVMHEGSMIAA_EVMHEGSMIAN_EVMHEGUMIAA_EVMHEGUMIAN_EVMHESMF_EVMHESMFA_EVMHESMFAAW_EVMHESMFANW_EVMHESMI_EVMHESMIA_EVMHESMIAAW_EVMHESMIANW_EVMHESSF_EVMHESSFA_EVMHESSFAAW_EVMHESSFANW_EVMHESSIAAW_EVMHESSIANW_EVMHEUMI_EVMHEUMIA_EVMHEUMIAAW_EVMHEUMIANW_EVMHEUSIAAW_EVMHEUSIANW_EVMHOGSMFAA_EVMHOGSMFAN_EVMHOGSMIAA_EVMHOGSMIAN_EVMHOGUMIAA_EVMHOGUMIAN_EVMHOSMF_EVMHOSMFA_EVMHOSMFAAW_EVMHOSMFANW_EVMHOSMI_EVMHOSMIA_EVMHOSMIAAW_EVMHOSMIANW_EVMHOSSF_EVMHOSSFA_EVMHOSSFAAW_EVMHOSSFANW_EVMHOSSIAAW_EVMHOSSIANW_EVMHOUMI_EVMHOUMIA_EVMHOUMIAAW_EVMHOUMIANW_EVMHOUSIAAW_EVMHOUSIANW_EVMWHSMF_EVMWHSMFA_EVMWHSMI_EVMWHSMIA_EVMWHSSF_EVMWHSSFA_EVMWHUMI_EVMWHUMIA_EVMWLSMIAAW_EVMWLSMIANW_EVMWLSSIAAW_EVMWLSSIANW_EVMWLUMI_EVMWLUMIA_EVMWLUMIAAW_EVMWLUMIANW_EVMWLUSIAAW_EVMWLUSIANW_EVMWSMF_EVMWSMFA_EVMWSMFAA_EVMWSMFAN_EVMWSMI_EVMWSMIA_EVMWSMIAA_EVMWSMIAN_EVMWSSF_EVMWSSFA_EVMWSSFAA_EVMWSSFAN_EVMWUMI_EVMWUMIA_EVMWUMIAA_EVMWUMIAN_EVSUBFSMIAAW_EVSUBFSSIAAW_EVSUBFUMIAAW_EVSUBFUSIAAW
  { 1, 21, 26, 502, 505 }, // 297 EVLDD_EVLDDX_EVLDH_EVLDHX_EVLDW_EVLDWX_EVLHHESPLAT_EVLHHESPLATX_EVLHHOSSPLAT_EVLHHOSSPLATX_EVLHHOUSPLAT_EVLHHOUSPLATX_EVLWHE_EVLWHEX_EVLWHOS_EVLWHOSX_EVLWHOU_EVLWHOUX_EVLWHSPLAT_EVLWHSPLATX_EVLWWSPLAT_EVLWWSPLATX
  { 1, 21, 26, 505, 508 }, // 298 EVSTDD_EVSTDDX_EVSTDH_EVSTDHX_EVSTDW_EVSTDWX_EVSTWHE_EVSTWHEX_EVSTWHO_EVSTWHOX_EVSTWWE_EVSTWWEX_EVSTWWO_EVSTWWOX
  { 1, 11, 16, 508, 510 }, // 299 HRFID_ATTN_CLRBHRB_MFBHRBE_NAP_RFCI_RFDI_RFMCI_SC
  { 1, 11, 16, 510, 512 }, // 300 RFI
  { 0, 0, 0, 0, 0 }, // 301 RFID
  { 1, 21, 26, 512, 515 }, // 302 DSS_DSSALL_DST_DST64_DSTST_DSTST64_DSTSTT_DSTSTT64_DSTT_DSTT64_ICBLQ_LBEPX_LHEPX_LWEPX_TLBIVAX_TLBLD_TLBLI_TLBRE_TLBRE2_TLBSX_TLBSX2_TLBSX2D_TLBWE_TLBWE2_MBAR_TRAP_DCCCI_ICCCI
  { 1, 21, 26, 515, 518 }, // 303 ICBLC_STBEPX_STHEPX_STWEPX
  { 1, 21, 26, 518, 521 }, // 304 LFDEPX
  { 1, 16, 21, 521, 524 }, // 305 STFDEPX
  { 1, 11, 16, 524, 526 }, // 306 MFSR_MFSRIN
  { 1, 81, 86, 526, 528 }, // 307 MTSR_MTSRIN
  { 1, 81, 86, 528, 530 }, // 308 MFDCR
  { 1, 81, 86, 530, 532 }, // 309 MTDCR
  { 1, 6, 11, 532, 535 }, // 310 NOP_GT_PWR6_NOP_GT_PWR7
  { 0, 0, 0, 0, 0 }, // 311 TLBIA
  { 1, 11, 16, 535, 537 }, // 312 WRTEE_WRTEEI
  { 1, 6, 11, 537, 540 }, // 313 HASHCHK_HASHCHK8_HASHCHKP_HASHCHKP8_HASHST_HASHST8_HASHSTP_HASHSTP8_ADDEX_ADDEX8
  { 1, 1, 6, 0, 0 }, // 314 MSYNC
  { 0, 0, 0, 0, 0 }, // 315 SLBSYNC
  { 0, 0, 0, 0, 0 }, // 316 SLBFEE_rec
  { 0, 0, 0, 0, 0 }, // 317 STOP
  { 1, 16, 21, 540, 542 }, // 318 DCBA_DCBI
  { 1, 31, 40, 542, 545 }, // 319 FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRE_FRES_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRSP_FRSQRTE_FRSQRTES
  { 0, 0, 0, 0, 0 }, // 320 VCFSX_VCFSX_0_VCFUX_VCFUX_0_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VLOGEFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP
  { 0, 0, 0, 0, 0 }, // 321 XSCVDPHP_XSCVDPSP_XSCVDPSPN_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPSXWSs_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPUXWSs_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSP_XSRSQRTEDP_XSRSQRTESP
  { 0, 0, 0, 0, 0 }, // 322 XVCVSPBF16
  { 1, 31, 40, 545, 548 }, // 323 FADDS_FMULS_FSUBS
  { 1, 31, 40, 548, 552 }, // 324 FMUL
  { 0, 0, 0, 0, 0 }, // 325 VADDFP_XVADDDP_XVADDSP_XVMULDP_XVMULSP_XVSUBDP_XVSUBSP
  { 0, 0, 0, 0, 0 }, // 326 VSUBFP
  { 0, 0, 0, 0, 0 }, // 327 XSADDDP_XSADDSP_XSSUBDP_XSSUBSP
  { 0, 0, 0, 0, 0 }, // 328 XSMULDP_XSMULSP
  { 0, 0, 0, 0, 0 }, // 329 VMADDFP_VNMSUBFP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP
  { 0, 0, 0, 0, 0 }, // 330 VEXPTEFP
  { 1, 31, 40, 552, 555 }, // 331 FADDS_rec_FMULS_rec_FSUBS_rec
  { 1, 31, 40, 555, 559 }, // 332 FMUL_rec
  { 1, 31, 40, 559, 562 }, // 333 FCFID_rec_FCFIDS_rec_FCFIDU_rec_FCFIDUS_rec_FCTID_rec_FCTIDU_rec_FCTIDUZ_rec_FCTIDZ_rec_FCTIW_rec_FCTIWU_rec_FCTIWUZ_rec_FCTIWZ_rec_FRE_rec_FRES_rec_FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRSP_rec_FRSQRTE_rec_FRSQRTES_rec
  { 1, 11, 16, 562, 564 }, // 334 BCLR_BCLRn_BDNZLR_BDNZLR8_BDNZLRm_BDNZLRp_BDZLR_BDZLR8_BDZLRm_BDZLRp_gBCLR_BCLRL_BCLRLn_BDNZLRL_BDNZLRLm_BDNZLRLp_BDZLRL_BDZLRLm_BDZLRLp_gBCLRL_BL_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLR_BLR8_BLRL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS
  { 1, 11, 16, 564, 566 }, // 335 BL8_NOTOC_BL8_NOTOC_RM_BL8_NOTOC_TLS
  { 1, 11, 16, 566, 568 }, // 336 B_BCC_BCCA_BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_CTRL_DEP_TAILB_TAILB8_BA_TAILBA_TAILBA8_BC_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_LDinto_toc_BCTRL8_LDinto_toc_RM_BCTRL8_RM_BCTRL_LWZinto_toc_BCTRL_LWZinto_toc_RM_BCTRL_RM_BCn_BDNZ_BDNZ8_BDNZm_BDNZp_BDZ_BDZ8_BDZm_BDZp_TAILBCTR_TAILBCTR8_gBC_gBCat_BCL_BCLalways_BCLn_BDNZL_BDNZLm_BDNZLp_BDZL_BDZLm_BDZLp_gBCL_gBCLat_BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM
  { 1, 11, 16, 568, 570 }, // 337 BCCTR_BCCTR8_BCCTR8n_BCCTRn_gBCCTR_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_gBCCTRL
  { 0, 0, 0, 0, 0 }, // 338 VSBOX
  { 1, 6, 11, 570, 573 }, // 339 CFUGED_CNTLZDM_CNTTZDM_PDEPD_PEXTD
  { 0, 0, 0, 0, 0 }, // 340 VCFUGED_VCLZDM_VCTZDM_VGNB_VPDEPD_VPEXTD
  { 0, 0, 0, 0, 0 }, // 341 XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP
  { 0, 0, 0, 0, 0 }, // 342 XSCVQPSQZ_XSCVQPUQZ_XSCVSQQP_XSCVUQQP
  { 0, 0, 0, 0, 0 }, // 343 XSADDQP_XSADDQPO_XSSUBQP_XSSUBQPO
  { 1, 6, 11, 573, 576 }, // 344 HASHST_HASHST8_HASHSTP_HASHSTP8
  { 0, 0, 0, 0, 0 }, // 345 XSMULQP_XSMULQPO
  { 0, 0, 0, 0, 0 }, // 346 VDIVESQ_VDIVEUQ_VDIVSQ_VDIVUQ
  { 0, 0, 0, 0, 0 }, // 347 VMODSQ_VMODUQ
  { 1, 26, 31, 576, 579 }, // 348 DIVWE_DIVWEO_DIVWEU_DIVWEUO
  { 0, 0, 0, 0, 0 }, // 349 VDIVSD_VDIVUD
  { 0, 0, 0, 0, 0 }, // 350 VMODSD_VMODUD
  { 0, 0, 0, 0, 0 }, // 351 VDIVSW_VDIVUW
  { 0, 0, 0, 0, 0 }, // 352 VMODSW_VMODUW
  { 0, 0, 0, 0, 0 }, // 353 VDIVESD_VDIVEUD
  { 0, 0, 0, 0, 0 }, // 354 VDIVESW_VDIVEUW
  { 0, 0, 0, 0, 0 }, // 355 BCDCTN_rec_VMUL10CUQ_VMUL10UQ_XSXSIGQP
  { 0, 0, 0, 0, 0 }, // 356 BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDUS_rec_BCDUTRUNC_rec_VADDCUQ_VMUL10ECUQ_VMUL10EUQ_VSUBCUQ_XSTSTDCQP
  { 0, 0, 0, 0, 0 }, // 357 VADDUQM_VSUBUQM
  { 0, 0, 0, 0, 0 }, // 358 XSMAXCQP_XSMINCQP
  { 0, 0, 0, 0, 0 }, // 359 XXGENPCVBM
  { 0, 0, 0, 0, 0 }, // 360 BCDADD_rec_BCDS_rec_BCDSUB_rec_BCDTRUNC_rec_VADDECUQ_VADDEUQM_VSUBECUQ_VSUBEUQM
  { 1, 21, 26, 579, 582 }, // 361 TRAP
  { 1, 11, 16, 582, 584 }, // 362 TW
  { 1, 6, 11, 584, 587 }, // 363 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW
  { 1, 31, 40, 587, 590 }, // 364 FTSQRT
  { 0, 0, 0, 0, 0 }, // 365 MTVSRBM_MTVSRBMI_MTVSRDM_MTVSRHM_MTVSRQM_MTVSRWM_VEXPANDBM_VEXPANDDM_VEXPANDHM_VEXPANDQM_VEXPANDWM_VEXTRACTBM_VEXTRACTDM_VEXTRACTHM_VEXTRACTQM_VEXTRACTWM_XVTLSBB
  { 1, 6, 11, 590, 593 }, // 366 POPCNTB_POPCNTB8
  { 0, 0, 0, 0, 0 }, // 367 VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTD_VPOPCNTW_VPRTYBD_VPRTYBW
  { 0, 0, 0, 0, 0 }, // 368 VPOPCNTB_VPOPCNTH
  { 0, 0, 0, 0, 0 }, // 369 XSCVSPDPN
  { 1, 31, 40, 593, 596 }, // 370 XSTSQRTDP
  { 0, 0, 0, 0, 0 }, // 371 XVCVHPSP
  { 1, 31, 40, 596, 599 }, // 372 XVTSQRTDP_XVTSQRTSP
  { 1, 6, 11, 599, 602 }, // 373 CMPEQB
  { 0, 0, 0, 0, 0 }, // 374 EXTSWSLI_32_64_rec_EXTSWSLI_rec
  { 0, 0, 0, 0, 0 }, // 375 SLD_rec_SRD_rec
  { 1, 6, 11, 602, 605 }, // 376 SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 0, 0, 0, 0, 0 }, // 377 VADDCUW_VADDSBS_VADDSHS_VADDSWS_VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VMAXFP_VMINFP_VSUBCUW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP
  { 0, 0, 0, 0, 0 }, // 378 VCMPBFP_VCMPBFP_rec_VCMPEQFP_VCMPEQFP_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPGTSB_rec_VCMPGTSD_rec_VCMPGTSH_rec_VCMPGTSW_rec_VCMPGTUB_rec_VCMPGTUD_rec_VCMPGTUH_rec_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 0, 0, 0, 0, 0 }, // 379 VCMPEQUQ_VCMPEQUQ_rec_VCMPGTSQ_VCMPGTSQ_rec_VCMPGTUQ_VCMPGTUQ_rec
  { 0, 0, 0, 0, 0 }, // 380 VCMPSQ_VCMPUQ_VCNTMBB_VCNTMBD_VCNTMBH_VCNTMBW
  { 0, 0, 0, 0, 0 }, // 381 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP
  { 0, 0, 0, 0, 0 }, // 382 RLDIC_rec
  { 0, 0, 0, 0, 0 }, // 383 RLDICL_32_rec_RLDICL_rec_RLDICR_rec
  { 0, 0, 0, 0, 0 }, // 384 VSHASIGMAD_VSHASIGMAW
  { 0, 0, 0, 0, 0 }, // 385 VRLQ_VRLQNM_VSLQ_VSRAQ_VSRQ
  { 0, 0, 0, 0, 0 }, // 386 VRLQMI
  { 1, 11, 16, 605, 608 }, // 387 CR6SET_CREQV_CRSET
  { 1, 21, 26, 608, 611 }, // 388 DSS_DSSALL
  { 1, 81, 86, 611, 613 }, // 389 MFCTR_MFCTR8_MFLR_MFLR8
  { 1, 6, 11, 613, 616 }, // 390 NOP_ORI_ORI8
  { 0, 0, 0, 0, 0 }, // 391 VXOR_V_SET0_V_SET0B_V_SET0H
  { 0, 0, 0, 0, 0 }, // 392 XXLEQV_XXLEQVOnes_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 1, 6, 11, 616, 619 }, // 393 ADDI_ADDI8_LI_LI8_ADDIS_ADDIS8_LIS_LIS8_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_NEG_NEG8_NEG8_rec_NEG_rec_NEG8O_NEGO
  { 0, 0, 0, 0, 0 }, // 394 ADDIdtprelL32_ADDItlsldLADDR32_ADDISdtprelHA32
  { 0, 0, 0, 0, 0 }, // 395 ADDItocL_ADDIStocHA_ADDIStocHA8
  { 1, 6, 11, 619, 622 }, // 396 ADDME_ADDME8_ADDME8O_ADDMEO_ADDZE_ADDZE8_ADDZE8O_ADDZEO_SUBFME_SUBFME8_SUBFME8O_SUBFMEO_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZEO
  { 1, 31, 40, 622, 625 }, // 397 FABSD_FABSS_FMR_FNABSD_FNABSS_FNEGD_FNEGS
  { 1, 6, 11, 625, 628 }, // 398 SETB_SETB8
  { 1, 6, 11, 628, 631 }, // 399 SETBC_SETBC8_SETBCR_SETBCR8_SETNBC_SETNBC8_SETNBCR_SETNBCR8
  { 0, 0, 0, 0, 0 }, // 400 VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VNEGD_VNEGW
  { 0, 0, 0, 0, 0 }, // 401 VEXTSD2Q
  { 0, 0, 0, 0, 0 }, // 402 XSABSDP_XSNABSDP_XSNEGDP_XSXEXPDP
  { 0, 0, 0, 0, 0 }, // 403 XSABSQP_XSNABSQP_XSNEGQP_XSXEXPQP_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVNEGDP_XVNEGSP_XVXEXPDP_XVXEXPSP
  { 0, 0, 0, 0, 0 }, // 404 XVXSIGDP_XVXSIGSP
  { 1, 6, 11, 631, 634 }, // 405 ADD4_ADD4TLS_ADD8_ADD8TLS_ADD8TLS__ADD4_rec_ADD8_rec_ADD4O_ADD8O_AND_AND8_AND8_rec_AND_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_EQV_EQV8_EQV8_rec_EQV_rec_NAND_NAND8_NAND8_rec_NAND_rec_NOR_NOR8_NOR8_rec_NOR_rec_OR_OR8_OR8_rec_OR_rec_ORC_ORC8_ORC8_rec_ORC_rec_ORIS_ORIS8_XOR_XOR8_XOR8_rec_XOR_rec_XORI_XORI8_XORIS_XORIS8
  { 1, 6, 11, 634, 637 }, // 406 ADDE_ADDE8_ADDE8O_ADDEO_ADDIC_ADDIC8_ANDI8_rec_ANDI_rec_ANDIS8_rec_ANDIS_rec_SUBF_SUBF8_SUBF8_rec_SUBF_rec_SUBFE_SUBFE8_SUBFE8O_SUBFEO_SUBFIC_SUBFIC8_SUBF8O_SUBFO
  { 1, 6, 11, 637, 640 }, // 407 CMPB_CMPB8
  { 0, 0, 0, 0, 0 }, // 408 EXTSWSLI_EXTSWSLI_32_64_SRADI_SRADI_32
  { 1, 6, 11, 640, 643 }, // 409 SLW_SLW8_SRW_SRW8
  { 0, 0, 0, 0, 0 }, // 410 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEQV_VNAND_VORC_VSLD_VSRAD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_XXLAND_XXLANDC_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC
  { 0, 0, 0, 0, 0 }, // 411 VAND_VANDC_VMRGEW_VMRGOW_VNOR_VOR_VRLB_VRLD_VRLDNM_VRLH_VRLW_VRLWNM_VSLB_VSLH_VSLW_VSRAB_VSRAH_VSRAW_VSRB_VSRH_VSRW_XSCPSGNQP_XSIEXPQP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP
  { 0, 0, 0, 0, 0 }, // 412 VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW
  { 1, 6, 11, 643, 646 }, // 413 ADDEX_ADDEX8
  { 1, 21, 26, 646, 649 }, // 414 DST_DST64_DSTT_DSTT64_DSTST_DSTST64_DSTSTT_DSTSTT64
  { 0, 0, 0, 0, 0 }, // 415 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32
  { 1, 11, 16, 649, 652 }, // 416 MFFS_MFFS_rec_MFFSL
  { 1, 81, 86, 652, 654 }, // 417 TRECHKPT
  { 1, 6, 11, 654, 657 }, // 418 ADDME8_rec_ADDME_rec_ADDME8O_rec_ADDMEO_rec_ADDZE8_rec_ADDZE_rec_ADDZE8O_rec_ADDZEO_rec_SUBFME8_rec_SUBFME_rec_SUBFME8O_rec_SUBFMEO_rec_SUBFZE8_rec_SUBFZE_rec_SUBFZE8O_rec_SUBFZEO_rec
  { 1, 11, 16, 657, 660 }, // 419 MTFSB0
  { 1, 6, 11, 660, 663 }, // 420 NEG8O_rec_NEGO_rec
  { 1, 6, 11, 663, 666 }, // 421 ADDE8_rec_ADDE_rec_ADDE8O_rec_ADDEO_rec_ADDIC_rec_SUBFE8_rec_SUBFE_rec_SUBFE8O_rec_SUBFEO_rec_SUBF8O_rec_SUBFO_rec
  { 1, 11, 16, 666, 668 }, // 422 HRFID
  { 1, 31, 40, 668, 671 }, // 423 FABSD_rec_FABSS_rec_FMR_rec_FNABSD_rec_FNABSS_rec_FNEGD_rec_FNEGS_rec
  { 1, 11, 16, 671, 673 }, // 424 SC
  { 1, 6, 11, 673, 676 }, // 425 ADDC_ADDC8_ADDC8O_ADDCO_SUBFC_SUBFC8_SUBFC8O_SUBFCO
  { 1, 6, 11, 676, 679 }, // 426 ADDC8_rec_ADDC_rec_SUBFC8_rec_SUBFC_rec
  { 1, 11, 16, 679, 682 }, // 427 MTFSF_MTFSFI_MTFSFIb
  { 1, 11, 16, 682, 685 }, // 428 MTFSFI_rec
  { 0, 0, 0, 0, 0 }, // 429 VSTRIBL_rec_VSTRIBR_rec_VSTRIHL_rec_VSTRIHR_rec
  { 1, 21, 26, 685, 688 }, // 430 LBZ_LBZ8_LDBRX_LHBRX_LHBRX8_LHZ_LHZ8_LWBRX_LWBRX8_LWZ_LWZ8
  { 0, 0, 0, 0, 0 }, // 431 LD
  { 0, 0, 0, 0, 0 }, // 432 LDtoc_LDtocBA_LDtocCPT_LDtocJTI_LDtocL_SPILLTOVSR_LD_LWZtoc_LWZtocL
  { 1, 21, 26, 688, 691 }, // 433 LXVRBX_LXVRDX_LXVRHX_LXVRWX
  { 1, 16, 21, 691, 693 }, // 434 DCBT_DCBTST
  { 1, 21, 26, 693, 696 }, // 435 ICBT_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32
  { 0, 0, 0, 0, 0 }, // 436 LDX_LDXTLS_LDXTLS_
  { 0, 0, 0, 0, 0 }, // 437 SPILLTOVSR_LDX
  { 1, 21, 26, 696, 699 }, // 438 LBZCIX_LDCIX_LHZCIX_LWZCIX
  { 1, 81, 86, 699, 701 }, // 439 MTSR
  { 1, 6, 11, 701, 704 }, // 440 MTVRSAVE_MTVRSAVEv
  { 1, 21, 26, 704, 707 }, // 441 LSWI
  { 1, 21, 26, 707, 710 }, // 442 PLBZ_PLBZ8_PLBZ8pc_PLBZpc_PLD_PLDpc_PLFD_PLFDpc_PLFS_PLFSpc_PLHA_PLHA8_PLHA8pc_PLHApc_PLHZ_PLHZ8_PLHZ8pc_PLHZpc_PLWA_PLWA8_PLWA8pc_PLWApc_PLWZ_PLWZ8_PLWZ8pc_PLWZpc_PLXSD_PLXSDpc_PLXSSP_PLXSSPpc_PLXV_PLXVpc_PLXVP_PLXVPpc
  { 1, 21, 26, 710, 713 }, // 443 LXVP_LXVPX
  { 1, 11, 16, 713, 715 }, // 444 MFSR
  { 1, 81, 86, 715, 717 }, // 445 MFTB8
  { 0, 0, 0, 0, 0 }, // 446 XXSETACCZ
  { 0, 0, 0, 0, 0 }, // 447 XVBF16GER2_XVF16GER2_XVF32GER_XVF64GER_XVI16GER2_XVI16GER2S_XVI4GER8_XVI8GER4
  { 0, 0, 0, 0, 0 }, // 448 XVBF16GER2NN_XVBF16GER2NP_XVBF16GER2PN_XVBF16GER2PP_XVF16GER2NN_XVF16GER2NP_XVF16GER2PN_XVF16GER2PP_XVF32GERNN_XVF32GERNP_XVF32GERPN_XVF32GERPP_XVF64GERNN_XVF64GERNP_XVF64GERPN_XVF64GERPP_XVI16GER2PP_XVI16GER2SPP_XVI4GER8PP_XVI8GER4PP
  { 0, 0, 0, 0, 0 }, // 449 XVI8GER4SPP
  { 0, 0, 0, 0, 0 }, // 450 PMXVF32GER_PMXVF64GER
  { 0, 0, 0, 0, 0 }, // 451 PMXVBF16GER2_PMXVF16GER2_PMXVF32GERNN_PMXVF32GERNP_PMXVF32GERPN_PMXVF32GERPP_PMXVF64GERNN_PMXVF64GERNP_PMXVF64GERPN_PMXVF64GERPP_PMXVI16GER2_PMXVI16GER2S_PMXVI4GER8_PMXVI8GER4
  { 0, 0, 0, 0, 0 }, // 452 PMXVBF16GER2NN_PMXVBF16GER2NP_PMXVBF16GER2PN_PMXVBF16GER2PP_PMXVF16GER2NN_PMXVF16GER2NP_PMXVF16GER2PN_PMXVF16GER2PP_PMXVI16GER2PP_PMXVI16GER2SPP_PMXVI4GER8PP_PMXVI8GER4PP
  { 0, 0, 0, 0, 0 }, // 453 PMXVI8GER4SPP
  { 0, 0, 0, 0, 0 }, // 454 XXMTACC
  { 0, 0, 0, 0, 0 }, // 455 XXMFACC
  { 0, 0, 0, 0, 0 }, // 456 MULLD_MULLDO
  { 0, 0, 0, 0, 0 }, // 457 VMULHSD_VMULHUD_VMULLD
  { 0, 0, 0, 0, 0 }, // 458 VSPLTISW
  { 0, 0, 0, 0, 0 }, // 459 V_SETALLONES_V_SETALLONESB_V_SETALLONESH
  { 0, 0, 0, 0, 0 }, // 460 MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VPRTYBQ
  { 0, 0, 0, 0, 0 }, // 461 VGBBD_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW
  { 0, 0, 0, 0, 0 }, // 462 VSPLTISB_VSPLTISH_XXSPLTIB
  { 0, 0, 0, 0, 0 }, // 463 VSTRIBL_VSTRIBR_VSTRIHL_VSTRIHR
  { 0, 0, 0, 0, 0 }, // 464 XVCVBF16SPN
  { 0, 0, 0, 0, 0 }, // 465 VBPERMQ_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLO_VSLV_VSR_VSRO_VSRV_XXEXTRACTUW
  { 0, 0, 0, 0, 0 }, // 466 VCLRLB_VCLRRB_XXGENPCVDM_XXGENPCVHM_XXGENPCVWM
  { 0, 0, 0, 0, 0 }, // 467 VEXTRACTD_VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VINSERTD_VINSERTW
  { 0, 0, 0, 0, 0 }, // 468 VEXTDDVLX_VEXTDDVRX_VEXTDUBVLX_VEXTDUBVRX_VEXTDUHVLX_VEXTDUHVRX_VEXTDUWVLX_VEXTDUWVRX_VINSBLX_VINSBRX_VINSBVLX_VINSBVRX_VINSD_VINSDLX_VINSDRX_VINSHLX_VINSHRX_VINSHVLX_VINSHVRX_VINSW_VINSWLX_VINSWRX_VINSWVLX_VINSWVRX_VSLDBI_VSRDBI
  { 0, 0, 0, 0, 0 }, // 469 VSUMSWS
  { 0, 0, 0, 0, 0 }, // 470 XXSPLTIDP_XXSPLTIW
  { 0, 0, 0, 0, 0 }, // 471 XXBLENDVB_XXBLENDVD_XXBLENDVH_XXBLENDVW_XXSPLTI32DX
  { 0, 0, 0, 0, 0 }, // 472 XXEVAL
  { 0, 0, 0, 0, 0 }, // 473 XXPERMX
  { 1, 16, 21, 717, 719 }, // 474 DCBST_DCBZ
  { 1, 16, 21, 719, 722 }, // 475 ICBI
  { 1, 16, 21, 722, 724 }, // 476 DCBF
  { 1, 21, 26, 724, 727 }, // 477 PSTXVP_PSTXVPpc
  { 1, 21, 26, 727, 730 }, // 478 STB_STB8_STDBRX_STH_STH8_STHBRX_STW_STW8_STWBRX
  { 0, 0, 0, 0, 0 }, // 479 SPILLTOVSR_ST
  { 1, 21, 26, 730, 733 }, // 480 STD
  { 0, 0, 0, 0, 0 }, // 481 DFSTOREf32_DFSTOREf64_STIWX
  { 1, 16, 21, 733, 736 }, // 482 STXVRBX_STXVRDX_STXVRHX_STXVRWX
  { 0, 0, 0, 0, 0 }, // 483 SPILLTOVSR_STX
  { 1, 21, 26, 736, 739 }, // 484 EnforceIEIO
  { 1, 21, 26, 739, 742 }, // 485 STBCIX_STDCIX_STHCIX_STWCIX
  { 1, 21, 26, 742, 745 }, // 486 PSTB_PSTB8_PSTB8pc_PSTBpc_PSTD_PSTDpc_PSTFD_PSTFDpc_PSTFS_PSTFSpc_PSTH_PSTH8_PSTH8pc_PSTHpc_PSTW_PSTW8_PSTW8pc_PSTWpc_PSTXSD_PSTXSDpc_PSTXSSP_PSTXSSPpc_PSTXV_PSTXVpc
  { 1, 21, 26, 745, 748 }, // 487 STXVP_STXVPX
  { 1, 11, 16, 748, 750 }, // 488 ATTN_NAP
  { 1, 16, 21, 750, 752 }, // 489 DCBZL
  { 1, 21, 26, 752, 755 }, // 490 DCCCI_ICBLQ_ICCCI_TLBLD_TLBLI_TLBRE2_TLBSX2_TLBSX2D_TLBWE2
  { 1, 21, 26, 755, 758 }, // 491 ICBLC
  { 1, 11, 16, 758, 760 }, // 492 CLRBHRB
  { 1, 11, 16, 760, 762 }, // 493 MFBHRBE
  { 1, 21, 26, 762, 765 }, // 494 PADDI_PADDI8_PADDI8pc_PADDIpc
  { 1, 6, 11, 765, 768 }, // 495 PLI_PLI8
  { 0, 0, 0, 0, 0 }, // 496 VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS
  { 0, 0, 0, 0, 0 }, // 497 VMULESD_VMULEUD_VMULHSW_VMULHUW_VMULOSD_VMULOUD
  { 0, 0, 0, 0, 0 }, // 498 VMSUMCUD
  { 0, uint16_t(~0U), uint16_t(~0U), uint16_t(~0U), uint16_t(~0U) }// end marker
};

static const llvm::InstrItinerary G3Itineraries[] = {
  { 0, 0, 0, 0, 0 }, // 0 NoInstrModel
  { 1, 86, 87, 0, 0 }, // 1 IIC_LdStSync
  { 1, 87, 88, 0, 0 }, // 2 IIC_IntSimple
  { 1, 87, 88, 0, 0 }, // 3 IIC_IntGeneral
  { 1, 88, 89, 0, 0 }, // 4 IIC_BrB
  { 0, 0, 0, 0, 0 }, // 5 IIC_VecFP
  { 1, 87, 88, 0, 0 }, // 6 IIC_IntCompare
  { 0, 0, 0, 0, 0 }, // 7 IIC_SprABORT
  { 0, 0, 0, 0, 0 }, // 8 IIC_LdStCOPY
  { 0, 0, 0, 0, 0 }, // 9 IIC_LdStPASTE
  { 1, 89, 90, 0, 0 }, // 10 IIC_BrCR
  { 0, 0, 0, 0, 0 }, // 11 IIC_LdStLD
  { 1, 86, 87, 0, 0 }, // 12 IIC_LdStDCBF
  { 1, 90, 91, 0, 0 }, // 13 IIC_LdStLoad
  { 0, 0, 0, 0, 0 }, // 14 IIC_IntDivD
  { 1, 91, 92, 0, 0 }, // 15 IIC_IntDivW
  { 0, 0, 0, 0, 0 }, // 16 IIC_FPDGeneral
  { 1, 92, 93, 0, 0 }, // 17 IIC_FPAddSub
  { 1, 93, 94, 0, 0 }, // 18 IIC_FPDivD
  { 0, 0, 0, 0, 0 }, // 19 IIC_FPSGeneral
  { 1, 92, 93, 0, 0 }, // 20 IIC_FPCompare
  { 1, 92, 93, 0, 0 }, // 21 IIC_FPGeneral
  { 0, 0, 0, 0, 0 }, // 22 IIC_VecGeneral
  { 0, 0, 0, 0, 0 }, // 23 IIC_VecComplex
  { 1, 90, 91, 0, 0 }, // 24 IIC_LdStStore
  { 0, 0, 0, 0, 0 }, // 25 IIC_IntRotateDI
  { 1, 94, 95, 0, 0 }, // 26 IIC_FPDivS
  { 1, 95, 96, 0, 0 }, // 27 IIC_FPFused
  { 0, 0, 0, 0, 0 }, // 28 IIC_FPSqrtD
  { 0, 0, 0, 0, 0 }, // 29 IIC_FPSqrtS
  { 1, 86, 87, 0, 0 }, // 30 IIC_LdStICBI
  { 0, 0, 0, 0, 0 }, // 31 IIC_IntISEL
  { 1, 96, 97, 0, 0 }, // 32 IIC_SprISYNC
  { 1, 86, 87, 0, 0 }, // 33 IIC_LdStLWARX
  { 1, 90, 91, 0, 0 }, // 34 IIC_LdStLoadUpd
  { 1, 90, 91, 0, 0 }, // 35 IIC_LdStLoadUpdX
  { 0, 0, 0, 0, 0 }, // 36 IIC_LdStLDARX
  { 0, 0, 0, 0, 0 }, // 37 IIC_LdStLDU
  { 0, 0, 0, 0, 0 }, // 38 IIC_LdStLDUX
  { 1, 90, 91, 0, 0 }, // 39 IIC_LdStLFD
  { 1, 90, 91, 0, 0 }, // 40 IIC_LdStLFDU
  { 1, 90, 91, 0, 0 }, // 41 IIC_LdStLFDUX
  { 1, 90, 91, 0, 0 }, // 42 IIC_LdStLHA
  { 1, 90, 91, 0, 0 }, // 43 IIC_LdStLHAU
  { 1, 90, 91, 0, 0 }, // 44 IIC_LdStLHAUX
  { 1, 97, 98, 0, 0 }, // 45 IIC_LdStLMW
  { 0, 0, 0, 0, 0 }, // 46 IIC_LdStLQ
  { 0, 0, 0, 0, 0 }, // 47 IIC_LdStLQARX
  { 0, 0, 0, 0, 0 }, // 48 IIC_LdStLWA
  { 0, 0, 0, 0, 0 }, // 49 IIC_IntMulHD
  { 1, 89, 90, 0, 0 }, // 50 IIC_BrMCR
  { 1, 89, 90, 0, 0 }, // 51 IIC_BrMCRX
  { 1, 89, 90, 0, 0 }, // 52 IIC_SprMFCR
  { 1, 98, 99, 0, 0 }, // 53 IIC_SprMFSPR
  { 1, 92, 93, 0, 0 }, // 54 IIC_IntMFFS
  { 1, 89, 90, 0, 0 }, // 55 IIC_SprMFMSR
  { 0, 0, 0, 0, 0 }, // 56 IIC_SprMFCRF
  { 0, 0, 0, 0, 0 }, // 57 IIC_SprMFPMR
  { 1, 98, 99, 0, 0 }, // 58 IIC_SprMFSR
  { 1, 98, 99, 0, 0 }, // 59 IIC_SprMFTB
  { 0, 0, 0, 0, 0 }, // 60 IIC_SprMSGSYNC
  { 1, 96, 97, 0, 0 }, // 61 IIC_SprMTSPR
  { 1, 99, 100, 0, 0 }, // 62 IIC_IntMTFSB0
  { 1, 89, 90, 0, 0 }, // 63 IIC_SprMTMSR
  { 0, 0, 0, 0, 0 }, // 64 IIC_SprMTMSRD
  { 0, 0, 0, 0, 0 }, // 65 IIC_SprMTPMR
  { 1, 96, 97, 0, 0 }, // 66 IIC_SprMTSR
  { 1, 100, 101, 0, 0 }, // 67 IIC_IntMulHW
  { 1, 101, 102, 0, 0 }, // 68 IIC_IntMulHWU
  { 1, 102, 103, 0, 0 }, // 69 IIC_IntMulLI
  { 1, 96, 97, 0, 0 }, // 70 IIC_SprRFI
  { 0, 0, 0, 0, 0 }, // 71 IIC_IntRFID
  { 0, 0, 0, 0, 0 }, // 72 IIC_IntRotateD
  { 1, 87, 88, 0, 0 }, // 73 IIC_IntRotate
  { 0, 0, 0, 0, 0 }, // 74 IIC_SprSLBFEE
  { 0, 0, 0, 0, 0 }, // 75 IIC_SprSLBIA
  { 0, 0, 0, 0, 0 }, // 76 IIC_SprSLBIE
  { 0, 0, 0, 0, 0 }, // 77 IIC_SprSLBIEG
  { 0, 0, 0, 0, 0 }, // 78 IIC_SprSLBMFEE
  { 0, 0, 0, 0, 0 }, // 79 IIC_SprSLBMFEV
  { 0, 0, 0, 0, 0 }, // 80 IIC_SprSLBMTE
  { 0, 0, 0, 0, 0 }, // 81 IIC_SprSLBSYNC
  { 1, 87, 88, 0, 0 }, // 82 IIC_IntShift
  { 1, 103, 104, 0, 0 }, // 83 IIC_LdStSTWCX
  { 1, 90, 91, 0, 0 }, // 84 IIC_LdStSTU
  { 1, 90, 91, 0, 0 }, // 85 IIC_LdStSTUX
  { 0, 0, 0, 0, 0 }, // 86 IIC_LdStSTD
  { 0, 0, 0, 0, 0 }, // 87 IIC_LdStSTDCX
  { 1, 90, 91, 0, 0 }, // 88 IIC_LdStSTFD
  { 1, 90, 91, 0, 0 }, // 89 IIC_LdStSTFDU
  { 0, 0, 0, 0, 0 }, // 90 IIC_SprSTOP
  { 0, 0, 0, 0, 0 }, // 91 IIC_LdStSTQ
  { 0, 0, 0, 0, 0 }, // 92 IIC_LdStSTQCX
  { 0, 0, 0, 0, 0 }, // 93 IIC_IntTrapD
  { 0, 0, 0, 0, 0 }, // 94 IIC_SprTLBIA
  { 0, 0, 0, 0, 0 }, // 95 IIC_SprTLBIE
  { 0, 0, 0, 0, 0 }, // 96 IIC_SprTLBIEL
  { 1, 98, 99, 0, 0 }, // 97 IIC_SprTLBSYNC
  { 1, 104, 105, 0, 0 }, // 98 IIC_IntTrapW
  { 0, 0, 0, 0, 0 }, // 99 IIC_VecFPCompare
  { 0, 0, 0, 0, 0 }, // 100 IIC_VecPerm
  { 0, 0, 0, 0, 0 }, // 101 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VSLD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_VPOPCNTB_VPOPCNTH_VSRAD_MTVSRDD_VEQV_VNAND_VNEGD_VNEGW_VORC_XXLAND_XXLANDC_XXLEQV_XXLEQVOnes_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 0, 0, 0, 0, 0 }, // 102 VAND_VANDC_V_SET0_V_SET0B_V_SET0H_VSLB_VSLH_VSLW_VSRB_VSRH_VSRW_VRLB_VRLD_VRLH_VRLW_VSRAB_VSRAH_VSRAW_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP_XVXEXPDP_XVXEXPSP_VRLDMI_VRLDNM_VRLWMI_VRLWNM_VMRGEW_VMRGOW_VNOR_VOR_VSEL_VXOR_XVNEGDP_XVNEGSP_XSABSQP_XSCPSGNQP_XSIEXPQP_XSNABSQP_XSNEGQP_XSXEXPQP
  { 0, 0, 0, 0, 0 }, // 103 XXSEL
  { 1, 96, 97, 0, 0 }, // 104 TABORTDC_TABORTDCI_TABORTWC_TABORTWCI
  { 1, 99, 100, 0, 0 }, // 105 MTFSB0_MTFSB1
  { 1, 92, 93, 0, 0 }, // 106 MFFSCDRN_MFFSCDRNI_MFFSCRN_MFFSCRNI
  { 1, 87, 88, 0, 0 }, // 107 CMPRB_CMPRB8_CMPEQB
  { 0, 0, 0, 0, 0 }, // 108 TD_TDI
  { 1, 104, 105, 0, 0 }, // 109 TW_TWI
  { 1, 92, 93, 0, 0 }, // 110 FCMPOD_FCMPOS_FCMPUD_FCMPUS_FTDIV_FTSQRT
  { 0, 0, 0, 0, 0 }, // 111 XSTSTDCDP_XSTSTDCSP
  { 0, 0, 0, 0, 0 }, // 112 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP_XSXSIGDP_XSCVSPDPN
  { 1, 92, 93, 0, 0 }, // 113 XSCMPEQDP_XSCMPEXPDP_XSCMPGEDP_XSCMPGTDP_XSCMPODP_XSCMPUDP_XSTDIVDP_XSTSQRTDP
  { 1, 87, 88, 0, 0 }, // 114 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW_CMPB_CMPB8_SETB_SETB8_BPERMD
  { 0, 0, 0, 0, 0 }, // 115 SLD_SRD_SRAD
  { 0, 0, 0, 0, 0 }, // 116 SRADI_EXTSWSLI_32_64_EXTSWSLI_SRADI_32_RLDIC
  { 0, 0, 0, 0, 0 }, // 117 MFVRD_MFVSRD_MTVRD_MTVSRD_MTVRWA_MTVRWZ_MTVSRWA_MTVSRWZ_MFVSRWZ_MFVRWZ
  { 1, 87, 88, 0, 0 }, // 118 CMPLW_CMPLWI_CMPW_CMPWI_CMPD_CMPDI_CMPLD_CMPLDI
  { 1, 87, 88, 0, 0 }, // 119 SUBFC_SUBFC8_SUBFC8O_SUBFCO_SUBFIC_SUBFIC8_ANDI8_rec_ANDIS8_rec_ANDIS_rec_ANDI_rec_ADDC_ADDC8_ADDC8O_ADDCO_ADDIC_ADDIC8_ADDIC_rec_ADDE_ADDE8_ADDE8O_ADDE8O_rec_ADDE8_rec_ADDEO_ADDEO_rec_ADDE_rec_ADDME_ADDME8_ADDME8O_ADDME8O_rec_ADDME8_rec_ADDMEO_ADDMEO_rec_ADDME_rec_ADDZE_ADDZE8_ADDZE8O_ADDZE8O_rec_ADDZE8_rec_ADDZEO_ADDZEO_rec_ADDZE_rec_SUBF_SUBF8_SUBF8O_SUBF8O_rec_SUBF8_rec_SUBFE_SUBFE8_SUBFE8O_SUBFE8O_rec_SUBFE8_rec_SUBFEO_SUBFEO_rec_SUBFE_rec_SUBFME_SUBFME8_SUBFME8O_SUBFME8O_rec_SUBFME8_rec_SUBFMEO_SUBFMEO_rec_SUBFME_rec_SUBFO_SUBFO_rec_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZE8O_rec_SUBFZE8_rec_SUBFZEO_SUBFZEO_rec_SUBFZE_rec_SUBF_rec_POPCNTB_POPCNTB8_LA_LA8
  { 1, 87, 88, 0, 0 }, // 120 ADD4_ADD4O_ADD4O_rec_ADD4_rec_ADD8_ADD8O_ADD8O_rec_ADD8_rec_NEG_NEG8_NEG8O_NEG8O_rec_NEG8_rec_NEGO_NEGO_rec_NEG_rec_ADDI_ADDI8_ADDIS_ADDIS8_LI_LI8_LIS_LIS8_OR_OR8_OR8_rec_ORI_ORI8_ORIS_ORIS8_OR_rec_XOR_XOR8_XOR8_rec_XORI_XORI8_XORIS_XORIS8_XOR_rec_NAND_NAND8_NAND8_rec_NAND_rec_AND_AND8_AND8_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_AND_rec_NOR_NOR8_NOR8_rec_NOR_rec_ORC_ORC8_ORC8_rec_ORC_rec_EQV_EQV8_EQV8_rec_EQV_rec_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_ADD4TLS_ADD8TLS_ADD8TLS__NOP
  { 0, 0, 0, 0, 0 }, // 121 ADDIStocHA_ADDIStocHA8_ADDItocL_COPY
  { 1, 89, 90, 0, 0 }, // 122 MCRF
  { 1, 89, 90, 0, 0 }, // 123 MCRXRX
  { 0, 0, 0, 0, 0 }, // 124 XSNABSDP_XSXEXPDP_XSABSDP_XSNEGDP_XSCPSGNDP
  { 1, 88, 89, 0, 0 }, // 125 RFEBB
  { 1, 96, 97, 0, 0 }, // 126 TBEGIN_TRECHKPT
  { 1, 90, 91, 0, 0 }, // 127 WAIT
  { 0, 0, 0, 0, 0 }, // 128 RLDCL_RLDCR
  { 1, 87, 88, 0, 0 }, // 129 RLWIMI_RLWIMI8
  { 0, 0, 0, 0, 0 }, // 130 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32_RLDIMI
  { 0, 0, 0, 0, 0 }, // 131 MFOCRF_MFOCRF8
  { 1, 89, 90, 0, 0 }, // 132 MTOCRF_MTOCRF8
  { 1, 89, 90, 0, 0 }, // 133 CR6SET_CR6UNSET_CRSET_CRUNSET_CRAND_CRANDC_CRNAND_CRNOR_CROR_CRORC_CREQV_CRXOR
  { 1, 87, 88, 0, 0 }, // 134 SLW_SLW8_SRW_SRW8_RLWINM_RLWINM8_RLWNM_RLWNM8
  { 1, 92, 93, 0, 0 }, // 135 FABSD_FABSS_FNABSD_FNABSS_FNEGD_FNEGS_FCPSGND_FCPSGNS_FMR
  { 1, 87, 88, 0, 0 }, // 136 SRAW_SRAWI
  { 0, 0, 0, 0, 0 }, // 137 ISEL_ISEL8
  { 0, 0, 0, 0, 0 }, // 138 XSIEXPDP
  { 1, 96, 97, 0, 0 }, // 139 TRECLAIM_TSR_TABORT
  { 1, 90, 91, 0, 0 }, // 140 MFVSCR
  { 1, 90, 91, 0, 0 }, // 141 MTVSCR
  { 0, 0, 0, 0, 0 }, // 142 VCMPNEZB_VCMPNEZH_VCMPNEZW_VCMPEQUB_VCMPEQUD_VCMPEQUH_VCMPEQUW_VCMPNEB_VCMPNEH_VCMPNEW_VCMPEQFP_VCMPEQFP_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPBFP_VCMPBFP_rec_VCMPGTSB_VCMPGTSB_rec_VCMPGTSD_VCMPGTSD_rec_VCMPGTSH_VCMPGTSH_rec_VCMPGTSW_VCMPGTSW_rec_VCMPGTUB_VCMPGTUB_rec_VCMPGTUD_VCMPGTUD_rec_VCMPGTUH_VCMPGTUH_rec_VCMPGTUW_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 0, 0, 0, 0, 0 }, // 143 VABSDUB_VABSDUH_VABSDUW_VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTW_VPOPCNTD_VPRTYBD_VPRTYBW
  { 0, 0, 0, 0, 0 }, // 144 VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VADDSBS_VADDSHS_VADDSWS_VMAXFP_VMINFP_VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW_VBPERMD_VADDCUW_VSHASIGMAD_VSHASIGMAW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_VSUBCUW_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP_XVXSIGDP_XVXSIGSP
  { 1, 92, 93, 0, 0 }, // 145 XVTDIVDP_XVTDIVSP_XVTSQRTDP_XVTSQRTSP
  { 0, 0, 0, 0, 0 }, // 146 VADDFP_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VEXPTEFP_VLOGEFP_VMADDFP_VMHADDSHS_VNMSUBFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVADDDP_XVADDSP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVHPSP_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVMULDP_XVMULSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP_XVSUBDP_XVSUBSP_VCFSX_VCFSX_0_VCFUX_VCFUX_0_VMHRADDSHS_VMLADDUHM_VMSUMMBM_VMSUMSHM_VMSUMSHS_VMSUMUBM_VMSUMUHM_VMSUMUDM_VMSUMUHS_VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS_VSUMSWS
  { 0, 0, 0, 0, 0 }, // 147 VSUBFP_VMULUWM
  { 0, 0, 0, 0, 0 }, // 148 MADDHD_MADDHDU_MADDLD_MADDLD8_MULLD_MULLDO
  { 1, 100, 101, 0, 0 }, // 149 MULHD_MULHW_MULLW_MULLWO
  { 1, 101, 102, 0, 0 }, // 150 MULHDU_MULHWU
  { 1, 102, 103, 0, 0 }, // 151 MULLI_MULLI8
  { 1, 92, 93, 0, 0 }, // 152 FRSP_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRE_FRES_FADDS_FMSUBS_FMADDS_FSUBS_FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRSQRTE_FRSQRTES_FNMADDS_FNMSUBS_FSELD_FSELS_FMULS
  { 1, 92, 93, 0, 0 }, // 153 FADD_FSUB
  { 1, 95, 96, 0, 0 }, // 154 FMSUB_FMADD_FNMADD_FNMSUB_FMUL
  { 0, 0, 0, 0, 0 }, // 155 XSMADDADP_XSMADDASP_XSMADDMDP_XSMADDMSP_XSMSUBADP_XSMSUBASP_XSMSUBMDP_XSMSUBMSP_XSMULDP_XSMULSP_XSNMADDADP_XSNMADDASP_XSNMADDMDP_XSNMADDMSP_XSNMSUBADP_XSNMSUBASP_XSNMSUBMDP_XSNMSUBMSP
  { 1, 92, 93, 0, 0 }, // 156 FSELD_rec_FSELS_rec
  { 1, 101, 102, 0, 0 }, // 157 MULHDU_rec_MULHWU_rec
  { 1, 100, 101, 0, 0 }, // 158 MULHD_rec_MULHW_rec_MULLWO_rec_MULLW_rec
  { 0, 0, 0, 0, 0 }, // 159 MULLDO_rec_MULLD_rec
  { 1, 92, 93, 0, 0 }, // 160 FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRES_rec_FRE_rec_FADDS_rec_FSUBS_rec_FMSUBS_rec_FNMSUBS_rec_FMADDS_rec_FNMADDS_rec_FCFIDS_rec_FCFIDUS_rec_FCFIDU_rec_FCFID_rec_FCTIDUZ_rec_FCTIDU_rec_FCTIDZ_rec_FCTID_rec_FCTIWUZ_rec_FCTIWU_rec_FCTIWZ_rec_FCTIW_rec_FMULS_rec_FRSQRTES_rec_FRSQRTE_rec_FRSP_rec
  { 1, 92, 93, 0, 0 }, // 161 FADD_rec_FSUB_rec
  { 1, 95, 96, 0, 0 }, // 162 FMSUB_rec_FNMSUB_rec_FMADD_rec_FNMADD_rec_FMUL_rec
  { 0, 0, 0, 0, 0 }, // 163 XSADDDP_XSADDSP_XSCVDPHP_XSCVDPSP_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPSXWSs_XSCVDPUXWSs_XSCVHPDP_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSQRTEDP_XSRSQRTESP_XSSUBDP_XSSUBSP_XSCVDPSPN_XSRSP
  { 1, 90, 91, 0, 0 }, // 164 LVSL_LVSR
  { 0, 0, 0, 0, 0 }, // 165 VSPLTISB_VSPLTISH_VSPLTISW_VSPLTB_VSPLTBs_VSPLTH_VSPLTHs_VSPLTW_XXMRGHW_XXMRGLW_XXPERM_XXPERMR_XXSLDWI_XXSLDWIs_XXSPLTIB_XXSPLTW_XXSPLTWs_XXPERMDI_XXPERMDIs
  { 0, 0, 0, 0, 0 }, // 166 V_SETALLONES_V_SETALLONESB_V_SETALLONESH_VBPERMQ_VGBBD_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPERM_VPERMR_VPERMXOR_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLDOI_VSLO_VSLV_VSR_VSRO_VSRV_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW_XXEXTRACTUW_XXINSERTW_VADDCUQ_VADDECUQ_VADDEUQM_VMUL10CUQ_VMUL10ECUQ_VMUL10EUQ_VMUL10UQ_VSUBCUQ_VSUBECUQ_VSUBEUQM_XSTSTDCQP_XSXSIGQP_BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDS_rec_BCDTRUNC_rec_BCDUS_rec_BCDUTRUNC_rec_BCDADD_rec_BCDSUB_rec
  { 0, 0, 0, 0, 0 }, // 167 VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VINSERTB_VINSERTD_VINSERTH_VINSERTW_MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VEXTRACTD_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VPRTYBQ_VADDUQM_VSUBUQM
  { 1, 92, 93, 0, 0 }, // 168 XSCMPEXPQP_XSCMPOQP_XSCMPUQP
  { 0, 0, 0, 0, 0 }, // 169 BCDSR_rec_XSADDQP_XSADDQPO_XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP_XSRQPI_XSRQPIX_XSRQPXP_XSSUBQP_XSSUBQPO
  { 0, 0, 0, 0, 0 }, // 170 BCDCTSQ_rec
  { 0, 0, 0, 0, 0 }, // 171 XSMADDQP_XSMADDQPO_XSMSUBQP_XSMSUBQPO_XSMULQP_XSMULQPO_XSNMADDQP_XSNMADDQPO_XSNMSUBQP_XSNMSUBQPO
  { 0, 0, 0, 0, 0 }, // 172 BCDCFSQ_rec
  { 0, 0, 0, 0, 0 }, // 173 XSDIVQP_XSDIVQPO
  { 0, 0, 0, 0, 0 }, // 174 XSSQRTQP_XSSQRTQPO
  { 1, 90, 91, 0, 0 }, // 175 LXVL_LXVLL
  { 1, 90, 91, 0, 0 }, // 176 LVEBX_LVEHX_LVEWX_LVX_LVXL
  { 1, 90, 91, 0, 0 }, // 177 LXSIBZX_LXSIHZX_LXSDX_LXVB16X_LXVD2X_LXVWSX_LXSIWZX_LXV_LXVX_LXSD
  { 0, 0, 0, 0, 0 }, // 178 DFLOADf64_XFLOADf64_LIWZX
  { 1, 86, 87, 0, 0 }, // 179 DCBF_DCBFEP_DCBST_DCBSTEP_DCBT_DCBTEP_DCBZ_DCBZEP_DCBZL_DCBZLEP_DCBTST_DCBTSTEP
  { 0, 0, 0, 0, 0 }, // 180 CP_COPY_CP_COPY8
  { 1, 86, 87, 0, 0 }, // 181 ICBI_ICBIEP
  { 1, 90, 91, 0, 0 }, // 182 ICBT_ICBTLS_LBZ_LBZ8_LBZCIX_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LDBRX_LDCIX_LHBRX_LHBRX8_LHZ_LHZ8_LHZCIX_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWBRX_LWBRX8_LWZ_LWZ8_LWZCIX_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32_EnforceIEIO_LSWI
  { 1, 86, 87, 0, 0 }, // 183 LBARX_LBARXL_LHARX_LHARXL_LWARX_LWARXL
  { 0, 0, 0, 0, 0 }, // 184 LD_LDX_LDXTLS_LDXTLS__DARN
  { 0, 0, 0, 0, 0 }, // 185 LDARX_LDARXL
  { 0, 0, 0, 0, 0 }, // 186 CP_ABORT
  { 1, 96, 97, 0, 0 }, // 187 ISYNC
  { 0, 0, 0, 0, 0 }, // 188 MSGSYNC
  { 1, 98, 99, 0, 0 }, // 189 TLBSYNC
  { 1, 86, 87, 0, 0 }, // 190 SYNC
  { 1, 97, 98, 0, 0 }, // 191 LMW
  { 1, 90, 91, 0, 0 }, // 192 LFIWZX_LFDX_LFD
  { 0, 0, 0, 0, 0 }, // 193 SLBIA
  { 0, 0, 0, 0, 0 }, // 194 SLBIE
  { 0, 0, 0, 0, 0 }, // 195 SLBMFEE
  { 0, 0, 0, 0, 0 }, // 196 SLBMFEV
  { 0, 0, 0, 0, 0 }, // 197 SLBMTE
  { 0, 0, 0, 0, 0 }, // 198 TLBIEL
  { 1, 90, 91, 0, 0 }, // 199 LHZU_LHZU8_LWZU_LWZU8
  { 1, 90, 91, 0, 0 }, // 200 LHZUX_LHZUX8_LWZUX_LWZUX8
  { 1, 96, 97, 0, 0 }, // 201 TEND
  { 1, 103, 104, 0, 0 }, // 202 STBCX_STHCX_STWCX
  { 0, 0, 0, 0, 0 }, // 203 STDCX
  { 0, 0, 0, 0, 0 }, // 204 LDMX
  { 1, 90, 91, 0, 0 }, // 205 LHA_LHA8_LHAX_LHAX8_LWAX_LWAX_32
  { 0, 0, 0, 0, 0 }, // 206 CP_PASTE8_rec_CP_PASTE_rec
  { 0, 0, 0, 0, 0 }, // 207 LWA_LWA_32
  { 1, 96, 97, 0, 0 }, // 208 TCHECK
  { 1, 90, 91, 0, 0 }, // 209 LFIWAX
  { 1, 90, 91, 0, 0 }, // 210 LXSIWAX
  { 0, 0, 0, 0, 0 }, // 211 LIWAX
  { 1, 90, 91, 0, 0 }, // 212 LFSX_LFS
  { 1, 90, 91, 0, 0 }, // 213 LXSSP_LXSSPX
  { 0, 0, 0, 0, 0 }, // 214 XFLOADf32_DFLOADf32
  { 1, 90, 91, 0, 0 }, // 215 LHAU_LHAU8
  { 1, 90, 91, 0, 0 }, // 216 LHAUX_LHAUX8_LWAUX
  { 1, 90, 91, 0, 0 }, // 217 LXVH8X_LXVDSX_LXVW4X
  { 1, 90, 91, 0, 0 }, // 218 STFD_STFDX_STFIWX_STFS_STFSX_STXSD_STXSDX_STXSIBX_STXSIBXv_STXSIHX_STXSIHXv_STXSIWX_STXSSP_STXSSPX
  { 1, 90, 91, 0, 0 }, // 219 STW_STW8_STDBRX_STHBRX_STWBRX_STB_STB8_STH_STH8_STBX_STBX8_STBXTLS_STBXTLS__STBXTLS_32_STHX_STHX8_STHXTLS_STHXTLS__STHXTLS_32_STWX_STWX8_STWXTLS_STWXTLS__STWXTLS_32
  { 0, 0, 0, 0, 0 }, // 220 DFSTOREf32_DFSTOREf64_XFSTOREf32_XFSTOREf64_STIWX
  { 0, 0, 0, 0, 0 }, // 221 STD_STDX_STDXTLS_STDXTLS_
  { 1, 90, 91, 0, 0 }, // 222 STBCIX_STDCIX_STHCIX_STWCIX_STSWI
  { 0, 0, 0, 0, 0 }, // 223 SLBIEG
  { 1, 97, 98, 0, 0 }, // 224 STMW
  { 0, 0, 0, 0, 0 }, // 225 TLBIE
  { 1, 90, 91, 0, 0 }, // 226 STVEBX_STVEHX_STVEWX_STVX_STVXL
  { 1, 90, 91, 0, 0 }, // 227 STXV_STXVB16X_STXVD2X_STXVH8X_STXVW4X_STXVX
  { 1, 90, 91, 0, 0 }, // 228 STXVL_STXVLL
  { 1, 96, 97, 0, 0 }, // 229 MTCTR_MTCTR8_MTCTR8loop_MTCTRloop_MTLR_MTLR8
  { 1, 87, 88, 0, 0 }, // 230 MFVRSAVE_MFVRSAVEv_MTVRSAVE_MTVRSAVEv
  { 0, 0, 0, 0, 0 }, // 231 MFPMR
  { 0, 0, 0, 0, 0 }, // 232 MTPMR
  { 1, 98, 99, 0, 0 }, // 233 MFTB_MFTB8
  { 1, 98, 99, 0, 0 }, // 234 MFCTR_MFCTR8_MFLR_MFLR8_MFSPR_MFSPR8
  { 1, 89, 90, 0, 0 }, // 235 MFMSR
  { 1, 89, 90, 0, 0 }, // 236 MTMSR
  { 0, 0, 0, 0, 0 }, // 237 MTMSRD
  { 1, 96, 97, 0, 0 }, // 238 MTSPR_MTSPR8
  { 1, 91, 92, 0, 0 }, // 239 DIVW_DIVWO_DIVWU_DIVWUO_MODSW
  { 1, 91, 92, 0, 0 }, // 240 DIVWE_DIVWEO_DIVWEU_DIVWEUO_MODSD_MODUD_MODUW
  { 0, 0, 0, 0, 0 }, // 241 DIVD_DIVDO_DIVDU_DIVDUO
  { 0, 0, 0, 0, 0 }, // 242 DIVDE_DIVDEO_DIVDEU_DIVDEUO
  { 1, 91, 92, 0, 0 }, // 243 DIVWO_rec_DIVWUO_rec_DIVWU_rec_DIVW_rec
  { 0, 0, 0, 0, 0 }, // 244 DIVD_rec_DIVDO_rec_DIVDU_rec_DIVDUO_rec
  { 1, 91, 92, 0, 0 }, // 245 DIVWE_rec_DIVWEO_rec_DIVWEU_rec_DIVWEUO_rec
  { 0, 0, 0, 0, 0 }, // 246 DIVDE_rec_DIVDEO_rec_DIVDEU_rec_DIVDEUO_rec
  { 1, 89, 90, 0, 0 }, // 247 MTCRF_MTCRF8
  { 1, 87, 88, 0, 0 }, // 248 ADDC8O_rec_ADDC8_rec_ADDCO_rec_ADDC_rec_SUBFC8O_rec_SUBFC8_rec_SUBFCO_rec_SUBFC_rec
  { 1, 92, 93, 0, 0 }, // 249 FABSD_rec_FABSS_rec_FNABSD_rec_FNABSS_rec_FCPSGND_rec_FCPSGNS_rec_FNEGD_rec_FNEGS_rec_FMR_rec
  { 1, 89, 90, 0, 0 }, // 250 MCRFS
  { 1, 92, 93, 0, 0 }, // 251 MTFSF_MTFSF_rec_MTFSFI_MTFSFI_rec_MTFSFIb
  { 1, 99, 100, 0, 0 }, // 252 MTFSFb
  { 0, 0, 0, 0, 0 }, // 253 RLDCL_rec_RLDCR_rec
  { 0, 0, 0, 0, 0 }, // 254 RLDICL_rec_RLDICR_rec_RLDICL_32_rec_RLDIMI_rec
  { 1, 87, 88, 0, 0 }, // 255 RLWIMI8_rec_RLWIMI_rec
  { 1, 87, 88, 0, 0 }, // 256 RLWINM8_rec_RLWINM_rec_RLWNM8_rec_RLWNM_rec_SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 1, 87, 88, 0, 0 }, // 257 SRAWI_rec_SRAW_rec
  { 1, 92, 93, 0, 0 }, // 258 MFFS_MFFSCE_MFFSL_MFFS_rec
  { 1, 89, 90, 0, 0 }, // 259 MFCR_MFCR8
  { 0, 0, 0, 0, 0 }, // 260 EXTSWSLI_32_64_rec_SRADI_rec_EXTSWSLI_rec_RLDIC_rec
  { 0, 0, 0, 0, 0 }, // 261 SRAD_rec_SLD_rec_SRD_rec
  { 1, 93, 94, 0, 0 }, // 262 FDIV
  { 1, 93, 94, 0, 0 }, // 263 FDIV_rec
  { 0, 0, 0, 0, 0 }, // 264 XSSQRTDP
  { 0, 0, 0, 0, 0 }, // 265 FSQRT
  { 0, 0, 0, 0, 0 }, // 266 XVSQRTDP
  { 0, 0, 0, 0, 0 }, // 267 XVSQRTSP
  { 0, 0, 0, 0, 0 }, // 268 FSQRT_rec
  { 0, 0, 0, 0, 0 }, // 269 XSSQRTSP
  { 0, 0, 0, 0, 0 }, // 270 FSQRTS
  { 0, 0, 0, 0, 0 }, // 271 FSQRTS_rec
  { 1, 93, 94, 0, 0 }, // 272 XSDIVDP
  { 1, 94, 95, 0, 0 }, // 273 FDIVS
  { 1, 94, 95, 0, 0 }, // 274 FDIVS_rec
  { 1, 94, 95, 0, 0 }, // 275 XSDIVSP
  { 1, 94, 95, 0, 0 }, // 276 XVDIVSP
  { 1, 93, 94, 0, 0 }, // 277 XVDIVDP
  { 1, 90, 91, 0, 0 }, // 278 LFSU
  { 1, 90, 91, 0, 0 }, // 279 LFSUX
  { 1, 90, 91, 0, 0 }, // 280 STFDU_STFDUX_STFSU_STFSUX
  { 1, 90, 91, 0, 0 }, // 281 STBU_STBU8_STDU_STHU_STHU8_STWU_STWU8
  { 1, 90, 91, 0, 0 }, // 282 STBUX_STBUX8_STDUX_STHUX_STHUX8_STWUX_STWUX8
  { 1, 90, 91, 0, 0 }, // 283 LBZU_LBZU8
  { 1, 90, 91, 0, 0 }, // 284 LBZUX_LBZUX8
  { 0, 0, 0, 0, 0 }, // 285 LDU
  { 0, 0, 0, 0, 0 }, // 286 LDUX
  { 1, 90, 91, 0, 0 }, // 287 LFDU
  { 1, 90, 91, 0, 0 }, // 288 LFDUX
  { 0, 0, 0, 0, 0 }, // 289 VPMSUMB_VPMSUMD_VPMSUMH_VPMSUMW_VCIPHER_VCIPHERLAST_VNCIPHER_VNCIPHERLAST_VSBOX
  { 1, 88, 89, 0, 0 }, // 290 BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_BCCTR_BCCTR8_BCCTR8n_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_BCCTRn_BDNZ_BDNZ8_BDNZA_BDNZAm_BDNZAp_BDNZm_BDNZp_BDZ_BDZ8_BDZA_BDZAm_BDZAp_BDZm_BDZp_BDNZL_BDNZLA_BDNZLAm_BDNZLAp_BDNZLR_BDNZLR8_BDNZLRL_BDNZLRLm_BDNZLRLp_BDNZLRm_BDNZLRp_BDNZLm_BDNZLp_BDZL_BDZLA_BDZLAm_BDZLAp_BDZLR_BDZLR8_BDZLRL_BDZLRLm_BDZLRLp_BDZLRm_BDZLRp_BDZLm_BDZLp_BL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM_BLR_BLR8_BLRL_TAILB_TAILB8_TAILBA_TAILBA8_TAILBCTR_TAILBCTR8_gBC_gBCA_gBCAat_gBCCTR_gBCCTRL_gBCL_gBCLA_gBCLAat_gBCLR_gBCLRL_gBCLat_gBCat_BCLR_BCLRL_BCLRLn_BCLRn_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_RM_BCTRL_RM_B_BA_BC_BCC_BCCA_BCL_BCLalways_BCLn_BCTRL8_LDinto_toc_BCTRL_LWZinto_toc_BCTRL8_LDinto_toc_RM_BCTRL_LWZinto_toc_RM_BCn_CTRL_DEP
  { 1, 88, 89, 0, 0 }, // 291 ADDPCIS
  { 1, 90, 91, 0, 0 }, // 292 LDAT_LWAT
  { 1, 90, 91, 0, 0 }, // 293 STDAT_STWAT
  { 1, 87, 88, 0, 0 }, // 294 BRINC
  { 0, 0, 0, 0, 0 }, // 295 EVABS_EVEQV_EVNAND_EVNEG_EVADDIW_EVADDW_EVAND_EVANDC_EVCMPEQ_EVCMPGTS_EVCMPGTU_EVCMPLTS_EVCMPLTU_EVCNTLSW_EVCNTLZW_EVEXTSB_EVEXTSH_EVMERGEHI_EVMERGEHILO_EVMERGELO_EVMERGELOHI_EVNOR_EVOR_EVORC_EVXOR_EVRLW_EVRLWI_EVRNDW_EVSLW_EVSLWI_EVSPLATFI_EVSPLATI_EVSRWIS_EVSRWIU_EVSRWS_EVSRWU_EVSUBFW_EVSUBIFW
  { 0, 0, 0, 0, 0 }, // 296 EVMRA_EVADDSMIAAW_EVADDSSIAAW_EVADDUMIAAW_EVADDUSIAAW_EVDIVWS_EVDIVWU_EVMHEGSMFAA_EVMHEGSMFAN_EVMHEGSMIAA_EVMHEGSMIAN_EVMHEGUMIAA_EVMHEGUMIAN_EVMHESMF_EVMHESMFA_EVMHESMFAAW_EVMHESMFANW_EVMHESMI_EVMHESMIA_EVMHESMIAAW_EVMHESMIANW_EVMHESSF_EVMHESSFA_EVMHESSFAAW_EVMHESSFANW_EVMHESSIAAW_EVMHESSIANW_EVMHEUMI_EVMHEUMIA_EVMHEUMIAAW_EVMHEUMIANW_EVMHEUSIAAW_EVMHEUSIANW_EVMHOGSMFAA_EVMHOGSMFAN_EVMHOGSMIAA_EVMHOGSMIAN_EVMHOGUMIAA_EVMHOGUMIAN_EVMHOSMF_EVMHOSMFA_EVMHOSMFAAW_EVMHOSMFANW_EVMHOSMI_EVMHOSMIA_EVMHOSMIAAW_EVMHOSMIANW_EVMHOSSF_EVMHOSSFA_EVMHOSSFAAW_EVMHOSSFANW_EVMHOSSIAAW_EVMHOSSIANW_EVMHOUMI_EVMHOUMIA_EVMHOUMIAAW_EVMHOUMIANW_EVMHOUSIAAW_EVMHOUSIANW_EVMWHSMF_EVMWHSMFA_EVMWHSMI_EVMWHSMIA_EVMWHSSF_EVMWHSSFA_EVMWHUMI_EVMWHUMIA_EVMWLSMIAAW_EVMWLSMIANW_EVMWLSSIAAW_EVMWLSSIANW_EVMWLUMI_EVMWLUMIA_EVMWLUMIAAW_EVMWLUMIANW_EVMWLUSIAAW_EVMWLUSIANW_EVMWSMF_EVMWSMFA_EVMWSMFAA_EVMWSMFAN_EVMWSMI_EVMWSMIA_EVMWSMIAA_EVMWSMIAN_EVMWSSF_EVMWSSFA_EVMWSSFAA_EVMWSSFAN_EVMWUMI_EVMWUMIA_EVMWUMIAA_EVMWUMIAN_EVSUBFSMIAAW_EVSUBFSSIAAW_EVSUBFUMIAAW_EVSUBFUSIAAW
  { 1, 90, 91, 0, 0 }, // 297 EVLDD_EVLDDX_EVLDH_EVLDHX_EVLDW_EVLDWX_EVLHHESPLAT_EVLHHESPLATX_EVLHHOSSPLAT_EVLHHOSSPLATX_EVLHHOUSPLAT_EVLHHOUSPLATX_EVLWHE_EVLWHEX_EVLWHOS_EVLWHOSX_EVLWHOU_EVLWHOUX_EVLWHSPLAT_EVLWHSPLATX_EVLWWSPLAT_EVLWWSPLATX
  { 1, 90, 91, 0, 0 }, // 298 EVSTDD_EVSTDDX_EVSTDH_EVSTDHX_EVSTDW_EVSTDWX_EVSTWHE_EVSTWHEX_EVSTWHO_EVSTWHOX_EVSTWWE_EVSTWWEX_EVSTWWO_EVSTWWOX
  { 1, 88, 89, 0, 0 }, // 299 HRFID_ATTN_CLRBHRB_MFBHRBE_NAP_RFCI_RFDI_RFMCI_SC
  { 1, 96, 97, 0, 0 }, // 300 RFI
  { 0, 0, 0, 0, 0 }, // 301 RFID
  { 1, 90, 91, 0, 0 }, // 302 DSS_DSSALL_DST_DST64_DSTST_DSTST64_DSTSTT_DSTSTT64_DSTT_DSTT64_ICBLQ_LBEPX_LHEPX_LWEPX_TLBIVAX_TLBLD_TLBLI_TLBRE_TLBRE2_TLBSX_TLBSX2_TLBSX2D_TLBWE_TLBWE2_MBAR_TRAP_DCCCI_ICCCI
  { 1, 90, 91, 0, 0 }, // 303 ICBLC_STBEPX_STHEPX_STWEPX
  { 1, 90, 91, 0, 0 }, // 304 LFDEPX
  { 1, 90, 91, 0, 0 }, // 305 STFDEPX
  { 1, 98, 99, 0, 0 }, // 306 MFSR_MFSRIN
  { 1, 96, 97, 0, 0 }, // 307 MTSR_MTSRIN
  { 1, 98, 99, 0, 0 }, // 308 MFDCR
  { 1, 96, 97, 0, 0 }, // 309 MTDCR
  { 1, 87, 88, 0, 0 }, // 310 NOP_GT_PWR6_NOP_GT_PWR7
  { 0, 0, 0, 0, 0 }, // 311 TLBIA
  { 1, 89, 90, 0, 0 }, // 312 WRTEE_WRTEEI
  { 1, 87, 88, 0, 0 }, // 313 HASHCHK_HASHCHK8_HASHCHKP_HASHCHKP8_HASHST_HASHST8_HASHSTP_HASHSTP8_ADDEX_ADDEX8
  { 1, 86, 87, 0, 0 }, // 314 MSYNC
  { 0, 0, 0, 0, 0 }, // 315 SLBSYNC
  { 0, 0, 0, 0, 0 }, // 316 SLBFEE_rec
  { 0, 0, 0, 0, 0 }, // 317 STOP
  { 1, 86, 87, 0, 0 }, // 318 DCBA_DCBI
  { 1, 92, 93, 0, 0 }, // 319 FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRE_FRES_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRSP_FRSQRTE_FRSQRTES
  { 0, 0, 0, 0, 0 }, // 320 VCFSX_VCFSX_0_VCFUX_VCFUX_0_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VLOGEFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP
  { 0, 0, 0, 0, 0 }, // 321 XSCVDPHP_XSCVDPSP_XSCVDPSPN_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPSXWSs_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPUXWSs_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSP_XSRSQRTEDP_XSRSQRTESP
  { 0, 0, 0, 0, 0 }, // 322 XVCVSPBF16
  { 1, 92, 93, 0, 0 }, // 323 FADDS_FMULS_FSUBS
  { 1, 95, 96, 0, 0 }, // 324 FMUL
  { 0, 0, 0, 0, 0 }, // 325 VADDFP_XVADDDP_XVADDSP_XVMULDP_XVMULSP_XVSUBDP_XVSUBSP
  { 0, 0, 0, 0, 0 }, // 326 VSUBFP
  { 0, 0, 0, 0, 0 }, // 327 XSADDDP_XSADDSP_XSSUBDP_XSSUBSP
  { 0, 0, 0, 0, 0 }, // 328 XSMULDP_XSMULSP
  { 0, 0, 0, 0, 0 }, // 329 VMADDFP_VNMSUBFP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP
  { 0, 0, 0, 0, 0 }, // 330 VEXPTEFP
  { 1, 92, 93, 0, 0 }, // 331 FADDS_rec_FMULS_rec_FSUBS_rec
  { 1, 95, 96, 0, 0 }, // 332 FMUL_rec
  { 1, 92, 93, 0, 0 }, // 333 FCFID_rec_FCFIDS_rec_FCFIDU_rec_FCFIDUS_rec_FCTID_rec_FCTIDU_rec_FCTIDUZ_rec_FCTIDZ_rec_FCTIW_rec_FCTIWU_rec_FCTIWUZ_rec_FCTIWZ_rec_FRE_rec_FRES_rec_FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRSP_rec_FRSQRTE_rec_FRSQRTES_rec
  { 1, 88, 89, 0, 0 }, // 334 BCLR_BCLRn_BDNZLR_BDNZLR8_BDNZLRm_BDNZLRp_BDZLR_BDZLR8_BDZLRm_BDZLRp_gBCLR_BCLRL_BCLRLn_BDNZLRL_BDNZLRLm_BDNZLRLp_BDZLRL_BDZLRLm_BDZLRLp_gBCLRL_BL_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLR_BLR8_BLRL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS
  { 1, 88, 89, 0, 0 }, // 335 BL8_NOTOC_BL8_NOTOC_RM_BL8_NOTOC_TLS
  { 1, 88, 89, 0, 0 }, // 336 B_BCC_BCCA_BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_CTRL_DEP_TAILB_TAILB8_BA_TAILBA_TAILBA8_BC_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_LDinto_toc_BCTRL8_LDinto_toc_RM_BCTRL8_RM_BCTRL_LWZinto_toc_BCTRL_LWZinto_toc_RM_BCTRL_RM_BCn_BDNZ_BDNZ8_BDNZm_BDNZp_BDZ_BDZ8_BDZm_BDZp_TAILBCTR_TAILBCTR8_gBC_gBCat_BCL_BCLalways_BCLn_BDNZL_BDNZLm_BDNZLp_BDZL_BDZLm_BDZLp_gBCL_gBCLat_BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM
  { 1, 88, 89, 0, 0 }, // 337 BCCTR_BCCTR8_BCCTR8n_BCCTRn_gBCCTR_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_gBCCTRL
  { 0, 0, 0, 0, 0 }, // 338 VSBOX
  { 1, 87, 88, 0, 0 }, // 339 CFUGED_CNTLZDM_CNTTZDM_PDEPD_PEXTD
  { 0, 0, 0, 0, 0 }, // 340 VCFUGED_VCLZDM_VCTZDM_VGNB_VPDEPD_VPEXTD
  { 0, 0, 0, 0, 0 }, // 341 XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP
  { 0, 0, 0, 0, 0 }, // 342 XSCVQPSQZ_XSCVQPUQZ_XSCVSQQP_XSCVUQQP
  { 0, 0, 0, 0, 0 }, // 343 XSADDQP_XSADDQPO_XSSUBQP_XSSUBQPO
  { 1, 87, 88, 0, 0 }, // 344 HASHST_HASHST8_HASHSTP_HASHSTP8
  { 0, 0, 0, 0, 0 }, // 345 XSMULQP_XSMULQPO
  { 0, 0, 0, 0, 0 }, // 346 VDIVESQ_VDIVEUQ_VDIVSQ_VDIVUQ
  { 0, 0, 0, 0, 0 }, // 347 VMODSQ_VMODUQ
  { 1, 91, 92, 0, 0 }, // 348 DIVWE_DIVWEO_DIVWEU_DIVWEUO
  { 0, 0, 0, 0, 0 }, // 349 VDIVSD_VDIVUD
  { 0, 0, 0, 0, 0 }, // 350 VMODSD_VMODUD
  { 0, 0, 0, 0, 0 }, // 351 VDIVSW_VDIVUW
  { 0, 0, 0, 0, 0 }, // 352 VMODSW_VMODUW
  { 0, 0, 0, 0, 0 }, // 353 VDIVESD_VDIVEUD
  { 0, 0, 0, 0, 0 }, // 354 VDIVESW_VDIVEUW
  { 0, 0, 0, 0, 0 }, // 355 BCDCTN_rec_VMUL10CUQ_VMUL10UQ_XSXSIGQP
  { 0, 0, 0, 0, 0 }, // 356 BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDUS_rec_BCDUTRUNC_rec_VADDCUQ_VMUL10ECUQ_VMUL10EUQ_VSUBCUQ_XSTSTDCQP
  { 0, 0, 0, 0, 0 }, // 357 VADDUQM_VSUBUQM
  { 0, 0, 0, 0, 0 }, // 358 XSMAXCQP_XSMINCQP
  { 0, 0, 0, 0, 0 }, // 359 XXGENPCVBM
  { 0, 0, 0, 0, 0 }, // 360 BCDADD_rec_BCDS_rec_BCDSUB_rec_BCDTRUNC_rec_VADDECUQ_VADDEUQM_VSUBECUQ_VSUBEUQM
  { 1, 90, 91, 0, 0 }, // 361 TRAP
  { 1, 104, 105, 0, 0 }, // 362 TW
  { 1, 87, 88, 0, 0 }, // 363 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW
  { 1, 92, 93, 0, 0 }, // 364 FTSQRT
  { 0, 0, 0, 0, 0 }, // 365 MTVSRBM_MTVSRBMI_MTVSRDM_MTVSRHM_MTVSRQM_MTVSRWM_VEXPANDBM_VEXPANDDM_VEXPANDHM_VEXPANDQM_VEXPANDWM_VEXTRACTBM_VEXTRACTDM_VEXTRACTHM_VEXTRACTQM_VEXTRACTWM_XVTLSBB
  { 1, 87, 88, 0, 0 }, // 366 POPCNTB_POPCNTB8
  { 0, 0, 0, 0, 0 }, // 367 VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTD_VPOPCNTW_VPRTYBD_VPRTYBW
  { 0, 0, 0, 0, 0 }, // 368 VPOPCNTB_VPOPCNTH
  { 0, 0, 0, 0, 0 }, // 369 XSCVSPDPN
  { 1, 92, 93, 0, 0 }, // 370 XSTSQRTDP
  { 0, 0, 0, 0, 0 }, // 371 XVCVHPSP
  { 1, 92, 93, 0, 0 }, // 372 XVTSQRTDP_XVTSQRTSP
  { 1, 87, 88, 0, 0 }, // 373 CMPEQB
  { 0, 0, 0, 0, 0 }, // 374 EXTSWSLI_32_64_rec_EXTSWSLI_rec
  { 0, 0, 0, 0, 0 }, // 375 SLD_rec_SRD_rec
  { 1, 87, 88, 0, 0 }, // 376 SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 0, 0, 0, 0, 0 }, // 377 VADDCUW_VADDSBS_VADDSHS_VADDSWS_VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VMAXFP_VMINFP_VSUBCUW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP
  { 0, 0, 0, 0, 0 }, // 378 VCMPBFP_VCMPBFP_rec_VCMPEQFP_VCMPEQFP_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPGTSB_rec_VCMPGTSD_rec_VCMPGTSH_rec_VCMPGTSW_rec_VCMPGTUB_rec_VCMPGTUD_rec_VCMPGTUH_rec_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 0, 0, 0, 0, 0 }, // 379 VCMPEQUQ_VCMPEQUQ_rec_VCMPGTSQ_VCMPGTSQ_rec_VCMPGTUQ_VCMPGTUQ_rec
  { 0, 0, 0, 0, 0 }, // 380 VCMPSQ_VCMPUQ_VCNTMBB_VCNTMBD_VCNTMBH_VCNTMBW
  { 0, 0, 0, 0, 0 }, // 381 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP
  { 0, 0, 0, 0, 0 }, // 382 RLDIC_rec
  { 0, 0, 0, 0, 0 }, // 383 RLDICL_32_rec_RLDICL_rec_RLDICR_rec
  { 0, 0, 0, 0, 0 }, // 384 VSHASIGMAD_VSHASIGMAW
  { 0, 0, 0, 0, 0 }, // 385 VRLQ_VRLQNM_VSLQ_VSRAQ_VSRQ
  { 0, 0, 0, 0, 0 }, // 386 VRLQMI
  { 1, 89, 90, 0, 0 }, // 387 CR6SET_CREQV_CRSET
  { 1, 90, 91, 0, 0 }, // 388 DSS_DSSALL
  { 1, 98, 99, 0, 0 }, // 389 MFCTR_MFCTR8_MFLR_MFLR8
  { 1, 87, 88, 0, 0 }, // 390 NOP_ORI_ORI8
  { 0, 0, 0, 0, 0 }, // 391 VXOR_V_SET0_V_SET0B_V_SET0H
  { 0, 0, 0, 0, 0 }, // 392 XXLEQV_XXLEQVOnes_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 1, 87, 88, 0, 0 }, // 393 ADDI_ADDI8_LI_LI8_ADDIS_ADDIS8_LIS_LIS8_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_NEG_NEG8_NEG8_rec_NEG_rec_NEG8O_NEGO
  { 0, 0, 0, 0, 0 }, // 394 ADDIdtprelL32_ADDItlsldLADDR32_ADDISdtprelHA32
  { 0, 0, 0, 0, 0 }, // 395 ADDItocL_ADDIStocHA_ADDIStocHA8
  { 1, 87, 88, 0, 0 }, // 396 ADDME_ADDME8_ADDME8O_ADDMEO_ADDZE_ADDZE8_ADDZE8O_ADDZEO_SUBFME_SUBFME8_SUBFME8O_SUBFMEO_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZEO
  { 1, 92, 93, 0, 0 }, // 397 FABSD_FABSS_FMR_FNABSD_FNABSS_FNEGD_FNEGS
  { 1, 87, 88, 0, 0 }, // 398 SETB_SETB8
  { 1, 87, 88, 0, 0 }, // 399 SETBC_SETBC8_SETBCR_SETBCR8_SETNBC_SETNBC8_SETNBCR_SETNBCR8
  { 0, 0, 0, 0, 0 }, // 400 VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VNEGD_VNEGW
  { 0, 0, 0, 0, 0 }, // 401 VEXTSD2Q
  { 0, 0, 0, 0, 0 }, // 402 XSABSDP_XSNABSDP_XSNEGDP_XSXEXPDP
  { 0, 0, 0, 0, 0 }, // 403 XSABSQP_XSNABSQP_XSNEGQP_XSXEXPQP_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVNEGDP_XVNEGSP_XVXEXPDP_XVXEXPSP
  { 0, 0, 0, 0, 0 }, // 404 XVXSIGDP_XVXSIGSP
  { 1, 87, 88, 0, 0 }, // 405 ADD4_ADD4TLS_ADD8_ADD8TLS_ADD8TLS__ADD4_rec_ADD8_rec_ADD4O_ADD8O_AND_AND8_AND8_rec_AND_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_EQV_EQV8_EQV8_rec_EQV_rec_NAND_NAND8_NAND8_rec_NAND_rec_NOR_NOR8_NOR8_rec_NOR_rec_OR_OR8_OR8_rec_OR_rec_ORC_ORC8_ORC8_rec_ORC_rec_ORIS_ORIS8_XOR_XOR8_XOR8_rec_XOR_rec_XORI_XORI8_XORIS_XORIS8
  { 1, 87, 88, 0, 0 }, // 406 ADDE_ADDE8_ADDE8O_ADDEO_ADDIC_ADDIC8_ANDI8_rec_ANDI_rec_ANDIS8_rec_ANDIS_rec_SUBF_SUBF8_SUBF8_rec_SUBF_rec_SUBFE_SUBFE8_SUBFE8O_SUBFEO_SUBFIC_SUBFIC8_SUBF8O_SUBFO
  { 1, 87, 88, 0, 0 }, // 407 CMPB_CMPB8
  { 0, 0, 0, 0, 0 }, // 408 EXTSWSLI_EXTSWSLI_32_64_SRADI_SRADI_32
  { 1, 87, 88, 0, 0 }, // 409 SLW_SLW8_SRW_SRW8
  { 0, 0, 0, 0, 0 }, // 410 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEQV_VNAND_VORC_VSLD_VSRAD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_XXLAND_XXLANDC_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC
  { 0, 0, 0, 0, 0 }, // 411 VAND_VANDC_VMRGEW_VMRGOW_VNOR_VOR_VRLB_VRLD_VRLDNM_VRLH_VRLW_VRLWNM_VSLB_VSLH_VSLW_VSRAB_VSRAH_VSRAW_VSRB_VSRH_VSRW_XSCPSGNQP_XSIEXPQP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP
  { 0, 0, 0, 0, 0 }, // 412 VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW
  { 1, 87, 88, 0, 0 }, // 413 ADDEX_ADDEX8
  { 1, 90, 91, 0, 0 }, // 414 DST_DST64_DSTT_DSTT64_DSTST_DSTST64_DSTSTT_DSTSTT64
  { 0, 0, 0, 0, 0 }, // 415 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32
  { 1, 92, 93, 0, 0 }, // 416 MFFS_MFFS_rec_MFFSL
  { 1, 96, 97, 0, 0 }, // 417 TRECHKPT
  { 1, 87, 88, 0, 0 }, // 418 ADDME8_rec_ADDME_rec_ADDME8O_rec_ADDMEO_rec_ADDZE8_rec_ADDZE_rec_ADDZE8O_rec_ADDZEO_rec_SUBFME8_rec_SUBFME_rec_SUBFME8O_rec_SUBFMEO_rec_SUBFZE8_rec_SUBFZE_rec_SUBFZE8O_rec_SUBFZEO_rec
  { 1, 99, 100, 0, 0 }, // 419 MTFSB0
  { 1, 87, 88, 0, 0 }, // 420 NEG8O_rec_NEGO_rec
  { 1, 87, 88, 0, 0 }, // 421 ADDE8_rec_ADDE_rec_ADDE8O_rec_ADDEO_rec_ADDIC_rec_SUBFE8_rec_SUBFE_rec_SUBFE8O_rec_SUBFEO_rec_SUBF8O_rec_SUBFO_rec
  { 1, 88, 89, 0, 0 }, // 422 HRFID
  { 1, 92, 93, 0, 0 }, // 423 FABSD_rec_FABSS_rec_FMR_rec_FNABSD_rec_FNABSS_rec_FNEGD_rec_FNEGS_rec
  { 1, 88, 89, 0, 0 }, // 424 SC
  { 1, 87, 88, 0, 0 }, // 425 ADDC_ADDC8_ADDC8O_ADDCO_SUBFC_SUBFC8_SUBFC8O_SUBFCO
  { 1, 87, 88, 0, 0 }, // 426 ADDC8_rec_ADDC_rec_SUBFC8_rec_SUBFC_rec
  { 1, 92, 93, 0, 0 }, // 427 MTFSF_MTFSFI_MTFSFIb
  { 1, 92, 93, 0, 0 }, // 428 MTFSFI_rec
  { 0, 0, 0, 0, 0 }, // 429 VSTRIBL_rec_VSTRIBR_rec_VSTRIHL_rec_VSTRIHR_rec
  { 1, 90, 91, 0, 0 }, // 430 LBZ_LBZ8_LDBRX_LHBRX_LHBRX8_LHZ_LHZ8_LWBRX_LWBRX8_LWZ_LWZ8
  { 0, 0, 0, 0, 0 }, // 431 LD
  { 0, 0, 0, 0, 0 }, // 432 LDtoc_LDtocBA_LDtocCPT_LDtocJTI_LDtocL_SPILLTOVSR_LD_LWZtoc_LWZtocL
  { 1, 90, 91, 0, 0 }, // 433 LXVRBX_LXVRDX_LXVRHX_LXVRWX
  { 1, 86, 87, 0, 0 }, // 434 DCBT_DCBTST
  { 1, 90, 91, 0, 0 }, // 435 ICBT_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32
  { 0, 0, 0, 0, 0 }, // 436 LDX_LDXTLS_LDXTLS_
  { 0, 0, 0, 0, 0 }, // 437 SPILLTOVSR_LDX
  { 1, 90, 91, 0, 0 }, // 438 LBZCIX_LDCIX_LHZCIX_LWZCIX
  { 1, 96, 97, 0, 0 }, // 439 MTSR
  { 1, 87, 88, 0, 0 }, // 440 MTVRSAVE_MTVRSAVEv
  { 1, 90, 91, 0, 0 }, // 441 LSWI
  { 1, 90, 91, 0, 0 }, // 442 PLBZ_PLBZ8_PLBZ8pc_PLBZpc_PLD_PLDpc_PLFD_PLFDpc_PLFS_PLFSpc_PLHA_PLHA8_PLHA8pc_PLHApc_PLHZ_PLHZ8_PLHZ8pc_PLHZpc_PLWA_PLWA8_PLWA8pc_PLWApc_PLWZ_PLWZ8_PLWZ8pc_PLWZpc_PLXSD_PLXSDpc_PLXSSP_PLXSSPpc_PLXV_PLXVpc_PLXVP_PLXVPpc
  { 1, 90, 91, 0, 0 }, // 443 LXVP_LXVPX
  { 1, 98, 99, 0, 0 }, // 444 MFSR
  { 1, 98, 99, 0, 0 }, // 445 MFTB8
  { 0, 0, 0, 0, 0 }, // 446 XXSETACCZ
  { 0, 0, 0, 0, 0 }, // 447 XVBF16GER2_XVF16GER2_XVF32GER_XVF64GER_XVI16GER2_XVI16GER2S_XVI4GER8_XVI8GER4
  { 0, 0, 0, 0, 0 }, // 448 XVBF16GER2NN_XVBF16GER2NP_XVBF16GER2PN_XVBF16GER2PP_XVF16GER2NN_XVF16GER2NP_XVF16GER2PN_XVF16GER2PP_XVF32GERNN_XVF32GERNP_XVF32GERPN_XVF32GERPP_XVF64GERNN_XVF64GERNP_XVF64GERPN_XVF64GERPP_XVI16GER2PP_XVI16GER2SPP_XVI4GER8PP_XVI8GER4PP
  { 0, 0, 0, 0, 0 }, // 449 XVI8GER4SPP
  { 0, 0, 0, 0, 0 }, // 450 PMXVF32GER_PMXVF64GER
  { 0, 0, 0, 0, 0 }, // 451 PMXVBF16GER2_PMXVF16GER2_PMXVF32GERNN_PMXVF32GERNP_PMXVF32GERPN_PMXVF32GERPP_PMXVF64GERNN_PMXVF64GERNP_PMXVF64GERPN_PMXVF64GERPP_PMXVI16GER2_PMXVI16GER2S_PMXVI4GER8_PMXVI8GER4
  { 0, 0, 0, 0, 0 }, // 452 PMXVBF16GER2NN_PMXVBF16GER2NP_PMXVBF16GER2PN_PMXVBF16GER2PP_PMXVF16GER2NN_PMXVF16GER2NP_PMXVF16GER2PN_PMXVF16GER2PP_PMXVI16GER2PP_PMXVI16GER2SPP_PMXVI4GER8PP_PMXVI8GER4PP
  { 0, 0, 0, 0, 0 }, // 453 PMXVI8GER4SPP
  { 0, 0, 0, 0, 0 }, // 454 XXMTACC
  { 0, 0, 0, 0, 0 }, // 455 XXMFACC
  { 0, 0, 0, 0, 0 }, // 456 MULLD_MULLDO
  { 0, 0, 0, 0, 0 }, // 457 VMULHSD_VMULHUD_VMULLD
  { 0, 0, 0, 0, 0 }, // 458 VSPLTISW
  { 0, 0, 0, 0, 0 }, // 459 V_SETALLONES_V_SETALLONESB_V_SETALLONESH
  { 0, 0, 0, 0, 0 }, // 460 MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VPRTYBQ
  { 0, 0, 0, 0, 0 }, // 461 VGBBD_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW
  { 0, 0, 0, 0, 0 }, // 462 VSPLTISB_VSPLTISH_XXSPLTIB
  { 0, 0, 0, 0, 0 }, // 463 VSTRIBL_VSTRIBR_VSTRIHL_VSTRIHR
  { 0, 0, 0, 0, 0 }, // 464 XVCVBF16SPN
  { 0, 0, 0, 0, 0 }, // 465 VBPERMQ_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLO_VSLV_VSR_VSRO_VSRV_XXEXTRACTUW
  { 0, 0, 0, 0, 0 }, // 466 VCLRLB_VCLRRB_XXGENPCVDM_XXGENPCVHM_XXGENPCVWM
  { 0, 0, 0, 0, 0 }, // 467 VEXTRACTD_VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VINSERTD_VINSERTW
  { 0, 0, 0, 0, 0 }, // 468 VEXTDDVLX_VEXTDDVRX_VEXTDUBVLX_VEXTDUBVRX_VEXTDUHVLX_VEXTDUHVRX_VEXTDUWVLX_VEXTDUWVRX_VINSBLX_VINSBRX_VINSBVLX_VINSBVRX_VINSD_VINSDLX_VINSDRX_VINSHLX_VINSHRX_VINSHVLX_VINSHVRX_VINSW_VINSWLX_VINSWRX_VINSWVLX_VINSWVRX_VSLDBI_VSRDBI
  { 0, 0, 0, 0, 0 }, // 469 VSUMSWS
  { 0, 0, 0, 0, 0 }, // 470 XXSPLTIDP_XXSPLTIW
  { 0, 0, 0, 0, 0 }, // 471 XXBLENDVB_XXBLENDVD_XXBLENDVH_XXBLENDVW_XXSPLTI32DX
  { 0, 0, 0, 0, 0 }, // 472 XXEVAL
  { 0, 0, 0, 0, 0 }, // 473 XXPERMX
  { 1, 86, 87, 0, 0 }, // 474 DCBST_DCBZ
  { 1, 86, 87, 0, 0 }, // 475 ICBI
  { 1, 86, 87, 0, 0 }, // 476 DCBF
  { 1, 90, 91, 0, 0 }, // 477 PSTXVP_PSTXVPpc
  { 1, 90, 91, 0, 0 }, // 478 STB_STB8_STDBRX_STH_STH8_STHBRX_STW_STW8_STWBRX
  { 0, 0, 0, 0, 0 }, // 479 SPILLTOVSR_ST
  { 0, 0, 0, 0, 0 }, // 480 STD
  { 0, 0, 0, 0, 0 }, // 481 DFSTOREf32_DFSTOREf64_STIWX
  { 1, 90, 91, 0, 0 }, // 482 STXVRBX_STXVRDX_STXVRHX_STXVRWX
  { 0, 0, 0, 0, 0 }, // 483 SPILLTOVSR_STX
  { 1, 90, 91, 0, 0 }, // 484 EnforceIEIO
  { 1, 90, 91, 0, 0 }, // 485 STBCIX_STDCIX_STHCIX_STWCIX
  { 1, 90, 91, 0, 0 }, // 486 PSTB_PSTB8_PSTB8pc_PSTBpc_PSTD_PSTDpc_PSTFD_PSTFDpc_PSTFS_PSTFSpc_PSTH_PSTH8_PSTH8pc_PSTHpc_PSTW_PSTW8_PSTW8pc_PSTWpc_PSTXSD_PSTXSDpc_PSTXSSP_PSTXSSPpc_PSTXV_PSTXVpc
  { 1, 90, 91, 0, 0 }, // 487 STXVP_STXVPX
  { 1, 88, 89, 0, 0 }, // 488 ATTN_NAP
  { 1, 86, 87, 0, 0 }, // 489 DCBZL
  { 1, 90, 91, 0, 0 }, // 490 DCCCI_ICBLQ_ICCCI_TLBLD_TLBLI_TLBRE2_TLBSX2_TLBSX2D_TLBWE2
  { 1, 90, 91, 0, 0 }, // 491 ICBLC
  { 1, 88, 89, 0, 0 }, // 492 CLRBHRB
  { 1, 88, 89, 0, 0 }, // 493 MFBHRBE
  { 1, 90, 91, 0, 0 }, // 494 PADDI_PADDI8_PADDI8pc_PADDIpc
  { 1, 87, 88, 0, 0 }, // 495 PLI_PLI8
  { 0, 0, 0, 0, 0 }, // 496 VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS
  { 0, 0, 0, 0, 0 }, // 497 VMULESD_VMULEUD_VMULHSW_VMULHUW_VMULOSD_VMULOUD
  { 0, 0, 0, 0, 0 }, // 498 VMSUMCUD
  { 0, uint16_t(~0U), uint16_t(~0U), uint16_t(~0U), uint16_t(~0U) }// end marker
};

static const llvm::InstrItinerary G4Itineraries[] = {
  { 0, 0, 0, 0, 0 }, // 0 NoInstrModel
  { 1, 105, 106, 0, 0 }, // 1 IIC_LdStSync
  { 1, 106, 107, 0, 0 }, // 2 IIC_IntSimple
  { 1, 106, 107, 0, 0 }, // 3 IIC_IntGeneral
  { 1, 107, 108, 0, 0 }, // 4 IIC_BrB
  { 1, 108, 109, 0, 0 }, // 5 IIC_VecFP
  { 1, 106, 107, 0, 0 }, // 6 IIC_IntCompare
  { 0, 0, 0, 0, 0 }, // 7 IIC_SprABORT
  { 0, 0, 0, 0, 0 }, // 8 IIC_LdStCOPY
  { 0, 0, 0, 0, 0 }, // 9 IIC_LdStPASTE
  { 1, 109, 110, 0, 0 }, // 10 IIC_BrCR
  { 0, 0, 0, 0, 0 }, // 11 IIC_LdStLD
  { 1, 110, 111, 0, 0 }, // 12 IIC_LdStDCBF
  { 1, 110, 111, 0, 0 }, // 13 IIC_LdStLoad
  { 0, 0, 0, 0, 0 }, // 14 IIC_IntDivD
  { 1, 111, 112, 0, 0 }, // 15 IIC_IntDivW
  { 0, 0, 0, 0, 0 }, // 16 IIC_FPDGeneral
  { 1, 112, 113, 0, 0 }, // 17 IIC_FPAddSub
  { 1, 113, 114, 0, 0 }, // 18 IIC_FPDivD
  { 0, 0, 0, 0, 0 }, // 19 IIC_FPSGeneral
  { 1, 112, 113, 0, 0 }, // 20 IIC_FPCompare
  { 1, 112, 113, 0, 0 }, // 21 IIC_FPGeneral
  { 1, 114, 115, 0, 0 }, // 22 IIC_VecGeneral
  { 1, 115, 116, 0, 0 }, // 23 IIC_VecComplex
  { 1, 110, 111, 0, 0 }, // 24 IIC_LdStStore
  { 0, 0, 0, 0, 0 }, // 25 IIC_IntRotateDI
  { 1, 116, 117, 0, 0 }, // 26 IIC_FPDivS
  { 1, 112, 113, 0, 0 }, // 27 IIC_FPFused
  { 0, 0, 0, 0, 0 }, // 28 IIC_FPSqrtD
  { 0, 0, 0, 0, 0 }, // 29 IIC_FPSqrtS
  { 1, 110, 111, 0, 0 }, // 30 IIC_LdStICBI
  { 0, 0, 0, 0, 0 }, // 31 IIC_IntISEL
  { 1, 117, 118, 0, 0 }, // 32 IIC_SprISYNC
  { 1, 118, 119, 0, 0 }, // 33 IIC_LdStLWARX
  { 1, 110, 111, 0, 0 }, // 34 IIC_LdStLoadUpd
  { 1, 110, 111, 0, 0 }, // 35 IIC_LdStLoadUpdX
  { 0, 0, 0, 0, 0 }, // 36 IIC_LdStLDARX
  { 0, 0, 0, 0, 0 }, // 37 IIC_LdStLDU
  { 0, 0, 0, 0, 0 }, // 38 IIC_LdStLDUX
  { 1, 110, 111, 0, 0 }, // 39 IIC_LdStLFD
  { 1, 110, 111, 0, 0 }, // 40 IIC_LdStLFDU
  { 1, 110, 111, 0, 0 }, // 41 IIC_LdStLFDUX
  { 1, 110, 111, 0, 0 }, // 42 IIC_LdStLHA
  { 1, 110, 111, 0, 0 }, // 43 IIC_LdStLHAU
  { 1, 110, 111, 0, 0 }, // 44 IIC_LdStLHAUX
  { 1, 119, 120, 0, 0 }, // 45 IIC_LdStLMW
  { 0, 0, 0, 0, 0 }, // 46 IIC_LdStLQ
  { 0, 0, 0, 0, 0 }, // 47 IIC_LdStLQARX
  { 0, 0, 0, 0, 0 }, // 48 IIC_LdStLWA
  { 0, 0, 0, 0, 0 }, // 49 IIC_IntMulHD
  { 1, 109, 110, 0, 0 }, // 50 IIC_BrMCR
  { 1, 109, 110, 0, 0 }, // 51 IIC_BrMCRX
  { 1, 109, 110, 0, 0 }, // 52 IIC_SprMFCR
  { 1, 120, 121, 0, 0 }, // 53 IIC_SprMFSPR
  { 1, 121, 122, 0, 0 }, // 54 IIC_IntMFFS
  { 1, 109, 110, 0, 0 }, // 55 IIC_SprMFMSR
  { 0, 0, 0, 0, 0 }, // 56 IIC_SprMFCRF
  { 0, 0, 0, 0, 0 }, // 57 IIC_SprMFPMR
  { 1, 120, 121, 0, 0 }, // 58 IIC_SprMFSR
  { 1, 109, 110, 0, 0 }, // 59 IIC_SprMFTB
  { 0, 0, 0, 0, 0 }, // 60 IIC_SprMSGSYNC
  { 1, 117, 118, 0, 0 }, // 61 IIC_SprMTSPR
  { 1, 121, 122, 0, 0 }, // 62 IIC_IntMTFSB0
  { 1, 109, 110, 0, 0 }, // 63 IIC_SprMTMSR
  { 0, 0, 0, 0, 0 }, // 64 IIC_SprMTMSRD
  { 0, 0, 0, 0, 0 }, // 65 IIC_SprMTPMR
  { 1, 117, 118, 0, 0 }, // 66 IIC_SprMTSR
  { 1, 122, 123, 0, 0 }, // 67 IIC_IntMulHW
  { 1, 123, 124, 0, 0 }, // 68 IIC_IntMulHWU
  { 1, 124, 125, 0, 0 }, // 69 IIC_IntMulLI
  { 1, 117, 118, 0, 0 }, // 70 IIC_SprRFI
  { 0, 0, 0, 0, 0 }, // 71 IIC_IntRFID
  { 0, 0, 0, 0, 0 }, // 72 IIC_IntRotateD
  { 1, 106, 107, 0, 0 }, // 73 IIC_IntRotate
  { 0, 0, 0, 0, 0 }, // 74 IIC_SprSLBFEE
  { 0, 0, 0, 0, 0 }, // 75 IIC_SprSLBIA
  { 0, 0, 0, 0, 0 }, // 76 IIC_SprSLBIE
  { 0, 0, 0, 0, 0 }, // 77 IIC_SprSLBIEG
  { 0, 0, 0, 0, 0 }, // 78 IIC_SprSLBMFEE
  { 0, 0, 0, 0, 0 }, // 79 IIC_SprSLBMFEV
  { 0, 0, 0, 0, 0 }, // 80 IIC_SprSLBMTE
  { 0, 0, 0, 0, 0 }, // 81 IIC_SprSLBSYNC
  { 1, 106, 107, 0, 0 }, // 82 IIC_IntShift
  { 1, 125, 126, 0, 0 }, // 83 IIC_LdStSTWCX
  { 1, 110, 111, 0, 0 }, // 84 IIC_LdStSTU
  { 1, 110, 111, 0, 0 }, // 85 IIC_LdStSTUX
  { 0, 0, 0, 0, 0 }, // 86 IIC_LdStSTD
  { 0, 0, 0, 0, 0 }, // 87 IIC_LdStSTDCX
  { 1, 110, 111, 0, 0 }, // 88 IIC_LdStSTFD
  { 1, 110, 111, 0, 0 }, // 89 IIC_LdStSTFDU
  { 0, 0, 0, 0, 0 }, // 90 IIC_SprSTOP
  { 0, 0, 0, 0, 0 }, // 91 IIC_LdStSTQ
  { 0, 0, 0, 0, 0 }, // 92 IIC_LdStSTQCX
  { 0, 0, 0, 0, 0 }, // 93 IIC_IntTrapD
  { 0, 0, 0, 0, 0 }, // 94 IIC_SprTLBIA
  { 0, 0, 0, 0, 0 }, // 95 IIC_SprTLBIE
  { 0, 0, 0, 0, 0 }, // 96 IIC_SprTLBIEL
  { 1, 126, 127, 0, 0 }, // 97 IIC_SprTLBSYNC
  { 1, 127, 128, 0, 0 }, // 98 IIC_IntTrapW
  { 1, 114, 115, 0, 0 }, // 99 IIC_VecFPCompare
  { 1, 128, 129, 0, 0 }, // 100 IIC_VecPerm
  { 1, 114, 115, 0, 0 }, // 101 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VSLD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_VPOPCNTB_VPOPCNTH_VSRAD_MTVSRDD_VEQV_VNAND_VNEGD_VNEGW_VORC_XXLAND_XXLANDC_XXLEQV_XXLEQVOnes_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 1, 108, 109, 0, 0 }, // 102 VAND_VANDC_V_SET0_V_SET0B_V_SET0H_VSLB_VSLH_VSLW_VSRB_VSRH_VSRW_VRLB_VRLD_VRLH_VRLW_VSRAB_VSRAH_VSRAW_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP_XVXEXPDP_XVXEXPSP_VRLDMI_VRLDNM_VRLWMI_VRLWNM_VMRGEW_VMRGOW_VNOR_VOR_VSEL_VXOR_XVNEGDP_XVNEGSP_XSABSQP_XSCPSGNQP_XSIEXPQP_XSNABSQP_XSNEGQP_XSXEXPQP
  { 1, 128, 129, 0, 0 }, // 103 XXSEL
  { 1, 117, 118, 0, 0 }, // 104 TABORTDC_TABORTDCI_TABORTWC_TABORTWCI
  { 1, 121, 122, 0, 0 }, // 105 MTFSB0_MTFSB1
  { 1, 121, 122, 0, 0 }, // 106 MFFSCDRN_MFFSCDRNI_MFFSCRN_MFFSCRNI
  { 1, 106, 107, 0, 0 }, // 107 CMPRB_CMPRB8_CMPEQB
  { 0, 0, 0, 0, 0 }, // 108 TD_TDI
  { 1, 127, 128, 0, 0 }, // 109 TW_TWI
  { 1, 112, 113, 0, 0 }, // 110 FCMPOD_FCMPOS_FCMPUD_FCMPUS_FTDIV_FTSQRT
  { 1, 108, 109, 0, 0 }, // 111 XSTSTDCDP_XSTSTDCSP
  { 1, 108, 109, 0, 0 }, // 112 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP_XSXSIGDP_XSCVSPDPN
  { 1, 112, 113, 0, 0 }, // 113 XSCMPEQDP_XSCMPEXPDP_XSCMPGEDP_XSCMPGTDP_XSCMPODP_XSCMPUDP_XSTDIVDP_XSTSQRTDP
  { 1, 106, 107, 0, 0 }, // 114 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW_CMPB_CMPB8_SETB_SETB8_BPERMD
  { 0, 0, 0, 0, 0 }, // 115 SLD_SRD_SRAD
  { 0, 0, 0, 0, 0 }, // 116 SRADI_EXTSWSLI_32_64_EXTSWSLI_SRADI_32_RLDIC
  { 1, 114, 115, 0, 0 }, // 117 MFVRD_MFVSRD_MTVRD_MTVSRD_MTVRWA_MTVRWZ_MTVSRWA_MTVSRWZ_MFVSRWZ_MFVRWZ
  { 1, 106, 107, 0, 0 }, // 118 CMPLW_CMPLWI_CMPW_CMPWI_CMPD_CMPDI_CMPLD_CMPLDI
  { 1, 106, 107, 0, 0 }, // 119 SUBFC_SUBFC8_SUBFC8O_SUBFCO_SUBFIC_SUBFIC8_ANDI8_rec_ANDIS8_rec_ANDIS_rec_ANDI_rec_ADDC_ADDC8_ADDC8O_ADDCO_ADDIC_ADDIC8_ADDIC_rec_ADDE_ADDE8_ADDE8O_ADDE8O_rec_ADDE8_rec_ADDEO_ADDEO_rec_ADDE_rec_ADDME_ADDME8_ADDME8O_ADDME8O_rec_ADDME8_rec_ADDMEO_ADDMEO_rec_ADDME_rec_ADDZE_ADDZE8_ADDZE8O_ADDZE8O_rec_ADDZE8_rec_ADDZEO_ADDZEO_rec_ADDZE_rec_SUBF_SUBF8_SUBF8O_SUBF8O_rec_SUBF8_rec_SUBFE_SUBFE8_SUBFE8O_SUBFE8O_rec_SUBFE8_rec_SUBFEO_SUBFEO_rec_SUBFE_rec_SUBFME_SUBFME8_SUBFME8O_SUBFME8O_rec_SUBFME8_rec_SUBFMEO_SUBFMEO_rec_SUBFME_rec_SUBFO_SUBFO_rec_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZE8O_rec_SUBFZE8_rec_SUBFZEO_SUBFZEO_rec_SUBFZE_rec_SUBF_rec_POPCNTB_POPCNTB8_LA_LA8
  { 1, 106, 107, 0, 0 }, // 120 ADD4_ADD4O_ADD4O_rec_ADD4_rec_ADD8_ADD8O_ADD8O_rec_ADD8_rec_NEG_NEG8_NEG8O_NEG8O_rec_NEG8_rec_NEGO_NEGO_rec_NEG_rec_ADDI_ADDI8_ADDIS_ADDIS8_LI_LI8_LIS_LIS8_OR_OR8_OR8_rec_ORI_ORI8_ORIS_ORIS8_OR_rec_XOR_XOR8_XOR8_rec_XORI_XORI8_XORIS_XORIS8_XOR_rec_NAND_NAND8_NAND8_rec_NAND_rec_AND_AND8_AND8_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_AND_rec_NOR_NOR8_NOR8_rec_NOR_rec_ORC_ORC8_ORC8_rec_ORC_rec_EQV_EQV8_EQV8_rec_EQV_rec_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_ADD4TLS_ADD8TLS_ADD8TLS__NOP
  { 0, 0, 0, 0, 0 }, // 121 ADDIStocHA_ADDIStocHA8_ADDItocL_COPY
  { 1, 109, 110, 0, 0 }, // 122 MCRF
  { 1, 109, 110, 0, 0 }, // 123 MCRXRX
  { 1, 108, 109, 0, 0 }, // 124 XSNABSDP_XSXEXPDP_XSABSDP_XSNEGDP_XSCPSGNDP
  { 1, 107, 108, 0, 0 }, // 125 RFEBB
  { 1, 117, 118, 0, 0 }, // 126 TBEGIN_TRECHKPT
  { 1, 110, 111, 0, 0 }, // 127 WAIT
  { 0, 0, 0, 0, 0 }, // 128 RLDCL_RLDCR
  { 1, 106, 107, 0, 0 }, // 129 RLWIMI_RLWIMI8
  { 0, 0, 0, 0, 0 }, // 130 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32_RLDIMI
  { 0, 0, 0, 0, 0 }, // 131 MFOCRF_MFOCRF8
  { 1, 109, 110, 0, 0 }, // 132 MTOCRF_MTOCRF8
  { 1, 109, 110, 0, 0 }, // 133 CR6SET_CR6UNSET_CRSET_CRUNSET_CRAND_CRANDC_CRNAND_CRNOR_CROR_CRORC_CREQV_CRXOR
  { 1, 106, 107, 0, 0 }, // 134 SLW_SLW8_SRW_SRW8_RLWINM_RLWINM8_RLWNM_RLWNM8
  { 1, 112, 113, 0, 0 }, // 135 FABSD_FABSS_FNABSD_FNABSS_FNEGD_FNEGS_FCPSGND_FCPSGNS_FMR
  { 1, 106, 107, 0, 0 }, // 136 SRAW_SRAWI
  { 0, 0, 0, 0, 0 }, // 137 ISEL_ISEL8
  { 1, 108, 109, 0, 0 }, // 138 XSIEXPDP
  { 1, 117, 118, 0, 0 }, // 139 TRECLAIM_TSR_TABORT
  { 1, 110, 111, 0, 0 }, // 140 MFVSCR
  { 1, 110, 111, 0, 0 }, // 141 MTVSCR
  { 1, 114, 115, 0, 0 }, // 142 VCMPNEZB_VCMPNEZH_VCMPNEZW_VCMPEQUB_VCMPEQUD_VCMPEQUH_VCMPEQUW_VCMPNEB_VCMPNEH_VCMPNEW_VCMPEQFP_VCMPEQFP_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPBFP_VCMPBFP_rec_VCMPGTSB_VCMPGTSB_rec_VCMPGTSD_VCMPGTSD_rec_VCMPGTSH_VCMPGTSH_rec_VCMPGTSW_VCMPGTSW_rec_VCMPGTUB_VCMPGTUB_rec_VCMPGTUD_VCMPGTUD_rec_VCMPGTUH_VCMPGTUH_rec_VCMPGTUW_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 1, 114, 115, 0, 0 }, // 143 VABSDUB_VABSDUH_VABSDUW_VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTW_VPOPCNTD_VPRTYBD_VPRTYBW
  { 1, 108, 109, 0, 0 }, // 144 VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VADDSBS_VADDSHS_VADDSWS_VMAXFP_VMINFP_VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW_VBPERMD_VADDCUW_VSHASIGMAD_VSHASIGMAW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_VSUBCUW_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP_XVXSIGDP_XVXSIGSP
  { 1, 112, 113, 0, 0 }, // 145 XVTDIVDP_XVTDIVSP_XVTSQRTDP_XVTSQRTSP
  { 1, 108, 109, 0, 0 }, // 146 VADDFP_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VEXPTEFP_VLOGEFP_VMADDFP_VMHADDSHS_VNMSUBFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVADDDP_XVADDSP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVHPSP_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVMULDP_XVMULSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP_XVSUBDP_XVSUBSP_VCFSX_VCFSX_0_VCFUX_VCFUX_0_VMHRADDSHS_VMLADDUHM_VMSUMMBM_VMSUMSHM_VMSUMSHS_VMSUMUBM_VMSUMUHM_VMSUMUDM_VMSUMUHS_VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS_VSUMSWS
  { 1, 114, 115, 0, 0 }, // 147 VSUBFP_VMULUWM
  { 0, 0, 0, 0, 0 }, // 148 MADDHD_MADDHDU_MADDLD_MADDLD8_MULLD_MULLDO
  { 1, 122, 123, 0, 0 }, // 149 MULHD_MULHW_MULLW_MULLWO
  { 1, 123, 124, 0, 0 }, // 150 MULHDU_MULHWU
  { 1, 124, 125, 0, 0 }, // 151 MULLI_MULLI8
  { 1, 112, 113, 0, 0 }, // 152 FRSP_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRE_FRES_FADDS_FMSUBS_FMADDS_FSUBS_FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRSQRTE_FRSQRTES_FNMADDS_FNMSUBS_FSELD_FSELS_FMULS
  { 1, 112, 113, 0, 0 }, // 153 FADD_FSUB
  { 1, 112, 113, 0, 0 }, // 154 FMSUB_FMADD_FNMADD_FNMSUB_FMUL
  { 1, 108, 109, 0, 0 }, // 155 XSMADDADP_XSMADDASP_XSMADDMDP_XSMADDMSP_XSMSUBADP_XSMSUBASP_XSMSUBMDP_XSMSUBMSP_XSMULDP_XSMULSP_XSNMADDADP_XSNMADDASP_XSNMADDMDP_XSNMADDMSP_XSNMSUBADP_XSNMSUBASP_XSNMSUBMDP_XSNMSUBMSP
  { 1, 112, 113, 0, 0 }, // 156 FSELD_rec_FSELS_rec
  { 1, 123, 124, 0, 0 }, // 157 MULHDU_rec_MULHWU_rec
  { 1, 122, 123, 0, 0 }, // 158 MULHD_rec_MULHW_rec_MULLWO_rec_MULLW_rec
  { 0, 0, 0, 0, 0 }, // 159 MULLDO_rec_MULLD_rec
  { 1, 112, 113, 0, 0 }, // 160 FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRES_rec_FRE_rec_FADDS_rec_FSUBS_rec_FMSUBS_rec_FNMSUBS_rec_FMADDS_rec_FNMADDS_rec_FCFIDS_rec_FCFIDUS_rec_FCFIDU_rec_FCFID_rec_FCTIDUZ_rec_FCTIDU_rec_FCTIDZ_rec_FCTID_rec_FCTIWUZ_rec_FCTIWU_rec_FCTIWZ_rec_FCTIW_rec_FMULS_rec_FRSQRTES_rec_FRSQRTE_rec_FRSP_rec
  { 1, 112, 113, 0, 0 }, // 161 FADD_rec_FSUB_rec
  { 1, 112, 113, 0, 0 }, // 162 FMSUB_rec_FNMSUB_rec_FMADD_rec_FNMADD_rec_FMUL_rec
  { 1, 108, 109, 0, 0 }, // 163 XSADDDP_XSADDSP_XSCVDPHP_XSCVDPSP_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPSXWSs_XSCVDPUXWSs_XSCVHPDP_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSQRTEDP_XSRSQRTESP_XSSUBDP_XSSUBSP_XSCVDPSPN_XSRSP
  { 1, 110, 111, 0, 0 }, // 164 LVSL_LVSR
  { 1, 128, 129, 0, 0 }, // 165 VSPLTISB_VSPLTISH_VSPLTISW_VSPLTB_VSPLTBs_VSPLTH_VSPLTHs_VSPLTW_XXMRGHW_XXMRGLW_XXPERM_XXPERMR_XXSLDWI_XXSLDWIs_XXSPLTIB_XXSPLTW_XXSPLTWs_XXPERMDI_XXPERMDIs
  { 1, 108, 109, 0, 0 }, // 166 V_SETALLONES_V_SETALLONESB_V_SETALLONESH_VBPERMQ_VGBBD_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPERM_VPERMR_VPERMXOR_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLDOI_VSLO_VSLV_VSR_VSRO_VSRV_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW_XXEXTRACTUW_XXINSERTW_VADDCUQ_VADDECUQ_VADDEUQM_VMUL10CUQ_VMUL10ECUQ_VMUL10EUQ_VMUL10UQ_VSUBCUQ_VSUBECUQ_VSUBEUQM_XSTSTDCQP_XSXSIGQP_BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDS_rec_BCDTRUNC_rec_BCDUS_rec_BCDUTRUNC_rec_BCDADD_rec_BCDSUB_rec
  { 1, 114, 115, 0, 0 }, // 167 VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VINSERTB_VINSERTD_VINSERTH_VINSERTW_MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VEXTRACTD_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VPRTYBQ_VADDUQM_VSUBUQM
  { 1, 112, 113, 0, 0 }, // 168 XSCMPEXPQP_XSCMPOQP_XSCMPUQP
  { 1, 108, 109, 0, 0 }, // 169 BCDSR_rec_XSADDQP_XSADDQPO_XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP_XSRQPI_XSRQPIX_XSRQPXP_XSSUBQP_XSSUBQPO
  { 1, 108, 109, 0, 0 }, // 170 BCDCTSQ_rec
  { 1, 108, 109, 0, 0 }, // 171 XSMADDQP_XSMADDQPO_XSMSUBQP_XSMSUBQPO_XSMULQP_XSMULQPO_XSNMADDQP_XSNMADDQPO_XSNMSUBQP_XSNMSUBQPO
  { 1, 108, 109, 0, 0 }, // 172 BCDCFSQ_rec
  { 1, 108, 109, 0, 0 }, // 173 XSDIVQP_XSDIVQPO
  { 1, 108, 109, 0, 0 }, // 174 XSSQRTQP_XSSQRTQPO
  { 1, 110, 111, 0, 0 }, // 175 LXVL_LXVLL
  { 1, 110, 111, 0, 0 }, // 176 LVEBX_LVEHX_LVEWX_LVX_LVXL
  { 1, 110, 111, 0, 0 }, // 177 LXSIBZX_LXSIHZX_LXSDX_LXVB16X_LXVD2X_LXVWSX_LXSIWZX_LXV_LXVX_LXSD
  { 0, 0, 0, 0, 0 }, // 178 DFLOADf64_XFLOADf64_LIWZX
  { 1, 110, 111, 0, 0 }, // 179 DCBF_DCBFEP_DCBST_DCBSTEP_DCBT_DCBTEP_DCBZ_DCBZEP_DCBZL_DCBZLEP_DCBTST_DCBTSTEP
  { 0, 0, 0, 0, 0 }, // 180 CP_COPY_CP_COPY8
  { 1, 110, 111, 0, 0 }, // 181 ICBI_ICBIEP
  { 1, 110, 111, 0, 0 }, // 182 ICBT_ICBTLS_LBZ_LBZ8_LBZCIX_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LDBRX_LDCIX_LHBRX_LHBRX8_LHZ_LHZ8_LHZCIX_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWBRX_LWBRX8_LWZ_LWZ8_LWZCIX_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32_EnforceIEIO_LSWI
  { 1, 118, 119, 0, 0 }, // 183 LBARX_LBARXL_LHARX_LHARXL_LWARX_LWARXL
  { 0, 0, 0, 0, 0 }, // 184 LD_LDX_LDXTLS_LDXTLS__DARN
  { 0, 0, 0, 0, 0 }, // 185 LDARX_LDARXL
  { 0, 0, 0, 0, 0 }, // 186 CP_ABORT
  { 1, 117, 118, 0, 0 }, // 187 ISYNC
  { 0, 0, 0, 0, 0 }, // 188 MSGSYNC
  { 1, 126, 127, 0, 0 }, // 189 TLBSYNC
  { 1, 105, 106, 0, 0 }, // 190 SYNC
  { 1, 119, 120, 0, 0 }, // 191 LMW
  { 1, 110, 111, 0, 0 }, // 192 LFIWZX_LFDX_LFD
  { 0, 0, 0, 0, 0 }, // 193 SLBIA
  { 0, 0, 0, 0, 0 }, // 194 SLBIE
  { 0, 0, 0, 0, 0 }, // 195 SLBMFEE
  { 0, 0, 0, 0, 0 }, // 196 SLBMFEV
  { 0, 0, 0, 0, 0 }, // 197 SLBMTE
  { 0, 0, 0, 0, 0 }, // 198 TLBIEL
  { 1, 110, 111, 0, 0 }, // 199 LHZU_LHZU8_LWZU_LWZU8
  { 1, 110, 111, 0, 0 }, // 200 LHZUX_LHZUX8_LWZUX_LWZUX8
  { 1, 117, 118, 0, 0 }, // 201 TEND
  { 1, 125, 126, 0, 0 }, // 202 STBCX_STHCX_STWCX
  { 0, 0, 0, 0, 0 }, // 203 STDCX
  { 0, 0, 0, 0, 0 }, // 204 LDMX
  { 1, 110, 111, 0, 0 }, // 205 LHA_LHA8_LHAX_LHAX8_LWAX_LWAX_32
  { 0, 0, 0, 0, 0 }, // 206 CP_PASTE8_rec_CP_PASTE_rec
  { 0, 0, 0, 0, 0 }, // 207 LWA_LWA_32
  { 1, 117, 118, 0, 0 }, // 208 TCHECK
  { 1, 110, 111, 0, 0 }, // 209 LFIWAX
  { 1, 110, 111, 0, 0 }, // 210 LXSIWAX
  { 0, 0, 0, 0, 0 }, // 211 LIWAX
  { 1, 110, 111, 0, 0 }, // 212 LFSX_LFS
  { 1, 110, 111, 0, 0 }, // 213 LXSSP_LXSSPX
  { 0, 0, 0, 0, 0 }, // 214 XFLOADf32_DFLOADf32
  { 1, 110, 111, 0, 0 }, // 215 LHAU_LHAU8
  { 1, 110, 111, 0, 0 }, // 216 LHAUX_LHAUX8_LWAUX
  { 1, 110, 111, 0, 0 }, // 217 LXVH8X_LXVDSX_LXVW4X
  { 1, 110, 111, 0, 0 }, // 218 STFD_STFDX_STFIWX_STFS_STFSX_STXSD_STXSDX_STXSIBX_STXSIBXv_STXSIHX_STXSIHXv_STXSIWX_STXSSP_STXSSPX
  { 1, 110, 111, 0, 0 }, // 219 STW_STW8_STDBRX_STHBRX_STWBRX_STB_STB8_STH_STH8_STBX_STBX8_STBXTLS_STBXTLS__STBXTLS_32_STHX_STHX8_STHXTLS_STHXTLS__STHXTLS_32_STWX_STWX8_STWXTLS_STWXTLS__STWXTLS_32
  { 0, 0, 0, 0, 0 }, // 220 DFSTOREf32_DFSTOREf64_XFSTOREf32_XFSTOREf64_STIWX
  { 0, 0, 0, 0, 0 }, // 221 STD_STDX_STDXTLS_STDXTLS_
  { 1, 110, 111, 0, 0 }, // 222 STBCIX_STDCIX_STHCIX_STWCIX_STSWI
  { 0, 0, 0, 0, 0 }, // 223 SLBIEG
  { 1, 119, 120, 0, 0 }, // 224 STMW
  { 0, 0, 0, 0, 0 }, // 225 TLBIE
  { 1, 110, 111, 0, 0 }, // 226 STVEBX_STVEHX_STVEWX_STVX_STVXL
  { 1, 110, 111, 0, 0 }, // 227 STXV_STXVB16X_STXVD2X_STXVH8X_STXVW4X_STXVX
  { 1, 110, 111, 0, 0 }, // 228 STXVL_STXVLL
  { 1, 117, 118, 0, 0 }, // 229 MTCTR_MTCTR8_MTCTR8loop_MTCTRloop_MTLR_MTLR8
  { 1, 106, 107, 0, 0 }, // 230 MFVRSAVE_MFVRSAVEv_MTVRSAVE_MTVRSAVEv
  { 0, 0, 0, 0, 0 }, // 231 MFPMR
  { 0, 0, 0, 0, 0 }, // 232 MTPMR
  { 1, 109, 110, 0, 0 }, // 233 MFTB_MFTB8
  { 1, 120, 121, 0, 0 }, // 234 MFCTR_MFCTR8_MFLR_MFLR8_MFSPR_MFSPR8
  { 1, 109, 110, 0, 0 }, // 235 MFMSR
  { 1, 109, 110, 0, 0 }, // 236 MTMSR
  { 0, 0, 0, 0, 0 }, // 237 MTMSRD
  { 1, 117, 118, 0, 0 }, // 238 MTSPR_MTSPR8
  { 1, 111, 112, 0, 0 }, // 239 DIVW_DIVWO_DIVWU_DIVWUO_MODSW
  { 1, 111, 112, 0, 0 }, // 240 DIVWE_DIVWEO_DIVWEU_DIVWEUO_MODSD_MODUD_MODUW
  { 0, 0, 0, 0, 0 }, // 241 DIVD_DIVDO_DIVDU_DIVDUO
  { 0, 0, 0, 0, 0 }, // 242 DIVDE_DIVDEO_DIVDEU_DIVDEUO
  { 1, 111, 112, 0, 0 }, // 243 DIVWO_rec_DIVWUO_rec_DIVWU_rec_DIVW_rec
  { 0, 0, 0, 0, 0 }, // 244 DIVD_rec_DIVDO_rec_DIVDU_rec_DIVDUO_rec
  { 1, 111, 112, 0, 0 }, // 245 DIVWE_rec_DIVWEO_rec_DIVWEU_rec_DIVWEUO_rec
  { 0, 0, 0, 0, 0 }, // 246 DIVDE_rec_DIVDEO_rec_DIVDEU_rec_DIVDEUO_rec
  { 1, 109, 110, 0, 0 }, // 247 MTCRF_MTCRF8
  { 1, 106, 107, 0, 0 }, // 248 ADDC8O_rec_ADDC8_rec_ADDCO_rec_ADDC_rec_SUBFC8O_rec_SUBFC8_rec_SUBFCO_rec_SUBFC_rec
  { 1, 112, 113, 0, 0 }, // 249 FABSD_rec_FABSS_rec_FNABSD_rec_FNABSS_rec_FCPSGND_rec_FCPSGNS_rec_FNEGD_rec_FNEGS_rec_FMR_rec
  { 1, 109, 110, 0, 0 }, // 250 MCRFS
  { 1, 121, 122, 0, 0 }, // 251 MTFSF_MTFSF_rec_MTFSFI_MTFSFI_rec_MTFSFIb
  { 1, 121, 122, 0, 0 }, // 252 MTFSFb
  { 0, 0, 0, 0, 0 }, // 253 RLDCL_rec_RLDCR_rec
  { 0, 0, 0, 0, 0 }, // 254 RLDICL_rec_RLDICR_rec_RLDICL_32_rec_RLDIMI_rec
  { 1, 106, 107, 0, 0 }, // 255 RLWIMI8_rec_RLWIMI_rec
  { 1, 106, 107, 0, 0 }, // 256 RLWINM8_rec_RLWINM_rec_RLWNM8_rec_RLWNM_rec_SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 1, 106, 107, 0, 0 }, // 257 SRAWI_rec_SRAW_rec
  { 1, 121, 122, 0, 0 }, // 258 MFFS_MFFSCE_MFFSL_MFFS_rec
  { 1, 109, 110, 0, 0 }, // 259 MFCR_MFCR8
  { 0, 0, 0, 0, 0 }, // 260 EXTSWSLI_32_64_rec_SRADI_rec_EXTSWSLI_rec_RLDIC_rec
  { 0, 0, 0, 0, 0 }, // 261 SRAD_rec_SLD_rec_SRD_rec
  { 1, 113, 114, 0, 0 }, // 262 FDIV
  { 1, 113, 114, 0, 0 }, // 263 FDIV_rec
  { 0, 0, 0, 0, 0 }, // 264 XSSQRTDP
  { 0, 0, 0, 0, 0 }, // 265 FSQRT
  { 0, 0, 0, 0, 0 }, // 266 XVSQRTDP
  { 0, 0, 0, 0, 0 }, // 267 XVSQRTSP
  { 0, 0, 0, 0, 0 }, // 268 FSQRT_rec
  { 0, 0, 0, 0, 0 }, // 269 XSSQRTSP
  { 0, 0, 0, 0, 0 }, // 270 FSQRTS
  { 0, 0, 0, 0, 0 }, // 271 FSQRTS_rec
  { 1, 113, 114, 0, 0 }, // 272 XSDIVDP
  { 1, 116, 117, 0, 0 }, // 273 FDIVS
  { 1, 116, 117, 0, 0 }, // 274 FDIVS_rec
  { 1, 116, 117, 0, 0 }, // 275 XSDIVSP
  { 1, 116, 117, 0, 0 }, // 276 XVDIVSP
  { 1, 113, 114, 0, 0 }, // 277 XVDIVDP
  { 1, 110, 111, 0, 0 }, // 278 LFSU
  { 1, 110, 111, 0, 0 }, // 279 LFSUX
  { 1, 110, 111, 0, 0 }, // 280 STFDU_STFDUX_STFSU_STFSUX
  { 1, 110, 111, 0, 0 }, // 281 STBU_STBU8_STDU_STHU_STHU8_STWU_STWU8
  { 1, 110, 111, 0, 0 }, // 282 STBUX_STBUX8_STDUX_STHUX_STHUX8_STWUX_STWUX8
  { 1, 110, 111, 0, 0 }, // 283 LBZU_LBZU8
  { 1, 110, 111, 0, 0 }, // 284 LBZUX_LBZUX8
  { 0, 0, 0, 0, 0 }, // 285 LDU
  { 0, 0, 0, 0, 0 }, // 286 LDUX
  { 1, 110, 111, 0, 0 }, // 287 LFDU
  { 1, 110, 111, 0, 0 }, // 288 LFDUX
  { 1, 108, 109, 0, 0 }, // 289 VPMSUMB_VPMSUMD_VPMSUMH_VPMSUMW_VCIPHER_VCIPHERLAST_VNCIPHER_VNCIPHERLAST_VSBOX
  { 1, 107, 108, 0, 0 }, // 290 BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_BCCTR_BCCTR8_BCCTR8n_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_BCCTRn_BDNZ_BDNZ8_BDNZA_BDNZAm_BDNZAp_BDNZm_BDNZp_BDZ_BDZ8_BDZA_BDZAm_BDZAp_BDZm_BDZp_BDNZL_BDNZLA_BDNZLAm_BDNZLAp_BDNZLR_BDNZLR8_BDNZLRL_BDNZLRLm_BDNZLRLp_BDNZLRm_BDNZLRp_BDNZLm_BDNZLp_BDZL_BDZLA_BDZLAm_BDZLAp_BDZLR_BDZLR8_BDZLRL_BDZLRLm_BDZLRLp_BDZLRm_BDZLRp_BDZLm_BDZLp_BL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM_BLR_BLR8_BLRL_TAILB_TAILB8_TAILBA_TAILBA8_TAILBCTR_TAILBCTR8_gBC_gBCA_gBCAat_gBCCTR_gBCCTRL_gBCL_gBCLA_gBCLAat_gBCLR_gBCLRL_gBCLat_gBCat_BCLR_BCLRL_BCLRLn_BCLRn_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_RM_BCTRL_RM_B_BA_BC_BCC_BCCA_BCL_BCLalways_BCLn_BCTRL8_LDinto_toc_BCTRL_LWZinto_toc_BCTRL8_LDinto_toc_RM_BCTRL_LWZinto_toc_RM_BCn_CTRL_DEP
  { 1, 107, 108, 0, 0 }, // 291 ADDPCIS
  { 1, 110, 111, 0, 0 }, // 292 LDAT_LWAT
  { 1, 110, 111, 0, 0 }, // 293 STDAT_STWAT
  { 1, 106, 107, 0, 0 }, // 294 BRINC
  { 1, 114, 115, 0, 0 }, // 295 EVABS_EVEQV_EVNAND_EVNEG_EVADDIW_EVADDW_EVAND_EVANDC_EVCMPEQ_EVCMPGTS_EVCMPGTU_EVCMPLTS_EVCMPLTU_EVCNTLSW_EVCNTLZW_EVEXTSB_EVEXTSH_EVMERGEHI_EVMERGEHILO_EVMERGELO_EVMERGELOHI_EVNOR_EVOR_EVORC_EVXOR_EVRLW_EVRLWI_EVRNDW_EVSLW_EVSLWI_EVSPLATFI_EVSPLATI_EVSRWIS_EVSRWIU_EVSRWS_EVSRWU_EVSUBFW_EVSUBIFW
  { 1, 115, 116, 0, 0 }, // 296 EVMRA_EVADDSMIAAW_EVADDSSIAAW_EVADDUMIAAW_EVADDUSIAAW_EVDIVWS_EVDIVWU_EVMHEGSMFAA_EVMHEGSMFAN_EVMHEGSMIAA_EVMHEGSMIAN_EVMHEGUMIAA_EVMHEGUMIAN_EVMHESMF_EVMHESMFA_EVMHESMFAAW_EVMHESMFANW_EVMHESMI_EVMHESMIA_EVMHESMIAAW_EVMHESMIANW_EVMHESSF_EVMHESSFA_EVMHESSFAAW_EVMHESSFANW_EVMHESSIAAW_EVMHESSIANW_EVMHEUMI_EVMHEUMIA_EVMHEUMIAAW_EVMHEUMIANW_EVMHEUSIAAW_EVMHEUSIANW_EVMHOGSMFAA_EVMHOGSMFAN_EVMHOGSMIAA_EVMHOGSMIAN_EVMHOGUMIAA_EVMHOGUMIAN_EVMHOSMF_EVMHOSMFA_EVMHOSMFAAW_EVMHOSMFANW_EVMHOSMI_EVMHOSMIA_EVMHOSMIAAW_EVMHOSMIANW_EVMHOSSF_EVMHOSSFA_EVMHOSSFAAW_EVMHOSSFANW_EVMHOSSIAAW_EVMHOSSIANW_EVMHOUMI_EVMHOUMIA_EVMHOUMIAAW_EVMHOUMIANW_EVMHOUSIAAW_EVMHOUSIANW_EVMWHSMF_EVMWHSMFA_EVMWHSMI_EVMWHSMIA_EVMWHSSF_EVMWHSSFA_EVMWHUMI_EVMWHUMIA_EVMWLSMIAAW_EVMWLSMIANW_EVMWLSSIAAW_EVMWLSSIANW_EVMWLUMI_EVMWLUMIA_EVMWLUMIAAW_EVMWLUMIANW_EVMWLUSIAAW_EVMWLUSIANW_EVMWSMF_EVMWSMFA_EVMWSMFAA_EVMWSMFAN_EVMWSMI_EVMWSMIA_EVMWSMIAA_EVMWSMIAN_EVMWSSF_EVMWSSFA_EVMWSSFAA_EVMWSSFAN_EVMWUMI_EVMWUMIA_EVMWUMIAA_EVMWUMIAN_EVSUBFSMIAAW_EVSUBFSSIAAW_EVSUBFUMIAAW_EVSUBFUSIAAW
  { 1, 110, 111, 0, 0 }, // 297 EVLDD_EVLDDX_EVLDH_EVLDHX_EVLDW_EVLDWX_EVLHHESPLAT_EVLHHESPLATX_EVLHHOSSPLAT_EVLHHOSSPLATX_EVLHHOUSPLAT_EVLHHOUSPLATX_EVLWHE_EVLWHEX_EVLWHOS_EVLWHOSX_EVLWHOU_EVLWHOUX_EVLWHSPLAT_EVLWHSPLATX_EVLWWSPLAT_EVLWWSPLATX
  { 1, 110, 111, 0, 0 }, // 298 EVSTDD_EVSTDDX_EVSTDH_EVSTDHX_EVSTDW_EVSTDWX_EVSTWHE_EVSTWHEX_EVSTWHO_EVSTWHOX_EVSTWWE_EVSTWWEX_EVSTWWO_EVSTWWOX
  { 1, 107, 108, 0, 0 }, // 299 HRFID_ATTN_CLRBHRB_MFBHRBE_NAP_RFCI_RFDI_RFMCI_SC
  { 1, 117, 118, 0, 0 }, // 300 RFI
  { 0, 0, 0, 0, 0 }, // 301 RFID
  { 1, 110, 111, 0, 0 }, // 302 DSS_DSSALL_DST_DST64_DSTST_DSTST64_DSTSTT_DSTSTT64_DSTT_DSTT64_ICBLQ_LBEPX_LHEPX_LWEPX_TLBIVAX_TLBLD_TLBLI_TLBRE_TLBRE2_TLBSX_TLBSX2_TLBSX2D_TLBWE_TLBWE2_MBAR_TRAP_DCCCI_ICCCI
  { 1, 110, 111, 0, 0 }, // 303 ICBLC_STBEPX_STHEPX_STWEPX
  { 1, 110, 111, 0, 0 }, // 304 LFDEPX
  { 1, 110, 111, 0, 0 }, // 305 STFDEPX
  { 1, 120, 121, 0, 0 }, // 306 MFSR_MFSRIN
  { 1, 117, 118, 0, 0 }, // 307 MTSR_MTSRIN
  { 1, 120, 121, 0, 0 }, // 308 MFDCR
  { 1, 117, 118, 0, 0 }, // 309 MTDCR
  { 1, 106, 107, 0, 0 }, // 310 NOP_GT_PWR6_NOP_GT_PWR7
  { 0, 0, 0, 0, 0 }, // 311 TLBIA
  { 1, 109, 110, 0, 0 }, // 312 WRTEE_WRTEEI
  { 1, 106, 107, 0, 0 }, // 313 HASHCHK_HASHCHK8_HASHCHKP_HASHCHKP8_HASHST_HASHST8_HASHSTP_HASHSTP8_ADDEX_ADDEX8
  { 1, 105, 106, 0, 0 }, // 314 MSYNC
  { 0, 0, 0, 0, 0 }, // 315 SLBSYNC
  { 0, 0, 0, 0, 0 }, // 316 SLBFEE_rec
  { 0, 0, 0, 0, 0 }, // 317 STOP
  { 1, 110, 111, 0, 0 }, // 318 DCBA_DCBI
  { 1, 112, 113, 0, 0 }, // 319 FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRE_FRES_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRSP_FRSQRTE_FRSQRTES
  { 1, 108, 109, 0, 0 }, // 320 VCFSX_VCFSX_0_VCFUX_VCFUX_0_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VLOGEFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP
  { 1, 108, 109, 0, 0 }, // 321 XSCVDPHP_XSCVDPSP_XSCVDPSPN_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPSXWSs_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPUXWSs_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSP_XSRSQRTEDP_XSRSQRTESP
  { 1, 108, 109, 0, 0 }, // 322 XVCVSPBF16
  { 1, 112, 113, 0, 0 }, // 323 FADDS_FMULS_FSUBS
  { 1, 112, 113, 0, 0 }, // 324 FMUL
  { 1, 108, 109, 0, 0 }, // 325 VADDFP_XVADDDP_XVADDSP_XVMULDP_XVMULSP_XVSUBDP_XVSUBSP
  { 1, 114, 115, 0, 0 }, // 326 VSUBFP
  { 1, 108, 109, 0, 0 }, // 327 XSADDDP_XSADDSP_XSSUBDP_XSSUBSP
  { 1, 108, 109, 0, 0 }, // 328 XSMULDP_XSMULSP
  { 1, 108, 109, 0, 0 }, // 329 VMADDFP_VNMSUBFP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP
  { 1, 108, 109, 0, 0 }, // 330 VEXPTEFP
  { 1, 112, 113, 0, 0 }, // 331 FADDS_rec_FMULS_rec_FSUBS_rec
  { 1, 112, 113, 0, 0 }, // 332 FMUL_rec
  { 1, 112, 113, 0, 0 }, // 333 FCFID_rec_FCFIDS_rec_FCFIDU_rec_FCFIDUS_rec_FCTID_rec_FCTIDU_rec_FCTIDUZ_rec_FCTIDZ_rec_FCTIW_rec_FCTIWU_rec_FCTIWUZ_rec_FCTIWZ_rec_FRE_rec_FRES_rec_FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRSP_rec_FRSQRTE_rec_FRSQRTES_rec
  { 1, 107, 108, 0, 0 }, // 334 BCLR_BCLRn_BDNZLR_BDNZLR8_BDNZLRm_BDNZLRp_BDZLR_BDZLR8_BDZLRm_BDZLRp_gBCLR_BCLRL_BCLRLn_BDNZLRL_BDNZLRLm_BDNZLRLp_BDZLRL_BDZLRLm_BDZLRLp_gBCLRL_BL_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLR_BLR8_BLRL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS
  { 1, 107, 108, 0, 0 }, // 335 BL8_NOTOC_BL8_NOTOC_RM_BL8_NOTOC_TLS
  { 1, 107, 108, 0, 0 }, // 336 B_BCC_BCCA_BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_CTRL_DEP_TAILB_TAILB8_BA_TAILBA_TAILBA8_BC_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_LDinto_toc_BCTRL8_LDinto_toc_RM_BCTRL8_RM_BCTRL_LWZinto_toc_BCTRL_LWZinto_toc_RM_BCTRL_RM_BCn_BDNZ_BDNZ8_BDNZm_BDNZp_BDZ_BDZ8_BDZm_BDZp_TAILBCTR_TAILBCTR8_gBC_gBCat_BCL_BCLalways_BCLn_BDNZL_BDNZLm_BDNZLp_BDZL_BDZLm_BDZLp_gBCL_gBCLat_BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM
  { 1, 107, 108, 0, 0 }, // 337 BCCTR_BCCTR8_BCCTR8n_BCCTRn_gBCCTR_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_gBCCTRL
  { 1, 108, 109, 0, 0 }, // 338 VSBOX
  { 1, 106, 107, 0, 0 }, // 339 CFUGED_CNTLZDM_CNTTZDM_PDEPD_PEXTD
  { 1, 114, 115, 0, 0 }, // 340 VCFUGED_VCLZDM_VCTZDM_VGNB_VPDEPD_VPEXTD
  { 1, 108, 109, 0, 0 }, // 341 XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP
  { 1, 108, 109, 0, 0 }, // 342 XSCVQPSQZ_XSCVQPUQZ_XSCVSQQP_XSCVUQQP
  { 1, 108, 109, 0, 0 }, // 343 XSADDQP_XSADDQPO_XSSUBQP_XSSUBQPO
  { 1, 106, 107, 0, 0 }, // 344 HASHST_HASHST8_HASHSTP_HASHSTP8
  { 1, 108, 109, 0, 0 }, // 345 XSMULQP_XSMULQPO
  { 1, 114, 115, 0, 0 }, // 346 VDIVESQ_VDIVEUQ_VDIVSQ_VDIVUQ
  { 1, 114, 115, 0, 0 }, // 347 VMODSQ_VMODUQ
  { 1, 111, 112, 0, 0 }, // 348 DIVWE_DIVWEO_DIVWEU_DIVWEUO
  { 1, 114, 115, 0, 0 }, // 349 VDIVSD_VDIVUD
  { 1, 114, 115, 0, 0 }, // 350 VMODSD_VMODUD
  { 1, 114, 115, 0, 0 }, // 351 VDIVSW_VDIVUW
  { 1, 114, 115, 0, 0 }, // 352 VMODSW_VMODUW
  { 1, 114, 115, 0, 0 }, // 353 VDIVESD_VDIVEUD
  { 1, 114, 115, 0, 0 }, // 354 VDIVESW_VDIVEUW
  { 1, 108, 109, 0, 0 }, // 355 BCDCTN_rec_VMUL10CUQ_VMUL10UQ_XSXSIGQP
  { 1, 108, 109, 0, 0 }, // 356 BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDUS_rec_BCDUTRUNC_rec_VADDCUQ_VMUL10ECUQ_VMUL10EUQ_VSUBCUQ_XSTSTDCQP
  { 1, 114, 115, 0, 0 }, // 357 VADDUQM_VSUBUQM
  { 1, 108, 109, 0, 0 }, // 358 XSMAXCQP_XSMINCQP
  { 1, 114, 115, 0, 0 }, // 359 XXGENPCVBM
  { 1, 108, 109, 0, 0 }, // 360 BCDADD_rec_BCDS_rec_BCDSUB_rec_BCDTRUNC_rec_VADDECUQ_VADDEUQM_VSUBECUQ_VSUBEUQM
  { 1, 110, 111, 0, 0 }, // 361 TRAP
  { 1, 127, 128, 0, 0 }, // 362 TW
  { 1, 106, 107, 0, 0 }, // 363 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW
  { 1, 112, 113, 0, 0 }, // 364 FTSQRT
  { 1, 114, 115, 0, 0 }, // 365 MTVSRBM_MTVSRBMI_MTVSRDM_MTVSRHM_MTVSRQM_MTVSRWM_VEXPANDBM_VEXPANDDM_VEXPANDHM_VEXPANDQM_VEXPANDWM_VEXTRACTBM_VEXTRACTDM_VEXTRACTHM_VEXTRACTQM_VEXTRACTWM_XVTLSBB
  { 1, 106, 107, 0, 0 }, // 366 POPCNTB_POPCNTB8
  { 1, 114, 115, 0, 0 }, // 367 VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTD_VPOPCNTW_VPRTYBD_VPRTYBW
  { 1, 114, 115, 0, 0 }, // 368 VPOPCNTB_VPOPCNTH
  { 1, 108, 109, 0, 0 }, // 369 XSCVSPDPN
  { 1, 112, 113, 0, 0 }, // 370 XSTSQRTDP
  { 1, 108, 109, 0, 0 }, // 371 XVCVHPSP
  { 1, 112, 113, 0, 0 }, // 372 XVTSQRTDP_XVTSQRTSP
  { 1, 106, 107, 0, 0 }, // 373 CMPEQB
  { 0, 0, 0, 0, 0 }, // 374 EXTSWSLI_32_64_rec_EXTSWSLI_rec
  { 0, 0, 0, 0, 0 }, // 375 SLD_rec_SRD_rec
  { 1, 106, 107, 0, 0 }, // 376 SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 1, 108, 109, 0, 0 }, // 377 VADDCUW_VADDSBS_VADDSHS_VADDSWS_VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VMAXFP_VMINFP_VSUBCUW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP
  { 1, 114, 115, 0, 0 }, // 378 VCMPBFP_VCMPBFP_rec_VCMPEQFP_VCMPEQFP_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPGTSB_rec_VCMPGTSD_rec_VCMPGTSH_rec_VCMPGTSW_rec_VCMPGTUB_rec_VCMPGTUD_rec_VCMPGTUH_rec_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 1, 114, 115, 0, 0 }, // 379 VCMPEQUQ_VCMPEQUQ_rec_VCMPGTSQ_VCMPGTSQ_rec_VCMPGTUQ_VCMPGTUQ_rec
  { 1, 114, 115, 0, 0 }, // 380 VCMPSQ_VCMPUQ_VCNTMBB_VCNTMBD_VCNTMBH_VCNTMBW
  { 1, 108, 109, 0, 0 }, // 381 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP
  { 0, 0, 0, 0, 0 }, // 382 RLDIC_rec
  { 0, 0, 0, 0, 0 }, // 383 RLDICL_32_rec_RLDICL_rec_RLDICR_rec
  { 1, 108, 109, 0, 0 }, // 384 VSHASIGMAD_VSHASIGMAW
  { 1, 108, 109, 0, 0 }, // 385 VRLQ_VRLQNM_VSLQ_VSRAQ_VSRQ
  { 1, 108, 109, 0, 0 }, // 386 VRLQMI
  { 1, 109, 110, 0, 0 }, // 387 CR6SET_CREQV_CRSET
  { 1, 110, 111, 0, 0 }, // 388 DSS_DSSALL
  { 1, 120, 121, 0, 0 }, // 389 MFCTR_MFCTR8_MFLR_MFLR8
  { 1, 106, 107, 0, 0 }, // 390 NOP_ORI_ORI8
  { 1, 108, 109, 0, 0 }, // 391 VXOR_V_SET0_V_SET0B_V_SET0H
  { 1, 114, 115, 0, 0 }, // 392 XXLEQV_XXLEQVOnes_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 1, 106, 107, 0, 0 }, // 393 ADDI_ADDI8_LI_LI8_ADDIS_ADDIS8_LIS_LIS8_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_NEG_NEG8_NEG8_rec_NEG_rec_NEG8O_NEGO
  { 0, 0, 0, 0, 0 }, // 394 ADDIdtprelL32_ADDItlsldLADDR32_ADDISdtprelHA32
  { 0, 0, 0, 0, 0 }, // 395 ADDItocL_ADDIStocHA_ADDIStocHA8
  { 1, 106, 107, 0, 0 }, // 396 ADDME_ADDME8_ADDME8O_ADDMEO_ADDZE_ADDZE8_ADDZE8O_ADDZEO_SUBFME_SUBFME8_SUBFME8O_SUBFMEO_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZEO
  { 1, 112, 113, 0, 0 }, // 397 FABSD_FABSS_FMR_FNABSD_FNABSS_FNEGD_FNEGS
  { 1, 106, 107, 0, 0 }, // 398 SETB_SETB8
  { 1, 106, 107, 0, 0 }, // 399 SETBC_SETBC8_SETBCR_SETBCR8_SETNBC_SETNBC8_SETNBCR_SETNBCR8
  { 1, 114, 115, 0, 0 }, // 400 VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VNEGD_VNEGW
  { 1, 114, 115, 0, 0 }, // 401 VEXTSD2Q
  { 1, 108, 109, 0, 0 }, // 402 XSABSDP_XSNABSDP_XSNEGDP_XSXEXPDP
  { 1, 108, 109, 0, 0 }, // 403 XSABSQP_XSNABSQP_XSNEGQP_XSXEXPQP_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVNEGDP_XVNEGSP_XVXEXPDP_XVXEXPSP
  { 1, 108, 109, 0, 0 }, // 404 XVXSIGDP_XVXSIGSP
  { 1, 106, 107, 0, 0 }, // 405 ADD4_ADD4TLS_ADD8_ADD8TLS_ADD8TLS__ADD4_rec_ADD8_rec_ADD4O_ADD8O_AND_AND8_AND8_rec_AND_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_EQV_EQV8_EQV8_rec_EQV_rec_NAND_NAND8_NAND8_rec_NAND_rec_NOR_NOR8_NOR8_rec_NOR_rec_OR_OR8_OR8_rec_OR_rec_ORC_ORC8_ORC8_rec_ORC_rec_ORIS_ORIS8_XOR_XOR8_XOR8_rec_XOR_rec_XORI_XORI8_XORIS_XORIS8
  { 1, 106, 107, 0, 0 }, // 406 ADDE_ADDE8_ADDE8O_ADDEO_ADDIC_ADDIC8_ANDI8_rec_ANDI_rec_ANDIS8_rec_ANDIS_rec_SUBF_SUBF8_SUBF8_rec_SUBF_rec_SUBFE_SUBFE8_SUBFE8O_SUBFEO_SUBFIC_SUBFIC8_SUBF8O_SUBFO
  { 1, 106, 107, 0, 0 }, // 407 CMPB_CMPB8
  { 0, 0, 0, 0, 0 }, // 408 EXTSWSLI_EXTSWSLI_32_64_SRADI_SRADI_32
  { 1, 106, 107, 0, 0 }, // 409 SLW_SLW8_SRW_SRW8
  { 1, 114, 115, 0, 0 }, // 410 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEQV_VNAND_VORC_VSLD_VSRAD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_XXLAND_XXLANDC_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC
  { 1, 108, 109, 0, 0 }, // 411 VAND_VANDC_VMRGEW_VMRGOW_VNOR_VOR_VRLB_VRLD_VRLDNM_VRLH_VRLW_VRLWNM_VSLB_VSLH_VSLW_VSRAB_VSRAH_VSRAW_VSRB_VSRH_VSRW_XSCPSGNQP_XSIEXPQP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP
  { 1, 108, 109, 0, 0 }, // 412 VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW
  { 1, 106, 107, 0, 0 }, // 413 ADDEX_ADDEX8
  { 1, 110, 111, 0, 0 }, // 414 DST_DST64_DSTT_DSTT64_DSTST_DSTST64_DSTSTT_DSTSTT64
  { 0, 0, 0, 0, 0 }, // 415 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32
  { 1, 121, 122, 0, 0 }, // 416 MFFS_MFFS_rec_MFFSL
  { 1, 117, 118, 0, 0 }, // 417 TRECHKPT
  { 1, 106, 107, 0, 0 }, // 418 ADDME8_rec_ADDME_rec_ADDME8O_rec_ADDMEO_rec_ADDZE8_rec_ADDZE_rec_ADDZE8O_rec_ADDZEO_rec_SUBFME8_rec_SUBFME_rec_SUBFME8O_rec_SUBFMEO_rec_SUBFZE8_rec_SUBFZE_rec_SUBFZE8O_rec_SUBFZEO_rec
  { 1, 121, 122, 0, 0 }, // 419 MTFSB0
  { 1, 106, 107, 0, 0 }, // 420 NEG8O_rec_NEGO_rec
  { 1, 106, 107, 0, 0 }, // 421 ADDE8_rec_ADDE_rec_ADDE8O_rec_ADDEO_rec_ADDIC_rec_SUBFE8_rec_SUBFE_rec_SUBFE8O_rec_SUBFEO_rec_SUBF8O_rec_SUBFO_rec
  { 1, 107, 108, 0, 0 }, // 422 HRFID
  { 1, 112, 113, 0, 0 }, // 423 FABSD_rec_FABSS_rec_FMR_rec_FNABSD_rec_FNABSS_rec_FNEGD_rec_FNEGS_rec
  { 1, 107, 108, 0, 0 }, // 424 SC
  { 1, 106, 107, 0, 0 }, // 425 ADDC_ADDC8_ADDC8O_ADDCO_SUBFC_SUBFC8_SUBFC8O_SUBFCO
  { 1, 106, 107, 0, 0 }, // 426 ADDC8_rec_ADDC_rec_SUBFC8_rec_SUBFC_rec
  { 1, 121, 122, 0, 0 }, // 427 MTFSF_MTFSFI_MTFSFIb
  { 1, 121, 122, 0, 0 }, // 428 MTFSFI_rec
  { 1, 114, 115, 0, 0 }, // 429 VSTRIBL_rec_VSTRIBR_rec_VSTRIHL_rec_VSTRIHR_rec
  { 1, 110, 111, 0, 0 }, // 430 LBZ_LBZ8_LDBRX_LHBRX_LHBRX8_LHZ_LHZ8_LWBRX_LWBRX8_LWZ_LWZ8
  { 0, 0, 0, 0, 0 }, // 431 LD
  { 0, 0, 0, 0, 0 }, // 432 LDtoc_LDtocBA_LDtocCPT_LDtocJTI_LDtocL_SPILLTOVSR_LD_LWZtoc_LWZtocL
  { 1, 110, 111, 0, 0 }, // 433 LXVRBX_LXVRDX_LXVRHX_LXVRWX
  { 1, 110, 111, 0, 0 }, // 434 DCBT_DCBTST
  { 1, 110, 111, 0, 0 }, // 435 ICBT_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32
  { 0, 0, 0, 0, 0 }, // 436 LDX_LDXTLS_LDXTLS_
  { 0, 0, 0, 0, 0 }, // 437 SPILLTOVSR_LDX
  { 1, 110, 111, 0, 0 }, // 438 LBZCIX_LDCIX_LHZCIX_LWZCIX
  { 1, 117, 118, 0, 0 }, // 439 MTSR
  { 1, 106, 107, 0, 0 }, // 440 MTVRSAVE_MTVRSAVEv
  { 1, 110, 111, 0, 0 }, // 441 LSWI
  { 1, 110, 111, 0, 0 }, // 442 PLBZ_PLBZ8_PLBZ8pc_PLBZpc_PLD_PLDpc_PLFD_PLFDpc_PLFS_PLFSpc_PLHA_PLHA8_PLHA8pc_PLHApc_PLHZ_PLHZ8_PLHZ8pc_PLHZpc_PLWA_PLWA8_PLWA8pc_PLWApc_PLWZ_PLWZ8_PLWZ8pc_PLWZpc_PLXSD_PLXSDpc_PLXSSP_PLXSSPpc_PLXV_PLXVpc_PLXVP_PLXVPpc
  { 1, 110, 111, 0, 0 }, // 443 LXVP_LXVPX
  { 1, 120, 121, 0, 0 }, // 444 MFSR
  { 1, 109, 110, 0, 0 }, // 445 MFTB8
  { 1, 114, 115, 0, 0 }, // 446 XXSETACCZ
  { 1, 108, 109, 0, 0 }, // 447 XVBF16GER2_XVF16GER2_XVF32GER_XVF64GER_XVI16GER2_XVI16GER2S_XVI4GER8_XVI8GER4
  { 1, 108, 109, 0, 0 }, // 448 XVBF16GER2NN_XVBF16GER2NP_XVBF16GER2PN_XVBF16GER2PP_XVF16GER2NN_XVF16GER2NP_XVF16GER2PN_XVF16GER2PP_XVF32GERNN_XVF32GERNP_XVF32GERPN_XVF32GERPP_XVF64GERNN_XVF64GERNP_XVF64GERPN_XVF64GERPP_XVI16GER2PP_XVI16GER2SPP_XVI4GER8PP_XVI8GER4PP
  { 1, 114, 115, 0, 0 }, // 449 XVI8GER4SPP
  { 1, 108, 109, 0, 0 }, // 450 PMXVF32GER_PMXVF64GER
  { 1, 108, 109, 0, 0 }, // 451 PMXVBF16GER2_PMXVF16GER2_PMXVF32GERNN_PMXVF32GERNP_PMXVF32GERPN_PMXVF32GERPP_PMXVF64GERNN_PMXVF64GERNP_PMXVF64GERPN_PMXVF64GERPP_PMXVI16GER2_PMXVI16GER2S_PMXVI4GER8_PMXVI8GER4
  { 1, 108, 109, 0, 0 }, // 452 PMXVBF16GER2NN_PMXVBF16GER2NP_PMXVBF16GER2PN_PMXVBF16GER2PP_PMXVF16GER2NN_PMXVF16GER2NP_PMXVF16GER2PN_PMXVF16GER2PP_PMXVI16GER2PP_PMXVI16GER2SPP_PMXVI4GER8PP_PMXVI8GER4PP
  { 1, 114, 115, 0, 0 }, // 453 PMXVI8GER4SPP
  { 1, 114, 115, 0, 0 }, // 454 XXMTACC
  { 1, 114, 115, 0, 0 }, // 455 XXMFACC
  { 0, 0, 0, 0, 0 }, // 456 MULLD_MULLDO
  { 1, 114, 115, 0, 0 }, // 457 VMULHSD_VMULHUD_VMULLD
  { 1, 128, 129, 0, 0 }, // 458 VSPLTISW
  { 1, 108, 109, 0, 0 }, // 459 V_SETALLONES_V_SETALLONESB_V_SETALLONESH
  { 1, 114, 115, 0, 0 }, // 460 MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VPRTYBQ
  { 1, 108, 109, 0, 0 }, // 461 VGBBD_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW
  { 1, 128, 129, 0, 0 }, // 462 VSPLTISB_VSPLTISH_XXSPLTIB
  { 1, 114, 115, 0, 0 }, // 463 VSTRIBL_VSTRIBR_VSTRIHL_VSTRIHR
  { 1, 108, 109, 0, 0 }, // 464 XVCVBF16SPN
  { 1, 108, 109, 0, 0 }, // 465 VBPERMQ_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLO_VSLV_VSR_VSRO_VSRV_XXEXTRACTUW
  { 1, 114, 115, 0, 0 }, // 466 VCLRLB_VCLRRB_XXGENPCVDM_XXGENPCVHM_XXGENPCVWM
  { 1, 114, 115, 0, 0 }, // 467 VEXTRACTD_VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VINSERTD_VINSERTW
  { 1, 114, 115, 0, 0 }, // 468 VEXTDDVLX_VEXTDDVRX_VEXTDUBVLX_VEXTDUBVRX_VEXTDUHVLX_VEXTDUHVRX_VEXTDUWVLX_VEXTDUWVRX_VINSBLX_VINSBRX_VINSBVLX_VINSBVRX_VINSD_VINSDLX_VINSDRX_VINSHLX_VINSHRX_VINSHVLX_VINSHVRX_VINSW_VINSWLX_VINSWRX_VINSWVLX_VINSWVRX_VSLDBI_VSRDBI
  { 1, 108, 109, 0, 0 }, // 469 VSUMSWS
  { 1, 114, 115, 0, 0 }, // 470 XXSPLTIDP_XXSPLTIW
  { 1, 114, 115, 0, 0 }, // 471 XXBLENDVB_XXBLENDVD_XXBLENDVH_XXBLENDVW_XXSPLTI32DX
  { 1, 114, 115, 0, 0 }, // 472 XXEVAL
  { 1, 128, 129, 0, 0 }, // 473 XXPERMX
  { 1, 110, 111, 0, 0 }, // 474 DCBST_DCBZ
  { 1, 110, 111, 0, 0 }, // 475 ICBI
  { 1, 110, 111, 0, 0 }, // 476 DCBF
  { 1, 110, 111, 0, 0 }, // 477 PSTXVP_PSTXVPpc
  { 1, 110, 111, 0, 0 }, // 478 STB_STB8_STDBRX_STH_STH8_STHBRX_STW_STW8_STWBRX
  { 0, 0, 0, 0, 0 }, // 479 SPILLTOVSR_ST
  { 0, 0, 0, 0, 0 }, // 480 STD
  { 0, 0, 0, 0, 0 }, // 481 DFSTOREf32_DFSTOREf64_STIWX
  { 1, 110, 111, 0, 0 }, // 482 STXVRBX_STXVRDX_STXVRHX_STXVRWX
  { 0, 0, 0, 0, 0 }, // 483 SPILLTOVSR_STX
  { 1, 110, 111, 0, 0 }, // 484 EnforceIEIO
  { 1, 110, 111, 0, 0 }, // 485 STBCIX_STDCIX_STHCIX_STWCIX
  { 1, 110, 111, 0, 0 }, // 486 PSTB_PSTB8_PSTB8pc_PSTBpc_PSTD_PSTDpc_PSTFD_PSTFDpc_PSTFS_PSTFSpc_PSTH_PSTH8_PSTH8pc_PSTHpc_PSTW_PSTW8_PSTW8pc_PSTWpc_PSTXSD_PSTXSDpc_PSTXSSP_PSTXSSPpc_PSTXV_PSTXVpc
  { 1, 110, 111, 0, 0 }, // 487 STXVP_STXVPX
  { 1, 107, 108, 0, 0 }, // 488 ATTN_NAP
  { 1, 110, 111, 0, 0 }, // 489 DCBZL
  { 1, 110, 111, 0, 0 }, // 490 DCCCI_ICBLQ_ICCCI_TLBLD_TLBLI_TLBRE2_TLBSX2_TLBSX2D_TLBWE2
  { 1, 110, 111, 0, 0 }, // 491 ICBLC
  { 1, 107, 108, 0, 0 }, // 492 CLRBHRB
  { 1, 107, 108, 0, 0 }, // 493 MFBHRBE
  { 1, 110, 111, 0, 0 }, // 494 PADDI_PADDI8_PADDI8pc_PADDIpc
  { 1, 106, 107, 0, 0 }, // 495 PLI_PLI8
  { 1, 108, 109, 0, 0 }, // 496 VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS
  { 1, 114, 115, 0, 0 }, // 497 VMULESD_VMULEUD_VMULHSW_VMULHUW_VMULOSD_VMULOUD
  { 1, 114, 115, 0, 0 }, // 498 VMSUMCUD
  { 0, uint16_t(~0U), uint16_t(~0U), uint16_t(~0U), uint16_t(~0U) }// end marker
};

static const llvm::InstrItinerary G4PlusItineraries[] = {
  { 0, 0, 0, 0, 0 }, // 0 NoInstrModel
  { 1, 129, 130, 0, 0 }, // 1 IIC_LdStSync
  { 1, 130, 131, 0, 0 }, // 2 IIC_IntSimple
  { 1, 130, 131, 0, 0 }, // 3 IIC_IntGeneral
  { 1, 131, 132, 0, 0 }, // 4 IIC_BrB
  { 1, 132, 133, 0, 0 }, // 5 IIC_VecFP
  { 1, 130, 131, 0, 0 }, // 6 IIC_IntCompare
  { 0, 0, 0, 0, 0 }, // 7 IIC_SprABORT
  { 0, 0, 0, 0, 0 }, // 8 IIC_LdStCOPY
  { 0, 0, 0, 0, 0 }, // 9 IIC_LdStPASTE
  { 1, 133, 134, 0, 0 }, // 10 IIC_BrCR
  { 0, 0, 0, 0, 0 }, // 11 IIC_LdStLD
  { 1, 134, 135, 0, 0 }, // 12 IIC_LdStDCBF
  { 1, 134, 135, 0, 0 }, // 13 IIC_LdStLoad
  { 0, 0, 0, 0, 0 }, // 14 IIC_IntDivD
  { 1, 135, 136, 0, 0 }, // 15 IIC_IntDivW
  { 0, 0, 0, 0, 0 }, // 16 IIC_FPDGeneral
  { 1, 136, 137, 0, 0 }, // 17 IIC_FPAddSub
  { 1, 137, 138, 0, 0 }, // 18 IIC_FPDivD
  { 0, 0, 0, 0, 0 }, // 19 IIC_FPSGeneral
  { 1, 136, 137, 0, 0 }, // 20 IIC_FPCompare
  { 1, 136, 137, 0, 0 }, // 21 IIC_FPGeneral
  { 1, 138, 139, 0, 0 }, // 22 IIC_VecGeneral
  { 1, 139, 140, 0, 0 }, // 23 IIC_VecComplex
  { 1, 134, 135, 0, 0 }, // 24 IIC_LdStStore
  { 0, 0, 0, 0, 0 }, // 25 IIC_IntRotateDI
  { 1, 140, 141, 0, 0 }, // 26 IIC_FPDivS
  { 1, 136, 137, 0, 0 }, // 27 IIC_FPFused
  { 0, 0, 0, 0, 0 }, // 28 IIC_FPSqrtD
  { 0, 0, 0, 0, 0 }, // 29 IIC_FPSqrtS
  { 1, 141, 142, 0, 0 }, // 30 IIC_LdStICBI
  { 0, 0, 0, 0, 0 }, // 31 IIC_IntISEL
  { 1, 142, 143, 0, 0 }, // 32 IIC_SprISYNC
  { 1, 134, 135, 0, 0 }, // 33 IIC_LdStLWARX
  { 1, 134, 135, 0, 0 }, // 34 IIC_LdStLoadUpd
  { 1, 134, 135, 0, 0 }, // 35 IIC_LdStLoadUpdX
  { 0, 0, 0, 0, 0 }, // 36 IIC_LdStLDARX
  { 0, 0, 0, 0, 0 }, // 37 IIC_LdStLDU
  { 0, 0, 0, 0, 0 }, // 38 IIC_LdStLDUX
  { 1, 143, 144, 0, 0 }, // 39 IIC_LdStLFD
  { 1, 143, 144, 0, 0 }, // 40 IIC_LdStLFDU
  { 1, 143, 144, 0, 0 }, // 41 IIC_LdStLFDUX
  { 1, 134, 135, 0, 0 }, // 42 IIC_LdStLHA
  { 1, 134, 135, 0, 0 }, // 43 IIC_LdStLHAU
  { 1, 134, 135, 0, 0 }, // 44 IIC_LdStLHAUX
  { 1, 144, 145, 0, 0 }, // 45 IIC_LdStLMW
  { 0, 0, 0, 0, 0 }, // 46 IIC_LdStLQ
  { 0, 0, 0, 0, 0 }, // 47 IIC_LdStLQARX
  { 1, 134, 135, 0, 0 }, // 48 IIC_LdStLWA
  { 0, 0, 0, 0, 0 }, // 49 IIC_IntMulHD
  { 1, 133, 134, 0, 0 }, // 50 IIC_BrMCR
  { 1, 133, 134, 0, 0 }, // 51 IIC_BrMCRX
  { 1, 133, 134, 0, 0 }, // 52 IIC_SprMFCR
  { 1, 145, 146, 0, 0 }, // 53 IIC_SprMFSPR
  { 1, 136, 137, 0, 0 }, // 54 IIC_IntMFFS
  { 1, 141, 142, 0, 0 }, // 55 IIC_SprMFMSR
  { 0, 0, 0, 0, 0 }, // 56 IIC_SprMFCRF
  { 0, 0, 0, 0, 0 }, // 57 IIC_SprMFPMR
  { 1, 145, 146, 0, 0 }, // 58 IIC_SprMFSR
  { 1, 146, 147, 0, 0 }, // 59 IIC_SprMFTB
  { 0, 0, 0, 0, 0 }, // 60 IIC_SprMSGSYNC
  { 1, 133, 134, 0, 0 }, // 61 IIC_SprMTSPR
  { 1, 136, 137, 0, 0 }, // 62 IIC_IntMTFSB0
  { 1, 133, 134, 0, 0 }, // 63 IIC_SprMTMSR
  { 0, 0, 0, 0, 0 }, // 64 IIC_SprMTMSRD
  { 0, 0, 0, 0, 0 }, // 65 IIC_SprMTPMR
  { 1, 133, 134, 0, 0 }, // 66 IIC_SprMTSR
  { 1, 145, 146, 0, 0 }, // 67 IIC_IntMulHW
  { 1, 145, 146, 0, 0 }, // 68 IIC_IntMulHWU
  { 1, 141, 142, 0, 0 }, // 69 IIC_IntMulLI
  { 1, 130, 131, 0, 0 }, // 70 IIC_SprRFI
  { 0, 0, 0, 0, 0 }, // 71 IIC_IntRFID
  { 0, 0, 0, 0, 0 }, // 72 IIC_IntRotateD
  { 1, 130, 131, 0, 0 }, // 73 IIC_IntRotate
  { 0, 0, 0, 0, 0 }, // 74 IIC_SprSLBFEE
  { 0, 0, 0, 0, 0 }, // 75 IIC_SprSLBIA
  { 0, 0, 0, 0, 0 }, // 76 IIC_SprSLBIE
  { 0, 0, 0, 0, 0 }, // 77 IIC_SprSLBIEG
  { 0, 0, 0, 0, 0 }, // 78 IIC_SprSLBMFEE
  { 0, 0, 0, 0, 0 }, // 79 IIC_SprSLBMFEV
  { 0, 0, 0, 0, 0 }, // 80 IIC_SprSLBMTE
  { 0, 0, 0, 0, 0 }, // 81 IIC_SprSLBSYNC
  { 1, 147, 148, 0, 0 }, // 82 IIC_IntShift
  { 1, 134, 135, 0, 0 }, // 83 IIC_LdStSTWCX
  { 1, 134, 135, 0, 0 }, // 84 IIC_LdStSTU
  { 1, 134, 135, 0, 0 }, // 85 IIC_LdStSTUX
  { 1, 134, 135, 0, 0 }, // 86 IIC_LdStSTD
  { 1, 134, 135, 0, 0 }, // 87 IIC_LdStSTDCX
  { 1, 134, 135, 0, 0 }, // 88 IIC_LdStSTFD
  { 1, 134, 135, 0, 0 }, // 89 IIC_LdStSTFDU
  { 0, 0, 0, 0, 0 }, // 90 IIC_SprSTOP
  { 0, 0, 0, 0, 0 }, // 91 IIC_LdStSTQ
  { 0, 0, 0, 0, 0 }, // 92 IIC_LdStSTQCX
  { 0, 0, 0, 0, 0 }, // 93 IIC_IntTrapD
  { 0, 0, 0, 0, 0 }, // 94 IIC_SprTLBIA
  { 0, 0, 0, 0, 0 }, // 95 IIC_SprTLBIE
  { 0, 0, 0, 0, 0 }, // 96 IIC_SprTLBIEL
  { 1, 134, 135, 0, 0 }, // 97 IIC_SprTLBSYNC
  { 1, 147, 148, 0, 0 }, // 98 IIC_IntTrapW
  { 1, 148, 149, 0, 0 }, // 99 IIC_VecFPCompare
  { 1, 149, 150, 0, 0 }, // 100 IIC_VecPerm
  { 1, 138, 139, 0, 0 }, // 101 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VSLD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_VPOPCNTB_VPOPCNTH_VSRAD_MTVSRDD_VEQV_VNAND_VNEGD_VNEGW_VORC_XXLAND_XXLANDC_XXLEQV_XXLEQVOnes_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 1, 132, 133, 0, 0 }, // 102 VAND_VANDC_V_SET0_V_SET0B_V_SET0H_VSLB_VSLH_VSLW_VSRB_VSRH_VSRW_VRLB_VRLD_VRLH_VRLW_VSRAB_VSRAH_VSRAW_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP_XVXEXPDP_XVXEXPSP_VRLDMI_VRLDNM_VRLWMI_VRLWNM_VMRGEW_VMRGOW_VNOR_VOR_VSEL_VXOR_XVNEGDP_XVNEGSP_XSABSQP_XSCPSGNQP_XSIEXPQP_XSNABSQP_XSNEGQP_XSXEXPQP
  { 1, 149, 150, 0, 0 }, // 103 XXSEL
  { 1, 133, 134, 0, 0 }, // 104 TABORTDC_TABORTDCI_TABORTWC_TABORTWCI
  { 1, 136, 137, 0, 0 }, // 105 MTFSB0_MTFSB1
  { 1, 136, 137, 0, 0 }, // 106 MFFSCDRN_MFFSCDRNI_MFFSCRN_MFFSCRNI
  { 1, 130, 131, 0, 0 }, // 107 CMPRB_CMPRB8_CMPEQB
  { 0, 0, 0, 0, 0 }, // 108 TD_TDI
  { 1, 147, 148, 0, 0 }, // 109 TW_TWI
  { 1, 136, 137, 0, 0 }, // 110 FCMPOD_FCMPOS_FCMPUD_FCMPUS_FTDIV_FTSQRT
  { 1, 132, 133, 0, 0 }, // 111 XSTSTDCDP_XSTSTDCSP
  { 1, 132, 133, 0, 0 }, // 112 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP_XSXSIGDP_XSCVSPDPN
  { 1, 136, 137, 0, 0 }, // 113 XSCMPEQDP_XSCMPEXPDP_XSCMPGEDP_XSCMPGTDP_XSCMPODP_XSCMPUDP_XSTDIVDP_XSTSQRTDP
  { 1, 130, 131, 0, 0 }, // 114 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW_CMPB_CMPB8_SETB_SETB8_BPERMD
  { 0, 0, 0, 0, 0 }, // 115 SLD_SRD_SRAD
  { 0, 0, 0, 0, 0 }, // 116 SRADI_EXTSWSLI_32_64_EXTSWSLI_SRADI_32_RLDIC
  { 1, 138, 139, 0, 0 }, // 117 MFVRD_MFVSRD_MTVRD_MTVSRD_MTVRWA_MTVRWZ_MTVSRWA_MTVSRWZ_MFVSRWZ_MFVRWZ
  { 1, 130, 131, 0, 0 }, // 118 CMPLW_CMPLWI_CMPW_CMPWI_CMPD_CMPDI_CMPLD_CMPLDI
  { 1, 130, 131, 0, 0 }, // 119 SUBFC_SUBFC8_SUBFC8O_SUBFCO_SUBFIC_SUBFIC8_ANDI8_rec_ANDIS8_rec_ANDIS_rec_ANDI_rec_ADDC_ADDC8_ADDC8O_ADDCO_ADDIC_ADDIC8_ADDIC_rec_ADDE_ADDE8_ADDE8O_ADDE8O_rec_ADDE8_rec_ADDEO_ADDEO_rec_ADDE_rec_ADDME_ADDME8_ADDME8O_ADDME8O_rec_ADDME8_rec_ADDMEO_ADDMEO_rec_ADDME_rec_ADDZE_ADDZE8_ADDZE8O_ADDZE8O_rec_ADDZE8_rec_ADDZEO_ADDZEO_rec_ADDZE_rec_SUBF_SUBF8_SUBF8O_SUBF8O_rec_SUBF8_rec_SUBFE_SUBFE8_SUBFE8O_SUBFE8O_rec_SUBFE8_rec_SUBFEO_SUBFEO_rec_SUBFE_rec_SUBFME_SUBFME8_SUBFME8O_SUBFME8O_rec_SUBFME8_rec_SUBFMEO_SUBFMEO_rec_SUBFME_rec_SUBFO_SUBFO_rec_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZE8O_rec_SUBFZE8_rec_SUBFZEO_SUBFZEO_rec_SUBFZE_rec_SUBF_rec_POPCNTB_POPCNTB8_LA_LA8
  { 1, 130, 131, 0, 0 }, // 120 ADD4_ADD4O_ADD4O_rec_ADD4_rec_ADD8_ADD8O_ADD8O_rec_ADD8_rec_NEG_NEG8_NEG8O_NEG8O_rec_NEG8_rec_NEGO_NEGO_rec_NEG_rec_ADDI_ADDI8_ADDIS_ADDIS8_LI_LI8_LIS_LIS8_OR_OR8_OR8_rec_ORI_ORI8_ORIS_ORIS8_OR_rec_XOR_XOR8_XOR8_rec_XORI_XORI8_XORIS_XORIS8_XOR_rec_NAND_NAND8_NAND8_rec_NAND_rec_AND_AND8_AND8_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_AND_rec_NOR_NOR8_NOR8_rec_NOR_rec_ORC_ORC8_ORC8_rec_ORC_rec_EQV_EQV8_EQV8_rec_EQV_rec_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_ADD4TLS_ADD8TLS_ADD8TLS__NOP
  { 0, 0, 0, 0, 0 }, // 121 ADDIStocHA_ADDIStocHA8_ADDItocL_COPY
  { 1, 133, 134, 0, 0 }, // 122 MCRF
  { 1, 133, 134, 0, 0 }, // 123 MCRXRX
  { 1, 132, 133, 0, 0 }, // 124 XSNABSDP_XSXEXPDP_XSABSDP_XSNEGDP_XSCPSGNDP
  { 1, 131, 132, 0, 0 }, // 125 RFEBB
  { 1, 133, 134, 0, 0 }, // 126 TBEGIN_TRECHKPT
  { 1, 134, 135, 0, 0 }, // 127 WAIT
  { 0, 0, 0, 0, 0 }, // 128 RLDCL_RLDCR
  { 1, 130, 131, 0, 0 }, // 129 RLWIMI_RLWIMI8
  { 0, 0, 0, 0, 0 }, // 130 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32_RLDIMI
  { 0, 0, 0, 0, 0 }, // 131 MFOCRF_MFOCRF8
  { 1, 133, 134, 0, 0 }, // 132 MTOCRF_MTOCRF8
  { 1, 133, 134, 0, 0 }, // 133 CR6SET_CR6UNSET_CRSET_CRUNSET_CRAND_CRANDC_CRNAND_CRNOR_CROR_CRORC_CREQV_CRXOR
  { 1, 130, 131, 0, 0 }, // 134 SLW_SLW8_SRW_SRW8_RLWINM_RLWINM8_RLWNM_RLWNM8
  { 1, 136, 137, 0, 0 }, // 135 FABSD_FABSS_FNABSD_FNABSS_FNEGD_FNEGS_FCPSGND_FCPSGNS_FMR
  { 1, 147, 148, 0, 0 }, // 136 SRAW_SRAWI
  { 0, 0, 0, 0, 0 }, // 137 ISEL_ISEL8
  { 1, 132, 133, 0, 0 }, // 138 XSIEXPDP
  { 1, 133, 134, 0, 0 }, // 139 TRECLAIM_TSR_TABORT
  { 1, 134, 135, 0, 0 }, // 140 MFVSCR
  { 1, 134, 135, 0, 0 }, // 141 MTVSCR
  { 1, 148, 149, 0, 0 }, // 142 VCMPNEZB_VCMPNEZH_VCMPNEZW_VCMPEQUB_VCMPEQUD_VCMPEQUH_VCMPEQUW_VCMPNEB_VCMPNEH_VCMPNEW_VCMPEQFP_VCMPEQFP_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPBFP_VCMPBFP_rec_VCMPGTSB_VCMPGTSB_rec_VCMPGTSD_VCMPGTSD_rec_VCMPGTSH_VCMPGTSH_rec_VCMPGTSW_VCMPGTSW_rec_VCMPGTUB_VCMPGTUB_rec_VCMPGTUD_VCMPGTUD_rec_VCMPGTUH_VCMPGTUH_rec_VCMPGTUW_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 1, 138, 139, 0, 0 }, // 143 VABSDUB_VABSDUH_VABSDUW_VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTW_VPOPCNTD_VPRTYBD_VPRTYBW
  { 1, 132, 133, 0, 0 }, // 144 VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VADDSBS_VADDSHS_VADDSWS_VMAXFP_VMINFP_VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW_VBPERMD_VADDCUW_VSHASIGMAD_VSHASIGMAW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_VSUBCUW_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP_XVXSIGDP_XVXSIGSP
  { 1, 136, 137, 0, 0 }, // 145 XVTDIVDP_XVTDIVSP_XVTSQRTDP_XVTSQRTSP
  { 1, 132, 133, 0, 0 }, // 146 VADDFP_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VEXPTEFP_VLOGEFP_VMADDFP_VMHADDSHS_VNMSUBFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVADDDP_XVADDSP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVHPSP_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVMULDP_XVMULSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP_XVSUBDP_XVSUBSP_VCFSX_VCFSX_0_VCFUX_VCFUX_0_VMHRADDSHS_VMLADDUHM_VMSUMMBM_VMSUMSHM_VMSUMSHS_VMSUMUBM_VMSUMUHM_VMSUMUDM_VMSUMUHS_VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS_VSUMSWS
  { 1, 138, 139, 0, 0 }, // 147 VSUBFP_VMULUWM
  { 0, 0, 0, 0, 0 }, // 148 MADDHD_MADDHDU_MADDLD_MADDLD8_MULLD_MULLDO
  { 1, 145, 146, 0, 0 }, // 149 MULHD_MULHW_MULLW_MULLWO
  { 1, 145, 146, 0, 0 }, // 150 MULHDU_MULHWU
  { 1, 141, 142, 0, 0 }, // 151 MULLI_MULLI8
  { 1, 136, 137, 0, 0 }, // 152 FRSP_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRE_FRES_FADDS_FMSUBS_FMADDS_FSUBS_FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRSQRTE_FRSQRTES_FNMADDS_FNMSUBS_FSELD_FSELS_FMULS
  { 1, 136, 137, 0, 0 }, // 153 FADD_FSUB
  { 1, 136, 137, 0, 0 }, // 154 FMSUB_FMADD_FNMADD_FNMSUB_FMUL
  { 1, 132, 133, 0, 0 }, // 155 XSMADDADP_XSMADDASP_XSMADDMDP_XSMADDMSP_XSMSUBADP_XSMSUBASP_XSMSUBMDP_XSMSUBMSP_XSMULDP_XSMULSP_XSNMADDADP_XSNMADDASP_XSNMADDMDP_XSNMADDMSP_XSNMSUBADP_XSNMSUBASP_XSNMSUBMDP_XSNMSUBMSP
  { 1, 136, 137, 0, 0 }, // 156 FSELD_rec_FSELS_rec
  { 1, 145, 146, 0, 0 }, // 157 MULHDU_rec_MULHWU_rec
  { 1, 145, 146, 0, 0 }, // 158 MULHD_rec_MULHW_rec_MULLWO_rec_MULLW_rec
  { 0, 0, 0, 0, 0 }, // 159 MULLDO_rec_MULLD_rec
  { 1, 136, 137, 0, 0 }, // 160 FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRES_rec_FRE_rec_FADDS_rec_FSUBS_rec_FMSUBS_rec_FNMSUBS_rec_FMADDS_rec_FNMADDS_rec_FCFIDS_rec_FCFIDUS_rec_FCFIDU_rec_FCFID_rec_FCTIDUZ_rec_FCTIDU_rec_FCTIDZ_rec_FCTID_rec_FCTIWUZ_rec_FCTIWU_rec_FCTIWZ_rec_FCTIW_rec_FMULS_rec_FRSQRTES_rec_FRSQRTE_rec_FRSP_rec
  { 1, 136, 137, 0, 0 }, // 161 FADD_rec_FSUB_rec
  { 1, 136, 137, 0, 0 }, // 162 FMSUB_rec_FNMSUB_rec_FMADD_rec_FNMADD_rec_FMUL_rec
  { 1, 132, 133, 0, 0 }, // 163 XSADDDP_XSADDSP_XSCVDPHP_XSCVDPSP_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPSXWSs_XSCVDPUXWSs_XSCVHPDP_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSQRTEDP_XSRSQRTESP_XSSUBDP_XSSUBSP_XSCVDPSPN_XSRSP
  { 1, 134, 135, 0, 0 }, // 164 LVSL_LVSR
  { 1, 149, 150, 0, 0 }, // 165 VSPLTISB_VSPLTISH_VSPLTISW_VSPLTB_VSPLTBs_VSPLTH_VSPLTHs_VSPLTW_XXMRGHW_XXMRGLW_XXPERM_XXPERMR_XXSLDWI_XXSLDWIs_XXSPLTIB_XXSPLTW_XXSPLTWs_XXPERMDI_XXPERMDIs
  { 1, 132, 133, 0, 0 }, // 166 V_SETALLONES_V_SETALLONESB_V_SETALLONESH_VBPERMQ_VGBBD_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPERM_VPERMR_VPERMXOR_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLDOI_VSLO_VSLV_VSR_VSRO_VSRV_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW_XXEXTRACTUW_XXINSERTW_VADDCUQ_VADDECUQ_VADDEUQM_VMUL10CUQ_VMUL10ECUQ_VMUL10EUQ_VMUL10UQ_VSUBCUQ_VSUBECUQ_VSUBEUQM_XSTSTDCQP_XSXSIGQP_BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDS_rec_BCDTRUNC_rec_BCDUS_rec_BCDUTRUNC_rec_BCDADD_rec_BCDSUB_rec
  { 1, 138, 139, 0, 0 }, // 167 VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VINSERTB_VINSERTD_VINSERTH_VINSERTW_MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VEXTRACTD_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VPRTYBQ_VADDUQM_VSUBUQM
  { 1, 136, 137, 0, 0 }, // 168 XSCMPEXPQP_XSCMPOQP_XSCMPUQP
  { 1, 132, 133, 0, 0 }, // 169 BCDSR_rec_XSADDQP_XSADDQPO_XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP_XSRQPI_XSRQPIX_XSRQPXP_XSSUBQP_XSSUBQPO
  { 1, 132, 133, 0, 0 }, // 170 BCDCTSQ_rec
  { 1, 132, 133, 0, 0 }, // 171 XSMADDQP_XSMADDQPO_XSMSUBQP_XSMSUBQPO_XSMULQP_XSMULQPO_XSNMADDQP_XSNMADDQPO_XSNMSUBQP_XSNMSUBQPO
  { 1, 132, 133, 0, 0 }, // 172 BCDCFSQ_rec
  { 1, 132, 133, 0, 0 }, // 173 XSDIVQP_XSDIVQPO
  { 1, 132, 133, 0, 0 }, // 174 XSSQRTQP_XSSQRTQPO
  { 1, 134, 135, 0, 0 }, // 175 LXVL_LXVLL
  { 1, 134, 135, 0, 0 }, // 176 LVEBX_LVEHX_LVEWX_LVX_LVXL
  { 1, 143, 144, 0, 0 }, // 177 LXSIBZX_LXSIHZX_LXSDX_LXVB16X_LXVD2X_LXVWSX_LXSIWZX_LXV_LXVX_LXSD
  { 0, 0, 0, 0, 0 }, // 178 DFLOADf64_XFLOADf64_LIWZX
  { 1, 134, 135, 0, 0 }, // 179 DCBF_DCBFEP_DCBST_DCBSTEP_DCBT_DCBTEP_DCBZ_DCBZEP_DCBZL_DCBZLEP_DCBTST_DCBTSTEP
  { 0, 0, 0, 0, 0 }, // 180 CP_COPY_CP_COPY8
  { 1, 141, 142, 0, 0 }, // 181 ICBI_ICBIEP
  { 1, 134, 135, 0, 0 }, // 182 ICBT_ICBTLS_LBZ_LBZ8_LBZCIX_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LDBRX_LDCIX_LHBRX_LHBRX8_LHZ_LHZ8_LHZCIX_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWBRX_LWBRX8_LWZ_LWZ8_LWZCIX_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32_EnforceIEIO_LSWI
  { 1, 134, 135, 0, 0 }, // 183 LBARX_LBARXL_LHARX_LHARXL_LWARX_LWARXL
  { 0, 0, 0, 0, 0 }, // 184 LD_LDX_LDXTLS_LDXTLS__DARN
  { 0, 0, 0, 0, 0 }, // 185 LDARX_LDARXL
  { 0, 0, 0, 0, 0 }, // 186 CP_ABORT
  { 1, 142, 143, 0, 0 }, // 187 ISYNC
  { 0, 0, 0, 0, 0 }, // 188 MSGSYNC
  { 1, 134, 135, 0, 0 }, // 189 TLBSYNC
  { 1, 129, 130, 0, 0 }, // 190 SYNC
  { 1, 144, 145, 0, 0 }, // 191 LMW
  { 1, 143, 144, 0, 0 }, // 192 LFIWZX_LFDX_LFD
  { 0, 0, 0, 0, 0 }, // 193 SLBIA
  { 0, 0, 0, 0, 0 }, // 194 SLBIE
  { 0, 0, 0, 0, 0 }, // 195 SLBMFEE
  { 0, 0, 0, 0, 0 }, // 196 SLBMFEV
  { 0, 0, 0, 0, 0 }, // 197 SLBMTE
  { 0, 0, 0, 0, 0 }, // 198 TLBIEL
  { 1, 134, 135, 0, 0 }, // 199 LHZU_LHZU8_LWZU_LWZU8
  { 1, 134, 135, 0, 0 }, // 200 LHZUX_LHZUX8_LWZUX_LWZUX8
  { 1, 133, 134, 0, 0 }, // 201 TEND
  { 1, 134, 135, 0, 0 }, // 202 STBCX_STHCX_STWCX
  { 1, 134, 135, 0, 0 }, // 203 STDCX
  { 0, 0, 0, 0, 0 }, // 204 LDMX
  { 1, 134, 135, 0, 0 }, // 205 LHA_LHA8_LHAX_LHAX8_LWAX_LWAX_32
  { 0, 0, 0, 0, 0 }, // 206 CP_PASTE8_rec_CP_PASTE_rec
  { 1, 134, 135, 0, 0 }, // 207 LWA_LWA_32
  { 1, 133, 134, 0, 0 }, // 208 TCHECK
  { 1, 143, 144, 0, 0 }, // 209 LFIWAX
  { 1, 143, 144, 0, 0 }, // 210 LXSIWAX
  { 0, 0, 0, 0, 0 }, // 211 LIWAX
  { 1, 143, 144, 0, 0 }, // 212 LFSX_LFS
  { 1, 143, 144, 0, 0 }, // 213 LXSSP_LXSSPX
  { 0, 0, 0, 0, 0 }, // 214 XFLOADf32_DFLOADf32
  { 1, 134, 135, 0, 0 }, // 215 LHAU_LHAU8
  { 1, 134, 135, 0, 0 }, // 216 LHAUX_LHAUX8_LWAUX
  { 1, 143, 144, 0, 0 }, // 217 LXVH8X_LXVDSX_LXVW4X
  { 1, 134, 135, 0, 0 }, // 218 STFD_STFDX_STFIWX_STFS_STFSX_STXSD_STXSDX_STXSIBX_STXSIBXv_STXSIHX_STXSIHXv_STXSIWX_STXSSP_STXSSPX
  { 1, 134, 135, 0, 0 }, // 219 STW_STW8_STDBRX_STHBRX_STWBRX_STB_STB8_STH_STH8_STBX_STBX8_STBXTLS_STBXTLS__STBXTLS_32_STHX_STHX8_STHXTLS_STHXTLS__STHXTLS_32_STWX_STWX8_STWXTLS_STWXTLS__STWXTLS_32
  { 0, 0, 0, 0, 0 }, // 220 DFSTOREf32_DFSTOREf64_XFSTOREf32_XFSTOREf64_STIWX
  { 1, 134, 135, 0, 0 }, // 221 STD_STDX_STDXTLS_STDXTLS_
  { 1, 134, 135, 0, 0 }, // 222 STBCIX_STDCIX_STHCIX_STWCIX_STSWI
  { 0, 0, 0, 0, 0 }, // 223 SLBIEG
  { 1, 144, 145, 0, 0 }, // 224 STMW
  { 0, 0, 0, 0, 0 }, // 225 TLBIE
  { 1, 134, 135, 0, 0 }, // 226 STVEBX_STVEHX_STVEWX_STVX_STVXL
  { 1, 134, 135, 0, 0 }, // 227 STXV_STXVB16X_STXVD2X_STXVH8X_STXVW4X_STXVX
  { 1, 134, 135, 0, 0 }, // 228 STXVL_STXVLL
  { 1, 133, 134, 0, 0 }, // 229 MTCTR_MTCTR8_MTCTR8loop_MTCTRloop_MTLR_MTLR8
  { 1, 130, 131, 0, 0 }, // 230 MFVRSAVE_MFVRSAVEv_MTVRSAVE_MTVRSAVEv
  { 0, 0, 0, 0, 0 }, // 231 MFPMR
  { 0, 0, 0, 0, 0 }, // 232 MTPMR
  { 1, 146, 147, 0, 0 }, // 233 MFTB_MFTB8
  { 1, 145, 146, 0, 0 }, // 234 MFCTR_MFCTR8_MFLR_MFLR8_MFSPR_MFSPR8
  { 1, 141, 142, 0, 0 }, // 235 MFMSR
  { 1, 133, 134, 0, 0 }, // 236 MTMSR
  { 0, 0, 0, 0, 0 }, // 237 MTMSRD
  { 1, 133, 134, 0, 0 }, // 238 MTSPR_MTSPR8
  { 1, 135, 136, 0, 0 }, // 239 DIVW_DIVWO_DIVWU_DIVWUO_MODSW
  { 1, 135, 136, 0, 0 }, // 240 DIVWE_DIVWEO_DIVWEU_DIVWEUO_MODSD_MODUD_MODUW
  { 0, 0, 0, 0, 0 }, // 241 DIVD_DIVDO_DIVDU_DIVDUO
  { 0, 0, 0, 0, 0 }, // 242 DIVDE_DIVDEO_DIVDEU_DIVDEUO
  { 1, 135, 136, 0, 0 }, // 243 DIVWO_rec_DIVWUO_rec_DIVWU_rec_DIVW_rec
  { 0, 0, 0, 0, 0 }, // 244 DIVD_rec_DIVDO_rec_DIVDU_rec_DIVDUO_rec
  { 1, 135, 136, 0, 0 }, // 245 DIVWE_rec_DIVWEO_rec_DIVWEU_rec_DIVWEUO_rec
  { 0, 0, 0, 0, 0 }, // 246 DIVDE_rec_DIVDEO_rec_DIVDEU_rec_DIVDEUO_rec
  { 1, 133, 134, 0, 0 }, // 247 MTCRF_MTCRF8
  { 1, 130, 131, 0, 0 }, // 248 ADDC8O_rec_ADDC8_rec_ADDCO_rec_ADDC_rec_SUBFC8O_rec_SUBFC8_rec_SUBFCO_rec_SUBFC_rec
  { 1, 136, 137, 0, 0 }, // 249 FABSD_rec_FABSS_rec_FNABSD_rec_FNABSS_rec_FCPSGND_rec_FCPSGNS_rec_FNEGD_rec_FNEGS_rec_FMR_rec
  { 1, 133, 134, 0, 0 }, // 250 MCRFS
  { 1, 136, 137, 0, 0 }, // 251 MTFSF_MTFSF_rec_MTFSFI_MTFSFI_rec_MTFSFIb
  { 1, 136, 137, 0, 0 }, // 252 MTFSFb
  { 0, 0, 0, 0, 0 }, // 253 RLDCL_rec_RLDCR_rec
  { 0, 0, 0, 0, 0 }, // 254 RLDICL_rec_RLDICR_rec_RLDICL_32_rec_RLDIMI_rec
  { 1, 130, 131, 0, 0 }, // 255 RLWIMI8_rec_RLWIMI_rec
  { 1, 130, 131, 0, 0 }, // 256 RLWINM8_rec_RLWINM_rec_RLWNM8_rec_RLWNM_rec_SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 1, 147, 148, 0, 0 }, // 257 SRAWI_rec_SRAW_rec
  { 1, 136, 137, 0, 0 }, // 258 MFFS_MFFSCE_MFFSL_MFFS_rec
  { 1, 133, 134, 0, 0 }, // 259 MFCR_MFCR8
  { 0, 0, 0, 0, 0 }, // 260 EXTSWSLI_32_64_rec_SRADI_rec_EXTSWSLI_rec_RLDIC_rec
  { 0, 0, 0, 0, 0 }, // 261 SRAD_rec_SLD_rec_SRD_rec
  { 1, 137, 138, 0, 0 }, // 262 FDIV
  { 1, 137, 138, 0, 0 }, // 263 FDIV_rec
  { 0, 0, 0, 0, 0 }, // 264 XSSQRTDP
  { 0, 0, 0, 0, 0 }, // 265 FSQRT
  { 0, 0, 0, 0, 0 }, // 266 XVSQRTDP
  { 0, 0, 0, 0, 0 }, // 267 XVSQRTSP
  { 0, 0, 0, 0, 0 }, // 268 FSQRT_rec
  { 0, 0, 0, 0, 0 }, // 269 XSSQRTSP
  { 0, 0, 0, 0, 0 }, // 270 FSQRTS
  { 0, 0, 0, 0, 0 }, // 271 FSQRTS_rec
  { 1, 137, 138, 0, 0 }, // 272 XSDIVDP
  { 1, 140, 141, 0, 0 }, // 273 FDIVS
  { 1, 140, 141, 0, 0 }, // 274 FDIVS_rec
  { 1, 140, 141, 0, 0 }, // 275 XSDIVSP
  { 1, 140, 141, 0, 0 }, // 276 XVDIVSP
  { 1, 137, 138, 0, 0 }, // 277 XVDIVDP
  { 1, 143, 144, 0, 0 }, // 278 LFSU
  { 1, 143, 144, 0, 0 }, // 279 LFSUX
  { 1, 134, 135, 0, 0 }, // 280 STFDU_STFDUX_STFSU_STFSUX
  { 1, 134, 135, 0, 0 }, // 281 STBU_STBU8_STDU_STHU_STHU8_STWU_STWU8
  { 1, 134, 135, 0, 0 }, // 282 STBUX_STBUX8_STDUX_STHUX_STHUX8_STWUX_STWUX8
  { 1, 134, 135, 0, 0 }, // 283 LBZU_LBZU8
  { 1, 134, 135, 0, 0 }, // 284 LBZUX_LBZUX8
  { 0, 0, 0, 0, 0 }, // 285 LDU
  { 0, 0, 0, 0, 0 }, // 286 LDUX
  { 1, 143, 144, 0, 0 }, // 287 LFDU
  { 1, 143, 144, 0, 0 }, // 288 LFDUX
  { 1, 132, 133, 0, 0 }, // 289 VPMSUMB_VPMSUMD_VPMSUMH_VPMSUMW_VCIPHER_VCIPHERLAST_VNCIPHER_VNCIPHERLAST_VSBOX
  { 1, 131, 132, 0, 0 }, // 290 BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_BCCTR_BCCTR8_BCCTR8n_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_BCCTRn_BDNZ_BDNZ8_BDNZA_BDNZAm_BDNZAp_BDNZm_BDNZp_BDZ_BDZ8_BDZA_BDZAm_BDZAp_BDZm_BDZp_BDNZL_BDNZLA_BDNZLAm_BDNZLAp_BDNZLR_BDNZLR8_BDNZLRL_BDNZLRLm_BDNZLRLp_BDNZLRm_BDNZLRp_BDNZLm_BDNZLp_BDZL_BDZLA_BDZLAm_BDZLAp_BDZLR_BDZLR8_BDZLRL_BDZLRLm_BDZLRLp_BDZLRm_BDZLRp_BDZLm_BDZLp_BL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM_BLR_BLR8_BLRL_TAILB_TAILB8_TAILBA_TAILBA8_TAILBCTR_TAILBCTR8_gBC_gBCA_gBCAat_gBCCTR_gBCCTRL_gBCL_gBCLA_gBCLAat_gBCLR_gBCLRL_gBCLat_gBCat_BCLR_BCLRL_BCLRLn_BCLRn_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_RM_BCTRL_RM_B_BA_BC_BCC_BCCA_BCL_BCLalways_BCLn_BCTRL8_LDinto_toc_BCTRL_LWZinto_toc_BCTRL8_LDinto_toc_RM_BCTRL_LWZinto_toc_RM_BCn_CTRL_DEP
  { 1, 131, 132, 0, 0 }, // 291 ADDPCIS
  { 1, 134, 135, 0, 0 }, // 292 LDAT_LWAT
  { 1, 134, 135, 0, 0 }, // 293 STDAT_STWAT
  { 1, 130, 131, 0, 0 }, // 294 BRINC
  { 1, 138, 139, 0, 0 }, // 295 EVABS_EVEQV_EVNAND_EVNEG_EVADDIW_EVADDW_EVAND_EVANDC_EVCMPEQ_EVCMPGTS_EVCMPGTU_EVCMPLTS_EVCMPLTU_EVCNTLSW_EVCNTLZW_EVEXTSB_EVEXTSH_EVMERGEHI_EVMERGEHILO_EVMERGELO_EVMERGELOHI_EVNOR_EVOR_EVORC_EVXOR_EVRLW_EVRLWI_EVRNDW_EVSLW_EVSLWI_EVSPLATFI_EVSPLATI_EVSRWIS_EVSRWIU_EVSRWS_EVSRWU_EVSUBFW_EVSUBIFW
  { 1, 139, 140, 0, 0 }, // 296 EVMRA_EVADDSMIAAW_EVADDSSIAAW_EVADDUMIAAW_EVADDUSIAAW_EVDIVWS_EVDIVWU_EVMHEGSMFAA_EVMHEGSMFAN_EVMHEGSMIAA_EVMHEGSMIAN_EVMHEGUMIAA_EVMHEGUMIAN_EVMHESMF_EVMHESMFA_EVMHESMFAAW_EVMHESMFANW_EVMHESMI_EVMHESMIA_EVMHESMIAAW_EVMHESMIANW_EVMHESSF_EVMHESSFA_EVMHESSFAAW_EVMHESSFANW_EVMHESSIAAW_EVMHESSIANW_EVMHEUMI_EVMHEUMIA_EVMHEUMIAAW_EVMHEUMIANW_EVMHEUSIAAW_EVMHEUSIANW_EVMHOGSMFAA_EVMHOGSMFAN_EVMHOGSMIAA_EVMHOGSMIAN_EVMHOGUMIAA_EVMHOGUMIAN_EVMHOSMF_EVMHOSMFA_EVMHOSMFAAW_EVMHOSMFANW_EVMHOSMI_EVMHOSMIA_EVMHOSMIAAW_EVMHOSMIANW_EVMHOSSF_EVMHOSSFA_EVMHOSSFAAW_EVMHOSSFANW_EVMHOSSIAAW_EVMHOSSIANW_EVMHOUMI_EVMHOUMIA_EVMHOUMIAAW_EVMHOUMIANW_EVMHOUSIAAW_EVMHOUSIANW_EVMWHSMF_EVMWHSMFA_EVMWHSMI_EVMWHSMIA_EVMWHSSF_EVMWHSSFA_EVMWHUMI_EVMWHUMIA_EVMWLSMIAAW_EVMWLSMIANW_EVMWLSSIAAW_EVMWLSSIANW_EVMWLUMI_EVMWLUMIA_EVMWLUMIAAW_EVMWLUMIANW_EVMWLUSIAAW_EVMWLUSIANW_EVMWSMF_EVMWSMFA_EVMWSMFAA_EVMWSMFAN_EVMWSMI_EVMWSMIA_EVMWSMIAA_EVMWSMIAN_EVMWSSF_EVMWSSFA_EVMWSSFAA_EVMWSSFAN_EVMWUMI_EVMWUMIA_EVMWUMIAA_EVMWUMIAN_EVSUBFSMIAAW_EVSUBFSSIAAW_EVSUBFUMIAAW_EVSUBFUSIAAW
  { 1, 134, 135, 0, 0 }, // 297 EVLDD_EVLDDX_EVLDH_EVLDHX_EVLDW_EVLDWX_EVLHHESPLAT_EVLHHESPLATX_EVLHHOSSPLAT_EVLHHOSSPLATX_EVLHHOUSPLAT_EVLHHOUSPLATX_EVLWHE_EVLWHEX_EVLWHOS_EVLWHOSX_EVLWHOU_EVLWHOUX_EVLWHSPLAT_EVLWHSPLATX_EVLWWSPLAT_EVLWWSPLATX
  { 1, 134, 135, 0, 0 }, // 298 EVSTDD_EVSTDDX_EVSTDH_EVSTDHX_EVSTDW_EVSTDWX_EVSTWHE_EVSTWHEX_EVSTWHO_EVSTWHOX_EVSTWWE_EVSTWWEX_EVSTWWO_EVSTWWOX
  { 1, 131, 132, 0, 0 }, // 299 HRFID_ATTN_CLRBHRB_MFBHRBE_NAP_RFCI_RFDI_RFMCI_SC
  { 1, 130, 131, 0, 0 }, // 300 RFI
  { 0, 0, 0, 0, 0 }, // 301 RFID
  { 1, 134, 135, 0, 0 }, // 302 DSS_DSSALL_DST_DST64_DSTST_DSTST64_DSTSTT_DSTSTT64_DSTT_DSTT64_ICBLQ_LBEPX_LHEPX_LWEPX_TLBIVAX_TLBLD_TLBLI_TLBRE_TLBRE2_TLBSX_TLBSX2_TLBSX2D_TLBWE_TLBWE2_MBAR_TRAP_DCCCI_ICCCI
  { 1, 134, 135, 0, 0 }, // 303 ICBLC_STBEPX_STHEPX_STWEPX
  { 1, 143, 144, 0, 0 }, // 304 LFDEPX
  { 1, 134, 135, 0, 0 }, // 305 STFDEPX
  { 1, 145, 146, 0, 0 }, // 306 MFSR_MFSRIN
  { 1, 133, 134, 0, 0 }, // 307 MTSR_MTSRIN
  { 1, 145, 146, 0, 0 }, // 308 MFDCR
  { 1, 133, 134, 0, 0 }, // 309 MTDCR
  { 1, 130, 131, 0, 0 }, // 310 NOP_GT_PWR6_NOP_GT_PWR7
  { 0, 0, 0, 0, 0 }, // 311 TLBIA
  { 1, 133, 134, 0, 0 }, // 312 WRTEE_WRTEEI
  { 1, 130, 131, 0, 0 }, // 313 HASHCHK_HASHCHK8_HASHCHKP_HASHCHKP8_HASHST_HASHST8_HASHSTP_HASHSTP8_ADDEX_ADDEX8
  { 1, 129, 130, 0, 0 }, // 314 MSYNC
  { 0, 0, 0, 0, 0 }, // 315 SLBSYNC
  { 0, 0, 0, 0, 0 }, // 316 SLBFEE_rec
  { 0, 0, 0, 0, 0 }, // 317 STOP
  { 1, 134, 135, 0, 0 }, // 318 DCBA_DCBI
  { 1, 136, 137, 0, 0 }, // 319 FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRE_FRES_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRSP_FRSQRTE_FRSQRTES
  { 1, 132, 133, 0, 0 }, // 320 VCFSX_VCFSX_0_VCFUX_VCFUX_0_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VLOGEFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP
  { 1, 132, 133, 0, 0 }, // 321 XSCVDPHP_XSCVDPSP_XSCVDPSPN_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPSXWSs_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPUXWSs_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSP_XSRSQRTEDP_XSRSQRTESP
  { 1, 132, 133, 0, 0 }, // 322 XVCVSPBF16
  { 1, 136, 137, 0, 0 }, // 323 FADDS_FMULS_FSUBS
  { 1, 136, 137, 0, 0 }, // 324 FMUL
  { 1, 132, 133, 0, 0 }, // 325 VADDFP_XVADDDP_XVADDSP_XVMULDP_XVMULSP_XVSUBDP_XVSUBSP
  { 1, 138, 139, 0, 0 }, // 326 VSUBFP
  { 1, 132, 133, 0, 0 }, // 327 XSADDDP_XSADDSP_XSSUBDP_XSSUBSP
  { 1, 132, 133, 0, 0 }, // 328 XSMULDP_XSMULSP
  { 1, 132, 133, 0, 0 }, // 329 VMADDFP_VNMSUBFP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP
  { 1, 132, 133, 0, 0 }, // 330 VEXPTEFP
  { 1, 136, 137, 0, 0 }, // 331 FADDS_rec_FMULS_rec_FSUBS_rec
  { 1, 136, 137, 0, 0 }, // 332 FMUL_rec
  { 1, 136, 137, 0, 0 }, // 333 FCFID_rec_FCFIDS_rec_FCFIDU_rec_FCFIDUS_rec_FCTID_rec_FCTIDU_rec_FCTIDUZ_rec_FCTIDZ_rec_FCTIW_rec_FCTIWU_rec_FCTIWUZ_rec_FCTIWZ_rec_FRE_rec_FRES_rec_FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRSP_rec_FRSQRTE_rec_FRSQRTES_rec
  { 1, 131, 132, 0, 0 }, // 334 BCLR_BCLRn_BDNZLR_BDNZLR8_BDNZLRm_BDNZLRp_BDZLR_BDZLR8_BDZLRm_BDZLRp_gBCLR_BCLRL_BCLRLn_BDNZLRL_BDNZLRLm_BDNZLRLp_BDZLRL_BDZLRLm_BDZLRLp_gBCLRL_BL_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLR_BLR8_BLRL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS
  { 1, 131, 132, 0, 0 }, // 335 BL8_NOTOC_BL8_NOTOC_RM_BL8_NOTOC_TLS
  { 1, 131, 132, 0, 0 }, // 336 B_BCC_BCCA_BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_CTRL_DEP_TAILB_TAILB8_BA_TAILBA_TAILBA8_BC_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_LDinto_toc_BCTRL8_LDinto_toc_RM_BCTRL8_RM_BCTRL_LWZinto_toc_BCTRL_LWZinto_toc_RM_BCTRL_RM_BCn_BDNZ_BDNZ8_BDNZm_BDNZp_BDZ_BDZ8_BDZm_BDZp_TAILBCTR_TAILBCTR8_gBC_gBCat_BCL_BCLalways_BCLn_BDNZL_BDNZLm_BDNZLp_BDZL_BDZLm_BDZLp_gBCL_gBCLat_BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM
  { 1, 131, 132, 0, 0 }, // 337 BCCTR_BCCTR8_BCCTR8n_BCCTRn_gBCCTR_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_gBCCTRL
  { 1, 132, 133, 0, 0 }, // 338 VSBOX
  { 1, 130, 131, 0, 0 }, // 339 CFUGED_CNTLZDM_CNTTZDM_PDEPD_PEXTD
  { 1, 138, 139, 0, 0 }, // 340 VCFUGED_VCLZDM_VCTZDM_VGNB_VPDEPD_VPEXTD
  { 1, 132, 133, 0, 0 }, // 341 XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP
  { 1, 132, 133, 0, 0 }, // 342 XSCVQPSQZ_XSCVQPUQZ_XSCVSQQP_XSCVUQQP
  { 1, 132, 133, 0, 0 }, // 343 XSADDQP_XSADDQPO_XSSUBQP_XSSUBQPO
  { 1, 130, 131, 0, 0 }, // 344 HASHST_HASHST8_HASHSTP_HASHSTP8
  { 1, 132, 133, 0, 0 }, // 345 XSMULQP_XSMULQPO
  { 1, 138, 139, 0, 0 }, // 346 VDIVESQ_VDIVEUQ_VDIVSQ_VDIVUQ
  { 1, 138, 139, 0, 0 }, // 347 VMODSQ_VMODUQ
  { 1, 135, 136, 0, 0 }, // 348 DIVWE_DIVWEO_DIVWEU_DIVWEUO
  { 1, 138, 139, 0, 0 }, // 349 VDIVSD_VDIVUD
  { 1, 138, 139, 0, 0 }, // 350 VMODSD_VMODUD
  { 1, 138, 139, 0, 0 }, // 351 VDIVSW_VDIVUW
  { 1, 138, 139, 0, 0 }, // 352 VMODSW_VMODUW
  { 1, 138, 139, 0, 0 }, // 353 VDIVESD_VDIVEUD
  { 1, 138, 139, 0, 0 }, // 354 VDIVESW_VDIVEUW
  { 1, 132, 133, 0, 0 }, // 355 BCDCTN_rec_VMUL10CUQ_VMUL10UQ_XSXSIGQP
  { 1, 132, 133, 0, 0 }, // 356 BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDUS_rec_BCDUTRUNC_rec_VADDCUQ_VMUL10ECUQ_VMUL10EUQ_VSUBCUQ_XSTSTDCQP
  { 1, 138, 139, 0, 0 }, // 357 VADDUQM_VSUBUQM
  { 1, 132, 133, 0, 0 }, // 358 XSMAXCQP_XSMINCQP
  { 1, 138, 139, 0, 0 }, // 359 XXGENPCVBM
  { 1, 132, 133, 0, 0 }, // 360 BCDADD_rec_BCDS_rec_BCDSUB_rec_BCDTRUNC_rec_VADDECUQ_VADDEUQM_VSUBECUQ_VSUBEUQM
  { 1, 134, 135, 0, 0 }, // 361 TRAP
  { 1, 147, 148, 0, 0 }, // 362 TW
  { 1, 130, 131, 0, 0 }, // 363 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW
  { 1, 136, 137, 0, 0 }, // 364 FTSQRT
  { 1, 138, 139, 0, 0 }, // 365 MTVSRBM_MTVSRBMI_MTVSRDM_MTVSRHM_MTVSRQM_MTVSRWM_VEXPANDBM_VEXPANDDM_VEXPANDHM_VEXPANDQM_VEXPANDWM_VEXTRACTBM_VEXTRACTDM_VEXTRACTHM_VEXTRACTQM_VEXTRACTWM_XVTLSBB
  { 1, 130, 131, 0, 0 }, // 366 POPCNTB_POPCNTB8
  { 1, 138, 139, 0, 0 }, // 367 VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTD_VPOPCNTW_VPRTYBD_VPRTYBW
  { 1, 138, 139, 0, 0 }, // 368 VPOPCNTB_VPOPCNTH
  { 1, 132, 133, 0, 0 }, // 369 XSCVSPDPN
  { 1, 136, 137, 0, 0 }, // 370 XSTSQRTDP
  { 1, 132, 133, 0, 0 }, // 371 XVCVHPSP
  { 1, 136, 137, 0, 0 }, // 372 XVTSQRTDP_XVTSQRTSP
  { 1, 130, 131, 0, 0 }, // 373 CMPEQB
  { 0, 0, 0, 0, 0 }, // 374 EXTSWSLI_32_64_rec_EXTSWSLI_rec
  { 0, 0, 0, 0, 0 }, // 375 SLD_rec_SRD_rec
  { 1, 130, 131, 0, 0 }, // 376 SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 1, 132, 133, 0, 0 }, // 377 VADDCUW_VADDSBS_VADDSHS_VADDSWS_VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VMAXFP_VMINFP_VSUBCUW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP
  { 1, 148, 149, 0, 0 }, // 378 VCMPBFP_VCMPBFP_rec_VCMPEQFP_VCMPEQFP_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPGTSB_rec_VCMPGTSD_rec_VCMPGTSH_rec_VCMPGTSW_rec_VCMPGTUB_rec_VCMPGTUD_rec_VCMPGTUH_rec_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 1, 148, 149, 0, 0 }, // 379 VCMPEQUQ_VCMPEQUQ_rec_VCMPGTSQ_VCMPGTSQ_rec_VCMPGTUQ_VCMPGTUQ_rec
  { 1, 138, 139, 0, 0 }, // 380 VCMPSQ_VCMPUQ_VCNTMBB_VCNTMBD_VCNTMBH_VCNTMBW
  { 1, 132, 133, 0, 0 }, // 381 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP
  { 0, 0, 0, 0, 0 }, // 382 RLDIC_rec
  { 0, 0, 0, 0, 0 }, // 383 RLDICL_32_rec_RLDICL_rec_RLDICR_rec
  { 1, 132, 133, 0, 0 }, // 384 VSHASIGMAD_VSHASIGMAW
  { 1, 132, 133, 0, 0 }, // 385 VRLQ_VRLQNM_VSLQ_VSRAQ_VSRQ
  { 1, 132, 133, 0, 0 }, // 386 VRLQMI
  { 1, 133, 134, 0, 0 }, // 387 CR6SET_CREQV_CRSET
  { 1, 134, 135, 0, 0 }, // 388 DSS_DSSALL
  { 1, 145, 146, 0, 0 }, // 389 MFCTR_MFCTR8_MFLR_MFLR8
  { 1, 130, 131, 0, 0 }, // 390 NOP_ORI_ORI8
  { 1, 132, 133, 0, 0 }, // 391 VXOR_V_SET0_V_SET0B_V_SET0H
  { 1, 138, 139, 0, 0 }, // 392 XXLEQV_XXLEQVOnes_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 1, 130, 131, 0, 0 }, // 393 ADDI_ADDI8_LI_LI8_ADDIS_ADDIS8_LIS_LIS8_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_NEG_NEG8_NEG8_rec_NEG_rec_NEG8O_NEGO
  { 0, 0, 0, 0, 0 }, // 394 ADDIdtprelL32_ADDItlsldLADDR32_ADDISdtprelHA32
  { 0, 0, 0, 0, 0 }, // 395 ADDItocL_ADDIStocHA_ADDIStocHA8
  { 1, 130, 131, 0, 0 }, // 396 ADDME_ADDME8_ADDME8O_ADDMEO_ADDZE_ADDZE8_ADDZE8O_ADDZEO_SUBFME_SUBFME8_SUBFME8O_SUBFMEO_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZEO
  { 1, 136, 137, 0, 0 }, // 397 FABSD_FABSS_FMR_FNABSD_FNABSS_FNEGD_FNEGS
  { 1, 130, 131, 0, 0 }, // 398 SETB_SETB8
  { 1, 130, 131, 0, 0 }, // 399 SETBC_SETBC8_SETBCR_SETBCR8_SETNBC_SETNBC8_SETNBCR_SETNBCR8
  { 1, 138, 139, 0, 0 }, // 400 VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VNEGD_VNEGW
  { 1, 138, 139, 0, 0 }, // 401 VEXTSD2Q
  { 1, 132, 133, 0, 0 }, // 402 XSABSDP_XSNABSDP_XSNEGDP_XSXEXPDP
  { 1, 132, 133, 0, 0 }, // 403 XSABSQP_XSNABSQP_XSNEGQP_XSXEXPQP_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVNEGDP_XVNEGSP_XVXEXPDP_XVXEXPSP
  { 1, 132, 133, 0, 0 }, // 404 XVXSIGDP_XVXSIGSP
  { 1, 130, 131, 0, 0 }, // 405 ADD4_ADD4TLS_ADD8_ADD8TLS_ADD8TLS__ADD4_rec_ADD8_rec_ADD4O_ADD8O_AND_AND8_AND8_rec_AND_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_EQV_EQV8_EQV8_rec_EQV_rec_NAND_NAND8_NAND8_rec_NAND_rec_NOR_NOR8_NOR8_rec_NOR_rec_OR_OR8_OR8_rec_OR_rec_ORC_ORC8_ORC8_rec_ORC_rec_ORIS_ORIS8_XOR_XOR8_XOR8_rec_XOR_rec_XORI_XORI8_XORIS_XORIS8
  { 1, 130, 131, 0, 0 }, // 406 ADDE_ADDE8_ADDE8O_ADDEO_ADDIC_ADDIC8_ANDI8_rec_ANDI_rec_ANDIS8_rec_ANDIS_rec_SUBF_SUBF8_SUBF8_rec_SUBF_rec_SUBFE_SUBFE8_SUBFE8O_SUBFEO_SUBFIC_SUBFIC8_SUBF8O_SUBFO
  { 1, 130, 131, 0, 0 }, // 407 CMPB_CMPB8
  { 0, 0, 0, 0, 0 }, // 408 EXTSWSLI_EXTSWSLI_32_64_SRADI_SRADI_32
  { 1, 130, 131, 0, 0 }, // 409 SLW_SLW8_SRW_SRW8
  { 1, 138, 139, 0, 0 }, // 410 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEQV_VNAND_VORC_VSLD_VSRAD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_XXLAND_XXLANDC_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC
  { 1, 132, 133, 0, 0 }, // 411 VAND_VANDC_VMRGEW_VMRGOW_VNOR_VOR_VRLB_VRLD_VRLDNM_VRLH_VRLW_VRLWNM_VSLB_VSLH_VSLW_VSRAB_VSRAH_VSRAW_VSRB_VSRH_VSRW_XSCPSGNQP_XSIEXPQP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP
  { 1, 132, 133, 0, 0 }, // 412 VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW
  { 1, 130, 131, 0, 0 }, // 413 ADDEX_ADDEX8
  { 1, 134, 135, 0, 0 }, // 414 DST_DST64_DSTT_DSTT64_DSTST_DSTST64_DSTSTT_DSTSTT64
  { 0, 0, 0, 0, 0 }, // 415 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32
  { 1, 136, 137, 0, 0 }, // 416 MFFS_MFFS_rec_MFFSL
  { 1, 133, 134, 0, 0 }, // 417 TRECHKPT
  { 1, 130, 131, 0, 0 }, // 418 ADDME8_rec_ADDME_rec_ADDME8O_rec_ADDMEO_rec_ADDZE8_rec_ADDZE_rec_ADDZE8O_rec_ADDZEO_rec_SUBFME8_rec_SUBFME_rec_SUBFME8O_rec_SUBFMEO_rec_SUBFZE8_rec_SUBFZE_rec_SUBFZE8O_rec_SUBFZEO_rec
  { 1, 136, 137, 0, 0 }, // 419 MTFSB0
  { 1, 130, 131, 0, 0 }, // 420 NEG8O_rec_NEGO_rec
  { 1, 130, 131, 0, 0 }, // 421 ADDE8_rec_ADDE_rec_ADDE8O_rec_ADDEO_rec_ADDIC_rec_SUBFE8_rec_SUBFE_rec_SUBFE8O_rec_SUBFEO_rec_SUBF8O_rec_SUBFO_rec
  { 1, 131, 132, 0, 0 }, // 422 HRFID
  { 1, 136, 137, 0, 0 }, // 423 FABSD_rec_FABSS_rec_FMR_rec_FNABSD_rec_FNABSS_rec_FNEGD_rec_FNEGS_rec
  { 1, 131, 132, 0, 0 }, // 424 SC
  { 1, 130, 131, 0, 0 }, // 425 ADDC_ADDC8_ADDC8O_ADDCO_SUBFC_SUBFC8_SUBFC8O_SUBFCO
  { 1, 130, 131, 0, 0 }, // 426 ADDC8_rec_ADDC_rec_SUBFC8_rec_SUBFC_rec
  { 1, 136, 137, 0, 0 }, // 427 MTFSF_MTFSFI_MTFSFIb
  { 1, 136, 137, 0, 0 }, // 428 MTFSFI_rec
  { 1, 138, 139, 0, 0 }, // 429 VSTRIBL_rec_VSTRIBR_rec_VSTRIHL_rec_VSTRIHR_rec
  { 1, 134, 135, 0, 0 }, // 430 LBZ_LBZ8_LDBRX_LHBRX_LHBRX8_LHZ_LHZ8_LWBRX_LWBRX8_LWZ_LWZ8
  { 0, 0, 0, 0, 0 }, // 431 LD
  { 0, 0, 0, 0, 0 }, // 432 LDtoc_LDtocBA_LDtocCPT_LDtocJTI_LDtocL_SPILLTOVSR_LD_LWZtoc_LWZtocL
  { 1, 143, 144, 0, 0 }, // 433 LXVRBX_LXVRDX_LXVRHX_LXVRWX
  { 1, 134, 135, 0, 0 }, // 434 DCBT_DCBTST
  { 1, 134, 135, 0, 0 }, // 435 ICBT_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32
  { 0, 0, 0, 0, 0 }, // 436 LDX_LDXTLS_LDXTLS_
  { 0, 0, 0, 0, 0 }, // 437 SPILLTOVSR_LDX
  { 1, 134, 135, 0, 0 }, // 438 LBZCIX_LDCIX_LHZCIX_LWZCIX
  { 1, 133, 134, 0, 0 }, // 439 MTSR
  { 1, 130, 131, 0, 0 }, // 440 MTVRSAVE_MTVRSAVEv
  { 1, 134, 135, 0, 0 }, // 441 LSWI
  { 1, 143, 144, 0, 0 }, // 442 PLBZ_PLBZ8_PLBZ8pc_PLBZpc_PLD_PLDpc_PLFD_PLFDpc_PLFS_PLFSpc_PLHA_PLHA8_PLHA8pc_PLHApc_PLHZ_PLHZ8_PLHZ8pc_PLHZpc_PLWA_PLWA8_PLWA8pc_PLWApc_PLWZ_PLWZ8_PLWZ8pc_PLWZpc_PLXSD_PLXSDpc_PLXSSP_PLXSSPpc_PLXV_PLXVpc_PLXVP_PLXVPpc
  { 1, 143, 144, 0, 0 }, // 443 LXVP_LXVPX
  { 1, 145, 146, 0, 0 }, // 444 MFSR
  { 1, 146, 147, 0, 0 }, // 445 MFTB8
  { 1, 138, 139, 0, 0 }, // 446 XXSETACCZ
  { 1, 132, 133, 0, 0 }, // 447 XVBF16GER2_XVF16GER2_XVF32GER_XVF64GER_XVI16GER2_XVI16GER2S_XVI4GER8_XVI8GER4
  { 1, 132, 133, 0, 0 }, // 448 XVBF16GER2NN_XVBF16GER2NP_XVBF16GER2PN_XVBF16GER2PP_XVF16GER2NN_XVF16GER2NP_XVF16GER2PN_XVF16GER2PP_XVF32GERNN_XVF32GERNP_XVF32GERPN_XVF32GERPP_XVF64GERNN_XVF64GERNP_XVF64GERPN_XVF64GERPP_XVI16GER2PP_XVI16GER2SPP_XVI4GER8PP_XVI8GER4PP
  { 1, 138, 139, 0, 0 }, // 449 XVI8GER4SPP
  { 1, 132, 133, 0, 0 }, // 450 PMXVF32GER_PMXVF64GER
  { 1, 132, 133, 0, 0 }, // 451 PMXVBF16GER2_PMXVF16GER2_PMXVF32GERNN_PMXVF32GERNP_PMXVF32GERPN_PMXVF32GERPP_PMXVF64GERNN_PMXVF64GERNP_PMXVF64GERPN_PMXVF64GERPP_PMXVI16GER2_PMXVI16GER2S_PMXVI4GER8_PMXVI8GER4
  { 1, 132, 133, 0, 0 }, // 452 PMXVBF16GER2NN_PMXVBF16GER2NP_PMXVBF16GER2PN_PMXVBF16GER2PP_PMXVF16GER2NN_PMXVF16GER2NP_PMXVF16GER2PN_PMXVF16GER2PP_PMXVI16GER2PP_PMXVI16GER2SPP_PMXVI4GER8PP_PMXVI8GER4PP
  { 1, 138, 139, 0, 0 }, // 453 PMXVI8GER4SPP
  { 1, 138, 139, 0, 0 }, // 454 XXMTACC
  { 1, 138, 139, 0, 0 }, // 455 XXMFACC
  { 0, 0, 0, 0, 0 }, // 456 MULLD_MULLDO
  { 1, 138, 139, 0, 0 }, // 457 VMULHSD_VMULHUD_VMULLD
  { 1, 149, 150, 0, 0 }, // 458 VSPLTISW
  { 1, 132, 133, 0, 0 }, // 459 V_SETALLONES_V_SETALLONESB_V_SETALLONESH
  { 1, 138, 139, 0, 0 }, // 460 MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VPRTYBQ
  { 1, 132, 133, 0, 0 }, // 461 VGBBD_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW
  { 1, 149, 150, 0, 0 }, // 462 VSPLTISB_VSPLTISH_XXSPLTIB
  { 1, 138, 139, 0, 0 }, // 463 VSTRIBL_VSTRIBR_VSTRIHL_VSTRIHR
  { 1, 132, 133, 0, 0 }, // 464 XVCVBF16SPN
  { 1, 132, 133, 0, 0 }, // 465 VBPERMQ_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLO_VSLV_VSR_VSRO_VSRV_XXEXTRACTUW
  { 1, 138, 139, 0, 0 }, // 466 VCLRLB_VCLRRB_XXGENPCVDM_XXGENPCVHM_XXGENPCVWM
  { 1, 138, 139, 0, 0 }, // 467 VEXTRACTD_VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VINSERTD_VINSERTW
  { 1, 138, 139, 0, 0 }, // 468 VEXTDDVLX_VEXTDDVRX_VEXTDUBVLX_VEXTDUBVRX_VEXTDUHVLX_VEXTDUHVRX_VEXTDUWVLX_VEXTDUWVRX_VINSBLX_VINSBRX_VINSBVLX_VINSBVRX_VINSD_VINSDLX_VINSDRX_VINSHLX_VINSHRX_VINSHVLX_VINSHVRX_VINSW_VINSWLX_VINSWRX_VINSWVLX_VINSWVRX_VSLDBI_VSRDBI
  { 1, 132, 133, 0, 0 }, // 469 VSUMSWS
  { 1, 138, 139, 0, 0 }, // 470 XXSPLTIDP_XXSPLTIW
  { 1, 138, 139, 0, 0 }, // 471 XXBLENDVB_XXBLENDVD_XXBLENDVH_XXBLENDVW_XXSPLTI32DX
  { 1, 138, 139, 0, 0 }, // 472 XXEVAL
  { 1, 149, 150, 0, 0 }, // 473 XXPERMX
  { 1, 134, 135, 0, 0 }, // 474 DCBST_DCBZ
  { 1, 141, 142, 0, 0 }, // 475 ICBI
  { 1, 134, 135, 0, 0 }, // 476 DCBF
  { 1, 143, 144, 0, 0 }, // 477 PSTXVP_PSTXVPpc
  { 1, 134, 135, 0, 0 }, // 478 STB_STB8_STDBRX_STH_STH8_STHBRX_STW_STW8_STWBRX
  { 0, 0, 0, 0, 0 }, // 479 SPILLTOVSR_ST
  { 1, 134, 135, 0, 0 }, // 480 STD
  { 0, 0, 0, 0, 0 }, // 481 DFSTOREf32_DFSTOREf64_STIWX
  { 1, 134, 135, 0, 0 }, // 482 STXVRBX_STXVRDX_STXVRHX_STXVRWX
  { 0, 0, 0, 0, 0 }, // 483 SPILLTOVSR_STX
  { 1, 134, 135, 0, 0 }, // 484 EnforceIEIO
  { 1, 134, 135, 0, 0 }, // 485 STBCIX_STDCIX_STHCIX_STWCIX
  { 1, 143, 144, 0, 0 }, // 486 PSTB_PSTB8_PSTB8pc_PSTBpc_PSTD_PSTDpc_PSTFD_PSTFDpc_PSTFS_PSTFSpc_PSTH_PSTH8_PSTH8pc_PSTHpc_PSTW_PSTW8_PSTW8pc_PSTWpc_PSTXSD_PSTXSDpc_PSTXSSP_PSTXSSPpc_PSTXV_PSTXVpc
  { 1, 143, 144, 0, 0 }, // 487 STXVP_STXVPX
  { 1, 131, 132, 0, 0 }, // 488 ATTN_NAP
  { 1, 134, 135, 0, 0 }, // 489 DCBZL
  { 1, 134, 135, 0, 0 }, // 490 DCCCI_ICBLQ_ICCCI_TLBLD_TLBLI_TLBRE2_TLBSX2_TLBSX2D_TLBWE2
  { 1, 134, 135, 0, 0 }, // 491 ICBLC
  { 1, 131, 132, 0, 0 }, // 492 CLRBHRB
  { 1, 131, 132, 0, 0 }, // 493 MFBHRBE
  { 1, 143, 144, 0, 0 }, // 494 PADDI_PADDI8_PADDI8pc_PADDIpc
  { 1, 130, 131, 0, 0 }, // 495 PLI_PLI8
  { 1, 132, 133, 0, 0 }, // 496 VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS
  { 1, 138, 139, 0, 0 }, // 497 VMULESD_VMULEUD_VMULHSW_VMULHUW_VMULOSD_VMULOUD
  { 1, 138, 139, 0, 0 }, // 498 VMSUMCUD
  { 0, uint16_t(~0U), uint16_t(~0U), uint16_t(~0U), uint16_t(~0U) }// end marker
};

static const llvm::InstrItinerary G5Itineraries[] = {
  { 0, 0, 0, 0, 0 }, // 0 NoInstrModel
  { 1, 150, 151, 0, 0 }, // 1 IIC_LdStSync
  { 1, 151, 152, 0, 0 }, // 2 IIC_IntSimple
  { 1, 151, 152, 0, 0 }, // 3 IIC_IntGeneral
  { 1, 152, 153, 0, 0 }, // 4 IIC_BrB
  { 1, 153, 154, 0, 0 }, // 5 IIC_VecFP
  { 1, 154, 155, 0, 0 }, // 6 IIC_IntCompare
  { 0, 0, 0, 0, 0 }, // 7 IIC_SprABORT
  { 0, 0, 0, 0, 0 }, // 8 IIC_LdStCOPY
  { 0, 0, 0, 0, 0 }, // 9 IIC_LdStPASTE
  { 1, 155, 156, 0, 0 }, // 10 IIC_BrCR
  { 1, 156, 157, 0, 0 }, // 11 IIC_LdStLD
  { 1, 156, 157, 0, 0 }, // 12 IIC_LdStDCBF
  { 1, 156, 157, 0, 0 }, // 13 IIC_LdStLoad
  { 1, 157, 158, 0, 0 }, // 14 IIC_IntDivD
  { 1, 158, 159, 0, 0 }, // 15 IIC_IntDivW
  { 0, 0, 0, 0, 0 }, // 16 IIC_FPDGeneral
  { 1, 159, 160, 0, 0 }, // 17 IIC_FPAddSub
  { 1, 160, 161, 0, 0 }, // 18 IIC_FPDivD
  { 0, 0, 0, 0, 0 }, // 19 IIC_FPSGeneral
  { 1, 161, 162, 0, 0 }, // 20 IIC_FPCompare
  { 1, 159, 160, 0, 0 }, // 21 IIC_FPGeneral
  { 1, 162, 163, 0, 0 }, // 22 IIC_VecGeneral
  { 1, 163, 164, 0, 0 }, // 23 IIC_VecComplex
  { 1, 156, 157, 0, 0 }, // 24 IIC_LdStStore
  { 1, 151, 152, 0, 0 }, // 25 IIC_IntRotateDI
  { 1, 160, 161, 0, 0 }, // 26 IIC_FPDivS
  { 1, 159, 160, 0, 0 }, // 27 IIC_FPFused
  { 1, 164, 165, 0, 0 }, // 28 IIC_FPSqrtD
  { 1, 164, 165, 0, 0 }, // 29 IIC_FPSqrtS
  { 1, 165, 166, 0, 0 }, // 30 IIC_LdStICBI
  { 0, 0, 0, 0, 0 }, // 31 IIC_IntISEL
  { 1, 165, 166, 0, 0 }, // 32 IIC_SprISYNC
  { 1, 166, 167, 0, 0 }, // 33 IIC_LdStLWARX
  { 1, 156, 157, 0, 0 }, // 34 IIC_LdStLoadUpd
  { 1, 156, 157, 0, 0 }, // 35 IIC_LdStLoadUpdX
  { 1, 166, 167, 0, 0 }, // 36 IIC_LdStLDARX
  { 1, 156, 157, 0, 0 }, // 37 IIC_LdStLDU
  { 1, 156, 157, 0, 0 }, // 38 IIC_LdStLDUX
  { 1, 156, 157, 0, 0 }, // 39 IIC_LdStLFD
  { 1, 167, 168, 0, 0 }, // 40 IIC_LdStLFDU
  { 1, 167, 168, 0, 0 }, // 41 IIC_LdStLFDUX
  { 1, 167, 168, 0, 0 }, // 42 IIC_LdStLHA
  { 1, 167, 168, 0, 0 }, // 43 IIC_LdStLHAU
  { 1, 167, 168, 0, 0 }, // 44 IIC_LdStLHAUX
  { 1, 168, 169, 0, 0 }, // 45 IIC_LdStLMW
  { 0, 0, 0, 0, 0 }, // 46 IIC_LdStLQ
  { 0, 0, 0, 0, 0 }, // 47 IIC_LdStLQARX
  { 1, 167, 168, 0, 0 }, // 48 IIC_LdStLWA
  { 1, 169, 170, 0, 0 }, // 49 IIC_IntMulHD
  { 1, 170, 171, 0, 0 }, // 50 IIC_BrMCR
  { 1, 171, 172, 0, 0 }, // 51 IIC_BrMCRX
  { 1, 172, 173, 0, 0 }, // 52 IIC_SprMFCR
  { 1, 173, 174, 0, 0 }, // 53 IIC_SprMFSPR
  { 1, 174, 175, 0, 0 }, // 54 IIC_IntMFFS
  { 1, 173, 174, 0, 0 }, // 55 IIC_SprMFMSR
  { 1, 172, 173, 0, 0 }, // 56 IIC_SprMFCRF
  { 0, 0, 0, 0, 0 }, // 57 IIC_SprMFPMR
  { 1, 156, 157, 0, 0 }, // 58 IIC_SprMFSR
  { 1, 175, 176, 0, 0 }, // 59 IIC_SprMFTB
  { 0, 0, 0, 0, 0 }, // 60 IIC_SprMSGSYNC
  { 1, 176, 177, 0, 0 }, // 61 IIC_SprMTSPR
  { 1, 159, 160, 0, 0 }, // 62 IIC_IntMTFSB0
  { 1, 156, 157, 0, 0 }, // 63 IIC_SprMTMSR
  { 0, 0, 0, 0, 0 }, // 64 IIC_SprMTMSRD
  { 0, 0, 0, 0, 0 }, // 65 IIC_SprMTPMR
  { 1, 156, 157, 0, 0 }, // 66 IIC_SprMTSR
  { 1, 177, 178, 0, 0 }, // 67 IIC_IntMulHW
  { 1, 177, 178, 0, 0 }, // 68 IIC_IntMulHWU
  { 1, 178, 179, 0, 0 }, // 69 IIC_IntMulLI
  { 0, 0, 0, 0, 0 }, // 70 IIC_SprRFI
  { 1, 179, 180, 0, 0 }, // 71 IIC_IntRFID
  { 1, 151, 152, 0, 0 }, // 72 IIC_IntRotateD
  { 1, 178, 179, 0, 0 }, // 73 IIC_IntRotate
  { 0, 0, 0, 0, 0 }, // 74 IIC_SprSLBFEE
  { 0, 0, 0, 0, 0 }, // 75 IIC_SprSLBIA
  { 0, 0, 0, 0, 0 }, // 76 IIC_SprSLBIE
  { 0, 0, 0, 0, 0 }, // 77 IIC_SprSLBIEG
  { 0, 0, 0, 0, 0 }, // 78 IIC_SprSLBMFEE
  { 0, 0, 0, 0, 0 }, // 79 IIC_SprSLBMFEV
  { 0, 0, 0, 0, 0 }, // 80 IIC_SprSLBMTE
  { 0, 0, 0, 0, 0 }, // 81 IIC_SprSLBSYNC
  { 1, 151, 152, 0, 0 }, // 82 IIC_IntShift
  { 1, 166, 167, 0, 0 }, // 83 IIC_LdStSTWCX
  { 1, 156, 157, 0, 0 }, // 84 IIC_LdStSTU
  { 1, 156, 157, 0, 0 }, // 85 IIC_LdStSTUX
  { 1, 156, 157, 0, 0 }, // 86 IIC_LdStSTD
  { 1, 166, 167, 0, 0 }, // 87 IIC_LdStSTDCX
  { 1, 180, 181, 0, 0 }, // 88 IIC_LdStSTFD
  { 1, 180, 181, 0, 0 }, // 89 IIC_LdStSTFDU
  { 0, 0, 0, 0, 0 }, // 90 IIC_SprSTOP
  { 0, 0, 0, 0, 0 }, // 91 IIC_LdStSTQ
  { 0, 0, 0, 0, 0 }, // 92 IIC_LdStSTQCX
  { 1, 181, 182, 0, 0 }, // 93 IIC_IntTrapD
  { 0, 0, 0, 0, 0 }, // 94 IIC_SprTLBIA
  { 0, 0, 0, 0, 0 }, // 95 IIC_SprTLBIE
  { 0, 0, 0, 0, 0 }, // 96 IIC_SprTLBIEL
  { 1, 156, 157, 0, 0 }, // 97 IIC_SprTLBSYNC
  { 1, 181, 182, 0, 0 }, // 98 IIC_IntTrapW
  { 1, 182, 183, 0, 0 }, // 99 IIC_VecFPCompare
  { 1, 183, 184, 0, 0 }, // 100 IIC_VecPerm
  { 1, 162, 163, 0, 0 }, // 101 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VSLD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_VPOPCNTB_VPOPCNTH_VSRAD_MTVSRDD_VEQV_VNAND_VNEGD_VNEGW_VORC_XXLAND_XXLANDC_XXLEQV_XXLEQVOnes_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 1, 153, 154, 0, 0 }, // 102 VAND_VANDC_V_SET0_V_SET0B_V_SET0H_VSLB_VSLH_VSLW_VSRB_VSRH_VSRW_VRLB_VRLD_VRLH_VRLW_VSRAB_VSRAH_VSRAW_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP_XVXEXPDP_XVXEXPSP_VRLDMI_VRLDNM_VRLWMI_VRLWNM_VMRGEW_VMRGOW_VNOR_VOR_VSEL_VXOR_XVNEGDP_XVNEGSP_XSABSQP_XSCPSGNQP_XSIEXPQP_XSNABSQP_XSNEGQP_XSXEXPQP
  { 1, 183, 184, 0, 0 }, // 103 XXSEL
  { 1, 176, 177, 0, 0 }, // 104 TABORTDC_TABORTDCI_TABORTWC_TABORTWCI
  { 1, 159, 160, 0, 0 }, // 105 MTFSB0_MTFSB1
  { 1, 174, 175, 0, 0 }, // 106 MFFSCDRN_MFFSCDRNI_MFFSCRN_MFFSCRNI
  { 1, 154, 155, 0, 0 }, // 107 CMPRB_CMPRB8_CMPEQB
  { 1, 181, 182, 0, 0 }, // 108 TD_TDI
  { 1, 181, 182, 0, 0 }, // 109 TW_TWI
  { 1, 161, 162, 0, 0 }, // 110 FCMPOD_FCMPOS_FCMPUD_FCMPUS_FTDIV_FTSQRT
  { 1, 153, 154, 0, 0 }, // 111 XSTSTDCDP_XSTSTDCSP
  { 1, 153, 154, 0, 0 }, // 112 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP_XSXSIGDP_XSCVSPDPN
  { 1, 161, 162, 0, 0 }, // 113 XSCMPEQDP_XSCMPEXPDP_XSCMPGEDP_XSCMPGTDP_XSCMPODP_XSCMPUDP_XSTDIVDP_XSTSQRTDP
  { 1, 151, 152, 0, 0 }, // 114 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW_CMPB_CMPB8_SETB_SETB8_BPERMD
  { 1, 151, 152, 0, 0 }, // 115 SLD_SRD_SRAD
  { 1, 151, 152, 0, 0 }, // 116 SRADI_EXTSWSLI_32_64_EXTSWSLI_SRADI_32_RLDIC
  { 1, 162, 163, 0, 0 }, // 117 MFVRD_MFVSRD_MTVRD_MTVSRD_MTVRWA_MTVRWZ_MTVSRWA_MTVSRWZ_MFVSRWZ_MFVRWZ
  { 1, 154, 155, 0, 0 }, // 118 CMPLW_CMPLWI_CMPW_CMPWI_CMPD_CMPDI_CMPLD_CMPLDI
  { 1, 151, 152, 0, 0 }, // 119 SUBFC_SUBFC8_SUBFC8O_SUBFCO_SUBFIC_SUBFIC8_ANDI8_rec_ANDIS8_rec_ANDIS_rec_ANDI_rec_ADDC_ADDC8_ADDC8O_ADDCO_ADDIC_ADDIC8_ADDIC_rec_ADDE_ADDE8_ADDE8O_ADDE8O_rec_ADDE8_rec_ADDEO_ADDEO_rec_ADDE_rec_ADDME_ADDME8_ADDME8O_ADDME8O_rec_ADDME8_rec_ADDMEO_ADDMEO_rec_ADDME_rec_ADDZE_ADDZE8_ADDZE8O_ADDZE8O_rec_ADDZE8_rec_ADDZEO_ADDZEO_rec_ADDZE_rec_SUBF_SUBF8_SUBF8O_SUBF8O_rec_SUBF8_rec_SUBFE_SUBFE8_SUBFE8O_SUBFE8O_rec_SUBFE8_rec_SUBFEO_SUBFEO_rec_SUBFE_rec_SUBFME_SUBFME8_SUBFME8O_SUBFME8O_rec_SUBFME8_rec_SUBFMEO_SUBFMEO_rec_SUBFME_rec_SUBFO_SUBFO_rec_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZE8O_rec_SUBFZE8_rec_SUBFZEO_SUBFZEO_rec_SUBFZE_rec_SUBF_rec_POPCNTB_POPCNTB8_LA_LA8
  { 1, 151, 152, 0, 0 }, // 120 ADD4_ADD4O_ADD4O_rec_ADD4_rec_ADD8_ADD8O_ADD8O_rec_ADD8_rec_NEG_NEG8_NEG8O_NEG8O_rec_NEG8_rec_NEGO_NEGO_rec_NEG_rec_ADDI_ADDI8_ADDIS_ADDIS8_LI_LI8_LIS_LIS8_OR_OR8_OR8_rec_ORI_ORI8_ORIS_ORIS8_OR_rec_XOR_XOR8_XOR8_rec_XORI_XORI8_XORIS_XORIS8_XOR_rec_NAND_NAND8_NAND8_rec_NAND_rec_AND_AND8_AND8_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_AND_rec_NOR_NOR8_NOR8_rec_NOR_rec_ORC_ORC8_ORC8_rec_ORC_rec_EQV_EQV8_EQV8_rec_EQV_rec_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_ADD4TLS_ADD8TLS_ADD8TLS__NOP
  { 0, 0, 0, 0, 0 }, // 121 ADDIStocHA_ADDIStocHA8_ADDItocL_COPY
  { 1, 170, 171, 0, 0 }, // 122 MCRF
  { 1, 171, 172, 0, 0 }, // 123 MCRXRX
  { 1, 153, 154, 0, 0 }, // 124 XSNABSDP_XSXEXPDP_XSABSDP_XSNEGDP_XSCPSGNDP
  { 1, 152, 153, 0, 0 }, // 125 RFEBB
  { 1, 176, 177, 0, 0 }, // 126 TBEGIN_TRECHKPT
  { 1, 156, 157, 0, 0 }, // 127 WAIT
  { 1, 151, 152, 0, 0 }, // 128 RLDCL_RLDCR
  { 1, 178, 179, 0, 0 }, // 129 RLWIMI_RLWIMI8
  { 1, 151, 152, 0, 0 }, // 130 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32_RLDIMI
  { 1, 172, 173, 0, 0 }, // 131 MFOCRF_MFOCRF8
  { 1, 171, 172, 0, 0 }, // 132 MTOCRF_MTOCRF8
  { 1, 155, 156, 0, 0 }, // 133 CR6SET_CR6UNSET_CRSET_CRUNSET_CRAND_CRANDC_CRNAND_CRNOR_CROR_CRORC_CREQV_CRXOR
  { 1, 151, 152, 0, 0 }, // 134 SLW_SLW8_SRW_SRW8_RLWINM_RLWINM8_RLWNM_RLWNM8
  { 1, 159, 160, 0, 0 }, // 135 FABSD_FABSS_FNABSD_FNABSS_FNEGD_FNEGS_FCPSGND_FCPSGNS_FMR
  { 1, 151, 152, 0, 0 }, // 136 SRAW_SRAWI
  { 0, 0, 0, 0, 0 }, // 137 ISEL_ISEL8
  { 1, 153, 154, 0, 0 }, // 138 XSIEXPDP
  { 1, 176, 177, 0, 0 }, // 139 TRECLAIM_TSR_TABORT
  { 1, 156, 157, 0, 0 }, // 140 MFVSCR
  { 1, 156, 157, 0, 0 }, // 141 MTVSCR
  { 1, 182, 183, 0, 0 }, // 142 VCMPNEZB_VCMPNEZH_VCMPNEZW_VCMPEQUB_VCMPEQUD_VCMPEQUH_VCMPEQUW_VCMPNEB_VCMPNEH_VCMPNEW_VCMPEQFP_VCMPEQFP_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPBFP_VCMPBFP_rec_VCMPGTSB_VCMPGTSB_rec_VCMPGTSD_VCMPGTSD_rec_VCMPGTSH_VCMPGTSH_rec_VCMPGTSW_VCMPGTSW_rec_VCMPGTUB_VCMPGTUB_rec_VCMPGTUD_VCMPGTUD_rec_VCMPGTUH_VCMPGTUH_rec_VCMPGTUW_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 1, 162, 163, 0, 0 }, // 143 VABSDUB_VABSDUH_VABSDUW_VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTW_VPOPCNTD_VPRTYBD_VPRTYBW
  { 1, 153, 154, 0, 0 }, // 144 VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VADDSBS_VADDSHS_VADDSWS_VMAXFP_VMINFP_VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW_VBPERMD_VADDCUW_VSHASIGMAD_VSHASIGMAW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_VSUBCUW_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP_XVXSIGDP_XVXSIGSP
  { 1, 161, 162, 0, 0 }, // 145 XVTDIVDP_XVTDIVSP_XVTSQRTDP_XVTSQRTSP
  { 1, 153, 154, 0, 0 }, // 146 VADDFP_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VEXPTEFP_VLOGEFP_VMADDFP_VMHADDSHS_VNMSUBFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVADDDP_XVADDSP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVHPSP_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVMULDP_XVMULSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP_XVSUBDP_XVSUBSP_VCFSX_VCFSX_0_VCFUX_VCFUX_0_VMHRADDSHS_VMLADDUHM_VMSUMMBM_VMSUMSHM_VMSUMSHS_VMSUMUBM_VMSUMUHM_VMSUMUDM_VMSUMUHS_VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS_VSUMSWS
  { 1, 162, 163, 0, 0 }, // 147 VSUBFP_VMULUWM
  { 1, 169, 170, 0, 0 }, // 148 MADDHD_MADDHDU_MADDLD_MADDLD8_MULLD_MULLDO
  { 1, 177, 178, 0, 0 }, // 149 MULHD_MULHW_MULLW_MULLWO
  { 1, 177, 178, 0, 0 }, // 150 MULHDU_MULHWU
  { 1, 178, 179, 0, 0 }, // 151 MULLI_MULLI8
  { 1, 159, 160, 0, 0 }, // 152 FRSP_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRE_FRES_FADDS_FMSUBS_FMADDS_FSUBS_FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRSQRTE_FRSQRTES_FNMADDS_FNMSUBS_FSELD_FSELS_FMULS
  { 1, 159, 160, 0, 0 }, // 153 FADD_FSUB
  { 1, 159, 160, 0, 0 }, // 154 FMSUB_FMADD_FNMADD_FNMSUB_FMUL
  { 1, 153, 154, 0, 0 }, // 155 XSMADDADP_XSMADDASP_XSMADDMDP_XSMADDMSP_XSMSUBADP_XSMSUBASP_XSMSUBMDP_XSMSUBMSP_XSMULDP_XSMULSP_XSNMADDADP_XSNMADDASP_XSNMADDMDP_XSNMADDMSP_XSNMSUBADP_XSNMSUBASP_XSNMSUBMDP_XSNMSUBMSP
  { 1, 159, 160, 0, 0 }, // 156 FSELD_rec_FSELS_rec
  { 1, 177, 178, 0, 0 }, // 157 MULHDU_rec_MULHWU_rec
  { 1, 177, 178, 0, 0 }, // 158 MULHD_rec_MULHW_rec_MULLWO_rec_MULLW_rec
  { 1, 169, 170, 0, 0 }, // 159 MULLDO_rec_MULLD_rec
  { 1, 159, 160, 0, 0 }, // 160 FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRES_rec_FRE_rec_FADDS_rec_FSUBS_rec_FMSUBS_rec_FNMSUBS_rec_FMADDS_rec_FNMADDS_rec_FCFIDS_rec_FCFIDUS_rec_FCFIDU_rec_FCFID_rec_FCTIDUZ_rec_FCTIDU_rec_FCTIDZ_rec_FCTID_rec_FCTIWUZ_rec_FCTIWU_rec_FCTIWZ_rec_FCTIW_rec_FMULS_rec_FRSQRTES_rec_FRSQRTE_rec_FRSP_rec
  { 1, 159, 160, 0, 0 }, // 161 FADD_rec_FSUB_rec
  { 1, 159, 160, 0, 0 }, // 162 FMSUB_rec_FNMSUB_rec_FMADD_rec_FNMADD_rec_FMUL_rec
  { 1, 153, 154, 0, 0 }, // 163 XSADDDP_XSADDSP_XSCVDPHP_XSCVDPSP_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPSXWSs_XSCVDPUXWSs_XSCVHPDP_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSQRTEDP_XSRSQRTESP_XSSUBDP_XSSUBSP_XSCVDPSPN_XSRSP
  { 1, 156, 157, 0, 0 }, // 164 LVSL_LVSR
  { 1, 183, 184, 0, 0 }, // 165 VSPLTISB_VSPLTISH_VSPLTISW_VSPLTB_VSPLTBs_VSPLTH_VSPLTHs_VSPLTW_XXMRGHW_XXMRGLW_XXPERM_XXPERMR_XXSLDWI_XXSLDWIs_XXSPLTIB_XXSPLTW_XXSPLTWs_XXPERMDI_XXPERMDIs
  { 1, 153, 154, 0, 0 }, // 166 V_SETALLONES_V_SETALLONESB_V_SETALLONESH_VBPERMQ_VGBBD_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPERM_VPERMR_VPERMXOR_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLDOI_VSLO_VSLV_VSR_VSRO_VSRV_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW_XXEXTRACTUW_XXINSERTW_VADDCUQ_VADDECUQ_VADDEUQM_VMUL10CUQ_VMUL10ECUQ_VMUL10EUQ_VMUL10UQ_VSUBCUQ_VSUBECUQ_VSUBEUQM_XSTSTDCQP_XSXSIGQP_BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDS_rec_BCDTRUNC_rec_BCDUS_rec_BCDUTRUNC_rec_BCDADD_rec_BCDSUB_rec
  { 1, 162, 163, 0, 0 }, // 167 VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VINSERTB_VINSERTD_VINSERTH_VINSERTW_MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VEXTRACTD_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VPRTYBQ_VADDUQM_VSUBUQM
  { 1, 161, 162, 0, 0 }, // 168 XSCMPEXPQP_XSCMPOQP_XSCMPUQP
  { 1, 153, 154, 0, 0 }, // 169 BCDSR_rec_XSADDQP_XSADDQPO_XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP_XSRQPI_XSRQPIX_XSRQPXP_XSSUBQP_XSSUBQPO
  { 1, 153, 154, 0, 0 }, // 170 BCDCTSQ_rec
  { 1, 153, 154, 0, 0 }, // 171 XSMADDQP_XSMADDQPO_XSMSUBQP_XSMSUBQPO_XSMULQP_XSMULQPO_XSNMADDQP_XSNMADDQPO_XSNMSUBQP_XSNMSUBQPO
  { 1, 153, 154, 0, 0 }, // 172 BCDCFSQ_rec
  { 1, 153, 154, 0, 0 }, // 173 XSDIVQP_XSDIVQPO
  { 1, 153, 154, 0, 0 }, // 174 XSSQRTQP_XSSQRTQPO
  { 1, 156, 157, 0, 0 }, // 175 LXVL_LXVLL
  { 1, 156, 157, 0, 0 }, // 176 LVEBX_LVEHX_LVEWX_LVX_LVXL
  { 1, 156, 157, 0, 0 }, // 177 LXSIBZX_LXSIHZX_LXSDX_LXVB16X_LXVD2X_LXVWSX_LXSIWZX_LXV_LXVX_LXSD
  { 0, 0, 0, 0, 0 }, // 178 DFLOADf64_XFLOADf64_LIWZX
  { 1, 156, 157, 0, 0 }, // 179 DCBF_DCBFEP_DCBST_DCBSTEP_DCBT_DCBTEP_DCBZ_DCBZEP_DCBZL_DCBZLEP_DCBTST_DCBTSTEP
  { 0, 0, 0, 0, 0 }, // 180 CP_COPY_CP_COPY8
  { 1, 165, 166, 0, 0 }, // 181 ICBI_ICBIEP
  { 1, 156, 157, 0, 0 }, // 182 ICBT_ICBTLS_LBZ_LBZ8_LBZCIX_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LDBRX_LDCIX_LHBRX_LHBRX8_LHZ_LHZ8_LHZCIX_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWBRX_LWBRX8_LWZ_LWZ8_LWZCIX_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32_EnforceIEIO_LSWI
  { 1, 166, 167, 0, 0 }, // 183 LBARX_LBARXL_LHARX_LHARXL_LWARX_LWARXL
  { 1, 156, 157, 0, 0 }, // 184 LD_LDX_LDXTLS_LDXTLS__DARN
  { 1, 166, 167, 0, 0 }, // 185 LDARX_LDARXL
  { 0, 0, 0, 0, 0 }, // 186 CP_ABORT
  { 1, 165, 166, 0, 0 }, // 187 ISYNC
  { 0, 0, 0, 0, 0 }, // 188 MSGSYNC
  { 1, 156, 157, 0, 0 }, // 189 TLBSYNC
  { 1, 150, 151, 0, 0 }, // 190 SYNC
  { 1, 168, 169, 0, 0 }, // 191 LMW
  { 1, 156, 157, 0, 0 }, // 192 LFIWZX_LFDX_LFD
  { 0, 0, 0, 0, 0 }, // 193 SLBIA
  { 0, 0, 0, 0, 0 }, // 194 SLBIE
  { 0, 0, 0, 0, 0 }, // 195 SLBMFEE
  { 0, 0, 0, 0, 0 }, // 196 SLBMFEV
  { 0, 0, 0, 0, 0 }, // 197 SLBMTE
  { 0, 0, 0, 0, 0 }, // 198 TLBIEL
  { 1, 156, 157, 0, 0 }, // 199 LHZU_LHZU8_LWZU_LWZU8
  { 1, 156, 157, 0, 0 }, // 200 LHZUX_LHZUX8_LWZUX_LWZUX8
  { 1, 176, 177, 0, 0 }, // 201 TEND
  { 1, 166, 167, 0, 0 }, // 202 STBCX_STHCX_STWCX
  { 1, 166, 167, 0, 0 }, // 203 STDCX
  { 1, 156, 157, 0, 0 }, // 204 LDMX
  { 1, 167, 168, 0, 0 }, // 205 LHA_LHA8_LHAX_LHAX8_LWAX_LWAX_32
  { 0, 0, 0, 0, 0 }, // 206 CP_PASTE8_rec_CP_PASTE_rec
  { 1, 167, 168, 0, 0 }, // 207 LWA_LWA_32
  { 1, 176, 177, 0, 0 }, // 208 TCHECK
  { 1, 156, 157, 0, 0 }, // 209 LFIWAX
  { 1, 156, 157, 0, 0 }, // 210 LXSIWAX
  { 0, 0, 0, 0, 0 }, // 211 LIWAX
  { 1, 156, 157, 0, 0 }, // 212 LFSX_LFS
  { 1, 156, 157, 0, 0 }, // 213 LXSSP_LXSSPX
  { 0, 0, 0, 0, 0 }, // 214 XFLOADf32_DFLOADf32
  { 1, 167, 168, 0, 0 }, // 215 LHAU_LHAU8
  { 1, 167, 168, 0, 0 }, // 216 LHAUX_LHAUX8_LWAUX
  { 1, 156, 157, 0, 0 }, // 217 LXVH8X_LXVDSX_LXVW4X
  { 1, 180, 181, 0, 0 }, // 218 STFD_STFDX_STFIWX_STFS_STFSX_STXSD_STXSDX_STXSIBX_STXSIBXv_STXSIHX_STXSIHXv_STXSIWX_STXSSP_STXSSPX
  { 1, 156, 157, 0, 0 }, // 219 STW_STW8_STDBRX_STHBRX_STWBRX_STB_STB8_STH_STH8_STBX_STBX8_STBXTLS_STBXTLS__STBXTLS_32_STHX_STHX8_STHXTLS_STHXTLS__STHXTLS_32_STWX_STWX8_STWXTLS_STWXTLS__STWXTLS_32
  { 0, 0, 0, 0, 0 }, // 220 DFSTOREf32_DFSTOREf64_XFSTOREf32_XFSTOREf64_STIWX
  { 1, 156, 157, 0, 0 }, // 221 STD_STDX_STDXTLS_STDXTLS_
  { 1, 156, 157, 0, 0 }, // 222 STBCIX_STDCIX_STHCIX_STWCIX_STSWI
  { 0, 0, 0, 0, 0 }, // 223 SLBIEG
  { 1, 168, 169, 0, 0 }, // 224 STMW
  { 0, 0, 0, 0, 0 }, // 225 TLBIE
  { 1, 156, 157, 0, 0 }, // 226 STVEBX_STVEHX_STVEWX_STVX_STVXL
  { 1, 180, 181, 0, 0 }, // 227 STXV_STXVB16X_STXVD2X_STXVH8X_STXVW4X_STXVX
  { 1, 156, 157, 0, 0 }, // 228 STXVL_STXVLL
  { 1, 176, 177, 0, 0 }, // 229 MTCTR_MTCTR8_MTCTR8loop_MTCTRloop_MTLR_MTLR8
  { 1, 151, 152, 0, 0 }, // 230 MFVRSAVE_MFVRSAVEv_MTVRSAVE_MTVRSAVEv
  { 0, 0, 0, 0, 0 }, // 231 MFPMR
  { 0, 0, 0, 0, 0 }, // 232 MTPMR
  { 1, 175, 176, 0, 0 }, // 233 MFTB_MFTB8
  { 1, 173, 174, 0, 0 }, // 234 MFCTR_MFCTR8_MFLR_MFLR8_MFSPR_MFSPR8
  { 1, 173, 174, 0, 0 }, // 235 MFMSR
  { 1, 156, 157, 0, 0 }, // 236 MTMSR
  { 0, 0, 0, 0, 0 }, // 237 MTMSRD
  { 1, 176, 177, 0, 0 }, // 238 MTSPR_MTSPR8
  { 1, 158, 159, 0, 0 }, // 239 DIVW_DIVWO_DIVWU_DIVWUO_MODSW
  { 1, 158, 159, 0, 0 }, // 240 DIVWE_DIVWEO_DIVWEU_DIVWEUO_MODSD_MODUD_MODUW
  { 1, 157, 158, 0, 0 }, // 241 DIVD_DIVDO_DIVDU_DIVDUO
  { 1, 157, 158, 0, 0 }, // 242 DIVDE_DIVDEO_DIVDEU_DIVDEUO
  { 1, 158, 159, 0, 0 }, // 243 DIVWO_rec_DIVWUO_rec_DIVWU_rec_DIVW_rec
  { 1, 157, 158, 0, 0 }, // 244 DIVD_rec_DIVDO_rec_DIVDU_rec_DIVDUO_rec
  { 1, 158, 159, 0, 0 }, // 245 DIVWE_rec_DIVWEO_rec_DIVWEU_rec_DIVWEUO_rec
  { 1, 157, 158, 0, 0 }, // 246 DIVDE_rec_DIVDEO_rec_DIVDEU_rec_DIVDEUO_rec
  { 1, 171, 172, 0, 0 }, // 247 MTCRF_MTCRF8
  { 1, 151, 152, 0, 0 }, // 248 ADDC8O_rec_ADDC8_rec_ADDCO_rec_ADDC_rec_SUBFC8O_rec_SUBFC8_rec_SUBFCO_rec_SUBFC_rec
  { 1, 159, 160, 0, 0 }, // 249 FABSD_rec_FABSS_rec_FNABSD_rec_FNABSS_rec_FCPSGND_rec_FCPSGNS_rec_FNEGD_rec_FNEGS_rec_FMR_rec
  { 1, 170, 171, 0, 0 }, // 250 MCRFS
  { 1, 174, 175, 0, 0 }, // 251 MTFSF_MTFSF_rec_MTFSFI_MTFSFI_rec_MTFSFIb
  { 1, 159, 160, 0, 0 }, // 252 MTFSFb
  { 1, 151, 152, 0, 0 }, // 253 RLDCL_rec_RLDCR_rec
  { 1, 151, 152, 0, 0 }, // 254 RLDICL_rec_RLDICR_rec_RLDICL_32_rec_RLDIMI_rec
  { 1, 178, 179, 0, 0 }, // 255 RLWIMI8_rec_RLWIMI_rec
  { 1, 151, 152, 0, 0 }, // 256 RLWINM8_rec_RLWINM_rec_RLWNM8_rec_RLWNM_rec_SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 1, 151, 152, 0, 0 }, // 257 SRAWI_rec_SRAW_rec
  { 1, 174, 175, 0, 0 }, // 258 MFFS_MFFSCE_MFFSL_MFFS_rec
  { 1, 172, 173, 0, 0 }, // 259 MFCR_MFCR8
  { 1, 151, 152, 0, 0 }, // 260 EXTSWSLI_32_64_rec_SRADI_rec_EXTSWSLI_rec_RLDIC_rec
  { 1, 151, 152, 0, 0 }, // 261 SRAD_rec_SLD_rec_SRD_rec
  { 1, 160, 161, 0, 0 }, // 262 FDIV
  { 1, 160, 161, 0, 0 }, // 263 FDIV_rec
  { 1, 164, 165, 0, 0 }, // 264 XSSQRTDP
  { 1, 164, 165, 0, 0 }, // 265 FSQRT
  { 1, 164, 165, 0, 0 }, // 266 XVSQRTDP
  { 1, 164, 165, 0, 0 }, // 267 XVSQRTSP
  { 1, 164, 165, 0, 0 }, // 268 FSQRT_rec
  { 1, 164, 165, 0, 0 }, // 269 XSSQRTSP
  { 1, 164, 165, 0, 0 }, // 270 FSQRTS
  { 1, 164, 165, 0, 0 }, // 271 FSQRTS_rec
  { 1, 160, 161, 0, 0 }, // 272 XSDIVDP
  { 1, 160, 161, 0, 0 }, // 273 FDIVS
  { 1, 160, 161, 0, 0 }, // 274 FDIVS_rec
  { 1, 160, 161, 0, 0 }, // 275 XSDIVSP
  { 1, 160, 161, 0, 0 }, // 276 XVDIVSP
  { 1, 160, 161, 0, 0 }, // 277 XVDIVDP
  { 1, 167, 168, 0, 0 }, // 278 LFSU
  { 1, 167, 168, 0, 0 }, // 279 LFSUX
  { 1, 180, 181, 0, 0 }, // 280 STFDU_STFDUX_STFSU_STFSUX
  { 1, 156, 157, 0, 0 }, // 281 STBU_STBU8_STDU_STHU_STHU8_STWU_STWU8
  { 1, 156, 157, 0, 0 }, // 282 STBUX_STBUX8_STDUX_STHUX_STHUX8_STWUX_STWUX8
  { 1, 156, 157, 0, 0 }, // 283 LBZU_LBZU8
  { 1, 156, 157, 0, 0 }, // 284 LBZUX_LBZUX8
  { 1, 156, 157, 0, 0 }, // 285 LDU
  { 1, 156, 157, 0, 0 }, // 286 LDUX
  { 1, 167, 168, 0, 0 }, // 287 LFDU
  { 1, 167, 168, 0, 0 }, // 288 LFDUX
  { 1, 153, 154, 0, 0 }, // 289 VPMSUMB_VPMSUMD_VPMSUMH_VPMSUMW_VCIPHER_VCIPHERLAST_VNCIPHER_VNCIPHERLAST_VSBOX
  { 1, 152, 153, 0, 0 }, // 290 BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_BCCTR_BCCTR8_BCCTR8n_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_BCCTRn_BDNZ_BDNZ8_BDNZA_BDNZAm_BDNZAp_BDNZm_BDNZp_BDZ_BDZ8_BDZA_BDZAm_BDZAp_BDZm_BDZp_BDNZL_BDNZLA_BDNZLAm_BDNZLAp_BDNZLR_BDNZLR8_BDNZLRL_BDNZLRLm_BDNZLRLp_BDNZLRm_BDNZLRp_BDNZLm_BDNZLp_BDZL_BDZLA_BDZLAm_BDZLAp_BDZLR_BDZLR8_BDZLRL_BDZLRLm_BDZLRLp_BDZLRm_BDZLRp_BDZLm_BDZLp_BL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM_BLR_BLR8_BLRL_TAILB_TAILB8_TAILBA_TAILBA8_TAILBCTR_TAILBCTR8_gBC_gBCA_gBCAat_gBCCTR_gBCCTRL_gBCL_gBCLA_gBCLAat_gBCLR_gBCLRL_gBCLat_gBCat_BCLR_BCLRL_BCLRLn_BCLRn_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_RM_BCTRL_RM_B_BA_BC_BCC_BCCA_BCL_BCLalways_BCLn_BCTRL8_LDinto_toc_BCTRL_LWZinto_toc_BCTRL8_LDinto_toc_RM_BCTRL_LWZinto_toc_RM_BCn_CTRL_DEP
  { 1, 152, 153, 0, 0 }, // 291 ADDPCIS
  { 1, 156, 157, 0, 0 }, // 292 LDAT_LWAT
  { 1, 156, 157, 0, 0 }, // 293 STDAT_STWAT
  { 1, 151, 152, 0, 0 }, // 294 BRINC
  { 1, 162, 163, 0, 0 }, // 295 EVABS_EVEQV_EVNAND_EVNEG_EVADDIW_EVADDW_EVAND_EVANDC_EVCMPEQ_EVCMPGTS_EVCMPGTU_EVCMPLTS_EVCMPLTU_EVCNTLSW_EVCNTLZW_EVEXTSB_EVEXTSH_EVMERGEHI_EVMERGEHILO_EVMERGELO_EVMERGELOHI_EVNOR_EVOR_EVORC_EVXOR_EVRLW_EVRLWI_EVRNDW_EVSLW_EVSLWI_EVSPLATFI_EVSPLATI_EVSRWIS_EVSRWIU_EVSRWS_EVSRWU_EVSUBFW_EVSUBIFW
  { 1, 163, 164, 0, 0 }, // 296 EVMRA_EVADDSMIAAW_EVADDSSIAAW_EVADDUMIAAW_EVADDUSIAAW_EVDIVWS_EVDIVWU_EVMHEGSMFAA_EVMHEGSMFAN_EVMHEGSMIAA_EVMHEGSMIAN_EVMHEGUMIAA_EVMHEGUMIAN_EVMHESMF_EVMHESMFA_EVMHESMFAAW_EVMHESMFANW_EVMHESMI_EVMHESMIA_EVMHESMIAAW_EVMHESMIANW_EVMHESSF_EVMHESSFA_EVMHESSFAAW_EVMHESSFANW_EVMHESSIAAW_EVMHESSIANW_EVMHEUMI_EVMHEUMIA_EVMHEUMIAAW_EVMHEUMIANW_EVMHEUSIAAW_EVMHEUSIANW_EVMHOGSMFAA_EVMHOGSMFAN_EVMHOGSMIAA_EVMHOGSMIAN_EVMHOGUMIAA_EVMHOGUMIAN_EVMHOSMF_EVMHOSMFA_EVMHOSMFAAW_EVMHOSMFANW_EVMHOSMI_EVMHOSMIA_EVMHOSMIAAW_EVMHOSMIANW_EVMHOSSF_EVMHOSSFA_EVMHOSSFAAW_EVMHOSSFANW_EVMHOSSIAAW_EVMHOSSIANW_EVMHOUMI_EVMHOUMIA_EVMHOUMIAAW_EVMHOUMIANW_EVMHOUSIAAW_EVMHOUSIANW_EVMWHSMF_EVMWHSMFA_EVMWHSMI_EVMWHSMIA_EVMWHSSF_EVMWHSSFA_EVMWHUMI_EVMWHUMIA_EVMWLSMIAAW_EVMWLSMIANW_EVMWLSSIAAW_EVMWLSSIANW_EVMWLUMI_EVMWLUMIA_EVMWLUMIAAW_EVMWLUMIANW_EVMWLUSIAAW_EVMWLUSIANW_EVMWSMF_EVMWSMFA_EVMWSMFAA_EVMWSMFAN_EVMWSMI_EVMWSMIA_EVMWSMIAA_EVMWSMIAN_EVMWSSF_EVMWSSFA_EVMWSSFAA_EVMWSSFAN_EVMWUMI_EVMWUMIA_EVMWUMIAA_EVMWUMIAN_EVSUBFSMIAAW_EVSUBFSSIAAW_EVSUBFUMIAAW_EVSUBFUSIAAW
  { 1, 156, 157, 0, 0 }, // 297 EVLDD_EVLDDX_EVLDH_EVLDHX_EVLDW_EVLDWX_EVLHHESPLAT_EVLHHESPLATX_EVLHHOSSPLAT_EVLHHOSSPLATX_EVLHHOUSPLAT_EVLHHOUSPLATX_EVLWHE_EVLWHEX_EVLWHOS_EVLWHOSX_EVLWHOU_EVLWHOUX_EVLWHSPLAT_EVLWHSPLATX_EVLWWSPLAT_EVLWWSPLATX
  { 1, 156, 157, 0, 0 }, // 298 EVSTDD_EVSTDDX_EVSTDH_EVSTDHX_EVSTDW_EVSTDWX_EVSTWHE_EVSTWHEX_EVSTWHO_EVSTWHOX_EVSTWWE_EVSTWWEX_EVSTWWO_EVSTWWOX
  { 1, 152, 153, 0, 0 }, // 299 HRFID_ATTN_CLRBHRB_MFBHRBE_NAP_RFCI_RFDI_RFMCI_SC
  { 0, 0, 0, 0, 0 }, // 300 RFI
  { 1, 179, 180, 0, 0 }, // 301 RFID
  { 1, 156, 157, 0, 0 }, // 302 DSS_DSSALL_DST_DST64_DSTST_DSTST64_DSTSTT_DSTSTT64_DSTT_DSTT64_ICBLQ_LBEPX_LHEPX_LWEPX_TLBIVAX_TLBLD_TLBLI_TLBRE_TLBRE2_TLBSX_TLBSX2_TLBSX2D_TLBWE_TLBWE2_MBAR_TRAP_DCCCI_ICCCI
  { 1, 156, 157, 0, 0 }, // 303 ICBLC_STBEPX_STHEPX_STWEPX
  { 1, 156, 157, 0, 0 }, // 304 LFDEPX
  { 1, 180, 181, 0, 0 }, // 305 STFDEPX
  { 1, 156, 157, 0, 0 }, // 306 MFSR_MFSRIN
  { 1, 156, 157, 0, 0 }, // 307 MTSR_MTSRIN
  { 1, 173, 174, 0, 0 }, // 308 MFDCR
  { 1, 176, 177, 0, 0 }, // 309 MTDCR
  { 1, 151, 152, 0, 0 }, // 310 NOP_GT_PWR6_NOP_GT_PWR7
  { 0, 0, 0, 0, 0 }, // 311 TLBIA
  { 1, 156, 157, 0, 0 }, // 312 WRTEE_WRTEEI
  { 1, 151, 152, 0, 0 }, // 313 HASHCHK_HASHCHK8_HASHCHKP_HASHCHKP8_HASHST_HASHST8_HASHSTP_HASHSTP8_ADDEX_ADDEX8
  { 1, 150, 151, 0, 0 }, // 314 MSYNC
  { 0, 0, 0, 0, 0 }, // 315 SLBSYNC
  { 0, 0, 0, 0, 0 }, // 316 SLBFEE_rec
  { 0, 0, 0, 0, 0 }, // 317 STOP
  { 1, 156, 157, 0, 0 }, // 318 DCBA_DCBI
  { 1, 159, 160, 0, 0 }, // 319 FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRE_FRES_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRSP_FRSQRTE_FRSQRTES
  { 1, 153, 154, 0, 0 }, // 320 VCFSX_VCFSX_0_VCFUX_VCFUX_0_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VLOGEFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP
  { 1, 153, 154, 0, 0 }, // 321 XSCVDPHP_XSCVDPSP_XSCVDPSPN_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPSXWSs_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPUXWSs_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSP_XSRSQRTEDP_XSRSQRTESP
  { 1, 153, 154, 0, 0 }, // 322 XVCVSPBF16
  { 1, 159, 160, 0, 0 }, // 323 FADDS_FMULS_FSUBS
  { 1, 159, 160, 0, 0 }, // 324 FMUL
  { 1, 153, 154, 0, 0 }, // 325 VADDFP_XVADDDP_XVADDSP_XVMULDP_XVMULSP_XVSUBDP_XVSUBSP
  { 1, 162, 163, 0, 0 }, // 326 VSUBFP
  { 1, 153, 154, 0, 0 }, // 327 XSADDDP_XSADDSP_XSSUBDP_XSSUBSP
  { 1, 153, 154, 0, 0 }, // 328 XSMULDP_XSMULSP
  { 1, 153, 154, 0, 0 }, // 329 VMADDFP_VNMSUBFP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP
  { 1, 153, 154, 0, 0 }, // 330 VEXPTEFP
  { 1, 159, 160, 0, 0 }, // 331 FADDS_rec_FMULS_rec_FSUBS_rec
  { 1, 159, 160, 0, 0 }, // 332 FMUL_rec
  { 1, 159, 160, 0, 0 }, // 333 FCFID_rec_FCFIDS_rec_FCFIDU_rec_FCFIDUS_rec_FCTID_rec_FCTIDU_rec_FCTIDUZ_rec_FCTIDZ_rec_FCTIW_rec_FCTIWU_rec_FCTIWUZ_rec_FCTIWZ_rec_FRE_rec_FRES_rec_FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRSP_rec_FRSQRTE_rec_FRSQRTES_rec
  { 1, 152, 153, 0, 0 }, // 334 BCLR_BCLRn_BDNZLR_BDNZLR8_BDNZLRm_BDNZLRp_BDZLR_BDZLR8_BDZLRm_BDZLRp_gBCLR_BCLRL_BCLRLn_BDNZLRL_BDNZLRLm_BDNZLRLp_BDZLRL_BDZLRLm_BDZLRLp_gBCLRL_BL_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLR_BLR8_BLRL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS
  { 1, 152, 153, 0, 0 }, // 335 BL8_NOTOC_BL8_NOTOC_RM_BL8_NOTOC_TLS
  { 1, 152, 153, 0, 0 }, // 336 B_BCC_BCCA_BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_CTRL_DEP_TAILB_TAILB8_BA_TAILBA_TAILBA8_BC_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_LDinto_toc_BCTRL8_LDinto_toc_RM_BCTRL8_RM_BCTRL_LWZinto_toc_BCTRL_LWZinto_toc_RM_BCTRL_RM_BCn_BDNZ_BDNZ8_BDNZm_BDNZp_BDZ_BDZ8_BDZm_BDZp_TAILBCTR_TAILBCTR8_gBC_gBCat_BCL_BCLalways_BCLn_BDNZL_BDNZLm_BDNZLp_BDZL_BDZLm_BDZLp_gBCL_gBCLat_BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM
  { 1, 152, 153, 0, 0 }, // 337 BCCTR_BCCTR8_BCCTR8n_BCCTRn_gBCCTR_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_gBCCTRL
  { 1, 153, 154, 0, 0 }, // 338 VSBOX
  { 1, 151, 152, 0, 0 }, // 339 CFUGED_CNTLZDM_CNTTZDM_PDEPD_PEXTD
  { 1, 162, 163, 0, 0 }, // 340 VCFUGED_VCLZDM_VCTZDM_VGNB_VPDEPD_VPEXTD
  { 1, 153, 154, 0, 0 }, // 341 XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP
  { 1, 153, 154, 0, 0 }, // 342 XSCVQPSQZ_XSCVQPUQZ_XSCVSQQP_XSCVUQQP
  { 1, 153, 154, 0, 0 }, // 343 XSADDQP_XSADDQPO_XSSUBQP_XSSUBQPO
  { 1, 151, 152, 0, 0 }, // 344 HASHST_HASHST8_HASHSTP_HASHSTP8
  { 1, 153, 154, 0, 0 }, // 345 XSMULQP_XSMULQPO
  { 1, 162, 163, 0, 0 }, // 346 VDIVESQ_VDIVEUQ_VDIVSQ_VDIVUQ
  { 1, 162, 163, 0, 0 }, // 347 VMODSQ_VMODUQ
  { 1, 158, 159, 0, 0 }, // 348 DIVWE_DIVWEO_DIVWEU_DIVWEUO
  { 1, 162, 163, 0, 0 }, // 349 VDIVSD_VDIVUD
  { 1, 162, 163, 0, 0 }, // 350 VMODSD_VMODUD
  { 1, 162, 163, 0, 0 }, // 351 VDIVSW_VDIVUW
  { 1, 162, 163, 0, 0 }, // 352 VMODSW_VMODUW
  { 1, 162, 163, 0, 0 }, // 353 VDIVESD_VDIVEUD
  { 1, 162, 163, 0, 0 }, // 354 VDIVESW_VDIVEUW
  { 1, 153, 154, 0, 0 }, // 355 BCDCTN_rec_VMUL10CUQ_VMUL10UQ_XSXSIGQP
  { 1, 153, 154, 0, 0 }, // 356 BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDUS_rec_BCDUTRUNC_rec_VADDCUQ_VMUL10ECUQ_VMUL10EUQ_VSUBCUQ_XSTSTDCQP
  { 1, 162, 163, 0, 0 }, // 357 VADDUQM_VSUBUQM
  { 1, 153, 154, 0, 0 }, // 358 XSMAXCQP_XSMINCQP
  { 1, 162, 163, 0, 0 }, // 359 XXGENPCVBM
  { 1, 153, 154, 0, 0 }, // 360 BCDADD_rec_BCDS_rec_BCDSUB_rec_BCDTRUNC_rec_VADDECUQ_VADDEUQM_VSUBECUQ_VSUBEUQM
  { 1, 156, 157, 0, 0 }, // 361 TRAP
  { 1, 181, 182, 0, 0 }, // 362 TW
  { 1, 151, 152, 0, 0 }, // 363 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW
  { 1, 161, 162, 0, 0 }, // 364 FTSQRT
  { 1, 162, 163, 0, 0 }, // 365 MTVSRBM_MTVSRBMI_MTVSRDM_MTVSRHM_MTVSRQM_MTVSRWM_VEXPANDBM_VEXPANDDM_VEXPANDHM_VEXPANDQM_VEXPANDWM_VEXTRACTBM_VEXTRACTDM_VEXTRACTHM_VEXTRACTQM_VEXTRACTWM_XVTLSBB
  { 1, 151, 152, 0, 0 }, // 366 POPCNTB_POPCNTB8
  { 1, 162, 163, 0, 0 }, // 367 VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTD_VPOPCNTW_VPRTYBD_VPRTYBW
  { 1, 162, 163, 0, 0 }, // 368 VPOPCNTB_VPOPCNTH
  { 1, 153, 154, 0, 0 }, // 369 XSCVSPDPN
  { 1, 161, 162, 0, 0 }, // 370 XSTSQRTDP
  { 1, 153, 154, 0, 0 }, // 371 XVCVHPSP
  { 1, 161, 162, 0, 0 }, // 372 XVTSQRTDP_XVTSQRTSP
  { 1, 154, 155, 0, 0 }, // 373 CMPEQB
  { 1, 151, 152, 0, 0 }, // 374 EXTSWSLI_32_64_rec_EXTSWSLI_rec
  { 1, 151, 152, 0, 0 }, // 375 SLD_rec_SRD_rec
  { 1, 151, 152, 0, 0 }, // 376 SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 1, 153, 154, 0, 0 }, // 377 VADDCUW_VADDSBS_VADDSHS_VADDSWS_VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VMAXFP_VMINFP_VSUBCUW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP
  { 1, 182, 183, 0, 0 }, // 378 VCMPBFP_VCMPBFP_rec_VCMPEQFP_VCMPEQFP_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPGTSB_rec_VCMPGTSD_rec_VCMPGTSH_rec_VCMPGTSW_rec_VCMPGTUB_rec_VCMPGTUD_rec_VCMPGTUH_rec_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 1, 182, 183, 0, 0 }, // 379 VCMPEQUQ_VCMPEQUQ_rec_VCMPGTSQ_VCMPGTSQ_rec_VCMPGTUQ_VCMPGTUQ_rec
  { 1, 162, 163, 0, 0 }, // 380 VCMPSQ_VCMPUQ_VCNTMBB_VCNTMBD_VCNTMBH_VCNTMBW
  { 1, 153, 154, 0, 0 }, // 381 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP
  { 1, 151, 152, 0, 0 }, // 382 RLDIC_rec
  { 1, 151, 152, 0, 0 }, // 383 RLDICL_32_rec_RLDICL_rec_RLDICR_rec
  { 1, 153, 154, 0, 0 }, // 384 VSHASIGMAD_VSHASIGMAW
  { 1, 153, 154, 0, 0 }, // 385 VRLQ_VRLQNM_VSLQ_VSRAQ_VSRQ
  { 1, 153, 154, 0, 0 }, // 386 VRLQMI
  { 1, 155, 156, 0, 0 }, // 387 CR6SET_CREQV_CRSET
  { 1, 156, 157, 0, 0 }, // 388 DSS_DSSALL
  { 1, 173, 174, 0, 0 }, // 389 MFCTR_MFCTR8_MFLR_MFLR8
  { 1, 151, 152, 0, 0 }, // 390 NOP_ORI_ORI8
  { 1, 153, 154, 0, 0 }, // 391 VXOR_V_SET0_V_SET0B_V_SET0H
  { 1, 162, 163, 0, 0 }, // 392 XXLEQV_XXLEQVOnes_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 1, 151, 152, 0, 0 }, // 393 ADDI_ADDI8_LI_LI8_ADDIS_ADDIS8_LIS_LIS8_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_NEG_NEG8_NEG8_rec_NEG_rec_NEG8O_NEGO
  { 0, 0, 0, 0, 0 }, // 394 ADDIdtprelL32_ADDItlsldLADDR32_ADDISdtprelHA32
  { 0, 0, 0, 0, 0 }, // 395 ADDItocL_ADDIStocHA_ADDIStocHA8
  { 1, 151, 152, 0, 0 }, // 396 ADDME_ADDME8_ADDME8O_ADDMEO_ADDZE_ADDZE8_ADDZE8O_ADDZEO_SUBFME_SUBFME8_SUBFME8O_SUBFMEO_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZEO
  { 1, 159, 160, 0, 0 }, // 397 FABSD_FABSS_FMR_FNABSD_FNABSS_FNEGD_FNEGS
  { 1, 151, 152, 0, 0 }, // 398 SETB_SETB8
  { 1, 154, 155, 0, 0 }, // 399 SETBC_SETBC8_SETBCR_SETBCR8_SETNBC_SETNBC8_SETNBCR_SETNBCR8
  { 1, 162, 163, 0, 0 }, // 400 VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VNEGD_VNEGW
  { 1, 162, 163, 0, 0 }, // 401 VEXTSD2Q
  { 1, 153, 154, 0, 0 }, // 402 XSABSDP_XSNABSDP_XSNEGDP_XSXEXPDP
  { 1, 153, 154, 0, 0 }, // 403 XSABSQP_XSNABSQP_XSNEGQP_XSXEXPQP_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVNEGDP_XVNEGSP_XVXEXPDP_XVXEXPSP
  { 1, 153, 154, 0, 0 }, // 404 XVXSIGDP_XVXSIGSP
  { 1, 151, 152, 0, 0 }, // 405 ADD4_ADD4TLS_ADD8_ADD8TLS_ADD8TLS__ADD4_rec_ADD8_rec_ADD4O_ADD8O_AND_AND8_AND8_rec_AND_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_EQV_EQV8_EQV8_rec_EQV_rec_NAND_NAND8_NAND8_rec_NAND_rec_NOR_NOR8_NOR8_rec_NOR_rec_OR_OR8_OR8_rec_OR_rec_ORC_ORC8_ORC8_rec_ORC_rec_ORIS_ORIS8_XOR_XOR8_XOR8_rec_XOR_rec_XORI_XORI8_XORIS_XORIS8
  { 1, 151, 152, 0, 0 }, // 406 ADDE_ADDE8_ADDE8O_ADDEO_ADDIC_ADDIC8_ANDI8_rec_ANDI_rec_ANDIS8_rec_ANDIS_rec_SUBF_SUBF8_SUBF8_rec_SUBF_rec_SUBFE_SUBFE8_SUBFE8O_SUBFEO_SUBFIC_SUBFIC8_SUBF8O_SUBFO
  { 1, 151, 152, 0, 0 }, // 407 CMPB_CMPB8
  { 1, 151, 152, 0, 0 }, // 408 EXTSWSLI_EXTSWSLI_32_64_SRADI_SRADI_32
  { 1, 151, 152, 0, 0 }, // 409 SLW_SLW8_SRW_SRW8
  { 1, 162, 163, 0, 0 }, // 410 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEQV_VNAND_VORC_VSLD_VSRAD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_XXLAND_XXLANDC_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC
  { 1, 153, 154, 0, 0 }, // 411 VAND_VANDC_VMRGEW_VMRGOW_VNOR_VOR_VRLB_VRLD_VRLDNM_VRLH_VRLW_VRLWNM_VSLB_VSLH_VSLW_VSRAB_VSRAH_VSRAW_VSRB_VSRH_VSRW_XSCPSGNQP_XSIEXPQP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP
  { 1, 153, 154, 0, 0 }, // 412 VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW
  { 1, 151, 152, 0, 0 }, // 413 ADDEX_ADDEX8
  { 1, 156, 157, 0, 0 }, // 414 DST_DST64_DSTT_DSTT64_DSTST_DSTST64_DSTSTT_DSTSTT64
  { 1, 151, 152, 0, 0 }, // 415 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32
  { 1, 174, 175, 0, 0 }, // 416 MFFS_MFFS_rec_MFFSL
  { 1, 176, 177, 0, 0 }, // 417 TRECHKPT
  { 1, 151, 152, 0, 0 }, // 418 ADDME8_rec_ADDME_rec_ADDME8O_rec_ADDMEO_rec_ADDZE8_rec_ADDZE_rec_ADDZE8O_rec_ADDZEO_rec_SUBFME8_rec_SUBFME_rec_SUBFME8O_rec_SUBFMEO_rec_SUBFZE8_rec_SUBFZE_rec_SUBFZE8O_rec_SUBFZEO_rec
  { 1, 159, 160, 0, 0 }, // 419 MTFSB0
  { 1, 151, 152, 0, 0 }, // 420 NEG8O_rec_NEGO_rec
  { 1, 151, 152, 0, 0 }, // 421 ADDE8_rec_ADDE_rec_ADDE8O_rec_ADDEO_rec_ADDIC_rec_SUBFE8_rec_SUBFE_rec_SUBFE8O_rec_SUBFEO_rec_SUBF8O_rec_SUBFO_rec
  { 1, 152, 153, 0, 0 }, // 422 HRFID
  { 1, 159, 160, 0, 0 }, // 423 FABSD_rec_FABSS_rec_FMR_rec_FNABSD_rec_FNABSS_rec_FNEGD_rec_FNEGS_rec
  { 1, 152, 153, 0, 0 }, // 424 SC
  { 1, 151, 152, 0, 0 }, // 425 ADDC_ADDC8_ADDC8O_ADDCO_SUBFC_SUBFC8_SUBFC8O_SUBFCO
  { 1, 151, 152, 0, 0 }, // 426 ADDC8_rec_ADDC_rec_SUBFC8_rec_SUBFC_rec
  { 1, 174, 175, 0, 0 }, // 427 MTFSF_MTFSFI_MTFSFIb
  { 1, 174, 175, 0, 0 }, // 428 MTFSFI_rec
  { 1, 162, 163, 0, 0 }, // 429 VSTRIBL_rec_VSTRIBR_rec_VSTRIHL_rec_VSTRIHR_rec
  { 1, 156, 157, 0, 0 }, // 430 LBZ_LBZ8_LDBRX_LHBRX_LHBRX8_LHZ_LHZ8_LWBRX_LWBRX8_LWZ_LWZ8
  { 1, 156, 157, 0, 0 }, // 431 LD
  { 0, 0, 0, 0, 0 }, // 432 LDtoc_LDtocBA_LDtocCPT_LDtocJTI_LDtocL_SPILLTOVSR_LD_LWZtoc_LWZtocL
  { 1, 156, 157, 0, 0 }, // 433 LXVRBX_LXVRDX_LXVRHX_LXVRWX
  { 1, 156, 157, 0, 0 }, // 434 DCBT_DCBTST
  { 1, 156, 157, 0, 0 }, // 435 ICBT_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32
  { 1, 156, 157, 0, 0 }, // 436 LDX_LDXTLS_LDXTLS_
  { 0, 0, 0, 0, 0 }, // 437 SPILLTOVSR_LDX
  { 1, 156, 157, 0, 0 }, // 438 LBZCIX_LDCIX_LHZCIX_LWZCIX
  { 1, 156, 157, 0, 0 }, // 439 MTSR
  { 1, 151, 152, 0, 0 }, // 440 MTVRSAVE_MTVRSAVEv
  { 1, 156, 157, 0, 0 }, // 441 LSWI
  { 1, 156, 157, 0, 0 }, // 442 PLBZ_PLBZ8_PLBZ8pc_PLBZpc_PLD_PLDpc_PLFD_PLFDpc_PLFS_PLFSpc_PLHA_PLHA8_PLHA8pc_PLHApc_PLHZ_PLHZ8_PLHZ8pc_PLHZpc_PLWA_PLWA8_PLWA8pc_PLWApc_PLWZ_PLWZ8_PLWZ8pc_PLWZpc_PLXSD_PLXSDpc_PLXSSP_PLXSSPpc_PLXV_PLXVpc_PLXVP_PLXVPpc
  { 1, 156, 157, 0, 0 }, // 443 LXVP_LXVPX
  { 1, 156, 157, 0, 0 }, // 444 MFSR
  { 1, 175, 176, 0, 0 }, // 445 MFTB8
  { 1, 162, 163, 0, 0 }, // 446 XXSETACCZ
  { 1, 153, 154, 0, 0 }, // 447 XVBF16GER2_XVF16GER2_XVF32GER_XVF64GER_XVI16GER2_XVI16GER2S_XVI4GER8_XVI8GER4
  { 1, 153, 154, 0, 0 }, // 448 XVBF16GER2NN_XVBF16GER2NP_XVBF16GER2PN_XVBF16GER2PP_XVF16GER2NN_XVF16GER2NP_XVF16GER2PN_XVF16GER2PP_XVF32GERNN_XVF32GERNP_XVF32GERPN_XVF32GERPP_XVF64GERNN_XVF64GERNP_XVF64GERPN_XVF64GERPP_XVI16GER2PP_XVI16GER2SPP_XVI4GER8PP_XVI8GER4PP
  { 1, 162, 163, 0, 0 }, // 449 XVI8GER4SPP
  { 1, 153, 154, 0, 0 }, // 450 PMXVF32GER_PMXVF64GER
  { 1, 153, 154, 0, 0 }, // 451 PMXVBF16GER2_PMXVF16GER2_PMXVF32GERNN_PMXVF32GERNP_PMXVF32GERPN_PMXVF32GERPP_PMXVF64GERNN_PMXVF64GERNP_PMXVF64GERPN_PMXVF64GERPP_PMXVI16GER2_PMXVI16GER2S_PMXVI4GER8_PMXVI8GER4
  { 1, 153, 154, 0, 0 }, // 452 PMXVBF16GER2NN_PMXVBF16GER2NP_PMXVBF16GER2PN_PMXVBF16GER2PP_PMXVF16GER2NN_PMXVF16GER2NP_PMXVF16GER2PN_PMXVF16GER2PP_PMXVI16GER2PP_PMXVI16GER2SPP_PMXVI4GER8PP_PMXVI8GER4PP
  { 1, 162, 163, 0, 0 }, // 453 PMXVI8GER4SPP
  { 1, 162, 163, 0, 0 }, // 454 XXMTACC
  { 1, 162, 163, 0, 0 }, // 455 XXMFACC
  { 1, 169, 170, 0, 0 }, // 456 MULLD_MULLDO
  { 1, 162, 163, 0, 0 }, // 457 VMULHSD_VMULHUD_VMULLD
  { 1, 183, 184, 0, 0 }, // 458 VSPLTISW
  { 1, 153, 154, 0, 0 }, // 459 V_SETALLONES_V_SETALLONESB_V_SETALLONESH
  { 1, 162, 163, 0, 0 }, // 460 MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VPRTYBQ
  { 1, 153, 154, 0, 0 }, // 461 VGBBD_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW
  { 1, 183, 184, 0, 0 }, // 462 VSPLTISB_VSPLTISH_XXSPLTIB
  { 1, 162, 163, 0, 0 }, // 463 VSTRIBL_VSTRIBR_VSTRIHL_VSTRIHR
  { 1, 153, 154, 0, 0 }, // 464 XVCVBF16SPN
  { 1, 153, 154, 0, 0 }, // 465 VBPERMQ_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLO_VSLV_VSR_VSRO_VSRV_XXEXTRACTUW
  { 1, 162, 163, 0, 0 }, // 466 VCLRLB_VCLRRB_XXGENPCVDM_XXGENPCVHM_XXGENPCVWM
  { 1, 162, 163, 0, 0 }, // 467 VEXTRACTD_VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VINSERTD_VINSERTW
  { 1, 162, 163, 0, 0 }, // 468 VEXTDDVLX_VEXTDDVRX_VEXTDUBVLX_VEXTDUBVRX_VEXTDUHVLX_VEXTDUHVRX_VEXTDUWVLX_VEXTDUWVRX_VINSBLX_VINSBRX_VINSBVLX_VINSBVRX_VINSD_VINSDLX_VINSDRX_VINSHLX_VINSHRX_VINSHVLX_VINSHVRX_VINSW_VINSWLX_VINSWRX_VINSWVLX_VINSWVRX_VSLDBI_VSRDBI
  { 1, 153, 154, 0, 0 }, // 469 VSUMSWS
  { 1, 162, 163, 0, 0 }, // 470 XXSPLTIDP_XXSPLTIW
  { 1, 162, 163, 0, 0 }, // 471 XXBLENDVB_XXBLENDVD_XXBLENDVH_XXBLENDVW_XXSPLTI32DX
  { 1, 162, 163, 0, 0 }, // 472 XXEVAL
  { 1, 183, 184, 0, 0 }, // 473 XXPERMX
  { 1, 156, 157, 0, 0 }, // 474 DCBST_DCBZ
  { 1, 165, 166, 0, 0 }, // 475 ICBI
  { 1, 156, 157, 0, 0 }, // 476 DCBF
  { 1, 156, 157, 0, 0 }, // 477 PSTXVP_PSTXVPpc
  { 1, 156, 157, 0, 0 }, // 478 STB_STB8_STDBRX_STH_STH8_STHBRX_STW_STW8_STWBRX
  { 0, 0, 0, 0, 0 }, // 479 SPILLTOVSR_ST
  { 1, 156, 157, 0, 0 }, // 480 STD
  { 0, 0, 0, 0, 0 }, // 481 DFSTOREf32_DFSTOREf64_STIWX
  { 1, 180, 181, 0, 0 }, // 482 STXVRBX_STXVRDX_STXVRHX_STXVRWX
  { 0, 0, 0, 0, 0 }, // 483 SPILLTOVSR_STX
  { 1, 156, 157, 0, 0 }, // 484 EnforceIEIO
  { 1, 156, 157, 0, 0 }, // 485 STBCIX_STDCIX_STHCIX_STWCIX
  { 1, 156, 157, 0, 0 }, // 486 PSTB_PSTB8_PSTB8pc_PSTBpc_PSTD_PSTDpc_PSTFD_PSTFDpc_PSTFS_PSTFSpc_PSTH_PSTH8_PSTH8pc_PSTHpc_PSTW_PSTW8_PSTW8pc_PSTWpc_PSTXSD_PSTXSDpc_PSTXSSP_PSTXSSPpc_PSTXV_PSTXVpc
  { 1, 156, 157, 0, 0 }, // 487 STXVP_STXVPX
  { 1, 152, 153, 0, 0 }, // 488 ATTN_NAP
  { 1, 156, 157, 0, 0 }, // 489 DCBZL
  { 1, 156, 157, 0, 0 }, // 490 DCCCI_ICBLQ_ICCCI_TLBLD_TLBLI_TLBRE2_TLBSX2_TLBSX2D_TLBWE2
  { 1, 156, 157, 0, 0 }, // 491 ICBLC
  { 1, 152, 153, 0, 0 }, // 492 CLRBHRB
  { 1, 152, 153, 0, 0 }, // 493 MFBHRBE
  { 1, 156, 157, 0, 0 }, // 494 PADDI_PADDI8_PADDI8pc_PADDIpc
  { 1, 151, 152, 0, 0 }, // 495 PLI_PLI8
  { 1, 153, 154, 0, 0 }, // 496 VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS
  { 1, 162, 163, 0, 0 }, // 497 VMULESD_VMULEUD_VMULHSW_VMULHUW_VMULOSD_VMULOUD
  { 1, 162, 163, 0, 0 }, // 498 VMSUMCUD
  { 0, uint16_t(~0U), uint16_t(~0U), uint16_t(~0U), uint16_t(~0U) }// end marker
};

static const llvm::InstrItinerary PPCA2Itineraries[] = {
  { 0, 0, 0, 0, 0 }, // 0 NoInstrModel
  { 1, 184, 185, 768, 769 }, // 1 IIC_LdStSync
  { 1, 184, 185, 769, 772 }, // 2 IIC_IntSimple
  { 1, 184, 185, 772, 775 }, // 3 IIC_IntGeneral
  { 1, 184, 185, 775, 778 }, // 4 IIC_BrB
  { 0, 0, 0, 0, 0 }, // 5 IIC_VecFP
  { 1, 184, 185, 778, 781 }, // 6 IIC_IntCompare
  { 0, 0, 0, 0, 0 }, // 7 IIC_SprABORT
  { 0, 0, 0, 0, 0 }, // 8 IIC_LdStCOPY
  { 0, 0, 0, 0, 0 }, // 9 IIC_LdStPASTE
  { 1, 184, 185, 781, 784 }, // 10 IIC_BrCR
  { 0, 0, 0, 0, 0 }, // 11 IIC_LdStLD
  { 1, 184, 185, 784, 787 }, // 12 IIC_LdStDCBF
  { 1, 184, 185, 787, 790 }, // 13 IIC_LdStLoad
  { 1, 184, 185, 790, 793 }, // 14 IIC_IntDivD
  { 1, 184, 185, 793, 796 }, // 15 IIC_IntDivW
  { 0, 0, 0, 0, 0 }, // 16 IIC_FPDGeneral
  { 1, 185, 186, 796, 799 }, // 17 IIC_FPAddSub
  { 1, 185, 186, 799, 802 }, // 18 IIC_FPDivD
  { 0, 0, 0, 0, 0 }, // 19 IIC_FPSGeneral
  { 1, 185, 186, 802, 805 }, // 20 IIC_FPCompare
  { 1, 185, 186, 805, 808 }, // 21 IIC_FPGeneral
  { 0, 0, 0, 0, 0 }, // 22 IIC_VecGeneral
  { 0, 0, 0, 0, 0 }, // 23 IIC_VecComplex
  { 1, 184, 185, 808, 811 }, // 24 IIC_LdStStore
  { 1, 184, 185, 811, 814 }, // 25 IIC_IntRotateDI
  { 1, 185, 186, 814, 817 }, // 26 IIC_FPDivS
  { 1, 185, 186, 817, 821 }, // 27 IIC_FPFused
  { 1, 185, 186, 821, 824 }, // 28 IIC_FPSqrtD
  { 1, 185, 186, 824, 827 }, // 29 IIC_FPSqrtS
  { 1, 184, 185, 827, 830 }, // 30 IIC_LdStICBI
  { 1, 184, 185, 830, 834 }, // 31 IIC_IntISEL
  { 1, 184, 185, 834, 835 }, // 32 IIC_SprISYNC
  { 1, 184, 185, 835, 838 }, // 33 IIC_LdStLWARX
  { 1, 184, 185, 838, 842 }, // 34 IIC_LdStLoadUpd
  { 1, 184, 185, 842, 846 }, // 35 IIC_LdStLoadUpdX
  { 0, 0, 0, 0, 0 }, // 36 IIC_LdStLDARX
  { 1, 184, 185, 846, 849 }, // 37 IIC_LdStLDU
  { 1, 184, 185, 849, 852 }, // 38 IIC_LdStLDUX
  { 1, 184, 185, 852, 855 }, // 39 IIC_LdStLFD
  { 1, 184, 185, 855, 859 }, // 40 IIC_LdStLFDU
  { 1, 184, 185, 859, 863 }, // 41 IIC_LdStLFDUX
  { 1, 184, 185, 863, 866 }, // 42 IIC_LdStLHA
  { 1, 184, 185, 866, 870 }, // 43 IIC_LdStLHAU
  { 1, 184, 185, 870, 874 }, // 44 IIC_LdStLHAUX
  { 0, 0, 0, 0, 0 }, // 45 IIC_LdStLMW
  { 0, 0, 0, 0, 0 }, // 46 IIC_LdStLQ
  { 0, 0, 0, 0, 0 }, // 47 IIC_LdStLQARX
  { 0, 0, 0, 0, 0 }, // 48 IIC_LdStLWA
  { 0, 0, 0, 0, 0 }, // 49 IIC_IntMulHD
  { 1, 184, 185, 874, 877 }, // 50 IIC_BrMCR
  { 1, 184, 185, 877, 880 }, // 51 IIC_BrMCRX
  { 1, 184, 185, 880, 882 }, // 52 IIC_SprMFCR
  { 1, 184, 185, 882, 884 }, // 53 IIC_SprMFSPR
  { 0, 0, 0, 0, 0 }, // 54 IIC_IntMFFS
  { 1, 184, 185, 884, 886 }, // 55 IIC_SprMFMSR
  { 1, 184, 185, 886, 888 }, // 56 IIC_SprMFCRF
  { 0, 0, 0, 0, 0 }, // 57 IIC_SprMFPMR
  { 0, 0, 0, 0, 0 }, // 58 IIC_SprMFSR
  { 1, 184, 185, 888, 890 }, // 59 IIC_SprMFTB
  { 0, 0, 0, 0, 0 }, // 60 IIC_SprMSGSYNC
  { 1, 184, 185, 890, 892 }, // 61 IIC_SprMTSPR
  { 0, 0, 0, 0, 0 }, // 62 IIC_IntMTFSB0
  { 1, 184, 185, 892, 894 }, // 63 IIC_SprMTMSR
  { 0, 0, 0, 0, 0 }, // 64 IIC_SprMTMSRD
  { 0, 0, 0, 0, 0 }, // 65 IIC_SprMTPMR
  { 0, 0, 0, 0, 0 }, // 66 IIC_SprMTSR
  { 1, 184, 185, 894, 897 }, // 67 IIC_IntMulHW
  { 1, 184, 185, 897, 900 }, // 68 IIC_IntMulHWU
  { 1, 184, 185, 900, 903 }, // 69 IIC_IntMulLI
  { 1, 184, 185, 903, 904 }, // 70 IIC_SprRFI
  { 0, 0, 0, 0, 0 }, // 71 IIC_IntRFID
  { 1, 184, 185, 904, 907 }, // 72 IIC_IntRotateD
  { 1, 184, 185, 907, 910 }, // 73 IIC_IntRotate
  { 0, 0, 0, 0, 0 }, // 74 IIC_SprSLBFEE
  { 0, 0, 0, 0, 0 }, // 75 IIC_SprSLBIA
  { 0, 0, 0, 0, 0 }, // 76 IIC_SprSLBIE
  { 0, 0, 0, 0, 0 }, // 77 IIC_SprSLBIEG
  { 0, 0, 0, 0, 0 }, // 78 IIC_SprSLBMFEE
  { 0, 0, 0, 0, 0 }, // 79 IIC_SprSLBMFEV
  { 0, 0, 0, 0, 0 }, // 80 IIC_SprSLBMTE
  { 0, 0, 0, 0, 0 }, // 81 IIC_SprSLBSYNC
  { 1, 184, 185, 910, 913 }, // 82 IIC_IntShift
  { 1, 184, 185, 913, 916 }, // 83 IIC_LdStSTWCX
  { 1, 184, 185, 916, 920 }, // 84 IIC_LdStSTU
  { 1, 184, 185, 920, 924 }, // 85 IIC_LdStSTUX
  { 1, 184, 185, 924, 927 }, // 86 IIC_LdStSTD
  { 1, 184, 185, 927, 930 }, // 87 IIC_LdStSTDCX
  { 1, 184, 185, 930, 933 }, // 88 IIC_LdStSTFD
  { 1, 184, 185, 933, 937 }, // 89 IIC_LdStSTFDU
  { 0, 0, 0, 0, 0 }, // 90 IIC_SprSTOP
  { 0, 0, 0, 0, 0 }, // 91 IIC_LdStSTQ
  { 0, 0, 0, 0, 0 }, // 92 IIC_LdStSTQCX
  { 1, 184, 185, 937, 939 }, // 93 IIC_IntTrapD
  { 0, 0, 0, 0, 0 }, // 94 IIC_SprTLBIA
  { 0, 0, 0, 0, 0 }, // 95 IIC_SprTLBIE
  { 0, 0, 0, 0, 0 }, // 96 IIC_SprTLBIEL
  { 0, 0, 0, 0, 0 }, // 97 IIC_SprTLBSYNC
  { 1, 184, 185, 939, 941 }, // 98 IIC_IntTrapW
  { 0, 0, 0, 0, 0 }, // 99 IIC_VecFPCompare
  { 0, 0, 0, 0, 0 }, // 100 IIC_VecPerm
  { 0, 0, 0, 0, 0 }, // 101 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VSLD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_VPOPCNTB_VPOPCNTH_VSRAD_MTVSRDD_VEQV_VNAND_VNEGD_VNEGW_VORC_XXLAND_XXLANDC_XXLEQV_XXLEQVOnes_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 0, 0, 0, 0, 0 }, // 102 VAND_VANDC_V_SET0_V_SET0B_V_SET0H_VSLB_VSLH_VSLW_VSRB_VSRH_VSRW_VRLB_VRLD_VRLH_VRLW_VSRAB_VSRAH_VSRAW_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP_XVXEXPDP_XVXEXPSP_VRLDMI_VRLDNM_VRLWMI_VRLWNM_VMRGEW_VMRGOW_VNOR_VOR_VSEL_VXOR_XVNEGDP_XVNEGSP_XSABSQP_XSCPSGNQP_XSIEXPQP_XSNABSQP_XSNEGQP_XSXEXPQP
  { 0, 0, 0, 0, 0 }, // 103 XXSEL
  { 1, 184, 185, 941, 943 }, // 104 TABORTDC_TABORTDCI_TABORTWC_TABORTWCI
  { 0, 0, 0, 0, 0 }, // 105 MTFSB0_MTFSB1
  { 0, 0, 0, 0, 0 }, // 106 MFFSCDRN_MFFSCDRNI_MFFSCRN_MFFSCRNI
  { 1, 184, 185, 943, 946 }, // 107 CMPRB_CMPRB8_CMPEQB
  { 1, 184, 185, 946, 948 }, // 108 TD_TDI
  { 1, 184, 185, 948, 950 }, // 109 TW_TWI
  { 1, 185, 186, 950, 953 }, // 110 FCMPOD_FCMPOS_FCMPUD_FCMPUS_FTDIV_FTSQRT
  { 0, 0, 0, 0, 0 }, // 111 XSTSTDCDP_XSTSTDCSP
  { 0, 0, 0, 0, 0 }, // 112 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP_XSXSIGDP_XSCVSPDPN
  { 1, 185, 186, 953, 956 }, // 113 XSCMPEQDP_XSCMPEXPDP_XSCMPGEDP_XSCMPGTDP_XSCMPODP_XSCMPUDP_XSTDIVDP_XSTSQRTDP
  { 1, 184, 185, 956, 959 }, // 114 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW_CMPB_CMPB8_SETB_SETB8_BPERMD
  { 1, 184, 185, 959, 962 }, // 115 SLD_SRD_SRAD
  { 1, 184, 185, 962, 965 }, // 116 SRADI_EXTSWSLI_32_64_EXTSWSLI_SRADI_32_RLDIC
  { 0, 0, 0, 0, 0 }, // 117 MFVRD_MFVSRD_MTVRD_MTVSRD_MTVRWA_MTVRWZ_MTVSRWA_MTVSRWZ_MFVSRWZ_MFVRWZ
  { 1, 184, 185, 965, 968 }, // 118 CMPLW_CMPLWI_CMPW_CMPWI_CMPD_CMPDI_CMPLD_CMPLDI
  { 1, 184, 185, 968, 971 }, // 119 SUBFC_SUBFC8_SUBFC8O_SUBFCO_SUBFIC_SUBFIC8_ANDI8_rec_ANDIS8_rec_ANDIS_rec_ANDI_rec_ADDC_ADDC8_ADDC8O_ADDCO_ADDIC_ADDIC8_ADDIC_rec_ADDE_ADDE8_ADDE8O_ADDE8O_rec_ADDE8_rec_ADDEO_ADDEO_rec_ADDE_rec_ADDME_ADDME8_ADDME8O_ADDME8O_rec_ADDME8_rec_ADDMEO_ADDMEO_rec_ADDME_rec_ADDZE_ADDZE8_ADDZE8O_ADDZE8O_rec_ADDZE8_rec_ADDZEO_ADDZEO_rec_ADDZE_rec_SUBF_SUBF8_SUBF8O_SUBF8O_rec_SUBF8_rec_SUBFE_SUBFE8_SUBFE8O_SUBFE8O_rec_SUBFE8_rec_SUBFEO_SUBFEO_rec_SUBFE_rec_SUBFME_SUBFME8_SUBFME8O_SUBFME8O_rec_SUBFME8_rec_SUBFMEO_SUBFMEO_rec_SUBFME_rec_SUBFO_SUBFO_rec_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZE8O_rec_SUBFZE8_rec_SUBFZEO_SUBFZEO_rec_SUBFZE_rec_SUBF_rec_POPCNTB_POPCNTB8_LA_LA8
  { 1, 184, 185, 971, 974 }, // 120 ADD4_ADD4O_ADD4O_rec_ADD4_rec_ADD8_ADD8O_ADD8O_rec_ADD8_rec_NEG_NEG8_NEG8O_NEG8O_rec_NEG8_rec_NEGO_NEGO_rec_NEG_rec_ADDI_ADDI8_ADDIS_ADDIS8_LI_LI8_LIS_LIS8_OR_OR8_OR8_rec_ORI_ORI8_ORIS_ORIS8_OR_rec_XOR_XOR8_XOR8_rec_XORI_XORI8_XORIS_XORIS8_XOR_rec_NAND_NAND8_NAND8_rec_NAND_rec_AND_AND8_AND8_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_AND_rec_NOR_NOR8_NOR8_rec_NOR_rec_ORC_ORC8_ORC8_rec_ORC_rec_EQV_EQV8_EQV8_rec_EQV_rec_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_ADD4TLS_ADD8TLS_ADD8TLS__NOP
  { 0, 0, 0, 0, 0 }, // 121 ADDIStocHA_ADDIStocHA8_ADDItocL_COPY
  { 1, 184, 185, 974, 977 }, // 122 MCRF
  { 1, 184, 185, 977, 980 }, // 123 MCRXRX
  { 0, 0, 0, 0, 0 }, // 124 XSNABSDP_XSXEXPDP_XSABSDP_XSNEGDP_XSCPSGNDP
  { 1, 184, 185, 980, 983 }, // 125 RFEBB
  { 1, 184, 185, 983, 985 }, // 126 TBEGIN_TRECHKPT
  { 1, 184, 185, 985, 988 }, // 127 WAIT
  { 1, 184, 185, 988, 991 }, // 128 RLDCL_RLDCR
  { 1, 184, 185, 991, 994 }, // 129 RLWIMI_RLWIMI8
  { 1, 184, 185, 994, 997 }, // 130 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32_RLDIMI
  { 1, 184, 185, 997, 999 }, // 131 MFOCRF_MFOCRF8
  { 1, 184, 185, 999, 1002 }, // 132 MTOCRF_MTOCRF8
  { 1, 184, 185, 1002, 1005 }, // 133 CR6SET_CR6UNSET_CRSET_CRUNSET_CRAND_CRANDC_CRNAND_CRNOR_CROR_CRORC_CREQV_CRXOR
  { 1, 184, 185, 1005, 1008 }, // 134 SLW_SLW8_SRW_SRW8_RLWINM_RLWINM8_RLWNM_RLWNM8
  { 1, 185, 186, 1008, 1011 }, // 135 FABSD_FABSS_FNABSD_FNABSS_FNEGD_FNEGS_FCPSGND_FCPSGNS_FMR
  { 1, 184, 185, 1011, 1014 }, // 136 SRAW_SRAWI
  { 1, 184, 185, 1014, 1018 }, // 137 ISEL_ISEL8
  { 0, 0, 0, 0, 0 }, // 138 XSIEXPDP
  { 1, 184, 185, 1018, 1020 }, // 139 TRECLAIM_TSR_TABORT
  { 1, 184, 185, 1020, 1023 }, // 140 MFVSCR
  { 1, 184, 185, 1023, 1026 }, // 141 MTVSCR
  { 0, 0, 0, 0, 0 }, // 142 VCMPNEZB_VCMPNEZH_VCMPNEZW_VCMPEQUB_VCMPEQUD_VCMPEQUH_VCMPEQUW_VCMPNEB_VCMPNEH_VCMPNEW_VCMPEQFP_VCMPEQFP_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPBFP_VCMPBFP_rec_VCMPGTSB_VCMPGTSB_rec_VCMPGTSD_VCMPGTSD_rec_VCMPGTSH_VCMPGTSH_rec_VCMPGTSW_VCMPGTSW_rec_VCMPGTUB_VCMPGTUB_rec_VCMPGTUD_VCMPGTUD_rec_VCMPGTUH_VCMPGTUH_rec_VCMPGTUW_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 0, 0, 0, 0, 0 }, // 143 VABSDUB_VABSDUH_VABSDUW_VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTW_VPOPCNTD_VPRTYBD_VPRTYBW
  { 0, 0, 0, 0, 0 }, // 144 VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VADDSBS_VADDSHS_VADDSWS_VMAXFP_VMINFP_VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW_VBPERMD_VADDCUW_VSHASIGMAD_VSHASIGMAW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_VSUBCUW_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP_XVXSIGDP_XVXSIGSP
  { 1, 185, 186, 1026, 1029 }, // 145 XVTDIVDP_XVTDIVSP_XVTSQRTDP_XVTSQRTSP
  { 0, 0, 0, 0, 0 }, // 146 VADDFP_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VEXPTEFP_VLOGEFP_VMADDFP_VMHADDSHS_VNMSUBFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVADDDP_XVADDSP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVHPSP_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVMULDP_XVMULSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP_XVSUBDP_XVSUBSP_VCFSX_VCFSX_0_VCFUX_VCFUX_0_VMHRADDSHS_VMLADDUHM_VMSUMMBM_VMSUMSHM_VMSUMSHS_VMSUMUBM_VMSUMUHM_VMSUMUDM_VMSUMUHS_VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS_VSUMSWS
  { 0, 0, 0, 0, 0 }, // 147 VSUBFP_VMULUWM
  { 0, 0, 0, 0, 0 }, // 148 MADDHD_MADDHDU_MADDLD_MADDLD8_MULLD_MULLDO
  { 1, 184, 185, 1029, 1032 }, // 149 MULHD_MULHW_MULLW_MULLWO
  { 1, 184, 185, 1032, 1035 }, // 150 MULHDU_MULHWU
  { 1, 184, 185, 1035, 1038 }, // 151 MULLI_MULLI8
  { 1, 185, 186, 1038, 1041 }, // 152 FRSP_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRE_FRES_FADDS_FMSUBS_FMADDS_FSUBS_FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRSQRTE_FRSQRTES_FNMADDS_FNMSUBS_FSELD_FSELS_FMULS
  { 1, 185, 186, 1041, 1044 }, // 153 FADD_FSUB
  { 1, 185, 186, 1044, 1048 }, // 154 FMSUB_FMADD_FNMADD_FNMSUB_FMUL
  { 0, 0, 0, 0, 0 }, // 155 XSMADDADP_XSMADDASP_XSMADDMDP_XSMADDMSP_XSMSUBADP_XSMSUBASP_XSMSUBMDP_XSMSUBMSP_XSMULDP_XSMULSP_XSNMADDADP_XSNMADDASP_XSNMADDMDP_XSNMADDMSP_XSNMSUBADP_XSNMSUBASP_XSNMSUBMDP_XSNMSUBMSP
  { 1, 185, 186, 1048, 1051 }, // 156 FSELD_rec_FSELS_rec
  { 1, 184, 185, 1051, 1054 }, // 157 MULHDU_rec_MULHWU_rec
  { 1, 184, 185, 1054, 1057 }, // 158 MULHD_rec_MULHW_rec_MULLWO_rec_MULLW_rec
  { 0, 0, 0, 0, 0 }, // 159 MULLDO_rec_MULLD_rec
  { 1, 185, 186, 1057, 1060 }, // 160 FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRES_rec_FRE_rec_FADDS_rec_FSUBS_rec_FMSUBS_rec_FNMSUBS_rec_FMADDS_rec_FNMADDS_rec_FCFIDS_rec_FCFIDUS_rec_FCFIDU_rec_FCFID_rec_FCTIDUZ_rec_FCTIDU_rec_FCTIDZ_rec_FCTID_rec_FCTIWUZ_rec_FCTIWU_rec_FCTIWZ_rec_FCTIW_rec_FMULS_rec_FRSQRTES_rec_FRSQRTE_rec_FRSP_rec
  { 1, 185, 186, 1060, 1063 }, // 161 FADD_rec_FSUB_rec
  { 1, 185, 186, 1063, 1067 }, // 162 FMSUB_rec_FNMSUB_rec_FMADD_rec_FNMADD_rec_FMUL_rec
  { 0, 0, 0, 0, 0 }, // 163 XSADDDP_XSADDSP_XSCVDPHP_XSCVDPSP_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPSXWSs_XSCVDPUXWSs_XSCVHPDP_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSQRTEDP_XSRSQRTESP_XSSUBDP_XSSUBSP_XSCVDPSPN_XSRSP
  { 1, 184, 185, 1067, 1070 }, // 164 LVSL_LVSR
  { 0, 0, 0, 0, 0 }, // 165 VSPLTISB_VSPLTISH_VSPLTISW_VSPLTB_VSPLTBs_VSPLTH_VSPLTHs_VSPLTW_XXMRGHW_XXMRGLW_XXPERM_XXPERMR_XXSLDWI_XXSLDWIs_XXSPLTIB_XXSPLTW_XXSPLTWs_XXPERMDI_XXPERMDIs
  { 0, 0, 0, 0, 0 }, // 166 V_SETALLONES_V_SETALLONESB_V_SETALLONESH_VBPERMQ_VGBBD_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPERM_VPERMR_VPERMXOR_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLDOI_VSLO_VSLV_VSR_VSRO_VSRV_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW_XXEXTRACTUW_XXINSERTW_VADDCUQ_VADDECUQ_VADDEUQM_VMUL10CUQ_VMUL10ECUQ_VMUL10EUQ_VMUL10UQ_VSUBCUQ_VSUBECUQ_VSUBEUQM_XSTSTDCQP_XSXSIGQP_BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDS_rec_BCDTRUNC_rec_BCDUS_rec_BCDUTRUNC_rec_BCDADD_rec_BCDSUB_rec
  { 0, 0, 0, 0, 0 }, // 167 VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VINSERTB_VINSERTD_VINSERTH_VINSERTW_MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VEXTRACTD_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VPRTYBQ_VADDUQM_VSUBUQM
  { 1, 185, 186, 1070, 1073 }, // 168 XSCMPEXPQP_XSCMPOQP_XSCMPUQP
  { 0, 0, 0, 0, 0 }, // 169 BCDSR_rec_XSADDQP_XSADDQPO_XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP_XSRQPI_XSRQPIX_XSRQPXP_XSSUBQP_XSSUBQPO
  { 0, 0, 0, 0, 0 }, // 170 BCDCTSQ_rec
  { 0, 0, 0, 0, 0 }, // 171 XSMADDQP_XSMADDQPO_XSMSUBQP_XSMSUBQPO_XSMULQP_XSMULQPO_XSNMADDQP_XSNMADDQPO_XSNMSUBQP_XSNMSUBQPO
  { 0, 0, 0, 0, 0 }, // 172 BCDCFSQ_rec
  { 0, 0, 0, 0, 0 }, // 173 XSDIVQP_XSDIVQPO
  { 0, 0, 0, 0, 0 }, // 174 XSSQRTQP_XSSQRTQPO
  { 1, 184, 185, 1073, 1076 }, // 175 LXVL_LXVLL
  { 1, 184, 185, 1076, 1079 }, // 176 LVEBX_LVEHX_LVEWX_LVX_LVXL
  { 1, 184, 185, 1079, 1082 }, // 177 LXSIBZX_LXSIHZX_LXSDX_LXVB16X_LXVD2X_LXVWSX_LXSIWZX_LXV_LXVX_LXSD
  { 0, 0, 0, 0, 0 }, // 178 DFLOADf64_XFLOADf64_LIWZX
  { 1, 184, 185, 1082, 1085 }, // 179 DCBF_DCBFEP_DCBST_DCBSTEP_DCBT_DCBTEP_DCBZ_DCBZEP_DCBZL_DCBZLEP_DCBTST_DCBTSTEP
  { 0, 0, 0, 0, 0 }, // 180 CP_COPY_CP_COPY8
  { 1, 184, 185, 1085, 1088 }, // 181 ICBI_ICBIEP
  { 1, 184, 185, 1088, 1091 }, // 182 ICBT_ICBTLS_LBZ_LBZ8_LBZCIX_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LDBRX_LDCIX_LHBRX_LHBRX8_LHZ_LHZ8_LHZCIX_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWBRX_LWBRX8_LWZ_LWZ8_LWZCIX_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32_EnforceIEIO_LSWI
  { 1, 184, 185, 1091, 1094 }, // 183 LBARX_LBARXL_LHARX_LHARXL_LWARX_LWARXL
  { 0, 0, 0, 0, 0 }, // 184 LD_LDX_LDXTLS_LDXTLS__DARN
  { 0, 0, 0, 0, 0 }, // 185 LDARX_LDARXL
  { 0, 0, 0, 0, 0 }, // 186 CP_ABORT
  { 1, 184, 185, 1094, 1095 }, // 187 ISYNC
  { 0, 0, 0, 0, 0 }, // 188 MSGSYNC
  { 0, 0, 0, 0, 0 }, // 189 TLBSYNC
  { 1, 184, 185, 1095, 1096 }, // 190 SYNC
  { 0, 0, 0, 0, 0 }, // 191 LMW
  { 1, 184, 185, 1096, 1099 }, // 192 LFIWZX_LFDX_LFD
  { 0, 0, 0, 0, 0 }, // 193 SLBIA
  { 0, 0, 0, 0, 0 }, // 194 SLBIE
  { 0, 0, 0, 0, 0 }, // 195 SLBMFEE
  { 0, 0, 0, 0, 0 }, // 196 SLBMFEV
  { 0, 0, 0, 0, 0 }, // 197 SLBMTE
  { 0, 0, 0, 0, 0 }, // 198 TLBIEL
  { 1, 184, 185, 1099, 1103 }, // 199 LHZU_LHZU8_LWZU_LWZU8
  { 1, 184, 185, 1103, 1107 }, // 200 LHZUX_LHZUX8_LWZUX_LWZUX8
  { 1, 184, 185, 1107, 1109 }, // 201 TEND
  { 1, 184, 185, 1109, 1112 }, // 202 STBCX_STHCX_STWCX
  { 1, 184, 185, 1112, 1115 }, // 203 STDCX
  { 0, 0, 0, 0, 0 }, // 204 LDMX
  { 1, 184, 185, 1115, 1118 }, // 205 LHA_LHA8_LHAX_LHAX8_LWAX_LWAX_32
  { 0, 0, 0, 0, 0 }, // 206 CP_PASTE8_rec_CP_PASTE_rec
  { 0, 0, 0, 0, 0 }, // 207 LWA_LWA_32
  { 1, 184, 185, 1118, 1120 }, // 208 TCHECK
  { 1, 184, 185, 1120, 1123 }, // 209 LFIWAX
  { 1, 184, 185, 1123, 1126 }, // 210 LXSIWAX
  { 0, 0, 0, 0, 0 }, // 211 LIWAX
  { 1, 184, 185, 1126, 1129 }, // 212 LFSX_LFS
  { 1, 184, 185, 1129, 1132 }, // 213 LXSSP_LXSSPX
  { 0, 0, 0, 0, 0 }, // 214 XFLOADf32_DFLOADf32
  { 1, 184, 185, 1132, 1136 }, // 215 LHAU_LHAU8
  { 1, 184, 185, 1136, 1140 }, // 216 LHAUX_LHAUX8_LWAUX
  { 1, 184, 185, 1140, 1143 }, // 217 LXVH8X_LXVDSX_LXVW4X
  { 1, 184, 185, 1143, 1146 }, // 218 STFD_STFDX_STFIWX_STFS_STFSX_STXSD_STXSDX_STXSIBX_STXSIBXv_STXSIHX_STXSIHXv_STXSIWX_STXSSP_STXSSPX
  { 1, 184, 185, 1146, 1149 }, // 219 STW_STW8_STDBRX_STHBRX_STWBRX_STB_STB8_STH_STH8_STBX_STBX8_STBXTLS_STBXTLS__STBXTLS_32_STHX_STHX8_STHXTLS_STHXTLS__STHXTLS_32_STWX_STWX8_STWXTLS_STWXTLS__STWXTLS_32
  { 0, 0, 0, 0, 0 }, // 220 DFSTOREf32_DFSTOREf64_XFSTOREf32_XFSTOREf64_STIWX
  { 1, 184, 185, 1149, 1152 }, // 221 STD_STDX_STDXTLS_STDXTLS_
  { 1, 184, 185, 1152, 1155 }, // 222 STBCIX_STDCIX_STHCIX_STWCIX_STSWI
  { 0, 0, 0, 0, 0 }, // 223 SLBIEG
  { 0, 0, 0, 0, 0 }, // 224 STMW
  { 0, 0, 0, 0, 0 }, // 225 TLBIE
  { 1, 184, 185, 1155, 1158 }, // 226 STVEBX_STVEHX_STVEWX_STVX_STVXL
  { 1, 184, 185, 1158, 1161 }, // 227 STXV_STXVB16X_STXVD2X_STXVH8X_STXVW4X_STXVX
  { 1, 184, 185, 1161, 1164 }, // 228 STXVL_STXVLL
  { 1, 184, 185, 1164, 1166 }, // 229 MTCTR_MTCTR8_MTCTR8loop_MTCTRloop_MTLR_MTLR8
  { 1, 184, 185, 1166, 1169 }, // 230 MFVRSAVE_MFVRSAVEv_MTVRSAVE_MTVRSAVEv
  { 0, 0, 0, 0, 0 }, // 231 MFPMR
  { 0, 0, 0, 0, 0 }, // 232 MTPMR
  { 1, 184, 185, 1169, 1171 }, // 233 MFTB_MFTB8
  { 1, 184, 185, 1171, 1173 }, // 234 MFCTR_MFCTR8_MFLR_MFLR8_MFSPR_MFSPR8
  { 1, 184, 185, 1173, 1175 }, // 235 MFMSR
  { 1, 184, 185, 1175, 1177 }, // 236 MTMSR
  { 0, 0, 0, 0, 0 }, // 237 MTMSRD
  { 1, 184, 185, 1177, 1179 }, // 238 MTSPR_MTSPR8
  { 1, 184, 185, 1179, 1182 }, // 239 DIVW_DIVWO_DIVWU_DIVWUO_MODSW
  { 1, 184, 185, 1182, 1185 }, // 240 DIVWE_DIVWEO_DIVWEU_DIVWEUO_MODSD_MODUD_MODUW
  { 1, 184, 185, 1185, 1188 }, // 241 DIVD_DIVDO_DIVDU_DIVDUO
  { 1, 184, 185, 1188, 1191 }, // 242 DIVDE_DIVDEO_DIVDEU_DIVDEUO
  { 1, 184, 185, 1191, 1194 }, // 243 DIVWO_rec_DIVWUO_rec_DIVWU_rec_DIVW_rec
  { 1, 184, 185, 1194, 1197 }, // 244 DIVD_rec_DIVDO_rec_DIVDU_rec_DIVDUO_rec
  { 1, 184, 185, 1197, 1200 }, // 245 DIVWE_rec_DIVWEO_rec_DIVWEU_rec_DIVWEUO_rec
  { 1, 184, 185, 1200, 1203 }, // 246 DIVDE_rec_DIVDEO_rec_DIVDEU_rec_DIVDEUO_rec
  { 1, 184, 185, 1203, 1206 }, // 247 MTCRF_MTCRF8
  { 1, 184, 185, 1206, 1209 }, // 248 ADDC8O_rec_ADDC8_rec_ADDCO_rec_ADDC_rec_SUBFC8O_rec_SUBFC8_rec_SUBFCO_rec_SUBFC_rec
  { 1, 185, 186, 1209, 1212 }, // 249 FABSD_rec_FABSS_rec_FNABSD_rec_FNABSS_rec_FCPSGND_rec_FCPSGNS_rec_FNEGD_rec_FNEGS_rec_FMR_rec
  { 1, 184, 185, 1212, 1215 }, // 250 MCRFS
  { 0, 0, 0, 0, 0 }, // 251 MTFSF_MTFSF_rec_MTFSFI_MTFSFI_rec_MTFSFIb
  { 0, 0, 0, 0, 0 }, // 252 MTFSFb
  { 1, 184, 185, 1215, 1218 }, // 253 RLDCL_rec_RLDCR_rec
  { 1, 184, 185, 1218, 1221 }, // 254 RLDICL_rec_RLDICR_rec_RLDICL_32_rec_RLDIMI_rec
  { 1, 184, 185, 1221, 1224 }, // 255 RLWIMI8_rec_RLWIMI_rec
  { 1, 184, 185, 1224, 1227 }, // 256 RLWINM8_rec_RLWINM_rec_RLWNM8_rec_RLWNM_rec_SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 1, 184, 185, 1227, 1230 }, // 257 SRAWI_rec_SRAW_rec
  { 0, 0, 0, 0, 0 }, // 258 MFFS_MFFSCE_MFFSL_MFFS_rec
  { 1, 184, 185, 1230, 1232 }, // 259 MFCR_MFCR8
  { 1, 184, 185, 1232, 1235 }, // 260 EXTSWSLI_32_64_rec_SRADI_rec_EXTSWSLI_rec_RLDIC_rec
  { 1, 184, 185, 1235, 1238 }, // 261 SRAD_rec_SLD_rec_SRD_rec
  { 1, 185, 186, 1238, 1241 }, // 262 FDIV
  { 1, 185, 186, 1241, 1244 }, // 263 FDIV_rec
  { 1, 185, 186, 1244, 1247 }, // 264 XSSQRTDP
  { 1, 185, 186, 1247, 1250 }, // 265 FSQRT
  { 1, 185, 186, 1250, 1253 }, // 266 XVSQRTDP
  { 1, 185, 186, 1253, 1256 }, // 267 XVSQRTSP
  { 1, 185, 186, 1256, 1259 }, // 268 FSQRT_rec
  { 1, 185, 186, 1259, 1262 }, // 269 XSSQRTSP
  { 1, 185, 186, 1262, 1265 }, // 270 FSQRTS
  { 1, 185, 186, 1265, 1268 }, // 271 FSQRTS_rec
  { 1, 185, 186, 1268, 1271 }, // 272 XSDIVDP
  { 1, 185, 186, 1271, 1274 }, // 273 FDIVS
  { 1, 185, 186, 1274, 1277 }, // 274 FDIVS_rec
  { 1, 185, 186, 1277, 1280 }, // 275 XSDIVSP
  { 1, 185, 186, 1280, 1283 }, // 276 XVDIVSP
  { 1, 185, 186, 1283, 1286 }, // 277 XVDIVDP
  { 1, 184, 185, 1286, 1290 }, // 278 LFSU
  { 1, 184, 185, 1290, 1294 }, // 279 LFSUX
  { 1, 184, 185, 1294, 1298 }, // 280 STFDU_STFDUX_STFSU_STFSUX
  { 1, 184, 185, 1298, 1302 }, // 281 STBU_STBU8_STDU_STHU_STHU8_STWU_STWU8
  { 1, 184, 185, 1302, 1306 }, // 282 STBUX_STBUX8_STDUX_STHUX_STHUX8_STWUX_STWUX8
  { 1, 184, 185, 1306, 1310 }, // 283 LBZU_LBZU8
  { 1, 184, 185, 1310, 1314 }, // 284 LBZUX_LBZUX8
  { 1, 184, 185, 1314, 1317 }, // 285 LDU
  { 1, 184, 185, 1317, 1320 }, // 286 LDUX
  { 1, 184, 185, 1320, 1324 }, // 287 LFDU
  { 1, 184, 185, 1324, 1328 }, // 288 LFDUX
  { 0, 0, 0, 0, 0 }, // 289 VPMSUMB_VPMSUMD_VPMSUMH_VPMSUMW_VCIPHER_VCIPHERLAST_VNCIPHER_VNCIPHERLAST_VSBOX
  { 1, 184, 185, 1328, 1331 }, // 290 BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_BCCTR_BCCTR8_BCCTR8n_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_BCCTRn_BDNZ_BDNZ8_BDNZA_BDNZAm_BDNZAp_BDNZm_BDNZp_BDZ_BDZ8_BDZA_BDZAm_BDZAp_BDZm_BDZp_BDNZL_BDNZLA_BDNZLAm_BDNZLAp_BDNZLR_BDNZLR8_BDNZLRL_BDNZLRLm_BDNZLRLp_BDNZLRm_BDNZLRp_BDNZLm_BDNZLp_BDZL_BDZLA_BDZLAm_BDZLAp_BDZLR_BDZLR8_BDZLRL_BDZLRLm_BDZLRLp_BDZLRm_BDZLRp_BDZLm_BDZLp_BL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM_BLR_BLR8_BLRL_TAILB_TAILB8_TAILBA_TAILBA8_TAILBCTR_TAILBCTR8_gBC_gBCA_gBCAat_gBCCTR_gBCCTRL_gBCL_gBCLA_gBCLAat_gBCLR_gBCLRL_gBCLat_gBCat_BCLR_BCLRL_BCLRLn_BCLRn_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_RM_BCTRL_RM_B_BA_BC_BCC_BCCA_BCL_BCLalways_BCLn_BCTRL8_LDinto_toc_BCTRL_LWZinto_toc_BCTRL8_LDinto_toc_RM_BCTRL_LWZinto_toc_RM_BCn_CTRL_DEP
  { 1, 184, 185, 1331, 1334 }, // 291 ADDPCIS
  { 1, 184, 185, 1334, 1337 }, // 292 LDAT_LWAT
  { 1, 184, 185, 1337, 1340 }, // 293 STDAT_STWAT
  { 1, 184, 185, 1340, 1343 }, // 294 BRINC
  { 0, 0, 0, 0, 0 }, // 295 EVABS_EVEQV_EVNAND_EVNEG_EVADDIW_EVADDW_EVAND_EVANDC_EVCMPEQ_EVCMPGTS_EVCMPGTU_EVCMPLTS_EVCMPLTU_EVCNTLSW_EVCNTLZW_EVEXTSB_EVEXTSH_EVMERGEHI_EVMERGEHILO_EVMERGELO_EVMERGELOHI_EVNOR_EVOR_EVORC_EVXOR_EVRLW_EVRLWI_EVRNDW_EVSLW_EVSLWI_EVSPLATFI_EVSPLATI_EVSRWIS_EVSRWIU_EVSRWS_EVSRWU_EVSUBFW_EVSUBIFW
  { 0, 0, 0, 0, 0 }, // 296 EVMRA_EVADDSMIAAW_EVADDSSIAAW_EVADDUMIAAW_EVADDUSIAAW_EVDIVWS_EVDIVWU_EVMHEGSMFAA_EVMHEGSMFAN_EVMHEGSMIAA_EVMHEGSMIAN_EVMHEGUMIAA_EVMHEGUMIAN_EVMHESMF_EVMHESMFA_EVMHESMFAAW_EVMHESMFANW_EVMHESMI_EVMHESMIA_EVMHESMIAAW_EVMHESMIANW_EVMHESSF_EVMHESSFA_EVMHESSFAAW_EVMHESSFANW_EVMHESSIAAW_EVMHESSIANW_EVMHEUMI_EVMHEUMIA_EVMHEUMIAAW_EVMHEUMIANW_EVMHEUSIAAW_EVMHEUSIANW_EVMHOGSMFAA_EVMHOGSMFAN_EVMHOGSMIAA_EVMHOGSMIAN_EVMHOGUMIAA_EVMHOGUMIAN_EVMHOSMF_EVMHOSMFA_EVMHOSMFAAW_EVMHOSMFANW_EVMHOSMI_EVMHOSMIA_EVMHOSMIAAW_EVMHOSMIANW_EVMHOSSF_EVMHOSSFA_EVMHOSSFAAW_EVMHOSSFANW_EVMHOSSIAAW_EVMHOSSIANW_EVMHOUMI_EVMHOUMIA_EVMHOUMIAAW_EVMHOUMIANW_EVMHOUSIAAW_EVMHOUSIANW_EVMWHSMF_EVMWHSMFA_EVMWHSMI_EVMWHSMIA_EVMWHSSF_EVMWHSSFA_EVMWHUMI_EVMWHUMIA_EVMWLSMIAAW_EVMWLSMIANW_EVMWLSSIAAW_EVMWLSSIANW_EVMWLUMI_EVMWLUMIA_EVMWLUMIAAW_EVMWLUMIANW_EVMWLUSIAAW_EVMWLUSIANW_EVMWSMF_EVMWSMFA_EVMWSMFAA_EVMWSMFAN_EVMWSMI_EVMWSMIA_EVMWSMIAA_EVMWSMIAN_EVMWSSF_EVMWSSFA_EVMWSSFAA_EVMWSSFAN_EVMWUMI_EVMWUMIA_EVMWUMIAA_EVMWUMIAN_EVSUBFSMIAAW_EVSUBFSSIAAW_EVSUBFUMIAAW_EVSUBFUSIAAW
  { 1, 184, 185, 1343, 1346 }, // 297 EVLDD_EVLDDX_EVLDH_EVLDHX_EVLDW_EVLDWX_EVLHHESPLAT_EVLHHESPLATX_EVLHHOSSPLAT_EVLHHOSSPLATX_EVLHHOUSPLAT_EVLHHOUSPLATX_EVLWHE_EVLWHEX_EVLWHOS_EVLWHOSX_EVLWHOU_EVLWHOUX_EVLWHSPLAT_EVLWHSPLATX_EVLWWSPLAT_EVLWWSPLATX
  { 1, 184, 185, 1346, 1349 }, // 298 EVSTDD_EVSTDDX_EVSTDH_EVSTDHX_EVSTDW_EVSTDWX_EVSTWHE_EVSTWHEX_EVSTWHO_EVSTWHOX_EVSTWWE_EVSTWWEX_EVSTWWO_EVSTWWOX
  { 1, 184, 185, 1349, 1352 }, // 299 HRFID_ATTN_CLRBHRB_MFBHRBE_NAP_RFCI_RFDI_RFMCI_SC
  { 1, 184, 185, 1352, 1353 }, // 300 RFI
  { 0, 0, 0, 0, 0 }, // 301 RFID
  { 1, 184, 185, 1353, 1356 }, // 302 DSS_DSSALL_DST_DST64_DSTST_DSTST64_DSTSTT_DSTSTT64_DSTT_DSTT64_ICBLQ_LBEPX_LHEPX_LWEPX_TLBIVAX_TLBLD_TLBLI_TLBRE_TLBRE2_TLBSX_TLBSX2_TLBSX2D_TLBWE_TLBWE2_MBAR_TRAP_DCCCI_ICCCI
  { 1, 184, 185, 1356, 1359 }, // 303 ICBLC_STBEPX_STHEPX_STWEPX
  { 1, 184, 185, 1359, 1362 }, // 304 LFDEPX
  { 1, 184, 185, 1362, 1365 }, // 305 STFDEPX
  { 0, 0, 0, 0, 0 }, // 306 MFSR_MFSRIN
  { 0, 0, 0, 0, 0 }, // 307 MTSR_MTSRIN
  { 1, 184, 185, 1365, 1367 }, // 308 MFDCR
  { 1, 184, 185, 1367, 1369 }, // 309 MTDCR
  { 1, 184, 185, 1369, 1372 }, // 310 NOP_GT_PWR6_NOP_GT_PWR7
  { 0, 0, 0, 0, 0 }, // 311 TLBIA
  { 1, 184, 185, 1372, 1374 }, // 312 WRTEE_WRTEEI
  { 1, 184, 185, 1374, 1377 }, // 313 HASHCHK_HASHCHK8_HASHCHKP_HASHCHKP8_HASHST_HASHST8_HASHSTP_HASHSTP8_ADDEX_ADDEX8
  { 1, 184, 185, 1377, 1378 }, // 314 MSYNC
  { 0, 0, 0, 0, 0 }, // 315 SLBSYNC
  { 0, 0, 0, 0, 0 }, // 316 SLBFEE_rec
  { 0, 0, 0, 0, 0 }, // 317 STOP
  { 1, 184, 185, 1378, 1381 }, // 318 DCBA_DCBI
  { 1, 185, 186, 1381, 1384 }, // 319 FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRE_FRES_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRSP_FRSQRTE_FRSQRTES
  { 0, 0, 0, 0, 0 }, // 320 VCFSX_VCFSX_0_VCFUX_VCFUX_0_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VLOGEFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP
  { 0, 0, 0, 0, 0 }, // 321 XSCVDPHP_XSCVDPSP_XSCVDPSPN_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPSXWSs_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPUXWSs_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSP_XSRSQRTEDP_XSRSQRTESP
  { 0, 0, 0, 0, 0 }, // 322 XVCVSPBF16
  { 1, 185, 186, 1384, 1387 }, // 323 FADDS_FMULS_FSUBS
  { 1, 185, 186, 1387, 1391 }, // 324 FMUL
  { 0, 0, 0, 0, 0 }, // 325 VADDFP_XVADDDP_XVADDSP_XVMULDP_XVMULSP_XVSUBDP_XVSUBSP
  { 0, 0, 0, 0, 0 }, // 326 VSUBFP
  { 0, 0, 0, 0, 0 }, // 327 XSADDDP_XSADDSP_XSSUBDP_XSSUBSP
  { 0, 0, 0, 0, 0 }, // 328 XSMULDP_XSMULSP
  { 0, 0, 0, 0, 0 }, // 329 VMADDFP_VNMSUBFP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP
  { 0, 0, 0, 0, 0 }, // 330 VEXPTEFP
  { 1, 185, 186, 1391, 1394 }, // 331 FADDS_rec_FMULS_rec_FSUBS_rec
  { 1, 185, 186, 1394, 1398 }, // 332 FMUL_rec
  { 1, 185, 186, 1398, 1401 }, // 333 FCFID_rec_FCFIDS_rec_FCFIDU_rec_FCFIDUS_rec_FCTID_rec_FCTIDU_rec_FCTIDUZ_rec_FCTIDZ_rec_FCTIW_rec_FCTIWU_rec_FCTIWUZ_rec_FCTIWZ_rec_FRE_rec_FRES_rec_FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRSP_rec_FRSQRTE_rec_FRSQRTES_rec
  { 1, 184, 185, 1401, 1404 }, // 334 BCLR_BCLRn_BDNZLR_BDNZLR8_BDNZLRm_BDNZLRp_BDZLR_BDZLR8_BDZLRm_BDZLRp_gBCLR_BCLRL_BCLRLn_BDNZLRL_BDNZLRLm_BDNZLRLp_BDZLRL_BDZLRLm_BDZLRLp_gBCLRL_BL_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLR_BLR8_BLRL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS
  { 1, 184, 185, 1404, 1407 }, // 335 BL8_NOTOC_BL8_NOTOC_RM_BL8_NOTOC_TLS
  { 1, 184, 185, 1407, 1410 }, // 336 B_BCC_BCCA_BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_CTRL_DEP_TAILB_TAILB8_BA_TAILBA_TAILBA8_BC_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_LDinto_toc_BCTRL8_LDinto_toc_RM_BCTRL8_RM_BCTRL_LWZinto_toc_BCTRL_LWZinto_toc_RM_BCTRL_RM_BCn_BDNZ_BDNZ8_BDNZm_BDNZp_BDZ_BDZ8_BDZm_BDZp_TAILBCTR_TAILBCTR8_gBC_gBCat_BCL_BCLalways_BCLn_BDNZL_BDNZLm_BDNZLp_BDZL_BDZLm_BDZLp_gBCL_gBCLat_BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM
  { 1, 184, 185, 1410, 1413 }, // 337 BCCTR_BCCTR8_BCCTR8n_BCCTRn_gBCCTR_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_gBCCTRL
  { 0, 0, 0, 0, 0 }, // 338 VSBOX
  { 1, 184, 185, 1413, 1416 }, // 339 CFUGED_CNTLZDM_CNTTZDM_PDEPD_PEXTD
  { 0, 0, 0, 0, 0 }, // 340 VCFUGED_VCLZDM_VCTZDM_VGNB_VPDEPD_VPEXTD
  { 0, 0, 0, 0, 0 }, // 341 XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP
  { 0, 0, 0, 0, 0 }, // 342 XSCVQPSQZ_XSCVQPUQZ_XSCVSQQP_XSCVUQQP
  { 0, 0, 0, 0, 0 }, // 343 XSADDQP_XSADDQPO_XSSUBQP_XSSUBQPO
  { 1, 184, 185, 1416, 1419 }, // 344 HASHST_HASHST8_HASHSTP_HASHSTP8
  { 0, 0, 0, 0, 0 }, // 345 XSMULQP_XSMULQPO
  { 0, 0, 0, 0, 0 }, // 346 VDIVESQ_VDIVEUQ_VDIVSQ_VDIVUQ
  { 0, 0, 0, 0, 0 }, // 347 VMODSQ_VMODUQ
  { 1, 184, 185, 1419, 1422 }, // 348 DIVWE_DIVWEO_DIVWEU_DIVWEUO
  { 0, 0, 0, 0, 0 }, // 349 VDIVSD_VDIVUD
  { 0, 0, 0, 0, 0 }, // 350 VMODSD_VMODUD
  { 0, 0, 0, 0, 0 }, // 351 VDIVSW_VDIVUW
  { 0, 0, 0, 0, 0 }, // 352 VMODSW_VMODUW
  { 0, 0, 0, 0, 0 }, // 353 VDIVESD_VDIVEUD
  { 0, 0, 0, 0, 0 }, // 354 VDIVESW_VDIVEUW
  { 0, 0, 0, 0, 0 }, // 355 BCDCTN_rec_VMUL10CUQ_VMUL10UQ_XSXSIGQP
  { 0, 0, 0, 0, 0 }, // 356 BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDUS_rec_BCDUTRUNC_rec_VADDCUQ_VMUL10ECUQ_VMUL10EUQ_VSUBCUQ_XSTSTDCQP
  { 0, 0, 0, 0, 0 }, // 357 VADDUQM_VSUBUQM
  { 0, 0, 0, 0, 0 }, // 358 XSMAXCQP_XSMINCQP
  { 0, 0, 0, 0, 0 }, // 359 XXGENPCVBM
  { 0, 0, 0, 0, 0 }, // 360 BCDADD_rec_BCDS_rec_BCDSUB_rec_BCDTRUNC_rec_VADDECUQ_VADDEUQM_VSUBECUQ_VSUBEUQM
  { 1, 184, 185, 1422, 1425 }, // 361 TRAP
  { 1, 184, 185, 1425, 1427 }, // 362 TW
  { 1, 184, 185, 1427, 1430 }, // 363 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW
  { 1, 185, 186, 1430, 1433 }, // 364 FTSQRT
  { 0, 0, 0, 0, 0 }, // 365 MTVSRBM_MTVSRBMI_MTVSRDM_MTVSRHM_MTVSRQM_MTVSRWM_VEXPANDBM_VEXPANDDM_VEXPANDHM_VEXPANDQM_VEXPANDWM_VEXTRACTBM_VEXTRACTDM_VEXTRACTHM_VEXTRACTQM_VEXTRACTWM_XVTLSBB
  { 1, 184, 185, 1433, 1436 }, // 366 POPCNTB_POPCNTB8
  { 0, 0, 0, 0, 0 }, // 367 VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTD_VPOPCNTW_VPRTYBD_VPRTYBW
  { 0, 0, 0, 0, 0 }, // 368 VPOPCNTB_VPOPCNTH
  { 0, 0, 0, 0, 0 }, // 369 XSCVSPDPN
  { 1, 185, 186, 1436, 1439 }, // 370 XSTSQRTDP
  { 0, 0, 0, 0, 0 }, // 371 XVCVHPSP
  { 1, 185, 186, 1439, 1442 }, // 372 XVTSQRTDP_XVTSQRTSP
  { 1, 184, 185, 1442, 1445 }, // 373 CMPEQB
  { 1, 184, 185, 1445, 1448 }, // 374 EXTSWSLI_32_64_rec_EXTSWSLI_rec
  { 1, 184, 185, 1448, 1451 }, // 375 SLD_rec_SRD_rec
  { 1, 184, 185, 1451, 1454 }, // 376 SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 0, 0, 0, 0, 0 }, // 377 VADDCUW_VADDSBS_VADDSHS_VADDSWS_VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VMAXFP_VMINFP_VSUBCUW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP
  { 0, 0, 0, 0, 0 }, // 378 VCMPBFP_VCMPBFP_rec_VCMPEQFP_VCMPEQFP_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPGTSB_rec_VCMPGTSD_rec_VCMPGTSH_rec_VCMPGTSW_rec_VCMPGTUB_rec_VCMPGTUD_rec_VCMPGTUH_rec_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 0, 0, 0, 0, 0 }, // 379 VCMPEQUQ_VCMPEQUQ_rec_VCMPGTSQ_VCMPGTSQ_rec_VCMPGTUQ_VCMPGTUQ_rec
  { 0, 0, 0, 0, 0 }, // 380 VCMPSQ_VCMPUQ_VCNTMBB_VCNTMBD_VCNTMBH_VCNTMBW
  { 0, 0, 0, 0, 0 }, // 381 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP
  { 1, 184, 185, 1454, 1457 }, // 382 RLDIC_rec
  { 1, 184, 185, 1457, 1460 }, // 383 RLDICL_32_rec_RLDICL_rec_RLDICR_rec
  { 0, 0, 0, 0, 0 }, // 384 VSHASIGMAD_VSHASIGMAW
  { 0, 0, 0, 0, 0 }, // 385 VRLQ_VRLQNM_VSLQ_VSRAQ_VSRQ
  { 0, 0, 0, 0, 0 }, // 386 VRLQMI
  { 1, 184, 185, 1460, 1463 }, // 387 CR6SET_CREQV_CRSET
  { 1, 184, 185, 1463, 1466 }, // 388 DSS_DSSALL
  { 1, 184, 185, 1466, 1468 }, // 389 MFCTR_MFCTR8_MFLR_MFLR8
  { 1, 184, 185, 1468, 1471 }, // 390 NOP_ORI_ORI8
  { 0, 0, 0, 0, 0 }, // 391 VXOR_V_SET0_V_SET0B_V_SET0H
  { 0, 0, 0, 0, 0 }, // 392 XXLEQV_XXLEQVOnes_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 1, 184, 185, 1471, 1474 }, // 393 ADDI_ADDI8_LI_LI8_ADDIS_ADDIS8_LIS_LIS8_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_NEG_NEG8_NEG8_rec_NEG_rec_NEG8O_NEGO
  { 0, 0, 0, 0, 0 }, // 394 ADDIdtprelL32_ADDItlsldLADDR32_ADDISdtprelHA32
  { 0, 0, 0, 0, 0 }, // 395 ADDItocL_ADDIStocHA_ADDIStocHA8
  { 1, 184, 185, 1474, 1477 }, // 396 ADDME_ADDME8_ADDME8O_ADDMEO_ADDZE_ADDZE8_ADDZE8O_ADDZEO_SUBFME_SUBFME8_SUBFME8O_SUBFMEO_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZEO
  { 1, 185, 186, 1477, 1480 }, // 397 FABSD_FABSS_FMR_FNABSD_FNABSS_FNEGD_FNEGS
  { 1, 184, 185, 1480, 1483 }, // 398 SETB_SETB8
  { 1, 184, 185, 1483, 1486 }, // 399 SETBC_SETBC8_SETBCR_SETBCR8_SETNBC_SETNBC8_SETNBCR_SETNBCR8
  { 0, 0, 0, 0, 0 }, // 400 VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VNEGD_VNEGW
  { 0, 0, 0, 0, 0 }, // 401 VEXTSD2Q
  { 0, 0, 0, 0, 0 }, // 402 XSABSDP_XSNABSDP_XSNEGDP_XSXEXPDP
  { 0, 0, 0, 0, 0 }, // 403 XSABSQP_XSNABSQP_XSNEGQP_XSXEXPQP_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVNEGDP_XVNEGSP_XVXEXPDP_XVXEXPSP
  { 0, 0, 0, 0, 0 }, // 404 XVXSIGDP_XVXSIGSP
  { 1, 184, 185, 1486, 1489 }, // 405 ADD4_ADD4TLS_ADD8_ADD8TLS_ADD8TLS__ADD4_rec_ADD8_rec_ADD4O_ADD8O_AND_AND8_AND8_rec_AND_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_EQV_EQV8_EQV8_rec_EQV_rec_NAND_NAND8_NAND8_rec_NAND_rec_NOR_NOR8_NOR8_rec_NOR_rec_OR_OR8_OR8_rec_OR_rec_ORC_ORC8_ORC8_rec_ORC_rec_ORIS_ORIS8_XOR_XOR8_XOR8_rec_XOR_rec_XORI_XORI8_XORIS_XORIS8
  { 1, 184, 185, 1489, 1492 }, // 406 ADDE_ADDE8_ADDE8O_ADDEO_ADDIC_ADDIC8_ANDI8_rec_ANDI_rec_ANDIS8_rec_ANDIS_rec_SUBF_SUBF8_SUBF8_rec_SUBF_rec_SUBFE_SUBFE8_SUBFE8O_SUBFEO_SUBFIC_SUBFIC8_SUBF8O_SUBFO
  { 1, 184, 185, 1492, 1495 }, // 407 CMPB_CMPB8
  { 1, 184, 185, 1495, 1498 }, // 408 EXTSWSLI_EXTSWSLI_32_64_SRADI_SRADI_32
  { 1, 184, 185, 1498, 1501 }, // 409 SLW_SLW8_SRW_SRW8
  { 0, 0, 0, 0, 0 }, // 410 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEQV_VNAND_VORC_VSLD_VSRAD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_XXLAND_XXLANDC_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC
  { 0, 0, 0, 0, 0 }, // 411 VAND_VANDC_VMRGEW_VMRGOW_VNOR_VOR_VRLB_VRLD_VRLDNM_VRLH_VRLW_VRLWNM_VSLB_VSLH_VSLW_VSRAB_VSRAH_VSRAW_VSRB_VSRH_VSRW_XSCPSGNQP_XSIEXPQP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP
  { 0, 0, 0, 0, 0 }, // 412 VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW
  { 1, 184, 185, 1501, 1504 }, // 413 ADDEX_ADDEX8
  { 1, 184, 185, 1504, 1507 }, // 414 DST_DST64_DSTT_DSTT64_DSTST_DSTST64_DSTSTT_DSTSTT64
  { 1, 184, 185, 1507, 1510 }, // 415 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32
  { 0, 0, 0, 0, 0 }, // 416 MFFS_MFFS_rec_MFFSL
  { 1, 184, 185, 1510, 1512 }, // 417 TRECHKPT
  { 1, 184, 185, 1512, 1515 }, // 418 ADDME8_rec_ADDME_rec_ADDME8O_rec_ADDMEO_rec_ADDZE8_rec_ADDZE_rec_ADDZE8O_rec_ADDZEO_rec_SUBFME8_rec_SUBFME_rec_SUBFME8O_rec_SUBFMEO_rec_SUBFZE8_rec_SUBFZE_rec_SUBFZE8O_rec_SUBFZEO_rec
  { 0, 0, 0, 0, 0 }, // 419 MTFSB0
  { 1, 184, 185, 1515, 1518 }, // 420 NEG8O_rec_NEGO_rec
  { 1, 184, 185, 1518, 1521 }, // 421 ADDE8_rec_ADDE_rec_ADDE8O_rec_ADDEO_rec_ADDIC_rec_SUBFE8_rec_SUBFE_rec_SUBFE8O_rec_SUBFEO_rec_SUBF8O_rec_SUBFO_rec
  { 1, 184, 185, 1521, 1524 }, // 422 HRFID
  { 1, 185, 186, 1524, 1527 }, // 423 FABSD_rec_FABSS_rec_FMR_rec_FNABSD_rec_FNABSS_rec_FNEGD_rec_FNEGS_rec
  { 1, 184, 185, 1527, 1530 }, // 424 SC
  { 1, 184, 185, 1530, 1533 }, // 425 ADDC_ADDC8_ADDC8O_ADDCO_SUBFC_SUBFC8_SUBFC8O_SUBFCO
  { 1, 184, 185, 1533, 1536 }, // 426 ADDC8_rec_ADDC_rec_SUBFC8_rec_SUBFC_rec
  { 0, 0, 0, 0, 0 }, // 427 MTFSF_MTFSFI_MTFSFIb
  { 0, 0, 0, 0, 0 }, // 428 MTFSFI_rec
  { 0, 0, 0, 0, 0 }, // 429 VSTRIBL_rec_VSTRIBR_rec_VSTRIHL_rec_VSTRIHR_rec
  { 1, 184, 185, 1536, 1539 }, // 430 LBZ_LBZ8_LDBRX_LHBRX_LHBRX8_LHZ_LHZ8_LWBRX_LWBRX8_LWZ_LWZ8
  { 0, 0, 0, 0, 0 }, // 431 LD
  { 0, 0, 0, 0, 0 }, // 432 LDtoc_LDtocBA_LDtocCPT_LDtocJTI_LDtocL_SPILLTOVSR_LD_LWZtoc_LWZtocL
  { 1, 184, 185, 1539, 1542 }, // 433 LXVRBX_LXVRDX_LXVRHX_LXVRWX
  { 1, 184, 185, 1542, 1545 }, // 434 DCBT_DCBTST
  { 1, 184, 185, 1545, 1548 }, // 435 ICBT_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32
  { 0, 0, 0, 0, 0 }, // 436 LDX_LDXTLS_LDXTLS_
  { 0, 0, 0, 0, 0 }, // 437 SPILLTOVSR_LDX
  { 1, 184, 185, 1548, 1551 }, // 438 LBZCIX_LDCIX_LHZCIX_LWZCIX
  { 0, 0, 0, 0, 0 }, // 439 MTSR
  { 1, 184, 185, 1551, 1554 }, // 440 MTVRSAVE_MTVRSAVEv
  { 1, 184, 185, 1554, 1557 }, // 441 LSWI
  { 1, 184, 185, 1557, 1560 }, // 442 PLBZ_PLBZ8_PLBZ8pc_PLBZpc_PLD_PLDpc_PLFD_PLFDpc_PLFS_PLFSpc_PLHA_PLHA8_PLHA8pc_PLHApc_PLHZ_PLHZ8_PLHZ8pc_PLHZpc_PLWA_PLWA8_PLWA8pc_PLWApc_PLWZ_PLWZ8_PLWZ8pc_PLWZpc_PLXSD_PLXSDpc_PLXSSP_PLXSSPpc_PLXV_PLXVpc_PLXVP_PLXVPpc
  { 1, 184, 185, 1560, 1563 }, // 443 LXVP_LXVPX
  { 0, 0, 0, 0, 0 }, // 444 MFSR
  { 1, 184, 185, 1563, 1565 }, // 445 MFTB8
  { 0, 0, 0, 0, 0 }, // 446 XXSETACCZ
  { 0, 0, 0, 0, 0 }, // 447 XVBF16GER2_XVF16GER2_XVF32GER_XVF64GER_XVI16GER2_XVI16GER2S_XVI4GER8_XVI8GER4
  { 0, 0, 0, 0, 0 }, // 448 XVBF16GER2NN_XVBF16GER2NP_XVBF16GER2PN_XVBF16GER2PP_XVF16GER2NN_XVF16GER2NP_XVF16GER2PN_XVF16GER2PP_XVF32GERNN_XVF32GERNP_XVF32GERPN_XVF32GERPP_XVF64GERNN_XVF64GERNP_XVF64GERPN_XVF64GERPP_XVI16GER2PP_XVI16GER2SPP_XVI4GER8PP_XVI8GER4PP
  { 0, 0, 0, 0, 0 }, // 449 XVI8GER4SPP
  { 0, 0, 0, 0, 0 }, // 450 PMXVF32GER_PMXVF64GER
  { 0, 0, 0, 0, 0 }, // 451 PMXVBF16GER2_PMXVF16GER2_PMXVF32GERNN_PMXVF32GERNP_PMXVF32GERPN_PMXVF32GERPP_PMXVF64GERNN_PMXVF64GERNP_PMXVF64GERPN_PMXVF64GERPP_PMXVI16GER2_PMXVI16GER2S_PMXVI4GER8_PMXVI8GER4
  { 0, 0, 0, 0, 0 }, // 452 PMXVBF16GER2NN_PMXVBF16GER2NP_PMXVBF16GER2PN_PMXVBF16GER2PP_PMXVF16GER2NN_PMXVF16GER2NP_PMXVF16GER2PN_PMXVF16GER2PP_PMXVI16GER2PP_PMXVI16GER2SPP_PMXVI4GER8PP_PMXVI8GER4PP
  { 0, 0, 0, 0, 0 }, // 453 PMXVI8GER4SPP
  { 0, 0, 0, 0, 0 }, // 454 XXMTACC
  { 0, 0, 0, 0, 0 }, // 455 XXMFACC
  { 0, 0, 0, 0, 0 }, // 456 MULLD_MULLDO
  { 0, 0, 0, 0, 0 }, // 457 VMULHSD_VMULHUD_VMULLD
  { 0, 0, 0, 0, 0 }, // 458 VSPLTISW
  { 0, 0, 0, 0, 0 }, // 459 V_SETALLONES_V_SETALLONESB_V_SETALLONESH
  { 0, 0, 0, 0, 0 }, // 460 MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VPRTYBQ
  { 0, 0, 0, 0, 0 }, // 461 VGBBD_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW
  { 0, 0, 0, 0, 0 }, // 462 VSPLTISB_VSPLTISH_XXSPLTIB
  { 0, 0, 0, 0, 0 }, // 463 VSTRIBL_VSTRIBR_VSTRIHL_VSTRIHR
  { 0, 0, 0, 0, 0 }, // 464 XVCVBF16SPN
  { 0, 0, 0, 0, 0 }, // 465 VBPERMQ_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLO_VSLV_VSR_VSRO_VSRV_XXEXTRACTUW
  { 0, 0, 0, 0, 0 }, // 466 VCLRLB_VCLRRB_XXGENPCVDM_XXGENPCVHM_XXGENPCVWM
  { 0, 0, 0, 0, 0 }, // 467 VEXTRACTD_VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VINSERTD_VINSERTW
  { 0, 0, 0, 0, 0 }, // 468 VEXTDDVLX_VEXTDDVRX_VEXTDUBVLX_VEXTDUBVRX_VEXTDUHVLX_VEXTDUHVRX_VEXTDUWVLX_VEXTDUWVRX_VINSBLX_VINSBRX_VINSBVLX_VINSBVRX_VINSD_VINSDLX_VINSDRX_VINSHLX_VINSHRX_VINSHVLX_VINSHVRX_VINSW_VINSWLX_VINSWRX_VINSWVLX_VINSWVRX_VSLDBI_VSRDBI
  { 0, 0, 0, 0, 0 }, // 469 VSUMSWS
  { 0, 0, 0, 0, 0 }, // 470 XXSPLTIDP_XXSPLTIW
  { 0, 0, 0, 0, 0 }, // 471 XXBLENDVB_XXBLENDVD_XXBLENDVH_XXBLENDVW_XXSPLTI32DX
  { 0, 0, 0, 0, 0 }, // 472 XXEVAL
  { 0, 0, 0, 0, 0 }, // 473 XXPERMX
  { 1, 184, 185, 1565, 1568 }, // 474 DCBST_DCBZ
  { 1, 184, 185, 1568, 1571 }, // 475 ICBI
  { 1, 184, 185, 1571, 1574 }, // 476 DCBF
  { 1, 184, 185, 1574, 1577 }, // 477 PSTXVP_PSTXVPpc
  { 1, 184, 185, 1577, 1580 }, // 478 STB_STB8_STDBRX_STH_STH8_STHBRX_STW_STW8_STWBRX
  { 0, 0, 0, 0, 0 }, // 479 SPILLTOVSR_ST
  { 1, 184, 185, 1580, 1583 }, // 480 STD
  { 0, 0, 0, 0, 0 }, // 481 DFSTOREf32_DFSTOREf64_STIWX
  { 1, 184, 185, 1583, 1586 }, // 482 STXVRBX_STXVRDX_STXVRHX_STXVRWX
  { 0, 0, 0, 0, 0 }, // 483 SPILLTOVSR_STX
  { 1, 184, 185, 1586, 1589 }, // 484 EnforceIEIO
  { 1, 184, 185, 1589, 1592 }, // 485 STBCIX_STDCIX_STHCIX_STWCIX
  { 1, 184, 185, 1592, 1595 }, // 486 PSTB_PSTB8_PSTB8pc_PSTBpc_PSTD_PSTDpc_PSTFD_PSTFDpc_PSTFS_PSTFSpc_PSTH_PSTH8_PSTH8pc_PSTHpc_PSTW_PSTW8_PSTW8pc_PSTWpc_PSTXSD_PSTXSDpc_PSTXSSP_PSTXSSPpc_PSTXV_PSTXVpc
  { 1, 184, 185, 1595, 1598 }, // 487 STXVP_STXVPX
  { 1, 184, 185, 1598, 1601 }, // 488 ATTN_NAP
  { 1, 184, 185, 1601, 1604 }, // 489 DCBZL
  { 1, 184, 185, 1604, 1607 }, // 490 DCCCI_ICBLQ_ICCCI_TLBLD_TLBLI_TLBRE2_TLBSX2_TLBSX2D_TLBWE2
  { 1, 184, 185, 1607, 1610 }, // 491 ICBLC
  { 1, 184, 185, 1610, 1613 }, // 492 CLRBHRB
  { 1, 184, 185, 1613, 1616 }, // 493 MFBHRBE
  { 1, 184, 185, 1616, 1619 }, // 494 PADDI_PADDI8_PADDI8pc_PADDIpc
  { 1, 184, 185, 1619, 1622 }, // 495 PLI_PLI8
  { 0, 0, 0, 0, 0 }, // 496 VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS
  { 0, 0, 0, 0, 0 }, // 497 VMULESD_VMULEUD_VMULHSW_VMULHUW_VMULOSD_VMULOUD
  { 0, 0, 0, 0, 0 }, // 498 VMSUMCUD
  { 0, uint16_t(~0U), uint16_t(~0U), uint16_t(~0U), uint16_t(~0U) }// end marker
};

static const llvm::InstrItinerary PPCE500Itineraries[] = {
  { 0, 0, 0, 0, 0 }, // 0 NoInstrModel
  { 1, 186, 188, 0, 0 }, // 1 IIC_LdStSync
  { 1, 188, 190, 1622, 1625 }, // 2 IIC_IntSimple
  { 1, 188, 190, 1625, 1628 }, // 3 IIC_IntGeneral
  { 1, 190, 192, 1628, 1630 }, // 4 IIC_BrB
  { 0, 0, 0, 0, 0 }, // 5 IIC_VecFP
  { 1, 188, 190, 1630, 1633 }, // 6 IIC_IntCompare
  { 0, 0, 0, 0, 0 }, // 7 IIC_SprABORT
  { 0, 0, 0, 0, 0 }, // 8 IIC_LdStCOPY
  { 0, 0, 0, 0, 0 }, // 9 IIC_LdStPASTE
  { 1, 190, 192, 1633, 1636 }, // 10 IIC_BrCR
  { 0, 0, 0, 0, 0 }, // 11 IIC_LdStLD
  { 1, 186, 188, 1636, 1638 }, // 12 IIC_LdStDCBF
  { 1, 186, 188, 1638, 1640 }, // 13 IIC_LdStLoad
  { 0, 0, 0, 0, 0 }, // 14 IIC_IntDivD
  { 1, 192, 195, 1640, 1643 }, // 15 IIC_IntDivW
  { 1, 195, 197, 1643, 1646 }, // 16 IIC_FPDGeneral
  { 0, 0, 0, 0, 0 }, // 17 IIC_FPAddSub
  { 1, 197, 199, 1646, 1649 }, // 18 IIC_FPDivD
  { 1, 199, 201, 1649, 1652 }, // 19 IIC_FPSGeneral
  { 0, 0, 0, 0, 0 }, // 20 IIC_FPCompare
  { 0, 0, 0, 0, 0 }, // 21 IIC_FPGeneral
  { 1, 201, 203, 1652, 1655 }, // 22 IIC_VecGeneral
  { 1, 199, 201, 1655, 1658 }, // 23 IIC_VecComplex
  { 1, 186, 188, 1658, 1660 }, // 24 IIC_LdStStore
  { 0, 0, 0, 0, 0 }, // 25 IIC_IntRotateDI
  { 1, 203, 205, 1660, 1663 }, // 26 IIC_FPDivS
  { 0, 0, 0, 0, 0 }, // 27 IIC_FPFused
  { 0, 0, 0, 0, 0 }, // 28 IIC_FPSqrtD
  { 0, 0, 0, 0, 0 }, // 29 IIC_FPSqrtS
  { 1, 186, 188, 1663, 1665 }, // 30 IIC_LdStICBI
  { 1, 188, 190, 1665, 1669 }, // 31 IIC_IntISEL
  { 0, 0, 0, 0, 0 }, // 32 IIC_SprISYNC
  { 1, 205, 207, 1669, 1672 }, // 33 IIC_LdStLWARX
  { 2, 207, 210, 1672, 1674 }, // 34 IIC_LdStLoadUpd
  { 2, 207, 210, 1674, 1676 }, // 35 IIC_LdStLoadUpdX
  { 0, 0, 0, 0, 0 }, // 36 IIC_LdStLDARX
  { 0, 0, 0, 0, 0 }, // 37 IIC_LdStLDU
  { 0, 0, 0, 0, 0 }, // 38 IIC_LdStLDUX
  { 0, 0, 0, 0, 0 }, // 39 IIC_LdStLFD
  { 0, 0, 0, 0, 0 }, // 40 IIC_LdStLFDU
  { 0, 0, 0, 0, 0 }, // 41 IIC_LdStLFDUX
  { 1, 186, 188, 1676, 1678 }, // 42 IIC_LdStLHA
  { 1, 207, 210, 1678, 1680 }, // 43 IIC_LdStLHAU
  { 1, 207, 210, 1680, 1682 }, // 44 IIC_LdStLHAUX
  { 1, 186, 188, 1682, 1684 }, // 45 IIC_LdStLMW
  { 0, 0, 0, 0, 0 }, // 46 IIC_LdStLQ
  { 0, 0, 0, 0, 0 }, // 47 IIC_LdStLQARX
  { 0, 0, 0, 0, 0 }, // 48 IIC_LdStLWA
  { 0, 0, 0, 0, 0 }, // 49 IIC_IntMulHD
  { 1, 190, 192, 1684, 1686 }, // 50 IIC_BrMCR
  { 1, 188, 190, 1686, 1689 }, // 51 IIC_BrMCRX
  { 1, 210, 212, 1689, 1691 }, // 52 IIC_SprMFCR
  { 1, 188, 190, 1691, 1693 }, // 53 IIC_SprMFSPR
  { 0, 0, 0, 0, 0 }, // 54 IIC_IntMFFS
  { 1, 212, 214, 1693, 1695 }, // 55 IIC_SprMFMSR
  { 1, 210, 212, 1695, 1697 }, // 56 IIC_SprMFCRF
  { 1, 212, 214, 1697, 1699 }, // 57 IIC_SprMFPMR
  { 1, 212, 214, 1699, 1701 }, // 58 IIC_SprMFSR
  { 1, 212, 214, 1701, 1703 }, // 59 IIC_SprMFTB
  { 0, 0, 0, 0, 0 }, // 60 IIC_SprMSGSYNC
  { 1, 188, 190, 1703, 1705 }, // 61 IIC_SprMTSPR
  { 0, 0, 0, 0, 0 }, // 62 IIC_IntMTFSB0
  { 1, 214, 216, 1705, 1707 }, // 63 IIC_SprMTMSR
  { 0, 0, 0, 0, 0 }, // 64 IIC_SprMTMSRD
  { 1, 201, 203, 1707, 1709 }, // 65 IIC_SprMTPMR
  { 1, 201, 203, 1709, 1711 }, // 66 IIC_SprMTSR
  { 1, 199, 201, 1711, 1714 }, // 67 IIC_IntMulHW
  { 1, 199, 201, 1714, 1717 }, // 68 IIC_IntMulHWU
  { 1, 199, 201, 1717, 1720 }, // 69 IIC_IntMulLI
  { 0, 0, 0, 0, 0 }, // 70 IIC_SprRFI
  { 0, 0, 0, 0, 0 }, // 71 IIC_IntRFID
  { 0, 0, 0, 0, 0 }, // 72 IIC_IntRotateD
  { 1, 188, 190, 1720, 1723 }, // 73 IIC_IntRotate
  { 0, 0, 0, 0, 0 }, // 74 IIC_SprSLBFEE
  { 0, 0, 0, 0, 0 }, // 75 IIC_SprSLBIA
  { 0, 0, 0, 0, 0 }, // 76 IIC_SprSLBIE
  { 0, 0, 0, 0, 0 }, // 77 IIC_SprSLBIEG
  { 0, 0, 0, 0, 0 }, // 78 IIC_SprSLBMFEE
  { 0, 0, 0, 0, 0 }, // 79 IIC_SprSLBMFEV
  { 0, 0, 0, 0, 0 }, // 80 IIC_SprSLBMTE
  { 0, 0, 0, 0, 0 }, // 81 IIC_SprSLBSYNC
  { 1, 188, 190, 1723, 1726 }, // 82 IIC_IntShift
  { 1, 186, 188, 1726, 1728 }, // 83 IIC_LdStSTWCX
  { 2, 207, 210, 1728, 1730 }, // 84 IIC_LdStSTU
  { 2, 207, 210, 1730, 1732 }, // 85 IIC_LdStSTUX
  { 0, 0, 0, 0, 0 }, // 86 IIC_LdStSTD
  { 0, 0, 0, 0, 0 }, // 87 IIC_LdStSTDCX
  { 0, 0, 0, 0, 0 }, // 88 IIC_LdStSTFD
  { 0, 0, 0, 0, 0 }, // 89 IIC_LdStSTFDU
  { 0, 0, 0, 0, 0 }, // 90 IIC_SprSTOP
  { 0, 0, 0, 0, 0 }, // 91 IIC_LdStSTQ
  { 0, 0, 0, 0, 0 }, // 92 IIC_LdStSTQCX
  { 0, 0, 0, 0, 0 }, // 93 IIC_IntTrapD
  { 0, 0, 0, 0, 0 }, // 94 IIC_SprTLBIA
  { 0, 0, 0, 0, 0 }, // 95 IIC_SprTLBIE
  { 0, 0, 0, 0, 0 }, // 96 IIC_SprTLBIEL
  { 1, 216, 218, 0, 0 }, // 97 IIC_SprTLBSYNC
  { 1, 218, 220, 1732, 1734 }, // 98 IIC_IntTrapW
  { 0, 0, 0, 0, 0 }, // 99 IIC_VecFPCompare
  { 0, 0, 0, 0, 0 }, // 100 IIC_VecPerm
  { 1, 201, 203, 1734, 1737 }, // 101 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VSLD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_VPOPCNTB_VPOPCNTH_VSRAD_MTVSRDD_VEQV_VNAND_VNEGD_VNEGW_VORC_XXLAND_XXLANDC_XXLEQV_XXLEQVOnes_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 0, 0, 0, 0, 0 }, // 102 VAND_VANDC_V_SET0_V_SET0B_V_SET0H_VSLB_VSLH_VSLW_VSRB_VSRH_VSRW_VRLB_VRLD_VRLH_VRLW_VSRAB_VSRAH_VSRAW_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP_XVXEXPDP_XVXEXPSP_VRLDMI_VRLDNM_VRLWMI_VRLWNM_VMRGEW_VMRGOW_VNOR_VOR_VSEL_VXOR_XVNEGDP_XVNEGSP_XSABSQP_XSCPSGNQP_XSIEXPQP_XSNABSQP_XSNEGQP_XSXEXPQP
  { 0, 0, 0, 0, 0 }, // 103 XXSEL
  { 1, 188, 190, 1737, 1739 }, // 104 TABORTDC_TABORTDCI_TABORTWC_TABORTWCI
  { 0, 0, 0, 0, 0 }, // 105 MTFSB0_MTFSB1
  { 0, 0, 0, 0, 0 }, // 106 MFFSCDRN_MFFSCDRNI_MFFSCRN_MFFSCRNI
  { 1, 188, 190, 1739, 1742 }, // 107 CMPRB_CMPRB8_CMPEQB
  { 0, 0, 0, 0, 0 }, // 108 TD_TDI
  { 1, 218, 220, 1742, 1744 }, // 109 TW_TWI
  { 0, 0, 0, 0, 0 }, // 110 FCMPOD_FCMPOS_FCMPUD_FCMPUS_FTDIV_FTSQRT
  { 0, 0, 0, 0, 0 }, // 111 XSTSTDCDP_XSTSTDCSP
  { 0, 0, 0, 0, 0 }, // 112 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP_XSXSIGDP_XSCVSPDPN
  { 0, 0, 0, 0, 0 }, // 113 XSCMPEQDP_XSCMPEXPDP_XSCMPGEDP_XSCMPGTDP_XSCMPODP_XSCMPUDP_XSTDIVDP_XSTSQRTDP
  { 1, 188, 190, 1744, 1747 }, // 114 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW_CMPB_CMPB8_SETB_SETB8_BPERMD
  { 0, 0, 0, 0, 0 }, // 115 SLD_SRD_SRAD
  { 0, 0, 0, 0, 0 }, // 116 SRADI_EXTSWSLI_32_64_EXTSWSLI_SRADI_32_RLDIC
  { 1, 201, 203, 1747, 1750 }, // 117 MFVRD_MFVSRD_MTVRD_MTVSRD_MTVRWA_MTVRWZ_MTVSRWA_MTVSRWZ_MFVSRWZ_MFVRWZ
  { 1, 188, 190, 1750, 1753 }, // 118 CMPLW_CMPLWI_CMPW_CMPWI_CMPD_CMPDI_CMPLD_CMPLDI
  { 1, 188, 190, 1753, 1756 }, // 119 SUBFC_SUBFC8_SUBFC8O_SUBFCO_SUBFIC_SUBFIC8_ANDI8_rec_ANDIS8_rec_ANDIS_rec_ANDI_rec_ADDC_ADDC8_ADDC8O_ADDCO_ADDIC_ADDIC8_ADDIC_rec_ADDE_ADDE8_ADDE8O_ADDE8O_rec_ADDE8_rec_ADDEO_ADDEO_rec_ADDE_rec_ADDME_ADDME8_ADDME8O_ADDME8O_rec_ADDME8_rec_ADDMEO_ADDMEO_rec_ADDME_rec_ADDZE_ADDZE8_ADDZE8O_ADDZE8O_rec_ADDZE8_rec_ADDZEO_ADDZEO_rec_ADDZE_rec_SUBF_SUBF8_SUBF8O_SUBF8O_rec_SUBF8_rec_SUBFE_SUBFE8_SUBFE8O_SUBFE8O_rec_SUBFE8_rec_SUBFEO_SUBFEO_rec_SUBFE_rec_SUBFME_SUBFME8_SUBFME8O_SUBFME8O_rec_SUBFME8_rec_SUBFMEO_SUBFMEO_rec_SUBFME_rec_SUBFO_SUBFO_rec_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZE8O_rec_SUBFZE8_rec_SUBFZEO_SUBFZEO_rec_SUBFZE_rec_SUBF_rec_POPCNTB_POPCNTB8_LA_LA8
  { 1, 188, 190, 1756, 1759 }, // 120 ADD4_ADD4O_ADD4O_rec_ADD4_rec_ADD8_ADD8O_ADD8O_rec_ADD8_rec_NEG_NEG8_NEG8O_NEG8O_rec_NEG8_rec_NEGO_NEGO_rec_NEG_rec_ADDI_ADDI8_ADDIS_ADDIS8_LI_LI8_LIS_LIS8_OR_OR8_OR8_rec_ORI_ORI8_ORIS_ORIS8_OR_rec_XOR_XOR8_XOR8_rec_XORI_XORI8_XORIS_XORIS8_XOR_rec_NAND_NAND8_NAND8_rec_NAND_rec_AND_AND8_AND8_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_AND_rec_NOR_NOR8_NOR8_rec_NOR_rec_ORC_ORC8_ORC8_rec_ORC_rec_EQV_EQV8_EQV8_rec_EQV_rec_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_ADD4TLS_ADD8TLS_ADD8TLS__NOP
  { 0, 0, 0, 0, 0 }, // 121 ADDIStocHA_ADDIStocHA8_ADDItocL_COPY
  { 1, 190, 192, 1759, 1761 }, // 122 MCRF
  { 1, 188, 190, 1761, 1764 }, // 123 MCRXRX
  { 0, 0, 0, 0, 0 }, // 124 XSNABSDP_XSXEXPDP_XSABSDP_XSNEGDP_XSCPSGNDP
  { 1, 190, 192, 1764, 1766 }, // 125 RFEBB
  { 1, 188, 190, 1766, 1768 }, // 126 TBEGIN_TRECHKPT
  { 1, 186, 188, 1768, 1770 }, // 127 WAIT
  { 0, 0, 0, 0, 0 }, // 128 RLDCL_RLDCR
  { 1, 188, 190, 1770, 1773 }, // 129 RLWIMI_RLWIMI8
  { 0, 0, 0, 0, 0 }, // 130 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32_RLDIMI
  { 1, 210, 212, 1773, 1775 }, // 131 MFOCRF_MFOCRF8
  { 1, 188, 190, 1775, 1778 }, // 132 MTOCRF_MTOCRF8
  { 1, 190, 192, 1778, 1781 }, // 133 CR6SET_CR6UNSET_CRSET_CRUNSET_CRAND_CRANDC_CRNAND_CRNOR_CROR_CRORC_CREQV_CRXOR
  { 1, 188, 190, 1781, 1784 }, // 134 SLW_SLW8_SRW_SRW8_RLWINM_RLWINM8_RLWNM_RLWNM8
  { 0, 0, 0, 0, 0 }, // 135 FABSD_FABSS_FNABSD_FNABSS_FNEGD_FNEGS_FCPSGND_FCPSGNS_FMR
  { 1, 188, 190, 1784, 1787 }, // 136 SRAW_SRAWI
  { 1, 188, 190, 1787, 1791 }, // 137 ISEL_ISEL8
  { 0, 0, 0, 0, 0 }, // 138 XSIEXPDP
  { 1, 188, 190, 1791, 1793 }, // 139 TRECLAIM_TSR_TABORT
  { 1, 186, 188, 1793, 1795 }, // 140 MFVSCR
  { 1, 186, 188, 1795, 1797 }, // 141 MTVSCR
  { 0, 0, 0, 0, 0 }, // 142 VCMPNEZB_VCMPNEZH_VCMPNEZW_VCMPEQUB_VCMPEQUD_VCMPEQUH_VCMPEQUW_VCMPNEB_VCMPNEH_VCMPNEW_VCMPEQFP_VCMPEQFP_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPBFP_VCMPBFP_rec_VCMPGTSB_VCMPGTSB_rec_VCMPGTSD_VCMPGTSD_rec_VCMPGTSH_VCMPGTSH_rec_VCMPGTSW_VCMPGTSW_rec_VCMPGTUB_VCMPGTUB_rec_VCMPGTUD_VCMPGTUD_rec_VCMPGTUH_VCMPGTUH_rec_VCMPGTUW_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 1, 201, 203, 1797, 1800 }, // 143 VABSDUB_VABSDUH_VABSDUW_VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTW_VPOPCNTD_VPRTYBD_VPRTYBW
  { 0, 0, 0, 0, 0 }, // 144 VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VADDSBS_VADDSHS_VADDSWS_VMAXFP_VMINFP_VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW_VBPERMD_VADDCUW_VSHASIGMAD_VSHASIGMAW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_VSUBCUW_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP_XVXSIGDP_XVXSIGSP
  { 0, 0, 0, 0, 0 }, // 145 XVTDIVDP_XVTDIVSP_XVTSQRTDP_XVTSQRTSP
  { 0, 0, 0, 0, 0 }, // 146 VADDFP_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VEXPTEFP_VLOGEFP_VMADDFP_VMHADDSHS_VNMSUBFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVADDDP_XVADDSP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVHPSP_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVMULDP_XVMULSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP_XVSUBDP_XVSUBSP_VCFSX_VCFSX_0_VCFUX_VCFUX_0_VMHRADDSHS_VMLADDUHM_VMSUMMBM_VMSUMSHM_VMSUMSHS_VMSUMUBM_VMSUMUHM_VMSUMUDM_VMSUMUHS_VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS_VSUMSWS
  { 1, 201, 203, 1800, 1803 }, // 147 VSUBFP_VMULUWM
  { 0, 0, 0, 0, 0 }, // 148 MADDHD_MADDHDU_MADDLD_MADDLD8_MULLD_MULLDO
  { 1, 199, 201, 1803, 1806 }, // 149 MULHD_MULHW_MULLW_MULLWO
  { 1, 199, 201, 1806, 1809 }, // 150 MULHDU_MULHWU
  { 1, 199, 201, 1809, 1812 }, // 151 MULLI_MULLI8
  { 0, 0, 0, 0, 0 }, // 152 FRSP_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRE_FRES_FADDS_FMSUBS_FMADDS_FSUBS_FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRSQRTE_FRSQRTES_FNMADDS_FNMSUBS_FSELD_FSELS_FMULS
  { 0, 0, 0, 0, 0 }, // 153 FADD_FSUB
  { 0, 0, 0, 0, 0 }, // 154 FMSUB_FMADD_FNMADD_FNMSUB_FMUL
  { 0, 0, 0, 0, 0 }, // 155 XSMADDADP_XSMADDASP_XSMADDMDP_XSMADDMSP_XSMSUBADP_XSMSUBASP_XSMSUBMDP_XSMSUBMSP_XSMULDP_XSMULSP_XSNMADDADP_XSNMADDASP_XSNMADDMDP_XSNMADDMSP_XSNMSUBADP_XSNMSUBASP_XSNMSUBMDP_XSNMSUBMSP
  { 0, 0, 0, 0, 0 }, // 156 FSELD_rec_FSELS_rec
  { 1, 199, 201, 1812, 1815 }, // 157 MULHDU_rec_MULHWU_rec
  { 1, 199, 201, 1815, 1818 }, // 158 MULHD_rec_MULHW_rec_MULLWO_rec_MULLW_rec
  { 0, 0, 0, 0, 0 }, // 159 MULLDO_rec_MULLD_rec
  { 0, 0, 0, 0, 0 }, // 160 FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRES_rec_FRE_rec_FADDS_rec_FSUBS_rec_FMSUBS_rec_FNMSUBS_rec_FMADDS_rec_FNMADDS_rec_FCFIDS_rec_FCFIDUS_rec_FCFIDU_rec_FCFID_rec_FCTIDUZ_rec_FCTIDU_rec_FCTIDZ_rec_FCTID_rec_FCTIWUZ_rec_FCTIWU_rec_FCTIWZ_rec_FCTIW_rec_FMULS_rec_FRSQRTES_rec_FRSQRTE_rec_FRSP_rec
  { 0, 0, 0, 0, 0 }, // 161 FADD_rec_FSUB_rec
  { 0, 0, 0, 0, 0 }, // 162 FMSUB_rec_FNMSUB_rec_FMADD_rec_FNMADD_rec_FMUL_rec
  { 0, 0, 0, 0, 0 }, // 163 XSADDDP_XSADDSP_XSCVDPHP_XSCVDPSP_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPSXWSs_XSCVDPUXWSs_XSCVHPDP_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSQRTEDP_XSRSQRTESP_XSSUBDP_XSSUBSP_XSCVDPSPN_XSRSP
  { 1, 186, 188, 1818, 1820 }, // 164 LVSL_LVSR
  { 0, 0, 0, 0, 0 }, // 165 VSPLTISB_VSPLTISH_VSPLTISW_VSPLTB_VSPLTBs_VSPLTH_VSPLTHs_VSPLTW_XXMRGHW_XXMRGLW_XXPERM_XXPERMR_XXSLDWI_XXSLDWIs_XXSPLTIB_XXSPLTW_XXSPLTWs_XXPERMDI_XXPERMDIs
  { 0, 0, 0, 0, 0 }, // 166 V_SETALLONES_V_SETALLONESB_V_SETALLONESH_VBPERMQ_VGBBD_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPERM_VPERMR_VPERMXOR_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLDOI_VSLO_VSLV_VSR_VSRO_VSRV_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW_XXEXTRACTUW_XXINSERTW_VADDCUQ_VADDECUQ_VADDEUQM_VMUL10CUQ_VMUL10ECUQ_VMUL10EUQ_VMUL10UQ_VSUBCUQ_VSUBECUQ_VSUBEUQM_XSTSTDCQP_XSXSIGQP_BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDS_rec_BCDTRUNC_rec_BCDUS_rec_BCDUTRUNC_rec_BCDADD_rec_BCDSUB_rec
  { 1, 201, 203, 1820, 1823 }, // 167 VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VINSERTB_VINSERTD_VINSERTH_VINSERTW_MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VEXTRACTD_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VPRTYBQ_VADDUQM_VSUBUQM
  { 0, 0, 0, 0, 0 }, // 168 XSCMPEXPQP_XSCMPOQP_XSCMPUQP
  { 0, 0, 0, 0, 0 }, // 169 BCDSR_rec_XSADDQP_XSADDQPO_XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP_XSRQPI_XSRQPIX_XSRQPXP_XSSUBQP_XSSUBQPO
  { 0, 0, 0, 0, 0 }, // 170 BCDCTSQ_rec
  { 0, 0, 0, 0, 0 }, // 171 XSMADDQP_XSMADDQPO_XSMSUBQP_XSMSUBQPO_XSMULQP_XSMULQPO_XSNMADDQP_XSNMADDQPO_XSNMSUBQP_XSNMSUBQPO
  { 0, 0, 0, 0, 0 }, // 172 BCDCFSQ_rec
  { 0, 0, 0, 0, 0 }, // 173 XSDIVQP_XSDIVQPO
  { 0, 0, 0, 0, 0 }, // 174 XSSQRTQP_XSSQRTQPO
  { 1, 186, 188, 1823, 1825 }, // 175 LXVL_LXVLL
  { 1, 186, 188, 1825, 1827 }, // 176 LVEBX_LVEHX_LVEWX_LVX_LVXL
  { 0, 0, 0, 0, 0 }, // 177 LXSIBZX_LXSIHZX_LXSDX_LXVB16X_LXVD2X_LXVWSX_LXSIWZX_LXV_LXVX_LXSD
  { 0, 0, 0, 0, 0 }, // 178 DFLOADf64_XFLOADf64_LIWZX
  { 1, 186, 188, 1827, 1829 }, // 179 DCBF_DCBFEP_DCBST_DCBSTEP_DCBT_DCBTEP_DCBZ_DCBZEP_DCBZL_DCBZLEP_DCBTST_DCBTSTEP
  { 0, 0, 0, 0, 0 }, // 180 CP_COPY_CP_COPY8
  { 1, 186, 188, 1829, 1831 }, // 181 ICBI_ICBIEP
  { 1, 186, 188, 1831, 1833 }, // 182 ICBT_ICBTLS_LBZ_LBZ8_LBZCIX_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LDBRX_LDCIX_LHBRX_LHBRX8_LHZ_LHZ8_LHZCIX_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWBRX_LWBRX8_LWZ_LWZ8_LWZCIX_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32_EnforceIEIO_LSWI
  { 1, 205, 207, 1833, 1836 }, // 183 LBARX_LBARXL_LHARX_LHARXL_LWARX_LWARXL
  { 0, 0, 0, 0, 0 }, // 184 LD_LDX_LDXTLS_LDXTLS__DARN
  { 0, 0, 0, 0, 0 }, // 185 LDARX_LDARXL
  { 0, 0, 0, 0, 0 }, // 186 CP_ABORT
  { 0, 0, 0, 0, 0 }, // 187 ISYNC
  { 0, 0, 0, 0, 0 }, // 188 MSGSYNC
  { 1, 216, 218, 0, 0 }, // 189 TLBSYNC
  { 1, 186, 188, 0, 0 }, // 190 SYNC
  { 1, 186, 188, 1836, 1838 }, // 191 LMW
  { 0, 0, 0, 0, 0 }, // 192 LFIWZX_LFDX_LFD
  { 0, 0, 0, 0, 0 }, // 193 SLBIA
  { 0, 0, 0, 0, 0 }, // 194 SLBIE
  { 0, 0, 0, 0, 0 }, // 195 SLBMFEE
  { 0, 0, 0, 0, 0 }, // 196 SLBMFEV
  { 0, 0, 0, 0, 0 }, // 197 SLBMTE
  { 0, 0, 0, 0, 0 }, // 198 TLBIEL
  { 2, 207, 210, 1838, 1840 }, // 199 LHZU_LHZU8_LWZU_LWZU8
  { 2, 207, 210, 1840, 1842 }, // 200 LHZUX_LHZUX8_LWZUX_LWZUX8
  { 1, 188, 190, 1842, 1844 }, // 201 TEND
  { 1, 186, 188, 1844, 1846 }, // 202 STBCX_STHCX_STWCX
  { 0, 0, 0, 0, 0 }, // 203 STDCX
  { 0, 0, 0, 0, 0 }, // 204 LDMX
  { 1, 186, 188, 1846, 1848 }, // 205 LHA_LHA8_LHAX_LHAX8_LWAX_LWAX_32
  { 0, 0, 0, 0, 0 }, // 206 CP_PASTE8_rec_CP_PASTE_rec
  { 0, 0, 0, 0, 0 }, // 207 LWA_LWA_32
  { 1, 188, 190, 1848, 1850 }, // 208 TCHECK
  { 0, 0, 0, 0, 0 }, // 209 LFIWAX
  { 0, 0, 0, 0, 0 }, // 210 LXSIWAX
  { 0, 0, 0, 0, 0 }, // 211 LIWAX
  { 0, 0, 0, 0, 0 }, // 212 LFSX_LFS
  { 0, 0, 0, 0, 0 }, // 213 LXSSP_LXSSPX
  { 0, 0, 0, 0, 0 }, // 214 XFLOADf32_DFLOADf32
  { 1, 207, 210, 1850, 1852 }, // 215 LHAU_LHAU8
  { 1, 207, 210, 1852, 1854 }, // 216 LHAUX_LHAUX8_LWAUX
  { 0, 0, 0, 0, 0 }, // 217 LXVH8X_LXVDSX_LXVW4X
  { 0, 0, 0, 0, 0 }, // 218 STFD_STFDX_STFIWX_STFS_STFSX_STXSD_STXSDX_STXSIBX_STXSIBXv_STXSIHX_STXSIHXv_STXSIWX_STXSSP_STXSSPX
  { 1, 186, 188, 1854, 1856 }, // 219 STW_STW8_STDBRX_STHBRX_STWBRX_STB_STB8_STH_STH8_STBX_STBX8_STBXTLS_STBXTLS__STBXTLS_32_STHX_STHX8_STHXTLS_STHXTLS__STHXTLS_32_STWX_STWX8_STWXTLS_STWXTLS__STWXTLS_32
  { 0, 0, 0, 0, 0 }, // 220 DFSTOREf32_DFSTOREf64_XFSTOREf32_XFSTOREf64_STIWX
  { 0, 0, 0, 0, 0 }, // 221 STD_STDX_STDXTLS_STDXTLS_
  { 1, 186, 188, 1856, 1858 }, // 222 STBCIX_STDCIX_STHCIX_STWCIX_STSWI
  { 0, 0, 0, 0, 0 }, // 223 SLBIEG
  { 1, 186, 188, 1858, 1860 }, // 224 STMW
  { 0, 0, 0, 0, 0 }, // 225 TLBIE
  { 1, 186, 188, 1860, 1862 }, // 226 STVEBX_STVEHX_STVEWX_STVX_STVXL
  { 0, 0, 0, 0, 0 }, // 227 STXV_STXVB16X_STXVD2X_STXVH8X_STXVW4X_STXVX
  { 1, 186, 188, 1862, 1864 }, // 228 STXVL_STXVLL
  { 1, 188, 190, 1864, 1866 }, // 229 MTCTR_MTCTR8_MTCTR8loop_MTCTRloop_MTLR_MTLR8
  { 1, 188, 190, 1866, 1869 }, // 230 MFVRSAVE_MFVRSAVEv_MTVRSAVE_MTVRSAVEv
  { 1, 212, 214, 1869, 1871 }, // 231 MFPMR
  { 1, 201, 203, 1871, 1873 }, // 232 MTPMR
  { 1, 212, 214, 1873, 1875 }, // 233 MFTB_MFTB8
  { 1, 188, 190, 1875, 1877 }, // 234 MFCTR_MFCTR8_MFLR_MFLR8_MFSPR_MFSPR8
  { 1, 212, 214, 1877, 1879 }, // 235 MFMSR
  { 1, 214, 216, 1879, 1881 }, // 236 MTMSR
  { 0, 0, 0, 0, 0 }, // 237 MTMSRD
  { 1, 188, 190, 1881, 1883 }, // 238 MTSPR_MTSPR8
  { 1, 192, 195, 1883, 1886 }, // 239 DIVW_DIVWO_DIVWU_DIVWUO_MODSW
  { 1, 192, 195, 1886, 1889 }, // 240 DIVWE_DIVWEO_DIVWEU_DIVWEUO_MODSD_MODUD_MODUW
  { 0, 0, 0, 0, 0 }, // 241 DIVD_DIVDO_DIVDU_DIVDUO
  { 0, 0, 0, 0, 0 }, // 242 DIVDE_DIVDEO_DIVDEU_DIVDEUO
  { 1, 192, 195, 1889, 1892 }, // 243 DIVWO_rec_DIVWUO_rec_DIVWU_rec_DIVW_rec
  { 0, 0, 0, 0, 0 }, // 244 DIVD_rec_DIVDO_rec_DIVDU_rec_DIVDUO_rec
  { 1, 192, 195, 1892, 1895 }, // 245 DIVWE_rec_DIVWEO_rec_DIVWEU_rec_DIVWEUO_rec
  { 0, 0, 0, 0, 0 }, // 246 DIVDE_rec_DIVDEO_rec_DIVDEU_rec_DIVDEUO_rec
  { 1, 188, 190, 1895, 1898 }, // 247 MTCRF_MTCRF8
  { 1, 188, 190, 1898, 1901 }, // 248 ADDC8O_rec_ADDC8_rec_ADDCO_rec_ADDC_rec_SUBFC8O_rec_SUBFC8_rec_SUBFCO_rec_SUBFC_rec
  { 0, 0, 0, 0, 0 }, // 249 FABSD_rec_FABSS_rec_FNABSD_rec_FNABSS_rec_FCPSGND_rec_FCPSGNS_rec_FNEGD_rec_FNEGS_rec_FMR_rec
  { 1, 190, 192, 1901, 1903 }, // 250 MCRFS
  { 0, 0, 0, 0, 0 }, // 251 MTFSF_MTFSF_rec_MTFSFI_MTFSFI_rec_MTFSFIb
  { 0, 0, 0, 0, 0 }, // 252 MTFSFb
  { 0, 0, 0, 0, 0 }, // 253 RLDCL_rec_RLDCR_rec
  { 0, 0, 0, 0, 0 }, // 254 RLDICL_rec_RLDICR_rec_RLDICL_32_rec_RLDIMI_rec
  { 1, 188, 190, 1903, 1906 }, // 255 RLWIMI8_rec_RLWIMI_rec
  { 1, 188, 190, 1906, 1909 }, // 256 RLWINM8_rec_RLWINM_rec_RLWNM8_rec_RLWNM_rec_SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 1, 188, 190, 1909, 1912 }, // 257 SRAWI_rec_SRAW_rec
  { 0, 0, 0, 0, 0 }, // 258 MFFS_MFFSCE_MFFSL_MFFS_rec
  { 1, 210, 212, 1912, 1914 }, // 259 MFCR_MFCR8
  { 0, 0, 0, 0, 0 }, // 260 EXTSWSLI_32_64_rec_SRADI_rec_EXTSWSLI_rec_RLDIC_rec
  { 0, 0, 0, 0, 0 }, // 261 SRAD_rec_SLD_rec_SRD_rec
  { 1, 197, 199, 1914, 1917 }, // 262 FDIV
  { 1, 197, 199, 1917, 1920 }, // 263 FDIV_rec
  { 0, 0, 0, 0, 0 }, // 264 XSSQRTDP
  { 0, 0, 0, 0, 0 }, // 265 FSQRT
  { 0, 0, 0, 0, 0 }, // 266 XVSQRTDP
  { 0, 0, 0, 0, 0 }, // 267 XVSQRTSP
  { 0, 0, 0, 0, 0 }, // 268 FSQRT_rec
  { 0, 0, 0, 0, 0 }, // 269 XSSQRTSP
  { 0, 0, 0, 0, 0 }, // 270 FSQRTS
  { 0, 0, 0, 0, 0 }, // 271 FSQRTS_rec
  { 1, 197, 199, 1920, 1923 }, // 272 XSDIVDP
  { 1, 203, 205, 1923, 1926 }, // 273 FDIVS
  { 1, 203, 205, 1926, 1929 }, // 274 FDIVS_rec
  { 1, 203, 205, 1929, 1932 }, // 275 XSDIVSP
  { 1, 203, 205, 1932, 1935 }, // 276 XVDIVSP
  { 1, 197, 199, 1935, 1938 }, // 277 XVDIVDP
  { 0, 0, 0, 0, 0 }, // 278 LFSU
  { 0, 0, 0, 0, 0 }, // 279 LFSUX
  { 0, 0, 0, 0, 0 }, // 280 STFDU_STFDUX_STFSU_STFSUX
  { 2, 207, 210, 1938, 1940 }, // 281 STBU_STBU8_STDU_STHU_STHU8_STWU_STWU8
  { 2, 207, 210, 1940, 1942 }, // 282 STBUX_STBUX8_STDUX_STHUX_STHUX8_STWUX_STWUX8
  { 2, 207, 210, 1942, 1944 }, // 283 LBZU_LBZU8
  { 2, 207, 210, 1944, 1946 }, // 284 LBZUX_LBZUX8
  { 0, 0, 0, 0, 0 }, // 285 LDU
  { 0, 0, 0, 0, 0 }, // 286 LDUX
  { 0, 0, 0, 0, 0 }, // 287 LFDU
  { 0, 0, 0, 0, 0 }, // 288 LFDUX
  { 0, 0, 0, 0, 0 }, // 289 VPMSUMB_VPMSUMD_VPMSUMH_VPMSUMW_VCIPHER_VCIPHERLAST_VNCIPHER_VNCIPHERLAST_VSBOX
  { 1, 190, 192, 1946, 1948 }, // 290 BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_BCCTR_BCCTR8_BCCTR8n_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_BCCTRn_BDNZ_BDNZ8_BDNZA_BDNZAm_BDNZAp_BDNZm_BDNZp_BDZ_BDZ8_BDZA_BDZAm_BDZAp_BDZm_BDZp_BDNZL_BDNZLA_BDNZLAm_BDNZLAp_BDNZLR_BDNZLR8_BDNZLRL_BDNZLRLm_BDNZLRLp_BDNZLRm_BDNZLRp_BDNZLm_BDNZLp_BDZL_BDZLA_BDZLAm_BDZLAp_BDZLR_BDZLR8_BDZLRL_BDZLRLm_BDZLRLp_BDZLRm_BDZLRp_BDZLm_BDZLp_BL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM_BLR_BLR8_BLRL_TAILB_TAILB8_TAILBA_TAILBA8_TAILBCTR_TAILBCTR8_gBC_gBCA_gBCAat_gBCCTR_gBCCTRL_gBCL_gBCLA_gBCLAat_gBCLR_gBCLRL_gBCLat_gBCat_BCLR_BCLRL_BCLRLn_BCLRn_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_RM_BCTRL_RM_B_BA_BC_BCC_BCCA_BCL_BCLalways_BCLn_BCTRL8_LDinto_toc_BCTRL_LWZinto_toc_BCTRL8_LDinto_toc_RM_BCTRL_LWZinto_toc_RM_BCn_CTRL_DEP
  { 1, 190, 192, 1948, 1950 }, // 291 ADDPCIS
  { 1, 186, 188, 1950, 1952 }, // 292 LDAT_LWAT
  { 1, 186, 188, 1952, 1954 }, // 293 STDAT_STWAT
  { 1, 188, 190, 1954, 1957 }, // 294 BRINC
  { 1, 201, 203, 1957, 1960 }, // 295 EVABS_EVEQV_EVNAND_EVNEG_EVADDIW_EVADDW_EVAND_EVANDC_EVCMPEQ_EVCMPGTS_EVCMPGTU_EVCMPLTS_EVCMPLTU_EVCNTLSW_EVCNTLZW_EVEXTSB_EVEXTSH_EVMERGEHI_EVMERGEHILO_EVMERGELO_EVMERGELOHI_EVNOR_EVOR_EVORC_EVXOR_EVRLW_EVRLWI_EVRNDW_EVSLW_EVSLWI_EVSPLATFI_EVSPLATI_EVSRWIS_EVSRWIU_EVSRWS_EVSRWU_EVSUBFW_EVSUBIFW
  { 1, 199, 201, 1960, 1963 }, // 296 EVMRA_EVADDSMIAAW_EVADDSSIAAW_EVADDUMIAAW_EVADDUSIAAW_EVDIVWS_EVDIVWU_EVMHEGSMFAA_EVMHEGSMFAN_EVMHEGSMIAA_EVMHEGSMIAN_EVMHEGUMIAA_EVMHEGUMIAN_EVMHESMF_EVMHESMFA_EVMHESMFAAW_EVMHESMFANW_EVMHESMI_EVMHESMIA_EVMHESMIAAW_EVMHESMIANW_EVMHESSF_EVMHESSFA_EVMHESSFAAW_EVMHESSFANW_EVMHESSIAAW_EVMHESSIANW_EVMHEUMI_EVMHEUMIA_EVMHEUMIAAW_EVMHEUMIANW_EVMHEUSIAAW_EVMHEUSIANW_EVMHOGSMFAA_EVMHOGSMFAN_EVMHOGSMIAA_EVMHOGSMIAN_EVMHOGUMIAA_EVMHOGUMIAN_EVMHOSMF_EVMHOSMFA_EVMHOSMFAAW_EVMHOSMFANW_EVMHOSMI_EVMHOSMIA_EVMHOSMIAAW_EVMHOSMIANW_EVMHOSSF_EVMHOSSFA_EVMHOSSFAAW_EVMHOSSFANW_EVMHOSSIAAW_EVMHOSSIANW_EVMHOUMI_EVMHOUMIA_EVMHOUMIAAW_EVMHOUMIANW_EVMHOUSIAAW_EVMHOUSIANW_EVMWHSMF_EVMWHSMFA_EVMWHSMI_EVMWHSMIA_EVMWHSSF_EVMWHSSFA_EVMWHUMI_EVMWHUMIA_EVMWLSMIAAW_EVMWLSMIANW_EVMWLSSIAAW_EVMWLSSIANW_EVMWLUMI_EVMWLUMIA_EVMWLUMIAAW_EVMWLUMIANW_EVMWLUSIAAW_EVMWLUSIANW_EVMWSMF_EVMWSMFA_EVMWSMFAA_EVMWSMFAN_EVMWSMI_EVMWSMIA_EVMWSMIAA_EVMWSMIAN_EVMWSSF_EVMWSSFA_EVMWSSFAA_EVMWSSFAN_EVMWUMI_EVMWUMIA_EVMWUMIAA_EVMWUMIAN_EVSUBFSMIAAW_EVSUBFSSIAAW_EVSUBFUMIAAW_EVSUBFUSIAAW
  { 1, 186, 188, 1963, 1965 }, // 297 EVLDD_EVLDDX_EVLDH_EVLDHX_EVLDW_EVLDWX_EVLHHESPLAT_EVLHHESPLATX_EVLHHOSSPLAT_EVLHHOSSPLATX_EVLHHOUSPLAT_EVLHHOUSPLATX_EVLWHE_EVLWHEX_EVLWHOS_EVLWHOSX_EVLWHOU_EVLWHOUX_EVLWHSPLAT_EVLWHSPLATX_EVLWWSPLAT_EVLWWSPLATX
  { 1, 186, 188, 1965, 1967 }, // 298 EVSTDD_EVSTDDX_EVSTDH_EVSTDHX_EVSTDW_EVSTDWX_EVSTWHE_EVSTWHEX_EVSTWHO_EVSTWHOX_EVSTWWE_EVSTWWEX_EVSTWWO_EVSTWWOX
  { 1, 190, 192, 1967, 1969 }, // 299 HRFID_ATTN_CLRBHRB_MFBHRBE_NAP_RFCI_RFDI_RFMCI_SC
  { 0, 0, 0, 0, 0 }, // 300 RFI
  { 0, 0, 0, 0, 0 }, // 301 RFID
  { 1, 186, 188, 1969, 1971 }, // 302 DSS_DSSALL_DST_DST64_DSTST_DSTST64_DSTSTT_DSTSTT64_DSTT_DSTT64_ICBLQ_LBEPX_LHEPX_LWEPX_TLBIVAX_TLBLD_TLBLI_TLBRE_TLBRE2_TLBSX_TLBSX2_TLBSX2D_TLBWE_TLBWE2_MBAR_TRAP_DCCCI_ICCCI
  { 1, 186, 188, 1971, 1973 }, // 303 ICBLC_STBEPX_STHEPX_STWEPX
  { 0, 0, 0, 0, 0 }, // 304 LFDEPX
  { 0, 0, 0, 0, 0 }, // 305 STFDEPX
  { 1, 212, 214, 1973, 1975 }, // 306 MFSR_MFSRIN
  { 1, 201, 203, 1975, 1977 }, // 307 MTSR_MTSRIN
  { 1, 188, 190, 1977, 1979 }, // 308 MFDCR
  { 1, 188, 190, 1979, 1981 }, // 309 MTDCR
  { 1, 188, 190, 1981, 1984 }, // 310 NOP_GT_PWR6_NOP_GT_PWR7
  { 0, 0, 0, 0, 0 }, // 311 TLBIA
  { 1, 214, 216, 1984, 1986 }, // 312 WRTEE_WRTEEI
  { 1, 188, 190, 1986, 1989 }, // 313 HASHCHK_HASHCHK8_HASHCHKP_HASHCHKP8_HASHST_HASHST8_HASHSTP_HASHSTP8_ADDEX_ADDEX8
  { 1, 186, 188, 0, 0 }, // 314 MSYNC
  { 0, 0, 0, 0, 0 }, // 315 SLBSYNC
  { 0, 0, 0, 0, 0 }, // 316 SLBFEE_rec
  { 0, 0, 0, 0, 0 }, // 317 STOP
  { 1, 186, 188, 1989, 1991 }, // 318 DCBA_DCBI
  { 0, 0, 0, 0, 0 }, // 319 FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRE_FRES_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRSP_FRSQRTE_FRSQRTES
  { 0, 0, 0, 0, 0 }, // 320 VCFSX_VCFSX_0_VCFUX_VCFUX_0_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VLOGEFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP
  { 0, 0, 0, 0, 0 }, // 321 XSCVDPHP_XSCVDPSP_XSCVDPSPN_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPSXWSs_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPUXWSs_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSP_XSRSQRTEDP_XSRSQRTESP
  { 0, 0, 0, 0, 0 }, // 322 XVCVSPBF16
  { 0, 0, 0, 0, 0 }, // 323 FADDS_FMULS_FSUBS
  { 0, 0, 0, 0, 0 }, // 324 FMUL
  { 0, 0, 0, 0, 0 }, // 325 VADDFP_XVADDDP_XVADDSP_XVMULDP_XVMULSP_XVSUBDP_XVSUBSP
  { 1, 201, 203, 1991, 1994 }, // 326 VSUBFP
  { 0, 0, 0, 0, 0 }, // 327 XSADDDP_XSADDSP_XSSUBDP_XSSUBSP
  { 0, 0, 0, 0, 0 }, // 328 XSMULDP_XSMULSP
  { 0, 0, 0, 0, 0 }, // 329 VMADDFP_VNMSUBFP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP
  { 0, 0, 0, 0, 0 }, // 330 VEXPTEFP
  { 0, 0, 0, 0, 0 }, // 331 FADDS_rec_FMULS_rec_FSUBS_rec
  { 0, 0, 0, 0, 0 }, // 332 FMUL_rec
  { 0, 0, 0, 0, 0 }, // 333 FCFID_rec_FCFIDS_rec_FCFIDU_rec_FCFIDUS_rec_FCTID_rec_FCTIDU_rec_FCTIDUZ_rec_FCTIDZ_rec_FCTIW_rec_FCTIWU_rec_FCTIWUZ_rec_FCTIWZ_rec_FRE_rec_FRES_rec_FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRSP_rec_FRSQRTE_rec_FRSQRTES_rec
  { 1, 190, 192, 1994, 1996 }, // 334 BCLR_BCLRn_BDNZLR_BDNZLR8_BDNZLRm_BDNZLRp_BDZLR_BDZLR8_BDZLRm_BDZLRp_gBCLR_BCLRL_BCLRLn_BDNZLRL_BDNZLRLm_BDNZLRLp_BDZLRL_BDZLRLm_BDZLRLp_gBCLRL_BL_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLR_BLR8_BLRL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS
  { 1, 190, 192, 1996, 1998 }, // 335 BL8_NOTOC_BL8_NOTOC_RM_BL8_NOTOC_TLS
  { 1, 190, 192, 1998, 2000 }, // 336 B_BCC_BCCA_BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_CTRL_DEP_TAILB_TAILB8_BA_TAILBA_TAILBA8_BC_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_LDinto_toc_BCTRL8_LDinto_toc_RM_BCTRL8_RM_BCTRL_LWZinto_toc_BCTRL_LWZinto_toc_RM_BCTRL_RM_BCn_BDNZ_BDNZ8_BDNZm_BDNZp_BDZ_BDZ8_BDZm_BDZp_TAILBCTR_TAILBCTR8_gBC_gBCat_BCL_BCLalways_BCLn_BDNZL_BDNZLm_BDNZLp_BDZL_BDZLm_BDZLp_gBCL_gBCLat_BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM
  { 1, 190, 192, 2000, 2002 }, // 337 BCCTR_BCCTR8_BCCTR8n_BCCTRn_gBCCTR_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_gBCCTRL
  { 0, 0, 0, 0, 0 }, // 338 VSBOX
  { 1, 188, 190, 2002, 2005 }, // 339 CFUGED_CNTLZDM_CNTTZDM_PDEPD_PEXTD
  { 1, 201, 203, 2005, 2008 }, // 340 VCFUGED_VCLZDM_VCTZDM_VGNB_VPDEPD_VPEXTD
  { 0, 0, 0, 0, 0 }, // 341 XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP
  { 0, 0, 0, 0, 0 }, // 342 XSCVQPSQZ_XSCVQPUQZ_XSCVSQQP_XSCVUQQP
  { 0, 0, 0, 0, 0 }, // 343 XSADDQP_XSADDQPO_XSSUBQP_XSSUBQPO
  { 1, 188, 190, 2008, 2011 }, // 344 HASHST_HASHST8_HASHSTP_HASHSTP8
  { 0, 0, 0, 0, 0 }, // 345 XSMULQP_XSMULQPO
  { 1, 201, 203, 2011, 2014 }, // 346 VDIVESQ_VDIVEUQ_VDIVSQ_VDIVUQ
  { 1, 201, 203, 2014, 2017 }, // 347 VMODSQ_VMODUQ
  { 1, 192, 195, 2017, 2020 }, // 348 DIVWE_DIVWEO_DIVWEU_DIVWEUO
  { 1, 201, 203, 2020, 2023 }, // 349 VDIVSD_VDIVUD
  { 1, 201, 203, 2023, 2026 }, // 350 VMODSD_VMODUD
  { 1, 201, 203, 2026, 2029 }, // 351 VDIVSW_VDIVUW
  { 1, 201, 203, 2029, 2032 }, // 352 VMODSW_VMODUW
  { 1, 201, 203, 2032, 2035 }, // 353 VDIVESD_VDIVEUD
  { 1, 201, 203, 2035, 2038 }, // 354 VDIVESW_VDIVEUW
  { 0, 0, 0, 0, 0 }, // 355 BCDCTN_rec_VMUL10CUQ_VMUL10UQ_XSXSIGQP
  { 0, 0, 0, 0, 0 }, // 356 BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDUS_rec_BCDUTRUNC_rec_VADDCUQ_VMUL10ECUQ_VMUL10EUQ_VSUBCUQ_XSTSTDCQP
  { 1, 201, 203, 2038, 2041 }, // 357 VADDUQM_VSUBUQM
  { 0, 0, 0, 0, 0 }, // 358 XSMAXCQP_XSMINCQP
  { 1, 201, 203, 2041, 2044 }, // 359 XXGENPCVBM
  { 0, 0, 0, 0, 0 }, // 360 BCDADD_rec_BCDS_rec_BCDSUB_rec_BCDTRUNC_rec_VADDECUQ_VADDEUQM_VSUBECUQ_VSUBEUQM
  { 1, 186, 188, 2044, 2046 }, // 361 TRAP
  { 1, 218, 220, 2046, 2048 }, // 362 TW
  { 1, 188, 190, 2048, 2051 }, // 363 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW
  { 0, 0, 0, 0, 0 }, // 364 FTSQRT
  { 1, 201, 203, 2051, 2054 }, // 365 MTVSRBM_MTVSRBMI_MTVSRDM_MTVSRHM_MTVSRQM_MTVSRWM_VEXPANDBM_VEXPANDDM_VEXPANDHM_VEXPANDQM_VEXPANDWM_VEXTRACTBM_VEXTRACTDM_VEXTRACTHM_VEXTRACTQM_VEXTRACTWM_XVTLSBB
  { 1, 188, 190, 2054, 2057 }, // 366 POPCNTB_POPCNTB8
  { 1, 201, 203, 2057, 2060 }, // 367 VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTD_VPOPCNTW_VPRTYBD_VPRTYBW
  { 1, 201, 203, 2060, 2063 }, // 368 VPOPCNTB_VPOPCNTH
  { 0, 0, 0, 0, 0 }, // 369 XSCVSPDPN
  { 0, 0, 0, 0, 0 }, // 370 XSTSQRTDP
  { 0, 0, 0, 0, 0 }, // 371 XVCVHPSP
  { 0, 0, 0, 0, 0 }, // 372 XVTSQRTDP_XVTSQRTSP
  { 1, 188, 190, 2063, 2066 }, // 373 CMPEQB
  { 0, 0, 0, 0, 0 }, // 374 EXTSWSLI_32_64_rec_EXTSWSLI_rec
  { 0, 0, 0, 0, 0 }, // 375 SLD_rec_SRD_rec
  { 1, 188, 190, 2066, 2069 }, // 376 SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 0, 0, 0, 0, 0 }, // 377 VADDCUW_VADDSBS_VADDSHS_VADDSWS_VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VMAXFP_VMINFP_VSUBCUW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP
  { 0, 0, 0, 0, 0 }, // 378 VCMPBFP_VCMPBFP_rec_VCMPEQFP_VCMPEQFP_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPGTSB_rec_VCMPGTSD_rec_VCMPGTSH_rec_VCMPGTSW_rec_VCMPGTUB_rec_VCMPGTUD_rec_VCMPGTUH_rec_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 0, 0, 0, 0, 0 }, // 379 VCMPEQUQ_VCMPEQUQ_rec_VCMPGTSQ_VCMPGTSQ_rec_VCMPGTUQ_VCMPGTUQ_rec
  { 1, 201, 203, 2069, 2072 }, // 380 VCMPSQ_VCMPUQ_VCNTMBB_VCNTMBD_VCNTMBH_VCNTMBW
  { 0, 0, 0, 0, 0 }, // 381 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP
  { 0, 0, 0, 0, 0 }, // 382 RLDIC_rec
  { 0, 0, 0, 0, 0 }, // 383 RLDICL_32_rec_RLDICL_rec_RLDICR_rec
  { 0, 0, 0, 0, 0 }, // 384 VSHASIGMAD_VSHASIGMAW
  { 0, 0, 0, 0, 0 }, // 385 VRLQ_VRLQNM_VSLQ_VSRAQ_VSRQ
  { 0, 0, 0, 0, 0 }, // 386 VRLQMI
  { 1, 190, 192, 2072, 2075 }, // 387 CR6SET_CREQV_CRSET
  { 1, 186, 188, 2075, 2077 }, // 388 DSS_DSSALL
  { 1, 188, 190, 2077, 2079 }, // 389 MFCTR_MFCTR8_MFLR_MFLR8
  { 1, 188, 190, 2079, 2082 }, // 390 NOP_ORI_ORI8
  { 0, 0, 0, 0, 0 }, // 391 VXOR_V_SET0_V_SET0B_V_SET0H
  { 1, 201, 203, 2082, 2085 }, // 392 XXLEQV_XXLEQVOnes_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 1, 188, 190, 2085, 2088 }, // 393 ADDI_ADDI8_LI_LI8_ADDIS_ADDIS8_LIS_LIS8_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_NEG_NEG8_NEG8_rec_NEG_rec_NEG8O_NEGO
  { 0, 0, 0, 0, 0 }, // 394 ADDIdtprelL32_ADDItlsldLADDR32_ADDISdtprelHA32
  { 0, 0, 0, 0, 0 }, // 395 ADDItocL_ADDIStocHA_ADDIStocHA8
  { 1, 188, 190, 2088, 2091 }, // 396 ADDME_ADDME8_ADDME8O_ADDMEO_ADDZE_ADDZE8_ADDZE8O_ADDZEO_SUBFME_SUBFME8_SUBFME8O_SUBFMEO_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZEO
  { 0, 0, 0, 0, 0 }, // 397 FABSD_FABSS_FMR_FNABSD_FNABSS_FNEGD_FNEGS
  { 1, 188, 190, 2091, 2094 }, // 398 SETB_SETB8
  { 1, 188, 190, 2094, 2097 }, // 399 SETBC_SETBC8_SETBCR_SETBCR8_SETNBC_SETNBC8_SETNBCR_SETNBCR8
  { 1, 201, 203, 2097, 2100 }, // 400 VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VNEGD_VNEGW
  { 1, 201, 203, 2100, 2103 }, // 401 VEXTSD2Q
  { 0, 0, 0, 0, 0 }, // 402 XSABSDP_XSNABSDP_XSNEGDP_XSXEXPDP
  { 0, 0, 0, 0, 0 }, // 403 XSABSQP_XSNABSQP_XSNEGQP_XSXEXPQP_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVNEGDP_XVNEGSP_XVXEXPDP_XVXEXPSP
  { 0, 0, 0, 0, 0 }, // 404 XVXSIGDP_XVXSIGSP
  { 1, 188, 190, 2103, 2106 }, // 405 ADD4_ADD4TLS_ADD8_ADD8TLS_ADD8TLS__ADD4_rec_ADD8_rec_ADD4O_ADD8O_AND_AND8_AND8_rec_AND_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_EQV_EQV8_EQV8_rec_EQV_rec_NAND_NAND8_NAND8_rec_NAND_rec_NOR_NOR8_NOR8_rec_NOR_rec_OR_OR8_OR8_rec_OR_rec_ORC_ORC8_ORC8_rec_ORC_rec_ORIS_ORIS8_XOR_XOR8_XOR8_rec_XOR_rec_XORI_XORI8_XORIS_XORIS8
  { 1, 188, 190, 2106, 2109 }, // 406 ADDE_ADDE8_ADDE8O_ADDEO_ADDIC_ADDIC8_ANDI8_rec_ANDI_rec_ANDIS8_rec_ANDIS_rec_SUBF_SUBF8_SUBF8_rec_SUBF_rec_SUBFE_SUBFE8_SUBFE8O_SUBFEO_SUBFIC_SUBFIC8_SUBF8O_SUBFO
  { 1, 188, 190, 2109, 2112 }, // 407 CMPB_CMPB8
  { 0, 0, 0, 0, 0 }, // 408 EXTSWSLI_EXTSWSLI_32_64_SRADI_SRADI_32
  { 1, 188, 190, 2112, 2115 }, // 409 SLW_SLW8_SRW_SRW8
  { 1, 201, 203, 2115, 2118 }, // 410 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEQV_VNAND_VORC_VSLD_VSRAD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_XXLAND_XXLANDC_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC
  { 0, 0, 0, 0, 0 }, // 411 VAND_VANDC_VMRGEW_VMRGOW_VNOR_VOR_VRLB_VRLD_VRLDNM_VRLH_VRLW_VRLWNM_VSLB_VSLH_VSLW_VSRAB_VSRAH_VSRAW_VSRB_VSRH_VSRW_XSCPSGNQP_XSIEXPQP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP
  { 0, 0, 0, 0, 0 }, // 412 VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW
  { 1, 188, 190, 2118, 2121 }, // 413 ADDEX_ADDEX8
  { 1, 186, 188, 2121, 2123 }, // 414 DST_DST64_DSTT_DSTT64_DSTST_DSTST64_DSTSTT_DSTSTT64
  { 0, 0, 0, 0, 0 }, // 415 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32
  { 0, 0, 0, 0, 0 }, // 416 MFFS_MFFS_rec_MFFSL
  { 1, 188, 190, 2123, 2125 }, // 417 TRECHKPT
  { 1, 188, 190, 2125, 2128 }, // 418 ADDME8_rec_ADDME_rec_ADDME8O_rec_ADDMEO_rec_ADDZE8_rec_ADDZE_rec_ADDZE8O_rec_ADDZEO_rec_SUBFME8_rec_SUBFME_rec_SUBFME8O_rec_SUBFMEO_rec_SUBFZE8_rec_SUBFZE_rec_SUBFZE8O_rec_SUBFZEO_rec
  { 0, 0, 0, 0, 0 }, // 419 MTFSB0
  { 1, 188, 190, 2128, 2131 }, // 420 NEG8O_rec_NEGO_rec
  { 1, 188, 190, 2131, 2134 }, // 421 ADDE8_rec_ADDE_rec_ADDE8O_rec_ADDEO_rec_ADDIC_rec_SUBFE8_rec_SUBFE_rec_SUBFE8O_rec_SUBFEO_rec_SUBF8O_rec_SUBFO_rec
  { 1, 190, 192, 2134, 2136 }, // 422 HRFID
  { 0, 0, 0, 0, 0 }, // 423 FABSD_rec_FABSS_rec_FMR_rec_FNABSD_rec_FNABSS_rec_FNEGD_rec_FNEGS_rec
  { 1, 190, 192, 2136, 2138 }, // 424 SC
  { 1, 188, 190, 2138, 2141 }, // 425 ADDC_ADDC8_ADDC8O_ADDCO_SUBFC_SUBFC8_SUBFC8O_SUBFCO
  { 1, 188, 190, 2141, 2144 }, // 426 ADDC8_rec_ADDC_rec_SUBFC8_rec_SUBFC_rec
  { 0, 0, 0, 0, 0 }, // 427 MTFSF_MTFSFI_MTFSFIb
  { 0, 0, 0, 0, 0 }, // 428 MTFSFI_rec
  { 1, 201, 203, 2144, 2147 }, // 429 VSTRIBL_rec_VSTRIBR_rec_VSTRIHL_rec_VSTRIHR_rec
  { 1, 186, 188, 2147, 2149 }, // 430 LBZ_LBZ8_LDBRX_LHBRX_LHBRX8_LHZ_LHZ8_LWBRX_LWBRX8_LWZ_LWZ8
  { 0, 0, 0, 0, 0 }, // 431 LD
  { 0, 0, 0, 0, 0 }, // 432 LDtoc_LDtocBA_LDtocCPT_LDtocJTI_LDtocL_SPILLTOVSR_LD_LWZtoc_LWZtocL
  { 0, 0, 0, 0, 0 }, // 433 LXVRBX_LXVRDX_LXVRHX_LXVRWX
  { 1, 186, 188, 2149, 2151 }, // 434 DCBT_DCBTST
  { 1, 186, 188, 2151, 2153 }, // 435 ICBT_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32
  { 0, 0, 0, 0, 0 }, // 436 LDX_LDXTLS_LDXTLS_
  { 0, 0, 0, 0, 0 }, // 437 SPILLTOVSR_LDX
  { 1, 186, 188, 2153, 2155 }, // 438 LBZCIX_LDCIX_LHZCIX_LWZCIX
  { 1, 201, 203, 2155, 2157 }, // 439 MTSR
  { 1, 188, 190, 2157, 2160 }, // 440 MTVRSAVE_MTVRSAVEv
  { 1, 186, 188, 2160, 2162 }, // 441 LSWI
  { 0, 0, 0, 0, 0 }, // 442 PLBZ_PLBZ8_PLBZ8pc_PLBZpc_PLD_PLDpc_PLFD_PLFDpc_PLFS_PLFSpc_PLHA_PLHA8_PLHA8pc_PLHApc_PLHZ_PLHZ8_PLHZ8pc_PLHZpc_PLWA_PLWA8_PLWA8pc_PLWApc_PLWZ_PLWZ8_PLWZ8pc_PLWZpc_PLXSD_PLXSDpc_PLXSSP_PLXSSPpc_PLXV_PLXVpc_PLXVP_PLXVPpc
  { 0, 0, 0, 0, 0 }, // 443 LXVP_LXVPX
  { 1, 212, 214, 2162, 2164 }, // 444 MFSR
  { 1, 212, 214, 2164, 2166 }, // 445 MFTB8
  { 1, 201, 203, 2166, 2169 }, // 446 XXSETACCZ
  { 0, 0, 0, 0, 0 }, // 447 XVBF16GER2_XVF16GER2_XVF32GER_XVF64GER_XVI16GER2_XVI16GER2S_XVI4GER8_XVI8GER4
  { 0, 0, 0, 0, 0 }, // 448 XVBF16GER2NN_XVBF16GER2NP_XVBF16GER2PN_XVBF16GER2PP_XVF16GER2NN_XVF16GER2NP_XVF16GER2PN_XVF16GER2PP_XVF32GERNN_XVF32GERNP_XVF32GERPN_XVF32GERPP_XVF64GERNN_XVF64GERNP_XVF64GERPN_XVF64GERPP_XVI16GER2PP_XVI16GER2SPP_XVI4GER8PP_XVI8GER4PP
  { 1, 201, 203, 2169, 2172 }, // 449 XVI8GER4SPP
  { 0, 0, 0, 0, 0 }, // 450 PMXVF32GER_PMXVF64GER
  { 0, 0, 0, 0, 0 }, // 451 PMXVBF16GER2_PMXVF16GER2_PMXVF32GERNN_PMXVF32GERNP_PMXVF32GERPN_PMXVF32GERPP_PMXVF64GERNN_PMXVF64GERNP_PMXVF64GERPN_PMXVF64GERPP_PMXVI16GER2_PMXVI16GER2S_PMXVI4GER8_PMXVI8GER4
  { 0, 0, 0, 0, 0 }, // 452 PMXVBF16GER2NN_PMXVBF16GER2NP_PMXVBF16GER2PN_PMXVBF16GER2PP_PMXVF16GER2NN_PMXVF16GER2NP_PMXVF16GER2PN_PMXVF16GER2PP_PMXVI16GER2PP_PMXVI16GER2SPP_PMXVI4GER8PP_PMXVI8GER4PP
  { 1, 201, 203, 2172, 2175 }, // 453 PMXVI8GER4SPP
  { 1, 201, 203, 2175, 2178 }, // 454 XXMTACC
  { 1, 201, 203, 2178, 2181 }, // 455 XXMFACC
  { 0, 0, 0, 0, 0 }, // 456 MULLD_MULLDO
  { 1, 201, 203, 2181, 2184 }, // 457 VMULHSD_VMULHUD_VMULLD
  { 0, 0, 0, 0, 0 }, // 458 VSPLTISW
  { 0, 0, 0, 0, 0 }, // 459 V_SETALLONES_V_SETALLONESB_V_SETALLONESH
  { 1, 201, 203, 2184, 2187 }, // 460 MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VPRTYBQ
  { 0, 0, 0, 0, 0 }, // 461 VGBBD_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW
  { 0, 0, 0, 0, 0 }, // 462 VSPLTISB_VSPLTISH_XXSPLTIB
  { 1, 201, 203, 2187, 2190 }, // 463 VSTRIBL_VSTRIBR_VSTRIHL_VSTRIHR
  { 0, 0, 0, 0, 0 }, // 464 XVCVBF16SPN
  { 0, 0, 0, 0, 0 }, // 465 VBPERMQ_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLO_VSLV_VSR_VSRO_VSRV_XXEXTRACTUW
  { 1, 201, 203, 2190, 2193 }, // 466 VCLRLB_VCLRRB_XXGENPCVDM_XXGENPCVHM_XXGENPCVWM
  { 1, 201, 203, 2193, 2196 }, // 467 VEXTRACTD_VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VINSERTD_VINSERTW
  { 1, 201, 203, 2196, 2199 }, // 468 VEXTDDVLX_VEXTDDVRX_VEXTDUBVLX_VEXTDUBVRX_VEXTDUHVLX_VEXTDUHVRX_VEXTDUWVLX_VEXTDUWVRX_VINSBLX_VINSBRX_VINSBVLX_VINSBVRX_VINSD_VINSDLX_VINSDRX_VINSHLX_VINSHRX_VINSHVLX_VINSHVRX_VINSW_VINSWLX_VINSWRX_VINSWVLX_VINSWVRX_VSLDBI_VSRDBI
  { 0, 0, 0, 0, 0 }, // 469 VSUMSWS
  { 1, 201, 203, 2199, 2202 }, // 470 XXSPLTIDP_XXSPLTIW
  { 1, 201, 203, 2202, 2205 }, // 471 XXBLENDVB_XXBLENDVD_XXBLENDVH_XXBLENDVW_XXSPLTI32DX
  { 1, 201, 203, 2205, 2208 }, // 472 XXEVAL
  { 0, 0, 0, 0, 0 }, // 473 XXPERMX
  { 1, 186, 188, 2208, 2210 }, // 474 DCBST_DCBZ
  { 1, 186, 188, 2210, 2212 }, // 475 ICBI
  { 1, 186, 188, 2212, 2214 }, // 476 DCBF
  { 0, 0, 0, 0, 0 }, // 477 PSTXVP_PSTXVPpc
  { 1, 186, 188, 2214, 2216 }, // 478 STB_STB8_STDBRX_STH_STH8_STHBRX_STW_STW8_STWBRX
  { 0, 0, 0, 0, 0 }, // 479 SPILLTOVSR_ST
  { 0, 0, 0, 0, 0 }, // 480 STD
  { 0, 0, 0, 0, 0 }, // 481 DFSTOREf32_DFSTOREf64_STIWX
  { 0, 0, 0, 0, 0 }, // 482 STXVRBX_STXVRDX_STXVRHX_STXVRWX
  { 0, 0, 0, 0, 0 }, // 483 SPILLTOVSR_STX
  { 1, 186, 188, 2216, 2218 }, // 484 EnforceIEIO
  { 1, 186, 188, 2218, 2220 }, // 485 STBCIX_STDCIX_STHCIX_STWCIX
  { 0, 0, 0, 0, 0 }, // 486 PSTB_PSTB8_PSTB8pc_PSTBpc_PSTD_PSTDpc_PSTFD_PSTFDpc_PSTFS_PSTFSpc_PSTH_PSTH8_PSTH8pc_PSTHpc_PSTW_PSTW8_PSTW8pc_PSTWpc_PSTXSD_PSTXSDpc_PSTXSSP_PSTXSSPpc_PSTXV_PSTXVpc
  { 0, 0, 0, 0, 0 }, // 487 STXVP_STXVPX
  { 1, 190, 192, 2220, 2222 }, // 488 ATTN_NAP
  { 1, 186, 188, 2222, 2224 }, // 489 DCBZL
  { 1, 186, 188, 2224, 2226 }, // 490 DCCCI_ICBLQ_ICCCI_TLBLD_TLBLI_TLBRE2_TLBSX2_TLBSX2D_TLBWE2
  { 1, 186, 188, 2226, 2228 }, // 491 ICBLC
  { 1, 190, 192, 2228, 2230 }, // 492 CLRBHRB
  { 1, 190, 192, 2230, 2232 }, // 493 MFBHRBE
  { 0, 0, 0, 0, 0 }, // 494 PADDI_PADDI8_PADDI8pc_PADDIpc
  { 1, 188, 190, 2232, 2235 }, // 495 PLI_PLI8
  { 0, 0, 0, 0, 0 }, // 496 VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS
  { 1, 201, 203, 2235, 2238 }, // 497 VMULESD_VMULEUD_VMULHSW_VMULHUW_VMULOSD_VMULOUD
  { 1, 201, 203, 2238, 2241 }, // 498 VMSUMCUD
  { 0, uint16_t(~0U), uint16_t(~0U), uint16_t(~0U), uint16_t(~0U) }// end marker
};

static const llvm::InstrItinerary PPCE500mcItineraries[] = {
  { 0, 0, 0, 0, 0 }, // 0 NoInstrModel
  { 1, 220, 222, 0, 0 }, // 1 IIC_LdStSync
  { 1, 222, 224, 2241, 2244 }, // 2 IIC_IntSimple
  { 1, 222, 224, 2244, 2247 }, // 3 IIC_IntGeneral
  { 1, 224, 226, 2247, 2249 }, // 4 IIC_BrB
  { 0, 0, 0, 0, 0 }, // 5 IIC_VecFP
  { 1, 222, 224, 2249, 2252 }, // 6 IIC_IntCompare
  { 0, 0, 0, 0, 0 }, // 7 IIC_SprABORT
  { 0, 0, 0, 0, 0 }, // 8 IIC_LdStCOPY
  { 0, 0, 0, 0, 0 }, // 9 IIC_LdStPASTE
  { 1, 224, 226, 2252, 2255 }, // 10 IIC_BrCR
  { 0, 0, 0, 0, 0 }, // 11 IIC_LdStLD
  { 1, 220, 222, 2255, 2257 }, // 12 IIC_LdStDCBF
  { 1, 220, 222, 2257, 2259 }, // 13 IIC_LdStLoad
  { 0, 0, 0, 0, 0 }, // 14 IIC_IntDivD
  { 1, 226, 229, 2259, 2262 }, // 15 IIC_IntDivW
  { 0, 0, 0, 0, 0 }, // 16 IIC_FPDGeneral
  { 1, 229, 231, 2262, 2265 }, // 17 IIC_FPAddSub
  { 1, 231, 233, 2265, 2268 }, // 18 IIC_FPDivD
  { 0, 0, 0, 0, 0 }, // 19 IIC_FPSGeneral
  { 1, 233, 235, 2268, 2271 }, // 20 IIC_FPCompare
  { 1, 233, 235, 2271, 2274 }, // 21 IIC_FPGeneral
  { 0, 0, 0, 0, 0 }, // 22 IIC_VecGeneral
  { 0, 0, 0, 0, 0 }, // 23 IIC_VecComplex
  { 1, 220, 222, 2274, 2276 }, // 24 IIC_LdStStore
  { 0, 0, 0, 0, 0 }, // 25 IIC_IntRotateDI
  { 1, 235, 237, 2276, 2279 }, // 26 IIC_FPDivS
  { 1, 229, 231, 2279, 2283 }, // 27 IIC_FPFused
  { 0, 0, 0, 0, 0 }, // 28 IIC_FPSqrtD
  { 0, 0, 0, 0, 0 }, // 29 IIC_FPSqrtS
  { 1, 220, 222, 2283, 2285 }, // 30 IIC_LdStICBI
  { 1, 222, 224, 2285, 2289 }, // 31 IIC_IntISEL
  { 0, 0, 0, 0, 0 }, // 32 IIC_SprISYNC
  { 1, 237, 239, 2289, 2292 }, // 33 IIC_LdStLWARX
  { 2, 239, 242, 2292, 2294 }, // 34 IIC_LdStLoadUpd
  { 2, 239, 242, 2294, 2296 }, // 35 IIC_LdStLoadUpdX
  { 0, 0, 0, 0, 0 }, // 36 IIC_LdStLDARX
  { 0, 0, 0, 0, 0 }, // 37 IIC_LdStLDU
  { 0, 0, 0, 0, 0 }, // 38 IIC_LdStLDUX
  { 1, 220, 222, 2296, 2299 }, // 39 IIC_LdStLFD
  { 2, 239, 242, 2299, 2302 }, // 40 IIC_LdStLFDU
  { 2, 239, 242, 2302, 2305 }, // 41 IIC_LdStLFDUX
  { 1, 220, 222, 2305, 2307 }, // 42 IIC_LdStLHA
  { 1, 239, 242, 2307, 2309 }, // 43 IIC_LdStLHAU
  { 1, 239, 242, 2309, 2311 }, // 44 IIC_LdStLHAUX
  { 1, 220, 222, 2311, 2313 }, // 45 IIC_LdStLMW
  { 0, 0, 0, 0, 0 }, // 46 IIC_LdStLQ
  { 0, 0, 0, 0, 0 }, // 47 IIC_LdStLQARX
  { 0, 0, 0, 0, 0 }, // 48 IIC_LdStLWA
  { 0, 0, 0, 0, 0 }, // 49 IIC_IntMulHD
  { 1, 224, 226, 2313, 2315 }, // 50 IIC_BrMCR
  { 1, 222, 224, 2315, 2318 }, // 51 IIC_BrMCRX
  { 1, 242, 244, 2318, 2320 }, // 52 IIC_SprMFCR
  { 1, 222, 224, 2320, 2322 }, // 53 IIC_SprMFSPR
  { 1, 244, 246, 2322, 2323 }, // 54 IIC_IntMFFS
  { 1, 246, 248, 2323, 2325 }, // 55 IIC_SprMFMSR
  { 1, 242, 244, 2325, 2327 }, // 56 IIC_SprMFCRF
  { 1, 246, 248, 2327, 2329 }, // 57 IIC_SprMFPMR
  { 1, 246, 248, 2329, 2331 }, // 58 IIC_SprMFSR
  { 1, 246, 248, 2331, 2333 }, // 59 IIC_SprMFTB
  { 0, 0, 0, 0, 0 }, // 60 IIC_SprMSGSYNC
  { 1, 222, 224, 2333, 2335 }, // 61 IIC_SprMTSPR
  { 1, 244, 246, 2335, 2338 }, // 62 IIC_IntMTFSB0
  { 1, 248, 250, 2338, 2340 }, // 63 IIC_SprMTMSR
  { 0, 0, 0, 0, 0 }, // 64 IIC_SprMTMSRD
  { 1, 250, 252, 2340, 2342 }, // 65 IIC_SprMTPMR
  { 1, 250, 252, 2342, 2344 }, // 66 IIC_SprMTSR
  { 1, 252, 254, 2344, 2347 }, // 67 IIC_IntMulHW
  { 1, 252, 254, 2347, 2350 }, // 68 IIC_IntMulHWU
  { 1, 252, 254, 2350, 2353 }, // 69 IIC_IntMulLI
  { 0, 0, 0, 0, 0 }, // 70 IIC_SprRFI
  { 0, 0, 0, 0, 0 }, // 71 IIC_IntRFID
  { 0, 0, 0, 0, 0 }, // 72 IIC_IntRotateD
  { 1, 222, 224, 2353, 2356 }, // 73 IIC_IntRotate
  { 0, 0, 0, 0, 0 }, // 74 IIC_SprSLBFEE
  { 0, 0, 0, 0, 0 }, // 75 IIC_SprSLBIA
  { 0, 0, 0, 0, 0 }, // 76 IIC_SprSLBIE
  { 0, 0, 0, 0, 0 }, // 77 IIC_SprSLBIEG
  { 0, 0, 0, 0, 0 }, // 78 IIC_SprSLBMFEE
  { 0, 0, 0, 0, 0 }, // 79 IIC_SprSLBMFEV
  { 0, 0, 0, 0, 0 }, // 80 IIC_SprSLBMTE
  { 0, 0, 0, 0, 0 }, // 81 IIC_SprSLBSYNC
  { 1, 222, 224, 2356, 2359 }, // 82 IIC_IntShift
  { 1, 220, 222, 2359, 2361 }, // 83 IIC_LdStSTWCX
  { 2, 239, 242, 2361, 2363 }, // 84 IIC_LdStSTU
  { 2, 239, 242, 2363, 2365 }, // 85 IIC_LdStSTUX
  { 0, 0, 0, 0, 0 }, // 86 IIC_LdStSTD
  { 0, 0, 0, 0, 0 }, // 87 IIC_LdStSTDCX
  { 1, 220, 222, 2365, 2368 }, // 88 IIC_LdStSTFD
  { 2, 239, 242, 2368, 2371 }, // 89 IIC_LdStSTFDU
  { 0, 0, 0, 0, 0 }, // 90 IIC_SprSTOP
  { 0, 0, 0, 0, 0 }, // 91 IIC_LdStSTQ
  { 0, 0, 0, 0, 0 }, // 92 IIC_LdStSTQCX
  { 0, 0, 0, 0, 0 }, // 93 IIC_IntTrapD
  { 0, 0, 0, 0, 0 }, // 94 IIC_SprTLBIA
  { 0, 0, 0, 0, 0 }, // 95 IIC_SprTLBIE
  { 0, 0, 0, 0, 0 }, // 96 IIC_SprTLBIEL
  { 1, 254, 256, 0, 0 }, // 97 IIC_SprTLBSYNC
  { 1, 256, 258, 2371, 2373 }, // 98 IIC_IntTrapW
  { 0, 0, 0, 0, 0 }, // 99 IIC_VecFPCompare
  { 0, 0, 0, 0, 0 }, // 100 IIC_VecPerm
  { 0, 0, 0, 0, 0 }, // 101 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VSLD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_VPOPCNTB_VPOPCNTH_VSRAD_MTVSRDD_VEQV_VNAND_VNEGD_VNEGW_VORC_XXLAND_XXLANDC_XXLEQV_XXLEQVOnes_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 0, 0, 0, 0, 0 }, // 102 VAND_VANDC_V_SET0_V_SET0B_V_SET0H_VSLB_VSLH_VSLW_VSRB_VSRH_VSRW_VRLB_VRLD_VRLH_VRLW_VSRAB_VSRAH_VSRAW_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP_XVXEXPDP_XVXEXPSP_VRLDMI_VRLDNM_VRLWMI_VRLWNM_VMRGEW_VMRGOW_VNOR_VOR_VSEL_VXOR_XVNEGDP_XVNEGSP_XSABSQP_XSCPSGNQP_XSIEXPQP_XSNABSQP_XSNEGQP_XSXEXPQP
  { 0, 0, 0, 0, 0 }, // 103 XXSEL
  { 1, 222, 224, 2373, 2375 }, // 104 TABORTDC_TABORTDCI_TABORTWC_TABORTWCI
  { 1, 244, 246, 2375, 2378 }, // 105 MTFSB0_MTFSB1
  { 1, 244, 246, 2378, 2379 }, // 106 MFFSCDRN_MFFSCDRNI_MFFSCRN_MFFSCRNI
  { 1, 222, 224, 2379, 2382 }, // 107 CMPRB_CMPRB8_CMPEQB
  { 0, 0, 0, 0, 0 }, // 108 TD_TDI
  { 1, 256, 258, 2382, 2384 }, // 109 TW_TWI
  { 1, 233, 235, 2384, 2387 }, // 110 FCMPOD_FCMPOS_FCMPUD_FCMPUS_FTDIV_FTSQRT
  { 0, 0, 0, 0, 0 }, // 111 XSTSTDCDP_XSTSTDCSP
  { 0, 0, 0, 0, 0 }, // 112 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP_XSXSIGDP_XSCVSPDPN
  { 1, 233, 235, 2387, 2390 }, // 113 XSCMPEQDP_XSCMPEXPDP_XSCMPGEDP_XSCMPGTDP_XSCMPODP_XSCMPUDP_XSTDIVDP_XSTSQRTDP
  { 1, 222, 224, 2390, 2393 }, // 114 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW_CMPB_CMPB8_SETB_SETB8_BPERMD
  { 0, 0, 0, 0, 0 }, // 115 SLD_SRD_SRAD
  { 0, 0, 0, 0, 0 }, // 116 SRADI_EXTSWSLI_32_64_EXTSWSLI_SRADI_32_RLDIC
  { 0, 0, 0, 0, 0 }, // 117 MFVRD_MFVSRD_MTVRD_MTVSRD_MTVRWA_MTVRWZ_MTVSRWA_MTVSRWZ_MFVSRWZ_MFVRWZ
  { 1, 222, 224, 2393, 2396 }, // 118 CMPLW_CMPLWI_CMPW_CMPWI_CMPD_CMPDI_CMPLD_CMPLDI
  { 1, 222, 224, 2396, 2399 }, // 119 SUBFC_SUBFC8_SUBFC8O_SUBFCO_SUBFIC_SUBFIC8_ANDI8_rec_ANDIS8_rec_ANDIS_rec_ANDI_rec_ADDC_ADDC8_ADDC8O_ADDCO_ADDIC_ADDIC8_ADDIC_rec_ADDE_ADDE8_ADDE8O_ADDE8O_rec_ADDE8_rec_ADDEO_ADDEO_rec_ADDE_rec_ADDME_ADDME8_ADDME8O_ADDME8O_rec_ADDME8_rec_ADDMEO_ADDMEO_rec_ADDME_rec_ADDZE_ADDZE8_ADDZE8O_ADDZE8O_rec_ADDZE8_rec_ADDZEO_ADDZEO_rec_ADDZE_rec_SUBF_SUBF8_SUBF8O_SUBF8O_rec_SUBF8_rec_SUBFE_SUBFE8_SUBFE8O_SUBFE8O_rec_SUBFE8_rec_SUBFEO_SUBFEO_rec_SUBFE_rec_SUBFME_SUBFME8_SUBFME8O_SUBFME8O_rec_SUBFME8_rec_SUBFMEO_SUBFMEO_rec_SUBFME_rec_SUBFO_SUBFO_rec_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZE8O_rec_SUBFZE8_rec_SUBFZEO_SUBFZEO_rec_SUBFZE_rec_SUBF_rec_POPCNTB_POPCNTB8_LA_LA8
  { 1, 222, 224, 2399, 2402 }, // 120 ADD4_ADD4O_ADD4O_rec_ADD4_rec_ADD8_ADD8O_ADD8O_rec_ADD8_rec_NEG_NEG8_NEG8O_NEG8O_rec_NEG8_rec_NEGO_NEGO_rec_NEG_rec_ADDI_ADDI8_ADDIS_ADDIS8_LI_LI8_LIS_LIS8_OR_OR8_OR8_rec_ORI_ORI8_ORIS_ORIS8_OR_rec_XOR_XOR8_XOR8_rec_XORI_XORI8_XORIS_XORIS8_XOR_rec_NAND_NAND8_NAND8_rec_NAND_rec_AND_AND8_AND8_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_AND_rec_NOR_NOR8_NOR8_rec_NOR_rec_ORC_ORC8_ORC8_rec_ORC_rec_EQV_EQV8_EQV8_rec_EQV_rec_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_ADD4TLS_ADD8TLS_ADD8TLS__NOP
  { 0, 0, 0, 0, 0 }, // 121 ADDIStocHA_ADDIStocHA8_ADDItocL_COPY
  { 1, 224, 226, 2402, 2404 }, // 122 MCRF
  { 1, 222, 224, 2404, 2407 }, // 123 MCRXRX
  { 0, 0, 0, 0, 0 }, // 124 XSNABSDP_XSXEXPDP_XSABSDP_XSNEGDP_XSCPSGNDP
  { 1, 224, 226, 2407, 2409 }, // 125 RFEBB
  { 1, 222, 224, 2409, 2411 }, // 126 TBEGIN_TRECHKPT
  { 1, 220, 222, 2411, 2413 }, // 127 WAIT
  { 0, 0, 0, 0, 0 }, // 128 RLDCL_RLDCR
  { 1, 222, 224, 2413, 2416 }, // 129 RLWIMI_RLWIMI8
  { 0, 0, 0, 0, 0 }, // 130 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32_RLDIMI
  { 1, 242, 244, 2416, 2418 }, // 131 MFOCRF_MFOCRF8
  { 1, 222, 224, 2418, 2421 }, // 132 MTOCRF_MTOCRF8
  { 1, 224, 226, 2421, 2424 }, // 133 CR6SET_CR6UNSET_CRSET_CRUNSET_CRAND_CRANDC_CRNAND_CRNOR_CROR_CRORC_CREQV_CRXOR
  { 1, 222, 224, 2424, 2427 }, // 134 SLW_SLW8_SRW_SRW8_RLWINM_RLWINM8_RLWNM_RLWNM8
  { 1, 233, 235, 2427, 2430 }, // 135 FABSD_FABSS_FNABSD_FNABSS_FNEGD_FNEGS_FCPSGND_FCPSGNS_FMR
  { 1, 222, 224, 2430, 2433 }, // 136 SRAW_SRAWI
  { 1, 222, 224, 2433, 2437 }, // 137 ISEL_ISEL8
  { 0, 0, 0, 0, 0 }, // 138 XSIEXPDP
  { 1, 222, 224, 2437, 2439 }, // 139 TRECLAIM_TSR_TABORT
  { 1, 220, 222, 2439, 2441 }, // 140 MFVSCR
  { 1, 220, 222, 2441, 2443 }, // 141 MTVSCR
  { 0, 0, 0, 0, 0 }, // 142 VCMPNEZB_VCMPNEZH_VCMPNEZW_VCMPEQUB_VCMPEQUD_VCMPEQUH_VCMPEQUW_VCMPNEB_VCMPNEH_VCMPNEW_VCMPEQFP_VCMPEQFP_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPBFP_VCMPBFP_rec_VCMPGTSB_VCMPGTSB_rec_VCMPGTSD_VCMPGTSD_rec_VCMPGTSH_VCMPGTSH_rec_VCMPGTSW_VCMPGTSW_rec_VCMPGTUB_VCMPGTUB_rec_VCMPGTUD_VCMPGTUD_rec_VCMPGTUH_VCMPGTUH_rec_VCMPGTUW_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 0, 0, 0, 0, 0 }, // 143 VABSDUB_VABSDUH_VABSDUW_VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTW_VPOPCNTD_VPRTYBD_VPRTYBW
  { 0, 0, 0, 0, 0 }, // 144 VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VADDSBS_VADDSHS_VADDSWS_VMAXFP_VMINFP_VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW_VBPERMD_VADDCUW_VSHASIGMAD_VSHASIGMAW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_VSUBCUW_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP_XVXSIGDP_XVXSIGSP
  { 1, 233, 235, 2443, 2446 }, // 145 XVTDIVDP_XVTDIVSP_XVTSQRTDP_XVTSQRTSP
  { 0, 0, 0, 0, 0 }, // 146 VADDFP_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VEXPTEFP_VLOGEFP_VMADDFP_VMHADDSHS_VNMSUBFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVADDDP_XVADDSP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVHPSP_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVMULDP_XVMULSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP_XVSUBDP_XVSUBSP_VCFSX_VCFSX_0_VCFUX_VCFUX_0_VMHRADDSHS_VMLADDUHM_VMSUMMBM_VMSUMSHM_VMSUMSHS_VMSUMUBM_VMSUMUHM_VMSUMUDM_VMSUMUHS_VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS_VSUMSWS
  { 0, 0, 0, 0, 0 }, // 147 VSUBFP_VMULUWM
  { 0, 0, 0, 0, 0 }, // 148 MADDHD_MADDHDU_MADDLD_MADDLD8_MULLD_MULLDO
  { 1, 252, 254, 2446, 2449 }, // 149 MULHD_MULHW_MULLW_MULLWO
  { 1, 252, 254, 2449, 2452 }, // 150 MULHDU_MULHWU
  { 1, 252, 254, 2452, 2455 }, // 151 MULLI_MULLI8
  { 1, 233, 235, 2455, 2458 }, // 152 FRSP_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRE_FRES_FADDS_FMSUBS_FMADDS_FSUBS_FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRSQRTE_FRSQRTES_FNMADDS_FNMSUBS_FSELD_FSELS_FMULS
  { 1, 229, 231, 2458, 2461 }, // 153 FADD_FSUB
  { 1, 229, 231, 2461, 2465 }, // 154 FMSUB_FMADD_FNMADD_FNMSUB_FMUL
  { 0, 0, 0, 0, 0 }, // 155 XSMADDADP_XSMADDASP_XSMADDMDP_XSMADDMSP_XSMSUBADP_XSMSUBASP_XSMSUBMDP_XSMSUBMSP_XSMULDP_XSMULSP_XSNMADDADP_XSNMADDASP_XSNMADDMDP_XSNMADDMSP_XSNMSUBADP_XSNMSUBASP_XSNMSUBMDP_XSNMSUBMSP
  { 1, 233, 235, 2465, 2468 }, // 156 FSELD_rec_FSELS_rec
  { 1, 252, 254, 2468, 2471 }, // 157 MULHDU_rec_MULHWU_rec
  { 1, 252, 254, 2471, 2474 }, // 158 MULHD_rec_MULHW_rec_MULLWO_rec_MULLW_rec
  { 0, 0, 0, 0, 0 }, // 159 MULLDO_rec_MULLD_rec
  { 1, 233, 235, 2474, 2477 }, // 160 FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRES_rec_FRE_rec_FADDS_rec_FSUBS_rec_FMSUBS_rec_FNMSUBS_rec_FMADDS_rec_FNMADDS_rec_FCFIDS_rec_FCFIDUS_rec_FCFIDU_rec_FCFID_rec_FCTIDUZ_rec_FCTIDU_rec_FCTIDZ_rec_FCTID_rec_FCTIWUZ_rec_FCTIWU_rec_FCTIWZ_rec_FCTIW_rec_FMULS_rec_FRSQRTES_rec_FRSQRTE_rec_FRSP_rec
  { 1, 229, 231, 2477, 2480 }, // 161 FADD_rec_FSUB_rec
  { 1, 229, 231, 2480, 2484 }, // 162 FMSUB_rec_FNMSUB_rec_FMADD_rec_FNMADD_rec_FMUL_rec
  { 0, 0, 0, 0, 0 }, // 163 XSADDDP_XSADDSP_XSCVDPHP_XSCVDPSP_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPSXWSs_XSCVDPUXWSs_XSCVHPDP_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSQRTEDP_XSRSQRTESP_XSSUBDP_XSSUBSP_XSCVDPSPN_XSRSP
  { 1, 220, 222, 2484, 2486 }, // 164 LVSL_LVSR
  { 0, 0, 0, 0, 0 }, // 165 VSPLTISB_VSPLTISH_VSPLTISW_VSPLTB_VSPLTBs_VSPLTH_VSPLTHs_VSPLTW_XXMRGHW_XXMRGLW_XXPERM_XXPERMR_XXSLDWI_XXSLDWIs_XXSPLTIB_XXSPLTW_XXSPLTWs_XXPERMDI_XXPERMDIs
  { 0, 0, 0, 0, 0 }, // 166 V_SETALLONES_V_SETALLONESB_V_SETALLONESH_VBPERMQ_VGBBD_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPERM_VPERMR_VPERMXOR_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLDOI_VSLO_VSLV_VSR_VSRO_VSRV_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW_XXEXTRACTUW_XXINSERTW_VADDCUQ_VADDECUQ_VADDEUQM_VMUL10CUQ_VMUL10ECUQ_VMUL10EUQ_VMUL10UQ_VSUBCUQ_VSUBECUQ_VSUBEUQM_XSTSTDCQP_XSXSIGQP_BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDS_rec_BCDTRUNC_rec_BCDUS_rec_BCDUTRUNC_rec_BCDADD_rec_BCDSUB_rec
  { 0, 0, 0, 0, 0 }, // 167 VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VINSERTB_VINSERTD_VINSERTH_VINSERTW_MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VEXTRACTD_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VPRTYBQ_VADDUQM_VSUBUQM
  { 1, 233, 235, 2486, 2489 }, // 168 XSCMPEXPQP_XSCMPOQP_XSCMPUQP
  { 0, 0, 0, 0, 0 }, // 169 BCDSR_rec_XSADDQP_XSADDQPO_XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP_XSRQPI_XSRQPIX_XSRQPXP_XSSUBQP_XSSUBQPO
  { 0, 0, 0, 0, 0 }, // 170 BCDCTSQ_rec
  { 0, 0, 0, 0, 0 }, // 171 XSMADDQP_XSMADDQPO_XSMSUBQP_XSMSUBQPO_XSMULQP_XSMULQPO_XSNMADDQP_XSNMADDQPO_XSNMSUBQP_XSNMSUBQPO
  { 0, 0, 0, 0, 0 }, // 172 BCDCFSQ_rec
  { 0, 0, 0, 0, 0 }, // 173 XSDIVQP_XSDIVQPO
  { 0, 0, 0, 0, 0 }, // 174 XSSQRTQP_XSSQRTQPO
  { 1, 220, 222, 2489, 2491 }, // 175 LXVL_LXVLL
  { 1, 220, 222, 2491, 2493 }, // 176 LVEBX_LVEHX_LVEWX_LVX_LVXL
  { 1, 220, 222, 2493, 2496 }, // 177 LXSIBZX_LXSIHZX_LXSDX_LXVB16X_LXVD2X_LXVWSX_LXSIWZX_LXV_LXVX_LXSD
  { 0, 0, 0, 0, 0 }, // 178 DFLOADf64_XFLOADf64_LIWZX
  { 1, 220, 222, 2496, 2498 }, // 179 DCBF_DCBFEP_DCBST_DCBSTEP_DCBT_DCBTEP_DCBZ_DCBZEP_DCBZL_DCBZLEP_DCBTST_DCBTSTEP
  { 0, 0, 0, 0, 0 }, // 180 CP_COPY_CP_COPY8
  { 1, 220, 222, 2498, 2500 }, // 181 ICBI_ICBIEP
  { 1, 220, 222, 2500, 2502 }, // 182 ICBT_ICBTLS_LBZ_LBZ8_LBZCIX_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LDBRX_LDCIX_LHBRX_LHBRX8_LHZ_LHZ8_LHZCIX_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWBRX_LWBRX8_LWZ_LWZ8_LWZCIX_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32_EnforceIEIO_LSWI
  { 1, 237, 239, 2502, 2505 }, // 183 LBARX_LBARXL_LHARX_LHARXL_LWARX_LWARXL
  { 0, 0, 0, 0, 0 }, // 184 LD_LDX_LDXTLS_LDXTLS__DARN
  { 0, 0, 0, 0, 0 }, // 185 LDARX_LDARXL
  { 0, 0, 0, 0, 0 }, // 186 CP_ABORT
  { 0, 0, 0, 0, 0 }, // 187 ISYNC
  { 0, 0, 0, 0, 0 }, // 188 MSGSYNC
  { 1, 254, 256, 0, 0 }, // 189 TLBSYNC
  { 1, 220, 222, 0, 0 }, // 190 SYNC
  { 1, 220, 222, 2505, 2507 }, // 191 LMW
  { 1, 220, 222, 2507, 2510 }, // 192 LFIWZX_LFDX_LFD
  { 0, 0, 0, 0, 0 }, // 193 SLBIA
  { 0, 0, 0, 0, 0 }, // 194 SLBIE
  { 0, 0, 0, 0, 0 }, // 195 SLBMFEE
  { 0, 0, 0, 0, 0 }, // 196 SLBMFEV
  { 0, 0, 0, 0, 0 }, // 197 SLBMTE
  { 0, 0, 0, 0, 0 }, // 198 TLBIEL
  { 2, 239, 242, 2510, 2512 }, // 199 LHZU_LHZU8_LWZU_LWZU8
  { 2, 239, 242, 2512, 2514 }, // 200 LHZUX_LHZUX8_LWZUX_LWZUX8
  { 1, 222, 224, 2514, 2516 }, // 201 TEND
  { 1, 220, 222, 2516, 2518 }, // 202 STBCX_STHCX_STWCX
  { 0, 0, 0, 0, 0 }, // 203 STDCX
  { 0, 0, 0, 0, 0 }, // 204 LDMX
  { 1, 220, 222, 2518, 2520 }, // 205 LHA_LHA8_LHAX_LHAX8_LWAX_LWAX_32
  { 0, 0, 0, 0, 0 }, // 206 CP_PASTE8_rec_CP_PASTE_rec
  { 0, 0, 0, 0, 0 }, // 207 LWA_LWA_32
  { 1, 222, 224, 2520, 2522 }, // 208 TCHECK
  { 1, 220, 222, 2522, 2525 }, // 209 LFIWAX
  { 1, 220, 222, 2525, 2528 }, // 210 LXSIWAX
  { 0, 0, 0, 0, 0 }, // 211 LIWAX
  { 1, 220, 222, 2528, 2531 }, // 212 LFSX_LFS
  { 1, 220, 222, 2531, 2534 }, // 213 LXSSP_LXSSPX
  { 0, 0, 0, 0, 0 }, // 214 XFLOADf32_DFLOADf32
  { 1, 239, 242, 2534, 2536 }, // 215 LHAU_LHAU8
  { 1, 239, 242, 2536, 2538 }, // 216 LHAUX_LHAUX8_LWAUX
  { 1, 220, 222, 2538, 2541 }, // 217 LXVH8X_LXVDSX_LXVW4X
  { 1, 220, 222, 2541, 2544 }, // 218 STFD_STFDX_STFIWX_STFS_STFSX_STXSD_STXSDX_STXSIBX_STXSIBXv_STXSIHX_STXSIHXv_STXSIWX_STXSSP_STXSSPX
  { 1, 220, 222, 2544, 2546 }, // 219 STW_STW8_STDBRX_STHBRX_STWBRX_STB_STB8_STH_STH8_STBX_STBX8_STBXTLS_STBXTLS__STBXTLS_32_STHX_STHX8_STHXTLS_STHXTLS__STHXTLS_32_STWX_STWX8_STWXTLS_STWXTLS__STWXTLS_32
  { 0, 0, 0, 0, 0 }, // 220 DFSTOREf32_DFSTOREf64_XFSTOREf32_XFSTOREf64_STIWX
  { 0, 0, 0, 0, 0 }, // 221 STD_STDX_STDXTLS_STDXTLS_
  { 1, 220, 222, 2546, 2548 }, // 222 STBCIX_STDCIX_STHCIX_STWCIX_STSWI
  { 0, 0, 0, 0, 0 }, // 223 SLBIEG
  { 1, 220, 222, 2548, 2550 }, // 224 STMW
  { 0, 0, 0, 0, 0 }, // 225 TLBIE
  { 1, 220, 222, 2550, 2552 }, // 226 STVEBX_STVEHX_STVEWX_STVX_STVXL
  { 1, 220, 222, 2552, 2555 }, // 227 STXV_STXVB16X_STXVD2X_STXVH8X_STXVW4X_STXVX
  { 1, 220, 222, 2555, 2557 }, // 228 STXVL_STXVLL
  { 1, 222, 224, 2557, 2559 }, // 229 MTCTR_MTCTR8_MTCTR8loop_MTCTRloop_MTLR_MTLR8
  { 1, 222, 224, 2559, 2562 }, // 230 MFVRSAVE_MFVRSAVEv_MTVRSAVE_MTVRSAVEv
  { 1, 246, 248, 2562, 2564 }, // 231 MFPMR
  { 1, 250, 252, 2564, 2566 }, // 232 MTPMR
  { 1, 246, 248, 2566, 2568 }, // 233 MFTB_MFTB8
  { 1, 222, 224, 2568, 2570 }, // 234 MFCTR_MFCTR8_MFLR_MFLR8_MFSPR_MFSPR8
  { 1, 246, 248, 2570, 2572 }, // 235 MFMSR
  { 1, 248, 250, 2572, 2574 }, // 236 MTMSR
  { 0, 0, 0, 0, 0 }, // 237 MTMSRD
  { 1, 222, 224, 2574, 2576 }, // 238 MTSPR_MTSPR8
  { 1, 226, 229, 2576, 2579 }, // 239 DIVW_DIVWO_DIVWU_DIVWUO_MODSW
  { 1, 226, 229, 2579, 2582 }, // 240 DIVWE_DIVWEO_DIVWEU_DIVWEUO_MODSD_MODUD_MODUW
  { 0, 0, 0, 0, 0 }, // 241 DIVD_DIVDO_DIVDU_DIVDUO
  { 0, 0, 0, 0, 0 }, // 242 DIVDE_DIVDEO_DIVDEU_DIVDEUO
  { 1, 226, 229, 2582, 2585 }, // 243 DIVWO_rec_DIVWUO_rec_DIVWU_rec_DIVW_rec
  { 0, 0, 0, 0, 0 }, // 244 DIVD_rec_DIVDO_rec_DIVDU_rec_DIVDUO_rec
  { 1, 226, 229, 2585, 2588 }, // 245 DIVWE_rec_DIVWEO_rec_DIVWEU_rec_DIVWEUO_rec
  { 0, 0, 0, 0, 0 }, // 246 DIVDE_rec_DIVDEO_rec_DIVDEU_rec_DIVDEUO_rec
  { 1, 222, 224, 2588, 2591 }, // 247 MTCRF_MTCRF8
  { 1, 222, 224, 2591, 2594 }, // 248 ADDC8O_rec_ADDC8_rec_ADDCO_rec_ADDC_rec_SUBFC8O_rec_SUBFC8_rec_SUBFCO_rec_SUBFC_rec
  { 1, 233, 235, 2594, 2597 }, // 249 FABSD_rec_FABSS_rec_FNABSD_rec_FNABSS_rec_FCPSGND_rec_FCPSGNS_rec_FNEGD_rec_FNEGS_rec_FMR_rec
  { 1, 224, 226, 2597, 2599 }, // 250 MCRFS
  { 1, 244, 246, 2599, 2600 }, // 251 MTFSF_MTFSF_rec_MTFSFI_MTFSFI_rec_MTFSFIb
  { 1, 244, 246, 2600, 2603 }, // 252 MTFSFb
  { 0, 0, 0, 0, 0 }, // 253 RLDCL_rec_RLDCR_rec
  { 0, 0, 0, 0, 0 }, // 254 RLDICL_rec_RLDICR_rec_RLDICL_32_rec_RLDIMI_rec
  { 1, 222, 224, 2603, 2606 }, // 255 RLWIMI8_rec_RLWIMI_rec
  { 1, 222, 224, 2606, 2609 }, // 256 RLWINM8_rec_RLWINM_rec_RLWNM8_rec_RLWNM_rec_SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 1, 222, 224, 2609, 2612 }, // 257 SRAWI_rec_SRAW_rec
  { 1, 244, 246, 2612, 2613 }, // 258 MFFS_MFFSCE_MFFSL_MFFS_rec
  { 1, 242, 244, 2613, 2615 }, // 259 MFCR_MFCR8
  { 0, 0, 0, 0, 0 }, // 260 EXTSWSLI_32_64_rec_SRADI_rec_EXTSWSLI_rec_RLDIC_rec
  { 0, 0, 0, 0, 0 }, // 261 SRAD_rec_SLD_rec_SRD_rec
  { 1, 231, 233, 2615, 2618 }, // 262 FDIV
  { 1, 231, 233, 2618, 2621 }, // 263 FDIV_rec
  { 0, 0, 0, 0, 0 }, // 264 XSSQRTDP
  { 0, 0, 0, 0, 0 }, // 265 FSQRT
  { 0, 0, 0, 0, 0 }, // 266 XVSQRTDP
  { 0, 0, 0, 0, 0 }, // 267 XVSQRTSP
  { 0, 0, 0, 0, 0 }, // 268 FSQRT_rec
  { 0, 0, 0, 0, 0 }, // 269 XSSQRTSP
  { 0, 0, 0, 0, 0 }, // 270 FSQRTS
  { 0, 0, 0, 0, 0 }, // 271 FSQRTS_rec
  { 1, 231, 233, 2621, 2624 }, // 272 XSDIVDP
  { 1, 235, 237, 2624, 2627 }, // 273 FDIVS
  { 1, 235, 237, 2627, 2630 }, // 274 FDIVS_rec
  { 1, 235, 237, 2630, 2633 }, // 275 XSDIVSP
  { 1, 235, 237, 2633, 2636 }, // 276 XVDIVSP
  { 1, 231, 233, 2636, 2639 }, // 277 XVDIVDP
  { 2, 239, 242, 2639, 2642 }, // 278 LFSU
  { 2, 239, 242, 2642, 2645 }, // 279 LFSUX
  { 2, 239, 242, 2645, 2648 }, // 280 STFDU_STFDUX_STFSU_STFSUX
  { 2, 239, 242, 2648, 2650 }, // 281 STBU_STBU8_STDU_STHU_STHU8_STWU_STWU8
  { 2, 239, 242, 2650, 2652 }, // 282 STBUX_STBUX8_STDUX_STHUX_STHUX8_STWUX_STWUX8
  { 2, 239, 242, 2652, 2654 }, // 283 LBZU_LBZU8
  { 2, 239, 242, 2654, 2656 }, // 284 LBZUX_LBZUX8
  { 0, 0, 0, 0, 0 }, // 285 LDU
  { 0, 0, 0, 0, 0 }, // 286 LDUX
  { 2, 239, 242, 2656, 2659 }, // 287 LFDU
  { 2, 239, 242, 2659, 2662 }, // 288 LFDUX
  { 0, 0, 0, 0, 0 }, // 289 VPMSUMB_VPMSUMD_VPMSUMH_VPMSUMW_VCIPHER_VCIPHERLAST_VNCIPHER_VNCIPHERLAST_VSBOX
  { 1, 224, 226, 2662, 2664 }, // 290 BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_BCCTR_BCCTR8_BCCTR8n_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_BCCTRn_BDNZ_BDNZ8_BDNZA_BDNZAm_BDNZAp_BDNZm_BDNZp_BDZ_BDZ8_BDZA_BDZAm_BDZAp_BDZm_BDZp_BDNZL_BDNZLA_BDNZLAm_BDNZLAp_BDNZLR_BDNZLR8_BDNZLRL_BDNZLRLm_BDNZLRLp_BDNZLRm_BDNZLRp_BDNZLm_BDNZLp_BDZL_BDZLA_BDZLAm_BDZLAp_BDZLR_BDZLR8_BDZLRL_BDZLRLm_BDZLRLp_BDZLRm_BDZLRp_BDZLm_BDZLp_BL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM_BLR_BLR8_BLRL_TAILB_TAILB8_TAILBA_TAILBA8_TAILBCTR_TAILBCTR8_gBC_gBCA_gBCAat_gBCCTR_gBCCTRL_gBCL_gBCLA_gBCLAat_gBCLR_gBCLRL_gBCLat_gBCat_BCLR_BCLRL_BCLRLn_BCLRn_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_RM_BCTRL_RM_B_BA_BC_BCC_BCCA_BCL_BCLalways_BCLn_BCTRL8_LDinto_toc_BCTRL_LWZinto_toc_BCTRL8_LDinto_toc_RM_BCTRL_LWZinto_toc_RM_BCn_CTRL_DEP
  { 1, 224, 226, 2664, 2666 }, // 291 ADDPCIS
  { 1, 220, 222, 2666, 2668 }, // 292 LDAT_LWAT
  { 1, 220, 222, 2668, 2670 }, // 293 STDAT_STWAT
  { 1, 222, 224, 2670, 2673 }, // 294 BRINC
  { 0, 0, 0, 0, 0 }, // 295 EVABS_EVEQV_EVNAND_EVNEG_EVADDIW_EVADDW_EVAND_EVANDC_EVCMPEQ_EVCMPGTS_EVCMPGTU_EVCMPLTS_EVCMPLTU_EVCNTLSW_EVCNTLZW_EVEXTSB_EVEXTSH_EVMERGEHI_EVMERGEHILO_EVMERGELO_EVMERGELOHI_EVNOR_EVOR_EVORC_EVXOR_EVRLW_EVRLWI_EVRNDW_EVSLW_EVSLWI_EVSPLATFI_EVSPLATI_EVSRWIS_EVSRWIU_EVSRWS_EVSRWU_EVSUBFW_EVSUBIFW
  { 0, 0, 0, 0, 0 }, // 296 EVMRA_EVADDSMIAAW_EVADDSSIAAW_EVADDUMIAAW_EVADDUSIAAW_EVDIVWS_EVDIVWU_EVMHEGSMFAA_EVMHEGSMFAN_EVMHEGSMIAA_EVMHEGSMIAN_EVMHEGUMIAA_EVMHEGUMIAN_EVMHESMF_EVMHESMFA_EVMHESMFAAW_EVMHESMFANW_EVMHESMI_EVMHESMIA_EVMHESMIAAW_EVMHESMIANW_EVMHESSF_EVMHESSFA_EVMHESSFAAW_EVMHESSFANW_EVMHESSIAAW_EVMHESSIANW_EVMHEUMI_EVMHEUMIA_EVMHEUMIAAW_EVMHEUMIANW_EVMHEUSIAAW_EVMHEUSIANW_EVMHOGSMFAA_EVMHOGSMFAN_EVMHOGSMIAA_EVMHOGSMIAN_EVMHOGUMIAA_EVMHOGUMIAN_EVMHOSMF_EVMHOSMFA_EVMHOSMFAAW_EVMHOSMFANW_EVMHOSMI_EVMHOSMIA_EVMHOSMIAAW_EVMHOSMIANW_EVMHOSSF_EVMHOSSFA_EVMHOSSFAAW_EVMHOSSFANW_EVMHOSSIAAW_EVMHOSSIANW_EVMHOUMI_EVMHOUMIA_EVMHOUMIAAW_EVMHOUMIANW_EVMHOUSIAAW_EVMHOUSIANW_EVMWHSMF_EVMWHSMFA_EVMWHSMI_EVMWHSMIA_EVMWHSSF_EVMWHSSFA_EVMWHUMI_EVMWHUMIA_EVMWLSMIAAW_EVMWLSMIANW_EVMWLSSIAAW_EVMWLSSIANW_EVMWLUMI_EVMWLUMIA_EVMWLUMIAAW_EVMWLUMIANW_EVMWLUSIAAW_EVMWLUSIANW_EVMWSMF_EVMWSMFA_EVMWSMFAA_EVMWSMFAN_EVMWSMI_EVMWSMIA_EVMWSMIAA_EVMWSMIAN_EVMWSSF_EVMWSSFA_EVMWSSFAA_EVMWSSFAN_EVMWUMI_EVMWUMIA_EVMWUMIAA_EVMWUMIAN_EVSUBFSMIAAW_EVSUBFSSIAAW_EVSUBFUMIAAW_EVSUBFUSIAAW
  { 1, 220, 222, 2673, 2675 }, // 297 EVLDD_EVLDDX_EVLDH_EVLDHX_EVLDW_EVLDWX_EVLHHESPLAT_EVLHHESPLATX_EVLHHOSSPLAT_EVLHHOSSPLATX_EVLHHOUSPLAT_EVLHHOUSPLATX_EVLWHE_EVLWHEX_EVLWHOS_EVLWHOSX_EVLWHOU_EVLWHOUX_EVLWHSPLAT_EVLWHSPLATX_EVLWWSPLAT_EVLWWSPLATX
  { 1, 220, 222, 2675, 2677 }, // 298 EVSTDD_EVSTDDX_EVSTDH_EVSTDHX_EVSTDW_EVSTDWX_EVSTWHE_EVSTWHEX_EVSTWHO_EVSTWHOX_EVSTWWE_EVSTWWEX_EVSTWWO_EVSTWWOX
  { 1, 224, 226, 2677, 2679 }, // 299 HRFID_ATTN_CLRBHRB_MFBHRBE_NAP_RFCI_RFDI_RFMCI_SC
  { 0, 0, 0, 0, 0 }, // 300 RFI
  { 0, 0, 0, 0, 0 }, // 301 RFID
  { 1, 220, 222, 2679, 2681 }, // 302 DSS_DSSALL_DST_DST64_DSTST_DSTST64_DSTSTT_DSTSTT64_DSTT_DSTT64_ICBLQ_LBEPX_LHEPX_LWEPX_TLBIVAX_TLBLD_TLBLI_TLBRE_TLBRE2_TLBSX_TLBSX2_TLBSX2D_TLBWE_TLBWE2_MBAR_TRAP_DCCCI_ICCCI
  { 1, 220, 222, 2681, 2683 }, // 303 ICBLC_STBEPX_STHEPX_STWEPX
  { 1, 220, 222, 2683, 2686 }, // 304 LFDEPX
  { 1, 220, 222, 2686, 2689 }, // 305 STFDEPX
  { 1, 246, 248, 2689, 2691 }, // 306 MFSR_MFSRIN
  { 1, 250, 252, 2691, 2693 }, // 307 MTSR_MTSRIN
  { 1, 222, 224, 2693, 2695 }, // 308 MFDCR
  { 1, 222, 224, 2695, 2697 }, // 309 MTDCR
  { 1, 222, 224, 2697, 2700 }, // 310 NOP_GT_PWR6_NOP_GT_PWR7
  { 0, 0, 0, 0, 0 }, // 311 TLBIA
  { 1, 248, 250, 2700, 2702 }, // 312 WRTEE_WRTEEI
  { 1, 222, 224, 2702, 2705 }, // 313 HASHCHK_HASHCHK8_HASHCHKP_HASHCHKP8_HASHST_HASHST8_HASHSTP_HASHSTP8_ADDEX_ADDEX8
  { 1, 220, 222, 0, 0 }, // 314 MSYNC
  { 0, 0, 0, 0, 0 }, // 315 SLBSYNC
  { 0, 0, 0, 0, 0 }, // 316 SLBFEE_rec
  { 0, 0, 0, 0, 0 }, // 317 STOP
  { 1, 220, 222, 2705, 2707 }, // 318 DCBA_DCBI
  { 1, 233, 235, 2707, 2710 }, // 319 FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRE_FRES_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRSP_FRSQRTE_FRSQRTES
  { 0, 0, 0, 0, 0 }, // 320 VCFSX_VCFSX_0_VCFUX_VCFUX_0_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VLOGEFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP
  { 0, 0, 0, 0, 0 }, // 321 XSCVDPHP_XSCVDPSP_XSCVDPSPN_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPSXWSs_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPUXWSs_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSP_XSRSQRTEDP_XSRSQRTESP
  { 0, 0, 0, 0, 0 }, // 322 XVCVSPBF16
  { 1, 233, 235, 2710, 2713 }, // 323 FADDS_FMULS_FSUBS
  { 1, 229, 231, 2713, 2717 }, // 324 FMUL
  { 0, 0, 0, 0, 0 }, // 325 VADDFP_XVADDDP_XVADDSP_XVMULDP_XVMULSP_XVSUBDP_XVSUBSP
  { 0, 0, 0, 0, 0 }, // 326 VSUBFP
  { 0, 0, 0, 0, 0 }, // 327 XSADDDP_XSADDSP_XSSUBDP_XSSUBSP
  { 0, 0, 0, 0, 0 }, // 328 XSMULDP_XSMULSP
  { 0, 0, 0, 0, 0 }, // 329 VMADDFP_VNMSUBFP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP
  { 0, 0, 0, 0, 0 }, // 330 VEXPTEFP
  { 1, 233, 235, 2717, 2720 }, // 331 FADDS_rec_FMULS_rec_FSUBS_rec
  { 1, 229, 231, 2720, 2724 }, // 332 FMUL_rec
  { 1, 233, 235, 2724, 2727 }, // 333 FCFID_rec_FCFIDS_rec_FCFIDU_rec_FCFIDUS_rec_FCTID_rec_FCTIDU_rec_FCTIDUZ_rec_FCTIDZ_rec_FCTIW_rec_FCTIWU_rec_FCTIWUZ_rec_FCTIWZ_rec_FRE_rec_FRES_rec_FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRSP_rec_FRSQRTE_rec_FRSQRTES_rec
  { 1, 224, 226, 2727, 2729 }, // 334 BCLR_BCLRn_BDNZLR_BDNZLR8_BDNZLRm_BDNZLRp_BDZLR_BDZLR8_BDZLRm_BDZLRp_gBCLR_BCLRL_BCLRLn_BDNZLRL_BDNZLRLm_BDNZLRLp_BDZLRL_BDZLRLm_BDZLRLp_gBCLRL_BL_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLR_BLR8_BLRL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS
  { 1, 224, 226, 2729, 2731 }, // 335 BL8_NOTOC_BL8_NOTOC_RM_BL8_NOTOC_TLS
  { 1, 224, 226, 2731, 2733 }, // 336 B_BCC_BCCA_BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_CTRL_DEP_TAILB_TAILB8_BA_TAILBA_TAILBA8_BC_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_LDinto_toc_BCTRL8_LDinto_toc_RM_BCTRL8_RM_BCTRL_LWZinto_toc_BCTRL_LWZinto_toc_RM_BCTRL_RM_BCn_BDNZ_BDNZ8_BDNZm_BDNZp_BDZ_BDZ8_BDZm_BDZp_TAILBCTR_TAILBCTR8_gBC_gBCat_BCL_BCLalways_BCLn_BDNZL_BDNZLm_BDNZLp_BDZL_BDZLm_BDZLp_gBCL_gBCLat_BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM
  { 1, 224, 226, 2733, 2735 }, // 337 BCCTR_BCCTR8_BCCTR8n_BCCTRn_gBCCTR_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_gBCCTRL
  { 0, 0, 0, 0, 0 }, // 338 VSBOX
  { 1, 222, 224, 2735, 2738 }, // 339 CFUGED_CNTLZDM_CNTTZDM_PDEPD_PEXTD
  { 0, 0, 0, 0, 0 }, // 340 VCFUGED_VCLZDM_VCTZDM_VGNB_VPDEPD_VPEXTD
  { 0, 0, 0, 0, 0 }, // 341 XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP
  { 0, 0, 0, 0, 0 }, // 342 XSCVQPSQZ_XSCVQPUQZ_XSCVSQQP_XSCVUQQP
  { 0, 0, 0, 0, 0 }, // 343 XSADDQP_XSADDQPO_XSSUBQP_XSSUBQPO
  { 1, 222, 224, 2738, 2741 }, // 344 HASHST_HASHST8_HASHSTP_HASHSTP8
  { 0, 0, 0, 0, 0 }, // 345 XSMULQP_XSMULQPO
  { 0, 0, 0, 0, 0 }, // 346 VDIVESQ_VDIVEUQ_VDIVSQ_VDIVUQ
  { 0, 0, 0, 0, 0 }, // 347 VMODSQ_VMODUQ
  { 1, 226, 229, 2741, 2744 }, // 348 DIVWE_DIVWEO_DIVWEU_DIVWEUO
  { 0, 0, 0, 0, 0 }, // 349 VDIVSD_VDIVUD
  { 0, 0, 0, 0, 0 }, // 350 VMODSD_VMODUD
  { 0, 0, 0, 0, 0 }, // 351 VDIVSW_VDIVUW
  { 0, 0, 0, 0, 0 }, // 352 VMODSW_VMODUW
  { 0, 0, 0, 0, 0 }, // 353 VDIVESD_VDIVEUD
  { 0, 0, 0, 0, 0 }, // 354 VDIVESW_VDIVEUW
  { 0, 0, 0, 0, 0 }, // 355 BCDCTN_rec_VMUL10CUQ_VMUL10UQ_XSXSIGQP
  { 0, 0, 0, 0, 0 }, // 356 BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDUS_rec_BCDUTRUNC_rec_VADDCUQ_VMUL10ECUQ_VMUL10EUQ_VSUBCUQ_XSTSTDCQP
  { 0, 0, 0, 0, 0 }, // 357 VADDUQM_VSUBUQM
  { 0, 0, 0, 0, 0 }, // 358 XSMAXCQP_XSMINCQP
  { 0, 0, 0, 0, 0 }, // 359 XXGENPCVBM
  { 0, 0, 0, 0, 0 }, // 360 BCDADD_rec_BCDS_rec_BCDSUB_rec_BCDTRUNC_rec_VADDECUQ_VADDEUQM_VSUBECUQ_VSUBEUQM
  { 1, 220, 222, 2744, 2746 }, // 361 TRAP
  { 1, 256, 258, 2746, 2748 }, // 362 TW
  { 1, 222, 224, 2748, 2751 }, // 363 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW
  { 1, 233, 235, 2751, 2754 }, // 364 FTSQRT
  { 0, 0, 0, 0, 0 }, // 365 MTVSRBM_MTVSRBMI_MTVSRDM_MTVSRHM_MTVSRQM_MTVSRWM_VEXPANDBM_VEXPANDDM_VEXPANDHM_VEXPANDQM_VEXPANDWM_VEXTRACTBM_VEXTRACTDM_VEXTRACTHM_VEXTRACTQM_VEXTRACTWM_XVTLSBB
  { 1, 222, 224, 2754, 2757 }, // 366 POPCNTB_POPCNTB8
  { 0, 0, 0, 0, 0 }, // 367 VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTD_VPOPCNTW_VPRTYBD_VPRTYBW
  { 0, 0, 0, 0, 0 }, // 368 VPOPCNTB_VPOPCNTH
  { 0, 0, 0, 0, 0 }, // 369 XSCVSPDPN
  { 1, 233, 235, 2757, 2760 }, // 370 XSTSQRTDP
  { 0, 0, 0, 0, 0 }, // 371 XVCVHPSP
  { 1, 233, 235, 2760, 2763 }, // 372 XVTSQRTDP_XVTSQRTSP
  { 1, 222, 224, 2763, 2766 }, // 373 CMPEQB
  { 0, 0, 0, 0, 0 }, // 374 EXTSWSLI_32_64_rec_EXTSWSLI_rec
  { 0, 0, 0, 0, 0 }, // 375 SLD_rec_SRD_rec
  { 1, 222, 224, 2766, 2769 }, // 376 SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 0, 0, 0, 0, 0 }, // 377 VADDCUW_VADDSBS_VADDSHS_VADDSWS_VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VMAXFP_VMINFP_VSUBCUW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP
  { 0, 0, 0, 0, 0 }, // 378 VCMPBFP_VCMPBFP_rec_VCMPEQFP_VCMPEQFP_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPGTSB_rec_VCMPGTSD_rec_VCMPGTSH_rec_VCMPGTSW_rec_VCMPGTUB_rec_VCMPGTUD_rec_VCMPGTUH_rec_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 0, 0, 0, 0, 0 }, // 379 VCMPEQUQ_VCMPEQUQ_rec_VCMPGTSQ_VCMPGTSQ_rec_VCMPGTUQ_VCMPGTUQ_rec
  { 0, 0, 0, 0, 0 }, // 380 VCMPSQ_VCMPUQ_VCNTMBB_VCNTMBD_VCNTMBH_VCNTMBW
  { 0, 0, 0, 0, 0 }, // 381 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP
  { 0, 0, 0, 0, 0 }, // 382 RLDIC_rec
  { 0, 0, 0, 0, 0 }, // 383 RLDICL_32_rec_RLDICL_rec_RLDICR_rec
  { 0, 0, 0, 0, 0 }, // 384 VSHASIGMAD_VSHASIGMAW
  { 0, 0, 0, 0, 0 }, // 385 VRLQ_VRLQNM_VSLQ_VSRAQ_VSRQ
  { 0, 0, 0, 0, 0 }, // 386 VRLQMI
  { 1, 224, 226, 2769, 2772 }, // 387 CR6SET_CREQV_CRSET
  { 1, 220, 222, 2772, 2774 }, // 388 DSS_DSSALL
  { 1, 222, 224, 2774, 2776 }, // 389 MFCTR_MFCTR8_MFLR_MFLR8
  { 1, 222, 224, 2776, 2779 }, // 390 NOP_ORI_ORI8
  { 0, 0, 0, 0, 0 }, // 391 VXOR_V_SET0_V_SET0B_V_SET0H
  { 0, 0, 0, 0, 0 }, // 392 XXLEQV_XXLEQVOnes_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 1, 222, 224, 2779, 2782 }, // 393 ADDI_ADDI8_LI_LI8_ADDIS_ADDIS8_LIS_LIS8_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_NEG_NEG8_NEG8_rec_NEG_rec_NEG8O_NEGO
  { 0, 0, 0, 0, 0 }, // 394 ADDIdtprelL32_ADDItlsldLADDR32_ADDISdtprelHA32
  { 0, 0, 0, 0, 0 }, // 395 ADDItocL_ADDIStocHA_ADDIStocHA8
  { 1, 222, 224, 2782, 2785 }, // 396 ADDME_ADDME8_ADDME8O_ADDMEO_ADDZE_ADDZE8_ADDZE8O_ADDZEO_SUBFME_SUBFME8_SUBFME8O_SUBFMEO_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZEO
  { 1, 233, 235, 2785, 2788 }, // 397 FABSD_FABSS_FMR_FNABSD_FNABSS_FNEGD_FNEGS
  { 1, 222, 224, 2788, 2791 }, // 398 SETB_SETB8
  { 1, 222, 224, 2791, 2794 }, // 399 SETBC_SETBC8_SETBCR_SETBCR8_SETNBC_SETNBC8_SETNBCR_SETNBCR8
  { 0, 0, 0, 0, 0 }, // 400 VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VNEGD_VNEGW
  { 0, 0, 0, 0, 0 }, // 401 VEXTSD2Q
  { 0, 0, 0, 0, 0 }, // 402 XSABSDP_XSNABSDP_XSNEGDP_XSXEXPDP
  { 0, 0, 0, 0, 0 }, // 403 XSABSQP_XSNABSQP_XSNEGQP_XSXEXPQP_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVNEGDP_XVNEGSP_XVXEXPDP_XVXEXPSP
  { 0, 0, 0, 0, 0 }, // 404 XVXSIGDP_XVXSIGSP
  { 1, 222, 224, 2794, 2797 }, // 405 ADD4_ADD4TLS_ADD8_ADD8TLS_ADD8TLS__ADD4_rec_ADD8_rec_ADD4O_ADD8O_AND_AND8_AND8_rec_AND_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_EQV_EQV8_EQV8_rec_EQV_rec_NAND_NAND8_NAND8_rec_NAND_rec_NOR_NOR8_NOR8_rec_NOR_rec_OR_OR8_OR8_rec_OR_rec_ORC_ORC8_ORC8_rec_ORC_rec_ORIS_ORIS8_XOR_XOR8_XOR8_rec_XOR_rec_XORI_XORI8_XORIS_XORIS8
  { 1, 222, 224, 2797, 2800 }, // 406 ADDE_ADDE8_ADDE8O_ADDEO_ADDIC_ADDIC8_ANDI8_rec_ANDI_rec_ANDIS8_rec_ANDIS_rec_SUBF_SUBF8_SUBF8_rec_SUBF_rec_SUBFE_SUBFE8_SUBFE8O_SUBFEO_SUBFIC_SUBFIC8_SUBF8O_SUBFO
  { 1, 222, 224, 2800, 2803 }, // 407 CMPB_CMPB8
  { 0, 0, 0, 0, 0 }, // 408 EXTSWSLI_EXTSWSLI_32_64_SRADI_SRADI_32
  { 1, 222, 224, 2803, 2806 }, // 409 SLW_SLW8_SRW_SRW8
  { 0, 0, 0, 0, 0 }, // 410 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEQV_VNAND_VORC_VSLD_VSRAD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_XXLAND_XXLANDC_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC
  { 0, 0, 0, 0, 0 }, // 411 VAND_VANDC_VMRGEW_VMRGOW_VNOR_VOR_VRLB_VRLD_VRLDNM_VRLH_VRLW_VRLWNM_VSLB_VSLH_VSLW_VSRAB_VSRAH_VSRAW_VSRB_VSRH_VSRW_XSCPSGNQP_XSIEXPQP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP
  { 0, 0, 0, 0, 0 }, // 412 VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW
  { 1, 222, 224, 2806, 2809 }, // 413 ADDEX_ADDEX8
  { 1, 220, 222, 2809, 2811 }, // 414 DST_DST64_DSTT_DSTT64_DSTST_DSTST64_DSTSTT_DSTSTT64
  { 0, 0, 0, 0, 0 }, // 415 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32
  { 1, 244, 246, 2811, 2812 }, // 416 MFFS_MFFS_rec_MFFSL
  { 1, 222, 224, 2812, 2814 }, // 417 TRECHKPT
  { 1, 222, 224, 2814, 2817 }, // 418 ADDME8_rec_ADDME_rec_ADDME8O_rec_ADDMEO_rec_ADDZE8_rec_ADDZE_rec_ADDZE8O_rec_ADDZEO_rec_SUBFME8_rec_SUBFME_rec_SUBFME8O_rec_SUBFMEO_rec_SUBFZE8_rec_SUBFZE_rec_SUBFZE8O_rec_SUBFZEO_rec
  { 1, 244, 246, 2817, 2820 }, // 419 MTFSB0
  { 1, 222, 224, 2820, 2823 }, // 420 NEG8O_rec_NEGO_rec
  { 1, 222, 224, 2823, 2826 }, // 421 ADDE8_rec_ADDE_rec_ADDE8O_rec_ADDEO_rec_ADDIC_rec_SUBFE8_rec_SUBFE_rec_SUBFE8O_rec_SUBFEO_rec_SUBF8O_rec_SUBFO_rec
  { 1, 224, 226, 2826, 2828 }, // 422 HRFID
  { 1, 233, 235, 2828, 2831 }, // 423 FABSD_rec_FABSS_rec_FMR_rec_FNABSD_rec_FNABSS_rec_FNEGD_rec_FNEGS_rec
  { 1, 224, 226, 2831, 2833 }, // 424 SC
  { 1, 222, 224, 2833, 2836 }, // 425 ADDC_ADDC8_ADDC8O_ADDCO_SUBFC_SUBFC8_SUBFC8O_SUBFCO
  { 1, 222, 224, 2836, 2839 }, // 426 ADDC8_rec_ADDC_rec_SUBFC8_rec_SUBFC_rec
  { 1, 244, 246, 2839, 2840 }, // 427 MTFSF_MTFSFI_MTFSFIb
  { 1, 244, 246, 2840, 2841 }, // 428 MTFSFI_rec
  { 0, 0, 0, 0, 0 }, // 429 VSTRIBL_rec_VSTRIBR_rec_VSTRIHL_rec_VSTRIHR_rec
  { 1, 220, 222, 2841, 2843 }, // 430 LBZ_LBZ8_LDBRX_LHBRX_LHBRX8_LHZ_LHZ8_LWBRX_LWBRX8_LWZ_LWZ8
  { 0, 0, 0, 0, 0 }, // 431 LD
  { 0, 0, 0, 0, 0 }, // 432 LDtoc_LDtocBA_LDtocCPT_LDtocJTI_LDtocL_SPILLTOVSR_LD_LWZtoc_LWZtocL
  { 1, 220, 222, 2843, 2846 }, // 433 LXVRBX_LXVRDX_LXVRHX_LXVRWX
  { 1, 220, 222, 2846, 2848 }, // 434 DCBT_DCBTST
  { 1, 220, 222, 2848, 2850 }, // 435 ICBT_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32
  { 0, 0, 0, 0, 0 }, // 436 LDX_LDXTLS_LDXTLS_
  { 0, 0, 0, 0, 0 }, // 437 SPILLTOVSR_LDX
  { 1, 220, 222, 2850, 2852 }, // 438 LBZCIX_LDCIX_LHZCIX_LWZCIX
  { 1, 250, 252, 2852, 2854 }, // 439 MTSR
  { 1, 222, 224, 2854, 2857 }, // 440 MTVRSAVE_MTVRSAVEv
  { 1, 220, 222, 2857, 2859 }, // 441 LSWI
  { 1, 220, 222, 2859, 2862 }, // 442 PLBZ_PLBZ8_PLBZ8pc_PLBZpc_PLD_PLDpc_PLFD_PLFDpc_PLFS_PLFSpc_PLHA_PLHA8_PLHA8pc_PLHApc_PLHZ_PLHZ8_PLHZ8pc_PLHZpc_PLWA_PLWA8_PLWA8pc_PLWApc_PLWZ_PLWZ8_PLWZ8pc_PLWZpc_PLXSD_PLXSDpc_PLXSSP_PLXSSPpc_PLXV_PLXVpc_PLXVP_PLXVPpc
  { 1, 220, 222, 2862, 2865 }, // 443 LXVP_LXVPX
  { 1, 246, 248, 2865, 2867 }, // 444 MFSR
  { 1, 246, 248, 2867, 2869 }, // 445 MFTB8
  { 0, 0, 0, 0, 0 }, // 446 XXSETACCZ
  { 0, 0, 0, 0, 0 }, // 447 XVBF16GER2_XVF16GER2_XVF32GER_XVF64GER_XVI16GER2_XVI16GER2S_XVI4GER8_XVI8GER4
  { 0, 0, 0, 0, 0 }, // 448 XVBF16GER2NN_XVBF16GER2NP_XVBF16GER2PN_XVBF16GER2PP_XVF16GER2NN_XVF16GER2NP_XVF16GER2PN_XVF16GER2PP_XVF32GERNN_XVF32GERNP_XVF32GERPN_XVF32GERPP_XVF64GERNN_XVF64GERNP_XVF64GERPN_XVF64GERPP_XVI16GER2PP_XVI16GER2SPP_XVI4GER8PP_XVI8GER4PP
  { 0, 0, 0, 0, 0 }, // 449 XVI8GER4SPP
  { 0, 0, 0, 0, 0 }, // 450 PMXVF32GER_PMXVF64GER
  { 0, 0, 0, 0, 0 }, // 451 PMXVBF16GER2_PMXVF16GER2_PMXVF32GERNN_PMXVF32GERNP_PMXVF32GERPN_PMXVF32GERPP_PMXVF64GERNN_PMXVF64GERNP_PMXVF64GERPN_PMXVF64GERPP_PMXVI16GER2_PMXVI16GER2S_PMXVI4GER8_PMXVI8GER4
  { 0, 0, 0, 0, 0 }, // 452 PMXVBF16GER2NN_PMXVBF16GER2NP_PMXVBF16GER2PN_PMXVBF16GER2PP_PMXVF16GER2NN_PMXVF16GER2NP_PMXVF16GER2PN_PMXVF16GER2PP_PMXVI16GER2PP_PMXVI16GER2SPP_PMXVI4GER8PP_PMXVI8GER4PP
  { 0, 0, 0, 0, 0 }, // 453 PMXVI8GER4SPP
  { 0, 0, 0, 0, 0 }, // 454 XXMTACC
  { 0, 0, 0, 0, 0 }, // 455 XXMFACC
  { 0, 0, 0, 0, 0 }, // 456 MULLD_MULLDO
  { 0, 0, 0, 0, 0 }, // 457 VMULHSD_VMULHUD_VMULLD
  { 0, 0, 0, 0, 0 }, // 458 VSPLTISW
  { 0, 0, 0, 0, 0 }, // 459 V_SETALLONES_V_SETALLONESB_V_SETALLONESH
  { 0, 0, 0, 0, 0 }, // 460 MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VPRTYBQ
  { 0, 0, 0, 0, 0 }, // 461 VGBBD_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW
  { 0, 0, 0, 0, 0 }, // 462 VSPLTISB_VSPLTISH_XXSPLTIB
  { 0, 0, 0, 0, 0 }, // 463 VSTRIBL_VSTRIBR_VSTRIHL_VSTRIHR
  { 0, 0, 0, 0, 0 }, // 464 XVCVBF16SPN
  { 0, 0, 0, 0, 0 }, // 465 VBPERMQ_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLO_VSLV_VSR_VSRO_VSRV_XXEXTRACTUW
  { 0, 0, 0, 0, 0 }, // 466 VCLRLB_VCLRRB_XXGENPCVDM_XXGENPCVHM_XXGENPCVWM
  { 0, 0, 0, 0, 0 }, // 467 VEXTRACTD_VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VINSERTD_VINSERTW
  { 0, 0, 0, 0, 0 }, // 468 VEXTDDVLX_VEXTDDVRX_VEXTDUBVLX_VEXTDUBVRX_VEXTDUHVLX_VEXTDUHVRX_VEXTDUWVLX_VEXTDUWVRX_VINSBLX_VINSBRX_VINSBVLX_VINSBVRX_VINSD_VINSDLX_VINSDRX_VINSHLX_VINSHRX_VINSHVLX_VINSHVRX_VINSW_VINSWLX_VINSWRX_VINSWVLX_VINSWVRX_VSLDBI_VSRDBI
  { 0, 0, 0, 0, 0 }, // 469 VSUMSWS
  { 0, 0, 0, 0, 0 }, // 470 XXSPLTIDP_XXSPLTIW
  { 0, 0, 0, 0, 0 }, // 471 XXBLENDVB_XXBLENDVD_XXBLENDVH_XXBLENDVW_XXSPLTI32DX
  { 0, 0, 0, 0, 0 }, // 472 XXEVAL
  { 0, 0, 0, 0, 0 }, // 473 XXPERMX
  { 1, 220, 222, 2869, 2871 }, // 474 DCBST_DCBZ
  { 1, 220, 222, 2871, 2873 }, // 475 ICBI
  { 1, 220, 222, 2873, 2875 }, // 476 DCBF
  { 1, 220, 222, 2875, 2878 }, // 477 PSTXVP_PSTXVPpc
  { 1, 220, 222, 2878, 2880 }, // 478 STB_STB8_STDBRX_STH_STH8_STHBRX_STW_STW8_STWBRX
  { 0, 0, 0, 0, 0 }, // 479 SPILLTOVSR_ST
  { 0, 0, 0, 0, 0 }, // 480 STD
  { 0, 0, 0, 0, 0 }, // 481 DFSTOREf32_DFSTOREf64_STIWX
  { 1, 220, 222, 2880, 2883 }, // 482 STXVRBX_STXVRDX_STXVRHX_STXVRWX
  { 0, 0, 0, 0, 0 }, // 483 SPILLTOVSR_STX
  { 1, 220, 222, 2883, 2885 }, // 484 EnforceIEIO
  { 1, 220, 222, 2885, 2887 }, // 485 STBCIX_STDCIX_STHCIX_STWCIX
  { 1, 220, 222, 2887, 2890 }, // 486 PSTB_PSTB8_PSTB8pc_PSTBpc_PSTD_PSTDpc_PSTFD_PSTFDpc_PSTFS_PSTFSpc_PSTH_PSTH8_PSTH8pc_PSTHpc_PSTW_PSTW8_PSTW8pc_PSTWpc_PSTXSD_PSTXSDpc_PSTXSSP_PSTXSSPpc_PSTXV_PSTXVpc
  { 1, 220, 222, 2890, 2893 }, // 487 STXVP_STXVPX
  { 1, 224, 226, 2893, 2895 }, // 488 ATTN_NAP
  { 1, 220, 222, 2895, 2897 }, // 489 DCBZL
  { 1, 220, 222, 2897, 2899 }, // 490 DCCCI_ICBLQ_ICCCI_TLBLD_TLBLI_TLBRE2_TLBSX2_TLBSX2D_TLBWE2
  { 1, 220, 222, 2899, 2901 }, // 491 ICBLC
  { 1, 224, 226, 2901, 2903 }, // 492 CLRBHRB
  { 1, 224, 226, 2903, 2905 }, // 493 MFBHRBE
  { 1, 220, 222, 2905, 2908 }, // 494 PADDI_PADDI8_PADDI8pc_PADDIpc
  { 1, 222, 224, 2908, 2911 }, // 495 PLI_PLI8
  { 0, 0, 0, 0, 0 }, // 496 VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS
  { 0, 0, 0, 0, 0 }, // 497 VMULESD_VMULEUD_VMULHSW_VMULHUW_VMULOSD_VMULOUD
  { 0, 0, 0, 0, 0 }, // 498 VMSUMCUD
  { 0, uint16_t(~0U), uint16_t(~0U), uint16_t(~0U), uint16_t(~0U) }// end marker
};

static const llvm::InstrItinerary PPCE5500Itineraries[] = {
  { 0, 0, 0, 0, 0 }, // 0 NoInstrModel
  { 1, 258, 260, 0, 0 }, // 1 IIC_LdStSync
  { 1, 260, 262, 2911, 2914 }, // 2 IIC_IntSimple
  { 1, 260, 262, 2914, 2917 }, // 3 IIC_IntGeneral
  { 1, 262, 264, 2917, 2919 }, // 4 IIC_BrB
  { 0, 0, 0, 0, 0 }, // 5 IIC_VecFP
  { 1, 260, 262, 2919, 2922 }, // 6 IIC_IntCompare
  { 0, 0, 0, 0, 0 }, // 7 IIC_SprABORT
  { 0, 0, 0, 0, 0 }, // 8 IIC_LdStCOPY
  { 0, 0, 0, 0, 0 }, // 9 IIC_LdStPASTE
  { 1, 262, 264, 2922, 2925 }, // 10 IIC_BrCR
  { 1, 258, 260, 2925, 2927 }, // 11 IIC_LdStLD
  { 1, 258, 260, 2927, 2929 }, // 12 IIC_LdStDCBF
  { 1, 258, 260, 2929, 2931 }, // 13 IIC_LdStLoad
  { 1, 264, 267, 2931, 2934 }, // 14 IIC_IntDivD
  { 1, 267, 270, 2934, 2937 }, // 15 IIC_IntDivW
  { 0, 0, 0, 0, 0 }, // 16 IIC_FPDGeneral
  { 1, 270, 272, 2937, 2940 }, // 17 IIC_FPAddSub
  { 1, 272, 274, 2940, 2943 }, // 18 IIC_FPDivD
  { 0, 0, 0, 0, 0 }, // 19 IIC_FPSGeneral
  { 1, 270, 272, 2943, 2946 }, // 20 IIC_FPCompare
  { 1, 270, 272, 2946, 2949 }, // 21 IIC_FPGeneral
  { 0, 0, 0, 0, 0 }, // 22 IIC_VecGeneral
  { 0, 0, 0, 0, 0 }, // 23 IIC_VecComplex
  { 1, 258, 260, 2949, 2951 }, // 24 IIC_LdStStore
  { 1, 260, 262, 2951, 2954 }, // 25 IIC_IntRotateDI
  { 1, 274, 276, 2954, 2957 }, // 26 IIC_FPDivS
  { 1, 270, 272, 2957, 2961 }, // 27 IIC_FPFused
  { 0, 0, 0, 0, 0 }, // 28 IIC_FPSqrtD
  { 0, 0, 0, 0, 0 }, // 29 IIC_FPSqrtS
  { 1, 258, 260, 2961, 2963 }, // 30 IIC_LdStICBI
  { 1, 260, 262, 2963, 2967 }, // 31 IIC_IntISEL
  { 0, 0, 0, 0, 0 }, // 32 IIC_SprISYNC
  { 1, 276, 278, 2967, 2970 }, // 33 IIC_LdStLWARX
  { 2, 278, 281, 2970, 2972 }, // 34 IIC_LdStLoadUpd
  { 2, 278, 281, 2972, 2974 }, // 35 IIC_LdStLoadUpdX
  { 1, 276, 278, 2974, 2976 }, // 36 IIC_LdStLDARX
  { 2, 278, 281, 2976, 2978 }, // 37 IIC_LdStLDU
  { 2, 278, 281, 2978, 2980 }, // 38 IIC_LdStLDUX
  { 2, 258, 260, 2980, 2983 }, // 39 IIC_LdStLFD
  { 2, 278, 281, 2983, 2986 }, // 40 IIC_LdStLFDU
  { 2, 278, 281, 2986, 2989 }, // 41 IIC_LdStLFDUX
  { 1, 258, 260, 2989, 2991 }, // 42 IIC_LdStLHA
  { 2, 278, 281, 2991, 2993 }, // 43 IIC_LdStLHAU
  { 2, 278, 281, 2993, 2995 }, // 44 IIC_LdStLHAUX
  { 1, 281, 283, 2995, 2997 }, // 45 IIC_LdStLMW
  { 0, 0, 0, 0, 0 }, // 46 IIC_LdStLQ
  { 0, 0, 0, 0, 0 }, // 47 IIC_LdStLQARX
  { 0, 0, 0, 0, 0 }, // 48 IIC_LdStLWA
  { 1, 283, 286, 2997, 3000 }, // 49 IIC_IntMulHD
  { 1, 262, 264, 3000, 3002 }, // 50 IIC_BrMCR
  { 1, 286, 288, 3002, 3005 }, // 51 IIC_BrMCRX
  { 1, 288, 290, 3005, 3007 }, // 52 IIC_SprMFCR
  { 1, 286, 288, 3007, 3008 }, // 53 IIC_SprMFSPR
  { 1, 270, 272, 3008, 3009 }, // 54 IIC_IntMFFS
  { 0, 0, 0, 0, 0 }, // 55 IIC_SprMFMSR
  { 1, 288, 290, 3009, 3011 }, // 56 IIC_SprMFCRF
  { 1, 290, 292, 3011, 3013 }, // 57 IIC_SprMFPMR
  { 0, 0, 0, 0, 0 }, // 58 IIC_SprMFSR
  { 1, 290, 292, 3013, 3015 }, // 59 IIC_SprMFTB
  { 0, 0, 0, 0, 0 }, // 60 IIC_SprMSGSYNC
  { 1, 286, 288, 3015, 3016 }, // 61 IIC_SprMTSPR
  { 1, 292, 294, 3016, 3019 }, // 62 IIC_IntMTFSB0
  { 1, 294, 296, 3019, 3021 }, // 63 IIC_SprMTMSR
  { 0, 0, 0, 0, 0 }, // 64 IIC_SprMTMSRD
  { 1, 286, 288, 3021, 3022 }, // 65 IIC_SprMTPMR
  { 0, 0, 0, 0, 0 }, // 66 IIC_SprMTSR
  { 1, 296, 299, 3022, 3025 }, // 67 IIC_IntMulHW
  { 1, 296, 299, 3025, 3028 }, // 68 IIC_IntMulHWU
  { 1, 283, 286, 3028, 3031 }, // 69 IIC_IntMulLI
  { 0, 0, 0, 0, 0 }, // 70 IIC_SprRFI
  { 0, 0, 0, 0, 0 }, // 71 IIC_IntRFID
  { 1, 299, 301, 3031, 3034 }, // 72 IIC_IntRotateD
  { 1, 260, 262, 3034, 3037 }, // 73 IIC_IntRotate
  { 0, 0, 0, 0, 0 }, // 74 IIC_SprSLBFEE
  { 0, 0, 0, 0, 0 }, // 75 IIC_SprSLBIA
  { 0, 0, 0, 0, 0 }, // 76 IIC_SprSLBIE
  { 0, 0, 0, 0, 0 }, // 77 IIC_SprSLBIEG
  { 0, 0, 0, 0, 0 }, // 78 IIC_SprSLBMFEE
  { 0, 0, 0, 0, 0 }, // 79 IIC_SprSLBMFEV
  { 0, 0, 0, 0, 0 }, // 80 IIC_SprSLBMTE
  { 0, 0, 0, 0, 0 }, // 81 IIC_SprSLBSYNC
  { 1, 299, 301, 3037, 3040 }, // 82 IIC_IntShift
  { 1, 258, 260, 3040, 3042 }, // 83 IIC_LdStSTWCX
  { 2, 278, 281, 3042, 3044 }, // 84 IIC_LdStSTU
  { 2, 278, 281, 3044, 3046 }, // 85 IIC_LdStSTUX
  { 1, 258, 260, 3046, 3048 }, // 86 IIC_LdStSTD
  { 1, 258, 260, 3048, 3050 }, // 87 IIC_LdStSTDCX
  { 1, 258, 260, 3050, 3053 }, // 88 IIC_LdStSTFD
  { 2, 278, 281, 3053, 3056 }, // 89 IIC_LdStSTFDU
  { 0, 0, 0, 0, 0 }, // 90 IIC_SprSTOP
  { 0, 0, 0, 0, 0 }, // 91 IIC_LdStSTQ
  { 0, 0, 0, 0, 0 }, // 92 IIC_LdStSTQCX
  { 0, 0, 0, 0, 0 }, // 93 IIC_IntTrapD
  { 0, 0, 0, 0, 0 }, // 94 IIC_SprTLBIA
  { 0, 0, 0, 0, 0 }, // 95 IIC_SprTLBIE
  { 0, 0, 0, 0, 0 }, // 96 IIC_SprTLBIEL
  { 1, 301, 303, 0, 0 }, // 97 IIC_SprTLBSYNC
  { 1, 303, 305, 3056, 3058 }, // 98 IIC_IntTrapW
  { 0, 0, 0, 0, 0 }, // 99 IIC_VecFPCompare
  { 0, 0, 0, 0, 0 }, // 100 IIC_VecPerm
  { 0, 0, 0, 0, 0 }, // 101 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VSLD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_VPOPCNTB_VPOPCNTH_VSRAD_MTVSRDD_VEQV_VNAND_VNEGD_VNEGW_VORC_XXLAND_XXLANDC_XXLEQV_XXLEQVOnes_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 0, 0, 0, 0, 0 }, // 102 VAND_VANDC_V_SET0_V_SET0B_V_SET0H_VSLB_VSLH_VSLW_VSRB_VSRH_VSRW_VRLB_VRLD_VRLH_VRLW_VSRAB_VSRAH_VSRAW_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP_XVXEXPDP_XVXEXPSP_VRLDMI_VRLDNM_VRLWMI_VRLWNM_VMRGEW_VMRGOW_VNOR_VOR_VSEL_VXOR_XVNEGDP_XVNEGSP_XSABSQP_XSCPSGNQP_XSIEXPQP_XSNABSQP_XSNEGQP_XSXEXPQP
  { 0, 0, 0, 0, 0 }, // 103 XXSEL
  { 1, 286, 288, 3058, 3059 }, // 104 TABORTDC_TABORTDCI_TABORTWC_TABORTWCI
  { 1, 292, 294, 3059, 3062 }, // 105 MTFSB0_MTFSB1
  { 1, 270, 272, 3062, 3063 }, // 106 MFFSCDRN_MFFSCDRNI_MFFSCRN_MFFSCRNI
  { 1, 260, 262, 3063, 3066 }, // 107 CMPRB_CMPRB8_CMPEQB
  { 0, 0, 0, 0, 0 }, // 108 TD_TDI
  { 1, 303, 305, 3066, 3068 }, // 109 TW_TWI
  { 1, 270, 272, 3068, 3071 }, // 110 FCMPOD_FCMPOS_FCMPUD_FCMPUS_FTDIV_FTSQRT
  { 0, 0, 0, 0, 0 }, // 111 XSTSTDCDP_XSTSTDCSP
  { 0, 0, 0, 0, 0 }, // 112 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP_XSXSIGDP_XSCVSPDPN
  { 1, 270, 272, 3071, 3074 }, // 113 XSCMPEQDP_XSCMPEXPDP_XSCMPGEDP_XSCMPGTDP_XSCMPODP_XSCMPUDP_XSTDIVDP_XSTSQRTDP
  { 1, 260, 262, 3074, 3077 }, // 114 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW_CMPB_CMPB8_SETB_SETB8_BPERMD
  { 1, 299, 301, 3077, 3080 }, // 115 SLD_SRD_SRAD
  { 1, 260, 262, 3080, 3083 }, // 116 SRADI_EXTSWSLI_32_64_EXTSWSLI_SRADI_32_RLDIC
  { 0, 0, 0, 0, 0 }, // 117 MFVRD_MFVSRD_MTVRD_MTVSRD_MTVRWA_MTVRWZ_MTVSRWA_MTVSRWZ_MFVSRWZ_MFVRWZ
  { 1, 260, 262, 3083, 3086 }, // 118 CMPLW_CMPLWI_CMPW_CMPWI_CMPD_CMPDI_CMPLD_CMPLDI
  { 1, 260, 262, 3086, 3089 }, // 119 SUBFC_SUBFC8_SUBFC8O_SUBFCO_SUBFIC_SUBFIC8_ANDI8_rec_ANDIS8_rec_ANDIS_rec_ANDI_rec_ADDC_ADDC8_ADDC8O_ADDCO_ADDIC_ADDIC8_ADDIC_rec_ADDE_ADDE8_ADDE8O_ADDE8O_rec_ADDE8_rec_ADDEO_ADDEO_rec_ADDE_rec_ADDME_ADDME8_ADDME8O_ADDME8O_rec_ADDME8_rec_ADDMEO_ADDMEO_rec_ADDME_rec_ADDZE_ADDZE8_ADDZE8O_ADDZE8O_rec_ADDZE8_rec_ADDZEO_ADDZEO_rec_ADDZE_rec_SUBF_SUBF8_SUBF8O_SUBF8O_rec_SUBF8_rec_SUBFE_SUBFE8_SUBFE8O_SUBFE8O_rec_SUBFE8_rec_SUBFEO_SUBFEO_rec_SUBFE_rec_SUBFME_SUBFME8_SUBFME8O_SUBFME8O_rec_SUBFME8_rec_SUBFMEO_SUBFMEO_rec_SUBFME_rec_SUBFO_SUBFO_rec_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZE8O_rec_SUBFZE8_rec_SUBFZEO_SUBFZEO_rec_SUBFZE_rec_SUBF_rec_POPCNTB_POPCNTB8_LA_LA8
  { 1, 260, 262, 3089, 3092 }, // 120 ADD4_ADD4O_ADD4O_rec_ADD4_rec_ADD8_ADD8O_ADD8O_rec_ADD8_rec_NEG_NEG8_NEG8O_NEG8O_rec_NEG8_rec_NEGO_NEGO_rec_NEG_rec_ADDI_ADDI8_ADDIS_ADDIS8_LI_LI8_LIS_LIS8_OR_OR8_OR8_rec_ORI_ORI8_ORIS_ORIS8_OR_rec_XOR_XOR8_XOR8_rec_XORI_XORI8_XORIS_XORIS8_XOR_rec_NAND_NAND8_NAND8_rec_NAND_rec_AND_AND8_AND8_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_AND_rec_NOR_NOR8_NOR8_rec_NOR_rec_ORC_ORC8_ORC8_rec_ORC_rec_EQV_EQV8_EQV8_rec_EQV_rec_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_ADD4TLS_ADD8TLS_ADD8TLS__NOP
  { 0, 0, 0, 0, 0 }, // 121 ADDIStocHA_ADDIStocHA8_ADDItocL_COPY
  { 1, 262, 264, 3092, 3094 }, // 122 MCRF
  { 1, 286, 288, 3094, 3097 }, // 123 MCRXRX
  { 0, 0, 0, 0, 0 }, // 124 XSNABSDP_XSXEXPDP_XSABSDP_XSNEGDP_XSCPSGNDP
  { 1, 262, 264, 3097, 3099 }, // 125 RFEBB
  { 1, 286, 288, 3099, 3100 }, // 126 TBEGIN_TRECHKPT
  { 1, 258, 260, 3100, 3102 }, // 127 WAIT
  { 1, 299, 301, 3102, 3105 }, // 128 RLDCL_RLDCR
  { 1, 260, 262, 3105, 3108 }, // 129 RLWIMI_RLWIMI8
  { 1, 260, 262, 3108, 3111 }, // 130 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32_RLDIMI
  { 1, 288, 290, 3111, 3113 }, // 131 MFOCRF_MFOCRF8
  { 1, 286, 288, 3113, 3116 }, // 132 MTOCRF_MTOCRF8
  { 1, 262, 264, 3116, 3119 }, // 133 CR6SET_CR6UNSET_CRSET_CRUNSET_CRAND_CRANDC_CRNAND_CRNOR_CROR_CRORC_CREQV_CRXOR
  { 1, 260, 262, 3119, 3122 }, // 134 SLW_SLW8_SRW_SRW8_RLWINM_RLWINM8_RLWNM_RLWNM8
  { 1, 270, 272, 3122, 3125 }, // 135 FABSD_FABSS_FNABSD_FNABSS_FNEGD_FNEGS_FCPSGND_FCPSGNS_FMR
  { 1, 299, 301, 3125, 3128 }, // 136 SRAW_SRAWI
  { 1, 260, 262, 3128, 3132 }, // 137 ISEL_ISEL8
  { 0, 0, 0, 0, 0 }, // 138 XSIEXPDP
  { 1, 286, 288, 3132, 3133 }, // 139 TRECLAIM_TSR_TABORT
  { 1, 258, 260, 3133, 3135 }, // 140 MFVSCR
  { 1, 258, 260, 3135, 3137 }, // 141 MTVSCR
  { 0, 0, 0, 0, 0 }, // 142 VCMPNEZB_VCMPNEZH_VCMPNEZW_VCMPEQUB_VCMPEQUD_VCMPEQUH_VCMPEQUW_VCMPNEB_VCMPNEH_VCMPNEW_VCMPEQFP_VCMPEQFP_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPBFP_VCMPBFP_rec_VCMPGTSB_VCMPGTSB_rec_VCMPGTSD_VCMPGTSD_rec_VCMPGTSH_VCMPGTSH_rec_VCMPGTSW_VCMPGTSW_rec_VCMPGTUB_VCMPGTUB_rec_VCMPGTUD_VCMPGTUD_rec_VCMPGTUH_VCMPGTUH_rec_VCMPGTUW_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 0, 0, 0, 0, 0 }, // 143 VABSDUB_VABSDUH_VABSDUW_VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTW_VPOPCNTD_VPRTYBD_VPRTYBW
  { 0, 0, 0, 0, 0 }, // 144 VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VADDSBS_VADDSHS_VADDSWS_VMAXFP_VMINFP_VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW_VBPERMD_VADDCUW_VSHASIGMAD_VSHASIGMAW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_VSUBCUW_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP_XVXSIGDP_XVXSIGSP
  { 1, 270, 272, 3137, 3140 }, // 145 XVTDIVDP_XVTDIVSP_XVTSQRTDP_XVTSQRTSP
  { 0, 0, 0, 0, 0 }, // 146 VADDFP_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VEXPTEFP_VLOGEFP_VMADDFP_VMHADDSHS_VNMSUBFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVADDDP_XVADDSP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVHPSP_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVMULDP_XVMULSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP_XVSUBDP_XVSUBSP_VCFSX_VCFSX_0_VCFUX_VCFUX_0_VMHRADDSHS_VMLADDUHM_VMSUMMBM_VMSUMSHM_VMSUMSHS_VMSUMUBM_VMSUMUHM_VMSUMUDM_VMSUMUHS_VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS_VSUMSWS
  { 0, 0, 0, 0, 0 }, // 147 VSUBFP_VMULUWM
  { 1, 283, 286, 3140, 3143 }, // 148 MADDHD_MADDHDU_MADDLD_MADDLD8_MULLD_MULLDO
  { 1, 296, 299, 3143, 3146 }, // 149 MULHD_MULHW_MULLW_MULLWO
  { 1, 296, 299, 3146, 3149 }, // 150 MULHDU_MULHWU
  { 1, 283, 286, 3149, 3152 }, // 151 MULLI_MULLI8
  { 1, 270, 272, 3152, 3155 }, // 152 FRSP_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRE_FRES_FADDS_FMSUBS_FMADDS_FSUBS_FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRSQRTE_FRSQRTES_FNMADDS_FNMSUBS_FSELD_FSELS_FMULS
  { 1, 270, 272, 3155, 3158 }, // 153 FADD_FSUB
  { 1, 270, 272, 3158, 3162 }, // 154 FMSUB_FMADD_FNMADD_FNMSUB_FMUL
  { 0, 0, 0, 0, 0 }, // 155 XSMADDADP_XSMADDASP_XSMADDMDP_XSMADDMSP_XSMSUBADP_XSMSUBASP_XSMSUBMDP_XSMSUBMSP_XSMULDP_XSMULSP_XSNMADDADP_XSNMADDASP_XSNMADDMDP_XSNMADDMSP_XSNMSUBADP_XSNMSUBASP_XSNMSUBMDP_XSNMSUBMSP
  { 1, 270, 272, 3162, 3165 }, // 156 FSELD_rec_FSELS_rec
  { 1, 296, 299, 3165, 3168 }, // 157 MULHDU_rec_MULHWU_rec
  { 1, 296, 299, 3168, 3171 }, // 158 MULHD_rec_MULHW_rec_MULLWO_rec_MULLW_rec
  { 1, 283, 286, 3171, 3174 }, // 159 MULLDO_rec_MULLD_rec
  { 1, 270, 272, 3174, 3177 }, // 160 FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRES_rec_FRE_rec_FADDS_rec_FSUBS_rec_FMSUBS_rec_FNMSUBS_rec_FMADDS_rec_FNMADDS_rec_FCFIDS_rec_FCFIDUS_rec_FCFIDU_rec_FCFID_rec_FCTIDUZ_rec_FCTIDU_rec_FCTIDZ_rec_FCTID_rec_FCTIWUZ_rec_FCTIWU_rec_FCTIWZ_rec_FCTIW_rec_FMULS_rec_FRSQRTES_rec_FRSQRTE_rec_FRSP_rec
  { 1, 270, 272, 3177, 3180 }, // 161 FADD_rec_FSUB_rec
  { 1, 270, 272, 3180, 3184 }, // 162 FMSUB_rec_FNMSUB_rec_FMADD_rec_FNMADD_rec_FMUL_rec
  { 0, 0, 0, 0, 0 }, // 163 XSADDDP_XSADDSP_XSCVDPHP_XSCVDPSP_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPSXWSs_XSCVDPUXWSs_XSCVHPDP_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSQRTEDP_XSRSQRTESP_XSSUBDP_XSSUBSP_XSCVDPSPN_XSRSP
  { 1, 258, 260, 3184, 3186 }, // 164 LVSL_LVSR
  { 0, 0, 0, 0, 0 }, // 165 VSPLTISB_VSPLTISH_VSPLTISW_VSPLTB_VSPLTBs_VSPLTH_VSPLTHs_VSPLTW_XXMRGHW_XXMRGLW_XXPERM_XXPERMR_XXSLDWI_XXSLDWIs_XXSPLTIB_XXSPLTW_XXSPLTWs_XXPERMDI_XXPERMDIs
  { 0, 0, 0, 0, 0 }, // 166 V_SETALLONES_V_SETALLONESB_V_SETALLONESH_VBPERMQ_VGBBD_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPERM_VPERMR_VPERMXOR_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLDOI_VSLO_VSLV_VSR_VSRO_VSRV_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW_XXEXTRACTUW_XXINSERTW_VADDCUQ_VADDECUQ_VADDEUQM_VMUL10CUQ_VMUL10ECUQ_VMUL10EUQ_VMUL10UQ_VSUBCUQ_VSUBECUQ_VSUBEUQM_XSTSTDCQP_XSXSIGQP_BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDS_rec_BCDTRUNC_rec_BCDUS_rec_BCDUTRUNC_rec_BCDADD_rec_BCDSUB_rec
  { 0, 0, 0, 0, 0 }, // 167 VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VINSERTB_VINSERTD_VINSERTH_VINSERTW_MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VEXTRACTD_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VPRTYBQ_VADDUQM_VSUBUQM
  { 1, 270, 272, 3186, 3189 }, // 168 XSCMPEXPQP_XSCMPOQP_XSCMPUQP
  { 0, 0, 0, 0, 0 }, // 169 BCDSR_rec_XSADDQP_XSADDQPO_XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP_XSRQPI_XSRQPIX_XSRQPXP_XSSUBQP_XSSUBQPO
  { 0, 0, 0, 0, 0 }, // 170 BCDCTSQ_rec
  { 0, 0, 0, 0, 0 }, // 171 XSMADDQP_XSMADDQPO_XSMSUBQP_XSMSUBQPO_XSMULQP_XSMULQPO_XSNMADDQP_XSNMADDQPO_XSNMSUBQP_XSNMSUBQPO
  { 0, 0, 0, 0, 0 }, // 172 BCDCFSQ_rec
  { 0, 0, 0, 0, 0 }, // 173 XSDIVQP_XSDIVQPO
  { 0, 0, 0, 0, 0 }, // 174 XSSQRTQP_XSSQRTQPO
  { 1, 258, 260, 3189, 3191 }, // 175 LXVL_LXVLL
  { 1, 258, 260, 3191, 3193 }, // 176 LVEBX_LVEHX_LVEWX_LVX_LVXL
  { 2, 258, 260, 3193, 3196 }, // 177 LXSIBZX_LXSIHZX_LXSDX_LXVB16X_LXVD2X_LXVWSX_LXSIWZX_LXV_LXVX_LXSD
  { 0, 0, 0, 0, 0 }, // 178 DFLOADf64_XFLOADf64_LIWZX
  { 1, 258, 260, 3196, 3198 }, // 179 DCBF_DCBFEP_DCBST_DCBSTEP_DCBT_DCBTEP_DCBZ_DCBZEP_DCBZL_DCBZLEP_DCBTST_DCBTSTEP
  { 0, 0, 0, 0, 0 }, // 180 CP_COPY_CP_COPY8
  { 1, 258, 260, 3198, 3200 }, // 181 ICBI_ICBIEP
  { 1, 258, 260, 3200, 3202 }, // 182 ICBT_ICBTLS_LBZ_LBZ8_LBZCIX_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LDBRX_LDCIX_LHBRX_LHBRX8_LHZ_LHZ8_LHZCIX_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWBRX_LWBRX8_LWZ_LWZ8_LWZCIX_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32_EnforceIEIO_LSWI
  { 1, 276, 278, 3202, 3205 }, // 183 LBARX_LBARXL_LHARX_LHARXL_LWARX_LWARXL
  { 1, 258, 260, 3205, 3207 }, // 184 LD_LDX_LDXTLS_LDXTLS__DARN
  { 1, 276, 278, 3207, 3209 }, // 185 LDARX_LDARXL
  { 0, 0, 0, 0, 0 }, // 186 CP_ABORT
  { 0, 0, 0, 0, 0 }, // 187 ISYNC
  { 0, 0, 0, 0, 0 }, // 188 MSGSYNC
  { 1, 301, 303, 0, 0 }, // 189 TLBSYNC
  { 1, 258, 260, 0, 0 }, // 190 SYNC
  { 1, 281, 283, 3209, 3211 }, // 191 LMW
  { 2, 258, 260, 3211, 3214 }, // 192 LFIWZX_LFDX_LFD
  { 0, 0, 0, 0, 0 }, // 193 SLBIA
  { 0, 0, 0, 0, 0 }, // 194 SLBIE
  { 0, 0, 0, 0, 0 }, // 195 SLBMFEE
  { 0, 0, 0, 0, 0 }, // 196 SLBMFEV
  { 0, 0, 0, 0, 0 }, // 197 SLBMTE
  { 0, 0, 0, 0, 0 }, // 198 TLBIEL
  { 2, 278, 281, 3214, 3216 }, // 199 LHZU_LHZU8_LWZU_LWZU8
  { 2, 278, 281, 3216, 3218 }, // 200 LHZUX_LHZUX8_LWZUX_LWZUX8
  { 1, 286, 288, 3218, 3219 }, // 201 TEND
  { 1, 258, 260, 3219, 3221 }, // 202 STBCX_STHCX_STWCX
  { 1, 258, 260, 3221, 3223 }, // 203 STDCX
  { 1, 258, 260, 3223, 3225 }, // 204 LDMX
  { 1, 258, 260, 3225, 3227 }, // 205 LHA_LHA8_LHAX_LHAX8_LWAX_LWAX_32
  { 0, 0, 0, 0, 0 }, // 206 CP_PASTE8_rec_CP_PASTE_rec
  { 0, 0, 0, 0, 0 }, // 207 LWA_LWA_32
  { 1, 286, 288, 3227, 3228 }, // 208 TCHECK
  { 2, 258, 260, 3228, 3231 }, // 209 LFIWAX
  { 2, 258, 260, 3231, 3234 }, // 210 LXSIWAX
  { 0, 0, 0, 0, 0 }, // 211 LIWAX
  { 2, 258, 260, 3234, 3237 }, // 212 LFSX_LFS
  { 2, 258, 260, 3237, 3240 }, // 213 LXSSP_LXSSPX
  { 0, 0, 0, 0, 0 }, // 214 XFLOADf32_DFLOADf32
  { 2, 278, 281, 3240, 3242 }, // 215 LHAU_LHAU8
  { 2, 278, 281, 3242, 3244 }, // 216 LHAUX_LHAUX8_LWAUX
  { 2, 258, 260, 3244, 3247 }, // 217 LXVH8X_LXVDSX_LXVW4X
  { 1, 258, 260, 3247, 3250 }, // 218 STFD_STFDX_STFIWX_STFS_STFSX_STXSD_STXSDX_STXSIBX_STXSIBXv_STXSIHX_STXSIHXv_STXSIWX_STXSSP_STXSSPX
  { 1, 258, 260, 3250, 3252 }, // 219 STW_STW8_STDBRX_STHBRX_STWBRX_STB_STB8_STH_STH8_STBX_STBX8_STBXTLS_STBXTLS__STBXTLS_32_STHX_STHX8_STHXTLS_STHXTLS__STHXTLS_32_STWX_STWX8_STWXTLS_STWXTLS__STWXTLS_32
  { 0, 0, 0, 0, 0 }, // 220 DFSTOREf32_DFSTOREf64_XFSTOREf32_XFSTOREf64_STIWX
  { 1, 258, 260, 3252, 3254 }, // 221 STD_STDX_STDXTLS_STDXTLS_
  { 1, 258, 260, 3254, 3256 }, // 222 STBCIX_STDCIX_STHCIX_STWCIX_STSWI
  { 0, 0, 0, 0, 0 }, // 223 SLBIEG
  { 1, 281, 283, 3256, 3258 }, // 224 STMW
  { 0, 0, 0, 0, 0 }, // 225 TLBIE
  { 1, 258, 260, 3258, 3260 }, // 226 STVEBX_STVEHX_STVEWX_STVX_STVXL
  { 1, 258, 260, 3260, 3263 }, // 227 STXV_STXVB16X_STXVD2X_STXVH8X_STXVW4X_STXVX
  { 1, 258, 260, 3263, 3265 }, // 228 STXVL_STXVLL
  { 1, 286, 288, 3265, 3266 }, // 229 MTCTR_MTCTR8_MTCTR8loop_MTCTRloop_MTLR_MTLR8
  { 1, 260, 262, 3266, 3269 }, // 230 MFVRSAVE_MFVRSAVEv_MTVRSAVE_MTVRSAVEv
  { 1, 290, 292, 3269, 3271 }, // 231 MFPMR
  { 1, 286, 288, 3271, 3272 }, // 232 MTPMR
  { 1, 290, 292, 3272, 3274 }, // 233 MFTB_MFTB8
  { 1, 286, 288, 3274, 3275 }, // 234 MFCTR_MFCTR8_MFLR_MFLR8_MFSPR_MFSPR8
  { 0, 0, 0, 0, 0 }, // 235 MFMSR
  { 1, 294, 296, 3275, 3277 }, // 236 MTMSR
  { 0, 0, 0, 0, 0 }, // 237 MTMSRD
  { 1, 286, 288, 3277, 3278 }, // 238 MTSPR_MTSPR8
  { 1, 267, 270, 3278, 3281 }, // 239 DIVW_DIVWO_DIVWU_DIVWUO_MODSW
  { 1, 267, 270, 3281, 3284 }, // 240 DIVWE_DIVWEO_DIVWEU_DIVWEUO_MODSD_MODUD_MODUW
  { 1, 264, 267, 3284, 3287 }, // 241 DIVD_DIVDO_DIVDU_DIVDUO
  { 1, 264, 267, 3287, 3290 }, // 242 DIVDE_DIVDEO_DIVDEU_DIVDEUO
  { 1, 267, 270, 3290, 3293 }, // 243 DIVWO_rec_DIVWUO_rec_DIVWU_rec_DIVW_rec
  { 1, 264, 267, 3293, 3296 }, // 244 DIVD_rec_DIVDO_rec_DIVDU_rec_DIVDUO_rec
  { 1, 267, 270, 3296, 3299 }, // 245 DIVWE_rec_DIVWEO_rec_DIVWEU_rec_DIVWEUO_rec
  { 1, 264, 267, 3299, 3302 }, // 246 DIVDE_rec_DIVDEO_rec_DIVDEU_rec_DIVDEUO_rec
  { 1, 286, 288, 3302, 3305 }, // 247 MTCRF_MTCRF8
  { 1, 260, 262, 3305, 3308 }, // 248 ADDC8O_rec_ADDC8_rec_ADDCO_rec_ADDC_rec_SUBFC8O_rec_SUBFC8_rec_SUBFCO_rec_SUBFC_rec
  { 1, 270, 272, 3308, 3311 }, // 249 FABSD_rec_FABSS_rec_FNABSD_rec_FNABSS_rec_FCPSGND_rec_FCPSGNS_rec_FNEGD_rec_FNEGS_rec_FMR_rec
  { 1, 262, 264, 3311, 3313 }, // 250 MCRFS
  { 1, 270, 272, 3313, 3314 }, // 251 MTFSF_MTFSF_rec_MTFSFI_MTFSFI_rec_MTFSFIb
  { 1, 292, 294, 3314, 3317 }, // 252 MTFSFb
  { 1, 299, 301, 3317, 3320 }, // 253 RLDCL_rec_RLDCR_rec
  { 1, 260, 262, 3320, 3323 }, // 254 RLDICL_rec_RLDICR_rec_RLDICL_32_rec_RLDIMI_rec
  { 1, 260, 262, 3323, 3326 }, // 255 RLWIMI8_rec_RLWIMI_rec
  { 1, 260, 262, 3326, 3329 }, // 256 RLWINM8_rec_RLWINM_rec_RLWNM8_rec_RLWNM_rec_SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 1, 299, 301, 3329, 3332 }, // 257 SRAWI_rec_SRAW_rec
  { 1, 270, 272, 3332, 3333 }, // 258 MFFS_MFFSCE_MFFSL_MFFS_rec
  { 1, 288, 290, 3333, 3335 }, // 259 MFCR_MFCR8
  { 1, 260, 262, 3335, 3338 }, // 260 EXTSWSLI_32_64_rec_SRADI_rec_EXTSWSLI_rec_RLDIC_rec
  { 1, 299, 301, 3338, 3341 }, // 261 SRAD_rec_SLD_rec_SRD_rec
  { 1, 272, 274, 3341, 3344 }, // 262 FDIV
  { 1, 272, 274, 3344, 3347 }, // 263 FDIV_rec
  { 0, 0, 0, 0, 0 }, // 264 XSSQRTDP
  { 0, 0, 0, 0, 0 }, // 265 FSQRT
  { 0, 0, 0, 0, 0 }, // 266 XVSQRTDP
  { 0, 0, 0, 0, 0 }, // 267 XVSQRTSP
  { 0, 0, 0, 0, 0 }, // 268 FSQRT_rec
  { 0, 0, 0, 0, 0 }, // 269 XSSQRTSP
  { 0, 0, 0, 0, 0 }, // 270 FSQRTS
  { 0, 0, 0, 0, 0 }, // 271 FSQRTS_rec
  { 1, 272, 274, 3347, 3350 }, // 272 XSDIVDP
  { 1, 274, 276, 3350, 3353 }, // 273 FDIVS
  { 1, 274, 276, 3353, 3356 }, // 274 FDIVS_rec
  { 1, 274, 276, 3356, 3359 }, // 275 XSDIVSP
  { 1, 274, 276, 3359, 3362 }, // 276 XVDIVSP
  { 1, 272, 274, 3362, 3365 }, // 277 XVDIVDP
  { 2, 278, 281, 3365, 3368 }, // 278 LFSU
  { 2, 278, 281, 3368, 3371 }, // 279 LFSUX
  { 2, 278, 281, 3371, 3374 }, // 280 STFDU_STFDUX_STFSU_STFSUX
  { 2, 278, 281, 3374, 3376 }, // 281 STBU_STBU8_STDU_STHU_STHU8_STWU_STWU8
  { 2, 278, 281, 3376, 3378 }, // 282 STBUX_STBUX8_STDUX_STHUX_STHUX8_STWUX_STWUX8
  { 2, 278, 281, 3378, 3380 }, // 283 LBZU_LBZU8
  { 2, 278, 281, 3380, 3382 }, // 284 LBZUX_LBZUX8
  { 2, 278, 281, 3382, 3384 }, // 285 LDU
  { 2, 278, 281, 3384, 3386 }, // 286 LDUX
  { 2, 278, 281, 3386, 3389 }, // 287 LFDU
  { 2, 278, 281, 3389, 3392 }, // 288 LFDUX
  { 0, 0, 0, 0, 0 }, // 289 VPMSUMB_VPMSUMD_VPMSUMH_VPMSUMW_VCIPHER_VCIPHERLAST_VNCIPHER_VNCIPHERLAST_VSBOX
  { 1, 262, 264, 3392, 3394 }, // 290 BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_BCCTR_BCCTR8_BCCTR8n_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_BCCTRn_BDNZ_BDNZ8_BDNZA_BDNZAm_BDNZAp_BDNZm_BDNZp_BDZ_BDZ8_BDZA_BDZAm_BDZAp_BDZm_BDZp_BDNZL_BDNZLA_BDNZLAm_BDNZLAp_BDNZLR_BDNZLR8_BDNZLRL_BDNZLRLm_BDNZLRLp_BDNZLRm_BDNZLRp_BDNZLm_BDNZLp_BDZL_BDZLA_BDZLAm_BDZLAp_BDZLR_BDZLR8_BDZLRL_BDZLRLm_BDZLRLp_BDZLRm_BDZLRp_BDZLm_BDZLp_BL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM_BLR_BLR8_BLRL_TAILB_TAILB8_TAILBA_TAILBA8_TAILBCTR_TAILBCTR8_gBC_gBCA_gBCAat_gBCCTR_gBCCTRL_gBCL_gBCLA_gBCLAat_gBCLR_gBCLRL_gBCLat_gBCat_BCLR_BCLRL_BCLRLn_BCLRn_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_RM_BCTRL_RM_B_BA_BC_BCC_BCCA_BCL_BCLalways_BCLn_BCTRL8_LDinto_toc_BCTRL_LWZinto_toc_BCTRL8_LDinto_toc_RM_BCTRL_LWZinto_toc_RM_BCn_CTRL_DEP
  { 1, 262, 264, 3394, 3396 }, // 291 ADDPCIS
  { 1, 258, 260, 3396, 3398 }, // 292 LDAT_LWAT
  { 1, 258, 260, 3398, 3400 }, // 293 STDAT_STWAT
  { 1, 260, 262, 3400, 3403 }, // 294 BRINC
  { 0, 0, 0, 0, 0 }, // 295 EVABS_EVEQV_EVNAND_EVNEG_EVADDIW_EVADDW_EVAND_EVANDC_EVCMPEQ_EVCMPGTS_EVCMPGTU_EVCMPLTS_EVCMPLTU_EVCNTLSW_EVCNTLZW_EVEXTSB_EVEXTSH_EVMERGEHI_EVMERGEHILO_EVMERGELO_EVMERGELOHI_EVNOR_EVOR_EVORC_EVXOR_EVRLW_EVRLWI_EVRNDW_EVSLW_EVSLWI_EVSPLATFI_EVSPLATI_EVSRWIS_EVSRWIU_EVSRWS_EVSRWU_EVSUBFW_EVSUBIFW
  { 0, 0, 0, 0, 0 }, // 296 EVMRA_EVADDSMIAAW_EVADDSSIAAW_EVADDUMIAAW_EVADDUSIAAW_EVDIVWS_EVDIVWU_EVMHEGSMFAA_EVMHEGSMFAN_EVMHEGSMIAA_EVMHEGSMIAN_EVMHEGUMIAA_EVMHEGUMIAN_EVMHESMF_EVMHESMFA_EVMHESMFAAW_EVMHESMFANW_EVMHESMI_EVMHESMIA_EVMHESMIAAW_EVMHESMIANW_EVMHESSF_EVMHESSFA_EVMHESSFAAW_EVMHESSFANW_EVMHESSIAAW_EVMHESSIANW_EVMHEUMI_EVMHEUMIA_EVMHEUMIAAW_EVMHEUMIANW_EVMHEUSIAAW_EVMHEUSIANW_EVMHOGSMFAA_EVMHOGSMFAN_EVMHOGSMIAA_EVMHOGSMIAN_EVMHOGUMIAA_EVMHOGUMIAN_EVMHOSMF_EVMHOSMFA_EVMHOSMFAAW_EVMHOSMFANW_EVMHOSMI_EVMHOSMIA_EVMHOSMIAAW_EVMHOSMIANW_EVMHOSSF_EVMHOSSFA_EVMHOSSFAAW_EVMHOSSFANW_EVMHOSSIAAW_EVMHOSSIANW_EVMHOUMI_EVMHOUMIA_EVMHOUMIAAW_EVMHOUMIANW_EVMHOUSIAAW_EVMHOUSIANW_EVMWHSMF_EVMWHSMFA_EVMWHSMI_EVMWHSMIA_EVMWHSSF_EVMWHSSFA_EVMWHUMI_EVMWHUMIA_EVMWLSMIAAW_EVMWLSMIANW_EVMWLSSIAAW_EVMWLSSIANW_EVMWLUMI_EVMWLUMIA_EVMWLUMIAAW_EVMWLUMIANW_EVMWLUSIAAW_EVMWLUSIANW_EVMWSMF_EVMWSMFA_EVMWSMFAA_EVMWSMFAN_EVMWSMI_EVMWSMIA_EVMWSMIAA_EVMWSMIAN_EVMWSSF_EVMWSSFA_EVMWSSFAA_EVMWSSFAN_EVMWUMI_EVMWUMIA_EVMWUMIAA_EVMWUMIAN_EVSUBFSMIAAW_EVSUBFSSIAAW_EVSUBFUMIAAW_EVSUBFUSIAAW
  { 1, 258, 260, 3403, 3405 }, // 297 EVLDD_EVLDDX_EVLDH_EVLDHX_EVLDW_EVLDWX_EVLHHESPLAT_EVLHHESPLATX_EVLHHOSSPLAT_EVLHHOSSPLATX_EVLHHOUSPLAT_EVLHHOUSPLATX_EVLWHE_EVLWHEX_EVLWHOS_EVLWHOSX_EVLWHOU_EVLWHOUX_EVLWHSPLAT_EVLWHSPLATX_EVLWWSPLAT_EVLWWSPLATX
  { 1, 258, 260, 3405, 3407 }, // 298 EVSTDD_EVSTDDX_EVSTDH_EVSTDHX_EVSTDW_EVSTDWX_EVSTWHE_EVSTWHEX_EVSTWHO_EVSTWHOX_EVSTWWE_EVSTWWEX_EVSTWWO_EVSTWWOX
  { 1, 262, 264, 3407, 3409 }, // 299 HRFID_ATTN_CLRBHRB_MFBHRBE_NAP_RFCI_RFDI_RFMCI_SC
  { 0, 0, 0, 0, 0 }, // 300 RFI
  { 0, 0, 0, 0, 0 }, // 301 RFID
  { 1, 258, 260, 3409, 3411 }, // 302 DSS_DSSALL_DST_DST64_DSTST_DSTST64_DSTSTT_DSTSTT64_DSTT_DSTT64_ICBLQ_LBEPX_LHEPX_LWEPX_TLBIVAX_TLBLD_TLBLI_TLBRE_TLBRE2_TLBSX_TLBSX2_TLBSX2D_TLBWE_TLBWE2_MBAR_TRAP_DCCCI_ICCCI
  { 1, 258, 260, 3411, 3413 }, // 303 ICBLC_STBEPX_STHEPX_STWEPX
  { 2, 258, 260, 3413, 3416 }, // 304 LFDEPX
  { 1, 258, 260, 3416, 3419 }, // 305 STFDEPX
  { 0, 0, 0, 0, 0 }, // 306 MFSR_MFSRIN
  { 0, 0, 0, 0, 0 }, // 307 MTSR_MTSRIN
  { 1, 286, 288, 3419, 3420 }, // 308 MFDCR
  { 1, 286, 288, 3420, 3421 }, // 309 MTDCR
  { 1, 260, 262, 3421, 3424 }, // 310 NOP_GT_PWR6_NOP_GT_PWR7
  { 0, 0, 0, 0, 0 }, // 311 TLBIA
  { 1, 294, 296, 3424, 3426 }, // 312 WRTEE_WRTEEI
  { 1, 260, 262, 3426, 3429 }, // 313 HASHCHK_HASHCHK8_HASHCHKP_HASHCHKP8_HASHST_HASHST8_HASHSTP_HASHSTP8_ADDEX_ADDEX8
  { 1, 258, 260, 0, 0 }, // 314 MSYNC
  { 0, 0, 0, 0, 0 }, // 315 SLBSYNC
  { 0, 0, 0, 0, 0 }, // 316 SLBFEE_rec
  { 0, 0, 0, 0, 0 }, // 317 STOP
  { 1, 258, 260, 3429, 3431 }, // 318 DCBA_DCBI
  { 1, 270, 272, 3431, 3434 }, // 319 FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRE_FRES_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRSP_FRSQRTE_FRSQRTES
  { 0, 0, 0, 0, 0 }, // 320 VCFSX_VCFSX_0_VCFUX_VCFUX_0_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VLOGEFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP
  { 0, 0, 0, 0, 0 }, // 321 XSCVDPHP_XSCVDPSP_XSCVDPSPN_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPSXWSs_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPUXWSs_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSP_XSRSQRTEDP_XSRSQRTESP
  { 0, 0, 0, 0, 0 }, // 322 XVCVSPBF16
  { 1, 270, 272, 3434, 3437 }, // 323 FADDS_FMULS_FSUBS
  { 1, 270, 272, 3437, 3441 }, // 324 FMUL
  { 0, 0, 0, 0, 0 }, // 325 VADDFP_XVADDDP_XVADDSP_XVMULDP_XVMULSP_XVSUBDP_XVSUBSP
  { 0, 0, 0, 0, 0 }, // 326 VSUBFP
  { 0, 0, 0, 0, 0 }, // 327 XSADDDP_XSADDSP_XSSUBDP_XSSUBSP
  { 0, 0, 0, 0, 0 }, // 328 XSMULDP_XSMULSP
  { 0, 0, 0, 0, 0 }, // 329 VMADDFP_VNMSUBFP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP
  { 0, 0, 0, 0, 0 }, // 330 VEXPTEFP
  { 1, 270, 272, 3441, 3444 }, // 331 FADDS_rec_FMULS_rec_FSUBS_rec
  { 1, 270, 272, 3444, 3448 }, // 332 FMUL_rec
  { 1, 270, 272, 3448, 3451 }, // 333 FCFID_rec_FCFIDS_rec_FCFIDU_rec_FCFIDUS_rec_FCTID_rec_FCTIDU_rec_FCTIDUZ_rec_FCTIDZ_rec_FCTIW_rec_FCTIWU_rec_FCTIWUZ_rec_FCTIWZ_rec_FRE_rec_FRES_rec_FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRSP_rec_FRSQRTE_rec_FRSQRTES_rec
  { 1, 262, 264, 3451, 3453 }, // 334 BCLR_BCLRn_BDNZLR_BDNZLR8_BDNZLRm_BDNZLRp_BDZLR_BDZLR8_BDZLRm_BDZLRp_gBCLR_BCLRL_BCLRLn_BDNZLRL_BDNZLRLm_BDNZLRLp_BDZLRL_BDZLRLm_BDZLRLp_gBCLRL_BL_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLR_BLR8_BLRL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS
  { 1, 262, 264, 3453, 3455 }, // 335 BL8_NOTOC_BL8_NOTOC_RM_BL8_NOTOC_TLS
  { 1, 262, 264, 3455, 3457 }, // 336 B_BCC_BCCA_BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_CTRL_DEP_TAILB_TAILB8_BA_TAILBA_TAILBA8_BC_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_LDinto_toc_BCTRL8_LDinto_toc_RM_BCTRL8_RM_BCTRL_LWZinto_toc_BCTRL_LWZinto_toc_RM_BCTRL_RM_BCn_BDNZ_BDNZ8_BDNZm_BDNZp_BDZ_BDZ8_BDZm_BDZp_TAILBCTR_TAILBCTR8_gBC_gBCat_BCL_BCLalways_BCLn_BDNZL_BDNZLm_BDNZLp_BDZL_BDZLm_BDZLp_gBCL_gBCLat_BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM
  { 1, 262, 264, 3457, 3459 }, // 337 BCCTR_BCCTR8_BCCTR8n_BCCTRn_gBCCTR_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_gBCCTRL
  { 0, 0, 0, 0, 0 }, // 338 VSBOX
  { 1, 260, 262, 3459, 3462 }, // 339 CFUGED_CNTLZDM_CNTTZDM_PDEPD_PEXTD
  { 0, 0, 0, 0, 0 }, // 340 VCFUGED_VCLZDM_VCTZDM_VGNB_VPDEPD_VPEXTD
  { 0, 0, 0, 0, 0 }, // 341 XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP
  { 0, 0, 0, 0, 0 }, // 342 XSCVQPSQZ_XSCVQPUQZ_XSCVSQQP_XSCVUQQP
  { 0, 0, 0, 0, 0 }, // 343 XSADDQP_XSADDQPO_XSSUBQP_XSSUBQPO
  { 1, 260, 262, 3462, 3465 }, // 344 HASHST_HASHST8_HASHSTP_HASHSTP8
  { 0, 0, 0, 0, 0 }, // 345 XSMULQP_XSMULQPO
  { 0, 0, 0, 0, 0 }, // 346 VDIVESQ_VDIVEUQ_VDIVSQ_VDIVUQ
  { 0, 0, 0, 0, 0 }, // 347 VMODSQ_VMODUQ
  { 1, 267, 270, 3465, 3468 }, // 348 DIVWE_DIVWEO_DIVWEU_DIVWEUO
  { 0, 0, 0, 0, 0 }, // 349 VDIVSD_VDIVUD
  { 0, 0, 0, 0, 0 }, // 350 VMODSD_VMODUD
  { 0, 0, 0, 0, 0 }, // 351 VDIVSW_VDIVUW
  { 0, 0, 0, 0, 0 }, // 352 VMODSW_VMODUW
  { 0, 0, 0, 0, 0 }, // 353 VDIVESD_VDIVEUD
  { 0, 0, 0, 0, 0 }, // 354 VDIVESW_VDIVEUW
  { 0, 0, 0, 0, 0 }, // 355 BCDCTN_rec_VMUL10CUQ_VMUL10UQ_XSXSIGQP
  { 0, 0, 0, 0, 0 }, // 356 BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDUS_rec_BCDUTRUNC_rec_VADDCUQ_VMUL10ECUQ_VMUL10EUQ_VSUBCUQ_XSTSTDCQP
  { 0, 0, 0, 0, 0 }, // 357 VADDUQM_VSUBUQM
  { 0, 0, 0, 0, 0 }, // 358 XSMAXCQP_XSMINCQP
  { 0, 0, 0, 0, 0 }, // 359 XXGENPCVBM
  { 0, 0, 0, 0, 0 }, // 360 BCDADD_rec_BCDS_rec_BCDSUB_rec_BCDTRUNC_rec_VADDECUQ_VADDEUQM_VSUBECUQ_VSUBEUQM
  { 1, 258, 260, 3468, 3470 }, // 361 TRAP
  { 1, 303, 305, 3470, 3472 }, // 362 TW
  { 1, 260, 262, 3472, 3475 }, // 363 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW
  { 1, 270, 272, 3475, 3478 }, // 364 FTSQRT
  { 0, 0, 0, 0, 0 }, // 365 MTVSRBM_MTVSRBMI_MTVSRDM_MTVSRHM_MTVSRQM_MTVSRWM_VEXPANDBM_VEXPANDDM_VEXPANDHM_VEXPANDQM_VEXPANDWM_VEXTRACTBM_VEXTRACTDM_VEXTRACTHM_VEXTRACTQM_VEXTRACTWM_XVTLSBB
  { 1, 260, 262, 3478, 3481 }, // 366 POPCNTB_POPCNTB8
  { 0, 0, 0, 0, 0 }, // 367 VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTD_VPOPCNTW_VPRTYBD_VPRTYBW
  { 0, 0, 0, 0, 0 }, // 368 VPOPCNTB_VPOPCNTH
  { 0, 0, 0, 0, 0 }, // 369 XSCVSPDPN
  { 1, 270, 272, 3481, 3484 }, // 370 XSTSQRTDP
  { 0, 0, 0, 0, 0 }, // 371 XVCVHPSP
  { 1, 270, 272, 3484, 3487 }, // 372 XVTSQRTDP_XVTSQRTSP
  { 1, 260, 262, 3487, 3490 }, // 373 CMPEQB
  { 1, 260, 262, 3490, 3493 }, // 374 EXTSWSLI_32_64_rec_EXTSWSLI_rec
  { 1, 299, 301, 3493, 3496 }, // 375 SLD_rec_SRD_rec
  { 1, 260, 262, 3496, 3499 }, // 376 SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 0, 0, 0, 0, 0 }, // 377 VADDCUW_VADDSBS_VADDSHS_VADDSWS_VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VMAXFP_VMINFP_VSUBCUW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP
  { 0, 0, 0, 0, 0 }, // 378 VCMPBFP_VCMPBFP_rec_VCMPEQFP_VCMPEQFP_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPGTSB_rec_VCMPGTSD_rec_VCMPGTSH_rec_VCMPGTSW_rec_VCMPGTUB_rec_VCMPGTUD_rec_VCMPGTUH_rec_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 0, 0, 0, 0, 0 }, // 379 VCMPEQUQ_VCMPEQUQ_rec_VCMPGTSQ_VCMPGTSQ_rec_VCMPGTUQ_VCMPGTUQ_rec
  { 0, 0, 0, 0, 0 }, // 380 VCMPSQ_VCMPUQ_VCNTMBB_VCNTMBD_VCNTMBH_VCNTMBW
  { 0, 0, 0, 0, 0 }, // 381 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP
  { 1, 260, 262, 3499, 3502 }, // 382 RLDIC_rec
  { 1, 260, 262, 3502, 3505 }, // 383 RLDICL_32_rec_RLDICL_rec_RLDICR_rec
  { 0, 0, 0, 0, 0 }, // 384 VSHASIGMAD_VSHASIGMAW
  { 0, 0, 0, 0, 0 }, // 385 VRLQ_VRLQNM_VSLQ_VSRAQ_VSRQ
  { 0, 0, 0, 0, 0 }, // 386 VRLQMI
  { 1, 262, 264, 3505, 3508 }, // 387 CR6SET_CREQV_CRSET
  { 1, 258, 260, 3508, 3510 }, // 388 DSS_DSSALL
  { 1, 286, 288, 3510, 3511 }, // 389 MFCTR_MFCTR8_MFLR_MFLR8
  { 1, 260, 262, 3511, 3514 }, // 390 NOP_ORI_ORI8
  { 0, 0, 0, 0, 0 }, // 391 VXOR_V_SET0_V_SET0B_V_SET0H
  { 0, 0, 0, 0, 0 }, // 392 XXLEQV_XXLEQVOnes_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 1, 260, 262, 3514, 3517 }, // 393 ADDI_ADDI8_LI_LI8_ADDIS_ADDIS8_LIS_LIS8_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_NEG_NEG8_NEG8_rec_NEG_rec_NEG8O_NEGO
  { 0, 0, 0, 0, 0 }, // 394 ADDIdtprelL32_ADDItlsldLADDR32_ADDISdtprelHA32
  { 0, 0, 0, 0, 0 }, // 395 ADDItocL_ADDIStocHA_ADDIStocHA8
  { 1, 260, 262, 3517, 3520 }, // 396 ADDME_ADDME8_ADDME8O_ADDMEO_ADDZE_ADDZE8_ADDZE8O_ADDZEO_SUBFME_SUBFME8_SUBFME8O_SUBFMEO_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZEO
  { 1, 270, 272, 3520, 3523 }, // 397 FABSD_FABSS_FMR_FNABSD_FNABSS_FNEGD_FNEGS
  { 1, 260, 262, 3523, 3526 }, // 398 SETB_SETB8
  { 1, 260, 262, 3526, 3529 }, // 399 SETBC_SETBC8_SETBCR_SETBCR8_SETNBC_SETNBC8_SETNBCR_SETNBCR8
  { 0, 0, 0, 0, 0 }, // 400 VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VNEGD_VNEGW
  { 0, 0, 0, 0, 0 }, // 401 VEXTSD2Q
  { 0, 0, 0, 0, 0 }, // 402 XSABSDP_XSNABSDP_XSNEGDP_XSXEXPDP
  { 0, 0, 0, 0, 0 }, // 403 XSABSQP_XSNABSQP_XSNEGQP_XSXEXPQP_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVNEGDP_XVNEGSP_XVXEXPDP_XVXEXPSP
  { 0, 0, 0, 0, 0 }, // 404 XVXSIGDP_XVXSIGSP
  { 1, 260, 262, 3529, 3532 }, // 405 ADD4_ADD4TLS_ADD8_ADD8TLS_ADD8TLS__ADD4_rec_ADD8_rec_ADD4O_ADD8O_AND_AND8_AND8_rec_AND_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_EQV_EQV8_EQV8_rec_EQV_rec_NAND_NAND8_NAND8_rec_NAND_rec_NOR_NOR8_NOR8_rec_NOR_rec_OR_OR8_OR8_rec_OR_rec_ORC_ORC8_ORC8_rec_ORC_rec_ORIS_ORIS8_XOR_XOR8_XOR8_rec_XOR_rec_XORI_XORI8_XORIS_XORIS8
  { 1, 260, 262, 3532, 3535 }, // 406 ADDE_ADDE8_ADDE8O_ADDEO_ADDIC_ADDIC8_ANDI8_rec_ANDI_rec_ANDIS8_rec_ANDIS_rec_SUBF_SUBF8_SUBF8_rec_SUBF_rec_SUBFE_SUBFE8_SUBFE8O_SUBFEO_SUBFIC_SUBFIC8_SUBF8O_SUBFO
  { 1, 260, 262, 3535, 3538 }, // 407 CMPB_CMPB8
  { 1, 260, 262, 3538, 3541 }, // 408 EXTSWSLI_EXTSWSLI_32_64_SRADI_SRADI_32
  { 1, 260, 262, 3541, 3544 }, // 409 SLW_SLW8_SRW_SRW8
  { 0, 0, 0, 0, 0 }, // 410 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEQV_VNAND_VORC_VSLD_VSRAD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_XXLAND_XXLANDC_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC
  { 0, 0, 0, 0, 0 }, // 411 VAND_VANDC_VMRGEW_VMRGOW_VNOR_VOR_VRLB_VRLD_VRLDNM_VRLH_VRLW_VRLWNM_VSLB_VSLH_VSLW_VSRAB_VSRAH_VSRAW_VSRB_VSRH_VSRW_XSCPSGNQP_XSIEXPQP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP
  { 0, 0, 0, 0, 0 }, // 412 VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW
  { 1, 260, 262, 3544, 3547 }, // 413 ADDEX_ADDEX8
  { 1, 258, 260, 3547, 3549 }, // 414 DST_DST64_DSTT_DSTT64_DSTST_DSTST64_DSTSTT_DSTSTT64
  { 1, 260, 262, 3549, 3552 }, // 415 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32
  { 1, 270, 272, 3552, 3553 }, // 416 MFFS_MFFS_rec_MFFSL
  { 1, 286, 288, 3553, 3554 }, // 417 TRECHKPT
  { 1, 260, 262, 3554, 3557 }, // 418 ADDME8_rec_ADDME_rec_ADDME8O_rec_ADDMEO_rec_ADDZE8_rec_ADDZE_rec_ADDZE8O_rec_ADDZEO_rec_SUBFME8_rec_SUBFME_rec_SUBFME8O_rec_SUBFMEO_rec_SUBFZE8_rec_SUBFZE_rec_SUBFZE8O_rec_SUBFZEO_rec
  { 1, 292, 294, 3557, 3560 }, // 419 MTFSB0
  { 1, 260, 262, 3560, 3563 }, // 420 NEG8O_rec_NEGO_rec
  { 1, 260, 262, 3563, 3566 }, // 421 ADDE8_rec_ADDE_rec_ADDE8O_rec_ADDEO_rec_ADDIC_rec_SUBFE8_rec_SUBFE_rec_SUBFE8O_rec_SUBFEO_rec_SUBF8O_rec_SUBFO_rec
  { 1, 262, 264, 3566, 3568 }, // 422 HRFID
  { 1, 270, 272, 3568, 3571 }, // 423 FABSD_rec_FABSS_rec_FMR_rec_FNABSD_rec_FNABSS_rec_FNEGD_rec_FNEGS_rec
  { 1, 262, 264, 3571, 3573 }, // 424 SC
  { 1, 260, 262, 3573, 3576 }, // 425 ADDC_ADDC8_ADDC8O_ADDCO_SUBFC_SUBFC8_SUBFC8O_SUBFCO
  { 1, 260, 262, 3576, 3579 }, // 426 ADDC8_rec_ADDC_rec_SUBFC8_rec_SUBFC_rec
  { 1, 270, 272, 3579, 3580 }, // 427 MTFSF_MTFSFI_MTFSFIb
  { 1, 270, 272, 3580, 3581 }, // 428 MTFSFI_rec
  { 0, 0, 0, 0, 0 }, // 429 VSTRIBL_rec_VSTRIBR_rec_VSTRIHL_rec_VSTRIHR_rec
  { 1, 258, 260, 3581, 3583 }, // 430 LBZ_LBZ8_LDBRX_LHBRX_LHBRX8_LHZ_LHZ8_LWBRX_LWBRX8_LWZ_LWZ8
  { 1, 258, 260, 3583, 3585 }, // 431 LD
  { 0, 0, 0, 0, 0 }, // 432 LDtoc_LDtocBA_LDtocCPT_LDtocJTI_LDtocL_SPILLTOVSR_LD_LWZtoc_LWZtocL
  { 2, 258, 260, 3585, 3588 }, // 433 LXVRBX_LXVRDX_LXVRHX_LXVRWX
  { 1, 258, 260, 3588, 3590 }, // 434 DCBT_DCBTST
  { 1, 258, 260, 3590, 3592 }, // 435 ICBT_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32
  { 1, 258, 260, 3592, 3594 }, // 436 LDX_LDXTLS_LDXTLS_
  { 0, 0, 0, 0, 0 }, // 437 SPILLTOVSR_LDX
  { 1, 258, 260, 3594, 3596 }, // 438 LBZCIX_LDCIX_LHZCIX_LWZCIX
  { 0, 0, 0, 0, 0 }, // 439 MTSR
  { 1, 260, 262, 3596, 3599 }, // 440 MTVRSAVE_MTVRSAVEv
  { 1, 258, 260, 3599, 3601 }, // 441 LSWI
  { 2, 258, 260, 3601, 3604 }, // 442 PLBZ_PLBZ8_PLBZ8pc_PLBZpc_PLD_PLDpc_PLFD_PLFDpc_PLFS_PLFSpc_PLHA_PLHA8_PLHA8pc_PLHApc_PLHZ_PLHZ8_PLHZ8pc_PLHZpc_PLWA_PLWA8_PLWA8pc_PLWApc_PLWZ_PLWZ8_PLWZ8pc_PLWZpc_PLXSD_PLXSDpc_PLXSSP_PLXSSPpc_PLXV_PLXVpc_PLXVP_PLXVPpc
  { 2, 258, 260, 3604, 3607 }, // 443 LXVP_LXVPX
  { 0, 0, 0, 0, 0 }, // 444 MFSR
  { 1, 290, 292, 3607, 3609 }, // 445 MFTB8
  { 0, 0, 0, 0, 0 }, // 446 XXSETACCZ
  { 0, 0, 0, 0, 0 }, // 447 XVBF16GER2_XVF16GER2_XVF32GER_XVF64GER_XVI16GER2_XVI16GER2S_XVI4GER8_XVI8GER4
  { 0, 0, 0, 0, 0 }, // 448 XVBF16GER2NN_XVBF16GER2NP_XVBF16GER2PN_XVBF16GER2PP_XVF16GER2NN_XVF16GER2NP_XVF16GER2PN_XVF16GER2PP_XVF32GERNN_XVF32GERNP_XVF32GERPN_XVF32GERPP_XVF64GERNN_XVF64GERNP_XVF64GERPN_XVF64GERPP_XVI16GER2PP_XVI16GER2SPP_XVI4GER8PP_XVI8GER4PP
  { 0, 0, 0, 0, 0 }, // 449 XVI8GER4SPP
  { 0, 0, 0, 0, 0 }, // 450 PMXVF32GER_PMXVF64GER
  { 0, 0, 0, 0, 0 }, // 451 PMXVBF16GER2_PMXVF16GER2_PMXVF32GERNN_PMXVF32GERNP_PMXVF32GERPN_PMXVF32GERPP_PMXVF64GERNN_PMXVF64GERNP_PMXVF64GERPN_PMXVF64GERPP_PMXVI16GER2_PMXVI16GER2S_PMXVI4GER8_PMXVI8GER4
  { 0, 0, 0, 0, 0 }, // 452 PMXVBF16GER2NN_PMXVBF16GER2NP_PMXVBF16GER2PN_PMXVBF16GER2PP_PMXVF16GER2NN_PMXVF16GER2NP_PMXVF16GER2PN_PMXVF16GER2PP_PMXVI16GER2PP_PMXVI16GER2SPP_PMXVI4GER8PP_PMXVI8GER4PP
  { 0, 0, 0, 0, 0 }, // 453 PMXVI8GER4SPP
  { 0, 0, 0, 0, 0 }, // 454 XXMTACC
  { 0, 0, 0, 0, 0 }, // 455 XXMFACC
  { 1, 283, 286, 3609, 3612 }, // 456 MULLD_MULLDO
  { 0, 0, 0, 0, 0 }, // 457 VMULHSD_VMULHUD_VMULLD
  { 0, 0, 0, 0, 0 }, // 458 VSPLTISW
  { 0, 0, 0, 0, 0 }, // 459 V_SETALLONES_V_SETALLONESB_V_SETALLONESH
  { 0, 0, 0, 0, 0 }, // 460 MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VPRTYBQ
  { 0, 0, 0, 0, 0 }, // 461 VGBBD_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW
  { 0, 0, 0, 0, 0 }, // 462 VSPLTISB_VSPLTISH_XXSPLTIB
  { 0, 0, 0, 0, 0 }, // 463 VSTRIBL_VSTRIBR_VSTRIHL_VSTRIHR
  { 0, 0, 0, 0, 0 }, // 464 XVCVBF16SPN
  { 0, 0, 0, 0, 0 }, // 465 VBPERMQ_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLO_VSLV_VSR_VSRO_VSRV_XXEXTRACTUW
  { 0, 0, 0, 0, 0 }, // 466 VCLRLB_VCLRRB_XXGENPCVDM_XXGENPCVHM_XXGENPCVWM
  { 0, 0, 0, 0, 0 }, // 467 VEXTRACTD_VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VINSERTD_VINSERTW
  { 0, 0, 0, 0, 0 }, // 468 VEXTDDVLX_VEXTDDVRX_VEXTDUBVLX_VEXTDUBVRX_VEXTDUHVLX_VEXTDUHVRX_VEXTDUWVLX_VEXTDUWVRX_VINSBLX_VINSBRX_VINSBVLX_VINSBVRX_VINSD_VINSDLX_VINSDRX_VINSHLX_VINSHRX_VINSHVLX_VINSHVRX_VINSW_VINSWLX_VINSWRX_VINSWVLX_VINSWVRX_VSLDBI_VSRDBI
  { 0, 0, 0, 0, 0 }, // 469 VSUMSWS
  { 0, 0, 0, 0, 0 }, // 470 XXSPLTIDP_XXSPLTIW
  { 0, 0, 0, 0, 0 }, // 471 XXBLENDVB_XXBLENDVD_XXBLENDVH_XXBLENDVW_XXSPLTI32DX
  { 0, 0, 0, 0, 0 }, // 472 XXEVAL
  { 0, 0, 0, 0, 0 }, // 473 XXPERMX
  { 1, 258, 260, 3612, 3614 }, // 474 DCBST_DCBZ
  { 1, 258, 260, 3614, 3616 }, // 475 ICBI
  { 1, 258, 260, 3616, 3618 }, // 476 DCBF
  { 2, 258, 260, 3618, 3621 }, // 477 PSTXVP_PSTXVPpc
  { 1, 258, 260, 3621, 3623 }, // 478 STB_STB8_STDBRX_STH_STH8_STHBRX_STW_STW8_STWBRX
  { 0, 0, 0, 0, 0 }, // 479 SPILLTOVSR_ST
  { 1, 258, 260, 3623, 3625 }, // 480 STD
  { 0, 0, 0, 0, 0 }, // 481 DFSTOREf32_DFSTOREf64_STIWX
  { 1, 258, 260, 3625, 3628 }, // 482 STXVRBX_STXVRDX_STXVRHX_STXVRWX
  { 0, 0, 0, 0, 0 }, // 483 SPILLTOVSR_STX
  { 1, 258, 260, 3628, 3630 }, // 484 EnforceIEIO
  { 1, 258, 260, 3630, 3632 }, // 485 STBCIX_STDCIX_STHCIX_STWCIX
  { 2, 258, 260, 3632, 3635 }, // 486 PSTB_PSTB8_PSTB8pc_PSTBpc_PSTD_PSTDpc_PSTFD_PSTFDpc_PSTFS_PSTFSpc_PSTH_PSTH8_PSTH8pc_PSTHpc_PSTW_PSTW8_PSTW8pc_PSTWpc_PSTXSD_PSTXSDpc_PSTXSSP_PSTXSSPpc_PSTXV_PSTXVpc
  { 2, 258, 260, 3635, 3638 }, // 487 STXVP_STXVPX
  { 1, 262, 264, 3638, 3640 }, // 488 ATTN_NAP
  { 1, 258, 260, 3640, 3642 }, // 489 DCBZL
  { 1, 258, 260, 3642, 3644 }, // 490 DCCCI_ICBLQ_ICCCI_TLBLD_TLBLI_TLBRE2_TLBSX2_TLBSX2D_TLBWE2
  { 1, 258, 260, 3644, 3646 }, // 491 ICBLC
  { 1, 262, 264, 3646, 3648 }, // 492 CLRBHRB
  { 1, 262, 264, 3648, 3650 }, // 493 MFBHRBE
  { 2, 258, 260, 3650, 3653 }, // 494 PADDI_PADDI8_PADDI8pc_PADDIpc
  { 1, 260, 262, 3653, 3656 }, // 495 PLI_PLI8
  { 0, 0, 0, 0, 0 }, // 496 VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS
  { 0, 0, 0, 0, 0 }, // 497 VMULESD_VMULEUD_VMULHSW_VMULHUW_VMULOSD_VMULOUD
  { 0, 0, 0, 0, 0 }, // 498 VMSUMCUD
  { 0, uint16_t(~0U), uint16_t(~0U), uint16_t(~0U), uint16_t(~0U) }// end marker
};

static const llvm::InstrItinerary P8Itineraries[] = {
  { 0, 0, 0, 0, 0 }, // 0 NoInstrModel
  { 0, 0, 0, 0, 0 }, // 1 IIC_LdStSync
  { 1, 305, 307, 3656, 3659 }, // 2 IIC_IntSimple
  { 1, 305, 307, 3659, 3662 }, // 3 IIC_IntGeneral
  { 1, 307, 309, 3662, 3665 }, // 4 IIC_BrB
  { 1, 309, 311, 3665, 3668 }, // 5 IIC_VecFP
  { 1, 311, 313, 3668, 3671 }, // 6 IIC_IntCompare
  { 0, 0, 0, 0, 0 }, // 7 IIC_SprABORT
  { 0, 0, 0, 0, 0 }, // 8 IIC_LdStCOPY
  { 0, 0, 0, 0, 0 }, // 9 IIC_LdStPASTE
  { 1, 313, 315, 3671, 3674 }, // 10 IIC_BrCR
  { 1, 315, 317, 3674, 3677 }, // 11 IIC_LdStLD
  { 0, 0, 0, 0, 0 }, // 12 IIC_LdStDCBF
  { 1, 315, 317, 3677, 3680 }, // 13 IIC_LdStLoad
  { 1, 317, 319, 3680, 3683 }, // 14 IIC_IntDivD
  { 1, 319, 321, 3683, 3686 }, // 15 IIC_IntDivW
  { 0, 0, 0, 0, 0 }, // 16 IIC_FPDGeneral
  { 1, 321, 323, 3686, 3689 }, // 17 IIC_FPAddSub
  { 1, 321, 323, 3689, 3692 }, // 18 IIC_FPDivD
  { 0, 0, 0, 0, 0 }, // 19 IIC_FPSGeneral
  { 1, 321, 323, 3692, 3695 }, // 20 IIC_FPCompare
  { 1, 321, 323, 3695, 3698 }, // 21 IIC_FPGeneral
  { 1, 309, 311, 3698, 3701 }, // 22 IIC_VecGeneral
  { 1, 309, 311, 3701, 3704 }, // 23 IIC_VecComplex
  { 1, 323, 326, 3704, 3707 }, // 24 IIC_LdStStore
  { 1, 311, 313, 3707, 3710 }, // 25 IIC_IntRotateDI
  { 1, 321, 323, 3710, 3713 }, // 26 IIC_FPDivS
  { 1, 321, 323, 3713, 3717 }, // 27 IIC_FPFused
  { 1, 321, 323, 3717, 3720 }, // 28 IIC_FPSqrtD
  { 1, 321, 323, 3720, 3723 }, // 29 IIC_FPSqrtS
  { 0, 0, 0, 0, 0 }, // 30 IIC_LdStICBI
  { 1, 326, 329, 3723, 3727 }, // 31 IIC_IntISEL
  { 0, 0, 0, 0, 0 }, // 32 IIC_SprISYNC
  { 1, 329, 334, 3727, 3730 }, // 33 IIC_LdStLWARX
  { 1, 334, 338, 3730, 3734 }, // 34 IIC_LdStLoadUpd
  { 1, 334, 338, 3734, 3738 }, // 35 IIC_LdStLoadUpdX
  { 1, 338, 345, 3738, 3741 }, // 36 IIC_LdStLDARX
  { 1, 334, 338, 3741, 3745 }, // 37 IIC_LdStLDU
  { 1, 334, 338, 3745, 3749 }, // 38 IIC_LdStLDUX
  { 1, 345, 347, 3749, 3752 }, // 39 IIC_LdStLFD
  { 1, 347, 351, 3752, 3756 }, // 40 IIC_LdStLFDU
  { 1, 347, 351, 3756, 3760 }, // 41 IIC_LdStLFDUX
  { 1, 351, 355, 3760, 3763 }, // 42 IIC_LdStLHA
  { 1, 355, 360, 3763, 3767 }, // 43 IIC_LdStLHAU
  { 1, 360, 369, 3767, 3771 }, // 44 IIC_LdStLHAUX
  { 1, 315, 317, 3771, 3774 }, // 45 IIC_LdStLMW
  { 0, 0, 0, 0, 0 }, // 46 IIC_LdStLQ
  { 0, 0, 0, 0, 0 }, // 47 IIC_LdStLQARX
  { 1, 369, 373, 3774, 3777 }, // 48 IIC_LdStLWA
  { 1, 311, 313, 3777, 3780 }, // 49 IIC_IntMulHD
  { 1, 373, 375, 3780, 3783 }, // 50 IIC_BrMCR
  { 1, 375, 377, 3783, 3785 }, // 51 IIC_BrMCRX
  { 1, 313, 315, 3785, 3787 }, // 52 IIC_SprMFCR
  { 0, 0, 0, 0, 0 }, // 53 IIC_SprMFSPR
  { 0, 0, 0, 0, 0 }, // 54 IIC_IntMFFS
  { 0, 0, 0, 0, 0 }, // 55 IIC_SprMFMSR
  { 1, 313, 315, 3787, 3789 }, // 56 IIC_SprMFCRF
  { 0, 0, 0, 0, 0 }, // 57 IIC_SprMFPMR
  { 0, 0, 0, 0, 0 }, // 58 IIC_SprMFSR
  { 0, 0, 0, 0, 0 }, // 59 IIC_SprMFTB
  { 0, 0, 0, 0, 0 }, // 60 IIC_SprMSGSYNC
  { 1, 375, 377, 3789, 3791 }, // 61 IIC_SprMTSPR
  { 0, 0, 0, 0, 0 }, // 62 IIC_IntMTFSB0
  { 0, 0, 0, 0, 0 }, // 63 IIC_SprMTMSR
  { 0, 0, 0, 0, 0 }, // 64 IIC_SprMTMSRD
  { 0, 0, 0, 0, 0 }, // 65 IIC_SprMTPMR
  { 0, 0, 0, 0, 0 }, // 66 IIC_SprMTSR
  { 1, 311, 313, 3791, 3794 }, // 67 IIC_IntMulHW
  { 1, 311, 313, 3794, 3797 }, // 68 IIC_IntMulHWU
  { 1, 311, 313, 3797, 3800 }, // 69 IIC_IntMulLI
  { 0, 0, 0, 0, 0 }, // 70 IIC_SprRFI
  { 0, 0, 0, 0, 0 }, // 71 IIC_IntRFID
  { 1, 311, 313, 3800, 3803 }, // 72 IIC_IntRotateD
  { 1, 311, 313, 3803, 3806 }, // 73 IIC_IntRotate
  { 0, 0, 0, 0, 0 }, // 74 IIC_SprSLBFEE
  { 0, 0, 0, 0, 0 }, // 75 IIC_SprSLBIA
  { 0, 0, 0, 0, 0 }, // 76 IIC_SprSLBIE
  { 0, 0, 0, 0, 0 }, // 77 IIC_SprSLBIEG
  { 0, 0, 0, 0, 0 }, // 78 IIC_SprSLBMFEE
  { 0, 0, 0, 0, 0 }, // 79 IIC_SprSLBMFEV
  { 0, 0, 0, 0, 0 }, // 80 IIC_SprSLBMTE
  { 0, 0, 0, 0, 0 }, // 81 IIC_SprSLBSYNC
  { 1, 311, 313, 3806, 3809 }, // 82 IIC_IntShift
  { 1, 377, 385, 3809, 3812 }, // 83 IIC_LdStSTWCX
  { 1, 385, 389, 3812, 3816 }, // 84 IIC_LdStSTU
  { 1, 389, 398, 3816, 3820 }, // 85 IIC_LdStSTUX
  { 1, 398, 401, 0, 0 }, // 86 IIC_LdStSTD
  { 1, 377, 385, 3820, 3823 }, // 87 IIC_LdStSTDCX
  { 1, 401, 404, 3823, 3826 }, // 88 IIC_LdStSTFD
  { 1, 404, 409, 3826, 3830 }, // 89 IIC_LdStSTFDU
  { 0, 0, 0, 0, 0 }, // 90 IIC_SprSTOP
  { 0, 0, 0, 0, 0 }, // 91 IIC_LdStSTQ
  { 0, 0, 0, 0, 0 }, // 92 IIC_LdStSTQCX
  { 1, 311, 313, 3830, 3832 }, // 93 IIC_IntTrapD
  { 0, 0, 0, 0, 0 }, // 94 IIC_SprTLBIA
  { 0, 0, 0, 0, 0 }, // 95 IIC_SprTLBIE
  { 0, 0, 0, 0, 0 }, // 96 IIC_SprTLBIEL
  { 0, 0, 0, 0, 0 }, // 97 IIC_SprTLBSYNC
  { 1, 311, 313, 3832, 3834 }, // 98 IIC_IntTrapW
  { 1, 309, 311, 3834, 3837 }, // 99 IIC_VecFPCompare
  { 1, 409, 411, 3837, 3840 }, // 100 IIC_VecPerm
  { 1, 309, 311, 3840, 3843 }, // 101 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VSLD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_VPOPCNTB_VPOPCNTH_VSRAD_MTVSRDD_VEQV_VNAND_VNEGD_VNEGW_VORC_XXLAND_XXLANDC_XXLEQV_XXLEQVOnes_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 1, 309, 311, 3843, 3846 }, // 102 VAND_VANDC_V_SET0_V_SET0B_V_SET0H_VSLB_VSLH_VSLW_VSRB_VSRH_VSRW_VRLB_VRLD_VRLH_VRLW_VSRAB_VSRAH_VSRAW_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP_XVXEXPDP_XVXEXPSP_VRLDMI_VRLDNM_VRLWMI_VRLWNM_VMRGEW_VMRGOW_VNOR_VOR_VSEL_VXOR_XVNEGDP_XVNEGSP_XSABSQP_XSCPSGNQP_XSIEXPQP_XSNABSQP_XSNEGQP_XSXEXPQP
  { 1, 409, 411, 3846, 3849 }, // 103 XXSEL
  { 1, 375, 377, 3849, 3851 }, // 104 TABORTDC_TABORTDCI_TABORTWC_TABORTWCI
  { 0, 0, 0, 0, 0 }, // 105 MTFSB0_MTFSB1
  { 0, 0, 0, 0, 0 }, // 106 MFFSCDRN_MFFSCDRNI_MFFSCRN_MFFSCRNI
  { 1, 311, 313, 3851, 3854 }, // 107 CMPRB_CMPRB8_CMPEQB
  { 1, 311, 313, 3854, 3856 }, // 108 TD_TDI
  { 1, 311, 313, 3856, 3858 }, // 109 TW_TWI
  { 1, 321, 323, 3858, 3861 }, // 110 FCMPOD_FCMPOS_FCMPUD_FCMPUS_FTDIV_FTSQRT
  { 1, 309, 311, 3861, 3864 }, // 111 XSTSTDCDP_XSTSTDCSP
  { 1, 309, 311, 3864, 3867 }, // 112 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP_XSXSIGDP_XSCVSPDPN
  { 1, 321, 323, 3867, 3870 }, // 113 XSCMPEQDP_XSCMPEXPDP_XSCMPGEDP_XSCMPGTDP_XSCMPODP_XSCMPUDP_XSTDIVDP_XSTSQRTDP
  { 1, 305, 307, 3870, 3873 }, // 114 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW_CMPB_CMPB8_SETB_SETB8_BPERMD
  { 1, 311, 313, 3873, 3876 }, // 115 SLD_SRD_SRAD
  { 1, 311, 313, 3876, 3879 }, // 116 SRADI_EXTSWSLI_32_64_EXTSWSLI_SRADI_32_RLDIC
  { 1, 309, 311, 3879, 3882 }, // 117 MFVRD_MFVSRD_MTVRD_MTVSRD_MTVRWA_MTVRWZ_MTVSRWA_MTVSRWZ_MFVSRWZ_MFVRWZ
  { 1, 311, 313, 3882, 3885 }, // 118 CMPLW_CMPLWI_CMPW_CMPWI_CMPD_CMPDI_CMPLD_CMPLDI
  { 1, 305, 307, 3885, 3888 }, // 119 SUBFC_SUBFC8_SUBFC8O_SUBFCO_SUBFIC_SUBFIC8_ANDI8_rec_ANDIS8_rec_ANDIS_rec_ANDI_rec_ADDC_ADDC8_ADDC8O_ADDCO_ADDIC_ADDIC8_ADDIC_rec_ADDE_ADDE8_ADDE8O_ADDE8O_rec_ADDE8_rec_ADDEO_ADDEO_rec_ADDE_rec_ADDME_ADDME8_ADDME8O_ADDME8O_rec_ADDME8_rec_ADDMEO_ADDMEO_rec_ADDME_rec_ADDZE_ADDZE8_ADDZE8O_ADDZE8O_rec_ADDZE8_rec_ADDZEO_ADDZEO_rec_ADDZE_rec_SUBF_SUBF8_SUBF8O_SUBF8O_rec_SUBF8_rec_SUBFE_SUBFE8_SUBFE8O_SUBFE8O_rec_SUBFE8_rec_SUBFEO_SUBFEO_rec_SUBFE_rec_SUBFME_SUBFME8_SUBFME8O_SUBFME8O_rec_SUBFME8_rec_SUBFMEO_SUBFMEO_rec_SUBFME_rec_SUBFO_SUBFO_rec_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZE8O_rec_SUBFZE8_rec_SUBFZEO_SUBFZEO_rec_SUBFZE_rec_SUBF_rec_POPCNTB_POPCNTB8_LA_LA8
  { 1, 305, 307, 3888, 3891 }, // 120 ADD4_ADD4O_ADD4O_rec_ADD4_rec_ADD8_ADD8O_ADD8O_rec_ADD8_rec_NEG_NEG8_NEG8O_NEG8O_rec_NEG8_rec_NEGO_NEGO_rec_NEG_rec_ADDI_ADDI8_ADDIS_ADDIS8_LI_LI8_LIS_LIS8_OR_OR8_OR8_rec_ORI_ORI8_ORIS_ORIS8_OR_rec_XOR_XOR8_XOR8_rec_XORI_XORI8_XORIS_XORIS8_XOR_rec_NAND_NAND8_NAND8_rec_NAND_rec_AND_AND8_AND8_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_AND_rec_NOR_NOR8_NOR8_rec_NOR_rec_ORC_ORC8_ORC8_rec_ORC_rec_EQV_EQV8_EQV8_rec_EQV_rec_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_ADD4TLS_ADD8TLS_ADD8TLS__NOP
  { 0, 0, 0, 0, 0 }, // 121 ADDIStocHA_ADDIStocHA8_ADDItocL_COPY
  { 1, 373, 375, 3891, 3894 }, // 122 MCRF
  { 1, 375, 377, 3894, 3896 }, // 123 MCRXRX
  { 1, 309, 311, 3896, 3899 }, // 124 XSNABSDP_XSXEXPDP_XSABSDP_XSNEGDP_XSCPSGNDP
  { 1, 307, 309, 3899, 3902 }, // 125 RFEBB
  { 1, 375, 377, 3902, 3904 }, // 126 TBEGIN_TRECHKPT
  { 1, 315, 317, 3904, 3907 }, // 127 WAIT
  { 1, 311, 313, 3907, 3910 }, // 128 RLDCL_RLDCR
  { 1, 311, 313, 3910, 3913 }, // 129 RLWIMI_RLWIMI8
  { 1, 311, 313, 3913, 3916 }, // 130 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32_RLDIMI
  { 1, 313, 315, 3916, 3918 }, // 131 MFOCRF_MFOCRF8
  { 1, 375, 377, 3918, 3920 }, // 132 MTOCRF_MTOCRF8
  { 1, 313, 315, 3920, 3923 }, // 133 CR6SET_CR6UNSET_CRSET_CRUNSET_CRAND_CRANDC_CRNAND_CRNOR_CROR_CRORC_CREQV_CRXOR
  { 1, 305, 307, 3923, 3926 }, // 134 SLW_SLW8_SRW_SRW8_RLWINM_RLWINM8_RLWNM_RLWNM8
  { 1, 321, 323, 3926, 3929 }, // 135 FABSD_FABSS_FNABSD_FNABSS_FNEGD_FNEGS_FCPSGND_FCPSGNS_FMR
  { 1, 311, 313, 3929, 3932 }, // 136 SRAW_SRAWI
  { 1, 326, 329, 3932, 3936 }, // 137 ISEL_ISEL8
  { 1, 309, 311, 3936, 3939 }, // 138 XSIEXPDP
  { 1, 375, 377, 3939, 3941 }, // 139 TRECLAIM_TSR_TABORT
  { 1, 323, 326, 3941, 3944 }, // 140 MFVSCR
  { 1, 315, 317, 3944, 3947 }, // 141 MTVSCR
  { 1, 309, 311, 3947, 3950 }, // 142 VCMPNEZB_VCMPNEZH_VCMPNEZW_VCMPEQUB_VCMPEQUD_VCMPEQUH_VCMPEQUW_VCMPNEB_VCMPNEH_VCMPNEW_VCMPEQFP_VCMPEQFP_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPBFP_VCMPBFP_rec_VCMPGTSB_VCMPGTSB_rec_VCMPGTSD_VCMPGTSD_rec_VCMPGTSH_VCMPGTSH_rec_VCMPGTSW_VCMPGTSW_rec_VCMPGTUB_VCMPGTUB_rec_VCMPGTUD_VCMPGTUD_rec_VCMPGTUH_VCMPGTUH_rec_VCMPGTUW_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 1, 309, 311, 3950, 3953 }, // 143 VABSDUB_VABSDUH_VABSDUW_VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTW_VPOPCNTD_VPRTYBD_VPRTYBW
  { 1, 309, 311, 3953, 3956 }, // 144 VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VADDSBS_VADDSHS_VADDSWS_VMAXFP_VMINFP_VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW_VBPERMD_VADDCUW_VSHASIGMAD_VSHASIGMAW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_VSUBCUW_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP_XVXSIGDP_XVXSIGSP
  { 1, 321, 323, 3956, 3959 }, // 145 XVTDIVDP_XVTDIVSP_XVTSQRTDP_XVTSQRTSP
  { 1, 309, 311, 3959, 3962 }, // 146 VADDFP_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VEXPTEFP_VLOGEFP_VMADDFP_VMHADDSHS_VNMSUBFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVADDDP_XVADDSP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVHPSP_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVMULDP_XVMULSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP_XVSUBDP_XVSUBSP_VCFSX_VCFSX_0_VCFUX_VCFUX_0_VMHRADDSHS_VMLADDUHM_VMSUMMBM_VMSUMSHM_VMSUMSHS_VMSUMUBM_VMSUMUHM_VMSUMUDM_VMSUMUHS_VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS_VSUMSWS
  { 1, 309, 311, 3962, 3965 }, // 147 VSUBFP_VMULUWM
  { 1, 311, 313, 3965, 3968 }, // 148 MADDHD_MADDHDU_MADDLD_MADDLD8_MULLD_MULLDO
  { 1, 311, 313, 3968, 3971 }, // 149 MULHD_MULHW_MULLW_MULLWO
  { 1, 311, 313, 3971, 3974 }, // 150 MULHDU_MULHWU
  { 1, 311, 313, 3974, 3977 }, // 151 MULLI_MULLI8
  { 1, 321, 323, 3977, 3980 }, // 152 FRSP_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRE_FRES_FADDS_FMSUBS_FMADDS_FSUBS_FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRSQRTE_FRSQRTES_FNMADDS_FNMSUBS_FSELD_FSELS_FMULS
  { 1, 321, 323, 3980, 3983 }, // 153 FADD_FSUB
  { 1, 321, 323, 3983, 3987 }, // 154 FMSUB_FMADD_FNMADD_FNMSUB_FMUL
  { 1, 309, 311, 3987, 3990 }, // 155 XSMADDADP_XSMADDASP_XSMADDMDP_XSMADDMSP_XSMSUBADP_XSMSUBASP_XSMSUBMDP_XSMSUBMSP_XSMULDP_XSMULSP_XSNMADDADP_XSNMADDASP_XSNMADDMDP_XSNMADDMSP_XSNMSUBADP_XSNMSUBASP_XSNMSUBMDP_XSNMSUBMSP
  { 1, 321, 323, 3990, 3993 }, // 156 FSELD_rec_FSELS_rec
  { 1, 311, 313, 3993, 3996 }, // 157 MULHDU_rec_MULHWU_rec
  { 1, 311, 313, 3996, 3999 }, // 158 MULHD_rec_MULHW_rec_MULLWO_rec_MULLW_rec
  { 1, 311, 313, 3999, 4002 }, // 159 MULLDO_rec_MULLD_rec
  { 1, 321, 323, 4002, 4005 }, // 160 FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRES_rec_FRE_rec_FADDS_rec_FSUBS_rec_FMSUBS_rec_FNMSUBS_rec_FMADDS_rec_FNMADDS_rec_FCFIDS_rec_FCFIDUS_rec_FCFIDU_rec_FCFID_rec_FCTIDUZ_rec_FCTIDU_rec_FCTIDZ_rec_FCTID_rec_FCTIWUZ_rec_FCTIWU_rec_FCTIWZ_rec_FCTIW_rec_FMULS_rec_FRSQRTES_rec_FRSQRTE_rec_FRSP_rec
  { 1, 321, 323, 4005, 4008 }, // 161 FADD_rec_FSUB_rec
  { 1, 321, 323, 4008, 4012 }, // 162 FMSUB_rec_FNMSUB_rec_FMADD_rec_FNMADD_rec_FMUL_rec
  { 1, 309, 311, 4012, 4015 }, // 163 XSADDDP_XSADDSP_XSCVDPHP_XSCVDPSP_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPSXWSs_XSCVDPUXWSs_XSCVHPDP_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSQRTEDP_XSRSQRTESP_XSSUBDP_XSSUBSP_XSCVDPSPN_XSRSP
  { 1, 315, 317, 4015, 4018 }, // 164 LVSL_LVSR
  { 1, 409, 411, 4018, 4021 }, // 165 VSPLTISB_VSPLTISH_VSPLTISW_VSPLTB_VSPLTBs_VSPLTH_VSPLTHs_VSPLTW_XXMRGHW_XXMRGLW_XXPERM_XXPERMR_XXSLDWI_XXSLDWIs_XXSPLTIB_XXSPLTW_XXSPLTWs_XXPERMDI_XXPERMDIs
  { 1, 309, 311, 4021, 4024 }, // 166 V_SETALLONES_V_SETALLONESB_V_SETALLONESH_VBPERMQ_VGBBD_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPERM_VPERMR_VPERMXOR_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLDOI_VSLO_VSLV_VSR_VSRO_VSRV_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW_XXEXTRACTUW_XXINSERTW_VADDCUQ_VADDECUQ_VADDEUQM_VMUL10CUQ_VMUL10ECUQ_VMUL10EUQ_VMUL10UQ_VSUBCUQ_VSUBECUQ_VSUBEUQM_XSTSTDCQP_XSXSIGQP_BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDS_rec_BCDTRUNC_rec_BCDUS_rec_BCDUTRUNC_rec_BCDADD_rec_BCDSUB_rec
  { 1, 309, 311, 4024, 4027 }, // 167 VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VINSERTB_VINSERTD_VINSERTH_VINSERTW_MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VEXTRACTD_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VPRTYBQ_VADDUQM_VSUBUQM
  { 1, 321, 323, 4027, 4030 }, // 168 XSCMPEXPQP_XSCMPOQP_XSCMPUQP
  { 1, 309, 311, 4030, 4033 }, // 169 BCDSR_rec_XSADDQP_XSADDQPO_XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP_XSRQPI_XSRQPIX_XSRQPXP_XSSUBQP_XSSUBQPO
  { 1, 309, 311, 4033, 4036 }, // 170 BCDCTSQ_rec
  { 1, 309, 311, 4036, 4039 }, // 171 XSMADDQP_XSMADDQPO_XSMSUBQP_XSMSUBQPO_XSMULQP_XSMULQPO_XSNMADDQP_XSNMADDQPO_XSNMSUBQP_XSNMSUBQPO
  { 1, 309, 311, 4039, 4042 }, // 172 BCDCFSQ_rec
  { 1, 309, 311, 4042, 4045 }, // 173 XSDIVQP_XSDIVQPO
  { 1, 309, 311, 4045, 4048 }, // 174 XSSQRTQP_XSSQRTQPO
  { 1, 315, 317, 4048, 4051 }, // 175 LXVL_LXVLL
  { 1, 315, 317, 4051, 4054 }, // 176 LVEBX_LVEHX_LVEWX_LVX_LVXL
  { 1, 345, 347, 4054, 4057 }, // 177 LXSIBZX_LXSIHZX_LXSDX_LXVB16X_LXVD2X_LXVWSX_LXSIWZX_LXV_LXVX_LXSD
  { 0, 0, 0, 0, 0 }, // 178 DFLOADf64_XFLOADf64_LIWZX
  { 0, 0, 0, 0, 0 }, // 179 DCBF_DCBFEP_DCBST_DCBSTEP_DCBT_DCBTEP_DCBZ_DCBZEP_DCBZL_DCBZLEP_DCBTST_DCBTSTEP
  { 0, 0, 0, 0, 0 }, // 180 CP_COPY_CP_COPY8
  { 0, 0, 0, 0, 0 }, // 181 ICBI_ICBIEP
  { 1, 315, 317, 4057, 4060 }, // 182 ICBT_ICBTLS_LBZ_LBZ8_LBZCIX_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LDBRX_LDCIX_LHBRX_LHBRX8_LHZ_LHZ8_LHZCIX_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWBRX_LWBRX8_LWZ_LWZ8_LWZCIX_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32_EnforceIEIO_LSWI
  { 1, 329, 334, 4060, 4063 }, // 183 LBARX_LBARXL_LHARX_LHARXL_LWARX_LWARXL
  { 1, 315, 317, 4063, 4066 }, // 184 LD_LDX_LDXTLS_LDXTLS__DARN
  { 1, 338, 345, 4066, 4069 }, // 185 LDARX_LDARXL
  { 0, 0, 0, 0, 0 }, // 186 CP_ABORT
  { 0, 0, 0, 0, 0 }, // 187 ISYNC
  { 0, 0, 0, 0, 0 }, // 188 MSGSYNC
  { 0, 0, 0, 0, 0 }, // 189 TLBSYNC
  { 0, 0, 0, 0, 0 }, // 190 SYNC
  { 1, 315, 317, 4069, 4072 }, // 191 LMW
  { 1, 345, 347, 4072, 4075 }, // 192 LFIWZX_LFDX_LFD
  { 0, 0, 0, 0, 0 }, // 193 SLBIA
  { 0, 0, 0, 0, 0 }, // 194 SLBIE
  { 0, 0, 0, 0, 0 }, // 195 SLBMFEE
  { 0, 0, 0, 0, 0 }, // 196 SLBMFEV
  { 0, 0, 0, 0, 0 }, // 197 SLBMTE
  { 0, 0, 0, 0, 0 }, // 198 TLBIEL
  { 1, 334, 338, 4075, 4079 }, // 199 LHZU_LHZU8_LWZU_LWZU8
  { 1, 334, 338, 4079, 4083 }, // 200 LHZUX_LHZUX8_LWZUX_LWZUX8
  { 1, 375, 377, 4083, 4085 }, // 201 TEND
  { 1, 377, 385, 4085, 4088 }, // 202 STBCX_STHCX_STWCX
  { 1, 377, 385, 4088, 4091 }, // 203 STDCX
  { 1, 315, 317, 4091, 4094 }, // 204 LDMX
  { 1, 351, 355, 4094, 4097 }, // 205 LHA_LHA8_LHAX_LHAX8_LWAX_LWAX_32
  { 0, 0, 0, 0, 0 }, // 206 CP_PASTE8_rec_CP_PASTE_rec
  { 1, 369, 373, 4097, 4100 }, // 207 LWA_LWA_32
  { 1, 375, 377, 4100, 4102 }, // 208 TCHECK
  { 1, 345, 347, 4102, 4105 }, // 209 LFIWAX
  { 1, 345, 347, 4105, 4108 }, // 210 LXSIWAX
  { 0, 0, 0, 0, 0 }, // 211 LIWAX
  { 1, 345, 347, 4108, 4111 }, // 212 LFSX_LFS
  { 1, 345, 347, 4111, 4114 }, // 213 LXSSP_LXSSPX
  { 0, 0, 0, 0, 0 }, // 214 XFLOADf32_DFLOADf32
  { 1, 355, 360, 4114, 4118 }, // 215 LHAU_LHAU8
  { 1, 360, 369, 4118, 4122 }, // 216 LHAUX_LHAUX8_LWAUX
  { 1, 345, 347, 4122, 4125 }, // 217 LXVH8X_LXVDSX_LXVW4X
  { 1, 401, 404, 4125, 4128 }, // 218 STFD_STFDX_STFIWX_STFS_STFSX_STXSD_STXSDX_STXSIBX_STXSIBXv_STXSIHX_STXSIHXv_STXSIWX_STXSSP_STXSSPX
  { 1, 323, 326, 4128, 4131 }, // 219 STW_STW8_STDBRX_STHBRX_STWBRX_STB_STB8_STH_STH8_STBX_STBX8_STBXTLS_STBXTLS__STBXTLS_32_STHX_STHX8_STHXTLS_STHXTLS__STHXTLS_32_STWX_STWX8_STWXTLS_STWXTLS__STWXTLS_32
  { 0, 0, 0, 0, 0 }, // 220 DFSTOREf32_DFSTOREf64_XFSTOREf32_XFSTOREf64_STIWX
  { 1, 398, 401, 0, 0 }, // 221 STD_STDX_STDXTLS_STDXTLS_
  { 1, 315, 317, 4131, 4134 }, // 222 STBCIX_STDCIX_STHCIX_STWCIX_STSWI
  { 0, 0, 0, 0, 0 }, // 223 SLBIEG
  { 1, 315, 317, 4134, 4137 }, // 224 STMW
  { 0, 0, 0, 0, 0 }, // 225 TLBIE
  { 1, 323, 326, 4137, 4140 }, // 226 STVEBX_STVEHX_STVEWX_STVX_STVXL
  { 1, 401, 404, 4140, 4143 }, // 227 STXV_STXVB16X_STXVD2X_STXVH8X_STXVW4X_STXVX
  { 1, 315, 317, 4143, 4146 }, // 228 STXVL_STXVLL
  { 1, 375, 377, 4146, 4148 }, // 229 MTCTR_MTCTR8_MTCTR8loop_MTCTRloop_MTLR_MTLR8
  { 1, 305, 307, 4148, 4151 }, // 230 MFVRSAVE_MFVRSAVEv_MTVRSAVE_MTVRSAVEv
  { 0, 0, 0, 0, 0 }, // 231 MFPMR
  { 0, 0, 0, 0, 0 }, // 232 MTPMR
  { 0, 0, 0, 0, 0 }, // 233 MFTB_MFTB8
  { 0, 0, 0, 0, 0 }, // 234 MFCTR_MFCTR8_MFLR_MFLR8_MFSPR_MFSPR8
  { 0, 0, 0, 0, 0 }, // 235 MFMSR
  { 0, 0, 0, 0, 0 }, // 236 MTMSR
  { 0, 0, 0, 0, 0 }, // 237 MTMSRD
  { 1, 375, 377, 4151, 4153 }, // 238 MTSPR_MTSPR8
  { 1, 319, 321, 4153, 4156 }, // 239 DIVW_DIVWO_DIVWU_DIVWUO_MODSW
  { 1, 319, 321, 4156, 4159 }, // 240 DIVWE_DIVWEO_DIVWEU_DIVWEUO_MODSD_MODUD_MODUW
  { 1, 317, 319, 4159, 4162 }, // 241 DIVD_DIVDO_DIVDU_DIVDUO
  { 1, 317, 319, 4162, 4165 }, // 242 DIVDE_DIVDEO_DIVDEU_DIVDEUO
  { 1, 319, 321, 4165, 4168 }, // 243 DIVWO_rec_DIVWUO_rec_DIVWU_rec_DIVW_rec
  { 1, 317, 319, 4168, 4171 }, // 244 DIVD_rec_DIVDO_rec_DIVDU_rec_DIVDUO_rec
  { 1, 319, 321, 4171, 4174 }, // 245 DIVWE_rec_DIVWEO_rec_DIVWEU_rec_DIVWEUO_rec
  { 1, 317, 319, 4174, 4177 }, // 246 DIVDE_rec_DIVDEO_rec_DIVDEU_rec_DIVDEUO_rec
  { 1, 375, 377, 4177, 4179 }, // 247 MTCRF_MTCRF8
  { 1, 305, 307, 4179, 4182 }, // 248 ADDC8O_rec_ADDC8_rec_ADDCO_rec_ADDC_rec_SUBFC8O_rec_SUBFC8_rec_SUBFCO_rec_SUBFC_rec
  { 1, 321, 323, 4182, 4185 }, // 249 FABSD_rec_FABSS_rec_FNABSD_rec_FNABSS_rec_FCPSGND_rec_FCPSGNS_rec_FNEGD_rec_FNEGS_rec_FMR_rec
  { 1, 373, 375, 4185, 4188 }, // 250 MCRFS
  { 0, 0, 0, 0, 0 }, // 251 MTFSF_MTFSF_rec_MTFSFI_MTFSFI_rec_MTFSFIb
  { 0, 0, 0, 0, 0 }, // 252 MTFSFb
  { 1, 311, 313, 4188, 4191 }, // 253 RLDCL_rec_RLDCR_rec
  { 1, 311, 313, 4191, 4194 }, // 254 RLDICL_rec_RLDICR_rec_RLDICL_32_rec_RLDIMI_rec
  { 1, 311, 313, 4194, 4197 }, // 255 RLWIMI8_rec_RLWIMI_rec
  { 1, 305, 307, 4197, 4200 }, // 256 RLWINM8_rec_RLWINM_rec_RLWNM8_rec_RLWNM_rec_SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 1, 311, 313, 4200, 4203 }, // 257 SRAWI_rec_SRAW_rec
  { 0, 0, 0, 0, 0 }, // 258 MFFS_MFFSCE_MFFSL_MFFS_rec
  { 1, 313, 315, 4203, 4205 }, // 259 MFCR_MFCR8
  { 1, 311, 313, 4205, 4208 }, // 260 EXTSWSLI_32_64_rec_SRADI_rec_EXTSWSLI_rec_RLDIC_rec
  { 1, 311, 313, 4208, 4211 }, // 261 SRAD_rec_SLD_rec_SRD_rec
  { 1, 321, 323, 4211, 4214 }, // 262 FDIV
  { 1, 321, 323, 4214, 4217 }, // 263 FDIV_rec
  { 1, 321, 323, 4217, 4220 }, // 264 XSSQRTDP
  { 1, 321, 323, 4220, 4223 }, // 265 FSQRT
  { 1, 321, 323, 4223, 4226 }, // 266 XVSQRTDP
  { 1, 321, 323, 4226, 4229 }, // 267 XVSQRTSP
  { 1, 321, 323, 4229, 4232 }, // 268 FSQRT_rec
  { 1, 321, 323, 4232, 4235 }, // 269 XSSQRTSP
  { 1, 321, 323, 4235, 4238 }, // 270 FSQRTS
  { 1, 321, 323, 4238, 4241 }, // 271 FSQRTS_rec
  { 1, 321, 323, 4241, 4244 }, // 272 XSDIVDP
  { 1, 321, 323, 4244, 4247 }, // 273 FDIVS
  { 1, 321, 323, 4247, 4250 }, // 274 FDIVS_rec
  { 1, 321, 323, 4250, 4253 }, // 275 XSDIVSP
  { 1, 321, 323, 4253, 4256 }, // 276 XVDIVSP
  { 1, 321, 323, 4256, 4259 }, // 277 XVDIVDP
  { 1, 347, 351, 4259, 4263 }, // 278 LFSU
  { 1, 347, 351, 4263, 4267 }, // 279 LFSUX
  { 1, 404, 409, 4267, 4271 }, // 280 STFDU_STFDUX_STFSU_STFSUX
  { 1, 385, 389, 4271, 4275 }, // 281 STBU_STBU8_STDU_STHU_STHU8_STWU_STWU8
  { 1, 389, 398, 4275, 4279 }, // 282 STBUX_STBUX8_STDUX_STHUX_STHUX8_STWUX_STWUX8
  { 1, 334, 338, 4279, 4283 }, // 283 LBZU_LBZU8
  { 1, 334, 338, 4283, 4287 }, // 284 LBZUX_LBZUX8
  { 1, 334, 338, 4287, 4291 }, // 285 LDU
  { 1, 334, 338, 4291, 4295 }, // 286 LDUX
  { 1, 347, 351, 4295, 4299 }, // 287 LFDU
  { 1, 347, 351, 4299, 4303 }, // 288 LFDUX
  { 1, 309, 311, 4303, 4306 }, // 289 VPMSUMB_VPMSUMD_VPMSUMH_VPMSUMW_VCIPHER_VCIPHERLAST_VNCIPHER_VNCIPHERLAST_VSBOX
  { 1, 307, 309, 4306, 4309 }, // 290 BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_BCCTR_BCCTR8_BCCTR8n_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_BCCTRn_BDNZ_BDNZ8_BDNZA_BDNZAm_BDNZAp_BDNZm_BDNZp_BDZ_BDZ8_BDZA_BDZAm_BDZAp_BDZm_BDZp_BDNZL_BDNZLA_BDNZLAm_BDNZLAp_BDNZLR_BDNZLR8_BDNZLRL_BDNZLRLm_BDNZLRLp_BDNZLRm_BDNZLRp_BDNZLm_BDNZLp_BDZL_BDZLA_BDZLAm_BDZLAp_BDZLR_BDZLR8_BDZLRL_BDZLRLm_BDZLRLp_BDZLRm_BDZLRp_BDZLm_BDZLp_BL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM_BLR_BLR8_BLRL_TAILB_TAILB8_TAILBA_TAILBA8_TAILBCTR_TAILBCTR8_gBC_gBCA_gBCAat_gBCCTR_gBCCTRL_gBCL_gBCLA_gBCLAat_gBCLR_gBCLRL_gBCLat_gBCat_BCLR_BCLRL_BCLRLn_BCLRn_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_RM_BCTRL_RM_B_BA_BC_BCC_BCCA_BCL_BCLalways_BCLn_BCTRL8_LDinto_toc_BCTRL_LWZinto_toc_BCTRL8_LDinto_toc_RM_BCTRL_LWZinto_toc_RM_BCn_CTRL_DEP
  { 1, 307, 309, 4309, 4312 }, // 291 ADDPCIS
  { 1, 315, 317, 4312, 4315 }, // 292 LDAT_LWAT
  { 1, 323, 326, 4315, 4318 }, // 293 STDAT_STWAT
  { 1, 305, 307, 4318, 4321 }, // 294 BRINC
  { 1, 309, 311, 4321, 4324 }, // 295 EVABS_EVEQV_EVNAND_EVNEG_EVADDIW_EVADDW_EVAND_EVANDC_EVCMPEQ_EVCMPGTS_EVCMPGTU_EVCMPLTS_EVCMPLTU_EVCNTLSW_EVCNTLZW_EVEXTSB_EVEXTSH_EVMERGEHI_EVMERGEHILO_EVMERGELO_EVMERGELOHI_EVNOR_EVOR_EVORC_EVXOR_EVRLW_EVRLWI_EVRNDW_EVSLW_EVSLWI_EVSPLATFI_EVSPLATI_EVSRWIS_EVSRWIU_EVSRWS_EVSRWU_EVSUBFW_EVSUBIFW
  { 1, 309, 311, 4324, 4327 }, // 296 EVMRA_EVADDSMIAAW_EVADDSSIAAW_EVADDUMIAAW_EVADDUSIAAW_EVDIVWS_EVDIVWU_EVMHEGSMFAA_EVMHEGSMFAN_EVMHEGSMIAA_EVMHEGSMIAN_EVMHEGUMIAA_EVMHEGUMIAN_EVMHESMF_EVMHESMFA_EVMHESMFAAW_EVMHESMFANW_EVMHESMI_EVMHESMIA_EVMHESMIAAW_EVMHESMIANW_EVMHESSF_EVMHESSFA_EVMHESSFAAW_EVMHESSFANW_EVMHESSIAAW_EVMHESSIANW_EVMHEUMI_EVMHEUMIA_EVMHEUMIAAW_EVMHEUMIANW_EVMHEUSIAAW_EVMHEUSIANW_EVMHOGSMFAA_EVMHOGSMFAN_EVMHOGSMIAA_EVMHOGSMIAN_EVMHOGUMIAA_EVMHOGUMIAN_EVMHOSMF_EVMHOSMFA_EVMHOSMFAAW_EVMHOSMFANW_EVMHOSMI_EVMHOSMIA_EVMHOSMIAAW_EVMHOSMIANW_EVMHOSSF_EVMHOSSFA_EVMHOSSFAAW_EVMHOSSFANW_EVMHOSSIAAW_EVMHOSSIANW_EVMHOUMI_EVMHOUMIA_EVMHOUMIAAW_EVMHOUMIANW_EVMHOUSIAAW_EVMHOUSIANW_EVMWHSMF_EVMWHSMFA_EVMWHSMI_EVMWHSMIA_EVMWHSSF_EVMWHSSFA_EVMWHUMI_EVMWHUMIA_EVMWLSMIAAW_EVMWLSMIANW_EVMWLSSIAAW_EVMWLSSIANW_EVMWLUMI_EVMWLUMIA_EVMWLUMIAAW_EVMWLUMIANW_EVMWLUSIAAW_EVMWLUSIANW_EVMWSMF_EVMWSMFA_EVMWSMFAA_EVMWSMFAN_EVMWSMI_EVMWSMIA_EVMWSMIAA_EVMWSMIAN_EVMWSSF_EVMWSSFA_EVMWSSFAA_EVMWSSFAN_EVMWUMI_EVMWUMIA_EVMWUMIAA_EVMWUMIAN_EVSUBFSMIAAW_EVSUBFSSIAAW_EVSUBFUMIAAW_EVSUBFUSIAAW
  { 1, 315, 317, 4327, 4330 }, // 297 EVLDD_EVLDDX_EVLDH_EVLDHX_EVLDW_EVLDWX_EVLHHESPLAT_EVLHHESPLATX_EVLHHOSSPLAT_EVLHHOSSPLATX_EVLHHOUSPLAT_EVLHHOUSPLATX_EVLWHE_EVLWHEX_EVLWHOS_EVLWHOSX_EVLWHOU_EVLWHOUX_EVLWHSPLAT_EVLWHSPLATX_EVLWWSPLAT_EVLWWSPLATX
  { 1, 323, 326, 4330, 4333 }, // 298 EVSTDD_EVSTDDX_EVSTDH_EVSTDHX_EVSTDW_EVSTDWX_EVSTWHE_EVSTWHEX_EVSTWHO_EVSTWHOX_EVSTWWE_EVSTWWEX_EVSTWWO_EVSTWWOX
  { 1, 307, 309, 4333, 4336 }, // 299 HRFID_ATTN_CLRBHRB_MFBHRBE_NAP_RFCI_RFDI_RFMCI_SC
  { 0, 0, 0, 0, 0 }, // 300 RFI
  { 0, 0, 0, 0, 0 }, // 301 RFID
  { 1, 315, 317, 4336, 4339 }, // 302 DSS_DSSALL_DST_DST64_DSTST_DSTST64_DSTSTT_DSTSTT64_DSTT_DSTT64_ICBLQ_LBEPX_LHEPX_LWEPX_TLBIVAX_TLBLD_TLBLI_TLBRE_TLBRE2_TLBSX_TLBSX2_TLBSX2D_TLBWE_TLBWE2_MBAR_TRAP_DCCCI_ICCCI
  { 1, 323, 326, 4339, 4342 }, // 303 ICBLC_STBEPX_STHEPX_STWEPX
  { 1, 345, 347, 4342, 4345 }, // 304 LFDEPX
  { 1, 401, 404, 4345, 4348 }, // 305 STFDEPX
  { 0, 0, 0, 0, 0 }, // 306 MFSR_MFSRIN
  { 0, 0, 0, 0, 0 }, // 307 MTSR_MTSRIN
  { 0, 0, 0, 0, 0 }, // 308 MFDCR
  { 1, 375, 377, 4348, 4350 }, // 309 MTDCR
  { 1, 305, 307, 4350, 4353 }, // 310 NOP_GT_PWR6_NOP_GT_PWR7
  { 0, 0, 0, 0, 0 }, // 311 TLBIA
  { 0, 0, 0, 0, 0 }, // 312 WRTEE_WRTEEI
  { 1, 305, 307, 4353, 4356 }, // 313 HASHCHK_HASHCHK8_HASHCHKP_HASHCHKP8_HASHST_HASHST8_HASHSTP_HASHSTP8_ADDEX_ADDEX8
  { 0, 0, 0, 0, 0 }, // 314 MSYNC
  { 0, 0, 0, 0, 0 }, // 315 SLBSYNC
  { 0, 0, 0, 0, 0 }, // 316 SLBFEE_rec
  { 0, 0, 0, 0, 0 }, // 317 STOP
  { 0, 0, 0, 0, 0 }, // 318 DCBA_DCBI
  { 1, 321, 323, 4356, 4359 }, // 319 FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRE_FRES_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRSP_FRSQRTE_FRSQRTES
  { 1, 309, 311, 4359, 4362 }, // 320 VCFSX_VCFSX_0_VCFUX_VCFUX_0_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VLOGEFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP
  { 1, 309, 311, 4362, 4365 }, // 321 XSCVDPHP_XSCVDPSP_XSCVDPSPN_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPSXWSs_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPUXWSs_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSP_XSRSQRTEDP_XSRSQRTESP
  { 1, 309, 311, 4365, 4368 }, // 322 XVCVSPBF16
  { 1, 321, 323, 4368, 4371 }, // 323 FADDS_FMULS_FSUBS
  { 1, 321, 323, 4371, 4375 }, // 324 FMUL
  { 1, 309, 311, 4375, 4378 }, // 325 VADDFP_XVADDDP_XVADDSP_XVMULDP_XVMULSP_XVSUBDP_XVSUBSP
  { 1, 309, 311, 4378, 4381 }, // 326 VSUBFP
  { 1, 309, 311, 4381, 4384 }, // 327 XSADDDP_XSADDSP_XSSUBDP_XSSUBSP
  { 1, 309, 311, 4384, 4387 }, // 328 XSMULDP_XSMULSP
  { 1, 309, 311, 4387, 4390 }, // 329 VMADDFP_VNMSUBFP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP
  { 1, 309, 311, 4390, 4393 }, // 330 VEXPTEFP
  { 1, 321, 323, 4393, 4396 }, // 331 FADDS_rec_FMULS_rec_FSUBS_rec
  { 1, 321, 323, 4396, 4400 }, // 332 FMUL_rec
  { 1, 321, 323, 4400, 4403 }, // 333 FCFID_rec_FCFIDS_rec_FCFIDU_rec_FCFIDUS_rec_FCTID_rec_FCTIDU_rec_FCTIDUZ_rec_FCTIDZ_rec_FCTIW_rec_FCTIWU_rec_FCTIWUZ_rec_FCTIWZ_rec_FRE_rec_FRES_rec_FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRSP_rec_FRSQRTE_rec_FRSQRTES_rec
  { 1, 307, 309, 4403, 4406 }, // 334 BCLR_BCLRn_BDNZLR_BDNZLR8_BDNZLRm_BDNZLRp_BDZLR_BDZLR8_BDZLRm_BDZLRp_gBCLR_BCLRL_BCLRLn_BDNZLRL_BDNZLRLm_BDNZLRLp_BDZLRL_BDZLRLm_BDZLRLp_gBCLRL_BL_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLR_BLR8_BLRL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS
  { 1, 307, 309, 4406, 4409 }, // 335 BL8_NOTOC_BL8_NOTOC_RM_BL8_NOTOC_TLS
  { 1, 307, 309, 4409, 4412 }, // 336 B_BCC_BCCA_BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_CTRL_DEP_TAILB_TAILB8_BA_TAILBA_TAILBA8_BC_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_LDinto_toc_BCTRL8_LDinto_toc_RM_BCTRL8_RM_BCTRL_LWZinto_toc_BCTRL_LWZinto_toc_RM_BCTRL_RM_BCn_BDNZ_BDNZ8_BDNZm_BDNZp_BDZ_BDZ8_BDZm_BDZp_TAILBCTR_TAILBCTR8_gBC_gBCat_BCL_BCLalways_BCLn_BDNZL_BDNZLm_BDNZLp_BDZL_BDZLm_BDZLp_gBCL_gBCLat_BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM
  { 1, 307, 309, 4412, 4415 }, // 337 BCCTR_BCCTR8_BCCTR8n_BCCTRn_gBCCTR_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_gBCCTRL
  { 1, 309, 311, 4415, 4418 }, // 338 VSBOX
  { 1, 305, 307, 4418, 4421 }, // 339 CFUGED_CNTLZDM_CNTTZDM_PDEPD_PEXTD
  { 1, 309, 311, 4421, 4424 }, // 340 VCFUGED_VCLZDM_VCTZDM_VGNB_VPDEPD_VPEXTD
  { 1, 309, 311, 4424, 4427 }, // 341 XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP
  { 1, 309, 311, 4427, 4430 }, // 342 XSCVQPSQZ_XSCVQPUQZ_XSCVSQQP_XSCVUQQP
  { 1, 309, 311, 4430, 4433 }, // 343 XSADDQP_XSADDQPO_XSSUBQP_XSSUBQPO
  { 1, 305, 307, 4433, 4436 }, // 344 HASHST_HASHST8_HASHSTP_HASHSTP8
  { 1, 309, 311, 4436, 4439 }, // 345 XSMULQP_XSMULQPO
  { 1, 309, 311, 4439, 4442 }, // 346 VDIVESQ_VDIVEUQ_VDIVSQ_VDIVUQ
  { 1, 309, 311, 4442, 4445 }, // 347 VMODSQ_VMODUQ
  { 1, 319, 321, 4445, 4448 }, // 348 DIVWE_DIVWEO_DIVWEU_DIVWEUO
  { 1, 309, 311, 4448, 4451 }, // 349 VDIVSD_VDIVUD
  { 1, 309, 311, 4451, 4454 }, // 350 VMODSD_VMODUD
  { 1, 309, 311, 4454, 4457 }, // 351 VDIVSW_VDIVUW
  { 1, 309, 311, 4457, 4460 }, // 352 VMODSW_VMODUW
  { 1, 309, 311, 4460, 4463 }, // 353 VDIVESD_VDIVEUD
  { 1, 309, 311, 4463, 4466 }, // 354 VDIVESW_VDIVEUW
  { 1, 309, 311, 4466, 4469 }, // 355 BCDCTN_rec_VMUL10CUQ_VMUL10UQ_XSXSIGQP
  { 1, 309, 311, 4469, 4472 }, // 356 BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDUS_rec_BCDUTRUNC_rec_VADDCUQ_VMUL10ECUQ_VMUL10EUQ_VSUBCUQ_XSTSTDCQP
  { 1, 309, 311, 4472, 4475 }, // 357 VADDUQM_VSUBUQM
  { 1, 309, 311, 4475, 4478 }, // 358 XSMAXCQP_XSMINCQP
  { 1, 309, 311, 4478, 4481 }, // 359 XXGENPCVBM
  { 1, 309, 311, 4481, 4484 }, // 360 BCDADD_rec_BCDS_rec_BCDSUB_rec_BCDTRUNC_rec_VADDECUQ_VADDEUQM_VSUBECUQ_VSUBEUQM
  { 1, 315, 317, 4484, 4487 }, // 361 TRAP
  { 1, 311, 313, 4487, 4489 }, // 362 TW
  { 1, 305, 307, 4489, 4492 }, // 363 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW
  { 1, 321, 323, 4492, 4495 }, // 364 FTSQRT
  { 1, 309, 311, 4495, 4498 }, // 365 MTVSRBM_MTVSRBMI_MTVSRDM_MTVSRHM_MTVSRQM_MTVSRWM_VEXPANDBM_VEXPANDDM_VEXPANDHM_VEXPANDQM_VEXPANDWM_VEXTRACTBM_VEXTRACTDM_VEXTRACTHM_VEXTRACTQM_VEXTRACTWM_XVTLSBB
  { 1, 305, 307, 4498, 4501 }, // 366 POPCNTB_POPCNTB8
  { 1, 309, 311, 4501, 4504 }, // 367 VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTD_VPOPCNTW_VPRTYBD_VPRTYBW
  { 1, 309, 311, 4504, 4507 }, // 368 VPOPCNTB_VPOPCNTH
  { 1, 309, 311, 4507, 4510 }, // 369 XSCVSPDPN
  { 1, 321, 323, 4510, 4513 }, // 370 XSTSQRTDP
  { 1, 309, 311, 4513, 4516 }, // 371 XVCVHPSP
  { 1, 321, 323, 4516, 4519 }, // 372 XVTSQRTDP_XVTSQRTSP
  { 1, 311, 313, 4519, 4522 }, // 373 CMPEQB
  { 1, 311, 313, 4522, 4525 }, // 374 EXTSWSLI_32_64_rec_EXTSWSLI_rec
  { 1, 311, 313, 4525, 4528 }, // 375 SLD_rec_SRD_rec
  { 1, 305, 307, 4528, 4531 }, // 376 SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 1, 309, 311, 4531, 4534 }, // 377 VADDCUW_VADDSBS_VADDSHS_VADDSWS_VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VMAXFP_VMINFP_VSUBCUW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP
  { 1, 309, 311, 4534, 4537 }, // 378 VCMPBFP_VCMPBFP_rec_VCMPEQFP_VCMPEQFP_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPGTSB_rec_VCMPGTSD_rec_VCMPGTSH_rec_VCMPGTSW_rec_VCMPGTUB_rec_VCMPGTUD_rec_VCMPGTUH_rec_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 1, 309, 311, 4537, 4540 }, // 379 VCMPEQUQ_VCMPEQUQ_rec_VCMPGTSQ_VCMPGTSQ_rec_VCMPGTUQ_VCMPGTUQ_rec
  { 1, 309, 311, 4540, 4543 }, // 380 VCMPSQ_VCMPUQ_VCNTMBB_VCNTMBD_VCNTMBH_VCNTMBW
  { 1, 309, 311, 4543, 4546 }, // 381 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP
  { 1, 311, 313, 4546, 4549 }, // 382 RLDIC_rec
  { 1, 311, 313, 4549, 4552 }, // 383 RLDICL_32_rec_RLDICL_rec_RLDICR_rec
  { 1, 309, 311, 4552, 4555 }, // 384 VSHASIGMAD_VSHASIGMAW
  { 1, 309, 311, 4555, 4558 }, // 385 VRLQ_VRLQNM_VSLQ_VSRAQ_VSRQ
  { 1, 309, 311, 4558, 4561 }, // 386 VRLQMI
  { 1, 313, 315, 4561, 4564 }, // 387 CR6SET_CREQV_CRSET
  { 1, 315, 317, 4564, 4567 }, // 388 DSS_DSSALL
  { 0, 0, 0, 0, 0 }, // 389 MFCTR_MFCTR8_MFLR_MFLR8
  { 1, 305, 307, 4567, 4570 }, // 390 NOP_ORI_ORI8
  { 1, 309, 311, 4570, 4573 }, // 391 VXOR_V_SET0_V_SET0B_V_SET0H
  { 1, 309, 311, 4573, 4576 }, // 392 XXLEQV_XXLEQVOnes_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 1, 305, 307, 4576, 4579 }, // 393 ADDI_ADDI8_LI_LI8_ADDIS_ADDIS8_LIS_LIS8_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_NEG_NEG8_NEG8_rec_NEG_rec_NEG8O_NEGO
  { 0, 0, 0, 0, 0 }, // 394 ADDIdtprelL32_ADDItlsldLADDR32_ADDISdtprelHA32
  { 0, 0, 0, 0, 0 }, // 395 ADDItocL_ADDIStocHA_ADDIStocHA8
  { 1, 305, 307, 4579, 4582 }, // 396 ADDME_ADDME8_ADDME8O_ADDMEO_ADDZE_ADDZE8_ADDZE8O_ADDZEO_SUBFME_SUBFME8_SUBFME8O_SUBFMEO_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZEO
  { 1, 321, 323, 4582, 4585 }, // 397 FABSD_FABSS_FMR_FNABSD_FNABSS_FNEGD_FNEGS
  { 1, 305, 307, 4585, 4588 }, // 398 SETB_SETB8
  { 1, 311, 313, 4588, 4591 }, // 399 SETBC_SETBC8_SETBCR_SETBCR8_SETNBC_SETNBC8_SETNBCR_SETNBCR8
  { 1, 309, 311, 4591, 4594 }, // 400 VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VNEGD_VNEGW
  { 1, 309, 311, 4594, 4597 }, // 401 VEXTSD2Q
  { 1, 309, 311, 4597, 4600 }, // 402 XSABSDP_XSNABSDP_XSNEGDP_XSXEXPDP
  { 1, 309, 311, 4600, 4603 }, // 403 XSABSQP_XSNABSQP_XSNEGQP_XSXEXPQP_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVNEGDP_XVNEGSP_XVXEXPDP_XVXEXPSP
  { 1, 309, 311, 4603, 4606 }, // 404 XVXSIGDP_XVXSIGSP
  { 1, 305, 307, 4606, 4609 }, // 405 ADD4_ADD4TLS_ADD8_ADD8TLS_ADD8TLS__ADD4_rec_ADD8_rec_ADD4O_ADD8O_AND_AND8_AND8_rec_AND_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_EQV_EQV8_EQV8_rec_EQV_rec_NAND_NAND8_NAND8_rec_NAND_rec_NOR_NOR8_NOR8_rec_NOR_rec_OR_OR8_OR8_rec_OR_rec_ORC_ORC8_ORC8_rec_ORC_rec_ORIS_ORIS8_XOR_XOR8_XOR8_rec_XOR_rec_XORI_XORI8_XORIS_XORIS8
  { 1, 305, 307, 4609, 4612 }, // 406 ADDE_ADDE8_ADDE8O_ADDEO_ADDIC_ADDIC8_ANDI8_rec_ANDI_rec_ANDIS8_rec_ANDIS_rec_SUBF_SUBF8_SUBF8_rec_SUBF_rec_SUBFE_SUBFE8_SUBFE8O_SUBFEO_SUBFIC_SUBFIC8_SUBF8O_SUBFO
  { 1, 305, 307, 4612, 4615 }, // 407 CMPB_CMPB8
  { 1, 311, 313, 4615, 4618 }, // 408 EXTSWSLI_EXTSWSLI_32_64_SRADI_SRADI_32
  { 1, 305, 307, 4618, 4621 }, // 409 SLW_SLW8_SRW_SRW8
  { 1, 309, 311, 4621, 4624 }, // 410 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEQV_VNAND_VORC_VSLD_VSRAD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_XXLAND_XXLANDC_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC
  { 1, 309, 311, 4624, 4627 }, // 411 VAND_VANDC_VMRGEW_VMRGOW_VNOR_VOR_VRLB_VRLD_VRLDNM_VRLH_VRLW_VRLWNM_VSLB_VSLH_VSLW_VSRAB_VSRAH_VSRAW_VSRB_VSRH_VSRW_XSCPSGNQP_XSIEXPQP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP
  { 1, 309, 311, 4627, 4630 }, // 412 VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW
  { 1, 305, 307, 4630, 4633 }, // 413 ADDEX_ADDEX8
  { 1, 315, 317, 4633, 4636 }, // 414 DST_DST64_DSTT_DSTT64_DSTST_DSTST64_DSTSTT_DSTSTT64
  { 1, 311, 313, 4636, 4639 }, // 415 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32
  { 0, 0, 0, 0, 0 }, // 416 MFFS_MFFS_rec_MFFSL
  { 1, 375, 377, 4639, 4641 }, // 417 TRECHKPT
  { 1, 305, 307, 4641, 4644 }, // 418 ADDME8_rec_ADDME_rec_ADDME8O_rec_ADDMEO_rec_ADDZE8_rec_ADDZE_rec_ADDZE8O_rec_ADDZEO_rec_SUBFME8_rec_SUBFME_rec_SUBFME8O_rec_SUBFMEO_rec_SUBFZE8_rec_SUBFZE_rec_SUBFZE8O_rec_SUBFZEO_rec
  { 0, 0, 0, 0, 0 }, // 419 MTFSB0
  { 1, 305, 307, 4644, 4647 }, // 420 NEG8O_rec_NEGO_rec
  { 1, 305, 307, 4647, 4650 }, // 421 ADDE8_rec_ADDE_rec_ADDE8O_rec_ADDEO_rec_ADDIC_rec_SUBFE8_rec_SUBFE_rec_SUBFE8O_rec_SUBFEO_rec_SUBF8O_rec_SUBFO_rec
  { 1, 307, 309, 4650, 4653 }, // 422 HRFID
  { 1, 321, 323, 4653, 4656 }, // 423 FABSD_rec_FABSS_rec_FMR_rec_FNABSD_rec_FNABSS_rec_FNEGD_rec_FNEGS_rec
  { 1, 307, 309, 4656, 4659 }, // 424 SC
  { 1, 305, 307, 4659, 4662 }, // 425 ADDC_ADDC8_ADDC8O_ADDCO_SUBFC_SUBFC8_SUBFC8O_SUBFCO
  { 1, 305, 307, 4662, 4665 }, // 426 ADDC8_rec_ADDC_rec_SUBFC8_rec_SUBFC_rec
  { 0, 0, 0, 0, 0 }, // 427 MTFSF_MTFSFI_MTFSFIb
  { 0, 0, 0, 0, 0 }, // 428 MTFSFI_rec
  { 1, 309, 311, 4665, 4668 }, // 429 VSTRIBL_rec_VSTRIBR_rec_VSTRIHL_rec_VSTRIHR_rec
  { 1, 315, 317, 4668, 4671 }, // 430 LBZ_LBZ8_LDBRX_LHBRX_LHBRX8_LHZ_LHZ8_LWBRX_LWBRX8_LWZ_LWZ8
  { 1, 315, 317, 4671, 4674 }, // 431 LD
  { 0, 0, 0, 0, 0 }, // 432 LDtoc_LDtocBA_LDtocCPT_LDtocJTI_LDtocL_SPILLTOVSR_LD_LWZtoc_LWZtocL
  { 1, 345, 347, 4674, 4677 }, // 433 LXVRBX_LXVRDX_LXVRHX_LXVRWX
  { 0, 0, 0, 0, 0 }, // 434 DCBT_DCBTST
  { 1, 315, 317, 4677, 4680 }, // 435 ICBT_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32
  { 1, 315, 317, 4680, 4683 }, // 436 LDX_LDXTLS_LDXTLS_
  { 0, 0, 0, 0, 0 }, // 437 SPILLTOVSR_LDX
  { 1, 315, 317, 4683, 4686 }, // 438 LBZCIX_LDCIX_LHZCIX_LWZCIX
  { 0, 0, 0, 0, 0 }, // 439 MTSR
  { 1, 305, 307, 4686, 4689 }, // 440 MTVRSAVE_MTVRSAVEv
  { 1, 315, 317, 4689, 4692 }, // 441 LSWI
  { 1, 345, 347, 4692, 4695 }, // 442 PLBZ_PLBZ8_PLBZ8pc_PLBZpc_PLD_PLDpc_PLFD_PLFDpc_PLFS_PLFSpc_PLHA_PLHA8_PLHA8pc_PLHApc_PLHZ_PLHZ8_PLHZ8pc_PLHZpc_PLWA_PLWA8_PLWA8pc_PLWApc_PLWZ_PLWZ8_PLWZ8pc_PLWZpc_PLXSD_PLXSDpc_PLXSSP_PLXSSPpc_PLXV_PLXVpc_PLXVP_PLXVPpc
  { 1, 345, 347, 4695, 4698 }, // 443 LXVP_LXVPX
  { 0, 0, 0, 0, 0 }, // 444 MFSR
  { 0, 0, 0, 0, 0 }, // 445 MFTB8
  { 1, 309, 311, 4698, 4701 }, // 446 XXSETACCZ
  { 1, 309, 311, 4701, 4704 }, // 447 XVBF16GER2_XVF16GER2_XVF32GER_XVF64GER_XVI16GER2_XVI16GER2S_XVI4GER8_XVI8GER4
  { 1, 309, 311, 4704, 4707 }, // 448 XVBF16GER2NN_XVBF16GER2NP_XVBF16GER2PN_XVBF16GER2PP_XVF16GER2NN_XVF16GER2NP_XVF16GER2PN_XVF16GER2PP_XVF32GERNN_XVF32GERNP_XVF32GERPN_XVF32GERPP_XVF64GERNN_XVF64GERNP_XVF64GERPN_XVF64GERPP_XVI16GER2PP_XVI16GER2SPP_XVI4GER8PP_XVI8GER4PP
  { 1, 309, 311, 4707, 4710 }, // 449 XVI8GER4SPP
  { 1, 309, 311, 4710, 4713 }, // 450 PMXVF32GER_PMXVF64GER
  { 1, 309, 311, 4713, 4716 }, // 451 PMXVBF16GER2_PMXVF16GER2_PMXVF32GERNN_PMXVF32GERNP_PMXVF32GERPN_PMXVF32GERPP_PMXVF64GERNN_PMXVF64GERNP_PMXVF64GERPN_PMXVF64GERPP_PMXVI16GER2_PMXVI16GER2S_PMXVI4GER8_PMXVI8GER4
  { 1, 309, 311, 4716, 4719 }, // 452 PMXVBF16GER2NN_PMXVBF16GER2NP_PMXVBF16GER2PN_PMXVBF16GER2PP_PMXVF16GER2NN_PMXVF16GER2NP_PMXVF16GER2PN_PMXVF16GER2PP_PMXVI16GER2PP_PMXVI16GER2SPP_PMXVI4GER8PP_PMXVI8GER4PP
  { 1, 309, 311, 4719, 4722 }, // 453 PMXVI8GER4SPP
  { 1, 309, 311, 4722, 4725 }, // 454 XXMTACC
  { 1, 309, 311, 4725, 4728 }, // 455 XXMFACC
  { 1, 311, 313, 4728, 4731 }, // 456 MULLD_MULLDO
  { 1, 309, 311, 4731, 4734 }, // 457 VMULHSD_VMULHUD_VMULLD
  { 1, 409, 411, 4734, 4737 }, // 458 VSPLTISW
  { 1, 309, 311, 4737, 4740 }, // 459 V_SETALLONES_V_SETALLONESB_V_SETALLONESH
  { 1, 309, 311, 4740, 4743 }, // 460 MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VPRTYBQ
  { 1, 309, 311, 4743, 4746 }, // 461 VGBBD_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW
  { 1, 409, 411, 4746, 4749 }, // 462 VSPLTISB_VSPLTISH_XXSPLTIB
  { 1, 309, 311, 4749, 4752 }, // 463 VSTRIBL_VSTRIBR_VSTRIHL_VSTRIHR
  { 1, 309, 311, 4752, 4755 }, // 464 XVCVBF16SPN
  { 1, 309, 311, 4755, 4758 }, // 465 VBPERMQ_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLO_VSLV_VSR_VSRO_VSRV_XXEXTRACTUW
  { 1, 309, 311, 4758, 4761 }, // 466 VCLRLB_VCLRRB_XXGENPCVDM_XXGENPCVHM_XXGENPCVWM
  { 1, 309, 311, 4761, 4764 }, // 467 VEXTRACTD_VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VINSERTD_VINSERTW
  { 1, 309, 311, 4764, 4767 }, // 468 VEXTDDVLX_VEXTDDVRX_VEXTDUBVLX_VEXTDUBVRX_VEXTDUHVLX_VEXTDUHVRX_VEXTDUWVLX_VEXTDUWVRX_VINSBLX_VINSBRX_VINSBVLX_VINSBVRX_VINSD_VINSDLX_VINSDRX_VINSHLX_VINSHRX_VINSHVLX_VINSHVRX_VINSW_VINSWLX_VINSWRX_VINSWVLX_VINSWVRX_VSLDBI_VSRDBI
  { 1, 309, 311, 4767, 4770 }, // 469 VSUMSWS
  { 1, 309, 311, 4770, 4773 }, // 470 XXSPLTIDP_XXSPLTIW
  { 1, 309, 311, 4773, 4776 }, // 471 XXBLENDVB_XXBLENDVD_XXBLENDVH_XXBLENDVW_XXSPLTI32DX
  { 1, 309, 311, 4776, 4779 }, // 472 XXEVAL
  { 1, 409, 411, 4779, 4782 }, // 473 XXPERMX
  { 0, 0, 0, 0, 0 }, // 474 DCBST_DCBZ
  { 0, 0, 0, 0, 0 }, // 475 ICBI
  { 0, 0, 0, 0, 0 }, // 476 DCBF
  { 1, 345, 347, 4782, 4785 }, // 477 PSTXVP_PSTXVPpc
  { 1, 323, 326, 4785, 4788 }, // 478 STB_STB8_STDBRX_STH_STH8_STHBRX_STW_STW8_STWBRX
  { 0, 0, 0, 0, 0 }, // 479 SPILLTOVSR_ST
  { 1, 398, 401, 0, 0 }, // 480 STD
  { 0, 0, 0, 0, 0 }, // 481 DFSTOREf32_DFSTOREf64_STIWX
  { 1, 401, 404, 4788, 4791 }, // 482 STXVRBX_STXVRDX_STXVRHX_STXVRWX
  { 0, 0, 0, 0, 0 }, // 483 SPILLTOVSR_STX
  { 1, 315, 317, 4791, 4794 }, // 484 EnforceIEIO
  { 1, 315, 317, 4794, 4797 }, // 485 STBCIX_STDCIX_STHCIX_STWCIX
  { 1, 345, 347, 4797, 4800 }, // 486 PSTB_PSTB8_PSTB8pc_PSTBpc_PSTD_PSTDpc_PSTFD_PSTFDpc_PSTFS_PSTFSpc_PSTH_PSTH8_PSTH8pc_PSTHpc_PSTW_PSTW8_PSTW8pc_PSTWpc_PSTXSD_PSTXSDpc_PSTXSSP_PSTXSSPpc_PSTXV_PSTXVpc
  { 1, 345, 347, 4800, 4803 }, // 487 STXVP_STXVPX
  { 1, 307, 309, 4803, 4806 }, // 488 ATTN_NAP
  { 0, 0, 0, 0, 0 }, // 489 DCBZL
  { 1, 315, 317, 4806, 4809 }, // 490 DCCCI_ICBLQ_ICCCI_TLBLD_TLBLI_TLBRE2_TLBSX2_TLBSX2D_TLBWE2
  { 1, 323, 326, 4809, 4812 }, // 491 ICBLC
  { 1, 307, 309, 4812, 4815 }, // 492 CLRBHRB
  { 1, 307, 309, 4815, 4818 }, // 493 MFBHRBE
  { 1, 345, 347, 4818, 4821 }, // 494 PADDI_PADDI8_PADDI8pc_PADDIpc
  { 1, 305, 307, 4821, 4824 }, // 495 PLI_PLI8
  { 1, 309, 311, 4824, 4827 }, // 496 VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS
  { 1, 309, 311, 4827, 4830 }, // 497 VMULESD_VMULEUD_VMULHSW_VMULHUW_VMULOSD_VMULOUD
  { 1, 309, 311, 4830, 4833 }, // 498 VMSUMCUD
  { 0, uint16_t(~0U), uint16_t(~0U), uint16_t(~0U), uint16_t(~0U) }// end marker
};

static const llvm::InstrItinerary P7Itineraries[] = {
  { 0, 0, 0, 0, 0 }, // 0 NoInstrModel
  { 0, 0, 0, 0, 0 }, // 1 IIC_LdStSync
  { 1, 411, 413, 4833, 4836 }, // 2 IIC_IntSimple
  { 1, 413, 415, 4836, 4839 }, // 3 IIC_IntGeneral
  { 1, 415, 417, 4839, 4842 }, // 4 IIC_BrB
  { 1, 417, 419, 4842, 4845 }, // 5 IIC_VecFP
  { 1, 413, 415, 4845, 4848 }, // 6 IIC_IntCompare
  { 0, 0, 0, 0, 0 }, // 7 IIC_SprABORT
  { 0, 0, 0, 0, 0 }, // 8 IIC_LdStCOPY
  { 0, 0, 0, 0, 0 }, // 9 IIC_LdStPASTE
  { 1, 419, 421, 4848, 4851 }, // 10 IIC_BrCR
  { 1, 421, 423, 4851, 4854 }, // 11 IIC_LdStLD
  { 0, 0, 0, 0, 0 }, // 12 IIC_LdStDCBF
  { 1, 421, 423, 4854, 4857 }, // 13 IIC_LdStLoad
  { 1, 423, 426, 4857, 4860 }, // 14 IIC_IntDivD
  { 1, 426, 429, 4860, 4863 }, // 15 IIC_IntDivW
  { 0, 0, 0, 0, 0 }, // 16 IIC_FPDGeneral
  { 1, 429, 431, 4863, 4866 }, // 17 IIC_FPAddSub
  { 1, 429, 431, 4866, 4869 }, // 18 IIC_FPDivD
  { 0, 0, 0, 0, 0 }, // 19 IIC_FPSGeneral
  { 1, 429, 431, 4869, 4872 }, // 20 IIC_FPCompare
  { 1, 429, 431, 4872, 4875 }, // 21 IIC_FPGeneral
  { 1, 431, 433, 4875, 4878 }, // 22 IIC_VecGeneral
  { 1, 431, 433, 4878, 4881 }, // 23 IIC_VecComplex
  { 1, 433, 436, 4881, 4884 }, // 24 IIC_LdStStore
  { 1, 413, 415, 4884, 4887 }, // 25 IIC_IntRotateDI
  { 1, 429, 431, 4887, 4890 }, // 26 IIC_FPDivS
  { 1, 429, 431, 4890, 4894 }, // 27 IIC_FPFused
  { 1, 429, 431, 4894, 4897 }, // 28 IIC_FPSqrtD
  { 1, 429, 431, 4897, 4900 }, // 29 IIC_FPSqrtS
  { 0, 0, 0, 0, 0 }, // 30 IIC_LdStICBI
  { 1, 436, 439, 4900, 4904 }, // 31 IIC_IntISEL
  { 0, 0, 0, 0, 0 }, // 32 IIC_SprISYNC
  { 1, 439, 444, 4904, 4907 }, // 33 IIC_LdStLWARX
  { 1, 444, 448, 4907, 4911 }, // 34 IIC_LdStLoadUpd
  { 1, 448, 455, 4911, 4915 }, // 35 IIC_LdStLoadUpdX
  { 1, 439, 444, 4915, 4918 }, // 36 IIC_LdStLDARX
  { 1, 444, 448, 4918, 4922 }, // 37 IIC_LdStLDU
  { 1, 448, 455, 4922, 4926 }, // 38 IIC_LdStLDUX
  { 1, 421, 423, 4926, 4929 }, // 39 IIC_LdStLFD
  { 1, 444, 448, 4929, 4933 }, // 40 IIC_LdStLFDU
  { 1, 444, 448, 4933, 4937 }, // 41 IIC_LdStLFDUX
  { 1, 455, 459, 4937, 4940 }, // 42 IIC_LdStLHA
  { 1, 459, 464, 4940, 4944 }, // 43 IIC_LdStLHAU
  { 1, 464, 472, 4944, 4948 }, // 44 IIC_LdStLHAUX
  { 1, 421, 423, 4948, 4951 }, // 45 IIC_LdStLMW
  { 0, 0, 0, 0, 0 }, // 46 IIC_LdStLQ
  { 0, 0, 0, 0, 0 }, // 47 IIC_LdStLQARX
  { 1, 455, 459, 4951, 4954 }, // 48 IIC_LdStLWA
  { 1, 413, 415, 4954, 4957 }, // 49 IIC_IntMulHD
  { 1, 415, 417, 4957, 4960 }, // 50 IIC_BrMCR
  { 1, 472, 478, 4960, 4962 }, // 51 IIC_BrMCRX
  { 1, 419, 421, 4962, 4964 }, // 52 IIC_SprMFCR
  { 0, 0, 0, 0, 0 }, // 53 IIC_SprMFSPR
  { 0, 0, 0, 0, 0 }, // 54 IIC_IntMFFS
  { 0, 0, 0, 0, 0 }, // 55 IIC_SprMFMSR
  { 1, 419, 421, 4964, 4966 }, // 56 IIC_SprMFCRF
  { 0, 0, 0, 0, 0 }, // 57 IIC_SprMFPMR
  { 0, 0, 0, 0, 0 }, // 58 IIC_SprMFSR
  { 0, 0, 0, 0, 0 }, // 59 IIC_SprMFTB
  { 0, 0, 0, 0, 0 }, // 60 IIC_SprMSGSYNC
  { 1, 478, 480, 4966, 4968 }, // 61 IIC_SprMTSPR
  { 0, 0, 0, 0, 0 }, // 62 IIC_IntMTFSB0
  { 0, 0, 0, 0, 0 }, // 63 IIC_SprMTMSR
  { 0, 0, 0, 0, 0 }, // 64 IIC_SprMTMSRD
  { 0, 0, 0, 0, 0 }, // 65 IIC_SprMTPMR
  { 0, 0, 0, 0, 0 }, // 66 IIC_SprMTSR
  { 1, 413, 415, 4968, 4971 }, // 67 IIC_IntMulHW
  { 1, 413, 415, 4971, 4974 }, // 68 IIC_IntMulHWU
  { 1, 413, 415, 4974, 4977 }, // 69 IIC_IntMulLI
  { 0, 0, 0, 0, 0 }, // 70 IIC_SprRFI
  { 0, 0, 0, 0, 0 }, // 71 IIC_IntRFID
  { 1, 413, 415, 4977, 4980 }, // 72 IIC_IntRotateD
  { 1, 413, 415, 4980, 4983 }, // 73 IIC_IntRotate
  { 0, 0, 0, 0, 0 }, // 74 IIC_SprSLBFEE
  { 0, 0, 0, 0, 0 }, // 75 IIC_SprSLBIA
  { 0, 0, 0, 0, 0 }, // 76 IIC_SprSLBIE
  { 0, 0, 0, 0, 0 }, // 77 IIC_SprSLBIEG
  { 0, 0, 0, 0, 0 }, // 78 IIC_SprSLBMFEE
  { 0, 0, 0, 0, 0 }, // 79 IIC_SprSLBMFEV
  { 0, 0, 0, 0, 0 }, // 80 IIC_SprSLBMTE
  { 0, 0, 0, 0, 0 }, // 81 IIC_SprSLBSYNC
  { 1, 413, 415, 4983, 4986 }, // 82 IIC_IntShift
  { 1, 439, 444, 4986, 4989 }, // 83 IIC_LdStSTWCX
  { 1, 459, 464, 4989, 4993 }, // 84 IIC_LdStSTU
  { 1, 480, 487, 4993, 4997 }, // 85 IIC_LdStSTUX
  { 1, 433, 436, 4997, 5000 }, // 86 IIC_LdStSTD
  { 1, 439, 444, 5000, 5003 }, // 87 IIC_LdStSTDCX
  { 1, 487, 490, 5003, 5006 }, // 88 IIC_LdStSTFD
  { 1, 490, 495, 5006, 5010 }, // 89 IIC_LdStSTFDU
  { 0, 0, 0, 0, 0 }, // 90 IIC_SprSTOP
  { 0, 0, 0, 0, 0 }, // 91 IIC_LdStSTQ
  { 0, 0, 0, 0, 0 }, // 92 IIC_LdStSTQCX
  { 1, 413, 415, 5010, 5012 }, // 93 IIC_IntTrapD
  { 0, 0, 0, 0, 0 }, // 94 IIC_SprTLBIA
  { 0, 0, 0, 0, 0 }, // 95 IIC_SprTLBIE
  { 0, 0, 0, 0, 0 }, // 96 IIC_SprTLBIEL
  { 0, 0, 0, 0, 0 }, // 97 IIC_SprTLBSYNC
  { 1, 413, 415, 5012, 5014 }, // 98 IIC_IntTrapW
  { 1, 417, 419, 5014, 5017 }, // 99 IIC_VecFPCompare
  { 1, 495, 497, 5017, 5020 }, // 100 IIC_VecPerm
  { 1, 431, 433, 5020, 5023 }, // 101 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VSLD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_VPOPCNTB_VPOPCNTH_VSRAD_MTVSRDD_VEQV_VNAND_VNEGD_VNEGW_VORC_XXLAND_XXLANDC_XXLEQV_XXLEQVOnes_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 1, 417, 419, 5023, 5026 }, // 102 VAND_VANDC_V_SET0_V_SET0B_V_SET0H_VSLB_VSLH_VSLW_VSRB_VSRH_VSRW_VRLB_VRLD_VRLH_VRLW_VSRAB_VSRAH_VSRAW_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP_XVXEXPDP_XVXEXPSP_VRLDMI_VRLDNM_VRLWMI_VRLWNM_VMRGEW_VMRGOW_VNOR_VOR_VSEL_VXOR_XVNEGDP_XVNEGSP_XSABSQP_XSCPSGNQP_XSIEXPQP_XSNABSQP_XSNEGQP_XSXEXPQP
  { 1, 495, 497, 5026, 5029 }, // 103 XXSEL
  { 1, 478, 480, 5029, 5031 }, // 104 TABORTDC_TABORTDCI_TABORTWC_TABORTWCI
  { 0, 0, 0, 0, 0 }, // 105 MTFSB0_MTFSB1
  { 0, 0, 0, 0, 0 }, // 106 MFFSCDRN_MFFSCDRNI_MFFSCRN_MFFSCRNI
  { 1, 413, 415, 5031, 5034 }, // 107 CMPRB_CMPRB8_CMPEQB
  { 1, 413, 415, 5034, 5036 }, // 108 TD_TDI
  { 1, 413, 415, 5036, 5038 }, // 109 TW_TWI
  { 1, 429, 431, 5038, 5041 }, // 110 FCMPOD_FCMPOS_FCMPUD_FCMPUS_FTDIV_FTSQRT
  { 1, 417, 419, 5041, 5044 }, // 111 XSTSTDCDP_XSTSTDCSP
  { 1, 417, 419, 5044, 5047 }, // 112 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP_XSXSIGDP_XSCVSPDPN
  { 1, 429, 431, 5047, 5050 }, // 113 XSCMPEQDP_XSCMPEXPDP_XSCMPGEDP_XSCMPGTDP_XSCMPODP_XSCMPUDP_XSTDIVDP_XSTSQRTDP
  { 1, 413, 415, 5050, 5053 }, // 114 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW_CMPB_CMPB8_SETB_SETB8_BPERMD
  { 1, 413, 415, 5053, 5056 }, // 115 SLD_SRD_SRAD
  { 1, 413, 415, 5056, 5059 }, // 116 SRADI_EXTSWSLI_32_64_EXTSWSLI_SRADI_32_RLDIC
  { 1, 431, 433, 5059, 5062 }, // 117 MFVRD_MFVSRD_MTVRD_MTVSRD_MTVRWA_MTVRWZ_MTVSRWA_MTVSRWZ_MFVSRWZ_MFVRWZ
  { 1, 413, 415, 5062, 5065 }, // 118 CMPLW_CMPLWI_CMPW_CMPWI_CMPD_CMPDI_CMPLD_CMPLDI
  { 1, 413, 415, 5065, 5068 }, // 119 SUBFC_SUBFC8_SUBFC8O_SUBFCO_SUBFIC_SUBFIC8_ANDI8_rec_ANDIS8_rec_ANDIS_rec_ANDI_rec_ADDC_ADDC8_ADDC8O_ADDCO_ADDIC_ADDIC8_ADDIC_rec_ADDE_ADDE8_ADDE8O_ADDE8O_rec_ADDE8_rec_ADDEO_ADDEO_rec_ADDE_rec_ADDME_ADDME8_ADDME8O_ADDME8O_rec_ADDME8_rec_ADDMEO_ADDMEO_rec_ADDME_rec_ADDZE_ADDZE8_ADDZE8O_ADDZE8O_rec_ADDZE8_rec_ADDZEO_ADDZEO_rec_ADDZE_rec_SUBF_SUBF8_SUBF8O_SUBF8O_rec_SUBF8_rec_SUBFE_SUBFE8_SUBFE8O_SUBFE8O_rec_SUBFE8_rec_SUBFEO_SUBFEO_rec_SUBFE_rec_SUBFME_SUBFME8_SUBFME8O_SUBFME8O_rec_SUBFME8_rec_SUBFMEO_SUBFMEO_rec_SUBFME_rec_SUBFO_SUBFO_rec_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZE8O_rec_SUBFZE8_rec_SUBFZEO_SUBFZEO_rec_SUBFZE_rec_SUBF_rec_POPCNTB_POPCNTB8_LA_LA8
  { 1, 411, 413, 5068, 5071 }, // 120 ADD4_ADD4O_ADD4O_rec_ADD4_rec_ADD8_ADD8O_ADD8O_rec_ADD8_rec_NEG_NEG8_NEG8O_NEG8O_rec_NEG8_rec_NEGO_NEGO_rec_NEG_rec_ADDI_ADDI8_ADDIS_ADDIS8_LI_LI8_LIS_LIS8_OR_OR8_OR8_rec_ORI_ORI8_ORIS_ORIS8_OR_rec_XOR_XOR8_XOR8_rec_XORI_XORI8_XORIS_XORIS8_XOR_rec_NAND_NAND8_NAND8_rec_NAND_rec_AND_AND8_AND8_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_AND_rec_NOR_NOR8_NOR8_rec_NOR_rec_ORC_ORC8_ORC8_rec_ORC_rec_EQV_EQV8_EQV8_rec_EQV_rec_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_ADD4TLS_ADD8TLS_ADD8TLS__NOP
  { 0, 0, 0, 0, 0 }, // 121 ADDIStocHA_ADDIStocHA8_ADDItocL_COPY
  { 1, 415, 417, 5071, 5074 }, // 122 MCRF
  { 1, 472, 478, 5074, 5076 }, // 123 MCRXRX
  { 1, 417, 419, 5076, 5079 }, // 124 XSNABSDP_XSXEXPDP_XSABSDP_XSNEGDP_XSCPSGNDP
  { 1, 415, 417, 5079, 5082 }, // 125 RFEBB
  { 1, 478, 480, 5082, 5084 }, // 126 TBEGIN_TRECHKPT
  { 1, 421, 423, 5084, 5087 }, // 127 WAIT
  { 1, 413, 415, 5087, 5090 }, // 128 RLDCL_RLDCR
  { 1, 413, 415, 5090, 5093 }, // 129 RLWIMI_RLWIMI8
  { 1, 413, 415, 5093, 5096 }, // 130 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32_RLDIMI
  { 1, 419, 421, 5096, 5098 }, // 131 MFOCRF_MFOCRF8
  { 1, 472, 478, 5098, 5100 }, // 132 MTOCRF_MTOCRF8
  { 1, 419, 421, 5100, 5103 }, // 133 CR6SET_CR6UNSET_CRSET_CRUNSET_CRAND_CRANDC_CRNAND_CRNOR_CROR_CRORC_CREQV_CRXOR
  { 1, 413, 415, 5103, 5106 }, // 134 SLW_SLW8_SRW_SRW8_RLWINM_RLWINM8_RLWNM_RLWNM8
  { 1, 429, 431, 5106, 5109 }, // 135 FABSD_FABSS_FNABSD_FNABSS_FNEGD_FNEGS_FCPSGND_FCPSGNS_FMR
  { 1, 413, 415, 5109, 5112 }, // 136 SRAW_SRAWI
  { 1, 436, 439, 5112, 5116 }, // 137 ISEL_ISEL8
  { 1, 417, 419, 5116, 5119 }, // 138 XSIEXPDP
  { 1, 478, 480, 5119, 5121 }, // 139 TRECLAIM_TSR_TABORT
  { 1, 433, 436, 5121, 5124 }, // 140 MFVSCR
  { 1, 421, 423, 5124, 5127 }, // 141 MTVSCR
  { 1, 417, 419, 5127, 5130 }, // 142 VCMPNEZB_VCMPNEZH_VCMPNEZW_VCMPEQUB_VCMPEQUD_VCMPEQUH_VCMPEQUW_VCMPNEB_VCMPNEH_VCMPNEW_VCMPEQFP_VCMPEQFP_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPBFP_VCMPBFP_rec_VCMPGTSB_VCMPGTSB_rec_VCMPGTSD_VCMPGTSD_rec_VCMPGTSH_VCMPGTSH_rec_VCMPGTSW_VCMPGTSW_rec_VCMPGTUB_VCMPGTUB_rec_VCMPGTUD_VCMPGTUD_rec_VCMPGTUH_VCMPGTUH_rec_VCMPGTUW_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 1, 431, 433, 5130, 5133 }, // 143 VABSDUB_VABSDUH_VABSDUW_VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTW_VPOPCNTD_VPRTYBD_VPRTYBW
  { 1, 417, 419, 5133, 5136 }, // 144 VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VADDSBS_VADDSHS_VADDSWS_VMAXFP_VMINFP_VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW_VBPERMD_VADDCUW_VSHASIGMAD_VSHASIGMAW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_VSUBCUW_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP_XVXSIGDP_XVXSIGSP
  { 1, 429, 431, 5136, 5139 }, // 145 XVTDIVDP_XVTDIVSP_XVTSQRTDP_XVTSQRTSP
  { 1, 417, 419, 5139, 5142 }, // 146 VADDFP_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VEXPTEFP_VLOGEFP_VMADDFP_VMHADDSHS_VNMSUBFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVADDDP_XVADDSP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVHPSP_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVMULDP_XVMULSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP_XVSUBDP_XVSUBSP_VCFSX_VCFSX_0_VCFUX_VCFUX_0_VMHRADDSHS_VMLADDUHM_VMSUMMBM_VMSUMSHM_VMSUMSHS_VMSUMUBM_VMSUMUHM_VMSUMUDM_VMSUMUHS_VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS_VSUMSWS
  { 1, 431, 433, 5142, 5145 }, // 147 VSUBFP_VMULUWM
  { 1, 413, 415, 5145, 5148 }, // 148 MADDHD_MADDHDU_MADDLD_MADDLD8_MULLD_MULLDO
  { 1, 413, 415, 5148, 5151 }, // 149 MULHD_MULHW_MULLW_MULLWO
  { 1, 413, 415, 5151, 5154 }, // 150 MULHDU_MULHWU
  { 1, 413, 415, 5154, 5157 }, // 151 MULLI_MULLI8
  { 1, 429, 431, 5157, 5160 }, // 152 FRSP_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRE_FRES_FADDS_FMSUBS_FMADDS_FSUBS_FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRSQRTE_FRSQRTES_FNMADDS_FNMSUBS_FSELD_FSELS_FMULS
  { 1, 429, 431, 5160, 5163 }, // 153 FADD_FSUB
  { 1, 429, 431, 5163, 5167 }, // 154 FMSUB_FMADD_FNMADD_FNMSUB_FMUL
  { 1, 417, 419, 5167, 5170 }, // 155 XSMADDADP_XSMADDASP_XSMADDMDP_XSMADDMSP_XSMSUBADP_XSMSUBASP_XSMSUBMDP_XSMSUBMSP_XSMULDP_XSMULSP_XSNMADDADP_XSNMADDASP_XSNMADDMDP_XSNMADDMSP_XSNMSUBADP_XSNMSUBASP_XSNMSUBMDP_XSNMSUBMSP
  { 1, 429, 431, 5170, 5173 }, // 156 FSELD_rec_FSELS_rec
  { 1, 413, 415, 5173, 5176 }, // 157 MULHDU_rec_MULHWU_rec
  { 1, 413, 415, 5176, 5179 }, // 158 MULHD_rec_MULHW_rec_MULLWO_rec_MULLW_rec
  { 1, 413, 415, 5179, 5182 }, // 159 MULLDO_rec_MULLD_rec
  { 1, 429, 431, 5182, 5185 }, // 160 FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRES_rec_FRE_rec_FADDS_rec_FSUBS_rec_FMSUBS_rec_FNMSUBS_rec_FMADDS_rec_FNMADDS_rec_FCFIDS_rec_FCFIDUS_rec_FCFIDU_rec_FCFID_rec_FCTIDUZ_rec_FCTIDU_rec_FCTIDZ_rec_FCTID_rec_FCTIWUZ_rec_FCTIWU_rec_FCTIWZ_rec_FCTIW_rec_FMULS_rec_FRSQRTES_rec_FRSQRTE_rec_FRSP_rec
  { 1, 429, 431, 5185, 5188 }, // 161 FADD_rec_FSUB_rec
  { 1, 429, 431, 5188, 5192 }, // 162 FMSUB_rec_FNMSUB_rec_FMADD_rec_FNMADD_rec_FMUL_rec
  { 1, 417, 419, 5192, 5195 }, // 163 XSADDDP_XSADDSP_XSCVDPHP_XSCVDPSP_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPSXWSs_XSCVDPUXWSs_XSCVHPDP_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSQRTEDP_XSRSQRTESP_XSSUBDP_XSSUBSP_XSCVDPSPN_XSRSP
  { 1, 421, 423, 5195, 5198 }, // 164 LVSL_LVSR
  { 1, 495, 497, 5198, 5201 }, // 165 VSPLTISB_VSPLTISH_VSPLTISW_VSPLTB_VSPLTBs_VSPLTH_VSPLTHs_VSPLTW_XXMRGHW_XXMRGLW_XXPERM_XXPERMR_XXSLDWI_XXSLDWIs_XXSPLTIB_XXSPLTW_XXSPLTWs_XXPERMDI_XXPERMDIs
  { 1, 417, 419, 5201, 5204 }, // 166 V_SETALLONES_V_SETALLONESB_V_SETALLONESH_VBPERMQ_VGBBD_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPERM_VPERMR_VPERMXOR_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLDOI_VSLO_VSLV_VSR_VSRO_VSRV_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW_XXEXTRACTUW_XXINSERTW_VADDCUQ_VADDECUQ_VADDEUQM_VMUL10CUQ_VMUL10ECUQ_VMUL10EUQ_VMUL10UQ_VSUBCUQ_VSUBECUQ_VSUBEUQM_XSTSTDCQP_XSXSIGQP_BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDS_rec_BCDTRUNC_rec_BCDUS_rec_BCDUTRUNC_rec_BCDADD_rec_BCDSUB_rec
  { 1, 431, 433, 5204, 5207 }, // 167 VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VINSERTB_VINSERTD_VINSERTH_VINSERTW_MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VEXTRACTD_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VPRTYBQ_VADDUQM_VSUBUQM
  { 1, 429, 431, 5207, 5210 }, // 168 XSCMPEXPQP_XSCMPOQP_XSCMPUQP
  { 1, 417, 419, 5210, 5213 }, // 169 BCDSR_rec_XSADDQP_XSADDQPO_XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP_XSRQPI_XSRQPIX_XSRQPXP_XSSUBQP_XSSUBQPO
  { 1, 417, 419, 5213, 5216 }, // 170 BCDCTSQ_rec
  { 1, 417, 419, 5216, 5219 }, // 171 XSMADDQP_XSMADDQPO_XSMSUBQP_XSMSUBQPO_XSMULQP_XSMULQPO_XSNMADDQP_XSNMADDQPO_XSNMSUBQP_XSNMSUBQPO
  { 1, 417, 419, 5219, 5222 }, // 172 BCDCFSQ_rec
  { 1, 417, 419, 5222, 5225 }, // 173 XSDIVQP_XSDIVQPO
  { 1, 417, 419, 5225, 5228 }, // 174 XSSQRTQP_XSSQRTQPO
  { 1, 421, 423, 5228, 5231 }, // 175 LXVL_LXVLL
  { 1, 421, 423, 5231, 5234 }, // 176 LVEBX_LVEHX_LVEWX_LVX_LVXL
  { 1, 421, 423, 5234, 5237 }, // 177 LXSIBZX_LXSIHZX_LXSDX_LXVB16X_LXVD2X_LXVWSX_LXSIWZX_LXV_LXVX_LXSD
  { 0, 0, 0, 0, 0 }, // 178 DFLOADf64_XFLOADf64_LIWZX
  { 0, 0, 0, 0, 0 }, // 179 DCBF_DCBFEP_DCBST_DCBSTEP_DCBT_DCBTEP_DCBZ_DCBZEP_DCBZL_DCBZLEP_DCBTST_DCBTSTEP
  { 0, 0, 0, 0, 0 }, // 180 CP_COPY_CP_COPY8
  { 0, 0, 0, 0, 0 }, // 181 ICBI_ICBIEP
  { 1, 421, 423, 5237, 5240 }, // 182 ICBT_ICBTLS_LBZ_LBZ8_LBZCIX_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LDBRX_LDCIX_LHBRX_LHBRX8_LHZ_LHZ8_LHZCIX_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWBRX_LWBRX8_LWZ_LWZ8_LWZCIX_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32_EnforceIEIO_LSWI
  { 1, 439, 444, 5240, 5243 }, // 183 LBARX_LBARXL_LHARX_LHARXL_LWARX_LWARXL
  { 1, 421, 423, 5243, 5246 }, // 184 LD_LDX_LDXTLS_LDXTLS__DARN
  { 1, 439, 444, 5246, 5249 }, // 185 LDARX_LDARXL
  { 0, 0, 0, 0, 0 }, // 186 CP_ABORT
  { 0, 0, 0, 0, 0 }, // 187 ISYNC
  { 0, 0, 0, 0, 0 }, // 188 MSGSYNC
  { 0, 0, 0, 0, 0 }, // 189 TLBSYNC
  { 0, 0, 0, 0, 0 }, // 190 SYNC
  { 1, 421, 423, 5249, 5252 }, // 191 LMW
  { 1, 421, 423, 5252, 5255 }, // 192 LFIWZX_LFDX_LFD
  { 0, 0, 0, 0, 0 }, // 193 SLBIA
  { 0, 0, 0, 0, 0 }, // 194 SLBIE
  { 0, 0, 0, 0, 0 }, // 195 SLBMFEE
  { 0, 0, 0, 0, 0 }, // 196 SLBMFEV
  { 0, 0, 0, 0, 0 }, // 197 SLBMTE
  { 0, 0, 0, 0, 0 }, // 198 TLBIEL
  { 1, 444, 448, 5255, 5259 }, // 199 LHZU_LHZU8_LWZU_LWZU8
  { 1, 448, 455, 5259, 5263 }, // 200 LHZUX_LHZUX8_LWZUX_LWZUX8
  { 1, 478, 480, 5263, 5265 }, // 201 TEND
  { 1, 439, 444, 5265, 5268 }, // 202 STBCX_STHCX_STWCX
  { 1, 439, 444, 5268, 5271 }, // 203 STDCX
  { 1, 421, 423, 5271, 5274 }, // 204 LDMX
  { 1, 455, 459, 5274, 5277 }, // 205 LHA_LHA8_LHAX_LHAX8_LWAX_LWAX_32
  { 0, 0, 0, 0, 0 }, // 206 CP_PASTE8_rec_CP_PASTE_rec
  { 1, 455, 459, 5277, 5280 }, // 207 LWA_LWA_32
  { 1, 478, 480, 5280, 5282 }, // 208 TCHECK
  { 1, 421, 423, 5282, 5285 }, // 209 LFIWAX
  { 1, 421, 423, 5285, 5288 }, // 210 LXSIWAX
  { 0, 0, 0, 0, 0 }, // 211 LIWAX
  { 1, 421, 423, 5288, 5291 }, // 212 LFSX_LFS
  { 1, 421, 423, 5291, 5294 }, // 213 LXSSP_LXSSPX
  { 0, 0, 0, 0, 0 }, // 214 XFLOADf32_DFLOADf32
  { 1, 459, 464, 5294, 5298 }, // 215 LHAU_LHAU8
  { 1, 464, 472, 5298, 5302 }, // 216 LHAUX_LHAUX8_LWAUX
  { 1, 421, 423, 5302, 5305 }, // 217 LXVH8X_LXVDSX_LXVW4X
  { 1, 487, 490, 5305, 5308 }, // 218 STFD_STFDX_STFIWX_STFS_STFSX_STXSD_STXSDX_STXSIBX_STXSIBXv_STXSIHX_STXSIHXv_STXSIWX_STXSSP_STXSSPX
  { 1, 433, 436, 5308, 5311 }, // 219 STW_STW8_STDBRX_STHBRX_STWBRX_STB_STB8_STH_STH8_STBX_STBX8_STBXTLS_STBXTLS__STBXTLS_32_STHX_STHX8_STHXTLS_STHXTLS__STHXTLS_32_STWX_STWX8_STWXTLS_STWXTLS__STWXTLS_32
  { 0, 0, 0, 0, 0 }, // 220 DFSTOREf32_DFSTOREf64_XFSTOREf32_XFSTOREf64_STIWX
  { 1, 433, 436, 5311, 5314 }, // 221 STD_STDX_STDXTLS_STDXTLS_
  { 1, 421, 423, 5314, 5317 }, // 222 STBCIX_STDCIX_STHCIX_STWCIX_STSWI
  { 0, 0, 0, 0, 0 }, // 223 SLBIEG
  { 1, 421, 423, 5317, 5320 }, // 224 STMW
  { 0, 0, 0, 0, 0 }, // 225 TLBIE
  { 1, 433, 436, 5320, 5323 }, // 226 STVEBX_STVEHX_STVEWX_STVX_STVXL
  { 1, 487, 490, 5323, 5326 }, // 227 STXV_STXVB16X_STXVD2X_STXVH8X_STXVW4X_STXVX
  { 1, 421, 423, 5326, 5329 }, // 228 STXVL_STXVLL
  { 1, 478, 480, 5329, 5331 }, // 229 MTCTR_MTCTR8_MTCTR8loop_MTCTRloop_MTLR_MTLR8
  { 1, 413, 415, 5331, 5334 }, // 230 MFVRSAVE_MFVRSAVEv_MTVRSAVE_MTVRSAVEv
  { 0, 0, 0, 0, 0 }, // 231 MFPMR
  { 0, 0, 0, 0, 0 }, // 232 MTPMR
  { 0, 0, 0, 0, 0 }, // 233 MFTB_MFTB8
  { 0, 0, 0, 0, 0 }, // 234 MFCTR_MFCTR8_MFLR_MFLR8_MFSPR_MFSPR8
  { 0, 0, 0, 0, 0 }, // 235 MFMSR
  { 0, 0, 0, 0, 0 }, // 236 MTMSR
  { 0, 0, 0, 0, 0 }, // 237 MTMSRD
  { 1, 478, 480, 5334, 5336 }, // 238 MTSPR_MTSPR8
  { 1, 426, 429, 5336, 5339 }, // 239 DIVW_DIVWO_DIVWU_DIVWUO_MODSW
  { 1, 426, 429, 5339, 5342 }, // 240 DIVWE_DIVWEO_DIVWEU_DIVWEUO_MODSD_MODUD_MODUW
  { 1, 423, 426, 5342, 5345 }, // 241 DIVD_DIVDO_DIVDU_DIVDUO
  { 1, 423, 426, 5345, 5348 }, // 242 DIVDE_DIVDEO_DIVDEU_DIVDEUO
  { 1, 426, 429, 5348, 5351 }, // 243 DIVWO_rec_DIVWUO_rec_DIVWU_rec_DIVW_rec
  { 1, 423, 426, 5351, 5354 }, // 244 DIVD_rec_DIVDO_rec_DIVDU_rec_DIVDUO_rec
  { 1, 426, 429, 5354, 5357 }, // 245 DIVWE_rec_DIVWEO_rec_DIVWEU_rec_DIVWEUO_rec
  { 1, 423, 426, 5357, 5360 }, // 246 DIVDE_rec_DIVDEO_rec_DIVDEU_rec_DIVDEUO_rec
  { 1, 472, 478, 5360, 5362 }, // 247 MTCRF_MTCRF8
  { 1, 413, 415, 5362, 5365 }, // 248 ADDC8O_rec_ADDC8_rec_ADDCO_rec_ADDC_rec_SUBFC8O_rec_SUBFC8_rec_SUBFCO_rec_SUBFC_rec
  { 1, 429, 431, 5365, 5368 }, // 249 FABSD_rec_FABSS_rec_FNABSD_rec_FNABSS_rec_FCPSGND_rec_FCPSGNS_rec_FNEGD_rec_FNEGS_rec_FMR_rec
  { 1, 415, 417, 5368, 5371 }, // 250 MCRFS
  { 0, 0, 0, 0, 0 }, // 251 MTFSF_MTFSF_rec_MTFSFI_MTFSFI_rec_MTFSFIb
  { 0, 0, 0, 0, 0 }, // 252 MTFSFb
  { 1, 413, 415, 5371, 5374 }, // 253 RLDCL_rec_RLDCR_rec
  { 1, 413, 415, 5374, 5377 }, // 254 RLDICL_rec_RLDICR_rec_RLDICL_32_rec_RLDIMI_rec
  { 1, 413, 415, 5377, 5380 }, // 255 RLWIMI8_rec_RLWIMI_rec
  { 1, 413, 415, 5380, 5383 }, // 256 RLWINM8_rec_RLWINM_rec_RLWNM8_rec_RLWNM_rec_SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 1, 413, 415, 5383, 5386 }, // 257 SRAWI_rec_SRAW_rec
  { 0, 0, 0, 0, 0 }, // 258 MFFS_MFFSCE_MFFSL_MFFS_rec
  { 1, 419, 421, 5386, 5388 }, // 259 MFCR_MFCR8
  { 1, 413, 415, 5388, 5391 }, // 260 EXTSWSLI_32_64_rec_SRADI_rec_EXTSWSLI_rec_RLDIC_rec
  { 1, 413, 415, 5391, 5394 }, // 261 SRAD_rec_SLD_rec_SRD_rec
  { 1, 429, 431, 5394, 5397 }, // 262 FDIV
  { 1, 429, 431, 5397, 5400 }, // 263 FDIV_rec
  { 1, 429, 431, 5400, 5403 }, // 264 XSSQRTDP
  { 1, 429, 431, 5403, 5406 }, // 265 FSQRT
  { 1, 429, 431, 5406, 5409 }, // 266 XVSQRTDP
  { 1, 429, 431, 5409, 5412 }, // 267 XVSQRTSP
  { 1, 429, 431, 5412, 5415 }, // 268 FSQRT_rec
  { 1, 429, 431, 5415, 5418 }, // 269 XSSQRTSP
  { 1, 429, 431, 5418, 5421 }, // 270 FSQRTS
  { 1, 429, 431, 5421, 5424 }, // 271 FSQRTS_rec
  { 1, 429, 431, 5424, 5427 }, // 272 XSDIVDP
  { 1, 429, 431, 5427, 5430 }, // 273 FDIVS
  { 1, 429, 431, 5430, 5433 }, // 274 FDIVS_rec
  { 1, 429, 431, 5433, 5436 }, // 275 XSDIVSP
  { 1, 429, 431, 5436, 5439 }, // 276 XVDIVSP
  { 1, 429, 431, 5439, 5442 }, // 277 XVDIVDP
  { 1, 444, 448, 5442, 5446 }, // 278 LFSU
  { 1, 444, 448, 5446, 5450 }, // 279 LFSUX
  { 1, 490, 495, 5450, 5454 }, // 280 STFDU_STFDUX_STFSU_STFSUX
  { 1, 459, 464, 5454, 5458 }, // 281 STBU_STBU8_STDU_STHU_STHU8_STWU_STWU8
  { 1, 480, 487, 5458, 5462 }, // 282 STBUX_STBUX8_STDUX_STHUX_STHUX8_STWUX_STWUX8
  { 1, 444, 448, 5462, 5466 }, // 283 LBZU_LBZU8
  { 1, 448, 455, 5466, 5470 }, // 284 LBZUX_LBZUX8
  { 1, 444, 448, 5470, 5474 }, // 285 LDU
  { 1, 448, 455, 5474, 5478 }, // 286 LDUX
  { 1, 444, 448, 5478, 5482 }, // 287 LFDU
  { 1, 444, 448, 5482, 5486 }, // 288 LFDUX
  { 1, 417, 419, 5486, 5489 }, // 289 VPMSUMB_VPMSUMD_VPMSUMH_VPMSUMW_VCIPHER_VCIPHERLAST_VNCIPHER_VNCIPHERLAST_VSBOX
  { 1, 415, 417, 5489, 5492 }, // 290 BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_BCCTR_BCCTR8_BCCTR8n_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_BCCTRn_BDNZ_BDNZ8_BDNZA_BDNZAm_BDNZAp_BDNZm_BDNZp_BDZ_BDZ8_BDZA_BDZAm_BDZAp_BDZm_BDZp_BDNZL_BDNZLA_BDNZLAm_BDNZLAp_BDNZLR_BDNZLR8_BDNZLRL_BDNZLRLm_BDNZLRLp_BDNZLRm_BDNZLRp_BDNZLm_BDNZLp_BDZL_BDZLA_BDZLAm_BDZLAp_BDZLR_BDZLR8_BDZLRL_BDZLRLm_BDZLRLp_BDZLRm_BDZLRp_BDZLm_BDZLp_BL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM_BLR_BLR8_BLRL_TAILB_TAILB8_TAILBA_TAILBA8_TAILBCTR_TAILBCTR8_gBC_gBCA_gBCAat_gBCCTR_gBCCTRL_gBCL_gBCLA_gBCLAat_gBCLR_gBCLRL_gBCLat_gBCat_BCLR_BCLRL_BCLRLn_BCLRn_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_RM_BCTRL_RM_B_BA_BC_BCC_BCCA_BCL_BCLalways_BCLn_BCTRL8_LDinto_toc_BCTRL_LWZinto_toc_BCTRL8_LDinto_toc_RM_BCTRL_LWZinto_toc_RM_BCn_CTRL_DEP
  { 1, 415, 417, 5492, 5495 }, // 291 ADDPCIS
  { 1, 421, 423, 5495, 5498 }, // 292 LDAT_LWAT
  { 1, 433, 436, 5498, 5501 }, // 293 STDAT_STWAT
  { 1, 411, 413, 5501, 5504 }, // 294 BRINC
  { 1, 431, 433, 5504, 5507 }, // 295 EVABS_EVEQV_EVNAND_EVNEG_EVADDIW_EVADDW_EVAND_EVANDC_EVCMPEQ_EVCMPGTS_EVCMPGTU_EVCMPLTS_EVCMPLTU_EVCNTLSW_EVCNTLZW_EVEXTSB_EVEXTSH_EVMERGEHI_EVMERGEHILO_EVMERGELO_EVMERGELOHI_EVNOR_EVOR_EVORC_EVXOR_EVRLW_EVRLWI_EVRNDW_EVSLW_EVSLWI_EVSPLATFI_EVSPLATI_EVSRWIS_EVSRWIU_EVSRWS_EVSRWU_EVSUBFW_EVSUBIFW
  { 1, 431, 433, 5507, 5510 }, // 296 EVMRA_EVADDSMIAAW_EVADDSSIAAW_EVADDUMIAAW_EVADDUSIAAW_EVDIVWS_EVDIVWU_EVMHEGSMFAA_EVMHEGSMFAN_EVMHEGSMIAA_EVMHEGSMIAN_EVMHEGUMIAA_EVMHEGUMIAN_EVMHESMF_EVMHESMFA_EVMHESMFAAW_EVMHESMFANW_EVMHESMI_EVMHESMIA_EVMHESMIAAW_EVMHESMIANW_EVMHESSF_EVMHESSFA_EVMHESSFAAW_EVMHESSFANW_EVMHESSIAAW_EVMHESSIANW_EVMHEUMI_EVMHEUMIA_EVMHEUMIAAW_EVMHEUMIANW_EVMHEUSIAAW_EVMHEUSIANW_EVMHOGSMFAA_EVMHOGSMFAN_EVMHOGSMIAA_EVMHOGSMIAN_EVMHOGUMIAA_EVMHOGUMIAN_EVMHOSMF_EVMHOSMFA_EVMHOSMFAAW_EVMHOSMFANW_EVMHOSMI_EVMHOSMIA_EVMHOSMIAAW_EVMHOSMIANW_EVMHOSSF_EVMHOSSFA_EVMHOSSFAAW_EVMHOSSFANW_EVMHOSSIAAW_EVMHOSSIANW_EVMHOUMI_EVMHOUMIA_EVMHOUMIAAW_EVMHOUMIANW_EVMHOUSIAAW_EVMHOUSIANW_EVMWHSMF_EVMWHSMFA_EVMWHSMI_EVMWHSMIA_EVMWHSSF_EVMWHSSFA_EVMWHUMI_EVMWHUMIA_EVMWLSMIAAW_EVMWLSMIANW_EVMWLSSIAAW_EVMWLSSIANW_EVMWLUMI_EVMWLUMIA_EVMWLUMIAAW_EVMWLUMIANW_EVMWLUSIAAW_EVMWLUSIANW_EVMWSMF_EVMWSMFA_EVMWSMFAA_EVMWSMFAN_EVMWSMI_EVMWSMIA_EVMWSMIAA_EVMWSMIAN_EVMWSSF_EVMWSSFA_EVMWSSFAA_EVMWSSFAN_EVMWUMI_EVMWUMIA_EVMWUMIAA_EVMWUMIAN_EVSUBFSMIAAW_EVSUBFSSIAAW_EVSUBFUMIAAW_EVSUBFUSIAAW
  { 1, 421, 423, 5510, 5513 }, // 297 EVLDD_EVLDDX_EVLDH_EVLDHX_EVLDW_EVLDWX_EVLHHESPLAT_EVLHHESPLATX_EVLHHOSSPLAT_EVLHHOSSPLATX_EVLHHOUSPLAT_EVLHHOUSPLATX_EVLWHE_EVLWHEX_EVLWHOS_EVLWHOSX_EVLWHOU_EVLWHOUX_EVLWHSPLAT_EVLWHSPLATX_EVLWWSPLAT_EVLWWSPLATX
  { 1, 433, 436, 5513, 5516 }, // 298 EVSTDD_EVSTDDX_EVSTDH_EVSTDHX_EVSTDW_EVSTDWX_EVSTWHE_EVSTWHEX_EVSTWHO_EVSTWHOX_EVSTWWE_EVSTWWEX_EVSTWWO_EVSTWWOX
  { 1, 415, 417, 5516, 5519 }, // 299 HRFID_ATTN_CLRBHRB_MFBHRBE_NAP_RFCI_RFDI_RFMCI_SC
  { 0, 0, 0, 0, 0 }, // 300 RFI
  { 0, 0, 0, 0, 0 }, // 301 RFID
  { 1, 421, 423, 5519, 5522 }, // 302 DSS_DSSALL_DST_DST64_DSTST_DSTST64_DSTSTT_DSTSTT64_DSTT_DSTT64_ICBLQ_LBEPX_LHEPX_LWEPX_TLBIVAX_TLBLD_TLBLI_TLBRE_TLBRE2_TLBSX_TLBSX2_TLBSX2D_TLBWE_TLBWE2_MBAR_TRAP_DCCCI_ICCCI
  { 1, 433, 436, 5522, 5525 }, // 303 ICBLC_STBEPX_STHEPX_STWEPX
  { 1, 421, 423, 5525, 5528 }, // 304 LFDEPX
  { 1, 487, 490, 5528, 5531 }, // 305 STFDEPX
  { 0, 0, 0, 0, 0 }, // 306 MFSR_MFSRIN
  { 0, 0, 0, 0, 0 }, // 307 MTSR_MTSRIN
  { 0, 0, 0, 0, 0 }, // 308 MFDCR
  { 1, 478, 480, 5531, 5533 }, // 309 MTDCR
  { 1, 411, 413, 5533, 5536 }, // 310 NOP_GT_PWR6_NOP_GT_PWR7
  { 0, 0, 0, 0, 0 }, // 311 TLBIA
  { 0, 0, 0, 0, 0 }, // 312 WRTEE_WRTEEI
  { 1, 413, 415, 5536, 5539 }, // 313 HASHCHK_HASHCHK8_HASHCHKP_HASHCHKP8_HASHST_HASHST8_HASHSTP_HASHSTP8_ADDEX_ADDEX8
  { 0, 0, 0, 0, 0 }, // 314 MSYNC
  { 0, 0, 0, 0, 0 }, // 315 SLBSYNC
  { 0, 0, 0, 0, 0 }, // 316 SLBFEE_rec
  { 0, 0, 0, 0, 0 }, // 317 STOP
  { 0, 0, 0, 0, 0 }, // 318 DCBA_DCBI
  { 1, 429, 431, 5539, 5542 }, // 319 FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRE_FRES_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRSP_FRSQRTE_FRSQRTES
  { 1, 417, 419, 5542, 5545 }, // 320 VCFSX_VCFSX_0_VCFUX_VCFUX_0_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VLOGEFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP
  { 1, 417, 419, 5545, 5548 }, // 321 XSCVDPHP_XSCVDPSP_XSCVDPSPN_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPSXWSs_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPUXWSs_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSP_XSRSQRTEDP_XSRSQRTESP
  { 1, 417, 419, 5548, 5551 }, // 322 XVCVSPBF16
  { 1, 429, 431, 5551, 5554 }, // 323 FADDS_FMULS_FSUBS
  { 1, 429, 431, 5554, 5558 }, // 324 FMUL
  { 1, 417, 419, 5558, 5561 }, // 325 VADDFP_XVADDDP_XVADDSP_XVMULDP_XVMULSP_XVSUBDP_XVSUBSP
  { 1, 431, 433, 5561, 5564 }, // 326 VSUBFP
  { 1, 417, 419, 5564, 5567 }, // 327 XSADDDP_XSADDSP_XSSUBDP_XSSUBSP
  { 1, 417, 419, 5567, 5570 }, // 328 XSMULDP_XSMULSP
  { 1, 417, 419, 5570, 5573 }, // 329 VMADDFP_VNMSUBFP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP
  { 1, 417, 419, 5573, 5576 }, // 330 VEXPTEFP
  { 1, 429, 431, 5576, 5579 }, // 331 FADDS_rec_FMULS_rec_FSUBS_rec
  { 1, 429, 431, 5579, 5583 }, // 332 FMUL_rec
  { 1, 429, 431, 5583, 5586 }, // 333 FCFID_rec_FCFIDS_rec_FCFIDU_rec_FCFIDUS_rec_FCTID_rec_FCTIDU_rec_FCTIDUZ_rec_FCTIDZ_rec_FCTIW_rec_FCTIWU_rec_FCTIWUZ_rec_FCTIWZ_rec_FRE_rec_FRES_rec_FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRSP_rec_FRSQRTE_rec_FRSQRTES_rec
  { 1, 415, 417, 5586, 5589 }, // 334 BCLR_BCLRn_BDNZLR_BDNZLR8_BDNZLRm_BDNZLRp_BDZLR_BDZLR8_BDZLRm_BDZLRp_gBCLR_BCLRL_BCLRLn_BDNZLRL_BDNZLRLm_BDNZLRLp_BDZLRL_BDZLRLm_BDZLRLp_gBCLRL_BL_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLR_BLR8_BLRL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS
  { 1, 415, 417, 5589, 5592 }, // 335 BL8_NOTOC_BL8_NOTOC_RM_BL8_NOTOC_TLS
  { 1, 415, 417, 5592, 5595 }, // 336 B_BCC_BCCA_BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_CTRL_DEP_TAILB_TAILB8_BA_TAILBA_TAILBA8_BC_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_LDinto_toc_BCTRL8_LDinto_toc_RM_BCTRL8_RM_BCTRL_LWZinto_toc_BCTRL_LWZinto_toc_RM_BCTRL_RM_BCn_BDNZ_BDNZ8_BDNZm_BDNZp_BDZ_BDZ8_BDZm_BDZp_TAILBCTR_TAILBCTR8_gBC_gBCat_BCL_BCLalways_BCLn_BDNZL_BDNZLm_BDNZLp_BDZL_BDZLm_BDZLp_gBCL_gBCLat_BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM
  { 1, 415, 417, 5595, 5598 }, // 337 BCCTR_BCCTR8_BCCTR8n_BCCTRn_gBCCTR_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_gBCCTRL
  { 1, 417, 419, 5598, 5601 }, // 338 VSBOX
  { 1, 413, 415, 5601, 5604 }, // 339 CFUGED_CNTLZDM_CNTTZDM_PDEPD_PEXTD
  { 1, 431, 433, 5604, 5607 }, // 340 VCFUGED_VCLZDM_VCTZDM_VGNB_VPDEPD_VPEXTD
  { 1, 417, 419, 5607, 5610 }, // 341 XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP
  { 1, 417, 419, 5610, 5613 }, // 342 XSCVQPSQZ_XSCVQPUQZ_XSCVSQQP_XSCVUQQP
  { 1, 417, 419, 5613, 5616 }, // 343 XSADDQP_XSADDQPO_XSSUBQP_XSSUBQPO
  { 1, 413, 415, 5616, 5619 }, // 344 HASHST_HASHST8_HASHSTP_HASHSTP8
  { 1, 417, 419, 5619, 5622 }, // 345 XSMULQP_XSMULQPO
  { 1, 431, 433, 5622, 5625 }, // 346 VDIVESQ_VDIVEUQ_VDIVSQ_VDIVUQ
  { 1, 431, 433, 5625, 5628 }, // 347 VMODSQ_VMODUQ
  { 1, 426, 429, 5628, 5631 }, // 348 DIVWE_DIVWEO_DIVWEU_DIVWEUO
  { 1, 431, 433, 5631, 5634 }, // 349 VDIVSD_VDIVUD
  { 1, 431, 433, 5634, 5637 }, // 350 VMODSD_VMODUD
  { 1, 431, 433, 5637, 5640 }, // 351 VDIVSW_VDIVUW
  { 1, 431, 433, 5640, 5643 }, // 352 VMODSW_VMODUW
  { 1, 431, 433, 5643, 5646 }, // 353 VDIVESD_VDIVEUD
  { 1, 431, 433, 5646, 5649 }, // 354 VDIVESW_VDIVEUW
  { 1, 417, 419, 5649, 5652 }, // 355 BCDCTN_rec_VMUL10CUQ_VMUL10UQ_XSXSIGQP
  { 1, 417, 419, 5652, 5655 }, // 356 BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDUS_rec_BCDUTRUNC_rec_VADDCUQ_VMUL10ECUQ_VMUL10EUQ_VSUBCUQ_XSTSTDCQP
  { 1, 431, 433, 5655, 5658 }, // 357 VADDUQM_VSUBUQM
  { 1, 417, 419, 5658, 5661 }, // 358 XSMAXCQP_XSMINCQP
  { 1, 431, 433, 5661, 5664 }, // 359 XXGENPCVBM
  { 1, 417, 419, 5664, 5667 }, // 360 BCDADD_rec_BCDS_rec_BCDSUB_rec_BCDTRUNC_rec_VADDECUQ_VADDEUQM_VSUBECUQ_VSUBEUQM
  { 1, 421, 423, 5667, 5670 }, // 361 TRAP
  { 1, 413, 415, 5670, 5672 }, // 362 TW
  { 1, 413, 415, 5672, 5675 }, // 363 CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW
  { 1, 429, 431, 5675, 5678 }, // 364 FTSQRT
  { 1, 431, 433, 5678, 5681 }, // 365 MTVSRBM_MTVSRBMI_MTVSRDM_MTVSRHM_MTVSRQM_MTVSRWM_VEXPANDBM_VEXPANDDM_VEXPANDHM_VEXPANDQM_VEXPANDWM_VEXTRACTBM_VEXTRACTDM_VEXTRACTHM_VEXTRACTQM_VEXTRACTWM_XVTLSBB
  { 1, 413, 415, 5681, 5684 }, // 366 POPCNTB_POPCNTB8
  { 1, 431, 433, 5684, 5687 }, // 367 VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTD_VPOPCNTW_VPRTYBD_VPRTYBW
  { 1, 431, 433, 5687, 5690 }, // 368 VPOPCNTB_VPOPCNTH
  { 1, 417, 419, 5690, 5693 }, // 369 XSCVSPDPN
  { 1, 429, 431, 5693, 5696 }, // 370 XSTSQRTDP
  { 1, 417, 419, 5696, 5699 }, // 371 XVCVHPSP
  { 1, 429, 431, 5699, 5702 }, // 372 XVTSQRTDP_XVTSQRTSP
  { 1, 413, 415, 5702, 5705 }, // 373 CMPEQB
  { 1, 413, 415, 5705, 5708 }, // 374 EXTSWSLI_32_64_rec_EXTSWSLI_rec
  { 1, 413, 415, 5708, 5711 }, // 375 SLD_rec_SRD_rec
  { 1, 413, 415, 5711, 5714 }, // 376 SLW8_rec_SLW_rec_SRW8_rec_SRW_rec
  { 1, 417, 419, 5714, 5717 }, // 377 VADDCUW_VADDSBS_VADDSHS_VADDSWS_VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VMAXFP_VMINFP_VSUBCUW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP
  { 1, 417, 419, 5717, 5720 }, // 378 VCMPBFP_VCMPBFP_rec_VCMPEQFP_VCMPEQFP_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPGTSB_rec_VCMPGTSD_rec_VCMPGTSH_rec_VCMPGTSW_rec_VCMPGTUB_rec_VCMPGTUD_rec_VCMPGTUH_rec_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec
  { 1, 417, 419, 5720, 5723 }, // 379 VCMPEQUQ_VCMPEQUQ_rec_VCMPGTSQ_VCMPGTSQ_rec_VCMPGTUQ_VCMPGTUQ_rec
  { 1, 431, 433, 5723, 5726 }, // 380 VCMPSQ_VCMPUQ_VCNTMBB_VCNTMBD_VCNTMBH_VCNTMBW
  { 1, 417, 419, 5726, 5729 }, // 381 XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP
  { 1, 413, 415, 5729, 5732 }, // 382 RLDIC_rec
  { 1, 413, 415, 5732, 5735 }, // 383 RLDICL_32_rec_RLDICL_rec_RLDICR_rec
  { 1, 417, 419, 5735, 5738 }, // 384 VSHASIGMAD_VSHASIGMAW
  { 1, 417, 419, 5738, 5741 }, // 385 VRLQ_VRLQNM_VSLQ_VSRAQ_VSRQ
  { 1, 417, 419, 5741, 5744 }, // 386 VRLQMI
  { 1, 419, 421, 5744, 5747 }, // 387 CR6SET_CREQV_CRSET
  { 1, 421, 423, 5747, 5750 }, // 388 DSS_DSSALL
  { 0, 0, 0, 0, 0 }, // 389 MFCTR_MFCTR8_MFLR_MFLR8
  { 1, 411, 413, 5750, 5753 }, // 390 NOP_ORI_ORI8
  { 1, 417, 419, 5753, 5756 }, // 391 VXOR_V_SET0_V_SET0B_V_SET0H
  { 1, 431, 433, 5756, 5759 }, // 392 XXLEQV_XXLEQVOnes_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz
  { 1, 411, 413, 5759, 5762 }, // 393 ADDI_ADDI8_LI_LI8_ADDIS_ADDIS8_LIS_LIS8_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_NEG_NEG8_NEG8_rec_NEG_rec_NEG8O_NEGO
  { 0, 0, 0, 0, 0 }, // 394 ADDIdtprelL32_ADDItlsldLADDR32_ADDISdtprelHA32
  { 0, 0, 0, 0, 0 }, // 395 ADDItocL_ADDIStocHA_ADDIStocHA8
  { 1, 413, 415, 5762, 5765 }, // 396 ADDME_ADDME8_ADDME8O_ADDMEO_ADDZE_ADDZE8_ADDZE8O_ADDZEO_SUBFME_SUBFME8_SUBFME8O_SUBFMEO_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZEO
  { 1, 429, 431, 5765, 5768 }, // 397 FABSD_FABSS_FMR_FNABSD_FNABSS_FNEGD_FNEGS
  { 1, 413, 415, 5768, 5771 }, // 398 SETB_SETB8
  { 1, 413, 415, 5771, 5774 }, // 399 SETBC_SETBC8_SETBCR_SETBCR8_SETNBC_SETNBC8_SETNBCR_SETNBCR8
  { 1, 431, 433, 5774, 5777 }, // 400 VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VNEGD_VNEGW
  { 1, 431, 433, 5777, 5780 }, // 401 VEXTSD2Q
  { 1, 417, 419, 5780, 5783 }, // 402 XSABSDP_XSNABSDP_XSNEGDP_XSXEXPDP
  { 1, 417, 419, 5783, 5786 }, // 403 XSABSQP_XSNABSQP_XSNEGQP_XSXEXPQP_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVNEGDP_XVNEGSP_XVXEXPDP_XVXEXPSP
  { 1, 417, 419, 5786, 5789 }, // 404 XVXSIGDP_XVXSIGSP
  { 1, 411, 413, 5789, 5792 }, // 405 ADD4_ADD4TLS_ADD8_ADD8TLS_ADD8TLS__ADD4_rec_ADD8_rec_ADD4O_ADD8O_AND_AND8_AND8_rec_AND_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_EQV_EQV8_EQV8_rec_EQV_rec_NAND_NAND8_NAND8_rec_NAND_rec_NOR_NOR8_NOR8_rec_NOR_rec_OR_OR8_OR8_rec_OR_rec_ORC_ORC8_ORC8_rec_ORC_rec_ORIS_ORIS8_XOR_XOR8_XOR8_rec_XOR_rec_XORI_XORI8_XORIS_XORIS8
  { 1, 413, 415, 5792, 5795 }, // 406 ADDE_ADDE8_ADDE8O_ADDEO_ADDIC_ADDIC8_ANDI8_rec_ANDI_rec_ANDIS8_rec_ANDIS_rec_SUBF_SUBF8_SUBF8_rec_SUBF_rec_SUBFE_SUBFE8_SUBFE8O_SUBFEO_SUBFIC_SUBFIC8_SUBF8O_SUBFO
  { 1, 413, 415, 5795, 5798 }, // 407 CMPB_CMPB8
  { 1, 413, 415, 5798, 5801 }, // 408 EXTSWSLI_EXTSWSLI_32_64_SRADI_SRADI_32
  { 1, 413, 415, 5801, 5804 }, // 409 SLW_SLW8_SRW_SRW8
  { 1, 431, 433, 5804, 5807 }, // 410 VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEQV_VNAND_VORC_VSLD_VSRAD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_XXLAND_XXLANDC_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC
  { 1, 417, 419, 5807, 5810 }, // 411 VAND_VANDC_VMRGEW_VMRGOW_VNOR_VOR_VRLB_VRLD_VRLDNM_VRLH_VRLW_VRLWNM_VSLB_VSLH_VSLW_VSRAB_VSRAH_VSRAW_VSRB_VSRH_VSRW_XSCPSGNQP_XSIEXPQP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP
  { 1, 417, 419, 5810, 5813 }, // 412 VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW
  { 1, 413, 415, 5813, 5816 }, // 413 ADDEX_ADDEX8
  { 1, 421, 423, 5816, 5819 }, // 414 DST_DST64_DSTT_DSTT64_DSTST_DSTST64_DSTSTT_DSTSTT64
  { 1, 413, 415, 5819, 5822 }, // 415 RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32
  { 0, 0, 0, 0, 0 }, // 416 MFFS_MFFS_rec_MFFSL
  { 1, 478, 480, 5822, 5824 }, // 417 TRECHKPT
  { 1, 413, 415, 5824, 5827 }, // 418 ADDME8_rec_ADDME_rec_ADDME8O_rec_ADDMEO_rec_ADDZE8_rec_ADDZE_rec_ADDZE8O_rec_ADDZEO_rec_SUBFME8_rec_SUBFME_rec_SUBFME8O_rec_SUBFMEO_rec_SUBFZE8_rec_SUBFZE_rec_SUBFZE8O_rec_SUBFZEO_rec
  { 0, 0, 0, 0, 0 }, // 419 MTFSB0
  { 1, 411, 413, 5827, 5830 }, // 420 NEG8O_rec_NEGO_rec
  { 1, 413, 415, 5830, 5833 }, // 421 ADDE8_rec_ADDE_rec_ADDE8O_rec_ADDEO_rec_ADDIC_rec_SUBFE8_rec_SUBFE_rec_SUBFE8O_rec_SUBFEO_rec_SUBF8O_rec_SUBFO_rec
  { 1, 415, 417, 5833, 5836 }, // 422 HRFID
  { 1, 429, 431, 5836, 5839 }, // 423 FABSD_rec_FABSS_rec_FMR_rec_FNABSD_rec_FNABSS_rec_FNEGD_rec_FNEGS_rec
  { 1, 415, 417, 5839, 5842 }, // 424 SC
  { 1, 413, 415, 5842, 5845 }, // 425 ADDC_ADDC8_ADDC8O_ADDCO_SUBFC_SUBFC8_SUBFC8O_SUBFCO
  { 1, 413, 415, 5845, 5848 }, // 426 ADDC8_rec_ADDC_rec_SUBFC8_rec_SUBFC_rec
  { 0, 0, 0, 0, 0 }, // 427 MTFSF_MTFSFI_MTFSFIb
  { 0, 0, 0, 0, 0 }, // 428 MTFSFI_rec
  { 1, 431, 433, 5848, 5851 }, // 429 VSTRIBL_rec_VSTRIBR_rec_VSTRIHL_rec_VSTRIHR_rec
  { 1, 421, 423, 5851, 5854 }, // 430 LBZ_LBZ8_LDBRX_LHBRX_LHBRX8_LHZ_LHZ8_LWBRX_LWBRX8_LWZ_LWZ8
  { 1, 421, 423, 5854, 5857 }, // 431 LD
  { 0, 0, 0, 0, 0 }, // 432 LDtoc_LDtocBA_LDtocCPT_LDtocJTI_LDtocL_SPILLTOVSR_LD_LWZtoc_LWZtocL
  { 1, 421, 423, 5857, 5860 }, // 433 LXVRBX_LXVRDX_LXVRHX_LXVRWX
  { 0, 0, 0, 0, 0 }, // 434 DCBT_DCBTST
  { 1, 421, 423, 5860, 5863 }, // 435 ICBT_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32
  { 1, 421, 423, 5863, 5866 }, // 436 LDX_LDXTLS_LDXTLS_
  { 0, 0, 0, 0, 0 }, // 437 SPILLTOVSR_LDX
  { 1, 421, 423, 5866, 5869 }, // 438 LBZCIX_LDCIX_LHZCIX_LWZCIX
  { 0, 0, 0, 0, 0 }, // 439 MTSR
  { 1, 413, 415, 5869, 5872 }, // 440 MTVRSAVE_MTVRSAVEv
  { 1, 421, 423, 5872, 5875 }, // 441 LSWI
  { 1, 421, 423, 5875, 5878 }, // 442 PLBZ_PLBZ8_PLBZ8pc_PLBZpc_PLD_PLDpc_PLFD_PLFDpc_PLFS_PLFSpc_PLHA_PLHA8_PLHA8pc_PLHApc_PLHZ_PLHZ8_PLHZ8pc_PLHZpc_PLWA_PLWA8_PLWA8pc_PLWApc_PLWZ_PLWZ8_PLWZ8pc_PLWZpc_PLXSD_PLXSDpc_PLXSSP_PLXSSPpc_PLXV_PLXVpc_PLXVP_PLXVPpc
  { 1, 421, 423, 5878, 5881 }, // 443 LXVP_LXVPX
  { 0, 0, 0, 0, 0 }, // 444 MFSR
  { 0, 0, 0, 0, 0 }, // 445 MFTB8
  { 1, 431, 433, 5881, 5884 }, // 446 XXSETACCZ
  { 1, 417, 419, 5884, 5887 }, // 447 XVBF16GER2_XVF16GER2_XVF32GER_XVF64GER_XVI16GER2_XVI16GER2S_XVI4GER8_XVI8GER4
  { 1, 417, 419, 5887, 5890 }, // 448 XVBF16GER2NN_XVBF16GER2NP_XVBF16GER2PN_XVBF16GER2PP_XVF16GER2NN_XVF16GER2NP_XVF16GER2PN_XVF16GER2PP_XVF32GERNN_XVF32GERNP_XVF32GERPN_XVF32GERPP_XVF64GERNN_XVF64GERNP_XVF64GERPN_XVF64GERPP_XVI16GER2PP_XVI16GER2SPP_XVI4GER8PP_XVI8GER4PP
  { 1, 431, 433, 5890, 5893 }, // 449 XVI8GER4SPP
  { 1, 417, 419, 5893, 5896 }, // 450 PMXVF32GER_PMXVF64GER
  { 1, 417, 419, 5896, 5899 }, // 451 PMXVBF16GER2_PMXVF16GER2_PMXVF32GERNN_PMXVF32GERNP_PMXVF32GERPN_PMXVF32GERPP_PMXVF64GERNN_PMXVF64GERNP_PMXVF64GERPN_PMXVF64GERPP_PMXVI16GER2_PMXVI16GER2S_PMXVI4GER8_PMXVI8GER4
  { 1, 417, 419, 5899, 5902 }, // 452 PMXVBF16GER2NN_PMXVBF16GER2NP_PMXVBF16GER2PN_PMXVBF16GER2PP_PMXVF16GER2NN_PMXVF16GER2NP_PMXVF16GER2PN_PMXVF16GER2PP_PMXVI16GER2PP_PMXVI16GER2SPP_PMXVI4GER8PP_PMXVI8GER4PP
  { 1, 431, 433, 5902, 5905 }, // 453 PMXVI8GER4SPP
  { 1, 431, 433, 5905, 5908 }, // 454 XXMTACC
  { 1, 431, 433, 5908, 5911 }, // 455 XXMFACC
  { 1, 413, 415, 5911, 5914 }, // 456 MULLD_MULLDO
  { 1, 431, 433, 5914, 5917 }, // 457 VMULHSD_VMULHUD_VMULLD
  { 1, 495, 497, 5917, 5920 }, // 458 VSPLTISW
  { 1, 417, 419, 5920, 5923 }, // 459 V_SETALLONES_V_SETALLONESB_V_SETALLONESH
  { 1, 431, 433, 5923, 5926 }, // 460 MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VPRTYBQ
  { 1, 417, 419, 5926, 5929 }, // 461 VGBBD_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW
  { 1, 495, 497, 5929, 5932 }, // 462 VSPLTISB_VSPLTISH_XXSPLTIB
  { 1, 431, 433, 5932, 5935 }, // 463 VSTRIBL_VSTRIBR_VSTRIHL_VSTRIHR
  { 1, 417, 419, 5935, 5938 }, // 464 XVCVBF16SPN
  { 1, 417, 419, 5938, 5941 }, // 465 VBPERMQ_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLO_VSLV_VSR_VSRO_VSRV_XXEXTRACTUW
  { 1, 431, 433, 5941, 5944 }, // 466 VCLRLB_VCLRRB_XXGENPCVDM_XXGENPCVHM_XXGENPCVWM
  { 1, 431, 433, 5944, 5947 }, // 467 VEXTRACTD_VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VINSERTD_VINSERTW
  { 1, 431, 433, 5947, 5950 }, // 468 VEXTDDVLX_VEXTDDVRX_VEXTDUBVLX_VEXTDUBVRX_VEXTDUHVLX_VEXTDUHVRX_VEXTDUWVLX_VEXTDUWVRX_VINSBLX_VINSBRX_VINSBVLX_VINSBVRX_VINSD_VINSDLX_VINSDRX_VINSHLX_VINSHRX_VINSHVLX_VINSHVRX_VINSW_VINSWLX_VINSWRX_VINSWVLX_VINSWVRX_VSLDBI_VSRDBI
  { 1, 417, 419, 5950, 5953 }, // 469 VSUMSWS
  { 1, 431, 433, 5953, 5956 }, // 470 XXSPLTIDP_XXSPLTIW
  { 1, 431, 433, 5956, 5959 }, // 471 XXBLENDVB_XXBLENDVD_XXBLENDVH_XXBLENDVW_XXSPLTI32DX
  { 1, 431, 433, 5959, 5962 }, // 472 XXEVAL
  { 1, 495, 497, 5962, 5965 }, // 473 XXPERMX
  { 0, 0, 0, 0, 0 }, // 474 DCBST_DCBZ
  { 0, 0, 0, 0, 0 }, // 475 ICBI
  { 0, 0, 0, 0, 0 }, // 476 DCBF
  { 1, 421, 423, 5965, 5968 }, // 477 PSTXVP_PSTXVPpc
  { 1, 433, 436, 5968, 5971 }, // 478 STB_STB8_STDBRX_STH_STH8_STHBRX_STW_STW8_STWBRX
  { 0, 0, 0, 0, 0 }, // 479 SPILLTOVSR_ST
  { 1, 433, 436, 5971, 5974 }, // 480 STD
  { 0, 0, 0, 0, 0 }, // 481 DFSTOREf32_DFSTOREf64_STIWX
  { 1, 487, 490, 5974, 5977 }, // 482 STXVRBX_STXVRDX_STXVRHX_STXVRWX
  { 0, 0, 0, 0, 0 }, // 483 SPILLTOVSR_STX
  { 1, 421, 423, 5977, 5980 }, // 484 EnforceIEIO
  { 1, 421, 423, 5980, 5983 }, // 485 STBCIX_STDCIX_STHCIX_STWCIX
  { 1, 421, 423, 5983, 5986 }, // 486 PSTB_PSTB8_PSTB8pc_PSTBpc_PSTD_PSTDpc_PSTFD_PSTFDpc_PSTFS_PSTFSpc_PSTH_PSTH8_PSTH8pc_PSTHpc_PSTW_PSTW8_PSTW8pc_PSTWpc_PSTXSD_PSTXSDpc_PSTXSSP_PSTXSSPpc_PSTXV_PSTXVpc
  { 1, 421, 423, 5986, 5989 }, // 487 STXVP_STXVPX
  { 1, 415, 417, 5989, 5992 }, // 488 ATTN_NAP
  { 0, 0, 0, 0, 0 }, // 489 DCBZL
  { 1, 421, 423, 5992, 5995 }, // 490 DCCCI_ICBLQ_ICCCI_TLBLD_TLBLI_TLBRE2_TLBSX2_TLBSX2D_TLBWE2
  { 1, 433, 436, 5995, 5998 }, // 491 ICBLC
  { 1, 415, 417, 5998, 6001 }, // 492 CLRBHRB
  { 1, 415, 417, 6001, 6004 }, // 493 MFBHRBE
  { 1, 421, 423, 6004, 6007 }, // 494 PADDI_PADDI8_PADDI8pc_PADDIpc
  { 1, 411, 413, 6007, 6010 }, // 495 PLI_PLI8
  { 1, 417, 419, 6010, 6013 }, // 496 VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS
  { 1, 431, 433, 6013, 6016 }, // 497 VMULESD_VMULEUD_VMULHSW_VMULHUW_VMULOSD_VMULOUD
  { 1, 431, 433, 6016, 6019 }, // 498 VMSUMCUD
  { 0, uint16_t(~0U), uint16_t(~0U), uint16_t(~0U), uint16_t(~0U) }// end marker
};

// ===============================================================
// Data tables for the new per-operand machine model.

// {ProcResourceIdx, Cycles}
extern const llvm::MCWriteProcResEntry PPCWriteProcResTable[] = {
  { 0,  0}, // Invalid
  { 1,  1}, // #1
  {13,  1}, // #2
  { 1,  1}, // #3
  { 9,  1}, // #4
  { 1,  2}, // #5
  { 8,  1}, // #6
  { 9,  1}, // #7
  { 1,  2}, // #8
  { 8,  1}, // #9
  { 9,  2}, // #10
  { 1,  1}, // #11
  {15,  1}, // #12
  { 1,  1}, // #13
  { 2,  1}, // #14
  { 1,  2}, // #15
  { 2,  1}, // #16
  { 8,  1}, // #17
  { 9,  1}, // #18
  { 1,  1}, // #19
  { 7,  1}, // #20
  { 1,  1}, // #21
  { 5,  1}, // #22
  { 1,  1}, // #23
  { 5, 16}, // #24
  { 1,  1}, // #25
  { 5, 17}, // #26
  { 1,  1}, // #27
  { 5, 30}, // #28
  { 1,  1}, // #29
  { 5, 49}, // #30
  { 1,  1}, // #31
  { 5, 67}, // #32
  { 1,  1}, // #33
  {10,  1}, // #34
  { 1,  1}, // #35
  {14,  1}, // #36
  { 1,  2}, // #37
  { 8,  1}, // #38
  {10,  1}, // #39
  { 1,  2}, // #40
  { 8,  1}, // #41
  { 9,  1}, // #42
  {14,  1}, // #43
  { 1,  2}, // #44
  { 8,  1}, // #45
  {14,  1}, // #46
  { 1,  4}, // #47
  { 8,  1}, // #48
  {10,  4}, // #49
  { 1,  4}, // #50
  { 8,  2}, // #51
  {10,  2}, // #52
  {12,  2}, // #53
  { 1,  2}, // #54
  { 8,  1}, // #55
  {10,  1}, // #56
  {15,  1}, // #57
  { 1,  2}, // #58
  { 8,  1}, // #59
  { 9,  1}, // #60
  {10,  1}, // #61
  {12,  1}, // #62
  { 1,  4}, // #63
  { 8,  1}, // #64
  {14,  4}, // #65
  { 1,  2}, // #66
  { 8,  1}, // #67
  {15,  1}, // #68
  { 1,  1}, // #69
  { 6, 10}, // #70
  { 1,  2}, // #71
  { 6, 10}, // #72
  { 8,  1}, // #73
  { 9,  1}, // #74
  { 1,  2}, // #75
  { 8,  1}, // #76
  { 9,  2}, // #77
  {12,  1}, // #78
  { 1,  4}, // #79
  { 8,  1}, // #80
  { 9,  4}, // #81
  { 1,  2}, // #82
  { 2,  7}, // #83
  { 8,  1}, // #84
  { 9,  1}, // #85
  { 1,  2}, // #86
  { 2, 10}, // #87
  { 8,  1}, // #88
  { 9,  1}, // #89
  { 1,  2}, // #90
  { 2,  5}, // #91
  { 8,  1}, // #92
  { 9,  1}, // #93
  { 1,  4}, // #94
  { 8,  1}, // #95
  { 9,  2}, // #96
  {10,  1}, // #97
  {12,  1}, // #98
  {15,  1}, // #99
  { 1,  1}, // #100
  { 3,  1}, // #101
  { 1,  2}, // #102
  { 8,  1}, // #103
  { 9,  1}, // #104
  {15,  1}, // #105
  { 1,  8}, // #106
  { 8,  1}, // #107
  { 9,  3}, // #108
  {10,  1}, // #109
  {14,  4}, // #110
  { 1,  4}, // #111
  { 8,  1}, // #112
  { 9,  1}, // #113
  {14,  3}, // #114
  { 1,  2}, // #115
  { 5,  1}, // #116
  { 8,  1}, // #117
  {10,  1}, // #118
  { 1,  2}, // #119
  { 5,  1}, // #120
  { 8,  1}, // #121
  {14,  1}, // #122
  { 1,  1}, // #123
  { 5, 12}, // #124
  { 1,  1}, // #125
  { 5, 15}, // #126
  { 1,  1}, // #127
  { 6, 21}, // #128
  { 1,  1}, // #129
  { 6, 33}, // #130
  { 1,  2}, // #131
  { 8,  1}, // #132
  { 9,  1}, // #133
  {13,  1}, // #134
  { 1,  2}, // #135
  { 8,  1}, // #136
  {10,  1}, // #137
  {12,  1}, // #138
  { 1,  2}, // #139
  { 8,  1}, // #140
  {10,  1}, // #141
  {12,  1}, // #142
  {15,  1}, // #143
  { 1,  1}, // #144
  {11,  1}, // #145
  { 1,  2}, // #146
  { 8,  1}, // #147
  { 9,  1}, // #148
  {11,  1}, // #149
  {12,  1}, // #150
  { 1,  4}, // #151
  { 8,  2}, // #152
  { 9,  2}, // #153
  {11,  2}, // #154
  {12,  2}, // #155
  { 1,  2}, // #156
  { 2,  1}, // #157
  { 8,  1}, // #158
  {13,  1}, // #159
  { 1,  2}, // #160
  { 8,  1}, // #161
  {12,  1}, // #162
  {13,  1}, // #163
  { 1,  2}, // #164
  { 8,  1}, // #165
  {12,  1}, // #166
  {14,  1}, // #167
  { 1,  2}, // #168
  { 8,  1}, // #169
  {12,  1}, // #170
  {14,  2}, // #171
  { 1,  2}, // #172
  { 8,  1}, // #173
  {12,  1}, // #174
  {15,  1}, // #175
  { 1,  1}, // #176
  { 2,  7}, // #177
  { 1,  1}, // #178
  { 2, 10}, // #179
  { 1,  1}, // #180
  { 2,  5}, // #181
  { 1,  1}, // #182
  { 2,  8}, // #183
  { 1,  1}, // #184
  { 4,  1}, // #185
  { 1,  2}, // #186
  { 2,  2}, // #187
  { 8,  1}, // #188
  { 1,  2}, // #189
  { 8,  1}, // #190
  {11,  1}, // #191
  {12,  1}, // #192
  { 1,  2}, // #193
  { 2,  1}, // #194
  { 3,  1}, // #195
  { 7,  1}, // #196
  {18,  2}, // #197
  {19,  1}, // #198
  {20,  1}, // #199
  { 1,  1}, // #200
  { 7,  3}, // #201
  { 8,  2}, // #202
  {10,  1}, // #203
  {11,  1}, // #204
  {12,  1}, // #205
  {18,  1}, // #206
  { 1,  1}, // #207
  { 7,  1}, // #208
  {18,  1}, // #209
  { 7,  1}, // #210
  {14,  2}, // #211
  {15,  1}, // #212
  {16,  1}, // #213
  {18,  2}, // #214
  {19,  1}, // #215
  {20,  1}, // #216
  { 7,  3}, // #217
  { 8,  2}, // #218
  {10,  1}, // #219
  {11,  1}, // #220
  {12,  1}, // #221
  {14,  1}, // #222
  {18,  1}, // #223
  { 1,  1}, // #224
  { 7,  4}, // #225
  { 8,  2}, // #226
  {10,  1}, // #227
  {11,  1}, // #228
  {12,  1}, // #229
  {14,  1}, // #230
  {18,  2}, // #231
  { 7,  1}, // #232
  {14,  1}, // #233
  {18,  1}, // #234
  { 7,  1}, // #235
  {18,  2}, // #236
  {19,  1}, // #237
  {20,  1}, // #238
  {22,  1}, // #239
  { 6,  1}, // #240
  { 7,  1}, // #241
  {18,  2}, // #242
  {19,  1}, // #243
  {20,  1}, // #244
  { 6, 11}, // #245
  { 7,  1}, // #246
  {18,  2}, // #247
  {19,  1}, // #248
  {20,  1}, // #249
  { 6, 12}, // #250
  { 7,  1}, // #251
  {18,  2}, // #252
  {19,  1}, // #253
  {20,  1}, // #254
  { 6, 25}, // #255
  { 7,  1}, // #256
  {18,  2}, // #257
  {19,  1}, // #258
  {20,  1}, // #259
  { 6, 44}, // #260
  { 7,  1}, // #261
  {18,  2}, // #262
  {19,  1}, // #263
  {20,  1}, // #264
  { 6, 62}, // #265
  { 7,  1}, // #266
  {18,  2}, // #267
  {19,  1}, // #268
  {20,  1}, // #269
  { 7,  1}, // #270
  {17,  1}, // #271
  {21,  1}, // #272
  { 7,  3}, // #273
  { 8,  2}, // #274
  {10,  1}, // #275
  {11,  1}, // #276
  {12,  1}, // #277
  {17,  1}, // #278
  {21,  1}, // #279
  { 7,  2}, // #280
  { 8,  2}, // #281
  {17,  2}, // #282
  {21,  2}, // #283
  { 1,  1}, // #284
  { 7,  4}, // #285
  { 8,  4}, // #286
  {17,  1}, // #287
  {18,  1}, // #288
  {21,  1}, // #289
  { 1,  1}, // #290
  { 7,  2}, // #291
  {17,  1}, // #292
  {18,  1}, // #293
  {21,  1}, // #294
  { 1,  1}, // #295
  { 7,  4}, // #296
  { 8,  2}, // #297
  {10,  1}, // #298
  {11,  1}, // #299
  {12,  1}, // #300
  {17,  1}, // #301
  {18,  2}, // #302
  {21,  1}, // #303
  { 7,  2}, // #304
  {17,  2}, // #305
  {21,  2}, // #306
  { 1,  1}, // #307
  { 7,  6}, // #308
  { 8,  4}, // #309
  {10,  2}, // #310
  {11,  2}, // #311
  {12,  2}, // #312
  {17,  1}, // #313
  {18,  1}, // #314
  {21,  1}, // #315
  { 1,  2}, // #316
  { 7,  5}, // #317
  { 8,  4}, // #318
  {17,  1}, // #319
  {18,  2}, // #320
  {21,  1}, // #321
  { 7,  2}, // #322
  {17,  1}, // #323
  {18,  2}, // #324
  {19,  1}, // #325
  {20,  1}, // #326
  {21,  1}, // #327
  {22,  1}, // #328
  { 7,  3}, // #329
  { 8,  2}, // #330
  {10,  1}, // #331
  {11,  1}, // #332
  {12,  1}, // #333
  {17,  1}, // #334
  {18,  1}, // #335
  {21,  1}, // #336
  { 7,  1}, // #337
  {17,  1}, // #338
  {18,  2}, // #339
  {19,  1}, // #340
  {20,  1}, // #341
  {21,  1}, // #342
  { 7,  2}, // #343
  { 8,  2}, // #344
  {10,  1}, // #345
  {11,  1}, // #346
  {13,  1}, // #347
  {18,  2}, // #348
  {19,  1}, // #349
  {20,  1}, // #350
  { 7,  2}, // #351
  { 8,  2}, // #352
  {10,  1}, // #353
  {11,  1}, // #354
  {13,  8}, // #355
  {18,  2}, // #356
  {19,  1}, // #357
  {20,  1}, // #358
  { 1,  1}, // #359
  { 7,  3}, // #360
  { 8,  2}, // #361
  {10,  1}, // #362
  {11,  1}, // #363
  {13,  8}, // #364
  {18,  3}, // #365
  {19,  1}, // #366
  {20,  1}, // #367
  { 1,  2}, // #368
  { 7,  6}, // #369
  { 8,  4}, // #370
  {10,  2}, // #371
  {11,  2}, // #372
  {12,  2}, // #373
  {18,  2}, // #374
  { 1,  2}, // #375
  { 7,  2}, // #376
  {18,  2}, // #377
  { 1,  2}, // #378
  { 7,  4}, // #379
  { 8,  2}, // #380
  {10,  1}, // #381
  {11,  1}, // #382
  {12,  1}, // #383
  {18,  2}, // #384
  { 1,  3}, // #385
  { 7,  9}, // #386
  { 8,  6}, // #387
  {10,  3}, // #388
  {11,  3}, // #389
  {12,  3}, // #390
  {18,  3}, // #391
  { 7,  3}, // #392
  { 8,  2}, // #393
  {10,  1}, // #394
  {11,  1}, // #395
  {12,  1}, // #396
  {14,  8}, // #397
  {18,  1}, // #398
  { 1,  1}, // #399
  { 7,  4}, // #400
  { 8,  2}, // #401
  {10,  1}, // #402
  {11,  1}, // #403
  {12,  1}, // #404
  {14,  8}, // #405
  {18,  2}, // #406
  { 7,  1}, // #407
  {14, 10}, // #408
  {18,  1}, // #409
  { 7,  3}, // #410
  { 8,  2}, // #411
  {10,  1}, // #412
  {11,  1}, // #413
  {12,  1}, // #414
  {14, 10}, // #415
  {18,  1}, // #416
  { 7,  1}, // #417
  {14, 20}, // #418
  {18,  2}, // #419
  {19,  1}, // #420
  {20,  1}, // #421
  { 1,  1}, // #422
  { 7,  4}, // #423
  { 8,  2}, // #424
  {10,  1}, // #425
  {11,  1}, // #426
  {12,  1}, // #427
  {14, 10}, // #428
  {18,  2}, // #429
  { 7,  1}, // #430
  {14,  5}, // #431
  {18,  1}, // #432
  { 7,  3}, // #433
  { 8,  2}, // #434
  {10,  1}, // #435
  {11,  1}, // #436
  {12,  1}, // #437
  {14,  5}, // #438
  {18,  1}, // #439
  { 1,  1}, // #440
  { 7,  4}, // #441
  { 8,  2}, // #442
  {10,  1}, // #443
  {11,  1}, // #444
  {12,  1}, // #445
  {14,  5}, // #446
  {18,  2}, // #447
  { 7,  1}, // #448
  {14,  8}, // #449
  {18,  1}, // #450
  { 7,  1}, // #451
  {14, 16}, // #452
  {15,  8}, // #453
  {16,  8}, // #454
  {18,  2}, // #455
  {19,  1}, // #456
  {20,  1}, // #457
  { 1,  2}, // #458
  { 7,  7}, // #459
  { 8,  4}, // #460
  {10,  2}, // #461
  {11,  2}, // #462
  {12,  2}, // #463
  {17,  1}, // #464
  {18,  2}, // #465
  {21,  1}, // #466
  { 1,  1}, // #467
  { 7,  4}, // #468
  { 8,  2}, // #469
  {10,  1}, // #470
  {11,  1}, // #471
  {12,  1}, // #472
  {17,  1}, // #473
  {18,  1}, // #474
  {21,  1}, // #475
  { 5,  1}, // #476
  { 7,  1}, // #477
  {18,  2}, // #478
  {19,  1}, // #479
  {20,  1}, // #480
  { 4,  1}, // #481
  { 7,  1}, // #482
  {12,  1}, // #483
  { 1,  1}, // #484
  { 4,  1}, // #485
  { 7,  2}, // #486
  {12,  1}, // #487
  {18,  1}, // #488
  { 7, 10}, // #489
  { 8,  4}, // #490
  {10,  2}, // #491
  {11,  2}, // #492
  {12,  2}, // #493
  {17,  5}, // #494
  {18,  2}, // #495
  {21,  5}, // #496
  { 7,  5}, // #497
  { 8,  2}, // #498
  {10,  1}, // #499
  {11,  1}, // #500
  {12,  1}, // #501
  {17,  3}, // #502
  {18,  1}, // #503
  {21,  3} // #504
}; // PPCWriteProcResTable

// {Cycles, WriteResourceID}
extern const llvm::MCWriteLatencyEntry PPCWriteLatencyTable[] = {
  { 0,  0}, // Invalid
  { 4, 108}, // #1 P10W_PM_4C
  { 1,  0}, // #2 P10W_DISP_ANY_P10W_DISP_PAIR
  { 3, 103}, // #3 P10W_FX_3C
  { 1,  0}, // #4 P10W_DISP_ANY
  { 4, 101}, // #5 P10W_F2_4C
  { 1,  0}, // #6 P10W_DISP_EVEN_P10W_DISP_ANY
  { 1,  0}, // #7 P10W_DISP_ANY
  { 3, 103}, // #8 P10W_FX_3C
  { 1,  0}, // #9 P10W_DISP_EVEN_P10W_DISP_PAIR
  { 3, 103}, // #10 P10W_FX_3C
  { 1,  0}, // #11 P10W_DISP_ANY
  { 3, 103}, // #12 P10W_FX_3C
  { 1,  0}, // #13 P10W_DISP_EVEN
  { 1,  0}, // #14 P10W_DISP_ANY
  { 0,  0}, // #15 P10W_SX
  { 1,  0}, // #16 P10W_DISP_ANY
  { 7, 112}, // #17 P10W_vMU_7C
  { 1,  0}, // #18 P10W_DISP_ANY
  { 5, 107}, // #19 P10W_MU_5C
  { 1,  0}, // #20 P10W_DISP_ANY
  { 7, 71}, // #21 P10W_BF_7C
  { 1,  0}, // #22 P10W_DISP_EVEN_P10W_DISP_ANY
  { 3, 103}, // #23 P10W_FX_3C
  { 1,  0}, // #24 P10W_DISP_ANY
  { 5, 107}, // #25 P10W_MU_5C
  { 1,  0}, // #26 P10W_DISP_EVEN
  { 3, 103}, // #27 P10W_FX_3C
  { 1,  0}, // #28 P10W_DISP_ANY
  { 5, 100}, // #29 P10W_DX_5C
  { 1,  0}, // #30 P10W_DISP_ANY
  {13, 79}, // #31 P10W_DF_13C
  { 1,  0}, // #32 P10W_DISP_ANY
  {24,  0}, // #33 P10W_DF_24C_P10W_BF_24C
  { 1,  0}, // #34 P10W_DISP_ANY
  {25,  0}, // #35 P10W_DF_25C_P10W_DV_25C
  { 1,  0}, // #36 P10W_DISP_ANY
  {38,  0}, // #37 P10W_DF_38C
  { 1,  0}, // #38 P10W_DISP_ANY
  {59,  0}, // #39 P10W_DF_59C
  { 1,  0}, // #40 P10W_DISP_ANY
  {77,  0}, // #41 P10W_DF_77C
  { 1,  0}, // #42 P10W_DISP_ANY
  { 6,  0}, // #43 P10W_LD_6C
  { 1,  0}, // #44 P10W_DISP_ANY_P10W_DISP_PAIR
  { 3, 109}, // #45 P10W_ST_3C
  { 1,  0}, // #46 P10W_DISP_ANY_P10W_DISP_PAIR
  { 6,  0}, // #47 P10W_LD_6C_P9_LS_6C
  { 1,  0}, // #48 P10W_DISP_EVEN_IP_AGEN_1C
  { 1,  0}, // #49 P10W_DISP_ANY_DISP_1C
  { 3, 109}, // #50 P10W_ST_3C
  { 1,  0}, // #51 P10W_DISP_EVEN
  { 3, 103}, // #52 P10W_FX_3C
  { 1,  0}, // #53 P10W_DISP_ANY
  { 3, 109}, // #54 P10W_ST_3C
  { 1,  0}, // #55 P10W_DISP_EVEN
  { 1,  0}, // #56 P10W_DISP_ANY
  { 6,  0}, // #57 P10W_LD_6C
  { 1,  0}, // #58 P10W_DISP_EVEN_P10W_DISP_PAIR
  { 6,  0}, // #59 P10W_LD_6C
  { 1,  0}, // #60 P10W_DISP_ANY_P10W_DISP_PAIR
  { 6,  0}, // #61 P10W_LD_6C
  { 1,  0}, // #62 P10W_DISP_ANY
  { 6,  0}, // #63 P10W_LD_6C
  { 1,  0}, // #64 P10W_DISP_ANY
  { 6,  0}, // #65 P10W_LD_6C
  { 1,  0}, // #66 P10W_DISP_EVEN_P10W_DISP_PAIR
  { 3, 111}, // #67 P10W_SX_3C
  { 1,  0}, // #68 P10W_DISP_ANY_P10W_DISP_PAIR
  { 6,  0}, // #69 P10W_LD_6C
  { 1,  0}, // #70 P10W_DISP_PAIR
  { 4, 101}, // #71 P10W_F2_4C
  { 3, 109}, // #72 P10W_ST_3C
  { 1,  0}, // #73 P10W_DISP_EVEN_P10W_DISP_PAIR
  { 3, 109}, // #74 P10W_ST_3C
  { 1,  0}, // #75 P10W_DISP_ANY
  { 3, 109}, // #76 P10W_ST_3C
  { 1,  0}, // #77 P10W_DISP_ANY
  { 3, 109}, // #78 P10W_ST_3C
  { 1,  0}, // #79 P10W_DISP_ANY
  { 2,  0}, // #80 P10W_FX_2C_P10W_BR_2C_P9_BR_2C
  { 1,  0}, // #81 P10W_DISP_ANY_DISP_BR_1C
  {13,  0}, // #82 P10W_MFL_13C
  { 1,  0}, // #83 P10W_DISP_EVEN
  { 1,  0}, // #84 P10W_DISP_ANY
  { 3, 111}, // #85 P10W_SX_3C
  { 1,  0}, // #86 P10W_DISP_EVEN
  { 1,  0}, // #87 P10W_DISP_ANY
  {20,  0}, // #88 P10W_DV_20C
  { 1,  0}, // #89 P10W_DISP_ANY
  {27,  0}, // #90 P10W_DV_27C_P10W_BF_27C
  { 1,  0}, // #91 P10W_DISP_ANY
  {41,  0}, // #92 P10W_DV_41C
  { 1,  0}, // #93 P10W_DISP_ANY
  {20,  0}, // #94 P10W_DV_20C
  { 1,  0}, // #95 P10W_DISP_EVEN
  { 3, 103}, // #96 P10W_FX_3C
  { 1,  0}, // #97 P10W_DISP_ANY
  {25,  0}, // #98 P10W_DV_25C
  { 1,  0}, // #99 P10W_DISP_EVEN
  { 3, 103}, // #100 P10W_FX_3C
  { 1,  0}, // #101 P10W_DISP_ANY
  {41,  0}, // #102 P10W_DV_41C
  { 1,  0}, // #103 P10W_DISP_EVEN
  { 3, 103}, // #104 P10W_FX_3C
  { 1,  0}, // #105 P10W_DISP_ANY
  { 3, 103}, // #106 P10W_FX_3C
  { 1,  0}, // #107 P10W_DISP_EVEN
  { 3, 103}, // #108 P10W_FX_3C
  { 1,  0}, // #109 P10W_DISP_ANY
  { 3, 103}, // #110 P10W_FX_3C
  { 1,  0}, // #111 P10W_DISP_ANY
  { 3, 103}, // #112 P10W_FX_3C
  { 1,  0}, // #113 P10W_DISP_ANY
  { 4, 101}, // #114 P10W_F2_4C
  { 1,  0}, // #115 P10W_DISP_PAIR
  { 4, 101}, // #116 P10W_F2_4C
  {27,  0}, // #117 P10W_BF_27C
  { 1,  0}, // #118 P10W_DISP_EVEN
  { 3, 103}, // #119 P10W_FX_3C
  { 1,  0}, // #120 P10W_DISP_ANY
  {36,  0}, // #121 P10W_BF_36C
  { 1,  0}, // #122 P10W_DISP_EVEN_P10W_DISP_ANY
  { 3, 103}, // #123 P10W_FX_3C
  { 1,  0}, // #124 P10W_DISP_ANY
  {26,  0}, // #125 P10W_BF_26C
  { 1,  0}, // #126 P10W_DISP_EVEN_P10W_DISP_ANY
  { 3, 103}, // #127 P10W_FX_3C
  { 1,  0}, // #128 P10W_DISP_ANY
  {22,  0}, // #129 P10W_BF_22C
  { 1,  0}, // #130 P10W_DISP_EVEN_P10W_DISP_ANY
  { 3, 103}, // #131 P10W_FX_3C
  { 1,  0}, // #132 P10W_DISP_ANY
  { 6,  0}, // #133 P10W_LD_6C
  { 1,  0}, // #134 P10W_DISP_PAIR
  { 4, 101}, // #135 P10W_F2_4C
  { 3, 111}, // #136 P10W_SX_3C
  { 1,  0}, // #137 P10W_DISP_ANY_P10W_DISP_EVEN
  { 3, 103}, // #138 P10W_FX_3C
  { 1,  0}, // #139 P10W_DISP_ANY
  { 3, 109}, // #140 P10W_ST_3C
  { 1,  0}, // #141 P10W_DISP_EVEN
  { 3, 103}, // #142 P10W_FX_3C
  { 1,  0}, // #143 P10W_DISP_ANY
  { 3, 109}, // #144 P10W_ST_3C
  { 1,  0}, // #145 P10W_DISP_ANY
  { 3, 103}, // #146 P10W_FX_3C
  { 1,  0}, // #147 P10W_DISP_ANY
  { 3, 109}, // #148 P10W_ST_3C
  { 1,  0}, // #149 P10W_DISP_ANY
  { 3, 103}, // #150 P10W_FX_3C
  { 1,  0}, // #151 P10W_DISP_ANY
  { 6,  0}, // #152 P10W_LD_6C
  { 1,  0}, // #153 P10W_DISP_ANY
  { 3, 109}, // #154 P10W_ST_3C
  { 1,  0}, // #155 P10W_DISP_ANY
  { 3, 109}, // #156 P10W_ST_3C
  { 1,  0}, // #157 P10W_DISP_EVEN
  { 3, 103}, // #158 P10W_FX_3C
  { 1,  0}, // #159 P10W_DISP_ANY
  { 3, 109}, // #160 P10W_ST_3C
  { 1,  0}, // #161 P10W_DISP_ANY
  { 3, 109}, // #162 P10W_ST_3C
  { 1,  0}, // #163 P10W_DISP_ANY
  { 6,  0}, // #164 P10W_LD_6C
  { 1,  0}, // #165 P10W_DISP_EVEN
  {13, 79}, // #166 P10W_DF_13C
  { 1,  0}, // #167 P10W_DISP_ANY
  {13, 79}, // #168 P10W_DF_13C
  { 1,  0}, // #169 P10W_DISP_EVEN
  { 3, 109}, // #170 P10W_ST_3C
  { 1,  0}, // #171 P10W_DISP_ANY
  {61,  0}, // #172 P10W_DF_61C
  { 1,  0}, // #173 P10W_DISP_ANY
  {68,  0}, // #174 P10W_DF_68C
  { 1,  0}, // #175 P10W_DISP_ANY
  {43,  0}, // #176 P10W_DV_43C
  { 1,  0}, // #177 P10W_DISP_ANY
  {47,  0}, // #178 P10W_DV_47C
  { 1,  0}, // #179 P10W_DISP_ANY
  {54,  0}, // #180 P10W_DV_54C
  { 1,  0}, // #181 P10W_DISP_ANY
  {60,  0}, // #182 P10W_DV_60C
  { 1,  0}, // #183 P10W_DISP_ANY
  {75,  0}, // #184 P10W_DV_75C
  { 1,  0}, // #185 P10W_DISP_ANY
  {83,  0}, // #186 P10W_DV_83C
  { 1,  0}, // #187 P10W_DISP_ANY
  { 4, 101}, // #188 P10W_F2_4C
  { 1,  0}, // #189 P10W_DISP_EVEN
  { 4, 108}, // #190 P10W_PM_4C
  { 1,  0}, // #191 P10W_DISP_ANY
  { 3, 103}, // #192 P10W_FX_3C
  { 1,  0}, // #193 P10W_DISP_EVEN
  { 4, 108}, // #194 P10W_PM_4C
  { 1,  0}, // #195 P10W_DISP_ANY
  {10, 106}, // #196 P10W_MM_10C
  { 1,  0}, // #197 P10W_DISP_ANY_P10W_DISP_PAIR
  {10, 106}, // #198 P10W_MM_10C
  { 1,  0}, // #199 P10W_DISP_PAIR
  { 3, 103}, // #200 P10W_FX_3C
  {10, 106}, // #201 P10W_MM_10C
  { 1,  0}, // #202 P10W_DISP_PAIR
  { 3, 103}, // #203 P10W_FX_3C
  {10, 106}, // #204 P10W_MM_10C
  { 1,  0}, // #205 P10W_DISP_PAIR
  { 3, 103}, // #206 P10W_FX_3C
  { 4, 108}, // #207 P10W_PM_4C
  { 1,  0}, // #208 P10W_DISP_EVEN
  { 7, 112}, // #209 P10W_vMU_7C
  { 1,  0}, // #210 P10W_DISP_ANY
  { 7, 78}, // #211 P10W_CY_7C
  { 1,  0}, // #212 P10W_DISP_ANY
  { 7, 71}, // #213 P10W_BF_7C
  { 1,  0}, // #214 P10W_DISP_EVEN
  { 7, 71}, // #215 P10W_BF_7C
  { 1,  0}, // #216 P10W_DISP_ANY
  { 2,  0}, // #217 P9_ALUE_2C
  { 2,  0}, // #218 P9_ALUO_2C_P9_ALU_2C
  { 1,  0}, // #219 IP_EXECE_1C_IP_EXEC_1C
  { 1,  0}, // #220 IP_EXECO_1C_DISP_1C_DISP_3SLOTS_1C
  { 1,  0}, // #221 DISP_1C
  { 3,  0}, // #222 P9_ALU_3C
  { 1,  0}, // #223 IP_EXEC_1C
  { 1,  0}, // #224 DISP_3SLOTS_1C_DISP_1C
  { 3,  0}, // #225 P9_ALUE_3C
  { 3,  0}, // #226 P9_ALUO_3C_P9_PM_3C
  { 1,  0}, // #227 IP_EXECE_1C_IP_EXECO_1C
  { 1,  0}, // #228 IP_EXECO_1C_IP_EXECE_1C
  { 1,  0}, // #229 DISP_1C
  { 7,  0}, // #230 P9_DPE_7C
  { 7,  0}, // #231 P9_DPO_7C_P9_DP_7C_P9_ALU_2C
  { 1,  0}, // #232 IP_EXECE_1C_IP_EXEC_1C
  { 1,  0}, // #233 IP_EXECO_1C_DISP_3SLOTS_1C_DISP_1C_DISP_BR_1C
  { 1,  0}, // #234 DISP_1C
  { 5,  0}, // #235 P9_DP_5C_P9_LS_5C
  { 1,  0}, // #236 IP_EXEC_1C_IP_AGEN_1C
  { 1,  0}, // #237 DISP_3SLOTS_1C_DISP_1C
  { 7,  0}, // #238 P9_DP_7C
  { 3,  0}, // #239 P9_ALU_3C
  { 1,  0}, // #240 IP_EXEC_1C_P9_LS_1C
  { 1,  0}, // #241 IP_EXEC_1C
  { 1,  0}, // #242 DISP_3SLOTS_1C_IP_AGEN_1C
  { 1,  0}, // #243 DISP_1C_DISP_3SLOTS_1C
  { 7,  0}, // #244 P9_ALU_2C_P9_ALU_3C
  { 1,  0}, // #245 IP_EXEC_1C_IP_AGEN_1C
  { 1,  0}, // #246 IP_EXEC_1C
  { 1,  0}, // #247 DISP_3SLOTS_1C_DISP_1C
  { 1,  0}, // #248 DISP_1C_DISP_3SLOTS_1C
  {10,  0}, // #249 P9_ALU_3C
  { 1,  0}, // #250 IP_EXEC_1C
  { 1,  0}, // #251 IP_EXEC_1C
  { 1,  0}, // #252 DISP_3SLOTS_1C
  { 1,  0}, // #253 DISP_1C
  {12,  0}, // #254 P9_DFU_12C_P9_DIV_12C
  { 1,  0}, // #255 IP_EXECE_1C
  { 1,  0}, // #256 IP_EXECO_1C
  { 1,  0}, // #257 DISP_1C_DISP_EVEN_1C
  {23,  0}, // #258 P9_DFU_23C
  { 1,  0}, // #259 IP_EXECE_1C
  { 1,  0}, // #260 IP_EXECO_1C
  { 1,  0}, // #261 DISP_1C
  {24,  0}, // #262 P9_DFU_24C_P9_DIV_24C_8
  { 1,  0}, // #263 IP_EXECE_1C_IP_EXECO_1C
  { 1,  0}, // #264 IP_EXECO_1C_IP_EXECE_1C
  { 1,  0}, // #265 DISP_1C_DISP_EVEN_1C
  {37,  0}, // #266 P9_DFU_37C
  { 1,  0}, // #267 IP_EXECE_1C
  { 1,  0}, // #268 IP_EXECO_1C
  { 1,  0}, // #269 DISP_1C
  {58,  0}, // #270 P9_DFU_58C
  { 1,  0}, // #271 IP_EXECE_1C
  { 1,  0}, // #272 IP_EXECO_1C
  { 1,  0}, // #273 DISP_1C
  {76,  0}, // #274 P9_DFU_76C
  { 1,  0}, // #275 IP_EXECE_1C
  { 1,  0}, // #276 IP_EXECO_1C
  { 1,  0}, // #277 DISP_1C
  { 4,  0}, // #278 P9_LS_4C
  { 1,  0}, // #279 IP_AGEN_1C
  { 1,  0}, // #280 DISP_1C_DISP_3SLOTS_1C
  { 4,  0}, // #281 P9_LS_4C
  { 4,  0}, // #282 P9_LS_4C
  { 1,  0}, // #283 IP_AGEN_1C
  { 1,  0}, // #284 IP_AGEN_1C
  { 1,  0}, // #285 DISP_PAIR_1C
  { 4,  0}, // #286 P9_LS_4C
  { 2,  0}, // #287 P9_ALU_2C
  { 1,  0}, // #288 IP_EXEC_1C_IP_AGEN_1C
  { 1,  0}, // #289 IP_AGEN_1C_IP_EXEC_1C
  { 1,  0}, // #290 DISP_PAIR_1C_DISP_1C_DISP_3SLOTS_1C
  { 1,  0}, // #291 DISP_PAIR_1C_DISP_1C
  { 3,  0}, // #292 P9_ALU_2C
  { 1,  0}, // #293 IP_EXEC_1C_P9_LS_1C
  { 1,  0}, // #294 IP_EXEC_1C_IP_EXECE_1C
  { 1,  0}, // #295 IP_AGEN_1C_IP_EXECO_1C
  { 1,  0}, // #296 DISP_3SLOTS_1C_IP_AGEN_1C
  { 1,  0}, // #297 DISP_1C
  { 8,  0}, // #298 P9_LS_4C_P9_ALU_3C
  { 1,  0}, // #299 IP_AGEN_1C
  { 1,  0}, // #300 IP_AGEN_1C_IP_EXEC_1C
  { 1,  0}, // #301 DISP_1C
  { 1,  0}, // #302 DISP_1C
  { 6,  0}, // #303 P9_ALU_2C_P9_ALU_3C_P9_CY_6C
  { 1,  0}, // #304 IP_EXEC_1C_IP_EXECO_1C
  { 1,  0}, // #305 IP_AGEN_1C_IP_EXEC_1C_IP_EXECE_1C
  { 1,  0}, // #306 DISP_1C_DISP_3SLOTS_1C
  { 1,  0}, // #307 DISP_1C_DISP_3SLOTS_1C
  { 6,  0}, // #308 P9_ALU_2C
  { 2,  0}, // #309 P9_ALU_2C
  { 1,  0}, // #310 IP_AGEN_1C
  { 1,  0}, // #311 IP_EXEC_1C
  { 1,  0}, // #312 IP_EXEC_1C
  { 1,  0}, // #313 DISP_PAIR_1C
  { 1,  0}, // #314 DISP_PAIR_1C
  { 1,  0}, // #315 DISP_1C
  { 8,  0}, // #316 P9_PM_3C
  { 1,  0}, // #317 IP_AGEN_1C
  { 1,  0}, // #318 IP_EXECE_1C
  { 1,  0}, // #319 IP_EXECO_1C
  { 1,  0}, // #320 DISP_1C
  { 1,  0}, // #321 DISP_1C
  { 5,  0}, // #322 P9_DIV_5C
  { 1,  0}, // #323 IP_EXECE_1C
  { 1,  0}, // #324 IP_EXECO_1C
  { 1,  0}, // #325 DISP_EVEN_1C
  {16,  0}, // #326 P9_DIV_16C_8
  { 1,  0}, // #327 IP_EXECO_1C
  { 1,  0}, // #328 IP_EXECE_1C
  { 1,  0}, // #329 DISP_EVEN_1C
  {40,  0}, // #330 P9_DIV_40C_8
  { 1,  0}, // #331 IP_EXECO_1C
  { 1,  0}, // #332 IP_EXECE_1C
  { 1,  0}, // #333 DISP_EVEN_1C
  {18,  0}, // #334 P9_ALU_2C
  { 1,  0}, // #335 IP_EXECE_1C
  { 1,  0}, // #336 IP_EXECO_1C
  { 1,  0}, // #337 IP_EXEC_1C
  { 1,  0}, // #338 DISP_EVEN_1C
  { 1,  0}, // #339 DISP_1C
  {26,  0}, // #340 P9_ALU_2C
  { 1,  0}, // #341 IP_EXECE_1C
  { 1,  0}, // #342 IP_EXECO_1C
  { 1,  0}, // #343 IP_EXEC_1C
  { 1,  0}, // #344 DISP_EVEN_1C
  { 1,  0}, // #345 DISP_1C
  {42,  0}, // #346 P9_ALU_2C
  { 1,  0}, // #347 IP_EXECE_1C
  { 1,  0}, // #348 IP_EXECO_1C
  { 1,  0}, // #349 IP_EXEC_1C
  { 1,  0}, // #350 DISP_EVEN_1C
  { 1,  0}, // #351 DISP_1C
  { 2,  0}, // #352 P9_ALU_2C
  { 2,  0}, // #353 P9_ALU_2C
  { 1,  0}, // #354 IP_EXEC_1C
  { 1,  0}, // #355 IP_EXEC_1C
  { 1,  0}, // #356 DISP_3SLOTS_1C_DISP_1C
  { 1,  0}, // #357 DISP_3SLOTS_1C_DISP_1C
  { 2,  0}, // #358 P9_ALU_2C
  { 3,  0}, // #359 P9_ALU_3C
  { 1,  0}, // #360 IP_EXEC_1C
  { 1,  0}, // #361 IP_EXEC_1C
  { 1,  0}, // #362 DISP_3SLOTS_1C
  { 1,  0}, // #363 DISP_1C
  { 3,  0}, // #364 P9_ALU_3C
  { 3,  0}, // #365 P9_ALU_3C
  { 1,  0}, // #366 IP_EXEC_1C
  { 1,  0}, // #367 IP_EXEC_1C
  { 1,  0}, // #368 DISP_1C_DISP_3SLOTS_1C
  { 1,  0}, // #369 DISP_1C_DISP_3SLOTS_1C
  { 4,  0}, // #370 P9_ALU_2C
  { 1,  0}, // #371 IP_EXEC_1C
  { 1,  0}, // #372 IP_EXEC_1C
  { 1,  0}, // #373 DISP_3SLOTS_1C_DISP_1C
  { 1,  0}, // #374 DISP_1C
  { 6,  0}, // #375 P9_ALU_2C
  { 1,  0}, // #376 IP_EXEC_1C
  { 1,  0}, // #377 IP_EXEC_1C
  { 1,  0}, // #378 IP_EXEC_1C
  { 1,  0}, // #379 DISP_3SLOTS_1C
  { 1,  0}, // #380 DISP_3SLOTS_1C
  { 1,  0}, // #381 DISP_3SLOTS_1C
  {33,  0}, // #382 P9_DP_33C_8
  { 1,  0}, // #383 IP_EXEC_1C
  { 1,  0}, // #384 DISP_3SLOTS_1C_DISP_1C
  {36,  0}, // #385 P9_ALU_3C_P9_DP_36C_10
  { 1,  0}, // #386 IP_EXEC_1C
  { 1,  0}, // #387 IP_EXEC_1C_DISP_1C_DISP_3SLOTS_1C
  { 1,  0}, // #388 DISP_3SLOTS_1C
  { 1,  0}, // #389 DISP_1C
  {36,  0}, // #390 P9_DPE_36C_10
  {36,  0}, // #391 P9_DPO_36C_10
  { 1,  0}, // #392 IP_EXECE_1C
  { 1,  0}, // #393 IP_EXECO_1C
  { 1,  0}, // #394 DISP_1C
  {27,  0}, // #395 P9_DPE_27C_10
  {27,  0}, // #396 P9_DPO_27C_10
  { 1,  0}, // #397 IP_EXECE_1C
  { 1,  0}, // #398 IP_EXECO_1C
  { 1,  0}, // #399 DISP_1C
  {39,  0}, // #400 P9_ALU_3C
  { 1,  0}, // #401 IP_EXEC_1C
  { 1,  0}, // #402 IP_EXEC_1C
  { 1,  0}, // #403 DISP_3SLOTS_1C
  { 1,  0}, // #404 DISP_1C
  {22,  0}, // #405 P9_DP_26C_5_P9_DP_22C_5
  { 1,  0}, // #406 IP_EXEC_1C
  { 1,  0}, // #407 DISP_1C_DISP_3SLOTS_1C
  {25,  0}, // #408 P9_ALU_3C
  { 1,  0}, // #409 IP_EXEC_1C
  { 1,  0}, // #410 IP_EXEC_1C
  { 1,  0}, // #411 DISP_3SLOTS_1C
  { 1,  0}, // #412 DISP_1C
  {24,  0}, // #413 P9_DPE_24C_8
  {24,  0}, // #414 P9_DPO_24C_8
  { 1,  0}, // #415 IP_EXECE_1C
  { 1,  0}, // #416 IP_EXECO_1C
  { 1,  0}, // #417 DISP_1C
  {33,  0}, // #418 P9_DPE_33C_8
  {33,  0}, // #419 P9_DPO_33C_8
  { 1,  0}, // #420 IP_EXECE_1C
  { 1,  0}, // #421 IP_EXECO_1C
  { 1,  0}, // #422 DISP_1C
  { 7,  0}, // #423 P9_ALU_3C
  { 2,  0}, // #424 P9_ALU_2C
  { 1,  0}, // #425 IP_AGEN_1C
  { 1,  0}, // #426 IP_EXEC_1C
  { 1,  0}, // #427 IP_EXEC_1C
  { 1,  0}, // #428 DISP_3SLOTS_1C
  { 1,  0}, // #429 DISP_3SLOTS_1C
  { 1,  0}, // #430 DISP_1C
  { 1,  0}, // #431 P9_LS_1C
  { 2,  0}, // #432 P9_ALU_2C
  { 1,  0}, // #433 IP_AGEN_1C
  { 1,  0}, // #434 IP_EXEC_1C
  { 1,  0}, // #435 IP_EXEC_1C
  { 1,  0}, // #436 DISP_3SLOTS_1C
  { 1,  0}, // #437 DISP_1C
  { 1,  0}, // #438 P9_LS_1C
  { 1,  0}, // #439 P9_LS_1C
  { 4,  0}, // #440 P9_LS_4C
  { 4,  0}, // #441 P9_LS_4C
  { 4,  0}, // #442 P9_LS_4C
  { 1,  0}, // #443 IP_EXEC_1C
  { 1,  0}, // #444 IP_EXEC_1C
  { 1,  0}, // #445 IP_AGEN_1C
  { 1,  0}, // #446 IP_AGEN_1C
  { 1,  0}, // #447 IP_AGEN_1C
  { 1,  0}, // #448 IP_AGEN_1C
  { 1,  0}, // #449 IP_AGEN_1C
  { 1,  0}, // #450 DISP_1C
  { 1,  0}, // #451 DISP_3SLOTS_1C
  { 1,  0}, // #452 DISP_3SLOTS_1C
  { 1,  0}, // #453 DISP_1C
  { 1,  0}, // #454 DISP_1C
  { 1,  0}, // #455 DISP_1C
  { 1,  0}, // #456 P9_LS_1C
  { 4,  0}, // #457 P9_LS_4C
  { 4,  0}, // #458 P9_LS_4C
  { 1,  0}, // #459 IP_EXEC_1C
  { 1,  0}, // #460 IP_AGEN_1C
  { 1,  0}, // #461 IP_AGEN_1C
  { 1,  0}, // #462 IP_AGEN_1C
  { 1,  0}, // #463 DISP_1C
  { 1,  0}, // #464 DISP_3SLOTS_1C
  { 1,  0} // #465 DISP_1C
}; // PPCWriteLatencyTable

// {UseIdx, WriteResourceID, Cycles}
extern const llvm::MCReadAdvanceEntry PPCReadAdvanceTable[] = {
  {0,  0,  0}, // Invalid
  {0, 101,  1}, // #1
  {0, 103,  1}, // #2
  {0, 108,  1}, // #3
  {0, 109,  1}, // #4
  {0, 111,  1}, // #5
  {1, 101,  1}, // #6
  {1, 103,  1}, // #7
  {1, 108,  1}, // #8
  {1, 109,  1}, // #9
  {1, 111,  1}, // #10
  {0, 101,  1}, // #11
  {0, 103,  1}, // #12
  {0, 108,  1}, // #13
  {0, 109,  1}, // #14
  {0, 111,  1}, // #15
  {1, 101,  1}, // #16
  {1, 103,  1}, // #17
  {1, 108,  1}, // #18
  {1, 109,  1}, // #19
  {1, 111,  1}, // #20
  {2, 101,  1}, // #21
  {2, 103,  1}, // #22
  {2, 108,  1}, // #23
  {2, 109,  1}, // #24
  {2, 111,  1}, // #25
  {0, 101,  1}, // #26
  {0, 103,  1}, // #27
  {0, 108,  1}, // #28
  {0, 109,  1}, // #29
  {0, 111,  1}, // #30
  {1, 101,  1}, // #31
  {1, 103,  1}, // #32
  {1, 108,  1}, // #33
  {1, 109,  1}, // #34
  {1, 111,  1}, // #35
  {2, 101,  1}, // #36
  {2, 103,  1}, // #37
  {2, 108,  1}, // #38
  {2, 109,  1}, // #39
  {2, 111,  1}, // #40
  {3, 101,  1}, // #41
  {3, 103,  1}, // #42
  {3, 108,  1}, // #43
  {3, 109,  1}, // #44
  {3, 111,  1}, // #45
  {4, 101,  1}, // #46
  {4, 103,  1}, // #47
  {4, 108,  1}, // #48
  {4, 109,  1}, // #49
  {4, 111,  1}, // #50
  {0, 71,  1}, // #51
  {0, 78,  1}, // #52
  {0, 79,  1}, // #53
  {0, 100,  1}, // #54
  {0, 106,  1}, // #55
  {0, 107,  1}, // #56
  {0, 112,  1}, // #57
  {1, 71,  1}, // #58
  {1, 78,  1}, // #59
  {1, 79,  1}, // #60
  {1, 100,  1}, // #61
  {1, 106,  1}, // #62
  {1, 107,  1}, // #63
  {1, 112,  1}, // #64
  {2, 71,  1}, // #65
  {2, 78,  1}, // #66
  {2, 79,  1}, // #67
  {2, 100,  1}, // #68
  {2, 106,  1}, // #69
  {2, 107,  1}, // #70
  {2, 112,  1}, // #71
  {0, 79,  1}, // #72
  {0, 100,  1}, // #73
  {0, 107,  1}, // #74
  {1, 79,  1}, // #75
  {1, 100,  1}, // #76
  {1, 107,  1}, // #77
  {2, 79,  1}, // #78
  {2, 100,  1}, // #79
  {2, 107,  1}, // #80
  {0, 101,  1}, // #81
  {0, 103,  1}, // #82
  {0, 109,  1}, // #83
  {0, 111,  1}, // #84
  {1, 101,  1}, // #85
  {1, 103,  1}, // #86
  {1, 109,  1}, // #87
  {1, 111,  1}, // #88
  {0, 101,  1}, // #89
  {0, 103,  1}, // #90
  {0, 106,  1}, // #91
  {0, 108,  1}, // #92
  {0, 109,  1}, // #93
  {0, 111,  1}, // #94
  {0, 101,  1}, // #95
  {0, 103,  1}, // #96
  {0, 106,  1}, // #97
  {0, 108,  1}, // #98
  {0, 109,  1}, // #99
  {0, 111,  1}, // #100
  {1, 101,  1}, // #101
  {1, 103,  1}, // #102
  {1, 106,  1}, // #103
  {1, 108,  1}, // #104
  {1, 109,  1}, // #105
  {1, 111,  1}, // #106
  {0, 101,  1}, // #107
  {0, 103,  1}, // #108
  {1, 101,  1}, // #109
  {1, 103,  1}, // #110
  {2, 101,  1}, // #111
  {2, 103,  1}, // #112
  {3, 101,  1}, // #113
  {3, 103,  1}, // #114
  {0, 71,  2}, // #115
  {1, 71,  2}, // #116
  {2, 71,  2}, // #117
  {0, 78,  1}, // #118
  {0, 79,  1}, // #119
  {0, 100,  1}, // #120
  {0, 106,  1}, // #121
  {0, 107,  1}, // #122
  {0, 112,  1}, // #123
  {1, 78,  1}, // #124
  {1, 79,  1}, // #125
  {1, 100,  1}, // #126
  {1, 106,  1}, // #127
  {1, 107,  1}, // #128
  {1, 112,  1}, // #129
  {2, 78,  1}, // #130
  {2, 79,  1}, // #131
  {2, 100,  1}, // #132
  {2, 106,  1}, // #133
  {2, 107,  1}, // #134
  {2, 112,  1}, // #135
  {0, 78,  3}, // #136
  {1, 78,  3}, // #137
  {0, 71,  1}, // #138
  {0, 79,  1}, // #139
  {0, 100,  1}, // #140
  {0, 106,  1}, // #141
  {0, 107,  1}, // #142
  {0, 112,  1}, // #143
  {1, 71,  1}, // #144
  {1, 79,  1}, // #145
  {1, 100,  1}, // #146
  {1, 106,  1}, // #147
  {1, 107,  1}, // #148
  {1, 112,  1}, // #149
  {0, 106,  6}, // #150
  {1, 106,  6}, // #151
  {0, 71,  1}, // #152
  {0, 78,  1}, // #153
  {0, 79,  1}, // #154
  {0, 100,  1}, // #155
  {0, 107,  1}, // #156
  {0, 112,  1}, // #157
  {1, 71,  1}, // #158
  {1, 78,  1}, // #159
  {1, 79,  1}, // #160
  {1, 100,  1}, // #161
  {1, 107,  1}, // #162
  {1, 112,  1}, // #163
  {0, 106,  6}, // #164
  {1, 106,  6}, // #165
  {2, 106,  6}, // #166
  {0, 71,  1}, // #167
  {0, 78,  1}, // #168
  {0, 79,  1}, // #169
  {0, 100,  1}, // #170
  {0, 107,  1}, // #171
  {0, 112,  1}, // #172
  {1, 71,  1}, // #173
  {1, 78,  1}, // #174
  {1, 79,  1}, // #175
  {1, 100,  1}, // #176
  {1, 107,  1}, // #177
  {1, 112,  1}, // #178
  {2, 71,  1}, // #179
  {2, 78,  1}, // #180
  {2, 79,  1}, // #181
  {2, 100,  1}, // #182
  {2, 107,  1}, // #183
  {2, 112,  1}, // #184
  {0, 106,  6}, // #185
  {1, 106,  6}, // #186
  {2, 106,  6}, // #187
  {3, 106,  6}, // #188
  {0, 71,  1}, // #189
  {0, 78,  1}, // #190
  {0, 79,  1}, // #191
  {0, 100,  1}, // #192
  {0, 107,  1}, // #193
  {0, 112,  1}, // #194
  {1, 71,  1}, // #195
  {1, 78,  1}, // #196
  {1, 79,  1}, // #197
  {1, 100,  1}, // #198
  {1, 107,  1}, // #199
  {1, 112,  1}, // #200
  {2, 71,  1}, // #201
  {2, 78,  1}, // #202
  {2, 79,  1}, // #203
  {2, 100,  1}, // #204
  {2, 107,  1}, // #205
  {2, 112,  1}, // #206
  {3, 71,  1}, // #207
  {3, 78,  1}, // #208
  {3, 79,  1}, // #209
  {3, 100,  1}, // #210
  {3, 107,  1}, // #211
  {3, 112,  1}, // #212
  {0, 106,  6}, // #213
  {1, 106,  6}, // #214
  {2, 106,  6}, // #215
  {3, 106,  6}, // #216
  {4, 106,  6}, // #217
  {0, 71,  1}, // #218
  {0, 78,  1}, // #219
  {0, 79,  1}, // #220
  {0, 100,  1}, // #221
  {0, 107,  1}, // #222
  {0, 112,  1}, // #223
  {1, 71,  1}, // #224
  {1, 78,  1}, // #225
  {1, 79,  1}, // #226
  {1, 100,  1}, // #227
  {1, 107,  1}, // #228
  {1, 112,  1}, // #229
  {2, 71,  1}, // #230
  {2, 78,  1}, // #231
  {2, 79,  1}, // #232
  {2, 100,  1}, // #233
  {2, 107,  1}, // #234
  {2, 112,  1}, // #235
  {3, 71,  1}, // #236
  {3, 78,  1}, // #237
  {3, 79,  1}, // #238
  {3, 100,  1}, // #239
  {3, 107,  1}, // #240
  {3, 112,  1}, // #241
  {4, 71,  1}, // #242
  {4, 78,  1}, // #243
  {4, 79,  1}, // #244
  {4, 100,  1}, // #245
  {4, 107,  1}, // #246
  {4, 112,  1}, // #247
  {0, 106,  6}, // #248
  {1, 106,  6}, // #249
  {2, 106,  6}, // #250
  {3, 106,  6}, // #251
  {4, 106,  6}, // #252
  {5, 106,  6}, // #253
  {0, 71,  1}, // #254
  {0, 78,  1}, // #255
  {0, 79,  1}, // #256
  {0, 100,  1}, // #257
  {0, 107,  1}, // #258
  {0, 112,  1}, // #259
  {1, 71,  1}, // #260
  {1, 78,  1}, // #261
  {1, 79,  1}, // #262
  {1, 100,  1}, // #263
  {1, 107,  1}, // #264
  {1, 112,  1}, // #265
  {2, 71,  1}, // #266
  {2, 78,  1}, // #267
  {2, 79,  1}, // #268
  {2, 100,  1}, // #269
  {2, 107,  1}, // #270
  {2, 112,  1}, // #271
  {3, 71,  1}, // #272
  {3, 78,  1}, // #273
  {3, 79,  1}, // #274
  {3, 100,  1}, // #275
  {3, 107,  1}, // #276
  {3, 112,  1}, // #277
  {4, 71,  1}, // #278
  {4, 78,  1}, // #279
  {4, 79,  1}, // #280
  {4, 100,  1}, // #281
  {4, 107,  1}, // #282
  {4, 112,  1}, // #283
  {5, 71,  1}, // #284
  {5, 78,  1}, // #285
  {5, 79,  1}, // #286
  {5, 100,  1}, // #287
  {5, 107,  1}, // #288
  {5, 112,  1} // #289
}; // PPCReadAdvanceTable

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc P10ModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD("IIC_LdStSync")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1
  {DBGFIELD("IIC_IntSimple")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2
  {DBGFIELD("IIC_IntGeneral")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #3
  {DBGFIELD("IIC_BrB")            8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #4
  {DBGFIELD("IIC_VecFP")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #5
  {DBGFIELD("IIC_IntCompare")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #6
  {DBGFIELD("IIC_SprABORT")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #7
  {DBGFIELD("IIC_LdStCOPY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #8
  {DBGFIELD("IIC_LdStPASTE")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #9
  {DBGFIELD("IIC_BrCR")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #10
  {DBGFIELD("IIC_LdStLD")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #11
  {DBGFIELD("IIC_LdStDCBF")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #12
  {DBGFIELD("IIC_LdStLoad")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #13
  {DBGFIELD("IIC_IntDivD")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #14
  {DBGFIELD("IIC_IntDivW")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #15
  {DBGFIELD("IIC_FPDGeneral")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #16
  {DBGFIELD("IIC_FPAddSub")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #17
  {DBGFIELD("IIC_FPDivD")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #18
  {DBGFIELD("IIC_FPSGeneral")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #19
  {DBGFIELD("IIC_FPCompare")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #20
  {DBGFIELD("IIC_FPGeneral")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #21
  {DBGFIELD("IIC_VecGeneral")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #22
  {DBGFIELD("IIC_VecComplex")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #23
  {DBGFIELD("IIC_LdStStore")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #24
  {DBGFIELD("IIC_IntRotateDI")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #25
  {DBGFIELD("IIC_FPDivS")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #26
  {DBGFIELD("IIC_FPFused")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #27
  {DBGFIELD("IIC_FPSqrtD")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #28
  {DBGFIELD("IIC_FPSqrtS")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #29
  {DBGFIELD("IIC_LdStICBI")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #30
  {DBGFIELD("IIC_IntISEL")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #31
  {DBGFIELD("IIC_SprISYNC")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #32
  {DBGFIELD("IIC_LdStLWARX")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #33
  {DBGFIELD("IIC_LdStLoadUpd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #34
  {DBGFIELD("IIC_LdStLoadUpdX")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #35
  {DBGFIELD("IIC_LdStLDARX")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #36
  {DBGFIELD("IIC_LdStLDU")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #37
  {DBGFIELD("IIC_LdStLDUX")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #38
  {DBGFIELD("IIC_LdStLFD")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #39
  {DBGFIELD("IIC_LdStLFDU")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #40
  {DBGFIELD("IIC_LdStLFDUX")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #41
  {DBGFIELD("IIC_LdStLHA")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #42
  {DBGFIELD("IIC_LdStLHAU")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #43
  {DBGFIELD("IIC_LdStLHAUX")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #44
  {DBGFIELD("IIC_LdStLMW")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #45
  {DBGFIELD("IIC_LdStLQ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #46
  {DBGFIELD("IIC_LdStLQARX")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #47
  {DBGFIELD("IIC_LdStLWA")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #48
  {DBGFIELD("IIC_IntMulHD")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #49
  {DBGFIELD("IIC_BrMCR")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #50
  {DBGFIELD("IIC_BrMCRX")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #51
  {DBGFIELD("IIC_SprMFCR")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #52
  {DBGFIELD("IIC_SprMFSPR")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #53
  {DBGFIELD("IIC_IntMFFS")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #54
  {DBGFIELD("IIC_SprMFMSR")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #55
  {DBGFIELD("IIC_SprMFCRF")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #56
  {DBGFIELD("IIC_SprMFPMR")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #57
  {DBGFIELD("IIC_SprMFSR")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #58
  {DBGFIELD("IIC_SprMFTB")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #59
  {DBGFIELD("IIC_SprMSGSYNC")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #60
  {DBGFIELD("IIC_SprMTSPR")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #61
  {DBGFIELD("IIC_IntMTFSB0")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #62
  {DBGFIELD("IIC_SprMTMSR")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #63
  {DBGFIELD("IIC_SprMTMSRD")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #64
  {DBGFIELD("IIC_SprMTPMR")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #65
  {DBGFIELD("IIC_SprMTSR")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #66
  {DBGFIELD("IIC_IntMulHW")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #67
  {DBGFIELD("IIC_IntMulHWU")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #68
  {DBGFIELD("IIC_IntMulLI")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #69
  {DBGFIELD("IIC_SprRFI")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #70
  {DBGFIELD("IIC_IntRFID")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #71
  {DBGFIELD("IIC_IntRotateD")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #72
  {DBGFIELD("IIC_IntRotate")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #73
  {DBGFIELD("IIC_SprSLBFEE")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #74
  {DBGFIELD("IIC_SprSLBIA")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #75
  {DBGFIELD("IIC_SprSLBIE")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #76
  {DBGFIELD("IIC_SprSLBIEG")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #77
  {DBGFIELD("IIC_SprSLBMFEE")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #78
  {DBGFIELD("IIC_SprSLBMFEV")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #79
  {DBGFIELD("IIC_SprSLBMTE")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #80
  {DBGFIELD("IIC_SprSLBSYNC")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #81
  {DBGFIELD("IIC_IntShift")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #82
  {DBGFIELD("IIC_LdStSTWCX")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #83
  {DBGFIELD("IIC_LdStSTU")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #84
  {DBGFIELD("IIC_LdStSTUX")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #85
  {DBGFIELD("IIC_LdStSTD")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #86
  {DBGFIELD("IIC_LdStSTDCX")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #87
  {DBGFIELD("IIC_LdStSTFD")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #88
  {DBGFIELD("IIC_LdStSTFDU")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #89
  {DBGFIELD("IIC_SprSTOP")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #90
  {DBGFIELD("IIC_LdStSTQ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #91
  {DBGFIELD("IIC_LdStSTQCX")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #92
  {DBGFIELD("IIC_IntTrapD")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #93
  {DBGFIELD("IIC_SprTLBIA")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #94
  {DBGFIELD("IIC_SprTLBIE")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #95
  {DBGFIELD("IIC_SprTLBIEL")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #96
  {DBGFIELD("IIC_SprTLBSYNC")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #97
  {DBGFIELD("IIC_IntTrapW")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #98
  {DBGFIELD("IIC_VecFPCompare")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #99
  {DBGFIELD("IIC_VecPerm")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #100
  {DBGFIELD("VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VSLD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_VPOPCNTB_VPOPCNTH_VSRAD_MTVSRDD_VEQV_VNAND_VNEGD_VNEGW_VORC_XXLAND_XXLANDC_XXLEQV_XXLEQVOnes_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz") 1, false, false, false,  1, 2,  1, 2,  1, 10}, // #101
  {DBGFIELD("VAND_VANDC_V_SET0_V_SET0B_V_SET0H_VSLB_VSLH_VSLW_VSRB_VSRH_VSRW_VRLB_VRLD_VRLH_VRLW_VSRAB_VSRAH_VSRAW_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP_XVXEXPDP_XVXEXPSP_VRLDMI_VRLDNM_VRLWMI_VRLWNM_VMRGEW_VMRGOW_VNOR_VOR_VSEL_VXOR_XVNEGDP_XVNEGSP_XSABSQP_XSCPSGNQP_XSIEXPQP_XSNABSQP_XSNEGQP_XSXEXPQP") 1, false, false, false,  3, 2,  3, 2, 11, 15}, // #102
  {DBGFIELD("XXSEL")              1, false, false, false,  3, 2,  3, 2, 11, 15}, // #103
  {DBGFIELD("TABORTDC_TABORTDCI_TABORTWC_TABORTWCI") 1, false, false, false,  5, 3,  5, 3, 11, 15}, // #104
  {DBGFIELD("MTFSB0_MTFSB1")      2, false, false, false,  8, 3,  8, 4,  1, 5}, // #105
  {DBGFIELD("MFFSCDRN_MFFSCDRNI_MFFSCRN_MFFSCRNI") 1, false, false, false,  5, 3, 12, 3,  1, 5}, // #106
  {DBGFIELD("CMPRB_CMPRB8_CMPEQB") 1, false, false, false,  3, 2,  5, 2, 11, 15}, // #107
  {DBGFIELD("TD_TDI")             1, false, false, false,  3, 2,  5, 2, 11, 15}, // #108
  {DBGFIELD("TW_TWI")             1, false, false, false,  3, 2,  5, 2, 11, 15}, // #109
  {DBGFIELD("FCMPOD_FCMPOS_FCMPUD_FCMPUS_FTDIV_FTSQRT") 1, false, false, false,  3, 2,  5, 2,  1, 10}, // #110
  {DBGFIELD("XSTSTDCDP_XSTSTDCSP") 1, false, false, false,  3, 2,  5, 2,  1, 10}, // #111
  {DBGFIELD("XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP_XSXSIGDP_XSCVSPDPN") 1, false, false, false,  3, 2,  3, 2,  1, 5}, // #112
  {DBGFIELD("XSCMPEQDP_XSCMPEXPDP_XSCMPGEDP_XSCMPGTDP_XSCMPODP_XSCMPUDP_XSTDIVDP_XSTSQRTDP") 1, false, false, false,  3, 2,  5, 2,  1, 10}, // #113
  {DBGFIELD("CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW_CMPB_CMPB8_SETB_SETB8_BPERMD") 1, false, false, false,  1, 2,  1, 2,  1, 10}, // #114
  {DBGFIELD("SLD_SRD_SRAD")       1, false, false, false,  3, 2,  3, 2,  1, 10}, // #115
  {DBGFIELD("SRADI_EXTSWSLI_32_64_EXTSWSLI_SRADI_32_RLDIC") 1, false, false, false,  3, 2,  3, 2, 11, 15}, // #116
  {DBGFIELD("MFVRD_MFVSRD_MTVRD_MTVSRD_MTVRWA_MTVRWZ_MTVSRWA_MTVSRWZ_MFVSRWZ_MFVRWZ") 1, false, false, false,  3, 2,  3, 2,  1, 5}, // #117
  {DBGFIELD("CMPLW_CMPLWI_CMPW_CMPWI_CMPD_CMPDI_CMPLD_CMPLDI") 1, false, false, false,  3, 2,  3, 2,  1, 10}, // #118
  {DBGFIELD("SUBFC_SUBFC8_SUBFC8O_SUBFCO_SUBFIC_SUBFIC8_ANDI8_rec_ANDIS8_rec_ANDIS_rec_ANDI_rec_ADDC_ADDC8_ADDC8O_ADDCO_ADDIC_ADDIC8_ADDIC_rec_ADDE_ADDE8_ADDE8O_ADDE8O_rec_ADDE8_rec_ADDEO_ADDEO_rec_ADDE_rec_ADDME_ADDME8_ADDME8O_ADDME8O_rec_ADDME8_rec_ADDMEO_ADDMEO_rec_ADDME_rec_ADDZE_ADDZE8_ADDZE8O_ADDZE8O_rec_ADDZE8_rec_ADDZEO_ADDZEO_rec_ADDZE_rec_SUBF_SUBF8_SUBF8O_SUBF8O_rec_SUBF8_rec_SUBFE_SUBFE8_SUBFE8O_SUBFE8O_rec_SUBFE8_rec_SUBFEO_SUBFEO_rec_SUBFE_rec_SUBFME_SUBFME8_SUBFME8O_SUBFME8O_rec_SUBFME8_rec_SUBFMEO_SUBFMEO_rec_SUBFME_rec_SUBFO_SUBFO_rec_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZE8O_rec_SUBFZE8_rec_SUBFZEO_SUBFZEO_rec_SUBFZE_rec_SUBF_rec_POPCNTB_POPCNTB8_LA_LA8") 1, false, false, false, 11, 2, 15, 2,  0, 0}, // #119
  {DBGFIELD("ADD4_ADD4O_ADD4O_rec_ADD4_rec_ADD8_ADD8O_ADD8O_rec_ADD8_rec_NEG_NEG8_NEG8O_NEG8O_rec_NEG8_rec_NEGO_NEGO_rec_NEG_rec_ADDI_ADDI8_ADDIS_ADDIS8_LI_LI8_LIS_LIS8_OR_OR8_OR8_rec_ORI_ORI8_ORIS_ORIS8_OR_rec_XOR_XOR8_XOR8_rec_XORI_XORI8_XORIS_XORIS8_XOR_rec_NAND_NAND8_NAND8_rec_NAND_rec_AND_AND8_AND8_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_AND_rec_NOR_NOR8_NOR8_rec_NOR_rec_ORC_ORC8_ORC8_rec_ORC_rec_EQV_EQV8_EQV8_rec_EQV_rec_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_ADD4TLS_ADD8TLS_ADD8TLS__NOP") 1, false, false, false,  5, 3, 12, 3,  1, 10}, // #120
  {DBGFIELD("ADDIStocHA_ADDIStocHA8_ADDItocL_COPY") 1, false, false, false,  3, 2,  3, 2,  1, 10}, // #121
  {DBGFIELD("MCRF")               1, false, false, false,  3, 2,  3, 2,  1, 5}, // #122
  {DBGFIELD("MCRXRX")             1, false, false, false,  3, 2,  3, 2,  0, 0}, // #123
  {DBGFIELD("XSNABSDP_XSXEXPDP_XSABSDP_XSNEGDP_XSCPSGNDP") 1, false, false, false,  3, 2,  3, 2,  1, 10}, // #124
  {DBGFIELD("RFEBB")              2, false, false, false,  8, 3,  8, 4,  1, 5}, // #125
  {DBGFIELD("TBEGIN_TRECHKPT")    1, false, false, false,  5, 3, 12, 3,  1, 5}, // #126
  {DBGFIELD("WAIT")               1, false, false, false,  3, 2,  3, 2,  1, 5}, // #127
  {DBGFIELD("RLDCL_RLDCR")        1, false, false, false,  3, 2,  3, 2, 11, 15}, // #128
  {DBGFIELD("RLWIMI_RLWIMI8")     1, false, false, false,  3, 2,  3, 2, 26, 25}, // #129
  {DBGFIELD("RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32_RLDIMI") 1, false, false, false,  3, 2,  3, 2, 26, 20}, // #130
  {DBGFIELD("MFOCRF_MFOCRF8")     1, false, false, false,  3, 2,  3, 2,  1, 5}, // #131
  {DBGFIELD("MTOCRF_MTOCRF8")     1, false, false, false,  3, 2,  3, 2,  1, 5}, // #132
  {DBGFIELD("CR6SET_CR6UNSET_CRSET_CRUNSET_CRAND_CRANDC_CRNAND_CRNOR_CROR_CRORC_CREQV_CRXOR") 1, false, false, false,  3, 2,  3, 2,  1, 10}, // #133
  {DBGFIELD("SLW_SLW8_SRW_SRW8_RLWINM_RLWINM8_RLWNM_RLWNM8") 1, false, false, false,  3, 2,  3, 2, 26, 20}, // #134
  {DBGFIELD("FABSD_FABSS_FNABSD_FNABSS_FNEGD_FNEGS_FCPSGND_FCPSGNS_FMR") 1, false, false, false,  3, 2,  3, 2,  1, 10}, // #135
  {DBGFIELD("SRAW_SRAWI")         1, false, false, false,  3, 2,  3, 2,  1, 10}, // #136
  {DBGFIELD("ISEL_ISEL8")         1, false, false, false,  3, 2,  3, 2, 11, 15}, // #137
  {DBGFIELD("XSIEXPDP")           1, false, false, false,  3, 2,  3, 2,  1, 10}, // #138
  {DBGFIELD("TRECLAIM_TSR_TABORT") 1, false, false, false,  5, 3, 12, 3,  1, 5}, // #139
  {DBGFIELD("MFVSCR")             1, false, false, false,  5, 3, 12, 3,  0, 0}, // #140
  {DBGFIELD("MTVSCR")             1, false, false, false,  5, 3, 12, 3,  1, 5}, // #141
  {DBGFIELD("VCMPNEZB_VCMPNEZH_VCMPNEZW_VCMPEQUB_VCMPEQUD_VCMPEQUH_VCMPEQUW_VCMPNEB_VCMPNEH_VCMPNEW_VCMPEQFP_VCMPEQFP_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPBFP_VCMPBFP_rec_VCMPGTSB_VCMPGTSB_rec_VCMPGTSD_VCMPGTSD_rec_VCMPGTSH_VCMPGTSH_rec_VCMPGTSW_VCMPGTSW_rec_VCMPGTUB_VCMPGTUB_rec_VCMPGTUD_VCMPGTUD_rec_VCMPGTUH_VCMPGTUH_rec_VCMPGTUW_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec") 1, false, false, false,  3, 2,  3, 2,  1, 10}, // #142
  {DBGFIELD("VABSDUB_VABSDUH_VABSDUW_VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTW_VPOPCNTD_VPRTYBD_VPRTYBW") 1, false, false, false,  3, 2,  5, 2,  1, 10}, // #143
  {DBGFIELD("VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VADDSBS_VADDSHS_VADDSWS_VMAXFP_VMINFP_VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW_VBPERMD_VADDCUW_VSHASIGMAD_VSHASIGMAW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_VSUBCUW_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP_XVXSIGDP_XVXSIGSP") 1, false, false, false,  1, 2,  1, 2,  1, 10}, // #144
  {DBGFIELD("XVTDIVDP_XVTDIVSP_XVTSQRTDP_XVTSQRTSP") 1, false, false, false,  3, 2,  5, 2,  1, 10}, // #145
  {DBGFIELD("VADDFP_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VEXPTEFP_VLOGEFP_VMADDFP_VMHADDSHS_VNMSUBFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVADDDP_XVADDSP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVHPSP_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVMULDP_XVMULSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP_XVSUBDP_XVSUBSP_VCFSX_VCFSX_0_VCFUX_VCFUX_0_VMHRADDSHS_VMLADDUHM_VMSUMMBM_VMSUMSHM_VMSUMSHS_VMSUMUBM_VMSUMUHM_VMSUMUDM_VMSUMUHS_VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS_VSUMSWS") 1, false, false, false, 13, 2, 17, 2, 51, 21}, // #146
  {DBGFIELD("VSUBFP_VMULUWM")     1, false, false, false, 13, 2, 17, 2, 51, 14}, // #147
  {DBGFIELD("MADDHD_MADDHDU_MADDLD_MADDLD8_MULLD_MULLDO") 1, false, false, false, 13, 2, 19, 2, 72, 9}, // #148
  {DBGFIELD("MULHD_MULHW_MULLW_MULLWO") 1, false, false, false, 13, 2, 19, 2, 72, 6}, // #149
  {DBGFIELD("MULHDU_MULHWU")      1, false, false, false, 13, 2, 19, 2, 72, 6}, // #150
  {DBGFIELD("MULLI_MULLI8")       1, false, false, false, 13, 2, 19, 2, 72, 6}, // #151
  {DBGFIELD("FRSP_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRE_FRES_FADDS_FMSUBS_FMADDS_FSUBS_FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRSQRTE_FRSQRTES_FNMADDS_FNMSUBS_FSELD_FSELS_FMULS") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #152
  {DBGFIELD("FADD_FSUB")          8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #153
  {DBGFIELD("FMSUB_FMADD_FNMADD_FNMSUB_FMUL") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #154
  {DBGFIELD("XSMADDADP_XSMADDASP_XSMADDMDP_XSMADDMSP_XSMSUBADP_XSMSUBASP_XSMSUBMDP_XSMSUBMSP_XSMULDP_XSMULSP_XSNMADDADP_XSNMADDASP_XSNMADDMDP_XSNMADDMSP_XSNMSUBADP_XSNMSUBASP_XSNMSUBMDP_XSNMSUBMSP") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #155
  {DBGFIELD("FSELD_rec_FSELS_rec") 2, false, false, false, 15, 4, 21, 4,  0, 0}, // #156
  {DBGFIELD("MULHDU_rec_MULHWU_rec") 2, false, false, false, 15, 4, 25, 4,  0, 0}, // #157
  {DBGFIELD("MULHD_rec_MULHW_rec_MULLWO_rec_MULLW_rec") 2, false, false, false, 15, 4, 25, 4,  0, 0}, // #158
  {DBGFIELD("MULLDO_rec_MULLD_rec") 2, false, false, false, 15, 4, 25, 4,  0, 0}, // #159
  {DBGFIELD("FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRES_rec_FRE_rec_FADDS_rec_FSUBS_rec_FMSUBS_rec_FNMSUBS_rec_FMADDS_rec_FNMADDS_rec_FCFIDS_rec_FCFIDUS_rec_FCFIDU_rec_FCFID_rec_FCTIDUZ_rec_FCTIDU_rec_FCTIDZ_rec_FCTID_rec_FCTIWUZ_rec_FCTIWU_rec_FCTIWZ_rec_FCTIW_rec_FMULS_rec_FRSQRTES_rec_FRSQRTE_rec_FRSP_rec") 2, false, false, false, 15, 4, 21, 4,  0, 0}, // #160
  {DBGFIELD("FADD_rec_FSUB_rec")  2, false, false, false, 15, 4, 21, 4,  0, 0}, // #161
  {DBGFIELD("FMSUB_rec_FNMSUB_rec_FMADD_rec_FNMADD_rec_FMUL_rec") 2, false, false, false, 15, 4, 21, 4,  0, 0}, // #162
  {DBGFIELD("XSADDDP_XSADDSP_XSCVDPHP_XSCVDPSP_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPSXWSs_XSCVDPUXWSs_XSCVHPDP_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSQRTEDP_XSRSQRTESP_XSSUBDP_XSSUBSP_XSCVDPSPN_XSRSP") 1, false, false, false,  3, 2,  5, 2,  1, 5}, // #163
  {DBGFIELD("LVSL_LVSR")          1, false, false, false,  1, 2,  1, 2,  1, 5}, // #164
  {DBGFIELD("VSPLTISB_VSPLTISH_VSPLTISW_VSPLTB_VSPLTBs_VSPLTH_VSPLTHs_VSPLTW_XXMRGHW_XXMRGLW_XXPERM_XXPERMR_XXSLDWI_XXSLDWIs_XXSPLTIB_XXSPLTW_XXSPLTWs_XXPERMDI_XXPERMDIs") 1, false, false, false,  1, 2,  1, 2,  1, 10}, // #165
  {DBGFIELD("V_SETALLONES_V_SETALLONESB_V_SETALLONESH_VBPERMQ_VGBBD_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPERM_VPERMR_VPERMXOR_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLDOI_VSLO_VSLV_VSR_VSRO_VSRV_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW_XXEXTRACTUW_XXINSERTW_VADDCUQ_VADDECUQ_VADDEUQM_VMUL10CUQ_VMUL10ECUQ_VMUL10EUQ_VMUL10UQ_VSUBCUQ_VSUBECUQ_VSUBEUQM_XSTSTDCQP_XSXSIGQP_BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDS_rec_BCDTRUNC_rec_BCDUS_rec_BCDUTRUNC_rec_BCDADD_rec_BCDSUB_rec") 1, false, false, false,  1, 2,  1, 2, 11, 15}, // #166
  {DBGFIELD("VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VINSERTB_VINSERTD_VINSERTH_VINSERTW_MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VEXTRACTD_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VPRTYBQ_VADDUQM_VSUBUQM") 1, false, false, false,  1, 2,  1, 2, 11, 15}, // #167
  {DBGFIELD("XSCMPEXPQP_XSCMPOQP_XSCMPUQP") 1, false, false, false, 19, 2, 29, 2, 51, 14}, // #168
  {DBGFIELD("BCDSR_rec_XSADDQP_XSADDQPO_XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP_XSRQPI_XSRQPIX_XSRQPXP_XSSUBQP_XSSUBQPO") 1, false, false, false, 21, 2, 31, 2, 51, 21}, // #169
  {DBGFIELD("BCDCTSQ_rec")        1, false, false, false, 23, 2, 33, 2, 51, 7}, // #170
  {DBGFIELD("XSMADDQP_XSMADDQPO_XSMSUBQP_XSMSUBQPO_XSMULQP_XSMULQPO_XSNMADDQP_XSNMADDQPO_XSNMSUBQP_XSNMSUBQPO") 1, false, false, false, 25, 2, 35, 2, 51, 21}, // #171
  {DBGFIELD("BCDCFSQ_rec")        1, false, false, false, 27, 2, 37, 2, 51, 14}, // #172
  {DBGFIELD("XSDIVQP_XSDIVQPO")   1, false, false, false, 29, 2, 39, 2, 51, 14}, // #173
  {DBGFIELD("XSSQRTQP_XSSQRTQPO") 1, false, false, false, 31, 2, 41, 2, 51, 7}, // #174
  {DBGFIELD("LXVL_LXVLL")         1, false, false, false, 33, 2, 43, 2, 81, 8}, // #175
  {DBGFIELD("LVEBX_LVEHX_LVEWX_LVX_LVXL") 1, false, false, false, 33, 2, 43, 2, 81, 4}, // #176
  {DBGFIELD("LXSIBZX_LXSIHZX_LXSDX_LXVB16X_LXVD2X_LXVWSX_LXSIWZX_LXV_LXVX_LXSD") 1, false, false, false, 33, 2, 43, 2, 81, 4}, // #177
  {DBGFIELD("DFLOADf64_XFLOADf64_LIWZX") 1, false, false, false, 33, 2, 43, 2, 81, 4}, // #178
  {DBGFIELD("DCBF_DCBFEP_DCBST_DCBSTEP_DCBT_DCBTEP_DCBZ_DCBZEP_DCBZL_DCBZLEP_DCBTST_DCBTSTEP") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #179
  {DBGFIELD("CP_COPY_CP_COPY8")   1, false, false, false, 35, 2, 45, 2, 11, 15}, // #180
  {DBGFIELD("ICBI_ICBIEP")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #181
  {DBGFIELD("ICBT_ICBTLS_LBZ_LBZ8_LBZCIX_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LDBRX_LDCIX_LHBRX_LHBRX8_LHZ_LHZ8_LHZCIX_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWBRX_LWBRX8_LWZ_LWZ8_LWZCIX_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32_EnforceIEIO_LSWI") 1, false, false, false, 11, 2, 15, 2,  0, 0}, // #182
  {DBGFIELD("LBARX_LBARXL_LHARX_LHARXL_LWARX_LWARXL") 1, false, false, false, 37, 3, 47, 3, 81, 4}, // #183
  {DBGFIELD("LD_LDX_LDXTLS_LDXTLS__DARN") 1, false, false, false, 37, 3, 47, 3, 81, 4}, // #184
  {DBGFIELD("LDARX_LDARXL")       1, false, false, false, 37, 3, 47, 3, 81, 4}, // #185
  {DBGFIELD("CP_ABORT")           1, false, false, false, 11, 2, 15, 2,  0, 0}, // #186
  {DBGFIELD("ISYNC")              2, false, false, false, 40, 4, 50, 4,  0, 0}, // #187
  {DBGFIELD("MSGSYNC")            1, false, false, false, 44, 3, 54, 3,  0, 0}, // #188
  {DBGFIELD("TLBSYNC")            1, false, false, false, 44, 3, 54, 3,  0, 0}, // #189
  {DBGFIELD("SYNC")               2, false, false, false, 40, 4, 50, 4,  0, 0}, // #190
  {DBGFIELD("LMW")                4, false, false, false, 47, 3, 57, 8, 81, 4}, // #191
  {DBGFIELD("LFIWZX_LFDX_LFD")    1, false, false, false, 33, 2, 43, 2, 81, 4}, // #192
  {DBGFIELD("SLBIA")              1, false, false, false, 37, 3, 47, 3,  0, 0}, // #193
  {DBGFIELD("SLBIE")              1, false, false, false, 37, 3, 47, 3, 81, 4}, // #194
  {DBGFIELD("SLBMFEE")            1, false, false, false, 37, 3, 47, 3, 81, 4}, // #195
  {DBGFIELD("SLBMFEV")            1, false, false, false, 37, 3, 47, 3, 81, 4}, // #196
  {DBGFIELD("SLBMTE")             2, false, false, false, 50, 4, 57, 4, 81, 8}, // #197
  {DBGFIELD("TLBIEL")             2, false, false, false, 50, 4, 57, 4, 81, 4}, // #198
  {DBGFIELD("LHZU_LHZU8_LWZU_LWZU8") 2, false, false, false, 54, 4, 65, 4,  0, 0}, // #199
  {DBGFIELD("LHZUX_LHZUX8_LWZUX_LWZUX8") 2, false, false, false, 54, 4, 65, 4,  0, 0}, // #200
  {DBGFIELD("TEND")               1, false, false, false, 44, 3, 54, 3,  1, 5}, // #201
  {DBGFIELD("STBCX_STHCX_STWCX")  1, false, false, false, 44, 3, 54, 3,  1, 10}, // #202
  {DBGFIELD("STDCX")              1, false, false, false, 44, 3, 54, 3,  1, 10}, // #203
  {DBGFIELD("LDMX")               1, false, false, false, 11, 2, 15, 2,  0, 0}, // #204
  {DBGFIELD("LHA_LHA8_LHAX_LHAX8_LWAX_LWAX_32") 1, false, false, false, 33, 2, 43, 2, 81, 4}, // #205
  {DBGFIELD("CP_PASTE8_rec_CP_PASTE_rec") 1, false, false, false, 44, 3, 54, 3, 11, 15}, // #206
  {DBGFIELD("LWA_LWA_32")         1, false, false, false, 33, 2, 43, 2, 81, 4}, // #207
  {DBGFIELD("TCHECK")             1, false, false, false, 44, 3, 54, 3,  0, 0}, // #208
  {DBGFIELD("LFIWAX")             1, false, false, false, 33, 2, 43, 2, 81, 4}, // #209
  {DBGFIELD("LXSIWAX")            1, false, false, false, 33, 2, 43, 2, 81, 4}, // #210
  {DBGFIELD("LIWAX")              1, false, false, false, 33, 2, 43, 2, 81, 4}, // #211
  {DBGFIELD("LFSX_LFS")           2, false, false, false, 58, 5, 69, 3,  0, 0}, // #212
  {DBGFIELD("LXSSP_LXSSPX")       2, false, false, false, 58, 5, 69, 3,  0, 0}, // #213
  {DBGFIELD("XFLOADf32_DFLOADf32") 1, false, false, false, 33, 2, 43, 2, 81, 4}, // #214
  {DBGFIELD("LHAU_LHAU8")         2, false, false, false, 54, 4, 65, 4,  0, 0}, // #215
  {DBGFIELD("LHAUX_LHAUX8_LWAUX") 2, false, false, false, 54, 4, 65, 4,  0, 0}, // #216
  {DBGFIELD("LXVH8X_LXVDSX_LXVW4X") 1, false, false, false, 33, 2, 43, 2, 81, 4}, // #217
  {DBGFIELD("STFD_STFDX_STFIWX_STFS_STFSX_STXSD_STXSDX_STXSIBX_STXSIBXv_STXSIHX_STXSIHXv_STXSIWX_STXSSP_STXSSPX") 1, false, false, false, 35, 2, 45, 2,  1, 10}, // #218
  {DBGFIELD("STW_STW8_STDBRX_STHBRX_STWBRX_STB_STB8_STH_STH8_STBX_STBX8_STBXTLS_STBXTLS__STBXTLS_32_STHX_STHX8_STHXTLS_STHXTLS__STHXTLS_32_STWX_STWX8_STWXTLS_STWXTLS__STWXTLS_32") 1, false, false, false, 35, 2, 45, 2, 11, 15}, // #219
  {DBGFIELD("DFSTOREf32_DFSTOREf64_XFSTOREf32_XFSTOREf64_STIWX") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #220
  {DBGFIELD("STD_STDX_STDXTLS_STDXTLS_") 1, false, false, false, 35, 2, 45, 2, 11, 15}, // #221
  {DBGFIELD("STBCIX_STDCIX_STHCIX_STWCIX_STSWI") 4, false, false, false, 63, 3, 72, 8, 11, 15}, // #222
  {DBGFIELD("SLBIEG")             1, false, false, false, 44, 3, 54, 3,  1, 10}, // #223
  {DBGFIELD("STMW")               4, false, false, false, 63, 3, 72, 8,  1, 10}, // #224
  {DBGFIELD("TLBIE")              1, false, false, false, 44, 3, 54, 3,  1, 10}, // #225
  {DBGFIELD("STVEBX_STVEHX_STVEWX_STVX_STVXL") 1, false, false, false, 35, 2, 45, 2,  1, 10}, // #226
  {DBGFIELD("STXV_STXVB16X_STXVD2X_STXVH8X_STXVW4X_STXVX") 1, false, false, false, 35, 2, 45, 2,  1, 10}, // #227
  {DBGFIELD("STXVL_STXVLL")       1, false, false, false, 35, 2, 45, 2, 11, 15}, // #228
  {DBGFIELD("MTCTR_MTCTR8_MTCTR8loop_MTCTRloop_MTLR_MTLR8") 1, false, false, false,  3, 2, 80, 2,  1, 5}, // #229
  {DBGFIELD("MFVRSAVE_MFVRSAVEv_MTVRSAVE_MTVRSAVEv") 1, false, false, false, 66, 3, 82, 3,  0, 0}, // #230
  {DBGFIELD("MFPMR")              1, false, false, false, 11, 2, 15, 2,  0, 0}, // #231
  {DBGFIELD("MTPMR")              1, false, false, false, 11, 2, 15, 2,  0, 0}, // #232
  {DBGFIELD("MFTB_MFTB8")         1, false, false, false, 66, 3, 85, 3, 89, 6}, // #233
  {DBGFIELD("MFCTR_MFCTR8_MFLR_MFLR8_MFSPR_MFSPR8") 1, false, false, false, 66, 3, 82, 3,  0, 0}, // #234
  {DBGFIELD("MFMSR")              1, false, false, false, 66, 3, 85, 3,  0, 0}, // #235
  {DBGFIELD("MTMSR")              1, false, false, false, 66, 3, 85, 3, 95, 12}, // #236
  {DBGFIELD("MTMSRD")             1, false, false, false, 66, 3, 85, 3, 95, 12}, // #237
  {DBGFIELD("MTSPR_MTSPR8")       1, false, false, false, 37, 3, 47, 3, 81, 8}, // #238
  {DBGFIELD("DIVW_DIVWO_DIVWU_DIVWUO_MODSW") 1, false, false, false, 69, 2, 88, 2, 51, 14}, // #239
  {DBGFIELD("DIVWE_DIVWEO_DIVWEU_DIVWEUO_MODSD_MODUD_MODUW") 1, false, false, false, 69, 2, 90, 2, 51, 14}, // #240
  {DBGFIELD("DIVD_DIVDO_DIVDU_DIVDUO") 1, false, false, false, 69, 2, 35, 2, 51, 14}, // #241
  {DBGFIELD("DIVDE_DIVDEO_DIVDEU_DIVDEUO") 1, false, false, false, 69, 2, 92, 2, 51, 14}, // #242
  {DBGFIELD("DIVWO_rec_DIVWUO_rec_DIVWU_rec_DIVW_rec") 2, false, false, false, 71, 4, 94, 4,  0, 0}, // #243
  {DBGFIELD("DIVD_rec_DIVDO_rec_DIVDU_rec_DIVDUO_rec") 2, false, false, false, 71, 4, 98, 4,  0, 0}, // #244
  {DBGFIELD("DIVWE_rec_DIVWEO_rec_DIVWEU_rec_DIVWEUO_rec") 2, false, false, false, 71, 4, 98, 4,  0, 0}, // #245
  {DBGFIELD("DIVDE_rec_DIVDEO_rec_DIVDEU_rec_DIVDEUO_rec") 2, false, false, false, 71, 4, 102, 4,  0, 0}, // #246
  {DBGFIELD("MTCRF_MTCRF8")       2, false, false, false, 75, 4,  8, 3,  1, 10}, // #247
  {DBGFIELD("ADDC8O_rec_ADDC8_rec_ADDCO_rec_ADDC_rec_SUBFC8O_rec_SUBFC8_rec_SUBFCO_rec_SUBFC_rec") 4, false, false, false, 79, 3, 106, 8,  1, 10}, // #248
  {DBGFIELD("FABSD_rec_FABSS_rec_FNABSD_rec_FNABSS_rec_FCPSGND_rec_FCPSGNS_rec_FNEGD_rec_FNEGS_rec_FMR_rec") 2, false, false, false,  8, 3,  8, 4,  1, 10}, // #249
  {DBGFIELD("MCRFS")              1, false, false, false,  5, 3, 12, 3,  1, 5}, // #250
  {DBGFIELD("MTFSF_MTFSF_rec_MTFSFI_MTFSFI_rec_MTFSFIb") 2, false, false, false,  8, 3,  8, 4, 26, 20}, // #251
  {DBGFIELD("MTFSFb")             2, false, false, false,  8, 3,  8, 4,  1, 10}, // #252
  {DBGFIELD("RLDCL_rec_RLDCR_rec") 1, false, false, false,  3, 2,  5, 2, 11, 15}, // #253
  {DBGFIELD("RLDICL_rec_RLDICR_rec_RLDICL_32_rec_RLDIMI_rec") 1, false, false, false,  3, 2,  5, 2, 26, 20}, // #254
  {DBGFIELD("RLWIMI8_rec_RLWIMI_rec") 1, false, false, false,  3, 2,  5, 2, 26, 25}, // #255
  {DBGFIELD("RLWINM8_rec_RLWINM_rec_RLWNM8_rec_RLWNM_rec_SLW8_rec_SLW_rec_SRW8_rec_SRW_rec") 1, false, false, false,  3, 2,  5, 2, 26, 20}, // #256
  {DBGFIELD("SRAWI_rec_SRAW_rec") 1, false, false, false,  5, 3,  5, 3,  1, 10}, // #257
  {DBGFIELD("MFFS_MFFSCE_MFFSL_MFFS_rec") 2, false, false, false,  8, 3,  8, 4,  0, 0}, // #258
  {DBGFIELD("MFCR_MFCR8")         2, false, false, false, 75, 4, 114, 3,  0, 0}, // #259
  {DBGFIELD("EXTSWSLI_32_64_rec_SRADI_rec_EXTSWSLI_rec_RLDIC_rec") 1, false, false, false,  5, 3,  5, 3,  1, 10}, // #260
  {DBGFIELD("SRAD_rec_SLD_rec_SRD_rec") 1, false, false, false,  5, 3,  5, 3,  1, 10}, // #261
  {DBGFIELD("FDIV")               8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #262
  {DBGFIELD("FDIV_rec")           2, false, false, false, 82, 4, 117, 4,  0, 0}, // #263
  {DBGFIELD("XSSQRTDP")           8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #264
  {DBGFIELD("FSQRT")              8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #265
  {DBGFIELD("XVSQRTDP")           8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #266
  {DBGFIELD("XVSQRTSP")           8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #267
  {DBGFIELD("FSQRT_rec")          2, false, false, false, 86, 4, 121, 4,  0, 0}, // #268
  {DBGFIELD("XSSQRTSP")           8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #269
  {DBGFIELD("FSQRTS")             8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #270
  {DBGFIELD("FSQRTS_rec")         2, false, false, false, 90, 4, 125, 4,  0, 0}, // #271
  {DBGFIELD("XSDIVDP")            8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #272
  {DBGFIELD("FDIVS")              8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #273
  {DBGFIELD("FDIVS_rec")          2, false, false, false, 90, 4, 129, 4,  0, 0}, // #274
  {DBGFIELD("XSDIVSP")            8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #275
  {DBGFIELD("XVDIVSP")            8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #276
  {DBGFIELD("XVDIVDP")            8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #277
  {DBGFIELD("LFSU")               4, false, false, false, 94, 6, 133, 7,  0, 0}, // #278
  {DBGFIELD("LFSUX")              4, false, false, false, 94, 6, 133, 7,  0, 0}, // #279
  {DBGFIELD("STFDU_STFDUX_STFSU_STFSUX") 1, false, false, false, 35, 2, 45, 2,  1, 10}, // #280
  {DBGFIELD("STBU_STBU8_STDU_STHU_STHU8_STWU_STWU8") 1, false, false, false, 35, 2, 45, 2,  1, 10}, // #281
  {DBGFIELD("STBUX_STBUX8_STDUX_STHUX_STHUX8_STWUX_STWUX8") 1, false, false, false, 35, 2, 45, 2,  1, 10}, // #282
  {DBGFIELD("LBZU_LBZU8")         2, false, false, false, 54, 4, 65, 4,  0, 0}, // #283
  {DBGFIELD("LBZUX_LBZUX8")       2, false, false, false, 54, 4, 65, 4,  0, 0}, // #284
  {DBGFIELD("LDU")                2, false, false, false, 54, 4, 65, 4,  0, 0}, // #285
  {DBGFIELD("LDUX")               2, false, false, false, 54, 4, 65, 4,  0, 0}, // #286
  {DBGFIELD("LFDU")               2, false, false, false, 54, 4, 65, 4,  0, 0}, // #287
  {DBGFIELD("LFDUX")              2, false, false, false, 54, 4, 65, 4,  0, 0}, // #288
  {DBGFIELD("VPMSUMB_VPMSUMD_VPMSUMH_VPMSUMW_VCIPHER_VCIPHERLAST_VNCIPHER_VNCIPHERLAST_VSBOX") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #289
  {DBGFIELD("BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_BCCTR_BCCTR8_BCCTR8n_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_BCCTRn_BDNZ_BDNZ8_BDNZA_BDNZAm_BDNZAp_BDNZm_BDNZp_BDZ_BDZ8_BDZA_BDZAm_BDZAp_BDZm_BDZp_BDNZL_BDNZLA_BDNZLAm_BDNZLAp_BDNZLR_BDNZLR8_BDNZLRL_BDNZLRLm_BDNZLRLp_BDNZLRm_BDNZLRp_BDNZLm_BDNZLp_BDZL_BDZLA_BDZLAm_BDZLAp_BDZLR_BDZLR8_BDZLRL_BDZLRLm_BDZLRLp_BDZLRm_BDZLRp_BDZLm_BDZLp_BL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM_BLR_BLR8_BLRL_TAILB_TAILB8_TAILBA_TAILBA8_TAILBCTR_TAILBCTR8_gBC_gBCA_gBCAat_gBCCTR_gBCCTRL_gBCL_gBCLA_gBCLAat_gBCLR_gBCLRL_gBCLat_gBCat_BCLR_BCLRL_BCLRLn_BCLRn_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_RM_BCTRL_RM_B_BA_BC_BCC_BCCA_BCL_BCLalways_BCLn_BCTRL8_LDinto_toc_BCTRL_LWZinto_toc_BCTRL8_LDinto_toc_RM_BCTRL_LWZinto_toc_RM_BCn_CTRL_DEP") 1, false, false, false, 100, 2, 80, 2, 107, 8}, // #290
  {DBGFIELD("ADDPCIS")            2, false, false, false, 102, 4, 136, 4,  0, 0}, // #291
  {DBGFIELD("LDAT_LWAT")          8, false, false, false, 106, 5, 140, 16,  0, 0}, // #292
  {DBGFIELD("STDAT_STWAT")        4, false, false, false, 111, 4, 156, 8,  0, 0}, // #293
  {DBGFIELD("BRINC")              8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #294
  {DBGFIELD("EVABS_EVEQV_EVNAND_EVNEG_EVADDIW_EVADDW_EVAND_EVANDC_EVCMPEQ_EVCMPGTS_EVCMPGTU_EVCMPLTS_EVCMPLTU_EVCNTLSW_EVCNTLZW_EVEXTSB_EVEXTSH_EVMERGEHI_EVMERGEHILO_EVMERGELO_EVMERGELOHI_EVNOR_EVOR_EVORC_EVXOR_EVRLW_EVRLWI_EVRNDW_EVSLW_EVSLWI_EVSPLATFI_EVSPLATI_EVSRWIS_EVSRWIU_EVSRWS_EVSRWU_EVSUBFW_EVSUBIFW") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #295
  {DBGFIELD("EVMRA_EVADDSMIAAW_EVADDSSIAAW_EVADDUMIAAW_EVADDUSIAAW_EVDIVWS_EVDIVWU_EVMHEGSMFAA_EVMHEGSMFAN_EVMHEGSMIAA_EVMHEGSMIAN_EVMHEGUMIAA_EVMHEGUMIAN_EVMHESMF_EVMHESMFA_EVMHESMFAAW_EVMHESMFANW_EVMHESMI_EVMHESMIA_EVMHESMIAAW_EVMHESMIANW_EVMHESSF_EVMHESSFA_EVMHESSFAAW_EVMHESSFANW_EVMHESSIAAW_EVMHESSIANW_EVMHEUMI_EVMHEUMIA_EVMHEUMIAAW_EVMHEUMIANW_EVMHEUSIAAW_EVMHEUSIANW_EVMHOGSMFAA_EVMHOGSMFAN_EVMHOGSMIAA_EVMHOGSMIAN_EVMHOGUMIAA_EVMHOGUMIAN_EVMHOSMF_EVMHOSMFA_EVMHOSMFAAW_EVMHOSMFANW_EVMHOSMI_EVMHOSMIA_EVMHOSMIAAW_EVMHOSMIANW_EVMHOSSF_EVMHOSSFA_EVMHOSSFAAW_EVMHOSSFANW_EVMHOSSIAAW_EVMHOSSIANW_EVMHOUMI_EVMHOUMIA_EVMHOUMIAAW_EVMHOUMIANW_EVMHOUSIAAW_EVMHOUSIANW_EVMWHSMF_EVMWHSMFA_EVMWHSMI_EVMWHSMIA_EVMWHSSF_EVMWHSSFA_EVMWHUMI_EVMWHUMIA_EVMWLSMIAAW_EVMWLSMIANW_EVMWLSSIAAW_EVMWLSSIANW_EVMWLUMI_EVMWLUMIA_EVMWLUMIAAW_EVMWLUMIANW_EVMWLUSIAAW_EVMWLUSIANW_EVMWSMF_EVMWSMFA_EVMWSMFAA_EVMWSMFAN_EVMWSMI_EVMWSMIA_EVMWSMIAA_EVMWSMIAN_EVMWSSF_EVMWSSFA_EVMWSSFAA_EVMWSSFAN_EVMWUMI_EVMWUMIA_EVMWUMIAA_EVMWUMIAN_EVSUBFSMIAAW_EVSUBFSSIAAW_EVSUBFUMIAAW_EVSUBFUSIAAW") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #296
  {DBGFIELD("EVLDD_EVLDDX_EVLDH_EVLDHX_EVLDW_EVLDWX_EVLHHESPLAT_EVLHHESPLATX_EVLHHOSSPLAT_EVLHHOSSPLATX_EVLHHOUSPLAT_EVLHHOUSPLATX_EVLWHE_EVLWHEX_EVLWHOS_EVLWHOSX_EVLWHOU_EVLWHOUX_EVLWHSPLAT_EVLWHSPLATX_EVLWWSPLAT_EVLWWSPLATX") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #297
  {DBGFIELD("EVSTDD_EVSTDDX_EVSTDH_EVSTDHX_EVSTDW_EVSTDWX_EVSTWHE_EVSTWHEX_EVSTWHO_EVSTWHOX_EVSTWWE_EVSTWWEX_EVSTWWO_EVSTWWOX") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #298
  {DBGFIELD("HRFID_ATTN_CLRBHRB_MFBHRBE_NAP_RFCI_RFDI_RFMCI_SC") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #299
  {DBGFIELD("RFI")                8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #300
  {DBGFIELD("RFID")               2, false, false, false,  8, 3,  8, 4,  0, 0}, // #301
  {DBGFIELD("DSS_DSSALL_DST_DST64_DSTST_DSTST64_DSTSTT_DSTSTT64_DSTT_DSTT64_ICBLQ_LBEPX_LHEPX_LWEPX_TLBIVAX_TLBLD_TLBLI_TLBRE_TLBRE2_TLBSX_TLBSX2_TLBSX2D_TLBWE_TLBWE2_MBAR_TRAP_DCCCI_ICCCI") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #302
  {DBGFIELD("ICBLC_STBEPX_STHEPX_STWEPX") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #303
  {DBGFIELD("LFDEPX")             8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #304
  {DBGFIELD("STFDEPX")            8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #305
  {DBGFIELD("MFSR_MFSRIN")        1, false, false, false, 11, 2, 15, 2,  0, 0}, // #306
  {DBGFIELD("MTSR_MTSRIN")        1, false, false, false, 11, 2, 15, 2,  0, 0}, // #307
  {DBGFIELD("MFDCR")              1, false, false, false, 11, 2, 15, 2,  0, 0}, // #308
  {DBGFIELD("MTDCR")              1, false, false, false, 11, 2, 15, 2,  0, 0}, // #309
  {DBGFIELD("NOP_GT_PWR6_NOP_GT_PWR7") 1, false, false, false,  3, 2,  3, 2,  0, 0}, // #310
  {DBGFIELD("TLBIA")              1, false, false, false, 11, 2, 15, 2,  0, 0}, // #311
  {DBGFIELD("WRTEE_WRTEEI")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #312
  {DBGFIELD("HASHCHK_HASHCHK8_HASHCHKP_HASHCHKP8_HASHST_HASHST8_HASHSTP_HASHSTP8_ADDEX_ADDEX8") 2, false, false, false, 115, 4, 164, 4,  0, 0}, // #313
  {DBGFIELD("MSYNC")              1, false, false, false, 11, 2, 15, 2,  0, 0}, // #314
  {DBGFIELD("SLBSYNC")            1, false, false, false, 44, 3, 54, 3,  0, 0}, // #315
  {DBGFIELD("SLBFEE_rec")         1, false, false, false, 37, 3, 47, 3, 81, 4}, // #316
  {DBGFIELD("STOP")               2, false, false, false,  8, 3,  8, 4,  0, 0}, // #317
  {DBGFIELD("DCBA_DCBI")          1, false, false, false, 11, 2, 15, 2,  0, 0}, // #318
  {DBGFIELD("FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRE_FRES_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRSP_FRSQRTE_FRSQRTES") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #319
  {DBGFIELD("VCFSX_VCFSX_0_VCFUX_VCFUX_0_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VLOGEFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #320
  {DBGFIELD("XSCVDPHP_XSCVDPSP_XSCVDPSPN_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPSXWSs_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPUXWSs_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSP_XSRSQRTEDP_XSRSQRTESP") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #321
  {DBGFIELD("XVCVSPBF16")         8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #322
  {DBGFIELD("FADDS_FMULS_FSUBS")  8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #323
  {DBGFIELD("FMUL")               8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #324
  {DBGFIELD("VADDFP_XVADDDP_XVADDSP_XVMULDP_XVMULSP_XVSUBDP_XVSUBSP") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #325
  {DBGFIELD("VSUBFP")             8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #326
  {DBGFIELD("XSADDDP_XSADDSP_XSSUBDP_XSSUBSP") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #327
  {DBGFIELD("XSMULDP_XSMULSP")    8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #328
  {DBGFIELD("VMADDFP_VNMSUBFP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #329
  {DBGFIELD("VEXPTEFP")           8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #330
  {DBGFIELD("FADDS_rec_FMULS_rec_FSUBS_rec") 2, false, false, false, 15, 4, 21, 4,  0, 0}, // #331
  {DBGFIELD("FMUL_rec")           2, false, false, false, 15, 4, 21, 4,  0, 0}, // #332
  {DBGFIELD("FCFID_rec_FCFIDS_rec_FCFIDU_rec_FCFIDUS_rec_FCTID_rec_FCTIDU_rec_FCTIDUZ_rec_FCTIDZ_rec_FCTIW_rec_FCTIWU_rec_FCTIWUZ_rec_FCTIWZ_rec_FRE_rec_FRES_rec_FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRSP_rec_FRSQRTE_rec_FRSQRTES_rec") 2, false, false, false, 15, 4, 21, 4,  0, 0}, // #333
  {DBGFIELD("BCLR_BCLRn_BDNZLR_BDNZLR8_BDNZLRm_BDNZLRp_BDZLR_BDZLR8_BDZLRm_BDZLRp_gBCLR_BCLRL_BCLRLn_BDNZLRL_BDNZLRLm_BDNZLRLp_BDZLRL_BDZLRLm_BDZLRLp_gBCLRL_BL_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLR_BLR8_BLRL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS") 1, false, false, false, 100, 2, 80, 2,  0, 0}, // #334
  {DBGFIELD("BL8_NOTOC_BL8_NOTOC_RM_BL8_NOTOC_TLS") 1, false, false, false, 100, 2, 80, 2,  0, 0}, // #335
  {DBGFIELD("B_BCC_BCCA_BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_CTRL_DEP_TAILB_TAILB8_BA_TAILBA_TAILBA8_BC_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_LDinto_toc_BCTRL8_LDinto_toc_RM_BCTRL8_RM_BCTRL_LWZinto_toc_BCTRL_LWZinto_toc_RM_BCTRL_RM_BCn_BDNZ_BDNZ8_BDNZm_BDNZp_BDZ_BDZ8_BDZm_BDZp_TAILBCTR_TAILBCTR8_gBC_gBCat_BCL_BCLalways_BCLn_BDNZL_BDNZLm_BDNZLp_BDZL_BDZLm_BDZLp_gBCL_gBCLat_BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM") 1, false, false, false, 100, 2, 80, 2,  1, 2}, // #336
  {DBGFIELD("BCCTR_BCCTR8_BCCTR8n_BCCTRn_gBCCTR_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_gBCCTRL") 1, false, false, false, 100, 2, 80, 2, 107, 6}, // #337
  {DBGFIELD("VSBOX")              8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("CFUGED_CNTLZDM_CNTTZDM_PDEPD_PEXTD") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD("VCFUGED_VCLZDM_VCTZDM_VGNB_VPDEPD_VPEXTD") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD("XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP") 1, false, false, false, 21, 2, 31, 2, 51, 7}, // #341
  {DBGFIELD("XSCVQPSQZ_XSCVQPUQZ_XSCVSQQP_XSCVUQQP") 1, false, false, false, 21, 2, 31, 2, 51, 7}, // #342
  {DBGFIELD("XSADDQP_XSADDQPO_XSSUBQP_XSSUBQPO") 1, false, false, false, 21, 2, 31, 2, 51, 14}, // #343
  {DBGFIELD("HASHST_HASHST8_HASHSTP_HASHSTP8") 2, false, false, false, 119, 4, 168, 4,  0, 0}, // #344
  {DBGFIELD("XSMULQP_XSMULQPO")   1, false, false, false, 25, 2, 35, 2, 51, 14}, // #345
  {DBGFIELD("VDIVESQ_VDIVEUQ_VDIVSQ_VDIVUQ") 1, false, false, false, 123, 2, 172, 2, 51, 14}, // #346
  {DBGFIELD("VMODSQ_VMODUQ")      1, false, false, false, 125, 2, 174, 2, 51, 14}, // #347
  {DBGFIELD("DIVWE_DIVWEO_DIVWEU_DIVWEUO") 1, false, false, false, 69, 2, 35, 2, 51, 14}, // #348
  {DBGFIELD("VDIVSD_VDIVUD")      1, false, false, false, 127, 2, 176, 2, 51, 14}, // #349
  {DBGFIELD("VMODSD_VMODUD")      1, false, false, false, 127, 2, 178, 2, 51, 14}, // #350
  {DBGFIELD("VDIVSW_VDIVUW")      1, false, false, false, 129, 2, 180, 2, 51, 14}, // #351
  {DBGFIELD("VMODSW_VMODUW")      1, false, false, false, 129, 2, 182, 2, 51, 14}, // #352
  {DBGFIELD("VDIVESD_VDIVEUD")    1, false, false, false, 127, 2, 184, 2, 51, 14}, // #353
  {DBGFIELD("VDIVESW_VDIVEUW")    1, false, false, false, 129, 2, 186, 2, 51, 14}, // #354
  {DBGFIELD("BCDCTN_rec_VMUL10CUQ_VMUL10UQ_XSXSIGQP") 1, false, false, false, 19, 2, 29, 2, 51, 7}, // #355
  {DBGFIELD("BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDUS_rec_BCDUTRUNC_rec_VADDCUQ_VMUL10ECUQ_VMUL10EUQ_VSUBCUQ_XSTSTDCQP") 1, false, false, false, 19, 2, 29, 2, 51, 14}, // #356
  {DBGFIELD("VADDUQM_VSUBUQM")    1, false, false, false, 19, 2, 29, 2, 51, 14}, // #357
  {DBGFIELD("XSMAXCQP_XSMINCQP")  1, false, false, false, 19, 2, 29, 2, 51, 14}, // #358
  {DBGFIELD("XXGENPCVBM")         1, false, false, false, 19, 2, 29, 2, 51, 14}, // #359
  {DBGFIELD("BCDADD_rec_BCDS_rec_BCDSUB_rec_BCDTRUNC_rec_VADDECUQ_VADDEUQM_VSUBECUQ_VSUBEUQM") 1, false, false, false, 19, 2, 29, 2, 51, 21}, // #360
  {DBGFIELD("TRAP")               1, false, false, false,  3, 2,  5, 2,  0, 0}, // #361
  {DBGFIELD("TW")                 1, false, false, false,  3, 2,  5, 2,  0, 0}, // #362
  {DBGFIELD("CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW") 1, false, false, false,  3, 2,  5, 2,  1, 5}, // #363
  {DBGFIELD("FTSQRT")             1, false, false, false,  3, 2,  5, 2,  1, 5}, // #364
  {DBGFIELD("MTVSRBM_MTVSRBMI_MTVSRDM_MTVSRHM_MTVSRQM_MTVSRWM_VEXPANDBM_VEXPANDDM_VEXPANDHM_VEXPANDQM_VEXPANDWM_VEXTRACTBM_VEXTRACTDM_VEXTRACTHM_VEXTRACTQM_VEXTRACTWM_XVTLSBB") 1, false, false, false,  3, 2,  5, 2,  1, 5}, // #365
  {DBGFIELD("POPCNTB_POPCNTB8")   1, false, false, false,  3, 2,  5, 2,  1, 5}, // #366
  {DBGFIELD("VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTD_VPOPCNTW_VPRTYBD_VPRTYBW") 1, false, false, false,  3, 2,  5, 2,  1, 5}, // #367
  {DBGFIELD("VPOPCNTB_VPOPCNTH")  1, false, false, false,  3, 2,  5, 2,  1, 5}, // #368
  {DBGFIELD("XSCVSPDPN")          1, false, false, false,  3, 2,  5, 2,  1, 5}, // #369
  {DBGFIELD("XSTSQRTDP")          1, false, false, false,  3, 2,  5, 2,  1, 5}, // #370
  {DBGFIELD("XVCVHPSP")           1, false, false, false,  3, 2,  5, 2,  1, 5}, // #371
  {DBGFIELD("XVTSQRTDP_XVTSQRTSP") 1, false, false, false,  3, 2,  5, 2,  1, 5}, // #372
  {DBGFIELD("CMPEQB")             1, false, false, false,  3, 2,  5, 2,  1, 10}, // #373
  {DBGFIELD("EXTSWSLI_32_64_rec_EXTSWSLI_rec") 1, false, false, false,  3, 2,  5, 2,  1, 10}, // #374
  {DBGFIELD("SLD_rec_SRD_rec")    1, false, false, false,  3, 2,  5, 2,  1, 10}, // #375
  {DBGFIELD("SLW8_rec_SLW_rec_SRW8_rec_SRW_rec") 1, false, false, false,  3, 2,  5, 2,  1, 10}, // #376
  {DBGFIELD("VADDCUW_VADDSBS_VADDSHS_VADDSWS_VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VMAXFP_VMINFP_VSUBCUW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP") 1, false, false, false,  3, 2,  5, 2,  1, 10}, // #377
  {DBGFIELD("VCMPBFP_VCMPBFP_rec_VCMPEQFP_VCMPEQFP_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPGTSB_rec_VCMPGTSD_rec_VCMPGTSH_rec_VCMPGTSW_rec_VCMPGTUB_rec_VCMPGTUD_rec_VCMPGTUH_rec_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec") 1, false, false, false,  3, 2,  5, 2,  1, 10}, // #378
  {DBGFIELD("VCMPEQUQ_VCMPEQUQ_rec_VCMPGTSQ_VCMPGTSQ_rec_VCMPGTUQ_VCMPGTUQ_rec") 1, false, false, false,  3, 2,  5, 2,  1, 10}, // #379
  {DBGFIELD("VCMPSQ_VCMPUQ_VCNTMBB_VCNTMBD_VCNTMBH_VCNTMBW") 1, false, false, false,  3, 2,  5, 2,  1, 10}, // #380
  {DBGFIELD("XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP") 1, false, false, false,  3, 2,  5, 2,  1, 10}, // #381
  {DBGFIELD("RLDIC_rec")          1, false, false, false,  3, 2,  5, 2, 11, 15}, // #382
  {DBGFIELD("RLDICL_32_rec_RLDICL_rec_RLDICR_rec") 1, false, false, false,  3, 2,  5, 2, 11, 15}, // #383
  {DBGFIELD("VSHASIGMAD_VSHASIGMAW") 1, false, false, false,  3, 2,  5, 2, 11, 15}, // #384
  {DBGFIELD("VRLQ_VRLQNM_VSLQ_VSRAQ_VSRQ") 2, false, false, false, 131, 4, 188, 4,  0, 0}, // #385
  {DBGFIELD("VRLQMI")             2, false, false, false, 131, 4, 188, 4,  0, 0}, // #386
  {DBGFIELD("CR6SET_CREQV_CRSET") 1, false, false, false,  3, 2,  3, 2,  0, 0}, // #387
  {DBGFIELD("DSS_DSSALL")         1, false, false, false,  3, 2,  3, 2,  0, 0}, // #388
  {DBGFIELD("MFCTR_MFCTR8_MFLR_MFLR8") 1, false, false, false,  3, 2,  3, 2,  0, 0}, // #389
  {DBGFIELD("NOP_ORI_ORI8")       1, false, false, false,  3, 2,  3, 2,  0, 0}, // #390
  {DBGFIELD("VXOR_V_SET0_V_SET0B_V_SET0H") 1, false, false, false,  3, 2,  3, 2,  0, 0}, // #391
  {DBGFIELD("XXLEQV_XXLEQVOnes_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz") 1, false, false, false,  3, 2,  3, 2,  0, 0}, // #392
  {DBGFIELD("ADDI_ADDI8_LI_LI8_ADDIS_ADDIS8_LIS_LIS8_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_NEG_NEG8_NEG8_rec_NEG_rec_NEG8O_NEGO") 1, false, false, false,  3, 2,  3, 2,  1, 5}, // #393
  {DBGFIELD("ADDIdtprelL32_ADDItlsldLADDR32_ADDISdtprelHA32") 1, false, false, false,  3, 2,  3, 2,  1, 5}, // #394
  {DBGFIELD("ADDItocL_ADDIStocHA_ADDIStocHA8") 1, false, false, false,  3, 2,  3, 2,  1, 5}, // #395
  {DBGFIELD("ADDME_ADDME8_ADDME8O_ADDMEO_ADDZE_ADDZE8_ADDZE8O_ADDZEO_SUBFME_SUBFME8_SUBFME8O_SUBFMEO_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZEO") 1, false, false, false,  3, 2,  3, 2,  1, 5}, // #396
  {DBGFIELD("FABSD_FABSS_FMR_FNABSD_FNABSS_FNEGD_FNEGS") 1, false, false, false,  3, 2,  3, 2,  1, 5}, // #397
  {DBGFIELD("SETB_SETB8")         1, false, false, false,  3, 2,  3, 2,  1, 5}, // #398
  {DBGFIELD("SETBC_SETBC8_SETBCR_SETBCR8_SETNBC_SETNBC8_SETNBCR_SETNBCR8") 1, false, false, false,  3, 2,  3, 2,  1, 5}, // #399
  {DBGFIELD("VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VNEGD_VNEGW") 1, false, false, false,  3, 2,  3, 2,  1, 5}, // #400
  {DBGFIELD("VEXTSD2Q")           1, false, false, false,  3, 2,  3, 2,  1, 5}, // #401
  {DBGFIELD("XSABSDP_XSNABSDP_XSNEGDP_XSXEXPDP") 1, false, false, false,  3, 2,  3, 2,  1, 5}, // #402
  {DBGFIELD("XSABSQP_XSNABSQP_XSNEGQP_XSXEXPQP_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVNEGDP_XVNEGSP_XVXEXPDP_XVXEXPSP") 1, false, false, false,  3, 2,  3, 2,  1, 5}, // #403
  {DBGFIELD("XVXSIGDP_XVXSIGSP")  1, false, false, false,  3, 2,  3, 2,  1, 5}, // #404
  {DBGFIELD("ADD4_ADD4TLS_ADD8_ADD8TLS_ADD8TLS__ADD4_rec_ADD8_rec_ADD4O_ADD8O_AND_AND8_AND8_rec_AND_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_EQV_EQV8_EQV8_rec_EQV_rec_NAND_NAND8_NAND8_rec_NAND_rec_NOR_NOR8_NOR8_rec_NOR_rec_OR_OR8_OR8_rec_OR_rec_ORC_ORC8_ORC8_rec_ORC_rec_ORIS_ORIS8_XOR_XOR8_XOR8_rec_XOR_rec_XORI_XORI8_XORIS_XORIS8") 1, false, false, false,  3, 2,  3, 2,  1, 10}, // #405
  {DBGFIELD("ADDE_ADDE8_ADDE8O_ADDEO_ADDIC_ADDIC8_ANDI8_rec_ANDI_rec_ANDIS8_rec_ANDIS_rec_SUBF_SUBF8_SUBF8_rec_SUBF_rec_SUBFE_SUBFE8_SUBFE8O_SUBFEO_SUBFIC_SUBFIC8_SUBF8O_SUBFO") 1, false, false, false,  3, 2,  3, 2,  1, 10}, // #406
  {DBGFIELD("CMPB_CMPB8")         1, false, false, false,  3, 2,  3, 2,  1, 10}, // #407
  {DBGFIELD("EXTSWSLI_EXTSWSLI_32_64_SRADI_SRADI_32") 1, false, false, false,  3, 2,  3, 2,  1, 10}, // #408
  {DBGFIELD("SLW_SLW8_SRW_SRW8")  1, false, false, false,  3, 2,  3, 2,  1, 10}, // #409
  {DBGFIELD("VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEQV_VNAND_VORC_VSLD_VSRAD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_XXLAND_XXLANDC_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC") 1, false, false, false,  3, 2,  3, 2,  1, 10}, // #410
  {DBGFIELD("VAND_VANDC_VMRGEW_VMRGOW_VNOR_VOR_VRLB_VRLD_VRLDNM_VRLH_VRLW_VRLWNM_VSLB_VSLH_VSLW_VSRAB_VSRAH_VSRAW_VSRB_VSRH_VSRW_XSCPSGNQP_XSIEXPQP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP") 1, false, false, false,  3, 2,  3, 2,  1, 10}, // #411
  {DBGFIELD("VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW") 1, false, false, false,  3, 2,  3, 2,  1, 10}, // #412
  {DBGFIELD("ADDEX_ADDEX8")       1, false, false, false,  3, 2,  3, 2, 11, 15}, // #413
  {DBGFIELD("DST_DST64_DSTT_DSTT64_DSTST_DSTST64_DSTSTT_DSTSTT64") 1, false, false, false,  3, 2,  3, 2, 11, 15}, // #414
  {DBGFIELD("RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32") 1, false, false, false,  3, 2,  3, 2, 11, 15}, // #415
  {DBGFIELD("MFFS_MFFS_rec_MFFSL") 1, false, false, false,  5, 3, 12, 3,  0, 0}, // #416
  {DBGFIELD("TRECHKPT")           1, false, false, false,  5, 3, 12, 3,  0, 0}, // #417
  {DBGFIELD("ADDME8_rec_ADDME_rec_ADDME8O_rec_ADDMEO_rec_ADDZE8_rec_ADDZE_rec_ADDZE8O_rec_ADDZEO_rec_SUBFME8_rec_SUBFME_rec_SUBFME8O_rec_SUBFMEO_rec_SUBFZE8_rec_SUBFZE_rec_SUBFZE8O_rec_SUBFZEO_rec") 1, false, false, false,  5, 3, 12, 3,  1, 5}, // #418
  {DBGFIELD("MTFSB0")             1, false, false, false,  5, 3, 12, 3,  1, 5}, // #419
  {DBGFIELD("NEG8O_rec_NEGO_rec") 1, false, false, false,  5, 3, 12, 3,  1, 5}, // #420
  {DBGFIELD("ADDE8_rec_ADDE_rec_ADDE8O_rec_ADDEO_rec_ADDIC_rec_SUBFE8_rec_SUBFE_rec_SUBFE8O_rec_SUBFEO_rec_SUBF8O_rec_SUBFO_rec") 1, false, false, false,  5, 3, 12, 3,  1, 10}, // #421
  {DBGFIELD("HRFID")              2, false, false, false,  8, 3,  8, 4,  0, 0}, // #422
  {DBGFIELD("FABSD_rec_FABSS_rec_FMR_rec_FNABSD_rec_FNABSS_rec_FNEGD_rec_FNEGS_rec") 2, false, false, false,  8, 3,  8, 4,  1, 5}, // #423
  {DBGFIELD("SC")                 2, false, false, false,  8, 3,  8, 4,  1, 5}, // #424
  {DBGFIELD("ADDC_ADDC8_ADDC8O_ADDCO_SUBFC_SUBFC8_SUBFC8O_SUBFCO") 2, false, false, false,  8, 3,  8, 4,  1, 10}, // #425
  {DBGFIELD("ADDC8_rec_ADDC_rec_SUBFC8_rec_SUBFC_rec") 2, false, false, false,  8, 3,  8, 4,  1, 10}, // #426
  {DBGFIELD("MTFSF_MTFSFI_MTFSFIb") 2, false, false, false,  8, 3,  8, 4,  1, 10}, // #427
  {DBGFIELD("MTFSFI_rec")         2, false, false, false,  8, 3,  8, 4, 11, 15}, // #428
  {DBGFIELD("VSTRIBL_rec_VSTRIBR_rec_VSTRIHL_rec_VSTRIHR_rec") 2, false, false, false, 131, 4, 192, 4,  0, 0}, // #429
  {DBGFIELD("LBZ_LBZ8_LDBRX_LHBRX_LHBRX8_LHZ_LHZ8_LWBRX_LWBRX8_LWZ_LWZ8") 1, false, false, false, 33, 2, 43, 2, 81, 4}, // #430
  {DBGFIELD("LD")                 1, false, false, false, 33, 2, 43, 2, 81, 4}, // #431
  {DBGFIELD("LDtoc_LDtocBA_LDtocCPT_LDtocJTI_LDtocL_SPILLTOVSR_LD_LWZtoc_LWZtocL") 1, false, false, false, 33, 2, 43, 2, 81, 4}, // #432
  {DBGFIELD("LXVRBX_LXVRDX_LXVRHX_LXVRWX") 1, false, false, false, 33, 2, 43, 2, 81, 4}, // #433
  {DBGFIELD("DCBT_DCBTST")        1, false, false, false, 33, 2, 43, 2, 81, 8}, // #434
  {DBGFIELD("ICBT_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32") 1, false, false, false, 33, 2, 43, 2, 81, 8}, // #435
  {DBGFIELD("LDX_LDXTLS_LDXTLS_") 1, false, false, false, 33, 2, 43, 2, 81, 8}, // #436
  {DBGFIELD("SPILLTOVSR_LDX")     1, false, false, false, 33, 2, 43, 2, 81, 8}, // #437
  {DBGFIELD("LBZCIX_LDCIX_LHZCIX_LWZCIX") 1, false, false, false, 37, 3, 47, 3, 81, 8}, // #438
  {DBGFIELD("MTSR")               1, false, false, false, 37, 3, 47, 3, 81, 8}, // #439
  {DBGFIELD("MTVRSAVE_MTVRSAVEv") 1, false, false, false, 37, 3, 47, 3, 81, 8}, // #440
  {DBGFIELD("LSWI")               4, false, false, false, 47, 3, 57, 8, 81, 8}, // #441
  {DBGFIELD("PLBZ_PLBZ8_PLBZ8pc_PLBZpc_PLD_PLDpc_PLFD_PLFDpc_PLFS_PLFSpc_PLHA_PLHA8_PLHA8pc_PLHApc_PLHZ_PLHZ8_PLHZ8pc_PLHZpc_PLWA_PLWA8_PLWA8pc_PLWApc_PLWZ_PLWZ8_PLWZ8pc_PLWZpc_PLXSD_PLXSDpc_PLXSSP_PLXSSPpc_PLXV_PLXVpc_PLXVP_PLXVPpc") 1, false, false, false, 135, 4, 43, 2, 81, 4}, // #442
  {DBGFIELD("LXVP_LXVPX")         2, false, false, false, 139, 5, 65, 3,  0, 0}, // #443
  {DBGFIELD("MFSR")               1, false, false, false, 66, 3, 82, 3,  0, 0}, // #444
  {DBGFIELD("MFTB8")              1, false, false, false, 66, 3, 82, 3,  0, 0}, // #445
  {DBGFIELD("XXSETACCZ")          1, false, false, false, 144, 2, 196, 2,  0, 0}, // #446
  {DBGFIELD("XVBF16GER2_XVF16GER2_XVF32GER_XVF64GER_XVI16GER2_XVI16GER2S_XVI4GER8_XVI8GER4") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("XVBF16GER2NN_XVBF16GER2NP_XVBF16GER2PN_XVBF16GER2PP_XVF16GER2NN_XVF16GER2NP_XVF16GER2PN_XVF16GER2PP_XVF32GERNN_XVF32GERNP_XVF32GERPN_XVF32GERPP_XVF64GERNN_XVF64GERNP_XVF64GERPN_XVF64GERPP_XVI16GER2PP_XVI16GER2SPP_XVI4GER8PP_XVI8GER4PP") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("XVI8GER4SPP")        8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("PMXVF32GER_PMXVF64GER") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #450
  {DBGFIELD("PMXVBF16GER2_PMXVF16GER2_PMXVF32GERNN_PMXVF32GERNP_PMXVF32GERPN_PMXVF32GERPP_PMXVF64GERNN_PMXVF64GERNP_PMXVF64GERPN_PMXVF64GERPP_PMXVI16GER2_PMXVI16GER2S_PMXVI4GER8_PMXVI8GER4") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #451
  {DBGFIELD("PMXVBF16GER2NN_PMXVBF16GER2NP_PMXVBF16GER2PN_PMXVBF16GER2PP_PMXVF16GER2NN_PMXVF16GER2NP_PMXVF16GER2PN_PMXVF16GER2PP_PMXVI16GER2PP_PMXVI16GER2SPP_PMXVI4GER8PP_PMXVI8GER4PP") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #452
  {DBGFIELD("PMXVI8GER4SPP")      8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #453
  {DBGFIELD("XXMTACC")            2, false, false, false, 146, 5, 198, 3,  0, 0}, // #454
  {DBGFIELD("XXMFACC")            4, false, false, false, 151, 5, 201, 6,  0, 0}, // #455
  {DBGFIELD("MULLD_MULLDO")       1, false, false, false, 13, 2, 19, 2, 72, 6}, // #456
  {DBGFIELD("VMULHSD_VMULHUD_VMULLD") 1, false, false, false, 13, 2, 19, 2, 72, 6}, // #457
  {DBGFIELD("VSPLTISW")           1, false, false, false,  1, 2,  1, 2,  0, 0}, // #458
  {DBGFIELD("V_SETALLONES_V_SETALLONESB_V_SETALLONESH") 1, false, false, false,  1, 2,  1, 2,  0, 0}, // #459
  {DBGFIELD("MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VPRTYBQ") 1, false, false, false,  1, 2,  1, 2,  1, 5}, // #460
  {DBGFIELD("VGBBD_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW") 1, false, false, false,  1, 2,  1, 2,  1, 5}, // #461
  {DBGFIELD("VSPLTISB_VSPLTISH_XXSPLTIB") 1, false, false, false,  1, 2,  1, 2,  1, 5}, // #462
  {DBGFIELD("VSTRIBL_VSTRIBR_VSTRIHL_VSTRIHR") 1, false, false, false,  1, 2,  1, 2,  1, 5}, // #463
  {DBGFIELD("XVCVBF16SPN")        1, false, false, false,  1, 2,  1, 2,  1, 5}, // #464
  {DBGFIELD("VBPERMQ_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLO_VSLV_VSR_VSRO_VSRV_XXEXTRACTUW") 1, false, false, false,  1, 2,  1, 2,  1, 10}, // #465
  {DBGFIELD("VCLRLB_VCLRRB_XXGENPCVDM_XXGENPCVHM_XXGENPCVWM") 1, false, false, false,  1, 2,  1, 2,  1, 10}, // #466
  {DBGFIELD("VEXTRACTD_VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VINSERTD_VINSERTW") 1, false, false, false,  1, 2,  1, 2,  1, 10}, // #467
  {DBGFIELD("VEXTDDVLX_VEXTDDVRX_VEXTDUBVLX_VEXTDUBVRX_VEXTDUHVLX_VEXTDUHVRX_VEXTDUWVLX_VEXTDUWVRX_VINSBLX_VINSBRX_VINSBVLX_VINSBVRX_VINSD_VINSDLX_VINSDRX_VINSHLX_VINSHRX_VINSHVLX_VINSHVRX_VINSW_VINSWLX_VINSWRX_VINSWVLX_VINSWVRX_VSLDBI_VSRDBI") 1, false, false, false,  1, 2,  1, 2, 11, 15}, // #468
  {DBGFIELD("VSUMSWS")            2, false, false, false, 156, 4, 207, 4,  0, 0}, // #469
  {DBGFIELD("XXSPLTIDP_XXSPLTIW") 1, false, false, false, 160, 4,  1, 2,  1, 5}, // #470
  {DBGFIELD("XXBLENDVB_XXBLENDVD_XXBLENDVH_XXBLENDVW_XXSPLTI32DX") 1, false, false, false, 160, 4,  1, 2, 11, 15}, // #471
  {DBGFIELD("XXEVAL")             1, false, false, false, 160, 4,  1, 2, 26, 20}, // #472
  {DBGFIELD("XXPERMX")            1, false, false, false, 160, 4,  1, 2, 26, 20}, // #473
  {DBGFIELD("DCBST_DCBZ")         1, false, false, false, 35, 2, 45, 2,  1, 5}, // #474
  {DBGFIELD("ICBI")               1, false, false, false, 35, 2, 45, 2,  1, 5}, // #475
  {DBGFIELD("DCBF")               1, false, false, false, 35, 2, 45, 2,  1, 10}, // #476
  {DBGFIELD("PSTXVP_PSTXVPpc")    1, false, false, false, 35, 2, 45, 2,  1, 10}, // #477
  {DBGFIELD("STB_STB8_STDBRX_STH_STH8_STHBRX_STW_STW8_STWBRX") 1, false, false, false, 35, 2, 45, 2,  1, 10}, // #478
  {DBGFIELD("SPILLTOVSR_ST")      1, false, false, false, 35, 2, 45, 2,  1, 10}, // #479
  {DBGFIELD("STD")                1, false, false, false, 35, 2, 45, 2,  1, 10}, // #480
  {DBGFIELD("DFSTOREf32_DFSTOREf64_STIWX") 1, false, false, false, 35, 2, 45, 2,  1, 10}, // #481
  {DBGFIELD("STXVRBX_STXVRDX_STXVRHX_STXVRWX") 1, false, false, false, 35, 2, 45, 2,  1, 10}, // #482
  {DBGFIELD("SPILLTOVSR_STX")     1, false, false, false, 35, 2, 45, 2, 11, 15}, // #483
  {DBGFIELD("EnforceIEIO")        1, false, false, false, 44, 3, 54, 3,  0, 0}, // #484
  {DBGFIELD("STBCIX_STDCIX_STHCIX_STWCIX") 1, false, false, false, 44, 3, 54, 3, 11, 15}, // #485
  {DBGFIELD("PSTB_PSTB8_PSTB8pc_PSTBpc_PSTD_PSTDpc_PSTFD_PSTFDpc_PSTFS_PSTFSpc_PSTH_PSTH8_PSTH8pc_PSTHpc_PSTW_PSTW8_PSTW8pc_PSTWpc_PSTXSD_PSTXSDpc_PSTXSSP_PSTXSSPpc_PSTXV_PSTXVpc") 1, false, false, false, 164, 4, 45, 2,  1, 10}, // #486
  {DBGFIELD("STXVP_STXVPX")       2, false, false, false, 168, 4, 72, 3,  1, 10}, // #487
  {DBGFIELD("ATTN_NAP")           1, false, false, false, 11, 2, 15, 2,  0, 0}, // #488
  {DBGFIELD("DCBZL")              1, false, false, false, 11, 2, 15, 2,  0, 0}, // #489
  {DBGFIELD("DCCCI_ICBLQ_ICCCI_TLBLD_TLBLI_TLBRE2_TLBSX2_TLBSX2D_TLBWE2") 1, false, false, false, 11, 2, 15, 2,  0, 0}, // #490
  {DBGFIELD("ICBLC")              1, false, false, false, 11, 2, 15, 2,  0, 0}, // #491
  {DBGFIELD("CLRBHRB")            1, false, false, false, 66, 3, 85, 3,  0, 0}, // #492
  {DBGFIELD("MFBHRBE")            1, false, false, false, 66, 3, 85, 3, 95, 12}, // #493
  {DBGFIELD("PADDI_PADDI8_PADDI8pc_PADDIpc") 1, false, false, false, 172, 4, 67, 2, 89, 6}, // #494
  {DBGFIELD("PLI_PLI8")           1, false, false, false, 172, 4, 67, 2, 89, 6}, // #495
  {DBGFIELD("VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS") 1, false, false, false, 13, 2, 17, 2, 51, 14}, // #496
  {DBGFIELD("VMULESD_VMULEUD_VMULHSW_VMULHUW_VMULOSD_VMULOUD") 1, false, false, false, 13, 2, 17, 2, 51, 14}, // #497
  {DBGFIELD("VMSUMCUD")           1, false, false, false, 13, 2, 17, 2, 51, 21}, // #498
  {DBGFIELD("P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_2C_P10BF_Read_2C_P10BF_Read_2C") 1, false, false, false, 13, 2, 21, 2, 115, 3}, // #499
  {DBGFIELD("P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_1C_P10BF_Read_1C_P10BF_Read_1C") 1, false, false, false, 13, 2, 21, 2, 118, 18}, // #500
  {DBGFIELD("P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_2C_P10BF_Read_2C") 1, false, false, false, 13, 2, 21, 2, 115, 2}, // #501
  {DBGFIELD("P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_1C_P10BF_Read_1C") 1, false, false, false, 13, 2, 21, 2, 118, 12}, // #502
  {DBGFIELD("P10W_BF_27C_P10W_DISP_ANY_P10BF_Read_2C_P10BF_Read_2C") 1, false, false, false, 176, 2, 90, 2, 115, 2}, // #503
  {DBGFIELD("P10W_BF_27C_P10W_DISP_ANY_P10BF_Read_1C_P10BF_Read_1C") 1, false, false, false, 176, 2, 90, 2, 118, 12}, // #504
  {DBGFIELD("P10W_BF_36C_P10W_DISP_ANY_P10BF_Read_2C") 1, false, false, false, 178, 2, 121, 2, 115, 1}, // #505
  {DBGFIELD("P10W_BF_36C_P10W_DISP_ANY_P10BF_Read_1C") 1, false, false, false, 178, 2, 121, 2, 52, 6}, // #506
  {DBGFIELD("P10W_BF_27C_P10W_DISP_ANY_P10BF_Read_2C") 1, false, false, false, 176, 2, 90, 2, 115, 1}, // #507
  {DBGFIELD("P10W_BF_27C_P10W_DISP_ANY_P10BF_Read_1C") 1, false, false, false, 176, 2, 90, 2, 52, 6}, // #508
  {DBGFIELD("P10W_BF_26C_P10W_DISP_ANY_P10BF_Read_2C") 1, false, false, false, 180, 2, 125, 2, 115, 1}, // #509
  {DBGFIELD("P10W_BF_26C_P10W_DISP_ANY_P10BF_Read_1C") 1, false, false, false, 180, 2, 125, 2, 52, 6}, // #510
  {DBGFIELD("P10W_BF_22C_P10W_DISP_ANY_P10BF_Read_2C_P10BF_Read_2C") 1, false, false, false, 180, 2, 129, 2, 115, 2}, // #511
  {DBGFIELD("P10W_BF_22C_P10W_DISP_ANY_P10BF_Read_1C_P10BF_Read_1C") 1, false, false, false, 180, 2, 129, 2, 118, 12}, // #512
  {DBGFIELD("P10W_BF_24C_P10W_DISP_ANY_P10BF_Read_2C_P10BF_Read_2C") 1, false, false, false, 182, 2, 33, 2, 115, 2}, // #513
  {DBGFIELD("P10W_BF_24C_P10W_DISP_ANY_P10BF_Read_1C_P10BF_Read_1C") 1, false, false, false, 182, 2, 33, 2, 118, 12}, // #514
  {DBGFIELD("P10W_CY_7C_P10W_DISP_ANY_P10CY_Read_3C_P10CY_Read_3C") 1, false, false, false, 184, 2, 211, 2, 136, 2}, // #515
  {DBGFIELD("P10W_CY_7C_P10W_DISP_ANY_P10CY_Read_1C_P10CY_Read_1C") 1, false, false, false, 184, 2, 211, 2, 138, 12}, // #516
  {DBGFIELD("P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_2C") 1, false, false, false, 13, 2, 21, 2, 115, 1}, // #517
  {DBGFIELD("P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_1C") 1, false, false, false, 13, 2, 21, 2, 52, 6}, // #518
  {DBGFIELD("P10W_BF_7C_P10W_DISP_EVEN_P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_2C") 2, false, false, false, 186, 3, 213, 4, 115, 1}, // #519
  {DBGFIELD("P10W_BF_7C_P10W_DISP_EVEN_P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_1C") 2, false, false, false, 186, 3, 213, 4, 52, 6}, // #520
  {DBGFIELD("P10W_CY_7C_P10W_DISP_ANY_P10CY_Read_3C") 1, false, false, false, 184, 2, 211, 2, 136, 1}, // #521
  {DBGFIELD("P10W_CY_7C_P10W_DISP_ANY_P10CY_Read_1C") 1, false, false, false, 184, 2, 211, 2, 138, 6}, // #522
  {DBGFIELD("P10W_MM_10C_P10W_DISP_ANY_P10MM_Read_6C_P10MM_Read_6C") 1, false, false, false, 144, 2, 196, 2, 150, 2}, // #523
  {DBGFIELD("P10W_MM_10C_P10W_DISP_ANY_P10MM_Read_1C_P10MM_Read_1C") 1, false, false, false, 144, 2, 196, 2, 152, 12}, // #524
  {DBGFIELD("P10W_MM_10C_P10W_DISP_ANY_P10MM_Read_6C_P10MM_Read_6C_P10MM_Read_6C") 1, false, false, false, 144, 2, 196, 2, 164, 3}, // #525
  {DBGFIELD("P10W_MM_10C_P10W_DISP_ANY_P10MM_Read_1C_P10MM_Read_1C_P10MM_Read_1C") 1, false, false, false, 144, 2, 196, 2, 167, 18}, // #526
  {DBGFIELD("P10W_MM_10C_P10W_DISP_PAIR_P10MM_Read_6C_P10MM_Read_6C_P10MM_Read_6C_P10MM_Read_6C") 1, false, false, false, 189, 4, 196, 2, 185, 4}, // #527
  {DBGFIELD("P10W_MM_10C_P10W_DISP_PAIR_P10MM_Read_1C_P10MM_Read_1C_P10MM_Read_1C_P10MM_Read_1C") 1, false, false, false, 189, 4, 196, 2, 189, 24}, // #528
  {DBGFIELD("P10W_MM_10C_P10W_DISP_PAIR_P10MM_Read_6C_P10MM_Read_6C_P10MM_Read_6C_P10MM_Read_6C_P10MM_Read_6C") 1, false, false, false, 189, 4, 196, 2, 213, 5}, // #529
  {DBGFIELD("P10W_MM_10C_P10W_DISP_PAIR_P10MM_Read_1C_P10MM_Read_1C_P10MM_Read_1C_P10MM_Read_1C_P10MM_Read_1C") 1, false, false, false, 189, 4, 196, 2, 218, 30}, // #530
  {DBGFIELD("P10W_MM_10C_P10W_DISP_PAIR_P10MM_Read_6C_P10MM_Read_6C_P10MM_Read_6C_P10MM_Read_6C_P10MM_Read_6C_P10MM_Read_6C") 1, false, false, false, 189, 4, 196, 2, 248, 6}, // #531
  {DBGFIELD("P10W_MM_10C_P10W_DISP_PAIR_P10MM_Read_1C_P10MM_Read_1C_P10MM_Read_1C_P10MM_Read_1C_P10MM_Read_1C_P10MM_Read_1C") 1, false, false, false, 189, 4, 196, 2, 254, 36}, // #532
}; // P10ModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc P9ModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD("IIC_LdStSync")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1
  {DBGFIELD("IIC_IntSimple")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2
  {DBGFIELD("IIC_IntGeneral")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #3
  {DBGFIELD("IIC_BrB")            8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #4
  {DBGFIELD("IIC_VecFP")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #5
  {DBGFIELD("IIC_IntCompare")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #6
  {DBGFIELD("IIC_SprABORT")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #7
  {DBGFIELD("IIC_LdStCOPY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #8
  {DBGFIELD("IIC_LdStPASTE")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #9
  {DBGFIELD("IIC_BrCR")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #10
  {DBGFIELD("IIC_LdStLD")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #11
  {DBGFIELD("IIC_LdStDCBF")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #12
  {DBGFIELD("IIC_LdStLoad")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #13
  {DBGFIELD("IIC_IntDivD")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #14
  {DBGFIELD("IIC_IntDivW")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #15
  {DBGFIELD("IIC_FPDGeneral")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #16
  {DBGFIELD("IIC_FPAddSub")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #17
  {DBGFIELD("IIC_FPDivD")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #18
  {DBGFIELD("IIC_FPSGeneral")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #19
  {DBGFIELD("IIC_FPCompare")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #20
  {DBGFIELD("IIC_FPGeneral")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #21
  {DBGFIELD("IIC_VecGeneral")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #22
  {DBGFIELD("IIC_VecComplex")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #23
  {DBGFIELD("IIC_LdStStore")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #24
  {DBGFIELD("IIC_IntRotateDI")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #25
  {DBGFIELD("IIC_FPDivS")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #26
  {DBGFIELD("IIC_FPFused")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #27
  {DBGFIELD("IIC_FPSqrtD")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #28
  {DBGFIELD("IIC_FPSqrtS")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #29
  {DBGFIELD("IIC_LdStICBI")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #30
  {DBGFIELD("IIC_IntISEL")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #31
  {DBGFIELD("IIC_SprISYNC")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #32
  {DBGFIELD("IIC_LdStLWARX")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #33
  {DBGFIELD("IIC_LdStLoadUpd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #34
  {DBGFIELD("IIC_LdStLoadUpdX")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #35
  {DBGFIELD("IIC_LdStLDARX")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #36
  {DBGFIELD("IIC_LdStLDU")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #37
  {DBGFIELD("IIC_LdStLDUX")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #38
  {DBGFIELD("IIC_LdStLFD")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #39
  {DBGFIELD("IIC_LdStLFDU")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #40
  {DBGFIELD("IIC_LdStLFDUX")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #41
  {DBGFIELD("IIC_LdStLHA")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #42
  {DBGFIELD("IIC_LdStLHAU")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #43
  {DBGFIELD("IIC_LdStLHAUX")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #44
  {DBGFIELD("IIC_LdStLMW")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #45
  {DBGFIELD("IIC_LdStLQ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #46
  {DBGFIELD("IIC_LdStLQARX")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #47
  {DBGFIELD("IIC_LdStLWA")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #48
  {DBGFIELD("IIC_IntMulHD")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #49
  {DBGFIELD("IIC_BrMCR")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #50
  {DBGFIELD("IIC_BrMCRX")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #51
  {DBGFIELD("IIC_SprMFCR")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #52
  {DBGFIELD("IIC_SprMFSPR")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #53
  {DBGFIELD("IIC_IntMFFS")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #54
  {DBGFIELD("IIC_SprMFMSR")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #55
  {DBGFIELD("IIC_SprMFCRF")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #56
  {DBGFIELD("IIC_SprMFPMR")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #57
  {DBGFIELD("IIC_SprMFSR")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #58
  {DBGFIELD("IIC_SprMFTB")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #59
  {DBGFIELD("IIC_SprMSGSYNC")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #60
  {DBGFIELD("IIC_SprMTSPR")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #61
  {DBGFIELD("IIC_IntMTFSB0")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #62
  {DBGFIELD("IIC_SprMTMSR")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #63
  {DBGFIELD("IIC_SprMTMSRD")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #64
  {DBGFIELD("IIC_SprMTPMR")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #65
  {DBGFIELD("IIC_SprMTSR")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #66
  {DBGFIELD("IIC_IntMulHW")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #67
  {DBGFIELD("IIC_IntMulHWU")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #68
  {DBGFIELD("IIC_IntMulLI")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #69
  {DBGFIELD("IIC_SprRFI")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #70
  {DBGFIELD("IIC_IntRFID")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #71
  {DBGFIELD("IIC_IntRotateD")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #72
  {DBGFIELD("IIC_IntRotate")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #73
  {DBGFIELD("IIC_SprSLBFEE")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #74
  {DBGFIELD("IIC_SprSLBIA")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #75
  {DBGFIELD("IIC_SprSLBIE")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #76
  {DBGFIELD("IIC_SprSLBIEG")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #77
  {DBGFIELD("IIC_SprSLBMFEE")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #78
  {DBGFIELD("IIC_SprSLBMFEV")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #79
  {DBGFIELD("IIC_SprSLBMTE")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #80
  {DBGFIELD("IIC_SprSLBSYNC")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #81
  {DBGFIELD("IIC_IntShift")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #82
  {DBGFIELD("IIC_LdStSTWCX")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #83
  {DBGFIELD("IIC_LdStSTU")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #84
  {DBGFIELD("IIC_LdStSTUX")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #85
  {DBGFIELD("IIC_LdStSTD")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #86
  {DBGFIELD("IIC_LdStSTDCX")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #87
  {DBGFIELD("IIC_LdStSTFD")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #88
  {DBGFIELD("IIC_LdStSTFDU")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #89
  {DBGFIELD("IIC_SprSTOP")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #90
  {DBGFIELD("IIC_LdStSTQ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #91
  {DBGFIELD("IIC_LdStSTQCX")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #92
  {DBGFIELD("IIC_IntTrapD")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #93
  {DBGFIELD("IIC_SprTLBIA")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #94
  {DBGFIELD("IIC_SprTLBIE")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #95
  {DBGFIELD("IIC_SprTLBIEL")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #96
  {DBGFIELD("IIC_SprTLBSYNC")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #97
  {DBGFIELD("IIC_IntTrapW")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #98
  {DBGFIELD("IIC_VecFPCompare")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #99
  {DBGFIELD("IIC_VecPerm")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #100
  {DBGFIELD("VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VSLD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_VPOPCNTB_VPOPCNTH_VSRAD_MTVSRDD_VEQV_VNAND_VNEGD_VNEGW_VORC_XXLAND_XXLANDC_XXLEQV_XXLEQVOnes_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz") 2, false, false, false, 193, 7, 217, 5,  0, 0}, // #101
  {DBGFIELD("VAND_VANDC_V_SET0_V_SET0B_V_SET0H_VSLB_VSLH_VSLW_VSRB_VSRH_VSRW_VRLB_VRLD_VRLH_VRLW_VSRAB_VSRAH_VSRAW_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP_XVXEXPDP_XVXEXPSP_VRLDMI_VRLDNM_VRLWMI_VRLWNM_VMRGEW_VMRGOW_VNOR_VOR_VSEL_VXOR_XVNEGDP_XVNEGSP_XSABSQP_XSCPSGNQP_XSIEXPQP_XSNABSQP_XSNEGQP_XSXEXPQP") 2, false, false, false, 193, 7, 217, 5,  0, 0}, // #102
  {DBGFIELD("XXSEL")              2, false, false, false, 193, 7, 217, 5,  0, 0}, // #103
  {DBGFIELD("TABORTDC_TABORTDCI_TABORTWC_TABORTWCI") 1, false, false, false, 200, 7, 222, 3,  0, 0}, // #104
  {DBGFIELD("MTFSB0_MTFSB1")      1, false, false, false, 200, 7, 222, 3,  0, 0}, // #105
  {DBGFIELD("MFFSCDRN_MFFSCDRNI_MFFSCRN_MFFSCRNI") 1, false, false, false, 200, 7, 222, 3,  0, 0}, // #106
  {DBGFIELD("CMPRB_CMPRB8_CMPEQB") 1, false, false, false, 200, 7, 222, 3,  0, 0}, // #107
  {DBGFIELD("TD_TDI")             1, false, false, false, 200, 7, 222, 3,  0, 0}, // #108
  {DBGFIELD("TW_TWI")             1, false, false, false, 200, 7, 222, 3,  0, 0}, // #109
  {DBGFIELD("FCMPOD_FCMPOS_FCMPUD_FCMPUS_FTDIV_FTSQRT") 1, false, false, false, 200, 7, 222, 3,  0, 0}, // #110
  {DBGFIELD("XSTSTDCDP_XSTSTDCSP") 1, false, false, false, 200, 7, 222, 3,  0, 0}, // #111
  {DBGFIELD("XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP_XSXSIGDP_XSCVSPDPN") 1, false, false, false, 207, 3, 222, 3,  0, 0}, // #112
  {DBGFIELD("XSCMPEQDP_XSCMPEXPDP_XSCMPGEDP_XSCMPGTDP_XSCMPODP_XSCMPUDP_XSTDIVDP_XSTSQRTDP") 1, false, false, false, 207, 3, 222, 3,  0, 0}, // #113
  {DBGFIELD("CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW_CMPB_CMPB8_SETB_SETB8_BPERMD") 1, false, false, false, 207, 3, 222, 3,  0, 0}, // #114
  {DBGFIELD("SLD_SRD_SRAD")       1, false, false, false, 207, 3, 218, 3,  0, 0}, // #115
  {DBGFIELD("SRADI_EXTSWSLI_32_64_EXTSWSLI_SRADI_32_RLDIC") 1, false, false, false, 207, 3, 218, 3,  0, 0}, // #116
  {DBGFIELD("MFVRD_MFVSRD_MTVRD_MTVSRD_MTVRWA_MTVRWZ_MTVSRWA_MTVSRWZ_MFVSRWZ_MFVRWZ") 1, false, false, false, 207, 3, 218, 3,  0, 0}, // #117
  {DBGFIELD("CMPLW_CMPLWI_CMPW_CMPWI_CMPD_CMPDI_CMPLD_CMPLDI") 1, false, false, false, 207, 3, 218, 3,  0, 0}, // #118
  {DBGFIELD("SUBFC_SUBFC8_SUBFC8O_SUBFCO_SUBFIC_SUBFIC8_ANDI8_rec_ANDIS8_rec_ANDIS_rec_ANDI_rec_ADDC_ADDC8_ADDC8O_ADDCO_ADDIC_ADDIC8_ADDIC_rec_ADDE_ADDE8_ADDE8O_ADDE8O_rec_ADDE8_rec_ADDEO_ADDEO_rec_ADDE_rec_ADDME_ADDME8_ADDME8O_ADDME8O_rec_ADDME8_rec_ADDMEO_ADDMEO_rec_ADDME_rec_ADDZE_ADDZE8_ADDZE8O_ADDZE8O_rec_ADDZE8_rec_ADDZEO_ADDZEO_rec_ADDZE_rec_SUBF_SUBF8_SUBF8O_SUBF8O_rec_SUBF8_rec_SUBFE_SUBFE8_SUBFE8O_SUBFE8O_rec_SUBFE8_rec_SUBFEO_SUBFEO_rec_SUBFE_rec_SUBFME_SUBFME8_SUBFME8O_SUBFME8O_rec_SUBFME8_rec_SUBFMEO_SUBFMEO_rec_SUBFME_rec_SUBFO_SUBFO_rec_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZE8O_rec_SUBFZE8_rec_SUBFZEO_SUBFZEO_rec_SUBFZE_rec_SUBF_rec_POPCNTB_POPCNTB8_LA_LA8") 1, false, false, false, 207, 3, 218, 3,  0, 0}, // #119
  {DBGFIELD("ADD4_ADD4O_ADD4O_rec_ADD4_rec_ADD8_ADD8O_ADD8O_rec_ADD8_rec_NEG_NEG8_NEG8O_NEG8O_rec_NEG8_rec_NEGO_NEGO_rec_NEG_rec_ADDI_ADDI8_ADDIS_ADDIS8_LI_LI8_LIS_LIS8_OR_OR8_OR8_rec_ORI_ORI8_ORIS_ORIS8_OR_rec_XOR_XOR8_XOR8_rec_XORI_XORI8_XORIS_XORIS8_XOR_rec_NAND_NAND8_NAND8_rec_NAND_rec_AND_AND8_AND8_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_AND_rec_NOR_NOR8_NOR8_rec_NOR_rec_ORC_ORC8_ORC8_rec_ORC_rec_EQV_EQV8_EQV8_rec_EQV_rec_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_ADD4TLS_ADD8TLS_ADD8TLS__NOP") 1, false, false, false, 207, 3, 218, 3,  0, 0}, // #120
  {DBGFIELD("ADDIStocHA_ADDIStocHA8_ADDItocL_COPY") 1, false, false, false, 207, 3, 218, 3,  0, 0}, // #121
  {DBGFIELD("MCRF")               1, false, false, false, 207, 3, 218, 3,  0, 0}, // #122
  {DBGFIELD("MCRXRX")             1, false, false, false, 207, 3, 218, 3,  0, 0}, // #123
  {DBGFIELD("XSNABSDP_XSXEXPDP_XSABSDP_XSNEGDP_XSCPSGNDP") 1, false, false, false, 207, 3, 218, 3,  0, 0}, // #124
  {DBGFIELD("RFEBB")              1, false, false, false, 207, 3, 218, 3,  0, 0}, // #125
  {DBGFIELD("TBEGIN_TRECHKPT")    1, false, false, false, 207, 3, 218, 3,  0, 0}, // #126
  {DBGFIELD("WAIT")               1, false, false, false, 207, 3, 218, 3,  0, 0}, // #127
  {DBGFIELD("RLDCL_RLDCR")        1, false, false, false, 200, 7, 218, 3,  0, 0}, // #128
  {DBGFIELD("RLWIMI_RLWIMI8")     1, false, false, false, 200, 7, 218, 3,  0, 0}, // #129
  {DBGFIELD("RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32_RLDIMI") 1, false, false, false, 200, 7, 218, 3,  0, 0}, // #130
  {DBGFIELD("MFOCRF_MFOCRF8")     1, false, false, false, 200, 7, 218, 3,  0, 0}, // #131
  {DBGFIELD("MTOCRF_MTOCRF8")     1, false, false, false, 200, 7, 218, 3,  0, 0}, // #132
  {DBGFIELD("CR6SET_CR6UNSET_CRSET_CRUNSET_CRAND_CRANDC_CRNAND_CRNOR_CROR_CRORC_CREQV_CRXOR") 1, false, false, false, 200, 7, 218, 3,  0, 0}, // #133
  {DBGFIELD("SLW_SLW8_SRW_SRW8_RLWINM_RLWINM8_RLWNM_RLWNM8") 1, false, false, false, 200, 7, 218, 3,  0, 0}, // #134
  {DBGFIELD("FABSD_FABSS_FNABSD_FNABSS_FNEGD_FNEGS_FCPSGND_FCPSGNS_FMR") 1, false, false, false, 200, 7, 218, 3,  0, 0}, // #135
  {DBGFIELD("SRAW_SRAWI")         1, false, false, false, 200, 7, 218, 3,  0, 0}, // #136
  {DBGFIELD("ISEL_ISEL8")         1, false, false, false, 200, 7, 218, 3,  0, 0}, // #137
  {DBGFIELD("XSIEXPDP")           1, false, false, false, 200, 7, 218, 3,  0, 0}, // #138
  {DBGFIELD("TRECLAIM_TSR_TABORT") 1, false, false, false, 200, 7, 218, 3,  0, 0}, // #139
  {DBGFIELD("MFVSCR")             2, false, false, false, 193, 7, 225, 5,  0, 0}, // #140
  {DBGFIELD("MTVSCR")             2, false, false, false, 193, 7, 225, 5,  0, 0}, // #141
  {DBGFIELD("VCMPNEZB_VCMPNEZH_VCMPNEZW_VCMPEQUB_VCMPEQUD_VCMPEQUH_VCMPEQUW_VCMPNEB_VCMPNEH_VCMPNEW_VCMPEQFP_VCMPEQFP_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPBFP_VCMPBFP_rec_VCMPGTSB_VCMPGTSB_rec_VCMPGTSD_VCMPGTSD_rec_VCMPGTSH_VCMPGTSH_rec_VCMPGTSW_VCMPGTSW_rec_VCMPGTUB_VCMPGTUB_rec_VCMPGTUD_VCMPGTUD_rec_VCMPGTUH_VCMPGTUH_rec_VCMPGTUW_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec") 2, false, false, false, 193, 7, 225, 5,  0, 0}, // #142
  {DBGFIELD("VABSDUB_VABSDUH_VABSDUW_VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTW_VPOPCNTD_VPRTYBD_VPRTYBW") 2, false, false, false, 193, 7, 225, 5,  0, 0}, // #143
  {DBGFIELD("VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VADDSBS_VADDSHS_VADDSWS_VMAXFP_VMINFP_VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW_VBPERMD_VADDCUW_VSHASIGMAD_VSHASIGMAW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_VSUBCUW_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP_XVXSIGDP_XVXSIGSP") 2, false, false, false, 193, 7, 225, 5,  0, 0}, // #144
  {DBGFIELD("XVTDIVDP_XVTDIVSP_XVTSQRTDP_XVTSQRTSP") 2, false, false, false, 193, 7, 225, 5,  0, 0}, // #145
  {DBGFIELD("VADDFP_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VEXPTEFP_VLOGEFP_VMADDFP_VMHADDSHS_VNMSUBFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVADDDP_XVADDSP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVHPSP_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVMULDP_XVMULSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP_XVSUBDP_XVSUBSP_VCFSX_VCFSX_0_VCFUX_VCFUX_0_VMHRADDSHS_VMLADDUHM_VMSUMMBM_VMSUMSHM_VMSUMSHS_VMSUMUBM_VMSUMUHM_VMSUMUDM_VMSUMUHS_VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS_VSUMSWS") 2, false, false, false, 210, 7, 230, 5,  0, 0}, // #146
  {DBGFIELD("VSUBFP_VMULUWM")     2, false, false, false, 210, 7, 230, 5,  0, 0}, // #147
  {DBGFIELD("MADDHD_MADDHDU_MADDLD_MADDLD8_MULLD_MULLDO") 1, false, false, false, 217, 7, 235, 3,  0, 0}, // #148
  {DBGFIELD("MULHD_MULHW_MULLW_MULLWO") 1, false, false, false, 217, 7, 235, 3,  0, 0}, // #149
  {DBGFIELD("MULHDU_MULHWU")      1, false, false, false, 217, 7, 235, 3,  0, 0}, // #150
  {DBGFIELD("MULLI_MULLI8")       1, false, false, false, 217, 7, 235, 3,  0, 0}, // #151
  {DBGFIELD("FRSP_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRE_FRES_FADDS_FMSUBS_FMADDS_FSUBS_FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRSQRTE_FRSQRTES_FNMADDS_FNMSUBS_FSELD_FSELS_FMULS") 1, false, false, false, 217, 7, 231, 3,  0, 0}, // #152
  {DBGFIELD("FADD_FSUB")          1, false, false, false, 217, 7, 231, 3,  0, 0}, // #153
  {DBGFIELD("FMSUB_FMADD_FNMADD_FNMSUB_FMUL") 1, false, false, false, 217, 7, 231, 3,  0, 0}, // #154
  {DBGFIELD("XSMADDADP_XSMADDASP_XSMADDMDP_XSMADDMSP_XSMSUBADP_XSMSUBASP_XSMSUBMDP_XSMSUBMSP_XSMULDP_XSMULSP_XSNMADDADP_XSNMADDASP_XSNMADDMDP_XSNMADDMSP_XSNMSUBADP_XSNMSUBASP_XSNMSUBMDP_XSNMSUBMSP") 1, false, false, false, 217, 7, 231, 3,  0, 0}, // #155
  {DBGFIELD("FSELD_rec_FSELS_rec") 2, false, false, false, 224, 8, 238, 6,  0, 0}, // #156
  {DBGFIELD("MULHDU_rec_MULHWU_rec") 2, false, false, false, 224, 8, 244, 5,  0, 0}, // #157
  {DBGFIELD("MULHD_rec_MULHW_rec_MULLWO_rec_MULLW_rec") 2, false, false, false, 224, 8, 244, 5,  0, 0}, // #158
  {DBGFIELD("MULLDO_rec_MULLD_rec") 2, false, false, false, 224, 8, 244, 5,  0, 0}, // #159
  {DBGFIELD("FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRES_rec_FRE_rec_FADDS_rec_FSUBS_rec_FMSUBS_rec_FNMSUBS_rec_FMADDS_rec_FNMADDS_rec_FCFIDS_rec_FCFIDUS_rec_FCFIDU_rec_FCFID_rec_FCTIDUZ_rec_FCTIDU_rec_FCTIDZ_rec_FCTID_rec_FCTIWUZ_rec_FCTIWU_rec_FCTIWZ_rec_FCTIW_rec_FMULS_rec_FRSQRTES_rec_FRSQRTE_rec_FRSP_rec") 2, false, false, false, 224, 8, 249, 5,  0, 0}, // #160
  {DBGFIELD("FADD_rec_FSUB_rec")  2, false, false, false, 224, 8, 249, 5,  0, 0}, // #161
  {DBGFIELD("FMSUB_rec_FNMSUB_rec_FMADD_rec_FNMADD_rec_FMUL_rec") 2, false, false, false, 224, 8, 249, 5,  0, 0}, // #162
  {DBGFIELD("XSADDDP_XSADDSP_XSCVDPHP_XSCVDPSP_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPSXWSs_XSCVDPUXWSs_XSCVHPDP_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSQRTEDP_XSRSQRTESP_XSSUBDP_XSSUBSP_XSCVDPSPN_XSRSP") 1, false, false, false, 232, 3, 231, 3,  0, 0}, // #163
  {DBGFIELD("LVSL_LVSR")          1, false, false, false, 235, 5, 226, 4,  0, 0}, // #164
  {DBGFIELD("VSPLTISB_VSPLTISH_VSPLTISW_VSPLTB_VSPLTBs_VSPLTH_VSPLTHs_VSPLTW_XXMRGHW_XXMRGLW_XXPERM_XXPERMR_XXSLDWI_XXSLDWIs_XXSPLTIB_XXSPLTW_XXSPLTWs_XXPERMDI_XXPERMDIs") 1, false, false, false, 235, 5, 226, 4,  0, 0}, // #165
  {DBGFIELD("V_SETALLONES_V_SETALLONESB_V_SETALLONESH_VBPERMQ_VGBBD_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPERM_VPERMR_VPERMXOR_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLDOI_VSLO_VSLV_VSR_VSRO_VSRV_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW_XXEXTRACTUW_XXINSERTW_VADDCUQ_VADDECUQ_VADDEUQM_VMUL10CUQ_VMUL10ECUQ_VMUL10EUQ_VMUL10UQ_VSUBCUQ_VSUBECUQ_VSUBEUQM_XSTSTDCQP_XSXSIGQP_BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDS_rec_BCDTRUNC_rec_BCDUS_rec_BCDUTRUNC_rec_BCDADD_rec_BCDSUB_rec") 1, false, false, false, 235, 5, 226, 4,  0, 0}, // #166
  {DBGFIELD("VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VINSERTB_VINSERTD_VINSERTH_VINSERTW_MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VEXTRACTD_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VPRTYBQ_VADDUQM_VSUBUQM") 1, false, false, false, 235, 5, 226, 4,  0, 0}, // #167
  {DBGFIELD("XSCMPEXPQP_XSCMPOQP_XSCMPUQP") 1, false, false, false, 235, 5, 226, 4,  0, 0}, // #168
  {DBGFIELD("BCDSR_rec_XSADDQP_XSADDQPO_XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP_XSRQPI_XSRQPIX_XSRQPXP_XSSUBQP_XSSUBQPO") 1, false, false, false, 240, 5, 254, 4,  0, 0}, // #169
  {DBGFIELD("BCDCTSQ_rec")        1, false, false, false, 245, 5, 258, 4,  0, 0}, // #170
  {DBGFIELD("XSMADDQP_XSMADDQPO_XSMSUBQP_XSMSUBQPO_XSMULQP_XSMULQPO_XSNMADDQP_XSNMADDQPO_XSNMSUBQP_XSNMSUBQPO") 1, false, false, false, 250, 5, 262, 4,  0, 0}, // #171
  {DBGFIELD("BCDCFSQ_rec")        1, false, false, false, 255, 5, 266, 4,  0, 0}, // #172
  {DBGFIELD("XSDIVQP_XSDIVQPO")   1, false, false, false, 260, 5, 270, 4,  0, 0}, // #173
  {DBGFIELD("XSSQRTQP_XSSQRTQPO") 1, false, false, false, 265, 5, 274, 4,  0, 0}, // #174
  {DBGFIELD("LXVL_LXVLL")         1, false, false, false, 270, 3, 47, 3,  0, 0}, // #175
  {DBGFIELD("LVEBX_LVEHX_LVEWX_LVX_LVXL") 1, false, false, false, 270, 3, 235, 3,  0, 0}, // #176
  {DBGFIELD("LXSIBZX_LXSIHZX_LXSDX_LXVB16X_LXVD2X_LXVWSX_LXSIWZX_LXV_LXVX_LXSD") 1, false, false, false, 270, 3, 235, 3,  0, 0}, // #177
  {DBGFIELD("DFLOADf64_XFLOADf64_LIWZX") 1, false, false, false, 270, 3, 235, 3,  0, 0}, // #178
  {DBGFIELD("DCBF_DCBFEP_DCBST_DCBSTEP_DCBT_DCBTEP_DCBZ_DCBZEP_DCBZL_DCBZLEP_DCBTST_DCBTSTEP") 1, false, false, false, 270, 3, 278, 3,  0, 0}, // #179
  {DBGFIELD("CP_COPY_CP_COPY8")   1, false, false, false, 270, 3, 278, 3,  0, 0}, // #180
  {DBGFIELD("ICBI_ICBIEP")        1, false, false, false, 270, 3, 278, 3,  0, 0}, // #181
  {DBGFIELD("ICBT_ICBTLS_LBZ_LBZ8_LBZCIX_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LDBRX_LDCIX_LHBRX_LHBRX8_LHZ_LHZ8_LHZCIX_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWBRX_LWBRX8_LWZ_LWZ8_LWZCIX_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32_EnforceIEIO_LSWI") 1, false, false, false, 270, 3, 278, 3,  0, 0}, // #182
  {DBGFIELD("LBARX_LBARXL_LHARX_LHARXL_LWARX_LWARXL") 1, false, false, false, 270, 3, 278, 3,  0, 0}, // #183
  {DBGFIELD("LD_LDX_LDXTLS_LDXTLS__DARN") 1, false, false, false, 270, 3, 278, 3,  0, 0}, // #184
  {DBGFIELD("LDARX_LDARXL")       1, false, false, false, 270, 3, 278, 3,  0, 0}, // #185
  {DBGFIELD("CP_ABORT")           1, false, false, false, 270, 3, 278, 3,  0, 0}, // #186
  {DBGFIELD("ISYNC")              1, false, false, false, 270, 3, 278, 3,  0, 0}, // #187
  {DBGFIELD("MSGSYNC")            1, false, false, false, 270, 3, 278, 3,  0, 0}, // #188
  {DBGFIELD("TLBSYNC")            1, false, false, false, 270, 3, 278, 3,  0, 0}, // #189
  {DBGFIELD("SYNC")               1, false, false, false, 270, 3, 278, 3,  0, 0}, // #190
  {DBGFIELD("LMW")                1, false, false, false, 270, 3, 278, 3,  0, 0}, // #191
  {DBGFIELD("LFIWZX_LFDX_LFD")    1, false, false, false, 273, 7, 278, 3,  0, 0}, // #192
  {DBGFIELD("SLBIA")              2, false, false, false, 280, 4, 281, 5,  0, 0}, // #193
  {DBGFIELD("SLBIE")              2, false, false, false, 280, 4, 281, 5,  0, 0}, // #194
  {DBGFIELD("SLBMFEE")            2, false, false, false, 280, 4, 281, 5,  0, 0}, // #195
  {DBGFIELD("SLBMFEV")            2, false, false, false, 280, 4, 281, 5,  0, 0}, // #196
  {DBGFIELD("SLBMTE")             2, false, false, false, 280, 4, 281, 5,  0, 0}, // #197
  {DBGFIELD("TLBIEL")             2, false, false, false, 280, 4, 281, 5,  0, 0}, // #198
  {DBGFIELD("LHZU_LHZU8_LWZU_LWZU8") 2, false, false, false, 284, 6, 286, 6,  0, 0}, // #199
  {DBGFIELD("LHZUX_LHZUX8_LWZUX_LWZUX8") 2, false, false, false, 284, 6, 286, 6,  0, 0}, // #200
  {DBGFIELD("TEND")               2, false, false, false, 290, 5, 286, 6,  0, 0}, // #201
  {DBGFIELD("STBCX_STHCX_STWCX")  2, false, false, false, 295, 9, 292, 6,  0, 0}, // #202
  {DBGFIELD("STDCX")              2, false, false, false, 295, 9, 292, 6,  0, 0}, // #203
  {DBGFIELD("LDMX")               2, false, false, false, 304, 3, 298, 5,  0, 0}, // #204
  {DBGFIELD("LHA_LHA8_LHAX_LHAX8_LWAX_LWAX_32") 2, false, false, false, 290, 5, 303, 5,  0, 0}, // #205
  {DBGFIELD("CP_PASTE8_rec_CP_PASTE_rec") 2, false, false, false, 290, 5, 303, 5,  0, 0}, // #206
  {DBGFIELD("LWA_LWA_32")         2, false, false, false, 290, 5, 303, 5,  0, 0}, // #207
  {DBGFIELD("TCHECK")             2, false, false, false, 290, 5, 303, 5,  0, 0}, // #208
  {DBGFIELD("LFIWAX")             2, false, false, false, 307, 9, 303, 5,  0, 0}, // #209
  {DBGFIELD("LXSIWAX")            2, false, false, false, 290, 5, 244, 5,  0, 0}, // #210
  {DBGFIELD("LIWAX")              2, false, false, false, 290, 5, 244, 5,  0, 0}, // #211
  {DBGFIELD("LFSX_LFS")           2, false, false, false, 307, 9, 244, 5,  0, 0}, // #212
  {DBGFIELD("LXSSP_LXSSPX")       2, false, false, false, 290, 5, 298, 5,  0, 0}, // #213
  {DBGFIELD("XFLOADf32_DFLOADf32") 2, false, false, false, 290, 5, 298, 5,  0, 0}, // #214
  {DBGFIELD("LHAU_LHAU8")         3, false, false, false, 316, 6, 308, 8,  0, 0}, // #215
  {DBGFIELD("LHAUX_LHAUX8_LWAUX") 3, false, false, false, 316, 6, 308, 8,  0, 0}, // #216
  {DBGFIELD("LXVH8X_LXVDSX_LXVW4X") 2, false, false, false, 322, 7, 316, 6,  0, 0}, // #217
  {DBGFIELD("STFD_STFDX_STFIWX_STFS_STFSX_STXSD_STXSDX_STXSIBX_STXSIBXv_STXSIHX_STXSIHXv_STXSIWX_STXSSP_STXSSPX") 1, false, false, false, 329, 8, 240, 4,  0, 0}, // #218
  {DBGFIELD("STW_STW8_STDBRX_STHBRX_STWBRX_STB_STB8_STH_STH8_STBX_STBX8_STBXTLS_STBXTLS__STBXTLS_32_STHX_STHX8_STHXTLS_STHXTLS__STHXTLS_32_STWX_STWX8_STWXTLS_STWXTLS__STWXTLS_32") 1, false, false, false, 329, 8, 240, 4,  0, 0}, // #219
  {DBGFIELD("DFSTOREf32_DFSTOREf64_XFSTOREf32_XFSTOREf64_STIWX") 1, false, false, false, 329, 8, 240, 4,  0, 0}, // #220
  {DBGFIELD("STD_STDX_STDXTLS_STDXTLS_") 1, false, false, false, 329, 8, 240, 4,  0, 0}, // #221
  {DBGFIELD("STBCIX_STDCIX_STHCIX_STWCIX_STSWI") 1, false, false, false, 329, 8, 240, 4,  0, 0}, // #222
  {DBGFIELD("SLBIEG")             1, false, false, false, 329, 8, 240, 4,  0, 0}, // #223
  {DBGFIELD("STMW")               1, false, false, false, 329, 8, 240, 4,  0, 0}, // #224
  {DBGFIELD("TLBIE")              1, false, false, false, 329, 8, 240, 4,  0, 0}, // #225
  {DBGFIELD("STVEBX_STVEHX_STVEWX_STVX_STVXL") 1, false, false, false, 337, 6, 293, 5,  0, 0}, // #226
  {DBGFIELD("STXV_STXVB16X_STXVD2X_STXVH8X_STXVW4X_STXVX") 1, false, false, false, 337, 6, 293, 5,  0, 0}, // #227
  {DBGFIELD("STXVL_STXVLL")       1, false, false, false, 337, 6, 293, 5,  0, 0}, // #228
  {DBGFIELD("MTCTR_MTCTR8_MTCTR8loop_MTCTRloop_MTLR_MTLR8") 1, false, false, false, 343, 8, 322, 4,  0, 0}, // #229
  {DBGFIELD("MFVRSAVE_MFVRSAVEv_MTVRSAVE_MTVRSAVEv") 1, false, false, false, 343, 8, 254, 4,  0, 0}, // #230
  {DBGFIELD("MFPMR")              1, false, false, false, 343, 8, 254, 4,  0, 0}, // #231
  {DBGFIELD("MTPMR")              1, false, false, false, 343, 8, 254, 4,  0, 0}, // #232
  {DBGFIELD("MFTB_MFTB8")         1, false, false, false, 343, 8, 254, 4,  0, 0}, // #233
  {DBGFIELD("MFCTR_MFCTR8_MFLR_MFLR8_MFSPR_MFSPR8") 1, false, false, false, 343, 8, 254, 4,  0, 0}, // #234
  {DBGFIELD("MFMSR")              1, false, false, false, 343, 8, 254, 4,  0, 0}, // #235
  {DBGFIELD("MTMSR")              1, false, false, false, 343, 8, 254, 4,  0, 0}, // #236
  {DBGFIELD("MTMSRD")             1, false, false, false, 343, 8, 254, 4,  0, 0}, // #237
  {DBGFIELD("MTSPR_MTSPR8")       1, false, false, false, 343, 8, 254, 4,  0, 0}, // #238
  {DBGFIELD("DIVW_DIVWO_DIVWU_DIVWUO_MODSW") 1, false, false, false, 351, 8, 326, 4,  0, 0}, // #239
  {DBGFIELD("DIVWE_DIVWEO_DIVWEU_DIVWEUO_MODSD_MODUD_MODUW") 1, false, false, false, 351, 8, 262, 4,  0, 0}, // #240
  {DBGFIELD("DIVD_DIVDO_DIVDU_DIVDUO") 1, false, false, false, 351, 8, 262, 4,  0, 0}, // #241
  {DBGFIELD("DIVDE_DIVDEO_DIVDEU_DIVDEUO") 1, false, false, false, 351, 8, 330, 4,  0, 0}, // #242
  {DBGFIELD("DIVWO_rec_DIVWUO_rec_DIVWU_rec_DIVW_rec") 2, false, false, false, 359, 9, 334, 6,  0, 0}, // #243
  {DBGFIELD("DIVD_rec_DIVDO_rec_DIVDU_rec_DIVDUO_rec") 2, false, false, false, 359, 9, 340, 6,  0, 0}, // #244
  {DBGFIELD("DIVWE_rec_DIVWEO_rec_DIVWEU_rec_DIVWEUO_rec") 2, false, false, false, 359, 9, 340, 6,  0, 0}, // #245
  {DBGFIELD("DIVDE_rec_DIVDEO_rec_DIVDEU_rec_DIVDEUO_rec") 2, false, false, false, 359, 9, 346, 6,  0, 0}, // #246
  {DBGFIELD("MTCRF_MTCRF8")       2, false, false, false, 368, 7, 352, 6,  0, 0}, // #247
  {DBGFIELD("ADDC8O_rec_ADDC8_rec_ADDCO_rec_ADDC_rec_SUBFC8O_rec_SUBFC8_rec_SUBFCO_rec_SUBFC_rec") 2, false, false, false, 375, 3, 352, 6,  0, 0}, // #248
  {DBGFIELD("FABSD_rec_FABSS_rec_FNABSD_rec_FNABSS_rec_FCPSGND_rec_FCPSGNS_rec_FNEGD_rec_FNEGS_rec_FMR_rec") 2, false, false, false, 378, 7, 358, 6,  0, 0}, // #249
  {DBGFIELD("MCRFS")              2, false, false, false, 375, 3, 364, 6,  0, 0}, // #250
  {DBGFIELD("MTFSF_MTFSF_rec_MTFSFI_MTFSFI_rec_MTFSFIb") 2, false, false, false, 368, 7, 364, 6,  0, 0}, // #251
  {DBGFIELD("MTFSFb")             2, false, false, false, 368, 7, 364, 6,  0, 0}, // #252
  {DBGFIELD("RLDCL_rec_RLDCR_rec") 2, false, false, false, 378, 7, 370, 5,  0, 0}, // #253
  {DBGFIELD("RLDICL_rec_RLDICR_rec_RLDICL_32_rec_RLDIMI_rec") 2, false, false, false, 378, 7, 370, 5,  0, 0}, // #254
  {DBGFIELD("RLWIMI8_rec_RLWIMI_rec") 2, false, false, false, 378, 7, 370, 5,  0, 0}, // #255
  {DBGFIELD("RLWINM8_rec_RLWINM_rec_RLWNM8_rec_RLWNM_rec_SLW8_rec_SLW_rec_SRW8_rec_SRW_rec") 2, false, false, false, 378, 7, 370, 5,  0, 0}, // #256
  {DBGFIELD("SRAWI_rec_SRAW_rec") 2, false, false, false, 378, 7, 370, 5,  0, 0}, // #257
  {DBGFIELD("MFFS_MFFSCE_MFFSL_MFFS_rec") 2, false, false, false, 368, 7, 303, 5,  0, 0}, // #258
  {DBGFIELD("MFCR_MFCR8")         3, false, false, false, 385, 7, 375, 7,  0, 0}, // #259
  {DBGFIELD("EXTSWSLI_32_64_rec_SRADI_rec_EXTSWSLI_rec_RLDIC_rec") 2, false, false, false, 375, 3, 370, 5,  0, 0}, // #260
  {DBGFIELD("SRAD_rec_SLD_rec_SRD_rec") 2, false, false, false, 375, 3, 370, 5,  0, 0}, // #261
  {DBGFIELD("FDIV")               1, false, false, false, 392, 7, 382, 3,  0, 0}, // #262
  {DBGFIELD("FDIV_rec")           2, false, false, false, 399, 8, 385, 5,  0, 0}, // #263
  {DBGFIELD("XSSQRTDP")           1, false, false, false, 407, 3, 385, 3,  0, 0}, // #264
  {DBGFIELD("FSQRT")              1, false, false, false, 410, 7, 385, 3,  0, 0}, // #265
  {DBGFIELD("XVSQRTDP")           2, false, false, false, 417, 5, 390, 5,  0, 0}, // #266
  {DBGFIELD("XVSQRTSP")           2, false, false, false, 417, 5, 395, 5,  0, 0}, // #267
  {DBGFIELD("FSQRT_rec")          2, false, false, false, 422, 8, 400, 5,  0, 0}, // #268
  {DBGFIELD("XSSQRTSP")           1, false, false, false, 430, 3, 405, 3,  0, 0}, // #269
  {DBGFIELD("FSQRTS")             1, false, false, false, 433, 7, 405, 3,  0, 0}, // #270
  {DBGFIELD("FSQRTS_rec")         2, false, false, false, 440, 8, 408, 5,  0, 0}, // #271
  {DBGFIELD("XSDIVDP")            1, false, false, false, 448, 3, 382, 3,  0, 0}, // #272
  {DBGFIELD("FDIVS")              1, false, false, false, 433, 7, 405, 3,  0, 0}, // #273
  {DBGFIELD("FDIVS_rec")          2, false, false, false, 440, 8, 408, 5,  0, 0}, // #274
  {DBGFIELD("XSDIVSP")            1, false, false, false, 430, 3, 405, 3,  0, 0}, // #275
  {DBGFIELD("XVDIVSP")            2, false, false, false, 451, 7, 413, 5,  0, 0}, // #276
  {DBGFIELD("XVDIVDP")            2, false, false, false, 451, 7, 418, 5,  0, 0}, // #277
  {DBGFIELD("LFSU")               3, false, false, false, 458, 9, 423, 8,  0, 0}, // #278
  {DBGFIELD("LFSUX")              3, false, false, false, 458, 9, 423, 8,  0, 0}, // #279
  {DBGFIELD("STFDU_STFDUX_STFSU_STFSUX") 2, false, false, false, 295, 9, 431, 7,  0, 0}, // #280
  {DBGFIELD("STBU_STBU8_STDU_STHU_STHU8_STWU_STWU8") 2, false, false, false, 295, 9, 431, 7,  0, 0}, // #281
  {DBGFIELD("STBUX_STBUX8_STDUX_STHUX_STHUX8_STWUX_STWUX8") 2, false, false, false, 295, 9, 431, 7,  0, 0}, // #282
  {DBGFIELD("LBZU_LBZU8")         2, false, false, false, 284, 6, 286, 6,  0, 0}, // #283
  {DBGFIELD("LBZUX_LBZUX8")       2, false, false, false, 284, 6, 286, 6,  0, 0}, // #284
  {DBGFIELD("LDU")                2, false, false, false, 284, 6, 286, 6,  0, 0}, // #285
  {DBGFIELD("LDUX")               2, false, false, false, 284, 6, 286, 6,  0, 0}, // #286
  {DBGFIELD("LFDU")               2, false, false, false, 467, 9, 286, 6,  0, 0}, // #287
  {DBGFIELD("LFDUX")              2, false, false, false, 467, 9, 286, 6,  0, 0}, // #288
  {DBGFIELD("VPMSUMB_VPMSUMD_VPMSUMH_VPMSUMW_VCIPHER_VCIPHERLAST_VNCIPHER_VNCIPHERLAST_VSBOX") 1, false, false, false, 476, 5, 303, 4,  0, 0}, // #289
  {DBGFIELD("BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_BCCTR_BCCTR8_BCCTR8n_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_BCCTRn_BDNZ_BDNZ8_BDNZA_BDNZAm_BDNZAp_BDNZm_BDNZp_BDZ_BDZ8_BDZA_BDZAm_BDZAp_BDZm_BDZp_BDNZL_BDNZLA_BDNZLAm_BDNZLAp_BDNZLR_BDNZLR8_BDNZLRL_BDNZLRLm_BDNZLRLp_BDNZLRm_BDNZLRp_BDNZLm_BDNZLp_BDZL_BDZLA_BDZLAm_BDZLAp_BDZLR_BDZLR8_BDZLRL_BDZLRLm_BDZLRLp_BDZLRm_BDZLRp_BDZLm_BDZLp_BL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM_BLR_BLR8_BLRL_TAILB_TAILB8_TAILBA_TAILBA8_TAILBCTR_TAILBCTR8_gBC_gBCA_gBCAat_gBCCTR_gBCCTRL_gBCL_gBCLA_gBCLAat_gBCLR_gBCLRL_gBCLat_gBCat_BCLR_BCLRL_BCLRLn_BCLRn_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_RM_BCTRL_RM_B_BA_BC_BCC_BCCA_BCL_BCLalways_BCLn_BCTRL8_LDinto_toc_BCTRL_LWZinto_toc_BCTRL8_LDinto_toc_RM_BCTRL_LWZinto_toc_RM_BCn_CTRL_DEP") 1, false, false, false, 481, 3, 80, 2,  0, 0}, // #290
  {DBGFIELD("ADDPCIS")            2, false, false, false, 484, 5, 231, 4,  0, 0}, // #291
  {DBGFIELD("LDAT_LWAT")          5, false, false, false, 489, 8, 438, 18,  0, 0}, // #292
  {DBGFIELD("STDAT_STWAT")        3, false, false, false, 497, 8, 456, 10,  0, 0}, // #293
  {DBGFIELD("BRINC")              8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #294
  {DBGFIELD("EVABS_EVEQV_EVNAND_EVNEG_EVADDIW_EVADDW_EVAND_EVANDC_EVCMPEQ_EVCMPGTS_EVCMPGTU_EVCMPLTS_EVCMPLTU_EVCNTLSW_EVCNTLZW_EVEXTSB_EVEXTSH_EVMERGEHI_EVMERGEHILO_EVMERGELO_EVMERGELOHI_EVNOR_EVOR_EVORC_EVXOR_EVRLW_EVRLWI_EVRNDW_EVSLW_EVSLWI_EVSPLATFI_EVSPLATI_EVSRWIS_EVSRWIU_EVSRWS_EVSRWU_EVSUBFW_EVSUBIFW") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #295
  {DBGFIELD("EVMRA_EVADDSMIAAW_EVADDSSIAAW_EVADDUMIAAW_EVADDUSIAAW_EVDIVWS_EVDIVWU_EVMHEGSMFAA_EVMHEGSMFAN_EVMHEGSMIAA_EVMHEGSMIAN_EVMHEGUMIAA_EVMHEGUMIAN_EVMHESMF_EVMHESMFA_EVMHESMFAAW_EVMHESMFANW_EVMHESMI_EVMHESMIA_EVMHESMIAAW_EVMHESMIANW_EVMHESSF_EVMHESSFA_EVMHESSFAAW_EVMHESSFANW_EVMHESSIAAW_EVMHESSIANW_EVMHEUMI_EVMHEUMIA_EVMHEUMIAAW_EVMHEUMIANW_EVMHEUSIAAW_EVMHEUSIANW_EVMHOGSMFAA_EVMHOGSMFAN_EVMHOGSMIAA_EVMHOGSMIAN_EVMHOGUMIAA_EVMHOGUMIAN_EVMHOSMF_EVMHOSMFA_EVMHOSMFAAW_EVMHOSMFANW_EVMHOSMI_EVMHOSMIA_EVMHOSMIAAW_EVMHOSMIANW_EVMHOSSF_EVMHOSSFA_EVMHOSSFAAW_EVMHOSSFANW_EVMHOSSIAAW_EVMHOSSIANW_EVMHOUMI_EVMHOUMIA_EVMHOUMIAAW_EVMHOUMIANW_EVMHOUSIAAW_EVMHOUSIANW_EVMWHSMF_EVMWHSMFA_EVMWHSMI_EVMWHSMIA_EVMWHSSF_EVMWHSSFA_EVMWHUMI_EVMWHUMIA_EVMWLSMIAAW_EVMWLSMIANW_EVMWLSSIAAW_EVMWLSSIANW_EVMWLUMI_EVMWLUMIA_EVMWLUMIAAW_EVMWLUMIANW_EVMWLUSIAAW_EVMWLUSIANW_EVMWSMF_EVMWSMFA_EVMWSMFAA_EVMWSMFAN_EVMWSMI_EVMWSMIA_EVMWSMIAA_EVMWSMIAN_EVMWSSF_EVMWSSFA_EVMWSSFAA_EVMWSSFAN_EVMWUMI_EVMWUMIA_EVMWUMIAA_EVMWUMIAN_EVSUBFSMIAAW_EVSUBFSSIAAW_EVSUBFUMIAAW_EVSUBFUSIAAW") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #296
  {DBGFIELD("EVLDD_EVLDDX_EVLDH_EVLDHX_EVLDW_EVLDWX_EVLHHESPLAT_EVLHHESPLATX_EVLHHOSSPLAT_EVLHHOSSPLATX_EVLHHOUSPLAT_EVLHHOUSPLATX_EVLWHE_EVLWHEX_EVLWHOS_EVLWHOSX_EVLWHOU_EVLWHOUX_EVLWHSPLAT_EVLWHSPLATX_EVLWWSPLAT_EVLWWSPLATX") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #297
  {DBGFIELD("EVSTDD_EVSTDDX_EVSTDH_EVSTDHX_EVSTDW_EVSTDWX_EVSTWHE_EVSTWHEX_EVSTWHO_EVSTWHOX_EVSTWWE_EVSTWWEX_EVSTWWO_EVSTWWOX") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #298
  {DBGFIELD("HRFID_ATTN_CLRBHRB_MFBHRBE_NAP_RFCI_RFDI_RFMCI_SC") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #299
  {DBGFIELD("RFI")                8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #300
  {DBGFIELD("RFID")               8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #301
  {DBGFIELD("DSS_DSSALL_DST_DST64_DSTST_DSTST64_DSTSTT_DSTSTT64_DSTT_DSTT64_ICBLQ_LBEPX_LHEPX_LWEPX_TLBIVAX_TLBLD_TLBLI_TLBRE_TLBRE2_TLBSX_TLBSX2_TLBSX2D_TLBWE_TLBWE2_MBAR_TRAP_DCCCI_ICCCI") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #302
  {DBGFIELD("ICBLC_STBEPX_STHEPX_STWEPX") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #303
  {DBGFIELD("LFDEPX")             8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #304
  {DBGFIELD("STFDEPX")            8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #305
  {DBGFIELD("MFSR_MFSRIN")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #306
  {DBGFIELD("MTSR_MTSRIN")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #307
  {DBGFIELD("MFDCR")              8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #308
  {DBGFIELD("MTDCR")              8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #309
  {DBGFIELD("NOP_GT_PWR6_NOP_GT_PWR7") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #310
  {DBGFIELD("TLBIA")              8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #311
  {DBGFIELD("WRTEE_WRTEEI")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #312
  {DBGFIELD("HASHCHK_HASHCHK8_HASHCHKP_HASHCHKP8_HASHST_HASHST8_HASHSTP_HASHSTP8_ADDEX_ADDEX8") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #313
  {DBGFIELD("MSYNC")              8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #314
  {DBGFIELD("SLBSYNC")            8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #315
  {DBGFIELD("SLBFEE_rec")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #316
  {DBGFIELD("STOP")               8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #317
  {DBGFIELD("DCBA_DCBI")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #318
  {DBGFIELD("FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRE_FRES_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRSP_FRSQRTE_FRSQRTES") 1, false, false, false, 217, 7, 231, 3,  0, 0}, // #319
  {DBGFIELD("VCFSX_VCFSX_0_VCFUX_VCFUX_0_VCTSXS_VCTSXS_0_VCTUXS_VCTUXS_0_VLOGEFP_VREFP_VRFIM_VRFIN_VRFIP_VRFIZ_VRSQRTEFP_XVCVDPSP_XVCVDPSXDS_XVCVDPSXWS_XVCVDPUXDS_XVCVDPUXWS_XVCVSPDP_XVCVSPHP_XVCVSPSXDS_XVCVSPSXWS_XVCVSPUXDS_XVCVSPUXWS_XVCVSXDDP_XVCVSXDSP_XVCVSXWDP_XVCVSXWSP_XVCVUXDDP_XVCVUXDSP_XVCVUXWDP_XVCVUXWSP_XVRDPI_XVRDPIC_XVRDPIM_XVRDPIP_XVRDPIZ_XVREDP_XVRESP_XVRSPI_XVRSPIC_XVRSPIM_XVRSPIP_XVRSPIZ_XVRSQRTEDP_XVRSQRTESP") 2, false, false, false, 210, 7, 230, 5,  0, 0}, // #320
  {DBGFIELD("XSCVDPHP_XSCVDPSP_XSCVDPSPN_XSCVDPSXDS_XSCVDPSXDSs_XSCVDPSXWS_XSCVDPSXWSs_XSCVDPUXDS_XSCVDPUXDSs_XSCVDPUXWS_XSCVDPUXWSs_XSCVSPDP_XSCVSXDDP_XSCVSXDSP_XSCVUXDDP_XSCVUXDSP_XSRDPI_XSRDPIC_XSRDPIM_XSRDPIP_XSRDPIZ_XSREDP_XSRESP_XSRSP_XSRSQRTEDP_XSRSQRTESP") 1, false, false, false, 232, 3, 231, 3,  0, 0}, // #321
  {DBGFIELD("XVCVSPBF16")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #322
  {DBGFIELD("FADDS_FMULS_FSUBS")  1, false, false, false, 217, 7, 231, 3,  0, 0}, // #323
  {DBGFIELD("FMUL")               1, false, false, false, 217, 7, 231, 3,  0, 0}, // #324
  {DBGFIELD("VADDFP_XVADDDP_XVADDSP_XVMULDP_XVMULSP_XVSUBDP_XVSUBSP") 2, false, false, false, 210, 7, 230, 5,  0, 0}, // #325
  {DBGFIELD("VSUBFP")             2, false, false, false, 210, 7, 230, 5,  0, 0}, // #326
  {DBGFIELD("XSADDDP_XSADDSP_XSSUBDP_XSSUBSP") 1, false, false, false, 232, 3, 231, 3,  0, 0}, // #327
  {DBGFIELD("XSMULDP_XSMULSP")    1, false, false, false, 217, 7, 231, 3,  0, 0}, // #328
  {DBGFIELD("VMADDFP_VNMSUBFP_XVMADDADP_XVMADDASP_XVMADDMDP_XVMADDMSP_XVMSUBADP_XVMSUBASP_XVMSUBMDP_XVMSUBMSP_XVNMADDADP_XVNMADDASP_XVNMADDMDP_XVNMADDMSP_XVNMSUBADP_XVNMSUBASP_XVNMSUBMDP_XVNMSUBMSP") 2, false, false, false, 210, 7, 230, 5,  0, 0}, // #329
  {DBGFIELD("VEXPTEFP")           2, false, false, false, 210, 7, 230, 5,  0, 0}, // #330
  {DBGFIELD("FADDS_rec_FMULS_rec_FSUBS_rec") 2, false, false, false, 224, 8, 249, 5,  0, 0}, // #331
  {DBGFIELD("FMUL_rec")           2, false, false, false, 224, 8, 249, 5,  0, 0}, // #332
  {DBGFIELD("FCFID_rec_FCFIDS_rec_FCFIDU_rec_FCFIDUS_rec_FCTID_rec_FCTIDU_rec_FCTIDUZ_rec_FCTIDZ_rec_FCTIW_rec_FCTIWU_rec_FCTIWUZ_rec_FCTIWZ_rec_FRE_rec_FRES_rec_FRIMD_rec_FRIMS_rec_FRIND_rec_FRINS_rec_FRIPD_rec_FRIPS_rec_FRIZD_rec_FRIZS_rec_FRSP_rec_FRSQRTE_rec_FRSQRTES_rec") 2, false, false, false, 224, 8, 249, 5,  0, 0}, // #333
  {DBGFIELD("BCLR_BCLRn_BDNZLR_BDNZLR8_BDNZLRm_BDNZLRp_BDZLR_BDZLR8_BDZLRm_BDZLRp_gBCLR_BCLRL_BCLRLn_BDNZLRL_BDNZLRLm_BDNZLRLp_BDZLRL_BDZLRLm_BDZLRLp_gBCLRL_BL_BL8_BL8_NOP_BL8_NOP_RM_BL8_NOP_TLS_BL8_RM_BL8_TLS_BL8_TLS__BLR_BLR8_BLRL_BL_NOP_BL_NOP_RM_BL_RM_BL_TLS") 1, false, false, false, 481, 3, 80, 2,  0, 0}, // #334
  {DBGFIELD("BL8_NOTOC_BL8_NOTOC_RM_BL8_NOTOC_TLS") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #335
  {DBGFIELD("B_BCC_BCCA_BCCCTR_BCCCTR8_BCCCTRL_BCCCTRL8_BCCL_BCCLA_BCCLR_BCCLRL_CTRL_DEP_TAILB_TAILB8_BA_TAILBA_TAILBA8_BC_BCTR_BCTR8_BCTRL_BCTRL8_BCTRL8_LDinto_toc_BCTRL8_LDinto_toc_RM_BCTRL8_RM_BCTRL_LWZinto_toc_BCTRL_LWZinto_toc_RM_BCTRL_RM_BCn_BDNZ_BDNZ8_BDNZm_BDNZp_BDZ_BDZ8_BDZm_BDZp_TAILBCTR_TAILBCTR8_gBC_gBCat_BCL_BCLalways_BCLn_BDNZL_BDNZLm_BDNZLp_BDZL_BDZLm_BDZLp_gBCL_gBCLat_BLA_BLA8_BLA8_NOP_BLA8_NOP_RM_BLA8_RM_BLA_RM") 1, false, false, false, 481, 3, 80, 2,  0, 0}, // #336
  {DBGFIELD("BCCTR_BCCTR8_BCCTR8n_BCCTRn_gBCCTR_BCCTRL_BCCTRL8_BCCTRL8n_BCCTRLn_gBCCTRL") 1, false, false, false, 481, 3, 80, 2,  0, 0}, // #337
  {DBGFIELD("VSBOX")              1, false, false, false, 476, 5, 303, 4,  0, 0}, // #338
  {DBGFIELD("CFUGED_CNTLZDM_CNTTZDM_PDEPD_PEXTD") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD("VCFUGED_VCLZDM_VCTZDM_VGNB_VPDEPD_VPEXTD") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD("XSCVDPQP_XSCVQPDP_XSCVQPDPO_XSCVQPSDZ_XSCVQPSWZ_XSCVQPUDZ_XSCVQPUWZ_XSCVSDQP_XSCVUDQP") 1, false, false, false, 240, 5, 254, 4,  0, 0}, // #341
  {DBGFIELD("XSCVQPSQZ_XSCVQPUQZ_XSCVSQQP_XSCVUQQP") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("XSADDQP_XSADDQPO_XSSUBQP_XSSUBQPO") 1, false, false, false, 240, 5, 254, 4,  0, 0}, // #343
  {DBGFIELD("HASHST_HASHST8_HASHSTP_HASHSTP8") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #344
  {DBGFIELD("XSMULQP_XSMULQPO")   1, false, false, false, 250, 5, 262, 4,  0, 0}, // #345
  {DBGFIELD("VDIVESQ_VDIVEUQ_VDIVSQ_VDIVUQ") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #346
  {DBGFIELD("VMODSQ_VMODUQ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #347
  {DBGFIELD("DIVWE_DIVWEO_DIVWEU_DIVWEUO") 1, false, false, false, 351, 8, 262, 4,  0, 0}, // #348
  {DBGFIELD("VDIVSD_VDIVUD")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #349
  {DBGFIELD("VMODSD_VMODUD")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("VDIVSW_VDIVUW")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #351
  {DBGFIELD("VMODSW_VMODUW")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #352
  {DBGFIELD("VDIVESD_VDIVEUD")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #353
  {DBGFIELD("VDIVESW_VDIVEUW")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #354
  {DBGFIELD("BCDCTN_rec_VMUL10CUQ_VMUL10UQ_XSXSIGQP") 1, false, false, false, 235, 5, 226, 4,  0, 0}, // #355
  {DBGFIELD("BCDCFN_rec_BCDCFZ_rec_BCDCPSGN_rec_BCDCTZ_rec_BCDSETSGN_rec_BCDUS_rec_BCDUTRUNC_rec_VADDCUQ_VMUL10ECUQ_VMUL10EUQ_VSUBCUQ_XSTSTDCQP") 1, false, false, false, 235, 5, 226, 4,  0, 0}, // #356
  {DBGFIELD("VADDUQM_VSUBUQM")    1, false, false, false, 235, 5, 226, 4,  0, 0}, // #357
  {DBGFIELD("XSMAXCQP_XSMINCQP")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #358
  {DBGFIELD("XXGENPCVBM")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #359
  {DBGFIELD("BCDADD_rec_BCDS_rec_BCDSUB_rec_BCDTRUNC_rec_VADDECUQ_VADDEUQM_VSUBECUQ_VSUBEUQM") 1, false, false, false, 235, 5, 226, 4,  0, 0}, // #360
  {DBGFIELD("TRAP")               8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #361
  {DBGFIELD("TW")                 1, false, false, false, 200, 7, 222, 3,  0, 0}, // #362
  {DBGFIELD("CNTLZD_CNTLZD_rec_CNTLZW_CNTLZW8_CNTLZW8_rec_CNTLZW_rec_CNTTZD_CNTTZD_rec_CNTTZW_CNTTZW8_CNTTZW8_rec_CNTTZW_rec_POPCNTD_POPCNTW") 1, false, false, false, 207, 3, 222, 3,  0, 0}, // #363
  {DBGFIELD("FTSQRT")             1, false, false, false, 200, 7, 222, 3,  0, 0}, // #364
  {DBGFIELD("MTVSRBM_MTVSRBMI_MTVSRDM_MTVSRHM_MTVSRQM_MTVSRWM_VEXPANDBM_VEXPANDDM_VEXPANDHM_VEXPANDQM_VEXPANDWM_VEXTRACTBM_VEXTRACTDM_VEXTRACTHM_VEXTRACTQM_VEXTRACTWM_XVTLSBB") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("POPCNTB_POPCNTB8")   1, false, false, false, 207, 3, 218, 3,  0, 0}, // #366
  {DBGFIELD("VCLZB_VCLZD_VCLZH_VCLZW_VCTZB_VCTZD_VCTZH_VCTZW_VPOPCNTD_VPOPCNTW_VPRTYBD_VPRTYBW") 2, false, false, false, 193, 7, 225, 5,  0, 0}, // #367
  {DBGFIELD("VPOPCNTB_VPOPCNTH")  2, false, false, false, 193, 7, 217, 5,  0, 0}, // #368
  {DBGFIELD("XSCVSPDPN")          1, false, false, false, 207, 3, 222, 3,  0, 0}, // #369
  {DBGFIELD("XSTSQRTDP")          1, false, false, false, 207, 3, 222, 3,  0, 0}, // #370
  {DBGFIELD("XVCVHPSP")           2, false, false, false, 210, 7, 230, 5,  0, 0}, // #371
  {DBGFIELD("XVTSQRTDP_XVTSQRTSP") 2, false, false, false, 193, 7, 225, 5,  0, 0}, // #372
  {DBGFIELD("CMPEQB")             1, false, false, false, 200, 7, 222, 3,  0, 0}, // #373
  {DBGFIELD("EXTSWSLI_32_64_rec_EXTSWSLI_rec") 2, false, false, false, 375, 3, 370, 5,  0, 0}, // #374
  {DBGFIELD("SLD_rec_SRD_rec")    2, false, false, false, 375, 3, 370, 5,  0, 0}, // #375
  {DBGFIELD("SLW8_rec_SLW_rec_SRW8_rec_SRW_rec") 2, false, false, false, 378, 7, 370, 5,  0, 0}, // #376
  {DBGFIELD("VADDCUW_VADDSBS_VADDSHS_VADDSWS_VADDUBS_VADDUHS_VADDUWS_VAVGSB_VAVGSH_VAVGSW_VAVGUB_VAVGUH_VAVGUW_VMAXFP_VMINFP_VSUBCUW_VSUBSBS_VSUBSHS_VSUBSWS_VSUBUBS_VSUBUHS_VSUBUWS_XVMAXDP_XVMAXSP_XVMINDP_XVMINSP_XVTSTDCDP_XVTSTDCSP") 2, false, false, false, 193, 7, 225, 5,  0, 0}, // #377
  {DBGFIELD("VCMPBFP_VCMPBFP_rec_VCMPEQFP_VCMPEQFP_rec_VCMPEQUB_rec_VCMPEQUD_rec_VCMPEQUH_rec_VCMPEQUW_rec_VCMPGEFP_VCMPGEFP_rec_VCMPGTFP_VCMPGTFP_rec_VCMPGTSB_rec_VCMPGTSD_rec_VCMPGTSH_rec_VCMPGTSW_rec_VCMPGTUB_rec_VCMPGTUD_rec_VCMPGTUH_rec_VCMPGTUW_rec_VCMPNEB_rec_VCMPNEH_rec_VCMPNEW_rec_VCMPNEZB_rec_VCMPNEZH_rec_VCMPNEZW_rec_XVCMPEQDP_XVCMPEQDP_rec_XVCMPEQSP_XVCMPEQSP_rec_XVCMPGEDP_XVCMPGEDP_rec_XVCMPGESP_XVCMPGESP_rec_XVCMPGTDP_XVCMPGTDP_rec_XVCMPGTSP_XVCMPGTSP_rec") 2, false, false, false, 193, 7, 225, 5,  0, 0}, // #378
  {DBGFIELD("VCMPEQUQ_VCMPEQUQ_rec_VCMPGTSQ_VCMPGTSQ_rec_VCMPGTUQ_VCMPGTUQ_rec") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("VCMPSQ_VCMPUQ_VCNTMBB_VCNTMBD_VCNTMBH_VCNTMBW") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("XSMAXCDP_XSMAXDP_XSMAXJDP_XSMINCDP_XSMINDP_XSMINJDP") 1, false, false, false, 207, 3, 222, 3,  0, 0}, // #381
  {DBGFIELD("RLDIC_rec")          2, false, false, false, 375, 3, 370, 5,  0, 0}, // #382
  {DBGFIELD("RLDICL_32_rec_RLDICL_rec_RLDICR_rec") 2, false, false, false, 378, 7, 370, 5,  0, 0}, // #383
  {DBGFIELD("VSHASIGMAD_VSHASIGMAW") 2, false, false, false, 193, 7, 225, 5,  0, 0}, // #384
  {DBGFIELD("VRLQ_VRLQNM_VSLQ_VSRAQ_VSRQ") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #385
  {DBGFIELD("VRLQMI")             8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("CR6SET_CREQV_CRSET") 1, false, false, false, 200, 7, 218, 3,  0, 0}, // #387
  {DBGFIELD("DSS_DSSALL")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #388
  {DBGFIELD("MFCTR_MFCTR8_MFLR_MFLR8") 1, false, false, false, 343, 8, 254, 4,  0, 0}, // #389
  {DBGFIELD("NOP_ORI_ORI8")       1, false, false, false, 207, 3, 218, 3,  0, 0}, // #390
  {DBGFIELD("VXOR_V_SET0_V_SET0B_V_SET0H") 2, false, false, false, 193, 7, 217, 5,  0, 0}, // #391
  {DBGFIELD("XXLEQV_XXLEQVOnes_XXLXOR_XXLXORdpz_XXLXORspz_XXLXORz") 2, false, false, false, 193, 7, 217, 5,  0, 0}, // #392
  {DBGFIELD("ADDI_ADDI8_LI_LI8_ADDIS_ADDIS8_LIS_LIS8_EXTSB_EXTSB8_EXTSB8_32_64_EXTSB8_rec_EXTSB_rec_EXTSH_EXTSH8_EXTSH8_32_64_EXTSH8_rec_EXTSH_rec_EXTSW_EXTSW_32_EXTSW_32_64_EXTSW_32_64_rec_EXTSW_rec_NEG_NEG8_NEG8_rec_NEG_rec_NEG8O_NEGO") 1, false, false, false, 207, 3, 218, 3,  0, 0}, // #393
  {DBGFIELD("ADDIdtprelL32_ADDItlsldLADDR32_ADDISdtprelHA32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("ADDItocL_ADDIStocHA_ADDIStocHA8") 1, false, false, false, 207, 3, 218, 3,  0, 0}, // #395
  {DBGFIELD("ADDME_ADDME8_ADDME8O_ADDMEO_ADDZE_ADDZE8_ADDZE8O_ADDZEO_SUBFME_SUBFME8_SUBFME8O_SUBFMEO_SUBFZE_SUBFZE8_SUBFZE8O_SUBFZEO") 1, false, false, false, 207, 3, 218, 3,  0, 0}, // #396
  {DBGFIELD("FABSD_FABSS_FMR_FNABSD_FNABSS_FNEGD_FNEGS") 1, false, false, false, 200, 7, 218, 3,  0, 0}, // #397
  {DBGFIELD("SETB_SETB8")         1, false, false, false, 207, 3, 222, 3,  0, 0}, // #398
  {DBGFIELD("SETBC_SETBC8_SETBCR_SETBCR8_SETNBC_SETNBC8_SETNBCR_SETNBCR8") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("VEXTSB2D_VEXTSB2Ds_VEXTSB2W_VEXTSB2Ws_VEXTSH2D_VEXTSH2Ds_VEXTSH2W_VEXTSH2Ws_VEXTSW2D_VEXTSW2Ds_VNEGD_VNEGW") 2, false, false, false, 193, 7, 217, 5,  0, 0}, // #400
  {DBGFIELD("VEXTSD2Q")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #401
  {DBGFIELD("XSABSDP_XSNABSDP_XSNEGDP_XSXEXPDP") 1, false, false, false, 207, 3, 218, 3,  0, 0}, // #402
  {DBGFIELD("XSABSQP_XSNABSQP_XSNEGQP_XSXEXPQP_XVABSDP_XVABSSP_XVNABSDP_XVNABSSP_XVNEGDP_XVNEGSP_XVXEXPDP_XVXEXPSP") 2, false, false, false, 193, 7, 217, 5,  0, 0}, // #403
  {DBGFIELD("XVXSIGDP_XVXSIGSP")  2, false, false, false, 193, 7, 225, 5,  0, 0}, // #404
  {DBGFIELD("ADD4_ADD4TLS_ADD8_ADD8TLS_ADD8TLS__ADD4_rec_ADD8_rec_ADD4O_ADD8O_AND_AND8_AND8_rec_AND_rec_ANDC_ANDC8_ANDC8_rec_ANDC_rec_EQV_EQV8_EQV8_rec_EQV_rec_NAND_NAND8_NAND8_rec_NAND_rec_NOR_NOR8_NOR8_rec_NOR_rec_OR_OR8_OR8_rec_OR_rec_ORC_ORC8_ORC8_rec_ORC_rec_ORIS_ORIS8_XOR_XOR8_XOR8_rec_XOR_rec_XORI_XORI8_XORIS_XORIS8") 1, false, false, false, 207, 3, 218, 3,  0, 0}, // #405
  {DBGFIELD("ADDE_ADDE8_ADDE8O_ADDEO_ADDIC_ADDIC8_ANDI8_rec_ANDI_rec_ANDIS8_rec_ANDIS_rec_SUBF_SUBF8_SUBF8_rec_SUBF_rec_SUBFE_SUBFE8_SUBFE8O_SUBFEO_SUBFIC_SUBFIC8_SUBF8O_SUBFO") 1, false, false, false, 207, 3, 218, 3,  0, 0}, // #406
  {DBGFIELD("CMPB_CMPB8")         1, false, false, false, 207, 3, 222, 3,  0, 0}, // #407
  {DBGFIELD("EXTSWSLI_EXTSWSLI_32_64_SRADI_SRADI_32") 1, false, false, false, 207, 3, 218, 3,  0, 0}, // #408
  {DBGFIELD("SLW_SLW8_SRW_SRW8")  1, false, false, false, 200, 7, 218, 3,  0, 0}, // #409
  {DBGFIELD("VADDUBM_VADDUDM_VADDUHM_VADDUWM_VEQV_VNAND_VORC_VSLD_VSRAD_VSRD_VSUBUBM_VSUBUDM_VSUBUHM_VSUBUWM_XXLAND_XXLANDC_XXLNAND_XXLNOR_XXLOR_XXLORf_XXLORC") 2, false, false, false, 193, 7, 217, 5,  0, 0}, // #410
  {DBGFIELD("VAND_VANDC_VMRGEW_VMRGOW_VNOR_VOR_VRLB_VRLD_VRLDNM_VRLH_VRLW_VRLWNM_VSLB_VSLH_VSLW_VSRAB_VSRAH_VSRAW_VSRB_VSRH_VSRW_XSCPSGNQP_XSIEXPQP_XVCPSGNDP_XVCPSGNSP_XVIEXPDP_XVIEXPSP") 2, false, false, false, 193, 7, 217, 5,  0, 0}, // #411
  {DBGFIELD("VMAXSB_VMAXSD_VMAXSH_VMAXSW_VMAXUB_VMAXUD_VMAXUH_VMAXUW_VMINSB_VMINSD_VMINSH_VMINSW_VMINUB_VMINUD_VMINUH_VMINUW") 2, false, false, false, 193, 7, 225, 5,  0, 0}, // #412
  {DBGFIELD("ADDEX_ADDEX8")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #413
  {DBGFIELD("DST_DST64_DSTT_DSTT64_DSTST_DSTST64_DSTSTT_DSTSTT64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #414
  {DBGFIELD("RLDICL_RLDICL_32_RLDICL_32_64_RLDICR_RLDICR_32") 1, false, false, false, 200, 7, 218, 3,  0, 0}, // #415
  {DBGFIELD("MFFS_MFFS_rec_MFFSL") 2, false, false, false, 368, 7, 303, 5,  0, 0}, // #416
  {DBGFIELD("TRECHKPT")           1, false, false, false, 207, 3, 218, 3,  0, 0}, // #417
  {DBGFIELD("ADDME8_rec_ADDME_rec_ADDME8O_rec_ADDMEO_rec_ADDZE8_rec_ADDZE_rec_ADDZE8O_rec_ADDZEO_rec_SUBFME8_rec_SUBFME_rec_SUBFME8O_rec_SUBFMEO_rec_SUBFZE8_rec_SUBFZE_rec_SUBFZE8O_rec_SUBFZEO_rec") 1, false, false, false, 207, 3, 218, 3,  0, 0}, // #418
  {DBGFIELD("MTFSB0")             1, false, false, false, 200, 7, 222, 3,  0, 0}, // #419
  {DBGFIELD("NEG8O_rec_NEGO_rec") 1, false, false, false, 207, 3, 218, 3,  0, 0}, // #420
  {DBGFIELD("ADDE8_rec_ADDE_rec_ADDE8O_rec_ADDEO_rec_ADDIC_rec_SUBFE8_rec_SUBFE_rec_SUBFE8O_rec_SUBFEO_rec_SUBF8O_rec_SUBFO_rec") 1, false, false, false, 207, 3, 218, 3,  0, 0}, // #421
  {DBGFIELD("HRFID")              8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #422
  {DBGFIELD("FABSD_rec_FABSS_rec_FMR_rec_FNABSD_rec_FNABSS_rec_FNEGD_rec_FNEGS_rec") 2, false, false, false, 378, 7, 358, 6,  0, 0}, // #423
  {DBGFIELD("SC")                 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #424
  {DBGFIELD("ADDC_ADDC8_ADDC8O_ADDCO_SUBFC_SUBFC8_SUBFC8O_SUBFCO") 1, false, false, false, 207, 3, 218, 3,  0, 0}, // #425
  {DBGFIELD("ADDC8_rec_ADDC_rec_SUBFC8_rec_SUBFC_rec") 2, false, false, false, 375, 3, 352, 6,  0, 0}, // #426
  {DBGFIELD("MTFSF_MTFSFI_MTFSFIb") 2, false, false, false, 368, 7, 364, 6,  0, 0}, // #427
  {DBGFIELD("MTFSFI_rec")         2, false, false, false, 368, 7, 364, 6,  0, 0}, // #428
  {DBGFIELD("VSTRIBL_rec_VSTRIBR_rec_VSTRIHL_rec_VSTRIHR_rec") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #429
  {DBGFIELD("LBZ_LBZ8_LDBRX_LHBRX_LHBRX8_LHZ_LHZ8_LWBRX_LWBRX8_LWZ_LWZ8") 1, false, false, false, 270, 3, 278, 3,  0, 0}, // #430
  {DBGFIELD("LD")                 1, false, false, false, 270, 3, 278, 3,  0, 0}, // #431
  {DBGFIELD("LDtoc_LDtocBA_LDtocCPT_LDtocJTI_LDtocL_SPILLTOVSR_LD_LWZtoc_LWZtocL") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #432
  {DBGFIELD("LXVRBX_LXVRDX_LXVRHX_LXVRWX") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #433
  {DBGFIELD("DCBT_DCBTST")        1, false, false, false, 270, 3, 278, 3,  0, 0}, // #434
  {DBGFIELD("ICBT_LBZX_LBZX8_LBZXTLS_LBZXTLS__LBZXTLS_32_LHZX_LHZX8_LHZXTLS_LHZXTLS__LHZXTLS_32_LWZX_LWZX8_LWZXTLS_LWZXTLS__LWZXTLS_32") 1, false, false, false, 270, 3, 278, 3,  0, 0}, // #435
  {DBGFIELD("LDX_LDXTLS_LDXTLS_") 1, false, false, false, 270, 3, 278, 3,  0, 0}, // #436
  {DBGFIELD("SPILLTOVSR_LDX")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #437
  {DBGFIELD("LBZCIX_LDCIX_LHZCIX_LWZCIX") 1, false, false, false, 270, 3, 278, 3,  0, 0}, // #438
  {DBGFIELD("MTSR")               8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #439
  {DBGFIELD("MTVRSAVE_MTVRSAVEv") 1, false, false, false, 343, 8, 254, 4,  0, 0}, // #440
  {DBGFIELD("LSWI")               1, false, false, false, 270, 3, 278, 3,  0, 0}, // #441
  {DBGFIELD("PLBZ_PLBZ8_PLBZ8pc_PLBZpc_PLD_PLDpc_PLFD_PLFDpc_PLFS_PLFSpc_PLHA_PLHA8_PLHA8pc_PLHApc_PLHZ_PLHZ8_PLHZ8pc_PLHZpc_PLWA_PLWA8_PLWA8pc_PLWApc_PLWZ_PLWZ8_PLWZ8pc_PLWZpc_PLXSD_PLXSDpc_PLXSSP_PLXSSPpc_PLXV_PLXVpc_PLXVP_PLXVPpc") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("LXVP_LXVPX")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #443
  {DBGFIELD("MFSR")               8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #444
  {DBGFIELD("MFTB8")              1, false, false, false, 343, 8, 254, 4,  0, 0}, // #445
  {DBGFIELD("XXSETACCZ")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("XVBF16GER2_XVF16GER2_XVF32GER_XVF64GER_XVI16GER2_XVI16GER2S_XVI4GER8_XVI8GER4") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("XVBF16GER2NN_XVBF16GER2NP_XVBF16GER2PN_XVBF16GER2PP_XVF16GER2NN_XVF16GER2NP_XVF16GER2PN_XVF16GER2PP_XVF32GERNN_XVF32GERNP_XVF32GERPN_XVF32GERPP_XVF64GERNN_XVF64GERNP_XVF64GERPN_XVF64GERPP_XVI16GER2PP_XVI16GER2SPP_XVI4GER8PP_XVI8GER4PP") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("XVI8GER4SPP")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("PMXVF32GER_PMXVF64GER") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #450
  {DBGFIELD("PMXVBF16GER2_PMXVF16GER2_PMXVF32GERNN_PMXVF32GERNP_PMXVF32GERPN_PMXVF32GERPP_PMXVF64GERNN_PMXVF64GERNP_PMXVF64GERPN_PMXVF64GERPP_PMXVI16GER2_PMXVI16GER2S_PMXVI4GER8_PMXVI8GER4") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #451
  {DBGFIELD("PMXVBF16GER2NN_PMXVBF16GER2NP_PMXVBF16GER2PN_PMXVBF16GER2PP_PMXVF16GER2NN_PMXVF16GER2NP_PMXVF16GER2PN_PMXVF16GER2PP_PMXVI16GER2PP_PMXVI16GER2SPP_PMXVI4GER8PP_PMXVI8GER4PP") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #452
  {DBGFIELD("PMXVI8GER4SPP")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #453
  {DBGFIELD("XXMTACC")            8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #454
  {DBGFIELD("XXMFACC")            8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #455
  {DBGFIELD("MULLD_MULLDO")       1, false, false, false, 217, 7, 235, 3,  0, 0}, // #456
  {DBGFIELD("VMULHSD_VMULHUD_VMULLD") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #457
  {DBGFIELD("VSPLTISW")           1, false, false, false, 235, 5, 226, 4,  0, 0}, // #458
  {DBGFIELD("V_SETALLONES_V_SETALLONESB_V_SETALLONESH") 1, false, false, false, 235, 5, 226, 4,  0, 0}, // #459
  {DBGFIELD("MFVSRLD_MTVSRWS_VCLZLSBB_VCTZLSBB_VPRTYBQ") 1, false, false, false, 235, 5, 226, 4,  0, 0}, // #460
  {DBGFIELD("VGBBD_VUPKHPX_VUPKHSB_VUPKHSH_VUPKHSW_VUPKLPX_VUPKLSB_VUPKLSH_VUPKLSW_XXBRD_XXBRH_XXBRQ_XXBRW") 1, false, false, false, 235, 5, 226, 4,  0, 0}, // #461
  {DBGFIELD("VSPLTISB_VSPLTISH_XXSPLTIB") 1, false, false, false, 235, 5, 226, 4,  0, 0}, // #462
  {DBGFIELD("VSTRIBL_VSTRIBR_VSTRIHL_VSTRIHR") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #463
  {DBGFIELD("XVCVBF16SPN")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #464
  {DBGFIELD("VBPERMQ_VMRGHB_VMRGHH_VMRGHW_VMRGLB_VMRGLH_VMRGLW_VPKPX_VPKSDSS_VPKSDUS_VPKSHSS_VPKSHUS_VPKSWSS_VPKSWUS_VPKUDUM_VPKUDUS_VPKUHUM_VPKUHUS_VPKUWUM_VPKUWUS_VSL_VSLO_VSLV_VSR_VSRO_VSRV_XXEXTRACTUW") 1, false, false, false, 235, 5, 226, 4,  0, 0}, // #465
  {DBGFIELD("VCLRLB_VCLRRB_XXGENPCVDM_XXGENPCVHM_XXGENPCVWM") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #466
  {DBGFIELD("VEXTRACTD_VEXTRACTUB_VEXTRACTUH_VEXTRACTUW_VEXTUBLX_VEXTUBRX_VEXTUHLX_VEXTUHRX_VEXTUWLX_VEXTUWRX_VINSERTD_VINSERTW") 1, false, false, false, 235, 5, 226, 4,  0, 0}, // #467
  {DBGFIELD("VEXTDDVLX_VEXTDDVRX_VEXTDUBVLX_VEXTDUBVRX_VEXTDUHVLX_VEXTDUHVRX_VEXTDUWVLX_VEXTDUWVRX_VINSBLX_VINSBRX_VINSBVLX_VINSBVRX_VINSD_VINSDLX_VINSDRX_VINSHLX_VINSHRX_VINSHVLX_VINSHVRX_VINSW_VINSWLX_VINSWRX_VINSWVLX_VINSWVRX_VSLDBI_VSRDBI") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("VSUMSWS")            2, false, false, false, 210, 7, 230, 5,  0, 0}, // #469
  {DBGFIELD("XXSPLTIDP_XXSPLTIW") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #470
  {DBGFIELD("XXBLENDVB_XXBLENDVD_XXBLENDVH_XXBLENDVW_XXSPLTI32DX") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("XXEVAL")             8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #472
  {DBGFIELD("XXPERMX")            8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #473
  {DBGFIELD("DCBST_DCBZ")         1, false, false, false, 270, 3, 278, 3,  0, 0}, // #474
  {DBGFIELD("ICBI")               1, false, false, false, 270, 3, 278, 3,  0, 0}, // #475
  {DBGFIELD("DCBF")               1, false, false, false, 270, 3, 278, 3,  0, 0}, // #476
  {DBGFIELD("PSTXVP_PSTXVPpc")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #477
  {DBGFIELD("STB_STB8_STDBRX_STH_STH8_STHBRX_STW_STW8_STWBRX") 1, false, false, false, 329, 8, 240, 4,  0, 0}, // #478
  {DBGFIELD("SPILLTOVSR_ST")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #479
  {DBGFIELD("STD")                1, false, false, false, 329, 8, 240, 4,  0, 0}, // #480
  {DBGFIELD("DFSTOREf32_DFSTOREf64_STIWX") 1, false, false, false, 329, 8, 240, 4,  0, 0}, // #481
  {DBGFIELD("STXVRBX_STXVRDX_STXVRHX_STXVRWX") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #482
  {DBGFIELD("SPILLTOVSR_STX")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #483
  {DBGFIELD("EnforceIEIO")        1, false, false, false, 270, 3, 278, 3,  0, 0}, // #484
  {DBGFIELD("STBCIX_STDCIX_STHCIX_STWCIX") 1, false, false, false, 329, 8, 240, 4,  0, 0}, // #485
  {DBGFIELD("PSTB_PSTB8_PSTB8pc_PSTBpc_PSTD_PSTDpc_PSTFD_PSTFDpc_PSTFS_PSTFSpc_PSTH_PSTH8_PSTH8pc_PSTHpc_PSTW_PSTW8_PSTW8pc_PSTWpc_PSTXSD_PSTXSDpc_PSTXSSP_PSTXSSPpc_PSTXV_PSTXVpc") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("STXVP_STXVPX")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("ATTN_NAP")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #488
  {DBGFIELD("DCBZL")              1, false, false, false, 270, 3, 278, 3,  0, 0}, // #489
  {DBGFIELD("DCCCI_ICBLQ_ICCCI_TLBLD_TLBLI_TLBRE2_TLBSX2_TLBSX2D_TLBWE2") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("ICBLC")              8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("CLRBHRB")            8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #492
  {DBGFIELD("MFBHRBE")            8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #493
  {DBGFIELD("PADDI_PADDI8_PADDI8pc_PADDIpc") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #494
  {DBGFIELD("PLI_PLI8")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #495
  {DBGFIELD("VMULESB_VMULESH_VMULESW_VMULEUB_VMULEUH_VMULEUW_VMULOSB_VMULOSH_VMULOSW_VMULOUB_VMULOUH_VMULOUW_VSUM2SWS_VSUM4SBS_VSUM4SHS_VSUM4UBS") 2, false, false, false, 210, 7, 230, 5,  0, 0}, // #496
  {DBGFIELD("VMULESD_VMULEUD_VMULHSW_VMULHUW_VMULOSD_VMULOUD") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("VMSUMCUD")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #498
  {DBGFIELD("P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_2C_P10BF_Read_2C_P10BF_Read_2C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #499
  {DBGFIELD("P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_1C_P10BF_Read_1C_P10BF_Read_1C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #500
  {DBGFIELD("P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_2C_P10BF_Read_2C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #501
  {DBGFIELD("P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_1C_P10BF_Read_1C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #502
  {DBGFIELD("P10W_BF_27C_P10W_DISP_ANY_P10BF_Read_2C_P10BF_Read_2C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #503
  {DBGFIELD("P10W_BF_27C_P10W_DISP_ANY_P10BF_Read_1C_P10BF_Read_1C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #504
  {DBGFIELD("P10W_BF_36C_P10W_DISP_ANY_P10BF_Read_2C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #505
  {DBGFIELD("P10W_BF_36C_P10W_DISP_ANY_P10BF_Read_1C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #506
  {DBGFIELD("P10W_BF_27C_P10W_DISP_ANY_P10BF_Read_2C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #507
  {DBGFIELD("P10W_BF_27C_P10W_DISP_ANY_P10BF_Read_1C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #508
  {DBGFIELD("P10W_BF_26C_P10W_DISP_ANY_P10BF_Read_2C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #509
  {DBGFIELD("P10W_BF_26C_P10W_DISP_ANY_P10BF_Read_1C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #510
  {DBGFIELD("P10W_BF_22C_P10W_DISP_ANY_P10BF_Read_2C_P10BF_Read_2C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #511
  {DBGFIELD("P10W_BF_22C_P10W_DISP_ANY_P10BF_Read_1C_P10BF_Read_1C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #512
  {DBGFIELD("P10W_BF_24C_P10W_DISP_ANY_P10BF_Read_2C_P10BF_Read_2C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #513
  {DBGFIELD("P10W_BF_24C_P10W_DISP_ANY_P10BF_Read_1C_P10BF_Read_1C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #514
  {DBGFIELD("P10W_CY_7C_P10W_DISP_ANY_P10CY_Read_3C_P10CY_Read_3C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #515
  {DBGFIELD("P10W_CY_7C_P10W_DISP_ANY_P10CY_Read_1C_P10CY_Read_1C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #516
  {DBGFIELD("P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_2C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #517
  {DBGFIELD("P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_1C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #518
  {DBGFIELD("P10W_BF_7C_P10W_DISP_EVEN_P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_2C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #519
  {DBGFIELD("P10W_BF_7C_P10W_DISP_EVEN_P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_1C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #520
  {DBGFIELD("P10W_CY_7C_P10W_DISP_ANY_P10CY_Read_3C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #521
  {DBGFIELD("P10W_CY_7C_P10W_DISP_ANY_P10CY_Read_1C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #522
  {DBGFIELD("P10W_MM_10C_P10W_DISP_ANY_P10MM_Read_6C_P10MM_Read_6C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #523
  {DBGFIELD("P10W_MM_10C_P10W_DISP_ANY_P10MM_Read_1C_P10MM_Read_1C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #524
  {DBGFIELD("P10W_MM_10C_P10W_DISP_ANY_P10MM_Read_6C_P10MM_Read_6C_P10MM_Read_6C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #525
  {DBGFIELD("P10W_MM_10C_P10W_DISP_ANY_P10MM_Read_1C_P10MM_Read_1C_P10MM_Read_1C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #526
  {DBGFIELD("P10W_MM_10C_P10W_DISP_PAIR_P10MM_Read_6C_P10MM_Read_6C_P10MM_Read_6C_P10MM_Read_6C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #527
  {DBGFIELD("P10W_MM_10C_P10W_DISP_PAIR_P10MM_Read_1C_P10MM_Read_1C_P10MM_Read_1C_P10MM_Read_1C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #528
  {DBGFIELD("P10W_MM_10C_P10W_DISP_PAIR_P10MM_Read_6C_P10MM_Read_6C_P10MM_Read_6C_P10MM_Read_6C_P10MM_Read_6C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #529
  {DBGFIELD("P10W_MM_10C_P10W_DISP_PAIR_P10MM_Read_1C_P10MM_Read_1C_P10MM_Read_1C_P10MM_Read_1C_P10MM_Read_1C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #530
  {DBGFIELD("P10W_MM_10C_P10W_DISP_PAIR_P10MM_Read_6C_P10MM_Read_6C_P10MM_Read_6C_P10MM_Read_6C_P10MM_Read_6C_P10MM_Read_6C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #531
  {DBGFIELD("P10W_MM_10C_P10W_DISP_PAIR_P10MM_Read_1C_P10MM_Read_1C_P10MM_Read_1C_P10MM_Read_1C_P10MM_Read_1C_P10MM_Read_1C") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #532
}; // P9ModelSchedClasses

#undef DBGFIELD

static const llvm::MCSchedModel NoSchedModel = {
  MCSchedModel::DefaultIssueWidth,
  MCSchedModel::DefaultMicroOpBufferSize,
  MCSchedModel::DefaultLoopMicroOpBufferSize,
  MCSchedModel::DefaultLoadLatency,
  MCSchedModel::DefaultHighLatency,
  MCSchedModel::DefaultMispredictPenalty,
  false, // PostRAScheduler
  false, // CompleteModel
  0, // Processor ID
  nullptr, nullptr, 0, 0, // No instruction-level machine model.
  nullptr, // No Itinerary
  nullptr // No extra processor descriptor
};

static const llvm::MCSchedModel PPC440Model = {
  2, // IssueWidth
  MCSchedModel::DefaultMicroOpBufferSize,
  MCSchedModel::DefaultLoopMicroOpBufferSize,
  5, // LoadLatency
  MCSchedModel::DefaultHighLatency,
  MCSchedModel::DefaultMispredictPenalty,
  false, // PostRAScheduler
  false, // CompleteModel
  1, // Processor ID
  nullptr, nullptr, 0, 0, // No instruction-level machine model.
  PPC440Itineraries,
  nullptr // No extra processor descriptor
};

static const llvm::MCSchedModel G3ItinerariesModel = {
  MCSchedModel::DefaultIssueWidth,
  MCSchedModel::DefaultMicroOpBufferSize,
  MCSchedModel::DefaultLoopMicroOpBufferSize,
  MCSchedModel::DefaultLoadLatency,
  MCSchedModel::DefaultHighLatency,
  MCSchedModel::DefaultMispredictPenalty,
  false, // PostRAScheduler
  false, // CompleteModel
  2, // Processor ID
  nullptr, nullptr, 0, 0, // No instruction-level machine model.
  G3Itineraries,
  nullptr // No extra processor descriptor
};

static const llvm::MCSchedModel G4ItinerariesModel = {
  MCSchedModel::DefaultIssueWidth,
  MCSchedModel::DefaultMicroOpBufferSize,
  MCSchedModel::DefaultLoopMicroOpBufferSize,
  MCSchedModel::DefaultLoadLatency,
  MCSchedModel::DefaultHighLatency,
  MCSchedModel::DefaultMispredictPenalty,
  false, // PostRAScheduler
  false, // CompleteModel
  3, // Processor ID
  nullptr, nullptr, 0, 0, // No instruction-level machine model.
  G4Itineraries,
  nullptr // No extra processor descriptor
};

static const llvm::MCSchedModel G4PlusItinerariesModel = {
  MCSchedModel::DefaultIssueWidth,
  MCSchedModel::DefaultMicroOpBufferSize,
  MCSchedModel::DefaultLoopMicroOpBufferSize,
  MCSchedModel::DefaultLoadLatency,
  MCSchedModel::DefaultHighLatency,
  MCSchedModel::DefaultMispredictPenalty,
  false, // PostRAScheduler
  false, // CompleteModel
  4, // Processor ID
  nullptr, nullptr, 0, 0, // No instruction-level machine model.
  G4PlusItineraries,
  nullptr // No extra processor descriptor
};

static const llvm::MCSchedModel G5Model = {
  4, // IssueWidth
  MCSchedModel::DefaultMicroOpBufferSize,
  MCSchedModel::DefaultLoopMicroOpBufferSize,
  3, // LoadLatency
  MCSchedModel::DefaultHighLatency,
  16, // MispredictPenalty
  false, // PostRAScheduler
  false, // CompleteModel
  5, // Processor ID
  nullptr, nullptr, 0, 0, // No instruction-level machine model.
  G5Itineraries,
  nullptr // No extra processor descriptor
};

static const llvm::MCSchedModel PPCA2Model = {
  1, // IssueWidth
  MCSchedModel::DefaultMicroOpBufferSize,
  MCSchedModel::DefaultLoopMicroOpBufferSize,
  6, // LoadLatency
  MCSchedModel::DefaultHighLatency,
  13, // MispredictPenalty
  false, // PostRAScheduler
  false, // CompleteModel
  6, // Processor ID
  nullptr, nullptr, 0, 0, // No instruction-level machine model.
  PPCA2Itineraries,
  nullptr // No extra processor descriptor
};

static const llvm::MCSchedModel PPCE500Model = {
  2, // IssueWidth
  MCSchedModel::DefaultMicroOpBufferSize,
  MCSchedModel::DefaultLoopMicroOpBufferSize,
  5, // LoadLatency
  MCSchedModel::DefaultHighLatency,
  MCSchedModel::DefaultMispredictPenalty,
  false, // PostRAScheduler
  false, // CompleteModel
  7, // Processor ID
  nullptr, nullptr, 0, 0, // No instruction-level machine model.
  PPCE500Itineraries,
  nullptr // No extra processor descriptor
};

static const llvm::MCSchedModel PPCE500mcModel = {
  2, // IssueWidth
  MCSchedModel::DefaultMicroOpBufferSize,
  MCSchedModel::DefaultLoopMicroOpBufferSize,
  5, // LoadLatency
  MCSchedModel::DefaultHighLatency,
  MCSchedModel::DefaultMispredictPenalty,
  false, // PostRAScheduler
  false, // CompleteModel
  8, // Processor ID
  nullptr, nullptr, 0, 0, // No instruction-level machine model.
  PPCE500mcItineraries,
  nullptr // No extra processor descriptor
};

static const llvm::MCSchedModel PPCE5500Model = {
  2, // IssueWidth
  MCSchedModel::DefaultMicroOpBufferSize,
  MCSchedModel::DefaultLoopMicroOpBufferSize,
  6, // LoadLatency
  MCSchedModel::DefaultHighLatency,
  MCSchedModel::DefaultMispredictPenalty,
  false, // PostRAScheduler
  false, // CompleteModel
  9, // Processor ID
  nullptr, nullptr, 0, 0, // No instruction-level machine model.
  PPCE5500Itineraries,
  nullptr // No extra processor descriptor
};

static const llvm::MCSchedModel P8Model = {
  8, // IssueWidth
  MCSchedModel::DefaultMicroOpBufferSize,
  60, // LoopMicroOpBufferSize
  3, // LoadLatency
  MCSchedModel::DefaultHighLatency,
  16, // MispredictPenalty
  false, // PostRAScheduler
  false, // CompleteModel
  10, // Processor ID
  nullptr, nullptr, 0, 0, // No instruction-level machine model.
  P8Itineraries,
  nullptr // No extra processor descriptor
};

static const unsigned P10ModelProcResourceSubUnits[] = {
  0,  // Invalid
};

// {Name, NumUnits, SuperIdx, BufferSize, SubUnitsIdxBegin}
static const llvm::MCProcResourceDesc P10ModelProcResources[] = {
  {"InvalidUnit", 0, 0, 0, 0},
  {"P10_ANY_SLOT",    8, 0, -1, nullptr}, // #1
  {"P10_BF",          4, 0, -1, nullptr}, // #2
  {"P10_BR",          2, 0, -1, nullptr}, // #3
  {"P10_CY",          4, 0, -1, nullptr}, // #4
  {"P10_DF",          1, 0, -1, nullptr}, // #5
  {"P10_DV",          2, 0, -1, nullptr}, // #6
  {"P10_DX",          2, 0, -1, nullptr}, // #7
  {"P10_EVEN_SLOT",   4, 1, -1, nullptr}, // #8, Super=P10_ANY_SLOT
  {"P10_FX",          4, 0, -1, nullptr}, // #9
  {"P10_LD",          2, 0, -1, nullptr}, // #10
  {"P10_MM",          2, 0, -1, nullptr}, // #11
  {"P10_ODD_SLOT",    4, 1, -1, nullptr}, // #12, Super=P10_ANY_SLOT
  {"P10_PM",          4, 0, -1, nullptr}, // #13
  {"P10_ST",          2, 0, -1, nullptr}, // #14
  {"P10_SX",          2, 0, -1, nullptr}, // #15
};

static const llvm::MCSchedModel P10Model = {
  8, // IssueWidth
  44, // MicroOpBufferSize
  60, // LoopMicroOpBufferSize
  MCSchedModel::DefaultLoadLatency,
  MCSchedModel::DefaultHighLatency,
  MCSchedModel::DefaultMispredictPenalty,
  false, // PostRAScheduler
  true, // CompleteModel
  11, // Processor ID
  P10ModelProcResources,
  P10ModelSchedClasses,
  16,
  533,
  nullptr, // No Itinerary
  nullptr // No extra processor descriptor
};

static const llvm::MCSchedModel P7Model = {
  6, // IssueWidth
  MCSchedModel::DefaultMicroOpBufferSize,
  40, // LoopMicroOpBufferSize
  3, // LoadLatency
  MCSchedModel::DefaultHighLatency,
  16, // MispredictPenalty
  false, // PostRAScheduler
  false, // CompleteModel
  12, // Processor ID
  nullptr, nullptr, 0, 0, // No instruction-level machine model.
  P7Itineraries,
  nullptr // No extra processor descriptor
};

static const unsigned P9ModelProcResourceSubUnits[] = {
  0,  // Invalid
  10,   10,   11,   11,   12,   12,   // DISP_NBR
  10,   10,   11,   11,   // DISP_SS
};

// {Name, NumUnits, SuperIdx, BufferSize, SubUnitsIdxBegin}
static const llvm::MCProcResourceDesc P9ModelProcResources[] = {
  {"InvalidUnit", 0, 0, 0, 0},
  {"ALU",             4, 0, -1, nullptr}, // #1
  {"ALUE",            2, 1, -1, nullptr}, // #2, Super=ALU
  {"ALUO",            2, 1, -1, nullptr}, // #3, Super=ALU
  {"BR",              1, 0, 16, nullptr}, // #4
  {"CY",              1, 0, -1, nullptr}, // #5
  {"DFU",             1, 0, -1, nullptr}, // #6
  {"DISP_NBR",        6, 0, -1, P9ModelProcResourceSubUnits + 1}, // #7
  {"DISP_SS",         4, 0, -1, P9ModelProcResourceSubUnits + 7}, // #8
  {"DISPb01",         2, 0, -1, nullptr}, // #9
  {"DISPx02",         2, 0, -1, nullptr}, // #10
  {"DISPx13",         2, 0, -1, nullptr}, // #11
  {"DISPxab",         2, 0, -1, nullptr}, // #12
  {"DIV",             2, 0, -1, nullptr}, // #13
  {"DP",              4, 0, -1, nullptr}, // #14
  {"DPE",             2, 14, -1, nullptr}, // #15, Super=DP
  {"DPO",             2, 14, -1, nullptr}, // #16, Super=DP
  {"IP_AGEN",         4, 0, -1, nullptr}, // #17
  {"IP_EXEC",         4, 0, -1, nullptr}, // #18
  {"IP_EXECE",        2, 18, -1, nullptr}, // #19, Super=IP_EXEC
  {"IP_EXECO",        2, 18, -1, nullptr}, // #20, Super=IP_EXEC
  {"LS",              4, 0, -1, nullptr}, // #21
  {"PM",              2, 0, -1, nullptr}, // #22
};

static const llvm::MCSchedModel P9Model = {
  8, // IssueWidth
  44, // MicroOpBufferSize
  60, // LoopMicroOpBufferSize
  5, // LoadLatency
  MCSchedModel::DefaultHighLatency,
  16, // MispredictPenalty
  false, // PostRAScheduler
  true, // CompleteModel
  13, // Processor ID
  P9ModelProcResources,
  P9ModelSchedClasses,
  23,
  533,
  nullptr, // No Itinerary
  nullptr // No extra processor descriptor
};

// Sorted (by key) array of values for CPU subtype.
extern const llvm::SubtargetSubTypeKV PPCSubTypeKV[] = {
 { "440", { { { 0x840c002000000010ULL, 0x280ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &PPC440Model },
 { "450", { { { 0x840c002000000010ULL, 0x280ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &PPC440Model },
 { "601", { { { 0x1000000000020ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G3ItinerariesModel },
 { "602", { { { 0x1000000000040ULL, 0x80ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G3ItinerariesModel },
 { "603", { { { 0xc000000000080ULL, 0x80ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G3ItinerariesModel },
 { "603e", { { { 0xc000000000080ULL, 0x80ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G3ItinerariesModel },
 { "603ev", { { { 0xc000000000080ULL, 0x80ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G3ItinerariesModel },
 { "604", { { { 0xc000000000100ULL, 0x80ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G3ItinerariesModel },
 { "604e", { { { 0xc000000000100ULL, 0x80ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G3ItinerariesModel },
 { "620", { { { 0xc000000000200ULL, 0x80ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G3ItinerariesModel },
 { "7400", { { { 0xc000200001000ULL, 0x80ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G4ItinerariesModel },
 { "7450", { { { 0xc000200001000ULL, 0x80ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G4PlusItinerariesModel },
 { "750", { { { 0xc000000000400ULL, 0x80ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G4ItinerariesModel },
 { "970", { { { 0x2c000210000800ULL, 0x1000000c0ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G5Model },
 { "a2", { { { 0x843ee06010002000ULL, 0x9400000c6ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &PPCA2Model },
 { "e500", { { { 0x8400002000004000ULL, 0x80000280ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &PPCE500Model },
 { "e500mc", { { { 0x8400002000008000ULL, 0x100000080ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &PPCE500mcModel },
 { "e5500", { { { 0x8400002010010000ULL, 0x1000000c0ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &PPCE5500Model },
 { "future", { { { 0xfd3ef24e57800002ULL, 0xf557e7f9deULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &NoSchedModel },
 { "g3", { { { 0xc000000000400ULL, 0x80ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G3ItinerariesModel },
 { "g4", { { { 0xc000200001000ULL, 0x80ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G4ItinerariesModel },
 { "g4+", { { { 0xc000200001000ULL, 0x80ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G4PlusItinerariesModel },
 { "g5", { { { 0x2c000210000802ULL, 0x1000000c0ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G5Model },
 { "generic", { { { 0x200000000000004ULL, 0x80ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G3ItinerariesModel },
 { "ppc", { { { 0x200000000000004ULL, 0x80ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G3ItinerariesModel },
 { "ppc32", { { { 0x200000000000004ULL, 0x80ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G3ItinerariesModel },
 { "ppc64", { { { 0x2c000210000008ULL, 0x1000000c0ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G5Model },
 { "ppc64le", { { { 0x9d3ef24b91800002ULL, 0xe1530438c6ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &P8Model },
 { "pwr10", { { { 0xfd3ef24e57800002ULL, 0xf557e7f9deULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &P10Model },
 { "pwr3", { { { 0xc000210020000ULL, 0x100000040ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G5Model },
 { "pwr4", { { { 0x2c000210040000ULL, 0x1000000c0ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G5Model },
 { "pwr5", { { { 0x3e000210080002ULL, 0x1000000c0ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G5Model },
 { "pwr5x", { { { 0x3e800210100002ULL, 0x1000000c0ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G5Model },
 { "pwr6", { { { 0x3ea04210200002ULL, 0x1400000c4ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G5Model },
 { "pwr6x", { { { 0x3ea04210100002ULL, 0x1400000c4ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &G5Model },
 { "pwr7", { { { 0x883ef04a10800002ULL, 0xe1400400c6ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &P7Model },
 { "pwr8", { { { 0x9d3ef24b91800002ULL, 0xe1530438c6ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &P8Model },
 { "pwr9", { { { 0xbd3ef24a13800002ULL, 0x1e15364f8c6ULL, 0x0ULL, 0x0ULL, } } }, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } }, &P9Model },
};

namespace PPC_MC {
unsigned resolveVariantSchedClassImpl(unsigned SchedClass,
    const MCInst *MI, const MCInstrInfo *MCII, unsigned CPUID) {
  switch (SchedClass) {
  case 152: // FRSP_FRIMD_FRIMS_FRIND_FRINS_FRIPD_FRIPS_FRIZD_FRIZS_FRE_FRES_FADDS_FMSUBS_FMADDS_FSUBS_FCFID_FCFIDS_FCFIDU_FCFIDUS_FCTID_FCTIDU_FCTIDUZ_FCTIDZ_FCTIW_FCTIWU_FCTIWUZ_FCTIWZ_FRSQRTE_FRSQRTES_FNMADDS_FNMSUBS_FSELD_FSELS_FMULS
    if (CPUID == 11) { // P10Model
      if ((
            MI->getOpcode() == PPC::FADD
            || MI->getOpcode() == PPC::FADDS
            || MI->getOpcode() == PPC::FADDS_rec
            || MI->getOpcode() == PPC::FADD_rec
            || MI->getOpcode() == PPC::FCFID
            || MI->getOpcode() == PPC::FCFIDS
            || MI->getOpcode() == PPC::FCFIDS_rec
            || MI->getOpcode() == PPC::FCFIDU
            || MI->getOpcode() == PPC::FCFIDUS
            || MI->getOpcode() == PPC::FCFIDUS_rec
            || MI->getOpcode() == PPC::FCFIDU_rec
            || MI->getOpcode() == PPC::FCFID_rec
            || MI->getOpcode() == PPC::FCTID
            || MI->getOpcode() == PPC::FCTIDU
            || MI->getOpcode() == PPC::FCTIDUZ
            || MI->getOpcode() == PPC::FCTIDUZ_rec
            || MI->getOpcode() == PPC::FCTIDU_rec
            || MI->getOpcode() == PPC::FCTIDZ
            || MI->getOpcode() == PPC::FCTIDZ_rec
            || MI->getOpcode() == PPC::FCTID_rec
            || MI->getOpcode() == PPC::FCTIW
            || MI->getOpcode() == PPC::FCTIWU
            || MI->getOpcode() == PPC::FCTIWUZ
            || MI->getOpcode() == PPC::FCTIWUZ_rec
            || MI->getOpcode() == PPC::FCTIWU_rec
            || MI->getOpcode() == PPC::FCTIWZ
            || MI->getOpcode() == PPC::FCTIWZ_rec
            || MI->getOpcode() == PPC::FCTIW_rec
            || MI->getOpcode() == PPC::FMADD
            || MI->getOpcode() == PPC::FMADDS
            || MI->getOpcode() == PPC::FMADDS_rec
            || MI->getOpcode() == PPC::FMADD_rec
            || MI->getOpcode() == PPC::FMSUB
            || MI->getOpcode() == PPC::FMSUBS
            || MI->getOpcode() == PPC::FMSUBS_rec
            || MI->getOpcode() == PPC::FMSUB_rec
            || MI->getOpcode() == PPC::FMUL
            || MI->getOpcode() == PPC::FMULS
            || MI->getOpcode() == PPC::FMULS_rec
            || MI->getOpcode() == PPC::FMUL_rec
            || MI->getOpcode() == PPC::FNMADD
            || MI->getOpcode() == PPC::FNMADDS
            || MI->getOpcode() == PPC::FNMADDS_rec
            || MI->getOpcode() == PPC::FNMADD_rec
            || MI->getOpcode() == PPC::FNMSUB
            || MI->getOpcode() == PPC::FNMSUBS
            || MI->getOpcode() == PPC::FNMSUBS_rec
            || MI->getOpcode() == PPC::FNMSUB_rec
            || MI->getOpcode() == PPC::FRE
            || MI->getOpcode() == PPC::FRES
            || MI->getOpcode() == PPC::FRES_rec
            || MI->getOpcode() == PPC::FRE_rec
            || MI->getOpcode() == PPC::FRIMD
            || MI->getOpcode() == PPC::FRIMS
            || MI->getOpcode() == PPC::FRIMD_rec
            || MI->getOpcode() == PPC::FRIMS_rec
            || MI->getOpcode() == PPC::FRIND
            || MI->getOpcode() == PPC::FRINS
            || MI->getOpcode() == PPC::FRIND_rec
            || MI->getOpcode() == PPC::FRINS_rec
            || MI->getOpcode() == PPC::FRIPD
            || MI->getOpcode() == PPC::FRIPS
            || MI->getOpcode() == PPC::FRIPD_rec
            || MI->getOpcode() == PPC::FRIPS_rec
            || MI->getOpcode() == PPC::FRIZD
            || MI->getOpcode() == PPC::FRIZS
            || MI->getOpcode() == PPC::FRIZD_rec
            || MI->getOpcode() == PPC::FRIZS_rec
            || MI->getOpcode() == PPC::FRSP
            || MI->getOpcode() == PPC::FRSP_rec
            || MI->getOpcode() == PPC::FRSQRTE
            || MI->getOpcode() == PPC::FRSQRTES
            || MI->getOpcode() == PPC::FRSQRTES_rec
            || MI->getOpcode() == PPC::FRSQRTE_rec
            || MI->getOpcode() == PPC::FSELD
            || MI->getOpcode() == PPC::FSELS
            || MI->getOpcode() == PPC::FSELD_rec
            || MI->getOpcode() == PPC::FSELS_rec
            || MI->getOpcode() == PPC::FSUB
            || MI->getOpcode() == PPC::FSUBS
            || MI->getOpcode() == PPC::FSUBS_rec
            || MI->getOpcode() == PPC::FSUB_rec
            || MI->getOpcode() == PPC::VADDFP
            || MI->getOpcode() == PPC::VCFSX
            || MI->getOpcode() == PPC::VCFSX_0
            || MI->getOpcode() == PPC::VCFUX
            || MI->getOpcode() == PPC::VCFUX_0
            || MI->getOpcode() == PPC::VCTSXS
            || MI->getOpcode() == PPC::VCTSXS_0
            || MI->getOpcode() == PPC::VCTUXS
            || MI->getOpcode() == PPC::VCTUXS_0
            || MI->getOpcode() == PPC::VEXPTEFP
            || MI->getOpcode() == PPC::VEXPTEFP
            || MI->getOpcode() == PPC::VLOGEFP
            || MI->getOpcode() == PPC::VMADDFP
            || MI->getOpcode() == PPC::VNMSUBFP
            || MI->getOpcode() == PPC::VREFP
            || MI->getOpcode() == PPC::VRFIM
            || MI->getOpcode() == PPC::VRFIN
            || MI->getOpcode() == PPC::VRFIP
            || MI->getOpcode() == PPC::VRFIZ
            || MI->getOpcode() == PPC::VRSQRTEFP
            || MI->getOpcode() == PPC::VSUBFP
            || MI->getOpcode() == PPC::XSADDDP
            || MI->getOpcode() == PPC::XSADDSP
            || MI->getOpcode() == PPC::XSCVDPHP
            || MI->getOpcode() == PPC::XSCVDPSP
            || MI->getOpcode() == PPC::XSCVDPSPN
            || MI->getOpcode() == PPC::XSCVDPSXDS
            || MI->getOpcode() == PPC::XSCVDPSXDSs
            || MI->getOpcode() == PPC::XSCVDPSXWS
            || MI->getOpcode() == PPC::XSCVDPSXWSs
            || MI->getOpcode() == PPC::XSCVDPUXDS
            || MI->getOpcode() == PPC::XSCVDPUXDSs
            || MI->getOpcode() == PPC::XSCVDPUXWS
            || MI->getOpcode() == PPC::XSCVDPUXWSs
            || MI->getOpcode() == PPC::XSCVSPDP
            || MI->getOpcode() == PPC::XSCVSXDDP
            || MI->getOpcode() == PPC::XSCVSXDSP
            || MI->getOpcode() == PPC::XSCVUXDDP
            || MI->getOpcode() == PPC::XSCVUXDSP
            || MI->getOpcode() == PPC::XSMADDADP
            || MI->getOpcode() == PPC::XSMADDASP
            || MI->getOpcode() == PPC::XSMADDMDP
            || MI->getOpcode() == PPC::XSMADDMSP
            || MI->getOpcode() == PPC::XSMSUBADP
            || MI->getOpcode() == PPC::XSMSUBASP
            || MI->getOpcode() == PPC::XSMSUBMDP
            || MI->getOpcode() == PPC::XSMSUBMSP
            || MI->getOpcode() == PPC::XSMULDP
            || MI->getOpcode() == PPC::XSMULSP
            || MI->getOpcode() == PPC::XSNMADDADP
            || MI->getOpcode() == PPC::XSNMADDASP
            || MI->getOpcode() == PPC::XSNMADDMDP
            || MI->getOpcode() == PPC::XSNMADDMSP
            || MI->getOpcode() == PPC::XSNMSUBADP
            || MI->getOpcode() == PPC::XSNMSUBASP
            || MI->getOpcode() == PPC::XSNMSUBMDP
            || MI->getOpcode() == PPC::XSNMSUBMSP
            || MI->getOpcode() == PPC::XSRDPI
            || MI->getOpcode() == PPC::XSRDPIC
            || MI->getOpcode() == PPC::XSRDPIM
            || MI->getOpcode() == PPC::XSRDPIP
            || MI->getOpcode() == PPC::XSRDPIZ
            || MI->getOpcode() == PPC::XSREDP
            || MI->getOpcode() == PPC::XSRESP
            || MI->getOpcode() == PPC::XSRSP
            || MI->getOpcode() == PPC::XSRSQRTEDP
            || MI->getOpcode() == PPC::XSRSQRTESP
            || MI->getOpcode() == PPC::XSSUBDP
            || MI->getOpcode() == PPC::XSSUBSP
            || MI->getOpcode() == PPC::XVADDDP
            || MI->getOpcode() == PPC::XVADDSP
            || MI->getOpcode() == PPC::XVCVDPSP
            || MI->getOpcode() == PPC::XVCVDPSXDS
            || MI->getOpcode() == PPC::XVCVDPSXWS
            || MI->getOpcode() == PPC::XVCVDPUXDS
            || MI->getOpcode() == PPC::XVCVDPUXWS
            || MI->getOpcode() == PPC::XVCVSPBF16
            || MI->getOpcode() == PPC::XVCVSPDP
            || MI->getOpcode() == PPC::XVCVSPHP
            || MI->getOpcode() == PPC::XVCVSPSXDS
            || MI->getOpcode() == PPC::XVCVSPSXWS
            || MI->getOpcode() == PPC::XVCVSPUXDS
            || MI->getOpcode() == PPC::XVCVSPUXWS
            || MI->getOpcode() == PPC::XVCVSXDDP
            || MI->getOpcode() == PPC::XVCVSXDSP
            || MI->getOpcode() == PPC::XVCVSXWDP
            || MI->getOpcode() == PPC::XVCVSXWSP
            || MI->getOpcode() == PPC::XVCVUXDDP
            || MI->getOpcode() == PPC::XVCVUXDSP
            || MI->getOpcode() == PPC::XVCVUXWDP
            || MI->getOpcode() == PPC::XVCVUXWSP
            || MI->getOpcode() == PPC::XVMADDADP
            || MI->getOpcode() == PPC::XVMADDASP
            || MI->getOpcode() == PPC::XVMADDMDP
            || MI->getOpcode() == PPC::XVMADDMSP
            || MI->getOpcode() == PPC::XVMSUBADP
            || MI->getOpcode() == PPC::XVMSUBASP
            || MI->getOpcode() == PPC::XVMSUBMDP
            || MI->getOpcode() == PPC::XVMSUBMSP
            || MI->getOpcode() == PPC::XVMULDP
            || MI->getOpcode() == PPC::XVMULSP
            || MI->getOpcode() == PPC::XVNMADDADP
            || MI->getOpcode() == PPC::XVNMADDASP
            || MI->getOpcode() == PPC::XVNMADDMDP
            || MI->getOpcode() == PPC::XVNMADDMSP
            || MI->getOpcode() == PPC::XVNMSUBADP
            || MI->getOpcode() == PPC::XVNMSUBASP
            || MI->getOpcode() == PPC::XVNMSUBMDP
            || MI->getOpcode() == PPC::XVNMSUBMSP
            || MI->getOpcode() == PPC::XVRDPI
            || MI->getOpcode() == PPC::XVRDPIC
            || MI->getOpcode() == PPC::XVRDPIM
            || MI->getOpcode() == PPC::XVRDPIP
            || MI->getOpcode() == PPC::XVRDPIZ
            || MI->getOpcode() == PPC::XVREDP
            || MI->getOpcode() == PPC::XVRESP
            || MI->getOpcode() == PPC::XVRSPI
            || MI->getOpcode() == PPC::XVRSPIC
            || MI->getOpcode() == PPC::XVRSPIM
            || MI->getOpcode() == PPC::XVRSPIP
            || MI->getOpcode() == PPC::XVRSPIZ
            || MI->getOpcode() == PPC::XVRSQRTEDP
            || MI->getOpcode() == PPC::XVRSQRTESP
            || MI->getOpcode() == PPC::XVSUBDP
            || MI->getOpcode() == PPC::XVSUBSP
          ))
        return 499; // P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_2C_P10BF_Read_2C_P10BF_Read_2C
      return 500; // P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_1C_P10BF_Read_1C_P10BF_Read_1C
    }
    break;
  case 153: // FADD_FSUB
    if (CPUID == 11) { // P10Model
      if ((
            MI->getOpcode() == PPC::FADD
            || MI->getOpcode() == PPC::FADDS
            || MI->getOpcode() == PPC::FADDS_rec
            || MI->getOpcode() == PPC::FADD_rec
            || MI->getOpcode() == PPC::FCFID
            || MI->getOpcode() == PPC::FCFIDS
            || MI->getOpcode() == PPC::FCFIDS_rec
            || MI->getOpcode() == PPC::FCFIDU
            || MI->getOpcode() == PPC::FCFIDUS
            || MI->getOpcode() == PPC::FCFIDUS_rec
            || MI->getOpcode() == PPC::FCFIDU_rec
            || MI->getOpcode() == PPC::FCFID_rec
            || MI->getOpcode() == PPC::FCTID
            || MI->getOpcode() == PPC::FCTIDU
            || MI->getOpcode() == PPC::FCTIDUZ
            || MI->getOpcode() == PPC::FCTIDUZ_rec
            || MI->getOpcode() == PPC::FCTIDU_rec
            || MI->getOpcode() == PPC::FCTIDZ
            || MI->getOpcode() == PPC::FCTIDZ_rec
            || MI->getOpcode() == PPC::FCTID_rec
            || MI->getOpcode() == PPC::FCTIW
            || MI->getOpcode() == PPC::FCTIWU
            || MI->getOpcode() == PPC::FCTIWUZ
            || MI->getOpcode() == PPC::FCTIWUZ_rec
            || MI->getOpcode() == PPC::FCTIWU_rec
            || MI->getOpcode() == PPC::FCTIWZ
            || MI->getOpcode() == PPC::FCTIWZ_rec
            || MI->getOpcode() == PPC::FCTIW_rec
            || MI->getOpcode() == PPC::FMADD
            || MI->getOpcode() == PPC::FMADDS
            || MI->getOpcode() == PPC::FMADDS_rec
            || MI->getOpcode() == PPC::FMADD_rec
            || MI->getOpcode() == PPC::FMSUB
            || MI->getOpcode() == PPC::FMSUBS
            || MI->getOpcode() == PPC::FMSUBS_rec
            || MI->getOpcode() == PPC::FMSUB_rec
            || MI->getOpcode() == PPC::FMUL
            || MI->getOpcode() == PPC::FMULS
            || MI->getOpcode() == PPC::FMULS_rec
            || MI->getOpcode() == PPC::FMUL_rec
            || MI->getOpcode() == PPC::FNMADD
            || MI->getOpcode() == PPC::FNMADDS
            || MI->getOpcode() == PPC::FNMADDS_rec
            || MI->getOpcode() == PPC::FNMADD_rec
            || MI->getOpcode() == PPC::FNMSUB
            || MI->getOpcode() == PPC::FNMSUBS
            || MI->getOpcode() == PPC::FNMSUBS_rec
            || MI->getOpcode() == PPC::FNMSUB_rec
            || MI->getOpcode() == PPC::FRE
            || MI->getOpcode() == PPC::FRES
            || MI->getOpcode() == PPC::FRES_rec
            || MI->getOpcode() == PPC::FRE_rec
            || MI->getOpcode() == PPC::FRIMD
            || MI->getOpcode() == PPC::FRIMS
            || MI->getOpcode() == PPC::FRIMD_rec
            || MI->getOpcode() == PPC::FRIMS_rec
            || MI->getOpcode() == PPC::FRIND
            || MI->getOpcode() == PPC::FRINS
            || MI->getOpcode() == PPC::FRIND_rec
            || MI->getOpcode() == PPC::FRINS_rec
            || MI->getOpcode() == PPC::FRIPD
            || MI->getOpcode() == PPC::FRIPS
            || MI->getOpcode() == PPC::FRIPD_rec
            || MI->getOpcode() == PPC::FRIPS_rec
            || MI->getOpcode() == PPC::FRIZD
            || MI->getOpcode() == PPC::FRIZS
            || MI->getOpcode() == PPC::FRIZD_rec
            || MI->getOpcode() == PPC::FRIZS_rec
            || MI->getOpcode() == PPC::FRSP
            || MI->getOpcode() == PPC::FRSP_rec
            || MI->getOpcode() == PPC::FRSQRTE
            || MI->getOpcode() == PPC::FRSQRTES
            || MI->getOpcode() == PPC::FRSQRTES_rec
            || MI->getOpcode() == PPC::FRSQRTE_rec
            || MI->getOpcode() == PPC::FSELD
            || MI->getOpcode() == PPC::FSELS
            || MI->getOpcode() == PPC::FSELD_rec
            || MI->getOpcode() == PPC::FSELS_rec
            || MI->getOpcode() == PPC::FSUB
            || MI->getOpcode() == PPC::FSUBS
            || MI->getOpcode() == PPC::FSUBS_rec
            || MI->getOpcode() == PPC::FSUB_rec
            || MI->getOpcode() == PPC::VADDFP
            || MI->getOpcode() == PPC::VCFSX
            || MI->getOpcode() == PPC::VCFSX_0
            || MI->getOpcode() == PPC::VCFUX
            || MI->getOpcode() == PPC::VCFUX_0
            || MI->getOpcode() == PPC::VCTSXS
            || MI->getOpcode() == PPC::VCTSXS_0
            || MI->getOpcode() == PPC::VCTUXS
            || MI->getOpcode() == PPC::VCTUXS_0
            || MI->getOpcode() == PPC::VEXPTEFP
            || MI->getOpcode() == PPC::VEXPTEFP
            || MI->getOpcode() == PPC::VLOGEFP
            || MI->getOpcode() == PPC::VMADDFP
            || MI->getOpcode() == PPC::VNMSUBFP
            || MI->getOpcode() == PPC::VREFP
            || MI->getOpcode() == PPC::VRFIM
            || MI->getOpcode() == PPC::VRFIN
            || MI->getOpcode() == PPC::VRFIP
            || MI->getOpcode() == PPC::VRFIZ
            || MI->getOpcode() == PPC::VRSQRTEFP
            || MI->getOpcode() == PPC::VSUBFP
            || MI->getOpcode() == PPC::XSADDDP
            || MI->getOpcode() == PPC::XSADDSP
            || MI->getOpcode() == PPC::XSCVDPHP
            || MI->getOpcode() == PPC::XSCVDPSP
            || MI->getOpcode() == PPC::XSCVDPSPN
            || MI->getOpcode() == PPC::XSCVDPSXDS
            || MI->getOpcode() == PPC::XSCVDPSXDSs
            || MI->getOpcode() == PPC::XSCVDPSXWS
            || MI->getOpcode() == PPC::XSCVDPSXWSs
            || MI->getOpcode() == PPC::XSCVDPUXDS
            || MI->getOpcode() == PPC::XSCVDPUXDSs
            || MI->getOpcode() == PPC::XSCVDPUXWS
            || MI->getOpcode() == PPC::XSCVDPUXWSs
            || MI->getOpcode() == PPC::XSCVSPDP
            || MI->getOpcode() == PPC::XSCVSXDDP
            || MI->getOpcode() == PPC::XSCVSXDSP
            || MI->getOpcode() == PPC::XSCVUXDDP
            || MI->getOpcode() == PPC::XSCVUXDSP
            || MI->getOpcode() == PPC::XSMADDADP
            || MI->getOpcode() == PPC::XSMADDASP
            || MI->getOpcode() == PPC::XSMADDMDP
            || MI->getOpcode() == PPC::XSMADDMSP
            || MI->getOpcode() == PPC::XSMSUBADP
            || MI->getOpcode() == PPC::XSMSUBASP
            || MI->getOpcode() == PPC::XSMSUBMDP
            || MI->getOpcode() == PPC::XSMSUBMSP
            || MI->getOpcode() == PPC::XSMULDP
            || MI->getOpcode() == PPC::XSMULSP
            || MI->getOpcode() == PPC::XSNMADDADP
            || MI->getOpcode() == PPC::XSNMADDASP
            || MI->getOpcode() == PPC::XSNMADDMDP
            || MI->getOpcode() == PPC::XSNMADDMSP
            || MI->getOpcode() == PPC::XSNMSUBADP
            || MI->getOpcode() == PPC::XSNMSUBASP
            || MI->getOpcode() == PPC::XSNMSUBMDP
            || MI->getOpcode() == PPC::XSNMSUBMSP
            || MI->getOpcode() == PPC::XSRDPI
            || MI->getOpcode() == PPC::XSRDPIC
            || MI->getOpcode() == PPC::XSRDPIM
            || MI->getOpcode() == PPC::XSRDPIP
            || MI->getOpcode() == PPC::XSRDPIZ
            || MI->getOpcode() == PPC::XSREDP
            || MI->getOpcode() == PPC::XSRESP
            || MI->getOpcode() == PPC::XSRSP
            || MI->getOpcode() == PPC::XSRSQRTEDP
            || MI->getOpcode() == PPC::XSRSQRTESP
            || MI->getOpcode() == PPC::XSSUBDP
            || MI->getOpcode() == PPC::XSSUBSP
            || MI->getOpcode() == PPC::XVADDDP
            || MI->getOpcode() == PPC::XVADDSP
            || MI->getOpcode() == PPC::XVCVDPSP
            || MI->getOpcode() == PPC::XVCVDPSXDS
            || MI->getOpcode() == PPC::XVCVDPSXWS
            || MI->getOpcode() == PPC::XVCVDPUXDS
            || MI->getOpcode() == PPC::XVCVDPUXWS
            || MI->getOpcode() == PPC::XVCVSPBF16
            || MI->getOpcode() == PPC::XVCVSPDP
            || MI->getOpcode() == PPC::XVCVSPHP
            || MI->getOpcode() == PPC::XVCVSPSXDS
            || MI->getOpcode() == PPC::XVCVSPSXWS
            || MI->getOpcode() == PPC::XVCVSPUXDS
            || MI->getOpcode() == PPC::XVCVSPUXWS
            || MI->getOpcode() == PPC::XVCVSXDDP
            || MI->getOpcode() == PPC::XVCVSXDSP
            || MI->getOpcode() == PPC::XVCVSXWDP
            || MI->getOpcode() == PPC::XVCVSXWSP
            || MI->getOpcode() == PPC::XVCVUXDDP
            || MI->getOpcode() == PPC::XVCVUXDSP
            || MI->getOpcode() == PPC::XVCVUXWDP
            || MI->getOpcode() == PPC::XVCVUXWSP
            || MI->getOpcode() == PPC::XVMADDADP
            || MI->getOpcode() == PPC::XVMADDASP
            || MI->getOpcode() == PPC::XVMADDMDP
            || MI->getOpcode() == PPC::XVMADDMSP
            || MI->getOpcode() == PPC::XVMSUBADP
            || MI->getOpcode() == PPC::XVMSUBASP
            || MI->getOpcode() == PPC::XVMSUBMDP
            || MI->getOpcode() == PPC::XVMSUBMSP
            || MI->getOpcode() == PPC::XVMULDP
            || MI->getOpcode() == PPC::XVMULSP
            || MI->getOpcode() == PPC::XVNMADDADP
            || MI->getOpcode() == PPC::XVNMADDASP
            || MI->getOpcode() == PPC::XVNMADDMDP
            || MI->getOpcode() == PPC::XVNMADDMSP
            || MI->getOpcode() == PPC::XVNMSUBADP
            || MI->getOpcode() == PPC::XVNMSUBASP
            || MI->getOpcode() == PPC::XVNMSUBMDP
            || MI->getOpcode() == PPC::XVNMSUBMSP
            || MI->getOpcode() == PPC::XVRDPI
            || MI->getOpcode() == PPC::XVRDPIC
            || MI->getOpcode() == PPC::XVRDPIM
            || MI->getOpcode() == PPC::XVRDPIP
            || MI->getOpcode() == PPC::XVRDPIZ
            || MI->getOpcode() == PPC::XVREDP
            || MI->getOpcode() == PPC::XVRESP
            || MI->getOpcode() == PPC::XVRSPI
            || MI->getOpcode() == PPC::XVRSPIC
            || MI->getOpcode() == PPC::XVRSPIM
            || MI->getOpcode() == PPC::XVRSPIP
            || MI->getOpcode() == PPC::XVRSPIZ
            || MI->getOpcode() == PPC::XVRSQRTEDP
            || MI->getOpcode() == PPC::XVRSQRTESP
            || MI->getOpcode() == PPC::XVSUBDP
            || MI->getOpcode() == PPC::XVSUBSP
          ))
        return 501; // P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_2C_P10BF_Read_2C
      return 502; // P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_1C_P10BF_Read_1C
    }
    break;
  case 154: // FMSUB_FMADD_FNMADD_FNMSUB_FMUL
    if (CPUID == 11) { // P10Model
      if ((
            MI->getOpcode() == PPC::FADD
            || MI->getOpcode() == PPC::FADDS
            || MI->getOpcode() == PPC::FADDS_rec
            || MI->getOpcode() == PPC::FADD_rec
            || MI->getOpcode() == PPC::FCFID
            || MI->getOpcode() == PPC::FCFIDS
            || MI->getOpcode() == PPC::FCFIDS_rec
            || MI->getOpcode() == PPC::FCFIDU
            || MI->getOpcode() == PPC::FCFIDUS
            || MI->getOpcode() == PPC::FCFIDUS_rec
            || MI->getOpcode() == PPC::FCFIDU_rec
            || MI->getOpcode() == PPC::FCFID_rec
            || MI->getOpcode() == PPC::FCTID
            || MI->getOpcode() == PPC::FCTIDU
            || MI->getOpcode() == PPC::FCTIDUZ
            || MI->getOpcode() == PPC::FCTIDUZ_rec
            || MI->getOpcode() == PPC::FCTIDU_rec
            || MI->getOpcode() == PPC::FCTIDZ
            || MI->getOpcode() == PPC::FCTIDZ_rec
            || MI->getOpcode() == PPC::FCTID_rec
            || MI->getOpcode() == PPC::FCTIW
            || MI->getOpcode() == PPC::FCTIWU
            || MI->getOpcode() == PPC::FCTIWUZ
            || MI->getOpcode() == PPC::FCTIWUZ_rec
            || MI->getOpcode() == PPC::FCTIWU_rec
            || MI->getOpcode() == PPC::FCTIWZ
            || MI->getOpcode() == PPC::FCTIWZ_rec
            || MI->getOpcode() == PPC::FCTIW_rec
            || MI->getOpcode() == PPC::FMADD
            || MI->getOpcode() == PPC::FMADDS
            || MI->getOpcode() == PPC::FMADDS_rec
            || MI->getOpcode() == PPC::FMADD_rec
            || MI->getOpcode() == PPC::FMSUB
            || MI->getOpcode() == PPC::FMSUBS
            || MI->getOpcode() == PPC::FMSUBS_rec
            || MI->getOpcode() == PPC::FMSUB_rec
            || MI->getOpcode() == PPC::FMUL
            || MI->getOpcode() == PPC::FMULS
            || MI->getOpcode() == PPC::FMULS_rec
            || MI->getOpcode() == PPC::FMUL_rec
            || MI->getOpcode() == PPC::FNMADD
            || MI->getOpcode() == PPC::FNMADDS
            || MI->getOpcode() == PPC::FNMADDS_rec
            || MI->getOpcode() == PPC::FNMADD_rec
            || MI->getOpcode() == PPC::FNMSUB
            || MI->getOpcode() == PPC::FNMSUBS
            || MI->getOpcode() == PPC::FNMSUBS_rec
            || MI->getOpcode() == PPC::FNMSUB_rec
            || MI->getOpcode() == PPC::FRE
            || MI->getOpcode() == PPC::FRES
            || MI->getOpcode() == PPC::FRES_rec
            || MI->getOpcode() == PPC::FRE_rec
            || MI->getOpcode() == PPC::FRIMD
            || MI->getOpcode() == PPC::FRIMS
            || MI->getOpcode() == PPC::FRIMD_rec
            || MI->getOpcode() == PPC::FRIMS_rec
            || MI->getOpcode() == PPC::FRIND
            || MI->getOpcode() == PPC::FRINS
            || MI->getOpcode() == PPC::FRIND_rec
            || MI->getOpcode() == PPC::FRINS_rec
            || MI->getOpcode() == PPC::FRIPD
            || MI->getOpcode() == PPC::FRIPS
            || MI->getOpcode() == PPC::FRIPD_rec
            || MI->getOpcode() == PPC::FRIPS_rec
            || MI->getOpcode() == PPC::FRIZD
            || MI->getOpcode() == PPC::FRIZS
            || MI->getOpcode() == PPC::FRIZD_rec
            || MI->getOpcode() == PPC::FRIZS_rec
            || MI->getOpcode() == PPC::FRSP
            || MI->getOpcode() == PPC::FRSP_rec
            || MI->getOpcode() == PPC::FRSQRTE
            || MI->getOpcode() == PPC::FRSQRTES
            || MI->getOpcode() == PPC::FRSQRTES_rec
            || MI->getOpcode() == PPC::FRSQRTE_rec
            || MI->getOpcode() == PPC::FSELD
            || MI->getOpcode() == PPC::FSELS
            || MI->getOpcode() == PPC::FSELD_rec
            || MI->getOpcode() == PPC::FSELS_rec
            || MI->getOpcode() == PPC::FSUB
            || MI->getOpcode() == PPC::FSUBS
            || MI->getOpcode() == PPC::FSUBS_rec
            || MI->getOpcode() == PPC::FSUB_rec
            || MI->getOpcode() == PPC::VADDFP
            || MI->getOpcode() == PPC::VCFSX
            || MI->getOpcode() == PPC::VCFSX_0
            || MI->getOpcode() == PPC::VCFUX
            || MI->getOpcode() == PPC::VCFUX_0
            || MI->getOpcode() == PPC::VCTSXS
            || MI->getOpcode() == PPC::VCTSXS_0
            || MI->getOpcode() == PPC::VCTUXS
            || MI->getOpcode() == PPC::VCTUXS_0
            || MI->getOpcode() == PPC::VEXPTEFP
            || MI->getOpcode() == PPC::VEXPTEFP
            || MI->getOpcode() == PPC::VLOGEFP
            || MI->getOpcode() == PPC::VMADDFP
            || MI->getOpcode() == PPC::VNMSUBFP
            || MI->getOpcode() == PPC::VREFP
            || MI->getOpcode() == PPC::VRFIM
            || MI->getOpcode() == PPC::VRFIN
            || MI->getOpcode() == PPC::VRFIP
            || MI->getOpcode() == PPC::VRFIZ
            || MI->getOpcode() == PPC::VRSQRTEFP
            || MI->getOpcode() == PPC::VSUBFP
            || MI->getOpcode() == PPC::XSADDDP
            || MI->getOpcode() == PPC::XSADDSP
            || MI->getOpcode() == PPC::XSCVDPHP
            || MI->getOpcode() == PPC::XSCVDPSP
            || MI->getOpcode() == PPC::XSCVDPSPN
            || MI->getOpcode() == PPC::XSCVDPSXDS
            || MI->getOpcode() == PPC::XSCVDPSXDSs
            || MI->getOpcode() == PPC::XSCVDPSXWS
            || MI->getOpcode() == PPC::XSCVDPSXWSs
            || MI->getOpcode() == PPC::XSCVDPUXDS
            || MI->getOpcode() == PPC::XSCVDPUXDSs
            || MI->getOpcode() == PPC::XSCVDPUXWS
            || MI->getOpcode() == PPC::XSCVDPUXWSs
            || MI->getOpcode() == PPC::XSCVSPDP
            || MI->getOpcode() == PPC::XSCVSXDDP
            || MI->getOpcode() == PPC::XSCVSXDSP
            || MI->getOpcode() == PPC::XSCVUXDDP
            || MI->getOpcode() == PPC::XSCVUXDSP
            || MI->getOpcode() == PPC::XSMADDADP
            || MI->getOpcode() == PPC::XSMADDASP
            || MI->getOpcode() == PPC::XSMADDMDP
            || MI->getOpcode() == PPC::XSMADDMSP
            || MI->getOpcode() == PPC::XSMSUBADP
            || MI->getOpcode() == PPC::XSMSUBASP
            || MI->getOpcode() == PPC::XSMSUBMDP
            || MI->getOpcode() == PPC::XSMSUBMSP
            || MI->getOpcode() == PPC::XSMULDP
            || MI->getOpcode() == PPC::XSMULSP
            || MI->getOpcode() == PPC::XSNMADDADP
            || MI->getOpcode() == PPC::XSNMADDASP
            || MI->getOpcode() == PPC::XSNMADDMDP
            || MI->getOpcode() == PPC::XSNMADDMSP
            || MI->getOpcode() == PPC::XSNMSUBADP
            || MI->getOpcode() == PPC::XSNMSUBASP
            || MI->getOpcode() == PPC::XSNMSUBMDP
            || MI->getOpcode() == PPC::XSNMSUBMSP
            || MI->getOpcode() == PPC::XSRDPI
            || MI->getOpcode() == PPC::XSRDPIC
            || MI->getOpcode() == PPC::XSRDPIM
            || MI->getOpcode() == PPC::XSRDPIP
            || MI->getOpcode() == PPC::XSRDPIZ
            || MI->getOpcode() == PPC::XSREDP
            || MI->getOpcode() == PPC::XSRESP
            || MI->getOpcode() == PPC::XSRSP
            || MI->getOpcode() == PPC::XSRSQRTEDP
            || MI->getOpcode() == PPC::XSRSQRTESP
            || MI->getOpcode() == PPC::XSSUBDP
            || MI->getOpcode() == PPC::XSSUBSP
            || MI->getOpcode() == PPC::XVADDDP
            || MI->getOpcode() == PPC::XVADDSP
            || MI->getOpcode() == PPC::XVCVDPSP
            || MI->getOpcode() == PPC::XVCVDPSXDS
            || MI->getOpcode() == PPC::XVCVDPSXWS
            || MI->getOpcode() == PPC::XVCVDPUXDS
            || MI->getOpcode() == PPC::XVCVDPUXWS
            || MI->getOpcode() == PPC::XVCVSPBF16
            || MI->getOpcode() == PPC::XVCVSPDP
            || MI->getOpcode() == PPC::XVCVSPHP
            || MI->getOpcode() == PPC::XVCVSPSXDS
            || MI->getOpcode() == PPC::XVCVSPSXWS
            || MI->getOpcode() == PPC::XVCVSPUXDS
            || MI->getOpcode() == PPC::XVCVSPUXWS
            || MI->getOpcode() == PPC::XVCVSXDDP
            || MI->getOpcode() == PPC::XVCVSXDSP
            || MI->getOpcode() == PPC::XVCVSXWDP
            || MI->getOpcode() == PPC::XVCVSXWSP
            || MI->getOpcode() == PPC::XVCVUXDDP
            || MI->getOpcode() == PPC::XVCVUXDSP
            || MI->getOpcode() == PPC::XVCVUXWDP
            || MI->getOpcode() == PPC::XVCVUXWSP
            || MI->getOpcode() == PPC::XVMADDADP
            || MI->getOpcode() == PPC::XVMADDASP
            || MI->getOpcode() == PPC::XVMADDMDP
            || MI->getOpcode() == PPC::XVMADDMSP
            || MI->getOpcode() == PPC::XVMSUBADP
            || MI->getOpcode() == PPC::XVMSUBASP
            || MI->getOpcode() == PPC::XVMSUBMDP
            || MI->getOpcode() == PPC::XVMSUBMSP
            || MI->getOpcode() == PPC::XVMULDP
            || MI->getOpcode() == PPC::XVMULSP
            || MI->getOpcode() == PPC::XVNMADDADP
            || MI->getOpcode() == PPC::XVNMADDASP
            || MI->getOpcode() == PPC::XVNMADDMDP
            || MI->getOpcode() == PPC::XVNMADDMSP
            || MI->getOpcode() == PPC::XVNMSUBADP
            || MI->getOpcode() == PPC::XVNMSUBASP
            || MI->getOpcode() == PPC::XVNMSUBMDP
            || MI->getOpcode() == PPC::XVNMSUBMSP
            || MI->getOpcode() == PPC::XVRDPI
            || MI->getOpcode() == PPC::XVRDPIC
            || MI->getOpcode() == PPC::XVRDPIM
            || MI->getOpcode() == PPC::XVRDPIP
            || MI->getOpcode() == PPC::XVRDPIZ
            || MI->getOpcode() == PPC::XVREDP
            || MI->getOpcode() == PPC::XVRESP
            || MI->getOpcode() == PPC::XVRSPI
            || MI->getOpcode() == PPC::XVRSPIC
            || MI->getOpcode() == PPC::XVRSPIM
            || MI->getOpcode() == PPC::XVRSPIP
            || MI->getOpcode() == PPC::XVRSPIZ
            || MI->getOpcode() == PPC::XVRSQRTEDP
            || MI->getOpcode() == PPC::XVRSQRTESP
            || MI->getOpcode() == PPC::XVSUBDP
            || MI->getOpcode() == PPC::XVSUBSP
          ))
        return 499; // P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_2C_P10BF_Read_2C_P10BF_Read_2C
      return 500; // P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_1C_P10BF_Read_1C_P10BF_Read_1C
    }
    break;
  case 155: // XSMADDADP_XSMADDASP_XSMADDMDP_XSMADDMSP_XSMSUBADP_XSMSUBASP_XSMSUBMDP_XSMSUBMSP_XSMULDP_XSMULSP_XSNMADDADP_XSNMADDASP_XSNMADDMDP_XSNMADDMSP_XSNMSUBADP_XSNMSUBASP_XSNMSUBMDP_XSNMSUBMSP
    if (CPUID == 11) { // P10Model
      if ((
            MI->getOpcode() == PPC::FADD
            || MI->getOpcode() == PPC::FADDS
            || MI->getOpcode() == PPC::FADDS_rec
            || MI->getOpcode() == PPC::FADD_rec
            || MI->getOpcode() == PPC::FCFID
            || MI->getOpcode() == PPC::FCFIDS
            || MI->getOpcode() == PPC::FCFIDS_rec
            || MI->getOpcode() == PPC::FCFIDU
            || MI->getOpcode() == PPC::FCFIDUS
            || MI->getOpcode() == PPC::FCFIDUS_rec
            || MI->getOpcode() == PPC::FCFIDU_rec
            || MI->getOpcode() == PPC::FCFID_rec
            || MI->getOpcode() == PPC::FCTID
            || MI->getOpcode() == PPC::FCTIDU
            || MI->getOpcode() == PPC::FCTIDUZ
            || MI->getOpcode() == PPC::FCTIDUZ_rec
            || MI->getOpcode() == PPC::FCTIDU_rec
            || MI->getOpcode() == PPC::FCTIDZ
            || MI->getOpcode() == PPC::FCTIDZ_rec
            || MI->getOpcode() == PPC::FCTID_rec
            || MI->getOpcode() == PPC::FCTIW
            || MI->getOpcode() == PPC::FCTIWU
            || MI->getOpcode() == PPC::FCTIWUZ
            || MI->getOpcode() == PPC::FCTIWUZ_rec
            || MI->getOpcode() == PPC::FCTIWU_rec
            || MI->getOpcode() == PPC::FCTIWZ
            || MI->getOpcode() == PPC::FCTIWZ_rec
            || MI->getOpcode() == PPC::FCTIW_rec
            || MI->getOpcode() == PPC::FMADD
            || MI->getOpcode() == PPC::FMADDS
            || MI->getOpcode() == PPC::FMADDS_rec
            || MI->getOpcode() == PPC::FMADD_rec
            || MI->getOpcode() == PPC::FMSUB
            || MI->getOpcode() == PPC::FMSUBS
            || MI->getOpcode() == PPC::FMSUBS_rec
            || MI->getOpcode() == PPC::FMSUB_rec
            || MI->getOpcode() == PPC::FMUL
            || MI->getOpcode() == PPC::FMULS
            || MI->getOpcode() == PPC::FMULS_rec
            || MI->getOpcode() == PPC::FMUL_rec
            || MI->getOpcode() == PPC::FNMADD
            || MI->getOpcode() == PPC::FNMADDS
            || MI->getOpcode() == PPC::FNMADDS_rec
            || MI->getOpcode() == PPC::FNMADD_rec
            || MI->getOpcode() == PPC::FNMSUB
            || MI->getOpcode() == PPC::FNMSUBS
            || MI->getOpcode() == PPC::FNMSUBS_rec
            || MI->getOpcode() == PPC::FNMSUB_rec
            || MI->getOpcode() == PPC::FRE
            || MI->getOpcode() == PPC::FRES
            || MI->getOpcode() == PPC::FRES_rec
            || MI->getOpcode() == PPC::FRE_rec
            || MI->getOpcode() == PPC::FRIMD
            || MI->getOpcode() == PPC::FRIMS
            || MI->getOpcode() == PPC::FRIMD_rec
            || MI->getOpcode() == PPC::FRIMS_rec
            || MI->getOpcode() == PPC::FRIND
            || MI->getOpcode() == PPC::FRINS
            || MI->getOpcode() == PPC::FRIND_rec
            || MI->getOpcode() == PPC::FRINS_rec
            || MI->getOpcode() == PPC::FRIPD
            || MI->getOpcode() == PPC::FRIPS
            || MI->getOpcode() == PPC::FRIPD_rec
            || MI->getOpcode() == PPC::FRIPS_rec
            || MI->getOpcode() == PPC::FRIZD
            || MI->getOpcode() == PPC::FRIZS
            || MI->getOpcode() == PPC::FRIZD_rec
            || MI->getOpcode() == PPC::FRIZS_rec
            || MI->getOpcode() == PPC::FRSP
            || MI->getOpcode() == PPC::FRSP_rec
            || MI->getOpcode() == PPC::FRSQRTE
            || MI->getOpcode() == PPC::FRSQRTES
            || MI->getOpcode() == PPC::FRSQRTES_rec
            || MI->getOpcode() == PPC::FRSQRTE_rec
            || MI->getOpcode() == PPC::FSELD
            || MI->getOpcode() == PPC::FSELS
            || MI->getOpcode() == PPC::FSELD_rec
            || MI->getOpcode() == PPC::FSELS_rec
            || MI->getOpcode() == PPC::FSUB
            || MI->getOpcode() == PPC::FSUBS
            || MI->getOpcode() == PPC::FSUBS_rec
            || MI->getOpcode() == PPC::FSUB_rec
            || MI->getOpcode() == PPC::VADDFP
            || MI->getOpcode() == PPC::VCFSX
            || MI->getOpcode() == PPC::VCFSX_0
            || MI->getOpcode() == PPC::VCFUX
            || MI->getOpcode() == PPC::VCFUX_0
            || MI->getOpcode() == PPC::VCTSXS
            || MI->getOpcode() == PPC::VCTSXS_0
            || MI->getOpcode() == PPC::VCTUXS
            || MI->getOpcode() == PPC::VCTUXS_0
            || MI->getOpcode() == PPC::VEXPTEFP
            || MI->getOpcode() == PPC::VEXPTEFP
            || MI->getOpcode() == PPC::VLOGEFP
            || MI->getOpcode() == PPC::VMADDFP
            || MI->getOpcode() == PPC::VNMSUBFP
            || MI->getOpcode() == PPC::VREFP
            || MI->getOpcode() == PPC::VRFIM
            || MI->getOpcode() == PPC::VRFIN
            || MI->getOpcode() == PPC::VRFIP
            || MI->getOpcode() == PPC::VRFIZ
            || MI->getOpcode() == PPC::VRSQRTEFP
            || MI->getOpcode() == PPC::VSUBFP
            || MI->getOpcode() == PPC::XSADDDP
            || MI->getOpcode() == PPC::XSADDSP
            || MI->getOpcode() == PPC::XSCVDPHP
            || MI->getOpcode() == PPC::XSCVDPSP
            || MI->getOpcode() == PPC::XSCVDPSPN
            || MI->getOpcode() == PPC::XSCVDPSXDS
            || MI->getOpcode() == PPC::XSCVDPSXDSs
            || MI->getOpcode() == PPC::XSCVDPSXWS
            || MI->getOpcode() == PPC::XSCVDPSXWSs
            || MI->getOpcode() == PPC::XSCVDPUXDS
            || MI->getOpcode() == PPC::XSCVDPUXDSs
            || MI->getOpcode() == PPC::XSCVDPUXWS
            || MI->getOpcode() == PPC::XSCVDPUXWSs
            || MI->getOpcode() == PPC::XSCVSPDP
            || MI->getOpcode() == PPC::XSCVSXDDP
            || MI->getOpcode() == PPC::XSCVSXDSP
            || MI->getOpcode() == PPC::XSCVUXDDP
            || MI->getOpcode() == PPC::XSCVUXDSP
            || MI->getOpcode() == PPC::XSMADDADP
            || MI->getOpcode() == PPC::XSMADDASP
            || MI->getOpcode() == PPC::XSMADDMDP
            || MI->getOpcode() == PPC::XSMADDMSP
            || MI->getOpcode() == PPC::XSMSUBADP
            || MI->getOpcode() == PPC::XSMSUBASP
            || MI->getOpcode() == PPC::XSMSUBMDP
            || MI->getOpcode() == PPC::XSMSUBMSP
            || MI->getOpcode() == PPC::XSMULDP
            || MI->getOpcode() == PPC::XSMULSP
            || MI->getOpcode() == PPC::XSNMADDADP
            || MI->getOpcode() == PPC::XSNMADDASP
            || MI->getOpcode() == PPC::XSNMADDMDP
            || MI->getOpcode() == PPC::XSNMADDMSP
            || MI->getOpcode() == PPC::XSNMSUBADP
            || MI->getOpcode() == PPC::XSNMSUBASP
            || MI->getOpcode() == PPC::XSNMSUBMDP
            || MI->getOpcode() == PPC::XSNMSUBMSP
            || MI->getOpcode() == PPC::XSRDPI
            || MI->getOpcode() == PPC::XSRDPIC
            || MI->getOpcode() == PPC::XSRDPIM
            || MI->getOpcode() == PPC::XSRDPIP
            || MI->getOpcode() == PPC::XSRDPIZ
            || MI->getOpcode() == PPC::XSREDP
            || MI->getOpcode() == PPC::XSRESP
            || MI->getOpcode() == PPC::XSRSP
            || MI->getOpcode() == PPC::XSRSQRTEDP
            || MI->getOpcode() == PPC::XSRSQRTESP
            || MI->getOpcode() == PPC::XSSUBDP
            || MI->getOpcode() == PPC::XSSUBSP
            || MI->getOpcode() == PPC::XVADDDP
            || MI->getOpcode() == PPC::XVADDSP
            || MI->getOpcode() == PPC::XVCVDPSP
            || MI->getOpcode() == PPC::XVCVDPSXDS
            || MI->getOpcode() == PPC::XVCVDPSXWS
            || MI->getOpcode() == PPC::XVCVDPUXDS
            || MI->getOpcode() == PPC::XVCVDPUXWS
            || MI->getOpcode() == PPC::XVCVSPBF16
            || MI->getOpcode() == PPC::XVCVSPDP
            || MI->getOpcode() == PPC::XVCVSPHP
            || MI->getOpcode() == PPC::XVCVSPSXDS
            || MI->getOpcode() == PPC::XVCVSPSXWS
            || MI->getOpcode() == PPC::XVCVSPUXDS
            || MI->getOpcode() == PPC::XVCVSPUXWS
            || MI->getOpcode() == PPC::XVCVSXDDP
            || MI->getOpcode() == PPC::XVCVSXDSP
            || MI->getOpcode() == PPC::XVCVSXWDP
            || MI->getOpcode() == PPC::XVCVSXWSP
            || MI->getOpcode() == PPC::XVCVUXDDP
            || MI->getOpcode() == PPC::XVCVUXDSP
            || MI->getOpcode() == PPC::XVCVUXWDP
            || MI->getOpcode() == PPC::XVCVUXWSP
            || MI->getOpcode() == PPC::XVMADDADP
            || MI->getOpcode() == PPC::XVMADDASP
            || MI->getOpcode() == PPC::XVMADDMDP
            || MI->getOpcode() == PPC::XVMADDMSP
            || MI->getOpcode() == PPC::XVMSUBADP
            || MI->getOpcode() == PPC::XVMSUBASP
            || MI->getOpcode() == PPC::XVMSUBMDP
            || MI->getOpcode() == PPC::XVMSUBMSP
            || MI->getOpcode() == PPC::XVMULDP
            || MI->getOpcode() == PPC::XVMULSP
            || MI->getOpcode() == PPC::XVNMADDADP
            || MI->getOpcode() == PPC::XVNMADDASP
            || MI->getOpcode() == PPC::XVNMADDMDP
            || MI->getOpcode() == PPC::XVNMADDMSP
            || MI->getOpcode() == PPC::XVNMSUBADP
            || MI->getOpcode() == PPC::XVNMSUBASP
            || MI->getOpcode() == PPC::XVNMSUBMDP
            || MI->getOpcode() == PPC::XVNMSUBMSP
            || MI->getOpcode() == PPC::XVRDPI
            || MI->getOpcode() == PPC::XVRDPIC
            || MI->getOpcode() == PPC::XVRDPIM
            || MI->getOpcode() == PPC::XVRDPIP
            || MI->getOpcode() == PPC::XVRDPIZ
            || MI->getOpcode() == PPC::XVREDP
            || MI->getOpcode() == PPC::XVRESP
            || MI->getOpcode() == PPC::XVRSPI
            || MI->getOpcode() == PPC::XVRSPIC
            || MI->getOpcode() == PPC::XVRSPIM
            || MI->getOpcode() == PPC::XVRSPIP
            || MI->getOpcode() == PPC::XVRSPIZ
            || MI->getOpcode() == PPC::XVRSQRTEDP
            || MI->getOpcode() == PPC::XVRSQRTESP
            || MI->getOpcode() == PPC::XVSUBDP
            || MI->getOpcode() == PPC::XVSUBSP
          ))
        return 499; // P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_2C_P10BF_Read_2C_P10BF_Read_2C
      return 500; // P10W_BF_7C_P10W_DISP_ANY_P10BF_Read_1C_P10BF_Read_1C_P10BF_Read_1C
    }
    break;
  case 262: // FDIV
    if (CPUID == 11) { // P10Model
      if ((
            MI->getOpcode() == PPC::FADD
            || MI->getOpcode() == PPC::FADDS
            || MI->getOpcode() == PPC::FADDS_rec
            || MI->getOpcode() == PPC::FADD_rec
            || MI->getOpcode() == PPC::FCFID
            || MI->getOpcode() == PPC::FCFIDS
            || MI->getOpcode() == PPC::FCFIDS_rec
            || MI->getOpcode() == PPC::FCFIDU
            || MI->getOpcode() == PPC::FCFIDUS
            || MI->getOpcode() == PPC::FCFIDUS_rec
            || MI->getOpcode() == PPC::FCFIDU_rec
            || MI->getOpcode() == PPC::FCFID_rec
            || MI->getOpcode() == PPC::FCTID
            || MI->getOpcode() == PPC::FCTIDU
            || MI->getOpcode() == PPC::FCTIDUZ
            || MI->getOpcode() == PPC::FCTIDUZ_rec
            || MI->getOpcode() == PPC::FCTIDU_rec
            || MI->getOpcode() == PPC::FCTIDZ
            || MI->getOpcode() == PPC::FCTIDZ_rec
            || MI->getOpcode() == PPC::FCTID_rec
            || MI->getOpcode() == PPC::FCTIW
            || MI->getOpcode() == PPC::FCTIWU
            || MI->getOpcode() == PPC::FCTIWUZ
            || MI->getOpcode() == PPC::FCTIWUZ_rec
            || MI->getOpcode() == PPC::FCTIWU_rec
            || MI->getOpcode() == PPC::FCTIWZ
            || MI->getOpcode() == PPC::FCTIWZ_rec
            || MI->getOpcode() == PPC::FCTIW_rec
            || MI->getOpcode() == PPC::FMADD
            || MI->getOpcode() == PPC::FMADDS
            || MI->getOpcode() == PPC::FMADDS_rec
            || MI->getOpcode() == PPC::FMADD_rec
            || MI->getOpcode() == PPC::FMSUB
            || MI->getOpcode() == PPC::FMSUBS
            || MI->getOpcode() == PPC::FMSUBS_rec
            || MI->getOpcode() == PPC::FMSUB_rec
            || MI->getOpcode() == PPC::FMUL
            || MI->getOpcode() == PPC::FMULS
            || MI->getOpcode() == PPC::FMULS_rec
            || MI->getOpcode() == PPC::FMUL_rec
            || MI->getOpcode() == PPC::FNMADD
            || MI->getOpcode() == PPC::FNMADDS
            || MI->getOpcode() == PPC::FNMADDS_rec
            || MI->getOpcode() == PPC::FNMADD_rec
            || MI->getOpcode() == PPC::FNMSUB
            || MI->getOpcode() == PPC::FNMSUBS
            || MI->getOpcode() == PPC::FNMSUBS_rec
            || MI->getOpcode() == PPC::FNMSUB_rec
            || MI->getOpcode() == PPC::FRE
            || MI->getOpcode() == PPC::FRES
            || MI->getOpcode() == PPC::FRES_rec
            || MI->getOpcode() == PPC::FRE_rec
            || MI->getOpcode() == PPC::FRIMD
            || MI->getOpcode() == PPC::FRIMS
            || MI->getOpcode() == PPC::FRIMD_rec
            || MI->getOpcode() == PPC::FRIMS_rec
            || MI->getOpcode() == PPC::FRIND
            || MI->getOpcode() == PPC::FRINS
            || MI->getOpcode() == PPC::FRIND_rec
            || MI->getOpcode() == PPC::FRINS_rec
            || MI->getOpcode() == PPC::FRIPD
            || MI->getOpcode() == PPC::FRIPS
            || MI->getOpcode() == PPC::FRIPD_rec
            || MI->getOpcode() == PPC::FRIPS_rec
            || MI->getOpcode() == PPC::FRIZD
            || MI->getOpcode() == PPC::FRIZS
            || MI->getOpcode() == PPC::FRIZD_rec
            || MI->getOpcode() == PPC::FRIZS_rec
            || MI->getOpcode() == PPC::FRSP
            || MI->getOpcode() == PPC::FRSP_rec
            || MI->getOpcode() == PPC::FRSQRTE
            || MI->getOpcode() == PPC::FRSQRTES
            || MI->getOpcode() == PPC::FRSQRTES_rec
            || MI->getOpcode() == PPC::FRSQRTE_rec
            || MI->getOpcode() == PPC::FSELD
            || MI->getOpcode() == PPC::FSELS
            || MI->getOpcode() == PPC::FSELD_rec
            || MI->getOpcode() == PPC::FSELS_rec
            || MI->getOpcode() == PPC::FSUB
            || MI->getOpcode() == PPC::FSUBS
            || MI->getOpcode() == PPC::FSUBS_rec
            || MI->getOpcode() == PPC::FSUB_rec
            || MI->getOpcode() == PPC::VADDFP
            || MI->getOpcode() == PPC::VCFSX
            || MI->getOpcode() == PPC::VCFSX_0
            || MI->getOpcode() == PPC::VCFUX
            || MI->getOpcode() == PPC::VCFUX_0
            || MI->getOpcode() == PPC::VCTSXS
            || MI->getOpcode() == PPC::VCTSXS_0
            || MI->getOpcode() == PPC::VCTUXS
            || MI->getOpcode() == PPC::VCTUXS_0
            || MI->getOpcode() == PPC::VEXPTEFP
            || MI->getOpcode() == PPC::VEXPTEFP
            || MI->getOpcode() == PPC::VLOGEFP
            || MI->getOpcode() == PPC::VMADDFP
            || MI->getOpcode() == PPC::VNMSUBFP
            || MI->getOpcode() == PPC::VREFP
            || MI->getOpcode() == PPC::VRFIM
            || MI->getOpcode() == PPC::VRFIN
            || MI->getOpcode() == PPC::VRFIP
            || MI->getOpcode() == PPC::VRFIZ
            || MI->getOpcode() == PPC::VRSQRTEFP
            || MI->getOpcode() == PPC::VSUBFP
            || MI->getOpcode() == PPC::XSADDDP
            || MI->getOpcode() == PPC::XSADDSP
            || MI->getOpcode() == PPC::XSCVDPHP
            || MI->getOpcode() == PPC::XSCVDPSP
            || MI->getOpcode() == PPC::XSCVDPSPN
            || MI->getOpcode() == PPC::XSCVDPSXDS
            || MI->getOpcode() == PPC::XSCVDPSXDSs
            || MI->getOpcode() == PPC::XSCVDPSXWS
            || MI->getOpcode() == PPC::XSCVDPSXWSs
            || MI->getOpcode() == PPC::XSCVDPUXDS
            || MI->getOpcode() == PPC::XSCVDPUXDSs
            || MI->getOpcode() == PPC::XSCVDPUXWS
            || MI->getOpcode() == PPC::XSCVDPUXWSs
            || MI->getOpcode() == PPC::XSCVSPDP
            || MI->getOpcode() == PPC::XSCVSXDDP
            || MI->getOpcode() == PPC::XSCVSXDSP
            || MI->getOpcode() == PPC::XSCVUXDDP
            || MI->getOpcode() == PPC::XSCVUXDSP
            || MI->getOpcode() == PPC::XSMADDADP
            || MI->getOpcode() == PPC::XSMADDASP
            || MI->getOpcode() == PPC::XSMADDMDP
            || MI->getOpcode() == PPC::XSMADDMSP
            || MI->getOpcode() == PPC::XSMSUBADP
            || MI->getOpcode() == PPC::XSMSUBASP
            || MI->getOpcode() == PPC::XSMSUBMDP
            || MI->getOpcode() == PPC::XSMSUBMSP
            || MI->getOpcode() == PPC::XSMULDP
            || MI->getOpcode() == PPC::XSMULSP
            || MI->getOpcode() == PPC::XSNMADDADP
            || MI->getOpcode() == PPC::XSNMADDASP
            || MI->getOpcode() == PPC::XSNMADDMDP
            || MI->getOpcode() == PPC::XSNMADDMSP
            || MI->getOpcode() == PPC::XSNMSUBADP
            || MI->getOpcode() == PPC::XSNMSUBASP
            || MI->getOpcode() == PPC::XSNMSUBMDP
            || MI->getOpcode() == PPC::XSNMSUBMSP
            || MI->getOpcode() == PPC::XSRDPI
            || MI->getOpcode() == PPC::XSRDPIC
            || MI->getOpcode() == PPC::XSRDPIM
            || MI->getOpcode() == PPC::XSRDPIP
            || MI->getOpcode() == PPC::XSRDPIZ
            || MI->getOpcode() == PPC::XSREDP
            || MI->getOpcode() == PPC::XSRESP
            || MI->getOpcode() == PPC::XSRSP
            || MI->getOpcode() == PPC::XSRSQRTEDP
            || MI->getOpcode() == PPC::XSRSQRTESP
            || MI->getOpcode() == PPC::XSSUBDP
            || MI->getOpcode() == PPC::XSSUBSP
            || MI->getOpcode() == PPC::XVADDDP
            || MI->getOpcode() == PPC::XVADDSP
            || MI->getOpcode() == PPC::XVCVDPSP
            || MI->getOpcode() == PPC::XVCVDPSXDS
            || MI->getOpcode() == PPC::XVCVDPSXWS
            || MI->getOpcode() == PPC::XVCVDPUXDS
            || MI->getOpcode() == PPC::XVCVDPUXWS
            || MI->getOpcode() == PPC::XVCVSPBF16
            || MI->getOpcode() == PPC::XVCVSPDP
            || MI->getOpcode() == PPC::XVCVSPHP
            || MI->getOpcode() == PPC::XVCVSPSXDS
            || MI->getOpcode() == PPC::XVCVSPSXWS
            || MI->getOpcode() == PPC::XVCVSPUXDS
            || MI->getOpcode() == PPC::XVCVSPUXWS
            || MI->getOpcode() == PPC::XVCVSXDDP
            || MI->getOpcode() == PPC::XVCVSXDSP
            || MI->getOpcode() == PPC::XVCVSXWDP
            || MI->getOpcode() == PPC::XVCVSXWSP
            || MI->getOpcode() == PPC::XVCVUXDDP
            || MI->getOpcode() == PPC::XVCVUXDSP
            || MI->getOpcode() == PPC::XVCVUXWDP
            || MI->getOpcode() == PPC::XVCVUXWSP
            || MI->getOpcode() == PPC::XVMADDADP
            || MI->getOpcode() == PPC::XVMADDASP
            || MI->getOpcode() == PPC::XVMADDMDP
            || MI->getOpcode() == PPC::XVMADDMSP
            || MI->getOpcode() == PPC::XVMSUBADP
            || MI->getOpcode() == PPC::XVMSUBASP
            || MI->getOpcode() == PPC::XVMSUBMDP
            || MI->getOpcode() == PPC::XVMSUBMSP
            || MI->getOpcode() == PPC::XVMULDP
            || MI->getOpcode() == PPC::XVMULSP
            || MI->getOpcode() == PPC::XVNMADDADP
            || MI->getOpcode() == PPC::XVNMADDASP
            || MI->getOpcode() == PPC::XVNMADDMDP
            || MI->getOpcode() == PPC::XVNMADDMSP
            || MI->getOpcode() == PPC::XVNMSUBADP
            || MI->getOpcode() == PPC::XVNMSUBASP
            || MI->getOpcode() == PPC::XVNMSUBMDP
            || MI->getOpcode() == PPC::XVNMSUBMSP
            || MI->getOpcode() == PPC::XVRDPI
            || MI->getOpcode() == PPC::XVRDPIC
            || MI->getOpcode() == PPC::XVRDPIM
            || MI->getOpcode() == PPC::XVRDPIP
            || MI->getOpcode() == PPC::XVRDPIZ
            || MI->getOpcode() == PPC::XVREDP
            || MI->getOpcode() == PPC::XVRESP
            || MI->getOpcode() == PPC::XVRSPI
            || MI->getOpcode() == PPC::XVRSPIC
            || MI->getOpcode() == PPC::XVRSPIM
            || MI->getOpcode() == PPC::XVRSPIP
            || MI->getOpcode() == PPC::XVRSPIZ
            || MI->getOpcode() == PPC::XVRSQRTEDP
            || MI->getOpcode() == PPC::XVRSQRTESP
            || MI->getOpcode() == PPC::XVSUBDP
            || MI->getOpcode() == PPC::XVSUBSP
          ))
        return 503; // P10W_BF_27C_P10W_DISP_ANY_P10BF_Read_2C_P10BF_Read_2C
      return 504; // P10W_BF_27C_P10W_DISP_ANY_P10BF_Read_1C_P10BF_Read_1C
    }
    break;
  case 264: // XSSQRTDP
    if (CPUID == 11) { // P10Model
      if ((
            MI->getOpcode() == PPC::FADD
            || MI->getOpcode() == PPC::FADDS
            || MI->getOpcode() == PPC::FADDS_rec
            || MI->getOpcode() == PPC::FADD_rec
            || MI->getOpcode() == PPC::FCFID
            || MI->getOpcode() == PPC::FCFIDS
            || MI->getOpcode() == PPC::FCFIDS_rec
            || MI->getOpcode() == PPC::FCFIDU
            || MI->getOpcode() == PPC::FCFIDUS
            || MI->getOpcode() == PPC::FCFIDUS_rec
            || MI->getOpcode() == PPC::FCFIDU_rec
            || MI->getOpcode() == PPC::FCFID_rec
            || MI->getOpcode() == PPC::FCTID
            || MI->getOpcode() == PPC::FCTIDU
            || MI->getOpcode() == PPC::FCTIDUZ
            || MI->getOpcode() == PPC::FCTIDUZ_rec
            || MI->getOpcode() == PPC::FCTIDU_rec
            || MI->getOpcode() == PPC::FCTIDZ
            || MI->getOpcode() == PPC::FCTIDZ_rec
            || MI->getOpcode() == PPC::FCTID_rec
            || MI->getOpcode() == PPC::FCTIW
            || MI->getOpcode() == PPC::FCTIWU
            || MI->getOpcode() == PPC::FCTIWUZ
            || MI->getOpcode() == PPC::FCTIWUZ_rec
            || MI->getOpcode() == PPC::FCTIWU_rec
            || MI->getOpcode() == PPC::FCTIWZ
            || MI->getOpcode() == PPC::FCTIWZ_rec
            || MI->getOpcode() == PPC::FCTIW_rec
            || MI->getOpcode() == PPC::FMADD
            || MI->getOpcode() == PPC::FMADDS
            || MI->getOpcode() == PPC::FMADDS_rec
            || MI->getOpcode() == PPC::FMADD_rec
            || MI->getOpcode() == PPC::FMSUB
            || MI->getOpcode() == PPC::FMSUBS
            || MI->getOpcode() == PPC::FMSUBS_rec
            || MI->getOpcode() == PPC::FMSUB_rec
            || MI->getOpcode() == PPC::FMUL
            || MI->getOpcode() == PPC::FMULS
            || MI->getOpcode() == PPC::FMULS_rec
            || MI->getOpcode() == PPC::FMUL_rec
            || MI->getOpcode() == PPC::FNMADD
            || MI->getOpcode() == PPC::FNMADDS
            || MI->getOpcode() == PPC::FNMADDS_rec
            || MI->getOpcode() == PPC::FNMADD_rec
            || MI->getOpcode() == PPC::FNMSUB
            || MI->getOpcode() == PPC::FNMSUBS
            || MI->getOpcode() == PPC::FNMSUBS_rec
            || MI->getOpcode() == PPC::FNMSUB_rec
            || MI->getOpcode() == PPC::FRE
            || MI->getOpcode() == PPC::FRES
            || MI->getOpcode() == PPC::FRES_rec
            || MI->getOpcode() == PPC::FRE_rec
            || MI->getOpcode() == PPC::FRIMD
            || MI->getOpcode() == PPC::FRIMS
            || MI->getOpcode() == PPC::FRIMD_rec
            || MI->getOpcode() == PPC::FRIMS_rec
            || MI->getOpcode() == PPC::FRIND
            || MI->getOpcode() == PPC::FRINS
            || MI->getOpcode() == PPC::FRIND_rec
            || MI->getOpcode() == PPC::FRINS_rec
            || MI->getOpcode() == PPC::FRIPD
            || MI->getOpcode() == PPC::FRIPS
            || MI->getOpcode() == PPC::FRIPD_rec
            || MI->getOpcode() == PPC::FRIPS_rec
            || MI->getOpcode() == PPC::FRIZD
            || MI->getOpcode() == PPC::FRIZS
            || MI->getOpcode() == PPC::FRIZD_rec
            || MI->getOpcode() == PPC::FRIZS_rec
            || MI->getOpcode() == PPC::FRSP
            || MI->getOpcode() == PPC::FRSP_rec
            || MI->getOpcode() == PPC::FRSQRTE
            || MI->getOpcode() == PPC::FRSQRTES
            || MI->getOpcode() == PPC::FRSQRTES_rec
            || MI->getOpcode() == PPC::FRSQRTE_rec
            || MI->getOpcode() == PPC::FSELD
            || MI->getOpcode() == PPC::FSELS
            || MI->getOpcode() == PPC::FSELD_rec
            || MI->getOpcode() == PPC::FSELS_rec
            || MI->getOpcode() == PPC::FSUB
            || MI->getOpcode() == PPC::FSUBS
            || MI->getOpcode() == PPC::FSUBS_rec
            || MI->getOpcode() == PPC::FSUB_rec
            || MI->getOpcode() == PPC::VADDFP
            || MI->getOpcode() == PPC::VCFSX
            || MI->getOpcode() == PPC::VCFSX_0
            || MI->getOpcode() == PPC::VCFUX
            || MI->getOpcode() == PPC::VCFUX_0
            || MI->getOpcode() == PPC::VCTSXS
            || MI->getOpcode() == PPC::VCTSXS_0
            || MI->getOpcode() == PPC::VCTUXS
            || MI->getOpcode() == PPC::VCTUXS_0
            || MI->getOpcode() == PPC::VEXPTEFP
            || MI->getOpcode() == PPC::VEXPTEFP
            || MI->getOpcode() == PPC::VLOGEFP
            || MI->getOpcode() == PPC::VMADDFP
            || MI->getOpcode() == PPC::VNMSUBFP
            || MI->getOpcode() == PPC::VREFP
            || MI->getOpcode() == PPC::VRFIM
            || MI->getOpcode() == PPC::VRFIN
            || MI->getOpcode() == PPC::VRFIP
            || MI->getOpcode() == PPC::VRFIZ
            || MI->getOpcode() == PPC::VRSQRTEFP
            || MI->getOpcode() == PPC::VSUBFP
            || MI->getOpcode() == PPC::XSADDDP
            || MI->getOpcode() == PPC::XSADDSP
            || MI->getOpcode() == PPC::XSCVDPHP
            || MI->getOpcode() == PPC::XSCVDPSP
            || MI->getOpcode() == PPC::XSCVDPSPN
            || MI->getOpcode() == PPC::XSCVDPSXDS
            || MI->getOpcode() == PPC::XSCVDPSXDSs
            || MI->getOpcode() == PPC::XSCVDPSXWS
            || MI->getOpcode() == PPC::XSCVDPSXWSs
            || MI->getOpcode() == PPC::XSCVDPUXDS
            || MI->getOpcode() == PPC::XSCVDPUXDSs
            || MI->getOpcode() == PPC::XSCVDPUXWS
            || MI->getOpcode() == PPC::XSCVDPUXWSs
            || MI->getOpcode() == PPC::XSCVSPDP
            || MI->getOpcode() == PPC::XSCVSXDDP
            || MI->getOpcode() == PPC::XSCVSXDSP
            || MI->getOpcode() == PPC::XSCVUXDDP
            || MI->getOpcode() == PPC::XSCVUXDSP
            || MI->getOpcode() == PPC::XSMADDADP
            || MI->getOpcode() == PPC::XSMADDASP
            || MI->getOpcode() == PPC::XSMADDMDP
            || MI->getOpcode() == PPC::XSMADDMSP
            || MI->getOpcode() == PPC::XSMSUBADP
            || MI->getOpcode() == PPC::XSMSUBASP
            || MI->getOpcode() == PPC::XSMSUBMDP
            || MI->getOpcode() == PPC::XSMSUBMSP
            || MI->getOpcode() == PPC::XSMULDP
            || MI->getOpcode() == PPC::XSMULSP
            || MI->getOpcode() == PPC::XSNMADDADP
            || MI->getOpcode() == PPC::XSNMADDASP
            || MI->getOpcode() == PPC::XSNMADDMDP
            || MI->getOpcode() == PPC::XSNMADDMSP
            || MI->getOpcode() == PPC::XSNMSUBADP
            || MI->getOpcode() == PPC::XSNMSUBASP
            || MI->getOpcode() == PPC::XSNMSUBMDP
            || MI->getOpcode() == PPC::XSNMSUBMSP
            || MI->getOpcode() == PPC::XSRDPI
            || MI->getOpcode() == PPC::XSRDPIC
            || MI->getOpcode() == PPC::XSRDPIM
            || MI->getOpcode() == PPC::XSRDPIP
            || MI->getOpcode() == PPC::XSRDPIZ
            || MI->getOpcode() == PPC::XSREDP
            || MI->getOpcode() == PPC::XSRESP
            || MI->getOpcode() == PPC::XSRSP
            || MI->getOpcode() == PPC::XSRSQRTEDP
            || MI->getOpcode() == PPC::XSRSQRTESP
            || MI->getOpcode() == PPC::XSSUBDP
            || MI->getOpcode() == PPC::XSSUBSP
            || MI->getOpcode() == PPC::XVADDDP
            || MI->getOpcode() == PPC::XVADDSP
            || MI->getOpcode() == PPC::XVCVDPSP
            || MI->getOpcode() == PPC::XVCVDPSXDS
            || MI->getOpcode() == PPC::XVCVDPSXWS
            || MI->getOpcode() == PPC::XVCVDPUXDS
            || MI->getOpcode() == PPC::XVCVDPUXWS
            || MI->getOpcode() == PPC::XVCVSPBF16
            || MI->getOpcode() == PPC::XVCVSPDP
            || MI->getOpcode() == PPC::XVCVSPHP
            || MI->getOpcode() == PPC::XVCVSPSXDS
            || MI->getOpcode() == PPC::XVCVSPSXWS
            || MI->getOpcode() == PPC::XVCVSPUXDS
            || MI->getOpcode() == PPC::XVCVSPUXWS
            || MI->getOpcode() == PPC::XVCVSXDDP
            || MI->getOpcode() == PPC::XVCVSXDSP
            || MI->getOpcode() == PPC::XVCVSXWDP
            || MI->getOpcode() == PPC::XVCVSXWSP
            || MI->getOpcode() == PPC::XVCVUXDDP
            || MI->getOpcode() == PPC::XVCVUXDSP
            || MI->getOpcode() == PPC::XVCVUXWDP
            || MI->getOpcode() == PPC::XVCVUXWSP
            || MI->getOpcode() == PPC::XVMADDADP
            || MI->getOpcode() == PPC::XVMADDASP
            || MI->getOpcode() == PPC::XVMADDMDP
            || MI->getOpcode() == PPC::XVMADDMSP
            || MI->getOpcode() == PPC::XVMSUBADP
            || MI->getOpcode() == PPC::XVMSUBASP
            || MI->getOpcode() == PPC::XVMSUBMDP
            || MI->getOpcode() == PPC::XVMSUBMSP
            || MI->getOpcode() == PPC::XVMULDP
            || MI->getOpcode() == PPC::XVMULSP
            || MI->getOpcode() == PPC::XVNMADDADP
            || MI->getOpcode() == PPC::XVNMADDASP
            || MI->getOpcode() == PPC::XVNMADDMDP
            || MI->getOpcode() == PPC::XVNMADDMSP
            || MI->getOpcode() == PPC::XVNMSUBADP
            || MI->getOpcode() == PPC::XVNMSUBASP
            || MI->getOpcode() == PPC::XVNMSUBMDP
            || MI->getOpcode() == PPC::XVNMSUBMSP
            || MI->getOpcode() == PPC::XVRDPI
            || MI->getOpcode() == PPC::XVRDPIC
            || MI->getOpcode() == PPC::XVRDPIM
            || MI->getOpcode() == PPC::XVRDPIP
            || MI->getOpcode() == PPC::XVRDPIZ
            || MI->getOpcode() == PPC::XVREDP
            || MI->getOpcode() == PPC::XVRESP
            || MI->getOpcode() == PPC::XVRSPI
            || MI->getOpcode() == PPC::XVRSPIC
            || MI->getOpcode() == PPC::XVRSPIM
            || MI->getOpcode() == PPC::XVRSPIP
            || MI->getOpcode() == PPC::XVRSPIZ
            || MI->getOpcode() == PPC::XVRSQRTEDP
            || MI->getOpcode() == PPC::XVRSQRTESP
            || MI->getOpcode() == PPC::XVSUBDP
            || MI->getOpcode() == PPC::XVSUBSP
          ))
        return 505; // P10W_BF_36C_P10W_DISP_ANY_P10BF_Read_2C
      return 506; // P10W_BF_36C_P10W_DISP_ANY_P10BF_Read_1C
    }
    break;
  case 265: // FSQRT
    if (CPUID == 11) { // P10Model
      if ((
            MI->getOpcode() == PPC::FADD
            || MI->getOpcode() == PPC::FADDS
            || MI->getOpcode() == PPC::FADDS_rec
            || MI->getOpcode() == PPC::FADD_rec
            || MI->getOpcode() == PPC::FCFID
            || MI->getOpcode() == PPC::FCFIDS
            || MI->getOpcode() == PPC::FCFIDS_rec
            || MI->getOpcode() == PPC::FCFIDU
            || MI->getOpcode() == PPC::FCFIDUS
            || MI->getOpcode() == PPC::FCFIDUS_rec
            || MI->getOpcode() == PPC::FCFIDU_rec
            || MI->getOpcode() == PPC::FCFID_rec
            || MI->getOpcode() == PPC::FCTID
            || MI->getOpcode() == PPC::FCTIDU
            || MI->getOpcode() == PPC::FCTIDUZ
            || MI->getOpcode() == PPC::FCTIDUZ_rec
            || MI->getOpcode() == PPC::FCTIDU_rec
            || MI->getOpcode() == PPC::FCTIDZ
            || MI->getOpcode() == PPC::FCTIDZ_rec
            || MI->getOpcode() == PPC::FCTID_rec
            || MI->getOpcode() == PPC::FCTIW
            || MI->getOpcode() == PPC::FCTIWU
            || MI->getOpcode() == PPC::FCTIWUZ
            || MI->getOpcode() == PPC::FCTIWUZ_rec
            || MI->getOpcode() == PPC::FCTIWU_rec
            || MI->getOpcode() == PPC::FCTIWZ
            || MI->getOpcode() == PPC::FCTIWZ_rec
            || MI->getOpcode() == PPC::FCTIW_rec
            || MI->getOpcode() == PPC::FMADD
            || MI->getOpcode() == PPC::FMADDS
            || MI->getOpcode() == PPC::FMADDS_rec
            || MI->getOpcode() == PPC::FMADD_rec
            || MI->getOpcode() == PPC::FMSUB
            || MI->getOpcode() == PPC::FMSUBS
            || MI->getOpcode() == PPC::FMSUBS_rec
            || MI->getOpcode() == PPC::FMSUB_rec
            || MI->getOpcode() == PPC::FMUL
            || MI->getOpcode() == PPC::FMULS
            || MI->getOpcode() == PPC::FMULS_rec
            || MI->getOpcode() == PPC::FMUL_rec
            || MI->getOpcode() == PPC::FNMADD
            || MI->getOpcode() == PPC::FNMADDS
            || MI->getOpcode() == PPC::FNMADDS_rec
            || MI->getOpcode() == PPC::FNMADD_rec
            || MI->getOpcode() == PPC::FNMSUB
            || MI->getOpcode() == PPC::FNMSUBS
            || MI->getOpcode() == PPC::FNMSUBS_rec
            || MI->getOpcode() == PPC::FNMSUB_rec
            || MI->getOpcode() == PPC::FRE
            || MI->getOpcode() == PPC::FRES
            || MI->getOpcode() == PPC::FRES_rec
            || MI->getOpcode() == PPC::FRE_rec
            || MI->getOpcode() == PPC::FRIMD
            || MI->getOpcode() == PPC::FRIMS
            || MI->getOpcode() == PPC::FRIMD_rec
            || MI->getOpcode() == PPC::FRIMS_rec
            || MI->getOpcode() == PPC::FRIND
            || MI->getOpcode() == PPC::FRINS
            || MI->getOpcode() == PPC::FRIND_rec
            || MI->getOpcode() == PPC::FRINS_rec
            || MI->getOpcode() == PPC::FRIPD
            || MI->getOpcode() == PPC::FRIPS
            || MI->getOpcode() == PPC::FRIPD_rec
            || MI->getOpcode() == PPC::FRIPS_rec
            || MI->getOpcode() == PPC::FRIZD
            || MI->getOpcode() == PPC::FRIZS
            || MI->getOpcode() == PPC::FRIZD_rec
            || MI->getOpcode() == PPC::FRIZS_rec
            || MI->getOpcode() == PPC::FRSP
            || MI->getOpcode() == PPC::FRSP_rec
            || MI->getOpcode() == PPC::FRSQRTE
            || MI->getOpcode() == PPC::FRSQRTES
            || MI->getOpcode() == PPC::FRSQRTES_rec
            || MI->getOpcode() == PPC::FRSQRTE_rec
            || MI->getOpcode() == PPC::FSELD
            || MI->getOpcode() == PPC::FSELS
            || MI->getOpcode() == PPC::FSELD_rec
            || MI->getOpcode() == PPC::FSELS_rec
            || MI->getOpcode() == PPC::FSUB
            || MI->getOpcode() == PPC::FSUBS
            || MI->getOpcode() == PPC::FSUBS_rec
            || MI->getOpcode() == PPC::FSUB_rec
            || MI->getOpcode() == PPC::VADDFP
            || MI->getOpcode() == PPC::VCFSX
            || MI->getOpcode() == PPC::VCFSX_0
            || MI->getOpcode() == PPC::VCFUX
            || MI->getOpcode() == PPC::VCFUX_0
            || MI->getOpcode() == PPC::VCTSXS
            || MI->getOpcode() == PPC::VCTSXS_0
            || MI->getOpcode() == PPC::VCTUXS
            || MI->getOpcode() == PPC::VCTUXS_0
            || MI->getOpcode() == PPC::VEXPTEFP
            || MI->getOpcode() == PPC::VEXPTEFP
            || MI->getOpcode() == PPC::VLOGEFP
            || MI->getOpcode() == PPC::VMADDFP
            || MI->getOpcode() == PPC::VNMSUBFP
            || MI->getOpcode() == PPC::VREFP
            || MI->getOpcode() == PPC::VRFIM
            || MI->getOpcode() == PPC::VRFIN
            || MI->getOpcode() == PPC::VRFIP
            || MI->getOpcode() == PPC::VRFIZ
            || MI->getOpcode() == PPC::VRSQRTEFP
            || MI->getOpcode() == PPC::VSUBFP
            || MI->getOpcode() == PPC::XSADDDP
            || MI->getOpcode() == PPC::XSADDSP
            || MI->getOpcode() == PPC::XSCVDPHP
            || MI->getOpcode() == PPC::XSCVDPSP
            || MI->getOpcode() == PPC::XSCVDPSPN
            || MI->getOpcode() == PPC::XSCVDPSXDS
            || MI->getOpcode() == PPC::XSCVDPSXDSs
            || MI->getOpcode() == PPC::XSCVDPSXWS
            || MI->getOpcode() == PPC::XSCVDPSXWSs
            || MI->getOpcode() == PPC::XSCVDPUXDS
            || MI->getOpcode() == PPC::XSCVDPUXDSs
            || MI->getOpcode() == PPC::XSCVDPUXWS
            || MI->getOpcode() == PPC::XSCVDPUXWSs
            || MI->getOpcode() == PPC::XSCVSPDP
            || MI->getOpcode() == PPC::XSCVSXDDP
            || MI->getOpcode() == PPC::XSCVSXDSP
            || MI->getOpcode() == PPC::XSCVUXDDP
            || MI->getOpcode() == PPC::XSCVUXDSP
            || MI->getOpcode() == PPC::XSMADDADP
            || MI->getOpcode() == PPC::XSMADDASP
            || MI->getOpcode() == PPC::XSMADDMDP
            || MI->getOpcode() == PPC::XSMADDMSP
            || MI->getOpcode() == PPC::XSMSUBADP
            || MI->getOpcode() == PPC::XSMSUBASP
            || MI->getOpcode() == PPC::XSMSUBMDP
            || MI->getOpcode() == PPC::XSMSUBMSP
            || MI->getOpcode() == PPC::XSMULDP
            || MI->getOpcode() == PPC::XSMULSP
            || MI->getOpcode() == PPC::XSNMADDADP
            || MI->getOpcode() == PPC::XSNMADDASP
            || MI->getOpcode() == PPC::XSNMADDMDP
            || MI->getOpcode() == PPC::XSNMADDMSP
            || MI->getOpcode() == PPC::XSNMSUBADP
            || MI->getOpcode() == PPC::XSNMSUBASP
            || MI->getOpcode() == PPC::XSNMSUBMDP
            || MI->getOpcode() == PPC::XSNMSUBMSP
            || MI->getOpcode() == PPC::XSRDPI
            || MI->getOpcode() == PPC::XSRDPIC
            || MI->getOpcode() == PPC::XSRDPIM
            || MI->getOpcode() == PPC::XSRDPIP
            || MI->getOpcode() == PPC::XSRDPIZ
            || MI->getOpcode() == PPC::XSREDP
            || MI->getOpcode() == PPC::XSRESP
            || MI->getOpcode() == PPC::XSRSP
            || MI->getOpcode() == PPC::XSRSQRTEDP
            || MI->getOpcode() == PPC::XSRSQRTESP
            || MI->getOpcode() == PPC::XSSUBDP
            || MI->getOpcode() == PPC::XSSUBSP
            || MI->getOpcode() == PPC::XVADDDP
            || MI->getOpcode() == PPC::XVADDSP
            || MI->getOpcode() == PPC::XVCVDPSP
            || MI->getOpcode() == PPC::XVCVDPSXDS
            || MI->getOpcode() == PPC::XVCVDPSXWS
            || MI->getOpcode() == PPC::XVCVDPUXDS
            || MI->getOpcode() == PPC::XVCVDPUXWS
            || MI->getOpcode() == PPC::XVCVSPBF16
            || MI->getOpcode() == PPC::XVCVSPDP
            || MI->getOpcode() == PPC::XVCVSPHP
            || MI->getOpcode() == PPC::XVCVSPSXDS
            || MI->getOpcode() == PPC::XVCVSPSXWS
            || MI->getOpcode() == PPC::XVCVSPUXDS
            || MI->getOpcode() == PPC::XVCVSPUXWS
            || MI->getOpcode() == PPC::XVCVSXDDP
            || MI->getOpcode() == PPC::XVCVSXDSP
            || MI->getOpcode() == PPC::XVCVSXWDP
            || MI->getOpcode() == PPC::XVCVSXWSP
            || MI->getOpcode() == PPC::XVCVUXDDP
            || MI->getOpcode() == PPC::XVCVUXDSP
            || MI->getOpcode() == PPC::XVCVUXWDP
            || MI->getOpcode() == PPC::XVCVUXWSP
            || MI->getOpcode() == PPC::XVMADDADP
            || MI->getOpcode() == PPC::XVMADDASP
            || MI->getOpcode() == PPC::XVMADDMDP
            || MI->getOpcode() == PPC::XVMADDMSP
            || MI->getOpcode() == PPC::XVMSUBADP
            || MI->getOpcode() == PPC::XVMSUBASP
            || MI->getOpcode() == PPC::XVMSUBMDP
            || MI->getOpcode() == PPC::XVMSUBMSP
            || MI->getOpcode() == PPC::XVMULDP
            || MI->getOpcode() == PPC::XVMULSP
            || MI->getOpcode() == PPC::XVNMADDADP
            || MI->getOpcode() == PPC::XVNMADDASP
            || MI->getOpcode() == PPC::XVNMADDMDP
            || MI->getOpcode() == PPC::XVNMADDMSP
            || MI->getOpcode() == PPC::XVNMSUBADP
            || MI->getOpcode() == PPC::XVNMSUBASP
            || MI->getOpcode() == PPC::XVNMSUBMDP
            || MI->getOpcode() == PPC::XVNMSUBMSP
            || MI->getOpcode() == PPC::XVRDPI
            || MI->getOpcode() == PPC::XVRDPIC
            || MI->getOpcode() == PPC::XVRDPIM
            || MI->getOpcode() == PPC::XVRDPIP
            || MI->getOpcode() == PPC::XVRDPIZ
            || MI->getOpcode() == PPC::XVREDP
            || MI->getOpcode() == PPC::XVRESP
            || MI->getOpcode() == PPC::XVRSPI
            || MI->getOpcode() == PPC::XVRSPIC
            || MI->getOpcode() == PPC::XVRSPIM
            || MI->getOpcode() == PPC::XVRSPIP
            || MI->getOpcode() == PPC::XVRSPIZ
            || MI->getOpcode() == PPC::XVRSQRTEDP
            || MI->getOpcode() == PPC::XVRSQRTESP
            || MI->getOpcode() == PPC::XVSUBDP
            || MI->getOpcode() == PPC::XVSUBSP
          ))
        return 505; // P10W_BF_36C_P10W_DISP_ANY_P10BF_Read_2C
      return 506; // P10W_BF_36C_P10W_DISP_ANY_P10BF_Read_1C
    }
    break;
  case 266: // XVSQRTDP
    if (CPUID == 11) { // P10Model
      if ((
            MI->getOpcode() == PPC::FADD
            || MI->getOpcode() == PPC::FADDS
            || MI->getOpcode() == PPC::FADDS_rec
            || MI->getOpcode() == PPC::FADD_rec
            || MI->getOpcode() == PPC::FCFID
            || MI->getOpcode() == PPC::FCFIDS
            || MI->getOpcode() == PPC::FCFIDS_rec
            || MI->getOpcode() == PPC::FCFIDU
            || MI->getOpcode() == PPC::FCFIDUS
            || MI->getOpcode() == PPC::FCFIDUS_rec
            || MI->getOpcode() == PPC::FCFIDU_rec
            || MI->getOpcode() == PPC::FCFID_rec
            || MI->getOpcode() == PPC::FCTID
            || MI->getOpcode() == PPC::FCTIDU
            || MI->getOpcode() == PPC::FCTIDUZ
            || MI->getOpcode() == PPC::FCTIDUZ_rec
            || MI->getOpcode() == PPC::FCTIDU_rec
            || MI->getOpcode() == PPC::FCTIDZ
            || MI->getOpcode() == PPC::FCTIDZ_rec
            || MI->getOpcode() == PPC::FCTID_rec
            || MI->getOpcode() == PPC::FCTIW
            || MI->getOpcode() == PPC::FCTIWU
            || MI->getOpcode() == PPC::FCTIWUZ
            || MI->getOpcode() == PPC::FCTIWUZ_rec
            || MI->getOpcode() == PPC::FCTIWU_rec
            || MI->getOpcode() == PPC::FCTIWZ
            || MI->getOpcode() == PPC::FCTIWZ_rec
            || MI->getOpcode() == PPC::FCTIW_rec
            || MI->getOpcode() == PPC::FMADD
            || MI->getOpcode() == PPC::FMADDS
            || MI->getOpcode() == PPC::FMADDS_rec
            || MI->getOpcode() == PPC::FMADD_rec
            || MI->getOpcode() == PPC::FMSUB
            || MI->getOpcode() == PPC::FMSUBS
            || MI->getOpcode() == PPC::FMSUBS_rec
            || MI->getOpcode() == PPC::FMSUB_rec
            || MI->getOpcode() == PPC::FMUL
            || MI->getOpcode() == PPC::FMULS
            || MI->getOpcode() == PPC::FMULS_rec
            || MI->getOpcode() == PPC::FMUL_rec
            || MI->getOpcode() == PPC::FNMADD
            || MI->getOpcode() == PPC::FNMADDS
            || MI->getOpcode() == PPC::FNMADDS_rec
            || MI->getOpcode() == PPC::FNMADD_rec
            || MI->getOpcode() == PPC::FNMSUB
            || MI->getOpcode() == PPC::FNMSUBS
            || MI->getOpcode() == PPC::FNMSUBS_rec
            || MI->getOpcode() == PPC::FNMSUB_rec
            || MI->getOpcode() == PPC::FRE
            || MI->getOpcode() == PPC::FRES
            || MI->getOpcode() == PPC::FRES_rec
            || MI->getOpcode() == PPC::FRE_rec
            || MI->getOpcode() == PPC::FRIMD
            || MI->getOpcode() == PPC::FRIMS
            || MI->getOpcode() == PPC::FRIMD_rec
            || MI->getOpcode() == PPC::FRIMS_rec
            || MI->getOpcode() == PPC::FRIND
            || MI->getOpcode() == PPC::FRINS
            || MI->getOpcode() == PPC::FRIND_rec
            || MI->getOpcode() == PPC::FRINS_rec
            || MI->getOpcode() == PPC::FRIPD
            || MI->getOpcode() == PPC::FRIPS
            || MI->getOpcode() == PPC::FRIPD_rec
            || MI->getOpcode() == PPC::FRIPS_rec
            || MI->getOpcode() == PPC::FRIZD
            || MI->getOpcode() == PPC::FRIZS
            || MI->getOpcode() == PPC::FRIZD_rec
            || MI->getOpcode() == PPC::FRIZS_rec
            || MI->getOpcode() == PPC::FRSP
            || MI->getOpcode() == PPC::FRSP_rec
            || MI->getOpcode() == PPC::FRSQRTE
            || MI->getOpcode() == PPC::FRSQRTES
            || MI->getOpcode() == PPC::FRSQRTES_rec
            || MI->getOpcode() == PPC::FRSQRTE_rec
            || MI->getOpcode() == PPC::FSELD
            || MI->getOpcode() == PPC::FSELS
            || MI->getOpcode() == PPC::FSELD_rec
            || MI->getOpcode() == PPC::FSELS_rec
            || MI->getOpcode() == PPC::FSUB
            || MI->getOpcode() == PPC::FSUBS
            || MI->getOpcode() == PPC::FSUBS_rec
            || MI->getOpcode() == PPC::FSUB_rec
            || MI->getOpcode() == PPC::VADDFP
            || MI->getOpcode() == PPC::VCFSX
            || MI->getOpcode() == PPC::VCFSX_0
            || MI->getOpcode() == PPC::VCFUX
            || MI->getOpcode() == PPC::VCFUX_0
            || MI->getOpcode() == PPC::VCTSXS
            || MI->getOpcode() == PPC::VCTSXS_0
            || MI->getOpcode() == PPC::VCTUXS
            || MI->getOpcode() == PPC::VCTUXS_0
            || MI->getOpcode() == PPC::VEXPTEFP
            || MI->getOpcode() == PPC::VEXPTEFP
            || MI->getOpcode() == PPC::VLOGEFP
            || MI->getOpcode() == PPC::VMADDFP
            || MI->getOpcode() == PPC::VNMSUBFP
            || MI->getOpcode() == PPC::VREFP
            || MI->getOpcode() == PPC::VRFIM
            || MI->getOpcode() == PPC::VRFIN
            || MI->getOpcode() == PPC::VRFIP
            || MI->getOpcode() == PPC::VRFIZ
            || MI->getOpcode() == PPC::VRSQRTEFP
            || MI->getOpcode() == PPC::VSUBFP
            || MI->getOpcode() == PPC::XSADDDP
            || MI->getOpcode() == PPC::XSADDSP
            || MI->getOpcode() == PPC::XSCVDPHP
            || MI->getOpcode() == PPC::XSCVDPSP
            || MI->getOpcode() == PPC::XSCVDPSPN
            || MI->getOpcode() == PPC::XSCVDPSXDS
            || MI->getOpcode() == PPC::XSCVDPSXDSs
            || MI->getOpcode() == PPC::XSCVDPSXWS
            || MI->getOpcode() == PPC::XSCVDPSXWSs
            || MI->getOpcode() == PPC::XSCVDPUXDS
            || MI->getOpcode() == PPC::XSCVDPUXDSs
            || MI->getOpcode() == PPC::XSCVDPUXWS
            || MI->getOpcode() == PPC::XSCVDPUXWSs
            || MI->getOpcode() == PPC::XSCVSPDP
            || MI->getOpcode() == PPC::XSCVSXDDP
            || MI->getOpcode() == PPC::XSCVSXDSP
            || MI->getOpcode() == PPC::XSCVUXDDP
            || MI->getOpcode() == PPC::XSCVUXDSP
            || MI->getOpcode() == PPC::XSMADDADP
            || MI->getOpcode() == PPC::XSMADDASP
            || MI->getOpcode() == PPC::XSMADDMDP
            || MI->getOpcode() == PPC::XSMADDMSP
            || MI->getOpcode() == PPC::XSMSUBADP
            || MI->getOpcode() == PPC::XSMSUBASP
            || MI->getOpcode() == PPC::XSMSUBMDP
            || MI->getOpcode() == PPC::XSMSUBMSP
            || MI->getOpcode() == PPC::XSMULDP
            || MI->getOpcode() == PPC::XSMULSP
   