/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Assembly Writer Source Fragment                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

/// getMnemonic - This method is automatically generated by tablegen
/// from the instruction set description.
std::pair<const char *, uint64_t> MSP430InstPrinter::getMnemonic(const MCInst *MI) {

#ifdef __GNUC__
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Woverlength-strings"
#endif
  static const char AsmStrs[] = {
  /* 0 */ "rra\t\0"
  /* 5 */ "rra.b\t\0"
  /* 12 */ "sub.b\t\0"
  /* 19 */ "subc.b\t\0"
  /* 27 */ "addc.b\t\0"
  /* 35 */ "bic.b\t\0"
  /* 42 */ "rrc.b\t\0"
  /* 49 */ "dadd.b\t\0"
  /* 57 */ "and.b\t\0"
  /* 64 */ "push.b\t\0"
  /* 72 */ "cmp.b\t\0"
  /* 79 */ "xor.b\t\0"
  /* 86 */ "bis.b\t\0"
  /* 93 */ "bit.b\t\0"
  /* 100 */ "mov.b\t\0"
  /* 107 */ "swpb\t\0"
  /* 113 */ "sub\t\0"
  /* 118 */ "subc\t\0"
  /* 124 */ "addc\t\0"
  /* 130 */ "bic\t\0"
  /* 135 */ "rrc\t\0"
  /* 140 */ "dadd\t\0"
  /* 146 */ "and\t\0"
  /* 151 */ "push\t\0"
  /* 157 */ "call\t\0"
  /* 163 */ "cmp\t\0"
  /* 168 */ "jmp\t\0"
  /* 173 */ "pop\t\0"
  /* 178 */ "br\t\0"
  /* 182 */ "xor\t\0"
  /* 187 */ "bis\t\0"
  /* 192 */ "bit\t\0"
  /* 197 */ "sxt\t\0"
  /* 202 */ "mov\t\0"
  /* 207 */ "#ADJCALLSTACKDOWN \0"
  /* 226 */ "#ADJCALLSTACKUP \0"
  /* 243 */ "# XRay Function Patchable RET.\0"
  /* 274 */ "# XRay Typed Event Log.\0"
  /* 298 */ "# XRay Custom Event Log.\0"
  /* 323 */ "# XRay Function Enter.\0"
  /* 346 */ "# XRay Tail Call Exit.\0"
  /* 369 */ "# XRay Function Exit.\0"
  /* 391 */ "LIFETIME_END\0"
  /* 404 */ "PSEUDO_PROBE\0"
  /* 417 */ "BUNDLE\0"
  /* 424 */ "DBG_VALUE\0"
  /* 434 */ "DBG_INSTR_REF\0"
  /* 448 */ "DBG_PHI\0"
  /* 456 */ "DBG_LABEL\0"
  /* 466 */ "# Sra16 PSEUDO\0"
  /* 481 */ "# Shl16 PSEUDO\0"
  /* 496 */ "# Srl16 PSEUDO\0"
  /* 511 */ "# Select16 PSEUDO\0"
  /* 529 */ "# Sra8 PSEUDO\0"
  /* 543 */ "# Shl8 PSEUDO\0"
  /* 557 */ "# Srl8 PSEUDO\0"
  /* 571 */ "# Select8 PSEUDO\0"
  /* 588 */ "# ADDframe PSEUDO\0"
  /* 606 */ "LIFETIME_START\0"
  /* 621 */ "DBG_VALUE_LIST\0"
  /* 636 */ "reti\0"
  /* 641 */ "j\0"
  /* 643 */ "# FEntry call\0"
  /* 657 */ "ret\0"
};
#ifdef __GNUC__
#pragma GCC diagnostic pop
#endif

  static const uint16_t OpInfo0[] = {
    0U,	// PHI
    0U,	// INLINEASM
    0U,	// INLINEASM_BR
    0U,	// CFI_INSTRUCTION
    0U,	// EH_LABEL
    0U,	// GC_LABEL
    0U,	// ANNOTATION_LABEL
    0U,	// KILL
    0U,	// EXTRACT_SUBREG
    0U,	// INSERT_SUBREG
    0U,	// IMPLICIT_DEF
    0U,	// SUBREG_TO_REG
    0U,	// COPY_TO_REGCLASS
    425U,	// DBG_VALUE
    622U,	// DBG_VALUE_LIST
    435U,	// DBG_INSTR_REF
    449U,	// DBG_PHI
    457U,	// DBG_LABEL
    0U,	// REG_SEQUENCE
    0U,	// COPY
    418U,	// BUNDLE
    607U,	// LIFETIME_START
    392U,	// LIFETIME_END
    405U,	// PSEUDO_PROBE
    0U,	// ARITH_FENCE
    0U,	// STACKMAP
    644U,	// FENTRY_CALL
    0U,	// PATCHPOINT
    0U,	// LOAD_STACK_GUARD
    0U,	// PREALLOCATED_SETUP
    0U,	// PREALLOCATED_ARG
    0U,	// STATEPOINT
    0U,	// LOCAL_ESCAPE
    0U,	// FAULTING_OP
    0U,	// PATCHABLE_OP
    324U,	// PATCHABLE_FUNCTION_ENTER
    244U,	// PATCHABLE_RET
    370U,	// PATCHABLE_FUNCTION_EXIT
    347U,	// PATCHABLE_TAIL_CALL
    299U,	// PATCHABLE_EVENT_CALL
    275U,	// PATCHABLE_TYPED_EVENT_CALL
    0U,	// ICALL_BRANCH_FUNNEL
    0U,	// G_ASSERT_SEXT
    0U,	// G_ASSERT_ZEXT
    0U,	// G_ASSERT_ALIGN
    0U,	// G_ADD
    0U,	// G_SUB
    0U,	// G_MUL
    0U,	// G_SDIV
    0U,	// G_UDIV
    0U,	// G_SREM
    0U,	// G_UREM
    0U,	// G_SDIVREM
    0U,	// G_UDIVREM
    0U,	// G_AND
    0U,	// G_OR
    0U,	// G_XOR
    0U,	// G_IMPLICIT_DEF
    0U,	// G_PHI
    0U,	// G_FRAME_INDEX
    0U,	// G_GLOBAL_VALUE
    0U,	// G_EXTRACT
    0U,	// G_UNMERGE_VALUES
    0U,	// G_INSERT
    0U,	// G_MERGE_VALUES
    0U,	// G_BUILD_VECTOR
    0U,	// G_BUILD_VECTOR_TRUNC
    0U,	// G_CONCAT_VECTORS
    0U,	// G_PTRTOINT
    0U,	// G_INTTOPTR
    0U,	// G_BITCAST
    0U,	// G_FREEZE
    0U,	// G_INTRINSIC_TRUNC
    0U,	// G_INTRINSIC_ROUND
    0U,	// G_INTRINSIC_LRINT
    0U,	// G_INTRINSIC_ROUNDEVEN
    0U,	// G_READCYCLECOUNTER
    0U,	// G_LOAD
    0U,	// G_SEXTLOAD
    0U,	// G_ZEXTLOAD
    0U,	// G_INDEXED_LOAD
    0U,	// G_INDEXED_SEXTLOAD
    0U,	// G_INDEXED_ZEXTLOAD
    0U,	// G_STORE
    0U,	// G_INDEXED_STORE
    0U,	// G_ATOMIC_CMPXCHG_WITH_SUCCESS
    0U,	// G_ATOMIC_CMPXCHG
    0U,	// G_ATOMICRMW_XCHG
    0U,	// G_ATOMICRMW_ADD
    0U,	// G_ATOMICRMW_SUB
    0U,	// G_ATOMICRMW_AND
    0U,	// G_ATOMICRMW_NAND
    0U,	// G_ATOMICRMW_OR
    0U,	// G_ATOMICRMW_XOR
    0U,	// G_ATOMICRMW_MAX
    0U,	// G_ATOMICRMW_MIN
    0U,	// G_ATOMICRMW_UMAX
    0U,	// G_ATOMICRMW_UMIN
    0U,	// G_ATOMICRMW_FADD
    0U,	// G_ATOMICRMW_FSUB
    0U,	// G_FENCE
    0U,	// G_BRCOND
    0U,	// G_BRINDIRECT
    0U,	// G_INTRINSIC
    0U,	// G_INTRINSIC_W_SIDE_EFFECTS
    0U,	// G_ANYEXT
    0U,	// G_TRUNC
    0U,	// G_CONSTANT
    0U,	// G_FCONSTANT
    0U,	// G_VASTART
    0U,	// G_VAARG
    0U,	// G_SEXT
    0U,	// G_SEXT_INREG
    0U,	// G_ZEXT
    0U,	// G_SHL
    0U,	// G_LSHR
    0U,	// G_ASHR
    0U,	// G_FSHL
    0U,	// G_FSHR
    0U,	// G_ROTR
    0U,	// G_ROTL
    0U,	// G_ICMP
    0U,	// G_FCMP
    0U,	// G_SELECT
    0U,	// G_UADDO
    0U,	// G_UADDE
    0U,	// G_USUBO
    0U,	// G_USUBE
    0U,	// G_SADDO
    0U,	// G_SADDE
    0U,	// G_SSUBO
    0U,	// G_SSUBE
    0U,	// G_UMULO
    0U,	// G_SMULO
    0U,	// G_UMULH
    0U,	// G_SMULH
    0U,	// G_UADDSAT
    0U,	// G_SADDSAT
    0U,	// G_USUBSAT
    0U,	// G_SSUBSAT
    0U,	// G_USHLSAT
    0U,	// G_SSHLSAT
    0U,	// G_SMULFIX
    0U,	// G_UMULFIX
    0U,	// G_SMULFIXSAT
    0U,	// G_UMULFIXSAT
    0U,	// G_SDIVFIX
    0U,	// G_UDIVFIX
    0U,	// G_SDIVFIXSAT
    0U,	// G_UDIVFIXSAT
    0U,	// G_FADD
    0U,	// G_FSUB
    0U,	// G_FMUL
    0U,	// G_FMA
    0U,	// G_FMAD
    0U,	// G_FDIV
    0U,	// G_FREM
    0U,	// G_FPOW
    0U,	// G_FPOWI
    0U,	// G_FEXP
    0U,	// G_FEXP2
    0U,	// G_FLOG
    0U,	// G_FLOG2
    0U,	// G_FLOG10
    0U,	// G_FNEG
    0U,	// G_FPEXT
    0U,	// G_FPTRUNC
    0U,	// G_FPTOSI
    0U,	// G_FPTOUI
    0U,	// G_SITOFP
    0U,	// G_UITOFP
    0U,	// G_FABS
    0U,	// G_FCOPYSIGN
    0U,	// G_FCANONICALIZE
    0U,	// G_FMINNUM
    0U,	// G_FMAXNUM
    0U,	// G_FMINNUM_IEEE
    0U,	// G_FMAXNUM_IEEE
    0U,	// G_FMINIMUM
    0U,	// G_FMAXIMUM
    0U,	// G_PTR_ADD
    0U,	// G_PTRMASK
    0U,	// G_SMIN
    0U,	// G_SMAX
    0U,	// G_UMIN
    0U,	// G_UMAX
    0U,	// G_ABS
    0U,	// G_LROUND
    0U,	// G_LLROUND
    0U,	// G_BR
    0U,	// G_BRJT
    0U,	// G_INSERT_VECTOR_ELT
    0U,	// G_EXTRACT_VECTOR_ELT
    0U,	// G_SHUFFLE_VECTOR
    0U,	// G_CTTZ
    0U,	// G_CTTZ_ZERO_UNDEF
    0U,	// G_CTLZ
    0U,	// G_CTLZ_ZERO_UNDEF
    0U,	// G_CTPOP
    0U,	// G_BSWAP
    0U,	// G_BITREVERSE
    0U,	// G_FCEIL
    0U,	// G_FCOS
    0U,	// G_FSIN
    0U,	// G_FSQRT
    0U,	// G_FFLOOR
    0U,	// G_FRINT
    0U,	// G_FNEARBYINT
    0U,	// G_ADDRSPACE_CAST
    0U,	// G_BLOCK_ADDR
    0U,	// G_JUMP_TABLE
    0U,	// G_DYN_STACKALLOC
    0U,	// G_STRICT_FADD
    0U,	// G_STRICT_FSUB
    0U,	// G_STRICT_FMUL
    0U,	// G_STRICT_FDIV
    0U,	// G_STRICT_FREM
    0U,	// G_STRICT_FMA
    0U,	// G_STRICT_FSQRT
    0U,	// G_READ_REGISTER
    0U,	// G_WRITE_REGISTER
    0U,	// G_MEMCPY
    0U,	// G_MEMCPY_INLINE
    0U,	// G_MEMMOVE
    0U,	// G_MEMSET
    0U,	// G_BZERO
    0U,	// G_VECREDUCE_SEQ_FADD
    0U,	// G_VECREDUCE_SEQ_FMUL
    0U,	// G_VECREDUCE_FADD
    0U,	// G_VECREDUCE_FMUL
    0U,	// G_VECREDUCE_FMAX
    0U,	// G_VECREDUCE_FMIN
    0U,	// G_VECREDUCE_ADD
    0U,	// G_VECREDUCE_MUL
    0U,	// G_VECREDUCE_AND
    0U,	// G_VECREDUCE_OR
    0U,	// G_VECREDUCE_XOR
    0U,	// G_VECREDUCE_SMAX
    0U,	// G_VECREDUCE_SMIN
    0U,	// G_VECREDUCE_UMAX
    0U,	// G_VECREDUCE_UMIN
    0U,	// G_SBFX
    0U,	// G_UBFX
    1166U,	// ADD16mc
    1166U,	// ADD16mi
    2190U,	// ADD16mm
    3214U,	// ADD16mn
    4238U,	// ADD16mp
    1166U,	// ADD16mr
    17550U,	// ADD16rc
    17550U,	// ADD16ri
    18574U,	// ADD16rm
    19598U,	// ADD16rn
    5262U,	// ADD16rp
    17550U,	// ADD16rr
    1075U,	// ADD8mc
    1075U,	// ADD8mi
    2099U,	// ADD8mm
    3123U,	// ADD8mn
    4147U,	// ADD8mp
    1075U,	// ADD8mr
    17459U,	// ADD8rc
    17459U,	// ADD8ri
    18483U,	// ADD8rm
    19507U,	// ADD8rn
    5171U,	// ADD8rp
    17459U,	// ADD8rr
    1149U,	// ADDC16mc
    1149U,	// ADDC16mi
    2173U,	// ADDC16mm
    3197U,	// ADDC16mn
    4221U,	// ADDC16mp
    1149U,	// ADDC16mr
    17533U,	// ADDC16rc
    17533U,	// ADDC16ri
    18557U,	// ADDC16rm
    19581U,	// ADDC16rn
    5245U,	// ADDC16rp
    17533U,	// ADDC16rr
    1052U,	// ADDC8mc
    1052U,	// ADDC8mi
    2076U,	// ADDC8mm
    3100U,	// ADDC8mn
    4124U,	// ADDC8mp
    1052U,	// ADDC8mr
    17436U,	// ADDC8rc
    17436U,	// ADDC8ri
    18460U,	// ADDC8rm
    19484U,	// ADDC8rn
    5148U,	// ADDC8rp
    17436U,	// ADDC8rr
    589U,	// ADDframe
    39120U,	// ADJCALLSTACKDOWN
    39139U,	// ADJCALLSTACKUP
    1171U,	// AND16mc
    1171U,	// AND16mi
    2195U,	// AND16mm
    3219U,	// AND16mn
    4243U,	// AND16mp
    1171U,	// AND16mr
    17555U,	// AND16rc
    17555U,	// AND16ri
    18579U,	// AND16rm
    19603U,	// AND16rn
    5267U,	// AND16rp
    17555U,	// AND16rr
    1082U,	// AND8mc
    1082U,	// AND8mi
    2106U,	// AND8mm
    3130U,	// AND8mn
    4154U,	// AND8mp
    1082U,	// AND8mr
    17466U,	// AND8rc
    17466U,	// AND8ri
    18490U,	// AND8rm
    19514U,	// AND8rn
    5178U,	// AND8rp
    17466U,	// AND8rr
    1155U,	// BIC16mc
    1155U,	// BIC16mi
    2179U,	// BIC16mm
    3203U,	// BIC16mn
    4227U,	// BIC16mp
    1155U,	// BIC16mr
    17539U,	// BIC16rc
    17539U,	// BIC16ri
    18563U,	// BIC16rm
    19587U,	// BIC16rn
    5251U,	// BIC16rp
    17539U,	// BIC16rr
    1060U,	// BIC8mc
    1060U,	// BIC8mi
    2084U,	// BIC8mm
    3108U,	// BIC8mn
    4132U,	// BIC8mp
    1060U,	// BIC8mr
    17444U,	// BIC8rc
    17444U,	// BIC8ri
    18468U,	// BIC8rm
    19492U,	// BIC8rn
    5156U,	// BIC8rp
    17444U,	// BIC8rr
    1212U,	// BIS16mc
    1212U,	// BIS16mi
    2236U,	// BIS16mm
    3260U,	// BIS16mn
    4284U,	// BIS16mp
    1212U,	// BIS16mr
    17596U,	// BIS16rc
    17596U,	// BIS16ri
    18620U,	// BIS16rm
    19644U,	// BIS16rn
    5308U,	// BIS16rp
    17596U,	// BIS16rr
    1111U,	// BIS8mc
    1111U,	// BIS8mi
    2135U,	// BIS8mm
    3159U,	// BIS8mn
    4183U,	// BIS8mp
    1111U,	// BIS8mr
    17495U,	// BIS8rc
    17495U,	// BIS8ri
    18519U,	// BIS8rm
    19543U,	// BIS8rn
    5207U,	// BIS8rp
    17495U,	// BIS8rr
    1217U,	// BIT16mc
    1217U,	// BIT16mi
    2241U,	// BIT16mm
    3265U,	// BIT16mn
    4289U,	// BIT16mp
    1217U,	// BIT16mr
    7361U,	// BIT16rc
    7361U,	// BIT16ri
    8385U,	// BIT16rm
    9409U,	// BIT16rn
    10433U,	// BIT16rp
    7361U,	// BIT16rr
    1118U,	// BIT8mc
    1118U,	// BIT8mi
    2142U,	// BIT8mm
    3166U,	// BIT8mn
    4190U,	// BIT8mp
    1118U,	// BIT8mr
    7262U,	// BIT8rc
    7262U,	// BIT8ri
    8286U,	// BIT8rm
    9310U,	// BIT8rn
    10334U,	// BIT8rp
    7262U,	// BIT8rr
    55475U,	// Bi
    11443U,	// Bm
    55475U,	// Br
    55454U,	// CALLi
    11422U,	// CALLm
    12446U,	// CALLn
    13470U,	// CALLp
    55454U,	// CALLr
    1188U,	// CMP16mc
    1188U,	// CMP16mi
    2212U,	// CMP16mm
    3236U,	// CMP16mn
    4260U,	// CMP16mp
    1188U,	// CMP16mr
    7332U,	// CMP16rc
    7332U,	// CMP16ri
    8356U,	// CMP16rm
    9380U,	// CMP16rn
    10404U,	// CMP16rp
    7332U,	// CMP16rr
    1097U,	// CMP8mc
    1097U,	// CMP8mi
    2121U,	// CMP8mm
    3145U,	// CMP8mn
    4169U,	// CMP8mp
    1097U,	// CMP8mr
    7241U,	// CMP8rc
    7241U,	// CMP8ri
    8265U,	// CMP8rm
    9289U,	// CMP8rn
    10313U,	// CMP8rp
    7241U,	// CMP8rr
    1165U,	// DADD16mc
    1165U,	// DADD16mi
    2189U,	// DADD16mm
    3213U,	// DADD16mn
    4237U,	// DADD16mp
    1165U,	// DADD16mr
    17549U,	// DADD16rc
    17549U,	// DADD16ri
    18573U,	// DADD16rm
    19597U,	// DADD16rn
    5261U,	// DADD16rp
    17549U,	// DADD16rr
    1074U,	// DADD8mc
    1074U,	// DADD8mi
    2098U,	// DADD8mm
    3122U,	// DADD8mn
    4146U,	// DADD8mp
    1074U,	// DADD8mr
    17458U,	// DADD8rc
    17458U,	// DADD8ri
    18482U,	// DADD8rm
    19506U,	// DADD8rn
    5170U,	// DADD8rp
    17458U,	// DADD8rr
    14978U,	// JCC
    15529U,	// JMP
    1227U,	// MOV16mc
    1227U,	// MOV16mi
    2251U,	// MOV16mm
    3275U,	// MOV16mn
    1227U,	// MOV16mr
    7371U,	// MOV16rc
    7371U,	// MOV16ri
    8395U,	// MOV16rm
    9419U,	// MOV16rn
    20683U,	// MOV16rp
    7371U,	// MOV16rr
    1125U,	// MOV8mc
    1125U,	// MOV8mi
    2149U,	// MOV8mm
    3173U,	// MOV8mn
    1125U,	// MOV8mr
    7269U,	// MOV8rc
    7269U,	// MOV8ri
    8293U,	// MOV8rm
    9317U,	// MOV8rn
    20581U,	// MOV8rp
    7269U,	// MOV8rr
    8293U,	// MOVZX16rm8
    7269U,	// MOVZX16rr8
    55470U,	// POP16r
    55448U,	// PUSH16c
    55448U,	// PUSH16i
    55448U,	// PUSH16r
    55361U,	// PUSH8r
    658U,	// RET
    637U,	// RETI
    11265U,	// RRA16m
    12289U,	// RRA16n
    13313U,	// RRA16p
    55297U,	// RRA16r
    11270U,	// RRA8m
    12294U,	// RRA8n
    13318U,	// RRA8p
    55302U,	// RRA8r
    11400U,	// RRC16m
    12424U,	// RRC16n
    13448U,	// RRC16p
    55432U,	// RRC16r
    11307U,	// RRC8m
    12331U,	// RRC8n
    13355U,	// RRC8p
    55339U,	// RRC8r
    0U,	// Rrcl16
    0U,	// Rrcl8
    11462U,	// SEXT16m
    12486U,	// SEXT16n
    13510U,	// SEXT16p
    55494U,	// SEXT16r
    1138U,	// SUB16mc
    1138U,	// SUB16mi
    2162U,	// SUB16mm
    3186U,	// SUB16mn
    4210U,	// SUB16mp
    1138U,	// SUB16mr
    17522U,	// SUB16rc
    17522U,	// SUB16ri
    18546U,	// SUB16rm
    19570U,	// SUB16rn
    5234U,	// SUB16rp
    17522U,	// SUB16rr
    1037U,	// SUB8mc
    1037U,	// SUB8mi
    2061U,	// SUB8mm
    3085U,	// SUB8mn
    4109U,	// SUB8mp
    1037U,	// SUB8mr
    17421U,	// SUB8rc
    17421U,	// SUB8ri
    18445U,	// SUB8rm
    19469U,	// SUB8rn
    5133U,	// SUB8rp
    17421U,	// SUB8rr
    1143U,	// SUBC16mc
    1143U,	// SUBC16mi
    2167U,	// SUBC16mm
    3191U,	// SUBC16mn
    4215U,	// SUBC16mp
    1143U,	// SUBC16mr
    17527U,	// SUBC16rc
    17527U,	// SUBC16ri
    18551U,	// SUBC16rm
    19575U,	// SUBC16rn
    5239U,	// SUBC16rp
    17527U,	// SUBC16rr
    1044U,	// SUBC8mc
    1044U,	// SUBC8mi
    2068U,	// SUBC8mm
    3092U,	// SUBC8mn
    4116U,	// SUBC8mp
    1044U,	// SUBC8mr
    17428U,	// SUBC8rc
    17428U,	// SUBC8ri
    18452U,	// SUBC8rm
    19476U,	// SUBC8rn
    5140U,	// SUBC8rp
    17428U,	// SUBC8rr
    11372U,	// SWPB16m
    12396U,	// SWPB16n
    13420U,	// SWPB16p
    55404U,	// SWPB16r
    512U,	// Select16
    572U,	// Select8
    482U,	// Shl16
    544U,	// Shl8
    467U,	// Sra16
    530U,	// Sra8
    497U,	// Srl16
    558U,	// Srl8
    1207U,	// XOR16mc
    1207U,	// XOR16mi
    2231U,	// XOR16mm
    3255U,	// XOR16mn
    4279U,	// XOR16mp
    1207U,	// XOR16mr
    17591U,	// XOR16rc
    17591U,	// XOR16ri
    18615U,	// XOR16rm
    19639U,	// XOR16rn
    5303U,	// XOR16rp
    17591U,	// XOR16rr
    1104U,	// XOR8mc
    1104U,	// XOR8mi
    2128U,	// XOR8mm
    3152U,	// XOR8mn
    4176U,	// XOR8mp
    1104U,	// XOR8mr
    17488U,	// XOR8rc
    17488U,	// XOR8ri
    18512U,	// XOR8rm
    19536U,	// XOR8rn
    5200U,	// XOR8rp
    17488U,	// XOR8rr
    7269U,	// ZEXT16r
  };

  // Emit the opcode for the instruction.
  uint32_t Bits = 0;
  Bits |= OpInfo0[MI->getOpcode()] << 0;
  return {AsmStrs+(Bits & 1023)-1, Bits};

}
/// printInstruction - This method is automatically generated by tablegen
/// from the instruction set description.
LLVM_NO_PROFILE_INSTRUMENT_FUNCTION
void MSP430InstPrinter::printInstruction(const MCInst *MI, uint64_t Address, raw_ostream &O) {
  O << "\t";

  auto MnemonicInfo = getMnemonic(MI);

  O << MnemonicInfo.first;

  uint32_t Bits = MnemonicInfo.second;
  assert(Bits != 0 && "Cannot print this instruction.");

  // Fragment 0 encoded into 4 bits for 16 unique commands.
  switch ((Bits >> 10) & 15) {
  default: llvm_unreachable("Invalid command number.");
  case 0:
    // DBG_VALUE, DBG_VALUE_LIST, DBG_INSTR_REF, DBG_PHI, DBG_LABEL, BUNDLE, ...
    return;
    break;
  case 1:
    // ADD16mc, ADD16mi, ADD16mr, ADD16rc, ADD16ri, ADD16rr, ADD8mc, ADD8mi, ...
    printOperand(MI, 2, O);
    O << ", ";
    break;
  case 2:
    // ADD16mm, ADD16rm, ADD8mm, ADD8rm, ADDC16mm, ADDC16rm, ADDC8mm, ADDC8rm...
    printSrcMemOperand(MI, 2, O);
    O << ", ";
    break;
  case 3:
    // ADD16mn, ADD16rn, ADD8mn, ADD8rn, ADDC16mn, ADDC16rn, ADDC8mn, ADDC8rn...
    printIndRegOperand(MI, 2, O);
    O << ", ";
    break;
  case 4:
    // ADD16mp, ADD8mp, ADDC16mp, ADDC8mp, AND16mp, AND8mp, BIC16mp, BIC8mp, ...
    printPostIndRegOperand(MI, 2, O);
    O << ", ";
    break;
  case 5:
    // ADD16rp, ADD8rp, ADDC16rp, ADDC8rp, AND16rp, AND8rp, BIC16rp, BIC8rp, ...
    printPostIndRegOperand(MI, 3, O);
    O << ", ";
    printOperand(MI, 0, O);
    return;
    break;
  case 6:
    // ADJCALLSTACKDOWN, ADJCALLSTACKUP, Bi, Br, CALLi, CALLr, POP16r, PUSH16...
    printOperand(MI, 0, O);
    break;
  case 7:
    // BIT16rc, BIT16ri, BIT16rr, BIT8rc, BIT8ri, BIT8rr, CMP16rc, CMP16ri, C...
    printOperand(MI, 1, O);
    O << ", ";
    printOperand(MI, 0, O);
    return;
    break;
  case 8:
    // BIT16rm, BIT8rm, CMP16rm, CMP8rm, MOV16rm, MOV8rm, MOVZX16rm8
    printSrcMemOperand(MI, 1, O);
    O << ", ";
    printOperand(MI, 0, O);
    return;
    break;
  case 9:
    // BIT16rn, BIT8rn, CMP16rn, CMP8rn, MOV16rn, MOV8rn
    printIndRegOperand(MI, 1, O);
    O << ", ";
    printOperand(MI, 0, O);
    return;
    break;
  case 10:
    // BIT16rp, BIT8rp, CMP16rp, CMP8rp
    printPostIndRegOperand(MI, 1, O);
    O << ", ";
    printOperand(MI, 0, O);
    return;
    break;
  case 11:
    // Bm, CALLm, RRA16m, RRA8m, RRC16m, RRC8m, SEXT16m, SWPB16m
    printSrcMemOperand(MI, 0, O);
    return;
    break;
  case 12:
    // CALLn, RRA16n, RRA8n, RRC16n, RRC8n, SEXT16n, SWPB16n
    printIndRegOperand(MI, 0, O);
    return;
    break;
  case 13:
    // CALLp, RRA16p, RRA8p, RRC16p, RRC8p, SEXT16p, SWPB16p
    printPostIndRegOperand(MI, 0, O);
    return;
    break;
  case 14:
    // JCC
    printCCOperand(MI, 1, O);
    O << "\t";
    printPCRelImmOperand(MI, 0, O);
    return;
    break;
  case 15:
    // JMP
    printPCRelImmOperand(MI, 0, O);
    return;
    break;
  }


  // Fragment 1 encoded into 2 bits for 4 unique commands.
  switch ((Bits >> 14) & 3) {
  default: llvm_unreachable("Invalid command number.");
  case 0:
    // ADD16mc, ADD16mi, ADD16mm, ADD16mn, ADD16mp, ADD16mr, ADD8mc, ADD8mi, ...
    printSrcMemOperand(MI, 0, O);
    return;
    break;
  case 1:
    // ADD16rc, ADD16ri, ADD16rm, ADD16rn, ADD16rr, ADD8rc, ADD8ri, ADD8rm, A...
    printOperand(MI, 0, O);
    return;
    break;
  case 2:
    // ADJCALLSTACKDOWN, ADJCALLSTACKUP
    O << ' ';
    printOperand(MI, 1, O);
    return;
    break;
  case 3:
    // Bi, Br, CALLi, CALLr, POP16r, PUSH16c, PUSH16i, PUSH16r, PUSH8r, RRA16...
    return;
    break;
  }

}


/// getRegisterName - This method is automatically generated by tblgen
/// from the register set description.  This returns the assembler name
/// for the specified register.
const char *MSP430InstPrinter::getRegisterName(unsigned RegNo) {
  assert(RegNo && RegNo < 33 && "Invalid register number!");


#ifdef __GNUC__
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Woverlength-strings"
#endif
  static const char AsmStrs[] = {
  /* 0 */ "r10\0"
  /* 4 */ "r0\0"
  /* 7 */ "r11\0"
  /* 11 */ "r1\0"
  /* 14 */ "r12\0"
  /* 18 */ "r2\0"
  /* 21 */ "r13\0"
  /* 25 */ "r3\0"
  /* 28 */ "r14\0"
  /* 32 */ "r4\0"
  /* 35 */ "r15\0"
  /* 39 */ "r5\0"
  /* 42 */ "r6\0"
  /* 45 */ "r7\0"
  /* 48 */ "r8\0"
  /* 51 */ "r9\0"
};
#ifdef __GNUC__
#pragma GCC diagnostic pop
#endif

  static const uint8_t RegAsmOffset[] = {
    25, 25, 4, 4, 11, 11, 18, 18, 32, 39, 42, 45, 48, 51, 
    0, 7, 14, 21, 28, 35, 32, 39, 42, 45, 48, 51, 0, 7, 
    14, 21, 28, 35, 
  };

  assert (*(AsmStrs+RegAsmOffset[RegNo-1]) &&
          "Invalid alt name index for register!");
  return AsmStrs+RegAsmOffset[RegNo-1];
}

#ifdef PRINT_ALIAS_INSTR
#undef PRINT_ALIAS_INSTR

bool MSP430InstPrinter::printAliasInstr(const MCInst *MI, uint64_t Address, raw_ostream &OS) {
  static const PatternsForOpcode OpToPatterns[] = {
    {MSP430::ADD16mc, 0, 2 },
    {MSP430::ADD16rc, 2, 2 },
    {MSP430::ADD8mc, 4, 2 },
    {MSP430::ADD8rc, 6, 2 },
    {MSP430::ADDC16mc, 8, 1 },
    {MSP430::ADDC16rc, 9, 1 },
    {MSP430::ADDC8mc, 10, 1 },
    {MSP430::ADDC8rc, 11, 1 },
    {MSP430::BIC16rc, 12, 4 },
    {MSP430::BIS16rc, 16, 4 },
    {MSP430::CMP16mc, 20, 1 },
    {MSP430::CMP16rc, 21, 1 },
    {MSP430::CMP8mc, 22, 1 },
    {MSP430::CMP8rc, 23, 1 },
    {MSP430::DADD16mc, 24, 1 },
    {MSP430::DADD16rc, 25, 1 },
    {MSP430::DADD8mc, 26, 1 },
    {MSP430::DADD8rc, 27, 1 },
    {MSP430::MOV16mc, 28, 1 },
    {MSP430::MOV16rc, 29, 2 },
    {MSP430::MOV8mc, 31, 1 },
    {MSP430::MOV8rc, 32, 1 },
    {MSP430::SUB16mc, 33, 2 },
    {MSP430::SUB16rc, 35, 2 },
    {MSP430::SUB8mc, 37, 2 },
    {MSP430::SUB8rc, 39, 2 },
    {MSP430::SUBC16mc, 41, 1 },
    {MSP430::SUBC16rc, 42, 1 },
    {MSP430::SUBC8mc, 43, 1 },
    {MSP430::SUBC8rc, 44, 1 },
    {MSP430::XOR16mc, 45, 1 },
    {MSP430::XOR16rc, 46, 1 },
    {MSP430::XOR8mc, 47, 1 },
    {MSP430::XOR8rc, 48, 1 },
  };

  static const AliasPattern Patterns[] = {
    // MSP430::ADD16mc - 0
    {0, 0, 3, 3 },
    {9, 3, 3, 3 },
    // MSP430::ADD16rc - 2
    {19, 6, 3, 3 },
    {26, 9, 3, 3 },
    // MSP430::ADD8mc - 4
    {34, 12, 3, 3 },
    {45, 15, 3, 3 },
    // MSP430::ADD8rc - 6
    {57, 18, 3, 3 },
    {66, 21, 3, 3 },
    // MSP430::ADDC16mc - 8
    {76, 24, 3, 3 },
    // MSP430::ADDC16rc - 9
    {85, 27, 3, 3 },
    // MSP430::ADDC8mc - 10
    {92, 30, 3, 3 },
    // MSP430::ADDC8rc - 11
    {103, 33, 3, 3 },
    // MSP430::BIC16rc - 12
    {112, 36, 3, 3 },
    {117, 39, 3, 3 },
    {122, 42, 3, 3 },
    {127, 45, 3, 3 },
    // MSP430::BIS16rc - 16
    {132, 48, 3, 3 },
    {137, 51, 3, 3 },
    {142, 54, 3, 3 },
    {147, 57, 3, 3 },
    // MSP430::CMP16mc - 20
    {152, 60, 3, 3 },
    // MSP430::CMP16rc - 21
    {161, 63, 2, 2 },
    // MSP430::CMP8mc - 22
    {168, 65, 3, 3 },
    // MSP430::CMP8rc - 23
    {179, 68, 2, 2 },
    // MSP430::DADD16mc - 24
    {188, 70, 3, 3 },
    // MSP430::DADD16rc - 25
    {198, 73, 3, 3 },
    // MSP430::DADD8mc - 26
    {206, 76, 3, 3 },
    // MSP430::DADD8rc - 27
    {218, 79, 3, 3 },
    // MSP430::MOV16mc - 28
    {228, 82, 3, 3 },
    // MSP430::MOV16rc - 29
    {237, 85, 2, 2 },
    {241, 87, 2, 2 },
    // MSP430::MOV8mc - 31
    {248, 89, 3, 3 },
    // MSP430::MOV8rc - 32
    {259, 92, 2, 2 },
    // MSP430::SUB16mc - 33
    {268, 94, 3, 3 },
    {277, 97, 3, 3 },
    // MSP430::SUB16rc - 35
    {287, 100, 3, 3 },
    {294, 103, 3, 3 },
    // MSP430::SUB8mc - 37
    {302, 106, 3, 3 },
    {313, 109, 3, 3 },
    // MSP430::SUB8rc - 39
    {325, 112, 3, 3 },
    {334, 115, 3, 3 },
    // MSP430::SUBC16mc - 41
    {344, 118, 3, 3 },
    // MSP430::SUBC16rc - 42
    {353, 121, 3, 3 },
    // MSP430::SUBC8mc - 43
    {360, 124, 3, 3 },
    // MSP430::SUBC8rc - 44
    {371, 127, 3, 3 },
    // MSP430::XOR16mc - 45
    {380, 130, 3, 3 },
    // MSP430::XOR16rc - 46
    {389, 133, 3, 3 },
    // MSP430::XOR8mc - 47
    {396, 136, 3, 3 },
    // MSP430::XOR8rc - 48
    {407, 139, 3, 3 },
  };

  static const AliasPatternCond Conds[] = {
    // (ADD16mc memdst:$dst, 1) - 0
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(1)},
    // (ADD16mc memdst:$dst, 2) - 3
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(2)},
    // (ADD16rc GR16:$dst, 1) - 6
    {AliasPatternCond::K_RegClass, MSP430::GR16RegClassID},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(1)},
    // (ADD16rc GR16:$dst, 2) - 9
    {AliasPatternCond::K_RegClass, MSP430::GR16RegClassID},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(2)},
    // (ADD8mc memdst:$dst, 1) - 12
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(1)},
    // (ADD8mc memdst:$dst, 2) - 15
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(2)},
    // (ADD8rc GR8:$dst, 1) - 18
    {AliasPatternCond::K_RegClass, MSP430::GR8RegClassID},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(1)},
    // (ADD8rc GR8:$dst, 2) - 21
    {AliasPatternCond::K_RegClass, MSP430::GR8RegClassID},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(2)},
    // (ADDC16mc memdst:$dst, 0) - 24
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(0)},
    // (ADDC16rc GR16:$dst, 0) - 27
    {AliasPatternCond::K_RegClass, MSP430::GR16RegClassID},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(0)},
    // (ADDC8mc memdst:$dst, 0) - 30
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(0)},
    // (ADDC8rc GR8:$dst, 0) - 33
    {AliasPatternCond::K_RegClass, MSP430::GR8RegClassID},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(0)},
    // (BIC16rc SR, 8) - 36
    {AliasPatternCond::K_Reg, MSP430::SR},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(8)},
    // (BIC16rc SR, 1) - 39
    {AliasPatternCond::K_Reg, MSP430::SR},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(1)},
    // (BIC16rc SR, 4) - 42
    {AliasPatternCond::K_Reg, MSP430::SR},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(4)},
    // (BIC16rc SR, 2) - 45
    {AliasPatternCond::K_Reg, MSP430::SR},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(2)},
    // (BIS16rc SR, 8) - 48
    {AliasPatternCond::K_Reg, MSP430::SR},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(8)},
    // (BIS16rc SR, 1) - 51
    {AliasPatternCond::K_Reg, MSP430::SR},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(1)},
    // (BIS16rc SR, 4) - 54
    {AliasPatternCond::K_Reg, MSP430::SR},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(4)},
    // (BIS16rc SR, 2) - 57
    {AliasPatternCond::K_Reg, MSP430::SR},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(2)},
    // (CMP16mc memdst:$dst, 0) - 60
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(0)},
    // (CMP16rc GR16:$dst, 0) - 63
    {AliasPatternCond::K_RegClass, MSP430::GR16RegClassID},
    {AliasPatternCond::K_Imm, uint32_t(0)},
    // (CMP8mc memdst:$dst, 0) - 65
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(0)},
    // (CMP8rc GR8:$dst, 0) - 68
    {AliasPatternCond::K_RegClass, MSP430::GR8RegClassID},
    {AliasPatternCond::K_Imm, uint32_t(0)},
    // (DADD16mc memdst:$dst, 0) - 70
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(0)},
    // (DADD16rc GR16:$dst, 0) - 73
    {AliasPatternCond::K_RegClass, MSP430::GR16RegClassID},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(0)},
    // (DADD8mc memdst:$dst, 0) - 76
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(0)},
    // (DADD8rc GR8:$dst, 0) - 79
    {AliasPatternCond::K_RegClass, MSP430::GR8RegClassID},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(0)},
    // (MOV16mc memdst:$dst, 0) - 82
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(0)},
    // (MOV16rc CG, 0) - 85
    {AliasPatternCond::K_Reg, MSP430::CG},
    {AliasPatternCond::K_Imm, uint32_t(0)},
    // (MOV16rc GR16:$dst, 0) - 87
    {AliasPatternCond::K_RegClass, MSP430::GR16RegClassID},
    {AliasPatternCond::K_Imm, uint32_t(0)},
    // (MOV8mc memdst:$dst, 0) - 89
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(0)},
    // (MOV8rc GR8:$dst, 0) - 92
    {AliasPatternCond::K_RegClass, MSP430::GR8RegClassID},
    {AliasPatternCond::K_Imm, uint32_t(0)},
    // (SUB16mc memdst:$dst, 1) - 94
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(1)},
    // (SUB16mc memdst:$dst, 2) - 97
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(2)},
    // (SUB16rc GR16:$dst, 1) - 100
    {AliasPatternCond::K_RegClass, MSP430::GR16RegClassID},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(1)},
    // (SUB16rc GR16:$dst, 2) - 103
    {AliasPatternCond::K_RegClass, MSP430::GR16RegClassID},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(2)},
    // (SUB8mc memdst:$dst, 1) - 106
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(1)},
    // (SUB8mc memdst:$dst, 2) - 109
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(2)},
    // (SUB8rc GR8:$dst, 1) - 112
    {AliasPatternCond::K_RegClass, MSP430::GR8RegClassID},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(1)},
    // (SUB8rc GR8:$dst, 2) - 115
    {AliasPatternCond::K_RegClass, MSP430::GR8RegClassID},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(2)},
    // (SUBC16mc memdst:$dst, 0) - 118
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(0)},
    // (SUBC16rc GR16:$dst, 0) - 121
    {AliasPatternCond::K_RegClass, MSP430::GR16RegClassID},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(0)},
    // (SUBC8mc memdst:$dst, 0) - 124
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(0)},
    // (SUBC8rc GR8:$dst, 0) - 127
    {AliasPatternCond::K_RegClass, MSP430::GR8RegClassID},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(0)},
    // (XOR16mc memdst:$dst, -1) - 130
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(-1)},
    // (XOR16rc GR16:$dst, -1) - 133
    {AliasPatternCond::K_RegClass, MSP430::GR16RegClassID},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(-1)},
    // (XOR8mc memdst:$dst, -1) - 136
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(-1)},
    // (XOR8rc GR8:$dst, -1) - 139
    {AliasPatternCond::K_RegClass, MSP430::GR8RegClassID},
    {AliasPatternCond::K_Ignore, 0},
    {AliasPatternCond::K_Imm, uint32_t(-1)},
  };

  static const char AsmStrings[] =
    /* 0 */ "inc	$\xFF\x01\x01\0"
    /* 9 */ "incd	$\xFF\x01\x01\0"
    /* 19 */ "inc	$\x01\0"
    /* 26 */ "incd	$\x01\0"
    /* 34 */ "inc.b	$\xFF\x01\x01\0"
    /* 45 */ "incd.b	$\xFF\x01\x01\0"
    /* 57 */ "inc.b	$\x01\0"
    /* 66 */ "incd.b	$\x01\0"
    /* 76 */ "adc	$\xFF\x01\x01\0"
    /* 85 */ "adc	$\x01\0"
    /* 92 */ "adc.b	$\xFF\x01\x01\0"
    /* 103 */ "adc.b	$\x01\0"
    /* 112 */ "dint\0"
    /* 117 */ "clrc\0"
    /* 122 */ "clrn\0"
    /* 127 */ "clrz\0"
    /* 132 */ "eint\0"
    /* 137 */ "setc\0"
    /* 142 */ "setn\0"
    /* 147 */ "setz\0"
    /* 152 */ "tst	$\xFF\x01\x01\0"
    /* 161 */ "tst	$\x01\0"
    /* 168 */ "tst.b	$\xFF\x01\x01\0"
    /* 179 */ "tst.b	$\x01\0"
    /* 188 */ "dadc	$\xFF\x01\x01\0"
    /* 198 */ "dadc	$\x01\0"
    /* 206 */ "dadc.b	$\xFF\x01\x01\0"
    /* 218 */ "dadc.b	$\x01\0"
    /* 228 */ "clr	$\xFF\x01\x01\0"
    /* 237 */ "nop\0"
    /* 241 */ "clr	$\x01\0"
    /* 248 */ "clr.b	$\xFF\x01\x01\0"
    /* 259 */ "clr.b	$\x01\0"
    /* 268 */ "dec	$\xFF\x01\x01\0"
    /* 277 */ "decd	$\xFF\x01\x01\0"
    /* 287 */ "dec	$\x01\0"
    /* 294 */ "decd	$\x01\0"
    /* 302 */ "dec.b	$\xFF\x01\x01\0"
    /* 313 */ "decd.b	$\xFF\x01\x01\0"
    /* 325 */ "dec.b	$\x01\0"
    /* 334 */ "decd.b	$\x01\0"
    /* 344 */ "sbc	$\xFF\x01\x01\0"
    /* 353 */ "sbc	$\x01\0"
    /* 360 */ "sbc.b	$\xFF\x01\x01\0"
    /* 371 */ "sbc.b	$\x01\0"
    /* 380 */ "inv	$\xFF\x01\x01\0"
    /* 389 */ "inv	$\x01\0"
    /* 396 */ "inv.b	$\xFF\x01\x01\0"
    /* 407 */ "inv.b	$\x01\0"
  ;

#ifndef NDEBUG
  static struct SortCheck {
    SortCheck(ArrayRef<PatternsForOpcode> OpToPatterns) {
      assert(std::is_sorted(
                 OpToPatterns.begin(), OpToPatterns.end(),
                 [](const PatternsForOpcode &L, const PatternsForOpcode &R) {
                   return L.Opcode < R.Opcode;
                 }) &&
             "tablegen failed to sort opcode patterns");
    }
  } sortCheckVar(OpToPatterns);
#endif

  AliasMatchingData M {
    makeArrayRef(OpToPatterns),
    makeArrayRef(Patterns),
    makeArrayRef(Conds),
    StringRef(AsmStrings, array_lengthof(AsmStrings)),
    nullptr,
  };
  const char *AsmString = matchAliasPatterns(MI, nullptr, M);
  if (!AsmString) return false;

  unsigned I = 0;
  while (AsmString[I] != ' ' && AsmString[I] != '\t' &&
         AsmString[I] != '$' && AsmString[I] != '\0')
    ++I;
  OS << '\t' << StringRef(AsmString, I);
  if (AsmString[I] != '\0') {
    if (AsmString[I] == ' ' || AsmString[I] == '\t') {
      OS << '\t';
      ++I;
    }
    do {
      if (AsmString[I] == '$') {
        ++I;
        if (AsmString[I] == (char)0xff) {
          ++I;
          int OpIdx = AsmString[I++] - 1;
          int PrintMethodIdx = AsmString[I++] - 1;
          printCustomAliasOperand(MI, Address, OpIdx, PrintMethodIdx, OS);
        } else
          printOperand(MI, unsigned(AsmString[I++]) - 1, OS);
      } else {
        OS << AsmString[I++];
      }
    } while (AsmString[I] != '\0');
  }

  return true;
}

void MSP430InstPrinter::printCustomAliasOperand(
         const MCInst *MI, uint64_t Address, unsigned OpIdx,
         unsigned PrintMethodIdx,
         raw_ostream &OS) {
  switch (PrintMethodIdx) {
  default:
    llvm_unreachable("Unknown PrintMethod kind");
    break;
  case 0:
    printSrcMemOperand(MI, OpIdx, OS);
    break;
  }
}

#endif // PRINT_ALIAS_INSTR
