/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Assembly Writer Source Fragment                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

/// getMnemonic - This method is automatically generated by tablegen
/// from the instruction set description.
std::pair<const char *, uint64_t> BPFInstPrinter::getMnemonic(const MCInst *MI) {

#ifdef __GNUC__
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Woverlength-strings"
#endif
  static const char AsmStrs[] = {
  /* 0 */ "lea\t\0"
  /* 5 */ "ld_pseudo\t\0"
  /* 16 */ "nop\t\0"
  /* 21 */ "#memcpy dst: \0"
  /* 35 */ "#ADJCALLSTACKDOWN \0"
  /* 54 */ "# Select PSEUDO \0"
  /* 71 */ "#ADJCALLSTACKUP \0"
  /* 88 */ "if \0"
  /* 92 */ "call \0"
  /* 98 */ "goto \0"
  /* 104 */ "callx \0"
  /* 111 */ "lock *(u32 *)(\0"
  /* 126 */ "lock *(u64 *)(\0"
  /* 141 */ "*(u16 *)(\0"
  /* 151 */ "*(u8 *)(\0"
  /* 160 */ "w0 = cmpxchg32_32(\0"
  /* 179 */ "r0 = cmpxchg_64(\0"
  /* 196 */ "# XRay Function Patchable RET.\0"
  /* 227 */ "# XRay Typed Event Log.\0"
  /* 251 */ "# XRay Custom Event Log.\0"
  /* 276 */ "# XRay Function Enter.\0"
  /* 299 */ "# XRay Tail Call Exit.\0"
  /* 322 */ "# XRay Function Exit.\0"
  /* 344 */ "LIFETIME_END\0"
  /* 357 */ "PSEUDO_PROBE\0"
  /* 370 */ "BUNDLE\0"
  /* 377 */ "DBG_VALUE\0"
  /* 387 */ "DBG_INSTR_REF\0"
  /* 401 */ "DBG_PHI\0"
  /* 409 */ "DBG_LABEL\0"
  /* 419 */ "LIFETIME_START\0"
  /* 434 */ "DBG_VALUE_LIST\0"
  /* 449 */ "r0 = *(u32 *)skb[\0"
  /* 467 */ "r0 = *(u16 *)skb[\0"
  /* 485 */ "r0 = *(u8 *)skb[\0"
  /* 502 */ "# FEntry call\0"
  /* 516 */ "exit\0"
};
#ifdef __GNUC__
#pragma GCC diagnostic pop
#endif

  static const uint16_t OpInfo0[] = {
    0U,	// PHI
    0U,	// INLINEASM
    0U,	// INLINEASM_BR
    0U,	// CFI_INSTRUCTION
    0U,	// EH_LABEL
    0U,	// GC_LABEL
    0U,	// ANNOTATION_LABEL
    0U,	// KILL
    0U,	// EXTRACT_SUBREG
    0U,	// INSERT_SUBREG
    0U,	// IMPLICIT_DEF
    0U,	// SUBREG_TO_REG
    0U,	// COPY_TO_REGCLASS
    378U,	// DBG_VALUE
    435U,	// DBG_VALUE_LIST
    388U,	// DBG_INSTR_REF
    402U,	// DBG_PHI
    410U,	// DBG_LABEL
    0U,	// REG_SEQUENCE
    0U,	// COPY
    371U,	// BUNDLE
    420U,	// LIFETIME_START
    345U,	// LIFETIME_END
    358U,	// PSEUDO_PROBE
    0U,	// ARITH_FENCE
    0U,	// STACKMAP
    503U,	// FENTRY_CALL
    0U,	// PATCHPOINT
    0U,	// LOAD_STACK_GUARD
    0U,	// PREALLOCATED_SETUP
    0U,	// PREALLOCATED_ARG
    0U,	// STATEPOINT
    0U,	// LOCAL_ESCAPE
    0U,	// FAULTING_OP
    0U,	// PATCHABLE_OP
    277U,	// PATCHABLE_FUNCTION_ENTER
    197U,	// PATCHABLE_RET
    323U,	// PATCHABLE_FUNCTION_EXIT
    300U,	// PATCHABLE_TAIL_CALL
    252U,	// PATCHABLE_EVENT_CALL
    228U,	// PATCHABLE_TYPED_EVENT_CALL
    0U,	// ICALL_BRANCH_FUNNEL
    0U,	// G_ASSERT_SEXT
    0U,	// G_ASSERT_ZEXT
    0U,	// G_ASSERT_ALIGN
    0U,	// G_ADD
    0U,	// G_SUB
    0U,	// G_MUL
    0U,	// G_SDIV
    0U,	// G_UDIV
    0U,	// G_SREM
    0U,	// G_UREM
    0U,	// G_SDIVREM
    0U,	// G_UDIVREM
    0U,	// G_AND
    0U,	// G_OR
    0U,	// G_XOR
    0U,	// G_IMPLICIT_DEF
    0U,	// G_PHI
    0U,	// G_FRAME_INDEX
    0U,	// G_GLOBAL_VALUE
    0U,	// G_EXTRACT
    0U,	// G_UNMERGE_VALUES
    0U,	// G_INSERT
    0U,	// G_MERGE_VALUES
    0U,	// G_BUILD_VECTOR
    0U,	// G_BUILD_VECTOR_TRUNC
    0U,	// G_CONCAT_VECTORS
    0U,	// G_PTRTOINT
    0U,	// G_INTTOPTR
    0U,	// G_BITCAST
    0U,	// G_FREEZE
    0U,	// G_INTRINSIC_TRUNC
    0U,	// G_INTRINSIC_ROUND
    0U,	// G_INTRINSIC_LRINT
    0U,	// G_INTRINSIC_ROUNDEVEN
    0U,	// G_READCYCLECOUNTER
    0U,	// G_LOAD
    0U,	// G_SEXTLOAD
    0U,	// G_ZEXTLOAD
    0U,	// G_INDEXED_LOAD
    0U,	// G_INDEXED_SEXTLOAD
    0U,	// G_INDEXED_ZEXTLOAD
    0U,	// G_STORE
    0U,	// G_INDEXED_STORE
    0U,	// G_ATOMIC_CMPXCHG_WITH_SUCCESS
    0U,	// G_ATOMIC_CMPXCHG
    0U,	// G_ATOMICRMW_XCHG
    0U,	// G_ATOMICRMW_ADD
    0U,	// G_ATOMICRMW_SUB
    0U,	// G_ATOMICRMW_AND
    0U,	// G_ATOMICRMW_NAND
    0U,	// G_ATOMICRMW_OR
    0U,	// G_ATOMICRMW_XOR
    0U,	// G_ATOMICRMW_MAX
    0U,	// G_ATOMICRMW_MIN
    0U,	// G_ATOMICRMW_UMAX
    0U,	// G_ATOMICRMW_UMIN
    0U,	// G_ATOMICRMW_FADD
    0U,	// G_ATOMICRMW_FSUB
    0U,	// G_FENCE
    0U,	// G_BRCOND
    0U,	// G_BRINDIRECT
    0U,	// G_INTRINSIC
    0U,	// G_INTRINSIC_W_SIDE_EFFECTS
    0U,	// G_ANYEXT
    0U,	// G_TRUNC
    0U,	// G_CONSTANT
    0U,	// G_FCONSTANT
    0U,	// G_VASTART
    0U,	// G_VAARG
    0U,	// G_SEXT
    0U,	// G_SEXT_INREG
    0U,	// G_ZEXT
    0U,	// G_SHL
    0U,	// G_LSHR
    0U,	// G_ASHR
    0U,	// G_FSHL
    0U,	// G_FSHR
    0U,	// G_ROTR
    0U,	// G_ROTL
    0U,	// G_ICMP
    0U,	// G_FCMP
    0U,	// G_SELECT
    0U,	// G_UADDO
    0U,	// G_UADDE
    0U,	// G_USUBO
    0U,	// G_USUBE
    0U,	// G_SADDO
    0U,	// G_SADDE
    0U,	// G_SSUBO
    0U,	// G_SSUBE
    0U,	// G_UMULO
    0U,	// G_SMULO
    0U,	// G_UMULH
    0U,	// G_SMULH
    0U,	// G_UADDSAT
    0U,	// G_SADDSAT
    0U,	// G_USUBSAT
    0U,	// G_SSUBSAT
    0U,	// G_USHLSAT
    0U,	// G_SSHLSAT
    0U,	// G_SMULFIX
    0U,	// G_UMULFIX
    0U,	// G_SMULFIXSAT
    0U,	// G_UMULFIXSAT
    0U,	// G_SDIVFIX
    0U,	// G_UDIVFIX
    0U,	// G_SDIVFIXSAT
    0U,	// G_UDIVFIXSAT
    0U,	// G_FADD
    0U,	// G_FSUB
    0U,	// G_FMUL
    0U,	// G_FMA
    0U,	// G_FMAD
    0U,	// G_FDIV
    0U,	// G_FREM
    0U,	// G_FPOW
    0U,	// G_FPOWI
    0U,	// G_FEXP
    0U,	// G_FEXP2
    0U,	// G_FLOG
    0U,	// G_FLOG2
    0U,	// G_FLOG10
    0U,	// G_FNEG
    0U,	// G_FPEXT
    0U,	// G_FPTRUNC
    0U,	// G_FPTOSI
    0U,	// G_FPTOUI
    0U,	// G_SITOFP
    0U,	// G_UITOFP
    0U,	// G_FABS
    0U,	// G_FCOPYSIGN
    0U,	// G_FCANONICALIZE
    0U,	// G_FMINNUM
    0U,	// G_FMAXNUM
    0U,	// G_FMINNUM_IEEE
    0U,	// G_FMAXNUM_IEEE
    0U,	// G_FMINIMUM
    0U,	// G_FMAXIMUM
    0U,	// G_PTR_ADD
    0U,	// G_PTRMASK
    0U,	// G_SMIN
    0U,	// G_SMAX
    0U,	// G_UMIN
    0U,	// G_UMAX
    0U,	// G_ABS
    0U,	// G_LROUND
    0U,	// G_LLROUND
    0U,	// G_BR
    0U,	// G_BRJT
    0U,	// G_INSERT_VECTOR_ELT
    0U,	// G_EXTRACT_VECTOR_ELT
    0U,	// G_SHUFFLE_VECTOR
    0U,	// G_CTTZ
    0U,	// G_CTTZ_ZERO_UNDEF
    0U,	// G_CTLZ
    0U,	// G_CTLZ_ZERO_UNDEF
    0U,	// G_CTPOP
    0U,	// G_BSWAP
    0U,	// G_BITREVERSE
    0U,	// G_FCEIL
    0U,	// G_FCOS
    0U,	// G_FSIN
    0U,	// G_FSQRT
    0U,	// G_FFLOOR
    0U,	// G_FRINT
    0U,	// G_FNEARBYINT
    0U,	// G_ADDRSPACE_CAST
    0U,	// G_BLOCK_ADDR
    0U,	// G_JUMP_TABLE
    0U,	// G_DYN_STACKALLOC
    0U,	// G_STRICT_FADD
    0U,	// G_STRICT_FSUB
    0U,	// G_STRICT_FMUL
    0U,	// G_STRICT_FDIV
    0U,	// G_STRICT_FREM
    0U,	// G_STRICT_FMA
    0U,	// G_STRICT_FSQRT
    0U,	// G_READ_REGISTER
    0U,	// G_WRITE_REGISTER
    0U,	// G_MEMCPY
    0U,	// G_MEMCPY_INLINE
    0U,	// G_MEMMOVE
    0U,	// G_MEMSET
    0U,	// G_BZERO
    0U,	// G_VECREDUCE_SEQ_FADD
    0U,	// G_VECREDUCE_SEQ_FMUL
    0U,	// G_VECREDUCE_FADD
    0U,	// G_VECREDUCE_FMUL
    0U,	// G_VECREDUCE_FMAX
    0U,	// G_VECREDUCE_FMIN
    0U,	// G_VECREDUCE_ADD
    0U,	// G_VECREDUCE_MUL
    0U,	// G_VECREDUCE_AND
    0U,	// G_VECREDUCE_OR
    0U,	// G_VECREDUCE_XOR
    0U,	// G_VECREDUCE_SMAX
    0U,	// G_VECREDUCE_SMIN
    0U,	// G_VECREDUCE_UMAX
    0U,	// G_VECREDUCE_UMIN
    0U,	// G_SBFX
    0U,	// G_UBFX
    1060U,	// ADJCALLSTACKDOWN
    1096U,	// ADJCALLSTACKUP
    9238U,	// MEMCPY
    17463U,	// Select
    17463U,	// Select_32
    17463U,	// Select_32_64
    17463U,	// Select_64_32
    17463U,	// Select_Ri
    17463U,	// Select_Ri_32
    17463U,	// Select_Ri_32_64
    17463U,	// Select_Ri_64_32
    25605U,	// ADD_ri
    25605U,	// ADD_ri_32
    25605U,	// ADD_rr
    25605U,	// ADD_rr_32
    33797U,	// AND_ri
    33797U,	// AND_ri_32
    33797U,	// AND_rr
    33797U,	// AND_rr_32
    41989U,	// BE16
    50181U,	// BE32
    58373U,	// BE64
    2228U,	// CMPXCHGD
    10401U,	// CMPXCHGW32
    17413U,	// CORE_ALU32_MEM
    25605U,	// CORE_MEM
    33797U,	// CORE_SHIFT
    41989U,	// DIV_ri
    41989U,	// DIV_ri_32
    41989U,	// DIV_rr
    41989U,	// DIV_rr_32
    50177U,	// FI_ri
    58461U,	// JAL
    58473U,	// JALX
    1113U,	// JEQ_ri
    1113U,	// JEQ_ri_32
    1113U,	// JEQ_rr
    1113U,	// JEQ_rr_32
    3171U,	// JMP
    9305U,	// JNE_ri
    9305U,	// JNE_ri_32
    9305U,	// JNE_rr
    9305U,	// JNE_rr_32
    17497U,	// JSGE_ri
    17497U,	// JSGE_ri_32
    17497U,	// JSGE_rr
    17497U,	// JSGE_rr_32
    25689U,	// JSGT_ri
    25689U,	// JSGT_ri_32
    25689U,	// JSGT_rr
    25689U,	// JSGT_rr_32
    33881U,	// JSLE_ri
    33881U,	// JSLE_ri_32
    33881U,	// JSLE_rr
    33881U,	// JSLE_rr_32
    42073U,	// JSLT_ri
    42073U,	// JSLT_ri_32
    42073U,	// JSLT_rr
    42073U,	// JSLT_rr_32
    50265U,	// JUGE_ri
    50265U,	// JUGE_ri_32
    50265U,	// JUGE_rr
    50265U,	// JUGE_rr_32
    58457U,	// JUGT_ri
    58457U,	// JUGT_ri_32
    58457U,	// JUGT_rr
    58457U,	// JUGT_rr_32
    1113U,	// JULE_ri
    1113U,	// JULE_ri_32
    1113U,	// JULE_rr
    1113U,	// JULE_rr_32
    9305U,	// JULT_ri
    9305U,	// JULT_ri_32
    9305U,	// JULT_rr
    9305U,	// JULT_rr_32
    17413U,	// LDB
    17413U,	// LDB32
    25605U,	// LDD
    33797U,	// LDH
    33797U,	// LDH32
    41989U,	// LDW
    41989U,	// LDW32
    4582U,	// LD_ABS_B
    4564U,	// LD_ABS_H
    4546U,	// LD_ABS_W
    4582U,	// LD_IND_B
    4564U,	// LD_IND_H
    4546U,	// LD_IND_W
    17413U,	// LD_imm64
    50182U,	// LD_pseudo
    50181U,	// LE16
    58373U,	// LE32
    1029U,	// LE64
    17413U,	// MOV_32_64
    17413U,	// MOV_ri
    17413U,	// MOV_ri_32
    17413U,	// MOV_rr
    17413U,	// MOV_rr_32
    9221U,	// MUL_ri
    9221U,	// MUL_ri_32
    9221U,	// MUL_rr
    9221U,	// MUL_rr_32
    17413U,	// NEG_32
    17413U,	// NEG_64
    58385U,	// NOP
    25605U,	// OR_ri
    25605U,	// OR_ri_32
    25605U,	// OR_rr
    25605U,	// OR_rr_32
    517U,	// RET
    33797U,	// SLL_ri
    33797U,	// SLL_ri_32
    33797U,	// SLL_rr
    33797U,	// SLL_rr_32
    41989U,	// SRA_ri
    41989U,	// SRA_ri_32
    41989U,	// SRA_rr
    41989U,	// SRA_rr_32
    50181U,	// SRL_ri
    50181U,	// SRL_ri_32
    50181U,	// SRL_rr
    50181U,	// SRL_rr_32
    62616U,	// STB
    62616U,	// STB32
    62596U,	// STD
    62606U,	// STH
    62606U,	// STH32
    62581U,	// STW
    62581U,	// STW32
    1029U,	// SUB_ri
    1029U,	// SUB_ri_32
    1029U,	// SUB_rr
    1029U,	// SUB_rr_32
    13439U,	// XADDD
    13424U,	// XADDW
    13424U,	// XADDW32
    21631U,	// XANDD
    21616U,	// XANDW32
    25605U,	// XCHGD
    33797U,	// XCHGW32
    41989U,	// XFADDD
    50181U,	// XFADDW32
    58373U,	// XFANDD
    1029U,	// XFANDW32
    9221U,	// XFORD
    17413U,	// XFORW32
    25605U,	// XFXORD
    33797U,	// XFXORW32
    46207U,	// XORD
    46192U,	// XORW32
    50181U,	// XOR_ri
    50181U,	// XOR_ri_32
    50181U,	// XOR_rr
    50181U,	// XOR_rr_32
    62591U,	// XXORD
    62576U,	// XXORW32
  };

  static const uint8_t OpInfo1[] = {
    0U,	// PHI
    0U,	// INLINEASM
    0U,	// INLINEASM_BR
    0U,	// CFI_INSTRUCTION
    0U,	// EH_LABEL
    0U,	// GC_LABEL
    0U,	// ANNOTATION_LABEL
    0U,	// KILL
    0U,	// EXTRACT_SUBREG
    0U,	// INSERT_SUBREG
    0U,	// IMPLICIT_DEF
    0U,	// SUBREG_TO_REG
    0U,	// COPY_TO_REGCLASS
    0U,	// DBG_VALUE
    0U,	// DBG_VALUE_LIST
    0U,	// DBG_INSTR_REF
    0U,	// DBG_PHI
    0U,	// DBG_LABEL
    0U,	// REG_SEQUENCE
    0U,	// COPY
    0U,	// BUNDLE
    0U,	// LIFETIME_START
    0U,	// LIFETIME_END
    0U,	// PSEUDO_PROBE
    0U,	// ARITH_FENCE
    0U,	// STACKMAP
    0U,	// FENTRY_CALL
    0U,	// PATCHPOINT
    0U,	// LOAD_STACK_GUARD
    0U,	// PREALLOCATED_SETUP
    0U,	// PREALLOCATED_ARG
    0U,	// STATEPOINT
    0U,	// LOCAL_ESCAPE
    0U,	// FAULTING_OP
    0U,	// PATCHABLE_OP
    0U,	// PATCHABLE_FUNCTION_ENTER
    0U,	// PATCHABLE_RET
    0U,	// PATCHABLE_FUNCTION_EXIT
    0U,	// PATCHABLE_TAIL_CALL
    0U,	// PATCHABLE_EVENT_CALL
    0U,	// PATCHABLE_TYPED_EVENT_CALL
    0U,	// ICALL_BRANCH_FUNNEL
    0U,	// G_ASSERT_SEXT
    0U,	// G_ASSERT_ZEXT
    0U,	// G_ASSERT_ALIGN
    0U,	// G_ADD
    0U,	// G_SUB
    0U,	// G_MUL
    0U,	// G_SDIV
    0U,	// G_UDIV
    0U,	// G_SREM
    0U,	// G_UREM
    0U,	// G_SDIVREM
    0U,	// G_UDIVREM
    0U,	// G_AND
    0U,	// G_OR
    0U,	// G_XOR
    0U,	// G_IMPLICIT_DEF
    0U,	// G_PHI
    0U,	// G_FRAME_INDEX
    0U,	// G_GLOBAL_VALUE
    0U,	// G_EXTRACT
    0U,	// G_UNMERGE_VALUES
    0U,	// G_INSERT
    0U,	// G_MERGE_VALUES
    0U,	// G_BUILD_VECTOR
    0U,	// G_BUILD_VECTOR_TRUNC
    0U,	// G_CONCAT_VECTORS
    0U,	// G_PTRTOINT
    0U,	// G_INTTOPTR
    0U,	// G_BITCAST
    0U,	// G_FREEZE
    0U,	// G_INTRINSIC_TRUNC
    0U,	// G_INTRINSIC_ROUND
    0U,	// G_INTRINSIC_LRINT
    0U,	// G_INTRINSIC_ROUNDEVEN
    0U,	// G_READCYCLECOUNTER
    0U,	// G_LOAD
    0U,	// G_SEXTLOAD
    0U,	// G_ZEXTLOAD
    0U,	// G_INDEXED_LOAD
    0U,	// G_INDEXED_SEXTLOAD
    0U,	// G_INDEXED_ZEXTLOAD
    0U,	// G_STORE
    0U,	// G_INDEXED_STORE
    0U,	// G_ATOMIC_CMPXCHG_WITH_SUCCESS
    0U,	// G_ATOMIC_CMPXCHG
    0U,	// G_ATOMICRMW_XCHG
    0U,	// G_ATOMICRMW_ADD
    0U,	// G_ATOMICRMW_SUB
    0U,	// G_ATOMICRMW_AND
    0U,	// G_ATOMICRMW_NAND
    0U,	// G_ATOMICRMW_OR
    0U,	// G_ATOMICRMW_XOR
    0U,	// G_ATOMICRMW_MAX
    0U,	// G_ATOMICRMW_MIN
    0U,	// G_ATOMICRMW_UMAX
    0U,	// G_ATOMICRMW_UMIN
    0U,	// G_ATOMICRMW_FADD
    0U,	// G_ATOMICRMW_FSUB
    0U,	// G_FENCE
    0U,	// G_BRCOND
    0U,	// G_BRINDIRECT
    0U,	// G_INTRINSIC
    0U,	// G_INTRINSIC_W_SIDE_EFFECTS
    0U,	// G_ANYEXT
    0U,	// G_TRUNC
    0U,	// G_CONSTANT
    0U,	// G_FCONSTANT
    0U,	// G_VASTART
    0U,	// G_VAARG
    0U,	// G_SEXT
    0U,	// G_SEXT_INREG
    0U,	// G_ZEXT
    0U,	// G_SHL
    0U,	// G_LSHR
    0U,	// G_ASHR
    0U,	// G_FSHL
    0U,	// G_FSHR
    0U,	// G_ROTR
    0U,	// G_ROTL
    0U,	// G_ICMP
    0U,	// G_FCMP
    0U,	// G_SELECT
    0U,	// G_UADDO
    0U,	// G_UADDE
    0U,	// G_USUBO
    0U,	// G_USUBE
    0U,	// G_SADDO
    0U,	// G_SADDE
    0U,	// G_SSUBO
    0U,	// G_SSUBE
    0U,	// G_UMULO
    0U,	// G_SMULO
    0U,	// G_UMULH
    0U,	// G_SMULH
    0U,	// G_UADDSAT
    0U,	// G_SADDSAT
    0U,	// G_USUBSAT
    0U,	// G_SSUBSAT
    0U,	// G_USHLSAT
    0U,	// G_SSHLSAT
    0U,	// G_SMULFIX
    0U,	// G_UMULFIX
    0U,	// G_SMULFIXSAT
    0U,	// G_UMULFIXSAT
    0U,	// G_SDIVFIX
    0U,	// G_UDIVFIX
    0U,	// G_SDIVFIXSAT
    0U,	// G_UDIVFIXSAT
    0U,	// G_FADD
    0U,	// G_FSUB
    0U,	// G_FMUL
    0U,	// G_FMA
    0U,	// G_FMAD
    0U,	// G_FDIV
    0U,	// G_FREM
    0U,	// G_FPOW
    0U,	// G_FPOWI
    0U,	// G_FEXP
    0U,	// G_FEXP2
    0U,	// G_FLOG
    0U,	// G_FLOG2
    0U,	// G_FLOG10
    0U,	// G_FNEG
    0U,	// G_FPEXT
    0U,	// G_FPTRUNC
    0U,	// G_FPTOSI
    0U,	// G_FPTOUI
    0U,	// G_SITOFP
    0U,	// G_UITOFP
    0U,	// G_FABS
    0U,	// G_FCOPYSIGN
    0U,	// G_FCANONICALIZE
    0U,	// G_FMINNUM
    0U,	// G_FMAXNUM
    0U,	// G_FMINNUM_IEEE
    0U,	// G_FMAXNUM_IEEE
    0U,	// G_FMINIMUM
    0U,	// G_FMAXIMUM
    0U,	// G_PTR_ADD
    0U,	// G_PTRMASK
    0U,	// G_SMIN
    0U,	// G_SMAX
    0U,	// G_UMIN
    0U,	// G_UMAX
    0U,	// G_ABS
    0U,	// G_LROUND
    0U,	// G_LLROUND
    0U,	// G_BR
    0U,	// G_BRJT
    0U,	// G_INSERT_VECTOR_ELT
    0U,	// G_EXTRACT_VECTOR_ELT
    0U,	// G_SHUFFLE_VECTOR
    0U,	// G_CTTZ
    0U,	// G_CTTZ_ZERO_UNDEF
    0U,	// G_CTLZ
    0U,	// G_CTLZ_ZERO_UNDEF
    0U,	// G_CTPOP
    0U,	// G_BSWAP
    0U,	// G_BITREVERSE
    0U,	// G_FCEIL
    0U,	// G_FCOS
    0U,	// G_FSIN
    0U,	// G_FSQRT
    0U,	// G_FFLOOR
    0U,	// G_FRINT
    0U,	// G_FNEARBYINT
    0U,	// G_ADDRSPACE_CAST
    0U,	// G_BLOCK_ADDR
    0U,	// G_JUMP_TABLE
    0U,	// G_DYN_STACKALLOC
    0U,	// G_STRICT_FADD
    0U,	// G_STRICT_FSUB
    0U,	// G_STRICT_FMUL
    0U,	// G_STRICT_FDIV
    0U,	// G_STRICT_FREM
    0U,	// G_STRICT_FMA
    0U,	// G_STRICT_FSQRT
    0U,	// G_READ_REGISTER
    0U,	// G_WRITE_REGISTER
    0U,	// G_MEMCPY
    0U,	// G_MEMCPY_INLINE
    0U,	// G_MEMMOVE
    0U,	// G_MEMSET
    0U,	// G_BZERO
    0U,	// G_VECREDUCE_SEQ_FADD
    0U,	// G_VECREDUCE_SEQ_FMUL
    0U,	// G_VECREDUCE_FADD
    0U,	// G_VECREDUCE_FMUL
    0U,	// G_VECREDUCE_FMAX
    0U,	// G_VECREDUCE_FMIN
    0U,	// G_VECREDUCE_ADD
    0U,	// G_VECREDUCE_MUL
    0U,	// G_VECREDUCE_AND
    0U,	// G_VECREDUCE_OR
    0U,	// G_VECREDUCE_XOR
    0U,	// G_VECREDUCE_SMAX
    0U,	// G_VECREDUCE_SMIN
    0U,	// G_VECREDUCE_UMAX
    0U,	// G_VECREDUCE_UMIN
    0U,	// G_SBFX
    0U,	// G_UBFX
    0U,	// ADJCALLSTACKDOWN
    0U,	// ADJCALLSTACKUP
    0U,	// MEMCPY
    0U,	// Select
    0U,	// Select_32
    0U,	// Select_32_64
    0U,	// Select_64_32
    0U,	// Select_Ri
    0U,	// Select_Ri_32
    0U,	// Select_Ri_32_64
    0U,	// Select_Ri_64_32
    0U,	// ADD_ri
    0U,	// ADD_ri_32
    0U,	// ADD_rr
    0U,	// ADD_rr_32
    0U,	// AND_ri
    0U,	// AND_ri_32
    0U,	// AND_rr
    0U,	// AND_rr_32
    0U,	// BE16
    0U,	// BE32
    0U,	// BE64
    1U,	// CMPXCHGD
    1U,	// CMPXCHGW32
    1U,	// CORE_ALU32_MEM
    1U,	// CORE_MEM
    1U,	// CORE_SHIFT
    1U,	// DIV_ri
    1U,	// DIV_ri_32
    1U,	// DIV_rr
    1U,	// DIV_rr_32
    9U,	// FI_ri
    1U,	// JAL
    1U,	// JALX
    2U,	// JEQ_ri
    2U,	// JEQ_ri_32
    2U,	// JEQ_rr
    2U,	// JEQ_rr_32
    0U,	// JMP
    2U,	// JNE_ri
    2U,	// JNE_ri_32
    2U,	// JNE_rr
    2U,	// JNE_rr_32
    2U,	// JSGE_ri
    2U,	// JSGE_ri_32
    2U,	// JSGE_rr
    2U,	// JSGE_rr_32
    2U,	// JSGT_ri
    2U,	// JSGT_ri_32
    2U,	// JSGT_rr
    2U,	// JSGT_rr_32
    2U,	// JSLE_ri
    2U,	// JSLE_ri_32
    2U,	// JSLE_rr
    2U,	// JSLE_rr_32
    2U,	// JSLT_ri
    2U,	// JSLT_ri_32
    2U,	// JSLT_rr
    2U,	// JSLT_rr_32
    2U,	// JUGE_ri
    2U,	// JUGE_ri_32
    2U,	// JUGE_rr
    2U,	// JUGE_rr_32
    2U,	// JUGT_ri
    2U,	// JUGT_ri_32
    2U,	// JUGT_rr
    2U,	// JUGT_rr_32
    3U,	// JULE_ri
    3U,	// JULE_ri_32
    3U,	// JULE_rr
    3U,	// JULE_rr_32
    3U,	// JULT_ri
    3U,	// JULT_ri_32
    3U,	// JULT_rr
    3U,	// JULT_rr_32
    3U,	// LDB
    3U,	// LDB32
    3U,	// LDD
    3U,	// LDH
    3U,	// LDH32
    3U,	// LDW
    3U,	// LDW32
    0U,	// LD_ABS_B
    0U,	// LD_ABS_H
    0U,	// LD_ABS_W
    0U,	// LD_IND_B
    0U,	// LD_IND_H
    0U,	// LD_IND_W
    16U,	// LD_imm64
    33U,	// LD_pseudo
    3U,	// LE16
    3U,	// LE32
    4U,	// LE64
    64U,	// MOV_32_64
    64U,	// MOV_ri
    64U,	// MOV_ri_32
    64U,	// MOV_rr
    64U,	// MOV_rr_32
    4U,	// MUL_ri
    4U,	// MUL_ri_32
    4U,	// MUL_rr
    4U,	// MUL_rr_32
    4U,	// NEG_32
    4U,	// NEG_64
    1U,	// NOP
    4U,	// OR_ri
    4U,	// OR_ri_32
    4U,	// OR_rr
    4U,	// OR_rr_32
    0U,	// RET
    4U,	// SLL_ri
    4U,	// SLL_ri_32
    4U,	// SLL_rr
    4U,	// SLL_rr_32
    4U,	// SRA_ri
    4U,	// SRA_ri_32
    4U,	// SRA_rr
    4U,	// SRA_rr_32
    4U,	// SRL_ri
    4U,	// SRL_ri_32
    4U,	// SRL_rr
    4U,	// SRL_rr_32
    4U,	// STB
    4U,	// STB32
    4U,	// STD
    4U,	// STH
    4U,	// STH32
    4U,	// STW
    4U,	// STW32
    5U,	// SUB_ri
    5U,	// SUB_ri_32
    5U,	// SUB_rr
    5U,	// SUB_rr_32
    5U,	// XADDD
    5U,	// XADDW
    5U,	// XADDW32
    5U,	// XANDD
    5U,	// XANDW32
    5U,	// XCHGD
    5U,	// XCHGW32
    5U,	// XFADDD
    5U,	// XFADDW32
    5U,	// XFANDD
    6U,	// XFANDW32
    6U,	// XFORD
    6U,	// XFORW32
    6U,	// XFXORD
    6U,	// XFXORW32
    6U,	// XORD
    6U,	// XORW32
    6U,	// XOR_ri
    6U,	// XOR_ri_32
    6U,	// XOR_rr
    6U,	// XOR_rr_32
    6U,	// XXORD
    6U,	// XXORW32
  };

  // Emit the opcode for the instruction.
  uint32_t Bits = 0;
  Bits |= OpInfo0[MI->getOpcode()] << 0;
  Bits |= OpInfo1[MI->getOpcode()] << 16;
  return {AsmStrs+(Bits & 1023)-1, Bits};

}
/// printInstruction - This method is automatically generated by tablegen
/// from the instruction set description.
LLVM_NO_PROFILE_INSTRUMENT_FUNCTION
void BPFInstPrinter::printInstruction(const MCInst *MI, uint64_t Address, raw_ostream &O) {
  O << "\t";

  auto MnemonicInfo = getMnemonic(MI);

  O << MnemonicInfo.first;

  uint32_t Bits = MnemonicInfo.second;
  assert(Bits != 0 && "Cannot print this instruction.");

  // Fragment 0 encoded into 3 bits for 6 unique commands.
  switch ((Bits >> 10) & 7) {
  default: llvm_unreachable("Invalid command number.");
  case 0:
    // DBG_VALUE, DBG_VALUE_LIST, DBG_INSTR_REF, DBG_PHI, DBG_LABEL, BUNDLE, ...
    return;
    break;
  case 1:
    // ADJCALLSTACKDOWN, ADJCALLSTACKUP, MEMCPY, Select, Select_32, Select_32...
    printOperand(MI, 0, O);
    break;
  case 2:
    // CMPXCHGD, CMPXCHGW32
    printMemOperand(MI, 0, O);
    break;
  case 3:
    // JMP
    printBrTargetOperand(MI, 0, O);
    return;
    break;
  case 4:
    // LD_ABS_B, LD_ABS_H, LD_ABS_W, LD_IND_B, LD_IND_H, LD_IND_W
    printOperand(MI, 1, O);
    O << ']';
    return;
    break;
  case 5:
    // STB, STB32, STD, STH, STH32, STW, STW32, XADDD, XADDW, XADDW32, XANDD,...
    printMemOperand(MI, 1, O);
    break;
  }


  // Fragment 1 encoded into 6 bits for 56 unique commands.
  switch ((Bits >> 13) & 63) {
  default: llvm_unreachable("Invalid command number.");
  case 0:
    // ADJCALLSTACKDOWN, ADJCALLSTACKUP
    O << ' ';
    printOperand(MI, 1, O);
    return;
    break;
  case 1:
    // MEMCPY
    O << ", src: ";
    printOperand(MI, 1, O);
    O << ", len: ";
    printOperand(MI, 2, O);
    O << ", align: ";
    printOperand(MI, 3, O);
    return;
    break;
  case 2:
    // Select, Select_32, Select_32_64, Select_64_32, Select_Ri, Select_Ri_32...
    O << " = ";
    break;
  case 3:
    // ADD_ri, ADD_ri_32, ADD_rr, ADD_rr_32
    O << " += ";
    printOperand(MI, 2, O);
    return;
    break;
  case 4:
    // AND_ri, AND_ri_32, AND_rr, AND_rr_32
    O << " &= ";
    printOperand(MI, 2, O);
    return;
    break;
  case 5:
    // BE16
    O << " = be16 ";
    printOperand(MI, 1, O);
    return;
    break;
  case 6:
    // BE32
    O << " = be32 ";
    printOperand(MI, 1, O);
    return;
    break;
  case 7:
    // BE64
    O << " = be64 ";
    printOperand(MI, 1, O);
    return;
    break;
  case 8:
    // CMPXCHGD
    O << ", r0, ";
    printOperand(MI, 2, O);
    O << ')';
    return;
    break;
  case 9:
    // CMPXCHGW32
    O << ", w0, ";
    printOperand(MI, 2, O);
    O << ')';
    return;
    break;
  case 10:
    // CORE_ALU32_MEM
    O << " = core_alu32_mem(";
    printImm64Operand(MI, 1, O);
    O << ", ";
    printOperand(MI, 2, O);
    O << ", ";
    printImm64Operand(MI, 3, O);
    O << ')';
    return;
    break;
  case 11:
    // CORE_MEM
    O << " = core_mem(";
    printImm64Operand(MI, 1, O);
    O << ", ";
    printOperand(MI, 2, O);
    O << ", ";
    printImm64Operand(MI, 3, O);
    O << ')';
    return;
    break;
  case 12:
    // CORE_SHIFT
    O << " = core_shift(";
    printImm64Operand(MI, 1, O);
    O << ", ";
    printOperand(MI, 2, O);
    O << ", ";
    printImm64Operand(MI, 3, O);
    O << ')';
    return;
    break;
  case 13:
    // DIV_ri, DIV_ri_32, DIV_rr, DIV_rr_32
    O << " /= ";
    printOperand(MI, 2, O);
    return;
    break;
  case 14:
    // FI_ri, LD_pseudo
    O << ", ";
    break;
  case 15:
    // JAL, JALX, NOP
    return;
    break;
  case 16:
    // JEQ_ri, JEQ_ri_32, JEQ_rr, JEQ_rr_32
    O << " == ";
    printOperand(MI, 1, O);
    O << " goto ";
    printBrTargetOperand(MI, 2, O);
    return;
    break;
  case 17:
    // JNE_ri, JNE_ri_32, JNE_rr, JNE_rr_32
    O << " != ";
    printOperand(MI, 1, O);
    O << " goto ";
    printBrTargetOperand(MI, 2, O);
    return;
    break;
  case 18:
    // JSGE_ri, JSGE_ri_32, JSGE_rr, JSGE_rr_32
    O << " s>= ";
    printOperand(MI, 1, O);
    O << " goto ";
    printBrTargetOperand(MI, 2, O);
    return;
    break;
  case 19:
    // JSGT_ri, JSGT_ri_32, JSGT_rr, JSGT_rr_32
    O << " s> ";
    printOperand(MI, 1, O);
    O << " goto ";
    printBrTargetOperand(MI, 2, O);
    return;
    break;
  case 20:
    // JSLE_ri, JSLE_ri_32, JSLE_rr, JSLE_rr_32
    O << " s<= ";
    printOperand(MI, 1, O);
    O << " goto ";
    printBrTargetOperand(MI, 2, O);
    return;
    break;
  case 21:
    // JSLT_ri, JSLT_ri_32, JSLT_rr, JSLT_rr_32
    O << " s< ";
    printOperand(MI, 1, O);
    O << " goto ";
    printBrTargetOperand(MI, 2, O);
    return;
    break;
  case 22:
    // JUGE_ri, JUGE_ri_32, JUGE_rr, JUGE_rr_32
    O << " >= ";
    printOperand(MI, 1, O);
    O << " goto ";
    printBrTargetOperand(MI, 2, O);
    return;
    break;
  case 23:
    // JUGT_ri, JUGT_ri_32, JUGT_rr, JUGT_rr_32
    O << " > ";
    printOperand(MI, 1, O);
    O << " goto ";
    printBrTargetOperand(MI, 2, O);
    return;
    break;
  case 24:
    // JULE_ri, JULE_ri_32, JULE_rr, JULE_rr_32
    O << " <= ";
    printOperand(MI, 1, O);
    O << " goto ";
    printBrTargetOperand(MI, 2, O);
    return;
    break;
  case 25:
    // JULT_ri, JULT_ri_32, JULT_rr, JULT_rr_32
    O << " < ";
    printOperand(MI, 1, O);
    O << " goto ";
    printBrTargetOperand(MI, 2, O);
    return;
    break;
  case 26:
    // LDB, LDB32
    O << " = *(u8 *)(";
    printMemOperand(MI, 1, O);
    O << ')';
    return;
    break;
  case 27:
    // LDD
    O << " = *(u64 *)(";
    printMemOperand(MI, 1, O);
    O << ')';
    return;
    break;
  case 28:
    // LDH, LDH32
    O << " = *(u16 *)(";
    printMemOperand(MI, 1, O);
    O << ')';
    return;
    break;
  case 29:
    // LDW, LDW32
    O << " = *(u32 *)(";
    printMemOperand(MI, 1, O);
    O << ')';
    return;
    break;
  case 30:
    // LE16
    O << " = le16 ";
    printOperand(MI, 1, O);
    return;
    break;
  case 31:
    // LE32
    O << " = le32 ";
    printOperand(MI, 1, O);
    return;
    break;
  case 32:
    // LE64
    O << " = le64 ";
    printOperand(MI, 1, O);
    return;
    break;
  case 33:
    // MUL_ri, MUL_ri_32, MUL_rr, MUL_rr_32
    O << " *= ";
    printOperand(MI, 2, O);
    return;
    break;
  case 34:
    // NEG_32, NEG_64
    O << " = -";
    printOperand(MI, 1, O);
    return;
    break;
  case 35:
    // OR_ri, OR_ri_32, OR_rr, OR_rr_32
    O << " |= ";
    printOperand(MI, 2, O);
    return;
    break;
  case 36:
    // SLL_ri, SLL_ri_32, SLL_rr, SLL_rr_32
    O << " <<= ";
    printOperand(MI, 2, O);
    return;
    break;
  case 37:
    // SRA_ri, SRA_ri_32, SRA_rr, SRA_rr_32
    O << " s>>= ";
    printOperand(MI, 2, O);
    return;
    break;
  case 38:
    // SRL_ri, SRL_ri_32, SRL_rr, SRL_rr_32
    O << " >>= ";
    printOperand(MI, 2, O);
    return;
    break;
  case 39:
    // STB, STB32, STD, STH, STH32, STW, STW32
    O << ") = ";
    printOperand(MI, 0, O);
    return;
    break;
  case 40:
    // SUB_ri, SUB_ri_32, SUB_rr, SUB_rr_32
    O << " -= ";
    printOperand(MI, 2, O);
    return;
    break;
  case 41:
    // XADDD, XADDW, XADDW32
    O << ") += ";
    printOperand(MI, 3, O);
    return;
    break;
  case 42:
    // XANDD, XANDW32
    O << ") &= ";
    printOperand(MI, 3, O);
    return;
    break;
  case 43:
    // XCHGD
    O << " = xchg_64(";
    printMemOperand(MI, 1, O);
    O << ", ";
    printOperand(MI, 3, O);
    O << ')';
    return;
    break;
  case 44:
    // XCHGW32
    O << " = xchg32_32(";
    printMemOperand(MI, 1, O);
    O << ", ";
    printOperand(MI, 3, O);
    O << ')';
    return;
    break;
  case 45:
    // XFADDD
    O << " = atomic_fetch_add((u64 *)(";
    printMemOperand(MI, 1, O);
    O << "), ";
    printOperand(MI, 3, O);
    O << ')';
    return;
    break;
  case 46:
    // XFADDW32
    O << " = atomic_fetch_add((u32 *)(";
    printMemOperand(MI, 1, O);
    O << "), ";
    printOperand(MI, 3, O);
    O << ')';
    return;
    break;
  case 47:
    // XFANDD
    O << " = atomic_fetch_and((u64 *)(";
    printMemOperand(MI, 1, O);
    O << "), ";
    printOperand(MI, 3, O);
    O << ')';
    return;
    break;
  case 48:
    // XFANDW32
    O << " = atomic_fetch_and((u32 *)(";
    printMemOperand(MI, 1, O);
    O << "), ";
    printOperand(MI, 3, O);
    O << ')';
    return;
    break;
  case 49:
    // XFORD
    O << " = atomic_fetch_or((u64 *)(";
    printMemOperand(MI, 1, O);
    O << "), ";
    printOperand(MI, 3, O);
    O << ')';
    return;
    break;
  case 50:
    // XFORW32
    O << " = atomic_fetch_or((u32 *)(";
    printMemOperand(MI, 1, O);
    O << "), ";
    printOperand(MI, 3, O);
    O << ')';
    return;
    break;
  case 51:
    // XFXORD
    O << " = atomic_fetch_xor((u64 *)(";
    printMemOperand(MI, 1, O);
    O << "), ";
    printOperand(MI, 3, O);
    O << ')';
    return;
    break;
  case 52:
    // XFXORW32
    O << " = atomic_fetch_xor((u32 *)(";
    printMemOperand(MI, 1, O);
    O << "), ";
    printOperand(MI, 3, O);
    O << ')';
    return;
    break;
  case 53:
    // XORD, XORW32
    O << ") |= ";
    printOperand(MI, 3, O);
    return;
    break;
  case 54:
    // XOR_ri, XOR_ri_32, XOR_rr, XOR_rr_32
    O << " ^= ";
    printOperand(MI, 2, O);
    return;
    break;
  case 55:
    // XXORD, XXORW32
    O << ") ^= ";
    printOperand(MI, 3, O);
    return;
    break;
  }


  // Fragment 2 encoded into 2 bits for 3 unique commands.
  switch ((Bits >> 19) & 3) {
  default: llvm_unreachable("Invalid command number.");
  case 0:
    // Select, Select_32, Select_32_64, Select_64_32, Select_Ri, Select_Ri_32...
    printOperand(MI, 1, O);
    break;
  case 1:
    // FI_ri
    printMemOperand(MI, 1, O);
    return;
    break;
  case 2:
    // LD_imm64
    printImm64Operand(MI, 1, O);
    O << " ll";
    return;
    break;
  }


  // Fragment 3 encoded into 2 bits for 3 unique commands.
  switch ((Bits >> 21) & 3) {
  default: llvm_unreachable("Invalid command number.");
  case 0:
    // Select, Select_32, Select_32_64, Select_64_32, Select_Ri, Select_Ri_32...
    O << ' ';
    printOperand(MI, 3, O);
    O << ' ';
    printOperand(MI, 2, O);
    O << " ? ";
    printOperand(MI, 4, O);
    O << " : ";
    printOperand(MI, 5, O);
    return;
    break;
  case 1:
    // LD_pseudo
    O << ", ";
    printImm64Operand(MI, 2, O);
    return;
    break;
  case 2:
    // MOV_32_64, MOV_ri, MOV_ri_32, MOV_rr, MOV_rr_32
    return;
    break;
  }

}


/// getRegisterName - This method is automatically generated by tblgen
/// from the register set description.  This returns the assembler name
/// for the specified register.
const char *BPFInstPrinter::getRegisterName(unsigned RegNo) {
  assert(RegNo && RegNo < 25 && "Invalid register number!");


#ifdef __GNUC__
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Woverlength-strings"
#endif
  static const char AsmStrs[] = {
  /* 0 */ "r10\0"
  /* 4 */ "w10\0"
  /* 8 */ "r0\0"
  /* 11 */ "w0\0"
  /* 14 */ "r11\0"
  /* 18 */ "w11\0"
  /* 22 */ "r1\0"
  /* 25 */ "w1\0"
  /* 28 */ "r2\0"
  /* 31 */ "w2\0"
  /* 34 */ "r3\0"
  /* 37 */ "w3\0"
  /* 40 */ "r4\0"
  /* 43 */ "w4\0"
  /* 46 */ "r5\0"
  /* 49 */ "w5\0"
  /* 52 */ "r6\0"
  /* 55 */ "w6\0"
  /* 58 */ "r7\0"
  /* 61 */ "w7\0"
  /* 64 */ "r8\0"
  /* 67 */ "w8\0"
  /* 70 */ "r9\0"
  /* 73 */ "w9\0"
};
#ifdef __GNUC__
#pragma GCC diagnostic pop
#endif

  static const uint8_t RegAsmOffset[] = {
    8, 22, 28, 34, 40, 46, 52, 58, 64, 70, 0, 14, 11, 25, 
    31, 37, 43, 49, 55, 61, 67, 73, 4, 18, 
  };

  assert (*(AsmStrs+RegAsmOffset[RegNo-1]) &&
          "Invalid alt name index for register!");
  return AsmStrs+RegAsmOffset[RegNo-1];
}

#ifdef PRINT_ALIAS_INSTR
#undef PRINT_ALIAS_INSTR

bool BPFInstPrinter::printAliasInstr(const MCInst *MI, uint64_t Address, raw_ostream &OS) {
  return false;
}

#endif // PRINT_ALIAS_INSTR
