/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the ARM target                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 80;
using PredicateBitset = llvm::PredicateBitsetImpl<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(ARMInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(ARMInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ISelInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ISelInfo;
  static ARMInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static ARMInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const int64_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const std::array<const MachineOperand *, 3> &Operands) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ISelInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_NoHonorSignDependentRoundingBit = 71,
  Feature_HasV4TBit = 6,
  Feature_NoV4TBit = 7,
  Feature_HasV5TBit = 13,
  Feature_NoV5TBit = 65,
  Feature_HasV5TEBit = 11,
  Feature_HasV6Bit = 0,
  Feature_NoV6Bit = 9,
  Feature_HasV6MBit = 29,
  Feature_HasV8MBaselineBit = 34,
  Feature_HasV8_1MMainlineBit = 40,
  Feature_HasMVEIntBit = 63,
  Feature_HasMVEFloatBit = 64,
  Feature_HasCDEBit = 79,
  Feature_HasFPRegsBit = 41,
  Feature_HasFPRegs16Bit = 42,
  Feature_HasNoFPRegs16Bit = 70,
  Feature_HasFPRegs64Bit = 51,
  Feature_HasV6T2Bit = 8,
  Feature_HasV6KBit = 19,
  Feature_HasV7Bit = 3,
  Feature_HasV8Bit = 15,
  Feature_PreV8Bit = 20,
  Feature_HasV8_1aBit = 73,
  Feature_HasV8_3aBit = 74,
  Feature_NoVFPBit = 23,
  Feature_HasVFP2Bit = 22,
  Feature_HasVFP3Bit = 52,
  Feature_HasVFP4Bit = 49,
  Feature_HasDPVFPBit = 43,
  Feature_HasFPARMv8Bit = 46,
  Feature_HasNEONBit = 53,
  Feature_HasSHA2Bit = 61,
  Feature_HasAESBit = 54,
  Feature_HasDotProdBit = 55,
  Feature_HasCRCBit = 14,
  Feature_HasLOBBit = 39,
  Feature_HasFP16Bit = 60,
  Feature_HasFullFP16Bit = 45,
  Feature_HasBF16Bit = 62,
  Feature_HasMatMulInt8Bit = 56,
  Feature_HasDivideInThumbBit = 36,
  Feature_HasDivideInARMBit = 12,
  Feature_HasDSPBit = 35,
  Feature_HasDBBit = 16,
  Feature_HasV7ClrexBit = 18,
  Feature_HasAcquireReleaseBit = 17,
  Feature_HasMPBit = 2,
  Feature_Has8MSecExtBit = 30,
  Feature_HasZCZBit = 57,
  Feature_UseNEONForFPBit = 77,
  Feature_DontUseNEONForFPBit = 44,
  Feature_IsThumbBit = 27,
  Feature_IsThumb1OnlyBit = 28,
  Feature_IsThumb2Bit = 33,
  Feature_IsNotMClassBit = 37,
  Feature_IsARMBit = 1,
  Feature_IsWindowsBit = 31,
  Feature_IsNotWindowsBit = 32,
  Feature_IsReadTPHardBit = 68,
  Feature_IsReadTPSoftBit = 21,
  Feature_UseNaClTrapBit = 4,
  Feature_DontUseNaClTrapBit = 5,
  Feature_UseMovtBit = 38,
  Feature_DontUseMovtBit = 24,
  Feature_UseMovtInPicBit = 25,
  Feature_DontUseMovtInPicBit = 26,
  Feature_UseFPVMLxBit = 48,
  Feature_SLSBLRMitigationBit = 67,
  Feature_NoSLSBLRMitigationBit = 66,
  Feature_UseMulOpsBit = 10,
  Feature_UseFusedMACBit = 50,
  Feature_HasFastVGETLNi32Bit = 58,
  Feature_HasSlowVGETLNi32Bit = 75,
  Feature_HasFastVDUP32Bit = 59,
  Feature_HasSlowVDUP32Bit = 76,
  Feature_UseVMOVSRBit = 47,
  Feature_DontUseVMOVSRBit = 78,
  Feature_IsLEBit = 69,
  Feature_IsBEBit = 72,
};

PredicateBitset ARMInstructionSelector::
computeAvailableModuleFeatures(const ARMSubtarget *Subtarget) const {
  PredicateBitset Features;
  if (!TM.Options.HonorSignDependentRoundingFPMath())
    Features.set(Feature_NoHonorSignDependentRoundingBit);
  if (Subtarget->hasV4TOps())
    Features.set(Feature_HasV4TBit);
  if (!Subtarget->hasV4TOps())
    Features.set(Feature_NoV4TBit);
  if (Subtarget->hasV5TOps())
    Features.set(Feature_HasV5TBit);
  if (!Subtarget->hasV5TOps())
    Features.set(Feature_NoV5TBit);
  if (Subtarget->hasV5TEOps())
    Features.set(Feature_HasV5TEBit);
  if (Subtarget->hasV6Ops())
    Features.set(Feature_HasV6Bit);
  if (!Subtarget->hasV6Ops())
    Features.set(Feature_NoV6Bit);
  if (Subtarget->hasV6MOps())
    Features.set(Feature_HasV6MBit);
  if (Subtarget->hasV8MBaselineOps())
    Features.set(Feature_HasV8MBaselineBit);
  if (Subtarget->hasV8_1MMainlineOps())
    Features.set(Feature_HasV8_1MMainlineBit);
  if (Subtarget->hasMVEIntegerOps())
    Features.set(Feature_HasMVEIntBit);
  if (Subtarget->hasMVEFloatOps())
    Features.set(Feature_HasMVEFloatBit);
  if (Subtarget->hasCDEOps())
    Features.set(Feature_HasCDEBit);
  if (Subtarget->hasFPRegs())
    Features.set(Feature_HasFPRegsBit);
  if (Subtarget->hasFPRegs16())
    Features.set(Feature_HasFPRegs16Bit);
  if (!Subtarget->hasFPRegs16())
    Features.set(Feature_HasNoFPRegs16Bit);
  if (Subtarget->hasFPRegs64())
    Features.set(Feature_HasFPRegs64Bit);
  if (Subtarget->hasV6T2Ops())
    Features.set(Feature_HasV6T2Bit);
  if (Subtarget->hasV6KOps())
    Features.set(Feature_HasV6KBit);
  if (Subtarget->hasV7Ops())
    Features.set(Feature_HasV7Bit);
  if (Subtarget->hasV8Ops())
    Features.set(Feature_HasV8Bit);
  if (!Subtarget->hasV8Ops())
    Features.set(Feature_PreV8Bit);
  if (Subtarget->hasV8_1aOps())
    Features.set(Feature_HasV8_1aBit);
  if (Subtarget->hasV8_3aOps())
    Features.set(Feature_HasV8_3aBit);
  if (!Subtarget->hasVFP2Base())
    Features.set(Feature_NoVFPBit);
  if (Subtarget->hasVFP2Base())
    Features.set(Feature_HasVFP2Bit);
  if (Subtarget->hasVFP3Base())
    Features.set(Feature_HasVFP3Bit);
  if (Subtarget->hasVFP4Base())
    Features.set(Feature_HasVFP4Bit);
  if (Subtarget->hasFP64())
    Features.set(Feature_HasDPVFPBit);
  if (Subtarget->hasFPARMv8Base())
    Features.set(Feature_HasFPARMv8Bit);
  if (Subtarget->hasNEON())
    Features.set(Feature_HasNEONBit);
  if (Subtarget->hasSHA2())
    Features.set(Feature_HasSHA2Bit);
  if (Subtarget->hasAES())
    Features.set(Feature_HasAESBit);
  if (Subtarget->hasDotProd())
    Features.set(Feature_HasDotProdBit);
  if (Subtarget->hasCRC())
    Features.set(Feature_HasCRCBit);
  if (Subtarget->hasLOB())
    Features.set(Feature_HasLOBBit);
  if (Subtarget->hasFP16())
    Features.set(Feature_HasFP16Bit);
  if (Subtarget->hasFullFP16())
    Features.set(Feature_HasFullFP16Bit);
  if (Subtarget->hasBF16())
    Features.set(Feature_HasBF16Bit);
  if (Subtarget->hasMatMulInt8())
    Features.set(Feature_HasMatMulInt8Bit);
  if (Subtarget->hasDivideInThumbMode())
    Features.set(Feature_HasDivideInThumbBit);
  if (Subtarget->hasDivideInARMMode())
    Features.set(Feature_HasDivideInARMBit);
  if (Subtarget->hasDSP())
    Features.set(Feature_HasDSPBit);
  if (Subtarget->hasDataBarrier())
    Features.set(Feature_HasDBBit);
  if (Subtarget->hasV7Clrex())
    Features.set(Feature_HasV7ClrexBit);
  if (Subtarget->hasAcquireRelease())
    Features.set(Feature_HasAcquireReleaseBit);
  if (Subtarget->hasMPExtension())
    Features.set(Feature_HasMPBit);
  if (Subtarget->has8MSecExt())
    Features.set(Feature_Has8MSecExtBit);
  if (Subtarget->hasZeroCycleZeroing())
    Features.set(Feature_HasZCZBit);
  if (Subtarget->useNEONForSinglePrecisionFP())
    Features.set(Feature_UseNEONForFPBit);
  if (!Subtarget->useNEONForSinglePrecisionFP())
    Features.set(Feature_DontUseNEONForFPBit);
  if (Subtarget->isThumb())
    Features.set(Feature_IsThumbBit);
  if (Subtarget->isThumb1Only())
    Features.set(Feature_IsThumb1OnlyBit);
  if (Subtarget->isThumb2())
    Features.set(Feature_IsThumb2Bit);
  if (!Subtarget->isMClass())
    Features.set(Feature_IsNotMClassBit);
  if (!Subtarget->isThumb())
    Features.set(Feature_IsARMBit);
  if (Subtarget->isTargetWindows())
    Features.set(Feature_IsWindowsBit);
  if (!Subtarget->isTargetWindows())
    Features.set(Feature_IsNotWindowsBit);
  if (Subtarget->isReadTPHard())
    Features.set(Feature_IsReadTPHardBit);
  if (!Subtarget->isReadTPHard())
    Features.set(Feature_IsReadTPSoftBit);
  if (Subtarget->useNaClTrap())
    Features.set(Feature_UseNaClTrapBit);
  if (!Subtarget->useNaClTrap())
    Features.set(Feature_DontUseNaClTrapBit);
  if (Subtarget->useMulOps())
    Features.set(Feature_UseMulOpsBit);
  if (TM.Options.AllowFPOpFusion ==  FPOpFusion::Fast && Subtarget->useFPVFMx())
    Features.set(Feature_UseFusedMACBit);
  if (!Subtarget->hasSlowVGETLNi32())
    Features.set(Feature_HasFastVGETLNi32Bit);
  if (Subtarget->hasSlowVGETLNi32())
    Features.set(Feature_HasSlowVGETLNi32Bit);
  if (!Subtarget->hasSlowVDUP32())
    Features.set(Feature_HasFastVDUP32Bit);
  if (Subtarget->hasSlowVDUP32())
    Features.set(Feature_HasSlowVDUP32Bit);
  if (Subtarget->preferVMOVSR() ||!Subtarget->useNEONForSinglePrecisionFP())
    Features.set(Feature_UseVMOVSRBit);
  if (!Subtarget->preferVMOVSR() &&Subtarget->useNEONForSinglePrecisionFP())
    Features.set(Feature_DontUseVMOVSRBit);
  return Features;
}

void ARMInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const ARMSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset ARMInstructionSelector::
computeAvailableFunctionFeatures(const ARMSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  if (Subtarget->useMovt())
    Features.set(Feature_UseMovtBit);
  if (!Subtarget->useMovt())
    Features.set(Feature_DontUseMovtBit);
  if (Subtarget->useMovt() && Subtarget->allowPositionIndependentMovt())
    Features.set(Feature_UseMovtInPicBit);
  if (!Subtarget->useMovt() || !Subtarget->allowPositionIndependentMovt())
    Features.set(Feature_DontUseMovtInPicBit);
  if (((Subtarget->useFPVMLx() &&  TM.Options.AllowFPOpFusion != FPOpFusion::Fast) ||Subtarget->hasMinSize()))
    Features.set(Feature_UseFPVMLxBit);
  if ( MF->getSubtarget<ARMSubtarget>().hardenSlsBlr() )
    Features.set(Feature_SLSBLRMitigationBit);
  if ( !MF->getSubtarget<ARMSubtarget>().hardenSlsBlr() )
    Features.set(Feature_NoSLSBLRMitigationBit);
  if (MF->getDataLayout().isLittleEndian())
    Features.set(Feature_IsLEBit);
  if (MF->getDataLayout().isBigEndian())
    Features.set(Feature_IsBEBit);
  return Features;
}

// LLT Objects.
enum {
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s1,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v4s1,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v4s64,
  GILLT_v8s1,
  GILLT_v8s8,
  GILLT_v8s16,
  GILLT_v8s64,
  GILLT_v16s1,
  GILLT_v16s8,
};
const static size_t NumTypeObjects = 16;
const static LLT TypeObjects[] = {
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getFixed(2), 1),
  LLT::vector(ElementCount::getFixed(2), 32),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 1),
  LLT::vector(ElementCount::getFixed(4), 16),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(4), 64),
  LLT::vector(ElementCount::getFixed(8), 1),
  LLT::vector(ElementCount::getFixed(8), 8),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(8), 64),
  LLT::vector(ElementCount::getFixed(16), 1),
  LLT::vector(ElementCount::getFixed(16), 8),
};

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasDotProd,
  GIFBS_HasFP16,
  GIFBS_HasFPARMv8,
  GIFBS_HasFPRegs,
  GIFBS_HasFullFP16,
  GIFBS_HasMVEFloat,
  GIFBS_HasMVEInt,
  GIFBS_HasMatMulInt8,
  GIFBS_HasNEON,
  GIFBS_HasVFP2,
  GIFBS_HasVFP3,
  GIFBS_HasVFP4,
  GIFBS_IsARM,
  GIFBS_IsThumb,
  GIFBS_IsThumb2,
  GIFBS_NoHonorSignDependentRounding,
  GIFBS_DontUseNEONForFP_HasVFP2,
  GIFBS_DontUseVMOVSR_HasNEON,
  GIFBS_Has8MSecExt_IsThumb,
  GIFBS_HasAES_HasV8,
  GIFBS_HasBF16_HasNEON,
  GIFBS_HasDB_IsARM,
  GIFBS_HasDB_IsThumb,
  GIFBS_HasDPVFP_HasFPARMv8,
  GIFBS_HasDPVFP_HasVFP2,
  GIFBS_HasDPVFP_HasVFP3,
  GIFBS_HasDPVFP_HasVFP4,
  GIFBS_HasDPVFP_NoHonorSignDependentRounding,
  GIFBS_HasDSP_IsThumb2,
  GIFBS_HasDivideInARM_IsARM,
  GIFBS_HasFP16_HasNEON,
  GIFBS_HasFPRegs_UseVMOVSR,
  GIFBS_HasFullFP16_HasNEON,
  GIFBS_HasMVEInt_HasV8_1MMainline,
  GIFBS_HasMVEInt_IsBE,
  GIFBS_HasMVEInt_IsLE,
  GIFBS_HasNEON_HasV8,
  GIFBS_HasNEON_HasV8_1a,
  GIFBS_HasNEON_HasV8_3a,
  GIFBS_HasNEON_HasVFP4,
  GIFBS_HasNEON_IsBE,
  GIFBS_HasNEON_IsLE,
  GIFBS_HasNEON_UseNEONForFP,
  GIFBS_HasSHA2_HasV8,
  GIFBS_HasV5T_IsARM,
  GIFBS_HasV5TE_IsARM,
  GIFBS_HasV6_IsARM,
  GIFBS_HasV6K_IsARM,
  GIFBS_HasV6M_IsThumb,
  GIFBS_HasV6T2_IsARM,
  GIFBS_HasV7_IsARM,
  GIFBS_HasV7Clrex_IsThumb,
  GIFBS_HasV8MBaseline_IsThumb,
  GIFBS_IsARM_NoV6,
  GIFBS_IsARM_PreV8,
  GIFBS_IsThumb_IsThumb1Only,
  GIFBS_IsThumb_IsWindows,
  GIFBS_IsThumb_UseMovt,
  GIFBS_IsThumb2_PreV8,
  GIFBS_IsThumb2_UseMulOps,
  GIFBS_HasCRC_HasV8_IsARM,
  GIFBS_HasCRC_HasV8_IsThumb2,
  GIFBS_HasDSP_IsThumb2_UseMulOps,
  GIFBS_HasDivideInThumb_HasV8MBaseline_IsThumb,
  GIFBS_HasFullFP16_HasNEON_HasV8,
  GIFBS_HasFullFP16_HasNEON_HasV8_3a,
  GIFBS_HasFullFP16_HasNEON_UseFPVMLx,
  GIFBS_HasFullFP16_HasNEON_UseFusedMAC,
  GIFBS_HasLOB_HasV8_1MMainline_IsThumb2,
  GIFBS_HasNEON_UseFPVMLx_UseNEONForFP,
  GIFBS_HasV5TE_IsARM_UseMulOps,
  GIFBS_HasV6_IsARM_UseMulOps,
  GIFBS_HasV6_IsThumb_IsThumb1Only,
  GIFBS_HasV6T2_IsARM_UseMulOps,
  GIFBS_HasVFP4_UseFusedMAC_UseNEONForFP,
  GIFBS_IsARM_NoV6_UseMulOps,
};
const static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasDotProdBit, },
  {Feature_HasFP16Bit, },
  {Feature_HasFPARMv8Bit, },
  {Feature_HasFPRegsBit, },
  {Feature_HasFullFP16Bit, },
  {Feature_HasMVEFloatBit, },
  {Feature_HasMVEIntBit, },
  {Feature_HasMatMulInt8Bit, },
  {Feature_HasNEONBit, },
  {Feature_HasVFP2Bit, },
  {Feature_HasVFP3Bit, },
  {Feature_HasVFP4Bit, },
  {Feature_IsARMBit, },
  {Feature_IsThumbBit, },
  {Feature_IsThumb2Bit, },
  {Feature_NoHonorSignDependentRoundingBit, },
  {Feature_DontUseNEONForFPBit, Feature_HasVFP2Bit, },
  {Feature_DontUseVMOVSRBit, Feature_HasNEONBit, },
  {Feature_Has8MSecExtBit, Feature_IsThumbBit, },
  {Feature_HasAESBit, Feature_HasV8Bit, },
  {Feature_HasBF16Bit, Feature_HasNEONBit, },
  {Feature_HasDBBit, Feature_IsARMBit, },
  {Feature_HasDBBit, Feature_IsThumbBit, },
  {Feature_HasDPVFPBit, Feature_HasFPARMv8Bit, },
  {Feature_HasDPVFPBit, Feature_HasVFP2Bit, },
  {Feature_HasDPVFPBit, Feature_HasVFP3Bit, },
  {Feature_HasDPVFPBit, Feature_HasVFP4Bit, },
  {Feature_HasDPVFPBit, Feature_NoHonorSignDependentRoundingBit, },
  {Feature_HasDSPBit, Feature_IsThumb2Bit, },
  {Feature_HasDivideInARMBit, Feature_IsARMBit, },
  {Feature_HasFP16Bit, Feature_HasNEONBit, },
  {Feature_HasFPRegsBit, Feature_UseVMOVSRBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, },
  {Feature_HasMVEIntBit, Feature_HasV8_1MMainlineBit, },
  {Feature_HasMVEIntBit, Feature_IsBEBit, },
  {Feature_HasMVEIntBit, Feature_IsLEBit, },
  {Feature_HasNEONBit, Feature_HasV8Bit, },
  {Feature_HasNEONBit, Feature_HasV8_1aBit, },
  {Feature_HasNEONBit, Feature_HasV8_3aBit, },
  {Feature_HasNEONBit, Feature_HasVFP4Bit, },
  {Feature_HasNEONBit, Feature_IsBEBit, },
  {Feature_HasNEONBit, Feature_IsLEBit, },
  {Feature_HasNEONBit, Feature_UseNEONForFPBit, },
  {Feature_HasSHA2Bit, Feature_HasV8Bit, },
  {Feature_HasV5TBit, Feature_IsARMBit, },
  {Feature_HasV5TEBit, Feature_IsARMBit, },
  {Feature_HasV6Bit, Feature_IsARMBit, },
  {Feature_HasV6KBit, Feature_IsARMBit, },
  {Feature_HasV6MBit, Feature_IsThumbBit, },
  {Feature_HasV6T2Bit, Feature_IsARMBit, },
  {Feature_HasV7Bit, Feature_IsARMBit, },
  {Feature_HasV7ClrexBit, Feature_IsThumbBit, },
  {Feature_HasV8MBaselineBit, Feature_IsThumbBit, },
  {Feature_IsARMBit, Feature_NoV6Bit, },
  {Feature_IsARMBit, Feature_PreV8Bit, },
  {Feature_IsThumbBit, Feature_IsThumb1OnlyBit, },
  {Feature_IsThumbBit, Feature_IsWindowsBit, },
  {Feature_IsThumbBit, Feature_UseMovtBit, },
  {Feature_IsThumb2Bit, Feature_PreV8Bit, },
  {Feature_IsThumb2Bit, Feature_UseMulOpsBit, },
  {Feature_HasCRCBit, Feature_HasV8Bit, Feature_IsARMBit, },
  {Feature_HasCRCBit, Feature_HasV8Bit, Feature_IsThumb2Bit, },
  {Feature_HasDSPBit, Feature_IsThumb2Bit, Feature_UseMulOpsBit, },
  {Feature_HasDivideInThumbBit, Feature_HasV8MBaselineBit, Feature_IsThumbBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_HasV8Bit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_HasV8_3aBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_UseFPVMLxBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_UseFusedMACBit, },
  {Feature_HasLOBBit, Feature_HasV8_1MMainlineBit, Feature_IsThumb2Bit, },
  {Feature_HasNEONBit, Feature_UseFPVMLxBit, Feature_UseNEONForFPBit, },
  {Feature_HasV5TEBit, Feature_IsARMBit, Feature_UseMulOpsBit, },
  {Feature_HasV6Bit, Feature_IsARMBit, Feature_UseMulOpsBit, },
  {Feature_HasV6Bit, Feature_IsThumbBit, Feature_IsThumb1OnlyBit, },
  {Feature_HasV6T2Bit, Feature_IsARMBit, Feature_UseMulOpsBit, },
  {Feature_HasVFP4Bit, Feature_UseFusedMACBit, Feature_UseNEONForFPBit, },
  {Feature_IsARMBit, Feature_NoV6Bit, Feature_UseMulOpsBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

// PatFrag predicates.
enum {
  GIPFP_I64_Predicate_VectorIndex16 = GIPFP_I64_Invalid + 1,
  GIPFP_I64_Predicate_VectorIndex32,
  GIPFP_I64_Predicate_VectorIndex64,
  GIPFP_I64_Predicate_VectorIndex8,
  GIPFP_I64_Predicate_asr_imm,
  GIPFP_I64_Predicate_imm0_15,
  GIPFP_I64_Predicate_imm0_239,
  GIPFP_I64_Predicate_imm0_255,
  GIPFP_I64_Predicate_imm0_31,
  GIPFP_I64_Predicate_imm0_32,
  GIPFP_I64_Predicate_imm0_4095,
  GIPFP_I64_Predicate_imm0_63,
  GIPFP_I64_Predicate_imm0_65535,
  GIPFP_I64_Predicate_imm0_65535_neg,
  GIPFP_I64_Predicate_imm0_7,
  GIPFP_I64_Predicate_imm16,
  GIPFP_I64_Predicate_imm16_31,
  GIPFP_I64_Predicate_imm1_15,
  GIPFP_I64_Predicate_imm1_16,
  GIPFP_I64_Predicate_imm1_31,
  GIPFP_I64_Predicate_imm1_7,
  GIPFP_I64_Predicate_imm24b,
  GIPFP_I64_Predicate_imm256_510,
  GIPFP_I64_Predicate_imm32,
  GIPFP_I64_Predicate_imm8,
  GIPFP_I64_Predicate_imm8_255,
  GIPFP_I64_Predicate_imm8_or_16,
  GIPFP_I64_Predicate_imm_11b,
  GIPFP_I64_Predicate_imm_12b,
  GIPFP_I64_Predicate_imm_13b,
  GIPFP_I64_Predicate_imm_3b,
  GIPFP_I64_Predicate_imm_4b,
  GIPFP_I64_Predicate_imm_6b,
  GIPFP_I64_Predicate_imm_7b,
  GIPFP_I64_Predicate_imm_9b,
  GIPFP_I64_Predicate_imm_even,
  GIPFP_I64_Predicate_imm_odd,
  GIPFP_I64_Predicate_long_shift,
  GIPFP_I64_Predicate_mod_imm,
  GIPFP_I64_Predicate_pkh_asr_amt,
  GIPFP_I64_Predicate_pkh_lsl_amt,
  GIPFP_I64_Predicate_shr_imm16,
  GIPFP_I64_Predicate_shr_imm32,
  GIPFP_I64_Predicate_shr_imm64,
  GIPFP_I64_Predicate_shr_imm8,
  GIPFP_I64_Predicate_t2_so_imm,
  GIPFP_I64_Predicate_t2_so_imm_neg,
};
bool ARMInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GIPFP_I64_Predicate_VectorIndex16: {
    
  return ((uint64_t)Imm) < 4;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndex32: {
    
  return ((uint64_t)Imm) < 2;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndex64: {
    
  return ((uint64_t)Imm) < 1;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndex8: {
    
  return ((uint64_t)Imm) < 8;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_asr_imm: {
     return Imm > 0 && Imm <= 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_15: {
    
  return Imm >= 0 && Imm < 16;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_239: {
     return Imm >= 0 && Imm < 240; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_255: {
     return Imm >= 0 && Imm < 256; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_31: {
    
  return Imm >= 0 && Imm < 32;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_32: {
    
  return Imm >= 0 && Imm < 33;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_4095: {
    
  return Imm >= 0 && Imm < 4096;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_63: {
    
  return Imm >= 0 && Imm < 64;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_65535: {
    
  return Imm >= 0 && Imm < 65536;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_65535_neg: {
    
  return -Imm >= 0 && -Imm < 65536;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_7: {
    
  return Imm >= 0 && Imm < 8;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm16: {
     return Imm == 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm16_31: {
    
  return (int32_t)Imm >= 16 && (int32_t)Imm < 32;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm1_15: {
     return Imm > 0 && Imm < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm1_16: {
    
    return Imm > 0 && Imm <= 16;
  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm1_31: {
     return Imm > 0 && Imm < 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm1_7: {
     return Imm > 0 && Imm < 8; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm24b: {
    
  return Imm >= 0 && Imm <= 0xffffff;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm256_510: {
    
  return Imm >= 256 && Imm < 511;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm32: {
     return Imm == 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm8: {
     return Imm == 8; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm8_255: {
    
  return Imm >= 8 && Imm < 256;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm8_or_16: {
     return Imm == 8 || Imm == 16;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm_11b: {
    { return Imm >= 0 && Imm < (1 << 11); }
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm_12b: {
    { return Imm >= 0 && Imm < (1 << 12); }
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm_13b: {
    { return Imm >= 0 && Imm < (1 << 13); }
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm_3b: {
    { return Imm >= 0 && Imm < (1 << 3); }
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm_4b: {
    { return Imm >= 0 && Imm < (1 << 4); }
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm_6b: {
    { return Imm >= 0 && Imm < (1 << 6); }
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm_7b: {
    { return Imm >= 0 && Imm < (1 << 7); }
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm_9b: {
    { return Imm >= 0 && Imm < (1 << 9); }
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm_even: {
     return (Imm & 1) == 0; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm_odd: {
     return (Imm & 1) == 1; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_long_shift: {
     return Imm > 0 && Imm <= 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_mod_imm: {
    
    return ARM_AM::getSOImmVal(Imm) != -1;
  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_pkh_asr_amt: {
     return Imm > 0 && Imm <= 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_pkh_lsl_amt: {
     return Imm >= 0 && Imm < 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_shr_imm16: {
     return Imm > 0 && Imm <= 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_shr_imm32: {
     return Imm > 0 && Imm <= 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_shr_imm64: {
     return Imm > 0 && Imm <= 64; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_shr_imm8: {
     return Imm > 0 && Imm <= 8; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_t2_so_imm: {
    
    return ARM_AM::getT2SOImmVal(Imm) != -1;
  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_t2_so_imm_neg: {
    
  return Imm && ARM_AM::getT2SOImmVal(-(uint32_t)Imm) != -1;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool ARMInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GIPFP_APInt_Predicate_arm_i32imm = GIPFP_APInt_Invalid + 1,
};
bool ARMInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GIPFP_APInt_Predicate_arm_i32imm: {
    
  if (Subtarget->useMovt())
    return true;
  if (ARM_AM::isSOImmTwoPartVal(Imm.getZExtValue()))
    return true;
  return ARM_AM::isSOImmTwoPartValNeg(Imm.getZExtValue());

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GIPFP_MI_Predicate_bf_inv_mask_imm = GIPFP_MI_Invalid + 1,
  GIPFP_MI_Predicate_vfp_f32imm,
  GIPFP_MI_Predicate_vfp_f64imm,
};
bool ARMInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const std::array<const MachineOperand *, 3> &Operands) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  (void)MRI;
  switch (PredicateID) {
  case GIPFP_MI_Predicate_bf_inv_mask_imm: {
    
    // There's better methods of implementing this check. IntImmLeaf<> would be
    // equivalent and have less boilerplate but we need a test for C++
    // predicates and this one causes new rules to be imported into GlobalISel
    // without requiring additional features first.
    const auto &MO = MI.getOperand(1);
    if (!MO.isCImm())
      return false;
    return ARM::isBitFieldInvertedMask(MO.getCImm()->getZExtValue());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_vfp_f32imm: {
    
      const auto &MO = MI.getOperand(1);
      if (!MO.isFPImm())
        return false;
      return ARM_AM::getFP32Imm(MO.getFPImm()->getValueAPF()) != -1;
    
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_vfp_f64imm: {
    
      const auto &MO = MI.getOperand(1);
      if (!MO.isFPImm())
        return false;
      return ARM_AM::getFP64Imm(MO.getFPImm()->getValueAPF()) != -1;
    
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}

ARMInstructionSelector::ComplexMatcherMemFn
ARMInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderVFPF32Imm,
  GICR_renderVFPF64Imm,
};
ARMInstructionSelector::CustomRendererFn
ARMInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &ARMInstructionSelector::renderVFPF32Imm,
  &ARMInstructionSelector::renderVFPF64Imm,
};

bool ARMInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  MachineFunction &MF = *I.getParent()->getParent();
  MachineRegisterInfo &MRI = MF.getRegInfo();
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  NewMIVector OutMIs;
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, OutMIs, State, ISelInfo, getMatchTable(), TII, MRI, TRI, RBI, AvailableFeatures, CoverageInfo)) {
    return true;
  }

  return false;
}

const int64_t *ARMInstructionSelector::getMatchTable() const {
  constexpr static int64_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/45, 208, /*)*//*default:*//*Label 62*/ 128000,
    /*TargetOpcode::G_ADD*//*Label 0*/ 168,
    /*TargetOpcode::G_SUB*//*Label 1*/ 8376,
    /*TargetOpcode::G_MUL*//*Label 2*/ 11417,
    /*TargetOpcode::G_SDIV*//*Label 3*/ 12262,
    /*TargetOpcode::G_UDIV*//*Label 4*/ 12364, 0, 0, 0, 0,
    /*TargetOpcode::G_AND*//*Label 5*/ 12466,
    /*TargetOpcode::G_OR*//*Label 6*/ 15226,
    /*TargetOpcode::G_XOR*//*Label 7*/ 20466, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_CONCAT_VECTORS*//*Label 8*/ 21984, 0, 0,
    /*TargetOpcode::G_BITCAST*//*Label 9*/ 22378, 0,
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 10*/ 33288,
    /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 11*/ 33544, 0, 0, 0, 0,
    /*TargetOpcode::G_SEXTLOAD*//*Label 12*/ 33752, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_INTRINSIC*//*Label 13*/ 33898,
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 14*/ 94647,
    /*TargetOpcode::G_ANYEXT*//*Label 15*/ 103092,
    /*TargetOpcode::G_TRUNC*//*Label 16*/ 103227,
    /*TargetOpcode::G_CONSTANT*//*Label 17*/ 103362,
    /*TargetOpcode::G_FCONSTANT*//*Label 18*/ 103559, 0, 0,
    /*TargetOpcode::G_SEXT*//*Label 19*/ 103638, 0,
    /*TargetOpcode::G_ZEXT*//*Label 20*/ 103773,
    /*TargetOpcode::G_SHL*//*Label 21*/ 104295,
    /*TargetOpcode::G_LSHR*//*Label 22*/ 104404,
    /*TargetOpcode::G_ASHR*//*Label 23*/ 104464, 0, 0,
    /*TargetOpcode::G_ROTR*//*Label 24*/ 104682, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_UMULH*//*Label 25*/ 104950,
    /*TargetOpcode::G_SMULH*//*Label 26*/ 105175,
    /*TargetOpcode::G_UADDSAT*//*Label 27*/ 105505,
    /*TargetOpcode::G_SADDSAT*//*Label 28*/ 106134,
    /*TargetOpcode::G_USUBSAT*//*Label 29*/ 107401,
    /*TargetOpcode::G_SSUBSAT*//*Label 30*/ 108030, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FADD*//*Label 31*/ 109025,
    /*TargetOpcode::G_FSUB*//*Label 32*/ 111171,
    /*TargetOpcode::G_FMUL*//*Label 33*/ 112729,
    /*TargetOpcode::G_FMA*//*Label 34*/ 113667, 0,
    /*TargetOpcode::G_FDIV*//*Label 35*/ 115368, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FNEG*//*Label 36*/ 115534,
    /*TargetOpcode::G_FPEXT*//*Label 37*/ 116852,
    /*TargetOpcode::G_FPTRUNC*//*Label 38*/ 117012,
    /*TargetOpcode::G_FPTOSI*//*Label 39*/ 117176,
    /*TargetOpcode::G_FPTOUI*//*Label 40*/ 118415,
    /*TargetOpcode::G_SITOFP*//*Label 41*/ 119654,
    /*TargetOpcode::G_UITOFP*//*Label 42*/ 120236,
    /*TargetOpcode::G_FABS*//*Label 43*/ 120818, 0, 0,
    /*TargetOpcode::G_FMINNUM*//*Label 44*/ 121418,
    /*TargetOpcode::G_FMAXNUM*//*Label 45*/ 121938, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_SMIN*//*Label 46*/ 122458,
    /*TargetOpcode::G_SMAX*//*Label 47*/ 122981,
    /*TargetOpcode::G_UMIN*//*Label 48*/ 123504,
    /*TargetOpcode::G_UMAX*//*Label 49*/ 124393,
    /*TargetOpcode::G_ABS*//*Label 50*/ 125282, 0, 0,
    /*TargetOpcode::G_BR*//*Label 51*/ 125711, 0, 0,
    /*TargetOpcode::G_EXTRACT_VECTOR_ELT*//*Label 52*/ 125775, 0, 0, 0,
    /*TargetOpcode::G_CTLZ*//*Label 53*/ 125856, 0,
    /*TargetOpcode::G_CTPOP*//*Label 54*/ 126364,
    /*TargetOpcode::G_BSWAP*//*Label 55*/ 126456,
    /*TargetOpcode::G_BITREVERSE*//*Label 56*/ 126704,
    /*TargetOpcode::G_FCEIL*//*Label 57*/ 127068, 0, 0,
    /*TargetOpcode::G_FSQRT*//*Label 58*/ 127276,
    /*TargetOpcode::G_FFLOOR*//*Label 59*/ 127406,
    /*TargetOpcode::G_FRINT*//*Label 60*/ 127614,
    /*TargetOpcode::G_FNEARBYINT*//*Label 61*/ 127870,
    // Label 0: @168
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 16, /*)*//*default:*//*Label 72*/ 8375,
    /*GILLT_s32*//*Label 63*/ 189,
    /*GILLT_s64*//*Label 64*/ 2172, 0,
    /*GILLT_v2s32*//*Label 65*/ 2224,
    /*GILLT_v2s64*//*Label 66*/ 2691, 0,
    /*GILLT_v4s16*//*Label 67*/ 3719,
    /*GILLT_v4s32*//*Label 68*/ 4186, 0, 0,
    /*GILLT_v8s8*//*Label 69*/ 5771,
    /*GILLT_v8s16*//*Label 70*/ 6238, 0, 0,
    /*GILLT_v16s8*//*Label 71*/ 7823,
    // Label 63: @189
    GIM_Try, /*On fail goto*//*Label 73*/ 2171,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 74*/ 266, // Rule ID 5709 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (UXTAB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5709,
        GIR_Done,
      // Label 74: @266
      GIM_Try, /*On fail goto*//*Label 75*/ 333, // Rule ID 5710 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (UXTAH:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5710,
        GIR_Done,
      // Label 75: @333
      GIM_Try, /*On fail goto*//*Label 76*/ 400, // Rule ID 5744 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2UXTAB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5744,
        GIR_Done,
      // Label 76: @400
      GIM_Try, /*On fail goto*//*Label 77*/ 467, // Rule ID 5745 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2UXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5745,
        GIR_Done,
      // Label 77: @467
      GIM_Try, /*On fail goto*//*Label 78*/ 534, // Rule ID 2014 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }))  =>  (UXTAB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2014,
        GIR_Done,
      // Label 78: @534
      GIM_Try, /*On fail goto*//*Label 79*/ 601, // Rule ID 2015 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }))  =>  (UXTAH:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2015,
        GIR_Done,
      // Label 79: @601
      GIM_Try, /*On fail goto*//*Label 80*/ 668, // Rule ID 2238 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }))  =>  (t2UXTAB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTAB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2238,
        GIR_Done,
      // Label 80: @668
      GIM_Try, /*On fail goto*//*Label 81*/ 735, // Rule ID 2239 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }))  =>  (t2UXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTAH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2239,
        GIR_Done,
      // Label 81: @735
      GIM_Try, /*On fail goto*//*Label 82*/ 845, // Rule ID 5488 //
        GIM_CheckFeatures, GIFBS_HasV5TE_IsARM_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i32] } (mul:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 16:{ *:[i32] })), GPR:{ *:[i32] }:$Ra)  =>  (SMLATT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SMLATT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5488,
        GIR_Done,
      // Label 82: @845
      GIM_Try, /*On fail goto*//*Label 83*/ 955, // Rule ID 5525 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i32] } (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] })), rGPR:{ *:[i32] }:$Ra)  =>  (t2SMLATT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SMLATT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5525,
        GIR_Done,
      // Label 83: @955
      GIM_Try, /*On fail goto*//*Label 84*/ 1065, // Rule ID 192 //
        GIM_CheckFeatures, GIFBS_HasV5TE_IsARM_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 16:{ *:[i32] })))  =>  (SMLATT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SMLATT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 192,
        GIR_Done,
      // Label 84: @1065
      GIM_Try, /*On fail goto*//*Label 85*/ 1175, // Rule ID 528 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] })))  =>  (t2SMLATT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SMLATT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 528,
        GIR_Done,
      // Label 85: @1175
      GIM_Try, /*On fail goto*//*Label 86*/ 1229, // Rule ID 72 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (ADDri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::ADDri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 72,
        GIR_Done,
      // Label 86: @1229
      GIM_Try, /*On fail goto*//*Label 87*/ 1283, // Rule ID 414 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2ADDri:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ADDri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 414,
        GIR_Done,
      // Label 87: @1283
      GIM_Try, /*On fail goto*//*Label 88*/ 1333, // Rule ID 415 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_imm0_4095,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_imm0_4095>>:$imm)  =>  (t2ADDri12:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ADDri12,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 415,
        GIR_Done,
      // Label 88: @1333
      GIM_Try, /*On fail goto*//*Label 89*/ 1405, // Rule ID 171 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm), GPRnopc:{ *:[i32] }:$Ra)  =>  (MLA:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 171,
        GIR_Done,
      // Label 89: @1405
      GIM_Try, /*On fail goto*//*Label 90*/ 1477, // Rule ID 172 //
        GIM_CheckFeatures, GIFBS_IsARM_NoV6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm), GPRnopc:{ *:[i32] }:$Ra)  =>  (MLAv5:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MLAv5,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 172,
        GIR_Done,
      // Label 90: @1477
      GIM_Try, /*On fail goto*//*Label 91*/ 1545, // Rule ID 510 //
        GIM_CheckFeatures, GIFBS_IsThumb2_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm), rGPR:{ *:[i32] }:$Ra)  =>  (t2MLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 510,
        GIR_Done,
      // Label 91: @1545
      GIM_Try, /*On fail goto*//*Label 92*/ 1613, // Rule ID 180 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SMULH,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (mulhs:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm), GPR:{ *:[i32] }:$Ra)  =>  (SMMLA:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SMMLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 180,
        GIR_Done,
      // Label 92: @1613
      GIM_Try, /*On fail goto*//*Label 93*/ 1681, // Rule ID 516 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SMULH,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (mulhs:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn), rGPR:{ *:[i32] }:$Ra)  =>  (t2SMMLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SMMLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 516,
        GIR_Done,
      // Label 93: @1681
      GIM_Try, /*On fail goto*//*Label 94*/ 1753, // Rule ID 5482 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Ra, (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm))  =>  (MLA:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5482,
        GIR_Done,
      // Label 94: @1753
      GIM_Try, /*On fail goto*//*Label 95*/ 1825, // Rule ID 5483 //
        GIM_CheckFeatures, GIFBS_IsARM_NoV6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Ra, (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm))  =>  (MLAv5:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MLAv5,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5483,
        GIR_Done,
      // Label 95: @1825
      GIM_Try, /*On fail goto*//*Label 96*/ 1893, // Rule ID 5520 //
        GIM_CheckFeatures, GIFBS_IsThumb2_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm))  =>  (t2MLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5520,
        GIR_Done,
      // Label 96: @1893
      GIM_Try, /*On fail goto*//*Label 97*/ 1961, // Rule ID 5484 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SMULH,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mulhs:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm))  =>  (SMMLA:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SMMLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5484,
        GIR_Done,
      // Label 97: @1961
      GIM_Try, /*On fail goto*//*Label 98*/ 2029, // Rule ID 5521 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SMULH,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mulhs:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn))  =>  (t2SMMLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SMMLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5521,
        GIR_Done,
      // Label 98: @2029
      GIM_Try, /*On fail goto*//*Label 99*/ 2076, // Rule ID 73 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (ADDrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::ADDrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 73,
        GIR_Done,
      // Label 99: @2076
      GIM_Try, /*On fail goto*//*Label 100*/ 2123, // Rule ID 416 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2ADDrr:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ADDrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 416,
        GIR_Done,
      // Label 100: @2123
      GIM_Try, /*On fail goto*//*Label 101*/ 2170, // Rule ID 5502 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)  =>  (t2ADDrr:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ADDrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5502,
        GIR_Done,
      // Label 101: @2170
      GIM_Reject,
    // Label 73: @2171
    GIM_Reject,
    // Label 64: @2172
    GIM_Try, /*On fail goto*//*Label 102*/ 2223, // Rule ID 778 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (add:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VADDv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv1i64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 778,
      GIR_Done,
    // Label 102: @2223
    GIM_Reject,
    // Label 65: @2224
    GIM_Try, /*On fail goto*//*Label 103*/ 2690,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 104*/ 2309, // Rule ID 5641 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 2257:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm), DPR:{ *:[v2i32] }:$src1)  =>  (VABAsv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5641,
        GIR_Done,
      // Label 104: @2309
      GIM_Try, /*On fail goto*//*Label 105*/ 2380, // Rule ID 5647 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 2258:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm), DPR:{ *:[v2i32] }:$src1)  =>  (VABAuv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5647,
        GIR_Done,
      // Label 105: @2380
      GIM_Try, /*On fail goto*//*Label 106*/ 2451, // Rule ID 1199 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (intrinsic_wo_chain:{ *:[v2i32] } 2257:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VABAsv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1199,
        GIR_Done,
      // Label 106: @2451
      GIM_Try, /*On fail goto*//*Label 107*/ 2522, // Rule ID 1205 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (intrinsic_wo_chain:{ *:[v2i32] } 2258:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VABAuv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1205,
        GIR_Done,
      // Label 107: @2522
      GIM_Try, /*On fail goto*//*Label 108*/ 2586, // Rule ID 5571 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm), DPR:{ *:[v2i32] }:$src1)  =>  (VMLAv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5571,
        GIR_Done,
      // Label 108: @2586
      GIM_Try, /*On fail goto*//*Label 109*/ 2650, // Rule ID 905 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VMLAv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 905,
        GIR_Done,
      // Label 109: @2650
      GIM_Try, /*On fail goto*//*Label 110*/ 2689, // Rule ID 774 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VADDv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 774,
        GIR_Done,
      // Label 110: @2689
      GIM_Reject,
    // Label 103: @2690
    GIM_Reject,
    // Label 66: @2691
    GIM_Try, /*On fail goto*//*Label 111*/ 3718,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 112*/ 2789, // Rule ID 5653 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 2257:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)), QPR:{ *:[v2i64] }:$src1)  =>  (VABALsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5653,
        GIR_Done,
      // Label 112: @2789
      GIM_Try, /*On fail goto*//*Label 113*/ 2873, // Rule ID 5656 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 2258:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)), QPR:{ *:[v2i64] }:$src1)  =>  (VABALuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5656,
        GIR_Done,
      // Label 113: @2873
      GIM_Try, /*On fail goto*//*Label 114*/ 2957, // Rule ID 1211 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 2257:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)))  =>  (VABALsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1211,
        GIR_Done,
      // Label 114: @2957
      GIM_Try, /*On fail goto*//*Label 115*/ 3041, // Rule ID 1214 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 2258:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)))  =>  (VABALuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1214,
        GIR_Done,
      // Label 115: @3041
      GIM_Try, /*On fail goto*//*Label 116*/ 3106, // Rule ID 798 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 798,
        GIR_Done,
      // Label 116: @3106
      GIM_Try, /*On fail goto*//*Label 117*/ 3171, // Rule ID 797 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 797,
        GIR_Done,
      // Label 117: @3171
      GIM_Try, /*On fail goto*//*Label 118*/ 3236, // Rule ID 786 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLsv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 786,
        GIR_Done,
      // Label 118: @3236
      GIM_Try, /*On fail goto*//*Label 119*/ 3301, // Rule ID 796 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 796,
        GIR_Done,
      // Label 119: @3301
      GIM_Try, /*On fail goto*//*Label 120*/ 3366, // Rule ID 795 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 795,
        GIR_Done,
      // Label 120: @3366
      GIM_Try, /*On fail goto*//*Label 121*/ 3418, // Rule ID 5550 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm), QPR:{ *:[v2i64] }:$Vn)  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5550,
        GIR_Done,
      // Label 121: @3418
      GIM_Try, /*On fail goto*//*Label 122*/ 3470, // Rule ID 5544 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm), QPR:{ *:[v2i64] }:$Vn)  =>  (VADDWsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5544,
        GIR_Done,
      // Label 122: @3470
      GIM_Try, /*On fail goto*//*Label 123*/ 3522, // Rule ID 5549 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm), QPR:{ *:[v2i64] }:$Vn)  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5549,
        GIR_Done,
      // Label 123: @3522
      GIM_Try, /*On fail goto*//*Label 124*/ 3574, // Rule ID 807 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 807,
        GIR_Done,
      // Label 124: @3574
      GIM_Try, /*On fail goto*//*Label 125*/ 3626, // Rule ID 801 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDWsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 801,
        GIR_Done,
      // Label 125: @3626
      GIM_Try, /*On fail goto*//*Label 126*/ 3678, // Rule ID 806 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 806,
        GIR_Done,
      // Label 126: @3678
      GIM_Try, /*On fail goto*//*Label 127*/ 3717, // Rule ID 779 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VADDv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 779,
        GIR_Done,
      // Label 127: @3717
      GIM_Reject,
    // Label 111: @3718
    GIM_Reject,
    // Label 67: @3719
    GIM_Try, /*On fail goto*//*Label 128*/ 4185,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 129*/ 3804, // Rule ID 5640 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 2257:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm), DPR:{ *:[v4i16] }:$src1)  =>  (VABAsv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5640,
        GIR_Done,
      // Label 129: @3804
      GIM_Try, /*On fail goto*//*Label 130*/ 3875, // Rule ID 5646 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 2258:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm), DPR:{ *:[v4i16] }:$src1)  =>  (VABAuv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5646,
        GIR_Done,
      // Label 130: @3875
      GIM_Try, /*On fail goto*//*Label 131*/ 3946, // Rule ID 1198 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (intrinsic_wo_chain:{ *:[v4i16] } 2257:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VABAsv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1198,
        GIR_Done,
      // Label 131: @3946
      GIM_Try, /*On fail goto*//*Label 132*/ 4017, // Rule ID 1204 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (intrinsic_wo_chain:{ *:[v4i16] } 2258:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VABAuv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1204,
        GIR_Done,
      // Label 132: @4017
      GIM_Try, /*On fail goto*//*Label 133*/ 4081, // Rule ID 5570 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm), DPR:{ *:[v4i16] }:$src1)  =>  (VMLAv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5570,
        GIR_Done,
      // Label 133: @4081
      GIM_Try, /*On fail goto*//*Label 134*/ 4145, // Rule ID 904 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VMLAv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 904,
        GIR_Done,
      // Label 134: @4145
      GIM_Try, /*On fail goto*//*Label 135*/ 4184, // Rule ID 773 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VADDv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 773,
        GIR_Done,
      // Label 135: @4184
      GIM_Reject,
    // Label 128: @4185
    GIM_Reject,
    // Label 68: @4186
    GIM_Try, /*On fail goto*//*Label 136*/ 5770,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 137*/ 4284, // Rule ID 5652 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 2257:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)), QPR:{ *:[v4i32] }:$src1)  =>  (VABALsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5652,
        GIR_Done,
      // Label 137: @4284
      GIM_Try, /*On fail goto*//*Label 138*/ 4372, // Rule ID 5655 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 2258:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)), QPR:{ *:[v4i32] }:$src1)  =>  (VABALuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5655,
        GIR_Done,
      // Label 138: @4372
      GIM_Try, /*On fail goto*//*Label 139*/ 4460, // Rule ID 1210 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 2257:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)))  =>  (VABALsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1210,
        GIR_Done,
      // Label 139: @4460
      GIM_Try, /*On fail goto*//*Label 140*/ 4548, // Rule ID 1213 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 2258:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)))  =>  (VABALuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1213,
        GIR_Done,
      // Label 140: @4548
      GIM_Try, /*On fail goto*//*Label 141*/ 4623, // Rule ID 5644 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 2257:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm), QPR:{ *:[v4i32] }:$src1)  =>  (VABAsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5644,
        GIR_Done,
      // Label 141: @4623
      GIM_Try, /*On fail goto*//*Label 142*/ 4698, // Rule ID 5650 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 2258:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm), QPR:{ *:[v4i32] }:$src1)  =>  (VABAuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5650,
        GIR_Done,
      // Label 142: @4698
      GIM_Try, /*On fail goto*//*Label 143*/ 4773, // Rule ID 1202 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (intrinsic_wo_chain:{ *:[v4i32] } 2257:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VABAsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1202,
        GIR_Done,
      // Label 143: @4773
      GIM_Try, /*On fail goto*//*Label 144*/ 4848, // Rule ID 1208 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (intrinsic_wo_chain:{ *:[v4i32] } 2258:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VABAuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1208,
        GIR_Done,
      // Label 144: @4848
      GIM_Try, /*On fail goto*//*Label 145*/ 4917, // Rule ID 794 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 794,
        GIR_Done,
      // Label 145: @4917
      GIM_Try, /*On fail goto*//*Label 146*/ 4986, // Rule ID 793 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 793,
        GIR_Done,
      // Label 146: @4986
      GIM_Try, /*On fail goto*//*Label 147*/ 5055, // Rule ID 785 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLsv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 785,
        GIR_Done,
      // Label 147: @5055
      GIM_Try, /*On fail goto*//*Label 148*/ 5124, // Rule ID 792 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 792,
        GIR_Done,
      // Label 148: @5124
      GIM_Try, /*On fail goto*//*Label 149*/ 5193, // Rule ID 791 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 791,
        GIR_Done,
      // Label 149: @5193
      GIM_Try, /*On fail goto*//*Label 150*/ 5261, // Rule ID 5574 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm), QPR:{ *:[v4i32] }:$src1)  =>  (VMLAv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5574,
        GIR_Done,
      // Label 150: @5261
      GIM_Try, /*On fail goto*//*Label 151*/ 5317, // Rule ID 5548 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm), QPR:{ *:[v4i32] }:$Vn)  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5548,
        GIR_Done,
      // Label 151: @5317
      GIM_Try, /*On fail goto*//*Label 152*/ 5373, // Rule ID 5543 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm), QPR:{ *:[v4i32] }:$Vn)  =>  (VADDWsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5543,
        GIR_Done,
      // Label 152: @5373
      GIM_Try, /*On fail goto*//*Label 153*/ 5429, // Rule ID 5547 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm), QPR:{ *:[v4i32] }:$Vn)  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5547,
        GIR_Done,
      // Label 153: @5429
      GIM_Try, /*On fail goto*//*Label 154*/ 5497, // Rule ID 908 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VMLAv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 908,
        GIR_Done,
      // Label 154: @5497
      GIM_Try, /*On fail goto*//*Label 155*/ 5553, // Rule ID 805 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 805,
        GIR_Done,
      // Label 155: @5553
      GIM_Try, /*On fail goto*//*Label 156*/ 5609, // Rule ID 800 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDWsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 800,
        GIR_Done,
      // Label 156: @5609
      GIM_Try, /*On fail goto*//*Label 157*/ 5665, // Rule ID 804 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 804,
        GIR_Done,
      // Label 157: @5665
      GIM_Try, /*On fail goto*//*Label 158*/ 5708, // Rule ID 777 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VADDv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 777,
        GIR_Done,
      // Label 158: @5708
      GIM_Try, /*On fail goto*//*Label 159*/ 5769, // Rule ID 3578 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (add:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VADDi32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VADDi32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3578,
        GIR_Done,
      // Label 159: @5769
      GIM_Reject,
    // Label 136: @5770
    GIM_Reject,
    // Label 69: @5771
    GIM_Try, /*On fail goto*//*Label 160*/ 6237,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 161*/ 5856, // Rule ID 5639 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } (intrinsic_wo_chain:{ *:[v8i8] } 2257:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm), DPR:{ *:[v8i8] }:$src1)  =>  (VABAsv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5639,
        GIR_Done,
      // Label 161: @5856
      GIM_Try, /*On fail goto*//*Label 162*/ 5927, // Rule ID 5645 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } (intrinsic_wo_chain:{ *:[v8i8] } 2258:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm), DPR:{ *:[v8i8] }:$src1)  =>  (VABAuv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5645,
        GIR_Done,
      // Label 162: @5927
      GIM_Try, /*On fail goto*//*Label 163*/ 5998, // Rule ID 1197 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (intrinsic_wo_chain:{ *:[v8i8] } 2257:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VABAsv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1197,
        GIR_Done,
      // Label 163: @5998
      GIM_Try, /*On fail goto*//*Label 164*/ 6069, // Rule ID 1203 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (intrinsic_wo_chain:{ *:[v8i8] } 2258:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VABAuv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1203,
        GIR_Done,
      // Label 164: @6069
      GIM_Try, /*On fail goto*//*Label 165*/ 6133, // Rule ID 5569 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm), DPR:{ *:[v8i8] }:$src1)  =>  (VMLAv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5569,
        GIR_Done,
      // Label 165: @6133
      GIM_Try, /*On fail goto*//*Label 166*/ 6197, // Rule ID 903 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VMLAv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 903,
        GIR_Done,
      // Label 166: @6197
      GIM_Try, /*On fail goto*//*Label 167*/ 6236, // Rule ID 772 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VADDv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 772,
        GIR_Done,
      // Label 167: @6236
      GIM_Reject,
    // Label 160: @6237
    GIM_Reject,
    // Label 70: @6238
    GIM_Try, /*On fail goto*//*Label 168*/ 7822,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 169*/ 6336, // Rule ID 5651 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 2257:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)), QPR:{ *:[v8i16] }:$src1)  =>  (VABALsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5651,
        GIR_Done,
      // Label 169: @6336
      GIM_Try, /*On fail goto*//*Label 170*/ 6424, // Rule ID 5654 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 2258:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)), QPR:{ *:[v8i16] }:$src1)  =>  (VABALuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5654,
        GIR_Done,
      // Label 170: @6424
      GIM_Try, /*On fail goto*//*Label 171*/ 6512, // Rule ID 1209 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 2257:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)))  =>  (VABALsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1209,
        GIR_Done,
      // Label 171: @6512
      GIM_Try, /*On fail goto*//*Label 172*/ 6600, // Rule ID 1212 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 2258:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)))  =>  (VABALuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABALuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1212,
        GIR_Done,
      // Label 172: @6600
      GIM_Try, /*On fail goto*//*Label 173*/ 6675, // Rule ID 5643 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 2257:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm), QPR:{ *:[v8i16] }:$src1)  =>  (VABAsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5643,
        GIR_Done,
      // Label 173: @6675
      GIM_Try, /*On fail goto*//*Label 174*/ 6750, // Rule ID 5649 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 2258:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm), QPR:{ *:[v8i16] }:$src1)  =>  (VABAuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5649,
        GIR_Done,
      // Label 174: @6750
      GIM_Try, /*On fail goto*//*Label 175*/ 6825, // Rule ID 1201 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (intrinsic_wo_chain:{ *:[v8i16] } 2257:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VABAsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1201,
        GIR_Done,
      // Label 175: @6825
      GIM_Try, /*On fail goto*//*Label 176*/ 6900, // Rule ID 1207 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (intrinsic_wo_chain:{ *:[v8i16] } 2258:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VABAuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1207,
        GIR_Done,
      // Label 176: @6900
      GIM_Try, /*On fail goto*//*Label 177*/ 6969, // Rule ID 790 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 790,
        GIR_Done,
      // Label 177: @6969
      GIM_Try, /*On fail goto*//*Label 178*/ 7038, // Rule ID 789 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 789,
        GIR_Done,
      // Label 178: @7038
      GIM_Try, /*On fail goto*//*Label 179*/ 7107, // Rule ID 784 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLsv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 784,
        GIR_Done,
      // Label 179: @7107
      GIM_Try, /*On fail goto*//*Label 180*/ 7176, // Rule ID 788 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 788,
        GIR_Done,
      // Label 180: @7176
      GIM_Try, /*On fail goto*//*Label 181*/ 7245, // Rule ID 787 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDLuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 787,
        GIR_Done,
      // Label 181: @7245
      GIM_Try, /*On fail goto*//*Label 182*/ 7313, // Rule ID 5573 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm), QPR:{ *:[v8i16] }:$src1)  =>  (VMLAv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5573,
        GIR_Done,
      // Label 182: @7313
      GIM_Try, /*On fail goto*//*Label 183*/ 7369, // Rule ID 5546 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm), QPR:{ *:[v8i16] }:$Vn)  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5546,
        GIR_Done,
      // Label 183: @7369
      GIM_Try, /*On fail goto*//*Label 184*/ 7425, // Rule ID 5542 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm), QPR:{ *:[v8i16] }:$Vn)  =>  (VADDWsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5542,
        GIR_Done,
      // Label 184: @7425
      GIM_Try, /*On fail goto*//*Label 185*/ 7481, // Rule ID 5545 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm), QPR:{ *:[v8i16] }:$Vn)  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5545,
        GIR_Done,
      // Label 185: @7481
      GIM_Try, /*On fail goto*//*Label 186*/ 7549, // Rule ID 907 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VMLAv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 907,
        GIR_Done,
      // Label 186: @7549
      GIM_Try, /*On fail goto*//*Label 187*/ 7605, // Rule ID 803 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 803,
        GIR_Done,
      // Label 187: @7605
      GIM_Try, /*On fail goto*//*Label 188*/ 7661, // Rule ID 799 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDWsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 799,
        GIR_Done,
      // Label 188: @7661
      GIM_Try, /*On fail goto*//*Label 189*/ 7717, // Rule ID 802 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDWuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 802,
        GIR_Done,
      // Label 189: @7717
      GIM_Try, /*On fail goto*//*Label 190*/ 7760, // Rule ID 776 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VADDv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 776,
        GIR_Done,
      // Label 190: @7760
      GIM_Try, /*On fail goto*//*Label 191*/ 7821, // Rule ID 3574 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (add:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VADDi16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VADDi16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3574,
        GIR_Done,
      // Label 191: @7821
      GIM_Reject,
    // Label 168: @7822
    GIM_Reject,
    // Label 71: @7823
    GIM_Try, /*On fail goto*//*Label 192*/ 8374,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 193*/ 7908, // Rule ID 5642 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (intrinsic_wo_chain:{ *:[v16i8] } 2257:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm), QPR:{ *:[v16i8] }:$src1)  =>  (VABAsv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5642,
        GIR_Done,
      // Label 193: @7908
      GIM_Try, /*On fail goto*//*Label 194*/ 7983, // Rule ID 5648 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (intrinsic_wo_chain:{ *:[v16i8] } 2258:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm), QPR:{ *:[v16i8] }:$src1)  =>  (VABAuv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5648,
        GIR_Done,
      // Label 194: @7983
      GIM_Try, /*On fail goto*//*Label 195*/ 8058, // Rule ID 1200 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabds,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (intrinsic_wo_chain:{ *:[v16i8] } 2257:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VABAsv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1200,
        GIR_Done,
      // Label 195: @8058
      GIM_Try, /*On fail goto*//*Label 196*/ 8133, // Rule ID 1206 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_neon_vabdu,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (intrinsic_wo_chain:{ *:[v16i8] } 2258:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VABAuv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VABAuv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1206,
        GIR_Done,
      // Label 196: @8133
      GIM_Try, /*On fail goto*//*Label 197*/ 8201, // Rule ID 5572 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm), QPR:{ *:[v16i8] }:$src1)  =>  (VMLAv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5572,
        GIR_Done,
      // Label 197: @8201
      GIM_Try, /*On fail goto*//*Label 198*/ 8269, // Rule ID 906 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VMLAv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 906,
        GIR_Done,
      // Label 198: @8269
      GIM_Try, /*On fail goto*//*Label 199*/ 8312, // Rule ID 775 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VADDv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VADDv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 775,
        GIR_Done,
      // Label 199: @8312
      GIM_Try, /*On fail goto*//*Label 200*/ 8373, // Rule ID 3570 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (add:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VADDi8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VADDi8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3570,
        GIR_Done,
      // Label 200: @8373
      GIM_Reject,
    // Label 192: @8374
    GIM_Reject,
    // Label 72: @8375
    GIM_Reject,
    // Label 1: @8376
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 16, /*)*//*default:*//*Label 210*/ 11416,
    /*GILLT_s32*//*Label 201*/ 8397,
    /*GILLT_s64*//*Label 202*/ 8905, 0,
    /*GILLT_v2s32*//*Label 203*/ 8957,
    /*GILLT_v2s64*//*Label 204*/ 9072, 0,
    /*GILLT_v4s16*//*Label 205*/ 9608,
    /*GILLT_v4s32*//*Label 206*/ 9723, 0, 0,
    /*GILLT_v8s8*//*Label 207*/ 10420,
    /*GILLT_v8s16*//*Label 208*/ 10535, 0, 0,
    /*GILLT_v16s8*//*Label 209*/ 11232,
    // Label 201: @8397
    GIM_Try, /*On fail goto*//*Label 211*/ 8904,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 212*/ 8461, // Rule ID 96 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm, GPR:{ *:[i32] }:$Rn)  =>  (RSBri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::RSBri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 96,
        GIR_Done,
      // Label 212: @8461
      GIM_Try, /*On fail goto*//*Label 213*/ 8515, // Rule ID 434 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, rGPR:{ *:[i32] }:$Rn)  =>  (t2RSBri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2RSBri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 434,
        GIR_Done,
      // Label 213: @8515
      GIM_Try, /*On fail goto*//*Label 214*/ 8569, // Rule ID 76 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (SUBri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SUBri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 76,
        GIR_Done,
      // Label 214: @8569
      GIM_Try, /*On fail goto*//*Label 215*/ 8623, // Rule ID 418 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2SUBri:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SUBri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 418,
        GIR_Done,
      // Label 215: @8623
      GIM_Try, /*On fail goto*//*Label 216*/ 8673, // Rule ID 419 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_imm0_4095,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_imm0_4095>>:$imm)  =>  (t2SUBri12:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SUBri12,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 419,
        GIR_Done,
      // Label 216: @8673
      GIM_Try, /*On fail goto*//*Label 217*/ 8741, // Rule ID 173 //
        GIM_CheckFeatures, GIFBS_HasV6T2_IsARM_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm))  =>  (MLS:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MLS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 173,
        GIR_Done,
      // Label 217: @8741
      GIM_Try, /*On fail goto*//*Label 218*/ 8809, // Rule ID 511 //
        GIM_CheckFeatures, GIFBS_IsThumb2_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm))  =>  (t2MLS:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MLS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 511,
        GIR_Done,
      // Label 218: @8809
      GIM_Try, /*On fail goto*//*Label 219*/ 8856, // Rule ID 77 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (SUBrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SUBrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 77,
        GIR_Done,
      // Label 219: @8856
      GIM_Try, /*On fail goto*//*Label 220*/ 8903, // Rule ID 420 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (sub:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SUBrr:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SUBrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 420,
        GIR_Done,
      // Label 220: @8903
      GIM_Reject,
    // Label 211: @8904
    GIM_Reject,
    // Label 202: @8905
    GIM_Try, /*On fail goto*//*Label 221*/ 8956, // Rule ID 982 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (sub:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VSUBv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv1i64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 982,
      GIR_Done,
    // Label 221: @8956
    GIM_Reject,
    // Label 203: @8957
    GIM_Try, /*On fail goto*//*Label 222*/ 9071,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 223*/ 9035, // Rule ID 933 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VMLSv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLSv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 933,
        GIR_Done,
      // Label 223: @9035
      GIM_Try, /*On fail goto*//*Label 224*/ 9070, // Rule ID 978 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (sub:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VSUBv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 978,
        GIR_Done,
      // Label 224: @9070
      GIM_Reject,
    // Label 222: @9071
    GIM_Reject,
    // Label 204: @9072
    GIM_Try, /*On fail goto*//*Label 225*/ 9607,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 226*/ 9151, // Rule ID 1002 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1002,
        GIR_Done,
      // Label 226: @9151
      GIM_Try, /*On fail goto*//*Label 227*/ 9216, // Rule ID 1001 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1001,
        GIR_Done,
      // Label 227: @9216
      GIM_Try, /*On fail goto*//*Label 228*/ 9281, // Rule ID 990 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLsv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 990,
        GIR_Done,
      // Label 228: @9281
      GIM_Try, /*On fail goto*//*Label 229*/ 9346, // Rule ID 1000 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1000,
        GIR_Done,
      // Label 229: @9346
      GIM_Try, /*On fail goto*//*Label 230*/ 9411, // Rule ID 999 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 999,
        GIR_Done,
      // Label 230: @9411
      GIM_Try, /*On fail goto*//*Label 231*/ 9463, // Rule ID 1011 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBWuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1011,
        GIR_Done,
      // Label 231: @9463
      GIM_Try, /*On fail goto*//*Label 232*/ 9515, // Rule ID 1005 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBWsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBWsv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1005,
        GIR_Done,
      // Label 232: @9515
      GIM_Try, /*On fail goto*//*Label 233*/ 9567, // Rule ID 1010 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBWuv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1010,
        GIR_Done,
      // Label 233: @9567
      GIM_Try, /*On fail goto*//*Label 234*/ 9606, // Rule ID 983 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VSUBv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 983,
        GIR_Done,
      // Label 234: @9606
      GIM_Reject,
    // Label 225: @9607
    GIM_Reject,
    // Label 205: @9608
    GIM_Try, /*On fail goto*//*Label 235*/ 9722,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 236*/ 9686, // Rule ID 932 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VMLSv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLSv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 932,
        GIR_Done,
      // Label 236: @9686
      GIM_Try, /*On fail goto*//*Label 237*/ 9721, // Rule ID 977 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (sub:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VSUBv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 977,
        GIR_Done,
      // Label 237: @9721
      GIM_Reject,
    // Label 235: @9722
    GIM_Reject,
    // Label 206: @9723
    GIM_Try, /*On fail goto*//*Label 238*/ 10419,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 239*/ 9802, // Rule ID 998 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 998,
        GIR_Done,
      // Label 239: @9802
      GIM_Try, /*On fail goto*//*Label 240*/ 9871, // Rule ID 997 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 997,
        GIR_Done,
      // Label 240: @9871
      GIM_Try, /*On fail goto*//*Label 241*/ 9940, // Rule ID 989 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLsv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 989,
        GIR_Done,
      // Label 241: @9940
      GIM_Try, /*On fail goto*//*Label 242*/ 10009, // Rule ID 996 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 996,
        GIR_Done,
      // Label 242: @10009
      GIM_Try, /*On fail goto*//*Label 243*/ 10078, // Rule ID 995 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 995,
        GIR_Done,
      // Label 243: @10078
      GIM_Try, /*On fail goto*//*Label 244*/ 10146, // Rule ID 936 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VMLSv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLSv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 936,
        GIR_Done,
      // Label 244: @10146
      GIM_Try, /*On fail goto*//*Label 245*/ 10202, // Rule ID 1009 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBWuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1009,
        GIR_Done,
      // Label 245: @10202
      GIM_Try, /*On fail goto*//*Label 246*/ 10258, // Rule ID 1004 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBWsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBWsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1004,
        GIR_Done,
      // Label 246: @10258
      GIM_Try, /*On fail goto*//*Label 247*/ 10314, // Rule ID 1008 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBWuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1008,
        GIR_Done,
      // Label 247: @10314
      GIM_Try, /*On fail goto*//*Label 248*/ 10357, // Rule ID 981 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VSUBv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 981,
        GIR_Done,
      // Label 248: @10357
      GIM_Try, /*On fail goto*//*Label 249*/ 10418, // Rule ID 3590 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (sub:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VSUBi32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VSUBi32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3590,
        GIR_Done,
      // Label 249: @10418
      GIM_Reject,
    // Label 238: @10419
    GIM_Reject,
    // Label 207: @10420
    GIM_Try, /*On fail goto*//*Label 250*/ 10534,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 251*/ 10498, // Rule ID 931 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VMLSv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLSv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 931,
        GIR_Done,
      // Label 251: @10498
      GIM_Try, /*On fail goto*//*Label 252*/ 10533, // Rule ID 976 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (sub:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VSUBv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 976,
        GIR_Done,
      // Label 252: @10533
      GIM_Reject,
    // Label 250: @10534
    GIM_Reject,
    // Label 208: @10535
    GIM_Try, /*On fail goto*//*Label 253*/ 11231,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 254*/ 10614, // Rule ID 994 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 994,
        GIR_Done,
      // Label 254: @10614
      GIM_Try, /*On fail goto*//*Label 255*/ 10683, // Rule ID 993 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 993,
        GIR_Done,
      // Label 255: @10683
      GIM_Try, /*On fail goto*//*Label 256*/ 10752, // Rule ID 988 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLsv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 988,
        GIR_Done,
      // Label 256: @10752
      GIM_Try, /*On fail goto*//*Label 257*/ 10821, // Rule ID 992 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 992,
        GIR_Done,
      // Label 257: @10821
      GIM_Try, /*On fail goto*//*Label 258*/ 10890, // Rule ID 991 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBLuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 991,
        GIR_Done,
      // Label 258: @10890
      GIM_Try, /*On fail goto*//*Label 259*/ 10958, // Rule ID 935 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VMLSv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLSv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 935,
        GIR_Done,
      // Label 259: @10958
      GIM_Try, /*On fail goto*//*Label 260*/ 11014, // Rule ID 1007 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBWuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1007,
        GIR_Done,
      // Label 260: @11014
      GIM_Try, /*On fail goto*//*Label 261*/ 11070, // Rule ID 1003 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBWsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBWsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1003,
        GIR_Done,
      // Label 261: @11070
      GIM_Try, /*On fail goto*//*Label 262*/ 11126, // Rule ID 1006 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBWuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1006,
        GIR_Done,
      // Label 262: @11126
      GIM_Try, /*On fail goto*//*Label 263*/ 11169, // Rule ID 980 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VSUBv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 980,
        GIR_Done,
      // Label 263: @11169
      GIM_Try, /*On fail goto*//*Label 264*/ 11230, // Rule ID 3586 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (sub:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VSUBi16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VSUBi16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3586,
        GIR_Done,
      // Label 264: @11230
      GIM_Reject,
    // Label 253: @11231
    GIM_Reject,
    // Label 209: @11232
    GIM_Try, /*On fail goto*//*Label 265*/ 11415,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 266*/ 11310, // Rule ID 934 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VMLSv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMLSv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 934,
        GIR_Done,
      // Label 266: @11310
      GIM_Try, /*On fail goto*//*Label 267*/ 11353, // Rule ID 979 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (sub:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VSUBv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VSUBv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 979,
        GIR_Done,
      // Label 267: @11353
      GIM_Try, /*On fail goto*//*Label 268*/ 11414, // Rule ID 3582 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (sub:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VSUBi8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VSUBi8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3582,
        GIR_Done,
      // Label 268: @11414
      GIM_Reject,
    // Label 265: @11415
    GIM_Reject,
    // Label 210: @11416
    GIM_Reject,
    // Label 2: @11417
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 16, /*)*//*default:*//*Label 276*/ 12261,
    /*GILLT_s32*//*Label 269*/ 11438, 0, 0,
    /*GILLT_v2s32*//*Label 270*/ 11757, 0, 0,
    /*GILLT_v4s16*//*Label 271*/ 11809,
    /*GILLT_v4s32*//*Label 272*/ 11861, 0, 0,
    /*GILLT_v8s8*//*Label 273*/ 11977,
    /*GILLT_v8s16*//*Label 274*/ 12029, 0, 0,
    /*GILLT_v16s8*//*Label 275*/ 12145,
    // Label 269: @11438
    GIM_Try, /*On fail goto*//*Label 277*/ 11756,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 278*/ 11533, // Rule ID 186 //
        GIM_CheckFeatures, GIFBS_HasV5TE_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i32] } (sra:{ *:[i32] } GPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 16:{ *:[i32] }))  =>  (SMULTT:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SMULTT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 186,
        GIR_Done,
      // Label 278: @11533
      GIM_Try, /*On fail goto*//*Label 279*/ 11618, // Rule ID 522 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] }))  =>  (t2SMULTT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SMULTT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 522,
        GIR_Done,
      // Label 279: @11618
      GIM_Try, /*On fail goto*//*Label 280*/ 11665, // Rule ID 169 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (MUL:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MUL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 169,
        GIR_Done,
      // Label 280: @11665
      GIM_Try, /*On fail goto*//*Label 281*/ 11712, // Rule ID 170 //
        GIM_CheckFeatures, GIFBS_IsARM_NoV6_UseMulOps,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (MULv5:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MULv5,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 170,
        GIR_Done,
      // Label 281: @11712
      GIM_Try, /*On fail goto*//*Label 282*/ 11755, // Rule ID 509 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2MUL:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MUL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 509,
        GIR_Done,
      // Label 282: @11755
      GIM_Reject,
    // Label 277: @11756
    GIM_Reject,
    // Label 270: @11757
    GIM_Try, /*On fail goto*//*Label 283*/ 11808, // Rule ID 853 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VMULv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULv2i32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 853,
      GIR_Done,
    // Label 283: @11808
    GIM_Reject,
    // Label 271: @11809
    GIM_Try, /*On fail goto*//*Label 284*/ 11860, // Rule ID 852 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VMULv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULv4i16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 852,
      GIR_Done,
    // Label 284: @11860
    GIM_Reject,
    // Label 272: @11861
    GIM_Try, /*On fail goto*//*Label 285*/ 11976,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 286*/ 11914, // Rule ID 856 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VMULv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 856,
        GIR_Done,
      // Label 286: @11914
      GIM_Try, /*On fail goto*//*Label 287*/ 11975, // Rule ID 3548 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (mul:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VMULi32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VMULi32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3548,
        GIR_Done,
      // Label 287: @11975
      GIM_Reject,
    // Label 285: @11976
    GIM_Reject,
    // Label 273: @11977
    GIM_Try, /*On fail goto*//*Label 288*/ 12028, // Rule ID 851 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VMULv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULv8i8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 851,
      GIR_Done,
    // Label 288: @12028
    GIM_Reject,
    // Label 274: @12029
    GIM_Try, /*On fail goto*//*Label 289*/ 12144,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 290*/ 12082, // Rule ID 855 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VMULv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 855,
        GIR_Done,
      // Label 290: @12082
      GIM_Try, /*On fail goto*//*Label 291*/ 12143, // Rule ID 3544 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (mul:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VMULi16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VMULi16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3544,
        GIR_Done,
      // Label 291: @12143
      GIM_Reject,
    // Label 289: @12144
    GIM_Reject,
    // Label 275: @12145
    GIM_Try, /*On fail goto*//*Label 292*/ 12260,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 293*/ 12198, // Rule ID 854 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VMULv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMULv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 854,
        GIR_Done,
      // Label 293: @12198
      GIM_Try, /*On fail goto*//*Label 294*/ 12259, // Rule ID 3540 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (mul:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VMULi8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VMULi8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3540,
        GIR_Done,
      // Label 294: @12259
      GIM_Reject,
    // Label 292: @12260
    GIM_Reject,
    // Label 276: @12261
    GIM_Reject,
    // Label 3: @12262
    GIM_Try, /*On fail goto*//*Label 295*/ 12363,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 296*/ 12319, // Rule ID 195 //
        GIM_CheckFeatures, GIFBS_HasDivideInARM_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (sdiv:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (SDIV:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SDIV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 195,
        GIR_Done,
      // Label 296: @12319
      GIM_Try, /*On fail goto*//*Label 297*/ 12362, // Rule ID 539 //
        GIM_CheckFeatures, GIFBS_HasDivideInThumb_HasV8MBaseline_IsThumb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (sdiv:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SDIV:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SDIV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 539,
        GIR_Done,
      // Label 297: @12362
      GIM_Reject,
    // Label 295: @12363
    GIM_Reject,
    // Label 4: @12364
    GIM_Try, /*On fail goto*//*Label 298*/ 12465,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 299*/ 12421, // Rule ID 196 //
        GIM_CheckFeatures, GIFBS_HasDivideInARM_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (udiv:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (UDIV:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UDIV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 196,
        GIR_Done,
      // Label 299: @12421
      GIM_Try, /*On fail goto*//*Label 300*/ 12464, // Rule ID 540 //
        GIM_CheckFeatures, GIFBS_HasDivideInThumb_HasV8MBaseline_IsThumb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (udiv:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UDIV:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UDIV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 540,
        GIR_Done,
      // Label 300: @12464
      GIM_Reject,
    // Label 298: @12465
    GIM_Reject,
    // Label 5: @12466
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 16, /*)*//*default:*//*Label 314*/ 15225,
    /*GILLT_s32*//*Label 301*/ 12487,
    /*GILLT_s64*//*Label 302*/ 14129,
    /*GILLT_v2s1*//*Label 303*/ 14181,
    /*GILLT_v2s32*//*Label 304*/ 14287,
    /*GILLT_v2s64*//*Label 305*/ 14339,
    /*GILLT_v4s1*//*Label 306*/ 14455,
    /*GILLT_v4s16*//*Label 307*/ 14561,
    /*GILLT_v4s32*//*Label 308*/ 14613, 0,
    /*GILLT_v8s1*//*Label 309*/ 14729,
    /*GILLT_v8s8*//*Label 310*/ 14835,
    /*GILLT_v8s16*//*Label 311*/ 14887, 0,
    /*GILLT_v16s1*//*Label 312*/ 15003,
    /*GILLT_v16s8*//*Label 313*/ 15109,
    // Label 301: @12487
    GIM_Try, /*On fail goto*//*Label 315*/ 14128,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 316*/ 12560, // Rule ID 1879 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 16711935,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$Src, 8:{ *:[i32] }), 16711935:{ *:[i32] })  =>  (UXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Src
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1879,
        GIR_Done,
      // Label 316: @12560
      GIM_Try, /*On fail goto*//*Label 317*/ 12623, // Rule ID 2119 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 16711935,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Src, 8:{ *:[i32] }), 16711935:{ *:[i32] })  =>  (t2UXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Src, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Src
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2119,
        GIR_Done,
      // Label 317: @12623
      GIM_Try, /*On fail goto*//*Label 318*/ 12665, // Rule ID 2011 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Src, 255:{ *:[i32] })  =>  (UXTB:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Src
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2011,
        GIR_Done,
      // Label 318: @12665
      GIM_Try, /*On fail goto*//*Label 319*/ 12707, // Rule ID 2012 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Src, 65535:{ *:[i32] })  =>  (UXTH:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Src
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2012,
        GIR_Done,
      // Label 319: @12707
      GIM_Try, /*On fail goto*//*Label 320*/ 12749, // Rule ID 2013 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 16711935,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Src, 16711935:{ *:[i32] })  =>  (UXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Src
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2013,
        GIR_Done,
      // Label 320: @12749
      GIM_Try, /*On fail goto*//*Label 321*/ 12791, // Rule ID 2235 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] })  =>  (t2UXTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2235,
        GIR_Done,
      // Label 321: @12791
      GIM_Try, /*On fail goto*//*Label 322*/ 12833, // Rule ID 2236 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] })  =>  (t2UXTH:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2236,
        GIR_Done,
      // Label 322: @12833
      GIM_Try, /*On fail goto*//*Label 323*/ 12875, // Rule ID 2237 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 16711935,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16711935:{ *:[i32] })  =>  (t2UXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2237,
        GIR_Done,
      // Label 323: @12875
      GIM_Try, /*On fail goto*//*Label 324*/ 12950, // Rule ID 5478 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm), GPR:{ *:[i32] }:$Rn)  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5478,
        GIR_Done,
      // Label 324: @12950
      GIM_Try, /*On fail goto*//*Label 325*/ 13025, // Rule ID 5511 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm), rGPR:{ *:[i32] }:$Rn)  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5511,
        GIR_Done,
      // Label 325: @13025
      GIM_Try, /*On fail goto*//*Label 326*/ 13100, // Rule ID 5477 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm, -1:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5477,
        GIR_Done,
      // Label 326: @13100
      GIM_Try, /*On fail goto*//*Label 327*/ 13175, // Rule ID 5510 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5510,
        GIR_Done,
      // Label 327: @13175
      GIM_Try, /*On fail goto*//*Label 328*/ 13250, // Rule ID 5476 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm))  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5476,
        GIR_Done,
      // Label 328: @13250
      GIM_Try, /*On fail goto*//*Label 329*/ 13325, // Rule ID 5509 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm))  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5509,
        GIR_Done,
      // Label 329: @13325
      GIM_Try, /*On fail goto*//*Label 330*/ 13400, // Rule ID 159 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm, -1:{ *:[i32] }))  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 159,
        GIR_Done,
      // Label 330: @13400
      GIM_Try, /*On fail goto*//*Label 331*/ 13475, // Rule ID 497 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }))  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2BICri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 497,
        GIR_Done,
      // Label 331: @13475
      GIM_Try, /*On fail goto*//*Label 332*/ 13543, // Rule ID 5479 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (BICrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::BICrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5479,
        GIR_Done,
      // Label 332: @13543
      GIM_Try, /*On fail goto*//*Label 333*/ 13611, // Rule ID 5512 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2BICrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2BICrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5512,
        GIR_Done,
      // Label 333: @13611
      GIM_Try, /*On fail goto*//*Label 334*/ 13679, // Rule ID 160 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (BICrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::BICrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 160,
        GIR_Done,
      // Label 334: @13679
      GIM_Try, /*On fail goto*//*Label 335*/ 13747, // Rule ID 498 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (t2BICrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2BICrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 498,
        GIR_Done,
      // Label 335: @13747
      GIM_Try, /*On fail goto*//*Label 336*/ 13786, // Rule ID 352 //
        GIM_CheckFeatures, GIFBS_HasV6_IsThumb_IsThumb1Only,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::tGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::tGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        // (and:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] })  =>  (tUXTB:{ *:[i32] } tGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::tUXTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 352,
        GIR_Done,
      // Label 336: @13786
      GIM_Try, /*On fail goto*//*Label 337*/ 13825, // Rule ID 353 //
        GIM_CheckFeatures, GIFBS_HasV6_IsThumb_IsThumb1Only,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::tGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::tGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        // (and:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] })  =>  (tUXTH:{ *:[i32] } tGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::tUXTH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 353,
        GIR_Done,
      // Label 337: @13825
      GIM_Try, /*On fail goto*//*Label 338*/ 13879, // Rule ID 147 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (ANDri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::ANDri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 147,
        GIR_Done,
      // Label 338: @13879
      GIM_Try, /*On fail goto*//*Label 339*/ 13933, // Rule ID 488 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2ANDri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ANDri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 488,
        GIR_Done,
      // Label 339: @13933
      GIM_Try, /*On fail goto*//*Label 340*/ 13983, // Rule ID 163 //
        GIM_CheckFeatures, GIFBS_HasV6T2_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_bf_inv_mask_imm,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_bf_inv_mask_imm>>:$imm)  =>  (BFC:{ *:[i32] } GPR:{ *:[i32] }:$src, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::BFC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 163,
        GIR_Done,
      // Label 340: @13983
      GIM_Try, /*On fail goto*//*Label 341*/ 14033, // Rule ID 500 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_bf_inv_mask_imm,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_bf_inv_mask_imm>>:$imm)  =>  (t2BFC:{ *:[i32] } rGPR:{ *:[i32] }:$src, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2BFC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 500,
        GIR_Done,
      // Label 341: @14033
      GIM_Try, /*On fail goto*//*Label 342*/ 14080, // Rule ID 148 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (ANDrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::ANDrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 148,
        GIR_Done,
      // Label 342: @14080
      GIM_Try, /*On fail goto*//*Label 343*/ 14127, // Rule ID 489 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2ANDrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ANDrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 489,
        GIR_Done,
      // Label 343: @14127
      GIM_Reject,
    // Label 315: @14128
    GIM_Reject,
    // Label 302: @14129
    GIM_Try, /*On fail goto*//*Label 344*/ 14180, // Rule ID 2517 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (and:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)  =>  (VANDd:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VANDd,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2517,
      GIR_Done,
    // Label 344: @14180
    GIM_Reject,
    // Label 303: @14181
    GIM_Try, /*On fail goto*//*Label 345*/ 14286, // Rule ID 1851 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::VCCRRegClassID,
      // (and:{ *:[v2i1] } VCCR:{ *:[v2i1] }:$p1, VCCR:{ *:[v2i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (t2ANDrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/ARM::t2ANDrr,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::VCCRRegClassID,
      // GIR_Coverage, 1851,
      GIR_Done,
    // Label 345: @14286
    GIM_Reject,
    // Label 304: @14287
    GIM_Try, /*On fail goto*//*Label 346*/ 14338, // Rule ID 1149 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (and:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VANDd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VANDd,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1149,
      GIR_Done,
    // Label 346: @14338
    GIM_Reject,
    // Label 305: @14339
    GIM_Try, /*On fail goto*//*Label 347*/ 14454,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 348*/ 14392, // Rule ID 2520 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (and:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)  =>  (VANDq:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VANDq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2520,
        GIR_Done,
      // Label 348: @14392
      GIM_Try, /*On fail goto*//*Label 349*/ 14453, // Rule ID 3452 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (and:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)  =>  (MVE_VAND:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VAND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3452,
        GIR_Done,
      // Label 349: @14453
      GIM_Reject,
    // Label 347: @14454
    GIM_Reject,
    // Label 306: @14455
    GIM_Try, /*On fail goto*//*Label 350*/ 14560, // Rule ID 1852 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::VCCRRegClassID,
      // (and:{ *:[v4i1] } VCCR:{ *:[v4i1] }:$p1, VCCR:{ *:[v4i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (t2ANDrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/ARM::t2ANDrr,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::VCCRRegClassID,
      // GIR_Coverage, 1852,
      GIR_Done,
    // Label 350: @14560
    GIM_Reject,
    // Label 307: @14561
    GIM_Try, /*On fail goto*//*Label 351*/ 14612, // Rule ID 2516 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (and:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)  =>  (VANDd:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VANDd,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2516,
      GIR_Done,
    // Label 351: @14612
    GIM_Reject,
    // Label 308: @14613
    GIM_Try, /*On fail goto*//*Label 352*/ 14728,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 353*/ 14666, // Rule ID 1150 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (and:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VANDq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VANDq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1150,
        GIR_Done,
      // Label 353: @14666
      GIM_Try, /*On fail goto*//*Label 354*/ 14727, // Rule ID 3448 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (and:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VAND:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VAND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3448,
        GIR_Done,
      // Label 354: @14727
      GIM_Reject,
    // Label 352: @14728
    GIM_Reject,
    // Label 309: @14729
    GIM_Try, /*On fail goto*//*Label 355*/ 14834, // Rule ID 1853 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::VCCRRegClassID,
      // (and:{ *:[v8i1] } VCCR:{ *:[v8i1] }:$p1, VCCR:{ *:[v8i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (t2ANDrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/ARM::t2ANDrr,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::VCCRRegClassID,
      // GIR_Coverage, 1853,
      GIR_Done,
    // Label 355: @14834
    GIM_Reject,
    // Label 310: @14835
    GIM_Try, /*On fail goto*//*Label 356*/ 14886, // Rule ID 2515 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (and:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)  =>  (VANDd:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VANDd,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2515,
      GIR_Done,
    // Label 356: @14886
    GIM_Reject,
    // Label 311: @14887
    GIM_Try, /*On fail goto*//*Label 357*/ 15002,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 358*/ 14940, // Rule ID 2519 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (and:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)  =>  (VANDq:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VANDq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2519,
        GIR_Done,
      // Label 358: @14940
      GIM_Try, /*On fail goto*//*Label 359*/ 15001, // Rule ID 3444 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (and:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VAND:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VAND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3444,
        GIR_Done,
      // Label 359: @15001
      GIM_Reject,
    // Label 357: @15002
    GIM_Reject,
    // Label 312: @15003
    GIM_Try, /*On fail goto*//*Label 360*/ 15108, // Rule ID 1850 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::VCCRRegClassID,
      // (and:{ *:[v16i1] } VCCR:{ *:[v16i1] }:$p1, VCCR:{ *:[v16i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v16i1] } (t2ANDrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/ARM::t2ANDrr,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::VCCRRegClassID,
      // GIR_Coverage, 1850,
      GIR_Done,
    // Label 360: @15108
    GIM_Reject,
    // Label 313: @15109
    GIM_Try, /*On fail goto*//*Label 361*/ 15224,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 362*/ 15162, // Rule ID 2518 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (and:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)  =>  (VANDq:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VANDq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2518,
        GIR_Done,
      // Label 362: @15162
      GIM_Try, /*On fail goto*//*Label 363*/ 15223, // Rule ID 3440 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (and:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VAND:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VAND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3440,
        GIR_Done,
      // Label 363: @15223
      GIM_Reject,
    // Label 361: @15224
    GIM_Reject,
    // Label 314: @15225
    GIM_Reject,
    // Label 6: @15226
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 16, /*)*//*default:*//*Label 377*/ 20465,
    /*GILLT_s32*//*Label 364*/ 15247,
    /*GILLT_s64*//*Label 365*/ 19369,
    /*GILLT_v2s1*//*Label 366*/ 19421,
    /*GILLT_v2s32*//*Label 367*/ 19527,
    /*GILLT_v2s64*//*Label 368*/ 19579,
    /*GILLT_v4s1*//*Label 369*/ 19695,
    /*GILLT_v4s16*//*Label 370*/ 19801,
    /*GILLT_v4s32*//*Label 371*/ 19853, 0,
    /*GILLT_v8s1*//*Label 372*/ 19969,
    /*GILLT_v8s8*//*Label 373*/ 20075,
    /*GILLT_v8s16*//*Label 374*/ 20127, 0,
    /*GILLT_v16s1*//*Label 375*/ 20243,
    /*GILLT_v16s8*//*Label 376*/ 20349,
    // Label 364: @15247
    GIM_Try, /*On fail goto*//*Label 378*/ 19368,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 379*/ 15377, // Rule ID 5694 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 24,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }), (sra:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }))  =>  (REVSH:{ *:[i32] } GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::REVSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5694,
        GIR_Done,
      // Label 379: @15377
      GIM_Try, /*On fail goto*//*Label 380*/ 15497, // Rule ID 5736 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 255,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 24,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }), (sra:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }))  =>  (t2REVSH:{ *:[i32] } rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2REVSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5736,
        GIR_Done,
      // Label 380: @15497
      GIM_Try, /*On fail goto*//*Label 381*/ 15617, // Rule ID 1942 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 24,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (sra:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }))  =>  (REVSH:{ *:[i32] } GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::REVSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1942,
        GIR_Done,
      // Label 381: @15617
      GIM_Try, /*On fail goto*//*Label 382*/ 15737, // Rule ID 2206 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 24,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (sra:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }))  =>  (t2REVSH:{ *:[i32] } rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2REVSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2206,
        GIR_Done,
      // Label 382: @15737
      GIM_Try, /*On fail goto*//*Label 383*/ 15854, // Rule ID 5492 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_pkh_asr_amt,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5492,
        GIR_Done,
      // Label 383: @15854
      GIM_Try, /*On fail goto*//*Label 384*/ 15971, // Rule ID 5529 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_pkh_asr_amt,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5529,
        GIR_Done,
      // Label 384: @15971
      GIM_Try, /*On fail goto*//*Label 385*/ 16088, // Rule ID 5699 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm1_15,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5699,
        GIR_Done,
      // Label 385: @16088
      GIM_Try, /*On fail goto*//*Label 386*/ 16205, // Rule ID 5741 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm1_15,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5741,
        GIR_Done,
      // Label 386: @16205
      GIM_Try, /*On fail goto*//*Label 387*/ 16322, // Rule ID 5491 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_pkh_lsl_amt,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5491,
        GIR_Done,
      // Label 387: @16322
      GIM_Try, /*On fail goto*//*Label 388*/ 16439, // Rule ID 5528 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_pkh_lsl_amt,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5528,
        GIR_Done,
      // Label 388: @16439
      GIM_Try, /*On fail goto*//*Label 389*/ 16556, // Rule ID 203 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_pkh_asr_amt,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 203,
        GIR_Done,
      // Label 389: @16556
      GIM_Try, /*On fail goto*//*Label 390*/ 16673, // Rule ID 547 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_pkh_asr_amt,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 547,
        GIR_Done,
      // Label 390: @16673
      GIM_Try, /*On fail goto*//*Label 391*/ 16790, // Rule ID 1947 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_imm1_15,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1947,
        GIR_Done,
      // Label 391: @16790
      GIM_Try, /*On fail goto*//*Label 392*/ 16907, // Rule ID 2211 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_imm1_15,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2211,
        GIR_Done,
      // Label 392: @16907
      GIM_Try, /*On fail goto*//*Label 393*/ 17024, // Rule ID 202 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_pkh_lsl_amt,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (and:{ *:[i32] } (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 202,
        GIR_Done,
      // Label 393: @17024
      GIM_Try, /*On fail goto*//*Label 394*/ 17141, // Rule ID 546 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_pkh_lsl_amt,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (and:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 546,
        GIR_Done,
      // Label 394: @17141
      GIM_Try, /*On fail goto*//*Label 395*/ 17229, // Rule ID 1943 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 4294901760:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1943,
        GIR_Done,
      // Label 395: @17229
      GIM_Try, /*On fail goto*//*Label 396*/ 17317, // Rule ID 2207 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src2, 4294901760:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2207,
        GIR_Done,
      // Label 396: @17317
      GIM_Try, /*On fail goto*//*Label 397*/ 17405, // Rule ID 5695 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 4294901760:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5695,
        GIR_Done,
      // Label 397: @17405
      GIM_Try, /*On fail goto*//*Label 398*/ 17493, // Rule ID 5737 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src2, 4294901760:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5737,
        GIR_Done,
      // Label 398: @17493
      GIM_Try, /*On fail goto*//*Label 399*/ 17589, // Rule ID 1946 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1946,
        GIR_Done,
      // Label 399: @17589
      GIM_Try, /*On fail goto*//*Label 400*/ 17685, // Rule ID 2210 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2210,
        GIR_Done,
      // Label 400: @17685
      GIM_Try, /*On fail goto*//*Label 401*/ 17781, // Rule ID 1945 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm16,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1945,
        GIR_Done,
      // Label 401: @17781
      GIM_Try, /*On fail goto*//*Label 402*/ 17877, // Rule ID 2209 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294901760,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm16,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2209,
        GIR_Done,
      // Label 402: @17877
      GIM_Try, /*On fail goto*//*Label 403*/ 17973, // Rule ID 1944 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1944,
        GIR_Done,
      // Label 403: @17973
      GIM_Try, /*On fail goto*//*Label 404*/ 18069, // Rule ID 2208 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 65535,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }), (shl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2208,
        GIR_Done,
      // Label 404: @18069
      GIM_Try, /*On fail goto*//*Label 405*/ 18165, // Rule ID 5698 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5698,
        GIR_Done,
      // Label 405: @18165
      GIM_Try, /*On fail goto*//*Label 406*/ 18261, // Rule ID 5740 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5740,
        GIR_Done,
      // Label 406: @18261
      GIM_Try, /*On fail goto*//*Label 407*/ 18357, // Rule ID 5697 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_imm16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5697,
        GIR_Done,
      // Label 407: @18357
      GIM_Try, /*On fail goto*//*Label 408*/ 18453, // Rule ID 5739 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_imm16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 4294901760,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHTB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5739,
        GIR_Done,
      // Label 408: @18453
      GIM_Try, /*On fail goto*//*Label 409*/ 18549, // Rule ID 5696 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5696,
        GIR_Done,
      // Label 409: @18549
      GIM_Try, /*On fail goto*//*Label 410*/ 18645, // Rule ID 5738 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_imm16_31,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2PKHBT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5738,
        GIR_Done,
      // Label 410: @18645
      GIM_Try, /*On fail goto*//*Label 411*/ 18720, // Rule ID 5516 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm), rGPR:{ *:[i32] }:$Rn)  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORNri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5516,
        GIR_Done,
      // Label 411: @18720
      GIM_Try, /*On fail goto*//*Label 412*/ 18795, // Rule ID 5515 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORNri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5515,
        GIR_Done,
      // Label 412: @18795
      GIM_Try, /*On fail goto*//*Label 413*/ 18870, // Rule ID 5514 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm))  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORNri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5514,
        GIR_Done,
      // Label 413: @18870
      GIM_Try, /*On fail goto*//*Label 414*/ 18945, // Rule ID 503 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }))  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORNri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 503,
        GIR_Done,
      // Label 414: @18945
      GIM_Try, /*On fail goto*//*Label 415*/ 19013, // Rule ID 5517 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2ORNrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORNrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5517,
        GIR_Done,
      // Label 415: @19013
      GIM_Try, /*On fail goto*//*Label 416*/ 19081, // Rule ID 504 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (t2ORNrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORNrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 504,
        GIR_Done,
      // Label 416: @19081
      GIM_Try, /*On fail goto*//*Label 417*/ 19123, // Rule ID 1872 //
        GIM_CheckFeatures, GIFBS_HasV6T2_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 4294901760,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$src, 4294901760:{ *:[i32] })  =>  (MOVTi16:{ *:[i32] } GPR:{ *:[i32] }:$src, 65535:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MOVTi16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm, /*InsnID*/0, /*Imm*/65535,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1872,
        GIR_Done,
      // Label 417: @19123
      GIM_Try, /*On fail goto*//*Label 418*/ 19165, // Rule ID 2101 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 4294901760,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$src, 4294901760:{ *:[i32] })  =>  (t2MOVTi16:{ *:[i32] } rGPR:{ *:[i32] }:$src, 65535:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MOVTi16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm, /*InsnID*/0, /*Imm*/65535,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2101,
        GIR_Done,
      // Label 418: @19165
      GIM_Try, /*On fail goto*//*Label 419*/ 19219, // Rule ID 151 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (ORRri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::ORRri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 151,
        GIR_Done,
      // Label 419: @19219
      GIM_Try, /*On fail goto*//*Label 420*/ 19273, // Rule ID 491 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2ORRri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORRri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 491,
        GIR_Done,
      // Label 420: @19273
      GIM_Try, /*On fail goto*//*Label 421*/ 19320, // Rule ID 152 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (ORRrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::ORRrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 152,
        GIR_Done,
      // Label 421: @19320
      GIM_Try, /*On fail goto*//*Label 422*/ 19367, // Rule ID 492 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2ORRrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2ORRrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 492,
        GIR_Done,
      // Label 422: @19367
      GIM_Reject,
    // Label 378: @19368
    GIM_Reject,
    // Label 365: @19369
    GIM_Try, /*On fail goto*//*Label 423*/ 19420, // Rule ID 2523 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (or:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)  =>  (VORRd:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VORRd,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2523,
      GIR_Done,
    // Label 423: @19420
    GIM_Reject,
    // Label 366: @19421
    GIM_Try, /*On fail goto*//*Label 424*/ 19526, // Rule ID 1859 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::VCCRRegClassID,
      // (or:{ *:[v2i1] } VCCR:{ *:[v2i1] }:$p1, VCCR:{ *:[v2i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (t2ORRrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/ARM::t2ORRrr,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::VCCRRegClassID,
      // GIR_Coverage, 1859,
      GIR_Done,
    // Label 424: @19526
    GIM_Reject,
    // Label 367: @19527
    GIM_Try, /*On fail goto*//*Label 425*/ 19578, // Rule ID 1153 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (or:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VORRd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VORRd,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1153,
      GIR_Done,
    // Label 425: @19578
    GIM_Reject,
    // Label 368: @19579
    GIM_Try, /*On fail goto*//*Label 426*/ 19694,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 427*/ 19632, // Rule ID 2526 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (or:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)  =>  (VORRq:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VORRq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2526,
        GIR_Done,
      // Label 427: @19632
      GIM_Try, /*On fail goto*//*Label 428*/ 19693, // Rule ID 3466 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (or:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)  =>  (MVE_VORR:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VORR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3466,
        GIR_Done,
      // Label 428: @19693
      GIM_Reject,
    // Label 426: @19694
    GIM_Reject,
    // Label 369: @19695
    GIM_Try, /*On fail goto*//*Label 429*/ 19800, // Rule ID 1860 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::VCCRRegClassID,
      // (or:{ *:[v4i1] } VCCR:{ *:[v4i1] }:$p1, VCCR:{ *:[v4i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (t2ORRrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/ARM::t2ORRrr,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::VCCRRegClassID,
      // GIR_Coverage, 1860,
      GIR_Done,
    // Label 429: @19800
    GIM_Reject,
    // Label 370: @19801
    GIM_Try, /*On fail goto*//*Label 430*/ 19852, // Rule ID 2522 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (or:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)  =>  (VORRd:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VORRd,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2522,
      GIR_Done,
    // Label 430: @19852
    GIM_Reject,
    // Label 371: @19853
    GIM_Try, /*On fail goto*//*Label 431*/ 19968,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 432*/ 19906, // Rule ID 1154 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (or:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VORRq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VORRq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1154,
        GIR_Done,
      // Label 432: @19906
      GIM_Try, /*On fail goto*//*Label 433*/ 19967, // Rule ID 3462 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (or:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VORR:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VORR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3462,
        GIR_Done,
      // Label 433: @19967
      GIM_Reject,
    // Label 431: @19968
    GIM_Reject,
    // Label 372: @19969
    GIM_Try, /*On fail goto*//*Label 434*/ 20074, // Rule ID 1861 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::VCCRRegClassID,
      // (or:{ *:[v8i1] } VCCR:{ *:[v8i1] }:$p1, VCCR:{ *:[v8i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (t2ORRrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/ARM::t2ORRrr,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::VCCRRegClassID,
      // GIR_Coverage, 1861,
      GIR_Done,
    // Label 434: @20074
    GIM_Reject,
    // Label 373: @20075
    GIM_Try, /*On fail goto*//*Label 435*/ 20126, // Rule ID 2521 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (or:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)  =>  (VORRd:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VORRd,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2521,
      GIR_Done,
    // Label 435: @20126
    GIM_Reject,
    // Label 374: @20127
    GIM_Try, /*On fail goto*//*Label 436*/ 20242,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 437*/ 20180, // Rule ID 2525 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (or:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)  =>  (VORRq:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VORRq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2525,
        GIR_Done,
      // Label 437: @20180
      GIM_Try, /*On fail goto*//*Label 438*/ 20241, // Rule ID 3458 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (or:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VORR:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VORR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3458,
        GIR_Done,
      // Label 438: @20241
      GIM_Reject,
    // Label 436: @20242
    GIM_Reject,
    // Label 375: @20243
    GIM_Try, /*On fail goto*//*Label 439*/ 20348, // Rule ID 1858 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::VCCRRegClassID,
      // (or:{ *:[v16i1] } VCCR:{ *:[v16i1] }:$p1, VCCR:{ *:[v16i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v16i1] } (t2ORRrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/ARM::t2ORRrr,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::VCCRRegClassID,
      // GIR_Coverage, 1858,
      GIR_Done,
    // Label 439: @20348
    GIM_Reject,
    // Label 376: @20349
    GIM_Try, /*On fail goto*//*Label 440*/ 20464,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 441*/ 20402, // Rule ID 2524 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (or:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)  =>  (VORRq:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VORRq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2524,
        GIR_Done,
      // Label 441: @20402
      GIM_Try, /*On fail goto*//*Label 442*/ 20463, // Rule ID 3454 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (or:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VORR:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VORR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3454,
        GIR_Done,
      // Label 442: @20463
      GIM_Reject,
    // Label 440: @20464
    GIM_Reject,
    // Label 377: @20465
    GIM_Reject,
    // Label 7: @20466
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 16, /*)*//*default:*//*Label 456*/ 21983,
    /*GILLT_s32*//*Label 443*/ 20487,
    /*GILLT_s64*//*Label 444*/ 20887,
    /*GILLT_v2s1*//*Label 445*/ 20939,
    /*GILLT_v2s32*//*Label 446*/ 21045,
    /*GILLT_v2s64*//*Label 447*/ 21097,
    /*GILLT_v4s1*//*Label 448*/ 21213,
    /*GILLT_v4s16*//*Label 449*/ 21319,
    /*GILLT_v4s32*//*Label 450*/ 21371, 0,
    /*GILLT_v8s1*//*Label 451*/ 21487,
    /*GILLT_v8s8*//*Label 452*/ 21593,
    /*GILLT_v8s16*//*Label 453*/ 21645, 0,
    /*GILLT_v16s1*//*Label 454*/ 21761,
    /*GILLT_v16s8*//*Label 455*/ 21867,
    // Label 443: @20487
    GIM_Try, /*On fail goto*//*Label 457*/ 20886,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 458*/ 20547, // Rule ID 5519 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, -1,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2MVNi:{ *:[i32] } (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MVNi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5519,
        GIR_Done,
      // Label 458: @20547
      GIM_Try, /*On fail goto*//*Label 459*/ 20597, // Rule ID 506 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] })  =>  (t2MVNi:{ *:[i32] } (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MVNi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 506,
        GIR_Done,
      // Label 459: @20597
      GIM_Try, /*On fail goto*//*Label 460*/ 20640, // Rule ID 507 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] })  =>  (t2MVNr:{ *:[i32] } rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2MVNr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 507,
        GIR_Done,
      // Label 460: @20640
      GIM_Try, /*On fail goto*//*Label 461*/ 20683, // Rule ID 165 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rm, -1:{ *:[i32] })  =>  (MVNr:{ *:[i32] } GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVNr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 165,
        GIR_Done,
      // Label 461: @20683
      GIM_Try, /*On fail goto*//*Label 462*/ 20737, // Rule ID 155 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_mod_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (EORri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::EORri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 155,
        GIR_Done,
      // Label 462: @20737
      GIM_Try, /*On fail goto*//*Label 463*/ 20791, // Rule ID 494 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_t2_so_imm,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2EORri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2EORri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 494,
        GIR_Done,
      // Label 463: @20791
      GIM_Try, /*On fail goto*//*Label 464*/ 20838, // Rule ID 156 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (EORrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::EORrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 156,
        GIR_Done,
      // Label 464: @20838
      GIM_Try, /*On fail goto*//*Label 465*/ 20885, // Rule ID 495 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2EORrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2EORrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 495,
        GIR_Done,
      // Label 465: @20885
      GIM_Reject,
    // Label 457: @20886
    GIM_Reject,
    // Label 444: @20887
    GIM_Try, /*On fail goto*//*Label 466*/ 20938, // Rule ID 2529 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (xor:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)  =>  (VEORd:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VEORd,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2529,
      GIR_Done,
    // Label 466: @20938
    GIM_Reject,
    // Label 445: @20939
    GIM_Try, /*On fail goto*//*Label 467*/ 21044, // Rule ID 1855 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::VCCRRegClassID,
      // (xor:{ *:[v2i1] } VCCR:{ *:[v2i1] }:$p1, VCCR:{ *:[v2i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (t2EORrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/ARM::t2EORrr,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::VCCRRegClassID,
      // GIR_Coverage, 1855,
      GIR_Done,
    // Label 467: @21044
    GIM_Reject,
    // Label 446: @21045
    GIM_Try, /*On fail goto*//*Label 468*/ 21096, // Rule ID 1151 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (xor:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VEORd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VEORd,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1151,
      GIR_Done,
    // Label 468: @21096
    GIM_Reject,
    // Label 447: @21097
    GIM_Try, /*On fail goto*//*Label 469*/ 21212,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 470*/ 21150, // Rule ID 2532 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (xor:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)  =>  (VEORq:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VEORq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2532,
        GIR_Done,
      // Label 470: @21150
      GIM_Try, /*On fail goto*//*Label 471*/ 21211, // Rule ID 3480 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (xor:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)  =>  (MVE_VEOR:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VEOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3480,
        GIR_Done,
      // Label 471: @21211
      GIM_Reject,
    // Label 469: @21212
    GIM_Reject,
    // Label 448: @21213
    GIM_Try, /*On fail goto*//*Label 472*/ 21318, // Rule ID 1856 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::VCCRRegClassID,
      // (xor:{ *:[v4i1] } VCCR:{ *:[v4i1] }:$p1, VCCR:{ *:[v4i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (t2EORrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/ARM::t2EORrr,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::VCCRRegClassID,
      // GIR_Coverage, 1856,
      GIR_Done,
    // Label 472: @21318
    GIM_Reject,
    // Label 449: @21319
    GIM_Try, /*On fail goto*//*Label 473*/ 21370, // Rule ID 2528 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (xor:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)  =>  (VEORd:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VEORd,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2528,
      GIR_Done,
    // Label 473: @21370
    GIM_Reject,
    // Label 450: @21371
    GIM_Try, /*On fail goto*//*Label 474*/ 21486,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 475*/ 21424, // Rule ID 1152 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (xor:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VEORq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VEORq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1152,
        GIR_Done,
      // Label 475: @21424
      GIM_Try, /*On fail goto*//*Label 476*/ 21485, // Rule ID 3476 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (xor:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VEOR:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VEOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3476,
        GIR_Done,
      // Label 476: @21485
      GIM_Reject,
    // Label 474: @21486
    GIM_Reject,
    // Label 451: @21487
    GIM_Try, /*On fail goto*//*Label 477*/ 21592, // Rule ID 1857 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::VCCRRegClassID,
      // (xor:{ *:[v8i1] } VCCR:{ *:[v8i1] }:$p1, VCCR:{ *:[v8i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (t2EORrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/ARM::t2EORrr,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::VCCRRegClassID,
      // GIR_Coverage, 1857,
      GIR_Done,
    // Label 477: @21592
    GIM_Reject,
    // Label 452: @21593
    GIM_Try, /*On fail goto*//*Label 478*/ 21644, // Rule ID 2527 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
      // (xor:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)  =>  (VEORd:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VEORd,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2527,
      GIR_Done,
    // Label 478: @21644
    GIM_Reject,
    // Label 453: @21645
    GIM_Try, /*On fail goto*//*Label 479*/ 21760,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 480*/ 21698, // Rule ID 2531 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (xor:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)  =>  (VEORq:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VEORq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2531,
        GIR_Done,
      // Label 480: @21698
      GIM_Try, /*On fail goto*//*Label 481*/ 21759, // Rule ID 3472 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (xor:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VEOR:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VEOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3472,
        GIR_Done,
      // Label 481: @21759
      GIM_Reject,
    // Label 479: @21760
    GIM_Reject,
    // Label 454: @21761
    GIM_Try, /*On fail goto*//*Label 482*/ 21866, // Rule ID 1854 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::VCCRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::VCCRRegClassID,
      // (xor:{ *:[v16i1] } VCCR:{ *:[v16i1] }:$p1, VCCR:{ *:[v16i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v16i1] } (t2EORrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/ARM::t2EORrr,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::VCCRRegClassID,
      // GIR_Coverage, 1854,
      GIR_Done,
    // Label 482: @21866
    GIM_Reject,
    // Label 455: @21867
    GIM_Try, /*On fail goto*//*Label 483*/ 21982,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 484*/ 21920, // Rule ID 2530 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (xor:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)  =>  (VEORq:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VEORq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // RHS
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2530,
        GIR_Done,
      // Label 484: @21920
      GIM_Try, /*On fail goto*//*Label 485*/ 21981, // Rule ID 3468 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (xor:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VEOR:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VEOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Qm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Qn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3468,
        GIR_Done,
      // Label 485: @21981
      GIM_Reject,
    // Label 483: @21982
    GIM_Reject,
    // Label 456: @21983
    GIM_Reject,
    // Label 8: @21984
    GIM_Try, /*On fail goto*//*Label 486*/ 22377,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/5, 16, /*)*//*default:*//*Label 491*/ 22376,
      /*GILLT_v2s64*//*Label 487*/ 22006, 0, 0,
      /*GILLT_v4s32*//*Label 488*/ 22067, 0, 0, 0,
      /*GILLT_v8s16*//*Label 489*/ 22171, 0, 0,
      /*GILLT_v16s8*//*Label 490*/ 22315,
      // Label 487: @22006
      GIM_Try, /*On fail goto*//*Label 492*/ 22066, // Rule ID 3101 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (concat_vectors:{ *:[v2i64] } DPR:{ *:[v1i64] }:$Dn, DPR:{ *:[v1i64] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v2i64] } QPR:{ *:[i32] }, DPR:{ *:[v1i64] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v1i64] }:$Dm, dsub_1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Dn
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/2,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, ARM::DPRRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, ARM::DPRRegClassID,
        // GIR_Coverage, 3101,
        GIR_Done,
      // Label 492: @22066
      GIM_Reject,
      // Label 488: @22067
      GIM_Try, /*On fail goto*//*Label 493*/ 22170,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_Try, /*On fail goto*//*Label 494*/ 22129, // Rule ID 3102 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          // (concat_vectors:{ *:[v4i32] } DPR:{ *:[v2i32] }:$Dn, DPR:{ *:[v2i32] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v4i32] } QPR:{ *:[i32] }, DPR:{ *:[v2i32] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v2i32] }:$Dm, dsub_1:{ *:[i32] })
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Dn
          GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/1,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
          GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/2,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, ARM::DPRRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, ARM::DPRRegClassID,
          // GIR_Coverage, 3102,
          GIR_Done,
        // Label 494: @22129
        GIM_Try, /*On fail goto*//*Label 495*/ 22169, // Rule ID 3105 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          // (concat_vectors:{ *:[v4f32] } DPR:{ *:[v2f32] }:$Dn, DPR:{ *:[v2f32] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v4f32] } QPR:{ *:[i32] }, DPR:{ *:[v2f32] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v2f32] }:$Dm, dsub_1:{ *:[i32] })
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Dn
          GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/1,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
          GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/2,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, ARM::DPRRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, ARM::DPRRegClassID,
          // GIR_Coverage, 3105,
          GIR_Done,
        // Label 495: @22169
        GIM_Reject,
      // Label 493: @22170
      GIM_Reject,
      // Label 489: @22171
      GIM_Try, /*On fail goto*//*Label 496*/ 22314,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        GIM_Try, /*On fail goto*//*Label 497*/ 22233, // Rule ID 3103 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          // (concat_vectors:{ *:[v8i16] } DPR:{ *:[v4i16] }:$Dn, DPR:{ *:[v4i16] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v8i16] } QPR:{ *:[i32] }, DPR:{ *:[v4i16] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v4i16] }:$Dm, dsub_1:{ *:[i32] })
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Dn
          GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/1,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
          GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/2,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, ARM::DPRRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, ARM::DPRRegClassID,
          // GIR_Coverage, 3103,
          GIR_Done,
        // Label 497: @22233
        GIM_Try, /*On fail goto*//*Label 498*/ 22273, // Rule ID 3106 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          // (concat_vectors:{ *:[v8f16] } DPR:{ *:[v4f16] }:$Dn, DPR:{ *:[v4f16] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v8f16] } QPR:{ *:[i32] }, DPR:{ *:[v4f16] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v4f16] }:$Dm, dsub_1:{ *:[i32] })
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Dn
          GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/1,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
          GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/2,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, ARM::DPRRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, ARM::DPRRegClassID,
          // GIR_Coverage, 3106,
          GIR_Done,
        // Label 498: @22273
        GIM_Try, /*On fail goto*//*Label 499*/ 22313, // Rule ID 3107 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          // (concat_vectors:{ *:[v8bf16] } DPR:{ *:[v4bf16] }:$Dn, DPR:{ *:[v4bf16] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v8bf16] } QPR:{ *:[i32] }, DPR:{ *:[v4bf16] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v4bf16] }:$Dm, dsub_1:{ *:[i32] })
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Dn
          GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/1,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
          GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/2,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, ARM::DPRRegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, ARM::DPRRegClassID,
          // GIR_Coverage, 3107,
          GIR_Done,
        // Label 499: @22313
        GIM_Reject,
      // Label 496: @22314
      GIM_Reject,
      // Label 490: @22315
      GIM_Try, /*On fail goto*//*Label 500*/ 22375, // Rule ID 3104 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (concat_vectors:{ *:[v16i8] } DPR:{ *:[v8i8] }:$Dn, DPR:{ *:[v8i8] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v16i8] } QPR:{ *:[i32] }, DPR:{ *:[v8i8] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v8i8] }:$Dm, dsub_1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Dn
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/2,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, ARM::DPRRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, ARM::DPRRegClassID,
        // GIR_Coverage, 3104,
        GIR_Done,
      // Label 500: @22375
      GIM_Reject,
      // Label 491: @22376
      GIM_Reject,
    // Label 486: @22377
    GIM_Reject,
    // Label 9: @22378
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 16, /*)*//*default:*//*Label 510*/ 33287,
    /*GILLT_s32*//*Label 501*/ 22399,
    /*GILLT_s64*//*Label 502*/ 22539, 0,
    /*GILLT_v2s32*//*Label 503*/ 23484,
    /*GILLT_v2s64*//*Label 504*/ 24429, 0,
    /*GILLT_v4s16*//*Label 505*/ 26352,
    /*GILLT_v4s32*//*Label 506*/ 27584, 0, 0,
    /*GILLT_v8s8*//*Label 507*/ 29507,
    /*GILLT_v8s16*//*Label 508*/ 30019, 0, 0,
    /*GILLT_v16s8*//*Label 509*/ 32229,
    // Label 501: @22399
    GIM_Try, /*On fail goto*//*Label 511*/ 22538,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 512*/ 22440, // Rule ID 705 //
        GIM_CheckFeatures, GIFBS_HasFPRegs,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::SPRRegClassID,
        // (bitconvert:{ *:[i32] } SPR:{ *:[f32] }:$Sn)  =>  (VMOVRS:{ *:[i32] } SPR:{ *:[f32] }:$Sn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMOVRS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Sn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 705,
        GIR_Done,
      // Label 512: @22440
      GIM_Try, /*On fail goto*//*Label 513*/ 22475, // Rule ID 706 //
        GIM_CheckFeatures, GIFBS_HasFPRegs_UseVMOVSR,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::SPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        // (bitconvert:{ *:[f32] } GPR:{ *:[i32] }:$Rt)  =>  (VMOVSR:{ *:[f32] } GPR:{ *:[i32] }:$Rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VMOVSR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rt
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 706,
        GIR_Done,
      // Label 513: @22475
      GIM_Try, /*On fail goto*//*Label 514*/ 22537, // Rule ID 2721 //
        GIM_CheckFeatures, GIFBS_DontUseVMOVSR_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::GPRRegClassID,
        // (bitconvert:{ *:[f32] } GPR:{ *:[i32] }:$a)  =>  (EXTRACT_SUBREG:{ *:[f32] } (VMOVDRR:{ *:[f64] } GPR:{ *:[i32] }:$a, GPR:{ *:[i32] }:$a), ssub_0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/ARM::VMOVDRR,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // a
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // a
        GIR_AddImm, /*InsnID*/1, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, ARM::ssub_0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::SPRRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, ARM::DPR_VFP2RegClassID,
        // GIR_Coverage, 2721,
        GIR_Done,
      // Label 514: @22537
      GIM_Reject,
    // Label 511: @22538
    GIM_Reject,
    // Label 502: @22539
    GIM_Try, /*On fail goto*//*Label 515*/ 22573, // Rule ID 2723 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2723,
      GIR_Done,
    // Label 515: @22573
    GIM_Try, /*On fail goto*//*Label 516*/ 22607, // Rule ID 2724 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2724,
      GIR_Done,
    // Label 516: @22607
    GIM_Try, /*On fail goto*//*Label 517*/ 22641, // Rule ID 2739 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2739,
      GIR_Done,
    // Label 517: @22641
    GIM_Try, /*On fail goto*//*Label 518*/ 22675, // Rule ID 2740 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2740,
      GIR_Done,
    // Label 518: @22675
    GIM_Try, /*On fail goto*//*Label 519*/ 22709, // Rule ID 2741 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2741,
      GIR_Done,
    // Label 519: @22709
    GIM_Try, /*On fail goto*//*Label 520*/ 22743, // Rule ID 2742 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4bf16] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2742,
      GIR_Done,
    // Label 520: @22743
    GIM_Try, /*On fail goto*//*Label 521*/ 22777, // Rule ID 2743 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2743,
      GIR_Done,
    // Label 521: @22777
    GIM_Try, /*On fail goto*//*Label 522*/ 22811, // Rule ID 2744 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2744,
      GIR_Done,
    // Label 522: @22811
    GIM_Try, /*On fail goto*//*Label 523*/ 22845, // Rule ID 2745 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2745,
      GIR_Done,
    // Label 523: @22845
    GIM_Try, /*On fail goto*//*Label 524*/ 22879, // Rule ID 2746 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2746,
      GIR_Done,
    // Label 524: @22879
    GIM_Try, /*On fail goto*//*Label 525*/ 22913, // Rule ID 2747 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2747,
      GIR_Done,
    // Label 525: @22913
    GIM_Try, /*On fail goto*//*Label 526*/ 22947, // Rule ID 2748 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4bf16] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2748,
      GIR_Done,
    // Label 526: @22947
    GIM_Try, /*On fail goto*//*Label 527*/ 22981, // Rule ID 2749 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2749,
      GIR_Done,
    // Label 527: @22981
    GIM_Try, /*On fail goto*//*Label 528*/ 23015, // Rule ID 2750 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2750,
      GIR_Done,
    // Label 528: @23015
    GIM_Try, /*On fail goto*//*Label 529*/ 23054, // Rule ID 2831 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2f32] }:$src)  =>  (VREV64d32:{ *:[f64] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2831,
      GIR_Done,
    // Label 529: @23054
    GIM_Try, /*On fail goto*//*Label 530*/ 23093, // Rule ID 2832 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2i32] }:$src)  =>  (VREV64d32:{ *:[f64] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2832,
      GIR_Done,
    // Label 530: @23093
    GIM_Try, /*On fail goto*//*Label 531*/ 23132, // Rule ID 2833 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4f16] }:$src)  =>  (VREV64d16:{ *:[f64] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2833,
      GIR_Done,
    // Label 531: @23132
    GIM_Try, /*On fail goto*//*Label 532*/ 23171, // Rule ID 2834 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4bf16] }:$src)  =>  (VREV64d16:{ *:[f64] } DPR:{ *:[v4bf16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2834,
      GIR_Done,
    // Label 532: @23171
    GIM_Try, /*On fail goto*//*Label 533*/ 23210, // Rule ID 2835 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4i16] }:$src)  =>  (VREV64d16:{ *:[f64] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2835,
      GIR_Done,
    // Label 533: @23210
    GIM_Try, /*On fail goto*//*Label 534*/ 23249, // Rule ID 2836 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[f64] } DPR:{ *:[v8i8] }:$src)  =>  (VREV64d8:{ *:[f64] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2836,
      GIR_Done,
    // Label 534: @23249
    GIM_Try, /*On fail goto*//*Label 535*/ 23288, // Rule ID 2837 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2f32] }:$src)  =>  (VREV64d32:{ *:[v1i64] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2837,
      GIR_Done,
    // Label 535: @23288
    GIM_Try, /*On fail goto*//*Label 536*/ 23327, // Rule ID 2838 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2i32] }:$src)  =>  (VREV64d32:{ *:[v1i64] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2838,
      GIR_Done,
    // Label 536: @23327
    GIM_Try, /*On fail goto*//*Label 537*/ 23366, // Rule ID 2839 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4f16] }:$src)  =>  (VREV64d16:{ *:[v1i64] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2839,
      GIR_Done,
    // Label 537: @23366
    GIM_Try, /*On fail goto*//*Label 538*/ 23405, // Rule ID 2840 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4bf16] }:$src)  =>  (VREV64d16:{ *:[v1i64] } DPR:{ *:[v4bf16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2840,
      GIR_Done,
    // Label 538: @23405
    GIM_Try, /*On fail goto*//*Label 539*/ 23444, // Rule ID 2841 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4i16] }:$src)  =>  (VREV64d16:{ *:[v1i64] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2841,
      GIR_Done,
    // Label 539: @23444
    GIM_Try, /*On fail goto*//*Label 540*/ 23483, // Rule ID 2842 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v8i8] }:$src)  =>  (VREV64d8:{ *:[v1i64] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2842,
      GIR_Done,
    // Label 540: @23483
    GIM_Reject,
    // Label 503: @23484
    GIM_Try, /*On fail goto*//*Label 541*/ 23518, // Rule ID 2725 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2725,
      GIR_Done,
    // Label 541: @23518
    GIM_Try, /*On fail goto*//*Label 542*/ 23552, // Rule ID 2726 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2726,
      GIR_Done,
    // Label 542: @23552
    GIM_Try, /*On fail goto*//*Label 543*/ 23586, // Rule ID 2751 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2751,
      GIR_Done,
    // Label 543: @23586
    GIM_Try, /*On fail goto*//*Label 544*/ 23620, // Rule ID 2752 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2752,
      GIR_Done,
    // Label 544: @23620
    GIM_Try, /*On fail goto*//*Label 545*/ 23654, // Rule ID 2753 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2753,
      GIR_Done,
    // Label 545: @23654
    GIM_Try, /*On fail goto*//*Label 546*/ 23688, // Rule ID 2754 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4bf16] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2754,
      GIR_Done,
    // Label 546: @23688
    GIM_Try, /*On fail goto*//*Label 547*/ 23722, // Rule ID 2755 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2755,
      GIR_Done,
    // Label 547: @23722
    GIM_Try, /*On fail goto*//*Label 548*/ 23756, // Rule ID 2756 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2756,
      GIR_Done,
    // Label 548: @23756
    GIM_Try, /*On fail goto*//*Label 549*/ 23790, // Rule ID 2757 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2757,
      GIR_Done,
    // Label 549: @23790
    GIM_Try, /*On fail goto*//*Label 550*/ 23824, // Rule ID 2758 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2758,
      GIR_Done,
    // Label 550: @23824
    GIM_Try, /*On fail goto*//*Label 551*/ 23858, // Rule ID 2759 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2759,
      GIR_Done,
    // Label 551: @23858
    GIM_Try, /*On fail goto*//*Label 552*/ 23892, // Rule ID 2760 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4bf16] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2760,
      GIR_Done,
    // Label 552: @23892
    GIM_Try, /*On fail goto*//*Label 553*/ 23926, // Rule ID 2761 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2761,
      GIR_Done,
    // Label 553: @23926
    GIM_Try, /*On fail goto*//*Label 554*/ 23960, // Rule ID 2762 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2762,
      GIR_Done,
    // Label 554: @23960
    GIM_Try, /*On fail goto*//*Label 555*/ 23999, // Rule ID 2843 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[f64] }:$src)  =>  (VREV64d32:{ *:[v2f32] } DPR:{ *:[f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2843,
      GIR_Done,
    // Label 555: @23999
    GIM_Try, /*On fail goto*//*Label 556*/ 24038, // Rule ID 2844 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d32:{ *:[v2f32] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2844,
      GIR_Done,
    // Label 556: @24038
    GIM_Try, /*On fail goto*//*Label 557*/ 24077, // Rule ID 2845 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4f16] }:$src)  =>  (VREV32d16:{ *:[v2f32] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2845,
      GIR_Done,
    // Label 557: @24077
    GIM_Try, /*On fail goto*//*Label 558*/ 24116, // Rule ID 2846 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4bf16] }:$src)  =>  (VREV32d16:{ *:[v2f32] } DPR:{ *:[v4bf16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2846,
      GIR_Done,
    // Label 558: @24116
    GIM_Try, /*On fail goto*//*Label 559*/ 24155, // Rule ID 2847 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4i16] }:$src)  =>  (VREV32d16:{ *:[v2f32] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2847,
      GIR_Done,
    // Label 559: @24155
    GIM_Try, /*On fail goto*//*Label 560*/ 24194, // Rule ID 2848 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v8i8] }:$src)  =>  (VREV32d8:{ *:[v2f32] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2848,
      GIR_Done,
    // Label 560: @24194
    GIM_Try, /*On fail goto*//*Label 561*/ 24233, // Rule ID 2849 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[f64] }:$src)  =>  (VREV64d32:{ *:[v2i32] } DPR:{ *:[f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2849,
      GIR_Done,
    // Label 561: @24233
    GIM_Try, /*On fail goto*//*Label 562*/ 24272, // Rule ID 2850 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d32:{ *:[v2i32] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2850,
      GIR_Done,
    // Label 562: @24272
    GIM_Try, /*On fail goto*//*Label 563*/ 24311, // Rule ID 2851 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4f16] }:$src)  =>  (VREV32d16:{ *:[v2i32] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2851,
      GIR_Done,
    // Label 563: @24311
    GIM_Try, /*On fail goto*//*Label 564*/ 24350, // Rule ID 2852 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4bf16] }:$src)  =>  (VREV32d16:{ *:[v2i32] } DPR:{ *:[v4bf16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2852,
      GIR_Done,
    // Label 564: @24350
    GIM_Try, /*On fail goto*//*Label 565*/ 24389, // Rule ID 2853 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4i16] }:$src)  =>  (VREV32d16:{ *:[v2i32] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2853,
      GIR_Done,
    // Label 565: @24389
    GIM_Try, /*On fail goto*//*Label 566*/ 24428, // Rule ID 2854 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v8i8] }:$src)  =>  (VREV32d8:{ *:[v2i32] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2854,
      GIR_Done,
    // Label 566: @24428
    GIM_Reject,
    // Label 504: @24429
    GIM_Try, /*On fail goto*//*Label 567*/ 24463, // Rule ID 2731 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2731,
      GIR_Done,
    // Label 567: @24463
    GIM_Try, /*On fail goto*//*Label 568*/ 24497, // Rule ID 2732 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2732,
      GIR_Done,
    // Label 568: @24497
    GIM_Try, /*On fail goto*//*Label 569*/ 24531, // Rule ID 2785 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2785,
      GIR_Done,
    // Label 569: @24531
    GIM_Try, /*On fail goto*//*Label 570*/ 24565, // Rule ID 2786 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2786,
      GIR_Done,
    // Label 570: @24565
    GIM_Try, /*On fail goto*//*Label 571*/ 24599, // Rule ID 2787 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2787,
      GIR_Done,
    // Label 571: @24599
    GIM_Try, /*On fail goto*//*Label 572*/ 24633, // Rule ID 2788 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8bf16] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2788,
      GIR_Done,
    // Label 572: @24633
    GIM_Try, /*On fail goto*//*Label 573*/ 24667, // Rule ID 2789 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2789,
      GIR_Done,
    // Label 573: @24667
    GIM_Try, /*On fail goto*//*Label 574*/ 24701, // Rule ID 2790 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2790,
      GIR_Done,
    // Label 574: @24701
    GIM_Try, /*On fail goto*//*Label 575*/ 24735, // Rule ID 2791 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2791,
      GIR_Done,
    // Label 575: @24735
    GIM_Try, /*On fail goto*//*Label 576*/ 24769, // Rule ID 2792 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2792,
      GIR_Done,
    // Label 576: @24769
    GIM_Try, /*On fail goto*//*Label 577*/ 24803, // Rule ID 2793 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2793,
      GIR_Done,
    // Label 577: @24803
    GIM_Try, /*On fail goto*//*Label 578*/ 24837, // Rule ID 2794 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8bf16] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2794,
      GIR_Done,
    // Label 578: @24837
    GIM_Try, /*On fail goto*//*Label 579*/ 24871, // Rule ID 2795 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2795,
      GIR_Done,
    // Label 579: @24871
    GIM_Try, /*On fail goto*//*Label 580*/ 24905, // Rule ID 2796 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2796,
      GIR_Done,
    // Label 580: @24905
    GIM_Try, /*On fail goto*//*Label 581*/ 24944, // Rule ID 2877 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)  =>  (VREV64q32:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2877,
      GIR_Done,
    // Label 581: @24944
    GIM_Try, /*On fail goto*//*Label 582*/ 24983, // Rule ID 2878 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)  =>  (VREV64q32:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2878,
      GIR_Done,
    // Label 582: @24983
    GIM_Try, /*On fail goto*//*Label 583*/ 25022, // Rule ID 2879 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)  =>  (VREV64q16:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2879,
      GIR_Done,
    // Label 583: @25022
    GIM_Try, /*On fail goto*//*Label 584*/ 25061, // Rule ID 2880 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8bf16] }:$src)  =>  (VREV64q16:{ *:[v2f64] } QPR:{ *:[v8bf16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2880,
      GIR_Done,
    // Label 584: @25061
    GIM_Try, /*On fail goto*//*Label 585*/ 25100, // Rule ID 2881 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)  =>  (VREV64q16:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2881,
      GIR_Done,
    // Label 585: @25100
    GIM_Try, /*On fail goto*//*Label 586*/ 25139, // Rule ID 2882 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)  =>  (VREV64q8:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2882,
      GIR_Done,
    // Label 586: @25139
    GIM_Try, /*On fail goto*//*Label 587*/ 25178, // Rule ID 2883 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)  =>  (VREV64q32:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2883,
      GIR_Done,
    // Label 587: @25178
    GIM_Try, /*On fail goto*//*Label 588*/ 25217, // Rule ID 2884 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)  =>  (VREV64q32:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2884,
      GIR_Done,
    // Label 588: @25217
    GIM_Try, /*On fail goto*//*Label 589*/ 25256, // Rule ID 2885 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8f16] }:$src)  =>  (VREV64q16:{ *:[v2i64] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2885,
      GIR_Done,
    // Label 589: @25256
    GIM_Try, /*On fail goto*//*Label 590*/ 25295, // Rule ID 2886 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8bf16] }:$src)  =>  (VREV64q16:{ *:[v2i64] } QPR:{ *:[v8bf16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2886,
      GIR_Done,
    // Label 590: @25295
    GIM_Try, /*On fail goto*//*Label 591*/ 25334, // Rule ID 2887 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)  =>  (VREV64q16:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2887,
      GIR_Done,
    // Label 591: @25334
    GIM_Try, /*On fail goto*//*Label 592*/ 25373, // Rule ID 2888 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)  =>  (VREV64q8:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2888,
      GIR_Done,
    // Label 592: @25373
    GIM_Try, /*On fail goto*//*Label 593*/ 25407, // Rule ID 5323 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5323,
      GIR_Done,
    // Label 593: @25407
    GIM_Try, /*On fail goto*//*Label 594*/ 25441, // Rule ID 5324 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5324,
      GIR_Done,
    // Label 594: @25441
    GIM_Try, /*On fail goto*//*Label 595*/ 25475, // Rule ID 5329 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5329,
      GIR_Done,
    // Label 595: @25475
    GIM_Try, /*On fail goto*//*Label 596*/ 25509, // Rule ID 5330 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5330,
      GIR_Done,
    // Label 596: @25509
    GIM_Try, /*On fail goto*//*Label 597*/ 25543, // Rule ID 5331 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5331,
      GIR_Done,
    // Label 597: @25543
    GIM_Try, /*On fail goto*//*Label 598*/ 25577, // Rule ID 5332 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5332,
      GIR_Done,
    // Label 598: @25577
    GIM_Try, /*On fail goto*//*Label 599*/ 25611, // Rule ID 5333 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5333,
      GIR_Done,
    // Label 599: @25611
    GIM_Try, /*On fail goto*//*Label 600*/ 25645, // Rule ID 5334 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5334,
      GIR_Done,
    // Label 600: @25645
    GIM_Try, /*On fail goto*//*Label 601*/ 25679, // Rule ID 5335 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5335,
      GIR_Done,
    // Label 601: @25679
    GIM_Try, /*On fail goto*//*Label 602*/ 25713, // Rule ID 5336 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5336,
      GIR_Done,
    // Label 602: @25713
    GIM_Try, /*On fail goto*//*Label 603*/ 25747, // Rule ID 5337 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5337,
      GIR_Done,
    // Label 603: @25747
    GIM_Try, /*On fail goto*//*Label 604*/ 25781, // Rule ID 5338 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5338,
      GIR_Done,
    // Label 604: @25781
    GIM_Try, /*On fail goto*//*Label 605*/ 25838, // Rule ID 5365 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV64_32:{ *:[v2f64] } MQPR:{ *:[v4f32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV64_32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5365,
      GIR_Done,
    // Label 605: @25838
    GIM_Try, /*On fail goto*//*Label 606*/ 25895, // Rule ID 5366 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV64_32:{ *:[v2f64] } MQPR:{ *:[v4i32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV64_32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5366,
      GIR_Done,
    // Label 606: @25895
    GIM_Try, /*On fail goto*//*Label 607*/ 25952, // Rule ID 5367 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV64_16:{ *:[v2f64] } MQPR:{ *:[v8f16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV64_16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5367,
      GIR_Done,
    // Label 607: @25952
    GIM_Try, /*On fail goto*//*Label 608*/ 26009, // Rule ID 5368 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV64_16:{ *:[v2f64] } MQPR:{ *:[v8i16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV64_16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5368,
      GIR_Done,
    // Label 608: @26009
    GIM_Try, /*On fail goto*//*Label 609*/ 26066, // Rule ID 5369 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV64_8:{ *:[v2f64] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV64_8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5369,
      GIR_Done,
    // Label 609: @26066
    GIM_Try, /*On fail goto*//*Label 610*/ 26123, // Rule ID 5370 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV64_32:{ *:[v2i64] } MQPR:{ *:[v4f32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV64_32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5370,
      GIR_Done,
    // Label 610: @26123
    GIM_Try, /*On fail goto*//*Label 611*/ 26180, // Rule ID 5371 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV64_32:{ *:[v2i64] } MQPR:{ *:[v4i32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV64_32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5371,
      GIR_Done,
    // Label 611: @26180
    GIM_Try, /*On fail goto*//*Label 612*/ 26237, // Rule ID 5372 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV64_16:{ *:[v2i64] } MQPR:{ *:[v8f16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV64_16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5372,
      GIR_Done,
    // Label 612: @26237
    GIM_Try, /*On fail goto*//*Label 613*/ 26294, // Rule ID 5373 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV64_16:{ *:[v2i64] } MQPR:{ *:[v8i16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV64_16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5373,
      GIR_Done,
    // Label 613: @26294
    GIM_Try, /*On fail goto*//*Label 614*/ 26351, // Rule ID 5374 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV64_8:{ *:[v2i64] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV64_8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5374,
      GIR_Done,
    // Label 614: @26351
    GIM_Reject,
    // Label 505: @26352
    GIM_Try, /*On fail goto*//*Label 615*/ 26386, // Rule ID 2727 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2727,
      GIR_Done,
    // Label 615: @26386
    GIM_Try, /*On fail goto*//*Label 616*/ 26420, // Rule ID 2728 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2728,
      GIR_Done,
    // Label 616: @26420
    GIM_Try, /*On fail goto*//*Label 617*/ 26454, // Rule ID 2729 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v4bf16] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2729,
      GIR_Done,
    // Label 617: @26454
    GIM_Try, /*On fail goto*//*Label 618*/ 26488, // Rule ID 2730 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v4bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2730,
      GIR_Done,
    // Label 618: @26488
    GIM_Try, /*On fail goto*//*Label 619*/ 26522, // Rule ID 2763 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2763,
      GIR_Done,
    // Label 619: @26522
    GIM_Try, /*On fail goto*//*Label 620*/ 26556, // Rule ID 2764 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2764,
      GIR_Done,
    // Label 620: @26556
    GIM_Try, /*On fail goto*//*Label 621*/ 26590, // Rule ID 2765 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2765,
      GIR_Done,
    // Label 621: @26590
    GIM_Try, /*On fail goto*//*Label 622*/ 26624, // Rule ID 2766 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2766,
      GIR_Done,
    // Label 622: @26624
    GIM_Try, /*On fail goto*//*Label 623*/ 26658, // Rule ID 2767 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2767,
      GIR_Done,
    // Label 623: @26658
    GIM_Try, /*On fail goto*//*Label 624*/ 26692, // Rule ID 2768 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v4bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2768,
      GIR_Done,
    // Label 624: @26692
    GIM_Try, /*On fail goto*//*Label 625*/ 26726, // Rule ID 2769 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v4bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2769,
      GIR_Done,
    // Label 625: @26726
    GIM_Try, /*On fail goto*//*Label 626*/ 26760, // Rule ID 2770 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v4bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2770,
      GIR_Done,
    // Label 626: @26760
    GIM_Try, /*On fail goto*//*Label 627*/ 26794, // Rule ID 2771 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v4bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2771,
      GIR_Done,
    // Label 627: @26794
    GIM_Try, /*On fail goto*//*Label 628*/ 26828, // Rule ID 2772 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v4bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2772,
      GIR_Done,
    // Label 628: @26828
    GIM_Try, /*On fail goto*//*Label 629*/ 26862, // Rule ID 2773 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2773,
      GIR_Done,
    // Label 629: @26862
    GIM_Try, /*On fail goto*//*Label 630*/ 26896, // Rule ID 2774 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2774,
      GIR_Done,
    // Label 630: @26896
    GIM_Try, /*On fail goto*//*Label 631*/ 26930, // Rule ID 2775 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2775,
      GIR_Done,
    // Label 631: @26930
    GIM_Try, /*On fail goto*//*Label 632*/ 26964, // Rule ID 2776 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2776,
      GIR_Done,
    // Label 632: @26964
    GIM_Try, /*On fail goto*//*Label 633*/ 26998, // Rule ID 2777 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2777,
      GIR_Done,
    // Label 633: @26998
    GIM_Try, /*On fail goto*//*Label 634*/ 27037, // Rule ID 2855 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[f64] }:$src)  =>  (VREV64d16:{ *:[v4f16] } DPR:{ *:[f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2855,
      GIR_Done,
    // Label 634: @27037
    GIM_Try, /*On fail goto*//*Label 635*/ 27076, // Rule ID 2856 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d16:{ *:[v4f16] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2856,
      GIR_Done,
    // Label 635: @27076
    GIM_Try, /*On fail goto*//*Label 636*/ 27115, // Rule ID 2857 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d16:{ *:[v4f16] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2857,
      GIR_Done,
    // Label 636: @27115
    GIM_Try, /*On fail goto*//*Label 637*/ 27154, // Rule ID 2858 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d16:{ *:[v4f16] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2858,
      GIR_Done,
    // Label 637: @27154
    GIM_Try, /*On fail goto*//*Label 638*/ 27193, // Rule ID 2859 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v8i8] }:$src)  =>  (VREV16d8:{ *:[v4f16] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2859,
      GIR_Done,
    // Label 638: @27193
    GIM_Try, /*On fail goto*//*Label 639*/ 27232, // Rule ID 2860 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[f64] }:$src)  =>  (VREV64d16:{ *:[v4bf16] } DPR:{ *:[f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2860,
      GIR_Done,
    // Label 639: @27232
    GIM_Try, /*On fail goto*//*Label 640*/ 27271, // Rule ID 2861 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d16:{ *:[v4bf16] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2861,
      GIR_Done,
    // Label 640: @27271
    GIM_Try, /*On fail goto*//*Label 641*/ 27310, // Rule ID 2862 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d16:{ *:[v4bf16] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2862,
      GIR_Done,
    // Label 641: @27310
    GIM_Try, /*On fail goto*//*Label 642*/ 27349, // Rule ID 2863 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d16:{ *:[v4bf16] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2863,
      GIR_Done,
    // Label 642: @27349
    GIM_Try, /*On fail goto*//*Label 643*/ 27388, // Rule ID 2864 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v8i8] }:$src)  =>  (VREV16d8:{ *:[v4bf16] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2864,
      GIR_Done,
    // Label 643: @27388
    GIM_Try, /*On fail goto*//*Label 644*/ 27427, // Rule ID 2865 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[f64] }:$src)  =>  (VREV64d16:{ *:[v4i16] } DPR:{ *:[f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2865,
      GIR_Done,
    // Label 644: @27427
    GIM_Try, /*On fail goto*//*Label 645*/ 27466, // Rule ID 2866 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d16:{ *:[v4i16] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2866,
      GIR_Done,
    // Label 645: @27466
    GIM_Try, /*On fail goto*//*Label 646*/ 27505, // Rule ID 2867 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d16:{ *:[v4i16] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2867,
      GIR_Done,
    // Label 646: @27505
    GIM_Try, /*On fail goto*//*Label 647*/ 27544, // Rule ID 2868 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d16:{ *:[v4i16] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2868,
      GIR_Done,
    // Label 647: @27544
    GIM_Try, /*On fail goto*//*Label 648*/ 27583, // Rule ID 2869 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v8i8] }:$src)  =>  (VREV16d8:{ *:[v4i16] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2869,
      GIR_Done,
    // Label 648: @27583
    GIM_Reject,
    // Label 506: @27584
    GIM_Try, /*On fail goto*//*Label 649*/ 27618, // Rule ID 2733 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2733,
      GIR_Done,
    // Label 649: @27618
    GIM_Try, /*On fail goto*//*Label 650*/ 27652, // Rule ID 2734 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2734,
      GIR_Done,
    // Label 650: @27652
    GIM_Try, /*On fail goto*//*Label 651*/ 27686, // Rule ID 2797 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2797,
      GIR_Done,
    // Label 651: @27686
    GIM_Try, /*On fail goto*//*Label 652*/ 27720, // Rule ID 2798 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2798,
      GIR_Done,
    // Label 652: @27720
    GIM_Try, /*On fail goto*//*Label 653*/ 27754, // Rule ID 2799 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2799,
      GIR_Done,
    // Label 653: @27754
    GIM_Try, /*On fail goto*//*Label 654*/ 27788, // Rule ID 2800 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8bf16] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2800,
      GIR_Done,
    // Label 654: @27788
    GIM_Try, /*On fail goto*//*Label 655*/ 27822, // Rule ID 2801 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2801,
      GIR_Done,
    // Label 655: @27822
    GIM_Try, /*On fail goto*//*Label 656*/ 27856, // Rule ID 2802 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2802,
      GIR_Done,
    // Label 656: @27856
    GIM_Try, /*On fail goto*//*Label 657*/ 27890, // Rule ID 2803 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2803,
      GIR_Done,
    // Label 657: @27890
    GIM_Try, /*On fail goto*//*Label 658*/ 27924, // Rule ID 2804 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2804,
      GIR_Done,
    // Label 658: @27924
    GIM_Try, /*On fail goto*//*Label 659*/ 27958, // Rule ID 2805 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2805,
      GIR_Done,
    // Label 659: @27958
    GIM_Try, /*On fail goto*//*Label 660*/ 27992, // Rule ID 2806 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8bf16] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2806,
      GIR_Done,
    // Label 660: @27992
    GIM_Try, /*On fail goto*//*Label 661*/ 28026, // Rule ID 2807 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2807,
      GIR_Done,
    // Label 661: @28026
    GIM_Try, /*On fail goto*//*Label 662*/ 28060, // Rule ID 2808 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2808,
      GIR_Done,
    // Label 662: @28060
    GIM_Try, /*On fail goto*//*Label 663*/ 28099, // Rule ID 2889 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q32:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2889,
      GIR_Done,
    // Label 663: @28099
    GIM_Try, /*On fail goto*//*Label 664*/ 28138, // Rule ID 2890 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q32:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2890,
      GIR_Done,
    // Label 664: @28138
    GIM_Try, /*On fail goto*//*Label 665*/ 28177, // Rule ID 2891 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8f16] }:$src)  =>  (VREV32q16:{ *:[v4f32] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2891,
      GIR_Done,
    // Label 665: @28177
    GIM_Try, /*On fail goto*//*Label 666*/ 28216, // Rule ID 2892 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8bf16] }:$src)  =>  (VREV32q16:{ *:[v4f32] } QPR:{ *:[v8bf16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2892,
      GIR_Done,
    // Label 666: @28216
    GIM_Try, /*On fail goto*//*Label 667*/ 28255, // Rule ID 2893 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)  =>  (VREV32q16:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2893,
      GIR_Done,
    // Label 667: @28255
    GIM_Try, /*On fail goto*//*Label 668*/ 28294, // Rule ID 2894 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)  =>  (VREV32q8:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2894,
      GIR_Done,
    // Label 668: @28294
    GIM_Try, /*On fail goto*//*Label 669*/ 28333, // Rule ID 2895 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q32:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2895,
      GIR_Done,
    // Label 669: @28333
    GIM_Try, /*On fail goto*//*Label 670*/ 28372, // Rule ID 2896 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q32:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2896,
      GIR_Done,
    // Label 670: @28372
    GIM_Try, /*On fail goto*//*Label 671*/ 28411, // Rule ID 2897 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8f16] }:$src)  =>  (VREV32q16:{ *:[v4i32] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2897,
      GIR_Done,
    // Label 671: @28411
    GIM_Try, /*On fail goto*//*Label 672*/ 28450, // Rule ID 2898 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8bf16] }:$src)  =>  (VREV32q16:{ *:[v4i32] } QPR:{ *:[v8bf16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2898,
      GIR_Done,
    // Label 672: @28450
    GIM_Try, /*On fail goto*//*Label 673*/ 28489, // Rule ID 2899 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)  =>  (VREV32q16:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2899,
      GIR_Done,
    // Label 673: @28489
    GIM_Try, /*On fail goto*//*Label 674*/ 28528, // Rule ID 2900 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)  =>  (VREV32q8:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2900,
      GIR_Done,
    // Label 674: @28528
    GIM_Try, /*On fail goto*//*Label 675*/ 28562, // Rule ID 5325 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5325,
      GIR_Done,
    // Label 675: @28562
    GIM_Try, /*On fail goto*//*Label 676*/ 28596, // Rule ID 5326 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5326,
      GIR_Done,
    // Label 676: @28596
    GIM_Try, /*On fail goto*//*Label 677*/ 28630, // Rule ID 5339 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5339,
      GIR_Done,
    // Label 677: @28630
    GIM_Try, /*On fail goto*//*Label 678*/ 28664, // Rule ID 5340 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5340,
      GIR_Done,
    // Label 678: @28664
    GIM_Try, /*On fail goto*//*Label 679*/ 28698, // Rule ID 5341 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5341,
      GIR_Done,
    // Label 679: @28698
    GIM_Try, /*On fail goto*//*Label 680*/ 28732, // Rule ID 5342 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5342,
      GIR_Done,
    // Label 680: @28732
    GIM_Try, /*On fail goto*//*Label 681*/ 28766, // Rule ID 5343 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5343,
      GIR_Done,
    // Label 681: @28766
    GIM_Try, /*On fail goto*//*Label 682*/ 28800, // Rule ID 5344 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5344,
      GIR_Done,
    // Label 682: @28800
    GIM_Try, /*On fail goto*//*Label 683*/ 28834, // Rule ID 5345 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5345,
      GIR_Done,
    // Label 683: @28834
    GIM_Try, /*On fail goto*//*Label 684*/ 28868, // Rule ID 5346 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5346,
      GIR_Done,
    // Label 684: @28868
    GIM_Try, /*On fail goto*//*Label 685*/ 28902, // Rule ID 5347 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5347,
      GIR_Done,
    // Label 685: @28902
    GIM_Try, /*On fail goto*//*Label 686*/ 28936, // Rule ID 5348 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5348,
      GIR_Done,
    // Label 686: @28936
    GIM_Try, /*On fail goto*//*Label 687*/ 28993, // Rule ID 5375 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_32:{ *:[v4f32] } MQPR:{ *:[v2f64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV64_32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5375,
      GIR_Done,
    // Label 687: @28993
    GIM_Try, /*On fail goto*//*Label 688*/ 29050, // Rule ID 5376 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_32:{ *:[v4f32] } MQPR:{ *:[v2i64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV64_32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5376,
      GIR_Done,
    // Label 688: @29050
    GIM_Try, /*On fail goto*//*Label 689*/ 29107, // Rule ID 5377 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV32_16:{ *:[v4f32] } MQPR:{ *:[v8f16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV32_16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5377,
      GIR_Done,
    // Label 689: @29107
    GIM_Try, /*On fail goto*//*Label 690*/ 29164, // Rule ID 5378 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV32_16:{ *:[v4f32] } MQPR:{ *:[v8i16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV32_16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5378,
      GIR_Done,
    // Label 690: @29164
    GIM_Try, /*On fail goto*//*Label 691*/ 29221, // Rule ID 5379 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV32_8:{ *:[v4f32] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV32_8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5379,
      GIR_Done,
    // Label 691: @29221
    GIM_Try, /*On fail goto*//*Label 692*/ 29278, // Rule ID 5380 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_32:{ *:[v4i32] } MQPR:{ *:[v2f64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV64_32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5380,
      GIR_Done,
    // Label 692: @29278
    GIM_Try, /*On fail goto*//*Label 693*/ 29335, // Rule ID 5381 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_32:{ *:[v4i32] } MQPR:{ *:[v2i64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV64_32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5381,
      GIR_Done,
    // Label 693: @29335
    GIM_Try, /*On fail goto*//*Label 694*/ 29392, // Rule ID 5382 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV32_16:{ *:[v4i32] } MQPR:{ *:[v8f16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV32_16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5382,
      GIR_Done,
    // Label 694: @29392
    GIM_Try, /*On fail goto*//*Label 695*/ 29449, // Rule ID 5383 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV32_16:{ *:[v4i32] } MQPR:{ *:[v8i16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV32_16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5383,
      GIR_Done,
    // Label 695: @29449
    GIM_Try, /*On fail goto*//*Label 696*/ 29506, // Rule ID 5384 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV32_8:{ *:[v4i32] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV32_8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5384,
      GIR_Done,
    // Label 696: @29506
    GIM_Reject,
    // Label 507: @29507
    GIM_Try, /*On fail goto*//*Label 697*/ 29541, // Rule ID 2778 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2778,
      GIR_Done,
    // Label 697: @29541
    GIM_Try, /*On fail goto*//*Label 698*/ 29575, // Rule ID 2779 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2779,
      GIR_Done,
    // Label 698: @29575
    GIM_Try, /*On fail goto*//*Label 699*/ 29609, // Rule ID 2780 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2780,
      GIR_Done,
    // Label 699: @29609
    GIM_Try, /*On fail goto*//*Label 700*/ 29643, // Rule ID 2781 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2781,
      GIR_Done,
    // Label 700: @29643
    GIM_Try, /*On fail goto*//*Label 701*/ 29677, // Rule ID 2782 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2782,
      GIR_Done,
    // Label 701: @29677
    GIM_Try, /*On fail goto*//*Label 702*/ 29711, // Rule ID 2783 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4bf16] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2783,
      GIR_Done,
    // Label 702: @29711
    GIM_Try, /*On fail goto*//*Label 703*/ 29745, // Rule ID 2784 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::DPRRegClassID,
      // GIR_Coverage, 2784,
      GIR_Done,
    // Label 703: @29745
    GIM_Try, /*On fail goto*//*Label 704*/ 29784, // Rule ID 2870 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[f64] }:$src)  =>  (VREV64d8:{ *:[v8i8] } DPR:{ *:[f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2870,
      GIR_Done,
    // Label 704: @29784
    GIM_Try, /*On fail goto*//*Label 705*/ 29823, // Rule ID 2871 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d8:{ *:[v8i8] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2871,
      GIR_Done,
    // Label 705: @29823
    GIM_Try, /*On fail goto*//*Label 706*/ 29862, // Rule ID 2872 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d8:{ *:[v8i8] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2872,
      GIR_Done,
    // Label 706: @29862
    GIM_Try, /*On fail goto*//*Label 707*/ 29901, // Rule ID 2873 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d8:{ *:[v8i8] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2873,
      GIR_Done,
    // Label 707: @29901
    GIM_Try, /*On fail goto*//*Label 708*/ 29940, // Rule ID 2874 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4f16] }:$src)  =>  (VREV16d8:{ *:[v8i8] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2874,
      GIR_Done,
    // Label 708: @29940
    GIM_Try, /*On fail goto*//*Label 709*/ 29979, // Rule ID 2875 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4bf16] }:$src)  =>  (VREV16d8:{ *:[v8i8] } DPR:{ *:[v4bf16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2875,
      GIR_Done,
    // Label 709: @29979
    GIM_Try, /*On fail goto*//*Label 710*/ 30018, // Rule ID 2876 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4i16] }:$src)  =>  (VREV16d8:{ *:[v8i8] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16d8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2876,
      GIR_Done,
    // Label 710: @30018
    GIM_Reject,
    // Label 508: @30019
    GIM_Try, /*On fail goto*//*Label 711*/ 30053, // Rule ID 2735 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2735,
      GIR_Done,
    // Label 711: @30053
    GIM_Try, /*On fail goto*//*Label 712*/ 30087, // Rule ID 2736 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2736,
      GIR_Done,
    // Label 712: @30087
    GIM_Try, /*On fail goto*//*Label 713*/ 30121, // Rule ID 2737 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v8bf16] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2737,
      GIR_Done,
    // Label 713: @30121
    GIM_Try, /*On fail goto*//*Label 714*/ 30155, // Rule ID 2738 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v8bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2738,
      GIR_Done,
    // Label 714: @30155
    GIM_Try, /*On fail goto*//*Label 715*/ 30189, // Rule ID 2809 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2809,
      GIR_Done,
    // Label 715: @30189
    GIM_Try, /*On fail goto*//*Label 716*/ 30223, // Rule ID 2810 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2810,
      GIR_Done,
    // Label 716: @30223
    GIM_Try, /*On fail goto*//*Label 717*/ 30257, // Rule ID 2811 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2811,
      GIR_Done,
    // Label 717: @30257
    GIM_Try, /*On fail goto*//*Label 718*/ 30291, // Rule ID 2812 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2812,
      GIR_Done,
    // Label 718: @30291
    GIM_Try, /*On fail goto*//*Label 719*/ 30325, // Rule ID 2813 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2813,
      GIR_Done,
    // Label 719: @30325
    GIM_Try, /*On fail goto*//*Label 720*/ 30359, // Rule ID 2814 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v8bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2814,
      GIR_Done,
    // Label 720: @30359
    GIM_Try, /*On fail goto*//*Label 721*/ 30393, // Rule ID 2815 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v8bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2815,
      GIR_Done,
    // Label 721: @30393
    GIM_Try, /*On fail goto*//*Label 722*/ 30427, // Rule ID 2816 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v8bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2816,
      GIR_Done,
    // Label 722: @30427
    GIM_Try, /*On fail goto*//*Label 723*/ 30461, // Rule ID 2817 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v8bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2817,
      GIR_Done,
    // Label 723: @30461
    GIM_Try, /*On fail goto*//*Label 724*/ 30495, // Rule ID 2818 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v8bf16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2818,
      GIR_Done,
    // Label 724: @30495
    GIM_Try, /*On fail goto*//*Label 725*/ 30529, // Rule ID 2819 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2819,
      GIR_Done,
    // Label 725: @30529
    GIM_Try, /*On fail goto*//*Label 726*/ 30563, // Rule ID 2820 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2820,
      GIR_Done,
    // Label 726: @30563
    GIM_Try, /*On fail goto*//*Label 727*/ 30597, // Rule ID 2821 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2821,
      GIR_Done,
    // Label 727: @30597
    GIM_Try, /*On fail goto*//*Label 728*/ 30631, // Rule ID 2822 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2822,
      GIR_Done,
    // Label 728: @30631
    GIM_Try, /*On fail goto*//*Label 729*/ 30665, // Rule ID 2823 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2823,
      GIR_Done,
    // Label 729: @30665
    GIM_Try, /*On fail goto*//*Label 730*/ 30704, // Rule ID 2901 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q16:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2901,
      GIR_Done,
    // Label 730: @30704
    GIM_Try, /*On fail goto*//*Label 731*/ 30743, // Rule ID 2902 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q16:{ *:[v8f16] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2902,
      GIR_Done,
    // Label 731: @30743
    GIM_Try, /*On fail goto*//*Label 732*/ 30782, // Rule ID 2903 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q16:{ *:[v8f16] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2903,
      GIR_Done,
    // Label 732: @30782
    GIM_Try, /*On fail goto*//*Label 733*/ 30821, // Rule ID 2904 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q16:{ *:[v8f16] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2904,
      GIR_Done,
    // Label 733: @30821
    GIM_Try, /*On fail goto*//*Label 734*/ 30860, // Rule ID 2905 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v16i8] }:$src)  =>  (VREV16q8:{ *:[v8f16] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2905,
      GIR_Done,
    // Label 734: @30860
    GIM_Try, /*On fail goto*//*Label 735*/ 30899, // Rule ID 2906 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q16:{ *:[v8bf16] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2906,
      GIR_Done,
    // Label 735: @30899
    GIM_Try, /*On fail goto*//*Label 736*/ 30938, // Rule ID 2907 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q16:{ *:[v8bf16] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2907,
      GIR_Done,
    // Label 736: @30938
    GIM_Try, /*On fail goto*//*Label 737*/ 30977, // Rule ID 2908 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q16:{ *:[v8bf16] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2908,
      GIR_Done,
    // Label 737: @30977
    GIM_Try, /*On fail goto*//*Label 738*/ 31016, // Rule ID 2909 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q16:{ *:[v8bf16] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2909,
      GIR_Done,
    // Label 738: @31016
    GIM_Try, /*On fail goto*//*Label 739*/ 31055, // Rule ID 2910 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v16i8] }:$src)  =>  (VREV16q8:{ *:[v8bf16] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2910,
      GIR_Done,
    // Label 739: @31055
    GIM_Try, /*On fail goto*//*Label 740*/ 31094, // Rule ID 2911 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q16:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2911,
      GIR_Done,
    // Label 740: @31094
    GIM_Try, /*On fail goto*//*Label 741*/ 31133, // Rule ID 2912 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q16:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2912,
      GIR_Done,
    // Label 741: @31133
    GIM_Try, /*On fail goto*//*Label 742*/ 31172, // Rule ID 2913 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q16:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2913,
      GIR_Done,
    // Label 742: @31172
    GIM_Try, /*On fail goto*//*Label 743*/ 31211, // Rule ID 2914 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q16:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2914,
      GIR_Done,
    // Label 743: @31211
    GIM_Try, /*On fail goto*//*Label 744*/ 31250, // Rule ID 2915 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)  =>  (VREV16q8:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2915,
      GIR_Done,
    // Label 744: @31250
    GIM_Try, /*On fail goto*//*Label 745*/ 31284, // Rule ID 5327 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5327,
      GIR_Done,
    // Label 745: @31284
    GIM_Try, /*On fail goto*//*Label 746*/ 31318, // Rule ID 5328 //
      GIM_CheckFeatures, GIFBS_HasMVEInt,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5328,
      GIR_Done,
    // Label 746: @31318
    GIM_Try, /*On fail goto*//*Label 747*/ 31352, // Rule ID 5349 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5349,
      GIR_Done,
    // Label 747: @31352
    GIM_Try, /*On fail goto*//*Label 748*/ 31386, // Rule ID 5350 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5350,
      GIR_Done,
    // Label 748: @31386
    GIM_Try, /*On fail goto*//*Label 749*/ 31420, // Rule ID 5351 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5351,
      GIR_Done,
    // Label 749: @31420
    GIM_Try, /*On fail goto*//*Label 750*/ 31454, // Rule ID 5352 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5352,
      GIR_Done,
    // Label 750: @31454
    GIM_Try, /*On fail goto*//*Label 751*/ 31488, // Rule ID 5353 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5353,
      GIR_Done,
    // Label 751: @31488
    GIM_Try, /*On fail goto*//*Label 752*/ 31522, // Rule ID 5354 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5354,
      GIR_Done,
    // Label 752: @31522
    GIM_Try, /*On fail goto*//*Label 753*/ 31556, // Rule ID 5355 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5355,
      GIR_Done,
    // Label 753: @31556
    GIM_Try, /*On fail goto*//*Label 754*/ 31590, // Rule ID 5356 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5356,
      GIR_Done,
    // Label 754: @31590
    GIM_Try, /*On fail goto*//*Label 755*/ 31624, // Rule ID 5357 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5357,
      GIR_Done,
    // Label 755: @31624
    GIM_Try, /*On fail goto*//*Label 756*/ 31658, // Rule ID 5358 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5358,
      GIR_Done,
    // Label 756: @31658
    GIM_Try, /*On fail goto*//*Label 757*/ 31715, // Rule ID 5385 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_16:{ *:[v8f16] } MQPR:{ *:[v2f64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV64_16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5385,
      GIR_Done,
    // Label 757: @31715
    GIM_Try, /*On fail goto*//*Label 758*/ 31772, // Rule ID 5386 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_16:{ *:[v8f16] } MQPR:{ *:[v2i64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV64_16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5386,
      GIR_Done,
    // Label 758: @31772
    GIM_Try, /*On fail goto*//*Label 759*/ 31829, // Rule ID 5387 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV32_16:{ *:[v8f16] } MQPR:{ *:[v4f32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV32_16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5387,
      GIR_Done,
    // Label 759: @31829
    GIM_Try, /*On fail goto*//*Label 760*/ 31886, // Rule ID 5388 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV32_16:{ *:[v8f16] } MQPR:{ *:[v4i32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV32_16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5388,
      GIR_Done,
    // Label 760: @31886
    GIM_Try, /*On fail goto*//*Label 761*/ 31943, // Rule ID 5389 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV16_8:{ *:[v8f16] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV16_8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5389,
      GIR_Done,
    // Label 761: @31943
    GIM_Try, /*On fail goto*//*Label 762*/ 32000, // Rule ID 5390 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_16:{ *:[v8i16] } MQPR:{ *:[v2f64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV64_16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5390,
      GIR_Done,
    // Label 762: @32000
    GIM_Try, /*On fail goto*//*Label 763*/ 32057, // Rule ID 5391 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_16:{ *:[v8i16] } MQPR:{ *:[v2i64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV64_16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5391,
      GIR_Done,
    // Label 763: @32057
    GIM_Try, /*On fail goto*//*Label 764*/ 32114, // Rule ID 5392 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV32_16:{ *:[v8i16] } MQPR:{ *:[v4f32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV32_16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5392,
      GIR_Done,
    // Label 764: @32114
    GIM_Try, /*On fail goto*//*Label 765*/ 32171, // Rule ID 5393 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV32_16:{ *:[v8i16] } MQPR:{ *:[v4i32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV32_16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5393,
      GIR_Done,
    // Label 765: @32171
    GIM_Try, /*On fail goto*//*Label 766*/ 32228, // Rule ID 5394 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV16_8:{ *:[v8i16] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV16_8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5394,
      GIR_Done,
    // Label 766: @32228
    GIM_Reject,
    // Label 509: @32229
    GIM_Try, /*On fail goto*//*Label 767*/ 32263, // Rule ID 2824 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2824,
      GIR_Done,
    // Label 767: @32263
    GIM_Try, /*On fail goto*//*Label 768*/ 32297, // Rule ID 2825 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2825,
      GIR_Done,
    // Label 768: @32297
    GIM_Try, /*On fail goto*//*Label 769*/ 32331, // Rule ID 2826 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2826,
      GIR_Done,
    // Label 769: @32331
    GIM_Try, /*On fail goto*//*Label 770*/ 32365, // Rule ID 2827 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2827,
      GIR_Done,
    // Label 770: @32365
    GIM_Try, /*On fail goto*//*Label 771*/ 32399, // Rule ID 2828 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2828,
      GIR_Done,
    // Label 771: @32399
    GIM_Try, /*On fail goto*//*Label 772*/ 32433, // Rule ID 2829 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8bf16] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2829,
      GIR_Done,
    // Label 772: @32433
    GIM_Try, /*On fail goto*//*Label 773*/ 32467, // Rule ID 2830 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::QPRRegClassID,
      // GIR_Coverage, 2830,
      GIR_Done,
    // Label 773: @32467
    GIM_Try, /*On fail goto*//*Label 774*/ 32506, // Rule ID 2916 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q8:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2916,
      GIR_Done,
    // Label 774: @32506
    GIM_Try, /*On fail goto*//*Label 775*/ 32545, // Rule ID 2917 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q8:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV64q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2917,
      GIR_Done,
    // Label 775: @32545
    GIM_Try, /*On fail goto*//*Label 776*/ 32584, // Rule ID 2918 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q8:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2918,
      GIR_Done,
    // Label 776: @32584
    GIM_Try, /*On fail goto*//*Label 777*/ 32623, // Rule ID 2919 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q8:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV32q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2919,
      GIR_Done,
    // Label 777: @32623
    GIM_Try, /*On fail goto*//*Label 778*/ 32662, // Rule ID 2920 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8f16] }:$src)  =>  (VREV16q8:{ *:[v16i8] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2920,
      GIR_Done,
    // Label 778: @32662
    GIM_Try, /*On fail goto*//*Label 779*/ 32701, // Rule ID 2921 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8bf16] }:$src)  =>  (VREV16q8:{ *:[v16i8] } QPR:{ *:[v8bf16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2921,
      GIR_Done,
    // Label 779: @32701
    GIM_Try, /*On fail goto*//*Label 780*/ 32740, // Rule ID 2922 //
      GIM_CheckFeatures, GIFBS_HasNEON_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::QPRRegClassID,
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)  =>  (VREV16q8:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VREV16q8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2922,
      GIR_Done,
    // Label 780: @32740
    GIM_Try, /*On fail goto*//*Label 781*/ 32774, // Rule ID 5359 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5359,
      GIR_Done,
    // Label 781: @32774
    GIM_Try, /*On fail goto*//*Label 782*/ 32808, // Rule ID 5360 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5360,
      GIR_Done,
    // Label 782: @32808
    GIM_Try, /*On fail goto*//*Label 783*/ 32842, // Rule ID 5361 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5361,
      GIR_Done,
    // Label 783: @32842
    GIM_Try, /*On fail goto*//*Label 784*/ 32876, // Rule ID 5362 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5362,
      GIR_Done,
    // Label 784: @32876
    GIM_Try, /*On fail goto*//*Label 785*/ 32910, // Rule ID 5363 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5363,
      GIR_Done,
    // Label 785: @32910
    GIM_Try, /*On fail goto*//*Label 786*/ 32944, // Rule ID 5364 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::MQPRRegClassID,
      // GIR_Coverage, 5364,
      GIR_Done,
    // Label 786: @32944
    GIM_Try, /*On fail goto*//*Label 787*/ 33001, // Rule ID 5395 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_8:{ *:[v16i8] } MQPR:{ *:[v2f64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV64_8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5395,
      GIR_Done,
    // Label 787: @33001
    GIM_Try, /*On fail goto*//*Label 788*/ 33058, // Rule ID 5396 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_8:{ *:[v16i8] } MQPR:{ *:[v2i64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV64_8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5396,
      GIR_Done,
    // Label 788: @33058
    GIM_Try, /*On fail goto*//*Label 789*/ 33115, // Rule ID 5397 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV32_8:{ *:[v16i8] } MQPR:{ *:[v4f32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV32_8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5397,
      GIR_Done,
    // Label 789: @33115
    GIM_Try, /*On fail goto*//*Label 790*/ 33172, // Rule ID 5398 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV32_8:{ *:[v16i8] } MQPR:{ *:[v4i32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV32_8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5398,
      GIR_Done,
    // Label 790: @33172
    GIM_Try, /*On fail goto*//*Label 791*/ 33229, // Rule ID 5399 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV16_8:{ *:[v16i8] } MQPR:{ *:[v8f16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV16_8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5399,
      GIR_Done,
    // Label 791: @33229
    GIM_Try, /*On fail goto*//*Label 792*/ 33286, // Rule ID 5400 //
      GIM_CheckFeatures, GIFBS_HasMVEInt_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV16_8:{ *:[v16i8] } MQPR:{ *:[v8i16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VREV16_8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5400,
      GIR_Done,
    // Label 792: @33286
    GIM_Reject,
    // Label 510: @33287
    GIM_Reject,
    // Label 10: @33288
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 13, /*)*//*default:*//*Label 798*/ 33543,
    /*GILLT_s16*//*Label 793*/ 33307,
    /*GILLT_s32*//*Label 794*/ 33347,
    /*GILLT_s64*//*Label 795*/ 33387, 0, 0, 0, 0, 0,
    /*GILLT_v4s32*//*Label 796*/ 33427, 0, 0, 0,
    /*GILLT_v8s16*//*Label 797*/ 33485,
    // Label 793: @33307
    GIM_Try, /*On fail goto*//*Label 799*/ 33346, // Rule ID 681 //
      GIM_CheckFeatures, GIFBS_HasFullFP16,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::HPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::HPRRegClassID,
      // (ftrunc:{ *:[f16] } HPR:{ *:[f16] }:$Sm)  =>  (VRINTZH:{ *:[f16] } HPR:{ *:[f16] }:$Sm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTZH,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Sm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 681,
      GIR_Done,
    // Label 799: @33346
    GIM_Reject,
    // Label 794: @33347
    GIM_Try, /*On fail goto*//*Label 800*/ 33386, // Rule ID 682 //
      GIM_CheckFeatures, GIFBS_HasFPARMv8,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::SPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::SPRRegClassID,
      // (ftrunc:{ *:[f32] } SPR:{ *:[f32] }:$Sm)  =>  (VRINTZS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTZS,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Sm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 682,
      GIR_Done,
    // Label 800: @33386
    GIM_Reject,
    // Label 795: @33387
    GIM_Try, /*On fail goto*//*Label 801*/ 33426, // Rule ID 683 //
      GIM_CheckFeatures, GIFBS_HasDPVFP_HasFPARMv8,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (ftrunc:{ *:[f64] } DPR:{ *:[f64] }:$Dm)  =>  (VRINTZD:{ *:[f64] } DPR:{ *:[f64] }:$Dm)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTZD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Dd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Dm
      GIR_AddImm, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 683,
      GIR_Done,
    // Label 801: @33426
    GIM_Reject,
    // Label 796: @33427
    GIM_Try, /*On fail goto*//*Label 802*/ 33484, // Rule ID 4046 //
      GIM_CheckFeatures, GIFBS_HasMVEFloat,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (ftrunc:{ *:[v4f32] } MQPR:{ *:[v4f32] }:$val)  =>  (MVE_VRINTf32Z:{ *:[v4f32] } MQPR:{ *:[v4f32] }:$val)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VRINTf32Z,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4046,
      GIR_Done,
    // Label 802: @33484
    GIM_Reject,
    // Label 797: @33485
    GIM_Try, /*On fail goto*//*Label 803*/ 33542, // Rule ID 4034 //
      GIM_CheckFeatures, GIFBS_HasMVEFloat,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (ftrunc:{ *:[v8f16] } MQPR:{ *:[v8f16] }:$val)  =>  (MVE_VRINTf16Z:{ *:[v8f16] } MQPR:{ *:[v8f16] }:$val)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VRINTf16Z,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4034,
      GIR_Done,
    // Label 803: @33542
    GIM_Reject,
    // Label 798: @33543
    GIM_Reject,
    // Label 11: @33544
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 13, /*)*//*default:*//*Label 809*/ 33751,
    /*GILLT_s16*//*Label 804*/ 33563,
    /*GILLT_s32*//*Label 805*/ 33587,
    /*GILLT_s64*//*Label 806*/ 33611, 0, 0, 0, 0, 0,
    /*GILLT_v4s32*//*Label 807*/ 33635, 0, 0, 0,
    /*GILLT_v8s16*//*Label 808*/ 33693,
    // Label 804: @33563
    GIM_Try, /*On fail goto*//*Label 810*/ 33586, // Rule ID 690 //
      GIM_CheckFeatures, GIFBS_HasFullFP16,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::HPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::HPRRegClassID,
      // (fround:{ *:[f16] } HPR:{ *:[f16] }:$Sm)  =>  (VRINTAH:{ *:[f16] } HPR:{ *:[f16] }:$Sm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/ARM::VRINTAH,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 690,
      GIR_Done,
    // Label 810: @33586
    GIM_Reject,
    // Label 805: @33587
    GIM_Try, /*On fail goto*//*Label 811*/ 33610, // Rule ID 691 //
      GIM_CheckFeatures, GIFBS_HasFPARMv8,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::SPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::SPRRegClassID,
      // (fround:{ *:[f32] } SPR:{ *:[f32] }:$Sm)  =>  (VRINTAS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/ARM::VRINTAS,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 691,
      GIR_Done,
    // Label 811: @33610
    GIM_Reject,
    // Label 806: @33611
    GIM_Try, /*On fail goto*//*Label 812*/ 33634, // Rule ID 692 //
      GIM_CheckFeatures, GIFBS_HasDPVFP_HasFPARMv8,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::DPRRegClassID,
      // (fround:{ *:[f64] } DPR:{ *:[f64] }:$Dm)  =>  (VRINTAD:{ *:[f64] } DPR:{ *:[f64] }:$Dm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/ARM::VRINTAD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 692,
      GIR_Done,
    // Label 812: @33634
    GIM_Reject,
    // Label 807: @33635
    GIM_Try, /*On fail goto*//*Label 813*/ 33692, // Rule ID 4044 //
      GIM_CheckFeatures, GIFBS_HasMVEFloat,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (fround:{ *:[v4f32] } MQPR:{ *:[v4f32] }:$val)  =>  (MVE_VRINTf32A:{ *:[v4f32] } MQPR:{ *:[v4f32] }:$val)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VRINTf32A,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4044,
      GIR_Done,
    // Label 813: @33692
    GIM_Reject,
    // Label 808: @33693
    GIM_Try, /*On fail goto*//*Label 814*/ 33750, // Rule ID 4032 //
      GIM_CheckFeatures, GIFBS_HasMVEFloat,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::MQPRRegClassID,
      // (fround:{ *:[v8f16] } MQPR:{ *:[v8f16] }:$val)  =>  (MVE_VRINTf16A:{ *:[v8f16] } MQPR:{ *:[v8f16] }:$val)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VRINTf16A,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // val
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4032,
      GIR_Done,
    // Label 814: @33750
    GIM_Reject,
    // Label 809: @33751
    GIM_Reject,
    // Label 12: @33752
    GIM_Try, /*On fail goto*//*Label 815*/ 33897,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 816*/ 33827, // Rule ID 2064 //
        GIM_CheckFeatures, GIFBS_HasV6_IsThumb_IsThumb1Only,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::tGPRRegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::tGPRRegClassID,
        // (ld:{ *:[i32] } tGPR:{ *:[i32] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi8>>  =>  (tLDRSB:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, (tMOVi8:{ *:[i32] } 0:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/ARM::tMOVi8,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/0,
        GIR_AddImm, /*InsnID*/1, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::tLDRSB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2064,
        GIR_Done,
      // Label 816: @33827
      GIM_Try, /*On fail goto*//*Label 817*/ 33896, // Rule ID 2065 //
        GIM_CheckFeatures, GIFBS_HasV6_IsThumb_IsThumb1Only,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::tGPRRegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/ARM::tGPRRegClassID,
        // (ld:{ *:[i32] } tGPR:{ *:[i32] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>>  =>  (tLDRSH:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, (tMOVi8:{ *:[i32] } 0:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/ARM::tMOVi8,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/0,
        GIR_AddImm, /*InsnID*/1, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/1, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::tLDRSH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2065,
        GIR_Done,
      // Label 817: @33896
      GIM_Reject,
    // Label 815: @33897
    GIM_Reject,
    // Label 13: @33898
    GIM_Try, /*On fail goto*//*Label 818*/ 40061,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 819*/ 33953, // Rule ID 1880 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uxtb16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 2460:{ *:[iPTR] }, GPR:{ *:[i32] }:$Src)  =>  (UXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::UXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Src
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1880,
        GIR_Done,
      // Label 819: @33953
      GIM_Try, /*On fail goto*//*Label 820*/ 34003, // Rule ID 2117 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uxtb16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 2460:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rm)  =>  (t2UXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2117,
        GIR_Done,
      // Label 820: @34003
      GIM_Try, /*On fail goto*//*Label 821*/ 34043, // Rule ID 693 //
        GIM_CheckFeatures, GIFBS_HasFullFP16,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::HPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::HPRRegClassID,
        // (intrinsic_wo_chain:{ *:[f16] } 2346:{ *:[iPTR] }, HPR:{ *:[f16] }:$Sm)  =>  (VRINTNH:{ *:[f16] } HPR:{ *:[f16] }:$Sm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTNH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Sm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 693,
        GIR_Done,
      // Label 821: @34043
      GIM_Try, /*On fail goto*//*Label 822*/ 34083, // Rule ID 694 //
        GIM_CheckFeatures, GIFBS_HasFPARMv8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::SPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::SPRRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 2346:{ *:[iPTR] }, SPR:{ *:[f32] }:$Sm)  =>  (VRINTNS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTNS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Sm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 694,
        GIR_Done,
      // Label 822: @34083
      GIM_Try, /*On fail goto*//*Label 823*/ 34123, // Rule ID 695 //
        GIM_CheckFeatures, GIFBS_HasDPVFP_HasFPARMv8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[f64] } 2346:{ *:[iPTR] }, DPR:{ *:[f64] }:$Dm)  =>  (VRINTND:{ *:[f64] } DPR:{ *:[f64] }:$Dm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Dd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 695,
        GIR_Done,
      // Label 823: @34123
      GIM_Try, /*On fail goto*//*Label 824*/ 34170, // Rule ID 709 //
        GIM_CheckFeatures, GIFBS_HasDPVFP_HasVFP2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_vcvtr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::SPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 2461:{ *:[iPTR] }, DPR:{ *:[f64] }:$Dm)  =>  (VTOSIRD:{ *:[f32] } DPR:{ *:[f64] }:$Dm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VTOSIRD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 709,
        GIR_Done,
      // Label 824: @34170
      GIM_Try, /*On fail goto*//*Label 825*/ 34217, // Rule ID 710 //
        GIM_CheckFeatures, GIFBS_DontUseNEONForFP_HasVFP2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_vcvtr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::SPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::SPRRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 2461:{ *:[iPTR] }, SPR:{ *:[f32] }:$Sm)  =>  (VTOSIRS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VTOSIRS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Sm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 710,
        GIR_Done,
      // Label 825: @34217
      GIM_Try, /*On fail goto*//*Label 826*/ 34264, // Rule ID 711 //
        GIM_CheckFeatures, GIFBS_HasDPVFP_HasVFP2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_vcvtru,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::SPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 2462:{ *:[iPTR] }, DPR:{ *:[f64] }:$Dm)  =>  (VTOUIRD:{ *:[f32] } DPR:{ *:[f64] }:$Dm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VTOUIRD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Dm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 711,
        GIR_Done,
      // Label 826: @34264
      GIM_Try, /*On fail goto*//*Label 827*/ 34311, // Rule ID 712 //
        GIM_CheckFeatures, GIFBS_DontUseNEONForFP_HasVFP2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_vcvtru,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::SPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::SPRRegClassID,
        // (intrinsic_wo_chain:{ *:[f32] } 2462:{ *:[iPTR] }, SPR:{ *:[f32] }:$Sm)  =>  (VTOUIRS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VTOUIRS,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Sd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Sm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 712,
        GIR_Done,
      // Label 827: @34311
      GIM_Try, /*On fail goto*//*Label 828*/ 34358, // Rule ID 1260 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 2312:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VPADDLsv8i8:{ *:[v4i16] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1260,
        GIR_Done,
      // Label 828: @34358
      GIM_Try, /*On fail goto*//*Label 829*/ 34405, // Rule ID 1261 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 2312:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VPADDLsv4i16:{ *:[v2i32] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1261,
        GIR_Done,
      // Label 829: @34405
      GIM_Try, /*On fail goto*//*Label 830*/ 34452, // Rule ID 1262 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i64] } 2312:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VPADDLsv2i32:{ *:[v1i64] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1262,
        GIR_Done,
      // Label 830: @34452
      GIM_Try, /*On fail goto*//*Label 831*/ 34499, // Rule ID 1263 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2312:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VPADDLsv16i8:{ *:[v8i16] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLsv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1263,
        GIR_Done,
      // Label 831: @34499
      GIM_Try, /*On fail goto*//*Label 832*/ 34546, // Rule ID 1264 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 2312:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VPADDLsv8i16:{ *:[v4i32] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLsv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1264,
        GIR_Done,
      // Label 832: @34546
      GIM_Try, /*On fail goto*//*Label 833*/ 34593, // Rule ID 1265 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 2312:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VPADDLsv4i32:{ *:[v2i64] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLsv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1265,
        GIR_Done,
      // Label 833: @34593
      GIM_Try, /*On fail goto*//*Label 834*/ 34640, // Rule ID 1266 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddlu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 2313:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VPADDLuv8i8:{ *:[v4i16] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1266,
        GIR_Done,
      // Label 834: @34640
      GIM_Try, /*On fail goto*//*Label 835*/ 34687, // Rule ID 1267 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddlu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 2313:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VPADDLuv4i16:{ *:[v2i32] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1267,
        GIR_Done,
      // Label 835: @34687
      GIM_Try, /*On fail goto*//*Label 836*/ 34734, // Rule ID 1268 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddlu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v1i64] } 2313:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VPADDLuv2i32:{ *:[v1i64] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1268,
        GIR_Done,
      // Label 836: @34734
      GIM_Try, /*On fail goto*//*Label 837*/ 34781, // Rule ID 1269 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddlu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2313:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VPADDLuv16i8:{ *:[v8i16] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLuv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1269,
        GIR_Done,
      // Label 837: @34781
      GIM_Try, /*On fail goto*//*Label 838*/ 34828, // Rule ID 1270 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddlu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 2313:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VPADDLuv8i16:{ *:[v4i32] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLuv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1270,
        GIR_Done,
      // Label 838: @34828
      GIM_Try, /*On fail goto*//*Label 839*/ 34875, // Rule ID 1271 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vpaddlu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 2313:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VPADDLuv4i32:{ *:[v2i64] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VPADDLuv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1271,
        GIR_Done,
      // Label 839: @34875
      GIM_Try, /*On fail goto*//*Label 840*/ 34922, // Rule ID 1300 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecpe,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 2340:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VRECPEd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPEd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1300,
        GIR_Done,
      // Label 840: @34922
      GIM_Try, /*On fail goto*//*Label 841*/ 34969, // Rule ID 1301 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecpe,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 2340:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VRECPEq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPEq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1301,
        GIR_Done,
      // Label 841: @34969
      GIM_Try, /*On fail goto*//*Label 842*/ 35016, // Rule ID 1302 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecpe,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 2340:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRECPEfd:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPEfd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1302,
        GIR_Done,
      // Label 842: @35016
      GIM_Try, /*On fail goto*//*Label 843*/ 35063, // Rule ID 1303 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecpe,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 2340:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRECPEfq:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPEfq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1303,
        GIR_Done,
      // Label 843: @35063
      GIM_Try, /*On fail goto*//*Label 844*/ 35110, // Rule ID 1304 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecpe,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 2340:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRECPEhd:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPEhd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1304,
        GIR_Done,
      // Label 844: @35110
      GIM_Try, /*On fail goto*//*Label 845*/ 35157, // Rule ID 1305 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrecpe,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 2340:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRECPEhq:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRECPEhq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1305,
        GIR_Done,
      // Label 845: @35157
      GIM_Try, /*On fail goto*//*Label 846*/ 35204, // Rule ID 1310 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 2353:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VRSQRTEd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTEd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1310,
        GIR_Done,
      // Label 846: @35204
      GIM_Try, /*On fail goto*//*Label 847*/ 35251, // Rule ID 1311 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 2353:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VRSQRTEq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTEq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1311,
        GIR_Done,
      // Label 847: @35251
      GIM_Try, /*On fail goto*//*Label 848*/ 35298, // Rule ID 1312 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 2353:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRSQRTEfd:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTEfd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1312,
        GIR_Done,
      // Label 848: @35298
      GIM_Try, /*On fail goto*//*Label 849*/ 35345, // Rule ID 1313 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 2353:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRSQRTEfq:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTEfq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1313,
        GIR_Done,
      // Label 849: @35345
      GIM_Try, /*On fail goto*//*Label 850*/ 35392, // Rule ID 1314 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 2353:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRSQRTEhd:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTEhd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1314,
        GIR_Done,
      // Label 850: @35392
      GIM_Try, /*On fail goto*//*Label 851*/ 35439, // Rule ID 1315 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrsqrte,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 2353:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRSQRTEhq:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRSQRTEhq,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1315,
        GIR_Done,
      // Label 851: @35439
      GIM_Try, /*On fail goto*//*Label 852*/ 35486, // Rule ID 1536 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqabs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 2318:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VQABSv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQABSv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1536,
        GIR_Done,
      // Label 852: @35486
      GIM_Try, /*On fail goto*//*Label 853*/ 35533, // Rule ID 1537 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqabs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 2318:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VQABSv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQABSv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1537,
        GIR_Done,
      // Label 853: @35533
      GIM_Try, /*On fail goto*//*Label 854*/ 35580, // Rule ID 1538 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqabs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 2318:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VQABSv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQABSv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1538,
        GIR_Done,
      // Label 854: @35580
      GIM_Try, /*On fail goto*//*Label 855*/ 35627, // Rule ID 1539 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqabs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 2318:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VQABSv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQABSv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1539,
        GIR_Done,
      // Label 855: @35627
      GIM_Try, /*On fail goto*//*Label 856*/ 35674, // Rule ID 1540 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqabs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2318:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQABSv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQABSv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1540,
        GIR_Done,
      // Label 856: @35674
      GIM_Try, /*On fail goto*//*Label 857*/ 35721, // Rule ID 1541 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqabs,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 2318:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQABSv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQABSv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1541,
        GIR_Done,
      // Label 857: @35721
      GIM_Try, /*On fail goto*//*Label 858*/ 35768, // Rule ID 1552 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqneg,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 2324:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VQNEGv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQNEGv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1552,
        GIR_Done,
      // Label 858: @35768
      GIM_Try, /*On fail goto*//*Label 859*/ 35815, // Rule ID 1553 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqneg,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 2324:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VQNEGv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQNEGv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1553,
        GIR_Done,
      // Label 859: @35815
      GIM_Try, /*On fail goto*//*Label 860*/ 35862, // Rule ID 1554 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqneg,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 2324:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VQNEGv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQNEGv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1554,
        GIR_Done,
      // Label 860: @35862
      GIM_Try, /*On fail goto*//*Label 861*/ 35909, // Rule ID 1555 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqneg,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 2324:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VQNEGv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQNEGv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1555,
        GIR_Done,
      // Label 861: @35909
      GIM_Try, /*On fail goto*//*Label 862*/ 35956, // Rule ID 1556 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqneg,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2324:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQNEGv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQNEGv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1556,
        GIR_Done,
      // Label 862: @35956
      GIM_Try, /*On fail goto*//*Label 863*/ 36003, // Rule ID 1557 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqneg,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 2324:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQNEGv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQNEGv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1557,
        GIR_Done,
      // Label 863: @36003
      GIM_Try, /*On fail goto*//*Label 864*/ 36050, // Rule ID 1558 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 2265:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VCLSv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCLSv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1558,
        GIR_Done,
      // Label 864: @36050
      GIM_Try, /*On fail goto*//*Label 865*/ 36097, // Rule ID 1559 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 2265:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VCLSv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCLSv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1559,
        GIR_Done,
      // Label 865: @36097
      GIM_Try, /*On fail goto*//*Label 866*/ 36144, // Rule ID 1560 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 2265:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VCLSv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCLSv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1560,
        GIR_Done,
      // Label 866: @36144
      GIM_Try, /*On fail goto*//*Label 867*/ 36191, // Rule ID 1561 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 2265:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VCLSv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCLSv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1561,
        GIR_Done,
      // Label 867: @36191
      GIM_Try, /*On fail goto*//*Label 868*/ 36238, // Rule ID 1562 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2265:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VCLSv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCLSv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1562,
        GIR_Done,
      // Label 868: @36238
      GIM_Try, /*On fail goto*//*Label 869*/ 36285, // Rule ID 1563 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 2265:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VCLSv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCLSv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1563,
        GIR_Done,
      // Label 869: @36285
      GIM_Try, /*On fail goto*//*Label 870*/ 36332, // Rule ID 1607 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovns,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 2321:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQMOVNsv8i8:{ *:[v8i8] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNsv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1607,
        GIR_Done,
      // Label 870: @36332
      GIM_Try, /*On fail goto*//*Label 871*/ 36379, // Rule ID 1608 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovns,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 2321:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQMOVNsv4i16:{ *:[v4i16] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNsv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1608,
        GIR_Done,
      // Label 871: @36379
      GIM_Try, /*On fail goto*//*Label 872*/ 36426, // Rule ID 1609 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovns,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 2321:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vm)  =>  (VQMOVNsv2i32:{ *:[v2i32] } QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNsv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1609,
        GIR_Done,
      // Label 872: @36426
      GIM_Try, /*On fail goto*//*Label 873*/ 36473, // Rule ID 1610 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovnu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 2323:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQMOVNuv8i8:{ *:[v8i8] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1610,
        GIR_Done,
      // Label 873: @36473
      GIM_Try, /*On fail goto*//*Label 874*/ 36520, // Rule ID 1611 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovnu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 2323:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQMOVNuv4i16:{ *:[v4i16] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1611,
        GIR_Done,
      // Label 874: @36520
      GIM_Try, /*On fail goto*//*Label 875*/ 36567, // Rule ID 1612 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovnu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 2323:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vm)  =>  (VQMOVNuv2i32:{ *:[v2i32] } QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1612,
        GIR_Done,
      // Label 875: @36567
      GIM_Try, /*On fail goto*//*Label 876*/ 36614, // Rule ID 1613 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovnsu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i8] } 2322:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQMOVNsuv8i8:{ *:[v8i8] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNsuv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1613,
        GIR_Done,
      // Label 876: @36614
      GIM_Try, /*On fail goto*//*Label 877*/ 36661, // Rule ID 1614 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovnsu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 2322:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQMOVNsuv4i16:{ *:[v4i16] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNsuv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1614,
        GIR_Done,
      // Label 877: @36661
      GIM_Try, /*On fail goto*//*Label 878*/ 36708, // Rule ID 1615 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vqmovnsu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 2322:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vm)  =>  (VQMOVNsuv2i32:{ *:[v2i32] } QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VQMOVNsuv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1615,
        GIR_Done,
      // Label 878: @36708
      GIM_Try, /*On fail goto*//*Label 879*/ 36748, // Rule ID 1638 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtas,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 2266:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTANSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANSDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1638,
        GIR_Done,
      // Label 879: @36748
      GIM_Try, /*On fail goto*//*Label 880*/ 36788, // Rule ID 1639 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtas,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 2266:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTANSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANSQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1639,
        GIR_Done,
      // Label 880: @36788
      GIM_Try, /*On fail goto*//*Label 881*/ 36828, // Rule ID 1640 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtau,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 2267:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTANUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANUDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1640,
        GIR_Done,
      // Label 881: @36828
      GIM_Try, /*On fail goto*//*Label 882*/ 36868, // Rule ID 1641 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtau,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 2267:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTANUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANUQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1641,
        GIR_Done,
      // Label 882: @36868
      GIM_Try, /*On fail goto*//*Label 883*/ 36908, // Rule ID 1642 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtas,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 2266:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTANSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANSDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1642,
        GIR_Done,
      // Label 883: @36908
      GIM_Try, /*On fail goto*//*Label 884*/ 36948, // Rule ID 1643 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtas,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2266:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTANSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANSQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1643,
        GIR_Done,
      // Label 884: @36948
      GIM_Try, /*On fail goto*//*Label 885*/ 36988, // Rule ID 1644 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtau,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 2267:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTANUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANUDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1644,
        GIR_Done,
      // Label 885: @36988
      GIM_Try, /*On fail goto*//*Label 886*/ 37028, // Rule ID 1645 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtau,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2267:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTANUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTANUQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1645,
        GIR_Done,
      // Label 886: @37028
      GIM_Try, /*On fail goto*//*Label 887*/ 37068, // Rule ID 1646 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtns,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 2278:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTNNSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNSDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1646,
        GIR_Done,
      // Label 887: @37068
      GIM_Try, /*On fail goto*//*Label 888*/ 37108, // Rule ID 1647 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtns,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 2278:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTNNSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNSQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1647,
        GIR_Done,
      // Label 888: @37108
      GIM_Try, /*On fail goto*//*Label 889*/ 37148, // Rule ID 1648 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtnu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 2279:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTNNUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNUDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1648,
        GIR_Done,
      // Label 889: @37148
      GIM_Try, /*On fail goto*//*Label 890*/ 37188, // Rule ID 1649 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtnu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 2279:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTNNUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNUQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1649,
        GIR_Done,
      // Label 890: @37188
      GIM_Try, /*On fail goto*//*Label 891*/ 37228, // Rule ID 1650 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtns,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 2278:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTNNSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNSDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1650,
        GIR_Done,
      // Label 891: @37228
      GIM_Try, /*On fail goto*//*Label 892*/ 37268, // Rule ID 1651 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtns,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2278:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTNNSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNSQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1651,
        GIR_Done,
      // Label 892: @37268
      GIM_Try, /*On fail goto*//*Label 893*/ 37308, // Rule ID 1652 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtnu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 2279:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTNNUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNUDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1652,
        GIR_Done,
      // Label 893: @37308
      GIM_Try, /*On fail goto*//*Label 894*/ 37348, // Rule ID 1653 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtnu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2279:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTNNUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTNNUQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1653,
        GIR_Done,
      // Label 894: @37348
      GIM_Try, /*On fail goto*//*Label 895*/ 37388, // Rule ID 1654 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtps,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 2280:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTPNSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNSDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1654,
        GIR_Done,
      // Label 895: @37388
      GIM_Try, /*On fail goto*//*Label 896*/ 37428, // Rule ID 1655 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtps,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 2280:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTPNSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNSQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1655,
        GIR_Done,
      // Label 896: @37428
      GIM_Try, /*On fail goto*//*Label 897*/ 37468, // Rule ID 1656 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtpu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 2281:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTPNUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNUDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1656,
        GIR_Done,
      // Label 897: @37468
      GIM_Try, /*On fail goto*//*Label 898*/ 37508, // Rule ID 1657 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtpu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 2281:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTPNUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNUQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1657,
        GIR_Done,
      // Label 898: @37508
      GIM_Try, /*On fail goto*//*Label 899*/ 37548, // Rule ID 1658 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtps,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 2280:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTPNSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNSDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1658,
        GIR_Done,
      // Label 899: @37548
      GIM_Try, /*On fail goto*//*Label 900*/ 37588, // Rule ID 1659 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtps,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2280:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTPNSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNSQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1659,
        GIR_Done,
      // Label 900: @37588
      GIM_Try, /*On fail goto*//*Label 901*/ 37628, // Rule ID 1660 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtpu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 2281:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTPNUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNUDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1660,
        GIR_Done,
      // Label 901: @37628
      GIM_Try, /*On fail goto*//*Label 902*/ 37668, // Rule ID 1661 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtpu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2281:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTPNUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTPNUQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1661,
        GIR_Done,
      // Label 902: @37668
      GIM_Try, /*On fail goto*//*Label 903*/ 37708, // Rule ID 1662 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtms,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 2276:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTMNSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNSDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1662,
        GIR_Done,
      // Label 903: @37708
      GIM_Try, /*On fail goto*//*Label 904*/ 37748, // Rule ID 1663 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtms,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 2276:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTMNSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNSQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1663,
        GIR_Done,
      // Label 904: @37748
      GIM_Try, /*On fail goto*//*Label 905*/ 37788, // Rule ID 1664 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtmu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i32] } 2277:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTMNUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNUDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1664,
        GIR_Done,
      // Label 905: @37788
      GIM_Try, /*On fail goto*//*Label 906*/ 37828, // Rule ID 1665 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtmu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 2277:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTMNUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNUQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1665,
        GIR_Done,
      // Label 906: @37828
      GIM_Try, /*On fail goto*//*Label 907*/ 37868, // Rule ID 1666 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtms,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 2276:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTMNSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNSDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1666,
        GIR_Done,
      // Label 907: @37868
      GIM_Try, /*On fail goto*//*Label 908*/ 37908, // Rule ID 1667 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtms,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2276:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTMNSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNSQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1667,
        GIR_Done,
      // Label 908: @37908
      GIM_Try, /*On fail goto*//*Label 909*/ 37948, // Rule ID 1668 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtmu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 2277:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTMNUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNUDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1668,
        GIR_Done,
      // Label 909: @37948
      GIM_Try, /*On fail goto*//*Label 910*/ 37988, // Rule ID 1669 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtmu,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2277:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTMNUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTMNUQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1669,
        GIR_Done,
      // Label 910: @37988
      GIM_Try, /*On fail goto*//*Label 911*/ 38035, // Rule ID 1686 //
        GIM_CheckFeatures, GIFBS_HasFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvtfp2hf,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i16] } 2272:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTf2h:{ *:[v4i16] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTf2h,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1686,
        GIR_Done,
      // Label 911: @38035
      GIM_Try, /*On fail goto*//*Label 912*/ 38082, // Rule ID 1687 //
        GIM_CheckFeatures, GIFBS_HasFP16_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vcvthf2fp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 2275:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VCVTh2f:{ *:[v4f32] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VCVTh2f,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1687,
        GIR_Done,
      // Label 912: @38082
      GIM_Try, /*On fail goto*//*Label 913*/ 38122, // Rule ID 1709 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 2346:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTNNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTNNDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1709,
        GIR_Done,
      // Label 913: @38122
      GIM_Try, /*On fail goto*//*Label 914*/ 38162, // Rule ID 1710 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 2346:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTNNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTNNQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1710,
        GIR_Done,
      // Label 914: @38162
      GIM_Try, /*On fail goto*//*Label 915*/ 38202, // Rule ID 1711 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 2346:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTNNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTNNDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1711,
        GIR_Done,
      // Label 915: @38202
      GIM_Try, /*On fail goto*//*Label 916*/ 38242, // Rule ID 1712 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 2346:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTNNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTNNQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1712,
        GIR_Done,
      // Label 916: @38242
      GIM_Try, /*On fail goto*//*Label 917*/ 38282, // Rule ID 1713 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 2348:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTXNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTXNDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1713,
        GIR_Done,
      // Label 917: @38282
      GIM_Try, /*On fail goto*//*Label 918*/ 38322, // Rule ID 1714 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 2348:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTXNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTXNQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1714,
        GIR_Done,
      // Label 918: @38322
      GIM_Try, /*On fail goto*//*Label 919*/ 38362, // Rule ID 1715 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 2348:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTXNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTXNDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1715,
        GIR_Done,
      // Label 919: @38362
      GIM_Try, /*On fail goto*//*Label 920*/ 38402, // Rule ID 1716 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintx,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 2348:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTXNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTXNQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1716,
        GIR_Done,
      // Label 920: @38402
      GIM_Try, /*On fail goto*//*Label 921*/ 38442, // Rule ID 1717 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrinta,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 2344:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTANDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTANDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1717,
        GIR_Done,
      // Label 921: @38442
      GIM_Try, /*On fail goto*//*Label 922*/ 38482, // Rule ID 1718 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrinta,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 2344:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTANQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTANQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1718,
        GIR_Done,
      // Label 922: @38482
      GIM_Try, /*On fail goto*//*Label 923*/ 38522, // Rule ID 1719 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrinta,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 2344:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTANDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTANDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1719,
        GIR_Done,
      // Label 923: @38522
      GIM_Try, /*On fail goto*//*Label 924*/ 38562, // Rule ID 1720 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrinta,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 2344:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTANQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTANQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1720,
        GIR_Done,
      // Label 924: @38562
      GIM_Try, /*On fail goto*//*Label 925*/ 38602, // Rule ID 1721 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 2349:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTZNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTZNDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1721,
        GIR_Done,
      // Label 925: @38602
      GIM_Try, /*On fail goto*//*Label 926*/ 38642, // Rule ID 1722 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 2349:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTZNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTZNQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1722,
        GIR_Done,
      // Label 926: @38642
      GIM_Try, /*On fail goto*//*Label 927*/ 38682, // Rule ID 1723 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 2349:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTZNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTZNDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1723,
        GIR_Done,
      // Label 927: @38682
      GIM_Try, /*On fail goto*//*Label 928*/ 38722, // Rule ID 1724 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintz,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 2349:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTZNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTZNQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1724,
        GIR_Done,
      // Label 928: @38722
      GIM_Try, /*On fail goto*//*Label 929*/ 38762, // Rule ID 1725 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 2345:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTMNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTMNDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1725,
        GIR_Done,
      // Label 929: @38762
      GIM_Try, /*On fail goto*//*Label 930*/ 38802, // Rule ID 1726 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 2345:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTMNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTMNQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1726,
        GIR_Done,
      // Label 930: @38802
      GIM_Try, /*On fail goto*//*Label 931*/ 38842, // Rule ID 1727 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 2345:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTMNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTMNDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1727,
        GIR_Done,
      // Label 931: @38842
      GIM_Try, /*On fail goto*//*Label 932*/ 38882, // Rule ID 1728 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 2345:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTMNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTMNQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1728,
        GIR_Done,
      // Label 932: @38882
      GIM_Try, /*On fail goto*//*Label 933*/ 38922, // Rule ID 1729 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f32] } 2347:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTPNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTPNDf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1729,
        GIR_Done,
      // Label 933: @38922
      GIM_Try, /*On fail goto*//*Label 934*/ 38962, // Rule ID 1730 //
        GIM_CheckFeatures, GIFBS_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 2347:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTPNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTPNQf,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1730,
        GIR_Done,
      // Label 934: @38962
      GIM_Try, /*On fail goto*//*Label 935*/ 39002, // Rule ID 1731 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::DPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::DPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f16] } 2347:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTPNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTPNDh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1731,
        GIR_Done,
      // Label 935: @39002
      GIM_Try, /*On fail goto*//*Label 936*/ 39042, // Rule ID 1732 //
        GIM_CheckFeatures, GIFBS_HasFullFP16_HasNEON_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_vrintp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 2347:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTPNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::VRINTPNQh,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1732,
        GIR_Done,
      // Label 936: @39042
      GIM_Try, /*On fail goto*//*Label 937*/ 39082, // Rule ID 1735 //
        GIM_CheckFeatures, GIFBS_HasAES_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_aesimc,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 2235:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (AESIMC:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::AESIMC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1735,
        GIR_Done,
      // Label 937: @39082
      GIM_Try, /*On fail goto*//*Label 938*/ 39122, // Rule ID 1736 //
        GIM_CheckFeatures, GIFBS_HasAES_HasV8,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_aesmc,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::QPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::QPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 2236:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (AESMC:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::AESMC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1736,
        GIR_Done,
      // Label 938: @39122
      GIM_Try, /*On fail goto*//*Label 939*/ 39172, // Rule ID 1875 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_sxtb16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 2435:{ *:[iPTR] }, GPR:{ *:[i32] }:$Src)  =>  (SXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::SXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Src
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1875,
        GIR_Done,
      // Label 939: @39172
      GIM_Try, /*On fail goto*//*Label 940*/ 39222, // Rule ID 2106 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_sxtb16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 2435:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn)  =>  (t2SXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2SXTB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2106,
        GIR_Done,
      // Label 940: @39222
      GIM_Try, /*On fail goto*//*Label 941*/ 39287, // Rule ID 3724 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_mve_vcls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 2117:{ *:[iPTR] }, MQPR:{ *:[v16i8] }:$val)  =>  (MVE_VCLSs8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$val)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VCLSs8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3724,
        GIR_Done,
      // Label 941: @39287
      GIM_Try, /*On fail goto*//*Label 942*/ 39352, // Rule ID 3726 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_mve_vcls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2117:{ *:[iPTR] }, MQPR:{ *:[v8i16] }:$val)  =>  (MVE_VCLSs16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$val)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VCLSs16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3726,
        GIR_Done,
      // Label 942: @39352
      GIM_Try, /*On fail goto*//*Label 943*/ 39417, // Rule ID 3728 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_mve_vcls,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 2117:{ *:[iPTR] }, MQPR:{ *:[v4i32] }:$val)  =>  (MVE_VCLSs32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$val)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VCLSs32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3728,
        GIR_Done,
      // Label 943: @39417
      GIM_Try, /*On fail goto*//*Label 944*/ 39482, // Rule ID 4028 //
        GIM_CheckFeatures, GIFBS_HasMVEFloat,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_mve_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 2199:{ *:[iPTR] }, MQPR:{ *:[v8f16] }:$val)  =>  (MVE_VRINTf16N:{ *:[v8f16] } MQPR:{ *:[v8f16] }:$val)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VRINTf16N,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4028,
        GIR_Done,
      // Label 944: @39482
      GIM_Try, /*On fail goto*//*Label 945*/ 39547, // Rule ID 4040 //
        GIM_CheckFeatures, GIFBS_HasMVEFloat,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_mve_vrintn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::MQPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 2199:{ *:[iPTR] }, MQPR:{ *:[v4f32] }:$val)  =>  (MVE_VRINTf32N:{ *:[v4f32] } MQPR:{ *:[v4f32] }:$val)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VRINTf32N,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // val
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4040,
        GIR_Done,
      // Label 945: @39547
      GIM_Try, /*On fail goto*//*Label 946*/ 39598, // Rule ID 4904 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_mve_vctp8,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::VCCRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i1] } 2125:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn)  =>  (MVE_VCTP8:{ *:[v16i1] } rGPR:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VCTP8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // P0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4904,
        GIR_Done,
      // Label 946: @39598
      GIM_Try, /*On fail goto*//*Label 947*/ 39649, // Rule ID 4906 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_mve_vctp16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::VCCRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i1] } 2122:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn)  =>  (MVE_VCTP16:{ *:[v8i1] } rGPR:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VCTP16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // P0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4906,
        GIR_Done,
      // Label 947: @39649
      GIM_Try, /*On fail goto*//*Label 948*/ 39700, // Rule ID 4908 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_mve_vctp32,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::VCCRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i1] } 2123:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn)  =>  (MVE_VCTP32:{ *:[v4i1] } rGPR:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VCTP32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // P0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4908,
        GIR_Done,
      // Label 948: @39700
      GIM_Try, /*On fail goto*//*Label 949*/ 39751, // Rule ID 4910 //
        GIM_CheckFeatures, GIFBS_HasMVEInt,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_mve_vctp64,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s1,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::VCCRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i1] } 2124:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn)  =>  (MVE_VCTP64:{ *:[v2i1] } rGPR:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VCTP64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // P0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4910,
        GIR_Done,
      // Label 949: @39751
      GIM_Try, /*On fail goto*//*Label 950*/ 39798, // Rule ID 616 //
        GIM_CheckFeatures, GIFBS_Has8MSecExt_IsThumb,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_cmse_tt,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 2007:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn)  =>  (t2TT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2TT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 616,
        GIR_Done,
      // Label 950: @39798
      GIM_Try, /*On fail goto*//*Label 951*/ 39845, // Rule ID 617 //
        GIM_CheckFeatures, GIFBS_Has8MSecExt_IsThumb,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_cmse_ttt,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 2010:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn)  =>  (t2TTT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2TTT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 617,
        GIR_Done,
      // Label 951: @39845
      GIM_Try, /*On fail goto*//*Label 952*/ 39892, // Rule ID 618 //
        GIM_CheckFeatures, GIFBS_Has8MSecExt_IsThumb,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_cmse_tta,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 2008:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn)  =>  (t2TTA:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2TTA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 618,
        GIR_Done,
      // Label 952: @39892
      GIM_Try, /*On fail goto*//*Label 953*/ 39939, // Rule ID 619 //
        GIM_CheckFeatures, GIFBS_Has8MSecExt_IsThumb,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_cmse_ttat,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 2009:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn)  =>  (t2TTAT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2TTAT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 619,
        GIR_Done,
      // Label 953: @39939
      GIM_Try, /*On fail goto*//*Label 954*/ 40060, // Rule ID 2696 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_neon_sha1h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 2243:{ *:[iPTR] }, i32:{ *:[i32] }:$Rn)  =>  (COPY_TO_REGCLASS:{ *:[i32] } (EXTRACT_SUBREG:{ *:[f32] } (SHA1H:{ *:[v16i8] } (SUBREG_TO_REG:{ *:[v16i8] } 0:{ *:[i64] }, (COPY_TO_REGCLASS:{ *:[f32] } i32:{ *:[i32] }:$Rn, SPR:{ *:[i32] }), ssub_0:{ *:[i32] })), ssub_0:{ *:[i32] }), GPR:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/3, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/3, /*Imm*/17,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, ARM::DPair_with_ssub_0RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, ARM::SPRRegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/ARM::SHA1H,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0, ARM::ssub_0,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, ARM::SPRRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, ARM::MQPRRegClassID,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, ARM::GPRRegClassID,
        // GIR_Coverage, 2696,
        GIR_Done,
      // Label 954: @40060
      GIM_Reject,
    // Label 818: @40061
    GIM_Try, /*On fail goto*//*Label 955*/ 62770,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 956*/ 40128, // Rule ID 2124 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_uxtab16,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 2459:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UXTAB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2UXTAB16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2124,
        GIR_Done,
      // Label 956: @40128
      GIM_Try, /*On fail goto*//*Label 957*/ 40226, // Rule ID 1916 //
        GIM_CheckFeatures, GIFBS_HasV6_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_usat,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_imm0_31,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm0_31,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[i32] } 2454:{ *:[iPTR] }, (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$shft), (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos)  =>  (USAT:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos, GPRnopc:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$shft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::USAT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // pos
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shft
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1916,
        GIR_Done,
      // Label 957: @40226
      GIM_Try, /*On fail goto*//*Label 958*/ 40324, // Rule ID 2164 //
        GIM_CheckFeatures, GIFBS_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_usat,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_imm0_31,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_imm0_31,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (intrinsic_wo_chain:{ *:[i32] } 2454:{ *:[iPTR] }, (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$shft), (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos)  =>  (t2USAT:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos, GPRnopc:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$shft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2USAT,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // pos
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shft
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2164,
        GIR_Done,
      // Label 958: @40324
      GIM_Try, /*On fail goto*//*Label 959*/ 40408, // Rule ID 5469 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // MIs[1] Rn
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 2377:{ *:[iPTR] }, (intrinsic_wo_chain:{ *:[i32] } 2377:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rn), GPRnopc:{ *:[i32] }:$Rm)  =>  (QDADD:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QDADD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5469,
        GIR_Done,
      // Label 959: @40408
      GIM_Try, /*On fail goto*//*Label 960*/ 40492, // Rule ID 5726 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // MIs[1] Rn
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 2377:{ *:[iPTR] }, (intrinsic_wo_chain:{ *:[i32] } 2377:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rn), rGPR:{ *:[i32] }:$Rm)  =>  (t2QDADD:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2QDADD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 5726,
        GIR_Done,
      // Label 960: @40492
      GIM_Try, /*On fail goto*//*Label 961*/ 40576, // Rule ID 109 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // MIs[1] Rn
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 2377:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rm, (intrinsic_wo_chain:{ *:[i32] } 2377:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rn))  =>  (QDADD:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QDADD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 109,
        GIR_Done,
      // Label 961: @40576
      GIM_Try, /*On fail goto*//*Label 962*/ 40660, // Rule ID 110 //
        GIM_CheckFeatures, GIFBS_IsARM,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qsub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::GPRnopcRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::GPRnopcRegClassID,
        // MIs[1] Rn
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 2382:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rm, (intrinsic_wo_chain:{ *:[i32] } 2377:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rn))  =>  (QDSUB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::QDSUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 110,
        GIR_Done,
      // Label 962: @40660
      GIM_Try, /*On fail goto*//*Label 963*/ 40744, // Rule ID 2142 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // MIs[1] Rn
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 2377:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rm, (intrinsic_wo_chain:{ *:[i32] } 2377:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rn))  =>  (t2QDADD:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2QDADD,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2142,
        GIR_Done,
      // Label 963: @40744
      GIM_Try, /*On fail goto*//*Label 964*/ 40828, // Rule ID 2143 //
        GIM_CheckFeatures, GIFBS_HasDSP_IsThumb2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_qsub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::rGPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::arm_qadd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/ARM::rGPRRegClassID,
        // MIs[1] Rn
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 2382:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rm, (intrinsic_wo_chain:{ *:[i32] } 2377:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rn))  =>  (t2QDSUB:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::t2QDSUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_AddImm, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2143,
        GIR_Done,
      // Label 964: @40828
      GIM_Try, /*On fail goto*//*Label 965*/ 40901, // Rule ID 4120 //
        GIM_CheckFeatures, GIFBS_HasMVEFloat,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_mve_vcvta,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 0,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::MQPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2133:{ *:[iPTR] }, 0:{ *:[i32] }, MQPR:{ *:[v8f16] }:$in)  =>  (MVE_VCVTs16f16a:{ *:[v8i16] } MQPR:{ *:[v8f16] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VCVTs16f16a,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // in
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4120,
        GIR_Done,
      // Label 965: @40901
      GIM_Try, /*On fail goto*//*Label 966*/ 40974, // Rule ID 4122 //
        GIM_CheckFeatures, GIFBS_HasMVEFloat,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_mve_vcvtn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 0,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::MQPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2137:{ *:[iPTR] }, 0:{ *:[i32] }, MQPR:{ *:[v8f16] }:$in)  =>  (MVE_VCVTs16f16n:{ *:[v8i16] } MQPR:{ *:[v8f16] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VCVTs16f16n,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // in
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4122,
        GIR_Done,
      // Label 966: @40974
      GIM_Try, /*On fail goto*//*Label 967*/ 41047, // Rule ID 4124 //
        GIM_CheckFeatures, GIFBS_HasMVEFloat,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_mve_vcvtp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 0,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::MQPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2139:{ *:[iPTR] }, 0:{ *:[i32] }, MQPR:{ *:[v8f16] }:$in)  =>  (MVE_VCVTs16f16p:{ *:[v8i16] } MQPR:{ *:[v8f16] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VCVTs16f16p,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // in
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4124,
        GIR_Done,
      // Label 967: @41047
      GIM_Try, /*On fail goto*//*Label 968*/ 41120, // Rule ID 4126 //
        GIM_CheckFeatures, GIFBS_HasMVEFloat,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_mve_vcvtm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 0,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::MQPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2135:{ *:[iPTR] }, 0:{ *:[i32] }, MQPR:{ *:[v8f16] }:$in)  =>  (MVE_VCVTs16f16m:{ *:[v8i16] } MQPR:{ *:[v8f16] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VCVTs16f16m,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // in
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4126,
        GIR_Done,
      // Label 968: @41120
      GIM_Try, /*On fail goto*//*Label 969*/ 41193, // Rule ID 4128 //
        GIM_CheckFeatures, GIFBS_HasMVEFloat,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_mve_vcvta,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::MQPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2133:{ *:[iPTR] }, 1:{ *:[i32] }, MQPR:{ *:[v8f16] }:$in)  =>  (MVE_VCVTu16f16a:{ *:[v8i16] } MQPR:{ *:[v8f16] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VCVTu16f16a,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // in
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4128,
        GIR_Done,
      // Label 969: @41193
      GIM_Try, /*On fail goto*//*Label 970*/ 41266, // Rule ID 4130 //
        GIM_CheckFeatures, GIFBS_HasMVEFloat,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_mve_vcvtn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::MQPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2137:{ *:[iPTR] }, 1:{ *:[i32] }, MQPR:{ *:[v8f16] }:$in)  =>  (MVE_VCVTu16f16n:{ *:[v8i16] } MQPR:{ *:[v8f16] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VCVTu16f16n,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // in
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4130,
        GIR_Done,
      // Label 970: @41266
      GIM_Try, /*On fail goto*//*Label 971*/ 41339, // Rule ID 4132 //
        GIM_CheckFeatures, GIFBS_HasMVEFloat,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_mve_vcvtp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::MQPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2139:{ *:[iPTR] }, 1:{ *:[i32] }, MQPR:{ *:[v8f16] }:$in)  =>  (MVE_VCVTu16f16p:{ *:[v8i16] } MQPR:{ *:[v8f16] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VCVTu16f16p,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // in
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4132,
        GIR_Done,
      // Label 971: @41339
      GIM_Try, /*On fail goto*//*Label 972*/ 41412, // Rule ID 4134 //
        GIM_CheckFeatures, GIFBS_HasMVEFloat,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_mve_vcvtm,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::MQPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 2135:{ *:[iPTR] }, 1:{ *:[i32] }, MQPR:{ *:[v8f16] }:$in)  =>  (MVE_VCVTu16f16m:{ *:[v8i16] } MQPR:{ *:[v8f16] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VCVTu16f16m,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // in
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4134,
        GIR_Done,
      // Label 972: @41412
      GIM_Try, /*On fail goto*//*Label 973*/ 41485, // Rule ID 4136 //
        GIM_CheckFeatures, GIFBS_HasMVEFloat,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_mve_vcvta,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 0,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::MQPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 2133:{ *:[iPTR] }, 0:{ *:[i32] }, MQPR:{ *:[v4f32] }:$in)  =>  (MVE_VCVTs32f32a:{ *:[v4i32] } MQPR:{ *:[v4f32] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VCVTs32f32a,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // in
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4136,
        GIR_Done,
      // Label 973: @41485
      GIM_Try, /*On fail goto*//*Label 974*/ 41558, // Rule ID 4138 //
        GIM_CheckFeatures, GIFBS_HasMVEFloat,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_mve_vcvtn,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 0,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/ARM::MQPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 2137:{ *:[iPTR] }, 0:{ *:[i32] }, MQPR:{ *:[v4f32] }:$in)  =>  (MVE_VCVTs32f32n:{ *:[v4i32] } MQPR:{ *:[v4f32] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/ARM::MVE_VCVTs32f32n,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Qd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // in
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, ARM::NoRegister, /*AddRegisterRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4138,
        GIR_Done,
      // Label 974: @41558
      GIM_Try, /*On fail goto*//*Label 975*/ 41631, // Rule ID 4140 //
        GIM_CheckFeatures, GIFBS_HasMVEFloat,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::arm_mve_vcvtp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/ARM::MQPRRegClassID,
        GIM_C