#ifdef GET_MIMGBaseOpcode_DECL
enum MIMGBaseOpcode {
  IMAGE_ATOMIC_ADD = 0,
  IMAGE_ATOMIC_AND = 1,
  IMAGE_ATOMIC_CMPSWAP = 2,
  IMAGE_ATOMIC_DEC = 3,
  IMAGE_ATOMIC_FCMPSWAP = 4,
  IMAGE_ATOMIC_FMAX = 5,
  IMAGE_ATOMIC_FMIN = 6,
  IMAGE_ATOMIC_INC = 7,
  IMAGE_ATOMIC_OR = 8,
  IMAGE_ATOMIC_RSUB = 9,
  IMAGE_ATOMIC_SMAX = 10,
  IMAGE_ATOMIC_SMIN = 11,
  IMAGE_ATOMIC_SUB = 12,
  IMAGE_ATOMIC_SWAP = 13,
  IMAGE_ATOMIC_UMAX = 14,
  IMAGE_ATOMIC_UMIN = 15,
  IMAGE_ATOMIC_XOR = 16,
  IMAGE_BVH64_INTERSECT_RAY = 17,
  IMAGE_BVH64_INTERSECT_RAY_a16 = 18,
  IMAGE_BVH_INTERSECT_RAY = 19,
  IMAGE_BVH_INTERSECT_RAY_a16 = 20,
  IMAGE_GATHER4 = 21,
  IMAGE_GATHER4_B = 22,
  IMAGE_GATHER4_B_CL = 23,
  IMAGE_GATHER4_B_CL_O = 24,
  IMAGE_GATHER4_B_O = 25,
  IMAGE_GATHER4_C = 26,
  IMAGE_GATHER4_CL = 27,
  IMAGE_GATHER4_CL_O = 28,
  IMAGE_GATHER4_C_B = 29,
  IMAGE_GATHER4_C_B_CL = 30,
  IMAGE_GATHER4_C_B_CL_O = 31,
  IMAGE_GATHER4_C_B_O = 32,
  IMAGE_GATHER4_C_CL = 33,
  IMAGE_GATHER4_C_CL_O = 34,
  IMAGE_GATHER4_C_L = 35,
  IMAGE_GATHER4_C_LZ = 36,
  IMAGE_GATHER4_C_LZ_O = 37,
  IMAGE_GATHER4_C_L_O = 38,
  IMAGE_GATHER4_C_O = 39,
  IMAGE_GATHER4_L = 40,
  IMAGE_GATHER4_LZ = 41,
  IMAGE_GATHER4_LZ_O = 42,
  IMAGE_GATHER4_L_O = 43,
  IMAGE_GATHER4_O = 44,
  IMAGE_GET_LOD = 45,
  IMAGE_GET_RESINFO = 46,
  IMAGE_LOAD = 47,
  IMAGE_LOAD_MIP = 48,
  IMAGE_LOAD_MIP_PCK = 49,
  IMAGE_LOAD_MIP_PCK_SGN = 50,
  IMAGE_LOAD_PCK = 51,
  IMAGE_LOAD_PCK_SGN = 52,
  IMAGE_MSAA_LOAD_X = 53,
  IMAGE_SAMPLE = 54,
  IMAGE_SAMPLE_B = 55,
  IMAGE_SAMPLE_B_CL = 56,
  IMAGE_SAMPLE_B_CL_O = 57,
  IMAGE_SAMPLE_B_O = 58,
  IMAGE_SAMPLE_C = 59,
  IMAGE_SAMPLE_CD = 60,
  IMAGE_SAMPLE_CD_CL = 61,
  IMAGE_SAMPLE_CD_CL_G16 = 62,
  IMAGE_SAMPLE_CD_CL_O = 63,
  IMAGE_SAMPLE_CD_CL_O_G16 = 64,
  IMAGE_SAMPLE_CD_G16 = 65,
  IMAGE_SAMPLE_CD_O = 66,
  IMAGE_SAMPLE_CD_O_G16 = 67,
  IMAGE_SAMPLE_CL = 68,
  IMAGE_SAMPLE_CL_O = 69,
  IMAGE_SAMPLE_C_B = 70,
  IMAGE_SAMPLE_C_B_CL = 71,
  IMAGE_SAMPLE_C_B_CL_O = 72,
  IMAGE_SAMPLE_C_B_O = 73,
  IMAGE_SAMPLE_C_CD = 74,
  IMAGE_SAMPLE_C_CD_CL = 75,
  IMAGE_SAMPLE_C_CD_CL_G16 = 76,
  IMAGE_SAMPLE_C_CD_CL_O = 77,
  IMAGE_SAMPLE_C_CD_CL_O_G16 = 78,
  IMAGE_SAMPLE_C_CD_G16 = 79,
  IMAGE_SAMPLE_C_CD_O = 80,
  IMAGE_SAMPLE_C_CD_O_G16 = 81,
  IMAGE_SAMPLE_C_CL = 82,
  IMAGE_SAMPLE_C_CL_O = 83,
  IMAGE_SAMPLE_C_D = 84,
  IMAGE_SAMPLE_C_D_CL = 85,
  IMAGE_SAMPLE_C_D_CL_G16 = 86,
  IMAGE_SAMPLE_C_D_CL_O = 87,
  IMAGE_SAMPLE_C_D_CL_O_G16 = 88,
  IMAGE_SAMPLE_C_D_G16 = 89,
  IMAGE_SAMPLE_C_D_O = 90,
  IMAGE_SAMPLE_C_D_O_G16 = 91,
  IMAGE_SAMPLE_C_L = 92,
  IMAGE_SAMPLE_C_LZ = 93,
  IMAGE_SAMPLE_C_LZ_O = 94,
  IMAGE_SAMPLE_C_L_O = 95,
  IMAGE_SAMPLE_C_O = 96,
  IMAGE_SAMPLE_D = 97,
  IMAGE_SAMPLE_D_CL = 98,
  IMAGE_SAMPLE_D_CL_G16 = 99,
  IMAGE_SAMPLE_D_CL_O = 100,
  IMAGE_SAMPLE_D_CL_O_G16 = 101,
  IMAGE_SAMPLE_D_G16 = 102,
  IMAGE_SAMPLE_D_O = 103,
  IMAGE_SAMPLE_D_O_G16 = 104,
  IMAGE_SAMPLE_L = 105,
  IMAGE_SAMPLE_LZ = 106,
  IMAGE_SAMPLE_LZ_O = 107,
  IMAGE_SAMPLE_L_O = 108,
  IMAGE_SAMPLE_O = 109,
  IMAGE_STORE = 110,
  IMAGE_STORE_MIP = 111,
  IMAGE_STORE_MIP_PCK = 112,
  IMAGE_STORE_PCK = 113,
};
#endif

#ifdef GET_MIMGDim_DECL
enum MIMGDim {
  AMDGPUDim1D = 0,
  AMDGPUDim1DArray = 1,
  AMDGPUDim2D = 2,
  AMDGPUDim2DArray = 3,
  AMDGPUDim2DArrayMsaa = 4,
  AMDGPUDim2DMsaa = 5,
  AMDGPUDim3D = 6,
  AMDGPUDimCube = 7,
};
#endif

#ifdef GET_MIMGEncoding_DECL
enum MIMGEncoding {
  MIMGEncGfx10Default = 0,
  MIMGEncGfx10NSA = 1,
  MIMGEncGfx6 = 2,
  MIMGEncGfx8 = 3,
  MIMGEncGfx90a = 4,
};
#endif

#ifdef GET_Gfx10PlusBufferFormat_DECL
const GcnBufferFormatInfo *getGfx10PlusBufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat);
const GcnBufferFormatInfo *getGfx10PlusBufferFormatInfo(uint8_t Format);
#endif

#ifdef GET_Gfx10PlusBufferFormat_IMPL
constexpr GcnBufferFormatInfo Gfx10PlusBufferFormat[] = {
  { 0x1, 0x8, 0x1, 0x0, 0x1 }, // 0
  { 0x2, 0x8, 0x1, 0x1, 0x1 }, // 1
  { 0x3, 0x8, 0x1, 0x2, 0x1 }, // 2
  { 0x4, 0x8, 0x1, 0x3, 0x1 }, // 3
  { 0x5, 0x8, 0x1, 0x4, 0x1 }, // 4
  { 0x6, 0x8, 0x1, 0x5, 0x1 }, // 5
  { 0xE, 0x8, 0x2, 0x0, 0x3 }, // 6
  { 0xF, 0x8, 0x2, 0x1, 0x3 }, // 7
  { 0x10, 0x8, 0x2, 0x2, 0x3 }, // 8
  { 0x11, 0x8, 0x2, 0x3, 0x3 }, // 9
  { 0x12, 0x8, 0x2, 0x4, 0x3 }, // 10
  { 0x13, 0x8, 0x2, 0x5, 0x3 }, // 11
  { 0x38, 0x8, 0x4, 0x0, 0xA }, // 12
  { 0x39, 0x8, 0x4, 0x1, 0xA }, // 13
  { 0x3A, 0x8, 0x4, 0x2, 0xA }, // 14
  { 0x3B, 0x8, 0x4, 0x3, 0xA }, // 15
  { 0x3C, 0x8, 0x4, 0x4, 0xA }, // 16
  { 0x3D, 0x8, 0x4, 0x5, 0xA }, // 17
  { 0x7, 0x10, 0x1, 0x0, 0x2 }, // 18
  { 0x8, 0x10, 0x1, 0x1, 0x2 }, // 19
  { 0x9, 0x10, 0x1, 0x2, 0x2 }, // 20
  { 0xA, 0x10, 0x1, 0x3, 0x2 }, // 21
  { 0xB, 0x10, 0x1, 0x4, 0x2 }, // 22
  { 0xC, 0x10, 0x1, 0x5, 0x2 }, // 23
  { 0xD, 0x10, 0x1, 0x7, 0x2 }, // 24
  { 0x17, 0x10, 0x2, 0x0, 0x5 }, // 25
  { 0x18, 0x10, 0x2, 0x1, 0x5 }, // 26
  { 0x19, 0x10, 0x2, 0x2, 0x5 }, // 27
  { 0x1A, 0x10, 0x2, 0x3, 0x5 }, // 28
  { 0x1B, 0x10, 0x2, 0x4, 0x5 }, // 29
  { 0x1C, 0x10, 0x2, 0x5, 0x5 }, // 30
  { 0x1D, 0x10, 0x2, 0x7, 0x5 }, // 31
  { 0x41, 0x10, 0x4, 0x0, 0xC }, // 32
  { 0x42, 0x10, 0x4, 0x1, 0xC }, // 33
  { 0x43, 0x10, 0x4, 0x2, 0xC }, // 34
  { 0x44, 0x10, 0x4, 0x3, 0xC }, // 35
  { 0x45, 0x10, 0x4, 0x4, 0xC }, // 36
  { 0x46, 0x10, 0x4, 0x5, 0xC }, // 37
  { 0x47, 0x10, 0x4, 0x7, 0xC }, // 38
  { 0x14, 0x20, 0x1, 0x4, 0x4 }, // 39
  { 0x15, 0x20, 0x1, 0x5, 0x4 }, // 40
  { 0x16, 0x20, 0x1, 0x7, 0x4 }, // 41
  { 0x3E, 0x20, 0x2, 0x4, 0xB }, // 42
  { 0x3F, 0x20, 0x2, 0x5, 0xB }, // 43
  { 0x40, 0x20, 0x2, 0x7, 0xB }, // 44
  { 0x48, 0x20, 0x3, 0x4, 0xD }, // 45
  { 0x49, 0x20, 0x3, 0x5, 0xD }, // 46
  { 0x4A, 0x20, 0x3, 0x7, 0xD }, // 47
  { 0x4B, 0x20, 0x4, 0x4, 0xE }, // 48
  { 0x4C, 0x20, 0x4, 0x5, 0xE }, // 49
  { 0x4D, 0x20, 0x4, 0x7, 0xE }, // 50
 };

const GcnBufferFormatInfo *getGfx10PlusBufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat) {
  struct KeyType {
    uint8_t BitsPerComp;
    uint8_t NumComponents;
    uint8_t NumFormat;
  };
  KeyType Key = {BitsPerComp, NumComponents, NumFormat};
  auto Table = makeArrayRef(Gfx10PlusBufferFormat);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const GcnBufferFormatInfo &LHS, const KeyType &RHS) {
      if (LHS.BitsPerComp < RHS.BitsPerComp)
        return true;
      if (LHS.BitsPerComp > RHS.BitsPerComp)
        return false;
      if (LHS.NumComponents < RHS.NumComponents)
        return true;
      if (LHS.NumComponents > RHS.NumComponents)
        return false;
      if (LHS.NumFormat < RHS.NumFormat)
        return true;
      if (LHS.NumFormat > RHS.NumFormat)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.BitsPerComp != Idx->BitsPerComp ||
      Key.NumComponents != Idx->NumComponents ||
      Key.NumFormat != Idx->NumFormat)
    return nullptr;
  return &*Idx;
}

const GcnBufferFormatInfo *getGfx10PlusBufferFormatInfo(uint8_t Format) {
  struct IndexType {
    uint8_t Format;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x1, 0 },
    { 0x2, 1 },
    { 0x3, 2 },
    { 0x4, 3 },
    { 0x5, 4 },
    { 0x6, 5 },
    { 0x7, 18 },
    { 0x8, 19 },
    { 0x9, 20 },
    { 0xA, 21 },
    { 0xB, 22 },
    { 0xC, 23 },
    { 0xD, 24 },
    { 0xE, 6 },
    { 0xF, 7 },
    { 0x10, 8 },
    { 0x11, 9 },
    { 0x12, 10 },
    { 0x13, 11 },
    { 0x14, 39 },
    { 0x15, 40 },
    { 0x16, 41 },
    { 0x17, 25 },
    { 0x18, 26 },
    { 0x19, 27 },
    { 0x1A, 28 },
    { 0x1B, 29 },
    { 0x1C, 30 },
    { 0x1D, 31 },
    { 0x38, 12 },
    { 0x39, 13 },
    { 0x3A, 14 },
    { 0x3B, 15 },
    { 0x3C, 16 },
    { 0x3D, 17 },
    { 0x3E, 42 },
    { 0x3F, 43 },
    { 0x40, 44 },
    { 0x41, 32 },
    { 0x42, 33 },
    { 0x43, 34 },
    { 0x44, 35 },
    { 0x45, 36 },
    { 0x46, 37 },
    { 0x47, 38 },
    { 0x48, 45 },
    { 0x49, 46 },
    { 0x4A, 47 },
    { 0x4B, 48 },
    { 0x4C, 49 },
    { 0x4D, 50 },
  };

  struct KeyType {
    uint8_t Format;
  };
  KeyType Key = {Format};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Format < RHS.Format)
        return true;
      if (LHS.Format > RHS.Format)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Format != Idx->Format)
    return nullptr;
  return &Gfx10PlusBufferFormat[Idx->_index];
}
#endif

#ifdef GET_Gfx9BufferFormat_DECL
const GcnBufferFormatInfo *getGfx9BufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat);
const GcnBufferFormatInfo *getGfx9BufferFormatInfo(uint8_t Format);
#endif

#ifdef GET_Gfx9BufferFormat_IMPL
constexpr GcnBufferFormatInfo Gfx9BufferFormat[] = {
  { 0x1, 0x8, 0x1, 0x0, 0x1 }, // 0
  { 0x11, 0x8, 0x1, 0x1, 0x1 }, // 1
  { 0x21, 0x8, 0x1, 0x2, 0x1 }, // 2
  { 0x31, 0x8, 0x1, 0x3, 0x1 }, // 3
  { 0x41, 0x8, 0x1, 0x4, 0x1 }, // 4
  { 0x51, 0x8, 0x1, 0x5, 0x1 }, // 5
  { 0x3, 0x8, 0x2, 0x0, 0x3 }, // 6
  { 0x13, 0x8, 0x2, 0x1, 0x3 }, // 7
  { 0x23, 0x8, 0x2, 0x2, 0x3 }, // 8
  { 0x33, 0x8, 0x2, 0x3, 0x3 }, // 9
  { 0x43, 0x8, 0x2, 0x4, 0x3 }, // 10
  { 0x53, 0x8, 0x2, 0x5, 0x3 }, // 11
  { 0xA, 0x8, 0x4, 0x0, 0xA }, // 12
  { 0x1A, 0x8, 0x4, 0x1, 0xA }, // 13
  { 0x2A, 0x8, 0x4, 0x2, 0xA }, // 14
  { 0x3A, 0x8, 0x4, 0x3, 0xA }, // 15
  { 0x4A, 0x8, 0x4, 0x4, 0xA }, // 16
  { 0x5A, 0x8, 0x4, 0x5, 0xA }, // 17
  { 0x2, 0x10, 0x1, 0x0, 0x2 }, // 18
  { 0x12, 0x10, 0x1, 0x1, 0x2 }, // 19
  { 0x22, 0x10, 0x1, 0x2, 0x2 }, // 20
  { 0x32, 0x10, 0x1, 0x3, 0x2 }, // 21
  { 0x42, 0x10, 0x1, 0x4, 0x2 }, // 22
  { 0x52, 0x10, 0x1, 0x5, 0x2 }, // 23
  { 0x72, 0x10, 0x1, 0x7, 0x2 }, // 24
  { 0x5, 0x10, 0x2, 0x0, 0x5 }, // 25
  { 0x15, 0x10, 0x2, 0x1, 0x5 }, // 26
  { 0x25, 0x10, 0x2, 0x2, 0x5 }, // 27
  { 0x35, 0x10, 0x2, 0x3, 0x5 }, // 28
  { 0x45, 0x10, 0x2, 0x4, 0x5 }, // 29
  { 0x55, 0x10, 0x2, 0x5, 0x5 }, // 30
  { 0x75, 0x10, 0x2, 0x7, 0x5 }, // 31
  { 0xC, 0x10, 0x4, 0x0, 0xC }, // 32
  { 0x1C, 0x10, 0x4, 0x1, 0xC }, // 33
  { 0x2C, 0x10, 0x4, 0x2, 0xC }, // 34
  { 0x3C, 0x10, 0x4, 0x3, 0xC }, // 35
  { 0x4C, 0x10, 0x4, 0x4, 0xC }, // 36
  { 0x5C, 0x10, 0x4, 0x5, 0xC }, // 37
  { 0x7C, 0x10, 0x4, 0x7, 0xC }, // 38
  { 0x44, 0x20, 0x1, 0x4, 0x4 }, // 39
  { 0x54, 0x20, 0x1, 0x5, 0x4 }, // 40
  { 0x74, 0x20, 0x1, 0x7, 0x4 }, // 41
  { 0x4B, 0x20, 0x2, 0x4, 0xB }, // 42
  { 0x5B, 0x20, 0x2, 0x5, 0xB }, // 43
  { 0x7B, 0x20, 0x2, 0x7, 0xB }, // 44
  { 0x4D, 0x20, 0x3, 0x4, 0xD }, // 45
  { 0x5D, 0x20, 0x3, 0x5, 0xD }, // 46
  { 0x7D, 0x20, 0x3, 0x7, 0xD }, // 47
  { 0x4E, 0x20, 0x4, 0x4, 0xE }, // 48
  { 0x5E, 0x20, 0x4, 0x5, 0xE }, // 49
  { 0x7E, 0x20, 0x4, 0x7, 0xE }, // 50
 };

const GcnBufferFormatInfo *getGfx9BufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat) {
  struct KeyType {
    uint8_t BitsPerComp;
    uint8_t NumComponents;
    uint8_t NumFormat;
  };
  KeyType Key = {BitsPerComp, NumComponents, NumFormat};
  auto Table = makeArrayRef(Gfx9BufferFormat);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const GcnBufferFormatInfo &LHS, const KeyType &RHS) {
      if (LHS.BitsPerComp < RHS.BitsPerComp)
        return true;
      if (LHS.BitsPerComp > RHS.BitsPerComp)
        return false;
      if (LHS.NumComponents < RHS.NumComponents)
        return true;
      if (LHS.NumComponents > RHS.NumComponents)
        return false;
      if (LHS.NumFormat < RHS.NumFormat)
        return true;
      if (LHS.NumFormat > RHS.NumFormat)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.BitsPerComp != Idx->BitsPerComp ||
      Key.NumComponents != Idx->NumComponents ||
      Key.NumFormat != Idx->NumFormat)
    return nullptr;
  return &*Idx;
}

const GcnBufferFormatInfo *getGfx9BufferFormatInfo(uint8_t Format) {
  struct IndexType {
    uint8_t Format;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x1, 0 },
    { 0x2, 18 },
    { 0x3, 6 },
    { 0x5, 25 },
    { 0xA, 12 },
    { 0xC, 32 },
    { 0x11, 1 },
    { 0x12, 19 },
    { 0x13, 7 },
    { 0x15, 26 },
    { 0x1A, 13 },
    { 0x1C, 33 },
    { 0x21, 2 },
    { 0x22, 20 },
    { 0x23, 8 },
    { 0x25, 27 },
    { 0x2A, 14 },
    { 0x2C, 34 },
    { 0x31, 3 },
    { 0x32, 21 },
    { 0x33, 9 },
    { 0x35, 28 },
    { 0x3A, 15 },
    { 0x3C, 35 },
    { 0x41, 4 },
    { 0x42, 22 },
    { 0x43, 10 },
    { 0x44, 39 },
    { 0x45, 29 },
    { 0x4A, 16 },
    { 0x4B, 42 },
    { 0x4C, 36 },
    { 0x4D, 45 },
    { 0x4E, 48 },
    { 0x51, 5 },
    { 0x52, 23 },
    { 0x53, 11 },
    { 0x54, 40 },
    { 0x55, 30 },
    { 0x5A, 17 },
    { 0x5B, 43 },
    { 0x5C, 37 },
    { 0x5D, 46 },
    { 0x5E, 49 },
    { 0x72, 24 },
    { 0x74, 41 },
    { 0x75, 31 },
    { 0x7B, 44 },
    { 0x7C, 38 },
    { 0x7D, 47 },
    { 0x7E, 50 },
  };

  struct KeyType {
    uint8_t Format;
  };
  KeyType Key = {Format};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Format < RHS.Format)
        return true;
      if (LHS.Format > RHS.Format)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Format != Idx->Format)
    return nullptr;
  return &Gfx9BufferFormat[Idx->_index];
}
#endif

#ifdef GET_ImageDimIntrinsicTable_DECL
const ImageDimIntrinsicInfo *getImageDimIntrinsicInfo(unsigned Intr);
const ImageDimIntrinsicInfo *getImageDimIntrinsicByBaseOpcode(unsigned BaseOpcode, unsigned Dim);
#endif

#ifdef GET_ImageDimIntrinsicTable_IMPL
constexpr ImageDimIntrinsicInfo ImageDimIntrinsicTable[] = {
  { Intrinsic::amdgcn_image_atomic_add_1d, IMAGE_ATOMIC_ADD, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 0
  { Intrinsic::amdgcn_image_atomic_add_1darray, IMAGE_ATOMIC_ADD, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 1
  { Intrinsic::amdgcn_image_atomic_add_2d, IMAGE_ATOMIC_ADD, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 2
  { Intrinsic::amdgcn_image_atomic_add_2darray, IMAGE_ATOMIC_ADD, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 3
  { Intrinsic::amdgcn_image_atomic_add_2darraymsaa, IMAGE_ATOMIC_ADD, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 4
  { Intrinsic::amdgcn_image_atomic_add_2dmsaa, IMAGE_ATOMIC_ADD, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 5
  { Intrinsic::amdgcn_image_atomic_add_3d, IMAGE_ATOMIC_ADD, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 6
  { Intrinsic::amdgcn_image_atomic_add_cube, IMAGE_ATOMIC_ADD, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 7
  { Intrinsic::amdgcn_image_atomic_and_1d, IMAGE_ATOMIC_AND, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 8
  { Intrinsic::amdgcn_image_atomic_and_1darray, IMAGE_ATOMIC_AND, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 9
  { Intrinsic::amdgcn_image_atomic_and_2d, IMAGE_ATOMIC_AND, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 10
  { Intrinsic::amdgcn_image_atomic_and_2darray, IMAGE_ATOMIC_AND, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 11
  { Intrinsic::amdgcn_image_atomic_and_2darraymsaa, IMAGE_ATOMIC_AND, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 12
  { Intrinsic::amdgcn_image_atomic_and_2dmsaa, IMAGE_ATOMIC_AND, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 13
  { Intrinsic::amdgcn_image_atomic_and_3d, IMAGE_ATOMIC_AND, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 14
  { Intrinsic::amdgcn_image_atomic_and_cube, IMAGE_ATOMIC_AND, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 15
  { Intrinsic::amdgcn_image_atomic_cmpswap_1d, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x1, 0x6, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 16
  { Intrinsic::amdgcn_image_atomic_cmpswap_1darray, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x7, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 17
  { Intrinsic::amdgcn_image_atomic_cmpswap_2d, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x7, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 18
  { Intrinsic::amdgcn_image_atomic_cmpswap_2darray, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 19
  { Intrinsic::amdgcn_image_atomic_cmpswap_2darraymsaa, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x4, 0x9, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 20
  { Intrinsic::amdgcn_image_atomic_cmpswap_2dmsaa, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 21
  { Intrinsic::amdgcn_image_atomic_cmpswap_3d, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 22
  { Intrinsic::amdgcn_image_atomic_cmpswap_cube, IMAGE_ATOMIC_CMPSWAP, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 23
  { Intrinsic::amdgcn_image_atomic_dec_1d, IMAGE_ATOMIC_DEC, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 24
  { Intrinsic::amdgcn_image_atomic_dec_1darray, IMAGE_ATOMIC_DEC, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 25
  { Intrinsic::amdgcn_image_atomic_dec_2d, IMAGE_ATOMIC_DEC, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 26
  { Intrinsic::amdgcn_image_atomic_dec_2darray, IMAGE_ATOMIC_DEC, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 27
  { Intrinsic::amdgcn_image_atomic_dec_2darraymsaa, IMAGE_ATOMIC_DEC, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 28
  { Intrinsic::amdgcn_image_atomic_dec_2dmsaa, IMAGE_ATOMIC_DEC, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 29
  { Intrinsic::amdgcn_image_atomic_dec_3d, IMAGE_ATOMIC_DEC, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 30
  { Intrinsic::amdgcn_image_atomic_dec_cube, IMAGE_ATOMIC_DEC, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 31
  { Intrinsic::amdgcn_image_atomic_fmax_1d, IMAGE_ATOMIC_FMAX, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 32
  { Intrinsic::amdgcn_image_atomic_fmax_1darray, IMAGE_ATOMIC_FMAX, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 33
  { Intrinsic::amdgcn_image_atomic_fmax_2d, IMAGE_ATOMIC_FMAX, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 34
  { Intrinsic::amdgcn_image_atomic_fmax_2darray, IMAGE_ATOMIC_FMAX, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 35
  { Intrinsic::amdgcn_image_atomic_fmax_2darraymsaa, IMAGE_ATOMIC_FMAX, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 36
  { Intrinsic::amdgcn_image_atomic_fmax_2dmsaa, IMAGE_ATOMIC_FMAX, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 37
  { Intrinsic::amdgcn_image_atomic_fmax_3d, IMAGE_ATOMIC_FMAX, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 38
  { Intrinsic::amdgcn_image_atomic_fmax_cube, IMAGE_ATOMIC_FMAX, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 39
  { Intrinsic::amdgcn_image_atomic_fmin_1d, IMAGE_ATOMIC_FMIN, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 40
  { Intrinsic::amdgcn_image_atomic_fmin_1darray, IMAGE_ATOMIC_FMIN, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 41
  { Intrinsic::amdgcn_image_atomic_fmin_2d, IMAGE_ATOMIC_FMIN, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 42
  { Intrinsic::amdgcn_image_atomic_fmin_2darray, IMAGE_ATOMIC_FMIN, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 43
  { Intrinsic::amdgcn_image_atomic_fmin_2darraymsaa, IMAGE_ATOMIC_FMIN, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 44
  { Intrinsic::amdgcn_image_atomic_fmin_2dmsaa, IMAGE_ATOMIC_FMIN, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 45
  { Intrinsic::amdgcn_image_atomic_fmin_3d, IMAGE_ATOMIC_FMIN, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 46
  { Intrinsic::amdgcn_image_atomic_fmin_cube, IMAGE_ATOMIC_FMIN, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 47
  { Intrinsic::amdgcn_image_atomic_inc_1d, IMAGE_ATOMIC_INC, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 48
  { Intrinsic::amdgcn_image_atomic_inc_1darray, IMAGE_ATOMIC_INC, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 49
  { Intrinsic::amdgcn_image_atomic_inc_2d, IMAGE_ATOMIC_INC, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 50
  { Intrinsic::amdgcn_image_atomic_inc_2darray, IMAGE_ATOMIC_INC, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 51
  { Intrinsic::amdgcn_image_atomic_inc_2darraymsaa, IMAGE_ATOMIC_INC, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 52
  { Intrinsic::amdgcn_image_atomic_inc_2dmsaa, IMAGE_ATOMIC_INC, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 53
  { Intrinsic::amdgcn_image_atomic_inc_3d, IMAGE_ATOMIC_INC, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 54
  { Intrinsic::amdgcn_image_atomic_inc_cube, IMAGE_ATOMIC_INC, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 55
  { Intrinsic::amdgcn_image_atomic_or_1d, IMAGE_ATOMIC_OR, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 56
  { Intrinsic::amdgcn_image_atomic_or_1darray, IMAGE_ATOMIC_OR, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 57
  { Intrinsic::amdgcn_image_atomic_or_2d, IMAGE_ATOMIC_OR, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 58
  { Intrinsic::amdgcn_image_atomic_or_2darray, IMAGE_ATOMIC_OR, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 59
  { Intrinsic::amdgcn_image_atomic_or_2darraymsaa, IMAGE_ATOMIC_OR, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 60
  { Intrinsic::amdgcn_image_atomic_or_2dmsaa, IMAGE_ATOMIC_OR, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 61
  { Intrinsic::amdgcn_image_atomic_or_3d, IMAGE_ATOMIC_OR, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 62
  { Intrinsic::amdgcn_image_atomic_or_cube, IMAGE_ATOMIC_OR, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 63
  { Intrinsic::amdgcn_image_atomic_smax_1d, IMAGE_ATOMIC_SMAX, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 64
  { Intrinsic::amdgcn_image_atomic_smax_1darray, IMAGE_ATOMIC_SMAX, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 65
  { Intrinsic::amdgcn_image_atomic_smax_2d, IMAGE_ATOMIC_SMAX, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 66
  { Intrinsic::amdgcn_image_atomic_smax_2darray, IMAGE_ATOMIC_SMAX, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 67
  { Intrinsic::amdgcn_image_atomic_smax_2darraymsaa, IMAGE_ATOMIC_SMAX, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 68
  { Intrinsic::amdgcn_image_atomic_smax_2dmsaa, IMAGE_ATOMIC_SMAX, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 69
  { Intrinsic::amdgcn_image_atomic_smax_3d, IMAGE_ATOMIC_SMAX, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 70
  { Intrinsic::amdgcn_image_atomic_smax_cube, IMAGE_ATOMIC_SMAX, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 71
  { Intrinsic::amdgcn_image_atomic_smin_1d, IMAGE_ATOMIC_SMIN, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 72
  { Intrinsic::amdgcn_image_atomic_smin_1darray, IMAGE_ATOMIC_SMIN, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 73
  { Intrinsic::amdgcn_image_atomic_smin_2d, IMAGE_ATOMIC_SMIN, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 74
  { Intrinsic::amdgcn_image_atomic_smin_2darray, IMAGE_ATOMIC_SMIN, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 75
  { Intrinsic::amdgcn_image_atomic_smin_2darraymsaa, IMAGE_ATOMIC_SMIN, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 76
  { Intrinsic::amdgcn_image_atomic_smin_2dmsaa, IMAGE_ATOMIC_SMIN, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 77
  { Intrinsic::amdgcn_image_atomic_smin_3d, IMAGE_ATOMIC_SMIN, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 78
  { Intrinsic::amdgcn_image_atomic_smin_cube, IMAGE_ATOMIC_SMIN, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 79
  { Intrinsic::amdgcn_image_atomic_sub_1d, IMAGE_ATOMIC_SUB, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 80
  { Intrinsic::amdgcn_image_atomic_sub_1darray, IMAGE_ATOMIC_SUB, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 81
  { Intrinsic::amdgcn_image_atomic_sub_2d, IMAGE_ATOMIC_SUB, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 82
  { Intrinsic::amdgcn_image_atomic_sub_2darray, IMAGE_ATOMIC_SUB, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 83
  { Intrinsic::amdgcn_image_atomic_sub_2darraymsaa, IMAGE_ATOMIC_SUB, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 84
  { Intrinsic::amdgcn_image_atomic_sub_2dmsaa, IMAGE_ATOMIC_SUB, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 85
  { Intrinsic::amdgcn_image_atomic_sub_3d, IMAGE_ATOMIC_SUB, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 86
  { Intrinsic::amdgcn_image_atomic_sub_cube, IMAGE_ATOMIC_SUB, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 87
  { Intrinsic::amdgcn_image_atomic_swap_1d, IMAGE_ATOMIC_SWAP, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 88
  { Intrinsic::amdgcn_image_atomic_swap_1darray, IMAGE_ATOMIC_SWAP, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 89
  { Intrinsic::amdgcn_image_atomic_swap_2d, IMAGE_ATOMIC_SWAP, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 90
  { Intrinsic::amdgcn_image_atomic_swap_2darray, IMAGE_ATOMIC_SWAP, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 91
  { Intrinsic::amdgcn_image_atomic_swap_2darraymsaa, IMAGE_ATOMIC_SWAP, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 92
  { Intrinsic::amdgcn_image_atomic_swap_2dmsaa, IMAGE_ATOMIC_SWAP, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 93
  { Intrinsic::amdgcn_image_atomic_swap_3d, IMAGE_ATOMIC_SWAP, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 94
  { Intrinsic::amdgcn_image_atomic_swap_cube, IMAGE_ATOMIC_SWAP, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 95
  { Intrinsic::amdgcn_image_atomic_umax_1d, IMAGE_ATOMIC_UMAX, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 96
  { Intrinsic::amdgcn_image_atomic_umax_1darray, IMAGE_ATOMIC_UMAX, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 97
  { Intrinsic::amdgcn_image_atomic_umax_2d, IMAGE_ATOMIC_UMAX, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 98
  { Intrinsic::amdgcn_image_atomic_umax_2darray, IMAGE_ATOMIC_UMAX, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 99
  { Intrinsic::amdgcn_image_atomic_umax_2darraymsaa, IMAGE_ATOMIC_UMAX, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 100
  { Intrinsic::amdgcn_image_atomic_umax_2dmsaa, IMAGE_ATOMIC_UMAX, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 101
  { Intrinsic::amdgcn_image_atomic_umax_3d, IMAGE_ATOMIC_UMAX, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 102
  { Intrinsic::amdgcn_image_atomic_umax_cube, IMAGE_ATOMIC_UMAX, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 103
  { Intrinsic::amdgcn_image_atomic_umin_1d, IMAGE_ATOMIC_UMIN, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 104
  { Intrinsic::amdgcn_image_atomic_umin_1darray, IMAGE_ATOMIC_UMIN, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 105
  { Intrinsic::amdgcn_image_atomic_umin_2d, IMAGE_ATOMIC_UMIN, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 106
  { Intrinsic::amdgcn_image_atomic_umin_2darray, IMAGE_ATOMIC_UMIN, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 107
  { Intrinsic::amdgcn_image_atomic_umin_2darraymsaa, IMAGE_ATOMIC_UMIN, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 108
  { Intrinsic::amdgcn_image_atomic_umin_2dmsaa, IMAGE_ATOMIC_UMIN, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 109
  { Intrinsic::amdgcn_image_atomic_umin_3d, IMAGE_ATOMIC_UMIN, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 110
  { Intrinsic::amdgcn_image_atomic_umin_cube, IMAGE_ATOMIC_UMIN, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 111
  { Intrinsic::amdgcn_image_atomic_xor_1d, IMAGE_ATOMIC_XOR, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 112
  { Intrinsic::amdgcn_image_atomic_xor_1darray, IMAGE_ATOMIC_XOR, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 113
  { Intrinsic::amdgcn_image_atomic_xor_2d, IMAGE_ATOMIC_XOR, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 114
  { Intrinsic::amdgcn_image_atomic_xor_2darray, IMAGE_ATOMIC_XOR, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 115
  { Intrinsic::amdgcn_image_atomic_xor_2darraymsaa, IMAGE_ATOMIC_XOR, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 116
  { Intrinsic::amdgcn_image_atomic_xor_2dmsaa, IMAGE_ATOMIC_XOR, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 117
  { Intrinsic::amdgcn_image_atomic_xor_3d, IMAGE_ATOMIC_XOR, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 118
  { Intrinsic::amdgcn_image_atomic_xor_cube, IMAGE_ATOMIC_XOR, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 119
  { Intrinsic::amdgcn_image_gather4_2d, IMAGE_GATHER4, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 120
  { Intrinsic::amdgcn_image_gather4_2darray, IMAGE_GATHER4, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 121
  { Intrinsic::amdgcn_image_gather4_b_2d, IMAGE_GATHER4_B, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 122
  { Intrinsic::amdgcn_image_gather4_b_2darray, IMAGE_GATHER4_B, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 123
  { Intrinsic::amdgcn_image_gather4_b_cl_2d, IMAGE_GATHER4_B_CL, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 124
  { Intrinsic::amdgcn_image_gather4_b_cl_2darray, IMAGE_GATHER4_B_CL, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 125
  { Intrinsic::amdgcn_image_gather4_b_cl_cube, IMAGE_GATHER4_B_CL, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 126
  { Intrinsic::amdgcn_image_gather4_b_cl_o_2d, IMAGE_GATHER4_B_CL_O, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 127
  { Intrinsic::amdgcn_image_gather4_b_cl_o_2darray, IMAGE_GATHER4_B_CL_O, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 128
  { Intrinsic::amdgcn_image_gather4_b_cl_o_cube, IMAGE_GATHER4_B_CL_O, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 129
  { Intrinsic::amdgcn_image_gather4_b_cube, IMAGE_GATHER4_B, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 130
  { Intrinsic::amdgcn_image_gather4_b_o_2d, IMAGE_GATHER4_B_O, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 131
  { Intrinsic::amdgcn_image_gather4_b_o_2darray, IMAGE_GATHER4_B_O, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 132
  { Intrinsic::amdgcn_image_gather4_b_o_cube, IMAGE_GATHER4_B_O, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 133
  { Intrinsic::amdgcn_image_gather4_c_2d, IMAGE_GATHER4_C, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 134
  { Intrinsic::amdgcn_image_gather4_c_2darray, IMAGE_GATHER4_C, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 135
  { Intrinsic::amdgcn_image_gather4_c_b_2d, IMAGE_GATHER4_C_B, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 136
  { Intrinsic::amdgcn_image_gather4_c_b_2darray, IMAGE_GATHER4_C_B, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 137
  { Intrinsic::amdgcn_image_gather4_c_b_cl_2d, IMAGE_GATHER4_C_B_CL, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 138
  { Intrinsic::amdgcn_image_gather4_c_b_cl_2darray, IMAGE_GATHER4_C_B_CL, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 139
  { Intrinsic::amdgcn_image_gather4_c_b_cl_cube, IMAGE_GATHER4_C_B_CL, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 140
  { Intrinsic::amdgcn_image_gather4_c_b_cl_o_2d, IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 141
  { Intrinsic::amdgcn_image_gather4_c_b_cl_o_2darray, IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 142
  { Intrinsic::amdgcn_image_gather4_c_b_cl_o_cube, IMAGE_GATHER4_C_B_CL_O, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 143
  { Intrinsic::amdgcn_image_gather4_c_b_cube, IMAGE_GATHER4_C_B, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 144
  { Intrinsic::amdgcn_image_gather4_c_b_o_2d, IMAGE_GATHER4_C_B_O, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 145
  { Intrinsic::amdgcn_image_gather4_c_b_o_2darray, IMAGE_GATHER4_C_B_O, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 146
  { Intrinsic::amdgcn_image_gather4_c_b_o_cube, IMAGE_GATHER4_C_B_O, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 147
  { Intrinsic::amdgcn_image_gather4_c_cl_2d, IMAGE_GATHER4_C_CL, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 148
  { Intrinsic::amdgcn_image_gather4_c_cl_2darray, IMAGE_GATHER4_C_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 149
  { Intrinsic::amdgcn_image_gather4_c_cl_cube, IMAGE_GATHER4_C_CL, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 150
  { Intrinsic::amdgcn_image_gather4_c_cl_o_2d, IMAGE_GATHER4_C_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 151
  { Intrinsic::amdgcn_image_gather4_c_cl_o_2darray, IMAGE_GATHER4_C_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 152
  { Intrinsic::amdgcn_image_gather4_c_cl_o_cube, IMAGE_GATHER4_C_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 153
  { Intrinsic::amdgcn_image_gather4_c_cube, IMAGE_GATHER4_C, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 154
  { Intrinsic::amdgcn_image_gather4_c_l_2d, IMAGE_GATHER4_C_L, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 155
  { Intrinsic::amdgcn_image_gather4_c_l_2darray, IMAGE_GATHER4_C_L, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 156
  { Intrinsic::amdgcn_image_gather4_c_l_cube, IMAGE_GATHER4_C_L, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 157
  { Intrinsic::amdgcn_image_gather4_c_l_o_2d, IMAGE_GATHER4_C_L_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 158
  { Intrinsic::amdgcn_image_gather4_c_l_o_2darray, IMAGE_GATHER4_C_L_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 159
  { Intrinsic::amdgcn_image_gather4_c_l_o_cube, IMAGE_GATHER4_C_L_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 160
  { Intrinsic::amdgcn_image_gather4_c_lz_2d, IMAGE_GATHER4_C_LZ, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 161
  { Intrinsic::amdgcn_image_gather4_c_lz_2darray, IMAGE_GATHER4_C_LZ, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 162
  { Intrinsic::amdgcn_image_gather4_c_lz_cube, IMAGE_GATHER4_C_LZ, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 163
  { Intrinsic::amdgcn_image_gather4_c_lz_o_2d, IMAGE_GATHER4_C_LZ_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 164
  { Intrinsic::amdgcn_image_gather4_c_lz_o_2darray, IMAGE_GATHER4_C_LZ_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 165
  { Intrinsic::amdgcn_image_gather4_c_lz_o_cube, IMAGE_GATHER4_C_LZ_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 166
  { Intrinsic::amdgcn_image_gather4_c_o_2d, IMAGE_GATHER4_C_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 167
  { Intrinsic::amdgcn_image_gather4_c_o_2darray, IMAGE_GATHER4_C_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 168
  { Intrinsic::amdgcn_image_gather4_c_o_cube, IMAGE_GATHER4_C_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 169
  { Intrinsic::amdgcn_image_gather4_cl_2d, IMAGE_GATHER4_CL, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 170
  { Intrinsic::amdgcn_image_gather4_cl_2darray, IMAGE_GATHER4_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 171
  { Intrinsic::amdgcn_image_gather4_cl_cube, IMAGE_GATHER4_CL, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 172
  { Intrinsic::amdgcn_image_gather4_cl_o_2d, IMAGE_GATHER4_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 173
  { Intrinsic::amdgcn_image_gather4_cl_o_2darray, IMAGE_GATHER4_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 174
  { Intrinsic::amdgcn_image_gather4_cl_o_cube, IMAGE_GATHER4_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 175
  { Intrinsic::amdgcn_image_gather4_cube, IMAGE_GATHER4, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 176
  { Intrinsic::amdgcn_image_gather4_l_2d, IMAGE_GATHER4_L, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 177
  { Intrinsic::amdgcn_image_gather4_l_2darray, IMAGE_GATHER4_L, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 178
  { Intrinsic::amdgcn_image_gather4_l_cube, IMAGE_GATHER4_L, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 179
  { Intrinsic::amdgcn_image_gather4_l_o_2d, IMAGE_GATHER4_L_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 180
  { Intrinsic::amdgcn_image_gather4_l_o_2darray, IMAGE_GATHER4_L_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 181
  { Intrinsic::amdgcn_image_gather4_l_o_cube, IMAGE_GATHER4_L_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 182
  { Intrinsic::amdgcn_image_gather4_lz_2d, IMAGE_GATHER4_LZ, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 183
  { Intrinsic::amdgcn_image_gather4_lz_2darray, IMAGE_GATHER4_LZ, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 184
  { Intrinsic::amdgcn_image_gather4_lz_cube, IMAGE_GATHER4_LZ, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 185
  { Intrinsic::amdgcn_image_gather4_lz_o_2d, IMAGE_GATHER4_LZ_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 186
  { Intrinsic::amdgcn_image_gather4_lz_o_2darray, IMAGE_GATHER4_LZ_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 187
  { Intrinsic::amdgcn_image_gather4_lz_o_cube, IMAGE_GATHER4_LZ_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 188
  { Intrinsic::amdgcn_image_gather4_o_2d, IMAGE_GATHER4_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 189
  { Intrinsic::amdgcn_image_gather4_o_2darray, IMAGE_GATHER4_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 190
  { Intrinsic::amdgcn_image_gather4_o_cube, IMAGE_GATHER4_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 191
  { Intrinsic::amdgcn_image_getlod_1d, IMAGE_GET_LOD, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 192
  { Intrinsic::amdgcn_image_getlod_1darray, IMAGE_GET_LOD, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 193
  { Intrinsic::amdgcn_image_getlod_2d, IMAGE_GET_LOD, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 194
  { Intrinsic::amdgcn_image_getlod_2darray, IMAGE_GET_LOD, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 195
  { Intrinsic::amdgcn_image_getlod_3d, IMAGE_GET_LOD, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 196
  { Intrinsic::amdgcn_image_getlod_cube, IMAGE_GET_LOD, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 197
  { Intrinsic::amdgcn_image_getresinfo_1d, IMAGE_GET_RESINFO, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 198
  { Intrinsic::amdgcn_image_getresinfo_1darray, IMAGE_GET_RESINFO, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 199
  { Intrinsic::amdgcn_image_getresinfo_2d, IMAGE_GET_RESINFO, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 200
  { Intrinsic::amdgcn_image_getresinfo_2darray, IMAGE_GET_RESINFO, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 201
  { Intrinsic::amdgcn_image_getresinfo_2darraymsaa, IMAGE_GET_RESINFO, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 202
  { Intrinsic::amdgcn_image_getresinfo_2dmsaa, IMAGE_GET_RESINFO, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 203
  { Intrinsic::amdgcn_image_getresinfo_3d, IMAGE_GET_RESINFO, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 204
  { Intrinsic::amdgcn_image_getresinfo_cube, IMAGE_GET_RESINFO, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 205
  { Intrinsic::amdgcn_image_load_1d, IMAGE_LOAD, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 206
  { Intrinsic::amdgcn_image_load_1darray, IMAGE_LOAD, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x6, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 207
  { Intrinsic::amdgcn_image_load_2d, IMAGE_LOAD, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x6, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 208
  { Intrinsic::amdgcn_image_load_2darray, IMAGE_LOAD, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 209
  { Intrinsic::amdgcn_image_load_2darraymsaa, IMAGE_LOAD, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 210
  { Intrinsic::amdgcn_image_load_2dmsaa, IMAGE_LOAD, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 211
  { Intrinsic::amdgcn_image_load_3d, IMAGE_LOAD, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 212
  { Intrinsic::amdgcn_image_load_cube, IMAGE_LOAD, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 213
  { Intrinsic::amdgcn_image_load_mip_1d, IMAGE_LOAD_MIP, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x6, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 214
  { Intrinsic::amdgcn_image_load_mip_1darray, IMAGE_LOAD_MIP, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 215
  { Intrinsic::amdgcn_image_load_mip_2d, IMAGE_LOAD_MIP, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 216
  { Intrinsic::amdgcn_image_load_mip_2darray, IMAGE_LOAD_MIP, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 217
  { Intrinsic::amdgcn_image_load_mip_3d, IMAGE_LOAD_MIP, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 218
  { Intrinsic::amdgcn_image_load_mip_cube, IMAGE_LOAD_MIP, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 219
  { Intrinsic::amdgcn_image_msaa_load_x_2darraymsaa, IMAGE_MSAA_LOAD_X, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 220
  { Intrinsic::amdgcn_image_msaa_load_x_2dmsaa, IMAGE_MSAA_LOAD_X, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 221
  { Intrinsic::amdgcn_image_sample_1d, IMAGE_SAMPLE, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 222
  { Intrinsic::amdgcn_image_sample_1darray, IMAGE_SAMPLE, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 223
  { Intrinsic::amdgcn_image_sample_2d, IMAGE_SAMPLE, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 224
  { Intrinsic::amdgcn_image_sample_2darray, IMAGE_SAMPLE, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 225
  { Intrinsic::amdgcn_image_sample_3d, IMAGE_SAMPLE, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 226
  { Intrinsic::amdgcn_image_sample_b_1d, IMAGE_SAMPLE_B, AMDGPUDim1D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x2, 0x2 }, // 227
  { Intrinsic::amdgcn_image_sample_b_1darray, IMAGE_SAMPLE_B, AMDGPUDim1DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 228
  { Intrinsic::amdgcn_image_sample_b_2d, IMAGE_SAMPLE_B, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 229
  { Intrinsic::amdgcn_image_sample_b_2darray, IMAGE_SAMPLE_B, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 230
  { Intrinsic::amdgcn_image_sample_b_3d, IMAGE_SAMPLE_B, AMDGPUDim3D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 231
  { Intrinsic::amdgcn_image_sample_b_cl_1d, IMAGE_SAMPLE_B_CL, AMDGPUDim1D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 232
  { Intrinsic::amdgcn_image_sample_b_cl_1darray, IMAGE_SAMPLE_B_CL, AMDGPUDim1DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 233
  { Intrinsic::amdgcn_image_sample_b_cl_2d, IMAGE_SAMPLE_B_CL, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 234
  { Intrinsic::amdgcn_image_sample_b_cl_2darray, IMAGE_SAMPLE_B_CL, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 235
  { Intrinsic::amdgcn_image_sample_b_cl_3d, IMAGE_SAMPLE_B_CL, AMDGPUDim3D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 236
  { Intrinsic::amdgcn_image_sample_b_cl_cube, IMAGE_SAMPLE_B_CL, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 237
  { Intrinsic::amdgcn_image_sample_b_cl_o_1d, IMAGE_SAMPLE_B_CL_O, AMDGPUDim1D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 238
  { Intrinsic::amdgcn_image_sample_b_cl_o_1darray, IMAGE_SAMPLE_B_CL_O, AMDGPUDim1DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 239
  { Intrinsic::amdgcn_image_sample_b_cl_o_2d, IMAGE_SAMPLE_B_CL_O, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 240
  { Intrinsic::amdgcn_image_sample_b_cl_o_2darray, IMAGE_SAMPLE_B_CL_O, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 241
  { Intrinsic::amdgcn_image_sample_b_cl_o_3d, IMAGE_SAMPLE_B_CL_O, AMDGPUDim3D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 242
  { Intrinsic::amdgcn_image_sample_b_cl_o_cube, IMAGE_SAMPLE_B_CL_O, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 243
  { Intrinsic::amdgcn_image_sample_b_cube, IMAGE_SAMPLE_B, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 244
  { Intrinsic::amdgcn_image_sample_b_o_1d, IMAGE_SAMPLE_B_O, AMDGPUDim1D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 245
  { Intrinsic::amdgcn_image_sample_b_o_1darray, IMAGE_SAMPLE_B_O, AMDGPUDim1DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 246
  { Intrinsic::amdgcn_image_sample_b_o_2d, IMAGE_SAMPLE_B_O, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 247
  { Intrinsic::amdgcn_image_sample_b_o_2darray, IMAGE_SAMPLE_B_O, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 248
  { Intrinsic::amdgcn_image_sample_b_o_3d, IMAGE_SAMPLE_B_O, AMDGPUDim3D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 249
  { Intrinsic::amdgcn_image_sample_b_o_cube, IMAGE_SAMPLE_B_O, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 250
  { Intrinsic::amdgcn_image_sample_c_1d, IMAGE_SAMPLE_C, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 251
  { Intrinsic::amdgcn_image_sample_c_1darray, IMAGE_SAMPLE_C, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 252
  { Intrinsic::amdgcn_image_sample_c_2d, IMAGE_SAMPLE_C, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 253
  { Intrinsic::amdgcn_image_sample_c_2darray, IMAGE_SAMPLE_C, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 254
  { Intrinsic::amdgcn_image_sample_c_3d, IMAGE_SAMPLE_C, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 255
  { Intrinsic::amdgcn_image_sample_c_b_1d, IMAGE_SAMPLE_C_B, AMDGPUDim1D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 256
  { Intrinsic::amdgcn_image_sample_c_b_1darray, IMAGE_SAMPLE_C_B, AMDGPUDim1DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 257
  { Intrinsic::amdgcn_image_sample_c_b_2d, IMAGE_SAMPLE_C_B, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 258
  { Intrinsic::amdgcn_image_sample_c_b_2darray, IMAGE_SAMPLE_C_B, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 259
  { Intrinsic::amdgcn_image_sample_c_b_3d, IMAGE_SAMPLE_C_B, AMDGPUDim3D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 260
  { Intrinsic::amdgcn_image_sample_c_b_cl_1d, IMAGE_SAMPLE_C_B_CL, AMDGPUDim1D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 261
  { Intrinsic::amdgcn_image_sample_c_b_cl_1darray, IMAGE_SAMPLE_C_B_CL, AMDGPUDim1DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 262
  { Intrinsic::amdgcn_image_sample_c_b_cl_2d, IMAGE_SAMPLE_C_B_CL, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 263
  { Intrinsic::amdgcn_image_sample_c_b_cl_2darray, IMAGE_SAMPLE_C_B_CL, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 264
  { Intrinsic::amdgcn_image_sample_c_b_cl_3d, IMAGE_SAMPLE_C_B_CL, AMDGPUDim3D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 265
  { Intrinsic::amdgcn_image_sample_c_b_cl_cube, IMAGE_SAMPLE_C_B_CL, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 266
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1d, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 267
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1darray, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 268
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2d, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 269
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2darray, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 270
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_3d, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim3D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 271
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_cube, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 272
  { Intrinsic::amdgcn_image_sample_c_b_cube, IMAGE_SAMPLE_C_B, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 273
  { Intrinsic::amdgcn_image_sample_c_b_o_1d, IMAGE_SAMPLE_C_B_O, AMDGPUDim1D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 274
  { Intrinsic::amdgcn_image_sample_c_b_o_1darray, IMAGE_SAMPLE_C_B_O, AMDGPUDim1DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 275
  { Intrinsic::amdgcn_image_sample_c_b_o_2d, IMAGE_SAMPLE_C_B_O, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 276
  { Intrinsic::amdgcn_image_sample_c_b_o_2darray, IMAGE_SAMPLE_C_B_O, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 277
  { Intrinsic::amdgcn_image_sample_c_b_o_3d, IMAGE_SAMPLE_C_B_O, AMDGPUDim3D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 278
  { Intrinsic::amdgcn_image_sample_c_b_o_cube, IMAGE_SAMPLE_C_B_O, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 279
  { Intrinsic::amdgcn_image_sample_c_cd_1d, IMAGE_SAMPLE_C_CD, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 280
  { Intrinsic::amdgcn_image_sample_c_cd_1darray, IMAGE_SAMPLE_C_CD, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 281
  { Intrinsic::amdgcn_image_sample_c_cd_2d, IMAGE_SAMPLE_C_CD, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 282
  { Intrinsic::amdgcn_image_sample_c_cd_2darray, IMAGE_SAMPLE_C_CD, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 283
  { Intrinsic::amdgcn_image_sample_c_cd_3d, IMAGE_SAMPLE_C_CD, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 284
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1d, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 285
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1darray, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 286
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2d, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 287
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2darray, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 288
  { Intrinsic::amdgcn_image_sample_c_cd_cl_3d, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 289
  { Intrinsic::amdgcn_image_sample_c_cd_cl_cube, IMAGE_SAMPLE_C_CD_CL, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 290
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1d, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 291
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1darray, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 292
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2d, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 293
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2darray, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 294
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_3d, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xC, 0x12, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xC, 0xC, 0xD, 0xD, 0xE, 0xF, 0x10, 0x11, 0x1, 0x1, 0x2 }, // 295
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_cube, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 296
  { Intrinsic::amdgcn_image_sample_c_cd_cube, IMAGE_SAMPLE_C_CD, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 297
  { Intrinsic::amdgcn_image_sample_c_cd_o_1d, IMAGE_SAMPLE_C_CD_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 298
  { Intrinsic::amdgcn_image_sample_c_cd_o_1darray, IMAGE_SAMPLE_C_CD_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 299
  { Intrinsic::amdgcn_image_sample_c_cd_o_2d, IMAGE_SAMPLE_C_CD_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 300
  { Intrinsic::amdgcn_image_sample_c_cd_o_2darray, IMAGE_SAMPLE_C_CD_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 301
  { Intrinsic::amdgcn_image_sample_c_cd_o_3d, IMAGE_SAMPLE_C_CD_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 302
  { Intrinsic::amdgcn_image_sample_c_cd_o_cube, IMAGE_SAMPLE_C_CD_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 303
  { Intrinsic::amdgcn_image_sample_c_cl_1d, IMAGE_SAMPLE_C_CL, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 304
  { Intrinsic::amdgcn_image_sample_c_cl_1darray, IMAGE_SAMPLE_C_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 305
  { Intrinsic::amdgcn_image_sample_c_cl_2d, IMAGE_SAMPLE_C_CL, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 306
  { Intrinsic::amdgcn_image_sample_c_cl_2darray, IMAGE_SAMPLE_C_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 307
  { Intrinsic::amdgcn_image_sample_c_cl_3d, IMAGE_SAMPLE_C_CL, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 308
  { Intrinsic::amdgcn_image_sample_c_cl_cube, IMAGE_SAMPLE_C_CL, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 309
  { Intrinsic::amdgcn_image_sample_c_cl_o_1d, IMAGE_SAMPLE_C_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 310
  { Intrinsic::amdgcn_image_sample_c_cl_o_1darray, IMAGE_SAMPLE_C_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 311
  { Intrinsic::amdgcn_image_sample_c_cl_o_2d, IMAGE_SAMPLE_C_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 312
  { Intrinsic::amdgcn_image_sample_c_cl_o_2darray, IMAGE_SAMPLE_C_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 313
  { Intrinsic::amdgcn_image_sample_c_cl_o_3d, IMAGE_SAMPLE_C_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 314
  { Intrinsic::amdgcn_image_sample_c_cl_o_cube, IMAGE_SAMPLE_C_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 315
  { Intrinsic::amdgcn_image_sample_c_cube, IMAGE_SAMPLE_C, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 316
  { Intrinsic::amdgcn_image_sample_c_d_1d, IMAGE_SAMPLE_C_D, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 317
  { Intrinsic::amdgcn_image_sample_c_d_1darray, IMAGE_SAMPLE_C_D, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 318
  { Intrinsic::amdgcn_image_sample_c_d_2d, IMAGE_SAMPLE_C_D, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 319
  { Intrinsic::amdgcn_image_sample_c_d_2darray, IMAGE_SAMPLE_C_D, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 320
  { Intrinsic::amdgcn_image_sample_c_d_3d, IMAGE_SAMPLE_C_D, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 321
  { Intrinsic::amdgcn_image_sample_c_d_cl_1d, IMAGE_SAMPLE_C_D_CL, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 322
  { Intrinsic::amdgcn_image_sample_c_d_cl_1darray, IMAGE_SAMPLE_C_D_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 323
  { Intrinsic::amdgcn_image_sample_c_d_cl_2d, IMAGE_SAMPLE_C_D_CL, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 324
  { Intrinsic::amdgcn_image_sample_c_d_cl_2darray, IMAGE_SAMPLE_C_D_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 325
  { Intrinsic::amdgcn_image_sample_c_d_cl_3d, IMAGE_SAMPLE_C_D_CL, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 326
  { Intrinsic::amdgcn_image_sample_c_d_cl_cube, IMAGE_SAMPLE_C_D_CL, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 327
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1d, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 328
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1darray, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 329
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2d, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 330
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2darray, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 331
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_3d, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xC, 0x12, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xC, 0xC, 0xD, 0xD, 0xE, 0xF, 0x10, 0x11, 0x1, 0x1, 0x2 }, // 332
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_cube, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 333
  { Intrinsic::amdgcn_image_sample_c_d_cube, IMAGE_SAMPLE_C_D, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 334
  { Intrinsic::amdgcn_image_sample_c_d_o_1d, IMAGE_SAMPLE_C_D_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 335
  { Intrinsic::amdgcn_image_sample_c_d_o_1darray, IMAGE_SAMPLE_C_D_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 336
  { Intrinsic::amdgcn_image_sample_c_d_o_2d, IMAGE_SAMPLE_C_D_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 337
  { Intrinsic::amdgcn_image_sample_c_d_o_2darray, IMAGE_SAMPLE_C_D_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 338
  { Intrinsic::amdgcn_image_sample_c_d_o_3d, IMAGE_SAMPLE_C_D_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 339
  { Intrinsic::amdgcn_image_sample_c_d_o_cube, IMAGE_SAMPLE_C_D_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 340
  { Intrinsic::amdgcn_image_sample_c_l_1d, IMAGE_SAMPLE_C_L, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 341
  { Intrinsic::amdgcn_image_sample_c_l_1darray, IMAGE_SAMPLE_C_L, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 342
  { Intrinsic::amdgcn_image_sample_c_l_2d, IMAGE_SAMPLE_C_L, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 343
  { Intrinsic::amdgcn_image_sample_c_l_2darray, IMAGE_SAMPLE_C_L, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 344
  { Intrinsic::amdgcn_image_sample_c_l_3d, IMAGE_SAMPLE_C_L, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 345
  { Intrinsic::amdgcn_image_sample_c_l_cube, IMAGE_SAMPLE_C_L, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 346
  { Intrinsic::amdgcn_image_sample_c_l_o_1d, IMAGE_SAMPLE_C_L_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 347
  { Intrinsic::amdgcn_image_sample_c_l_o_1darray, IMAGE_SAMPLE_C_L_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 348
  { Intrinsic::amdgcn_image_sample_c_l_o_2d, IMAGE_SAMPLE_C_L_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 349
  { Intrinsic::amdgcn_image_sample_c_l_o_2darray, IMAGE_SAMPLE_C_L_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 350
  { Intrinsic::amdgcn_image_sample_c_l_o_3d, IMAGE_SAMPLE_C_L_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 351
  { Intrinsic::amdgcn_image_sample_c_l_o_cube, IMAGE_SAMPLE_C_L_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 352
  { Intrinsic::amdgcn_image_sample_c_lz_1d, IMAGE_SAMPLE_C_LZ, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 353
  { Intrinsic::amdgcn_image_sample_c_lz_1darray, IMAGE_SAMPLE_C_LZ, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 354
  { Intrinsic::amdgcn_image_sample_c_lz_2d, IMAGE_SAMPLE_C_LZ, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 355
  { Intrinsic::amdgcn_image_sample_c_lz_2darray, IMAGE_SAMPLE_C_LZ, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 356
  { Intrinsic::amdgcn_image_sample_c_lz_3d, IMAGE_SAMPLE_C_LZ, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 357
  { Intrinsic::amdgcn_image_sample_c_lz_cube, IMAGE_SAMPLE_C_LZ, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 358
  { Intrinsic::amdgcn_image_sample_c_lz_o_1d, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 359
  { Intrinsic::amdgcn_image_sample_c_lz_o_1darray, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 360
  { Intrinsic::amdgcn_image_sample_c_lz_o_2d, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 361
  { Intrinsic::amdgcn_image_sample_c_lz_o_2darray, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 362
  { Intrinsic::amdgcn_image_sample_c_lz_o_3d, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 363
  { Intrinsic::amdgcn_image_sample_c_lz_o_cube, IMAGE_SAMPLE_C_LZ_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 364
  { Intrinsic::amdgcn_image_sample_c_o_1d, IMAGE_SAMPLE_C_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 365
  { Intrinsic::amdgcn_image_sample_c_o_1darray, IMAGE_SAMPLE_C_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 366
  { Intrinsic::amdgcn_image_sample_c_o_2d, IMAGE_SAMPLE_C_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 367
  { Intrinsic::amdgcn_image_sample_c_o_2darray, IMAGE_SAMPLE_C_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 368
  { Intrinsic::amdgcn_image_sample_c_o_3d, IMAGE_SAMPLE_C_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 369
  { Intrinsic::amdgcn_image_sample_c_o_cube, IMAGE_SAMPLE_C_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 370
  { Intrinsic::amdgcn_image_sample_cd_1d, IMAGE_SAMPLE_CD, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x2 }, // 371
  { Intrinsic::amdgcn_image_sample_cd_1darray, IMAGE_SAMPLE_CD, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 372
  { Intrinsic::amdgcn_image_sample_cd_2d, IMAGE_SAMPLE_CD, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 373
  { Intrinsic::amdgcn_image_sample_cd_2darray, IMAGE_SAMPLE_CD, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 374
  { Intrinsic::amdgcn_image_sample_cd_3d, IMAGE_SAMPLE_CD, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 375
  { Intrinsic::amdgcn_image_sample_cd_cl_1d, IMAGE_SAMPLE_CD_CL, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 376
  { Intrinsic::amdgcn_image_sample_cd_cl_1darray, IMAGE_SAMPLE_CD_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 377
  { Intrinsic::amdgcn_image_sample_cd_cl_2d, IMAGE_SAMPLE_CD_CL, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 378
  { Intrinsic::amdgcn_image_sample_cd_cl_2darray, IMAGE_SAMPLE_CD_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 379
  { Intrinsic::amdgcn_image_sample_cd_cl_3d, IMAGE_SAMPLE_CD_CL, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 380
  { Intrinsic::amdgcn_image_sample_cd_cl_cube, IMAGE_SAMPLE_CD_CL, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 381
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1d, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 382
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1darray, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 383
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2d, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 384
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2darray, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 385
  { Intrinsic::amdgcn_image_sample_cd_cl_o_3d, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 386
  { Intrinsic::amdgcn_image_sample_cd_cl_o_cube, IMAGE_SAMPLE_CD_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 387
  { Intrinsic::amdgcn_image_sample_cd_cube, IMAGE_SAMPLE_CD, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 388
  { Intrinsic::amdgcn_image_sample_cd_o_1d, IMAGE_SAMPLE_CD_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 389
  { Intrinsic::amdgcn_image_sample_cd_o_1darray, IMAGE_SAMPLE_CD_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 390
  { Intrinsic::amdgcn_image_sample_cd_o_2d, IMAGE_SAMPLE_CD_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 391
  { Intrinsic::amdgcn_image_sample_cd_o_2darray, IMAGE_SAMPLE_CD_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 392
  { Intrinsic::amdgcn_image_sample_cd_o_3d, IMAGE_SAMPLE_CD_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 393
  { Intrinsic::amdgcn_image_sample_cd_o_cube, IMAGE_SAMPLE_CD_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 394
  { Intrinsic::amdgcn_image_sample_cl_1d, IMAGE_SAMPLE_CL, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 395
  { Intrinsic::amdgcn_image_sample_cl_1darray, IMAGE_SAMPLE_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 396
  { Intrinsic::amdgcn_image_sample_cl_2d, IMAGE_SAMPLE_CL, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 397
  { Intrinsic::amdgcn_image_sample_cl_2darray, IMAGE_SAMPLE_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 398
  { Intrinsic::amdgcn_image_sample_cl_3d, IMAGE_SAMPLE_CL, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 399
  { Intrinsic::amdgcn_image_sample_cl_cube, IMAGE_SAMPLE_CL, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 400
  { Intrinsic::amdgcn_image_sample_cl_o_1d, IMAGE_SAMPLE_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 401
  { Intrinsic::amdgcn_image_sample_cl_o_1darray, IMAGE_SAMPLE_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 402
  { Intrinsic::amdgcn_image_sample_cl_o_2d, IMAGE_SAMPLE_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 403
  { Intrinsic::amdgcn_image_sample_cl_o_2darray, IMAGE_SAMPLE_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 404
  { Intrinsic::amdgcn_image_sample_cl_o_3d, IMAGE_SAMPLE_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 405
  { Intrinsic::amdgcn_image_sample_cl_o_cube, IMAGE_SAMPLE_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 406
  { Intrinsic::amdgcn_image_sample_cube, IMAGE_SAMPLE, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 407
  { Intrinsic::amdgcn_image_sample_d_1d, IMAGE_SAMPLE_D, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x2 }, // 408
  { Intrinsic::amdgcn_image_sample_d_1darray, IMAGE_SAMPLE_D, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 409
  { Intrinsic::amdgcn_image_sample_d_2d, IMAGE_SAMPLE_D, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 410
  { Intrinsic::amdgcn_image_sample_d_2darray, IMAGE_SAMPLE_D, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 411
  { Intrinsic::amdgcn_image_sample_d_3d, IMAGE_SAMPLE_D, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 412
  { Intrinsic::amdgcn_image_sample_d_cl_1d, IMAGE_SAMPLE_D_CL, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 413
  { Intrinsic::amdgcn_image_sample_d_cl_1darray, IMAGE_SAMPLE_D_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 414
  { Intrinsic::amdgcn_image_sample_d_cl_2d, IMAGE_SAMPLE_D_CL, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 415
  { Intrinsic::amdgcn_image_sample_d_cl_2darray, IMAGE_SAMPLE_D_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 416
  { Intrinsic::amdgcn_image_sample_d_cl_3d, IMAGE_SAMPLE_D_CL, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 417
  { Intrinsic::amdgcn_image_sample_d_cl_cube, IMAGE_SAMPLE_D_CL, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 418
  { Intrinsic::amdgcn_image_sample_d_cl_o_1d, IMAGE_SAMPLE_D_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 419
  { Intrinsic::amdgcn_image_sample_d_cl_o_1darray, IMAGE_SAMPLE_D_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 420
  { Intrinsic::amdgcn_image_sample_d_cl_o_2d, IMAGE_SAMPLE_D_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 421
  { Intrinsic::amdgcn_image_sample_d_cl_o_2darray, IMAGE_SAMPLE_D_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 422
  { Intrinsic::amdgcn_image_sample_d_cl_o_3d, IMAGE_SAMPLE_D_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 423
  { Intrinsic::amdgcn_image_sample_d_cl_o_cube, IMAGE_SAMPLE_D_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 424
  { Intrinsic::amdgcn_image_sample_d_cube, IMAGE_SAMPLE_D, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 425
  { Intrinsic::amdgcn_image_sample_d_o_1d, IMAGE_SAMPLE_D_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 426
  { Intrinsic::amdgcn_image_sample_d_o_1darray, IMAGE_SAMPLE_D_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 427
  { Intrinsic::amdgcn_image_sample_d_o_2d, IMAGE_SAMPLE_D_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 428
  { Intrinsic::amdgcn_image_sample_d_o_2darray, IMAGE_SAMPLE_D_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 429
  { Intrinsic::amdgcn_image_sample_d_o_3d, IMAGE_SAMPLE_D_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 430
  { Intrinsic::amdgcn_image_sample_d_o_cube, IMAGE_SAMPLE_D_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 431
  { Intrinsic::amdgcn_image_sample_l_1d, IMAGE_SAMPLE_L, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 432
  { Intrinsic::amdgcn_image_sample_l_1darray, IMAGE_SAMPLE_L, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 433
  { Intrinsic::amdgcn_image_sample_l_2d, IMAGE_SAMPLE_L, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 434
  { Intrinsic::amdgcn_image_sample_l_2darray, IMAGE_SAMPLE_L, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 435
  { Intrinsic::amdgcn_image_sample_l_3d, IMAGE_SAMPLE_L, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 436
  { Intrinsic::amdgcn_image_sample_l_cube, IMAGE_SAMPLE_L, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 437
  { Intrinsic::amdgcn_image_sample_l_o_1d, IMAGE_SAMPLE_L_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 438
  { Intrinsic::amdgcn_image_sample_l_o_1darray, IMAGE_SAMPLE_L_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 439
  { Intrinsic::amdgcn_image_sample_l_o_2d, IMAGE_SAMPLE_L_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 440
  { Intrinsic::amdgcn_image_sample_l_o_2darray, IMAGE_SAMPLE_L_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 441
  { Intrinsic::amdgcn_image_sample_l_o_3d, IMAGE_SAMPLE_L_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 442
  { Intrinsic::amdgcn_image_sample_l_o_cube, IMAGE_SAMPLE_L_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 443
  { Intrinsic::amdgcn_image_sample_lz_1d, IMAGE_SAMPLE_LZ, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 444
  { Intrinsic::amdgcn_image_sample_lz_1darray, IMAGE_SAMPLE_LZ, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 445
  { Intrinsic::amdgcn_image_sample_lz_2d, IMAGE_SAMPLE_LZ, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 446
  { Intrinsic::amdgcn_image_sample_lz_2darray, IMAGE_SAMPLE_LZ, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 447
  { Intrinsic::amdgcn_image_sample_lz_3d, IMAGE_SAMPLE_LZ, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 448
  { Intrinsic::amdgcn_image_sample_lz_cube, IMAGE_SAMPLE_LZ, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 449
  { Intrinsic::amdgcn_image_sample_lz_o_1d, IMAGE_SAMPLE_LZ_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 450
  { Intrinsic::amdgcn_image_sample_lz_o_1darray, IMAGE_SAMPLE_LZ_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 451
  { Intrinsic::amdgcn_image_sample_lz_o_2d, IMAGE_SAMPLE_LZ_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 452
  { Intrinsic::amdgcn_image_sample_lz_o_2darray, IMAGE_SAMPLE_LZ_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 453
  { Intrinsic::amdgcn_image_sample_lz_o_3d, IMAGE_SAMPLE_LZ_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 454
  { Intrinsic::amdgcn_image_sample_lz_o_cube, IMAGE_SAMPLE_LZ_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 455
  { Intrinsic::amdgcn_image_sample_o_1d, IMAGE_SAMPLE_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 456
  { Intrinsic::amdgcn_image_sample_o_1darray, IMAGE_SAMPLE_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 457
  { Intrinsic::amdgcn_image_sample_o_2d, IMAGE_SAMPLE_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 458
  { Intrinsic::amdgcn_image_sample_o_2darray, IMAGE_SAMPLE_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 459
  { Intrinsic::amdgcn_image_sample_o_3d, IMAGE_SAMPLE_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 460
  { Intrinsic::amdgcn_image_sample_o_cube, IMAGE_SAMPLE_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 461
  { Intrinsic::amdgcn_image_store_1d, IMAGE_STORE, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x6, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 462
  { Intrinsic::amdgcn_image_store_1darray, IMAGE_STORE, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x2, 0x7, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 463
  { Intrinsic::amdgcn_image_store_2d, IMAGE_STORE, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x2, 0x7, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 464
  { Intrinsic::amdgcn_image_store_2darray, IMAGE_STORE, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 465
  { Intrinsic::amdgcn_image_store_2darraymsaa, IMAGE_STORE, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x9, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 466
  { Intrinsic::amdgcn_image_store_2dmsaa, IMAGE_STORE, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 467
  { Intrinsic::amdgcn_image_store_3d, IMAGE_STORE, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 468
  { Intrinsic::amdgcn_image_store_cube, IMAGE_STORE, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 469
  { Intrinsic::amdgcn_image_store_mip_1d, IMAGE_STORE_MIP, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x2, 0x7, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 470
  { Intrinsic::amdgcn_image_store_mip_1darray, IMAGE_STORE_MIP, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 471
  { Intrinsic::amdgcn_image_store_mip_2d, IMAGE_STORE_MIP, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 472
  { Intrinsic::amdgcn_image_store_mip_2darray, IMAGE_STORE_MIP, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x9, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 473
  { Intrinsic::amdgcn_image_store_mip_3d, IMAGE_STORE_MIP, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x9, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 474
  { Intrinsic::amdgcn_image_store_mip_cube, IMAGE_STORE_MIP, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x9, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 475
 };

const ImageDimIntrinsicInfo *getImageDimIntrinsicInfo(unsigned Intr) {
  if ((Intr < Intrinsic::amdgcn_image_atomic_add_1d) ||
      (Intr > Intrinsic::amdgcn_image_store_mip_cube))
    return nullptr;

  struct KeyType {
    unsigned Intr;
  };
  KeyType Key = {Intr};
  auto Table = makeArrayRef(ImageDimIntrinsicTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const ImageDimIntrinsicInfo &LHS, const KeyType &RHS) {
      if (LHS.Intr < RHS.Intr)
        return true;
      if (LHS.Intr > RHS.Intr)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Intr != Idx->Intr)
    return nullptr;
  return &*Idx;
}

const ImageDimIntrinsicInfo *getImageDimIntrinsicByBaseOpcode(unsigned BaseOpcode, unsigned Dim) {
  struct IndexType {
    unsigned BaseOpcode;
    unsigned Dim;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { IMAGE_ATOMIC_ADD, AMDGPUDim1D, 0 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim1DArray, 1 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim2D, 2 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim2DArray, 3 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim2DArrayMsaa, 4 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim2DMsaa, 5 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim3D, 6 },
    { IMAGE_ATOMIC_ADD, AMDGPUDimCube, 7 },
    { IMAGE_ATOMIC_AND, AMDGPUDim1D, 8 },
    { IMAGE_ATOMIC_AND, AMDGPUDim1DArray, 9 },
    { IMAGE_ATOMIC_AND, AMDGPUDim2D, 10 },
    { IMAGE_ATOMIC_AND, AMDGPUDim2DArray, 11 },
    { IMAGE_ATOMIC_AND, AMDGPUDim2DArrayMsaa, 12 },
    { IMAGE_ATOMIC_AND, AMDGPUDim2DMsaa, 13 },
    { IMAGE_ATOMIC_AND, AMDGPUDim3D, 14 },
    { IMAGE_ATOMIC_AND, AMDGPUDimCube, 15 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1D, 16 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1DArray, 17 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2D, 18 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArray, 19 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArrayMsaa, 20 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DMsaa, 21 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim3D, 22 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDimCube, 23 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim1D, 24 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim1DArray, 25 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim2D, 26 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim2DArray, 27 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim2DArrayMsaa, 28 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim2DMsaa, 29 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim3D, 30 },
    { IMAGE_ATOMIC_DEC, AMDGPUDimCube, 31 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim1D, 32 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim1DArray, 33 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim2D, 34 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim2DArray, 35 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim2DArrayMsaa, 36 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim2DMsaa, 37 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim3D, 38 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDimCube, 39 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim1D, 40 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim1DArray, 41 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim2D, 42 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim2DArray, 43 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim2DArrayMsaa, 44 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim2DMsaa, 45 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim3D, 46 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDimCube, 47 },
    { IMAGE_ATOMIC_INC, AMDGPUDim1D, 48 },
    { IMAGE_ATOMIC_INC, AMDGPUDim1DArray, 49 },
    { IMAGE_ATOMIC_INC, AMDGPUDim2D, 50 },
    { IMAGE_ATOMIC_INC, AMDGPUDim2DArray, 51 },
    { IMAGE_ATOMIC_INC, AMDGPUDim2DArrayMsaa, 52 },
    { IMAGE_ATOMIC_INC, AMDGPUDim2DMsaa, 53 },
    { IMAGE_ATOMIC_INC, AMDGPUDim3D, 54 },
    { IMAGE_ATOMIC_INC, AMDGPUDimCube, 55 },
    { IMAGE_ATOMIC_OR, AMDGPUDim1D, 56 },
    { IMAGE_ATOMIC_OR, AMDGPUDim1DArray, 57 },
    { IMAGE_ATOMIC_OR, AMDGPUDim2D, 58 },
    { IMAGE_ATOMIC_OR, AMDGPUDim2DArray, 59 },
    { IMAGE_ATOMIC_OR, AMDGPUDim2DArrayMsaa, 60 },
    { IMAGE_ATOMIC_OR, AMDGPUDim2DMsaa, 61 },
    { IMAGE_ATOMIC_OR, AMDGPUDim3D, 62 },
    { IMAGE_ATOMIC_OR, AMDGPUDimCube, 63 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim1D, 64 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim1DArray, 65 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim2D, 66 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim2DArray, 67 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim2DArrayMsaa, 68 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim2DMsaa, 69 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim3D, 70 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDimCube, 71 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim1D, 72 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim1DArray, 73 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim2D, 74 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim2DArray, 75 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim2DArrayMsaa, 76 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim2DMsaa, 77 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim3D, 78 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDimCube, 79 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim1D, 80 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim1DArray, 81 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim2D, 82 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim2DArray, 83 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim2DArrayMsaa, 84 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim2DMsaa, 85 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim3D, 86 },
    { IMAGE_ATOMIC_SUB, AMDGPUDimCube, 87 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim1D, 88 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim1DArray, 89 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim2D, 90 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim2DArray, 91 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim2DArrayMsaa, 92 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim2DMsaa, 93 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim3D, 94 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDimCube, 95 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim1D, 96 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim1DArray, 97 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim2D, 98 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim2DArray, 99 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim2DArrayMsaa, 100 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim2DMsaa, 101 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim3D, 102 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDimCube, 103 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim1D, 104 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim1DArray, 105 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim2D, 106 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim2DArray, 107 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim2DArrayMsaa, 108 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim2DMsaa, 109 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim3D, 110 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDimCube, 111 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim1D, 112 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim1DArray, 113 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim2D, 114 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim2DArray, 115 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim2DArrayMsaa, 116 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim2DMsaa, 117 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim3D, 118 },
    { IMAGE_ATOMIC_XOR, AMDGPUDimCube, 119 },
    { IMAGE_GATHER4, AMDGPUDim2D, 120 },
    { IMAGE_GATHER4, AMDGPUDim2DArray, 121 },
    { IMAGE_GATHER4, AMDGPUDimCube, 176 },
    { IMAGE_GATHER4_B, AMDGPUDim2D, 122 },
    { IMAGE_GATHER4_B, AMDGPUDim2DArray, 123 },
    { IMAGE_GATHER4_B, AMDGPUDimCube, 130 },
    { IMAGE_GATHER4_B_CL, AMDGPUDim2D, 124 },
    { IMAGE_GATHER4_B_CL, AMDGPUDim2DArray, 125 },
    { IMAGE_GATHER4_B_CL, AMDGPUDimCube, 126 },
    { IMAGE_GATHER4_B_CL_O, AMDGPUDim2D, 127 },
    { IMAGE_GATHER4_B_CL_O, AMDGPUDim2DArray, 128 },
    { IMAGE_GATHER4_B_CL_O, AMDGPUDimCube, 129 },
    { IMAGE_GATHER4_B_O, AMDGPUDim2D, 131 },
    { IMAGE_GATHER4_B_O, AMDGPUDim2DArray, 132 },
    { IMAGE_GATHER4_B_O, AMDGPUDimCube, 133 },
    { IMAGE_GATHER4_C, AMDGPUDim2D, 134 },
    { IMAGE_GATHER4_C, AMDGPUDim2DArray, 135 },
    { IMAGE_GATHER4_C, AMDGPUDimCube, 154 },
    { IMAGE_GATHER4_CL, AMDGPUDim2D, 170 },
    { IMAGE_GATHER4_CL, AMDGPUDim2DArray, 171 },
    { IMAGE_GATHER4_CL, AMDGPUDimCube, 172 },
    { IMAGE_GATHER4_CL_O, AMDGPUDim2D, 173 },
    { IMAGE_GATHER4_CL_O, AMDGPUDim2DArray, 174 },
    { IMAGE_GATHER4_CL_O, AMDGPUDimCube, 175 },
    { IMAGE_GATHER4_C_B, AMDGPUDim2D, 136 },
    { IMAGE_GATHER4_C_B, AMDGPUDim2DArray, 137 },
    { IMAGE_GATHER4_C_B, AMDGPUDimCube, 144 },
    { IMAGE_GATHER4_C_B_CL, AMDGPUDim2D, 138 },
    { IMAGE_GATHER4_C_B_CL, AMDGPUDim2DArray, 139 },
    { IMAGE_GATHER4_C_B_CL, AMDGPUDimCube, 140 },
    { IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2D, 141 },
    { IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2DArray, 142 },
    { IMAGE_GATHER4_C_B_CL_O, AMDGPUDimCube, 143 },
    { IMAGE_GATHER4_C_B_O, AMDGPUDim2D, 145 },
    { IMAGE_GATHER4_C_B_O, AMDGPUDim2DArray, 146 },
    { IMAGE_GATHER4_C_B_O, AMDGPUDimCube, 147 },
    { IMAGE_GATHER4_C_CL, AMDGPUDim2D, 148 },
    { IMAGE_GATHER4_C_CL, AMDGPUDim2DArray, 149 },
    { IMAGE_GATHER4_C_CL, AMDGPUDimCube, 150 },
    { IMAGE_GATHER4_C_CL_O, AMDGPUDim2D, 151 },
    { IMAGE_GATHER4_C_CL_O, AMDGPUDim2DArray, 152 },
    { IMAGE_GATHER4_C_CL_O, AMDGPUDimCube, 153 },
    { IMAGE_GATHER4_C_L, AMDGPUDim2D, 155 },
    { IMAGE_GATHER4_C_L, AMDGPUDim2DArray, 156 },
    { IMAGE_GATHER4_C_L, AMDGPUDimCube, 157 },
    { IMAGE_GATHER4_C_LZ, AMDGPUDim2D, 161 },
    { IMAGE_GATHER4_C_LZ, AMDGPUDim2DArray, 162 },
    { IMAGE_GATHER4_C_LZ, AMDGPUDimCube, 163 },
    { IMAGE_GATHER4_C_LZ_O, AMDGPUDim2D, 164 },
    { IMAGE_GATHER4_C_LZ_O, AMDGPUDim2DArray, 165 },
    { IMAGE_GATHER4_C_LZ_O, AMDGPUDimCube, 166 },
    { IMAGE_GATHER4_C_L_O, AMDGPUDim2D, 158 },
    { IMAGE_GATHER4_C_L_O, AMDGPUDim2DArray, 159 },
    { IMAGE_GATHER4_C_L_O, AMDGPUDimCube, 160 },
    { IMAGE_GATHER4_C_O, AMDGPUDim2D, 167 },
    { IMAGE_GATHER4_C_O, AMDGPUDim2DArray, 168 },
    { IMAGE_GATHER4_C_O, AMDGPUDimCube, 169 },
    { IMAGE_GATHER4_L, AMDGPUDim2D, 177 },
    { IMAGE_GATHER4_L, AMDGPUDim2DArray, 178 },
    { IMAGE_GATHER4_L, AMDGPUDimCube, 179 },
    { IMAGE_GATHER4_LZ, AMDGPUDim2D, 183 },
    { IMAGE_GATHER4_LZ, AMDGPUDim2DArray, 184 },
    { IMAGE_GATHER4_LZ, AMDGPUDimCube, 185 },
    { IMAGE_GATHER4_LZ_O, AMDGPUDim2D, 186 },
    { IMAGE_GATHER4_LZ_O, AMDGPUDim2DArray, 187 },
    { IMAGE_GATHER4_LZ_O, AMDGPUDimCube, 188 },
    { IMAGE_GATHER4_L_O, AMDGPUDim2D, 180 },
    { IMAGE_GATHER4_L_O, AMDGPUDim2DArray, 181 },
    { IMAGE_GATHER4_L_O, AMDGPUDimCube, 182 },
    { IMAGE_GATHER4_O, AMDGPUDim2D, 189 },
    { IMAGE_GATHER4_O, AMDGPUDim2DArray, 190 },
    { IMAGE_GATHER4_O, AMDGPUDimCube, 191 },
    { IMAGE_GET_LOD, AMDGPUDim1D, 192 },
    { IMAGE_GET_LOD, AMDGPUDim1DArray, 193 },
    { IMAGE_GET_LOD, AMDGPUDim2D, 194 },
    { IMAGE_GET_LOD, AMDGPUDim2DArray, 195 },
    { IMAGE_GET_LOD, AMDGPUDim3D, 196 },
    { IMAGE_GET_LOD, AMDGPUDimCube, 197 },
    { IMAGE_GET_RESINFO, AMDGPUDim1D, 198 },
    { IMAGE_GET_RESINFO, AMDGPUDim1DArray, 199 },
    { IMAGE_GET_RESINFO, AMDGPUDim2D, 200 },
    { IMAGE_GET_RESINFO, AMDGPUDim2DArray, 201 },
    { IMAGE_GET_RESINFO, AMDGPUDim2DArrayMsaa, 202 },
    { IMAGE_GET_RESINFO, AMDGPUDim2DMsaa, 203 },
    { IMAGE_GET_RESINFO, AMDGPUDim3D, 204 },
    { IMAGE_GET_RESINFO, AMDGPUDimCube, 205 },
    { IMAGE_LOAD, AMDGPUDim1D, 206 },
    { IMAGE_LOAD, AMDGPUDim1DArray, 207 },
    { IMAGE_LOAD, AMDGPUDim2D, 208 },
    { IMAGE_LOAD, AMDGPUDim2DArray, 209 },
    { IMAGE_LOAD, AMDGPUDim2DArrayMsaa, 210 },
    { IMAGE_LOAD, AMDGPUDim2DMsaa, 211 },
    { IMAGE_LOAD, AMDGPUDim3D, 212 },
    { IMAGE_LOAD, AMDGPUDimCube, 213 },
    { IMAGE_LOAD_MIP, AMDGPUDim1D, 214 },
    { IMAGE_LOAD_MIP, AMDGPUDim1DArray, 215 },
    { IMAGE_LOAD_MIP, AMDGPUDim2D, 216 },
    { IMAGE_LOAD_MIP, AMDGPUDim2DArray, 217 },
    { IMAGE_LOAD_MIP, AMDGPUDim3D, 218 },
    { IMAGE_LOAD_MIP, AMDGPUDimCube, 219 },
    { IMAGE_MSAA_LOAD_X, AMDGPUDim2DArrayMsaa, 220 },
    { IMAGE_MSAA_LOAD_X, AMDGPUDim2DMsaa, 221 },
    { IMAGE_SAMPLE, AMDGPUDim1D, 222 },
    { IMAGE_SAMPLE, AMDGPUDim1DArray, 223 },
    { IMAGE_SAMPLE, AMDGPUDim2D, 224 },
    { IMAGE_SAMPLE, AMDGPUDim2DArray, 225 },
    { IMAGE_SAMPLE, AMDGPUDim3D, 226 },
    { IMAGE_SAMPLE, AMDGPUDimCube, 407 },
    { IMAGE_SAMPLE_B, AMDGPUDim1D, 227 },
    { IMAGE_SAMPLE_B, AMDGPUDim1DArray, 228 },
    { IMAGE_SAMPLE_B, AMDGPUDim2D, 229 },
    { IMAGE_SAMPLE_B, AMDGPUDim2DArray, 230 },
    { IMAGE_SAMPLE_B, AMDGPUDim3D, 231 },
    { IMAGE_SAMPLE_B, AMDGPUDimCube, 244 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim1D, 232 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim1DArray, 233 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim2D, 234 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim2DArray, 235 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim3D, 236 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDimCube, 237 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim1D, 238 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim1DArray, 239 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim2D, 240 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim2DArray, 241 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim3D, 242 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDimCube, 243 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim1D, 245 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim1DArray, 246 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim2D, 247 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim2DArray, 248 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim3D, 249 },
    { IMAGE_SAMPLE_B_O, AMDGPUDimCube, 250 },
    { IMAGE_SAMPLE_C, AMDGPUDim1D, 251 },
    { IMAGE_SAMPLE_C, AMDGPUDim1DArray, 252 },
    { IMAGE_SAMPLE_C, AMDGPUDim2D, 253 },
    { IMAGE_SAMPLE_C, AMDGPUDim2DArray, 254 },
    { IMAGE_SAMPLE_C, AMDGPUDim3D, 255 },
    { IMAGE_SAMPLE_C, AMDGPUDimCube, 316 },
    { IMAGE_SAMPLE_CD, AMDGPUDim1D, 371 },
    { IMAGE_SAMPLE_CD, AMDGPUDim1DArray, 372 },
    { IMAGE_SAMPLE_CD, AMDGPUDim2D, 373 },
    { IMAGE_SAMPLE_CD, AMDGPUDim2DArray, 374 },
    { IMAGE_SAMPLE_CD, AMDGPUDim3D, 375 },
    { IMAGE_SAMPLE_CD, AMDGPUDimCube, 388 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim1D, 376 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim1DArray, 377 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim2D, 378 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim2DArray, 379 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim3D, 380 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDimCube, 381 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1D, 382 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1DArray, 383 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2D, 384 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2DArray, 385 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim3D, 386 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDimCube, 387 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim1D, 389 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim1DArray, 390 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim2D, 391 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim2DArray, 392 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim3D, 393 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDimCube, 394 },
    { IMAGE_SAMPLE_CL, AMDGPUDim1D, 395 },
    { IMAGE_SAMPLE_CL, AMDGPUDim1DArray, 396 },
    { IMAGE_SAMPLE_CL, AMDGPUDim2D, 397 },
    { IMAGE_SAMPLE_CL, AMDGPUDim2DArray, 398 },
    { IMAGE_SAMPLE_CL, AMDGPUDim3D, 399 },
    { IMAGE_SAMPLE_CL, AMDGPUDimCube, 400 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim1D, 401 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim1DArray, 402 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim2D, 403 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim2DArray, 404 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim3D, 405 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDimCube, 406 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim1D, 256 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim1DArray, 257 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim2D, 258 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim2DArray, 259 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim3D, 260 },
    { IMAGE_SAMPLE_C_B, AMDGPUDimCube, 273 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim1D, 261 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim1DArray, 262 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim2D, 263 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim2DArray, 264 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim3D, 265 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDimCube, 266 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1D, 267 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1DArray, 268 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2D, 269 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2DArray, 270 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim3D, 271 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDimCube, 272 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim1D, 274 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim1DArray, 275 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim2D, 276 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim2DArray, 277 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim3D, 278 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDimCube, 279 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim1D, 280 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim1DArray, 281 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim2D, 282 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim2DArray, 283 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim3D, 284 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDimCube, 297 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1D, 285 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1DArray, 286 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2D, 287 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2DArray, 288 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim3D, 289 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDimCube, 290 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1D, 291 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1DArray, 292 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2D, 293 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2DArray, 294 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim3D, 295 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDimCube, 296 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim1D, 298 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim1DArray, 299 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim2D, 300 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim2DArray, 301 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim3D, 302 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDimCube, 303 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim1D, 304 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim1DArray, 305 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim2D, 306 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim2DArray, 307 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim3D, 308 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDimCube, 309 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim1D, 310 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim1DArray, 311 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim2D, 312 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim2DArray, 313 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim3D, 314 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDimCube, 315 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim1D, 317 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim1DArray, 318 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim2D, 319 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim2DArray, 320 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim3D, 321 },
    { IMAGE_SAMPLE_C_D, AMDGPUDimCube, 334 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim1D, 322 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim1DArray, 323 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim2D, 324 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim2DArray, 325 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim3D, 326 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDimCube, 327 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1D, 328 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1DArray, 329 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2D, 330 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2DArray, 331 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim3D, 332 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDimCube, 333 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim1D, 335 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim1DArray, 336 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim2D, 337 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim2DArray, 338 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim3D, 339 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDimCube, 340 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim1D, 341 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim1DArray, 342 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim2D, 343 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim2DArray, 344 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim3D, 345 },
    { IMAGE_SAMPLE_C_L, AMDGPUDimCube, 346 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim1D, 353 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim1DArray, 354 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim2D, 355 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim2DArray, 356 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim3D, 357 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDimCube, 358 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1D, 359 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1DArray, 360 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2D, 361 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2DArray, 362 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim3D, 363 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDimCube, 364 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim1D, 347 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim1DArray, 348 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim2D, 349 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim2DArray, 350 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim3D, 351 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDimCube, 352 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim1D, 365 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim1DArray, 366 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim2D, 367 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim2DArray, 368 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim3D, 369 },
    { IMAGE_SAMPLE_C_O, AMDGPUDimCube, 370 },
    { IMAGE_SAMPLE_D, AMDGPUDim1D, 408 },
    { IMAGE_SAMPLE_D, AMDGPUDim1DArray, 409 },
    { IMAGE_SAMPLE_D, AMDGPUDim2D, 410 },
    { IMAGE_SAMPLE_D, AMDGPUDim2DArray, 411 },
    { IMAGE_SAMPLE_D, AMDGPUDim3D, 412 },
    { IMAGE_SAMPLE_D, AMDGPUDimCube, 425 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim1D, 413 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim1DArray, 414 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim2D, 415 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim2DArray, 416 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim3D, 417 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDimCube, 418 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim1D, 419 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim1DArray, 420 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim2D, 421 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim2DArray, 422 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim3D, 423 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDimCube, 424 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim1D, 426 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim1DArray, 427 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim2D, 428 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim2DArray, 429 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim3D, 430 },
    { IMAGE_SAMPLE_D_O, AMDGPUDimCube, 431 },
    { IMAGE_SAMPLE_L, AMDGPUDim1D, 432 },
    { IMAGE_SAMPLE_L, AMDGPUDim1DArray, 433 },
    { IMAGE_SAMPLE_L, AMDGPUDim2D, 434 },
    { IMAGE_SAMPLE_L, AMDGPUDim2DArray, 435 },
    { IMAGE_SAMPLE_L, AMDGPUDim3D, 436 },
    { IMAGE_SAMPLE_L, AMDGPUDimCube, 437 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim1D, 444 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim1DArray, 445 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim2D, 446 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim2DArray, 447 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim3D, 448 },
    { IMAGE_SAMPLE_LZ, AMDGPUDimCube, 449 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim1D, 450 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim1DArray, 451 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim2D, 452 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim2DArray, 453 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim3D, 454 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDimCube, 455 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim1D, 438 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim1DArray, 439 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim2D, 440 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim2DArray, 441 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim3D, 442 },
    { IMAGE_SAMPLE_L_O, AMDGPUDimCube, 443 },
    { IMAGE_SAMPLE_O, AMDGPUDim1D, 456 },
    { IMAGE_SAMPLE_O, AMDGPUDim1DArray, 457 },
    { IMAGE_SAMPLE_O, AMDGPUDim2D, 458 },
    { IMAGE_SAMPLE_O, AMDGPUDim2DArray, 459 },
    { IMAGE_SAMPLE_O, AMDGPUDim3D, 460 },
    { IMAGE_SAMPLE_O, AMDGPUDimCube, 461 },
    { IMAGE_STORE, AMDGPUDim1D, 462 },
    { IMAGE_STORE, AMDGPUDim1DArray, 463 },
    { IMAGE_STORE, AMDGPUDim2D, 464 },
    { IMAGE_STORE, AMDGPUDim2DArray, 465 },
    { IMAGE_STORE, AMDGPUDim2DArrayMsaa, 466 },
    { IMAGE_STORE, AMDGPUDim2DMsaa, 467 },
    { IMAGE_STORE, AMDGPUDim3D, 468 },
    { IMAGE_STORE, AMDGPUDimCube, 469 },
    { IMAGE_STORE_MIP, AMDGPUDim1D, 470 },
    { IMAGE_STORE_MIP, AMDGPUDim1DArray, 471 },
    { IMAGE_STORE_MIP, AMDGPUDim2D, 472 },
    { IMAGE_STORE_MIP, AMDGPUDim2DArray, 473 },
    { IMAGE_STORE_MIP, AMDGPUDim3D, 474 },
    { IMAGE_STORE_MIP, AMDGPUDimCube, 475 },
  };

  struct KeyType {
    unsigned BaseOpcode;
    unsigned Dim;
  };
  KeyType Key = {BaseOpcode, Dim};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if ((unsigned)LHS.BaseOpcode < (unsigned)RHS.BaseOpcode)
        return true;
      if ((unsigned)LHS.BaseOpcode > (unsigned)RHS.BaseOpcode)
        return false;
      if ((unsigned)LHS.Dim < (unsigned)RHS.Dim)
        return true;
      if ((unsigned)LHS.Dim > (unsigned)RHS.Dim)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.BaseOpcode != Idx->BaseOpcode ||
      Key.Dim != Idx->Dim)
    return nullptr;
  return &ImageDimIntrinsicTable[Idx->_index];
}
#endif

#ifdef GET_MIMGBaseOpcodesTable_DECL
const MIMGBaseOpcodeInfo *getMIMGBaseOpcodeInfo(unsigned BaseOpcode);
#endif

#ifdef GET_MIMGBaseOpcodesTable_IMPL
constexpr MIMGBaseOpcodeInfo MIMGBaseOpcodesTable[] = {
  { IMAGE_ATOMIC_ADD, false, true, false, false, false, 0x0, false, false, true, false, false, false, false }, // 0
  { IMAGE_ATOMIC_AND, false, true, false, false, false, 0x0, false, false, true, false, false, false, false }, // 1
  { IMAGE_ATOMIC_CMPSWAP, false, true, true, false, false, 0x0, false, false, true, false, false, false, false }, // 2
  { IMAGE_ATOMIC_DEC, false, true, false, false, false, 0x0, false, false, true, false, false, false, false }, // 3
  { IMAGE_ATOMIC_FCMPSWAP, false, true, true, false, false, 0x0, false, false, true, false, false, false, false }, // 4
  { IMAGE_ATOMIC_FMAX, false, true, false, false, false, 0x0, false, false, true, false, false, false, false }, // 5
  { IMAGE_ATOMIC_FMIN, false, true, false, false, false, 0x0, false, false, true, false, false, false, false }, // 6
  { IMAGE_ATOMIC_INC, false, true, false, false, false, 0x0, false, false, true, false, false, false, false }, // 7
  { IMAGE_ATOMIC_OR, false, true, false, false, false, 0x0, false, false, true, false, false, false, false }, // 8
  { IMAGE_ATOMIC_RSUB, false, true, false, false, false, 0x0, false, false, true, false, false, false, false }, // 9
  { IMAGE_ATOMIC_SMAX, false, true, false, false, false, 0x0, false, false, true, false, false, false, false }, // 10
  { IMAGE_ATOMIC_SMIN, false, true, false, false, false, 0x0, false, false, true, false, false, false, false }, // 11
  { IMAGE_ATOMIC_SUB, false, true, false, false, false, 0x0, false, false, true, false, false, false, false }, // 12
  { IMAGE_ATOMIC_SWAP, false, true, false, false, false, 0x0, false, false, true, false, false, false, false }, // 13
  { IMAGE_ATOMIC_UMAX, false, true, false, false, false, 0x0, false, false, true, false, false, false, false }, // 14
  { IMAGE_ATOMIC_UMIN, false, true, false, false, false, 0x0, false, false, true, false, false, false, false }, // 15
  { IMAGE_ATOMIC_XOR, false, true, false, false, false, 0x0, false, false, true, false, false, false, false }, // 16
  { IMAGE_BVH64_INTERSECT_RAY, false, false, false, false, false, 0x0, false, false, true, false, false, false, true }, // 17
  { IMAGE_BVH64_INTERSECT_RAY_a16, false, false, false, false, false, 0x0, false, false, true, false, false, false, true }, // 18
  { IMAGE_BVH_INTERSECT_RAY, false, false, false, false, false, 0x0, false, false, true, false, false, false, true }, // 19
  { IMAGE_BVH_INTERSECT_RAY_a16, false, false, false, false, false, 0x0, false, false, true, false, false, false, true }, // 20
  { IMAGE_GATHER4, false, false, false, true, true, 0x0, false, false, true, false, true, false, false }, // 21
  { IMAGE_GATHER4_B, false, false, false, true, true, 0x1, false, false, true, false, true, false, false }, // 22
  { IMAGE_GATHER4_B_CL, false, false, false, true, true, 0x1, false, false, true, true, true, false, false }, // 23
  { IMAGE_GATHER4_B_CL_O, false, false, false, true, true, 0x2, false, false, true, true, true, false, false }, // 24
  { IMAGE_GATHER4_B_O, false, false, false, true, true, 0x2, false, false, true, false, true, false, false }, // 25
  { IMAGE_GATHER4_C, false, false, false, true, true, 0x1, false, false, true, false, true, false, false }, // 26
  { IMAGE_GATHER4_CL, false, false, false, true, true, 0x0, false, false, true, true, true, false, false }, // 27
  { IMAGE_GATHER4_CL_O, false, false, false, true, true, 0x1, false, false, true, true, true, false, false }, // 28
  { IMAGE_GATHER4_C_B, false, false, false, true, true, 0x2, false, false, true, false, true, false, false }, // 29
  { IMAGE_GATHER4_C_B_CL, false, false, false, true, true, 0x2, false, false, true, true, true, false, false }, // 30
  { IMAGE_GATHER4_C_B_CL_O, false, false, false, true, true, 0x3, false, false, true, true, true, false, false }, // 31
  { IMAGE_GATHER4_C_B_O, false, false, false, true, true, 0x3, false, false, true, false, true, false, false }, // 32
  { IMAGE_GATHER4_C_CL, false, false, false, true, true, 0x1, false, false, true, true, true, false, false }, // 33
  { IMAGE_GATHER4_C_CL_O, false, false, false, true, true, 0x2, false, false, true, true, true, false, false }, // 34
  { IMAGE_GATHER4_C_L, false, false, false, true, true, 0x1, false, false, true, true, true, false, false }, // 35
  { IMAGE_GATHER4_C_LZ, false, false, false, true, true, 0x1, false, false, true, false, true, false, false }, // 36
  { IMAGE_GATHER4_C_LZ_O, false, false, false, true, true, 0x2, false, false, true, false, true, false, false }, // 37
  { IMAGE_GATHER4_C_L_O, false, false, false, true, true, 0x2, false, false, true, true, true, false, false }, // 38
  { IMAGE_GATHER4_C_O, false, false, false, true, true, 0x2, false, false, true, false, true, false, false }, // 39
  { IMAGE_GATHER4_L, false, false, false, true, true, 0x0, false, false, true, true, true, false, false }, // 40
  { IMAGE_GATHER4_LZ, false, false, false, true, true, 0x0, false, false, true, false, true, false, false }, // 41
  { IMAGE_GATHER4_LZ_O, false, false, false, true, true, 0x1, false, false, true, false, true, false, false }, // 42
  { IMAGE_GATHER4_L_O, false, false, false, true, true, 0x1, false, false, true, true, true, false, false }, // 43
  { IMAGE_GATHER4_O, false, false, false, true, true, 0x1, false, false, true, false, true, false, false }, // 44
  { IMAGE_GET_LOD, false, false, false, true, false, 0x0, false, false, true, false, false, false, false }, // 45
  { IMAGE_GET_RESINFO, false, false, false, false, false, 0x0, false, false, false, true, false, false, false }, // 46
  { IMAGE_LOAD, false, false, false, false, false, 0x0, false, false, true, false, true, false, false }, // 47
  { IMAGE_LOAD_MIP, false, false, false, false, false, 0x0, false, false, true, true, true, false, false }, // 48
  { IMAGE_LOAD_MIP_PCK, false, false, false, false, false, 0x0, false, false, true, true, false, false, false }, // 49
  { IMAGE_LOAD_MIP_PCK_SGN, false, false, false, false, false, 0x0, false, false, true, true, false, false, false }, // 50
  { IMAGE_LOAD_PCK, false, false, false, false, false, 0x0, false, false, true, false, false, false, false }, // 51
  { IMAGE_LOAD_PCK_SGN, false, false, false, false, false, 0x0, false, false, true, false, false, false, false }, // 52
  { IMAGE_MSAA_LOAD_X, false, false, false, false, false, 0x0, false, false, true, false, true, true, false }, // 53
  { IMAGE_SAMPLE, false, false, false, true, false, 0x0, false, false, true, false, true, false, false }, // 54
  { IMAGE_SAMPLE_B, false, false, false, true, false, 0x1, false, false, true, false, true, false, false }, // 55
  { IMAGE_SAMPLE_B_CL, false, false, false, true, false, 0x1, false, false, true, true, true, false, false }, // 56
  { IMAGE_SAMPLE_B_CL_O, false, false, false, true, false, 0x2, false, false, true, true, true, false, false }, // 57
  { IMAGE_SAMPLE_B_O, false, false, false, true, false, 0x2, false, false, true, false, true, false, false }, // 58
  { IMAGE_SAMPLE_C, false, false, false, true, false, 0x1, false, false, true, false, true, false, false }, // 59
  { IMAGE_SAMPLE_CD, false, false, false, true, false, 0x0, true, false, true, false, true, false, false }, // 60
  { IMAGE_SAMPLE_CD_CL, false, false, false, true, false, 0x0, true, false, true, true, true, false, false }, // 61
  { IMAGE_SAMPLE_CD_CL_G16, false, false, false, true, false, 0x0, true, true, true, true, true, false, false }, // 62
  { IMAGE_SAMPLE_CD_CL_O, false, false, false, true, false, 0x1, true, false, true, true, true, false, false }, // 63
  { IMAGE_SAMPLE_CD_CL_O_G16, false, false, false, true, false, 0x1, true, true, true, true, true, false, false }, // 64
  { IMAGE_SAMPLE_CD_G16, false, false, false, true, false, 0x0, true, true, true, false, true, false, false }, // 65
  { IMAGE_SAMPLE_CD_O, false, false, false, true, false, 0x1, true, false, true, false, true, false, false }, // 66
  { IMAGE_SAMPLE_CD_O_G16, false, false, false, true, false, 0x1, true, true, true, false, true, false, false }, // 67
  { IMAGE_SAMPLE_CL, false, false, false, true, false, 0x0, false, false, true, true, true, false, false }, // 68
  { IMAGE_SAMPLE_CL_O, false, false, false, true, false, 0x1, false, false, true, true, true, false, false }, // 69
  { IMAGE_SAMPLE_C_B, false, false, false, true, false, 0x2, false, false, true, false, true, false, false }, // 70
  { IMAGE_SAMPLE_C_B_CL, false, false, false, true, false, 0x2, false, false, true, true, true, false, false }, // 71
  { IMAGE_SAMPLE_C_B_CL_O, false, false, false, true, false, 0x3, false, false, true, true, true, false, false }, // 72
  { IMAGE_SAMPLE_C_B_O, false, false, false, true, false, 0x3, false, false, true, false, true, false, false }, // 73
  { IMAGE_SAMPLE_C_CD, false, false, false, true, false, 0x1, true, false, true, false, true, false, false }, // 74
  { IMAGE_SAMPLE_C_CD_CL, false, false, false, true, false, 0x1, true, false, true, true, true, false, false }, // 75
  { IMAGE_SAMPLE_C_CD_CL_G16, false, false, false, true, false, 0x1, true, true, true, true, true, false, false }, // 76
  { IMAGE_SAMPLE_C_CD_CL_O, false, false, false, true, false, 0x2, true, false, true, true, true, false, false }, // 77
  { IMAGE_SAMPLE_C_CD_CL_O_G16, false, false, false, true, false, 0x2, true, true, true, true, true, false, false }, // 78
  { IMAGE_SAMPLE_C_CD_G16, false, false, false, true, false, 0x1, true, true, true, false, true, false, false }, // 79
  { IMAGE_SAMPLE_C_CD_O, false, false, false, true, false, 0x2, true, false, true, false, true, false, false }, // 80
  { IMAGE_SAMPLE_C_CD_O_G16, false, false, false, true, false, 0x2, true, true, true, false, true, false, false }, // 81
  { IMAGE_SAMPLE_C_CL, false, false, false, true, false, 0x1, false, false, true, true, true, false, false }, // 82
  { IMAGE_SAMPLE_C_CL_O, false, false, false, true, false, 0x2, false, false, true, true, true, false, false }, // 83
  { IMAGE_SAMPLE_C_D, false, false, false, true, false, 0x1, true, false, true, false, true, false, false }, // 84
  { IMAGE_SAMPLE_C_D_CL, false, false, false, true, false, 0x1, true, false, true, true, true, false, false }, // 85
  { IMAGE_SAMPLE_C_D_CL_G16, false, false, false, true, false, 0x1, true, true, true, true, true, false, false }, // 86
  { IMAGE_SAMPLE_C_D_CL_O, false, false, false, true, false, 0x2, true, false, true, true, true, false, false }, // 87
  { IMAGE_SAMPLE_C_D_CL_O_G16, false, false, false, true, false, 0x2, true, true, true, true, true, false, false }, // 88
  { IMAGE_SAMPLE_C_D_G16, false, false, false, true, false, 0x1, true, true, true, false, true, false, false }, // 89
  { IMAGE_SAMPLE_C_D_O, false, false, false, true, false, 0x2, true, false, true, false, true, false, false }, // 90
  { IMAGE_SAMPLE_C_D_O_G16, false, false, false, true, false, 0x2, true, true, true, false, true, false, false }, // 91
  { IMAGE_SAMPLE_C_L, false, false, false, true, false, 0x1, false, false, true, true, true, false, false }, // 92
  { IMAGE_SAMPLE_C_LZ, false, false, false, true, false, 0x1, false, false, true, false, true, false, false }, // 93
  { IMAGE_SAMPLE_C_LZ_O, false, false, false, true, false, 0x2, false, false, true, false, true, false, false }, // 94
  { IMAGE_SAMPLE_C_L_O, false, false, false, true, false, 0x2, false, false, true, true, true, false, false }, // 95
  { IMAGE_SAMPLE_C_O, false, false, false, true, false, 0x2, false, false, true, false, true, false, false }, // 96
  { IMAGE_SAMPLE_D, false, false, false, true, false, 0x0, true, false, true, false, true, false, false }, // 97
  { IMAGE_SAMPLE_D_CL, false, false, false, true, false, 0x0, true, false, true, true, true, false, false }, // 98
  { IMAGE_SAMPLE_D_CL_G16, false, false, false, true, false, 0x0, true, true, true, true, true, false, false }, // 99
  { IMAGE_SAMPLE_D_CL_O, false, false, false, true, false, 0x1, true, false, true, true, true, false, false }, // 100
  { IMAGE_SAMPLE_D_CL_O_G16, false, false, false, true, false, 0x1, true, true, true, true, true, false, false }, // 101
  { IMAGE_SAMPLE_D_G16, false, false, false, true, false, 0x0, true, true, true, false, true, false, false }, // 102
  { IMAGE_SAMPLE_D_O, false, false, false, true, false, 0x1, true, false, true, false, true, false, false }, // 103
  { IMAGE_SAMPLE_D_O_G16, false, false, false, true, false, 0x1, true, true, true, false, true, false, false }, // 104
  { IMAGE_SAMPLE_L, false, false, false, true, false, 0x0, false, false, true, true, true, false, false }, // 105
  { IMAGE_SAMPLE_LZ, false, false, false, true, false, 0x0, false, false, true, false, true, false, false }, // 106
  { IMAGE_SAMPLE_LZ_O, false, false, false, true, false, 0x1, false, false, true, false, true, false, false }, // 107
  { IMAGE_SAMPLE_L_O, false, false, false, true, false, 0x1, false, false, true, true, true, false, false }, // 108
  { IMAGE_SAMPLE_O, false, false, false, true, false, 0x1, false, false, true, false, true, false, false }, // 109
  { IMAGE_STORE, true, false, false, false, false, 0x0, false, false, true, false, true, false, false }, // 110
  { IMAGE_STORE_MIP, true, false, false, false, false, 0x0, false, false, true, true, true, false, false }, // 111
  { IMAGE_STORE_MIP_PCK, true, false, false, false, false, 0x0, false, false, true, true, false, false, false }, // 112
  { IMAGE_STORE_PCK, true, false, false, false, false, 0x0, false, false, true, false, false, false, false }, // 113
 };

const MIMGBaseOpcodeInfo *getMIMGBaseOpcodeInfo(unsigned BaseOpcode) {
  auto Table = makeArrayRef(MIMGBaseOpcodesTable);
  size_t Idx = BaseOpcode;
  return Idx >= Table.size() ? nullptr : &Table[Idx];
}
#endif

#ifdef GET_MIMGBiasMappingTable_DECL
const MIMGBiasMappingInfo *getMIMGBiasMappingInfo(unsigned Bias);
#endif

#ifdef GET_MIMGBiasMappingTable_IMPL
constexpr MIMGBiasMappingInfo MIMGBiasMappingTable[] = {
  { IMAGE_GATHER4_B, IMAGE_GATHER4 }, // 0
  { IMAGE_GATHER4_B_CL, IMAGE_GATHER4_CL }, // 1
  { IMAGE_GATHER4_B_CL_O, IMAGE_GATHER4_CL_O }, // 2
  { IMAGE_GATHER4_B_O, IMAGE_GATHER4_O }, // 3
  { IMAGE_GATHER4_C_B, IMAGE_GATHER4_C }, // 4
  { IMAGE_GATHER4_C_B_CL, IMAGE_GATHER4_C_CL }, // 5
  { IMAGE_GATHER4_C_B_CL_O, IMAGE_GATHER4_C_CL_O }, // 6
  { IMAGE_GATHER4_C_B_O, IMAGE_GATHER4_C_O }, // 7
  { IMAGE_SAMPLE_B, IMAGE_SAMPLE }, // 8
  { IMAGE_SAMPLE_B_CL, IMAGE_SAMPLE_CL }, // 9
  { IMAGE_SAMPLE_B_CL_O, IMAGE_SAMPLE_CL_O }, // 10
  { IMAGE_SAMPLE_B_O, IMAGE_SAMPLE_O }, // 11
  { IMAGE_SAMPLE_C_B, IMAGE_SAMPLE_C }, // 12
  { IMAGE_SAMPLE_C_B_CL, IMAGE_SAMPLE_C_CL }, // 13
  { IMAGE_SAMPLE_C_B_CL_O, IMAGE_SAMPLE_C_CL_O }, // 14
  { IMAGE_SAMPLE_C_B_O, IMAGE_SAMPLE_C_O }, // 15
 };

const MIMGBiasMappingInfo *getMIMGBiasMappingInfo(unsigned Bias) {
  struct KeyType {
    unsigned Bias;
  };
  KeyType Key = {Bias};
  auto Table = makeArrayRef(MIMGBiasMappingTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const MIMGBiasMappingInfo &LHS, const KeyType &RHS) {
      if ((unsigned)LHS.Bias < (unsigned)RHS.Bias)
        return true;
      if ((unsigned)LHS.Bias > (unsigned)RHS.Bias)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Bias != Idx->Bias)
    return nullptr;
  return &*Idx;
}
#endif

#ifdef GET_MIMGDimInfoTable_DECL
const MIMGDimInfo *getMIMGDimInfo(unsigned Dim);
const MIMGDimInfo *getMIMGDimInfoByAsmSuffix(StringRef AsmSuffix);
const MIMGDimInfo *getMIMGDimInfoByEncoding(uint8_t Encoding);
#endif

#ifdef GET_MIMGDimInfoTable_IMPL
constexpr MIMGDimInfo MIMGDimInfoTable[] = {
  { AMDGPUDim1D, 0x1, 0x2, false, false, 0x0, "1D" }, // 0
  { AMDGPUDim1DArray, 0x2, 0x2, false, true, 0x4, "1D_ARRAY" }, // 1
  { AMDGPUDim2D, 0x2, 0x4, false, false, 0x1, "2D" }, // 2
  { AMDGPUDim2DArray, 0x3, 0x4, false, true, 0x5, "2D_ARRAY" }, // 3
  { AMDGPUDim2DArrayMsaa, 0x4, 0x4, true, true, 0x7, "2D_MSAA_ARRAY" }, // 4
  { AMDGPUDim2DMsaa, 0x3, 0x4, true, false, 0x6, "2D_MSAA" }, // 5
  { AMDGPUDim3D, 0x3, 0x6, false, false, 0x2, "3D" }, // 6
  { AMDGPUDimCube, 0x3, 0x4, false, true, 0x3, "CUBE" }, // 7
 };

const MIMGDimInfo *getMIMGDimInfo(unsigned Dim) {
  auto Table = makeArrayRef(MIMGDimInfoTable);
  size_t Idx = Dim;
  return Idx >= Table.size() ? nullptr : &Table[Idx];
}

const MIMGDimInfo *getMIMGDimInfoByAsmSuffix(StringRef AsmSuffix) {
  struct IndexType {
    const char * AsmSuffix;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "1D", 0 },
    { "1D_ARRAY", 1 },
    { "2D", 2 },
    { "2D_ARRAY", 3 },
    { "2D_MSAA", 5 },
    { "2D_MSAA_ARRAY", 4 },
    { "3D", 6 },
    { "CUBE", 7 },
  };

  struct KeyType {
    std::string AsmSuffix;
  };
  KeyType Key = {AsmSuffix.upper()};
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpAsmSuffix = StringRef(LHS.AsmSuffix).compare(RHS.AsmSuffix);
      if (CmpAsmSuffix < 0) return true;
      if (CmpAsmSuffix > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.AsmSuffix != Idx->AsmSuffix)
    return nullptr;
  return &MIMGDimInfoTable[Idx->_index];
}

const MIMGDimInfo *getMIMGDimInfoByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x0, 0 },
    { 0x1, 2 },
    { 0x2, 6 },
    { 0x3, 7 },
    { 0x4, 1 },
    { 0x5, 3 },
    { 0x6, 5 },
    { 0x7, 4 },
  };

  auto Table = makeArrayRef(Index);
  size_t Idx = Encoding;
  return Idx >= Table.size() ? nullptr : &MIMGDimInfoTable[Table[Idx]._index];
}
#endif

#ifdef GET_MIMGG16MappingTable_DECL
const MIMGG16MappingInfo *getMIMGG16MappingInfo(unsigned G);
#endif

#ifdef GET_MIMGG16MappingTable_IMPL
constexpr MIMGG16MappingInfo MIMGG16MappingTable[] = {
  { IMAGE_SAMPLE_CD, IMAGE_SAMPLE_CD_G16 }, // 0
  { IMAGE_SAMPLE_CD_CL, IMAGE_SAMPLE_CD_CL_G16 }, // 1
  { IMAGE_SAMPLE_CD_CL_O, IMAGE_SAMPLE_CD_CL_O_G16 }, // 2
  { IMAGE_SAMPLE_CD_O, IMAGE_SAMPLE_CD_O_G16 }, // 3
  { IMAGE_SAMPLE_C_CD, IMAGE_SAMPLE_C_CD_G16 }, // 4
  { IMAGE_SAMPLE_C_CD_CL, IMAGE_SAMPLE_C_CD_CL_G16 }, // 5
  { IMAGE_SAMPLE_C_CD_CL_O, IMAGE_SAMPLE_C_CD_CL_O_G16 }, // 6
  { IMAGE_SAMPLE_C_CD_O, IMAGE_SAMPLE_C_CD_O_G16 }, // 7
  { IMAGE_SAMPLE_C_D, IMAGE_SAMPLE_C_D_G16 }, // 8
  { IMAGE_SAMPLE_C_D_CL, IMAGE_SAMPLE_C_D_CL_G16 }, // 9
  { IMAGE_SAMPLE_C_D_CL_O, IMAGE_SAMPLE_C_D_CL_O_G16 }, // 10
  { IMAGE_SAMPLE_C_D_O, IMAGE_SAMPLE_C_D_O_G16 }, // 11
  { IMAGE_SAMPLE_D, IMAGE_SAMPLE_D_G16 }, // 12
  { IMAGE_SAMPLE_D_CL, IMAGE_SAMPLE_D_CL_G16 }, // 13
  { IMAGE_SAMPLE_D_CL_O, IMAGE_SAMPLE_D_CL_O_G16 }, // 14
  { IMAGE_SAMPLE_D_O, IMAGE_SAMPLE_D_O_G16 }, // 15
 };

const MIMGG16MappingInfo *getMIMGG16MappingInfo(unsigned G) {
  struct KeyType {
    unsigned G;
  };
  KeyType Key = {G};
  auto Table = makeArrayRef(MIMGG16MappingTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const MIMGG16MappingInfo &LHS, const KeyType &RHS) {
      if ((unsigned)LHS.G < (unsigned)RHS.G)
        return true;
      if ((unsigned)LHS.G > (unsigned)RHS.G)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.G != Idx->G)
    return nullptr;
  return &*Idx;
}
#endif

#ifdef GET_MIMGInfoTable_DECL
const MIMGInfo *getMIMGOpcodeHelper(unsigned BaseOpcode, unsigned MIMGEncoding, uint8_t VDataDwords, uint8_t VAddrDwords);
const MIMGInfo *getMIMGInfo(unsigned Opcode);
#endif

#ifdef GET_MIMGInfoTable_IMPL
constexpr MIMGInfo MIMGInfoTable[] = {
  { IMAGE_ATOMIC_ADD_V1_V1_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x1, 0x1 }, // 0
  { IMAGE_ATOMIC_ADD_V1_V2_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x1, 0x2 }, // 1
  { IMAGE_ATOMIC_ADD_V1_V3_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x1, 0x3 }, // 2
  { IMAGE_ATOMIC_ADD_V1_V4_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x1, 0x4 }, // 3
  { IMAGE_ATOMIC_ADD_V2_V1_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x1 }, // 4
  { IMAGE_ATOMIC_ADD_V2_V2_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x2 }, // 5
  { IMAGE_ATOMIC_ADD_V2_V3_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x3 }, // 6
  { IMAGE_ATOMIC_ADD_V2_V4_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x4 }, // 7
  { IMAGE_ATOMIC_ADD_V1_V2_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x1, 0x2 }, // 8
  { IMAGE_ATOMIC_ADD_V1_V3_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x1, 0x3 }, // 9
  { IMAGE_ATOMIC_ADD_V1_V4_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x1, 0x4 }, // 10
  { IMAGE_ATOMIC_ADD_V2_V2_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x2, 0x2 }, // 11
  { IMAGE_ATOMIC_ADD_V2_V3_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x2, 0x3 }, // 12
  { IMAGE_ATOMIC_ADD_V2_V4_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x2, 0x4 }, // 13
  { IMAGE_ATOMIC_ADD_V1_V1_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x1 }, // 14
  { IMAGE_ATOMIC_ADD_V1_V2_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x2 }, // 15
  { IMAGE_ATOMIC_ADD_V1_V3_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x3 }, // 16
  { IMAGE_ATOMIC_ADD_V1_V4_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x4 }, // 17
  { IMAGE_ATOMIC_ADD_V2_V1_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x1 }, // 18
  { IMAGE_ATOMIC_ADD_V2_V2_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x2 }, // 19
  { IMAGE_ATOMIC_ADD_V2_V3_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x3 }, // 20
  { IMAGE_ATOMIC_ADD_V2_V4_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x4 }, // 21
  { IMAGE_ATOMIC_ADD_V1_V1_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x1 }, // 22
  { IMAGE_ATOMIC_ADD_V1_V2_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x2 }, // 23
  { IMAGE_ATOMIC_ADD_V1_V3_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x3 }, // 24
  { IMAGE_ATOMIC_ADD_V1_V4_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x4 }, // 25
  { IMAGE_ATOMIC_ADD_V2_V1_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x1 }, // 26
  { IMAGE_ATOMIC_ADD_V2_V2_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x2 }, // 27
  { IMAGE_ATOMIC_ADD_V2_V3_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x3 }, // 28
  { IMAGE_ATOMIC_ADD_V2_V4_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x4 }, // 29
  { IMAGE_ATOMIC_ADD_V1_V1_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x1, 0x1 }, // 30
  { IMAGE_ATOMIC_ADD_V1_V2_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x1, 0x2 }, // 31
  { IMAGE_ATOMIC_ADD_V1_V3_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x1, 0x3 }, // 32
  { IMAGE_ATOMIC_ADD_V1_V4_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x1, 0x4 }, // 33
  { IMAGE_ATOMIC_ADD_V2_V1_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x1 }, // 34
  { IMAGE_ATOMIC_ADD_V2_V2_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x2 }, // 35
  { IMAGE_ATOMIC_ADD_V2_V3_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x3 }, // 36
  { IMAGE_ATOMIC_ADD_V2_V4_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x4 }, // 37
  { IMAGE_ATOMIC_AND_V1_V1_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x1, 0x1 }, // 38
  { IMAGE_ATOMIC_AND_V1_V2_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x1, 0x2 }, // 39
  { IMAGE_ATOMIC_AND_V1_V3_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x1, 0x3 }, // 40
  { IMAGE_ATOMIC_AND_V1_V4_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x1, 0x4 }, // 41
  { IMAGE_ATOMIC_AND_V2_V1_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x1 }, // 42
  { IMAGE_ATOMIC_AND_V2_V2_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x2 }, // 43
  { IMAGE_ATOMIC_AND_V2_V3_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x3 }, // 44
  { IMAGE_ATOMIC_AND_V2_V4_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x4 }, // 45
  { IMAGE_ATOMIC_AND_V1_V2_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x1, 0x2 }, // 46
  { IMAGE_ATOMIC_AND_V1_V3_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x1, 0x3 }, // 47
  { IMAGE_ATOMIC_AND_V1_V4_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x1, 0x4 }, // 48
  { IMAGE_ATOMIC_AND_V2_V2_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x2, 0x2 }, // 49
  { IMAGE_ATOMIC_AND_V2_V3_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x2, 0x3 }, // 50
  { IMAGE_ATOMIC_AND_V2_V4_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x2, 0x4 }, // 51
  { IMAGE_ATOMIC_AND_V1_V1_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x1 }, // 52
  { IMAGE_ATOMIC_AND_V1_V2_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x2 }, // 53
  { IMAGE_ATOMIC_AND_V1_V3_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x3 }, // 54
  { IMAGE_ATOMIC_AND_V1_V4_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x4 }, // 55
  { IMAGE_ATOMIC_AND_V2_V1_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x1 }, // 56
  { IMAGE_ATOMIC_AND_V2_V2_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x2 }, // 57
  { IMAGE_ATOMIC_AND_V2_V3_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x3 }, // 58
  { IMAGE_ATOMIC_AND_V2_V4_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x4 }, // 59
  { IMAGE_ATOMIC_AND_V1_V1_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x1 }, // 60
  { IMAGE_ATOMIC_AND_V1_V2_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x2 }, // 61
  { IMAGE_ATOMIC_AND_V1_V3_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x3 }, // 62
  { IMAGE_ATOMIC_AND_V1_V4_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x4 }, // 63
  { IMAGE_ATOMIC_AND_V2_V1_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x1 }, // 64
  { IMAGE_ATOMIC_AND_V2_V2_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x2 }, // 65
  { IMAGE_ATOMIC_AND_V2_V3_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x3 }, // 66
  { IMAGE_ATOMIC_AND_V2_V4_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x4 }, // 67
  { IMAGE_ATOMIC_AND_V1_V1_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x1, 0x1 }, // 68
  { IMAGE_ATOMIC_AND_V1_V2_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x1, 0x2 }, // 69
  { IMAGE_ATOMIC_AND_V1_V3_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x1, 0x3 }, // 70
  { IMAGE_ATOMIC_AND_V1_V4_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x1, 0x4 }, // 71
  { IMAGE_ATOMIC_AND_V2_V1_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x1 }, // 72
  { IMAGE_ATOMIC_AND_V2_V2_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x2 }, // 73
  { IMAGE_ATOMIC_AND_V2_V3_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x3 }, // 74
  { IMAGE_ATOMIC_AND_V2_V4_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x4 }, // 75
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x1 }, // 76
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x2 }, // 77
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x3 }, // 78
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x4 }, // 79
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x1 }, // 80
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x2 }, // 81
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x3 }, // 82
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x4 }, // 83
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x2, 0x2 }, // 84
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x2, 0x3 }, // 85
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x2, 0x4 }, // 86
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x4, 0x2 }, // 87
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x4, 0x3 }, // 88
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x4, 0x4 }, // 89
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x1 }, // 90
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x2 }, // 91
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x3 }, // 92
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x4 }, // 93
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x1 }, // 94
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x2 }, // 95
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x3 }, // 96
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x4 }, // 97
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x1 }, // 98
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x2 }, // 99
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x3 }, // 100
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x4 }, // 101
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x1 }, // 102
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x2 }, // 103
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x3 }, // 104
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x4 }, // 105
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x1 }, // 106
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x2 }, // 107
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x3 }, // 108
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x4 }, // 109
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x1 }, // 110
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x2 }, // 111
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x3 }, // 112
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x4 }, // 113
  { IMAGE_ATOMIC_DEC_V1_V1_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x1, 0x1 }, // 114
  { IMAGE_ATOMIC_DEC_V1_V2_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x1, 0x2 }, // 115
  { IMAGE_ATOMIC_DEC_V1_V3_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x1, 0x3 }, // 116
  { IMAGE_ATOMIC_DEC_V1_V4_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x1, 0x4 }, // 117
  { IMAGE_ATOMIC_DEC_V2_V1_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x1 }, // 118
  { IMAGE_ATOMIC_DEC_V2_V2_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x2 }, // 119
  { IMAGE_ATOMIC_DEC_V2_V3_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x3 }, // 120
  { IMAGE_ATOMIC_DEC_V2_V4_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x4 }, // 121
  { IMAGE_ATOMIC_DEC_V1_V2_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x1, 0x2 }, // 122
  { IMAGE_ATOMIC_DEC_V1_V3_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x1, 0x3 }, // 123
  { IMAGE_ATOMIC_DEC_V1_V4_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x1, 0x4 }, // 124
  { IMAGE_ATOMIC_DEC_V2_V2_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x2, 0x2 }, // 125
  { IMAGE_ATOMIC_DEC_V2_V3_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x2, 0x3 }, // 126
  { IMAGE_ATOMIC_DEC_V2_V4_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x2, 0x4 }, // 127
  { IMAGE_ATOMIC_DEC_V1_V1_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x1 }, // 128
  { IMAGE_ATOMIC_DEC_V1_V2_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x2 }, // 129
  { IMAGE_ATOMIC_DEC_V1_V3_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x3 }, // 130
  { IMAGE_ATOMIC_DEC_V1_V4_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x4 }, // 131
  { IMAGE_ATOMIC_DEC_V2_V1_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x1 }, // 132
  { IMAGE_ATOMIC_DEC_V2_V2_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x2 }, // 133
  { IMAGE_ATOMIC_DEC_V2_V3_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x3 }, // 134
  { IMAGE_ATOMIC_DEC_V2_V4_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x4 }, // 135
  { IMAGE_ATOMIC_DEC_V1_V1_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x1 }, // 136
  { IMAGE_ATOMIC_DEC_V1_V2_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x2 }, // 137
  { IMAGE_ATOMIC_DEC_V1_V3_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x3 }, // 138
  { IMAGE_ATOMIC_DEC_V1_V4_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x4 }, // 139
  { IMAGE_ATOMIC_DEC_V2_V1_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x1 }, // 140
  { IMAGE_ATOMIC_DEC_V2_V2_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x2 }, // 141
  { IMAGE_ATOMIC_DEC_V2_V3_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x3 }, // 142
  { IMAGE_ATOMIC_DEC_V2_V4_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x4 }, // 143
  { IMAGE_ATOMIC_DEC_V1_V1_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x1, 0x1 }, // 144
  { IMAGE_ATOMIC_DEC_V1_V2_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x1, 0x2 }, // 145
  { IMAGE_ATOMIC_DEC_V1_V3_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x1, 0x3 }, // 146
  { IMAGE_ATOMIC_DEC_V1_V4_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x1, 0x4 }, // 147
  { IMAGE_ATOMIC_DEC_V2_V1_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x1 }, // 148
  { IMAGE_ATOMIC_DEC_V2_V2_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x2 }, // 149
  { IMAGE_ATOMIC_DEC_V2_V3_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x3 }, // 150
  { IMAGE_ATOMIC_DEC_V2_V4_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x4 }, // 151
  { IMAGE_ATOMIC_FCMPSWAP_V1_V1_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x1 }, // 152
  { IMAGE_ATOMIC_FCMPSWAP_V1_V2_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x2 }, // 153
  { IMAGE_ATOMIC_FCMPSWAP_V1_V3_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x3 }, // 154
  { IMAGE_ATOMIC_FCMPSWAP_V1_V4_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x4 }, // 155
  { IMAGE_ATOMIC_FCMPSWAP_V2_V1_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x1 }, // 156
  { IMAGE_ATOMIC_FCMPSWAP_V2_V2_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x2 }, // 157
  { IMAGE_ATOMIC_FCMPSWAP_V2_V3_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x3 }, // 158
  { IMAGE_ATOMIC_FCMPSWAP_V2_V4_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x4 }, // 159
  { IMAGE_ATOMIC_FCMPSWAP_V1_V2_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x2, 0x2 }, // 160
  { IMAGE_ATOMIC_FCMPSWAP_V1_V3_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x2, 0x3 }, // 161
  { IMAGE_ATOMIC_FCMPSWAP_V1_V4_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x2, 0x4 }, // 162
  { IMAGE_ATOMIC_FCMPSWAP_V2_V2_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x4, 0x2 }, // 163
  { IMAGE_ATOMIC_FCMPSWAP_V2_V3_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x4, 0x3 }, // 164
  { IMAGE_ATOMIC_FCMPSWAP_V2_V4_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x4, 0x4 }, // 165
  { IMAGE_ATOMIC_FCMPSWAP_V1_V1_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x1 }, // 166
  { IMAGE_ATOMIC_FCMPSWAP_V1_V2_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x2 }, // 167
  { IMAGE_ATOMIC_FCMPSWAP_V1_V3_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x3 }, // 168
  { IMAGE_ATOMIC_FCMPSWAP_V1_V4_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x4 }, // 169
  { IMAGE_ATOMIC_FCMPSWAP_V2_V1_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x1 }, // 170
  { IMAGE_ATOMIC_FCMPSWAP_V2_V2_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x2 }, // 171
  { IMAGE_ATOMIC_FCMPSWAP_V2_V3_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x3 }, // 172
  { IMAGE_ATOMIC_FCMPSWAP_V2_V4_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x4 }, // 173
  { IMAGE_ATOMIC_FMAX_V1_V1_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x1, 0x1 }, // 174
  { IMAGE_ATOMIC_FMAX_V1_V2_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x1, 0x2 }, // 175
  { IMAGE_ATOMIC_FMAX_V1_V3_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x1, 0x3 }, // 176
  { IMAGE_ATOMIC_FMAX_V1_V4_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x1, 0x4 }, // 177
  { IMAGE_ATOMIC_FMAX_V2_V1_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x1 }, // 178
  { IMAGE_ATOMIC_FMAX_V2_V2_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x2 }, // 179
  { IMAGE_ATOMIC_FMAX_V2_V3_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x3 }, // 180
  { IMAGE_ATOMIC_FMAX_V2_V4_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x4 }, // 181
  { IMAGE_ATOMIC_FMAX_V1_V2_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x1, 0x2 }, // 182
  { IMAGE_ATOMIC_FMAX_V1_V3_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x1, 0x3 }, // 183
  { IMAGE_ATOMIC_FMAX_V1_V4_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x1, 0x4 }, // 184
  { IMAGE_ATOMIC_FMAX_V2_V2_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x2, 0x2 }, // 185
  { IMAGE_ATOMIC_FMAX_V2_V3_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x2, 0x3 }, // 186
  { IMAGE_ATOMIC_FMAX_V2_V4_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x2, 0x4 }, // 187
  { IMAGE_ATOMIC_FMAX_V1_V1_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x1, 0x1 }, // 188
  { IMAGE_ATOMIC_FMAX_V1_V2_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x1, 0x2 }, // 189
  { IMAGE_ATOMIC_FMAX_V1_V3_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x1, 0x3 }, // 190
  { IMAGE_ATOMIC_FMAX_V1_V4_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x1, 0x4 }, // 191
  { IMAGE_ATOMIC_FMAX_V2_V1_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x1 }, // 192
  { IMAGE_ATOMIC_FMAX_V2_V2_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x2 }, // 193
  { IMAGE_ATOMIC_FMAX_V2_V3_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x3 }, // 194
  { IMAGE_ATOMIC_FMAX_V2_V4_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x4 }, // 195
  { IMAGE_ATOMIC_FMIN_V1_V1_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x1, 0x1 }, // 196
  { IMAGE_ATOMIC_FMIN_V1_V2_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x1, 0x2 }, // 197
  { IMAGE_ATOMIC_FMIN_V1_V3_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x1, 0x3 }, // 198
  { IMAGE_ATOMIC_FMIN_V1_V4_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x1, 0x4 }, // 199
  { IMAGE_ATOMIC_FMIN_V2_V1_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x1 }, // 200
  { IMAGE_ATOMIC_FMIN_V2_V2_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x2 }, // 201
  { IMAGE_ATOMIC_FMIN_V2_V3_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x3 }, // 202
  { IMAGE_ATOMIC_FMIN_V2_V4_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x4 }, // 203
  { IMAGE_ATOMIC_FMIN_V1_V2_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x1, 0x2 }, // 204
  { IMAGE_ATOMIC_FMIN_V1_V3_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x1, 0x3 }, // 205
  { IMAGE_ATOMIC_FMIN_V1_V4_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x1, 0x4 }, // 206
  { IMAGE_ATOMIC_FMIN_V2_V2_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x2, 0x2 }, // 207
  { IMAGE_ATOMIC_FMIN_V2_V3_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x2, 0x3 }, // 208
  { IMAGE_ATOMIC_FMIN_V2_V4_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x2, 0x4 }, // 209
  { IMAGE_ATOMIC_FMIN_V1_V1_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x1, 0x1 }, // 210
  { IMAGE_ATOMIC_FMIN_V1_V2_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x1, 0x2 }, // 211
  { IMAGE_ATOMIC_FMIN_V1_V3_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x1, 0x3 }, // 212
  { IMAGE_ATOMIC_FMIN_V1_V4_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x1, 0x4 }, // 213
  { IMAGE_ATOMIC_FMIN_V2_V1_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x1 }, // 214
  { IMAGE_ATOMIC_FMIN_V2_V2_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x2 }, // 215
  { IMAGE_ATOMIC_FMIN_V2_V3_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x3 }, // 216
  { IMAGE_ATOMIC_FMIN_V2_V4_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x4 }, // 217
  { IMAGE_ATOMIC_INC_V1_V1_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x1, 0x1 }, // 218
  { IMAGE_ATOMIC_INC_V1_V2_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x1, 0x2 }, // 219
  { IMAGE_ATOMIC_INC_V1_V3_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x1, 0x3 }, // 220
  { IMAGE_ATOMIC_INC_V1_V4_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x1, 0x4 }, // 221
  { IMAGE_ATOMIC_INC_V2_V1_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x1 }, // 222
  { IMAGE_ATOMIC_INC_V2_V2_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x2 }, // 223
  { IMAGE_ATOMIC_INC_V2_V3_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x3 }, // 224
  { IMAGE_ATOMIC_INC_V2_V4_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x4 }, // 225
  { IMAGE_ATOMIC_INC_V1_V2_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x1, 0x2 }, // 226
  { IMAGE_ATOMIC_INC_V1_V3_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x1, 0x3 }, // 227
  { IMAGE_ATOMIC_INC_V1_V4_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x1, 0x4 }, // 228
  { IMAGE_ATOMIC_INC_V2_V2_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x2, 0x2 }, // 229
  { IMAGE_ATOMIC_INC_V2_V3_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x2, 0x3 }, // 230
  { IMAGE_ATOMIC_INC_V2_V4_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x2, 0x4 }, // 231
  { IMAGE_ATOMIC_INC_V1_V1_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x1 }, // 232
  { IMAGE_ATOMIC_INC_V1_V2_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x2 }, // 233
  { IMAGE_ATOMIC_INC_V1_V3_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x3 }, // 234
  { IMAGE_ATOMIC_INC_V1_V4_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x4 }, // 235
  { IMAGE_ATOMIC_INC_V2_V1_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x1 }, // 236
  { IMAGE_ATOMIC_INC_V2_V2_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x2 }, // 237
  { IMAGE_ATOMIC_INC_V2_V3_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x3 }, // 238
  { IMAGE_ATOMIC_INC_V2_V4_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x4 }, // 239
  { IMAGE_ATOMIC_INC_V1_V1_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x1 }, // 240
  { IMAGE_ATOMIC_INC_V1_V2_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x2 }, // 241
  { IMAGE_ATOMIC_INC_V1_V3_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x3 }, // 242
  { IMAGE_ATOMIC_INC_V1_V4_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x4 }, // 243
  { IMAGE_ATOMIC_INC_V2_V1_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x1 }, // 244
  { IMAGE_ATOMIC_INC_V2_V2_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x2 }, // 245
  { IMAGE_ATOMIC_INC_V2_V3_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x3 }, // 246
  { IMAGE_ATOMIC_INC_V2_V4_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x4 }, // 247
  { IMAGE_ATOMIC_INC_V1_V1_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x1, 0x1 }, // 248
  { IMAGE_ATOMIC_INC_V1_V2_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x1, 0x2 }, // 249
  { IMAGE_ATOMIC_INC_V1_V3_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x1, 0x3 }, // 250
  { IMAGE_ATOMIC_INC_V1_V4_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x1, 0x4 }, // 251
  { IMAGE_ATOMIC_INC_V2_V1_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x1 }, // 252
  { IMAGE_ATOMIC_INC_V2_V2_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x2 }, // 253
  { IMAGE_ATOMIC_INC_V2_V3_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x3 }, // 254
  { IMAGE_ATOMIC_INC_V2_V4_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x4 }, // 255
  { IMAGE_ATOMIC_OR_V1_V1_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x1, 0x1 }, // 256
  { IMAGE_ATOMIC_OR_V1_V2_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x1, 0x2 }, // 257
  { IMAGE_ATOMIC_OR_V1_V3_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x1, 0x3 }, // 258
  { IMAGE_ATOMIC_OR_V1_V4_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x1, 0x4 }, // 259
  { IMAGE_ATOMIC_OR_V2_V1_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x1 }, // 260
  { IMAGE_ATOMIC_OR_V2_V2_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x2 }, // 261
  { IMAGE_ATOMIC_OR_V2_V3_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x3 }, // 262
  { IMAGE_ATOMIC_OR_V2_V4_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x4 }, // 263
  { IMAGE_ATOMIC_OR_V1_V2_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x1, 0x2 }, // 264
  { IMAGE_ATOMIC_OR_V1_V3_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x1, 0x3 }, // 265
  { IMAGE_ATOMIC_OR_V1_V4_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x1, 0x4 }, // 266
  { IMAGE_ATOMIC_OR_V2_V2_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x2, 0x2 }, // 267
  { IMAGE_ATOMIC_OR_V2_V3_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x2, 0x3 }, // 268
  { IMAGE_ATOMIC_OR_V2_V4_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x2, 0x4 }, // 269
  { IMAGE_ATOMIC_OR_V1_V1_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x1 }, // 270
  { IMAGE_ATOMIC_OR_V1_V2_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x2 }, // 271
  { IMAGE_ATOMIC_OR_V1_V3_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x3 }, // 272
  { IMAGE_ATOMIC_OR_V1_V4_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x4 }, // 273
  { IMAGE_ATOMIC_OR_V2_V1_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x1 }, // 274
  { IMAGE_ATOMIC_OR_V2_V2_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x2 }, // 275
  { IMAGE_ATOMIC_OR_V2_V3_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x3 }, // 276
  { IMAGE_ATOMIC_OR_V2_V4_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x4 }, // 277
  { IMAGE_ATOMIC_OR_V1_V1_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x1 }, // 278
  { IMAGE_ATOMIC_OR_V1_V2_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x2 }, // 279
  { IMAGE_ATOMIC_OR_V1_V3_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x3 }, // 280
  { IMAGE_ATOMIC_OR_V1_V4_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x4 }, // 281
  { IMAGE_ATOMIC_OR_V2_V1_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x1 }, // 282
  { IMAGE_ATOMIC_OR_V2_V2_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x2 }, // 283
  { IMAGE_ATOMIC_OR_V2_V3_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x3 }, // 284
  { IMAGE_ATOMIC_OR_V2_V4_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x4 }, // 285
  { IMAGE_ATOMIC_OR_V1_V1_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x1, 0x1 }, // 286
  { IMAGE_ATOMIC_OR_V1_V2_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x1, 0x2 }, // 287
  { IMAGE_ATOMIC_OR_V1_V3_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x1, 0x3 }, // 288
  { IMAGE_ATOMIC_OR_V1_V4_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x1, 0x4 }, // 289
  { IMAGE_ATOMIC_OR_V2_V1_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x1 }, // 290
  { IMAGE_ATOMIC_OR_V2_V2_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x2 }, // 291
  { IMAGE_ATOMIC_OR_V2_V3_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x3 }, // 292
  { IMAGE_ATOMIC_OR_V2_V4_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x4 }, // 293
  { IMAGE_ATOMIC_RSUB_V1_V1_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x1, 0x1 }, // 294
  { IMAGE_ATOMIC_RSUB_V1_V2_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x1, 0x2 }, // 295
  { IMAGE_ATOMIC_RSUB_V1_V3_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x1, 0x3 }, // 296
  { IMAGE_ATOMIC_RSUB_V1_V4_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x1, 0x4 }, // 297
  { IMAGE_ATOMIC_RSUB_V2_V1_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x1 }, // 298
  { IMAGE_ATOMIC_RSUB_V2_V2_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x2 }, // 299
  { IMAGE_ATOMIC_RSUB_V2_V3_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x3 }, // 300
  { IMAGE_ATOMIC_RSUB_V2_V4_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x4 }, // 301
  { IMAGE_ATOMIC_SMAX_V1_V1_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x1, 0x1 }, // 302
  { IMAGE_ATOMIC_SMAX_V1_V2_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x1, 0x2 }, // 303
  { IMAGE_ATOMIC_SMAX_V1_V3_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x1, 0x3 }, // 304
  { IMAGE_ATOMIC_SMAX_V1_V4_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x1, 0x4 }, // 305
  { IMAGE_ATOMIC_SMAX_V2_V1_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x1 }, // 306
  { IMAGE_ATOMIC_SMAX_V2_V2_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x2 }, // 307
  { IMAGE_ATOMIC_SMAX_V2_V3_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x3 }, // 308
  { IMAGE_ATOMIC_SMAX_V2_V4_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x4 }, // 309
  { IMAGE_ATOMIC_SMAX_V1_V2_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x1, 0x2 }, // 310
  { IMAGE_ATOMIC_SMAX_V1_V3_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x1, 0x3 }, // 311
  { IMAGE_ATOMIC_SMAX_V1_V4_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x1, 0x4 }, // 312
  { IMAGE_ATOMIC_SMAX_V2_V2_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x2, 0x2 }, // 313
  { IMAGE_ATOMIC_SMAX_V2_V3_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x2, 0x3 }, // 314
  { IMAGE_ATOMIC_SMAX_V2_V4_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x2, 0x4 }, // 315
  { IMAGE_ATOMIC_SMAX_V1_V1_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x1 }, // 316
  { IMAGE_ATOMIC_SMAX_V1_V2_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x2 }, // 317
  { IMAGE_ATOMIC_SMAX_V1_V3_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x3 }, // 318
  { IMAGE_ATOMIC_SMAX_V1_V4_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x4 }, // 319
  { IMAGE_ATOMIC_SMAX_V2_V1_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x1 }, // 320
  { IMAGE_ATOMIC_SMAX_V2_V2_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x2 }, // 321
  { IMAGE_ATOMIC_SMAX_V2_V3_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x3 }, // 322
  { IMAGE_ATOMIC_SMAX_V2_V4_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x4 }, // 323
  { IMAGE_ATOMIC_SMAX_V1_V1_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x1 }, // 324
  { IMAGE_ATOMIC_SMAX_V1_V2_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x2 }, // 325
  { IMAGE_ATOMIC_SMAX_V1_V3_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x3 }, // 326
  { IMAGE_ATOMIC_SMAX_V1_V4_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x4 }, // 327
  { IMAGE_ATOMIC_SMAX_V2_V1_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x1 }, // 328
  { IMAGE_ATOMIC_SMAX_V2_V2_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x2 }, // 329
  { IMAGE_ATOMIC_SMAX_V2_V3_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x3 }, // 330
  { IMAGE_ATOMIC_SMAX_V2_V4_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x4 }, // 331
  { IMAGE_ATOMIC_SMAX_V1_V1_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x1, 0x1 }, // 332
  { IMAGE_ATOMIC_SMAX_V1_V2_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x1, 0x2 }, // 333
  { IMAGE_ATOMIC_SMAX_V1_V3_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x1, 0x3 }, // 334
  { IMAGE_ATOMIC_SMAX_V1_V4_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x1, 0x4 }, // 335
  { IMAGE_ATOMIC_SMAX_V2_V1_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x1 }, // 336
  { IMAGE_ATOMIC_SMAX_V2_V2_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x2 }, // 337
  { IMAGE_ATOMIC_SMAX_V2_V3_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x3 }, // 338
  { IMAGE_ATOMIC_SMAX_V2_V4_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x4 }, // 339
  { IMAGE_ATOMIC_SMIN_V1_V1_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x1, 0x1 }, // 340
  { IMAGE_ATOMIC_SMIN_V1_V2_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x1, 0x2 }, // 341
  { IMAGE_ATOMIC_SMIN_V1_V3_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x1, 0x3 }, // 342
  { IMAGE_ATOMIC_SMIN_V1_V4_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x1, 0x4 }, // 343
  { IMAGE_ATOMIC_SMIN_V2_V1_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x1 }, // 344
  { IMAGE_ATOMIC_SMIN_V2_V2_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x2 }, // 345
  { IMAGE_ATOMIC_SMIN_V2_V3_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x3 }, // 346
  { IMAGE_ATOMIC_SMIN_V2_V4_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x4 }, // 347
  { IMAGE_ATOMIC_SMIN_V1_V2_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x1, 0x2 }, // 348
  { IMAGE_ATOMIC_SMIN_V1_V3_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x1, 0x3 }, // 349
  { IMAGE_ATOMIC_SMIN_V1_V4_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x1, 0x4 }, // 350
  { IMAGE_ATOMIC_SMIN_V2_V2_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x2, 0x2 }, // 351
  { IMAGE_ATOMIC_SMIN_V2_V3_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x2, 0x3 }, // 352
  { IMAGE_ATOMIC_SMIN_V2_V4_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x2, 0x4 }, // 353
  { IMAGE_ATOMIC_SMIN_V1_V1_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x1 }, // 354
  { IMAGE_ATOMIC_SMIN_V1_V2_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x2 }, // 355
  { IMAGE_ATOMIC_SMIN_V1_V3_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x3 }, // 356
  { IMAGE_ATOMIC_SMIN_V1_V4_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x4 }, // 357
  { IMAGE_ATOMIC_SMIN_V2_V1_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x1 }, // 358
  { IMAGE_ATOMIC_SMIN_V2_V2_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x2 }, // 359
  { IMAGE_ATOMIC_SMIN_V2_V3_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x3 }, // 360
  { IMAGE_ATOMIC_SMIN_V2_V4_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x4 }, // 361
  { IMAGE_ATOMIC_SMIN_V1_V1_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x1 }, // 362
  { IMAGE_ATOMIC_SMIN_V1_V2_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x2 }, // 363
  { IMAGE_ATOMIC_SMIN_V1_V3_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x3 }, // 364
  { IMAGE_ATOMIC_SMIN_V1_V4_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x4 }, // 365
  { IMAGE_ATOMIC_SMIN_V2_V1_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x1 }, // 366
  { IMAGE_ATOMIC_SMIN_V2_V2_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x2 }, // 367
  { IMAGE_ATOMIC_SMIN_V2_V3_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x3 }, // 368
  { IMAGE_ATOMIC_SMIN_V2_V4_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x4 }, // 369
  { IMAGE_ATOMIC_SMIN_V1_V1_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x1, 0x1 }, // 370
  { IMAGE_ATOMIC_SMIN_V1_V2_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x1, 0x2 }, // 371
  { IMAGE_ATOMIC_SMIN_V1_V3_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x1, 0x3 }, // 372
  { IMAGE_ATOMIC_SMIN_V1_V4_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x1, 0x4 }, // 373
  { IMAGE_ATOMIC_SMIN_V2_V1_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x1 }, // 374
  { IMAGE_ATOMIC_SMIN_V2_V2_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x2 }, // 375
  { IMAGE_ATOMIC_SMIN_V2_V3_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x3 }, // 376
  { IMAGE_ATOMIC_SMIN_V2_V4_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x4 }, // 377
  { IMAGE_ATOMIC_SUB_V1_V1_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x1, 0x1 }, // 378
  { IMAGE_ATOMIC_SUB_V1_V2_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x1, 0x2 }, // 379
  { IMAGE_ATOMIC_SUB_V1_V3_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x1, 0x3 }, // 380
  { IMAGE_ATOMIC_SUB_V1_V4_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x1, 0x4 }, // 381
  { IMAGE_ATOMIC_SUB_V2_V1_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x1 }, // 382
  { IMAGE_ATOMIC_SUB_V2_V2_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x2 }, // 383
  { IMAGE_ATOMIC_SUB_V2_V3_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x3 }, // 384
  { IMAGE_ATOMIC_SUB_V2_V4_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x4 }, // 385
  { IMAGE_ATOMIC_SUB_V1_V2_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x1, 0x2 }, // 386
  { IMAGE_ATOMIC_SUB_V1_V3_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x1, 0x3 }, // 387
  { IMAGE_ATOMIC_SUB_V1_V4_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x1, 0x4 }, // 388
  { IMAGE_ATOMIC_SUB_V2_V2_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x2, 0x2 }, // 389
  { IMAGE_ATOMIC_SUB_V2_V3_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x2, 0x3 }, // 390
  { IMAGE_ATOMIC_SUB_V2_V4_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x2, 0x4 }, // 391
  { IMAGE_ATOMIC_SUB_V1_V1_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x1 }, // 392
  { IMAGE_ATOMIC_SUB_V1_V2_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x2 }, // 393
  { IMAGE_ATOMIC_SUB_V1_V3_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x3 }, // 394
  { IMAGE_ATOMIC_SUB_V1_V4_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x4 }, // 395
  { IMAGE_ATOMIC_SUB_V2_V1_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x1 }, // 396
  { IMAGE_ATOMIC_SUB_V2_V2_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x2 }, // 397
  { IMAGE_ATOMIC_SUB_V2_V3_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x3 }, // 398
  { IMAGE_ATOMIC_SUB_V2_V4_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x4 }, // 399
  { IMAGE_ATOMIC_SUB_V1_V1_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x1 }, // 400
  { IMAGE_ATOMIC_SUB_V1_V2_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x2 }, // 401
  { IMAGE_ATOMIC_SUB_V1_V3_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x3 }, // 402
  { IMAGE_ATOMIC_SUB_V1_V4_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x4 }, // 403
  { IMAGE_ATOMIC_SUB_V2_V1_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x1 }, // 404
  { IMAGE_ATOMIC_SUB_V2_V2_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x2 }, // 405
  { IMAGE_ATOMIC_SUB_V2_V3_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x3 }, // 406
  { IMAGE_ATOMIC_SUB_V2_V4_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x4 }, // 407
  { IMAGE_ATOMIC_SUB_V1_V1_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x1, 0x1 }, // 408
  { IMAGE_ATOMIC_SUB_V1_V2_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x1, 0x2 }, // 409
  { IMAGE_ATOMIC_SUB_V1_V3_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x1, 0x3 }, // 410
  { IMAGE_ATOMIC_SUB_V1_V4_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x1, 0x4 }, // 411
  { IMAGE_ATOMIC_SUB_V2_V1_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x1 }, // 412
  { IMAGE_ATOMIC_SUB_V2_V2_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x2 }, // 413
  { IMAGE_ATOMIC_SUB_V2_V3_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x3 }, // 414
  { IMAGE_ATOMIC_SUB_V2_V4_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x4 }, // 415
  { IMAGE_ATOMIC_SWAP_V1_V1_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x1, 0x1 }, // 416
  { IMAGE_ATOMIC_SWAP_V1_V2_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x1, 0x2 }, // 417
  { IMAGE_ATOMIC_SWAP_V1_V3_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x1, 0x3 }, // 418
  { IMAGE_ATOMIC_SWAP_V1_V4_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x1, 0x4 }, // 419
  { IMAGE_ATOMIC_SWAP_V2_V1_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x1 }, // 420
  { IMAGE_ATOMIC_SWAP_V2_V2_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x2 }, // 421
  { IMAGE_ATOMIC_SWAP_V2_V3_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x3 }, // 422
  { IMAGE_ATOMIC_SWAP_V2_V4_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x4 }, // 423
  { IMAGE_ATOMIC_SWAP_V1_V2_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x1, 0x2 }, // 424
  { IMAGE_ATOMIC_SWAP_V1_V3_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x1, 0x3 }, // 425
  { IMAGE_ATOMIC_SWAP_V1_V4_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x1, 0x4 }, // 426
  { IMAGE_ATOMIC_SWAP_V2_V2_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x2, 0x2 }, // 427
  { IMAGE_ATOMIC_SWAP_V2_V3_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x2, 0x3 }, // 428
  { IMAGE_ATOMIC_SWAP_V2_V4_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x2, 0x4 }, // 429
  { IMAGE_ATOMIC_SWAP_V1_V1_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x1 }, // 430
  { IMAGE_ATOMIC_SWAP_V1_V2_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x2 }, // 431
  { IMAGE_ATOMIC_SWAP_V1_V3_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x3 }, // 432
  { IMAGE_ATOMIC_SWAP_V1_V4_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x4 }, // 433
  { IMAGE_ATOMIC_SWAP_V2_V1_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x1 }, // 434
  { IMAGE_ATOMIC_SWAP_V2_V2_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x2 }, // 435
  { IMAGE_ATOMIC_SWAP_V2_V3_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x3 }, // 436
  { IMAGE_ATOMIC_SWAP_V2_V4_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x4 }, // 437
  { IMAGE_ATOMIC_SWAP_V1_V1_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x1 }, // 438
  { IMAGE_ATOMIC_SWAP_V1_V2_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x2 }, // 439
  { IMAGE_ATOMIC_SWAP_V1_V3_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x3 }, // 440
  { IMAGE_ATOMIC_SWAP_V1_V4_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x4 }, // 441
  { IMAGE_ATOMIC_SWAP_V2_V1_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x1 }, // 442
  { IMAGE_ATOMIC_SWAP_V2_V2_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x2 }, // 443
  { IMAGE_ATOMIC_SWAP_V2_V3_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x3 }, // 444
  { IMAGE_ATOMIC_SWAP_V2_V4_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x4 }, // 445
  { IMAGE_ATOMIC_SWAP_V1_V1_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x1, 0x1 }, // 446
  { IMAGE_ATOMIC_SWAP_V1_V2_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x1, 0x2 }, // 447
  { IMAGE_ATOMIC_SWAP_V1_V3_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x1, 0x3 }, // 448
  { IMAGE_ATOMIC_SWAP_V1_V4_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x1, 0x4 }, // 449
  { IMAGE_ATOMIC_SWAP_V2_V1_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x1 }, // 450
  { IMAGE_ATOMIC_SWAP_V2_V2_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x2 }, // 451
  { IMAGE_ATOMIC_SWAP_V2_V3_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x3 }, // 452
  { IMAGE_ATOMIC_SWAP_V2_V4_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x4 }, // 453
  { IMAGE_ATOMIC_UMAX_V1_V1_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x1, 0x1 }, // 454
  { IMAGE_ATOMIC_UMAX_V1_V2_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x1, 0x2 }, // 455
  { IMAGE_ATOMIC_UMAX_V1_V3_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x1, 0x3 }, // 456
  { IMAGE_ATOMIC_UMAX_V1_V4_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x1, 0x4 }, // 457
  { IMAGE_ATOMIC_UMAX_V2_V1_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x1 }, // 458
  { IMAGE_ATOMIC_UMAX_V2_V2_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x2 }, // 459
  { IMAGE_ATOMIC_UMAX_V2_V3_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x3 }, // 460
  { IMAGE_ATOMIC_UMAX_V2_V4_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x4 }, // 461
  { IMAGE_ATOMIC_UMAX_V1_V2_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x1, 0x2 }, // 462
  { IMAGE_ATOMIC_UMAX_V1_V3_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x1, 0x3 }, // 463
  { IMAGE_ATOMIC_UMAX_V1_V4_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x1, 0x4 }, // 464
  { IMAGE_ATOMIC_UMAX_V2_V2_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x2, 0x2 }, // 465
  { IMAGE_ATOMIC_UMAX_V2_V3_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x2, 0x3 }, // 466
  { IMAGE_ATOMIC_UMAX_V2_V4_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x2, 0x4 }, // 467
  { IMAGE_ATOMIC_UMAX_V1_V1_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x1 }, // 468
  { IMAGE_ATOMIC_UMAX_V1_V2_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x2 }, // 469
  { IMAGE_ATOMIC_UMAX_V1_V3_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x3 }, // 470
  { IMAGE_ATOMIC_UMAX_V1_V4_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x4 }, // 471
  { IMAGE_ATOMIC_UMAX_V2_V1_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x1 }, // 472
  { IMAGE_ATOMIC_UMAX_V2_V2_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x2 }, // 473
  { IMAGE_ATOMIC_UMAX_V2_V3_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x3 }, // 474
  { IMAGE_ATOMIC_UMAX_V2_V4_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x4 }, // 475
  { IMAGE_ATOMIC_UMAX_V1_V1_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x1 }, // 476
  { IMAGE_ATOMIC_UMAX_V1_V2_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x2 }, // 477
  { IMAGE_ATOMIC_UMAX_V1_V3_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x3 }, // 478
  { IMAGE_ATOMIC_UMAX_V1_V4_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x4 }, // 479
  { IMAGE_ATOMIC_UMAX_V2_V1_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x1 }, // 480
  { IMAGE_ATOMIC_UMAX_V2_V2_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x2 }, // 481
  { IMAGE_ATOMIC_UMAX_V2_V3_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x3 }, // 482
  { IMAGE_ATOMIC_UMAX_V2_V4_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x4 }, // 483
  { IMAGE_ATOMIC_UMAX_V1_V1_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x1, 0x1 }, // 484
  { IMAGE_ATOMIC_UMAX_V1_V2_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x1, 0x2 }, // 485
  { IMAGE_ATOMIC_UMAX_V1_V3_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x1, 0x3 }, // 486
  { IMAGE_ATOMIC_UMAX_V1_V4_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x1, 0x4 }, // 487
  { IMAGE_ATOMIC_UMAX_V2_V1_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x1 }, // 488
  { IMAGE_ATOMIC_UMAX_V2_V2_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x2 }, // 489
  { IMAGE_ATOMIC_UMAX_V2_V3_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x3 }, // 490
  { IMAGE_ATOMIC_UMAX_V2_V4_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x4 }, // 491
  { IMAGE_ATOMIC_UMIN_V1_V1_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x1, 0x1 }, // 492
  { IMAGE_ATOMIC_UMIN_V1_V2_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x1, 0x2 }, // 493
  { IMAGE_ATOMIC_UMIN_V1_V3_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x1, 0x3 }, // 494
  { IMAGE_ATOMIC_UMIN_V1_V4_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x1, 0x4 }, // 495
  { IMAGE_ATOMIC_UMIN_V2_V1_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x1 }, // 496
  { IMAGE_ATOMIC_UMIN_V2_V2_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x2 }, // 497
  { IMAGE_ATOMIC_UMIN_V2_V3_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x3 }, // 498
  { IMAGE_ATOMIC_UMIN_V2_V4_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x4 }, // 499
  { IMAGE_ATOMIC_UMIN_V1_V2_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x1, 0x2 }, // 500
  { IMAGE_ATOMIC_UMIN_V1_V3_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x1, 0x3 }, // 501
  { IMAGE_ATOMIC_UMIN_V1_V4_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x1, 0x4 }, // 502
  { IMAGE_ATOMIC_UMIN_V2_V2_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x2, 0x2 }, // 503
  { IMAGE_ATOMIC_UMIN_V2_V3_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x2, 0x3 }, // 504
  { IMAGE_ATOMIC_UMIN_V2_V4_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x2, 0x4 }, // 505
  { IMAGE_ATOMIC_UMIN_V1_V1_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x1 }, // 506
  { IMAGE_ATOMIC_UMIN_V1_V2_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x2 }, // 507
  { IMAGE_ATOMIC_UMIN_V1_V3_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x3 }, // 508
  { IMAGE_ATOMIC_UMIN_V1_V4_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x4 }, // 509
  { IMAGE_ATOMIC_UMIN_V2_V1_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x1 }, // 510
  { IMAGE_ATOMIC_UMIN_V2_V2_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x2 }, // 511
  { IMAGE_ATOMIC_UMIN_V2_V3_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x3 }, // 512
  { IMAGE_ATOMIC_UMIN_V2_V4_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x4 }, // 513
  { IMAGE_ATOMIC_UMIN_V1_V1_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x1 }, // 514
  { IMAGE_ATOMIC_UMIN_V1_V2_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x2 }, // 515
  { IMAGE_ATOMIC_UMIN_V1_V3_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x3 }, // 516
  { IMAGE_ATOMIC_UMIN_V1_V4_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x4 }, // 517
  { IMAGE_ATOMIC_UMIN_V2_V1_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x1 }, // 518
  { IMAGE_ATOMIC_UMIN_V2_V2_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x2 }, // 519
  { IMAGE_ATOMIC_UMIN_V2_V3_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x3 }, // 520
  { IMAGE_ATOMIC_UMIN_V2_V4_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x4 }, // 521
  { IMAGE_ATOMIC_UMIN_V1_V1_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x1, 0x1 }, // 522
  { IMAGE_ATOMIC_UMIN_V1_V2_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x1, 0x2 }, // 523
  { IMAGE_ATOMIC_UMIN_V1_V3_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x1, 0x3 }, // 524
  { IMAGE_ATOMIC_UMIN_V1_V4_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x1, 0x4 }, // 525
  { IMAGE_ATOMIC_UMIN_V2_V1_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x1 }, // 526
  { IMAGE_ATOMIC_UMIN_V2_V2_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x2 }, // 527
  { IMAGE_ATOMIC_UMIN_V2_V3_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x3 }, // 528
  { IMAGE_ATOMIC_UMIN_V2_V4_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x4 }, // 529
  { IMAGE_ATOMIC_XOR_V1_V1_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x1, 0x1 }, // 530
  { IMAGE_ATOMIC_XOR_V1_V2_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x1, 0x2 }, // 531
  { IMAGE_ATOMIC_XOR_V1_V3_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x1, 0x3 }, // 532
  { IMAGE_ATOMIC_XOR_V1_V4_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x1, 0x4 }, // 533
  { IMAGE_ATOMIC_XOR_V2_V1_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x1 }, // 534
  { IMAGE_ATOMIC_XOR_V2_V2_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x2 }, // 535
  { IMAGE_ATOMIC_XOR_V2_V3_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x3 }, // 536
  { IMAGE_ATOMIC_XOR_V2_V4_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x4 }, // 537
  { IMAGE_ATOMIC_XOR_V1_V2_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x1, 0x2 }, // 538
  { IMAGE_ATOMIC_XOR_V1_V3_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x1, 0x3 }, // 539
  { IMAGE_ATOMIC_XOR_V1_V4_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x1, 0x4 }, // 540
  { IMAGE_ATOMIC_XOR_V2_V2_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x2, 0x2 }, // 541
  { IMAGE_ATOMIC_XOR_V2_V3_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x2, 0x3 }, // 542
  { IMAGE_ATOMIC_XOR_V2_V4_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x2, 0x4 }, // 543
  { IMAGE_ATOMIC_XOR_V1_V1_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x1 }, // 544
  { IMAGE_ATOMIC_XOR_V1_V2_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x2 }, // 545
  { IMAGE_ATOMIC_XOR_V1_V3_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x3 }, // 546
  { IMAGE_ATOMIC_XOR_V1_V4_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x4 }, // 547
  { IMAGE_ATOMIC_XOR_V2_V1_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x1 }, // 548
  { IMAGE_ATOMIC_XOR_V2_V2_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x2 }, // 549
  { IMAGE_ATOMIC_XOR_V2_V3_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x3 }, // 550
  { IMAGE_ATOMIC_XOR_V2_V4_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x4 }, // 551
  { IMAGE_ATOMIC_XOR_V1_V1_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x1 }, // 552
  { IMAGE_ATOMIC_XOR_V1_V2_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x2 }, // 553
  { IMAGE_ATOMIC_XOR_V1_V3_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x3 }, // 554
  { IMAGE_ATOMIC_XOR_V1_V4_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x4 }, // 555
  { IMAGE_ATOMIC_XOR_V2_V1_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x1 }, // 556
  { IMAGE_ATOMIC_XOR_V2_V2_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x2 }, // 557
  { IMAGE_ATOMIC_XOR_V2_V3_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x3 }, // 558
  { IMAGE_ATOMIC_XOR_V2_V4_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x4 }, // 559
  { IMAGE_ATOMIC_XOR_V1_V1_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x1, 0x1 }, // 560
  { IMAGE_ATOMIC_XOR_V1_V2_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x1, 0x2 }, // 561
  { IMAGE_ATOMIC_XOR_V1_V3_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x1, 0x3 }, // 562
  { IMAGE_ATOMIC_XOR_V1_V4_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x1, 0x4 }, // 563
  { IMAGE_ATOMIC_XOR_V2_V1_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x1 }, // 564
  { IMAGE_ATOMIC_XOR_V2_V2_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x2 }, // 565
  { IMAGE_ATOMIC_XOR_V2_V3_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x3 }, // 566
  { IMAGE_ATOMIC_XOR_V2_V4_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x4 }, // 567
  { IMAGE_BVH64_INTERSECT_RAY_sa_gfx10, IMAGE_BVH64_INTERSECT_RAY, MIMGEncGfx10Default, 0x4, 0x10 }, // 568
  { IMAGE_BVH64_INTERSECT_RAY_nsa_gfx10, IMAGE_BVH64_INTERSECT_RAY, MIMGEncGfx10NSA, 0x4, 0xC }, // 569
  { IMAGE_BVH64_INTERSECT_RAY_a16_sa_gfx10, IMAGE_BVH64_INTERSECT_RAY_a16, MIMGEncGfx10Default, 0x4, 0x10 }, // 570
  { IMAGE_BVH64_INTERSECT_RAY_a16_nsa_gfx10, IMAGE_BVH64_INTERSECT_RAY_a16, MIMGEncGfx10NSA, 0x4, 0x9 }, // 571
  { IMAGE_BVH_INTERSECT_RAY_sa_gfx10, IMAGE_BVH_INTERSECT_RAY, MIMGEncGfx10Default, 0x4, 0x10 }, // 572
  { IMAGE_BVH_INTERSECT_RAY_nsa_gfx10, IMAGE_BVH_INTERSECT_RAY, MIMGEncGfx10NSA, 0x4, 0xB }, // 573
  { IMAGE_BVH_INTERSECT_RAY_a16_sa_gfx10, IMAGE_BVH_INTERSECT_RAY_a16, MIMGEncGfx10Default, 0x4, 0x8 }, // 574
  { IMAGE_BVH_INTERSECT_RAY_a16_nsa_gfx10, IMAGE_BVH_INTERSECT_RAY_a16, MIMGEncGfx10NSA, 0x4, 0x8 }, // 575
  { IMAGE_GATHER4_V2_V1_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x2, 0x1 }, // 576
  { IMAGE_GATHER4_V2_V2_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x2, 0x2 }, // 577
  { IMAGE_GATHER4_V2_V3_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x2, 0x3 }, // 578
  { IMAGE_GATHER4_V2_V4_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x2, 0x4 }, // 579
  { IMAGE_GATHER4_V4_V1_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x4, 0x1 }, // 580
  { IMAGE_GATHER4_V4_V2_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x4, 0x2 }, // 581
  { IMAGE_GATHER4_V4_V3_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x4, 0x3 }, // 582
  { IMAGE_GATHER4_V4_V4_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x4, 0x4 }, // 583
  { IMAGE_GATHER4_V5_V1_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x5, 0x1 }, // 584
  { IMAGE_GATHER4_V5_V2_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x5, 0x2 }, // 585
  { IMAGE_GATHER4_V5_V3_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x5, 0x3 }, // 586
  { IMAGE_GATHER4_V5_V4_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x5, 0x4 }, // 587
  { IMAGE_GATHER4_V2_V2_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x2, 0x2 }, // 588
  { IMAGE_GATHER4_V2_V3_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x2, 0x3 }, // 589
  { IMAGE_GATHER4_V4_V2_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x4, 0x2 }, // 590
  { IMAGE_GATHER4_V4_V3_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x4, 0x3 }, // 591
  { IMAGE_GATHER4_V5_V2_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x5, 0x2 }, // 592
  { IMAGE_GATHER4_V5_V3_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x5, 0x3 }, // 593
  { IMAGE_GATHER4_V2_V1, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x1 }, // 594
  { IMAGE_GATHER4_V2_V2, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x2 }, // 595
  { IMAGE_GATHER4_V2_V3, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x3 }, // 596
  { IMAGE_GATHER4_V2_V4, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x4 }, // 597
  { IMAGE_GATHER4_V4_V1, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x1 }, // 598
  { IMAGE_GATHER4_V4_V2, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x2 }, // 599
  { IMAGE_GATHER4_V4_V3, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x3 }, // 600
  { IMAGE_GATHER4_V4_V4, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x4 }, // 601
  { IMAGE_GATHER4_V5_V1, IMAGE_GATHER4, MIMGEncGfx6, 0x5, 0x1 }, // 602
  { IMAGE_GATHER4_V5_V2, IMAGE_GATHER4, MIMGEncGfx6, 0x5, 0x2 }, // 603
  { IMAGE_GATHER4_V5_V3, IMAGE_GATHER4, MIMGEncGfx6, 0x5, 0x3 }, // 604
  { IMAGE_GATHER4_V5_V4, IMAGE_GATHER4, MIMGEncGfx6, 0x5, 0x4 }, // 605
  { IMAGE_GATHER4_B_V2_V2_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x2, 0x2 }, // 606
  { IMAGE_GATHER4_B_V2_V3_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x2, 0x3 }, // 607
  { IMAGE_GATHER4_B_V2_V4_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x2, 0x4 }, // 608
  { IMAGE_GATHER4_B_V4_V2_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x4, 0x2 }, // 609
  { IMAGE_GATHER4_B_V4_V3_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x4, 0x3 }, // 610
  { IMAGE_GATHER4_B_V4_V4_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x4, 0x4 }, // 611
  { IMAGE_GATHER4_B_V5_V2_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x5, 0x2 }, // 612
  { IMAGE_GATHER4_B_V5_V3_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x5, 0x3 }, // 613
  { IMAGE_GATHER4_B_V5_V4_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x5, 0x4 }, // 614
  { IMAGE_GATHER4_B_V2_V2_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x2, 0x2 }, // 615
  { IMAGE_GATHER4_B_V2_V3_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x2, 0x3 }, // 616
  { IMAGE_GATHER4_B_V2_V4_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x2, 0x4 }, // 617
  { IMAGE_GATHER4_B_V4_V2_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x4, 0x2 }, // 618
  { IMAGE_GATHER4_B_V4_V3_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x4, 0x3 }, // 619
  { IMAGE_GATHER4_B_V4_V4_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x4, 0x4 }, // 620
  { IMAGE_GATHER4_B_V5_V2_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x5, 0x2 }, // 621
  { IMAGE_GATHER4_B_V5_V3_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x5, 0x3 }, // 622
  { IMAGE_GATHER4_B_V5_V4_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x5, 0x4 }, // 623
  { IMAGE_GATHER4_B_V2_V2, IMAGE_GATHER4_B, MIMGEncGfx6, 0x2, 0x2 }, // 624
  { IMAGE_GATHER4_B_V2_V3, IMAGE_GATHER4_B, MIMGEncGfx6, 0x2, 0x3 }, // 625
  { IMAGE_GATHER4_B_V2_V4, IMAGE_GATHER4_B, MIMGEncGfx6, 0x2, 0x4 }, // 626
  { IMAGE_GATHER4_B_V4_V2, IMAGE_GATHER4_B, MIMGEncGfx6, 0x4, 0x2 }, // 627
  { IMAGE_GATHER4_B_V4_V3, IMAGE_GATHER4_B, MIMGEncGfx6, 0x4, 0x3 }, // 628
  { IMAGE_GATHER4_B_V4_V4, IMAGE_GATHER4_B, MIMGEncGfx6, 0x4, 0x4 }, // 629
  { IMAGE_GATHER4_B_V5_V2, IMAGE_GATHER4_B, MIMGEncGfx6, 0x5, 0x2 }, // 630
  { IMAGE_GATHER4_B_V5_V3, IMAGE_GATHER4_B, MIMGEncGfx6, 0x5, 0x3 }, // 631
  { IMAGE_GATHER4_B_V5_V4, IMAGE_GATHER4_B, MIMGEncGfx6, 0x5, 0x4 }, // 632
  { IMAGE_GATHER4_B_CL_V2_V2_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x2 }, // 633
  { IMAGE_GATHER4_B_CL_V2_V3_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x3 }, // 634
  { IMAGE_GATHER4_B_CL_V2_V4_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x4 }, // 635
  { IMAGE_GATHER4_B_CL_V2_V5_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x5 }, // 636
  { IMAGE_GATHER4_B_CL_V2_V8_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x8 }, // 637
  { IMAGE_GATHER4_B_CL_V4_V2_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x2 }, // 638
  { IMAGE_GATHER4_B_CL_V4_V3_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x3 }, // 639
  { IMAGE_GATHER4_B_CL_V4_V4_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x4 }, // 640
  { IMAGE_GATHER4_B_CL_V4_V5_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x5 }, // 641
  { IMAGE_GATHER4_B_CL_V4_V8_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x8 }, // 642
  { IMAGE_GATHER4_B_CL_V5_V2_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x2 }, // 643
  { IMAGE_GATHER4_B_CL_V5_V3_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x3 }, // 644
  { IMAGE_GATHER4_B_CL_V5_V4_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x4 }, // 645
  { IMAGE_GATHER4_B_CL_V5_V5_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x5 }, // 646
  { IMAGE_GATHER4_B_CL_V5_V8_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x8 }, // 647
  { IMAGE_GATHER4_B_CL_V2_V2_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x2, 0x2 }, // 648
  { IMAGE_GATHER4_B_CL_V2_V3_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x2, 0x3 }, // 649
  { IMAGE_GATHER4_B_CL_V2_V4_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x2, 0x4 }, // 650
  { IMAGE_GATHER4_B_CL_V2_V5_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x2, 0x5 }, // 651
  { IMAGE_GATHER4_B_CL_V4_V2_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x4, 0x2 }, // 652
  { IMAGE_GATHER4_B_CL_V4_V3_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x4, 0x3 }, // 653
  { IMAGE_GATHER4_B_CL_V4_V4_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x4, 0x4 }, // 654
  { IMAGE_GATHER4_B_CL_V4_V5_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x4, 0x5 }, // 655
  { IMAGE_GATHER4_B_CL_V5_V2_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x5, 0x2 }, // 656
  { IMAGE_GATHER4_B_CL_V5_V3_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x5, 0x3 }, // 657
  { IMAGE_GATHER4_B_CL_V5_V4_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x5, 0x4 }, // 658
  { IMAGE_GATHER4_B_CL_V5_V5_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x5, 0x5 }, // 659
  { IMAGE_GATHER4_B_CL_V2_V2, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x2 }, // 660
  { IMAGE_GATHER4_B_CL_V2_V3, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x3 }, // 661
  { IMAGE_GATHER4_B_CL_V2_V4, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x4 }, // 662
  { IMAGE_GATHER4_B_CL_V2_V5, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x5 }, // 663
  { IMAGE_GATHER4_B_CL_V2_V8, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x8 }, // 664
  { IMAGE_GATHER4_B_CL_V4_V2, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x2 }, // 665
  { IMAGE_GATHER4_B_CL_V4_V3, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x3 }, // 666
  { IMAGE_GATHER4_B_CL_V4_V4, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x4 }, // 667
  { IMAGE_GATHER4_B_CL_V4_V5, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x5 }, // 668
  { IMAGE_GATHER4_B_CL_V4_V8, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x8 }, // 669
  { IMAGE_GATHER4_B_CL_V5_V2, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x2 }, // 670
  { IMAGE_GATHER4_B_CL_V5_V3, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x3 }, // 671
  { IMAGE_GATHER4_B_CL_V5_V4, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x4 }, // 672
  { IMAGE_GATHER4_B_CL_V5_V5, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x5 }, // 673
  { IMAGE_GATHER4_B_CL_V5_V8, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x8 }, // 674
  { IMAGE_GATHER4_B_CL_O_V2_V3_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 675
  { IMAGE_GATHER4_B_CL_O_V2_V4_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 676
  { IMAGE_GATHER4_B_CL_O_V2_V5_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 677
  { IMAGE_GATHER4_B_CL_O_V2_V6_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x6 }, // 678
  { IMAGE_GATHER4_B_CL_O_V2_V8_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 679
  { IMAGE_GATHER4_B_CL_O_V4_V3_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 680
  { IMAGE_GATHER4_B_CL_O_V4_V4_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 681
  { IMAGE_GATHER4_B_CL_O_V4_V5_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 682
  { IMAGE_GATHER4_B_CL_O_V4_V6_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x6 }, // 683
  { IMAGE_GATHER4_B_CL_O_V4_V8_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 684
  { IMAGE_GATHER4_B_CL_O_V5_V3_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 685
  { IMAGE_GATHER4_B_CL_O_V5_V4_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 686
  { IMAGE_GATHER4_B_CL_O_V5_V5_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 687
  { IMAGE_GATHER4_B_CL_O_V5_V6_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x6 }, // 688
  { IMAGE_GATHER4_B_CL_O_V5_V8_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 689
  { IMAGE_GATHER4_B_CL_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 690
  { IMAGE_GATHER4_B_CL_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 691
  { IMAGE_GATHER4_B_CL_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 692
  { IMAGE_GATHER4_B_CL_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x6 }, // 693
  { IMAGE_GATHER4_B_CL_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 694
  { IMAGE_GATHER4_B_CL_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 695
  { IMAGE_GATHER4_B_CL_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 696
  { IMAGE_GATHER4_B_CL_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x6 }, // 697
  { IMAGE_GATHER4_B_CL_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 698
  { IMAGE_GATHER4_B_CL_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 699
  { IMAGE_GATHER4_B_CL_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 700
  { IMAGE_GATHER4_B_CL_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x6 }, // 701
  { IMAGE_GATHER4_B_CL_O_V2_V3, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x3 }, // 702
  { IMAGE_GATHER4_B_CL_O_V2_V4, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 703
  { IMAGE_GATHER4_B_CL_O_V2_V5, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x5 }, // 704
  { IMAGE_GATHER4_B_CL_O_V2_V6, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x6 }, // 705
  { IMAGE_GATHER4_B_CL_O_V2_V8, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 706
  { IMAGE_GATHER4_B_CL_O_V4_V3, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x3 }, // 707
  { IMAGE_GATHER4_B_CL_O_V4_V4, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 708
  { IMAGE_GATHER4_B_CL_O_V4_V5, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x5 }, // 709
  { IMAGE_GATHER4_B_CL_O_V4_V6, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x6 }, // 710
  { IMAGE_GATHER4_B_CL_O_V4_V8, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 711
  { IMAGE_GATHER4_B_CL_O_V5_V3, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x3 }, // 712
  { IMAGE_GATHER4_B_CL_O_V5_V4, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x4 }, // 713
  { IMAGE_GATHER4_B_CL_O_V5_V5, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x5 }, // 714
  { IMAGE_GATHER4_B_CL_O_V5_V6, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x6 }, // 715
  { IMAGE_GATHER4_B_CL_O_V5_V8, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x8 }, // 716
  { IMAGE_GATHER4_B_O_V2_V3_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 717
  { IMAGE_GATHER4_B_O_V2_V4_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 718
  { IMAGE_GATHER4_B_O_V2_V5_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 719
  { IMAGE_GATHER4_B_O_V2_V8_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 720
  { IMAGE_GATHER4_B_O_V4_V3_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 721
  { IMAGE_GATHER4_B_O_V4_V4_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 722
  { IMAGE_GATHER4_B_O_V4_V5_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 723
  { IMAGE_GATHER4_B_O_V4_V8_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 724
  { IMAGE_GATHER4_B_O_V5_V3_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 725
  { IMAGE_GATHER4_B_O_V5_V4_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 726
  { IMAGE_GATHER4_B_O_V5_V5_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 727
  { IMAGE_GATHER4_B_O_V5_V8_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 728
  { IMAGE_GATHER4_B_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 729
  { IMAGE_GATHER4_B_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 730
  { IMAGE_GATHER4_B_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 731
  { IMAGE_GATHER4_B_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 732
  { IMAGE_GATHER4_B_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 733
  { IMAGE_GATHER4_B_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 734
  { IMAGE_GATHER4_B_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 735
  { IMAGE_GATHER4_B_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 736
  { IMAGE_GATHER4_B_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 737
  { IMAGE_GATHER4_B_O_V2_V3, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x3 }, // 738
  { IMAGE_GATHER4_B_O_V2_V4, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x4 }, // 739
  { IMAGE_GATHER4_B_O_V2_V5, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x5 }, // 740
  { IMAGE_GATHER4_B_O_V2_V8, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x8 }, // 741
  { IMAGE_GATHER4_B_O_V4_V3, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x3 }, // 742
  { IMAGE_GATHER4_B_O_V4_V4, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x4 }, // 743
  { IMAGE_GATHER4_B_O_V4_V5, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x5 }, // 744
  { IMAGE_GATHER4_B_O_V4_V8, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x8 }, // 745
  { IMAGE_GATHER4_B_O_V5_V3, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x5, 0x3 }, // 746
  { IMAGE_GATHER4_B_O_V5_V4, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x5, 0x4 }, // 747
  { IMAGE_GATHER4_B_O_V5_V5, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x5, 0x5 }, // 748
  { IMAGE_GATHER4_B_O_V5_V8, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x5, 0x8 }, // 749
  { IMAGE_GATHER4_C_V2_V2_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x2, 0x2 }, // 750
  { IMAGE_GATHER4_C_V2_V3_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x2, 0x3 }, // 751
  { IMAGE_GATHER4_C_V2_V4_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x2, 0x4 }, // 752
  { IMAGE_GATHER4_C_V4_V2_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x4, 0x2 }, // 753
  { IMAGE_GATHER4_C_V4_V3_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x4, 0x3 }, // 754
  { IMAGE_GATHER4_C_V4_V4_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x4, 0x4 }, // 755
  { IMAGE_GATHER4_C_V5_V2_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x5, 0x2 }, // 756
  { IMAGE_GATHER4_C_V5_V3_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x5, 0x3 }, // 757
  { IMAGE_GATHER4_C_V5_V4_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x5, 0x4 }, // 758
  { IMAGE_GATHER4_C_V2_V2_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x2, 0x2 }, // 759
  { IMAGE_GATHER4_C_V2_V3_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x2, 0x3 }, // 760
  { IMAGE_GATHER4_C_V2_V4_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x2, 0x4 }, // 761
  { IMAGE_GATHER4_C_V4_V2_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x4, 0x2 }, // 762
  { IMAGE_GATHER4_C_V4_V3_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x4, 0x3 }, // 763
  { IMAGE_GATHER4_C_V4_V4_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x4, 0x4 }, // 764
  { IMAGE_GATHER4_C_V5_V2_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x5, 0x2 }, // 765
  { IMAGE_GATHER4_C_V5_V3_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x5, 0x3 }, // 766
  { IMAGE_GATHER4_C_V5_V4_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x5, 0x4 }, // 767
  { IMAGE_GATHER4_C_V2_V2, IMAGE_GATHER4_C, MIMGEncGfx6, 0x2, 0x2 }, // 768
  { IMAGE_GATHER4_C_V2_V3, IMAGE_GATHER4_C, MIMGEncGfx6, 0x2, 0x3 }, // 769
  { IMAGE_GATHER4_C_V2_V4, IMAGE_GATHER4_C, MIMGEncGfx6, 0x2, 0x4 }, // 770
  { IMAGE_GATHER4_C_V4_V2, IMAGE_GATHER4_C, MIMGEncGfx6, 0x4, 0x2 }, // 771
  { IMAGE_GATHER4_C_V4_V3, IMAGE_GATHER4_C, MIMGEncGfx6, 0x4, 0x3 }, // 772
  { IMAGE_GATHER4_C_V4_V4, IMAGE_GATHER4_C, MIMGEncGfx6, 0x4, 0x4 }, // 773
  { IMAGE_GATHER4_C_V5_V2, IMAGE_GATHER4_C, MIMGEncGfx6, 0x5, 0x2 }, // 774
  { IMAGE_GATHER4_C_V5_V3, IMAGE_GATHER4_C, MIMGEncGfx6, 0x5, 0x3 }, // 775
  { IMAGE_GATHER4_C_V5_V4, IMAGE_GATHER4_C, MIMGEncGfx6, 0x5, 0x4 }, // 776
  { IMAGE_GATHER4_CL_V2_V1_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x2, 0x1 }, // 777
  { IMAGE_GATHER4_CL_V2_V2_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x2, 0x2 }, // 778
  { IMAGE_GATHER4_CL_V2_V3_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x2, 0x3 }, // 779
  { IMAGE_GATHER4_CL_V2_V4_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x2, 0x4 }, // 780
  { IMAGE_GATHER4_CL_V4_V1_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x4, 0x1 }, // 781
  { IMAGE_GATHER4_CL_V4_V2_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x4, 0x2 }, // 782
  { IMAGE_GATHER4_CL_V4_V3_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x4, 0x3 }, // 783
  { IMAGE_GATHER4_CL_V4_V4_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x4, 0x4 }, // 784
  { IMAGE_GATHER4_CL_V5_V1_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x5, 0x1 }, // 785
  { IMAGE_GATHER4_CL_V5_V2_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x5, 0x2 }, // 786
  { IMAGE_GATHER4_CL_V5_V3_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x5, 0x3 }, // 787
  { IMAGE_GATHER4_CL_V5_V4_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x5, 0x4 }, // 788
  { IMAGE_GATHER4_CL_V2_V2_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x2, 0x2 }, // 789
  { IMAGE_GATHER4_CL_V2_V3_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x2, 0x3 }, // 790
  { IMAGE_GATHER4_CL_V2_V4_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x2, 0x4 }, // 791
  { IMAGE_GATHER4_CL_V4_V2_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x4, 0x2 }, // 792
  { IMAGE_GATHER4_CL_V4_V3_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x4, 0x3 }, // 793
  { IMAGE_GATHER4_CL_V4_V4_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x4, 0x4 }, // 794
  { IMAGE_GATHER4_CL_V5_V2_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x5, 0x2 }, // 795
  { IMAGE_GATHER4_CL_V5_V3_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x5, 0x3 }, // 796
  { IMAGE_GATHER4_CL_V5_V4_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x5, 0x4 }, // 797
  { IMAGE_GATHER4_CL_V2_V1, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x1 }, // 798
  { IMAGE_GATHER4_CL_V2_V2, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x2 }, // 799
  { IMAGE_GATHER4_CL_V2_V3, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x3 }, // 800
  { IMAGE_GATHER4_CL_V2_V4, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x4 }, // 801
  { IMAGE_GATHER4_CL_V4_V1, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x1 }, // 802
  { IMAGE_GATHER4_CL_V4_V2, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x2 }, // 803
  { IMAGE_GATHER4_CL_V4_V3, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x3 }, // 804
  { IMAGE_GATHER4_CL_V4_V4, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x4 }, // 805
  { IMAGE_GATHER4_CL_V5_V1, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x5, 0x1 }, // 806
  { IMAGE_GATHER4_CL_V5_V2, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x5, 0x2 }, // 807
  { IMAGE_GATHER4_CL_V5_V3, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x5, 0x3 }, // 808
  { IMAGE_GATHER4_CL_V5_V4, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x5, 0x4 }, // 809
  { IMAGE_GATHER4_CL_O_V2_V2_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x2 }, // 810
  { IMAGE_GATHER4_CL_O_V2_V3_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 811
  { IMAGE_GATHER4_CL_O_V2_V4_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 812
  { IMAGE_GATHER4_CL_O_V2_V5_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 813
  { IMAGE_GATHER4_CL_O_V2_V8_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 814
  { IMAGE_GATHER4_CL_O_V4_V2_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x2 }, // 815
  { IMAGE_GATHER4_CL_O_V4_V3_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 816
  { IMAGE_GATHER4_CL_O_V4_V4_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 817
  { IMAGE_GATHER4_CL_O_V4_V5_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 818
  { IMAGE_GATHER4_CL_O_V4_V8_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 819
  { IMAGE_GATHER4_CL_O_V5_V2_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x2 }, // 820
  { IMAGE_GATHER4_CL_O_V5_V3_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 821
  { IMAGE_GATHER4_CL_O_V5_V4_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 822
  { IMAGE_GATHER4_CL_O_V5_V5_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 823
  { IMAGE_GATHER4_CL_O_V5_V8_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 824
  { IMAGE_GATHER4_CL_O_V2_V2_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x2, 0x2 }, // 825
  { IMAGE_GATHER4_CL_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 826
  { IMAGE_GATHER4_CL_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 827
  { IMAGE_GATHER4_CL_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 828
  { IMAGE_GATHER4_CL_O_V4_V2_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x4, 0x2 }, // 829
  { IMAGE_GATHER4_CL_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 830
  { IMAGE_GATHER4_CL_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 831
  { IMAGE_GATHER4_CL_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 832
  { IMAGE_GATHER4_CL_O_V5_V2_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x5, 0x2 }, // 833
  { IMAGE_GATHER4_CL_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 834
  { IMAGE_GATHER4_CL_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 835
  { IMAGE_GATHER4_CL_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 836
  { IMAGE_GATHER4_CL_O_V2_V2, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x2 }, // 837
  { IMAGE_GATHER4_CL_O_V2_V3, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x3 }, // 838
  { IMAGE_GATHER4_CL_O_V2_V4, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 839
  { IMAGE_GATHER4_CL_O_V2_V5, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x5 }, // 840
  { IMAGE_GATHER4_CL_O_V2_V8, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 841
  { IMAGE_GATHER4_CL_O_V4_V2, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x2 }, // 842
  { IMAGE_GATHER4_CL_O_V4_V3, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x3 }, // 843
  { IMAGE_GATHER4_CL_O_V4_V4, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 844
  { IMAGE_GATHER4_CL_O_V4_V5, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x5 }, // 845
  { IMAGE_GATHER4_CL_O_V4_V8, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 846
  { IMAGE_GATHER4_CL_O_V5_V2, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x2 }, // 847
  { IMAGE_GATHER4_CL_O_V5_V3, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x3 }, // 848
  { IMAGE_GATHER4_CL_O_V5_V4, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x4 }, // 849
  { IMAGE_GATHER4_CL_O_V5_V5, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x5 }, // 850
  { IMAGE_GATHER4_CL_O_V5_V8, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x8 }, // 851
  { IMAGE_GATHER4_C_B_V2_V3_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x2, 0x3 }, // 852
  { IMAGE_GATHER4_C_B_V2_V4_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x2, 0x4 }, // 853
  { IMAGE_GATHER4_C_B_V2_V5_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x2, 0x5 }, // 854
  { IMAGE_GATHER4_C_B_V2_V8_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x2, 0x8 }, // 855
  { IMAGE_GATHER4_C_B_V4_V3_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x4, 0x3 }, // 856
  { IMAGE_GATHER4_C_B_V4_V4_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x4, 0x4 }, // 857
  { IMAGE_GATHER4_C_B_V4_V5_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x4, 0x5 }, // 858
  { IMAGE_GATHER4_C_B_V4_V8_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x4, 0x8 }, // 859
  { IMAGE_GATHER4_C_B_V5_V3_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x5, 0x3 }, // 860
  { IMAGE_GATHER4_C_B_V5_V4_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x5, 0x4 }, // 861
  { IMAGE_GATHER4_C_B_V5_V5_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x5, 0x5 }, // 862
  { IMAGE_GATHER4_C_B_V5_V8_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x5, 0x8 }, // 863
  { IMAGE_GATHER4_C_B_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x2, 0x3 }, // 864
  { IMAGE_GATHER4_C_B_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x2, 0x4 }, // 865
  { IMAGE_GATHER4_C_B_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x2, 0x5 }, // 866
  { IMAGE_GATHER4_C_B_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x4, 0x3 }, // 867
  { IMAGE_GATHER4_C_B_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x4, 0x4 }, // 868
  { IMAGE_GATHER4_C_B_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x4, 0x5 }, // 869
  { IMAGE_GATHER4_C_B_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x5, 0x3 }, // 870
  { IMAGE_GATHER4_C_B_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x5, 0x4 }, // 871
  { IMAGE_GATHER4_C_B_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x5, 0x5 }, // 872
  { IMAGE_GATHER4_C_B_V2_V3, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x3 }, // 873
  { IMAGE_GATHER4_C_B_V2_V4, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x4 }, // 874
  { IMAGE_GATHER4_C_B_V2_V5, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x5 }, // 875
  { IMAGE_GATHER4_C_B_V2_V8, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x8 }, // 876
  { IMAGE_GATHER4_C_B_V4_V3, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x3 }, // 877
  { IMAGE_GATHER4_C_B_V4_V4, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x4 }, // 878
  { IMAGE_GATHER4_C_B_V4_V5, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x5 }, // 879
  { IMAGE_GATHER4_C_B_V4_V8, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x8 }, // 880
  { IMAGE_GATHER4_C_B_V5_V3, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x5, 0x3 }, // 881
  { IMAGE_GATHER4_C_B_V5_V4, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x5, 0x4 }, // 882
  { IMAGE_GATHER4_C_B_V5_V5, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x5, 0x5 }, // 883
  { IMAGE_GATHER4_C_B_V5_V8, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x5, 0x8 }, // 884
  { IMAGE_GATHER4_C_B_CL_V2_V3_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x3 }, // 885
  { IMAGE_GATHER4_C_B_CL_V2_V4_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x4 }, // 886
  { IMAGE_GATHER4_C_B_CL_V2_V5_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x5 }, // 887
  { IMAGE_GATHER4_C_B_CL_V2_V6_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x6 }, // 888
  { IMAGE_GATHER4_C_B_CL_V2_V8_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x8 }, // 889
  { IMAGE_GATHER4_C_B_CL_V4_V3_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x3 }, // 890
  { IMAGE_GATHER4_C_B_CL_V4_V4_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x4 }, // 891
  { IMAGE_GATHER4_C_B_CL_V4_V5_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x5 }, // 892
  { IMAGE_GATHER4_C_B_CL_V4_V6_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x6 }, // 893
  { IMAGE_GATHER4_C_B_CL_V4_V8_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x8 }, // 894
  { IMAGE_GATHER4_C_B_CL_V5_V3_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x3 }, // 895
  { IMAGE_GATHER4_C_B_CL_V5_V4_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x4 }, // 896
  { IMAGE_GATHER4_C_B_CL_V5_V5_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x5 }, // 897
  { IMAGE_GATHER4_C_B_CL_V5_V6_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x6 }, // 898
  { IMAGE_GATHER4_C_B_CL_V5_V8_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x8 }, // 899
  { IMAGE_GATHER4_C_B_CL_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x3 }, // 900
  { IMAGE_GATHER4_C_B_CL_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x4 }, // 901
  { IMAGE_GATHER4_C_B_CL_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x5 }, // 902
  { IMAGE_GATHER4_C_B_CL_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x6 }, // 903
  { IMAGE_GATHER4_C_B_CL_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x3 }, // 904
  { IMAGE_GATHER4_C_B_CL_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x4 }, // 905
  { IMAGE_GATHER4_C_B_CL_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x5 }, // 906
  { IMAGE_GATHER4_C_B_CL_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x6 }, // 907
  { IMAGE_GATHER4_C_B_CL_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x3 }, // 908
  { IMAGE_GATHER4_C_B_CL_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x4 }, // 909
  { IMAGE_GATHER4_C_B_CL_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x5 }, // 910
  { IMAGE_GATHER4_C_B_CL_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x6 }, // 911
  { IMAGE_GATHER4_C_B_CL_V2_V3, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x3 }, // 912
  { IMAGE_GATHER4_C_B_CL_V2_V4, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x4 }, // 913
  { IMAGE_GATHER4_C_B_CL_V2_V5, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x5 }, // 914
  { IMAGE_GATHER4_C_B_CL_V2_V6, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x6 }, // 915
  { IMAGE_GATHER4_C_B_CL_V2_V8, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x8 }, // 916
  { IMAGE_GATHER4_C_B_CL_V4_V3, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x3 }, // 917
  { IMAGE_GATHER4_C_B_CL_V4_V4, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x4 }, // 918
  { IMAGE_GATHER4_C_B_CL_V4_V5, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x5 }, // 919
  { IMAGE_GATHER4_C_B_CL_V4_V6, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x6 }, // 920
  { IMAGE_GATHER4_C_B_CL_V4_V8, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x8 }, // 921
  { IMAGE_GATHER4_C_B_CL_V5_V3, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x3 }, // 922
  { IMAGE_GATHER4_C_B_CL_V5_V4, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x4 }, // 923
  { IMAGE_GATHER4_C_B_CL_V5_V5, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x5 }, // 924
  { IMAGE_GATHER4_C_B_CL_V5_V6, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x6 }, // 925
  { IMAGE_GATHER4_C_B_CL_V5_V8, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x8 }, // 926
  { IMAGE_GATHER4_C_B_CL_O_V2_V4_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 927
  { IMAGE_GATHER4_C_B_CL_O_V2_V5_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 928
  { IMAGE_GATHER4_C_B_CL_O_V2_V6_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x6 }, // 929
  { IMAGE_GATHER4_C_B_CL_O_V2_V7_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x7 }, // 930
  { IMAGE_GATHER4_C_B_CL_O_V2_V8_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 931
  { IMAGE_GATHER4_C_B_CL_O_V4_V4_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 932
  { IMAGE_GATHER4_C_B_CL_O_V4_V5_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 933
  { IMAGE_GATHER4_C_B_CL_O_V4_V6_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x6 }, // 934
  { IMAGE_GATHER4_C_B_CL_O_V4_V7_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x7 }, // 935
  { IMAGE_GATHER4_C_B_CL_O_V4_V8_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 936
  { IMAGE_GATHER4_C_B_CL_O_V5_V4_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 937
  { IMAGE_GATHER4_C_B_CL_O_V5_V5_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 938
  { IMAGE_GATHER4_C_B_CL_O_V5_V6_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x6 }, // 939
  { IMAGE_GATHER4_C_B_CL_O_V5_V7_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x7 }, // 940
  { IMAGE_GATHER4_C_B_CL_O_V5_V8_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 941
  { IMAGE_GATHER4_C_B_CL_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 942
  { IMAGE_GATHER4_C_B_CL_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 943
  { IMAGE_GATHER4_C_B_CL_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x6 }, // 944
  { IMAGE_GATHER4_C_B_CL_O_V2_V7_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x7 }, // 945
  { IMAGE_GATHER4_C_B_CL_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 946
  { IMAGE_GATHER4_C_B_CL_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 947
  { IMAGE_GATHER4_C_B_CL_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x6 }, // 948
  { IMAGE_GATHER4_C_B_CL_O_V4_V7_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x7 }, // 949
  { IMAGE_GATHER4_C_B_CL_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 950
  { IMAGE_GATHER4_C_B_CL_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 951
  { IMAGE_GATHER4_C_B_CL_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x6 }, // 952
  { IMAGE_GATHER4_C_B_CL_O_V5_V7_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x7 }, // 953
  { IMAGE_GATHER4_C_B_CL_O_V2_V4, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 954
  { IMAGE_GATHER4_C_B_CL_O_V2_V5, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x5 }, // 955
  { IMAGE_GATHER4_C_B_CL_O_V2_V6, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x6 }, // 956
  { IMAGE_GATHER4_C_B_CL_O_V2_V7, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x7 }, // 957
  { IMAGE_GATHER4_C_B_CL_O_V2_V8, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 958
  { IMAGE_GATHER4_C_B_CL_O_V4_V4, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 959
  { IMAGE_GATHER4_C_B_CL_O_V4_V5, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x5 }, // 960
  { IMAGE_GATHER4_C_B_CL_O_V4_V6, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x6 }, // 961
  { IMAGE_GATHER4_C_B_CL_O_V4_V7, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x7 }, // 962
  { IMAGE_GATHER4_C_B_CL_O_V4_V8, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 963
  { IMAGE_GATHER4_C_B_CL_O_V5_V4, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x4 }, // 964
  { IMAGE_GATHER4_C_B_CL_O_V5_V5, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x5 }, // 965
  { IMAGE_GATHER4_C_B_CL_O_V5_V6, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x6 }, // 966
  { IMAGE_GATHER4_C_B_CL_O_V5_V7, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x7 }, // 967
  { IMAGE_GATHER4_C_B_CL_O_V5_V8, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x8 }, // 968
  { IMAGE_GATHER4_C_B_O_V2_V4_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 969
  { IMAGE_GATHER4_C_B_O_V2_V5_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 970
  { IMAGE_GATHER4_C_B_O_V2_V6_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x2, 0x6 }, // 971
  { IMAGE_GATHER4_C_B_O_V2_V8_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 972
  { IMAGE_GATHER4_C_B_O_V4_V4_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 973
  { IMAGE_GATHER4_C_B_O_V4_V5_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 974
  { IMAGE_GATHER4_C_B_O_V4_V6_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x4, 0x6 }, // 975
  { IMAGE_GATHER4_C_B_O_V4_V8_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 976
  { IMAGE_GATHER4_C_B_O_V5_V4_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 977
  { IMAGE_GATHER4_C_B_O_V5_V5_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 978
  { IMAGE_GATHER4_C_B_O_V5_V6_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x5, 0x6 }, // 979
  { IMAGE_GATHER4_C_B_O_V5_V8_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 980
  { IMAGE_GATHER4_C_B_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 981
  { IMAGE_GATHER4_C_B_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 982
  { IMAGE_GATHER4_C_B_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x2, 0x6 }, // 983
  { IMAGE_GATHER4_C_B_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 984
  { IMAGE_GATHER4_C_B_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 985
  { IMAGE_GATHER4_C_B_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x4, 0x6 }, // 986
  { IMAGE_GATHER4_C_B_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 987
  { IMAGE_GATHER4_C_B_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 988
  { IMAGE_GATHER4_C_B_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x5, 0x6 }, // 989
  { IMAGE_GATHER4_C_B_O_V2_V4, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x4 }, // 990
  { IMAGE_GATHER4_C_B_O_V2_V5, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x5 }, // 991
  { IMAGE_GATHER4_C_B_O_V2_V6, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x6 }, // 992
  { IMAGE_GATHER4_C_B_O_V2_V8, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x8 }, // 993
  { IMAGE_GATHER4_C_B_O_V4_V4, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x4 }, // 994
  { IMAGE_GATHER4_C_B_O_V4_V5, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x5 }, // 995
  { IMAGE_GATHER4_C_B_O_V4_V6, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x6 }, // 996
  { IMAGE_GATHER4_C_B_O_V4_V8, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x8 }, // 997
  { IMAGE_GATHER4_C_B_O_V5_V4, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x5, 0x4 }, // 998
  { IMAGE_GATHER4_C_B_O_V5_V5, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x5, 0x5 }, // 999
  { IMAGE_GATHER4_C_B_O_V5_V6, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x5, 0x6 }, // 1000
  { IMAGE_GATHER4_C_B_O_V5_V8, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x5, 0x8 }, // 1001
  { IMAGE_GATHER4_C_CL_V2_V2_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x2 }, // 1002
  { IMAGE_GATHER4_C_CL_V2_V3_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x3 }, // 1003
  { IMAGE_GATHER4_C_CL_V2_V4_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x4 }, // 1004
  { IMAGE_GATHER4_C_CL_V2_V5_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x5 }, // 1005
  { IMAGE_GATHER4_C_CL_V2_V8_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x8 }, // 1006
  { IMAGE_GATHER4_C_CL_V4_V2_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x2 }, // 1007
  { IMAGE_GATHER4_C_CL_V4_V3_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x3 }, // 1008
  { IMAGE_GATHER4_C_CL_V4_V4_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x4 }, // 1009
  { IMAGE_GATHER4_C_CL_V4_V5_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x5 }, // 1010
  { IMAGE_GATHER4_C_CL_V4_V8_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x8 }, // 1011
  { IMAGE_GATHER4_C_CL_V5_V2_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x2 }, // 1012
  { IMAGE_GATHER4_C_CL_V5_V3_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x3 }, // 1013
  { IMAGE_GATHER4_C_CL_V5_V4_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x4 }, // 1014
  { IMAGE_GATHER4_C_CL_V5_V5_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x5 }, // 1015
  { IMAGE_GATHER4_C_CL_V5_V8_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x8 }, // 1016
  { IMAGE_GATHER4_C_CL_V2_V2_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x2, 0x2 }, // 1017
  { IMAGE_GATHER4_C_CL_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x2, 0x3 }, // 1018
  { IMAGE_GATHER4_C_CL_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x2, 0x4 }, // 1019
  { IMAGE_GATHER4_C_CL_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x2, 0x5 }, // 1020
  { IMAGE_GATHER4_C_CL_V4_V2_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x4, 0x2 }, // 1021
  { IMAGE_GATHER4_C_CL_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x4, 0x3 }, // 1022
  { IMAGE_GATHER4_C_CL_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x4, 0x4 }, // 1023
  { IMAGE_GATHER4_C_CL_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x4, 0x5 }, // 1024
  { IMAGE_GATHER4_C_CL_V5_V2_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x5, 0x2 }, // 1025
  { IMAGE_GATHER4_C_CL_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x5, 0x3 }, // 1026
  { IMAGE_GATHER4_C_CL_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x5, 0x4 }, // 1027
  { IMAGE_GATHER4_C_CL_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x5, 0x5 }, // 1028
  { IMAGE_GATHER4_C_CL_V2_V2, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x2 }, // 1029
  { IMAGE_GATHER4_C_CL_V2_V3, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x3 }, // 1030
  { IMAGE_GATHER4_C_CL_V2_V4, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x4 }, // 1031
  { IMAGE_GATHER4_C_CL_V2_V5, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x5 }, // 1032
  { IMAGE_GATHER4_C_CL_V2_V8, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x8 }, // 1033
  { IMAGE_GATHER4_C_CL_V4_V2, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x2 }, // 1034
  { IMAGE_GATHER4_C_CL_V4_V3, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x3 }, // 1035
  { IMAGE_GATHER4_C_CL_V4_V4, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x4 }, // 1036
  { IMAGE_GATHER4_C_CL_V4_V5, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x5 }, // 1037
  { IMAGE_GATHER4_C_CL_V4_V8, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x8 }, // 1038
  { IMAGE_GATHER4_C_CL_V5_V2, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x2 }, // 1039
  { IMAGE_GATHER4_C_CL_V5_V3, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x3 }, // 1040
  { IMAGE_GATHER4_C_CL_V5_V4, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x4 }, // 1041
  { IMAGE_GATHER4_C_CL_V5_V5, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x5 }, // 1042
  { IMAGE_GATHER4_C_CL_V5_V8, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x8 }, // 1043
  { IMAGE_GATHER4_C_CL_O_V2_V3_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 1044
  { IMAGE_GATHER4_C_CL_O_V2_V4_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 1045
  { IMAGE_GATHER4_C_CL_O_V2_V5_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 1046
  { IMAGE_GATHER4_C_CL_O_V2_V6_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x6 }, // 1047
  { IMAGE_GATHER4_C_CL_O_V2_V8_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 1048
  { IMAGE_GATHER4_C_CL_O_V4_V3_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 1049
  { IMAGE_GATHER4_C_CL_O_V4_V4_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 1050
  { IMAGE_GATHER4_C_CL_O_V4_V5_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 1051
  { IMAGE_GATHER4_C_CL_O_V4_V6_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x6 }, // 1052
  { IMAGE_GATHER4_C_CL_O_V4_V8_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 1053
  { IMAGE_GATHER4_C_CL_O_V5_V3_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 1054
  { IMAGE_GATHER4_C_CL_O_V5_V4_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 1055
  { IMAGE_GATHER4_C_CL_O_V5_V5_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 1056
  { IMAGE_GATHER4_C_CL_O_V5_V6_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x6 }, // 1057
  { IMAGE_GATHER4_C_CL_O_V5_V8_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 1058
  { IMAGE_GATHER4_C_CL_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 1059
  { IMAGE_GATHER4_C_CL_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 1060
  { IMAGE_GATHER4_C_CL_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 1061
  { IMAGE_GATHER4_C_CL_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x6 }, // 1062
  { IMAGE_GATHER4_C_CL_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 1063
  { IMAGE_GATHER4_C_CL_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 1064
  { IMAGE_GATHER4_C_CL_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 1065
  { IMAGE_GATHER4_C_CL_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x6 }, // 1066
  { IMAGE_GATHER4_C_CL_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 1067
  { IMAGE_GATHER4_C_CL_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 1068
  { IMAGE_GATHER4_C_CL_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 1069
  { IMAGE_GATHER4_C_CL_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x6 }, // 1070
  { IMAGE_GATHER4_C_CL_O_V2_V3, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x3 }, // 1071
  { IMAGE_GATHER4_C_CL_O_V2_V4, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 1072
  { IMAGE_GATHER4_C_CL_O_V2_V5, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x5 }, // 1073
  { IMAGE_GATHER4_C_CL_O_V2_V6, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x6 }, // 1074
  { IMAGE_GATHER4_C_CL_O_V2_V8, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 1075
  { IMAGE_GATHER4_C_CL_O_V4_V3, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x3 }, // 1076
  { IMAGE_GATHER4_C_CL_O_V4_V4, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 1077
  { IMAGE_GATHER4_C_CL_O_V4_V5, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x5 }, // 1078
  { IMAGE_GATHER4_C_CL_O_V4_V6, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x6 }, // 1079
  { IMAGE_GATHER4_C_CL_O_V4_V8, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 1080
  { IMAGE_GATHER4_C_CL_O_V5_V3, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x3 }, // 1081
  { IMAGE_GATHER4_C_CL_O_V5_V4, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x4 }, // 1082
  { IMAGE_GATHER4_C_CL_O_V5_V5, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x5 }, // 1083
  { IMAGE_GATHER4_C_CL_O_V5_V6, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x6 }, // 1084
  { IMAGE_GATHER4_C_CL_O_V5_V8, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x8 }, // 1085
  { IMAGE_GATHER4_C_L_V2_V2_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x2 }, // 1086
  { IMAGE_GATHER4_C_L_V2_V3_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x3 }, // 1087
  { IMAGE_GATHER4_C_L_V2_V4_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x4 }, // 1088
  { IMAGE_GATHER4_C_L_V2_V5_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x5 }, // 1089
  { IMAGE_GATHER4_C_L_V2_V8_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x8 }, // 1090
  { IMAGE_GATHER4_C_L_V4_V2_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x2 }, // 1091
  { IMAGE_GATHER4_C_L_V4_V3_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x3 }, // 1092
  { IMAGE_GATHER4_C_L_V4_V4_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x4 }, // 1093
  { IMAGE_GATHER4_C_L_V4_V5_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x5 }, // 1094
  { IMAGE_GATHER4_C_L_V4_V8_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x8 }, // 1095
  { IMAGE_GATHER4_C_L_V5_V2_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x2 }, // 1096
  { IMAGE_GATHER4_C_L_V5_V3_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x3 }, // 1097
  { IMAGE_GATHER4_C_L_V5_V4_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x4 }, // 1098
  { IMAGE_GATHER4_C_L_V5_V5_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x5 }, // 1099
  { IMAGE_GATHER4_C_L_V5_V8_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x8 }, // 1100
  { IMAGE_GATHER4_C_L_V2_V2_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x2, 0x2 }, // 1101
  { IMAGE_GATHER4_C_L_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x2, 0x3 }, // 1102
  { IMAGE_GATHER4_C_L_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x2, 0x4 }, // 1103
  { IMAGE_GATHER4_C_L_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x2, 0x5 }, // 1104
  { IMAGE_GATHER4_C_L_V4_V2_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x4, 0x2 }, // 1105
  { IMAGE_GATHER4_C_L_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x4, 0x3 }, // 1106
  { IMAGE_GATHER4_C_L_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x4, 0x4 }, // 1107
  { IMAGE_GATHER4_C_L_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x4, 0x5 }, // 1108
  { IMAGE_GATHER4_C_L_V5_V2_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x5, 0x2 }, // 1109
  { IMAGE_GATHER4_C_L_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x5, 0x3 }, // 1110
  { IMAGE_GATHER4_C_L_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x5, 0x4 }, // 1111
  { IMAGE_GATHER4_C_L_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x5, 0x5 }, // 1112
  { IMAGE_GATHER4_C_L_V2_V2, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x2 }, // 1113
  { IMAGE_GATHER4_C_L_V2_V3, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x3 }, // 1114
  { IMAGE_GATHER4_C_L_V2_V4, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x4 }, // 1115
  { IMAGE_GATHER4_C_L_V2_V5, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x5 }, // 1116
  { IMAGE_GATHER4_C_L_V2_V8, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x8 }, // 1117
  { IMAGE_GATHER4_C_L_V4_V2, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x2 }, // 1118
  { IMAGE_GATHER4_C_L_V4_V3, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x3 }, // 1119
  { IMAGE_GATHER4_C_L_V4_V4, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x4 }, // 1120
  { IMAGE_GATHER4_C_L_V4_V5, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x5 }, // 1121
  { IMAGE_GATHER4_C_L_V4_V8, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x8 }, // 1122
  { IMAGE_GATHER4_C_L_V5_V2, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x2 }, // 1123
  { IMAGE_GATHER4_C_L_V5_V3, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x3 }, // 1124
  { IMAGE_GATHER4_C_L_V5_V4, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x4 }, // 1125
  { IMAGE_GATHER4_C_L_V5_V5, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x5 }, // 1126
  { IMAGE_GATHER4_C_L_V5_V8, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x8 }, // 1127
  { IMAGE_GATHER4_C_LZ_V2_V2_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x2, 0x2 }, // 1128
  { IMAGE_GATHER4_C_LZ_V2_V3_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x2, 0x3 }, // 1129
  { IMAGE_GATHER4_C_LZ_V2_V4_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x2, 0x4 }, // 1130
  { IMAGE_GATHER4_C_LZ_V4_V2_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x4, 0x2 }, // 1131
  { IMAGE_GATHER4_C_LZ_V4_V3_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x4, 0x3 }, // 1132
  { IMAGE_GATHER4_C_LZ_V4_V4_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x4, 0x4 }, // 1133
  { IMAGE_GATHER4_C_LZ_V5_V2_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x5, 0x2 }, // 1134
  { IMAGE_GATHER4_C_LZ_V5_V3_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x5, 0x3 }, // 1135
  { IMAGE_GATHER4_C_LZ_V5_V4_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x5, 0x4 }, // 1136
  { IMAGE_GATHER4_C_LZ_V2_V2_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x2, 0x2 }, // 1137
  { IMAGE_GATHER4_C_LZ_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x2, 0x3 }, // 1138
  { IMAGE_GATHER4_C_LZ_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x2, 0x4 }, // 1139
  { IMAGE_GATHER4_C_LZ_V4_V2_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x4, 0x2 }, // 1140
  { IMAGE_GATHER4_C_LZ_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x4, 0x3 }, // 1141
  { IMAGE_GATHER4_C_LZ_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x4, 0x4 }, // 1142
  { IMAGE_GATHER4_C_LZ_V5_V2_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x5, 0x2 }, // 1143
  { IMAGE_GATHER4_C_LZ_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x5, 0x3 }, // 1144
  { IMAGE_GATHER4_C_LZ_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x5, 0x4 }, // 1145
  { IMAGE_GATHER4_C_LZ_V2_V2, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x2, 0x2 }, // 1146
  { IMAGE_GATHER4_C_LZ_V2_V3, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x2, 0x3 }, // 1147
  { IMAGE_GATHER4_C_LZ_V2_V4, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x2, 0x4 }, // 1148
  { IMAGE_GATHER4_C_LZ_V4_V2, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x4, 0x2 }, // 1149
  { IMAGE_GATHER4_C_LZ_V4_V3, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x4, 0x3 }, // 1150
  { IMAGE_GATHER4_C_LZ_V4_V4, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x4, 0x4 }, // 1151
  { IMAGE_GATHER4_C_LZ_V5_V2, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x5, 0x2 }, // 1152
  { IMAGE_GATHER4_C_LZ_V5_V3, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x5, 0x3 }, // 1153
  { IMAGE_GATHER4_C_LZ_V5_V4, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x5, 0x4 }, // 1154
  { IMAGE_GATHER4_C_LZ_O_V2_V3_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 1155
  { IMAGE_GATHER4_C_LZ_O_V2_V4_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 1156
  { IMAGE_GATHER4_C_LZ_O_V2_V5_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 1157
  { IMAGE_GATHER4_C_LZ_O_V2_V8_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 1158
  { IMAGE_GATHER4_C_LZ_O_V4_V3_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 1159
  { IMAGE_GATHER4_C_LZ_O_V4_V4_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 1160
  { IMAGE_GATHER4_C_LZ_O_V4_V5_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 1161
  { IMAGE_GATHER4_C_LZ_O_V4_V8_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 1162
  { IMAGE_GATHER4_C_LZ_O_V5_V3_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 1163
  { IMAGE_GATHER4_C_LZ_O_V5_V4_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 1164
  { IMAGE_GATHER4_C_LZ_O_V5_V5_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 1165
  { IMAGE_GATHER4_C_LZ_O_V5_V8_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 1166
  { IMAGE_GATHER4_C_LZ_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 1167
  { IMAGE_GATHER4_C_LZ_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 1168
  { IMAGE_GATHER4_C_LZ_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 1169
  { IMAGE_GATHER4_C_LZ_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 1170
  { IMAGE_GATHER4_C_LZ_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 1171
  { IMAGE_GATHER4_C_LZ_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 1172
  { IMAGE_GATHER4_C_LZ_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 1173
  { IMAGE_GATHER4_C_LZ_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 1174
  { IMAGE_GATHER4_C_LZ_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 1175
  { IMAGE_GATHER4_C_LZ_O_V2_V3, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x3 }, // 1176
  { IMAGE_GATHER4_C_LZ_O_V2_V4, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x4 }, // 1177
  { IMAGE_GATHER4_C_LZ_O_V2_V5, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x5 }, // 1178
  { IMAGE_GATHER4_C_LZ_O_V2_V8, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x8 }, // 1179
  { IMAGE_GATHER4_C_LZ_O_V4_V3, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x3 }, // 1180
  { IMAGE_GATHER4_C_LZ_O_V4_V4, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x4 }, // 1181
  { IMAGE_GATHER4_C_LZ_O_V4_V5, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x5 }, // 1182
  { IMAGE_GATHER4_C_LZ_O_V4_V8, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x8 }, // 1183
  { IMAGE_GATHER4_C_LZ_O_V5_V3, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x5, 0x3 }, // 1184
  { IMAGE_GATHER4_C_LZ_O_V5_V4, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x5, 0x4 }, // 1185
  { IMAGE_GATHER4_C_LZ_O_V5_V5, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x5, 0x5 }, // 1186
  { IMAGE_GATHER4_C_LZ_O_V5_V8, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x5, 0x8 }, // 1187
  { IMAGE_GATHER4_C_L_O_V2_V3_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 1188
  { IMAGE_GATHER4_C_L_O_V2_V4_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 1189
  { IMAGE_GATHER4_C_L_O_V2_V5_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 1190
  { IMAGE_GATHER4_C_L_O_V2_V6_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x6 }, // 1191
  { IMAGE_GATHER4_C_L_O_V2_V8_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 1192
  { IMAGE_GATHER4_C_L_O_V4_V3_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 1193
  { IMAGE_GATHER4_C_L_O_V4_V4_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 1194
  { IMAGE_GATHER4_C_L_O_V4_V5_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 1195
  { IMAGE_GATHER4_C_L_O_V4_V6_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x6 }, // 1196
  { IMAGE_GATHER4_C_L_O_V4_V8_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 1197
  { IMAGE_GATHER4_C_L_O_V5_V3_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 1198
  { IMAGE_GATHER4_C_L_O_V5_V4_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 1199
  { IMAGE_GATHER4_C_L_O_V5_V5_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 1200
  { IMAGE_GATHER4_C_L_O_V5_V6_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x6 }, // 1201
  { IMAGE_GATHER4_C_L_O_V5_V8_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 1202
  { IMAGE_GATHER4_C_L_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 1203
  { IMAGE_GATHER4_C_L_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 1204
  { IMAGE_GATHER4_C_L_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 1205
  { IMAGE_GATHER4_C_L_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x2, 0x6 }, // 1206
  { IMAGE_GATHER4_C_L_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 1207
  { IMAGE_GATHER4_C_L_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 1208
  { IMAGE_GATHER4_C_L_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 1209
  { IMAGE_GATHER4_C_L_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x4, 0x6 }, // 1210
  { IMAGE_GATHER4_C_L_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 1211
  { IMAGE_GATHER4_C_L_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 1212
  { IMAGE_GATHER4_C_L_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 1213
  { IMAGE_GATHER4_C_L_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x5, 0x6 }, // 1214
  { IMAGE_GATHER4_C_L_O_V2_V3, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x3 }, // 1215
  { IMAGE_GATHER4_C_L_O_V2_V4, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x4 }, // 1216
  { IMAGE_GATHER4_C_L_O_V2_V5, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x5 }, // 1217
  { IMAGE_GATHER4_C_L_O_V2_V6, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x6 }, // 1218
  { IMAGE_GATHER4_C_L_O_V2_V8, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x8 }, // 1219
  { IMAGE_GATHER4_C_L_O_V4_V3, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x3 }, // 1220
  { IMAGE_GATHER4_C_L_O_V4_V4, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x4 }, // 1221
  { IMAGE_GATHER4_C_L_O_V4_V5, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x5 }, // 1222
  { IMAGE_GATHER4_C_L_O_V4_V6, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x6 }, // 1223
  { IMAGE_GATHER4_C_L_O_V4_V8, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x8 }, // 1224
  { IMAGE_GATHER4_C_L_O_V5_V3, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x3 }, // 1225
  { IMAGE_GATHER4_C_L_O_V5_V4, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x4 }, // 1226
  { IMAGE_GATHER4_C_L_O_V5_V5, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x5 }, // 1227
  { IMAGE_GATHER4_C_L_O_V5_V6, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x6 }, // 1228
  { IMAGE_GATHER4_C_L_O_V5_V8, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x8 }, // 1229
  { IMAGE_GATHER4_C_O_V2_V3_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 1230
  { IMAGE_GATHER4_C_O_V2_V4_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 1231
  { IMAGE_GATHER4_C_O_V2_V5_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 1232
  { IMAGE_GATHER4_C_O_V2_V8_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 1233
  { IMAGE_GATHER4_C_O_V4_V3_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 1234
  { IMAGE_GATHER4_C_O_V4_V4_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 1235
  { IMAGE_GATHER4_C_O_V4_V5_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 1236
  { IMAGE_GATHER4_C_O_V4_V8_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 1237
  { IMAGE_GATHER4_C_O_V5_V3_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 1238
  { IMAGE_GATHER4_C_O_V5_V4_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 1239
  { IMAGE_GATHER4_C_O_V5_V5_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 1240
  { IMAGE_GATHER4_C_O_V5_V8_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 1241
  { IMAGE_GATHER4_C_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 1242
  { IMAGE_GATHER4_C_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 1243
  { IMAGE_GATHER4_C_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 1244
  { IMAGE_GATHER4_C_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 1245
  { IMAGE_GATHER4_C_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 1246
  { IMAGE_GATHER4_C_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 1247
  { IMAGE_GATHER4_C_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 1248
  { IMAGE_GATHER4_C_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 1249
  { IMAGE_GATHER4_C_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 1250
  { IMAGE_GATHER4_C_O_V2_V3, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x3 }, // 1251
  { IMAGE_GATHER4_C_O_V2_V4, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x4 }, // 1252
  { IMAGE_GATHER4_C_O_V2_V5, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x5 }, // 1253
  { IMAGE_GATHER4_C_O_V2_V8, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x8 }, // 1254
  { IMAGE_GATHER4_C_O_V4_V3, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x3 }, // 1255
  { IMAGE_GATHER4_C_O_V4_V4, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x4 }, // 1256
  { IMAGE_GATHER4_C_O_V4_V5, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x5 }, // 1257
  { IMAGE_GATHER4_C_O_V4_V8, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x8 }, // 1258
  { IMAGE_GATHER4_C_O_V5_V3, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x5, 0x3 }, // 1259
  { IMAGE_GATHER4_C_O_V5_V4, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x5, 0x4 }, // 1260
  { IMAGE_GATHER4_C_O_V5_V5, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x5, 0x5 }, // 1261
  { IMAGE_GATHER4_C_O_V5_V8, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x5, 0x8 }, // 1262
  { IMAGE_GATHER4_L_V2_V1_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x2, 0x1 }, // 1263
  { IMAGE_GATHER4_L_V2_V2_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x2, 0x2 }, // 1264
  { IMAGE_GATHER4_L_V2_V3_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x2, 0x3 }, // 1265
  { IMAGE_GATHER4_L_V2_V4_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x2, 0x4 }, // 1266
  { IMAGE_GATHER4_L_V4_V1_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x4, 0x1 }, // 1267
  { IMAGE_GATHER4_L_V4_V2_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x4, 0x2 }, // 1268
  { IMAGE_GATHER4_L_V4_V3_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x4, 0x3 }, // 1269
  { IMAGE_GATHER4_L_V4_V4_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x4, 0x4 }, // 1270
  { IMAGE_GATHER4_L_V5_V1_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x5, 0x1 }, // 1271
  { IMAGE_GATHER4_L_V5_V2_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x5, 0x2 }, // 1272
  { IMAGE_GATHER4_L_V5_V3_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x5, 0x3 }, // 1273
  { IMAGE_GATHER4_L_V5_V4_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x5, 0x4 }, // 1274
  { IMAGE_GATHER4_L_V2_V2_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x2, 0x2 }, // 1275
  { IMAGE_GATHER4_L_V2_V3_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x2, 0x3 }, // 1276
  { IMAGE_GATHER4_L_V2_V4_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x2, 0x4 }, // 1277
  { IMAGE_GATHER4_L_V4_V2_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x4, 0x2 }, // 1278
  { IMAGE_GATHER4_L_V4_V3_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x4, 0x3 }, // 1279
  { IMAGE_GATHER4_L_V4_V4_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x4, 0x4 }, // 1280
  { IMAGE_GATHER4_L_V5_V2_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x5, 0x2 }, // 1281
  { IMAGE_GATHER4_L_V5_V3_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x5, 0x3 }, // 1282
  { IMAGE_GATHER4_L_V5_V4_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x5, 0x4 }, // 1283
  { IMAGE_GATHER4_L_V2_V1, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x1 }, // 1284
  { IMAGE_GATHER4_L_V2_V2, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x2 }, // 1285
  { IMAGE_GATHER4_L_V2_V3, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x3 }, // 1286
  { IMAGE_GATHER4_L_V2_V4, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x4 }, // 1287
  { IMAGE_GATHER4_L_V4_V1, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x1 }, // 1288
  { IMAGE_GATHER4_L_V4_V2, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x2 }, // 1289
  { IMAGE_GATHER4_L_V4_V3, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x3 }, // 1290
  { IMAGE_GATHER4_L_V4_V4, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x4 }, // 1291
  { IMAGE_GATHER4_L_V5_V1, IMAGE_GATHER4_L, MIMGEncGfx6, 0x5, 0x1 }, // 1292
  { IMAGE_GATHER4_L_V5_V2, IMAGE_GATHER4_L, MIMGEncGfx6, 0x5, 0x2 }, // 1293
  { IMAGE_GATHER4_L_V5_V3, IMAGE_GATHER4_L, MIMGEncGfx6, 0x5, 0x3 }, // 1294
  { IMAGE_GATHER4_L_V5_V4, IMAGE_GATHER4_L, MIMGEncGfx6, 0x5, 0x4 }, // 1295
  { IMAGE_GATHER4_LZ_V2_V1_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x2, 0x1 }, // 1296
  { IMAGE_GATHER4_LZ_V2_V2_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x2, 0x2 }, // 1297
  { IMAGE_GATHER4_LZ_V2_V3_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x2, 0x3 }, // 1298
  { IMAGE_GATHER4_LZ_V2_V4_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x2, 0x4 }, // 1299
  { IMAGE_GATHER4_LZ_V4_V1_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x4, 0x1 }, // 1300
  { IMAGE_GATHER4_LZ_V4_V2_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x4, 0x2 }, // 1301
  { IMAGE_GATHER4_LZ_V4_V3_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x4, 0x3 }, // 1302
  { IMAGE_GATHER4_LZ_V4_V4_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x4, 0x4 }, // 1303
  { IMAGE_GATHER4_LZ_V5_V1_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x5, 0x1 }, // 1304
  { IMAGE_GATHER4_LZ_V5_V2_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x5, 0x2 }, // 1305
  { IMAGE_GATHER4_LZ_V5_V3_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x5, 0x3 }, // 1306
  { IMAGE_GATHER4_LZ_V5_V4_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x5, 0x4 }, // 1307
  { IMAGE_GATHER4_LZ_V2_V2_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x2, 0x2 }, // 1308
  { IMAGE_GATHER4_LZ_V2_V3_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x2, 0x3 }, // 1309
  { IMAGE_GATHER4_LZ_V4_V2_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x4, 0x2 }, // 1310
  { IMAGE_GATHER4_LZ_V4_V3_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x4, 0x3 }, // 1311
  { IMAGE_GATHER4_LZ_V5_V2_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x5, 0x2 }, // 1312
  { IMAGE_GATHER4_LZ_V5_V3_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x5, 0x3 }, // 1313
  { IMAGE_GATHER4_LZ_V2_V1, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x1 }, // 1314
  { IMAGE_GATHER4_LZ_V2_V2, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x2 }, // 1315
  { IMAGE_GATHER4_LZ_V2_V3, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x3 }, // 1316
  { IMAGE_GATHER4_LZ_V2_V4, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x4 }, // 1317
  { IMAGE_GATHER4_LZ_V4_V1, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x1 }, // 1318
  { IMAGE_GATHER4_LZ_V4_V2, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x2 }, // 1319
  { IMAGE_GATHER4_LZ_V4_V3, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x3 }, // 1320
  { IMAGE_GATHER4_LZ_V4_V4, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x4 }, // 1321
  { IMAGE_GATHER4_LZ_V5_V1, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x5, 0x1 }, // 1322
  { IMAGE_GATHER4_LZ_V5_V2, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x5, 0x2 }, // 1323
  { IMAGE_GATHER4_LZ_V5_V3, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x5, 0x3 }, // 1324
  { IMAGE_GATHER4_LZ_V5_V4, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x5, 0x4 }, // 1325
  { IMAGE_GATHER4_LZ_O_V2_V2_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x2, 0x2 }, // 1326
  { IMAGE_GATHER4_LZ_O_V2_V3_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 1327
  { IMAGE_GATHER4_LZ_O_V2_V4_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 1328
  { IMAGE_GATHER4_LZ_O_V4_V2_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x4, 0x2 }, // 1329
  { IMAGE_GATHER4_LZ_O_V4_V3_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 1330
  { IMAGE_GATHER4_LZ_O_V4_V4_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 1331
  { IMAGE_GATHER4_LZ_O_V5_V2_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x5, 0x2 }, // 1332
  { IMAGE_GATHER4_LZ_O_V5_V3_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 1333
  { IMAGE_GATHER4_LZ_O_V5_V4_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 1334
  { IMAGE_GATHER4_LZ_O_V2_V2_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x2, 0x2 }, // 1335
  { IMAGE_GATHER4_LZ_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 1336
  { IMAGE_GATHER4_LZ_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 1337
  { IMAGE_GATHER4_LZ_O_V4_V2_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x4, 0x2 }, // 1338
  { IMAGE_GATHER4_LZ_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 1339
  { IMAGE_GATHER4_LZ_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 1340
  { IMAGE_GATHER4_LZ_O_V5_V2_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x5, 0x2 }, // 1341
  { IMAGE_GATHER4_LZ_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 1342
  { IMAGE_GATHER4_LZ_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 1343
  { IMAGE_GATHER4_LZ_O_V2_V2, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x2, 0x2 }, // 1344
  { IMAGE_GATHER4_LZ_O_V2_V3, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x2, 0x3 }, // 1345
  { IMAGE_GATHER4_LZ_O_V2_V4, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x2, 0x4 }, // 1346
  { IMAGE_GATHER4_LZ_O_V4_V2, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x4, 0x2 }, // 1347
  { IMAGE_GATHER4_LZ_O_V4_V3, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x4, 0x3 }, // 1348
  { IMAGE_GATHER4_LZ_O_V4_V4, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x4, 0x4 }, // 1349
  { IMAGE_GATHER4_LZ_O_V5_V2, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x5, 0x2 }, // 1350
  { IMAGE_GATHER4_LZ_O_V5_V3, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x5, 0x3 }, // 1351
  { IMAGE_GATHER4_LZ_O_V5_V4, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x5, 0x4 }, // 1352
  { IMAGE_GATHER4_L_O_V2_V2_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x2 }, // 1353
  { IMAGE_GATHER4_L_O_V2_V3_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 1354
  { IMAGE_GATHER4_L_O_V2_V4_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 1355
  { IMAGE_GATHER4_L_O_V2_V5_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 1356
  { IMAGE_GATHER4_L_O_V2_V8_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 1357
  { IMAGE_GATHER4_L_O_V4_V2_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x2 }, // 1358
  { IMAGE_GATHER4_L_O_V4_V3_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 1359
  { IMAGE_GATHER4_L_O_V4_V4_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 1360
  { IMAGE_GATHER4_L_O_V4_V5_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 1361
  { IMAGE_GATHER4_L_O_V4_V8_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 1362
  { IMAGE_GATHER4_L_O_V5_V2_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x2 }, // 1363
  { IMAGE_GATHER4_L_O_V5_V3_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 1364
  { IMAGE_GATHER4_L_O_V5_V4_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 1365
  { IMAGE_GATHER4_L_O_V5_V5_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 1366
  { IMAGE_GATHER4_L_O_V5_V8_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 1367
  { IMAGE_GATHER4_L_O_V2_V2_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x2, 0x2 }, // 1368
  { IMAGE_GATHER4_L_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 1369
  { IMAGE_GATHER4_L_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 1370
  { IMAGE_GATHER4_L_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 1371
  { IMAGE_GATHER4_L_O_V4_V2_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x4, 0x2 }, // 1372
  { IMAGE_GATHER4_L_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 1373
  { IMAGE_GATHER4_L_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 1374
  { IMAGE_GATHER4_L_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 1375
  { IMAGE_GATHER4_L_O_V5_V2_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x5, 0x2 }, // 1376
  { IMAGE_GATHER4_L_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 1377
  { IMAGE_GATHER4_L_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 1378
  { IMAGE_GATHER4_L_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 1379
  { IMAGE_GATHER4_L_O_V2_V2, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x2 }, // 1380
  { IMAGE_GATHER4_L_O_V2_V3, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x3 }, // 1381
  { IMAGE_GATHER4_L_O_V2_V4, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x4 }, // 1382
  { IMAGE_GATHER4_L_O_V2_V5, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x5 }, // 1383
  { IMAGE_GATHER4_L_O_V2_V8, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x8 }, // 1384
  { IMAGE_GATHER4_L_O_V4_V2, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x2 }, // 1385
  { IMAGE_GATHER4_L_O_V4_V3, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x3 }, // 1386
  { IMAGE_GATHER4_L_O_V4_V4, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x4 }, // 1387
  { IMAGE_GATHER4_L_O_V4_V5, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x5 }, // 1388
  { IMAGE_GATHER4_L_O_V4_V8, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x8 }, // 1389
  { IMAGE_GATHER4_L_O_V5_V2, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x2 }, // 1390
  { IMAGE_GATHER4_L_O_V5_V3, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x3 }, // 1391
  { IMAGE_GATHER4_L_O_V5_V4, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x4 }, // 1392
  { IMAGE_GATHER4_L_O_V5_V5, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x5 }, // 1393
  { IMAGE_GATHER4_L_O_V5_V8, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x8 }, // 1394
  { IMAGE_GATHER4_O_V2_V2_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x2, 0x2 }, // 1395
  { IMAGE_GATHER4_O_V2_V3_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 1396
  { IMAGE_GATHER4_O_V2_V4_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 1397
  { IMAGE_GATHER4_O_V4_V2_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x4, 0x2 }, // 1398
  { IMAGE_GATHER4_O_V4_V3_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 1399
  { IMAGE_GATHER4_O_V4_V4_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 1400
  { IMAGE_GATHER4_O_V5_V2_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x5, 0x2 }, // 1401
  { IMAGE_GATHER4_O_V5_V3_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 1402
  { IMAGE_GATHER4_O_V5_V4_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 1403
  { IMAGE_GATHER4_O_V2_V2_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x2, 0x2 }, // 1404
  { IMAGE_GATHER4_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 1405
  { IMAGE_GATHER4_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 1406
  { IMAGE_GATHER4_O_V4_V2_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x4, 0x2 }, // 1407
  { IMAGE_GATHER4_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 1408
  { IMAGE_GATHER4_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 1409
  { IMAGE_GATHER4_O_V5_V2_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x5, 0x2 }, // 1410
  { IMAGE_GATHER4_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 1411
  { IMAGE_GATHER4_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 1412
  { IMAGE_GATHER4_O_V2_V2, IMAGE_GATHER4_O, MIMGEncGfx6, 0x2, 0x2 }, // 1413
  { IMAGE_GATHER4_O_V2_V3, IMAGE_GATHER4_O, MIMGEncGfx6, 0x2, 0x3 }, // 1414
  { IMAGE_GATHER4_O_V2_V4, IMAGE_GATHER4_O, MIMGEncGfx6, 0x2, 0x4 }, // 1415
  { IMAGE_GATHER4_O_V4_V2, IMAGE_GATHER4_O, MIMGEncGfx6, 0x4, 0x2 }, // 1416
  { IMAGE_GATHER4_O_V4_V3, IMAGE_GATHER4_O, MIMGEncGfx6, 0x4, 0x3 }, // 1417
  { IMAGE_GATHER4_O_V4_V4, IMAGE_GATHER4_O, MIMGEncGfx6, 0x4, 0x4 }, // 1418
  { IMAGE_GATHER4_O_V5_V2, IMAGE_GATHER4_O, MIMGEncGfx6, 0x5, 0x2 }, // 1419
  { IMAGE_GATHER4_O_V5_V3, IMAGE_GATHER4_O, MIMGEncGfx6, 0x5, 0x3 }, // 1420
  { IMAGE_GATHER4_O_V5_V4, IMAGE_GATHER4_O, MIMGEncGfx6, 0x5, 0x4 }, // 1421
  { IMAGE_GET_LOD_V1_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x1, 0x1 }, // 1422
  { IMAGE_GET_LOD_V1_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x1, 0x2 }, // 1423
  { IMAGE_GET_LOD_V1_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x1, 0x3 }, // 1424
  { IMAGE_GET_LOD_V1_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x1, 0x4 }, // 1425
  { IMAGE_GET_LOD_V2_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x2, 0x1 }, // 1426
  { IMAGE_GET_LOD_V2_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x2, 0x2 }, // 1427
  { IMAGE_GET_LOD_V2_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x2, 0x3 }, // 1428
  { IMAGE_GET_LOD_V2_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x2, 0x4 }, // 1429
  { IMAGE_GET_LOD_V3_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x3, 0x1 }, // 1430
  { IMAGE_GET_LOD_V3_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x3, 0x2 }, // 1431
  { IMAGE_GET_LOD_V3_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x3, 0x3 }, // 1432
  { IMAGE_GET_LOD_V3_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x3, 0x4 }, // 1433
  { IMAGE_GET_LOD_V4_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x4, 0x1 }, // 1434
  { IMAGE_GET_LOD_V4_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x4, 0x2 }, // 1435
  { IMAGE_GET_LOD_V4_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x4, 0x3 }, // 1436
  { IMAGE_GET_LOD_V4_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x4, 0x4 }, // 1437
  { IMAGE_GET_LOD_V5_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x5, 0x1 }, // 1438
  { IMAGE_GET_LOD_V5_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x5, 0x2 }, // 1439
  { IMAGE_GET_LOD_V5_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x5, 0x3 }, // 1440
  { IMAGE_GET_LOD_V5_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x5, 0x4 }, // 1441
  { IMAGE_GET_LOD_V1_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x1, 0x2 }, // 1442
  { IMAGE_GET_LOD_V1_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x1, 0x3 }, // 1443
  { IMAGE_GET_LOD_V2_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x2, 0x2 }, // 1444
  { IMAGE_GET_LOD_V2_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x2, 0x3 }, // 1445
  { IMAGE_GET_LOD_V3_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x3, 0x2 }, // 1446
  { IMAGE_GET_LOD_V3_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x3, 0x3 }, // 1447
  { IMAGE_GET_LOD_V4_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x4, 0x2 }, // 1448
  { IMAGE_GET_LOD_V4_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x4, 0x3 }, // 1449
  { IMAGE_GET_LOD_V5_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x5, 0x2 }, // 1450
  { IMAGE_GET_LOD_V5_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x5, 0x3 }, // 1451
  { IMAGE_GET_LOD_V1_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x1 }, // 1452
  { IMAGE_GET_LOD_V1_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x2 }, // 1453
  { IMAGE_GET_LOD_V1_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x3 }, // 1454
  { IMAGE_GET_LOD_V1_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x4 }, // 1455
  { IMAGE_GET_LOD_V2_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x1 }, // 1456
  { IMAGE_GET_LOD_V2_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x2 }, // 1457
  { IMAGE_GET_LOD_V2_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x3 }, // 1458
  { IMAGE_GET_LOD_V2_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x4 }, // 1459
  { IMAGE_GET_LOD_V3_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x1 }, // 1460
  { IMAGE_GET_LOD_V3_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x2 }, // 1461
  { IMAGE_GET_LOD_V3_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x3 }, // 1462
  { IMAGE_GET_LOD_V3_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x4 }, // 1463
  { IMAGE_GET_LOD_V4_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x1 }, // 1464
  { IMAGE_GET_LOD_V4_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x2 }, // 1465
  { IMAGE_GET_LOD_V4_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x3 }, // 1466
  { IMAGE_GET_LOD_V4_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x4 }, // 1467
  { IMAGE_GET_LOD_V5_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x5, 0x1 }, // 1468
  { IMAGE_GET_LOD_V5_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x5, 0x2 }, // 1469
  { IMAGE_GET_LOD_V5_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x5, 0x3 }, // 1470
  { IMAGE_GET_LOD_V5_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x5, 0x4 }, // 1471
  { IMAGE_GET_LOD_V1_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x1, 0x1 }, // 1472
  { IMAGE_GET_LOD_V1_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x1, 0x2 }, // 1473
  { IMAGE_GET_LOD_V1_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x1, 0x3 }, // 1474
  { IMAGE_GET_LOD_V1_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x1, 0x4 }, // 1475
  { IMAGE_GET_LOD_V2_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x2, 0x1 }, // 1476
  { IMAGE_GET_LOD_V2_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x2, 0x2 }, // 1477
  { IMAGE_GET_LOD_V2_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x2, 0x3 }, // 1478
  { IMAGE_GET_LOD_V2_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x2, 0x4 }, // 1479
  { IMAGE_GET_LOD_V3_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x3, 0x1 }, // 1480
  { IMAGE_GET_LOD_V3_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x3, 0x2 }, // 1481
  { IMAGE_GET_LOD_V3_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x3, 0x3 }, // 1482
  { IMAGE_GET_LOD_V3_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x3, 0x4 }, // 1483
  { IMAGE_GET_LOD_V4_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x4, 0x1 }, // 1484
  { IMAGE_GET_LOD_V4_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x4, 0x2 }, // 1485
  { IMAGE_GET_LOD_V4_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x4, 0x3 }, // 1486
  { IMAGE_GET_LOD_V4_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x4, 0x4 }, // 1487
  { IMAGE_GET_LOD_V5_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x5, 0x1 }, // 1488
  { IMAGE_GET_LOD_V5_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x5, 0x2 }, // 1489
  { IMAGE_GET_LOD_V5_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x5, 0x3 }, // 1490
  { IMAGE_GET_LOD_V5_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x5, 0x4 }, // 1491
  { IMAGE_GET_RESINFO_V1_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x1, 0x1 }, // 1492
  { IMAGE_GET_RESINFO_V1_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x1, 0x2 }, // 1493
  { IMAGE_GET_RESINFO_V1_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x1, 0x3 }, // 1494
  { IMAGE_GET_RESINFO_V1_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x1, 0x4 }, // 1495
  { IMAGE_GET_RESINFO_V2_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x2, 0x1 }, // 1496
  { IMAGE_GET_RESINFO_V2_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x2, 0x2 }, // 1497
  { IMAGE_GET_RESINFO_V2_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x2, 0x3 }, // 1498
  { IMAGE_GET_RESINFO_V2_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x2, 0x4 }, // 1499
  { IMAGE_GET_RESINFO_V3_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x3, 0x1 }, // 1500
  { IMAGE_GET_RESINFO_V3_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x3, 0x2 }, // 1501
  { IMAGE_GET_RESINFO_V3_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x3, 0x3 }, // 1502
  { IMAGE_GET_RESINFO_V3_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x3, 0x4 }, // 1503
  { IMAGE_GET_RESINFO_V4_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x4, 0x1 }, // 1504
  { IMAGE_GET_RESINFO_V4_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x4, 0x2 }, // 1505
  { IMAGE_GET_RESINFO_V4_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x4, 0x3 }, // 1506
  { IMAGE_GET_RESINFO_V4_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x4, 0x4 }, // 1507
  { IMAGE_GET_RESINFO_V5_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x5, 0x1 }, // 1508
  { IMAGE_GET_RESINFO_V5_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x5, 0x2 }, // 1509
  { IMAGE_GET_RESINFO_V5_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x5, 0x3 }, // 1510
  { IMAGE_GET_RESINFO_V5_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x5, 0x4 }, // 1511
  { IMAGE_GET_RESINFO_V1_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x1, 0x2 }, // 1512
  { IMAGE_GET_RESINFO_V1_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x1, 0x3 }, // 1513
  { IMAGE_GET_RESINFO_V1_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x1, 0x4 }, // 1514
  { IMAGE_GET_RESINFO_V2_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x2, 0x2 }, // 1515
  { IMAGE_GET_RESINFO_V2_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x2, 0x3 }, // 1516
  { IMAGE_GET_RESINFO_V2_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x2, 0x4 }, // 1517
  { IMAGE_GET_RESINFO_V3_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x3, 0x2 }, // 1518
  { IMAGE_GET_RESINFO_V3_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x3, 0x3 }, // 1519
  { IMAGE_GET_RESINFO_V3_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x3, 0x4 }, // 1520
  { IMAGE_GET_RESINFO_V4_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x4, 0x2 }, // 1521
  { IMAGE_GET_RESINFO_V4_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x4, 0x3 }, // 1522
  { IMAGE_GET_RESINFO_V4_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x4, 0x4 }, // 1523
  { IMAGE_GET_RESINFO_V5_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x5, 0x2 }, // 1524
  { IMAGE_GET_RESINFO_V5_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x5, 0x3 }, // 1525
  { IMAGE_GET_RESINFO_V5_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x5, 0x4 }, // 1526
  { IMAGE_GET_RESINFO_V1_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x1 }, // 1527
  { IMAGE_GET_RESINFO_V1_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x2 }, // 1528
  { IMAGE_GET_RESINFO_V1_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x3 }, // 1529
  { IMAGE_GET_RESINFO_V1_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x4 }, // 1530
  { IMAGE_GET_RESINFO_V2_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x1 }, // 1531
  { IMAGE_GET_RESINFO_V2_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x2 }, // 1532
  { IMAGE_GET_RESINFO_V2_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x3 }, // 1533
  { IMAGE_GET_RESINFO_V2_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x4 }, // 1534
  { IMAGE_GET_RESINFO_V3_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x1 }, // 1535
  { IMAGE_GET_RESINFO_V3_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x2 }, // 1536
  { IMAGE_GET_RESINFO_V3_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x3 }, // 1537
  { IMAGE_GET_RESINFO_V3_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x4 }, // 1538
  { IMAGE_GET_RESINFO_V4_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x1 }, // 1539
  { IMAGE_GET_RESINFO_V4_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x2 }, // 1540
  { IMAGE_GET_RESINFO_V4_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x3 }, // 1541
  { IMAGE_GET_RESINFO_V4_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x4 }, // 1542
  { IMAGE_GET_RESINFO_V5_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x5, 0x1 }, // 1543
  { IMAGE_GET_RESINFO_V5_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x5, 0x2 }, // 1544
  { IMAGE_GET_RESINFO_V5_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x5, 0x3 }, // 1545
  { IMAGE_GET_RESINFO_V5_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x5, 0x4 }, // 1546
  { IMAGE_GET_RESINFO_V1_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x1, 0x1 }, // 1547
  { IMAGE_GET_RESINFO_V1_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x1, 0x2 }, // 1548
  { IMAGE_GET_RESINFO_V1_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x1, 0x3 }, // 1549
  { IMAGE_GET_RESINFO_V1_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x1, 0x4 }, // 1550
  { IMAGE_GET_RESINFO_V2_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x2, 0x1 }, // 1551
  { IMAGE_GET_RESINFO_V2_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x2, 0x2 }, // 1552
  { IMAGE_GET_RESINFO_V2_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x2, 0x3 }, // 1553
  { IMAGE_GET_RESINFO_V2_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x2, 0x4 }, // 1554
  { IMAGE_GET_RESINFO_V3_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x3, 0x1 }, // 1555
  { IMAGE_GET_RESINFO_V3_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x3, 0x2 }, // 1556
  { IMAGE_GET_RESINFO_V3_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x3, 0x3 }, // 1557
  { IMAGE_GET_RESINFO_V3_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x3, 0x4 }, // 1558
  { IMAGE_GET_RESINFO_V4_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x4, 0x1 }, // 1559
  { IMAGE_GET_RESINFO_V4_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x4, 0x2 }, // 1560
  { IMAGE_GET_RESINFO_V4_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x4, 0x3 }, // 1561
  { IMAGE_GET_RESINFO_V4_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x4, 0x4 }, // 1562
  { IMAGE_GET_RESINFO_V5_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x5, 0x1 }, // 1563
  { IMAGE_GET_RESINFO_V5_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x5, 0x2 }, // 1564
  { IMAGE_GET_RESINFO_V5_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x5, 0x3 }, // 1565
  { IMAGE_GET_RESINFO_V5_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x5, 0x4 }, // 1566
  { IMAGE_LOAD_V1_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x1, 0x1 }, // 1567
  { IMAGE_LOAD_V1_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x1, 0x2 }, // 1568
  { IMAGE_LOAD_V1_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x1, 0x3 }, // 1569
  { IMAGE_LOAD_V1_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x1, 0x4 }, // 1570
  { IMAGE_LOAD_V2_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x2, 0x1 }, // 1571
  { IMAGE_LOAD_V2_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x2, 0x2 }, // 1572
  { IMAGE_LOAD_V2_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x2, 0x3 }, // 1573
  { IMAGE_LOAD_V2_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x2, 0x4 }, // 1574
  { IMAGE_LOAD_V3_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x3, 0x1 }, // 1575
  { IMAGE_LOAD_V3_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x3, 0x2 }, // 1576
  { IMAGE_LOAD_V3_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x3, 0x3 }, // 1577
  { IMAGE_LOAD_V3_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x3, 0x4 }, // 1578
  { IMAGE_LOAD_V4_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x4, 0x1 }, // 1579
  { IMAGE_LOAD_V4_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x4, 0x2 }, // 1580
  { IMAGE_LOAD_V4_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x4, 0x3 }, // 1581
  { IMAGE_LOAD_V4_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x4, 0x4 }, // 1582
  { IMAGE_LOAD_V5_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x5, 0x1 }, // 1583
  { IMAGE_LOAD_V5_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x5, 0x2 }, // 1584
  { IMAGE_LOAD_V5_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x5, 0x3 }, // 1585
  { IMAGE_LOAD_V5_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x5, 0x4 }, // 1586
  { IMAGE_LOAD_V1_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x1, 0x2 }, // 1587
  { IMAGE_LOAD_V1_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x1, 0x3 }, // 1588
  { IMAGE_LOAD_V1_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x1, 0x4 }, // 1589
  { IMAGE_LOAD_V2_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x2, 0x2 }, // 1590
  { IMAGE_LOAD_V2_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x2, 0x3 }, // 1591
  { IMAGE_LOAD_V2_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x2, 0x4 }, // 1592
  { IMAGE_LOAD_V3_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x3, 0x2 }, // 1593
  { IMAGE_LOAD_V3_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x3, 0x3 }, // 1594
  { IMAGE_LOAD_V3_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x3, 0x4 }, // 1595
  { IMAGE_LOAD_V4_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x4, 0x2 }, // 1596
  { IMAGE_LOAD_V4_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x4, 0x3 }, // 1597
  { IMAGE_LOAD_V4_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x4, 0x4 }, // 1598
  { IMAGE_LOAD_V5_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x5, 0x2 }, // 1599
  { IMAGE_LOAD_V5_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x5, 0x3 }, // 1600
  { IMAGE_LOAD_V5_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x5, 0x4 }, // 1601
  { IMAGE_LOAD_V1_V1, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x1 }, // 1602
  { IMAGE_LOAD_V1_V2, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x2 }, // 1603
  { IMAGE_LOAD_V1_V3, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x3 }, // 1604
  { IMAGE_LOAD_V1_V4, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x4 }, // 1605
  { IMAGE_LOAD_V2_V1, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x1 }, // 1606
  { IMAGE_LOAD_V2_V2, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x2 }, // 1607
  { IMAGE_LOAD_V2_V3, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x3 }, // 1608
  { IMAGE_LOAD_V2_V4, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x4 }, // 1609
  { IMAGE_LOAD_V3_V1, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x1 }, // 1610
  { IMAGE_LOAD_V3_V2, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x2 }, // 1611
  { IMAGE_LOAD_V3_V3, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x3 }, // 1612
  { IMAGE_LOAD_V3_V4, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x4 }, // 1613
  { IMAGE_LOAD_V4_V1, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x1 }, // 1614
  { IMAGE_LOAD_V4_V2, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x2 }, // 1615
  { IMAGE_LOAD_V4_V3, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x3 }, // 1616
  { IMAGE_LOAD_V4_V4, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x4 }, // 1617
  { IMAGE_LOAD_V5_V1, IMAGE_LOAD, MIMGEncGfx6, 0x5, 0x1 }, // 1618
  { IMAGE_LOAD_V5_V2, IMAGE_LOAD, MIMGEncGfx6, 0x5, 0x2 }, // 1619
  { IMAGE_LOAD_V5_V3, IMAGE_LOAD, MIMGEncGfx6, 0x5, 0x3 }, // 1620
  { IMAGE_LOAD_V5_V4, IMAGE_LOAD, MIMGEncGfx6, 0x5, 0x4 }, // 1621
  { IMAGE_LOAD_V1_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x1, 0x1 }, // 1622
  { IMAGE_LOAD_V1_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x1, 0x2 }, // 1623
  { IMAGE_LOAD_V1_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x1, 0x3 }, // 1624
  { IMAGE_LOAD_V1_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x1, 0x4 }, // 1625
  { IMAGE_LOAD_V2_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x2, 0x1 }, // 1626
  { IMAGE_LOAD_V2_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x2, 0x2 }, // 1627
  { IMAGE_LOAD_V2_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x2, 0x3 }, // 1628
  { IMAGE_LOAD_V2_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x2, 0x4 }, // 1629
  { IMAGE_LOAD_V3_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x3, 0x1 }, // 1630
  { IMAGE_LOAD_V3_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x3, 0x2 }, // 1631
  { IMAGE_LOAD_V3_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x3, 0x3 }, // 1632
  { IMAGE_LOAD_V3_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x3, 0x4 }, // 1633
  { IMAGE_LOAD_V4_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x4, 0x1 }, // 1634
  { IMAGE_LOAD_V4_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x4, 0x2 }, // 1635
  { IMAGE_LOAD_V4_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x4, 0x3 }, // 1636
  { IMAGE_LOAD_V4_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x4, 0x4 }, // 1637
  { IMAGE_LOAD_V5_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x5, 0x1 }, // 1638
  { IMAGE_LOAD_V5_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x5, 0x2 }, // 1639
  { IMAGE_LOAD_V5_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x5, 0x3 }, // 1640
  { IMAGE_LOAD_V5_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x5, 0x4 }, // 1641
  { IMAGE_LOAD_MIP_V1_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x1, 0x1 }, // 1642
  { IMAGE_LOAD_MIP_V1_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x1, 0x2 }, // 1643
  { IMAGE_LOAD_MIP_V1_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x1, 0x3 }, // 1644
  { IMAGE_LOAD_MIP_V1_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x1, 0x4 }, // 1645
  { IMAGE_LOAD_MIP_V2_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x2, 0x1 }, // 1646
  { IMAGE_LOAD_MIP_V2_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x2, 0x2 }, // 1647
  { IMAGE_LOAD_MIP_V2_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x2, 0x3 }, // 1648
  { IMAGE_LOAD_MIP_V2_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x2, 0x4 }, // 1649
  { IMAGE_LOAD_MIP_V3_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x3, 0x1 }, // 1650
  { IMAGE_LOAD_MIP_V3_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x3, 0x2 }, // 1651
  { IMAGE_LOAD_MIP_V3_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x3, 0x3 }, // 1652
  { IMAGE_LOAD_MIP_V3_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x3, 0x4 }, // 1653
  { IMAGE_LOAD_MIP_V4_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x4, 0x1 }, // 1654
  { IMAGE_LOAD_MIP_V4_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x4, 0x2 }, // 1655
  { IMAGE_LOAD_MIP_V4_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x4, 0x3 }, // 1656
  { IMAGE_LOAD_MIP_V4_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x4, 0x4 }, // 1657
  { IMAGE_LOAD_MIP_V5_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x5, 0x1 }, // 1658
  { IMAGE_LOAD_MIP_V5_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x5, 0x2 }, // 1659
  { IMAGE_LOAD_MIP_V5_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x5, 0x3 }, // 1660
  { IMAGE_LOAD_MIP_V5_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x5, 0x4 }, // 1661
  { IMAGE_LOAD_MIP_V1_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x1, 0x2 }, // 1662
  { IMAGE_LOAD_MIP_V1_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x1, 0x3 }, // 1663
  { IMAGE_LOAD_MIP_V1_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x1, 0x4 }, // 1664
  { IMAGE_LOAD_MIP_V2_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x2, 0x2 }, // 1665
  { IMAGE_LOAD_MIP_V2_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x2, 0x3 }, // 1666
  { IMAGE_LOAD_MIP_V2_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x2, 0x4 }, // 1667
  { IMAGE_LOAD_MIP_V3_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x3, 0x2 }, // 1668
  { IMAGE_LOAD_MIP_V3_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x3, 0x3 }, // 1669
  { IMAGE_LOAD_MIP_V3_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x3, 0x4 }, // 1670
  { IMAGE_LOAD_MIP_V4_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x4, 0x2 }, // 1671
  { IMAGE_LOAD_MIP_V4_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x4, 0x3 }, // 1672
  { IMAGE_LOAD_MIP_V4_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x4, 0x4 }, // 1673
  { IMAGE_LOAD_MIP_V5_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x5, 0x2 }, // 1674
  { IMAGE_LOAD_MIP_V5_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x5, 0x3 }, // 1675
  { IMAGE_LOAD_MIP_V5_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x5, 0x4 }, // 1676
  { IMAGE_LOAD_MIP_V1_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x1 }, // 1677
  { IMAGE_LOAD_MIP_V1_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x2 }, // 1678
  { IMAGE_LOAD_MIP_V1_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x3 }, // 1679
  { IMAGE_LOAD_MIP_V1_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x4 }, // 1680
  { IMAGE_LOAD_MIP_V2_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x1 }, // 1681
  { IMAGE_LOAD_MIP_V2_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x2 }, // 1682
  { IMAGE_LOAD_MIP_V2_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x3 }, // 1683
  { IMAGE_LOAD_MIP_V2_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x4 }, // 1684
  { IMAGE_LOAD_MIP_V3_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x1 }, // 1685
  { IMAGE_LOAD_MIP_V3_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x2 }, // 1686
  { IMAGE_LOAD_MIP_V3_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x3 }, // 1687
  { IMAGE_LOAD_MIP_V3_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x4 }, // 1688
  { IMAGE_LOAD_MIP_V4_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x1 }, // 1689
  { IMAGE_LOAD_MIP_V4_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x2 }, // 1690
  { IMAGE_LOAD_MIP_V4_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x3 }, // 1691
  { IMAGE_LOAD_MIP_V4_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x4 }, // 1692
  { IMAGE_LOAD_MIP_V5_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x5, 0x1 }, // 1693
  { IMAGE_LOAD_MIP_V5_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x5, 0x2 }, // 1694
  { IMAGE_LOAD_MIP_V5_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x5, 0x3 }, // 1695
  { IMAGE_LOAD_MIP_V5_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x5, 0x4 }, // 1696
  { IMAGE_LOAD_MIP_V1_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x1, 0x1 }, // 1697
  { IMAGE_LOAD_MIP_V1_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x1, 0x2 }, // 1698
  { IMAGE_LOAD_MIP_V1_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x1, 0x3 }, // 1699
  { IMAGE_LOAD_MIP_V1_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x1, 0x4 }, // 1700
  { IMAGE_LOAD_MIP_V2_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x2, 0x1 }, // 1701
  { IMAGE_LOAD_MIP_V2_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x2, 0x2 }, // 1702
  { IMAGE_LOAD_MIP_V2_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x2, 0x3 }, // 1703
  { IMAGE_LOAD_MIP_V2_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x2, 0x4 }, // 1704
  { IMAGE_LOAD_MIP_V3_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x3, 0x1 }, // 1705
  { IMAGE_LOAD_MIP_V3_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x3, 0x2 }, // 1706
  { IMAGE_LOAD_MIP_V3_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x3, 0x3 }, // 1707
  { IMAGE_LOAD_MIP_V3_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x3, 0x4 }, // 1708
  { IMAGE_LOAD_MIP_V4_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x4, 0x1 }, // 1709
  { IMAGE_LOAD_MIP_V4_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x4, 0x2 }, // 1710
  { IMAGE_LOAD_MIP_V4_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x4, 0x3 }, // 1711
  { IMAGE_LOAD_MIP_V4_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x4, 0x4 }, // 1712
  { IMAGE_LOAD_MIP_V5_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x5, 0x1 }, // 1713
  { IMAGE_LOAD_MIP_V5_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x5, 0x2 }, // 1714
  { IMAGE_LOAD_MIP_V5_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x5, 0x3 }, // 1715
  { IMAGE_LOAD_MIP_V5_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x5, 0x4 }, // 1716
  { IMAGE_LOAD_MIP_PCK_V1_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x1 }, // 1717
  { IMAGE_LOAD_MIP_PCK_V1_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x2 }, // 1718
  { IMAGE_LOAD_MIP_PCK_V1_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x3 }, // 1719
  { IMAGE_LOAD_MIP_PCK_V1_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x4 }, // 1720
  { IMAGE_LOAD_MIP_PCK_V2_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x1 }, // 1721
  { IMAGE_LOAD_MIP_PCK_V2_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x2 }, // 1722
  { IMAGE_LOAD_MIP_PCK_V2_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x3 }, // 1723
  { IMAGE_LOAD_MIP_PCK_V2_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x4 }, // 1724
  { IMAGE_LOAD_MIP_PCK_V3_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x1 }, // 1725
  { IMAGE_LOAD_MIP_PCK_V3_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x2 }, // 1726
  { IMAGE_LOAD_MIP_PCK_V3_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x3 }, // 1727
  { IMAGE_LOAD_MIP_PCK_V3_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x4 }, // 1728
  { IMAGE_LOAD_MIP_PCK_V4_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x1 }, // 1729
  { IMAGE_LOAD_MIP_PCK_V4_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x2 }, // 1730
  { IMAGE_LOAD_MIP_PCK_V4_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x3 }, // 1731
  { IMAGE_LOAD_MIP_PCK_V4_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x4 }, // 1732
  { IMAGE_LOAD_MIP_PCK_V5_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x1 }, // 1733
  { IMAGE_LOAD_MIP_PCK_V5_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x2 }, // 1734
  { IMAGE_LOAD_MIP_PCK_V5_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x3 }, // 1735
  { IMAGE_LOAD_MIP_PCK_V5_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x4 }, // 1736
  { IMAGE_LOAD_MIP_PCK_V1_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x1, 0x2 }, // 1737
  { IMAGE_LOAD_MIP_PCK_V1_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x1, 0x3 }, // 1738
  { IMAGE_LOAD_MIP_PCK_V1_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x1, 0x4 }, // 1739
  { IMAGE_LOAD_MIP_PCK_V2_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x2, 0x2 }, // 1740
  { IMAGE_LOAD_MIP_PCK_V2_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x2, 0x3 }, // 1741
  { IMAGE_LOAD_MIP_PCK_V2_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x2, 0x4 }, // 1742
  { IMAGE_LOAD_MIP_PCK_V3_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x3, 0x2 }, // 1743
  { IMAGE_LOAD_MIP_PCK_V3_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x3, 0x3 }, // 1744
  { IMAGE_LOAD_MIP_PCK_V3_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x3, 0x4 }, // 1745
  { IMAGE_LOAD_MIP_PCK_V4_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x4, 0x2 }, // 1746
  { IMAGE_LOAD_MIP_PCK_V4_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x4, 0x3 }, // 1747
  { IMAGE_LOAD_MIP_PCK_V4_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x4, 0x4 }, // 1748
  { IMAGE_LOAD_MIP_PCK_V5_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x5, 0x2 }, // 1749
  { IMAGE_LOAD_MIP_PCK_V5_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x5, 0x3 }, // 1750
  { IMAGE_LOAD_MIP_PCK_V5_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x5, 0x4 }, // 1751
  { IMAGE_LOAD_MIP_PCK_V1_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x1 }, // 1752
  { IMAGE_LOAD_MIP_PCK_V1_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x2 }, // 1753
  { IMAGE_LOAD_MIP_PCK_V1_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x3 }, // 1754
  { IMAGE_LOAD_MIP_PCK_V1_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x4 }, // 1755
  { IMAGE_LOAD_MIP_PCK_V2_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x1 }, // 1756
  { IMAGE_LOAD_MIP_PCK_V2_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x2 }, // 1757
  { IMAGE_LOAD_MIP_PCK_V2_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x3 }, // 1758
  { IMAGE_LOAD_MIP_PCK_V2_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x4 }, // 1759
  { IMAGE_LOAD_MIP_PCK_V3_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x1 }, // 1760
  { IMAGE_LOAD_MIP_PCK_V3_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x2 }, // 1761
  { IMAGE_LOAD_MIP_PCK_V3_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x3 }, // 1762
  { IMAGE_LOAD_MIP_PCK_V3_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x4 }, // 1763
  { IMAGE_LOAD_MIP_PCK_V4_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x1 }, // 1764
  { IMAGE_LOAD_MIP_PCK_V4_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x2 }, // 1765
  { IMAGE_LOAD_MIP_PCK_V4_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x3 }, // 1766
  { IMAGE_LOAD_MIP_PCK_V4_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x4 }, // 1767
  { IMAGE_LOAD_MIP_PCK_V5_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x5, 0x1 }, // 1768
  { IMAGE_LOAD_MIP_PCK_V5_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x5, 0x2 }, // 1769
  { IMAGE_LOAD_MIP_PCK_V5_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x5, 0x3 }, // 1770
  { IMAGE_LOAD_MIP_PCK_V5_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x5, 0x4 }, // 1771
  { IMAGE_LOAD_MIP_PCK_V1_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x1, 0x1 }, // 1772
  { IMAGE_LOAD_MIP_PCK_V1_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x1, 0x2 }, // 1773
  { IMAGE_LOAD_MIP_PCK_V1_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x1, 0x3 }, // 1774
  { IMAGE_LOAD_MIP_PCK_V1_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x1, 0x4 }, // 1775
  { IMAGE_LOAD_MIP_PCK_V2_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x2, 0x1 }, // 1776
  { IMAGE_LOAD_MIP_PCK_V2_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x2, 0x2 }, // 1777
  { IMAGE_LOAD_MIP_PCK_V2_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x2, 0x3 }, // 1778
  { IMAGE_LOAD_MIP_PCK_V2_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x2, 0x4 }, // 1779
  { IMAGE_LOAD_MIP_PCK_V3_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x3, 0x1 }, // 1780
  { IMAGE_LOAD_MIP_PCK_V3_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x3, 0x2 }, // 1781
  { IMAGE_LOAD_MIP_PCK_V3_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x3, 0x3 }, // 1782
  { IMAGE_LOAD_MIP_PCK_V3_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x3, 0x4 }, // 1783
  { IMAGE_LOAD_MIP_PCK_V4_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x4, 0x1 }, // 1784
  { IMAGE_LOAD_MIP_PCK_V4_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x4, 0x2 }, // 1785
  { IMAGE_LOAD_MIP_PCK_V4_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x4, 0x3 }, // 1786
  { IMAGE_LOAD_MIP_PCK_V4_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x4, 0x4 }, // 1787
  { IMAGE_LOAD_MIP_PCK_V5_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x5, 0x1 }, // 1788
  { IMAGE_LOAD_MIP_PCK_V5_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x5, 0x2 }, // 1789
  { IMAGE_LOAD_MIP_PCK_V5_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x5, 0x3 }, // 1790
  { IMAGE_LOAD_MIP_PCK_V5_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x5, 0x4 }, // 1791
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x1 }, // 1792
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x2 }, // 1793
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x3 }, // 1794
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x4 }, // 1795
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x1 }, // 1796
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x2 }, // 1797
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x3 }, // 1798
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x4 }, // 1799
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x1 }, // 1800
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x2 }, // 1801
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x3 }, // 1802
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x4 }, // 1803
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x1 }, // 1804
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x2 }, // 1805
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x3 }, // 1806
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x4 }, // 1807
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x1 }, // 1808
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x2 }, // 1809
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x3 }, // 1810
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x4 }, // 1811
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x2 }, // 1812
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x3 }, // 1813
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x4 }, // 1814
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x2 }, // 1815
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x3 }, // 1816
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x4 }, // 1817
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x2 }, // 1818
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x3 }, // 1819
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x4 }, // 1820
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x2 }, // 1821
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x3 }, // 1822
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x4 }, // 1823
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x2 }, // 1824
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x3 }, // 1825
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x4 }, // 1826
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x1 }, // 1827
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x2 }, // 1828
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x3 }, // 1829
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x4 }, // 1830
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x1 }, // 1831
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x2 }, // 1832
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x3 }, // 1833
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x4 }, // 1834
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x1 }, // 1835
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x2 }, // 1836
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x3 }, // 1837
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x4 }, // 1838
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x1 }, // 1839
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x2 }, // 1840
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x3 }, // 1841
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x4 }, // 1842
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x5, 0x1 }, // 1843
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x5, 0x2 }, // 1844
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x5, 0x3 }, // 1845
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x5, 0x4 }, // 1846
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x1, 0x1 }, // 1847
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x1, 0x2 }, // 1848
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x1, 0x3 }, // 1849
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x1, 0x4 }, // 1850
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x2, 0x1 }, // 1851
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x2, 0x2 }, // 1852
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x2, 0x3 }, // 1853
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x2, 0x4 }, // 1854
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x3, 0x1 }, // 1855
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x3, 0x2 }, // 1856
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x3, 0x3 }, // 1857
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x3, 0x4 }, // 1858
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x4, 0x1 }, // 1859
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x4, 0x2 }, // 1860
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x4, 0x3 }, // 1861
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x4, 0x4 }, // 1862
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x5, 0x1 }, // 1863
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x5, 0x2 }, // 1864
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x5, 0x3 }, // 1865
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x5, 0x4 }, // 1866
  { IMAGE_LOAD_PCK_V1_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x1, 0x1 }, // 1867
  { IMAGE_LOAD_PCK_V1_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x1, 0x2 }, // 1868
  { IMAGE_LOAD_PCK_V1_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x1, 0x3 }, // 1869
  { IMAGE_LOAD_PCK_V1_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x1, 0x4 }, // 1870
  { IMAGE_LOAD_PCK_V2_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x2, 0x1 }, // 1871
  { IMAGE_LOAD_PCK_V2_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x2, 0x2 }, // 1872
  { IMAGE_LOAD_PCK_V2_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x2, 0x3 }, // 1873
  { IMAGE_LOAD_PCK_V2_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x2, 0x4 }, // 1874
  { IMAGE_LOAD_PCK_V3_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x3, 0x1 }, // 1875
  { IMAGE_LOAD_PCK_V3_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x3, 0x2 }, // 1876
  { IMAGE_LOAD_PCK_V3_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x3, 0x3 }, // 1877
  { IMAGE_LOAD_PCK_V3_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x3, 0x4 }, // 1878
  { IMAGE_LOAD_PCK_V4_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x4, 0x1 }, // 1879
  { IMAGE_LOAD_PCK_V4_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x4, 0x2 }, // 1880
  { IMAGE_LOAD_PCK_V4_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x4, 0x3 }, // 1881
  { IMAGE_LOAD_PCK_V4_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x4, 0x4 }, // 1882
  { IMAGE_LOAD_PCK_V5_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x5, 0x1 }, // 1883
  { IMAGE_LOAD_PCK_V5_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x5, 0x2 }, // 1884
  { IMAGE_LOAD_PCK_V5_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x5, 0x3 }, // 1885
  { IMAGE_LOAD_PCK_V5_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x5, 0x4 }, // 1886
  { IMAGE_LOAD_PCK_V1_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x1, 0x2 }, // 1887
  { IMAGE_LOAD_PCK_V1_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x1, 0x3 }, // 1888
  { IMAGE_LOAD_PCK_V1_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x1, 0x4 }, // 1889
  { IMAGE_LOAD_PCK_V2_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x2, 0x2 }, // 1890
  { IMAGE_LOAD_PCK_V2_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x2, 0x3 }, // 1891
  { IMAGE_LOAD_PCK_V2_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x2, 0x4 }, // 1892
  { IMAGE_LOAD_PCK_V3_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x3, 0x2 }, // 1893
  { IMAGE_LOAD_PCK_V3_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x3, 0x3 }, // 1894
  { IMAGE_LOAD_PCK_V3_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x3, 0x4 }, // 1895
  { IMAGE_LOAD_PCK_V4_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x4, 0x2 }, // 1896
  { IMAGE_LOAD_PCK_V4_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x4, 0x3 }, // 1897
  { IMAGE_LOAD_PCK_V4_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x4, 0x4 }, // 1898
  { IMAGE_LOAD_PCK_V5_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x5, 0x2 }, // 1899
  { IMAGE_LOAD_PCK_V5_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x5, 0x3 }, // 1900
  { IMAGE_LOAD_PCK_V5_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x5, 0x4 }, // 1901
  { IMAGE_LOAD_PCK_V1_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x1 }, // 1902
  { IMAGE_LOAD_PCK_V1_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x2 }, // 1903
  { IMAGE_LOAD_PCK_V1_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x3 }, // 1904
  { IMAGE_LOAD_PCK_V1_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x4 }, // 1905
  { IMAGE_LOAD_PCK_V2_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x1 }, // 1906
  { IMAGE_LOAD_PCK_V2_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x2 }, // 1907
  { IMAGE_LOAD_PCK_V2_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x3 }, // 1908
  { IMAGE_LOAD_PCK_V2_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x4 }, // 1909
  { IMAGE_LOAD_PCK_V3_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x1 }, // 1910
  { IMAGE_LOAD_PCK_V3_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x2 }, // 1911
  { IMAGE_LOAD_PCK_V3_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x3 }, // 1912
  { IMAGE_LOAD_PCK_V3_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x4 }, // 1913
  { IMAGE_LOAD_PCK_V4_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x1 }, // 1914
  { IMAGE_LOAD_PCK_V4_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x2 }, // 1915
  { IMAGE_LOAD_PCK_V4_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x3 }, // 1916
  { IMAGE_LOAD_PCK_V4_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x4 }, // 1917
  { IMAGE_LOAD_PCK_V5_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x5, 0x1 }, // 1918
  { IMAGE_LOAD_PCK_V5_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x5, 0x2 }, // 1919
  { IMAGE_LOAD_PCK_V5_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x5, 0x3 }, // 1920
  { IMAGE_LOAD_PCK_V5_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x5, 0x4 }, // 1921
  { IMAGE_LOAD_PCK_V1_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x1, 0x1 }, // 1922
  { IMAGE_LOAD_PCK_V1_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x1, 0x2 }, // 1923
  { IMAGE_LOAD_PCK_V1_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x1, 0x3 }, // 1924
  { IMAGE_LOAD_PCK_V1_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x1, 0x4 }, // 1925
  { IMAGE_LOAD_PCK_V2_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x2, 0x1 }, // 1926
  { IMAGE_LOAD_PCK_V2_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x2, 0x2 }, // 1927
  { IMAGE_LOAD_PCK_V2_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x2, 0x3 }, // 1928
  { IMAGE_LOAD_PCK_V2_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x2, 0x4 }, // 1929
  { IMAGE_LOAD_PCK_V3_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x3, 0x1 }, // 1930
  { IMAGE_LOAD_PCK_V3_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x3, 0x2 }, // 1931
  { IMAGE_LOAD_PCK_V3_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x3, 0x3 }, // 1932
  { IMAGE_LOAD_PCK_V3_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x3, 0x4 }, // 1933
  { IMAGE_LOAD_PCK_V4_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x4, 0x1 }, // 1934
  { IMAGE_LOAD_PCK_V4_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x4, 0x2 }, // 1935
  { IMAGE_LOAD_PCK_V4_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x4, 0x3 }, // 1936
  { IMAGE_LOAD_PCK_V4_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x4, 0x4 }, // 1937
  { IMAGE_LOAD_PCK_V5_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x5, 0x1 }, // 1938
  { IMAGE_LOAD_PCK_V5_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x5, 0x2 }, // 1939
  { IMAGE_LOAD_PCK_V5_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x5, 0x3 }, // 1940
  { IMAGE_LOAD_PCK_V5_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x5, 0x4 }, // 1941
  { IMAGE_LOAD_PCK_SGN_V1_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x1 }, // 1942
  { IMAGE_LOAD_PCK_SGN_V1_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x2 }, // 1943
  { IMAGE_LOAD_PCK_SGN_V1_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x3 }, // 1944
  { IMAGE_LOAD_PCK_SGN_V1_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x4 }, // 1945
  { IMAGE_LOAD_PCK_SGN_V2_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x1 }, // 1946
  { IMAGE_LOAD_PCK_SGN_V2_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x2 }, // 1947
  { IMAGE_LOAD_PCK_SGN_V2_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x3 }, // 1948
  { IMAGE_LOAD_PCK_SGN_V2_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x4 }, // 1949
  { IMAGE_LOAD_PCK_SGN_V3_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x1 }, // 1950
  { IMAGE_LOAD_PCK_SGN_V3_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x2 }, // 1951
  { IMAGE_LOAD_PCK_SGN_V3_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x3 }, // 1952
  { IMAGE_LOAD_PCK_SGN_V3_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x4 }, // 1953
  { IMAGE_LOAD_PCK_SGN_V4_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x1 }, // 1954
  { IMAGE_LOAD_PCK_SGN_V4_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x2 }, // 1955
  { IMAGE_LOAD_PCK_SGN_V4_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x3 }, // 1956
  { IMAGE_LOAD_PCK_SGN_V4_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x4 }, // 1957
  { IMAGE_LOAD_PCK_SGN_V5_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x1 }, // 1958
  { IMAGE_LOAD_PCK_SGN_V5_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x2 }, // 1959
  { IMAGE_LOAD_PCK_SGN_V5_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x3 }, // 1960
  { IMAGE_LOAD_PCK_SGN_V5_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x4 }, // 1961
  { IMAGE_LOAD_PCK_SGN_V1_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x2 }, // 1962
  { IMAGE_LOAD_PCK_SGN_V1_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x3 }, // 1963
  { IMAGE_LOAD_PCK_SGN_V1_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x4 }, // 1964
  { IMAGE_LOAD_PCK_SGN_V2_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x2 }, // 1965
  { IMAGE_LOAD_PCK_SGN_V2_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x3 }, // 1966
  { IMAGE_LOAD_PCK_SGN_V2_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x4 }, // 1967
  { IMAGE_LOAD_PCK_SGN_V3_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x2 }, // 1968
  { IMAGE_LOAD_PCK_SGN_V3_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x3 }, // 1969
  { IMAGE_LOAD_PCK_SGN_V3_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x4 }, // 1970
  { IMAGE_LOAD_PCK_SGN_V4_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x2 }, // 1971
  { IMAGE_LOAD_PCK_SGN_V4_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x3 }, // 1972
  { IMAGE_LOAD_PCK_SGN_V4_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x4 }, // 1973
  { IMAGE_LOAD_PCK_SGN_V5_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x2 }, // 1974
  { IMAGE_LOAD_PCK_SGN_V5_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x3 }, // 1975
  { IMAGE_LOAD_PCK_SGN_V5_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x4 }, // 1976
  { IMAGE_LOAD_PCK_SGN_V1_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x1 }, // 1977
  { IMAGE_LOAD_PCK_SGN_V1_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x2 }, // 1978
  { IMAGE_LOAD_PCK_SGN_V1_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x3 }, // 1979
  { IMAGE_LOAD_PCK_SGN_V1_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x4 }, // 1980
  { IMAGE_LOAD_PCK_SGN_V2_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x1 }, // 1981
  { IMAGE_LOAD_PCK_SGN_V2_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x2 }, // 1982
  { IMAGE_LOAD_PCK_SGN_V2_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x3 }, // 1983
  { IMAGE_LOAD_PCK_SGN_V2_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x4 }, // 1984
  { IMAGE_LOAD_PCK_SGN_V3_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x1 }, // 1985
  { IMAGE_LOAD_PCK_SGN_V3_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x2 }, // 1986
  { IMAGE_LOAD_PCK_SGN_V3_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x3 }, // 1987
  { IMAGE_LOAD_PCK_SGN_V3_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x4 }, // 1988
  { IMAGE_LOAD_PCK_SGN_V4_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x1 }, // 1989
  { IMAGE_LOAD_PCK_SGN_V4_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x2 }, // 1990
  { IMAGE_LOAD_PCK_SGN_V4_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x3 }, // 1991
  { IMAGE_LOAD_PCK_SGN_V4_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x4 }, // 1992
  { IMAGE_LOAD_PCK_SGN_V5_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x5, 0x1 }, // 1993
  { IMAGE_LOAD_PCK_SGN_V5_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x5, 0x2 }, // 1994
  { IMAGE_LOAD_PCK_SGN_V5_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x5, 0x3 }, // 1995
  { IMAGE_LOAD_PCK_SGN_V5_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x5, 0x4 }, // 1996
  { IMAGE_LOAD_PCK_SGN_V1_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x1, 0x1 }, // 1997
  { IMAGE_LOAD_PCK_SGN_V1_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x1, 0x2 }, // 1998
  { IMAGE_LOAD_PCK_SGN_V1_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x1, 0x3 }, // 1999
  { IMAGE_LOAD_PCK_SGN_V1_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x1, 0x4 }, // 2000
  { IMAGE_LOAD_PCK_SGN_V2_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x2, 0x1 }, // 2001
  { IMAGE_LOAD_PCK_SGN_V2_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x2, 0x2 }, // 2002
  { IMAGE_LOAD_PCK_SGN_V2_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x2, 0x3 }, // 2003
  { IMAGE_LOAD_PCK_SGN_V2_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x2, 0x4 }, // 2004
  { IMAGE_LOAD_PCK_SGN_V3_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x3, 0x1 }, // 2005
  { IMAGE_LOAD_PCK_SGN_V3_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x3, 0x2 }, // 2006
  { IMAGE_LOAD_PCK_SGN_V3_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x3, 0x3 }, // 2007
  { IMAGE_LOAD_PCK_SGN_V3_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x3, 0x4 }, // 2008
  { IMAGE_LOAD_PCK_SGN_V4_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x4, 0x1 }, // 2009
  { IMAGE_LOAD_PCK_SGN_V4_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x4, 0x2 }, // 2010
  { IMAGE_LOAD_PCK_SGN_V4_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x4, 0x3 }, // 2011
  { IMAGE_LOAD_PCK_SGN_V4_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x4, 0x4 }, // 2012
  { IMAGE_LOAD_PCK_SGN_V5_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x5, 0x1 }, // 2013
  { IMAGE_LOAD_PCK_SGN_V5_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x5, 0x2 }, // 2014
  { IMAGE_LOAD_PCK_SGN_V5_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x5, 0x3 }, // 2015
  { IMAGE_LOAD_PCK_SGN_V5_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x5, 0x4 }, // 2016
  { IMAGE_MSAA_LOAD_X_V1_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x1, 0x1 }, // 2017
  { IMAGE_MSAA_LOAD_X_V1_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x1, 0x2 }, // 2018
  { IMAGE_MSAA_LOAD_X_V1_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x1, 0x3 }, // 2019
  { IMAGE_MSAA_LOAD_X_V1_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x1, 0x4 }, // 2020
  { IMAGE_MSAA_LOAD_X_V2_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x2, 0x1 }, // 2021
  { IMAGE_MSAA_LOAD_X_V2_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x2, 0x2 }, // 2022
  { IMAGE_MSAA_LOAD_X_V2_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x2, 0x3 }, // 2023
  { IMAGE_MSAA_LOAD_X_V2_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x2, 0x4 }, // 2024
  { IMAGE_MSAA_LOAD_X_V3_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x3, 0x1 }, // 2025
  { IMAGE_MSAA_LOAD_X_V3_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x3, 0x2 }, // 2026
  { IMAGE_MSAA_LOAD_X_V3_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x3, 0x3 }, // 2027
  { IMAGE_MSAA_LOAD_X_V3_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x3, 0x4 }, // 2028
  { IMAGE_MSAA_LOAD_X_V4_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x4, 0x1 }, // 2029
  { IMAGE_MSAA_LOAD_X_V4_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x4, 0x2 }, // 2030
  { IMAGE_MSAA_LOAD_X_V4_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x4, 0x3 }, // 2031
  { IMAGE_MSAA_LOAD_X_V4_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x4, 0x4 }, // 2032
  { IMAGE_MSAA_LOAD_X_V5_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x5, 0x1 }, // 2033
  { IMAGE_MSAA_LOAD_X_V5_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x5, 0x2 }, // 2034
  { IMAGE_MSAA_LOAD_X_V5_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x5, 0x3 }, // 2035
  { IMAGE_MSAA_LOAD_X_V5_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x5, 0x4 }, // 2036
  { IMAGE_MSAA_LOAD_X_V1_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x1, 0x2 }, // 2037
  { IMAGE_MSAA_LOAD_X_V1_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x1, 0x3 }, // 2038
  { IMAGE_MSAA_LOAD_X_V1_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x1, 0x4 }, // 2039
  { IMAGE_MSAA_LOAD_X_V2_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x2, 0x2 }, // 2040
  { IMAGE_MSAA_LOAD_X_V2_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x2, 0x3 }, // 2041
  { IMAGE_MSAA_LOAD_X_V2_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x2, 0x4 }, // 2042
  { IMAGE_MSAA_LOAD_X_V3_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x3, 0x2 }, // 2043
  { IMAGE_MSAA_LOAD_X_V3_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x3, 0x3 }, // 2044
  { IMAGE_MSAA_LOAD_X_V3_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x3, 0x4 }, // 2045
  { IMAGE_MSAA_LOAD_X_V4_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x4, 0x2 }, // 2046
  { IMAGE_MSAA_LOAD_X_V4_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x4, 0x3 }, // 2047
  { IMAGE_MSAA_LOAD_X_V4_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x4, 0x4 }, // 2048
  { IMAGE_MSAA_LOAD_X_V5_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x5, 0x2 }, // 2049
  { IMAGE_MSAA_LOAD_X_V5_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x5, 0x3 }, // 2050
  { IMAGE_MSAA_LOAD_X_V5_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x5, 0x4 }, // 2051
  { IMAGE_MSAA_LOAD_X_V1_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x1, 0x1 }, // 2052
  { IMAGE_MSAA_LOAD_X_V1_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x1, 0x2 }, // 2053
  { IMAGE_MSAA_LOAD_X_V1_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x1, 0x3 }, // 2054
  { IMAGE_MSAA_LOAD_X_V1_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x1, 0x4 }, // 2055
  { IMAGE_MSAA_LOAD_X_V2_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x2, 0x1 }, // 2056
  { IMAGE_MSAA_LOAD_X_V2_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x2, 0x2 }, // 2057
  { IMAGE_MSAA_LOAD_X_V2_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x2, 0x3 }, // 2058
  { IMAGE_MSAA_LOAD_X_V2_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x2, 0x4 }, // 2059
  { IMAGE_MSAA_LOAD_X_V3_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x3, 0x1 }, // 2060
  { IMAGE_MSAA_LOAD_X_V3_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x3, 0x2 }, // 2061
  { IMAGE_MSAA_LOAD_X_V3_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x3, 0x3 }, // 2062
  { IMAGE_MSAA_LOAD_X_V3_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x3, 0x4 }, // 2063
  { IMAGE_MSAA_LOAD_X_V4_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x4, 0x1 }, // 2064
  { IMAGE_MSAA_LOAD_X_V4_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x4, 0x2 }, // 2065
  { IMAGE_MSAA_LOAD_X_V4_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x4, 0x3 }, // 2066
  { IMAGE_MSAA_LOAD_X_V4_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x4, 0x4 }, // 2067
  { IMAGE_MSAA_LOAD_X_V5_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x5, 0x1 }, // 2068
  { IMAGE_MSAA_LOAD_X_V5_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x5, 0x2 }, // 2069
  { IMAGE_MSAA_LOAD_X_V5_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x5, 0x3 }, // 2070
  { IMAGE_MSAA_LOAD_X_V5_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x5, 0x4 }, // 2071
  { IMAGE_SAMPLE_V1_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x1, 0x1 }, // 2072
  { IMAGE_SAMPLE_V1_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x1, 0x2 }, // 2073
  { IMAGE_SAMPLE_V1_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x1, 0x3 }, // 2074
  { IMAGE_SAMPLE_V1_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x1, 0x4 }, // 2075
  { IMAGE_SAMPLE_V2_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x2, 0x1 }, // 2076
  { IMAGE_SAMPLE_V2_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x2, 0x2 }, // 2077
  { IMAGE_SAMPLE_V2_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x2, 0x3 }, // 2078
  { IMAGE_SAMPLE_V2_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x2, 0x4 }, // 2079
  { IMAGE_SAMPLE_V3_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x3, 0x1 }, // 2080
  { IMAGE_SAMPLE_V3_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x3, 0x2 }, // 2081
  { IMAGE_SAMPLE_V3_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x3, 0x3 }, // 2082
  { IMAGE_SAMPLE_V3_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x3, 0x4 }, // 2083
  { IMAGE_SAMPLE_V4_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x4, 0x1 }, // 2084
  { IMAGE_SAMPLE_V4_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x4, 0x2 }, // 2085
  { IMAGE_SAMPLE_V4_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x4, 0x3 }, // 2086
  { IMAGE_SAMPLE_V4_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x4, 0x4 }, // 2087
  { IMAGE_SAMPLE_V5_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x5, 0x1 }, // 2088
  { IMAGE_SAMPLE_V5_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x5, 0x2 }, // 2089
  { IMAGE_SAMPLE_V5_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x5, 0x3 }, // 2090
  { IMAGE_SAMPLE_V5_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x5, 0x4 }, // 2091
  { IMAGE_SAMPLE_V1_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x1, 0x2 }, // 2092
  { IMAGE_SAMPLE_V1_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x1, 0x3 }, // 2093
  { IMAGE_SAMPLE_V2_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x2, 0x2 }, // 2094
  { IMAGE_SAMPLE_V2_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x2, 0x3 }, // 2095
  { IMAGE_SAMPLE_V3_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x3, 0x2 }, // 2096
  { IMAGE_SAMPLE_V3_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x3, 0x3 }, // 2097
  { IMAGE_SAMPLE_V4_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x4, 0x2 }, // 2098
  { IMAGE_SAMPLE_V4_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x4, 0x3 }, // 2099
  { IMAGE_SAMPLE_V5_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x5, 0x2 }, // 2100
  { IMAGE_SAMPLE_V5_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x5, 0x3 }, // 2101
  { IMAGE_SAMPLE_V1_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x1 }, // 2102
  { IMAGE_SAMPLE_V1_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x2 }, // 2103
  { IMAGE_SAMPLE_V1_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x3 }, // 2104
  { IMAGE_SAMPLE_V1_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x4 }, // 2105
  { IMAGE_SAMPLE_V2_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x1 }, // 2106
  { IMAGE_SAMPLE_V2_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x2 }, // 2107
  { IMAGE_SAMPLE_V2_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x3 }, // 2108
  { IMAGE_SAMPLE_V2_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x4 }, // 2109
  { IMAGE_SAMPLE_V3_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x1 }, // 2110
  { IMAGE_SAMPLE_V3_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x2 }, // 2111
  { IMAGE_SAMPLE_V3_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x3 }, // 2112
  { IMAGE_SAMPLE_V3_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x4 }, // 2113
  { IMAGE_SAMPLE_V4_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x1 }, // 2114
  { IMAGE_SAMPLE_V4_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x2 }, // 2115
  { IMAGE_SAMPLE_V4_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x3 }, // 2116
  { IMAGE_SAMPLE_V4_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x4 }, // 2117
  { IMAGE_SAMPLE_V5_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x5, 0x1 }, // 2118
  { IMAGE_SAMPLE_V5_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x5, 0x2 }, // 2119
  { IMAGE_SAMPLE_V5_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x5, 0x3 }, // 2120
  { IMAGE_SAMPLE_V5_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x5, 0x4 }, // 2121
  { IMAGE_SAMPLE_V1_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x1, 0x1 }, // 2122
  { IMAGE_SAMPLE_V1_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x1, 0x2 }, // 2123
  { IMAGE_SAMPLE_V1_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x1, 0x3 }, // 2124
  { IMAGE_SAMPLE_V1_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x1, 0x4 }, // 2125
  { IMAGE_SAMPLE_V2_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x2, 0x1 }, // 2126
  { IMAGE_SAMPLE_V2_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x2, 0x2 }, // 2127
  { IMAGE_SAMPLE_V2_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x2, 0x3 }, // 2128
  { IMAGE_SAMPLE_V2_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x2, 0x4 }, // 2129
  { IMAGE_SAMPLE_V3_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x3, 0x1 }, // 2130
  { IMAGE_SAMPLE_V3_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x3, 0x2 }, // 2131
  { IMAGE_SAMPLE_V3_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x3, 0x3 }, // 2132
  { IMAGE_SAMPLE_V3_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x3, 0x4 }, // 2133
  { IMAGE_SAMPLE_V4_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x4, 0x1 }, // 2134
  { IMAGE_SAMPLE_V4_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x4, 0x2 }, // 2135
  { IMAGE_SAMPLE_V4_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x4, 0x3 }, // 2136
  { IMAGE_SAMPLE_V4_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x4, 0x4 }, // 2137
  { IMAGE_SAMPLE_V5_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x5, 0x1 }, // 2138
  { IMAGE_SAMPLE_V5_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x5, 0x2 }, // 2139
  { IMAGE_SAMPLE_V5_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x5, 0x3 }, // 2140
  { IMAGE_SAMPLE_V5_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x5, 0x4 }, // 2141
  { IMAGE_SAMPLE_B_V1_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x1, 0x2 }, // 2142
  { IMAGE_SAMPLE_B_V1_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x1, 0x3 }, // 2143
  { IMAGE_SAMPLE_B_V1_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x1, 0x4 }, // 2144
  { IMAGE_SAMPLE_B_V2_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x2, 0x2 }, // 2145
  { IMAGE_SAMPLE_B_V2_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x2, 0x3 }, // 2146
  { IMAGE_SAMPLE_B_V2_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x2, 0x4 }, // 2147
  { IMAGE_SAMPLE_B_V3_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x3, 0x2 }, // 2148
  { IMAGE_SAMPLE_B_V3_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x3, 0x3 }, // 2149
  { IMAGE_SAMPLE_B_V3_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x3, 0x4 }, // 2150
  { IMAGE_SAMPLE_B_V4_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x4, 0x2 }, // 2151
  { IMAGE_SAMPLE_B_V4_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x4, 0x3 }, // 2152
  { IMAGE_SAMPLE_B_V4_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x4, 0x4 }, // 2153
  { IMAGE_SAMPLE_B_V5_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x5, 0x2 }, // 2154
  { IMAGE_SAMPLE_B_V5_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x5, 0x3 }, // 2155
  { IMAGE_SAMPLE_B_V5_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x5, 0x4 }, // 2156
  { IMAGE_SAMPLE_B_V1_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x1, 0x2 }, // 2157
  { IMAGE_SAMPLE_B_V1_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x1, 0x3 }, // 2158
  { IMAGE_SAMPLE_B_V1_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x1, 0x4 }, // 2159
  { IMAGE_SAMPLE_B_V2_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x2, 0x2 }, // 2160
  { IMAGE_SAMPLE_B_V2_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x2, 0x3 }, // 2161
  { IMAGE_SAMPLE_B_V2_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x2, 0x4 }, // 2162
  { IMAGE_SAMPLE_B_V3_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x3, 0x2 }, // 2163
  { IMAGE_SAMPLE_B_V3_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x3, 0x3 }, // 2164
  { IMAGE_SAMPLE_B_V3_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x3, 0x4 }, // 2165
  { IMAGE_SAMPLE_B_V4_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x4, 0x2 }, // 2166
  { IMAGE_SAMPLE_B_V4_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x4, 0x3 }, // 2167
  { IMAGE_SAMPLE_B_V4_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x4, 0x4 }, // 2168
  { IMAGE_SAMPLE_B_V5_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x5, 0x2 }, // 2169
  { IMAGE_SAMPLE_B_V5_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x5, 0x3 }, // 2170
  { IMAGE_SAMPLE_B_V5_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x5, 0x4 }, // 2171
  { IMAGE_SAMPLE_B_V1_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x1, 0x2 }, // 2172
  { IMAGE_SAMPLE_B_V1_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x1, 0x3 }, // 2173
  { IMAGE_SAMPLE_B_V1_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x1, 0x4 }, // 2174
  { IMAGE_SAMPLE_B_V2_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x2, 0x2 }, // 2175
  { IMAGE_SAMPLE_B_V2_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x2, 0x3 }, // 2176
  { IMAGE_SAMPLE_B_V2_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x2, 0x4 }, // 2177
  { IMAGE_SAMPLE_B_V3_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x3, 0x2 }, // 2178
  { IMAGE_SAMPLE_B_V3_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x3, 0x3 }, // 2179
  { IMAGE_SAMPLE_B_V3_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x3, 0x4 }, // 2180
  { IMAGE_SAMPLE_B_V4_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x4, 0x2 }, // 2181
  { IMAGE_SAMPLE_B_V4_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x4, 0x3 }, // 2182
  { IMAGE_SAMPLE_B_V4_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x4, 0x4 }, // 2183
  { IMAGE_SAMPLE_B_V5_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x5, 0x2 }, // 2184
  { IMAGE_SAMPLE_B_V5_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x5, 0x3 }, // 2185
  { IMAGE_SAMPLE_B_V5_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x5, 0x4 }, // 2186
  { IMAGE_SAMPLE_B_CL_V1_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x2 }, // 2187
  { IMAGE_SAMPLE_B_CL_V1_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x3 }, // 2188
  { IMAGE_SAMPLE_B_CL_V1_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x4 }, // 2189
  { IMAGE_SAMPLE_B_CL_V1_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x5 }, // 2190
  { IMAGE_SAMPLE_B_CL_V1_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x8 }, // 2191
  { IMAGE_SAMPLE_B_CL_V2_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x2 }, // 2192
  { IMAGE_SAMPLE_B_CL_V2_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x3 }, // 2193
  { IMAGE_SAMPLE_B_CL_V2_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x4 }, // 2194
  { IMAGE_SAMPLE_B_CL_V2_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x5 }, // 2195
  { IMAGE_SAMPLE_B_CL_V2_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x8 }, // 2196
  { IMAGE_SAMPLE_B_CL_V3_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x2 }, // 2197
  { IMAGE_SAMPLE_B_CL_V3_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x3 }, // 2198
  { IMAGE_SAMPLE_B_CL_V3_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x4 }, // 2199
  { IMAGE_SAMPLE_B_CL_V3_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x5 }, // 2200
  { IMAGE_SAMPLE_B_CL_V3_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x8 }, // 2201
  { IMAGE_SAMPLE_B_CL_V4_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x2 }, // 2202
  { IMAGE_SAMPLE_B_CL_V4_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x3 }, // 2203
  { IMAGE_SAMPLE_B_CL_V4_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x4 }, // 2204
  { IMAGE_SAMPLE_B_CL_V4_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x5 }, // 2205
  { IMAGE_SAMPLE_B_CL_V4_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x8 }, // 2206
  { IMAGE_SAMPLE_B_CL_V5_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x2 }, // 2207
  { IMAGE_SAMPLE_B_CL_V5_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x3 }, // 2208
  { IMAGE_SAMPLE_B_CL_V5_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x4 }, // 2209
  { IMAGE_SAMPLE_B_CL_V5_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x5 }, // 2210
  { IMAGE_SAMPLE_B_CL_V5_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x8 }, // 2211
  { IMAGE_SAMPLE_B_CL_V1_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x1, 0x2 }, // 2212
  { IMAGE_SAMPLE_B_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x1, 0x3 }, // 2213
  { IMAGE_SAMPLE_B_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x1, 0x4 }, // 2214
  { IMAGE_SAMPLE_B_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x1, 0x5 }, // 2215
  { IMAGE_SAMPLE_B_CL_V2_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x2, 0x2 }, // 2216
  { IMAGE_SAMPLE_B_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x2, 0x3 }, // 2217
  { IMAGE_SAMPLE_B_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x2, 0x4 }, // 2218
  { IMAGE_SAMPLE_B_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x2, 0x5 }, // 2219
  { IMAGE_SAMPLE_B_CL_V3_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x3, 0x2 }, // 2220
  { IMAGE_SAMPLE_B_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x3, 0x3 }, // 2221
  { IMAGE_SAMPLE_B_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x3, 0x4 }, // 2222
  { IMAGE_SAMPLE_B_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x3, 0x5 }, // 2223
  { IMAGE_SAMPLE_B_CL_V4_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x4, 0x2 }, // 2224
  { IMAGE_SAMPLE_B_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x4, 0x3 }, // 2225
  { IMAGE_SAMPLE_B_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x4, 0x4 }, // 2226
  { IMAGE_SAMPLE_B_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x4, 0x5 }, // 2227
  { IMAGE_SAMPLE_B_CL_V5_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x5, 0x2 }, // 2228
  { IMAGE_SAMPLE_B_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x5, 0x3 }, // 2229
  { IMAGE_SAMPLE_B_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x5, 0x4 }, // 2230
  { IMAGE_SAMPLE_B_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x5, 0x5 }, // 2231
  { IMAGE_SAMPLE_B_CL_V1_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x2 }, // 2232
  { IMAGE_SAMPLE_B_CL_V1_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x3 }, // 2233
  { IMAGE_SAMPLE_B_CL_V1_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x4 }, // 2234
  { IMAGE_SAMPLE_B_CL_V1_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x5 }, // 2235
  { IMAGE_SAMPLE_B_CL_V1_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x8 }, // 2236
  { IMAGE_SAMPLE_B_CL_V2_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x2 }, // 2237
  { IMAGE_SAMPLE_B_CL_V2_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x3 }, // 2238
  { IMAGE_SAMPLE_B_CL_V2_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x4 }, // 2239
  { IMAGE_SAMPLE_B_CL_V2_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x5 }, // 2240
  { IMAGE_SAMPLE_B_CL_V2_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x8 }, // 2241
  { IMAGE_SAMPLE_B_CL_V3_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x2 }, // 2242
  { IMAGE_SAMPLE_B_CL_V3_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x3 }, // 2243
  { IMAGE_SAMPLE_B_CL_V3_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x4 }, // 2244
  { IMAGE_SAMPLE_B_CL_V3_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x5 }, // 2245
  { IMAGE_SAMPLE_B_CL_V3_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x8 }, // 2246
  { IMAGE_SAMPLE_B_CL_V4_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x2 }, // 2247
  { IMAGE_SAMPLE_B_CL_V4_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x3 }, // 2248
  { IMAGE_SAMPLE_B_CL_V4_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x4 }, // 2249
  { IMAGE_SAMPLE_B_CL_V4_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x5 }, // 2250
  { IMAGE_SAMPLE_B_CL_V4_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x8 }, // 2251
  { IMAGE_SAMPLE_B_CL_V5_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x2 }, // 2252
  { IMAGE_SAMPLE_B_CL_V5_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x3 }, // 2253
  { IMAGE_SAMPLE_B_CL_V5_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x4 }, // 2254
  { IMAGE_SAMPLE_B_CL_V5_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x5 }, // 2255
  { IMAGE_SAMPLE_B_CL_V5_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x8 }, // 2256
  { IMAGE_SAMPLE_B_CL_O_V1_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x3 }, // 2257
  { IMAGE_SAMPLE_B_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x4 }, // 2258
  { IMAGE_SAMPLE_B_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x5 }, // 2259
  { IMAGE_SAMPLE_B_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x6 }, // 2260
  { IMAGE_SAMPLE_B_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x8 }, // 2261
  { IMAGE_SAMPLE_B_CL_O_V2_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 2262
  { IMAGE_SAMPLE_B_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 2263
  { IMAGE_SAMPLE_B_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 2264
  { IMAGE_SAMPLE_B_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x6 }, // 2265
  { IMAGE_SAMPLE_B_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 2266
  { IMAGE_SAMPLE_B_CL_O_V3_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x3 }, // 2267
  { IMAGE_SAMPLE_B_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x4 }, // 2268
  { IMAGE_SAMPLE_B_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x5 }, // 2269
  { IMAGE_SAMPLE_B_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x6 }, // 2270
  { IMAGE_SAMPLE_B_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x8 }, // 2271
  { IMAGE_SAMPLE_B_CL_O_V4_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 2272
  { IMAGE_SAMPLE_B_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 2273
  { IMAGE_SAMPLE_B_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 2274
  { IMAGE_SAMPLE_B_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x6 }, // 2275
  { IMAGE_SAMPLE_B_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 2276
  { IMAGE_SAMPLE_B_CL_O_V5_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 2277
  { IMAGE_SAMPLE_B_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 2278
  { IMAGE_SAMPLE_B_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 2279
  { IMAGE_SAMPLE_B_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x6 }, // 2280
  { IMAGE_SAMPLE_B_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 2281
  { IMAGE_SAMPLE_B_CL_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x3 }, // 2282
  { IMAGE_SAMPLE_B_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x4 }, // 2283
  { IMAGE_SAMPLE_B_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x5 }, // 2284
  { IMAGE_SAMPLE_B_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x6 }, // 2285
  { IMAGE_SAMPLE_B_CL_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 2286
  { IMAGE_SAMPLE_B_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 2287
  { IMAGE_SAMPLE_B_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 2288
  { IMAGE_SAMPLE_B_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x6 }, // 2289
  { IMAGE_SAMPLE_B_CL_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x3 }, // 2290
  { IMAGE_SAMPLE_B_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x4 }, // 2291
  { IMAGE_SAMPLE_B_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x5 }, // 2292
  { IMAGE_SAMPLE_B_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x6 }, // 2293
  { IMAGE_SAMPLE_B_CL_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 2294
  { IMAGE_SAMPLE_B_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 2295
  { IMAGE_SAMPLE_B_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 2296
  { IMAGE_SAMPLE_B_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x6 }, // 2297
  { IMAGE_SAMPLE_B_CL_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 2298
  { IMAGE_SAMPLE_B_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 2299
  { IMAGE_SAMPLE_B_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 2300
  { IMAGE_SAMPLE_B_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x6 }, // 2301
  { IMAGE_SAMPLE_B_CL_O_V1_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x3 }, // 2302
  { IMAGE_SAMPLE_B_CL_O_V1_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x4 }, // 2303
  { IMAGE_SAMPLE_B_CL_O_V1_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x5 }, // 2304
  { IMAGE_SAMPLE_B_CL_O_V1_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x6 }, // 2305
  { IMAGE_SAMPLE_B_CL_O_V1_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x8 }, // 2306
  { IMAGE_SAMPLE_B_CL_O_V2_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x3 }, // 2307
  { IMAGE_SAMPLE_B_CL_O_V2_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 2308
  { IMAGE_SAMPLE_B_CL_O_V2_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x5 }, // 2309
  { IMAGE_SAMPLE_B_CL_O_V2_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x6 }, // 2310
  { IMAGE_SAMPLE_B_CL_O_V2_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 2311
  { IMAGE_SAMPLE_B_CL_O_V3_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x3 }, // 2312
  { IMAGE_SAMPLE_B_CL_O_V3_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x4 }, // 2313
  { IMAGE_SAMPLE_B_CL_O_V3_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x5 }, // 2314
  { IMAGE_SAMPLE_B_CL_O_V3_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x6 }, // 2315
  { IMAGE_SAMPLE_B_CL_O_V3_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x8 }, // 2316
  { IMAGE_SAMPLE_B_CL_O_V4_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x3 }, // 2317
  { IMAGE_SAMPLE_B_CL_O_V4_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 2318
  { IMAGE_SAMPLE_B_CL_O_V4_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x5 }, // 2319
  { IMAGE_SAMPLE_B_CL_O_V4_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x6 }, // 2320
  { IMAGE_SAMPLE_B_CL_O_V4_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 2321
  { IMAGE_SAMPLE_B_CL_O_V5_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x3 }, // 2322
  { IMAGE_SAMPLE_B_CL_O_V5_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x4 }, // 2323
  { IMAGE_SAMPLE_B_CL_O_V5_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x5 }, // 2324
  { IMAGE_SAMPLE_B_CL_O_V5_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x6 }, // 2325
  { IMAGE_SAMPLE_B_CL_O_V5_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x8 }, // 2326
  { IMAGE_SAMPLE_B_O_V1_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x1, 0x3 }, // 2327
  { IMAGE_SAMPLE_B_O_V1_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x1, 0x4 }, // 2328
  { IMAGE_SAMPLE_B_O_V1_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x1, 0x5 }, // 2329
  { IMAGE_SAMPLE_B_O_V1_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x1, 0x8 }, // 2330
  { IMAGE_SAMPLE_B_O_V2_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 2331
  { IMAGE_SAMPLE_B_O_V2_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 2332
  { IMAGE_SAMPLE_B_O_V2_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 2333
  { IMAGE_SAMPLE_B_O_V2_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 2334
  { IMAGE_SAMPLE_B_O_V3_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x3, 0x3 }, // 2335
  { IMAGE_SAMPLE_B_O_V3_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x3, 0x4 }, // 2336
  { IMAGE_SAMPLE_B_O_V3_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x3, 0x5 }, // 2337
  { IMAGE_SAMPLE_B_O_V3_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x3, 0x8 }, // 2338
  { IMAGE_SAMPLE_B_O_V4_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 2339
  { IMAGE_SAMPLE_B_O_V4_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 2340
  { IMAGE_SAMPLE_B_O_V4_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 2341
  { IMAGE_SAMPLE_B_O_V4_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 2342
  { IMAGE_SAMPLE_B_O_V5_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 2343
  { IMAGE_SAMPLE_B_O_V5_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 2344
  { IMAGE_SAMPLE_B_O_V5_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 2345
  { IMAGE_SAMPLE_B_O_V5_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 2346
  { IMAGE_SAMPLE_B_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x1, 0x3 }, // 2347
  { IMAGE_SAMPLE_B_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x1, 0x4 }, // 2348
  { IMAGE_SAMPLE_B_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x1, 0x5 }, // 2349
  { IMAGE_SAMPLE_B_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 2350
  { IMAGE_SAMPLE_B_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 2351
  { IMAGE_SAMPLE_B_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 2352
  { IMAGE_SAMPLE_B_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x3, 0x3 }, // 2353
  { IMAGE_SAMPLE_B_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x3, 0x4 }, // 2354
  { IMAGE_SAMPLE_B_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x3, 0x5 }, // 2355
  { IMAGE_SAMPLE_B_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 2356
  { IMAGE_SAMPLE_B_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 2357
  { IMAGE_SAMPLE_B_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 2358
  { IMAGE_SAMPLE_B_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 2359
  { IMAGE_SAMPLE_B_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 2360
  { IMAGE_SAMPLE_B_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 2361
  { IMAGE_SAMPLE_B_O_V1_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x3 }, // 2362
  { IMAGE_SAMPLE_B_O_V1_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x4 }, // 2363
  { IMAGE_SAMPLE_B_O_V1_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x5 }, // 2364
  { IMAGE_SAMPLE_B_O_V1_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x8 }, // 2365
  { IMAGE_SAMPLE_B_O_V2_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x3 }, // 2366
  { IMAGE_SAMPLE_B_O_V2_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x4 }, // 2367
  { IMAGE_SAMPLE_B_O_V2_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x5 }, // 2368
  { IMAGE_SAMPLE_B_O_V2_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x8 }, // 2369
  { IMAGE_SAMPLE_B_O_V3_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x3 }, // 2370
  { IMAGE_SAMPLE_B_O_V3_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x4 }, // 2371
  { IMAGE_SAMPLE_B_O_V3_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x5 }, // 2372
  { IMAGE_SAMPLE_B_O_V3_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x8 }, // 2373
  { IMAGE_SAMPLE_B_O_V4_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x3 }, // 2374
  { IMAGE_SAMPLE_B_O_V4_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x4 }, // 2375
  { IMAGE_SAMPLE_B_O_V4_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x5 }, // 2376
  { IMAGE_SAMPLE_B_O_V4_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x8 }, // 2377
  { IMAGE_SAMPLE_B_O_V5_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x5, 0x3 }, // 2378
  { IMAGE_SAMPLE_B_O_V5_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x5, 0x4 }, // 2379
  { IMAGE_SAMPLE_B_O_V5_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x5, 0x5 }, // 2380
  { IMAGE_SAMPLE_B_O_V5_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x5, 0x8 }, // 2381
  { IMAGE_SAMPLE_C_V1_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x1, 0x2 }, // 2382
  { IMAGE_SAMPLE_C_V1_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x1, 0x3 }, // 2383
  { IMAGE_SAMPLE_C_V1_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x1, 0x4 }, // 2384
  { IMAGE_SAMPLE_C_V2_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x2, 0x2 }, // 2385
  { IMAGE_SAMPLE_C_V2_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x2, 0x3 }, // 2386
  { IMAGE_SAMPLE_C_V2_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x2, 0x4 }, // 2387
  { IMAGE_SAMPLE_C_V3_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x3, 0x2 }, // 2388
  { IMAGE_SAMPLE_C_V3_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x3, 0x3 }, // 2389
  { IMAGE_SAMPLE_C_V3_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x3, 0x4 }, // 2390
  { IMAGE_SAMPLE_C_V4_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x4, 0x2 }, // 2391
  { IMAGE_SAMPLE_C_V4_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x4, 0x3 }, // 2392
  { IMAGE_SAMPLE_C_V4_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x4, 0x4 }, // 2393
  { IMAGE_SAMPLE_C_V5_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x5, 0x2 }, // 2394
  { IMAGE_SAMPLE_C_V5_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x5, 0x3 }, // 2395
  { IMAGE_SAMPLE_C_V5_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x5, 0x4 }, // 2396
  { IMAGE_SAMPLE_C_V1_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x1, 0x2 }, // 2397
  { IMAGE_SAMPLE_C_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x1, 0x3 }, // 2398
  { IMAGE_SAMPLE_C_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x1, 0x4 }, // 2399
  { IMAGE_SAMPLE_C_V2_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x2, 0x2 }, // 2400
  { IMAGE_SAMPLE_C_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x2, 0x3 }, // 2401
  { IMAGE_SAMPLE_C_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x2, 0x4 }, // 2402
  { IMAGE_SAMPLE_C_V3_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x3, 0x2 }, // 2403
  { IMAGE_SAMPLE_C_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x3, 0x3 }, // 2404
  { IMAGE_SAMPLE_C_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x3, 0x4 }, // 2405
  { IMAGE_SAMPLE_C_V4_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x4, 0x2 }, // 2406
  { IMAGE_SAMPLE_C_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x4, 0x3 }, // 2407
  { IMAGE_SAMPLE_C_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x4, 0x4 }, // 2408
  { IMAGE_SAMPLE_C_V5_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x5, 0x2 }, // 2409
  { IMAGE_SAMPLE_C_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x5, 0x3 }, // 2410
  { IMAGE_SAMPLE_C_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x5, 0x4 }, // 2411
  { IMAGE_SAMPLE_C_V1_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x1, 0x2 }, // 2412
  { IMAGE_SAMPLE_C_V1_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x1, 0x3 }, // 2413
  { IMAGE_SAMPLE_C_V1_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x1, 0x4 }, // 2414
  { IMAGE_SAMPLE_C_V2_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x2, 0x2 }, // 2415
  { IMAGE_SAMPLE_C_V2_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x2, 0x3 }, // 2416
  { IMAGE_SAMPLE_C_V2_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x2, 0x4 }, // 2417
  { IMAGE_SAMPLE_C_V3_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x3, 0x2 }, // 2418
  { IMAGE_SAMPLE_C_V3_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x3, 0x3 }, // 2419
  { IMAGE_SAMPLE_C_V3_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x3, 0x4 }, // 2420
  { IMAGE_SAMPLE_C_V4_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x4, 0x2 }, // 2421
  { IMAGE_SAMPLE_C_V4_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x4, 0x3 }, // 2422
  { IMAGE_SAMPLE_C_V4_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x4, 0x4 }, // 2423
  { IMAGE_SAMPLE_C_V5_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x5, 0x2 }, // 2424
  { IMAGE_SAMPLE_C_V5_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x5, 0x3 }, // 2425
  { IMAGE_SAMPLE_C_V5_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x5, 0x4 }, // 2426
  { IMAGE_SAMPLE_CD_V1_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x2 }, // 2427
  { IMAGE_SAMPLE_CD_V1_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x3 }, // 2428
  { IMAGE_SAMPLE_CD_V1_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x4 }, // 2429
  { IMAGE_SAMPLE_CD_V1_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x5 }, // 2430
  { IMAGE_SAMPLE_CD_V1_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x6 }, // 2431
  { IMAGE_SAMPLE_CD_V1_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x7 }, // 2432
  { IMAGE_SAMPLE_CD_V1_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x8 }, // 2433
  { IMAGE_SAMPLE_CD_V1_V16_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x10 }, // 2434
  { IMAGE_SAMPLE_CD_V2_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x2 }, // 2435
  { IMAGE_SAMPLE_CD_V2_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x3 }, // 2436
  { IMAGE_SAMPLE_CD_V2_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x4 }, // 2437
  { IMAGE_SAMPLE_CD_V2_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x5 }, // 2438
  { IMAGE_SAMPLE_CD_V2_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x6 }, // 2439
  { IMAGE_SAMPLE_CD_V2_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x7 }, // 2440
  { IMAGE_SAMPLE_CD_V2_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x8 }, // 2441
  { IMAGE_SAMPLE_CD_V2_V16_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x10 }, // 2442
  { IMAGE_SAMPLE_CD_V3_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x2 }, // 2443
  { IMAGE_SAMPLE_CD_V3_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x3 }, // 2444
  { IMAGE_SAMPLE_CD_V3_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x4 }, // 2445
  { IMAGE_SAMPLE_CD_V3_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x5 }, // 2446
  { IMAGE_SAMPLE_CD_V3_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x6 }, // 2447
  { IMAGE_SAMPLE_CD_V3_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x7 }, // 2448
  { IMAGE_SAMPLE_CD_V3_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x8 }, // 2449
  { IMAGE_SAMPLE_CD_V3_V16_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x10 }, // 2450
  { IMAGE_SAMPLE_CD_V4_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x2 }, // 2451
  { IMAGE_SAMPLE_CD_V4_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x3 }, // 2452
  { IMAGE_SAMPLE_CD_V4_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x4 }, // 2453
  { IMAGE_SAMPLE_CD_V4_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x5 }, // 2454
  { IMAGE_SAMPLE_CD_V4_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x6 }, // 2455
  { IMAGE_SAMPLE_CD_V4_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x7 }, // 2456
  { IMAGE_SAMPLE_CD_V4_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x8 }, // 2457
  { IMAGE_SAMPLE_CD_V4_V16_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x10 }, // 2458
  { IMAGE_SAMPLE_CD_V5_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x2 }, // 2459
  { IMAGE_SAMPLE_CD_V5_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x3 }, // 2460
  { IMAGE_SAMPLE_CD_V5_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x4 }, // 2461
  { IMAGE_SAMPLE_CD_V5_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x5 }, // 2462
  { IMAGE_SAMPLE_CD_V5_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x6 }, // 2463
  { IMAGE_SAMPLE_CD_V5_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x7 }, // 2464
  { IMAGE_SAMPLE_CD_V5_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x8 }, // 2465
  { IMAGE_SAMPLE_CD_V5_V16_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x10 }, // 2466
  { IMAGE_SAMPLE_CD_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x2 }, // 2467
  { IMAGE_SAMPLE_CD_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x3 }, // 2468
  { IMAGE_SAMPLE_CD_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x4 }, // 2469
  { IMAGE_SAMPLE_CD_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x5 }, // 2470
  { IMAGE_SAMPLE_CD_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x6 }, // 2471
  { IMAGE_SAMPLE_CD_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x7 }, // 2472
  { IMAGE_SAMPLE_CD_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x8 }, // 2473
  { IMAGE_SAMPLE_CD_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x9 }, // 2474
  { IMAGE_SAMPLE_CD_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x2 }, // 2475
  { IMAGE_SAMPLE_CD_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x3 }, // 2476
  { IMAGE_SAMPLE_CD_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x4 }, // 2477
  { IMAGE_SAMPLE_CD_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x5 }, // 2478
  { IMAGE_SAMPLE_CD_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x6 }, // 2479
  { IMAGE_SAMPLE_CD_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x7 }, // 2480
  { IMAGE_SAMPLE_CD_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x8 }, // 2481
  { IMAGE_SAMPLE_CD_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x9 }, // 2482
  { IMAGE_SAMPLE_CD_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x2 }, // 2483
  { IMAGE_SAMPLE_CD_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x3 }, // 2484
  { IMAGE_SAMPLE_CD_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x4 }, // 2485
  { IMAGE_SAMPLE_CD_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x5 }, // 2486
  { IMAGE_SAMPLE_CD_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x6 }, // 2487
  { IMAGE_SAMPLE_CD_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x7 }, // 2488
  { IMAGE_SAMPLE_CD_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x8 }, // 2489
  { IMAGE_SAMPLE_CD_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x9 }, // 2490
  { IMAGE_SAMPLE_CD_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x2 }, // 2491
  { IMAGE_SAMPLE_CD_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x3 }, // 2492
  { IMAGE_SAMPLE_CD_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x4 }, // 2493
  { IMAGE_SAMPLE_CD_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x5 }, // 2494
  { IMAGE_SAMPLE_CD_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x6 }, // 2495
  { IMAGE_SAMPLE_CD_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x7 }, // 2496
  { IMAGE_SAMPLE_CD_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x8 }, // 2497
  { IMAGE_SAMPLE_CD_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x9 }, // 2498
  { IMAGE_SAMPLE_CD_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x2 }, // 2499
  { IMAGE_SAMPLE_CD_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x3 }, // 2500
  { IMAGE_SAMPLE_CD_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x4 }, // 2501
  { IMAGE_SAMPLE_CD_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x5 }, // 2502
  { IMAGE_SAMPLE_CD_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x6 }, // 2503
  { IMAGE_SAMPLE_CD_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x7 }, // 2504
  { IMAGE_SAMPLE_CD_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x8 }, // 2505
  { IMAGE_SAMPLE_CD_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x9 }, // 2506
  { IMAGE_SAMPLE_CD_V1_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x2 }, // 2507
  { IMAGE_SAMPLE_CD_V1_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x3 }, // 2508
  { IMAGE_SAMPLE_CD_V1_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x4 }, // 2509
  { IMAGE_SAMPLE_CD_V1_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x5 }, // 2510
  { IMAGE_SAMPLE_CD_V1_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x6 }, // 2511
  { IMAGE_SAMPLE_CD_V1_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x7 }, // 2512
  { IMAGE_SAMPLE_CD_V1_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x8 }, // 2513
  { IMAGE_SAMPLE_CD_V1_V16, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x10 }, // 2514
  { IMAGE_SAMPLE_CD_V2_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x2 }, // 2515
  { IMAGE_SAMPLE_CD_V2_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x3 }, // 2516
  { IMAGE_SAMPLE_CD_V2_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x4 }, // 2517
  { IMAGE_SAMPLE_CD_V2_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x5 }, // 2518
  { IMAGE_SAMPLE_CD_V2_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x6 }, // 2519
  { IMAGE_SAMPLE_CD_V2_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x7 }, // 2520
  { IMAGE_SAMPLE_CD_V2_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x8 }, // 2521
  { IMAGE_SAMPLE_CD_V2_V16, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x10 }, // 2522
  { IMAGE_SAMPLE_CD_V3_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x2 }, // 2523
  { IMAGE_SAMPLE_CD_V3_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x3 }, // 2524
  { IMAGE_SAMPLE_CD_V3_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x4 }, // 2525
  { IMAGE_SAMPLE_CD_V3_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x5 }, // 2526
  { IMAGE_SAMPLE_CD_V3_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x6 }, // 2527
  { IMAGE_SAMPLE_CD_V3_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x7 }, // 2528
  { IMAGE_SAMPLE_CD_V3_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x8 }, // 2529
  { IMAGE_SAMPLE_CD_V3_V16, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x10 }, // 2530
  { IMAGE_SAMPLE_CD_V4_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x2 }, // 2531
  { IMAGE_SAMPLE_CD_V4_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x3 }, // 2532
  { IMAGE_SAMPLE_CD_V4_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x4 }, // 2533
  { IMAGE_SAMPLE_CD_V4_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x5 }, // 2534
  { IMAGE_SAMPLE_CD_V4_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x6 }, // 2535
  { IMAGE_SAMPLE_CD_V4_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x7 }, // 2536
  { IMAGE_SAMPLE_CD_V4_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x8 }, // 2537
  { IMAGE_SAMPLE_CD_V4_V16, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x10 }, // 2538
  { IMAGE_SAMPLE_CD_V5_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x2 }, // 2539
  { IMAGE_SAMPLE_CD_V5_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x3 }, // 2540
  { IMAGE_SAMPLE_CD_V5_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x4 }, // 2541
  { IMAGE_SAMPLE_CD_V5_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x5 }, // 2542
  { IMAGE_SAMPLE_CD_V5_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x6 }, // 2543
  { IMAGE_SAMPLE_CD_V5_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x7 }, // 2544
  { IMAGE_SAMPLE_CD_V5_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x8 }, // 2545
  { IMAGE_SAMPLE_CD_V5_V16, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x10 }, // 2546
  { IMAGE_SAMPLE_CD_CL_V1_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x2 }, // 2547
  { IMAGE_SAMPLE_CD_CL_V1_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x3 }, // 2548
  { IMAGE_SAMPLE_CD_CL_V1_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x4 }, // 2549
  { IMAGE_SAMPLE_CD_CL_V1_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x5 }, // 2550
  { IMAGE_SAMPLE_CD_CL_V1_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x6 }, // 2551
  { IMAGE_SAMPLE_CD_CL_V1_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x7 }, // 2552
  { IMAGE_SAMPLE_CD_CL_V1_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x8 }, // 2553
  { IMAGE_SAMPLE_CD_CL_V1_V16_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x10 }, // 2554
  { IMAGE_SAMPLE_CD_CL_V2_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x2 }, // 2555
  { IMAGE_SAMPLE_CD_CL_V2_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x3 }, // 2556
  { IMAGE_SAMPLE_CD_CL_V2_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x4 }, // 2557
  { IMAGE_SAMPLE_CD_CL_V2_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x5 }, // 2558
  { IMAGE_SAMPLE_CD_CL_V2_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x6 }, // 2559
  { IMAGE_SAMPLE_CD_CL_V2_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x7 }, // 2560
  { IMAGE_SAMPLE_CD_CL_V2_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x8 }, // 2561
  { IMAGE_SAMPLE_CD_CL_V2_V16_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x10 }, // 2562
  { IMAGE_SAMPLE_CD_CL_V3_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x2 }, // 2563
  { IMAGE_SAMPLE_CD_CL_V3_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x3 }, // 2564
  { IMAGE_SAMPLE_CD_CL_V3_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x4 }, // 2565
  { IMAGE_SAMPLE_CD_CL_V3_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x5 }, // 2566
  { IMAGE_SAMPLE_CD_CL_V3_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x6 }, // 2567
  { IMAGE_SAMPLE_CD_CL_V3_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x7 }, // 2568
  { IMAGE_SAMPLE_CD_CL_V3_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x8 }, // 2569
  { IMAGE_SAMPLE_CD_CL_V3_V16_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x10 }, // 2570
  { IMAGE_SAMPLE_CD_CL_V4_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x2 }, // 2571
  { IMAGE_SAMPLE_CD_CL_V4_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x3 }, // 2572
  { IMAGE_SAMPLE_CD_CL_V4_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x4 }, // 2573
  { IMAGE_SAMPLE_CD_CL_V4_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x5 }, // 2574
  { IMAGE_SAMPLE_CD_CL_V4_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x6 }, // 2575
  { IMAGE_SAMPLE_CD_CL_V4_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x7 }, // 2576
  { IMAGE_SAMPLE_CD_CL_V4_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x8 }, // 2577
  { IMAGE_SAMPLE_CD_CL_V4_V16_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x10 }, // 2578
  { IMAGE_SAMPLE_CD_CL_V5_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x2 }, // 2579
  { IMAGE_SAMPLE_CD_CL_V5_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x3 }, // 2580
  { IMAGE_SAMPLE_CD_CL_V5_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x4 }, // 2581
  { IMAGE_SAMPLE_CD_CL_V5_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x5 }, // 2582
  { IMAGE_SAMPLE_CD_CL_V5_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x6 }, // 2583
  { IMAGE_SAMPLE_CD_CL_V5_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x7 }, // 2584
  { IMAGE_SAMPLE_CD_CL_V5_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x8 }, // 2585
  { IMAGE_SAMPLE_CD_CL_V5_V16_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x10 }, // 2586
  { IMAGE_SAMPLE_CD_CL_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x2 }, // 2587
  { IMAGE_SAMPLE_CD_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x3 }, // 2588
  { IMAGE_SAMPLE_CD_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x4 }, // 2589
  { IMAGE_SAMPLE_CD_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x5 }, // 2590
  { IMAGE_SAMPLE_CD_CL_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x6 }, // 2591
  { IMAGE_SAMPLE_CD_CL_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x7 }, // 2592
  { IMAGE_SAMPLE_CD_CL_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x8 }, // 2593
  { IMAGE_SAMPLE_CD_CL_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x9 }, // 2594
  { IMAGE_SAMPLE_CD_CL_V1_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0xA }, // 2595
  { IMAGE_SAMPLE_CD_CL_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x2 }, // 2596
  { IMAGE_SAMPLE_CD_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x3 }, // 2597
  { IMAGE_SAMPLE_CD_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x4 }, // 2598
  { IMAGE_SAMPLE_CD_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x5 }, // 2599
  { IMAGE_SAMPLE_CD_CL_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x6 }, // 2600
  { IMAGE_SAMPLE_CD_CL_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x7 }, // 2601
  { IMAGE_SAMPLE_CD_CL_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x8 }, // 2602
  { IMAGE_SAMPLE_CD_CL_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x9 }, // 2603
  { IMAGE_SAMPLE_CD_CL_V2_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0xA }, // 2604
  { IMAGE_SAMPLE_CD_CL_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x2 }, // 2605
  { IMAGE_SAMPLE_CD_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x3 }, // 2606
  { IMAGE_SAMPLE_CD_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x4 }, // 2607
  { IMAGE_SAMPLE_CD_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x5 }, // 2608
  { IMAGE_SAMPLE_CD_CL_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x6 }, // 2609
  { IMAGE_SAMPLE_CD_CL_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x7 }, // 2610
  { IMAGE_SAMPLE_CD_CL_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x8 }, // 2611
  { IMAGE_SAMPLE_CD_CL_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x9 }, // 2612
  { IMAGE_SAMPLE_CD_CL_V3_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0xA }, // 2613
  { IMAGE_SAMPLE_CD_CL_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x2 }, // 2614
  { IMAGE_SAMPLE_CD_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x3 }, // 2615
  { IMAGE_SAMPLE_CD_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x4 }, // 2616
  { IMAGE_SAMPLE_CD_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x5 }, // 2617
  { IMAGE_SAMPLE_CD_CL_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x6 }, // 2618
  { IMAGE_SAMPLE_CD_CL_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x7 }, // 2619
  { IMAGE_SAMPLE_CD_CL_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x8 }, // 2620
  { IMAGE_SAMPLE_CD_CL_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x9 }, // 2621
  { IMAGE_SAMPLE_CD_CL_V4_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0xA }, // 2622
  { IMAGE_SAMPLE_CD_CL_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x2 }, // 2623
  { IMAGE_SAMPLE_CD_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x3 }, // 2624
  { IMAGE_SAMPLE_CD_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x4 }, // 2625
  { IMAGE_SAMPLE_CD_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x5 }, // 2626
  { IMAGE_SAMPLE_CD_CL_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x6 }, // 2627
  { IMAGE_SAMPLE_CD_CL_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x7 }, // 2628
  { IMAGE_SAMPLE_CD_CL_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x8 }, // 2629
  { IMAGE_SAMPLE_CD_CL_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x9 }, // 2630
  { IMAGE_SAMPLE_CD_CL_V5_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0xA }, // 2631
  { IMAGE_SAMPLE_CD_CL_V1_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x2 }, // 2632
  { IMAGE_SAMPLE_CD_CL_V1_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x3 }, // 2633
  { IMAGE_SAMPLE_CD_CL_V1_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x4 }, // 2634
  { IMAGE_SAMPLE_CD_CL_V1_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x5 }, // 2635
  { IMAGE_SAMPLE_CD_CL_V1_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x6 }, // 2636
  { IMAGE_SAMPLE_CD_CL_V1_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x7 }, // 2637
  { IMAGE_SAMPLE_CD_CL_V1_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x8 }, // 2638
  { IMAGE_SAMPLE_CD_CL_V1_V16, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x10 }, // 2639
  { IMAGE_SAMPLE_CD_CL_V2_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x2 }, // 2640
  { IMAGE_SAMPLE_CD_CL_V2_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x3 }, // 2641
  { IMAGE_SAMPLE_CD_CL_V2_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x4 }, // 2642
  { IMAGE_SAMPLE_CD_CL_V2_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x5 }, // 2643
  { IMAGE_SAMPLE_CD_CL_V2_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x6 }, // 2644
  { IMAGE_SAMPLE_CD_CL_V2_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x7 }, // 2645
  { IMAGE_SAMPLE_CD_CL_V2_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x8 }, // 2646
  { IMAGE_SAMPLE_CD_CL_V2_V16, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x10 }, // 2647
  { IMAGE_SAMPLE_CD_CL_V3_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x2 }, // 2648
  { IMAGE_SAMPLE_CD_CL_V3_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x3 }, // 2649
  { IMAGE_SAMPLE_CD_CL_V3_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x4 }, // 2650
  { IMAGE_SAMPLE_CD_CL_V3_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x5 }, // 2651
  { IMAGE_SAMPLE_CD_CL_V3_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x6 }, // 2652
  { IMAGE_SAMPLE_CD_CL_V3_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x7 }, // 2653
  { IMAGE_SAMPLE_CD_CL_V3_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x8 }, // 2654
  { IMAGE_SAMPLE_CD_CL_V3_V16, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x10 }, // 2655
  { IMAGE_SAMPLE_CD_CL_V4_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x2 }, // 2656
  { IMAGE_SAMPLE_CD_CL_V4_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x3 }, // 2657
  { IMAGE_SAMPLE_CD_CL_V4_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x4 }, // 2658
  { IMAGE_SAMPLE_CD_CL_V4_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x5 }, // 2659
  { IMAGE_SAMPLE_CD_CL_V4_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x6 }, // 2660
  { IMAGE_SAMPLE_CD_CL_V4_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x7 }, // 2661
  { IMAGE_SAMPLE_CD_CL_V4_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x8 }, // 2662
  { IMAGE_SAMPLE_CD_CL_V4_V16, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x10 }, // 2663
  { IMAGE_SAMPLE_CD_CL_V5_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x2 }, // 2664
  { IMAGE_SAMPLE_CD_CL_V5_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x3 }, // 2665
  { IMAGE_SAMPLE_CD_CL_V5_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x4 }, // 2666
  { IMAGE_SAMPLE_CD_CL_V5_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x5 }, // 2667
  { IMAGE_SAMPLE_CD_CL_V5_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x6 }, // 2668
  { IMAGE_SAMPLE_CD_CL_V5_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x7 }, // 2669
  { IMAGE_SAMPLE_CD_CL_V5_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x8 }, // 2670
  { IMAGE_SAMPLE_CD_CL_V5_V16, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x10 }, // 2671
  { IMAGE_SAMPLE_CD_CL_G16_V1_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x2 }, // 2672
  { IMAGE_SAMPLE_CD_CL_G16_V1_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x3 }, // 2673
  { IMAGE_SAMPLE_CD_CL_G16_V1_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x4 }, // 2674
  { IMAGE_SAMPLE_CD_CL_G16_V1_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x5 }, // 2675
  { IMAGE_SAMPLE_CD_CL_G16_V1_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x6 }, // 2676
  { IMAGE_SAMPLE_CD_CL_G16_V1_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x7 }, // 2677
  { IMAGE_SAMPLE_CD_CL_G16_V1_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x8 }, // 2678
  { IMAGE_SAMPLE_CD_CL_G16_V1_V16_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x10 }, // 2679
  { IMAGE_SAMPLE_CD_CL_G16_V2_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x2 }, // 2680
  { IMAGE_SAMPLE_CD_CL_G16_V2_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x3 }, // 2681
  { IMAGE_SAMPLE_CD_CL_G16_V2_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x4 }, // 2682
  { IMAGE_SAMPLE_CD_CL_G16_V2_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x5 }, // 2683
  { IMAGE_SAMPLE_CD_CL_G16_V2_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x6 }, // 2684
  { IMAGE_SAMPLE_CD_CL_G16_V2_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x7 }, // 2685
  { IMAGE_SAMPLE_CD_CL_G16_V2_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x8 }, // 2686
  { IMAGE_SAMPLE_CD_CL_G16_V2_V16_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x10 }, // 2687
  { IMAGE_SAMPLE_CD_CL_G16_V3_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x2 }, // 2688
  { IMAGE_SAMPLE_CD_CL_G16_V3_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x3 }, // 2689
  { IMAGE_SAMPLE_CD_CL_G16_V3_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x4 }, // 2690
  { IMAGE_SAMPLE_CD_CL_G16_V3_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x5 }, // 2691
  { IMAGE_SAMPLE_CD_CL_G16_V3_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x6 }, // 2692
  { IMAGE_SAMPLE_CD_CL_G16_V3_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x7 }, // 2693
  { IMAGE_SAMPLE_CD_CL_G16_V3_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x8 }, // 2694
  { IMAGE_SAMPLE_CD_CL_G16_V3_V16_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x10 }, // 2695
  { IMAGE_SAMPLE_CD_CL_G16_V4_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x2 }, // 2696
  { IMAGE_SAMPLE_CD_CL_G16_V4_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x3 }, // 2697
  { IMAGE_SAMPLE_CD_CL_G16_V4_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x4 }, // 2698
  { IMAGE_SAMPLE_CD_CL_G16_V4_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x5 }, // 2699
  { IMAGE_SAMPLE_CD_CL_G16_V4_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x6 }, // 2700
  { IMAGE_SAMPLE_CD_CL_G16_V4_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x7 }, // 2701
  { IMAGE_SAMPLE_CD_CL_G16_V4_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x8 }, // 2702
  { IMAGE_SAMPLE_CD_CL_G16_V4_V16_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x10 }, // 2703
  { IMAGE_SAMPLE_CD_CL_G16_V5_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x2 }, // 2704
  { IMAGE_SAMPLE_CD_CL_G16_V5_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x3 }, // 2705
  { IMAGE_SAMPLE_CD_CL_G16_V5_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x4 }, // 2706
  { IMAGE_SAMPLE_CD_CL_G16_V5_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x5 }, // 2707
  { IMAGE_SAMPLE_CD_CL_G16_V5_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x6 }, // 2708
  { IMAGE_SAMPLE_CD_CL_G16_V5_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x7 }, // 2709
  { IMAGE_SAMPLE_CD_CL_G16_V5_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x8 }, // 2710
  { IMAGE_SAMPLE_CD_CL_G16_V5_V16_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x10 }, // 2711
  { IMAGE_SAMPLE_CD_CL_G16_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x2 }, // 2712
  { IMAGE_SAMPLE_CD_CL_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x3 }, // 2713
  { IMAGE_SAMPLE_CD_CL_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x4 }, // 2714
  { IMAGE_SAMPLE_CD_CL_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x5 }, // 2715
  { IMAGE_SAMPLE_CD_CL_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x6 }, // 2716
  { IMAGE_SAMPLE_CD_CL_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x7 }, // 2717
  { IMAGE_SAMPLE_CD_CL_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x8 }, // 2718
  { IMAGE_SAMPLE_CD_CL_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x9 }, // 2719
  { IMAGE_SAMPLE_CD_CL_G16_V1_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0xA }, // 2720
  { IMAGE_SAMPLE_CD_CL_G16_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x2 }, // 2721
  { IMAGE_SAMPLE_CD_CL_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x3 }, // 2722
  { IMAGE_SAMPLE_CD_CL_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x4 }, // 2723
  { IMAGE_SAMPLE_CD_CL_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x5 }, // 2724
  { IMAGE_SAMPLE_CD_CL_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x6 }, // 2725
  { IMAGE_SAMPLE_CD_CL_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x7 }, // 2726
  { IMAGE_SAMPLE_CD_CL_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x8 }, // 2727
  { IMAGE_SAMPLE_CD_CL_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x9 }, // 2728
  { IMAGE_SAMPLE_CD_CL_G16_V2_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0xA }, // 2729
  { IMAGE_SAMPLE_CD_CL_G16_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x2 }, // 2730
  { IMAGE_SAMPLE_CD_CL_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x3 }, // 2731
  { IMAGE_SAMPLE_CD_CL_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x4 }, // 2732
  { IMAGE_SAMPLE_CD_CL_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x5 }, // 2733
  { IMAGE_SAMPLE_CD_CL_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x6 }, // 2734
  { IMAGE_SAMPLE_CD_CL_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x7 }, // 2735
  { IMAGE_SAMPLE_CD_CL_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x8 }, // 2736
  { IMAGE_SAMPLE_CD_CL_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x9 }, // 2737
  { IMAGE_SAMPLE_CD_CL_G16_V3_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0xA }, // 2738
  { IMAGE_SAMPLE_CD_CL_G16_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x2 }, // 2739
  { IMAGE_SAMPLE_CD_CL_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x3 }, // 2740
  { IMAGE_SAMPLE_CD_CL_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x4 }, // 2741
  { IMAGE_SAMPLE_CD_CL_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x5 }, // 2742
  { IMAGE_SAMPLE_CD_CL_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x6 }, // 2743
  { IMAGE_SAMPLE_CD_CL_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x7 }, // 2744
  { IMAGE_SAMPLE_CD_CL_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x8 }, // 2745
  { IMAGE_SAMPLE_CD_CL_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x9 }, // 2746
  { IMAGE_SAMPLE_CD_CL_G16_V4_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0xA }, // 2747
  { IMAGE_SAMPLE_CD_CL_G16_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x2 }, // 2748
  { IMAGE_SAMPLE_CD_CL_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x3 }, // 2749
  { IMAGE_SAMPLE_CD_CL_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x4 }, // 2750
  { IMAGE_SAMPLE_CD_CL_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x5 }, // 2751
  { IMAGE_SAMPLE_CD_CL_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x6 }, // 2752
  { IMAGE_SAMPLE_CD_CL_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x7 }, // 2753
  { IMAGE_SAMPLE_CD_CL_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x8 }, // 2754
  { IMAGE_SAMPLE_CD_CL_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x9 }, // 2755
  { IMAGE_SAMPLE_CD_CL_G16_V5_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0xA }, // 2756
  { IMAGE_SAMPLE_CD_CL_G16_V1_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x2 }, // 2757
  { IMAGE_SAMPLE_CD_CL_G16_V1_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x3 }, // 2758
  { IMAGE_SAMPLE_CD_CL_G16_V1_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x4 }, // 2759
  { IMAGE_SAMPLE_CD_CL_G16_V1_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x5 }, // 2760
  { IMAGE_SAMPLE_CD_CL_G16_V1_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x6 }, // 2761
  { IMAGE_SAMPLE_CD_CL_G16_V1_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x7 }, // 2762
  { IMAGE_SAMPLE_CD_CL_G16_V1_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x8 }, // 2763
  { IMAGE_SAMPLE_CD_CL_G16_V1_V16, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x10 }, // 2764
  { IMAGE_SAMPLE_CD_CL_G16_V2_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x2 }, // 2765
  { IMAGE_SAMPLE_CD_CL_G16_V2_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x3 }, // 2766
  { IMAGE_SAMPLE_CD_CL_G16_V2_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x4 }, // 2767
  { IMAGE_SAMPLE_CD_CL_G16_V2_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x5 }, // 2768
  { IMAGE_SAMPLE_CD_CL_G16_V2_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x6 }, // 2769
  { IMAGE_SAMPLE_CD_CL_G16_V2_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x7 }, // 2770
  { IMAGE_SAMPLE_CD_CL_G16_V2_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x8 }, // 2771
  { IMAGE_SAMPLE_CD_CL_G16_V2_V16, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x10 }, // 2772
  { IMAGE_SAMPLE_CD_CL_G16_V3_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x2 }, // 2773
  { IMAGE_SAMPLE_CD_CL_G16_V3_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x3 }, // 2774
  { IMAGE_SAMPLE_CD_CL_G16_V3_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x4 }, // 2775
  { IMAGE_SAMPLE_CD_CL_G16_V3_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x5 }, // 2776
  { IMAGE_SAMPLE_CD_CL_G16_V3_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x6 }, // 2777
  { IMAGE_SAMPLE_CD_CL_G16_V3_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x7 }, // 2778
  { IMAGE_SAMPLE_CD_CL_G16_V3_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x8 }, // 2779
  { IMAGE_SAMPLE_CD_CL_G16_V3_V16, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x10 }, // 2780
  { IMAGE_SAMPLE_CD_CL_G16_V4_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x2 }, // 2781
  { IMAGE_SAMPLE_CD_CL_G16_V4_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x3 }, // 2782
  { IMAGE_SAMPLE_CD_CL_G16_V4_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x4 }, // 2783
  { IMAGE_SAMPLE_CD_CL_G16_V4_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x5 }, // 2784
  { IMAGE_SAMPLE_CD_CL_G16_V4_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x6 }, // 2785
  { IMAGE_SAMPLE_CD_CL_G16_V4_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x7 }, // 2786
  { IMAGE_SAMPLE_CD_CL_G16_V4_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x8 }, // 2787
  { IMAGE_SAMPLE_CD_CL_G16_V4_V16, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x10 }, // 2788
  { IMAGE_SAMPLE_CD_CL_G16_V5_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x2 }, // 2789
  { IMAGE_SAMPLE_CD_CL_G16_V5_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x3 }, // 2790
  { IMAGE_SAMPLE_CD_CL_G16_V5_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x4 }, // 2791
  { IMAGE_SAMPLE_CD_CL_G16_V5_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x5 }, // 2792
  { IMAGE_SAMPLE_CD_CL_G16_V5_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x6 }, // 2793
  { IMAGE_SAMPLE_CD_CL_G16_V5_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x7 }, // 2794
  { IMAGE_SAMPLE_CD_CL_G16_V5_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x8 }, // 2795
  { IMAGE_SAMPLE_CD_CL_G16_V5_V16, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x10 }, // 2796
  { IMAGE_SAMPLE_CD_CL_O_V1_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x3 }, // 2797
  { IMAGE_SAMPLE_CD_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x4 }, // 2798
  { IMAGE_SAMPLE_CD_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x5 }, // 2799
  { IMAGE_SAMPLE_CD_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x6 }, // 2800
  { IMAGE_SAMPLE_CD_CL_O_V1_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x7 }, // 2801
  { IMAGE_SAMPLE_CD_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x8 }, // 2802
  { IMAGE_SAMPLE_CD_CL_O_V1_V16_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x10 }, // 2803
  { IMAGE_SAMPLE_CD_CL_O_V2_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 2804
  { IMAGE_SAMPLE_CD_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 2805
  { IMAGE_SAMPLE_CD_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 2806
  { IMAGE_SAMPLE_CD_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x6 }, // 2807
  { IMAGE_SAMPLE_CD_CL_O_V2_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x7 }, // 2808
  { IMAGE_SAMPLE_CD_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 2809
  { IMAGE_SAMPLE_CD_CL_O_V2_V16_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x10 }, // 2810
  { IMAGE_SAMPLE_CD_CL_O_V3_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x3 }, // 2811
  { IMAGE_SAMPLE_CD_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x4 }, // 2812
  { IMAGE_SAMPLE_CD_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x5 }, // 2813
  { IMAGE_SAMPLE_CD_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x6 }, // 2814
  { IMAGE_SAMPLE_CD_CL_O_V3_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x7 }, // 2815
  { IMAGE_SAMPLE_CD_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x8 }, // 2816
  { IMAGE_SAMPLE_CD_CL_O_V3_V16_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x10 }, // 2817
  { IMAGE_SAMPLE_CD_CL_O_V4_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 2818
  { IMAGE_SAMPLE_CD_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 2819
  { IMAGE_SAMPLE_CD_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 2820
  { IMAGE_SAMPLE_CD_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x6 }, // 2821
  { IMAGE_SAMPLE_CD_CL_O_V4_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x7 }, // 2822
  { IMAGE_SAMPLE_CD_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 2823
  { IMAGE_SAMPLE_CD_CL_O_V4_V16_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x10 }, // 2824
  { IMAGE_SAMPLE_CD_CL_O_V5_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 2825
  { IMAGE_SAMPLE_CD_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 2826
  { IMAGE_SAMPLE_CD_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 2827
  { IMAGE_SAMPLE_CD_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x6 }, // 2828
  { IMAGE_SAMPLE_CD_CL_O_V5_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x7 }, // 2829
  { IMAGE_SAMPLE_CD_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 2830
  { IMAGE_SAMPLE_CD_CL_O_V5_V16_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x10 }, // 2831
  { IMAGE_SAMPLE_CD_CL_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x3 }, // 2832
  { IMAGE_SAMPLE_CD_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x4 }, // 2833
  { IMAGE_SAMPLE_CD_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x5 }, // 2834
  { IMAGE_SAMPLE_CD_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x6 }, // 2835
  { IMAGE_SAMPLE_CD_CL_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x7 }, // 2836
  { IMAGE_SAMPLE_CD_CL_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x8 }, // 2837
  { IMAGE_SAMPLE_CD_CL_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x9 }, // 2838
  { IMAGE_SAMPLE_CD_CL_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0xA }, // 2839
  { IMAGE_SAMPLE_CD_CL_O_V1_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0xB }, // 2840
  { IMAGE_SAMPLE_CD_CL_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 2841
  { IMAGE_SAMPLE_CD_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 2842
  { IMAGE_SAMPLE_CD_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 2843
  { IMAGE_SAMPLE_CD_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x6 }, // 2844
  { IMAGE_SAMPLE_CD_CL_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x7 }, // 2845
  { IMAGE_SAMPLE_CD_CL_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x8 }, // 2846
  { IMAGE_SAMPLE_CD_CL_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x9 }, // 2847
  { IMAGE_SAMPLE_CD_CL_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0xA }, // 2848
  { IMAGE_SAMPLE_CD_CL_O_V2_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0xB }, // 2849
  { IMAGE_SAMPLE_CD_CL_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x3 }, // 2850
  { IMAGE_SAMPLE_CD_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x4 }, // 2851
  { IMAGE_SAMPLE_CD_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x5 }, // 2852
  { IMAGE_SAMPLE_CD_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x6 }, // 2853
  { IMAGE_SAMPLE_CD_CL_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x7 }, // 2854
  { IMAGE_SAMPLE_CD_CL_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x8 }, // 2855
  { IMAGE_SAMPLE_CD_CL_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x9 }, // 2856
  { IMAGE_SAMPLE_CD_CL_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0xA }, // 2857
  { IMAGE_SAMPLE_CD_CL_O_V3_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0xB }, // 2858
  { IMAGE_SAMPLE_CD_CL_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 2859
  { IMAGE_SAMPLE_CD_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 2860
  { IMAGE_SAMPLE_CD_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 2861
  { IMAGE_SAMPLE_CD_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x6 }, // 2862
  { IMAGE_SAMPLE_CD_CL_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x7 }, // 2863
  { IMAGE_SAMPLE_CD_CL_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x8 }, // 2864
  { IMAGE_SAMPLE_CD_CL_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x9 }, // 2865
  { IMAGE_SAMPLE_CD_CL_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0xA }, // 2866
  { IMAGE_SAMPLE_CD_CL_O_V4_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0xB }, // 2867
  { IMAGE_SAMPLE_CD_CL_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 2868
  { IMAGE_SAMPLE_CD_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 2869
  { IMAGE_SAMPLE_CD_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 2870
  { IMAGE_SAMPLE_CD_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x6 }, // 2871
  { IMAGE_SAMPLE_CD_CL_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x7 }, // 2872
  { IMAGE_SAMPLE_CD_CL_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x8 }, // 2873
  { IMAGE_SAMPLE_CD_CL_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x9 }, // 2874
  { IMAGE_SAMPLE_CD_CL_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0xA }, // 2875
  { IMAGE_SAMPLE_CD_CL_O_V5_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0xB }, // 2876
  { IMAGE_SAMPLE_CD_CL_O_V1_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x3 }, // 2877
  { IMAGE_SAMPLE_CD_CL_O_V1_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x4 }, // 2878
  { IMAGE_SAMPLE_CD_CL_O_V1_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x5 }, // 2879
  { IMAGE_SAMPLE_CD_CL_O_V1_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x6 }, // 2880
  { IMAGE_SAMPLE_CD_CL_O_V1_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x7 }, // 2881
  { IMAGE_SAMPLE_CD_CL_O_V1_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x8 }, // 2882
  { IMAGE_SAMPLE_CD_CL_O_V1_V16, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x10 }, // 2883
  { IMAGE_SAMPLE_CD_CL_O_V2_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x3 }, // 2884
  { IMAGE_SAMPLE_CD_CL_O_V2_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 2885
  { IMAGE_SAMPLE_CD_CL_O_V2_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x5 }, // 2886
  { IMAGE_SAMPLE_CD_CL_O_V2_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x6 }, // 2887
  { IMAGE_SAMPLE_CD_CL_O_V2_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x7 }, // 2888
  { IMAGE_SAMPLE_CD_CL_O_V2_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 2889
  { IMAGE_SAMPLE_CD_CL_O_V2_V16, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x10 }, // 2890
  { IMAGE_SAMPLE_CD_CL_O_V3_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x3 }, // 2891
  { IMAGE_SAMPLE_CD_CL_O_V3_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x4 }, // 2892
  { IMAGE_SAMPLE_CD_CL_O_V3_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x5 }, // 2893
  { IMAGE_SAMPLE_CD_CL_O_V3_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x6 }, // 2894
  { IMAGE_SAMPLE_CD_CL_O_V3_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x7 }, // 2895
  { IMAGE_SAMPLE_CD_CL_O_V3_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x8 }, // 2896
  { IMAGE_SAMPLE_CD_CL_O_V3_V16, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x10 }, // 2897
  { IMAGE_SAMPLE_CD_CL_O_V4_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x3 }, // 2898
  { IMAGE_SAMPLE_CD_CL_O_V4_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 2899
  { IMAGE_SAMPLE_CD_CL_O_V4_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x5 }, // 2900
  { IMAGE_SAMPLE_CD_CL_O_V4_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x6 }, // 2901
  { IMAGE_SAMPLE_CD_CL_O_V4_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x7 }, // 2902
  { IMAGE_SAMPLE_CD_CL_O_V4_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 2903
  { IMAGE_SAMPLE_CD_CL_O_V4_V16, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x10 }, // 2904
  { IMAGE_SAMPLE_CD_CL_O_V5_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x3 }, // 2905
  { IMAGE_SAMPLE_CD_CL_O_V5_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x4 }, // 2906
  { IMAGE_SAMPLE_CD_CL_O_V5_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x5 }, // 2907
  { IMAGE_SAMPLE_CD_CL_O_V5_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x6 }, // 2908
  { IMAGE_SAMPLE_CD_CL_O_V5_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x7 }, // 2909
  { IMAGE_SAMPLE_CD_CL_O_V5_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x8 }, // 2910
  { IMAGE_SAMPLE_CD_CL_O_V5_V16, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x10 }, // 2911
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x3 }, // 2912
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x4 }, // 2913
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x5 }, // 2914
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x6 }, // 2915
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x7 }, // 2916
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x8 }, // 2917
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V16_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x10 }, // 2918
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x3 }, // 2919
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x4 }, // 2920
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x5 }, // 2921
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x6 }, // 2922
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x7 }, // 2923
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x8 }, // 2924
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V16_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x10 }, // 2925
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x3 }, // 2926
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x4 }, // 2927
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x5 }, // 2928
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x6 }, // 2929
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x7 }, // 2930
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x8 }, // 2931
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V16_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x10 }, // 2932
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x3 }, // 2933
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x4 }, // 2934
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x5 }, // 2935
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x6 }, // 2936
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x7 }, // 2937
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x8 }, // 2938
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V16_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x10 }, // 2939
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x3 }, // 2940
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x4 }, // 2941
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x5 }, // 2942
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x6 }, // 2943
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x7 }, // 2944
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x8 }, // 2945
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V16_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x10 }, // 2946
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x3 }, // 2947
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x4 }, // 2948
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x5 }, // 2949
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x6 }, // 2950
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x7 }, // 2951
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x8 }, // 2952
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x9 }, // 2953
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0xA }, // 2954
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0xB }, // 2955
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x3 }, // 2956
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x4 }, // 2957
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x5 }, // 2958
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x6 }, // 2959
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x7 }, // 2960
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x8 }, // 2961
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x9 }, // 2962
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0xA }, // 2963
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0xB }, // 2964
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x3 }, // 2965
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x4 }, // 2966
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x5 }, // 2967
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x6 }, // 2968
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x7 }, // 2969
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x8 }, // 2970
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x9 }, // 2971
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0xA }, // 2972
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0xB }, // 2973
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x3 }, // 2974
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x4 }, // 2975
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x5 }, // 2976
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x6 }, // 2977
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x7 }, // 2978
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x8 }, // 2979
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x9 }, // 2980
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0xA }, // 2981
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0xB }, // 2982
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x3 }, // 2983
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x4 }, // 2984
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x5 }, // 2985
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x6 }, // 2986
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x7 }, // 2987
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x8 }, // 2988
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x9 }, // 2989
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0xA }, // 2990
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0xB }, // 2991
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x3 }, // 2992
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x4 }, // 2993
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x5 }, // 2994
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x6 }, // 2995
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x7 }, // 2996
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x8 }, // 2997
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V16, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x10 }, // 2998
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x3 }, // 2999
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x4 }, // 3000
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x5 }, // 3001
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x6 }, // 3002
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x7 }, // 3003
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x8 }, // 3004
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V16, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x10 }, // 3005
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x3 }, // 3006
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x4 }, // 3007
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x5 }, // 3008
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x6 }, // 3009
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x7 }, // 3010
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x8 }, // 3011
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V16, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x10 }, // 3012
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x3 }, // 3013
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x4 }, // 3014
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x5 }, // 3015
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x6 }, // 3016
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x7 }, // 3017
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x8 }, // 3018
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V16, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x10 }, // 3019
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x3 }, // 3020
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x4 }, // 3021
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x5 }, // 3022
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x6 }, // 3023
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x7 }, // 3024
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x8 }, // 3025
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V16, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x10 }, // 3026
  { IMAGE_SAMPLE_CD_G16_V1_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x2 }, // 3027
  { IMAGE_SAMPLE_CD_G16_V1_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x3 }, // 3028
  { IMAGE_SAMPLE_CD_G16_V1_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x4 }, // 3029
  { IMAGE_SAMPLE_CD_G16_V1_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x5 }, // 3030
  { IMAGE_SAMPLE_CD_G16_V1_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x6 }, // 3031
  { IMAGE_SAMPLE_CD_G16_V1_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x7 }, // 3032
  { IMAGE_SAMPLE_CD_G16_V1_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x8 }, // 3033
  { IMAGE_SAMPLE_CD_G16_V1_V16_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x10 }, // 3034
  { IMAGE_SAMPLE_CD_G16_V2_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x2 }, // 3035
  { IMAGE_SAMPLE_CD_G16_V2_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x3 }, // 3036
  { IMAGE_SAMPLE_CD_G16_V2_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x4 }, // 3037
  { IMAGE_SAMPLE_CD_G16_V2_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x5 }, // 3038
  { IMAGE_SAMPLE_CD_G16_V2_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x6 }, // 3039
  { IMAGE_SAMPLE_CD_G16_V2_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x7 }, // 3040
  { IMAGE_SAMPLE_CD_G16_V2_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x8 }, // 3041
  { IMAGE_SAMPLE_CD_G16_V2_V16_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x10 }, // 3042
  { IMAGE_SAMPLE_CD_G16_V3_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x2 }, // 3043
  { IMAGE_SAMPLE_CD_G16_V3_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x3 }, // 3044
  { IMAGE_SAMPLE_CD_G16_V3_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x4 }, // 3045
  { IMAGE_SAMPLE_CD_G16_V3_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x5 }, // 3046
  { IMAGE_SAMPLE_CD_G16_V3_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x6 }, // 3047
  { IMAGE_SAMPLE_CD_G16_V3_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x7 }, // 3048
  { IMAGE_SAMPLE_CD_G16_V3_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x8 }, // 3049
  { IMAGE_SAMPLE_CD_G16_V3_V16_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x10 }, // 3050
  { IMAGE_SAMPLE_CD_G16_V4_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x2 }, // 3051
  { IMAGE_SAMPLE_CD_G16_V4_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x3 }, // 3052
  { IMAGE_SAMPLE_CD_G16_V4_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x4 }, // 3053
  { IMAGE_SAMPLE_CD_G16_V4_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x5 }, // 3054
  { IMAGE_SAMPLE_CD_G16_V4_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x6 }, // 3055
  { IMAGE_SAMPLE_CD_G16_V4_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x7 }, // 3056
  { IMAGE_SAMPLE_CD_G16_V4_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x8 }, // 3057
  { IMAGE_SAMPLE_CD_G16_V4_V16_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x10 }, // 3058
  { IMAGE_SAMPLE_CD_G16_V5_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x2 }, // 3059
  { IMAGE_SAMPLE_CD_G16_V5_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x3 }, // 3060
  { IMAGE_SAMPLE_CD_G16_V5_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x4 }, // 3061
  { IMAGE_SAMPLE_CD_G16_V5_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x5 }, // 3062
  { IMAGE_SAMPLE_CD_G16_V5_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x6 }, // 3063
  { IMAGE_SAMPLE_CD_G16_V5_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x7 }, // 3064
  { IMAGE_SAMPLE_CD_G16_V5_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x8 }, // 3065
  { IMAGE_SAMPLE_CD_G16_V5_V16_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x10 }, // 3066
  { IMAGE_SAMPLE_CD_G16_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x2 }, // 3067
  { IMAGE_SAMPLE_CD_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x3 }, // 3068
  { IMAGE_SAMPLE_CD_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x4 }, // 3069
  { IMAGE_SAMPLE_CD_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x5 }, // 3070
  { IMAGE_SAMPLE_CD_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x6 }, // 3071
  { IMAGE_SAMPLE_CD_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x7 }, // 3072
  { IMAGE_SAMPLE_CD_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x8 }, // 3073
  { IMAGE_SAMPLE_CD_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x9 }, // 3074
  { IMAGE_SAMPLE_CD_G16_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x2 }, // 3075
  { IMAGE_SAMPLE_CD_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x3 }, // 3076
  { IMAGE_SAMPLE_CD_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x4 }, // 3077
  { IMAGE_SAMPLE_CD_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x5 }, // 3078
  { IMAGE_SAMPLE_CD_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x6 }, // 3079
  { IMAGE_SAMPLE_CD_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x7 }, // 3080
  { IMAGE_SAMPLE_CD_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x8 }, // 3081
  { IMAGE_SAMPLE_CD_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x9 }, // 3082
  { IMAGE_SAMPLE_CD_G16_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x2 }, // 3083
  { IMAGE_SAMPLE_CD_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x3 }, // 3084
  { IMAGE_SAMPLE_CD_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x4 }, // 3085
  { IMAGE_SAMPLE_CD_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x5 }, // 3086
  { IMAGE_SAMPLE_CD_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x6 }, // 3087
  { IMAGE_SAMPLE_CD_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x7 }, // 3088
  { IMAGE_SAMPLE_CD_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x8 }, // 3089
  { IMAGE_SAMPLE_CD_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x9 }, // 3090
  { IMAGE_SAMPLE_CD_G16_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x2 }, // 3091
  { IMAGE_SAMPLE_CD_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x3 }, // 3092
  { IMAGE_SAMPLE_CD_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x4 }, // 3093
  { IMAGE_SAMPLE_CD_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x5 }, // 3094
  { IMAGE_SAMPLE_CD_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x6 }, // 3095
  { IMAGE_SAMPLE_CD_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x7 }, // 3096
  { IMAGE_SAMPLE_CD_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x8 }, // 3097
  { IMAGE_SAMPLE_CD_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x9 }, // 3098
  { IMAGE_SAMPLE_CD_G16_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x2 }, // 3099
  { IMAGE_SAMPLE_CD_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x3 }, // 3100
  { IMAGE_SAMPLE_CD_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x4 }, // 3101
  { IMAGE_SAMPLE_CD_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x5 }, // 3102
  { IMAGE_SAMPLE_CD_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x6 }, // 3103
  { IMAGE_SAMPLE_CD_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x7 }, // 3104
  { IMAGE_SAMPLE_CD_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x8 }, // 3105
  { IMAGE_SAMPLE_CD_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x9 }, // 3106
  { IMAGE_SAMPLE_CD_G16_V1_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x2 }, // 3107
  { IMAGE_SAMPLE_CD_G16_V1_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x3 }, // 3108
  { IMAGE_SAMPLE_CD_G16_V1_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x4 }, // 3109
  { IMAGE_SAMPLE_CD_G16_V1_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x5 }, // 3110
  { IMAGE_SAMPLE_CD_G16_V1_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x6 }, // 3111
  { IMAGE_SAMPLE_CD_G16_V1_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x7 }, // 3112
  { IMAGE_SAMPLE_CD_G16_V1_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x8 }, // 3113
  { IMAGE_SAMPLE_CD_G16_V1_V16, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x10 }, // 3114
  { IMAGE_SAMPLE_CD_G16_V2_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x2 }, // 3115
  { IMAGE_SAMPLE_CD_G16_V2_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x3 }, // 3116
  { IMAGE_SAMPLE_CD_G16_V2_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x4 }, // 3117
  { IMAGE_SAMPLE_CD_G16_V2_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x5 }, // 3118
  { IMAGE_SAMPLE_CD_G16_V2_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x6 }, // 3119
  { IMAGE_SAMPLE_CD_G16_V2_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x7 }, // 3120
  { IMAGE_SAMPLE_CD_G16_V2_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x8 }, // 3121
  { IMAGE_SAMPLE_CD_G16_V2_V16, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x10 }, // 3122
  { IMAGE_SAMPLE_CD_G16_V3_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x2 }, // 3123
  { IMAGE_SAMPLE_CD_G16_V3_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x3 }, // 3124
  { IMAGE_SAMPLE_CD_G16_V3_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x4 }, // 3125
  { IMAGE_SAMPLE_CD_G16_V3_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x5 }, // 3126
  { IMAGE_SAMPLE_CD_G16_V3_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x6 }, // 3127
  { IMAGE_SAMPLE_CD_G16_V3_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x7 }, // 3128
  { IMAGE_SAMPLE_CD_G16_V3_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x8 }, // 3129
  { IMAGE_SAMPLE_CD_G16_V3_V16, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x10 }, // 3130
  { IMAGE_SAMPLE_CD_G16_V4_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x2 }, // 3131
  { IMAGE_SAMPLE_CD_G16_V4_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x3 }, // 3132
  { IMAGE_SAMPLE_CD_G16_V4_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x4 }, // 3133
  { IMAGE_SAMPLE_CD_G16_V4_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x5 }, // 3134
  { IMAGE_SAMPLE_CD_G16_V4_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x6 }, // 3135
  { IMAGE_SAMPLE_CD_G16_V4_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x7 }, // 3136
  { IMAGE_SAMPLE_CD_G16_V4_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x8 }, // 3137
  { IMAGE_SAMPLE_CD_G16_V4_V16, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x10 }, // 3138
  { IMAGE_SAMPLE_CD_G16_V5_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x2 }, // 3139
  { IMAGE_SAMPLE_CD_G16_V5_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x3 }, // 3140
  { IMAGE_SAMPLE_CD_G16_V5_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x4 }, // 3141
  { IMAGE_SAMPLE_CD_G16_V5_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x5 }, // 3142
  { IMAGE_SAMPLE_CD_G16_V5_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x6 }, // 3143
  { IMAGE_SAMPLE_CD_G16_V5_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x7 }, // 3144
  { IMAGE_SAMPLE_CD_G16_V5_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x8 }, // 3145
  { IMAGE_SAMPLE_CD_G16_V5_V16, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x10 }, // 3146
  { IMAGE_SAMPLE_CD_O_V1_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x3 }, // 3147
  { IMAGE_SAMPLE_CD_O_V1_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x4 }, // 3148
  { IMAGE_SAMPLE_CD_O_V1_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x5 }, // 3149
  { IMAGE_SAMPLE_CD_O_V1_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x6 }, // 3150
  { IMAGE_SAMPLE_CD_O_V1_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x7 }, // 3151
  { IMAGE_SAMPLE_CD_O_V1_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x8 }, // 3152
  { IMAGE_SAMPLE_CD_O_V1_V16_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x10 }, // 3153
  { IMAGE_SAMPLE_CD_O_V2_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 3154
  { IMAGE_SAMPLE_CD_O_V2_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 3155
  { IMAGE_SAMPLE_CD_O_V2_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 3156
  { IMAGE_SAMPLE_CD_O_V2_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x6 }, // 3157
  { IMAGE_SAMPLE_CD_O_V2_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x7 }, // 3158
  { IMAGE_SAMPLE_CD_O_V2_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 3159
  { IMAGE_SAMPLE_CD_O_V2_V16_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x10 }, // 3160
  { IMAGE_SAMPLE_CD_O_V3_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x3 }, // 3161
  { IMAGE_SAMPLE_CD_O_V3_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x4 }, // 3162
  { IMAGE_SAMPLE_CD_O_V3_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x5 }, // 3163
  { IMAGE_SAMPLE_CD_O_V3_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x6 }, // 3164
  { IMAGE_SAMPLE_CD_O_V3_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x7 }, // 3165
  { IMAGE_SAMPLE_CD_O_V3_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x8 }, // 3166
  { IMAGE_SAMPLE_CD_O_V3_V16_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x10 }, // 3167
  { IMAGE_SAMPLE_CD_O_V4_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 3168
  { IMAGE_SAMPLE_CD_O_V4_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 3169
  { IMAGE_SAMPLE_CD_O_V4_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 3170
  { IMAGE_SAMPLE_CD_O_V4_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x6 }, // 3171
  { IMAGE_SAMPLE_CD_O_V4_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x7 }, // 3172
  { IMAGE_SAMPLE_CD_O_V4_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 3173
  { IMAGE_SAMPLE_CD_O_V4_V16_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x10 }, // 3174
  { IMAGE_SAMPLE_CD_O_V5_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 3175
  { IMAGE_SAMPLE_CD_O_V5_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 3176
  { IMAGE_SAMPLE_CD_O_V5_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 3177
  { IMAGE_SAMPLE_CD_O_V5_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x6 }, // 3178
  { IMAGE_SAMPLE_CD_O_V5_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x7 }, // 3179
  { IMAGE_SAMPLE_CD_O_V5_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 3180
  { IMAGE_SAMPLE_CD_O_V5_V16_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x10 }, // 3181
  { IMAGE_SAMPLE_CD_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x3 }, // 3182
  { IMAGE_SAMPLE_CD_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x4 }, // 3183
  { IMAGE_SAMPLE_CD_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x5 }, // 3184
  { IMAGE_SAMPLE_CD_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x6 }, // 3185
  { IMAGE_SAMPLE_CD_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x7 }, // 3186
  { IMAGE_SAMPLE_CD_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x8 }, // 3187
  { IMAGE_SAMPLE_CD_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x9 }, // 3188
  { IMAGE_SAMPLE_CD_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0xA }, // 3189
  { IMAGE_SAMPLE_CD_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 3190
  { IMAGE_SAMPLE_CD_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 3191
  { IMAGE_SAMPLE_CD_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 3192
  { IMAGE_SAMPLE_CD_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x6 }, // 3193
  { IMAGE_SAMPLE_CD_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x7 }, // 3194
  { IMAGE_SAMPLE_CD_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x8 }, // 3195
  { IMAGE_SAMPLE_CD_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x9 }, // 3196
  { IMAGE_SAMPLE_CD_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0xA }, // 3197
  { IMAGE_SAMPLE_CD_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x3 }, // 3198
  { IMAGE_SAMPLE_CD_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x4 }, // 3199
  { IMAGE_SAMPLE_CD_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x5 }, // 3200
  { IMAGE_SAMPLE_CD_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x6 }, // 3201
  { IMAGE_SAMPLE_CD_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x7 }, // 3202
  { IMAGE_SAMPLE_CD_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x8 }, // 3203
  { IMAGE_SAMPLE_CD_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x9 }, // 3204
  { IMAGE_SAMPLE_CD_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0xA }, // 3205
  { IMAGE_SAMPLE_CD_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 3206
  { IMAGE_SAMPLE_CD_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 3207
  { IMAGE_SAMPLE_CD_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 3208
  { IMAGE_SAMPLE_CD_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x6 }, // 3209
  { IMAGE_SAMPLE_CD_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x7 }, // 3210
  { IMAGE_SAMPLE_CD_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x8 }, // 3211
  { IMAGE_SAMPLE_CD_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x9 }, // 3212
  { IMAGE_SAMPLE_CD_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0xA }, // 3213
  { IMAGE_SAMPLE_CD_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 3214
  { IMAGE_SAMPLE_CD_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 3215
  { IMAGE_SAMPLE_CD_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 3216
  { IMAGE_SAMPLE_CD_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x6 }, // 3217
  { IMAGE_SAMPLE_CD_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x7 }, // 3218
  { IMAGE_SAMPLE_CD_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x8 }, // 3219
  { IMAGE_SAMPLE_CD_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x9 }, // 3220
  { IMAGE_SAMPLE_CD_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0xA }, // 3221
  { IMAGE_SAMPLE_CD_O_V1_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x3 }, // 3222
  { IMAGE_SAMPLE_CD_O_V1_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x4 }, // 3223
  { IMAGE_SAMPLE_CD_O_V1_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x5 }, // 3224
  { IMAGE_SAMPLE_CD_O_V1_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x6 }, // 3225
  { IMAGE_SAMPLE_CD_O_V1_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x7 }, // 3226
  { IMAGE_SAMPLE_CD_O_V1_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x8 }, // 3227
  { IMAGE_SAMPLE_CD_O_V1_V16, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x10 }, // 3228
  { IMAGE_SAMPLE_CD_O_V2_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x3 }, // 3229
  { IMAGE_SAMPLE_CD_O_V2_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x4 }, // 3230
  { IMAGE_SAMPLE_CD_O_V2_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x5 }, // 3231
  { IMAGE_SAMPLE_CD_O_V2_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x6 }, // 3232
  { IMAGE_SAMPLE_CD_O_V2_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x7 }, // 3233
  { IMAGE_SAMPLE_CD_O_V2_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x8 }, // 3234
  { IMAGE_SAMPLE_CD_O_V2_V16, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x10 }, // 3235
  { IMAGE_SAMPLE_CD_O_V3_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x3 }, // 3236
  { IMAGE_SAMPLE_CD_O_V3_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x4 }, // 3237
  { IMAGE_SAMPLE_CD_O_V3_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x5 }, // 3238
  { IMAGE_SAMPLE_CD_O_V3_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x6 }, // 3239
  { IMAGE_SAMPLE_CD_O_V3_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x7 }, // 3240
  { IMAGE_SAMPLE_CD_O_V3_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x8 }, // 3241
  { IMAGE_SAMPLE_CD_O_V3_V16, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x10 }, // 3242
  { IMAGE_SAMPLE_CD_O_V4_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x3 }, // 3243
  { IMAGE_SAMPLE_CD_O_V4_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x4 }, // 3244
  { IMAGE_SAMPLE_CD_O_V4_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x5 }, // 3245
  { IMAGE_SAMPLE_CD_O_V4_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x6 }, // 3246
  { IMAGE_SAMPLE_CD_O_V4_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x7 }, // 3247
  { IMAGE_SAMPLE_CD_O_V4_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x8 }, // 3248
  { IMAGE_SAMPLE_CD_O_V4_V16, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x10 }, // 3249
  { IMAGE_SAMPLE_CD_O_V5_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x3 }, // 3250
  { IMAGE_SAMPLE_CD_O_V5_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x4 }, // 3251
  { IMAGE_SAMPLE_CD_O_V5_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x5 }, // 3252
  { IMAGE_SAMPLE_CD_O_V5_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x6 }, // 3253
  { IMAGE_SAMPLE_CD_O_V5_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x7 }, // 3254
  { IMAGE_SAMPLE_CD_O_V5_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x8 }, // 3255
  { IMAGE_SAMPLE_CD_O_V5_V16, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x10 }, // 3256
  { IMAGE_SAMPLE_CD_O_G16_V1_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x3 }, // 3257
  { IMAGE_SAMPLE_CD_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x4 }, // 3258
  { IMAGE_SAMPLE_CD_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x5 }, // 3259
  { IMAGE_SAMPLE_CD_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x6 }, // 3260
  { IMAGE_SAMPLE_CD_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x7 }, // 3261
  { IMAGE_SAMPLE_CD_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x8 }, // 3262
  { IMAGE_SAMPLE_CD_O_G16_V1_V16_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x10 }, // 3263
  { IMAGE_SAMPLE_CD_O_G16_V2_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x3 }, // 3264
  { IMAGE_SAMPLE_CD_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x4 }, // 3265
  { IMAGE_SAMPLE_CD_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x5 }, // 3266
  { IMAGE_SAMPLE_CD_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x6 }, // 3267
  { IMAGE_SAMPLE_CD_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x7 }, // 3268
  { IMAGE_SAMPLE_CD_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x8 }, // 3269
  { IMAGE_SAMPLE_CD_O_G16_V2_V16_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x10 }, // 3270
  { IMAGE_SAMPLE_CD_O_G16_V3_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x3 }, // 3271
  { IMAGE_SAMPLE_CD_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x4 }, // 3272
  { IMAGE_SAMPLE_CD_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x5 }, // 3273
  { IMAGE_SAMPLE_CD_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x6 }, // 3274
  { IMAGE_SAMPLE_CD_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x7 }, // 3275
  { IMAGE_SAMPLE_CD_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x8 }, // 3276
  { IMAGE_SAMPLE_CD_O_G16_V3_V16_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x10 }, // 3277
  { IMAGE_SAMPLE_CD_O_G16_V4_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x3 }, // 3278
  { IMAGE_SAMPLE_CD_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x4 }, // 3279
  { IMAGE_SAMPLE_CD_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x5 }, // 3280
  { IMAGE_SAMPLE_CD_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x6 }, // 3281
  { IMAGE_SAMPLE_CD_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x7 }, // 3282
  { IMAGE_SAMPLE_CD_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x8 }, // 3283
  { IMAGE_SAMPLE_CD_O_G16_V4_V16_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x10 }, // 3284
  { IMAGE_SAMPLE_CD_O_G16_V5_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x3 }, // 3285
  { IMAGE_SAMPLE_CD_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x4 }, // 3286
  { IMAGE_SAMPLE_CD_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x5 }, // 3287
  { IMAGE_SAMPLE_CD_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x6 }, // 3288
  { IMAGE_SAMPLE_CD_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x7 }, // 3289
  { IMAGE_SAMPLE_CD_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x8 }, // 3290
  { IMAGE_SAMPLE_CD_O_G16_V5_V16_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x10 }, // 3291
  { IMAGE_SAMPLE_CD_O_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x3 }, // 3292
  { IMAGE_SAMPLE_CD_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x4 }, // 3293
  { IMAGE_SAMPLE_CD_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x5 }, // 3294
  { IMAGE_SAMPLE_CD_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x6 }, // 3295
  { IMAGE_SAMPLE_CD_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x7 }, // 3296
  { IMAGE_SAMPLE_CD_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x8 }, // 3297
  { IMAGE_SAMPLE_CD_O_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x9 }, // 3298
  { IMAGE_SAMPLE_CD_O_G16_V1_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0xA }, // 3299
  { IMAGE_SAMPLE_CD_O_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x3 }, // 3300
  { IMAGE_SAMPLE_CD_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x4 }, // 3301
  { IMAGE_SAMPLE_CD_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x5 }, // 3302
  { IMAGE_SAMPLE_CD_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x6 }, // 3303
  { IMAGE_SAMPLE_CD_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x7 }, // 3304
  { IMAGE_SAMPLE_CD_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x8 }, // 3305
  { IMAGE_SAMPLE_CD_O_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x9 }, // 3306
  { IMAGE_SAMPLE_CD_O_G16_V2_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0xA }, // 3307
  { IMAGE_SAMPLE_CD_O_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x3 }, // 3308
  { IMAGE_SAMPLE_CD_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x4 }, // 3309
  { IMAGE_SAMPLE_CD_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x5 }, // 3310
  { IMAGE_SAMPLE_CD_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x6 }, // 3311
  { IMAGE_SAMPLE_CD_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x7 }, // 3312
  { IMAGE_SAMPLE_CD_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x8 }, // 3313
  { IMAGE_SAMPLE_CD_O_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x9 }, // 3314
  { IMAGE_SAMPLE_CD_O_G16_V3_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0xA }, // 3315
  { IMAGE_SAMPLE_CD_O_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x3 }, // 3316
  { IMAGE_SAMPLE_CD_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x4 }, // 3317
  { IMAGE_SAMPLE_CD_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x5 }, // 3318
  { IMAGE_SAMPLE_CD_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x6 }, // 3319
  { IMAGE_SAMPLE_CD_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x7 }, // 3320
  { IMAGE_SAMPLE_CD_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x8 }, // 3321
  { IMAGE_SAMPLE_CD_O_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x9 }, // 3322
  { IMAGE_SAMPLE_CD_O_G16_V4_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0xA }, // 3323
  { IMAGE_SAMPLE_CD_O_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x3 }, // 3324
  { IMAGE_SAMPLE_CD_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x4 }, // 3325
  { IMAGE_SAMPLE_CD_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x5 }, // 3326
  { IMAGE_SAMPLE_CD_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x6 }, // 3327
  { IMAGE_SAMPLE_CD_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x7 }, // 3328
  { IMAGE_SAMPLE_CD_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x8 }, // 3329
  { IMAGE_SAMPLE_CD_O_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x9 }, // 3330
  { IMAGE_SAMPLE_CD_O_G16_V5_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0xA }, // 3331
  { IMAGE_SAMPLE_CD_O_G16_V1_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x3 }, // 3332
  { IMAGE_SAMPLE_CD_O_G16_V1_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x4 }, // 3333
  { IMAGE_SAMPLE_CD_O_G16_V1_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x5 }, // 3334
  { IMAGE_SAMPLE_CD_O_G16_V1_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x6 }, // 3335
  { IMAGE_SAMPLE_CD_O_G16_V1_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x7 }, // 3336
  { IMAGE_SAMPLE_CD_O_G16_V1_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x8 }, // 3337
  { IMAGE_SAMPLE_CD_O_G16_V1_V16, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x10 }, // 3338
  { IMAGE_SAMPLE_CD_O_G16_V2_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x3 }, // 3339
  { IMAGE_SAMPLE_CD_O_G16_V2_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x4 }, // 3340
  { IMAGE_SAMPLE_CD_O_G16_V2_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x5 }, // 3341
  { IMAGE_SAMPLE_CD_O_G16_V2_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x6 }, // 3342
  { IMAGE_SAMPLE_CD_O_G16_V2_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x7 }, // 3343
  { IMAGE_SAMPLE_CD_O_G16_V2_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x8 }, // 3344
  { IMAGE_SAMPLE_CD_O_G16_V2_V16, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x10 }, // 3345
  { IMAGE_SAMPLE_CD_O_G16_V3_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x3 }, // 3346
  { IMAGE_SAMPLE_CD_O_G16_V3_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x4 }, // 3347
  { IMAGE_SAMPLE_CD_O_G16_V3_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x5 }, // 3348
  { IMAGE_SAMPLE_CD_O_G16_V3_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x6 }, // 3349
  { IMAGE_SAMPLE_CD_O_G16_V3_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x7 }, // 3350
  { IMAGE_SAMPLE_CD_O_G16_V3_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x8 }, // 3351
  { IMAGE_SAMPLE_CD_O_G16_V3_V16, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x10 }, // 3352
  { IMAGE_SAMPLE_CD_O_G16_V4_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x3 }, // 3353
  { IMAGE_SAMPLE_CD_O_G16_V4_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x4 }, // 3354
  { IMAGE_SAMPLE_CD_O_G16_V4_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x5 }, // 3355
  { IMAGE_SAMPLE_CD_O_G16_V4_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x6 }, // 3356
  { IMAGE_SAMPLE_CD_O_G16_V4_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x7 }, // 3357
  { IMAGE_SAMPLE_CD_O_G16_V4_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x8 }, // 3358
  { IMAGE_SAMPLE_CD_O_G16_V4_V16, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x10 }, // 3359
  { IMAGE_SAMPLE_CD_O_G16_V5_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x3 }, // 3360
  { IMAGE_SAMPLE_CD_O_G16_V5_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x4 }, // 3361
  { IMAGE_SAMPLE_CD_O_G16_V5_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x5 }, // 3362
  { IMAGE_SAMPLE_CD_O_G16_V5_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x6 }, // 3363
  { IMAGE_SAMPLE_CD_O_G16_V5_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x7 }, // 3364
  { IMAGE_SAMPLE_CD_O_G16_V5_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x8 }, // 3365
  { IMAGE_SAMPLE_CD_O_G16_V5_V16, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x10 }, // 3366
  { IMAGE_SAMPLE_CL_V1_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x1, 0x1 }, // 3367
  { IMAGE_SAMPLE_CL_V1_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x1, 0x2 }, // 3368
  { IMAGE_SAMPLE_CL_V1_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x1, 0x3 }, // 3369
  { IMAGE_SAMPLE_CL_V1_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x1, 0x4 }, // 3370
  { IMAGE_SAMPLE_CL_V2_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x2, 0x1 }, // 3371
  { IMAGE_SAMPLE_CL_V2_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x2, 0x2 }, // 3372
  { IMAGE_SAMPLE_CL_V2_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x2, 0x3 }, // 3373
  { IMAGE_SAMPLE_CL_V2_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x2, 0x4 }, // 3374
  { IMAGE_SAMPLE_CL_V3_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x3, 0x1 }, // 3375
  { IMAGE_SAMPLE_CL_V3_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x3, 0x2 }, // 3376
  { IMAGE_SAMPLE_CL_V3_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x3, 0x3 }, // 3377
  { IMAGE_SAMPLE_CL_V3_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x3, 0x4 }, // 3378
  { IMAGE_SAMPLE_CL_V4_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x4, 0x1 }, // 3379
  { IMAGE_SAMPLE_CL_V4_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x4, 0x2 }, // 3380
  { IMAGE_SAMPLE_CL_V4_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x4, 0x3 }, // 3381
  { IMAGE_SAMPLE_CL_V4_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x4, 0x4 }, // 3382
  { IMAGE_SAMPLE_CL_V5_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x5, 0x1 }, // 3383
  { IMAGE_SAMPLE_CL_V5_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x5, 0x2 }, // 3384
  { IMAGE_SAMPLE_CL_V5_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x5, 0x3 }, // 3385
  { IMAGE_SAMPLE_CL_V5_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x5, 0x4 }, // 3386
  { IMAGE_SAMPLE_CL_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x1, 0x2 }, // 3387
  { IMAGE_SAMPLE_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x1, 0x3 }, // 3388
  { IMAGE_SAMPLE_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x1, 0x4 }, // 3389
  { IMAGE_SAMPLE_CL_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x2, 0x2 }, // 3390
  { IMAGE_SAMPLE_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x2, 0x3 }, // 3391
  { IMAGE_SAMPLE_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x2, 0x4 }, // 3392
  { IMAGE_SAMPLE_CL_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x3, 0x2 }, // 3393
  { IMAGE_SAMPLE_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x3, 0x3 }, // 3394
  { IMAGE_SAMPLE_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x3, 0x4 }, // 3395
  { IMAGE_SAMPLE_CL_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x4, 0x2 }, // 3396
  { IMAGE_SAMPLE_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x4, 0x3 }, // 3397
  { IMAGE_SAMPLE_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x4, 0x4 }, // 3398
  { IMAGE_SAMPLE_CL_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x5, 0x2 }, // 3399
  { IMAGE_SAMPLE_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x5, 0x3 }, // 3400
  { IMAGE_SAMPLE_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x5, 0x4 }, // 3401
  { IMAGE_SAMPLE_CL_V1_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x1 }, // 3402
  { IMAGE_SAMPLE_CL_V1_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x2 }, // 3403
  { IMAGE_SAMPLE_CL_V1_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x3 }, // 3404
  { IMAGE_SAMPLE_CL_V1_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x4 }, // 3405
  { IMAGE_SAMPLE_CL_V2_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x1 }, // 3406
  { IMAGE_SAMPLE_CL_V2_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x2 }, // 3407
  { IMAGE_SAMPLE_CL_V2_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x3 }, // 3408
  { IMAGE_SAMPLE_CL_V2_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x4 }, // 3409
  { IMAGE_SAMPLE_CL_V3_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x1 }, // 3410
  { IMAGE_SAMPLE_CL_V3_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x2 }, // 3411
  { IMAGE_SAMPLE_CL_V3_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x3 }, // 3412
  { IMAGE_SAMPLE_CL_V3_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x4 }, // 3413
  { IMAGE_SAMPLE_CL_V4_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x1 }, // 3414
  { IMAGE_SAMPLE_CL_V4_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x2 }, // 3415
  { IMAGE_SAMPLE_CL_V4_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x3 }, // 3416
  { IMAGE_SAMPLE_CL_V4_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x4 }, // 3417
  { IMAGE_SAMPLE_CL_V5_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x5, 0x1 }, // 3418
  { IMAGE_SAMPLE_CL_V5_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x5, 0x2 }, // 3419
  { IMAGE_SAMPLE_CL_V5_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x5, 0x3 }, // 3420
  { IMAGE_SAMPLE_CL_V5_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x5, 0x4 }, // 3421
  { IMAGE_SAMPLE_CL_O_V1_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x2 }, // 3422
  { IMAGE_SAMPLE_CL_O_V1_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x3 }, // 3423
  { IMAGE_SAMPLE_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x4 }, // 3424
  { IMAGE_SAMPLE_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x5 }, // 3425
  { IMAGE_SAMPLE_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x8 }, // 3426
  { IMAGE_SAMPLE_CL_O_V2_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x2 }, // 3427
  { IMAGE_SAMPLE_CL_O_V2_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 3428
  { IMAGE_SAMPLE_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 3429
  { IMAGE_SAMPLE_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 3430
  { IMAGE_SAMPLE_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 3431
  { IMAGE_SAMPLE_CL_O_V3_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x2 }, // 3432
  { IMAGE_SAMPLE_CL_O_V3_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x3 }, // 3433
  { IMAGE_SAMPLE_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x4 }, // 3434
  { IMAGE_SAMPLE_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x5 }, // 3435
  { IMAGE_SAMPLE_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x8 }, // 3436
  { IMAGE_SAMPLE_CL_O_V4_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x2 }, // 3437
  { IMAGE_SAMPLE_CL_O_V4_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 3438
  { IMAGE_SAMPLE_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 3439
  { IMAGE_SAMPLE_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 3440
  { IMAGE_SAMPLE_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 3441
  { IMAGE_SAMPLE_CL_O_V5_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x2 }, // 3442
  { IMAGE_SAMPLE_CL_O_V5_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 3443
  { IMAGE_SAMPLE_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 3444
  { IMAGE_SAMPLE_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 3445
  { IMAGE_SAMPLE_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 3446
  { IMAGE_SAMPLE_CL_O_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x1, 0x2 }, // 3447
  { IMAGE_SAMPLE_CL_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x1, 0x3 }, // 3448
  { IMAGE_SAMPLE_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x1, 0x4 }, // 3449
  { IMAGE_SAMPLE_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x1, 0x5 }, // 3450
  { IMAGE_SAMPLE_CL_O_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x2, 0x2 }, // 3451
  { IMAGE_SAMPLE_CL_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 3452
  { IMAGE_SAMPLE_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 3453
  { IMAGE_SAMPLE_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 3454
  { IMAGE_SAMPLE_CL_O_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x3, 0x2 }, // 3455
  { IMAGE_SAMPLE_CL_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x3, 0x3 }, // 3456
  { IMAGE_SAMPLE_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x3, 0x4 }, // 3457
  { IMAGE_SAMPLE_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x3, 0x5 }, // 3458
  { IMAGE_SAMPLE_CL_O_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x4, 0x2 }, // 3459
  { IMAGE_SAMPLE_CL_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 3460
  { IMAGE_SAMPLE_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 3461
  { IMAGE_SAMPLE_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 3462
  { IMAGE_SAMPLE_CL_O_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x5, 0x2 }, // 3463
  { IMAGE_SAMPLE_CL_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 3464
  { IMAGE_SAMPLE_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 3465
  { IMAGE_SAMPLE_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 3466
  { IMAGE_SAMPLE_CL_O_V1_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x2 }, // 3467
  { IMAGE_SAMPLE_CL_O_V1_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x3 }, // 3468
  { IMAGE_SAMPLE_CL_O_V1_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x4 }, // 3469
  { IMAGE_SAMPLE_CL_O_V1_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x5 }, // 3470
  { IMAGE_SAMPLE_CL_O_V1_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x8 }, // 3471
  { IMAGE_SAMPLE_CL_O_V2_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x2 }, // 3472
  { IMAGE_SAMPLE_CL_O_V2_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x3 }, // 3473
  { IMAGE_SAMPLE_CL_O_V2_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 3474
  { IMAGE_SAMPLE_CL_O_V2_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x5 }, // 3475
  { IMAGE_SAMPLE_CL_O_V2_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 3476
  { IMAGE_SAMPLE_CL_O_V3_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x2 }, // 3477
  { IMAGE_SAMPLE_CL_O_V3_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x3 }, // 3478
  { IMAGE_SAMPLE_CL_O_V3_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x4 }, // 3479
  { IMAGE_SAMPLE_CL_O_V3_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x5 }, // 3480
  { IMAGE_SAMPLE_CL_O_V3_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x8 }, // 3481
  { IMAGE_SAMPLE_CL_O_V4_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x2 }, // 3482
  { IMAGE_SAMPLE_CL_O_V4_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x3 }, // 3483
  { IMAGE_SAMPLE_CL_O_V4_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 3484
  { IMAGE_SAMPLE_CL_O_V4_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x5 }, // 3485
  { IMAGE_SAMPLE_CL_O_V4_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 3486
  { IMAGE_SAMPLE_CL_O_V5_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x2 }, // 3487
  { IMAGE_SAMPLE_CL_O_V5_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x3 }, // 3488
  { IMAGE_SAMPLE_CL_O_V5_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x4 }, // 3489
  { IMAGE_SAMPLE_CL_O_V5_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x5 }, // 3490
  { IMAGE_SAMPLE_CL_O_V5_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x8 }, // 3491
  { IMAGE_SAMPLE_C_B_V1_V3_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x1, 0x3 }, // 3492
  { IMAGE_SAMPLE_C_B_V1_V4_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x1, 0x4 }, // 3493
  { IMAGE_SAMPLE_C_B_V1_V5_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x1, 0x5 }, // 3494
  { IMAGE_SAMPLE_C_B_V1_V8_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x1, 0x8 }, // 3495
  { IMAGE_SAMPLE_C_B_V2_V3_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x2, 0x3 }, // 3496
  { IMAGE_SAMPLE_C_B_V2_V4_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x2, 0x4 }, // 3497
  { IMAGE_SAMPLE_C_B_V2_V5_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x2, 0x5 }, // 3498
  { IMAGE_SAMPLE_C_B_V2_V8_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x2, 0x8 }, // 3499
  { IMAGE_SAMPLE_C_B_V3_V3_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x3, 0x3 }, // 3500
  { IMAGE_SAMPLE_C_B_V3_V4_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x3, 0x4 }, // 3501
  { IMAGE_SAMPLE_C_B_V3_V5_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x3, 0x5 }, // 3502
  { IMAGE_SAMPLE_C_B_V3_V8_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x3, 0x8 }, // 3503
  { IMAGE_SAMPLE_C_B_V4_V3_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x4, 0x3 }, // 3504
  { IMAGE_SAMPLE_C_B_V4_V4_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x4, 0x4 }, // 3505
  { IMAGE_SAMPLE_C_B_V4_V5_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x4, 0x5 }, // 3506
  { IMAGE_SAMPLE_C_B_V4_V8_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x4, 0x8 }, // 3507
  { IMAGE_SAMPLE_C_B_V5_V3_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x5, 0x3 }, // 3508
  { IMAGE_SAMPLE_C_B_V5_V4_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x5, 0x4 }, // 3509
  { IMAGE_SAMPLE_C_B_V5_V5_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x5, 0x5 }, // 3510
  { IMAGE_SAMPLE_C_B_V5_V8_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x5, 0x8 }, // 3511
  { IMAGE_SAMPLE_C_B_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x1, 0x3 }, // 3512
  { IMAGE_SAMPLE_C_B_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x1, 0x4 }, // 3513
  { IMAGE_SAMPLE_C_B_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x1, 0x5 }, // 3514
  { IMAGE_SAMPLE_C_B_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x2, 0x3 }, // 3515
  { IMAGE_SAMPLE_C_B_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x2, 0x4 }, // 3516
  { IMAGE_SAMPLE_C_B_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x2, 0x5 }, // 3517
  { IMAGE_SAMPLE_C_B_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x3, 0x3 }, // 3518
  { IMAGE_SAMPLE_C_B_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x3, 0x4 }, // 3519
  { IMAGE_SAMPLE_C_B_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x3, 0x5 }, // 3520
  { IMAGE_SAMPLE_C_B_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x4, 0x3 }, // 3521
  { IMAGE_SAMPLE_C_B_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x4, 0x4 }, // 3522
  { IMAGE_SAMPLE_C_B_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x4, 0x5 }, // 3523
  { IMAGE_SAMPLE_C_B_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x5, 0x3 }, // 3524
  { IMAGE_SAMPLE_C_B_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x5, 0x4 }, // 3525
  { IMAGE_SAMPLE_C_B_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x5, 0x5 }, // 3526
  { IMAGE_SAMPLE_C_B_V1_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x1, 0x3 }, // 3527
  { IMAGE_SAMPLE_C_B_V1_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x1, 0x4 }, // 3528
  { IMAGE_SAMPLE_C_B_V1_V5, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x1, 0x5 }, // 3529
  { IMAGE_SAMPLE_C_B_V1_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x1, 0x8 }, // 3530
  { IMAGE_SAMPLE_C_B_V2_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x2, 0x3 }, // 3531
  { IMAGE_SAMPLE_C_B_V2_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x2, 0x4 }, // 3532
  { IMAGE_SAMPLE_C_B_V2_V5, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x2, 0x5 }, // 3533
  { IMAGE_SAMPLE_C_B_V2_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x2, 0x8 }, // 3534
  { IMAGE_SAMPLE_C_B_V3_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x3, 0x3 }, // 3535
  { IMAGE_SAMPLE_C_B_V3_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x3, 0x4 }, // 3536
  { IMAGE_SAMPLE_C_B_V3_V5, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x3, 0x5 }, // 3537
  { IMAGE_SAMPLE_C_B_V3_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x3, 0x8 }, // 3538
  { IMAGE_SAMPLE_C_B_V4_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x4, 0x3 }, // 3539
  { IMAGE_SAMPLE_C_B_V4_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x4, 0x4 }, // 3540
  { IMAGE_SAMPLE_C_B_V4_V5, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x4, 0x5 }, // 3541
  { IMAGE_SAMPLE_C_B_V4_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x4, 0x8 }, // 3542
  { IMAGE_SAMPLE_C_B_V5_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x5, 0x3 }, // 3543
  { IMAGE_SAMPLE_C_B_V5_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x5, 0x4 }, // 3544
  { IMAGE_SAMPLE_C_B_V5_V5, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x5, 0x5 }, // 3545
  { IMAGE_SAMPLE_C_B_V5_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x5, 0x8 }, // 3546
  { IMAGE_SAMPLE_C_B_CL_V1_V3_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x1, 0x3 }, // 3547
  { IMAGE_SAMPLE_C_B_CL_V1_V4_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x1, 0x4 }, // 3548
  { IMAGE_SAMPLE_C_B_CL_V1_V5_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x1, 0x5 }, // 3549
  { IMAGE_SAMPLE_C_B_CL_V1_V6_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x1, 0x6 }, // 3550
  { IMAGE_SAMPLE_C_B_CL_V1_V8_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x1, 0x8 }, // 3551
  { IMAGE_SAMPLE_C_B_CL_V2_V3_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x2, 0x3 }, // 3552
  { IMAGE_SAMPLE_C_B_CL_V2_V4_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x2, 0x4 }, // 3553
  { IMAGE_SAMPLE_C_B_CL_V2_V5_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x2, 0x5 }, // 3554
  { IMAGE_SAMPLE_C_B_CL_V2_V6_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x2, 0x6 }, // 3555
  { IMAGE_SAMPLE_C_B_CL_V2_V8_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x2, 0x8 }, // 3556
  { IMAGE_SAMPLE_C_B_CL_V3_V3_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x3, 0x3 }, // 3557
  { IMAGE_SAMPLE_C_B_CL_V3_V4_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x3, 0x4 }, // 3558
  { IMAGE_SAMPLE_C_B_CL_V3_V5_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x3, 0x5 }, // 3559
  { IMAGE_SAMPLE_C_B_CL_V3_V6_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x3, 0x6 }, // 3560
  { IMAGE_SAMPLE_C_B_CL_V3_V8_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x3, 0x8 }, // 3561
  { IMAGE_SAMPLE_C_B_CL_V4_V3_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x4, 0x3 }, // 3562
  { IMAGE_SAMPLE_C_B_CL_V4_V4_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x4, 0x4 }, // 3563
  { IMAGE_SAMPLE_C_B_CL_V4_V5_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x4, 0x5 }, // 3564
  { IMAGE_SAMPLE_C_B_CL_V4_V6_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x4, 0x6 }, // 3565
  { IMAGE_SAMPLE_C_B_CL_V4_V8_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x4, 0x8 }, // 3566
  { IMAGE_SAMPLE_C_B_CL_V5_V3_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x5, 0x3 }, // 3567
  { IMAGE_SAMPLE_C_B_CL_V5_V4_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x5, 0x4 }, // 3568
  { IMAGE_SAMPLE_C_B_CL_V5_V5_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x5, 0x5 }, // 3569
  { IMAGE_SAMPLE_C_B_CL_V5_V6_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x5, 0x6 }, // 3570
  { IMAGE_SAMPLE_C_B_CL_V5_V8_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x5, 0x8 }, // 3571
  { IMAGE_SAMPLE_C_B_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x1, 0x3 }, // 3572
  { IMAGE_SAMPLE_C_B_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x1, 0x4 }, // 3573
  { IMAGE_SAMPLE_C_B_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x1, 0x5 }, // 3574
  { IMAGE_SAMPLE_C_B_CL_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x1, 0x6 }, // 3575
  { IMAGE_SAMPLE_C_B_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x3 }, // 3576
  { IMAGE_SAMPLE_C_B_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x4 }, // 3577
  { IMAGE_SAMPLE_C_B_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x5 }, // 3578
  { IMAGE_SAMPLE_C_B_CL_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x6 }, // 3579
  { IMAGE_SAMPLE_C_B_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x3, 0x3 }, // 3580
  { IMAGE_SAMPLE_C_B_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x3, 0x4 }, // 3581
  { IMAGE_SAMPLE_C_B_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x3, 0x5 }, // 3582
  { IMAGE_SAMPLE_C_B_CL_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x3, 0x6 }, // 3583
  { IMAGE_SAMPLE_C_B_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x3 }, // 3584
  { IMAGE_SAMPLE_C_B_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x4 }, // 3585
  { IMAGE_SAMPLE_C_B_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x5 }, // 3586
  { IMAGE_SAMPLE_C_B_CL_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x6 }, // 3587
  { IMAGE_SAMPLE_C_B_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x3 }, // 3588
  { IMAGE_SAMPLE_C_B_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x4 }, // 3589
  { IMAGE_SAMPLE_C_B_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x5 }, // 3590
  { IMAGE_SAMPLE_C_B_CL_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x6 }, // 3591
  { IMAGE_SAMPLE_C_B_CL_V1_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x3 }, // 3592
  { IMAGE_SAMPLE_C_B_CL_V1_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x4 }, // 3593
  { IMAGE_SAMPLE_C_B_CL_V1_V5, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x5 }, // 3594
  { IMAGE_SAMPLE_C_B_CL_V1_V6, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x6 }, // 3595
  { IMAGE_SAMPLE_C_B_CL_V1_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x8 }, // 3596
  { IMAGE_SAMPLE_C_B_CL_V2_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x3 }, // 3597
  { IMAGE_SAMPLE_C_B_CL_V2_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x4 }, // 3598
  { IMAGE_SAMPLE_C_B_CL_V2_V5, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x5 }, // 3599
  { IMAGE_SAMPLE_C_B_CL_V2_V6, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x6 }, // 3600
  { IMAGE_SAMPLE_C_B_CL_V2_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x8 }, // 3601
  { IMAGE_SAMPLE_C_B_CL_V3_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x3 }, // 3602
  { IMAGE_SAMPLE_C_B_CL_V3_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x4 }, // 3603
  { IMAGE_SAMPLE_C_B_CL_V3_V5, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x5 }, // 3604
  { IMAGE_SAMPLE_C_B_CL_V3_V6, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x6 }, // 3605
  { IMAGE_SAMPLE_C_B_CL_V3_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x8 }, // 3606
  { IMAGE_SAMPLE_C_B_CL_V4_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x3 }, // 3607
  { IMAGE_SAMPLE_C_B_CL_V4_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x4 }, // 3608
  { IMAGE_SAMPLE_C_B_CL_V4_V5, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x5 }, // 3609
  { IMAGE_SAMPLE_C_B_CL_V4_V6, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x6 }, // 3610
  { IMAGE_SAMPLE_C_B_CL_V4_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x8 }, // 3611
  { IMAGE_SAMPLE_C_B_CL_V5_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x5, 0x3 }, // 3612
  { IMAGE_SAMPLE_C_B_CL_V5_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x5, 0x4 }, // 3613
  { IMAGE_SAMPLE_C_B_CL_V5_V5, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x5, 0x5 }, // 3614
  { IMAGE_SAMPLE_C_B_CL_V5_V6, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x5, 0x6 }, // 3615
  { IMAGE_SAMPLE_C_B_CL_V5_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x5, 0x8 }, // 3616
  { IMAGE_SAMPLE_C_B_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x1, 0x4 }, // 3617
  { IMAGE_SAMPLE_C_B_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x1, 0x5 }, // 3618
  { IMAGE_SAMPLE_C_B_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x1, 0x6 }, // 3619
  { IMAGE_SAMPLE_C_B_CL_O_V1_V7_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x1, 0x7 }, // 3620
  { IMAGE_SAMPLE_C_B_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x1, 0x8 }, // 3621
  { IMAGE_SAMPLE_C_B_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 3622
  { IMAGE_SAMPLE_C_B_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 3623
  { IMAGE_SAMPLE_C_B_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x6 }, // 3624
  { IMAGE_SAMPLE_C_B_CL_O_V2_V7_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x7 }, // 3625
  { IMAGE_SAMPLE_C_B_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 3626
  { IMAGE_SAMPLE_C_B_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x3, 0x4 }, // 3627
  { IMAGE_SAMPLE_C_B_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x3, 0x5 }, // 3628
  { IMAGE_SAMPLE_C_B_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x3, 0x6 }, // 3629
  { IMAGE_SAMPLE_C_B_CL_O_V3_V7_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x3, 0x7 }, // 3630
  { IMAGE_SAMPLE_C_B_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x3, 0x8 }, // 3631
  { IMAGE_SAMPLE_C_B_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 3632
  { IMAGE_SAMPLE_C_B_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 3633
  { IMAGE_SAMPLE_C_B_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x6 }, // 3634
  { IMAGE_SAMPLE_C_B_CL_O_V4_V7_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x7 }, // 3635
  { IMAGE_SAMPLE_C_B_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 3636
  { IMAGE_SAMPLE_C_B_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 3637
  { IMAGE_SAMPLE_C_B_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 3638
  { IMAGE_SAMPLE_C_B_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x6 }, // 3639
  { IMAGE_SAMPLE_C_B_CL_O_V5_V7_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x7 }, // 3640
  { IMAGE_SAMPLE_C_B_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 3641
  { IMAGE_SAMPLE_C_B_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x4 }, // 3642
  { IMAGE_SAMPLE_C_B_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x5 }, // 3643
  { IMAGE_SAMPLE_C_B_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x6 }, // 3644
  { IMAGE_SAMPLE_C_B_CL_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x7 }, // 3645
  { IMAGE_SAMPLE_C_B_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 3646
  { IMAGE_SAMPLE_C_B_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 3647
  { IMAGE_SAMPLE_C_B_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x6 }, // 3648
  { IMAGE_SAMPLE_C_B_CL_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x7 }, // 3649
  { IMAGE_SAMPLE_C_B_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x4 }, // 3650
  { IMAGE_SAMPLE_C_B_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x5 }, // 3651
  { IMAGE_SAMPLE_C_B_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x6 }, // 3652
  { IMAGE_SAMPLE_C_B_CL_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x7 }, // 3653
  { IMAGE_SAMPLE_C_B_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 3654
  { IMAGE_SAMPLE_C_B_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 3655
  { IMAGE_SAMPLE_C_B_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x6 }, // 3656
  { IMAGE_SAMPLE_C_B_CL_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x7 }, // 3657
  { IMAGE_SAMPLE_C_B_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 3658
  { IMAGE_SAMPLE_C_B_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 3659
  { IMAGE_SAMPLE_C_B_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x6 }, // 3660
  { IMAGE_SAMPLE_C_B_CL_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x7 }, // 3661
  { IMAGE_SAMPLE_C_B_CL_O_V1_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x4 }, // 3662
  { IMAGE_SAMPLE_C_B_CL_O_V1_V5, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x5 }, // 3663
  { IMAGE_SAMPLE_C_B_CL_O_V1_V6, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x6 }, // 3664
  { IMAGE_SAMPLE_C_B_CL_O_V1_V7, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x7 }, // 3665
  { IMAGE_SAMPLE_C_B_CL_O_V1_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x8 }, // 3666
  { IMAGE_SAMPLE_C_B_CL_O_V2_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 3667
  { IMAGE_SAMPLE_C_B_CL_O_V2_V5, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x5 }, // 3668
  { IMAGE_SAMPLE_C_B_CL_O_V2_V6, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x6 }, // 3669
  { IMAGE_SAMPLE_C_B_CL_O_V2_V7, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x7 }, // 3670
  { IMAGE_SAMPLE_C_B_CL_O_V2_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 3671
  { IMAGE_SAMPLE_C_B_CL_O_V3_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x4 }, // 3672
  { IMAGE_SAMPLE_C_B_CL_O_V3_V5, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x5 }, // 3673
  { IMAGE_SAMPLE_C_B_CL_O_V3_V6, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x6 }, // 3674
  { IMAGE_SAMPLE_C_B_CL_O_V3_V7, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x7 }, // 3675
  { IMAGE_SAMPLE_C_B_CL_O_V3_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x8 }, // 3676
  { IMAGE_SAMPLE_C_B_CL_O_V4_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 3677
  { IMAGE_SAMPLE_C_B_CL_O_V4_V5, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x5 }, // 3678
  { IMAGE_SAMPLE_C_B_CL_O_V4_V6, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x6 }, // 3679
  { IMAGE_SAMPLE_C_B_CL_O_V4_V7, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x7 }, // 3680
  { IMAGE_SAMPLE_C_B_CL_O_V4_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 3681
  { IMAGE_SAMPLE_C_B_CL_O_V5_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x5, 0x4 }, // 3682
  { IMAGE_SAMPLE_C_B_CL_O_V5_V5, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x5, 0x5 }, // 3683
  { IMAGE_SAMPLE_C_B_CL_O_V5_V6, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x5, 0x6 }, // 3684
  { IMAGE_SAMPLE_C_B_CL_O_V5_V7, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x5, 0x7 }, // 3685
  { IMAGE_SAMPLE_C_B_CL_O_V5_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x5, 0x8 }, // 3686
  { IMAGE_SAMPLE_C_B_O_V1_V4_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x1, 0x4 }, // 3687
  { IMAGE_SAMPLE_C_B_O_V1_V5_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x1, 0x5 }, // 3688
  { IMAGE_SAMPLE_C_B_O_V1_V6_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x1, 0x6 }, // 3689
  { IMAGE_SAMPLE_C_B_O_V1_V8_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x1, 0x8 }, // 3690
  { IMAGE_SAMPLE_C_B_O_V2_V4_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 3691
  { IMAGE_SAMPLE_C_B_O_V2_V5_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 3692
  { IMAGE_SAMPLE_C_B_O_V2_V6_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x2, 0x6 }, // 3693
  { IMAGE_SAMPLE_C_B_O_V2_V8_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 3694
  { IMAGE_SAMPLE_C_B_O_V3_V4_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x3, 0x4 }, // 3695
  { IMAGE_SAMPLE_C_B_O_V3_V5_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x3, 0x5 }, // 3696
  { IMAGE_SAMPLE_C_B_O_V3_V6_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x3, 0x6 }, // 3697
  { IMAGE_SAMPLE_C_B_O_V3_V8_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x3, 0x8 }, // 3698
  { IMAGE_SAMPLE_C_B_O_V4_V4_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 3699
  { IMAGE_SAMPLE_C_B_O_V4_V5_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 3700
  { IMAGE_SAMPLE_C_B_O_V4_V6_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x4, 0x6 }, // 3701
  { IMAGE_SAMPLE_C_B_O_V4_V8_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 3702
  { IMAGE_SAMPLE_C_B_O_V5_V4_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 3703
  { IMAGE_SAMPLE_C_B_O_V5_V5_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 3704
  { IMAGE_SAMPLE_C_B_O_V5_V6_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x5, 0x6 }, // 3705
  { IMAGE_SAMPLE_C_B_O_V5_V8_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 3706
  { IMAGE_SAMPLE_C_B_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x1, 0x4 }, // 3707
  { IMAGE_SAMPLE_C_B_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x1, 0x5 }, // 3708
  { IMAGE_SAMPLE_C_B_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x1, 0x6 }, // 3709
  { IMAGE_SAMPLE_C_B_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 3710
  { IMAGE_SAMPLE_C_B_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 3711
  { IMAGE_SAMPLE_C_B_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x2, 0x6 }, // 3712
  { IMAGE_SAMPLE_C_B_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x3, 0x4 }, // 3713
  { IMAGE_SAMPLE_C_B_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x3, 0x5 }, // 3714
  { IMAGE_SAMPLE_C_B_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x3, 0x6 }, // 3715
  { IMAGE_SAMPLE_C_B_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 3716
  { IMAGE_SAMPLE_C_B_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 3717
  { IMAGE_SAMPLE_C_B_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x4, 0x6 }, // 3718
  { IMAGE_SAMPLE_C_B_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 3719
  { IMAGE_SAMPLE_C_B_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 3720
  { IMAGE_SAMPLE_C_B_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x5, 0x6 }, // 3721
  { IMAGE_SAMPLE_C_B_O_V1_V4, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x1, 0x4 }, // 3722
  { IMAGE_SAMPLE_C_B_O_V1_V5, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x1, 0x5 }, // 3723
  { IMAGE_SAMPLE_C_B_O_V1_V6, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x1, 0x6 }, // 3724
  { IMAGE_SAMPLE_C_B_O_V1_V8, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x1, 0x8 }, // 3725
  { IMAGE_SAMPLE_C_B_O_V2_V4, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x2, 0x4 }, // 3726
  { IMAGE_SAMPLE_C_B_O_V2_V5, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x2, 0x5 }, // 3727
  { IMAGE_SAMPLE_C_B_O_V2_V6, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x2, 0x6 }, // 3728
  { IMAGE_SAMPLE_C_B_O_V2_V8, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x2, 0x8 }, // 3729
  { IMAGE_SAMPLE_C_B_O_V3_V4, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x3, 0x4 }, // 3730
  { IMAGE_SAMPLE_C_B_O_V3_V5, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x3, 0x5 }, // 3731
  { IMAGE_SAMPLE_C_B_O_V3_V6, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x3, 0x6 }, // 3732
  { IMAGE_SAMPLE_C_B_O_V3_V8, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x3, 0x8 }, // 3733
  { IMAGE_SAMPLE_C_B_O_V4_V4, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x4, 0x4 }, // 3734
  { IMAGE_SAMPLE_C_B_O_V4_V5, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x4, 0x5 }, // 3735
  { IMAGE_SAMPLE_C_B_O_V4_V6, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x4, 0x6 }, // 3736
  { IMAGE_SAMPLE_C_B_O_V4_V8, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x4, 0x8 }, // 3737
  { IMAGE_SAMPLE_C_B_O_V5_V4, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x5, 0x4 }, // 3738
  { IMAGE_SAMPLE_C_B_O_V5_V5, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x5, 0x5 }, // 3739
  { IMAGE_SAMPLE_C_B_O_V5_V6, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x5, 0x6 }, // 3740
  { IMAGE_SAMPLE_C_B_O_V5_V8, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x5, 0x8 }, // 3741
  { IMAGE_SAMPLE_C_CD_V1_V3_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0x3 }, // 3742
  { IMAGE_SAMPLE_C_CD_V1_V4_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0x4 }, // 3743
  { IMAGE_SAMPLE_C_CD_V1_V5_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0x5 }, // 3744
  { IMAGE_SAMPLE_C_CD_V1_V6_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0x6 }, // 3745
  { IMAGE_SAMPLE_C_CD_V1_V7_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0x7 }, // 3746
  { IMAGE_SAMPLE_C_CD_V1_V8_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0x8 }, // 3747
  { IMAGE_SAMPLE_C_CD_V1_V16_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0x10 }, // 3748
  { IMAGE_SAMPLE_C_CD_V2_V3_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0x3 }, // 3749
  { IMAGE_SAMPLE_C_CD_V2_V4_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0x4 }, // 3750
  { IMAGE_SAMPLE_C_CD_V2_V5_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0x5 }, // 3751
  { IMAGE_SAMPLE_C_CD_V2_V6_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0x6 }, // 3752
  { IMAGE_SAMPLE_C_CD_V2_V7_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0x7 }, // 3753
  { IMAGE_SAMPLE_C_CD_V2_V8_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0x8 }, // 3754
  { IMAGE_SAMPLE_C_CD_V2_V16_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0x10 }, // 3755
  { IMAGE_SAMPLE_C_CD_V3_V3_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0x3 }, // 3756
  { IMAGE_SAMPLE_C_CD_V3_V4_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0x4 }, // 3757
  { IMAGE_SAMPLE_C_CD_V3_V5_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0x5 }, // 3758
  { IMAGE_SAMPLE_C_CD_V3_V6_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0x6 }, // 3759
  { IMAGE_SAMPLE_C_CD_V3_V7_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0x7 }, // 3760
  { IMAGE_SAMPLE_C_CD_V3_V8_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0x8 }, // 3761
  { IMAGE_SAMPLE_C_CD_V3_V16_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0x10 }, // 3762
  { IMAGE_SAMPLE_C_CD_V4_V3_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0x3 }, // 3763
  { IMAGE_SAMPLE_C_CD_V4_V4_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0x4 }, // 3764
  { IMAGE_SAMPLE_C_CD_V4_V5_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0x5 }, // 3765
  { IMAGE_SAMPLE_C_CD_V4_V6_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0x6 }, // 3766
  { IMAGE_SAMPLE_C_CD_V4_V7_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0x7 }, // 3767
  { IMAGE_SAMPLE_C_CD_V4_V8_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0x8 }, // 3768
  { IMAGE_SAMPLE_C_CD_V4_V16_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0x10 }, // 3769
  { IMAGE_SAMPLE_C_CD_V5_V3_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0x3 }, // 3770
  { IMAGE_SAMPLE_C_CD_V5_V4_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0x4 }, // 3771
  { IMAGE_SAMPLE_C_CD_V5_V5_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0x5 }, // 3772
  { IMAGE_SAMPLE_C_CD_V5_V6_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0x6 }, // 3773
  { IMAGE_SAMPLE_C_CD_V5_V7_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0x7 }, // 3774
  { IMAGE_SAMPLE_C_CD_V5_V8_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0x8 }, // 3775
  { IMAGE_SAMPLE_C_CD_V5_V16_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0x10 }, // 3776
  { IMAGE_SAMPLE_C_CD_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0x3 }, // 3777
  { IMAGE_SAMPLE_C_CD_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0x4 }, // 3778
  { IMAGE_SAMPLE_C_CD_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0x5 }, // 3779
  { IMAGE_SAMPLE_C_CD_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0x6 }, // 3780
  { IMAGE_SAMPLE_C_CD_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0x7 }, // 3781
  { IMAGE_SAMPLE_C_CD_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0x8 }, // 3782
  { IMAGE_SAMPLE_C_CD_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0x9 }, // 3783
  { IMAGE_SAMPLE_C_CD_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0xA }, // 3784
  { IMAGE_SAMPLE_C_CD_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0x3 }, // 3785
  { IMAGE_SAMPLE_C_CD_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0x4 }, // 3786
  { IMAGE_SAMPLE_C_CD_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0x5 }, // 3787
  { IMAGE_SAMPLE_C_CD_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0x6 }, // 3788
  { IMAGE_SAMPLE_C_CD_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0x7 }, // 3789
  { IMAGE_SAMPLE_C_CD_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0x8 }, // 3790
  { IMAGE_SAMPLE_C_CD_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0x9 }, // 3791
  { IMAGE_SAMPLE_C_CD_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0xA }, // 3792
  { IMAGE_SAMPLE_C_CD_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0x3 }, // 3793
  { IMAGE_SAMPLE_C_CD_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0x4 }, // 3794
  { IMAGE_SAMPLE_C_CD_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0x5 }, // 3795
  { IMAGE_SAMPLE_C_CD_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0x6 }, // 3796
  { IMAGE_SAMPLE_C_CD_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0x7 }, // 3797
  { IMAGE_SAMPLE_C_CD_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0x8 }, // 3798
  { IMAGE_SAMPLE_C_CD_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0x9 }, // 3799
  { IMAGE_SAMPLE_C_CD_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0xA }, // 3800
  { IMAGE_SAMPLE_C_CD_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0x3 }, // 3801
  { IMAGE_SAMPLE_C_CD_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0x4 }, // 3802
  { IMAGE_SAMPLE_C_CD_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0x5 }, // 3803
  { IMAGE_SAMPLE_C_CD_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0x6 }, // 3804
  { IMAGE_SAMPLE_C_CD_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0x7 }, // 3805
  { IMAGE_SAMPLE_C_CD_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0x8 }, // 3806
  { IMAGE_SAMPLE_C_CD_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0x9 }, // 3807
  { IMAGE_SAMPLE_C_CD_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0xA }, // 3808
  { IMAGE_SAMPLE_C_CD_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0x3 }, // 3809
  { IMAGE_SAMPLE_C_CD_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0x4 }, // 3810
  { IMAGE_SAMPLE_C_CD_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0x5 }, // 3811
  { IMAGE_SAMPLE_C_CD_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0x6 }, // 3812
  { IMAGE_SAMPLE_C_CD_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0x7 }, // 3813
  { IMAGE_SAMPLE_C_CD_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0x8 }, // 3814
  { IMAGE_SAMPLE_C_CD_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0x9 }, // 3815
  { IMAGE_SAMPLE_C_CD_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0xA }, // 3816
  { IMAGE_SAMPLE_C_CD_V1_V3, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x3 }, // 3817
  { IMAGE_SAMPLE_C_CD_V1_V4, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x4 }, // 3818
  { IMAGE_SAMPLE_C_CD_V1_V5, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x5 }, // 3819
  { IMAGE_SAMPLE_C_CD_V1_V6, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x6 }, // 3820
  { IMAGE_SAMPLE_C_CD_V1_V7, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x7 }, // 3821
  { IMAGE_SAMPLE_C_CD_V1_V8, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x8 }, // 3822
  { IMAGE_SAMPLE_C_CD_V1_V16, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x10 }, // 3823
  { IMAGE_SAMPLE_C_CD_V2_V3, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x3 }, // 3824
  { IMAGE_SAMPLE_C_CD_V2_V4, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x4 }, // 3825
  { IMAGE_SAMPLE_C_CD_V2_V5, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x5 }, // 3826
  { IMAGE_SAMPLE_C_CD_V2_V6, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x6 }, // 3827
  { IMAGE_SAMPLE_C_CD_V2_V7, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x7 }, // 3828
  { IMAGE_SAMPLE_C_CD_V2_V8, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x8 }, // 3829
  { IMAGE_SAMPLE_C_CD_V2_V16, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x10 }, // 3830
  { IMAGE_SAMPLE_C_CD_V3_V3, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x3 }, // 3831
  { IMAGE_SAMPLE_C_CD_V3_V4, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x4 }, // 3832
  { IMAGE_SAMPLE_C_CD_V3_V5, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x5 }, // 3833
  { IMAGE_SAMPLE_C_CD_V3_V6, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x6 }, // 3834
  { IMAGE_SAMPLE_C_CD_V3_V7, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x7 }, // 3835
  { IMAGE_SAMPLE_C_CD_V3_V8, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x8 }, // 3836
  { IMAGE_SAMPLE_C_CD_V3_V16, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x10 }, // 3837
  { IMAGE_SAMPLE_C_CD_V4_V3, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x3 }, // 3838
  { IMAGE_SAMPLE_C_CD_V4_V4, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x4 }, // 3839
  { IMAGE_SAMPLE_C_CD_V4_V5, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x5 }, // 3840
  { IMAGE_SAMPLE_C_CD_V4_V6, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x6 }, // 3841
  { IMAGE_SAMPLE_C_CD_V4_V7, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x7 }, // 3842
  { IMAGE_SAMPLE_C_CD_V4_V8, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x8 }, // 3843
  { IMAGE_SAMPLE_C_CD_V4_V16, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x10 }, // 3844
  { IMAGE_SAMPLE_C_CD_V5_V3, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0x3 }, // 3845
  { IMAGE_SAMPLE_C_CD_V5_V4, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0x4 }, // 3846
  { IMAGE_SAMPLE_C_CD_V5_V5, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0x5 }, // 3847
  { IMAGE_SAMPLE_C_CD_V5_V6, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0x6 }, // 3848
  { IMAGE_SAMPLE_C_CD_V5_V7, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0x7 }, // 3849
  { IMAGE_SAMPLE_C_CD_V5_V8, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0x8 }, // 3850
  { IMAGE_SAMPLE_C_CD_V5_V16, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0x10 }, // 3851
  { IMAGE_SAMPLE_C_CD_CL_V1_V3_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0x3 }, // 3852
  { IMAGE_SAMPLE_C_CD_CL_V1_V4_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0x4 }, // 3853
  { IMAGE_SAMPLE_C_CD_CL_V1_V5_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0x5 }, // 3854
  { IMAGE_SAMPLE_C_CD_CL_V1_V6_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0x6 }, // 3855
  { IMAGE_SAMPLE_C_CD_CL_V1_V7_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0x7 }, // 3856
  { IMAGE_SAMPLE_C_CD_CL_V1_V8_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0x8 }, // 3857
  { IMAGE_SAMPLE_C_CD_CL_V1_V16_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0x10 }, // 3858
  { IMAGE_SAMPLE_C_CD_CL_V2_V3_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0x3 }, // 3859
  { IMAGE_SAMPLE_C_CD_CL_V2_V4_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0x4 }, // 3860
  { IMAGE_SAMPLE_C_CD_CL_V2_V5_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0x5 }, // 3861
  { IMAGE_SAMPLE_C_CD_CL_V2_V6_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0x6 }, // 3862
  { IMAGE_SAMPLE_C_CD_CL_V2_V7_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0x7 }, // 3863
  { IMAGE_SAMPLE_C_CD_CL_V2_V8_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0x8 }, // 3864
  { IMAGE_SAMPLE_C_CD_CL_V2_V16_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0x10 }, // 3865
  { IMAGE_SAMPLE_C_CD_CL_V3_V3_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0x3 }, // 3866
  { IMAGE_SAMPLE_C_CD_CL_V3_V4_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0x4 }, // 3867
  { IMAGE_SAMPLE_C_CD_CL_V3_V5_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0x5 }, // 3868
  { IMAGE_SAMPLE_C_CD_CL_V3_V6_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0x6 }, // 3869
  { IMAGE_SAMPLE_C_CD_CL_V3_V7_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0x7 }, // 3870
  { IMAGE_SAMPLE_C_CD_CL_V3_V8_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0x8 }, // 3871
  { IMAGE_SAMPLE_C_CD_CL_V3_V16_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0x10 }, // 3872
  { IMAGE_SAMPLE_C_CD_CL_V4_V3_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0x3 }, // 3873
  { IMAGE_SAMPLE_C_CD_CL_V4_V4_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0x4 }, // 3874
  { IMAGE_SAMPLE_C_CD_CL_V4_V5_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0x5 }, // 3875
  { IMAGE_SAMPLE_C_CD_CL_V4_V6_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0x6 }, // 3876
  { IMAGE_SAMPLE_C_CD_CL_V4_V7_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0x7 }, // 3877
  { IMAGE_SAMPLE_C_CD_CL_V4_V8_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0x8 }, // 3878
  { IMAGE_SAMPLE_C_CD_CL_V4_V16_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0x10 }, // 3879
  { IMAGE_SAMPLE_C_CD_CL_V5_V3_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0x3 }, // 3880
  { IMAGE_SAMPLE_C_CD_CL_V5_V4_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0x4 }, // 3881
  { IMAGE_SAMPLE_C_CD_CL_V5_V5_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0x5 }, // 3882
  { IMAGE_SAMPLE_C_CD_CL_V5_V6_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0x6 }, // 3883
  { IMAGE_SAMPLE_C_CD_CL_V5_V7_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0x7 }, // 3884
  { IMAGE_SAMPLE_C_CD_CL_V5_V8_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0x8 }, // 3885
  { IMAGE_SAMPLE_C_CD_CL_V5_V16_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0x10 }, // 3886
  { IMAGE_SAMPLE_C_CD_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0x3 }, // 3887
  { IMAGE_SAMPLE_C_CD_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0x4 }, // 3888
  { IMAGE_SAMPLE_C_CD_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0x5 }, // 3889
  { IMAGE_SAMPLE_C_CD_CL_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0x6 }, // 3890
  { IMAGE_SAMPLE_C_CD_CL_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0x7 }, // 3891
  { IMAGE_SAMPLE_C_CD_CL_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0x8 }, // 3892
  { IMAGE_SAMPLE_C_CD_CL_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0x9 }, // 3893
  { IMAGE_SAMPLE_C_CD_CL_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0xA }, // 3894
  { IMAGE_SAMPLE_C_CD_CL_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0xB }, // 3895
  { IMAGE_SAMPLE_C_CD_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0x3 }, // 3896
  { IMAGE_SAMPLE_C_CD_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0x4 }, // 3897
  { IMAGE_SAMPLE_C_CD_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0x5 }, // 3898
  { IMAGE_SAMPLE_C_CD_CL_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0x6 }, // 3899
  { IMAGE_SAMPLE_C_CD_CL_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0x7 }, // 3900
  { IMAGE_SAMPLE_C_CD_CL_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0x8 }, // 3901
  { IMAGE_SAMPLE_C_CD_CL_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0x9 }, // 3902
  { IMAGE_SAMPLE_C_CD_CL_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0xA }, // 3903
  { IMAGE_SAMPLE_C_CD_CL_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0xB }, // 3904
  { IMAGE_SAMPLE_C_CD_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0x3 }, // 3905
  { IMAGE_SAMPLE_C_CD_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0x4 }, // 3906
  { IMAGE_SAMPLE_C_CD_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0x5 }, // 3907
  { IMAGE_SAMPLE_C_CD_CL_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0x6 }, // 3908
  { IMAGE_SAMPLE_C_CD_CL_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0x7 }, // 3909
  { IMAGE_SAMPLE_C_CD_CL_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0x8 }, // 3910
  { IMAGE_SAMPLE_C_CD_CL_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0x9 }, // 3911
  { IMAGE_SAMPLE_C_CD_CL_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0xA }, // 3912
  { IMAGE_SAMPLE_C_CD_CL_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0xB }, // 3913
  { IMAGE_SAMPLE_C_CD_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0x3 }, // 3914
  { IMAGE_SAMPLE_C_CD_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0x4 }, // 3915
  { IMAGE_SAMPLE_C_CD_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0x5 }, // 3916
  { IMAGE_SAMPLE_C_CD_CL_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0x6 }, // 3917
  { IMAGE_SAMPLE_C_CD_CL_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0x7 }, // 3918
  { IMAGE_SAMPLE_C_CD_CL_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0x8 }, // 3919
  { IMAGE_SAMPLE_C_CD_CL_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0x9 }, // 3920
  { IMAGE_SAMPLE_C_CD_CL_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0xA }, // 3921
  { IMAGE_SAMPLE_C_CD_CL_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0xB }, // 3922
  { IMAGE_SAMPLE_C_CD_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0x3 }, // 3923
  { IMAGE_SAMPLE_C_CD_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0x4 }, // 3924
  { IMAGE_SAMPLE_C_CD_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0x5 }, // 3925
  { IMAGE_SAMPLE_C_CD_CL_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0x6 }, // 3926
  { IMAGE_SAMPLE_C_CD_CL_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0x7 }, // 3927
  { IMAGE_SAMPLE_C_CD_CL_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0x8 }, // 3928
  { IMAGE_SAMPLE_C_CD_CL_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0x9 }, // 3929
  { IMAGE_SAMPLE_C_CD_CL_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0xA }, // 3930
  { IMAGE_SAMPLE_C_CD_CL_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0xB }, // 3931
  { IMAGE_SAMPLE_C_CD_CL_V1_V3, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x3 }, // 3932
  { IMAGE_SAMPLE_C_CD_CL_V1_V4, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x4 }, // 3933
  { IMAGE_SAMPLE_C_CD_CL_V1_V5, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x5 }, // 3934
  { IMAGE_SAMPLE_C_CD_CL_V1_V6, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x6 }, // 3935
  { IMAGE_SAMPLE_C_CD_CL_V1_V7, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x7 }, // 3936
  { IMAGE_SAMPLE_C_CD_CL_V1_V8, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x8 }, // 3937
  { IMAGE_SAMPLE_C_CD_CL_V1_V16, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x10 }, // 3938
  { IMAGE_SAMPLE_C_CD_CL_V2_V3, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x3 }, // 3939
  { IMAGE_SAMPLE_C_CD_CL_V2_V4, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x4 }, // 3940
  { IMAGE_SAMPLE_C_CD_CL_V2_V5, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x5 }, // 3941
  { IMAGE_SAMPLE_C_CD_CL_V2_V6, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x6 }, // 3942
  { IMAGE_SAMPLE_C_CD_CL_V2_V7, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x7 }, // 3943
  { IMAGE_SAMPLE_C_CD_CL_V2_V8, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x8 }, // 3944
  { IMAGE_SAMPLE_C_CD_CL_V2_V16, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x10 }, // 3945
  { IMAGE_SAMPLE_C_CD_CL_V3_V3, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x3 }, // 3946
  { IMAGE_SAMPLE_C_CD_CL_V3_V4, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x4 }, // 3947
  { IMAGE_SAMPLE_C_CD_CL_V3_V5, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x5 }, // 3948
  { IMAGE_SAMPLE_C_CD_CL_V3_V6, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x6 }, // 3949
  { IMAGE_SAMPLE_C_CD_CL_V3_V7, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x7 }, // 3950
  { IMAGE_SAMPLE_C_CD_CL_V3_V8, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x8 }, // 3951
  { IMAGE_SAMPLE_C_CD_CL_V3_V16, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x10 }, // 3952
  { IMAGE_SAMPLE_C_CD_CL_V4_V3, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x3 }, // 3953
  { IMAGE_SAMPLE_C_CD_CL_V4_V4, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x4 }, // 3954
  { IMAGE_SAMPLE_C_CD_CL_V4_V5, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x5 }, // 3955
  { IMAGE_SAMPLE_C_CD_CL_V4_V6, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x6 }, // 3956
  { IMAGE_SAMPLE_C_CD_CL_V4_V7, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x7 }, // 3957
  { IMAGE_SAMPLE_C_CD_CL_V4_V8, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x8 }, // 3958
  { IMAGE_SAMPLE_C_CD_CL_V4_V16, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x10 }, // 3959
  { IMAGE_SAMPLE_C_CD_CL_V5_V3, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0x3 }, // 3960
  { IMAGE_SAMPLE_C_CD_CL_V5_V4, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0x4 }, // 3961
  { IMAGE_SAMPLE_C_CD_CL_V5_V5, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0x5 }, // 3962
  { IMAGE_SAMPLE_C_CD_CL_V5_V6, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0x6 }, // 3963
  { IMAGE_SAMPLE_C_CD_CL_V5_V7, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0x7 }, // 3964
  { IMAGE_SAMPLE_C_CD_CL_V5_V8, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0x8 }, // 3965
  { IMAGE_SAMPLE_C_CD_CL_V5_V16, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0x10 }, // 3966
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V3_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x3 }, // 3967
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x4 }, // 3968
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x5 }, // 3969
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x6 }, // 3970
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x7 }, // 3971
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x8 }, // 3972
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V16_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x10 }, // 3973
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V3_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x3 }, // 3974
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x4 }, // 3975
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x5 }, // 3976
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x6 }, // 3977
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x7 }, // 3978
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x8 }, // 3979
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V16_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x10 }, // 3980
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V3_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x3 }, // 3981
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x4 }, // 3982
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x5 }, // 3983
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x6 }, // 3984
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x7 }, // 3985
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x8 }, // 3986
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V16_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x10 }, // 3987
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V3_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x3 }, // 3988
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x4 }, // 3989
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x5 }, // 3990
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x6 }, // 3991
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x7 }, // 3992
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x8 }, // 3993
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V16_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x10 }, // 3994
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V3_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x3 }, // 3995
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x4 }, // 3996
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x5 }, // 3997
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x6 }, // 3998
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x7 }, // 3999
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x8 }, // 4000
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V16_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x10 }, // 4001
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x3 }, // 4002
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x4 }, // 4003
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x5 }, // 4004
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x6 }, // 4005
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x7 }, // 4006
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x8 }, // 4007
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x9 }, // 4008
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0xA }, // 4009
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0xB }, // 4010
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x3 }, // 4011
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x4 }, // 4012
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x5 }, // 4013
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x6 }, // 4014
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x7 }, // 4015
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x8 }, // 4016
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x9 }, // 4017
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0xA }, // 4018
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0xB }, // 4019
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x3 }, // 4020
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x4 }, // 4021
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x5 }, // 4022
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x6 }, // 4023
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x7 }, // 4024
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x8 }, // 4025
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x9 }, // 4026
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0xA }, // 4027
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0xB }, // 4028
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x3 }, // 4029
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x4 }, // 4030
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x5 }, // 4031
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x6 }, // 4032
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x7 }, // 4033
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x8 }, // 4034
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x9 }, // 4035
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0xA }, // 4036
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0xB }, // 4037
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x3 }, // 4038
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x4 }, // 4039
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x5 }, // 4040
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x6 }, // 4041
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x7 }, // 4042
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x8 }, // 4043
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x9 }, // 4044
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0xA }, // 4045
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0xB }, // 4046
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V3, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x1, 0x3 }, // 4047
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V4, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x1, 0x4 }, // 4048
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V5, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x1, 0x5 }, // 4049
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V6, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x1, 0x6 }, // 4050
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V7, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x1, 0x7 }, // 4051
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V8, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x1, 0x8 }, // 4052
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V16, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x1, 0x10 }, // 4053
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V3, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x2, 0x3 }, // 4054
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V4, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x2, 0x4 }, // 4055
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V5, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x2, 0x5 }, // 4056
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V6, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x2, 0x6 }, // 4057
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V7, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x2, 0x7 }, // 4058
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V8, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x2, 0x8 }, // 4059
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V16, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x2, 0x10 }, // 4060
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V3, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x3, 0x3 }, // 4061
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V4, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x3, 0x4 }, // 4062
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V5, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x3, 0x5 }, // 4063
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V6, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x3, 0x6 }, // 4064
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V7, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x3, 0x7 }, // 4065
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V8, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x3, 0x8 }, // 4066
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V16, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x3, 0x10 }, // 4067
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V3, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x4, 0x3 }, // 4068
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V4, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x4, 0x4 }, // 4069
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V5, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x4, 0x5 }, // 4070
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V6, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x4, 0x6 }, // 4071
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V7, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x4, 0x7 }, // 4072
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V8, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x4, 0x8 }, // 4073
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V16, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x4, 0x10 }, // 4074
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V3, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x5, 0x3 }, // 4075
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V4, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x5, 0x4 }, // 4076
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V5, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x5, 0x5 }, // 4077
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V6, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x5, 0x6 }, // 4078
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V7, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x5, 0x7 }, // 4079
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V8, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x5, 0x8 }, // 4080
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V16, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x5, 0x10 }, // 4081
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x4 }, // 4082
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x5 }, // 4083
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x6 }, // 4084
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x7 }, // 4085
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x8 }, // 4086
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V16_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x10 }, // 4087
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 4088
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 4089
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x6 }, // 4090
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x7 }, // 4091
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 4092
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V16_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x10 }, // 4093
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x4 }, // 4094
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x5 }, // 4095
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x6 }, // 4096
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x7 }, // 4097
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x8 }, // 4098
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V16_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x10 }, // 4099
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 4100
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 4101
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x6 }, // 4102
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x7 }, // 4103
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 4104
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V16_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x10 }, // 4105
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 4106
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 4107
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x6 }, // 4108
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x7 }, // 4109
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 4110
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V16_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x10 }, // 4111
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x4 }, // 4112
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x5 }, // 4113
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x6 }, // 4114
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x7 }, // 4115
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x8 }, // 4116
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x9 }, // 4117
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0xA }, // 4118
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0xB }, // 4119
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V12_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0xC }, // 4120
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 4121
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 4122
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x6 }, // 4123
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x7 }, // 4124
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x8 }, // 4125
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x9 }, // 4126
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0xA }, // 4127
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0xB }, // 4128
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V12_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0xC }, // 4129
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x4 }, // 4130
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x5 }, // 4131
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x6 }, // 4132
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x7 }, // 4133
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x8 }, // 4134
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x9 }, // 4135
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0xA }, // 4136
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0xB }, // 4137
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V12_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0xC }, // 4138
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 4139
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 4140
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x6 }, // 4141
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x7 }, // 4142
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x8 }, // 4143
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x9 }, // 4144
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0xA }, // 4145
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0xB }, // 4146
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V12_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0xC }, // 4147
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 4148
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 4149
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x6 }, // 4150
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x7 }, // 4151
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x8 }, // 4152
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x9 }, // 4153
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0xA }, // 4154
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0xB }, // 4155
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V12_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0xC }, // 4156
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V4, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0x4 }, // 4157
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V5, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0x5 }, // 4158
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V6, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0x6 }, // 4159
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V7, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0x7 }, // 4160
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V8, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0x8 }, // 4161
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V16, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0x10 }, // 4162
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V4, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 4163
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V5, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0x5 }, // 4164
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V6, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0x6 }, // 4165
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V7, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0x7 }, // 4166
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V8, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 4167
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V16, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0x10 }, // 4168
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V4, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0x4 }, // 4169
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V5, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0x5 }, // 4170
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V6, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0x6 }, // 4171
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V7, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0x7 }, // 4172
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V8, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0x8 }, // 4173
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V16, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0x10 }, // 4174
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V4, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 4175
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V5, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0x5 }, // 4176
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V6, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0x6 }, // 4177
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V7, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0x7 }, // 4178
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V8, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 4179
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V16, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0x10 }, // 4180
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V4, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0x4 }, // 4181
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V5, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0x5 }, // 4182
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V6, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0x6 }, // 4183
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V7, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0x7 }, // 4184
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V8, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0x8 }, // 4185
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V16, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0x10 }, // 4186
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x4 }, // 4187
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x5 }, // 4188
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x6 }, // 4189
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x7 }, // 4190
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x8 }, // 4191
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V16_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x10 }, // 4192
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x4 }, // 4193
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x5 }, // 4194
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x6 }, // 4195
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x7 }, // 4196
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x8 }, // 4197
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V16_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x10 }, // 4198
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x4 }, // 4199
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x5 }, // 4200
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x6 }, // 4201
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x7 }, // 4202
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x8 }, // 4203
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V16_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x10 }, // 4204
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x4 }, // 4205
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x5 }, // 4206
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x6 }, // 4207
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x7 }, // 4208
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x8 }, // 4209
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V16_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x10 }, // 4210
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x4 }, // 4211
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x5 }, // 4212
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x6 }, // 4213
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x7 }, // 4214
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x8 }, // 4215
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V16_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x10 }, // 4216
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x4 }, // 4217
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x5 }, // 4218
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x6 }, // 4219
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x7 }, // 4220
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x8 }, // 4221
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x9 }, // 4222
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0xA }, // 4223
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0xB }, // 4224
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V12_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0xC }, // 4225
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x4 }, // 4226
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x5 }, // 4227
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x6 }, // 4228
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x7 }, // 4229
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x8 }, // 4230
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x9 }, // 4231
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0xA }, // 4232
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0xB }, // 4233
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V12_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0xC }, // 4234
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x4 }, // 4235
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x5 }, // 4236
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x6 }, // 4237
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x7 }, // 4238
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x8 }, // 4239
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x9 }, // 4240
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0xA }, // 4241
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0xB }, // 4242
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V12_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0xC }, // 4243
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x4 }, // 4244
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x5 }, // 4245
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x6 }, // 4246
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x7 }, // 4247
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x8 }, // 4248
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x9 }, // 4249
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0xA }, // 4250
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0xB }, // 4251
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V12_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0xC }, // 4252
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x4 }, // 4253
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x5 }, // 4254
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x6 }, // 4255
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x7 }, // 4256
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x8 }, // 4257
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x9 }, // 4258
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0xA }, // 4259
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0xB }, // 4260
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V12_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0xC }, // 4261
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V4, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x4 }, // 4262
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V5, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x5 }, // 4263
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V6, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x6 }, // 4264
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V7, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x7 }, // 4265
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V8, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x8 }, // 4266
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V16, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x10 }, // 4267
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V4, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x4 }, // 4268
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V5, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x5 }, // 4269
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V6, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x6 }, // 4270
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V7, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x7 }, // 4271
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V8, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x8 }, // 4272
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V16, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x10 }, // 4273
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V4, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x4 }, // 4274
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V5, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x5 }, // 4275
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V6, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x6 }, // 4276
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V7, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x7 }, // 4277
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V8, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x8 }, // 4278
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V16, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x10 }, // 4279
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V4, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x4 }, // 4280
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V5, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x5 }, // 4281
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V6, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x6 }, // 4282
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V7, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x7 }, // 4283
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V8, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x8 }, // 4284
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V16, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x10 }, // 4285
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V4, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x4 }, // 4286
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V5, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x5 }, // 4287
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V6, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x6 }, // 4288
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V7, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x7 }, // 4289
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V8, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x8 }, // 4290
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V16, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x10 }, // 4291
  { IMAGE_SAMPLE_C_CD_G16_V1_V3_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x1, 0x3 }, // 4292
  { IMAGE_SAMPLE_C_CD_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x1, 0x4 }, // 4293
  { IMAGE_SAMPLE_C_CD_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x1, 0x5 }, // 4294
  { IMAGE_SAMPLE_C_CD_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x1, 0x6 }, // 4295
  { IMAGE_SAMPLE_C_CD_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x1, 0x7 }, // 4296
  { IMAGE_SAMPLE_C_CD_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x1, 0x8 }, // 4297
  { IMAGE_SAMPLE_C_CD_G16_V1_V16_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x1, 0x10 }, // 4298
  { IMAGE_SAMPLE_C_CD_G16_V2_V3_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x2, 0x3 }, // 4299
  { IMAGE_SAMPLE_C_CD_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x2, 0x4 }, // 4300
  { IMAGE_SAMPLE_C_CD_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x2, 0x5 }, // 4301
  { IMAGE_SAMPLE_C_CD_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x2, 0x6 }, // 4302
  { IMAGE_SAMPLE_C_CD_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x2, 0x7 }, // 4303
  { IMAGE_SAMPLE_C_CD_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x2, 0x8 }, // 4304
  { IMAGE_SAMPLE_C_CD_G16_V2_V16_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x2, 0x10 }, // 4305
  { IMAGE_SAMPLE_C_CD_G16_V3_V3_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x3, 0x3 }, // 4306
  { IMAGE_SAMPLE_C_CD_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x3, 0x4 }, // 4307
  { IMAGE_SAMPLE_C_CD_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x3, 0x5 }, // 4308
  { IMAGE_SAMPLE_C_CD_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x3, 0x6 }, // 4309
  { IMAGE_SAMPLE_C_CD_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x3, 0x7 }, // 4310
  { IMAGE_SAMPLE_C_CD_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x3, 0x8 }, // 4311
  { IMAGE_SAMPLE_C_CD_G16_V3_V16_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x3, 0x10 }, // 4312
  { IMAGE_SAMPLE_C_CD_G16_V4_V3_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x4, 0x3 }, // 4313
  { IMAGE_SAMPLE_C_CD_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x4, 0x4 }, // 4314
  { IMAGE_SAMPLE_C_CD_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x4, 0x5 }, // 4315
  { IMAGE_SAMPLE_C_CD_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x4, 0x6 }, // 4316
  { IMAGE_SAMPLE_C_CD_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x4, 0x7 }, // 4317
  { IMAGE_SAMPLE_C_CD_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x4, 0x8 }, // 4318
  { IMAGE_SAMPLE_C_CD_G16_V4_V16_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x4, 0x10 }, // 4319
  { IMAGE_SAMPLE_C_CD_G16_V5_V3_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x5, 0x3 }, // 4320
  { IMAGE_SAMPLE_C_CD_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x5, 0x4 }, // 4321
  { IMAGE_SAMPLE_C_CD_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x5, 0x5 }, // 4322
  { IMAGE_SAMPLE_C_CD_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x5, 0x6 }, // 4323
  { IMAGE_SAMPLE_C_CD_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x5, 0x7 }, // 4324
  { IMAGE_SAMPLE_C_CD_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x5, 0x8 }, // 4325
  { IMAGE_SAMPLE_C_CD_G16_V5_V16_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x5, 0x10 }, // 4326
  { IMAGE_SAMPLE_C_CD_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x1, 0x3 }, // 4327
  { IMAGE_SAMPLE_C_CD_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x1, 0x4 }, // 4328
  { IMAGE_SAMPLE_C_CD_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x1, 0x5 }, // 4329
  { IMAGE_SAMPLE_C_CD_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x1, 0x6 }, // 4330
  { IMAGE_SAMPLE_C_CD_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x1, 0x7 }, // 4331
  { IMAGE_SAMPLE_C_CD_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x1, 0x8 }, // 4332
  { IMAGE_SAMPLE_C_CD_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x1, 0x9 }, // 4333
  { IMAGE_SAMPLE_C_CD_G16_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x1, 0xA }, // 4334
  { IMAGE_SAMPLE_C_CD_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x2, 0x3 }, // 4335
  { IMAGE_SAMPLE_C_CD_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x2, 0x4 }, // 4336
  { IMAGE_SAMPLE_C_CD_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x2, 0x5 }, // 4337
  { IMAGE_SAMPLE_C_CD_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x2, 0x6 }, // 4338
  { IMAGE_SAMPLE_C_CD_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x2, 0x7 }, // 4339
  { IMAGE_SAMPLE_C_CD_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x2, 0x8 }, // 4340
  { IMAGE_SAMPLE_C_CD_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x2, 0x9 }, // 4341
  { IMAGE_SAMPLE_C_CD_G16_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x2, 0xA }, // 4342
  { IMAGE_SAMPLE_C_CD_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x3, 0x3 }, // 4343
  { IMAGE_SAMPLE_C_CD_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x3, 0x4 }, // 4344
  { IMAGE_SAMPLE_C_CD_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x3, 0x5 }, // 4345
  { IMAGE_SAMPLE_C_CD_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x3, 0x6 }, // 4346
  { IMAGE_SAMPLE_C_CD_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x3, 0x7 }, // 4347
  { IMAGE_SAMPLE_C_CD_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x3, 0x8 }, // 4348
  { IMAGE_SAMPLE_C_CD_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x3, 0x9 }, // 4349
  { IMAGE_SAMPLE_C_CD_G16_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x3, 0xA }, // 4350
  { IMAGE_SAMPLE_C_CD_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x4, 0x3 }, // 4351
  { IMAGE_SAMPLE_C_CD_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x4, 0x4 }, // 4352
  { IMAGE_SAMPLE_C_CD_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x4, 0x5 }, // 4353
  { IMAGE_SAMPLE_C_CD_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x4, 0x6 }, // 4354
  { IMAGE_SAMPLE_C_CD_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x4, 0x7 }, // 4355
  { IMAGE_SAMPLE_C_CD_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x4, 0x8 }, // 4356
  { IMAGE_SAMPLE_C_CD_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x4, 0x9 }, // 4357
  { IMAGE_SAMPLE_C_CD_G16_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x4, 0xA }, // 4358
  { IMAGE_SAMPLE_C_CD_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x5, 0x3 }, // 4359
  { IMAGE_SAMPLE_C_CD_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x5, 0x4 }, // 4360
  { IMAGE_SAMPLE_C_CD_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x5, 0x5 }, // 4361
  { IMAGE_SAMPLE_C_CD_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x5, 0x6 }, // 4362
  { IMAGE_SAMPLE_C_CD_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x5, 0x7 }, // 4363
  { IMAGE_SAMPLE_C_CD_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x5, 0x8 }, // 4364
  { IMAGE_SAMPLE_C_CD_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x5, 0x9 }, // 4365
  { IMAGE_SAMPLE_C_CD_G16_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x5, 0xA }, // 4366
  { IMAGE_SAMPLE_C_CD_G16_V1_V3, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x1, 0x3 }, // 4367
  { IMAGE_SAMPLE_C_CD_G16_V1_V4, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x1, 0x4 }, // 4368
  { IMAGE_SAMPLE_C_CD_G16_V1_V5, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x1, 0x5 }, // 4369
  { IMAGE_SAMPLE_C_CD_G16_V1_V6, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x1, 0x6 }, // 4370
  { IMAGE_SAMPLE_C_CD_G16_V1_V7, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x1, 0x7 }, // 4371
  { IMAGE_SAMPLE_C_CD_G16_V1_V8, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x1, 0x8 }, // 4372
  { IMAGE_SAMPLE_C_CD_G16_V1_V16, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x1, 0x10 }, // 4373
  { IMAGE_SAMPLE_C_CD_G16_V2_V3, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x2, 0x3 }, // 4374
  { IMAGE_SAMPLE_C_CD_G16_V2_V4, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x2, 0x4 }, // 4375
  { IMAGE_SAMPLE_C_CD_G16_V2_V5, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x2, 0x5 }, // 4376
  { IMAGE_SAMPLE_C_CD_G16_V2_V6, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x2, 0x6 }, // 4377
  { IMAGE_SAMPLE_C_CD_G16_V2_V7, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x2, 0x7 }, // 4378
  { IMAGE_SAMPLE_C_CD_G16_V2_V8, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x2, 0x8 }, // 4379
  { IMAGE_SAMPLE_C_CD_G16_V2_V16, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x2, 0x10 }, // 4380
  { IMAGE_SAMPLE_C_CD_G16_V3_V3, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x3, 0x3 }, // 4381
  { IMAGE_SAMPLE_C_CD_G16_V3_V4, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x3, 0x4 }, // 4382
  { IMAGE_SAMPLE_C_CD_G16_V3_V5, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x3, 0x5 }, // 4383
  { IMAGE_SAMPLE_C_CD_G16_V3_V6, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x3, 0x6 }, // 4384
  { IMAGE_SAMPLE_C_CD_G16_V3_V7, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x3, 0x7 }, // 4385
  { IMAGE_SAMPLE_C_CD_G16_V3_V8, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x3, 0x8 }, // 4386
  { IMAGE_SAMPLE_C_CD_G16_V3_V16, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x3, 0x10 }, // 4387
  { IMAGE_SAMPLE_C_CD_G16_V4_V3, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x4, 0x3 }, // 4388
  { IMAGE_SAMPLE_C_CD_G16_V4_V4, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x4, 0x4 }, // 4389
  { IMAGE_SAMPLE_C_CD_G16_V4_V5, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x4, 0x5 }, // 4390
  { IMAGE_SAMPLE_C_CD_G16_V4_V6, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x4, 0x6 }, // 4391
  { IMAGE_SAMPLE_C_CD_G16_V4_V7, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x4, 0x7 }, // 4392
  { IMAGE_SAMPLE_C_CD_G16_V4_V8, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x4, 0x8 }, // 4393
  { IMAGE_SAMPLE_C_CD_G16_V4_V16, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x4, 0x10 }, // 4394
  { IMAGE_SAMPLE_C_CD_G16_V5_V3, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x5, 0x3 }, // 4395
  { IMAGE_SAMPLE_C_CD_G16_V5_V4, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x5, 0x4 }, // 4396
  { IMAGE_SAMPLE_C_CD_G16_V5_V5, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x5, 0x5 }, // 4397
  { IMAGE_SAMPLE_C_CD_G16_V5_V6, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x5, 0x6 }, // 4398
  { IMAGE_SAMPLE_C_CD_G16_V5_V7, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x5, 0x7 }, // 4399
  { IMAGE_SAMPLE_C_CD_G16_V5_V8, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x5, 0x8 }, // 4400
  { IMAGE_SAMPLE_C_CD_G16_V5_V16, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x5, 0x10 }, // 4401
  { IMAGE_SAMPLE_C_CD_O_V1_V4_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0x4 }, // 4402
  { IMAGE_SAMPLE_C_CD_O_V1_V5_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0x5 }, // 4403
  { IMAGE_SAMPLE_C_CD_O_V1_V6_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0x6 }, // 4404
  { IMAGE_SAMPLE_C_CD_O_V1_V7_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0x7 }, // 4405
  { IMAGE_SAMPLE_C_CD_O_V1_V8_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0x8 }, // 4406
  { IMAGE_SAMPLE_C_CD_O_V1_V16_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0x10 }, // 4407
  { IMAGE_SAMPLE_C_CD_O_V2_V4_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 4408
  { IMAGE_SAMPLE_C_CD_O_V2_V5_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 4409
  { IMAGE_SAMPLE_C_CD_O_V2_V6_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0x6 }, // 4410
  { IMAGE_SAMPLE_C_CD_O_V2_V7_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0x7 }, // 4411
  { IMAGE_SAMPLE_C_CD_O_V2_V8_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 4412
  { IMAGE_SAMPLE_C_CD_O_V2_V16_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0x10 }, // 4413
  { IMAGE_SAMPLE_C_CD_O_V3_V4_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0x4 }, // 4414
  { IMAGE_SAMPLE_C_CD_O_V3_V5_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0x5 }, // 4415
  { IMAGE_SAMPLE_C_CD_O_V3_V6_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0x6 }, // 4416
  { IMAGE_SAMPLE_C_CD_O_V3_V7_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0x7 }, // 4417
  { IMAGE_SAMPLE_C_CD_O_V3_V8_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0x8 }, // 4418
  { IMAGE_SAMPLE_C_CD_O_V3_V16_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0x10 }, // 4419
  { IMAGE_SAMPLE_C_CD_O_V4_V4_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 4420
  { IMAGE_SAMPLE_C_CD_O_V4_V5_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 4421
  { IMAGE_SAMPLE_C_CD_O_V4_V6_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0x6 }, // 4422
  { IMAGE_SAMPLE_C_CD_O_V4_V7_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0x7 }, // 4423
  { IMAGE_SAMPLE_C_CD_O_V4_V8_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 4424
  { IMAGE_SAMPLE_C_CD_O_V4_V16_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0x10 }, // 4425
  { IMAGE_SAMPLE_C_CD_O_V5_V4_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 4426
  { IMAGE_SAMPLE_C_CD_O_V5_V5_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 4427
  { IMAGE_SAMPLE_C_CD_O_V5_V6_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0x6 }, // 4428
  { IMAGE_SAMPLE_C_CD_O_V5_V7_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0x7 }, // 4429
  { IMAGE_SAMPLE_C_CD_O_V5_V8_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 4430
  { IMAGE_SAMPLE_C_CD_O_V5_V16_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0x10 }, // 4431
  { IMAGE_SAMPLE_C_CD_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0x4 }, // 4432
  { IMAGE_SAMPLE_C_CD_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0x5 }, // 4433
  { IMAGE_SAMPLE_C_CD_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0x6 }, // 4434
  { IMAGE_SAMPLE_C_CD_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0x7 }, // 4435
  { IMAGE_SAMPLE_C_CD_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0x8 }, // 4436
  { IMAGE_SAMPLE_C_CD_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0x9 }, // 4437
  { IMAGE_SAMPLE_C_CD_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0xA }, // 4438
  { IMAGE_SAMPLE_C_CD_O_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0xB }, // 4439
  { IMAGE_SAMPLE_C_CD_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 4440
  { IMAGE_SAMPLE_C_CD_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 4441
  { IMAGE_SAMPLE_C_CD_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0x6 }, // 4442
  { IMAGE_SAMPLE_C_CD_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0x7 }, // 4443
  { IMAGE_SAMPLE_C_CD_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0x8 }, // 4444
  { IMAGE_SAMPLE_C_CD_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0x9 }, // 4445
  { IMAGE_SAMPLE_C_CD_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0xA }, // 4446
  { IMAGE_SAMPLE_C_CD_O_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0xB }, // 4447
  { IMAGE_SAMPLE_C_CD_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0x4 }, // 4448
  { IMAGE_SAMPLE_C_CD_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0x5 }, // 4449
  { IMAGE_SAMPLE_C_CD_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0x6 }, // 4450
  { IMAGE_SAMPLE_C_CD_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0x7 }, // 4451
  { IMAGE_SAMPLE_C_CD_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0x8 }, // 4452
  { IMAGE_SAMPLE_C_CD_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0x9 }, // 4453
  { IMAGE_SAMPLE_C_CD_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0xA }, // 4454
  { IMAGE_SAMPLE_C_CD_O_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0xB }, // 4455
  { IMAGE_SAMPLE_C_CD_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 4456
  { IMAGE_SAMPLE_C_CD_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 4457
  { IMAGE_SAMPLE_C_CD_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0x6 }, // 4458
  { IMAGE_SAMPLE_C_CD_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0x7 }, // 4459
  { IMAGE_SAMPLE_C_CD_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0x8 }, // 4460
  { IMAGE_SAMPLE_C_CD_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0x9 }, // 4461
  { IMAGE_SAMPLE_C_CD_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0xA }, // 4462
  { IMAGE_SAMPLE_C_CD_O_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0xB }, // 4463
  { IMAGE_SAMPLE_C_CD_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 4464
  { IMAGE_SAMPLE_C_CD_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 4465
  { IMAGE_SAMPLE_C_CD_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0x6 }, // 4466
  { IMAGE_SAMPLE_C_CD_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0x7 }, // 4467
  { IMAGE_SAMPLE_C_CD_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0x8 }, // 4468
  { IMAGE_SAMPLE_C_CD_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0x9 }, // 4469
  { IMAGE_SAMPLE_C_CD_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0xA }, // 4470
  { IMAGE_SAMPLE_C_CD_O_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0xB }, // 4471
  { IMAGE_SAMPLE_C_CD_O_V1_V4, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0x4 }, // 4472
  { IMAGE_SAMPLE_C_CD_O_V1_V5, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0x5 }, // 4473
  { IMAGE_SAMPLE_C_CD_O_V1_V6, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0x6 }, // 4474
  { IMAGE_SAMPLE_C_CD_O_V1_V7, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0x7 }, // 4475
  { IMAGE_SAMPLE_C_CD_O_V1_V8, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0x8 }, // 4476
  { IMAGE_SAMPLE_C_CD_O_V1_V16, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0x10 }, // 4477
  { IMAGE_SAMPLE_C_CD_O_V2_V4, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0x4 }, // 4478
  { IMAGE_SAMPLE_C_CD_O_V2_V5, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0x5 }, // 4479
  { IMAGE_SAMPLE_C_CD_O_V2_V6, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0x6 }, // 4480
  { IMAGE_SAMPLE_C_CD_O_V2_V7, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0x7 }, // 4481
  { IMAGE_SAMPLE_C_CD_O_V2_V8, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0x8 }, // 4482
  { IMAGE_SAMPLE_C_CD_O_V2_V16, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0x10 }, // 4483
  { IMAGE_SAMPLE_C_CD_O_V3_V4, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0x4 }, // 4484
  { IMAGE_SAMPLE_C_CD_O_V3_V5, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0x5 }, // 4485
  { IMAGE_SAMPLE_C_CD_O_V3_V6, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0x6 }, // 4486
  { IMAGE_SAMPLE_C_CD_O_V3_V7, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0x7 }, // 4487
  { IMAGE_SAMPLE_C_CD_O_V3_V8, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0x8 }, // 4488
  { IMAGE_SAMPLE_C_CD_O_V3_V16, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0x10 }, // 4489
  { IMAGE_SAMPLE_C_CD_O_V4_V4, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0x4 }, // 4490
  { IMAGE_SAMPLE_C_CD_O_V4_V5, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0x5 }, // 4491
  { IMAGE_SAMPLE_C_CD_O_V4_V6, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0x6 }, // 4492
  { IMAGE_SAMPLE_C_CD_O_V4_V7, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0x7 }, // 4493
  { IMAGE_SAMPLE_C_CD_O_V4_V8, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0x8 }, // 4494
  { IMAGE_SAMPLE_C_CD_O_V4_V16, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0x10 }, // 4495
  { IMAGE_SAMPLE_C_CD_O_V5_V4, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0x4 }, // 4496
  { IMAGE_SAMPLE_C_CD_O_V5_V5, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0x5 }, // 4497
  { IMAGE_SAMPLE_C_CD_O_V5_V6, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0x6 }, // 4498
  { IMAGE_SAMPLE_C_CD_O_V5_V7, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0x7 }, // 4499
  { IMAGE_SAMPLE_C_CD_O_V5_V8, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0x8 }, // 4500
  { IMAGE_SAMPLE_C_CD_O_V5_V16, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0x10 }, // 4501
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x4 }, // 4502
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x5 }, // 4503
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x6 }, // 4504
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x7 }, // 4505
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x8 }, // 4506
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V16_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x10 }, // 4507
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x4 }, // 4508
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x5 }, // 4509
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x6 }, // 4510
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x7 }, // 4511
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x8 }, // 4512
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V16_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x10 }, // 4513
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x4 }, // 4514
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x5 }, // 4515
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x6 }, // 4516
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x7 }, // 4517
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x8 }, // 4518
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V16_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x10 }, // 4519
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x4 }, // 4520
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x5 }, // 4521
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x6 }, // 4522
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x7 }, // 4523
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x8 }, // 4524
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V16_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x10 }, // 4525
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x4 }, // 4526
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x5 }, // 4527
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x6 }, // 4528
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x7 }, // 4529
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x8 }, // 4530
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V16_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x10 }, // 4531
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x4 }, // 4532
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x5 }, // 4533
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x6 }, // 4534
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x7 }, // 4535
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x8 }, // 4536
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x9 }, // 4537
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0xA }, // 4538
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0xB }, // 4539
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x4 }, // 4540
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x5 }, // 4541
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x6 }, // 4542
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x7 }, // 4543
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x8 }, // 4544
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x9 }, // 4545
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0xA }, // 4546
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0xB }, // 4547
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x4 }, // 4548
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x5 }, // 4549
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x6 }, // 4550
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x7 }, // 4551
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x8 }, // 4552
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x9 }, // 4553
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0xA }, // 4554
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0xB }, // 4555
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x4 }, // 4556
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x5 }, // 4557
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x6 }, // 4558
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x7 }, // 4559
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x8 }, // 4560
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x9 }, // 4561
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0xA }, // 4562
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0xB }, // 4563
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x4 }, // 4564
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x5 }, // 4565
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x6 }, // 4566
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x7 }, // 4567
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x8 }, // 4568
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x9 }, // 4569
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0xA }, // 4570
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0xB }, // 4571
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V4, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x1, 0x4 }, // 4572
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V5, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x1, 0x5 }, // 4573
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V6, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x1, 0x6 }, // 4574
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V7, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x1, 0x7 }, // 4575
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V8, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x1, 0x8 }, // 4576
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V16, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x1, 0x10 }, // 4577
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V4, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x2, 0x4 }, // 4578
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V5, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x2, 0x5 }, // 4579
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V6, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x2, 0x6 }, // 4580
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V7, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x2, 0x7 }, // 4581
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V8, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x2, 0x8 }, // 4582
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V16, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x2, 0x10 }, // 4583
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V4, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x3, 0x4 }, // 4584
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V5, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x3, 0x5 }, // 4585
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V6, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x3, 0x6 }, // 4586
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V7, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x3, 0x7 }, // 4587
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V8, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x3, 0x8 }, // 4588
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V16, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x3, 0x10 }, // 4589
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V4, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x4, 0x4 }, // 4590
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V5, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x4, 0x5 }, // 4591
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V6, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x4, 0x6 }, // 4592
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V7, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x4, 0x7 }, // 4593
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V8, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x4, 0x8 }, // 4594
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V16, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x4, 0x10 }, // 4595
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V4, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x5, 0x4 }, // 4596
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V5, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x5, 0x5 }, // 4597
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V6, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x5, 0x6 }, // 4598
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V7, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x5, 0x7 }, // 4599
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V8, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x5, 0x8 }, // 4600
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V16, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x5, 0x10 }, // 4601
  { IMAGE_SAMPLE_C_CL_V1_V2_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x1, 0x2 }, // 4602
  { IMAGE_SAMPLE_C_CL_V1_V3_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x1, 0x3 }, // 4603
  { IMAGE_SAMPLE_C_CL_V1_V4_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x1, 0x4 }, // 4604
  { IMAGE_SAMPLE_C_CL_V1_V5_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x1, 0x5 }, // 4605
  { IMAGE_SAMPLE_C_CL_V1_V8_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x1, 0x8 }, // 4606
  { IMAGE_SAMPLE_C_CL_V2_V2_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x2, 0x2 }, // 4607
  { IMAGE_SAMPLE_C_CL_V2_V3_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x2, 0x3 }, // 4608
  { IMAGE_SAMPLE_C_CL_V2_V4_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x2, 0x4 }, // 4609
  { IMAGE_SAMPLE_C_CL_V2_V5_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x2, 0x5 }, // 4610
  { IMAGE_SAMPLE_C_CL_V2_V8_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x2, 0x8 }, // 4611
  { IMAGE_SAMPLE_C_CL_V3_V2_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x3, 0x2 }, // 4612
  { IMAGE_SAMPLE_C_CL_V3_V3_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x3, 0x3 }, // 4613
  { IMAGE_SAMPLE_C_CL_V3_V4_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x3, 0x4 }, // 4614
  { IMAGE_SAMPLE_C_CL_V3_V5_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x3, 0x5 }, // 4615
  { IMAGE_SAMPLE_C_CL_V3_V8_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x3, 0x8 }, // 4616
  { IMAGE_SAMPLE_C_CL_V4_V2_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x4, 0x2 }, // 4617
  { IMAGE_SAMPLE_C_CL_V4_V3_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x4, 0x3 }, // 4618
  { IMAGE_SAMPLE_C_CL_V4_V4_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x4, 0x4 }, // 4619
  { IMAGE_SAMPLE_C_CL_V4_V5_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x4, 0x5 }, // 4620
  { IMAGE_SAMPLE_C_CL_V4_V8_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x4, 0x8 }, // 4621
  { IMAGE_SAMPLE_C_CL_V5_V2_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x5, 0x2 }, // 4622
  { IMAGE_SAMPLE_C_CL_V5_V3_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x5, 0x3 }, // 4623
  { IMAGE_SAMPLE_C_CL_V5_V4_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x5, 0x4 }, // 4624
  { IMAGE_SAMPLE_C_CL_V5_V5_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x5, 0x5 }, // 4625
  { IMAGE_SAMPLE_C_CL_V5_V8_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x5, 0x8 }, // 4626
  { IMAGE_SAMPLE_C_CL_V1_V2_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x1, 0x2 }, // 4627
  { IMAGE_SAMPLE_C_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x1, 0x3 }, // 4628
  { IMAGE_SAMPLE_C_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x1, 0x4 }, // 4629
  { IMAGE_SAMPLE_C_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x1, 0x5 }, // 4630
  { IMAGE_SAMPLE_C_CL_V2_V2_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x2, 0x2 }, // 4631
  { IMAGE_SAMPLE_C_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x2, 0x3 }, // 4632
  { IMAGE_SAMPLE_C_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x2, 0x4 }, // 4633
  { IMAGE_SAMPLE_C_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x2, 0x5 }, // 4634
  { IMAGE_SAMPLE_C_CL_V3_V2_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x3, 0x2 }, // 4635
  { IMAGE_SAMPLE_C_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x3, 0x3 }, // 4636
  { IMAGE_SAMPLE_C_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x3, 0x4 }, // 4637
  { IMAGE_SAMPLE_C_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x3, 0x5 }, // 4638
  { IMAGE_SAMPLE_C_CL_V4_V2_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x4, 0x2 }, // 4639
  { IMAGE_SAMPLE_C_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x4, 0x3 }, // 4640
  { IMAGE_SAMPLE_C_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x4, 0x4 }, // 4641
  { IMAGE_SAMPLE_C_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x4, 0x5 }, // 4642
  { IMAGE_SAMPLE_C_CL_V5_V2_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x5, 0x2 }, // 4643
  { IMAGE_SAMPLE_C_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x5, 0x3 }, // 4644
  { IMAGE_SAMPLE_C_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x5, 0x4 }, // 4645
  { IMAGE_SAMPLE_C_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x5, 0x5 }, // 4646
  { IMAGE_SAMPLE_C_CL_V1_V2, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x1, 0x2 }, // 4647
  { IMAGE_SAMPLE_C_CL_V1_V3, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x1, 0x3 }, // 4648
  { IMAGE_SAMPLE_C_CL_V1_V4, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x1, 0x4 }, // 4649
  { IMAGE_SAMPLE_C_CL_V1_V5, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x1, 0x5 }, // 4650
  { IMAGE_SAMPLE_C_CL_V1_V8, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x1, 0x8 }, // 4651
  { IMAGE_SAMPLE_C_CL_V2_V2, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x2, 0x2 }, // 4652
  { IMAGE_SAMPLE_C_CL_V2_V3, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x2, 0x3 }, // 4653
  { IMAGE_SAMPLE_C_CL_V2_V4, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x2, 0x4 }, // 4654
  { IMAGE_SAMPLE_C_CL_V2_V5, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x2, 0x5 }, // 4655
  { IMAGE_SAMPLE_C_CL_V2_V8, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x2, 0x8 }, // 4656
  { IMAGE_SAMPLE_C_CL_V3_V2, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x3, 0x2 }, // 4657
  { IMAGE_SAMPLE_C_CL_V3_V3, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x3, 0x3 }, // 4658
  { IMAGE_SAMPLE_C_CL_V3_V4, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x3, 0x4 }, // 4659
  { IMAGE_SAMPLE_C_CL_V3_V5, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x3, 0x5 }, // 4660
  { IMAGE_SAMPLE_C_CL_V3_V8, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x3, 0x8 }, // 4661
  { IMAGE_SAMPLE_C_CL_V4_V2, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x4, 0x2 }, // 4662
  { IMAGE_SAMPLE_C_CL_V4_V3, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x4, 0x3 }, // 4663
  { IMAGE_SAMPLE_C_CL_V4_V4, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x4, 0x4 }, // 4664
  { IMAGE_SAMPLE_C_CL_V4_V5, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x4, 0x5 }, // 4665
  { IMAGE_SAMPLE_C_CL_V4_V8, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x4, 0x8 }, // 4666
  { IMAGE_SAMPLE_C_CL_V5_V2, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x5, 0x2 }, // 4667
  { IMAGE_SAMPLE_C_CL_V5_V3, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x5, 0x3 }, // 4668
  { IMAGE_SAMPLE_C_CL_V5_V4, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x5, 0x4 }, // 4669
  { IMAGE_SAMPLE_C_CL_V5_V5, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x5, 0x5 }, // 4670
  { IMAGE_SAMPLE_C_CL_V5_V8, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x5, 0x8 }, // 4671
  { IMAGE_SAMPLE_C_CL_O_V1_V3_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x1, 0x3 }, // 4672
  { IMAGE_SAMPLE_C_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x1, 0x4 }, // 4673
  { IMAGE_SAMPLE_C_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x1, 0x5 }, // 4674
  { IMAGE_SAMPLE_C_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x1, 0x6 }, // 4675
  { IMAGE_SAMPLE_C_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x1, 0x8 }, // 4676
  { IMAGE_SAMPLE_C_CL_O_V2_V3_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 4677
  { IMAGE_SAMPLE_C_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 4678
  { IMAGE_SAMPLE_C_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 4679
  { IMAGE_SAMPLE_C_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x2, 0x6 }, // 4680
  { IMAGE_SAMPLE_C_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 4681
  { IMAGE_SAMPLE_C_CL_O_V3_V3_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x3, 0x3 }, // 4682
  { IMAGE_SAMPLE_C_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x3, 0x4 }, // 4683
  { IMAGE_SAMPLE_C_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x3, 0x5 }, // 4684
  { IMAGE_SAMPLE_C_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x3, 0x6 }, // 4685
  { IMAGE_SAMPLE_C_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x3, 0x8 }, // 4686
  { IMAGE_SAMPLE_C_CL_O_V4_V3_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 4687
  { IMAGE_SAMPLE_C_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 4688
  { IMAGE_SAMPLE_C_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 4689
  { IMAGE_SAMPLE_C_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x4, 0x6 }, // 4690
  { IMAGE_SAMPLE_C_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 4691
  { IMAGE_SAMPLE_C_CL_O_V5_V3_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 4692
  { IMAGE_SAMPLE_C_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 4693
  { IMAGE_SAMPLE_C_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 4694
  { IMAGE_SAMPLE_C_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x5, 0x6 }, // 4695
  { IMAGE_SAMPLE_C_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 4696
  { IMAGE_SAMPLE_C_CL_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x1, 0x3 }, // 4697
  { IMAGE_SAMPLE_C_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x1, 0x4 }, // 4698
  { IMAGE_SAMPLE_C_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x1, 0x5 }, // 4699
  { IMAGE_SAMPLE_C_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x1, 0x6 }, // 4700
  { IMAGE_SAMPLE_C_CL_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 4701
  { IMAGE_SAMPLE_C_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 4702
  { IMAGE_SAMPLE_C_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 4703
  { IMAGE_SAMPLE_C_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x6 }, // 4704
  { IMAGE_SAMPLE_C_CL_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x3, 0x3 }, // 4705
  { IMAGE_SAMPLE_C_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x3, 0x4 }, // 4706
  { IMAGE_SAMPLE_C_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x3, 0x5 }, // 4707
  { IMAGE_SAMPLE_C_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x3, 0x6 }, // 4708
  { IMAGE_SAMPLE_C_CL_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 4709
  { IMAGE_SAMPLE_C_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 4710
  { IMAGE_SAMPLE_C_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 4711
  { IMAGE_SAMPLE_C_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x6 }, // 4712
  { IMAGE_SAMPLE_C_CL_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 4713
  { IMAGE_SAMPLE_C_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 4714
  { IMAGE_SAMPLE_C_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 4715
  { IMAGE_SAMPLE_C_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x6 }, // 4716
  { IMAGE_SAMPLE_C_CL_O_V1_V3, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x1, 0x3 }, // 4717
  { IMAGE_SAMPLE_C_CL_O_V1_V4, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x1, 0x4 }, // 4718
  { IMAGE_SAMPLE_C_CL_O_V1_V5, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x1, 0x5 }, // 4719
  { IMAGE_SAMPLE_C_CL_O_V1_V6, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x1, 0x6 }, // 4720
  { IMAGE_SAMPLE_C_CL_O_V1_V8, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x1, 0x8 }, // 4721
  { IMAGE_SAMPLE_C_CL_O_V2_V3, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x2, 0x3 }, // 4722
  { IMAGE_SAMPLE_C_CL_O_V2_V4, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 4723
  { IMAGE_SAMPLE_C_CL_O_V2_V5, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x2, 0x5 }, // 4724
  { IMAGE_SAMPLE_C_CL_O_V2_V6, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x2, 0x6 }, // 4725
  { IMAGE_SAMPLE_C_CL_O_V2_V8, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 4726
  { IMAGE_SAMPLE_C_CL_O_V3_V3, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x3, 0x3 }, // 4727
  { IMAGE_SAMPLE_C_CL_O_V3_V4, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x3, 0x4 }, // 4728
  { IMAGE_SAMPLE_C_CL_O_V3_V5, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x3, 0x5 }, // 4729
  { IMAGE_SAMPLE_C_CL_O_V3_V6, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x3, 0x6 }, // 4730
  { IMAGE_SAMPLE_C_CL_O_V3_V8, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x3, 0x8 }, // 4731
  { IMAGE_SAMPLE_C_CL_O_V4_V3, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x4, 0x3 }, // 4732
  { IMAGE_SAMPLE_C_CL_O_V4_V4, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 4733
  { IMAGE_SAMPLE_C_CL_O_V4_V5, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x4, 0x5 }, // 4734
  { IMAGE_SAMPLE_C_CL_O_V4_V6, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x4, 0x6 }, // 4735
  { IMAGE_SAMPLE_C_CL_O_V4_V8, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 4736
  { IMAGE_SAMPLE_C_CL_O_V5_V3, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x5, 0x3 }, // 4737
  { IMAGE_SAMPLE_C_CL_O_V5_V4, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x5, 0x4 }, // 4738
  { IMAGE_SAMPLE_C_CL_O_V5_V5, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x5, 0x5 }, // 4739
  { IMAGE_SAMPLE_C_CL_O_V5_V6, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x5, 0x6 }, // 4740
  { IMAGE_SAMPLE_C_CL_O_V5_V8, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x5, 0x8 }, // 4741
  { IMAGE_SAMPLE_C_D_V1_V3_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0x3 }, // 4742
  { IMAGE_SAMPLE_C_D_V1_V4_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0x4 }, // 4743
  { IMAGE_SAMPLE_C_D_V1_V5_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0x5 }, // 4744
  { IMAGE_SAMPLE_C_D_V1_V6_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0x6 }, // 4745
  { IMAGE_SAMPLE_C_D_V1_V7_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0x7 }, // 4746
  { IMAGE_SAMPLE_C_D_V1_V8_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0x8 }, // 4747
  { IMAGE_SAMPLE_C_D_V1_V16_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0x10 }, // 4748
  { IMAGE_SAMPLE_C_D_V2_V3_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0x3 }, // 4749
  { IMAGE_SAMPLE_C_D_V2_V4_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0x4 }, // 4750
  { IMAGE_SAMPLE_C_D_V2_V5_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0x5 }, // 4751
  { IMAGE_SAMPLE_C_D_V2_V6_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0x6 }, // 4752
  { IMAGE_SAMPLE_C_D_V2_V7_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0x7 }, // 4753
  { IMAGE_SAMPLE_C_D_V2_V8_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0x8 }, // 4754
  { IMAGE_SAMPLE_C_D_V2_V16_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0x10 }, // 4755
  { IMAGE_SAMPLE_C_D_V3_V3_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0x3 }, // 4756
  { IMAGE_SAMPLE_C_D_V3_V4_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0x4 }, // 4757
  { IMAGE_SAMPLE_C_D_V3_V5_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0x5 }, // 4758
  { IMAGE_SAMPLE_C_D_V3_V6_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0x6 }, // 4759
  { IMAGE_SAMPLE_C_D_V3_V7_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0x7 }, // 4760
  { IMAGE_SAMPLE_C_D_V3_V8_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0x8 }, // 4761
  { IMAGE_SAMPLE_C_D_V3_V16_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0x10 }, // 4762
  { IMAGE_SAMPLE_C_D_V4_V3_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0x3 }, // 4763
  { IMAGE_SAMPLE_C_D_V4_V4_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0x4 }, // 4764
  { IMAGE_SAMPLE_C_D_V4_V5_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0x5 }, // 4765
  { IMAGE_SAMPLE_C_D_V4_V6_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0x6 }, // 4766
  { IMAGE_SAMPLE_C_D_V4_V7_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0x7 }, // 4767
  { IMAGE_SAMPLE_C_D_V4_V8_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0x8 }, // 4768
  { IMAGE_SAMPLE_C_D_V4_V16_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0x10 }, // 4769
  { IMAGE_SAMPLE_C_D_V5_V3_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0x3 }, // 4770
  { IMAGE_SAMPLE_C_D_V5_V4_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0x4 }, // 4771
  { IMAGE_SAMPLE_C_D_V5_V5_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0x5 }, // 4772
  { IMAGE_SAMPLE_C_D_V5_V6_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0x6 }, // 4773
  { IMAGE_SAMPLE_C_D_V5_V7_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0x7 }, // 4774
  { IMAGE_SAMPLE_C_D_V5_V8_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0x8 }, // 4775
  { IMAGE_SAMPLE_C_D_V5_V16_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0x10 }, // 4776
  { IMAGE_SAMPLE_C_D_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0x3 }, // 4777
  { IMAGE_SAMPLE_C_D_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0x4 }, // 4778
  { IMAGE_SAMPLE_C_D_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0x5 }, // 4779
  { IMAGE_SAMPLE_C_D_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0x6 }, // 4780
  { IMAGE_SAMPLE_C_D_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0x7 }, // 4781
  { IMAGE_SAMPLE_C_D_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0x8 }, // 4782
  { IMAGE_SAMPLE_C_D_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0x9 }, // 4783
  { IMAGE_SAMPLE_C_D_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0xA }, // 4784
  { IMAGE_SAMPLE_C_D_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0x3 }, // 4785
  { IMAGE_SAMPLE_C_D_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0x4 }, // 4786
  { IMAGE_SAMPLE_C_D_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0x5 }, // 4787
  { IMAGE_SAMPLE_C_D_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0x6 }, // 4788
  { IMAGE_SAMPLE_C_D_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0x7 }, // 4789
  { IMAGE_SAMPLE_C_D_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0x8 }, // 4790
  { IMAGE_SAMPLE_C_D_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0x9 }, // 4791
  { IMAGE_SAMPLE_C_D_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0xA }, // 4792
  { IMAGE_SAMPLE_C_D_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0x3 }, // 4793
  { IMAGE_SAMPLE_C_D_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0x4 }, // 4794
  { IMAGE_SAMPLE_C_D_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0x5 }, // 4795
  { IMAGE_SAMPLE_C_D_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0x6 }, // 4796
  { IMAGE_SAMPLE_C_D_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0x7 }, // 4797
  { IMAGE_SAMPLE_C_D_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0x8 }, // 4798
  { IMAGE_SAMPLE_C_D_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0x9 }, // 4799
  { IMAGE_SAMPLE_C_D_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0xA }, // 4800
  { IMAGE_SAMPLE_C_D_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0x3 }, // 4801
  { IMAGE_SAMPLE_C_D_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0x4 }, // 4802
  { IMAGE_SAMPLE_C_D_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0x5 }, // 4803
  { IMAGE_SAMPLE_C_D_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0x6 }, // 4804
  { IMAGE_SAMPLE_C_D_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0x7 }, // 4805
  { IMAGE_SAMPLE_C_D_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0x8 }, // 4806
  { IMAGE_SAMPLE_C_D_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0x9 }, // 4807
  { IMAGE_SAMPLE_C_D_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0xA }, // 4808
  { IMAGE_SAMPLE_C_D_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0x3 }, // 4809
  { IMAGE_SAMPLE_C_D_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0x4 }, // 4810
  { IMAGE_SAMPLE_C_D_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0x5 }, // 4811
  { IMAGE_SAMPLE_C_D_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0x6 }, // 4812
  { IMAGE_SAMPLE_C_D_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0x7 }, // 4813
  { IMAGE_SAMPLE_C_D_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0x8 }, // 4814
  { IMAGE_SAMPLE_C_D_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0x9 }, // 4815
  { IMAGE_SAMPLE_C_D_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0xA }, // 4816
  { IMAGE_SAMPLE_C_D_V1_V3, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x3 }, // 4817
  { IMAGE_SAMPLE_C_D_V1_V4, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x4 }, // 4818
  { IMAGE_SAMPLE_C_D_V1_V5, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x5 }, // 4819
  { IMAGE_SAMPLE_C_D_V1_V6, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x6 }, // 4820
  { IMAGE_SAMPLE_C_D_V1_V7, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x7 }, // 4821
  { IMAGE_SAMPLE_C_D_V1_V8, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x8 }, // 4822
  { IMAGE_SAMPLE_C_D_V1_V16, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x10 }, // 4823
  { IMAGE_SAMPLE_C_D_V2_V3, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x3 }, // 4824
  { IMAGE_SAMPLE_C_D_V2_V4, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x4 }, // 4825
  { IMAGE_SAMPLE_C_D_V2_V5, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x5 }, // 4826
  { IMAGE_SAMPLE_C_D_V2_V6, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x6 }, // 4827
  { IMAGE_SAMPLE_C_D_V2_V7, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x7 }, // 4828
  { IMAGE_SAMPLE_C_D_V2_V8, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x8 }, // 4829
  { IMAGE_SAMPLE_C_D_V2_V16, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x10 }, // 4830
  { IMAGE_SAMPLE_C_D_V3_V3, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x3 }, // 4831
  { IMAGE_SAMPLE_C_D_V3_V4, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x4 }, // 4832
  { IMAGE_SAMPLE_C_D_V3_V5, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x5 }, // 4833
  { IMAGE_SAMPLE_C_D_V3_V6, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x6 }, // 4834
  { IMAGE_SAMPLE_C_D_V3_V7, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x7 }, // 4835
  { IMAGE_SAMPLE_C_D_V3_V8, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x8 }, // 4836
  { IMAGE_SAMPLE_C_D_V3_V16, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x10 }, // 4837
  { IMAGE_SAMPLE_C_D_V4_V3, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x3 }, // 4838
  { IMAGE_SAMPLE_C_D_V4_V4, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x4 }, // 4839
  { IMAGE_SAMPLE_C_D_V4_V5, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x5 }, // 4840
  { IMAGE_SAMPLE_C_D_V4_V6, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x6 }, // 4841
  { IMAGE_SAMPLE_C_D_V4_V7, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x7 }, // 4842
  { IMAGE_SAMPLE_C_D_V4_V8, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x8 }, // 4843
  { IMAGE_SAMPLE_C_D_V4_V16, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x10 }, // 4844
  { IMAGE_SAMPLE_C_D_V5_V3, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0x3 }, // 4845
  { IMAGE_SAMPLE_C_D_V5_V4, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0x4 }, // 4846
  { IMAGE_SAMPLE_C_D_V5_V5, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0x5 }, // 4847
  { IMAGE_SAMPLE_C_D_V5_V6, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0x6 }, // 4848
  { IMAGE_SAMPLE_C_D_V5_V7, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0x7 }, // 4849
  { IMAGE_SAMPLE_C_D_V5_V8, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0x8 }, // 4850
  { IMAGE_SAMPLE_C_D_V5_V16, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0x10 }, // 4851
  { IMAGE_SAMPLE_C_D_CL_V1_V3_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0x3 }, // 4852
  { IMAGE_SAMPLE_C_D_CL_V1_V4_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0x4 }, // 4853
  { IMAGE_SAMPLE_C_D_CL_V1_V5_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0x5 }, // 4854
  { IMAGE_SAMPLE_C_D_CL_V1_V6_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0x6 }, // 4855
  { IMAGE_SAMPLE_C_D_CL_V1_V7_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0x7 }, // 4856
  { IMAGE_SAMPLE_C_D_CL_V1_V8_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0x8 }, // 4857
  { IMAGE_SAMPLE_C_D_CL_V1_V16_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0x10 }, // 4858
  { IMAGE_SAMPLE_C_D_CL_V2_V3_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0x3 }, // 4859
  { IMAGE_SAMPLE_C_D_CL_V2_V4_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0x4 }, // 4860
  { IMAGE_SAMPLE_C_D_CL_V2_V5_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0x5 }, // 4861
  { IMAGE_SAMPLE_C_D_CL_V2_V6_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0x6 }, // 4862
  { IMAGE_SAMPLE_C_D_CL_V2_V7_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0x7 }, // 4863
  { IMAGE_SAMPLE_C_D_CL_V2_V8_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0x8 }, // 4864
  { IMAGE_SAMPLE_C_D_CL_V2_V16_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0x10 }, // 4865
  { IMAGE_SAMPLE_C_D_CL_V3_V3_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0x3 }, // 4866
  { IMAGE_SAMPLE_C_D_CL_V3_V4_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0x4 }, // 4867
  { IMAGE_SAMPLE_C_D_CL_V3_V5_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0x5 }, // 4868
  { IMAGE_SAMPLE_C_D_CL_V3_V6_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0x6 }, // 4869
  { IMAGE_SAMPLE_C_D_CL_V3_V7_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0x7 }, // 4870
  { IMAGE_SAMPLE_C_D_CL_V3_V8_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0x8 }, // 4871
  { IMAGE_SAMPLE_C_D_CL_V3_V16_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0x10 }, // 4872
  { IMAGE_SAMPLE_C_D_CL_V4_V3_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0x3 }, // 4873
  { IMAGE_SAMPLE_C_D_CL_V4_V4_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0x4 }, // 4874
  { IMAGE_SAMPLE_C_D_CL_V4_V5_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0x5 }, // 4875
  { IMAGE_SAMPLE_C_D_CL_V4_V6_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0x6 }, // 4876
  { IMAGE_SAMPLE_C_D_CL_V4_V7_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0x7 }, // 4877
  { IMAGE_SAMPLE_C_D_CL_V4_V8_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0x8 }, // 4878
  { IMAGE_SAMPLE_C_D_CL_V4_V16_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0x10 }, // 4879
  { IMAGE_SAMPLE_C_D_CL_V5_V3_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0x3 }, // 4880
  { IMAGE_SAMPLE_C_D_CL_V5_V4_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0x4 }, // 4881
  { IMAGE_SAMPLE_C_D_CL_V5_V5_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0x5 }, // 4882
  { IMAGE_SAMPLE_C_D_CL_V5_V6_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0x6 }, // 4883
  { IMAGE_SAMPLE_C_D_CL_V5_V7_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0x7 }, // 4884
  { IMAGE_SAMPLE_C_D_CL_V5_V8_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0x8 }, // 4885
  { IMAGE_SAMPLE_C_D_CL_V5_V16_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0x10 }, // 4886
  { IMAGE_SAMPLE_C_D_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0x3 }, // 4887
  { IMAGE_SAMPLE_C_D_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0x4 }, // 4888
  { IMAGE_SAMPLE_C_D_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0x5 }, // 4889
  { IMAGE_SAMPLE_C_D_CL_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0x6 }, // 4890
  { IMAGE_SAMPLE_C_D_CL_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0x7 }, // 4891
  { IMAGE_SAMPLE_C_D_CL_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0x8 }, // 4892
  { IMAGE_SAMPLE_C_D_CL_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0x9 }, // 4893
  { IMAGE_SAMPLE_C_D_CL_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0xA }, // 4894
  { IMAGE_SAMPLE_C_D_CL_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0xB }, // 4895
  { IMAGE_SAMPLE_C_D_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0x3 }, // 4896
  { IMAGE_SAMPLE_C_D_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0x4 }, // 4897
  { IMAGE_SAMPLE_C_D_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0x5 }, // 4898
  { IMAGE_SAMPLE_C_D_CL_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0x6 }, // 4899
  { IMAGE_SAMPLE_C_D_CL_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0x7 }, // 4900
  { IMAGE_SAMPLE_C_D_CL_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0x8 }, // 4901
  { IMAGE_SAMPLE_C_D_CL_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0x9 }, // 4902
  { IMAGE_SAMPLE_C_D_CL_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0xA }, // 4903
  { IMAGE_SAMPLE_C_D_CL_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0xB }, // 4904
  { IMAGE_SAMPLE_C_D_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0x3 }, // 4905
  { IMAGE_SAMPLE_C_D_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0x4 }, // 4906
  { IMAGE_SAMPLE_C_D_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0x5 }, // 4907
  { IMAGE_SAMPLE_C_D_CL_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0x6 }, // 4908
  { IMAGE_SAMPLE_C_D_CL_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0x7 }, // 4909
  { IMAGE_SAMPLE_C_D_CL_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0x8 }, // 4910
  { IMAGE_SAMPLE_C_D_CL_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0x9 }, // 4911
  { IMAGE_SAMPLE_C_D_CL_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0xA }, // 4912
  { IMAGE_SAMPLE_C_D_CL_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0xB }, // 4913
  { IMAGE_SAMPLE_C_D_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0x3 }, // 4914
  { IMAGE_SAMPLE_C_D_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0x4 }, // 4915
  { IMAGE_SAMPLE_C_D_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0x5 }, // 4916
  { IMAGE_SAMPLE_C_D_CL_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0x6 }, // 4917
  { IMAGE_SAMPLE_C_D_CL_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0x7 }, // 4918
  { IMAGE_SAMPLE_C_D_CL_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0x8 }, // 4919
  { IMAGE_SAMPLE_C_D_CL_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0x9 }, // 4920
  { IMAGE_SAMPLE_C_D_CL_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0xA }, // 4921
  { IMAGE_SAMPLE_C_D_CL_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0xB }, // 4922
  { IMAGE_SAMPLE_C_D_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0x3 }, // 4923
  { IMAGE_SAMPLE_C_D_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0x4 }, // 4924
  { IMAGE_SAMPLE_C_D_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0x5 }, // 4925
  { IMAGE_SAMPLE_C_D_CL_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0x6 }, // 4926
  { IMAGE_SAMPLE_C_D_CL_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0x7 }, // 4927
  { IMAGE_SAMPLE_C_D_CL_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0x8 }, // 4928
  { IMAGE_SAMPLE_C_D_CL_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0x9 }, // 4929
  { IMAGE_SAMPLE_C_D_CL_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0xA }, // 4930
  { IMAGE_SAMPLE_C_D_CL_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0xB }, // 4931
  { IMAGE_SAMPLE_C_D_CL_V1_V3, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x3 }, // 4932
  { IMAGE_SAMPLE_C_D_CL_V1_V4, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x4 }, // 4933
  { IMAGE_SAMPLE_C_D_CL_V1_V5, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x5 }, // 4934
  { IMAGE_SAMPLE_C_D_CL_V1_V6, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x6 }, // 4935
  { IMAGE_SAMPLE_C_D_CL_V1_V7, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x7 }, // 4936
  { IMAGE_SAMPLE_C_D_CL_V1_V8, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x8 }, // 4937
  { IMAGE_SAMPLE_C_D_CL_V1_V16, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x10 }, // 4938
  { IMAGE_SAMPLE_C_D_CL_V2_V3, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x3 }, // 4939
  { IMAGE_SAMPLE_C_D_CL_V2_V4, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x4 }, // 4940
  { IMAGE_SAMPLE_C_D_CL_V2_V5, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x5 }, // 4941
  { IMAGE_SAMPLE_C_D_CL_V2_V6, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x6 }, // 4942
  { IMAGE_SAMPLE_C_D_CL_V2_V7, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x7 }, // 4943
  { IMAGE_SAMPLE_C_D_CL_V2_V8, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x8 }, // 4944
  { IMAGE_SAMPLE_C_D_CL_V2_V16, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x10 }, // 4945
  { IMAGE_SAMPLE_C_D_CL_V3_V3, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x3 }, // 4946
  { IMAGE_SAMPLE_C_D_CL_V3_V4, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x4 }, // 4947
  { IMAGE_SAMPLE_C_D_CL_V3_V5, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x5 }, // 4948
  { IMAGE_SAMPLE_C_D_CL_V3_V6, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x6 }, // 4949
  { IMAGE_SAMPLE_C_D_CL_V3_V7, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x7 }, // 4950
  { IMAGE_SAMPLE_C_D_CL_V3_V8, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x8 }, // 4951
  { IMAGE_SAMPLE_C_D_CL_V3_V16, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x10 }, // 4952
  { IMAGE_SAMPLE_C_D_CL_V4_V3, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x3 }, // 4953
  { IMAGE_SAMPLE_C_D_CL_V4_V4, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x4 }, // 4954
  { IMAGE_SAMPLE_C_D_CL_V4_V5, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x5 }, // 4955
  { IMAGE_SAMPLE_C_D_CL_V4_V6, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x6 }, // 4956
  { IMAGE_SAMPLE_C_D_CL_V4_V7, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x7 }, // 4957
  { IMAGE_SAMPLE_C_D_CL_V4_V8, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x8 }, // 4958
  { IMAGE_SAMPLE_C_D_CL_V4_V16, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x10 }, // 4959
  { IMAGE_SAMPLE_C_D_CL_V5_V3, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0x3 }, // 4960
  { IMAGE_SAMPLE_C_D_CL_V5_V4, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0x4 }, // 4961
  { IMAGE_SAMPLE_C_D_CL_V5_V5, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0x5 }, // 4962
  { IMAGE_SAMPLE_C_D_CL_V5_V6, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0x6 }, // 4963
  { IMAGE_SAMPLE_C_D_CL_V5_V7, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0x7 }, // 4964
  { IMAGE_SAMPLE_C_D_CL_V5_V8, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0x8 }, // 4965
  { IMAGE_SAMPLE_C_D_CL_V5_V16, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0x10 }, // 4966
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V3_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x3 }, // 4967
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x4 }, // 4968
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x5 }, // 4969
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x6 }, // 4970
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x7 }, // 4971
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x8 }, // 4972
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V16_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x10 }, // 4973
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V3_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x3 }, // 4974
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x4 }, // 4975
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x5 }, // 4976
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x6 }, // 4977
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x7 }, // 4978
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x8 }, // 4979
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V16_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x10 }, // 4980
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V3_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x3 }, // 4981
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x4 }, // 4982
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x5 }, // 4983
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x6 }, // 4984
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x7 }, // 4985
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x8 }, // 4986
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V16_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x10 }, // 4987
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V3_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x3 }, // 4988
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x4 }, // 4989
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x5 }, // 4990
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x6 }, // 4991
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x7 }, // 4992
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x8 }, // 4993
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V16_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x10 }, // 4994
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V3_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x3 }, // 4995
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x4 }, // 4996
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x5 }, // 4997
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x6 }, // 4998
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x7 }, // 4999
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x8 }, // 5000
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V16_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x10 }, // 5001
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x3 }, // 5002
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x4 }, // 5003
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x5 }, // 5004
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x6 }, // 5005
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x7 }, // 5006
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x8 }, // 5007
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x9 }, // 5008
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0xA }, // 5009
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0xB }, // 5010
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x3 }, // 5011
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x4 }, // 5012
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x5 }, // 5013
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x6 }, // 5014
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x7 }, // 5015
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x8 }, // 5016
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x9 }, // 5017
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0xA }, // 5018
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0xB }, // 5019
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x3 }, // 5020
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x4 }, // 5021
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x5 }, // 5022
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x6 }, // 5023
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x7 }, // 5024
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x8 }, // 5025
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x9 }, // 5026
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0xA }, // 5027
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0xB }, // 5028
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x3 }, // 5029
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x4 }, // 5030
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x5 }, // 5031
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x6 }, // 5032
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x7 }, // 5033
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x8 }, // 5034
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x9 }, // 5035
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0xA }, // 5036
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0xB }, // 5037
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x3 }, // 5038
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x4 }, // 5039
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x5 }, // 5040
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x6 }, // 5041
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x7 }, // 5042
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x8 }, // 5043
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x9 }, // 5044
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0xA }, // 5045
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0xB }, // 5046
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V3, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x1, 0x3 }, // 5047
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V4, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x1, 0x4 }, // 5048
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V5, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x1, 0x5 }, // 5049
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V6, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x1, 0x6 }, // 5050
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V7, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x1, 0x7 }, // 5051
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V8, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x1, 0x8 }, // 5052
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V16, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x1, 0x10 }, // 5053
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V3, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x2, 0x3 }, // 5054
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V4, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x2, 0x4 }, // 5055
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V5, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x2, 0x5 }, // 5056
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V6, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x2, 0x6 }, // 5057
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V7, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x2, 0x7 }, // 5058
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V8, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x2, 0x8 }, // 5059
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V16, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x2, 0x10 }, // 5060
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V3, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x3, 0x3 }, // 5061
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V4, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x3, 0x4 }, // 5062
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V5, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x3, 0x5 }, // 5063
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V6, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x3, 0x6 }, // 5064
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V7, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x3, 0x7 }, // 5065
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V8, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x3, 0x8 }, // 5066
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V16, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x3, 0x10 }, // 5067
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V3, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x4, 0x3 }, // 5068
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V4, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x4, 0x4 }, // 5069
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V5, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x4, 0x5 }, // 5070
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V6, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x4, 0x6 }, // 5071
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V7, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x4, 0x7 }, // 5072
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V8, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x4, 0x8 }, // 5073
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V16, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x4, 0x10 }, // 5074
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V3, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x5, 0x3 }, // 5075
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V4, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x5, 0x4 }, // 5076
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V5, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x5, 0x5 }, // 5077
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V6, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x5, 0x6 }, // 5078
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V7, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x5, 0x7 }, // 5079
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V8, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x5, 0x8 }, // 5080
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V16, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x5, 0x10 }, // 5081
  { IMAGE_SAMPLE_C_D_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0x4 }, // 5082
  { IMAGE_SAMPLE_C_D_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0x5 }, // 5083
  { IMAGE_SAMPLE_C_D_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0x6 }, // 5084
  { IMAGE_SAMPLE_C_D_CL_O_V1_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0x7 }, // 5085
  { IMAGE_SAMPLE_C_D_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0x8 }, // 5086
  { IMAGE_SAMPLE_C_D_CL_O_V1_V16_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0x10 }, // 5087
  { IMAGE_SAMPLE_C_D_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 5088
  { IMAGE_SAMPLE_C_D_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 5089
  { IMAGE_SAMPLE_C_D_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0x6 }, // 5090
  { IMAGE_SAMPLE_C_D_CL_O_V2_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0x7 }, // 5091
  { IMAGE_SAMPLE_C_D_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 5092
  { IMAGE_SAMPLE_C_D_CL_O_V2_V16_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0x10 }, // 5093
  { IMAGE_SAMPLE_C_D_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0x4 }, // 5094
  { IMAGE_SAMPLE_C_D_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0x5 }, // 5095
  { IMAGE_SAMPLE_C_D_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0x6 }, // 5096
  { IMAGE_SAMPLE_C_D_CL_O_V3_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0x7 }, // 5097
  { IMAGE_SAMPLE_C_D_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0x8 }, // 5098
  { IMAGE_SAMPLE_C_D_CL_O_V3_V16_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0x10 }, // 5099
  { IMAGE_SAMPLE_C_D_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 5100
  { IMAGE_SAMPLE_C_D_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 5101
  { IMAGE_SAMPLE_C_D_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0x6 }, // 5102
  { IMAGE_SAMPLE_C_D_CL_O_V4_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0x7 }, // 5103
  { IMAGE_SAMPLE_C_D_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 5104
  { IMAGE_SAMPLE_C_D_CL_O_V4_V16_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0x10 }, // 5105
  { IMAGE_SAMPLE_C_D_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 5106
  { IMAGE_SAMPLE_C_D_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 5107
  { IMAGE_SAMPLE_C_D_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0x6 }, // 5108
  { IMAGE_SAMPLE_C_D_CL_O_V5_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0x7 }, // 5109
  { IMAGE_SAMPLE_C_D_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 5110
  { IMAGE_SAMPLE_C_D_CL_O_V5_V16_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0x10 }, // 5111
  { IMAGE_SAMPLE_C_D_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x4 }, // 5112
  { IMAGE_SAMPLE_C_D_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x5 }, // 5113
  { IMAGE_SAMPLE_C_D_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x6 }, // 5114
  { IMAGE_SAMPLE_C_D_CL_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x7 }, // 5115
  { IMAGE_SAMPLE_C_D_CL_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x8 }, // 5116
  { IMAGE_SAMPLE_C_D_CL_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x9 }, // 5117
  { IMAGE_SAMPLE_C_D_CL_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0xA }, // 5118
  { IMAGE_SAMPLE_C_D_CL_O_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0xB }, // 5119
  { IMAGE_SAMPLE_C_D_CL_O_V1_V12_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0xC }, // 5120
  { IMAGE_SAMPLE_C_D_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 5121
  { IMAGE_SAMPLE_C_D_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 5122
  { IMAGE_SAMPLE_C_D_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x6 }, // 5123
  { IMAGE_SAMPLE_C_D_CL_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x7 }, // 5124
  { IMAGE_SAMPLE_C_D_CL_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x8 }, // 5125
  { IMAGE_SAMPLE_C_D_CL_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x9 }, // 5126
  { IMAGE_SAMPLE_C_D_CL_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0xA }, // 5127
  { IMAGE_SAMPLE_C_D_CL_O_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0xB }, // 5128
  { IMAGE_SAMPLE_C_D_CL_O_V2_V12_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0xC }, // 5129
  { IMAGE_SAMPLE_C_D_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x4 }, // 5130
  { IMAGE_SAMPLE_C_D_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x5 }, // 5131
  { IMAGE_SAMPLE_C_D_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x6 }, // 5132
  { IMAGE_SAMPLE_C_D_CL_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x7 }, // 5133
  { IMAGE_SAMPLE_C_D_CL_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x8 }, // 5134
  { IMAGE_SAMPLE_C_D_CL_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x9 }, // 5135
  { IMAGE_SAMPLE_C_D_CL_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0xA }, // 5136
  { IMAGE_SAMPLE_C_D_CL_O_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0xB }, // 5137
  { IMAGE_SAMPLE_C_D_CL_O_V3_V12_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0xC }, // 5138
  { IMAGE_SAMPLE_C_D_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 5139
  { IMAGE_SAMPLE_C_D_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 5140
  { IMAGE_SAMPLE_C_D_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x6 }, // 5141
  { IMAGE_SAMPLE_C_D_CL_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x7 }, // 5142
  { IMAGE_SAMPLE_C_D_CL_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x8 }, // 5143
  { IMAGE_SAMPLE_C_D_CL_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x9 }, // 5144
  { IMAGE_SAMPLE_C_D_CL_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0xA }, // 5145
  { IMAGE_SAMPLE_C_D_CL_O_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0xB }, // 5146
  { IMAGE_SAMPLE_C_D_CL_O_V4_V12_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0xC }, // 5147
  { IMAGE_SAMPLE_C_D_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 5148
  { IMAGE_SAMPLE_C_D_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 5149
  { IMAGE_SAMPLE_C_D_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x6 }, // 5150
  { IMAGE_SAMPLE_C_D_CL_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x7 }, // 5151
  { IMAGE_SAMPLE_C_D_CL_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x8 }, // 5152
  { IMAGE_SAMPLE_C_D_CL_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x9 }, // 5153
  { IMAGE_SAMPLE_C_D_CL_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0xA }, // 5154
  { IMAGE_SAMPLE_C_D_CL_O_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0xB }, // 5155
  { IMAGE_SAMPLE_C_D_CL_O_V5_V12_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0xC }, // 5156
  { IMAGE_SAMPLE_C_D_CL_O_V1_V4, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0x4 }, // 5157
  { IMAGE_SAMPLE_C_D_CL_O_V1_V5, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0x5 }, // 5158
  { IMAGE_SAMPLE_C_D_CL_O_V1_V6, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0x6 }, // 5159
  { IMAGE_SAMPLE_C_D_CL_O_V1_V7, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0x7 }, // 5160
  { IMAGE_SAMPLE_C_D_CL_O_V1_V8, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0x8 }, // 5161
  { IMAGE_SAMPLE_C_D_CL_O_V1_V16, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0x10 }, // 5162
  { IMAGE_SAMPLE_C_D_CL_O_V2_V4, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 5163
  { IMAGE_SAMPLE_C_D_CL_O_V2_V5, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0x5 }, // 5164
  { IMAGE_SAMPLE_C_D_CL_O_V2_V6, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0x6 }, // 5165
  { IMAGE_SAMPLE_C_D_CL_O_V2_V7, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0x7 }, // 5166
  { IMAGE_SAMPLE_C_D_CL_O_V2_V8, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 5167
  { IMAGE_SAMPLE_C_D_CL_O_V2_V16, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0x10 }, // 5168
  { IMAGE_SAMPLE_C_D_CL_O_V3_V4, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0x4 }, // 5169
  { IMAGE_SAMPLE_C_D_CL_O_V3_V5, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0x5 }, // 5170
  { IMAGE_SAMPLE_C_D_CL_O_V3_V6, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0x6 }, // 5171
  { IMAGE_SAMPLE_C_D_CL_O_V3_V7, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0x7 }, // 5172
  { IMAGE_SAMPLE_C_D_CL_O_V3_V8, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0x8 }, // 5173
  { IMAGE_SAMPLE_C_D_CL_O_V3_V16, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0x10 }, // 5174
  { IMAGE_SAMPLE_C_D_CL_O_V4_V4, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 5175
  { IMAGE_SAMPLE_C_D_CL_O_V4_V5, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0x5 }, // 5176
  { IMAGE_SAMPLE_C_D_CL_O_V4_V6, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0x6 }, // 5177
  { IMAGE_SAMPLE_C_D_CL_O_V4_V7, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0x7 }, // 5178
  { IMAGE_SAMPLE_C_D_CL_O_V4_V8, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 5179
  { IMAGE_SAMPLE_C_D_CL_O_V4_V16, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0x10 }, // 5180
  { IMAGE_SAMPLE_C_D_CL_O_V5_V4, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0x4 }, // 5181
  { IMAGE_SAMPLE_C_D_CL_O_V5_V5, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0x5 }, // 5182
  { IMAGE_SAMPLE_C_D_CL_O_V5_V6, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0x6 }, // 5183
  { IMAGE_SAMPLE_C_D_CL_O_V5_V7, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0x7 }, // 5184
  { IMAGE_SAMPLE_C_D_CL_O_V5_V8, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0x8 }, // 5185
  { IMAGE_SAMPLE_C_D_CL_O_V5_V16, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0x10 }, // 5186
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x4 }, // 5187
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x5 }, // 5188
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x6 }, // 5189
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x7 }, // 5190
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x8 }, // 5191
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V16_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x10 }, // 5192
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x4 }, // 5193
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x5 }, // 5194
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x6 }, // 5195
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x7 }, // 5196
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x8 }, // 5197
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V16_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x10 }, // 5198
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x4 }, // 5199
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x5 }, // 5200
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x6 }, // 5201
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x7 }, // 5202
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x8 }, // 5203
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V16_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x10 }, // 5204
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x4 }, // 5205
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x5 }, // 5206
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x6 }, // 5207
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x7 }, // 5208
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x8 }, // 5209
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V16_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x10 }, // 5210
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x4 }, // 5211
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x5 }, // 5212
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x6 }, // 5213
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x7 }, // 5214
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x8 }, // 5215
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V16_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x10 }, // 5216
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x4 }, // 5217
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x5 }, // 5218
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x6 }, // 5219
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x7 }, // 5220
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x8 }, // 5221
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x9 }, // 5222
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0xA }, // 5223
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0xB }, // 5224
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V12_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0xC }, // 5225
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x4 }, // 5226
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x5 }, // 5227
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x6 }, // 5228
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x7 }, // 5229
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x8 }, // 5230
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x9 }, // 5231
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0xA }, // 5232
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0xB }, // 5233
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V12_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0xC }, // 5234
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x4 }, // 5235
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x5 }, // 5236
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x6 }, // 5237
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x7 }, // 5238
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x8 }, // 5239
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x9 }, // 5240
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0xA }, // 5241
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0xB }, // 5242
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V12_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0xC }, // 5243
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x4 }, // 5244
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x5 }, // 5245
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x6 }, // 5246
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x7 }, // 5247
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x8 }, // 5248
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x9 }, // 5249
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0xA }, // 5250
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0xB }, // 5251
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V12_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0xC }, // 5252
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x4 }, // 5253
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x5 }, // 5254
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x6 }, // 5255
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x7 }, // 5256
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x8 }, // 5257
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x9 }, // 5258
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0xA }, // 5259
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0xB }, // 5260
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V12_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0xC }, // 5261
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V4, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x4 }, // 5262
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V5, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x5 }, // 5263
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V6, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x6 }, // 5264
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V7, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x7 }, // 5265
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V8, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x8 }, // 5266
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V16, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x10 }, // 5267
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V4, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x4 }, // 5268
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V5, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x5 }, // 5269
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V6, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x6 }, // 5270
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V7, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x7 }, // 5271
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V8, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x8 }, // 5272
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V16, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x10 }, // 5273
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V4, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x4 }, // 5274
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V5, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x5 }, // 5275
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V6, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x6 }, // 5276
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V7, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x7 }, // 5277
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V8, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x8 }, // 5278
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V16, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x10 }, // 5279
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V4, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x4 }, // 5280
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V5, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x5 }, // 5281
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V6, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x6 }, // 5282
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V7, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x7 }, // 5283
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V8, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x8 }, // 5284
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V16, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x10 }, // 5285
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V4, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x4 }, // 5286
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V5, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x5 }, // 5287
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V6, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x6 }, // 5288
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V7, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x7 }, // 5289
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V8, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x8 }, // 5290
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V16, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x10 }, // 5291
  { IMAGE_SAMPLE_C_D_G16_V1_V3_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x1, 0x3 }, // 5292
  { IMAGE_SAMPLE_C_D_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x1, 0x4 }, // 5293
  { IMAGE_SAMPLE_C_D_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x1, 0x5 }, // 5294
  { IMAGE_SAMPLE_C_D_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x1, 0x6 }, // 5295
  { IMAGE_SAMPLE_C_D_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x1, 0x7 }, // 5296
  { IMAGE_SAMPLE_C_D_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x1, 0x8 }, // 5297
  { IMAGE_SAMPLE_C_D_G16_V1_V16_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x1, 0x10 }, // 5298
  { IMAGE_SAMPLE_C_D_G16_V2_V3_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x2, 0x3 }, // 5299
  { IMAGE_SAMPLE_C_D_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x2, 0x4 }, // 5300
  { IMAGE_SAMPLE_C_D_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x2, 0x5 }, // 5301
  { IMAGE_SAMPLE_C_D_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x2, 0x6 }, // 5302
  { IMAGE_SAMPLE_C_D_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x2, 0x7 }, // 5303
  { IMAGE_SAMPLE_C_D_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x2, 0x8 }, // 5304
  { IMAGE_SAMPLE_C_D_G16_V2_V16_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x2, 0x10 }, // 5305
  { IMAGE_SAMPLE_C_D_G16_V3_V3_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x3, 0x3 }, // 5306
  { IMAGE_SAMPLE_C_D_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x3, 0x4 }, // 5307
  { IMAGE_SAMPLE_C_D_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x3, 0x5 }, // 5308
  { IMAGE_SAMPLE_C_D_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x3, 0x6 }, // 5309
  { IMAGE_SAMPLE_C_D_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x3, 0x7 }, // 5310
  { IMAGE_SAMPLE_C_D_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x3, 0x8 }, // 5311
  { IMAGE_SAMPLE_C_D_G16_V3_V16_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x3, 0x10 }, // 5312
  { IMAGE_SAMPLE_C_D_G16_V4_V3_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x4, 0x3 }, // 5313
  { IMAGE_SAMPLE_C_D_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x4, 0x4 }, // 5314
  { IMAGE_SAMPLE_C_D_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x4, 0x5 }, // 5315
  { IMAGE_SAMPLE_C_D_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x4, 0x6 }, // 5316
  { IMAGE_SAMPLE_C_D_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x4, 0x7 }, // 5317
  { IMAGE_SAMPLE_C_D_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x4, 0x8 }, // 5318
  { IMAGE_SAMPLE_C_D_G16_V4_V16_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x4, 0x10 }, // 5319
  { IMAGE_SAMPLE_C_D_G16_V5_V3_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x5, 0x3 }, // 5320
  { IMAGE_SAMPLE_C_D_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x5, 0x4 }, // 5321
  { IMAGE_SAMPLE_C_D_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x5, 0x5 }, // 5322
  { IMAGE_SAMPLE_C_D_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x5, 0x6 }, // 5323
  { IMAGE_SAMPLE_C_D_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x5, 0x7 }, // 5324
  { IMAGE_SAMPLE_C_D_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x5, 0x8 }, // 5325
  { IMAGE_SAMPLE_C_D_G16_V5_V16_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x5, 0x10 }, // 5326
  { IMAGE_SAMPLE_C_D_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x1, 0x3 }, // 5327
  { IMAGE_SAMPLE_C_D_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x1, 0x4 }, // 5328
  { IMAGE_SAMPLE_C_D_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x1, 0x5 }, // 5329
  { IMAGE_SAMPLE_C_D_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x1, 0x6 }, // 5330
  { IMAGE_SAMPLE_C_D_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x1, 0x7 }, // 5331
  { IMAGE_SAMPLE_C_D_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x1, 0x8 }, // 5332
  { IMAGE_SAMPLE_C_D_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x1, 0x9 }, // 5333
  { IMAGE_SAMPLE_C_D_G16_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x1, 0xA }, // 5334
  { IMAGE_SAMPLE_C_D_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x2, 0x3 }, // 5335
  { IMAGE_SAMPLE_C_D_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x2, 0x4 }, // 5336
  { IMAGE_SAMPLE_C_D_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x2, 0x5 }, // 5337
  { IMAGE_SAMPLE_C_D_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x2, 0x6 }, // 5338
  { IMAGE_SAMPLE_C_D_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x2, 0x7 }, // 5339
  { IMAGE_SAMPLE_C_D_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x2, 0x8 }, // 5340
  { IMAGE_SAMPLE_C_D_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x2, 0x9 }, // 5341
  { IMAGE_SAMPLE_C_D_G16_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x2, 0xA }, // 5342
  { IMAGE_SAMPLE_C_D_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x3, 0x3 }, // 5343
  { IMAGE_SAMPLE_C_D_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x3, 0x4 }, // 5344
  { IMAGE_SAMPLE_C_D_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x3, 0x5 }, // 5345
  { IMAGE_SAMPLE_C_D_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x3, 0x6 }, // 5346
  { IMAGE_SAMPLE_C_D_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x3, 0x7 }, // 5347
  { IMAGE_SAMPLE_C_D_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x3, 0x8 }, // 5348
  { IMAGE_SAMPLE_C_D_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x3, 0x9 }, // 5349
  { IMAGE_SAMPLE_C_D_G16_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x3, 0xA }, // 5350
  { IMAGE_SAMPLE_C_D_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x4, 0x3 }, // 5351
  { IMAGE_SAMPLE_C_D_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x4, 0x4 }, // 5352
  { IMAGE_SAMPLE_C_D_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x4, 0x5 }, // 5353
  { IMAGE_SAMPLE_C_D_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x4, 0x6 }, // 5354
  { IMAGE_SAMPLE_C_D_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x4, 0x7 }, // 5355
  { IMAGE_SAMPLE_C_D_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x4, 0x8 }, // 5356
  { IMAGE_SAMPLE_C_D_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x4, 0x9 }, // 5357
  { IMAGE_SAMPLE_C_D_G16_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x4, 0xA }, // 5358
  { IMAGE_SAMPLE_C_D_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x5, 0x3 }, // 5359
  { IMAGE_SAMPLE_C_D_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x5, 0x4 }, // 5360
  { IMAGE_SAMPLE_C_D_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x5, 0x5 }, // 5361
  { IMAGE_SAMPLE_C_D_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x5, 0x6 }, // 5362
  { IMAGE_SAMPLE_C_D_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x5, 0x7 }, // 5363
  { IMAGE_SAMPLE_C_D_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x5, 0x8 }, // 5364
  { IMAGE_SAMPLE_C_D_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x5, 0x9 }, // 5365
  { IMAGE_SAMPLE_C_D_G16_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x5, 0xA }, // 5366
  { IMAGE_SAMPLE_C_D_G16_V1_V3, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x1, 0x3 }, // 5367
  { IMAGE_SAMPLE_C_D_G16_V1_V4, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x1, 0x4 }, // 5368
  { IMAGE_SAMPLE_C_D_G16_V1_V5, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x1, 0x5 }, // 5369
  { IMAGE_SAMPLE_C_D_G16_V1_V6, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x1, 0x6 }, // 5370
  { IMAGE_SAMPLE_C_D_G16_V1_V7, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x1, 0x7 }, // 5371
  { IMAGE_SAMPLE_C_D_G16_V1_V8, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x1, 0x8 }, // 5372
  { IMAGE_SAMPLE_C_D_G16_V1_V16, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x1, 0x10 }, // 5373
  { IMAGE_SAMPLE_C_D_G16_V2_V3, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x2, 0x3 }, // 5374
  { IMAGE_SAMPLE_C_D_G16_V2_V4, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x2, 0x4 }, // 5375
  { IMAGE_SAMPLE_C_D_G16_V2_V5, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x2, 0x5 }, // 5376
  { IMAGE_SAMPLE_C_D_G16_V2_V6, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x2, 0x6 }, // 5377
  { IMAGE_SAMPLE_C_D_G16_V2_V7, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x2, 0x7 }, // 5378
  { IMAGE_SAMPLE_C_D_G16_V2_V8, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x2, 0x8 }, // 5379
  { IMAGE_SAMPLE_C_D_G16_V2_V16, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x2, 0x10 }, // 5380
  { IMAGE_SAMPLE_C_D_G16_V3_V3, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x3, 0x3 }, // 5381
  { IMAGE_SAMPLE_C_D_G16_V3_V4, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x3, 0x4 }, // 5382
  { IMAGE_SAMPLE_C_D_G16_V3_V5, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x3, 0x5 }, // 5383
  { IMAGE_SAMPLE_C_D_G16_V3_V6, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x3, 0x6 }, // 5384
  { IMAGE_SAMPLE_C_D_G16_V3_V7, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x3, 0x7 }, // 5385
  { IMAGE_SAMPLE_C_D_G16_V3_V8, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x3, 0x8 }, // 5386
  { IMAGE_SAMPLE_C_D_G16_V3_V16, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x3, 0x10 }, // 5387
  { IMAGE_SAMPLE_C_D_G16_V4_V3, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x4, 0x3 }, // 5388
  { IMAGE_SAMPLE_C_D_G16_V4_V4, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x4, 0x4 }, // 5389
  { IMAGE_SAMPLE_C_D_G16_V4_V5, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x4, 0x5 }, // 5390
  { IMAGE_SAMPLE_C_D_G16_V4_V6, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x4, 0x6 }, // 5391
  { IMAGE_SAMPLE_C_D_G16_V4_V7, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x4, 0x7 }, // 5392
  { IMAGE_SAMPLE_C_D_G16_V4_V8, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x4, 0x8 }, // 5393
  { IMAGE_SAMPLE_C_D_G16_V4_V16, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x4, 0x10 }, // 5394
  { IMAGE_SAMPLE_C_D_G16_V5_V3, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x5, 0x3 }, // 5395
  { IMAGE_SAMPLE_C_D_G16_V5_V4, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x5, 0x4 }, // 5396
  { IMAGE_SAMPLE_C_D_G16_V5_V5, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x5, 0x5 }, // 5397
  { IMAGE_SAMPLE_C_D_G16_V5_V6, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x5, 0x6 }, // 5398
  { IMAGE_SAMPLE_C_D_G16_V5_V7, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x5, 0x7 }, // 5399
  { IMAGE_SAMPLE_C_D_G16_V5_V8, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x5, 0x8 }, // 5400
  { IMAGE_SAMPLE_C_D_G16_V5_V16, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx6, 0x5, 0x10 }, // 5401
  { IMAGE_SAMPLE_C_D_O_V1_V4_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x1, 0x4 }, // 5402
  { IMAGE_SAMPLE_C_D_O_V1_V5_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x1, 0x5 }, // 5403
  { IMAGE_SAMPLE_C_D_O_V1_V6_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x1, 0x6 }, // 5404
  { IMAGE_SAMPLE_C_D_O_V1_V7_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x1, 0x7 }, // 5405
  { IMAGE_SAMPLE_C_D_O_V1_V8_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x1, 0x8 }, // 5406
  { IMAGE_SAMPLE_C_D_O_V1_V16_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x1, 0x10 }, // 5407
  { IMAGE_SAMPLE_C_D_O_V2_V4_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 5408
  { IMAGE_SAMPLE_C_D_O_V2_V5_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 5409
  { IMAGE_SAMPLE_C_D_O_V2_V6_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x2, 0x6 }, // 5410
  { IMAGE_SAMPLE_C_D_O_V2_V7_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x2, 0x7 }, // 5411
  { IMAGE_SAMPLE_C_D_O_V2_V8_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 5412
  { IMAGE_SAMPLE_C_D_O_V2_V16_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x2, 0x10 }, // 5413
  { IMAGE_SAMPLE_C_D_O_V3_V4_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x3, 0x4 }, // 5414
  { IMAGE_SAMPLE_C_D_O_V3_V5_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x3, 0x5 }, // 5415
  { IMAGE_SAMPLE_C_D_O_V3_V6_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x3, 0x6 }, // 5416
  { IMAGE_SAMPLE_C_D_O_V3_V7_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x3, 0x7 }, // 5417
  { IMAGE_SAMPLE_C_D_O_V3_V8_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x3, 0x8 }, // 5418
  { IMAGE_SAMPLE_C_D_O_V3_V16_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x3, 0x10 }, // 5419
  { IMAGE_SAMPLE_C_D_O_V4_V4_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 5420
  { IMAGE_SAMPLE_C_D_O_V4_V5_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 5421
  { IMAGE_SAMPLE_C_D_O_V4_V6_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x4, 0x6 }, // 5422
  { IMAGE_SAMPLE_C_D_O_V4_V7_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x4, 0x7 }, // 5423
  { IMAGE_SAMPLE_C_D_O_V4_V8_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 5424
  { IMAGE_SAMPLE_C_D_O_V4_V16_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x4, 0x10 }, // 5425
  { IMAGE_SAMPLE_C_D_O_V5_V4_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 5426
  { IMAGE_SAMPLE_C_D_O_V5_V5_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 5427
  { IMAGE_SAMPLE_C_D_O_V5_V6_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x5, 0x6 }, // 5428
  { IMAGE_SAMPLE_C_D_O_V5_V7_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x5, 0x7 }, // 5429
  { IMAGE_SAMPLE_C_D_O_V5_V8_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 5430
  { IMAGE_SAMPLE_C_D_O_V5_V16_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10Default, 0x5, 0x10 }, // 5431
  { IMAGE_SAMPLE_C_D_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x1, 0x4 }, // 5432
  { IMAGE_SAMPLE_C_D_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x1, 0x5 }, // 5433
  { IMAGE_SAMPLE_C_D_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x1, 0x6 }, // 5434
  { IMAGE_SAMPLE_C_D_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x1, 0x7 }, // 5435
  { IMAGE_SAMPLE_C_D_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x1, 0x8 }, // 5436
  { IMAGE_SAMPLE_C_D_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x1, 0x9 }, // 5437
  { IMAGE_SAMPLE_C_D_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x1, 0xA }, // 5438
  { IMAGE_SAMPLE_C_D_O_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x1, 0xB }, // 5439
  { IMAGE_SAMPLE_C_D_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 5440
  { IMAGE_SAMPLE_C_D_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 5441
  { IMAGE_SAMPLE_C_D_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x2, 0x6 }, // 5442
  { IMAGE_SAMPLE_C_D_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x2, 0x7 }, // 5443
  { IMAGE_SAMPLE_C_D_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x2, 0x8 }, // 5444
  { IMAGE_SAMPLE_C_D_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x2, 0x9 }, // 5445
  { IMAGE_SAMPLE_C_D_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x2, 0xA }, // 5446
  { IMAGE_SAMPLE_C_D_O_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x2, 0xB }, // 5447
  { IMAGE_SAMPLE_C_D_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x3, 0x4 }, // 5448
  { IMAGE_SAMPLE_C_D_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x3, 0x5 }, // 5449
  { IMAGE_SAMPLE_C_D_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x3, 0x6 }, // 5450
  { IMAGE_SAMPLE_C_D_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x3, 0x7 }, // 5451
  { IMAGE_SAMPLE_C_D_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x3, 0x8 }, // 5452
  { IMAGE_SAMPLE_C_D_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x3, 0x9 }, // 5453
  { IMAGE_SAMPLE_C_D_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x3, 0xA }, // 5454
  { IMAGE_SAMPLE_C_D_O_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x3, 0xB }, // 5455
  { IMAGE_SAMPLE_C_D_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 5456
  { IMAGE_SAMPLE_C_D_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 5457
  { IMAGE_SAMPLE_C_D_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x4, 0x6 }, // 5458
  { IMAGE_SAMPLE_C_D_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x4, 0x7 }, // 5459
  { IMAGE_SAMPLE_C_D_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x4, 0x8 }, // 5460
  { IMAGE_SAMPLE_C_D_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x4, 0x9 }, // 5461
  { IMAGE_SAMPLE_C_D_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x4, 0xA }, // 5462
  { IMAGE_SAMPLE_C_D_O_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x4, 0xB }, // 5463
  { IMAGE_SAMPLE_C_D_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 5464
  { IMAGE_SAMPLE_C_D_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 5465
  { IMAGE_SAMPLE_C_D_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x5, 0x6 }, // 5466
  { IMAGE_SAMPLE_C_D_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x5, 0x7 }, // 5467
  { IMAGE_SAMPLE_C_D_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x5, 0x8 }, // 5468
  { IMAGE_SAMPLE_C_D_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x5, 0x9 }, // 5469
  { IMAGE_SAMPLE_C_D_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x5, 0xA }, // 5470
  { IMAGE_SAMPLE_C_D_O_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_O, MIMGEncGfx10NSA, 0x5, 0xB }, // 5471
  { IMAGE_SAMPLE_C_D_O_V1_V4, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x1, 0x4 }, // 5472
  { IMAGE_SAMPLE_C_D_O_V1_V5, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x1, 0x5 }, // 5473
  { IMAGE_SAMPLE_C_D_O_V1_V6, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x1, 0x6 }, // 5474
  { IMAGE_SAMPLE_C_D_O_V1_V7, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x1, 0x7 }, // 5475
  { IMAGE_SAMPLE_C_D_O_V1_V8, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x1, 0x8 }, // 5476
  { IMAGE_SAMPLE_C_D_O_V1_V16, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x1, 0x10 }, // 5477
  { IMAGE_SAMPLE_C_D_O_V2_V4, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x2, 0x4 }, // 5478
  { IMAGE_SAMPLE_C_D_O_V2_V5, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x2, 0x5 }, // 5479
  { IMAGE_SAMPLE_C_D_O_V2_V6, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x2, 0x6 }, // 5480
  { IMAGE_SAMPLE_C_D_O_V2_V7, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x2, 0x7 }, // 5481
  { IMAGE_SAMPLE_C_D_O_V2_V8, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x2, 0x8 }, // 5482
  { IMAGE_SAMPLE_C_D_O_V2_V16, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x2, 0x10 }, // 5483
  { IMAGE_SAMPLE_C_D_O_V3_V4, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x3, 0x4 }, // 5484
  { IMAGE_SAMPLE_C_D_O_V3_V5, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x3, 0x5 }, // 5485
  { IMAGE_SAMPLE_C_D_O_V3_V6, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x3, 0x6 }, // 5486
  { IMAGE_SAMPLE_C_D_O_V3_V7, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x3, 0x7 }, // 5487
  { IMAGE_SAMPLE_C_D_O_V3_V8, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x3, 0x8 }, // 5488
  { IMAGE_SAMPLE_C_D_O_V3_V16, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x3, 0x10 }, // 5489
  { IMAGE_SAMPLE_C_D_O_V4_V4, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x4, 0x4 }, // 5490
  { IMAGE_SAMPLE_C_D_O_V4_V5, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x4, 0x5 }, // 5491
  { IMAGE_SAMPLE_C_D_O_V4_V6, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x4, 0x6 }, // 5492
  { IMAGE_SAMPLE_C_D_O_V4_V7, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x4, 0x7 }, // 5493
  { IMAGE_SAMPLE_C_D_O_V4_V8, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x4, 0x8 }, // 5494
  { IMAGE_SAMPLE_C_D_O_V4_V16, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x4, 0x10 }, // 5495
  { IMAGE_SAMPLE_C_D_O_V5_V4, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x5, 0x4 }, // 5496
  { IMAGE_SAMPLE_C_D_O_V5_V5, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x5, 0x5 }, // 5497
  { IMAGE_SAMPLE_C_D_O_V5_V6, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x5, 0x6 }, // 5498
  { IMAGE_SAMPLE_C_D_O_V5_V7, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x5, 0x7 }, // 5499
  { IMAGE_SAMPLE_C_D_O_V5_V8, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x5, 0x8 }, // 5500
  { IMAGE_SAMPLE_C_D_O_V5_V16, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x5, 0x10 }, // 5501
  { IMAGE_SAMPLE_C_D_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x1, 0x4 }, // 5502
  { IMAGE_SAMPLE_C_D_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x1, 0x5 }, // 5503
  { IMAGE_SAMPLE_C_D_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x1, 0x6 }, // 5504
  { IMAGE_SAMPLE_C_D_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x1, 0x7 }, // 5505
  { IMAGE_SAMPLE_C_D_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x1, 0x8 }, // 5506
  { IMAGE_SAMPLE_C_D_O_G16_V1_V16_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x1, 0x10 }, // 5507
  { IMAGE_SAMPLE_C_D_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x2, 0x4 }, // 5508
  { IMAGE_SAMPLE_C_D_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x2, 0x5 }, // 5509
  { IMAGE_SAMPLE_C_D_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x2, 0x6 }, // 5510
  { IMAGE_SAMPLE_C_D_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x2, 0x7 }, // 5511
  { IMAGE_SAMPLE_C_D_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x2, 0x8 }, // 5512
  { IMAGE_SAMPLE_C_D_O_G16_V2_V16_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x2, 0x10 }, // 5513
  { IMAGE_SAMPLE_C_D_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x3, 0x4 }, // 5514
  { IMAGE_SAMPLE_C_D_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x3, 0x5 }, // 5515
  { IMAGE_SAMPLE_C_D_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x3, 0x6 }, // 5516
  { IMAGE_SAMPLE_C_D_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x3, 0x7 }, // 5517
  { IMAGE_SAMPLE_C_D_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x3, 0x8 }, // 5518
  { IMAGE_SAMPLE_C_D_O_G16_V3_V16_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x3, 0x10 }, // 5519
  { IMAGE_SAMPLE_C_D_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x4, 0x4 }, // 5520
  { IMAGE_SAMPLE_C_D_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x4, 0x5 }, // 5521
  { IMAGE_SAMPLE_C_D_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x4, 0x6 }, // 5522
  { IMAGE_SAMPLE_C_D_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x4, 0x7 }, // 5523
  { IMAGE_SAMPLE_C_D_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x4, 0x8 }, // 5524
  { IMAGE_SAMPLE_C_D_O_G16_V4_V16_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x4, 0x10 }, // 5525
  { IMAGE_SAMPLE_C_D_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x5, 0x4 }, // 5526
  { IMAGE_SAMPLE_C_D_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x5, 0x5 }, // 5527
  { IMAGE_SAMPLE_C_D_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x5, 0x6 }, // 5528
  { IMAGE_SAMPLE_C_D_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x5, 0x7 }, // 5529
  { IMAGE_SAMPLE_C_D_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x5, 0x8 }, // 5530
  { IMAGE_SAMPLE_C_D_O_G16_V5_V16_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10Default, 0x5, 0x10 }, // 5531
  { IMAGE_SAMPLE_C_D_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x1, 0x4 }, // 5532
  { IMAGE_SAMPLE_C_D_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x1, 0x5 }, // 5533
  { IMAGE_SAMPLE_C_D_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x1, 0x6 }, // 5534
  { IMAGE_SAMPLE_C_D_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x1, 0x7 }, // 5535
  { IMAGE_SAMPLE_C_D_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x1, 0x8 }, // 5536
  { IMAGE_SAMPLE_C_D_O_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x1, 0x9 }, // 5537
  { IMAGE_SAMPLE_C_D_O_G16_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x1, 0xA }, // 5538
  { IMAGE_SAMPLE_C_D_O_G16_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x1, 0xB }, // 5539
  { IMAGE_SAMPLE_C_D_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x2, 0x4 }, // 5540
  { IMAGE_SAMPLE_C_D_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x2, 0x5 }, // 5541
  { IMAGE_SAMPLE_C_D_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x2, 0x6 }, // 5542
  { IMAGE_SAMPLE_C_D_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x2, 0x7 }, // 5543
  { IMAGE_SAMPLE_C_D_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x2, 0x8 }, // 5544
  { IMAGE_SAMPLE_C_D_O_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x2, 0x9 }, // 5545
  { IMAGE_SAMPLE_C_D_O_G16_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x2, 0xA }, // 5546
  { IMAGE_SAMPLE_C_D_O_G16_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x2, 0xB }, // 5547
  { IMAGE_SAMPLE_C_D_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x3, 0x4 }, // 5548
  { IMAGE_SAMPLE_C_D_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x3, 0x5 }, // 5549
  { IMAGE_SAMPLE_C_D_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x3, 0x6 }, // 5550
  { IMAGE_SAMPLE_C_D_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x3, 0x7 }, // 5551
  { IMAGE_SAMPLE_C_D_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x3, 0x8 }, // 5552
  { IMAGE_SAMPLE_C_D_O_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x3, 0x9 }, // 5553
  { IMAGE_SAMPLE_C_D_O_G16_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x3, 0xA }, // 5554
  { IMAGE_SAMPLE_C_D_O_G16_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x3, 0xB }, // 5555
  { IMAGE_SAMPLE_C_D_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x4, 0x4 }, // 5556
  { IMAGE_SAMPLE_C_D_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x4, 0x5 }, // 5557
  { IMAGE_SAMPLE_C_D_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x4, 0x6 }, // 5558
  { IMAGE_SAMPLE_C_D_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x4, 0x7 }, // 5559
  { IMAGE_SAMPLE_C_D_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x4, 0x8 }, // 5560
  { IMAGE_SAMPLE_C_D_O_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x4, 0x9 }, // 5561
  { IMAGE_SAMPLE_C_D_O_G16_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x4, 0xA }, // 5562
  { IMAGE_SAMPLE_C_D_O_G16_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x4, 0xB }, // 5563
  { IMAGE_SAMPLE_C_D_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x5, 0x4 }, // 5564
  { IMAGE_SAMPLE_C_D_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x5, 0x5 }, // 5565
  { IMAGE_SAMPLE_C_D_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x5, 0x6 }, // 5566
  { IMAGE_SAMPLE_C_D_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x5, 0x7 }, // 5567
  { IMAGE_SAMPLE_C_D_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x5, 0x8 }, // 5568
  { IMAGE_SAMPLE_C_D_O_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x5, 0x9 }, // 5569
  { IMAGE_SAMPLE_C_D_O_G16_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x5, 0xA }, // 5570
  { IMAGE_SAMPLE_C_D_O_G16_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx10NSA, 0x5, 0xB }, // 5571
  { IMAGE_SAMPLE_C_D_O_G16_V1_V4, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x1, 0x4 }, // 5572
  { IMAGE_SAMPLE_C_D_O_G16_V1_V5, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x1, 0x5 }, // 5573
  { IMAGE_SAMPLE_C_D_O_G16_V1_V6, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x1, 0x6 }, // 5574
  { IMAGE_SAMPLE_C_D_O_G16_V1_V7, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x1, 0x7 }, // 5575
  { IMAGE_SAMPLE_C_D_O_G16_V1_V8, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x1, 0x8 }, // 5576
  { IMAGE_SAMPLE_C_D_O_G16_V1_V16, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x1, 0x10 }, // 5577
  { IMAGE_SAMPLE_C_D_O_G16_V2_V4, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x2, 0x4 }, // 5578
  { IMAGE_SAMPLE_C_D_O_G16_V2_V5, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x2, 0x5 }, // 5579
  { IMAGE_SAMPLE_C_D_O_G16_V2_V6, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x2, 0x6 }, // 5580
  { IMAGE_SAMPLE_C_D_O_G16_V2_V7, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x2, 0x7 }, // 5581
  { IMAGE_SAMPLE_C_D_O_G16_V2_V8, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x2, 0x8 }, // 5582
  { IMAGE_SAMPLE_C_D_O_G16_V2_V16, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x2, 0x10 }, // 5583
  { IMAGE_SAMPLE_C_D_O_G16_V3_V4, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x3, 0x4 }, // 5584
  { IMAGE_SAMPLE_C_D_O_G16_V3_V5, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x3, 0x5 }, // 5585
  { IMAGE_SAMPLE_C_D_O_G16_V3_V6, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x3, 0x6 }, // 5586
  { IMAGE_SAMPLE_C_D_O_G16_V3_V7, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x3, 0x7 }, // 5587
  { IMAGE_SAMPLE_C_D_O_G16_V3_V8, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x3, 0x8 }, // 5588
  { IMAGE_SAMPLE_C_D_O_G16_V3_V16, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x3, 0x10 }, // 5589
  { IMAGE_SAMPLE_C_D_O_G16_V4_V4, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x4, 0x4 }, // 5590
  { IMAGE_SAMPLE_C_D_O_G16_V4_V5, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x4, 0x5 }, // 5591
  { IMAGE_SAMPLE_C_D_O_G16_V4_V6, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x4, 0x6 }, // 5592
  { IMAGE_SAMPLE_C_D_O_G16_V4_V7, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x4, 0x7 }, // 5593
  { IMAGE_SAMPLE_C_D_O_G16_V4_V8, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x4, 0x8 }, // 5594
  { IMAGE_SAMPLE_C_D_O_G16_V4_V16, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x4, 0x10 }, // 5595
  { IMAGE_SAMPLE_C_D_O_G16_V5_V4, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x5, 0x4 }, // 5596
  { IMAGE_SAMPLE_C_D_O_G16_V5_V5, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x5, 0x5 }, // 5597
  { IMAGE_SAMPLE_C_D_O_G16_V5_V6, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x5, 0x6 }, // 5598
  { IMAGE_SAMPLE_C_D_O_G16_V5_V7, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x5, 0x7 }, // 5599
  { IMAGE_SAMPLE_C_D_O_G16_V5_V8, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x5, 0x8 }, // 5600
  { IMAGE_SAMPLE_C_D_O_G16_V5_V16, IMAGE_SAMPLE_C_D_O_G16, MIMGEncGfx6, 0x5, 0x10 }, // 5601
  { IMAGE_SAMPLE_C_L_V1_V2_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x1, 0x2 }, // 5602
  { IMAGE_SAMPLE_C_L_V1_V3_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x1, 0x3 }, // 5603
  { IMAGE_SAMPLE_C_L_V1_V4_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x1, 0x4 }, // 5604
  { IMAGE_SAMPLE_C_L_V1_V5_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x1, 0x5 }, // 5605
  { IMAGE_SAMPLE_C_L_V1_V8_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x1, 0x8 }, // 5606
  { IMAGE_SAMPLE_C_L_V2_V2_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x2, 0x2 }, // 5607
  { IMAGE_SAMPLE_C_L_V2_V3_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x2, 0x3 }, // 5608
  { IMAGE_SAMPLE_C_L_V2_V4_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x2, 0x4 }, // 5609
  { IMAGE_SAMPLE_C_L_V2_V5_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x2, 0x5 }, // 5610
  { IMAGE_SAMPLE_C_L_V2_V8_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x2, 0x8 }, // 5611
  { IMAGE_SAMPLE_C_L_V3_V2_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x3, 0x2 }, // 5612
  { IMAGE_SAMPLE_C_L_V3_V3_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x3, 0x3 }, // 5613
  { IMAGE_SAMPLE_C_L_V3_V4_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x3, 0x4 }, // 5614
  { IMAGE_SAMPLE_C_L_V3_V5_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x3, 0x5 }, // 5615
  { IMAGE_SAMPLE_C_L_V3_V8_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x3, 0x8 }, // 5616
  { IMAGE_SAMPLE_C_L_V4_V2_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x4, 0x2 }, // 5617
  { IMAGE_SAMPLE_C_L_V4_V3_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x4, 0x3 }, // 5618
  { IMAGE_SAMPLE_C_L_V4_V4_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x4, 0x4 }, // 5619
  { IMAGE_SAMPLE_C_L_V4_V5_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x4, 0x5 }, // 5620
  { IMAGE_SAMPLE_C_L_V4_V8_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x4, 0x8 }, // 5621
  { IMAGE_SAMPLE_C_L_V5_V2_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x5, 0x2 }, // 5622
  { IMAGE_SAMPLE_C_L_V5_V3_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x5, 0x3 }, // 5623
  { IMAGE_SAMPLE_C_L_V5_V4_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x5, 0x4 }, // 5624
  { IMAGE_SAMPLE_C_L_V5_V5_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x5, 0x5 }, // 5625
  { IMAGE_SAMPLE_C_L_V5_V8_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10Default, 0x5, 0x8 }, // 5626
  { IMAGE_SAMPLE_C_L_V1_V2_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x1, 0x2 }, // 5627
  { IMAGE_SAMPLE_C_L_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x1, 0x3 }, // 5628
  { IMAGE_SAMPLE_C_L_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x1, 0x4 }, // 5629
  { IMAGE_SAMPLE_C_L_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x1, 0x5 }, // 5630
  { IMAGE_SAMPLE_C_L_V2_V2_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x2, 0x2 }, // 5631
  { IMAGE_SAMPLE_C_L_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x2, 0x3 }, // 5632
  { IMAGE_SAMPLE_C_L_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x2, 0x4 }, // 5633
  { IMAGE_SAMPLE_C_L_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x2, 0x5 }, // 5634
  { IMAGE_SAMPLE_C_L_V3_V2_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x3, 0x2 }, // 5635
  { IMAGE_SAMPLE_C_L_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x3, 0x3 }, // 5636
  { IMAGE_SAMPLE_C_L_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x3, 0x4 }, // 5637
  { IMAGE_SAMPLE_C_L_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x3, 0x5 }, // 5638
  { IMAGE_SAMPLE_C_L_V4_V2_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x4, 0x2 }, // 5639
  { IMAGE_SAMPLE_C_L_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x4, 0x3 }, // 5640
  { IMAGE_SAMPLE_C_L_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x4, 0x4 }, // 5641
  { IMAGE_SAMPLE_C_L_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x4, 0x5 }, // 5642
  { IMAGE_SAMPLE_C_L_V5_V2_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x5, 0x2 }, // 5643
  { IMAGE_SAMPLE_C_L_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x5, 0x3 }, // 5644
  { IMAGE_SAMPLE_C_L_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x5, 0x4 }, // 5645
  { IMAGE_SAMPLE_C_L_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_L, MIMGEncGfx10NSA, 0x5, 0x5 }, // 5646
  { IMAGE_SAMPLE_C_L_V1_V2, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x1, 0x2 }, // 5647
  { IMAGE_SAMPLE_C_L_V1_V3, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x1, 0x3 }, // 5648
  { IMAGE_SAMPLE_C_L_V1_V4, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x1, 0x4 }, // 5649
  { IMAGE_SAMPLE_C_L_V1_V5, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x1, 0x5 }, // 5650
  { IMAGE_SAMPLE_C_L_V1_V8, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x1, 0x8 }, // 5651
  { IMAGE_SAMPLE_C_L_V2_V2, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x2, 0x2 }, // 5652
  { IMAGE_SAMPLE_C_L_V2_V3, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x2, 0x3 }, // 5653
  { IMAGE_SAMPLE_C_L_V2_V4, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x2, 0x4 }, // 5654
  { IMAGE_SAMPLE_C_L_V2_V5, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x2, 0x5 }, // 5655
  { IMAGE_SAMPLE_C_L_V2_V8, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x2, 0x8 }, // 5656
  { IMAGE_SAMPLE_C_L_V3_V2, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x3, 0x2 }, // 5657
  { IMAGE_SAMPLE_C_L_V3_V3, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x3, 0x3 }, // 5658
  { IMAGE_SAMPLE_C_L_V3_V4, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x3, 0x4 }, // 5659
  { IMAGE_SAMPLE_C_L_V3_V5, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x3, 0x5 }, // 5660
  { IMAGE_SAMPLE_C_L_V3_V8, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x3, 0x8 }, // 5661
  { IMAGE_SAMPLE_C_L_V4_V2, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x4, 0x2 }, // 5662
  { IMAGE_SAMPLE_C_L_V4_V3, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x4, 0x3 }, // 5663
  { IMAGE_SAMPLE_C_L_V4_V4, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x4, 0x4 }, // 5664
  { IMAGE_SAMPLE_C_L_V4_V5, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x4, 0x5 }, // 5665
  { IMAGE_SAMPLE_C_L_V4_V8, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x4, 0x8 }, // 5666
  { IMAGE_SAMPLE_C_L_V5_V2, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x5, 0x2 }, // 5667
  { IMAGE_SAMPLE_C_L_V5_V3, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x5, 0x3 }, // 5668
  { IMAGE_SAMPLE_C_L_V5_V4, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x5, 0x4 }, // 5669
  { IMAGE_SAMPLE_C_L_V5_V5, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x5, 0x5 }, // 5670
  { IMAGE_SAMPLE_C_L_V5_V8, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x5, 0x8 }, // 5671
  { IMAGE_SAMPLE_C_LZ_V1_V2_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x1, 0x2 }, // 5672
  { IMAGE_SAMPLE_C_LZ_V1_V3_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x1, 0x3 }, // 5673
  { IMAGE_SAMPLE_C_LZ_V1_V4_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x1, 0x4 }, // 5674
  { IMAGE_SAMPLE_C_LZ_V2_V2_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x2, 0x2 }, // 5675
  { IMAGE_SAMPLE_C_LZ_V2_V3_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x2, 0x3 }, // 5676
  { IMAGE_SAMPLE_C_LZ_V2_V4_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x2, 0x4 }, // 5677
  { IMAGE_SAMPLE_C_LZ_V3_V2_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x3, 0x2 }, // 5678
  { IMAGE_SAMPLE_C_LZ_V3_V3_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x3, 0x3 }, // 5679
  { IMAGE_SAMPLE_C_LZ_V3_V4_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x3, 0x4 }, // 5680
  { IMAGE_SAMPLE_C_LZ_V4_V2_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x4, 0x2 }, // 5681
  { IMAGE_SAMPLE_C_LZ_V4_V3_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x4, 0x3 }, // 5682
  { IMAGE_SAMPLE_C_LZ_V4_V4_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x4, 0x4 }, // 5683
  { IMAGE_SAMPLE_C_LZ_V5_V2_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x5, 0x2 }, // 5684
  { IMAGE_SAMPLE_C_LZ_V5_V3_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x5, 0x3 }, // 5685
  { IMAGE_SAMPLE_C_LZ_V5_V4_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10Default, 0x5, 0x4 }, // 5686
  { IMAGE_SAMPLE_C_LZ_V1_V2_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x1, 0x2 }, // 5687
  { IMAGE_SAMPLE_C_LZ_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x1, 0x3 }, // 5688
  { IMAGE_SAMPLE_C_LZ_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x1, 0x4 }, // 5689
  { IMAGE_SAMPLE_C_LZ_V2_V2_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x2, 0x2 }, // 5690
  { IMAGE_SAMPLE_C_LZ_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x2, 0x3 }, // 5691
  { IMAGE_SAMPLE_C_LZ_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x2, 0x4 }, // 5692
  { IMAGE_SAMPLE_C_LZ_V3_V2_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x3, 0x2 }, // 5693
  { IMAGE_SAMPLE_C_LZ_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x3, 0x3 }, // 5694
  { IMAGE_SAMPLE_C_LZ_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x3, 0x4 }, // 5695
  { IMAGE_SAMPLE_C_LZ_V4_V2_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x4, 0x2 }, // 5696
  { IMAGE_SAMPLE_C_LZ_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x4, 0x3 }, // 5697
  { IMAGE_SAMPLE_C_LZ_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x4, 0x4 }, // 5698
  { IMAGE_SAMPLE_C_LZ_V5_V2_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x5, 0x2 }, // 5699
  { IMAGE_SAMPLE_C_LZ_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x5, 0x3 }, // 5700
  { IMAGE_SAMPLE_C_LZ_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_LZ, MIMGEncGfx10NSA, 0x5, 0x4 }, // 5701
  { IMAGE_SAMPLE_C_LZ_V1_V2, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x1, 0x2 }, // 5702
  { IMAGE_SAMPLE_C_LZ_V1_V3, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x1, 0x3 }, // 5703
  { IMAGE_SAMPLE_C_LZ_V1_V4, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x1, 0x4 }, // 5704
  { IMAGE_SAMPLE_C_LZ_V2_V2, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x2, 0x2 }, // 5705
  { IMAGE_SAMPLE_C_LZ_V2_V3, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x2, 0x3 }, // 5706
  { IMAGE_SAMPLE_C_LZ_V2_V4, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x2, 0x4 }, // 5707
  { IMAGE_SAMPLE_C_LZ_V3_V2, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x3, 0x2 }, // 5708
  { IMAGE_SAMPLE_C_LZ_V3_V3, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x3, 0x3 }, // 5709
  { IMAGE_SAMPLE_C_LZ_V3_V4, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x3, 0x4 }, // 5710
  { IMAGE_SAMPLE_C_LZ_V4_V2, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x4, 0x2 }, // 5711
  { IMAGE_SAMPLE_C_LZ_V4_V3, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x4, 0x3 }, // 5712
  { IMAGE_SAMPLE_C_LZ_V4_V4, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x4, 0x4 }, // 5713
  { IMAGE_SAMPLE_C_LZ_V5_V2, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x5, 0x2 }, // 5714
  { IMAGE_SAMPLE_C_LZ_V5_V3, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x5, 0x3 }, // 5715
  { IMAGE_SAMPLE_C_LZ_V5_V4, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x5, 0x4 }, // 5716
  { IMAGE_SAMPLE_C_LZ_O_V1_V3_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x1, 0x3 }, // 5717
  { IMAGE_SAMPLE_C_LZ_O_V1_V4_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x1, 0x4 }, // 5718
  { IMAGE_SAMPLE_C_LZ_O_V1_V5_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x1, 0x5 }, // 5719
  { IMAGE_SAMPLE_C_LZ_O_V1_V8_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x1, 0x8 }, // 5720
  { IMAGE_SAMPLE_C_LZ_O_V2_V3_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 5721
  { IMAGE_SAMPLE_C_LZ_O_V2_V4_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 5722
  { IMAGE_SAMPLE_C_LZ_O_V2_V5_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 5723
  { IMAGE_SAMPLE_C_LZ_O_V2_V8_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 5724
  { IMAGE_SAMPLE_C_LZ_O_V3_V3_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x3, 0x3 }, // 5725
  { IMAGE_SAMPLE_C_LZ_O_V3_V4_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x3, 0x4 }, // 5726
  { IMAGE_SAMPLE_C_LZ_O_V3_V5_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x3, 0x5 }, // 5727
  { IMAGE_SAMPLE_C_LZ_O_V3_V8_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x3, 0x8 }, // 5728
  { IMAGE_SAMPLE_C_LZ_O_V4_V3_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 5729
  { IMAGE_SAMPLE_C_LZ_O_V4_V4_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 5730
  { IMAGE_SAMPLE_C_LZ_O_V4_V5_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 5731
  { IMAGE_SAMPLE_C_LZ_O_V4_V8_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 5732
  { IMAGE_SAMPLE_C_LZ_O_V5_V3_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 5733
  { IMAGE_SAMPLE_C_LZ_O_V5_V4_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 5734
  { IMAGE_SAMPLE_C_LZ_O_V5_V5_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 5735
  { IMAGE_SAMPLE_C_LZ_O_V5_V8_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 5736
  { IMAGE_SAMPLE_C_LZ_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x1, 0x3 }, // 5737
  { IMAGE_SAMPLE_C_LZ_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x1, 0x4 }, // 5738
  { IMAGE_SAMPLE_C_LZ_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x1, 0x5 }, // 5739
  { IMAGE_SAMPLE_C_LZ_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 5740
  { IMAGE_SAMPLE_C_LZ_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 5741
  { IMAGE_SAMPLE_C_LZ_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 5742
  { IMAGE_SAMPLE_C_LZ_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x3, 0x3 }, // 5743
  { IMAGE_SAMPLE_C_LZ_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x3, 0x4 }, // 5744
  { IMAGE_SAMPLE_C_LZ_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x3, 0x5 }, // 5745
  { IMAGE_SAMPLE_C_LZ_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 5746
  { IMAGE_SAMPLE_C_LZ_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 5747
  { IMAGE_SAMPLE_C_LZ_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 5748
  { IMAGE_SAMPLE_C_LZ_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 5749
  { IMAGE_SAMPLE_C_LZ_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 5750
  { IMAGE_SAMPLE_C_LZ_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 5751
  { IMAGE_SAMPLE_C_LZ_O_V1_V3, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x1, 0x3 }, // 5752
  { IMAGE_SAMPLE_C_LZ_O_V1_V4, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x1, 0x4 }, // 5753
  { IMAGE_SAMPLE_C_LZ_O_V1_V5, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x1, 0x5 }, // 5754
  { IMAGE_SAMPLE_C_LZ_O_V1_V8, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x1, 0x8 }, // 5755
  { IMAGE_SAMPLE_C_LZ_O_V2_V3, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x2, 0x3 }, // 5756
  { IMAGE_SAMPLE_C_LZ_O_V2_V4, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x2, 0x4 }, // 5757
  { IMAGE_SAMPLE_C_LZ_O_V2_V5, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x2, 0x5 }, // 5758
  { IMAGE_SAMPLE_C_LZ_O_V2_V8, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x2, 0x8 }, // 5759
  { IMAGE_SAMPLE_C_LZ_O_V3_V3, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x3, 0x3 }, // 5760
  { IMAGE_SAMPLE_C_LZ_O_V3_V4, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x3, 0x4 }, // 5761
  { IMAGE_SAMPLE_C_LZ_O_V3_V5, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x3, 0x5 }, // 5762
  { IMAGE_SAMPLE_C_LZ_O_V3_V8, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x3, 0x8 }, // 5763
  { IMAGE_SAMPLE_C_LZ_O_V4_V3, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x4, 0x3 }, // 5764
  { IMAGE_SAMPLE_C_LZ_O_V4_V4, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x4, 0x4 }, // 5765
  { IMAGE_SAMPLE_C_LZ_O_V4_V5, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x4, 0x5 }, // 5766
  { IMAGE_SAMPLE_C_LZ_O_V4_V8, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x4, 0x8 }, // 5767
  { IMAGE_SAMPLE_C_LZ_O_V5_V3, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x5, 0x3 }, // 5768
  { IMAGE_SAMPLE_C_LZ_O_V5_V4, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x5, 0x4 }, // 5769
  { IMAGE_SAMPLE_C_LZ_O_V5_V5, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x5, 0x5 }, // 5770
  { IMAGE_SAMPLE_C_LZ_O_V5_V8, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x5, 0x8 }, // 5771
  { IMAGE_SAMPLE_C_L_O_V1_V3_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x1, 0x3 }, // 5772
  { IMAGE_SAMPLE_C_L_O_V1_V4_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x1, 0x4 }, // 5773
  { IMAGE_SAMPLE_C_L_O_V1_V5_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x1, 0x5 }, // 5774
  { IMAGE_SAMPLE_C_L_O_V1_V6_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x1, 0x6 }, // 5775
  { IMAGE_SAMPLE_C_L_O_V1_V8_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x1, 0x8 }, // 5776
  { IMAGE_SAMPLE_C_L_O_V2_V3_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 5777
  { IMAGE_SAMPLE_C_L_O_V2_V4_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 5778
  { IMAGE_SAMPLE_C_L_O_V2_V5_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 5779
  { IMAGE_SAMPLE_C_L_O_V2_V6_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x2, 0x6 }, // 5780
  { IMAGE_SAMPLE_C_L_O_V2_V8_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 5781
  { IMAGE_SAMPLE_C_L_O_V3_V3_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x3, 0x3 }, // 5782
  { IMAGE_SAMPLE_C_L_O_V3_V4_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x3, 0x4 }, // 5783
  { IMAGE_SAMPLE_C_L_O_V3_V5_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x3, 0x5 }, // 5784
  { IMAGE_SAMPLE_C_L_O_V3_V6_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x3, 0x6 }, // 5785
  { IMAGE_SAMPLE_C_L_O_V3_V8_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x3, 0x8 }, // 5786
  { IMAGE_SAMPLE_C_L_O_V4_V3_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 5787
  { IMAGE_SAMPLE_C_L_O_V4_V4_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 5788
  { IMAGE_SAMPLE_C_L_O_V4_V5_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 5789
  { IMAGE_SAMPLE_C_L_O_V4_V6_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x4, 0x6 }, // 5790
  { IMAGE_SAMPLE_C_L_O_V4_V8_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 5791
  { IMAGE_SAMPLE_C_L_O_V5_V3_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 5792
  { IMAGE_SAMPLE_C_L_O_V5_V4_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 5793
  { IMAGE_SAMPLE_C_L_O_V5_V5_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 5794
  { IMAGE_SAMPLE_C_L_O_V5_V6_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x5, 0x6 }, // 5795
  { IMAGE_SAMPLE_C_L_O_V5_V8_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 5796
  { IMAGE_SAMPLE_C_L_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x1, 0x3 }, // 5797
  { IMAGE_SAMPLE_C_L_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x1, 0x4 }, // 5798
  { IMAGE_SAMPLE_C_L_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x1, 0x5 }, // 5799
  { IMAGE_SAMPLE_C_L_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x1, 0x6 }, // 5800
  { IMAGE_SAMPLE_C_L_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 5801
  { IMAGE_SAMPLE_C_L_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 5802
  { IMAGE_SAMPLE_C_L_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 5803
  { IMAGE_SAMPLE_C_L_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x2, 0x6 }, // 5804
  { IMAGE_SAMPLE_C_L_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x3, 0x3 }, // 5805
  { IMAGE_SAMPLE_C_L_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x3, 0x4 }, // 5806
  { IMAGE_SAMPLE_C_L_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x3, 0x5 }, // 5807
  { IMAGE_SAMPLE_C_L_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x3, 0x6 }, // 5808
  { IMAGE_SAMPLE_C_L_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 5809
  { IMAGE_SAMPLE_C_L_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 5810
  { IMAGE_SAMPLE_C_L_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 5811
  { IMAGE_SAMPLE_C_L_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x4, 0x6 }, // 5812
  { IMAGE_SAMPLE_C_L_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 5813
  { IMAGE_SAMPLE_C_L_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 5814
  { IMAGE_SAMPLE_C_L_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 5815
  { IMAGE_SAMPLE_C_L_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_L_O, MIMGEncGfx10NSA, 0x5, 0x6 }, // 5816
  { IMAGE_SAMPLE_C_L_O_V1_V3, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x1, 0x3 }, // 5817
  { IMAGE_SAMPLE_C_L_O_V1_V4, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x1, 0x4 }, // 5818
  { IMAGE_SAMPLE_C_L_O_V1_V5, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x1, 0x5 }, // 5819
  { IMAGE_SAMPLE_C_L_O_V1_V6, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x1, 0x6 }, // 5820
  { IMAGE_SAMPLE_C_L_O_V1_V8, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x1, 0x8 }, // 5821
  { IMAGE_SAMPLE_C_L_O_V2_V3, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x2, 0x3 }, // 5822
  { IMAGE_SAMPLE_C_L_O_V2_V4, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x2, 0x4 }, // 5823
  { IMAGE_SAMPLE_C_L_O_V2_V5, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x2, 0x5 }, // 5824
  { IMAGE_SAMPLE_C_L_O_V2_V6, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x2, 0x6 }, // 5825
  { IMAGE_SAMPLE_C_L_O_V2_V8, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x2, 0x8 }, // 5826
  { IMAGE_SAMPLE_C_L_O_V3_V3, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x3, 0x3 }, // 5827
  { IMAGE_SAMPLE_C_L_O_V3_V4, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x3, 0x4 }, // 5828
  { IMAGE_SAMPLE_C_L_O_V3_V5, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x3, 0x5 }, // 5829
  { IMAGE_SAMPLE_C_L_O_V3_V6, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x3, 0x6 }, // 5830
  { IMAGE_SAMPLE_C_L_O_V3_V8, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x3, 0x8 }, // 5831
  { IMAGE_SAMPLE_C_L_O_V4_V3, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x4, 0x3 }, // 5832
  { IMAGE_SAMPLE_C_L_O_V4_V4, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x4, 0x4 }, // 5833
  { IMAGE_SAMPLE_C_L_O_V4_V5, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x4, 0x5 }, // 5834
  { IMAGE_SAMPLE_C_L_O_V4_V6, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x4, 0x6 }, // 5835
  { IMAGE_SAMPLE_C_L_O_V4_V8, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x4, 0x8 }, // 5836
  { IMAGE_SAMPLE_C_L_O_V5_V3, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x5, 0x3 }, // 5837
  { IMAGE_SAMPLE_C_L_O_V5_V4, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x5, 0x4 }, // 5838
  { IMAGE_SAMPLE_C_L_O_V5_V5, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x5, 0x5 }, // 5839
  { IMAGE_SAMPLE_C_L_O_V5_V6, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x5, 0x6 }, // 5840
  { IMAGE_SAMPLE_C_L_O_V5_V8, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x5, 0x8 }, // 5841
  { IMAGE_SAMPLE_C_O_V1_V3_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x1, 0x3 }, // 5842
  { IMAGE_SAMPLE_C_O_V1_V4_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x1, 0x4 }, // 5843
  { IMAGE_SAMPLE_C_O_V1_V5_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x1, 0x5 }, // 5844
  { IMAGE_SAMPLE_C_O_V1_V8_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x1, 0x8 }, // 5845
  { IMAGE_SAMPLE_C_O_V2_V3_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 5846
  { IMAGE_SAMPLE_C_O_V2_V4_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 5847
  { IMAGE_SAMPLE_C_O_V2_V5_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 5848
  { IMAGE_SAMPLE_C_O_V2_V8_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 5849
  { IMAGE_SAMPLE_C_O_V3_V3_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x3, 0x3 }, // 5850
  { IMAGE_SAMPLE_C_O_V3_V4_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x3, 0x4 }, // 5851
  { IMAGE_SAMPLE_C_O_V3_V5_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x3, 0x5 }, // 5852
  { IMAGE_SAMPLE_C_O_V3_V8_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x3, 0x8 }, // 5853
  { IMAGE_SAMPLE_C_O_V4_V3_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 5854
  { IMAGE_SAMPLE_C_O_V4_V4_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 5855
  { IMAGE_SAMPLE_C_O_V4_V5_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 5856
  { IMAGE_SAMPLE_C_O_V4_V8_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 5857
  { IMAGE_SAMPLE_C_O_V5_V3_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 5858
  { IMAGE_SAMPLE_C_O_V5_V4_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 5859
  { IMAGE_SAMPLE_C_O_V5_V5_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 5860
  { IMAGE_SAMPLE_C_O_V5_V8_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 5861
  { IMAGE_SAMPLE_C_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x1, 0x3 }, // 5862
  { IMAGE_SAMPLE_C_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x1, 0x4 }, // 5863
  { IMAGE_SAMPLE_C_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x1, 0x5 }, // 5864
  { IMAGE_SAMPLE_C_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 5865
  { IMAGE_SAMPLE_C_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 5866
  { IMAGE_SAMPLE_C_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 5867
  { IMAGE_SAMPLE_C_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x3, 0x3 }, // 5868
  { IMAGE_SAMPLE_C_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x3, 0x4 }, // 5869
  { IMAGE_SAMPLE_C_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x3, 0x5 }, // 5870
  { IMAGE_SAMPLE_C_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 5871
  { IMAGE_SAMPLE_C_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 5872
  { IMAGE_SAMPLE_C_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 5873
  { IMAGE_SAMPLE_C_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 5874
  { IMAGE_SAMPLE_C_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 5875
  { IMAGE_SAMPLE_C_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 5876
  { IMAGE_SAMPLE_C_O_V1_V3, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x1, 0x3 }, // 5877
  { IMAGE_SAMPLE_C_O_V1_V4, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x1, 0x4 }, // 5878
  { IMAGE_SAMPLE_C_O_V1_V5, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x1, 0x5 }, // 5879
  { IMAGE_SAMPLE_C_O_V1_V8, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x1, 0x8 }, // 5880
  { IMAGE_SAMPLE_C_O_V2_V3, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x2, 0x3 }, // 5881
  { IMAGE_SAMPLE_C_O_V2_V4, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x2, 0x4 }, // 5882
  { IMAGE_SAMPLE_C_O_V2_V5, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x2, 0x5 }, // 5883
  { IMAGE_SAMPLE_C_O_V2_V8, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x2, 0x8 }, // 5884
  { IMAGE_SAMPLE_C_O_V3_V3, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x3, 0x3 }, // 5885
  { IMAGE_SAMPLE_C_O_V3_V4, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x3, 0x4 }, // 5886
  { IMAGE_SAMPLE_C_O_V3_V5, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x3, 0x5 }, // 5887
  { IMAGE_SAMPLE_C_O_V3_V8, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x3, 0x8 }, // 5888
  { IMAGE_SAMPLE_C_O_V4_V3, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x4, 0x3 }, // 5889
  { IMAGE_SAMPLE_C_O_V4_V4, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x4, 0x4 }, // 5890
  { IMAGE_SAMPLE_C_O_V4_V5, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x4, 0x5 }, // 5891
  { IMAGE_SAMPLE_C_O_V4_V8, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x4, 0x8 }, // 5892
  { IMAGE_SAMPLE_C_O_V5_V3, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x5, 0x3 }, // 5893
  { IMAGE_SAMPLE_C_O_V5_V4, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x5, 0x4 }, // 5894
  { IMAGE_SAMPLE_C_O_V5_V5, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x5, 0x5 }, // 5895
  { IMAGE_SAMPLE_C_O_V5_V8, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x5, 0x8 }, // 5896
  { IMAGE_SAMPLE_D_V1_V2_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x1, 0x2 }, // 5897
  { IMAGE_SAMPLE_D_V1_V3_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x1, 0x3 }, // 5898
  { IMAGE_SAMPLE_D_V1_V4_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x1, 0x4 }, // 5899
  { IMAGE_SAMPLE_D_V1_V5_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x1, 0x5 }, // 5900
  { IMAGE_SAMPLE_D_V1_V6_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x1, 0x6 }, // 5901
  { IMAGE_SAMPLE_D_V1_V7_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x1, 0x7 }, // 5902
  { IMAGE_SAMPLE_D_V1_V8_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x1, 0x8 }, // 5903
  { IMAGE_SAMPLE_D_V1_V16_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x1, 0x10 }, // 5904
  { IMAGE_SAMPLE_D_V2_V2_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x2, 0x2 }, // 5905
  { IMAGE_SAMPLE_D_V2_V3_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x2, 0x3 }, // 5906
  { IMAGE_SAMPLE_D_V2_V4_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x2, 0x4 }, // 5907
  { IMAGE_SAMPLE_D_V2_V5_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x2, 0x5 }, // 5908
  { IMAGE_SAMPLE_D_V2_V6_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x2, 0x6 }, // 5909
  { IMAGE_SAMPLE_D_V2_V7_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x2, 0x7 }, // 5910
  { IMAGE_SAMPLE_D_V2_V8_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x2, 0x8 }, // 5911
  { IMAGE_SAMPLE_D_V2_V16_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x2, 0x10 }, // 5912
  { IMAGE_SAMPLE_D_V3_V2_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x3, 0x2 }, // 5913
  { IMAGE_SAMPLE_D_V3_V3_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x3, 0x3 }, // 5914
  { IMAGE_SAMPLE_D_V3_V4_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x3, 0x4 }, // 5915
  { IMAGE_SAMPLE_D_V3_V5_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x3, 0x5 }, // 5916
  { IMAGE_SAMPLE_D_V3_V6_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x3, 0x6 }, // 5917
  { IMAGE_SAMPLE_D_V3_V7_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x3, 0x7 }, // 5918
  { IMAGE_SAMPLE_D_V3_V8_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x3, 0x8 }, // 5919
  { IMAGE_SAMPLE_D_V3_V16_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x3, 0x10 }, // 5920
  { IMAGE_SAMPLE_D_V4_V2_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x4, 0x2 }, // 5921
  { IMAGE_SAMPLE_D_V4_V3_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x4, 0x3 }, // 5922
  { IMAGE_SAMPLE_D_V4_V4_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x4, 0x4 }, // 5923
  { IMAGE_SAMPLE_D_V4_V5_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x4, 0x5 }, // 5924
  { IMAGE_SAMPLE_D_V4_V6_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x4, 0x6 }, // 5925
  { IMAGE_SAMPLE_D_V4_V7_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x4, 0x7 }, // 5926
  { IMAGE_SAMPLE_D_V4_V8_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x4, 0x8 }, // 5927
  { IMAGE_SAMPLE_D_V4_V16_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x4, 0x10 }, // 5928
  { IMAGE_SAMPLE_D_V5_V2_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x5, 0x2 }, // 5929
  { IMAGE_SAMPLE_D_V5_V3_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x5, 0x3 }, // 5930
  { IMAGE_SAMPLE_D_V5_V4_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x5, 0x4 }, // 5931
  { IMAGE_SAMPLE_D_V5_V5_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x5, 0x5 }, // 5932
  { IMAGE_SAMPLE_D_V5_V6_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x5, 0x6 }, // 5933
  { IMAGE_SAMPLE_D_V5_V7_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x5, 0x7 }, // 5934
  { IMAGE_SAMPLE_D_V5_V8_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x5, 0x8 }, // 5935
  { IMAGE_SAMPLE_D_V5_V16_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10Default, 0x5, 0x10 }, // 5936
  { IMAGE_SAMPLE_D_V1_V2_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x1, 0x2 }, // 5937
  { IMAGE_SAMPLE_D_V1_V3_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x1, 0x3 }, // 5938
  { IMAGE_SAMPLE_D_V1_V4_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x1, 0x4 }, // 5939
  { IMAGE_SAMPLE_D_V1_V5_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x1, 0x5 }, // 5940
  { IMAGE_SAMPLE_D_V1_V6_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x1, 0x6 }, // 5941
  { IMAGE_SAMPLE_D_V1_V7_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x1, 0x7 }, // 5942
  { IMAGE_SAMPLE_D_V1_V8_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x1, 0x8 }, // 5943
  { IMAGE_SAMPLE_D_V1_V9_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x1, 0x9 }, // 5944
  { IMAGE_SAMPLE_D_V2_V2_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x2, 0x2 }, // 5945
  { IMAGE_SAMPLE_D_V2_V3_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x2, 0x3 }, // 5946
  { IMAGE_SAMPLE_D_V2_V4_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x2, 0x4 }, // 5947
  { IMAGE_SAMPLE_D_V2_V5_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x2, 0x5 }, // 5948
  { IMAGE_SAMPLE_D_V2_V6_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x2, 0x6 }, // 5949
  { IMAGE_SAMPLE_D_V2_V7_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x2, 0x7 }, // 5950
  { IMAGE_SAMPLE_D_V2_V8_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x2, 0x8 }, // 5951
  { IMAGE_SAMPLE_D_V2_V9_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x2, 0x9 }, // 5952
  { IMAGE_SAMPLE_D_V3_V2_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x3, 0x2 }, // 5953
  { IMAGE_SAMPLE_D_V3_V3_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x3, 0x3 }, // 5954
  { IMAGE_SAMPLE_D_V3_V4_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x3, 0x4 }, // 5955
  { IMAGE_SAMPLE_D_V3_V5_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x3, 0x5 }, // 5956
  { IMAGE_SAMPLE_D_V3_V6_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x3, 0x6 }, // 5957
  { IMAGE_SAMPLE_D_V3_V7_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x3, 0x7 }, // 5958
  { IMAGE_SAMPLE_D_V3_V8_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x3, 0x8 }, // 5959
  { IMAGE_SAMPLE_D_V3_V9_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x3, 0x9 }, // 5960
  { IMAGE_SAMPLE_D_V4_V2_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x4, 0x2 }, // 5961
  { IMAGE_SAMPLE_D_V4_V3_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x4, 0x3 }, // 5962
  { IMAGE_SAMPLE_D_V4_V4_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x4, 0x4 }, // 5963
  { IMAGE_SAMPLE_D_V4_V5_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x4, 0x5 }, // 5964
  { IMAGE_SAMPLE_D_V4_V6_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x4, 0x6 }, // 5965
  { IMAGE_SAMPLE_D_V4_V7_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x4, 0x7 }, // 5966
  { IMAGE_SAMPLE_D_V4_V8_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x4, 0x8 }, // 5967
  { IMAGE_SAMPLE_D_V4_V9_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x4, 0x9 }, // 5968
  { IMAGE_SAMPLE_D_V5_V2_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x5, 0x2 }, // 5969
  { IMAGE_SAMPLE_D_V5_V3_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x5, 0x3 }, // 5970
  { IMAGE_SAMPLE_D_V5_V4_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x5, 0x4 }, // 5971
  { IMAGE_SAMPLE_D_V5_V5_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x5, 0x5 }, // 5972
  { IMAGE_SAMPLE_D_V5_V6_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x5, 0x6 }, // 5973
  { IMAGE_SAMPLE_D_V5_V7_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x5, 0x7 }, // 5974
  { IMAGE_SAMPLE_D_V5_V8_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x5, 0x8 }, // 5975
  { IMAGE_SAMPLE_D_V5_V9_nsa_gfx10, IMAGE_SAMPLE_D, MIMGEncGfx10NSA, 0x5, 0x9 }, // 5976
  { IMAGE_SAMPLE_D_V1_V2, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x1, 0x2 }, // 5977
  { IMAGE_SAMPLE_D_V1_V3, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x1, 0x3 }, // 5978
  { IMAGE_SAMPLE_D_V1_V4, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x1, 0x4 }, // 5979
  { IMAGE_SAMPLE_D_V1_V5, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x1, 0x5 }, // 5980
  { IMAGE_SAMPLE_D_V1_V6, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x1, 0x6 }, // 5981
  { IMAGE_SAMPLE_D_V1_V7, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x1, 0x7 }, // 5982
  { IMAGE_SAMPLE_D_V1_V8, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x1, 0x8 }, // 5983
  { IMAGE_SAMPLE_D_V1_V16, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x1, 0x10 }, // 5984
  { IMAGE_SAMPLE_D_V2_V2, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x2, 0x2 }, // 5985
  { IMAGE_SAMPLE_D_V2_V3, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x2, 0x3 }, // 5986
  { IMAGE_SAMPLE_D_V2_V4, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x2, 0x4 }, // 5987
  { IMAGE_SAMPLE_D_V2_V5, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x2, 0x5 }, // 5988
  { IMAGE_SAMPLE_D_V2_V6, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x2, 0x6 }, // 5989
  { IMAGE_SAMPLE_D_V2_V7, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x2, 0x7 }, // 5990
  { IMAGE_SAMPLE_D_V2_V8, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x2, 0x8 }, // 5991
  { IMAGE_SAMPLE_D_V2_V16, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x2, 0x10 }, // 5992
  { IMAGE_SAMPLE_D_V3_V2, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x3, 0x2 }, // 5993
  { IMAGE_SAMPLE_D_V3_V3, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x3, 0x3 }, // 5994
  { IMAGE_SAMPLE_D_V3_V4, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x3, 0x4 }, // 5995
  { IMAGE_SAMPLE_D_V3_V5, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x3, 0x5 }, // 5996
  { IMAGE_SAMPLE_D_V3_V6, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x3, 0x6 }, // 5997
  { IMAGE_SAMPLE_D_V3_V7, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x3, 0x7 }, // 5998
  { IMAGE_SAMPLE_D_V3_V8, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x3, 0x8 }, // 5999
  { IMAGE_SAMPLE_D_V3_V16, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x3, 0x10 }, // 6000
  { IMAGE_SAMPLE_D_V4_V2, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x4, 0x2 }, // 6001
  { IMAGE_SAMPLE_D_V4_V3, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x4, 0x3 }, // 6002
  { IMAGE_SAMPLE_D_V4_V4, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x4, 0x4 }, // 6003
  { IMAGE_SAMPLE_D_V4_V5, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x4, 0x5 }, // 6004
  { IMAGE_SAMPLE_D_V4_V6, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x4, 0x6 }, // 6005
  { IMAGE_SAMPLE_D_V4_V7, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x4, 0x7 }, // 6006
  { IMAGE_SAMPLE_D_V4_V8, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x4, 0x8 }, // 6007
  { IMAGE_SAMPLE_D_V4_V16, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x4, 0x10 }, // 6008
  { IMAGE_SAMPLE_D_V5_V2, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x5, 0x2 }, // 6009
  { IMAGE_SAMPLE_D_V5_V3, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x5, 0x3 }, // 6010
  { IMAGE_SAMPLE_D_V5_V4, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x5, 0x4 }, // 6011
  { IMAGE_SAMPLE_D_V5_V5, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x5, 0x5 }, // 6012
  { IMAGE_SAMPLE_D_V5_V6, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x5, 0x6 }, // 6013
  { IMAGE_SAMPLE_D_V5_V7, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x5, 0x7 }, // 6014
  { IMAGE_SAMPLE_D_V5_V8, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x5, 0x8 }, // 6015
  { IMAGE_SAMPLE_D_V5_V16, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x5, 0x10 }, // 6016
  { IMAGE_SAMPLE_D_CL_V1_V2_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x1, 0x2 }, // 6017
  { IMAGE_SAMPLE_D_CL_V1_V3_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x1, 0x3 }, // 6018
  { IMAGE_SAMPLE_D_CL_V1_V4_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x1, 0x4 }, // 6019
  { IMAGE_SAMPLE_D_CL_V1_V5_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x1, 0x5 }, // 6020
  { IMAGE_SAMPLE_D_CL_V1_V6_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x1, 0x6 }, // 6021
  { IMAGE_SAMPLE_D_CL_V1_V7_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x1, 0x7 }, // 6022
  { IMAGE_SAMPLE_D_CL_V1_V8_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x1, 0x8 }, // 6023
  { IMAGE_SAMPLE_D_CL_V1_V16_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x1, 0x10 }, // 6024
  { IMAGE_SAMPLE_D_CL_V2_V2_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x2, 0x2 }, // 6025
  { IMAGE_SAMPLE_D_CL_V2_V3_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x2, 0x3 }, // 6026
  { IMAGE_SAMPLE_D_CL_V2_V4_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x2, 0x4 }, // 6027
  { IMAGE_SAMPLE_D_CL_V2_V5_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x2, 0x5 }, // 6028
  { IMAGE_SAMPLE_D_CL_V2_V6_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x2, 0x6 }, // 6029
  { IMAGE_SAMPLE_D_CL_V2_V7_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x2, 0x7 }, // 6030
  { IMAGE_SAMPLE_D_CL_V2_V8_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x2, 0x8 }, // 6031
  { IMAGE_SAMPLE_D_CL_V2_V16_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x2, 0x10 }, // 6032
  { IMAGE_SAMPLE_D_CL_V3_V2_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x3, 0x2 }, // 6033
  { IMAGE_SAMPLE_D_CL_V3_V3_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x3, 0x3 }, // 6034
  { IMAGE_SAMPLE_D_CL_V3_V4_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x3, 0x4 }, // 6035
  { IMAGE_SAMPLE_D_CL_V3_V5_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x3, 0x5 }, // 6036
  { IMAGE_SAMPLE_D_CL_V3_V6_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x3, 0x6 }, // 6037
  { IMAGE_SAMPLE_D_CL_V3_V7_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x3, 0x7 }, // 6038
  { IMAGE_SAMPLE_D_CL_V3_V8_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x3, 0x8 }, // 6039
  { IMAGE_SAMPLE_D_CL_V3_V16_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x3, 0x10 }, // 6040
  { IMAGE_SAMPLE_D_CL_V4_V2_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x4, 0x2 }, // 6041
  { IMAGE_SAMPLE_D_CL_V4_V3_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x4, 0x3 }, // 6042
  { IMAGE_SAMPLE_D_CL_V4_V4_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x4, 0x4 }, // 6043
  { IMAGE_SAMPLE_D_CL_V4_V5_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x4, 0x5 }, // 6044
  { IMAGE_SAMPLE_D_CL_V4_V6_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x4, 0x6 }, // 6045
  { IMAGE_SAMPLE_D_CL_V4_V7_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x4, 0x7 }, // 6046
  { IMAGE_SAMPLE_D_CL_V4_V8_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x4, 0x8 }, // 6047
  { IMAGE_SAMPLE_D_CL_V4_V16_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x4, 0x10 }, // 6048
  { IMAGE_SAMPLE_D_CL_V5_V2_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x5, 0x2 }, // 6049
  { IMAGE_SAMPLE_D_CL_V5_V3_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x5, 0x3 }, // 6050
  { IMAGE_SAMPLE_D_CL_V5_V4_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x5, 0x4 }, // 6051
  { IMAGE_SAMPLE_D_CL_V5_V5_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x5, 0x5 }, // 6052
  { IMAGE_SAMPLE_D_CL_V5_V6_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x5, 0x6 }, // 6053
  { IMAGE_SAMPLE_D_CL_V5_V7_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x5, 0x7 }, // 6054
  { IMAGE_SAMPLE_D_CL_V5_V8_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x5, 0x8 }, // 6055
  { IMAGE_SAMPLE_D_CL_V5_V16_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10Default, 0x5, 0x10 }, // 6056
  { IMAGE_SAMPLE_D_CL_V1_V2_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x1, 0x2 }, // 6057
  { IMAGE_SAMPLE_D_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x1, 0x3 }, // 6058
  { IMAGE_SAMPLE_D_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x1, 0x4 }, // 6059
  { IMAGE_SAMPLE_D_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x1, 0x5 }, // 6060
  { IMAGE_SAMPLE_D_CL_V1_V6_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x1, 0x6 }, // 6061
  { IMAGE_SAMPLE_D_CL_V1_V7_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x1, 0x7 }, // 6062
  { IMAGE_SAMPLE_D_CL_V1_V8_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x1, 0x8 }, // 6063
  { IMAGE_SAMPLE_D_CL_V1_V9_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x1, 0x9 }, // 6064
  { IMAGE_SAMPLE_D_CL_V1_V10_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x1, 0xA }, // 6065
  { IMAGE_SAMPLE_D_CL_V2_V2_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x2, 0x2 }, // 6066
  { IMAGE_SAMPLE_D_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x2, 0x3 }, // 6067
  { IMAGE_SAMPLE_D_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x2, 0x4 }, // 6068
  { IMAGE_SAMPLE_D_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x2, 0x5 }, // 6069
  { IMAGE_SAMPLE_D_CL_V2_V6_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x2, 0x6 }, // 6070
  { IMAGE_SAMPLE_D_CL_V2_V7_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x2, 0x7 }, // 6071
  { IMAGE_SAMPLE_D_CL_V2_V8_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x2, 0x8 }, // 6072
  { IMAGE_SAMPLE_D_CL_V2_V9_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x2, 0x9 }, // 6073
  { IMAGE_SAMPLE_D_CL_V2_V10_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x2, 0xA }, // 6074
  { IMAGE_SAMPLE_D_CL_V3_V2_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x3, 0x2 }, // 6075
  { IMAGE_SAMPLE_D_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x3, 0x3 }, // 6076
  { IMAGE_SAMPLE_D_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x3, 0x4 }, // 6077
  { IMAGE_SAMPLE_D_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x3, 0x5 }, // 6078
  { IMAGE_SAMPLE_D_CL_V3_V6_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x3, 0x6 }, // 6079
  { IMAGE_SAMPLE_D_CL_V3_V7_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x3, 0x7 }, // 6080
  { IMAGE_SAMPLE_D_CL_V3_V8_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x3, 0x8 }, // 6081
  { IMAGE_SAMPLE_D_CL_V3_V9_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x3, 0x9 }, // 6082
  { IMAGE_SAMPLE_D_CL_V3_V10_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x3, 0xA }, // 6083
  { IMAGE_SAMPLE_D_CL_V4_V2_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x4, 0x2 }, // 6084
  { IMAGE_SAMPLE_D_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x4, 0x3 }, // 6085
  { IMAGE_SAMPLE_D_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x4, 0x4 }, // 6086
  { IMAGE_SAMPLE_D_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x4, 0x5 }, // 6087
  { IMAGE_SAMPLE_D_CL_V4_V6_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x4, 0x6 }, // 6088
  { IMAGE_SAMPLE_D_CL_V4_V7_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x4, 0x7 }, // 6089
  { IMAGE_SAMPLE_D_CL_V4_V8_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x4, 0x8 }, // 6090
  { IMAGE_SAMPLE_D_CL_V4_V9_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x4, 0x9 }, // 6091
  { IMAGE_SAMPLE_D_CL_V4_V10_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x4, 0xA }, // 6092
  { IMAGE_SAMPLE_D_CL_V5_V2_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x5, 0x2 }, // 6093
  { IMAGE_SAMPLE_D_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x5, 0x3 }, // 6094
  { IMAGE_SAMPLE_D_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x5, 0x4 }, // 6095
  { IMAGE_SAMPLE_D_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x5, 0x5 }, // 6096
  { IMAGE_SAMPLE_D_CL_V5_V6_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x5, 0x6 }, // 6097
  { IMAGE_SAMPLE_D_CL_V5_V7_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x5, 0x7 }, // 6098
  { IMAGE_SAMPLE_D_CL_V5_V8_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x5, 0x8 }, // 6099
  { IMAGE_SAMPLE_D_CL_V5_V9_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x5, 0x9 }, // 6100
  { IMAGE_SAMPLE_D_CL_V5_V10_nsa_gfx10, IMAGE_SAMPLE_D_CL, MIMGEncGfx10NSA, 0x5, 0xA }, // 6101
  { IMAGE_SAMPLE_D_CL_V1_V2, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x1, 0x2 }, // 6102
  { IMAGE_SAMPLE_D_CL_V1_V3, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x1, 0x3 }, // 6103
  { IMAGE_SAMPLE_D_CL_V1_V4, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x1, 0x4 }, // 6104
  { IMAGE_SAMPLE_D_CL_V1_V5, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x1, 0x5 }, // 6105
  { IMAGE_SAMPLE_D_CL_V1_V6, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x1, 0x6 }, // 6106
  { IMAGE_SAMPLE_D_CL_V1_V7, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x1, 0x7 }, // 6107
  { IMAGE_SAMPLE_D_CL_V1_V8, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x1, 0x8 }, // 6108
  { IMAGE_SAMPLE_D_CL_V1_V16, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x1, 0x10 }, // 6109
  { IMAGE_SAMPLE_D_CL_V2_V2, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x2, 0x2 }, // 6110
  { IMAGE_SAMPLE_D_CL_V2_V3, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x2, 0x3 }, // 6111
  { IMAGE_SAMPLE_D_CL_V2_V4, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x2, 0x4 }, // 6112
  { IMAGE_SAMPLE_D_CL_V2_V5, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x2, 0x5 }, // 6113
  { IMAGE_SAMPLE_D_CL_V2_V6, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x2, 0x6 }, // 6114
  { IMAGE_SAMPLE_D_CL_V2_V7, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x2, 0x7 }, // 6115
  { IMAGE_SAMPLE_D_CL_V2_V8, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x2, 0x8 }, // 6116
  { IMAGE_SAMPLE_D_CL_V2_V16, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x2, 0x10 }, // 6117
  { IMAGE_SAMPLE_D_CL_V3_V2, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x3, 0x2 }, // 6118
  { IMAGE_SAMPLE_D_CL_V3_V3, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x3, 0x3 }, // 6119
  { IMAGE_SAMPLE_D_CL_V3_V4, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x3, 0x4 }, // 6120
  { IMAGE_SAMPLE_D_CL_V3_V5, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x3, 0x5 }, // 6121
  { IMAGE_SAMPLE_D_CL_V3_V6, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x3, 0x6 }, // 6122
  { IMAGE_SAMPLE_D_CL_V3_V7, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x3, 0x7 }, // 6123
  { IMAGE_SAMPLE_D_CL_V3_V8, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x3, 0x8 }, // 6124
  { IMAGE_SAMPLE_D_CL_V3_V16, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x3, 0x10 }, // 6125
  { IMAGE_SAMPLE_D_CL_V4_V2, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x4, 0x2 }, // 6126
  { IMAGE_SAMPLE_D_CL_V4_V3, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x4, 0x3 }, // 6127
  { IMAGE_SAMPLE_D_CL_V4_V4, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x4, 0x4 }, // 6128
  { IMAGE_SAMPLE_D_CL_V4_V5, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x4, 0x5 }, // 6129
  { IMAGE_SAMPLE_D_CL_V4_V6, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x4, 0x6 }, // 6130
  { IMAGE_SAMPLE_D_CL_V4_V7, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x4, 0x7 }, // 6131
  { IMAGE_SAMPLE_D_CL_V4_V8, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x4, 0x8 }, // 6132
  { IMAGE_SAMPLE_D_CL_V4_V16, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x4, 0x10 }, // 6133
  { IMAGE_SAMPLE_D_CL_V5_V2, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x5, 0x2 }, // 6134
  { IMAGE_SAMPLE_D_CL_V5_V3, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x5, 0x3 }, // 6135
  { IMAGE_SAMPLE_D_CL_V5_V4, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x5, 0x4 }, // 6136
  { IMAGE_SAMPLE_D_CL_V5_V5, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x5, 0x5 }, // 6137
  { IMAGE_SAMPLE_D_CL_V5_V6, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x5, 0x6 }, // 6138
  { IMAGE_SAMPLE_D_CL_V5_V7, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x5, 0x7 }, // 6139
  { IMAGE_SAMPLE_D_CL_V5_V8, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x5, 0x8 }, // 6140
  { IMAGE_SAMPLE_D_CL_V5_V16, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x5, 0x10 }, // 6141
  { IMAGE_SAMPLE_D_CL_G16_V1_V2_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x2 }, // 6142
  { IMAGE_SAMPLE_D_CL_G16_V1_V3_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x3 }, // 6143
  { IMAGE_SAMPLE_D_CL_G16_V1_V4_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x4 }, // 6144
  { IMAGE_SAMPLE_D_CL_G16_V1_V5_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x5 }, // 6145
  { IMAGE_SAMPLE_D_CL_G16_V1_V6_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x6 }, // 6146
  { IMAGE_SAMPLE_D_CL_G16_V1_V7_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x7 }, // 6147
  { IMAGE_SAMPLE_D_CL_G16_V1_V8_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x8 }, // 6148
  { IMAGE_SAMPLE_D_CL_G16_V1_V16_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x10 }, // 6149
  { IMAGE_SAMPLE_D_CL_G16_V2_V2_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x2 }, // 6150
  { IMAGE_SAMPLE_D_CL_G16_V2_V3_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x3 }, // 6151
  { IMAGE_SAMPLE_D_CL_G16_V2_V4_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x4 }, // 6152
  { IMAGE_SAMPLE_D_CL_G16_V2_V5_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x5 }, // 6153
  { IMAGE_SAMPLE_D_CL_G16_V2_V6_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x6 }, // 6154
  { IMAGE_SAMPLE_D_CL_G16_V2_V7_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x7 }, // 6155
  { IMAGE_SAMPLE_D_CL_G16_V2_V8_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x8 }, // 6156
  { IMAGE_SAMPLE_D_CL_G16_V2_V16_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x10 }, // 6157
  { IMAGE_SAMPLE_D_CL_G16_V3_V2_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x2 }, // 6158
  { IMAGE_SAMPLE_D_CL_G16_V3_V3_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x3 }, // 6159
  { IMAGE_SAMPLE_D_CL_G16_V3_V4_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x4 }, // 6160
  { IMAGE_SAMPLE_D_CL_G16_V3_V5_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x5 }, // 6161
  { IMAGE_SAMPLE_D_CL_G16_V3_V6_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x6 }, // 6162
  { IMAGE_SAMPLE_D_CL_G16_V3_V7_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x7 }, // 6163
  { IMAGE_SAMPLE_D_CL_G16_V3_V8_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x8 }, // 6164
  { IMAGE_SAMPLE_D_CL_G16_V3_V16_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x10 }, // 6165
  { IMAGE_SAMPLE_D_CL_G16_V4_V2_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x2 }, // 6166
  { IMAGE_SAMPLE_D_CL_G16_V4_V3_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x3 }, // 6167
  { IMAGE_SAMPLE_D_CL_G16_V4_V4_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x4 }, // 6168
  { IMAGE_SAMPLE_D_CL_G16_V4_V5_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x5 }, // 6169
  { IMAGE_SAMPLE_D_CL_G16_V4_V6_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x6 }, // 6170
  { IMAGE_SAMPLE_D_CL_G16_V4_V7_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x7 }, // 6171
  { IMAGE_SAMPLE_D_CL_G16_V4_V8_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x8 }, // 6172
  { IMAGE_SAMPLE_D_CL_G16_V4_V16_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x10 }, // 6173
  { IMAGE_SAMPLE_D_CL_G16_V5_V2_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x2 }, // 6174
  { IMAGE_SAMPLE_D_CL_G16_V5_V3_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x3 }, // 6175
  { IMAGE_SAMPLE_D_CL_G16_V5_V4_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x4 }, // 6176
  { IMAGE_SAMPLE_D_CL_G16_V5_V5_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x5 }, // 6177
  { IMAGE_SAMPLE_D_CL_G16_V5_V6_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x6 }, // 6178
  { IMAGE_SAMPLE_D_CL_G16_V5_V7_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x7 }, // 6179
  { IMAGE_SAMPLE_D_CL_G16_V5_V8_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x8 }, // 6180
  { IMAGE_SAMPLE_D_CL_G16_V5_V16_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x10 }, // 6181
  { IMAGE_SAMPLE_D_CL_G16_V1_V2_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x2 }, // 6182
  { IMAGE_SAMPLE_D_CL_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x3 }, // 6183
  { IMAGE_SAMPLE_D_CL_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x4 }, // 6184
  { IMAGE_SAMPLE_D_CL_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x5 }, // 6185
  { IMAGE_SAMPLE_D_CL_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x6 }, // 6186
  { IMAGE_SAMPLE_D_CL_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x7 }, // 6187
  { IMAGE_SAMPLE_D_CL_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x8 }, // 6188
  { IMAGE_SAMPLE_D_CL_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x9 }, // 6189
  { IMAGE_SAMPLE_D_CL_G16_V1_V10_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0xA }, // 6190
  { IMAGE_SAMPLE_D_CL_G16_V2_V2_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x2 }, // 6191
  { IMAGE_SAMPLE_D_CL_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x3 }, // 6192
  { IMAGE_SAMPLE_D_CL_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x4 }, // 6193
  { IMAGE_SAMPLE_D_CL_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x5 }, // 6194
  { IMAGE_SAMPLE_D_CL_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x6 }, // 6195
  { IMAGE_SAMPLE_D_CL_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x7 }, // 6196
  { IMAGE_SAMPLE_D_CL_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x8 }, // 6197
  { IMAGE_SAMPLE_D_CL_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x9 }, // 6198
  { IMAGE_SAMPLE_D_CL_G16_V2_V10_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0xA }, // 6199
  { IMAGE_SAMPLE_D_CL_G16_V3_V2_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x2 }, // 6200
  { IMAGE_SAMPLE_D_CL_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x3 }, // 6201
  { IMAGE_SAMPLE_D_CL_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x4 }, // 6202
  { IMAGE_SAMPLE_D_CL_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x5 }, // 6203
  { IMAGE_SAMPLE_D_CL_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x6 }, // 6204
  { IMAGE_SAMPLE_D_CL_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x7 }, // 6205
  { IMAGE_SAMPLE_D_CL_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x8 }, // 6206
  { IMAGE_SAMPLE_D_CL_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x9 }, // 6207
  { IMAGE_SAMPLE_D_CL_G16_V3_V10_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0xA }, // 6208
  { IMAGE_SAMPLE_D_CL_G16_V4_V2_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x2 }, // 6209
  { IMAGE_SAMPLE_D_CL_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x3 }, // 6210
  { IMAGE_SAMPLE_D_CL_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x4 }, // 6211
  { IMAGE_SAMPLE_D_CL_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x5 }, // 6212
  { IMAGE_SAMPLE_D_CL_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x6 }, // 6213
  { IMAGE_SAMPLE_D_CL_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x7 }, // 6214
  { IMAGE_SAMPLE_D_CL_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x8 }, // 6215
  { IMAGE_SAMPLE_D_CL_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x9 }, // 6216
  { IMAGE_SAMPLE_D_CL_G16_V4_V10_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0xA }, // 6217
  { IMAGE_SAMPLE_D_CL_G16_V5_V2_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x2 }, // 6218
  { IMAGE_SAMPLE_D_CL_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x3 }, // 6219
  { IMAGE_SAMPLE_D_CL_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x4 }, // 6220
  { IMAGE_SAMPLE_D_CL_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x5 }, // 6221
  { IMAGE_SAMPLE_D_CL_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x6 }, // 6222
  { IMAGE_SAMPLE_D_CL_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x7 }, // 6223
  { IMAGE_SAMPLE_D_CL_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x8 }, // 6224
  { IMAGE_SAMPLE_D_CL_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x9 }, // 6225
  { IMAGE_SAMPLE_D_CL_G16_V5_V10_nsa_gfx10, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0xA }, // 6226
  { IMAGE_SAMPLE_D_CL_G16_V1_V2, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x1, 0x2 }, // 6227
  { IMAGE_SAMPLE_D_CL_G16_V1_V3, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x1, 0x3 }, // 6228
  { IMAGE_SAMPLE_D_CL_G16_V1_V4, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x1, 0x4 }, // 6229
  { IMAGE_SAMPLE_D_CL_G16_V1_V5, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x1, 0x5 }, // 6230
  { IMAGE_SAMPLE_D_CL_G16_V1_V6, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x1, 0x6 }, // 6231
  { IMAGE_SAMPLE_D_CL_G16_V1_V7, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x1, 0x7 }, // 6232
  { IMAGE_SAMPLE_D_CL_G16_V1_V8, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x1, 0x8 }, // 6233
  { IMAGE_SAMPLE_D_CL_G16_V1_V16, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x1, 0x10 }, // 6234
  { IMAGE_SAMPLE_D_CL_G16_V2_V2, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x2, 0x2 }, // 6235
  { IMAGE_SAMPLE_D_CL_G16_V2_V3, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x2, 0x3 }, // 6236
  { IMAGE_SAMPLE_D_CL_G16_V2_V4, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x2, 0x4 }, // 6237
  { IMAGE_SAMPLE_D_CL_G16_V2_V5, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x2, 0x5 }, // 6238
  { IMAGE_SAMPLE_D_CL_G16_V2_V6, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x2, 0x6 }, // 6239
  { IMAGE_SAMPLE_D_CL_G16_V2_V7, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x2, 0x7 }, // 6240
  { IMAGE_SAMPLE_D_CL_G16_V2_V8, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x2, 0x8 }, // 6241
  { IMAGE_SAMPLE_D_CL_G16_V2_V16, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x2, 0x10 }, // 6242
  { IMAGE_SAMPLE_D_CL_G16_V3_V2, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x3, 0x2 }, // 6243
  { IMAGE_SAMPLE_D_CL_G16_V3_V3, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x3, 0x3 }, // 6244
  { IMAGE_SAMPLE_D_CL_G16_V3_V4, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x3, 0x4 }, // 6245
  { IMAGE_SAMPLE_D_CL_G16_V3_V5, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x3, 0x5 }, // 6246
  { IMAGE_SAMPLE_D_CL_G16_V3_V6, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x3, 0x6 }, // 6247
  { IMAGE_SAMPLE_D_CL_G16_V3_V7, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x3, 0x7 }, // 6248
  { IMAGE_SAMPLE_D_CL_G16_V3_V8, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x3, 0x8 }, // 6249
  { IMAGE_SAMPLE_D_CL_G16_V3_V16, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x3, 0x10 }, // 6250
  { IMAGE_SAMPLE_D_CL_G16_V4_V2, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x4, 0x2 }, // 6251
  { IMAGE_SAMPLE_D_CL_G16_V4_V3, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x4, 0x3 }, // 6252
  { IMAGE_SAMPLE_D_CL_G16_V4_V4, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x4, 0x4 }, // 6253
  { IMAGE_SAMPLE_D_CL_G16_V4_V5, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x4, 0x5 }, // 6254
  { IMAGE_SAMPLE_D_CL_G16_V4_V6, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x4, 0x6 }, // 6255
  { IMAGE_SAMPLE_D_CL_G16_V4_V7, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x4, 0x7 }, // 6256
  { IMAGE_SAMPLE_D_CL_G16_V4_V8, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x4, 0x8 }, // 6257
  { IMAGE_SAMPLE_D_CL_G16_V4_V16, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x4, 0x10 }, // 6258
  { IMAGE_SAMPLE_D_CL_G16_V5_V2, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x5, 0x2 }, // 6259
  { IMAGE_SAMPLE_D_CL_G16_V5_V3, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x5, 0x3 }, // 6260
  { IMAGE_SAMPLE_D_CL_G16_V5_V4, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x5, 0x4 }, // 6261
  { IMAGE_SAMPLE_D_CL_G16_V5_V5, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x5, 0x5 }, // 6262
  { IMAGE_SAMPLE_D_CL_G16_V5_V6, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x5, 0x6 }, // 6263
  { IMAGE_SAMPLE_D_CL_G16_V5_V7, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x5, 0x7 }, // 6264
  { IMAGE_SAMPLE_D_CL_G16_V5_V8, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x5, 0x8 }, // 6265
  { IMAGE_SAMPLE_D_CL_G16_V5_V16, IMAGE_SAMPLE_D_CL_G16, MIMGEncGfx6, 0x5, 0x10 }, // 6266
  { IMAGE_SAMPLE_D_CL_O_V1_V3_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x1, 0x3 }, // 6267
  { IMAGE_SAMPLE_D_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x1, 0x4 }, // 6268
  { IMAGE_SAMPLE_D_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x1, 0x5 }, // 6269
  { IMAGE_SAMPLE_D_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x1, 0x6 }, // 6270
  { IMAGE_SAMPLE_D_CL_O_V1_V7_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x1, 0x7 }, // 6271
  { IMAGE_SAMPLE_D_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x1, 0x8 }, // 6272
  { IMAGE_SAMPLE_D_CL_O_V1_V16_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x1, 0x10 }, // 6273
  { IMAGE_SAMPLE_D_CL_O_V2_V3_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 6274
  { IMAGE_SAMPLE_D_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 6275
  { IMAGE_SAMPLE_D_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 6276
  { IMAGE_SAMPLE_D_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x2, 0x6 }, // 6277
  { IMAGE_SAMPLE_D_CL_O_V2_V7_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x2, 0x7 }, // 6278
  { IMAGE_SAMPLE_D_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 6279
  { IMAGE_SAMPLE_D_CL_O_V2_V16_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x2, 0x10 }, // 6280
  { IMAGE_SAMPLE_D_CL_O_V3_V3_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x3, 0x3 }, // 6281
  { IMAGE_SAMPLE_D_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x3, 0x4 }, // 6282
  { IMAGE_SAMPLE_D_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x3, 0x5 }, // 6283
  { IMAGE_SAMPLE_D_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x3, 0x6 }, // 6284
  { IMAGE_SAMPLE_D_CL_O_V3_V7_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x3, 0x7 }, // 6285
  { IMAGE_SAMPLE_D_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x3, 0x8 }, // 6286
  { IMAGE_SAMPLE_D_CL_O_V3_V16_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x3, 0x10 }, // 6287
  { IMAGE_SAMPLE_D_CL_O_V4_V3_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 6288
  { IMAGE_SAMPLE_D_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 6289
  { IMAGE_SAMPLE_D_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 6290
  { IMAGE_SAMPLE_D_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x4, 0x6 }, // 6291
  { IMAGE_SAMPLE_D_CL_O_V4_V7_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x4, 0x7 }, // 6292
  { IMAGE_SAMPLE_D_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 6293
  { IMAGE_SAMPLE_D_CL_O_V4_V16_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x4, 0x10 }, // 6294
  { IMAGE_SAMPLE_D_CL_O_V5_V3_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 6295
  { IMAGE_SAMPLE_D_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 6296
  { IMAGE_SAMPLE_D_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 6297
  { IMAGE_SAMPLE_D_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x5, 0x6 }, // 6298
  { IMAGE_SAMPLE_D_CL_O_V5_V7_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x5, 0x7 }, // 6299
  { IMAGE_SAMPLE_D_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 6300
  { IMAGE_SAMPLE_D_CL_O_V5_V16_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10Default, 0x5, 0x10 }, // 6301
  { IMAGE_SAMPLE_D_CL_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x3 }, // 6302
  { IMAGE_SAMPLE_D_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x4 }, // 6303
  { IMAGE_SAMPLE_D_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x5 }, // 6304
  { IMAGE_SAMPLE_D_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x6 }, // 6305
  { IMAGE_SAMPLE_D_CL_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x7 }, // 6306
  { IMAGE_SAMPLE_D_CL_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x8 }, // 6307
  { IMAGE_SAMPLE_D_CL_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x9 }, // 6308
  { IMAGE_SAMPLE_D_CL_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x1, 0xA }, // 6309
  { IMAGE_SAMPLE_D_CL_O_V1_V11_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x1, 0xB }, // 6310
  { IMAGE_SAMPLE_D_CL_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 6311
  { IMAGE_SAMPLE_D_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 6312
  { IMAGE_SAMPLE_D_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 6313
  { IMAGE_SAMPLE_D_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x6 }, // 6314
  { IMAGE_SAMPLE_D_CL_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x7 }, // 6315
  { IMAGE_SAMPLE_D_CL_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x8 }, // 6316
  { IMAGE_SAMPLE_D_CL_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x9 }, // 6317
  { IMAGE_SAMPLE_D_CL_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x2, 0xA }, // 6318
  { IMAGE_SAMPLE_D_CL_O_V2_V11_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x2, 0xB }, // 6319
  { IMAGE_SAMPLE_D_CL_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x3 }, // 6320
  { IMAGE_SAMPLE_D_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x4 }, // 6321
  { IMAGE_SAMPLE_D_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x5 }, // 6322
  { IMAGE_SAMPLE_D_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x6 }, // 6323
  { IMAGE_SAMPLE_D_CL_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x7 }, // 6324
  { IMAGE_SAMPLE_D_CL_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x8 }, // 6325
  { IMAGE_SAMPLE_D_CL_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x9 }, // 6326
  { IMAGE_SAMPLE_D_CL_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x3, 0xA }, // 6327
  { IMAGE_SAMPLE_D_CL_O_V3_V11_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x3, 0xB }, // 6328
  { IMAGE_SAMPLE_D_CL_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 6329
  { IMAGE_SAMPLE_D_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 6330
  { IMAGE_SAMPLE_D_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 6331
  { IMAGE_SAMPLE_D_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x6 }, // 6332
  { IMAGE_SAMPLE_D_CL_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x7 }, // 6333
  { IMAGE_SAMPLE_D_CL_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x8 }, // 6334
  { IMAGE_SAMPLE_D_CL_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x9 }, // 6335
  { IMAGE_SAMPLE_D_CL_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x4, 0xA }, // 6336
  { IMAGE_SAMPLE_D_CL_O_V4_V11_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x4, 0xB }, // 6337
  { IMAGE_SAMPLE_D_CL_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 6338
  { IMAGE_SAMPLE_D_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 6339
  { IMAGE_SAMPLE_D_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 6340
  { IMAGE_SAMPLE_D_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x6 }, // 6341
  { IMAGE_SAMPLE_D_CL_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x7 }, // 6342
  { IMAGE_SAMPLE_D_CL_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x8 }, // 6343
  { IMAGE_SAMPLE_D_CL_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x9 }, // 6344
  { IMAGE_SAMPLE_D_CL_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x5, 0xA }, // 6345
  { IMAGE_SAMPLE_D_CL_O_V5_V11_nsa_gfx10, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx10NSA, 0x5, 0xB }, // 6346
  { IMAGE_SAMPLE_D_CL_O_V1_V3, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x1, 0x3 }, // 6347
  { IMAGE_SAMPLE_D_CL_O_V1_V4, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x1, 0x4 }, // 6348
  { IMAGE_SAMPLE_D_CL_O_V1_V5, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x1, 0x5 }, // 6349
  { IMAGE_SAMPLE_D_CL_O_V1_V6, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x1, 0x6 }, // 6350
  { IMAGE_SAMPLE_D_CL_O_V1_V7, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x1, 0x7 }, // 6351
  { IMAGE_SAMPLE_D_CL_O_V1_V8, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x1, 0x8 }, // 6352
  { IMAGE_SAMPLE_D_CL_O_V1_V16, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x1, 0x10 }, // 6353
  { IMAGE_SAMPLE_D_CL_O_V2_V3, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x2, 0x3 }, // 6354
  { IMAGE_SAMPLE_D_CL_O_V2_V4, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 6355
  { IMAGE_SAMPLE_D_CL_O_V2_V5, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x2, 0x5 }, // 6356
  { IMAGE_SAMPLE_D_CL_O_V2_V6, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x2, 0x6 }, // 6357
  { IMAGE_SAMPLE_D_CL_O_V2_V7, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x2, 0x7 }, // 6358
  { IMAGE_SAMPLE_D_CL_O_V2_V8, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 6359
  { IMAGE_SAMPLE_D_CL_O_V2_V16, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x2, 0x10 }, // 6360
  { IMAGE_SAMPLE_D_CL_O_V3_V3, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x3, 0x3 }, // 6361
  { IMAGE_SAMPLE_D_CL_O_V3_V4, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x3, 0x4 }, // 6362
  { IMAGE_SAMPLE_D_CL_O_V3_V5, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x3, 0x5 }, // 6363
  { IMAGE_SAMPLE_D_CL_O_V3_V6, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x3, 0x6 }, // 6364
  { IMAGE_SAMPLE_D_CL_O_V3_V7, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x3, 0x7 }, // 6365
  { IMAGE_SAMPLE_D_CL_O_V3_V8, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x3, 0x8 }, // 6366
  { IMAGE_SAMPLE_D_CL_O_V3_V16, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x3, 0x10 }, // 6367
  { IMAGE_SAMPLE_D_CL_O_V4_V3, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x4, 0x3 }, // 6368
  { IMAGE_SAMPLE_D_CL_O_V4_V4, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 6369
  { IMAGE_SAMPLE_D_CL_O_V4_V5, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x4, 0x5 }, // 6370
  { IMAGE_SAMPLE_D_CL_O_V4_V6, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x4, 0x6 }, // 6371
  { IMAGE_SAMPLE_D_CL_O_V4_V7, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x4, 0x7 }, // 6372
  { IMAGE_SAMPLE_D_CL_O_V4_V8, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 6373
  { IMAGE_SAMPLE_D_CL_O_V4_V16, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x4, 0x10 }, // 6374
  { IMAGE_SAMPLE_D_CL_O_V5_V3, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x5, 0x3 }, // 6375
  { IMAGE_SAMPLE_D_CL_O_V5_V4, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x5, 0x4 }, // 6376
  { IMAGE_SAMPLE_D_CL_O_V5_V5, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x5, 0x5 }, // 6377
  { IMAGE_SAMPLE_D_CL_O_V5_V6, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x5, 0x6 }, // 6378
  { IMAGE_SAMPLE_D_CL_O_V5_V7, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x5, 0x7 }, // 6379
  { IMAGE_SAMPLE_D_CL_O_V5_V8, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x5, 0x8 }, // 6380
  { IMAGE_SAMPLE_D_CL_O_V5_V16, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x5, 0x10 }, // 6381
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V3_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x3 }, // 6382
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x4 }, // 6383
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x5 }, // 6384
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x6 }, // 6385
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x7 }, // 6386
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x8 }, // 6387
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V16_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x10 }, // 6388
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V3_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x3 }, // 6389
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x4 }, // 6390
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x5 }, // 6391
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x6 }, // 6392
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x7 }, // 6393
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x8 }, // 6394
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V16_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x10 }, // 6395
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V3_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x3 }, // 6396
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x4 }, // 6397
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x5 }, // 6398
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x6 }, // 6399
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x7 }, // 6400
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x8 }, // 6401
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V16_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x10 }, // 6402
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V3_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x3 }, // 6403
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x4 }, // 6404
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x5 }, // 6405
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x6 }, // 6406
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x7 }, // 6407
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x8 }, // 6408
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V16_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x10 }, // 6409
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V3_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x3 }, // 6410
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x4 }, // 6411
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x5 }, // 6412
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x6 }, // 6413
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x7 }, // 6414
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x8 }, // 6415
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V16_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x10 }, // 6416
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x3 }, // 6417
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x4 }, // 6418
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x5 }, // 6419
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x6 }, // 6420
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x7 }, // 6421
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x8 }, // 6422
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x9 }, // 6423
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V10_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0xA }, // 6424
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V11_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0xB }, // 6425
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x3 }, // 6426
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x4 }, // 6427
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x5 }, // 6428
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x6 }, // 6429
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x7 }, // 6430
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x8 }, // 6431
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x9 }, // 6432
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V10_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0xA }, // 6433
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V11_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0xB }, // 6434
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x3 }, // 6435
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x4 }, // 6436
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x5 }, // 6437
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x6 }, // 6438
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x7 }, // 6439
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x8 }, // 6440
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x9 }, // 6441
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V10_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0xA }, // 6442
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V11_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0xB }, // 6443
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x3 }, // 6444
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x4 }, // 6445
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x5 }, // 6446
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x6 }, // 6447
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x7 }, // 6448
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x8 }, // 6449
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x9 }, // 6450
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V10_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0xA }, // 6451
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V11_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0xB }, // 6452
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x3 }, // 6453
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x4 }, // 6454
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x5 }, // 6455
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x6 }, // 6456
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x7 }, // 6457
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x8 }, // 6458
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x9 }, // 6459
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V10_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0xA }, // 6460
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V11_nsa_gfx10, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0xB }, // 6461
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V3, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x3 }, // 6462
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V4, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x4 }, // 6463
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V5, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x5 }, // 6464
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V6, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x6 }, // 6465
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V7, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x7 }, // 6466
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V8, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x8 }, // 6467
  { IMAGE_SAMPLE_D_CL_O_G16_V1_V16, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x10 }, // 6468
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V3, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x3 }, // 6469
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V4, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x4 }, // 6470
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V5, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x5 }, // 6471
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V6, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x6 }, // 6472
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V7, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x7 }, // 6473
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V8, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x8 }, // 6474
  { IMAGE_SAMPLE_D_CL_O_G16_V2_V16, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x10 }, // 6475
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V3, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x3 }, // 6476
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V4, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x4 }, // 6477
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V5, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x5 }, // 6478
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V6, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x6 }, // 6479
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V7, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x7 }, // 6480
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V8, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x8 }, // 6481
  { IMAGE_SAMPLE_D_CL_O_G16_V3_V16, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x10 }, // 6482
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V3, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x3 }, // 6483
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V4, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x4 }, // 6484
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V5, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x5 }, // 6485
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V6, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x6 }, // 6486
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V7, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x7 }, // 6487
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V8, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x8 }, // 6488
  { IMAGE_SAMPLE_D_CL_O_G16_V4_V16, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x10 }, // 6489
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V3, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x3 }, // 6490
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V4, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x4 }, // 6491
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V5, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x5 }, // 6492
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V6, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x6 }, // 6493
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V7, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x7 }, // 6494
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V8, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x8 }, // 6495
  { IMAGE_SAMPLE_D_CL_O_G16_V5_V16, IMAGE_SAMPLE_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x10 }, // 6496
  { IMAGE_SAMPLE_D_G16_V1_V2_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x1, 0x2 }, // 6497
  { IMAGE_SAMPLE_D_G16_V1_V3_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x1, 0x3 }, // 6498
  { IMAGE_SAMPLE_D_G16_V1_V4_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x1, 0x4 }, // 6499
  { IMAGE_SAMPLE_D_G16_V1_V5_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x1, 0x5 }, // 6500
  { IMAGE_SAMPLE_D_G16_V1_V6_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x1, 0x6 }, // 6501
  { IMAGE_SAMPLE_D_G16_V1_V7_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x1, 0x7 }, // 6502
  { IMAGE_SAMPLE_D_G16_V1_V8_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x1, 0x8 }, // 6503
  { IMAGE_SAMPLE_D_G16_V1_V16_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x1, 0x10 }, // 6504
  { IMAGE_SAMPLE_D_G16_V2_V2_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x2, 0x2 }, // 6505
  { IMAGE_SAMPLE_D_G16_V2_V3_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x2, 0x3 }, // 6506
  { IMAGE_SAMPLE_D_G16_V2_V4_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x2, 0x4 }, // 6507
  { IMAGE_SAMPLE_D_G16_V2_V5_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x2, 0x5 }, // 6508
  { IMAGE_SAMPLE_D_G16_V2_V6_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x2, 0x6 }, // 6509
  { IMAGE_SAMPLE_D_G16_V2_V7_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x2, 0x7 }, // 6510
  { IMAGE_SAMPLE_D_G16_V2_V8_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x2, 0x8 }, // 6511
  { IMAGE_SAMPLE_D_G16_V2_V16_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x2, 0x10 }, // 6512
  { IMAGE_SAMPLE_D_G16_V3_V2_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x3, 0x2 }, // 6513
  { IMAGE_SAMPLE_D_G16_V3_V3_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x3, 0x3 }, // 6514
  { IMAGE_SAMPLE_D_G16_V3_V4_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x3, 0x4 }, // 6515
  { IMAGE_SAMPLE_D_G16_V3_V5_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x3, 0x5 }, // 6516
  { IMAGE_SAMPLE_D_G16_V3_V6_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x3, 0x6 }, // 6517
  { IMAGE_SAMPLE_D_G16_V3_V7_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x3, 0x7 }, // 6518
  { IMAGE_SAMPLE_D_G16_V3_V8_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x3, 0x8 }, // 6519
  { IMAGE_SAMPLE_D_G16_V3_V16_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x3, 0x10 }, // 6520
  { IMAGE_SAMPLE_D_G16_V4_V2_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x4, 0x2 }, // 6521
  { IMAGE_SAMPLE_D_G16_V4_V3_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x4, 0x3 }, // 6522
  { IMAGE_SAMPLE_D_G16_V4_V4_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x4, 0x4 }, // 6523
  { IMAGE_SAMPLE_D_G16_V4_V5_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x4, 0x5 }, // 6524
  { IMAGE_SAMPLE_D_G16_V4_V6_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x4, 0x6 }, // 6525
  { IMAGE_SAMPLE_D_G16_V4_V7_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x4, 0x7 }, // 6526
  { IMAGE_SAMPLE_D_G16_V4_V8_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x4, 0x8 }, // 6527
  { IMAGE_SAMPLE_D_G16_V4_V16_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x4, 0x10 }, // 6528
  { IMAGE_SAMPLE_D_G16_V5_V2_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x5, 0x2 }, // 6529
  { IMAGE_SAMPLE_D_G16_V5_V3_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x5, 0x3 }, // 6530
  { IMAGE_SAMPLE_D_G16_V5_V4_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x5, 0x4 }, // 6531
  { IMAGE_SAMPLE_D_G16_V5_V5_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x5, 0x5 }, // 6532
  { IMAGE_SAMPLE_D_G16_V5_V6_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x5, 0x6 }, // 6533
  { IMAGE_SAMPLE_D_G16_V5_V7_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x5, 0x7 }, // 6534
  { IMAGE_SAMPLE_D_G16_V5_V8_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x5, 0x8 }, // 6535
  { IMAGE_SAMPLE_D_G16_V5_V16_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10Default, 0x5, 0x10 }, // 6536
  { IMAGE_SAMPLE_D_G16_V1_V2_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x1, 0x2 }, // 6537
  { IMAGE_SAMPLE_D_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x1, 0x3 }, // 6538
  { IMAGE_SAMPLE_D_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x1, 0x4 }, // 6539
  { IMAGE_SAMPLE_D_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x1, 0x5 }, // 6540
  { IMAGE_SAMPLE_D_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x1, 0x6 }, // 6541
  { IMAGE_SAMPLE_D_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x1, 0x7 }, // 6542
  { IMAGE_SAMPLE_D_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x1, 0x8 }, // 6543
  { IMAGE_SAMPLE_D_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x1, 0x9 }, // 6544
  { IMAGE_SAMPLE_D_G16_V2_V2_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x2, 0x2 }, // 6545
  { IMAGE_SAMPLE_D_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x2, 0x3 }, // 6546
  { IMAGE_SAMPLE_D_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x2, 0x4 }, // 6547
  { IMAGE_SAMPLE_D_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x2, 0x5 }, // 6548
  { IMAGE_SAMPLE_D_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x2, 0x6 }, // 6549
  { IMAGE_SAMPLE_D_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x2, 0x7 }, // 6550
  { IMAGE_SAMPLE_D_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x2, 0x8 }, // 6551
  { IMAGE_SAMPLE_D_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x2, 0x9 }, // 6552
  { IMAGE_SAMPLE_D_G16_V3_V2_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x3, 0x2 }, // 6553
  { IMAGE_SAMPLE_D_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x3, 0x3 }, // 6554
  { IMAGE_SAMPLE_D_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x3, 0x4 }, // 6555
  { IMAGE_SAMPLE_D_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x3, 0x5 }, // 6556
  { IMAGE_SAMPLE_D_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x3, 0x6 }, // 6557
  { IMAGE_SAMPLE_D_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x3, 0x7 }, // 6558
  { IMAGE_SAMPLE_D_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x3, 0x8 }, // 6559
  { IMAGE_SAMPLE_D_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x3, 0x9 }, // 6560
  { IMAGE_SAMPLE_D_G16_V4_V2_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x4, 0x2 }, // 6561
  { IMAGE_SAMPLE_D_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x4, 0x3 }, // 6562
  { IMAGE_SAMPLE_D_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x4, 0x4 }, // 6563
  { IMAGE_SAMPLE_D_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x4, 0x5 }, // 6564
  { IMAGE_SAMPLE_D_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x4, 0x6 }, // 6565
  { IMAGE_SAMPLE_D_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x4, 0x7 }, // 6566
  { IMAGE_SAMPLE_D_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x4, 0x8 }, // 6567
  { IMAGE_SAMPLE_D_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x4, 0x9 }, // 6568
  { IMAGE_SAMPLE_D_G16_V5_V2_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x5, 0x2 }, // 6569
  { IMAGE_SAMPLE_D_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x5, 0x3 }, // 6570
  { IMAGE_SAMPLE_D_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x5, 0x4 }, // 6571
  { IMAGE_SAMPLE_D_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x5, 0x5 }, // 6572
  { IMAGE_SAMPLE_D_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x5, 0x6 }, // 6573
  { IMAGE_SAMPLE_D_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x5, 0x7 }, // 6574
  { IMAGE_SAMPLE_D_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x5, 0x8 }, // 6575
  { IMAGE_SAMPLE_D_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_D_G16, MIMGEncGfx10NSA, 0x5, 0x9 }, // 6576
  { IMAGE_SAMPLE_D_G16_V1_V2, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x1, 0x2 }, // 6577
  { IMAGE_SAMPLE_D_G16_V1_V3, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x1, 0x3 }, // 6578
  { IMAGE_SAMPLE_D_G16_V1_V4, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x1, 0x4 }, // 6579
  { IMAGE_SAMPLE_D_G16_V1_V5, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x1, 0x5 }, // 6580
  { IMAGE_SAMPLE_D_G16_V1_V6, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x1, 0x6 }, // 6581
  { IMAGE_SAMPLE_D_G16_V1_V7, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x1, 0x7 }, // 6582
  { IMAGE_SAMPLE_D_G16_V1_V8, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x1, 0x8 }, // 6583
  { IMAGE_SAMPLE_D_G16_V1_V16, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x1, 0x10 }, // 6584
  { IMAGE_SAMPLE_D_G16_V2_V2, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x2, 0x2 }, // 6585
  { IMAGE_SAMPLE_D_G16_V2_V3, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x2, 0x3 }, // 6586
  { IMAGE_SAMPLE_D_G16_V2_V4, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x2, 0x4 }, // 6587
  { IMAGE_SAMPLE_D_G16_V2_V5, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x2, 0x5 }, // 6588
  { IMAGE_SAMPLE_D_G16_V2_V6, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x2, 0x6 }, // 6589
  { IMAGE_SAMPLE_D_G16_V2_V7, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x2, 0x7 }, // 6590
  { IMAGE_SAMPLE_D_G16_V2_V8, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x2, 0x8 }, // 6591
  { IMAGE_SAMPLE_D_G16_V2_V16, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x2, 0x10 }, // 6592
  { IMAGE_SAMPLE_D_G16_V3_V2, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x3, 0x2 }, // 6593
  { IMAGE_SAMPLE_D_G16_V3_V3, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x3, 0x3 }, // 6594
  { IMAGE_SAMPLE_D_G16_V3_V4, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x3, 0x4 }, // 6595
  { IMAGE_SAMPLE_D_G16_V3_V5, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x3, 0x5 }, // 6596
  { IMAGE_SAMPLE_D_G16_V3_V6, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x3, 0x6 }, // 6597
  { IMAGE_SAMPLE_D_G16_V3_V7, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x3, 0x7 }, // 6598
  { IMAGE_SAMPLE_D_G16_V3_V8, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x3, 0x8 }, // 6599
  { IMAGE_SAMPLE_D_G16_V3_V16, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x3, 0x10 }, // 6600
  { IMAGE_SAMPLE_D_G16_V4_V2, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x4, 0x2 }, // 6601
  { IMAGE_SAMPLE_D_G16_V4_V3, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x4, 0x3 }, // 6602
  { IMAGE_SAMPLE_D_G16_V4_V4, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x4, 0x4 }, // 6603
  { IMAGE_SAMPLE_D_G16_V4_V5, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x4, 0x5 }, // 6604
  { IMAGE_SAMPLE_D_G16_V4_V6, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x4, 0x6 }, // 6605
  { IMAGE_SAMPLE_D_G16_V4_V7, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x4, 0x7 }, // 6606
  { IMAGE_SAMPLE_D_G16_V4_V8, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x4, 0x8 }, // 6607
  { IMAGE_SAMPLE_D_G16_V4_V16, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x4, 0x10 }, // 6608
  { IMAGE_SAMPLE_D_G16_V5_V2, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x5, 0x2 }, // 6609
  { IMAGE_SAMPLE_D_G16_V5_V3, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x5, 0x3 }, // 6610
  { IMAGE_SAMPLE_D_G16_V5_V4, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x5, 0x4 }, // 6611
  { IMAGE_SAMPLE_D_G16_V5_V5, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x5, 0x5 }, // 6612
  { IMAGE_SAMPLE_D_G16_V5_V6, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x5, 0x6 }, // 6613
  { IMAGE_SAMPLE_D_G16_V5_V7, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x5, 0x7 }, // 6614
  { IMAGE_SAMPLE_D_G16_V5_V8, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x5, 0x8 }, // 6615
  { IMAGE_SAMPLE_D_G16_V5_V16, IMAGE_SAMPLE_D_G16, MIMGEncGfx6, 0x5, 0x10 }, // 6616
  { IMAGE_SAMPLE_D_O_V1_V3_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x1, 0x3 }, // 6617
  { IMAGE_SAMPLE_D_O_V1_V4_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x1, 0x4 }, // 6618
  { IMAGE_SAMPLE_D_O_V1_V5_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x1, 0x5 }, // 6619
  { IMAGE_SAMPLE_D_O_V1_V6_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x1, 0x6 }, // 6620
  { IMAGE_SAMPLE_D_O_V1_V7_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x1, 0x7 }, // 6621
  { IMAGE_SAMPLE_D_O_V1_V8_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x1, 0x8 }, // 6622
  { IMAGE_SAMPLE_D_O_V1_V16_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x1, 0x10 }, // 6623
  { IMAGE_SAMPLE_D_O_V2_V3_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 6624
  { IMAGE_SAMPLE_D_O_V2_V4_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 6625
  { IMAGE_SAMPLE_D_O_V2_V5_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 6626
  { IMAGE_SAMPLE_D_O_V2_V6_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x2, 0x6 }, // 6627
  { IMAGE_SAMPLE_D_O_V2_V7_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x2, 0x7 }, // 6628
  { IMAGE_SAMPLE_D_O_V2_V8_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 6629
  { IMAGE_SAMPLE_D_O_V2_V16_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x2, 0x10 }, // 6630
  { IMAGE_SAMPLE_D_O_V3_V3_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x3, 0x3 }, // 6631
  { IMAGE_SAMPLE_D_O_V3_V4_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x3, 0x4 }, // 6632
  { IMAGE_SAMPLE_D_O_V3_V5_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x3, 0x5 }, // 6633
  { IMAGE_SAMPLE_D_O_V3_V6_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x3, 0x6 }, // 6634
  { IMAGE_SAMPLE_D_O_V3_V7_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x3, 0x7 }, // 6635
  { IMAGE_SAMPLE_D_O_V3_V8_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x3, 0x8 }, // 6636
  { IMAGE_SAMPLE_D_O_V3_V16_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x3, 0x10 }, // 6637
  { IMAGE_SAMPLE_D_O_V4_V3_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 6638
  { IMAGE_SAMPLE_D_O_V4_V4_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 6639
  { IMAGE_SAMPLE_D_O_V4_V5_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 6640
  { IMAGE_SAMPLE_D_O_V4_V6_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x4, 0x6 }, // 6641
  { IMAGE_SAMPLE_D_O_V4_V7_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x4, 0x7 }, // 6642
  { IMAGE_SAMPLE_D_O_V4_V8_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 6643
  { IMAGE_SAMPLE_D_O_V4_V16_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x4, 0x10 }, // 6644
  { IMAGE_SAMPLE_D_O_V5_V3_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 6645
  { IMAGE_SAMPLE_D_O_V5_V4_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 6646
  { IMAGE_SAMPLE_D_O_V5_V5_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 6647
  { IMAGE_SAMPLE_D_O_V5_V6_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x5, 0x6 }, // 6648
  { IMAGE_SAMPLE_D_O_V5_V7_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x5, 0x7 }, // 6649
  { IMAGE_SAMPLE_D_O_V5_V8_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 6650
  { IMAGE_SAMPLE_D_O_V5_V16_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10Default, 0x5, 0x10 }, // 6651
  { IMAGE_SAMPLE_D_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x1, 0x3 }, // 6652
  { IMAGE_SAMPLE_D_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x1, 0x4 }, // 6653
  { IMAGE_SAMPLE_D_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x1, 0x5 }, // 6654
  { IMAGE_SAMPLE_D_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x1, 0x6 }, // 6655
  { IMAGE_SAMPLE_D_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x1, 0x7 }, // 6656
  { IMAGE_SAMPLE_D_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x1, 0x8 }, // 6657
  { IMAGE_SAMPLE_D_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x1, 0x9 }, // 6658
  { IMAGE_SAMPLE_D_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x1, 0xA }, // 6659
  { IMAGE_SAMPLE_D_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 6660
  { IMAGE_SAMPLE_D_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 6661
  { IMAGE_SAMPLE_D_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 6662
  { IMAGE_SAMPLE_D_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x2, 0x6 }, // 6663
  { IMAGE_SAMPLE_D_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x2, 0x7 }, // 6664
  { IMAGE_SAMPLE_D_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x2, 0x8 }, // 6665
  { IMAGE_SAMPLE_D_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x2, 0x9 }, // 6666
  { IMAGE_SAMPLE_D_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x2, 0xA }, // 6667
  { IMAGE_SAMPLE_D_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x3, 0x3 }, // 6668
  { IMAGE_SAMPLE_D_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x3, 0x4 }, // 6669
  { IMAGE_SAMPLE_D_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x3, 0x5 }, // 6670
  { IMAGE_SAMPLE_D_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x3, 0x6 }, // 6671
  { IMAGE_SAMPLE_D_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x3, 0x7 }, // 6672
  { IMAGE_SAMPLE_D_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x3, 0x8 }, // 6673
  { IMAGE_SAMPLE_D_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x3, 0x9 }, // 6674
  { IMAGE_SAMPLE_D_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x3, 0xA }, // 6675
  { IMAGE_SAMPLE_D_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 6676
  { IMAGE_SAMPLE_D_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 6677
  { IMAGE_SAMPLE_D_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 6678
  { IMAGE_SAMPLE_D_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x4, 0x6 }, // 6679
  { IMAGE_SAMPLE_D_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x4, 0x7 }, // 6680
  { IMAGE_SAMPLE_D_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x4, 0x8 }, // 6681
  { IMAGE_SAMPLE_D_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x4, 0x9 }, // 6682
  { IMAGE_SAMPLE_D_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x4, 0xA }, // 6683
  { IMAGE_SAMPLE_D_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 6684
  { IMAGE_SAMPLE_D_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 6685
  { IMAGE_SAMPLE_D_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 6686
  { IMAGE_SAMPLE_D_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x5, 0x6 }, // 6687
  { IMAGE_SAMPLE_D_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x5, 0x7 }, // 6688
  { IMAGE_SAMPLE_D_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x5, 0x8 }, // 6689
  { IMAGE_SAMPLE_D_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x5, 0x9 }, // 6690
  { IMAGE_SAMPLE_D_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_D_O, MIMGEncGfx10NSA, 0x5, 0xA }, // 6691
  { IMAGE_SAMPLE_D_O_V1_V3, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x1, 0x3 }, // 6692
  { IMAGE_SAMPLE_D_O_V1_V4, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x1, 0x4 }, // 6693
  { IMAGE_SAMPLE_D_O_V1_V5, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x1, 0x5 }, // 6694
  { IMAGE_SAMPLE_D_O_V1_V6, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x1, 0x6 }, // 6695
  { IMAGE_SAMPLE_D_O_V1_V7, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x1, 0x7 }, // 6696
  { IMAGE_SAMPLE_D_O_V1_V8, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x1, 0x8 }, // 6697
  { IMAGE_SAMPLE_D_O_V1_V16, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x1, 0x10 }, // 6698
  { IMAGE_SAMPLE_D_O_V2_V3, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x2, 0x3 }, // 6699
  { IMAGE_SAMPLE_D_O_V2_V4, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x2, 0x4 }, // 6700
  { IMAGE_SAMPLE_D_O_V2_V5, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x2, 0x5 }, // 6701
  { IMAGE_SAMPLE_D_O_V2_V6, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x2, 0x6 }, // 6702
  { IMAGE_SAMPLE_D_O_V2_V7, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x2, 0x7 }, // 6703
  { IMAGE_SAMPLE_D_O_V2_V8, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x2, 0x8 }, // 6704
  { IMAGE_SAMPLE_D_O_V2_V16, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x2, 0x10 }, // 6705
  { IMAGE_SAMPLE_D_O_V3_V3, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x3, 0x3 }, // 6706
  { IMAGE_SAMPLE_D_O_V3_V4, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x3, 0x4 }, // 6707
  { IMAGE_SAMPLE_D_O_V3_V5, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x3, 0x5 }, // 6708
  { IMAGE_SAMPLE_D_O_V3_V6, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x3, 0x6 }, // 6709
  { IMAGE_SAMPLE_D_O_V3_V7, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x3, 0x7 }, // 6710
  { IMAGE_SAMPLE_D_O_V3_V8, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x3, 0x8 }, // 6711
  { IMAGE_SAMPLE_D_O_V3_V16, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x3, 0x10 }, // 6712
  { IMAGE_SAMPLE_D_O_V4_V3, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x4, 0x3 }, // 6713
  { IMAGE_SAMPLE_D_O_V4_V4, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x4, 0x4 }, // 6714
  { IMAGE_SAMPLE_D_O_V4_V5, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x4, 0x5 }, // 6715
  { IMAGE_SAMPLE_D_O_V4_V6, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x4, 0x6 }, // 6716
  { IMAGE_SAMPLE_D_O_V4_V7, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x4, 0x7 }, // 6717
  { IMAGE_SAMPLE_D_O_V4_V8, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x4, 0x8 }, // 6718
  { IMAGE_SAMPLE_D_O_V4_V16, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x4, 0x10 }, // 6719
  { IMAGE_SAMPLE_D_O_V5_V3, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x5, 0x3 }, // 6720
  { IMAGE_SAMPLE_D_O_V5_V4, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x5, 0x4 }, // 6721
  { IMAGE_SAMPLE_D_O_V5_V5, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x5, 0x5 }, // 6722
  { IMAGE_SAMPLE_D_O_V5_V6, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x5, 0x6 }, // 6723
  { IMAGE_SAMPLE_D_O_V5_V7, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x5, 0x7 }, // 6724
  { IMAGE_SAMPLE_D_O_V5_V8, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x5, 0x8 }, // 6725
  { IMAGE_SAMPLE_D_O_V5_V16, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x5, 0x10 }, // 6726
  { IMAGE_SAMPLE_D_O_G16_V1_V3_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x1, 0x3 }, // 6727
  { IMAGE_SAMPLE_D_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x1, 0x4 }, // 6728
  { IMAGE_SAMPLE_D_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x1, 0x5 }, // 6729
  { IMAGE_SAMPLE_D_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x1, 0x6 }, // 6730
  { IMAGE_SAMPLE_D_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x1, 0x7 }, // 6731
  { IMAGE_SAMPLE_D_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x1, 0x8 }, // 6732
  { IMAGE_SAMPLE_D_O_G16_V1_V16_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x1, 0x10 }, // 6733
  { IMAGE_SAMPLE_D_O_G16_V2_V3_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x2, 0x3 }, // 6734
  { IMAGE_SAMPLE_D_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x2, 0x4 }, // 6735
  { IMAGE_SAMPLE_D_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x2, 0x5 }, // 6736
  { IMAGE_SAMPLE_D_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x2, 0x6 }, // 6737
  { IMAGE_SAMPLE_D_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x2, 0x7 }, // 6738
  { IMAGE_SAMPLE_D_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x2, 0x8 }, // 6739
  { IMAGE_SAMPLE_D_O_G16_V2_V16_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x2, 0x10 }, // 6740
  { IMAGE_SAMPLE_D_O_G16_V3_V3_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x3, 0x3 }, // 6741
  { IMAGE_SAMPLE_D_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x3, 0x4 }, // 6742
  { IMAGE_SAMPLE_D_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x3, 0x5 }, // 6743
  { IMAGE_SAMPLE_D_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x3, 0x6 }, // 6744
  { IMAGE_SAMPLE_D_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x3, 0x7 }, // 6745
  { IMAGE_SAMPLE_D_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x3, 0x8 }, // 6746
  { IMAGE_SAMPLE_D_O_G16_V3_V16_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x3, 0x10 }, // 6747
  { IMAGE_SAMPLE_D_O_G16_V4_V3_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x4, 0x3 }, // 6748
  { IMAGE_SAMPLE_D_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x4, 0x4 }, // 6749
  { IMAGE_SAMPLE_D_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x4, 0x5 }, // 6750
  { IMAGE_SAMPLE_D_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x4, 0x6 }, // 6751
  { IMAGE_SAMPLE_D_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x4, 0x7 }, // 6752
  { IMAGE_SAMPLE_D_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x4, 0x8 }, // 6753
  { IMAGE_SAMPLE_D_O_G16_V4_V16_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x4, 0x10 }, // 6754
  { IMAGE_SAMPLE_D_O_G16_V5_V3_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x5, 0x3 }, // 6755
  { IMAGE_SAMPLE_D_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x5, 0x4 }, // 6756
  { IMAGE_SAMPLE_D_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x5, 0x5 }, // 6757
  { IMAGE_SAMPLE_D_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x5, 0x6 }, // 6758
  { IMAGE_SAMPLE_D_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x5, 0x7 }, // 6759
  { IMAGE_SAMPLE_D_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x5, 0x8 }, // 6760
  { IMAGE_SAMPLE_D_O_G16_V5_V16_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10Default, 0x5, 0x10 }, // 6761
  { IMAGE_SAMPLE_D_O_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x1, 0x3 }, // 6762
  { IMAGE_SAMPLE_D_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x1, 0x4 }, // 6763
  { IMAGE_SAMPLE_D_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x1, 0x5 }, // 6764
  { IMAGE_SAMPLE_D_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x1, 0x6 }, // 6765
  { IMAGE_SAMPLE_D_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x1, 0x7 }, // 6766
  { IMAGE_SAMPLE_D_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x1, 0x8 }, // 6767
  { IMAGE_SAMPLE_D_O_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x1, 0x9 }, // 6768
  { IMAGE_SAMPLE_D_O_G16_V1_V10_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x1, 0xA }, // 6769
  { IMAGE_SAMPLE_D_O_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x2, 0x3 }, // 6770
  { IMAGE_SAMPLE_D_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x2, 0x4 }, // 6771
  { IMAGE_SAMPLE_D_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x2, 0x5 }, // 6772
  { IMAGE_SAMPLE_D_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x2, 0x6 }, // 6773
  { IMAGE_SAMPLE_D_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x2, 0x7 }, // 6774
  { IMAGE_SAMPLE_D_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x2, 0x8 }, // 6775
  { IMAGE_SAMPLE_D_O_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x2, 0x9 }, // 6776
  { IMAGE_SAMPLE_D_O_G16_V2_V10_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x2, 0xA }, // 6777
  { IMAGE_SAMPLE_D_O_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x3, 0x3 }, // 6778
  { IMAGE_SAMPLE_D_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x3, 0x4 }, // 6779
  { IMAGE_SAMPLE_D_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x3, 0x5 }, // 6780
  { IMAGE_SAMPLE_D_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x3, 0x6 }, // 6781
  { IMAGE_SAMPLE_D_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x3, 0x7 }, // 6782
  { IMAGE_SAMPLE_D_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x3, 0x8 }, // 6783
  { IMAGE_SAMPLE_D_O_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x3, 0x9 }, // 6784
  { IMAGE_SAMPLE_D_O_G16_V3_V10_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x3, 0xA }, // 6785
  { IMAGE_SAMPLE_D_O_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x4, 0x3 }, // 6786
  { IMAGE_SAMPLE_D_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x4, 0x4 }, // 6787
  { IMAGE_SAMPLE_D_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x4, 0x5 }, // 6788
  { IMAGE_SAMPLE_D_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x4, 0x6 }, // 6789
  { IMAGE_SAMPLE_D_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x4, 0x7 }, // 6790
  { IMAGE_SAMPLE_D_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x4, 0x8 }, // 6791
  { IMAGE_SAMPLE_D_O_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x4, 0x9 }, // 6792
  { IMAGE_SAMPLE_D_O_G16_V4_V10_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x4, 0xA }, // 6793
  { IMAGE_SAMPLE_D_O_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x5, 0x3 }, // 6794
  { IMAGE_SAMPLE_D_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x5, 0x4 }, // 6795
  { IMAGE_SAMPLE_D_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x5, 0x5 }, // 6796
  { IMAGE_SAMPLE_D_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x5, 0x6 }, // 6797
  { IMAGE_SAMPLE_D_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x5, 0x7 }, // 6798
  { IMAGE_SAMPLE_D_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x5, 0x8 }, // 6799
  { IMAGE_SAMPLE_D_O_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x5, 0x9 }, // 6800
  { IMAGE_SAMPLE_D_O_G16_V5_V10_nsa_gfx10, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx10NSA, 0x5, 0xA }, // 6801
  { IMAGE_SAMPLE_D_O_G16_V1_V3, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x1, 0x3 }, // 6802
  { IMAGE_SAMPLE_D_O_G16_V1_V4, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x1, 0x4 }, // 6803
  { IMAGE_SAMPLE_D_O_G16_V1_V5, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x1, 0x5 }, // 6804
  { IMAGE_SAMPLE_D_O_G16_V1_V6, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x1, 0x6 }, // 6805
  { IMAGE_SAMPLE_D_O_G16_V1_V7, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x1, 0x7 }, // 6806
  { IMAGE_SAMPLE_D_O_G16_V1_V8, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x1, 0x8 }, // 6807
  { IMAGE_SAMPLE_D_O_G16_V1_V16, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x1, 0x10 }, // 6808
  { IMAGE_SAMPLE_D_O_G16_V2_V3, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x2, 0x3 }, // 6809
  { IMAGE_SAMPLE_D_O_G16_V2_V4, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x2, 0x4 }, // 6810
  { IMAGE_SAMPLE_D_O_G16_V2_V5, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x2, 0x5 }, // 6811
  { IMAGE_SAMPLE_D_O_G16_V2_V6, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x2, 0x6 }, // 6812
  { IMAGE_SAMPLE_D_O_G16_V2_V7, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x2, 0x7 }, // 6813
  { IMAGE_SAMPLE_D_O_G16_V2_V8, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x2, 0x8 }, // 6814
  { IMAGE_SAMPLE_D_O_G16_V2_V16, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x2, 0x10 }, // 6815
  { IMAGE_SAMPLE_D_O_G16_V3_V3, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x3, 0x3 }, // 6816
  { IMAGE_SAMPLE_D_O_G16_V3_V4, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x3, 0x4 }, // 6817
  { IMAGE_SAMPLE_D_O_G16_V3_V5, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x3, 0x5 }, // 6818
  { IMAGE_SAMPLE_D_O_G16_V3_V6, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x3, 0x6 }, // 6819
  { IMAGE_SAMPLE_D_O_G16_V3_V7, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x3, 0x7 }, // 6820
  { IMAGE_SAMPLE_D_O_G16_V3_V8, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x3, 0x8 }, // 6821
  { IMAGE_SAMPLE_D_O_G16_V3_V16, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x3, 0x10 }, // 6822
  { IMAGE_SAMPLE_D_O_G16_V4_V3, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x4, 0x3 }, // 6823
  { IMAGE_SAMPLE_D_O_G16_V4_V4, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x4, 0x4 }, // 6824
  { IMAGE_SAMPLE_D_O_G16_V4_V5, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x4, 0x5 }, // 6825
  { IMAGE_SAMPLE_D_O_G16_V4_V6, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x4, 0x6 }, // 6826
  { IMAGE_SAMPLE_D_O_G16_V4_V7, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x4, 0x7 }, // 6827
  { IMAGE_SAMPLE_D_O_G16_V4_V8, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x4, 0x8 }, // 6828
  { IMAGE_SAMPLE_D_O_G16_V4_V16, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x4, 0x10 }, // 6829
  { IMAGE_SAMPLE_D_O_G16_V5_V3, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x5, 0x3 }, // 6830
  { IMAGE_SAMPLE_D_O_G16_V5_V4, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x5, 0x4 }, // 6831
  { IMAGE_SAMPLE_D_O_G16_V5_V5, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x5, 0x5 }, // 6832
  { IMAGE_SAMPLE_D_O_G16_V5_V6, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x5, 0x6 }, // 6833
  { IMAGE_SAMPLE_D_O_G16_V5_V7, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x5, 0x7 }, // 6834
  { IMAGE_SAMPLE_D_O_G16_V5_V8, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x5, 0x8 }, // 6835
  { IMAGE_SAMPLE_D_O_G16_V5_V16, IMAGE_SAMPLE_D_O_G16, MIMGEncGfx6, 0x5, 0x10 }, // 6836
  { IMAGE_SAMPLE_L_V1_V1_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10Default, 0x1, 0x1 }, // 6837
  { IMAGE_SAMPLE_L_V1_V2_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10Default, 0x1, 0x2 }, // 6838
  { IMAGE_SAMPLE_L_V1_V3_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10Default, 0x1, 0x3 }, // 6839
  { IMAGE_SAMPLE_L_V1_V4_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10Default, 0x1, 0x4 }, // 6840
  { IMAGE_SAMPLE_L_V2_V1_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10Default, 0x2, 0x1 }, // 6841
  { IMAGE_SAMPLE_L_V2_V2_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10Default, 0x2, 0x2 }, // 6842
  { IMAGE_SAMPLE_L_V2_V3_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10Default, 0x2, 0x3 }, // 6843
  { IMAGE_SAMPLE_L_V2_V4_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10Default, 0x2, 0x4 }, // 6844
  { IMAGE_SAMPLE_L_V3_V1_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10Default, 0x3, 0x1 }, // 6845
  { IMAGE_SAMPLE_L_V3_V2_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10Default, 0x3, 0x2 }, // 6846
  { IMAGE_SAMPLE_L_V3_V3_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10Default, 0x3, 0x3 }, // 6847
  { IMAGE_SAMPLE_L_V3_V4_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10Default, 0x3, 0x4 }, // 6848
  { IMAGE_SAMPLE_L_V4_V1_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10Default, 0x4, 0x1 }, // 6849
  { IMAGE_SAMPLE_L_V4_V2_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10Default, 0x4, 0x2 }, // 6850
  { IMAGE_SAMPLE_L_V4_V3_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10Default, 0x4, 0x3 }, // 6851
  { IMAGE_SAMPLE_L_V4_V4_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10Default, 0x4, 0x4 }, // 6852
  { IMAGE_SAMPLE_L_V5_V1_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10Default, 0x5, 0x1 }, // 6853
  { IMAGE_SAMPLE_L_V5_V2_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10Default, 0x5, 0x2 }, // 6854
  { IMAGE_SAMPLE_L_V5_V3_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10Default, 0x5, 0x3 }, // 6855
  { IMAGE_SAMPLE_L_V5_V4_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10Default, 0x5, 0x4 }, // 6856
  { IMAGE_SAMPLE_L_V1_V2_nsa_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10NSA, 0x1, 0x2 }, // 6857
  { IMAGE_SAMPLE_L_V1_V3_nsa_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10NSA, 0x1, 0x3 }, // 6858
  { IMAGE_SAMPLE_L_V1_V4_nsa_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10NSA, 0x1, 0x4 }, // 6859
  { IMAGE_SAMPLE_L_V2_V2_nsa_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10NSA, 0x2, 0x2 }, // 6860
  { IMAGE_SAMPLE_L_V2_V3_nsa_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10NSA, 0x2, 0x3 }, // 6861
  { IMAGE_SAMPLE_L_V2_V4_nsa_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10NSA, 0x2, 0x4 }, // 6862
  { IMAGE_SAMPLE_L_V3_V2_nsa_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10NSA, 0x3, 0x2 }, // 6863
  { IMAGE_SAMPLE_L_V3_V3_nsa_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10NSA, 0x3, 0x3 }, // 6864
  { IMAGE_SAMPLE_L_V3_V4_nsa_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10NSA, 0x3, 0x4 }, // 6865
  { IMAGE_SAMPLE_L_V4_V2_nsa_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10NSA, 0x4, 0x2 }, // 6866
  { IMAGE_SAMPLE_L_V4_V3_nsa_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10NSA, 0x4, 0x3 }, // 6867
  { IMAGE_SAMPLE_L_V4_V4_nsa_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10NSA, 0x4, 0x4 }, // 6868
  { IMAGE_SAMPLE_L_V5_V2_nsa_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10NSA, 0x5, 0x2 }, // 6869
  { IMAGE_SAMPLE_L_V5_V3_nsa_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10NSA, 0x5, 0x3 }, // 6870
  { IMAGE_SAMPLE_L_V5_V4_nsa_gfx10, IMAGE_SAMPLE_L, MIMGEncGfx10NSA, 0x5, 0x4 }, // 6871
  { IMAGE_SAMPLE_L_V1_V1, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x1, 0x1 }, // 6872
  { IMAGE_SAMPLE_L_V1_V2, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x1, 0x2 }, // 6873
  { IMAGE_SAMPLE_L_V1_V3, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x1, 0x3 }, // 6874
  { IMAGE_SAMPLE_L_V1_V4, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x1, 0x4 }, // 6875
  { IMAGE_SAMPLE_L_V2_V1, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x2, 0x1 }, // 6876
  { IMAGE_SAMPLE_L_V2_V2, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x2, 0x2 }, // 6877
  { IMAGE_SAMPLE_L_V2_V3, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x2, 0x3 }, // 6878
  { IMAGE_SAMPLE_L_V2_V4, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x2, 0x4 }, // 6879
  { IMAGE_SAMPLE_L_V3_V1, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x3, 0x1 }, // 6880
  { IMAGE_SAMPLE_L_V3_V2, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x3, 0x2 }, // 6881
  { IMAGE_SAMPLE_L_V3_V3, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x3, 0x3 }, // 6882
  { IMAGE_SAMPLE_L_V3_V4, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x3, 0x4 }, // 6883
  { IMAGE_SAMPLE_L_V4_V1, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x4, 0x1 }, // 6884
  { IMAGE_SAMPLE_L_V4_V2, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x4, 0x2 }, // 6885
  { IMAGE_SAMPLE_L_V4_V3, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x4, 0x3 }, // 6886
  { IMAGE_SAMPLE_L_V4_V4, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x4, 0x4 }, // 6887
  { IMAGE_SAMPLE_L_V5_V1, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x5, 0x1 }, // 6888
  { IMAGE_SAMPLE_L_V5_V2, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x5, 0x2 }, // 6889
  { IMAGE_SAMPLE_L_V5_V3, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x5, 0x3 }, // 6890
  { IMAGE_SAMPLE_L_V5_V4, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x5, 0x4 }, // 6891
  { IMAGE_SAMPLE_LZ_V1_V1_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10Default, 0x1, 0x1 }, // 6892
  { IMAGE_SAMPLE_LZ_V1_V2_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10Default, 0x1, 0x2 }, // 6893
  { IMAGE_SAMPLE_LZ_V1_V3_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10Default, 0x1, 0x3 }, // 6894
  { IMAGE_SAMPLE_LZ_V1_V4_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10Default, 0x1, 0x4 }, // 6895
  { IMAGE_SAMPLE_LZ_V2_V1_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10Default, 0x2, 0x1 }, // 6896
  { IMAGE_SAMPLE_LZ_V2_V2_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10Default, 0x2, 0x2 }, // 6897
  { IMAGE_SAMPLE_LZ_V2_V3_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10Default, 0x2, 0x3 }, // 6898
  { IMAGE_SAMPLE_LZ_V2_V4_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10Default, 0x2, 0x4 }, // 6899
  { IMAGE_SAMPLE_LZ_V3_V1_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10Default, 0x3, 0x1 }, // 6900
  { IMAGE_SAMPLE_LZ_V3_V2_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10Default, 0x3, 0x2 }, // 6901
  { IMAGE_SAMPLE_LZ_V3_V3_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10Default, 0x3, 0x3 }, // 6902
  { IMAGE_SAMPLE_LZ_V3_V4_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10Default, 0x3, 0x4 }, // 6903
  { IMAGE_SAMPLE_LZ_V4_V1_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10Default, 0x4, 0x1 }, // 6904
  { IMAGE_SAMPLE_LZ_V4_V2_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10Default, 0x4, 0x2 }, // 6905
  { IMAGE_SAMPLE_LZ_V4_V3_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10Default, 0x4, 0x3 }, // 6906
  { IMAGE_SAMPLE_LZ_V4_V4_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10Default, 0x4, 0x4 }, // 6907
  { IMAGE_SAMPLE_LZ_V5_V1_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10Default, 0x5, 0x1 }, // 6908
  { IMAGE_SAMPLE_LZ_V5_V2_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10Default, 0x5, 0x2 }, // 6909
  { IMAGE_SAMPLE_LZ_V5_V3_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10Default, 0x5, 0x3 }, // 6910
  { IMAGE_SAMPLE_LZ_V5_V4_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10Default, 0x5, 0x4 }, // 6911
  { IMAGE_SAMPLE_LZ_V1_V2_nsa_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10NSA, 0x1, 0x2 }, // 6912
  { IMAGE_SAMPLE_LZ_V1_V3_nsa_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10NSA, 0x1, 0x3 }, // 6913
  { IMAGE_SAMPLE_LZ_V2_V2_nsa_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10NSA, 0x2, 0x2 }, // 6914
  { IMAGE_SAMPLE_LZ_V2_V3_nsa_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10NSA, 0x2, 0x3 }, // 6915
  { IMAGE_SAMPLE_LZ_V3_V2_nsa_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10NSA, 0x3, 0x2 }, // 6916
  { IMAGE_SAMPLE_LZ_V3_V3_nsa_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10NSA, 0x3, 0x3 }, // 6917
  { IMAGE_SAMPLE_LZ_V4_V2_nsa_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10NSA, 0x4, 0x2 }, // 6918
  { IMAGE_SAMPLE_LZ_V4_V3_nsa_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10NSA, 0x4, 0x3 }, // 6919
  { IMAGE_SAMPLE_LZ_V5_V2_nsa_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10NSA, 0x5, 0x2 }, // 6920
  { IMAGE_SAMPLE_LZ_V5_V3_nsa_gfx10, IMAGE_SAMPLE_LZ, MIMGEncGfx10NSA, 0x5, 0x3 }, // 6921
  { IMAGE_SAMPLE_LZ_V1_V1, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x1, 0x1 }, // 6922
  { IMAGE_SAMPLE_LZ_V1_V2, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x1, 0x2 }, // 6923
  { IMAGE_SAMPLE_LZ_V1_V3, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x1, 0x3 }, // 6924
  { IMAGE_SAMPLE_LZ_V1_V4, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x1, 0x4 }, // 6925
  { IMAGE_SAMPLE_LZ_V2_V1, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x2, 0x1 }, // 6926
  { IMAGE_SAMPLE_LZ_V2_V2, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x2, 0x2 }, // 6927
  { IMAGE_SAMPLE_LZ_V2_V3, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x2, 0x3 }, // 6928
  { IMAGE_SAMPLE_LZ_V2_V4, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x2, 0x4 }, // 6929
  { IMAGE_SAMPLE_LZ_V3_V1, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x3, 0x1 }, // 6930
  { IMAGE_SAMPLE_LZ_V3_V2, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x3, 0x2 }, // 6931
  { IMAGE_SAMPLE_LZ_V3_V3, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x3, 0x3 }, // 6932
  { IMAGE_SAMPLE_LZ_V3_V4, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x3, 0x4 }, // 6933
  { IMAGE_SAMPLE_LZ_V4_V1, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x4, 0x1 }, // 6934
  { IMAGE_SAMPLE_LZ_V4_V2, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x4, 0x2 }, // 6935
  { IMAGE_SAMPLE_LZ_V4_V3, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x4, 0x3 }, // 6936
  { IMAGE_SAMPLE_LZ_V4_V4, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x4, 0x4 }, // 6937
  { IMAGE_SAMPLE_LZ_V5_V1, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x5, 0x1 }, // 6938
  { IMAGE_SAMPLE_LZ_V5_V2, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x5, 0x2 }, // 6939
  { IMAGE_SAMPLE_LZ_V5_V3, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x5, 0x3 }, // 6940
  { IMAGE_SAMPLE_LZ_V5_V4, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x5, 0x4 }, // 6941
  { IMAGE_SAMPLE_LZ_O_V1_V2_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10Default, 0x1, 0x2 }, // 6942
  { IMAGE_SAMPLE_LZ_O_V1_V3_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10Default, 0x1, 0x3 }, // 6943
  { IMAGE_SAMPLE_LZ_O_V1_V4_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10Default, 0x1, 0x4 }, // 6944
  { IMAGE_SAMPLE_LZ_O_V2_V2_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10Default, 0x2, 0x2 }, // 6945
  { IMAGE_SAMPLE_LZ_O_V2_V3_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 6946
  { IMAGE_SAMPLE_LZ_O_V2_V4_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 6947
  { IMAGE_SAMPLE_LZ_O_V3_V2_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10Default, 0x3, 0x2 }, // 6948
  { IMAGE_SAMPLE_LZ_O_V3_V3_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10Default, 0x3, 0x3 }, // 6949
  { IMAGE_SAMPLE_LZ_O_V3_V4_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10Default, 0x3, 0x4 }, // 6950
  { IMAGE_SAMPLE_LZ_O_V4_V2_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10Default, 0x4, 0x2 }, // 6951
  { IMAGE_SAMPLE_LZ_O_V4_V3_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 6952
  { IMAGE_SAMPLE_LZ_O_V4_V4_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 6953
  { IMAGE_SAMPLE_LZ_O_V5_V2_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10Default, 0x5, 0x2 }, // 6954
  { IMAGE_SAMPLE_LZ_O_V5_V3_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 6955
  { IMAGE_SAMPLE_LZ_O_V5_V4_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 6956
  { IMAGE_SAMPLE_LZ_O_V1_V2_nsa_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10NSA, 0x1, 0x2 }, // 6957
  { IMAGE_SAMPLE_LZ_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10NSA, 0x1, 0x3 }, // 6958
  { IMAGE_SAMPLE_LZ_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10NSA, 0x1, 0x4 }, // 6959
  { IMAGE_SAMPLE_LZ_O_V2_V2_nsa_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10NSA, 0x2, 0x2 }, // 6960
  { IMAGE_SAMPLE_LZ_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 6961
  { IMAGE_SAMPLE_LZ_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 6962
  { IMAGE_SAMPLE_LZ_O_V3_V2_nsa_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10NSA, 0x3, 0x2 }, // 6963
  { IMAGE_SAMPLE_LZ_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10NSA, 0x3, 0x3 }, // 6964
  { IMAGE_SAMPLE_LZ_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10NSA, 0x3, 0x4 }, // 6965
  { IMAGE_SAMPLE_LZ_O_V4_V2_nsa_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10NSA, 0x4, 0x2 }, // 6966
  { IMAGE_SAMPLE_LZ_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 6967
  { IMAGE_SAMPLE_LZ_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 6968
  { IMAGE_SAMPLE_LZ_O_V5_V2_nsa_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10NSA, 0x5, 0x2 }, // 6969
  { IMAGE_SAMPLE_LZ_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 6970
  { IMAGE_SAMPLE_LZ_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_LZ_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 6971
  { IMAGE_SAMPLE_LZ_O_V1_V2, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x1, 0x2 }, // 6972
  { IMAGE_SAMPLE_LZ_O_V1_V3, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x1, 0x3 }, // 6973
  { IMAGE_SAMPLE_LZ_O_V1_V4, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x1, 0x4 }, // 6974
  { IMAGE_SAMPLE_LZ_O_V2_V2, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x2, 0x2 }, // 6975
  { IMAGE_SAMPLE_LZ_O_V2_V3, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x2, 0x3 }, // 6976
  { IMAGE_SAMPLE_LZ_O_V2_V4, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x2, 0x4 }, // 6977
  { IMAGE_SAMPLE_LZ_O_V3_V2, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x3, 0x2 }, // 6978
  { IMAGE_SAMPLE_LZ_O_V3_V3, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x3, 0x3 }, // 6979
  { IMAGE_SAMPLE_LZ_O_V3_V4, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x3, 0x4 }, // 6980
  { IMAGE_SAMPLE_LZ_O_V4_V2, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x4, 0x2 }, // 6981
  { IMAGE_SAMPLE_LZ_O_V4_V3, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x4, 0x3 }, // 6982
  { IMAGE_SAMPLE_LZ_O_V4_V4, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x4, 0x4 }, // 6983
  { IMAGE_SAMPLE_LZ_O_V5_V2, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x5, 0x2 }, // 6984
  { IMAGE_SAMPLE_LZ_O_V5_V3, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x5, 0x3 }, // 6985
  { IMAGE_SAMPLE_LZ_O_V5_V4, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x5, 0x4 }, // 6986
  { IMAGE_SAMPLE_L_O_V1_V2_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x1, 0x2 }, // 6987
  { IMAGE_SAMPLE_L_O_V1_V3_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x1, 0x3 }, // 6988
  { IMAGE_SAMPLE_L_O_V1_V4_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x1, 0x4 }, // 6989
  { IMAGE_SAMPLE_L_O_V1_V5_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x1, 0x5 }, // 6990
  { IMAGE_SAMPLE_L_O_V1_V8_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x1, 0x8 }, // 6991
  { IMAGE_SAMPLE_L_O_V2_V2_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x2, 0x2 }, // 6992
  { IMAGE_SAMPLE_L_O_V2_V3_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 6993
  { IMAGE_SAMPLE_L_O_V2_V4_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 6994
  { IMAGE_SAMPLE_L_O_V2_V5_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x2, 0x5 }, // 6995
  { IMAGE_SAMPLE_L_O_V2_V8_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x2, 0x8 }, // 6996
  { IMAGE_SAMPLE_L_O_V3_V2_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x3, 0x2 }, // 6997
  { IMAGE_SAMPLE_L_O_V3_V3_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x3, 0x3 }, // 6998
  { IMAGE_SAMPLE_L_O_V3_V4_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x3, 0x4 }, // 6999
  { IMAGE_SAMPLE_L_O_V3_V5_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x3, 0x5 }, // 7000
  { IMAGE_SAMPLE_L_O_V3_V8_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x3, 0x8 }, // 7001
  { IMAGE_SAMPLE_L_O_V4_V2_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x4, 0x2 }, // 7002
  { IMAGE_SAMPLE_L_O_V4_V3_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 7003
  { IMAGE_SAMPLE_L_O_V4_V4_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 7004
  { IMAGE_SAMPLE_L_O_V4_V5_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x4, 0x5 }, // 7005
  { IMAGE_SAMPLE_L_O_V4_V8_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x4, 0x8 }, // 7006
  { IMAGE_SAMPLE_L_O_V5_V2_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x5, 0x2 }, // 7007
  { IMAGE_SAMPLE_L_O_V5_V3_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 7008
  { IMAGE_SAMPLE_L_O_V5_V4_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 7009
  { IMAGE_SAMPLE_L_O_V5_V5_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x5, 0x5 }, // 7010
  { IMAGE_SAMPLE_L_O_V5_V8_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10Default, 0x5, 0x8 }, // 7011
  { IMAGE_SAMPLE_L_O_V1_V2_nsa_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10NSA, 0x1, 0x2 }, // 7012
  { IMAGE_SAMPLE_L_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10NSA, 0x1, 0x3 }, // 7013
  { IMAGE_SAMPLE_L_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10NSA, 0x1, 0x4 }, // 7014
  { IMAGE_SAMPLE_L_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10NSA, 0x1, 0x5 }, // 7015
  { IMAGE_SAMPLE_L_O_V2_V2_nsa_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10NSA, 0x2, 0x2 }, // 7016
  { IMAGE_SAMPLE_L_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 7017
  { IMAGE_SAMPLE_L_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 7018
  { IMAGE_SAMPLE_L_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10NSA, 0x2, 0x5 }, // 7019
  { IMAGE_SAMPLE_L_O_V3_V2_nsa_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10NSA, 0x3, 0x2 }, // 7020
  { IMAGE_SAMPLE_L_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10NSA, 0x3, 0x3 }, // 7021
  { IMAGE_SAMPLE_L_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10NSA, 0x3, 0x4 }, // 7022
  { IMAGE_SAMPLE_L_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10NSA, 0x3, 0x5 }, // 7023
  { IMAGE_SAMPLE_L_O_V4_V2_nsa_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10NSA, 0x4, 0x2 }, // 7024
  { IMAGE_SAMPLE_L_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 7025
  { IMAGE_SAMPLE_L_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 7026
  { IMAGE_SAMPLE_L_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10NSA, 0x4, 0x5 }, // 7027
  { IMAGE_SAMPLE_L_O_V5_V2_nsa_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10NSA, 0x5, 0x2 }, // 7028
  { IMAGE_SAMPLE_L_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 7029
  { IMAGE_SAMPLE_L_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 7030
  { IMAGE_SAMPLE_L_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_L_O, MIMGEncGfx10NSA, 0x5, 0x5 }, // 7031
  { IMAGE_SAMPLE_L_O_V1_V2, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x1, 0x2 }, // 7032
  { IMAGE_SAMPLE_L_O_V1_V3, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x1, 0x3 }, // 7033
  { IMAGE_SAMPLE_L_O_V1_V4, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x1, 0x4 }, // 7034
  { IMAGE_SAMPLE_L_O_V1_V5, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x1, 0x5 }, // 7035
  { IMAGE_SAMPLE_L_O_V1_V8, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x1, 0x8 }, // 7036
  { IMAGE_SAMPLE_L_O_V2_V2, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x2, 0x2 }, // 7037
  { IMAGE_SAMPLE_L_O_V2_V3, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x2, 0x3 }, // 7038
  { IMAGE_SAMPLE_L_O_V2_V4, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x2, 0x4 }, // 7039
  { IMAGE_SAMPLE_L_O_V2_V5, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x2, 0x5 }, // 7040
  { IMAGE_SAMPLE_L_O_V2_V8, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x2, 0x8 }, // 7041
  { IMAGE_SAMPLE_L_O_V3_V2, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x3, 0x2 }, // 7042
  { IMAGE_SAMPLE_L_O_V3_V3, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x3, 0x3 }, // 7043
  { IMAGE_SAMPLE_L_O_V3_V4, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x3, 0x4 }, // 7044
  { IMAGE_SAMPLE_L_O_V3_V5, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x3, 0x5 }, // 7045
  { IMAGE_SAMPLE_L_O_V3_V8, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x3, 0x8 }, // 7046
  { IMAGE_SAMPLE_L_O_V4_V2, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x4, 0x2 }, // 7047
  { IMAGE_SAMPLE_L_O_V4_V3, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x4, 0x3 }, // 7048
  { IMAGE_SAMPLE_L_O_V4_V4, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x4, 0x4 }, // 7049
  { IMAGE_SAMPLE_L_O_V4_V5, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x4, 0x5 }, // 7050
  { IMAGE_SAMPLE_L_O_V4_V8, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x4, 0x8 }, // 7051
  { IMAGE_SAMPLE_L_O_V5_V2, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x5, 0x2 }, // 7052
  { IMAGE_SAMPLE_L_O_V5_V3, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x5, 0x3 }, // 7053
  { IMAGE_SAMPLE_L_O_V5_V4, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x5, 0x4 }, // 7054
  { IMAGE_SAMPLE_L_O_V5_V5, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x5, 0x5 }, // 7055
  { IMAGE_SAMPLE_L_O_V5_V8, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x5, 0x8 }, // 7056
  { IMAGE_SAMPLE_O_V1_V2_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10Default, 0x1, 0x2 }, // 7057
  { IMAGE_SAMPLE_O_V1_V3_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10Default, 0x1, 0x3 }, // 7058
  { IMAGE_SAMPLE_O_V1_V4_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10Default, 0x1, 0x4 }, // 7059
  { IMAGE_SAMPLE_O_V2_V2_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10Default, 0x2, 0x2 }, // 7060
  { IMAGE_SAMPLE_O_V2_V3_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10Default, 0x2, 0x3 }, // 7061
  { IMAGE_SAMPLE_O_V2_V4_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10Default, 0x2, 0x4 }, // 7062
  { IMAGE_SAMPLE_O_V3_V2_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10Default, 0x3, 0x2 }, // 7063
  { IMAGE_SAMPLE_O_V3_V3_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10Default, 0x3, 0x3 }, // 7064
  { IMAGE_SAMPLE_O_V3_V4_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10Default, 0x3, 0x4 }, // 7065
  { IMAGE_SAMPLE_O_V4_V2_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10Default, 0x4, 0x2 }, // 7066
  { IMAGE_SAMPLE_O_V4_V3_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10Default, 0x4, 0x3 }, // 7067
  { IMAGE_SAMPLE_O_V4_V4_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10Default, 0x4, 0x4 }, // 7068
  { IMAGE_SAMPLE_O_V5_V2_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10Default, 0x5, 0x2 }, // 7069
  { IMAGE_SAMPLE_O_V5_V3_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10Default, 0x5, 0x3 }, // 7070
  { IMAGE_SAMPLE_O_V5_V4_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10Default, 0x5, 0x4 }, // 7071
  { IMAGE_SAMPLE_O_V1_V2_nsa_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10NSA, 0x1, 0x2 }, // 7072
  { IMAGE_SAMPLE_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10NSA, 0x1, 0x3 }, // 7073
  { IMAGE_SAMPLE_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10NSA, 0x1, 0x4 }, // 7074
  { IMAGE_SAMPLE_O_V2_V2_nsa_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10NSA, 0x2, 0x2 }, // 7075
  { IMAGE_SAMPLE_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10NSA, 0x2, 0x3 }, // 7076
  { IMAGE_SAMPLE_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10NSA, 0x2, 0x4 }, // 7077
  { IMAGE_SAMPLE_O_V3_V2_nsa_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10NSA, 0x3, 0x2 }, // 7078
  { IMAGE_SAMPLE_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10NSA, 0x3, 0x3 }, // 7079
  { IMAGE_SAMPLE_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10NSA, 0x3, 0x4 }, // 7080
  { IMAGE_SAMPLE_O_V4_V2_nsa_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10NSA, 0x4, 0x2 }, // 7081
  { IMAGE_SAMPLE_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10NSA, 0x4, 0x3 }, // 7082
  { IMAGE_SAMPLE_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10NSA, 0x4, 0x4 }, // 7083
  { IMAGE_SAMPLE_O_V5_V2_nsa_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10NSA, 0x5, 0x2 }, // 7084
  { IMAGE_SAMPLE_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10NSA, 0x5, 0x3 }, // 7085
  { IMAGE_SAMPLE_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_O, MIMGEncGfx10NSA, 0x5, 0x4 }, // 7086
  { IMAGE_SAMPLE_O_V1_V2, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x1, 0x2 }, // 7087
  { IMAGE_SAMPLE_O_V1_V3, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x1, 0x3 }, // 7088
  { IMAGE_SAMPLE_O_V1_V4, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x1, 0x4 }, // 7089
  { IMAGE_SAMPLE_O_V2_V2, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x2, 0x2 }, // 7090
  { IMAGE_SAMPLE_O_V2_V3, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x2, 0x3 }, // 7091
  { IMAGE_SAMPLE_O_V2_V4, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x2, 0x4 }, // 7092
  { IMAGE_SAMPLE_O_V3_V2, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x3, 0x2 }, // 7093
  { IMAGE_SAMPLE_O_V3_V3, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x3, 0x3 }, // 7094
  { IMAGE_SAMPLE_O_V3_V4, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x3, 0x4 }, // 7095
  { IMAGE_SAMPLE_O_V4_V2, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x4, 0x2 }, // 7096
  { IMAGE_SAMPLE_O_V4_V3, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x4, 0x3 }, // 7097
  { IMAGE_SAMPLE_O_V4_V4, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x4, 0x4 }, // 7098
  { IMAGE_SAMPLE_O_V5_V2, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x5, 0x2 }, // 7099
  { IMAGE_SAMPLE_O_V5_V3, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x5, 0x3 }, // 7100
  { IMAGE_SAMPLE_O_V5_V4, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x5, 0x4 }, // 7101
  { IMAGE_STORE_V1_V1_gfx10, IMAGE_STORE, MIMGEncGfx10Default, 0x1, 0x1 }, // 7102
  { IMAGE_STORE_V1_V2_gfx10, IMAGE_STORE, MIMGEncGfx10Default, 0x1, 0x2 }, // 7103
  { IMAGE_STORE_V1_V3_gfx10, IMAGE_STORE, MIMGEncGfx10Default, 0x1, 0x3 }, // 7104
  { IMAGE_STORE_V1_V4_gfx10, IMAGE_STORE, MIMGEncGfx10Default, 0x1, 0x4 }, // 7105
  { IMAGE_STORE_V2_V1_gfx10, IMAGE_STORE, MIMGEncGfx10Default, 0x2, 0x1 }, // 7106
  { IMAGE_STORE_V2_V2_gfx10, IMAGE_STORE, MIMGEncGfx10Default, 0x2, 0x2 }, // 7107
  { IMAGE_STORE_V2_V3_gfx10, IMAGE_STORE, MIMGEncGfx10Default, 0x2, 0x3 }, // 7108
  { IMAGE_STORE_V2_V4_gfx10, IMAGE_STORE, MIMGEncGfx10Default, 0x2, 0x4 }, // 7109
  { IMAGE_STORE_V3_V1_gfx10, IMAGE_STORE, MIMGEncGfx10Default, 0x3, 0x1 }, // 7110
  { IMAGE_STORE_V3_V2_gfx10, IMAGE_STORE, MIMGEncGfx10Default, 0x3, 0x2 }, // 7111
  { IMAGE_STORE_V3_V3_gfx10, IMAGE_STORE, MIMGEncGfx10Default, 0x3, 0x3 }, // 7112
  { IMAGE_STORE_V3_V4_gfx10, IMAGE_STORE, MIMGEncGfx10Default, 0x3, 0x4 }, // 7113
  { IMAGE_STORE_V4_V1_gfx10, IMAGE_STORE, MIMGEncGfx10Default, 0x4, 0x1 }, // 7114
  { IMAGE_STORE_V4_V2_gfx10, IMAGE_STORE, MIMGEncGfx10Default, 0x4, 0x2 }, // 7115
  { IMAGE_STORE_V4_V3_gfx10, IMAGE_STORE, MIMGEncGfx10Default, 0x4, 0x3 }, // 7116
  { IMAGE_STORE_V4_V4_gfx10, IMAGE_STORE, MIMGEncGfx10Default, 0x4, 0x4 }, // 7117
  { IMAGE_STORE_V5_V1_gfx10, IMAGE_STORE, MIMGEncGfx10Default, 0x5, 0x1 }, // 7118
  { IMAGE_STORE_V5_V2_gfx10, IMAGE_STORE, MIMGEncGfx10Default, 0x5, 0x2 }, // 7119
  { IMAGE_STORE_V5_V3_gfx10, IMAGE_STORE, MIMGEncGfx10Default, 0x5, 0x3 }, // 7120
  { IMAGE_STORE_V5_V4_gfx10, IMAGE_STORE, MIMGEncGfx10Default, 0x5, 0x4 }, // 7121
  { IMAGE_STORE_V1_V2_nsa_gfx10, IMAGE_STORE, MIMGEncGfx10NSA, 0x1, 0x2 }, // 7122
  { IMAGE_STORE_V1_V3_nsa_gfx10, IMAGE_STORE, MIMGEncGfx10NSA, 0x1, 0x3 }, // 7123
  { IMAGE_STORE_V1_V4_nsa_gfx10, IMAGE_STORE, MIMGEncGfx10NSA, 0x1, 0x4 }, // 7124
  { IMAGE_STORE_V2_V2_nsa_gfx10, IMAGE_STORE, MIMGEncGfx10NSA, 0x2, 0x2 }, // 7125
  { IMAGE_STORE_V2_V3_nsa_gfx10, IMAGE_STORE, MIMGEncGfx10NSA, 0x2, 0x3 }, // 7126
  { IMAGE_STORE_V2_V4_nsa_gfx10, IMAGE_STORE, MIMGEncGfx10NSA, 0x2, 0x4 }, // 7127
  { IMAGE_STORE_V3_V2_nsa_gfx10, IMAGE_STORE, MIMGEncGfx10NSA, 0x3, 0x2 }, // 7128
  { IMAGE_STORE_V3_V3_nsa_gfx10, IMAGE_STORE, MIMGEncGfx10NSA, 0x3, 0x3 }, // 7129
  { IMAGE_STORE_V3_V4_nsa_gfx10, IMAGE_STORE, MIMGEncGfx10NSA, 0x3, 0x4 }, // 7130
  { IMAGE_STORE_V4_V2_nsa_gfx10, IMAGE_STORE, MIMGEncGfx10NSA, 0x4, 0x2 }, // 7131
  { IMAGE_STORE_V4_V3_nsa_gfx10, IMAGE_STORE, MIMGEncGfx10NSA, 0x4, 0x3 }, // 7132
  { IMAGE_STORE_V4_V4_nsa_gfx10, IMAGE_STORE, MIMGEncGfx10NSA, 0x4, 0x4 }, // 7133
  { IMAGE_STORE_V5_V2_nsa_gfx10, IMAGE_STORE, MIMGEncGfx10NSA, 0x5, 0x2 }, // 7134
  { IMAGE_STORE_V5_V3_nsa_gfx10, IMAGE_STORE, MIMGEncGfx10NSA, 0x5, 0x3 }, // 7135
  { IMAGE_STORE_V5_V4_nsa_gfx10, IMAGE_STORE, MIMGEncGfx10NSA, 0x5, 0x4 }, // 7136
  { IMAGE_STORE_V1_V1, IMAGE_STORE, MIMGEncGfx6, 0x1, 0x1 }, // 7137
  { IMAGE_STORE_V1_V2, IMAGE_STORE, MIMGEncGfx6, 0x1, 0x2 }, // 7138
  { IMAGE_STORE_V1_V3, IMAGE_STORE, MIMGEncGfx6, 0x1, 0x3 }, // 7139
  { IMAGE_STORE_V1_V4, IMAGE_STORE, MIMGEncGfx6, 0x1, 0x4 }, // 7140
  { IMAGE_STORE_V2_V1, IMAGE_STORE, MIMGEncGfx6, 0x2, 0x1 }, // 7141
  { IMAGE_STORE_V2_V2, IMAGE_STORE, MIMGEncGfx6, 0x2, 0x2 }, // 7142
  { IMAGE_STORE_V2_V3, IMAGE_STORE, MIMGEncGfx6, 0x2, 0x3 }, // 7143
  { IMAGE_STORE_V2_V4, IMAGE_STORE, MIMGEncGfx6, 0x2, 0x4 }, // 7144
  { IMAGE_STORE_V3_V1, IMAGE_STORE, MIMGEncGfx6, 0x3, 0x1 }, // 7145
  { IMAGE_STORE_V3_V2, IMAGE_STORE, MIMGEncGfx6, 0x3, 0x2 }, // 7146
  { IMAGE_STORE_V3_V3, IMAGE_STORE, MIMGEncGfx6, 0x3, 0x3 }, // 7147
  { IMAGE_STORE_V3_V4, IMAGE_STORE, MIMGEncGfx6, 0x3, 0x4 }, // 7148
  { IMAGE_STORE_V4_V1, IMAGE_STORE, MIMGEncGfx6, 0x4, 0x1 }, // 7149
  { IMAGE_STORE_V4_V2, IMAGE_STORE, MIMGEncGfx6, 0x4, 0x2 }, // 7150
  { IMAGE_STORE_V4_V3, IMAGE_STORE, MIMGEncGfx6, 0x4, 0x3 }, // 7151
  { IMAGE_STORE_V4_V4, IMAGE_STORE, MIMGEncGfx6, 0x4, 0x4 }, // 7152
  { IMAGE_STORE_V5_V1, IMAGE_STORE, MIMGEncGfx6, 0x5, 0x1 }, // 7153
  { IMAGE_STORE_V5_V2, IMAGE_STORE, MIMGEncGfx6, 0x5, 0x2 }, // 7154
  { IMAGE_STORE_V5_V3, IMAGE_STORE, MIMGEncGfx6, 0x5, 0x3 }, // 7155
  { IMAGE_STORE_V5_V4, IMAGE_STORE, MIMGEncGfx6, 0x5, 0x4 }, // 7156
  { IMAGE_STORE_V1_V1_gfx90a, IMAGE_STORE, MIMGEncGfx90a, 0x1, 0x1 }, // 7157
  { IMAGE_STORE_V1_V2_gfx90a, IMAGE_STORE, MIMGEncGfx90a, 0x1, 0x2 }, // 7158
  { IMAGE_STORE_V1_V3_gfx90a, IMAGE_STORE, MIMGEncGfx90a, 0x1, 0x3 }, // 7159
  { IMAGE_STORE_V1_V4_gfx90a, IMAGE_STORE, MIMGEncGfx90a, 0x1, 0x4 }, // 7160
  { IMAGE_STORE_V2_V1_gfx90a, IMAGE_STORE, MIMGEncGfx90a, 0x2, 0x1 }, // 7161
  { IMAGE_STORE_V2_V2_gfx90a, IMAGE_STORE, MIMGEncGfx90a, 0x2, 0x2 }, // 7162
  { IMAGE_STORE_V2_V3_gfx90a, IMAGE_STORE, MIMGEncGfx90a, 0x2, 0x3 }, // 7163
  { IMAGE_STORE_V2_V4_gfx90a, IMAGE_STORE, MIMGEncGfx90a, 0x2, 0x4 }, // 7164
  { IMAGE_STORE_V3_V1_gfx90a, IMAGE_STORE, MIMGEncGfx90a, 0x3, 0x1 }, // 7165
  { IMAGE_STORE_V3_V2_gfx90a, IMAGE_STORE, MIMGEncGfx90a, 0x3, 0x2 }, // 7166
  { IMAGE_STORE_V3_V3_gfx90a, IMAGE_STORE, MIMGEncGfx90a, 0x3, 0x3 }, // 7167
  { IMAGE_STORE_V3_V4_gfx90a, IMAGE_STORE, MIMGEncGfx90a, 0x3, 0x4 }, // 7168
  { IMAGE_STORE_V4_V1_gfx90a, IMAGE_STORE, MIMGEncGfx90a, 0x4, 0x1 }, // 7169
  { IMAGE_STORE_V4_V2_gfx90a, IMAGE_STORE, MIMGEncGfx90a, 0x4, 0x2 }, // 7170
  { IMAGE_STORE_V4_V3_gfx90a, IMAGE_STORE, MIMGEncGfx90a, 0x4, 0x3 }, // 7171
  { IMAGE_STORE_V4_V4_gfx90a, IMAGE_STORE, MIMGEncGfx90a, 0x4, 0x4 }, // 7172
  { IMAGE_STORE_V5_V1_gfx90a, IMAGE_STORE, MIMGEncGfx90a, 0x5, 0x1 }, // 7173
  { IMAGE_STORE_V5_V2_gfx90a, IMAGE_STORE, MIMGEncGfx90a, 0x5, 0x2 }, // 7174
  { IMAGE_STORE_V5_V3_gfx90a, IMAGE_STORE, MIMGEncGfx90a, 0x5, 0x3 }, // 7175
  { IMAGE_STORE_V5_V4_gfx90a, IMAGE_STORE, MIMGEncGfx90a, 0x5, 0x4 }, // 7176
  { IMAGE_STORE_MIP_V1_V1_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10Default, 0x1, 0x1 }, // 7177
  { IMAGE_STORE_MIP_V1_V2_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10Default, 0x1, 0x2 }, // 7178
  { IMAGE_STORE_MIP_V1_V3_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10Default, 0x1, 0x3 }, // 7179
  { IMAGE_STORE_MIP_V1_V4_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10Default, 0x1, 0x4 }, // 7180
  { IMAGE_STORE_MIP_V2_V1_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10Default, 0x2, 0x1 }, // 7181
  { IMAGE_STORE_MIP_V2_V2_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10Default, 0x2, 0x2 }, // 7182
  { IMAGE_STORE_MIP_V2_V3_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10Default, 0x2, 0x3 }, // 7183
  { IMAGE_STORE_MIP_V2_V4_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10Default, 0x2, 0x4 }, // 7184
  { IMAGE_STORE_MIP_V3_V1_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10Default, 0x3, 0x1 }, // 7185
  { IMAGE_STORE_MIP_V3_V2_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10Default, 0x3, 0x2 }, // 7186
  { IMAGE_STORE_MIP_V3_V3_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10Default, 0x3, 0x3 }, // 7187
  { IMAGE_STORE_MIP_V3_V4_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10Default, 0x3, 0x4 }, // 7188
  { IMAGE_STORE_MIP_V4_V1_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10Default, 0x4, 0x1 }, // 7189
  { IMAGE_STORE_MIP_V4_V2_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10Default, 0x4, 0x2 }, // 7190
  { IMAGE_STORE_MIP_V4_V3_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10Default, 0x4, 0x3 }, // 7191
  { IMAGE_STORE_MIP_V4_V4_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10Default, 0x4, 0x4 }, // 7192
  { IMAGE_STORE_MIP_V5_V1_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10Default, 0x5, 0x1 }, // 7193
  { IMAGE_STORE_MIP_V5_V2_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10Default, 0x5, 0x2 }, // 7194
  { IMAGE_STORE_MIP_V5_V3_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10Default, 0x5, 0x3 }, // 7195
  { IMAGE_STORE_MIP_V5_V4_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10Default, 0x5, 0x4 }, // 7196
  { IMAGE_STORE_MIP_V1_V2_nsa_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10NSA, 0x1, 0x2 }, // 7197
  { IMAGE_STORE_MIP_V1_V3_nsa_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10NSA, 0x1, 0x3 }, // 7198
  { IMAGE_STORE_MIP_V1_V4_nsa_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10NSA, 0x1, 0x4 }, // 7199
  { IMAGE_STORE_MIP_V2_V2_nsa_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10NSA, 0x2, 0x2 }, // 7200
  { IMAGE_STORE_MIP_V2_V3_nsa_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10NSA, 0x2, 0x3 }, // 7201
  { IMAGE_STORE_MIP_V2_V4_nsa_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10NSA, 0x2, 0x4 }, // 7202
  { IMAGE_STORE_MIP_V3_V2_nsa_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10NSA, 0x3, 0x2 }, // 7203
  { IMAGE_STORE_MIP_V3_V3_nsa_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10NSA, 0x3, 0x3 }, // 7204
  { IMAGE_STORE_MIP_V3_V4_nsa_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10NSA, 0x3, 0x4 }, // 7205
  { IMAGE_STORE_MIP_V4_V2_nsa_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10NSA, 0x4, 0x2 }, // 7206
  { IMAGE_STORE_MIP_V4_V3_nsa_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10NSA, 0x4, 0x3 }, // 7207
  { IMAGE_STORE_MIP_V4_V4_nsa_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10NSA, 0x4, 0x4 }, // 7208
  { IMAGE_STORE_MIP_V5_V2_nsa_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10NSA, 0x5, 0x2 }, // 7209
  { IMAGE_STORE_MIP_V5_V3_nsa_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10NSA, 0x5, 0x3 }, // 7210
  { IMAGE_STORE_MIP_V5_V4_nsa_gfx10, IMAGE_STORE_MIP, MIMGEncGfx10NSA, 0x5, 0x4 }, // 7211
  { IMAGE_STORE_MIP_V1_V1, IMAGE_STORE_MIP, MIMGEncGfx6, 0x1, 0x1 }, // 7212
  { IMAGE_STORE_MIP_V1_V2, IMAGE_STORE_MIP, MIMGEncGfx6, 0x1, 0x2 }, // 7213
  { IMAGE_STORE_MIP_V1_V3, IMAGE_STORE_MIP, MIMGEncGfx6, 0x1, 0x3 }, // 7214
  { IMAGE_STORE_MIP_V1_V4, IMAGE_STORE_MIP, MIMGEncGfx6, 0x1, 0x4 }, // 7215
  { IMAGE_STORE_MIP_V2_V1, IMAGE_STORE_MIP, MIMGEncGfx6, 0x2, 0x1 }, // 7216
  { IMAGE_STORE_MIP_V2_V2, IMAGE_STORE_MIP, MIMGEncGfx6, 0x2, 0x2 }, // 7217
  { IMAGE_STORE_MIP_V2_V3, IMAGE_STORE_MIP, MIMGEncGfx6, 0x2, 0x3 }, // 7218
  { IMAGE_STORE_MIP_V2_V4, IMAGE_STORE_MIP, MIMGEncGfx6, 0x2, 0x4 }, // 7219
  { IMAGE_STORE_MIP_V3_V1, IMAGE_STORE_MIP, MIMGEncGfx6, 0x3, 0x1 }, // 7220
  { IMAGE_STORE_MIP_V3_V2, IMAGE_STORE_MIP, MIMGEncGfx6, 0x3, 0x2 }, // 7221
  { IMAGE_STORE_MIP_V3_V3, IMAGE_STORE_MIP, MIMGEncGfx6, 0x3, 0x3 }, // 7222
  { IMAGE_STORE_MIP_V3_V4, IMAGE_STORE_MIP, MIMGEncGfx6, 0x3, 0x4 }, // 7223
  { IMAGE_STORE_MIP_V4_V1, IMAGE_STORE_MIP, MIMGEncGfx6, 0x4, 0x1 }, // 7224
  { IMAGE_STORE_MIP_V4_V2, IMAGE_STORE_MIP, MIMGEncGfx6, 0x4, 0x2 }, // 7225
  { IMAGE_STORE_MIP_V4_V3, IMAGE_STORE_MIP, MIMGEncGfx6, 0x4, 0x3 }, // 7226
  { IMAGE_STORE_MIP_V4_V4, IMAGE_STORE_MIP, MIMGEncGfx6, 0x4, 0x4 }, // 7227
  { IMAGE_STORE_MIP_V5_V1, IMAGE_STORE_MIP, MIMGEncGfx6, 0x5, 0x1 }, // 7228
  { IMAGE_STORE_MIP_V5_V2, IMAGE_STORE_MIP, MIMGEncGfx6, 0x5, 0x2 }, // 7229
  { IMAGE_STORE_MIP_V5_V3, IMAGE_STORE_MIP, MIMGEncGfx6, 0x5, 0x3 }, // 7230
  { IMAGE_STORE_MIP_V5_V4, IMAGE_STORE_MIP, MIMGEncGfx6, 0x5, 0x4 }, // 7231
  { IMAGE_STORE_MIP_V1_V1_gfx90a, IMAGE_STORE_MIP, MIMGEncGfx90a, 0x1, 0x1 }, // 7232
  { IMAGE_STORE_MIP_V1_V2_gfx90a, IMAGE_STORE_MIP, MIMGEncGfx90a, 0x1, 0x2 }, // 7233
  { IMAGE_STORE_MIP_V1_V3_gfx90a, IMAGE_STORE_MIP, MIMGEncGfx90a, 0x1, 0x3 }, // 7234
  { IMAGE_STORE_MIP_V1_V4_gfx90a, IMAGE_STORE_MIP, MIMGEncGfx90a, 0x1, 0x4 }, // 7235
  { IMAGE_STORE_MIP_V2_V1_gfx90a, IMAGE_STORE_MIP, MIMGEncGfx90a, 0x2, 0x1 }, // 7236
  { IMAGE_STORE_MIP_V2_V2_gfx90a, IMAGE_STORE_MIP, MIMGEncGfx90a, 0x2, 0x2 }, // 7237
  { IMAGE_STORE_MIP_V2_V3_gfx90a, IMAGE_STORE_MIP, MIMGEncGfx90a, 0x2, 0x3 }, // 7238
  { IMAGE_STORE_MIP_V2_V4_gfx90a, IMAGE_STORE_MIP, MIMGEncGfx90a, 0x2, 0x4 }, // 7239
  { IMAGE_STORE_MIP_V3_V1_gfx90a, IMAGE_STORE_MIP, MIMGEncGfx90a, 0x3, 0x1 }, // 7240
  { IMAGE_STORE_MIP_V3_V2_gfx90a, IMAGE_STORE_MIP, MIMGEncGfx90a, 0x3, 0x2 }, // 7241
  { IMAGE_STORE_MIP_V3_V3_gfx90a, IMAGE_STORE_MIP, MIMGEncGfx90a, 0x3, 0x3 }, // 7242
  { IMAGE_STORE_MIP_V3_V4_gfx90a, IMAGE_STORE_MIP, MIMGEncGfx90a, 0x3, 0x4 }, // 7243
  { IMAGE_STORE_MIP_V4_V1_gfx90a, IMAGE_STORE_MIP, MIMGEncGfx90a, 0x4, 0x1 }, // 7244
  { IMAGE_STORE_MIP_V4_V2_gfx90a, IMAGE_STORE_MIP, MIMGEncGfx90a, 0x4, 0x2 }, // 7245
  { IMAGE_STORE_MIP_V4_V3_gfx90a, IMAGE_STORE_MIP, MIMGEncGfx90a, 0x4, 0x3 }, // 7246
  { IMAGE_STORE_MIP_V4_V4_gfx90a, IMAGE_STORE_MIP, MIMGEncGfx90a, 0x4, 0x4 }, // 7247
  { IMAGE_STORE_MIP_V5_V1_gfx90a, IMAGE_STORE_MIP, MIMGEncGfx90a, 0x5, 0x1 }, // 7248
  { IMAGE_STORE_MIP_V5_V2_gfx90a, IMAGE_STORE_MIP, MIMGEncGfx90a, 0x5, 0x2 }, // 7249
  { IMAGE_STORE_MIP_V5_V3_gfx90a, IMAGE_STORE_MIP, MIMGEncGfx90a, 0x5, 0x3 }, // 7250
  { IMAGE_STORE_MIP_V5_V4_gfx90a, IMAGE_STORE_MIP, MIMGEncGfx90a, 0x5, 0x4 }, // 7251
  { IMAGE_STORE_MIP_PCK_V1_V1_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x1 }, // 7252
  { IMAGE_STORE_MIP_PCK_V1_V2_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x2 }, // 7253
  { IMAGE_STORE_MIP_PCK_V1_V3_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x3 }, // 7254
  { IMAGE_STORE_MIP_PCK_V1_V4_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x4 }, // 7255
  { IMAGE_STORE_MIP_PCK_V2_V1_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x1 }, // 7256
  { IMAGE_STORE_MIP_PCK_V2_V2_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x2 }, // 7257
  { IMAGE_STORE_MIP_PCK_V2_V3_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x3 }, // 7258
  { IMAGE_STORE_MIP_PCK_V2_V4_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x4 }, // 7259
  { IMAGE_STORE_MIP_PCK_V3_V1_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x1 }, // 7260
  { IMAGE_STORE_MIP_PCK_V3_V2_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x2 }, // 7261
  { IMAGE_STORE_MIP_PCK_V3_V3_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x3 }, // 7262
  { IMAGE_STORE_MIP_PCK_V3_V4_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x4 }, // 7263
  { IMAGE_STORE_MIP_PCK_V4_V1_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x1 }, // 7264
  { IMAGE_STORE_MIP_PCK_V4_V2_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x2 }, // 7265
  { IMAGE_STORE_MIP_PCK_V4_V3_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x3 }, // 7266
  { IMAGE_STORE_MIP_PCK_V4_V4_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x4 }, // 7267
  { IMAGE_STORE_MIP_PCK_V5_V1_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x1 }, // 7268
  { IMAGE_STORE_MIP_PCK_V5_V2_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x2 }, // 7269
  { IMAGE_STORE_MIP_PCK_V5_V3_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x3 }, // 7270
  { IMAGE_STORE_MIP_PCK_V5_V4_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x4 }, // 7271
  { IMAGE_STORE_MIP_PCK_V1_V2_nsa_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10NSA, 0x1, 0x2 }, // 7272
  { IMAGE_STORE_MIP_PCK_V1_V3_nsa_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10NSA, 0x1, 0x3 }, // 7273
  { IMAGE_STORE_MIP_PCK_V1_V4_nsa_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10NSA, 0x1, 0x4 }, // 7274
  { IMAGE_STORE_MIP_PCK_V2_V2_nsa_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10NSA, 0x2, 0x2 }, // 7275
  { IMAGE_STORE_MIP_PCK_V2_V3_nsa_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10NSA, 0x2, 0x3 }, // 7276
  { IMAGE_STORE_MIP_PCK_V2_V4_nsa_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10NSA, 0x2, 0x4 }, // 7277
  { IMAGE_STORE_MIP_PCK_V3_V2_nsa_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10NSA, 0x3, 0x2 }, // 7278
  { IMAGE_STORE_MIP_PCK_V3_V3_nsa_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10NSA, 0x3, 0x3 }, // 7279
  { IMAGE_STORE_MIP_PCK_V3_V4_nsa_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10NSA, 0x3, 0x4 }, // 7280
  { IMAGE_STORE_MIP_PCK_V4_V2_nsa_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10NSA, 0x4, 0x2 }, // 7281
  { IMAGE_STORE_MIP_PCK_V4_V3_nsa_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10NSA, 0x4, 0x3 }, // 7282
  { IMAGE_STORE_MIP_PCK_V4_V4_nsa_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10NSA, 0x4, 0x4 }, // 7283
  { IMAGE_STORE_MIP_PCK_V5_V2_nsa_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10NSA, 0x5, 0x2 }, // 7284
  { IMAGE_STORE_MIP_PCK_V5_V3_nsa_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10NSA, 0x5, 0x3 }, // 7285
  { IMAGE_STORE_MIP_PCK_V5_V4_nsa_gfx10, IMAGE_STORE_MIP_PCK, MIMGEncGfx10NSA, 0x5, 0x4 }, // 7286
  { IMAGE_STORE_MIP_PCK_V1_V1, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x1, 0x1 }, // 7287
  { IMAGE_STORE_MIP_PCK_V1_V2, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x1, 0x2 }, // 7288
  { IMAGE_STORE_MIP_PCK_V1_V3, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x1, 0x3 }, // 7289
  { IMAGE_STORE_MIP_PCK_V1_V4, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x1, 0x4 }, // 7290
  { IMAGE_STORE_MIP_PCK_V2_V1, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x2, 0x1 }, // 7291
  { IMAGE_STORE_MIP_PCK_V2_V2, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x2, 0x2 }, // 7292
  { IMAGE_STORE_MIP_PCK_V2_V3, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x2, 0x3 }, // 7293
  { IMAGE_STORE_MIP_PCK_V2_V4, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x2, 0x4 }, // 7294
  { IMAGE_STORE_MIP_PCK_V3_V1, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x3, 0x1 }, // 7295
  { IMAGE_STORE_MIP_PCK_V3_V2, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x3, 0x2 }, // 7296
  { IMAGE_STORE_MIP_PCK_V3_V3, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x3, 0x3 }, // 7297
  { IMAGE_STORE_MIP_PCK_V3_V4, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x3, 0x4 }, // 7298
  { IMAGE_STORE_MIP_PCK_V4_V1, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x4, 0x1 }, // 7299
  { IMAGE_STORE_MIP_PCK_V4_V2, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x4, 0x2 }, // 7300
  { IMAGE_STORE_MIP_PCK_V4_V3, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x4, 0x3 }, // 7301
  { IMAGE_STORE_MIP_PCK_V4_V4, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x4, 0x4 }, // 7302
  { IMAGE_STORE_MIP_PCK_V5_V1, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x5, 0x1 }, // 7303
  { IMAGE_STORE_MIP_PCK_V5_V2, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x5, 0x2 }, // 7304
  { IMAGE_STORE_MIP_PCK_V5_V3, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x5, 0x3 }, // 7305
  { IMAGE_STORE_MIP_PCK_V5_V4, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x5, 0x4 }, // 7306
  { IMAGE_STORE_MIP_PCK_V1_V1_gfx90a, IMAGE_STORE_MIP_PCK, MIMGEncGfx90a, 0x1, 0x1 }, // 7307
  { IMAGE_STORE_MIP_PCK_V1_V2_gfx90a, IMAGE_STORE_MIP_PCK, MIMGEncGfx90a, 0x1, 0x2 }, // 7308
  { IMAGE_STORE_MIP_PCK_V1_V3_gfx90a, IMAGE_STORE_MIP_PCK, MIMGEncGfx90a, 0x1, 0x3 }, // 7309
  { IMAGE_STORE_MIP_PCK_V1_V4_gfx90a, IMAGE_STORE_MIP_PCK, MIMGEncGfx90a, 0x1, 0x4 }, // 7310
  { IMAGE_STORE_MIP_PCK_V2_V1_gfx90a, IMAGE_STORE_MIP_PCK, MIMGEncGfx90a, 0x2, 0x1 }, // 7311
  { IMAGE_STORE_MIP_PCK_V2_V2_gfx90a, IMAGE_STORE_MIP_PCK, MIMGEncGfx90a, 0x2, 0x2 }, // 7312
  { IMAGE_STORE_MIP_PCK_V2_V3_gfx90a, IMAGE_STORE_MIP_PCK, MIMGEncGfx90a, 0x2, 0x3 }, // 7313
  { IMAGE_STORE_MIP_PCK_V2_V4_gfx90a, IMAGE_STORE_MIP_PCK, MIMGEncGfx90a, 0x2, 0x4 }, // 7314
  { IMAGE_STORE_MIP_PCK_V3_V1_gfx90a, IMAGE_STORE_MIP_PCK, MIMGEncGfx90a, 0x3, 0x1 }, // 7315
  { IMAGE_STORE_MIP_PCK_V3_V2_gfx90a, IMAGE_STORE_MIP_PCK, MIMGEncGfx90a, 0x3, 0x2 }, // 7316
  { IMAGE_STORE_MIP_PCK_V3_V3_gfx90a, IMAGE_STORE_MIP_PCK, MIMGEncGfx90a, 0x3, 0x3 }, // 7317
  { IMAGE_STORE_MIP_PCK_V3_V4_gfx90a, IMAGE_STORE_MIP_PCK, MIMGEncGfx90a, 0x3, 0x4 }, // 7318
  { IMAGE_STORE_MIP_PCK_V4_V1_gfx90a, IMAGE_STORE_MIP_PCK, MIMGEncGfx90a, 0x4, 0x1 }, // 7319
  { IMAGE_STORE_MIP_PCK_V4_V2_gfx90a, IMAGE_STORE_MIP_PCK, MIMGEncGfx90a, 0x4, 0x2 }, // 7320
  { IMAGE_STORE_MIP_PCK_V4_V3_gfx90a, IMAGE_STORE_MIP_PCK, MIMGEncGfx90a, 0x4, 0x3 }, // 7321
  { IMAGE_STORE_MIP_PCK_V4_V4_gfx90a, IMAGE_STORE_MIP_PCK, MIMGEncGfx90a, 0x4, 0x4 }, // 7322
  { IMAGE_STORE_MIP_PCK_V5_V1_gfx90a, IMAGE_STORE_MIP_PCK, MIMGEncGfx90a, 0x5, 0x1 }, // 7323
  { IMAGE_STORE_MIP_PCK_V5_V2_gfx90a, IMAGE_STORE_MIP_PCK, MIMGEncGfx90a, 0x5, 0x2 }, // 7324
  { IMAGE_STORE_MIP_PCK_V5_V3_gfx90a, IMAGE_STORE_MIP_PCK, MIMGEncGfx90a, 0x5, 0x3 }, // 7325
  { IMAGE_STORE_MIP_PCK_V5_V4_gfx90a, IMAGE_STORE_MIP_PCK, MIMGEncGfx90a, 0x5, 0x4 }, // 7326
  { IMAGE_STORE_PCK_V1_V1_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10Default, 0x1, 0x1 }, // 7327
  { IMAGE_STORE_PCK_V1_V2_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10Default, 0x1, 0x2 }, // 7328
  { IMAGE_STORE_PCK_V1_V3_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10Default, 0x1, 0x3 }, // 7329
  { IMAGE_STORE_PCK_V1_V4_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10Default, 0x1, 0x4 }, // 7330
  { IMAGE_STORE_PCK_V2_V1_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10Default, 0x2, 0x1 }, // 7331
  { IMAGE_STORE_PCK_V2_V2_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10Default, 0x2, 0x2 }, // 7332
  { IMAGE_STORE_PCK_V2_V3_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10Default, 0x2, 0x3 }, // 7333
  { IMAGE_STORE_PCK_V2_V4_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10Default, 0x2, 0x4 }, // 7334
  { IMAGE_STORE_PCK_V3_V1_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10Default, 0x3, 0x1 }, // 7335
  { IMAGE_STORE_PCK_V3_V2_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10Default, 0x3, 0x2 }, // 7336
  { IMAGE_STORE_PCK_V3_V3_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10Default, 0x3, 0x3 }, // 7337
  { IMAGE_STORE_PCK_V3_V4_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10Default, 0x3, 0x4 }, // 7338
  { IMAGE_STORE_PCK_V4_V1_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10Default, 0x4, 0x1 }, // 7339
  { IMAGE_STORE_PCK_V4_V2_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10Default, 0x4, 0x2 }, // 7340
  { IMAGE_STORE_PCK_V4_V3_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10Default, 0x4, 0x3 }, // 7341
  { IMAGE_STORE_PCK_V4_V4_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10Default, 0x4, 0x4 }, // 7342
  { IMAGE_STORE_PCK_V5_V1_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10Default, 0x5, 0x1 }, // 7343
  { IMAGE_STORE_PCK_V5_V2_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10Default, 0x5, 0x2 }, // 7344
  { IMAGE_STORE_PCK_V5_V3_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10Default, 0x5, 0x3 }, // 7345
  { IMAGE_STORE_PCK_V5_V4_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10Default, 0x5, 0x4 }, // 7346
  { IMAGE_STORE_PCK_V1_V2_nsa_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10NSA, 0x1, 0x2 }, // 7347
  { IMAGE_STORE_PCK_V1_V3_nsa_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10NSA, 0x1, 0x3 }, // 7348
  { IMAGE_STORE_PCK_V1_V4_nsa_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10NSA, 0x1, 0x4 }, // 7349
  { IMAGE_STORE_PCK_V2_V2_nsa_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10NSA, 0x2, 0x2 }, // 7350
  { IMAGE_STORE_PCK_V2_V3_nsa_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10NSA, 0x2, 0x3 }, // 7351
  { IMAGE_STORE_PCK_V2_V4_nsa_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10NSA, 0x2, 0x4 }, // 7352
  { IMAGE_STORE_PCK_V3_V2_nsa_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10NSA, 0x3, 0x2 }, // 7353
  { IMAGE_STORE_PCK_V3_V3_nsa_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10NSA, 0x3, 0x3 }, // 7354
  { IMAGE_STORE_PCK_V3_V4_nsa_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10NSA, 0x3, 0x4 }, // 7355
  { IMAGE_STORE_PCK_V4_V2_nsa_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10NSA, 0x4, 0x2 }, // 7356
  { IMAGE_STORE_PCK_V4_V3_nsa_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10NSA, 0x4, 0x3 }, // 7357
  { IMAGE_STORE_PCK_V4_V4_nsa_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10NSA, 0x4, 0x4 }, // 7358
  { IMAGE_STORE_PCK_V5_V2_nsa_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10NSA, 0x5, 0x2 }, // 7359
  { IMAGE_STORE_PCK_V5_V3_nsa_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10NSA, 0x5, 0x3 }, // 7360
  { IMAGE_STORE_PCK_V5_V4_nsa_gfx10, IMAGE_STORE_PCK, MIMGEncGfx10NSA, 0x5, 0x4 }, // 7361
  { IMAGE_STORE_PCK_V1_V1, IMAGE_STORE_PCK, MIMGEncGfx6, 0x1, 0x1 }, // 7362
  { IMAGE_STORE_PCK_V1_V2, IMAGE_STORE_PCK, MIMGEncGfx6, 0x1, 0x2 }, // 7363
  { IMAGE_STORE_PCK_V1_V3, IMAGE_STORE_PCK, MIMGEncGfx6, 0x1, 0x3 }, // 7364
  { IMAGE_STORE_PCK_V1_V4, IMAGE_STORE_PCK, MIMGEncGfx6, 0x1, 0x4 }, // 7365
  { IMAGE_STORE_PCK_V2_V1, IMAGE_STORE_PCK, MIMGEncGfx6, 0x2, 0x1 }, // 7366
  { IMAGE_STORE_PCK_V2_V2, IMAGE_STORE_PCK, MIMGEncGfx6, 0x2, 0x2 }, // 7367
  { IMAGE_STORE_PCK_V2_V3, IMAGE_STORE_PCK, MIMGEncGfx6, 0x2, 0x3 }, // 7368
  { IMAGE_STORE_PCK_V2_V4, IMAGE_STORE_PCK, MIMGEncGfx6, 0x2, 0x4 }, // 7369
  { IMAGE_STORE_PCK_V3_V1, IMAGE_STORE_PCK, MIMGEncGfx6, 0x3, 0x1 }, // 7370
  { IMAGE_STORE_PCK_V3_V2, IMAGE_STORE_PCK, MIMGEncGfx6, 0x3, 0x2 }, // 7371
  { IMAGE_STORE_PCK_V3_V3, IMAGE_STORE_PCK, MIMGEncGfx6, 0x3, 0x3 }, // 7372
  { IMAGE_STORE_PCK_V3_V4, IMAGE_STORE_PCK, MIMGEncGfx6, 0x3, 0x4 }, // 7373
  { IMAGE_STORE_PCK_V4_V1, IMAGE_STORE_PCK, MIMGEncGfx6, 0x4, 0x1 }, // 7374
  { IMAGE_STORE_PCK_V4_V2, IMAGE_STORE_PCK, MIMGEncGfx6, 0x4, 0x2 }, // 7375
  { IMAGE_STORE_PCK_V4_V3, IMAGE_STORE_PCK, MIMGEncGfx6, 0x4, 0x3 }, // 7376
  { IMAGE_STORE_PCK_V4_V4, IMAGE_STORE_PCK, MIMGEncGfx6, 0x4, 0x4 }, // 7377
  { IMAGE_STORE_PCK_V5_V1, IMAGE_STORE_PCK, MIMGEncGfx6, 0x5, 0x1 }, // 7378
  { IMAGE_STORE_PCK_V5_V2, IMAGE_STORE_PCK, MIMGEncGfx6, 0x5, 0x2 }, // 7379
  { IMAGE_STORE_PCK_V5_V3, IMAGE_STORE_PCK, MIMGEncGfx6, 0x5, 0x3 }, // 7380
  { IMAGE_STORE_PCK_V5_V4, IMAGE_STORE_PCK, MIMGEncGfx6, 0x5, 0x4 }, // 7381
  { IMAGE_STORE_PCK_V1_V1_gfx90a, IMAGE_STORE_PCK, MIMGEncGfx90a, 0x1, 0x1 }, // 7382
  { IMAGE_STORE_PCK_V1_V2_gfx90a, IMAGE_STORE_PCK, MIMGEncGfx90a, 0x1, 0x2 }, // 7383
  { IMAGE_STORE_PCK_V1_V3_gfx90a, IMAGE_STORE_PCK, MIMGEncGfx90a, 0x1, 0x3 }, // 7384
  { IMAGE_STORE_PCK_V1_V4_gfx90a, IMAGE_STORE_PCK, MIMGEncGfx90a, 0x1, 0x4 }, // 7385
  { IMAGE_STORE_PCK_V2_V1_gfx90a, IMAGE_STORE_PCK, MIMGEncGfx90a, 0x2, 0x1 }, // 7386
  { IMAGE_STORE_PCK_V2_V2_gfx90a, IMAGE_STORE_PCK, MIMGEncGfx90a, 0x2, 0x2 }, // 7387
  { IMAGE_STORE_PCK_V2_V3_gfx90a, IMAGE_STORE_PCK, MIMGEncGfx90a, 0x2, 0x3 }, // 7388
  { IMAGE_STORE_PCK_V2_V4_gfx90a, IMAGE_STORE_PCK, MIMGEncGfx90a, 0x2, 0x4 }, // 7389
  { IMAGE_STORE_PCK_V3_V1_gfx90a, IMAGE_STORE_PCK, MIMGEncGfx90a, 0x3, 0x1 }, // 7390
  { IMAGE_STORE_PCK_V3_V2_gfx90a, IMAGE_STORE_PCK, MIMGEncGfx90a, 0x3, 0x2 }, // 7391
  { IMAGE_STORE_PCK_V3_V3_gfx90a, IMAGE_STORE_PCK, MIMGEncGfx90a, 0x3, 0x3 }, // 7392
  { IMAGE_STORE_PCK_V3_V4_gfx90a, IMAGE_STORE_PCK, MIMGEncGfx90a, 0x3, 0x4 }, // 7393
  { IMAGE_STORE_PCK_V4_V1_gfx90a, IMAGE_STORE_PCK, MIMGEncGfx90a, 0x4, 0x1 }, // 7394
  { IMAGE_STORE_PCK_V4_V2_gfx90a, IMAGE_STORE_PCK, MIMGEncGfx90a, 0x4, 0x2 }, // 7395
  { IMAGE_STORE_PCK_V4_V3_gfx90a, IMAGE_STORE_PCK, MIMGEncGfx90a, 0x4, 0x3 }, // 7396
  { IMAGE_STORE_PCK_V4_V4_gfx90a, IMAGE_STORE_PCK, MIMGEncGfx90a, 0x4, 0x4 }, // 7397
  { IMAGE_STORE_PCK_V5_V1_gfx90a, IMAGE_STORE_PCK, MIMGEncGfx90a, 0x5, 0x1 }, // 7398
  { IMAGE_STORE_PCK_V5_V2_gfx90a, IMAGE_STORE_PCK, MIMGEncGfx90a, 0x5, 0x2 }, // 7399
  { IMAGE_STORE_PCK_V5_V3_gfx90a, IMAGE_STORE_PCK, MIMGEncGfx90a, 0x5, 0x3 }, // 7400
  { IMAGE_STORE_PCK_V5_V4_gfx90a, IMAGE_STORE_PCK, MIMGEncGfx90a, 0x5, 0x4 }, // 7401
 };

const MIMGInfo *getMIMGOpcodeHelper(unsigned BaseOpcode, unsigned MIMGEncoding, uint8_t VDataDwords, uint8_t VAddrDwords) {
  struct KeyType {
    unsigned BaseOpcode;
    unsigned MIMGEncoding;
    uint8_t VDataDwords;
    uint8_t VAddrDwords;
  };
  KeyType Key = {BaseOpcode, MIMGEncoding, VDataDwords, VAddrDwords};
  auto Table = makeArrayRef(MIMGInfoTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const MIMGInfo &LHS, const KeyType &RHS) {
      if ((unsigned)LHS.BaseOpcode < (unsigned)RHS.BaseOpcode)
        return true;
      if ((unsigned)LHS.BaseOpcode > (unsigned)RHS.BaseOpcode)
        return false;
      if ((unsigned)LHS.MIMGEncoding < (unsigned)RHS.MIMGEncoding)
        return true;
      if ((unsigned)LHS.MIMGEncoding > (unsigned)RHS.MIMGEncoding)
        return false;
      if (LHS.VDataDwords < RHS.VDataDwords)
        return true;
      if (LHS.VDataDwords > RHS.VDataDwords)
        return false;
      if (LHS.VAddrDwords < RHS.VAddrDwords)
        return true;
      if (LHS.VAddrDwords > RHS.VAddrDwords)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.BaseOpcode != Idx->BaseOpcode ||
      Key.MIMGEncoding != Idx->MIMGEncoding ||
      Key.VDataDwords != Idx->VDataDwords ||
      Key.VAddrDwords != Idx->VAddrDwords)
    return nullptr;
  return &*Idx;
}

const MIMGInfo *getMIMGInfo(unsigned Opcode) {
  struct IndexType {
    unsigned Opcode;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { IMAGE_ATOMIC_ADD_V1_V1_gfx10, 0 },
    { IMAGE_ATOMIC_ADD_V1_V1_gfx90a, 30 },
    { IMAGE_ATOMIC_ADD_V1_V1_si, 14 },
    { IMAGE_ATOMIC_ADD_V1_V1_vi, 22 },
    { IMAGE_ATOMIC_ADD_V1_V2_gfx10, 1 },
    { IMAGE_ATOMIC_ADD_V1_V2_gfx90a, 31 },
    { IMAGE_ATOMIC_ADD_V1_V2_nsa_gfx10, 8 },
    { IMAGE_ATOMIC_ADD_V1_V2_si, 15 },
    { IMAGE_ATOMIC_ADD_V1_V2_vi, 23 },
    { IMAGE_ATOMIC_ADD_V1_V3_gfx10, 2 },
    { IMAGE_ATOMIC_ADD_V1_V3_gfx90a, 32 },
    { IMAGE_ATOMIC_ADD_V1_V3_nsa_gfx10, 9 },
    { IMAGE_ATOMIC_ADD_V1_V3_si, 16 },
    { IMAGE_ATOMIC_ADD_V1_V3_vi, 24 },
    { IMAGE_ATOMIC_ADD_V1_V4_gfx10, 3 },
    { IMAGE_ATOMIC_ADD_V1_V4_gfx90a, 33 },
    { IMAGE_ATOMIC_ADD_V1_V4_nsa_gfx10, 10 },
    { IMAGE_ATOMIC_ADD_V1_V4_si, 17 },
    { IMAGE_ATOMIC_ADD_V1_V4_vi, 25 },
    { IMAGE_ATOMIC_ADD_V2_V1_gfx10, 4 },
    { IMAGE_ATOMIC_ADD_V2_V1_gfx90a, 34 },
    { IMAGE_ATOMIC_ADD_V2_V1_si, 18 },
    { IMAGE_ATOMIC_ADD_V2_V1_vi, 26 },
    { IMAGE_ATOMIC_ADD_V2_V2_gfx10, 5 },
    { IMAGE_ATOMIC_ADD_V2_V2_gfx90a, 35 },
    { IMAGE_ATOMIC_ADD_V2_V2_nsa_gfx10, 11 },
    { IMAGE_ATOMIC_ADD_V2_V2_si, 19 },
    { IMAGE_ATOMIC_ADD_V2_V2_vi, 27 },
    { IMAGE_ATOMIC_ADD_V2_V3_gfx10, 6 },
    { IMAGE_ATOMIC_ADD_V2_V3_gfx90a, 36 },
    { IMAGE_ATOMIC_ADD_V2_V3_nsa_gfx10, 12 },
    { IMAGE_ATOMIC_ADD_V2_V3_si, 20 },
    { IMAGE_ATOMIC_ADD_V2_V3_vi, 28 },
    { IMAGE_ATOMIC_ADD_V2_V4_gfx10, 7 },
    { IMAGE_ATOMIC_ADD_V2_V4_gfx90a, 37 },
    { IMAGE_ATOMIC_ADD_V2_V4_nsa_gfx10, 13 },
    { IMAGE_ATOMIC_ADD_V2_V4_si, 21 },
    { IMAGE_ATOMIC_ADD_V2_V4_vi, 29 },
    { IMAGE_ATOMIC_AND_V1_V1_gfx10, 38 },
    { IMAGE_ATOMIC_AND_V1_V1_gfx90a, 68 },
    { IMAGE_ATOMIC_AND_V1_V1_si, 52 },
    { IMAGE_ATOMIC_AND_V1_V1_vi, 60 },
    { IMAGE_ATOMIC_AND_V1_V2_gfx10, 39 },
    { IMAGE_ATOMIC_AND_V1_V2_gfx90a, 69 },
    { IMAGE_ATOMIC_AND_V1_V2_nsa_gfx10, 46 },
    { IMAGE_ATOMIC_AND_V1_V2_si, 53 },
    { IMAGE_ATOMIC_AND_V1_V2_vi, 61 },
    { IMAGE_ATOMIC_AND_V1_V3_gfx10, 40 },
    { IMAGE_ATOMIC_AND_V1_V3_gfx90a, 70 },
    { IMAGE_ATOMIC_AND_V1_V3_nsa_gfx10, 47 },
    { IMAGE_ATOMIC_AND_V1_V3_si, 54 },
    { IMAGE_ATOMIC_AND_V1_V3_vi, 62 },
    { IMAGE_ATOMIC_AND_V1_V4_gfx10, 41 },
    { IMAGE_ATOMIC_AND_V1_V4_gfx90a, 71 },
    { IMAGE_ATOMIC_AND_V1_V4_nsa_gfx10, 48 },
    { IMAGE_ATOMIC_AND_V1_V4_si, 55 },
    { IMAGE_ATOMIC_AND_V1_V4_vi, 63 },
    { IMAGE_ATOMIC_AND_V2_V1_gfx10, 42 },
    { IMAGE_ATOMIC_AND_V2_V1_gfx90a, 72 },
    { IMAGE_ATOMIC_AND_V2_V1_si, 56 },
    { IMAGE_ATOMIC_AND_V2_V1_vi, 64 },
    { IMAGE_ATOMIC_AND_V2_V2_gfx10, 43 },
    { IMAGE_ATOMIC_AND_V2_V2_gfx90a, 73 },
    { IMAGE_ATOMIC_AND_V2_V2_nsa_gfx10, 49 },
    { IMAGE_ATOMIC_AND_V2_V2_si, 57 },
    { IMAGE_ATOMIC_AND_V2_V2_vi, 65 },
    { IMAGE_ATOMIC_AND_V2_V3_gfx10, 44 },
    { IMAGE_ATOMIC_AND_V2_V3_gfx90a, 74 },
    { IMAGE_ATOMIC_AND_V2_V3_nsa_gfx10, 50 },
    { IMAGE_ATOMIC_AND_V2_V3_si, 58 },
    { IMAGE_ATOMIC_AND_V2_V3_vi, 66 },
    { IMAGE_ATOMIC_AND_V2_V4_gfx10, 45 },
    { IMAGE_ATOMIC_AND_V2_V4_gfx90a, 75 },
    { IMAGE_ATOMIC_AND_V2_V4_nsa_gfx10, 51 },
    { IMAGE_ATOMIC_AND_V2_V4_si, 59 },
    { IMAGE_ATOMIC_AND_V2_V4_vi, 67 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V1_gfx10, 76 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V1_gfx90a, 106 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V1_si, 90 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V1_vi, 98 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V2_gfx10, 77 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V2_gfx90a, 107 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V2_nsa_gfx10, 84 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V2_si, 91 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V2_vi, 99 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V3_gfx10, 78 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V3_gfx90a, 108 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V3_nsa_gfx10, 85 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V3_si, 92 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V3_vi, 100 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V4_gfx10, 79 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V4_gfx90a, 109 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V4_nsa_gfx10, 86 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V4_si, 93 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V4_vi, 101 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V1_gfx10, 80 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V1_gfx90a, 110 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V1_si, 94 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V1_vi, 102 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V2_gfx10, 81 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V2_gfx90a, 111 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V2_nsa_gfx10, 87 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V2_si, 95 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V2_vi, 103 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V3_gfx10, 82 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V3_gfx90a, 112 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V3_nsa_gfx10, 88 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V3_si, 96 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V3_vi, 104 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V4_gfx10, 83 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V4_gfx90a, 113 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V4_nsa_gfx10, 89 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V4_si, 97 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V4_vi, 105 },
    { IMAGE_ATOMIC_DEC_V1_V1_gfx10, 114 },
    { IMAGE_ATOMIC_DEC_V1_V1_gfx90a, 144 },
    { IMAGE_ATOMIC_DEC_V1_V1_si, 128 },
    { IMAGE_ATOMIC_DEC_V1_V1_vi, 136 },
    { IMAGE_ATOMIC_DEC_V1_V2_gfx10, 115 },
    { IMAGE_ATOMIC_DEC_V1_V2_gfx90a, 145 },
    { IMAGE_ATOMIC_DEC_V1_V2_nsa_gfx10, 122 },
    { IMAGE_ATOMIC_DEC_V1_V2_si, 129 },
    { IMAGE_ATOMIC_DEC_V1_V2_vi, 137 },
    { IMAGE_ATOMIC_DEC_V1_V3_gfx10, 116 },
    { IMAGE_ATOMIC_DEC_V1_V3_gfx90a, 146 },
    { IMAGE_ATOMIC_DEC_V1_V3_nsa_gfx10, 123 },
    { IMAGE_ATOMIC_DEC_V1_V3_si, 130 },
    { IMAGE_ATOMIC_DEC_V1_V3_vi, 138 },
    { IMAGE_ATOMIC_DEC_V1_V4_gfx10, 117 },
    { IMAGE_ATOMIC_DEC_V1_V4_gfx90a, 147 },
    { IMAGE_ATOMIC_DEC_V1_V4_nsa_gfx10, 124 },
    { IMAGE_ATOMIC_DEC_V1_V4_si, 131 },
    { IMAGE_ATOMIC_DEC_V1_V4_vi, 139 },
    { IMAGE_ATOMIC_DEC_V2_V1_gfx10, 118 },
    { IMAGE_ATOMIC_DEC_V2_V1_gfx90a, 148 },
    { IMAGE_ATOMIC_DEC_V2_V1_si, 132 },
    { IMAGE_ATOMIC_DEC_V2_V1_vi, 140 },
    { IMAGE_ATOMIC_DEC_V2_V2_gfx10, 119 },
    { IMAGE_ATOMIC_DEC_V2_V2_gfx90a, 149 },
    { IMAGE_ATOMIC_DEC_V2_V2_nsa_gfx10, 125 },
    { IMAGE_ATOMIC_DEC_V2_V2_si, 133 },
    { IMAGE_ATOMIC_DEC_V2_V2_vi, 141 },
    { IMAGE_ATOMIC_DEC_V2_V3_gfx10, 120 },
    { IMAGE_ATOMIC_DEC_V2_V3_gfx90a, 150 },
    { IMAGE_ATOMIC_DEC_V2_V3_nsa_gfx10, 126 },
    { IMAGE_ATOMIC_DEC_V2_V3_si, 134 },
    { IMAGE_ATOMIC_DEC_V2_V3_vi, 142 },
    { IMAGE_ATOMIC_DEC_V2_V4_gfx10, 121 },
    { IMAGE_ATOMIC_DEC_V2_V4_gfx90a, 151 },
    { IMAGE_ATOMIC_DEC_V2_V4_nsa_gfx10, 127 },
    { IMAGE_ATOMIC_DEC_V2_V4_si, 135 },
    { IMAGE_ATOMIC_DEC_V2_V4_vi, 143 },
    { IMAGE_ATOMIC_FCMPSWAP_V1_V1_gfx10, 152 },
    { IMAGE_ATOMIC_FCMPSWAP_V1_V1_si, 166 },
    { IMAGE_ATOMIC_FCMPSWAP_V1_V2_gfx10, 153 },
    { IMAGE_ATOMIC_FCMPSWAP_V1_V2_nsa_gfx10, 160 },
    { IMAGE_ATOMIC_FCMPSWAP_V1_V2_si, 167 },
    { IMAGE_ATOMIC_FCMPSWAP_V1_V3_gfx10, 154 },
    { IMAGE_ATOMIC_FCMPSWAP_V1_V3_nsa_gfx10, 161 },
    { IMAGE_ATOMIC_FCMPSWAP_V1_V3_si, 168 },
    { IMAGE_ATOMIC_FCMPSWAP_V1_V4_gfx10, 155 },
    { IMAGE_ATOMIC_FCMPSWAP_V1_V4_nsa_gfx10, 162 },
    { IMAGE_ATOMIC_FCMPSWAP_V1_V4_si, 169 },
    { IMAGE_ATOMIC_FCMPSWAP_V2_V1_gfx10, 156 },
    { IMAGE_ATOMIC_FCMPSWAP_V2_V1_si, 170 },
    { IMAGE_ATOMIC_FCMPSWAP_V2_V2_gfx10, 157 },
    { IMAGE_ATOMIC_FCMPSWAP_V2_V2_nsa_gfx10, 163 },
    { IMAGE_ATOMIC_FCMPSWAP_V2_V2_si, 171 },
    { IMAGE_ATOMIC_FCMPSWAP_V2_V3_gfx10, 158 },
    { IMAGE_ATOMIC_FCMPSWAP_V2_V3_nsa_gfx10, 164 },
    { IMAGE_ATOMIC_FCMPSWAP_V2_V3_si, 172 },
    { IMAGE_ATOMIC_FCMPSWAP_V2_V4_gfx10, 159 },
    { IMAGE_ATOMIC_FCMPSWAP_V2_V4_nsa_gfx10, 165 },
    { IMAGE_ATOMIC_FCMPSWAP_V2_V4_si, 173 },
    { IMAGE_ATOMIC_FMAX_V1_V1_gfx10, 174 },
    { IMAGE_ATOMIC_FMAX_V1_V1_si, 188 },
    { IMAGE_ATOMIC_FMAX_V1_V2_gfx10, 175 },
    { IMAGE_ATOMIC_FMAX_V1_V2_nsa_gfx10, 182 },
    { IMAGE_ATOMIC_FMAX_V1_V2_si, 189 },
    { IMAGE_ATOMIC_FMAX_V1_V3_gfx10, 176 },
    { IMAGE_ATOMIC_FMAX_V1_V3_nsa_gfx10, 183 },
    { IMAGE_ATOMIC_FMAX_V1_V3_si, 190 },
    { IMAGE_ATOMIC_FMAX_V1_V4_gfx10, 177 },
    { IMAGE_ATOMIC_FMAX_V1_V4_nsa_gfx10, 184 },
    { IMAGE_ATOMIC_FMAX_V1_V4_si, 191 },
    { IMAGE_ATOMIC_FMAX_V2_V1_gfx10, 178 },
    { IMAGE_ATOMIC_FMAX_V2_V1_si, 192 },
    { IMAGE_ATOMIC_FMAX_V2_V2_gfx10, 179 },
    { IMAGE_ATOMIC_FMAX_V2_V2_nsa_gfx10, 185 },
    { IMAGE_ATOMIC_FMAX_V2_V2_si, 193 },
    { IMAGE_ATOMIC_FMAX_V2_V3_gfx10, 180 },
    { IMAGE_ATOMIC_FMAX_V2_V3_nsa_gfx10, 186 },
    { IMAGE_ATOMIC_FMAX_V2_V3_si, 194 },
    { IMAGE_ATOMIC_FMAX_V2_V4_gfx10, 181 },
    { IMAGE_ATOMIC_FMAX_V2_V4_nsa_gfx10, 187 },
    { IMAGE_ATOMIC_FMAX_V2_V4_si, 195 },
    { IMAGE_ATOMIC_FMIN_V1_V1_gfx10, 196 },
    { IMAGE_ATOMIC_FMIN_V1_V1_si, 210 },
    { IMAGE_ATOMIC_FMIN_V1_V2_gfx10, 197 },
    { IMAGE_ATOMIC_FMIN_V1_V2_nsa_gfx10, 204 },
    { IMAGE_ATOMIC_FMIN_V1_V2_si, 211 },
    { IMAGE_ATOMIC_FMIN_V1_V3_gfx10, 198 },
    { IMAGE_ATOMIC_FMIN_V1_V3_nsa_gfx10, 205 },
    { IMAGE_ATOMIC_FMIN_V1_V3_si, 212 },
    { IMAGE_ATOMIC_FMIN_V1_V4_gfx10, 199 },
    { IMAGE_ATOMIC_FMIN_V1_V4_nsa_gfx10, 206 },
    { IMAGE_ATOMIC_FMIN_V1_V4_si, 213 },
    { IMAGE_ATOMIC_FMIN_V2_V1_gfx10, 200 },
    { IMAGE_ATOMIC_FMIN_V2_V1_si, 214 },
    { IMAGE_ATOMIC_FMIN_V2_V2_gfx10, 201 },
    { IMAGE_ATOMIC_FMIN_V2_V2_nsa_gfx10, 207 },
    { IMAGE_ATOMIC_FMIN_V2_V2_si, 215 },
    { IMAGE_ATOMIC_FMIN_V2_V3_gfx10, 202 },
    { IMAGE_ATOMIC_FMIN_V2_V3_nsa_gfx10, 208 },
    { IMAGE_ATOMIC_FMIN_V2_V3_si, 216 },
    { IMAGE_ATOMIC_FMIN_V2_V4_gfx10, 203 },
    { IMAGE_ATOMIC_FMIN_V2_V4_nsa_gfx10, 209 },
    { IMAGE_ATOMIC_FMIN_V2_V4_si, 217 },
    { IMAGE_ATOMIC_INC_V1_V1_gfx10, 218 },
    { IMAGE_ATOMIC_INC_V1_V1_gfx90a, 248 },
    { IMAGE_ATOMIC_INC_V1_V1_si, 232 },
    { IMAGE_ATOMIC_INC_V1_V1_vi, 240 },
    { IMAGE_ATOMIC_INC_V1_V2_gfx10, 219 },
    { IMAGE_ATOMIC_INC_V1_V2_gfx90a, 249 },
    { IMAGE_ATOMIC_INC_V1_V2_nsa_gfx10, 226 },
    { IMAGE_ATOMIC_INC_V1_V2_si, 233 },
    { IMAGE_ATOMIC_INC_V1_V2_vi, 241 },
    { IMAGE_ATOMIC_INC_V1_V3_gfx10, 220 },
    { IMAGE_ATOMIC_INC_V1_V3_gfx90a, 250 },
    { IMAGE_ATOMIC_INC_V1_V3_nsa_gfx10, 227 },
    { IMAGE_ATOMIC_INC_V1_V3_si, 234 },
    { IMAGE_ATOMIC_INC_V1_V3_vi, 242 },
    { IMAGE_ATOMIC_INC_V1_V4_gfx10, 221 },
    { IMAGE_ATOMIC_INC_V1_V4_gfx90a, 251 },
    { IMAGE_ATOMIC_INC_V1_V4_nsa_gfx10, 228 },
    { IMAGE_ATOMIC_INC_V1_V4_si, 235 },
    { IMAGE_ATOMIC_INC_V1_V4_vi, 243 },
    { IMAGE_ATOMIC_INC_V2_V1_gfx10, 222 },
    { IMAGE_ATOMIC_INC_V2_V1_gfx90a, 252 },
    { IMAGE_ATOMIC_INC_V2_V1_si, 236 },
    { IMAGE_ATOMIC_INC_V2_V1_vi, 244 },
    { IMAGE_ATOMIC_INC_V2_V2_gfx10, 223 },
    { IMAGE_ATOMIC_INC_V2_V2_gfx90a, 253 },
    { IMAGE_ATOMIC_INC_V2_V2_nsa_gfx10, 229 },
    { IMAGE_ATOMIC_INC_V2_V2_si, 237 },
    { IMAGE_ATOMIC_INC_V2_V2_vi, 245 },
    { IMAGE_ATOMIC_INC_V2_V3_gfx10, 224 },
    { IMAGE_ATOMIC_INC_V2_V3_gfx90a, 254 },
    { IMAGE_ATOMIC_INC_V2_V3_nsa_gfx10, 230 },
    { IMAGE_ATOMIC_INC_V2_V3_si, 238 },
    { IMAGE_ATOMIC_INC_V2_V3_vi, 246 },
    { IMAGE_ATOMIC_INC_V2_V4_gfx10, 225 },
    { IMAGE_ATOMIC_INC_V2_V4_gfx90a, 255 },
    { IMAGE_ATOMIC_INC_V2_V4_nsa_gfx10, 231 },
    { IMAGE_ATOMIC_INC_V2_V4_si, 239 },
    { IMAGE_ATOMIC_INC_V2_V4_vi, 247 },
    { IMAGE_ATOMIC_OR_V1_V1_gfx10, 256 },
    { IMAGE_ATOMIC_OR_V1_V1_gfx90a, 286 },
    { IMAGE_ATOMIC_OR_V1_V1_si, 270 },
    { IMAGE_ATOMIC_OR_V1_V1_vi, 278 },
    { IMAGE_ATOMIC_OR_V1_V2_gfx10, 257 },
    { IMAGE_ATOMIC_OR_V1_V2_gfx90a, 287 },
    { IMAGE_ATOMIC_OR_V1_V2_nsa_gfx10, 264 },
    { IMAGE_ATOMIC_OR_V1_V2_si, 271 },
    { IMAGE_ATOMIC_OR_V1_V2_vi, 279 },
    { IMAGE_ATOMIC_OR_V1_V3_gfx10, 258 },
    { IMAGE_ATOMIC_OR_V1_V3_gfx90a, 288 },
    { IMAGE_ATOMIC_OR_V1_V3_nsa_gfx10, 265 },
    { IMAGE_ATOMIC_OR_V1_V3_si, 272 },
    { IMAGE_ATOMIC_OR_V1_V3_vi, 280 },
    { IMAGE_ATOMIC_OR_V1_V4_gfx10, 259 },
    { IMAGE_ATOMIC_OR_V1_V4_gfx90a, 289 },
    { IMAGE_ATOMIC_OR_V1_V4_nsa_gfx10, 266 },
    { IMAGE_ATOMIC_OR_V1_V4_si, 273 },
    { IMAGE_ATOMIC_OR_V1_V4_vi, 281 },
    { IMAGE_ATOMIC_OR_V2_V1_gfx10, 260 },
    { IMAGE_ATOMIC_OR_V2_V1_gfx90a, 290 },
    { IMAGE_ATOMIC_OR_V2_V1_si, 274 },
    { IMAGE_ATOMIC_OR_V2_V1_vi, 282 },
    { IMAGE_ATOMIC_OR_V2_V2_gfx10, 261 },
    { IMAGE_ATOMIC_OR_V2_V2_gfx90a, 291 },
    { IMAGE_ATOMIC_OR_V2_V2_nsa_gfx10, 267 },
    { IMAGE_ATOMIC_OR_V2_V2_si, 275 },
    { IMAGE_ATOMIC_OR_V2_V2_vi, 283 },
    { IMAGE_ATOMIC_OR_V2_V3_gfx10, 262 },
    { IMAGE_ATOMIC_OR_V2_V3_gfx90a, 292 },
    { IMAGE_ATOMIC_OR_V2_V3_nsa_gfx10, 268 },
    { IMAGE_ATOMIC_OR_V2_V3_si, 276 },
    { IMAGE_ATOMIC_OR_V2_V3_vi, 284 },
    { IMAGE_ATOMIC_OR_V2_V4_gfx10, 263 },
    { IMAGE_ATOMIC_OR_V2_V4_gfx90a, 293 },
    { IMAGE_ATOMIC_OR_V2_V4_nsa_gfx10, 269 },
    { IMAGE_ATOMIC_OR_V2_V4_si, 277 },
    { IMAGE_ATOMIC_OR_V2_V4_vi, 285 },
    { IMAGE_ATOMIC_RSUB_V1_V1_si, 294 },
    { IMAGE_ATOMIC_RSUB_V1_V2_si, 295 },
    { IMAGE_ATOMIC_RSUB_V1_V3_si, 296 },
    { IMAGE_ATOMIC_RSUB_V1_V4_si, 297 },
    { IMAGE_ATOMIC_RSUB_V2_V1_si, 298 },
    { IMAGE_ATOMIC_RSUB_V2_V2_si, 299 },
    { IMAGE_ATOMIC_RSUB_V2_V3_si, 300 },
    { IMAGE_ATOMIC_RSUB_V2_V4_si, 301 },
    { IMAGE_ATOMIC_SMAX_V1_V1_gfx10, 302 },
    { IMAGE_ATOMIC_SMAX_V1_V1_gfx90a, 332 },
    { IMAGE_ATOMIC_SMAX_V1_V1_si, 316 },
    { IMAGE_ATOMIC_SMAX_V1_V1_vi, 324 },
    { IMAGE_ATOMIC_SMAX_V1_V2_gfx10, 303 },
    { IMAGE_ATOMIC_SMAX_V1_V2_gfx90a, 333 },
    { IMAGE_ATOMIC_SMAX_V1_V2_nsa_gfx10, 310 },
    { IMAGE_ATOMIC_SMAX_V1_V2_si, 317 },
    { IMAGE_ATOMIC_SMAX_V1_V2_vi, 325 },
    { IMAGE_ATOMIC_SMAX_V1_V3_gfx10, 304 },
    { IMAGE_ATOMIC_SMAX_V1_V3_gfx90a, 334 },
    { IMAGE_ATOMIC_SMAX_V1_V3_nsa_gfx10, 311 },
    { IMAGE_ATOMIC_SMAX_V1_V3_si, 318 },
    { IMAGE_ATOMIC_SMAX_V1_V3_vi, 326 },
    { IMAGE_ATOMIC_SMAX_V1_V4_gfx10, 305 },
    { IMAGE_ATOMIC_SMAX_V1_V4_gfx90a, 335 },
    { IMAGE_ATOMIC_SMAX_V1_V4_nsa_gfx10, 312 },
    { IMAGE_ATOMIC_SMAX_V1_V4_si, 319 },
    { IMAGE_ATOMIC_SMAX_V1_V4_vi, 327 },
    { IMAGE_ATOMIC_SMAX_V2_V1_gfx10, 306 },
    { IMAGE_ATOMIC_SMAX_V2_V1_gfx90a, 336 },
    { IMAGE_ATOMIC_SMAX_V2_V1_si, 320 },
    { IMAGE_ATOMIC_SMAX_V2_V1_vi, 328 },
    { IMAGE_ATOMIC_SMAX_V2_V2_gfx10, 307 },
    { IMAGE_ATOMIC_SMAX_V2_V2_gfx90a, 337 },
    { IMAGE_ATOMIC_SMAX_V2_V2_nsa_gfx10, 313 },
    { IMAGE_ATOMIC_SMAX_V2_V2_si, 321 },
    { IMAGE_ATOMIC_SMAX_V2_V2_vi, 329 },
    { IMAGE_ATOMIC_SMAX_V2_V3_gfx10, 308 },
    { IMAGE_ATOMIC_SMAX_V2_V3_gfx90a, 338 },
    { IMAGE_ATOMIC_SMAX_V2_V3_nsa_gfx10, 314 },
    { IMAGE_ATOMIC_SMAX_V2_V3_si, 322 },
    { IMAGE_ATOMIC_SMAX_V2_V3_vi, 330 },
    { IMAGE_ATOMIC_SMAX_V2_V4_gfx10, 309 },
    { IMAGE_ATOMIC_SMAX_V2_V4_gfx90a, 339 },
    { IMAGE_ATOMIC_SMAX_V2_V4_nsa_gfx10, 315 },
    { IMAGE_ATOMIC_SMAX_V2_V4_si, 323 },
    { IMAGE_ATOMIC_SMAX_V2_V4_vi, 331 },
    { IMAGE_ATOMIC_SMIN_V1_V1_gfx10, 340 },
    { IMAGE_ATOMIC_SMIN_V1_V1_gfx90a, 370 },
    { IMAGE_ATOMIC_SMIN_V1_V1_si, 354 },
    { IMAGE_ATOMIC_SMIN_V1_V1_vi, 362 },
    { IMAGE_ATOMIC_SMIN_V1_V2_gfx10, 341 },
    { IMAGE_ATOMIC_SMIN_V1_V2_gfx90a, 371 },
    { IMAGE_ATOMIC_SMIN_V1_V2_nsa_gfx10, 348 },
    { IMAGE_ATOMIC_SMIN_V1_V2_si, 355 },
    { IMAGE_ATOMIC_SMIN_V1_V2_vi, 363 },
    { IMAGE_ATOMIC_SMIN_V1_V3_gfx10, 342 },
    { IMAGE_ATOMIC_SMIN_V1_V3_gfx90a, 372 },
    { IMAGE_ATOMIC_SMIN_V1_V3_nsa_gfx10, 349 },
    { IMAGE_ATOMIC_SMIN_V1_V3_si, 356 },
    { IMAGE_ATOMIC_SMIN_V1_V3_vi, 364 },
    { IMAGE_ATOMIC_SMIN_V1_V4_gfx10, 343 },
    { IMAGE_ATOMIC_SMIN_V1_V4_gfx90a, 373 },
    { IMAGE_ATOMIC_SMIN_V1_V4_nsa_gfx10, 350 },
    { IMAGE_ATOMIC_SMIN_V1_V4_si, 357 },
    { IMAGE_ATOMIC_SMIN_V1_V4_vi, 365 },
    { IMAGE_ATOMIC_SMIN_V2_V1_gfx10, 344 },
    { IMAGE_ATOMIC_SMIN_V2_V1_gfx90a, 374 },
    { IMAGE_ATOMIC_SMIN_V2_V1_si, 358 },
    { IMAGE_ATOMIC_SMIN_V2_V1_vi, 366 },
    { IMAGE_ATOMIC_SMIN_V2_V2_gfx10, 345 },
    { IMAGE_ATOMIC_SMIN_V2_V2_gfx90a, 375 },
    { IMAGE_ATOMIC_SMIN_V2_V2_nsa_gfx10, 351 },
    { IMAGE_ATOMIC_SMIN_V2_V2_si, 359 },
    { IMAGE_ATOMIC_SMIN_V2_V2_vi, 367 },
    { IMAGE_ATOMIC_SMIN_V2_V3_gfx10, 346 },
    { IMAGE_ATOMIC_SMIN_V2_V3_gfx90a, 376 },
    { IMAGE_ATOMIC_SMIN_V2_V3_nsa_gfx10, 352 },
    { IMAGE_ATOMIC_SMIN_V2_V3_si, 360 },
    { IMAGE_ATOMIC_SMIN_V2_V3_vi, 368 },
    { IMAGE_ATOMIC_SMIN_V2_V4_gfx10, 347 },
    { IMAGE_ATOMIC_SMIN_V2_V4_gfx90a, 377 },
    { IMAGE_ATOMIC_SMIN_V2_V4_nsa_gfx10, 353 },
    { IMAGE_ATOMIC_SMIN_V2_V4_si, 361 },
    { IMAGE_ATOMIC_SMIN_V2_V4_vi, 369 },
    { IMAGE_ATOMIC_SUB_V1_V1_gfx10, 378 },
    { IMAGE_ATOMIC_SUB_V1_V1_gfx90a, 408 },
    { IMAGE_ATOMIC_SUB_V1_V1_si, 392 },
    { IMAGE_ATOMIC_SUB_V1_V1_vi, 400 },
    { IMAGE_ATOMIC_SUB_V1_V2_gfx10, 379 },
    { IMAGE_ATOMIC_SUB_V1_V2_gfx90a, 409 },
    { IMAGE_ATOMIC_SUB_V1_V2_nsa_gfx10, 386 },
    { IMAGE_ATOMIC_SUB_V1_V2_si, 393 },
    { IMAGE_ATOMIC_SUB_V1_V2_vi, 401 },
    { IMAGE_ATOMIC_SUB_V1_V3_gfx10, 380 },
    { IMAGE_ATOMIC_SUB_V1_V3_gfx90a, 410 },
    { IMAGE_ATOMIC_SUB_V1_V3_nsa_gfx10, 387 },
    { IMAGE_ATOMIC_SUB_V1_V3_si, 394 },
    { IMAGE_ATOMIC_SUB_V1_V3_vi, 402 },
    { IMAGE_ATOMIC_SUB_V1_V4_gfx10, 381 },
    { IMAGE_ATOMIC_SUB_V1_V4_gfx90a, 411 },
    { IMAGE_ATOMIC_SUB_V1_V4_nsa_gfx10, 388 },
    { IMAGE_ATOMIC_SUB_V1_V4_si, 395 },
    { IMAGE_ATOMIC_SUB_V1_V4_vi, 403 },
    { IMAGE_ATOMIC_SUB_V2_V1_gfx10, 382 },
    { IMAGE_ATOMIC_SUB_V2_V1_gfx90a, 412 },
    { IMAGE_ATOMIC_SUB_V2_V1_si, 396 },
    { IMAGE_ATOMIC_SUB_V2_V1_vi, 404 },
    { IMAGE_ATOMIC_SUB_V2_V2_gfx10, 383 },
    { IMAGE_ATOMIC_SUB_V2_V2_gfx90a, 413 },
    { IMAGE_ATOMIC_SUB_V2_V2_nsa_gfx10, 389 },
    { IMAGE_ATOMIC_SUB_V2_V2_si, 397 },
    { IMAGE_ATOMIC_SUB_V2_V2_vi, 405 },
    { IMAGE_ATOMIC_SUB_V2_V3_gfx10, 384 },
    { IMAGE_ATOMIC_SUB_V2_V3_gfx90a, 414 },
    { IMAGE_ATOMIC_SUB_V2_V3_nsa_gfx10, 390 },
    { IMAGE_ATOMIC_SUB_V2_V3_si, 398 },
    { IMAGE_ATOMIC_SUB_V2_V3_vi, 406 },
    { IMAGE_ATOMIC_SUB_V2_V4_gfx10, 385 },
    { IMAGE_ATOMIC_SUB_V2_V4_gfx90a, 415 },
    { IMAGE_ATOMIC_SUB_V2_V4_nsa_gfx10, 391 },
    { IMAGE_ATOMIC_SUB_V2_V4_si, 399 },
    { IMAGE_ATOMIC_SUB_V2_V4_vi, 407 },
    { IMAGE_ATOMIC_SWAP_V1_V1_gfx10, 416 },
    { IMAGE_ATOMIC_SWAP_V1_V1_gfx90a, 446 },
    { IMAGE_ATOMIC_SWAP_V1_V1_si, 430 },
    { IMAGE_ATOMIC_SWAP_V1_V1_vi, 438 },
    { IMAGE_ATOMIC_SWAP_V1_V2_gfx10, 417 },
    { IMAGE_ATOMIC_SWAP_V1_V2_gfx90a, 447 },
    { IMAGE_ATOMIC_SWAP_V1_V2_nsa_gfx10, 424 },
    { IMAGE_ATOMIC_SWAP_V1_V2_si, 431 },
    { IMAGE_ATOMIC_SWAP_V1_V2_vi, 439 },
    { IMAGE_ATOMIC_SWAP_V1_V3_gfx10, 418 },
    { IMAGE_ATOMIC_SWAP_V1_V3_gfx90a, 448 },
    { IMAGE_ATOMIC_SWAP_V1_V3_nsa_gfx10, 425 },
    { IMAGE_ATOMIC_SWAP_V1_V3_si, 432 },
    { IMAGE_ATOMIC_SWAP_V1_V3_vi, 440 },
    { IMAGE_ATOMIC_SWAP_V1_V4_gfx10, 419 },
    { IMAGE_ATOMIC_SWAP_V1_V4_gfx90a, 449 },
    { IMAGE_ATOMIC_SWAP_V1_V4_nsa_gfx10, 426 },
    { IMAGE_ATOMIC_SWAP_V1_V4_si, 433 },
    { IMAGE_ATOMIC_SWAP_V1_V4_vi, 441 },
    { IMAGE_ATOMIC_SWAP_V2_V1_gfx10, 420 },
    { IMAGE_ATOMIC_SWAP_V2_V1_gfx90a, 450 },
    { IMAGE_ATOMIC_SWAP_V2_V1_si, 434 },
    { IMAGE_ATOMIC_SWAP_V2_V1_vi, 442 },
    { IMAGE_ATOMIC_SWAP_V2_V2_gfx10, 421 },
    { IMAGE_ATOMIC_SWAP_V2_V2_gfx90a, 451 },
    { IMAGE_ATOMIC_SWAP_V2_V2_nsa_gfx10, 427 },
    { IMAGE_ATOMIC_SWAP_V2_V2_si, 435 },
    { IMAGE_ATOMIC_SWAP_V2_V2_vi, 443 },
    { IMAGE_ATOMIC_SWAP_V2_V3_gfx10, 422 },
    { IMAGE_ATOMIC_SWAP_V2_V3_gfx90a, 452 },
    { IMAGE_ATOMIC_SWAP_V2_V3_nsa_gfx10, 428 },
    { IMAGE_ATOMIC_SWAP_V2_V3_si, 436 },
    { IMAGE_ATOMIC_SWAP_V2_V3_vi, 444 },
    { IMAGE_ATOMIC_SWAP_V2_V4_gfx10, 423 },
    { IMAGE_ATOMIC_SWAP_V2_V4_gfx90a, 453 },
    { IMAGE_ATOMIC_SWAP_V2_V4_nsa_gfx10, 429 },
    { IMAGE_ATOMIC_SWAP_V2_V4_si, 437 },
    { IMAGE_ATOMIC_SWAP_V2_V4_vi, 445 },
    { IMAGE_ATOMIC_UMAX_V1_V1_gfx10, 454 },
    { IMAGE_ATOMIC_UMAX_V1_V1_gfx90a, 484 },
    { IMAGE_ATOMIC_UMAX_V1_V1_si, 468 },
    { IMAGE_ATOMIC_UMAX_V1_V1_vi, 476 },
    { IMAGE_ATOMIC_UMAX_V1_V2_gfx10, 455 },
    { IMAGE_ATOMIC_UMAX_V1_V2_gfx90a, 485 },
    { IMAGE_ATOMIC_UMAX_V1_V2_nsa_gfx10, 462 },
    { IMAGE_ATOMIC_UMAX_V1_V2_si, 469 },
    { IMAGE_ATOMIC_UMAX_V1_V2_vi, 477 },
    { IMAGE_ATOMIC_UMAX_V1_V3_gfx10, 456 },
    { IMAGE_ATOMIC_UMAX_V1_V3_gfx90a, 486 },
    { IMAGE_ATOMIC_UMAX_V1_V3_nsa_gfx10, 463 },
    { IMAGE_ATOMIC_UMAX_V1_V3_si, 470 },
    { IMAGE_ATOMIC_UMAX_V1_V3_vi, 478 },
    { IMAGE_ATOMIC_UMAX_V1_V4_gfx10, 457 },
    { IMAGE_ATOMIC_UMAX_V1_V4_gfx90a, 487 },
    { IMAGE_ATOMIC_UMAX_V1_V4_nsa_gfx10, 464 },
    { IMAGE_ATOMIC_UMAX_V1_V4_si, 471 },
    { IMAGE_ATOMIC_UMAX_V1_V4_vi, 479 },
    { IMAGE_ATOMIC_UMAX_V2_V1_gfx10, 458 },
    { IMAGE_ATOMIC_UMAX_V2_V1_gfx90a, 488 },
    { IMAGE_ATOMIC_UMAX_V2_V1_si, 472 },
    { IMAGE_ATOMIC_UMAX_V2_V1_vi, 480 },
    { IMAGE_ATOMIC_UMAX_V2_V2_gfx10, 459 },
    { IMAGE_ATOMIC_UMAX_V2_V2_gfx90a, 489 },
    { IMAGE_ATOMIC_UMAX_V2_V2_nsa_gfx10, 465 },
    { IMAGE_ATOMIC_UMAX_V2_V2_si, 473 },
    { IMAGE_ATOMIC_UMAX_V2_V2_vi, 481 },
    { IMAGE_ATOMIC_UMAX_V2_V3_gfx10, 460 },
    { IMAGE_ATOMIC_UMAX_V2_V3_gfx90a, 490 },
    { IMAGE_ATOMIC_UMAX_V2_V3_nsa_gfx10, 466 },
    { IMAGE_ATOMIC_UMAX_V2_V3_si, 474 },
    { IMAGE_ATOMIC_UMAX_V2_V3_vi, 482 },
    { IMAGE_ATOMIC_UMAX_V2_V4_gfx10, 461 },
    { IMAGE_ATOMIC_UMAX_V2_V4_gfx90a, 491 },
    { IMAGE_ATOMIC_UMAX_V2_V4_nsa_gfx10, 467 },
    { IMAGE_ATOMIC_UMAX_V2_V4_si, 475 },
    { IMAGE_ATOMIC_UMAX_V2_V4_vi, 483 },
    { IMAGE_ATOMIC_UMIN_V1_V1_gfx10, 492 },
    { IMAGE_ATOMIC_UMIN_V1_V1_gfx90a, 522 },
    { IMAGE_ATOMIC_UMIN_V1_V1_si, 506 },
    { IMAGE_ATOMIC_UMIN_V1_V1_vi, 514 },
    { IMAGE_ATOMIC_UMIN_V1_V2_gfx10, 493 },
    { IMAGE_ATOMIC_UMIN_V1_V2_gfx90a, 523 },
    { IMAGE_ATOMIC_UMIN_V1_V2_nsa_gfx10, 500 },
    { IMAGE_ATOMIC_UMIN_V1_V2_si, 507 },
    { IMAGE_ATOMIC_UMIN_V1_V2_vi, 515 },
    { IMAGE_ATOMIC_UMIN_V1_V3_gfx10, 494 },
    { IMAGE_ATOMIC_UMIN_V1_V3_gfx90a, 524 },
    { IMAGE_ATOMIC_UMIN_V1_V3_nsa_gfx10, 501 },
    { IMAGE_ATOMIC_UMIN_V1_V3_si, 508 },
    { IMAGE_ATOMIC_UMIN_V1_V3_vi, 516 },
    { IMAGE_ATOMIC_UMIN_V1_V4_gfx10, 495 },
    { IMAGE_ATOMIC_UMIN_V1_V4_gfx90a, 525 },
    { IMAGE_ATOMIC_UMIN_V1_V4_nsa_gfx10, 502 },
    { IMAGE_ATOMIC_UMIN_V1_V4_si, 509 },
    { IMAGE_ATOMIC_UMIN_V1_V4_vi, 517 },
    { IMAGE_ATOMIC_UMIN_V2_V1_gfx10, 496 },
    { IMAGE_ATOMIC_UMIN_V2_V1_gfx90a, 526 },
    { IMAGE_ATOMIC_UMIN_V2_V1_si, 510 },
    { IMAGE_ATOMIC_UMIN_V2_V1_vi, 518 },
    { IMAGE_ATOMIC_UMIN_V2_V2_gfx10, 497 },
    { IMAGE_ATOMIC_UMIN_V2_V2_gfx90a, 527 },
    { IMAGE_ATOMIC_UMIN_V2_V2_nsa_gfx10, 503 },
    { IMAGE_ATOMIC_UMIN_V2_V2_si, 511 },
    { IMAGE_ATOMIC_UMIN_V2_V2_vi, 519 },
    { IMAGE_ATOMIC_UMIN_V2_V3_gfx10, 498 },
    { IMAGE_ATOMIC_UMIN_V2_V3_gfx90a, 528 },
    { IMAGE_ATOMIC_UMIN_V2_V3_nsa_gfx10, 504 },
    { IMAGE_ATOMIC_UMIN_V2_V3_si, 512 },
    { IMAGE_ATOMIC_UMIN_V2_V3_vi, 520 },
    { IMAGE_ATOMIC_UMIN_V2_V4_gfx10, 499 },
    { IMAGE_ATOMIC_UMIN_V2_V4_gfx90a, 529 },
    { IMAGE_ATOMIC_UMIN_V2_V4_nsa_gfx10, 505 },
    { IMAGE_ATOMIC_UMIN_V2_V4_si, 513 },
    { IMAGE_ATOMIC_UMIN_V2_V4_vi, 521 },
    { IMAGE_ATOMIC_XOR_V1_V1_gfx10, 530 },
    { IMAGE_ATOMIC_XOR_V1_V1_gfx90a, 560 },
    { IMAGE_ATOMIC_XOR_V1_V1_si, 544 },
    { IMAGE_ATOMIC_XOR_V1_V1_vi, 552 },
    { IMAGE_ATOMIC_XOR_V1_V2_gfx10, 531 },
    { IMAGE_ATOMIC_XOR_V1_V2_gfx90a, 561 },
    { IMAGE_ATOMIC_XOR_V1_V2_nsa_gfx10, 538 },
    { IMAGE_ATOMIC_XOR_V1_V2_si, 545 },
    { IMAGE_ATOMIC_XOR_V1_V2_vi, 553 },
    { IMAGE_ATOMIC_XOR_V1_V3_gfx10, 532 },
    { IMAGE_ATOMIC_XOR_V1_V3_gfx90a, 562 },
    { IMAGE_ATOMIC_XOR_V1_V3_nsa_gfx10, 539 },
    { IMAGE_ATOMIC_XOR_V1_V3_si, 546 },
    { IMAGE_ATOMIC_XOR_V1_V3_vi, 554 },
    { IMAGE_ATOMIC_XOR_V1_V4_gfx10, 533 },
    { IMAGE_ATOMIC_XOR_V1_V4_gfx90a, 563 },
    { IMAGE_ATOMIC_XOR_V1_V4_nsa_gfx10, 540 },
    { IMAGE_ATOMIC_XOR_V1_V4_si, 547 },
    { IMAGE_ATOMIC_XOR_V1_V4_vi, 555 },
    { IMAGE_ATOMIC_XOR_V2_V1_gfx10, 534 },
    { IMAGE_ATOMIC_XOR_V2_V1_gfx90a, 564 },
    { IMAGE_ATOMIC_XOR_V2_V1_si, 548 },
    { IMAGE_ATOMIC_XOR_V2_V1_vi, 556 },
    { IMAGE_ATOMIC_XOR_V2_V2_gfx10, 535 },
    { IMAGE_ATOMIC_XOR_V2_V2_gfx90a, 565 },
    { IMAGE_ATOMIC_XOR_V2_V2_nsa_gfx10, 541 },
    { IMAGE_ATOMIC_XOR_V2_V2_si, 549 },
    { IMAGE_ATOMIC_XOR_V2_V2_vi, 557 },
    { IMAGE_ATOMIC_XOR_V2_V3_gfx10, 536 },
    { IMAGE_ATOMIC_XOR_V2_V3_gfx90a, 566 },
    { IMAGE_ATOMIC_XOR_V2_V3_nsa_gfx10, 542 },
    { IMAGE_ATOMIC_XOR_V2_V3_si, 550 },
    { IMAGE_ATOMIC_XOR_V2_V3_vi, 558 },
    { IMAGE_ATOMIC_XOR_V2_V4_gfx10, 537 },
    { IMAGE_ATOMIC_XOR_V2_V4_gfx90a, 567 },
    { IMAGE_ATOMIC_XOR_V2_V4_nsa_gfx10, 543 },
    { IMAGE_ATOMIC_XOR_V2_V4_si, 551 },
    { IMAGE_ATOMIC_XOR_V2_V4_vi, 559 },
    { IMAGE_BVH64_INTERSECT_RAY_a16_nsa_gfx10, 571 },
    { IMAGE_BVH64_INTERSECT_RAY_a16_sa_gfx10, 570 },
    { IMAGE_BVH64_INTERSECT_RAY_nsa_gfx10, 569 },
    { IMAGE_BVH64_INTERSECT_RAY_sa_gfx10, 568 },
    { IMAGE_BVH_INTERSECT_RAY_a16_nsa_gfx10, 575 },
    { IMAGE_BVH_INTERSECT_RAY_a16_sa_gfx10, 574 },
    { IMAGE_BVH_INTERSECT_RAY_nsa_gfx10, 573 },
    { IMAGE_BVH_INTERSECT_RAY_sa_gfx10, 572 },
    { IMAGE_GATHER4_B_CL_O_V2_V3, 702 },
    { IMAGE_GATHER4_B_CL_O_V2_V3_gfx10, 675 },
    { IMAGE_GATHER4_B_CL_O_V2_V3_nsa_gfx10, 690 },
    { IMAGE_GATHER4_B_CL_O_V2_V4, 703 },
    { IMAGE_GATHER4_B_CL_O_V2_V4_gfx10, 676 },
    { IMAGE_GATHER4_B_CL_O_V2_V4_nsa_gfx10, 691 },
    { IMAGE_GATHER4_B_CL_O_V2_V5, 704 },
    { IMAGE_GATHER4_B_CL_O_V2_V5_gfx10, 677 },
    { IMAGE_GATHER4_B_CL_O_V2_V5_nsa_gfx10, 692 },
    { IMAGE_GATHER4_B_CL_O_V2_V6, 705 },
    { IMAGE_GATHER4_B_CL_O_V2_V6_gfx10, 678 },
    { IMAGE_GATHER4_B_CL_O_V2_V6_nsa_gfx10, 693 },
    { IMAGE_GATHER4_B_CL_O_V2_V8, 706 },
    { IMAGE_GATHER4_B_CL_O_V2_V8_gfx10, 679 },
    { IMAGE_GATHER4_B_CL_O_V4_V3, 707 },
    { IMAGE_GATHER4_B_CL_O_V4_V3_gfx10, 680 },
    { IMAGE_GATHER4_B_CL_O_V4_V3_nsa_gfx10, 694 },
    { IMAGE_GATHER4_B_CL_O_V4_V4, 708 },
    { IMAGE_GATHER4_B_CL_O_V4_V4_gfx10, 681 },
    { IMAGE_GATHER4_B_CL_O_V4_V4_nsa_gfx10, 695 },
    { IMAGE_GATHER4_B_CL_O_V4_V5, 709 },
    { IMAGE_GATHER4_B_CL_O_V4_V5_gfx10, 682 },
    { IMAGE_GATHER4_B_CL_O_V4_V5_nsa_gfx10, 696 },
    { IMAGE_GATHER4_B_CL_O_V4_V6, 710 },
    { IMAGE_GATHER4_B_CL_O_V4_V6_gfx10, 683 },
    { IMAGE_GATHER4_B_CL_O_V4_V6_nsa_gfx10, 697 },
    { IMAGE_GATHER4_B_CL_O_V4_V8, 711 },
    { IMAGE_GATHER4_B_CL_O_V4_V8_gfx10, 684 },
    { IMAGE_GATHER4_B_CL_O_V5_V3, 712 },
    { IMAGE_GATHER4_B_CL_O_V5_V3_gfx10, 685 },
    { IMAGE_GATHER4_B_CL_O_V5_V3_nsa_gfx10, 698 },
    { IMAGE_GATHER4_B_CL_O_V5_V4, 713 },
    { IMAGE_GATHER4_B_CL_O_V5_V4_gfx10, 686 },
    { IMAGE_GATHER4_B_CL_O_V5_V4_nsa_gfx10, 699 },
    { IMAGE_GATHER4_B_CL_O_V5_V5, 714 },
    { IMAGE_GATHER4_B_CL_O_V5_V5_gfx10, 687 },
    { IMAGE_GATHER4_B_CL_O_V5_V5_nsa_gfx10, 700 },
    { IMAGE_GATHER4_B_CL_O_V5_V6, 715 },
    { IMAGE_GATHER4_B_CL_O_V5_V6_gfx10, 688 },
    { IMAGE_GATHER4_B_CL_O_V5_V6_nsa_gfx10, 701 },
    { IMAGE_GATHER4_B_CL_O_V5_V8, 716 },
    { IMAGE_GATHER4_B_CL_O_V5_V8_gfx10, 689 },
    { IMAGE_GATHER4_B_CL_V2_V2, 660 },
    { IMAGE_GATHER4_B_CL_V2_V2_gfx10, 633 },
    { IMAGE_GATHER4_B_CL_V2_V2_nsa_gfx10, 648 },
    { IMAGE_GATHER4_B_CL_V2_V3, 661 },
    { IMAGE_GATHER4_B_CL_V2_V3_gfx10, 634 },
    { IMAGE_GATHER4_B_CL_V2_V3_nsa_gfx10, 649 },
    { IMAGE_GATHER4_B_CL_V2_V4, 662 },
    { IMAGE_GATHER4_B_CL_V2_V4_gfx10, 635 },
    { IMAGE_GATHER4_B_CL_V2_V4_nsa_gfx10, 650 },
    { IMAGE_GATHER4_B_CL_V2_V5, 663 },
    { IMAGE_GATHER4_B_CL_V2_V5_gfx10, 636 },
    { IMAGE_GATHER4_B_CL_V2_V5_nsa_gfx10, 651 },
    { IMAGE_GATHER4_B_CL_V2_V8, 664 },
    { IMAGE_GATHER4_B_CL_V2_V8_gfx10, 637 },
    { IMAGE_GATHER4_B_CL_V4_V2, 665 },
    { IMAGE_GATHER4_B_CL_V4_V2_gfx10, 638 },
    { IMAGE_GATHER4_B_CL_V4_V2_nsa_gfx10, 652 },
    { IMAGE_GATHER4_B_CL_V4_V3, 666 },
    { IMAGE_GATHER4_B_CL_V4_V3_gfx10, 639 },
    { IMAGE_GATHER4_B_CL_V4_V3_nsa_gfx10, 653 },
    { IMAGE_GATHER4_B_CL_V4_V4, 667 },
    { IMAGE_GATHER4_B_CL_V4_V4_gfx10, 640 },
    { IMAGE_GATHER4_B_CL_V4_V4_nsa_gfx10, 654 },
    { IMAGE_GATHER4_B_CL_V4_V5, 668 },
    { IMAGE_GATHER4_B_CL_V4_V5_gfx10, 641 },
    { IMAGE_GATHER4_B_CL_V4_V5_nsa_gfx10, 655 },
    { IMAGE_GATHER4_B_CL_V4_V8, 669 },
    { IMAGE_GATHER4_B_CL_V4_V8_gfx10, 642 },
    { IMAGE_GATHER4_B_CL_V5_V2, 670 },
    { IMAGE_GATHER4_B_CL_V5_V2_gfx10, 643 },
    { IMAGE_GATHER4_B_CL_V5_V2_nsa_gfx10, 656 },
    { IMAGE_GATHER4_B_CL_V5_V3, 671 },
    { IMAGE_GATHER4_B_CL_V5_V3_gfx10, 644 },
    { IMAGE_GATHER4_B_CL_V5_V3_nsa_gfx10, 657 },
    { IMAGE_GATHER4_B_CL_V5_V4, 672 },
    { IMAGE_GATHER4_B_CL_V5_V4_gfx10, 645 },
    { IMAGE_GATHER4_B_CL_V5_V4_nsa_gfx10, 658 },
    { IMAGE_GATHER4_B_CL_V5_V5, 673 },
    { IMAGE_GATHER4_B_CL_V5_V5_gfx10, 646 },
    { IMAGE_GATHER4_B_CL_V5_V5_nsa_gfx10, 659 },
    { IMAGE_GATHER4_B_CL_V5_V8, 674 },
    { IMAGE_GATHER4_B_CL_V5_V8_gfx10, 647 },
    { IMAGE_GATHER4_B_O_V2_V3, 738 },
    { IMAGE_GATHER4_B_O_V2_V3_gfx10, 717 },
    { IMAGE_GATHER4_B_O_V2_V3_nsa_gfx10, 729 },
    { IMAGE_GATHER4_B_O_V2_V4, 739 },
    { IMAGE_GATHER4_B_O_V2_V4_gfx10, 718 },
    { IMAGE_GATHER4_B_O_V2_V4_nsa_gfx10, 730 },
    { IMAGE_GATHER4_B_O_V2_V5, 740 },
    { IMAGE_GATHER4_B_O_V2_V5_gfx10, 719 },
    { IMAGE_GATHER4_B_O_V2_V5_nsa_gfx10, 731 },
    { IMAGE_GATHER4_B_O_V2_V8, 741 },
    { IMAGE_GATHER4_B_O_V2_V8_gfx10, 720 },
    { IMAGE_GATHER4_B_O_V4_V3, 742 },
    { IMAGE_GATHER4_B_O_V4_V3_gfx10, 721 },
    { IMAGE_GATHER4_B_O_V4_V3_nsa_gfx10, 732 },
    { IMAGE_GATHER4_B_O_V4_V4, 743 },
    { IMAGE_GATHER4_B_O_V4_V4_gfx10, 722 },
    { IMAGE_GATHER4_B_O_V4_V4_nsa_gfx10, 733 },
    { IMAGE_GATHER4_B_O_V4_V5, 744 },
    { IMAGE_GATHER4_B_O_V4_V5_gfx10, 723 },
    { IMAGE_GATHER4_B_O_V4_V5_nsa_gfx10, 734 },
    { IMAGE_GATHER4_B_O_V4_V8, 745 },
    { IMAGE_GATHER4_B_O_V4_V8_gfx10, 724 },
    { IMAGE_GATHER4_B_O_V5_V3, 746 },
    { IMAGE_GATHER4_B_O_V5_V3_gfx10, 725 },
    { IMAGE_GATHER4_B_O_V5_V3_nsa_gfx10, 735 },
    { IMAGE_GATHER4_B_O_V5_V4, 747 },
    { IMAGE_GATHER4_B_O_V5_V4_gfx10, 726 },
    { IMAGE_GATHER4_B_O_V5_V4_nsa_gfx10, 736 },
    { IMAGE_GATHER4_B_O_V5_V5, 748 },
    { IMAGE_GATHER4_B_O_V5_V5_gfx10, 727 },
    { IMAGE_GATHER4_B_O_V5_V5_nsa_gfx10, 737 },
    { IMAGE_GATHER4_B_O_V5_V8, 749 },
    { IMAGE_GATHER4_B_O_V5_V8_gfx10, 728 },
    { IMAGE_GATHER4_B_V2_V2, 624 },
    { IMAGE_GATHER4_B_V2_V2_gfx10, 606 },
    { IMAGE_GATHER4_B_V2_V2_nsa_gfx10, 615 },
    { IMAGE_GATHER4_B_V2_V3, 625 },
    { IMAGE_GATHER4_B_V2_V3_gfx10, 607 },
    { IMAGE_GATHER4_B_V2_V3_nsa_gfx10, 616 },
    { IMAGE_GATHER4_B_V2_V4, 626 },
    { IMAGE_GATHER4_B_V2_V4_gfx10, 608 },
    { IMAGE_GATHER4_B_V2_V4_nsa_gfx10, 617 },
    { IMAGE_GATHER4_B_V4_V2, 627 },
    { IMAGE_GATHER4_B_V4_V2_gfx10, 609 },
    { IMAGE_GATHER4_B_V4_V2_nsa_gfx10, 618 },
    { IMAGE_GATHER4_B_V4_V3, 628 },
    { IMAGE_GATHER4_B_V4_V3_gfx10, 610 },
    { IMAGE_GATHER4_B_V4_V3_nsa_gfx10, 619 },
    { IMAGE_GATHER4_B_V4_V4, 629 },
    { IMAGE_GATHER4_B_V4_V4_gfx10, 611 },
    { IMAGE_GATHER4_B_V4_V4_nsa_gfx10, 620 },
    { IMAGE_GATHER4_B_V5_V2, 630 },
    { IMAGE_GATHER4_B_V5_V2_gfx10, 612 },
    { IMAGE_GATHER4_B_V5_V2_nsa_gfx10, 621 },
    { IMAGE_GATHER4_B_V5_V3, 631 },
    { IMAGE_GATHER4_B_V5_V3_gfx10, 613 },
    { IMAGE_GATHER4_B_V5_V3_nsa_gfx10, 622 },
    { IMAGE_GATHER4_B_V5_V4, 632 },
    { IMAGE_GATHER4_B_V5_V4_gfx10, 614 },
    { IMAGE_GATHER4_B_V5_V4_nsa_gfx10, 623 },
    { IMAGE_GATHER4_CL_O_V2_V2, 837 },
    { IMAGE_GATHER4_CL_O_V2_V2_gfx10, 810 },
    { IMAGE_GATHER4_CL_O_V2_V2_nsa_gfx10, 825 },
    { IMAGE_GATHER4_CL_O_V2_V3, 838 },
    { IMAGE_GATHER4_CL_O_V2_V3_gfx10, 811 },
    { IMAGE_GATHER4_CL_O_V2_V3_nsa_gfx10, 826 },
    { IMAGE_GATHER4_CL_O_V2_V4, 839 },
    { IMAGE_GATHER4_CL_O_V2_V4_gfx10, 812 },
    { IMAGE_GATHER4_CL_O_V2_V4_nsa_gfx10, 827 },
    { IMAGE_GATHER4_CL_O_V2_V5, 840 },
    { IMAGE_GATHER4_CL_O_V2_V5_gfx10, 813 },
    { IMAGE_GATHER4_CL_O_V2_V5_nsa_gfx10, 828 },
    { IMAGE_GATHER4_CL_O_V2_V8, 841 },
    { IMAGE_GATHER4_CL_O_V2_V8_gfx10, 814 },
    { IMAGE_GATHER4_CL_O_V4_V2, 842 },
    { IMAGE_GATHER4_CL_O_V4_V2_gfx10, 815 },
    { IMAGE_GATHER4_CL_O_V4_V2_nsa_gfx10, 829 },
    { IMAGE_GATHER4_CL_O_V4_V3, 843 },
    { IMAGE_GATHER4_CL_O_V4_V3_gfx10, 816 },
    { IMAGE_GATHER4_CL_O_V4_V3_nsa_gfx10, 830 },
    { IMAGE_GATHER4_CL_O_V4_V4, 844 },
    { IMAGE_GATHER4_CL_O_V4_V4_gfx10, 817 },
    { IMAGE_GATHER4_CL_O_V4_V4_nsa_gfx10, 831 },
    { IMAGE_GATHER4_CL_O_V4_V5, 845 },
    { IMAGE_GATHER4_CL_O_V4_V5_gfx10, 818 },
    { IMAGE_GATHER4_CL_O_V4_V5_nsa_gfx10, 832 },
    { IMAGE_GATHER4_CL_O_V4_V8, 846 },
    { IMAGE_GATHER4_CL_O_V4_V8_gfx10, 819 },
    { IMAGE_GATHER4_CL_O_V5_V2, 847 },
    { IMAGE_GATHER4_CL_O_V5_V2_gfx10, 820 },
    { IMAGE_GATHER4_CL_O_V5_V2_nsa_gfx10, 833 },
    { IMAGE_GATHER4_CL_O_V5_V3, 848 },
    { IMAGE_GATHER4_CL_O_V5_V3_gfx10, 821 },
    { IMAGE_GATHER4_CL_O_V5_V3_nsa_gfx10, 834 },
    { IMAGE_GATHER4_CL_O_V5_V4, 849 },
    { IMAGE_GATHER4_CL_O_V5_V4_gfx10, 822 },
    { IMAGE_GATHER4_CL_O_V5_V4_nsa_gfx10, 835 },
    { IMAGE_GATHER4_CL_O_V5_V5, 850 },
    { IMAGE_GATHER4_CL_O_V5_V5_gfx10, 823 },
    { IMAGE_GATHER4_CL_O_V5_V5_nsa_gfx10, 836 },
    { IMAGE_GATHER4_CL_O_V5_V8, 851 },
    { IMAGE_GATHER4_CL_O_V5_V8_gfx10, 824 },
    { IMAGE_GATHER4_CL_V2_V1, 798 },
    { IMAGE_GATHER4_CL_V2_V1_gfx10, 777 },
    { IMAGE_GATHER4_CL_V2_V2, 799 },
    { IMAGE_GATHER4_CL_V2_V2_gfx10, 778 },
    { IMAGE_GATHER4_CL_V2_V2_nsa_gfx10, 789 },
    { IMAGE_GATHER4_CL_V2_V3, 800 },
    { IMAGE_GATHER4_CL_V2_V3_gfx10, 779 },
    { IMAGE_GATHER4_CL_V2_V3_nsa_gfx10, 790 },
    { IMAGE_GATHER4_CL_V2_V4, 801 },
    { IMAGE_GATHER4_CL_V2_V4_gfx10, 780 },
    { IMAGE_GATHER4_CL_V2_V4_nsa_gfx10, 791 },
    { IMAGE_GATHER4_CL_V4_V1, 802 },
    { IMAGE_GATHER4_CL_V4_V1_gfx10, 781 },
    { IMAGE_GATHER4_CL_V4_V2, 803 },
    { IMAGE_GATHER4_CL_V4_V2_gfx10, 782 },
    { IMAGE_GATHER4_CL_V4_V2_nsa_gfx10, 792 },
    { IMAGE_GATHER4_CL_V4_V3, 804 },
    { IMAGE_GATHER4_CL_V4_V3_gfx10, 783 },
    { IMAGE_GATHER4_CL_V4_V3_nsa_gfx10, 793 },
    { IMAGE_GATHER4_CL_V4_V4, 805 },
    { IMAGE_GATHER4_CL_V4_V4_gfx10, 784 },
    { IMAGE_GATHER4_CL_V4_V4_nsa_gfx10, 794 },
    { IMAGE_GATHER4_CL_V5_V1, 806 },
    { IMAGE_GATHER4_CL_V5_V1_gfx10, 785 },
    { IMAGE_GATHER4_CL_V5_V2, 807 },
    { IMAGE_GATHER4_CL_V5_V2_gfx10, 786 },
    { IMAGE_GATHER4_CL_V5_V2_nsa_gfx10, 795 },
    { IMAGE_GATHER4_CL_V5_V3, 808 },
    { IMAGE_GATHER4_CL_V5_V3_gfx10, 787 },
    { IMAGE_GATHER4_CL_V5_V3_nsa_gfx10, 796 },
    { IMAGE_GATHER4_CL_V5_V4, 809 },
    { IMAGE_GATHER4_CL_V5_V4_gfx10, 788 },
    { IMAGE_GATHER4_CL_V5_V4_nsa_gfx10, 797 },
    { IMAGE_GATHER4_C_B_CL_O_V2_V4, 954 },
    { IMAGE_GATHER4_C_B_CL_O_V2_V4_gfx10, 927 },
    { IMAGE_GATHER4_C_B_CL_O_V2_V4_nsa_gfx10, 942 },
    { IMAGE_GATHER4_C_B_CL_O_V2_V5, 955 },
    { IMAGE_GATHER4_C_B_CL_O_V2_V5_gfx10, 928 },
    { IMAGE_GATHER4_C_B_CL_O_V2_V5_nsa_gfx10, 943 },
    { IMAGE_GATHER4_C_B_CL_O_V2_V6, 956 },
    { IMAGE_GATHER4_C_B_CL_O_V2_V6_gfx10, 929 },
    { IMAGE_GATHER4_C_B_CL_O_V2_V6_nsa_gfx10, 944 },
    { IMAGE_GATHER4_C_B_CL_O_V2_V7, 957 },
    { IMAGE_GATHER4_C_B_CL_O_V2_V7_gfx10, 930 },
    { IMAGE_GATHER4_C_B_CL_O_V2_V7_nsa_gfx10, 945 },
    { IMAGE_GATHER4_C_B_CL_O_V2_V8, 958 },
    { IMAGE_GATHER4_C_B_CL_O_V2_V8_gfx10, 931 },
    { IMAGE_GATHER4_C_B_CL_O_V4_V4, 959 },
    { IMAGE_GATHER4_C_B_CL_O_V4_V4_gfx10, 932 },
    { IMAGE_GATHER4_C_B_CL_O_V4_V4_nsa_gfx10, 946 },
    { IMAGE_GATHER4_C_B_CL_O_V4_V5, 960 },
    { IMAGE_GATHER4_C_B_CL_O_V4_V5_gfx10, 933 },
    { IMAGE_GATHER4_C_B_CL_O_V4_V5_nsa_gfx10, 947 },
    { IMAGE_GATHER4_C_B_CL_O_V4_V6, 961 },
    { IMAGE_GATHER4_C_B_CL_O_V4_V6_gfx10, 934 },
    { IMAGE_GATHER4_C_B_CL_O_V4_V6_nsa_gfx10, 948 },
    { IMAGE_GATHER4_C_B_CL_O_V4_V7, 962 },
    { IMAGE_GATHER4_C_B_CL_O_V4_V7_gfx10, 935 },
    { IMAGE_GATHER4_C_B_CL_O_V4_V7_nsa_gfx10, 949 },
    { IMAGE_GATHER4_C_B_CL_O_V4_V8, 963 },
    { IMAGE_GATHER4_C_B_CL_O_V4_V8_gfx10, 936 },
    { IMAGE_GATHER4_C_B_CL_O_V5_V4, 964 },
    { IMAGE_GATHER4_C_B_CL_O_V5_V4_gfx10, 937 },
    { IMAGE_GATHER4_C_B_CL_O_V5_V4_nsa_gfx10, 950 },
    { IMAGE_GATHER4_C_B_CL_O_V5_V5, 965 },
    { IMAGE_GATHER4_C_B_CL_O_V5_V5_gfx10, 938 },
    { IMAGE_GATHER4_C_B_CL_O_V5_V5_nsa_gfx10, 951 },
    { IMAGE_GATHER4_C_B_CL_O_V5_V6, 966 },
    { IMAGE_GATHER4_C_B_CL_O_V5_V6_gfx10, 939 },
    { IMAGE_GATHER4_C_B_CL_O_V5_V6_nsa_gfx10, 952 },
    { IMAGE_GATHER4_C_B_CL_O_V5_V7, 967 },
    { IMAGE_GATHER4_C_B_CL_O_V5_V7_gfx10, 940 },
    { IMAGE_GATHER4_C_B_CL_O_V5_V7_nsa_gfx10, 953 },
    { IMAGE_GATHER4_C_B_CL_O_V5_V8, 968 },
    { IMAGE_GATHER4_C_B_CL_O_V5_V8_gfx10, 941 },
    { IMAGE_GATHER4_C_B_CL_V2_V3, 912 },
    { IMAGE_GATHER4_C_B_CL_V2_V3_gfx10, 885 },
    { IMAGE_GATHER4_C_B_CL_V2_V3_nsa_gfx10, 900 },
    { IMAGE_GATHER4_C_B_CL_V2_V4, 913 },
    { IMAGE_GATHER4_C_B_CL_V2_V4_gfx10, 886 },
    { IMAGE_GATHER4_C_B_CL_V2_V4_nsa_gfx10, 901 },
    { IMAGE_GATHER4_C_B_CL_V2_V5, 914 },
    { IMAGE_GATHER4_C_B_CL_V2_V5_gfx10, 887 },
    { IMAGE_GATHER4_C_B_CL_V2_V5_nsa_gfx10, 902 },
    { IMAGE_GATHER4_C_B_CL_V2_V6, 915 },
    { IMAGE_GATHER4_C_B_CL_V2_V6_gfx10, 888 },
    { IMAGE_GATHER4_C_B_CL_V2_V6_nsa_gfx10, 903 },
    { IMAGE_GATHER4_C_B_CL_V2_V8, 916 },
    { IMAGE_GATHER4_C_B_CL_V2_V8_gfx10, 889 },
    { IMAGE_GATHER4_C_B_CL_V4_V3, 917 },
    { IMAGE_GATHER4_C_B_CL_V4_V3_gfx10, 890 },
    { IMAGE_GATHER4_C_B_CL_V4_V3_nsa_gfx10, 904 },
    { IMAGE_GATHER4_C_B_CL_V4_V4, 918 },
    { IMAGE_GATHER4_C_B_CL_V4_V4_gfx10, 891 },
    { IMAGE_GATHER4_C_B_CL_V4_V4_nsa_gfx10, 905 },
    { IMAGE_GATHER4_C_B_CL_V4_V5, 919 },
    { IMAGE_GATHER4_C_B_CL_V4_V5_gfx10, 892 },
    { IMAGE_GATHER4_C_B_CL_V4_V5_nsa_gfx10, 906 },
    { IMAGE_GATHER4_C_B_CL_V4_V6, 920 },
    { IMAGE_GATHER4_C_B_CL_V4_V6_gfx10, 893 },
    { IMAGE_GATHER4_C_B_CL_V4_V6_nsa_gfx10, 907 },
    { IMAGE_GATHER4_C_B_CL_V4_V8, 921 },
    { IMAGE_GATHER4_C_B_CL_V4_V8_gfx10, 894 },
    { IMAGE_GATHER4_C_B_CL_V5_V3, 922 },
    { IMAGE_GATHER4_C_B_CL_V5_V3_gfx10, 895 },
    { IMAGE_GATHER4_C_B_CL_V5_V3_nsa_gfx10, 908 },
    { IMAGE_GATHER4_C_B_CL_V5_V4, 923 },
    { IMAGE_GATHER4_C_B_CL_V5_V4_gfx10, 896 },
    { IMAGE_GATHER4_C_B_CL_V5_V4_nsa_gfx10, 909 },
    { IMAGE_GATHER4_C_B_CL_V5_V5, 924 },
    { IMAGE_GATHER4_C_B_CL_V5_V5_gfx10, 897 },
    { IMAGE_GATHER4_C_B_CL_V5_V5_nsa_gfx10, 910 },
    { IMAGE_GATHER4_C_B_CL_V5_V6, 925 },
    { IMAGE_GATHER4_C_B_CL_V5_V6_gfx10, 898 },
    { IMAGE_GATHER4_C_B_CL_V5_V6_nsa_gfx10, 911 },
    { IMAGE_GATHER4_C_B_CL_V5_V8, 926 },
    { IMAGE_GATHER4_C_B_CL_V5_V8_gfx10, 899 },
    { IMAGE_GATHER4_C_B_O_V2_V4, 990 },
    { IMAGE_GATHER4_C_B_O_V2_V4_gfx10, 969 },
    { IMAGE_GATHER4_C_B_O_V2_V4_nsa_gfx10, 981 },
    { IMAGE_GATHER4_C_B_O_V2_V5, 991 },
    { IMAGE_GATHER4_C_B_O_V2_V5_gfx10, 970 },
    { IMAGE_GATHER4_C_B_O_V2_V5_nsa_gfx10, 982 },
    { IMAGE_GATHER4_C_B_O_V2_V6, 992 },
    { IMAGE_GATHER4_C_B_O_V2_V6_gfx10, 971 },
    { IMAGE_GATHER4_C_B_O_V2_V6_nsa_gfx10, 983 },
    { IMAGE_GATHER4_C_B_O_V2_V8, 993 },
    { IMAGE_GATHER4_C_B_O_V2_V8_gfx10, 972 },
    { IMAGE_GATHER4_C_B_O_V4_V4, 994 },
    { IMAGE_GATHER4_C_B_O_V4_V4_gfx10, 973 },
    { IMAGE_GATHER4_C_B_O_V4_V4_nsa_gfx10, 984 },
    { IMAGE_GATHER4_C_B_O_V4_V5, 995 },
    { IMAGE_GATHER4_C_B_O_V4_V5_gfx10, 974 },
    { IMAGE_GATHER4_C_B_O_V4_V5_nsa_gfx10, 985 },
    { IMAGE_GATHER4_C_B_O_V4_V6, 996 },
    { IMAGE_GATHER4_C_B_O_V4_V6_gfx10, 975 },
    { IMAGE_GATHER4_C_B_O_V4_V6_nsa_gfx10, 986 },
    { IMAGE_GATHER4_C_B_O_V4_V8, 997 },
    { IMAGE_GATHER4_C_B_O_V4_V8_gfx10, 976 },
    { IMAGE_GATHER4_C_B_O_V5_V4, 998 },
    { IMAGE_GATHER4_C_B_O_V5_V4_gfx10, 977 },
    { IMAGE_GATHER4_C_B_O_V5_V4_nsa_gfx10, 987 },
    { IMAGE_GATHER4_C_B_O_V5_V5, 999 },
    { IMAGE_GATHER4_C_B_O_V5_V5_gfx10, 978 },
    { IMAGE_GATHER4_C_B_O_V5_V5_nsa_gfx10, 988 },
    { IMAGE_GATHER4_C_B_O_V5_V6, 1000 },
    { IMAGE_GATHER4_C_B_O_V5_V6_gfx10, 979 },
    { IMAGE_GATHER4_C_B_O_V5_V6_nsa_gfx10, 989 },
    { IMAGE_GATHER4_C_B_O_V5_V8, 1001 },
    { IMAGE_GATHER4_C_B_O_V5_V8_gfx10, 980 },
    { IMAGE_GATHER4_C_B_V2_V3, 873 },
    { IMAGE_GATHER4_C_B_V2_V3_gfx10, 852 },
    { IMAGE_GATHER4_C_B_V2_V3_nsa_gfx10, 864 },
    { IMAGE_GATHER4_C_B_V2_V4, 874 },
    { IMAGE_GATHER4_C_B_V2_V4_gfx10, 853 },
    { IMAGE_GATHER4_C_B_V2_V4_nsa_gfx10, 865 },
    { IMAGE_GATHER4_C_B_V2_V5, 875 },
    { IMAGE_GATHER4_C_B_V2_V5_gfx10, 854 },
    { IMAGE_GATHER4_C_B_V2_V5_nsa_gfx10, 866 },
    { IMAGE_GATHER4_C_B_V2_V8, 876 },
    { IMAGE_GATHER4_C_B_V2_V8_gfx10, 855 },
    { IMAGE_GATHER4_C_B_V4_V3, 877 },
    { IMAGE_GATHER4_C_B_V4_V3_gfx10, 856 },
    { IMAGE_GATHER4_C_B_V4_V3_nsa_gfx10, 867 },
    { IMAGE_GATHER4_C_B_V4_V4, 878 },
    { IMAGE_GATHER4_C_B_V4_V4_gfx10, 857 },
    { IMAGE_GATHER4_C_B_V4_V4_nsa_gfx10, 868 },
    { IMAGE_GATHER4_C_B_V4_V5, 879 },
    { IMAGE_GATHER4_C_B_V4_V5_gfx10, 858 },
    { IMAGE_GATHER4_C_B_V4_V5_nsa_gfx10, 869 },
    { IMAGE_GATHER4_C_B_V4_V8, 880 },
    { IMAGE_GATHER4_C_B_V4_V8_gfx10, 859 },
    { IMAGE_GATHER4_C_B_V5_V3, 881 },
    { IMAGE_GATHER4_C_B_V5_V3_gfx10, 860 },
    { IMAGE_GATHER4_C_B_V5_V3_nsa_gfx10, 870 },
    { IMAGE_GATHER4_C_B_V5_V4, 882 },
    { IMAGE_GATHER4_C_B_V5_V4_gfx10, 861 },
    { IMAGE_GATHER4_C_B_V5_V4_nsa_gfx10, 871 },
    { IMAGE_GATHER4_C_B_V5_V5, 883 },
    { IMAGE_GATHER4_C_B_V5_V5_gfx10, 862 },
    { IMAGE_GATHER4_C_B_V5_V5_nsa_gfx10, 872 },
    { IMAGE_GATHER4_C_B_V5_V8, 884 },
    { IMAGE_GATHER4_C_B_V5_V8_gfx10, 863 },
    { IMAGE_GATHER4_C_CL_O_V2_V3, 1071 },
    { IMAGE_GATHER4_C_CL_O_V2_V3_gfx10, 1044 },
    { IMAGE_GATHER4_C_CL_O_V2_V3_nsa_gfx10, 1059 },
    { IMAGE_GATHER4_C_CL_O_V2_V4, 1072 },
    { IMAGE_GATHER4_C_CL_O_V2_V4_gfx10, 1045 },
    { IMAGE_GATHER4_C_CL_O_V2_V4_nsa_gfx10, 1060 },
    { IMAGE_GATHER4_C_CL_O_V2_V5, 1073 },
    { IMAGE_GATHER4_C_CL_O_V2_V5_gfx10, 1046 },
    { IMAGE_GATHER4_C_CL_O_V2_V5_nsa_gfx10, 1061 },
    { IMAGE_GATHER4_C_CL_O_V2_V6, 1074 },
    { IMAGE_GATHER4_C_CL_O_V2_V6_gfx10, 1047 },
    { IMAGE_GATHER4_C_CL_O_V2_V6_nsa_gfx10, 1062 },
    { IMAGE_GATHER4_C_CL_O_V2_V8, 1075 },
    { IMAGE_GATHER4_C_CL_O_V2_V8_gfx10, 1048 },
    { IMAGE_GATHER4_C_CL_O_V4_V3, 1076 },
    { IMAGE_GATHER4_C_CL_O_V4_V3_gfx10, 1049 },
    { IMAGE_GATHER4_C_CL_O_V4_V3_nsa_gfx10, 1063 },
    { IMAGE_GATHER4_C_CL_O_V4_V4, 1077 },
    { IMAGE_GATHER4_C_CL_O_V4_V4_gfx10, 1050 },
    { IMAGE_GATHER4_C_CL_O_V4_V4_nsa_gfx10, 1064 },
    { IMAGE_GATHER4_C_CL_O_V4_V5, 1078 },
    { IMAGE_GATHER4_C_CL_O_V4_V5_gfx10, 1051 },
    { IMAGE_GATHER4_C_CL_O_V4_V5_nsa_gfx10, 1065 },
    { IMAGE_GATHER4_C_CL_O_V4_V6, 1079 },
    { IMAGE_GATHER4_C_CL_O_V4_V6_gfx10, 1052 },
    { IMAGE_GATHER4_C_CL_O_V4_V6_nsa_gfx10, 1066 },
    { IMAGE_GATHER4_C_CL_O_V4_V8, 1080 },
    { IMAGE_GATHER4_C_CL_O_V4_V8_gfx10, 1053 },
    { IMAGE_GATHER4_C_CL_O_V5_V3, 1081 },
    { IMAGE_GATHER4_C_CL_O_V5_V3_gfx10, 1054 },
    { IMAGE_GATHER4_C_CL_O_V5_V3_nsa_gfx10, 1067 },
    { IMAGE_GATHER4_C_CL_O_V5_V4, 1082 },
    { IMAGE_GATHER4_C_CL_O_V5_V4_gfx10, 1055 },
    { IMAGE_GATHER4_C_CL_O_V5_V4_nsa_gfx10, 1068 },
    { IMAGE_GATHER4_C_CL_O_V5_V5, 1083 },
    { IMAGE_GATHER4_C_CL_O_V5_V5_gfx10, 1056 },
    { IMAGE_GATHER4_C_CL_O_V5_V5_nsa_gfx10, 1069 },
    { IMAGE_GATHER4_C_CL_O_V5_V6, 1084 },
    { IMAGE_GATHER4_C_CL_O_V5_V6_gfx10, 1057 },
    { IMAGE_GATHER4_C_CL_O_V5_V6_nsa_gfx10, 1070 },
    { IMAGE_GATHER4_C_CL_O_V5_V8, 1085 },
    { IMAGE_GATHER4_C_CL_O_V5_V8_gfx10, 1058 },
    { IMAGE_GATHER4_C_CL_V2_V2, 1029 },
    { IMAGE_GATHER4_C_CL_V2_V2_gfx10, 1002 },
    { IMAGE_GATHER4_C_CL_V2_V2_nsa_gfx10, 1017 },
    { IMAGE_GATHER4_C_CL_V2_V3, 1030 },
    { IMAGE_GATHER4_C_CL_V2_V3_gfx10, 1003 },
    { IMAGE_GATHER4_C_CL_V2_V3_nsa_gfx10, 1018 },
    { IMAGE_GATHER4_C_CL_V2_V4, 1031 },
    { IMAGE_GATHER4_C_CL_V2_V4_gfx10, 1004 },
    { IMAGE_GATHER4_C_CL_V2_V4_nsa_gfx10, 1019 },
    { IMAGE_GATHER4_C_CL_V2_V5, 1032 },
    { IMAGE_GATHER4_C_CL_V2_V5_gfx10, 1005 },
    { IMAGE_GATHER4_C_CL_V2_V5_nsa_gfx10, 1020 },
    { IMAGE_GATHER4_C_CL_V2_V8, 1033 },
    { IMAGE_GATHER4_C_CL_V2_V8_gfx10, 1006 },
    { IMAGE_GATHER4_C_CL_V4_V2, 1034 },
    { IMAGE_GATHER4_C_CL_V4_V2_gfx10, 1007 },
    { IMAGE_GATHER4_C_CL_V4_V2_nsa_gfx10, 1021 },
    { IMAGE_GATHER4_C_CL_V4_V3, 1035 },
    { IMAGE_GATHER4_C_CL_V4_V3_gfx10, 1008 },
    { IMAGE_GATHER4_C_CL_V4_V3_nsa_gfx10, 1022 },
    { IMAGE_GATHER4_C_CL_V4_V4, 1036 },
    { IMAGE_GATHER4_C_CL_V4_V4_gfx10, 1009 },
    { IMAGE_GATHER4_C_CL_V4_V4_nsa_gfx10, 1023 },
    { IMAGE_GATHER4_C_CL_V4_V5, 1037 },
    { IMAGE_GATHER4_C_CL_V4_V5_gfx10, 1010 },
    { IMAGE_GATHER4_C_CL_V4_V5_nsa_gfx10, 1024 },
    { IMAGE_GATHER4_C_CL_V4_V8, 1038 },
    { IMAGE_GATHER4_C_CL_V4_V8_gfx10, 1011 },
    { IMAGE_GATHER4_C_CL_V5_V2, 1039 },
    { IMAGE_GATHER4_C_CL_V5_V2_gfx10, 1012 },
    { IMAGE_GATHER4_C_CL_V5_V2_nsa_gfx10, 1025 },
    { IMAGE_GATHER4_C_CL_V5_V3, 1040 },
    { IMAGE_GATHER4_C_CL_V5_V3_gfx10, 1013 },
    { IMAGE_GATHER4_C_CL_V5_V3_nsa_gfx10, 1026 },
    { IMAGE_GATHER4_C_CL_V5_V4, 1041 },
    { IMAGE_GATHER4_C_CL_V5_V4_gfx10, 1014 },
    { IMAGE_GATHER4_C_CL_V5_V4_nsa_gfx10, 1027 },
    { IMAGE_GATHER4_C_CL_V5_V5, 1042 },
    { IMAGE_GATHER4_C_CL_V5_V5_gfx10, 1015 },
    { IMAGE_GATHER4_C_CL_V5_V5_nsa_gfx10, 1028 },
    { IMAGE_GATHER4_C_CL_V5_V8, 1043 },
    { IMAGE_GATHER4_C_CL_V5_V8_gfx10, 1016 },
    { IMAGE_GATHER4_C_LZ_O_V2_V3, 1176 },
    { IMAGE_GATHER4_C_LZ_O_V2_V3_gfx10, 1155 },
    { IMAGE_GATHER4_C_LZ_O_V2_V3_nsa_gfx10, 1167 },
    { IMAGE_GATHER4_C_LZ_O_V2_V4, 1177 },
    { IMAGE_GATHER4_C_LZ_O_V2_V4_gfx10, 1156 },
    { IMAGE_GATHER4_C_LZ_O_V2_V4_nsa_gfx10, 1168 },
    { IMAGE_GATHER4_C_LZ_O_V2_V5, 1178 },
    { IMAGE_GATHER4_C_LZ_O_V2_V5_gfx10, 1157 },
    { IMAGE_GATHER4_C_LZ_O_V2_V5_nsa_gfx10, 1169 },
    { IMAGE_GATHER4_C_LZ_O_V2_V8, 1179 },
    { IMAGE_GATHER4_C_LZ_O_V2_V8_gfx10, 1158 },
    { IMAGE_GATHER4_C_LZ_O_V4_V3, 1180 },
    { IMAGE_GATHER4_C_LZ_O_V4_V3_gfx10, 1159 },
    { IMAGE_GATHER4_C_LZ_O_V4_V3_nsa_gfx10, 1170 },
    { IMAGE_GATHER4_C_LZ_O_V4_V4, 1181 },
    { IMAGE_GATHER4_C_LZ_O_V4_V4_gfx10, 1160 },
    { IMAGE_GATHER4_C_LZ_O_V4_V4_nsa_gfx10, 1171 },
    { IMAGE_GATHER4_C_LZ_O_V4_V5, 1182 },
    { IMAGE_GATHER4_C_LZ_O_V4_V5_gfx10, 1161 },
    { IMAGE_GATHER4_C_LZ_O_V4_V5_nsa_gfx10, 1172 },
    { IMAGE_GATHER4_C_LZ_O_V4_V8, 1183 },
    { IMAGE_GATHER4_C_LZ_O_V4_V8_gfx10, 1162 },
    { IMAGE_GATHER4_C_LZ_O_V5_V3, 1184 },
    { IMAGE_GATHER4_C_LZ_O_V5_V3_gfx10, 1163 },
    { IMAGE_GATHER4_C_LZ_O_V5_V3_nsa_gfx10, 1173 },
    { IMAGE_GATHER4_C_LZ_O_V5_V4, 1185 },
    { IMAGE_GATHER4_C_LZ_O_V5_V4_gfx10, 1164 },
    { IMAGE_GATHER4_C_LZ_O_V5_V4_nsa_gfx10, 1174 },
    { IMAGE_GATHER4_C_LZ_O_V5_V5, 1186 },
    { IMAGE_GATHER4_C_LZ_O_V5_V5_gfx10, 1165 },
    { IMAGE_GATHER4_C_LZ_O_V5_V5_nsa_gfx10, 1175 },
    { IMAGE_GATHER4_C_LZ_O_V5_V8, 1187 },
    { IMAGE_GATHER4_C_LZ_O_V5_V8_gfx10, 1166 },
    { IMAGE_GATHER4_C_LZ_V2_V2, 1146 },
    { IMAGE_GATHER4_C_LZ_V2_V2_gfx10, 1128 },
    { IMAGE_GATHER4_C_LZ_V2_V2_nsa_gfx10, 1137 },
    { IMAGE_GATHER4_C_LZ_V2_V3, 1147 },
    { IMAGE_GATHER4_C_LZ_V2_V3_gfx10, 1129 },
    { IMAGE_GATHER4_C_LZ_V2_V3_nsa_gfx10, 1138 },
    { IMAGE_GATHER4_C_LZ_V2_V4, 1148 },
    { IMAGE_GATHER4_C_LZ_V2_V4_gfx10, 1130 },
    { IMAGE_GATHER4_C_LZ_V2_V4_nsa_gfx10, 1139 },
    { IMAGE_GATHER4_C_LZ_V4_V2, 1149 },
    { IMAGE_GATHER4_C_LZ_V4_V2_gfx10, 1131 },
    { IMAGE_GATHER4_C_LZ_V4_V2_nsa_gfx10, 1140 },
    { IMAGE_GATHER4_C_LZ_V4_V3, 1150 },
    { IMAGE_GATHER4_C_LZ_V4_V3_gfx10, 1132 },
    { IMAGE_GATHER4_C_LZ_V4_V3_nsa_gfx10, 1141 },
    { IMAGE_GATHER4_C_LZ_V4_V4, 1151 },
    { IMAGE_GATHER4_C_LZ_V4_V4_gfx10, 1133 },
    { IMAGE_GATHER4_C_LZ_V4_V4_nsa_gfx10, 1142 },
    { IMAGE_GATHER4_C_LZ_V5_V2, 1152 },
    { IMAGE_GATHER4_C_LZ_V5_V2_gfx10, 1134 },
    { IMAGE_GATHER4_C_LZ_V5_V2_nsa_gfx10, 1143 },
    { IMAGE_GATHER4_C_LZ_V5_V3, 1153 },
    { IMAGE_GATHER4_C_LZ_V5_V3_gfx10, 1135 },
    { IMAGE_GATHER4_C_LZ_V5_V3_nsa_gfx10, 1144 },
    { IMAGE_GATHER4_C_LZ_V5_V4, 1154 },
    { IMAGE_GATHER4_C_LZ_V5_V4_gfx10, 1136 },
    { IMAGE_GATHER4_C_LZ_V5_V4_nsa_gfx10, 1145 },
    { IMAGE_GATHER4_C_L_O_V2_V3, 1215 },
    { IMAGE_GATHER4_C_L_O_V2_V3_gfx10, 1188 },
    { IMAGE_GATHER4_C_L_O_V2_V3_nsa_gfx10, 1203 },
    { IMAGE_GATHER4_C_L_O_V2_V4, 1216 },
    { IMAGE_GATHER4_C_L_O_V2_V4_gfx10, 1189 },
    { IMAGE_GATHER4_C_L_O_V2_V4_nsa_gfx10, 1204 },
    { IMAGE_GATHER4_C_L_O_V2_V5, 1217 },
    { IMAGE_GATHER4_C_L_O_V2_V5_gfx10, 1190 },
    { IMAGE_GATHER4_C_L_O_V2_V5_nsa_gfx10, 1205 },
    { IMAGE_GATHER4_C_L_O_V2_V6, 1218 },
    { IMAGE_GATHER4_C_L_O_V2_V6_gfx10, 1191 },
    { IMAGE_GATHER4_C_L_O_V2_V6_nsa_gfx10, 1206 },
    { IMAGE_GATHER4_C_L_O_V2_V8, 1219 },
    { IMAGE_GATHER4_C_L_O_V2_V8_gfx10, 1192 },
    { IMAGE_GATHER4_C_L_O_V4_V3, 1220 },
    { IMAGE_GATHER4_C_L_O_V4_V3_gfx10, 1193 },
    { IMAGE_GATHER4_C_L_O_V4_V3_nsa_gfx10, 1207 },
    { IMAGE_GATHER4_C_L_O_V4_V4, 1221 },
    { IMAGE_GATHER4_C_L_O_V4_V4_gfx10, 1194 },
    { IMAGE_GATHER4_C_L_O_V4_V4_nsa_gfx10, 1208 },
    { IMAGE_GATHER4_C_L_O_V4_V5, 1222 },
    { IMAGE_GATHER4_C_L_O_V4_V5_gfx10, 1195 },
    { IMAGE_GATHER4_C_L_O_V4_V5_nsa_gfx10, 1209 },
    { IMAGE_GATHER4_C_L_O_V4_V6, 1223 },
    { IMAGE_GATHER4_C_L_O_V4_V6_gfx10, 1196 },
    { IMAGE_GATHER4_C_L_O_V4_V6_nsa_gfx10, 1210 },
    { IMAGE_GATHER4_C_L_O_V4_V8, 1224 },
    { IMAGE_GATHER4_C_L_O_V4_V8_gfx10, 1197 },
    { IMAGE_GATHER4_C_L_O_V5_V3, 1225 },
    { IMAGE_GATHER4_C_L_O_V5_V3_gfx10, 1198 },
    { IMAGE_GATHER4_C_L_O_V5_V3_nsa_gfx10, 1211 },
    { IMAGE_GATHER4_C_L_O_V5_V4, 1226 },
    { IMAGE_GATHER4_C_L_O_V5_V4_gfx10, 1199 },
    { IMAGE_GATHER4_C_L_O_V5_V4_nsa_gfx10, 1212 },
    { IMAGE_GATHER4_C_L_O_V5_V5, 1227 },
    { IMAGE_GATHER4_C_L_O_V5_V5_gfx10, 1200 },
    { IMAGE_GATHER4_C_L_O_V5_V5_nsa_gfx10, 1213 },
    { IMAGE_GATHER4_C_L_O_V5_V6, 1228 },
    { IMAGE_GATHER4_C_L_O_V5_V6_gfx10, 1201 },
    { IMAGE_GATHER4_C_L_O_V5_V6_nsa_gfx10, 1214 },
    { IMAGE_GATHER4_C_L_O_V5_V8, 1229 },
    { IMAGE_GATHER4_C_L_O_V5_V8_gfx10, 1202 },
    { IMAGE_GATHER4_C_L_V2_V2, 1113 },
    { IMAGE_GATHER4_C_L_V2_V2_gfx10, 1086 },
    { IMAGE_GATHER4_C_L_V2_V2_nsa_gfx10, 1101 },
    { IMAGE_GATHER4_C_L_V2_V3, 1114 },
    { IMAGE_GATHER4_C_L_V2_V3_gfx10, 1087 },
    { IMAGE_GATHER4_C_L_V2_V3_nsa_gfx10, 1102 },
    { IMAGE_GATHER4_C_L_V2_V4, 1115 },
    { IMAGE_GATHER4_C_L_V2_V4_gfx10, 1088 },
    { IMAGE_GATHER4_C_L_V2_V4_nsa_gfx10, 1103 },
    { IMAGE_GATHER4_C_L_V2_V5, 1116 },
    { IMAGE_GATHER4_C_L_V2_V5_gfx10, 1089 },
    { IMAGE_GATHER4_C_L_V2_V5_nsa_gfx10, 1104 },
    { IMAGE_GATHER4_C_L_V2_V8, 1117 },
    { IMAGE_GATHER4_C_L_V2_V8_gfx10, 1090 },
    { IMAGE_GATHER4_C_L_V4_V2, 1118 },
    { IMAGE_GATHER4_C_L_V4_V2_gfx10, 1091 },
    { IMAGE_GATHER4_C_L_V4_V2_nsa_gfx10, 1105 },
    { IMAGE_GATHER4_C_L_V4_V3, 1119 },
    { IMAGE_GATHER4_C_L_V4_V3_gfx10, 1092 },
    { IMAGE_GATHER4_C_L_V4_V3_nsa_gfx10, 1106 },
    { IMAGE_GATHER4_C_L_V4_V4, 1120 },
    { IMAGE_GATHER4_C_L_V4_V4_gfx10, 1093 },
    { IMAGE_GATHER4_C_L_V4_V4_nsa_gfx10, 1107 },
    { IMAGE_GATHER4_C_L_V4_V5, 1121 },
    { IMAGE_GATHER4_C_L_V4_V5_gfx10, 1094 },
    { IMAGE_GATHER4_C_L_V4_V5_nsa_gfx10, 1108 },
    { IMAGE_GATHER4_C_L_V4_V8, 1122 },
    { IMAGE_GATHER4_C_L_V4_V8_gfx10, 1095 },
    { IMAGE_GATHER4_C_L_V5_V2, 1123 },
    { IMAGE_GATHER4_C_L_V5_V2_gfx10, 1096 },
    { IMAGE_GATHER4_C_L_V5_V2_nsa_gfx10, 1109 },
    { IMAGE_GATHER4_C_L_V5_V3, 1124 },
    { IMAGE_GATHER4_C_L_V5_V3_gfx10, 1097 },
    { IMAGE_GATHER4_C_L_V5_V3_nsa_gfx10, 1110 },
    { IMAGE_GATHER4_C_L_V5_V4, 1125 },
    { IMAGE_GATHER4_C_L_V5_V4_gfx10, 1098 },
    { IMAGE_GATHER4_C_L_V5_V4_nsa_gfx10, 1111 },
    { IMAGE_GATHER4_C_L_V5_V5, 1126 },
    { IMAGE_GATHER4_C_L_V5_V5_gfx10, 1099 },
    { IMAGE_GATHER4_C_L_V5_V5_nsa_gfx10, 1112 },
    { IMAGE_GATHER4_C_L_V5_V8, 1127 },
    { IMAGE_GATHER4_C_L_V5_V8_gfx10, 1100 },
    { IMAGE_GATHER4_C_O_V2_V3, 1251 },
    { IMAGE_GATHER4_C_O_V2_V3_gfx10, 1230 },
    { IMAGE_GATHER4_C_O_V2_V3_nsa_gfx10, 1242 },
    { IMAGE_GATHER4_C_O_V2_V4, 1252 },
    { IMAGE_GATHER4_C_O_V2_V4_gfx10, 1231 },
    { IMAGE_GATHER4_C_O_V2_V4_nsa_gfx10, 1243 },
    { IMAGE_GATHER4_C_O_V2_V5, 1253 },
    { IMAGE_GATHER4_C_O_V2_V5_gfx10, 1232 },
    { IMAGE_GATHER4_C_O_V2_V5_nsa_gfx10, 1244 },
    { IMAGE_GATHER4_C_O_V2_V8, 1254 },
    { IMAGE_GATHER4_C_O_V2_V8_gfx10, 1233 },
    { IMAGE_GATHER4_C_O_V4_V3, 1255 },
    { IMAGE_GATHER4_C_O_V4_V3_gfx10, 1234 },
    { IMAGE_GATHER4_C_O_V4_V3_nsa_gfx10, 1245 },
    { IMAGE_GATHER4_C_O_V4_V4, 1256 },
    { IMAGE_GATHER4_C_O_V4_V4_gfx10, 1235 },
    { IMAGE_GATHER4_C_O_V4_V4_nsa_gfx10, 1246 },
    { IMAGE_GATHER4_C_O_V4_V5, 1257 },
    { IMAGE_GATHER4_C_O_V4_V5_gfx10, 1236 },
    { IMAGE_GATHER4_C_O_V4_V5_nsa_gfx10, 1247 },
    { IMAGE_GATHER4_C_O_V4_V8, 1258 },
    { IMAGE_GATHER4_C_O_V4_V8_gfx10, 1237 },
    { IMAGE_GATHER4_C_O_V5_V3, 1259 },
    { IMAGE_GATHER4_C_O_V5_V3_gfx10, 1238 },
    { IMAGE_GATHER4_C_O_V5_V3_nsa_gfx10, 1248 },
    { IMAGE_GATHER4_C_O_V5_V4, 1260 },
    { IMAGE_GATHER4_C_O_V5_V4_gfx10, 1239 },
    { IMAGE_GATHER4_C_O_V5_V4_nsa_gfx10, 1249 },
    { IMAGE_GATHER4_C_O_V5_V5, 1261 },
    { IMAGE_GATHER4_C_O_V5_V5_gfx10, 1240 },
    { IMAGE_GATHER4_C_O_V5_V5_nsa_gfx10, 1250 },
    { IMAGE_GATHER4_C_O_V5_V8, 1262 },
    { IMAGE_GATHER4_C_O_V5_V8_gfx10, 1241 },
    { IMAGE_GATHER4_C_V2_V2, 768 },
    { IMAGE_GATHER4_C_V2_V2_gfx10, 750 },
    { IMAGE_GATHER4_C_V2_V2_nsa_gfx10, 759 },
    { IMAGE_GATHER4_C_V2_V3, 769 },
    { IMAGE_GATHER4_C_V2_V3_gfx10, 751 },
    { IMAGE_GATHER4_C_V2_V3_nsa_gfx10, 760 },
    { IMAGE_GATHER4_C_V2_V4, 770 },
    { IMAGE_GATHER4_C_V2_V4_gfx10, 752 },
    { IMAGE_GATHER4_C_V2_V4_nsa_gfx10, 761 },
    { IMAGE_GATHER4_C_V4_V2, 771 },
    { IMAGE_GATHER4_C_V4_V2_gfx10, 753 },
    { IMAGE_GATHER4_C_V4_V2_nsa_gfx10, 762 },
    { IMAGE_GATHER4_C_V4_V3, 772 },
    { IMAGE_GATHER4_C_V4_V3_gfx10, 754 },
    { IMAGE_GATHER4_C_V4_V3_nsa_gfx10, 763 },
    { IMAGE_GATHER4_C_V4_V4, 773 },
    { IMAGE_GATHER4_C_V4_V4_gfx10, 755 },
    { IMAGE_GATHER4_C_V4_V4_nsa_gfx10, 764 },
    { IMAGE_GATHER4_C_V5_V2, 774 },
    { IMAGE_GATHER4_C_V5_V2_gfx10, 756 },
    { IMAGE_GATHER4_C_V5_V2_nsa_gfx10, 765 },
    { IMAGE_GATHER4_C_V5_V3, 775 },
    { IMAGE_GATHER4_C_V5_V3_gfx10, 757 },
    { IMAGE_GATHER4_C_V5_V3_nsa_gfx10, 766 },
    { IMAGE_GATHER4_C_V5_V4, 776 },
    { IMAGE_GATHER4_C_V5_V4_gfx10, 758 },
    { IMAGE_GATHER4_C_V5_V4_nsa_gfx10, 767 },
    { IMAGE_GATHER4_LZ_O_V2_V2, 1344 },
    { IMAGE_GATHER4_LZ_O_V2_V2_gfx10, 1326 },
    { IMAGE_GATHER4_LZ_O_V2_V2_nsa_gfx10, 1335 },
    { IMAGE_GATHER4_LZ_O_V2_V3, 1345 },
    { IMAGE_GATHER4_LZ_O_V2_V3_gfx10, 1327 },
    { IMAGE_GATHER4_LZ_O_V2_V3_nsa_gfx10, 1336 },
    { IMAGE_GATHER4_LZ_O_V2_V4, 1346 },
    { IMAGE_GATHER4_LZ_O_V2_V4_gfx10, 1328 },
    { IMAGE_GATHER4_LZ_O_V2_V4_nsa_gfx10, 1337 },
    { IMAGE_GATHER4_LZ_O_V4_V2, 1347 },
    { IMAGE_GATHER4_LZ_O_V4_V2_gfx10, 1329 },
    { IMAGE_GATHER4_LZ_O_V4_V2_nsa_gfx10, 1338 },
    { IMAGE_GATHER4_LZ_O_V4_V3, 1348 },
    { IMAGE_GATHER4_LZ_O_V4_V3_gfx10, 1330 },
    { IMAGE_GATHER4_LZ_O_V4_V3_nsa_gfx10, 1339 },
    { IMAGE_GATHER4_LZ_O_V4_V4, 1349 },
    { IMAGE_GATHER4_LZ_O_V4_V4_gfx10, 1331 },
    { IMAGE_GATHER4_LZ_O_V4_V4_nsa_gfx10, 1340 },
    { IMAGE_GATHER4_LZ_O_V5_V2, 1350 },
    { IMAGE_GATHER4_LZ_O_V5_V2_gfx10, 1332 },
    { IMAGE_GATHER4_LZ_O_V5_V2_nsa_gfx10, 1341 },
    { IMAGE_GATHER4_LZ_O_V5_V3, 1351 },
    { IMAGE_GATHER4_LZ_O_V5_V3_gfx10, 1333 },
    { IMAGE_GATHER4_LZ_O_V5_V3_nsa_gfx10, 1342 },
    { IMAGE_GATHER4_LZ_O_V5_V4, 1352 },
    { IMAGE_GATHER4_LZ_O_V5_V4_gfx10, 1334 },
    { IMAGE_GATHER4_LZ_O_V5_V4_nsa_gfx10, 1343 },
    { IMAGE_GATHER4_LZ_V2_V1, 1314 },
    { IMAGE_GATHER4_LZ_V2_V1_gfx10, 1296 },
    { IMAGE_GATHER4_LZ_V2_V2, 1315 },
    { IMAGE_GATHER4_LZ_V2_V2_gfx10, 1297 },
    { IMAGE_GATHER4_LZ_V2_V2_nsa_gfx10, 1308 },
    { IMAGE_GATHER4_LZ_V2_V3, 1316 },
    { IMAGE_GATHER4_LZ_V2_V3_gfx10, 1298 },
    { IMAGE_GATHER4_LZ_V2_V3_nsa_gfx10, 1309 },
    { IMAGE_GATHER4_LZ_V2_V4, 1317 },
    { IMAGE_GATHER4_LZ_V2_V4_gfx10, 1299 },
    { IMAGE_GATHER4_LZ_V4_V1, 1318 },
    { IMAGE_GATHER4_LZ_V4_V1_gfx10, 1300 },
    { IMAGE_GATHER4_LZ_V4_V2, 1319 },
    { IMAGE_GATHER4_LZ_V4_V2_gfx10, 1301 },
    { IMAGE_GATHER4_LZ_V4_V2_nsa_gfx10, 1310 },
    { IMAGE_GATHER4_LZ_V4_V3, 1320 },
    { IMAGE_GATHER4_LZ_V4_V3_gfx10, 1302 },
    { IMAGE_GATHER4_LZ_V4_V3_nsa_gfx10, 1311 },
    { IMAGE_GATHER4_LZ_V4_V4, 1321 },
    { IMAGE_GATHER4_LZ_V4_V4_gfx10, 1303 },
    { IMAGE_GATHER4_LZ_V5_V1, 1322 },
    { IMAGE_GATHER4_LZ_V5_V1_gfx10, 1304 },
    { IMAGE_GATHER4_LZ_V5_V2, 1323 },
    { IMAGE_GATHER4_LZ_V5_V2_gfx10, 1305 },
    { IMAGE_GATHER4_LZ_V5_V2_nsa_gfx10, 1312 },
    { IMAGE_GATHER4_LZ_V5_V3, 1324 },
    { IMAGE_GATHER4_LZ_V5_V3_gfx10, 1306 },
    { IMAGE_GATHER4_LZ_V5_V3_nsa_gfx10, 1313 },
    { IMAGE_GATHER4_LZ_V5_V4, 1325 },
    { IMAGE_GATHER4_LZ_V5_V4_gfx10, 1307 },
    { IMAGE_GATHER4_L_O_V2_V2, 1380 },
    { IMAGE_GATHER4_L_O_V2_V2_gfx10, 1353 },
    { IMAGE_GATHER4_L_O_V2_V2_nsa_gfx10, 1368 },
    { IMAGE_GATHER4_L_O_V2_V3, 1381 },
    { IMAGE_GATHER4_L_O_V2_V3_gfx10, 1354 },
    { IMAGE_GATHER4_L_O_V2_V3_nsa_gfx10, 1369 },
    { IMAGE_GATHER4_L_O_V2_V4, 1382 },
    { IMAGE_GATHER4_L_O_V2_V4_gfx10, 1355 },
    { IMAGE_GATHER4_L_O_V2_V4_nsa_gfx10, 1370 },
    { IMAGE_GATHER4_L_O_V2_V5, 1383 },
    { IMAGE_GATHER4_L_O_V2_V5_gfx10, 1356 },
    { IMAGE_GATHER4_L_O_V2_V5_nsa_gfx10, 1371 },
    { IMAGE_GATHER4_L_O_V2_V8, 1384 },
    { IMAGE_GATHER4_L_O_V2_V8_gfx10, 1357 },
    { IMAGE_GATHER4_L_O_V4_V2, 1385 },
    { IMAGE_GATHER4_L_O_V4_V2_gfx10, 1358 },
    { IMAGE_GATHER4_L_O_V4_V2_nsa_gfx10, 1372 },
    { IMAGE_GATHER4_L_O_V4_V3, 1386 },
    { IMAGE_GATHER4_L_O_V4_V3_gfx10, 1359 },
    { IMAGE_GATHER4_L_O_V4_V3_nsa_gfx10, 1373 },
    { IMAGE_GATHER4_L_O_V4_V4, 1387 },
    { IMAGE_GATHER4_L_O_V4_V4_gfx10, 1360 },
    { IMAGE_GATHER4_L_O_V4_V4_nsa_gfx10, 1374 },
    { IMAGE_GATHER4_L_O_V4_V5, 1388 },
    { IMAGE_GATHER4_L_O_V4_V5_gfx10, 1361 },
    { IMAGE_GATHER4_L_O_V4_V5_nsa_gfx10, 1375 },
    { IMAGE_GATHER4_L_O_V4_V8, 1389 },
    { IMAGE_GATHER4_L_O_V4_V8_gfx10, 1362 },
    { IMAGE_GATHER4_L_O_V5_V2, 1390 },
    { IMAGE_GATHER4_L_O_V5_V2_gfx10, 1363 },
    { IMAGE_GATHER4_L_O_V5_V2_nsa_gfx10, 1376 },
    { IMAGE_GATHER4_L_O_V5_V3, 1391 },
    { IMAGE_GATHER4_L_O_V5_V3_gfx10, 1364 },
    { IMAGE_GATHER4_L_O_V5_V3_nsa_gfx10, 1377 },
    { IMAGE_GATHER4_L_O_V5_V4, 1392 },
    { IMAGE_GATHER4_L_O_V5_V4_gfx10, 1365 },
    { IMAGE_GATHER4_L_O_V5_V4_nsa_gfx10, 1378 },
    { IMAGE_GATHER4_L_O_V5_V5, 1393 },
    { IMAGE_GATHER4_L_O_V5_V5_gfx10, 1366 },
    { IMAGE_GATHER4_L_O_V5_V5_nsa_gfx10, 1379 },
    { IMAGE_GATHER4_L_O_V5_V8, 1394 },
    { IMAGE_GATHER4_L_O_V5_V8_gfx10, 1367 },
    { IMAGE_GATHER4_L_V2_V1, 1284 },
    { IMAGE_GATHER4_L_V2_V1_gfx10, 1263 },
    { IMAGE_GATHER4_L_V2_V2, 1285 },
    { IMAGE_GATHER4_L_V2_V2_gfx10, 1264 },
    { IMAGE_GATHER4_L_V2_V2_nsa_gfx10, 1275 },
    { IMAGE_GATHER4_L_V2_V3, 1286 },
    { IMAGE_GATHER4_L_V2_V3_gfx10, 1265 },
    { IMAGE_GATHER4_L_V2_V3_nsa_gfx10, 1276 },
    { IMAGE_GATHER4_L_V2_V4, 1287 },
    { IMAGE_GATHER4_L_V2_V4_gfx10, 1266 },
    { IMAGE_GATHER4_L_V2_V4_nsa_gfx10, 1277 },
    { IMAGE_GATHER4_L_V4_V1, 1288 },
    { IMAGE_GATHER4_L_V4_V1_gfx10, 1267 },
    { IMAGE_GATHER4_L_V4_V2, 1289 },
    { IMAGE_GATHER4_L_V4_V2_gfx10, 1268 },
    { IMAGE_GATHER4_L_V4_V2_nsa_gfx10, 1278 },
    { IMAGE_GATHER4_L_V4_V3, 1290 },
    { IMAGE_GATHER4_L_V4_V3_gfx10, 1269 },
    { IMAGE_GATHER4_L_V4_V3_nsa_gfx10, 1279 },
    { IMAGE_GATHER4_L_V4_V4, 1291 },
    { IMAGE_GATHER4_L_V4_V4_gfx10, 1270 },
    { IMAGE_GATHER4_L_V4_V4_nsa_gfx10, 1280 },
    { IMAGE_GATHER4_L_V5_V1, 1292 },
    { IMAGE_GATHER4_L_V5_V1_gfx10, 1271 },
    { IMAGE_GATHER4_L_V5_V2, 1293 },
    { IMAGE_GATHER4_L_V5_V2_gfx10, 1272 },
    { IMAGE_GATHER4_L_V5_V2_nsa_gfx10, 1281 },
    { IMAGE_GATHER4_L_V5_V3, 1294 },
    { IMAGE_GATHER4_L_V5_V3_gfx10, 1273 },
    { IMAGE_GATHER4_L_V5_V3_nsa_gfx10, 1282 },
    { IMAGE_GATHER4_L_V5_V4, 1295 },
    { IMAGE_GATHER4_L_V5_V4_gfx10, 1274 },
    { IMAGE_GATHER4_L_V5_V4_nsa_gfx10, 1283 },
    { IMAGE_GATHER4_O_V2_V2, 1413 },
    { IMAGE_GATHER4_O_V2_V2_gfx10, 1395 },
    { IMAGE_GATHER4_O_V2_V2_nsa_gfx10, 1404 },
    { IMAGE_GATHER4_O_V2_V3, 1414 },
    { IMAGE_GATHER4_O_V2_V3_gfx10, 1396 },
    { IMAGE_GATHER4_O_V2_V3_nsa_gfx10, 1405 },
    { IMAGE_GATHER4_O_V2_V4, 1415 },
    { IMAGE_GATHER4_O_V2_V4_gfx10, 1397 },
    { IMAGE_GATHER4_O_V2_V4_nsa_gfx10, 1406 },
    { IMAGE_GATHER4_O_V4_V2, 1416 },
    { IMAGE_GATHER4_O_V4_V2_gfx10, 1398 },
    { IMAGE_GATHER4_O_V4_V2_nsa_gfx10, 1407 },
    { IMAGE_GATHER4_O_V4_V3, 1417 },
    { IMAGE_GATHER4_O_V4_V3_gfx10, 1399 },
    { IMAGE_GATHER4_O_V4_V3_nsa_gfx10, 1408 },
    { IMAGE_GATHER4_O_V4_V4, 1418 },
    { IMAGE_GATHER4_O_V4_V4_gfx10, 1400 },
    { IMAGE_GATHER4_O_V4_V4_nsa_gfx10, 1409 },
    { IMAGE_GATHER4_O_V5_V2, 1419 },
    { IMAGE_GATHER4_O_V5_V2_gfx10, 1401 },
    { IMAGE_GATHER4_O_V5_V2_nsa_gfx10, 1410 },
    { IMAGE_GATHER4_O_V5_V3, 1420 },
    { IMAGE_GATHER4_O_V5_V3_gfx10, 1402 },
    { IMAGE_GATHER4_O_V5_V3_nsa_gfx10, 1411 },
    { IMAGE_GATHER4_O_V5_V4, 1421 },
    { IMAGE_GATHER4_O_V5_V4_gfx10, 1403 },
    { IMAGE_GATHER4_O_V5_V4_nsa_gfx10, 1412 },
    { IMAGE_GATHER4_V2_V1, 594 },
    { IMAGE_GATHER4_V2_V1_gfx10, 576 },
    { IMAGE_GATHER4_V2_V2, 595 },
    { IMAGE_GATHER4_V2_V2_gfx10, 577 },
    { IMAGE_GATHER4_V2_V2_nsa_gfx10, 588 },
    { IMAGE_GATHER4_V2_V3, 596 },
    { IMAGE_GATHER4_V2_V3_gfx10, 578 },
    { IMAGE_GATHER4_V2_V3_nsa_gfx10, 589 },
    { IMAGE_GATHER4_V2_V4, 597 },
    { IMAGE_GATHER4_V2_V4_gfx10, 579 },
    { IMAGE_GATHER4_V4_V1, 598 },
    { IMAGE_GATHER4_V4_V1_gfx10, 580 },
    { IMAGE_GATHER4_V4_V2, 599 },
    { IMAGE_GATHER4_V4_V2_gfx10, 581 },
    { IMAGE_GATHER4_V4_V2_nsa_gfx10, 590 },
    { IMAGE_GATHER4_V4_V3, 600 },
    { IMAGE_GATHER4_V4_V3_gfx10, 582 },
    { IMAGE_GATHER4_V4_V3_nsa_gfx10, 591 },
    { IMAGE_GATHER4_V4_V4, 601 },
    { IMAGE_GATHER4_V4_V4_gfx10, 583 },
    { IMAGE_GATHER4_V5_V1, 602 },
    { IMAGE_GATHER4_V5_V1_gfx10, 584 },
    { IMAGE_GATHER4_V5_V2, 603 },
    { IMAGE_GATHER4_V5_V2_gfx10, 585 },
    { IMAGE_GATHER4_V5_V2_nsa_gfx10, 592 },
    { IMAGE_GATHER4_V5_V3, 604 },
    { IMAGE_GATHER4_V5_V3_gfx10, 586 },
    { IMAGE_GATHER4_V5_V3_nsa_gfx10, 593 },
    { IMAGE_GATHER4_V5_V4, 605 },
    { IMAGE_GATHER4_V5_V4_gfx10, 587 },
    { IMAGE_GET_LOD_V1_V1, 1452 },
    { IMAGE_GET_LOD_V1_V1_gfx10, 1422 },
    { IMAGE_GET_LOD_V1_V1_gfx90a, 1472 },
    { IMAGE_GET_LOD_V1_V2, 1453 },
    { IMAGE_GET_LOD_V1_V2_gfx10, 1423 },
    { IMAGE_GET_LOD_V1_V2_gfx90a, 1473 },
    { IMAGE_GET_LOD_V1_V2_nsa_gfx10, 1442 },
    { IMAGE_GET_LOD_V1_V3, 1454 },
    { IMAGE_GET_LOD_V1_V3_gfx10, 1424 },
    { IMAGE_GET_LOD_V1_V3_gfx90a, 1474 },
    { IMAGE_GET_LOD_V1_V3_nsa_gfx10, 1443 },
    { IMAGE_GET_LOD_V1_V4, 1455 },
    { IMAGE_GET_LOD_V1_V4_gfx10, 1425 },
    { IMAGE_GET_LOD_V1_V4_gfx90a, 1475 },
    { IMAGE_GET_LOD_V2_V1, 1456 },
    { IMAGE_GET_LOD_V2_V1_gfx10, 1426 },
    { IMAGE_GET_LOD_V2_V1_gfx90a, 1476 },
    { IMAGE_GET_LOD_V2_V2, 1457 },
    { IMAGE_GET_LOD_V2_V2_gfx10, 1427 },
    { IMAGE_GET_LOD_V2_V2_gfx90a, 1477 },
    { IMAGE_GET_LOD_V2_V2_nsa_gfx10, 1444 },
    { IMAGE_GET_LOD_V2_V3, 1458 },
    { IMAGE_GET_LOD_V2_V3_gfx10, 1428 },
    { IMAGE_GET_LOD_V2_V3_gfx90a, 1478 },
    { IMAGE_GET_LOD_V2_V3_nsa_gfx10, 1445 },
    { IMAGE_GET_LOD_V2_V4, 1459 },
    { IMAGE_GET_LOD_V2_V4_gfx10, 1429 },
    { IMAGE_GET_LOD_V2_V4_gfx90a, 1479 },
    { IMAGE_GET_LOD_V3_V1, 1460 },
    { IMAGE_GET_LOD_V3_V1_gfx10, 1430 },
    { IMAGE_GET_LOD_V3_V1_gfx90a, 1480 },
    { IMAGE_GET_LOD_V3_V2, 1461 },
    { IMAGE_GET_LOD_V3_V2_gfx10, 1431 },
    { IMAGE_GET_LOD_V3_V2_gfx90a, 1481 },
    { IMAGE_GET_LOD_V3_V2_nsa_gfx10, 1446 },
    { IMAGE_GET_LOD_V3_V3, 1462 },
    { IMAGE_GET_LOD_V3_V3_gfx10, 1432 },
    { IMAGE_GET_LOD_V3_V3_gfx90a, 1482 },
    { IMAGE_GET_LOD_V3_V3_nsa_gfx10, 1447 },
    { IMAGE_GET_LOD_V3_V4, 1463 },
    { IMAGE_GET_LOD_V3_V4_gfx10, 1433 },
    { IMAGE_GET_LOD_V3_V4_gfx90a, 1483 },
    { IMAGE_GET_LOD_V4_V1, 1464 },
    { IMAGE_GET_LOD_V4_V1_gfx10, 1434 },
    { IMAGE_GET_LOD_V4_V1_gfx90a, 1484 },
    { IMAGE_GET_LOD_V4_V2, 1465 },
    { IMAGE_GET_LOD_V4_V2_gfx10, 1435 },
    { IMAGE_GET_LOD_V4_V2_gfx90a, 1485 },
    { IMAGE_GET_LOD_V4_V2_nsa_gfx10, 1448 },
    { IMAGE_GET_LOD_V4_V3, 1466 },
    { IMAGE_GET_LOD_V4_V3_gfx10, 1436 },
    { IMAGE_GET_LOD_V4_V3_gfx90a, 1486 },
    { IMAGE_GET_LOD_V4_V3_nsa_gfx10, 1449 },
    { IMAGE_GET_LOD_V4_V4, 1467 },
    { IMAGE_GET_LOD_V4_V4_gfx10, 1437 },
    { IMAGE_GET_LOD_V4_V4_gfx90a, 1487 },
    { IMAGE_GET_LOD_V5_V1, 1468 },
    { IMAGE_GET_LOD_V5_V1_gfx10, 1438 },
    { IMAGE_GET_LOD_V5_V1_gfx90a, 1488 },
    { IMAGE_GET_LOD_V5_V2, 1469 },
    { IMAGE_GET_LOD_V5_V2_gfx10, 1439 },
    { IMAGE_GET_LOD_V5_V2_gfx90a, 1489 },
    { IMAGE_GET_LOD_V5_V2_nsa_gfx10, 1450 },
    { IMAGE_GET_LOD_V5_V3, 1470 },
    { IMAGE_GET_LOD_V5_V3_gfx10, 1440 },
    { IMAGE_GET_LOD_V5_V3_gfx90a, 1490 },
    { IMAGE_GET_LOD_V5_V3_nsa_gfx10, 1451 },
    { IMAGE_GET_LOD_V5_V4, 1471 },
    { IMAGE_GET_LOD_V5_V4_gfx10, 1441 },
    { IMAGE_GET_LOD_V5_V4_gfx90a, 1491 },
    { IMAGE_GET_RESINFO_V1_V1, 1527 },
    { IMAGE_GET_RESINFO_V1_V1_gfx10, 1492 },
    { IMAGE_GET_RESINFO_V1_V1_gfx90a, 1547 },
    { IMAGE_GET_RESINFO_V1_V2, 1528 },
    { IMAGE_GET_RESINFO_V1_V2_gfx10, 1493 },
    { IMAGE_GET_RESINFO_V1_V2_gfx90a, 1548 },
    { IMAGE_GET_RESINFO_V1_V2_nsa_gfx10, 1512 },
    { IMAGE_GET_RESINFO_V1_V3, 1529 },
    { IMAGE_GET_RESINFO_V1_V3_gfx10, 1494 },
    { IMAGE_GET_RESINFO_V1_V3_gfx90a, 1549 },
    { IMAGE_GET_RESINFO_V1_V3_nsa_gfx10, 1513 },
    { IMAGE_GET_RESINFO_V1_V4, 1530 },
    { IMAGE_GET_RESINFO_V1_V4_gfx10, 1495 },
    { IMAGE_GET_RESINFO_V1_V4_gfx90a, 1550 },
    { IMAGE_GET_RESINFO_V1_V4_nsa_gfx10, 1514 },
    { IMAGE_GET_RESINFO_V2_V1, 1531 },
    { IMAGE_GET_RESINFO_V2_V1_gfx10, 1496 },
    { IMAGE_GET_RESINFO_V2_V1_gfx90a, 1551 },
    { IMAGE_GET_RESINFO_V2_V2, 1532 },
    { IMAGE_GET_RESINFO_V2_V2_gfx10, 1497 },
    { IMAGE_GET_RESINFO_V2_V2_gfx90a, 1552 },
    { IMAGE_GET_RESINFO_V2_V2_nsa_gfx10, 1515 },
    { IMAGE_GET_RESINFO_V2_V3, 1533 },
    { IMAGE_GET_RESINFO_V2_V3_gfx10, 1498 },
    { IMAGE_GET_RESINFO_V2_V3_gfx90a, 1553 },
    { IMAGE_GET_RESINFO_V2_V3_nsa_gfx10, 1516 },
    { IMAGE_GET_RESINFO_V2_V4, 1534 },
    { IMAGE_GET_RESINFO_V2_V4_gfx10, 1499 },
    { IMAGE_GET_RESINFO_V2_V4_gfx90a, 1554 },
    { IMAGE_GET_RESINFO_V2_V4_nsa_gfx10, 1517 },
    { IMAGE_GET_RESINFO_V3_V1, 1535 },
    { IMAGE_GET_RESINFO_V3_V1_gfx10, 1500 },
    { IMAGE_GET_RESINFO_V3_V1_gfx90a, 1555 },
    { IMAGE_GET_RESINFO_V3_V2, 1536 },
    { IMAGE_GET_RESINFO_V3_V2_gfx10, 1501 },
    { IMAGE_GET_RESINFO_V3_V2_gfx90a, 1556 },
    { IMAGE_GET_RESINFO_V3_V2_nsa_gfx10, 1518 },
    { IMAGE_GET_RESINFO_V3_V3, 1537 },
    { IMAGE_GET_RESINFO_V3_V3_gfx10, 1502 },
    { IMAGE_GET_RESINFO_V3_V3_gfx90a, 1557 },
    { IMAGE_GET_RESINFO_V3_V3_nsa_gfx10, 1519 },
    { IMAGE_GET_RESINFO_V3_V4, 1538 },
    { IMAGE_GET_RESINFO_V3_V4_gfx10, 1503 },
    { IMAGE_GET_RESINFO_V3_V4_gfx90a, 1558 },
    { IMAGE_GET_RESINFO_V3_V4_nsa_gfx10, 1520 },
    { IMAGE_GET_RESINFO_V4_V1, 1539 },
    { IMAGE_GET_RESINFO_V4_V1_gfx10, 1504 },
    { IMAGE_GET_RESINFO_V4_V1_gfx90a, 1559 },
    { IMAGE_GET_RESINFO_V4_V2, 1540 },
    { IMAGE_GET_RESINFO_V4_V2_gfx10, 1505 },
    { IMAGE_GET_RESINFO_V4_V2_gfx90a, 1560 },
    { IMAGE_GET_RESINFO_V4_V2_nsa_gfx10, 1521 },
    { IMAGE_GET_RESINFO_V4_V3, 1541 },
    { IMAGE_GET_RESINFO_V4_V3_gfx10, 1506 },
    { IMAGE_GET_RESINFO_V4_V3_gfx90a, 1561 },
    { IMAGE_GET_RESINFO_V4_V3_nsa_gfx10, 1522 },
    { IMAGE_GET_RESINFO_V4_V4, 1542 },
    { IMAGE_GET_RESINFO_V4_V4_gfx10, 1507 },
    { IMAGE_GET_RESINFO_V4_V4_gfx90a, 1562 },
    { IMAGE_GET_RESINFO_V4_V4_nsa_gfx10, 1523 },
    { IMAGE_GET_RESINFO_V5_V1, 1543 },
    { IMAGE_GET_RESINFO_V5_V1_gfx10, 1508 },
    { IMAGE_GET_RESINFO_V5_V1_gfx90a, 1563 },
    { IMAGE_GET_RESINFO_V5_V2, 1544 },
    { IMAGE_GET_RESINFO_V5_V2_gfx10, 1509 },
    { IMAGE_GET_RESINFO_V5_V2_gfx90a, 1564 },
    { IMAGE_GET_RESINFO_V5_V2_nsa_gfx10, 1524 },
    { IMAGE_GET_RESINFO_V5_V3, 1545 },
    { IMAGE_GET_RESINFO_V5_V3_gfx10, 1510 },
    { IMAGE_GET_RESINFO_V5_V3_gfx90a, 1565 },
    { IMAGE_GET_RESINFO_V5_V3_nsa_gfx10, 1525 },
    { IMAGE_GET_RESINFO_V5_V4, 1546 },
    { IMAGE_GET_RESINFO_V5_V4_gfx10, 1511 },
    { IMAGE_GET_RESINFO_V5_V4_gfx90a, 1566 },
    { IMAGE_GET_RESINFO_V5_V4_nsa_gfx10, 1526 },
    { IMAGE_LOAD_MIP_PCK_SGN_V1_V1, 1827 },
    { IMAGE_LOAD_MIP_PCK_SGN_V1_V1_gfx10, 1792 },
    { IMAGE_LOAD_MIP_PCK_SGN_V1_V1_gfx90a, 1847 },
    { IMAGE_LOAD_MIP_PCK_SGN_V1_V2, 1828 },
    { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_gfx10, 1793 },
    { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_gfx90a, 1848 },
    { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_nsa_gfx10, 1812 },
    { IMAGE_LOAD_MIP_PCK_SGN_V1_V3, 1829 },
    { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_gfx10, 1794 },
    { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_gfx90a, 1849 },
    { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_nsa_gfx10, 1813 },
    { IMAGE_LOAD_MIP_PCK_SGN_V1_V4, 1830 },
    { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_gfx10, 1795 },
    { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_gfx90a, 1850 },
    { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_nsa_gfx10, 1814 },
    { IMAGE_LOAD_MIP_PCK_SGN_V2_V1, 1831 },
    { IMAGE_LOAD_MIP_PCK_SGN_V2_V1_gfx10, 1796 },
    { IMAGE_LOAD_MIP_PCK_SGN_V2_V1_gfx90a, 1851 },
    { IMAGE_LOAD_MIP_PCK_SGN_V2_V2, 1832 },
    { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_gfx10, 1797 },
    { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_gfx90a, 1852 },
    { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_nsa_gfx10, 1815 },
    { IMAGE_LOAD_MIP_PCK_SGN_V2_V3, 1833 },
    { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_gfx10, 1798 },
    { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_gfx90a, 1853 },
    { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_nsa_gfx10, 1816 },
    { IMAGE_LOAD_MIP_PCK_SGN_V2_V4, 1834 },
    { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_gfx10, 1799 },
    { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_gfx90a, 1854 },
    { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_nsa_gfx10, 1817 },
    { IMAGE_LOAD_MIP_PCK_SGN_V3_V1, 1835 },
    { IMAGE_LOAD_MIP_PCK_SGN_V3_V1_gfx10, 1800 },
    { IMAGE_LOAD_MIP_PCK_SGN_V3_V1_gfx90a, 1855 },
    { IMAGE_LOAD_MIP_PCK_SGN_V3_V2, 1836 },
    { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_gfx10, 1801 },
    { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_gfx90a, 1856 },
    { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_nsa_gfx10, 1818 },
    { IMAGE_LOAD_MIP_PCK_SGN_V3_V3, 1837 },
    { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_gfx10, 1802 },
    { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_gfx90a, 1857 },
    { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_nsa_gfx10, 1819 },
    { IMAGE_LOAD_MIP_PCK_SGN_V3_V4, 1838 },
    { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_gfx10, 1803 },
    { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_gfx90a, 1858 },
    { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_nsa_gfx10, 1820 },
    { IMAGE_LOAD_MIP_PCK_SGN_V4_V1, 1839 },
    { IMAGE_LOAD_MIP_PCK_SGN_V4_V1_gfx10, 1804 },
    { IMAGE_LOAD_MIP_PCK_SGN_V4_V1_gfx90a, 1859 },
    { IMAGE_LOAD_MIP_PCK_SGN_V4_V2, 1840 },
    { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_gfx10, 1805 },
    { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_gfx90a, 1860 },
    { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_nsa_gfx10, 1821 },
    { IMAGE_LOAD_MIP_PCK_SGN_V4_V3, 1841 },
    { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_gfx10, 1806 },
    { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_gfx90a, 1861 },
    { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_nsa_gfx10, 1822 },
    { IMAGE_LOAD_MIP_PCK_SGN_V4_V4, 1842 },
    { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_gfx10, 1807 },
    { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_gfx90a, 1862 },
    { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_nsa_gfx10, 1823 },
    { IMAGE_LOAD_MIP_PCK_SGN_V5_V1, 1843 },
    { IMAGE_LOAD_MIP_PCK_SGN_V5_V1_gfx10, 1808 },
    { IMAGE_LOAD_MIP_PCK_SGN_V5_V1_gfx90a, 1863 },
    { IMAGE_LOAD_MIP_PCK_SGN_V5_V2, 1844 },
    { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_gfx10, 1809 },
    { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_gfx90a, 1864 },
    { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_nsa_gfx10, 1824 },
    { IMAGE_LOAD_MIP_PCK_SGN_V5_V3, 1845 },
    { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_gfx10, 1810 },
    { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_gfx90a, 1865 },
    { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_nsa_gfx10, 1825 },
    { IMAGE_LOAD_MIP_PCK_SGN_V5_V4, 1846 },
    { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_gfx10, 1811 },
    { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_gfx90a, 1866 },
    { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_nsa_gfx10, 1826 },
    { IMAGE_LOAD_MIP_PCK_V1_V1, 1752 },
    { IMAGE_LOAD_MIP_PCK_V1_V1_gfx10, 1717 },
    { IMAGE_LOAD_MIP_PCK_V1_V1_gfx90a, 1772 },
    { IMAGE_LOAD_MIP_PCK_V1_V2, 1753 },
    { IMAGE_LOAD_MIP_PCK_V1_V2_gfx10, 1718 },
    { IMAGE_LOAD_MIP_PCK_V1_V2_gfx90a, 1773 },
    { IMAGE_LOAD_MIP_PCK_V1_V2_nsa_gfx10, 1737 },
    { IMAGE_LOAD_MIP_PCK_V1_V3, 1754 },
    { IMAGE_LOAD_MIP_PCK_V1_V3_gfx10, 1719 },
    { IMAGE_LOAD_MIP_PCK_V1_V3_gfx90a, 1774 },
    { IMAGE_LOAD_MIP_PCK_V1_V3_nsa_gfx10, 1738 },
    { IMAGE_LOAD_MIP_PCK_V1_V4, 1755 },
    { IMAGE_LOAD_MIP_PCK_V1_V4_gfx10, 1720 },
    { IMAGE_LOAD_MIP_PCK_V1_V4_gfx90a, 1775 },
    { IMAGE_LOAD_MIP_PCK_V1_V4_nsa_gfx10, 1739 },
    { IMAGE_LOAD_MIP_PCK_V2_V1, 1756 },
    { IMAGE_LOAD_MIP_PCK_V2_V1_gfx10, 1721 },
    { IMAGE_LOAD_MIP_PCK_V2_V1_gfx90a, 1776 },
    { IMAGE_LOAD_MIP_PCK_V2_V2, 1757 },
    { IMAGE_LOAD_MIP_PCK_V2_V2_gfx10, 1722 },
    { IMAGE_LOAD_MIP_PCK_V2_V2_gfx90a, 1777 },
    { IMAGE_LOAD_MIP_PCK_V2_V2_nsa_gfx10, 1740 },
    { IMAGE_LOAD_MIP_PCK_V2_V3, 1758 },
    { IMAGE_LOAD_MIP_PCK_V2_V3_gfx10, 1723 },
    { IMAGE_LOAD_MIP_PCK_V2_V3_gfx90a, 1778 },
    { IMAGE_LOAD_MIP_PCK_V2_V3_nsa_gfx10, 1741 },
    { IMAGE_LOAD_MIP_PCK_V2_V4, 1759 },
    { IMAGE_LOAD_MIP_PCK_V2_V4_gfx10, 1724 },
    { IMAGE_LOAD_MIP_PCK_V2_V4_gfx90a, 1779 },
    { IMAGE_LOAD_MIP_PCK_V2_V4_nsa_gfx10, 1742 },
    { IMAGE_LOAD_MIP_PCK_V3_V1, 1760 },
    { IMAGE_LOAD_MIP_PCK_V3_V1_gfx10, 1725 },
    { IMAGE_LOAD_MIP_PCK_V3_V1_gfx90a, 1780 },
    { IMAGE_LOAD_MIP_PCK_V3_V2, 1761 },
    { IMAGE_LOAD_MIP_PCK_V3_V2_gfx10, 1726 },
    { IMAGE_LOAD_MIP_PCK_V3_V2_gfx90a, 1781 },
    { IMAGE_LOAD_MIP_PCK_V3_V2_nsa_gfx10, 1743 },
    { IMAGE_LOAD_MIP_PCK_V3_V3, 1762 },
    { IMAGE_LOAD_MIP_PCK_V3_V3_gfx10, 1727 },
    { IMAGE_LOAD_MIP_PCK_V3_V3_gfx90a, 1782 },
    { IMAGE_LOAD_MIP_PCK_V3_V3_nsa_gfx10, 1744 },
    { IMAGE_LOAD_MIP_PCK_V3_V4, 1763 },
    { IMAGE_LOAD_MIP_PCK_V3_V4_gfx10, 1728 },
    { IMAGE_LOAD_MIP_PCK_V3_V4_gfx90a, 1783 },
    { IMAGE_LOAD_MIP_PCK_V3_V4_nsa_gfx10, 1745 },
    { IMAGE_LOAD_MIP_PCK_V4_V1, 1764 },
    { IMAGE_LOAD_MIP_PCK_V4_V1_gfx10, 1729 },
    { IMAGE_LOAD_MIP_PCK_V4_V1_gfx90a, 1784 },
    { IMAGE_LOAD_MIP_PCK_V4_V2, 1765 },
    { IMAGE_LOAD_MIP_PCK_V4_V2_gfx10, 1730 },
    { IMAGE_LOAD_MIP_PCK_V4_V2_gfx90a, 1785 },
    { IMAGE_LOAD_MIP_PCK_V4_V2_nsa_gfx10, 1746 },
    { IMAGE_LOAD_MIP_PCK_V4_V3, 1766 },
    { IMAGE_LOAD_MIP_PCK_V4_V3_gfx10, 1731 },
    { IMAGE_LOAD_MIP_PCK_V4_V3_gfx90a, 1786 },
    { IMAGE_LOAD_MIP_PCK_V4_V3_nsa_gfx10, 1747 },
    { IMAGE_LOAD_MIP_PCK_V4_V4, 1767 },
    { IMAGE_LOAD_MIP_PCK_V4_V4_gfx10, 1732 },
    { IMAGE_LOAD_MIP_PCK_V4_V4_gfx90a, 1787 },
    { IMAGE_LOAD_MIP_PCK_V4_V4_nsa_gfx10, 1748 },
    { IMAGE_LOAD_MIP_PCK_V5_V1, 1768 },
    { IMAGE_LOAD_MIP_PCK_V5_V1_gfx10, 1733 },
    { IMAGE_LOAD_MIP_PCK_V5_V1_gfx90a, 1788 },
    { IMAGE_LOAD_MIP_PCK_V5_V2, 1769 },
    { IMAGE_LOAD_MIP_PCK_V5_V2_gfx10, 1734 },
    { IMAGE_LOAD_MIP_PCK_V5_V2_gfx90a, 1789 },
    { IMAGE_LOAD_MIP_PCK_V5_V2_nsa_gfx10, 1749 },
    { IMAGE_LOAD_MIP_PCK_V5_V3, 1770 },
    { IMAGE_LOAD_MIP_PCK_V5_V3_gfx10, 1735 },
    { IMAGE_LOAD_MIP_PCK_V5_V3_gfx90a, 1790 },
    { IMAGE_LOAD_MIP_PCK_V5_V3_nsa_gfx10, 1750 },
    { IMAGE_LOAD_MIP_PCK_V5_V4, 1771 },
    { IMAGE_LOAD_MIP_PCK_V5_V4_gfx10, 1736 },
    { IMAGE_LOAD_MIP_PCK_V5_V4_gfx90a, 1791 },
    { IMAGE_LOAD_MIP_PCK_V5_V4_nsa_gfx10, 1751 },
    { IMAGE_LOAD_MIP_V1_V1, 1677 },
    { IMAGE_LOAD_MIP_V1_V1_gfx10, 1642 },
    { IMAGE_LOAD_MIP_V1_V1_gfx90a, 1697 },
    { IMAGE_LOAD_MIP_V1_V2, 1678 },
    { IMAGE_LOAD_MIP_V1_V2_gfx10, 1643 },
    { IMAGE_LOAD_MIP_V1_V2_gfx90a, 1698 },
    { IMAGE_LOAD_MIP_V1_V2_nsa_gfx10, 1662 },
    { IMAGE_LOAD_MIP_V1_V3, 1679 },
    { IMAGE_LOAD_MIP_V1_V3_gfx10, 1644 },
    { IMAGE_LOAD_MIP_V1_V3_gfx90a, 1699 },
    { IMAGE_LOAD_MIP_V1_V3_nsa_gfx10, 1663 },
    { IMAGE_LOAD_MIP_V1_V4, 1680 },
    { IMAGE_LOAD_MIP_V1_V4_gfx10, 1645 },
    { IMAGE_LOAD_MIP_V1_V4_gfx90a, 1700 },
    { IMAGE_LOAD_MIP_V1_V4_nsa_gfx10, 1664 },
    { IMAGE_LOAD_MIP_V2_V1, 1681 },
    { IMAGE_LOAD_MIP_V2_V1_gfx10, 1646 },
    { IMAGE_LOAD_MIP_V2_V1_gfx90a, 1701 },
    { IMAGE_LOAD_MIP_V2_V2, 1682 },
    { IMAGE_LOAD_MIP_V2_V2_gfx10, 1647 },
    { IMAGE_LOAD_MIP_V2_V2_gfx90a, 1702 },
    { IMAGE_LOAD_MIP_V2_V2_nsa_gfx10, 1665 },
    { IMAGE_LOAD_MIP_V2_V3, 1683 },
    { IMAGE_LOAD_MIP_V2_V3_gfx10, 1648 },
    { IMAGE_LOAD_MIP_V2_V3_gfx90a, 1703 },
    { IMAGE_LOAD_MIP_V2_V3_nsa_gfx10, 1666 },
    { IMAGE_LOAD_MIP_V2_V4, 1684 },
    { IMAGE_LOAD_MIP_V2_V4_gfx10, 1649 },
    { IMAGE_LOAD_MIP_V2_V4_gfx90a, 1704 },
    { IMAGE_LOAD_MIP_V2_V4_nsa_gfx10, 1667 },
    { IMAGE_LOAD_MIP_V3_V1, 1685 },
    { IMAGE_LOAD_MIP_V3_V1_gfx10, 1650 },
    { IMAGE_LOAD_MIP_V3_V1_gfx90a, 1705 },
    { IMAGE_LOAD_MIP_V3_V2, 1686 },
    { IMAGE_LOAD_MIP_V3_V2_gfx10, 1651 },
    { IMAGE_LOAD_MIP_V3_V2_gfx90a, 1706 },
    { IMAGE_LOAD_MIP_V3_V2_nsa_gfx10, 1668 },
    { IMAGE_LOAD_MIP_V3_V3, 1687 },
    { IMAGE_LOAD_MIP_V3_V3_gfx10, 1652 },
    { IMAGE_LOAD_MIP_V3_V3_gfx90a, 1707 },
    { IMAGE_LOAD_MIP_V3_V3_nsa_gfx10, 1669 },
    { IMAGE_LOAD_MIP_V3_V4, 1688 },
    { IMAGE_LOAD_MIP_V3_V4_gfx10, 1653 },
    { IMAGE_LOAD_MIP_V3_V4_gfx90a, 1708 },
    { IMAGE_LOAD_MIP_V3_V4_nsa_gfx10, 1670 },
    { IMAGE_LOAD_MIP_V4_V1, 1689 },
    { IMAGE_LOAD_MIP_V4_V1_gfx10, 1654 },
    { IMAGE_LOAD_MIP_V4_V1_gfx90a, 1709 },
    { IMAGE_LOAD_MIP_V4_V2, 1690 },
    { IMAGE_LOAD_MIP_V4_V2_gfx10, 1655 },
    { IMAGE_LOAD_MIP_V4_V2_gfx90a, 1710 },
    { IMAGE_LOAD_MIP_V4_V2_nsa_gfx10, 1671 },
    { IMAGE_LOAD_MIP_V4_V3, 1691 },
    { IMAGE_LOAD_MIP_V4_V3_gfx10, 1656 },
    { IMAGE_LOAD_MIP_V4_V3_gfx90a, 1711 },
    { IMAGE_LOAD_MIP_V4_V3_nsa_gfx10, 1672 },
    { IMAGE_LOAD_MIP_V4_V4, 1692 },
    { IMAGE_LOAD_MIP_V4_V4_gfx10, 1657 },
    { IMAGE_LOAD_MIP_V4_V4_gfx90a, 1712 },
    { IMAGE_LOAD_MIP_V4_V4_nsa_gfx10, 1673 },
    { IMAGE_LOAD_MIP_V5_V1, 1693 },
    { IMAGE_LOAD_MIP_V5_V1_gfx10, 1658 },
    { IMAGE_LOAD_MIP_V5_V1_gfx90a, 1713 },
    { IMAGE_LOAD_MIP_V5_V2, 1694 },
    { IMAGE_LOAD_MIP_V5_V2_gfx10, 1659 },
    { IMAGE_LOAD_MIP_V5_V2_gfx90a, 1714 },
    { IMAGE_LOAD_MIP_V5_V2_nsa_gfx10, 1674 },
    { IMAGE_LOAD_MIP_V5_V3, 1695 },
    { IMAGE_LOAD_MIP_V5_V3_gfx10, 1660 },
    { IMAGE_LOAD_MIP_V5_V3_gfx90a, 1715 },
    { IMAGE_LOAD_MIP_V5_V3_nsa_gfx10, 1675 },
    { IMAGE_LOAD_MIP_V5_V4, 1696 },
    { IMAGE_LOAD_MIP_V5_V4_gfx10, 1661 },
    { IMAGE_LOAD_MIP_V5_V4_gfx90a, 1716 },
    { IMAGE_LOAD_MIP_V5_V4_nsa_gfx10, 1676 },
    { IMAGE_LOAD_PCK_SGN_V1_V1, 1977 },
    { IMAGE_LOAD_PCK_SGN_V1_V1_gfx10, 1942 },
    { IMAGE_LOAD_PCK_SGN_V1_V1_gfx90a, 1997 },
    { IMAGE_LOAD_PCK_SGN_V1_V2, 1978 },
    { IMAGE_LOAD_PCK_SGN_V1_V2_gfx10, 1943 },
    { IMAGE_LOAD_PCK_SGN_V1_V2_gfx90a, 1998 },
    { IMAGE_LOAD_PCK_SGN_V1_V2_nsa_gfx10, 1962 },
    { IMAGE_LOAD_PCK_SGN_V1_V3, 1979 },
    { IMAGE_LOAD_PCK_SGN_V1_V3_gfx10, 1944 },
    { IMAGE_LOAD_PCK_SGN_V1_V3_gfx90a, 1999 },
    { IMAGE_LOAD_PCK_SGN_V1_V3_nsa_gfx10, 1963 },
    { IMAGE_LOAD_PCK_SGN_V1_V4, 1980 },
    { IMAGE_LOAD_PCK_SGN_V1_V4_gfx10, 1945 },
    { IMAGE_LOAD_PCK_SGN_V1_V4_gfx90a, 2000 },
    { IMAGE_LOAD_PCK_SGN_V1_V4_nsa_gfx10, 1964 },
    { IMAGE_LOAD_PCK_SGN_V2_V1, 1981 },
    { IMAGE_LOAD_PCK_SGN_V2_V1_gfx10, 1946 },
    { IMAGE_LOAD_PCK_SGN_V2_V1_gfx90a, 2001 },
    { IMAGE_LOAD_PCK_SGN_V2_V2, 1982 },
    { IMAGE_LOAD_PCK_SGN_V2_V2_gfx10, 1947 },
    { IMAGE_LOAD_PCK_SGN_V2_V2_gfx90a, 2002 },
    { IMAGE_LOAD_PCK_SGN_V2_V2_nsa_gfx10, 1965 },
    { IMAGE_LOAD_PCK_SGN_V2_V3, 1983 },
    { IMAGE_LOAD_PCK_SGN_V2_V3_gfx10, 1948 },
    { IMAGE_LOAD_PCK_SGN_V2_V3_gfx90a, 2003 },
    { IMAGE_LOAD_PCK_SGN_V2_V3_nsa_gfx10, 1966 },
    { IMAGE_LOAD_PCK_SGN_V2_V4, 1984 },
    { IMAGE_LOAD_PCK_SGN_V2_V4_gfx10, 1949 },
    { IMAGE_LOAD_PCK_SGN_V2_V4_gfx90a, 2004 },
    { IMAGE_LOAD_PCK_SGN_V2_V4_nsa_gfx10, 1967 },
    { IMAGE_LOAD_PCK_SGN_V3_V1, 1985 },
    { IMAGE_LOAD_PCK_SGN_V3_V1_gfx10, 1950 },
    { IMAGE_LOAD_PCK_SGN_V3_V1_gfx90a, 2005 },
    { IMAGE_LOAD_PCK_SGN_V3_V2, 1986 },
    { IMAGE_LOAD_PCK_SGN_V3_V2_gfx10, 1951 },
    { IMAGE_LOAD_PCK_SGN_V3_V2_gfx90a, 2006 },
    { IMAGE_LOAD_PCK_SGN_V3_V2_nsa_gfx10, 1968 },
    { IMAGE_LOAD_PCK_SGN_V3_V3, 1987 },
    { IMAGE_LOAD_PCK_SGN_V3_V3_gfx10, 1952 },
    { IMAGE_LOAD_PCK_SGN_V3_V3_gfx90a, 2007 },
    { IMAGE_LOAD_PCK_SGN_V3_V3_nsa_gfx10, 1969 },
    { IMAGE_LOAD_PCK_SGN_V3_V4, 1988 },
    { IMAGE_LOAD_PCK_SGN_V3_V4_gfx10, 1953 },
    { IMAGE_LOAD_PCK_SGN_V3_V4_gfx90a, 2008 },
    { IMAGE_LOAD_PCK_SGN_V3_V4_nsa_gfx10, 1970 },
    { IMAGE_LOAD_PCK_SGN_V4_V1, 1989 },
    { IMAGE_LOAD_PCK_SGN_V4_V1_gfx10, 1954 },
    { IMAGE_LOAD_PCK_SGN_V4_V1_gfx90a, 2009 },
    { IMAGE_LOAD_PCK_SGN_V4_V2, 1990 },
    { IMAGE_LOAD_PCK_SGN_V4_V2_gfx10, 1955 },
    { IMAGE_LOAD_PCK_SGN_V4_V2_gfx90a, 2010 },
    { IMAGE_LOAD_PCK_SGN_V4_V2_nsa_gfx10, 1971 },
    { IMAGE_LOAD_PCK_SGN_V4_V3, 1991 },
    { IMAGE_LOAD_PCK_SGN_V4_V3_gfx10, 1956 },
    { IMAGE_LOAD_PCK_SGN_V4_V3_gfx90a, 2011 },
    { IMAGE_LOAD_PCK_SGN_V4_V3_nsa_gfx10, 1972 },
    { IMAGE_LOAD_PCK_SGN_V4_V4, 1992 },
    { IMAGE_LOAD_PCK_SGN_V4_V4_gfx10, 1957 },
    { IMAGE_LOAD_PCK_SGN_V4_V4_gfx90a, 2012 },
    { IMAGE_LOAD_PCK_SGN_V4_V4_nsa_gfx10, 1973 },
    { IMAGE_LOAD_PCK_SGN_V5_V1, 1993 },
    { IMAGE_LOAD_PCK_SGN_V5_V1_gfx10, 1958 },
    { IMAGE_LOAD_PCK_SGN_V5_V1_gfx90a, 2013 },
    { IMAGE_LOAD_PCK_SGN_V5_V2, 1994 },
    { IMAGE_LOAD_PCK_SGN_V5_V2_gfx10, 1959 },
    { IMAGE_LOAD_PCK_SGN_V5_V2_gfx90a, 2014 },
    { IMAGE_LOAD_PCK_SGN_V5_V2_nsa_gfx10, 1974 },
    { IMAGE_LOAD_PCK_SGN_V5_V3, 1995 },
    { IMAGE_LOAD_PCK_SGN_V5_V3_gfx10, 1960 },
    { IMAGE_LOAD_PCK_SGN_V5_V3_gfx90a, 2015 },
    { IMAGE_LOAD_PCK_SGN_V5_V3_nsa_gfx10, 1975 },
    { IMAGE_LOAD_PCK_SGN_V5_V4, 1996 },
    { IMAGE_LOAD_PCK_SGN_V5_V4_gfx10, 1961 },
    { IMAGE_LOAD_PCK_SGN_V5_V4_gfx90a, 2016 },
    { IMAGE_LOAD_PCK_SGN_V5_V4_nsa_gfx10, 1976 },
    { IMAGE_LOAD_PCK_V1_V1, 1902 },
    { IMAGE_LOAD_PCK_V1_V1_gfx10, 1867 },
    { IMAGE_LOAD_PCK_V1_V1_gfx90a, 1922 },
    { IMAGE_LOAD_PCK_V1_V2, 1903 },
    { IMAGE_LOAD_PCK_V1_V2_gfx10, 1868 },
    { IMAGE_LOAD_PCK_V1_V2_gfx90a, 1923 },
    { IMAGE_LOAD_PCK_V1_V2_nsa_gfx10, 1887 },
    { IMAGE_LOAD_PCK_V1_V3, 1904 },
    { IMAGE_LOAD_PCK_V1_V3_gfx10, 1869 },
    { IMAGE_LOAD_PCK_V1_V3_gfx90a, 1924 },
    { IMAGE_LOAD_PCK_V1_V3_nsa_gfx10, 1888 },
    { IMAGE_LOAD_PCK_V1_V4, 1905 },
    { IMAGE_LOAD_PCK_V1_V4_gfx10, 1870 },
    { IMAGE_LOAD_PCK_V1_V4_gfx90a, 1925 },
    { IMAGE_LOAD_PCK_V1_V4_nsa_gfx10, 1889 },
    { IMAGE_LOAD_PCK_V2_V1, 1906 },
    { IMAGE_LOAD_PCK_V2_V1_gfx10, 1871 },
    { IMAGE_LOAD_PCK_V2_V1_gfx90a, 1926 },
    { IMAGE_LOAD_PCK_V2_V2, 1907 },
    { IMAGE_LOAD_PCK_V2_V2_gfx10, 1872 },
    { IMAGE_LOAD_PCK_V2_V2_gfx90a, 1927 },
    { IMAGE_LOAD_PCK_V2_V2_nsa_gfx10, 1890 },
    { IMAGE_LOAD_PCK_V2_V3, 1908 },
    { IMAGE_LOAD_PCK_V2_V3_gfx10, 1873 },
    { IMAGE_LOAD_PCK_V2_V3_gfx90a, 1928 },
    { IMAGE_LOAD_PCK_V2_V3_nsa_gfx10, 1891 },
    { IMAGE_LOAD_PCK_V2_V4, 1909 },
    { IMAGE_LOAD_PCK_V2_V4_gfx10, 1874 },
    { IMAGE_LOAD_PCK_V2_V4_gfx90a, 1929 },
    { IMAGE_LOAD_PCK_V2_V4_nsa_gfx10, 1892 },
    { IMAGE_LOAD_PCK_V3_V1, 1910 },
    { IMAGE_LOAD_PCK_V3_V1_gfx10, 1875 },
    { IMAGE_LOAD_PCK_V3_V1_gfx90a, 1930 },
    { IMAGE_LOAD_PCK_V3_V2, 1911 },
    { IMAGE_LOAD_PCK_V3_V2_gfx10, 1876 },
    { IMAGE_LOAD_PCK_V3_V2_gfx90a, 1931 },
    { IMAGE_LOAD_PCK_V3_V2_nsa_gfx10, 1893 },
    { IMAGE_LOAD_PCK_V3_V3, 1912 },
    { IMAGE_LOAD_PCK_V3_V3_gfx10, 1877 },
    { IMAGE_LOAD_PCK_V3_V3_gfx90a, 1932 },
    { IMAGE_LOAD_PCK_V3_V3_nsa_gfx10, 1894 },
    { IMAGE_LOAD_PCK_V3_V4, 1913 },
    { IMAGE_LOAD_PCK_V3_V4_gfx10, 1878 },
    { IMAGE_LOAD_PCK_V3_V4_gfx90a, 1933 },
    { IMAGE_LOAD_PCK_V3_V4_nsa_gfx10, 1895 },
    { IMAGE_LOAD_PCK_V4_V1, 1914 },
    { IMAGE_LOAD_PCK_V4_V1_gfx10, 1879 },
    { IMAGE_LOAD_PCK_V4_V1_gfx90a, 1934 },
    { IMAGE_LOAD_PCK_V4_V2, 1915 },
    { IMAGE_LOAD_PCK_V4_V2_gfx10, 1880 },
    { IMAGE_LOAD_PCK_V4_V2_gfx90a, 1935 },
    { IMAGE_LOAD_PCK_V4_V2_nsa_gfx10, 1896 },
    { IMAGE_LOAD_PCK_V4_V3, 1916 },
    { IMAGE_LOAD_PCK_V4_V3_gfx10, 1881 },
    { IMAGE_LOAD_PCK_V4_V3_gfx90a, 1936 },
    { IMAGE_LOAD_PCK_V4_V3_nsa_gfx10, 1897 },
    { IMAGE_LOAD_PCK_V4_V4, 1917 },
    { IMAGE_LOAD_PCK_V4_V4_gfx10, 1882 },
    { IMAGE_LOAD_PCK_V4_V4_gfx90a, 1937 },
    { IMAGE_LOAD_PCK_V4_V4_nsa_gfx10, 1898 },
    { IMAGE_LOAD_PCK_V5_V1, 1918 },
    { IMAGE_LOAD_PCK_V5_V1_gfx10, 1883 },
    { IMAGE_LOAD_PCK_V5_V1_gfx90a, 1938 },
    { IMAGE_LOAD_PCK_V5_V2, 1919 },
    { IMAGE_LOAD_PCK_V5_V2_gfx10, 1884 },
    { IMAGE_LOAD_PCK_V5_V2_gfx90a, 1939 },
    { IMAGE_LOAD_PCK_V5_V2_nsa_gfx10, 1899 },
    { IMAGE_LOAD_PCK_V5_V3, 1920 },
    { IMAGE_LOAD_PCK_V5_V3_gfx10, 1885 },
    { IMAGE_LOAD_PCK_V5_V3_gfx90a, 1940 },
    { IMAGE_LOAD_PCK_V5_V3_nsa_gfx10, 1900 },
    { IMAGE_LOAD_PCK_V5_V4, 1921 },
    { IMAGE_LOAD_PCK_V5_V4_gfx10, 1886 },
    { IMAGE_LOAD_PCK_V5_V4_gfx90a, 1941 },
    { IMAGE_LOAD_PCK_V5_V4_nsa_gfx10, 1901 },
    { IMAGE_LOAD_V1_V1, 1602 },
    { IMAGE_LOAD_V1_V1_gfx10, 1567 },
    { IMAGE_LOAD_V1_V1_gfx90a, 1622 },
    { IMAGE_LOAD_V1_V2, 1603 },
    { IMAGE_LOAD_V1_V2_gfx10, 1568 },
    { IMAGE_LOAD_V1_V2_gfx90a, 1623 },
    { IMAGE_LOAD_V1_V2_nsa_gfx10, 1587 },
    { IMAGE_LOAD_V1_V3, 1604 },
    { IMAGE_LOAD_V1_V3_gfx10, 1569 },
    { IMAGE_LOAD_V1_V3_gfx90a, 1624 },
    { IMAGE_LOAD_V1_V3_nsa_gfx10, 1588 },
    { IMAGE_LOAD_V1_V4, 1605 },
    { IMAGE_LOAD_V1_V4_gfx10, 1570 },
    { IMAGE_LOAD_V1_V4_gfx90a, 1625 },
    { IMAGE_LOAD_V1_V4_nsa_gfx10, 1589 },
    { IMAGE_LOAD_V2_V1, 1606 },
    { IMAGE_LOAD_V2_V1_gfx10, 1571 },
    { IMAGE_LOAD_V2_V1_gfx90a, 1626 },
    { IMAGE_LOAD_V2_V2, 1607 },
    { IMAGE_LOAD_V2_V2_gfx10, 1572 },
    { IMAGE_LOAD_V2_V2_gfx90a, 1627 },
    { IMAGE_LOAD_V2_V2_nsa_gfx10, 1590 },
    { IMAGE_LOAD_V2_V3, 1608 },
    { IMAGE_LOAD_V2_V3_gfx10, 1573 },
    { IMAGE_LOAD_V2_V3_gfx90a, 1628 },
    { IMAGE_LOAD_V2_V3_nsa_gfx10, 1591 },
    { IMAGE_LOAD_V2_V4, 1609 },
    { IMAGE_LOAD_V2_V4_gfx10, 1574 },
    { IMAGE_LOAD_V2_V4_gfx90a, 1629 },
    { IMAGE_LOAD_V2_V4_nsa_gfx10, 1592 },
    { IMAGE_LOAD_V3_V1, 1610 },
    { IMAGE_LOAD_V3_V1_gfx10, 1575 },
    { IMAGE_LOAD_V3_V1_gfx90a, 1630 },
    { IMAGE_LOAD_V3_V2, 1611 },
    { IMAGE_LOAD_V3_V2_gfx10, 1576 },
    { IMAGE_LOAD_V3_V2_gfx90a, 1631 },
    { IMAGE_LOAD_V3_V2_nsa_gfx10, 1593 },
    { IMAGE_LOAD_V3_V3, 1612 },
    { IMAGE_LOAD_V3_V3_gfx10, 1577 },
    { IMAGE_LOAD_V3_V3_gfx90a, 1632 },
    { IMAGE_LOAD_V3_V3_nsa_gfx10, 1594 },
    { IMAGE_LOAD_V3_V4, 1613 },
    { IMAGE_LOAD_V3_V4_gfx10, 1578 },
    { IMAGE_LOAD_V3_V4_gfx90a, 1633 },
    { IMAGE_LOAD_V3_V4_nsa_gfx10, 1595 },
    { IMAGE_LOAD_V4_V1, 1614 },
    { IMAGE_LOAD_V4_V1_gfx10, 1579 },
    { IMAGE_LOAD_V4_V1_gfx90a, 1634 },
    { IMAGE_LOAD_V4_V2, 1615 },
    { IMAGE_LOAD_V4_V2_gfx10, 1580 },
    { IMAGE_LOAD_V4_V2_gfx90a, 1635 },
    { IMAGE_LOAD_V4_V2_nsa_gfx10, 1596 },
    { IMAGE_LOAD_V4_V3, 1616 },
    { IMAGE_LOAD_V4_V3_gfx10, 1581 },
    { IMAGE_LOAD_V4_V3_gfx90a, 1636 },
    { IMAGE_LOAD_V4_V3_nsa_gfx10, 1597 },
    { IMAGE_LOAD_V4_V4, 1617 },
    { IMAGE_LOAD_V4_V4_gfx10, 1582 },
    { IMAGE_LOAD_V4_V4_gfx90a, 1637 },
    { IMAGE_LOAD_V4_V4_nsa_gfx10, 1598 },
    { IMAGE_LOAD_V5_V1, 1618 },
    { IMAGE_LOAD_V5_V1_gfx10, 1583 },
    { IMAGE_LOAD_V5_V1_gfx90a, 1638 },
    { IMAGE_LOAD_V5_V2, 1619 },
    { IMAGE_LOAD_V5_V2_gfx10, 1584 },
    { IMAGE_LOAD_V5_V2_gfx90a, 1639 },
    { IMAGE_LOAD_V5_V2_nsa_gfx10, 1599 },
    { IMAGE_LOAD_V5_V3, 1620 },
    { IMAGE_LOAD_V5_V3_gfx10, 1585 },
    { IMAGE_LOAD_V5_V3_gfx90a, 1640 },
    { IMAGE_LOAD_V5_V3_nsa_gfx10, 1600 },
    { IMAGE_LOAD_V5_V4, 1621 },
    { IMAGE_LOAD_V5_V4_gfx10, 1586 },
    { IMAGE_LOAD_V5_V4_gfx90a, 1641 },
    { IMAGE_LOAD_V5_V4_nsa_gfx10, 1601 },
    { IMAGE_MSAA_LOAD_X_V1_V1, 2052 },
    { IMAGE_MSAA_LOAD_X_V1_V1_gfx10, 2017 },
    { IMAGE_MSAA_LOAD_X_V1_V2, 2053 },
    { IMAGE_MSAA_LOAD_X_V1_V2_gfx10, 2018 },
    { IMAGE_MSAA_LOAD_X_V1_V2_nsa_gfx10, 2037 },
    { IMAGE_MSAA_LOAD_X_V1_V3, 2054 },
    { IMAGE_MSAA_LOAD_X_V1_V3_gfx10, 2019 },
    { IMAGE_MSAA_LOAD_X_V1_V3_nsa_gfx10, 2038 },
    { IMAGE_MSAA_LOAD_X_V1_V4, 2055 },
    { IMAGE_MSAA_LOAD_X_V1_V4_gfx10, 2020 },
    { IMAGE_MSAA_LOAD_X_V1_V4_nsa_gfx10, 2039 },
    { IMAGE_MSAA_LOAD_X_V2_V1, 2056 },
    { IMAGE_MSAA_LOAD_X_V2_V1_gfx10, 2021 },
    { IMAGE_MSAA_LOAD_X_V2_V2, 2057 },
    { IMAGE_MSAA_LOAD_X_V2_V2_gfx10, 2022 },
    { IMAGE_MSAA_LOAD_X_V2_V2_nsa_gfx10, 2040 },
    { IMAGE_MSAA_LOAD_X_V2_V3, 2058 },
    { IMAGE_MSAA_LOAD_X_V2_V3_gfx10, 2023 },
    { IMAGE_MSAA_LOAD_X_V2_V3_nsa_gfx10, 2041 },
    { IMAGE_MSAA_LOAD_X_V2_V4, 2059 },
    { IMAGE_MSAA_LOAD_X_V2_V4_gfx10, 2024 },
    { IMAGE_MSAA_LOAD_X_V2_V4_nsa_gfx10, 2042 },
    { IMAGE_MSAA_LOAD_X_V3_V1, 2060 },
    { IMAGE_MSAA_LOAD_X_V3_V1_gfx10, 2025 },
    { IMAGE_MSAA_LOAD_X_V3_V2, 2061 },
    { IMAGE_MSAA_LOAD_X_V3_V2_gfx10, 2026 },
    { IMAGE_MSAA_LOAD_X_V3_V2_nsa_gfx10, 2043 },
    { IMAGE_MSAA_LOAD_X_V3_V3, 2062 },
    { IMAGE_MSAA_LOAD_X_V3_V3_gfx10, 2027 },
    { IMAGE_MSAA_LOAD_X_V3_V3_nsa_gfx10, 2044 },
    { IMAGE_MSAA_LOAD_X_V3_V4, 2063 },
    { IMAGE_MSAA_LOAD_X_V3_V4_gfx10, 2028 },
    { IMAGE_MSAA_LOAD_X_V3_V4_nsa_gfx10, 2045 },
    { IMAGE_MSAA_LOAD_X_V4_V1, 2064 },
    { IMAGE_MSAA_LOAD_X_V4_V1_gfx10, 2029 },
    { IMAGE_MSAA_LOAD_X_V4_V2, 2065 },
    { IMAGE_MSAA_LOAD_X_V4_V2_gfx10, 2030 },
    { IMAGE_MSAA_LOAD_X_V4_V2_nsa_gfx10, 2046 },
    { IMAGE_MSAA_LOAD_X_V4_V3, 2066 },
    { IMAGE_MSAA_LOAD_X_V4_V3_gfx10, 2031 },
    { IMAGE_MSAA_LOAD_X_V4_V3_nsa_gfx10, 2047 },
    { IMAGE_MSAA_LOAD_X_V4_V4, 2067 },
    { IMAGE_MSAA_LOAD_X_V4_V4_gfx10, 2032 },
    { IMAGE_MSAA_LOAD_X_V4_V4_nsa_gfx10, 2048 },
    { IMAGE_MSAA_LOAD_X_V5_V1, 2068 },
    { IMAGE_MSAA_LOAD_X_V5_V1_gfx10, 2033 },
    { IMAGE_MSAA_LOAD_X_V5_V2, 2069 },
    { IMAGE_MSAA_LOAD_X_V5_V2_gfx10, 2034 },
    { IMAGE_MSAA_LOAD_X_V5_V2_nsa_gfx10, 2049 },
    { IMAGE_MSAA_LOAD_X_V5_V3, 2070 },
    { IMAGE_MSAA_LOAD_X_V5_V3_gfx10, 2035 },
    { IMAGE_MSAA_LOAD_X_V5_V3_nsa_gfx10, 2050 },
    { IMAGE_MSAA_LOAD_X_V5_V4, 2071 },
    { IMAGE_MSAA_LOAD_X_V5_V4_gfx10, 2036 },
    { IMAGE_MSAA_LOAD_X_V5_V4_nsa_gfx10, 2051 },
    { IMAGE_SAMPLE_B_CL_O_V1_V3, 2302 },
    { IMAGE_SAMPLE_B_CL_O_V1_V3_gfx10, 2257 },
    { IMAGE_SAMPLE_B_CL_O_V1_V3_nsa_gfx10, 2282 },
    { IMAGE_SAMPLE_B_CL_O_V1_V4, 2303 },
    { IMAGE_SAMPLE_B_CL_O_V1_V4_gfx10, 2258 },
    { IMAGE_SAMPLE_B_CL_O_V1_V4_nsa_gfx10, 2283 },
    { IMAGE_SAMPLE_B_CL_O_V1_V5, 2304 },
    { IMAGE_SAMPLE_B_CL_O_V1_V5_gfx10, 2259 },
    { IMAGE_SAMPLE_B_CL_O_V1_V5_nsa_gfx10, 2284 },
    { IMAGE_SAMPLE_B_CL_O_V1_V6, 2305 },
    { IMAGE_SAMPLE_B_CL_O_V1_V6_gfx10, 2260 },
    { IMAGE_SAMPLE_B_CL_O_V1_V6_nsa_gfx10, 2285 },
    { IMAGE_SAMPLE_B_CL_O_V1_V8, 2306 },
    { IMAGE_SAMPLE_B_CL_O_V1_V8_gfx10, 2261 },
    { IMAGE_SAMPLE_B_CL_O_V2_V3, 2307 },
    { IMAGE_SAMPLE_B_CL_O_V2_V3_gfx10, 2262 },
    { IMAGE_SAMPLE_B_CL_O_V2_V3_nsa_gfx10, 2286 },
    { IMAGE_SAMPLE_B_CL_O_V2_V4, 2308 },
    { IMAGE_SAMPLE_B_CL_O_V2_V4_gfx10, 2263 },
    { IMAGE_SAMPLE_B_CL_O_V2_V4_nsa_gfx10, 2287 },
    { IMAGE_SAMPLE_B_CL_O_V2_V5, 2309 },
    { IMAGE_SAMPLE_B_CL_O_V2_V5_gfx10, 2264 },
    { IMAGE_SAMPLE_B_CL_O_V2_V5_nsa_gfx10, 2288 },
    { IMAGE_SAMPLE_B_CL_O_V2_V6, 2310 },
    { IMAGE_SAMPLE_B_CL_O_V2_V6_gfx10, 2265 },
    { IMAGE_SAMPLE_B_CL_O_V2_V6_nsa_gfx10, 2289 },
    { IMAGE_SAMPLE_B_CL_O_V2_V8, 2311 },
    { IMAGE_SAMPLE_B_CL_O_V2_V8_gfx10, 2266 },
    { IMAGE_SAMPLE_B_CL_O_V3_V3, 2312 },
    { IMAGE_SAMPLE_B_CL_O_V3_V3_gfx10, 2267 },
    { IMAGE_SAMPLE_B_CL_O_V3_V3_nsa_gfx10, 2290 },
    { IMAGE_SAMPLE_B_CL_O_V3_V4, 2313 },
    { IMAGE_SAMPLE_B_CL_O_V3_V4_gfx10, 2268 },
    { IMAGE_SAMPLE_B_CL_O_V3_V4_nsa_gfx10, 2291 },
    { IMAGE_SAMPLE_B_CL_O_V3_V5, 2314 },
    { IMAGE_SAMPLE_B_CL_O_V3_V5_gfx10, 2269 },
    { IMAGE_SAMPLE_B_CL_O_V3_V5_nsa_gfx10, 2292 },
    { IMAGE_SAMPLE_B_CL_O_V3_V6, 2315 },
    { IMAGE_SAMPLE_B_CL_O_V3_V6_gfx10, 2270 },
    { IMAGE_SAMPLE_B_CL_O_V3_V6_nsa_gfx10, 2293 },
    { IMAGE_SAMPLE_B_CL_O_V3_V8, 2316 },
    { IMAGE_SAMPLE_B_CL_O_V3_V8_gfx10, 2271 },
    { IMAGE_SAMPLE_B_CL_O_V4_V3, 2317 },
    { IMAGE_SAMPLE_B_CL_O_V4_V3_gfx10, 2272 },
    { IMAGE_SAMPLE_B_CL_O_V4_V3_nsa_gfx10, 2294 },
    { IMAGE_SAMPLE_B_CL_O_V4_V4, 2318 },
    { IMAGE_SAMPLE_B_CL_O_V4_V4_gfx10, 2273 },
    { IMAGE_SAMPLE_B_CL_O_V4_V4_nsa_gfx10, 2295 },
    { IMAGE_SAMPLE_B_CL_O_V4_V5, 2319 },
    { IMAGE_SAMPLE_B_CL_O_V4_V5_gfx10, 2274 },
    { IMAGE_SAMPLE_B_CL_O_V4_V5_nsa_gfx10, 2296 },
    { IMAGE_SAMPLE_B_CL_O_V4_V6, 2320 },
    { IMAGE_SAMPLE_B_CL_O_V4_V6_gfx10, 2275 },
    { IMAGE_SAMPLE_B_CL_O_V4_V6_nsa_gfx10, 2297 },
    { IMAGE_SAMPLE_B_CL_O_V4_V8, 2321 },
    { IMAGE_SAMPLE_B_CL_O_V4_V8_gfx10, 2276 },
    { IMAGE_SAMPLE_B_CL_O_V5_V3, 2322 },
    { IMAGE_SAMPLE_B_CL_O_V5_V3_gfx10, 2277 },
    { IMAGE_SAMPLE_B_CL_O_V5_V3_nsa_gfx10, 2298 },
    { IMAGE_SAMPLE_B_CL_O_V5_V4, 2323 },
    { IMAGE_SAMPLE_B_CL_O_V5_V4_gfx10, 2278 },
    { IMAGE_SAMPLE_B_CL_O_V5_V4_nsa_gfx10, 2299 },
    { IMAGE_SAMPLE_B_CL_O_V5_V5, 2324 },
    { IMAGE_SAMPLE_B_CL_O_V5_V5_gfx10, 2279 },
    { IMAGE_SAMPLE_B_CL_O_V5_V5_nsa_gfx10, 2300 },
    { IMAGE_SAMPLE_B_CL_O_V5_V6, 2325 },
    { IMAGE_SAMPLE_B_CL_O_V5_V6_gfx10, 2280 },
    { IMAGE_SAMPLE_B_CL_O_V5_V6_nsa_gfx10, 2301 },
    { IMAGE_SAMPLE_B_CL_O_V5_V8, 2326 },
    { IMAGE_SAMPLE_B_CL_O_V5_V8_gfx10, 2281 },
    { IMAGE_SAMPLE_B_CL_V1_V2, 2232 },
    { IMAGE_SAMPLE_B_CL_V1_V2_gfx10, 2187 },
    { IMAGE_SAMPLE_B_CL_V1_V2_nsa_gfx10, 2212 },
    { IMAGE_SAMPLE_B_CL_V1_V3, 2233 },
    { IMAGE_SAMPLE_B_CL_V1_V3_gfx10, 2188 },
    { IMAGE_SAMPLE_B_CL_V1_V3_nsa_gfx10, 2213 },
    { IMAGE_SAMPLE_B_CL_V1_V4, 2234 },
    { IMAGE_SAMPLE_B_CL_V1_V4_gfx10, 2189 },
    { IMAGE_SAMPLE_B_CL_V1_V4_nsa_gfx10, 2214 },
    { IMAGE_SAMPLE_B_CL_V1_V5, 2235 },
    { IMAGE_SAMPLE_B_CL_V1_V5_gfx10, 2190 },
    { IMAGE_SAMPLE_B_CL_V1_V5_nsa_gfx10, 2215 },
    { IMAGE_SAMPLE_B_CL_V1_V8, 2236 },
    { IMAGE_SAMPLE_B_CL_V1_V8_gfx10, 2191 },
    { IMAGE_SAMPLE_B_CL_V2_V2, 2237 },
    { IMAGE_SAMPLE_B_CL_V2_V2_gfx10, 2192 },
    { IMAGE_SAMPLE_B_CL_V2_V2_nsa_gfx10, 2216 },
    { IMAGE_SAMPLE_B_CL_V2_V3, 2238 },
    { IMAGE_SAMPLE_B_CL_V2_V3_gfx10, 2193 },
    { IMAGE_SAMPLE_B_CL_V2_V3_nsa_gfx10, 2217 },
    { IMAGE_SAMPLE_B_CL_V2_V4, 2239 },
    { IMAGE_SAMPLE_B_CL_V2_V4_gfx10, 2194 },
    { IMAGE_SAMPLE_B_CL_V2_V4_nsa_gfx10, 2218 },
    { IMAGE_SAMPLE_B_CL_V2_V5, 2240 },
    { IMAGE_SAMPLE_B_CL_V2_V5_gfx10, 2195 },
    { IMAGE_SAMPLE_B_CL_V2_V5_nsa_gfx10, 2219 },
    { IMAGE_SAMPLE_B_CL_V2_V8, 2241 },
    { IMAGE_SAMPLE_B_CL_V2_V8_gfx10, 2196 },
    { IMAGE_SAMPLE_B_CL_V3_V2, 2242 },
    { IMAGE_SAMPLE_B_CL_V3_V2_gfx10, 2197 },
    { IMAGE_SAMPLE_B_CL_V3_V2_nsa_gfx10, 2220 },
    { IMAGE_SAMPLE_B_CL_V3_V3, 2243 },
    { IMAGE_SAMPLE_B_CL_V3_V3_gfx10, 2198 },
    { IMAGE_SAMPLE_B_CL_V3_V3_nsa_gfx10, 2221 },
    { IMAGE_SAMPLE_B_CL_V3_V4, 2244 },
    { IMAGE_SAMPLE_B_CL_V3_V4_gfx10, 2199 },
    { IMAGE_SAMPLE_B_CL_V3_V4_nsa_gfx10, 2222 },
    { IMAGE_SAMPLE_B_CL_V3_V5, 2245 },
    { IMAGE_SAMPLE_B_CL_V3_V5_gfx10, 2200 },
    { IMAGE_SAMPLE_B_CL_V3_V5_nsa_gfx10, 2223 },
    { IMAGE_SAMPLE_B_CL_V3_V8, 2246 },
    { IMAGE_SAMPLE_B_CL_V3_V8_gfx10, 2201 },
    { IMAGE_SAMPLE_B_CL_V4_V2, 2247 },
    { IMAGE_SAMPLE_B_CL_V4_V2_gfx10, 2202 },
    { IMAGE_SAMPLE_B_CL_V4_V2_nsa_gfx10, 2224 },
    { IMAGE_SAMPLE_B_CL_V4_V3, 2248 },
    { IMAGE_SAMPLE_B_CL_V4_V3_gfx10, 2203 },
    { IMAGE_SAMPLE_B_CL_V4_V3_nsa_gfx10, 2225 },
    { IMAGE_SAMPLE_B_CL_V4_V4, 2249 },
    { IMAGE_SAMPLE_B_CL_V4_V4_gfx10, 2204 },
    { IMAGE_SAMPLE_B_CL_V4_V4_nsa_gfx10, 2226 },
    { IMAGE_SAMPLE_B_CL_V4_V5, 2250 },
    { IMAGE_SAMPLE_B_CL_V4_V5_gfx10, 2205 },
    { IMAGE_SAMPLE_B_CL_V4_V5_nsa_gfx10, 2227 },
    { IMAGE_SAMPLE_B_CL_V4_V8, 2251 },
    { IMAGE_SAMPLE_B_CL_V4_V8_gfx10, 2206 },
    { IMAGE_SAMPLE_B_CL_V5_V2, 2252 },
    { IMAGE_SAMPLE_B_CL_V5_V2_gfx10, 2207 },
    { IMAGE_SAMPLE_B_CL_V5_V2_nsa_gfx10, 2228 },
    { IMAGE_SAMPLE_B_CL_V5_V3, 2253 },
    { IMAGE_SAMPLE_B_CL_V5_V3_gfx10, 2208 },
    { IMAGE_SAMPLE_B_CL_V5_V3_nsa_gfx10, 2229 },
    { IMAGE_SAMPLE_B_CL_V5_V4, 2254 },
    { IMAGE_SAMPLE_B_CL_V5_V4_gfx10, 2209 },
    { IMAGE_SAMPLE_B_CL_V5_V4_nsa_gfx10, 2230 },
    { IMAGE_SAMPLE_B_CL_V5_V5, 2255 },
    { IMAGE_SAMPLE_B_CL_V5_V5_gfx10, 2210 },
    { IMAGE_SAMPLE_B_CL_V5_V5_nsa_gfx10, 2231 },
    { IMAGE_SAMPLE_B_CL_V5_V8, 2256 },
    { IMAGE_SAMPLE_B_CL_V5_V8_gfx10, 2211 },
    { IMAGE_SAMPLE_B_O_V1_V3, 2362 },
    { IMAGE_SAMPLE_B_O_V1_V3_gfx10, 2327 },
    { IMAGE_SAMPLE_B_O_V1_V3_nsa_gfx10, 2347 },
    { IMAGE_SAMPLE_B_O_V1_V4, 2363 },
    { IMAGE_SAMPLE_B_O_V1_V4_gfx10, 2328 },
    { IMAGE_SAMPLE_B_O_V1_V4_nsa_gfx10, 2348 },
    { IMAGE_SAMPLE_B_O_V1_V5, 2364 },
    { IMAGE_SAMPLE_B_O_V1_V5_gfx10, 2329 },
    { IMAGE_SAMPLE_B_O_V1_V5_nsa_gfx10, 2349 },
    { IMAGE_SAMPLE_B_O_V1_V8, 2365 },
    { IMAGE_SAMPLE_B_O_V1_V8_gfx10, 2330 },
    { IMAGE_SAMPLE_B_O_V2_V3, 2366 },
    { IMAGE_SAMPLE_B_O_V2_V3_gfx10, 2331 },
    { IMAGE_SAMPLE_B_O_V2_V3_nsa_gfx10, 2350 },
    { IMAGE_SAMPLE_B_O_V2_V4, 2367 },
    { IMAGE_SAMPLE_B_O_V2_V4_gfx10, 2332 },
    { IMAGE_SAMPLE_B_O_V2_V4_nsa_gfx10, 2351 },
    { IMAGE_SAMPLE_B_O_V2_V5, 2368 },
    { IMAGE_SAMPLE_B_O_V2_V5_gfx10, 2333 },
    { IMAGE_SAMPLE_B_O_V2_V5_nsa_gfx10, 2352 },
    { IMAGE_SAMPLE_B_O_V2_V8, 2369 },
    { IMAGE_SAMPLE_B_O_V2_V8_gfx10, 2334 },
    { IMAGE_SAMPLE_B_O_V3_V3, 2370 },
    { IMAGE_SAMPLE_B_O_V3_V3_gfx10, 2335 },
    { IMAGE_SAMPLE_B_O_V3_V3_nsa_gfx10, 2353 },
    { IMAGE_SAMPLE_B_O_V3_V4, 2371 },
    { IMAGE_SAMPLE_B_O_V3_V4_gfx10, 2336 },
    { IMAGE_SAMPLE_B_O_V3_V4_nsa_gfx10, 2354 },
    { IMAGE_SAMPLE_B_O_V3_V5, 2372 },
    { IMAGE_SAMPLE_B_O_V3_V5_gfx10, 2337 },
    { IMAGE_SAMPLE_B_O_V3_V5_nsa_gfx10, 2355 },
    { IMAGE_SAMPLE_B_O_V3_V8, 2373 },
    { IMAGE_SAMPLE_B_O_V3_V8_gfx10, 2338 },
    { IMAGE_SAMPLE_B_O_V4_V3, 2374 },
    { IMAGE_SAMPLE_B_O_V4_V3_gfx10, 2339 },
    { IMAGE_SAMPLE_B_O_V4_V3_nsa_gfx10, 2356 },
    { IMAGE_SAMPLE_B_O_V4_V4, 2375 },
    { IMAGE_SAMPLE_B_O_V4_V4_gfx10, 2340 },
    { IMAGE_SAMPLE_B_O_V4_V4_nsa_gfx10, 2357 },
    { IMAGE_SAMPLE_B_O_V4_V5, 2376 },
    { IMAGE_SAMPLE_B_O_V4_V5_gfx10, 2341 },
    { IMAGE_SAMPLE_B_O_V4_V5_nsa_gfx10, 2358 },
    { IMAGE_SAMPLE_B_O_V4_V8, 2377 },
    { IMAGE_SAMPLE_B_O_V4_V8_gfx10, 2342 },
    { IMAGE_SAMPLE_B_O_V5_V3, 2378 },
    { IMAGE_SAMPLE_B_O_V5_V3_gfx10, 2343 },
    { IMAGE_SAMPLE_B_O_V5_V3_nsa_gfx10, 2359 },
    { IMAGE_SAMPLE_B_O_V5_V4, 2379 },
    { IMAGE_SAMPLE_B_O_V5_V4_gfx10, 2344 },
    { IMAGE_SAMPLE_B_O_V5_V4_nsa_gfx10, 2360 },
    { IMAGE_SAMPLE_B_O_V5_V5, 2380 },
    { IMAGE_SAMPLE_B_O_V5_V5_gfx10, 2345 },
    { IMAGE_SAMPLE_B_O_V5_V5_nsa_gfx10, 2361 },
    { IMAGE_SAMPLE_B_O_V5_V8, 2381 },
    { IMAGE_SAMPLE_B_O_V5_V8_gfx10, 2346 },
    { IMAGE_SAMPLE_B_V1_V2, 2172 },
    { IMAGE_SAMPLE_B_V1_V2_gfx10, 2142 },
    { IMAGE_SAMPLE_B_V1_V2_nsa_gfx10, 2157 },
    { IMAGE_SAMPLE_B_V1_V3, 2173 },
    { IMAGE_SAMPLE_B_V1_V3_gfx10, 2143 },
    { IMAGE_SAMPLE_B_V1_V3_nsa_gfx10, 2158 },
    { IMAGE_SAMPLE_B_V1_V4, 2174 },
    { IMAGE_SAMPLE_B_V1_V4_gfx10, 2144 },
    { IMAGE_SAMPLE_B_V1_V4_nsa_gfx10, 2159 },
    { IMAGE_SAMPLE_B_V2_V2, 2175 },
    { IMAGE_SAMPLE_B_V2_V2_gfx10, 2145 },
    { IMAGE_SAMPLE_B_V2_V2_nsa_gfx10, 2160 },
    { IMAGE_SAMPLE_B_V2_V3, 2176 },
    { IMAGE_SAMPLE_B_V2_V3_gfx10, 2146 },
    { IMAGE_SAMPLE_B_V2_V3_nsa_gfx10, 2161 },
    { IMAGE_SAMPLE_B_V2_V4, 2177 },
    { IMAGE_SAMPLE_B_V2_V4_gfx10, 2147 },
    { IMAGE_SAMPLE_B_V2_V4_nsa_gfx10, 2162 },
    { IMAGE_SAMPLE_B_V3_V2, 2178 },
    { IMAGE_SAMPLE_B_V3_V2_gfx10, 2148 },
    { IMAGE_SAMPLE_B_V3_V2_nsa_gfx10, 2163 },
    { IMAGE_SAMPLE_B_V3_V3, 2179 },
    { IMAGE_SAMPLE_B_V3_V3_gfx10, 2149 },
    { IMAGE_SAMPLE_B_V3_V3_nsa_gfx10, 2164 },
    { IMAGE_SAMPLE_B_V3_V4, 2180 },
    { IMAGE_SAMPLE_B_V3_V4_gfx10, 2150 },
    { IMAGE_SAMPLE_B_V3_V4_nsa_gfx10, 2165 },
    { IMAGE_SAMPLE_B_V4_V2, 2181 },
    { IMAGE_SAMPLE_B_V4_V2_gfx10, 2151 },
    { IMAGE_SAMPLE_B_V4_V2_nsa_gfx10, 2166 },
    { IMAGE_SAMPLE_B_V4_V3, 2182 },
    { IMAGE_SAMPLE_B_V4_V3_gfx10, 2152 },
    { IMAGE_SAMPLE_B_V4_V3_nsa_gfx10, 2167 },
    { IMAGE_SAMPLE_B_V4_V4, 2183 },
    { IMAGE_SAMPLE_B_V4_V4_gfx10, 2153 },
    { IMAGE_SAMPLE_B_V4_V4_nsa_gfx10, 2168 },
    { IMAGE_SAMPLE_B_V5_V2, 2184 },
    { IMAGE_SAMPLE_B_V5_V2_gfx10, 2154 },
    { IMAGE_SAMPLE_B_V5_V2_nsa_gfx10, 2169 },
    { IMAGE_SAMPLE_B_V5_V3, 2185 },
    { IMAGE_SAMPLE_B_V5_V3_gfx10, 2155 },
    { IMAGE_SAMPLE_B_V5_V3_nsa_gfx10, 2170 },
    { IMAGE_SAMPLE_B_V5_V4, 2186 },
    { IMAGE_SAMPLE_B_V5_V4_gfx10, 2156 },
    { IMAGE_SAMPLE_B_V5_V4_nsa_gfx10, 2171 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V10_nsa_gfx10, 2720 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V16, 2764 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V16_gfx10, 2679 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V2, 2757 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V2_gfx10, 2672 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V2_nsa_gfx10, 2712 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V3, 2758 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V3_gfx10, 2673 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V3_nsa_gfx10, 2713 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V4, 2759 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V4_gfx10, 2674 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V4_nsa_gfx10, 2714 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V5, 2760 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V5_gfx10, 2675 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V5_nsa_gfx10, 2715 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V6, 2761 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V6_gfx10, 2676 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V6_nsa_gfx10, 2716 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V7, 2762 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V7_gfx10, 2677 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V7_nsa_gfx10, 2717 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V8, 2763 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V8_gfx10, 2678 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V8_nsa_gfx10, 2718 },
    { IMAGE_SAMPLE_CD_CL_G16_V1_V9_nsa_gfx10, 2719 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V10_nsa_gfx10, 2729 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V16, 2772 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V16_gfx10, 2687 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V2, 2765 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V2_gfx10, 2680 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V2_nsa_gfx10, 2721 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V3, 2766 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V3_gfx10, 2681 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V3_nsa_gfx10, 2722 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V4, 2767 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V4_gfx10, 2682 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V4_nsa_gfx10, 2723 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V5, 2768 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V5_gfx10, 2683 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V5_nsa_gfx10, 2724 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V6, 2769 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V6_gfx10, 2684 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V6_nsa_gfx10, 2725 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V7, 2770 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V7_gfx10, 2685 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V7_nsa_gfx10, 2726 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V8, 2771 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V8_gfx10, 2686 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V8_nsa_gfx10, 2727 },
    { IMAGE_SAMPLE_CD_CL_G16_V2_V9_nsa_gfx10, 2728 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V10_nsa_gfx10, 2738 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V16, 2780 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V16_gfx10, 2695 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V2, 2773 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V2_gfx10, 2688 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V2_nsa_gfx10, 2730 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V3, 2774 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V3_gfx10, 2689 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V3_nsa_gfx10, 2731 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V4, 2775 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V4_gfx10, 2690 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V4_nsa_gfx10, 2732 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V5, 2776 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V5_gfx10, 2691 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V5_nsa_gfx10, 2733 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V6, 2777 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V6_gfx10, 2692 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V6_nsa_gfx10, 2734 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V7, 2778 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V7_gfx10, 2693 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V7_nsa_gfx10, 2735 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V8, 2779 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V8_gfx10, 2694 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V8_nsa_gfx10, 2736 },
    { IMAGE_SAMPLE_CD_CL_G16_V3_V9_nsa_gfx10, 2737 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V10_nsa_gfx10, 2747 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V16, 2788 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V16_gfx10, 2703 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V2, 2781 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V2_gfx10, 2696 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V2_nsa_gfx10, 2739 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V3, 2782 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V3_gfx10, 2697 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V3_nsa_gfx10, 2740 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V4, 2783 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V4_gfx10, 2698 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V4_nsa_gfx10, 2741 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V5, 2784 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V5_gfx10, 2699 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V5_nsa_gfx10, 2742 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V6, 2785 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V6_gfx10, 2700 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V6_nsa_gfx10, 2743 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V7, 2786 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V7_gfx10, 2701 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V7_nsa_gfx10, 2744 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V8, 2787 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V8_gfx10, 2702 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V8_nsa_gfx10, 2745 },
    { IMAGE_SAMPLE_CD_CL_G16_V4_V9_nsa_gfx10, 2746 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V10_nsa_gfx10, 2756 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V16, 2796 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V16_gfx10, 2711 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V2, 2789 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V2_gfx10, 2704 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V2_nsa_gfx10, 2748 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V3, 2790 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V3_gfx10, 2705 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V3_nsa_gfx10, 2749 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V4, 2791 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V4_gfx10, 2706 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V4_nsa_gfx10, 2750 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V5, 2792 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V5_gfx10, 2707 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V5_nsa_gfx10, 2751 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V6, 2793 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V6_gfx10, 2708 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V6_nsa_gfx10, 2752 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V7, 2794 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V7_gfx10, 2709 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V7_nsa_gfx10, 2753 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V8, 2795 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V8_gfx10, 2710 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V8_nsa_gfx10, 2754 },
    { IMAGE_SAMPLE_CD_CL_G16_V5_V9_nsa_gfx10, 2755 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V10_nsa_gfx10, 2954 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V11_nsa_gfx10, 2955 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V16, 2998 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V16_gfx10, 2918 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V3, 2992 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V3_gfx10, 2912 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V3_nsa_gfx10, 2947 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V4, 2993 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V4_gfx10, 2913 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V4_nsa_gfx10, 2948 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V5, 2994 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V5_gfx10, 2914 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V5_nsa_gfx10, 2949 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V6, 2995 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V6_gfx10, 2915 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V6_nsa_gfx10, 2950 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V7, 2996 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V7_gfx10, 2916 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V7_nsa_gfx10, 2951 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V8, 2997 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V8_gfx10, 2917 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V8_nsa_gfx10, 2952 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V1_V9_nsa_gfx10, 2953 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V10_nsa_gfx10, 2963 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V11_nsa_gfx10, 2964 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V16, 3005 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V16_gfx10, 2925 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V3, 2999 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V3_gfx10, 2919 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V3_nsa_gfx10, 2956 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V4, 3000 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V4_gfx10, 2920 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V4_nsa_gfx10, 2957 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V5, 3001 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V5_gfx10, 2921 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V5_nsa_gfx10, 2958 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V6, 3002 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V6_gfx10, 2922 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V6_nsa_gfx10, 2959 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V7, 3003 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V7_gfx10, 2923 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V7_nsa_gfx10, 2960 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V8, 3004 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V8_gfx10, 2924 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V8_nsa_gfx10, 2961 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V2_V9_nsa_gfx10, 2962 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V10_nsa_gfx10, 2972 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V11_nsa_gfx10, 2973 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V16, 3012 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V16_gfx10, 2932 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V3, 3006 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V3_gfx10, 2926 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V3_nsa_gfx10, 2965 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V4, 3007 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V4_gfx10, 2927 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V4_nsa_gfx10, 2966 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V5, 3008 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V5_gfx10, 2928 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V5_nsa_gfx10, 2967 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V6, 3009 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V6_gfx10, 2929 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V6_nsa_gfx10, 2968 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V7, 3010 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V7_gfx10, 2930 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V7_nsa_gfx10, 2969 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V8, 3011 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V8_gfx10, 2931 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V8_nsa_gfx10, 2970 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V3_V9_nsa_gfx10, 2971 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V10_nsa_gfx10, 2981 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V11_nsa_gfx10, 2982 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V16, 3019 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V16_gfx10, 2939 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V3, 3013 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V3_gfx10, 2933 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V3_nsa_gfx10, 2974 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V4, 3014 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V4_gfx10, 2934 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V4_nsa_gfx10, 2975 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V5, 3015 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V5_gfx10, 2935 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V5_nsa_gfx10, 2976 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V6, 3016 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V6_gfx10, 2936 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V6_nsa_gfx10, 2977 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V7, 3017 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V7_gfx10, 2937 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V7_nsa_gfx10, 2978 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V8, 3018 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V8_gfx10, 2938 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V8_nsa_gfx10, 2979 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V4_V9_nsa_gfx10, 2980 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V10_nsa_gfx10, 2990 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V11_nsa_gfx10, 2991 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V16, 3026 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V16_gfx10, 2946 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V3, 3020 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V3_gfx10, 2940 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V3_nsa_gfx10, 2983 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V4, 3021 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V4_gfx10, 2941 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V4_nsa_gfx10, 2984 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V5, 3022 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V5_gfx10, 2942 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V5_nsa_gfx10, 2985 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V6, 3023 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V6_gfx10, 2943 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V6_nsa_gfx10, 2986 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V7, 3024 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V7_gfx10, 2944 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V7_nsa_gfx10, 2987 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V8, 3025 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V8_gfx10, 2945 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V8_nsa_gfx10, 2988 },
    { IMAGE_SAMPLE_CD_CL_O_G16_V5_V9_nsa_gfx10, 2989 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V10_nsa_gfx10, 2839 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V11_nsa_gfx10, 2840 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V16, 2883 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V16_gfx10, 2803 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V3, 2877 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V3_gfx10, 2797 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V3_nsa_gfx10, 2832 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V4, 2878 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V4_gfx10, 2798 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V4_nsa_gfx10, 2833 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V5, 2879 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V5_gfx10, 2799 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V5_nsa_gfx10, 2834 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V6, 2880 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V6_gfx10, 2800 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V6_nsa_gfx10, 2835 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V7, 2881 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V7_gfx10, 2801 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V7_nsa_gfx10, 2836 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V8, 2882 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V8_gfx10, 2802 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V8_nsa_gfx10, 2837 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V9_nsa_gfx10, 2838 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V10_nsa_gfx10, 2848 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V11_nsa_gfx10, 2849 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V16, 2890 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V16_gfx10, 2810 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V3, 2884 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V3_gfx10, 2804 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V3_nsa_gfx10, 2841 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V4, 2885 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V4_gfx10, 2805 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V4_nsa_gfx10, 2842 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V5, 2886 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V5_gfx10, 2806 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V5_nsa_gfx10, 2843 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V6, 2887 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V6_gfx10, 2807 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V6_nsa_gfx10, 2844 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V7, 2888 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V7_gfx10, 2808 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V7_nsa_gfx10, 2845 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V8, 2889 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V8_gfx10, 2809 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V8_nsa_gfx10, 2846 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V9_nsa_gfx10, 2847 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V10_nsa_gfx10, 2857 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V11_nsa_gfx10, 2858 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V16, 2897 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V16_gfx10, 2817 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V3, 2891 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V3_gfx10, 2811 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V3_nsa_gfx10, 2850 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V4, 2892 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V4_gfx10, 2812 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V4_nsa_gfx10, 2851 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V5, 2893 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V5_gfx10, 2813 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V5_nsa_gfx10, 2852 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V6, 2894 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V6_gfx10, 2814 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V6_nsa_gfx10, 2853 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V7, 2895 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V7_gfx10, 2815 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V7_nsa_gfx10, 2854 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V8, 2896 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V8_gfx10, 2816 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V8_nsa_gfx10, 2855 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V9_nsa_gfx10, 2856 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V10_nsa_gfx10, 2866 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V11_nsa_gfx10, 2867 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V16, 2904 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V16_gfx10, 2824 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V3, 2898 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V3_gfx10, 2818 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V3_nsa_gfx10, 2859 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V4, 2899 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V4_gfx10, 2819 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V4_nsa_gfx10, 2860 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V5, 2900 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V5_gfx10, 2820 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V5_nsa_gfx10, 2861 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V6, 2901 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V6_gfx10, 2821 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V6_nsa_gfx10, 2862 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V7, 2902 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V7_gfx10, 2822 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V7_nsa_gfx10, 2863 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V8, 2903 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V8_gfx10, 2823 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V8_nsa_gfx10, 2864 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V9_nsa_gfx10, 2865 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V10_nsa_gfx10, 2875 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V11_nsa_gfx10, 2876 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V16, 2911 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V16_gfx10, 2831 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V3, 2905 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V3_gfx10, 2825 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V3_nsa_gfx10, 2868 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V4, 2906 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V4_gfx10, 2826 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V4_nsa_gfx10, 2869 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V5, 2907 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V5_gfx10, 2827 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V5_nsa_gfx10, 2870 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V6, 2908 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V6_gfx10, 2828 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V6_nsa_gfx10, 2871 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V7, 2909 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V7_gfx10, 2829 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V7_nsa_gfx10, 2872 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V8, 2910 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V8_gfx10, 2830 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V8_nsa_gfx10, 2873 },
    { IMAGE_SAMPLE_CD_CL_O_V5_V9_nsa_gfx10, 2874 },
    { IMAGE_SAMPLE_CD_CL_V1_V10_nsa_gfx10, 2595 },
    { IMAGE_SAMPLE_CD_CL_V1_V16, 2639 },
    { IMAGE_SAMPLE_CD_CL_V1_V16_gfx10, 2554 },
    { IMAGE_SAMPLE_CD_CL_V1_V2, 2632 },
    { IMAGE_SAMPLE_CD_CL_V1_V2_gfx10, 2547 },
    { IMAGE_SAMPLE_CD_CL_V1_V2_nsa_gfx10, 2587 },
    { IMAGE_SAMPLE_CD_CL_V1_V3, 2633 },
    { IMAGE_SAMPLE_CD_CL_V1_V3_gfx10, 2548 },
    { IMAGE_SAMPLE_CD_CL_V1_V3_nsa_gfx10, 2588 },
    { IMAGE_SAMPLE_CD_CL_V1_V4, 2634 },
    { IMAGE_SAMPLE_CD_CL_V1_V4_gfx10, 2549 },
    { IMAGE_SAMPLE_CD_CL_V1_V4_nsa_gfx10, 2589 },
    { IMAGE_SAMPLE_CD_CL_V1_V5, 2635 },
    { IMAGE_SAMPLE_CD_CL_V1_V5_gfx10, 2550 },
    { IMAGE_SAMPLE_CD_CL_V1_V5_nsa_gfx10, 2590 },
    { IMAGE_SAMPLE_CD_CL_V1_V6, 2636 },
    { IMAGE_SAMPLE_CD_CL_V1_V6_gfx10, 2551 },
    { IMAGE_SAMPLE_CD_CL_V1_V6_nsa_gfx10, 2591 },
    { IMAGE_SAMPLE_CD_CL_V1_V7, 2637 },
    { IMAGE_SAMPLE_CD_CL_V1_V7_gfx10, 2552 },
    { IMAGE_SAMPLE_CD_CL_V1_V7_nsa_gfx10, 2592 },
    { IMAGE_SAMPLE_CD_CL_V1_V8, 2638 },
    { IMAGE_SAMPLE_CD_CL_V1_V8_gfx10, 2553 },
    { IMAGE_SAMPLE_CD_CL_V1_V8_nsa_gfx10, 2593 },
    { IMAGE_SAMPLE_CD_CL_V1_V9_nsa_gfx10, 2594 },
    { IMAGE_SAMPLE_CD_CL_V2_V10_nsa_gfx10, 2604 },
    { IMAGE_SAMPLE_CD_CL_V2_V16, 2647 },
    { IMAGE_SAMPLE_CD_CL_V2_V16_gfx10, 2562 },
    { IMAGE_SAMPLE_CD_CL_V2_V2, 2640 },
    { IMAGE_SAMPLE_CD_CL_V2_V2_gfx10, 2555 },
    { IMAGE_SAMPLE_CD_CL_V2_V2_nsa_gfx10, 2596 },
    { IMAGE_SAMPLE_CD_CL_V2_V3, 2641 },
    { IMAGE_SAMPLE_CD_CL_V2_V3_gfx10, 2556 },
    { IMAGE_SAMPLE_CD_CL_V2_V3_nsa_gfx10, 2597 },
    { IMAGE_SAMPLE_CD_CL_V2_V4, 2642 },
    { IMAGE_SAMPLE_CD_CL_V2_V4_gfx10, 2557 },
    { IMAGE_SAMPLE_CD_CL_V2_V4_nsa_gfx10, 2598 },
    { IMAGE_SAMPLE_CD_CL_V2_V5, 2643 },
    { IMAGE_SAMPLE_CD_CL_V2_V5_gfx10, 2558 },
    { IMAGE_SAMPLE_CD_CL_V2_V5_nsa_gfx10, 2599 },
    { IMAGE_SAMPLE_CD_CL_V2_V6, 2644 },
    { IMAGE_SAMPLE_CD_CL_V2_V6_gfx10, 2559 },
    { IMAGE_SAMPLE_CD_CL_V2_V6_nsa_gfx10, 2600 },
    { IMAGE_SAMPLE_CD_CL_V2_V7, 2645 },
    { IMAGE_SAMPLE_CD_CL_V2_V7_gfx10, 2560 },
    { IMAGE_SAMPLE_CD_CL_V2_V7_nsa_gfx10, 2601 },
    { IMAGE_SAMPLE_CD_CL_V2_V8, 2646 },
    { IMAGE_SAMPLE_CD_CL_V2_V8_gfx10, 2561 },
    { IMAGE_SAMPLE_CD_CL_V2_V8_nsa_gfx10, 2602 },
    { IMAGE_SAMPLE_CD_CL_V2_V9_nsa_gfx10, 2603 },
    { IMAGE_SAMPLE_CD_CL_V3_V10_nsa_gfx10, 2613 },
    { IMAGE_SAMPLE_CD_CL_V3_V16, 2655 },
    { IMAGE_SAMPLE_CD_CL_V3_V16_gfx10, 2570 },
    { IMAGE_SAMPLE_CD_CL_V3_V2, 2648 },
    { IMAGE_SAMPLE_CD_CL_V3_V2_gfx10, 2563 },
    { IMAGE_SAMPLE_CD_CL_V3_V2_nsa_gfx10, 2605 },
    { IMAGE_SAMPLE_CD_CL_V3_V3, 2649 },
    { IMAGE_SAMPLE_CD_CL_V3_V3_gfx10, 2564 },
    { IMAGE_SAMPLE_CD_CL_V3_V3_nsa_gfx10, 2606 },
    { IMAGE_SAMPLE_CD_CL_V3_V4, 2650 },
    { IMAGE_SAMPLE_CD_CL_V3_V4_gfx10, 2565 },
    { IMAGE_SAMPLE_CD_CL_V3_V4_nsa_gfx10, 2607 },
    { IMAGE_SAMPLE_CD_CL_V3_V5, 2651 },
    { IMAGE_SAMPLE_CD_CL_V3_V5_gfx10, 2566 },
    { IMAGE_SAMPLE_CD_CL_V3_V5_nsa_gfx10, 2608 },
    { IMAGE_SAMPLE_CD_CL_V3_V6, 2652 },
    { IMAGE_SAMPLE_CD_CL_V3_V6_gfx10, 2567 },
    { IMAGE_SAMPLE_CD_CL_V3_V6_nsa_gfx10, 2609 },
    { IMAGE_SAMPLE_CD_CL_V3_V7, 2653 },
    { IMAGE_SAMPLE_CD_CL_V3_V7_gfx10, 2568 },
    { IMAGE_SAMPLE_CD_CL_V3_V7_nsa_gfx10, 2610 },
    { IMAGE_SAMPLE_CD_CL_V3_V8, 2654 },
    { IMAGE_SAMPLE_CD_CL_V3_V8_gfx10, 2569 },
    { IMAGE_SAMPLE_CD_CL_V3_V8_nsa_gfx10, 2611 },
    { IMAGE_SAMPLE_CD_CL_V3_V9_nsa_gfx10, 2612 },
    { IMAGE_SAMPLE_CD_CL_V4_V10_nsa_gfx10, 2622 },
    { IMAGE_SAMPLE_CD_CL_V4_V16, 2663 },
    { IMAGE_SAMPLE_CD_CL_V4_V16_gfx10, 2578 },
    { IMAGE_SAMPLE_CD_CL_V4_V2, 2656 },
    { IMAGE_SAMPLE_CD_CL_V4_V2_gfx10, 2571 },
    { IMAGE_SAMPLE_CD_CL_V4_V2_nsa_gfx10, 2614 },
    { IMAGE_SAMPLE_CD_CL_V4_V3, 2657 },
    { IMAGE_SAMPLE_CD_CL_V4_V3_gfx10, 2572 },
    { IMAGE_SAMPLE_CD_CL_V4_V3_nsa_gfx10, 2615 },
    { IMAGE_SAMPLE_CD_CL_V4_V4, 2658 },
    { IMAGE_SAMPLE_CD_CL_V4_V4_gfx10, 2573 },
    { IMAGE_SAMPLE_CD_CL_V4_V4_nsa_gfx10, 2616 },
    { IMAGE_SAMPLE_CD_CL_V4_V5, 2659 },
    { IMAGE_SAMPLE_CD_CL_V4_V5_gfx10, 2574 },
    { IMAGE_SAMPLE_CD_CL_V4_V5_nsa_gfx10, 2617 },
    { IMAGE_SAMPLE_CD_CL_V4_V6, 2660 },
    { IMAGE_SAMPLE_CD_CL_V4_V6_gfx10, 2575 },
    { IMAGE_SAMPLE_CD_CL_V4_V6_nsa_gfx10, 2618 },
    { IMAGE_SAMPLE_CD_CL_V4_V7, 2661 },
    { IMAGE_SAMPLE_CD_CL_V4_V7_gfx10, 2576 },
    { IMAGE_SAMPLE_CD_CL_V4_V7_nsa_gfx10, 2619 },
    { IMAGE_SAMPLE_CD_CL_V4_V8, 2662 },
    { IMAGE_SAMPLE_CD_CL_V4_V8_gfx10, 2577 },
    { IMAGE_SAMPLE_CD_CL_V4_V8_nsa_gfx10, 2620 },
    { IMAGE_SAMPLE_CD_CL_V4_V9_nsa_gfx10, 2621 },
    { IMAGE_SAMPLE_CD_CL_V5_V10_nsa_gfx10, 2631 },
    { IMAGE_SAMPLE_CD_CL_V5_V16, 2671 },
    { IMAGE_SAMPLE_CD_CL_V5_V16_gfx10, 2586 },
    { IMAGE_SAMPLE_CD_CL_V5_V2, 2664 },
    { IMAGE_SAMPLE_CD_CL_V5_V2_gfx10, 2579 },
    { IMAGE_SAMPLE_CD_CL_V5_V2_nsa_gfx10, 2623 },
    { IMAGE_SAMPLE_CD_CL_V5_V3, 2665 },
    { IMAGE_SAMPLE_CD_CL_V5_V3_gfx10, 2580 },
    { IMAGE_SAMPLE_CD_CL_V5_V3_nsa_gfx10, 2624 },
    { IMAGE_SAMPLE_CD_CL_V5_V4, 2666 },
    { IMAGE_SAMPLE_CD_CL_V5_V4_gfx10, 2581 },
    { IMAGE_SAMPLE_CD_CL_V5_V4_nsa_gfx10, 2625 },
    { IMAGE_SAMPLE_CD_CL_V5_V5, 2667 },
    { IMAGE_SAMPLE_CD_CL_V5_V5_gfx10, 2582 },
    { IMAGE_SAMPLE_CD_CL_V5_V5_nsa_gfx10, 2626 },
    { IMAGE_SAMPLE_CD_CL_V5_V6, 2668 },
    { IMAGE_SAMPLE_CD_CL_V5_V6_gfx10, 2583 },
    { IMAGE_SAMPLE_CD_CL_V5_V6_nsa_gfx10, 2627 },
    { IMAGE_SAMPLE_CD_CL_V5_V7, 2669 },
    { IMAGE_SAMPLE_CD_CL_V5_V7_gfx10, 2584 },
    { IMAGE_SAMPLE_CD_CL_V5_V7_nsa_gfx10, 2628 },
    { IMAGE_SAMPLE_CD_CL_V5_V8, 2670 },
    { IMAGE_SAMPLE_CD_CL_V5_V8_gfx10, 2585 },
    { IMAGE_SAMPLE_CD_CL_V5_V8_nsa_gfx10, 2629 },
    { IMAGE_SAMPLE_CD_CL_V5_V9_nsa_gfx10, 2630 },
    { IMAGE_SAMPLE_CD_G16_V1_V16, 3114 },
    { IMAGE_SAMPLE_CD_G16_V1_V16_gfx10, 3034 },
    { IMAGE_SAMPLE_CD_G16_V1_V2, 3107 },
    { IMAGE_SAMPLE_CD_G16_V1_V2_gfx10, 3027 },
    { IMAGE_SAMPLE_CD_G16_V1_V2_nsa_gfx10, 3067 },
    { IMAGE_SAMPLE_CD_G16_V1_V3, 3108 },
    { IMAGE_SAMPLE_CD_G16_V1_V3_gfx10, 3028 },
    { IMAGE_SAMPLE_CD_G16_V1_V3_nsa_gfx10, 3068 },
    { IMAGE_SAMPLE_CD_G16_V1_V4, 3109 },
    { IMAGE_SAMPLE_CD_G16_V1_V4_gfx10, 3029 },
    { IMAGE_SAMPLE_CD_G16_V1_V4_nsa_gfx10, 3069 },
    { IMAGE_SAMPLE_CD_G16_V1_V5, 3110 },
    { IMAGE_SAMPLE_CD_G16_V1_V5_gfx10, 3030 },
    { IMAGE_SAMPLE_CD_G16_V1_V5_nsa_gfx10, 3070 },
    { IMAGE_SAMPLE_CD_G16_V1_V6, 3111 },
    { IMAGE_SAMPLE_CD_G16_V1_V6_gfx10, 3031 },
    { IMAGE_SAMPLE_CD_G16_V1_V6_nsa_gfx10, 3071 },
    { IMAGE_SAMPLE_CD_G16_V1_V7, 3112 },
    { IMAGE_SAMPLE_CD_G16_V1_V7_gfx10, 3032 },
    { IMAGE_SAMPLE_CD_G16_V1_V7_nsa_gfx10, 3072 },
    { IMAGE_SAMPLE_CD_G16_V1_V8, 3113 },
    { IMAGE_SAMPLE_CD_G16_V1_V8_gfx10, 3033 },
    { IMAGE_SAMPLE_CD_G16_V1_V8_nsa_gfx10, 3073 },
    { IMAGE_SAMPLE_CD_G16_V1_V9_nsa_gfx10, 3074 },
    { IMAGE_SAMPLE_CD_G16_V2_V16, 3122 },
    { IMAGE_SAMPLE_CD_G16_V2_V16_gfx10, 3042 },
    { IMAGE_SAMPLE_CD_G16_V2_V2, 3115 },
    { IMAGE_SAMPLE_CD_G16_V2_V2_gfx10, 3035 },
    { IMAGE_SAMPLE_CD_G16_V2_V2_nsa_gfx10, 3075 },
    { IMAGE_SAMPLE_CD_G16_V2_V3, 3116 },
    { IMAGE_SAMPLE_CD_G16_V2_V3_gfx10, 3036 },
    { IMAGE_SAMPLE_CD_G16_V2_V3_nsa_gfx10, 3076 },
    { IMAGE_SAMPLE_CD_G16_V2_V4, 3117 },
    { IMAGE_SAMPLE_CD_G16_V2_V4_gfx10, 3037 },
    { IMAGE_SAMPLE_CD_G16_V2_V4_nsa_gfx10, 3077 },
    { IMAGE_SAMPLE_CD_G16_V2_V5, 3118 },
    { IMAGE_SAMPLE_CD_G16_V2_V5_gfx10, 3038 },
    { IMAGE_SAMPLE_CD_G16_V2_V5_nsa_gfx10, 3078 },
    { IMAGE_SAMPLE_CD_G16_V2_V6, 3119 },
    { IMAGE_SAMPLE_CD_G16_V2_V6_gfx10, 3039 },
    { IMAGE_SAMPLE_CD_G16_V2_V6_nsa_gfx10, 3079 },
    { IMAGE_SAMPLE_CD_G16_V2_V7, 3120 },
    { IMAGE_SAMPLE_CD_G16_V2_V7_gfx10, 3040 },
    { IMAGE_SAMPLE_CD_G16_V2_V7_nsa_gfx10, 3080 },
    { IMAGE_SAMPLE_CD_G16_V2_V8, 3121 },
    { IMAGE_SAMPLE_CD_G16_V2_V8_gfx10, 3041 },
    { IMAGE_SAMPLE_CD_G16_V2_V8_nsa_gfx10, 3081 },
    { IMAGE_SAMPLE_CD_G16_V2_V9_nsa_gfx10, 3082 },
    { IMAGE_SAMPLE_CD_G16_V3_V16, 3130 },
    { IMAGE_SAMPLE_CD_G16_V3_V16_gfx10, 3050 },
    { IMAGE_SAMPLE_CD_G16_V3_V2, 3123 },
    { IMAGE_SAMPLE_CD_G16_V3_V2_gfx10, 3043 },
    { IMAGE_SAMPLE_CD_G16_V3_V2_nsa_gfx10, 3083 },
    { IMAGE_SAMPLE_CD_G16_V3_V3, 3124 },
    { IMAGE_SAMPLE_CD_G16_V3_V3_gfx10, 3044 },
    { IMAGE_SAMPLE_CD_G16_V3_V3_nsa_gfx10, 3084 },
    { IMAGE_SAMPLE_CD_G16_V3_V4, 3125 },
    { IMAGE_SAMPLE_CD_G16_V3_V4_gfx10, 3045 },
    { IMAGE_SAMPLE_CD_G16_V3_V4_nsa_gfx10, 3085 },
    { IMAGE_SAMPLE_CD_G16_V3_V5, 3126 },
    { IMAGE_SAMPLE_CD_G16_V3_V5_gfx10, 3046 },
    { IMAGE_SAMPLE_CD_G16_V3_V5_nsa_gfx10, 3086 },
    { IMAGE_SAMPLE_CD_G16_V3_V6, 3127 },
    { IMAGE_SAMPLE_CD_G16_V3_V6_gfx10, 3047 },
    { IMAGE_SAMPLE_CD_G16_V3_V6_nsa_gfx10, 3087 },
    { IMAGE_SAMPLE_CD_G16_V3_V7, 3128 },
    { IMAGE_SAMPLE_CD_G16_V3_V7_gfx10, 3048 },
    { IMAGE_SAMPLE_CD_G16_V3_V7_nsa_gfx10, 3088 },
    { IMAGE_SAMPLE_CD_G16_V3_V8, 3129 },
    { IMAGE_SAMPLE_CD_G16_V3_V8_gfx10, 3049 },
    { IMAGE_SAMPLE_CD_G16_V3_V8_nsa_gfx10, 3089 },
    { IMAGE_SAMPLE_CD_G16_V3_V9_nsa_gfx10, 3090 },
    { IMAGE_SAMPLE_CD_G16_V4_V16, 3138 },
    { IMAGE_SAMPLE_CD_G16_V4_V16_gfx10, 3058 },
    { IMAGE_SAMPLE_CD_G16_V4_V2, 3131 },
    { IMAGE_SAMPLE_CD_G16_V4_V2_gfx10, 3051 },
    { IMAGE_SAMPLE_CD_G16_V4_V2_nsa_gfx10, 3091 },
    { IMAGE_SAMPLE_CD_G16_V4_V3, 3132 },
    { IMAGE_SAMPLE_CD_G16_V4_V3_gfx10, 3052 },
    { IMAGE_SAMPLE_CD_G16_V4_V3_nsa_gfx10, 3092 },
    { IMAGE_SAMPLE_CD_G16_V4_V4, 3133 },
    { IMAGE_SAMPLE_CD_G16_V4_V4_gfx10, 3053 },
    { IMAGE_SAMPLE_CD_G16_V4_V4_nsa_gfx10, 3093 },
    { IMAGE_SAMPLE_CD_G16_V4_V5, 3134 },
    { IMAGE_SAMPLE_CD_G16_V4_V5_gfx10, 3054 },
    { IMAGE_SAMPLE_CD_G16_V4_V5_nsa_gfx10, 3094 },
    { IMAGE_SAMPLE_CD_G16_V4_V6, 3135 },
    { IMAGE_SAMPLE_CD_G16_V4_V6_gfx10, 3055 },
    { IMAGE_SAMPLE_CD_G16_V4_V6_nsa_gfx10, 3095 },
    { IMAGE_SAMPLE_CD_G16_V4_V7, 3136 },
    { IMAGE_SAMPLE_CD_G16_V4_V7_gfx10, 3056 },
    { IMAGE_SAMPLE_CD_G16_V4_V7_nsa_gfx10, 3096 },
    { IMAGE_SAMPLE_CD_G16_V4_V8, 3137 },
    { IMAGE_SAMPLE_CD_G16_V4_V8_gfx10, 3057 },
    { IMAGE_SAMPLE_CD_G16_V4_V8_nsa_gfx10, 3097 },
    { IMAGE_SAMPLE_CD_G16_V4_V9_nsa_gfx10, 3098 },
    { IMAGE_SAMPLE_CD_G16_V5_V16, 3146 },
    { IMAGE_SAMPLE_CD_G16_V5_V16_gfx10, 3066 },
    { IMAGE_SAMPLE_CD_G16_V5_V2, 3139 },
    { IMAGE_SAMPLE_CD_G16_V5_V2_gfx10, 3059 },
    { IMAGE_SAMPLE_CD_G16_V5_V2_nsa_gfx10, 3099 },
    { IMAGE_SAMPLE_CD_G16_V5_V3, 3140 },
    { IMAGE_SAMPLE_CD_G16_V5_V3_gfx10, 3060 },
    { IMAGE_SAMPLE_CD_G16_V5_V3_nsa_gfx10, 3100 },
    { IMAGE_SAMPLE_CD_G16_V5_V4, 3141 },
    { IMAGE_SAMPLE_CD_G16_V5_V4_gfx10, 3061 },
    { IMAGE_SAMPLE_CD_G16_V5_V4_nsa_gfx10, 3101 },
    { IMAGE_SAMPLE_CD_G16_V5_V5, 3142 },
    { IMAGE_SAMPLE_CD_G16_V5_V5_gfx10, 3062 },
    { IMAGE_SAMPLE_CD_G16_V5_V5_nsa_gfx10, 3102 },
    { IMAGE_SAMPLE_CD_G16_V5_V6, 3143 },
    { IMAGE_SAMPLE_CD_G16_V5_V6_gfx10, 3063 },
    { IMAGE_SAMPLE_CD_G16_V5_V6_nsa_gfx10, 3103 },
    { IMAGE_SAMPLE_CD_G16_V5_V7, 3144 },
    { IMAGE_SAMPLE_CD_G16_V5_V7_gfx10, 3064 },
    { IMAGE_SAMPLE_CD_G16_V5_V7_nsa_gfx10, 3104 },
    { IMAGE_SAMPLE_CD_G16_V5_V8, 3145 },
    { IMAGE_SAMPLE_CD_G16_V5_V8_gfx10, 3065 },
    { IMAGE_SAMPLE_CD_G16_V5_V8_nsa_gfx10, 3105 },
    { IMAGE_SAMPLE_CD_G16_V5_V9_nsa_gfx10, 3106 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V10_nsa_gfx10, 3299 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V16, 3338 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V16_gfx10, 3263 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V3, 3332 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V3_gfx10, 3257 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V3_nsa_gfx10, 3292 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V4, 3333 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V4_gfx10, 3258 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V4_nsa_gfx10, 3293 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V5, 3334 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V5_gfx10, 3259 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V5_nsa_gfx10, 3294 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V6, 3335 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V6_gfx10, 3260 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V6_nsa_gfx10, 3295 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V7, 3336 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V7_gfx10, 3261 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V7_nsa_gfx10, 3296 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V8, 3337 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V8_gfx10, 3262 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V8_nsa_gfx10, 3297 },
    { IMAGE_SAMPLE_CD_O_G16_V1_V9_nsa_gfx10, 3298 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V10_nsa_gfx10, 3307 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V16, 3345 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V16_gfx10, 3270 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V3, 3339 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V3_gfx10, 3264 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V3_nsa_gfx10, 3300 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V4, 3340 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V4_gfx10, 3265 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V4_nsa_gfx10, 3301 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V5, 3341 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V5_gfx10, 3266 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V5_nsa_gfx10, 3302 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V6, 3342 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V6_gfx10, 3267 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V6_nsa_gfx10, 3303 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V7, 3343 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V7_gfx10, 3268 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V7_nsa_gfx10, 3304 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V8, 3344 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V8_gfx10, 3269 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V8_nsa_gfx10, 3305 },
    { IMAGE_SAMPLE_CD_O_G16_V2_V9_nsa_gfx10, 3306 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V10_nsa_gfx10, 3315 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V16, 3352 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V16_gfx10, 3277 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V3, 3346 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V3_gfx10, 3271 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V3_nsa_gfx10, 3308 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V4, 3347 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V4_gfx10, 3272 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V4_nsa_gfx10, 3309 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V5, 3348 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V5_gfx10, 3273 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V5_nsa_gfx10, 3310 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V6, 3349 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V6_gfx10, 3274 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V6_nsa_gfx10, 3311 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V7, 3350 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V7_gfx10, 3275 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V7_nsa_gfx10, 3312 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V8, 3351 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V8_gfx10, 3276 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V8_nsa_gfx10, 3313 },
    { IMAGE_SAMPLE_CD_O_G16_V3_V9_nsa_gfx10, 3314 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V10_nsa_gfx10, 3323 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V16, 3359 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V16_gfx10, 3284 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V3, 3353 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V3_gfx10, 3278 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V3_nsa_gfx10, 3316 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V4, 3354 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V4_gfx10, 3279 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V4_nsa_gfx10, 3317 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V5, 3355 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V5_gfx10, 3280 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V5_nsa_gfx10, 3318 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V6, 3356 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V6_gfx10, 3281 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V6_nsa_gfx10, 3319 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V7, 3357 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V7_gfx10, 3282 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V7_nsa_gfx10, 3320 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V8, 3358 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V8_gfx10, 3283 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V8_nsa_gfx10, 3321 },
    { IMAGE_SAMPLE_CD_O_G16_V4_V9_nsa_gfx10, 3322 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V10_nsa_gfx10, 3331 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V16, 3366 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V16_gfx10, 3291 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V3, 3360 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V3_gfx10, 3285 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V3_nsa_gfx10, 3324 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V4, 3361 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V4_gfx10, 3286 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V4_nsa_gfx10, 3325 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V5, 3362 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V5_gfx10, 3287 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V5_nsa_gfx10, 3326 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V6, 3363 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V6_gfx10, 3288 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V6_nsa_gfx10, 3327 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V7, 3364 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V7_gfx10, 3289 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V7_nsa_gfx10, 3328 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V8, 3365 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V8_gfx10, 3290 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V8_nsa_gfx10, 3329 },
    { IMAGE_SAMPLE_CD_O_G16_V5_V9_nsa_gfx10, 3330 },
    { IMAGE_SAMPLE_CD_O_V1_V10_nsa_gfx10, 3189 },
    { IMAGE_SAMPLE_CD_O_V1_V16, 3228 },
    { IMAGE_SAMPLE_CD_O_V1_V16_gfx10, 3153 },
    { IMAGE_SAMPLE_CD_O_V1_V3, 3222 },
    { IMAGE_SAMPLE_CD_O_V1_V3_gfx10, 3147 },
    { IMAGE_SAMPLE_CD_O_V1_V3_nsa_gfx10, 3182 },
    { IMAGE_SAMPLE_CD_O_V1_V4, 3223 },
    { IMAGE_SAMPLE_CD_O_V1_V4_gfx10, 3148 },
    { IMAGE_SAMPLE_CD_O_V1_V4_nsa_gfx10, 3183 },
    { IMAGE_SAMPLE_CD_O_V1_V5, 3224 },
    { IMAGE_SAMPLE_CD_O_V1_V5_gfx10, 3149 },
    { IMAGE_SAMPLE_CD_O_V1_V5_nsa_gfx10, 3184 },
    { IMAGE_SAMPLE_CD_O_V1_V6, 3225 },
    { IMAGE_SAMPLE_CD_O_V1_V6_gfx10, 3150 },
    { IMAGE_SAMPLE_CD_O_V1_V6_nsa_gfx10, 3185 },
    { IMAGE_SAMPLE_CD_O_V1_V7, 3226 },
    { IMAGE_SAMPLE_CD_O_V1_V7_gfx10, 3151 },
    { IMAGE_SAMPLE_CD_O_V1_V7_nsa_gfx10, 3186 },
    { IMAGE_SAMPLE_CD_O_V1_V8, 3227 },
    { IMAGE_SAMPLE_CD_O_V1_V8_gfx10, 3152 },
    { IMAGE_SAMPLE_CD_O_V1_V8_nsa_gfx10, 3187 },
    { IMAGE_SAMPLE_CD_O_V1_V9_nsa_gfx10, 3188 },
    { IMAGE_SAMPLE_CD_O_V2_V10_nsa_gfx10, 3197 },
    { IMAGE_SAMPLE_CD_O_V2_V16, 3235 },
    { IMAGE_SAMPLE_CD_O_V2_V16_gfx10, 3160 },
    { IMAGE_SAMPLE_CD_O_V2_V3, 3229 },
    { IMAGE_SAMPLE_CD_O_V2_V3_gfx10, 3154 },
    { IMAGE_SAMPLE_CD_O_V2_V3_nsa_gfx10, 3190 },
    { IMAGE_SAMPLE_CD_O_V2_V4, 3230 },
    { IMAGE_SAMPLE_CD_O_V2_V4_gfx10, 3155 },
    { IMAGE_SAMPLE_CD_O_V2_V4_nsa_gfx10, 3191 },
    { IMAGE_SAMPLE_CD_O_V2_V5, 3231 },
    { IMAGE_SAMPLE_CD_O_V2_V5_gfx10, 3156 },
    { IMAGE_SAMPLE_CD_O_V2_V5_nsa_gfx10, 3192 },
    { IMAGE_SAMPLE_CD_O_V2_V6, 3232 },
    { IMAGE_SAMPLE_CD_O_V2_V6_gfx10, 3157 },
    { IMAGE_SAMPLE_CD_O_V2_V6_nsa_gfx10, 3193 },
    { IMAGE_SAMPLE_CD_O_V2_V7, 3233 },
    { IMAGE_SAMPLE_CD_O_V2_V7_gfx10, 3158 },
    { IMAGE_SAMPLE_CD_O_V2_V7_nsa_gfx10, 3194 },
    { IMAGE_SAMPLE_CD_O_V2_V8, 3234 },
    { IMAGE_SAMPLE_CD_O_V2_V8_gfx10, 3159 },
    { IMAGE_SAMPLE_CD_O_V2_V8_nsa_gfx10, 3195 },
    { IMAGE_SAMPLE_CD_O_V2_V9_nsa_gfx10, 3196 },
    { IMAGE_SAMPLE_CD_O_V3_V10_nsa_gfx10, 3205 },
    { IMAGE_SAMPLE_CD_O_V3_V16, 3242 },
    { IMAGE_SAMPLE_CD_O_V3_V16_gfx10, 3167 },
    { IMAGE_SAMPLE_CD_O_V3_V3, 3236 },
    { IMAGE_SAMPLE_CD_O_V3_V3_gfx10, 3161 },
    { IMAGE_SAMPLE_CD_O_V3_V3_nsa_gfx10, 3198 },
    { IMAGE_SAMPLE_CD_O_V3_V4, 3237 },
    { IMAGE_SAMPLE_CD_O_V3_V4_gfx10, 3162 },
    { IMAGE_SAMPLE_CD_O_V3_V4_nsa_gfx10, 3199 },
    { IMAGE_SAMPLE_CD_O_V3_V5, 3238 },
    { IMAGE_SAMPLE_CD_O_V3_V5_gfx10, 3163 },
    { IMAGE_SAMPLE_CD_O_V3_V5_nsa_gfx10, 3200 },
    { IMAGE_SAMPLE_CD_O_V3_V6, 3239 },
    { IMAGE_SAMPLE_CD_O_V3_V6_gfx10, 3164 },
    { IMAGE_SAMPLE_CD_O_V3_V6_nsa_gfx10, 3201 },
    { IMAGE_SAMPLE_CD_O_V3_V7, 3240 },
    { IMAGE_SAMPLE_CD_O_V3_V7_gfx10, 3165 },
    { IMAGE_SAMPLE_CD_O_V3_V7_nsa_gfx10, 3202 },
    { IMAGE_SAMPLE_CD_O_V3_V8, 3241 },
    { IMAGE_SAMPLE_CD_O_V3_V8_gfx10, 3166 },
    { IMAGE_SAMPLE_CD_O_V3_V8_nsa_gfx10, 3203 },
    { IMAGE_SAMPLE_CD_O_V3_V9_nsa_gfx10, 3204 },
    { IMAGE_SAMPLE_CD_O_V4_V10_nsa_gfx10, 3213 },
    { IMAGE_SAMPLE_CD_O_V4_V16, 3249 },
    { IMAGE_SAMPLE_CD_O_V4_V16_gfx10, 3174 },
    { IMAGE_SAMPLE_CD_O_V4_V3, 3243 },
    { IMAGE_SAMPLE_CD_O_V4_V3_gfx10, 3168 },
    { IMAGE_SAMPLE_CD_O_V4_V3_nsa_gfx10, 3206 },
    { IMAGE_SAMPLE_CD_O_V4_V4, 3244 },
    { IMAGE_SAMPLE_CD_O_V4_V4_gfx10, 3169 },
    { IMAGE_SAMPLE_CD_O_V4_V4_nsa_gfx10, 3207 },
    { IMAGE_SAMPLE_CD_O_V4_V5, 3245 },
    { IMAGE_SAMPLE_CD_O_V4_V5_gfx10, 3170 },
    { IMAGE_SAMPLE_CD_O_V4_V5_nsa_gfx10, 3208 },
    { IMAGE_SAMPLE_CD_O_V4_V6, 3246 },
    { IMAGE_SAMPLE_CD_O_V4_V6_gfx10, 3171 },
    { IMAGE_SAMPLE_CD_O_V4_V6_nsa_gfx10, 3209 },
    { IMAGE_SAMPLE_CD_O_V4_V7, 3247 },
    { IMAGE_SAMPLE_CD_O_V4_V7_gfx10, 3172 },
    { IMAGE_SAMPLE_CD_O_V4_V7_nsa_gfx10, 3210 },
    { IMAGE_SAMPLE_CD_O_V4_V8, 3248 },
    { IMAGE_SAMPLE_CD_O_V4_V8_gfx10, 3173 },
    { IMAGE_SAMPLE_CD_O_V4_V8_nsa_gfx10, 3211 },
    { IMAGE_SAMPLE_CD_O_V4_V9_nsa_gfx10, 3212 },
    { IMAGE_SAMPLE_CD_O_V5_V10_nsa_gfx10, 3221 },
    { IMAGE_SAMPLE_CD_O_V5_V16, 3256 },
    { IMAGE_SAMPLE_CD_O_V5_V16_gfx10, 3181 },
    { IMAGE_SAMPLE_CD_O_V5_V3, 3250 },
    { IMAGE_SAMPLE_CD_O_V5_V3_gfx10, 3175 },
    { IMAGE_SAMPLE_CD_O_V5_V3_nsa_gfx10, 3214 },
    { IMAGE_SAMPLE_CD_O_V5_V4, 3251 },
    { IMAGE_SAMPLE_CD_O_V5_V4_gfx10, 3176 },
    { IMAGE_SAMPLE_CD_O_V5_V4_nsa_gfx10, 3215 },
    { IMAGE_SAMPLE_CD_O_V5_V5, 3252 },
    { IMAGE_SAMPLE_CD_O_V5_V5_gfx10, 3177 },
    { IMAGE_SAMPLE_CD_O_V5_V5_nsa_gfx10, 3216 },
    { IMAGE_SAMPLE_CD_O_V5_V6, 3253 },
    { IMAGE_SAMPLE_CD_O_V5_V6_gfx10, 3178 },
    { IMAGE_SAMPLE_CD_O_V5_V6_nsa_gfx10, 3217 },
    { IMAGE_SAMPLE_CD_O_V5_V7, 3254 },
    { IMAGE_SAMPLE_CD_O_V5_V7_gfx10, 3179 },
    { IMAGE_SAMPLE_CD_O_V5_V7_nsa_gfx10, 3218 },
    { IMAGE_SAMPLE_CD_O_V5_V8, 3255 },
    { IMAGE_SAMPLE_CD_O_V5_V8_gfx10, 3180 },
    { IMAGE_SAMPLE_CD_O_V5_V8_nsa_gfx10, 3219 },
    { IMAGE_SAMPLE_CD_O_V5_V9_nsa_gfx10, 3220 },
    { IMAGE_SAMPLE_CD_V1_V16, 2514 },
    { IMAGE_SAMPLE_CD_V1_V16_gfx10, 2434 },
    { IMAGE_SAMPLE_CD_V1_V2, 2507 },
    { IMAGE_SAMPLE_CD_V1_V2_gfx10, 2427 },
    { IMAGE_SAMPLE_CD_V1_V2_nsa_gfx10, 2467 },
    { IMAGE_SAMPLE_CD_V1_V3, 2508 },
    { IMAGE_SAMPLE_CD_V1_V3_gfx10, 2428 },
    { IMAGE_SAMPLE_CD_V1_V3_nsa_gfx10, 2468 },
    { IMAGE_SAMPLE_CD_V1_V4, 2509 },
    { IMAGE_SAMPLE_CD_V1_V4_gfx10, 2429 },
    { IMAGE_SAMPLE_CD_V1_V4_nsa_gfx10, 2469 },
    { IMAGE_SAMPLE_CD_V1_V5, 2510 },
    { IMAGE_SAMPLE_CD_V1_V5_gfx10, 2430 },
    { IMAGE_SAMPLE_CD_V1_V5_nsa_gfx10, 2470 },
    { IMAGE_SAMPLE_CD_V1_V6, 2511 },
    { IMAGE_SAMPLE_CD_V1_V6_gfx10, 2431 },
    { IMAGE_SAMPLE_CD_V1_V6_nsa_gfx10, 2471 },
    { IMAGE_SAMPLE_CD_V1_V7, 2512 },
    { IMAGE_SAMPLE_CD_V1_V7_gfx10, 2432 },
    { IMAGE_SAMPLE_CD_V1_V7_nsa_gfx10, 2472 },
    { IMAGE_SAMPLE_CD_V1_V8, 2513 },
    { IMAGE_SAMPLE_CD_V1_V8_gfx10, 2433 },
    { IMAGE_SAMPLE_CD_V1_V8_nsa_gfx10, 2473 },
    { IMAGE_SAMPLE_CD_V1_V9_nsa_gfx10, 2474 },
    { IMAGE_SAMPLE_CD_V2_V16, 2522 },
    { IMAGE_SAMPLE_CD_V2_V16_gfx10, 2442 },
    { IMAGE_SAMPLE_CD_V2_V2, 2515 },
    { IMAGE_SAMPLE_CD_V2_V2_gfx10, 2435 },
    { IMAGE_SAMPLE_CD_V2_V2_nsa_gfx10, 2475 },
    { IMAGE_SAMPLE_CD_V2_V3, 2516 },
    { IMAGE_SAMPLE_CD_V2_V3_gfx10, 2436 },
    { IMAGE_SAMPLE_CD_V2_V3_nsa_gfx10, 2476 },
    { IMAGE_SAMPLE_CD_V2_V4, 2517 },
    { IMAGE_SAMPLE_CD_V2_V4_gfx10, 2437 },
    { IMAGE_SAMPLE_CD_V2_V4_nsa_gfx10, 2477 },
    { IMAGE_SAMPLE_CD_V2_V5, 2518 },
    { IMAGE_SAMPLE_CD_V2_V5_gfx10, 2438 },
    { IMAGE_SAMPLE_CD_V2_V5_nsa_gfx10, 2478 },
    { IMAGE_SAMPLE_CD_V2_V6, 2519 },
    { IMAGE_SAMPLE_CD_V2_V6_gfx10, 2439 },
    { IMAGE_SAMPLE_CD_V2_V6_nsa_gfx10, 2479 },
    { IMAGE_SAMPLE_CD_V2_V7, 2520 },
    { IMAGE_SAMPLE_CD_V2_V7_gfx10, 2440 },
    { IMAGE_SAMPLE_CD_V2_V7_nsa_gfx10, 2480 },
    { IMAGE_SAMPLE_CD_V2_V8, 2521 },
    { IMAGE_SAMPLE_CD_V2_V8_gfx10, 2441 },
    { IMAGE_SAMPLE_CD_V2_V8_nsa_gfx10, 2481 },
    { IMAGE_SAMPLE_CD_V2_V9_nsa_gfx10, 2482 },
    { IMAGE_SAMPLE_CD_V3_V16, 2530 },
    { IMAGE_SAMPLE_CD_V3_V16_gfx10, 2450 },
    { IMAGE_SAMPLE_CD_V3_V2, 2523 },
    { IMAGE_SAMPLE_CD_V3_V2_gfx10, 2443 },
    { IMAGE_SAMPLE_CD_V3_V2_nsa_gfx10, 2483 },
    { IMAGE_SAMPLE_CD_V3_V3, 2524 },
    { IMAGE_SAMPLE_CD_V3_V3_gfx10, 2444 },
    { IMAGE_SAMPLE_CD_V3_V3_nsa_gfx10, 2484 },
    { IMAGE_SAMPLE_CD_V3_V4, 2525 },
    { IMAGE_SAMPLE_CD_V3_V4_gfx10, 2445 },
    { IMAGE_SAMPLE_CD_V3_V4_nsa_gfx10, 2485 },
    { IMAGE_SAMPLE_CD_V3_V5, 2526 },
    { IMAGE_SAMPLE_CD_V3_V5_gfx10, 2446 },
    { IMAGE_SAMPLE_CD_V3_V5_nsa_gfx10, 2486 },
    { IMAGE_SAMPLE_CD_V3_V6, 2527 },
    { IMAGE_SAMPLE_CD_V3_V6_gfx10, 2447 },
    { IMAGE_SAMPLE_CD_V3_V6_nsa_gfx10, 2487 },
    { IMAGE_SAMPLE_CD_V3_V7, 2528 },
    { IMAGE_SAMPLE_CD_V3_V7_gfx10, 2448 },
    { IMAGE_SAMPLE_CD_V3_V7_nsa_gfx10, 2488 },
    { IMAGE_SAMPLE_CD_V3_V8, 2529 },
    { IMAGE_SAMPLE_CD_V3_V8_gfx10, 2449 },
    { IMAGE_SAMPLE_CD_V3_V8_nsa_gfx10, 2489 },
    { IMAGE_SAMPLE_CD_V3_V9_nsa_gfx10, 2490 },
    { IMAGE_SAMPLE_CD_V4_V16, 2538 },
    { IMAGE_SAMPLE_CD_V4_V16_gfx10, 2458 },
    { IMAGE_SAMPLE_CD_V4_V2, 2531 },
    { IMAGE_SAMPLE_CD_V4_V2_gfx10, 2451 },
    { IMAGE_SAMPLE_CD_V4_V2_nsa_gfx10, 2491 },
    { IMAGE_SAMPLE_CD_V4_V3, 2532 },
    { IMAGE_SAMPLE_CD_V4_V3_gfx10, 2452 },
    { IMAGE_SAMPLE_CD_V4_V3_nsa_gfx10, 2492 },
    { IMAGE_SAMPLE_CD_V4_V4, 2533 },
    { IMAGE_SAMPLE_CD_V4_V4_gfx10, 2453 },
    { IMAGE_SAMPLE_CD_V4_V4_nsa_gfx10, 2493 },
    { IMAGE_SAMPLE_CD_V4_V5, 2534 },
    { IMAGE_SAMPLE_CD_V4_V5_gfx10, 2454 },
    { IMAGE_SAMPLE_CD_V4_V5_nsa_gfx10, 2494 },
    { IMAGE_SAMPLE_CD_V4_V6, 2535 },
    { IMAGE_SAMPLE_CD_V4_V6_gfx10, 2455 },
    { IMAGE_SAMPLE_CD_V4_V6_nsa_gfx10, 2495 },
    { IMAGE_SAMPLE_CD_V4_V7, 2536 },
    { IMAGE_SAMPLE_CD_V4_V7_gfx10, 2456 },
    { IMAGE_SAMPLE_CD_V4_V7_nsa_gfx10, 2496 },
    { IMAGE_SAMPLE_CD_V4_V8, 2537 },
    { IMAGE_SAMPLE_CD_V4_V8_gfx10, 2457 },
    { IMAGE_SAMPLE_CD_V4_V8_nsa_gfx10, 2497 },
    { IMAGE_SAMPLE_CD_V4_V9_nsa_gfx10, 2498 },
    { IMAGE_SAMPLE_CD_V5_V16, 2546 },
    { IMAGE_SAMPLE_CD_V5_V16_gfx10, 2466 },
    { IMAGE_SAMPLE_CD_V5_V2, 2539 },
    { IMAGE_SAMPLE_CD_V5_V2_gfx10, 2459 },
    { IMAGE_SAMPLE_CD_V5_V2_nsa_gfx10, 2499 },
    { IMAGE_SAMPLE_CD_V5_V3, 2540 },
    { IMAGE_SAMPLE_CD_V5_V3_gfx10, 2460 },
    { IMAGE_SAMPLE_CD_V5_V3_nsa_gfx10, 2500 },
    { IMAGE_SAMPLE_CD_V5_V4, 2541 },
    { IMAGE_SAMPLE_CD_V5_V4_gfx10, 2461 },
    { IMAGE_SAMPLE_CD_V5_V4_nsa_gfx10, 2501 },
    { IMAGE_SAMPLE_CD_V5_V5, 2542 },
    { IMAGE_SAMPLE_CD_V5_V5_gfx10, 2462 },
    { IMAGE_SAMPLE_CD_V5_V5_nsa_gfx10, 2502 },
    { IMAGE_SAMPLE_CD_V5_V6, 2543 },
    { IMAGE_SAMPLE_CD_V5_V6_gfx10, 2463 },
    { IMAGE_SAMPLE_CD_V5_V6_nsa_gfx10, 2503 },
    { IMAGE_SAMPLE_CD_V5_V7, 2544 },
    { IMAGE_SAMPLE_CD_V5_V7_gfx10, 2464 },
    { IMAGE_SAMPLE_CD_V5_V7_nsa_gfx10, 2504 },
    { IMAGE_SAMPLE_CD_V5_V8, 2545 },
    { IMAGE_SAMPLE_CD_V5_V8_gfx10, 2465 },
    { IMAGE_SAMPLE_CD_V5_V8_nsa_gfx10, 2505 },
    { IMAGE_SAMPLE_CD_V5_V9_nsa_gfx10, 2506 },
    { IMAGE_SAMPLE_CL_O_V1_V2, 3467 },
    { IMAGE_SAMPLE_CL_O_V1_V2_gfx10, 3422 },
    { IMAGE_SAMPLE_CL_O_V1_V2_nsa_gfx10, 3447 },
    { IMAGE_SAMPLE_CL_O_V1_V3, 3468 },
    { IMAGE_SAMPLE_CL_O_V1_V3_gfx10, 3423 },
    { IMAGE_SAMPLE_CL_O_V1_V3_nsa_gfx10, 3448 },
    { IMAGE_SAMPLE_CL_O_V1_V4, 3469 },
    { IMAGE_SAMPLE_CL_O_V1_V4_gfx10, 3424 },
    { IMAGE_SAMPLE_CL_O_V1_V4_nsa_gfx10, 3449 },
    { IMAGE_SAMPLE_CL_O_V1_V5, 3470 },
    { IMAGE_SAMPLE_CL_O_V1_V5_gfx10, 3425 },
    { IMAGE_SAMPLE_CL_O_V1_V5_nsa_gfx10, 3450 },
    { IMAGE_SAMPLE_CL_O_V1_V8, 3471 },
    { IMAGE_SAMPLE_CL_O_V1_V8_gfx10, 3426 },
    { IMAGE_SAMPLE_CL_O_V2_V2, 3472 },
    { IMAGE_SAMPLE_CL_O_V2_V2_gfx10, 3427 },
    { IMAGE_SAMPLE_CL_O_V2_V2_nsa_gfx10, 3451 },
    { IMAGE_SAMPLE_CL_O_V2_V3, 3473 },
    { IMAGE_SAMPLE_CL_O_V2_V3_gfx10, 3428 },
    { IMAGE_SAMPLE_CL_O_V2_V3_nsa_gfx10, 3452 },
    { IMAGE_SAMPLE_CL_O_V2_V4, 3474 },
    { IMAGE_SAMPLE_CL_O_V2_V4_gfx10, 3429 },
    { IMAGE_SAMPLE_CL_O_V2_V4_nsa_gfx10, 3453 },
    { IMAGE_SAMPLE_CL_O_V2_V5, 3475 },
    { IMAGE_SAMPLE_CL_O_V2_V5_gfx10, 3430 },
    { IMAGE_SAMPLE_CL_O_V2_V5_nsa_gfx10, 3454 },
    { IMAGE_SAMPLE_CL_O_V2_V8, 3476 },
    { IMAGE_SAMPLE_CL_O_V2_V8_gfx10, 3431 },
    { IMAGE_SAMPLE_CL_O_V3_V2, 3477 },
    { IMAGE_SAMPLE_CL_O_V3_V2_gfx10, 3432 },
    { IMAGE_SAMPLE_CL_O_V3_V2_nsa_gfx10, 3455 },
    { IMAGE_SAMPLE_CL_O_V3_V3, 3478 },
    { IMAGE_SAMPLE_CL_O_V3_V3_gfx10, 3433 },
    { IMAGE_SAMPLE_CL_O_V3_V3_nsa_gfx10, 3456 },
    { IMAGE_SAMPLE_CL_O_V3_V4, 3479 },
    { IMAGE_SAMPLE_CL_O_V3_V4_gfx10, 3434 },
    { IMAGE_SAMPLE_CL_O_V3_V4_nsa_gfx10, 3457 },
    { IMAGE_SAMPLE_CL_O_V3_V5, 3480 },
    { IMAGE_SAMPLE_CL_O_V3_V5_gfx10, 3435 },
    { IMAGE_SAMPLE_CL_O_V3_V5_nsa_gfx10, 3458 },
    { IMAGE_SAMPLE_CL_O_V3_V8, 3481 },
    { IMAGE_SAMPLE_CL_O_V3_V8_gfx10, 3436 },
    { IMAGE_SAMPLE_CL_O_V4_V2, 3482 },
    { IMAGE_SAMPLE_CL_O_V4_V2_gfx10, 3437 },
    { IMAGE_SAMPLE_CL_O_V4_V2_nsa_gfx10, 3459 },
    { IMAGE_SAMPLE_CL_O_V4_V3, 3483 },
    { IMAGE_SAMPLE_CL_O_V4_V3_gfx10, 3438 },
    { IMAGE_SAMPLE_CL_O_V4_V3_nsa_gfx10, 3460 },
    { IMAGE_SAMPLE_CL_O_V4_V4, 3484 },
    { IMAGE_SAMPLE_CL_O_V4_V4_gfx10, 3439 },
    { IMAGE_SAMPLE_CL_O_V4_V4_nsa_gfx10, 3461 },
    { IMAGE_SAMPLE_CL_O_V4_V5, 3485 },
    { IMAGE_SAMPLE_CL_O_V4_V5_gfx10, 3440 },
    { IMAGE_SAMPLE_CL_O_V4_V5_nsa_gfx10, 3462 },
    { IMAGE_SAMPLE_CL_O_V4_V8, 3486 },
    { IMAGE_SAMPLE_CL_O_V4_V8_gfx10, 3441 },
    { IMAGE_SAMPLE_CL_O_V5_V2, 3487 },
    { IMAGE_SAMPLE_CL_O_V5_V2_gfx10, 3442 },
    { IMAGE_SAMPLE_CL_O_V5_V2_nsa_gfx10, 3463 },
    { IMAGE_SAMPLE_CL_O_V5_V3, 3488 },
    { IMAGE_SAMPLE_CL_O_V5_V3_gfx10, 3443 },
    { IMAGE_SAMPLE_CL_O_V5_V3_nsa_gfx10, 3464 },
    { IMAGE_SAMPLE_CL_O_V5_V4, 3489 },
    { IMAGE_SAMPLE_CL_O_V5_V4_gfx10, 3444 },
    { IMAGE_SAMPLE_CL_O_V5_V4_nsa_gfx10, 3465 },
    { IMAGE_SAMPLE_CL_O_V5_V5, 3490 },
    { IMAGE_SAMPLE_CL_O_V5_V5_gfx10, 3445 },
    { IMAGE_SAMPLE_CL_O_V5_V5_nsa_gfx10, 3466 },
    { IMAGE_SAMPLE_CL_O_V5_V8, 3491 },
    { IMAGE_SAMPLE_CL_O_V5_V8_gfx10, 3446 },
    { IMAGE_SAMPLE_CL_V1_V1, 3402 },
    { IMAGE_SAMPLE_CL_V1_V1_gfx10, 3367 },
    { IMAGE_SAMPLE_CL_V1_V2, 3403 },
    { IMAGE_SAMPLE_CL_V1_V2_gfx10, 3368 },
    { IMAGE_SAMPLE_CL_V1_V2_nsa_gfx10, 3387 },
    { IMAGE_SAMPLE_CL_V1_V3, 3404 },
    { IMAGE_SAMPLE_CL_V1_V3_gfx10, 3369 },
    { IMAGE_SAMPLE_CL_V1_V3_nsa_gfx10, 3388 },
    { IMAGE_SAMPLE_CL_V1_V4, 3405 },
    { IMAGE_SAMPLE_CL_V1_V4_gfx10, 3370 },
    { IMAGE_SAMPLE_CL_V1_V4_nsa_gfx10, 3389 },
    { IMAGE_SAMPLE_CL_V2_V1, 3406 },
    { IMAGE_SAMPLE_CL_V2_V1_gfx10, 3371 },
    { IMAGE_SAMPLE_CL_V2_V2, 3407 },
    { IMAGE_SAMPLE_CL_V2_V2_gfx10, 3372 },
    { IMAGE_SAMPLE_CL_V2_V2_nsa_gfx10, 3390 },
    { IMAGE_SAMPLE_CL_V2_V3, 3408 },
    { IMAGE_SAMPLE_CL_V2_V3_gfx10, 3373 },
    { IMAGE_SAMPLE_CL_V2_V3_nsa_gfx10, 3391 },
    { IMAGE_SAMPLE_CL_V2_V4, 3409 },
    { IMAGE_SAMPLE_CL_V2_V4_gfx10, 3374 },
    { IMAGE_SAMPLE_CL_V2_V4_nsa_gfx10, 3392 },
    { IMAGE_SAMPLE_CL_V3_V1, 3410 },
    { IMAGE_SAMPLE_CL_V3_V1_gfx10, 3375 },
    { IMAGE_SAMPLE_CL_V3_V2, 3411 },
    { IMAGE_SAMPLE_CL_V3_V2_gfx10, 3376 },
    { IMAGE_SAMPLE_CL_V3_V2_nsa_gfx10, 3393 },
    { IMAGE_SAMPLE_CL_V3_V3, 3412 },
    { IMAGE_SAMPLE_CL_V3_V3_gfx10, 3377 },
    { IMAGE_SAMPLE_CL_V3_V3_nsa_gfx10, 3394 },
    { IMAGE_SAMPLE_CL_V3_V4, 3413 },
    { IMAGE_SAMPLE_CL_V3_V4_gfx10, 3378 },
    { IMAGE_SAMPLE_CL_V3_V4_nsa_gfx10, 3395 },
    { IMAGE_SAMPLE_CL_V4_V1, 3414 },
    { IMAGE_SAMPLE_CL_V4_V1_gfx10, 3379 },
    { IMAGE_SAMPLE_CL_V4_V2, 3415 },
    { IMAGE_SAMPLE_CL_V4_V2_gfx10, 3380 },
    { IMAGE_SAMPLE_CL_V4_V2_nsa_gfx10, 3396 },
    { IMAGE_SAMPLE_CL_V4_V3, 3416 },
    { IMAGE_SAMPLE_CL_V4_V3_gfx10, 3381 },
    { IMAGE_SAMPLE_CL_V4_V3_nsa_gfx10, 3397 },
    { IMAGE_SAMPLE_CL_V4_V4, 3417 },
    { IMAGE_SAMPLE_CL_V4_V4_gfx10, 3382 },
    { IMAGE_SAMPLE_CL_V4_V4_nsa_gfx10, 3398 },
    { IMAGE_SAMPLE_CL_V5_V1, 3418 },
    {