/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the AMDGPU target                          *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 63;
using PredicateBitset = llvm::PredicateBitsetImpl<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(AMDGPUInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AMDGPUInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ISelInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ISelInfo;
  static AMDGPUInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static AMDGPUInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const int64_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const std::array<const MachineOperand *, 3> &Operands) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(3),
ISelInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_isGFX6Bit = 26,
  Feature_isGFX6GFX7Bit = 3,
  Feature_isGFX6GFX7GFX10Bit = 49,
  Feature_isGFX7OnlyBit = 42,
  Feature_isGFX7GFX8GFX9Bit = 19,
  Feature_isGFX6GFX7GFX8GFX9Bit = 33,
  Feature_isGFX7PlusBit = 5,
  Feature_isGFX8PlusBit = 1,
  Feature_isGFX8OnlyBit = 9,
  Feature_isGFX9PlusBit = 0,
  Feature_isGFX90APlusBit = 16,
  Feature_isNotGFX90APlusBit = 10,
  Feature_isGFX10PlusBit = 2,
  Feature_HasFlatAddressSpaceBit = 23,
  Feature_HasFlatGlobalInstsBit = 24,
  Feature_HasFlatScratchInstsBit = 46,
  Feature_HasGFX10_BEncodingBit = 25,
  Feature_HasUnpackedD16VMemBit = 47,
  Feature_HasPackedD16VMemBit = 48,
  Feature_D16PreservesUnusedBitsBit = 44,
  Feature_LDSRequiresM0InitBit = 59,
  Feature_NotLDSRequiresM0InitBit = 60,
  Feature_HasLDSFPAtomicAddBit = 62,
  Feature_HasAddNoCarryInstsBit = 32,
  Feature_NotHasAddNoCarryInstsBit = 58,
  Feature_Has16BitInstsBit = 4,
  Feature_HasVOP3PInstsBit = 39,
  Feature_HasMinMaxDenormModesBit = 53,
  Feature_NotHasMinMaxDenormModesBit = 55,
  Feature_HasPackedFP32OpsBit = 17,
  Feature_HasIntClampBit = 38,
  Feature_HasMadMixInstsBit = 40,
  Feature_HasScalarStoresBit = 20,
  Feature_has16BankLDSBit = 28,
  Feature_has32BankLDSBit = 11,
  Feature_HasFmaMixInstsBit = 41,
  Feature_HasDLInstsBit = 6,
  Feature_HasDot1InstsBit = 14,
  Feature_HasDot2InstsBit = 12,
  Feature_HasDot3InstsBit = 37,
  Feature_HasDot4InstsBit = 36,
  Feature_HasDot5InstsBit = 34,
  Feature_HasDot6InstsBit = 35,
  Feature_HasDot7InstsBit = 13,
  Feature_HasGetWaveIdInstBit = 22,
  Feature_HasMAIInstsBit = 15,
  Feature_HasSMemRealTimeBit = 21,
  Feature_HasSMemTimeInstBit = 18,
  Feature_HasShaderCyclesRegisterBit = 43,
  Feature_HasMadMacF32InstsBit = 7,
  Feature_HasFmaLegacy32Bit = 8,
  Feature_HasAtomicFaddInstsBit = 27,
  Feature_EnableLateCFGStructurizeBit = 29,
  Feature_EnableFlatScratchBit = 45,
  Feature_DisableFlatScratchBit = 50,
  Feature_HasUnalignedAccessModeBit = 61,
  Feature_FalsePredicateBit = 54,
  Feature_FP16DenormalsBit = 57,
  Feature_FP64DenormalsBit = 56,
  Feature_NoFP32DenormalsBit = 52,
  Feature_UnsafeFPMathBit = 51,
  Feature_isWave32Bit = 30,
  Feature_isWave64Bit = 31,
};

PredicateBitset AMDGPUInstructionSelector::
computeAvailableModuleFeatures(const AMDGPUSubtarget *Subtarget) const {
  PredicateBitset Features;
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS)
    Features.set(Feature_isGFX6Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX6GFX7Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX6GFX7GFX10Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX7OnlyBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX7GFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX6GFX7GFX8GFX9Bit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX7PlusBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
    Features.set(Feature_isGFX8PlusBit);
  if (Subtarget->getGeneration() ==AMDGPUSubtarget::VOLCANIC_ISLANDS)
    Features.set(Feature_isGFX8OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX9PlusBit);
  if (Subtarget->hasGFX90AInsts())
    Features.set(Feature_isGFX90APlusBit);
  if (!Subtarget->hasGFX90AInsts())
    Features.set(Feature_isNotGFX90APlusBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX10PlusBit);
  if (Subtarget->hasFlatAddressSpace())
    Features.set(Feature_HasFlatAddressSpaceBit);
  if (Subtarget->hasFlatGlobalInsts())
    Features.set(Feature_HasFlatGlobalInstsBit);
  if (Subtarget->hasFlatScratchInsts())
    Features.set(Feature_HasFlatScratchInstsBit);
  if (Subtarget->hasGFX10_BEncoding())
    Features.set(Feature_HasGFX10_BEncodingBit);
  if (Subtarget->hasUnpackedD16VMem())
    Features.set(Feature_HasUnpackedD16VMemBit);
  if (!Subtarget->hasUnpackedD16VMem())
    Features.set(Feature_HasPackedD16VMemBit);
  if (Subtarget->d16PreservesUnusedBits())
    Features.set(Feature_D16PreservesUnusedBitsBit);
  if (Subtarget->ldsRequiresM0Init())
    Features.set(Feature_LDSRequiresM0InitBit);
  if (!Subtarget->ldsRequiresM0Init())
    Features.set(Feature_NotLDSRequiresM0InitBit);
  if (Subtarget->hasLDSFPAtomicAdd())
    Features.set(Feature_HasLDSFPAtomicAddBit);
  if (Subtarget->hasAddNoCarry())
    Features.set(Feature_HasAddNoCarryInstsBit);
  if (!Subtarget->hasAddNoCarry())
    Features.set(Feature_NotHasAddNoCarryInstsBit);
  if (Subtarget->has16BitInsts())
    Features.set(Feature_Has16BitInstsBit);
  if (Subtarget->hasVOP3PInsts())
    Features.set(Feature_HasVOP3PInstsBit);
  if (Subtarget->supportsMinMaxDenormModes())
    Features.set(Feature_HasMinMaxDenormModesBit);
  if (!Subtarget->supportsMinMaxDenormModes())
    Features.set(Feature_NotHasMinMaxDenormModesBit);
  if (Subtarget->hasPackedFP32Ops())
    Features.set(Feature_HasPackedFP32OpsBit);
  if (Subtarget->hasIntClamp())
    Features.set(Feature_HasIntClampBit);
  if (Subtarget->hasMadMixInsts())
    Features.set(Feature_HasMadMixInstsBit);
  if (Subtarget->hasScalarStores())
    Features.set(Feature_HasScalarStoresBit);
  if (Subtarget->getLDSBankCount() == 16)
    Features.set(Feature_has16BankLDSBit);
  if (Subtarget->getLDSBankCount() == 32)
    Features.set(Feature_has32BankLDSBit);
  if (Subtarget->hasFmaMixInsts())
    Features.set(Feature_HasFmaMixInstsBit);
  if (Subtarget->hasDLInsts())
    Features.set(Feature_HasDLInstsBit);
  if (Subtarget->hasDot1Insts())
    Features.set(Feature_HasDot1InstsBit);
  if (Subtarget->hasDot2Insts())
    Features.set(Feature_HasDot2InstsBit);
  if (Subtarget->hasDot3Insts())
    Features.set(Feature_HasDot3InstsBit);
  if (Subtarget->hasDot4Insts())
    Features.set(Feature_HasDot4InstsBit);
  if (Subtarget->hasDot5Insts())
    Features.set(Feature_HasDot5InstsBit);
  if (Subtarget->hasDot6Insts())
    Features.set(Feature_HasDot6InstsBit);
  if (Subtarget->hasDot7Insts())
    Features.set(Feature_HasDot7InstsBit);
  if (Subtarget->hasGetWaveIdInst())
    Features.set(Feature_HasGetWaveIdInstBit);
  if (Subtarget->hasMAIInsts())
    Features.set(Feature_HasMAIInstsBit);
  if (Subtarget->hasSMemRealTime())
    Features.set(Feature_HasSMemRealTimeBit);
  if (Subtarget->hasSMemTimeInst())
    Features.set(Feature_HasSMemTimeInstBit);
  if (Subtarget->hasShaderCyclesRegister())
    Features.set(Feature_HasShaderCyclesRegisterBit);
  if (Subtarget->hasMadMacF32Insts())
    Features.set(Feature_HasMadMacF32InstsBit);
  if (Subtarget->hasGFX10_3Insts())
    Features.set(Feature_HasFmaLegacy32Bit);
  if (Subtarget->hasAtomicFaddInsts())
    Features.set(Feature_HasAtomicFaddInstsBit);
  if (EnableLateStructurizeCFG)
    Features.set(Feature_EnableLateCFGStructurizeBit);
  if (Subtarget->enableFlatScratch())
    Features.set(Feature_EnableFlatScratchBit);
  if (!Subtarget->enableFlatScratch())
    Features.set(Feature_DisableFlatScratchBit);
  if (Subtarget->hasUnalignedAccessMode())
    Features.set(Feature_HasUnalignedAccessModeBit);
  if (false)
    Features.set(Feature_FalsePredicateBit);
  if (Subtarget->getWavefrontSize() == 32)
    Features.set(Feature_isWave32Bit);
  if (Subtarget->getWavefrontSize() == 64)
    Features.set(Feature_isWave64Bit);
  return Features;
}

void AMDGPUInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const AMDGPUSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset AMDGPUInstructionSelector::
computeAvailableFunctionFeatures(const AMDGPUSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().allFP64FP16Denormals())
    Features.set(Feature_FP16DenormalsBit);
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().allFP64FP16Denormals())
    Features.set(Feature_FP64DenormalsBit);
  if (!MF->getInfo<SIMachineFunctionInfo>()->getMode().allFP32Denormals())
    Features.set(Feature_NoFP32DenormalsBit);
  if (TM.Options.UnsafeFPMath)
    Features.set(Feature_UnsafeFPMathBit);
  return Features;
}

// LLT Objects.
enum {
  GILLT_p0s64,
  GILLT_p1s64,
  GILLT_p2s32,
  GILLT_p3s32,
  GILLT_p4s64,
  GILLT_p5s32,
  GILLT_p6s32,
  GILLT_s1,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s16,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v3s32,
  GILLT_v3s64,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v4s64,
  GILLT_v5s32,
  GILLT_v6s32,
  GILLT_v7s32,
  GILLT_v8s16,
  GILLT_v8s32,
  GILLT_v8s64,
  GILLT_v16s32,
  GILLT_v16s64,
  GILLT_v32s32,
};
const static size_t NumTypeObjects = 28;
const static LLT TypeObjects[] = {
  LLT::pointer(0, 64),
  LLT::pointer(1, 64),
  LLT::pointer(2, 32),
  LLT::pointer(3, 32),
  LLT::pointer(4, 64),
  LLT::pointer(5, 32),
  LLT::pointer(6, 32),
  LLT::scalar(1),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getFixed(2), 16),
  LLT::vector(ElementCount::getFixed(2), 32),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(3), 32),
  LLT::vector(ElementCount::getFixed(3), 64),
  LLT::vector(ElementCount::getFixed(4), 16),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(4), 64),
  LLT::vector(ElementCount::getFixed(5), 32),
  LLT::vector(ElementCount::getFixed(6), 32),
  LLT::vector(ElementCount::getFixed(7), 32),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(8), 32),
  LLT::vector(ElementCount::getFixed(8), 64),
  LLT::vector(ElementCount::getFixed(16), 32),
  LLT::vector(ElementCount::getFixed(16), 64),
  LLT::vector(ElementCount::getFixed(32), 32),
};

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_D16PreservesUnusedBits,
  GIFBS_DisableFlatScratch,
  GIFBS_Has16BitInsts,
  GIFBS_HasAddNoCarryInsts,
  GIFBS_HasDLInsts,
  GIFBS_HasDot1Insts,
  GIFBS_HasDot2Insts,
  GIFBS_HasDot7Insts,
  GIFBS_HasFlatAddressSpace,
  GIFBS_HasFlatGlobalInsts,
  GIFBS_HasFmaLegacy32,
  GIFBS_HasGFX10_BEncoding,
  GIFBS_HasGetWaveIdInst,
  GIFBS_HasIntClamp,
  GIFBS_HasLDSFPAtomicAdd,
  GIFBS_HasMAIInsts,
  GIFBS_HasMadMacF32Insts,
  GIFBS_HasMinMaxDenormModes,
  GIFBS_HasPackedD16VMem,
  GIFBS_HasPackedFP32Ops,
  GIFBS_HasSMemRealTime,
  GIFBS_HasSMemTimeInst,
  GIFBS_HasShaderCyclesRegister,
  GIFBS_HasUnpackedD16VMem,
  GIFBS_HasVOP3PInsts,
  GIFBS_LDSRequiresM0Init,
  GIFBS_NotHasAddNoCarryInsts,
  GIFBS_NotLDSRequiresM0Init,
  GIFBS_UnsafeFPMath,
  GIFBS_isGFX10Plus,
  GIFBS_isGFX6,
  GIFBS_isGFX6GFX7,
  GIFBS_isGFX6GFX7GFX10,
  GIFBS_isGFX7GFX8GFX9,
  GIFBS_isGFX7Only,
  GIFBS_isGFX7Plus,
  GIFBS_isGFX8Plus,
  GIFBS_isGFX90APlus,
  GIFBS_isGFX9Plus,
  GIFBS_isNotGFX90APlus,
  GIFBS_isWave32,
  GIFBS_isWave64,
  GIFBS_D16PreservesUnusedBits_DisableFlatScratch,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts,
  GIFBS_FP16Denormals_NotHasMinMaxDenormModes,
  GIFBS_FP64Denormals_NotHasMinMaxDenormModes,
  GIFBS_FalsePredicate_NotHasMinMaxDenormModes,
  GIFBS_Has16BitInsts_HasIntClamp,
  GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
  GIFBS_Has16BitInsts_isGFX7GFX8GFX9,
  GIFBS_Has16BitInsts_isGFX8Only,
  GIFBS_Has16BitInsts_isGFX9Plus,
  GIFBS_Has16BitInsts_isNotGFX90APlus,
  GIFBS_HasAddNoCarryInsts_HasIntClamp,
  GIFBS_HasAtomicFaddInsts_isGFX90APlus,
  GIFBS_HasFlatGlobalInsts_isGFX90APlus,
  GIFBS_HasLDSFPAtomicAdd_LDSRequiresM0Init,
  GIFBS_HasLDSFPAtomicAdd_NotLDSRequiresM0Init,
  GIFBS_HasMadMacF32Insts_NoFP32Denormals,
  GIFBS_HasScalarStores_isGFX8Plus,
  GIFBS_HasUnalignedAccessMode_LDSRequiresM0Init,
  GIFBS_HasUnalignedAccessMode_NotLDSRequiresM0Init,
  GIFBS_LDSRequiresM0Init_isGFX7Plus,
  GIFBS_NotLDSRequiresM0Init_isGFX7Plus,
  GIFBS_has16BankLDS_isNotGFX90APlus,
  GIFBS_has32BankLDS_isNotGFX90APlus,
  GIFBS_D16PreservesUnusedBits_EnableFlatScratch_HasFlatScratchInsts,
  GIFBS_Has16BitInsts_has32BankLDS_isNotGFX90APlus,
  GIFBS_HasMadMacF32Insts_NoFP32Denormals_isGFX6GFX7GFX10,
};
const static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_D16PreservesUnusedBitsBit, },
  {Feature_DisableFlatScratchBit, },
  {Feature_Has16BitInstsBit, },
  {Feature_HasAddNoCarryInstsBit, },
  {Feature_HasDLInstsBit, },
  {Feature_HasDot1InstsBit, },
  {Feature_HasDot2InstsBit, },
  {Feature_HasDot7InstsBit, },
  {Feature_HasFlatAddressSpaceBit, },
  {Feature_HasFlatGlobalInstsBit, },
  {Feature_HasFmaLegacy32Bit, },
  {Feature_HasGFX10_BEncodingBit, },
  {Feature_HasGetWaveIdInstBit, },
  {Feature_HasIntClampBit, },
  {Feature_HasLDSFPAtomicAddBit, },
  {Feature_HasMAIInstsBit, },
  {Feature_HasMadMacF32InstsBit, },
  {Feature_HasMinMaxDenormModesBit, },
  {Feature_HasPackedD16VMemBit, },
  {Feature_HasPackedFP32OpsBit, },
  {Feature_HasSMemRealTimeBit, },
  {Feature_HasSMemTimeInstBit, },
  {Feature_HasShaderCyclesRegisterBit, },
  {Feature_HasUnpackedD16VMemBit, },
  {Feature_HasVOP3PInstsBit, },
  {Feature_LDSRequiresM0InitBit, },
  {Feature_NotHasAddNoCarryInstsBit, },
  {Feature_NotLDSRequiresM0InitBit, },
  {Feature_UnsafeFPMathBit, },
  {Feature_isGFX10PlusBit, },
  {Feature_isGFX6Bit, },
  {Feature_isGFX6GFX7Bit, },
  {Feature_isGFX6GFX7GFX10Bit, },
  {Feature_isGFX7GFX8GFX9Bit, },
  {Feature_isGFX7OnlyBit, },
  {Feature_isGFX7PlusBit, },
  {Feature_isGFX8PlusBit, },
  {Feature_isGFX90APlusBit, },
  {Feature_isGFX9PlusBit, },
  {Feature_isNotGFX90APlusBit, },
  {Feature_isWave32Bit, },
  {Feature_isWave64Bit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_DisableFlatScratchBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, },
  {Feature_FP16DenormalsBit, Feature_NotHasMinMaxDenormModesBit, },
  {Feature_FP64DenormalsBit, Feature_NotHasMinMaxDenormModesBit, },
  {Feature_FalsePredicateBit, Feature_NotHasMinMaxDenormModesBit, },
  {Feature_Has16BitInstsBit, Feature_HasIntClampBit, },
  {Feature_Has16BitInstsBit, Feature_isGFX6GFX7GFX8GFX9Bit, },
  {Feature_Has16BitInstsBit, Feature_isGFX7GFX8GFX9Bit, },
  {Feature_Has16BitInstsBit, Feature_isGFX8OnlyBit, },
  {Feature_Has16BitInstsBit, Feature_isGFX9PlusBit, },
  {Feature_Has16BitInstsBit, Feature_isNotGFX90APlusBit, },
  {Feature_HasAddNoCarryInstsBit, Feature_HasIntClampBit, },
  {Feature_HasAtomicFaddInstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasFlatGlobalInstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasLDSFPAtomicAddBit, Feature_LDSRequiresM0InitBit, },
  {Feature_HasLDSFPAtomicAddBit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_HasMadMacF32InstsBit, Feature_NoFP32DenormalsBit, },
  {Feature_HasScalarStoresBit, Feature_isGFX8PlusBit, },
  {Feature_HasUnalignedAccessModeBit, Feature_LDSRequiresM0InitBit, },
  {Feature_HasUnalignedAccessModeBit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_LDSRequiresM0InitBit, Feature_isGFX7PlusBit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_isGFX7PlusBit, },
  {Feature_has16BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_has32BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, },
  {Feature_Has16BitInstsBit, Feature_has32BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_HasMadMacF32InstsBit, Feature_NoFP32DenormalsBit, Feature_isGFX6GFX7GFX10Bit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
  GICP_gi_ds_128bit_8byte_aligned,
  GICP_gi_ds_1addr_1offset,
  GICP_gi_ds_64bit_4byte_aligned,
  GICP_gi_flat_offset,
  GICP_gi_flat_scratch_offset,
  GICP_gi_flat_scratch_saddr,
  GICP_gi_global_offset,
  GICP_gi_global_saddr,
  GICP_gi_mubuf_addr64,
  GICP_gi_mubuf_offset,
  GICP_gi_mubuf_scratch_offen,
  GICP_gi_mubuf_scratch_offset,
  GICP_gi_smrd_buffer_imm,
  GICP_gi_smrd_buffer_imm32,
  GICP_gi_smrd_imm,
  GICP_gi_smrd_imm32,
  GICP_gi_smrd_sgpr,
  GICP_gi_vcsrc,
  GICP_gi_vop3_no_mods,
  GICP_gi_vop3mods,
  GICP_gi_vop3mods0,
  GICP_gi_vop3mods_nnan,
  GICP_gi_vop3omods,
  GICP_gi_vop3opsel,
  GICP_gi_vop3opselmods,
  GICP_gi_vop3pmods,
  GICP_gi_vsrc0,
};
// See constructor for table contents

// PatFrag predicates.
enum {
  GIPFP_I64_Predicate_IMMZeroBasedBitfieldMask = GIPFP_I64_Invalid + 1,
  GIPFP_I64_Predicate_InlineImm16,
  GIPFP_I64_Predicate_InlineImm32,
  GIPFP_I64_Predicate_InlineImm64,
  GIPFP_I64_Predicate_NegSubInlineConst32,
  GIPFP_I64_Predicate_NegSubInlineIntConst16,
  GIPFP_I64_Predicate_SIMM16bit,
  GIPFP_I64_Predicate_ShiftAmt32Imm,
  GIPFP_I64_Predicate_UIMM16bit,
  GIPFP_I64_Predicate_i64imm_32bit,
};
bool AMDGPUInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GIPFP_I64_Predicate_IMMZeroBasedBitfieldMask: {
    
  return isMask_32(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_InlineImm16: {
    
  return isInlineImmediate16(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_InlineImm32: {
    
  return isInlineImmediate32(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_InlineImm64: {
    
  return isInlineImmediate64(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_NegSubInlineConst32: {
    
  return Imm < -16 && Imm >= -64;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_NegSubInlineIntConst16: {
    
  return Imm < -16 && Imm >= -64;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_SIMM16bit: {
    return isInt<16>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_ShiftAmt32Imm: {
    
  return Imm < 32;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_UIMM16bit: {
    return isUInt<16>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_i64imm_32bit: {
    
  return (Imm & 0xffffffffULL) == static_cast<uint64_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GIPFP_APFloat_Predicate_InlineImmFP32 = GIPFP_APFloat_Invalid + 1,
  GIPFP_APFloat_Predicate_InlineImmFP64,
};
bool AMDGPUInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  switch (PredicateID) {
  case GIPFP_APFloat_Predicate_InlineImmFP32: {
    
  return isInlineImmediate(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APFloat_Predicate_InlineImmFP64: {
    
  return isInlineImmediate(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GIPFP_MI_Predicate_AMDGPUmul_i24_oneuse = GIPFP_MI_Invalid + 1,
  GIPFP_MI_Predicate_AMDGPUmul_u24_oneuse,
  GIPFP_MI_Predicate_NonACAMDGPUmul_i24_oneuse,
  GIPFP_MI_Predicate_NonACAMDGPUmul_u24_oneuse,
  GIPFP_MI_Predicate_NonACAdd_oneuse,
  GIPFP_MI_Predicate_add_oneuse,
  GIPFP_MI_Predicate_and_oneuse,
  GIPFP_MI_Predicate_anonymous_11005,
  GIPFP_MI_Predicate_anonymous_11010,
  GIPFP_MI_Predicate_anonymous_11011,
  GIPFP_MI_Predicate_anonymous_11012,
  GIPFP_MI_Predicate_anonymous_11013,
  GIPFP_MI_Predicate_anonymous_11026,
  GIPFP_MI_Predicate_anonymous_11027,
  GIPFP_MI_Predicate_anonymous_11028,
  GIPFP_MI_Predicate_anonymous_11029,
  GIPFP_MI_Predicate_anonymous_11030,
  GIPFP_MI_Predicate_anonymous_11031,
  GIPFP_MI_Predicate_anonymous_11032,
  GIPFP_MI_Predicate_anonymous_11033,
  GIPFP_MI_Predicate_anonymous_11035,
  GIPFP_MI_Predicate_anonymous_11036,
  GIPFP_MI_Predicate_anonymous_11037,
  GIPFP_MI_Predicate_anonymous_11038,
  GIPFP_MI_Predicate_anonymous_11039,
  GIPFP_MI_Predicate_anonymous_11040,
  GIPFP_MI_Predicate_anonymous_11041,
  GIPFP_MI_Predicate_anonymous_11042,
  GIPFP_MI_Predicate_anonymous_11043,
  GIPFP_MI_Predicate_anonymous_11044,
  GIPFP_MI_Predicate_anonymous_11045,
  GIPFP_MI_Predicate_anonymous_11049,
  GIPFP_MI_Predicate_anonymous_11050,
  GIPFP_MI_Predicate_anonymous_11060,
  GIPFP_MI_Predicate_anonymous_11068,
  GIPFP_MI_Predicate_anonymous_14656,
  GIPFP_MI_Predicate_anonymous_14658,
  GIPFP_MI_Predicate_anonymous_15124,
  GIPFP_MI_Predicate_anonymous_15351,
  GIPFP_MI_Predicate_anonymous_15352,
  GIPFP_MI_Predicate_anonymous_15354,
  GIPFP_MI_Predicate_anonymous_15355,
  GIPFP_MI_Predicate_anonymous_15357,
  GIPFP_MI_Predicate_anonymous_15359,
  GIPFP_MI_Predicate_anonymous_15361,
  GIPFP_MI_Predicate_anonymous_15362,
  GIPFP_MI_Predicate_anonymous_15364,
  GIPFP_MI_Predicate_anonymous_15365,
  GIPFP_MI_Predicate_anonymous_15367,
  GIPFP_MI_Predicate_anonymous_15368,
  GIPFP_MI_Predicate_anonymous_15380,
  GIPFP_MI_Predicate_anonymous_15386,
  GIPFP_MI_Predicate_anonymous_15388,
  GIPFP_MI_Predicate_anonymous_18629,
  GIPFP_MI_Predicate_anonymous_18631,
  GIPFP_MI_Predicate_anonymous_19136,
  GIPFP_MI_Predicate_anonymous_19301,
  GIPFP_MI_Predicate_anonymous_19303,
  GIPFP_MI_Predicate_anonymous_19364,
  GIPFP_MI_Predicate_anonymous_19369,
  GIPFP_MI_Predicate_anonymous_19469,
  GIPFP_MI_Predicate_anonymous_19473,
  GIPFP_MI_Predicate_anonymous_19516,
  GIPFP_MI_Predicate_anonymous_19518,
  GIPFP_MI_Predicate_anonymous_19539,
  GIPFP_MI_Predicate_anonymous_19558,
  GIPFP_MI_Predicate_anonymous_19563,
  GIPFP_MI_Predicate_anonymous_19565,
  GIPFP_MI_Predicate_csh_mask_16,
  GIPFP_MI_Predicate_csh_mask_32,
  GIPFP_MI_Predicate_csh_mask_64,
  GIPFP_MI_Predicate_cshl_16_oneuse,
  GIPFP_MI_Predicate_cshl_32_oneuse,
  GIPFP_MI_Predicate_cshl_64_oneuse,
  GIPFP_MI_Predicate_csra_16_oneuse,
  GIPFP_MI_Predicate_csra_32_oneuse,
  GIPFP_MI_Predicate_csra_64_oneuse,
  GIPFP_MI_Predicate_csrl_16_oneuse,
  GIPFP_MI_Predicate_csrl_32_oneuse,
  GIPFP_MI_Predicate_csrl_64_oneuse,
  GIPFP_MI_Predicate_fmaxnum_ieee_oneuse,
  GIPFP_MI_Predicate_fmaxnum_oneuse,
  GIPFP_MI_Predicate_fminnum_ieee_oneuse,
  GIPFP_MI_Predicate_fminnum_oneuse,
  GIPFP_MI_Predicate_not_oneuse,
  GIPFP_MI_Predicate_or_oneuse,
  GIPFP_MI_Predicate_select_oneuse,
  GIPFP_MI_Predicate_shl1_add,
  GIPFP_MI_Predicate_shl2_add,
  GIPFP_MI_Predicate_shl3_add,
  GIPFP_MI_Predicate_shl4_add,
  GIPFP_MI_Predicate_shl_oneuse,
  GIPFP_MI_Predicate_smax_oneuse,
  GIPFP_MI_Predicate_smin_oneuse,
  GIPFP_MI_Predicate_smrd_load,
  GIPFP_MI_Predicate_srl_oneuse,
  GIPFP_MI_Predicate_sub_oneuse,
  GIPFP_MI_Predicate_umax_oneuse,
  GIPFP_MI_Predicate_umin_oneuse,
  GIPFP_MI_Predicate_xor_oneuse,
};
bool AMDGPUInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const std::array<const MachineOperand *, 3> &Operands) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  (void)MRI;
  switch (PredicateID) {
  case GIPFP_MI_Predicate_AMDGPUmul_i24_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_AMDGPUmul_u24_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_NonACAMDGPUmul_i24_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_NonACAMDGPUmul_u24_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_NonACAdd_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_add_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_and_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11005: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11010: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11011: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11012: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11013: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11026: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11027: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11028: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11029: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11030: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11031: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11032: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11033: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11035: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11036: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11037: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11038: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11039: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11040: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11041: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11042: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11043: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11044: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11045: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11049: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11050: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11060: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_11068: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_14656: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_14658: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_15124: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_15351: {
    
    const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
    int ConstantBusUses = 0;
    for (unsigned i = 0; i < 3; ++i) {
      const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
      if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
        if (++ConstantBusUses > ConstantBusLimit)
          return false;
      }
    }
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_15352: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_15354: {
    
    const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
    int ConstantBusUses = 0;
    for (unsigned i = 0; i < 3; ++i) {
      const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
      if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
        if (++ConstantBusUses > ConstantBusLimit)
          return false;
      }
    }
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_15355: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_15357: {
    
    const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
    int ConstantBusUses = 0;
    for (unsigned i = 0; i < 3; ++i) {
      const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
      if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
        if (++ConstantBusUses > ConstantBusLimit)
          return false;
      }
    }
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_15359: {
    
    const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
    int ConstantBusUses = 0;
    for (unsigned i = 0; i < 3; ++i) {
      const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
      if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
        if (++ConstantBusUses > ConstantBusLimit)
          return false;
      }
    }
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_15361: {
    
    const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
    int ConstantBusUses = 0;
    for (unsigned i = 0; i < 3; ++i) {
      const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
      if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
        if (++ConstantBusUses > ConstantBusLimit)
          return false;
      }
    }
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_15362: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_15364: {
    
    const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
    int ConstantBusUses = 0;
    for (unsigned i = 0; i < 3; ++i) {
      const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
      if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
        if (++ConstantBusUses > ConstantBusLimit)
          return false;
      }
    }
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_15365: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_15367: {
    
    const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
    int ConstantBusUses = 0;
    for (unsigned i = 0; i < 3; ++i) {
      const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
      if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
        if (++ConstantBusUses > ConstantBusLimit)
          return false;
      }
    }
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_15368: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_15380: {
    
    const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
    int ConstantBusUses = 0;
    for (unsigned i = 0; i < 3; ++i) {
      const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
      if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
        if (++ConstantBusUses > ConstantBusLimit)
          return false;
      }
    }
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_15386: {
    
    return MI.getOperand(6).getImm() != 0 ||
           MI.getOperand(7).getImm() != 0;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_15388: {
    
    return MI.getOperand(6).getImm() != 0 ||
           MI.getOperand(7).getImm() != 0;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_18629: {
    
    return MRI.use_nodbg_empty(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_18631: {
    
    return MRI.use_nodbg_empty(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19136: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19301: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19303: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19364: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19369: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19469: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19473: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19516: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19518: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19539: {
    
    const SITargetLowering *TLI = static_cast<const SITargetLowering *>(
      MF.getSubtarget().getTargetLowering());

    return TLI->isCanonicalized(MI.getOperand(1).getReg(), const_cast<MachineFunction&>(MF)) &&
      TLI->isCanonicalized(MI.getOperand(2).getReg(), const_cast<MachineFunction&>(MF));
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19558: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19563: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19565: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_csh_mask_16: {
     return isUnneededShiftMask(MI, 4); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_csh_mask_32: {
     return isUnneededShiftMask(MI, 5); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_csh_mask_64: {
     return isUnneededShiftMask(MI, 6); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_cshl_16_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_cshl_32_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_cshl_64_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_csra_16_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_csra_32_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_csra_64_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_csrl_16_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_csrl_32_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_csrl_64_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_fmaxnum_ieee_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_fmaxnum_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_fminnum_ieee_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_fminnum_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_not_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_or_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_select_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_shl1_add: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_shl2_add: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_shl3_add: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_shl4_add: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_shl_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_smax_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_smin_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_smrd_load: {
    
    if (!MI.hasOneMemOperand())
      return false;
    if (!isInstrUniform(MI))
      return false;

    // FIXME: We should probably be caching this.
    SmallVector<GEPInfo, 4> AddrInfo;
    getAddrModeInfo(MI, MRI, AddrInfo);

    if (hasVgprParts(AddrInfo))
      return false;
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_srl_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_sub_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_umax_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_umin_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_xor_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}

AMDGPUInstructionSelector::ComplexMatcherMemFn
AMDGPUInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
  &AMDGPUInstructionSelector::selectDS128Bit8ByteAligned, // gi_ds_128bit_8byte_aligned
  &AMDGPUInstructionSelector::selectDS1Addr1Offset, // gi_ds_1addr_1offset
  &AMDGPUInstructionSelector::selectDS64Bit4ByteAligned, // gi_ds_64bit_4byte_aligned
  &AMDGPUInstructionSelector::selectFlatOffset, // gi_flat_offset
  &AMDGPUInstructionSelector::selectScratchOffset, // gi_flat_scratch_offset
  &AMDGPUInstructionSelector::selectScratchSAddr, // gi_flat_scratch_saddr
  &AMDGPUInstructionSelector::selectGlobalOffset, // gi_global_offset
  &AMDGPUInstructionSelector::selectGlobalSAddr, // gi_global_saddr
  &AMDGPUInstructionSelector::selectMUBUFAddr64, // gi_mubuf_addr64
  &AMDGPUInstructionSelector::selectMUBUFOffset, // gi_mubuf_offset
  &AMDGPUInstructionSelector::selectMUBUFScratchOffen, // gi_mubuf_scratch_offen
  &AMDGPUInstructionSelector::selectMUBUFScratchOffset, // gi_mubuf_scratch_offset
  &AMDGPUInstructionSelector::selectSMRDBufferImm, // gi_smrd_buffer_imm
  &AMDGPUInstructionSelector::selectSMRDBufferImm32, // gi_smrd_buffer_imm32
  &AMDGPUInstructionSelector::selectSmrdImm, // gi_smrd_imm
  &AMDGPUInstructionSelector::selectSmrdImm32, // gi_smrd_imm32
  &AMDGPUInstructionSelector::selectSmrdSgpr, // gi_smrd_sgpr
  &AMDGPUInstructionSelector::selectVCSRC, // gi_vcsrc
  &AMDGPUInstructionSelector::selectVOP3NoMods, // gi_vop3_no_mods
  &AMDGPUInstructionSelector::selectVOP3Mods, // gi_vop3mods
  &AMDGPUInstructionSelector::selectVOP3Mods0, // gi_vop3mods0
  &AMDGPUInstructionSelector::selectVOP3Mods_nnan, // gi_vop3mods_nnan
  &AMDGPUInstructionSelector::selectVOP3OMods, // gi_vop3omods
  &AMDGPUInstructionSelector::selectVOP3OpSelMods, // gi_vop3opsel
  &AMDGPUInstructionSelector::selectVOP3OpSelMods, // gi_vop3opselmods
  &AMDGPUInstructionSelector::selectVOP3PMods, // gi_vop3pmods
  &AMDGPUInstructionSelector::selectVSRC0, // gi_vsrc0
};

// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderBitcastImm,
  GICR_renderExtractCPol,
  GICR_renderExtractSWZ,
  GICR_renderFrameIndex,
  GICR_renderNegateImm,
  GICR_renderPopcntImm,
  GICR_renderSetGLC,
  GICR_renderTruncTImm,
};
AMDGPUInstructionSelector::CustomRendererFn
AMDGPUInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &AMDGPUInstructionSelector::renderBitcastImm,
  &AMDGPUInstructionSelector::renderExtractCPol,
  &AMDGPUInstructionSelector::renderExtractSWZ,
  &AMDGPUInstructionSelector::renderFrameIndex,
  &AMDGPUInstructionSelector::renderNegateImm,
  &AMDGPUInstructionSelector::renderPopcntImm,
  &AMDGPUInstructionSelector::renderSetGLC,
  &AMDGPUInstructionSelector::renderTruncTImm,
};

bool AMDGPUInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  MachineFunction &MF = *I.getParent()->getParent();
  MachineRegisterInfo &MRI = MF.getRegInfo();
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  NewMIVector OutMIs;
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, OutMIs, State, ISelInfo, getMatchTable(), TII, MRI, TRI, RBI, AvailableFeatures, CoverageInfo)) {
    return true;
  }

  return false;
}

const int64_t *AMDGPUInstructionSelector::getMatchTable() const {
  constexpr static int64_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/45, 1752, /*)*//*default:*//*Label 138*/ 245925,
    /*TargetOpcode::G_ADD*//*Label 0*/ 1712,
    /*TargetOpcode::G_SUB*//*Label 1*/ 3391,
    /*TargetOpcode::G_MUL*//*Label 2*/ 3574, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_AND*//*Label 3*/ 3727,
    /*TargetOpcode::G_OR*//*Label 4*/ 4557,
    /*TargetOpcode::G_XOR*//*Label 5*/ 16619, 0, 0,
    /*TargetOpcode::G_FRAME_INDEX*//*Label 6*/ 20207, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_BUILD_VECTOR*//*Label 7*/ 20259, 0, 0, 0, 0,
    /*TargetOpcode::G_BITCAST*//*Label 8*/ 21299, 0,
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 9*/ 25886, 0, 0, 0,
    /*TargetOpcode::G_READCYCLECOUNTER*//*Label 10*/ 26026,
    /*TargetOpcode::G_LOAD*//*Label 11*/ 26127,
    /*TargetOpcode::G_SEXTLOAD*//*Label 12*/ 51183,
    /*TargetOpcode::G_ZEXTLOAD*//*Label 13*/ 53488, 0, 0, 0,
    /*TargetOpcode::G_STORE*//*Label 14*/ 55677, 0, 0,
    /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 15*/ 75084,
    /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 16*/ 75479,
    /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 17*/ 76576,
    /*TargetOpcode::G_ATOMICRMW_SUB*//*Label 18*/ 77673,
    /*TargetOpcode::G_ATOMICRMW_AND*//*Label 19*/ 78770, 0,
    /*TargetOpcode::G_ATOMICRMW_OR*//*Label 20*/ 79867,
    /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 21*/ 80964,
    /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 22*/ 82061,
    /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 23*/ 83158,
    /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 24*/ 84255,
    /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 25*/ 85352,
    /*TargetOpcode::G_ATOMICRMW_FADD*//*Label 26*/ 86449, 0,
    /*TargetOpcode::G_FENCE*//*Label 27*/ 87340, 0, 0,
    /*TargetOpcode::G_INTRINSIC*//*Label 28*/ 87356,
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 29*/ 97031, 0, 0,
    /*TargetOpcode::G_CONSTANT*//*Label 30*/ 99854,
    /*TargetOpcode::G_FCONSTANT*//*Label 31*/ 99933, 0, 0, 0, 0,
    /*TargetOpcode::G_ZEXT*//*Label 32*/ 99988,
    /*TargetOpcode::G_SHL*//*Label 33*/ 100741,
    /*TargetOpcode::G_LSHR*//*Label 34*/ 101689,
    /*TargetOpcode::G_ASHR*//*Label 35*/ 102474, 0,
    /*TargetOpcode::G_FSHR*//*Label 36*/ 103259, 0, 0,
    /*TargetOpcode::G_ICMP*//*Label 37*/ 103292,
    /*TargetOpcode::G_FCMP*//*Label 38*/ 104177,
    /*TargetOpcode::G_SELECT*//*Label 39*/ 106274, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_UMULH*//*Label 40*/ 106475,
    /*TargetOpcode::G_SMULH*//*Label 41*/ 106533,
    /*TargetOpcode::G_UADDSAT*//*Label 42*/ 106591,
    /*TargetOpcode::G_SADDSAT*//*Label 43*/ 106789,
    /*TargetOpcode::G_USUBSAT*//*Label 44*/ 106971,
    /*TargetOpcode::G_SSUBSAT*//*Label 45*/ 107169, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FADD*//*Label 46*/ 107351,
    /*TargetOpcode::G_FSUB*//*Label 47*/ 108323,
    /*TargetOpcode::G_FMUL*//*Label 48*/ 108508,
    /*TargetOpcode::G_FMA*//*Label 49*/ 108998,
    /*TargetOpcode::G_FMAD*//*Label 50*/ 109847, 0, 0,
    /*TargetOpcode::G_FPOW*//*Label 51*/ 110264, 0, 0,
    /*TargetOpcode::G_FEXP2*//*Label 52*/ 110377, 0,
    /*TargetOpcode::G_FLOG2*//*Label 53*/ 110472, 0,
    /*TargetOpcode::G_FNEG*//*Label 54*/ 110567,
    /*TargetOpcode::G_FPEXT*//*Label 55*/ 111594,
    /*TargetOpcode::G_FPTRUNC*//*Label 56*/ 111687,
    /*TargetOpcode::G_FPTOSI*//*Label 57*/ 111780,
    /*TargetOpcode::G_FPTOUI*//*Label 58*/ 112092,
    /*TargetOpcode::G_SITOFP*//*Label 59*/ 112404,
    /*TargetOpcode::G_UITOFP*//*Label 60*/ 112724,
    /*TargetOpcode::G_FABS*//*Label 61*/ 113044, 0,
    /*TargetOpcode::G_FCANONICALIZE*//*Label 62*/ 113490,
    /*TargetOpcode::G_FMINNUM*//*Label 63*/ 114180,
    /*TargetOpcode::G_FMAXNUM*//*Label 64*/ 114599,
    /*TargetOpcode::G_FMINNUM_IEEE*//*Label 65*/ 146250,
    /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 66*/ 146669, 0, 0, 0, 0,
    /*TargetOpcode::G_SMIN*//*Label 67*/ 178320,
    /*TargetOpcode::G_SMAX*//*Label 68*/ 181628,
    /*TargetOpcode::G_UMIN*//*Label 69*/ 185100,
    /*TargetOpcode::G_UMAX*//*Label 70*/ 188408,
    /*TargetOpcode::G_ABS*//*Label 71*/ 191716, 0, 0,
    /*TargetOpcode::G_BR*//*Label 72*/ 191741, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_CTTZ_ZERO_UNDEF*//*Label 73*/ 191766, 0,
    /*TargetOpcode::G_CTLZ_ZERO_UNDEF*//*Label 74*/ 191832,
    /*TargetOpcode::G_CTPOP*//*Label 75*/ 191902,
    /*TargetOpcode::G_BSWAP*//*Label 76*/ 191990,
    /*TargetOpcode::G_BITREVERSE*//*Label 77*/ 192810,
    /*TargetOpcode::G_FCEIL*//*Label 78*/ 192874, 0, 0,
    /*TargetOpcode::G_FSQRT*//*Label 79*/ 193014,
    /*TargetOpcode::G_FFLOOR*//*Label 80*/ 193152,
    /*TargetOpcode::G_FRINT*//*Label 81*/ 193456, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_STRICT_FADD*//*Label 82*/ 193596,
    /*TargetOpcode::G_STRICT_FSUB*//*Label 83*/ 194086,
    /*TargetOpcode::G_STRICT_FMUL*//*Label 84*/ 194219, 0, 0,
    /*TargetOpcode::G_STRICT_FMA*//*Label 85*/ 194597, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*AMDGPU::G_AMDGPU_ATOMIC_CMPXCHG*//*Label 86*/ 195272,
    /*AMDGPU::G_AMDGPU_ATOMIC_DEC*//*Label 87*/ 195779,
    /*AMDGPU::G_AMDGPU_ATOMIC_FMAX*//*Label 88*/ 196876,
    /*AMDGPU::G_AMDGPU_ATOMIC_FMIN*//*Label 89*/ 197665,
    /*AMDGPU::G_AMDGPU_ATOMIC_INC*//*Label 90*/ 198454,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_ADD*//*Label 91*/ 199551,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_AND*//*Label 92*/ 200140,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_CMPSWAP*//*Label 93*/ 200729,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_DEC*//*Label 94*/ 201326,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FADD*//*Label 95*/ 201915,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FMAX*//*Label 96*/ 202819,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FMIN*//*Label 97*/ 203694,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_INC*//*Label 98*/ 204569,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_OR*//*Label 99*/ 205158,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SMAX*//*Label 100*/ 205747,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SMIN*//*Label 101*/ 206336,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SUB*//*Label 102*/ 206925,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SWAP*//*Label 103*/ 207514,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_UMAX*//*Label 104*/ 208365,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_UMIN*//*Label 105*/ 208954,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_XOR*//*Label 106*/ 209543,
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD*//*Label 107*/ 210132,
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT*//*Label 108*/ 213628,
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT_D16*//*Label 109*/ 215964,
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SBYTE*//*Label 110*/ 220531,
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SSHORT*//*Label 111*/ 220836,
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_UBYTE*//*Label 112*/ 221141,
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_USHORT*//*Label 113*/ 221446,
    /*AMDGPU::G_AMDGPU_BUFFER_STORE*//*Label 114*/ 221751,
    /*AMDGPU::G_AMDGPU_BUFFER_STORE_BYTE*//*Label 115*/ 225223,
    /*AMDGPU::G_AMDGPU_BUFFER_STORE_FORMAT*//*Label 116*/ 225524,
    /*AMDGPU::G_AMDGPU_BUFFER_STORE_FORMAT_D16*//*Label 117*/ 227844,
    /*AMDGPU::G_AMDGPU_BUFFER_STORE_SHORT*//*Label 118*/ 231719,
    /*AMDGPU::G_AMDGPU_CLAMP*//*Label 119*/ 232020,
    /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE0*//*Label 120*/ 232242,
    /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE1*//*Label 121*/ 232286,
    /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE2*//*Label 122*/ 232330,
    /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE3*//*Label 123*/ 232374,
    /*AMDGPU::G_AMDGPU_CVT_PK_I16_I32*//*Label 124*/ 232418,
    /*AMDGPU::G_AMDGPU_FFBH_U32*//*Label 125*/ 232447,
    /*AMDGPU::G_AMDGPU_FFBL_B32*//*Label 126*/ 232517,
    /*AMDGPU::G_AMDGPU_FMAX_LEGACY*//*Label 127*/ 232583,
    /*AMDGPU::G_AMDGPU_FMED3*//*Label 128*/ 232650,
    /*AMDGPU::G_AMDGPU_FMIN_LEGACY*//*Label 129*/ 232815, 0, 0, 0, 0, 0,
    /*AMDGPU::G_AMDGPU_RCP_IFLAG*//*Label 130*/ 232882,
    /*AMDGPU::G_AMDGPU_SMED3*//*Label 131*/ 232928,
    /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD*//*Label 132*/ 233044,
    /*AMDGPU::G_AMDGPU_TBUFFER_LOAD_FORMAT*//*Label 133*/ 234213,
    /*AMDGPU::G_AMDGPU_TBUFFER_LOAD_FORMAT_D16*//*Label 134*/ 236805,
    /*AMDGPU::G_AMDGPU_TBUFFER_STORE_FORMAT*//*Label 135*/ 240214,
    /*AMDGPU::G_AMDGPU_TBUFFER_STORE_FORMAT_D16*//*Label 136*/ 242790,
    /*AMDGPU::G_AMDGPU_UMED3*//*Label 137*/ 245809,
    // Label 0: @1712
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 12, /*)*//*default:*//*Label 143*/ 3390,
    /*GILLT_s16*//*Label 139*/ 1722,
    /*GILLT_s32*//*Label 140*/ 1948,
    /*GILLT_s64*//*Label 141*/ 3294,
    /*GILLT_v2s16*//*Label 142*/ 3322,
    // Label 139: @1722
    GIM_Try, /*On fail goto*//*Label 144*/ 1947,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_Try, /*On fail goto*//*Label 145*/ 1775, // Rule ID 1457 //
        GIM_CheckFeatures, GIFBS_Has16BitInsts,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_NegSubInlineIntConst16,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_U16_e64:{ *:[i16] } VSrc_b16:{ *:[i16] }:$src0, (NegateImm:{ *:[i16 i32 f16 f32 v2i16 v2f16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_SUB_U16_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderNegateImm, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1457,
        GIR_Done,
      // Label 145: @1775
      GIM_Try, /*On fail goto*//*Label 146*/ 1823, // Rule ID 1494 //
        GIM_CheckFeatures, GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MAD_U16_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1494,
        GIR_Done,
      // Label 146: @1823
      GIM_Try, /*On fail goto*//*Label 147*/ 1871, // Rule ID 1495 //
        GIM_CheckFeatures, GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_I16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MAD_I16_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1495,
        GIR_Done,
      // Label 147: @1871
      GIM_Try, /*On fail goto*//*Label 148*/ 1919, // Rule ID 3854 //
        GIM_CheckFeatures, GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MAD_U16_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3854,
        GIR_Done,
      // Label 148: @1919
      GIM_Try, /*On fail goto*//*Label 149*/ 1946, // Rule ID 555 //
        GIM_CheckFeatures, GIFBS_Has16BitInsts,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_ADD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_ADD_U16_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 555,
        GIR_Done,
      // Label 149: @1946
      GIM_Reject,
    // Label 144: @1947
    GIM_Reject,
    // Label 140: @1948
    GIM_Try, /*On fail goto*//*Label 150*/ 3293,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 151*/ 2054, // Rule ID 1499 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIPFP_MI_Predicate_csh_mask_32,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_15352,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:1:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_15351,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:1:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_15352>>, i32:{ *:[i32] }:$src2:$pred:1:z)<<P:1:Predicate_anonymous_15351>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHL_ADD_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1499,
        GIR_Done,
      // Label 151: @2054
      GIM_Try, /*On fail goto*//*Label 152*/ 2150, // Rule ID 3857 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:1:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIPFP_MI_Predicate_csh_mask_32,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_15352,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_15351,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:1:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:1:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_15352>>)<<P:1:Predicate_anonymous_15351>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHL_ADD_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3857,
        GIR_Done,
      // Label 152: @2150
      GIM_Try, /*On fail goto*//*Label 153*/ 2213, // Rule ID 61 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_shl_oneuse,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_shl1_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 1:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl1_add>>  =>  (S_LSHL1_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL1_ADD_U32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61,
        GIR_Done,
      // Label 153: @2213
      GIM_Try, /*On fail goto*//*Label 154*/ 2276, // Rule ID 62 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_shl_oneuse,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_shl2_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 2:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl2_add>>  =>  (S_LSHL2_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL2_ADD_U32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62,
        GIR_Done,
      // Label 154: @2276
      GIM_Try, /*On fail goto*//*Label 155*/ 2339, // Rule ID 63 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_shl_oneuse,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_shl3_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 3:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl3_add>>  =>  (S_LSHL3_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL3_ADD_U32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 63,
        GIR_Done,
      // Label 155: @2339
      GIM_Try, /*On fail goto*//*Label 156*/ 2402, // Rule ID 64 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_shl_oneuse,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_shl4_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 4:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl4_add>>  =>  (S_LSHL4_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL4_ADD_U32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64,
        GIR_Done,
      // Label 156: @2402
      GIM_Try, /*On fail goto*//*Label 157*/ 2465, // Rule ID 3801 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_shl_oneuse,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_shl1_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 1:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl1_add>>  =>  (S_LSHL1_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL1_ADD_U32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3801,
        GIR_Done,
      // Label 157: @2465
      GIM_Try, /*On fail goto*//*Label 158*/ 2528, // Rule ID 3802 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_shl_oneuse,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_shl2_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 2:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl2_add>>  =>  (S_LSHL2_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL2_ADD_U32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3802,
        GIR_Done,
      // Label 158: @2528
      GIM_Try, /*On fail goto*//*Label 159*/ 2591, // Rule ID 3803 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_shl_oneuse,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_shl3_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 3:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl3_add>>  =>  (S_LSHL3_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL3_ADD_U32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3803,
        GIR_Done,
      // Label 159: @2591
      GIM_Try, /*On fail goto*//*Label 160*/ 2654, // Rule ID 3804 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_shl_oneuse,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_shl4_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 4:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl4_add>>  =>  (S_LSHL4_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL4_ADD_U32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3804,
        GIR_Done,
      // Label 160: @2654
      GIM_Try, /*On fail goto*//*Label 161*/ 2721, // Rule ID 1502 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ADD,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_15355,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:3:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_15357,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:3:x, i32:{ *:[i32] }:$src1:$pred:3:y)<<P:Predicate_anonymous_15355>>, i32:{ *:[i32] }:$src2:$pred:3:z)<<P:3:Predicate_anonymous_15357>>  =>  (V_ADD3_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_ADD3_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1502,
        GIR_Done,
      // Label 161: @2721
      GIM_Try, /*On fail goto*//*Label 162*/ 2788, // Rule ID 1498 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_15352,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:1:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_15351,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, i32:{ *:[i32] }:$src1:$pred:1:y)<<P:Predicate_anonymous_15352>>, i32:{ *:[i32] }:$src2:$pred:1:z)<<P:1:Predicate_anonymous_15351>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHL_ADD_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1498,
        GIR_Done,
      // Label 162: @2788
      GIM_Try, /*On fail goto*//*Label 163*/ 2855, // Rule ID 1507 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:7:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:7:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_15368,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:7:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_15367,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:7:x, i32:{ *:[i32] }:$src1:$pred:7:y)<<P:Predicate_anonymous_15368>>, i32:{ *:[i32] }:$src2:$pred:7:z)<<P:7:Predicate_anonymous_15367>>  =>  (V_XAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_XAD_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1507,
        GIR_Done,
      // Label 163: @2855
      GIM_Try, /*On fail goto*//*Label 164*/ 2922, // Rule ID 3858 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:3:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ADD,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_15355,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_15357,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:3:z, (add:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:3:x, i32:{ *:[i32] }:$src1:$pred:3:y)<<P:Predicate_anonymous_15355>>)<<P:3:Predicate_anonymous_15357>>  =>  (V_ADD3_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_ADD3_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3858,
        GIR_Done,
      // Label 164: @2922
      GIM_Try, /*On fail goto*//*Label 165*/ 2989, // Rule ID 3856 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:1:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_15352,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_15351,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:1:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, i32:{ *:[i32] }:$src1:$pred:1:y)<<P:Predicate_anonymous_15352>>)<<P:1:Predicate_anonymous_15351>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHL_ADD_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3856,
        GIR_Done,
      // Label 165: @2989
      GIM_Try, /*On fail goto*//*Label 166*/ 3056, // Rule ID 3863 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:7:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:7:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:7:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_15368,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_15367,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:7:z, (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:7:x, i32:{ *:[i32] }:$src1:$pred:7:y)<<P:Predicate_anonymous_15368>>)<<P:7:Predicate_anonymous_15367>>  =>  (V_XAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_XAD_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3863,
        GIR_Done,
      // Label 166: @3056
      GIM_Try, /*On fail goto*//*Label 167*/ 3094, // Rule ID 3395 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_NegSubInlineConst32,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)  =>  (S_SUB_I32:{ *:[i32] }:{ *:[i1] } SReg_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i1 i16 i32 f16 f32 v2i16 v2f16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_SUB_I32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderNegateImm, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3395,
        GIR_Done,
      // Label 167: @3094
      GIM_Try, /*On fail goto*//*Label 168*/ 3137, // Rule ID 3396 //
        GIM_CheckFeatures, GIFBS_HasAddNoCarryInsts,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_NegSubInlineConst32,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)  =>  (V_SUB_U32_e64:{ *:[i32] } VS_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i16 i32 f16 f32 v2i16 v2f16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_SUB_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderNegateImm, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3396,
        GIR_Done,
      // Label 168: @3137
      GIM_Try, /*On fail goto*//*Label 169*/ 3187, // Rule ID 3397 //
        GIM_CheckFeatures, GIFBS_NotHasAddNoCarryInsts,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_NegSubInlineConst32,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)  =>  (V_SUB_CO_U32_e64:{ *:[i32] }:{ *:[i1] } VS_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i16 i32 f16 f32 v2i16 v2f16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_SUB_CO_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderNegateImm, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3397,
        GIR_Done,
      // Label 169: @3187
      GIM_Try, /*On fail goto*//*Label 170*/ 3214, // Rule ID 22 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11026,
        // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_11026>>  =>  (S_ADD_I32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_ADD_I32,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22,
        GIR_Done,
      // Label 170: @3214
      GIM_Try, /*On fail goto*//*Label 171*/ 3253, // Rule ID 518 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CTPOP,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$src0), i32:{ *:[i32] }:$src1)  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BCNT_U32_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 518,
        GIR_Done,
      // Label 171: @3253
      GIM_Try, /*On fail goto*//*Label 172*/ 3292, // Rule ID 3816 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CTPOP,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src1, (ctpop:{ *:[i32] } i32:{ *:[i32] }:$src0))  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BCNT_U32_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3816,
        GIR_Done,
      // Label 172: @3292
      GIM_Reject,
    // Label 150: @3293
    GIM_Reject,
    // Label 141: @3294
    GIM_Try, /*On fail goto*//*Label 173*/ 3321, // Rule ID 868 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11026,
      // (add:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_11026>>  =>  (S_ADD_U64_PSEUDO:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_ADD_U64_PSEUDO,
      GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 868,
      GIR_Done,
    // Label 173: @3321
    GIM_Reject,
    // Label 142: @3322
    GIM_Try, /*On fail goto*//*Label 174*/ 3389, // Rule ID 658 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_vop3pmods,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/1, GICP_gi_vop3pmods,
      // (add:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_ADD_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_PK_ADD_U16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // src0_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // src0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/1, /*SubOperand*/1, // src1_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/1, /*SubOperand*/0, // src1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 658,
      GIR_Done,
    // Label 174: @3389
    GIM_Reject,
    // Label 143: @3390
    GIM_Reject,
    // Label 1: @3391
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 12, /*)*//*default:*//*Label 179*/ 3573,
    /*GILLT_s16*//*Label 175*/ 3401,
    /*GILLT_s32*//*Label 176*/ 3441,
    /*GILLT_s64*//*Label 177*/ 3477,
    /*GILLT_v2s16*//*Label 178*/ 3505,
    // Label 175: @3401
    GIM_Try, /*On fail goto*//*Label 180*/ 3440, // Rule ID 556 //
      GIM_CheckFeatures, GIFBS_Has16BitInsts,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (sub:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_SUB_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_SUB_U16_e64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 556,
      GIR_Done,
    // Label 180: @3440
    GIM_Reject,
    // Label 176: @3441
    GIM_Try, /*On fail goto*//*Label 181*/ 3476, // Rule ID 23 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11027,
      // (sub:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_11027>>  =>  (S_SUB_I32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_SUB_I32,
      GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 23,
      GIR_Done,
    // Label 181: @3476
    GIM_Reject,
    // Label 177: @3477
    GIM_Try, /*On fail goto*//*Label 182*/ 3504, // Rule ID 869 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11027,
      // (sub:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_11027>>  =>  (S_SUB_U64_PSEUDO:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_SUB_U64_PSEUDO,
      GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 869,
      GIR_Done,
    // Label 182: @3504
    GIM_Reject,
    // Label 178: @3505
    GIM_Try, /*On fail goto*//*Label 183*/ 3572, // Rule ID 664 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_vop3pmods,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/1, GICP_gi_vop3pmods,
      // (sub:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_SUB_I16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_PK_SUB_I16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // src0_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // src0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/1, /*SubOperand*/1, // src1_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/1, /*SubOperand*/0, // src1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 664,
      GIR_Done,
    // Label 183: @3572
    GIM_Reject,
    // Label 179: @3573
    GIM_Reject,
    // Label 2: @3574
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 12, /*)*//*default:*//*Label 187*/ 3726,
    /*GILLT_s16*//*Label 184*/ 3584,
    /*GILLT_s32*//*Label 185*/ 3611, 0,
    /*GILLT_v2s16*//*Label 186*/ 3658,
    // Label 184: @3584
    GIM_Try, /*On fail goto*//*Label 188*/ 3610, // Rule ID 557 //
      GIM_CheckFeatures, GIFBS_Has16BitInsts,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_MUL_LO_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MUL_LO_U16_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 557,
      GIR_Done,
    // Label 188: @3610
    GIM_Reject,
    // Label 185: @3611
    GIM_Try, /*On fail goto*//*Label 189*/ 3657,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 190*/ 3637, // Rule ID 60 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11045,
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_11045>>  =>  (S_MUL_I32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_MUL_I32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60,
        GIR_Done,
      // Label 190: @3637
      GIM_Try, /*On fail goto*//*Label 191*/ 3656, // Rule ID 581 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_15124,
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_15124>>  =>  (V_MUL_LO_U32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MUL_LO_U32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 581,
        GIR_Done,
      // Label 191: @3656
      GIM_Reject,
    // Label 189: @3657
    GIM_Reject,
    // Label 186: @3658
    GIM_Try, /*On fail goto*//*Label 192*/ 3725, // Rule ID 659 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_vop3pmods,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/1, GICP_gi_vop3pmods,
      // (mul:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_MUL_LO_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_PK_MUL_LO_U16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // src0_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // src0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/1, /*SubOperand*/1, // src1_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/1, /*SubOperand*/0, // src1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 659,
      GIR_Done,
    // Label 192: @3725
    GIM_Reject,
    // Label 187: @3726
    GIM_Reject,
    // Label 3: @3727
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 17, /*)*//*default:*//*Label 199*/ 4556,
    /*GILLT_s16*//*Label 193*/ 3742,
    /*GILLT_s32*//*Label 194*/ 3876,
    /*GILLT_s64*//*Label 195*/ 4029,
    /*GILLT_v2s16*//*Label 196*/ 4152,
    /*GILLT_v2s32*//*Label 197*/ 4302, 0, 0, 0,
    /*GILLT_v4s16*//*Label 198*/ 4429,
    // Label 193: @3742
    GIM_Try, /*On fail goto*//*Label 200*/ 3875,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 201*/ 3805, // Rule ID 3844 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11005,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11035,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i16] } (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] })<<P:Predicate_anonymous_11005>>, i16:{ *:[i16] }:$src0)<<P:Predicate_anonymous_11035>>  =>  (S_ANDN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3844,
        GIR_Done,
      // Label 201: @3805
      GIM_Try, /*On fail goto*//*Label 202*/ 3858, // Rule ID 1228 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11005,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11035,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] })<<P:Predicate_anonymous_11005>>)<<P:Predicate_anonymous_11035>>  =>  (S_ANDN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1228,
        GIR_Done,
      // Label 202: @3858
      GIM_Try, /*On fail goto*//*Label 203*/ 3874, // Rule ID 1451 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_AND_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1451,
        GIR_Done,
      // Label 203: @3874
      GIM_Reject,
    // Label 200: @3875
    GIM_Reject,
    // Label 194: @3876
    GIM_Try, /*On fail goto*//*Label 204*/ 4028,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 205*/ 3939, // Rule ID 3797 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11005,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11035,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] })<<P:Predicate_anonymous_11005>>, i32:{ *:[i32] }:$src0)<<P:Predicate_anonymous_11035>>  =>  (S_ANDN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3797,
        GIR_Done,
      // Label 205: @3939
      GIM_Try, /*On fail goto*//*Label 206*/ 3992, // Rule ID 43 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11005,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11035,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] })<<P:Predicate_anonymous_11005>>)<<P:Predicate_anonymous_11035>>  =>  (S_ANDN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 43,
        GIR_Done,
      // Label 206: @3992
      GIM_Try, /*On fail goto*//*Label 207*/ 4011, // Rule ID 31 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11035,
        // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_11035>>  =>  (S_AND_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_AND_B32,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 31,
        GIR_Done,
      // Label 207: @4011
      GIM_Try, /*On fail goto*//*Label 208*/ 4027, // Rule ID 513 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_AND_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_AND_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 513,
        GIR_Done,
      // Label 208: @4027
      GIM_Reject,
    // Label 204: @4028
    GIM_Reject,
    // Label 195: @4029
    GIM_Try, /*On fail goto*//*Label 209*/ 4151,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11035,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_Try, /*On fail goto*//*Label 210*/ 4092, // Rule ID 3798 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11005,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] })<<P:Predicate_anonymous_11005>>, i64:{ *:[i64] }:$src0)<<P:Predicate_anonymous_11035>>  =>  (S_ANDN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3798,
        GIR_Done,
      // Label 210: @4092
      GIM_Try, /*On fail goto*//*Label 211*/ 4138, // Rule ID 44 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11005,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } i64:{ *:[i64] }:$src0, (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] })<<P:Predicate_anonymous_11005>>)<<P:Predicate_anonymous_11035>>  =>  (S_ANDN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44,
        GIR_Done,
      // Label 211: @4138
      GIM_Try, /*On fail goto*//*Label 212*/ 4150, // Rule ID 32 //
        // (and:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_11035>>  =>  (S_AND_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_AND_B64,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 32,
        GIR_Done,
      // Label 212: @4150
      GIM_Reject,
    // Label 209: @4151
    GIM_Reject,
    // Label 196: @4152
    GIM_Try, /*On fail goto*//*Label 213*/ 4301,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_Try, /*On fail goto*//*Label 214*/ 4223, // Rule ID 3845 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11068,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11035,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v2i16] } (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] })<<P:Predicate_anonymous_11068>>, v2i16:{ *:[v2i16] }:$src0)<<P:Predicate_anonymous_11035>>  =>  (S_ANDN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3845,
        GIR_Done,
      // Label 214: @4223
      GIM_Try, /*On fail goto*//*Label 215*/ 4284, // Rule ID 1229 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11068,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11035,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] })<<P:Predicate_anonymous_11068>>)<<P:Predicate_anonymous_11035>>  =>  (S_ANDN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1229,
        GIR_Done,
      // Label 215: @4284
      GIM_Try, /*On fail goto*//*Label 216*/ 4300, // Rule ID 1454 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (and:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[v2i16] } VSrc_b32:{ *:[v2i16] }:$src0, VSrc_b32:{ *:[v2i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_AND_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1454,
        GIR_Done,
      // Label 216: @4300
      GIM_Reject,
    // Label 213: @4301
    GIM_Reject,
    // Label 197: @4302
    GIM_Try, /*On fail goto*//*Label 217*/ 4428,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11035,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_Try, /*On fail goto*//*Label 218*/ 4373, // Rule ID 3847 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11068,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v2i32] } (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] })<<P:Predicate_anonymous_11068>>, v2i32:{ *:[v2i32] }:$src0)<<P:Predicate_anonymous_11035>>  =>  (S_ANDN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3847,
        GIR_Done,
      // Label 218: @4373
      GIM_Try, /*On fail goto*//*Label 219*/ 4427, // Rule ID 1231 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11068,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src0, (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] })<<P:Predicate_anonymous_11068>>)<<P:Predicate_anonymous_11035>>  =>  (S_ANDN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1231,
        GIR_Done,
      // Label 219: @4427
      GIM_Reject,
    // Label 217: @4428
    GIM_Reject,
    // Label 198: @4429
    GIM_Try, /*On fail goto*//*Label 220*/ 4555,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11035,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_Try, /*On fail goto*//*Label 221*/ 4500, // Rule ID 3846 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11068,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i16] } (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] })<<P:Predicate_anonymous_11068>>, v4i16:{ *:[v4i16] }:$src0)<<P:Predicate_anonymous_11035>>  =>  (S_ANDN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3846,
        GIR_Done,
      // Label 221: @4500
      GIM_Try, /*On fail goto*//*Label 222*/ 4554, // Rule ID 1230 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11068,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src0, (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] })<<P:Predicate_anonymous_11068>>)<<P:Predicate_anonymous_11035>>  =>  (S_ANDN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1230,
        GIR_Done,
      // Label 222: @4554
      GIM_Reject,
    // Label 220: @4555
    GIM_Reject,
    // Label 199: @4556
    GIM_Reject,
    // Label 4: @4557
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 17, /*)*//*default:*//*Label 229*/ 16618,
    /*GILLT_s16*//*Label 223*/ 4572,
    /*GILLT_s32*//*Label 224*/ 4706,
    /*GILLT_s64*//*Label 225*/ 7861,
    /*GILLT_v2s16*//*Label 226*/ 16214,
    /*GILLT_v2s32*//*Label 227*/ 16364, 0, 0, 0,
    /*GILLT_v4s16*//*Label 228*/ 16491,
    // Label 223: @4572
    GIM_Try, /*On fail goto*//*Label 230*/ 4705,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 231*/ 4635, // Rule ID 3848 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11005,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11036,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i16] } (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] })<<P:Predicate_anonymous_11005>>, i16:{ *:[i16] }:$src0)<<P:Predicate_anonymous_11036>>  =>  (S_ORN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3848,
        GIR_Done,
      // Label 231: @4635
      GIM_Try, /*On fail goto*//*Label 232*/ 4688, // Rule ID 1232 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11005,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11036,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] })<<P:Predicate_anonymous_11005>>)<<P:Predicate_anonymous_11036>>  =>  (S_ORN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1232,
        GIR_Done,
      // Label 232: @4688
      GIM_Try, /*On fail goto*//*Label 233*/ 4704, // Rule ID 1452 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_OR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_OR_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1452,
        GIR_Done,
      // Label 233: @4704
      GIM_Reject,
    // Label 230: @4705
    GIM_Reject,
    // Label 224: @4706
    GIM_Try, /*On fail goto*//*Label 234*/ 7860,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 235*/ 4805, // Rule ID 6512 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6512,
        GIR_Done,
      // Label 235: @4805
      GIM_Try, /*On fail goto*//*Label 236*/ 4894, // Rule ID 6511 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6511,
        GIR_Done,
      // Label 236: @4894
      GIM_Try, /*On fail goto*//*Label 237*/ 4983, // Rule ID 6510 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6510,
        GIR_Done,
      // Label 237: @4983
      GIM_Try, /*On fail goto*//*Label 238*/ 5072, // Rule ID 6509 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })), (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6509,
        GIR_Done,
      // Label 238: @5072
      GIM_Try, /*On fail goto*//*Label 239*/ 5161, // Rule ID 6506 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6506,
        GIR_Done,
      // Label 239: @5161
      GIM_Try, /*On fail goto*//*Label 240*/ 5250, // Rule ID 6508 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6508,
        GIR_Done,
      // Label 240: @5250
      GIM_Try, /*On fail goto*//*Label 241*/ 5339, // Rule ID 3252 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3252,
        GIR_Done,
      // Label 241: @5339
      GIM_Try, /*On fail goto*//*Label 242*/ 5428, // Rule ID 6507 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6507,
        GIR_Done,
      // Label 242: @5428
      GIM_Try, /*On fail goto*//*Label 243*/ 5524, // Rule ID 1504 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:4:x
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:4:y
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIPFP_MI_Predicate_csh_mask_32,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_15352,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:4:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_15359,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:4:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:4:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_15352>>, i32:{ *:[i32] }:$src2:$pred:4:z)<<P:4:Predicate_anonymous_15359>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHL_OR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1504,
        GIR_Done,
      // Label 243: @5524
      GIM_Try, /*On fail goto*//*Label 244*/ 5620, // Rule ID 3860 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:4:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:4:x
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:4:y
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIPFP_MI_Predicate_csh_mask_32,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_15352,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_15359,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:4:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:4:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:4:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_15352>>)<<P:4:Predicate_anonymous_15359>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHL_OR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3860,
        GIR_Done,
      // Label 244: @5620
      GIM_Try, /*On fail goto*//*Label 245*/ 5726, // Rule ID 6557 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6557,
        GIR_Done,
      // Label 245: @5726
      GIM_Try, /*On fail goto*//*Label 246*/ 5832, // Rule ID 6558 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6558,
        GIR_Done,
      // Label 246: @5832
      GIM_Try, /*On fail goto*//*Label 247*/ 5938, // Rule ID 6559 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6559,
        GIR_Done,
      // Label 247: @5938
      GIM_Try, /*On fail goto*//*Label 248*/ 6044, // Rule ID 6560 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6560,
        GIR_Done,
      // Label 248: @6044
      GIM_Try, /*On fail goto*//*Label 249*/ 6150, // Rule ID 6553 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6553,
        GIR_Done,
      // Label 249: @6150
      GIM_Try, /*On fail goto*//*Label 250*/ 6256, // Rule ID 6554 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6554,
        GIR_Done,
      // Label 250: @6256
      GIM_Try, /*On fail goto*//*Label 251*/ 6362, // Rule ID 6555 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6555,
        GIR_Done,
      // Label 251: @6362
      GIM_Try, /*On fail goto*//*Label 252*/ 6468, // Rule ID 6556 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6556,
        GIR_Done,
      // Label 252: @6468
      GIM_Try, /*On fail goto*//*Label 253*/ 6574, // Rule ID 6547 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6547,
        GIR_Done,
      // Label 253: @6574
      GIM_Try, /*On fail goto*//*Label 254*/ 6680, // Rule ID 6548 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6548,
        GIR_Done,
      // Label 254: @6680
      GIM_Try, /*On fail goto*//*Label 255*/ 6786, // Rule ID 6551 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6551,
        GIR_Done,
      // Label 255: @6786
      GIM_Try, /*On fail goto*//*Label 256*/ 6892, // Rule ID 6552 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6552,
        GIR_Done,
      // Label 256: @6892
      GIM_Try, /*On fail goto*//*Label 257*/ 6998, // Rule ID 3407 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3407,
        GIR_Done,
      // Label 257: @6998
      GIM_Try, /*On fail goto*//*Label 258*/ 7104, // Rule ID 6546 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6546,
        GIR_Done,
      // Label 258: @7104
      GIM_Try, /*On fail goto*//*Label 259*/ 7210, // Rule ID 6549 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6549,
        GIR_Done,
      // Label 259: @7210
      GIM_Try, /*On fail goto*//*Label 260*/ 7316, // Rule ID 6550 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)))<<P:Predicate_anonymous_19364>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6550,
        GIR_Done,
      // Label 260: @7316
      GIM_Try, /*On fail goto*//*Label 261*/ 7369, // Rule ID 3799 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11005,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11036,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] })<<P:Predicate_anonymous_11005>>, i32:{ *:[i32] }:$src0)<<P:Predicate_anonymous_11036>>  =>  (S_ORN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3799,
        GIR_Done,
      // Label 261: @7369
      GIM_Try, /*On fail goto*//*Label 262*/ 7422, // Rule ID 45 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11005,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11036,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src0, (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] })<<P:Predicate_anonymous_11005>>)<<P:Predicate_anonymous_11036>>  =>  (S_ORN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45,
        GIR_Done,
      // Label 262: @7422
      GIM_Try, /*On fail goto*//*Label 263*/ 7489, // Rule ID 1505 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:5:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_15362,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:5:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_15361,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, i32:{ *:[i32] }:$src1:$pred:5:y)<<P:Predicate_anonymous_15362>>, i32:{ *:[i32] }:$src2:$pred:5:z)<<P:5:Predicate_anonymous_15361>>  =>  (V_AND_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_AND_OR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1505,
        GIR_Done,
      // Label 263: @7489
      GIM_Try, /*On fail goto*//*Label 264*/ 7556, // Rule ID 1506 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:6:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:6:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_15365,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:6:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_15364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:6:x, i32:{ *:[i32] }:$src1:$pred:6:y)<<P:Predicate_anonymous_15365>>, i32:{ *:[i32] }:$src2:$pred:6:z)<<P:6:Predicate_anonymous_15364>>  =>  (V_OR3_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_OR3_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1506,
        GIR_Done,
      // Label 264: @7556
      GIM_Try, /*On fail goto*//*Label 265*/ 7623, // Rule ID 1503 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:4:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:4:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_15352,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:4:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_15359,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:4:x, i32:{ *:[i32] }:$src1:$pred:4:y)<<P:Predicate_anonymous_15352>>, i32:{ *:[i32] }:$src2:$pred:4:z)<<P:4:Predicate_anonymous_15359>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHL_OR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1503,
        GIR_Done,
      // Label 265: @7623
      GIM_Try, /*On fail goto*//*Label 266*/ 7690, // Rule ID 3861 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:5:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:5:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_15362,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_15361,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:5:z, (and:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, i32:{ *:[i32] }:$src1:$pred:5:y)<<P:Predicate_anonymous_15362>>)<<P:5:Predicate_anonymous_15361>>  =>  (V_AND_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_AND_OR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3861,
        GIR_Done,
      // Label 266: @7690
      GIM_Try, /*On fail goto*//*Label 267*/ 7757, // Rule ID 3862 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:6:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:6:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:6:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_15365,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_15364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:6:z, (or:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:6:x, i32:{ *:[i32] }:$src1:$pred:6:y)<<P:Predicate_anonymous_15365>>)<<P:6:Predicate_anonymous_15364>>  =>  (V_OR3_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_OR3_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3862,
        GIR_Done,
      // Label 267: @7757
      GIM_Try, /*On fail goto*//*Label 268*/ 7824, // Rule ID 3859 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:4:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:4:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:4:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_15352,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_15359,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:4:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:4:x, i32:{ *:[i32] }:$src1:$pred:4:y)<<P:Predicate_anonymous_15352>>)<<P:4:Predicate_anonymous_15359>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHL_OR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3859,
        GIR_Done,
      // Label 268: @7824
      GIM_Try, /*On fail goto*//*Label 269*/ 7843, // Rule ID 33 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11036,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_11036>>  =>  (S_OR_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_OR_B32,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 33,
        GIR_Done,
      // Label 269: @7843
      GIM_Try, /*On fail goto*//*Label 270*/ 7859, // Rule ID 514 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_OR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_OR_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 514,
        GIR_Done,
      // Label 270: @7859
      GIM_Reject,
    // Label 234: @7860
    GIM_Reject,
    // Label 225: @7861
    GIM_Try, /*On fail goto*//*Label 271*/ 16213,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 272*/ 8158, // Rule ID 6520 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] }), i64:{ *:[i64] }:$z), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/3, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/3, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6520,
        GIR_Done,
      // Label 272: @8158
      GIM_Try, /*On fail goto*//*Label 273*/ 8445, // Rule ID 6519 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] }), i64:{ *:[i64] }:$z), (and:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/3, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/3, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6519,
        GIR_Done,
      // Label 273: @8445
      GIM_Try, /*On fail goto*//*Label 274*/ 8732, // Rule ID 6518 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$z, (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] })), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/3, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/3, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6518,
        GIR_Done,
      // Label 274: @8732
      GIM_Try, /*On fail goto*//*Label 275*/ 9019, // Rule ID 6517 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$z, (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] })), (and:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/3, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/3, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6517,
        GIR_Done,
      // Label 275: @9019
      GIM_Try, /*On fail goto*//*Label 276*/ 9306, // Rule ID 6514 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$x), (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] }), i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6514,
        GIR_Done,
      // Label 276: @9306
      GIM_Try, /*On fail goto*//*Label 277*/ 9593, // Rule ID 6516 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$y), (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] }), i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6516,
        GIR_Done,
      // Label 277: @9593
      GIM_Try, /*On fail goto*//*Label 278*/ 9880, // Rule ID 3254 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$x), (and:{ *:[i64] } i64:{ *:[i64] }:$z, (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] })))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 3254,
        GIR_Done,
      // Label 278: @9880
      GIM_Try, /*On fail goto*//*Label 279*/ 10167, // Rule ID 6515 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$y), (and:{ *:[i64] } i64:{ *:[i64] }:$z, (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] })))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6515,
        GIR_Done,
      // Label 279: @10167
      GIM_Try, /*On fail goto*//*Label 280*/ 10537, // Rule ID 6572 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$y), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6572,
        GIR_Done,
      // Label 280: @10537
      GIM_Try, /*On fail goto*//*Label 281*/ 10907, // Rule ID 6573 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$y), (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6573,
        GIR_Done,
      // Label 281: @10907
      GIM_Try, /*On fail goto*//*Label 282*/ 11277, // Rule ID 6574 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), i64:{ *:[i64] }:$y), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6574,
        GIR_Done,
      // Label 282: @11277
      GIM_Try, /*On fail goto*//*Label 283*/ 11647, // Rule ID 6575 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), i64:{ *:[i64] }:$y), (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6575,
        GIR_Done,
      // Label 283: @11647
      GIM_Try, /*On fail goto*//*Label 284*/ 12017, // Rule ID 6568 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z)), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6568,
        GIR_Done,
      // Label 284: @12017
      GIM_Try, /*On fail goto*//*Label 285*/ 12387, // Rule ID 6569 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z)), (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6569,
        GIR_Done,
      // Label 285: @12387
      GIM_Try, /*On fail goto*//*Label 286*/ 12757, // Rule ID 6570 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x)), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6570,
        GIR_Done,
      // Label 286: @12757
      GIM_Try, /*On fail goto*//*Label 287*/ 13127, // Rule ID 6571 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x)), (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6571,
        GIR_Done,
      // Label 287: @13127
      GIM_Try, /*On fail goto*//*Label 288*/ 13497, // Rule ID 6562 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6562,
        GIR_Done,
      // Label 288: @13497
      GIM_Try, /*On fail goto*//*Label 289*/ 13867, // Rule ID 6563 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6563,
        GIR_Done,
      // Label 289: @13867
      GIM_Try, /*On fail goto*//*Label 290*/ 14237, // Rule ID 6566 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6566,
        GIR_Done,
      // Label 290: @14237
      GIM_Try, /*On fail goto*//*Label 291*/ 14607, // Rule ID 6567 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6567,
        GIR_Done,
      // Label 291: @14607
      GIM_Try, /*On fail goto*//*Label 292*/ 14977, // Rule ID 3408 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z)))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 3408,
        GIR_Done,
      // Label 292: @14977
      GIM_Try, /*On fail goto*//*Label 293*/ 15347, // Rule ID 6561 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x)))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6561,
        GIR_Done,
      // Label 293: @15347
      GIM_Try, /*On fail goto*//*Label 294*/ 15717, // Rule ID 6564 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z)))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6564,
        GIR_Done,
      // Label 294: @15717
      GIM_Try, /*On fail goto*//*Label 295*/ 16087, // Rule ID 6565 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19364,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x)))<<P:Predicate_anonymous_19364>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6565,
        GIR_Done,
      // Label 295: @16087
      GIM_Try, /*On fail goto*//*Label 296*/ 16140, // Rule ID 3800 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11005,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11036,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] })<<P:Predicate_anonymous_11005>>, i64:{ *:[i64] }:$src0)<<P:Predicate_anonymous_11036>>  =>  (S_ORN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3800,
        GIR_Done,
      // Label 296: @16140
      GIM_Try, /*On fail goto*//*Label 297*/ 16193, // Rule ID 46 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11005,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11036,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } i64:{ *:[i64] }:$src0, (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] })<<P:Predicate_anonymous_11005>>)<<P:Predicate_anonymous_11036>>  =>  (S_ORN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46,
        GIR_Done,
      // Label 297: @16193
      GIM_Try, /*On fail goto*//*Label 298*/ 16212, // Rule ID 34 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11036,
        // (or:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_11036>>  =>  (S_OR_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_OR_B64,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 34,
        GIR_Done,
      // Label 298: @16212
      GIM_Reject,
    // Label 271: @16213
    GIM_Reject,
    // Label 226: @16214
    GIM_Try, /*On fail goto*//*Label 299*/ 16363,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_Try, /*On fail goto*//*Label 300*/ 16285, // Rule ID 3849 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11068,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11036,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i16] } (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] })<<P:Predicate_anonymous_11068>>, v2i16:{ *:[v2i16] }:$src0)<<P:Predicate_anonymous_11036>>  =>  (S_ORN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3849,
        GIR_Done,
      // Label 300: @16285
      GIM_Try, /*On fail goto*//*Label 301*/ 16346, // Rule ID 1233 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11068,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11036,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] })<<P:Predicate_anonymous_11068>>)<<P:Predicate_anonymous_11036>>  =>  (S_ORN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1233,
        GIR_Done,
      // Label 301: @16346
      GIM_Try, /*On fail goto*//*Label 302*/ 16362, // Rule ID 1455 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (or:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1)  =>  (V_OR_B32_e64:{ *:[v2i16] } VSrc_b32:{ *:[v2i16] }:$src0, VSrc_b32:{ *:[v2i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_OR_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1455,
        GIR_Done,
      // Label 302: @16362
      GIM_Reject,
    // Label 299: @16363
    GIM_Reject,
    // Label 227: @16364
    GIM_Try, /*On fail goto*//*Label 303*/ 16490,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11036,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_Try, /*On fail goto*//*Label 304*/ 16435, // Rule ID 3851 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11068,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i32] } (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] })<<P:Predicate_anonymous_11068>>, v2i32:{ *:[v2i32] }:$src0)<<P:Predicate_anonymous_11036>>  =>  (S_ORN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3851,
        GIR_Done,
      // Label 304: @16435
      GIM_Try, /*On fail goto*//*Label 305*/ 16489, // Rule ID 1235 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11068,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src0, (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] })<<P:Predicate_anonymous_11068>>)<<P:Predicate_anonymous_11036>>  =>  (S_ORN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1235,
        GIR_Done,
      // Label 305: @16489
      GIM_Reject,
    // Label 303: @16490
    GIM_Reject,
    // Label 228: @16491
    GIM_Try, /*On fail goto*//*Label 306*/ 16617,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11036,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_Try, /*On fail goto*//*Label 307*/ 16562, // Rule ID 3850 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11068,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i16] } (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] })<<P:Predicate_anonymous_11068>>, v4i16:{ *:[v4i16] }:$src0)<<P:Predicate_anonymous_11036>>  =>  (S_ORN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3850,
        GIR_Done,
      // Label 307: @16562
      GIM_Try, /*On fail goto*//*Label 308*/ 16616, // Rule ID 1234 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_11068,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src0, (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] })<<P:Predicate_anonymous_11068>>)<<P:Predicate_anonymous_11036>>  =>  (S_ORN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1234,
        GIR_Done,
      // Label 308: @16616
      GIM_Reject,
    // Label 306: @16617
    GIM_Reject,
    // Label 229: @16618
    GIM_Reject,
    // Label 5: @16619
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 12, /*)*//*default:*//*Label 313*/ 20206,
    /*GILLT_s16*//*Label 309*/ 16629,
    /*GILLT_s32*//*Label 310*/ 16654,
    /*GILLT_s64*//*Label 311*/ 17786,
    /*GILLT_v2s16*//*Label 312*/ 20181,
    // Label 309: @16629
    GIM_Try, /*On fail goto*//*Label 314*/ 16653, // Rule ID 1453 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (xor:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_XOR_B32_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1453,
      GIR_Done,
    // Label 314: @16653
    GIM_Reject,
    // Label 310: @16654
    GIM_Try, /*On fail goto*//*Label 315*/ 17785,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 316*/ 16717, // Rule ID 39 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_and_oneuse,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11005,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_and_oneuse>>, -1:{ *:[i32] })<<P:Predicate_anonymous_11005>>  =>  (S_NAND_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_NAND_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 39,
        GIR_Done,
      // Label 316: @16717
      GIM_Try, /*On fail goto*//*Label 317*/ 16774, // Rule ID 41 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_or_oneuse,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11005,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_or_oneuse>>, -1:{ *:[i32] })<<P:Predicate_anonymous_11005>>  =>  (S_NOR_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_NOR_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 41,
        GIR_Done,
      // Label 317: @16774
      GIM_Try, /*On fail goto*//*Label 318*/ 16831, // Rule ID 37 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_xor_oneuse,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11005,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_xor_oneuse>>, -1:{ *:[i32] })<<P:Predicate_anonymous_11005>>  =>  (S_XNOR_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_XNOR_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 37,
        GIR_Done,
      // Label 318: @16831
      GIM_Try, /*On fail goto*//*Label 319*/ 16903, // Rule ID 6526 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[0] z
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19369,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$z)<<P:Predicate_anonymous_19369>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6526,
        GIR_Done,
      // Label 319: @16903
      GIM_Try, /*On fail goto*//*Label 320*/ 16975, // Rule ID 6527 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[0] z
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19369,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$z)<<P:Predicate_anonymous_19369>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6527,
        GIR_Done,
      // Label 320: @16975
      GIM_Try, /*On fail goto*//*Label 321*/ 17047, // Rule ID 6524 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[0] z
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19369,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, (xor:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$z)), i32:{ *:[i32] }:$z)<<P:Predicate_anonymous_19369>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6524,
        GIR_Done,
      // Label 321: @17047
      GIM_Try, /*On fail goto*//*Label 322*/ 17119, // Rule ID 6525 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[0] z
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19369,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, (xor:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)), i32:{ *:[i32] }:$z)<<P:Predicate_anonymous_19369>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6525,
        GIR_Done,
      // Label 322: @17119
      GIM_Try, /*On fail goto*//*Label 323*/ 17191, // Rule ID 6523 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] z
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19369,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$z, (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_19369>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6523,
        GIR_Done,
      // Label 323: @17191
      GIM_Try, /*On fail goto*//*Label 324*/ 17263, // Rule ID 6522 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[2] z
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19369,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$z, (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_19369>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6522,
        GIR_Done,
      // Label 324: @17263
      GIM_Try, /*On fail goto*//*Label 325*/ 17335, // Rule ID 6521 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] z
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19369,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$z, (and:{ *:[i32] } i32:{ *:[i32] }:$x, (xor:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)))<<P:Predicate_anonymous_19369>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6521,
        GIR_Done,
      // Label 325: @17335
      GIM_Try, /*On fail goto*//*Label 326*/ 17407, // Rule ID 3255 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[2] z
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19369,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$z, (and:{ *:[i32] } i32:{ *:[i32] }:$x, (xor:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$z)))<<P:Predicate_anonymous_19369>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3255,
        GIR_Done,
      // Label 326: @17407
      GIM_Try, /*On fail goto*//*Label 327*/ 17440, // Rule ID 0 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11005,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, -1:{ *:[i32] })<<P:Predicate_anonymous_11005>>  =>  (S_NOT_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_NOT_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 0,
        GIR_Done,
      // Label 327: @17440
      GIM_Try, /*On fail goto*//*Label 328*/ 17511, // Rule ID 1513 //
        GIM_CheckFeatures, GIFBS_isGFX10Plus,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:8:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:8:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_15368,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:8:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_15380,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:8:x, i32:{ *:[i32] }:$src1:$pred:8:y)<<P:Predicate_anonymous_15368>>, i32:{ *:[i32] }:$src2:$pred:8:z)<<P:8:Predicate_anonymous_15380>>  =>  (V_XOR3_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_XOR3_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1513,
        GIR_Done,
      // Label 328: @17511
      GIM_Try, /*On fail goto*//*Label 329*/ 17582, // Rule ID 3865 //
        GIM_CheckFeatures, GIFBS_isGFX10Plus,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:8:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:8:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:8:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_15368,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_15380,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:8:z, (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:8:x, i32:{ *:[i32] }:$src1:$pred:8:y)<<P:Predicate_anonymous_15368>>)<<P:8:Predicate_anonymous_15380>>  =>  (V_XOR3_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_XOR3_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3865,
        GIR_Done,
      // Label 329: @17582
      GIM_Try, /*On fail goto*//*Label 330*/ 17605, // Rule ID 35 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11037,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_11037>>  =>  (S_XOR_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_XOR_B32,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 35,
        GIR_Done,
      // Label 330: @17605
      GIM_Try, /*On fail goto*//*Label 331*/ 17658, // Rule ID 3825 //
        GIM_CheckFeatures, GIFBS_HasDLInsts,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, -1:{ *:[i32] }), i32:{ *:[i32] }:$src1)  =>  (V_XNOR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_XNOR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3825,
        GIR_Done,
      // Label 331: @17658
      GIM_Try, /*On fail goto*//*Label 332*/ 17711, // Rule ID 566 //
        GIM_CheckFeatures, GIFBS_HasDLInsts,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), -1:{ *:[i32] })  =>  (V_XNOR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_XNOR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 566,
        GIR_Done,
      // Label 332: @17711
      GIM_Try, /*On fail goto*//*Label 333*/ 17764, // Rule ID 3826 //
        GIM_CheckFeatures, GIFBS_HasDLInsts,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, -1:{ *:[i32] }))  =>  (V_XNOR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_XNOR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3826,
        GIR_Done,
      // Label 333: @17764
      GIM_Try, /*On fail goto*//*Label 334*/ 17784, // Rule ID 515 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_XOR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 515,
        GIR_Done,
      // Label 334: @17784
      GIM_Reject,
    // Label 315: @17785
    GIM_Reject,
    // Label 311: @17786
    GIM_Try, /*On fail goto*//*Label 335*/ 20180,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 336*/ 17849, // Rule ID 40 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_and_oneuse,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11005,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_and_oneuse>>, -1:{ *:[i64] })<<P:Predicate_anonymous_11005>>  =>  (S_NAND_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_NAND_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 40,
        GIR_Done,
      // Label 336: @17849
      GIM_Try, /*On fail goto*//*Label 337*/ 17906, // Rule ID 42 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_or_oneuse,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11005,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_or_oneuse>>, -1:{ *:[i64] })<<P:Predicate_anonymous_11005>>  =>  (S_NOR_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_NOR_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 42,
        GIR_Done,
      // Label 337: @17906
      GIM_Try, /*On fail goto*//*Label 338*/ 17963, // Rule ID 38 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_xor_oneuse,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11005,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_xor_oneuse>>, -1:{ *:[i64] })<<P:Predicate_anonymous_11005>>  =>  (S_XNOR_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_XNOR_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 38,
        GIR_Done,
      // Label 338: @17963
      GIM_Try, /*On fail goto*//*Label 339*/ 18233, // Rule ID 6533 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[0] z
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19369,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$x), i64:{ *:[i64] }:$z)<<P:Predicate_anonymous_19369>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6533,
        GIR_Done,
      // Label 339: @18233
      GIM_Try, /*On fail goto*//*Label 340*/ 18503, // Rule ID 6534 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[0] z
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19369,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$y), i64:{ *:[i64] }:$x), i64:{ *:[i64] }:$z)<<P:Predicate_anonymous_19369>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6534,
        GIR_Done,
      // Label 340: @18503
      GIM_Try, /*On fail goto*//*Label 341*/ 18773, // Rule ID 6531 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[0] z
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19369,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, (xor:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$z)), i64:{ *:[i64] }:$z)<<P:Predicate_anonymous_19369>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6531,
        GIR_Done,
      // Label 341: @18773
      GIM_Try, /*On fail goto*//*Label 342*/ 19043, // Rule ID 6532 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[0] z
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19369,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, (xor:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$y)), i64:{ *:[i64] }:$z)<<P:Predicate_anonymous_19369>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6532,
        GIR_Done,
      // Label 342: @19043
      GIM_Try, /*On fail goto*//*Label 343*/ 19313, // Rule ID 6530 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] z
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19369,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$z, (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$y), i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_19369>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6530,
        GIR_Done,
      // Label 343: @19313
      GIM_Try, /*On fail goto*//*Label 344*/ 19583, // Rule ID 6529 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        // MIs[2] z
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19369,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$z, (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_19369>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6529,
        GIR_Done,
      // Label 344: @19583
      GIM_Try, /*On fail goto*//*Label 345*/ 19853, // Rule ID 6528 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] z
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19369,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$z, (and:{ *:[i64] } i64:{ *:[i64] }:$x, (xor:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$y)))<<P:Predicate_anonymous_19369>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 6528,
        GIR_Done,
      // Label 345: @19853
      GIM_Try, /*On fail goto*//*Label 346*/ 20123, // Rule ID 3256 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        // MIs[2] z
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19369,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$z, (and:{ *:[i64] } i64:{ *:[i64] }:$x, (xor:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$z)))<<P:Predicate_anonymous_19369>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 3256,
        GIR_Done,
      // Label 346: @20123
      GIM_Try, /*On fail goto*//*Label 347*/ 20156, // Rule ID 1 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11005,
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$src0, -1:{ *:[i64] })<<P:Predicate_anonymous_11005>>  =>  (S_NOT_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_NOT_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1,
        GIR_Done,
      // Label 347: @20156
      GIM_Try, /*On fail goto*//*Label 348*/ 20179, // Rule ID 36 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_11037,
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_11037>>  =>  (S_XOR_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_XOR_B64,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 36,
        GIR_Done,
      // Label 348: @20179
      GIM_Reject,
    // Label 335: @20180
    GIM_Reject,
    // Label 312: @20181
    GIM_Try, /*On fail goto*//*Label 349*/ 20205, // Rule ID 1456 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1)  =>  (V_XOR_B32_e64:{ *:[v2i16] } VSrc_b32:{ *:[v2i16] }:$src0, VSrc_b32:{ *:[v2i16] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_XOR_B32_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1456,
      GIR_Done,
    // Label 349: @20205
    GIM_Reject,
    // Label 313: @20206
    GIM_Reject,
    // Label 6: @20207
    GIM_Try, /*On fail goto*//*Label 350*/ 20258,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_p5s32,
      GIM_Try, /*On fail goto*//*Label 351*/ 20235, // Rule ID 3237 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (frameindex:{ *:[i32] }):$fi  =>  (V_MOV_B32_e32:{ *:[i32] } (frameindex_to_targetframeindex:{ *:[i32] } ?:{ *:[i32] }:$fi))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MOV_B32_e32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/0, /*Renderer*/GICR_renderFrameIndex, // fi
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3237,
        GIR_Done,
      // Label 351: @20235
      GIM_Try, /*On fail goto*//*Label 352*/ 20257, // Rule ID 3238 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        // (frameindex:{ *:[i32] }):$fi  =>  (S_MOV_B32:{ *:[i32] } (frameindex_to_targetframeindex:{ *:[i32] } ?:{ *:[i32] }:$fi))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/0, /*Renderer*/GICR_renderFrameIndex, // fi
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3238,
        GIR_Done,
      // Label 352: @20257
      GIM_Reject,
    // Label 350: @20258
    GIM_Reject,
    // Label 7: @20259
    GIM_Try, /*On fail goto*//*Label 353*/ 21298,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 354*/ 20389, // Rule ID 3383 //
        GIM_CheckFeatures, GIFBS_HasVOP3PInsts,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIPFP_MI_Predicate_srl_oneuse,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 16,
        GIM_CheckCxxInsnPredicate, /*MI*/4, /*FnId*/GIPFP_MI_Predicate_srl_oneuse,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19516,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (build_vector:{ *:[v2i16] } (trunc:{ *:[i16] } (srl:{ *:[i32] } SReg_32:{ *:[i32] }:$src0, 16:{ *:[i32] })<<P:Predicate_srl_oneuse>>), (trunc:{ *:[i16] } (srl:{ *:[i32] } SReg_32:{ *:[i32] }:$src1, 16:{ *:[i32] })<<P:Predicate_srl_oneuse>>))<<P:Predicate_anonymous_19516>>  =>  (S_PACK_HH_B32_B16:{ *:[v2i16] } SReg_32:{ *:[i32] }:$src0, SReg_32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_PACK_HH_B32_B16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3383,
        GIR_Done,
      // Label 354: @20389
      GIM_Try, /*On fail goto*//*Label 355*/ 20540, // Rule ID 3384 //
        GIM_CheckFeatures, GIFBS_HasVOP3PInsts,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIPFP_MI_Predicate_srl_oneuse,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 16,
        GIM_CheckCxxInsnPredicate, /*MI*/4, /*FnId*/GIPFP_MI_Predicate_srl_oneuse,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19518,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (build_vector:{ *:[v2i16] } (trunc:{ *:[i16] } (srl:{ *:[i32] } SReg_32:{ *:[i32] }:$src0, 16:{ *:[i32] })<<P:Predicate_srl_oneuse>>), (trunc:{ *:[i16] } (srl:{ *:[i32] } SReg_32:{ *:[i32] }:$src1, 16:{ *:[i32] })<<P:Predicate_srl_oneuse>>))<<P:Predicate_anonymous_19518>>  =>  (V_AND_OR_B32_e64:{ *:[v2i16] } SReg_32:{ *:[i32] }:$src1, (V_MOV_B32_e32:{ *:[i32] } 4294901760:{ *:[i32] }), (V_LSHRREV_B32_e64:{ *:[i32] } 16:{ *:[i32] }, SReg_32:{ *:[i32] }:$src0))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_LSHRREV_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/2, /*Imm*/16,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_MOV_B32_e32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/4294901760,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_AND_OR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3384,
        GIR_Done,
      // Label 355: @20540
      GIM_Try, /*On fail goto*//*Label 356*/ 20595, // Rule ID 3387 //
        GIM_CheckFeatures, GIFBS_HasVOP3PInsts,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19539,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_vop3mods,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/1, GICP_gi_vop3mods,
        // (build_vector:{ *:[v2f16] } (VOP3Mods:{ *:[f16] } VGPR_32:{ *:[f16] }:$src0, i32:{ *:[i32] }:$src0_mods), (VOP3Mods:{ *:[f16] } VGPR_32:{ *:[f16] }:$src1, i32:{ *:[i32] }:$src1_mods))<<P:Predicate_anonymous_19539>>  =>  (V_PACK_B32_F16_e64:{ *:[v2f16] } ?:{ *:[i32] }:$src0_mods, VGPR_32:{ *:[f16] }:$src0, ?:{ *:[i32] }:$src1_mods, VGPR_32:{ *:[f16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_PACK_B32_F16_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // src0_mods
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/1, /*SubOperand*/1, // src1_mods
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/1, /*SubOperand*/0, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3387,
        GIR_Done,
      // Label 356: @20595
      GIM_Try, /*On fail goto*//*Label 357*/ 20671, // Rule ID 3381 //
        GIM_CheckFeatures, GIFBS_HasVOP3PInsts,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIPFP_MI_Predicate_srl_oneuse,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19516,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (build_vector:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src0, (trunc:{ *:[i16] } (srl:{ *:[i32] } SReg_32:{ *:[i32] }:$src1, 16:{ *:[i32] })<<P:Predicate_srl_oneuse>>))<<P:Predicate_anonymous_19516>>  =>  (S_PACK_LH_B32_B16:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src0, SReg_32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_PACK_LH_B32_B16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3381,
        GIR_Done,
      // Label 357: @20671
      GIM_Try, /*On fail goto*//*Label 358*/ 20766, // Rule ID 3382 //
        GIM_CheckFeatures, GIFBS_HasVOP3PInsts,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIPFP_MI_Predicate_srl_oneuse,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19518,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (build_vector:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src0, (trunc:{ *:[i16] } (srl:{ *:[i32] } SReg_32:{ *:[i32] }:$src1, 16:{ *:[i32] })<<P:Predicate_srl_oneuse>>))<<P:Predicate_anonymous_19518>>  =>  (V_BFI_B32_e64:{ *:[v2i16] } (V_MOV_B32_e32:{ *:[i32] } 65535:{ *:[i32] }), SReg_32:{ *:[i16] }:$src0, SReg_32:{ *:[i32] }:$src1)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_MOV_B32_e32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/65535,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3382,
        GIR_Done,
      // Label 358: @20766
      GIM_Try, /*On fail goto*//*Label 359*/ 20802, // Rule ID 3366 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19516,
        // (build_vector:{ *:[v2i16] } 0:{ *:[i16] }, SReg_32:{ *:[i16] }:$src1)<<P:Predicate_anonymous_19516>>  =>  (S_LSHL_B32:{ *:[v2i16] }:{ *:[i1] } SReg_32:{ *:[i16] }:$src1, 16:{ *:[i16] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/16,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3366,
        GIR_Done,
      // Label 359: @20802
      GIM_Try, /*On fail goto*//*Label 360*/ 20838, // Rule ID 3367 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19518,
        // (build_vector:{ *:[v2i16] } 0:{ *:[i16] }, SReg_32:{ *:[i16] }:$src1)<<P:Predicate_anonymous_19518>>  =>  (V_LSHLREV_B32_e64:{ *:[v2i16] } 16:{ *:[i16] }, SReg_32:{ *:[i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHLREV_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddImm, /*InsnID*/0, /*Imm*/16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3367,
        GIR_Done,
      // Label 360: @20838
      GIM_Try, /*On fail goto*//*Label 361*/ 20890, // Rule ID 3368 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 0,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19516,
        // (build_vector:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src1, 0:{ *:[i16] })<<P:Predicate_anonymous_19516>>  =>  (S_AND_B32:{ *:[v2i16] }:{ *:[i1] } (S_MOV_B32:{ *:[i1] } 65535:{ *:[i32] }), SReg_32:{ *:[i16] }:$src1)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/65535,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_AND_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3368,
        GIR_Done,
      // Label 361: @20890
      GIM_Try, /*On fail goto*//*Label 362*/ 20942, // Rule ID 3369 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 0,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19518,
        // (build_vector:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src1, 0:{ *:[i16] })<<P:Predicate_anonymous_19518>>  =>  (V_AND_B32_e64:{ *:[v2i16] } (V_MOV_B32_e32:{ *:[i32] } 65535:{ *:[i32] }), SReg_32:{ *:[i16] }:$src1)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_MOV_B32_e32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/65535,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_AND_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3369,
        GIR_Done,
      // Label 362: @20942
      GIM_Try, /*On fail goto*//*Label 363*/ 20983, // Rule ID 3375 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19516,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (build_vector:{ *:[v2i16] } (undef:{ *:[i16] }), SReg_32:{ *:[i16] }:$src1)<<P:Predicate_anonymous_19516>>  =>  (S_LSHL_B32:{ *:[v2i16] }:{ *:[i1] } SReg_32:{ *:[i16] }:$src1, 16:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/16,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3375,
        GIR_Done,
      // Label 363: @20983
      GIM_Try, /*On fail goto*//*Label 364*/ 21024, // Rule ID 3376 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19518,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (build_vector:{ *:[v2i16] } (undef:{ *:[i16] }), SReg_32:{ *:[i16] }:$src1)<<P:Predicate_anonymous_19518>>  =>  (V_LSHLREV_B32_e64:{ *:[v2i16] } 16:{ *:[i32] }, SReg_32:{ *:[i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHLREV_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddImm, /*InsnID*/0, /*Imm*/16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3376,
        GIR_Done,
      // Label 364: @21024
      GIM_Try, /*On fail goto*//*Label 365*/ 21065, // Rule ID 3377 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19516,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (build_vector:{ *:[v2f16] } (undef:{ *:[f16] }), SReg_32:{ *:[f16] }:$src1)<<P:Predicate_anonymous_19516>>  =>  (S_LSHL_B32:{ *:[v2f16] }:{ *:[i1] } SReg_32:{ *:[f16] }:$src1, 16:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/16,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3377,
        GIR_Done,
      // Label 365: @21065
      GIM_Try, /*On fail goto*//*Label 366*/ 21106, // Rule ID 3378 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19518,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (build_vector:{ *:[v2f16] } (undef:{ *:[f16] }), SReg_32:{ *:[f16] }:$src1)<<P:Predicate_anonymous_19518>>  =>  (V_LSHLREV_B32_e64:{ *:[v2f16] } 16:{ *:[i32] }, SReg_32:{ *:[f16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHLREV_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddImm, /*InsnID*/0, /*Imm*/16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3378,
        GIR_Done,
      // Label 366: @21106
      GIM_Try, /*On fail goto*//*Label 367*/ 21143, // Rule ID 3372 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (build_vector:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src0, (undef:{ *:[i16] }))  =>  (COPY_TO_REGCLASS:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src0, SReg_32:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
        // GIR_Coverage, 3372,
        GIR_Done,
      // Label 367: @21143
      GIM_Try, /*On fail goto*//*Label 368*/ 21180, // Rule ID 3373 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (build_vector:{ *:[v2i16] } VGPR_32:{ *:[i16] }:$src0, (undef:{ *:[i16] }))  =>  (COPY_TO_REGCLASS:{ *:[v2i16] } VGPR_32:{ *:[i16] }:$src0, VGPR_32:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 3373,
        GIR_Done,
      // Label 368: @21180
      GIM_Try, /*On fail goto*//*Label 369*/ 21220,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19516,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_Try, /*On fail goto*//*Label 370*/ 21208, // Rule ID 3379 //
          GIM_CheckFeatures, GIFBS_HasVOP3PInsts,
          // (build_vector:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src0, SReg_32:{ *:[i16] }:$src1)<<P:Predicate_anonymous_19516>>  =>  (S_PACK_LL_B32_B16:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src0, SReg_32:{ *:[i16] }:$src1)
          GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_PACK_LL_B32_B16,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3379,
          GIR_Done,
        // Label 370: @21208
        GIM_Try, /*On fail goto*//*Label 371*/ 21219, // Rule ID 3385 //
          GIM_CheckFeatures, GIFBS_HasVOP3PInsts,
          // (build_vector:{ *:[v2f16] } SReg_32:{ *:[f16] }:$src0, SReg_32:{ *:[f16] }:$src1)<<P:Predicate_anonymous_19516>>  =>  (S_PACK_LL_B32_B16:{ *:[v2f16] } SReg_32:{ *:[f16] }:$src0, SReg_32:{ *:[f16] }:$src1)
          GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_PACK_LL_B32_B16,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 3385,
          GIR_Done,
        // Label 371: @21219
        GIM_Reject,
      // Label 369: @21220
      GIM_Try, /*On fail goto*//*Label 372*/ 21297, // Rule ID 3386 //
        GIM_CheckFeatures, GIFBS_HasVOP3PInsts,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_19518,
        // (build_vector:{ *:[v2f16] } SReg_32:{ *:[f16] }:$src0, SReg_32:{ *:[f16] }:$src1)<<P:Predicate_anonymous_19518>>  =>  (V_LSHL_OR_B32_e64:{ *:[v2f16] } SReg_32:{ *:[f16] }:$src1, 16:{ *:[i32] }, (V_AND_B32_e64:{ *:[i32] } (V_MOV_B32_e32:{ *:[i32] } 65535:{ *:[i32] }), SReg_32:{ *:[f16] }:$src0))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_MOV_B32_e32,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/2, /*Imm*/65535,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_AND_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHL_OR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/16,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3386,
        GIR_Done,
      // Label 372: @21297
      GIM_Reject,
    // Label 353: @21298
    GIM_Reject,
    // Label 8: @21299
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 28, /*)*//*default:*//*Label 393*/ 25885,
    /*GILLT_s16*//*Label 373*/ 21325,
    /*GILLT_s32*//*Label 374*/ 21445,
    /*GILLT_s64*//*Label 375*/ 21702,
    /*GILLT_v2s16*//*Label 376*/ 22023,
    /*GILLT_v2s32*//*Label 377*/ 22216,
    /*GILLT_v2s64*//*Label 378*/ 22569,
    /*GILLT_v3s32*//*Label 379*/ 22890,
    /*GILLT_v3s64*//*Label 380*/ 22946,
    /*GILLT_v4s16*//*Label 381*/ 23139,
    /*GILLT_v4s32*//*Label 382*/ 23460,
    /*GILLT_v4s64*//*Label 383*/ 23781,
    /*GILLT_v5s32*//*Label 384*/ 23974,
    /*GILLT_v6s32*//*Label 385*/ 24094,
    /*GILLT_v7s32*//*Label 386*/ 24351,
    /*GILLT_v8s16*//*Label 387*/ 24471,
    /*GILLT_v8s32*//*Label 388*/ 24856,
    /*GILLT_v8s64*//*Label 389*/ 25113,
    /*GILLT_v16s32*//*Label 390*/ 25306,
    /*GILLT_v16s64*//*Label 391*/ 25499,
    /*GILLT_v32s32*//*Label 392*/ 25692,
    // Label 373: @21325
    GIM_Try, /*On fail goto*//*Label 394*/ 21444,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 395*/ 21359, // Rule ID 3048 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (bitconvert:{ *:[i16] } VGPR_32:{ *:[f16] }:$src0)  =>  VGPR_32:{ *:[i16] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 3048,
        GIR_Done,
      // Label 395: @21359
      GIM_Try, /*On fail goto*//*Label 396*/ 21387, // Rule ID 3049 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (bitconvert:{ *:[f16] } VGPR_32:{ *:[i16] }:$src0)  =>  VGPR_32:{ *:[f16] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 3049,
        GIR_Done,
      // Label 396: @21387
      GIM_Try, /*On fail goto*//*Label 397*/ 21415, // Rule ID 3050 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        // (bitconvert:{ *:[i16] } SReg_32:{ *:[f16] }:$src0)  =>  SReg_32:{ *:[i16] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
        // GIR_Coverage, 3050,
        GIR_Done,
      // Label 397: @21415
      GIM_Try, /*On fail goto*//*Label 398*/ 21443, // Rule ID 3051 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        // (bitconvert:{ *:[f16] } SReg_32:{ *:[i16] }:$src0)  =>  SReg_32:{ *:[f16] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
        // GIR_Coverage, 3051,
        GIR_Done,
      // Label 398: @21443
      GIM_Reject,
    // Label 394: @21444
    GIM_Reject,
    // Label 374: @21445
    GIM_Try, /*On fail goto*//*Label 399*/ 21477, // Rule ID 3052 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (bitconvert:{ *:[i32] } VGPR_32:{ *:[f32] }:$src0)  =>  VGPR_32:{ *:[i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VGPR_32RegClassID,
      // GIR_Coverage, 3052,
      GIR_Done,
    // Label 399: @21477
    GIM_Try, /*On fail goto*//*Label 400*/ 21509, // Rule ID 3053 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (bitconvert:{ *:[f32] } VGPR_32:{ *:[i32] }:$src0)  =>  VGPR_32:{ *:[f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VGPR_32RegClassID,
      // GIR_Coverage, 3053,
      GIR_Done,
    // Label 400: @21509
    GIM_Try, /*On fail goto*//*Label 401*/ 21541, // Rule ID 3054 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[i32] } SReg_32:{ *:[f32] }:$src0)  =>  SReg_32:{ *:[i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3054,
      GIR_Done,
    // Label 401: @21541
    GIM_Try, /*On fail goto*//*Label 402*/ 21573, // Rule ID 3055 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[f32] } SReg_32:{ *:[i32] }:$src0)  =>  SReg_32:{ *:[f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3055,
      GIR_Done,
    // Label 402: @21573
    GIM_Try, /*On fail goto*//*Label 403*/ 21605, // Rule ID 3057 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[i32] } SReg_32:{ *:[v2i16] }:$src0)  =>  SReg_32:{ *:[i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3057,
      GIR_Done,
    // Label 403: @21605
    GIM_Try, /*On fail goto*//*Label 404*/ 21637, // Rule ID 3059 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[i32] } SReg_32:{ *:[v2f16] }:$src0)  =>  SReg_32:{ *:[i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3059,
      GIR_Done,
    // Label 404: @21637
    GIM_Try, /*On fail goto*//*Label 405*/ 21669, // Rule ID 3063 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[f32] } SReg_32:{ *:[v2f16] }:$src0)  =>  SReg_32:{ *:[f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3063,
      GIR_Done,
    // Label 405: @21669
    GIM_Try, /*On fail goto*//*Label 406*/ 21701, // Rule ID 3065 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[f32] } SReg_32:{ *:[v2i16] }:$src0)  =>  SReg_32:{ *:[f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3065,
      GIR_Done,
    // Label 406: @21701
    GIM_Reject,
    // Label 375: @21702
    GIM_Try, /*On fail goto*//*Label 407*/ 21734, // Rule ID 3066 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3066,
      GIR_Done,
    // Label 407: @21734
    GIM_Try, /*On fail goto*//*Label 408*/ 21766, // Rule ID 3067 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3067,
      GIR_Done,
    // Label 408: @21766
    GIM_Try, /*On fail goto*//*Label 409*/ 21798, // Rule ID 3070 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3070,
      GIR_Done,
    // Label 409: @21798
    GIM_Try, /*On fail goto*//*Label 410*/ 21830, // Rule ID 3072 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3072,
      GIR_Done,
    // Label 410: @21830
    GIM_Try, /*On fail goto*//*Label 411*/ 21862, // Rule ID 3074 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3074,
      GIR_Done,
    // Label 411: @21862
    GIM_Try, /*On fail goto*//*Label 412*/ 21894, // Rule ID 3076 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3076,
      GIR_Done,
    // Label 412: @21894
    GIM_Try, /*On fail goto*//*Label 413*/ 21926, // Rule ID 3091 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3091,
      GIR_Done,
    // Label 413: @21926
    GIM_Try, /*On fail goto*//*Label 414*/ 21958, // Rule ID 3092 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3092,
      GIR_Done,
    // Label 414: @21958
    GIM_Try, /*On fail goto*//*Label 415*/ 21990, // Rule ID 3095 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3095,
      GIR_Done,
    // Label 415: @21990
    GIM_Try, /*On fail goto*//*Label 416*/ 22022, // Rule ID 3096 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3096,
      GIR_Done,
    // Label 416: @22022
    GIM_Reject,
    // Label 376: @22023
    GIM_Try, /*On fail goto*//*Label 417*/ 22055, // Rule ID 3056 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2i16] } SReg_32:{ *:[i32] }:$src0)  =>  SReg_32:{ *:[v2i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3056,
      GIR_Done,
    // Label 417: @22055
    GIM_Try, /*On fail goto*//*Label 418*/ 22087, // Rule ID 3058 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2f16] } SReg_32:{ *:[i32] }:$src0)  =>  SReg_32:{ *:[v2f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3058,
      GIR_Done,
    // Label 418: @22087
    GIM_Try, /*On fail goto*//*Label 419*/ 22119, // Rule ID 3060 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2i16] } SReg_32:{ *:[v2f16] }:$src0)  =>  SReg_32:{ *:[v2i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3060,
      GIR_Done,
    // Label 419: @22119
    GIM_Try, /*On fail goto*//*Label 420*/ 22151, // Rule ID 3061 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2f16] } SReg_32:{ *:[v2i16] }:$src0)  =>  SReg_32:{ *:[v2f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3061,
      GIR_Done,
    // Label 420: @22151
    GIM_Try, /*On fail goto*//*Label 421*/ 22183, // Rule ID 3062 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2f16] } SReg_32:{ *:[f32] }:$src0)  =>  SReg_32:{ *:[v2f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3062,
      GIR_Done,
    // Label 421: @22183
    GIM_Try, /*On fail goto*//*Label 422*/ 22215, // Rule ID 3064 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2i16] } SReg_32:{ *:[f32] }:$src0)  =>  SReg_32:{ *:[v2i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3064,
      GIR_Done,
    // Label 422: @22215
    GIM_Reject,
    // Label 377: @22216
    GIM_Try, /*On fail goto*//*Label 423*/ 22248, // Rule ID 3068 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3068,
      GIR_Done,
    // Label 423: @22248
    GIM_Try, /*On fail goto*//*Label 424*/ 22280, // Rule ID 3069 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3069,
      GIR_Done,
    // Label 424: @22280
    GIM_Try, /*On fail goto*//*Label 425*/ 22312, // Rule ID 3071 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3071,
      GIR_Done,
    // Label 425: @22312
    GIM_Try, /*On fail goto*//*Label 426*/ 22344, // Rule ID 3073 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3073,
      GIR_Done,
    // Label 426: @22344
    GIM_Try, /*On fail goto*//*Label 427*/ 22376, // Rule ID 3075 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3075,
      GIR_Done,
    // Label 427: @22376
    GIM_Try, /*On fail goto*//*Label 428*/ 22408, // Rule ID 3077 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3077,
      GIR_Done,
    // Label 428: @22408
    GIM_Try, /*On fail goto*//*Label 429*/ 22440, // Rule ID 3080 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3080,
      GIR_Done,
    // Label 429: @22440
    GIM_Try, /*On fail goto*//*Label 430*/ 22472, // Rule ID 3082 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3082,
      GIR_Done,
    // Label 430: @22472
    GIM_Try, /*On fail goto*//*Label 431*/ 22504, // Rule ID 3083 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3083,
      GIR_Done,
    // Label 431: @22504
    GIM_Try, /*On fail goto*//*Label 432*/ 22536, // Rule ID 3085 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3085,
      GIR_Done,
    // Label 432: @22536
    GIM_Try, /*On fail goto*//*Label 433*/ 22568, // Rule ID 3087 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3087,
      GIR_Done,
    // Label 433: @22568
    GIM_Reject,
    // Label 378: @22569
    GIM_Try, /*On fail goto*//*Label 434*/ 22601, // Rule ID 3101 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v2i64] } SReg_128:{ *:[v4i32] }:$src0)  =>  SReg_128:{ *:[v2i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3101,
      GIR_Done,
    // Label 434: @22601
    GIM_Try, /*On fail goto*//*Label 435*/ 22633, // Rule ID 3103 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v2f64] } VReg_128:{ *:[v4f32] }:$src0)  =>  VReg_128:{ *:[v2f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3103,
      GIR_Done,
    // Label 435: @22633
    GIM_Try, /*On fail goto*//*Label 436*/ 22665, // Rule ID 3104 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v2f64] } VReg_128:{ *:[v4i32] }:$src0)  =>  VReg_128:{ *:[v2f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3104,
      GIR_Done,
    // Label 436: @22665
    GIM_Try, /*On fail goto*//*Label 437*/ 22697, // Rule ID 3107 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v2i64] } VReg_128:{ *:[v2f64] }:$src0)  =>  VReg_128:{ *:[v2i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3107,
      GIR_Done,
    // Label 437: @22697
    GIM_Try, /*On fail goto*//*Label 438*/ 22729, // Rule ID 3108 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v2f64] } VReg_128:{ *:[v2i64] }:$src0)  =>  VReg_128:{ *:[v2f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3108,
      GIR_Done,
    // Label 438: @22729
    GIM_Try, /*On fail goto*//*Label 439*/ 22761, // Rule ID 3110 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v2i64] } VReg_128:{ *:[v4f32] }:$src0)  =>  VReg_128:{ *:[v2i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3110,
      GIR_Done,
    // Label 439: @22761
    GIM_Try, /*On fail goto*//*Label 440*/ 22793, // Rule ID 3127 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v2i64] } SReg_128:{ *:[v8i16] }:$src0)  =>  SReg_128:{ *:[v2i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3127,
      GIR_Done,
    // Label 440: @22793
    GIM_Try, /*On fail goto*//*Label 441*/ 22825, // Rule ID 3128 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v2f64] } SReg_128:{ *:[v8i16] }:$src0)  =>  SReg_128:{ *:[v2f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3128,
      GIR_Done,
    // Label 441: @22825
    GIM_Try, /*On fail goto*//*Label 442*/ 22857, // Rule ID 3129 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v2i64] } SReg_128:{ *:[v8f16] }:$src0)  =>  SReg_128:{ *:[v2i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3129,
      GIR_Done,
    // Label 442: @22857
    GIM_Try, /*On fail goto*//*Label 443*/ 22889, // Rule ID 3130 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v2f64] } SReg_128:{ *:[v8f16] }:$src0)  =>  SReg_128:{ *:[v2f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3130,
      GIR_Done,
    // Label 443: @22889
    GIM_Reject,
    // Label 379: @22890
    GIM_Try, /*On fail goto*//*Label 444*/ 22945,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v3s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SGPR_96RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SGPR_96RegClassID,
      GIM_Try, /*On fail goto*//*Label 445*/ 22924, // Rule ID 3099 //
        // (bitconvert:{ *:[v3i32] } SGPR_96:{ *:[v3f32] }:$src0)  =>  SGPR_96:{ *:[v3i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SGPR_96RegClassID,
        // GIR_Coverage, 3099,
        GIR_Done,
      // Label 445: @22924
      GIM_Try, /*On fail goto*//*Label 446*/ 22944, // Rule ID 3100 //
        // (bitconvert:{ *:[v3f32] } SGPR_96:{ *:[v3i32] }:$src0)  =>  SGPR_96:{ *:[v3f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SGPR_96RegClassID,
        // GIR_Coverage, 3100,
        GIR_Done,
      // Label 446: @22944
      GIM_Reject,
    // Label 444: @22945
    GIM_Reject,
    // Label 380: @22946
    GIM_Try, /*On fail goto*//*Label 447*/ 22978, // Rule ID 3139 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v3s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v3i64] } VReg_192:{ *:[v3f64] }:$src0)  =>  VReg_192:{ *:[v3i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3139,
      GIR_Done,
    // Label 447: @22978
    GIM_Try, /*On fail goto*//*Label 448*/ 23010, // Rule ID 3140 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v3s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v3f64] } VReg_192:{ *:[v3i64] }:$src0)  =>  VReg_192:{ *:[v3f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3140,
      GIR_Done,
    // Label 448: @23010
    GIM_Try, /*On fail goto*//*Label 449*/ 23042, // Rule ID 3141 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v3i64] } VReg_192:{ *:[v6i32] }:$src0)  =>  VReg_192:{ *:[v3i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3141,
      GIR_Done,
    // Label 449: @23042
    GIM_Try, /*On fail goto*//*Label 450*/ 23074, // Rule ID 3142 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v3i64] } VReg_192:{ *:[v6f32] }:$src0)  =>  VReg_192:{ *:[v3i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3142,
      GIR_Done,
    // Label 450: @23074
    GIM_Try, /*On fail goto*//*Label 451*/ 23106, // Rule ID 3143 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v3f64] } VReg_192:{ *:[v6i32] }:$src0)  =>  VReg_192:{ *:[v3f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3143,
      GIR_Done,
    // Label 451: @23106
    GIM_Try, /*On fail goto*//*Label 452*/ 23138, // Rule ID 3144 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v3f64] } VReg_192:{ *:[v6f32] }:$src0)  =>  VReg_192:{ *:[v3f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3144,
      GIR_Done,
    // Label 452: @23138
    GIM_Reject,
    // Label 381: @23139
    GIM_Try, /*On fail goto*//*Label 453*/ 23171, // Rule ID 3078 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3078,
      GIR_Done,
    // Label 453: @23171
    GIM_Try, /*On fail goto*//*Label 454*/ 23203, // Rule ID 3079 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3079,
      GIR_Done,
    // Label 454: @23203
    GIM_Try, /*On fail goto*//*Label 455*/ 23235, // Rule ID 3081 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3081,
      GIR_Done,
    // Label 455: @23235
    GIM_Try, /*On fail goto*//*Label 456*/ 23267, // Rule ID 3084 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3084,
      GIR_Done,
    // Label 456: @23267
    GIM_Try, /*On fail goto*//*Label 457*/ 23299, // Rule ID 3086 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3086,
      GIR_Done,
    // Label 457: @23299
    GIM_Try, /*On fail goto*//*Label 458*/ 23331, // Rule ID 3088 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3088,
      GIR_Done,
    // Label 458: @23331
    GIM_Try, /*On fail goto*//*Label 459*/ 23363, // Rule ID 3089 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3089,
      GIR_Done,
    // Label 459: @23363
    GIM_Try, /*On fail goto*//*Label 460*/ 23395, // Rule ID 3090 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3090,
      GIR_Done,
    // Label 460: @23395
    GIM_Try, /*On fail goto*//*Label 461*/ 23427, // Rule ID 3093 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3093,
      GIR_Done,
    // Label 461: @23427
    GIM_Try, /*On fail goto*//*Label 462*/ 23459, // Rule ID 3094 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3094,
      GIR_Done,
    // Label 462: @23459
    GIM_Reject,
    // Label 382: @23460
    GIM_Try, /*On fail goto*//*Label 463*/ 23492, // Rule ID 3097 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4i32] } VReg_128:{ *:[v4f32] }:$src0)  =>  VReg_128:{ *:[v4i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3097,
      GIR_Done,
    // Label 463: @23492
    GIM_Try, /*On fail goto*//*Label 464*/ 23524, // Rule ID 3098 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4f32] } VReg_128:{ *:[v4i32] }:$src0)  =>  VReg_128:{ *:[v4f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3098,
      GIR_Done,
    // Label 464: @23524
    GIM_Try, /*On fail goto*//*Label 465*/ 23556, // Rule ID 3102 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v4i32] } SReg_128:{ *:[v2i64] }:$src0)  =>  SReg_128:{ *:[v4i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3102,
      GIR_Done,
    // Label 465: @23556
    GIM_Try, /*On fail goto*//*Label 466*/ 23588, // Rule ID 3105 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4f32] } VReg_128:{ *:[v2f64] }:$src0)  =>  VReg_128:{ *:[v4f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3105,
      GIR_Done,
    // Label 466: @23588
    GIM_Try, /*On fail goto*//*Label 467*/ 23620, // Rule ID 3106 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4i32] } VReg_128:{ *:[v2f64] }:$src0)  =>  VReg_128:{ *:[v4i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3106,
      GIR_Done,
    // Label 467: @23620
    GIM_Try, /*On fail goto*//*Label 468*/ 23652, // Rule ID 3109 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4f32] } VReg_128:{ *:[v2i64] }:$src0)  =>  VReg_128:{ *:[v4f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3109,
      GIR_Done,
    // Label 468: @23652
    GIM_Try, /*On fail goto*//*Label 469*/ 23684, // Rule ID 3112 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v4i32] } SReg_128:{ *:[v8i16] }:$src0)  =>  SReg_128:{ *:[v4i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3112,
      GIR_Done,
    // Label 469: @23684
    GIM_Try, /*On fail goto*//*Label 470*/ 23716, // Rule ID 3115 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4f32] } VReg_128:{ *:[v8f16] }:$src0)  =>  VReg_128:{ *:[v4f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3115,
      GIR_Done,
    // Label 470: @23716
    GIM_Try, /*On fail goto*//*Label 471*/ 23748, // Rule ID 3116 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4i32] } VReg_128:{ *:[v8f16] }:$src0)  =>  VReg_128:{ *:[v4i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3116,
      GIR_Done,
    // Label 471: @23748
    GIM_Try, /*On fail goto*//*Label 472*/ 23780, // Rule ID 3119 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4f32] } VReg_128:{ *:[v8i16] }:$src0)  =>  VReg_128:{ *:[v4f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3119,
      GIR_Done,
    // Label 472: @23780
    GIM_Reject,
    // Label 383: @23781
    GIM_Try, /*On fail goto*//*Label 473*/ 23813, // Rule ID 3157 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v4i64] } VReg_256:{ *:[v4f64] }:$src0)  =>  VReg_256:{ *:[v4i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3157,
      GIR_Done,
    // Label 473: @23813
    GIM_Try, /*On fail goto*//*Label 474*/ 23845, // Rule ID 3158 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v4f64] } VReg_256:{ *:[v4i64] }:$src0)  =>  VReg_256:{ *:[v4f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3158,
      GIR_Done,
    // Label 474: @23845
    GIM_Try, /*On fail goto*//*Label 475*/ 23877, // Rule ID 3159 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v4i64] } VReg_256:{ *:[v8i32] }:$src0)  =>  VReg_256:{ *:[v4i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3159,
      GIR_Done,
    // Label 475: @23877
    GIM_Try, /*On fail goto*//*Label 476*/ 23909, // Rule ID 3160 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v4i64] } VReg_256:{ *:[v8f32] }:$src0)  =>  VReg_256:{ *:[v4i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3160,
      GIR_Done,
    // Label 476: @23909
    GIM_Try, /*On fail goto*//*Label 477*/ 23941, // Rule ID 3161 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v4f64] } VReg_256:{ *:[v8i32] }:$src0)  =>  VReg_256:{ *:[v4f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3161,
      GIR_Done,
    // Label 477: @23941
    GIM_Try, /*On fail goto*//*Label 478*/ 23973, // Rule ID 3162 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v4f64] } VReg_256:{ *:[v8f32] }:$src0)  =>  VReg_256:{ *:[v4f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3162,
      GIR_Done,
    // Label 478: @23973
    GIM_Reject,
    // Label 384: @23974
    GIM_Try, /*On fail goto*//*Label 479*/ 24093,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v5s32,
      GIM_Try, /*On fail goto*//*Label 480*/ 24008, // Rule ID 3131 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_160RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_160RegClassID,
        // (bitconvert:{ *:[v5i32] } SReg_160:{ *:[v5f32] }:$src0)  =>  SReg_160:{ *:[v5i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_160RegClassID,
        // GIR_Coverage, 3131,
        GIR_Done,
      // Label 480: @24008
      GIM_Try, /*On fail goto*//*Label 481*/ 24036, // Rule ID 3132 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_160RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_160RegClassID,
        // (bitconvert:{ *:[v5f32] } SReg_160:{ *:[v5i32] }:$src0)  =>  SReg_160:{ *:[v5f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_160RegClassID,
        // GIR_Coverage, 3132,
        GIR_Done,
      // Label 481: @24036
      GIM_Try, /*On fail goto*//*Label 482*/ 24064, // Rule ID 3133 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_160RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_160RegClassID,
        // (bitconvert:{ *:[v5i32] } VReg_160:{ *:[v5f32] }:$src0)  =>  VReg_160:{ *:[v5i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_160RegClassID,
        // GIR_Coverage, 3133,
        GIR_Done,
      // Label 482: @24064
      GIM_Try, /*On fail goto*//*Label 483*/ 24092, // Rule ID 3134 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_160RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_160RegClassID,
        // (bitconvert:{ *:[v5f32] } VReg_160:{ *:[v5i32] }:$src0)  =>  VReg_160:{ *:[v5f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_160RegClassID,
        // GIR_Coverage, 3134,
        GIR_Done,
      // Label 483: @24092
      GIM_Reject,
    // Label 479: @24093
    GIM_Reject,
    // Label 385: @24094
    GIM_Try, /*On fail goto*//*Label 484*/ 24126, // Rule ID 3135 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_192RegClassID,
      // (bitconvert:{ *:[v6i32] } SReg_192:{ *:[v6f32] }:$src0)  =>  SReg_192:{ *:[v6i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_192RegClassID,
      // GIR_Coverage, 3135,
      GIR_Done,
    // Label 484: @24126
    GIM_Try, /*On fail goto*//*Label 485*/ 24158, // Rule ID 3136 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_192RegClassID,
      // (bitconvert:{ *:[v6f32] } SReg_192:{ *:[v6i32] }:$src0)  =>  SReg_192:{ *:[v6f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_192RegClassID,
      // GIR_Coverage, 3136,
      GIR_Done,
    // Label 485: @24158
    GIM_Try, /*On fail goto*//*Label 486*/ 24190, // Rule ID 3137 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v6i32] } VReg_192:{ *:[v6f32] }:$src0)  =>  VReg_192:{ *:[v6i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3137,
      GIR_Done,
    // Label 486: @24190
    GIM_Try, /*On fail goto*//*Label 487*/ 24222, // Rule ID 3138 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v6f32] } VReg_192:{ *:[v6i32] }:$src0)  =>  VReg_192:{ *:[v6f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3138,
      GIR_Done,
    // Label 487: @24222
    GIM_Try, /*On fail goto*//*Label 488*/ 24254, // Rule ID 3145 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v3s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v6i32] } VReg_192:{ *:[v3i64] }:$src0)  =>  VReg_192:{ *:[v6i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3145,
      GIR_Done,
    // Label 488: @24254
    GIM_Try, /*On fail goto*//*Label 489*/ 24286, // Rule ID 3146 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v3s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v6f32] } VReg_192:{ *:[v3i64] }:$src0)  =>  VReg_192:{ *:[v6f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3146,
      GIR_Done,
    // Label 489: @24286
    GIM_Try, /*On fail goto*//*Label 490*/ 24318, // Rule ID 3147 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v3s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v6i32] } VReg_192:{ *:[v3f64] }:$src0)  =>  VReg_192:{ *:[v6i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3147,
      GIR_Done,
    // Label 490: @24318
    GIM_Try, /*On fail goto*//*Label 491*/ 24350, // Rule ID 3148 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v3s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v6f32] } VReg_192:{ *:[v3f64] }:$src0)  =>  VReg_192:{ *:[v6f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3148,
      GIR_Done,
    // Label 491: @24350
    GIM_Reject,
    // Label 386: @24351
    GIM_Try, /*On fail goto*//*Label 492*/ 24470,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v7s32,
      GIM_Try, /*On fail goto*//*Label 493*/ 24385, // Rule ID 3149 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_224RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_224RegClassID,
        // (bitconvert:{ *:[v7i32] } SReg_224:{ *:[v7f32] }:$src0)  =>  SReg_224:{ *:[v7i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_224RegClassID,
        // GIR_Coverage, 3149,
        GIR_Done,
      // Label 493: @24385
      GIM_Try, /*On fail goto*//*Label 494*/ 24413, // Rule ID 3150 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_224RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_224RegClassID,
        // (bitconvert:{ *:[v7f32] } SReg_224:{ *:[v7i32] }:$src0)  =>  SReg_224:{ *:[v7f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_224RegClassID,
        // GIR_Coverage, 3150,
        GIR_Done,
      // Label 494: @24413
      GIM_Try, /*On fail goto*//*Label 495*/ 24441, // Rule ID 3151 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_224RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_224RegClassID,
        // (bitconvert:{ *:[v7i32] } VReg_224:{ *:[v7f32] }:$src0)  =>  VReg_224:{ *:[v7i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_224RegClassID,
        // GIR_Coverage, 3151,
        GIR_Done,
      // Label 495: @24441
      GIM_Try, /*On fail goto*//*Label 496*/ 24469, // Rule ID 3152 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_224RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_224RegClassID,
        // (bitconvert:{ *:[v7f32] } VReg_224:{ *:[v7i32] }:$src0)  =>  VReg_224:{ *:[v7f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_224RegClassID,
        // GIR_Coverage, 3152,
        GIR_Done,
      // Label 496: @24469
      GIM_Reject,
    // Label 492: @24470
    GIM_Reject,
    // Label 387: @24471
    GIM_Try, /*On fail goto*//*Label 497*/ 24503, // Rule ID 3111 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v8i16] } SReg_128:{ *:[v4i32] }:$src0)  =>  SReg_128:{ *:[v8i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3111,
      GIR_Done,
    // Label 497: @24503
    GIM_Try, /*On fail goto*//*Label 498*/ 24535, // Rule ID 3113 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v8f16] } VReg_128:{ *:[v4f32] }:$src0)  =>  VReg_128:{ *:[v8f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3113,
      GIR_Done,
    // Label 498: @24535
    GIM_Try, /*On fail goto*//*Label 499*/ 24567, // Rule ID 3114 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v8f16] } VReg_128:{ *:[v4i32] }:$src0)  =>  VReg_128:{ *:[v8f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3114,
      GIR_Done,
    // Label 499: @24567
    GIM_Try, /*On fail goto*//*Label 500*/ 24599, // Rule ID 3117 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v8i16] } VReg_128:{ *:[v8f16] }:$src0)  =>  VReg_128:{ *:[v8i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3117,
      GIR_Done,
    // Label 500: @24599
    GIM_Try, /*On fail goto*//*Label 501*/ 24631, // Rule ID 3118 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v8f16] } VReg_128:{ *:[v8i16] }:$src0)  =>  VReg_128:{ *:[v8f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3118,
      GIR_Done,
    // Label 501: @24631
    GIM_Try, /*On fail goto*//*Label 502*/ 24663, // Rule ID 3120 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v8i16] } VReg_128:{ *:[v4f32] }:$src0)  =>  VReg_128:{ *:[v8i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3120,
      GIR_Done,
    // Label 502: @24663
    GIM_Try, /*On fail goto*//*Label 503*/ 24695, // Rule ID 3121 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v8i16] } SReg_128:{ *:[v8f16] }:$src0)  =>  SReg_128:{ *:[v8i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3121,
      GIR_Done,
    // Label 503: @24695
    GIM_Try, /*On fail goto*//*Label 504*/ 24727, // Rule ID 3122 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v8i16] } SReg_128:{ *:[v2i64] }:$src0)  =>  SReg_128:{ *:[v8i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3122,
      GIR_Done,
    // Label 504: @24727
    GIM_Try, /*On fail goto*//*Label 505*/ 24759, // Rule ID 3123 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v8i16] } SReg_128:{ *:[v2f64] }:$src0)  =>  SReg_128:{ *:[v8i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3123,
      GIR_Done,
    // Label 505: @24759
    GIM_Try, /*On fail goto*//*Label 506*/ 24791, // Rule ID 3124 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v8f16] } SReg_128:{ *:[v2i64] }:$src0)  =>  SReg_128:{ *:[v8f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3124,
      GIR_Done,
    // Label 506: @24791
    GIM_Try, /*On fail goto*//*Label 507*/ 24823, // Rule ID 3125 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v8f16] } SReg_128:{ *:[v2f64] }:$src0)  =>  SReg_128:{ *:[v8f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3125,
      GIR_Done,
    // Label 507: @24823
    GIM_Try, /*On fail goto*//*Label 508*/ 24855, // Rule ID 3126 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v8f16] } SReg_128:{ *:[v8i16] }:$src0)  =>  SReg_128:{ *:[v8f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3126,
      GIR_Done,
    // Label 508: @24855
    GIM_Reject,
    // Label 388: @24856
    GIM_Try, /*On fail goto*//*Label 509*/ 24888, // Rule ID 3153 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_256RegClassID,
      // (bitconvert:{ *:[v8i32] } SReg_256:{ *:[v8f32] }:$src0)  =>  SReg_256:{ *:[v8i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_256RegClassID,
      // GIR_Coverage, 3153,
      GIR_Done,
    // Label 509: @24888
    GIM_Try, /*On fail goto*//*Label 510*/ 24920, // Rule ID 3154 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_256RegClassID,
      // (bitconvert:{ *:[v8f32] } SReg_256:{ *:[v8i32] }:$src0)  =>  SReg_256:{ *:[v8f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_256RegClassID,
      // GIR_Coverage, 3154,
      GIR_Done,
    // Label 510: @24920
    GIM_Try, /*On fail goto*//*Label 511*/ 24952, // Rule ID 3155 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v8i32] } VReg_256:{ *:[v8f32] }:$src0)  =>  VReg_256:{ *:[v8i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3155,
      GIR_Done,
    // Label 511: @24952
    GIM_Try, /*On fail goto*//*Label 512*/ 24984, // Rule ID 3156 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v8f32] } VReg_256:{ *:[v8i32] }:$src0)  =>  VReg_256:{ *:[v8f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3156,
      GIR_Done,
    // Label 512: @24984
    GIM_Try, /*On fail goto*//*Label 513*/ 25016, // Rule ID 3163 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v8i32] } VReg_256:{ *:[v4i64] }:$src0)  =>  VReg_256:{ *:[v8i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3163,
      GIR_Done,
    // Label 513: @25016
    GIM_Try, /*On fail goto*//*Label 514*/ 25048, // Rule ID 3164 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v8f32] } VReg_256:{ *:[v4i64] }:$src0)  =>  VReg_256:{ *:[v8f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3164,
      GIR_Done,
    // Label 514: @25048
    GIM_Try, /*On fail goto*//*Label 515*/ 25080, // Rule ID 3165 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v8i32] } VReg_256:{ *:[v4f64] }:$src0)  =>  VReg_256:{ *:[v8i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3165,
      GIR_Done,
    // Label 515: @25080
    GIM_Try, /*On fail goto*//*Label 516*/ 25112, // Rule ID 3166 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v8f32] } VReg_256:{ *:[v4f64] }:$src0)  =>  VReg_256:{ *:[v8f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3166,
      GIR_Done,
    // Label 516: @25112
    GIM_Reject,
    // Label 389: @25113
    GIM_Try, /*On fail goto*//*Label 517*/ 25145, // Rule ID 3169 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v8i64] } VReg_512:{ *:[v8f64] }:$src0)  =>  VReg_512:{ *:[v8i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3169,
      GIR_Done,
    // Label 517: @25145
    GIM_Try, /*On fail goto*//*Label 518*/ 25177, // Rule ID 3170 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v8f64] } VReg_512:{ *:[v8i64] }:$src0)  =>  VReg_512:{ *:[v8f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3170,
      GIR_Done,
    // Label 518: @25177
    GIM_Try, /*On fail goto*//*Label 519*/ 25209, // Rule ID 3171 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v8i64] } VReg_512:{ *:[v16i32] }:$src0)  =>  VReg_512:{ *:[v8i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3171,
      GIR_Done,
    // Label 519: @25209
    GIM_Try, /*On fail goto*//*Label 520*/ 25241, // Rule ID 3172 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v8f64] } VReg_512:{ *:[v16i32] }:$src0)  =>  VReg_512:{ *:[v8f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3172,
      GIR_Done,
    // Label 520: @25241
    GIM_Try, /*On fail goto*//*Label 521*/ 25273, // Rule ID 3175 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v8i64] } VReg_512:{ *:[v16f32] }:$src0)  =>  VReg_512:{ *:[v8i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3175,
      GIR_Done,
    // Label 521: @25273
    GIM_Try, /*On fail goto*//*Label 522*/ 25305, // Rule ID 3176 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v8f64] } VReg_512:{ *:[v16f32] }:$src0)  =>  VReg_512:{ *:[v8f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3176,
      GIR_Done,
    // Label 522: @25305
    GIM_Reject,
    // Label 390: @25306
    GIM_Try, /*On fail goto*//*Label 523*/ 25338, // Rule ID 3167 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v16i32] } VReg_512:{ *:[v16f32] }:$src0)  =>  VReg_512:{ *:[v16i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3167,
      GIR_Done,
    // Label 523: @25338
    GIM_Try, /*On fail goto*//*Label 524*/ 25370, // Rule ID 3168 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v16f32] } VReg_512:{ *:[v16i32] }:$src0)  =>  VReg_512:{ *:[v16f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3168,
      GIR_Done,
    // Label 524: @25370
    GIM_Try, /*On fail goto*//*Label 525*/ 25402, // Rule ID 3173 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v16i32] } VReg_512:{ *:[v8i64] }:$src0)  =>  VReg_512:{ *:[v16i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3173,
      GIR_Done,
    // Label 525: @25402
    GIM_Try, /*On fail goto*//*Label 526*/ 25434, // Rule ID 3174 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v16i32] } VReg_512:{ *:[v8f64] }:$src0)  =>  VReg_512:{ *:[v16i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3174,
      GIR_Done,
    // Label 526: @25434
    GIM_Try, /*On fail goto*//*Label 527*/ 25466, // Rule ID 3177 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v16f32] } VReg_512:{ *:[v8i64] }:$src0)  =>  VReg_512:{ *:[v16f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3177,
      GIR_Done,
    // Label 527: @25466
    GIM_Try, /*On fail goto*//*Label 528*/ 25498, // Rule ID 3178 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v16f32] } VReg_512:{ *:[v8f64] }:$src0)  =>  VReg_512:{ *:[v16f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3178,
      GIR_Done,
    // Label 528: @25498
    GIM_Reject,
    // Label 391: @25499
    GIM_Try, /*On fail goto*//*Label 529*/ 25531, // Rule ID 3181 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v16i64] } VReg_1024:{ *:[v16f64] }:$src0)  =>  VReg_1024:{ *:[v16i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3181,
      GIR_Done,
    // Label 529: @25531
    GIM_Try, /*On fail goto*//*Label 530*/ 25563, // Rule ID 3182 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v16f64] } VReg_1024:{ *:[v16i64] }:$src0)  =>  VReg_1024:{ *:[v16f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3182,
      GIR_Done,
    // Label 530: @25563
    GIM_Try, /*On fail goto*//*Label 531*/ 25595, // Rule ID 3183 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v32s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v16i64] } VReg_1024:{ *:[v32i32] }:$src0)  =>  VReg_1024:{ *:[v16i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3183,
      GIR_Done,
    // Label 531: @25595
    GIM_Try, /*On fail goto*//*Label 532*/ 25627, // Rule ID 3185 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v32s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v16f64] } VReg_1024:{ *:[v32f32] }:$src0)  =>  VReg_1024:{ *:[v16f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3185,
      GIR_Done,
    // Label 532: @25627
    GIM_Try, /*On fail goto*//*Label 533*/ 25659, // Rule ID 3187 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v32s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v16i64] } VReg_1024:{ *:[v32f32] }:$src0)  =>  VReg_1024:{ *:[v16i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3187,
      GIR_Done,
    // Label 533: @25659
    GIM_Try, /*On fail goto*//*Label 534*/ 25691, // Rule ID 3189 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v32s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v16f64] } VReg_1024:{ *:[v32i32] }:$src0)  =>  VReg_1024:{ *:[v16f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3189,
      GIR_Done,
    // Label 534: @25691
    GIM_Reject,
    // Label 392: @25692
    GIM_Try, /*On fail goto*//*Label 535*/ 25724, // Rule ID 3179 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v32s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v32i32] } VReg_1024:{ *:[v32f32] }:$src0)  =>  VReg_1024:{ *:[v32i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3179,
      GIR_Done,
    // Label 535: @25724
    GIM_Try, /*On fail goto*//*Label 536*/ 25756, // Rule ID 3180 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v32s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v32f32] } VReg_1024:{ *:[v32i32] }:$src0)  =>  VReg_1024:{ *:[v32f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3180,
      GIR_Done,
    // Label 536: @25756
    GIM_Try, /*On fail goto*//*Label 537*/ 25788, // Rule ID 3184 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v32i32] } VReg_1024:{ *:[v16i64] }:$src0)  =>  VReg_1024:{ *:[v32i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3184,
      GIR_Done,
    // Label 537: @25788
    GIM_Try, /*On fail goto*//*Label 538*/ 25820, // Rule ID 3186 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v32f32] } VReg_1024:{ *:[v16f64] }:$src0)  =>  VReg_1024:{ *:[v32f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3186,
      GIR_Done,
    // Label 538: @25820
    GIM_Try, /*On fail goto*//*Label 539*/ 25852, // Rule ID 3188 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v32i32] } VReg_1024:{ *:[v16f64] }:$src0)  =>  VReg_1024:{ *:[v32i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3188,
      GIR_Done,
    // Label 539: @25852
    GIM_Try, /*On fail goto*//*Label 540*/ 25884, // Rule ID 3190 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v32f32] } VReg_1024:{ *:[v16i64] }:$src0)  =>  VReg_1024:{ *:[v32f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3190,
      GIR_Done,
    // Label 540: @25884
    GIM_Reject,
    // Label 393: @25885
    GIM_Reject,
    // Label 9: @25886
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 11, /*)*//*default:*//*Label 544*/ 26025,
    /*GILLT_s16*//*Label 541*/ 25895,
    /*GILLT_s32*//*Label 542*/ 25939,
    /*GILLT_s64*//*Label 543*/ 25981,
    // Label 541: @25895
    GIM_Try, /*On fail goto*//*Label 545*/ 25938, // Rule ID 479 //
      GIM_CheckFeatures, GIFBS_Has16BitInsts,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_vop3mods,
      // (ftrunc:{ *:[f16] } (VOP3Mods:{ *:[f16] } f16:{ *:[f16] }:$src0, i32:{ *:[i32] }:$src0_modifiers))  =>  (V_TRUNC_F16_e64:{ *:[f16] } i32:{ *:[i32] }:$src0_modifiers, f16:{ *:[f16] }:$src0)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_TRUNC_F16_e64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // src0_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // src0
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 479,
      GIR_Done,
    // Label 545: @25938
    GIM_Reject,
    // Label 542: @25939
    GIM_Try, /*On fail goto*//*Label 546*/ 25980, // Rule ID 411 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_vop3mods,
      // (ftrunc:{ *:[f32] } (VOP3Mods:{ *:[f32] } f32:{ *:[f32] }:$src0, i32:{ *:[i32] }:$src0_modifiers))  =>  (V_TRUNC_F32_e64:{ *:[f32] } i32:{ *:[i32] }:$src0_modifiers, f32:{ *:[f32] }:$src0)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_TRUNC_F32_e64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // src0_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // src0
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 411,
      GIR_Done,
    // Label 546: @25980
    GIM_Reject,
    // Label 543: @25981
    GIM_Try, /*On fail goto*//*Label 547*/ 26024, // Rule ID 455 //
      GIM_CheckFeatures, GIFBS_isGFX7Plus,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_vop3mods,
      // (ftrunc:{ *:[f64] } (VOP3Mods:{ *:[f64] } f64:{ *:[f64] }:$src0, i32:{ *:[i32] }:$src0_modifiers))  =>  (V_TRUNC_F64_e64:{ *:[f64] } i32:{ *:[i32] }:$src0_modifiers, f64:{ *:[f64] }:$src0)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_TRUNC_F64_e64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // src0_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // src0
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 455,
      GIR_Done,
    // Label 547: @26024
    GIM_Reject,
    // Label 544: @26025
    GIM_Reject,
    // Label 10: @26026
    GIM_Try, /*On fail goto*//*Label 548*/ 26126,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 549*/ 26110, // Rule ID 1739 //
        GIM_CheckFeatures, GIFBS_HasShaderCyclesRegister,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        // (readcyclecounter:{ *:[i64] })  =>  (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, (S_GETREG_B32:{ *:[i1] } 38941:{ *:[i32] }), sub0:{ *:[i32] }, (S_MOV_B32:{ *:[i1] } 0:{ *:[i32] }), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/2, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::S_GETREG_B32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/38941,
        GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::SRegOrLds_32_and_SReg_1RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::SReg_32_XM0RegClassID,
        // GIR_Coverage, 1739,
        GIR_Done,
      // Label 549: @26110
      GIM_Try, /*On fail goto*//*Label 550*/ 26125, // Rule ID 1738 //
        GIM_CheckFeatures, GIFBS_HasSMemTimeInst,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
        // (readcyclecounter:{ *:[i64] })  =>  (S_MEMTIME:{ *:[i64] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_MEMTIME,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1738,
        GIR_Done,
      // Label 550: @26125
      GIM_Reject,
    // Label 548: @26126
    GIM_Reject,
    // Label 11: @26127
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 26, /*)*//*default:*//*Label 573*/ 51182,
    /*GILLT_p0s64*//*Label 551*/ 26159,
    /*GILLT_p1s64*//*Label 552*/ 26920,
    /*GILLT_p2s32*//*Label 553*/ 27681,
    /*GILLT_p3s32*//*Label 554*/ 28433,
    /*GILLT_p4s64*//*Label 555*/ 29185,
    /*GILLT_p5s32*//*Label 556*/ 29946,
    /*GILLT_p6s32*//*Label 557*/ 30698,
    /*GILLT_s1*//*Label 558*/ 31450,
    /*GILLT_s16*//*Label 559*/ 31620,
    /*GILLT_s32*//*Label 560*/ 33194,
    /*GILLT_s64*//*Label 561*/ 37056,
    /*GILLT_v2s16*//*Label 562*/ 39172,
    /*GILLT_v2s32*//*Label 563*/ 40675,
    /*GILLT_v2s64*//*Label 564*/ 42468,
    /*GILLT_v3s32*//*Label 565*/ 43989, 0,
    /*GILLT_v4s16*//*Label 566*/ 45059,
    /*GILLT_v4s32*//*Label 567*/ 46580,
    /*GILLT_v4s64*//*Label 568*/ 48373, 0, 0, 0,
    /*GILLT_v8s16*//*Label 569*/ 48695,
    /*GILLT_v8s32*//*Label 570*/ 50216,
    /*GILLT_v8s64*//*Label 571*/ 50538,
    /*GILLT_v16s32*//*Label 572*/ 50860,
    // Label 551: @26159
    GIM_Try, /*On fail goto*//*Label 574*/ 26232, // Rule ID 3634 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemoryAlignment, /*MI*/0, /*MMO*/0, /*MinAlign*/8,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>><<P:Predicate_load_align8_local_m0>>  =>  (DS_READ_B64:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3634,
      GIR_Done,
    // Label 574: @26232
    GIM_Try, /*On fail goto*//*Label 575*/ 26296, // Rule ID 3635 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAlignment, /*MI*/0, /*MMO*/0, /*MinAlign*/8,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>><<P:Predicate_load_align8_local>>  =>  (DS_READ_B64_gfx9:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3635,
      GIR_Done,
    // Label 575: @26296
    GIM_Try, /*On fail goto*//*Label 576*/ 26352, // Rule ID 2164 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i64] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORDX2_SADDR:{ *:[i64] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORDX2_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2164,
      GIR_Done,
    // Label 576: @26352
    GIM_Try, /*On fail goto*//*Label 577*/ 26408, // Rule ID 2163 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i64] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2163,
      GIR_Done,
    // Label 577: @26408
    GIM_Try, /*On fail goto*//*Label 578*/ 26472, // Rule ID 3578 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init_isGFX7Plus,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_64bit_4byte_aligned,
      // (AMDGPUld_glue:{ *:[i64] } (DS64Bit4ByteAligned:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i8:{ *:[i8] }:$offset0, i8:{ *:[i8] }:$offset1))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>>  =>  (DS_READ2_B32:{ *:[i64] } ?:{ *:[i32] }:$ptr, ?:{ *:[i8] }:$offset0, ?:{ *:[i8] }:$offset1, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ2_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3578,
      GIR_Done,
    // Label 578: @26472
    GIM_Try, /*On fail goto*//*Label 579*/ 26532, // Rule ID 3580 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_64bit_4byte_aligned,
      // (ld:{ *:[i64] } (DS64Bit4ByteAligned:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i8:{ *:[i8] }:$offset0, i8:{ *:[i8] }:$offset1))<<P:Predicate_unindexedload>><<P:Predicate_load_local>>  =>  (DS_READ2_B32_gfx9:{ *:[i64] } ?:{ *:[i32] }:$ptr, ?:{ *:[i8] }:$offset0, ?:{ *:[i8] }:$offset1, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ2_B32_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3580,
      GIR_Done,
    // Label 579: @26532
    GIM_Try, /*On fail goto*//*Label 580*/ 26584, // Rule ID 3785 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
      // (ld:{ *:[i64] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3785,
      GIR_Done,
    // Label 580: @26584
    GIM_Try, /*On fail goto*//*Label 581*/ 26638, // Rule ID 3786 //
      GIM_CheckFeatures, GIFBS_isGFX7Only,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
      // (ld:{ *:[i64] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM_ci:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM_ci,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3786,
      GIR_Done,
    // Label 581: @26638
    GIM_Try, /*On fail goto*//*Label 582*/ 26690, // Rule ID 3787 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
      // (ld:{ *:[i64] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_SGPR:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_SGPR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3787,
      GIR_Done,
    // Label 582: @26690
    GIM_Try, /*On fail goto*//*Label 583*/ 26752, // Rule ID 1937 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i64] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORDX2_SADDR:{ *:[i64] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORDX2_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1937,
      GIR_Done,
    // Label 583: @26752
    GIM_Try, /*On fail goto*//*Label 584*/ 26810, // Rule ID 1936 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i64] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1936,
      GIR_Done,
    // Label 584: @26810
    GIM_Try, /*On fail goto*//*Label 585*/ 26860, // Rule ID 3788 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      // (ld:{ *:[i64] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i64] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3788,
      GIR_Done,
    // Label 585: @26860
    GIM_Try, /*On fail goto*//*Label 586*/ 26919, // Rule ID 1784 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[i64] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_flat>>  =>  (FLAT_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1784,
      GIR_Done,
    // Label 586: @26919
    GIM_Reject,
    // Label 552: @26920
    GIM_Try, /*On fail goto*//*Label 587*/ 26993, // Rule ID 3638 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemoryAlignment, /*MI*/0, /*MMO*/0, /*MinAlign*/8,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>><<P:Predicate_load_align8_local_m0>>  =>  (DS_READ_B64:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3638,
      GIR_Done,
    // Label 587: @26993
    GIM_Try, /*On fail goto*//*Label 588*/ 27057, // Rule ID 3639 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAlignment, /*MI*/0, /*MMO*/0, /*MinAlign*/8,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>><<P:Predicate_load_align8_local>>  =>  (DS_READ_B64_gfx9:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3639,
      GIR_Done,
    // Label 588: @27057
    GIM_Try, /*On fail goto*//*Label 589*/ 27113, // Rule ID 2168 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i64] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORDX2_SADDR:{ *:[i64] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORDX2_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2168,
      GIR_Done,
    // Label 589: @27113
    GIM_Try, /*On fail goto*//*Label 590*/ 27169, // Rule ID 2167 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i64] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2167,
      GIR_Done,
    // Label 590: @27169
    GIM_Try, /*On fail goto*//*Label 591*/ 27233, // Rule ID 3582 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init_isGFX7Plus,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_64bit_4byte_aligned,
      // (AMDGPUld_glue:{ *:[i64] } (DS64Bit4ByteAligned:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i8:{ *:[i8] }:$offset0, i8:{ *:[i8] }:$offset1))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>>  =>  (DS_READ2_B32:{ *:[i64] } ?:{ *:[i32] }:$ptr, ?:{ *:[i8] }:$offset0, ?:{ *:[i8] }:$offset1, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ2_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3582,
      GIR_Done,
    // Label 591: @27233
    GIM_Try, /*On fail goto*//*Label 592*/ 27293, // Rule ID 3584 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_64bit_4byte_aligned,
      // (ld:{ *:[i64] } (DS64Bit4ByteAligned:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i8:{ *:[i8] }:$offset0, i8:{ *:[i8] }:$offset1))<<P:Predicate_unindexedload>><<P:Predicate_load_local>>  =>  (DS_READ2_B32_gfx9:{ *:[i64] } ?:{ *:[i32] }:$ptr, ?:{ *:[i8] }:$offset0, ?:{ *:[i8] }:$offset1, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ2_B32_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3584,
      GIR_Done,
    // Label 592: @27293
    GIM_Try, /*On fail goto*//*Label 593*/ 27345, // Rule ID 3789 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
      // (ld:{ *:[i64] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3789,
      GIR_Done,
    // Label 593: @27345
    GIM_Try, /*On fail goto*//*Label 594*/ 27399, // Rule ID 3790 //
      GIM_CheckFeatures, GIFBS_isGFX7Only,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
      // (ld:{ *:[i64] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM_ci:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM_ci,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3790,
      GIR_Done,
    // Label 594: @27399
    GIM_Try, /*On fail goto*//*Label 595*/ 27451, // Rule ID 3791 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
      // (ld:{ *:[i64] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_SGPR:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_SGPR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3791,
      GIR_Done,
    // Label 595: @27451
    GIM_Try, /*On fail goto*//*Label 596*/ 27513, // Rule ID 1941 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i64] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORDX2_SADDR:{ *:[i64] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORDX2_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1941,
      GIR_Done,
    // Label 596: @27513
    GIM_Try, /*On fail goto*//*Label 597*/ 27571, // Rule ID 1940 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i64] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1940,
      GIR_Done,
    // Label 597: @27571
    GIM_Try, /*On fail goto*//*Label 598*/ 27621, // Rule ID 3792 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      // (ld:{ *:[i64] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i64] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3792,
      GIR_Done,
    // Label 598: @27621
    GIM_Try, /*On fail goto*//*Label 599*/ 27680, // Rule ID 1786 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[i64] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_flat>>  =>  (FLAT_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1786,
      GIR_Done,
    // Label 599: @27680
    GIM_Reject,
    // Label 553: @27681
    GIM_Try, /*On fail goto*//*Label 600*/ 27733, // Rule ID 1611 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
      // (ld:{ *:[i32] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1611,
      GIR_Done,
    // Label 600: @27733
    GIM_Try, /*On fail goto*//*Label 601*/ 27787, // Rule ID 1612 //
      GIM_CheckFeatures, GIFBS_isGFX7Only,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
      // (ld:{ *:[i32] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM_ci:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM_ci,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1612,
      GIR_Done,
    // Label 601: @27787
    GIM_Try, /*On fail goto*//*Label 602*/ 27839, // Rule ID 1613 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
      // (ld:{ *:[i32] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_SGPR:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_SGPR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1613,
      GIR_Done,
    // Label 602: @27839
    GIM_Try, /*On fail goto*//*Label 603*/ 27889, // Rule ID 1614 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      // (ld:{ *:[i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1614,
      GIR_Done,
    // Label 603: @27889
    GIM_Try, /*On fail goto*//*Label 604*/ 27955, // Rule ID 2761 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offset,
      // (ld:{ *:[i32] } (MUBUFScratchOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFSET:{ *:[i32] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2761,
      GIR_Done,
    // Label 604: @27955
    GIM_Try, /*On fail goto*//*Label 605*/ 28011, // Rule ID 2124 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i32] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD_SADDR:{ *:[i32] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2124,
      GIR_Done,
    // Label 605: @28011
    GIM_Try, /*On fail goto*//*Label 606*/ 28067, // Rule ID 2123 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i32] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2123,
      GIR_Done,
    // Label 606: @28067
    GIM_Try, /*On fail goto*//*Label 607*/ 28137, // Rule ID 2760 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offen,
      // (ld:{ *:[i32] } (MUBUFScratchOffen:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$vaddr, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFEN:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFEN,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2760,
      GIR_Done,
    // Label 607: @28137
    GIM_Try, /*On fail goto*//*Label 608*/ 28197, // Rule ID 3480 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>>  =>  (DS_READ_B32:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3480,
      GIR_Done,
    // Label 608: @28197
    GIM_Try, /*On fail goto*//*Label 609*/ 28253, // Rule ID 3481 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>>  =>  (DS_READ_B32_gfx9:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3481,
      GIR_Done,
    // Label 609: @28253
    GIM_Try, /*On fail goto*//*Label 610*/ 28315, // Rule ID 1897 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i32] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORD_SADDR:{ *:[i32] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1897,
      GIR_Done,
    // Label 610: @28315
    GIM_Try, /*On fail goto*//*Label 611*/ 28373, // Rule ID 1896 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i32] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORD:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1896,
      GIR_Done,
    // Label 611: @28373
    GIM_Try, /*On fail goto*//*Label 612*/ 28432, // Rule ID 1763 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[i32] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_flat>>  =>  (FLAT_LOAD_DWORD:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1763,
      GIR_Done,
    // Label 612: @28432
    GIM_Reject,
    // Label 554: @28433
    GIM_Try, /*On fail goto*//*Label 613*/ 28485, // Rule ID 1615 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
      // (ld:{ *:[i32] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1615,
      GIR_Done,
    // Label 613: @28485
    GIM_Try, /*On fail goto*//*Label 614*/ 28539, // Rule ID 1616 //
      GIM_CheckFeatures, GIFBS_isGFX7Only,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
      // (ld:{ *:[i32] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM_ci:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM_ci,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1616,
      GIR_Done,
    // Label 614: @28539
    GIM_Try, /*On fail goto*//*Label 615*/ 28591, // Rule ID 1617 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
      // (ld:{ *:[i32] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_SGPR:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_SGPR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1617,
      GIR_Done,
    // Label 615: @28591
    GIM_Try, /*On fail goto*//*Label 616*/ 28641, // Rule ID 1618 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      // (ld:{ *:[i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1618,
      GIR_Done,
    // Label 616: @28641
    GIM_Try, /*On fail goto*//*Label 617*/ 28707, // Rule ID 2763 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offset,
      // (ld:{ *:[i32] } (MUBUFScratchOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFSET:{ *:[i32] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2763,
      GIR_Done,
    // Label 617: @28707
    GIM_Try, /*On fail goto*//*Label 618*/ 28763, // Rule ID 2128 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i32] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD_SADDR:{ *:[i32] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2128,
      GIR_Done,
    // Label 618: @28763
    GIM_Try, /*On fail goto*//*Label 619*/ 28819, // Rule ID 2127 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i32] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2127,
      GIR_Done,
    // Label 619: @28819
    GIM_Try, /*On fail goto*//*Label 620*/ 28889, // Rule ID 2762 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offen,
      // (ld:{ *:[i32] } (MUBUFScratchOffen:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$vaddr, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFEN:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFEN,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2762,
      GIR_Done,
    // Label 620: @28889
    GIM_Try, /*On fail goto*//*Label 621*/ 28949, // Rule ID 3482 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>>  =>  (DS_READ_B32:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3482,
      GIR_Done,
    // Label 621: @28949
    GIM_Try, /*On fail goto*//*Label 622*/ 29005, // Rule ID 3483 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>>  =>  (DS_READ_B32_gfx9:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3483,
      GIR_Done,
    // Label 622: @29005
    GIM_Try, /*On fail goto*//*Label 623*/ 29067, // Rule ID 1901 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i32] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORD_SADDR:{ *:[i32] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1901,
      GIR_Done,
    // Label 623: @29067
    GIM_Try, /*On fail goto*//*Label 624*/ 29125, // Rule ID 1900 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i32] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORD:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1900,
      GIR_Done,
    // Label 624: @29125
    GIM_Try, /*On fail goto*//*Label 625*/ 29184, // Rule ID 1765 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[i32] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_flat>>  =>  (FLAT_LOAD_DWORD:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1765,
      GIR_Done,
    // Label 625: @29184
    GIM_Reject,
    // Label 555: @29185
    GIM_Try, /*On fail goto*//*Label 626*/ 29258, // Rule ID 3642 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemoryAlignment, /*MI*/0, /*MMO*/0, /*MinAlign*/8,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>><<P:Predicate_load_align8_local_m0>>  =>  (DS_READ_B64:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3642,
      GIR_Done,
    // Label 626: @29258
    GIM_Try, /*On fail goto*//*Label 627*/ 29322, // Rule ID 3643 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAlignment, /*MI*/0, /*MMO*/0, /*MinAlign*/8,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>><<P:Predicate_load_align8_local>>  =>  (DS_READ_B64_gfx9:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3643,
      GIR_Done,
    // Label 627: @29322
    GIM_Try, /*On fail goto*//*Label 628*/ 29378, // Rule ID 2172 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i64] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORDX2_SADDR:{ *:[i64] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORDX2_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2172,
      GIR_Done,
    // Label 628: @29378
    GIM_Try, /*On fail goto*//*Label 629*/ 29434, // Rule ID 2171 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i64] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2171,
      GIR_Done,
    // Label 629: @29434
    GIM_Try, /*On fail goto*//*Label 630*/ 29498, // Rule ID 3586 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init_isGFX7Plus,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_64bit_4byte_aligned,
      // (AMDGPUld_glue:{ *:[i64] } (DS64Bit4ByteAligned:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i8:{ *:[i8] }:$offset0, i8:{ *:[i8] }:$offset1))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>>  =>  (DS_READ2_B32:{ *:[i64] } ?:{ *:[i32] }:$ptr, ?:{ *:[i8] }:$offset0, ?:{ *:[i8] }:$offset1, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ2_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3586,
      GIR_Done,
    // Label 630: @29498
    GIM_Try, /*On fail goto*//*Label 631*/ 29558, // Rule ID 3588 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_64bit_4byte_aligned,
      // (ld:{ *:[i64] } (DS64Bit4ByteAligned:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i8:{ *:[i8] }:$offset0, i8:{ *:[i8] }:$offset1))<<P:Predicate_unindexedload>><<P:Predicate_load_local>>  =>  (DS_READ2_B32_gfx9:{ *:[i64] } ?:{ *:[i32] }:$ptr, ?:{ *:[i8] }:$offset0, ?:{ *:[i8] }:$offset1, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ2_B32_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3588,
      GIR_Done,
    // Label 631: @29558
    GIM_Try, /*On fail goto*//*Label 632*/ 29610, // Rule ID 3793 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
      // (ld:{ *:[i64] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3793,
      GIR_Done,
    // Label 632: @29610
    GIM_Try, /*On fail goto*//*Label 633*/ 29664, // Rule ID 3794 //
      GIM_CheckFeatures, GIFBS_isGFX7Only,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
      // (ld:{ *:[i64] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM_ci:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM_ci,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3794,
      GIR_Done,
    // Label 633: @29664
    GIM_Try, /*On fail goto*//*Label 634*/ 29716, // Rule ID 3795 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
      // (ld:{ *:[i64] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_SGPR:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_SGPR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3795,
      GIR_Done,
    // Label 634: @29716
    GIM_Try, /*On fail goto*//*Label 635*/ 29778, // Rule ID 1945 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i64] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORDX2_SADDR:{ *:[i64] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORDX2_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1945,
      GIR_Done,
    // Label 635: @29778
    GIM_Try, /*On fail goto*//*Label 636*/ 29836, // Rule ID 1944 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i64] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1944,
      GIR_Done,
    // Label 636: @29836
    GIM_Try, /*On fail goto*//*Label 637*/ 29886, // Rule ID 3796 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      // (ld:{ *:[i64] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i64] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3796,
      GIR_Done,
    // Label 637: @29886
    GIM_Try, /*On fail goto*//*Label 638*/ 29945, // Rule ID 1788 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[i64] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_flat>>  =>  (FLAT_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1788,
      GIR_Done,
    // Label 638: @29945
    GIM_Reject,
    // Label 556: @29946
    GIM_Try, /*On fail goto*//*Label 639*/ 29998, // Rule ID 1619 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
      // (ld:{ *:[i32] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1619,
      GIR_Done,
    // Label 639: @29998
    GIM_Try, /*On fail goto*//*Label 640*/ 30052, // Rule ID 1620 //
      GIM_CheckFeatures, GIFBS_isGFX7Only,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
      // (ld:{ *:[i32] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM_ci:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM_ci,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1620,
      GIR_Done,
    // Label 640: @30052
    GIM_Try, /*On fail goto*//*Label 641*/ 30104, // Rule ID 1621 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
      // (ld:{ *:[i32] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_SGPR:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_SGPR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1621,
      GIR_Done,
    // Label 641: @30104
    GIM_Try, /*On fail goto*//*Label 642*/ 30154, // Rule ID 1622 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      // (ld:{ *:[i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1622,
      GIR_Done,
    // Label 642: @30154
    GIM_Try, /*On fail goto*//*Label 643*/ 30220, // Rule ID 2765 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offset,
      // (ld:{ *:[i32] } (MUBUFScratchOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFSET:{ *:[i32] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2765,
      GIR_Done,
    // Label 643: @30220
    GIM_Try, /*On fail goto*//*Label 644*/ 30276, // Rule ID 2132 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i32] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD_SADDR:{ *:[i32] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2132,
      GIR_Done,
    // Label 644: @30276
    GIM_Try, /*On fail goto*//*Label 645*/ 30332, // Rule ID 2131 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i32] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2131,
      GIR_Done,
    // Label 645: @30332
    GIM_Try, /*On fail goto*//*Label 646*/ 30402, // Rule ID 2764 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offen,
      // (ld:{ *:[i32] } (MUBUFScratchOffen:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$vaddr, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFEN:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFEN,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2764,
      GIR_Done,
    // Label 646: @30402
    GIM_Try, /*On fail goto*//*Label 647*/ 30462, // Rule ID 3484 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>>  =>  (DS_READ_B32:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3484,
      GIR_Done,
    // Label 647: @30462
    GIM_Try, /*On fail goto*//*Label 648*/ 30518, // Rule ID 3485 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>>  =>  (DS_READ_B32_gfx9:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3485,
      GIR_Done,
    // Label 648: @30518
    GIM_Try, /*On fail goto*//*Label 649*/ 30580, // Rule ID 1905 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i32] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORD_SADDR:{ *:[i32] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1905,
      GIR_Done,
    // Label 649: @30580
    GIM_Try, /*On fail goto*//*Label 650*/ 30638, // Rule ID 1904 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i32] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORD:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1904,
      GIR_Done,
    // Label 650: @30638
    GIM_Try, /*On fail goto*//*Label 651*/ 30697, // Rule ID 1767 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[i32] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_flat>>  =>  (FLAT_LOAD_DWORD:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1767,
      GIR_Done,
    // Label 651: @30697
    GIM_Reject,
    // Label 557: @30698
    GIM_Try, /*On fail goto*//*Label 652*/ 30750, // Rule ID 1623 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
      // (ld:{ *:[i32] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1623,
      GIR_Done,
    // Label 652: @30750
    GIM_Try, /*On fail goto*//*Label 653*/ 30804, // Rule ID 1624 //
      GIM_CheckFeatures, GIFBS_isGFX7Only,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
      // (ld:{ *:[i32] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM_ci:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM_ci,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1624,
      GIR_Done,
    // Label 653: @30804
    GIM_Try, /*On fail goto*//*Label 654*/ 30856, // Rule ID 1625 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
      // (ld:{ *:[i32] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_SGPR:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_SGPR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1625,
      GIR_Done,
    // Label 654: @30856
    GIM_Try, /*On fail goto*//*Label 655*/ 30906, // Rule ID 1626 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      // (ld:{ *:[i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1626,
      GIR_Done,
    // Label 655: @30906
    GIM_Try, /*On fail goto*//*Label 656*/ 30972, // Rule ID 2767 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offset,
      // (ld:{ *:[i32] } (MUBUFScratchOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFSET:{ *:[i32] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2767,
      GIR_Done,
    // Label 656: @30972
    GIM_Try, /*On fail goto*//*Label 657*/ 31028, // Rule ID 2136 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i32] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD_SADDR:{ *:[i32] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2136,
      GIR_Done,
    // Label 657: @31028
    GIM_Try, /*On fail goto*//*Label 658*/ 31084, // Rule ID 2135 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i32] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2135,
      GIR_Done,
    // Label 658: @31084
    GIM_Try, /*On fail goto*//*Label 659*/ 31154, // Rule ID 2766 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offen,
      // (ld:{ *:[i32] } (MUBUFScratchOffen:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$vaddr, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFEN:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFEN,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2766,
      GIR_Done,
    // Label 659: @31154
    GIM_Try, /*On fail goto*//*Label 660*/ 31214, // Rule ID 3486 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>>  =>  (DS_READ_B32:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3486,
      GIR_Done,
    // Label 660: @31214
    GIM_Try, /*On fail goto*//*Label 661*/ 31270, // Rule ID 3487 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>>  =>  (DS_READ_B32_gfx9:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3487,
      GIR_Done,
    // Label 661: @31270
    GIM_Try, /*On fail goto*//*Label 662*/ 31332, // Rule ID 1909 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i32] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORD_SADDR:{ *:[i32] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1909,
      GIR_Done,
    // Label 662: @31332
    GIM_Try, /*On fail goto*//*Label 663*/ 31390, // Rule ID 1908 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i32] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORD:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1908,
      GIR_Done,
    // Label 663: @31390
    GIM_Try, /*On fail goto*//*Label 664*/ 31449, // Rule ID 1769 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[i32] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_flat>>  =>  (FLAT_LOAD_DWORD:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1769,
      GIR_Done,
    // Label 664: @31449
    GIM_Reject,
    // Label 558: @31450
    GIM_Try, /*On fail goto*//*Label 665*/ 31619,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_Try, /*On fail goto*//*Label 666*/ 31504, // Rule ID 1643 //
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
        // (ld:{ *:[i1] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i1] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1643,
        GIR_Done,
      // Label 666: @31504
      GIM_Try, /*On fail goto*//*Label 667*/ 31544, // Rule ID 1644 //
        GIM_CheckFeatures, GIFBS_isGFX7Only,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
        // (ld:{ *:[i1] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM_ci:{ *:[i1] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM_ci,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1644,
        GIR_Done,
      // Label 667: @31544
      GIM_Try, /*On fail goto*//*Label 668*/ 31582, // Rule ID 1645 //
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
        // (ld:{ *:[i1] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_SGPR:{ *:[i1] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_SGPR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1645,
        GIR_Done,
      // Label 668: @31582
      GIM_Try, /*On fail goto*//*Label 669*/ 31618, // Rule ID 1646 //
        // MIs[0] sbase
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
        // (ld:{ *:[i1] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i1] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1646,
        GIR_Done,
      // Label 669: @31618
      GIM_Reject,
    // Label 665: @31619
    GIM_Reject,
    // Label 559: @31620
    GIM_Try, /*On fail goto*//*Label 670*/ 31690, // Rule ID 2741 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offset,
      // (ld:{ *:[i16] } (MUBUFScratchOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8_private>>  =>  (BUFFER_LOAD_UBYTE_OFFSET:{ *:[i16] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_UBYTE_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2741,
      GIR_Done,
    // Label 670: @31690
    GIM_Try, /*On fail goto*//*Label 671*/ 31756, // Rule ID 2751 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offset,
      // (ld:{ *:[i16] } (MUBUFScratchOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_USHORT_OFFSET:{ *:[i16] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_USHORT_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2751,
      GIR_Done,
    // Label 671: @31756
    GIM_Try, /*On fail goto*//*Label 672*/ 31816, // Rule ID 2096 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i16] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8_private>>  =>  (SCRATCH_LOAD_UBYTE_SADDR:{ *:[i16] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_UBYTE_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2096,
      GIR_Done,
    // Label 672: @31816
    GIM_Try, /*On fail goto*//*Label 673*/ 31872, // Rule ID 2108 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i16] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_USHORT_SADDR:{ *:[i16] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_USHORT_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2108,
      GIR_Done,
    // Label 673: @31872
    GIM_Try, /*On fail goto*//*Label 674*/ 31932, // Rule ID 2095 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i16] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8_private>>  =>  (SCRATCH_LOAD_UBYTE:{ *:[i16] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_UBYTE,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2095,
      GIR_Done,
    // Label 674: @31932
    GIM_Try, /*On fail goto*//*Label 675*/ 31988, // Rule ID 2107 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i16] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_USHORT:{ *:[i16] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_USHORT,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2107,
      GIR_Done,
    // Label 675: @31988
    GIM_Try, /*On fail goto*//*Label 676*/ 32062, // Rule ID 2740 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offen,
      // (ld:{ *:[i16] } (MUBUFScratchOffen:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$vaddr, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8_private>>  =>  (BUFFER_LOAD_UBYTE_OFFEN:{ *:[i16] } ?:{ *:[i32] }:$vaddr, ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_UBYTE_OFFEN,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2740,
      GIR_Done,
    // Label 676: @32062
    GIM_Try, /*On fail goto*//*Label 677*/ 32132, // Rule ID 2750 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offen,
      // (ld:{ *:[i16] } (MUBUFScratchOffen:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$vaddr, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_USHORT_OFFEN:{ *:[i16] } ?:{ *:[i32] }:$vaddr, ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_USHORT_OFFEN,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2750,
      GIR_Done,
    // Label 677: @32132
    GIM_Try, /*On fail goto*//*Label 678*/ 32203, // Rule ID 2724 //
      GIM_CheckFeatures, GIFBS_Has16BitInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/2, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_offset,
      // (ld:{ *:[i16] } (MUBUFOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8_constant>>  =>  (BUFFER_LOAD_UBYTE_OFFSET:{ *:[i16] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_UBYTE_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2724,
      GIR_Done,
    // Label 678: @32203
    GIM_Try, /*On fail goto*//*Label 679*/ 32275, // Rule ID 2727 //
      GIM_CheckFeatures, GIFBS_Has16BitInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_offset,
      // (ld:{ *:[i16] } (MUBUFOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8_global>>  =>  (BUFFER_LOAD_UBYTE_OFFSET:{ *:[i16] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_UBYTE_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2727,
      GIR_Done,
    // Label 679: @32275
    GIM_Try, /*On fail goto*//*Label 680*/ 32343, // Rule ID 2729 //
      GIM_CheckFeatures, GIFBS_Has16BitInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_offset,
      // (ld:{ *:[i16] } (MUBUFOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (BUFFER_LOAD_USHORT_OFFSET:{ *:[i16] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_USHORT_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2729,
      GIR_Done,
    // Label 680: @32343
    GIM_Try, /*On fail goto*//*Label 681*/ 32403, // Rule ID 3488 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUatomic_ld_glue:{ *:[i16] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_8_glue>><<P:Predicate_atomic_load_8_local_m0>>  =>  (DS_READ_U8:{ *:[i16] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3488,
      GIR_Done,
    // Label 681: @32403
    GIM_Try, /*On fail goto*//*Label 682*/ 32463, // Rule ID 3489 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (atomic_load:{ *:[i16] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_8>><<P:Predicate_atomic_load_8_local>>  =>  (DS_READ_U8_gfx9:{ *:[i16] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U8_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3489,
      GIR_Done,
    // Label 682: @32463
    GIM_Try, /*On fail goto*//*Label 683*/ 32523, // Rule ID 3492 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUatomic_ld_glue:{ *:[i16] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_16_glue>><<P:Predicate_atomic_load_16_local_m0>>  =>  (DS_READ_U16:{ *:[i16] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3492,
      GIR_Done,
    // Label 683: @32523
    GIM_Try, /*On fail goto*//*Label 684*/ 32583, // Rule ID 3493 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (atomic_load:{ *:[i16] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_16>><<P:Predicate_atomic_load_16_local>>  =>  (DS_READ_U16_gfx9:{ *:[i16] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U16_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3493,
      GIR_Done,
    // Label 684: @32583
    GIM_Try, /*On fail goto*//*Label 685*/ 32647, // Rule ID 3458 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i16] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_extload_glue>><<P:Predicate_extloadi8_glue>><<P:Predicate_extloadi8_local_m0>>  =>  (DS_READ_U8:{ *:[i16] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3458,
      GIR_Done,
    // Label 685: @32647
    GIM_Try, /*On fail goto*//*Label 686*/ 32707, // Rule ID 3459 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i16] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8_local>>  =>  (DS_READ_U8_gfx9:{ *:[i16] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U8_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3459,
      GIR_Done,
    // Label 686: @32707
    GIM_Try, /*On fail goto*//*Label 687*/ 32767, // Rule ID 3470 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i16] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>>  =>  (DS_READ_U16:{ *:[i16] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3470,
      GIR_Done,
    // Label 687: @32767
    GIM_Try, /*On fail goto*//*Label 688*/ 32823, // Rule ID 3471 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i16] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>>  =>  (DS_READ_U16_gfx9:{ *:[i16] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U16_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3471,
      GIR_Done,
    // Label 688: @32823
    GIM_Try, /*On fail goto*//*Label 689*/ 32889, // Rule ID 1869 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i16] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8_global>>  =>  (GLOBAL_LOAD_UBYTE_SADDR:{ *:[i16] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_UBYTE_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1869,
      GIR_Done,
    // Label 689: @32889
    GIM_Try, /*On fail goto*//*Label 690*/ 32951, // Rule ID 1881 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i16] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_USHORT_SADDR:{ *:[i16] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_USHORT_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1881,
      GIR_Done,
    // Label 690: @32951
    GIM_Try, /*On fail goto*//*Label 691*/ 33013, // Rule ID 1868 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i16] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8_global>>  =>  (GLOBAL_LOAD_UBYTE:{ *:[i16] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_UBYTE,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1868,
      GIR_Done,
    // Label 691: @33013
    GIM_Try, /*On fail goto*//*Label 692*/ 33071, // Rule ID 1880 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i16] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_USHORT:{ *:[i16] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_USHORT,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1880,
      GIR_Done,
    // Label 692: @33071
    GIM_Try, /*On fail goto*//*Label 693*/ 33134, // Rule ID 1743 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[i16] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8_flat>>  =>  (FLAT_LOAD_UBYTE:{ *:[i16] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_UBYTE,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1743,
      GIR_Done,
    // Label 693: @33134
    GIM_Try, /*On fail goto*//*Label 694*/ 33193, // Rule ID 1748 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[i16] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_flat>>  =>  (FLAT_LOAD_USHORT:{ *:[i16] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_USHORT,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1748,
      GIR_Done,
    // Label 694: @33193
    GIM_Reject,
    // Label 560: @33194
    GIM_Try, /*On fail goto*//*Label 695*/ 33246, // Rule ID 1592 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
      // (ld:{ *:[i32] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1592,
      GIR_Done,
    // Label 695: @33246
    GIM_Try, /*On fail goto*//*Label 696*/ 33300, // Rule ID 1593 //
      GIM_CheckFeatures, GIFBS_isGFX7Only,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
      // (ld:{ *:[i32] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM_ci:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM_ci,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1593,
      GIR_Done,
    // Label 696: @33300
    GIM_Try, /*On fail goto*//*Label 697*/ 33352, // Rule ID 1594 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
      // (ld:{ *:[i32] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_SGPR:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_SGPR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1594,
      GIR_Done,
    // Label 697: @33352
    GIM_Try, /*On fail goto*//*Label 698*/ 33404, // Rule ID 1599 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
      // (ld:{ *:[f32] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[f32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1599,
      GIR_Done,
    // Label 698: @33404
    GIM_Try, /*On fail goto*//*Label 699*/ 33458, // Rule ID 1600 //
      GIM_CheckFeatures, GIFBS_isGFX7Only,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
      // (ld:{ *:[f32] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM_ci:{ *:[f32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM_ci,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1600,
      GIR_Done,
    // Label 699: @33458
    GIM_Try, /*On fail goto*//*Label 700*/ 33510, // Rule ID 1601 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
      // (ld:{ *:[f32] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_SGPR:{ *:[f32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_SGPR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1601,
      GIR_Done,
    // Label 700: @33510
    GIM_Try, /*On fail goto*//*Label 701*/ 33560, // Rule ID 1595 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      // (ld:{ *:[i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1595,
      GIR_Done,
    // Label 701: @33560
    GIM_Try, /*On fail goto*//*Label 702*/ 33610, // Rule ID 1602 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      // (ld:{ *:[f32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[f32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1602,
      GIR_Done,
    // Label 702: @33610
    GIM_Try, /*On fail goto*//*Label 703*/ 33680, // Rule ID 2735 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offset,
      // (ld:{ *:[i32] } (MUBUFScratchOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8_private>>  =>  (BUFFER_LOAD_UBYTE_OFFSET:{ *:[i32] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_UBYTE_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2735,
      GIR_Done,
    // Label 703: @33680
    GIM_Try, /*On fail goto*//*Label 704*/ 33750, // Rule ID 2747 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offset,
      // (ld:{ *:[i32] } (MUBUFScratchOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16_private>>  =>  (BUFFER_LOAD_USHORT_OFFSET:{ *:[i32] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_USHORT_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2747,
      GIR_Done,
    // Label 704: @33750
    GIM_Try, /*On fail goto*//*Label 705*/ 33816, // Rule ID 2753 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offset,
      // (ld:{ *:[i32] } (MUBUFScratchOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFSET:{ *:[i32] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2753,
      GIR_Done,
    // Label 705: @33816
    GIM_Try, /*On fail goto*//*Label 706*/ 33882, // Rule ID 2755 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offset,
      // (ld:{ *:[f32] } (MUBUFScratchOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFSET:{ *:[f32] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2755,
      GIR_Done,
    // Label 706: @33882
    GIM_Try, /*On fail goto*//*Label 707*/ 33942, // Rule ID 1859 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i32] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8_private>>  =>  (SCRATCH_LOAD_UBYTE_SADDR:{ *:[i32] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_UBYTE_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1859,
      GIR_Done,
    // Label 707: @33942
    GIM_Try, /*On fail goto*//*Label 708*/ 34002, // Rule ID 2102 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i32] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16_private>>  =>  (SCRATCH_LOAD_USHORT_SADDR:{ *:[i32] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_USHORT_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2102,
      GIR_Done,
    // Label 708: @34002
    GIM_Try, /*On fail goto*//*Label 709*/ 34058, // Rule ID 2110 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i32] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD_SADDR:{ *:[i32] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2110,
      GIR_Done,
    // Label 709: @34058
    GIM_Try, /*On fail goto*//*Label 710*/ 34114, // Rule ID 2112 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[f32] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD_SADDR:{ *:[f32] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2112,
      GIR_Done,
    // Label 710: @34114
    GIM_Try, /*On fail goto*//*Label 711*/ 34174, // Rule ID 1858 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i32] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8_private>>  =>  (SCRATCH_LOAD_UBYTE:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_UBYTE,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1858,
      GIR_Done,
    // Label 711: @34174
    GIM_Try, /*On fail goto*//*Label 712*/ 34234, // Rule ID 2101 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i32] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16_private>>  =>  (SCRATCH_LOAD_USHORT:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_USHORT,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2101,
      GIR_Done,
    // Label 712: @34234
    GIM_Try, /*On fail goto*//*Label 713*/ 34290, // Rule ID 2109 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i32] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2109,
      GIR_Done,
    // Label 713: @34290
    GIM_Try, /*On fail goto*//*Label 714*/ 34346, // Rule ID 2111 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[f32] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD:{ *:[f32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2111,
      GIR_Done,
    // Label 714: @34346
    GIM_Try, /*On fail goto*//*Label 715*/ 34422, // Rule ID 2713 //
      GIM_CheckFeatures, GIFBS_isGFX6GFX7,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_addr64,
      // (atomic_load:{ *:[i32] } (MUBUFAddr64:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i64:{ *:[i64] }:$vaddr, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_32>><<P:Predicate_atomic_load_32_global>>  =>  (BUFFER_LOAD_DWORD_ADDR64:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_ADDR64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2713,
      GIR_Done,
    // Label 715: @34422
    GIM_Try, /*On fail goto*//*Label 716*/ 34496, // Rule ID 2238 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_addr64,
      // (ld:{ *:[i32] } (MUBUFAddr64:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i64:{ *:[i64] }:$vaddr, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8_global>>  =>  (BUFFER_LOAD_UBYTE_ADDR64:{ *:[i32] } i64:{ *:[i64] }:$vaddr, v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_UBYTE_ADDR64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2238,
      GIR_Done,
    // Label 716: @34496
    GIM_Try, /*On fail goto*//*Label 717*/ 34570, // Rule ID 2244 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_addr64,
      // (ld:{ *:[i32] } (MUBUFAddr64:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i64:{ *:[i64] }:$vaddr, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16_global>>  =>  (BUFFER_LOAD_USHORT_ADDR64:{ *:[i32] } i64:{ *:[i64] }:$vaddr, v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_USHORT_ADDR64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2244,
      GIR_Done,
    // Label 717: @34570
    GIM_Try, /*On fail goto*//*Label 718*/ 34645, // Rule ID 2716 //
      GIM_CheckFeatures, GIFBS_isGFX6GFX7,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/2, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_addr64,
      // (ld:{ *:[i32] } (MUBUFAddr64:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i64:{ *:[i64] }:$vaddr, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8_constant>>  =>  (BUFFER_LOAD_UBYTE_ADDR64:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_UBYTE_ADDR64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2716,
      GIR_Done,
    // Label 718: @34645
    GIM_Try, /*On fail goto*//*Label 719*/ 34720, // Rule ID 2719 //
      GIM_CheckFeatures, GIFBS_isGFX6GFX7,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/2, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_addr64,
      // (ld:{ *:[i32] } (MUBUFAddr64:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i64:{ *:[i64] }:$vaddr, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16_constant>>  =>  (BUFFER_LOAD_USHORT_ADDR64:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_USHORT_ADDR64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2719,
      GIR_Done,
    // Label 719: @34720
    GIM_Try, /*On fail goto*//*Label 720*/ 34794, // Rule ID 2734 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offen,
      // (ld:{ *:[i32] } (MUBUFScratchOffen:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$vaddr, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8_private>>  =>  (BUFFER_LOAD_UBYTE_OFFEN:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_UBYTE_OFFEN,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2734,
      GIR_Done,
    // Label 720: @34794
    GIM_Try, /*On fail goto*//*Label 721*/ 34868, // Rule ID 2746 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offen,
      // (ld:{ *:[i32] } (MUBUFScratchOffen:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$vaddr, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16_private>>  =>  (BUFFER_LOAD_USHORT_OFFEN:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_USHORT_OFFEN,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2746,
      GIR_Done,
    // Label 721: @34868
    GIM_Try, /*On fail goto*//*Label 722*/ 34938, // Rule ID 2250 //
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_addr64,
      // (ld:{ *:[i32] } (MUBUFAddr64:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i64:{ *:[i64] }:$vaddr, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (BUFFER_LOAD_DWORD_ADDR64:{ *:[i32] } i64:{ *:[i64] }:$vaddr, v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_ADDR64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2250,
      GIR_Done,
    // Label 722: @34938
    GIM_Try, /*On fail goto*//*Label 723*/ 35008, // Rule ID 2752 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offen,
      // (ld:{ *:[i32] } (MUBUFScratchOffen:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$vaddr, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFEN:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFEN,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2752,
      GIR_Done,
    // Label 723: @35008
    GIM_Try, /*On fail goto*//*Label 724*/ 35078, // Rule ID 2754 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offen,
      // (ld:{ *:[f32] } (MUBUFScratchOffen:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$vaddr, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFEN:{ *:[f32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFEN,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2754,
      GIR_Done,
    // Label 724: @35078
    GIM_Try, /*On fail goto*//*Label 725*/ 35148, // Rule ID 2237 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_offset,
      // (ld:{ *:[i32] } (MUBUFOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8_global>>  =>  (BUFFER_LOAD_UBYTE_OFFSET:{ *:[i32] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_UBYTE_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2237,
      GIR_Done,
    // Label 725: @35148
    GIM_Try, /*On fail goto*//*Label 726*/ 35218, // Rule ID 2243 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_offset,
      // (ld:{ *:[i32] } (MUBUFOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16_global>>  =>  (BUFFER_LOAD_USHORT_OFFSET:{ *:[i32] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_USHORT_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2243,
      GIR_Done,
    // Label 726: @35218
    GIM_Try, /*On fail goto*//*Label 727*/ 35284, // Rule ID 2249 //
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_offset,
      // (ld:{ *:[i32] } (MUBUFOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (BUFFER_LOAD_DWORD_OFFSET:{ *:[i32] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2249,
      GIR_Done,
    // Label 727: @35284
    GIM_Try, /*On fail goto*//*Label 728*/ 35344, // Rule ID 3490 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUatomic_ld_glue:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_8_glue>><<P:Predicate_atomic_load_8_local_m0>>  =>  (DS_READ_U8:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3490,
      GIR_Done,
    // Label 728: @35344
    GIM_Try, /*On fail goto*//*Label 729*/ 35404, // Rule ID 3491 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (atomic_load:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_8>><<P:Predicate_atomic_load_8_local>>  =>  (DS_READ_U8_gfx9:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U8_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3491,
      GIR_Done,
    // Label 729: @35404
    GIM_Try, /*On fail goto*//*Label 730*/ 35464, // Rule ID 3494 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUatomic_ld_glue:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_16_glue>><<P:Predicate_atomic_load_16_local_m0>>  =>  (DS_READ_U16:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3494,
      GIR_Done,
    // Label 730: @35464
    GIM_Try, /*On fail goto*//*Label 731*/ 35524, // Rule ID 3495 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (atomic_load:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_16>><<P:Predicate_atomic_load_16_local>>  =>  (DS_READ_U16_gfx9:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U16_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3495,
      GIR_Done,
    // Label 731: @35524
    GIM_Try, /*On fail goto*//*Label 732*/ 35584, // Rule ID 3496 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUatomic_ld_glue:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_32_glue>><<P:Predicate_atomic_load_32_local_m0>>  =>  (DS_READ_B32:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3496,
      GIR_Done,
    // Label 732: @35584
    GIM_Try, /*On fail goto*//*Label 733*/ 35644, // Rule ID 3497 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (atomic_load:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_32>><<P:Predicate_atomic_load_32_local>>  =>  (DS_READ_B32_gfx9:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3497,
      GIR_Done,
    // Label 733: @35644
    GIM_Try, /*On fail goto*//*Label 734*/ 35708, // Rule ID 3454 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_extload_glue>><<P:Predicate_extloadi8_glue>><<P:Predicate_extloadi8_local_m0>>  =>  (DS_READ_U8:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3454,
      GIR_Done,
    // Label 734: @35708
    GIM_Try, /*On fail goto*//*Label 735*/ 35772, // Rule ID 3466 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_extload_glue>><<P:Predicate_extloadi16_glue>><<P:Predicate_extloadi16_local_m0>>  =>  (DS_READ_U16:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3466,
      GIR_Done,
    // Label 735: @35772
    GIM_Try, /*On fail goto*//*Label 736*/ 35832, // Rule ID 3455 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8_local>>  =>  (DS_READ_U8_gfx9:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U8_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3455,
      GIR_Done,
    // Label 736: @35832
    GIM_Try, /*On fail goto*//*Label 737*/ 35892, // Rule ID 3467 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16_local>>  =>  (DS_READ_U16_gfx9:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U16_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3467,
      GIR_Done,
    // Label 737: @35892
    GIM_Try, /*On fail goto*//*Label 738*/ 35952, // Rule ID 3472 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>>  =>  (DS_READ_B32:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3472,
      GIR_Done,
    // Label 738: @35952
    GIM_Try, /*On fail goto*//*Label 739*/ 36012, // Rule ID 3474 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[f32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>>  =>  (DS_READ_B32:{ *:[f32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3474,
      GIR_Done,
    // Label 739: @36012
    GIM_Try, /*On fail goto*//*Label 740*/ 36068, // Rule ID 3473 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>>  =>  (DS_READ_B32_gfx9:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3473,
      GIR_Done,
    // Label 740: @36068
    GIM_Try, /*On fail goto*//*Label 741*/ 36124, // Rule ID 3475 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[f32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>>  =>  (DS_READ_B32_gfx9:{ *:[f32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3475,
      GIR_Done,
    // Label 741: @36124
    GIM_Try, /*On fail goto*//*Label 742*/ 36190, // Rule ID 1975 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (atomic_load:{ *:[i32] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_32>><<P:Predicate_atomic_load_32_global>>  =>  (GLOBAL_LOAD_DWORD_SADDR:{ *:[i32] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1975,
      GIR_Done,
    // Label 742: @36190
    GIM_Try, /*On fail goto*//*Label 743*/ 36256, // Rule ID 1847 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i32] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8_global>>  =>  (GLOBAL_LOAD_UBYTE_SADDR:{ *:[i32] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_UBYTE_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1847,
      GIR_Done,
    // Label 743: @36256
    GIM_Try, /*On fail goto*//*Label 744*/ 36322, // Rule ID 1875 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i32] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16_global>>  =>  (GLOBAL_LOAD_USHORT_SADDR:{ *:[i32] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_USHORT_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1875,
      GIR_Done,
    // Label 744: @36322
    GIM_Try, /*On fail goto*//*Label 745*/ 36384, // Rule ID 1883 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i32] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORD_SADDR:{ *:[i32] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1883,
      GIR_Done,
    // Label 745: @36384
    GIM_Try, /*On fail goto*//*Label 746*/ 36446, // Rule ID 1885 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[f32] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORD_SADDR:{ *:[f32] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1885,
      GIR_Done,
    // Label 746: @36446
    GIM_Try, /*On fail goto*//*Label 747*/ 36508, // Rule ID 1974 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (atomic_load:{ *:[i32] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_32>><<P:Predicate_atomic_load_32_global>>  =>  (GLOBAL_LOAD_DWORD:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1974,
      GIR_Done,
    // Label 747: @36508
    GIM_Try, /*On fail goto*//*Label 748*/ 36570, // Rule ID 1846 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i32] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8_global>>  =>  (GLOBAL_LOAD_UBYTE:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_UBYTE,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1846,
      GIR_Done,
    // Label 748: @36570
    GIM_Try, /*On fail goto*//*Label 749*/ 36632, // Rule ID 1874 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i32] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16_global>>  =>  (GLOBAL_LOAD_USHORT:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_USHORT,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1874,
      GIR_Done,
    // Label 749: @36632
    GIM_Try, /*On fail goto*//*Label 750*/ 36690, // Rule ID 1882 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i32] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORD:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1882,
      GIR_Done,
    // Label 750: @36690
    GIM_Try, /*On fail goto*//*Label 751*/ 36748, // Rule ID 1884 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[f32] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORD:{ *:[f32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1884,
      GIR_Done,
    // Label 751: @36748
    GIM_Try, /*On fail goto*//*Label 752*/ 36811, // Rule ID 1751 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (atomic_load:{ *:[i32] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_32>><<P:Predicate_atomic_load_32_flat>>  =>  (FLAT_LOAD_DWORD:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1751,
      GIR_Done,
    // Label 752: @36811
    GIM_Try, /*On fail goto*//*Label 753*/ 36874, // Rule ID 1740 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[i32] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8_flat>>  =>  (FLAT_LOAD_UBYTE:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_UBYTE,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1740,
      GIR_Done,
    // Label 753: @36874
    GIM_Try, /*On fail goto*//*Label 754*/ 36937, // Rule ID 1746 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[i32] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16_flat>>  =>  (FLAT_LOAD_USHORT:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_USHORT,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1746,
      GIR_Done,
    // Label 754: @36937
    GIM_Try, /*On fail goto*//*Label 755*/ 36996, // Rule ID 1755 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[i32] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_flat>>  =>  (FLAT_LOAD_DWORD:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1755,
      GIR_Done,
    // Label 755: @36996
    GIM_Try, /*On fail goto*//*Label 756*/ 37055, // Rule ID 1757 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[f32] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_flat>>  =>  (FLAT_LOAD_DWORD:{ *:[f32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1757,
      GIR_Done,
    // Label 756: @37055
    GIM_Reject,
    // Label 561: @37056
    GIM_Try, /*On fail goto*//*Label 757*/ 37129, // Rule ID 3610 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemoryAlignment, /*MI*/0, /*MMO*/0, /*MinAlign*/8,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>><<P:Predicate_load_align8_local_m0>>  =>  (DS_READ_B64:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3610,
      GIR_Done,
    // Label 757: @37129
    GIM_Try, /*On fail goto*//*Label 758*/ 37202, // Rule ID 3614 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemoryAlignment, /*MI*/0, /*MMO*/0, /*MinAlign*/8,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[f64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>><<P:Predicate_load_align8_local_m0>>  =>  (DS_READ_B64:{ *:[f64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3614,
      GIR_Done,
    // Label 758: @37202
    GIM_Try, /*On fail goto*//*Label 759*/ 37254, // Rule ID 1631 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
      // (ld:{ *:[i64] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1631,
      GIR_Done,
    // Label 759: @37254
    GIM_Try, /*On fail goto*//*Label 760*/ 37308, // Rule ID 1632 //
      GIM_CheckFeatures, GIFBS_isGFX7Only,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
      // (ld:{ *:[i64] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM_ci:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM_ci,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1632,
      GIR_Done,
    // Label 760: @37308
    GIM_Try, /*On fail goto*//*Label 761*/ 37360, // Rule ID 1633 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
      // (ld:{ *:[i64] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_SGPR:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_SGPR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1633,
      GIR_Done,
    // Label 761: @37360
    GIM_Try, /*On fail goto*//*Label 762*/ 37412, // Rule ID 1639 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
      // (ld:{ *:[f64] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[f64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1639,
      GIR_Done,
    // Label 762: @37412
    GIM_Try, /*On fail goto*//*Label 763*/ 37466, // Rule ID 1640 //
      GIM_CheckFeatures, GIFBS_isGFX7Only,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
      // (ld:{ *:[f64] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM_ci:{ *:[f64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM_ci,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1640,
      GIR_Done,
    // Label 763: @37466
    GIM_Try, /*On fail goto*//*Label 764*/ 37518, // Rule ID 1641 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
      // (ld:{ *:[f64] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_SGPR:{ *:[f64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_SGPR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1641,
      GIR_Done,
    // Label 764: @37518
    GIM_Try, /*On fail goto*//*Label 765*/ 37582, // Rule ID 3611 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAlignment, /*MI*/0, /*MMO*/0, /*MinAlign*/8,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>><<P:Predicate_load_align8_local>>  =>  (DS_READ_B64_gfx9:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3611,
      GIR_Done,
    // Label 765: @37582
    GIM_Try, /*On fail goto*//*Label 766*/ 37646, // Rule ID 3615 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAlignment, /*MI*/0, /*MMO*/0, /*MinAlign*/8,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[f64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>><<P:Predicate_load_align8_local>>  =>  (DS_READ_B64_gfx9:{ *:[f64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3615,
      GIR_Done,
    // Label 766: @37646
    GIM_Try, /*On fail goto*//*Label 767*/ 37696, // Rule ID 1634 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      // (ld:{ *:[i64] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i64] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1634,
      GIR_Done,
    // Label 767: @37696
    GIM_Try, /*On fail goto*//*Label 768*/ 37746, // Rule ID 1642 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      // (ld:{ *:[f64] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[f64] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1642,
      GIR_Done,
    // Label 768: @37746
    GIM_Try, /*On fail goto*//*Label 769*/ 37802, // Rule ID 2140 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i64] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORDX2_SADDR:{ *:[i64] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORDX2_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2140,
      GIR_Done,
    // Label 769: @37802
    GIM_Try, /*On fail goto*//*Label 770*/ 37858, // Rule ID 2144 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[f64] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORDX2_SADDR:{ *:[f64] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORDX2_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2144,
      GIR_Done,
    // Label 770: @37858
    GIM_Try, /*On fail goto*//*Label 771*/ 37914, // Rule ID 2139 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i64] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2139,
      GIR_Done,
    // Label 771: @37914
    GIM_Try, /*On fail goto*//*Label 772*/ 37970, // Rule ID 2143 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[f64] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORDX2:{ *:[f64] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2143,
      GIR_Done,
    // Label 772: @37970
    GIM_Try, /*On fail goto*//*Label 773*/ 38046, // Rule ID 2721 //
      GIM_CheckFeatures, GIFBS_isGFX6GFX7,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_addr64,
      // (atomic_load:{ *:[i64] } (MUBUFAddr64:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i64:{ *:[i64] }:$vaddr, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_64>><<P:Predicate_atomic_load_64_global>>  =>  (BUFFER_LOAD_DWORDX2_ADDR64:{ *:[i64] } ?:{ *:[i64] }:$vaddr, ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORDX2_ADDR64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2721,
      GIR_Done,
    // Label 773: @38046
    GIM_Try, /*On fail goto*//*Label 774*/ 38110, // Rule ID 3550 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init_isGFX7Plus,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_64bit_4byte_aligned,
      // (AMDGPUld_glue:{ *:[i64] } (DS64Bit4ByteAligned:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i8:{ *:[i8] }:$offset0, i8:{ *:[i8] }:$offset1))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>>  =>  (DS_READ2_B32:{ *:[i64] } ?:{ *:[i32] }:$ptr, ?:{ *:[i8] }:$offset0, ?:{ *:[i8] }:$offset1, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ2_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3550,
      GIR_Done,
    // Label 774: @38110
    GIM_Try, /*On fail goto*//*Label 775*/ 38174, // Rule ID 3558 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init_isGFX7Plus,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_64bit_4byte_aligned,
      // (AMDGPUld_glue:{ *:[f64] } (DS64Bit4ByteAligned:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i8:{ *:[i8] }:$offset0, i8:{ *:[i8] }:$offset1))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>>  =>  (DS_READ2_B32:{ *:[f64] } ?:{ *:[i32] }:$ptr, ?:{ *:[i8] }:$offset0, ?:{ *:[i8] }:$offset1, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ2_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3558,
      GIR_Done,
    // Label 775: @38174
    GIM_Try, /*On fail goto*//*Label 776*/ 38234, // Rule ID 3552 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_64bit_4byte_aligned,
      // (ld:{ *:[i64] } (DS64Bit4ByteAligned:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i8:{ *:[i8] }:$offset0, i8:{ *:[i8] }:$offset1))<<P:Predicate_unindexedload>><<P:Predicate_load_local>>  =>  (DS_READ2_B32_gfx9:{ *:[i64] } ?:{ *:[i32] }:$ptr, ?:{ *:[i8] }:$offset0, ?:{ *:[i8] }:$offset1, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ2_B32_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3552,
      GIR_Done,
    // Label 776: @38234
    GIM_Try, /*On fail goto*//*Label 777*/ 38294, // Rule ID 3560 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_64bit_4byte_aligned,
      // (ld:{ *:[f64] } (DS64Bit4ByteAligned:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i8:{ *:[i8] }:$offset0, i8:{ *:[i8] }:$offset1))<<P:Predicate_unindexedload>><<P:Predicate_load_local>>  =>  (DS_READ2_B32_gfx9:{ *:[f64] } ?:{ *:[i32] }:$ptr, ?:{ *:[i8] }:$offset0, ?:{ *:[i8] }:$offset1, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ2_B32_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3560,
      GIR_Done,
    // Label 777: @38294
    GIM_Try, /*On fail goto*//*Label 778*/ 38354, // Rule ID 3498 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUatomic_ld_glue:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_64_glue>><<P:Predicate_atomic_load_64_local_m0>>  =>  (DS_READ_B64:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3498,
      GIR_Done,
    // Label 778: @38354
    GIM_Try, /*On fail goto*//*Label 779*/ 38414, // Rule ID 3499 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (atomic_load:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_64>><<P:Predicate_atomic_load_64_local>>  =>  (DS_READ_B64_gfx9:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3499,
      GIR_Done,
    // Label 779: @38414
    GIM_Try, /*On fail goto*//*Label 780*/ 38466, // Rule ID 3781 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
      // (ld:{ *:[i64] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3781,
      GIR_Done,
    // Label 780: @38466
    GIM_Try, /*On fail goto*//*Label 781*/ 38520, // Rule ID 3782 //
      GIM_CheckFeatures, GIFBS_isGFX7Only,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
      // (ld:{ *:[i64] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM_ci:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM_ci,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3782,
      GIR_Done,
    // Label 781: @38520
    GIM_Try, /*On fail goto*//*Label 782*/ 38572, // Rule ID 3783 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
      // (ld:{ *:[i64] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_SGPR:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_SGPR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3783,
      GIR_Done,
    // Label 782: @38572
    GIM_Try, /*On fail goto*//*Label 783*/ 38638, // Rule ID 1977 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (atomic_load:{ *:[i64] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_64>><<P:Predicate_atomic_load_64_global>>  =>  (GLOBAL_LOAD_DWORDX2_SADDR:{ *:[i64] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORDX2_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1977,
      GIR_Done,
    // Label 783: @38638
    GIM_Try, /*On fail goto*//*Label 784*/ 38700, // Rule ID 1913 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i64] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORDX2_SADDR:{ *:[i64] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORDX2_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1913,
      GIR_Done,
    // Label 784: @38700
    GIM_Try, /*On fail goto*//*Label 785*/ 38762, // Rule ID 1917 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[f64] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORDX2_SADDR:{ *:[f64] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORDX2_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1917,
      GIR_Done,
    // Label 785: @38762
    GIM_Try, /*On fail goto*//*Label 786*/ 38824, // Rule ID 1976 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (atomic_load:{ *:[i64] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_64>><<P:Predicate_atomic_load_64_global>>  =>  (GLOBAL_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1976,
      GIR_Done,
    // Label 786: @38824
    GIM_Try, /*On fail goto*//*Label 787*/ 38882, // Rule ID 1912 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i64] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1912,
      GIR_Done,
    // Label 787: @38882
    GIM_Try, /*On fail goto*//*Label 788*/ 38940, // Rule ID 1916 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[f64] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORDX2:{ *:[f64] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1916,
      GIR_Done,
    // Label 788: @38940
    GIM_Try, /*On fail goto*//*Label 789*/ 38990, // Rule ID 3784 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      // (ld:{ *:[i64] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i64] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3784,
      GIR_Done,
    // Label 789: @38990
    GIM_Try, /*On fail goto*//*Label 790*/ 39053, // Rule ID 1752 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (atomic_load:{ *:[i64] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_64>><<P:Predicate_atomic_load_64_flat>>  =>  (FLAT_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOpera