/* puzzle-generator.c generated by valac 0.56.16, the Vala compiler
 * generated from puzzle-generator.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* Puzzle generation logic:*/
/* We want to measure a puzzle's difficulty by the number of button presses*/
/* needed to solve it, and have that increase in a controlled manner.*/
/**/
/* Lights Off can be seen as a linear algebra problem over the field GF(2).*/
/* (See e.g. the first page of "Turning Lights Out with Linear Algebra".)*/
/* The linear map from button-press strategies to light configurations*/
/* will in general have a nullspace (of dimension n).*/
/* Thus, any solvable puzzle has 2^n solutions, given by a fixed solution*/
/* plus an element of the nullspace.*/
/* A solution is thus optimal if it presses at most half the buttons*/
/* which make up any element of the nullspace.*/
/**/
/* A basis for the nullspace splits the board into (up to) 2^n regions,*/
/* defined by which basic nullspace elements include a given button.*/
/* (This determines which nullspace elements include the same button.)*/
/* Thus, a solution is optimal if it includes at most half the buttons in any*/
/* region (except the region lying outside all null-sets).*/
/* The converse is not true, but (at least if the regions are even-sized)*/
/* does hold for a large number of puzzles up to the highest difficulty level.*/
/* (Certainly, on average, at most half the lights which belong to at least*/
/* one null set may be used.)*/

#include <glib-object.h>
#include <glib.h>
#include <math.h>
#include <float.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PUZZLE_GENERATOR (puzzle_generator_get_type ())
#define PUZZLE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_GENERATOR, PuzzleGenerator))
#define PUZZLE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_GENERATOR, PuzzleGeneratorClass))
#define IS_PUZZLE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_GENERATOR))
#define IS_PUZZLE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_GENERATOR))
#define PUZZLE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_GENERATOR, PuzzleGeneratorClass))

typedef struct _PuzzleGenerator PuzzleGenerator;
typedef struct _PuzzleGeneratorClass PuzzleGeneratorClass;
typedef struct _PuzzleGeneratorPrivate PuzzleGeneratorPrivate;
enum  {
	PUZZLE_GENERATOR_0_PROPERTY,
	PUZZLE_GENERATOR_NUM_PROPERTIES
};
static GParamSpec* puzzle_generator_properties[PUZZLE_GENERATOR_NUM_PROPERTIES];

struct _PuzzleGenerator {
	GObject parent_instance;
	PuzzleGeneratorPrivate * priv;
};

struct _PuzzleGeneratorClass {
	GObjectClass parent_class;
};

struct _PuzzleGeneratorPrivate {
	gint size;
	gint max_solution_length;
	gint* region_of;
	gint region_of_length1;
	gint _region_of_size_;
	gint* region_size;
	gint region_size_length1;
	gint _region_size_size_;
};

static gint PuzzleGenerator_private_offset;
static gpointer puzzle_generator_parent_class = NULL;

VALA_EXTERN GType puzzle_generator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PuzzleGenerator, g_object_unref)
VALA_EXTERN PuzzleGenerator* puzzle_generator_new (gint size);
VALA_EXTERN PuzzleGenerator* puzzle_generator_construct (GType object_type,
                                             gint size);
VALA_EXTERN gboolean* puzzle_generator_minimal_solution (PuzzleGenerator* self,
                                             gint solution_length,
                                             gint* result_length1,
                                             gint* result_length2);
static void puzzle_generator_finalize (GObject * obj);
static GType puzzle_generator_get_type_once (void);

static inline gpointer
puzzle_generator_get_instance_private (PuzzleGenerator* self)
{
	return G_STRUCT_MEMBER_P (self, PuzzleGenerator_private_offset);
}

PuzzleGenerator*
puzzle_generator_construct (GType object_type,
                            gint size)
{
	PuzzleGenerator * self = NULL;
	gint* adj_matrix = NULL;
	gint* _tmp0_;
	gint adj_matrix_length1;
	gint adj_matrix_length2;
	GList* non_pivot_cols = NULL;
	gint ipiv = 0;
	gint* basis_for_ns = NULL;
	GList* _tmp35_;
	gint* _tmp36_;
	gint basis_for_ns_length1;
	gint basis_for_ns_length2;
	gint n = 0;
	GList* _tmp37_;
	GList* _tmp56_;
	gint* _tmp57_;
	gint* _tmp62_;
	gint* _tmp76_;
	gint _tmp76__length1;
	gint _tmp77_;
	self = (PuzzleGenerator*) g_object_new (object_type, NULL);
	self->priv->size = size;
	_tmp0_ = g_new0 (gint, (size * size) * (size * size));
	adj_matrix = _tmp0_;
	adj_matrix_length1 = size * size;
	adj_matrix_length2 = size * size;
	{
		gint x0 = 0;
		x0 = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = x0;
					x0 = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(x0 < size)) {
					break;
				}
				{
					gint y0 = 0;
					y0 = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = y0;
								y0 = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							if (!(y0 < size)) {
								break;
							}
							{
								gint x1 = 0;
								x1 = 0;
								{
									gboolean _tmp5_ = FALSE;
									_tmp5_ = TRUE;
									while (TRUE) {
										if (!_tmp5_) {
											gint _tmp6_;
											_tmp6_ = x1;
											x1 = _tmp6_ + 1;
										}
										_tmp5_ = FALSE;
										if (!(x1 < size)) {
											break;
										}
										{
											gint y1 = 0;
											y1 = 0;
											{
												gboolean _tmp7_ = FALSE;
												_tmp7_ = TRUE;
												while (TRUE) {
													gint dx = 0;
													gint dy = 0;
													gint _tmp9_ = 0;
													gint* _tmp10_;
													gint _tmp10__length1;
													gint _tmp10__length2;
													if (!_tmp7_) {
														gint _tmp8_;
														_tmp8_ = y1;
														y1 = _tmp8_ + 1;
													}
													_tmp7_ = FALSE;
													if (!(y1 < size)) {
														break;
													}
													dx = x0 - x1;
													dy = y0 - y1;
													if (((dx * dx) + (dy * dy)) <= 1) {
														_tmp9_ = 1;
													} else {
														_tmp9_ = 0;
													}
													_tmp10_ = adj_matrix;
													_tmp10__length1 = adj_matrix_length1;
													_tmp10__length2 = adj_matrix_length2;
													_tmp10_[(((x0 * size) + y0) * _tmp10__length2) + ((x1 * size) + y1)] = _tmp9_;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	non_pivot_cols = NULL;
	ipiv = 0;
	{
		gint jpiv = 0;
		jpiv = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gboolean is_pivot_col = FALSE;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = jpiv;
					jpiv = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				if (!(jpiv < (size * size))) {
					break;
				}
				is_pivot_col = FALSE;
				{
					gint i = 0;
					i = ipiv;
					{
						gboolean _tmp13_ = FALSE;
						_tmp13_ = TRUE;
						while (TRUE) {
							gint* _tmp15_;
							gint _tmp15__length1;
							gint _tmp15__length2;
							gint _tmp16_;
							if (!_tmp13_) {
								gint _tmp14_;
								_tmp14_ = i;
								i = _tmp14_ + 1;
							}
							_tmp13_ = FALSE;
							if (!(i < (size * size))) {
								break;
							}
							_tmp15_ = adj_matrix;
							_tmp15__length1 = adj_matrix_length1;
							_tmp15__length2 = adj_matrix_length2;
							_tmp16_ = _tmp15_[(i * _tmp15__length2) + jpiv];
							if (_tmp16_ != 0) {
								gint _tmp34_;
								if (i != ipiv) {
									{
										gint z = 0;
										z = 0;
										{
											gboolean _tmp17_ = FALSE;
											_tmp17_ = TRUE;
											while (TRUE) {
												gint t = 0;
												gint* _tmp19_;
												gint _tmp19__length1;
												gint _tmp19__length2;
												gint _tmp20_;
												gint* _tmp21_;
												gint _tmp21__length1;
												gint _tmp21__length2;
												gint* _tmp22_;
												gint _tmp22__length1;
												gint _tmp22__length2;
												gint _tmp23_;
												gint* _tmp24_;
												gint _tmp24__length1;
												gint _tmp24__length2;
												if (!_tmp17_) {
													gint _tmp18_;
													_tmp18_ = z;
													z = _tmp18_ + 1;
												}
												_tmp17_ = FALSE;
												if (!(z < (size * size))) {
													break;
												}
												_tmp19_ = adj_matrix;
												_tmp19__length1 = adj_matrix_length1;
												_tmp19__length2 = adj_matrix_length2;
												_tmp20_ = _tmp19_[(i * _tmp19__length2) + z];
												t = _tmp20_;
												_tmp21_ = adj_matrix;
												_tmp21__length1 = adj_matrix_length1;
												_tmp21__length2 = adj_matrix_length2;
												_tmp22_ = adj_matrix;
												_tmp22__length1 = adj_matrix_length1;
												_tmp22__length2 = adj_matrix_length2;
												_tmp23_ = _tmp22_[(ipiv * _tmp22__length2) + z];
												_tmp21_[(i * _tmp21__length2) + z] = _tmp23_;
												_tmp24_ = adj_matrix;
												_tmp24__length1 = adj_matrix_length1;
												_tmp24__length2 = adj_matrix_length2;
												_tmp24_[(ipiv * _tmp24__length2) + z] = t;
											}
										}
									}
								}
								{
									gint j = 0;
									j = ipiv + 1;
									{
										gboolean _tmp25_ = FALSE;
										_tmp25_ = TRUE;
										while (TRUE) {
											gint* _tmp27_;
											gint _tmp27__length1;
											gint _tmp27__length2;
											gint _tmp28_;
											if (!_tmp25_) {
												gint _tmp26_;
												_tmp26_ = j;
												j = _tmp26_ + 1;
											}
											_tmp25_ = FALSE;
											if (!(j < (size * size))) {
												break;
											}
											_tmp27_ = adj_matrix;
											_tmp27__length1 = adj_matrix_length1;
											_tmp27__length2 = adj_matrix_length2;
											_tmp28_ = _tmp27_[(j * _tmp27__length2) + jpiv];
											if (_tmp28_ != 0) {
												{
													gint k = 0;
													k = 0;
													{
														gboolean _tmp29_ = FALSE;
														_tmp29_ = TRUE;
														while (TRUE) {
															gint* _tmp31_;
															gint _tmp31__length1;
															gint _tmp31__length2;
															gint* _tmp32_;
															gint _tmp32__length1;
															gint _tmp32__length2;
															gint _tmp33_;
															if (!_tmp29_) {
																gint _tmp30_;
																_tmp30_ = k;
																k = _tmp30_ + 1;
															}
															_tmp29_ = FALSE;
															if (!(k < (size * size))) {
																break;
															}
															_tmp31_ = adj_matrix;
															_tmp31__length1 = adj_matrix_length1;
															_tmp31__length2 = adj_matrix_length2;
															_tmp32_ = adj_matrix;
															_tmp32__length1 = adj_matrix_length1;
															_tmp32__length2 = adj_matrix_length2;
															_tmp33_ = _tmp32_[(ipiv * _tmp32__length2) + k];
															_tmp31_[(j * _tmp31__length2) + k] ^= _tmp33_;
														}
													}
												}
											}
										}
									}
								}
								is_pivot_col = TRUE;
								_tmp34_ = ipiv;
								ipiv = _tmp34_ + 1;
								break;
							}
						}
					}
				}
				if (!is_pivot_col) {
					non_pivot_cols = g_list_append (non_pivot_cols, (gpointer) ((gintptr) jpiv));
				}
			}
		}
	}
	_tmp35_ = non_pivot_cols;
	_tmp36_ = g_new0 (gint, g_list_length (_tmp35_) * (size * size));
	basis_for_ns = _tmp36_;
	basis_for_ns_length1 = g_list_length (_tmp35_);
	basis_for_ns_length2 = size * size;
	n = 0;
	_tmp37_ = non_pivot_cols;
	{
		GList* col_collection = NULL;
		GList* col_it = NULL;
		col_collection = _tmp37_;
		for (col_it = col_collection; col_it != NULL; col_it = col_it->next) {
			gint col = 0;
			col = (gint) ((gintptr) col_it->data);
			{
				gint* _tmp41_;
				gint _tmp41__length1;
				gint _tmp41__length2;
				gint _tmp55_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp38_ = FALSE;
						_tmp38_ = TRUE;
						while (TRUE) {
							gint* _tmp40_;
							gint _tmp40__length1;
							gint _tmp40__length2;
							if (!_tmp38_) {
								gint _tmp39_;
								_tmp39_ = j;
								j = _tmp39_ + 1;
							}
							_tmp38_ = FALSE;
							if (!(j < (size * size))) {
								break;
							}
							_tmp40_ = basis_for_ns;
							_tmp40__length1 = basis_for_ns_length1;
							_tmp40__length2 = basis_for_ns_length2;
							_tmp40_[(n * _tmp40__length2) + j] = 0;
						}
					}
				}
				_tmp41_ = basis_for_ns;
				_tmp41__length1 = basis_for_ns_length1;
				_tmp41__length2 = basis_for_ns_length2;
				_tmp41_[(n * _tmp41__length2) + col] = 1;
				{
					gint i = 0;
					i = (size * size) - 1;
					{
						gboolean _tmp42_ = FALSE;
						_tmp42_ = TRUE;
						while (TRUE) {
							gint jpiv = 0;
							if (!_tmp42_) {
								gint _tmp43_;
								_tmp43_ = i;
								i = _tmp43_ - 1;
							}
							_tmp42_ = FALSE;
							if (!(i >= 0)) {
								break;
							}
							jpiv = 0;
							{
								gboolean _tmp44_ = FALSE;
								_tmp44_ = TRUE;
								while (TRUE) {
									gint* _tmp46_;
									gint _tmp46__length1;
									gint _tmp46__length2;
									gint _tmp47_;
									if (!_tmp44_) {
										gint _tmp45_;
										_tmp45_ = jpiv;
										jpiv = _tmp45_ + 1;
									}
									_tmp44_ = FALSE;
									if (!(jpiv < (size * size))) {
										break;
									}
									_tmp46_ = adj_matrix;
									_tmp46__length1 = adj_matrix_length1;
									_tmp46__length2 = adj_matrix_length2;
									_tmp47_ = _tmp46_[(i * _tmp46__length2) + jpiv];
									if (_tmp47_ != 0) {
										break;
									}
								}
							}
							if (jpiv == (size * size)) {
								continue;
							}
							{
								gint j = 0;
								j = jpiv + 1;
								{
									gboolean _tmp48_ = FALSE;
									_tmp48_ = TRUE;
									while (TRUE) {
										gint* _tmp50_;
										gint _tmp50__length1;
										gint _tmp50__length2;
										gint* _tmp51_;
										gint _tmp51__length1;
										gint _tmp51__length2;
										gint _tmp52_;
										gint* _tmp53_;
										gint _tmp53__length1;
										gint _tmp53__length2;
										gint _tmp54_;
										if (!_tmp48_) {
											gint _tmp49_;
											_tmp49_ = j;
											j = _tmp49_ + 1;
										}
										_tmp48_ = FALSE;
										if (!(j < (size * size))) {
											break;
										}
										_tmp50_ = basis_for_ns;
										_tmp50__length1 = basis_for_ns_length1;
										_tmp50__length2 = basis_for_ns_length2;
										_tmp51_ = adj_matrix;
										_tmp51__length1 = adj_matrix_length1;
										_tmp51__length2 = adj_matrix_length2;
										_tmp52_ = _tmp51_[(i * _tmp51__length2) + j];
										_tmp53_ = basis_for_ns;
										_tmp53__length1 = basis_for_ns_length1;
										_tmp53__length2 = basis_for_ns_length2;
										_tmp54_ = _tmp53_[(n * _tmp53__length2) + j];
										_tmp50_[(n * _tmp50__length2) + jpiv] ^= _tmp52_ * _tmp54_;
									}
								}
							}
						}
					}
				}
				_tmp55_ = n;
				n = _tmp55_ + 1;
			}
		}
	}
	_tmp56_ = non_pivot_cols;
	_tmp57_ = g_new0 (gint, 1 << g_list_length (_tmp56_));
	self->priv->region_size = (g_free (self->priv->region_size), NULL);
	self->priv->region_size = _tmp57_;
	self->priv->region_size_length1 = 1 << g_list_length (_tmp56_);
	self->priv->_region_size_size_ = self->priv->region_size_length1;
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp58_ = FALSE;
			_tmp58_ = TRUE;
			while (TRUE) {
				gint* _tmp60_;
				gint _tmp60__length1;
				gint* _tmp61_;
				gint _tmp61__length1;
				if (!_tmp58_) {
					gint _tmp59_;
					_tmp59_ = j;
					j = _tmp59_ + 1;
				}
				_tmp58_ = FALSE;
				_tmp60_ = self->priv->region_size;
				_tmp60__length1 = self->priv->region_size_length1;
				if (!(j < _tmp60__length1)) {
					break;
				}
				_tmp61_ = self->priv->region_size;
				_tmp61__length1 = self->priv->region_size_length1;
				_tmp61_[j] = 0;
			}
		}
	}
	_tmp62_ = g_new0 (gint, size * size);
	self->priv->region_of = (g_free (self->priv->region_of), NULL);
	self->priv->region_of = _tmp62_;
	self->priv->region_of_length1 = size * size;
	self->priv->_region_of_size_ = self->priv->region_of_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp63_ = FALSE;
			_tmp63_ = TRUE;
			while (TRUE) {
				gint* _tmp65_;
				gint _tmp65__length1;
				gint* _tmp72_;
				gint _tmp72__length1;
				gint* _tmp73_;
				gint _tmp73__length1;
				gint _tmp74_;
				gint _tmp75_;
				if (!_tmp63_) {
					gint _tmp64_;
					_tmp64_ = i;
					i = _tmp64_ + 1;
				}
				_tmp63_ = FALSE;
				if (!(i < (size * size))) {
					break;
				}
				_tmp65_ = self->priv->region_of;
				_tmp65__length1 = self->priv->region_of_length1;
				_tmp65_[i] = 0;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp66_ = FALSE;
						_tmp66_ = TRUE;
						while (TRUE) {
							GList* _tmp68_;
							gint* _tmp69_;
							gint _tmp69__length1;
							gint _tmp69__length2;
							gint _tmp70_;
							if (!_tmp66_) {
								gint _tmp67_;
								_tmp67_ = j;
								j = _tmp67_ + 1;
							}
							_tmp66_ = FALSE;
							_tmp68_ = non_pivot_cols;
							if (!(((guint) j) < g_list_length (_tmp68_))) {
								break;
							}
							_tmp69_ = basis_for_ns;
							_tmp69__length1 = basis_for_ns_length1;
							_tmp69__length2 = basis_for_ns_length2;
							_tmp70_ = _tmp69_[(j * _tmp69__length2) + i];
							if (_tmp70_ != 0) {
								gint* _tmp71_;
								gint _tmp71__length1;
								_tmp71_ = self->priv->region_of;
								_tmp71__length1 = self->priv->region_of_length1;
								_tmp71_[i] += 1 << j;
							}
						}
					}
				}
				_tmp72_ = self->priv->region_size;
				_tmp72__length1 = self->priv->region_size_length1;
				_tmp73_ = self->priv->region_of;
				_tmp73__length1 = self->priv->region_of_length1;
				_tmp74_ = _tmp73_[i];
				_tmp75_ = _tmp72_[_tmp74_];
				_tmp72_[_tmp74_] = _tmp75_ + 1;
			}
		}
	}
	_tmp76_ = self->priv->region_size;
	_tmp76__length1 = self->priv->region_size_length1;
	_tmp77_ = _tmp76_[0];
	self->priv->max_solution_length = _tmp77_;
	{
		gint j = 0;
		j = 1;
		{
			gboolean _tmp78_ = FALSE;
			_tmp78_ = TRUE;
			while (TRUE) {
				gint* _tmp80_;
				gint _tmp80__length1;
				gint* _tmp81_;
				gint _tmp81__length1;
				gint _tmp82_;
				if (!_tmp78_) {
					gint _tmp79_;
					_tmp79_ = j;
					j = _tmp79_ + 1;
				}
				_tmp78_ = FALSE;
				_tmp80_ = self->priv->region_size;
				_tmp80__length1 = self->priv->region_size_length1;
				if (!(j < _tmp80__length1)) {
					break;
				}
				_tmp81_ = self->priv->region_size;
				_tmp81__length1 = self->priv->region_size_length1;
				_tmp82_ = _tmp81_[j];
				self->priv->max_solution_length = self->priv->max_solution_length + ((gint) floor ((gdouble) (_tmp82_ / 2)));
			}
		}
	}
	basis_for_ns = (g_free (basis_for_ns), NULL);
	(non_pivot_cols == NULL) ? NULL : (non_pivot_cols = (g_list_free (non_pivot_cols), NULL));
	adj_matrix = (g_free (adj_matrix), NULL);
	return self;
}

PuzzleGenerator*
puzzle_generator_new (gint size)
{
	return puzzle_generator_construct (TYPE_PUZZLE_GENERATOR, size);
}

gboolean*
puzzle_generator_minimal_solution (PuzzleGenerator* self,
                                   gint solution_length,
                                   gint* result_length1,
                                   gint* result_length2)
{
	gboolean* sol = NULL;
	gboolean* _tmp0_;
	gint sol_length1;
	gint sol_length2;
	gint* presses_in_region = NULL;
	gint* _tmp6_;
	gint _tmp6__length1;
	gint* _tmp7_;
	gint presses_in_region_length1;
	gint _presses_in_region_size_;
	gint sym = 0;
	gint presses_left = 0;
	gboolean* _tmp39_;
	gint _tmp39__length1;
	gint _tmp39__length2;
	gboolean* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gboolean, self->priv->size * self->priv->size);
	sol = _tmp0_;
	sol_length1 = self->priv->size;
	sol_length2 = self->priv->size;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(x < self->priv->size)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gboolean* _tmp5_;
							gint _tmp5__length1;
							gint _tmp5__length2;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = y;
								y = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							if (!(y < self->priv->size)) {
								break;
							}
							_tmp5_ = sol;
							_tmp5__length1 = sol_length1;
							_tmp5__length2 = sol_length2;
							_tmp5_[(x * _tmp5__length2) + y] = FALSE;
						}
					}
				}
			}
		}
	}
	_tmp6_ = self->priv->region_size;
	_tmp6__length1 = self->priv->region_size_length1;
	_tmp7_ = g_new0 (gint, _tmp6__length1);
	presses_in_region = _tmp7_;
	presses_in_region_length1 = _tmp6__length1;
	_presses_in_region_size_ = presses_in_region_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint* _tmp10_;
				gint _tmp10__length1;
				gint* _tmp11_;
				gint _tmp11__length1;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = self->priv->region_size;
				_tmp10__length1 = self->priv->region_size_length1;
				if (!(i < _tmp10__length1)) {
					break;
				}
				_tmp11_ = presses_in_region;
				_tmp11__length1 = presses_in_region_length1;
				_tmp11_[i] = 0;
			}
		}
	}
	sym = (gint) floor (3 * g_random_double ());
	presses_left = MIN (solution_length, self->priv->max_solution_length);
	while (TRUE) {
		gint x[2] = {0};
		gint y[2] = {0};
		if (!(presses_left > 0)) {
			break;
		}
		x[0] = (gint) round ((self->priv->size - 1) * g_random_double ());
		y[0] = (gint) round ((self->priv->size - 1) * g_random_double ());
		if (sym == 0) {
			gint _tmp12_;
			gint _tmp13_;
			_tmp12_ = x[0];
			x[1] = (self->priv->size - 1) - _tmp12_;
			_tmp13_ = y[0];
			y[1] = _tmp13_;
		} else {
			if (sym == 1) {
				gint _tmp14_;
				gint _tmp15_;
				_tmp14_ = x[0];
				x[1] = (self->priv->size - 1) - _tmp14_;
				_tmp15_ = y[0];
				y[1] = (self->priv->size - 1) - _tmp15_;
			} else {
				gint _tmp16_;
				gint _tmp17_;
				_tmp16_ = x[0];
				x[1] = _tmp16_;
				_tmp17_ = y[0];
				y[1] = (self->priv->size - 1) - _tmp17_;
			}
		}
		{
			gint k = 0;
			k = 0;
			{
				gboolean _tmp18_ = FALSE;
				_tmp18_ = TRUE;
				while (TRUE) {
					gint r = 0;
					gint* _tmp20_;
					gint _tmp20__length1;
					gint _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					gboolean _tmp24_ = FALSE;
					if (!_tmp18_) {
						gint _tmp19_;
						_tmp19_ = k;
						k = _tmp19_ + 1;
					}
					_tmp18_ = FALSE;
					if (!(k < 2)) {
						break;
					}
					_tmp20_ = self->priv->region_of;
					_tmp20__length1 = self->priv->region_of_length1;
					_tmp21_ = x[k];
					_tmp22_ = y[k];
					_tmp23_ = _tmp20_[(_tmp21_ * self->priv->size) + _tmp22_];
					r = _tmp23_;
					if (r == 0) {
						_tmp24_ = TRUE;
					} else {
						gint* _tmp25_;
						gint _tmp25__length1;
						gint _tmp26_;
						gint* _tmp27_;
						gint _tmp27__length1;
						gint _tmp28_;
						_tmp25_ = presses_in_region;
						_tmp25__length1 = presses_in_region_length1;
						_tmp26_ = _tmp25_[r];
						_tmp27_ = self->priv->region_size;
						_tmp27__length1 = self->priv->region_size_length1;
						_tmp28_ = _tmp27_[r];
						_tmp24_ = (2 * (_tmp26_ + 1)) <= _tmp28_;
					}
					if (_tmp24_) {
						gboolean* _tmp29_;
						gint _tmp29__length1;
						gint _tmp29__length2;
						gint _tmp30_;
						gint _tmp31_;
						gboolean _tmp32_;
						gboolean* _tmp33_;
						gint _tmp33__length1;
						gint _tmp33__length2;
						gint _tmp34_;
						gint _tmp35_;
						gint* _tmp36_;
						gint _tmp36__length1;
						gint _tmp37_;
						gint _tmp38_;
						_tmp29_ = sol;
						_tmp29__length1 = sol_length1;
						_tmp29__length2 = sol_length2;
						_tmp30_ = x[k];
						_tmp31_ = y[k];
						_tmp32_ = _tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_];
						if (_tmp32_) {
							continue;
						}
						_tmp33_ = sol;
						_tmp33__length1 = sol_length1;
						_tmp33__length2 = sol_length2;
						_tmp34_ = x[k];
						_tmp35_ = y[k];
						_tmp33_[(_tmp34_ * _tmp33__length2) + _tmp35_] = TRUE;
						_tmp36_ = presses_in_region;
						_tmp36__length1 = presses_in_region_length1;
						_tmp37_ = _tmp36_[r];
						_tmp36_[r] = _tmp37_ + 1;
						_tmp38_ = presses_left;
						presses_left = _tmp38_ - 1;
					}
					if (presses_left == 0) {
						break;
					}
				}
			}
		}
	}
	_tmp39_ = sol;
	_tmp39__length1 = sol_length1;
	_tmp39__length2 = sol_length2;
	if (result_length1) {
		*result_length1 = _tmp39__length1;
	}
	if (result_length2) {
		*result_length2 = _tmp39__length2;
	}
	result = _tmp39_;
	presses_in_region = (g_free (presses_in_region), NULL);
	return result;
}

static void
puzzle_generator_class_init (PuzzleGeneratorClass * klass,
                             gpointer klass_data)
{
	puzzle_generator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PuzzleGenerator_private_offset);
	G_OBJECT_CLASS (klass)->finalize = puzzle_generator_finalize;
}

static void
puzzle_generator_instance_init (PuzzleGenerator * self,
                                gpointer klass)
{
	self->priv = puzzle_generator_get_instance_private (self);
}

static void
puzzle_generator_finalize (GObject * obj)
{
	PuzzleGenerator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PUZZLE_GENERATOR, PuzzleGenerator);
	self->priv->region_of = (g_free (self->priv->region_of), NULL);
	self->priv->region_size = (g_free (self->priv->region_size), NULL);
	G_OBJECT_CLASS (puzzle_generator_parent_class)->finalize (obj);
}

static GType
puzzle_generator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PuzzleGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) puzzle_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PuzzleGenerator), 0, (GInstanceInitFunc) puzzle_generator_instance_init, NULL };
	GType puzzle_generator_type_id;
	puzzle_generator_type_id = g_type_register_static (G_TYPE_OBJECT, "PuzzleGenerator", &g_define_type_info, 0);
	PuzzleGenerator_private_offset = g_type_add_instance_private (puzzle_generator_type_id, sizeof (PuzzleGeneratorPrivate));
	return puzzle_generator_type_id;
}

GType
puzzle_generator_get_type (void)
{
	static volatile gsize puzzle_generator_type_id__once = 0;
	if (g_once_init_enter (&puzzle_generator_type_id__once)) {
		GType puzzle_generator_type_id;
		puzzle_generator_type_id = puzzle_generator_get_type_once ();
		g_once_init_leave (&puzzle_generator_type_id__once, puzzle_generator_type_id);
	}
	return puzzle_generator_type_id__once;
}

