/* managed-window.c generated by valac 0.56.16, the Vala compiler
 * generated from managed-window.vala, do not modify */

/*
 * Copyright (C) 2020 Arnaud Bonatti
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <string.h>
#include <stdlib.h>

#define MANAGED_WINDOW_tiled_state ((((GDK_WINDOW_STATE_TILED | GDK_WINDOW_STATE_TOP_TILED) | GDK_WINDOW_STATE_BOTTOM_TILED) | GDK_WINDOW_STATE_LEFT_TILED) | GDK_WINDOW_STATE_RIGHT_TILED)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MANAGED_WINDOW (managed_window_get_type ())
#define MANAGED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MANAGED_WINDOW, ManagedWindow))
#define MANAGED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MANAGED_WINDOW, ManagedWindowClass))
#define IS_MANAGED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MANAGED_WINDOW))
#define IS_MANAGED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MANAGED_WINDOW))
#define MANAGED_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MANAGED_WINDOW, ManagedWindowClass))

typedef struct _ManagedWindow ManagedWindow;
typedef struct _ManagedWindowClass ManagedWindowClass;
typedef struct _ManagedWindowPrivate ManagedWindowPrivate;
typedef enum  {
	MANAGED_WINDOW_WINDOW_SIZE_START,
	MANAGED_WINDOW_WINDOW_SIZE_SMALL,
	MANAGED_WINDOW_WINDOW_SIZE_LARGE
} ManagedWindowWindowSize;

#define MANAGED_WINDOW_TYPE_WINDOW_SIZE (managed_window_window_size_get_type ())
enum  {
	MANAGED_WINDOW_0_PROPERTY,
	MANAGED_WINDOW_SCHEMA_PATH_PROPERTY,
	MANAGED_WINDOW_NUM_PROPERTIES
};
static GParamSpec* managed_window_properties[MANAGED_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

struct _ManagedWindow {
	GtkApplicationWindow parent_instance;
	ManagedWindowPrivate * priv;
};

struct _ManagedWindowClass {
	GtkApplicationWindowClass parent_class;
	void (*change_window_size) (ManagedWindow* self, gboolean large);
};

struct _ManagedWindowPrivate {
	gint window_width;
	gint window_height;
	gboolean window_is_maximized;
	gboolean window_is_fullscreen;
	gboolean window_is_tiled;
	ManagedWindowWindowSize window_size;
	GSettings* settings;
};

static gint ManagedWindow_private_offset;
static gpointer managed_window_parent_class = NULL;

VALA_EXTERN GType managed_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ManagedWindow, g_object_unref)
static GType managed_window_window_size_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN void managed_window_change_window_size (ManagedWindow* self,
                                        gboolean large);
static inline void managed_window_connect_callbacks (ManagedWindow* self);
static inline gboolean managed_window_on_window_state_event (ManagedWindow* self,
                                               GtkWidget* widget,
                                               GdkEventWindowState* event);
static gboolean _managed_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                              GdkEventWindowState* event,
                                                                              gpointer self);
static inline void managed_window_on_size_allocate (ManagedWindow* self,
                                      GtkAllocation* allocation);
static void _managed_window_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                GtkAllocation* allocation,
                                                                gpointer self);
static inline void managed_window_on_destroy (ManagedWindow* self);
static void _managed_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender,
                                                    gpointer self);
static gint* _int_dup (gint* self);
static void managed_window_update_adaptative_children (ManagedWindow* self);
static inline void managed_window_save_window_state (ManagedWindow* self);
static void _managed_window_change_window_size (ManagedWindow* self,
                                         ManagedWindowWindowSize new_window_size);
static void managed_window_real_change_window_size (ManagedWindow* self,
                                             gboolean large);
static inline void managed_window_load_window_state (ManagedWindow* self);
VALA_EXTERN ManagedWindow* managed_window_new (void);
VALA_EXTERN ManagedWindow* managed_window_construct (GType object_type);
static void managed_window_set_schema_path (ManagedWindow* self,
                                     const gchar* value);
static GObject * managed_window_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void managed_window_finalize (GObject * obj);
static GType managed_window_get_type_once (void);
static void _vala_managed_window_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);

static inline gpointer
managed_window_get_instance_private (ManagedWindow* self)
{
	return G_STRUCT_MEMBER_P (self, ManagedWindow_private_offset);
}

static GType
managed_window_window_size_get_type_once (void)
{
	static const GEnumValue values[] = {{MANAGED_WINDOW_WINDOW_SIZE_START, "MANAGED_WINDOW_WINDOW_SIZE_START", "start"}, {MANAGED_WINDOW_WINDOW_SIZE_SMALL, "MANAGED_WINDOW_WINDOW_SIZE_SMALL", "small"}, {MANAGED_WINDOW_WINDOW_SIZE_LARGE, "MANAGED_WINDOW_WINDOW_SIZE_LARGE", "large"}, {0, NULL, NULL}};
	GType managed_window_window_size_type_id;
	managed_window_window_size_type_id = g_enum_register_static ("ManagedWindowWindowSize", values);
	return managed_window_window_size_type_id;
}

static GType
managed_window_window_size_get_type (void)
{
	static volatile gsize managed_window_window_size_type_id__once = 0;
	if (g_once_init_enter (&managed_window_window_size_type_id__once)) {
		GType managed_window_window_size_type_id;
		managed_window_window_size_type_id = managed_window_window_size_get_type_once ();
		g_once_init_leave (&managed_window_window_size_type_id__once, managed_window_window_size_type_id);
	}
	return managed_window_window_size_type_id__once;
}

static gboolean
_managed_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                     GdkEventWindowState* event,
                                                                     gpointer self)
{
	gboolean result;
	result = managed_window_on_window_state_event ((ManagedWindow*) self, _sender, event);
	return result;
}

static void
_managed_window_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                           GtkAllocation* allocation,
                                                           gpointer self)
{
	managed_window_on_size_allocate ((ManagedWindow*) self, allocation);
}

static void
_managed_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender,
                                               gpointer self)
{
	managed_window_on_destroy ((ManagedWindow*) self);
}

static inline void
managed_window_connect_callbacks (ManagedWindow* self)
{
	g_return_if_fail (self != NULL);
	g_signal_connect_object ((GtkWidget*) self, "window-state-event", (GCallback) _managed_window_on_window_state_event_gtk_widget_window_state_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) _managed_window_on_size_allocate_gtk_widget_size_allocate, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "destroy", (GCallback) _managed_window_on_destroy_gtk_widget_destroy, self, 0);
}

static inline gboolean
managed_window_on_window_state_event (ManagedWindow* self,
                                      GtkWidget* widget,
                                      GdkEventWindowState* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if ((event->changed_mask & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		self->priv->window_is_maximized = (event->new_window_state & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	if ((event->changed_mask & GDK_WINDOW_STATE_FULLSCREEN) != 0) {
		self->priv->window_is_fullscreen = (event->new_window_state & GDK_WINDOW_STATE_FULLSCREEN) != 0;
	}
	if ((event->changed_mask & MANAGED_WINDOW_tiled_state) != 0) {
		self->priv->window_is_tiled = (event->new_window_state & MANAGED_WINDOW_tiled_state) != 0;
	}
	result = FALSE;
	return result;
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static inline void
managed_window_on_size_allocate (ManagedWindow* self,
                                 GtkAllocation* allocation)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint* _window_width = NULL;
	gint* _window_height = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_;
	gint* _tmp5_;
	gint _tmp6_;
	gint* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gint* _tmp9_;
	gint* _tmp11_;
	gint* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	if (self->priv->window_is_maximized) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->window_is_tiled;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->window_is_fullscreen;
	}
	if (_tmp0_) {
		return;
	}
	_window_width = NULL;
	_window_height = NULL;
	gtk_window_get_size ((GtkWindow*) self, &_tmp2_, &_tmp3_);
	_g_free0 (_window_width);
	_tmp4_ = _tmp2_;
	_tmp5_ = __int_dup0 (&_tmp4_);
	_window_width = _tmp5_;
	_g_free0 (_window_height);
	_tmp6_ = _tmp3_;
	_tmp7_ = __int_dup0 (&_tmp6_);
	_window_height = _tmp7_;
	_tmp9_ = _window_width;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		gint* _tmp10_;
		_tmp10_ = _window_height;
		_tmp8_ = _tmp10_ == NULL;
	}
	if (_tmp8_) {
		_g_free0 (_window_height);
		_g_free0 (_window_width);
		return;
	}
	_tmp11_ = _window_width;
	self->priv->window_width = (gint) (*_tmp11_);
	_tmp12_ = _window_height;
	self->priv->window_height = (gint) (*_tmp12_);
	managed_window_update_adaptative_children (self);
	_g_free0 (_window_height);
	_g_free0 (_window_width);
}

static inline void
managed_window_on_destroy (ManagedWindow* self)
{
	g_return_if_fail (self != NULL);
	managed_window_save_window_state (self);
	GTK_WIDGET_CLASS (managed_window_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow));
}

static void
managed_window_update_adaptative_children (ManagedWindow* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->window_width < 590) {
		_managed_window_change_window_size (self, MANAGED_WINDOW_WINDOW_SIZE_SMALL);
	} else {
		_managed_window_change_window_size (self, MANAGED_WINDOW_WINDOW_SIZE_LARGE);
	}
}

static void
_managed_window_change_window_size (ManagedWindow* self,
                                    ManagedWindowWindowSize new_window_size)
{
	g_return_if_fail (self != NULL);
	if (self->priv->window_size == new_window_size) {
		return;
	}
	self->priv->window_size = new_window_size;
	managed_window_change_window_size (self, self->priv->window_size == MANAGED_WINDOW_WINDOW_SIZE_LARGE);
}

static void
managed_window_real_change_window_size (ManagedWindow* self,
                                        gboolean large)
{
}

void
managed_window_change_window_size (ManagedWindow* self,
                                   gboolean large)
{
	ManagedWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = MANAGED_WINDOW_GET_CLASS (self);
	if (_klass_->change_window_size) {
		_klass_->change_window_size (self, large);
	}
}

static inline void
managed_window_load_window_state (ManagedWindow* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp0_, "window-is-maximized")) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	_tmp1_ = self->priv->settings;
	_tmp2_ = self->priv->settings;
	gtk_window_set_default_size ((GtkWindow*) self, g_settings_get_int (_tmp1_, "window-width"), g_settings_get_int (_tmp2_, "window-height"));
}

static inline void
managed_window_save_window_state (ManagedWindow* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	g_settings_delay (_tmp0_);
	_tmp1_ = self->priv->settings;
	g_settings_set_int (_tmp1_, "window-width", self->priv->window_width);
	_tmp2_ = self->priv->settings;
	g_settings_set_int (_tmp2_, "window-height", self->priv->window_height);
	if (self->priv->window_is_maximized) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = self->priv->window_is_fullscreen;
	}
	_tmp4_ = self->priv->settings;
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp3_);
	_tmp5_ = self->priv->settings;
	g_settings_apply (_tmp5_);
}

ManagedWindow*
managed_window_construct (GType object_type)
{
	ManagedWindow * self = NULL;
	self = (ManagedWindow*) g_object_new (object_type, NULL);
	return self;
}

ManagedWindow*
managed_window_new (void)
{
	return managed_window_construct (TYPE_MANAGED_WINDOW);
}

static void
managed_window_set_schema_path (ManagedWindow* self,
                                const gchar* value)
{
	gchar* _value = NULL;
	gchar* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_value = _tmp0_;
	if (_value == NULL) {
		g_assert_not_reached ();
	}
	_tmp1_ = g_settings_new_with_path ("org.gnome.LightsOff.Lib", value);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	_g_free0 (_value);
}

static GObject *
managed_window_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ManagedWindow * self;
	parent_class = G_OBJECT_CLASS (managed_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MANAGED_WINDOW, ManagedWindow);
	managed_window_connect_callbacks (self);
	managed_window_load_window_state (self);
	return obj;
}

static void
managed_window_class_init (ManagedWindowClass * klass,
                           gpointer klass_data)
{
	managed_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ManagedWindow_private_offset);
	((ManagedWindowClass *) klass)->change_window_size = (void (*) (ManagedWindow*, gboolean)) managed_window_real_change_window_size;
	G_OBJECT_CLASS (klass)->set_property = _vala_managed_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = managed_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = managed_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MANAGED_WINDOW_SCHEMA_PATH_PROPERTY, managed_window_properties[MANAGED_WINDOW_SCHEMA_PATH_PROPERTY] = g_param_spec_string ("schema-path", "schema-path", "schema-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
}

static void
managed_window_instance_init (ManagedWindow * self,
                              gpointer klass)
{
	self->priv = managed_window_get_instance_private (self);
	self->priv->window_width = 0;
	self->priv->window_height = 0;
	self->priv->window_is_maximized = FALSE;
	self->priv->window_is_fullscreen = FALSE;
	self->priv->window_is_tiled = FALSE;
	self->priv->window_size = MANAGED_WINDOW_WINDOW_SIZE_START;
}

static void
managed_window_finalize (GObject * obj)
{
	ManagedWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MANAGED_WINDOW, ManagedWindow);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (managed_window_parent_class)->finalize (obj);
}

static GType
managed_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ManagedWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) managed_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ManagedWindow), 0, (GInstanceInitFunc) managed_window_instance_init, NULL };
	GType managed_window_type_id;
	managed_window_type_id = g_type_register_static (gtk_application_window_get_type (), "ManagedWindow", &g_define_type_info, 0);
	ManagedWindow_private_offset = g_type_add_instance_private (managed_window_type_id, sizeof (ManagedWindowPrivate));
	return managed_window_type_id;
}

GType
managed_window_get_type (void)
{
	static volatile gsize managed_window_type_id__once = 0;
	if (g_once_init_enter (&managed_window_type_id__once)) {
		GType managed_window_type_id;
		managed_window_type_id = managed_window_get_type_once ();
		g_once_init_leave (&managed_window_type_id__once, managed_window_type_id);
	}
	return managed_window_type_id__once;
}

static void
_vala_managed_window_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	ManagedWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MANAGED_WINDOW, ManagedWindow);
	switch (property_id) {
		case MANAGED_WINDOW_SCHEMA_PATH_PROPERTY:
		managed_window_set_schema_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

