/* lightsoff-window.c generated by valac 0.56.16, the Vala compiler
 * generated from lightsoff-window.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2014 Michael Catanzaro
 * Copyright (C) 2016 Arnaud Bonatti
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MANAGED_WINDOW (managed_window_get_type ())
#define MANAGED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MANAGED_WINDOW, ManagedWindow))
#define MANAGED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MANAGED_WINDOW, ManagedWindowClass))
#define IS_MANAGED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MANAGED_WINDOW))
#define IS_MANAGED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MANAGED_WINDOW))
#define MANAGED_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MANAGED_WINDOW, ManagedWindowClass))

typedef struct _ManagedWindow ManagedWindow;
typedef struct _ManagedWindowClass ManagedWindowClass;
typedef struct _ManagedWindowPrivate ManagedWindowPrivate;

#define TYPE_LIGHTSOFF_WINDOW (lightsoff_window_get_type ())
#define LIGHTSOFF_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIGHTSOFF_WINDOW, LightsoffWindow))
#define LIGHTSOFF_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIGHTSOFF_WINDOW, LightsoffWindowClass))
#define IS_LIGHTSOFF_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIGHTSOFF_WINDOW))
#define IS_LIGHTSOFF_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIGHTSOFF_WINDOW))
#define LIGHTSOFF_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIGHTSOFF_WINDOW, LightsoffWindowClass))

typedef struct _LightsoffWindow LightsoffWindow;
typedef struct _LightsoffWindowClass LightsoffWindowClass;
typedef struct _LightsoffWindowPrivate LightsoffWindowPrivate;

#define TYPE_GAME_BUTTON (game_button_get_type ())
#define GAME_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_BUTTON, GameButton))
#define GAME_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_BUTTON, GameButtonClass))
#define IS_GAME_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_BUTTON))
#define IS_GAME_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_BUTTON))
#define GAME_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_BUTTON, GameButtonClass))

typedef struct _GameButton GameButton;
typedef struct _GameButtonClass GameButtonClass;

#define TYPE_NOTIFICATIONS_REVEALER (notifications_revealer_get_type ())
#define NOTIFICATIONS_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATIONS_REVEALER, NotificationsRevealer))
#define NOTIFICATIONS_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATIONS_REVEALER, NotificationsRevealerClass))
#define IS_NOTIFICATIONS_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATIONS_REVEALER))
#define IS_NOTIFICATIONS_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATIONS_REVEALER))
#define NOTIFICATIONS_REVEALER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATIONS_REVEALER, NotificationsRevealerClass))

typedef struct _NotificationsRevealer NotificationsRevealer;
typedef struct _NotificationsRevealerClass NotificationsRevealerClass;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_GAME_VIEW, GameViewIface))

typedef struct _GameView GameView;
typedef struct _GameViewIface GameViewIface;

#define TYPE_BOARD_VIEW (board_view_get_type ())
#define BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD_VIEW, BoardView))
#define IS_BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD_VIEW))
#define BOARD_VIEW_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_BOARD_VIEW, BoardViewIface))

typedef struct _BoardView BoardView;
typedef struct _BoardViewIface BoardViewIface;

#define TYPE_PUZZLE_GENERATOR (puzzle_generator_get_type ())
#define PUZZLE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_GENERATOR, PuzzleGenerator))
#define PUZZLE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_GENERATOR, PuzzleGeneratorClass))
#define IS_PUZZLE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_GENERATOR))
#define IS_PUZZLE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_GENERATOR))
#define PUZZLE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_GENERATOR, PuzzleGeneratorClass))

typedef struct _PuzzleGenerator PuzzleGenerator;
typedef struct _PuzzleGeneratorClass PuzzleGeneratorClass;
typedef enum  {
	GAME_VIEW_REPLACE_STYLE_REFRESH,
	GAME_VIEW_REPLACE_STYLE_RESTART,
	GAME_VIEW_REPLACE_STYLE_SLIDE_FORWARD,
	GAME_VIEW_REPLACE_STYLE_SLIDE_BACKWARD,
	GAME_VIEW_REPLACE_STYLE_SLIDE_NEXT
} GameViewReplaceStyle;

#define GAME_VIEW_TYPE_REPLACE_STYLE (game_view_replace_style_get_type ())
enum  {
	LIGHTSOFF_WINDOW_0_PROPERTY,
	LIGHTSOFF_WINDOW_NUM_PROPERTIES
};
static GParamSpec* lightsoff_window_properties[LIGHTSOFF_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_GTK_GAME_VIEW (gtk_game_view_get_type ())
#define GTK_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GTK_GAME_VIEW, GtkGameView))
#define GTK_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GTK_GAME_VIEW, GtkGameViewClass))
#define IS_GTK_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GTK_GAME_VIEW))
#define IS_GTK_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GTK_GAME_VIEW))
#define GTK_GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GTK_GAME_VIEW, GtkGameViewClass))

typedef struct _GtkGameView GtkGameView;
typedef struct _GtkGameViewClass GtkGameViewClass;
typedef struct _GameButtonPrivate GameButtonPrivate;
enum  {
	GAME_BUTTON_0_PROPERTY,
	GAME_BUTTON_NUM_PROPERTIES
};
static GParamSpec* game_button_properties[GAME_BUTTON_NUM_PROPERTIES];

struct _ManagedWindow {
	GtkApplicationWindow parent_instance;
	ManagedWindowPrivate * priv;
};

struct _ManagedWindowClass {
	GtkApplicationWindowClass parent_class;
	void (*change_window_size) (ManagedWindow* self, gboolean large);
};

struct _LightsoffWindow {
	ManagedWindow parent_instance;
	LightsoffWindowPrivate * priv;
};

struct _LightsoffWindowClass {
	ManagedWindowClass parent_class;
};

struct _BoardViewIface {
	GTypeInterface parent_iface;
	gint (*get_moves) (BoardView* self);
	PuzzleGenerator* (*get_puzzle_generator) (BoardView* self);
	void (*clear_level) (BoardView* self);
	void (*toggle_light) (BoardView* self, gint x, gint y, gboolean user_initiated);
	void (*increase_moves) (BoardView* self);
	gboolean (*is_light_active) (BoardView* self, gint x, gint y);
	GObject* (*get_light_at) (BoardView* self, gint x, gint y);
};

struct _GameViewIface {
	GTypeInterface parent_iface;
	void (*replace_board) (GameView* self, BoardView* board_biew, BoardView* new_board_view, GameViewReplaceStyle style, gboolean fast);
	gboolean (*hide_cursor) (GameView* self);
	gboolean (*activate_cursor) (GameView* self);
	gboolean (*move_cursor) (GameView* self, gint x, gint y);
	void (*reset_game) (GameView* self);
	BoardView* (*get_board_view) (GameView* self);
	gboolean (*is_transitioning) (GameView* self);
	gint (*next_level) (GameView* self, gint direction);
	BoardView* (*create_board_view) (GameView* self, gint level);
};

struct _LightsoffWindowPrivate {
	GtkHeaderBar* headerbar;
	GtkMenuButton* menu_button;
	GtkLabel* level_label;
	GameButton* game_button_1;
	GameButton* game_button_2;
	GtkAspectFrame* aspect_frame;
	GtkRevealer* revealer;
	NotificationsRevealer* notifications_revealer;
	GSettings* settings;
	GameView* game_view;
	GSimpleAction* previous_level;
	GSimpleAction* restart_action;
	GtkEventControllerKey* key_controller;
	gchar* custom_title;
	gboolean large_window_size;
};

struct _GameButton {
	GtkMenuButton parent_instance;
	GameButtonPrivate * priv;
};

struct _GameButtonClass {
	GtkMenuButtonClass parent_class;
};

static gint LightsoffWindow_private_offset;
static gpointer lightsoff_window_parent_class = NULL;
static gpointer game_button_parent_class = NULL;

VALA_EXTERN GType managed_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ManagedWindow, g_object_unref)
VALA_EXTERN GType lightsoff_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LightsoffWindow, g_object_unref)
VALA_EXTERN GType game_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameButton, g_object_unref)
VALA_EXTERN GType notifications_revealer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotificationsRevealer, g_object_unref)
VALA_EXTERN GType puzzle_generator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PuzzleGenerator, g_object_unref)
VALA_EXTERN GType board_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoardView, g_object_unref)
VALA_EXTERN GType game_view_replace_style_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType game_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameView, g_object_unref)
VALA_EXTERN void managed_window_change_window_size (ManagedWindow* self,
                                        gboolean large);
static void lightsoff_window_new_game_cb (LightsoffWindow* self);
static void _lightsoff_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void lightsoff_window_previous_level_cb (LightsoffWindow* self);
static void _lightsoff_window_previous_level_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
static void lightsoff_window_next_level_cb (LightsoffWindow* self);
static void _lightsoff_window_next_level_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
static void lightsoff_window_restart_cb (LightsoffWindow* self);
static void _lightsoff_window_restart_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static inline void lightsoff_window_init_keyboard (LightsoffWindow* self);
static inline gboolean lightsoff_window_on_key_pressed (LightsoffWindow* self,
                                          GtkEventControllerKey* _key_controller,
                                          guint keyval,
                                          guint keycode,
                                          GdkModifierType state);
static gboolean _lightsoff_window_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                guint keyval,
                                                                                guint keycode,
                                                                                GdkModifierType state,
                                                                                gpointer self);
static inline void lightsoff_window_populate_game_container (LightsoffWindow* self,
                                               gint level);
VALA_EXTERN GType gtk_game_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkGameView, g_object_unref)
VALA_EXTERN GtkGameView* gtk_game_view_new (gint level);
VALA_EXTERN GtkGameView* gtk_game_view_construct (GType object_type,
                                      gint level);
VALA_EXTERN LightsoffWindow* lightsoff_window_new (void);
VALA_EXTERN LightsoffWindow* lightsoff_window_construct (GType object_type);
static void lightsoff_window_enable_restart_action (LightsoffWindow* self,
                                             gboolean new_state);
static void lightsoff_window_level_changed_cb (LightsoffWindow* self,
                                        gint level);
VALA_EXTERN void notifications_revealer_show_notification (NotificationsRevealer* self,
                                               const gchar* notification);
static void _lightsoff_window_level_changed_cb_game_view_level_changed (GameView* _sender,
                                                                 gint level,
                                                                 gpointer self);
static void lightsoff_window_update_subtitle (LightsoffWindow* self,
                                       gint moves);
static void _lightsoff_window_update_subtitle_game_view_moves_changed (GameView* _sender,
                                                                gint moves,
                                                                gpointer self);
static void lightsoff_window_update_title (LightsoffWindow* self);
VALA_EXTERN void notifications_revealer_hide_notification (NotificationsRevealer* self);
VALA_EXTERN void game_view_swap_board (GameView* self,
                           gint direction);
VALA_EXTERN gboolean game_view_hide_cursor (GameView* self);
VALA_EXTERN gboolean game_view_move_cursor (GameView* self,
                                gint x,
                                gint y);
VALA_EXTERN gboolean game_view_activate_cursor (GameView* self);
VALA_EXTERN void game_view_reset_game (GameView* self);
static void lightsoff_window_real_change_window_size (ManagedWindow* base,
                                               gboolean large);
VALA_EXTERN void notifications_revealer_set_window_size (NotificationsRevealer* self,
                                             gboolean thin);
static void lightsoff_window_finalize (GObject * obj);
static GType lightsoff_window_get_type_once (void);
VALA_EXTERN GameButton* game_button_new (void);
VALA_EXTERN GameButton* game_button_construct (GType object_type);
static GType game_button_get_type_once (void);

static const GActionEntry LIGHTSOFF_WINDOW_window_actions[4] = {{"new-game", _lightsoff_window_new_game_cb_gsimple_action_activate_callback}, {"previous-level", _lightsoff_window_previous_level_cb_gsimple_action_activate_callback}, {"next-level", _lightsoff_window_next_level_cb_gsimple_action_activate_callback}, {"restart", _lightsoff_window_restart_cb_gsimple_action_activate_callback}};

static inline gpointer
lightsoff_window_get_instance_private (LightsoffWindow* self)
{
	return G_STRUCT_MEMBER_P (self, LightsoffWindow_private_offset);
}

static void
_lightsoff_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	lightsoff_window_new_game_cb ((LightsoffWindow*) self);
}

static void
_lightsoff_window_previous_level_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	lightsoff_window_previous_level_cb ((LightsoffWindow*) self);
}

static void
_lightsoff_window_next_level_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	lightsoff_window_next_level_cb ((LightsoffWindow*) self);
}

static void
_lightsoff_window_restart_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	lightsoff_window_restart_cb ((LightsoffWindow*) self);
}

static gboolean
_lightsoff_window_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                       guint keyval,
                                                                       guint keycode,
                                                                       GdkModifierType state,
                                                                       gpointer self)
{
	gboolean result;
	result = lightsoff_window_on_key_pressed ((LightsoffWindow*) self, _sender, keyval, keycode, state);
	return result;
}

static inline void
lightsoff_window_init_keyboard (LightsoffWindow* self)
{
	GtkEventControllerKey* _tmp0_;
	GtkEventControllerKey* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) self);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp0_;
	_tmp1_ = self->priv->key_controller;
	g_signal_connect_object (_tmp1_, "key-pressed", (GCallback) _lightsoff_window_on_key_pressed_gtk_event_controller_key_key_pressed, self, 0);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static inline void
lightsoff_window_populate_game_container (LightsoffWindow* self,
                                          gint level)
{
	GtkGameView* gtk_game_view = NULL;
	GtkGameView* _tmp0_;
	GtkGameView* _tmp1_;
	GtkGameView* _tmp2_;
	GtkGameView* _tmp3_;
	GtkAspectFrame* _tmp4_;
	GtkGameView* _tmp5_;
	GtkGameView* _tmp6_;
	GameView* _tmp7_;
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp8_;
	GtkCssProvider* _tmp9_;
	GdkScreen* gdk_screen = NULL;
	GdkScreen* _tmp10_;
	GdkScreen* _tmp11_;
	GdkScreen* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_game_view_new (level);
	g_object_ref_sink (_tmp0_);
	gtk_game_view = _tmp0_;
	_tmp1_ = gtk_game_view;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = gtk_game_view;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = gtk_game_view;
	gtk_widget_show ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->aspect_frame;
	_tmp5_ = gtk_game_view;
	gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = gtk_game_view;
	_tmp7_ = _g_object_ref0 ((GameView*) _tmp6_);
	_g_object_unref0 (self->priv->game_view);
	self->priv->game_view = _tmp7_;
	_tmp8_ = gtk_css_provider_new ();
	provider = _tmp8_;
	_tmp9_ = provider;
	gtk_css_provider_load_from_resource (_tmp9_, "/org/gnome/LightsOff/ui/lightsoff.css");
	_tmp10_ = gdk_screen_get_default ();
	_tmp11_ = _g_object_ref0 (_tmp10_);
	gdk_screen = _tmp11_;
	_tmp12_ = gdk_screen;
	if (_tmp12_ != NULL) {
		GdkScreen* _tmp13_;
		GtkCssProvider* _tmp14_;
		_tmp13_ = gdk_screen;
		_tmp14_ = provider;
		gtk_style_context_add_provider_for_screen (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gdk_screen_get_type (), GdkScreen), (GtkStyleProvider*) _tmp14_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	}
	_g_object_unref0 (gdk_screen);
	_g_object_unref0 (provider);
	_g_object_unref0 (gtk_game_view);
}

static void
_lightsoff_window_level_changed_cb_game_view_level_changed (GameView* _sender,
                                                            gint level,
                                                            gpointer self)
{
	lightsoff_window_level_changed_cb ((LightsoffWindow*) self, level);
}

static void
_lightsoff_window_update_subtitle_game_view_moves_changed (GameView* _sender,
                                                           gint moves,
                                                           gpointer self)
{
	lightsoff_window_update_subtitle ((LightsoffWindow*) self, moves);
}

LightsoffWindow*
lightsoff_window_construct (GType object_type)
{
	LightsoffWindow * self = NULL;
	GSettings* _tmp0_;
	GtkBuilder* menu_builder = NULL;
	GtkBuilder* _tmp1_;
	GtkMenuButton* _tmp2_;
	GtkBuilder* _tmp3_;
	GObject* _tmp4_;
	GAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GAction* _tmp7_;
	GSimpleAction* _tmp8_;
	gint level = 0;
	GSettings* _tmp9_;
	GameView* _tmp11_;
	GameView* _tmp12_;
	self = (LightsoffWindow*) g_object_new (object_type, "schema-path", "/org/gnome/LightsOff/", NULL);
	_tmp0_ = g_settings_new ("org.gnome.LightsOff");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = gtk_builder_new_from_resource ("/org/gnome/LightsOff/ui/menus.ui");
	menu_builder = _tmp1_;
	_tmp2_ = self->priv->menu_button;
	_tmp3_ = menu_builder;
	_tmp4_ = gtk_builder_get_object (_tmp3_, "primary-menu");
	gtk_menu_button_set_menu_model (_tmp2_, (GMenuModel*) G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_menu_get_type (), GMenu));
	g_action_map_add_action_entries ((GActionMap*) self, LIGHTSOFF_WINDOW_window_actions, (gint) G_N_ELEMENTS (LIGHTSOFF_WINDOW_window_actions), self);
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) self, "previous-level");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->previous_level);
	self->priv->previous_level = _tmp6_;
	_tmp7_ = g_action_map_lookup_action ((GActionMap*) self, "restart");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->restart_action);
	self->priv->restart_action = _tmp8_;
	lightsoff_window_enable_restart_action (self, FALSE);
	lightsoff_window_init_keyboard (self);
	_tmp9_ = self->priv->settings;
	level = g_settings_get_int (_tmp9_, "level");
	lightsoff_window_level_changed_cb (self, level);
	if (level == 1) {
		NotificationsRevealer* _tmp10_;
		_tmp10_ = self->priv->notifications_revealer;
		notifications_revealer_show_notification (_tmp10_, _ ("Turn off all the lights!"));
	}
	lightsoff_window_populate_game_container (self, level);
	_tmp11_ = self->priv->game_view;
	g_signal_connect_object (_tmp11_, "level-changed", (GCallback) _lightsoff_window_level_changed_cb_game_view_level_changed, self, 0);
	_tmp12_ = self->priv->game_view;
	g_signal_connect_object (_tmp12_, "moves-changed", (GCallback) _lightsoff_window_update_subtitle_game_view_moves_changed, self, 0);
	_g_object_unref0 (menu_builder);
	return self;
}

LightsoffWindow*
lightsoff_window_new (void)
{
	return lightsoff_window_construct (TYPE_LIGHTSOFF_WINDOW);
}

static void
lightsoff_window_update_subtitle (LightsoffWindow* self,
                                  gint moves)
{
	gchar* moves_string = NULL;
	gchar* _tmp0_;
	GameButton* _tmp1_;
	GameButton* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup_printf ("%i", moves);
	moves_string = _tmp0_;
	_tmp1_ = self->priv->game_button_1;
	gtk_button_set_label ((GtkButton*) _tmp1_, moves_string);
	_tmp2_ = self->priv->game_button_2;
	gtk_button_set_label ((GtkButton*) _tmp2_, moves_string);
	lightsoff_window_enable_restart_action (self, moves > 0);
	_g_free0 (moves_string);
}

static void
lightsoff_window_update_title (LightsoffWindow* self)
{
	GtkLabel* _tmp2_;
	const gchar* _tmp3_;
	NotificationsRevealer* _tmp4_;
	g_return_if_fail (self != NULL);
	if (self->priv->large_window_size) {
		GtkHeaderBar* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = self->priv->headerbar;
		_tmp1_ = self->priv->custom_title;
		gtk_header_bar_set_title (_tmp0_, _tmp1_);
	}
	_tmp2_ = self->priv->level_label;
	_tmp3_ = self->priv->custom_title;
	gtk_label_set_label (_tmp2_, _tmp3_);
	lightsoff_window_update_subtitle (self, 0);
	_tmp4_ = self->priv->notifications_revealer;
	notifications_revealer_hide_notification (_tmp4_);
}

static void
lightsoff_window_enable_restart_action (LightsoffWindow* self,
                                        gboolean new_state)
{
	GSimpleAction* _tmp0_;
	GameButton* _tmp1_;
	GameButton* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->restart_action;
	g_simple_action_set_enabled (_tmp0_, new_state);
	_tmp1_ = self->priv->game_button_1;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, new_state);
	_tmp2_ = self->priv->game_button_2;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, new_state);
}

static void
lightsoff_window_previous_level_cb (LightsoffWindow* self)
{
	GameView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	game_view_swap_board (_tmp0_, -1);
}

static void
lightsoff_window_next_level_cb (LightsoffWindow* self)
{
	GameView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	game_view_swap_board (_tmp0_, 1);
}

static void
lightsoff_window_restart_cb (LightsoffWindow* self)
{
	GameView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	game_view_swap_board (_tmp0_, 0);
	lightsoff_window_enable_restart_action (self, FALSE);
}

static void
lightsoff_window_level_changed_cb (LightsoffWindow* self,
                                   gint level)
{
	GSimpleAction* _tmp0_;
	gchar* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->previous_level;
	g_simple_action_set_enabled (_tmp0_, level > 1);
	lightsoff_window_enable_restart_action (self, FALSE);
	_tmp1_ = g_strdup_printf (_ ("Puzzle %d"), level);
	_g_free0 (self->priv->custom_title);
	self->priv->custom_title = _tmp1_;
	lightsoff_window_update_title (self);
	gtk_window_set_focus_visible ((GtkWindow*) self, FALSE);
	_tmp2_ = self->priv->settings;
	if (level != g_settings_get_int (_tmp2_, "level")) {
		GSettings* _tmp3_;
		_tmp3_ = self->priv->settings;
		g_settings_set_int (_tmp3_, "level", level);
	}
}

static inline gboolean
lightsoff_window_on_key_pressed (LightsoffWindow* self,
                                 GtkEventControllerKey* _key_controller,
                                 guint keyval,
                                 guint keycode,
                                 GdkModifierType state)
{
	GtkMenuButton* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (_key_controller != NULL, FALSE);
	_tmp0_ = self->priv->menu_button;
	if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_)) {
		result = FALSE;
		return result;
	}
	switch (keyval) {
		case GDK_KEY_Escape:
		{
			GameView* _tmp1_;
			gtk_window_set_focus_visible ((GtkWindow*) self, FALSE);
			_tmp1_ = self->priv->game_view;
			result = game_view_hide_cursor (_tmp1_);
			return result;
		}
		case GDK_KEY_Down:
		{
			GameView* _tmp2_;
			_tmp2_ = self->priv->game_view;
			result = game_view_move_cursor (_tmp2_, 0, 1);
			return result;
		}
		case GDK_KEY_Up:
		{
			GameView* _tmp3_;
			_tmp3_ = self->priv->game_view;
			result = game_view_move_cursor (_tmp3_, 0, -1);
			return result;
		}
		case GDK_KEY_Left:
		{
			GameView* _tmp4_;
			_tmp4_ = self->priv->game_view;
			result = game_view_move_cursor (_tmp4_, -1, 0);
			return result;
		}
		case GDK_KEY_Right:
		{
			GameView* _tmp5_;
			_tmp5_ = self->priv->game_view;
			result = game_view_move_cursor (_tmp5_, 1, 0);
			return result;
		}
		case GDK_KEY_Return:
		{
			GameView* _tmp6_;
			_tmp6_ = self->priv->game_view;
			result = game_view_activate_cursor (_tmp6_);
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static void
lightsoff_window_new_game_cb (LightsoffWindow* self)
{
	GameView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	game_view_reset_game (_tmp0_);
	lightsoff_window_enable_restart_action (self, FALSE);
}

static void
lightsoff_window_real_change_window_size (ManagedWindow* base,
                                          gboolean large)
{
	LightsoffWindow * self;
	self = (LightsoffWindow*) base;
	self->priv->large_window_size = large;
	if (large) {
		GameButton* _tmp0_;
		GtkHeaderBar* _tmp1_;
		const gchar* _tmp2_;
		GtkRevealer* _tmp3_;
		NotificationsRevealer* _tmp4_;
		_tmp0_ = self->priv->game_button_1;
		gtk_widget_show ((GtkWidget*) _tmp0_);
		_tmp1_ = self->priv->headerbar;
		_tmp2_ = self->priv->custom_title;
		gtk_header_bar_set_title (_tmp1_, _tmp2_);
		_tmp3_ = self->priv->revealer;
		gtk_revealer_set_reveal_child (_tmp3_, FALSE);
		_tmp4_ = self->priv->notifications_revealer;
		notifications_revealer_set_window_size (_tmp4_, FALSE);
	} else {
		GameButton* _tmp5_;
		GtkHeaderBar* _tmp6_;
		GtkRevealer* _tmp7_;
		NotificationsRevealer* _tmp8_;
		_tmp5_ = self->priv->game_button_1;
		gtk_widget_hide ((GtkWidget*) _tmp5_);
		_tmp6_ = self->priv->headerbar;
		gtk_header_bar_set_title (_tmp6_, NULL);
		_tmp7_ = self->priv->revealer;
		gtk_revealer_set_reveal_child (_tmp7_, TRUE);
		_tmp8_ = self->priv->notifications_revealer;
		notifications_revealer_set_window_size (_tmp8_, TRUE);
	}
}

static void
lightsoff_window_class_init (LightsoffWindowClass * klass,
                             gpointer klass_data)
{
	lightsoff_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &LightsoffWindow_private_offset);
	((ManagedWindowClass *) klass)->change_window_size = (void (*) (ManagedWindow*, gboolean)) lightsoff_window_real_change_window_size;
	G_OBJECT_CLASS (klass)->finalize = lightsoff_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/LightsOff/ui/lightsoff.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "headerbar", FALSE, LightsoffWindow_private_offset + G_STRUCT_OFFSET (LightsoffWindowPrivate, headerbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "menu_button", FALSE, LightsoffWindow_private_offset + G_STRUCT_OFFSET (LightsoffWindowPrivate, menu_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "level_label", FALSE, LightsoffWindow_private_offset + G_STRUCT_OFFSET (LightsoffWindowPrivate, level_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "game_button_1", FALSE, LightsoffWindow_private_offset + G_STRUCT_OFFSET (LightsoffWindowPrivate, game_button_1));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "game_button_2", FALSE, LightsoffWindow_private_offset + G_STRUCT_OFFSET (LightsoffWindowPrivate, game_button_2));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "aspect_frame", FALSE, LightsoffWindow_private_offset + G_STRUCT_OFFSET (LightsoffWindowPrivate, aspect_frame));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "revealer", FALSE, LightsoffWindow_private_offset + G_STRUCT_OFFSET (LightsoffWindowPrivate, revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "notifications_revealer", FALSE, LightsoffWindow_private_offset + G_STRUCT_OFFSET (LightsoffWindowPrivate, notifications_revealer));
}

static void
lightsoff_window_instance_init (LightsoffWindow * self,
                                gpointer klass)
{
	gchar* _tmp0_;
	self->priv = lightsoff_window_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->custom_title = _tmp0_;
	self->priv->large_window_size = TRUE;
	g_type_ensure (TYPE_GAME_BUTTON);
	g_type_ensure (TYPE_GAME_BUTTON);
	g_type_ensure (TYPE_NOTIFICATIONS_REVEALER);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
lightsoff_window_finalize (GObject * obj)
{
	LightsoffWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIGHTSOFF_WINDOW, LightsoffWindow);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->game_view);
	_g_object_unref0 (self->priv->previous_level);
	_g_object_unref0 (self->priv->restart_action);
	_g_object_unref0 (self->priv->key_controller);
	_g_free0 (self->priv->custom_title);
	G_OBJECT_CLASS (lightsoff_window_parent_class)->finalize (obj);
}

static GType
lightsoff_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LightsoffWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lightsoff_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LightsoffWindow), 0, (GInstanceInitFunc) lightsoff_window_instance_init, NULL };
	GType lightsoff_window_type_id;
	lightsoff_window_type_id = g_type_register_static (TYPE_MANAGED_WINDOW, "LightsoffWindow", &g_define_type_info, 0);
	LightsoffWindow_private_offset = g_type_add_instance_private (lightsoff_window_type_id, sizeof (LightsoffWindowPrivate));
	return lightsoff_window_type_id;
}

GType
lightsoff_window_get_type (void)
{
	static volatile gsize lightsoff_window_type_id__once = 0;
	if (g_once_init_enter (&lightsoff_window_type_id__once)) {
		GType lightsoff_window_type_id;
		lightsoff_window_type_id = lightsoff_window_get_type_once ();
		g_once_init_leave (&lightsoff_window_type_id__once, lightsoff_window_type_id);
	}
	return lightsoff_window_type_id__once;
}

GameButton*
game_button_construct (GType object_type)
{
	GameButton * self = NULL;
	self = (GameButton*) g_object_new (object_type, NULL);
	return self;
}

GameButton*
game_button_new (void)
{
	return game_button_construct (TYPE_GAME_BUTTON);
}

static void
game_button_class_init (GameButtonClass * klass,
                        gpointer klass_data)
{
	game_button_parent_class = g_type_class_peek_parent (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/LightsOff/ui/game-button.ui");
}

static void
game_button_instance_init (GameButton * self,
                           gpointer klass)
{
	gtk_widget_init_template (GTK_WIDGET (self));
}

static GType
game_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameButton), 0, (GInstanceInitFunc) game_button_instance_init, NULL };
	GType game_button_type_id;
	game_button_type_id = g_type_register_static (gtk_menu_button_get_type (), "GameButton", &g_define_type_info, 0);
	return game_button_type_id;
}

GType
game_button_get_type (void)
{
	static volatile gsize game_button_type_id__once = 0;
	if (g_once_init_enter (&game_button_type_id__once)) {
		GType game_button_type_id;
		game_button_type_id = game_button_get_type_once ();
		g_once_init_leave (&game_button_type_id__once, game_button_type_id);
	}
	return game_button_type_id__once;
}

