/* MainWindow.c generated by valac 0.56.16, the Vala compiler
 * generated from MainWindow.vala, do not modify */

/*
 * Copyright 2018-2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authors: Corentin Noël <corentin@elementary.io>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <handy.h>
#include <lightdm.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <granite.h>
#include <glib/gi18n-lib.h>
#include <gio/gdesktopappinfo.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_TYPE_MAIN_WINDOW (greeter_main_window_get_type ())
#define GREETER_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_MAIN_WINDOW, GreeterMainWindow))
#define GREETER_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_MAIN_WINDOW, GreeterMainWindowClass))
#define GREETER_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_MAIN_WINDOW))
#define GREETER_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_MAIN_WINDOW))
#define GREETER_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_MAIN_WINDOW, GreeterMainWindowClass))

typedef struct _GreeterMainWindow GreeterMainWindow;
typedef struct _GreeterMainWindowClass GreeterMainWindowClass;
typedef struct _GreeterMainWindowPrivate GreeterMainWindowPrivate;

#define GREETER_TYPE_BASE_CARD (greeter_base_card_get_type ())
#define GREETER_BASE_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_BASE_CARD, GreeterBaseCard))
#define GREETER_BASE_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_BASE_CARD, GreeterBaseCardClass))
#define GREETER_IS_BASE_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_BASE_CARD))
#define GREETER_IS_BASE_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_BASE_CARD))
#define GREETER_BASE_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_BASE_CARD, GreeterBaseCardClass))

typedef struct _GreeterBaseCard GreeterBaseCard;
typedef struct _GreeterBaseCardClass GreeterBaseCardClass;

#define GREETER_TYPE_USER_CARD (greeter_user_card_get_type ())
#define GREETER_USER_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_USER_CARD, GreeterUserCard))
#define GREETER_USER_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_USER_CARD, GreeterUserCardClass))
#define GREETER_IS_USER_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_USER_CARD))
#define GREETER_IS_USER_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_USER_CARD))
#define GREETER_USER_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_USER_CARD, GreeterUserCardClass))

typedef struct _GreeterUserCard GreeterUserCard;
typedef struct _GreeterUserCardClass GreeterUserCardClass;

#define GREETER_TYPE_SETTINGS (greeter_settings_get_type ())
#define GREETER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_SETTINGS, GreeterSettings))
#define GREETER_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_SETTINGS, GreeterSettingsClass))
#define GREETER_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_SETTINGS))
#define GREETER_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_SETTINGS))
#define GREETER_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_SETTINGS, GreeterSettingsClass))

typedef struct _GreeterSettings GreeterSettings;
typedef struct _GreeterSettingsClass GreeterSettingsClass;

#define GREETER_TYPE_DATE_TIME_WIDGET (greeter_date_time_widget_get_type ())
#define GREETER_DATE_TIME_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_DATE_TIME_WIDGET, GreeterDateTimeWidget))
#define GREETER_DATE_TIME_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_DATE_TIME_WIDGET, GreeterDateTimeWidgetClass))
#define GREETER_IS_DATE_TIME_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_DATE_TIME_WIDGET))
#define GREETER_IS_DATE_TIME_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_DATE_TIME_WIDGET))
#define GREETER_DATE_TIME_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_DATE_TIME_WIDGET, GreeterDateTimeWidgetClass))

typedef struct _GreeterDateTimeWidget GreeterDateTimeWidget;
typedef struct _GreeterDateTimeWidgetClass GreeterDateTimeWidgetClass;
enum  {
	GREETER_MAIN_WINDOW_0_PROPERTY,
	GREETER_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* greeter_main_window_properties[GREETER_MAIN_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef enum  {
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_SWIPE,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_SWIPE_AGAIN,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_SWIPE_TOO_SHORT,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_NOT_CENTERED,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_REMOVE,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_PLACE,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_PLACE_AGAIN,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_NO_MATCH,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_TIMEOUT,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_ERROR,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FAILED,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_OTHER
} GreeterFPrintUtilsMessageText;

#define GREETER_FPRINT_UTILS_TYPE_MESSAGE_TEXT (greeter_fprint_utils_message_text_get_type ())

#define GREETER_TYPE_MANUAL_CARD (greeter_manual_card_get_type ())
#define GREETER_MANUAL_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_MANUAL_CARD, GreeterManualCard))
#define GREETER_MANUAL_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_MANUAL_CARD, GreeterManualCardClass))
#define GREETER_IS_MANUAL_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_MANUAL_CARD))
#define GREETER_IS_MANUAL_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_MANUAL_CARD))
#define GREETER_MANUAL_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_MANUAL_CARD, GreeterManualCardClass))

typedef struct _GreeterManualCard GreeterManualCard;
typedef struct _GreeterManualCardClass GreeterManualCardClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GreeterMainWindowLoadUsersData GreeterMainWindowLoadUsersData;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;

struct _GreeterMainWindow {
	GtkApplicationWindow parent_instance;
	GreeterMainWindowPrivate * priv;
};

struct _GreeterMainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _GreeterMainWindowPrivate {
	GQueue* user_cards;
	GtkSizeGroup* card_size_group;
	HdyCarousel* carousel;
	LightDMGreeter* lightdm_greeter;
	GreeterSettings* settings;
	GtkButton* guest_login_button;
	GtkToggleButton* manual_login_button;
	GreeterDateTimeWidget* datetime_widget;
	LightDMUserList* lightdm_user_list;
	gint current_user_card_index;
	GreeterBaseCard* current_card;
	gboolean installer_mode;
	GBinding* time_format_binding;
};

struct _Block1Data {
	int _ref_count_;
	GreeterMainWindow* self;
	GSimpleAction* select_session_action;
	GVariantDict* vardict;
};

struct _Block2Data {
	int _ref_count_;
	GreeterMainWindow* self;
	gchar* user_to_select;
	gboolean user_selected;
};

struct _GreeterMainWindowLoadUsersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GreeterMainWindow* self;
	LightDMGreeter* _tmp0_;
	GError* e;
	GError* _tmp1_;
	const gchar* _tmp2_;
	LightDMGreeter* _tmp3_;
	LightDMGreeter* _tmp4_;
	LightDMGreeter* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GActionGroup* _tmp8_;
	LightDMGreeter* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	GDesktopAppInfo* installer_desktop;
	GDesktopAppInfo* _tmp14_;
	GDesktopAppInfo* _tmp15_;
	LightDMUserList* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	Block2Data* _data2_;
	GreeterDateTimeWidget* _tmp19_;
	LightDMUserList* _tmp20_;
	GList* _tmp21_;
	GList* _tmp22_;
	const gchar* select_user;
	LightDMGreeter* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	GreeterSettings* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	GQueue* _tmp35_;
	GList* _tmp36_;
	GreeterUserCard* user_card;
	GQueue* _tmp37_;
	gconstpointer _tmp38_;
	GreeterUserCard* _tmp39_;
	GreeterUserCard* _tmp40_;
	GreeterDateTimeWidget* _tmp41_;
	LightDMGreeter* _tmp42_;
	GError* _inner_error0_;
};

struct _Block3Data {
	int _ref_count_;
	GreeterMainWindow* self;
	GreeterUserCard* user_card;
};

struct _Block4Data {
	int _ref_count_;
	GreeterMainWindow* self;
	GtkGrid* extra_login_grid;
	GreeterManualCard* manual_card;
	GtkStack* manual_login_stack;
};

static gint GreeterMainWindow_private_offset;
static gpointer greeter_main_window_parent_class = NULL;
VALA_EXTERN GtkCssProvider* greeter_main_window_css_provider;
GtkCssProvider* greeter_main_window_css_provider = NULL;

VALA_EXTERN GType greeter_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterMainWindow, g_object_unref)
VALA_EXTERN GType greeter_base_card_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterBaseCard, g_object_unref)
VALA_EXTERN GType greeter_user_card_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterUserCard, g_object_unref)
VALA_EXTERN GType greeter_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterSettings, g_object_unref)
VALA_EXTERN GType greeter_date_time_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterDateTimeWidget, g_object_unref)
static void greeter_main_window_maximize_and_focus (GreeterMainWindow* self);
static void greeter_main_window_maximize_window (GreeterMainWindow* self);
static void greeter_main_window_create_session_selection_action (GreeterMainWindow* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda20_ (Block1Data* _data1_,
                  LightDMSession* session);
static void ___lambda20__gfunc (gconstpointer data,
                         gpointer self);
static void __lambda21_ (Block1Data* _data1_,
                  GVariant* param);
static void ___lambda21__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static void greeter_main_window_show_message (GreeterMainWindow* self,
                                       const gchar* text,
                                       LightDMMessageType type);
VALA_EXTERN GType greeter_fprint_utils_message_text_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GreeterFPrintUtilsMessageText greeter_fprint_utils_string_to_messagetext (const gchar* text);
VALA_EXTERN void greeter_base_card_set_use_fingerprint (GreeterBaseCard* self,
                                            gboolean value);
static void greeter_main_window_show_prompt (GreeterMainWindow* self,
                                      const gchar* text,
                                      LightDMPromptType type);
VALA_EXTERN GType greeter_manual_card_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterManualCard, g_object_unref)
VALA_EXTERN void greeter_manual_card_ask_password (GreeterManualCard* self);
VALA_EXTERN void greeter_manual_card_wrong_username (GreeterManualCard* self);
static void greeter_main_window_authentication_complete (GreeterMainWindow* self);
VALA_EXTERN LightDMUser* greeter_user_card_get_lightdm_user (GreeterUserCard* self);
VALA_EXTERN void greeter_settings_set_last_user (GreeterSettings* self,
                                     const gchar* value);
VALA_EXTERN gint greeter_user_card_get_sleep_inactive_ac_timeout (GreeterUserCard* self);
VALA_EXTERN void greeter_settings_set_sleep_inactive_ac_timeout (GreeterSettings* self,
                                                     gint value);
VALA_EXTERN gint greeter_user_card_get_sleep_inactive_ac_type (GreeterUserCard* self);
VALA_EXTERN void greeter_settings_set_sleep_inactive_ac_type (GreeterSettings* self,
                                                  gint value);
VALA_EXTERN gint greeter_user_card_get_sleep_inactive_battery_timeout (GreeterUserCard* self);
VALA_EXTERN void greeter_settings_set_sleep_inactive_battery_timeout (GreeterSettings* self,
                                                          gint value);
VALA_EXTERN gint greeter_user_card_get_sleep_inactive_battery_type (GreeterUserCard* self);
VALA_EXTERN void greeter_settings_set_sleep_inactive_battery_type (GreeterSettings* self,
                                                       gint value);
static void _gtk_widget_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
VALA_EXTERN void greeter_base_card_wrong_credentials (GreeterBaseCard* self);
static void greeter_main_window_load_users_data_free (gpointer _data);
static void greeter_main_window_load_users (GreeterMainWindow* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static void greeter_main_window_load_users_finish (GreeterMainWindow* self,
                                            GAsyncResult* _res_);
static gboolean greeter_main_window_load_users_co (GreeterMainWindowLoadUsersData* _data_);
static void greeter_main_window_load_users_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda26_ (GreeterMainWindow* self,
                   LightDMUser* user);
static void greeter_main_window_add_card (GreeterMainWindow* self,
                                   LightDMUser* lightdm_user);
static void ____lambda26__gfunc (gconstpointer data,
                          gpointer self);
VALA_EXTERN gchar* greeter_settings_get_last_user (GreeterSettings* self);
static void ____lambda30_ (Block2Data* _data2_,
                    GreeterUserCard* card);
static void greeter_main_window_switch_to_card (GreeterMainWindow* self,
                                         GreeterUserCard* user_card);
static void _____lambda30__gfunc (gconstpointer data,
                           gpointer self);
VALA_EXTERN void greeter_user_card_set_show_input (GreeterUserCard* self,
                                       gboolean value);
static gboolean ___lambda31_ (GreeterMainWindow* self);
static gboolean ____lambda31__gsource_func (gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN GreeterUserCard* greeter_user_card_new (LightDMUser* lightdm_user);
VALA_EXTERN GreeterUserCard* greeter_user_card_construct (GType object_type,
                                              LightDMUser* lightdm_user);
static void __lambda27_ (Block3Data* _data3_);
static void ___lambda27__greeter_user_card_focus_requested (GreeterUserCard* _sender,
                                                     gpointer self);
static void __lambda28_ (GreeterMainWindow* self);
static void greeter_main_window_go_previous (GreeterMainWindow* self);
static void greeter_main_window_go_next (GreeterMainWindow* self);
static void ___lambda28__greeter_user_card_go_left (GreeterUserCard* _sender,
                                             gpointer self);
static void __lambda29_ (GreeterMainWindow* self);
static void ___lambda29__greeter_user_card_go_right (GreeterUserCard* _sender,
                                              gpointer self);
static void greeter_main_window_do_connect (GreeterMainWindow* self,
                                     const gchar* credential);
static void _greeter_main_window_do_connect_greeter_base_card_do_connect (GreeterBaseCard* _sender,
                                                                   const gchar* credential,
                                                                   gpointer self);
VALA_EXTERN void greeter_user_card_set_settings (GreeterUserCard* self);
static void greeter_main_window_do_connect_username (GreeterMainWindow* self,
                                              const gchar* username);
VALA_EXTERN GreeterMainWindow* greeter_main_window_new (void);
VALA_EXTERN GreeterMainWindow* greeter_main_window_construct (GType object_type);
static GObject * greeter_main_window_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN GreeterSettings* greeter_settings_new (void);
VALA_EXTERN GreeterSettings* greeter_settings_construct (GType object_type);
VALA_EXTERN GreeterDateTimeWidget* greeter_date_time_widget_new (void);
VALA_EXTERN GreeterDateTimeWidget* greeter_date_time_widget_construct (GType object_type);
VALA_EXTERN GreeterManualCard* greeter_manual_card_new (void);
VALA_EXTERN GreeterManualCard* greeter_manual_card_construct (GType object_type);
static void _greeter_main_window___lambda32_ (Block4Data* _data4_);
static void __greeter_main_window___lambda32__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self);
static void _greeter_main_window___lambda33_ (GreeterMainWindow* self);
static void __greeter_main_window___lambda33__gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self);
static void _greeter_main_window_show_message_lightdm_greeter_show_message (LightDMGreeter* _sender,
                                                                     const gchar* text,
                                                                     LightDMMessageType type,
                                                                     gpointer self);
static void _greeter_main_window_show_prompt_lightdm_greeter_show_prompt (LightDMGreeter* _sender,
                                                                   const gchar* text,
                                                                   LightDMPromptType type,
                                                                   gpointer self);
static void _greeter_main_window_authentication_complete_lightdm_greeter_authentication_complete (LightDMGreeter* _sender,
                                                                                           gpointer self);
static void _greeter_main_window___lambda34_ (Block4Data* _data4_);
static void __greeter_main_window___lambda34__g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void _greeter_main_window___lambda35_ (Block4Data* _data4_);
static void __greeter_main_window___lambda35__g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void _greeter_main_window___lambda36_ (GreeterMainWindow* self);
static void __greeter_main_window___lambda36__g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void _greeter_main_window___lambda37_ (GreeterMainWindow* self);
static void __greeter_main_window___lambda37__lightdm_user_list_user_added (LightDMUserList* _sender,
                                                                     LightDMUser* user,
                                                                     gpointer self);
static void _greeter_main_window_do_connect_username_greeter_manual_card_do_connect_username (GreeterManualCard* _sender,
                                                                                       const gchar* username,
                                                                                       gpointer self);
static gboolean _greeter_main_window___lambda38_ (GreeterMainWindow* self,
                                           GdkEventKey* event);
static gboolean _vala_uint_array_contains (guint * stack,
                                    gssize stack_length,
                                    const guint needle);
static gboolean __greeter_main_window___lambda38__gtk_widget_key_press_event (GtkWidget* _sender,
                                                                       GdkEventKey* event,
                                                                       gpointer self);
static void _greeter_main_window___lambda39_ (GreeterMainWindow* self,
                                       guint index);
static void __greeter_main_window___lambda39__hdy_carousel_page_changed (HdyCarousel* _sender,
                                                                  guint index,
                                                                  gpointer self);
static void _greeter_main_window___lambda40_ (GreeterMainWindow* self);
static void __greeter_main_window___lambda40__gdk_screen_monitors_changed (GdkScreen* _sender,
                                                                    gpointer self);
static gboolean _greeter_main_window___lambda41_ (GreeterMainWindow* self);
static gboolean __greeter_main_window___lambda41__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                          GdkEventCrossing* event,
                                                                          gpointer self);
static void _greeter_main_window___lambda42_ (GreeterMainWindow* self);
static void __greeter_main_window___lambda42__gtk_widget_destroy (GtkWidget* _sender,
                                                           gpointer self);
static void _greeter_main_window___lambda43_ (GreeterMainWindow* self);
static gboolean __lambda44_ (GreeterMainWindow* self);
static gboolean ___lambda44__gsource_func (gpointer self);
static void __greeter_main_window___lambda43__gasync_ready_callback (GObject* source_object,
                                                              GAsyncResult* res,
                                                              gpointer self);
VALA_EXTERN gboolean greeter_settings_get_activate_numlock (GreeterSettings* self);
static void greeter_main_window_finalize (GObject * obj);
static GType greeter_main_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const guint GREETER_MAIN_WINDOW_NAVIGATION_KEYS[6] = {GDK_KEY_Up, GDK_KEY_Down, GDK_KEY_Left, GDK_KEY_Right, GDK_KEY_Return, GDK_KEY_Tab};

static inline gpointer
greeter_main_window_get_instance_private (GreeterMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterMainWindow_private_offset);
}

static void
greeter_main_window_maximize_and_focus (GreeterMainWindow* self)
{
	GtkStyleContext* _tmp0_;
	GreeterBaseCard* _tmp1_;
	g_return_if_fail (self != NULL);
	gtk_window_present ((GtkWindow*) self);
	greeter_main_window_maximize_window (self);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "initialized");
	_tmp1_ = self->priv->current_card;
	if (_tmp1_ != NULL) {
		GreeterBaseCard* _tmp2_;
		_tmp2_ = self->priv->current_card;
		gtk_widget_grab_focus ((GtkWidget*) _tmp2_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
greeter_main_window_maximize_window (GreeterMainWindow* self)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkSeat* seat = NULL;
	GdkDisplay* _tmp2_;
	GdkSeat* _tmp3_;
	GdkDevice* pointer = NULL;
	GdkSeat* _tmp4_;
	GdkDevice* _tmp5_;
	GdkMonitor* monitor = NULL;
	GdkDevice* _tmp6_;
	GdkRectangle rect = {0};
	GdkMonitor* _tmp16_;
	GdkRectangle _tmp17_ = {0};
	GdkRectangle _tmp18_;
	GdkRectangle _tmp19_;
	GdkRectangle _tmp20_;
	GdkRectangle _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	_tmp3_ = gdk_display_get_default_seat (_tmp2_);
	seat = _tmp3_;
	_tmp4_ = seat;
	_tmp5_ = gdk_seat_get_pointer (_tmp4_);
	pointer = _tmp5_;
	_tmp6_ = pointer;
	if (_tmp6_ != NULL) {
		gint x = 0;
		gint y = 0;
		GdkDevice* _tmp7_;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		GdkDisplay* _tmp10_;
		GdkMonitor* _tmp11_;
		GdkMonitor* _tmp12_;
		_tmp7_ = pointer;
		gdk_device_get_position (_tmp7_, NULL, &_tmp8_, &_tmp9_);
		x = _tmp8_;
		y = _tmp9_;
		_tmp10_ = display;
		_tmp11_ = gdk_display_get_monitor_at_point (_tmp10_, x, y);
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_g_object_unref0 (monitor);
		monitor = _tmp12_;
	} else {
		GdkDisplay* _tmp13_;
		GdkMonitor* _tmp14_;
		GdkMonitor* _tmp15_;
		_tmp13_ = display;
		_tmp14_ = gdk_display_get_primary_monitor (_tmp13_);
		_tmp15_ = _g_object_ref0 (_tmp14_);
		_g_object_unref0 (monitor);
		monitor = _tmp15_;
	}
	_tmp16_ = monitor;
	gdk_monitor_get_geometry (_tmp16_, &_tmp17_);
	rect = _tmp17_;
	_tmp18_ = rect;
	_tmp19_ = rect;
	gtk_window_resize ((GtkWindow*) self, _tmp18_.width, _tmp19_.height);
	_tmp20_ = rect;
	_tmp21_ = rect;
	gtk_window_move ((GtkWindow*) self, _tmp20_.x, _tmp21_.y);
	_g_object_unref0 (monitor);
	_g_object_unref0 (display);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GreeterMainWindow* self;
		self = _data1_->self;
		_g_variant_dict_unref0 (_data1_->vardict);
		_g_object_unref0 (_data1_->select_session_action);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda20_ (Block1Data* _data1_,
             LightDMSession* session)
{
	GreeterMainWindow* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	self = _data1_->self;
	g_return_if_fail (session != NULL);
	_tmp0_ = lightdm_session_get_name (session);
	_tmp1_ = _tmp0_;
	_tmp2_ = lightdm_session_get_key (session);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_new_string (_tmp3_);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	g_variant_dict_insert_value (_data1_->vardict, _tmp1_, _tmp5_);
	_g_variant_unref0 (_tmp5_);
}

static void
___lambda20__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda20_ (self, (LightDMSession*) data);
}

static void
__lambda21_ (Block1Data* _data1_,
             GVariant* param)
{
	GreeterMainWindow* self;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	gboolean _tmp2_;
	self = _data1_->self;
	_tmp0_ = g_action_get_state ((GAction*) _data1_->select_session_action);
	_tmp1_ = _tmp0_;
	_tmp2_ = !g_variant_equal (_tmp1_, param);
	_g_variant_unref0 (_tmp1_);
	if (_tmp2_) {
		g_simple_action_set_state (_data1_->select_session_action, param);
	}
}

static void
___lambda21__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
	__lambda21_ (self, parameter);
}

static void
greeter_main_window_create_session_selection_action (GreeterMainWindow* self)
{
	Block1Data* _data1_;
	GList* sessions = NULL;
	GList* _tmp0_;
	LightDMSession* first_session = NULL;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	const gchar* _tmp3_ = NULL;
	LightDMSession* _tmp4_;
	GVariant* selected_session = NULL;
	GVariant* _tmp8_;
	const GVariantType* _tmp9_;
	GSimpleAction* _tmp10_;
	GVariantDict* _tmp11_;
	GList* _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp15_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = lightdm_get_sessions ();
	sessions = _tmp0_;
	_tmp1_ = sessions;
	_tmp2_ = g_list_nth_data (_tmp1_, (guint) 0);
	first_session = (LightDMSession*) _tmp2_;
	_tmp4_ = first_session;
	if (_tmp4_ != NULL) {
		LightDMSession* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = first_session;
		_tmp6_ = lightdm_session_get_key (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_;
	} else {
		_tmp3_ = "";
	}
	_tmp8_ = g_variant_new_string (_tmp3_);
	g_variant_ref_sink (_tmp8_);
	selected_session = _tmp8_;
	_tmp9_ = G_VARIANT_TYPE_STRING;
	_tmp10_ = g_simple_action_new_stateful ("select", _tmp9_, selected_session);
	_data1_->select_session_action = _tmp10_;
	_tmp11_ = g_variant_dict_new (NULL);
	_data1_->vardict = _tmp11_;
	_tmp12_ = sessions;
	g_list_foreach (_tmp12_, ___lambda20__gfunc, _data1_);
	_tmp13_ = g_variant_dict_end (_data1_->vardict);
	g_variant_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	g_simple_action_set_state_hint (_data1_->select_session_action, _tmp14_);
	_g_variant_unref0 (_tmp14_);
	g_signal_connect_data (_data1_->select_session_action, "activate", (GCallback) ___lambda21__g_simple_action_activate, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp15_ = g_simple_action_group_new ();
	action_group = _tmp15_;
	g_action_map_add_action ((GActionMap*) action_group, (GAction*) _data1_->select_session_action);
	gtk_widget_insert_action_group ((GtkWidget*) self, "session", (GActionGroup*) action_group);
	_g_object_unref0 (action_group);
	_g_variant_unref0 (selected_session);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
greeter_main_window_show_message (GreeterMainWindow* self,
                                  const gchar* text,
                                  LightDMMessageType type)
{
	GreeterFPrintUtilsMessageText messagetext = 0;
	GEnumValue* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	messagetext = greeter_fprint_utils_string_to_messagetext (text);
	switch (messagetext) {
		case GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_TIMEOUT:
		case GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_ERROR:
		case GREETER_FPRINT_UTILS_MESSAGE_TEXT_OTHER:
		{
			GreeterBaseCard* _tmp0_;
			_tmp0_ = self->priv->current_card;
			greeter_base_card_set_use_fingerprint (_tmp0_, FALSE);
			break;
		}
		default:
		{
			GreeterBaseCard* _tmp1_;
			_tmp1_ = self->priv->current_card;
			greeter_base_card_set_use_fingerprint (_tmp1_, TRUE);
			break;
		}
	}
	_tmp2_ = g_enum_get_value (g_type_class_ref (GREETER_FPRINT_UTILS_TYPE_MESSAGE_TEXT), messagetext);
	g_critical ("MainWindow.vala:327: message: `%s' (%d): %s", text, (gint) type, (_tmp2_ != NULL) ? _tmp2_->value_name : NULL);
}

static void
greeter_main_window_show_prompt (GreeterMainWindow* self,
                                 const gchar* text,
                                 LightDMPromptType type)
{
	GreeterBaseCard* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_critical ("MainWindow.vala:339: prompt: `%s' (%d)", text, (gint) type);
	_tmp0_ = self->priv->current_card;
	if (GREETER_IS_MANUAL_CARD (_tmp0_)) {
		if (type == LIGHTDM_PROMPT_TYPE_SECRET) {
			GreeterBaseCard* _tmp1_;
			_tmp1_ = self->priv->current_card;
			greeter_manual_card_ask_password (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GREETER_TYPE_MANUAL_CARD, GreeterManualCard));
		} else {
			GreeterBaseCard* _tmp2_;
			_tmp2_ = self->priv->current_card;
			greeter_manual_card_wrong_username (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GREETER_TYPE_MANUAL_CARD, GreeterManualCard));
		}
	}
}

static void
_gtk_widget_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
greeter_main_window_authentication_complete (GreeterMainWindow* self)
{
	GreeterUserCard* user_card = NULL;
	GreeterBaseCard* _tmp0_;
	GreeterUserCard* _tmp1_;
	GreeterUserCard* _tmp2_;
	LightDMGreeter* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GreeterUserCard* _tmp48_;
	GreeterBaseCard* _tmp57_;
	HdyCarousel* _tmp58_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_card;
	_tmp1_ = _g_object_ref0 (GREETER_IS_USER_CARD (_tmp0_) ? ((GreeterUserCard*) _tmp0_) : NULL);
	user_card = _tmp1_;
	_tmp2_ = user_card;
	if (_tmp2_ != NULL) {
		GreeterSettings* _tmp3_;
		GreeterUserCard* _tmp4_;
		LightDMUser* _tmp5_;
		LightDMUser* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp3_ = self->priv->settings;
		_tmp4_ = user_card;
		_tmp5_ = greeter_user_card_get_lightdm_user (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = lightdm_user_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		greeter_settings_set_last_user (_tmp3_, _tmp8_);
	}
	_tmp9_ = self->priv->lightdm_greeter;
	_tmp10_ = lightdm_greeter_get_is_authenticated (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		GreeterUserCard* _tmp12_;
		GActionGroup* action_group = NULL;
		GActionGroup* _tmp29_;
		GActionGroup* _tmp30_;
		_tmp12_ = user_card;
		if (_tmp12_ != NULL) {
			GreeterSettings* _tmp13_;
			GreeterUserCard* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			GreeterSettings* _tmp17_;
			GreeterUserCard* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			GreeterSettings* _tmp21_;
			GreeterUserCard* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			GreeterSettings* _tmp25_;
			GreeterUserCard* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			_tmp13_ = self->priv->settings;
			_tmp14_ = user_card;
			_tmp15_ = greeter_user_card_get_sleep_inactive_ac_timeout (_tmp14_);
			_tmp16_ = _tmp15_;
			greeter_settings_set_sleep_inactive_ac_timeout (_tmp13_, _tmp16_);
			_tmp17_ = self->priv->settings;
			_tmp18_ = user_card;
			_tmp19_ = greeter_user_card_get_sleep_inactive_ac_type (_tmp18_);
			_tmp20_ = _tmp19_;
			greeter_settings_set_sleep_inactive_ac_type (_tmp17_, _tmp20_);
			_tmp21_ = self->priv->settings;
			_tmp22_ = user_card;
			_tmp23_ = greeter_user_card_get_sleep_inactive_battery_timeout (_tmp22_);
			_tmp24_ = _tmp23_;
			greeter_settings_set_sleep_inactive_battery_timeout (_tmp21_, _tmp24_);
			_tmp25_ = self->priv->settings;
			_tmp26_ = user_card;
			_tmp27_ = greeter_user_card_get_sleep_inactive_battery_type (_tmp26_);
			_tmp28_ = _tmp27_;
			greeter_settings_set_sleep_inactive_battery_type (_tmp25_, _tmp28_);
		}
		_tmp29_ = gtk_widget_get_action_group ((GtkWidget*) self, "session");
		_tmp30_ = _g_object_ref0 (_tmp29_);
		action_group = _tmp30_;
		{
			const gchar* session = NULL;
			GActionGroup* _tmp31_;
			GVariant* _tmp32_;
			GVariant* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			LightDMGreeter* _tmp39_;
			const gchar* _tmp40_;
			_tmp31_ = action_group;
			_tmp32_ = g_action_group_get_action_state (_tmp31_, "select");
			_tmp33_ = _tmp32_;
			_tmp34_ = g_variant_get_string (_tmp33_, NULL);
			_tmp35_ = _tmp34_;
			_g_variant_unref0 (_tmp33_);
			session = _tmp35_;
			if (self->priv->installer_mode) {
				GFile* demo_mode_file = NULL;
				GFile* _tmp36_;
				GFile* _tmp37_;
				_tmp36_ = g_file_new_for_path ("/var/lib/lightdm/demo-mode");
				demo_mode_file = _tmp36_;
				_tmp37_ = demo_mode_file;
				if (g_file_query_exists (_tmp37_, NULL)) {
					GFile* _tmp38_;
					_tmp38_ = demo_mode_file;
					g_file_delete (_tmp38_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (demo_mode_file);
						goto __catch0_g_error;
					}
					session = "pantheon";
				} else {
					session = "installer";
				}
				_g_object_unref0 (demo_mode_file);
			}
			_tmp39_ = self->priv->lightdm_greeter;
			_tmp40_ = session;
			lightdm_greeter_start_session_sync (_tmp39_, _tmp40_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_g_object_unref0 (action_group);
			_g_object_unref0 (user_card);
			return;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GraniteMessageDialog* error_dialog = NULL;
			GraniteMessageDialog* _tmp41_;
			GraniteMessageDialog* _tmp42_;
			GError* _tmp43_;
			const gchar* _tmp44_;
			GraniteMessageDialog* _tmp45_;
			GraniteMessageDialog* _tmp46_;
			GraniteMessageDialog* _tmp47_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp41_ = granite_message_dialog_new_with_image_from_icon_name (_ ("Unable to Log In"), _ ("Starting the session has failed."), "dialog-error", GTK_BUTTONS_CLOSE);
			g_object_ref_sink (_tmp41_);
			error_dialog = _tmp41_;
			_tmp42_ = error_dialog;
			_tmp43_ = e;
			_tmp44_ = _tmp43_->message;
			granite_message_dialog_show_error_details (_tmp42_, _tmp44_);
			_tmp45_ = error_dialog;
			gtk_window_present ((GtkWindow*) _tmp45_);
			_tmp46_ = error_dialog;
			_tmp47_ = error_dialog;
			g_signal_connect_object ((GtkDialog*) _tmp46_, "response", (GCallback) _gtk_widget_destroy_gtk_dialog_response, (GtkWidget*) _tmp47_, 0);
			_g_object_unref0 (error_dialog);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (action_group);
			_g_object_unref0 (user_card);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_object_unref0 (action_group);
	}
	_tmp48_ = user_card;
	if (_tmp48_ != NULL) {
		{
			LightDMGreeter* _tmp49_;
			GreeterUserCard* _tmp50_;
			LightDMUser* _tmp51_;
			LightDMUser* _tmp52_;
			const gchar* _tmp53_;
			const gchar* _tmp54_;
			_tmp49_ = self->priv->lightdm_greeter;
			_tmp50_ = user_card;
			_tmp51_ = greeter_user_card_get_lightdm_user (_tmp50_);
			_tmp52_ = _tmp51_;
			_tmp53_ = lightdm_user_get_name (_tmp52_);
			_tmp54_ = _tmp53_;
			lightdm_greeter_authenticate (_tmp49_, _tmp54_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp55_;
			const gchar* _tmp56_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp55_ = e;
			_tmp56_ = _tmp55_->message;
			g_critical ("MainWindow.vala:405: %s", _tmp56_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (user_card);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp57_ = self->priv->current_card;
	greeter_base_card_wrong_credentials (_tmp57_);
	_tmp58_ = self->priv->carousel;
	hdy_carousel_set_interactive (_tmp58_, TRUE);
	_g_object_unref0 (user_card);
}

static void
greeter_main_window_load_users_data_free (gpointer _data)
{
	GreeterMainWindowLoadUsersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GreeterMainWindowLoadUsersData, _data_);
}

static void
greeter_main_window_load_users (GreeterMainWindow* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	GreeterMainWindowLoadUsersData* _data_;
	GreeterMainWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GreeterMainWindowLoadUsersData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, greeter_main_window_load_users_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	greeter_main_window_load_users_co (_data_);
}

static void
greeter_main_window_load_users_finish (GreeterMainWindow* self,
                                       GAsyncResult* _res_)
{
	GreeterMainWindowLoadUsersData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
greeter_main_window_load_users_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	GreeterMainWindowLoadUsersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	greeter_main_window_load_users_co (_data_);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GreeterMainWindow* self;
		self = _data2_->self;
		_g_free0 (_data2_->user_to_select);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
___lambda26_ (GreeterMainWindow* self,
              LightDMUser* user)
{
	g_return_if_fail (user != NULL);
	greeter_main_window_add_card (self, user);
}

static void
____lambda26__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda26_ ((GreeterMainWindow*) self, (LightDMUser*) data);
}

static void
____lambda30_ (Block2Data* _data2_,
               GreeterUserCard* card)
{
	GreeterMainWindow* self;
	LightDMUser* _tmp0_;
	LightDMUser* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = _data2_->self;
	g_return_if_fail (card != NULL);
	_tmp0_ = greeter_user_card_get_lightdm_user (card);
	_tmp1_ = _tmp0_;
	_tmp2_ = lightdm_user_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _data2_->user_to_select;
	if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
		greeter_main_window_switch_to_card (self, card);
		_data2_->user_selected = TRUE;
	}
}

static void
_____lambda30__gfunc (gconstpointer data,
                      gpointer self)
{
	____lambda30_ (self, (GreeterUserCard*) data);
}

static gboolean
___lambda31_ (GreeterMainWindow* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		GAppInfo* initial_setup = NULL;
		GAppInfo* _tmp0_;
		GAppInfo* _tmp1_;
		_tmp0_ = g_app_info_create_from_commandline ("io.elementary.initial-setup", NULL, G_APP_INFO_CREATE_NONE, &_inner_error0_);
		initial_setup = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = initial_setup;
		g_app_info_launch (_tmp1_, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (initial_setup);
			goto __catch0_g_error;
		}
		_g_object_unref0 (initial_setup);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* error_text = NULL;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		GraniteMessageDialog* error_dialog = NULL;
		const gchar* _tmp6_;
		GraniteMessageDialog* _tmp7_;
		GraniteMessageDialog* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		GraniteMessageDialog* _tmp11_;
		GraniteMessageDialog* _tmp12_;
		GraniteMessageDialog* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = g_strdup (_ ("Unable to Launch Initial Setup"));
		error_text = _tmp2_;
		_tmp3_ = error_text;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("MainWindow.vala:469: %s: %s", _tmp3_, _tmp5_);
		_tmp6_ = error_text;
		_tmp7_ = granite_message_dialog_new_with_image_from_icon_name (_tmp6_, _ ("Initial Setup creates your first user. Without it, you will not be abl" \
"e to log in and may need to reinstall the OS."), "dialog-error", GTK_BUTTONS_CLOSE);
		g_object_ref_sink (_tmp7_);
		error_dialog = _tmp7_;
		_tmp8_ = error_dialog;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		granite_message_dialog_show_error_details (_tmp8_, _tmp10_);
		_tmp11_ = error_dialog;
		gtk_window_present ((GtkWindow*) _tmp11_);
		_tmp12_ = error_dialog;
		_tmp13_ = error_dialog;
		g_signal_connect_object ((GtkDialog*) _tmp12_, "response", (GCallback) _gtk_widget_destroy_gtk_dialog_response, (GtkWidget*) _tmp13_, 0);
		_g_object_unref0 (error_dialog);
		_g_free0 (error_text);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp14_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp14_;
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda31__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda31_ ((GreeterMainWindow*) self);
	return result;
}

static gboolean
greeter_main_window_load_users_co (GreeterMainWindowLoadUsersData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->lightdm_greeter;
		_data_->_state_ = 1;
		lightdm_greeter_connect_to_daemon (_data_->_tmp0_, NULL, greeter_main_window_load_users_ready, _data_);
		return FALSE;
		_state_1:
		lightdm_greeter_connect_to_daemon_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp1_ = _data_->e;
		_data_->_tmp2_ = _data_->_tmp1_->message;
		g_critical ("MainWindow.vala:418: %s", _data_->_tmp2_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->self->priv->lightdm_greeter;
	g_object_notify ((GObject*) _data_->_tmp3_, "show-manual-login-hint");
	_data_->_tmp4_ = _data_->self->priv->lightdm_greeter;
	g_object_notify ((GObject*) _data_->_tmp4_, "has-guest-account-hint");
	_data_->_tmp5_ = _data_->self->priv->lightdm_greeter;
	_data_->_tmp6_ = lightdm_greeter_get_default_session_hint (_data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	if (_data_->_tmp7_ != NULL) {
		_data_->_tmp8_ = gtk_widget_get_action_group ((GtkWidget*) _data_->self, "session");
		_data_->_tmp9_ = _data_->self->priv->lightdm_greeter;
		_data_->_tmp10_ = lightdm_greeter_get_default_session_hint (_data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = g_variant_new_string (_data_->_tmp11_);
		g_variant_ref_sink (_data_->_tmp12_);
		_data_->_tmp13_ = _data_->_tmp12_;
		g_action_group_activate_action (_data_->_tmp8_, "select", _data_->_tmp13_);
		_g_variant_unref0 (_data_->_tmp13_);
	}
	_data_->_tmp14_ = g_desktop_app_info_new ("io.elementary.installer.desktop");
	_data_->installer_desktop = _data_->_tmp14_;
	_data_->_tmp15_ = _data_->installer_desktop;
	if (_data_->_tmp15_ != NULL) {
		_data_->self->priv->installer_mode = TRUE;
	}
	_data_->_tmp16_ = _data_->self->priv->lightdm_user_list;
	_data_->_tmp17_ = lightdm_user_list_get_length (_data_->_tmp16_);
	_data_->_tmp18_ = _data_->_tmp17_;
	if (_data_->_tmp18_ > 0) {
		_data_->_data2_ = g_slice_new0 (Block2Data);
		_data_->_data2_->_ref_count_ = 1;
		_data_->_data2_->self = g_object_ref (_data_->self);
		_data_->_tmp19_ = _data_->self->priv->datetime_widget;
		gtk_revealer_set_reveal_child ((GtkRevealer*) _data_->_tmp19_, TRUE);
		_data_->_tmp20_ = _data_->self->priv->lightdm_user_list;
		_data_->_tmp21_ = lightdm_user_list_get_users (_data_->_tmp20_);
		_data_->_tmp22_ = _data_->_tmp21_;
		g_list_foreach (_data_->_tmp22_, ____lambda26__gfunc, _data_->self);
		_data_->_tmp23_ = _data_->self->priv->lightdm_greeter;
		_data_->_tmp24_ = lightdm_greeter_get_select_user_hint (_data_->_tmp23_);
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->select_user = _data_->_tmp25_;
		_data_->_tmp27_ = _data_->select_user;
		if (_data_->_tmp27_ != NULL) {
			_data_->_tmp28_ = _data_->select_user;
			_data_->_tmp29_ = g_strdup (_data_->_tmp28_);
			_g_free0 (_data_->_tmp26_);
			_data_->_tmp26_ = _data_->_tmp29_;
		} else {
			_data_->_tmp30_ = _data_->self->priv->settings;
			_data_->_tmp31_ = greeter_settings_get_last_user (_data_->_tmp30_);
			_data_->_tmp32_ = _data_->_tmp31_;
			_g_free0 (_data_->_tmp26_);
			_data_->_tmp26_ = _data_->_tmp32_;
		}
		_data_->_tmp33_ = g_strdup (_data_->_tmp26_);
		_data_->_data2_->user_to_select = _data_->_tmp33_;
		_data_->_data2_->user_selected = FALSE;
		_data_->_tmp34_ = _data_->_data2_->user_to_select;
		if (_data_->_tmp34_ != NULL) {
			_data_->_tmp35_ = _data_->self->priv->user_cards;
			_data_->_tmp36_ = _data_->_tmp35_->head;
			g_list_foreach (_data_->_tmp36_, _____lambda30__gfunc, _data_->_data2_);
		}
		if (!_data_->_data2_->user_selected) {
			_data_->_tmp37_ = _data_->self->priv->user_cards;
			_data_->_tmp38_ = g_queue_peek_head (_data_->_tmp37_);
			_data_->user_card = (GreeterUserCard*) _data_->_tmp38_;
			_data_->_tmp39_ = _data_->user_card;
			greeter_user_card_set_show_input (_data_->_tmp39_, TRUE);
			_data_->_tmp40_ = _data_->user_card;
			greeter_main_window_switch_to_card (_data_->self, _data_->_tmp40_);
		}
		_g_free0 (_data_->_tmp26_);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
	} else {
		_data_->_tmp41_ = _data_->self->priv->datetime_widget;
		gtk_revealer_set_reveal_child ((GtkRevealer*) _data_->_tmp41_, FALSE);
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda31__gsource_func, g_object_ref (_data_->self), g_object_unref);
	}
	_data_->_tmp42_ = _data_->self->priv->lightdm_greeter;
	g_object_notify ((GObject*) _data_->_tmp42_, "hide-users-hint");
	_g_object_unref0 (_data_->installer_desktop);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		GreeterMainWindow* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->user_card);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda27_ (Block3Data* _data3_)
{
	GreeterMainWindow* self;
	self = _data3_->self;
	greeter_main_window_switch_to_card (self, _data3_->user_card);
}

static void
___lambda27__greeter_user_card_focus_requested (GreeterUserCard* _sender,
                                                gpointer self)
{
	__lambda27_ (self);
}

static void
__lambda28_ (GreeterMainWindow* self)
{
	GtkStyleContext* _tmp0_;
	GtkTextDirection _tmp1_;
	GtkTextDirection _tmp2_;
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = gtk_style_context_get_direction (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == GTK_TEXT_DIR_LTR) {
		greeter_main_window_go_previous (self);
	} else {
		greeter_main_window_go_next (self);
	}
}

static void
___lambda28__greeter_user_card_go_left (GreeterUserCard* _sender,
                                        gpointer self)
{
	__lambda28_ ((GreeterMainWindow*) self);
}

static void
__lambda29_ (GreeterMainWindow* self)
{
	GtkStyleContext* _tmp0_;
	GtkTextDirection _tmp1_;
	GtkTextDirection _tmp2_;
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = gtk_style_context_get_direction (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == GTK_TEXT_DIR_LTR) {
		greeter_main_window_go_next (self);
	} else {
		greeter_main_window_go_previous (self);
	}
}

static void
___lambda29__greeter_user_card_go_right (GreeterUserCard* _sender,
                                         gpointer self)
{
	__lambda29_ ((GreeterMainWindow*) self);
}

static void
_greeter_main_window_do_connect_greeter_base_card_do_connect (GreeterBaseCard* _sender,
                                                              const gchar* credential,
                                                              gpointer self)
{
	greeter_main_window_do_connect ((GreeterMainWindow*) self, credential);
}

static void
greeter_main_window_add_card (GreeterMainWindow* self,
                              LightDMUser* lightdm_user)
{
	Block3Data* _data3_;
	GreeterUserCard* _tmp0_;
	HdyCarousel* _tmp1_;
	GtkSizeGroup* _tmp2_;
	GQueue* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (lightdm_user != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = greeter_user_card_new (lightdm_user);
	g_object_ref_sink (_tmp0_);
	_data3_->user_card = _tmp0_;
	gtk_widget_show_all ((GtkWidget*) _data3_->user_card);
	_tmp1_ = self->priv->carousel;
	gtk_container_add ((GtkContainer*) _tmp1_, (GtkWidget*) _data3_->user_card);
	g_signal_connect_data (_data3_->user_card, "focus-requested", (GCallback) ___lambda27__greeter_user_card_focus_requested, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	g_signal_connect_object (_data3_->user_card, "go-left", (GCallback) ___lambda28__greeter_user_card_go_left, self, 0);
	g_signal_connect_object (_data3_->user_card, "go-right", (GCallback) ___lambda29__greeter_user_card_go_right, self, 0);
	g_signal_connect_object ((GreeterBaseCard*) _data3_->user_card, "do-connect", (GCallback) _greeter_main_window_do_connect_greeter_base_card_do_connect, self, 0);
	_tmp2_ = self->priv->card_size_group;
	gtk_size_group_add_widget (_tmp2_, (GtkWidget*) _data3_->user_card);
	_tmp3_ = self->priv->user_cards;
	g_queue_push_tail (_tmp3_, _data3_->user_card);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
greeter_main_window_switch_to_card (GreeterMainWindow* self,
                                    GreeterUserCard* user_card)
{
	HdyCarousel* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	GreeterBaseCard* _tmp4_;
	GBinding* _tmp7_;
	GreeterDateTimeWidget* _tmp10_;
	GBinding* _tmp11_;
	HdyCarousel* _tmp12_;
	LightDMUser* _tmp13_;
	LightDMUser* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	LightDMGreeter* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (user_card != NULL);
	_tmp0_ = self->priv->carousel;
	_tmp1_ = hdy_carousel_get_interactive (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp4_ = self->priv->current_card;
	if (_tmp4_ != NULL) {
		GreeterBaseCard* _tmp5_;
		_tmp5_ = self->priv->current_card;
		_tmp3_ = GREETER_IS_USER_CARD (_tmp5_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GreeterBaseCard* _tmp6_;
		_tmp6_ = self->priv->current_card;
		greeter_user_card_set_show_input (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GREETER_TYPE_USER_CARD, GreeterUserCard), FALSE);
	}
	_tmp7_ = self->priv->time_format_binding;
	if (_tmp7_ != NULL) {
		GBinding* _tmp8_;
		GBinding* _tmp9_;
		_tmp8_ = self->priv->time_format_binding;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		g_binding_unbind (_tmp9_);
	}
	_tmp10_ = self->priv->datetime_widget;
	_tmp11_ = g_object_bind_property_with_closures ((GObject*) user_card, "is-24h", (GObject*) _tmp10_, "is-24h", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	self->priv->time_format_binding = _tmp11_;
	self->priv->current_card = (GreeterBaseCard*) user_card;
	_tmp12_ = self->priv->carousel;
	hdy_carousel_scroll_to (_tmp12_, (GtkWidget*) user_card);
	greeter_user_card_set_settings (user_card);
	greeter_user_card_set_show_input (user_card, TRUE);
	gtk_widget_grab_focus ((GtkWidget*) user_card);
	_tmp13_ = greeter_user_card_get_lightdm_user (user_card);
	_tmp14_ = _tmp13_;
	_tmp15_ = lightdm_user_get_session (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		GActionGroup* _tmp17_;
		LightDMUser* _tmp18_;
		LightDMUser* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		GVariant* _tmp22_;
		GVariant* _tmp23_;
		_tmp17_ = gtk_widget_get_action_group ((GtkWidget*) self, "session");
		_tmp18_ = greeter_user_card_get_lightdm_user (user_card);
		_tmp19_ = _tmp18_;
		_tmp20_ = lightdm_user_get_session (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_variant_new_string (_tmp21_);
		g_variant_ref_sink (_tmp22_);
		_tmp23_ = _tmp22_;
		g_action_group_activate_action (_tmp17_, "select", _tmp23_);
		_g_variant_unref0 (_tmp23_);
	}
	_tmp24_ = self->priv->lightdm_greeter;
	_tmp25_ = lightdm_greeter_get_in_authentication (_tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_) {
		{
			LightDMGreeter* _tmp27_;
			_tmp27_ = self->priv->lightdm_greeter;
			lightdm_greeter_cancel_authentication (_tmp27_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp28_;
			const gchar* _tmp29_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp28_ = e;
			_tmp29_ = _tmp28_->message;
			g_critical ("MainWindow.vala:552: %s", _tmp29_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		LightDMGreeter* _tmp30_;
		LightDMUser* _tmp31_;
		LightDMUser* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		_tmp30_ = self->priv->lightdm_greeter;
		_tmp31_ = greeter_user_card_get_lightdm_user (user_card);
		_tmp32_ = _tmp31_;
		_tmp33_ = lightdm_user_get_name (_tmp32_);
		_tmp34_ = _tmp33_;
		lightdm_greeter_authenticate (_tmp30_, _tmp34_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp35_;
		const gchar* _tmp36_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp35_ = e;
		_tmp36_ = _tmp35_->message;
		g_critical ("MainWindow.vala:559: %s", _tmp36_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
greeter_main_window_do_connect_username (GreeterMainWindow* self,
                                         const gchar* username)
{
	LightDMGreeter* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (username != NULL);
	_tmp0_ = self->priv->lightdm_greeter;
	_tmp1_ = lightdm_greeter_get_in_authentication (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		{
			LightDMGreeter* _tmp3_;
			_tmp3_ = self->priv->lightdm_greeter;
			lightdm_greeter_cancel_authentication (_tmp3_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_critical ("MainWindow.vala:568: %s", _tmp5_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		LightDMGreeter* _tmp6_;
		_tmp6_ = self->priv->lightdm_greeter;
		lightdm_greeter_authenticate (_tmp6_, username, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_critical ("MainWindow.vala:575: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
greeter_main_window_do_connect (GreeterMainWindow* self,
                                const gchar* credential)
{
	HdyCarousel* _tmp3_;
	HdyCarousel* _tmp4_;
	GreeterBaseCard* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (credential != NULL) {
		{
			LightDMGreeter* _tmp0_;
			_tmp0_ = self->priv->lightdm_greeter;
			lightdm_greeter_respond (_tmp0_, credential, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp1_;
			const gchar* _tmp2_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp1_ = e;
			_tmp2_ = _tmp1_->message;
			g_critical ("MainWindow.vala:584: %s", _tmp2_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp3_ = self->priv->carousel;
	hdy_carousel_set_interactive (_tmp3_, FALSE);
	_tmp4_ = self->priv->carousel;
	_tmp5_ = self->priv->current_card;
	hdy_carousel_scroll_to (_tmp4_, (GtkWidget*) _tmp5_);
}

static void
greeter_main_window_go_previous (GreeterMainWindow* self)
{
	HdyCarousel* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GreeterUserCard* next_card = NULL;
	GQueue* _tmp3_;
	gconstpointer _tmp4_;
	GreeterUserCard* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carousel;
	_tmp1_ = hdy_carousel_get_interactive (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->user_cards;
	_tmp4_ = g_queue_peek_nth (_tmp3_, (guint) (self->priv->current_user_card_index - 1));
	next_card = (GreeterUserCard*) _tmp4_;
	_tmp5_ = next_card;
	if (_tmp5_ != NULL) {
		HdyCarousel* _tmp6_;
		GreeterUserCard* _tmp7_;
		_tmp6_ = self->priv->carousel;
		_tmp7_ = next_card;
		hdy_carousel_scroll_to (_tmp6_, (GtkWidget*) _tmp7_);
	}
}

static void
greeter_main_window_go_next (GreeterMainWindow* self)
{
	HdyCarousel* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GreeterUserCard* next_card = NULL;
	GQueue* _tmp3_;
	gconstpointer _tmp4_;
	GreeterUserCard* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carousel;
	_tmp1_ = hdy_carousel_get_interactive (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->user_cards;
	_tmp4_ = g_queue_peek_nth (_tmp3_, (guint) (self->priv->current_user_card_index + 1));
	next_card = (GreeterUserCard*) _tmp4_;
	_tmp5_ = next_card;
	if (_tmp5_ != NULL) {
		HdyCarousel* _tmp6_;
		GreeterUserCard* _tmp7_;
		_tmp6_ = self->priv->carousel;
		_tmp7_ = next_card;
		hdy_carousel_scroll_to (_tmp6_, (GtkWidget*) _tmp7_);
	}
}

GreeterMainWindow*
greeter_main_window_construct (GType object_type)
{
	GreeterMainWindow * self = NULL;
	self = (GreeterMainWindow*) g_object_new (object_type, NULL);
	return self;
}

GreeterMainWindow*
greeter_main_window_new (void)
{
	return greeter_main_window_construct (GREETER_TYPE_MAIN_WINDOW);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		GreeterMainWindow* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->manual_login_stack);
		_g_object_unref0 (_data4_->manual_card);
		_g_object_unref0 (_data4_->extra_login_grid);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_greeter_main_window___lambda32_ (Block4Data* _data4_)
{
	GreeterMainWindow* self;
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GError* _inner_error0_ = NULL;
	self = _data4_->self;
	_tmp0_ = self->priv->manual_login_button;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		LightDMGreeter* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		GtkStack* _tmp9_;
		GreeterManualCard* _tmp10_;
		GreeterManualCard* _tmp11_;
		_tmp3_ = self->priv->lightdm_greeter;
		_tmp4_ = lightdm_greeter_get_in_authentication (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			{
				LightDMGreeter* _tmp6_;
				_tmp6_ = self->priv->lightdm_greeter;
				lightdm_greeter_cancel_authentication (_tmp6_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp7_;
				const gchar* _tmp8_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp7_ = e;
				_tmp8_ = _tmp7_->message;
				g_critical ("MainWindow.vala:109: %s", _tmp8_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp9_ = _data4_->manual_login_stack;
		_tmp10_ = _data4_->manual_card;
		gtk_stack_set_visible_child (_tmp9_, (GtkWidget*) _tmp10_);
		_tmp11_ = _data4_->manual_card;
		self->priv->current_card = (GreeterBaseCard*) _tmp11_;
	} else {
		LightDMGreeter* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		GtkStack* _tmp18_;
		HdyCarousel* _tmp19_;
		GQueue* _tmp20_;
		gconstpointer _tmp21_;
		_tmp12_ = self->priv->lightdm_greeter;
		_tmp13_ = lightdm_greeter_get_in_authentication (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_) {
			{
				LightDMGreeter* _tmp15_;
				_tmp15_ = self->priv->lightdm_greeter;
				lightdm_greeter_cancel_authentication (_tmp15_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp16_;
				const gchar* _tmp17_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp16_ = e;
				_tmp17_ = _tmp16_->message;
				g_critical ("MainWindow.vala:120: %s", _tmp17_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp18_ = _data4_->manual_login_stack;
		_tmp19_ = self->priv->carousel;
		gtk_stack_set_visible_child (_tmp18_, (GtkWidget*) _tmp19_);
		_tmp20_ = self->priv->user_cards;
		_tmp21_ = g_queue_peek_nth (_tmp20_, (guint) self->priv->current_user_card_index);
		self->priv->current_card = (GreeterBaseCard*) ((GreeterUserCard*) _tmp21_);
		{
			LightDMGreeter* _tmp22_;
			GreeterBaseCard* _tmp23_;
			LightDMUser* _tmp24_;
			LightDMUser* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			_tmp22_ = self->priv->lightdm_greeter;
			_tmp23_ = self->priv->current_card;
			_tmp24_ = greeter_user_card_get_lightdm_user (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GREETER_TYPE_USER_CARD, GreeterUserCard));
			_tmp25_ = _tmp24_;
			_tmp26_ = lightdm_user_get_name (_tmp25_);
			_tmp27_ = _tmp26_;
			lightdm_greeter_authenticate (_tmp22_, _tmp27_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			GError* _tmp28_;
			const gchar* _tmp29_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp28_ = e;
			_tmp29_ = _tmp28_->message;
			g_critical ("MainWindow.vala:130: %s", _tmp29_);
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
__greeter_main_window___lambda32__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                             gpointer self)
{
	_greeter_main_window___lambda32_ (self);
}

static void
_greeter_main_window___lambda33_ (GreeterMainWindow* self)
{
	GError* _inner_error0_ = NULL;
	{
		LightDMGreeter* _tmp0_;
		_tmp0_ = self->priv->lightdm_greeter;
		lightdm_greeter_authenticate_as_guest (_tmp0_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("MainWindow.vala:139: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__greeter_main_window___lambda33__gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self)
{
	_greeter_main_window___lambda33_ ((GreeterMainWindow*) self);
}

static void
_greeter_main_window_show_message_lightdm_greeter_show_message (LightDMGreeter* _sender,
                                                                const gchar* text,
                                                                LightDMMessageType type,
                                                                gpointer self)
{
	greeter_main_window_show_message ((GreeterMainWindow*) self, text, type);
}

static void
_greeter_main_window_show_prompt_lightdm_greeter_show_prompt (LightDMGreeter* _sender,
                                                              const gchar* text,
                                                              LightDMPromptType type,
                                                              gpointer self)
{
	greeter_main_window_show_prompt ((GreeterMainWindow*) self, text, type);
}

static void
_greeter_main_window_authentication_complete_lightdm_greeter_authentication_complete (LightDMGreeter* _sender,
                                                                                      gpointer self)
{
	greeter_main_window_authentication_complete ((GreeterMainWindow*) self);
}

static void
_greeter_main_window___lambda34_ (Block4Data* _data4_)
{
	GreeterMainWindow* self;
	gboolean _tmp0_ = FALSE;
	LightDMGreeter* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data4_->self;
	_tmp1_ = self->priv->lightdm_greeter;
	_tmp2_ = lightdm_greeter_get_has_guest_account_hint (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GtkButton* _tmp4_;
		GtkContainer* _tmp5_;
		GtkContainer* _tmp6_;
		_tmp4_ = self->priv->guest_login_button;
		_tmp5_ = gtk_widget_get_parent ((GtkWidget*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkGrid* _tmp7_;
		GtkButton* _tmp8_;
		GtkButton* _tmp9_;
		_tmp7_ = _data4_->extra_login_grid;
		_tmp8_ = self->priv->guest_login_button;
		gtk_grid_attach (_tmp7_, (GtkWidget*) _tmp8_, 0, 0, 1, 1);
		_tmp9_ = self->priv->guest_login_button;
		gtk_widget_show ((GtkWidget*) _tmp9_);
	}
}

static void
__greeter_main_window___lambda34__g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	_greeter_main_window___lambda34_ (self);
}

static void
_greeter_main_window___lambda35_ (Block4Data* _data4_)
{
	GreeterMainWindow* self;
	gboolean _tmp0_ = FALSE;
	LightDMGreeter* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data4_->self;
	_tmp1_ = self->priv->lightdm_greeter;
	_tmp2_ = lightdm_greeter_get_show_manual_login_hint (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GtkToggleButton* _tmp4_;
		GtkContainer* _tmp5_;
		GtkContainer* _tmp6_;
		_tmp4_ = self->priv->manual_login_button;
		_tmp5_ = gtk_widget_get_parent ((GtkWidget*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkGrid* _tmp7_;
		GtkToggleButton* _tmp8_;
		GtkToggleButton* _tmp9_;
		_tmp7_ = _data4_->extra_login_grid;
		_tmp8_ = self->priv->manual_login_button;
		gtk_grid_attach (_tmp7_, (GtkWidget*) _tmp8_, 1, 0, 1, 1);
		_tmp9_ = self->priv->manual_login_button;
		gtk_widget_show ((GtkWidget*) _tmp9_);
	}
}

static void
__greeter_main_window___lambda35__g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	_greeter_main_window___lambda35_ (self);
}

static void
_greeter_main_window___lambda36_ (GreeterMainWindow* self)
{
	greeter_main_window_maximize_window (self);
}

static void
__greeter_main_window___lambda36__g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	_greeter_main_window___lambda36_ ((GreeterMainWindow*) self);
}

static void
_greeter_main_window___lambda37_ (GreeterMainWindow* self)
{
	greeter_main_window_load_users (self, NULL, NULL);
}

static void
__greeter_main_window___lambda37__lightdm_user_list_user_added (LightDMUserList* _sender,
                                                                LightDMUser* user,
                                                                gpointer self)
{
	_greeter_main_window___lambda37_ ((GreeterMainWindow*) self);
}

static void
_greeter_main_window_do_connect_username_greeter_manual_card_do_connect_username (GreeterManualCard* _sender,
                                                                                  const gchar* username,
                                                                                  gpointer self)
{
	greeter_main_window_do_connect_username ((GreeterMainWindow*) self, username);
}

static gboolean
_vala_uint_array_contains (guint * stack,
                           gssize stack_length,
                           const guint needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
_greeter_main_window___lambda38_ (GreeterMainWindow* self,
                                  GdkEventKey* event)
{
	GreeterBaseCard* _tmp7_;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	if (!_vala_uint_array_contains (GREETER_MAIN_WINDOW_NAVIGATION_KEYS, G_N_ELEMENTS (GREETER_MAIN_WINDOW_NAVIGATION_KEYS), event->keyval)) {
		GtkWidget* current_focus = NULL;
		GtkWidget* _tmp0_;
		gboolean _tmp1_ = FALSE;
		_tmp0_ = gtk_window_get_focus ((GtkWindow*) self);
		current_focus = _tmp0_;
		if (event->is_modifier == ((guint) 0)) {
			gboolean _tmp2_ = FALSE;
			GtkWidget* _tmp3_;
			_tmp3_ = current_focus;
			if (_tmp3_ == NULL) {
				_tmp2_ = TRUE;
			} else {
				GtkWidget* _tmp4_;
				GreeterBaseCard* _tmp5_;
				_tmp4_ = current_focus;
				_tmp5_ = self->priv->current_card;
				_tmp2_ = !gtk_widget_is_ancestor (_tmp4_, (GtkWidget*) _tmp5_);
			}
			_tmp1_ = _tmp2_;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			GreeterBaseCard* _tmp6_;
			_tmp6_ = self->priv->current_card;
			gtk_widget_grab_focus ((GtkWidget*) _tmp6_);
		}
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp7_ = self->priv->current_card;
	if (GREETER_IS_USER_CARD (_tmp7_)) {
		GtkEntry* focused_entry = NULL;
		GtkWidget* _tmp8_;
		gboolean _tmp9_ = FALSE;
		GtkEntry* _tmp10_;
		_tmp8_ = gtk_window_get_focus ((GtkWindow*) self);
		focused_entry = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_entry_get_type (), GtkEntry);
		_tmp10_ = focused_entry;
		if (_tmp10_ != NULL) {
			GtkEntry* _tmp11_;
			GreeterBaseCard* _tmp12_;
			_tmp11_ = focused_entry;
			_tmp12_ = self->priv->current_card;
			_tmp9_ = gtk_widget_is_ancestor ((GtkWidget*) _tmp11_, (GtkWidget*) _tmp12_);
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			GtkEntry* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp13_ = focused_entry;
			_tmp14_ = gtk_entry_get_text (_tmp13_);
			_tmp15_ = _tmp14_;
			if (g_strcmp0 (_tmp15_, "") == 0) {
				if (event->keyval == GDK_KEY_Left) {
					GtkStyleContext* _tmp16_;
					GtkTextDirection _tmp17_;
					GtkTextDirection _tmp18_;
					_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) self);
					_tmp17_ = gtk_style_context_get_direction (_tmp16_);
					_tmp18_ = _tmp17_;
					if (_tmp18_ == GTK_TEXT_DIR_LTR) {
						greeter_main_window_go_previous (self);
					} else {
						greeter_main_window_go_next (self);
					}
					result = GDK_EVENT_STOP;
					return result;
				} else {
					if (event->keyval == GDK_KEY_Right) {
						GtkStyleContext* _tmp19_;
						GtkTextDirection _tmp20_;
						GtkTextDirection _tmp21_;
						_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) self);
						_tmp20_ = gtk_style_context_get_direction (_tmp19_);
						_tmp21_ = _tmp20_;
						if (_tmp21_ == GTK_TEXT_DIR_LTR) {
							greeter_main_window_go_next (self);
						} else {
							greeter_main_window_go_previous (self);
						}
						result = GDK_EVENT_STOP;
						return result;
					}
				}
			}
		}
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
__greeter_main_window___lambda38__gtk_widget_key_press_event (GtkWidget* _sender,
                                                              GdkEventKey* event,
                                                              gpointer self)
{
	gboolean result;
	result = _greeter_main_window___lambda38_ ((GreeterMainWindow*) self, event);
	return result;
}

static void
_greeter_main_window___lambda39_ (GreeterMainWindow* self,
                                  guint index)
{
	GList* children = NULL;
	HdyCarousel* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	_tmp0_ = self->priv->carousel;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	children = _tmp1_;
	_tmp2_ = children;
	_tmp3_ = g_list_nth_data (_tmp2_, index);
	if (GREETER_IS_USER_CARD ((GtkWidget*) _tmp3_)) {
		GList* _tmp4_;
		gconstpointer _tmp5_;
		self->priv->current_user_card_index = (gint) index;
		_tmp4_ = children;
		_tmp5_ = g_list_nth_data (_tmp4_, index);
		greeter_main_window_switch_to_card (self, G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp5_, GREETER_TYPE_USER_CARD, GreeterUserCard));
	}
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
}

static void
__greeter_main_window___lambda39__hdy_carousel_page_changed (HdyCarousel* _sender,
                                                             guint index,
                                                             gpointer self)
{
	_greeter_main_window___lambda39_ ((GreeterMainWindow*) self, index);
}

static void
_greeter_main_window___lambda40_ (GreeterMainWindow* self)
{
	greeter_main_window_maximize_and_focus (self);
}

static void
__greeter_main_window___lambda40__gdk_screen_monitors_changed (GdkScreen* _sender,
                                                               gpointer self)
{
	_greeter_main_window___lambda40_ ((GreeterMainWindow*) self);
}

static gboolean
_greeter_main_window___lambda41_ (GreeterMainWindow* self)
{
	gboolean result;
	greeter_main_window_maximize_and_focus (self);
	result = FALSE;
	return result;
}

static gboolean
__greeter_main_window___lambda41__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                 GdkEventCrossing* event,
                                                                 gpointer self)
{
	gboolean result;
	result = _greeter_main_window___lambda41_ ((GreeterMainWindow*) self);
	return result;
}

static void
_greeter_main_window___lambda42_ (GreeterMainWindow* self)
{
	gtk_main_quit ();
}

static void
__greeter_main_window___lambda42__gtk_widget_destroy (GtkWidget* _sender,
                                                      gpointer self)
{
	_greeter_main_window___lambda42_ ((GreeterMainWindow*) self);
}

static gboolean
__lambda44_ (GreeterMainWindow* self)
{
	gboolean result;
	greeter_main_window_maximize_and_focus (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda44__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda44_ ((GreeterMainWindow*) self);
	return result;
}

static void
_greeter_main_window___lambda43_ (GreeterMainWindow* self)
{
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda44__gsource_func, g_object_ref (self), g_object_unref);
}

static void
__greeter_main_window___lambda43__gasync_ready_callback (GObject* source_object,
                                                         GAsyncResult* res,
                                                         gpointer self)
{
	_greeter_main_window___lambda43_ ((GreeterMainWindow*) self);
	g_object_unref (self);
}

static GObject *
greeter_main_window_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GreeterMainWindow * self;
	Block4Data* _data4_;
	GtkStyleContext* _tmp0_;
	GtkCssProvider* _tmp1_;
	GreeterSettings* _tmp2_;
	GdkScreen* _tmp3_;
	GdkVisual* _tmp4_;
	GtkButton* _tmp5_;
	GtkToggleButton* _tmp6_;
	GtkGrid* _tmp7_;
	GtkGrid* _tmp8_;
	GtkGrid* _tmp9_;
	GtkGrid* _tmp10_;
	GtkGrid* _tmp11_;
	GreeterDateTimeWidget* _tmp12_;
	GreeterDateTimeWidget* _tmp13_;
	GQueue* _tmp14_;
	GreeterManualCard* _tmp15_;
	HdyCarousel* _tmp16_ = NULL;
	GtkStack* _tmp17_ = NULL;
	GtkStack* _tmp18_;
	HdyCarousel* _tmp19_;
	GtkStack* _tmp20_;
	GreeterManualCard* _tmp21_;
	GtkBox* main_box = NULL;
	GtkBox* _tmp22_ = NULL;
	GtkBox* _tmp23_;
	GreeterDateTimeWidget* _tmp24_;
	GtkBox* _tmp25_;
	GtkStack* _tmp26_;
	GtkBox* _tmp27_;
	GtkGrid* _tmp28_;
	GtkBox* _tmp29_;
	GtkToggleButton* _tmp30_;
	GtkButton* _tmp31_;
	GtkSizeGroup* _tmp32_;
	GtkSizeGroup* _tmp33_;
	GtkGrid* _tmp34_;
	GtkSizeGroup* _tmp35_;
	GreeterManualCard* _tmp36_;
	LightDMGreeter* _tmp37_;
	LightDMGreeter* _tmp38_;
	LightDMGreeter* _tmp39_;
	LightDMGreeter* _tmp40_;
	LightDMGreeter* _tmp41_;
	LightDMGreeter* _tmp42_;
	LightDMGreeter* _tmp43_;
	GtkToggleButton* _tmp44_;
	LightDMGreeter* _tmp45_;
	GtkToggleButton* _tmp46_;
	LightDMUserList* _tmp47_;
	LightDMUserList* _tmp48_;
	GreeterManualCard* _tmp49_;
	GreeterManualCard* _tmp50_;
	HdyCarousel* _tmp51_;
	GdkScreen* _tmp52_;
	GreeterSettings* _tmp53_;
	gboolean _tmp54_;
	gboolean _tmp55_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (greeter_main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_TYPE_MAIN_WINDOW, GreeterMainWindow);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	gtk_widget_set_app_paintable ((GtkWidget*) self, TRUE);
	gtk_window_set_decorated ((GtkWindow*) self, FALSE);
	gtk_window_set_type_hint ((GtkWindow*) self, GDK_WINDOW_TYPE_HINT_DESKTOP);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = greeter_main_window_css_provider;
	gtk_style_context_add_provider (_tmp0_, (GtkStyleProvider*) _tmp1_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp2_ = greeter_settings_new ();
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp2_;
	greeter_main_window_create_session_selection_action (self);
	_tmp3_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp4_ = gdk_screen_get_rgba_visual (_tmp3_);
	gtk_widget_set_visual ((GtkWidget*) self, _tmp4_);
	_tmp5_ = (GtkButton*) gtk_button_new_with_label (_ ("Log in as Guest"));
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->guest_login_button);
	self->priv->guest_login_button = _tmp5_;
	_tmp6_ = (GtkToggleButton*) gtk_toggle_button_new_with_label (_ ("Manual Login…"));
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->manual_login_button);
	self->priv->manual_login_button = _tmp6_;
	_tmp7_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp7_);
	_data4_->extra_login_grid = _tmp7_;
	_tmp8_ = _data4_->extra_login_grid;
	gtk_widget_set_halign ((GtkWidget*) _tmp8_, GTK_ALIGN_CENTER);
	_tmp9_ = _data4_->extra_login_grid;
	gtk_widget_set_valign ((GtkWidget*) _tmp9_, GTK_ALIGN_END);
	_tmp10_ = _data4_->extra_login_grid;
	gtk_grid_set_column_spacing (_tmp10_, 12);
	_tmp11_ = _data4_->extra_login_grid;
	gtk_grid_set_column_homogeneous (_tmp11_, TRUE);
	_tmp12_ = greeter_date_time_widget_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->datetime_widget);
	self->priv->datetime_widget = _tmp12_;
	_tmp13_ = self->priv->datetime_widget;
	gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_CENTER);
	_tmp14_ = g_queue_new ();
	(self->priv->user_cards == NULL) ? NULL : (self->priv->user_cards = (g_queue_free (self->priv->user_cards), NULL));
	self->priv->user_cards = _tmp14_;
	_tmp15_ = greeter_manual_card_new ();
	g_object_ref_sink (_tmp15_);
	_data4_->manual_card = _tmp15_;
	_tmp16_ = (HdyCarousel*) hdy_carousel_new ();
	hdy_carousel_set_allow_long_swipes (_tmp16_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp16_, TRUE);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->carousel);
	self->priv->carousel = _tmp16_;
	_tmp17_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_transition_type (_tmp17_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	g_object_ref_sink (_tmp17_);
	_data4_->manual_login_stack = _tmp17_;
	_tmp18_ = _data4_->manual_login_stack;
	_tmp19_ = self->priv->carousel;
	gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = _data4_->manual_login_stack;
	_tmp21_ = _data4_->manual_card;
	gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 24);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp22_, 24);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp22_, 24);
	g_object_ref_sink (_tmp22_);
	main_box = _tmp22_;
	_tmp23_ = main_box;
	_tmp24_ = self->priv->datetime_widget;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = main_box;
	_tmp26_ = _data4_->manual_login_stack;
	gtk_container_add ((GtkContainer*) _tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = main_box;
	_tmp28_ = _data4_->extra_login_grid;
	gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = main_box;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp29_, NULL);
	_tmp30_ = self->priv->manual_login_button;
	g_signal_connect_data (_tmp30_, "toggled", (GCallback) __greeter_main_window___lambda32__gtk_toggle_button_toggled, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp31_ = self->priv->guest_login_button;
	g_signal_connect_object (_tmp31_, "clicked", (GCallback) __greeter_main_window___lambda33__gtk_button_clicked, self, 0);
	_tmp32_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_g_object_unref0 (self->priv->card_size_group);
	self->priv->card_size_group = _tmp32_;
	_tmp33_ = self->priv->card_size_group;
	_tmp34_ = _data4_->extra_login_grid;
	gtk_size_group_add_widget (_tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = self->priv->card_size_group;
	_tmp36_ = _data4_->manual_card;
	gtk_size_group_add_widget (_tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = lightdm_greeter_new ();
	_g_object_unref0 (self->priv->lightdm_greeter);
	self->priv->lightdm_greeter = _tmp37_;
	_tmp38_ = self->priv->lightdm_greeter;
	g_signal_connect_object (_tmp38_, "show-message", (GCallback) _greeter_main_window_show_message_lightdm_greeter_show_message, self, 0);
	_tmp39_ = self->priv->lightdm_greeter;
	g_signal_connect_object (_tmp39_, "show-prompt", (GCallback) _greeter_main_window_show_prompt_lightdm_greeter_show_prompt, self, 0);
	_tmp40_ = self->priv->lightdm_greeter;
	g_signal_connect_object (_tmp40_, "authentication-complete", (GCallback) _greeter_main_window_authentication_complete_lightdm_greeter_authentication_complete, self, 0);
	_tmp41_ = self->priv->lightdm_greeter;
	g_signal_connect_data ((GObject*) _tmp41_, "notify::has-guest-account-hint", (GCallback) __greeter_main_window___lambda34__g_object_notify, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp42_ = self->priv->lightdm_greeter;
	g_signal_connect_data ((GObject*) _tmp42_, "notify::show-manual-login-hint", (GCallback) __greeter_main_window___lambda35__g_object_notify, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp43_ = self->priv->lightdm_greeter;
	_tmp44_ = self->priv->manual_login_button;
	g_object_bind_property_with_closures ((GObject*) _tmp43_, "hide-users-hint", (GObject*) _tmp44_, "sensitive", G_BINDING_SYNC_CREATE | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp45_ = self->priv->lightdm_greeter;
	_tmp46_ = self->priv->manual_login_button;
	g_object_bind_property_with_closures ((GObject*) _tmp45_, "hide-users-hint", (GObject*) _tmp46_, "active", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_object ((GObject*) self, "notify::scale-factor", (GCallback) __greeter_main_window___lambda36__g_object_notify, self, 0);
	_tmp47_ = lightdm_user_list_get_instance ();
	self->priv->lightdm_user_list = _tmp47_;
	_tmp48_ = self->priv->lightdm_user_list;
	g_signal_connect_object (_tmp48_, "user-added", (GCallback) __greeter_main_window___lambda37__lightdm_user_list_user_added, self, 0);
	_tmp49_ = _data4_->manual_card;
	g_signal_connect_object (_tmp49_, "do-connect-username", (GCallback) _greeter_main_window_do_connect_username_greeter_manual_card_do_connect_username, self, 0);
	_tmp50_ = _data4_->manual_card;
	g_signal_connect_object ((GreeterBaseCard*) _tmp50_, "do-connect", (GCallback) _greeter_main_window_do_connect_greeter_base_card_do_connect, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) __greeter_main_window___lambda38__gtk_widget_key_press_event, self, 0);
	_tmp51_ = self->priv->carousel;
	g_signal_connect_object (_tmp51_, "page-changed", (GCallback) __greeter_main_window___lambda39__hdy_carousel_page_changed, self, 0);
	_tmp52_ = gtk_window_get_screen ((GtkWindow*) self);
	g_signal_connect_object (_tmp52_, "monitors-changed", (GCallback) __greeter_main_window___lambda40__gdk_screen_monitors_changed, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) __greeter_main_window___lambda41__gtk_widget_leave_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "destroy", (GCallback) __greeter_main_window___lambda42__gtk_widget_destroy, self, 0);
	greeter_main_window_load_users (self, __greeter_main_window___lambda43__gasync_ready_callback, g_object_ref (self));
	greeter_main_window_maximize_window (self);
	_tmp53_ = self->priv->settings;
	_tmp54_ = greeter_settings_get_activate_numlock (_tmp53_);
	_tmp55_ = _tmp54_;
	if (_tmp55_) {
		{
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar** _tmp58_;
			gchar** _tmp59_;
			gint _tmp59__length1;
			_tmp56_ = g_strdup ("numlockx");
			_tmp57_ = g_strdup ("on");
			_tmp58_ = g_new0 (gchar*, 2 + 1);
			_tmp58_[0] = _tmp56_;
			_tmp58_[1] = _tmp57_;
			_tmp59_ = _tmp58_;
			_tmp59__length1 = 2;
			g_spawn_async (NULL, _tmp59_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error0_);
			_tmp59_ = (_vala_array_free (_tmp59_, _tmp59__length1, (GDestroyNotify) g_free), NULL);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
			g_warning ("MainWindow.vala:258: Unable to spawn numlockx to set numlock state");
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (main_box);
			block4_data_unref (_data4_);
			_data4_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
	}
	_g_object_unref0 (main_box);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return obj;
}

static void
greeter_main_window_class_init (GreeterMainWindowClass * klass,
                                gpointer klass_data)
{
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	greeter_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterMainWindow_private_offset);
	G_OBJECT_CLASS (klass)->constructor = greeter_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = greeter_main_window_finalize;
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (greeter_main_window_css_provider);
	greeter_main_window_css_provider = _tmp0_;
	_tmp1_ = greeter_main_window_css_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "/io/elementary/greeter/MainWindow.css");
}

static void
greeter_main_window_instance_init (GreeterMainWindow * self,
                                   gpointer klass)
{
	self->priv = greeter_main_window_get_instance_private (self);
	self->priv->current_user_card_index = 0;
	self->priv->current_card = NULL;
	self->priv->installer_mode = FALSE;
	self->priv->time_format_binding = NULL;
}

static void
greeter_main_window_finalize (GObject * obj)
{
	GreeterMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_TYPE_MAIN_WINDOW, GreeterMainWindow);
	(self->priv->user_cards == NULL) ? NULL : (self->priv->user_cards = (g_queue_free (self->priv->user_cards), NULL));
	_g_object_unref0 (self->priv->card_size_group);
	_g_object_unref0 (self->priv->carousel);
	_g_object_unref0 (self->priv->lightdm_greeter);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->guest_login_button);
	_g_object_unref0 (self->priv->manual_login_button);
	_g_object_unref0 (self->priv->datetime_widget);
	G_OBJECT_CLASS (greeter_main_window_parent_class)->finalize (obj);
}

static GType
greeter_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterMainWindow), 0, (GInstanceInitFunc) greeter_main_window_instance_init, NULL };
	GType greeter_main_window_type_id;
	greeter_main_window_type_id = g_type_register_static (gtk_application_window_get_type (), "GreeterMainWindow", &g_define_type_info, 0);
	GreeterMainWindow_private_offset = g_type_add_instance_private (greeter_main_window_type_id, sizeof (GreeterMainWindowPrivate));
	return greeter_main_window_type_id;
}

GType
greeter_main_window_get_type (void)
{
	static volatile gsize greeter_main_window_type_id__once = 0;
	if (g_once_init_enter (&greeter_main_window_type_id__once)) {
		GType greeter_main_window_type_id;
		greeter_main_window_type_id = greeter_main_window_get_type_once ();
		g_once_init_leave (&greeter_main_window_type_id__once, greeter_main_window_type_id);
	}
	return greeter_main_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

