/* BackgroundSource.c generated by valac 0.56.16, the Vala compiler
 * generated from BackgroundSource.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2024 elementary, Inc. (https://elementary.io)
 *                         2014 Tom Beckmann
 */

#include <glib-object.h>
#include <meta/display.h>
#include <gio/gio.h>
#include <glib.h>
#include <meta/meta-monitor-manager.h>
#include <stdlib.h>
#include <string.h>
#include <gsettings-desktop-schemas/gdesktop-enums.h>
#include <glib/gstdio.h>
#include <meta/meta-context.h>
#include <meta/meta-backend.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE (greeter_compositor_background_source_get_type ())
#define GREETER_COMPOSITOR_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE, GreeterCompositorBackgroundSource))
#define GREETER_COMPOSITOR_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE, GreeterCompositorBackgroundSourceClass))
#define GREETER_COMPOSITOR_IS_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE))
#define GREETER_COMPOSITOR_IS_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE))
#define GREETER_COMPOSITOR_BACKGROUND_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE, GreeterCompositorBackgroundSourceClass))

typedef struct _GreeterCompositorBackgroundSource GreeterCompositorBackgroundSource;
typedef struct _GreeterCompositorBackgroundSourceClass GreeterCompositorBackgroundSourceClass;
typedef struct _GreeterCompositorBackgroundSourcePrivate GreeterCompositorBackgroundSourcePrivate;

#define GREETER_COMPOSITOR_TYPE_BACKGROUND (greeter_compositor_background_get_type ())
#define GREETER_COMPOSITOR_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND, GreeterCompositorBackground))
#define GREETER_COMPOSITOR_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND, GreeterCompositorBackgroundClass))
#define GREETER_COMPOSITOR_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND))
#define GREETER_COMPOSITOR_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND))
#define GREETER_COMPOSITOR_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND, GreeterCompositorBackgroundClass))

typedef struct _GreeterCompositorBackground GreeterCompositorBackground;
typedef struct _GreeterCompositorBackgroundClass GreeterCompositorBackgroundClass;
enum  {
	GREETER_COMPOSITOR_BACKGROUND_SOURCE_0_PROPERTY,
	GREETER_COMPOSITOR_BACKGROUND_SOURCE_DISPLAY_PROPERTY,
	GREETER_COMPOSITOR_BACKGROUND_SOURCE_GNOME_BACKGROUND_SETTINGS_PROPERTY,
	GREETER_COMPOSITOR_BACKGROUND_SOURCE_USE_COUNT_PROPERTY,
	GREETER_COMPOSITOR_BACKGROUND_SOURCE_NUM_PROPERTIES
};
static GParamSpec* greeter_compositor_background_source_properties[GREETER_COMPOSITOR_BACKGROUND_SOURCE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block13Data Block13Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
enum  {
	GREETER_COMPOSITOR_BACKGROUND_SOURCE_CHANGED_SIGNAL,
	GREETER_COMPOSITOR_BACKGROUND_SOURCE_NUM_SIGNALS
};
static guint greeter_compositor_background_source_signals[GREETER_COMPOSITOR_BACKGROUND_SOURCE_NUM_SIGNALS] = {0};

struct _GreeterCompositorBackgroundSource {
	GObject parent_instance;
	GreeterCompositorBackgroundSourcePrivate * priv;
};

struct _GreeterCompositorBackgroundSourceClass {
	GObjectClass parent_class;
};

struct _GreeterCompositorBackgroundSourcePrivate {
	MetaDisplay* _display;
	GSettings* _gnome_background_settings;
	gint _use_count;
	GHashTable* backgrounds;
	guint* hash_cache;
	gint hash_cache_length1;
	gint _hash_cache_size_;
	MetaMonitorManager* monitor_manager;
	GSettings* gala_background_settings;
};

struct _Block13Data {
	int _ref_count_;
	GreeterCompositorBackgroundSource* self;
	gint n;
	gint i;
};

static gint GreeterCompositorBackgroundSource_private_offset;
static gpointer greeter_compositor_background_source_parent_class = NULL;

VALA_EXTERN GType greeter_compositor_background_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorBackgroundSource, g_object_unref)
VALA_EXTERN GType greeter_compositor_background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorBackground, g_object_unref)
VALA_EXTERN GreeterCompositorBackgroundSource* greeter_compositor_background_source_new (MetaDisplay* display);
VALA_EXTERN GreeterCompositorBackgroundSource* greeter_compositor_background_source_construct (GType object_type,
                                                                                   MetaDisplay* display);
static void greeter_compositor_background_source_monitors_changed (GreeterCompositorBackgroundSource* self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
VALA_EXTERN MetaDisplay* greeter_compositor_background_source_get_display (GreeterCompositorBackgroundSource* self);
static gboolean __lambda5_ (Block13Data* _data13_,
                     gint hash,
                     GreeterCompositorBackground* background);
VALA_EXTERN void greeter_compositor_background_update_resolution (GreeterCompositorBackground* self);
static void greeter_compositor_background_source_background_changed (GreeterCompositorBackgroundSource* self,
                                                              GreeterCompositorBackground* background);
static void _greeter_compositor_background_source_background_changed_greeter_compositor_background_changed (GreeterCompositorBackground* _sender,
                                                                                                     gpointer self);
VALA_EXTERN void greeter_compositor_background_destroy (GreeterCompositorBackground* self);
static gboolean ___lambda5__ghr_func (gconstpointer key,
                               gconstpointer value,
                               gpointer self);
VALA_EXTERN GreeterCompositorBackground* greeter_compositor_background_source_get_background (GreeterCompositorBackgroundSource* self,
                                                                                  gint monitor_index);
VALA_EXTERN GSettings* greeter_compositor_background_source_get_gnome_background_settings (GreeterCompositorBackgroundSource* self);
static gchar* greeter_compositor_background_source_get_background_path (GreeterCompositorBackgroundSource* self);
VALA_EXTERN GreeterCompositorBackground* greeter_compositor_background_new (MetaDisplay* display,
                                                                gint monitor_index,
                                                                const gchar* filename,
                                                                GreeterCompositorBackgroundSource* background_source,
                                                                GDesktopBackgroundStyle style);
VALA_EXTERN GreeterCompositorBackground* greeter_compositor_background_construct (GType object_type,
                                                                      MetaDisplay* display,
                                                                      gint monitor_index,
                                                                      const gchar* filename,
                                                                      GreeterCompositorBackgroundSource* background_source,
                                                                      GDesktopBackgroundStyle style);
VALA_EXTERN gint greeter_compositor_background_get_monitor_index (GreeterCompositorBackground* self);
VALA_EXTERN void greeter_compositor_background_source_destroy (GreeterCompositorBackgroundSource* self);
static void _greeter_compositor_background_source_monitors_changed_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                                                   gpointer self);
static gboolean __lambda9_ (GreeterCompositorBackgroundSource* self,
                     gint hash,
                     GreeterCompositorBackground* background);
static gboolean ___lambda9__ghr_func (gconstpointer key,
                               gconstpointer value,
                               gpointer self);
static void greeter_compositor_background_source_set_display (GreeterCompositorBackgroundSource* self,
                                                       MetaDisplay* value);
static void greeter_compositor_background_source_set_gnome_background_settings (GreeterCompositorBackgroundSource* self,
                                                                         GSettings* value);
VALA_EXTERN gint greeter_compositor_background_source_get_use_count (GreeterCompositorBackgroundSource* self);
VALA_EXTERN void greeter_compositor_background_source_set_use_count (GreeterCompositorBackgroundSource* self,
                                                         gint value);
static GObject * greeter_compositor_background_source_constructor (GType type,
                                                            guint n_construct_properties,
                                                            GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static void _greeter_compositor_background_source___lambda14_ (GreeterCompositorBackgroundSource* self);
static void __greeter_compositor_background_source___lambda14__g_settings_changed (GSettings* _sender,
                                                                            const gchar* key,
                                                                            gpointer self);
static void _greeter_compositor_background_source___lambda15_ (GreeterCompositorBackgroundSource* self,
                                                        const gchar* key);
static void __greeter_compositor_background_source___lambda15__g_settings_changed (GSettings* _sender,
                                                                            const gchar* key,
                                                                            gpointer self);
static void greeter_compositor_background_source_finalize (GObject * obj);
static GType greeter_compositor_background_source_get_type_once (void);
static void _vala_greeter_compositor_background_source_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_greeter_compositor_background_source_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);

static const gchar* GREETER_COMPOSITOR_BACKGROUND_SOURCE_OPTIONS[6] = {"color-shading-type", "picture-options", "picture-uri", "picture-uri-dark", "primary-color", "secondary-color"};

static inline gpointer
greeter_compositor_background_source_get_instance_private (GreeterCompositorBackgroundSource* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterCompositorBackgroundSource_private_offset);
}

GreeterCompositorBackgroundSource*
greeter_compositor_background_source_construct (GType object_type,
                                                MetaDisplay* display)
{
	GreeterCompositorBackgroundSource * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	self = (GreeterCompositorBackgroundSource*) g_object_new (object_type, "display", display, NULL);
	return self;
}

GreeterCompositorBackgroundSource*
greeter_compositor_background_source_new (MetaDisplay* display)
{
	return greeter_compositor_background_source_construct (GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE, display);
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		GreeterCompositorBackgroundSource* self;
		self = _data13_->self;
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static void
_greeter_compositor_background_source_background_changed_greeter_compositor_background_changed (GreeterCompositorBackground* _sender,
                                                                                                gpointer self)
{
	greeter_compositor_background_source_background_changed ((GreeterCompositorBackgroundSource*) self, _sender);
}

static gboolean
__lambda5_ (Block13Data* _data13_,
            gint hash,
            GreeterCompositorBackground* background)
{
	GreeterCompositorBackgroundSource* self;
	gint _tmp0_;
	gint _tmp1_;
	gboolean result;
	self = _data13_->self;
	g_return_val_if_fail (background != NULL, FALSE);
	_tmp0_ = _data13_->i;
	_data13_->i = _tmp0_ + 1;
	_tmp1_ = _data13_->n;
	if (_tmp0_ < _tmp1_) {
		greeter_compositor_background_update_resolution (background);
		result = FALSE;
		return result;
	} else {
		guint _tmp2_;
		g_signal_parse_name ("changed", GREETER_COMPOSITOR_TYPE_BACKGROUND, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (background, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _greeter_compositor_background_source_background_changed_greeter_compositor_background_changed, self);
		greeter_compositor_background_destroy (background);
		result = TRUE;
		return result;
	}
}

static gboolean
___lambda5__ghr_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	gboolean result;
	result = __lambda5_ (self, (gint) ((gintptr) key), (GreeterCompositorBackground*) value);
	return result;
}

static void
greeter_compositor_background_source_monitors_changed (GreeterCompositorBackgroundSource* self)
{
	Block13Data* _data13_;
	MetaDisplay* _tmp0_;
	GHashTable* _tmp1_;
	g_return_if_fail (self != NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_tmp0_ = self->priv->_display;
	_data13_->n = meta_display_get_n_monitors (_tmp0_);
	_data13_->i = 0;
	_tmp1_ = self->priv->backgrounds;
	g_hash_table_foreach_remove (_tmp1_, ___lambda5__ghr_func, _data13_);
	block13_data_unref (_data13_);
	_data13_ = NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GreeterCompositorBackground*
greeter_compositor_background_source_get_background (GreeterCompositorBackgroundSource* self,
                                                     gint monitor_index)
{
	gchar* filename = NULL;
	gint style = 0;
	GSettings* _tmp0_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	GreeterCompositorBackground* background = NULL;
	GHashTable* _tmp5_;
	gconstpointer _tmp6_;
	GreeterCompositorBackground* _tmp7_;
	GreeterCompositorBackground* _tmp8_;
	GreeterCompositorBackground* result;
	g_return_val_if_fail (self != NULL, NULL);
	filename = NULL;
	_tmp0_ = self->priv->_gnome_background_settings;
	style = g_settings_get_enum (_tmp0_, "picture-options");
	if (style != ((gint) G_DESKTOP_BACKGROUND_STYLE_NONE)) {
		gchar* _tmp1_;
		_tmp1_ = greeter_compositor_background_source_get_background_path (self);
		_g_free0 (filename);
		filename = _tmp1_;
	}
	_tmp3_ = filename;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = filename;
		_tmp2_ = !g_str_has_suffix (_tmp4_, ".xml");
	}
	if (_tmp2_) {
		monitor_index = 0;
	}
	_tmp5_ = self->priv->backgrounds;
	_tmp6_ = g_hash_table_lookup (_tmp5_, (gpointer) ((gintptr) monitor_index));
	_tmp7_ = _g_object_ref0 ((GreeterCompositorBackground*) _tmp6_);
	background = _tmp7_;
	_tmp8_ = background;
	if (_tmp8_ == NULL) {
		MetaDisplay* _tmp9_;
		const gchar* _tmp10_;
		GreeterCompositorBackground* _tmp11_;
		GreeterCompositorBackground* _tmp12_;
		GHashTable* _tmp13_;
		GreeterCompositorBackground* _tmp14_;
		GreeterCompositorBackground* _tmp15_;
		_tmp9_ = self->priv->_display;
		_tmp10_ = filename;
		_tmp11_ = greeter_compositor_background_new (_tmp9_, monitor_index, _tmp10_, self, (GDesktopBackgroundStyle) style);
		_g_object_unref0 (background);
		background = _tmp11_;
		_tmp12_ = background;
		g_signal_connect_object (_tmp12_, "changed", (GCallback) _greeter_compositor_background_source_background_changed_greeter_compositor_background_changed, self, 0);
		_tmp13_ = self->priv->backgrounds;
		_tmp14_ = background;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		g_hash_table_insert (_tmp13_, (gpointer) ((gintptr) monitor_index), _tmp15_);
	}
	result = background;
	_g_free0 (filename);
	return result;
}

static gchar*
greeter_compositor_background_source_get_background_path (GreeterCompositorBackgroundSource* self)
{
	gchar* uri = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* path = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gnome_background_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "picture-uri");
	uri = _tmp1_;
	_tmp2_ = uri;
	_tmp3_ = g_file_new_for_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_get_path (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	path = _tmp6_;
	_tmp7_ = path;
	if (g_file_test (_tmp7_, G_FILE_TEST_EXISTS)) {
		result = path;
		_g_free0 (uri);
		return result;
	}
	result = uri;
	_g_free0 (path);
	return result;
}

static void
greeter_compositor_background_source_background_changed (GreeterCompositorBackgroundSource* self,
                                                         GreeterCompositorBackground* background)
{
	guint _tmp0_;
	GHashTable* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (background != NULL);
	g_signal_parse_name ("changed", GREETER_COMPOSITOR_TYPE_BACKGROUND, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (background, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _greeter_compositor_background_source_background_changed_greeter_compositor_background_changed, self);
	greeter_compositor_background_destroy (background);
	_tmp1_ = self->priv->backgrounds;
	_tmp2_ = greeter_compositor_background_get_monitor_index (background);
	_tmp3_ = _tmp2_;
	g_hash_table_remove (_tmp1_, (gpointer) ((gintptr) _tmp3_));
}

static void
_greeter_compositor_background_source_monitors_changed_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                                              gpointer self)
{
	greeter_compositor_background_source_monitors_changed ((GreeterCompositorBackgroundSource*) self);
}

static gboolean
__lambda9_ (GreeterCompositorBackgroundSource* self,
            gint hash,
            GreeterCompositorBackground* background)
{
	guint _tmp0_;
	gboolean result;
	g_return_val_if_fail (background != NULL, FALSE);
	g_signal_parse_name ("changed", GREETER_COMPOSITOR_TYPE_BACKGROUND, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (background, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _greeter_compositor_background_source_background_changed_greeter_compositor_background_changed, self);
	greeter_compositor_background_destroy (background);
	result = TRUE;
	return result;
}

static gboolean
___lambda9__ghr_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	gboolean result;
	result = __lambda9_ ((GreeterCompositorBackgroundSource*) self, (gint) ((gintptr) key), (GreeterCompositorBackground*) value);
	return result;
}

void
greeter_compositor_background_source_destroy (GreeterCompositorBackgroundSource* self)
{
	MetaMonitorManager* _tmp0_;
	guint _tmp1_;
	GHashTable* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->monitor_manager;
	g_signal_parse_name ("monitors-changed", meta_monitor_manager_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _greeter_compositor_background_source_monitors_changed_meta_monitor_manager_monitors_changed, self);
	_g_object_unref0 (self->priv->monitor_manager);
	self->priv->monitor_manager = NULL;
	_tmp2_ = self->priv->backgrounds;
	g_hash_table_foreach_remove (_tmp2_, ___lambda9__ghr_func, self);
}

MetaDisplay*
greeter_compositor_background_source_get_display (GreeterCompositorBackgroundSource* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static void
greeter_compositor_background_source_set_display (GreeterCompositorBackgroundSource* self,
                                                  MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_background_source_get_display (self);
	if (old_value != value) {
		MetaDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_background_source_properties[GREETER_COMPOSITOR_BACKGROUND_SOURCE_DISPLAY_PROPERTY]);
	}
}

GSettings*
greeter_compositor_background_source_get_gnome_background_settings (GreeterCompositorBackgroundSource* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gnome_background_settings;
	result = _tmp0_;
	return result;
}

static void
greeter_compositor_background_source_set_gnome_background_settings (GreeterCompositorBackgroundSource* self,
                                                                    GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_background_source_get_gnome_background_settings (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_gnome_background_settings);
		self->priv->_gnome_background_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_background_source_properties[GREETER_COMPOSITOR_BACKGROUND_SOURCE_GNOME_BACKGROUND_SETTINGS_PROPERTY]);
	}
}

gint
greeter_compositor_background_source_get_use_count (GreeterCompositorBackgroundSource* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_use_count;
	return result;
}

void
greeter_compositor_background_source_set_use_count (GreeterCompositorBackgroundSource* self,
                                                    gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_background_source_get_use_count (self);
	if (old_value != value) {
		self->priv->_use_count = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_background_source_properties[GREETER_COMPOSITOR_BACKGROUND_SOURCE_USE_COUNT_PROPERTY]);
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_greeter_compositor_background_source___lambda14_ (GreeterCompositorBackgroundSource* self)
{
	g_signal_emit (self, greeter_compositor_background_source_signals[GREETER_COMPOSITOR_BACKGROUND_SOURCE_CHANGED_SIGNAL], 0);
}

static void
__greeter_compositor_background_source___lambda14__g_settings_changed (GSettings* _sender,
                                                                       const gchar* key,
                                                                       gpointer self)
{
	_greeter_compositor_background_source___lambda14_ ((GreeterCompositorBackgroundSource*) self);
}

static void
_greeter_compositor_background_source___lambda15_ (GreeterCompositorBackgroundSource* self,
                                                   const gchar* key)
{
	g_return_if_fail (key != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < G_N_ELEMENTS (GREETER_COMPOSITOR_BACKGROUND_SOURCE_OPTIONS))) {
					break;
				}
				_tmp2_ = GREETER_COMPOSITOR_BACKGROUND_SOURCE_OPTIONS[i];
				if (g_strcmp0 (key, _tmp2_) == 0) {
					guint new_hash = 0U;
					GSettings* _tmp3_;
					GVariant* _tmp4_;
					GVariant* _tmp5_;
					guint _tmp6_;
					guint* _tmp7_;
					gint _tmp7__length1;
					guint _tmp8_;
					_tmp3_ = self->priv->_gnome_background_settings;
					_tmp4_ = g_settings_get_value (_tmp3_, key);
					_tmp5_ = _tmp4_;
					_tmp6_ = g_variant_hash (_tmp5_);
					_g_variant_unref0 (_tmp5_);
					new_hash = _tmp6_;
					_tmp7_ = self->priv->hash_cache;
					_tmp7__length1 = self->priv->hash_cache_length1;
					_tmp8_ = _tmp7_[i];
					if (_tmp8_ != new_hash) {
						guint* _tmp9_;
						gint _tmp9__length1;
						_tmp9_ = self->priv->hash_cache;
						_tmp9__length1 = self->priv->hash_cache_length1;
						_tmp9_[i] = new_hash;
						g_signal_emit (self, greeter_compositor_background_source_signals[GREETER_COMPOSITOR_BACKGROUND_SOURCE_CHANGED_SIGNAL], 0);
						break;
					}
				}
			}
		}
	}
}

static void
__greeter_compositor_background_source___lambda15__g_settings_changed (GSettings* _sender,
                                                                       const gchar* key,
                                                                       gpointer self)
{
	_greeter_compositor_background_source___lambda15_ ((GreeterCompositorBackgroundSource*) self, key);
}

static GObject *
greeter_compositor_background_source_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GreeterCompositorBackgroundSource * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	guint* _tmp3_;
	MetaDisplay* _tmp4_;
	MetaContext* _tmp5_;
	MetaBackend* _tmp6_;
	MetaMonitorManager* _tmp7_;
	MetaMonitorManager* _tmp8_;
	MetaMonitorManager* _tmp9_;
	GSettings* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
	GSettings* _tmp21_;
	parent_class = G_OBJECT_CLASS (greeter_compositor_background_source_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE, GreeterCompositorBackgroundSource);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->backgrounds);
	self->priv->backgrounds = _tmp2_;
	_tmp3_ = g_new0 (guint, G_N_ELEMENTS (GREETER_COMPOSITOR_BACKGROUND_SOURCE_OPTIONS));
	self->priv->hash_cache = (g_free (self->priv->hash_cache), NULL);
	self->priv->hash_cache = _tmp3_;
	self->priv->hash_cache_length1 = G_N_ELEMENTS (GREETER_COMPOSITOR_BACKGROUND_SOURCE_OPTIONS);
	self->priv->_hash_cache_size_ = self->priv->hash_cache_length1;
	_tmp4_ = self->priv->_display;
	_tmp5_ = meta_display_get_context (_tmp4_);
	_tmp6_ = meta_context_get_backend (_tmp5_);
	_tmp7_ = meta_backend_get_monitor_manager (_tmp6_);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (self->priv->monitor_manager);
	self->priv->monitor_manager = _tmp8_;
	_tmp9_ = self->priv->monitor_manager;
	g_signal_connect_object (_tmp9_, "monitors-changed", (GCallback) _greeter_compositor_background_source_monitors_changed_meta_monitor_manager_monitors_changed, self, 0);
	_tmp10_ = g_settings_new ("io.elementary.desktop.background");
	_g_object_unref0 (self->priv->gala_background_settings);
	self->priv->gala_background_settings = _tmp10_;
	_tmp11_ = self->priv->gala_background_settings;
	g_signal_connect_object (_tmp11_, "changed::dim-wallpaper-in-dark-style", (GCallback) __greeter_compositor_background_source___lambda14__g_settings_changed, self, 0);
	_tmp12_ = g_settings_new ("org.gnome.desktop.background");
	_tmp13_ = _tmp12_;
	greeter_compositor_background_source_set_gnome_background_settings (self, _tmp13_);
	_g_object_unref0 (_tmp13_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				guint* _tmp16_;
				gint _tmp16__length1;
				GSettings* _tmp17_;
				const gchar* _tmp18_;
				GVariant* _tmp19_;
				GVariant* _tmp20_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				if (!(i < G_N_ELEMENTS (GREETER_COMPOSITOR_BACKGROUND_SOURCE_OPTIONS))) {
					break;
				}
				_tmp16_ = self->priv->hash_cache;
				_tmp16__length1 = self->priv->hash_cache_length1;
				_tmp17_ = self->priv->_gnome_background_settings;
				_tmp18_ = GREETER_COMPOSITOR_BACKGROUND_SOURCE_OPTIONS[i];
				_tmp19_ = g_settings_get_value (_tmp17_, _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp16_[i] = g_variant_hash (_tmp20_);
				_g_variant_unref0 (_tmp20_);
			}
		}
	}
	_tmp21_ = self->priv->_gnome_background_settings;
	g_signal_connect_object (_tmp21_, "changed", (GCallback) __greeter_compositor_background_source___lambda15__g_settings_changed, self, 0);
	return obj;
}

static void
greeter_compositor_background_source_class_init (GreeterCompositorBackgroundSourceClass * klass,
                                                 gpointer klass_data)
{
	greeter_compositor_background_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterCompositorBackgroundSource_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_greeter_compositor_background_source_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_greeter_compositor_background_source_set_property;
	G_OBJECT_CLASS (klass)->constructor = greeter_compositor_background_source_constructor;
	G_OBJECT_CLASS (klass)->finalize = greeter_compositor_background_source_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_BACKGROUND_SOURCE_DISPLAY_PROPERTY, greeter_compositor_background_source_properties[GREETER_COMPOSITOR_BACKGROUND_SOURCE_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_BACKGROUND_SOURCE_GNOME_BACKGROUND_SETTINGS_PROPERTY, greeter_compositor_background_source_properties[GREETER_COMPOSITOR_BACKGROUND_SOURCE_GNOME_BACKGROUND_SETTINGS_PROPERTY] = g_param_spec_object ("gnome-background-settings", "gnome-background-settings", "gnome-background-settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_BACKGROUND_SOURCE_USE_COUNT_PROPERTY, greeter_compositor_background_source_properties[GREETER_COMPOSITOR_BACKGROUND_SOURCE_USE_COUNT_PROPERTY] = g_param_spec_int ("use-count", "use-count", "use-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	greeter_compositor_background_source_signals[GREETER_COMPOSITOR_BACKGROUND_SOURCE_CHANGED_SIGNAL] = g_signal_new ("changed", GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
greeter_compositor_background_source_instance_init (GreeterCompositorBackgroundSource * self,
                                                    gpointer klass)
{
	self->priv = greeter_compositor_background_source_get_instance_private (self);
	self->priv->_use_count = 0;
}

static void
greeter_compositor_background_source_finalize (GObject * obj)
{
	GreeterCompositorBackgroundSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE, GreeterCompositorBackgroundSource);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->_gnome_background_settings);
	_g_hash_table_unref0 (self->priv->backgrounds);
	self->priv->hash_cache = (g_free (self->priv->hash_cache), NULL);
	_g_object_unref0 (self->priv->monitor_manager);
	_g_object_unref0 (self->priv->gala_background_settings);
	G_OBJECT_CLASS (greeter_compositor_background_source_parent_class)->finalize (obj);
}

static GType
greeter_compositor_background_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorBackgroundSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_background_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorBackgroundSource), 0, (GInstanceInitFunc) greeter_compositor_background_source_instance_init, NULL };
	GType greeter_compositor_background_source_type_id;
	greeter_compositor_background_source_type_id = g_type_register_static (G_TYPE_OBJECT, "GreeterCompositorBackgroundSource", &g_define_type_info, 0);
	GreeterCompositorBackgroundSource_private_offset = g_type_add_instance_private (greeter_compositor_background_source_type_id, sizeof (GreeterCompositorBackgroundSourcePrivate));
	return greeter_compositor_background_source_type_id;
}

GType
greeter_compositor_background_source_get_type (void)
{
	static volatile gsize greeter_compositor_background_source_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_background_source_type_id__once)) {
		GType greeter_compositor_background_source_type_id;
		greeter_compositor_background_source_type_id = greeter_compositor_background_source_get_type_once ();
		g_once_init_leave (&greeter_compositor_background_source_type_id__once, greeter_compositor_background_source_type_id);
	}
	return greeter_compositor_background_source_type_id__once;
}

static void
_vala_greeter_compositor_background_source_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	GreeterCompositorBackgroundSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE, GreeterCompositorBackgroundSource);
	switch (property_id) {
		case GREETER_COMPOSITOR_BACKGROUND_SOURCE_DISPLAY_PROPERTY:
		g_value_set_object (value, greeter_compositor_background_source_get_display (self));
		break;
		case GREETER_COMPOSITOR_BACKGROUND_SOURCE_GNOME_BACKGROUND_SETTINGS_PROPERTY:
		g_value_set_object (value, greeter_compositor_background_source_get_gnome_background_settings (self));
		break;
		case GREETER_COMPOSITOR_BACKGROUND_SOURCE_USE_COUNT_PROPERTY:
		g_value_set_int (value, greeter_compositor_background_source_get_use_count (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_greeter_compositor_background_source_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	GreeterCompositorBackgroundSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE, GreeterCompositorBackgroundSource);
	switch (property_id) {
		case GREETER_COMPOSITOR_BACKGROUND_SOURCE_DISPLAY_PROPERTY:
		greeter_compositor_background_source_set_display (self, g_value_get_object (value));
		break;
		case GREETER_COMPOSITOR_BACKGROUND_SOURCE_GNOME_BACKGROUND_SETTINGS_PROPERTY:
		greeter_compositor_background_source_set_gnome_background_settings (self, g_value_get_object (value));
		break;
		case GREETER_COMPOSITOR_BACKGROUND_SOURCE_USE_COUNT_PROPERTY:
		greeter_compositor_background_source_set_use_count (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

