

/* this file was generated by volk template utils, do not edit! */

/* -*- c++ -*- */
/*
 * Copyright 2011-2012 Free Software Foundation, Inc.
 *
 * This file is part of VOLK
 *
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include <volk/volk_common.h>
#include "volk_machines.h"
#include <volk/volk_typedefs.h>
#include <volk/volk_cpu.h>
#include "volk_rank_archs.h"
#include <volk/volk.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>

static size_t __alignment = 0;
static intptr_t __alignment_mask = 0;

struct volk_machine *get_machine(void)
{
  extern struct volk_machine *volk_machines[];
  extern unsigned int n_volk_machines;
  static struct volk_machine *machine = NULL;

  if(machine != NULL)
    return machine;
  else {
    unsigned int max_score = 0;
    unsigned int i;
    struct volk_machine *max_machine = NULL;
    for(i=0; i<n_volk_machines; i++) {
      if(!(volk_machines[i]->caps & (~volk_get_lvarch()))) {
        if(volk_machines[i]->caps > max_score) {
          max_score = volk_machines[i]->caps;
          max_machine = volk_machines[i];
        }
      }
    }
    machine = max_machine;
    //printf("Using Volk machine: %s\n", machine->name);
    __alignment = machine->alignment;
    __alignment_mask = (intptr_t)(__alignment-1);
    return machine;
  }
}

void volk_list_machines(void)
{
  extern struct volk_machine *volk_machines[];
  extern unsigned int n_volk_machines;

  unsigned int i;
  for(i=0; i<n_volk_machines; i++) {
    if(!(volk_machines[i]->caps & (~volk_get_lvarch()))) {
        printf("%s;", volk_machines[i]->name);
    }
  }
  printf("\n");
}

const char* volk_get_machine(void)
{
  extern struct volk_machine *volk_machines[];
  extern unsigned int n_volk_machines;
  static struct volk_machine *machine = NULL;

  if(machine != NULL)
    return machine->name;
  else {
    unsigned int max_score = 0;
    unsigned int i;
    struct volk_machine *max_machine = NULL;
    for(i=0; i<n_volk_machines; i++) {
      if(!(volk_machines[i]->caps & (~volk_get_lvarch()))) {
        if(volk_machines[i]->caps > max_score) {
          max_score = volk_machines[i]->caps;
          max_machine = volk_machines[i];
        }
      }
    }
    machine = max_machine;
    return machine->name;
  }
}

size_t volk_get_alignment(void)
{
    get_machine(); //ensures alignment is set
    return __alignment;
}

bool volk_is_aligned(const void *ptr)
{
    return ((intptr_t)(ptr) & __alignment_mask) == 0;
}

#define LV_HAVE_GENERIC
#define LV_HAVE_DISPATCHER



static inline void __volk_16i_32fc_dot_prod_32fc_d(lv_32fc_t*  result, const short*  input, const lv_32fc_t*  taps, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(result,
        VOLK_OR_PTR(input,
        VOLK_OR_PTR(taps,
        0)))
    )){
        volk_16i_32fc_dot_prod_32fc_a(result, input, taps, num_points);
    }
    else{
        volk_16i_32fc_dot_prod_32fc_u(result, input, taps, num_points);
    }
}

static inline void __init_volk_16i_32fc_dot_prod_32fc(void)
{
    const char *name = get_machine()->volk_16i_32fc_dot_prod_32fc_name;
    const char **impl_names = get_machine()->volk_16i_32fc_dot_prod_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_16i_32fc_dot_prod_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_16i_32fc_dot_prod_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_16i_32fc_dot_prod_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_16i_32fc_dot_prod_32fc_a = get_machine()->volk_16i_32fc_dot_prod_32fc_impls[index_a];
    volk_16i_32fc_dot_prod_32fc_u = get_machine()->volk_16i_32fc_dot_prod_32fc_impls[index_u];

    assert(volk_16i_32fc_dot_prod_32fc_a);
    assert(volk_16i_32fc_dot_prod_32fc_u);

    volk_16i_32fc_dot_prod_32fc = &__volk_16i_32fc_dot_prod_32fc_d;
}

static inline void __volk_16i_32fc_dot_prod_32fc_a(lv_32fc_t*  result, const short*  input, const lv_32fc_t*  taps, unsigned int  num_points)
{
    __init_volk_16i_32fc_dot_prod_32fc();
    volk_16i_32fc_dot_prod_32fc_a(result, input, taps, num_points);
}

static inline void __volk_16i_32fc_dot_prod_32fc_u(lv_32fc_t*  result, const short*  input, const lv_32fc_t*  taps, unsigned int  num_points)
{
    __init_volk_16i_32fc_dot_prod_32fc();
    volk_16i_32fc_dot_prod_32fc_u(result, input, taps, num_points);
}

static inline void __volk_16i_32fc_dot_prod_32fc(lv_32fc_t*  result, const short*  input, const lv_32fc_t*  taps, unsigned int  num_points)
{
    __init_volk_16i_32fc_dot_prod_32fc();
    volk_16i_32fc_dot_prod_32fc(result, input, taps, num_points);
}

p_16i_32fc_dot_prod_32fc volk_16i_32fc_dot_prod_32fc_a = &__volk_16i_32fc_dot_prod_32fc_a;
p_16i_32fc_dot_prod_32fc volk_16i_32fc_dot_prod_32fc_u = &__volk_16i_32fc_dot_prod_32fc_u;
p_16i_32fc_dot_prod_32fc volk_16i_32fc_dot_prod_32fc   = &__volk_16i_32fc_dot_prod_32fc;

void volk_16i_32fc_dot_prod_32fc_manual(lv_32fc_t*  result, const short*  input, const lv_32fc_t*  taps, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_16i_32fc_dot_prod_32fc_impl_names,
        get_machine()->volk_16i_32fc_dot_prod_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_16i_32fc_dot_prod_32fc_impls[index](
        result, input, taps, num_points
    );
}

volk_func_desc_t volk_16i_32fc_dot_prod_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_16i_32fc_dot_prod_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_16i_32fc_dot_prod_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_16i_32fc_dot_prod_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_16i_32fc_dot_prod_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_16i_branch_4_state_8_d(short*  target, short*  src0, char**  permuters, short*  cntl2, short*  cntl3, short*  scalars)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(target,
        VOLK_OR_PTR(src0,
        VOLK_OR_PTR(permuters,
        VOLK_OR_PTR(cntl2,
        VOLK_OR_PTR(cntl3,
        VOLK_OR_PTR(scalars,
        0))))))
    )){
        volk_16i_branch_4_state_8_a(target, src0, permuters, cntl2, cntl3, scalars);
    }
    else{
        volk_16i_branch_4_state_8_u(target, src0, permuters, cntl2, cntl3, scalars);
    }
}

static inline void __init_volk_16i_branch_4_state_8(void)
{
    const char *name = get_machine()->volk_16i_branch_4_state_8_name;
    const char **impl_names = get_machine()->volk_16i_branch_4_state_8_impl_names;
    const int *impl_deps = get_machine()->volk_16i_branch_4_state_8_impl_deps;
    const bool *alignment = get_machine()->volk_16i_branch_4_state_8_impl_alignment;
    const size_t n_impls = get_machine()->volk_16i_branch_4_state_8_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_16i_branch_4_state_8_a = get_machine()->volk_16i_branch_4_state_8_impls[index_a];
    volk_16i_branch_4_state_8_u = get_machine()->volk_16i_branch_4_state_8_impls[index_u];

    assert(volk_16i_branch_4_state_8_a);
    assert(volk_16i_branch_4_state_8_u);

    volk_16i_branch_4_state_8 = &__volk_16i_branch_4_state_8_d;
}

static inline void __volk_16i_branch_4_state_8_a(short*  target, short*  src0, char**  permuters, short*  cntl2, short*  cntl3, short*  scalars)
{
    __init_volk_16i_branch_4_state_8();
    volk_16i_branch_4_state_8_a(target, src0, permuters, cntl2, cntl3, scalars);
}

static inline void __volk_16i_branch_4_state_8_u(short*  target, short*  src0, char**  permuters, short*  cntl2, short*  cntl3, short*  scalars)
{
    __init_volk_16i_branch_4_state_8();
    volk_16i_branch_4_state_8_u(target, src0, permuters, cntl2, cntl3, scalars);
}

static inline void __volk_16i_branch_4_state_8(short*  target, short*  src0, char**  permuters, short*  cntl2, short*  cntl3, short*  scalars)
{
    __init_volk_16i_branch_4_state_8();
    volk_16i_branch_4_state_8(target, src0, permuters, cntl2, cntl3, scalars);
}

p_16i_branch_4_state_8 volk_16i_branch_4_state_8_a = &__volk_16i_branch_4_state_8_a;
p_16i_branch_4_state_8 volk_16i_branch_4_state_8_u = &__volk_16i_branch_4_state_8_u;
p_16i_branch_4_state_8 volk_16i_branch_4_state_8   = &__volk_16i_branch_4_state_8;

void volk_16i_branch_4_state_8_manual(short*  target, short*  src0, char**  permuters, short*  cntl2, short*  cntl3, short*  scalars, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_16i_branch_4_state_8_impl_names,
        get_machine()->volk_16i_branch_4_state_8_n_impls,
        impl_name
    );
    get_machine()->volk_16i_branch_4_state_8_impls[index](
        target, src0, permuters, cntl2, cntl3, scalars
    );
}

volk_func_desc_t volk_16i_branch_4_state_8_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_16i_branch_4_state_8_impl_names;
    const int *impl_deps = get_machine()->volk_16i_branch_4_state_8_impl_deps;
    const bool *alignment = get_machine()->volk_16i_branch_4_state_8_impl_alignment;
    const size_t n_impls = get_machine()->volk_16i_branch_4_state_8_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_16i_convert_8i_d(int8_t*  outputVector, const int16_t*  inputVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outputVector,
        VOLK_OR_PTR(inputVector,
        0))
    )){
        volk_16i_convert_8i_a(outputVector, inputVector, num_points);
    }
    else{
        volk_16i_convert_8i_u(outputVector, inputVector, num_points);
    }
}

static inline void __init_volk_16i_convert_8i(void)
{
    const char *name = get_machine()->volk_16i_convert_8i_name;
    const char **impl_names = get_machine()->volk_16i_convert_8i_impl_names;
    const int *impl_deps = get_machine()->volk_16i_convert_8i_impl_deps;
    const bool *alignment = get_machine()->volk_16i_convert_8i_impl_alignment;
    const size_t n_impls = get_machine()->volk_16i_convert_8i_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_16i_convert_8i_a = get_machine()->volk_16i_convert_8i_impls[index_a];
    volk_16i_convert_8i_u = get_machine()->volk_16i_convert_8i_impls[index_u];

    assert(volk_16i_convert_8i_a);
    assert(volk_16i_convert_8i_u);

    volk_16i_convert_8i = &__volk_16i_convert_8i_d;
}

static inline void __volk_16i_convert_8i_a(int8_t*  outputVector, const int16_t*  inputVector, unsigned int  num_points)
{
    __init_volk_16i_convert_8i();
    volk_16i_convert_8i_a(outputVector, inputVector, num_points);
}

static inline void __volk_16i_convert_8i_u(int8_t*  outputVector, const int16_t*  inputVector, unsigned int  num_points)
{
    __init_volk_16i_convert_8i();
    volk_16i_convert_8i_u(outputVector, inputVector, num_points);
}

static inline void __volk_16i_convert_8i(int8_t*  outputVector, const int16_t*  inputVector, unsigned int  num_points)
{
    __init_volk_16i_convert_8i();
    volk_16i_convert_8i(outputVector, inputVector, num_points);
}

p_16i_convert_8i volk_16i_convert_8i_a = &__volk_16i_convert_8i_a;
p_16i_convert_8i volk_16i_convert_8i_u = &__volk_16i_convert_8i_u;
p_16i_convert_8i volk_16i_convert_8i   = &__volk_16i_convert_8i;

void volk_16i_convert_8i_manual(int8_t*  outputVector, const int16_t*  inputVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_16i_convert_8i_impl_names,
        get_machine()->volk_16i_convert_8i_n_impls,
        impl_name
    );
    get_machine()->volk_16i_convert_8i_impls[index](
        outputVector, inputVector, num_points
    );
}

volk_func_desc_t volk_16i_convert_8i_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_16i_convert_8i_impl_names;
    const int *impl_deps = get_machine()->volk_16i_convert_8i_impl_deps;
    const bool *alignment = get_machine()->volk_16i_convert_8i_impl_alignment;
    const size_t n_impls = get_machine()->volk_16i_convert_8i_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_16i_max_star_16i_d(short*  target, short*  src0, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(target,
        VOLK_OR_PTR(src0,
        0))
    )){
        volk_16i_max_star_16i_a(target, src0, num_points);
    }
    else{
        volk_16i_max_star_16i_u(target, src0, num_points);
    }
}

static inline void __init_volk_16i_max_star_16i(void)
{
    const char *name = get_machine()->volk_16i_max_star_16i_name;
    const char **impl_names = get_machine()->volk_16i_max_star_16i_impl_names;
    const int *impl_deps = get_machine()->volk_16i_max_star_16i_impl_deps;
    const bool *alignment = get_machine()->volk_16i_max_star_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_16i_max_star_16i_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_16i_max_star_16i_a = get_machine()->volk_16i_max_star_16i_impls[index_a];
    volk_16i_max_star_16i_u = get_machine()->volk_16i_max_star_16i_impls[index_u];

    assert(volk_16i_max_star_16i_a);
    assert(volk_16i_max_star_16i_u);

    volk_16i_max_star_16i = &__volk_16i_max_star_16i_d;
}

static inline void __volk_16i_max_star_16i_a(short*  target, short*  src0, unsigned int  num_points)
{
    __init_volk_16i_max_star_16i();
    volk_16i_max_star_16i_a(target, src0, num_points);
}

static inline void __volk_16i_max_star_16i_u(short*  target, short*  src0, unsigned int  num_points)
{
    __init_volk_16i_max_star_16i();
    volk_16i_max_star_16i_u(target, src0, num_points);
}

static inline void __volk_16i_max_star_16i(short*  target, short*  src0, unsigned int  num_points)
{
    __init_volk_16i_max_star_16i();
    volk_16i_max_star_16i(target, src0, num_points);
}

p_16i_max_star_16i volk_16i_max_star_16i_a = &__volk_16i_max_star_16i_a;
p_16i_max_star_16i volk_16i_max_star_16i_u = &__volk_16i_max_star_16i_u;
p_16i_max_star_16i volk_16i_max_star_16i   = &__volk_16i_max_star_16i;

void volk_16i_max_star_16i_manual(short*  target, short*  src0, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_16i_max_star_16i_impl_names,
        get_machine()->volk_16i_max_star_16i_n_impls,
        impl_name
    );
    get_machine()->volk_16i_max_star_16i_impls[index](
        target, src0, num_points
    );
}

volk_func_desc_t volk_16i_max_star_16i_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_16i_max_star_16i_impl_names;
    const int *impl_deps = get_machine()->volk_16i_max_star_16i_impl_deps;
    const bool *alignment = get_machine()->volk_16i_max_star_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_16i_max_star_16i_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_16i_max_star_horizontal_16i_d(int16_t*  target, int16_t*  src0, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(target,
        VOLK_OR_PTR(src0,
        0))
    )){
        volk_16i_max_star_horizontal_16i_a(target, src0, num_points);
    }
    else{
        volk_16i_max_star_horizontal_16i_u(target, src0, num_points);
    }
}

static inline void __init_volk_16i_max_star_horizontal_16i(void)
{
    const char *name = get_machine()->volk_16i_max_star_horizontal_16i_name;
    const char **impl_names = get_machine()->volk_16i_max_star_horizontal_16i_impl_names;
    const int *impl_deps = get_machine()->volk_16i_max_star_horizontal_16i_impl_deps;
    const bool *alignment = get_machine()->volk_16i_max_star_horizontal_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_16i_max_star_horizontal_16i_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_16i_max_star_horizontal_16i_a = get_machine()->volk_16i_max_star_horizontal_16i_impls[index_a];
    volk_16i_max_star_horizontal_16i_u = get_machine()->volk_16i_max_star_horizontal_16i_impls[index_u];

    assert(volk_16i_max_star_horizontal_16i_a);
    assert(volk_16i_max_star_horizontal_16i_u);

    volk_16i_max_star_horizontal_16i = &__volk_16i_max_star_horizontal_16i_d;
}

static inline void __volk_16i_max_star_horizontal_16i_a(int16_t*  target, int16_t*  src0, unsigned int  num_points)
{
    __init_volk_16i_max_star_horizontal_16i();
    volk_16i_max_star_horizontal_16i_a(target, src0, num_points);
}

static inline void __volk_16i_max_star_horizontal_16i_u(int16_t*  target, int16_t*  src0, unsigned int  num_points)
{
    __init_volk_16i_max_star_horizontal_16i();
    volk_16i_max_star_horizontal_16i_u(target, src0, num_points);
}

static inline void __volk_16i_max_star_horizontal_16i(int16_t*  target, int16_t*  src0, unsigned int  num_points)
{
    __init_volk_16i_max_star_horizontal_16i();
    volk_16i_max_star_horizontal_16i(target, src0, num_points);
}

p_16i_max_star_horizontal_16i volk_16i_max_star_horizontal_16i_a = &__volk_16i_max_star_horizontal_16i_a;
p_16i_max_star_horizontal_16i volk_16i_max_star_horizontal_16i_u = &__volk_16i_max_star_horizontal_16i_u;
p_16i_max_star_horizontal_16i volk_16i_max_star_horizontal_16i   = &__volk_16i_max_star_horizontal_16i;

void volk_16i_max_star_horizontal_16i_manual(int16_t*  target, int16_t*  src0, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_16i_max_star_horizontal_16i_impl_names,
        get_machine()->volk_16i_max_star_horizontal_16i_n_impls,
        impl_name
    );
    get_machine()->volk_16i_max_star_horizontal_16i_impls[index](
        target, src0, num_points
    );
}

volk_func_desc_t volk_16i_max_star_horizontal_16i_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_16i_max_star_horizontal_16i_impl_names;
    const int *impl_deps = get_machine()->volk_16i_max_star_horizontal_16i_impl_deps;
    const bool *alignment = get_machine()->volk_16i_max_star_horizontal_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_16i_max_star_horizontal_16i_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_16i_permute_and_scalar_add_d(short*  target, short*  src0, short*  permute_indexes, short*  cntl0, short*  cntl1, short*  cntl2, short*  cntl3, short*  scalars, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(target,
        VOLK_OR_PTR(src0,
        VOLK_OR_PTR(permute_indexes,
        VOLK_OR_PTR(cntl0,
        VOLK_OR_PTR(cntl1,
        VOLK_OR_PTR(cntl2,
        VOLK_OR_PTR(cntl3,
        VOLK_OR_PTR(scalars,
        0))))))))
    )){
        volk_16i_permute_and_scalar_add_a(target, src0, permute_indexes, cntl0, cntl1, cntl2, cntl3, scalars, num_points);
    }
    else{
        volk_16i_permute_and_scalar_add_u(target, src0, permute_indexes, cntl0, cntl1, cntl2, cntl3, scalars, num_points);
    }
}

static inline void __init_volk_16i_permute_and_scalar_add(void)
{
    const char *name = get_machine()->volk_16i_permute_and_scalar_add_name;
    const char **impl_names = get_machine()->volk_16i_permute_and_scalar_add_impl_names;
    const int *impl_deps = get_machine()->volk_16i_permute_and_scalar_add_impl_deps;
    const bool *alignment = get_machine()->volk_16i_permute_and_scalar_add_impl_alignment;
    const size_t n_impls = get_machine()->volk_16i_permute_and_scalar_add_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_16i_permute_and_scalar_add_a = get_machine()->volk_16i_permute_and_scalar_add_impls[index_a];
    volk_16i_permute_and_scalar_add_u = get_machine()->volk_16i_permute_and_scalar_add_impls[index_u];

    assert(volk_16i_permute_and_scalar_add_a);
    assert(volk_16i_permute_and_scalar_add_u);

    volk_16i_permute_and_scalar_add = &__volk_16i_permute_and_scalar_add_d;
}

static inline void __volk_16i_permute_and_scalar_add_a(short*  target, short*  src0, short*  permute_indexes, short*  cntl0, short*  cntl1, short*  cntl2, short*  cntl3, short*  scalars, unsigned int  num_points)
{
    __init_volk_16i_permute_and_scalar_add();
    volk_16i_permute_and_scalar_add_a(target, src0, permute_indexes, cntl0, cntl1, cntl2, cntl3, scalars, num_points);
}

static inline void __volk_16i_permute_and_scalar_add_u(short*  target, short*  src0, short*  permute_indexes, short*  cntl0, short*  cntl1, short*  cntl2, short*  cntl3, short*  scalars, unsigned int  num_points)
{
    __init_volk_16i_permute_and_scalar_add();
    volk_16i_permute_and_scalar_add_u(target, src0, permute_indexes, cntl0, cntl1, cntl2, cntl3, scalars, num_points);
}

static inline void __volk_16i_permute_and_scalar_add(short*  target, short*  src0, short*  permute_indexes, short*  cntl0, short*  cntl1, short*  cntl2, short*  cntl3, short*  scalars, unsigned int  num_points)
{
    __init_volk_16i_permute_and_scalar_add();
    volk_16i_permute_and_scalar_add(target, src0, permute_indexes, cntl0, cntl1, cntl2, cntl3, scalars, num_points);
}

p_16i_permute_and_scalar_add volk_16i_permute_and_scalar_add_a = &__volk_16i_permute_and_scalar_add_a;
p_16i_permute_and_scalar_add volk_16i_permute_and_scalar_add_u = &__volk_16i_permute_and_scalar_add_u;
p_16i_permute_and_scalar_add volk_16i_permute_and_scalar_add   = &__volk_16i_permute_and_scalar_add;

void volk_16i_permute_and_scalar_add_manual(short*  target, short*  src0, short*  permute_indexes, short*  cntl0, short*  cntl1, short*  cntl2, short*  cntl3, short*  scalars, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_16i_permute_and_scalar_add_impl_names,
        get_machine()->volk_16i_permute_and_scalar_add_n_impls,
        impl_name
    );
    get_machine()->volk_16i_permute_and_scalar_add_impls[index](
        target, src0, permute_indexes, cntl0, cntl1, cntl2, cntl3, scalars, num_points
    );
}

volk_func_desc_t volk_16i_permute_and_scalar_add_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_16i_permute_and_scalar_add_impl_names;
    const int *impl_deps = get_machine()->volk_16i_permute_and_scalar_add_impl_deps;
    const bool *alignment = get_machine()->volk_16i_permute_and_scalar_add_impl_alignment;
    const size_t n_impls = get_machine()->volk_16i_permute_and_scalar_add_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_16i_s32f_convert_32f_d(float*  outputVector, const int16_t*  inputVector, const float  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outputVector,
        VOLK_OR_PTR(inputVector,
        0))
    )){
        volk_16i_s32f_convert_32f_a(outputVector, inputVector, scalar, num_points);
    }
    else{
        volk_16i_s32f_convert_32f_u(outputVector, inputVector, scalar, num_points);
    }
}

static inline void __init_volk_16i_s32f_convert_32f(void)
{
    const char *name = get_machine()->volk_16i_s32f_convert_32f_name;
    const char **impl_names = get_machine()->volk_16i_s32f_convert_32f_impl_names;
    const int *impl_deps = get_machine()->volk_16i_s32f_convert_32f_impl_deps;
    const bool *alignment = get_machine()->volk_16i_s32f_convert_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_16i_s32f_convert_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_16i_s32f_convert_32f_a = get_machine()->volk_16i_s32f_convert_32f_impls[index_a];
    volk_16i_s32f_convert_32f_u = get_machine()->volk_16i_s32f_convert_32f_impls[index_u];

    assert(volk_16i_s32f_convert_32f_a);
    assert(volk_16i_s32f_convert_32f_u);

    volk_16i_s32f_convert_32f = &__volk_16i_s32f_convert_32f_d;
}

static inline void __volk_16i_s32f_convert_32f_a(float*  outputVector, const int16_t*  inputVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_16i_s32f_convert_32f();
    volk_16i_s32f_convert_32f_a(outputVector, inputVector, scalar, num_points);
}

static inline void __volk_16i_s32f_convert_32f_u(float*  outputVector, const int16_t*  inputVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_16i_s32f_convert_32f();
    volk_16i_s32f_convert_32f_u(outputVector, inputVector, scalar, num_points);
}

static inline void __volk_16i_s32f_convert_32f(float*  outputVector, const int16_t*  inputVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_16i_s32f_convert_32f();
    volk_16i_s32f_convert_32f(outputVector, inputVector, scalar, num_points);
}

p_16i_s32f_convert_32f volk_16i_s32f_convert_32f_a = &__volk_16i_s32f_convert_32f_a;
p_16i_s32f_convert_32f volk_16i_s32f_convert_32f_u = &__volk_16i_s32f_convert_32f_u;
p_16i_s32f_convert_32f volk_16i_s32f_convert_32f   = &__volk_16i_s32f_convert_32f;

void volk_16i_s32f_convert_32f_manual(float*  outputVector, const int16_t*  inputVector, const float  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_16i_s32f_convert_32f_impl_names,
        get_machine()->volk_16i_s32f_convert_32f_n_impls,
        impl_name
    );
    get_machine()->volk_16i_s32f_convert_32f_impls[index](
        outputVector, inputVector, scalar, num_points
    );
}

volk_func_desc_t volk_16i_s32f_convert_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_16i_s32f_convert_32f_impl_names;
    const int *impl_deps = get_machine()->volk_16i_s32f_convert_32f_impl_deps;
    const bool *alignment = get_machine()->volk_16i_s32f_convert_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_16i_s32f_convert_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_16i_x4_quad_max_star_16i_d(short*  target, short*  src0, short*  src1, short*  src2, short*  src3, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(target,
        VOLK_OR_PTR(src0,
        VOLK_OR_PTR(src1,
        VOLK_OR_PTR(src2,
        VOLK_OR_PTR(src3,
        0)))))
    )){
        volk_16i_x4_quad_max_star_16i_a(target, src0, src1, src2, src3, num_points);
    }
    else{
        volk_16i_x4_quad_max_star_16i_u(target, src0, src1, src2, src3, num_points);
    }
}

static inline void __init_volk_16i_x4_quad_max_star_16i(void)
{
    const char *name = get_machine()->volk_16i_x4_quad_max_star_16i_name;
    const char **impl_names = get_machine()->volk_16i_x4_quad_max_star_16i_impl_names;
    const int *impl_deps = get_machine()->volk_16i_x4_quad_max_star_16i_impl_deps;
    const bool *alignment = get_machine()->volk_16i_x4_quad_max_star_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_16i_x4_quad_max_star_16i_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_16i_x4_quad_max_star_16i_a = get_machine()->volk_16i_x4_quad_max_star_16i_impls[index_a];
    volk_16i_x4_quad_max_star_16i_u = get_machine()->volk_16i_x4_quad_max_star_16i_impls[index_u];

    assert(volk_16i_x4_quad_max_star_16i_a);
    assert(volk_16i_x4_quad_max_star_16i_u);

    volk_16i_x4_quad_max_star_16i = &__volk_16i_x4_quad_max_star_16i_d;
}

static inline void __volk_16i_x4_quad_max_star_16i_a(short*  target, short*  src0, short*  src1, short*  src2, short*  src3, unsigned int  num_points)
{
    __init_volk_16i_x4_quad_max_star_16i();
    volk_16i_x4_quad_max_star_16i_a(target, src0, src1, src2, src3, num_points);
}

static inline void __volk_16i_x4_quad_max_star_16i_u(short*  target, short*  src0, short*  src1, short*  src2, short*  src3, unsigned int  num_points)
{
    __init_volk_16i_x4_quad_max_star_16i();
    volk_16i_x4_quad_max_star_16i_u(target, src0, src1, src2, src3, num_points);
}

static inline void __volk_16i_x4_quad_max_star_16i(short*  target, short*  src0, short*  src1, short*  src2, short*  src3, unsigned int  num_points)
{
    __init_volk_16i_x4_quad_max_star_16i();
    volk_16i_x4_quad_max_star_16i(target, src0, src1, src2, src3, num_points);
}

p_16i_x4_quad_max_star_16i volk_16i_x4_quad_max_star_16i_a = &__volk_16i_x4_quad_max_star_16i_a;
p_16i_x4_quad_max_star_16i volk_16i_x4_quad_max_star_16i_u = &__volk_16i_x4_quad_max_star_16i_u;
p_16i_x4_quad_max_star_16i volk_16i_x4_quad_max_star_16i   = &__volk_16i_x4_quad_max_star_16i;

void volk_16i_x4_quad_max_star_16i_manual(short*  target, short*  src0, short*  src1, short*  src2, short*  src3, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_16i_x4_quad_max_star_16i_impl_names,
        get_machine()->volk_16i_x4_quad_max_star_16i_n_impls,
        impl_name
    );
    get_machine()->volk_16i_x4_quad_max_star_16i_impls[index](
        target, src0, src1, src2, src3, num_points
    );
}

volk_func_desc_t volk_16i_x4_quad_max_star_16i_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_16i_x4_quad_max_star_16i_impl_names;
    const int *impl_deps = get_machine()->volk_16i_x4_quad_max_star_16i_impl_deps;
    const bool *alignment = get_machine()->volk_16i_x4_quad_max_star_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_16i_x4_quad_max_star_16i_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_16i_x5_add_quad_16i_x4_d(short*  target0, short*  target1, short*  target2, short*  target3, short*  src0, short*  src1, short*  src2, short*  src3, short*  src4, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(target0,
        VOLK_OR_PTR(target1,
        VOLK_OR_PTR(target2,
        VOLK_OR_PTR(target3,
        VOLK_OR_PTR(src0,
        VOLK_OR_PTR(src1,
        VOLK_OR_PTR(src2,
        VOLK_OR_PTR(src3,
        VOLK_OR_PTR(src4,
        0)))))))))
    )){
        volk_16i_x5_add_quad_16i_x4_a(target0, target1, target2, target3, src0, src1, src2, src3, src4, num_points);
    }
    else{
        volk_16i_x5_add_quad_16i_x4_u(target0, target1, target2, target3, src0, src1, src2, src3, src4, num_points);
    }
}

static inline void __init_volk_16i_x5_add_quad_16i_x4(void)
{
    const char *name = get_machine()->volk_16i_x5_add_quad_16i_x4_name;
    const char **impl_names = get_machine()->volk_16i_x5_add_quad_16i_x4_impl_names;
    const int *impl_deps = get_machine()->volk_16i_x5_add_quad_16i_x4_impl_deps;
    const bool *alignment = get_machine()->volk_16i_x5_add_quad_16i_x4_impl_alignment;
    const size_t n_impls = get_machine()->volk_16i_x5_add_quad_16i_x4_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_16i_x5_add_quad_16i_x4_a = get_machine()->volk_16i_x5_add_quad_16i_x4_impls[index_a];
    volk_16i_x5_add_quad_16i_x4_u = get_machine()->volk_16i_x5_add_quad_16i_x4_impls[index_u];

    assert(volk_16i_x5_add_quad_16i_x4_a);
    assert(volk_16i_x5_add_quad_16i_x4_u);

    volk_16i_x5_add_quad_16i_x4 = &__volk_16i_x5_add_quad_16i_x4_d;
}

static inline void __volk_16i_x5_add_quad_16i_x4_a(short*  target0, short*  target1, short*  target2, short*  target3, short*  src0, short*  src1, short*  src2, short*  src3, short*  src4, unsigned int  num_points)
{
    __init_volk_16i_x5_add_quad_16i_x4();
    volk_16i_x5_add_quad_16i_x4_a(target0, target1, target2, target3, src0, src1, src2, src3, src4, num_points);
}

static inline void __volk_16i_x5_add_quad_16i_x4_u(short*  target0, short*  target1, short*  target2, short*  target3, short*  src0, short*  src1, short*  src2, short*  src3, short*  src4, unsigned int  num_points)
{
    __init_volk_16i_x5_add_quad_16i_x4();
    volk_16i_x5_add_quad_16i_x4_u(target0, target1, target2, target3, src0, src1, src2, src3, src4, num_points);
}

static inline void __volk_16i_x5_add_quad_16i_x4(short*  target0, short*  target1, short*  target2, short*  target3, short*  src0, short*  src1, short*  src2, short*  src3, short*  src4, unsigned int  num_points)
{
    __init_volk_16i_x5_add_quad_16i_x4();
    volk_16i_x5_add_quad_16i_x4(target0, target1, target2, target3, src0, src1, src2, src3, src4, num_points);
}

p_16i_x5_add_quad_16i_x4 volk_16i_x5_add_quad_16i_x4_a = &__volk_16i_x5_add_quad_16i_x4_a;
p_16i_x5_add_quad_16i_x4 volk_16i_x5_add_quad_16i_x4_u = &__volk_16i_x5_add_quad_16i_x4_u;
p_16i_x5_add_quad_16i_x4 volk_16i_x5_add_quad_16i_x4   = &__volk_16i_x5_add_quad_16i_x4;

void volk_16i_x5_add_quad_16i_x4_manual(short*  target0, short*  target1, short*  target2, short*  target3, short*  src0, short*  src1, short*  src2, short*  src3, short*  src4, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_16i_x5_add_quad_16i_x4_impl_names,
        get_machine()->volk_16i_x5_add_quad_16i_x4_n_impls,
        impl_name
    );
    get_machine()->volk_16i_x5_add_quad_16i_x4_impls[index](
        target0, target1, target2, target3, src0, src1, src2, src3, src4, num_points
    );
}

volk_func_desc_t volk_16i_x5_add_quad_16i_x4_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_16i_x5_add_quad_16i_x4_impl_names;
    const int *impl_deps = get_machine()->volk_16i_x5_add_quad_16i_x4_impl_deps;
    const bool *alignment = get_machine()->volk_16i_x5_add_quad_16i_x4_impl_alignment;
    const size_t n_impls = get_machine()->volk_16i_x5_add_quad_16i_x4_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_16ic_convert_32fc_d(lv_32fc_t*  outputVector, const lv_16sc_t*  inputVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outputVector,
        VOLK_OR_PTR(inputVector,
        0))
    )){
        volk_16ic_convert_32fc_a(outputVector, inputVector, num_points);
    }
    else{
        volk_16ic_convert_32fc_u(outputVector, inputVector, num_points);
    }
}

static inline void __init_volk_16ic_convert_32fc(void)
{
    const char *name = get_machine()->volk_16ic_convert_32fc_name;
    const char **impl_names = get_machine()->volk_16ic_convert_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_16ic_convert_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_16ic_convert_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_16ic_convert_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_16ic_convert_32fc_a = get_machine()->volk_16ic_convert_32fc_impls[index_a];
    volk_16ic_convert_32fc_u = get_machine()->volk_16ic_convert_32fc_impls[index_u];

    assert(volk_16ic_convert_32fc_a);
    assert(volk_16ic_convert_32fc_u);

    volk_16ic_convert_32fc = &__volk_16ic_convert_32fc_d;
}

static inline void __volk_16ic_convert_32fc_a(lv_32fc_t*  outputVector, const lv_16sc_t*  inputVector, unsigned int  num_points)
{
    __init_volk_16ic_convert_32fc();
    volk_16ic_convert_32fc_a(outputVector, inputVector, num_points);
}

static inline void __volk_16ic_convert_32fc_u(lv_32fc_t*  outputVector, const lv_16sc_t*  inputVector, unsigned int  num_points)
{
    __init_volk_16ic_convert_32fc();
    volk_16ic_convert_32fc_u(outputVector, inputVector, num_points);
}

static inline void __volk_16ic_convert_32fc(lv_32fc_t*  outputVector, const lv_16sc_t*  inputVector, unsigned int  num_points)
{
    __init_volk_16ic_convert_32fc();
    volk_16ic_convert_32fc(outputVector, inputVector, num_points);
}

p_16ic_convert_32fc volk_16ic_convert_32fc_a = &__volk_16ic_convert_32fc_a;
p_16ic_convert_32fc volk_16ic_convert_32fc_u = &__volk_16ic_convert_32fc_u;
p_16ic_convert_32fc volk_16ic_convert_32fc   = &__volk_16ic_convert_32fc;

void volk_16ic_convert_32fc_manual(lv_32fc_t*  outputVector, const lv_16sc_t*  inputVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_16ic_convert_32fc_impl_names,
        get_machine()->volk_16ic_convert_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_16ic_convert_32fc_impls[index](
        outputVector, inputVector, num_points
    );
}

volk_func_desc_t volk_16ic_convert_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_16ic_convert_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_16ic_convert_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_16ic_convert_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_16ic_convert_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_16ic_deinterleave_16i_x2_d(int16_t*  iBuffer, int16_t*  qBuffer, const lv_16sc_t*  complexVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(iBuffer,
        VOLK_OR_PTR(qBuffer,
        VOLK_OR_PTR(complexVector,
        0)))
    )){
        volk_16ic_deinterleave_16i_x2_a(iBuffer, qBuffer, complexVector, num_points);
    }
    else{
        volk_16ic_deinterleave_16i_x2_u(iBuffer, qBuffer, complexVector, num_points);
    }
}

static inline void __init_volk_16ic_deinterleave_16i_x2(void)
{
    const char *name = get_machine()->volk_16ic_deinterleave_16i_x2_name;
    const char **impl_names = get_machine()->volk_16ic_deinterleave_16i_x2_impl_names;
    const int *impl_deps = get_machine()->volk_16ic_deinterleave_16i_x2_impl_deps;
    const bool *alignment = get_machine()->volk_16ic_deinterleave_16i_x2_impl_alignment;
    const size_t n_impls = get_machine()->volk_16ic_deinterleave_16i_x2_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_16ic_deinterleave_16i_x2_a = get_machine()->volk_16ic_deinterleave_16i_x2_impls[index_a];
    volk_16ic_deinterleave_16i_x2_u = get_machine()->volk_16ic_deinterleave_16i_x2_impls[index_u];

    assert(volk_16ic_deinterleave_16i_x2_a);
    assert(volk_16ic_deinterleave_16i_x2_u);

    volk_16ic_deinterleave_16i_x2 = &__volk_16ic_deinterleave_16i_x2_d;
}

static inline void __volk_16ic_deinterleave_16i_x2_a(int16_t*  iBuffer, int16_t*  qBuffer, const lv_16sc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_16ic_deinterleave_16i_x2();
    volk_16ic_deinterleave_16i_x2_a(iBuffer, qBuffer, complexVector, num_points);
}

static inline void __volk_16ic_deinterleave_16i_x2_u(int16_t*  iBuffer, int16_t*  qBuffer, const lv_16sc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_16ic_deinterleave_16i_x2();
    volk_16ic_deinterleave_16i_x2_u(iBuffer, qBuffer, complexVector, num_points);
}

static inline void __volk_16ic_deinterleave_16i_x2(int16_t*  iBuffer, int16_t*  qBuffer, const lv_16sc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_16ic_deinterleave_16i_x2();
    volk_16ic_deinterleave_16i_x2(iBuffer, qBuffer, complexVector, num_points);
}

p_16ic_deinterleave_16i_x2 volk_16ic_deinterleave_16i_x2_a = &__volk_16ic_deinterleave_16i_x2_a;
p_16ic_deinterleave_16i_x2 volk_16ic_deinterleave_16i_x2_u = &__volk_16ic_deinterleave_16i_x2_u;
p_16ic_deinterleave_16i_x2 volk_16ic_deinterleave_16i_x2   = &__volk_16ic_deinterleave_16i_x2;

void volk_16ic_deinterleave_16i_x2_manual(int16_t*  iBuffer, int16_t*  qBuffer, const lv_16sc_t*  complexVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_16ic_deinterleave_16i_x2_impl_names,
        get_machine()->volk_16ic_deinterleave_16i_x2_n_impls,
        impl_name
    );
    get_machine()->volk_16ic_deinterleave_16i_x2_impls[index](
        iBuffer, qBuffer, complexVector, num_points
    );
}

volk_func_desc_t volk_16ic_deinterleave_16i_x2_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_16ic_deinterleave_16i_x2_impl_names;
    const int *impl_deps = get_machine()->volk_16ic_deinterleave_16i_x2_impl_deps;
    const bool *alignment = get_machine()->volk_16ic_deinterleave_16i_x2_impl_alignment;
    const size_t n_impls = get_machine()->volk_16ic_deinterleave_16i_x2_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_16ic_deinterleave_real_16i_d(int16_t*  iBuffer, const lv_16sc_t*  complexVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(iBuffer,
        VOLK_OR_PTR(complexVector,
        0))
    )){
        volk_16ic_deinterleave_real_16i_a(iBuffer, complexVector, num_points);
    }
    else{
        volk_16ic_deinterleave_real_16i_u(iBuffer, complexVector, num_points);
    }
}

static inline void __init_volk_16ic_deinterleave_real_16i(void)
{
    const char *name = get_machine()->volk_16ic_deinterleave_real_16i_name;
    const char **impl_names = get_machine()->volk_16ic_deinterleave_real_16i_impl_names;
    const int *impl_deps = get_machine()->volk_16ic_deinterleave_real_16i_impl_deps;
    const bool *alignment = get_machine()->volk_16ic_deinterleave_real_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_16ic_deinterleave_real_16i_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_16ic_deinterleave_real_16i_a = get_machine()->volk_16ic_deinterleave_real_16i_impls[index_a];
    volk_16ic_deinterleave_real_16i_u = get_machine()->volk_16ic_deinterleave_real_16i_impls[index_u];

    assert(volk_16ic_deinterleave_real_16i_a);
    assert(volk_16ic_deinterleave_real_16i_u);

    volk_16ic_deinterleave_real_16i = &__volk_16ic_deinterleave_real_16i_d;
}

static inline void __volk_16ic_deinterleave_real_16i_a(int16_t*  iBuffer, const lv_16sc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_16ic_deinterleave_real_16i();
    volk_16ic_deinterleave_real_16i_a(iBuffer, complexVector, num_points);
}

static inline void __volk_16ic_deinterleave_real_16i_u(int16_t*  iBuffer, const lv_16sc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_16ic_deinterleave_real_16i();
    volk_16ic_deinterleave_real_16i_u(iBuffer, complexVector, num_points);
}

static inline void __volk_16ic_deinterleave_real_16i(int16_t*  iBuffer, const lv_16sc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_16ic_deinterleave_real_16i();
    volk_16ic_deinterleave_real_16i(iBuffer, complexVector, num_points);
}

p_16ic_deinterleave_real_16i volk_16ic_deinterleave_real_16i_a = &__volk_16ic_deinterleave_real_16i_a;
p_16ic_deinterleave_real_16i volk_16ic_deinterleave_real_16i_u = &__volk_16ic_deinterleave_real_16i_u;
p_16ic_deinterleave_real_16i volk_16ic_deinterleave_real_16i   = &__volk_16ic_deinterleave_real_16i;

void volk_16ic_deinterleave_real_16i_manual(int16_t*  iBuffer, const lv_16sc_t*  complexVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_16ic_deinterleave_real_16i_impl_names,
        get_machine()->volk_16ic_deinterleave_real_16i_n_impls,
        impl_name
    );
    get_machine()->volk_16ic_deinterleave_real_16i_impls[index](
        iBuffer, complexVector, num_points
    );
}

volk_func_desc_t volk_16ic_deinterleave_real_16i_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_16ic_deinterleave_real_16i_impl_names;
    const int *impl_deps = get_machine()->volk_16ic_deinterleave_real_16i_impl_deps;
    const bool *alignment = get_machine()->volk_16ic_deinterleave_real_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_16ic_deinterleave_real_16i_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_16ic_deinterleave_real_8i_d(int8_t*  iBuffer, const lv_16sc_t*  complexVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(iBuffer,
        VOLK_OR_PTR(complexVector,
        0))
    )){
        volk_16ic_deinterleave_real_8i_a(iBuffer, complexVector, num_points);
    }
    else{
        volk_16ic_deinterleave_real_8i_u(iBuffer, complexVector, num_points);
    }
}

static inline void __init_volk_16ic_deinterleave_real_8i(void)
{
    const char *name = get_machine()->volk_16ic_deinterleave_real_8i_name;
    const char **impl_names = get_machine()->volk_16ic_deinterleave_real_8i_impl_names;
    const int *impl_deps = get_machine()->volk_16ic_deinterleave_real_8i_impl_deps;
    const bool *alignment = get_machine()->volk_16ic_deinterleave_real_8i_impl_alignment;
    const size_t n_impls = get_machine()->volk_16ic_deinterleave_real_8i_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_16ic_deinterleave_real_8i_a = get_machine()->volk_16ic_deinterleave_real_8i_impls[index_a];
    volk_16ic_deinterleave_real_8i_u = get_machine()->volk_16ic_deinterleave_real_8i_impls[index_u];

    assert(volk_16ic_deinterleave_real_8i_a);
    assert(volk_16ic_deinterleave_real_8i_u);

    volk_16ic_deinterleave_real_8i = &__volk_16ic_deinterleave_real_8i_d;
}

static inline void __volk_16ic_deinterleave_real_8i_a(int8_t*  iBuffer, const lv_16sc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_16ic_deinterleave_real_8i();
    volk_16ic_deinterleave_real_8i_a(iBuffer, complexVector, num_points);
}

static inline void __volk_16ic_deinterleave_real_8i_u(int8_t*  iBuffer, const lv_16sc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_16ic_deinterleave_real_8i();
    volk_16ic_deinterleave_real_8i_u(iBuffer, complexVector, num_points);
}

static inline void __volk_16ic_deinterleave_real_8i(int8_t*  iBuffer, const lv_16sc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_16ic_deinterleave_real_8i();
    volk_16ic_deinterleave_real_8i(iBuffer, complexVector, num_points);
}

p_16ic_deinterleave_real_8i volk_16ic_deinterleave_real_8i_a = &__volk_16ic_deinterleave_real_8i_a;
p_16ic_deinterleave_real_8i volk_16ic_deinterleave_real_8i_u = &__volk_16ic_deinterleave_real_8i_u;
p_16ic_deinterleave_real_8i volk_16ic_deinterleave_real_8i   = &__volk_16ic_deinterleave_real_8i;

void volk_16ic_deinterleave_real_8i_manual(int8_t*  iBuffer, const lv_16sc_t*  complexVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_16ic_deinterleave_real_8i_impl_names,
        get_machine()->volk_16ic_deinterleave_real_8i_n_impls,
        impl_name
    );
    get_machine()->volk_16ic_deinterleave_real_8i_impls[index](
        iBuffer, complexVector, num_points
    );
}

volk_func_desc_t volk_16ic_deinterleave_real_8i_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_16ic_deinterleave_real_8i_impl_names;
    const int *impl_deps = get_machine()->volk_16ic_deinterleave_real_8i_impl_deps;
    const bool *alignment = get_machine()->volk_16ic_deinterleave_real_8i_impl_alignment;
    const size_t n_impls = get_machine()->volk_16ic_deinterleave_real_8i_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_16ic_magnitude_16i_d(int16_t*  magnitudeVector, const lv_16sc_t*  complexVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(magnitudeVector,
        VOLK_OR_PTR(complexVector,
        0))
    )){
        volk_16ic_magnitude_16i_a(magnitudeVector, complexVector, num_points);
    }
    else{
        volk_16ic_magnitude_16i_u(magnitudeVector, complexVector, num_points);
    }
}

static inline void __init_volk_16ic_magnitude_16i(void)
{
    const char *name = get_machine()->volk_16ic_magnitude_16i_name;
    const char **impl_names = get_machine()->volk_16ic_magnitude_16i_impl_names;
    const int *impl_deps = get_machine()->volk_16ic_magnitude_16i_impl_deps;
    const bool *alignment = get_machine()->volk_16ic_magnitude_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_16ic_magnitude_16i_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_16ic_magnitude_16i_a = get_machine()->volk_16ic_magnitude_16i_impls[index_a];
    volk_16ic_magnitude_16i_u = get_machine()->volk_16ic_magnitude_16i_impls[index_u];

    assert(volk_16ic_magnitude_16i_a);
    assert(volk_16ic_magnitude_16i_u);

    volk_16ic_magnitude_16i = &__volk_16ic_magnitude_16i_d;
}

static inline void __volk_16ic_magnitude_16i_a(int16_t*  magnitudeVector, const lv_16sc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_16ic_magnitude_16i();
    volk_16ic_magnitude_16i_a(magnitudeVector, complexVector, num_points);
}

static inline void __volk_16ic_magnitude_16i_u(int16_t*  magnitudeVector, const lv_16sc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_16ic_magnitude_16i();
    volk_16ic_magnitude_16i_u(magnitudeVector, complexVector, num_points);
}

static inline void __volk_16ic_magnitude_16i(int16_t*  magnitudeVector, const lv_16sc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_16ic_magnitude_16i();
    volk_16ic_magnitude_16i(magnitudeVector, complexVector, num_points);
}

p_16ic_magnitude_16i volk_16ic_magnitude_16i_a = &__volk_16ic_magnitude_16i_a;
p_16ic_magnitude_16i volk_16ic_magnitude_16i_u = &__volk_16ic_magnitude_16i_u;
p_16ic_magnitude_16i volk_16ic_magnitude_16i   = &__volk_16ic_magnitude_16i;

void volk_16ic_magnitude_16i_manual(int16_t*  magnitudeVector, const lv_16sc_t*  complexVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_16ic_magnitude_16i_impl_names,
        get_machine()->volk_16ic_magnitude_16i_n_impls,
        impl_name
    );
    get_machine()->volk_16ic_magnitude_16i_impls[index](
        magnitudeVector, complexVector, num_points
    );
}

volk_func_desc_t volk_16ic_magnitude_16i_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_16ic_magnitude_16i_impl_names;
    const int *impl_deps = get_machine()->volk_16ic_magnitude_16i_impl_deps;
    const bool *alignment = get_machine()->volk_16ic_magnitude_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_16ic_magnitude_16i_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_16ic_s32f_deinterleave_32f_x2_d(float*  iBuffer, float*  qBuffer, const lv_16sc_t*  complexVector, const float  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(iBuffer,
        VOLK_OR_PTR(qBuffer,
        VOLK_OR_PTR(complexVector,
        0)))
    )){
        volk_16ic_s32f_deinterleave_32f_x2_a(iBuffer, qBuffer, complexVector, scalar, num_points);
    }
    else{
        volk_16ic_s32f_deinterleave_32f_x2_u(iBuffer, qBuffer, complexVector, scalar, num_points);
    }
}

static inline void __init_volk_16ic_s32f_deinterleave_32f_x2(void)
{
    const char *name = get_machine()->volk_16ic_s32f_deinterleave_32f_x2_name;
    const char **impl_names = get_machine()->volk_16ic_s32f_deinterleave_32f_x2_impl_names;
    const int *impl_deps = get_machine()->volk_16ic_s32f_deinterleave_32f_x2_impl_deps;
    const bool *alignment = get_machine()->volk_16ic_s32f_deinterleave_32f_x2_impl_alignment;
    const size_t n_impls = get_machine()->volk_16ic_s32f_deinterleave_32f_x2_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_16ic_s32f_deinterleave_32f_x2_a = get_machine()->volk_16ic_s32f_deinterleave_32f_x2_impls[index_a];
    volk_16ic_s32f_deinterleave_32f_x2_u = get_machine()->volk_16ic_s32f_deinterleave_32f_x2_impls[index_u];

    assert(volk_16ic_s32f_deinterleave_32f_x2_a);
    assert(volk_16ic_s32f_deinterleave_32f_x2_u);

    volk_16ic_s32f_deinterleave_32f_x2 = &__volk_16ic_s32f_deinterleave_32f_x2_d;
}

static inline void __volk_16ic_s32f_deinterleave_32f_x2_a(float*  iBuffer, float*  qBuffer, const lv_16sc_t*  complexVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_16ic_s32f_deinterleave_32f_x2();
    volk_16ic_s32f_deinterleave_32f_x2_a(iBuffer, qBuffer, complexVector, scalar, num_points);
}

static inline void __volk_16ic_s32f_deinterleave_32f_x2_u(float*  iBuffer, float*  qBuffer, const lv_16sc_t*  complexVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_16ic_s32f_deinterleave_32f_x2();
    volk_16ic_s32f_deinterleave_32f_x2_u(iBuffer, qBuffer, complexVector, scalar, num_points);
}

static inline void __volk_16ic_s32f_deinterleave_32f_x2(float*  iBuffer, float*  qBuffer, const lv_16sc_t*  complexVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_16ic_s32f_deinterleave_32f_x2();
    volk_16ic_s32f_deinterleave_32f_x2(iBuffer, qBuffer, complexVector, scalar, num_points);
}

p_16ic_s32f_deinterleave_32f_x2 volk_16ic_s32f_deinterleave_32f_x2_a = &__volk_16ic_s32f_deinterleave_32f_x2_a;
p_16ic_s32f_deinterleave_32f_x2 volk_16ic_s32f_deinterleave_32f_x2_u = &__volk_16ic_s32f_deinterleave_32f_x2_u;
p_16ic_s32f_deinterleave_32f_x2 volk_16ic_s32f_deinterleave_32f_x2   = &__volk_16ic_s32f_deinterleave_32f_x2;

void volk_16ic_s32f_deinterleave_32f_x2_manual(float*  iBuffer, float*  qBuffer, const lv_16sc_t*  complexVector, const float  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_16ic_s32f_deinterleave_32f_x2_impl_names,
        get_machine()->volk_16ic_s32f_deinterleave_32f_x2_n_impls,
        impl_name
    );
    get_machine()->volk_16ic_s32f_deinterleave_32f_x2_impls[index](
        iBuffer, qBuffer, complexVector, scalar, num_points
    );
}

volk_func_desc_t volk_16ic_s32f_deinterleave_32f_x2_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_16ic_s32f_deinterleave_32f_x2_impl_names;
    const int *impl_deps = get_machine()->volk_16ic_s32f_deinterleave_32f_x2_impl_deps;
    const bool *alignment = get_machine()->volk_16ic_s32f_deinterleave_32f_x2_impl_alignment;
    const size_t n_impls = get_machine()->volk_16ic_s32f_deinterleave_32f_x2_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_16ic_s32f_deinterleave_real_32f_d(float*  iBuffer, const lv_16sc_t*  complexVector, const float  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(iBuffer,
        VOLK_OR_PTR(complexVector,
        0))
    )){
        volk_16ic_s32f_deinterleave_real_32f_a(iBuffer, complexVector, scalar, num_points);
    }
    else{
        volk_16ic_s32f_deinterleave_real_32f_u(iBuffer, complexVector, scalar, num_points);
    }
}

static inline void __init_volk_16ic_s32f_deinterleave_real_32f(void)
{
    const char *name = get_machine()->volk_16ic_s32f_deinterleave_real_32f_name;
    const char **impl_names = get_machine()->volk_16ic_s32f_deinterleave_real_32f_impl_names;
    const int *impl_deps = get_machine()->volk_16ic_s32f_deinterleave_real_32f_impl_deps;
    const bool *alignment = get_machine()->volk_16ic_s32f_deinterleave_real_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_16ic_s32f_deinterleave_real_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_16ic_s32f_deinterleave_real_32f_a = get_machine()->volk_16ic_s32f_deinterleave_real_32f_impls[index_a];
    volk_16ic_s32f_deinterleave_real_32f_u = get_machine()->volk_16ic_s32f_deinterleave_real_32f_impls[index_u];

    assert(volk_16ic_s32f_deinterleave_real_32f_a);
    assert(volk_16ic_s32f_deinterleave_real_32f_u);

    volk_16ic_s32f_deinterleave_real_32f = &__volk_16ic_s32f_deinterleave_real_32f_d;
}

static inline void __volk_16ic_s32f_deinterleave_real_32f_a(float*  iBuffer, const lv_16sc_t*  complexVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_16ic_s32f_deinterleave_real_32f();
    volk_16ic_s32f_deinterleave_real_32f_a(iBuffer, complexVector, scalar, num_points);
}

static inline void __volk_16ic_s32f_deinterleave_real_32f_u(float*  iBuffer, const lv_16sc_t*  complexVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_16ic_s32f_deinterleave_real_32f();
    volk_16ic_s32f_deinterleave_real_32f_u(iBuffer, complexVector, scalar, num_points);
}

static inline void __volk_16ic_s32f_deinterleave_real_32f(float*  iBuffer, const lv_16sc_t*  complexVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_16ic_s32f_deinterleave_real_32f();
    volk_16ic_s32f_deinterleave_real_32f(iBuffer, complexVector, scalar, num_points);
}

p_16ic_s32f_deinterleave_real_32f volk_16ic_s32f_deinterleave_real_32f_a = &__volk_16ic_s32f_deinterleave_real_32f_a;
p_16ic_s32f_deinterleave_real_32f volk_16ic_s32f_deinterleave_real_32f_u = &__volk_16ic_s32f_deinterleave_real_32f_u;
p_16ic_s32f_deinterleave_real_32f volk_16ic_s32f_deinterleave_real_32f   = &__volk_16ic_s32f_deinterleave_real_32f;

void volk_16ic_s32f_deinterleave_real_32f_manual(float*  iBuffer, const lv_16sc_t*  complexVector, const float  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_16ic_s32f_deinterleave_real_32f_impl_names,
        get_machine()->volk_16ic_s32f_deinterleave_real_32f_n_impls,
        impl_name
    );
    get_machine()->volk_16ic_s32f_deinterleave_real_32f_impls[index](
        iBuffer, complexVector, scalar, num_points
    );
}

volk_func_desc_t volk_16ic_s32f_deinterleave_real_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_16ic_s32f_deinterleave_real_32f_impl_names;
    const int *impl_deps = get_machine()->volk_16ic_s32f_deinterleave_real_32f_impl_deps;
    const bool *alignment = get_machine()->volk_16ic_s32f_deinterleave_real_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_16ic_s32f_deinterleave_real_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_16ic_s32f_magnitude_32f_d(float*  magnitudeVector, const lv_16sc_t*  complexVector, const float  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(magnitudeVector,
        VOLK_OR_PTR(complexVector,
        0))
    )){
        volk_16ic_s32f_magnitude_32f_a(magnitudeVector, complexVector, scalar, num_points);
    }
    else{
        volk_16ic_s32f_magnitude_32f_u(magnitudeVector, complexVector, scalar, num_points);
    }
}

static inline void __init_volk_16ic_s32f_magnitude_32f(void)
{
    const char *name = get_machine()->volk_16ic_s32f_magnitude_32f_name;
    const char **impl_names = get_machine()->volk_16ic_s32f_magnitude_32f_impl_names;
    const int *impl_deps = get_machine()->volk_16ic_s32f_magnitude_32f_impl_deps;
    const bool *alignment = get_machine()->volk_16ic_s32f_magnitude_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_16ic_s32f_magnitude_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_16ic_s32f_magnitude_32f_a = get_machine()->volk_16ic_s32f_magnitude_32f_impls[index_a];
    volk_16ic_s32f_magnitude_32f_u = get_machine()->volk_16ic_s32f_magnitude_32f_impls[index_u];

    assert(volk_16ic_s32f_magnitude_32f_a);
    assert(volk_16ic_s32f_magnitude_32f_u);

    volk_16ic_s32f_magnitude_32f = &__volk_16ic_s32f_magnitude_32f_d;
}

static inline void __volk_16ic_s32f_magnitude_32f_a(float*  magnitudeVector, const lv_16sc_t*  complexVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_16ic_s32f_magnitude_32f();
    volk_16ic_s32f_magnitude_32f_a(magnitudeVector, complexVector, scalar, num_points);
}

static inline void __volk_16ic_s32f_magnitude_32f_u(float*  magnitudeVector, const lv_16sc_t*  complexVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_16ic_s32f_magnitude_32f();
    volk_16ic_s32f_magnitude_32f_u(magnitudeVector, complexVector, scalar, num_points);
}

static inline void __volk_16ic_s32f_magnitude_32f(float*  magnitudeVector, const lv_16sc_t*  complexVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_16ic_s32f_magnitude_32f();
    volk_16ic_s32f_magnitude_32f(magnitudeVector, complexVector, scalar, num_points);
}

p_16ic_s32f_magnitude_32f volk_16ic_s32f_magnitude_32f_a = &__volk_16ic_s32f_magnitude_32f_a;
p_16ic_s32f_magnitude_32f volk_16ic_s32f_magnitude_32f_u = &__volk_16ic_s32f_magnitude_32f_u;
p_16ic_s32f_magnitude_32f volk_16ic_s32f_magnitude_32f   = &__volk_16ic_s32f_magnitude_32f;

void volk_16ic_s32f_magnitude_32f_manual(float*  magnitudeVector, const lv_16sc_t*  complexVector, const float  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_16ic_s32f_magnitude_32f_impl_names,
        get_machine()->volk_16ic_s32f_magnitude_32f_n_impls,
        impl_name
    );
    get_machine()->volk_16ic_s32f_magnitude_32f_impls[index](
        magnitudeVector, complexVector, scalar, num_points
    );
}

volk_func_desc_t volk_16ic_s32f_magnitude_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_16ic_s32f_magnitude_32f_impl_names;
    const int *impl_deps = get_machine()->volk_16ic_s32f_magnitude_32f_impl_deps;
    const bool *alignment = get_machine()->volk_16ic_s32f_magnitude_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_16ic_s32f_magnitude_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_16ic_x2_dot_prod_16ic_d(lv_16sc_t*  result, const lv_16sc_t*  in_a, const lv_16sc_t*  in_b, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(result,
        VOLK_OR_PTR(in_a,
        VOLK_OR_PTR(in_b,
        0)))
    )){
        volk_16ic_x2_dot_prod_16ic_a(result, in_a, in_b, num_points);
    }
    else{
        volk_16ic_x2_dot_prod_16ic_u(result, in_a, in_b, num_points);
    }
}

static inline void __init_volk_16ic_x2_dot_prod_16ic(void)
{
    const char *name = get_machine()->volk_16ic_x2_dot_prod_16ic_name;
    const char **impl_names = get_machine()->volk_16ic_x2_dot_prod_16ic_impl_names;
    const int *impl_deps = get_machine()->volk_16ic_x2_dot_prod_16ic_impl_deps;
    const bool *alignment = get_machine()->volk_16ic_x2_dot_prod_16ic_impl_alignment;
    const size_t n_impls = get_machine()->volk_16ic_x2_dot_prod_16ic_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_16ic_x2_dot_prod_16ic_a = get_machine()->volk_16ic_x2_dot_prod_16ic_impls[index_a];
    volk_16ic_x2_dot_prod_16ic_u = get_machine()->volk_16ic_x2_dot_prod_16ic_impls[index_u];

    assert(volk_16ic_x2_dot_prod_16ic_a);
    assert(volk_16ic_x2_dot_prod_16ic_u);

    volk_16ic_x2_dot_prod_16ic = &__volk_16ic_x2_dot_prod_16ic_d;
}

static inline void __volk_16ic_x2_dot_prod_16ic_a(lv_16sc_t*  result, const lv_16sc_t*  in_a, const lv_16sc_t*  in_b, unsigned int  num_points)
{
    __init_volk_16ic_x2_dot_prod_16ic();
    volk_16ic_x2_dot_prod_16ic_a(result, in_a, in_b, num_points);
}

static inline void __volk_16ic_x2_dot_prod_16ic_u(lv_16sc_t*  result, const lv_16sc_t*  in_a, const lv_16sc_t*  in_b, unsigned int  num_points)
{
    __init_volk_16ic_x2_dot_prod_16ic();
    volk_16ic_x2_dot_prod_16ic_u(result, in_a, in_b, num_points);
}

static inline void __volk_16ic_x2_dot_prod_16ic(lv_16sc_t*  result, const lv_16sc_t*  in_a, const lv_16sc_t*  in_b, unsigned int  num_points)
{
    __init_volk_16ic_x2_dot_prod_16ic();
    volk_16ic_x2_dot_prod_16ic(result, in_a, in_b, num_points);
}

p_16ic_x2_dot_prod_16ic volk_16ic_x2_dot_prod_16ic_a = &__volk_16ic_x2_dot_prod_16ic_a;
p_16ic_x2_dot_prod_16ic volk_16ic_x2_dot_prod_16ic_u = &__volk_16ic_x2_dot_prod_16ic_u;
p_16ic_x2_dot_prod_16ic volk_16ic_x2_dot_prod_16ic   = &__volk_16ic_x2_dot_prod_16ic;

void volk_16ic_x2_dot_prod_16ic_manual(lv_16sc_t*  result, const lv_16sc_t*  in_a, const lv_16sc_t*  in_b, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_16ic_x2_dot_prod_16ic_impl_names,
        get_machine()->volk_16ic_x2_dot_prod_16ic_n_impls,
        impl_name
    );
    get_machine()->volk_16ic_x2_dot_prod_16ic_impls[index](
        result, in_a, in_b, num_points
    );
}

volk_func_desc_t volk_16ic_x2_dot_prod_16ic_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_16ic_x2_dot_prod_16ic_impl_names;
    const int *impl_deps = get_machine()->volk_16ic_x2_dot_prod_16ic_impl_deps;
    const bool *alignment = get_machine()->volk_16ic_x2_dot_prod_16ic_impl_alignment;
    const size_t n_impls = get_machine()->volk_16ic_x2_dot_prod_16ic_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_16ic_x2_multiply_16ic_d(lv_16sc_t*  result, const lv_16sc_t*  in_a, const lv_16sc_t*  in_b, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(result,
        VOLK_OR_PTR(in_a,
        VOLK_OR_PTR(in_b,
        0)))
    )){
        volk_16ic_x2_multiply_16ic_a(result, in_a, in_b, num_points);
    }
    else{
        volk_16ic_x2_multiply_16ic_u(result, in_a, in_b, num_points);
    }
}

static inline void __init_volk_16ic_x2_multiply_16ic(void)
{
    const char *name = get_machine()->volk_16ic_x2_multiply_16ic_name;
    const char **impl_names = get_machine()->volk_16ic_x2_multiply_16ic_impl_names;
    const int *impl_deps = get_machine()->volk_16ic_x2_multiply_16ic_impl_deps;
    const bool *alignment = get_machine()->volk_16ic_x2_multiply_16ic_impl_alignment;
    const size_t n_impls = get_machine()->volk_16ic_x2_multiply_16ic_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_16ic_x2_multiply_16ic_a = get_machine()->volk_16ic_x2_multiply_16ic_impls[index_a];
    volk_16ic_x2_multiply_16ic_u = get_machine()->volk_16ic_x2_multiply_16ic_impls[index_u];

    assert(volk_16ic_x2_multiply_16ic_a);
    assert(volk_16ic_x2_multiply_16ic_u);

    volk_16ic_x2_multiply_16ic = &__volk_16ic_x2_multiply_16ic_d;
}

static inline void __volk_16ic_x2_multiply_16ic_a(lv_16sc_t*  result, const lv_16sc_t*  in_a, const lv_16sc_t*  in_b, unsigned int  num_points)
{
    __init_volk_16ic_x2_multiply_16ic();
    volk_16ic_x2_multiply_16ic_a(result, in_a, in_b, num_points);
}

static inline void __volk_16ic_x2_multiply_16ic_u(lv_16sc_t*  result, const lv_16sc_t*  in_a, const lv_16sc_t*  in_b, unsigned int  num_points)
{
    __init_volk_16ic_x2_multiply_16ic();
    volk_16ic_x2_multiply_16ic_u(result, in_a, in_b, num_points);
}

static inline void __volk_16ic_x2_multiply_16ic(lv_16sc_t*  result, const lv_16sc_t*  in_a, const lv_16sc_t*  in_b, unsigned int  num_points)
{
    __init_volk_16ic_x2_multiply_16ic();
    volk_16ic_x2_multiply_16ic(result, in_a, in_b, num_points);
}

p_16ic_x2_multiply_16ic volk_16ic_x2_multiply_16ic_a = &__volk_16ic_x2_multiply_16ic_a;
p_16ic_x2_multiply_16ic volk_16ic_x2_multiply_16ic_u = &__volk_16ic_x2_multiply_16ic_u;
p_16ic_x2_multiply_16ic volk_16ic_x2_multiply_16ic   = &__volk_16ic_x2_multiply_16ic;

void volk_16ic_x2_multiply_16ic_manual(lv_16sc_t*  result, const lv_16sc_t*  in_a, const lv_16sc_t*  in_b, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_16ic_x2_multiply_16ic_impl_names,
        get_machine()->volk_16ic_x2_multiply_16ic_n_impls,
        impl_name
    );
    get_machine()->volk_16ic_x2_multiply_16ic_impls[index](
        result, in_a, in_b, num_points
    );
}

volk_func_desc_t volk_16ic_x2_multiply_16ic_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_16ic_x2_multiply_16ic_impl_names;
    const int *impl_deps = get_machine()->volk_16ic_x2_multiply_16ic_impl_deps;
    const bool *alignment = get_machine()->volk_16ic_x2_multiply_16ic_impl_alignment;
    const size_t n_impls = get_machine()->volk_16ic_x2_multiply_16ic_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_16u_byteswap_d(uint16_t*  intsToSwap, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(intsToSwap,
        0)
    )){
        volk_16u_byteswap_a(intsToSwap, num_points);
    }
    else{
        volk_16u_byteswap_u(intsToSwap, num_points);
    }
}

static inline void __init_volk_16u_byteswap(void)
{
    const char *name = get_machine()->volk_16u_byteswap_name;
    const char **impl_names = get_machine()->volk_16u_byteswap_impl_names;
    const int *impl_deps = get_machine()->volk_16u_byteswap_impl_deps;
    const bool *alignment = get_machine()->volk_16u_byteswap_impl_alignment;
    const size_t n_impls = get_machine()->volk_16u_byteswap_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_16u_byteswap_a = get_machine()->volk_16u_byteswap_impls[index_a];
    volk_16u_byteswap_u = get_machine()->volk_16u_byteswap_impls[index_u];

    assert(volk_16u_byteswap_a);
    assert(volk_16u_byteswap_u);

    volk_16u_byteswap = &__volk_16u_byteswap_d;
}

static inline void __volk_16u_byteswap_a(uint16_t*  intsToSwap, unsigned int  num_points)
{
    __init_volk_16u_byteswap();
    volk_16u_byteswap_a(intsToSwap, num_points);
}

static inline void __volk_16u_byteswap_u(uint16_t*  intsToSwap, unsigned int  num_points)
{
    __init_volk_16u_byteswap();
    volk_16u_byteswap_u(intsToSwap, num_points);
}

static inline void __volk_16u_byteswap(uint16_t*  intsToSwap, unsigned int  num_points)
{
    __init_volk_16u_byteswap();
    volk_16u_byteswap(intsToSwap, num_points);
}

p_16u_byteswap volk_16u_byteswap_a = &__volk_16u_byteswap_a;
p_16u_byteswap volk_16u_byteswap_u = &__volk_16u_byteswap_u;
p_16u_byteswap volk_16u_byteswap   = &__volk_16u_byteswap;

void volk_16u_byteswap_manual(uint16_t*  intsToSwap, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_16u_byteswap_impl_names,
        get_machine()->volk_16u_byteswap_n_impls,
        impl_name
    );
    get_machine()->volk_16u_byteswap_impls[index](
        intsToSwap, num_points
    );
}

volk_func_desc_t volk_16u_byteswap_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_16u_byteswap_impl_names;
    const int *impl_deps = get_machine()->volk_16u_byteswap_impl_deps;
    const bool *alignment = get_machine()->volk_16u_byteswap_impl_alignment;
    const size_t n_impls = get_machine()->volk_16u_byteswap_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_16u_byteswappuppet_16u_d(uint16_t*  output, uint16_t*  intsToSwap, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(output,
        VOLK_OR_PTR(intsToSwap,
        0))
    )){
        volk_16u_byteswappuppet_16u_a(output, intsToSwap, num_points);
    }
    else{
        volk_16u_byteswappuppet_16u_u(output, intsToSwap, num_points);
    }
}

static inline void __init_volk_16u_byteswappuppet_16u(void)
{
    const char *name = get_machine()->volk_16u_byteswappuppet_16u_name;
    const char **impl_names = get_machine()->volk_16u_byteswappuppet_16u_impl_names;
    const int *impl_deps = get_machine()->volk_16u_byteswappuppet_16u_impl_deps;
    const bool *alignment = get_machine()->volk_16u_byteswappuppet_16u_impl_alignment;
    const size_t n_impls = get_machine()->volk_16u_byteswappuppet_16u_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_16u_byteswappuppet_16u_a = get_machine()->volk_16u_byteswappuppet_16u_impls[index_a];
    volk_16u_byteswappuppet_16u_u = get_machine()->volk_16u_byteswappuppet_16u_impls[index_u];

    assert(volk_16u_byteswappuppet_16u_a);
    assert(volk_16u_byteswappuppet_16u_u);

    volk_16u_byteswappuppet_16u = &__volk_16u_byteswappuppet_16u_d;
}

static inline void __volk_16u_byteswappuppet_16u_a(uint16_t*  output, uint16_t*  intsToSwap, unsigned int  num_points)
{
    __init_volk_16u_byteswappuppet_16u();
    volk_16u_byteswappuppet_16u_a(output, intsToSwap, num_points);
}

static inline void __volk_16u_byteswappuppet_16u_u(uint16_t*  output, uint16_t*  intsToSwap, unsigned int  num_points)
{
    __init_volk_16u_byteswappuppet_16u();
    volk_16u_byteswappuppet_16u_u(output, intsToSwap, num_points);
}

static inline void __volk_16u_byteswappuppet_16u(uint16_t*  output, uint16_t*  intsToSwap, unsigned int  num_points)
{
    __init_volk_16u_byteswappuppet_16u();
    volk_16u_byteswappuppet_16u(output, intsToSwap, num_points);
}

p_16u_byteswappuppet_16u volk_16u_byteswappuppet_16u_a = &__volk_16u_byteswappuppet_16u_a;
p_16u_byteswappuppet_16u volk_16u_byteswappuppet_16u_u = &__volk_16u_byteswappuppet_16u_u;
p_16u_byteswappuppet_16u volk_16u_byteswappuppet_16u   = &__volk_16u_byteswappuppet_16u;

void volk_16u_byteswappuppet_16u_manual(uint16_t*  output, uint16_t*  intsToSwap, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_16u_byteswappuppet_16u_impl_names,
        get_machine()->volk_16u_byteswappuppet_16u_n_impls,
        impl_name
    );
    get_machine()->volk_16u_byteswappuppet_16u_impls[index](
        output, intsToSwap, num_points
    );
}

volk_func_desc_t volk_16u_byteswappuppet_16u_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_16u_byteswappuppet_16u_impl_names;
    const int *impl_deps = get_machine()->volk_16u_byteswappuppet_16u_impl_deps;
    const bool *alignment = get_machine()->volk_16u_byteswappuppet_16u_impl_alignment;
    const size_t n_impls = get_machine()->volk_16u_byteswappuppet_16u_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_64f_add_64f_d(double*  cVector, const float*  aVector, const double*  bVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_32f_64f_add_64f_a(cVector, aVector, bVector, num_points);
    }
    else{
        volk_32f_64f_add_64f_u(cVector, aVector, bVector, num_points);
    }
}

static inline void __init_volk_32f_64f_add_64f(void)
{
    const char *name = get_machine()->volk_32f_64f_add_64f_name;
    const char **impl_names = get_machine()->volk_32f_64f_add_64f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_64f_add_64f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_64f_add_64f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_64f_add_64f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_64f_add_64f_a = get_machine()->volk_32f_64f_add_64f_impls[index_a];
    volk_32f_64f_add_64f_u = get_machine()->volk_32f_64f_add_64f_impls[index_u];

    assert(volk_32f_64f_add_64f_a);
    assert(volk_32f_64f_add_64f_u);

    volk_32f_64f_add_64f = &__volk_32f_64f_add_64f_d;
}

static inline void __volk_32f_64f_add_64f_a(double*  cVector, const float*  aVector, const double*  bVector, unsigned int  num_points)
{
    __init_volk_32f_64f_add_64f();
    volk_32f_64f_add_64f_a(cVector, aVector, bVector, num_points);
}

static inline void __volk_32f_64f_add_64f_u(double*  cVector, const float*  aVector, const double*  bVector, unsigned int  num_points)
{
    __init_volk_32f_64f_add_64f();
    volk_32f_64f_add_64f_u(cVector, aVector, bVector, num_points);
}

static inline void __volk_32f_64f_add_64f(double*  cVector, const float*  aVector, const double*  bVector, unsigned int  num_points)
{
    __init_volk_32f_64f_add_64f();
    volk_32f_64f_add_64f(cVector, aVector, bVector, num_points);
}

p_32f_64f_add_64f volk_32f_64f_add_64f_a = &__volk_32f_64f_add_64f_a;
p_32f_64f_add_64f volk_32f_64f_add_64f_u = &__volk_32f_64f_add_64f_u;
p_32f_64f_add_64f volk_32f_64f_add_64f   = &__volk_32f_64f_add_64f;

void volk_32f_64f_add_64f_manual(double*  cVector, const float*  aVector, const double*  bVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_64f_add_64f_impl_names,
        get_machine()->volk_32f_64f_add_64f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_64f_add_64f_impls[index](
        cVector, aVector, bVector, num_points
    );
}

volk_func_desc_t volk_32f_64f_add_64f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_64f_add_64f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_64f_add_64f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_64f_add_64f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_64f_add_64f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_64f_multiply_64f_d(double*  cVector, const float*  aVector, const double*  bVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_32f_64f_multiply_64f_a(cVector, aVector, bVector, num_points);
    }
    else{
        volk_32f_64f_multiply_64f_u(cVector, aVector, bVector, num_points);
    }
}

static inline void __init_volk_32f_64f_multiply_64f(void)
{
    const char *name = get_machine()->volk_32f_64f_multiply_64f_name;
    const char **impl_names = get_machine()->volk_32f_64f_multiply_64f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_64f_multiply_64f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_64f_multiply_64f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_64f_multiply_64f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_64f_multiply_64f_a = get_machine()->volk_32f_64f_multiply_64f_impls[index_a];
    volk_32f_64f_multiply_64f_u = get_machine()->volk_32f_64f_multiply_64f_impls[index_u];

    assert(volk_32f_64f_multiply_64f_a);
    assert(volk_32f_64f_multiply_64f_u);

    volk_32f_64f_multiply_64f = &__volk_32f_64f_multiply_64f_d;
}

static inline void __volk_32f_64f_multiply_64f_a(double*  cVector, const float*  aVector, const double*  bVector, unsigned int  num_points)
{
    __init_volk_32f_64f_multiply_64f();
    volk_32f_64f_multiply_64f_a(cVector, aVector, bVector, num_points);
}

static inline void __volk_32f_64f_multiply_64f_u(double*  cVector, const float*  aVector, const double*  bVector, unsigned int  num_points)
{
    __init_volk_32f_64f_multiply_64f();
    volk_32f_64f_multiply_64f_u(cVector, aVector, bVector, num_points);
}

static inline void __volk_32f_64f_multiply_64f(double*  cVector, const float*  aVector, const double*  bVector, unsigned int  num_points)
{
    __init_volk_32f_64f_multiply_64f();
    volk_32f_64f_multiply_64f(cVector, aVector, bVector, num_points);
}

p_32f_64f_multiply_64f volk_32f_64f_multiply_64f_a = &__volk_32f_64f_multiply_64f_a;
p_32f_64f_multiply_64f volk_32f_64f_multiply_64f_u = &__volk_32f_64f_multiply_64f_u;
p_32f_64f_multiply_64f volk_32f_64f_multiply_64f   = &__volk_32f_64f_multiply_64f;

void volk_32f_64f_multiply_64f_manual(double*  cVector, const float*  aVector, const double*  bVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_64f_multiply_64f_impl_names,
        get_machine()->volk_32f_64f_multiply_64f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_64f_multiply_64f_impls[index](
        cVector, aVector, bVector, num_points
    );
}

volk_func_desc_t volk_32f_64f_multiply_64f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_64f_multiply_64f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_64f_multiply_64f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_64f_multiply_64f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_64f_multiply_64f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_8u_polarbutterfly_32f_d(float*  llrs, unsigned char*  u, const int  frame_exp, const int  stage, const int  u_num, const int  row)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(llrs,
        VOLK_OR_PTR(u,
        0))
    )){
        volk_32f_8u_polarbutterfly_32f_a(llrs, u, frame_exp, stage, u_num, row);
    }
    else{
        volk_32f_8u_polarbutterfly_32f_u(llrs, u, frame_exp, stage, u_num, row);
    }
}

static inline void __init_volk_32f_8u_polarbutterfly_32f(void)
{
    const char *name = get_machine()->volk_32f_8u_polarbutterfly_32f_name;
    const char **impl_names = get_machine()->volk_32f_8u_polarbutterfly_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_8u_polarbutterfly_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_8u_polarbutterfly_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_8u_polarbutterfly_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_8u_polarbutterfly_32f_a = get_machine()->volk_32f_8u_polarbutterfly_32f_impls[index_a];
    volk_32f_8u_polarbutterfly_32f_u = get_machine()->volk_32f_8u_polarbutterfly_32f_impls[index_u];

    assert(volk_32f_8u_polarbutterfly_32f_a);
    assert(volk_32f_8u_polarbutterfly_32f_u);

    volk_32f_8u_polarbutterfly_32f = &__volk_32f_8u_polarbutterfly_32f_d;
}

static inline void __volk_32f_8u_polarbutterfly_32f_a(float*  llrs, unsigned char*  u, const int  frame_exp, const int  stage, const int  u_num, const int  row)
{
    __init_volk_32f_8u_polarbutterfly_32f();
    volk_32f_8u_polarbutterfly_32f_a(llrs, u, frame_exp, stage, u_num, row);
}

static inline void __volk_32f_8u_polarbutterfly_32f_u(float*  llrs, unsigned char*  u, const int  frame_exp, const int  stage, const int  u_num, const int  row)
{
    __init_volk_32f_8u_polarbutterfly_32f();
    volk_32f_8u_polarbutterfly_32f_u(llrs, u, frame_exp, stage, u_num, row);
}

static inline void __volk_32f_8u_polarbutterfly_32f(float*  llrs, unsigned char*  u, const int  frame_exp, const int  stage, const int  u_num, const int  row)
{
    __init_volk_32f_8u_polarbutterfly_32f();
    volk_32f_8u_polarbutterfly_32f(llrs, u, frame_exp, stage, u_num, row);
}

p_32f_8u_polarbutterfly_32f volk_32f_8u_polarbutterfly_32f_a = &__volk_32f_8u_polarbutterfly_32f_a;
p_32f_8u_polarbutterfly_32f volk_32f_8u_polarbutterfly_32f_u = &__volk_32f_8u_polarbutterfly_32f_u;
p_32f_8u_polarbutterfly_32f volk_32f_8u_polarbutterfly_32f   = &__volk_32f_8u_polarbutterfly_32f;

void volk_32f_8u_polarbutterfly_32f_manual(float*  llrs, unsigned char*  u, const int  frame_exp, const int  stage, const int  u_num, const int  row, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_8u_polarbutterfly_32f_impl_names,
        get_machine()->volk_32f_8u_polarbutterfly_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_8u_polarbutterfly_32f_impls[index](
        llrs, u, frame_exp, stage, u_num, row
    );
}

volk_func_desc_t volk_32f_8u_polarbutterfly_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_8u_polarbutterfly_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_8u_polarbutterfly_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_8u_polarbutterfly_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_8u_polarbutterfly_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_8u_polarbutterflypuppet_32f_d(float*  llrs, const float*  input, unsigned char*  u, const int  elements)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(llrs,
        VOLK_OR_PTR(input,
        VOLK_OR_PTR(u,
        0)))
    )){
        volk_32f_8u_polarbutterflypuppet_32f_a(llrs, input, u, elements);
    }
    else{
        volk_32f_8u_polarbutterflypuppet_32f_u(llrs, input, u, elements);
    }
}

static inline void __init_volk_32f_8u_polarbutterflypuppet_32f(void)
{
    const char *name = get_machine()->volk_32f_8u_polarbutterflypuppet_32f_name;
    const char **impl_names = get_machine()->volk_32f_8u_polarbutterflypuppet_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_8u_polarbutterflypuppet_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_8u_polarbutterflypuppet_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_8u_polarbutterflypuppet_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_8u_polarbutterflypuppet_32f_a = get_machine()->volk_32f_8u_polarbutterflypuppet_32f_impls[index_a];
    volk_32f_8u_polarbutterflypuppet_32f_u = get_machine()->volk_32f_8u_polarbutterflypuppet_32f_impls[index_u];

    assert(volk_32f_8u_polarbutterflypuppet_32f_a);
    assert(volk_32f_8u_polarbutterflypuppet_32f_u);

    volk_32f_8u_polarbutterflypuppet_32f = &__volk_32f_8u_polarbutterflypuppet_32f_d;
}

static inline void __volk_32f_8u_polarbutterflypuppet_32f_a(float*  llrs, const float*  input, unsigned char*  u, const int  elements)
{
    __init_volk_32f_8u_polarbutterflypuppet_32f();
    volk_32f_8u_polarbutterflypuppet_32f_a(llrs, input, u, elements);
}

static inline void __volk_32f_8u_polarbutterflypuppet_32f_u(float*  llrs, const float*  input, unsigned char*  u, const int  elements)
{
    __init_volk_32f_8u_polarbutterflypuppet_32f();
    volk_32f_8u_polarbutterflypuppet_32f_u(llrs, input, u, elements);
}

static inline void __volk_32f_8u_polarbutterflypuppet_32f(float*  llrs, const float*  input, unsigned char*  u, const int  elements)
{
    __init_volk_32f_8u_polarbutterflypuppet_32f();
    volk_32f_8u_polarbutterflypuppet_32f(llrs, input, u, elements);
}

p_32f_8u_polarbutterflypuppet_32f volk_32f_8u_polarbutterflypuppet_32f_a = &__volk_32f_8u_polarbutterflypuppet_32f_a;
p_32f_8u_polarbutterflypuppet_32f volk_32f_8u_polarbutterflypuppet_32f_u = &__volk_32f_8u_polarbutterflypuppet_32f_u;
p_32f_8u_polarbutterflypuppet_32f volk_32f_8u_polarbutterflypuppet_32f   = &__volk_32f_8u_polarbutterflypuppet_32f;

void volk_32f_8u_polarbutterflypuppet_32f_manual(float*  llrs, const float*  input, unsigned char*  u, const int  elements, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_8u_polarbutterflypuppet_32f_impl_names,
        get_machine()->volk_32f_8u_polarbutterflypuppet_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_8u_polarbutterflypuppet_32f_impls[index](
        llrs, input, u, elements
    );
}

volk_func_desc_t volk_32f_8u_polarbutterflypuppet_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_8u_polarbutterflypuppet_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_8u_polarbutterflypuppet_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_8u_polarbutterflypuppet_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_8u_polarbutterflypuppet_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_accumulator_s32f_d(float*  result, const float*  inputBuffer, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(result,
        VOLK_OR_PTR(inputBuffer,
        0))
    )){
        volk_32f_accumulator_s32f_a(result, inputBuffer, num_points);
    }
    else{
        volk_32f_accumulator_s32f_u(result, inputBuffer, num_points);
    }
}

static inline void __init_volk_32f_accumulator_s32f(void)
{
    const char *name = get_machine()->volk_32f_accumulator_s32f_name;
    const char **impl_names = get_machine()->volk_32f_accumulator_s32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_accumulator_s32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_accumulator_s32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_accumulator_s32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_accumulator_s32f_a = get_machine()->volk_32f_accumulator_s32f_impls[index_a];
    volk_32f_accumulator_s32f_u = get_machine()->volk_32f_accumulator_s32f_impls[index_u];

    assert(volk_32f_accumulator_s32f_a);
    assert(volk_32f_accumulator_s32f_u);

    volk_32f_accumulator_s32f = &__volk_32f_accumulator_s32f_d;
}

static inline void __volk_32f_accumulator_s32f_a(float*  result, const float*  inputBuffer, unsigned int  num_points)
{
    __init_volk_32f_accumulator_s32f();
    volk_32f_accumulator_s32f_a(result, inputBuffer, num_points);
}

static inline void __volk_32f_accumulator_s32f_u(float*  result, const float*  inputBuffer, unsigned int  num_points)
{
    __init_volk_32f_accumulator_s32f();
    volk_32f_accumulator_s32f_u(result, inputBuffer, num_points);
}

static inline void __volk_32f_accumulator_s32f(float*  result, const float*  inputBuffer, unsigned int  num_points)
{
    __init_volk_32f_accumulator_s32f();
    volk_32f_accumulator_s32f(result, inputBuffer, num_points);
}

p_32f_accumulator_s32f volk_32f_accumulator_s32f_a = &__volk_32f_accumulator_s32f_a;
p_32f_accumulator_s32f volk_32f_accumulator_s32f_u = &__volk_32f_accumulator_s32f_u;
p_32f_accumulator_s32f volk_32f_accumulator_s32f   = &__volk_32f_accumulator_s32f;

void volk_32f_accumulator_s32f_manual(float*  result, const float*  inputBuffer, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_accumulator_s32f_impl_names,
        get_machine()->volk_32f_accumulator_s32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_accumulator_s32f_impls[index](
        result, inputBuffer, num_points
    );
}

volk_func_desc_t volk_32f_accumulator_s32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_accumulator_s32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_accumulator_s32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_accumulator_s32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_accumulator_s32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_acos_32f_d(float*  bVector, const float*  aVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(bVector,
        VOLK_OR_PTR(aVector,
        0))
    )){
        volk_32f_acos_32f_a(bVector, aVector, num_points);
    }
    else{
        volk_32f_acos_32f_u(bVector, aVector, num_points);
    }
}

static inline void __init_volk_32f_acos_32f(void)
{
    const char *name = get_machine()->volk_32f_acos_32f_name;
    const char **impl_names = get_machine()->volk_32f_acos_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_acos_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_acos_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_acos_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_acos_32f_a = get_machine()->volk_32f_acos_32f_impls[index_a];
    volk_32f_acos_32f_u = get_machine()->volk_32f_acos_32f_impls[index_u];

    assert(volk_32f_acos_32f_a);
    assert(volk_32f_acos_32f_u);

    volk_32f_acos_32f = &__volk_32f_acos_32f_d;
}

static inline void __volk_32f_acos_32f_a(float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_acos_32f();
    volk_32f_acos_32f_a(bVector, aVector, num_points);
}

static inline void __volk_32f_acos_32f_u(float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_acos_32f();
    volk_32f_acos_32f_u(bVector, aVector, num_points);
}

static inline void __volk_32f_acos_32f(float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_acos_32f();
    volk_32f_acos_32f(bVector, aVector, num_points);
}

p_32f_acos_32f volk_32f_acos_32f_a = &__volk_32f_acos_32f_a;
p_32f_acos_32f volk_32f_acos_32f_u = &__volk_32f_acos_32f_u;
p_32f_acos_32f volk_32f_acos_32f   = &__volk_32f_acos_32f;

void volk_32f_acos_32f_manual(float*  bVector, const float*  aVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_acos_32f_impl_names,
        get_machine()->volk_32f_acos_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_acos_32f_impls[index](
        bVector, aVector, num_points
    );
}

volk_func_desc_t volk_32f_acos_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_acos_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_acos_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_acos_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_acos_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_asin_32f_d(float*  bVector, const float*  aVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(bVector,
        VOLK_OR_PTR(aVector,
        0))
    )){
        volk_32f_asin_32f_a(bVector, aVector, num_points);
    }
    else{
        volk_32f_asin_32f_u(bVector, aVector, num_points);
    }
}

static inline void __init_volk_32f_asin_32f(void)
{
    const char *name = get_machine()->volk_32f_asin_32f_name;
    const char **impl_names = get_machine()->volk_32f_asin_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_asin_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_asin_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_asin_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_asin_32f_a = get_machine()->volk_32f_asin_32f_impls[index_a];
    volk_32f_asin_32f_u = get_machine()->volk_32f_asin_32f_impls[index_u];

    assert(volk_32f_asin_32f_a);
    assert(volk_32f_asin_32f_u);

    volk_32f_asin_32f = &__volk_32f_asin_32f_d;
}

static inline void __volk_32f_asin_32f_a(float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_asin_32f();
    volk_32f_asin_32f_a(bVector, aVector, num_points);
}

static inline void __volk_32f_asin_32f_u(float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_asin_32f();
    volk_32f_asin_32f_u(bVector, aVector, num_points);
}

static inline void __volk_32f_asin_32f(float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_asin_32f();
    volk_32f_asin_32f(bVector, aVector, num_points);
}

p_32f_asin_32f volk_32f_asin_32f_a = &__volk_32f_asin_32f_a;
p_32f_asin_32f volk_32f_asin_32f_u = &__volk_32f_asin_32f_u;
p_32f_asin_32f volk_32f_asin_32f   = &__volk_32f_asin_32f;

void volk_32f_asin_32f_manual(float*  bVector, const float*  aVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_asin_32f_impl_names,
        get_machine()->volk_32f_asin_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_asin_32f_impls[index](
        bVector, aVector, num_points
    );
}

volk_func_desc_t volk_32f_asin_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_asin_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_asin_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_asin_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_asin_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_atan_32f_d(float*  out, const float*  in, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(out,
        VOLK_OR_PTR(in,
        0))
    )){
        volk_32f_atan_32f_a(out, in, num_points);
    }
    else{
        volk_32f_atan_32f_u(out, in, num_points);
    }
}

static inline void __init_volk_32f_atan_32f(void)
{
    const char *name = get_machine()->volk_32f_atan_32f_name;
    const char **impl_names = get_machine()->volk_32f_atan_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_atan_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_atan_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_atan_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_atan_32f_a = get_machine()->volk_32f_atan_32f_impls[index_a];
    volk_32f_atan_32f_u = get_machine()->volk_32f_atan_32f_impls[index_u];

    assert(volk_32f_atan_32f_a);
    assert(volk_32f_atan_32f_u);

    volk_32f_atan_32f = &__volk_32f_atan_32f_d;
}

static inline void __volk_32f_atan_32f_a(float*  out, const float*  in, unsigned int  num_points)
{
    __init_volk_32f_atan_32f();
    volk_32f_atan_32f_a(out, in, num_points);
}

static inline void __volk_32f_atan_32f_u(float*  out, const float*  in, unsigned int  num_points)
{
    __init_volk_32f_atan_32f();
    volk_32f_atan_32f_u(out, in, num_points);
}

static inline void __volk_32f_atan_32f(float*  out, const float*  in, unsigned int  num_points)
{
    __init_volk_32f_atan_32f();
    volk_32f_atan_32f(out, in, num_points);
}

p_32f_atan_32f volk_32f_atan_32f_a = &__volk_32f_atan_32f_a;
p_32f_atan_32f volk_32f_atan_32f_u = &__volk_32f_atan_32f_u;
p_32f_atan_32f volk_32f_atan_32f   = &__volk_32f_atan_32f;

void volk_32f_atan_32f_manual(float*  out, const float*  in, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_atan_32f_impl_names,
        get_machine()->volk_32f_atan_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_atan_32f_impls[index](
        out, in, num_points
    );
}

volk_func_desc_t volk_32f_atan_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_atan_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_atan_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_atan_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_atan_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_binary_slicer_32i_d(int*  cVector, const float*  aVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        0))
    )){
        volk_32f_binary_slicer_32i_a(cVector, aVector, num_points);
    }
    else{
        volk_32f_binary_slicer_32i_u(cVector, aVector, num_points);
    }
}

static inline void __init_volk_32f_binary_slicer_32i(void)
{
    const char *name = get_machine()->volk_32f_binary_slicer_32i_name;
    const char **impl_names = get_machine()->volk_32f_binary_slicer_32i_impl_names;
    const int *impl_deps = get_machine()->volk_32f_binary_slicer_32i_impl_deps;
    const bool *alignment = get_machine()->volk_32f_binary_slicer_32i_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_binary_slicer_32i_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_binary_slicer_32i_a = get_machine()->volk_32f_binary_slicer_32i_impls[index_a];
    volk_32f_binary_slicer_32i_u = get_machine()->volk_32f_binary_slicer_32i_impls[index_u];

    assert(volk_32f_binary_slicer_32i_a);
    assert(volk_32f_binary_slicer_32i_u);

    volk_32f_binary_slicer_32i = &__volk_32f_binary_slicer_32i_d;
}

static inline void __volk_32f_binary_slicer_32i_a(int*  cVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_binary_slicer_32i();
    volk_32f_binary_slicer_32i_a(cVector, aVector, num_points);
}

static inline void __volk_32f_binary_slicer_32i_u(int*  cVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_binary_slicer_32i();
    volk_32f_binary_slicer_32i_u(cVector, aVector, num_points);
}

static inline void __volk_32f_binary_slicer_32i(int*  cVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_binary_slicer_32i();
    volk_32f_binary_slicer_32i(cVector, aVector, num_points);
}

p_32f_binary_slicer_32i volk_32f_binary_slicer_32i_a = &__volk_32f_binary_slicer_32i_a;
p_32f_binary_slicer_32i volk_32f_binary_slicer_32i_u = &__volk_32f_binary_slicer_32i_u;
p_32f_binary_slicer_32i volk_32f_binary_slicer_32i   = &__volk_32f_binary_slicer_32i;

void volk_32f_binary_slicer_32i_manual(int*  cVector, const float*  aVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_binary_slicer_32i_impl_names,
        get_machine()->volk_32f_binary_slicer_32i_n_impls,
        impl_name
    );
    get_machine()->volk_32f_binary_slicer_32i_impls[index](
        cVector, aVector, num_points
    );
}

volk_func_desc_t volk_32f_binary_slicer_32i_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_binary_slicer_32i_impl_names;
    const int *impl_deps = get_machine()->volk_32f_binary_slicer_32i_impl_deps;
    const bool *alignment = get_machine()->volk_32f_binary_slicer_32i_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_binary_slicer_32i_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_binary_slicer_8i_d(int8_t*  cVector, const float*  aVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        0))
    )){
        volk_32f_binary_slicer_8i_a(cVector, aVector, num_points);
    }
    else{
        volk_32f_binary_slicer_8i_u(cVector, aVector, num_points);
    }
}

static inline void __init_volk_32f_binary_slicer_8i(void)
{
    const char *name = get_machine()->volk_32f_binary_slicer_8i_name;
    const char **impl_names = get_machine()->volk_32f_binary_slicer_8i_impl_names;
    const int *impl_deps = get_machine()->volk_32f_binary_slicer_8i_impl_deps;
    const bool *alignment = get_machine()->volk_32f_binary_slicer_8i_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_binary_slicer_8i_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_binary_slicer_8i_a = get_machine()->volk_32f_binary_slicer_8i_impls[index_a];
    volk_32f_binary_slicer_8i_u = get_machine()->volk_32f_binary_slicer_8i_impls[index_u];

    assert(volk_32f_binary_slicer_8i_a);
    assert(volk_32f_binary_slicer_8i_u);

    volk_32f_binary_slicer_8i = &__volk_32f_binary_slicer_8i_d;
}

static inline void __volk_32f_binary_slicer_8i_a(int8_t*  cVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_binary_slicer_8i();
    volk_32f_binary_slicer_8i_a(cVector, aVector, num_points);
}

static inline void __volk_32f_binary_slicer_8i_u(int8_t*  cVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_binary_slicer_8i();
    volk_32f_binary_slicer_8i_u(cVector, aVector, num_points);
}

static inline void __volk_32f_binary_slicer_8i(int8_t*  cVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_binary_slicer_8i();
    volk_32f_binary_slicer_8i(cVector, aVector, num_points);
}

p_32f_binary_slicer_8i volk_32f_binary_slicer_8i_a = &__volk_32f_binary_slicer_8i_a;
p_32f_binary_slicer_8i volk_32f_binary_slicer_8i_u = &__volk_32f_binary_slicer_8i_u;
p_32f_binary_slicer_8i volk_32f_binary_slicer_8i   = &__volk_32f_binary_slicer_8i;

void volk_32f_binary_slicer_8i_manual(int8_t*  cVector, const float*  aVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_binary_slicer_8i_impl_names,
        get_machine()->volk_32f_binary_slicer_8i_n_impls,
        impl_name
    );
    get_machine()->volk_32f_binary_slicer_8i_impls[index](
        cVector, aVector, num_points
    );
}

volk_func_desc_t volk_32f_binary_slicer_8i_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_binary_slicer_8i_impl_names;
    const int *impl_deps = get_machine()->volk_32f_binary_slicer_8i_impl_deps;
    const bool *alignment = get_machine()->volk_32f_binary_slicer_8i_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_binary_slicer_8i_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_convert_64f_d(double*  outputVector, const float*  inputVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outputVector,
        VOLK_OR_PTR(inputVector,
        0))
    )){
        volk_32f_convert_64f_a(outputVector, inputVector, num_points);
    }
    else{
        volk_32f_convert_64f_u(outputVector, inputVector, num_points);
    }
}

static inline void __init_volk_32f_convert_64f(void)
{
    const char *name = get_machine()->volk_32f_convert_64f_name;
    const char **impl_names = get_machine()->volk_32f_convert_64f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_convert_64f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_convert_64f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_convert_64f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_convert_64f_a = get_machine()->volk_32f_convert_64f_impls[index_a];
    volk_32f_convert_64f_u = get_machine()->volk_32f_convert_64f_impls[index_u];

    assert(volk_32f_convert_64f_a);
    assert(volk_32f_convert_64f_u);

    volk_32f_convert_64f = &__volk_32f_convert_64f_d;
}

static inline void __volk_32f_convert_64f_a(double*  outputVector, const float*  inputVector, unsigned int  num_points)
{
    __init_volk_32f_convert_64f();
    volk_32f_convert_64f_a(outputVector, inputVector, num_points);
}

static inline void __volk_32f_convert_64f_u(double*  outputVector, const float*  inputVector, unsigned int  num_points)
{
    __init_volk_32f_convert_64f();
    volk_32f_convert_64f_u(outputVector, inputVector, num_points);
}

static inline void __volk_32f_convert_64f(double*  outputVector, const float*  inputVector, unsigned int  num_points)
{
    __init_volk_32f_convert_64f();
    volk_32f_convert_64f(outputVector, inputVector, num_points);
}

p_32f_convert_64f volk_32f_convert_64f_a = &__volk_32f_convert_64f_a;
p_32f_convert_64f volk_32f_convert_64f_u = &__volk_32f_convert_64f_u;
p_32f_convert_64f volk_32f_convert_64f   = &__volk_32f_convert_64f;

void volk_32f_convert_64f_manual(double*  outputVector, const float*  inputVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_convert_64f_impl_names,
        get_machine()->volk_32f_convert_64f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_convert_64f_impls[index](
        outputVector, inputVector, num_points
    );
}

volk_func_desc_t volk_32f_convert_64f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_convert_64f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_convert_64f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_convert_64f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_convert_64f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_cos_32f_d(float*  cosVector, const float*  inVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cosVector,
        VOLK_OR_PTR(inVector,
        0))
    )){
        volk_32f_cos_32f_a(cosVector, inVector, num_points);
    }
    else{
        volk_32f_cos_32f_u(cosVector, inVector, num_points);
    }
}

static inline void __init_volk_32f_cos_32f(void)
{
    const char *name = get_machine()->volk_32f_cos_32f_name;
    const char **impl_names = get_machine()->volk_32f_cos_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_cos_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_cos_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_cos_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_cos_32f_a = get_machine()->volk_32f_cos_32f_impls[index_a];
    volk_32f_cos_32f_u = get_machine()->volk_32f_cos_32f_impls[index_u];

    assert(volk_32f_cos_32f_a);
    assert(volk_32f_cos_32f_u);

    volk_32f_cos_32f = &__volk_32f_cos_32f_d;
}

static inline void __volk_32f_cos_32f_a(float*  cosVector, const float*  inVector, unsigned int  num_points)
{
    __init_volk_32f_cos_32f();
    volk_32f_cos_32f_a(cosVector, inVector, num_points);
}

static inline void __volk_32f_cos_32f_u(float*  cosVector, const float*  inVector, unsigned int  num_points)
{
    __init_volk_32f_cos_32f();
    volk_32f_cos_32f_u(cosVector, inVector, num_points);
}

static inline void __volk_32f_cos_32f(float*  cosVector, const float*  inVector, unsigned int  num_points)
{
    __init_volk_32f_cos_32f();
    volk_32f_cos_32f(cosVector, inVector, num_points);
}

p_32f_cos_32f volk_32f_cos_32f_a = &__volk_32f_cos_32f_a;
p_32f_cos_32f volk_32f_cos_32f_u = &__volk_32f_cos_32f_u;
p_32f_cos_32f volk_32f_cos_32f   = &__volk_32f_cos_32f;

void volk_32f_cos_32f_manual(float*  cosVector, const float*  inVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_cos_32f_impl_names,
        get_machine()->volk_32f_cos_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_cos_32f_impls[index](
        cosVector, inVector, num_points
    );
}

volk_func_desc_t volk_32f_cos_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_cos_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_cos_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_cos_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_cos_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_exp_32f_d(float*  bVector, const float*  aVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(bVector,
        VOLK_OR_PTR(aVector,
        0))
    )){
        volk_32f_exp_32f_a(bVector, aVector, num_points);
    }
    else{
        volk_32f_exp_32f_u(bVector, aVector, num_points);
    }
}

static inline void __init_volk_32f_exp_32f(void)
{
    const char *name = get_machine()->volk_32f_exp_32f_name;
    const char **impl_names = get_machine()->volk_32f_exp_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_exp_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_exp_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_exp_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_exp_32f_a = get_machine()->volk_32f_exp_32f_impls[index_a];
    volk_32f_exp_32f_u = get_machine()->volk_32f_exp_32f_impls[index_u];

    assert(volk_32f_exp_32f_a);
    assert(volk_32f_exp_32f_u);

    volk_32f_exp_32f = &__volk_32f_exp_32f_d;
}

static inline void __volk_32f_exp_32f_a(float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_exp_32f();
    volk_32f_exp_32f_a(bVector, aVector, num_points);
}

static inline void __volk_32f_exp_32f_u(float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_exp_32f();
    volk_32f_exp_32f_u(bVector, aVector, num_points);
}

static inline void __volk_32f_exp_32f(float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_exp_32f();
    volk_32f_exp_32f(bVector, aVector, num_points);
}

p_32f_exp_32f volk_32f_exp_32f_a = &__volk_32f_exp_32f_a;
p_32f_exp_32f volk_32f_exp_32f_u = &__volk_32f_exp_32f_u;
p_32f_exp_32f volk_32f_exp_32f   = &__volk_32f_exp_32f;

void volk_32f_exp_32f_manual(float*  bVector, const float*  aVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_exp_32f_impl_names,
        get_machine()->volk_32f_exp_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_exp_32f_impls[index](
        bVector, aVector, num_points
    );
}

volk_func_desc_t volk_32f_exp_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_exp_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_exp_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_exp_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_exp_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_expfast_32f_d(float*  bVector, const float*  aVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(bVector,
        VOLK_OR_PTR(aVector,
        0))
    )){
        volk_32f_expfast_32f_a(bVector, aVector, num_points);
    }
    else{
        volk_32f_expfast_32f_u(bVector, aVector, num_points);
    }
}

static inline void __init_volk_32f_expfast_32f(void)
{
    const char *name = get_machine()->volk_32f_expfast_32f_name;
    const char **impl_names = get_machine()->volk_32f_expfast_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_expfast_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_expfast_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_expfast_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_expfast_32f_a = get_machine()->volk_32f_expfast_32f_impls[index_a];
    volk_32f_expfast_32f_u = get_machine()->volk_32f_expfast_32f_impls[index_u];

    assert(volk_32f_expfast_32f_a);
    assert(volk_32f_expfast_32f_u);

    volk_32f_expfast_32f = &__volk_32f_expfast_32f_d;
}

static inline void __volk_32f_expfast_32f_a(float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_expfast_32f();
    volk_32f_expfast_32f_a(bVector, aVector, num_points);
}

static inline void __volk_32f_expfast_32f_u(float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_expfast_32f();
    volk_32f_expfast_32f_u(bVector, aVector, num_points);
}

static inline void __volk_32f_expfast_32f(float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_expfast_32f();
    volk_32f_expfast_32f(bVector, aVector, num_points);
}

p_32f_expfast_32f volk_32f_expfast_32f_a = &__volk_32f_expfast_32f_a;
p_32f_expfast_32f volk_32f_expfast_32f_u = &__volk_32f_expfast_32f_u;
p_32f_expfast_32f volk_32f_expfast_32f   = &__volk_32f_expfast_32f;

void volk_32f_expfast_32f_manual(float*  bVector, const float*  aVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_expfast_32f_impl_names,
        get_machine()->volk_32f_expfast_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_expfast_32f_impls[index](
        bVector, aVector, num_points
    );
}

volk_func_desc_t volk_32f_expfast_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_expfast_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_expfast_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_expfast_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_expfast_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_index_max_16u_d(uint16_t*  target, const float*  src0, uint32_t  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(target,
        VOLK_OR_PTR(src0,
        0))
    )){
        volk_32f_index_max_16u_a(target, src0, num_points);
    }
    else{
        volk_32f_index_max_16u_u(target, src0, num_points);
    }
}

static inline void __init_volk_32f_index_max_16u(void)
{
    const char *name = get_machine()->volk_32f_index_max_16u_name;
    const char **impl_names = get_machine()->volk_32f_index_max_16u_impl_names;
    const int *impl_deps = get_machine()->volk_32f_index_max_16u_impl_deps;
    const bool *alignment = get_machine()->volk_32f_index_max_16u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_index_max_16u_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_index_max_16u_a = get_machine()->volk_32f_index_max_16u_impls[index_a];
    volk_32f_index_max_16u_u = get_machine()->volk_32f_index_max_16u_impls[index_u];

    assert(volk_32f_index_max_16u_a);
    assert(volk_32f_index_max_16u_u);

    volk_32f_index_max_16u = &__volk_32f_index_max_16u_d;
}

static inline void __volk_32f_index_max_16u_a(uint16_t*  target, const float*  src0, uint32_t  num_points)
{
    __init_volk_32f_index_max_16u();
    volk_32f_index_max_16u_a(target, src0, num_points);
}

static inline void __volk_32f_index_max_16u_u(uint16_t*  target, const float*  src0, uint32_t  num_points)
{
    __init_volk_32f_index_max_16u();
    volk_32f_index_max_16u_u(target, src0, num_points);
}

static inline void __volk_32f_index_max_16u(uint16_t*  target, const float*  src0, uint32_t  num_points)
{
    __init_volk_32f_index_max_16u();
    volk_32f_index_max_16u(target, src0, num_points);
}

p_32f_index_max_16u volk_32f_index_max_16u_a = &__volk_32f_index_max_16u_a;
p_32f_index_max_16u volk_32f_index_max_16u_u = &__volk_32f_index_max_16u_u;
p_32f_index_max_16u volk_32f_index_max_16u   = &__volk_32f_index_max_16u;

void volk_32f_index_max_16u_manual(uint16_t*  target, const float*  src0, uint32_t  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_index_max_16u_impl_names,
        get_machine()->volk_32f_index_max_16u_n_impls,
        impl_name
    );
    get_machine()->volk_32f_index_max_16u_impls[index](
        target, src0, num_points
    );
}

volk_func_desc_t volk_32f_index_max_16u_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_index_max_16u_impl_names;
    const int *impl_deps = get_machine()->volk_32f_index_max_16u_impl_deps;
    const bool *alignment = get_machine()->volk_32f_index_max_16u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_index_max_16u_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_index_max_32u_d(uint32_t*  target, const float*  src0, uint32_t  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(target,
        VOLK_OR_PTR(src0,
        0))
    )){
        volk_32f_index_max_32u_a(target, src0, num_points);
    }
    else{
        volk_32f_index_max_32u_u(target, src0, num_points);
    }
}

static inline void __init_volk_32f_index_max_32u(void)
{
    const char *name = get_machine()->volk_32f_index_max_32u_name;
    const char **impl_names = get_machine()->volk_32f_index_max_32u_impl_names;
    const int *impl_deps = get_machine()->volk_32f_index_max_32u_impl_deps;
    const bool *alignment = get_machine()->volk_32f_index_max_32u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_index_max_32u_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_index_max_32u_a = get_machine()->volk_32f_index_max_32u_impls[index_a];
    volk_32f_index_max_32u_u = get_machine()->volk_32f_index_max_32u_impls[index_u];

    assert(volk_32f_index_max_32u_a);
    assert(volk_32f_index_max_32u_u);

    volk_32f_index_max_32u = &__volk_32f_index_max_32u_d;
}

static inline void __volk_32f_index_max_32u_a(uint32_t*  target, const float*  src0, uint32_t  num_points)
{
    __init_volk_32f_index_max_32u();
    volk_32f_index_max_32u_a(target, src0, num_points);
}

static inline void __volk_32f_index_max_32u_u(uint32_t*  target, const float*  src0, uint32_t  num_points)
{
    __init_volk_32f_index_max_32u();
    volk_32f_index_max_32u_u(target, src0, num_points);
}

static inline void __volk_32f_index_max_32u(uint32_t*  target, const float*  src0, uint32_t  num_points)
{
    __init_volk_32f_index_max_32u();
    volk_32f_index_max_32u(target, src0, num_points);
}

p_32f_index_max_32u volk_32f_index_max_32u_a = &__volk_32f_index_max_32u_a;
p_32f_index_max_32u volk_32f_index_max_32u_u = &__volk_32f_index_max_32u_u;
p_32f_index_max_32u volk_32f_index_max_32u   = &__volk_32f_index_max_32u;

void volk_32f_index_max_32u_manual(uint32_t*  target, const float*  src0, uint32_t  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_index_max_32u_impl_names,
        get_machine()->volk_32f_index_max_32u_n_impls,
        impl_name
    );
    get_machine()->volk_32f_index_max_32u_impls[index](
        target, src0, num_points
    );
}

volk_func_desc_t volk_32f_index_max_32u_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_index_max_32u_impl_names;
    const int *impl_deps = get_machine()->volk_32f_index_max_32u_impl_deps;
    const bool *alignment = get_machine()->volk_32f_index_max_32u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_index_max_32u_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_index_min_16u_d(uint16_t*  target, const float*  source, uint32_t  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(target,
        VOLK_OR_PTR(source,
        0))
    )){
        volk_32f_index_min_16u_a(target, source, num_points);
    }
    else{
        volk_32f_index_min_16u_u(target, source, num_points);
    }
}

static inline void __init_volk_32f_index_min_16u(void)
{
    const char *name = get_machine()->volk_32f_index_min_16u_name;
    const char **impl_names = get_machine()->volk_32f_index_min_16u_impl_names;
    const int *impl_deps = get_machine()->volk_32f_index_min_16u_impl_deps;
    const bool *alignment = get_machine()->volk_32f_index_min_16u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_index_min_16u_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_index_min_16u_a = get_machine()->volk_32f_index_min_16u_impls[index_a];
    volk_32f_index_min_16u_u = get_machine()->volk_32f_index_min_16u_impls[index_u];

    assert(volk_32f_index_min_16u_a);
    assert(volk_32f_index_min_16u_u);

    volk_32f_index_min_16u = &__volk_32f_index_min_16u_d;
}

static inline void __volk_32f_index_min_16u_a(uint16_t*  target, const float*  source, uint32_t  num_points)
{
    __init_volk_32f_index_min_16u();
    volk_32f_index_min_16u_a(target, source, num_points);
}

static inline void __volk_32f_index_min_16u_u(uint16_t*  target, const float*  source, uint32_t  num_points)
{
    __init_volk_32f_index_min_16u();
    volk_32f_index_min_16u_u(target, source, num_points);
}

static inline void __volk_32f_index_min_16u(uint16_t*  target, const float*  source, uint32_t  num_points)
{
    __init_volk_32f_index_min_16u();
    volk_32f_index_min_16u(target, source, num_points);
}

p_32f_index_min_16u volk_32f_index_min_16u_a = &__volk_32f_index_min_16u_a;
p_32f_index_min_16u volk_32f_index_min_16u_u = &__volk_32f_index_min_16u_u;
p_32f_index_min_16u volk_32f_index_min_16u   = &__volk_32f_index_min_16u;

void volk_32f_index_min_16u_manual(uint16_t*  target, const float*  source, uint32_t  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_index_min_16u_impl_names,
        get_machine()->volk_32f_index_min_16u_n_impls,
        impl_name
    );
    get_machine()->volk_32f_index_min_16u_impls[index](
        target, source, num_points
    );
}

volk_func_desc_t volk_32f_index_min_16u_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_index_min_16u_impl_names;
    const int *impl_deps = get_machine()->volk_32f_index_min_16u_impl_deps;
    const bool *alignment = get_machine()->volk_32f_index_min_16u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_index_min_16u_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_index_min_32u_d(uint32_t*  target, const float*  source, uint32_t  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(target,
        VOLK_OR_PTR(source,
        0))
    )){
        volk_32f_index_min_32u_a(target, source, num_points);
    }
    else{
        volk_32f_index_min_32u_u(target, source, num_points);
    }
}

static inline void __init_volk_32f_index_min_32u(void)
{
    const char *name = get_machine()->volk_32f_index_min_32u_name;
    const char **impl_names = get_machine()->volk_32f_index_min_32u_impl_names;
    const int *impl_deps = get_machine()->volk_32f_index_min_32u_impl_deps;
    const bool *alignment = get_machine()->volk_32f_index_min_32u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_index_min_32u_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_index_min_32u_a = get_machine()->volk_32f_index_min_32u_impls[index_a];
    volk_32f_index_min_32u_u = get_machine()->volk_32f_index_min_32u_impls[index_u];

    assert(volk_32f_index_min_32u_a);
    assert(volk_32f_index_min_32u_u);

    volk_32f_index_min_32u = &__volk_32f_index_min_32u_d;
}

static inline void __volk_32f_index_min_32u_a(uint32_t*  target, const float*  source, uint32_t  num_points)
{
    __init_volk_32f_index_min_32u();
    volk_32f_index_min_32u_a(target, source, num_points);
}

static inline void __volk_32f_index_min_32u_u(uint32_t*  target, const float*  source, uint32_t  num_points)
{
    __init_volk_32f_index_min_32u();
    volk_32f_index_min_32u_u(target, source, num_points);
}

static inline void __volk_32f_index_min_32u(uint32_t*  target, const float*  source, uint32_t  num_points)
{
    __init_volk_32f_index_min_32u();
    volk_32f_index_min_32u(target, source, num_points);
}

p_32f_index_min_32u volk_32f_index_min_32u_a = &__volk_32f_index_min_32u_a;
p_32f_index_min_32u volk_32f_index_min_32u_u = &__volk_32f_index_min_32u_u;
p_32f_index_min_32u volk_32f_index_min_32u   = &__volk_32f_index_min_32u;

void volk_32f_index_min_32u_manual(uint32_t*  target, const float*  source, uint32_t  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_index_min_32u_impl_names,
        get_machine()->volk_32f_index_min_32u_n_impls,
        impl_name
    );
    get_machine()->volk_32f_index_min_32u_impls[index](
        target, source, num_points
    );
}

volk_func_desc_t volk_32f_index_min_32u_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_index_min_32u_impl_names;
    const int *impl_deps = get_machine()->volk_32f_index_min_32u_impl_deps;
    const bool *alignment = get_machine()->volk_32f_index_min_32u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_index_min_32u_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_invsqrt_32f_d(float*  cVector, const float*  aVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        0))
    )){
        volk_32f_invsqrt_32f_a(cVector, aVector, num_points);
    }
    else{
        volk_32f_invsqrt_32f_u(cVector, aVector, num_points);
    }
}

static inline void __init_volk_32f_invsqrt_32f(void)
{
    const char *name = get_machine()->volk_32f_invsqrt_32f_name;
    const char **impl_names = get_machine()->volk_32f_invsqrt_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_invsqrt_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_invsqrt_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_invsqrt_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_invsqrt_32f_a = get_machine()->volk_32f_invsqrt_32f_impls[index_a];
    volk_32f_invsqrt_32f_u = get_machine()->volk_32f_invsqrt_32f_impls[index_u];

    assert(volk_32f_invsqrt_32f_a);
    assert(volk_32f_invsqrt_32f_u);

    volk_32f_invsqrt_32f = &__volk_32f_invsqrt_32f_d;
}

static inline void __volk_32f_invsqrt_32f_a(float*  cVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_invsqrt_32f();
    volk_32f_invsqrt_32f_a(cVector, aVector, num_points);
}

static inline void __volk_32f_invsqrt_32f_u(float*  cVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_invsqrt_32f();
    volk_32f_invsqrt_32f_u(cVector, aVector, num_points);
}

static inline void __volk_32f_invsqrt_32f(float*  cVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_invsqrt_32f();
    volk_32f_invsqrt_32f(cVector, aVector, num_points);
}

p_32f_invsqrt_32f volk_32f_invsqrt_32f_a = &__volk_32f_invsqrt_32f_a;
p_32f_invsqrt_32f volk_32f_invsqrt_32f_u = &__volk_32f_invsqrt_32f_u;
p_32f_invsqrt_32f volk_32f_invsqrt_32f   = &__volk_32f_invsqrt_32f;

void volk_32f_invsqrt_32f_manual(float*  cVector, const float*  aVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_invsqrt_32f_impl_names,
        get_machine()->volk_32f_invsqrt_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_invsqrt_32f_impls[index](
        cVector, aVector, num_points
    );
}

volk_func_desc_t volk_32f_invsqrt_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_invsqrt_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_invsqrt_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_invsqrt_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_invsqrt_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_log2_32f_d(float*  bVector, const float*  aVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(bVector,
        VOLK_OR_PTR(aVector,
        0))
    )){
        volk_32f_log2_32f_a(bVector, aVector, num_points);
    }
    else{
        volk_32f_log2_32f_u(bVector, aVector, num_points);
    }
}

static inline void __init_volk_32f_log2_32f(void)
{
    const char *name = get_machine()->volk_32f_log2_32f_name;
    const char **impl_names = get_machine()->volk_32f_log2_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_log2_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_log2_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_log2_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_log2_32f_a = get_machine()->volk_32f_log2_32f_impls[index_a];
    volk_32f_log2_32f_u = get_machine()->volk_32f_log2_32f_impls[index_u];

    assert(volk_32f_log2_32f_a);
    assert(volk_32f_log2_32f_u);

    volk_32f_log2_32f = &__volk_32f_log2_32f_d;
}

static inline void __volk_32f_log2_32f_a(float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_log2_32f();
    volk_32f_log2_32f_a(bVector, aVector, num_points);
}

static inline void __volk_32f_log2_32f_u(float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_log2_32f();
    volk_32f_log2_32f_u(bVector, aVector, num_points);
}

static inline void __volk_32f_log2_32f(float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_log2_32f();
    volk_32f_log2_32f(bVector, aVector, num_points);
}

p_32f_log2_32f volk_32f_log2_32f_a = &__volk_32f_log2_32f_a;
p_32f_log2_32f volk_32f_log2_32f_u = &__volk_32f_log2_32f_u;
p_32f_log2_32f volk_32f_log2_32f   = &__volk_32f_log2_32f;

void volk_32f_log2_32f_manual(float*  bVector, const float*  aVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_log2_32f_impl_names,
        get_machine()->volk_32f_log2_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_log2_32f_impls[index](
        bVector, aVector, num_points
    );
}

volk_func_desc_t volk_32f_log2_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_log2_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_log2_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_log2_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_log2_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_null_32f_d(float*  bVector, const float*  aVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(bVector,
        VOLK_OR_PTR(aVector,
        0))
    )){
        volk_32f_null_32f_a(bVector, aVector, num_points);
    }
    else{
        volk_32f_null_32f_u(bVector, aVector, num_points);
    }
}

static inline void __init_volk_32f_null_32f(void)
{
    const char *name = get_machine()->volk_32f_null_32f_name;
    const char **impl_names = get_machine()->volk_32f_null_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_null_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_null_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_null_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_null_32f_a = get_machine()->volk_32f_null_32f_impls[index_a];
    volk_32f_null_32f_u = get_machine()->volk_32f_null_32f_impls[index_u];

    assert(volk_32f_null_32f_a);
    assert(volk_32f_null_32f_u);

    volk_32f_null_32f = &__volk_32f_null_32f_d;
}

static inline void __volk_32f_null_32f_a(float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_null_32f();
    volk_32f_null_32f_a(bVector, aVector, num_points);
}

static inline void __volk_32f_null_32f_u(float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_null_32f();
    volk_32f_null_32f_u(bVector, aVector, num_points);
}

static inline void __volk_32f_null_32f(float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_null_32f();
    volk_32f_null_32f(bVector, aVector, num_points);
}

p_32f_null_32f volk_32f_null_32f_a = &__volk_32f_null_32f_a;
p_32f_null_32f volk_32f_null_32f_u = &__volk_32f_null_32f_u;
p_32f_null_32f volk_32f_null_32f   = &__volk_32f_null_32f;

void volk_32f_null_32f_manual(float*  bVector, const float*  aVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_null_32f_impl_names,
        get_machine()->volk_32f_null_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_null_32f_impls[index](
        bVector, aVector, num_points
    );
}

volk_func_desc_t volk_32f_null_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_null_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_null_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_null_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_null_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_s32f_32f_fm_detect_32f_d(float*  outputVector, const float*  inputVector, const float  bound, float*  saveValue, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outputVector,
        VOLK_OR_PTR(inputVector,
        VOLK_OR_PTR(saveValue,
        0)))
    )){
        volk_32f_s32f_32f_fm_detect_32f_a(outputVector, inputVector, bound, saveValue, num_points);
    }
    else{
        volk_32f_s32f_32f_fm_detect_32f_u(outputVector, inputVector, bound, saveValue, num_points);
    }
}

static inline void __init_volk_32f_s32f_32f_fm_detect_32f(void)
{
    const char *name = get_machine()->volk_32f_s32f_32f_fm_detect_32f_name;
    const char **impl_names = get_machine()->volk_32f_s32f_32f_fm_detect_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_32f_fm_detect_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_32f_fm_detect_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_32f_fm_detect_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_s32f_32f_fm_detect_32f_a = get_machine()->volk_32f_s32f_32f_fm_detect_32f_impls[index_a];
    volk_32f_s32f_32f_fm_detect_32f_u = get_machine()->volk_32f_s32f_32f_fm_detect_32f_impls[index_u];

    assert(volk_32f_s32f_32f_fm_detect_32f_a);
    assert(volk_32f_s32f_32f_fm_detect_32f_u);

    volk_32f_s32f_32f_fm_detect_32f = &__volk_32f_s32f_32f_fm_detect_32f_d;
}

static inline void __volk_32f_s32f_32f_fm_detect_32f_a(float*  outputVector, const float*  inputVector, const float  bound, float*  saveValue, unsigned int  num_points)
{
    __init_volk_32f_s32f_32f_fm_detect_32f();
    volk_32f_s32f_32f_fm_detect_32f_a(outputVector, inputVector, bound, saveValue, num_points);
}

static inline void __volk_32f_s32f_32f_fm_detect_32f_u(float*  outputVector, const float*  inputVector, const float  bound, float*  saveValue, unsigned int  num_points)
{
    __init_volk_32f_s32f_32f_fm_detect_32f();
    volk_32f_s32f_32f_fm_detect_32f_u(outputVector, inputVector, bound, saveValue, num_points);
}

static inline void __volk_32f_s32f_32f_fm_detect_32f(float*  outputVector, const float*  inputVector, const float  bound, float*  saveValue, unsigned int  num_points)
{
    __init_volk_32f_s32f_32f_fm_detect_32f();
    volk_32f_s32f_32f_fm_detect_32f(outputVector, inputVector, bound, saveValue, num_points);
}

p_32f_s32f_32f_fm_detect_32f volk_32f_s32f_32f_fm_detect_32f_a = &__volk_32f_s32f_32f_fm_detect_32f_a;
p_32f_s32f_32f_fm_detect_32f volk_32f_s32f_32f_fm_detect_32f_u = &__volk_32f_s32f_32f_fm_detect_32f_u;
p_32f_s32f_32f_fm_detect_32f volk_32f_s32f_32f_fm_detect_32f   = &__volk_32f_s32f_32f_fm_detect_32f;

void volk_32f_s32f_32f_fm_detect_32f_manual(float*  outputVector, const float*  inputVector, const float  bound, float*  saveValue, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_s32f_32f_fm_detect_32f_impl_names,
        get_machine()->volk_32f_s32f_32f_fm_detect_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_s32f_32f_fm_detect_32f_impls[index](
        outputVector, inputVector, bound, saveValue, num_points
    );
}

volk_func_desc_t volk_32f_s32f_32f_fm_detect_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_s32f_32f_fm_detect_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_32f_fm_detect_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_32f_fm_detect_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_32f_fm_detect_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_s32f_add_32f_d(float*  cVector, const float*  aVector, const float  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        0))
    )){
        volk_32f_s32f_add_32f_a(cVector, aVector, scalar, num_points);
    }
    else{
        volk_32f_s32f_add_32f_u(cVector, aVector, scalar, num_points);
    }
}

static inline void __init_volk_32f_s32f_add_32f(void)
{
    const char *name = get_machine()->volk_32f_s32f_add_32f_name;
    const char **impl_names = get_machine()->volk_32f_s32f_add_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_add_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_add_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_add_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_s32f_add_32f_a = get_machine()->volk_32f_s32f_add_32f_impls[index_a];
    volk_32f_s32f_add_32f_u = get_machine()->volk_32f_s32f_add_32f_impls[index_u];

    assert(volk_32f_s32f_add_32f_a);
    assert(volk_32f_s32f_add_32f_u);

    volk_32f_s32f_add_32f = &__volk_32f_s32f_add_32f_d;
}

static inline void __volk_32f_s32f_add_32f_a(float*  cVector, const float*  aVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32f_s32f_add_32f();
    volk_32f_s32f_add_32f_a(cVector, aVector, scalar, num_points);
}

static inline void __volk_32f_s32f_add_32f_u(float*  cVector, const float*  aVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32f_s32f_add_32f();
    volk_32f_s32f_add_32f_u(cVector, aVector, scalar, num_points);
}

static inline void __volk_32f_s32f_add_32f(float*  cVector, const float*  aVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32f_s32f_add_32f();
    volk_32f_s32f_add_32f(cVector, aVector, scalar, num_points);
}

p_32f_s32f_add_32f volk_32f_s32f_add_32f_a = &__volk_32f_s32f_add_32f_a;
p_32f_s32f_add_32f volk_32f_s32f_add_32f_u = &__volk_32f_s32f_add_32f_u;
p_32f_s32f_add_32f volk_32f_s32f_add_32f   = &__volk_32f_s32f_add_32f;

void volk_32f_s32f_add_32f_manual(float*  cVector, const float*  aVector, const float  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_s32f_add_32f_impl_names,
        get_machine()->volk_32f_s32f_add_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_s32f_add_32f_impls[index](
        cVector, aVector, scalar, num_points
    );
}

volk_func_desc_t volk_32f_s32f_add_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_s32f_add_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_add_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_add_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_add_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_s32f_calc_spectral_noise_floor_32f_d(float*  noiseFloorAmplitude, const float*  realDataPoints, const float  spectralExclusionValue, const unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(noiseFloorAmplitude,
        VOLK_OR_PTR(realDataPoints,
        0))
    )){
        volk_32f_s32f_calc_spectral_noise_floor_32f_a(noiseFloorAmplitude, realDataPoints, spectralExclusionValue, num_points);
    }
    else{
        volk_32f_s32f_calc_spectral_noise_floor_32f_u(noiseFloorAmplitude, realDataPoints, spectralExclusionValue, num_points);
    }
}

static inline void __init_volk_32f_s32f_calc_spectral_noise_floor_32f(void)
{
    const char *name = get_machine()->volk_32f_s32f_calc_spectral_noise_floor_32f_name;
    const char **impl_names = get_machine()->volk_32f_s32f_calc_spectral_noise_floor_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_calc_spectral_noise_floor_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_calc_spectral_noise_floor_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_calc_spectral_noise_floor_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_s32f_calc_spectral_noise_floor_32f_a = get_machine()->volk_32f_s32f_calc_spectral_noise_floor_32f_impls[index_a];
    volk_32f_s32f_calc_spectral_noise_floor_32f_u = get_machine()->volk_32f_s32f_calc_spectral_noise_floor_32f_impls[index_u];

    assert(volk_32f_s32f_calc_spectral_noise_floor_32f_a);
    assert(volk_32f_s32f_calc_spectral_noise_floor_32f_u);

    volk_32f_s32f_calc_spectral_noise_floor_32f = &__volk_32f_s32f_calc_spectral_noise_floor_32f_d;
}

static inline void __volk_32f_s32f_calc_spectral_noise_floor_32f_a(float*  noiseFloorAmplitude, const float*  realDataPoints, const float  spectralExclusionValue, const unsigned int  num_points)
{
    __init_volk_32f_s32f_calc_spectral_noise_floor_32f();
    volk_32f_s32f_calc_spectral_noise_floor_32f_a(noiseFloorAmplitude, realDataPoints, spectralExclusionValue, num_points);
}

static inline void __volk_32f_s32f_calc_spectral_noise_floor_32f_u(float*  noiseFloorAmplitude, const float*  realDataPoints, const float  spectralExclusionValue, const unsigned int  num_points)
{
    __init_volk_32f_s32f_calc_spectral_noise_floor_32f();
    volk_32f_s32f_calc_spectral_noise_floor_32f_u(noiseFloorAmplitude, realDataPoints, spectralExclusionValue, num_points);
}

static inline void __volk_32f_s32f_calc_spectral_noise_floor_32f(float*  noiseFloorAmplitude, const float*  realDataPoints, const float  spectralExclusionValue, const unsigned int  num_points)
{
    __init_volk_32f_s32f_calc_spectral_noise_floor_32f();
    volk_32f_s32f_calc_spectral_noise_floor_32f(noiseFloorAmplitude, realDataPoints, spectralExclusionValue, num_points);
}

p_32f_s32f_calc_spectral_noise_floor_32f volk_32f_s32f_calc_spectral_noise_floor_32f_a = &__volk_32f_s32f_calc_spectral_noise_floor_32f_a;
p_32f_s32f_calc_spectral_noise_floor_32f volk_32f_s32f_calc_spectral_noise_floor_32f_u = &__volk_32f_s32f_calc_spectral_noise_floor_32f_u;
p_32f_s32f_calc_spectral_noise_floor_32f volk_32f_s32f_calc_spectral_noise_floor_32f   = &__volk_32f_s32f_calc_spectral_noise_floor_32f;

void volk_32f_s32f_calc_spectral_noise_floor_32f_manual(float*  noiseFloorAmplitude, const float*  realDataPoints, const float  spectralExclusionValue, const unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_s32f_calc_spectral_noise_floor_32f_impl_names,
        get_machine()->volk_32f_s32f_calc_spectral_noise_floor_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_s32f_calc_spectral_noise_floor_32f_impls[index](
        noiseFloorAmplitude, realDataPoints, spectralExclusionValue, num_points
    );
}

volk_func_desc_t volk_32f_s32f_calc_spectral_noise_floor_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_s32f_calc_spectral_noise_floor_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_calc_spectral_noise_floor_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_calc_spectral_noise_floor_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_calc_spectral_noise_floor_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_s32f_clamppuppet_32f_d(float*  out, const float*  in, const float  min, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(out,
        VOLK_OR_PTR(in,
        0))
    )){
        volk_32f_s32f_clamppuppet_32f_a(out, in, min, num_points);
    }
    else{
        volk_32f_s32f_clamppuppet_32f_u(out, in, min, num_points);
    }
}

static inline void __init_volk_32f_s32f_clamppuppet_32f(void)
{
    const char *name = get_machine()->volk_32f_s32f_clamppuppet_32f_name;
    const char **impl_names = get_machine()->volk_32f_s32f_clamppuppet_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_clamppuppet_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_clamppuppet_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_clamppuppet_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_s32f_clamppuppet_32f_a = get_machine()->volk_32f_s32f_clamppuppet_32f_impls[index_a];
    volk_32f_s32f_clamppuppet_32f_u = get_machine()->volk_32f_s32f_clamppuppet_32f_impls[index_u];

    assert(volk_32f_s32f_clamppuppet_32f_a);
    assert(volk_32f_s32f_clamppuppet_32f_u);

    volk_32f_s32f_clamppuppet_32f = &__volk_32f_s32f_clamppuppet_32f_d;
}

static inline void __volk_32f_s32f_clamppuppet_32f_a(float*  out, const float*  in, const float  min, unsigned int  num_points)
{
    __init_volk_32f_s32f_clamppuppet_32f();
    volk_32f_s32f_clamppuppet_32f_a(out, in, min, num_points);
}

static inline void __volk_32f_s32f_clamppuppet_32f_u(float*  out, const float*  in, const float  min, unsigned int  num_points)
{
    __init_volk_32f_s32f_clamppuppet_32f();
    volk_32f_s32f_clamppuppet_32f_u(out, in, min, num_points);
}

static inline void __volk_32f_s32f_clamppuppet_32f(float*  out, const float*  in, const float  min, unsigned int  num_points)
{
    __init_volk_32f_s32f_clamppuppet_32f();
    volk_32f_s32f_clamppuppet_32f(out, in, min, num_points);
}

p_32f_s32f_clamppuppet_32f volk_32f_s32f_clamppuppet_32f_a = &__volk_32f_s32f_clamppuppet_32f_a;
p_32f_s32f_clamppuppet_32f volk_32f_s32f_clamppuppet_32f_u = &__volk_32f_s32f_clamppuppet_32f_u;
p_32f_s32f_clamppuppet_32f volk_32f_s32f_clamppuppet_32f   = &__volk_32f_s32f_clamppuppet_32f;

void volk_32f_s32f_clamppuppet_32f_manual(float*  out, const float*  in, const float  min, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_s32f_clamppuppet_32f_impl_names,
        get_machine()->volk_32f_s32f_clamppuppet_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_s32f_clamppuppet_32f_impls[index](
        out, in, min, num_points
    );
}

volk_func_desc_t volk_32f_s32f_clamppuppet_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_s32f_clamppuppet_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_clamppuppet_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_clamppuppet_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_clamppuppet_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_s32f_convert_16i_d(int16_t*  outputVector, const float*  inputVector, const float  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outputVector,
        VOLK_OR_PTR(inputVector,
        0))
    )){
        volk_32f_s32f_convert_16i_a(outputVector, inputVector, scalar, num_points);
    }
    else{
        volk_32f_s32f_convert_16i_u(outputVector, inputVector, scalar, num_points);
    }
}

static inline void __init_volk_32f_s32f_convert_16i(void)
{
    const char *name = get_machine()->volk_32f_s32f_convert_16i_name;
    const char **impl_names = get_machine()->volk_32f_s32f_convert_16i_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_convert_16i_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_convert_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_convert_16i_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_s32f_convert_16i_a = get_machine()->volk_32f_s32f_convert_16i_impls[index_a];
    volk_32f_s32f_convert_16i_u = get_machine()->volk_32f_s32f_convert_16i_impls[index_u];

    assert(volk_32f_s32f_convert_16i_a);
    assert(volk_32f_s32f_convert_16i_u);

    volk_32f_s32f_convert_16i = &__volk_32f_s32f_convert_16i_d;
}

static inline void __volk_32f_s32f_convert_16i_a(int16_t*  outputVector, const float*  inputVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32f_s32f_convert_16i();
    volk_32f_s32f_convert_16i_a(outputVector, inputVector, scalar, num_points);
}

static inline void __volk_32f_s32f_convert_16i_u(int16_t*  outputVector, const float*  inputVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32f_s32f_convert_16i();
    volk_32f_s32f_convert_16i_u(outputVector, inputVector, scalar, num_points);
}

static inline void __volk_32f_s32f_convert_16i(int16_t*  outputVector, const float*  inputVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32f_s32f_convert_16i();
    volk_32f_s32f_convert_16i(outputVector, inputVector, scalar, num_points);
}

p_32f_s32f_convert_16i volk_32f_s32f_convert_16i_a = &__volk_32f_s32f_convert_16i_a;
p_32f_s32f_convert_16i volk_32f_s32f_convert_16i_u = &__volk_32f_s32f_convert_16i_u;
p_32f_s32f_convert_16i volk_32f_s32f_convert_16i   = &__volk_32f_s32f_convert_16i;

void volk_32f_s32f_convert_16i_manual(int16_t*  outputVector, const float*  inputVector, const float  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_s32f_convert_16i_impl_names,
        get_machine()->volk_32f_s32f_convert_16i_n_impls,
        impl_name
    );
    get_machine()->volk_32f_s32f_convert_16i_impls[index](
        outputVector, inputVector, scalar, num_points
    );
}

volk_func_desc_t volk_32f_s32f_convert_16i_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_s32f_convert_16i_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_convert_16i_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_convert_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_convert_16i_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_s32f_convert_32i_d(int32_t*  outputVector, const float*  inputVector, const float  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outputVector,
        VOLK_OR_PTR(inputVector,
        0))
    )){
        volk_32f_s32f_convert_32i_a(outputVector, inputVector, scalar, num_points);
    }
    else{
        volk_32f_s32f_convert_32i_u(outputVector, inputVector, scalar, num_points);
    }
}

static inline void __init_volk_32f_s32f_convert_32i(void)
{
    const char *name = get_machine()->volk_32f_s32f_convert_32i_name;
    const char **impl_names = get_machine()->volk_32f_s32f_convert_32i_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_convert_32i_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_convert_32i_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_convert_32i_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_s32f_convert_32i_a = get_machine()->volk_32f_s32f_convert_32i_impls[index_a];
    volk_32f_s32f_convert_32i_u = get_machine()->volk_32f_s32f_convert_32i_impls[index_u];

    assert(volk_32f_s32f_convert_32i_a);
    assert(volk_32f_s32f_convert_32i_u);

    volk_32f_s32f_convert_32i = &__volk_32f_s32f_convert_32i_d;
}

static inline void __volk_32f_s32f_convert_32i_a(int32_t*  outputVector, const float*  inputVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32f_s32f_convert_32i();
    volk_32f_s32f_convert_32i_a(outputVector, inputVector, scalar, num_points);
}

static inline void __volk_32f_s32f_convert_32i_u(int32_t*  outputVector, const float*  inputVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32f_s32f_convert_32i();
    volk_32f_s32f_convert_32i_u(outputVector, inputVector, scalar, num_points);
}

static inline void __volk_32f_s32f_convert_32i(int32_t*  outputVector, const float*  inputVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32f_s32f_convert_32i();
    volk_32f_s32f_convert_32i(outputVector, inputVector, scalar, num_points);
}

p_32f_s32f_convert_32i volk_32f_s32f_convert_32i_a = &__volk_32f_s32f_convert_32i_a;
p_32f_s32f_convert_32i volk_32f_s32f_convert_32i_u = &__volk_32f_s32f_convert_32i_u;
p_32f_s32f_convert_32i volk_32f_s32f_convert_32i   = &__volk_32f_s32f_convert_32i;

void volk_32f_s32f_convert_32i_manual(int32_t*  outputVector, const float*  inputVector, const float  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_s32f_convert_32i_impl_names,
        get_machine()->volk_32f_s32f_convert_32i_n_impls,
        impl_name
    );
    get_machine()->volk_32f_s32f_convert_32i_impls[index](
        outputVector, inputVector, scalar, num_points
    );
}

volk_func_desc_t volk_32f_s32f_convert_32i_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_s32f_convert_32i_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_convert_32i_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_convert_32i_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_convert_32i_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_s32f_convert_8i_d(int8_t*  outputVector, const float*  inputVector, const float  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outputVector,
        VOLK_OR_PTR(inputVector,
        0))
    )){
        volk_32f_s32f_convert_8i_a(outputVector, inputVector, scalar, num_points);
    }
    else{
        volk_32f_s32f_convert_8i_u(outputVector, inputVector, scalar, num_points);
    }
}

static inline void __init_volk_32f_s32f_convert_8i(void)
{
    const char *name = get_machine()->volk_32f_s32f_convert_8i_name;
    const char **impl_names = get_machine()->volk_32f_s32f_convert_8i_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_convert_8i_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_convert_8i_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_convert_8i_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_s32f_convert_8i_a = get_machine()->volk_32f_s32f_convert_8i_impls[index_a];
    volk_32f_s32f_convert_8i_u = get_machine()->volk_32f_s32f_convert_8i_impls[index_u];

    assert(volk_32f_s32f_convert_8i_a);
    assert(volk_32f_s32f_convert_8i_u);

    volk_32f_s32f_convert_8i = &__volk_32f_s32f_convert_8i_d;
}

static inline void __volk_32f_s32f_convert_8i_a(int8_t*  outputVector, const float*  inputVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32f_s32f_convert_8i();
    volk_32f_s32f_convert_8i_a(outputVector, inputVector, scalar, num_points);
}

static inline void __volk_32f_s32f_convert_8i_u(int8_t*  outputVector, const float*  inputVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32f_s32f_convert_8i();
    volk_32f_s32f_convert_8i_u(outputVector, inputVector, scalar, num_points);
}

static inline void __volk_32f_s32f_convert_8i(int8_t*  outputVector, const float*  inputVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32f_s32f_convert_8i();
    volk_32f_s32f_convert_8i(outputVector, inputVector, scalar, num_points);
}

p_32f_s32f_convert_8i volk_32f_s32f_convert_8i_a = &__volk_32f_s32f_convert_8i_a;
p_32f_s32f_convert_8i volk_32f_s32f_convert_8i_u = &__volk_32f_s32f_convert_8i_u;
p_32f_s32f_convert_8i volk_32f_s32f_convert_8i   = &__volk_32f_s32f_convert_8i;

void volk_32f_s32f_convert_8i_manual(int8_t*  outputVector, const float*  inputVector, const float  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_s32f_convert_8i_impl_names,
        get_machine()->volk_32f_s32f_convert_8i_n_impls,
        impl_name
    );
    get_machine()->volk_32f_s32f_convert_8i_impls[index](
        outputVector, inputVector, scalar, num_points
    );
}

volk_func_desc_t volk_32f_s32f_convert_8i_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_s32f_convert_8i_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_convert_8i_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_convert_8i_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_convert_8i_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_s32f_convertpuppet_8u_d(uint8_t*  output, const float*  input, float  scale, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(output,
        VOLK_OR_PTR(input,
        0))
    )){
        volk_32f_s32f_convertpuppet_8u_a(output, input, scale, num_points);
    }
    else{
        volk_32f_s32f_convertpuppet_8u_u(output, input, scale, num_points);
    }
}

static inline void __init_volk_32f_s32f_convertpuppet_8u(void)
{
    const char *name = get_machine()->volk_32f_s32f_convertpuppet_8u_name;
    const char **impl_names = get_machine()->volk_32f_s32f_convertpuppet_8u_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_convertpuppet_8u_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_convertpuppet_8u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_convertpuppet_8u_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_s32f_convertpuppet_8u_a = get_machine()->volk_32f_s32f_convertpuppet_8u_impls[index_a];
    volk_32f_s32f_convertpuppet_8u_u = get_machine()->volk_32f_s32f_convertpuppet_8u_impls[index_u];

    assert(volk_32f_s32f_convertpuppet_8u_a);
    assert(volk_32f_s32f_convertpuppet_8u_u);

    volk_32f_s32f_convertpuppet_8u = &__volk_32f_s32f_convertpuppet_8u_d;
}

static inline void __volk_32f_s32f_convertpuppet_8u_a(uint8_t*  output, const float*  input, float  scale, unsigned int  num_points)
{
    __init_volk_32f_s32f_convertpuppet_8u();
    volk_32f_s32f_convertpuppet_8u_a(output, input, scale, num_points);
}

static inline void __volk_32f_s32f_convertpuppet_8u_u(uint8_t*  output, const float*  input, float  scale, unsigned int  num_points)
{
    __init_volk_32f_s32f_convertpuppet_8u();
    volk_32f_s32f_convertpuppet_8u_u(output, input, scale, num_points);
}

static inline void __volk_32f_s32f_convertpuppet_8u(uint8_t*  output, const float*  input, float  scale, unsigned int  num_points)
{
    __init_volk_32f_s32f_convertpuppet_8u();
    volk_32f_s32f_convertpuppet_8u(output, input, scale, num_points);
}

p_32f_s32f_convertpuppet_8u volk_32f_s32f_convertpuppet_8u_a = &__volk_32f_s32f_convertpuppet_8u_a;
p_32f_s32f_convertpuppet_8u volk_32f_s32f_convertpuppet_8u_u = &__volk_32f_s32f_convertpuppet_8u_u;
p_32f_s32f_convertpuppet_8u volk_32f_s32f_convertpuppet_8u   = &__volk_32f_s32f_convertpuppet_8u;

void volk_32f_s32f_convertpuppet_8u_manual(uint8_t*  output, const float*  input, float  scale, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_s32f_convertpuppet_8u_impl_names,
        get_machine()->volk_32f_s32f_convertpuppet_8u_n_impls,
        impl_name
    );
    get_machine()->volk_32f_s32f_convertpuppet_8u_impls[index](
        output, input, scale, num_points
    );
}

volk_func_desc_t volk_32f_s32f_convertpuppet_8u_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_s32f_convertpuppet_8u_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_convertpuppet_8u_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_convertpuppet_8u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_convertpuppet_8u_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_s32f_mod_rangepuppet_32f_d(float*  output, const float*  input, float  bound, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(output,
        VOLK_OR_PTR(input,
        0))
    )){
        volk_32f_s32f_mod_rangepuppet_32f_a(output, input, bound, num_points);
    }
    else{
        volk_32f_s32f_mod_rangepuppet_32f_u(output, input, bound, num_points);
    }
}

static inline void __init_volk_32f_s32f_mod_rangepuppet_32f(void)
{
    const char *name = get_machine()->volk_32f_s32f_mod_rangepuppet_32f_name;
    const char **impl_names = get_machine()->volk_32f_s32f_mod_rangepuppet_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_mod_rangepuppet_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_mod_rangepuppet_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_mod_rangepuppet_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_s32f_mod_rangepuppet_32f_a = get_machine()->volk_32f_s32f_mod_rangepuppet_32f_impls[index_a];
    volk_32f_s32f_mod_rangepuppet_32f_u = get_machine()->volk_32f_s32f_mod_rangepuppet_32f_impls[index_u];

    assert(volk_32f_s32f_mod_rangepuppet_32f_a);
    assert(volk_32f_s32f_mod_rangepuppet_32f_u);

    volk_32f_s32f_mod_rangepuppet_32f = &__volk_32f_s32f_mod_rangepuppet_32f_d;
}

static inline void __volk_32f_s32f_mod_rangepuppet_32f_a(float*  output, const float*  input, float  bound, unsigned int  num_points)
{
    __init_volk_32f_s32f_mod_rangepuppet_32f();
    volk_32f_s32f_mod_rangepuppet_32f_a(output, input, bound, num_points);
}

static inline void __volk_32f_s32f_mod_rangepuppet_32f_u(float*  output, const float*  input, float  bound, unsigned int  num_points)
{
    __init_volk_32f_s32f_mod_rangepuppet_32f();
    volk_32f_s32f_mod_rangepuppet_32f_u(output, input, bound, num_points);
}

static inline void __volk_32f_s32f_mod_rangepuppet_32f(float*  output, const float*  input, float  bound, unsigned int  num_points)
{
    __init_volk_32f_s32f_mod_rangepuppet_32f();
    volk_32f_s32f_mod_rangepuppet_32f(output, input, bound, num_points);
}

p_32f_s32f_mod_rangepuppet_32f volk_32f_s32f_mod_rangepuppet_32f_a = &__volk_32f_s32f_mod_rangepuppet_32f_a;
p_32f_s32f_mod_rangepuppet_32f volk_32f_s32f_mod_rangepuppet_32f_u = &__volk_32f_s32f_mod_rangepuppet_32f_u;
p_32f_s32f_mod_rangepuppet_32f volk_32f_s32f_mod_rangepuppet_32f   = &__volk_32f_s32f_mod_rangepuppet_32f;

void volk_32f_s32f_mod_rangepuppet_32f_manual(float*  output, const float*  input, float  bound, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_s32f_mod_rangepuppet_32f_impl_names,
        get_machine()->volk_32f_s32f_mod_rangepuppet_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_s32f_mod_rangepuppet_32f_impls[index](
        output, input, bound, num_points
    );
}

volk_func_desc_t volk_32f_s32f_mod_rangepuppet_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_s32f_mod_rangepuppet_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_mod_rangepuppet_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_mod_rangepuppet_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_mod_rangepuppet_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_s32f_multiply_32f_d(float*  cVector, const float*  aVector, const float  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        0))
    )){
        volk_32f_s32f_multiply_32f_a(cVector, aVector, scalar, num_points);
    }
    else{
        volk_32f_s32f_multiply_32f_u(cVector, aVector, scalar, num_points);
    }
}

static inline void __init_volk_32f_s32f_multiply_32f(void)
{
    const char *name = get_machine()->volk_32f_s32f_multiply_32f_name;
    const char **impl_names = get_machine()->volk_32f_s32f_multiply_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_multiply_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_multiply_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_multiply_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_s32f_multiply_32f_a = get_machine()->volk_32f_s32f_multiply_32f_impls[index_a];
    volk_32f_s32f_multiply_32f_u = get_machine()->volk_32f_s32f_multiply_32f_impls[index_u];

    assert(volk_32f_s32f_multiply_32f_a);
    assert(volk_32f_s32f_multiply_32f_u);

    volk_32f_s32f_multiply_32f = &__volk_32f_s32f_multiply_32f_d;
}

static inline void __volk_32f_s32f_multiply_32f_a(float*  cVector, const float*  aVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32f_s32f_multiply_32f();
    volk_32f_s32f_multiply_32f_a(cVector, aVector, scalar, num_points);
}

static inline void __volk_32f_s32f_multiply_32f_u(float*  cVector, const float*  aVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32f_s32f_multiply_32f();
    volk_32f_s32f_multiply_32f_u(cVector, aVector, scalar, num_points);
}

static inline void __volk_32f_s32f_multiply_32f(float*  cVector, const float*  aVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32f_s32f_multiply_32f();
    volk_32f_s32f_multiply_32f(cVector, aVector, scalar, num_points);
}

p_32f_s32f_multiply_32f volk_32f_s32f_multiply_32f_a = &__volk_32f_s32f_multiply_32f_a;
p_32f_s32f_multiply_32f volk_32f_s32f_multiply_32f_u = &__volk_32f_s32f_multiply_32f_u;
p_32f_s32f_multiply_32f volk_32f_s32f_multiply_32f   = &__volk_32f_s32f_multiply_32f;

void volk_32f_s32f_multiply_32f_manual(float*  cVector, const float*  aVector, const float  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_s32f_multiply_32f_impl_names,
        get_machine()->volk_32f_s32f_multiply_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_s32f_multiply_32f_impls[index](
        cVector, aVector, scalar, num_points
    );
}

volk_func_desc_t volk_32f_s32f_multiply_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_s32f_multiply_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_multiply_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_multiply_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_multiply_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_s32f_normalize_d(float*  vecBuffer, const float  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(vecBuffer,
        0)
    )){
        volk_32f_s32f_normalize_a(vecBuffer, scalar, num_points);
    }
    else{
        volk_32f_s32f_normalize_u(vecBuffer, scalar, num_points);
    }
}

static inline void __init_volk_32f_s32f_normalize(void)
{
    const char *name = get_machine()->volk_32f_s32f_normalize_name;
    const char **impl_names = get_machine()->volk_32f_s32f_normalize_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_normalize_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_normalize_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_normalize_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_s32f_normalize_a = get_machine()->volk_32f_s32f_normalize_impls[index_a];
    volk_32f_s32f_normalize_u = get_machine()->volk_32f_s32f_normalize_impls[index_u];

    assert(volk_32f_s32f_normalize_a);
    assert(volk_32f_s32f_normalize_u);

    volk_32f_s32f_normalize = &__volk_32f_s32f_normalize_d;
}

static inline void __volk_32f_s32f_normalize_a(float*  vecBuffer, const float  scalar, unsigned int  num_points)
{
    __init_volk_32f_s32f_normalize();
    volk_32f_s32f_normalize_a(vecBuffer, scalar, num_points);
}

static inline void __volk_32f_s32f_normalize_u(float*  vecBuffer, const float  scalar, unsigned int  num_points)
{
    __init_volk_32f_s32f_normalize();
    volk_32f_s32f_normalize_u(vecBuffer, scalar, num_points);
}

static inline void __volk_32f_s32f_normalize(float*  vecBuffer, const float  scalar, unsigned int  num_points)
{
    __init_volk_32f_s32f_normalize();
    volk_32f_s32f_normalize(vecBuffer, scalar, num_points);
}

p_32f_s32f_normalize volk_32f_s32f_normalize_a = &__volk_32f_s32f_normalize_a;
p_32f_s32f_normalize volk_32f_s32f_normalize_u = &__volk_32f_s32f_normalize_u;
p_32f_s32f_normalize volk_32f_s32f_normalize   = &__volk_32f_s32f_normalize;

void volk_32f_s32f_normalize_manual(float*  vecBuffer, const float  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_s32f_normalize_impl_names,
        get_machine()->volk_32f_s32f_normalize_n_impls,
        impl_name
    );
    get_machine()->volk_32f_s32f_normalize_impls[index](
        vecBuffer, scalar, num_points
    );
}

volk_func_desc_t volk_32f_s32f_normalize_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_s32f_normalize_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_normalize_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_normalize_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_normalize_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_s32f_power_32f_d(float*  cVector, const float*  aVector, const float  power, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        0))
    )){
        volk_32f_s32f_power_32f_a(cVector, aVector, power, num_points);
    }
    else{
        volk_32f_s32f_power_32f_u(cVector, aVector, power, num_points);
    }
}

static inline void __init_volk_32f_s32f_power_32f(void)
{
    const char *name = get_machine()->volk_32f_s32f_power_32f_name;
    const char **impl_names = get_machine()->volk_32f_s32f_power_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_power_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_power_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_power_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_s32f_power_32f_a = get_machine()->volk_32f_s32f_power_32f_impls[index_a];
    volk_32f_s32f_power_32f_u = get_machine()->volk_32f_s32f_power_32f_impls[index_u];

    assert(volk_32f_s32f_power_32f_a);
    assert(volk_32f_s32f_power_32f_u);

    volk_32f_s32f_power_32f = &__volk_32f_s32f_power_32f_d;
}

static inline void __volk_32f_s32f_power_32f_a(float*  cVector, const float*  aVector, const float  power, unsigned int  num_points)
{
    __init_volk_32f_s32f_power_32f();
    volk_32f_s32f_power_32f_a(cVector, aVector, power, num_points);
}

static inline void __volk_32f_s32f_power_32f_u(float*  cVector, const float*  aVector, const float  power, unsigned int  num_points)
{
    __init_volk_32f_s32f_power_32f();
    volk_32f_s32f_power_32f_u(cVector, aVector, power, num_points);
}

static inline void __volk_32f_s32f_power_32f(float*  cVector, const float*  aVector, const float  power, unsigned int  num_points)
{
    __init_volk_32f_s32f_power_32f();
    volk_32f_s32f_power_32f(cVector, aVector, power, num_points);
}

p_32f_s32f_power_32f volk_32f_s32f_power_32f_a = &__volk_32f_s32f_power_32f_a;
p_32f_s32f_power_32f volk_32f_s32f_power_32f_u = &__volk_32f_s32f_power_32f_u;
p_32f_s32f_power_32f volk_32f_s32f_power_32f   = &__volk_32f_s32f_power_32f;

void volk_32f_s32f_power_32f_manual(float*  cVector, const float*  aVector, const float  power, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_s32f_power_32f_impl_names,
        get_machine()->volk_32f_s32f_power_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_s32f_power_32f_impls[index](
        cVector, aVector, power, num_points
    );
}

volk_func_desc_t volk_32f_s32f_power_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_s32f_power_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_power_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_power_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_power_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_s32f_s32f_mod_range_32f_d(float*  outputVector, const float*  inputVector, const float  lower_bound, const float  upper_bound, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outputVector,
        VOLK_OR_PTR(inputVector,
        0))
    )){
        volk_32f_s32f_s32f_mod_range_32f_a(outputVector, inputVector, lower_bound, upper_bound, num_points);
    }
    else{
        volk_32f_s32f_s32f_mod_range_32f_u(outputVector, inputVector, lower_bound, upper_bound, num_points);
    }
}

static inline void __init_volk_32f_s32f_s32f_mod_range_32f(void)
{
    const char *name = get_machine()->volk_32f_s32f_s32f_mod_range_32f_name;
    const char **impl_names = get_machine()->volk_32f_s32f_s32f_mod_range_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_s32f_mod_range_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_s32f_mod_range_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_s32f_mod_range_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_s32f_s32f_mod_range_32f_a = get_machine()->volk_32f_s32f_s32f_mod_range_32f_impls[index_a];
    volk_32f_s32f_s32f_mod_range_32f_u = get_machine()->volk_32f_s32f_s32f_mod_range_32f_impls[index_u];

    assert(volk_32f_s32f_s32f_mod_range_32f_a);
    assert(volk_32f_s32f_s32f_mod_range_32f_u);

    volk_32f_s32f_s32f_mod_range_32f = &__volk_32f_s32f_s32f_mod_range_32f_d;
}

static inline void __volk_32f_s32f_s32f_mod_range_32f_a(float*  outputVector, const float*  inputVector, const float  lower_bound, const float  upper_bound, unsigned int  num_points)
{
    __init_volk_32f_s32f_s32f_mod_range_32f();
    volk_32f_s32f_s32f_mod_range_32f_a(outputVector, inputVector, lower_bound, upper_bound, num_points);
}

static inline void __volk_32f_s32f_s32f_mod_range_32f_u(float*  outputVector, const float*  inputVector, const float  lower_bound, const float  upper_bound, unsigned int  num_points)
{
    __init_volk_32f_s32f_s32f_mod_range_32f();
    volk_32f_s32f_s32f_mod_range_32f_u(outputVector, inputVector, lower_bound, upper_bound, num_points);
}

static inline void __volk_32f_s32f_s32f_mod_range_32f(float*  outputVector, const float*  inputVector, const float  lower_bound, const float  upper_bound, unsigned int  num_points)
{
    __init_volk_32f_s32f_s32f_mod_range_32f();
    volk_32f_s32f_s32f_mod_range_32f(outputVector, inputVector, lower_bound, upper_bound, num_points);
}

p_32f_s32f_s32f_mod_range_32f volk_32f_s32f_s32f_mod_range_32f_a = &__volk_32f_s32f_s32f_mod_range_32f_a;
p_32f_s32f_s32f_mod_range_32f volk_32f_s32f_s32f_mod_range_32f_u = &__volk_32f_s32f_s32f_mod_range_32f_u;
p_32f_s32f_s32f_mod_range_32f volk_32f_s32f_s32f_mod_range_32f   = &__volk_32f_s32f_s32f_mod_range_32f;

void volk_32f_s32f_s32f_mod_range_32f_manual(float*  outputVector, const float*  inputVector, const float  lower_bound, const float  upper_bound, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_s32f_s32f_mod_range_32f_impl_names,
        get_machine()->volk_32f_s32f_s32f_mod_range_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_s32f_s32f_mod_range_32f_impls[index](
        outputVector, inputVector, lower_bound, upper_bound, num_points
    );
}

volk_func_desc_t volk_32f_s32f_s32f_mod_range_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_s32f_s32f_mod_range_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_s32f_mod_range_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_s32f_mod_range_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_s32f_mod_range_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_s32f_stddev_32f_d(float*  stddev, const float*  inputBuffer, const float  mean, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(stddev,
        VOLK_OR_PTR(inputBuffer,
        0))
    )){
        volk_32f_s32f_stddev_32f_a(stddev, inputBuffer, mean, num_points);
    }
    else{
        volk_32f_s32f_stddev_32f_u(stddev, inputBuffer, mean, num_points);
    }
}

static inline void __init_volk_32f_s32f_stddev_32f(void)
{
    const char *name = get_machine()->volk_32f_s32f_stddev_32f_name;
    const char **impl_names = get_machine()->volk_32f_s32f_stddev_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_stddev_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_stddev_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_stddev_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_s32f_stddev_32f_a = get_machine()->volk_32f_s32f_stddev_32f_impls[index_a];
    volk_32f_s32f_stddev_32f_u = get_machine()->volk_32f_s32f_stddev_32f_impls[index_u];

    assert(volk_32f_s32f_stddev_32f_a);
    assert(volk_32f_s32f_stddev_32f_u);

    volk_32f_s32f_stddev_32f = &__volk_32f_s32f_stddev_32f_d;
}

static inline void __volk_32f_s32f_stddev_32f_a(float*  stddev, const float*  inputBuffer, const float  mean, unsigned int  num_points)
{
    __init_volk_32f_s32f_stddev_32f();
    volk_32f_s32f_stddev_32f_a(stddev, inputBuffer, mean, num_points);
}

static inline void __volk_32f_s32f_stddev_32f_u(float*  stddev, const float*  inputBuffer, const float  mean, unsigned int  num_points)
{
    __init_volk_32f_s32f_stddev_32f();
    volk_32f_s32f_stddev_32f_u(stddev, inputBuffer, mean, num_points);
}

static inline void __volk_32f_s32f_stddev_32f(float*  stddev, const float*  inputBuffer, const float  mean, unsigned int  num_points)
{
    __init_volk_32f_s32f_stddev_32f();
    volk_32f_s32f_stddev_32f(stddev, inputBuffer, mean, num_points);
}

p_32f_s32f_stddev_32f volk_32f_s32f_stddev_32f_a = &__volk_32f_s32f_stddev_32f_a;
p_32f_s32f_stddev_32f volk_32f_s32f_stddev_32f_u = &__volk_32f_s32f_stddev_32f_u;
p_32f_s32f_stddev_32f volk_32f_s32f_stddev_32f   = &__volk_32f_s32f_stddev_32f;

void volk_32f_s32f_stddev_32f_manual(float*  stddev, const float*  inputBuffer, const float  mean, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_s32f_stddev_32f_impl_names,
        get_machine()->volk_32f_s32f_stddev_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_s32f_stddev_32f_impls[index](
        stddev, inputBuffer, mean, num_points
    );
}

volk_func_desc_t volk_32f_s32f_stddev_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_s32f_stddev_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_stddev_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_stddev_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_stddev_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_s32f_x2_clamp_32f_d(float*  out, const float*  in, const float  min, const float  max, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(out,
        VOLK_OR_PTR(in,
        0))
    )){
        volk_32f_s32f_x2_clamp_32f_a(out, in, min, max, num_points);
    }
    else{
        volk_32f_s32f_x2_clamp_32f_u(out, in, min, max, num_points);
    }
}

static inline void __init_volk_32f_s32f_x2_clamp_32f(void)
{
    const char *name = get_machine()->volk_32f_s32f_x2_clamp_32f_name;
    const char **impl_names = get_machine()->volk_32f_s32f_x2_clamp_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_x2_clamp_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_x2_clamp_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_x2_clamp_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_s32f_x2_clamp_32f_a = get_machine()->volk_32f_s32f_x2_clamp_32f_impls[index_a];
    volk_32f_s32f_x2_clamp_32f_u = get_machine()->volk_32f_s32f_x2_clamp_32f_impls[index_u];

    assert(volk_32f_s32f_x2_clamp_32f_a);
    assert(volk_32f_s32f_x2_clamp_32f_u);

    volk_32f_s32f_x2_clamp_32f = &__volk_32f_s32f_x2_clamp_32f_d;
}

static inline void __volk_32f_s32f_x2_clamp_32f_a(float*  out, const float*  in, const float  min, const float  max, unsigned int  num_points)
{
    __init_volk_32f_s32f_x2_clamp_32f();
    volk_32f_s32f_x2_clamp_32f_a(out, in, min, max, num_points);
}

static inline void __volk_32f_s32f_x2_clamp_32f_u(float*  out, const float*  in, const float  min, const float  max, unsigned int  num_points)
{
    __init_volk_32f_s32f_x2_clamp_32f();
    volk_32f_s32f_x2_clamp_32f_u(out, in, min, max, num_points);
}

static inline void __volk_32f_s32f_x2_clamp_32f(float*  out, const float*  in, const float  min, const float  max, unsigned int  num_points)
{
    __init_volk_32f_s32f_x2_clamp_32f();
    volk_32f_s32f_x2_clamp_32f(out, in, min, max, num_points);
}

p_32f_s32f_x2_clamp_32f volk_32f_s32f_x2_clamp_32f_a = &__volk_32f_s32f_x2_clamp_32f_a;
p_32f_s32f_x2_clamp_32f volk_32f_s32f_x2_clamp_32f_u = &__volk_32f_s32f_x2_clamp_32f_u;
p_32f_s32f_x2_clamp_32f volk_32f_s32f_x2_clamp_32f   = &__volk_32f_s32f_x2_clamp_32f;

void volk_32f_s32f_x2_clamp_32f_manual(float*  out, const float*  in, const float  min, const float  max, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_s32f_x2_clamp_32f_impl_names,
        get_machine()->volk_32f_s32f_x2_clamp_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_s32f_x2_clamp_32f_impls[index](
        out, in, min, max, num_points
    );
}

volk_func_desc_t volk_32f_s32f_x2_clamp_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_s32f_x2_clamp_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_x2_clamp_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_x2_clamp_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_x2_clamp_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_s32f_x2_convert_8u_d(uint8_t*  outputVector, const float*  inputVector, const float  scale, const float  bias, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outputVector,
        VOLK_OR_PTR(inputVector,
        0))
    )){
        volk_32f_s32f_x2_convert_8u_a(outputVector, inputVector, scale, bias, num_points);
    }
    else{
        volk_32f_s32f_x2_convert_8u_u(outputVector, inputVector, scale, bias, num_points);
    }
}

static inline void __init_volk_32f_s32f_x2_convert_8u(void)
{
    const char *name = get_machine()->volk_32f_s32f_x2_convert_8u_name;
    const char **impl_names = get_machine()->volk_32f_s32f_x2_convert_8u_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_x2_convert_8u_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_x2_convert_8u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_x2_convert_8u_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_s32f_x2_convert_8u_a = get_machine()->volk_32f_s32f_x2_convert_8u_impls[index_a];
    volk_32f_s32f_x2_convert_8u_u = get_machine()->volk_32f_s32f_x2_convert_8u_impls[index_u];

    assert(volk_32f_s32f_x2_convert_8u_a);
    assert(volk_32f_s32f_x2_convert_8u_u);

    volk_32f_s32f_x2_convert_8u = &__volk_32f_s32f_x2_convert_8u_d;
}

static inline void __volk_32f_s32f_x2_convert_8u_a(uint8_t*  outputVector, const float*  inputVector, const float  scale, const float  bias, unsigned int  num_points)
{
    __init_volk_32f_s32f_x2_convert_8u();
    volk_32f_s32f_x2_convert_8u_a(outputVector, inputVector, scale, bias, num_points);
}

static inline void __volk_32f_s32f_x2_convert_8u_u(uint8_t*  outputVector, const float*  inputVector, const float  scale, const float  bias, unsigned int  num_points)
{
    __init_volk_32f_s32f_x2_convert_8u();
    volk_32f_s32f_x2_convert_8u_u(outputVector, inputVector, scale, bias, num_points);
}

static inline void __volk_32f_s32f_x2_convert_8u(uint8_t*  outputVector, const float*  inputVector, const float  scale, const float  bias, unsigned int  num_points)
{
    __init_volk_32f_s32f_x2_convert_8u();
    volk_32f_s32f_x2_convert_8u(outputVector, inputVector, scale, bias, num_points);
}

p_32f_s32f_x2_convert_8u volk_32f_s32f_x2_convert_8u_a = &__volk_32f_s32f_x2_convert_8u_a;
p_32f_s32f_x2_convert_8u volk_32f_s32f_x2_convert_8u_u = &__volk_32f_s32f_x2_convert_8u_u;
p_32f_s32f_x2_convert_8u volk_32f_s32f_x2_convert_8u   = &__volk_32f_s32f_x2_convert_8u;

void volk_32f_s32f_x2_convert_8u_manual(uint8_t*  outputVector, const float*  inputVector, const float  scale, const float  bias, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_s32f_x2_convert_8u_impl_names,
        get_machine()->volk_32f_s32f_x2_convert_8u_n_impls,
        impl_name
    );
    get_machine()->volk_32f_s32f_x2_convert_8u_impls[index](
        outputVector, inputVector, scale, bias, num_points
    );
}

volk_func_desc_t volk_32f_s32f_x2_convert_8u_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_s32f_x2_convert_8u_impl_names;
    const int *impl_deps = get_machine()->volk_32f_s32f_x2_convert_8u_impl_deps;
    const bool *alignment = get_machine()->volk_32f_s32f_x2_convert_8u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_s32f_x2_convert_8u_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_sin_32f_d(float*  sinVector, const float*  inVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(sinVector,
        VOLK_OR_PTR(inVector,
        0))
    )){
        volk_32f_sin_32f_a(sinVector, inVector, num_points);
    }
    else{
        volk_32f_sin_32f_u(sinVector, inVector, num_points);
    }
}

static inline void __init_volk_32f_sin_32f(void)
{
    const char *name = get_machine()->volk_32f_sin_32f_name;
    const char **impl_names = get_machine()->volk_32f_sin_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_sin_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_sin_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_sin_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_sin_32f_a = get_machine()->volk_32f_sin_32f_impls[index_a];
    volk_32f_sin_32f_u = get_machine()->volk_32f_sin_32f_impls[index_u];

    assert(volk_32f_sin_32f_a);
    assert(volk_32f_sin_32f_u);

    volk_32f_sin_32f = &__volk_32f_sin_32f_d;
}

static inline void __volk_32f_sin_32f_a(float*  sinVector, const float*  inVector, unsigned int  num_points)
{
    __init_volk_32f_sin_32f();
    volk_32f_sin_32f_a(sinVector, inVector, num_points);
}

static inline void __volk_32f_sin_32f_u(float*  sinVector, const float*  inVector, unsigned int  num_points)
{
    __init_volk_32f_sin_32f();
    volk_32f_sin_32f_u(sinVector, inVector, num_points);
}

static inline void __volk_32f_sin_32f(float*  sinVector, const float*  inVector, unsigned int  num_points)
{
    __init_volk_32f_sin_32f();
    volk_32f_sin_32f(sinVector, inVector, num_points);
}

p_32f_sin_32f volk_32f_sin_32f_a = &__volk_32f_sin_32f_a;
p_32f_sin_32f volk_32f_sin_32f_u = &__volk_32f_sin_32f_u;
p_32f_sin_32f volk_32f_sin_32f   = &__volk_32f_sin_32f;

void volk_32f_sin_32f_manual(float*  sinVector, const float*  inVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_sin_32f_impl_names,
        get_machine()->volk_32f_sin_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_sin_32f_impls[index](
        sinVector, inVector, num_points
    );
}

volk_func_desc_t volk_32f_sin_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_sin_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_sin_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_sin_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_sin_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_sqrt_32f_d(float*  cVector, const float*  aVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        0))
    )){
        volk_32f_sqrt_32f_a(cVector, aVector, num_points);
    }
    else{
        volk_32f_sqrt_32f_u(cVector, aVector, num_points);
    }
}

static inline void __init_volk_32f_sqrt_32f(void)
{
    const char *name = get_machine()->volk_32f_sqrt_32f_name;
    const char **impl_names = get_machine()->volk_32f_sqrt_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_sqrt_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_sqrt_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_sqrt_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_sqrt_32f_a = get_machine()->volk_32f_sqrt_32f_impls[index_a];
    volk_32f_sqrt_32f_u = get_machine()->volk_32f_sqrt_32f_impls[index_u];

    assert(volk_32f_sqrt_32f_a);
    assert(volk_32f_sqrt_32f_u);

    volk_32f_sqrt_32f = &__volk_32f_sqrt_32f_d;
}

static inline void __volk_32f_sqrt_32f_a(float*  cVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_sqrt_32f();
    volk_32f_sqrt_32f_a(cVector, aVector, num_points);
}

static inline void __volk_32f_sqrt_32f_u(float*  cVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_sqrt_32f();
    volk_32f_sqrt_32f_u(cVector, aVector, num_points);
}

static inline void __volk_32f_sqrt_32f(float*  cVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_sqrt_32f();
    volk_32f_sqrt_32f(cVector, aVector, num_points);
}

p_32f_sqrt_32f volk_32f_sqrt_32f_a = &__volk_32f_sqrt_32f_a;
p_32f_sqrt_32f volk_32f_sqrt_32f_u = &__volk_32f_sqrt_32f_u;
p_32f_sqrt_32f volk_32f_sqrt_32f   = &__volk_32f_sqrt_32f;

void volk_32f_sqrt_32f_manual(float*  cVector, const float*  aVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_sqrt_32f_impl_names,
        get_machine()->volk_32f_sqrt_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_sqrt_32f_impls[index](
        cVector, aVector, num_points
    );
}

volk_func_desc_t volk_32f_sqrt_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_sqrt_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_sqrt_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_sqrt_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_sqrt_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_stddev_and_mean_32f_x2_d(float*  stddev, float*  mean, const float*  inputBuffer, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(stddev,
        VOLK_OR_PTR(mean,
        VOLK_OR_PTR(inputBuffer,
        0)))
    )){
        volk_32f_stddev_and_mean_32f_x2_a(stddev, mean, inputBuffer, num_points);
    }
    else{
        volk_32f_stddev_and_mean_32f_x2_u(stddev, mean, inputBuffer, num_points);
    }
}

static inline void __init_volk_32f_stddev_and_mean_32f_x2(void)
{
    const char *name = get_machine()->volk_32f_stddev_and_mean_32f_x2_name;
    const char **impl_names = get_machine()->volk_32f_stddev_and_mean_32f_x2_impl_names;
    const int *impl_deps = get_machine()->volk_32f_stddev_and_mean_32f_x2_impl_deps;
    const bool *alignment = get_machine()->volk_32f_stddev_and_mean_32f_x2_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_stddev_and_mean_32f_x2_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_stddev_and_mean_32f_x2_a = get_machine()->volk_32f_stddev_and_mean_32f_x2_impls[index_a];
    volk_32f_stddev_and_mean_32f_x2_u = get_machine()->volk_32f_stddev_and_mean_32f_x2_impls[index_u];

    assert(volk_32f_stddev_and_mean_32f_x2_a);
    assert(volk_32f_stddev_and_mean_32f_x2_u);

    volk_32f_stddev_and_mean_32f_x2 = &__volk_32f_stddev_and_mean_32f_x2_d;
}

static inline void __volk_32f_stddev_and_mean_32f_x2_a(float*  stddev, float*  mean, const float*  inputBuffer, unsigned int  num_points)
{
    __init_volk_32f_stddev_and_mean_32f_x2();
    volk_32f_stddev_and_mean_32f_x2_a(stddev, mean, inputBuffer, num_points);
}

static inline void __volk_32f_stddev_and_mean_32f_x2_u(float*  stddev, float*  mean, const float*  inputBuffer, unsigned int  num_points)
{
    __init_volk_32f_stddev_and_mean_32f_x2();
    volk_32f_stddev_and_mean_32f_x2_u(stddev, mean, inputBuffer, num_points);
}

static inline void __volk_32f_stddev_and_mean_32f_x2(float*  stddev, float*  mean, const float*  inputBuffer, unsigned int  num_points)
{
    __init_volk_32f_stddev_and_mean_32f_x2();
    volk_32f_stddev_and_mean_32f_x2(stddev, mean, inputBuffer, num_points);
}

p_32f_stddev_and_mean_32f_x2 volk_32f_stddev_and_mean_32f_x2_a = &__volk_32f_stddev_and_mean_32f_x2_a;
p_32f_stddev_and_mean_32f_x2 volk_32f_stddev_and_mean_32f_x2_u = &__volk_32f_stddev_and_mean_32f_x2_u;
p_32f_stddev_and_mean_32f_x2 volk_32f_stddev_and_mean_32f_x2   = &__volk_32f_stddev_and_mean_32f_x2;

void volk_32f_stddev_and_mean_32f_x2_manual(float*  stddev, float*  mean, const float*  inputBuffer, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_stddev_and_mean_32f_x2_impl_names,
        get_machine()->volk_32f_stddev_and_mean_32f_x2_n_impls,
        impl_name
    );
    get_machine()->volk_32f_stddev_and_mean_32f_x2_impls[index](
        stddev, mean, inputBuffer, num_points
    );
}

volk_func_desc_t volk_32f_stddev_and_mean_32f_x2_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_stddev_and_mean_32f_x2_impl_names;
    const int *impl_deps = get_machine()->volk_32f_stddev_and_mean_32f_x2_impl_deps;
    const bool *alignment = get_machine()->volk_32f_stddev_and_mean_32f_x2_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_stddev_and_mean_32f_x2_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_tan_32f_d(float*  bVector, const float*  aVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(bVector,
        VOLK_OR_PTR(aVector,
        0))
    )){
        volk_32f_tan_32f_a(bVector, aVector, num_points);
    }
    else{
        volk_32f_tan_32f_u(bVector, aVector, num_points);
    }
}

static inline void __init_volk_32f_tan_32f(void)
{
    const char *name = get_machine()->volk_32f_tan_32f_name;
    const char **impl_names = get_machine()->volk_32f_tan_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_tan_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_tan_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_tan_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_tan_32f_a = get_machine()->volk_32f_tan_32f_impls[index_a];
    volk_32f_tan_32f_u = get_machine()->volk_32f_tan_32f_impls[index_u];

    assert(volk_32f_tan_32f_a);
    assert(volk_32f_tan_32f_u);

    volk_32f_tan_32f = &__volk_32f_tan_32f_d;
}

static inline void __volk_32f_tan_32f_a(float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_tan_32f();
    volk_32f_tan_32f_a(bVector, aVector, num_points);
}

static inline void __volk_32f_tan_32f_u(float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_tan_32f();
    volk_32f_tan_32f_u(bVector, aVector, num_points);
}

static inline void __volk_32f_tan_32f(float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_tan_32f();
    volk_32f_tan_32f(bVector, aVector, num_points);
}

p_32f_tan_32f volk_32f_tan_32f_a = &__volk_32f_tan_32f_a;
p_32f_tan_32f volk_32f_tan_32f_u = &__volk_32f_tan_32f_u;
p_32f_tan_32f volk_32f_tan_32f   = &__volk_32f_tan_32f;

void volk_32f_tan_32f_manual(float*  bVector, const float*  aVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_tan_32f_impl_names,
        get_machine()->volk_32f_tan_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_tan_32f_impls[index](
        bVector, aVector, num_points
    );
}

volk_func_desc_t volk_32f_tan_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_tan_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_tan_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_tan_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_tan_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_tanh_32f_d(float*  cVector, const float*  aVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        0))
    )){
        volk_32f_tanh_32f_a(cVector, aVector, num_points);
    }
    else{
        volk_32f_tanh_32f_u(cVector, aVector, num_points);
    }
}

static inline void __init_volk_32f_tanh_32f(void)
{
    const char *name = get_machine()->volk_32f_tanh_32f_name;
    const char **impl_names = get_machine()->volk_32f_tanh_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_tanh_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_tanh_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_tanh_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_tanh_32f_a = get_machine()->volk_32f_tanh_32f_impls[index_a];
    volk_32f_tanh_32f_u = get_machine()->volk_32f_tanh_32f_impls[index_u];

    assert(volk_32f_tanh_32f_a);
    assert(volk_32f_tanh_32f_u);

    volk_32f_tanh_32f = &__volk_32f_tanh_32f_d;
}

static inline void __volk_32f_tanh_32f_a(float*  cVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_tanh_32f();
    volk_32f_tanh_32f_a(cVector, aVector, num_points);
}

static inline void __volk_32f_tanh_32f_u(float*  cVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_tanh_32f();
    volk_32f_tanh_32f_u(cVector, aVector, num_points);
}

static inline void __volk_32f_tanh_32f(float*  cVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_tanh_32f();
    volk_32f_tanh_32f(cVector, aVector, num_points);
}

p_32f_tanh_32f volk_32f_tanh_32f_a = &__volk_32f_tanh_32f_a;
p_32f_tanh_32f volk_32f_tanh_32f_u = &__volk_32f_tanh_32f_u;
p_32f_tanh_32f volk_32f_tanh_32f   = &__volk_32f_tanh_32f;

void volk_32f_tanh_32f_manual(float*  cVector, const float*  aVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_tanh_32f_impl_names,
        get_machine()->volk_32f_tanh_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_tanh_32f_impls[index](
        cVector, aVector, num_points
    );
}

volk_func_desc_t volk_32f_tanh_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_tanh_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_tanh_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_tanh_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_tanh_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_x2_add_32f_d(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_32f_x2_add_32f_a(cVector, aVector, bVector, num_points);
    }
    else{
        volk_32f_x2_add_32f_u(cVector, aVector, bVector, num_points);
    }
}

static inline void __init_volk_32f_x2_add_32f(void)
{
    const char *name = get_machine()->volk_32f_x2_add_32f_name;
    const char **impl_names = get_machine()->volk_32f_x2_add_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_add_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_add_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_add_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_x2_add_32f_a = get_machine()->volk_32f_x2_add_32f_impls[index_a];
    volk_32f_x2_add_32f_u = get_machine()->volk_32f_x2_add_32f_impls[index_u];

    assert(volk_32f_x2_add_32f_a);
    assert(volk_32f_x2_add_32f_u);

    volk_32f_x2_add_32f = &__volk_32f_x2_add_32f_d;
}

static inline void __volk_32f_x2_add_32f_a(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32f_x2_add_32f();
    volk_32f_x2_add_32f_a(cVector, aVector, bVector, num_points);
}

static inline void __volk_32f_x2_add_32f_u(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32f_x2_add_32f();
    volk_32f_x2_add_32f_u(cVector, aVector, bVector, num_points);
}

static inline void __volk_32f_x2_add_32f(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32f_x2_add_32f();
    volk_32f_x2_add_32f(cVector, aVector, bVector, num_points);
}

p_32f_x2_add_32f volk_32f_x2_add_32f_a = &__volk_32f_x2_add_32f_a;
p_32f_x2_add_32f volk_32f_x2_add_32f_u = &__volk_32f_x2_add_32f_u;
p_32f_x2_add_32f volk_32f_x2_add_32f   = &__volk_32f_x2_add_32f;

void volk_32f_x2_add_32f_manual(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_x2_add_32f_impl_names,
        get_machine()->volk_32f_x2_add_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_x2_add_32f_impls[index](
        cVector, aVector, bVector, num_points
    );
}

volk_func_desc_t volk_32f_x2_add_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_x2_add_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_add_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_add_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_add_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_x2_divide_32f_d(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_32f_x2_divide_32f_a(cVector, aVector, bVector, num_points);
    }
    else{
        volk_32f_x2_divide_32f_u(cVector, aVector, bVector, num_points);
    }
}

static inline void __init_volk_32f_x2_divide_32f(void)
{
    const char *name = get_machine()->volk_32f_x2_divide_32f_name;
    const char **impl_names = get_machine()->volk_32f_x2_divide_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_divide_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_divide_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_divide_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_x2_divide_32f_a = get_machine()->volk_32f_x2_divide_32f_impls[index_a];
    volk_32f_x2_divide_32f_u = get_machine()->volk_32f_x2_divide_32f_impls[index_u];

    assert(volk_32f_x2_divide_32f_a);
    assert(volk_32f_x2_divide_32f_u);

    volk_32f_x2_divide_32f = &__volk_32f_x2_divide_32f_d;
}

static inline void __volk_32f_x2_divide_32f_a(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32f_x2_divide_32f();
    volk_32f_x2_divide_32f_a(cVector, aVector, bVector, num_points);
}

static inline void __volk_32f_x2_divide_32f_u(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32f_x2_divide_32f();
    volk_32f_x2_divide_32f_u(cVector, aVector, bVector, num_points);
}

static inline void __volk_32f_x2_divide_32f(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32f_x2_divide_32f();
    volk_32f_x2_divide_32f(cVector, aVector, bVector, num_points);
}

p_32f_x2_divide_32f volk_32f_x2_divide_32f_a = &__volk_32f_x2_divide_32f_a;
p_32f_x2_divide_32f volk_32f_x2_divide_32f_u = &__volk_32f_x2_divide_32f_u;
p_32f_x2_divide_32f volk_32f_x2_divide_32f   = &__volk_32f_x2_divide_32f;

void volk_32f_x2_divide_32f_manual(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_x2_divide_32f_impl_names,
        get_machine()->volk_32f_x2_divide_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_x2_divide_32f_impls[index](
        cVector, aVector, bVector, num_points
    );
}

volk_func_desc_t volk_32f_x2_divide_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_x2_divide_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_divide_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_divide_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_divide_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_x2_dot_prod_16i_d(int16_t*  result, const float*  input, const float*  taps, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(result,
        VOLK_OR_PTR(input,
        VOLK_OR_PTR(taps,
        0)))
    )){
        volk_32f_x2_dot_prod_16i_a(result, input, taps, num_points);
    }
    else{
        volk_32f_x2_dot_prod_16i_u(result, input, taps, num_points);
    }
}

static inline void __init_volk_32f_x2_dot_prod_16i(void)
{
    const char *name = get_machine()->volk_32f_x2_dot_prod_16i_name;
    const char **impl_names = get_machine()->volk_32f_x2_dot_prod_16i_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_dot_prod_16i_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_dot_prod_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_dot_prod_16i_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_x2_dot_prod_16i_a = get_machine()->volk_32f_x2_dot_prod_16i_impls[index_a];
    volk_32f_x2_dot_prod_16i_u = get_machine()->volk_32f_x2_dot_prod_16i_impls[index_u];

    assert(volk_32f_x2_dot_prod_16i_a);
    assert(volk_32f_x2_dot_prod_16i_u);

    volk_32f_x2_dot_prod_16i = &__volk_32f_x2_dot_prod_16i_d;
}

static inline void __volk_32f_x2_dot_prod_16i_a(int16_t*  result, const float*  input, const float*  taps, unsigned int  num_points)
{
    __init_volk_32f_x2_dot_prod_16i();
    volk_32f_x2_dot_prod_16i_a(result, input, taps, num_points);
}

static inline void __volk_32f_x2_dot_prod_16i_u(int16_t*  result, const float*  input, const float*  taps, unsigned int  num_points)
{
    __init_volk_32f_x2_dot_prod_16i();
    volk_32f_x2_dot_prod_16i_u(result, input, taps, num_points);
}

static inline void __volk_32f_x2_dot_prod_16i(int16_t*  result, const float*  input, const float*  taps, unsigned int  num_points)
{
    __init_volk_32f_x2_dot_prod_16i();
    volk_32f_x2_dot_prod_16i(result, input, taps, num_points);
}

p_32f_x2_dot_prod_16i volk_32f_x2_dot_prod_16i_a = &__volk_32f_x2_dot_prod_16i_a;
p_32f_x2_dot_prod_16i volk_32f_x2_dot_prod_16i_u = &__volk_32f_x2_dot_prod_16i_u;
p_32f_x2_dot_prod_16i volk_32f_x2_dot_prod_16i   = &__volk_32f_x2_dot_prod_16i;

void volk_32f_x2_dot_prod_16i_manual(int16_t*  result, const float*  input, const float*  taps, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_x2_dot_prod_16i_impl_names,
        get_machine()->volk_32f_x2_dot_prod_16i_n_impls,
        impl_name
    );
    get_machine()->volk_32f_x2_dot_prod_16i_impls[index](
        result, input, taps, num_points
    );
}

volk_func_desc_t volk_32f_x2_dot_prod_16i_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_x2_dot_prod_16i_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_dot_prod_16i_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_dot_prod_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_dot_prod_16i_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_x2_dot_prod_32f_d(float*  result, const float*  input, const float*  taps, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(result,
        VOLK_OR_PTR(input,
        VOLK_OR_PTR(taps,
        0)))
    )){
        volk_32f_x2_dot_prod_32f_a(result, input, taps, num_points);
    }
    else{
        volk_32f_x2_dot_prod_32f_u(result, input, taps, num_points);
    }
}

static inline void __init_volk_32f_x2_dot_prod_32f(void)
{
    const char *name = get_machine()->volk_32f_x2_dot_prod_32f_name;
    const char **impl_names = get_machine()->volk_32f_x2_dot_prod_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_dot_prod_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_dot_prod_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_dot_prod_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_x2_dot_prod_32f_a = get_machine()->volk_32f_x2_dot_prod_32f_impls[index_a];
    volk_32f_x2_dot_prod_32f_u = get_machine()->volk_32f_x2_dot_prod_32f_impls[index_u];

    assert(volk_32f_x2_dot_prod_32f_a);
    assert(volk_32f_x2_dot_prod_32f_u);

    volk_32f_x2_dot_prod_32f = &__volk_32f_x2_dot_prod_32f_d;
}

static inline void __volk_32f_x2_dot_prod_32f_a(float*  result, const float*  input, const float*  taps, unsigned int  num_points)
{
    __init_volk_32f_x2_dot_prod_32f();
    volk_32f_x2_dot_prod_32f_a(result, input, taps, num_points);
}

static inline void __volk_32f_x2_dot_prod_32f_u(float*  result, const float*  input, const float*  taps, unsigned int  num_points)
{
    __init_volk_32f_x2_dot_prod_32f();
    volk_32f_x2_dot_prod_32f_u(result, input, taps, num_points);
}

static inline void __volk_32f_x2_dot_prod_32f(float*  result, const float*  input, const float*  taps, unsigned int  num_points)
{
    __init_volk_32f_x2_dot_prod_32f();
    volk_32f_x2_dot_prod_32f(result, input, taps, num_points);
}

p_32f_x2_dot_prod_32f volk_32f_x2_dot_prod_32f_a = &__volk_32f_x2_dot_prod_32f_a;
p_32f_x2_dot_prod_32f volk_32f_x2_dot_prod_32f_u = &__volk_32f_x2_dot_prod_32f_u;
p_32f_x2_dot_prod_32f volk_32f_x2_dot_prod_32f   = &__volk_32f_x2_dot_prod_32f;

void volk_32f_x2_dot_prod_32f_manual(float*  result, const float*  input, const float*  taps, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_x2_dot_prod_32f_impl_names,
        get_machine()->volk_32f_x2_dot_prod_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_x2_dot_prod_32f_impls[index](
        result, input, taps, num_points
    );
}

volk_func_desc_t volk_32f_x2_dot_prod_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_x2_dot_prod_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_dot_prod_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_dot_prod_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_dot_prod_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_x2_fm_detectpuppet_32f_d(float*  outputVector, const float*  inputVector, float*  saveValue, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outputVector,
        VOLK_OR_PTR(inputVector,
        VOLK_OR_PTR(saveValue,
        0)))
    )){
        volk_32f_x2_fm_detectpuppet_32f_a(outputVector, inputVector, saveValue, num_points);
    }
    else{
        volk_32f_x2_fm_detectpuppet_32f_u(outputVector, inputVector, saveValue, num_points);
    }
}

static inline void __init_volk_32f_x2_fm_detectpuppet_32f(void)
{
    const char *name = get_machine()->volk_32f_x2_fm_detectpuppet_32f_name;
    const char **impl_names = get_machine()->volk_32f_x2_fm_detectpuppet_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_fm_detectpuppet_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_fm_detectpuppet_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_fm_detectpuppet_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_x2_fm_detectpuppet_32f_a = get_machine()->volk_32f_x2_fm_detectpuppet_32f_impls[index_a];
    volk_32f_x2_fm_detectpuppet_32f_u = get_machine()->volk_32f_x2_fm_detectpuppet_32f_impls[index_u];

    assert(volk_32f_x2_fm_detectpuppet_32f_a);
    assert(volk_32f_x2_fm_detectpuppet_32f_u);

    volk_32f_x2_fm_detectpuppet_32f = &__volk_32f_x2_fm_detectpuppet_32f_d;
}

static inline void __volk_32f_x2_fm_detectpuppet_32f_a(float*  outputVector, const float*  inputVector, float*  saveValue, unsigned int  num_points)
{
    __init_volk_32f_x2_fm_detectpuppet_32f();
    volk_32f_x2_fm_detectpuppet_32f_a(outputVector, inputVector, saveValue, num_points);
}

static inline void __volk_32f_x2_fm_detectpuppet_32f_u(float*  outputVector, const float*  inputVector, float*  saveValue, unsigned int  num_points)
{
    __init_volk_32f_x2_fm_detectpuppet_32f();
    volk_32f_x2_fm_detectpuppet_32f_u(outputVector, inputVector, saveValue, num_points);
}

static inline void __volk_32f_x2_fm_detectpuppet_32f(float*  outputVector, const float*  inputVector, float*  saveValue, unsigned int  num_points)
{
    __init_volk_32f_x2_fm_detectpuppet_32f();
    volk_32f_x2_fm_detectpuppet_32f(outputVector, inputVector, saveValue, num_points);
}

p_32f_x2_fm_detectpuppet_32f volk_32f_x2_fm_detectpuppet_32f_a = &__volk_32f_x2_fm_detectpuppet_32f_a;
p_32f_x2_fm_detectpuppet_32f volk_32f_x2_fm_detectpuppet_32f_u = &__volk_32f_x2_fm_detectpuppet_32f_u;
p_32f_x2_fm_detectpuppet_32f volk_32f_x2_fm_detectpuppet_32f   = &__volk_32f_x2_fm_detectpuppet_32f;

void volk_32f_x2_fm_detectpuppet_32f_manual(float*  outputVector, const float*  inputVector, float*  saveValue, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_x2_fm_detectpuppet_32f_impl_names,
        get_machine()->volk_32f_x2_fm_detectpuppet_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_x2_fm_detectpuppet_32f_impls[index](
        outputVector, inputVector, saveValue, num_points
    );
}

volk_func_desc_t volk_32f_x2_fm_detectpuppet_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_x2_fm_detectpuppet_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_fm_detectpuppet_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_fm_detectpuppet_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_fm_detectpuppet_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_x2_interleave_32fc_d(lv_32fc_t*  complexVector, const float*  iBuffer, const float*  qBuffer, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(complexVector,
        VOLK_OR_PTR(iBuffer,
        VOLK_OR_PTR(qBuffer,
        0)))
    )){
        volk_32f_x2_interleave_32fc_a(complexVector, iBuffer, qBuffer, num_points);
    }
    else{
        volk_32f_x2_interleave_32fc_u(complexVector, iBuffer, qBuffer, num_points);
    }
}

static inline void __init_volk_32f_x2_interleave_32fc(void)
{
    const char *name = get_machine()->volk_32f_x2_interleave_32fc_name;
    const char **impl_names = get_machine()->volk_32f_x2_interleave_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_interleave_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_interleave_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_interleave_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_x2_interleave_32fc_a = get_machine()->volk_32f_x2_interleave_32fc_impls[index_a];
    volk_32f_x2_interleave_32fc_u = get_machine()->volk_32f_x2_interleave_32fc_impls[index_u];

    assert(volk_32f_x2_interleave_32fc_a);
    assert(volk_32f_x2_interleave_32fc_u);

    volk_32f_x2_interleave_32fc = &__volk_32f_x2_interleave_32fc_d;
}

static inline void __volk_32f_x2_interleave_32fc_a(lv_32fc_t*  complexVector, const float*  iBuffer, const float*  qBuffer, unsigned int  num_points)
{
    __init_volk_32f_x2_interleave_32fc();
    volk_32f_x2_interleave_32fc_a(complexVector, iBuffer, qBuffer, num_points);
}

static inline void __volk_32f_x2_interleave_32fc_u(lv_32fc_t*  complexVector, const float*  iBuffer, const float*  qBuffer, unsigned int  num_points)
{
    __init_volk_32f_x2_interleave_32fc();
    volk_32f_x2_interleave_32fc_u(complexVector, iBuffer, qBuffer, num_points);
}

static inline void __volk_32f_x2_interleave_32fc(lv_32fc_t*  complexVector, const float*  iBuffer, const float*  qBuffer, unsigned int  num_points)
{
    __init_volk_32f_x2_interleave_32fc();
    volk_32f_x2_interleave_32fc(complexVector, iBuffer, qBuffer, num_points);
}

p_32f_x2_interleave_32fc volk_32f_x2_interleave_32fc_a = &__volk_32f_x2_interleave_32fc_a;
p_32f_x2_interleave_32fc volk_32f_x2_interleave_32fc_u = &__volk_32f_x2_interleave_32fc_u;
p_32f_x2_interleave_32fc volk_32f_x2_interleave_32fc   = &__volk_32f_x2_interleave_32fc;

void volk_32f_x2_interleave_32fc_manual(lv_32fc_t*  complexVector, const float*  iBuffer, const float*  qBuffer, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_x2_interleave_32fc_impl_names,
        get_machine()->volk_32f_x2_interleave_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_32f_x2_interleave_32fc_impls[index](
        complexVector, iBuffer, qBuffer, num_points
    );
}

volk_func_desc_t volk_32f_x2_interleave_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_x2_interleave_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_interleave_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_interleave_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_interleave_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_x2_max_32f_d(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_32f_x2_max_32f_a(cVector, aVector, bVector, num_points);
    }
    else{
        volk_32f_x2_max_32f_u(cVector, aVector, bVector, num_points);
    }
}

static inline void __init_volk_32f_x2_max_32f(void)
{
    const char *name = get_machine()->volk_32f_x2_max_32f_name;
    const char **impl_names = get_machine()->volk_32f_x2_max_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_max_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_max_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_max_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_x2_max_32f_a = get_machine()->volk_32f_x2_max_32f_impls[index_a];
    volk_32f_x2_max_32f_u = get_machine()->volk_32f_x2_max_32f_impls[index_u];

    assert(volk_32f_x2_max_32f_a);
    assert(volk_32f_x2_max_32f_u);

    volk_32f_x2_max_32f = &__volk_32f_x2_max_32f_d;
}

static inline void __volk_32f_x2_max_32f_a(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32f_x2_max_32f();
    volk_32f_x2_max_32f_a(cVector, aVector, bVector, num_points);
}

static inline void __volk_32f_x2_max_32f_u(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32f_x2_max_32f();
    volk_32f_x2_max_32f_u(cVector, aVector, bVector, num_points);
}

static inline void __volk_32f_x2_max_32f(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32f_x2_max_32f();
    volk_32f_x2_max_32f(cVector, aVector, bVector, num_points);
}

p_32f_x2_max_32f volk_32f_x2_max_32f_a = &__volk_32f_x2_max_32f_a;
p_32f_x2_max_32f volk_32f_x2_max_32f_u = &__volk_32f_x2_max_32f_u;
p_32f_x2_max_32f volk_32f_x2_max_32f   = &__volk_32f_x2_max_32f;

void volk_32f_x2_max_32f_manual(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_x2_max_32f_impl_names,
        get_machine()->volk_32f_x2_max_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_x2_max_32f_impls[index](
        cVector, aVector, bVector, num_points
    );
}

volk_func_desc_t volk_32f_x2_max_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_x2_max_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_max_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_max_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_max_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_x2_min_32f_d(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_32f_x2_min_32f_a(cVector, aVector, bVector, num_points);
    }
    else{
        volk_32f_x2_min_32f_u(cVector, aVector, bVector, num_points);
    }
}

static inline void __init_volk_32f_x2_min_32f(void)
{
    const char *name = get_machine()->volk_32f_x2_min_32f_name;
    const char **impl_names = get_machine()->volk_32f_x2_min_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_min_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_min_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_min_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_x2_min_32f_a = get_machine()->volk_32f_x2_min_32f_impls[index_a];
    volk_32f_x2_min_32f_u = get_machine()->volk_32f_x2_min_32f_impls[index_u];

    assert(volk_32f_x2_min_32f_a);
    assert(volk_32f_x2_min_32f_u);

    volk_32f_x2_min_32f = &__volk_32f_x2_min_32f_d;
}

static inline void __volk_32f_x2_min_32f_a(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32f_x2_min_32f();
    volk_32f_x2_min_32f_a(cVector, aVector, bVector, num_points);
}

static inline void __volk_32f_x2_min_32f_u(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32f_x2_min_32f();
    volk_32f_x2_min_32f_u(cVector, aVector, bVector, num_points);
}

static inline void __volk_32f_x2_min_32f(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32f_x2_min_32f();
    volk_32f_x2_min_32f(cVector, aVector, bVector, num_points);
}

p_32f_x2_min_32f volk_32f_x2_min_32f_a = &__volk_32f_x2_min_32f_a;
p_32f_x2_min_32f volk_32f_x2_min_32f_u = &__volk_32f_x2_min_32f_u;
p_32f_x2_min_32f volk_32f_x2_min_32f   = &__volk_32f_x2_min_32f;

void volk_32f_x2_min_32f_manual(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_x2_min_32f_impl_names,
        get_machine()->volk_32f_x2_min_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_x2_min_32f_impls[index](
        cVector, aVector, bVector, num_points
    );
}

volk_func_desc_t volk_32f_x2_min_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_x2_min_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_min_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_min_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_min_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_x2_multiply_32f_d(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_32f_x2_multiply_32f_a(cVector, aVector, bVector, num_points);
    }
    else{
        volk_32f_x2_multiply_32f_u(cVector, aVector, bVector, num_points);
    }
}

static inline void __init_volk_32f_x2_multiply_32f(void)
{
    const char *name = get_machine()->volk_32f_x2_multiply_32f_name;
    const char **impl_names = get_machine()->volk_32f_x2_multiply_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_multiply_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_multiply_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_multiply_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_x2_multiply_32f_a = get_machine()->volk_32f_x2_multiply_32f_impls[index_a];
    volk_32f_x2_multiply_32f_u = get_machine()->volk_32f_x2_multiply_32f_impls[index_u];

    assert(volk_32f_x2_multiply_32f_a);
    assert(volk_32f_x2_multiply_32f_u);

    volk_32f_x2_multiply_32f = &__volk_32f_x2_multiply_32f_d;
}

static inline void __volk_32f_x2_multiply_32f_a(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32f_x2_multiply_32f();
    volk_32f_x2_multiply_32f_a(cVector, aVector, bVector, num_points);
}

static inline void __volk_32f_x2_multiply_32f_u(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32f_x2_multiply_32f();
    volk_32f_x2_multiply_32f_u(cVector, aVector, bVector, num_points);
}

static inline void __volk_32f_x2_multiply_32f(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32f_x2_multiply_32f();
    volk_32f_x2_multiply_32f(cVector, aVector, bVector, num_points);
}

p_32f_x2_multiply_32f volk_32f_x2_multiply_32f_a = &__volk_32f_x2_multiply_32f_a;
p_32f_x2_multiply_32f volk_32f_x2_multiply_32f_u = &__volk_32f_x2_multiply_32f_u;
p_32f_x2_multiply_32f volk_32f_x2_multiply_32f   = &__volk_32f_x2_multiply_32f;

void volk_32f_x2_multiply_32f_manual(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_x2_multiply_32f_impl_names,
        get_machine()->volk_32f_x2_multiply_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_x2_multiply_32f_impls[index](
        cVector, aVector, bVector, num_points
    );
}

volk_func_desc_t volk_32f_x2_multiply_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_x2_multiply_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_multiply_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_multiply_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_multiply_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_x2_pow_32f_d(float*  cVector, const float*  bVector, const float*  aVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(bVector,
        VOLK_OR_PTR(aVector,
        0)))
    )){
        volk_32f_x2_pow_32f_a(cVector, bVector, aVector, num_points);
    }
    else{
        volk_32f_x2_pow_32f_u(cVector, bVector, aVector, num_points);
    }
}

static inline void __init_volk_32f_x2_pow_32f(void)
{
    const char *name = get_machine()->volk_32f_x2_pow_32f_name;
    const char **impl_names = get_machine()->volk_32f_x2_pow_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_pow_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_pow_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_pow_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_x2_pow_32f_a = get_machine()->volk_32f_x2_pow_32f_impls[index_a];
    volk_32f_x2_pow_32f_u = get_machine()->volk_32f_x2_pow_32f_impls[index_u];

    assert(volk_32f_x2_pow_32f_a);
    assert(volk_32f_x2_pow_32f_u);

    volk_32f_x2_pow_32f = &__volk_32f_x2_pow_32f_d;
}

static inline void __volk_32f_x2_pow_32f_a(float*  cVector, const float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_x2_pow_32f();
    volk_32f_x2_pow_32f_a(cVector, bVector, aVector, num_points);
}

static inline void __volk_32f_x2_pow_32f_u(float*  cVector, const float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_x2_pow_32f();
    volk_32f_x2_pow_32f_u(cVector, bVector, aVector, num_points);
}

static inline void __volk_32f_x2_pow_32f(float*  cVector, const float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_x2_pow_32f();
    volk_32f_x2_pow_32f(cVector, bVector, aVector, num_points);
}

p_32f_x2_pow_32f volk_32f_x2_pow_32f_a = &__volk_32f_x2_pow_32f_a;
p_32f_x2_pow_32f volk_32f_x2_pow_32f_u = &__volk_32f_x2_pow_32f_u;
p_32f_x2_pow_32f volk_32f_x2_pow_32f   = &__volk_32f_x2_pow_32f;

void volk_32f_x2_pow_32f_manual(float*  cVector, const float*  bVector, const float*  aVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_x2_pow_32f_impl_names,
        get_machine()->volk_32f_x2_pow_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_x2_pow_32f_impls[index](
        cVector, bVector, aVector, num_points
    );
}

volk_func_desc_t volk_32f_x2_pow_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_x2_pow_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_pow_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_pow_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_pow_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_x2_powpuppet_32f_d(float*  cVector, const float*  bVector, const float*  aVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(bVector,
        VOLK_OR_PTR(aVector,
        0)))
    )){
        volk_32f_x2_powpuppet_32f_a(cVector, bVector, aVector, num_points);
    }
    else{
        volk_32f_x2_powpuppet_32f_u(cVector, bVector, aVector, num_points);
    }
}

static inline void __init_volk_32f_x2_powpuppet_32f(void)
{
    const char *name = get_machine()->volk_32f_x2_powpuppet_32f_name;
    const char **impl_names = get_machine()->volk_32f_x2_powpuppet_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_powpuppet_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_powpuppet_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_powpuppet_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_x2_powpuppet_32f_a = get_machine()->volk_32f_x2_powpuppet_32f_impls[index_a];
    volk_32f_x2_powpuppet_32f_u = get_machine()->volk_32f_x2_powpuppet_32f_impls[index_u];

    assert(volk_32f_x2_powpuppet_32f_a);
    assert(volk_32f_x2_powpuppet_32f_u);

    volk_32f_x2_powpuppet_32f = &__volk_32f_x2_powpuppet_32f_d;
}

static inline void __volk_32f_x2_powpuppet_32f_a(float*  cVector, const float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_x2_powpuppet_32f();
    volk_32f_x2_powpuppet_32f_a(cVector, bVector, aVector, num_points);
}

static inline void __volk_32f_x2_powpuppet_32f_u(float*  cVector, const float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_x2_powpuppet_32f();
    volk_32f_x2_powpuppet_32f_u(cVector, bVector, aVector, num_points);
}

static inline void __volk_32f_x2_powpuppet_32f(float*  cVector, const float*  bVector, const float*  aVector, unsigned int  num_points)
{
    __init_volk_32f_x2_powpuppet_32f();
    volk_32f_x2_powpuppet_32f(cVector, bVector, aVector, num_points);
}

p_32f_x2_powpuppet_32f volk_32f_x2_powpuppet_32f_a = &__volk_32f_x2_powpuppet_32f_a;
p_32f_x2_powpuppet_32f volk_32f_x2_powpuppet_32f_u = &__volk_32f_x2_powpuppet_32f_u;
p_32f_x2_powpuppet_32f volk_32f_x2_powpuppet_32f   = &__volk_32f_x2_powpuppet_32f;

void volk_32f_x2_powpuppet_32f_manual(float*  cVector, const float*  bVector, const float*  aVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_x2_powpuppet_32f_impl_names,
        get_machine()->volk_32f_x2_powpuppet_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_x2_powpuppet_32f_impls[index](
        cVector, bVector, aVector, num_points
    );
}

volk_func_desc_t volk_32f_x2_powpuppet_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_x2_powpuppet_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_powpuppet_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_powpuppet_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_powpuppet_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_x2_s32f_interleave_16ic_d(lv_16sc_t*  complexVector, const float*  iBuffer, const float*  qBuffer, const float  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(complexVector,
        VOLK_OR_PTR(iBuffer,
        VOLK_OR_PTR(qBuffer,
        0)))
    )){
        volk_32f_x2_s32f_interleave_16ic_a(complexVector, iBuffer, qBuffer, scalar, num_points);
    }
    else{
        volk_32f_x2_s32f_interleave_16ic_u(complexVector, iBuffer, qBuffer, scalar, num_points);
    }
}

static inline void __init_volk_32f_x2_s32f_interleave_16ic(void)
{
    const char *name = get_machine()->volk_32f_x2_s32f_interleave_16ic_name;
    const char **impl_names = get_machine()->volk_32f_x2_s32f_interleave_16ic_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_s32f_interleave_16ic_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_s32f_interleave_16ic_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_s32f_interleave_16ic_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_x2_s32f_interleave_16ic_a = get_machine()->volk_32f_x2_s32f_interleave_16ic_impls[index_a];
    volk_32f_x2_s32f_interleave_16ic_u = get_machine()->volk_32f_x2_s32f_interleave_16ic_impls[index_u];

    assert(volk_32f_x2_s32f_interleave_16ic_a);
    assert(volk_32f_x2_s32f_interleave_16ic_u);

    volk_32f_x2_s32f_interleave_16ic = &__volk_32f_x2_s32f_interleave_16ic_d;
}

static inline void __volk_32f_x2_s32f_interleave_16ic_a(lv_16sc_t*  complexVector, const float*  iBuffer, const float*  qBuffer, const float  scalar, unsigned int  num_points)
{
    __init_volk_32f_x2_s32f_interleave_16ic();
    volk_32f_x2_s32f_interleave_16ic_a(complexVector, iBuffer, qBuffer, scalar, num_points);
}

static inline void __volk_32f_x2_s32f_interleave_16ic_u(lv_16sc_t*  complexVector, const float*  iBuffer, const float*  qBuffer, const float  scalar, unsigned int  num_points)
{
    __init_volk_32f_x2_s32f_interleave_16ic();
    volk_32f_x2_s32f_interleave_16ic_u(complexVector, iBuffer, qBuffer, scalar, num_points);
}

static inline void __volk_32f_x2_s32f_interleave_16ic(lv_16sc_t*  complexVector, const float*  iBuffer, const float*  qBuffer, const float  scalar, unsigned int  num_points)
{
    __init_volk_32f_x2_s32f_interleave_16ic();
    volk_32f_x2_s32f_interleave_16ic(complexVector, iBuffer, qBuffer, scalar, num_points);
}

p_32f_x2_s32f_interleave_16ic volk_32f_x2_s32f_interleave_16ic_a = &__volk_32f_x2_s32f_interleave_16ic_a;
p_32f_x2_s32f_interleave_16ic volk_32f_x2_s32f_interleave_16ic_u = &__volk_32f_x2_s32f_interleave_16ic_u;
p_32f_x2_s32f_interleave_16ic volk_32f_x2_s32f_interleave_16ic   = &__volk_32f_x2_s32f_interleave_16ic;

void volk_32f_x2_s32f_interleave_16ic_manual(lv_16sc_t*  complexVector, const float*  iBuffer, const float*  qBuffer, const float  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_x2_s32f_interleave_16ic_impl_names,
        get_machine()->volk_32f_x2_s32f_interleave_16ic_n_impls,
        impl_name
    );
    get_machine()->volk_32f_x2_s32f_interleave_16ic_impls[index](
        complexVector, iBuffer, qBuffer, scalar, num_points
    );
}

volk_func_desc_t volk_32f_x2_s32f_interleave_16ic_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_x2_s32f_interleave_16ic_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_s32f_interleave_16ic_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_s32f_interleave_16ic_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_s32f_interleave_16ic_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_x2_subtract_32f_d(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_32f_x2_subtract_32f_a(cVector, aVector, bVector, num_points);
    }
    else{
        volk_32f_x2_subtract_32f_u(cVector, aVector, bVector, num_points);
    }
}

static inline void __init_volk_32f_x2_subtract_32f(void)
{
    const char *name = get_machine()->volk_32f_x2_subtract_32f_name;
    const char **impl_names = get_machine()->volk_32f_x2_subtract_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_subtract_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_subtract_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_subtract_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_x2_subtract_32f_a = get_machine()->volk_32f_x2_subtract_32f_impls[index_a];
    volk_32f_x2_subtract_32f_u = get_machine()->volk_32f_x2_subtract_32f_impls[index_u];

    assert(volk_32f_x2_subtract_32f_a);
    assert(volk_32f_x2_subtract_32f_u);

    volk_32f_x2_subtract_32f = &__volk_32f_x2_subtract_32f_d;
}

static inline void __volk_32f_x2_subtract_32f_a(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32f_x2_subtract_32f();
    volk_32f_x2_subtract_32f_a(cVector, aVector, bVector, num_points);
}

static inline void __volk_32f_x2_subtract_32f_u(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32f_x2_subtract_32f();
    volk_32f_x2_subtract_32f_u(cVector, aVector, bVector, num_points);
}

static inline void __volk_32f_x2_subtract_32f(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32f_x2_subtract_32f();
    volk_32f_x2_subtract_32f(cVector, aVector, bVector, num_points);
}

p_32f_x2_subtract_32f volk_32f_x2_subtract_32f_a = &__volk_32f_x2_subtract_32f_a;
p_32f_x2_subtract_32f volk_32f_x2_subtract_32f_u = &__volk_32f_x2_subtract_32f_u;
p_32f_x2_subtract_32f volk_32f_x2_subtract_32f   = &__volk_32f_x2_subtract_32f;

void volk_32f_x2_subtract_32f_manual(float*  cVector, const float*  aVector, const float*  bVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_x2_subtract_32f_impl_names,
        get_machine()->volk_32f_x2_subtract_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_x2_subtract_32f_impls[index](
        cVector, aVector, bVector, num_points
    );
}

volk_func_desc_t volk_32f_x2_subtract_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_x2_subtract_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x2_subtract_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x2_subtract_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x2_subtract_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32f_x3_sum_of_poly_32f_d(float*  target, float*  src0, float*  center_point_array, float*  cutoff, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(target,
        VOLK_OR_PTR(src0,
        VOLK_OR_PTR(center_point_array,
        VOLK_OR_PTR(cutoff,
        0))))
    )){
        volk_32f_x3_sum_of_poly_32f_a(target, src0, center_point_array, cutoff, num_points);
    }
    else{
        volk_32f_x3_sum_of_poly_32f_u(target, src0, center_point_array, cutoff, num_points);
    }
}

static inline void __init_volk_32f_x3_sum_of_poly_32f(void)
{
    const char *name = get_machine()->volk_32f_x3_sum_of_poly_32f_name;
    const char **impl_names = get_machine()->volk_32f_x3_sum_of_poly_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x3_sum_of_poly_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x3_sum_of_poly_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x3_sum_of_poly_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32f_x3_sum_of_poly_32f_a = get_machine()->volk_32f_x3_sum_of_poly_32f_impls[index_a];
    volk_32f_x3_sum_of_poly_32f_u = get_machine()->volk_32f_x3_sum_of_poly_32f_impls[index_u];

    assert(volk_32f_x3_sum_of_poly_32f_a);
    assert(volk_32f_x3_sum_of_poly_32f_u);

    volk_32f_x3_sum_of_poly_32f = &__volk_32f_x3_sum_of_poly_32f_d;
}

static inline void __volk_32f_x3_sum_of_poly_32f_a(float*  target, float*  src0, float*  center_point_array, float*  cutoff, unsigned int  num_points)
{
    __init_volk_32f_x3_sum_of_poly_32f();
    volk_32f_x3_sum_of_poly_32f_a(target, src0, center_point_array, cutoff, num_points);
}

static inline void __volk_32f_x3_sum_of_poly_32f_u(float*  target, float*  src0, float*  center_point_array, float*  cutoff, unsigned int  num_points)
{
    __init_volk_32f_x3_sum_of_poly_32f();
    volk_32f_x3_sum_of_poly_32f_u(target, src0, center_point_array, cutoff, num_points);
}

static inline void __volk_32f_x3_sum_of_poly_32f(float*  target, float*  src0, float*  center_point_array, float*  cutoff, unsigned int  num_points)
{
    __init_volk_32f_x3_sum_of_poly_32f();
    volk_32f_x3_sum_of_poly_32f(target, src0, center_point_array, cutoff, num_points);
}

p_32f_x3_sum_of_poly_32f volk_32f_x3_sum_of_poly_32f_a = &__volk_32f_x3_sum_of_poly_32f_a;
p_32f_x3_sum_of_poly_32f volk_32f_x3_sum_of_poly_32f_u = &__volk_32f_x3_sum_of_poly_32f_u;
p_32f_x3_sum_of_poly_32f volk_32f_x3_sum_of_poly_32f   = &__volk_32f_x3_sum_of_poly_32f;

void volk_32f_x3_sum_of_poly_32f_manual(float*  target, float*  src0, float*  center_point_array, float*  cutoff, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32f_x3_sum_of_poly_32f_impl_names,
        get_machine()->volk_32f_x3_sum_of_poly_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32f_x3_sum_of_poly_32f_impls[index](
        target, src0, center_point_array, cutoff, num_points
    );
}

volk_func_desc_t volk_32f_x3_sum_of_poly_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32f_x3_sum_of_poly_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32f_x3_sum_of_poly_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32f_x3_sum_of_poly_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32f_x3_sum_of_poly_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_32f_add_32fc_d(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const float*  bVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_32fc_32f_add_32fc_a(cVector, aVector, bVector, num_points);
    }
    else{
        volk_32fc_32f_add_32fc_u(cVector, aVector, bVector, num_points);
    }
}

static inline void __init_volk_32fc_32f_add_32fc(void)
{
    const char *name = get_machine()->volk_32fc_32f_add_32fc_name;
    const char **impl_names = get_machine()->volk_32fc_32f_add_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_32f_add_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_32f_add_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_32f_add_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_32f_add_32fc_a = get_machine()->volk_32fc_32f_add_32fc_impls[index_a];
    volk_32fc_32f_add_32fc_u = get_machine()->volk_32fc_32f_add_32fc_impls[index_u];

    assert(volk_32fc_32f_add_32fc_a);
    assert(volk_32fc_32f_add_32fc_u);

    volk_32fc_32f_add_32fc = &__volk_32fc_32f_add_32fc_d;
}

static inline void __volk_32fc_32f_add_32fc_a(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32fc_32f_add_32fc();
    volk_32fc_32f_add_32fc_a(cVector, aVector, bVector, num_points);
}

static inline void __volk_32fc_32f_add_32fc_u(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32fc_32f_add_32fc();
    volk_32fc_32f_add_32fc_u(cVector, aVector, bVector, num_points);
}

static inline void __volk_32fc_32f_add_32fc(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32fc_32f_add_32fc();
    volk_32fc_32f_add_32fc(cVector, aVector, bVector, num_points);
}

p_32fc_32f_add_32fc volk_32fc_32f_add_32fc_a = &__volk_32fc_32f_add_32fc_a;
p_32fc_32f_add_32fc volk_32fc_32f_add_32fc_u = &__volk_32fc_32f_add_32fc_u;
p_32fc_32f_add_32fc volk_32fc_32f_add_32fc   = &__volk_32fc_32f_add_32fc;

void volk_32fc_32f_add_32fc_manual(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const float*  bVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_32f_add_32fc_impl_names,
        get_machine()->volk_32fc_32f_add_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_32f_add_32fc_impls[index](
        cVector, aVector, bVector, num_points
    );
}

volk_func_desc_t volk_32fc_32f_add_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_32f_add_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_32f_add_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_32f_add_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_32f_add_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_32f_dot_prod_32fc_d(lv_32fc_t*  result, const lv_32fc_t*  input, const float*  taps, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(result,
        VOLK_OR_PTR(input,
        VOLK_OR_PTR(taps,
        0)))
    )){
        volk_32fc_32f_dot_prod_32fc_a(result, input, taps, num_points);
    }
    else{
        volk_32fc_32f_dot_prod_32fc_u(result, input, taps, num_points);
    }
}

static inline void __init_volk_32fc_32f_dot_prod_32fc(void)
{
    const char *name = get_machine()->volk_32fc_32f_dot_prod_32fc_name;
    const char **impl_names = get_machine()->volk_32fc_32f_dot_prod_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_32f_dot_prod_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_32f_dot_prod_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_32f_dot_prod_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_32f_dot_prod_32fc_a = get_machine()->volk_32fc_32f_dot_prod_32fc_impls[index_a];
    volk_32fc_32f_dot_prod_32fc_u = get_machine()->volk_32fc_32f_dot_prod_32fc_impls[index_u];

    assert(volk_32fc_32f_dot_prod_32fc_a);
    assert(volk_32fc_32f_dot_prod_32fc_u);

    volk_32fc_32f_dot_prod_32fc = &__volk_32fc_32f_dot_prod_32fc_d;
}

static inline void __volk_32fc_32f_dot_prod_32fc_a(lv_32fc_t*  result, const lv_32fc_t*  input, const float*  taps, unsigned int  num_points)
{
    __init_volk_32fc_32f_dot_prod_32fc();
    volk_32fc_32f_dot_prod_32fc_a(result, input, taps, num_points);
}

static inline void __volk_32fc_32f_dot_prod_32fc_u(lv_32fc_t*  result, const lv_32fc_t*  input, const float*  taps, unsigned int  num_points)
{
    __init_volk_32fc_32f_dot_prod_32fc();
    volk_32fc_32f_dot_prod_32fc_u(result, input, taps, num_points);
}

static inline void __volk_32fc_32f_dot_prod_32fc(lv_32fc_t*  result, const lv_32fc_t*  input, const float*  taps, unsigned int  num_points)
{
    __init_volk_32fc_32f_dot_prod_32fc();
    volk_32fc_32f_dot_prod_32fc(result, input, taps, num_points);
}

p_32fc_32f_dot_prod_32fc volk_32fc_32f_dot_prod_32fc_a = &__volk_32fc_32f_dot_prod_32fc_a;
p_32fc_32f_dot_prod_32fc volk_32fc_32f_dot_prod_32fc_u = &__volk_32fc_32f_dot_prod_32fc_u;
p_32fc_32f_dot_prod_32fc volk_32fc_32f_dot_prod_32fc   = &__volk_32fc_32f_dot_prod_32fc;

void volk_32fc_32f_dot_prod_32fc_manual(lv_32fc_t*  result, const lv_32fc_t*  input, const float*  taps, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_32f_dot_prod_32fc_impl_names,
        get_machine()->volk_32fc_32f_dot_prod_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_32f_dot_prod_32fc_impls[index](
        result, input, taps, num_points
    );
}

volk_func_desc_t volk_32fc_32f_dot_prod_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_32f_dot_prod_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_32f_dot_prod_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_32f_dot_prod_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_32f_dot_prod_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_32f_multiply_32fc_d(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const float*  bVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_32fc_32f_multiply_32fc_a(cVector, aVector, bVector, num_points);
    }
    else{
        volk_32fc_32f_multiply_32fc_u(cVector, aVector, bVector, num_points);
    }
}

static inline void __init_volk_32fc_32f_multiply_32fc(void)
{
    const char *name = get_machine()->volk_32fc_32f_multiply_32fc_name;
    const char **impl_names = get_machine()->volk_32fc_32f_multiply_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_32f_multiply_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_32f_multiply_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_32f_multiply_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_32f_multiply_32fc_a = get_machine()->volk_32fc_32f_multiply_32fc_impls[index_a];
    volk_32fc_32f_multiply_32fc_u = get_machine()->volk_32fc_32f_multiply_32fc_impls[index_u];

    assert(volk_32fc_32f_multiply_32fc_a);
    assert(volk_32fc_32f_multiply_32fc_u);

    volk_32fc_32f_multiply_32fc = &__volk_32fc_32f_multiply_32fc_d;
}

static inline void __volk_32fc_32f_multiply_32fc_a(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32fc_32f_multiply_32fc();
    volk_32fc_32f_multiply_32fc_a(cVector, aVector, bVector, num_points);
}

static inline void __volk_32fc_32f_multiply_32fc_u(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32fc_32f_multiply_32fc();
    volk_32fc_32f_multiply_32fc_u(cVector, aVector, bVector, num_points);
}

static inline void __volk_32fc_32f_multiply_32fc(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const float*  bVector, unsigned int  num_points)
{
    __init_volk_32fc_32f_multiply_32fc();
    volk_32fc_32f_multiply_32fc(cVector, aVector, bVector, num_points);
}

p_32fc_32f_multiply_32fc volk_32fc_32f_multiply_32fc_a = &__volk_32fc_32f_multiply_32fc_a;
p_32fc_32f_multiply_32fc volk_32fc_32f_multiply_32fc_u = &__volk_32fc_32f_multiply_32fc_u;
p_32fc_32f_multiply_32fc volk_32fc_32f_multiply_32fc   = &__volk_32fc_32f_multiply_32fc;

void volk_32fc_32f_multiply_32fc_manual(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const float*  bVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_32f_multiply_32fc_impl_names,
        get_machine()->volk_32fc_32f_multiply_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_32f_multiply_32fc_impls[index](
        cVector, aVector, bVector, num_points
    );
}

volk_func_desc_t volk_32fc_32f_multiply_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_32f_multiply_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_32f_multiply_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_32f_multiply_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_32f_multiply_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_accumulator_s32fc_d(lv_32fc_t*  result, const lv_32fc_t*  inputBuffer, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(result,
        VOLK_OR_PTR(inputBuffer,
        0))
    )){
        volk_32fc_accumulator_s32fc_a(result, inputBuffer, num_points);
    }
    else{
        volk_32fc_accumulator_s32fc_u(result, inputBuffer, num_points);
    }
}

static inline void __init_volk_32fc_accumulator_s32fc(void)
{
    const char *name = get_machine()->volk_32fc_accumulator_s32fc_name;
    const char **impl_names = get_machine()->volk_32fc_accumulator_s32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_accumulator_s32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_accumulator_s32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_accumulator_s32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_accumulator_s32fc_a = get_machine()->volk_32fc_accumulator_s32fc_impls[index_a];
    volk_32fc_accumulator_s32fc_u = get_machine()->volk_32fc_accumulator_s32fc_impls[index_u];

    assert(volk_32fc_accumulator_s32fc_a);
    assert(volk_32fc_accumulator_s32fc_u);

    volk_32fc_accumulator_s32fc = &__volk_32fc_accumulator_s32fc_d;
}

static inline void __volk_32fc_accumulator_s32fc_a(lv_32fc_t*  result, const lv_32fc_t*  inputBuffer, unsigned int  num_points)
{
    __init_volk_32fc_accumulator_s32fc();
    volk_32fc_accumulator_s32fc_a(result, inputBuffer, num_points);
}

static inline void __volk_32fc_accumulator_s32fc_u(lv_32fc_t*  result, const lv_32fc_t*  inputBuffer, unsigned int  num_points)
{
    __init_volk_32fc_accumulator_s32fc();
    volk_32fc_accumulator_s32fc_u(result, inputBuffer, num_points);
}

static inline void __volk_32fc_accumulator_s32fc(lv_32fc_t*  result, const lv_32fc_t*  inputBuffer, unsigned int  num_points)
{
    __init_volk_32fc_accumulator_s32fc();
    volk_32fc_accumulator_s32fc(result, inputBuffer, num_points);
}

p_32fc_accumulator_s32fc volk_32fc_accumulator_s32fc_a = &__volk_32fc_accumulator_s32fc_a;
p_32fc_accumulator_s32fc volk_32fc_accumulator_s32fc_u = &__volk_32fc_accumulator_s32fc_u;
p_32fc_accumulator_s32fc volk_32fc_accumulator_s32fc   = &__volk_32fc_accumulator_s32fc;

void volk_32fc_accumulator_s32fc_manual(lv_32fc_t*  result, const lv_32fc_t*  inputBuffer, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_accumulator_s32fc_impl_names,
        get_machine()->volk_32fc_accumulator_s32fc_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_accumulator_s32fc_impls[index](
        result, inputBuffer, num_points
    );
}

volk_func_desc_t volk_32fc_accumulator_s32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_accumulator_s32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_accumulator_s32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_accumulator_s32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_accumulator_s32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_conjugate_32fc_d(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        0))
    )){
        volk_32fc_conjugate_32fc_a(cVector, aVector, num_points);
    }
    else{
        volk_32fc_conjugate_32fc_u(cVector, aVector, num_points);
    }
}

static inline void __init_volk_32fc_conjugate_32fc(void)
{
    const char *name = get_machine()->volk_32fc_conjugate_32fc_name;
    const char **impl_names = get_machine()->volk_32fc_conjugate_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_conjugate_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_conjugate_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_conjugate_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_conjugate_32fc_a = get_machine()->volk_32fc_conjugate_32fc_impls[index_a];
    volk_32fc_conjugate_32fc_u = get_machine()->volk_32fc_conjugate_32fc_impls[index_u];

    assert(volk_32fc_conjugate_32fc_a);
    assert(volk_32fc_conjugate_32fc_u);

    volk_32fc_conjugate_32fc = &__volk_32fc_conjugate_32fc_d;
}

static inline void __volk_32fc_conjugate_32fc_a(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, unsigned int  num_points)
{
    __init_volk_32fc_conjugate_32fc();
    volk_32fc_conjugate_32fc_a(cVector, aVector, num_points);
}

static inline void __volk_32fc_conjugate_32fc_u(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, unsigned int  num_points)
{
    __init_volk_32fc_conjugate_32fc();
    volk_32fc_conjugate_32fc_u(cVector, aVector, num_points);
}

static inline void __volk_32fc_conjugate_32fc(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, unsigned int  num_points)
{
    __init_volk_32fc_conjugate_32fc();
    volk_32fc_conjugate_32fc(cVector, aVector, num_points);
}

p_32fc_conjugate_32fc volk_32fc_conjugate_32fc_a = &__volk_32fc_conjugate_32fc_a;
p_32fc_conjugate_32fc volk_32fc_conjugate_32fc_u = &__volk_32fc_conjugate_32fc_u;
p_32fc_conjugate_32fc volk_32fc_conjugate_32fc   = &__volk_32fc_conjugate_32fc;

void volk_32fc_conjugate_32fc_manual(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_conjugate_32fc_impl_names,
        get_machine()->volk_32fc_conjugate_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_conjugate_32fc_impls[index](
        cVector, aVector, num_points
    );
}

volk_func_desc_t volk_32fc_conjugate_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_conjugate_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_conjugate_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_conjugate_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_conjugate_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_convert_16ic_d(lv_16sc_t*  outputVector, const lv_32fc_t*  inputVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outputVector,
        VOLK_OR_PTR(inputVector,
        0))
    )){
        volk_32fc_convert_16ic_a(outputVector, inputVector, num_points);
    }
    else{
        volk_32fc_convert_16ic_u(outputVector, inputVector, num_points);
    }
}

static inline void __init_volk_32fc_convert_16ic(void)
{
    const char *name = get_machine()->volk_32fc_convert_16ic_name;
    const char **impl_names = get_machine()->volk_32fc_convert_16ic_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_convert_16ic_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_convert_16ic_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_convert_16ic_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_convert_16ic_a = get_machine()->volk_32fc_convert_16ic_impls[index_a];
    volk_32fc_convert_16ic_u = get_machine()->volk_32fc_convert_16ic_impls[index_u];

    assert(volk_32fc_convert_16ic_a);
    assert(volk_32fc_convert_16ic_u);

    volk_32fc_convert_16ic = &__volk_32fc_convert_16ic_d;
}

static inline void __volk_32fc_convert_16ic_a(lv_16sc_t*  outputVector, const lv_32fc_t*  inputVector, unsigned int  num_points)
{
    __init_volk_32fc_convert_16ic();
    volk_32fc_convert_16ic_a(outputVector, inputVector, num_points);
}

static inline void __volk_32fc_convert_16ic_u(lv_16sc_t*  outputVector, const lv_32fc_t*  inputVector, unsigned int  num_points)
{
    __init_volk_32fc_convert_16ic();
    volk_32fc_convert_16ic_u(outputVector, inputVector, num_points);
}

static inline void __volk_32fc_convert_16ic(lv_16sc_t*  outputVector, const lv_32fc_t*  inputVector, unsigned int  num_points)
{
    __init_volk_32fc_convert_16ic();
    volk_32fc_convert_16ic(outputVector, inputVector, num_points);
}

p_32fc_convert_16ic volk_32fc_convert_16ic_a = &__volk_32fc_convert_16ic_a;
p_32fc_convert_16ic volk_32fc_convert_16ic_u = &__volk_32fc_convert_16ic_u;
p_32fc_convert_16ic volk_32fc_convert_16ic   = &__volk_32fc_convert_16ic;

void volk_32fc_convert_16ic_manual(lv_16sc_t*  outputVector, const lv_32fc_t*  inputVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_convert_16ic_impl_names,
        get_machine()->volk_32fc_convert_16ic_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_convert_16ic_impls[index](
        outputVector, inputVector, num_points
    );
}

volk_func_desc_t volk_32fc_convert_16ic_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_convert_16ic_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_convert_16ic_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_convert_16ic_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_convert_16ic_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_deinterleave_32f_x2_d(float*  iBuffer, float*  qBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(iBuffer,
        VOLK_OR_PTR(qBuffer,
        VOLK_OR_PTR(complexVector,
        0)))
    )){
        volk_32fc_deinterleave_32f_x2_a(iBuffer, qBuffer, complexVector, num_points);
    }
    else{
        volk_32fc_deinterleave_32f_x2_u(iBuffer, qBuffer, complexVector, num_points);
    }
}

static inline void __init_volk_32fc_deinterleave_32f_x2(void)
{
    const char *name = get_machine()->volk_32fc_deinterleave_32f_x2_name;
    const char **impl_names = get_machine()->volk_32fc_deinterleave_32f_x2_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_deinterleave_32f_x2_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_deinterleave_32f_x2_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_deinterleave_32f_x2_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_deinterleave_32f_x2_a = get_machine()->volk_32fc_deinterleave_32f_x2_impls[index_a];
    volk_32fc_deinterleave_32f_x2_u = get_machine()->volk_32fc_deinterleave_32f_x2_impls[index_u];

    assert(volk_32fc_deinterleave_32f_x2_a);
    assert(volk_32fc_deinterleave_32f_x2_u);

    volk_32fc_deinterleave_32f_x2 = &__volk_32fc_deinterleave_32f_x2_d;
}

static inline void __volk_32fc_deinterleave_32f_x2_a(float*  iBuffer, float*  qBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_32fc_deinterleave_32f_x2();
    volk_32fc_deinterleave_32f_x2_a(iBuffer, qBuffer, complexVector, num_points);
}

static inline void __volk_32fc_deinterleave_32f_x2_u(float*  iBuffer, float*  qBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_32fc_deinterleave_32f_x2();
    volk_32fc_deinterleave_32f_x2_u(iBuffer, qBuffer, complexVector, num_points);
}

static inline void __volk_32fc_deinterleave_32f_x2(float*  iBuffer, float*  qBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_32fc_deinterleave_32f_x2();
    volk_32fc_deinterleave_32f_x2(iBuffer, qBuffer, complexVector, num_points);
}

p_32fc_deinterleave_32f_x2 volk_32fc_deinterleave_32f_x2_a = &__volk_32fc_deinterleave_32f_x2_a;
p_32fc_deinterleave_32f_x2 volk_32fc_deinterleave_32f_x2_u = &__volk_32fc_deinterleave_32f_x2_u;
p_32fc_deinterleave_32f_x2 volk_32fc_deinterleave_32f_x2   = &__volk_32fc_deinterleave_32f_x2;

void volk_32fc_deinterleave_32f_x2_manual(float*  iBuffer, float*  qBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_deinterleave_32f_x2_impl_names,
        get_machine()->volk_32fc_deinterleave_32f_x2_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_deinterleave_32f_x2_impls[index](
        iBuffer, qBuffer, complexVector, num_points
    );
}

volk_func_desc_t volk_32fc_deinterleave_32f_x2_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_deinterleave_32f_x2_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_deinterleave_32f_x2_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_deinterleave_32f_x2_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_deinterleave_32f_x2_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_deinterleave_64f_x2_d(double*  iBuffer, double*  qBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(iBuffer,
        VOLK_OR_PTR(qBuffer,
        VOLK_OR_PTR(complexVector,
        0)))
    )){
        volk_32fc_deinterleave_64f_x2_a(iBuffer, qBuffer, complexVector, num_points);
    }
    else{
        volk_32fc_deinterleave_64f_x2_u(iBuffer, qBuffer, complexVector, num_points);
    }
}

static inline void __init_volk_32fc_deinterleave_64f_x2(void)
{
    const char *name = get_machine()->volk_32fc_deinterleave_64f_x2_name;
    const char **impl_names = get_machine()->volk_32fc_deinterleave_64f_x2_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_deinterleave_64f_x2_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_deinterleave_64f_x2_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_deinterleave_64f_x2_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_deinterleave_64f_x2_a = get_machine()->volk_32fc_deinterleave_64f_x2_impls[index_a];
    volk_32fc_deinterleave_64f_x2_u = get_machine()->volk_32fc_deinterleave_64f_x2_impls[index_u];

    assert(volk_32fc_deinterleave_64f_x2_a);
    assert(volk_32fc_deinterleave_64f_x2_u);

    volk_32fc_deinterleave_64f_x2 = &__volk_32fc_deinterleave_64f_x2_d;
}

static inline void __volk_32fc_deinterleave_64f_x2_a(double*  iBuffer, double*  qBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_32fc_deinterleave_64f_x2();
    volk_32fc_deinterleave_64f_x2_a(iBuffer, qBuffer, complexVector, num_points);
}

static inline void __volk_32fc_deinterleave_64f_x2_u(double*  iBuffer, double*  qBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_32fc_deinterleave_64f_x2();
    volk_32fc_deinterleave_64f_x2_u(iBuffer, qBuffer, complexVector, num_points);
}

static inline void __volk_32fc_deinterleave_64f_x2(double*  iBuffer, double*  qBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_32fc_deinterleave_64f_x2();
    volk_32fc_deinterleave_64f_x2(iBuffer, qBuffer, complexVector, num_points);
}

p_32fc_deinterleave_64f_x2 volk_32fc_deinterleave_64f_x2_a = &__volk_32fc_deinterleave_64f_x2_a;
p_32fc_deinterleave_64f_x2 volk_32fc_deinterleave_64f_x2_u = &__volk_32fc_deinterleave_64f_x2_u;
p_32fc_deinterleave_64f_x2 volk_32fc_deinterleave_64f_x2   = &__volk_32fc_deinterleave_64f_x2;

void volk_32fc_deinterleave_64f_x2_manual(double*  iBuffer, double*  qBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_deinterleave_64f_x2_impl_names,
        get_machine()->volk_32fc_deinterleave_64f_x2_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_deinterleave_64f_x2_impls[index](
        iBuffer, qBuffer, complexVector, num_points
    );
}

volk_func_desc_t volk_32fc_deinterleave_64f_x2_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_deinterleave_64f_x2_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_deinterleave_64f_x2_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_deinterleave_64f_x2_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_deinterleave_64f_x2_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_deinterleave_imag_32f_d(float*  qBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(qBuffer,
        VOLK_OR_PTR(complexVector,
        0))
    )){
        volk_32fc_deinterleave_imag_32f_a(qBuffer, complexVector, num_points);
    }
    else{
        volk_32fc_deinterleave_imag_32f_u(qBuffer, complexVector, num_points);
    }
}

static inline void __init_volk_32fc_deinterleave_imag_32f(void)
{
    const char *name = get_machine()->volk_32fc_deinterleave_imag_32f_name;
    const char **impl_names = get_machine()->volk_32fc_deinterleave_imag_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_deinterleave_imag_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_deinterleave_imag_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_deinterleave_imag_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_deinterleave_imag_32f_a = get_machine()->volk_32fc_deinterleave_imag_32f_impls[index_a];
    volk_32fc_deinterleave_imag_32f_u = get_machine()->volk_32fc_deinterleave_imag_32f_impls[index_u];

    assert(volk_32fc_deinterleave_imag_32f_a);
    assert(volk_32fc_deinterleave_imag_32f_u);

    volk_32fc_deinterleave_imag_32f = &__volk_32fc_deinterleave_imag_32f_d;
}

static inline void __volk_32fc_deinterleave_imag_32f_a(float*  qBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_32fc_deinterleave_imag_32f();
    volk_32fc_deinterleave_imag_32f_a(qBuffer, complexVector, num_points);
}

static inline void __volk_32fc_deinterleave_imag_32f_u(float*  qBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_32fc_deinterleave_imag_32f();
    volk_32fc_deinterleave_imag_32f_u(qBuffer, complexVector, num_points);
}

static inline void __volk_32fc_deinterleave_imag_32f(float*  qBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_32fc_deinterleave_imag_32f();
    volk_32fc_deinterleave_imag_32f(qBuffer, complexVector, num_points);
}

p_32fc_deinterleave_imag_32f volk_32fc_deinterleave_imag_32f_a = &__volk_32fc_deinterleave_imag_32f_a;
p_32fc_deinterleave_imag_32f volk_32fc_deinterleave_imag_32f_u = &__volk_32fc_deinterleave_imag_32f_u;
p_32fc_deinterleave_imag_32f volk_32fc_deinterleave_imag_32f   = &__volk_32fc_deinterleave_imag_32f;

void volk_32fc_deinterleave_imag_32f_manual(float*  qBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_deinterleave_imag_32f_impl_names,
        get_machine()->volk_32fc_deinterleave_imag_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_deinterleave_imag_32f_impls[index](
        qBuffer, complexVector, num_points
    );
}

volk_func_desc_t volk_32fc_deinterleave_imag_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_deinterleave_imag_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_deinterleave_imag_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_deinterleave_imag_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_deinterleave_imag_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_deinterleave_real_32f_d(float*  iBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(iBuffer,
        VOLK_OR_PTR(complexVector,
        0))
    )){
        volk_32fc_deinterleave_real_32f_a(iBuffer, complexVector, num_points);
    }
    else{
        volk_32fc_deinterleave_real_32f_u(iBuffer, complexVector, num_points);
    }
}

static inline void __init_volk_32fc_deinterleave_real_32f(void)
{
    const char *name = get_machine()->volk_32fc_deinterleave_real_32f_name;
    const char **impl_names = get_machine()->volk_32fc_deinterleave_real_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_deinterleave_real_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_deinterleave_real_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_deinterleave_real_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_deinterleave_real_32f_a = get_machine()->volk_32fc_deinterleave_real_32f_impls[index_a];
    volk_32fc_deinterleave_real_32f_u = get_machine()->volk_32fc_deinterleave_real_32f_impls[index_u];

    assert(volk_32fc_deinterleave_real_32f_a);
    assert(volk_32fc_deinterleave_real_32f_u);

    volk_32fc_deinterleave_real_32f = &__volk_32fc_deinterleave_real_32f_d;
}

static inline void __volk_32fc_deinterleave_real_32f_a(float*  iBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_32fc_deinterleave_real_32f();
    volk_32fc_deinterleave_real_32f_a(iBuffer, complexVector, num_points);
}

static inline void __volk_32fc_deinterleave_real_32f_u(float*  iBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_32fc_deinterleave_real_32f();
    volk_32fc_deinterleave_real_32f_u(iBuffer, complexVector, num_points);
}

static inline void __volk_32fc_deinterleave_real_32f(float*  iBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_32fc_deinterleave_real_32f();
    volk_32fc_deinterleave_real_32f(iBuffer, complexVector, num_points);
}

p_32fc_deinterleave_real_32f volk_32fc_deinterleave_real_32f_a = &__volk_32fc_deinterleave_real_32f_a;
p_32fc_deinterleave_real_32f volk_32fc_deinterleave_real_32f_u = &__volk_32fc_deinterleave_real_32f_u;
p_32fc_deinterleave_real_32f volk_32fc_deinterleave_real_32f   = &__volk_32fc_deinterleave_real_32f;

void volk_32fc_deinterleave_real_32f_manual(float*  iBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_deinterleave_real_32f_impl_names,
        get_machine()->volk_32fc_deinterleave_real_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_deinterleave_real_32f_impls[index](
        iBuffer, complexVector, num_points
    );
}

volk_func_desc_t volk_32fc_deinterleave_real_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_deinterleave_real_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_deinterleave_real_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_deinterleave_real_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_deinterleave_real_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_deinterleave_real_64f_d(double*  iBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(iBuffer,
        VOLK_OR_PTR(complexVector,
        0))
    )){
        volk_32fc_deinterleave_real_64f_a(iBuffer, complexVector, num_points);
    }
    else{
        volk_32fc_deinterleave_real_64f_u(iBuffer, complexVector, num_points);
    }
}

static inline void __init_volk_32fc_deinterleave_real_64f(void)
{
    const char *name = get_machine()->volk_32fc_deinterleave_real_64f_name;
    const char **impl_names = get_machine()->volk_32fc_deinterleave_real_64f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_deinterleave_real_64f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_deinterleave_real_64f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_deinterleave_real_64f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_deinterleave_real_64f_a = get_machine()->volk_32fc_deinterleave_real_64f_impls[index_a];
    volk_32fc_deinterleave_real_64f_u = get_machine()->volk_32fc_deinterleave_real_64f_impls[index_u];

    assert(volk_32fc_deinterleave_real_64f_a);
    assert(volk_32fc_deinterleave_real_64f_u);

    volk_32fc_deinterleave_real_64f = &__volk_32fc_deinterleave_real_64f_d;
}

static inline void __volk_32fc_deinterleave_real_64f_a(double*  iBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_32fc_deinterleave_real_64f();
    volk_32fc_deinterleave_real_64f_a(iBuffer, complexVector, num_points);
}

static inline void __volk_32fc_deinterleave_real_64f_u(double*  iBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_32fc_deinterleave_real_64f();
    volk_32fc_deinterleave_real_64f_u(iBuffer, complexVector, num_points);
}

static inline void __volk_32fc_deinterleave_real_64f(double*  iBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_32fc_deinterleave_real_64f();
    volk_32fc_deinterleave_real_64f(iBuffer, complexVector, num_points);
}

p_32fc_deinterleave_real_64f volk_32fc_deinterleave_real_64f_a = &__volk_32fc_deinterleave_real_64f_a;
p_32fc_deinterleave_real_64f volk_32fc_deinterleave_real_64f_u = &__volk_32fc_deinterleave_real_64f_u;
p_32fc_deinterleave_real_64f volk_32fc_deinterleave_real_64f   = &__volk_32fc_deinterleave_real_64f;

void volk_32fc_deinterleave_real_64f_manual(double*  iBuffer, const lv_32fc_t*  complexVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_deinterleave_real_64f_impl_names,
        get_machine()->volk_32fc_deinterleave_real_64f_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_deinterleave_real_64f_impls[index](
        iBuffer, complexVector, num_points
    );
}

volk_func_desc_t volk_32fc_deinterleave_real_64f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_deinterleave_real_64f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_deinterleave_real_64f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_deinterleave_real_64f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_deinterleave_real_64f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_index_max_16u_d(uint16_t*  target, lv_32fc_t*  src0, uint32_t  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(target,
        VOLK_OR_PTR(src0,
        0))
    )){
        volk_32fc_index_max_16u_a(target, src0, num_points);
    }
    else{
        volk_32fc_index_max_16u_u(target, src0, num_points);
    }
}

static inline void __init_volk_32fc_index_max_16u(void)
{
    const char *name = get_machine()->volk_32fc_index_max_16u_name;
    const char **impl_names = get_machine()->volk_32fc_index_max_16u_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_index_max_16u_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_index_max_16u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_index_max_16u_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_index_max_16u_a = get_machine()->volk_32fc_index_max_16u_impls[index_a];
    volk_32fc_index_max_16u_u = get_machine()->volk_32fc_index_max_16u_impls[index_u];

    assert(volk_32fc_index_max_16u_a);
    assert(volk_32fc_index_max_16u_u);

    volk_32fc_index_max_16u = &__volk_32fc_index_max_16u_d;
}

static inline void __volk_32fc_index_max_16u_a(uint16_t*  target, lv_32fc_t*  src0, uint32_t  num_points)
{
    __init_volk_32fc_index_max_16u();
    volk_32fc_index_max_16u_a(target, src0, num_points);
}

static inline void __volk_32fc_index_max_16u_u(uint16_t*  target, lv_32fc_t*  src0, uint32_t  num_points)
{
    __init_volk_32fc_index_max_16u();
    volk_32fc_index_max_16u_u(target, src0, num_points);
}

static inline void __volk_32fc_index_max_16u(uint16_t*  target, lv_32fc_t*  src0, uint32_t  num_points)
{
    __init_volk_32fc_index_max_16u();
    volk_32fc_index_max_16u(target, src0, num_points);
}

p_32fc_index_max_16u volk_32fc_index_max_16u_a = &__volk_32fc_index_max_16u_a;
p_32fc_index_max_16u volk_32fc_index_max_16u_u = &__volk_32fc_index_max_16u_u;
p_32fc_index_max_16u volk_32fc_index_max_16u   = &__volk_32fc_index_max_16u;

void volk_32fc_index_max_16u_manual(uint16_t*  target, lv_32fc_t*  src0, uint32_t  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_index_max_16u_impl_names,
        get_machine()->volk_32fc_index_max_16u_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_index_max_16u_impls[index](
        target, src0, num_points
    );
}

volk_func_desc_t volk_32fc_index_max_16u_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_index_max_16u_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_index_max_16u_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_index_max_16u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_index_max_16u_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_index_max_32u_d(uint32_t*  target, lv_32fc_t*  src0, uint32_t  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(target,
        VOLK_OR_PTR(src0,
        0))
    )){
        volk_32fc_index_max_32u_a(target, src0, num_points);
    }
    else{
        volk_32fc_index_max_32u_u(target, src0, num_points);
    }
}

static inline void __init_volk_32fc_index_max_32u(void)
{
    const char *name = get_machine()->volk_32fc_index_max_32u_name;
    const char **impl_names = get_machine()->volk_32fc_index_max_32u_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_index_max_32u_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_index_max_32u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_index_max_32u_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_index_max_32u_a = get_machine()->volk_32fc_index_max_32u_impls[index_a];
    volk_32fc_index_max_32u_u = get_machine()->volk_32fc_index_max_32u_impls[index_u];

    assert(volk_32fc_index_max_32u_a);
    assert(volk_32fc_index_max_32u_u);

    volk_32fc_index_max_32u = &__volk_32fc_index_max_32u_d;
}

static inline void __volk_32fc_index_max_32u_a(uint32_t*  target, lv_32fc_t*  src0, uint32_t  num_points)
{
    __init_volk_32fc_index_max_32u();
    volk_32fc_index_max_32u_a(target, src0, num_points);
}

static inline void __volk_32fc_index_max_32u_u(uint32_t*  target, lv_32fc_t*  src0, uint32_t  num_points)
{
    __init_volk_32fc_index_max_32u();
    volk_32fc_index_max_32u_u(target, src0, num_points);
}

static inline void __volk_32fc_index_max_32u(uint32_t*  target, lv_32fc_t*  src0, uint32_t  num_points)
{
    __init_volk_32fc_index_max_32u();
    volk_32fc_index_max_32u(target, src0, num_points);
}

p_32fc_index_max_32u volk_32fc_index_max_32u_a = &__volk_32fc_index_max_32u_a;
p_32fc_index_max_32u volk_32fc_index_max_32u_u = &__volk_32fc_index_max_32u_u;
p_32fc_index_max_32u volk_32fc_index_max_32u   = &__volk_32fc_index_max_32u;

void volk_32fc_index_max_32u_manual(uint32_t*  target, lv_32fc_t*  src0, uint32_t  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_index_max_32u_impl_names,
        get_machine()->volk_32fc_index_max_32u_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_index_max_32u_impls[index](
        target, src0, num_points
    );
}

volk_func_desc_t volk_32fc_index_max_32u_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_index_max_32u_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_index_max_32u_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_index_max_32u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_index_max_32u_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_index_min_16u_d(uint16_t*  target, const lv_32fc_t*  source, uint32_t  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(target,
        VOLK_OR_PTR(source,
        0))
    )){
        volk_32fc_index_min_16u_a(target, source, num_points);
    }
    else{
        volk_32fc_index_min_16u_u(target, source, num_points);
    }
}

static inline void __init_volk_32fc_index_min_16u(void)
{
    const char *name = get_machine()->volk_32fc_index_min_16u_name;
    const char **impl_names = get_machine()->volk_32fc_index_min_16u_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_index_min_16u_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_index_min_16u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_index_min_16u_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_index_min_16u_a = get_machine()->volk_32fc_index_min_16u_impls[index_a];
    volk_32fc_index_min_16u_u = get_machine()->volk_32fc_index_min_16u_impls[index_u];

    assert(volk_32fc_index_min_16u_a);
    assert(volk_32fc_index_min_16u_u);

    volk_32fc_index_min_16u = &__volk_32fc_index_min_16u_d;
}

static inline void __volk_32fc_index_min_16u_a(uint16_t*  target, const lv_32fc_t*  source, uint32_t  num_points)
{
    __init_volk_32fc_index_min_16u();
    volk_32fc_index_min_16u_a(target, source, num_points);
}

static inline void __volk_32fc_index_min_16u_u(uint16_t*  target, const lv_32fc_t*  source, uint32_t  num_points)
{
    __init_volk_32fc_index_min_16u();
    volk_32fc_index_min_16u_u(target, source, num_points);
}

static inline void __volk_32fc_index_min_16u(uint16_t*  target, const lv_32fc_t*  source, uint32_t  num_points)
{
    __init_volk_32fc_index_min_16u();
    volk_32fc_index_min_16u(target, source, num_points);
}

p_32fc_index_min_16u volk_32fc_index_min_16u_a = &__volk_32fc_index_min_16u_a;
p_32fc_index_min_16u volk_32fc_index_min_16u_u = &__volk_32fc_index_min_16u_u;
p_32fc_index_min_16u volk_32fc_index_min_16u   = &__volk_32fc_index_min_16u;

void volk_32fc_index_min_16u_manual(uint16_t*  target, const lv_32fc_t*  source, uint32_t  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_index_min_16u_impl_names,
        get_machine()->volk_32fc_index_min_16u_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_index_min_16u_impls[index](
        target, source, num_points
    );
}

volk_func_desc_t volk_32fc_index_min_16u_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_index_min_16u_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_index_min_16u_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_index_min_16u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_index_min_16u_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_index_min_32u_d(uint32_t*  target, const lv_32fc_t*  source, uint32_t  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(target,
        VOLK_OR_PTR(source,
        0))
    )){
        volk_32fc_index_min_32u_a(target, source, num_points);
    }
    else{
        volk_32fc_index_min_32u_u(target, source, num_points);
    }
}

static inline void __init_volk_32fc_index_min_32u(void)
{
    const char *name = get_machine()->volk_32fc_index_min_32u_name;
    const char **impl_names = get_machine()->volk_32fc_index_min_32u_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_index_min_32u_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_index_min_32u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_index_min_32u_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_index_min_32u_a = get_machine()->volk_32fc_index_min_32u_impls[index_a];
    volk_32fc_index_min_32u_u = get_machine()->volk_32fc_index_min_32u_impls[index_u];

    assert(volk_32fc_index_min_32u_a);
    assert(volk_32fc_index_min_32u_u);

    volk_32fc_index_min_32u = &__volk_32fc_index_min_32u_d;
}

static inline void __volk_32fc_index_min_32u_a(uint32_t*  target, const lv_32fc_t*  source, uint32_t  num_points)
{
    __init_volk_32fc_index_min_32u();
    volk_32fc_index_min_32u_a(target, source, num_points);
}

static inline void __volk_32fc_index_min_32u_u(uint32_t*  target, const lv_32fc_t*  source, uint32_t  num_points)
{
    __init_volk_32fc_index_min_32u();
    volk_32fc_index_min_32u_u(target, source, num_points);
}

static inline void __volk_32fc_index_min_32u(uint32_t*  target, const lv_32fc_t*  source, uint32_t  num_points)
{
    __init_volk_32fc_index_min_32u();
    volk_32fc_index_min_32u(target, source, num_points);
}

p_32fc_index_min_32u volk_32fc_index_min_32u_a = &__volk_32fc_index_min_32u_a;
p_32fc_index_min_32u volk_32fc_index_min_32u_u = &__volk_32fc_index_min_32u_u;
p_32fc_index_min_32u volk_32fc_index_min_32u   = &__volk_32fc_index_min_32u;

void volk_32fc_index_min_32u_manual(uint32_t*  target, const lv_32fc_t*  source, uint32_t  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_index_min_32u_impl_names,
        get_machine()->volk_32fc_index_min_32u_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_index_min_32u_impls[index](
        target, source, num_points
    );
}

volk_func_desc_t volk_32fc_index_min_32u_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_index_min_32u_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_index_min_32u_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_index_min_32u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_index_min_32u_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_magnitude_32f_d(float*  magnitudeVector, const lv_32fc_t*  complexVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(magnitudeVector,
        VOLK_OR_PTR(complexVector,
        0))
    )){
        volk_32fc_magnitude_32f_a(magnitudeVector, complexVector, num_points);
    }
    else{
        volk_32fc_magnitude_32f_u(magnitudeVector, complexVector, num_points);
    }
}

static inline void __init_volk_32fc_magnitude_32f(void)
{
    const char *name = get_machine()->volk_32fc_magnitude_32f_name;
    const char **impl_names = get_machine()->volk_32fc_magnitude_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_magnitude_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_magnitude_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_magnitude_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_magnitude_32f_a = get_machine()->volk_32fc_magnitude_32f_impls[index_a];
    volk_32fc_magnitude_32f_u = get_machine()->volk_32fc_magnitude_32f_impls[index_u];

    assert(volk_32fc_magnitude_32f_a);
    assert(volk_32fc_magnitude_32f_u);

    volk_32fc_magnitude_32f = &__volk_32fc_magnitude_32f_d;
}

static inline void __volk_32fc_magnitude_32f_a(float*  magnitudeVector, const lv_32fc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_32fc_magnitude_32f();
    volk_32fc_magnitude_32f_a(magnitudeVector, complexVector, num_points);
}

static inline void __volk_32fc_magnitude_32f_u(float*  magnitudeVector, const lv_32fc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_32fc_magnitude_32f();
    volk_32fc_magnitude_32f_u(magnitudeVector, complexVector, num_points);
}

static inline void __volk_32fc_magnitude_32f(float*  magnitudeVector, const lv_32fc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_32fc_magnitude_32f();
    volk_32fc_magnitude_32f(magnitudeVector, complexVector, num_points);
}

p_32fc_magnitude_32f volk_32fc_magnitude_32f_a = &__volk_32fc_magnitude_32f_a;
p_32fc_magnitude_32f volk_32fc_magnitude_32f_u = &__volk_32fc_magnitude_32f_u;
p_32fc_magnitude_32f volk_32fc_magnitude_32f   = &__volk_32fc_magnitude_32f;

void volk_32fc_magnitude_32f_manual(float*  magnitudeVector, const lv_32fc_t*  complexVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_magnitude_32f_impl_names,
        get_machine()->volk_32fc_magnitude_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_magnitude_32f_impls[index](
        magnitudeVector, complexVector, num_points
    );
}

volk_func_desc_t volk_32fc_magnitude_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_magnitude_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_magnitude_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_magnitude_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_magnitude_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_magnitude_squared_32f_d(float*  magnitudeVector, const lv_32fc_t*  complexVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(magnitudeVector,
        VOLK_OR_PTR(complexVector,
        0))
    )){
        volk_32fc_magnitude_squared_32f_a(magnitudeVector, complexVector, num_points);
    }
    else{
        volk_32fc_magnitude_squared_32f_u(magnitudeVector, complexVector, num_points);
    }
}

static inline void __init_volk_32fc_magnitude_squared_32f(void)
{
    const char *name = get_machine()->volk_32fc_magnitude_squared_32f_name;
    const char **impl_names = get_machine()->volk_32fc_magnitude_squared_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_magnitude_squared_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_magnitude_squared_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_magnitude_squared_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_magnitude_squared_32f_a = get_machine()->volk_32fc_magnitude_squared_32f_impls[index_a];
    volk_32fc_magnitude_squared_32f_u = get_machine()->volk_32fc_magnitude_squared_32f_impls[index_u];

    assert(volk_32fc_magnitude_squared_32f_a);
    assert(volk_32fc_magnitude_squared_32f_u);

    volk_32fc_magnitude_squared_32f = &__volk_32fc_magnitude_squared_32f_d;
}

static inline void __volk_32fc_magnitude_squared_32f_a(float*  magnitudeVector, const lv_32fc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_32fc_magnitude_squared_32f();
    volk_32fc_magnitude_squared_32f_a(magnitudeVector, complexVector, num_points);
}

static inline void __volk_32fc_magnitude_squared_32f_u(float*  magnitudeVector, const lv_32fc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_32fc_magnitude_squared_32f();
    volk_32fc_magnitude_squared_32f_u(magnitudeVector, complexVector, num_points);
}

static inline void __volk_32fc_magnitude_squared_32f(float*  magnitudeVector, const lv_32fc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_32fc_magnitude_squared_32f();
    volk_32fc_magnitude_squared_32f(magnitudeVector, complexVector, num_points);
}

p_32fc_magnitude_squared_32f volk_32fc_magnitude_squared_32f_a = &__volk_32fc_magnitude_squared_32f_a;
p_32fc_magnitude_squared_32f volk_32fc_magnitude_squared_32f_u = &__volk_32fc_magnitude_squared_32f_u;
p_32fc_magnitude_squared_32f volk_32fc_magnitude_squared_32f   = &__volk_32fc_magnitude_squared_32f;

void volk_32fc_magnitude_squared_32f_manual(float*  magnitudeVector, const lv_32fc_t*  complexVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_magnitude_squared_32f_impl_names,
        get_machine()->volk_32fc_magnitude_squared_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_magnitude_squared_32f_impls[index](
        magnitudeVector, complexVector, num_points
    );
}

volk_func_desc_t volk_32fc_magnitude_squared_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_magnitude_squared_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_magnitude_squared_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_magnitude_squared_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_magnitude_squared_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_s32f_atan2_32f_d(float*  outputVector, const lv_32fc_t*  inputVector, const float  normalizeFactor, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outputVector,
        VOLK_OR_PTR(inputVector,
        0))
    )){
        volk_32fc_s32f_atan2_32f_a(outputVector, inputVector, normalizeFactor, num_points);
    }
    else{
        volk_32fc_s32f_atan2_32f_u(outputVector, inputVector, normalizeFactor, num_points);
    }
}

static inline void __init_volk_32fc_s32f_atan2_32f(void)
{
    const char *name = get_machine()->volk_32fc_s32f_atan2_32f_name;
    const char **impl_names = get_machine()->volk_32fc_s32f_atan2_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32f_atan2_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32f_atan2_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32f_atan2_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_s32f_atan2_32f_a = get_machine()->volk_32fc_s32f_atan2_32f_impls[index_a];
    volk_32fc_s32f_atan2_32f_u = get_machine()->volk_32fc_s32f_atan2_32f_impls[index_u];

    assert(volk_32fc_s32f_atan2_32f_a);
    assert(volk_32fc_s32f_atan2_32f_u);

    volk_32fc_s32f_atan2_32f = &__volk_32fc_s32f_atan2_32f_d;
}

static inline void __volk_32fc_s32f_atan2_32f_a(float*  outputVector, const lv_32fc_t*  inputVector, const float  normalizeFactor, unsigned int  num_points)
{
    __init_volk_32fc_s32f_atan2_32f();
    volk_32fc_s32f_atan2_32f_a(outputVector, inputVector, normalizeFactor, num_points);
}

static inline void __volk_32fc_s32f_atan2_32f_u(float*  outputVector, const lv_32fc_t*  inputVector, const float  normalizeFactor, unsigned int  num_points)
{
    __init_volk_32fc_s32f_atan2_32f();
    volk_32fc_s32f_atan2_32f_u(outputVector, inputVector, normalizeFactor, num_points);
}

static inline void __volk_32fc_s32f_atan2_32f(float*  outputVector, const lv_32fc_t*  inputVector, const float  normalizeFactor, unsigned int  num_points)
{
    __init_volk_32fc_s32f_atan2_32f();
    volk_32fc_s32f_atan2_32f(outputVector, inputVector, normalizeFactor, num_points);
}

p_32fc_s32f_atan2_32f volk_32fc_s32f_atan2_32f_a = &__volk_32fc_s32f_atan2_32f_a;
p_32fc_s32f_atan2_32f volk_32fc_s32f_atan2_32f_u = &__volk_32fc_s32f_atan2_32f_u;
p_32fc_s32f_atan2_32f volk_32fc_s32f_atan2_32f   = &__volk_32fc_s32f_atan2_32f;

void volk_32fc_s32f_atan2_32f_manual(float*  outputVector, const lv_32fc_t*  inputVector, const float  normalizeFactor, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_s32f_atan2_32f_impl_names,
        get_machine()->volk_32fc_s32f_atan2_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_s32f_atan2_32f_impls[index](
        outputVector, inputVector, normalizeFactor, num_points
    );
}

volk_func_desc_t volk_32fc_s32f_atan2_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_s32f_atan2_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32f_atan2_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32f_atan2_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32f_atan2_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_s32f_deinterleave_real_16i_d(int16_t*  iBuffer, const lv_32fc_t*  complexVector, const float  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(iBuffer,
        VOLK_OR_PTR(complexVector,
        0))
    )){
        volk_32fc_s32f_deinterleave_real_16i_a(iBuffer, complexVector, scalar, num_points);
    }
    else{
        volk_32fc_s32f_deinterleave_real_16i_u(iBuffer, complexVector, scalar, num_points);
    }
}

static inline void __init_volk_32fc_s32f_deinterleave_real_16i(void)
{
    const char *name = get_machine()->volk_32fc_s32f_deinterleave_real_16i_name;
    const char **impl_names = get_machine()->volk_32fc_s32f_deinterleave_real_16i_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32f_deinterleave_real_16i_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32f_deinterleave_real_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32f_deinterleave_real_16i_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_s32f_deinterleave_real_16i_a = get_machine()->volk_32fc_s32f_deinterleave_real_16i_impls[index_a];
    volk_32fc_s32f_deinterleave_real_16i_u = get_machine()->volk_32fc_s32f_deinterleave_real_16i_impls[index_u];

    assert(volk_32fc_s32f_deinterleave_real_16i_a);
    assert(volk_32fc_s32f_deinterleave_real_16i_u);

    volk_32fc_s32f_deinterleave_real_16i = &__volk_32fc_s32f_deinterleave_real_16i_d;
}

static inline void __volk_32fc_s32f_deinterleave_real_16i_a(int16_t*  iBuffer, const lv_32fc_t*  complexVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32fc_s32f_deinterleave_real_16i();
    volk_32fc_s32f_deinterleave_real_16i_a(iBuffer, complexVector, scalar, num_points);
}

static inline void __volk_32fc_s32f_deinterleave_real_16i_u(int16_t*  iBuffer, const lv_32fc_t*  complexVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32fc_s32f_deinterleave_real_16i();
    volk_32fc_s32f_deinterleave_real_16i_u(iBuffer, complexVector, scalar, num_points);
}

static inline void __volk_32fc_s32f_deinterleave_real_16i(int16_t*  iBuffer, const lv_32fc_t*  complexVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32fc_s32f_deinterleave_real_16i();
    volk_32fc_s32f_deinterleave_real_16i(iBuffer, complexVector, scalar, num_points);
}

p_32fc_s32f_deinterleave_real_16i volk_32fc_s32f_deinterleave_real_16i_a = &__volk_32fc_s32f_deinterleave_real_16i_a;
p_32fc_s32f_deinterleave_real_16i volk_32fc_s32f_deinterleave_real_16i_u = &__volk_32fc_s32f_deinterleave_real_16i_u;
p_32fc_s32f_deinterleave_real_16i volk_32fc_s32f_deinterleave_real_16i   = &__volk_32fc_s32f_deinterleave_real_16i;

void volk_32fc_s32f_deinterleave_real_16i_manual(int16_t*  iBuffer, const lv_32fc_t*  complexVector, const float  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_s32f_deinterleave_real_16i_impl_names,
        get_machine()->volk_32fc_s32f_deinterleave_real_16i_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_s32f_deinterleave_real_16i_impls[index](
        iBuffer, complexVector, scalar, num_points
    );
}

volk_func_desc_t volk_32fc_s32f_deinterleave_real_16i_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_s32f_deinterleave_real_16i_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32f_deinterleave_real_16i_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32f_deinterleave_real_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32f_deinterleave_real_16i_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_s32f_magnitude_16i_d(int16_t*  magnitudeVector, const lv_32fc_t*  complexVector, const float  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(magnitudeVector,
        VOLK_OR_PTR(complexVector,
        0))
    )){
        volk_32fc_s32f_magnitude_16i_a(magnitudeVector, complexVector, scalar, num_points);
    }
    else{
        volk_32fc_s32f_magnitude_16i_u(magnitudeVector, complexVector, scalar, num_points);
    }
}

static inline void __init_volk_32fc_s32f_magnitude_16i(void)
{
    const char *name = get_machine()->volk_32fc_s32f_magnitude_16i_name;
    const char **impl_names = get_machine()->volk_32fc_s32f_magnitude_16i_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32f_magnitude_16i_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32f_magnitude_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32f_magnitude_16i_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_s32f_magnitude_16i_a = get_machine()->volk_32fc_s32f_magnitude_16i_impls[index_a];
    volk_32fc_s32f_magnitude_16i_u = get_machine()->volk_32fc_s32f_magnitude_16i_impls[index_u];

    assert(volk_32fc_s32f_magnitude_16i_a);
    assert(volk_32fc_s32f_magnitude_16i_u);

    volk_32fc_s32f_magnitude_16i = &__volk_32fc_s32f_magnitude_16i_d;
}

static inline void __volk_32fc_s32f_magnitude_16i_a(int16_t*  magnitudeVector, const lv_32fc_t*  complexVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32fc_s32f_magnitude_16i();
    volk_32fc_s32f_magnitude_16i_a(magnitudeVector, complexVector, scalar, num_points);
}

static inline void __volk_32fc_s32f_magnitude_16i_u(int16_t*  magnitudeVector, const lv_32fc_t*  complexVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32fc_s32f_magnitude_16i();
    volk_32fc_s32f_magnitude_16i_u(magnitudeVector, complexVector, scalar, num_points);
}

static inline void __volk_32fc_s32f_magnitude_16i(int16_t*  magnitudeVector, const lv_32fc_t*  complexVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32fc_s32f_magnitude_16i();
    volk_32fc_s32f_magnitude_16i(magnitudeVector, complexVector, scalar, num_points);
}

p_32fc_s32f_magnitude_16i volk_32fc_s32f_magnitude_16i_a = &__volk_32fc_s32f_magnitude_16i_a;
p_32fc_s32f_magnitude_16i volk_32fc_s32f_magnitude_16i_u = &__volk_32fc_s32f_magnitude_16i_u;
p_32fc_s32f_magnitude_16i volk_32fc_s32f_magnitude_16i   = &__volk_32fc_s32f_magnitude_16i;

void volk_32fc_s32f_magnitude_16i_manual(int16_t*  magnitudeVector, const lv_32fc_t*  complexVector, const float  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_s32f_magnitude_16i_impl_names,
        get_machine()->volk_32fc_s32f_magnitude_16i_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_s32f_magnitude_16i_impls[index](
        magnitudeVector, complexVector, scalar, num_points
    );
}

volk_func_desc_t volk_32fc_s32f_magnitude_16i_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_s32f_magnitude_16i_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32f_magnitude_16i_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32f_magnitude_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32f_magnitude_16i_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_s32f_power_32fc_d(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const float  power, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        0))
    )){
        volk_32fc_s32f_power_32fc_a(cVector, aVector, power, num_points);
    }
    else{
        volk_32fc_s32f_power_32fc_u(cVector, aVector, power, num_points);
    }
}

static inline void __init_volk_32fc_s32f_power_32fc(void)
{
    const char *name = get_machine()->volk_32fc_s32f_power_32fc_name;
    const char **impl_names = get_machine()->volk_32fc_s32f_power_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32f_power_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32f_power_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32f_power_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_s32f_power_32fc_a = get_machine()->volk_32fc_s32f_power_32fc_impls[index_a];
    volk_32fc_s32f_power_32fc_u = get_machine()->volk_32fc_s32f_power_32fc_impls[index_u];

    assert(volk_32fc_s32f_power_32fc_a);
    assert(volk_32fc_s32f_power_32fc_u);

    volk_32fc_s32f_power_32fc = &__volk_32fc_s32f_power_32fc_d;
}

static inline void __volk_32fc_s32f_power_32fc_a(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const float  power, unsigned int  num_points)
{
    __init_volk_32fc_s32f_power_32fc();
    volk_32fc_s32f_power_32fc_a(cVector, aVector, power, num_points);
}

static inline void __volk_32fc_s32f_power_32fc_u(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const float  power, unsigned int  num_points)
{
    __init_volk_32fc_s32f_power_32fc();
    volk_32fc_s32f_power_32fc_u(cVector, aVector, power, num_points);
}

static inline void __volk_32fc_s32f_power_32fc(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const float  power, unsigned int  num_points)
{
    __init_volk_32fc_s32f_power_32fc();
    volk_32fc_s32f_power_32fc(cVector, aVector, power, num_points);
}

p_32fc_s32f_power_32fc volk_32fc_s32f_power_32fc_a = &__volk_32fc_s32f_power_32fc_a;
p_32fc_s32f_power_32fc volk_32fc_s32f_power_32fc_u = &__volk_32fc_s32f_power_32fc_u;
p_32fc_s32f_power_32fc volk_32fc_s32f_power_32fc   = &__volk_32fc_s32f_power_32fc;

void volk_32fc_s32f_power_32fc_manual(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const float  power, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_s32f_power_32fc_impl_names,
        get_machine()->volk_32fc_s32f_power_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_s32f_power_32fc_impls[index](
        cVector, aVector, power, num_points
    );
}

volk_func_desc_t volk_32fc_s32f_power_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_s32f_power_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32f_power_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32f_power_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32f_power_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_s32f_power_spectral_densitypuppet_32f_d(float*  logPowerOutput, const lv_32fc_t*  complexFFTInput, const float  normalizationFactor, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(logPowerOutput,
        VOLK_OR_PTR(complexFFTInput,
        0))
    )){
        volk_32fc_s32f_power_spectral_densitypuppet_32f_a(logPowerOutput, complexFFTInput, normalizationFactor, num_points);
    }
    else{
        volk_32fc_s32f_power_spectral_densitypuppet_32f_u(logPowerOutput, complexFFTInput, normalizationFactor, num_points);
    }
}

static inline void __init_volk_32fc_s32f_power_spectral_densitypuppet_32f(void)
{
    const char *name = get_machine()->volk_32fc_s32f_power_spectral_densitypuppet_32f_name;
    const char **impl_names = get_machine()->volk_32fc_s32f_power_spectral_densitypuppet_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32f_power_spectral_densitypuppet_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32f_power_spectral_densitypuppet_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32f_power_spectral_densitypuppet_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_s32f_power_spectral_densitypuppet_32f_a = get_machine()->volk_32fc_s32f_power_spectral_densitypuppet_32f_impls[index_a];
    volk_32fc_s32f_power_spectral_densitypuppet_32f_u = get_machine()->volk_32fc_s32f_power_spectral_densitypuppet_32f_impls[index_u];

    assert(volk_32fc_s32f_power_spectral_densitypuppet_32f_a);
    assert(volk_32fc_s32f_power_spectral_densitypuppet_32f_u);

    volk_32fc_s32f_power_spectral_densitypuppet_32f = &__volk_32fc_s32f_power_spectral_densitypuppet_32f_d;
}

static inline void __volk_32fc_s32f_power_spectral_densitypuppet_32f_a(float*  logPowerOutput, const lv_32fc_t*  complexFFTInput, const float  normalizationFactor, unsigned int  num_points)
{
    __init_volk_32fc_s32f_power_spectral_densitypuppet_32f();
    volk_32fc_s32f_power_spectral_densitypuppet_32f_a(logPowerOutput, complexFFTInput, normalizationFactor, num_points);
}

static inline void __volk_32fc_s32f_power_spectral_densitypuppet_32f_u(float*  logPowerOutput, const lv_32fc_t*  complexFFTInput, const float  normalizationFactor, unsigned int  num_points)
{
    __init_volk_32fc_s32f_power_spectral_densitypuppet_32f();
    volk_32fc_s32f_power_spectral_densitypuppet_32f_u(logPowerOutput, complexFFTInput, normalizationFactor, num_points);
}

static inline void __volk_32fc_s32f_power_spectral_densitypuppet_32f(float*  logPowerOutput, const lv_32fc_t*  complexFFTInput, const float  normalizationFactor, unsigned int  num_points)
{
    __init_volk_32fc_s32f_power_spectral_densitypuppet_32f();
    volk_32fc_s32f_power_spectral_densitypuppet_32f(logPowerOutput, complexFFTInput, normalizationFactor, num_points);
}

p_32fc_s32f_power_spectral_densitypuppet_32f volk_32fc_s32f_power_spectral_densitypuppet_32f_a = &__volk_32fc_s32f_power_spectral_densitypuppet_32f_a;
p_32fc_s32f_power_spectral_densitypuppet_32f volk_32fc_s32f_power_spectral_densitypuppet_32f_u = &__volk_32fc_s32f_power_spectral_densitypuppet_32f_u;
p_32fc_s32f_power_spectral_densitypuppet_32f volk_32fc_s32f_power_spectral_densitypuppet_32f   = &__volk_32fc_s32f_power_spectral_densitypuppet_32f;

void volk_32fc_s32f_power_spectral_densitypuppet_32f_manual(float*  logPowerOutput, const lv_32fc_t*  complexFFTInput, const float  normalizationFactor, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_s32f_power_spectral_densitypuppet_32f_impl_names,
        get_machine()->volk_32fc_s32f_power_spectral_densitypuppet_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_s32f_power_spectral_densitypuppet_32f_impls[index](
        logPowerOutput, complexFFTInput, normalizationFactor, num_points
    );
}

volk_func_desc_t volk_32fc_s32f_power_spectral_densitypuppet_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_s32f_power_spectral_densitypuppet_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32f_power_spectral_densitypuppet_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32f_power_spectral_densitypuppet_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32f_power_spectral_densitypuppet_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_s32f_power_spectrum_32f_d(float*  logPowerOutput, const lv_32fc_t*  complexFFTInput, const float  normalizationFactor, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(logPowerOutput,
        VOLK_OR_PTR(complexFFTInput,
        0))
    )){
        volk_32fc_s32f_power_spectrum_32f_a(logPowerOutput, complexFFTInput, normalizationFactor, num_points);
    }
    else{
        volk_32fc_s32f_power_spectrum_32f_u(logPowerOutput, complexFFTInput, normalizationFactor, num_points);
    }
}

static inline void __init_volk_32fc_s32f_power_spectrum_32f(void)
{
    const char *name = get_machine()->volk_32fc_s32f_power_spectrum_32f_name;
    const char **impl_names = get_machine()->volk_32fc_s32f_power_spectrum_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32f_power_spectrum_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32f_power_spectrum_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32f_power_spectrum_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_s32f_power_spectrum_32f_a = get_machine()->volk_32fc_s32f_power_spectrum_32f_impls[index_a];
    volk_32fc_s32f_power_spectrum_32f_u = get_machine()->volk_32fc_s32f_power_spectrum_32f_impls[index_u];

    assert(volk_32fc_s32f_power_spectrum_32f_a);
    assert(volk_32fc_s32f_power_spectrum_32f_u);

    volk_32fc_s32f_power_spectrum_32f = &__volk_32fc_s32f_power_spectrum_32f_d;
}

static inline void __volk_32fc_s32f_power_spectrum_32f_a(float*  logPowerOutput, const lv_32fc_t*  complexFFTInput, const float  normalizationFactor, unsigned int  num_points)
{
    __init_volk_32fc_s32f_power_spectrum_32f();
    volk_32fc_s32f_power_spectrum_32f_a(logPowerOutput, complexFFTInput, normalizationFactor, num_points);
}

static inline void __volk_32fc_s32f_power_spectrum_32f_u(float*  logPowerOutput, const lv_32fc_t*  complexFFTInput, const float  normalizationFactor, unsigned int  num_points)
{
    __init_volk_32fc_s32f_power_spectrum_32f();
    volk_32fc_s32f_power_spectrum_32f_u(logPowerOutput, complexFFTInput, normalizationFactor, num_points);
}

static inline void __volk_32fc_s32f_power_spectrum_32f(float*  logPowerOutput, const lv_32fc_t*  complexFFTInput, const float  normalizationFactor, unsigned int  num_points)
{
    __init_volk_32fc_s32f_power_spectrum_32f();
    volk_32fc_s32f_power_spectrum_32f(logPowerOutput, complexFFTInput, normalizationFactor, num_points);
}

p_32fc_s32f_power_spectrum_32f volk_32fc_s32f_power_spectrum_32f_a = &__volk_32fc_s32f_power_spectrum_32f_a;
p_32fc_s32f_power_spectrum_32f volk_32fc_s32f_power_spectrum_32f_u = &__volk_32fc_s32f_power_spectrum_32f_u;
p_32fc_s32f_power_spectrum_32f volk_32fc_s32f_power_spectrum_32f   = &__volk_32fc_s32f_power_spectrum_32f;

void volk_32fc_s32f_power_spectrum_32f_manual(float*  logPowerOutput, const lv_32fc_t*  complexFFTInput, const float  normalizationFactor, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_s32f_power_spectrum_32f_impl_names,
        get_machine()->volk_32fc_s32f_power_spectrum_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_s32f_power_spectrum_32f_impls[index](
        logPowerOutput, complexFFTInput, normalizationFactor, num_points
    );
}

volk_func_desc_t volk_32fc_s32f_power_spectrum_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_s32f_power_spectrum_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32f_power_spectrum_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32f_power_spectrum_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32f_power_spectrum_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_s32f_x2_power_spectral_density_32f_d(float*  logPowerOutput, const lv_32fc_t*  complexFFTInput, const float  normalizationFactor, const float  rbw, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(logPowerOutput,
        VOLK_OR_PTR(complexFFTInput,
        0))
    )){
        volk_32fc_s32f_x2_power_spectral_density_32f_a(logPowerOutput, complexFFTInput, normalizationFactor, rbw, num_points);
    }
    else{
        volk_32fc_s32f_x2_power_spectral_density_32f_u(logPowerOutput, complexFFTInput, normalizationFactor, rbw, num_points);
    }
}

static inline void __init_volk_32fc_s32f_x2_power_spectral_density_32f(void)
{
    const char *name = get_machine()->volk_32fc_s32f_x2_power_spectral_density_32f_name;
    const char **impl_names = get_machine()->volk_32fc_s32f_x2_power_spectral_density_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32f_x2_power_spectral_density_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32f_x2_power_spectral_density_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32f_x2_power_spectral_density_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_s32f_x2_power_spectral_density_32f_a = get_machine()->volk_32fc_s32f_x2_power_spectral_density_32f_impls[index_a];
    volk_32fc_s32f_x2_power_spectral_density_32f_u = get_machine()->volk_32fc_s32f_x2_power_spectral_density_32f_impls[index_u];

    assert(volk_32fc_s32f_x2_power_spectral_density_32f_a);
    assert(volk_32fc_s32f_x2_power_spectral_density_32f_u);

    volk_32fc_s32f_x2_power_spectral_density_32f = &__volk_32fc_s32f_x2_power_spectral_density_32f_d;
}

static inline void __volk_32fc_s32f_x2_power_spectral_density_32f_a(float*  logPowerOutput, const lv_32fc_t*  complexFFTInput, const float  normalizationFactor, const float  rbw, unsigned int  num_points)
{
    __init_volk_32fc_s32f_x2_power_spectral_density_32f();
    volk_32fc_s32f_x2_power_spectral_density_32f_a(logPowerOutput, complexFFTInput, normalizationFactor, rbw, num_points);
}

static inline void __volk_32fc_s32f_x2_power_spectral_density_32f_u(float*  logPowerOutput, const lv_32fc_t*  complexFFTInput, const float  normalizationFactor, const float  rbw, unsigned int  num_points)
{
    __init_volk_32fc_s32f_x2_power_spectral_density_32f();
    volk_32fc_s32f_x2_power_spectral_density_32f_u(logPowerOutput, complexFFTInput, normalizationFactor, rbw, num_points);
}

static inline void __volk_32fc_s32f_x2_power_spectral_density_32f(float*  logPowerOutput, const lv_32fc_t*  complexFFTInput, const float  normalizationFactor, const float  rbw, unsigned int  num_points)
{
    __init_volk_32fc_s32f_x2_power_spectral_density_32f();
    volk_32fc_s32f_x2_power_spectral_density_32f(logPowerOutput, complexFFTInput, normalizationFactor, rbw, num_points);
}

p_32fc_s32f_x2_power_spectral_density_32f volk_32fc_s32f_x2_power_spectral_density_32f_a = &__volk_32fc_s32f_x2_power_spectral_density_32f_a;
p_32fc_s32f_x2_power_spectral_density_32f volk_32fc_s32f_x2_power_spectral_density_32f_u = &__volk_32fc_s32f_x2_power_spectral_density_32f_u;
p_32fc_s32f_x2_power_spectral_density_32f volk_32fc_s32f_x2_power_spectral_density_32f   = &__volk_32fc_s32f_x2_power_spectral_density_32f;

void volk_32fc_s32f_x2_power_spectral_density_32f_manual(float*  logPowerOutput, const lv_32fc_t*  complexFFTInput, const float  normalizationFactor, const float  rbw, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_s32f_x2_power_spectral_density_32f_impl_names,
        get_machine()->volk_32fc_s32f_x2_power_spectral_density_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_s32f_x2_power_spectral_density_32f_impls[index](
        logPowerOutput, complexFFTInput, normalizationFactor, rbw, num_points
    );
}

volk_func_desc_t volk_32fc_s32f_x2_power_spectral_density_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_s32f_x2_power_spectral_density_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32f_x2_power_spectral_density_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32f_x2_power_spectral_density_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32f_x2_power_spectral_density_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_s32fc_multiply2_32fc_d(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(scalar,
        0)))
    )){
        volk_32fc_s32fc_multiply2_32fc_a(cVector, aVector, scalar, num_points);
    }
    else{
        volk_32fc_s32fc_multiply2_32fc_u(cVector, aVector, scalar, num_points);
    }
}

static inline void __init_volk_32fc_s32fc_multiply2_32fc(void)
{
    const char *name = get_machine()->volk_32fc_s32fc_multiply2_32fc_name;
    const char **impl_names = get_machine()->volk_32fc_s32fc_multiply2_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32fc_multiply2_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32fc_multiply2_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32fc_multiply2_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_s32fc_multiply2_32fc_a = get_machine()->volk_32fc_s32fc_multiply2_32fc_impls[index_a];
    volk_32fc_s32fc_multiply2_32fc_u = get_machine()->volk_32fc_s32fc_multiply2_32fc_impls[index_u];

    assert(volk_32fc_s32fc_multiply2_32fc_a);
    assert(volk_32fc_s32fc_multiply2_32fc_u);

    volk_32fc_s32fc_multiply2_32fc = &__volk_32fc_s32fc_multiply2_32fc_d;
}

static inline void __volk_32fc_s32fc_multiply2_32fc_a(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  scalar, unsigned int  num_points)
{
    __init_volk_32fc_s32fc_multiply2_32fc();
    volk_32fc_s32fc_multiply2_32fc_a(cVector, aVector, scalar, num_points);
}

static inline void __volk_32fc_s32fc_multiply2_32fc_u(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  scalar, unsigned int  num_points)
{
    __init_volk_32fc_s32fc_multiply2_32fc();
    volk_32fc_s32fc_multiply2_32fc_u(cVector, aVector, scalar, num_points);
}

static inline void __volk_32fc_s32fc_multiply2_32fc(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  scalar, unsigned int  num_points)
{
    __init_volk_32fc_s32fc_multiply2_32fc();
    volk_32fc_s32fc_multiply2_32fc(cVector, aVector, scalar, num_points);
}

p_32fc_s32fc_multiply2_32fc volk_32fc_s32fc_multiply2_32fc_a = &__volk_32fc_s32fc_multiply2_32fc_a;
p_32fc_s32fc_multiply2_32fc volk_32fc_s32fc_multiply2_32fc_u = &__volk_32fc_s32fc_multiply2_32fc_u;
p_32fc_s32fc_multiply2_32fc volk_32fc_s32fc_multiply2_32fc   = &__volk_32fc_s32fc_multiply2_32fc;

void volk_32fc_s32fc_multiply2_32fc_manual(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_s32fc_multiply2_32fc_impl_names,
        get_machine()->volk_32fc_s32fc_multiply2_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_s32fc_multiply2_32fc_impls[index](
        cVector, aVector, scalar, num_points
    );
}

volk_func_desc_t volk_32fc_s32fc_multiply2_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_s32fc_multiply2_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32fc_multiply2_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32fc_multiply2_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32fc_multiply2_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_s32fc_multiply_32fc_d(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        0))
    )){
        volk_32fc_s32fc_multiply_32fc_a(cVector, aVector, scalar, num_points);
    }
    else{
        volk_32fc_s32fc_multiply_32fc_u(cVector, aVector, scalar, num_points);
    }
}

static inline void __init_volk_32fc_s32fc_multiply_32fc(void)
{
    const char *name = get_machine()->volk_32fc_s32fc_multiply_32fc_name;
    const char **impl_names = get_machine()->volk_32fc_s32fc_multiply_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32fc_multiply_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32fc_multiply_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32fc_multiply_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_s32fc_multiply_32fc_a = get_machine()->volk_32fc_s32fc_multiply_32fc_impls[index_a];
    volk_32fc_s32fc_multiply_32fc_u = get_machine()->volk_32fc_s32fc_multiply_32fc_impls[index_u];

    assert(volk_32fc_s32fc_multiply_32fc_a);
    assert(volk_32fc_s32fc_multiply_32fc_u);

    volk_32fc_s32fc_multiply_32fc = &__volk_32fc_s32fc_multiply_32fc_d;
}

static inline void __volk_32fc_s32fc_multiply_32fc_a(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t  scalar, unsigned int  num_points)
{
    __init_volk_32fc_s32fc_multiply_32fc();
    volk_32fc_s32fc_multiply_32fc_a(cVector, aVector, scalar, num_points);
}

static inline void __volk_32fc_s32fc_multiply_32fc_u(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t  scalar, unsigned int  num_points)
{
    __init_volk_32fc_s32fc_multiply_32fc();
    volk_32fc_s32fc_multiply_32fc_u(cVector, aVector, scalar, num_points);
}

static inline void __volk_32fc_s32fc_multiply_32fc(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t  scalar, unsigned int  num_points)
{
    __init_volk_32fc_s32fc_multiply_32fc();
    volk_32fc_s32fc_multiply_32fc(cVector, aVector, scalar, num_points);
}

p_32fc_s32fc_multiply_32fc volk_32fc_s32fc_multiply_32fc_a = &__volk_32fc_s32fc_multiply_32fc_a;
p_32fc_s32fc_multiply_32fc volk_32fc_s32fc_multiply_32fc_u = &__volk_32fc_s32fc_multiply_32fc_u;
p_32fc_s32fc_multiply_32fc volk_32fc_s32fc_multiply_32fc   = &__volk_32fc_s32fc_multiply_32fc;

void volk_32fc_s32fc_multiply_32fc_manual(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_s32fc_multiply_32fc_impl_names,
        get_machine()->volk_32fc_s32fc_multiply_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_s32fc_multiply_32fc_impls[index](
        cVector, aVector, scalar, num_points
    );
}

volk_func_desc_t volk_32fc_s32fc_multiply_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_s32fc_multiply_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32fc_multiply_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32fc_multiply_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32fc_multiply_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_s32fc_rotator2puppet_32fc_d(lv_32fc_t*  outVector, const lv_32fc_t*  inVector, const lv_32fc_t*  phase_inc, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outVector,
        VOLK_OR_PTR(inVector,
        VOLK_OR_PTR(phase_inc,
        0)))
    )){
        volk_32fc_s32fc_rotator2puppet_32fc_a(outVector, inVector, phase_inc, num_points);
    }
    else{
        volk_32fc_s32fc_rotator2puppet_32fc_u(outVector, inVector, phase_inc, num_points);
    }
}

static inline void __init_volk_32fc_s32fc_rotator2puppet_32fc(void)
{
    const char *name = get_machine()->volk_32fc_s32fc_rotator2puppet_32fc_name;
    const char **impl_names = get_machine()->volk_32fc_s32fc_rotator2puppet_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32fc_rotator2puppet_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32fc_rotator2puppet_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32fc_rotator2puppet_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_s32fc_rotator2puppet_32fc_a = get_machine()->volk_32fc_s32fc_rotator2puppet_32fc_impls[index_a];
    volk_32fc_s32fc_rotator2puppet_32fc_u = get_machine()->volk_32fc_s32fc_rotator2puppet_32fc_impls[index_u];

    assert(volk_32fc_s32fc_rotator2puppet_32fc_a);
    assert(volk_32fc_s32fc_rotator2puppet_32fc_u);

    volk_32fc_s32fc_rotator2puppet_32fc = &__volk_32fc_s32fc_rotator2puppet_32fc_d;
}

static inline void __volk_32fc_s32fc_rotator2puppet_32fc_a(lv_32fc_t*  outVector, const lv_32fc_t*  inVector, const lv_32fc_t*  phase_inc, unsigned int  num_points)
{
    __init_volk_32fc_s32fc_rotator2puppet_32fc();
    volk_32fc_s32fc_rotator2puppet_32fc_a(outVector, inVector, phase_inc, num_points);
}

static inline void __volk_32fc_s32fc_rotator2puppet_32fc_u(lv_32fc_t*  outVector, const lv_32fc_t*  inVector, const lv_32fc_t*  phase_inc, unsigned int  num_points)
{
    __init_volk_32fc_s32fc_rotator2puppet_32fc();
    volk_32fc_s32fc_rotator2puppet_32fc_u(outVector, inVector, phase_inc, num_points);
}

static inline void __volk_32fc_s32fc_rotator2puppet_32fc(lv_32fc_t*  outVector, const lv_32fc_t*  inVector, const lv_32fc_t*  phase_inc, unsigned int  num_points)
{
    __init_volk_32fc_s32fc_rotator2puppet_32fc();
    volk_32fc_s32fc_rotator2puppet_32fc(outVector, inVector, phase_inc, num_points);
}

p_32fc_s32fc_rotator2puppet_32fc volk_32fc_s32fc_rotator2puppet_32fc_a = &__volk_32fc_s32fc_rotator2puppet_32fc_a;
p_32fc_s32fc_rotator2puppet_32fc volk_32fc_s32fc_rotator2puppet_32fc_u = &__volk_32fc_s32fc_rotator2puppet_32fc_u;
p_32fc_s32fc_rotator2puppet_32fc volk_32fc_s32fc_rotator2puppet_32fc   = &__volk_32fc_s32fc_rotator2puppet_32fc;

void volk_32fc_s32fc_rotator2puppet_32fc_manual(lv_32fc_t*  outVector, const lv_32fc_t*  inVector, const lv_32fc_t*  phase_inc, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_s32fc_rotator2puppet_32fc_impl_names,
        get_machine()->volk_32fc_s32fc_rotator2puppet_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_s32fc_rotator2puppet_32fc_impls[index](
        outVector, inVector, phase_inc, num_points
    );
}

volk_func_desc_t volk_32fc_s32fc_rotator2puppet_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_s32fc_rotator2puppet_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32fc_rotator2puppet_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32fc_rotator2puppet_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32fc_rotator2puppet_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_s32fc_x2_rotator2_32fc_d(lv_32fc_t*  outVector, const lv_32fc_t*  inVector, const lv_32fc_t*  phase_inc, lv_32fc_t*  phase, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outVector,
        VOLK_OR_PTR(inVector,
        VOLK_OR_PTR(phase_inc,
        VOLK_OR_PTR(phase,
        0))))
    )){
        volk_32fc_s32fc_x2_rotator2_32fc_a(outVector, inVector, phase_inc, phase, num_points);
    }
    else{
        volk_32fc_s32fc_x2_rotator2_32fc_u(outVector, inVector, phase_inc, phase, num_points);
    }
}

static inline void __init_volk_32fc_s32fc_x2_rotator2_32fc(void)
{
    const char *name = get_machine()->volk_32fc_s32fc_x2_rotator2_32fc_name;
    const char **impl_names = get_machine()->volk_32fc_s32fc_x2_rotator2_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32fc_x2_rotator2_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32fc_x2_rotator2_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32fc_x2_rotator2_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_s32fc_x2_rotator2_32fc_a = get_machine()->volk_32fc_s32fc_x2_rotator2_32fc_impls[index_a];
    volk_32fc_s32fc_x2_rotator2_32fc_u = get_machine()->volk_32fc_s32fc_x2_rotator2_32fc_impls[index_u];

    assert(volk_32fc_s32fc_x2_rotator2_32fc_a);
    assert(volk_32fc_s32fc_x2_rotator2_32fc_u);

    volk_32fc_s32fc_x2_rotator2_32fc = &__volk_32fc_s32fc_x2_rotator2_32fc_d;
}

static inline void __volk_32fc_s32fc_x2_rotator2_32fc_a(lv_32fc_t*  outVector, const lv_32fc_t*  inVector, const lv_32fc_t*  phase_inc, lv_32fc_t*  phase, unsigned int  num_points)
{
    __init_volk_32fc_s32fc_x2_rotator2_32fc();
    volk_32fc_s32fc_x2_rotator2_32fc_a(outVector, inVector, phase_inc, phase, num_points);
}

static inline void __volk_32fc_s32fc_x2_rotator2_32fc_u(lv_32fc_t*  outVector, const lv_32fc_t*  inVector, const lv_32fc_t*  phase_inc, lv_32fc_t*  phase, unsigned int  num_points)
{
    __init_volk_32fc_s32fc_x2_rotator2_32fc();
    volk_32fc_s32fc_x2_rotator2_32fc_u(outVector, inVector, phase_inc, phase, num_points);
}

static inline void __volk_32fc_s32fc_x2_rotator2_32fc(lv_32fc_t*  outVector, const lv_32fc_t*  inVector, const lv_32fc_t*  phase_inc, lv_32fc_t*  phase, unsigned int  num_points)
{
    __init_volk_32fc_s32fc_x2_rotator2_32fc();
    volk_32fc_s32fc_x2_rotator2_32fc(outVector, inVector, phase_inc, phase, num_points);
}

p_32fc_s32fc_x2_rotator2_32fc volk_32fc_s32fc_x2_rotator2_32fc_a = &__volk_32fc_s32fc_x2_rotator2_32fc_a;
p_32fc_s32fc_x2_rotator2_32fc volk_32fc_s32fc_x2_rotator2_32fc_u = &__volk_32fc_s32fc_x2_rotator2_32fc_u;
p_32fc_s32fc_x2_rotator2_32fc volk_32fc_s32fc_x2_rotator2_32fc   = &__volk_32fc_s32fc_x2_rotator2_32fc;

void volk_32fc_s32fc_x2_rotator2_32fc_manual(lv_32fc_t*  outVector, const lv_32fc_t*  inVector, const lv_32fc_t*  phase_inc, lv_32fc_t*  phase, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_s32fc_x2_rotator2_32fc_impl_names,
        get_machine()->volk_32fc_s32fc_x2_rotator2_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_s32fc_x2_rotator2_32fc_impls[index](
        outVector, inVector, phase_inc, phase, num_points
    );
}

volk_func_desc_t volk_32fc_s32fc_x2_rotator2_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_s32fc_x2_rotator2_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32fc_x2_rotator2_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32fc_x2_rotator2_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32fc_x2_rotator2_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_s32fc_x2_rotator_32fc_d(lv_32fc_t*  outVector, const lv_32fc_t*  inVector, const lv_32fc_t  phase_inc, lv_32fc_t*  phase, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outVector,
        VOLK_OR_PTR(inVector,
        VOLK_OR_PTR(phase,
        0)))
    )){
        volk_32fc_s32fc_x2_rotator_32fc_a(outVector, inVector, phase_inc, phase, num_points);
    }
    else{
        volk_32fc_s32fc_x2_rotator_32fc_u(outVector, inVector, phase_inc, phase, num_points);
    }
}

static inline void __init_volk_32fc_s32fc_x2_rotator_32fc(void)
{
    const char *name = get_machine()->volk_32fc_s32fc_x2_rotator_32fc_name;
    const char **impl_names = get_machine()->volk_32fc_s32fc_x2_rotator_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32fc_x2_rotator_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32fc_x2_rotator_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32fc_x2_rotator_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_s32fc_x2_rotator_32fc_a = get_machine()->volk_32fc_s32fc_x2_rotator_32fc_impls[index_a];
    volk_32fc_s32fc_x2_rotator_32fc_u = get_machine()->volk_32fc_s32fc_x2_rotator_32fc_impls[index_u];

    assert(volk_32fc_s32fc_x2_rotator_32fc_a);
    assert(volk_32fc_s32fc_x2_rotator_32fc_u);

    volk_32fc_s32fc_x2_rotator_32fc = &__volk_32fc_s32fc_x2_rotator_32fc_d;
}

static inline void __volk_32fc_s32fc_x2_rotator_32fc_a(lv_32fc_t*  outVector, const lv_32fc_t*  inVector, const lv_32fc_t  phase_inc, lv_32fc_t*  phase, unsigned int  num_points)
{
    __init_volk_32fc_s32fc_x2_rotator_32fc();
    volk_32fc_s32fc_x2_rotator_32fc_a(outVector, inVector, phase_inc, phase, num_points);
}

static inline void __volk_32fc_s32fc_x2_rotator_32fc_u(lv_32fc_t*  outVector, const lv_32fc_t*  inVector, const lv_32fc_t  phase_inc, lv_32fc_t*  phase, unsigned int  num_points)
{
    __init_volk_32fc_s32fc_x2_rotator_32fc();
    volk_32fc_s32fc_x2_rotator_32fc_u(outVector, inVector, phase_inc, phase, num_points);
}

static inline void __volk_32fc_s32fc_x2_rotator_32fc(lv_32fc_t*  outVector, const lv_32fc_t*  inVector, const lv_32fc_t  phase_inc, lv_32fc_t*  phase, unsigned int  num_points)
{
    __init_volk_32fc_s32fc_x2_rotator_32fc();
    volk_32fc_s32fc_x2_rotator_32fc(outVector, inVector, phase_inc, phase, num_points);
}

p_32fc_s32fc_x2_rotator_32fc volk_32fc_s32fc_x2_rotator_32fc_a = &__volk_32fc_s32fc_x2_rotator_32fc_a;
p_32fc_s32fc_x2_rotator_32fc volk_32fc_s32fc_x2_rotator_32fc_u = &__volk_32fc_s32fc_x2_rotator_32fc_u;
p_32fc_s32fc_x2_rotator_32fc volk_32fc_s32fc_x2_rotator_32fc   = &__volk_32fc_s32fc_x2_rotator_32fc;

void volk_32fc_s32fc_x2_rotator_32fc_manual(lv_32fc_t*  outVector, const lv_32fc_t*  inVector, const lv_32fc_t  phase_inc, lv_32fc_t*  phase, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_s32fc_x2_rotator_32fc_impl_names,
        get_machine()->volk_32fc_s32fc_x2_rotator_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_s32fc_x2_rotator_32fc_impls[index](
        outVector, inVector, phase_inc, phase, num_points
    );
}

volk_func_desc_t volk_32fc_s32fc_x2_rotator_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_s32fc_x2_rotator_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_s32fc_x2_rotator_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_s32fc_x2_rotator_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_s32fc_x2_rotator_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_x2_add_32fc_d(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_32fc_x2_add_32fc_a(cVector, aVector, bVector, num_points);
    }
    else{
        volk_32fc_x2_add_32fc_u(cVector, aVector, bVector, num_points);
    }
}

static inline void __init_volk_32fc_x2_add_32fc(void)
{
    const char *name = get_machine()->volk_32fc_x2_add_32fc_name;
    const char **impl_names = get_machine()->volk_32fc_x2_add_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_x2_add_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_x2_add_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_x2_add_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_x2_add_32fc_a = get_machine()->volk_32fc_x2_add_32fc_impls[index_a];
    volk_32fc_x2_add_32fc_u = get_machine()->volk_32fc_x2_add_32fc_impls[index_u];

    assert(volk_32fc_x2_add_32fc_a);
    assert(volk_32fc_x2_add_32fc_u);

    volk_32fc_x2_add_32fc = &__volk_32fc_x2_add_32fc_d;
}

static inline void __volk_32fc_x2_add_32fc_a(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points)
{
    __init_volk_32fc_x2_add_32fc();
    volk_32fc_x2_add_32fc_a(cVector, aVector, bVector, num_points);
}

static inline void __volk_32fc_x2_add_32fc_u(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points)
{
    __init_volk_32fc_x2_add_32fc();
    volk_32fc_x2_add_32fc_u(cVector, aVector, bVector, num_points);
}

static inline void __volk_32fc_x2_add_32fc(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points)
{
    __init_volk_32fc_x2_add_32fc();
    volk_32fc_x2_add_32fc(cVector, aVector, bVector, num_points);
}

p_32fc_x2_add_32fc volk_32fc_x2_add_32fc_a = &__volk_32fc_x2_add_32fc_a;
p_32fc_x2_add_32fc volk_32fc_x2_add_32fc_u = &__volk_32fc_x2_add_32fc_u;
p_32fc_x2_add_32fc volk_32fc_x2_add_32fc   = &__volk_32fc_x2_add_32fc;

void volk_32fc_x2_add_32fc_manual(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_x2_add_32fc_impl_names,
        get_machine()->volk_32fc_x2_add_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_x2_add_32fc_impls[index](
        cVector, aVector, bVector, num_points
    );
}

volk_func_desc_t volk_32fc_x2_add_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_x2_add_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_x2_add_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_x2_add_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_x2_add_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_x2_conjugate_dot_prod_32fc_d(lv_32fc_t*  result, const lv_32fc_t*  input, const lv_32fc_t*  taps, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(result,
        VOLK_OR_PTR(input,
        VOLK_OR_PTR(taps,
        0)))
    )){
        volk_32fc_x2_conjugate_dot_prod_32fc_a(result, input, taps, num_points);
    }
    else{
        volk_32fc_x2_conjugate_dot_prod_32fc_u(result, input, taps, num_points);
    }
}

static inline void __init_volk_32fc_x2_conjugate_dot_prod_32fc(void)
{
    const char *name = get_machine()->volk_32fc_x2_conjugate_dot_prod_32fc_name;
    const char **impl_names = get_machine()->volk_32fc_x2_conjugate_dot_prod_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_x2_conjugate_dot_prod_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_x2_conjugate_dot_prod_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_x2_conjugate_dot_prod_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_x2_conjugate_dot_prod_32fc_a = get_machine()->volk_32fc_x2_conjugate_dot_prod_32fc_impls[index_a];
    volk_32fc_x2_conjugate_dot_prod_32fc_u = get_machine()->volk_32fc_x2_conjugate_dot_prod_32fc_impls[index_u];

    assert(volk_32fc_x2_conjugate_dot_prod_32fc_a);
    assert(volk_32fc_x2_conjugate_dot_prod_32fc_u);

    volk_32fc_x2_conjugate_dot_prod_32fc = &__volk_32fc_x2_conjugate_dot_prod_32fc_d;
}

static inline void __volk_32fc_x2_conjugate_dot_prod_32fc_a(lv_32fc_t*  result, const lv_32fc_t*  input, const lv_32fc_t*  taps, unsigned int  num_points)
{
    __init_volk_32fc_x2_conjugate_dot_prod_32fc();
    volk_32fc_x2_conjugate_dot_prod_32fc_a(result, input, taps, num_points);
}

static inline void __volk_32fc_x2_conjugate_dot_prod_32fc_u(lv_32fc_t*  result, const lv_32fc_t*  input, const lv_32fc_t*  taps, unsigned int  num_points)
{
    __init_volk_32fc_x2_conjugate_dot_prod_32fc();
    volk_32fc_x2_conjugate_dot_prod_32fc_u(result, input, taps, num_points);
}

static inline void __volk_32fc_x2_conjugate_dot_prod_32fc(lv_32fc_t*  result, const lv_32fc_t*  input, const lv_32fc_t*  taps, unsigned int  num_points)
{
    __init_volk_32fc_x2_conjugate_dot_prod_32fc();
    volk_32fc_x2_conjugate_dot_prod_32fc(result, input, taps, num_points);
}

p_32fc_x2_conjugate_dot_prod_32fc volk_32fc_x2_conjugate_dot_prod_32fc_a = &__volk_32fc_x2_conjugate_dot_prod_32fc_a;
p_32fc_x2_conjugate_dot_prod_32fc volk_32fc_x2_conjugate_dot_prod_32fc_u = &__volk_32fc_x2_conjugate_dot_prod_32fc_u;
p_32fc_x2_conjugate_dot_prod_32fc volk_32fc_x2_conjugate_dot_prod_32fc   = &__volk_32fc_x2_conjugate_dot_prod_32fc;

void volk_32fc_x2_conjugate_dot_prod_32fc_manual(lv_32fc_t*  result, const lv_32fc_t*  input, const lv_32fc_t*  taps, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_x2_conjugate_dot_prod_32fc_impl_names,
        get_machine()->volk_32fc_x2_conjugate_dot_prod_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_x2_conjugate_dot_prod_32fc_impls[index](
        result, input, taps, num_points
    );
}

volk_func_desc_t volk_32fc_x2_conjugate_dot_prod_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_x2_conjugate_dot_prod_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_x2_conjugate_dot_prod_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_x2_conjugate_dot_prod_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_x2_conjugate_dot_prod_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_x2_divide_32fc_d(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_32fc_x2_divide_32fc_a(cVector, aVector, bVector, num_points);
    }
    else{
        volk_32fc_x2_divide_32fc_u(cVector, aVector, bVector, num_points);
    }
}

static inline void __init_volk_32fc_x2_divide_32fc(void)
{
    const char *name = get_machine()->volk_32fc_x2_divide_32fc_name;
    const char **impl_names = get_machine()->volk_32fc_x2_divide_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_x2_divide_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_x2_divide_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_x2_divide_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_x2_divide_32fc_a = get_machine()->volk_32fc_x2_divide_32fc_impls[index_a];
    volk_32fc_x2_divide_32fc_u = get_machine()->volk_32fc_x2_divide_32fc_impls[index_u];

    assert(volk_32fc_x2_divide_32fc_a);
    assert(volk_32fc_x2_divide_32fc_u);

    volk_32fc_x2_divide_32fc = &__volk_32fc_x2_divide_32fc_d;
}

static inline void __volk_32fc_x2_divide_32fc_a(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points)
{
    __init_volk_32fc_x2_divide_32fc();
    volk_32fc_x2_divide_32fc_a(cVector, aVector, bVector, num_points);
}

static inline void __volk_32fc_x2_divide_32fc_u(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points)
{
    __init_volk_32fc_x2_divide_32fc();
    volk_32fc_x2_divide_32fc_u(cVector, aVector, bVector, num_points);
}

static inline void __volk_32fc_x2_divide_32fc(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points)
{
    __init_volk_32fc_x2_divide_32fc();
    volk_32fc_x2_divide_32fc(cVector, aVector, bVector, num_points);
}

p_32fc_x2_divide_32fc volk_32fc_x2_divide_32fc_a = &__volk_32fc_x2_divide_32fc_a;
p_32fc_x2_divide_32fc volk_32fc_x2_divide_32fc_u = &__volk_32fc_x2_divide_32fc_u;
p_32fc_x2_divide_32fc volk_32fc_x2_divide_32fc   = &__volk_32fc_x2_divide_32fc;

void volk_32fc_x2_divide_32fc_manual(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_x2_divide_32fc_impl_names,
        get_machine()->volk_32fc_x2_divide_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_x2_divide_32fc_impls[index](
        cVector, aVector, bVector, num_points
    );
}

volk_func_desc_t volk_32fc_x2_divide_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_x2_divide_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_x2_divide_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_x2_divide_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_x2_divide_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_x2_dot_prod_32fc_d(lv_32fc_t*  result, const lv_32fc_t*  input, const lv_32fc_t*  taps, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(result,
        VOLK_OR_PTR(input,
        VOLK_OR_PTR(taps,
        0)))
    )){
        volk_32fc_x2_dot_prod_32fc_a(result, input, taps, num_points);
    }
    else{
        volk_32fc_x2_dot_prod_32fc_u(result, input, taps, num_points);
    }
}

static inline void __init_volk_32fc_x2_dot_prod_32fc(void)
{
    const char *name = get_machine()->volk_32fc_x2_dot_prod_32fc_name;
    const char **impl_names = get_machine()->volk_32fc_x2_dot_prod_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_x2_dot_prod_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_x2_dot_prod_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_x2_dot_prod_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_x2_dot_prod_32fc_a = get_machine()->volk_32fc_x2_dot_prod_32fc_impls[index_a];
    volk_32fc_x2_dot_prod_32fc_u = get_machine()->volk_32fc_x2_dot_prod_32fc_impls[index_u];

    assert(volk_32fc_x2_dot_prod_32fc_a);
    assert(volk_32fc_x2_dot_prod_32fc_u);

    volk_32fc_x2_dot_prod_32fc = &__volk_32fc_x2_dot_prod_32fc_d;
}

static inline void __volk_32fc_x2_dot_prod_32fc_a(lv_32fc_t*  result, const lv_32fc_t*  input, const lv_32fc_t*  taps, unsigned int  num_points)
{
    __init_volk_32fc_x2_dot_prod_32fc();
    volk_32fc_x2_dot_prod_32fc_a(result, input, taps, num_points);
}

static inline void __volk_32fc_x2_dot_prod_32fc_u(lv_32fc_t*  result, const lv_32fc_t*  input, const lv_32fc_t*  taps, unsigned int  num_points)
{
    __init_volk_32fc_x2_dot_prod_32fc();
    volk_32fc_x2_dot_prod_32fc_u(result, input, taps, num_points);
}

static inline void __volk_32fc_x2_dot_prod_32fc(lv_32fc_t*  result, const lv_32fc_t*  input, const lv_32fc_t*  taps, unsigned int  num_points)
{
    __init_volk_32fc_x2_dot_prod_32fc();
    volk_32fc_x2_dot_prod_32fc(result, input, taps, num_points);
}

p_32fc_x2_dot_prod_32fc volk_32fc_x2_dot_prod_32fc_a = &__volk_32fc_x2_dot_prod_32fc_a;
p_32fc_x2_dot_prod_32fc volk_32fc_x2_dot_prod_32fc_u = &__volk_32fc_x2_dot_prod_32fc_u;
p_32fc_x2_dot_prod_32fc volk_32fc_x2_dot_prod_32fc   = &__volk_32fc_x2_dot_prod_32fc;

void volk_32fc_x2_dot_prod_32fc_manual(lv_32fc_t*  result, const lv_32fc_t*  input, const lv_32fc_t*  taps, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_x2_dot_prod_32fc_impl_names,
        get_machine()->volk_32fc_x2_dot_prod_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_x2_dot_prod_32fc_impls[index](
        result, input, taps, num_points
    );
}

volk_func_desc_t volk_32fc_x2_dot_prod_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_x2_dot_prod_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_x2_dot_prod_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_x2_dot_prod_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_x2_dot_prod_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_x2_multiply_32fc_d(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_32fc_x2_multiply_32fc_a(cVector, aVector, bVector, num_points);
    }
    else{
        volk_32fc_x2_multiply_32fc_u(cVector, aVector, bVector, num_points);
    }
}

static inline void __init_volk_32fc_x2_multiply_32fc(void)
{
    const char *name = get_machine()->volk_32fc_x2_multiply_32fc_name;
    const char **impl_names = get_machine()->volk_32fc_x2_multiply_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_x2_multiply_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_x2_multiply_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_x2_multiply_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_x2_multiply_32fc_a = get_machine()->volk_32fc_x2_multiply_32fc_impls[index_a];
    volk_32fc_x2_multiply_32fc_u = get_machine()->volk_32fc_x2_multiply_32fc_impls[index_u];

    assert(volk_32fc_x2_multiply_32fc_a);
    assert(volk_32fc_x2_multiply_32fc_u);

    volk_32fc_x2_multiply_32fc = &__volk_32fc_x2_multiply_32fc_d;
}

static inline void __volk_32fc_x2_multiply_32fc_a(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points)
{
    __init_volk_32fc_x2_multiply_32fc();
    volk_32fc_x2_multiply_32fc_a(cVector, aVector, bVector, num_points);
}

static inline void __volk_32fc_x2_multiply_32fc_u(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points)
{
    __init_volk_32fc_x2_multiply_32fc();
    volk_32fc_x2_multiply_32fc_u(cVector, aVector, bVector, num_points);
}

static inline void __volk_32fc_x2_multiply_32fc(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points)
{
    __init_volk_32fc_x2_multiply_32fc();
    volk_32fc_x2_multiply_32fc(cVector, aVector, bVector, num_points);
}

p_32fc_x2_multiply_32fc volk_32fc_x2_multiply_32fc_a = &__volk_32fc_x2_multiply_32fc_a;
p_32fc_x2_multiply_32fc volk_32fc_x2_multiply_32fc_u = &__volk_32fc_x2_multiply_32fc_u;
p_32fc_x2_multiply_32fc volk_32fc_x2_multiply_32fc   = &__volk_32fc_x2_multiply_32fc;

void volk_32fc_x2_multiply_32fc_manual(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_x2_multiply_32fc_impl_names,
        get_machine()->volk_32fc_x2_multiply_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_x2_multiply_32fc_impls[index](
        cVector, aVector, bVector, num_points
    );
}

volk_func_desc_t volk_32fc_x2_multiply_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_x2_multiply_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_x2_multiply_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_x2_multiply_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_x2_multiply_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_x2_multiply_conjugate_32fc_d(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_32fc_x2_multiply_conjugate_32fc_a(cVector, aVector, bVector, num_points);
    }
    else{
        volk_32fc_x2_multiply_conjugate_32fc_u(cVector, aVector, bVector, num_points);
    }
}

static inline void __init_volk_32fc_x2_multiply_conjugate_32fc(void)
{
    const char *name = get_machine()->volk_32fc_x2_multiply_conjugate_32fc_name;
    const char **impl_names = get_machine()->volk_32fc_x2_multiply_conjugate_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_x2_multiply_conjugate_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_x2_multiply_conjugate_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_x2_multiply_conjugate_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_x2_multiply_conjugate_32fc_a = get_machine()->volk_32fc_x2_multiply_conjugate_32fc_impls[index_a];
    volk_32fc_x2_multiply_conjugate_32fc_u = get_machine()->volk_32fc_x2_multiply_conjugate_32fc_impls[index_u];

    assert(volk_32fc_x2_multiply_conjugate_32fc_a);
    assert(volk_32fc_x2_multiply_conjugate_32fc_u);

    volk_32fc_x2_multiply_conjugate_32fc = &__volk_32fc_x2_multiply_conjugate_32fc_d;
}

static inline void __volk_32fc_x2_multiply_conjugate_32fc_a(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points)
{
    __init_volk_32fc_x2_multiply_conjugate_32fc();
    volk_32fc_x2_multiply_conjugate_32fc_a(cVector, aVector, bVector, num_points);
}

static inline void __volk_32fc_x2_multiply_conjugate_32fc_u(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points)
{
    __init_volk_32fc_x2_multiply_conjugate_32fc();
    volk_32fc_x2_multiply_conjugate_32fc_u(cVector, aVector, bVector, num_points);
}

static inline void __volk_32fc_x2_multiply_conjugate_32fc(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points)
{
    __init_volk_32fc_x2_multiply_conjugate_32fc();
    volk_32fc_x2_multiply_conjugate_32fc(cVector, aVector, bVector, num_points);
}

p_32fc_x2_multiply_conjugate_32fc volk_32fc_x2_multiply_conjugate_32fc_a = &__volk_32fc_x2_multiply_conjugate_32fc_a;
p_32fc_x2_multiply_conjugate_32fc volk_32fc_x2_multiply_conjugate_32fc_u = &__volk_32fc_x2_multiply_conjugate_32fc_u;
p_32fc_x2_multiply_conjugate_32fc volk_32fc_x2_multiply_conjugate_32fc   = &__volk_32fc_x2_multiply_conjugate_32fc;

void volk_32fc_x2_multiply_conjugate_32fc_manual(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_x2_multiply_conjugate_32fc_impl_names,
        get_machine()->volk_32fc_x2_multiply_conjugate_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_x2_multiply_conjugate_32fc_impls[index](
        cVector, aVector, bVector, num_points
    );
}

volk_func_desc_t volk_32fc_x2_multiply_conjugate_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_x2_multiply_conjugate_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_x2_multiply_conjugate_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_x2_multiply_conjugate_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_x2_multiply_conjugate_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_x2_s32f_square_dist_scalar_mult_32f_d(float*  target, lv_32fc_t*  src0, lv_32fc_t*  points, float  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(target,
        VOLK_OR_PTR(src0,
        VOLK_OR_PTR(points,
        0)))
    )){
        volk_32fc_x2_s32f_square_dist_scalar_mult_32f_a(target, src0, points, scalar, num_points);
    }
    else{
        volk_32fc_x2_s32f_square_dist_scalar_mult_32f_u(target, src0, points, scalar, num_points);
    }
}

static inline void __init_volk_32fc_x2_s32f_square_dist_scalar_mult_32f(void)
{
    const char *name = get_machine()->volk_32fc_x2_s32f_square_dist_scalar_mult_32f_name;
    const char **impl_names = get_machine()->volk_32fc_x2_s32f_square_dist_scalar_mult_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_x2_s32f_square_dist_scalar_mult_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_x2_s32f_square_dist_scalar_mult_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_x2_s32f_square_dist_scalar_mult_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_x2_s32f_square_dist_scalar_mult_32f_a = get_machine()->volk_32fc_x2_s32f_square_dist_scalar_mult_32f_impls[index_a];
    volk_32fc_x2_s32f_square_dist_scalar_mult_32f_u = get_machine()->volk_32fc_x2_s32f_square_dist_scalar_mult_32f_impls[index_u];

    assert(volk_32fc_x2_s32f_square_dist_scalar_mult_32f_a);
    assert(volk_32fc_x2_s32f_square_dist_scalar_mult_32f_u);

    volk_32fc_x2_s32f_square_dist_scalar_mult_32f = &__volk_32fc_x2_s32f_square_dist_scalar_mult_32f_d;
}

static inline void __volk_32fc_x2_s32f_square_dist_scalar_mult_32f_a(float*  target, lv_32fc_t*  src0, lv_32fc_t*  points, float  scalar, unsigned int  num_points)
{
    __init_volk_32fc_x2_s32f_square_dist_scalar_mult_32f();
    volk_32fc_x2_s32f_square_dist_scalar_mult_32f_a(target, src0, points, scalar, num_points);
}

static inline void __volk_32fc_x2_s32f_square_dist_scalar_mult_32f_u(float*  target, lv_32fc_t*  src0, lv_32fc_t*  points, float  scalar, unsigned int  num_points)
{
    __init_volk_32fc_x2_s32f_square_dist_scalar_mult_32f();
    volk_32fc_x2_s32f_square_dist_scalar_mult_32f_u(target, src0, points, scalar, num_points);
}

static inline void __volk_32fc_x2_s32f_square_dist_scalar_mult_32f(float*  target, lv_32fc_t*  src0, lv_32fc_t*  points, float  scalar, unsigned int  num_points)
{
    __init_volk_32fc_x2_s32f_square_dist_scalar_mult_32f();
    volk_32fc_x2_s32f_square_dist_scalar_mult_32f(target, src0, points, scalar, num_points);
}

p_32fc_x2_s32f_square_dist_scalar_mult_32f volk_32fc_x2_s32f_square_dist_scalar_mult_32f_a = &__volk_32fc_x2_s32f_square_dist_scalar_mult_32f_a;
p_32fc_x2_s32f_square_dist_scalar_mult_32f volk_32fc_x2_s32f_square_dist_scalar_mult_32f_u = &__volk_32fc_x2_s32f_square_dist_scalar_mult_32f_u;
p_32fc_x2_s32f_square_dist_scalar_mult_32f volk_32fc_x2_s32f_square_dist_scalar_mult_32f   = &__volk_32fc_x2_s32f_square_dist_scalar_mult_32f;

void volk_32fc_x2_s32f_square_dist_scalar_mult_32f_manual(float*  target, lv_32fc_t*  src0, lv_32fc_t*  points, float  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_x2_s32f_square_dist_scalar_mult_32f_impl_names,
        get_machine()->volk_32fc_x2_s32f_square_dist_scalar_mult_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_x2_s32f_square_dist_scalar_mult_32f_impls[index](
        target, src0, points, scalar, num_points
    );
}

volk_func_desc_t volk_32fc_x2_s32f_square_dist_scalar_mult_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_x2_s32f_square_dist_scalar_mult_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_x2_s32f_square_dist_scalar_mult_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_x2_s32f_square_dist_scalar_mult_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_x2_s32f_square_dist_scalar_mult_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_d(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, const lv_32fc_t*  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        VOLK_OR_PTR(scalar,
        0))))
    )){
        volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_a(cVector, aVector, bVector, scalar, num_points);
    }
    else{
        volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_u(cVector, aVector, bVector, scalar, num_points);
    }
}

static inline void __init_volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc(void)
{
    const char *name = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_name;
    const char **impl_names = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_a = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_impls[index_a];
    volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_u = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_impls[index_u];

    assert(volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_a);
    assert(volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_u);

    volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc = &__volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_d;
}

static inline void __volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_a(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, const lv_32fc_t*  scalar, unsigned int  num_points)
{
    __init_volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc();
    volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_a(cVector, aVector, bVector, scalar, num_points);
}

static inline void __volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_u(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, const lv_32fc_t*  scalar, unsigned int  num_points)
{
    __init_volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc();
    volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_u(cVector, aVector, bVector, scalar, num_points);
}

static inline void __volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, const lv_32fc_t*  scalar, unsigned int  num_points)
{
    __init_volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc();
    volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc(cVector, aVector, bVector, scalar, num_points);
}

p_32fc_x2_s32fc_multiply_conjugate_add2_32fc volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_a = &__volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_a;
p_32fc_x2_s32fc_multiply_conjugate_add2_32fc volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_u = &__volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_u;
p_32fc_x2_s32fc_multiply_conjugate_add2_32fc volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc   = &__volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc;

void volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_manual(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, const lv_32fc_t*  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_impl_names,
        get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_impls[index](
        cVector, aVector, bVector, scalar, num_points
    );
}

volk_func_desc_t volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add2_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_d(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, const lv_32fc_t  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_a(cVector, aVector, bVector, scalar, num_points);
    }
    else{
        volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_u(cVector, aVector, bVector, scalar, num_points);
    }
}

static inline void __init_volk_32fc_x2_s32fc_multiply_conjugate_add_32fc(void)
{
    const char *name = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_name;
    const char **impl_names = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_a = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_impls[index_a];
    volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_u = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_impls[index_u];

    assert(volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_a);
    assert(volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_u);

    volk_32fc_x2_s32fc_multiply_conjugate_add_32fc = &__volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_d;
}

static inline void __volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_a(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, const lv_32fc_t  scalar, unsigned int  num_points)
{
    __init_volk_32fc_x2_s32fc_multiply_conjugate_add_32fc();
    volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_a(cVector, aVector, bVector, scalar, num_points);
}

static inline void __volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_u(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, const lv_32fc_t  scalar, unsigned int  num_points)
{
    __init_volk_32fc_x2_s32fc_multiply_conjugate_add_32fc();
    volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_u(cVector, aVector, bVector, scalar, num_points);
}

static inline void __volk_32fc_x2_s32fc_multiply_conjugate_add_32fc(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, const lv_32fc_t  scalar, unsigned int  num_points)
{
    __init_volk_32fc_x2_s32fc_multiply_conjugate_add_32fc();
    volk_32fc_x2_s32fc_multiply_conjugate_add_32fc(cVector, aVector, bVector, scalar, num_points);
}

p_32fc_x2_s32fc_multiply_conjugate_add_32fc volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_a = &__volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_a;
p_32fc_x2_s32fc_multiply_conjugate_add_32fc volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_u = &__volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_u;
p_32fc_x2_s32fc_multiply_conjugate_add_32fc volk_32fc_x2_s32fc_multiply_conjugate_add_32fc   = &__volk_32fc_x2_s32fc_multiply_conjugate_add_32fc;

void volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_manual(lv_32fc_t*  cVector, const lv_32fc_t*  aVector, const lv_32fc_t*  bVector, const lv_32fc_t  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_impl_names,
        get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_impls[index](
        cVector, aVector, bVector, scalar, num_points
    );
}

volk_func_desc_t volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_x2_s32fc_multiply_conjugate_add_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32fc_x2_square_dist_32f_d(float*  target, lv_32fc_t*  src0, lv_32fc_t*  points, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(target,
        VOLK_OR_PTR(src0,
        VOLK_OR_PTR(points,
        0)))
    )){
        volk_32fc_x2_square_dist_32f_a(target, src0, points, num_points);
    }
    else{
        volk_32fc_x2_square_dist_32f_u(target, src0, points, num_points);
    }
}

static inline void __init_volk_32fc_x2_square_dist_32f(void)
{
    const char *name = get_machine()->volk_32fc_x2_square_dist_32f_name;
    const char **impl_names = get_machine()->volk_32fc_x2_square_dist_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_x2_square_dist_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_x2_square_dist_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_x2_square_dist_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32fc_x2_square_dist_32f_a = get_machine()->volk_32fc_x2_square_dist_32f_impls[index_a];
    volk_32fc_x2_square_dist_32f_u = get_machine()->volk_32fc_x2_square_dist_32f_impls[index_u];

    assert(volk_32fc_x2_square_dist_32f_a);
    assert(volk_32fc_x2_square_dist_32f_u);

    volk_32fc_x2_square_dist_32f = &__volk_32fc_x2_square_dist_32f_d;
}

static inline void __volk_32fc_x2_square_dist_32f_a(float*  target, lv_32fc_t*  src0, lv_32fc_t*  points, unsigned int  num_points)
{
    __init_volk_32fc_x2_square_dist_32f();
    volk_32fc_x2_square_dist_32f_a(target, src0, points, num_points);
}

static inline void __volk_32fc_x2_square_dist_32f_u(float*  target, lv_32fc_t*  src0, lv_32fc_t*  points, unsigned int  num_points)
{
    __init_volk_32fc_x2_square_dist_32f();
    volk_32fc_x2_square_dist_32f_u(target, src0, points, num_points);
}

static inline void __volk_32fc_x2_square_dist_32f(float*  target, lv_32fc_t*  src0, lv_32fc_t*  points, unsigned int  num_points)
{
    __init_volk_32fc_x2_square_dist_32f();
    volk_32fc_x2_square_dist_32f(target, src0, points, num_points);
}

p_32fc_x2_square_dist_32f volk_32fc_x2_square_dist_32f_a = &__volk_32fc_x2_square_dist_32f_a;
p_32fc_x2_square_dist_32f volk_32fc_x2_square_dist_32f_u = &__volk_32fc_x2_square_dist_32f_u;
p_32fc_x2_square_dist_32f volk_32fc_x2_square_dist_32f   = &__volk_32fc_x2_square_dist_32f;

void volk_32fc_x2_square_dist_32f_manual(float*  target, lv_32fc_t*  src0, lv_32fc_t*  points, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32fc_x2_square_dist_32f_impl_names,
        get_machine()->volk_32fc_x2_square_dist_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32fc_x2_square_dist_32f_impls[index](
        target, src0, points, num_points
    );
}

volk_func_desc_t volk_32fc_x2_square_dist_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32fc_x2_square_dist_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32fc_x2_square_dist_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32fc_x2_square_dist_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32fc_x2_square_dist_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32i_s32f_convert_32f_d(float*  outputVector, const int32_t*  inputVector, const float  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outputVector,
        VOLK_OR_PTR(inputVector,
        0))
    )){
        volk_32i_s32f_convert_32f_a(outputVector, inputVector, scalar, num_points);
    }
    else{
        volk_32i_s32f_convert_32f_u(outputVector, inputVector, scalar, num_points);
    }
}

static inline void __init_volk_32i_s32f_convert_32f(void)
{
    const char *name = get_machine()->volk_32i_s32f_convert_32f_name;
    const char **impl_names = get_machine()->volk_32i_s32f_convert_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32i_s32f_convert_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32i_s32f_convert_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32i_s32f_convert_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32i_s32f_convert_32f_a = get_machine()->volk_32i_s32f_convert_32f_impls[index_a];
    volk_32i_s32f_convert_32f_u = get_machine()->volk_32i_s32f_convert_32f_impls[index_u];

    assert(volk_32i_s32f_convert_32f_a);
    assert(volk_32i_s32f_convert_32f_u);

    volk_32i_s32f_convert_32f = &__volk_32i_s32f_convert_32f_d;
}

static inline void __volk_32i_s32f_convert_32f_a(float*  outputVector, const int32_t*  inputVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32i_s32f_convert_32f();
    volk_32i_s32f_convert_32f_a(outputVector, inputVector, scalar, num_points);
}

static inline void __volk_32i_s32f_convert_32f_u(float*  outputVector, const int32_t*  inputVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32i_s32f_convert_32f();
    volk_32i_s32f_convert_32f_u(outputVector, inputVector, scalar, num_points);
}

static inline void __volk_32i_s32f_convert_32f(float*  outputVector, const int32_t*  inputVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_32i_s32f_convert_32f();
    volk_32i_s32f_convert_32f(outputVector, inputVector, scalar, num_points);
}

p_32i_s32f_convert_32f volk_32i_s32f_convert_32f_a = &__volk_32i_s32f_convert_32f_a;
p_32i_s32f_convert_32f volk_32i_s32f_convert_32f_u = &__volk_32i_s32f_convert_32f_u;
p_32i_s32f_convert_32f volk_32i_s32f_convert_32f   = &__volk_32i_s32f_convert_32f;

void volk_32i_s32f_convert_32f_manual(float*  outputVector, const int32_t*  inputVector, const float  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32i_s32f_convert_32f_impl_names,
        get_machine()->volk_32i_s32f_convert_32f_n_impls,
        impl_name
    );
    get_machine()->volk_32i_s32f_convert_32f_impls[index](
        outputVector, inputVector, scalar, num_points
    );
}

volk_func_desc_t volk_32i_s32f_convert_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32i_s32f_convert_32f_impl_names;
    const int *impl_deps = get_machine()->volk_32i_s32f_convert_32f_impl_deps;
    const bool *alignment = get_machine()->volk_32i_s32f_convert_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_32i_s32f_convert_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32i_x2_and_32i_d(int32_t*  cVector, const int32_t*  aVector, const int32_t*  bVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_32i_x2_and_32i_a(cVector, aVector, bVector, num_points);
    }
    else{
        volk_32i_x2_and_32i_u(cVector, aVector, bVector, num_points);
    }
}

static inline void __init_volk_32i_x2_and_32i(void)
{
    const char *name = get_machine()->volk_32i_x2_and_32i_name;
    const char **impl_names = get_machine()->volk_32i_x2_and_32i_impl_names;
    const int *impl_deps = get_machine()->volk_32i_x2_and_32i_impl_deps;
    const bool *alignment = get_machine()->volk_32i_x2_and_32i_impl_alignment;
    const size_t n_impls = get_machine()->volk_32i_x2_and_32i_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32i_x2_and_32i_a = get_machine()->volk_32i_x2_and_32i_impls[index_a];
    volk_32i_x2_and_32i_u = get_machine()->volk_32i_x2_and_32i_impls[index_u];

    assert(volk_32i_x2_and_32i_a);
    assert(volk_32i_x2_and_32i_u);

    volk_32i_x2_and_32i = &__volk_32i_x2_and_32i_d;
}

static inline void __volk_32i_x2_and_32i_a(int32_t*  cVector, const int32_t*  aVector, const int32_t*  bVector, unsigned int  num_points)
{
    __init_volk_32i_x2_and_32i();
    volk_32i_x2_and_32i_a(cVector, aVector, bVector, num_points);
}

static inline void __volk_32i_x2_and_32i_u(int32_t*  cVector, const int32_t*  aVector, const int32_t*  bVector, unsigned int  num_points)
{
    __init_volk_32i_x2_and_32i();
    volk_32i_x2_and_32i_u(cVector, aVector, bVector, num_points);
}

static inline void __volk_32i_x2_and_32i(int32_t*  cVector, const int32_t*  aVector, const int32_t*  bVector, unsigned int  num_points)
{
    __init_volk_32i_x2_and_32i();
    volk_32i_x2_and_32i(cVector, aVector, bVector, num_points);
}

p_32i_x2_and_32i volk_32i_x2_and_32i_a = &__volk_32i_x2_and_32i_a;
p_32i_x2_and_32i volk_32i_x2_and_32i_u = &__volk_32i_x2_and_32i_u;
p_32i_x2_and_32i volk_32i_x2_and_32i   = &__volk_32i_x2_and_32i;

void volk_32i_x2_and_32i_manual(int32_t*  cVector, const int32_t*  aVector, const int32_t*  bVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32i_x2_and_32i_impl_names,
        get_machine()->volk_32i_x2_and_32i_n_impls,
        impl_name
    );
    get_machine()->volk_32i_x2_and_32i_impls[index](
        cVector, aVector, bVector, num_points
    );
}

volk_func_desc_t volk_32i_x2_and_32i_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32i_x2_and_32i_impl_names;
    const int *impl_deps = get_machine()->volk_32i_x2_and_32i_impl_deps;
    const bool *alignment = get_machine()->volk_32i_x2_and_32i_impl_alignment;
    const size_t n_impls = get_machine()->volk_32i_x2_and_32i_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32i_x2_or_32i_d(int32_t*  cVector, const int32_t*  aVector, const int32_t*  bVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_32i_x2_or_32i_a(cVector, aVector, bVector, num_points);
    }
    else{
        volk_32i_x2_or_32i_u(cVector, aVector, bVector, num_points);
    }
}

static inline void __init_volk_32i_x2_or_32i(void)
{
    const char *name = get_machine()->volk_32i_x2_or_32i_name;
    const char **impl_names = get_machine()->volk_32i_x2_or_32i_impl_names;
    const int *impl_deps = get_machine()->volk_32i_x2_or_32i_impl_deps;
    const bool *alignment = get_machine()->volk_32i_x2_or_32i_impl_alignment;
    const size_t n_impls = get_machine()->volk_32i_x2_or_32i_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32i_x2_or_32i_a = get_machine()->volk_32i_x2_or_32i_impls[index_a];
    volk_32i_x2_or_32i_u = get_machine()->volk_32i_x2_or_32i_impls[index_u];

    assert(volk_32i_x2_or_32i_a);
    assert(volk_32i_x2_or_32i_u);

    volk_32i_x2_or_32i = &__volk_32i_x2_or_32i_d;
}

static inline void __volk_32i_x2_or_32i_a(int32_t*  cVector, const int32_t*  aVector, const int32_t*  bVector, unsigned int  num_points)
{
    __init_volk_32i_x2_or_32i();
    volk_32i_x2_or_32i_a(cVector, aVector, bVector, num_points);
}

static inline void __volk_32i_x2_or_32i_u(int32_t*  cVector, const int32_t*  aVector, const int32_t*  bVector, unsigned int  num_points)
{
    __init_volk_32i_x2_or_32i();
    volk_32i_x2_or_32i_u(cVector, aVector, bVector, num_points);
}

static inline void __volk_32i_x2_or_32i(int32_t*  cVector, const int32_t*  aVector, const int32_t*  bVector, unsigned int  num_points)
{
    __init_volk_32i_x2_or_32i();
    volk_32i_x2_or_32i(cVector, aVector, bVector, num_points);
}

p_32i_x2_or_32i volk_32i_x2_or_32i_a = &__volk_32i_x2_or_32i_a;
p_32i_x2_or_32i volk_32i_x2_or_32i_u = &__volk_32i_x2_or_32i_u;
p_32i_x2_or_32i volk_32i_x2_or_32i   = &__volk_32i_x2_or_32i;

void volk_32i_x2_or_32i_manual(int32_t*  cVector, const int32_t*  aVector, const int32_t*  bVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32i_x2_or_32i_impl_names,
        get_machine()->volk_32i_x2_or_32i_n_impls,
        impl_name
    );
    get_machine()->volk_32i_x2_or_32i_impls[index](
        cVector, aVector, bVector, num_points
    );
}

volk_func_desc_t volk_32i_x2_or_32i_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32i_x2_or_32i_impl_names;
    const int *impl_deps = get_machine()->volk_32i_x2_or_32i_impl_deps;
    const bool *alignment = get_machine()->volk_32i_x2_or_32i_impl_alignment;
    const size_t n_impls = get_machine()->volk_32i_x2_or_32i_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32u_byteswap_d(uint32_t*  intsToSwap, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(intsToSwap,
        0)
    )){
        volk_32u_byteswap_a(intsToSwap, num_points);
    }
    else{
        volk_32u_byteswap_u(intsToSwap, num_points);
    }
}

static inline void __init_volk_32u_byteswap(void)
{
    const char *name = get_machine()->volk_32u_byteswap_name;
    const char **impl_names = get_machine()->volk_32u_byteswap_impl_names;
    const int *impl_deps = get_machine()->volk_32u_byteswap_impl_deps;
    const bool *alignment = get_machine()->volk_32u_byteswap_impl_alignment;
    const size_t n_impls = get_machine()->volk_32u_byteswap_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32u_byteswap_a = get_machine()->volk_32u_byteswap_impls[index_a];
    volk_32u_byteswap_u = get_machine()->volk_32u_byteswap_impls[index_u];

    assert(volk_32u_byteswap_a);
    assert(volk_32u_byteswap_u);

    volk_32u_byteswap = &__volk_32u_byteswap_d;
}

static inline void __volk_32u_byteswap_a(uint32_t*  intsToSwap, unsigned int  num_points)
{
    __init_volk_32u_byteswap();
    volk_32u_byteswap_a(intsToSwap, num_points);
}

static inline void __volk_32u_byteswap_u(uint32_t*  intsToSwap, unsigned int  num_points)
{
    __init_volk_32u_byteswap();
    volk_32u_byteswap_u(intsToSwap, num_points);
}

static inline void __volk_32u_byteswap(uint32_t*  intsToSwap, unsigned int  num_points)
{
    __init_volk_32u_byteswap();
    volk_32u_byteswap(intsToSwap, num_points);
}

p_32u_byteswap volk_32u_byteswap_a = &__volk_32u_byteswap_a;
p_32u_byteswap volk_32u_byteswap_u = &__volk_32u_byteswap_u;
p_32u_byteswap volk_32u_byteswap   = &__volk_32u_byteswap;

void volk_32u_byteswap_manual(uint32_t*  intsToSwap, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32u_byteswap_impl_names,
        get_machine()->volk_32u_byteswap_n_impls,
        impl_name
    );
    get_machine()->volk_32u_byteswap_impls[index](
        intsToSwap, num_points
    );
}

volk_func_desc_t volk_32u_byteswap_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32u_byteswap_impl_names;
    const int *impl_deps = get_machine()->volk_32u_byteswap_impl_deps;
    const bool *alignment = get_machine()->volk_32u_byteswap_impl_alignment;
    const size_t n_impls = get_machine()->volk_32u_byteswap_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32u_byteswappuppet_32u_d(uint32_t*  output, uint32_t*  intsToSwap, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(output,
        VOLK_OR_PTR(intsToSwap,
        0))
    )){
        volk_32u_byteswappuppet_32u_a(output, intsToSwap, num_points);
    }
    else{
        volk_32u_byteswappuppet_32u_u(output, intsToSwap, num_points);
    }
}

static inline void __init_volk_32u_byteswappuppet_32u(void)
{
    const char *name = get_machine()->volk_32u_byteswappuppet_32u_name;
    const char **impl_names = get_machine()->volk_32u_byteswappuppet_32u_impl_names;
    const int *impl_deps = get_machine()->volk_32u_byteswappuppet_32u_impl_deps;
    const bool *alignment = get_machine()->volk_32u_byteswappuppet_32u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32u_byteswappuppet_32u_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32u_byteswappuppet_32u_a = get_machine()->volk_32u_byteswappuppet_32u_impls[index_a];
    volk_32u_byteswappuppet_32u_u = get_machine()->volk_32u_byteswappuppet_32u_impls[index_u];

    assert(volk_32u_byteswappuppet_32u_a);
    assert(volk_32u_byteswappuppet_32u_u);

    volk_32u_byteswappuppet_32u = &__volk_32u_byteswappuppet_32u_d;
}

static inline void __volk_32u_byteswappuppet_32u_a(uint32_t*  output, uint32_t*  intsToSwap, unsigned int  num_points)
{
    __init_volk_32u_byteswappuppet_32u();
    volk_32u_byteswappuppet_32u_a(output, intsToSwap, num_points);
}

static inline void __volk_32u_byteswappuppet_32u_u(uint32_t*  output, uint32_t*  intsToSwap, unsigned int  num_points)
{
    __init_volk_32u_byteswappuppet_32u();
    volk_32u_byteswappuppet_32u_u(output, intsToSwap, num_points);
}

static inline void __volk_32u_byteswappuppet_32u(uint32_t*  output, uint32_t*  intsToSwap, unsigned int  num_points)
{
    __init_volk_32u_byteswappuppet_32u();
    volk_32u_byteswappuppet_32u(output, intsToSwap, num_points);
}

p_32u_byteswappuppet_32u volk_32u_byteswappuppet_32u_a = &__volk_32u_byteswappuppet_32u_a;
p_32u_byteswappuppet_32u volk_32u_byteswappuppet_32u_u = &__volk_32u_byteswappuppet_32u_u;
p_32u_byteswappuppet_32u volk_32u_byteswappuppet_32u   = &__volk_32u_byteswappuppet_32u;

void volk_32u_byteswappuppet_32u_manual(uint32_t*  output, uint32_t*  intsToSwap, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32u_byteswappuppet_32u_impl_names,
        get_machine()->volk_32u_byteswappuppet_32u_n_impls,
        impl_name
    );
    get_machine()->volk_32u_byteswappuppet_32u_impls[index](
        output, intsToSwap, num_points
    );
}

volk_func_desc_t volk_32u_byteswappuppet_32u_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32u_byteswappuppet_32u_impl_names;
    const int *impl_deps = get_machine()->volk_32u_byteswappuppet_32u_impl_deps;
    const bool *alignment = get_machine()->volk_32u_byteswappuppet_32u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32u_byteswappuppet_32u_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32u_popcnt_d(uint32_t*  ret, const uint32_t  value)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(ret,
        0)
    )){
        volk_32u_popcnt_a(ret, value);
    }
    else{
        volk_32u_popcnt_u(ret, value);
    }
}

static inline void __init_volk_32u_popcnt(void)
{
    const char *name = get_machine()->volk_32u_popcnt_name;
    const char **impl_names = get_machine()->volk_32u_popcnt_impl_names;
    const int *impl_deps = get_machine()->volk_32u_popcnt_impl_deps;
    const bool *alignment = get_machine()->volk_32u_popcnt_impl_alignment;
    const size_t n_impls = get_machine()->volk_32u_popcnt_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32u_popcnt_a = get_machine()->volk_32u_popcnt_impls[index_a];
    volk_32u_popcnt_u = get_machine()->volk_32u_popcnt_impls[index_u];

    assert(volk_32u_popcnt_a);
    assert(volk_32u_popcnt_u);

    volk_32u_popcnt = &__volk_32u_popcnt_d;
}

static inline void __volk_32u_popcnt_a(uint32_t*  ret, const uint32_t  value)
{
    __init_volk_32u_popcnt();
    volk_32u_popcnt_a(ret, value);
}

static inline void __volk_32u_popcnt_u(uint32_t*  ret, const uint32_t  value)
{
    __init_volk_32u_popcnt();
    volk_32u_popcnt_u(ret, value);
}

static inline void __volk_32u_popcnt(uint32_t*  ret, const uint32_t  value)
{
    __init_volk_32u_popcnt();
    volk_32u_popcnt(ret, value);
}

p_32u_popcnt volk_32u_popcnt_a = &__volk_32u_popcnt_a;
p_32u_popcnt volk_32u_popcnt_u = &__volk_32u_popcnt_u;
p_32u_popcnt volk_32u_popcnt   = &__volk_32u_popcnt;

void volk_32u_popcnt_manual(uint32_t*  ret, const uint32_t  value, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32u_popcnt_impl_names,
        get_machine()->volk_32u_popcnt_n_impls,
        impl_name
    );
    get_machine()->volk_32u_popcnt_impls[index](
        ret, value
    );
}

volk_func_desc_t volk_32u_popcnt_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32u_popcnt_impl_names;
    const int *impl_deps = get_machine()->volk_32u_popcnt_impl_deps;
    const bool *alignment = get_machine()->volk_32u_popcnt_impl_alignment;
    const size_t n_impls = get_machine()->volk_32u_popcnt_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32u_popcntpuppet_32u_d(uint32_t*  outVector, const uint32_t*  inVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outVector,
        VOLK_OR_PTR(inVector,
        0))
    )){
        volk_32u_popcntpuppet_32u_a(outVector, inVector, num_points);
    }
    else{
        volk_32u_popcntpuppet_32u_u(outVector, inVector, num_points);
    }
}

static inline void __init_volk_32u_popcntpuppet_32u(void)
{
    const char *name = get_machine()->volk_32u_popcntpuppet_32u_name;
    const char **impl_names = get_machine()->volk_32u_popcntpuppet_32u_impl_names;
    const int *impl_deps = get_machine()->volk_32u_popcntpuppet_32u_impl_deps;
    const bool *alignment = get_machine()->volk_32u_popcntpuppet_32u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32u_popcntpuppet_32u_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32u_popcntpuppet_32u_a = get_machine()->volk_32u_popcntpuppet_32u_impls[index_a];
    volk_32u_popcntpuppet_32u_u = get_machine()->volk_32u_popcntpuppet_32u_impls[index_u];

    assert(volk_32u_popcntpuppet_32u_a);
    assert(volk_32u_popcntpuppet_32u_u);

    volk_32u_popcntpuppet_32u = &__volk_32u_popcntpuppet_32u_d;
}

static inline void __volk_32u_popcntpuppet_32u_a(uint32_t*  outVector, const uint32_t*  inVector, unsigned int  num_points)
{
    __init_volk_32u_popcntpuppet_32u();
    volk_32u_popcntpuppet_32u_a(outVector, inVector, num_points);
}

static inline void __volk_32u_popcntpuppet_32u_u(uint32_t*  outVector, const uint32_t*  inVector, unsigned int  num_points)
{
    __init_volk_32u_popcntpuppet_32u();
    volk_32u_popcntpuppet_32u_u(outVector, inVector, num_points);
}

static inline void __volk_32u_popcntpuppet_32u(uint32_t*  outVector, const uint32_t*  inVector, unsigned int  num_points)
{
    __init_volk_32u_popcntpuppet_32u();
    volk_32u_popcntpuppet_32u(outVector, inVector, num_points);
}

p_32u_popcntpuppet_32u volk_32u_popcntpuppet_32u_a = &__volk_32u_popcntpuppet_32u_a;
p_32u_popcntpuppet_32u volk_32u_popcntpuppet_32u_u = &__volk_32u_popcntpuppet_32u_u;
p_32u_popcntpuppet_32u volk_32u_popcntpuppet_32u   = &__volk_32u_popcntpuppet_32u;

void volk_32u_popcntpuppet_32u_manual(uint32_t*  outVector, const uint32_t*  inVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32u_popcntpuppet_32u_impl_names,
        get_machine()->volk_32u_popcntpuppet_32u_n_impls,
        impl_name
    );
    get_machine()->volk_32u_popcntpuppet_32u_impls[index](
        outVector, inVector, num_points
    );
}

volk_func_desc_t volk_32u_popcntpuppet_32u_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32u_popcntpuppet_32u_impl_names;
    const int *impl_deps = get_machine()->volk_32u_popcntpuppet_32u_impl_deps;
    const bool *alignment = get_machine()->volk_32u_popcntpuppet_32u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32u_popcntpuppet_32u_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_32u_reverse_32u_d(uint32_t*  out, const uint32_t*  in, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(out,
        VOLK_OR_PTR(in,
        0))
    )){
        volk_32u_reverse_32u_a(out, in, num_points);
    }
    else{
        volk_32u_reverse_32u_u(out, in, num_points);
    }
}

static inline void __init_volk_32u_reverse_32u(void)
{
    const char *name = get_machine()->volk_32u_reverse_32u_name;
    const char **impl_names = get_machine()->volk_32u_reverse_32u_impl_names;
    const int *impl_deps = get_machine()->volk_32u_reverse_32u_impl_deps;
    const bool *alignment = get_machine()->volk_32u_reverse_32u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32u_reverse_32u_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_32u_reverse_32u_a = get_machine()->volk_32u_reverse_32u_impls[index_a];
    volk_32u_reverse_32u_u = get_machine()->volk_32u_reverse_32u_impls[index_u];

    assert(volk_32u_reverse_32u_a);
    assert(volk_32u_reverse_32u_u);

    volk_32u_reverse_32u = &__volk_32u_reverse_32u_d;
}

static inline void __volk_32u_reverse_32u_a(uint32_t*  out, const uint32_t*  in, unsigned int  num_points)
{
    __init_volk_32u_reverse_32u();
    volk_32u_reverse_32u_a(out, in, num_points);
}

static inline void __volk_32u_reverse_32u_u(uint32_t*  out, const uint32_t*  in, unsigned int  num_points)
{
    __init_volk_32u_reverse_32u();
    volk_32u_reverse_32u_u(out, in, num_points);
}

static inline void __volk_32u_reverse_32u(uint32_t*  out, const uint32_t*  in, unsigned int  num_points)
{
    __init_volk_32u_reverse_32u();
    volk_32u_reverse_32u(out, in, num_points);
}

p_32u_reverse_32u volk_32u_reverse_32u_a = &__volk_32u_reverse_32u_a;
p_32u_reverse_32u volk_32u_reverse_32u_u = &__volk_32u_reverse_32u_u;
p_32u_reverse_32u volk_32u_reverse_32u   = &__volk_32u_reverse_32u;

void volk_32u_reverse_32u_manual(uint32_t*  out, const uint32_t*  in, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_32u_reverse_32u_impl_names,
        get_machine()->volk_32u_reverse_32u_n_impls,
        impl_name
    );
    get_machine()->volk_32u_reverse_32u_impls[index](
        out, in, num_points
    );
}

volk_func_desc_t volk_32u_reverse_32u_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_32u_reverse_32u_impl_names;
    const int *impl_deps = get_machine()->volk_32u_reverse_32u_impl_deps;
    const bool *alignment = get_machine()->volk_32u_reverse_32u_impl_alignment;
    const size_t n_impls = get_machine()->volk_32u_reverse_32u_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_64f_convert_32f_d(float*  outputVector, const double*  inputVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outputVector,
        VOLK_OR_PTR(inputVector,
        0))
    )){
        volk_64f_convert_32f_a(outputVector, inputVector, num_points);
    }
    else{
        volk_64f_convert_32f_u(outputVector, inputVector, num_points);
    }
}

static inline void __init_volk_64f_convert_32f(void)
{
    const char *name = get_machine()->volk_64f_convert_32f_name;
    const char **impl_names = get_machine()->volk_64f_convert_32f_impl_names;
    const int *impl_deps = get_machine()->volk_64f_convert_32f_impl_deps;
    const bool *alignment = get_machine()->volk_64f_convert_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_64f_convert_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_64f_convert_32f_a = get_machine()->volk_64f_convert_32f_impls[index_a];
    volk_64f_convert_32f_u = get_machine()->volk_64f_convert_32f_impls[index_u];

    assert(volk_64f_convert_32f_a);
    assert(volk_64f_convert_32f_u);

    volk_64f_convert_32f = &__volk_64f_convert_32f_d;
}

static inline void __volk_64f_convert_32f_a(float*  outputVector, const double*  inputVector, unsigned int  num_points)
{
    __init_volk_64f_convert_32f();
    volk_64f_convert_32f_a(outputVector, inputVector, num_points);
}

static inline void __volk_64f_convert_32f_u(float*  outputVector, const double*  inputVector, unsigned int  num_points)
{
    __init_volk_64f_convert_32f();
    volk_64f_convert_32f_u(outputVector, inputVector, num_points);
}

static inline void __volk_64f_convert_32f(float*  outputVector, const double*  inputVector, unsigned int  num_points)
{
    __init_volk_64f_convert_32f();
    volk_64f_convert_32f(outputVector, inputVector, num_points);
}

p_64f_convert_32f volk_64f_convert_32f_a = &__volk_64f_convert_32f_a;
p_64f_convert_32f volk_64f_convert_32f_u = &__volk_64f_convert_32f_u;
p_64f_convert_32f volk_64f_convert_32f   = &__volk_64f_convert_32f;

void volk_64f_convert_32f_manual(float*  outputVector, const double*  inputVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_64f_convert_32f_impl_names,
        get_machine()->volk_64f_convert_32f_n_impls,
        impl_name
    );
    get_machine()->volk_64f_convert_32f_impls[index](
        outputVector, inputVector, num_points
    );
}

volk_func_desc_t volk_64f_convert_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_64f_convert_32f_impl_names;
    const int *impl_deps = get_machine()->volk_64f_convert_32f_impl_deps;
    const bool *alignment = get_machine()->volk_64f_convert_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_64f_convert_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_64f_x2_add_64f_d(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_64f_x2_add_64f_a(cVector, aVector, bVector, num_points);
    }
    else{
        volk_64f_x2_add_64f_u(cVector, aVector, bVector, num_points);
    }
}

static inline void __init_volk_64f_x2_add_64f(void)
{
    const char *name = get_machine()->volk_64f_x2_add_64f_name;
    const char **impl_names = get_machine()->volk_64f_x2_add_64f_impl_names;
    const int *impl_deps = get_machine()->volk_64f_x2_add_64f_impl_deps;
    const bool *alignment = get_machine()->volk_64f_x2_add_64f_impl_alignment;
    const size_t n_impls = get_machine()->volk_64f_x2_add_64f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_64f_x2_add_64f_a = get_machine()->volk_64f_x2_add_64f_impls[index_a];
    volk_64f_x2_add_64f_u = get_machine()->volk_64f_x2_add_64f_impls[index_u];

    assert(volk_64f_x2_add_64f_a);
    assert(volk_64f_x2_add_64f_u);

    volk_64f_x2_add_64f = &__volk_64f_x2_add_64f_d;
}

static inline void __volk_64f_x2_add_64f_a(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points)
{
    __init_volk_64f_x2_add_64f();
    volk_64f_x2_add_64f_a(cVector, aVector, bVector, num_points);
}

static inline void __volk_64f_x2_add_64f_u(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points)
{
    __init_volk_64f_x2_add_64f();
    volk_64f_x2_add_64f_u(cVector, aVector, bVector, num_points);
}

static inline void __volk_64f_x2_add_64f(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points)
{
    __init_volk_64f_x2_add_64f();
    volk_64f_x2_add_64f(cVector, aVector, bVector, num_points);
}

p_64f_x2_add_64f volk_64f_x2_add_64f_a = &__volk_64f_x2_add_64f_a;
p_64f_x2_add_64f volk_64f_x2_add_64f_u = &__volk_64f_x2_add_64f_u;
p_64f_x2_add_64f volk_64f_x2_add_64f   = &__volk_64f_x2_add_64f;

void volk_64f_x2_add_64f_manual(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_64f_x2_add_64f_impl_names,
        get_machine()->volk_64f_x2_add_64f_n_impls,
        impl_name
    );
    get_machine()->volk_64f_x2_add_64f_impls[index](
        cVector, aVector, bVector, num_points
    );
}

volk_func_desc_t volk_64f_x2_add_64f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_64f_x2_add_64f_impl_names;
    const int *impl_deps = get_machine()->volk_64f_x2_add_64f_impl_deps;
    const bool *alignment = get_machine()->volk_64f_x2_add_64f_impl_alignment;
    const size_t n_impls = get_machine()->volk_64f_x2_add_64f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_64f_x2_max_64f_d(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_64f_x2_max_64f_a(cVector, aVector, bVector, num_points);
    }
    else{
        volk_64f_x2_max_64f_u(cVector, aVector, bVector, num_points);
    }
}

static inline void __init_volk_64f_x2_max_64f(void)
{
    const char *name = get_machine()->volk_64f_x2_max_64f_name;
    const char **impl_names = get_machine()->volk_64f_x2_max_64f_impl_names;
    const int *impl_deps = get_machine()->volk_64f_x2_max_64f_impl_deps;
    const bool *alignment = get_machine()->volk_64f_x2_max_64f_impl_alignment;
    const size_t n_impls = get_machine()->volk_64f_x2_max_64f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_64f_x2_max_64f_a = get_machine()->volk_64f_x2_max_64f_impls[index_a];
    volk_64f_x2_max_64f_u = get_machine()->volk_64f_x2_max_64f_impls[index_u];

    assert(volk_64f_x2_max_64f_a);
    assert(volk_64f_x2_max_64f_u);

    volk_64f_x2_max_64f = &__volk_64f_x2_max_64f_d;
}

static inline void __volk_64f_x2_max_64f_a(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points)
{
    __init_volk_64f_x2_max_64f();
    volk_64f_x2_max_64f_a(cVector, aVector, bVector, num_points);
}

static inline void __volk_64f_x2_max_64f_u(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points)
{
    __init_volk_64f_x2_max_64f();
    volk_64f_x2_max_64f_u(cVector, aVector, bVector, num_points);
}

static inline void __volk_64f_x2_max_64f(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points)
{
    __init_volk_64f_x2_max_64f();
    volk_64f_x2_max_64f(cVector, aVector, bVector, num_points);
}

p_64f_x2_max_64f volk_64f_x2_max_64f_a = &__volk_64f_x2_max_64f_a;
p_64f_x2_max_64f volk_64f_x2_max_64f_u = &__volk_64f_x2_max_64f_u;
p_64f_x2_max_64f volk_64f_x2_max_64f   = &__volk_64f_x2_max_64f;

void volk_64f_x2_max_64f_manual(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_64f_x2_max_64f_impl_names,
        get_machine()->volk_64f_x2_max_64f_n_impls,
        impl_name
    );
    get_machine()->volk_64f_x2_max_64f_impls[index](
        cVector, aVector, bVector, num_points
    );
}

volk_func_desc_t volk_64f_x2_max_64f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_64f_x2_max_64f_impl_names;
    const int *impl_deps = get_machine()->volk_64f_x2_max_64f_impl_deps;
    const bool *alignment = get_machine()->volk_64f_x2_max_64f_impl_alignment;
    const size_t n_impls = get_machine()->volk_64f_x2_max_64f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_64f_x2_min_64f_d(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_64f_x2_min_64f_a(cVector, aVector, bVector, num_points);
    }
    else{
        volk_64f_x2_min_64f_u(cVector, aVector, bVector, num_points);
    }
}

static inline void __init_volk_64f_x2_min_64f(void)
{
    const char *name = get_machine()->volk_64f_x2_min_64f_name;
    const char **impl_names = get_machine()->volk_64f_x2_min_64f_impl_names;
    const int *impl_deps = get_machine()->volk_64f_x2_min_64f_impl_deps;
    const bool *alignment = get_machine()->volk_64f_x2_min_64f_impl_alignment;
    const size_t n_impls = get_machine()->volk_64f_x2_min_64f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_64f_x2_min_64f_a = get_machine()->volk_64f_x2_min_64f_impls[index_a];
    volk_64f_x2_min_64f_u = get_machine()->volk_64f_x2_min_64f_impls[index_u];

    assert(volk_64f_x2_min_64f_a);
    assert(volk_64f_x2_min_64f_u);

    volk_64f_x2_min_64f = &__volk_64f_x2_min_64f_d;
}

static inline void __volk_64f_x2_min_64f_a(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points)
{
    __init_volk_64f_x2_min_64f();
    volk_64f_x2_min_64f_a(cVector, aVector, bVector, num_points);
}

static inline void __volk_64f_x2_min_64f_u(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points)
{
    __init_volk_64f_x2_min_64f();
    volk_64f_x2_min_64f_u(cVector, aVector, bVector, num_points);
}

static inline void __volk_64f_x2_min_64f(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points)
{
    __init_volk_64f_x2_min_64f();
    volk_64f_x2_min_64f(cVector, aVector, bVector, num_points);
}

p_64f_x2_min_64f volk_64f_x2_min_64f_a = &__volk_64f_x2_min_64f_a;
p_64f_x2_min_64f volk_64f_x2_min_64f_u = &__volk_64f_x2_min_64f_u;
p_64f_x2_min_64f volk_64f_x2_min_64f   = &__volk_64f_x2_min_64f;

void volk_64f_x2_min_64f_manual(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_64f_x2_min_64f_impl_names,
        get_machine()->volk_64f_x2_min_64f_n_impls,
        impl_name
    );
    get_machine()->volk_64f_x2_min_64f_impls[index](
        cVector, aVector, bVector, num_points
    );
}

volk_func_desc_t volk_64f_x2_min_64f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_64f_x2_min_64f_impl_names;
    const int *impl_deps = get_machine()->volk_64f_x2_min_64f_impl_deps;
    const bool *alignment = get_machine()->volk_64f_x2_min_64f_impl_alignment;
    const size_t n_impls = get_machine()->volk_64f_x2_min_64f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_64f_x2_multiply_64f_d(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_64f_x2_multiply_64f_a(cVector, aVector, bVector, num_points);
    }
    else{
        volk_64f_x2_multiply_64f_u(cVector, aVector, bVector, num_points);
    }
}

static inline void __init_volk_64f_x2_multiply_64f(void)
{
    const char *name = get_machine()->volk_64f_x2_multiply_64f_name;
    const char **impl_names = get_machine()->volk_64f_x2_multiply_64f_impl_names;
    const int *impl_deps = get_machine()->volk_64f_x2_multiply_64f_impl_deps;
    const bool *alignment = get_machine()->volk_64f_x2_multiply_64f_impl_alignment;
    const size_t n_impls = get_machine()->volk_64f_x2_multiply_64f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_64f_x2_multiply_64f_a = get_machine()->volk_64f_x2_multiply_64f_impls[index_a];
    volk_64f_x2_multiply_64f_u = get_machine()->volk_64f_x2_multiply_64f_impls[index_u];

    assert(volk_64f_x2_multiply_64f_a);
    assert(volk_64f_x2_multiply_64f_u);

    volk_64f_x2_multiply_64f = &__volk_64f_x2_multiply_64f_d;
}

static inline void __volk_64f_x2_multiply_64f_a(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points)
{
    __init_volk_64f_x2_multiply_64f();
    volk_64f_x2_multiply_64f_a(cVector, aVector, bVector, num_points);
}

static inline void __volk_64f_x2_multiply_64f_u(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points)
{
    __init_volk_64f_x2_multiply_64f();
    volk_64f_x2_multiply_64f_u(cVector, aVector, bVector, num_points);
}

static inline void __volk_64f_x2_multiply_64f(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points)
{
    __init_volk_64f_x2_multiply_64f();
    volk_64f_x2_multiply_64f(cVector, aVector, bVector, num_points);
}

p_64f_x2_multiply_64f volk_64f_x2_multiply_64f_a = &__volk_64f_x2_multiply_64f_a;
p_64f_x2_multiply_64f volk_64f_x2_multiply_64f_u = &__volk_64f_x2_multiply_64f_u;
p_64f_x2_multiply_64f volk_64f_x2_multiply_64f   = &__volk_64f_x2_multiply_64f;

void volk_64f_x2_multiply_64f_manual(double*  cVector, const double*  aVector, const double*  bVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_64f_x2_multiply_64f_impl_names,
        get_machine()->volk_64f_x2_multiply_64f_n_impls,
        impl_name
    );
    get_machine()->volk_64f_x2_multiply_64f_impls[index](
        cVector, aVector, bVector, num_points
    );
}

volk_func_desc_t volk_64f_x2_multiply_64f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_64f_x2_multiply_64f_impl_names;
    const int *impl_deps = get_machine()->volk_64f_x2_multiply_64f_impl_deps;
    const bool *alignment = get_machine()->volk_64f_x2_multiply_64f_impl_alignment;
    const size_t n_impls = get_machine()->volk_64f_x2_multiply_64f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_64u_byteswap_d(uint64_t*  intsToSwap, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(intsToSwap,
        0)
    )){
        volk_64u_byteswap_a(intsToSwap, num_points);
    }
    else{
        volk_64u_byteswap_u(intsToSwap, num_points);
    }
}

static inline void __init_volk_64u_byteswap(void)
{
    const char *name = get_machine()->volk_64u_byteswap_name;
    const char **impl_names = get_machine()->volk_64u_byteswap_impl_names;
    const int *impl_deps = get_machine()->volk_64u_byteswap_impl_deps;
    const bool *alignment = get_machine()->volk_64u_byteswap_impl_alignment;
    const size_t n_impls = get_machine()->volk_64u_byteswap_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_64u_byteswap_a = get_machine()->volk_64u_byteswap_impls[index_a];
    volk_64u_byteswap_u = get_machine()->volk_64u_byteswap_impls[index_u];

    assert(volk_64u_byteswap_a);
    assert(volk_64u_byteswap_u);

    volk_64u_byteswap = &__volk_64u_byteswap_d;
}

static inline void __volk_64u_byteswap_a(uint64_t*  intsToSwap, unsigned int  num_points)
{
    __init_volk_64u_byteswap();
    volk_64u_byteswap_a(intsToSwap, num_points);
}

static inline void __volk_64u_byteswap_u(uint64_t*  intsToSwap, unsigned int  num_points)
{
    __init_volk_64u_byteswap();
    volk_64u_byteswap_u(intsToSwap, num_points);
}

static inline void __volk_64u_byteswap(uint64_t*  intsToSwap, unsigned int  num_points)
{
    __init_volk_64u_byteswap();
    volk_64u_byteswap(intsToSwap, num_points);
}

p_64u_byteswap volk_64u_byteswap_a = &__volk_64u_byteswap_a;
p_64u_byteswap volk_64u_byteswap_u = &__volk_64u_byteswap_u;
p_64u_byteswap volk_64u_byteswap   = &__volk_64u_byteswap;

void volk_64u_byteswap_manual(uint64_t*  intsToSwap, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_64u_byteswap_impl_names,
        get_machine()->volk_64u_byteswap_n_impls,
        impl_name
    );
    get_machine()->volk_64u_byteswap_impls[index](
        intsToSwap, num_points
    );
}

volk_func_desc_t volk_64u_byteswap_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_64u_byteswap_impl_names;
    const int *impl_deps = get_machine()->volk_64u_byteswap_impl_deps;
    const bool *alignment = get_machine()->volk_64u_byteswap_impl_alignment;
    const size_t n_impls = get_machine()->volk_64u_byteswap_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_64u_byteswappuppet_64u_d(uint64_t*  output, uint64_t*  intsToSwap, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(output,
        VOLK_OR_PTR(intsToSwap,
        0))
    )){
        volk_64u_byteswappuppet_64u_a(output, intsToSwap, num_points);
    }
    else{
        volk_64u_byteswappuppet_64u_u(output, intsToSwap, num_points);
    }
}

static inline void __init_volk_64u_byteswappuppet_64u(void)
{
    const char *name = get_machine()->volk_64u_byteswappuppet_64u_name;
    const char **impl_names = get_machine()->volk_64u_byteswappuppet_64u_impl_names;
    const int *impl_deps = get_machine()->volk_64u_byteswappuppet_64u_impl_deps;
    const bool *alignment = get_machine()->volk_64u_byteswappuppet_64u_impl_alignment;
    const size_t n_impls = get_machine()->volk_64u_byteswappuppet_64u_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_64u_byteswappuppet_64u_a = get_machine()->volk_64u_byteswappuppet_64u_impls[index_a];
    volk_64u_byteswappuppet_64u_u = get_machine()->volk_64u_byteswappuppet_64u_impls[index_u];

    assert(volk_64u_byteswappuppet_64u_a);
    assert(volk_64u_byteswappuppet_64u_u);

    volk_64u_byteswappuppet_64u = &__volk_64u_byteswappuppet_64u_d;
}

static inline void __volk_64u_byteswappuppet_64u_a(uint64_t*  output, uint64_t*  intsToSwap, unsigned int  num_points)
{
    __init_volk_64u_byteswappuppet_64u();
    volk_64u_byteswappuppet_64u_a(output, intsToSwap, num_points);
}

static inline void __volk_64u_byteswappuppet_64u_u(uint64_t*  output, uint64_t*  intsToSwap, unsigned int  num_points)
{
    __init_volk_64u_byteswappuppet_64u();
    volk_64u_byteswappuppet_64u_u(output, intsToSwap, num_points);
}

static inline void __volk_64u_byteswappuppet_64u(uint64_t*  output, uint64_t*  intsToSwap, unsigned int  num_points)
{
    __init_volk_64u_byteswappuppet_64u();
    volk_64u_byteswappuppet_64u(output, intsToSwap, num_points);
}

p_64u_byteswappuppet_64u volk_64u_byteswappuppet_64u_a = &__volk_64u_byteswappuppet_64u_a;
p_64u_byteswappuppet_64u volk_64u_byteswappuppet_64u_u = &__volk_64u_byteswappuppet_64u_u;
p_64u_byteswappuppet_64u volk_64u_byteswappuppet_64u   = &__volk_64u_byteswappuppet_64u;

void volk_64u_byteswappuppet_64u_manual(uint64_t*  output, uint64_t*  intsToSwap, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_64u_byteswappuppet_64u_impl_names,
        get_machine()->volk_64u_byteswappuppet_64u_n_impls,
        impl_name
    );
    get_machine()->volk_64u_byteswappuppet_64u_impls[index](
        output, intsToSwap, num_points
    );
}

volk_func_desc_t volk_64u_byteswappuppet_64u_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_64u_byteswappuppet_64u_impl_names;
    const int *impl_deps = get_machine()->volk_64u_byteswappuppet_64u_impl_deps;
    const bool *alignment = get_machine()->volk_64u_byteswappuppet_64u_impl_alignment;
    const size_t n_impls = get_machine()->volk_64u_byteswappuppet_64u_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_64u_popcnt_d(uint64_t*  ret, const uint64_t  value)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(ret,
        0)
    )){
        volk_64u_popcnt_a(ret, value);
    }
    else{
        volk_64u_popcnt_u(ret, value);
    }
}

static inline void __init_volk_64u_popcnt(void)
{
    const char *name = get_machine()->volk_64u_popcnt_name;
    const char **impl_names = get_machine()->volk_64u_popcnt_impl_names;
    const int *impl_deps = get_machine()->volk_64u_popcnt_impl_deps;
    const bool *alignment = get_machine()->volk_64u_popcnt_impl_alignment;
    const size_t n_impls = get_machine()->volk_64u_popcnt_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_64u_popcnt_a = get_machine()->volk_64u_popcnt_impls[index_a];
    volk_64u_popcnt_u = get_machine()->volk_64u_popcnt_impls[index_u];

    assert(volk_64u_popcnt_a);
    assert(volk_64u_popcnt_u);

    volk_64u_popcnt = &__volk_64u_popcnt_d;
}

static inline void __volk_64u_popcnt_a(uint64_t*  ret, const uint64_t  value)
{
    __init_volk_64u_popcnt();
    volk_64u_popcnt_a(ret, value);
}

static inline void __volk_64u_popcnt_u(uint64_t*  ret, const uint64_t  value)
{
    __init_volk_64u_popcnt();
    volk_64u_popcnt_u(ret, value);
}

static inline void __volk_64u_popcnt(uint64_t*  ret, const uint64_t  value)
{
    __init_volk_64u_popcnt();
    volk_64u_popcnt(ret, value);
}

p_64u_popcnt volk_64u_popcnt_a = &__volk_64u_popcnt_a;
p_64u_popcnt volk_64u_popcnt_u = &__volk_64u_popcnt_u;
p_64u_popcnt volk_64u_popcnt   = &__volk_64u_popcnt;

void volk_64u_popcnt_manual(uint64_t*  ret, const uint64_t  value, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_64u_popcnt_impl_names,
        get_machine()->volk_64u_popcnt_n_impls,
        impl_name
    );
    get_machine()->volk_64u_popcnt_impls[index](
        ret, value
    );
}

volk_func_desc_t volk_64u_popcnt_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_64u_popcnt_impl_names;
    const int *impl_deps = get_machine()->volk_64u_popcnt_impl_deps;
    const bool *alignment = get_machine()->volk_64u_popcnt_impl_alignment;
    const size_t n_impls = get_machine()->volk_64u_popcnt_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_64u_popcntpuppet_64u_d(uint64_t*  outVector, const uint64_t*  inVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outVector,
        VOLK_OR_PTR(inVector,
        0))
    )){
        volk_64u_popcntpuppet_64u_a(outVector, inVector, num_points);
    }
    else{
        volk_64u_popcntpuppet_64u_u(outVector, inVector, num_points);
    }
}

static inline void __init_volk_64u_popcntpuppet_64u(void)
{
    const char *name = get_machine()->volk_64u_popcntpuppet_64u_name;
    const char **impl_names = get_machine()->volk_64u_popcntpuppet_64u_impl_names;
    const int *impl_deps = get_machine()->volk_64u_popcntpuppet_64u_impl_deps;
    const bool *alignment = get_machine()->volk_64u_popcntpuppet_64u_impl_alignment;
    const size_t n_impls = get_machine()->volk_64u_popcntpuppet_64u_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_64u_popcntpuppet_64u_a = get_machine()->volk_64u_popcntpuppet_64u_impls[index_a];
    volk_64u_popcntpuppet_64u_u = get_machine()->volk_64u_popcntpuppet_64u_impls[index_u];

    assert(volk_64u_popcntpuppet_64u_a);
    assert(volk_64u_popcntpuppet_64u_u);

    volk_64u_popcntpuppet_64u = &__volk_64u_popcntpuppet_64u_d;
}

static inline void __volk_64u_popcntpuppet_64u_a(uint64_t*  outVector, const uint64_t*  inVector, unsigned int  num_points)
{
    __init_volk_64u_popcntpuppet_64u();
    volk_64u_popcntpuppet_64u_a(outVector, inVector, num_points);
}

static inline void __volk_64u_popcntpuppet_64u_u(uint64_t*  outVector, const uint64_t*  inVector, unsigned int  num_points)
{
    __init_volk_64u_popcntpuppet_64u();
    volk_64u_popcntpuppet_64u_u(outVector, inVector, num_points);
}

static inline void __volk_64u_popcntpuppet_64u(uint64_t*  outVector, const uint64_t*  inVector, unsigned int  num_points)
{
    __init_volk_64u_popcntpuppet_64u();
    volk_64u_popcntpuppet_64u(outVector, inVector, num_points);
}

p_64u_popcntpuppet_64u volk_64u_popcntpuppet_64u_a = &__volk_64u_popcntpuppet_64u_a;
p_64u_popcntpuppet_64u volk_64u_popcntpuppet_64u_u = &__volk_64u_popcntpuppet_64u_u;
p_64u_popcntpuppet_64u volk_64u_popcntpuppet_64u   = &__volk_64u_popcntpuppet_64u;

void volk_64u_popcntpuppet_64u_manual(uint64_t*  outVector, const uint64_t*  inVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_64u_popcntpuppet_64u_impl_names,
        get_machine()->volk_64u_popcntpuppet_64u_n_impls,
        impl_name
    );
    get_machine()->volk_64u_popcntpuppet_64u_impls[index](
        outVector, inVector, num_points
    );
}

volk_func_desc_t volk_64u_popcntpuppet_64u_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_64u_popcntpuppet_64u_impl_names;
    const int *impl_deps = get_machine()->volk_64u_popcntpuppet_64u_impl_deps;
    const bool *alignment = get_machine()->volk_64u_popcntpuppet_64u_impl_alignment;
    const size_t n_impls = get_machine()->volk_64u_popcntpuppet_64u_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_8i_convert_16i_d(int16_t*  outputVector, const int8_t*  inputVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outputVector,
        VOLK_OR_PTR(inputVector,
        0))
    )){
        volk_8i_convert_16i_a(outputVector, inputVector, num_points);
    }
    else{
        volk_8i_convert_16i_u(outputVector, inputVector, num_points);
    }
}

static inline void __init_volk_8i_convert_16i(void)
{
    const char *name = get_machine()->volk_8i_convert_16i_name;
    const char **impl_names = get_machine()->volk_8i_convert_16i_impl_names;
    const int *impl_deps = get_machine()->volk_8i_convert_16i_impl_deps;
    const bool *alignment = get_machine()->volk_8i_convert_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_8i_convert_16i_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_8i_convert_16i_a = get_machine()->volk_8i_convert_16i_impls[index_a];
    volk_8i_convert_16i_u = get_machine()->volk_8i_convert_16i_impls[index_u];

    assert(volk_8i_convert_16i_a);
    assert(volk_8i_convert_16i_u);

    volk_8i_convert_16i = &__volk_8i_convert_16i_d;
}

static inline void __volk_8i_convert_16i_a(int16_t*  outputVector, const int8_t*  inputVector, unsigned int  num_points)
{
    __init_volk_8i_convert_16i();
    volk_8i_convert_16i_a(outputVector, inputVector, num_points);
}

static inline void __volk_8i_convert_16i_u(int16_t*  outputVector, const int8_t*  inputVector, unsigned int  num_points)
{
    __init_volk_8i_convert_16i();
    volk_8i_convert_16i_u(outputVector, inputVector, num_points);
}

static inline void __volk_8i_convert_16i(int16_t*  outputVector, const int8_t*  inputVector, unsigned int  num_points)
{
    __init_volk_8i_convert_16i();
    volk_8i_convert_16i(outputVector, inputVector, num_points);
}

p_8i_convert_16i volk_8i_convert_16i_a = &__volk_8i_convert_16i_a;
p_8i_convert_16i volk_8i_convert_16i_u = &__volk_8i_convert_16i_u;
p_8i_convert_16i volk_8i_convert_16i   = &__volk_8i_convert_16i;

void volk_8i_convert_16i_manual(int16_t*  outputVector, const int8_t*  inputVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_8i_convert_16i_impl_names,
        get_machine()->volk_8i_convert_16i_n_impls,
        impl_name
    );
    get_machine()->volk_8i_convert_16i_impls[index](
        outputVector, inputVector, num_points
    );
}

volk_func_desc_t volk_8i_convert_16i_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_8i_convert_16i_impl_names;
    const int *impl_deps = get_machine()->volk_8i_convert_16i_impl_deps;
    const bool *alignment = get_machine()->volk_8i_convert_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_8i_convert_16i_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_8i_s32f_convert_32f_d(float*  outputVector, const int8_t*  inputVector, const float  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(outputVector,
        VOLK_OR_PTR(inputVector,
        0))
    )){
        volk_8i_s32f_convert_32f_a(outputVector, inputVector, scalar, num_points);
    }
    else{
        volk_8i_s32f_convert_32f_u(outputVector, inputVector, scalar, num_points);
    }
}

static inline void __init_volk_8i_s32f_convert_32f(void)
{
    const char *name = get_machine()->volk_8i_s32f_convert_32f_name;
    const char **impl_names = get_machine()->volk_8i_s32f_convert_32f_impl_names;
    const int *impl_deps = get_machine()->volk_8i_s32f_convert_32f_impl_deps;
    const bool *alignment = get_machine()->volk_8i_s32f_convert_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_8i_s32f_convert_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_8i_s32f_convert_32f_a = get_machine()->volk_8i_s32f_convert_32f_impls[index_a];
    volk_8i_s32f_convert_32f_u = get_machine()->volk_8i_s32f_convert_32f_impls[index_u];

    assert(volk_8i_s32f_convert_32f_a);
    assert(volk_8i_s32f_convert_32f_u);

    volk_8i_s32f_convert_32f = &__volk_8i_s32f_convert_32f_d;
}

static inline void __volk_8i_s32f_convert_32f_a(float*  outputVector, const int8_t*  inputVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_8i_s32f_convert_32f();
    volk_8i_s32f_convert_32f_a(outputVector, inputVector, scalar, num_points);
}

static inline void __volk_8i_s32f_convert_32f_u(float*  outputVector, const int8_t*  inputVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_8i_s32f_convert_32f();
    volk_8i_s32f_convert_32f_u(outputVector, inputVector, scalar, num_points);
}

static inline void __volk_8i_s32f_convert_32f(float*  outputVector, const int8_t*  inputVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_8i_s32f_convert_32f();
    volk_8i_s32f_convert_32f(outputVector, inputVector, scalar, num_points);
}

p_8i_s32f_convert_32f volk_8i_s32f_convert_32f_a = &__volk_8i_s32f_convert_32f_a;
p_8i_s32f_convert_32f volk_8i_s32f_convert_32f_u = &__volk_8i_s32f_convert_32f_u;
p_8i_s32f_convert_32f volk_8i_s32f_convert_32f   = &__volk_8i_s32f_convert_32f;

void volk_8i_s32f_convert_32f_manual(float*  outputVector, const int8_t*  inputVector, const float  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_8i_s32f_convert_32f_impl_names,
        get_machine()->volk_8i_s32f_convert_32f_n_impls,
        impl_name
    );
    get_machine()->volk_8i_s32f_convert_32f_impls[index](
        outputVector, inputVector, scalar, num_points
    );
}

volk_func_desc_t volk_8i_s32f_convert_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_8i_s32f_convert_32f_impl_names;
    const int *impl_deps = get_machine()->volk_8i_s32f_convert_32f_impl_deps;
    const bool *alignment = get_machine()->volk_8i_s32f_convert_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_8i_s32f_convert_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_8ic_deinterleave_16i_x2_d(int16_t*  iBuffer, int16_t*  qBuffer, const lv_8sc_t*  complexVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(iBuffer,
        VOLK_OR_PTR(qBuffer,
        VOLK_OR_PTR(complexVector,
        0)))
    )){
        volk_8ic_deinterleave_16i_x2_a(iBuffer, qBuffer, complexVector, num_points);
    }
    else{
        volk_8ic_deinterleave_16i_x2_u(iBuffer, qBuffer, complexVector, num_points);
    }
}

static inline void __init_volk_8ic_deinterleave_16i_x2(void)
{
    const char *name = get_machine()->volk_8ic_deinterleave_16i_x2_name;
    const char **impl_names = get_machine()->volk_8ic_deinterleave_16i_x2_impl_names;
    const int *impl_deps = get_machine()->volk_8ic_deinterleave_16i_x2_impl_deps;
    const bool *alignment = get_machine()->volk_8ic_deinterleave_16i_x2_impl_alignment;
    const size_t n_impls = get_machine()->volk_8ic_deinterleave_16i_x2_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_8ic_deinterleave_16i_x2_a = get_machine()->volk_8ic_deinterleave_16i_x2_impls[index_a];
    volk_8ic_deinterleave_16i_x2_u = get_machine()->volk_8ic_deinterleave_16i_x2_impls[index_u];

    assert(volk_8ic_deinterleave_16i_x2_a);
    assert(volk_8ic_deinterleave_16i_x2_u);

    volk_8ic_deinterleave_16i_x2 = &__volk_8ic_deinterleave_16i_x2_d;
}

static inline void __volk_8ic_deinterleave_16i_x2_a(int16_t*  iBuffer, int16_t*  qBuffer, const lv_8sc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_8ic_deinterleave_16i_x2();
    volk_8ic_deinterleave_16i_x2_a(iBuffer, qBuffer, complexVector, num_points);
}

static inline void __volk_8ic_deinterleave_16i_x2_u(int16_t*  iBuffer, int16_t*  qBuffer, const lv_8sc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_8ic_deinterleave_16i_x2();
    volk_8ic_deinterleave_16i_x2_u(iBuffer, qBuffer, complexVector, num_points);
}

static inline void __volk_8ic_deinterleave_16i_x2(int16_t*  iBuffer, int16_t*  qBuffer, const lv_8sc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_8ic_deinterleave_16i_x2();
    volk_8ic_deinterleave_16i_x2(iBuffer, qBuffer, complexVector, num_points);
}

p_8ic_deinterleave_16i_x2 volk_8ic_deinterleave_16i_x2_a = &__volk_8ic_deinterleave_16i_x2_a;
p_8ic_deinterleave_16i_x2 volk_8ic_deinterleave_16i_x2_u = &__volk_8ic_deinterleave_16i_x2_u;
p_8ic_deinterleave_16i_x2 volk_8ic_deinterleave_16i_x2   = &__volk_8ic_deinterleave_16i_x2;

void volk_8ic_deinterleave_16i_x2_manual(int16_t*  iBuffer, int16_t*  qBuffer, const lv_8sc_t*  complexVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_8ic_deinterleave_16i_x2_impl_names,
        get_machine()->volk_8ic_deinterleave_16i_x2_n_impls,
        impl_name
    );
    get_machine()->volk_8ic_deinterleave_16i_x2_impls[index](
        iBuffer, qBuffer, complexVector, num_points
    );
}

volk_func_desc_t volk_8ic_deinterleave_16i_x2_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_8ic_deinterleave_16i_x2_impl_names;
    const int *impl_deps = get_machine()->volk_8ic_deinterleave_16i_x2_impl_deps;
    const bool *alignment = get_machine()->volk_8ic_deinterleave_16i_x2_impl_alignment;
    const size_t n_impls = get_machine()->volk_8ic_deinterleave_16i_x2_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_8ic_deinterleave_real_16i_d(int16_t*  iBuffer, const lv_8sc_t*  complexVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(iBuffer,
        VOLK_OR_PTR(complexVector,
        0))
    )){
        volk_8ic_deinterleave_real_16i_a(iBuffer, complexVector, num_points);
    }
    else{
        volk_8ic_deinterleave_real_16i_u(iBuffer, complexVector, num_points);
    }
}

static inline void __init_volk_8ic_deinterleave_real_16i(void)
{
    const char *name = get_machine()->volk_8ic_deinterleave_real_16i_name;
    const char **impl_names = get_machine()->volk_8ic_deinterleave_real_16i_impl_names;
    const int *impl_deps = get_machine()->volk_8ic_deinterleave_real_16i_impl_deps;
    const bool *alignment = get_machine()->volk_8ic_deinterleave_real_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_8ic_deinterleave_real_16i_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_8ic_deinterleave_real_16i_a = get_machine()->volk_8ic_deinterleave_real_16i_impls[index_a];
    volk_8ic_deinterleave_real_16i_u = get_machine()->volk_8ic_deinterleave_real_16i_impls[index_u];

    assert(volk_8ic_deinterleave_real_16i_a);
    assert(volk_8ic_deinterleave_real_16i_u);

    volk_8ic_deinterleave_real_16i = &__volk_8ic_deinterleave_real_16i_d;
}

static inline void __volk_8ic_deinterleave_real_16i_a(int16_t*  iBuffer, const lv_8sc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_8ic_deinterleave_real_16i();
    volk_8ic_deinterleave_real_16i_a(iBuffer, complexVector, num_points);
}

static inline void __volk_8ic_deinterleave_real_16i_u(int16_t*  iBuffer, const lv_8sc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_8ic_deinterleave_real_16i();
    volk_8ic_deinterleave_real_16i_u(iBuffer, complexVector, num_points);
}

static inline void __volk_8ic_deinterleave_real_16i(int16_t*  iBuffer, const lv_8sc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_8ic_deinterleave_real_16i();
    volk_8ic_deinterleave_real_16i(iBuffer, complexVector, num_points);
}

p_8ic_deinterleave_real_16i volk_8ic_deinterleave_real_16i_a = &__volk_8ic_deinterleave_real_16i_a;
p_8ic_deinterleave_real_16i volk_8ic_deinterleave_real_16i_u = &__volk_8ic_deinterleave_real_16i_u;
p_8ic_deinterleave_real_16i volk_8ic_deinterleave_real_16i   = &__volk_8ic_deinterleave_real_16i;

void volk_8ic_deinterleave_real_16i_manual(int16_t*  iBuffer, const lv_8sc_t*  complexVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_8ic_deinterleave_real_16i_impl_names,
        get_machine()->volk_8ic_deinterleave_real_16i_n_impls,
        impl_name
    );
    get_machine()->volk_8ic_deinterleave_real_16i_impls[index](
        iBuffer, complexVector, num_points
    );
}

volk_func_desc_t volk_8ic_deinterleave_real_16i_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_8ic_deinterleave_real_16i_impl_names;
    const int *impl_deps = get_machine()->volk_8ic_deinterleave_real_16i_impl_deps;
    const bool *alignment = get_machine()->volk_8ic_deinterleave_real_16i_impl_alignment;
    const size_t n_impls = get_machine()->volk_8ic_deinterleave_real_16i_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_8ic_deinterleave_real_8i_d(int8_t*  iBuffer, const lv_8sc_t*  complexVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(iBuffer,
        VOLK_OR_PTR(complexVector,
        0))
    )){
        volk_8ic_deinterleave_real_8i_a(iBuffer, complexVector, num_points);
    }
    else{
        volk_8ic_deinterleave_real_8i_u(iBuffer, complexVector, num_points);
    }
}

static inline void __init_volk_8ic_deinterleave_real_8i(void)
{
    const char *name = get_machine()->volk_8ic_deinterleave_real_8i_name;
    const char **impl_names = get_machine()->volk_8ic_deinterleave_real_8i_impl_names;
    const int *impl_deps = get_machine()->volk_8ic_deinterleave_real_8i_impl_deps;
    const bool *alignment = get_machine()->volk_8ic_deinterleave_real_8i_impl_alignment;
    const size_t n_impls = get_machine()->volk_8ic_deinterleave_real_8i_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_8ic_deinterleave_real_8i_a = get_machine()->volk_8ic_deinterleave_real_8i_impls[index_a];
    volk_8ic_deinterleave_real_8i_u = get_machine()->volk_8ic_deinterleave_real_8i_impls[index_u];

    assert(volk_8ic_deinterleave_real_8i_a);
    assert(volk_8ic_deinterleave_real_8i_u);

    volk_8ic_deinterleave_real_8i = &__volk_8ic_deinterleave_real_8i_d;
}

static inline void __volk_8ic_deinterleave_real_8i_a(int8_t*  iBuffer, const lv_8sc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_8ic_deinterleave_real_8i();
    volk_8ic_deinterleave_real_8i_a(iBuffer, complexVector, num_points);
}

static inline void __volk_8ic_deinterleave_real_8i_u(int8_t*  iBuffer, const lv_8sc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_8ic_deinterleave_real_8i();
    volk_8ic_deinterleave_real_8i_u(iBuffer, complexVector, num_points);
}

static inline void __volk_8ic_deinterleave_real_8i(int8_t*  iBuffer, const lv_8sc_t*  complexVector, unsigned int  num_points)
{
    __init_volk_8ic_deinterleave_real_8i();
    volk_8ic_deinterleave_real_8i(iBuffer, complexVector, num_points);
}

p_8ic_deinterleave_real_8i volk_8ic_deinterleave_real_8i_a = &__volk_8ic_deinterleave_real_8i_a;
p_8ic_deinterleave_real_8i volk_8ic_deinterleave_real_8i_u = &__volk_8ic_deinterleave_real_8i_u;
p_8ic_deinterleave_real_8i volk_8ic_deinterleave_real_8i   = &__volk_8ic_deinterleave_real_8i;

void volk_8ic_deinterleave_real_8i_manual(int8_t*  iBuffer, const lv_8sc_t*  complexVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_8ic_deinterleave_real_8i_impl_names,
        get_machine()->volk_8ic_deinterleave_real_8i_n_impls,
        impl_name
    );
    get_machine()->volk_8ic_deinterleave_real_8i_impls[index](
        iBuffer, complexVector, num_points
    );
}

volk_func_desc_t volk_8ic_deinterleave_real_8i_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_8ic_deinterleave_real_8i_impl_names;
    const int *impl_deps = get_machine()->volk_8ic_deinterleave_real_8i_impl_deps;
    const bool *alignment = get_machine()->volk_8ic_deinterleave_real_8i_impl_alignment;
    const size_t n_impls = get_machine()->volk_8ic_deinterleave_real_8i_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_8ic_s32f_deinterleave_32f_x2_d(float*  iBuffer, float*  qBuffer, const lv_8sc_t*  complexVector, const float  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(iBuffer,
        VOLK_OR_PTR(qBuffer,
        VOLK_OR_PTR(complexVector,
        0)))
    )){
        volk_8ic_s32f_deinterleave_32f_x2_a(iBuffer, qBuffer, complexVector, scalar, num_points);
    }
    else{
        volk_8ic_s32f_deinterleave_32f_x2_u(iBuffer, qBuffer, complexVector, scalar, num_points);
    }
}

static inline void __init_volk_8ic_s32f_deinterleave_32f_x2(void)
{
    const char *name = get_machine()->volk_8ic_s32f_deinterleave_32f_x2_name;
    const char **impl_names = get_machine()->volk_8ic_s32f_deinterleave_32f_x2_impl_names;
    const int *impl_deps = get_machine()->volk_8ic_s32f_deinterleave_32f_x2_impl_deps;
    const bool *alignment = get_machine()->volk_8ic_s32f_deinterleave_32f_x2_impl_alignment;
    const size_t n_impls = get_machine()->volk_8ic_s32f_deinterleave_32f_x2_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_8ic_s32f_deinterleave_32f_x2_a = get_machine()->volk_8ic_s32f_deinterleave_32f_x2_impls[index_a];
    volk_8ic_s32f_deinterleave_32f_x2_u = get_machine()->volk_8ic_s32f_deinterleave_32f_x2_impls[index_u];

    assert(volk_8ic_s32f_deinterleave_32f_x2_a);
    assert(volk_8ic_s32f_deinterleave_32f_x2_u);

    volk_8ic_s32f_deinterleave_32f_x2 = &__volk_8ic_s32f_deinterleave_32f_x2_d;
}

static inline void __volk_8ic_s32f_deinterleave_32f_x2_a(float*  iBuffer, float*  qBuffer, const lv_8sc_t*  complexVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_8ic_s32f_deinterleave_32f_x2();
    volk_8ic_s32f_deinterleave_32f_x2_a(iBuffer, qBuffer, complexVector, scalar, num_points);
}

static inline void __volk_8ic_s32f_deinterleave_32f_x2_u(float*  iBuffer, float*  qBuffer, const lv_8sc_t*  complexVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_8ic_s32f_deinterleave_32f_x2();
    volk_8ic_s32f_deinterleave_32f_x2_u(iBuffer, qBuffer, complexVector, scalar, num_points);
}

static inline void __volk_8ic_s32f_deinterleave_32f_x2(float*  iBuffer, float*  qBuffer, const lv_8sc_t*  complexVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_8ic_s32f_deinterleave_32f_x2();
    volk_8ic_s32f_deinterleave_32f_x2(iBuffer, qBuffer, complexVector, scalar, num_points);
}

p_8ic_s32f_deinterleave_32f_x2 volk_8ic_s32f_deinterleave_32f_x2_a = &__volk_8ic_s32f_deinterleave_32f_x2_a;
p_8ic_s32f_deinterleave_32f_x2 volk_8ic_s32f_deinterleave_32f_x2_u = &__volk_8ic_s32f_deinterleave_32f_x2_u;
p_8ic_s32f_deinterleave_32f_x2 volk_8ic_s32f_deinterleave_32f_x2   = &__volk_8ic_s32f_deinterleave_32f_x2;

void volk_8ic_s32f_deinterleave_32f_x2_manual(float*  iBuffer, float*  qBuffer, const lv_8sc_t*  complexVector, const float  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_8ic_s32f_deinterleave_32f_x2_impl_names,
        get_machine()->volk_8ic_s32f_deinterleave_32f_x2_n_impls,
        impl_name
    );
    get_machine()->volk_8ic_s32f_deinterleave_32f_x2_impls[index](
        iBuffer, qBuffer, complexVector, scalar, num_points
    );
}

volk_func_desc_t volk_8ic_s32f_deinterleave_32f_x2_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_8ic_s32f_deinterleave_32f_x2_impl_names;
    const int *impl_deps = get_machine()->volk_8ic_s32f_deinterleave_32f_x2_impl_deps;
    const bool *alignment = get_machine()->volk_8ic_s32f_deinterleave_32f_x2_impl_alignment;
    const size_t n_impls = get_machine()->volk_8ic_s32f_deinterleave_32f_x2_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_8ic_s32f_deinterleave_real_32f_d(float*  iBuffer, const lv_8sc_t*  complexVector, const float  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(iBuffer,
        VOLK_OR_PTR(complexVector,
        0))
    )){
        volk_8ic_s32f_deinterleave_real_32f_a(iBuffer, complexVector, scalar, num_points);
    }
    else{
        volk_8ic_s32f_deinterleave_real_32f_u(iBuffer, complexVector, scalar, num_points);
    }
}

static inline void __init_volk_8ic_s32f_deinterleave_real_32f(void)
{
    const char *name = get_machine()->volk_8ic_s32f_deinterleave_real_32f_name;
    const char **impl_names = get_machine()->volk_8ic_s32f_deinterleave_real_32f_impl_names;
    const int *impl_deps = get_machine()->volk_8ic_s32f_deinterleave_real_32f_impl_deps;
    const bool *alignment = get_machine()->volk_8ic_s32f_deinterleave_real_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_8ic_s32f_deinterleave_real_32f_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_8ic_s32f_deinterleave_real_32f_a = get_machine()->volk_8ic_s32f_deinterleave_real_32f_impls[index_a];
    volk_8ic_s32f_deinterleave_real_32f_u = get_machine()->volk_8ic_s32f_deinterleave_real_32f_impls[index_u];

    assert(volk_8ic_s32f_deinterleave_real_32f_a);
    assert(volk_8ic_s32f_deinterleave_real_32f_u);

    volk_8ic_s32f_deinterleave_real_32f = &__volk_8ic_s32f_deinterleave_real_32f_d;
}

static inline void __volk_8ic_s32f_deinterleave_real_32f_a(float*  iBuffer, const lv_8sc_t*  complexVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_8ic_s32f_deinterleave_real_32f();
    volk_8ic_s32f_deinterleave_real_32f_a(iBuffer, complexVector, scalar, num_points);
}

static inline void __volk_8ic_s32f_deinterleave_real_32f_u(float*  iBuffer, const lv_8sc_t*  complexVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_8ic_s32f_deinterleave_real_32f();
    volk_8ic_s32f_deinterleave_real_32f_u(iBuffer, complexVector, scalar, num_points);
}

static inline void __volk_8ic_s32f_deinterleave_real_32f(float*  iBuffer, const lv_8sc_t*  complexVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_8ic_s32f_deinterleave_real_32f();
    volk_8ic_s32f_deinterleave_real_32f(iBuffer, complexVector, scalar, num_points);
}

p_8ic_s32f_deinterleave_real_32f volk_8ic_s32f_deinterleave_real_32f_a = &__volk_8ic_s32f_deinterleave_real_32f_a;
p_8ic_s32f_deinterleave_real_32f volk_8ic_s32f_deinterleave_real_32f_u = &__volk_8ic_s32f_deinterleave_real_32f_u;
p_8ic_s32f_deinterleave_real_32f volk_8ic_s32f_deinterleave_real_32f   = &__volk_8ic_s32f_deinterleave_real_32f;

void volk_8ic_s32f_deinterleave_real_32f_manual(float*  iBuffer, const lv_8sc_t*  complexVector, const float  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_8ic_s32f_deinterleave_real_32f_impl_names,
        get_machine()->volk_8ic_s32f_deinterleave_real_32f_n_impls,
        impl_name
    );
    get_machine()->volk_8ic_s32f_deinterleave_real_32f_impls[index](
        iBuffer, complexVector, scalar, num_points
    );
}

volk_func_desc_t volk_8ic_s32f_deinterleave_real_32f_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_8ic_s32f_deinterleave_real_32f_impl_names;
    const int *impl_deps = get_machine()->volk_8ic_s32f_deinterleave_real_32f_impl_deps;
    const bool *alignment = get_machine()->volk_8ic_s32f_deinterleave_real_32f_impl_alignment;
    const size_t n_impls = get_machine()->volk_8ic_s32f_deinterleave_real_32f_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_8ic_x2_multiply_conjugate_16ic_d(lv_16sc_t*  cVector, const lv_8sc_t*  aVector, const lv_8sc_t*  bVector, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_8ic_x2_multiply_conjugate_16ic_a(cVector, aVector, bVector, num_points);
    }
    else{
        volk_8ic_x2_multiply_conjugate_16ic_u(cVector, aVector, bVector, num_points);
    }
}

static inline void __init_volk_8ic_x2_multiply_conjugate_16ic(void)
{
    const char *name = get_machine()->volk_8ic_x2_multiply_conjugate_16ic_name;
    const char **impl_names = get_machine()->volk_8ic_x2_multiply_conjugate_16ic_impl_names;
    const int *impl_deps = get_machine()->volk_8ic_x2_multiply_conjugate_16ic_impl_deps;
    const bool *alignment = get_machine()->volk_8ic_x2_multiply_conjugate_16ic_impl_alignment;
    const size_t n_impls = get_machine()->volk_8ic_x2_multiply_conjugate_16ic_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_8ic_x2_multiply_conjugate_16ic_a = get_machine()->volk_8ic_x2_multiply_conjugate_16ic_impls[index_a];
    volk_8ic_x2_multiply_conjugate_16ic_u = get_machine()->volk_8ic_x2_multiply_conjugate_16ic_impls[index_u];

    assert(volk_8ic_x2_multiply_conjugate_16ic_a);
    assert(volk_8ic_x2_multiply_conjugate_16ic_u);

    volk_8ic_x2_multiply_conjugate_16ic = &__volk_8ic_x2_multiply_conjugate_16ic_d;
}

static inline void __volk_8ic_x2_multiply_conjugate_16ic_a(lv_16sc_t*  cVector, const lv_8sc_t*  aVector, const lv_8sc_t*  bVector, unsigned int  num_points)
{
    __init_volk_8ic_x2_multiply_conjugate_16ic();
    volk_8ic_x2_multiply_conjugate_16ic_a(cVector, aVector, bVector, num_points);
}

static inline void __volk_8ic_x2_multiply_conjugate_16ic_u(lv_16sc_t*  cVector, const lv_8sc_t*  aVector, const lv_8sc_t*  bVector, unsigned int  num_points)
{
    __init_volk_8ic_x2_multiply_conjugate_16ic();
    volk_8ic_x2_multiply_conjugate_16ic_u(cVector, aVector, bVector, num_points);
}

static inline void __volk_8ic_x2_multiply_conjugate_16ic(lv_16sc_t*  cVector, const lv_8sc_t*  aVector, const lv_8sc_t*  bVector, unsigned int  num_points)
{
    __init_volk_8ic_x2_multiply_conjugate_16ic();
    volk_8ic_x2_multiply_conjugate_16ic(cVector, aVector, bVector, num_points);
}

p_8ic_x2_multiply_conjugate_16ic volk_8ic_x2_multiply_conjugate_16ic_a = &__volk_8ic_x2_multiply_conjugate_16ic_a;
p_8ic_x2_multiply_conjugate_16ic volk_8ic_x2_multiply_conjugate_16ic_u = &__volk_8ic_x2_multiply_conjugate_16ic_u;
p_8ic_x2_multiply_conjugate_16ic volk_8ic_x2_multiply_conjugate_16ic   = &__volk_8ic_x2_multiply_conjugate_16ic;

void volk_8ic_x2_multiply_conjugate_16ic_manual(lv_16sc_t*  cVector, const lv_8sc_t*  aVector, const lv_8sc_t*  bVector, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_8ic_x2_multiply_conjugate_16ic_impl_names,
        get_machine()->volk_8ic_x2_multiply_conjugate_16ic_n_impls,
        impl_name
    );
    get_machine()->volk_8ic_x2_multiply_conjugate_16ic_impls[index](
        cVector, aVector, bVector, num_points
    );
}

volk_func_desc_t volk_8ic_x2_multiply_conjugate_16ic_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_8ic_x2_multiply_conjugate_16ic_impl_names;
    const int *impl_deps = get_machine()->volk_8ic_x2_multiply_conjugate_16ic_impl_deps;
    const bool *alignment = get_machine()->volk_8ic_x2_multiply_conjugate_16ic_impl_alignment;
    const size_t n_impls = get_machine()->volk_8ic_x2_multiply_conjugate_16ic_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_8ic_x2_s32f_multiply_conjugate_32fc_d(lv_32fc_t*  cVector, const lv_8sc_t*  aVector, const lv_8sc_t*  bVector, const float  scalar, unsigned int  num_points)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(cVector,
        VOLK_OR_PTR(aVector,
        VOLK_OR_PTR(bVector,
        0)))
    )){
        volk_8ic_x2_s32f_multiply_conjugate_32fc_a(cVector, aVector, bVector, scalar, num_points);
    }
    else{
        volk_8ic_x2_s32f_multiply_conjugate_32fc_u(cVector, aVector, bVector, scalar, num_points);
    }
}

static inline void __init_volk_8ic_x2_s32f_multiply_conjugate_32fc(void)
{
    const char *name = get_machine()->volk_8ic_x2_s32f_multiply_conjugate_32fc_name;
    const char **impl_names = get_machine()->volk_8ic_x2_s32f_multiply_conjugate_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_8ic_x2_s32f_multiply_conjugate_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_8ic_x2_s32f_multiply_conjugate_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_8ic_x2_s32f_multiply_conjugate_32fc_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_8ic_x2_s32f_multiply_conjugate_32fc_a = get_machine()->volk_8ic_x2_s32f_multiply_conjugate_32fc_impls[index_a];
    volk_8ic_x2_s32f_multiply_conjugate_32fc_u = get_machine()->volk_8ic_x2_s32f_multiply_conjugate_32fc_impls[index_u];

    assert(volk_8ic_x2_s32f_multiply_conjugate_32fc_a);
    assert(volk_8ic_x2_s32f_multiply_conjugate_32fc_u);

    volk_8ic_x2_s32f_multiply_conjugate_32fc = &__volk_8ic_x2_s32f_multiply_conjugate_32fc_d;
}

static inline void __volk_8ic_x2_s32f_multiply_conjugate_32fc_a(lv_32fc_t*  cVector, const lv_8sc_t*  aVector, const lv_8sc_t*  bVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_8ic_x2_s32f_multiply_conjugate_32fc();
    volk_8ic_x2_s32f_multiply_conjugate_32fc_a(cVector, aVector, bVector, scalar, num_points);
}

static inline void __volk_8ic_x2_s32f_multiply_conjugate_32fc_u(lv_32fc_t*  cVector, const lv_8sc_t*  aVector, const lv_8sc_t*  bVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_8ic_x2_s32f_multiply_conjugate_32fc();
    volk_8ic_x2_s32f_multiply_conjugate_32fc_u(cVector, aVector, bVector, scalar, num_points);
}

static inline void __volk_8ic_x2_s32f_multiply_conjugate_32fc(lv_32fc_t*  cVector, const lv_8sc_t*  aVector, const lv_8sc_t*  bVector, const float  scalar, unsigned int  num_points)
{
    __init_volk_8ic_x2_s32f_multiply_conjugate_32fc();
    volk_8ic_x2_s32f_multiply_conjugate_32fc(cVector, aVector, bVector, scalar, num_points);
}

p_8ic_x2_s32f_multiply_conjugate_32fc volk_8ic_x2_s32f_multiply_conjugate_32fc_a = &__volk_8ic_x2_s32f_multiply_conjugate_32fc_a;
p_8ic_x2_s32f_multiply_conjugate_32fc volk_8ic_x2_s32f_multiply_conjugate_32fc_u = &__volk_8ic_x2_s32f_multiply_conjugate_32fc_u;
p_8ic_x2_s32f_multiply_conjugate_32fc volk_8ic_x2_s32f_multiply_conjugate_32fc   = &__volk_8ic_x2_s32f_multiply_conjugate_32fc;

void volk_8ic_x2_s32f_multiply_conjugate_32fc_manual(lv_32fc_t*  cVector, const lv_8sc_t*  aVector, const lv_8sc_t*  bVector, const float  scalar, unsigned int  num_points, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_8ic_x2_s32f_multiply_conjugate_32fc_impl_names,
        get_machine()->volk_8ic_x2_s32f_multiply_conjugate_32fc_n_impls,
        impl_name
    );
    get_machine()->volk_8ic_x2_s32f_multiply_conjugate_32fc_impls[index](
        cVector, aVector, bVector, scalar, num_points
    );
}

volk_func_desc_t volk_8ic_x2_s32f_multiply_conjugate_32fc_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_8ic_x2_s32f_multiply_conjugate_32fc_impl_names;
    const int *impl_deps = get_machine()->volk_8ic_x2_s32f_multiply_conjugate_32fc_impl_deps;
    const bool *alignment = get_machine()->volk_8ic_x2_s32f_multiply_conjugate_32fc_impl_alignment;
    const size_t n_impls = get_machine()->volk_8ic_x2_s32f_multiply_conjugate_32fc_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_8u_conv_k7_r2puppet_8u_d(unsigned char*  dec, unsigned char*  syms, unsigned int  framebits)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(dec,
        VOLK_OR_PTR(syms,
        0))
    )){
        volk_8u_conv_k7_r2puppet_8u_a(dec, syms, framebits);
    }
    else{
        volk_8u_conv_k7_r2puppet_8u_u(dec, syms, framebits);
    }
}

static inline void __init_volk_8u_conv_k7_r2puppet_8u(void)
{
    const char *name = get_machine()->volk_8u_conv_k7_r2puppet_8u_name;
    const char **impl_names = get_machine()->volk_8u_conv_k7_r2puppet_8u_impl_names;
    const int *impl_deps = get_machine()->volk_8u_conv_k7_r2puppet_8u_impl_deps;
    const bool *alignment = get_machine()->volk_8u_conv_k7_r2puppet_8u_impl_alignment;
    const size_t n_impls = get_machine()->volk_8u_conv_k7_r2puppet_8u_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_8u_conv_k7_r2puppet_8u_a = get_machine()->volk_8u_conv_k7_r2puppet_8u_impls[index_a];
    volk_8u_conv_k7_r2puppet_8u_u = get_machine()->volk_8u_conv_k7_r2puppet_8u_impls[index_u];

    assert(volk_8u_conv_k7_r2puppet_8u_a);
    assert(volk_8u_conv_k7_r2puppet_8u_u);

    volk_8u_conv_k7_r2puppet_8u = &__volk_8u_conv_k7_r2puppet_8u_d;
}

static inline void __volk_8u_conv_k7_r2puppet_8u_a(unsigned char*  dec, unsigned char*  syms, unsigned int  framebits)
{
    __init_volk_8u_conv_k7_r2puppet_8u();
    volk_8u_conv_k7_r2puppet_8u_a(dec, syms, framebits);
}

static inline void __volk_8u_conv_k7_r2puppet_8u_u(unsigned char*  dec, unsigned char*  syms, unsigned int  framebits)
{
    __init_volk_8u_conv_k7_r2puppet_8u();
    volk_8u_conv_k7_r2puppet_8u_u(dec, syms, framebits);
}

static inline void __volk_8u_conv_k7_r2puppet_8u(unsigned char*  dec, unsigned char*  syms, unsigned int  framebits)
{
    __init_volk_8u_conv_k7_r2puppet_8u();
    volk_8u_conv_k7_r2puppet_8u(dec, syms, framebits);
}

p_8u_conv_k7_r2puppet_8u volk_8u_conv_k7_r2puppet_8u_a = &__volk_8u_conv_k7_r2puppet_8u_a;
p_8u_conv_k7_r2puppet_8u volk_8u_conv_k7_r2puppet_8u_u = &__volk_8u_conv_k7_r2puppet_8u_u;
p_8u_conv_k7_r2puppet_8u volk_8u_conv_k7_r2puppet_8u   = &__volk_8u_conv_k7_r2puppet_8u;

void volk_8u_conv_k7_r2puppet_8u_manual(unsigned char*  dec, unsigned char*  syms, unsigned int  framebits, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_8u_conv_k7_r2puppet_8u_impl_names,
        get_machine()->volk_8u_conv_k7_r2puppet_8u_n_impls,
        impl_name
    );
    get_machine()->volk_8u_conv_k7_r2puppet_8u_impls[index](
        dec, syms, framebits
    );
}

volk_func_desc_t volk_8u_conv_k7_r2puppet_8u_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_8u_conv_k7_r2puppet_8u_impl_names;
    const int *impl_deps = get_machine()->volk_8u_conv_k7_r2puppet_8u_impl_deps;
    const bool *alignment = get_machine()->volk_8u_conv_k7_r2puppet_8u_impl_alignment;
    const size_t n_impls = get_machine()->volk_8u_conv_k7_r2puppet_8u_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_8u_x2_encodeframepolar_8u_d(unsigned char*  frame, unsigned char*  temp, unsigned int  frame_size)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(frame,
        VOLK_OR_PTR(temp,
        0))
    )){
        volk_8u_x2_encodeframepolar_8u_a(frame, temp, frame_size);
    }
    else{
        volk_8u_x2_encodeframepolar_8u_u(frame, temp, frame_size);
    }
}

static inline void __init_volk_8u_x2_encodeframepolar_8u(void)
{
    const char *name = get_machine()->volk_8u_x2_encodeframepolar_8u_name;
    const char **impl_names = get_machine()->volk_8u_x2_encodeframepolar_8u_impl_names;
    const int *impl_deps = get_machine()->volk_8u_x2_encodeframepolar_8u_impl_deps;
    const bool *alignment = get_machine()->volk_8u_x2_encodeframepolar_8u_impl_alignment;
    const size_t n_impls = get_machine()->volk_8u_x2_encodeframepolar_8u_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_8u_x2_encodeframepolar_8u_a = get_machine()->volk_8u_x2_encodeframepolar_8u_impls[index_a];
    volk_8u_x2_encodeframepolar_8u_u = get_machine()->volk_8u_x2_encodeframepolar_8u_impls[index_u];

    assert(volk_8u_x2_encodeframepolar_8u_a);
    assert(volk_8u_x2_encodeframepolar_8u_u);

    volk_8u_x2_encodeframepolar_8u = &__volk_8u_x2_encodeframepolar_8u_d;
}

static inline void __volk_8u_x2_encodeframepolar_8u_a(unsigned char*  frame, unsigned char*  temp, unsigned int  frame_size)
{
    __init_volk_8u_x2_encodeframepolar_8u();
    volk_8u_x2_encodeframepolar_8u_a(frame, temp, frame_size);
}

static inline void __volk_8u_x2_encodeframepolar_8u_u(unsigned char*  frame, unsigned char*  temp, unsigned int  frame_size)
{
    __init_volk_8u_x2_encodeframepolar_8u();
    volk_8u_x2_encodeframepolar_8u_u(frame, temp, frame_size);
}

static inline void __volk_8u_x2_encodeframepolar_8u(unsigned char*  frame, unsigned char*  temp, unsigned int  frame_size)
{
    __init_volk_8u_x2_encodeframepolar_8u();
    volk_8u_x2_encodeframepolar_8u(frame, temp, frame_size);
}

p_8u_x2_encodeframepolar_8u volk_8u_x2_encodeframepolar_8u_a = &__volk_8u_x2_encodeframepolar_8u_a;
p_8u_x2_encodeframepolar_8u volk_8u_x2_encodeframepolar_8u_u = &__volk_8u_x2_encodeframepolar_8u_u;
p_8u_x2_encodeframepolar_8u volk_8u_x2_encodeframepolar_8u   = &__volk_8u_x2_encodeframepolar_8u;

void volk_8u_x2_encodeframepolar_8u_manual(unsigned char*  frame, unsigned char*  temp, unsigned int  frame_size, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_8u_x2_encodeframepolar_8u_impl_names,
        get_machine()->volk_8u_x2_encodeframepolar_8u_n_impls,
        impl_name
    );
    get_machine()->volk_8u_x2_encodeframepolar_8u_impls[index](
        frame, temp, frame_size
    );
}

volk_func_desc_t volk_8u_x2_encodeframepolar_8u_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_8u_x2_encodeframepolar_8u_impl_names;
    const int *impl_deps = get_machine()->volk_8u_x2_encodeframepolar_8u_impl_deps;
    const bool *alignment = get_machine()->volk_8u_x2_encodeframepolar_8u_impl_alignment;
    const size_t n_impls = get_machine()->volk_8u_x2_encodeframepolar_8u_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_8u_x3_encodepolar_8u_x2_d(unsigned char*  frame, unsigned char*  temp, const unsigned char*  frozen_bit_mask, const unsigned char*  frozen_bits, const unsigned char*  info_bits, unsigned int  frame_size)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(frame,
        VOLK_OR_PTR(temp,
        VOLK_OR_PTR(frozen_bit_mask,
        VOLK_OR_PTR(frozen_bits,
        VOLK_OR_PTR(info_bits,
        0)))))
    )){
        volk_8u_x3_encodepolar_8u_x2_a(frame, temp, frozen_bit_mask, frozen_bits, info_bits, frame_size);
    }
    else{
        volk_8u_x3_encodepolar_8u_x2_u(frame, temp, frozen_bit_mask, frozen_bits, info_bits, frame_size);
    }
}

static inline void __init_volk_8u_x3_encodepolar_8u_x2(void)
{
    const char *name = get_machine()->volk_8u_x3_encodepolar_8u_x2_name;
    const char **impl_names = get_machine()->volk_8u_x3_encodepolar_8u_x2_impl_names;
    const int *impl_deps = get_machine()->volk_8u_x3_encodepolar_8u_x2_impl_deps;
    const bool *alignment = get_machine()->volk_8u_x3_encodepolar_8u_x2_impl_alignment;
    const size_t n_impls = get_machine()->volk_8u_x3_encodepolar_8u_x2_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_8u_x3_encodepolar_8u_x2_a = get_machine()->volk_8u_x3_encodepolar_8u_x2_impls[index_a];
    volk_8u_x3_encodepolar_8u_x2_u = get_machine()->volk_8u_x3_encodepolar_8u_x2_impls[index_u];

    assert(volk_8u_x3_encodepolar_8u_x2_a);
    assert(volk_8u_x3_encodepolar_8u_x2_u);

    volk_8u_x3_encodepolar_8u_x2 = &__volk_8u_x3_encodepolar_8u_x2_d;
}

static inline void __volk_8u_x3_encodepolar_8u_x2_a(unsigned char*  frame, unsigned char*  temp, const unsigned char*  frozen_bit_mask, const unsigned char*  frozen_bits, const unsigned char*  info_bits, unsigned int  frame_size)
{
    __init_volk_8u_x3_encodepolar_8u_x2();
    volk_8u_x3_encodepolar_8u_x2_a(frame, temp, frozen_bit_mask, frozen_bits, info_bits, frame_size);
}

static inline void __volk_8u_x3_encodepolar_8u_x2_u(unsigned char*  frame, unsigned char*  temp, const unsigned char*  frozen_bit_mask, const unsigned char*  frozen_bits, const unsigned char*  info_bits, unsigned int  frame_size)
{
    __init_volk_8u_x3_encodepolar_8u_x2();
    volk_8u_x3_encodepolar_8u_x2_u(frame, temp, frozen_bit_mask, frozen_bits, info_bits, frame_size);
}

static inline void __volk_8u_x3_encodepolar_8u_x2(unsigned char*  frame, unsigned char*  temp, const unsigned char*  frozen_bit_mask, const unsigned char*  frozen_bits, const unsigned char*  info_bits, unsigned int  frame_size)
{
    __init_volk_8u_x3_encodepolar_8u_x2();
    volk_8u_x3_encodepolar_8u_x2(frame, temp, frozen_bit_mask, frozen_bits, info_bits, frame_size);
}

p_8u_x3_encodepolar_8u_x2 volk_8u_x3_encodepolar_8u_x2_a = &__volk_8u_x3_encodepolar_8u_x2_a;
p_8u_x3_encodepolar_8u_x2 volk_8u_x3_encodepolar_8u_x2_u = &__volk_8u_x3_encodepolar_8u_x2_u;
p_8u_x3_encodepolar_8u_x2 volk_8u_x3_encodepolar_8u_x2   = &__volk_8u_x3_encodepolar_8u_x2;

void volk_8u_x3_encodepolar_8u_x2_manual(unsigned char*  frame, unsigned char*  temp, const unsigned char*  frozen_bit_mask, const unsigned char*  frozen_bits, const unsigned char*  info_bits, unsigned int  frame_size, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_8u_x3_encodepolar_8u_x2_impl_names,
        get_machine()->volk_8u_x3_encodepolar_8u_x2_n_impls,
        impl_name
    );
    get_machine()->volk_8u_x3_encodepolar_8u_x2_impls[index](
        frame, temp, frozen_bit_mask, frozen_bits, info_bits, frame_size
    );
}

volk_func_desc_t volk_8u_x3_encodepolar_8u_x2_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_8u_x3_encodepolar_8u_x2_impl_names;
    const int *impl_deps = get_machine()->volk_8u_x3_encodepolar_8u_x2_impl_deps;
    const bool *alignment = get_machine()->volk_8u_x3_encodepolar_8u_x2_impl_alignment;
    const size_t n_impls = get_machine()->volk_8u_x3_encodepolar_8u_x2_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_8u_x3_encodepolarpuppet_8u_d(unsigned char*  frame, unsigned char*  frozen_bit_mask, const unsigned char*  frozen_bits, const unsigned char*  info_bits, unsigned int  frame_size)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(frame,
        VOLK_OR_PTR(frozen_bit_mask,
        VOLK_OR_PTR(frozen_bits,
        VOLK_OR_PTR(info_bits,
        0))))
    )){
        volk_8u_x3_encodepolarpuppet_8u_a(frame, frozen_bit_mask, frozen_bits, info_bits, frame_size);
    }
    else{
        volk_8u_x3_encodepolarpuppet_8u_u(frame, frozen_bit_mask, frozen_bits, info_bits, frame_size);
    }
}

static inline void __init_volk_8u_x3_encodepolarpuppet_8u(void)
{
    const char *name = get_machine()->volk_8u_x3_encodepolarpuppet_8u_name;
    const char **impl_names = get_machine()->volk_8u_x3_encodepolarpuppet_8u_impl_names;
    const int *impl_deps = get_machine()->volk_8u_x3_encodepolarpuppet_8u_impl_deps;
    const bool *alignment = get_machine()->volk_8u_x3_encodepolarpuppet_8u_impl_alignment;
    const size_t n_impls = get_machine()->volk_8u_x3_encodepolarpuppet_8u_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_8u_x3_encodepolarpuppet_8u_a = get_machine()->volk_8u_x3_encodepolarpuppet_8u_impls[index_a];
    volk_8u_x3_encodepolarpuppet_8u_u = get_machine()->volk_8u_x3_encodepolarpuppet_8u_impls[index_u];

    assert(volk_8u_x3_encodepolarpuppet_8u_a);
    assert(volk_8u_x3_encodepolarpuppet_8u_u);

    volk_8u_x3_encodepolarpuppet_8u = &__volk_8u_x3_encodepolarpuppet_8u_d;
}

static inline void __volk_8u_x3_encodepolarpuppet_8u_a(unsigned char*  frame, unsigned char*  frozen_bit_mask, const unsigned char*  frozen_bits, const unsigned char*  info_bits, unsigned int  frame_size)
{
    __init_volk_8u_x3_encodepolarpuppet_8u();
    volk_8u_x3_encodepolarpuppet_8u_a(frame, frozen_bit_mask, frozen_bits, info_bits, frame_size);
}

static inline void __volk_8u_x3_encodepolarpuppet_8u_u(unsigned char*  frame, unsigned char*  frozen_bit_mask, const unsigned char*  frozen_bits, const unsigned char*  info_bits, unsigned int  frame_size)
{
    __init_volk_8u_x3_encodepolarpuppet_8u();
    volk_8u_x3_encodepolarpuppet_8u_u(frame, frozen_bit_mask, frozen_bits, info_bits, frame_size);
}

static inline void __volk_8u_x3_encodepolarpuppet_8u(unsigned char*  frame, unsigned char*  frozen_bit_mask, const unsigned char*  frozen_bits, const unsigned char*  info_bits, unsigned int  frame_size)
{
    __init_volk_8u_x3_encodepolarpuppet_8u();
    volk_8u_x3_encodepolarpuppet_8u(frame, frozen_bit_mask, frozen_bits, info_bits, frame_size);
}

p_8u_x3_encodepolarpuppet_8u volk_8u_x3_encodepolarpuppet_8u_a = &__volk_8u_x3_encodepolarpuppet_8u_a;
p_8u_x3_encodepolarpuppet_8u volk_8u_x3_encodepolarpuppet_8u_u = &__volk_8u_x3_encodepolarpuppet_8u_u;
p_8u_x3_encodepolarpuppet_8u volk_8u_x3_encodepolarpuppet_8u   = &__volk_8u_x3_encodepolarpuppet_8u;

void volk_8u_x3_encodepolarpuppet_8u_manual(unsigned char*  frame, unsigned char*  frozen_bit_mask, const unsigned char*  frozen_bits, const unsigned char*  info_bits, unsigned int  frame_size, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_8u_x3_encodepolarpuppet_8u_impl_names,
        get_machine()->volk_8u_x3_encodepolarpuppet_8u_n_impls,
        impl_name
    );
    get_machine()->volk_8u_x3_encodepolarpuppet_8u_impls[index](
        frame, frozen_bit_mask, frozen_bits, info_bits, frame_size
    );
}

volk_func_desc_t volk_8u_x3_encodepolarpuppet_8u_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_8u_x3_encodepolarpuppet_8u_impl_names;
    const int *impl_deps = get_machine()->volk_8u_x3_encodepolarpuppet_8u_impl_deps;
    const bool *alignment = get_machine()->volk_8u_x3_encodepolarpuppet_8u_impl_alignment;
    const size_t n_impls = get_machine()->volk_8u_x3_encodepolarpuppet_8u_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}



static inline void __volk_8u_x4_conv_k7_r2_8u_d(unsigned char*  Y, unsigned char*  X, unsigned char*  syms, unsigned char*  dec, unsigned int  framebits, unsigned int  excess, unsigned char*  Branchtab)
{

    if (volk_is_aligned(
        VOLK_OR_PTR(Y,
        VOLK_OR_PTR(X,
        VOLK_OR_PTR(syms,
        VOLK_OR_PTR(dec,
        VOLK_OR_PTR(Branchtab,
        0)))))
    )){
        volk_8u_x4_conv_k7_r2_8u_a(Y, X, syms, dec, framebits, excess, Branchtab);
    }
    else{
        volk_8u_x4_conv_k7_r2_8u_u(Y, X, syms, dec, framebits, excess, Branchtab);
    }
}

static inline void __init_volk_8u_x4_conv_k7_r2_8u(void)
{
    const char *name = get_machine()->volk_8u_x4_conv_k7_r2_8u_name;
    const char **impl_names = get_machine()->volk_8u_x4_conv_k7_r2_8u_impl_names;
    const int *impl_deps = get_machine()->volk_8u_x4_conv_k7_r2_8u_impl_deps;
    const bool *alignment = get_machine()->volk_8u_x4_conv_k7_r2_8u_impl_alignment;
    const size_t n_impls = get_machine()->volk_8u_x4_conv_k7_r2_8u_n_impls;
    const size_t index_a = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, true/*aligned*/);
    const size_t index_u = volk_rank_archs(name, impl_names, impl_deps, alignment, n_impls, false/*unaligned*/);
    volk_8u_x4_conv_k7_r2_8u_a = get_machine()->volk_8u_x4_conv_k7_r2_8u_impls[index_a];
    volk_8u_x4_conv_k7_r2_8u_u = get_machine()->volk_8u_x4_conv_k7_r2_8u_impls[index_u];

    assert(volk_8u_x4_conv_k7_r2_8u_a);
    assert(volk_8u_x4_conv_k7_r2_8u_u);

    volk_8u_x4_conv_k7_r2_8u = &__volk_8u_x4_conv_k7_r2_8u_d;
}

static inline void __volk_8u_x4_conv_k7_r2_8u_a(unsigned char*  Y, unsigned char*  X, unsigned char*  syms, unsigned char*  dec, unsigned int  framebits, unsigned int  excess, unsigned char*  Branchtab)
{
    __init_volk_8u_x4_conv_k7_r2_8u();
    volk_8u_x4_conv_k7_r2_8u_a(Y, X, syms, dec, framebits, excess, Branchtab);
}

static inline void __volk_8u_x4_conv_k7_r2_8u_u(unsigned char*  Y, unsigned char*  X, unsigned char*  syms, unsigned char*  dec, unsigned int  framebits, unsigned int  excess, unsigned char*  Branchtab)
{
    __init_volk_8u_x4_conv_k7_r2_8u();
    volk_8u_x4_conv_k7_r2_8u_u(Y, X, syms, dec, framebits, excess, Branchtab);
}

static inline void __volk_8u_x4_conv_k7_r2_8u(unsigned char*  Y, unsigned char*  X, unsigned char*  syms, unsigned char*  dec, unsigned int  framebits, unsigned int  excess, unsigned char*  Branchtab)
{
    __init_volk_8u_x4_conv_k7_r2_8u();
    volk_8u_x4_conv_k7_r2_8u(Y, X, syms, dec, framebits, excess, Branchtab);
}

p_8u_x4_conv_k7_r2_8u volk_8u_x4_conv_k7_r2_8u_a = &__volk_8u_x4_conv_k7_r2_8u_a;
p_8u_x4_conv_k7_r2_8u volk_8u_x4_conv_k7_r2_8u_u = &__volk_8u_x4_conv_k7_r2_8u_u;
p_8u_x4_conv_k7_r2_8u volk_8u_x4_conv_k7_r2_8u   = &__volk_8u_x4_conv_k7_r2_8u;

void volk_8u_x4_conv_k7_r2_8u_manual(unsigned char*  Y, unsigned char*  X, unsigned char*  syms, unsigned char*  dec, unsigned int  framebits, unsigned int  excess, unsigned char*  Branchtab, const char* impl_name)
{
    const int index = volk_get_index(
        get_machine()->volk_8u_x4_conv_k7_r2_8u_impl_names,
        get_machine()->volk_8u_x4_conv_k7_r2_8u_n_impls,
        impl_name
    );
    get_machine()->volk_8u_x4_conv_k7_r2_8u_impls[index](
        Y, X, syms, dec, framebits, excess, Branchtab
    );
}

volk_func_desc_t volk_8u_x4_conv_k7_r2_8u_get_func_desc(void) {
    const char **impl_names = get_machine()->volk_8u_x4_conv_k7_r2_8u_impl_names;
    const int *impl_deps = get_machine()->volk_8u_x4_conv_k7_r2_8u_impl_deps;
    const bool *alignment = get_machine()->volk_8u_x4_conv_k7_r2_8u_impl_alignment;
    const size_t n_impls = get_machine()->volk_8u_x4_conv_k7_r2_8u_n_impls;
    volk_func_desc_t desc = {
        impl_names,
        impl_deps,
        alignment,
        n_impls
    };
    return desc;
}

